#!/bin/sh
# static_modules.c.SH: Generates our static module list
# $Id: static_modules.c.SH 21564 2006-01-04 19:42:17Z leeh $
#
SYMS=`for x in $*; do basename $x .c; done`
cat > static_modules.c <<EOF
/*
 *  This file is automatically generated: do not modify
 *  ircd-ratbox: A slightly useful ircd
 *
 *  Copyright (C) 2003,2008 Aaron Sethman <androsyn@ratbox.org>
 *  Copyright (C) 2003-2005,2008 ircd-ratbox development team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *  USA
 *  
 */
#include "stdinc.h"
#include "modules.h"
#include "hash.h"
#include "s_log.h"

EOF

for x in $SYMS; do 
	echo extern struct mapi_header_av1 "$x"_mheader\;
done >> static_modules.c


echo const struct mapi_header_av1 *static_mapi_headers[] = { >> static_modules.c 
for x in $SYMS; do 
	echo \&"$x"_mheader,
done >> static_modules.c

echo NULL }\; >> static_modules.c

cat >> static_modules.c <<EOF
