ITK Release 4.11
================

New Features

------------------------------------------------------------------------

-   Wrapping Improvements

` - Python GetArrayFromImage() and GetImageFromArray() from ITKBridgeNumPy are directly accessible from the Python itk namespace.`\
` - The itk package loads much faster: individual modules are loaded only when required.`\
` - Conversion of ITK images from and to NumPy array using Bridge NumPy supports RGB, RGBA, and Vector images.`\
` - VNL vectors and VNL matrices can be converted from and to NumPy objects with respectively the new couple of functions GetArrayFromVnlVector()/GetVnlVectorFromArray() and GetArrayFromVnlMatrix()/GetVnlMatrixFromArray()`\
` - The global timestamp is used across all ITK Python modules when built statically`\
` - Wrap additional classes such as KernelFunctionBase`\
` - itk_python_add_test CMake function added for Python script testing in ITK modules`

-   New Remote Modules

` - DVMeshNoise`\
`   - Perturbing mesh vertices with additive gaussian noise`\
`   - `[`https://hdl.handle.net/10380/3567`](https://hdl.handle.net/10380/3567)\
` - PerformanceBenchmarking`\
`   - Accurate benchmarking of computational performance`\
`   - `[`https://hdl.handle.net/10380/3557`](https://hdl.handle.net/10380/3557)\
` - PrincipalComponentsAnalysis`\
`   - Principal components analysis of scalar, vector, and mesh vertex data`\
`   - `[`https://hdl.handle.net/10380/3386`](https://hdl.handle.net/10380/3386)\
` - RLEImage`\
`   - Run-length encoded memory compression scheme for itk::Image`\
`   - `[`https://hdl.handle.net/10380/3562`](https://hdl.handle.net/10380/3562)\
` - MorphologicalContourInterpolation`\
`   - N-D morphological contour interpolation`\
`   - `[`https://hdl.handle.net/10380/3563`](https://hdl.handle.net/10380/3563)\
` - GenericLabelInterpolator`\
`   - A generic interpolator for multi-label images`\
`   - `[`https://hdl.handle.net/10380/3506`](https://hdl.handle.net/10380/3506)\
` - MultipleImageIterator`\
`   - Iterate over multiple images simultaneously`\
`   - `[`https://hdl.handle.net/10380/3455`](https://hdl.handle.net/10380/3455)\
` - FixedPointInverseDisplacementField`\
`  - Computes inverse displacement field`\
`  - `[`https://hdl.handle.net/10380/3222`](https://hdl.handle.net/10380/3222)

-   Core Improvements

` - New ITK_TEMPLATE_EXPORT for templated classes resolves cross-binary dynamic_cast on Mac OSX`\
` - New MersenneTwisterRandomVariateGenerator instances are initialized with different seeds`\
` - Use compiler feature detection in CMake for C++11 features, etc.`\
` - New CMake macro itk_module_add_library for creating libraries in ITK modules`\
` - Improved support for ccache and distcc with CMAKE_`<LANG>`_COMPILER_LAUNCHER (CMake >=3.4 required)`\
` - Support for .sha512 ExternalData content links`\
` - GitHub Pages and data.kitware.com ExternalData repositories added`\
` - GPGPU system support for C++11`\
` - Support of new compilers: Visual Studio 15 and XCode 8.2.1 (clang-800.0.42.1)`

-   Filtering Improvements

` - HessianToObjectnessMeasure moved out of the ITKReview module`\
` - New UnsharpMaskImageFilter for image edge enhancement`

-   IO Improvements

` - TransformFactory class has been moved to a separate module`\
` - Spline order added to BSplineTransform identifier`\
` - Improved NIFTI orientation support`

-   Documentation Improvements

` - Updates to the Software Guide, Doxygen, Wiki and Sphinx Examples`

-   Third Party Library Updates

` - pygccxml updated to v1.8.0`\
` - VNL updated to latest upstream (2016.07.06)`\
` - SWIG updated to v3.0.11`\
` - KWSys updated to latest upstream (2016.11.21)`\
` - HDF5 updated to v1.8.17`\
` - SCIFIO updated to latest upstream (2016.12.01)`\
` - DCMTK updated to 3.6.1_20121012`\
` - CastXML to latest upstream (2016.01.28)`

-   Improved Code Coverage -- we are at 85.44%!

` - Jon Haitz-Legarreta's extensive code coverage improvements`\
` - `[`https://blog.kitware.com/why-should-we-spend-time-writing-tests/`](https://blog.kitware.com/why-should-we-spend-time-writing-tests/)

Changes from v4.11rc02 to v4.11.0

------------------------------------------------------------------------

Bradley Lowekamp (3):

`     BUG: Add itk prefix to TIFF files in binary directory.`\
`     BUG: Remove ITK_DISALLOW_COPY_AND_ASSIGN as Doxygen private`\
`     BUG: First IterationEvent is at CurrentIteration==0`

Francois Budin (3):

`     ENH: Update SCIFIO to latest revision (2017.01.17)`\
`     ENH: Update SCIFIO to lastest commit (01.21.2017)`\
`     BUG: Alpha value created when converted image to RGBA is not always 1`

Jon Haitz Legarreta (2):

`     BUG: Fix uninitialized variables in itkGaussianInterpolateImageFunction.`\
`     BUG: Fix RTTI Superclass name in itkLabelMapMaskImageFilter.`

Matthew McCormick (2):

`     BUG: Fix cat/echo in ContentLinkSynchronization.sh`\
`     ENH: Add missing SHA512 content links`

Richard Beare (1):

`     BUG: Fix precision issues with poly-line FlatStructuring element`

Stephen Aylward (1):

`     BUG: Target file for modules moved to subdir Targets.`

Changes from v4.11rc01 to v4.11rc02

------------------------------------------------------------------------

Bradley Lowekamp (5):

`     BUG: Remove unused SimpleImageRegistrationTest baselines`\
`     ENH: Expose GetNextSeed method in MersenneTwiseter Generator`\
`     BUG: Add option for fixed seed or wall clock seed for sampling`\
`     BUG: Use metric random seed in v3 examples`\
`     BUG: Prefer setting seed at algorithm in `“`v4`”` tests.`

Francois Budin (3):

`     ENH: Update BridgeNumPy to latest version on 2017.01.08 to address ITK-3511`\
`     BUG: Extra \$ in doxygen comment`\
`     BUG: Binary include directory added only if enabled shared`

Jon Haitz Legarreta (2):

`     DOC: Document itkLabelOverlapMeasuresImageFilter methods.`\
`     DOC: Fix ITKImageNoise filters' doc TeX errors.`

Matthew McCormick (1):

`     BUG: Remove invalid ImageRegistration4Test.png.sha512`

Max Smolens (1):

`     DOC: Fix itkUnsharpMaskImageFilter documentation typos`

Simon Rit (1):

`     BUG: ITK-based software was crasing when thread creation failed`

Changes from v4.10.0 to v4.11rc01

------------------------------------------------------------------------

Bill Lorensen (4):

`     COMP: Restore support for clang 3.0 compiler`\
`     COMP: Consistent use of ModifiedTimeType`\
`     ENH: Bump WikiExamples remote module version`\
`     ENH: Bump WikiExamples version`

Bradley Lowekamp (57):

`     ENH: Add registered TrasformIO's to exception`\
`     ENH: Use template or constant for loop stop condition`\
`     ENH: Updating SWIG version to 3.0.9`\
`     COMP: Address VS9 ambiguous std::abs call in Haung calculator`\
`     COMP: Fix undefined NumericTraits::Zero and One errors with mingw64`\
`     BUG: Fix segfault if ~CleanUpObjectFactory called multiple times`\
`     BUG: Address itkHDF5ImageIO test failures for mingw64`\
`     BUG: demonstrate dynamic_cast failure when reading transforms`\
`     BUG: Address itkHDF5ImageIO test failures for mingw64`\
`     ENH: Updating SWIG version to 3.0.10`\
`     ENH: Enable CMP0063 New behavior`\
`     COMP: Enable hidden visibility property with vxl static libraries`\
`     COMP: Enable hidden visibility property with HDF5 static libraries`\
`     COMP: Enable hidden visibility property with HDF5 static libraries`\
`     BUG: Match Add2 function to AddImageFilter documentation`\
`     ENH: Improve support for std::complex with PowImageFilter`\
`     ENH: Explicitly mark required files for dependent tests`\
`     COMP: Bypass XCode 7.3,8 internal compilation error`\
`     COMP: Address CMake configuration error with itkJPEG2000Test03 property`\
`     BUG: Correct test's REQUIRED_FILES to only the input.`\
`     ENH: move HessianToObjectnessMeasure filter out of Review`\
`     ENH: Separate TransformFactory class into separate module`\
`     DOC: Add links between similar label to rgb filters`\
`     ENH: Separate data from function calls`\
`     COMP: Fix changed Graft method`\
`     ENH: Reduce template dependencies on CalculateRotationMatrix`\
`     ENH: Add Functor Accessors to LabelMapToRGB filter`\
`     BUG: Enable VirtualDomain and FixedTransform in RegMethv4`\
`     BUG: Use BSpline Order 3 for 2D in transform factory.`\
`     ENH: Add spline order to BSplineTransform's string id`\
`     ENH: Adding initial CircleCi configuration file`\
`     COMP: Fix float to unsigned integer conversion warnings`\
`     BUG: Include installed modules in ITK_MODULES_ENABLED`\
`     COMP: Address CMake error that ITKGPUCommon is not in export`\
`     COMP: Address wrong library types with VS and shared libraries`\
`     BUG: Ensure CreateImageIO is concurrent thread safe`\
`     ENH: Mark HDF5 CMake options as internal`\
`     COMP: Add template export declaration for ParametricPath`\
`     COMP: Correct TEMPLATE_EXPLICIT definition in Path module`\
`     ENH: Factor out common code in the TrasformFactoryBase registration`\
`     ENH: Add CMake variable for max transform dimension, defaults 4`\
`     ENH: Create CMake module to check for private RTTI compatibility`\
`     ENH: Improving setting of default ITK_TEMPATE_VISIBILITY_DEFAULT`\
`     COMP: Correct ifndef value to allow user defined ITK_TEMPLATE_EXPORT`\
`     BUG: Add explicit instantiate for ObjectToObjectOptimizerBase`\
`     COMP: Use add_definitions for CMake 2.8.9 compatibility`\
`     COMP: Add warning suppression for distcc warning`\
`     ENH: Explicitly instantiate the optimizer base over float`\
`     BUG: Use IsLinear to check if transform is `“`affine`”\
`     ENH: Remove unneeded includes of random iterator header`\
`     ENH: Improve thread-safety for Generator, and unique New sequence`\
`     ENH: Do not use global random generator`\
`     BUG: Update v3 registration metrics to use local seed`\
`     ENH: Prefer setting local seed over global in tests.`\
`     ENH: Update SWIG to latest 3.0.11 release`\
`     BUG: relax testing parameters for v3 translation registration`\
`     BUG: Restore baseline for debug registration`

Caspar Goch (2):

`     BUG: Use printable type for RGBA pixel ostream for ITK-3501`\
`     STYLE: Remove extra space for ITK-3501`

Christina Rossmanith (1):

`     DOC: Added more details to the class Doxygen documentation.`

Davis Vigneault (2):

`     COMP: VCL_DEFINE_SPECIALIZATION not defined`\
`     ENH: Add remote module DVMeshNoise`

Dženan Zukić (27):

`     BUG: Fixing CID-1355433 (IDENTICAL_BRANCHES)`\
`     ENH: Adding MultipleImageIterator as a remote module`\
`     COMP: enables TBB 4.4 back-end for VTK7's SMP`\
`     COMP: enabling position independent code flag for FFTW`\
`     ENH: adding configuration file for code reformatting tool clang-format`\
`     ENH: Updating hooks to work with Windows/TortoiseGit/KDiff3`\
`     COMP: Fixing -fPIC flag passing with Ninja build system`\
`     ENH: Adding RLEImage as a remote module`\
`     ENH: Updating uncrustify configuration to current git version`\
`     STYLE: better compliance with ITK style`\
`     STYLE: A new option in uncrustify, updating the config file accordingly`\
`     ENH: Adding MorphologicalContourInterpolation as a remote module`\
`     ENH: improving documentation`\
`     BUG: fixing buffer growing endlessly, as reported by Timothee Evain`\
`     BUG: fixing buffer growing endlessly, as reported by Timothee Evain`\
`     STYLE: default uncrustify configuration file is less aggressive`\
`     COMP: Fixing warning`\
`     COMP: VS15 compiler fix`\
`     BUG: casting -9 to unsigned produced unwanted result`\
`     BUG: Ensuring consistency between debug and release`\
`     COMP: Updating LesionSizingToolkit after some recent compile fixes`\
`     COMP: respect option METAIO_USE_NAMESPACE`\
`     ENH: updating version of AnisotropicDiffusionLBR`\
`     ENH: adding UnsharpMaskingImageFilter`\
`     COMP: explicitly cast to output type`\
`     BUG: double call to update would cause empty output image`\
`     ENH: Updating RLEImage remote module. Change-log:`

Eugene Prilepin (4):

`     ENH: Add the `“`ITK_USE_GPU`”` to ITK Config`\
`     BUG: Fix API for set/get `“`LaplacianImageFilter`”` object`\
`     ENH: Add support of images types with the 'CovariantVector' pixel type`\
`     ENH: Add python test for the 'GradientVectorFlowImageFilter' wrap`

Francois Budin (52):

`     ENH: Adding GetArrayFromImage in python itk namespace`\
`     ENH: Adding GetImageFromArray in python itk namespace`\
`     ENH: *_WRAP_* variable per external module`\
`     BUG: ImportImageFilter not responsible of memory management`\
`     ENH: New remote module GenericLabelInterpolator`\
`     DOC: SetNumberOfOutputs had wrong comment`\
`     BUG: lazyAttributes dictionary keys could be over-ridden`\
`     BUG: lazyAttributes dictionary keys could be over-ridden`\
`     BUG: Fix recent update of HDF5 (1.8.17)`\
`     ENH: Update SCIFIO to latest version on 08/23/2016`\
`     ENH: Addition of the remote module FixedPointInverseDisplacementField`\
`     ENH: Update SCIFIO to latest version on 08/29/2016`\
`     BUG: Path to commit was relative instead of absolute`\
`     ENH: Path to SetupForDevelopment is relative, not absolute`\
`     BUG: LSMImageIO write function was not checking image dimension`\
`     BUG: LSMImageIO was not checking correctly image dimension`\
`     BUG: Missing associated test data`\
`     BUG: Missing associated test data`\
`     ENH: Bump CMakeLists.txt version to 4.10.1.`\
`     BUG: Quotes are not escaped in configured cmake file`\
`     ENH: Improving API of Graft() in itk::Image`\
`     ENH: Updating ITKGenericLabelInterpolator remote module`\
`     ENH: Update ITKIOTransformDCMTK remote module`\
`     BUG: Factory registration should depend on ITK_BUILD_SHARED`\
`     COMP: Updating DCMTK compilation for Ninja`\
`     ENH: Update version of DCMTK to 3.6.1_20121012`\
`     ENH: Update SCIFIO to latest version on 10/25/2016`\
`     BUG: Swig and PCRE do not support space in installation paths`\
`     BUG: exit() call from within piped commands was not exiting the script`\
`     BUG: Typo in folder creation command`\
`     ENH: Only display message for transform registered multiple times in debug`\
`     ENH: Image spacing must be positive`\
`     BUG: Supported extensions by PNG IO were not added in constructor.`\
`     DOC: Documentation in itkRBGAPixel and itkRGBPixel was incorrect.`\
`     ENH: Update SCIFIO to lastest (2016.12.01)`\
`     ENH: FixedPointInverseDisplacementField moved to InsightSoftwareConsortium`\
`     COMP: Remove compilation warnings`\
`     ENH: Improved support of ccache and distcc`\
`     BUG: GPUImage regression due to API change.`\
`     ENH: Update Bridge Numpy (2016.12.05)`\
`     ENH: Update VariationalRegistration to remove warnings during compilation`\
`     ENH: FindPythonLibs does not support both debug and release python libraries`\
`     ENH: Update VariationalRegistration`\
`     BUG: Missing ITK_TEMPLATE_EXPORT in forward declaration of itk::ImageBase`\
`     BUG: Missing ITK_TEMPLATE_EXPORT in itkOptimizerParametersHelper`\
`     BUG: Missing ITK_TEMPLATE_EXPORT in templated class`\
`     BUG: Remove linkage warnings on MacOS`\
`     BUG: HDF5 CMake installation directory variable had not been updated`\
`     BUG: Missing include header in AnisotropicDiffusionBLR remote module hxx files`\
`     COMP: Silencing unused variable warning in itkTimeStamp`\
`     STYLE: Improve style checking by using module ITKKWStyleOverwrite.txt`\
`     COMP: OS*Barrier functions are deprecated on MacOS 10.12`

GCC-XML Upstream (1):

`     ENH: pygccxml v1.8.0 (reduced)`

Gert Wollny (1):

`     BUG: Relax vnl_complex floating point comparisons for i386`

Gilles Filippini (1):

`     BUG: Use NATIVE_HBOOL for encoding HDF5 types.`

HDF Group (1):

`     ENH: hdf5 1.8.17-r30218 (reduced)`

Hans Johnson (23):

`     COMP: Use cmake WriteCompilerDetectionHeader`\
`     ENH: Use itk_compiler_detection versions`\
`     COMP: Need ITK_NOEXCEPT_OR_THROW macro.`\
`     COMP: Provide consistent granular C++11 support`\
`     STYLE: Use granular ITK_COMPILER_CXX_STATIC_ASSERT`\
`     STYLE: Prefer to use consistent definitions`\
`     COMP: Improve robustness of identifying the compiler standard used`\
`     BUG: try_compile for AlignAs were always failing`\
`     STYLE: Provide a well documented macro for repeated code`\
`     STYLE: Delete functions in consistent way`\
`     COMP: GPU baseclass ivars need to be protected`\
`     COMP: Remove unnecessary circular dependancy`\
`     COMP: Add long long usage for HDF5`\
`     COMP: Add long long usage for HDF5`\
`     STYLE: Prefer static small array to dynamic array`\
`     BUG: Confusing interface for FFTW wisdom files`\
`     STYLE: Output dimension from OutputImageType`\
`     STYLE: Code review style cleanups`\
`     STYLE: Prefer to use ITK AssertOrThrow macros`\
`     ENH: Add OverrideBoundaryCondition logic`\
`     ENH: Provide mechanism for enhanced NIFTI support`\
`     BUG: Use NIFTI sform/qform conventions correctly`\
`     ENH: Remove ambiguity about sform/qform`

Hastings Greer (8):

`     BUG: ITK-3448 Wrap itkQuadEdgeCellTraitsInfo more specifically`\
`     BUG: make itkTriangleHelper instantiable to ease wrapping`\
`     BUG: remove lsqr because of license issues ITK 1160`\
`     BUG: make itkTriangleHelper instantiable to ease wrapping`\
`     BUG: initialize X to zero in lsmr Solve`\
`     BUG: Labled Point Set Registration: test multiple labels`\
`     BUG: Fix python wrapping of Cuberille remote module`\
`     BUG: Add test demonstrating Python global timestamp issue`

Jean-Christophe Fillion-Robin (5):

`     STYLE: UseITK: Set ImageIO exceptions using new convention. See #3393`\
`     STYLE: MeshIO: Moves virtual destructor into cpp files. See #3393`\
`     STYLE: Update MeshIO factories to use RegisterFactoryInternal. See #3393`\
`     STYLE: MeshIO: Move MeshFileWriterException into its own file. See #3393`\
`     STYLE: MeshIO: Remove unused include from headers. See #3393`

Johan Andruejol (3):

`     ENH: Add missing itkKernelFunctionBase wrapping`\
`     ENH: Add PrincipalComponentsAnalysis remote module`\
`     COMP: Override cannot be used with inline`

Jon Haitz Legarreta (216):

`     ENH: Improve itkFlatStructutingElement coverage.`\
`     ENH: Improve itkPathToImageFilter class coverage.`\
`     ENH: Improve itkIsolatedWatershedImageFilter coverage.`\
`     ENH: Improve itkLogSigmoidTransferFunction coverage.`\
`     STYLE: Improve itkBSplineTransform doc style.`\
`     ENH: Improve GaborKernelFunctionCoverage.`\
`     PERF: Remove duplicate itkMath include`\
`     STYLE: Move the PrintSelf method to the end`\
`     STYLE: Improve the itkScalarToRGBColormapImageFilter style.`\
`     STYLE: Delete duplicate method documentation`\
`     STYLE: Remove method documentation from implementation file`\
`     STYLE: Improve GACLevelSet classes' style`\
`     STYLE: Improve test style`\
`     ENH: Improve itkGaussianDerivativeImageFilter coverage.`\
`     ENH: Improve the itkScalarToRGBColormapImageFilter coverage`\
`     STYLE: Improve itkScalarToRGBColormap test style`\
`     ENH: Improve GACLSImageFilter classes' coverage`\
`     STYLE: Improve comment style in GACLS tests`\
`     ENH: Improve itkImportImageFilter coverage`\
`     ENH: Improve itkVideoFileReader coverage`\
`     ENH: Improve itkVideoFileWriter coverage`\
`     STYLE: Improve the itkVideoFileWriter style.`\
`     STYLE: Imrpove itkVideoFileReader style.`\
`     ENH: Improve the itkBSplineControlPointImageFunction coverage`\
`     STYLE: Improve the itkIntensityWindowingImageFilter style`\
`     STYLE: Improve the itkIntensityWindowingImageFilter test style`\
`     ENH: Improve ImageToSpatialObjectRegistrationMethod coverage`\
`     STYLE: Improve test style`\
`     ENH: Improve MaskNeighborhoodOperatorImageFilter coverage`\
`     ENH: Improve itkMeshFileWriter coverage`\
`     ENH: Improve RescaleIntensityImageFilter coverage.`\
`     ENH: Improve itkClampImageFilter coverage.`\
`     BUG: Fix ivar type casting in PrintSelf.`\
`     STYLE: Improve MRIBiasFieldCorrectionFilter style.`\
`     ENH: Improve MRIBiasFieldCorrectionFilter coverage.`\
`     ENH: Improve itkIntensityWindowingImageFilter coverage`\
`     BUG: Fix Run-time type information in CSV module classes.`\
`     ENH: Improve the itkHistogram class code coverage.`\
`     DOC: Fix documentation typo.`\
`     STYLE: Improve the ImproveRescaleIntensityImageFilter style.`\
`     PERF: Make the itkVideoFileReader ivars private`\
`     PERF: Make itkVideoFileWriter ivars private`\
`     ENH: Improve coverage for itk::OrientImageFilter.`\
`     STYLE: Improve itk::OrientImageFilter class style.`\
`     ENH: Improve itkCSVNumericObjectFileWriter coverage.`\
`     ENH: Add missing standard class typdefs.`\
`     ENH: Improve itkVoronoiSegmentationImageFilter coverage.`\
`     ENH: Improve itkVoronoiSegmentationImageFilter style.`\
`     STYLE: Improve the MalahanobisDistanceThresholdImageFunction style.`\
`     ENH: Improve coverage for itkMalahanobisDistanceThreshold.`\
`     ENH: Improve itk::MinimumMaximumImageCalculator coverage.`\
`     ENH: Improve itkMinimumMaximumImageCalculator style.`\
`     BUG: Fix type mismatch in test.`\
`     STYLE: Improve itkPolylineMaskImagefilter style.`\
`     ENH: Improve itkPolylineMaskImageFilter coverage.`\
`     ENH: Improve itkFileListVideoStyle.`\
`     ENH: Improve itkLandmarkBasedTransformInitializer coverage.`\
`     ENH: Add baseline image to itkPolylineMaskImageFilter test.`\
`     ENH: Improve coverage for itkBSplineTransformInitializer.`\
`     STYLE: Improve itkBSplineTransformInitializer doc style.`\
`     ENH: Enhance itkBSplineTransformInitializer implementation.`\
`     DOC: Fix typo in method documentation.`\
`     ENH: Improve the itkRegularStepGradientDescentOptimizerv4 style.`\
`     STYLE: Improve the itkSimpleContourExtractorImageFilter style.`\
`     ENH: Exercise the class' Get methods.`\
`     ENH: Improve coverage for itkStatisticsOpeningLabelMapFilter.`\
`     ENH: Improve style for itkThresholdLabelerImageFilter.`\
`     ENH: Improve itkThresholdLabelerImageFilter coverage.`\
`     ENH: Get internal ImageIO via a const macro.`\
`     ENH: Improve the itkSimpleContourExtractorImageFilter coverage.`\
`     STYLE: Improve the itkMetaArray class style.`\
`     ENH: Improve MetaArrayReader/Writer coverages.`\
`     ENH: Improve the itkCovarianceImageFunction style.`\
`     STYLE: Improve itkVoronoiDiagram2DGenerator style.`\
`     ENH: Improve VoronoiDiagram2DGenerator coverage.`\
`     STYLE: Improve the itkBayesianClassifierImageFilter style.`\
`     STYLE: Improve the itkMetaArrayWriter style.`\
`     ENH: Improve itkCovarianteImageFunction coverage.`\
`     COMP: Fix signed/unsigned int comparison warning.`\
`     DOC: Improve itkGrayscaleDilateImageFilter documentation.`\
`     DOC: Improve documentation for itkGrayscaleErodeImageFilter.`\
`     DOC: Improve ConfigureHistogram method documentation.`\
`     STYLE: Improve the itkMovingHistogramMorphologyImagefilter style.`\
`     BUG: Fix Superclass name in RTTI.`\
`     STYLE: Improve itkGaussianInterpolateImageFunction style.`\
`     ENH: Improve coverage for itkGaussianInterpolateImageFunction.`\
`     ENH: Improve itkBayesianClassifierImageFilter coverage.`\
`     ENH: Add itkBSplineControlPointImageFilter RTTI.`\
`     STYLE: Improve itkBSplinecontrolPointImageFilter style.`\
`     ENH: Improve itkBSplineControlPointImageFilter coverage.`\
`     ENH: Improve coverage for itkRegularStepGradientDescentOptimizerv4.`\
`     STYLE: Improve the class implementation file style.`\
`     STYLE: Improve the itkResampleImageFilter style.`\
`     DOC: Fix typo in GetMTime method doc.`\
`     STYLE: Remove out-of-body implementation doc`\
`     ENH: Improve itkResampleImageFilter coverage.`\
`     ENH: Improve itkAbsImageAdaptor and Filter coverage.`\
`     BUG: Fix itkLSMImageIO class' Superclass name.`\
`     ENH: Improve the itkInterpolateImagePointsFilter coverage.`\
`     ENH: Improve itkPowImageFilter coverage.`\
`     BUG: Fix ConvolutionImageFilter RTTI.`\
`     STYLE: Use initialization lists.`\
`     STYLE: Improve BinaryFunctorImageFilter style.`\
`     ENH: Improve itkMinimumImageFilter code coverage.`\
`     BUG: Fix Linux-x86_64-gcc4.1 warning on implicit conversion.`\
`     ENH: Improve MaximumImageFilter coverage.`\
`     BUG: Fix conversion to PixelType conversion.`\
`     COMP: Fix double to unsigned char conversion warning.`\
`     ENH: Improve coverage for itkNormalizeToConstantImageFilter.`\
`     BUG: Fix itkSquaredDifferenceErrorFunction RTTI.`\
`     ENH: Improve itkMeanImageFunctionCoverage.`\
`     ENH: Improve itkSquareImageFilter coverage.`\
`     STYLE: Improve the itkSquaredDifferenceErrorFunction style.`\
`     STYLE: Enhance style for itkNormalizeToConstantImageFilter.`\
`     STYLE: Improve itkMeanImageFunction style.`\
`     ENH: Remove unnecesary call to filter print.`\
`     ENH: Improve itkRegionOfInterestImageFilter coverage.`\
`     STYLE: Improve itkRegionOfInterestImageFilter style.`\
`     STYLE: Improve itkPasteImageFilter style.`\
`     STYLE: Improve itkJoinSeriesImageFilter style.`\
`     BUG: Fix itkPadLabelMapFilter RTTI Superclass.`\
`     COMP: Address std::cout.precision conversion warning.`\
`     ENH: Improve itkBayesianClassifiertImageFilter coverage.`\
`     ENH: Improve itkPadLabelMapFilter coverage.`\
`     ENH: Improve itkJoinSeriesImageFilter coverage.`\
`     ENH: Improve the itkPasteImageFilter coverage.`\
`     ENH: Improve MeanImageFilter coverage.`\
`     COMP: Address std::cout.precision conversion warning.`\
`     ENH: Improve TernaryMagnitudeImageFilter coverage.`\
`     ENH: Improve FFTConvolutionImageFilter coverage.`\
`     DOC: Fix class documentation in ternary magnitude filters.`\
`     ENH: Improve ConstrainedValueDifferenceImageFilter coverage.`\
`     ENH: Improve AndImageFilter coverage.`\
`     ENH: Add baseline test to itkTernaryMagnitudeImageFilter.`\
`     ENH: Use MD5 comparison framework in baseline test.`\
`     ENH: Improve itk::VectorRescaleIntensityImageFilter coverage.`\
`     STYLE: Improve the itkVectorRescaleIntensityImageFilter style.`\
`     ENH: Print missing ivar in filter PrintSelf method.`\
`     ENH: Improve itkComplexToImaginaryFilter coverage.`\
`     ENH: Improve itkComplexToPhaseImageFilter coverage.`\
`     ENH: Improve itkComplexToModulusImageFilter coverage.`\
`     ENH: Improve itkComplexToRealImageFilter coverage.`\
`     ENH: Improve itkVectorResampleImageFilter coverage.`\
`     ENH: Add GetTransform method.`\
`     ENH: Improve itkConstrainedValueAdditionImageFilter coverage.`\
`     ENH: Improve itkModulusImageFilter coverage.`\
`     ENH: Improve itkLog10ImageFilter coverage.`\
`     ENH: Imporve itkMagnitudeAndPhaseToComplexImageFilter coverage.`\
`     ENH: Improve itkLogImageFilter coverage.`\
`     ENH: Improve itkInvertIntensityImageFilter coverage.`\
`     STYLE: Improve itkInvertIntensityImageFilter style.`\
`     DOC: Add missing doc to itkInvertIntensityImageFilter.`\
`     STYLE: Improve itkIntensityWindowingImageFilter style.`\
`     STYLE: Use initialization lists.`\
`     ENH: Improve itkIntensityWindowingImageFilter coverage.`\
`     ENH: Improve itkNaryMaximumImageFilter coverage.`\
`     COMP: Fix std::precision type casting warning.`\
`     ENH: Improve itkPointSetToPointSetRegistrationMethod coverage.`\
`     STYLE: Improve the itkPointSetToPointSetImageRegistrationMethod style.`\
`     ENH: Remove SmartPointers being explicitly initialized to null.`\
`     STYLE: Improve the itkPointSetToImageRegistrationMethod style.`\
`     ENH: Improve itkPointSetToImageRegistration coverage.`\
`     STYLE: Change the name of the itkPointSetToImageRegistrationMethod test.`\
`     STYLE: Improve itkVectorResampleImageFilter style.`\
`     STYLE: Improve the itkAntiAliasBinaryImageFilter style.`\
`     ENH: Improve trigonometric function filters' coverage.`\
`     STYLE: Remove test names from std::out messages.`\
`     ENH: Improve Boolean Algebra ImageFilters coverage.`\
`     STYLE: Improve the EuclideanDistancePointMetric style.`\
`     ENH: Improve itkSigmoidImageFilter coverage.`\
`     STYLE: Improve itkCropImageFilter style.`\
`     ENH: Improve itkCropImageFilter coverage.`\
`     ENH: Improve RGBToLuminanceImageFilter and Adaptor coverage.`\
`     ENH: Improve itkRescaleIntensityImageFilter coverage.`\
`     ENH: Improve the itkMatrixSelectionImageFilter coverage.`\
`     ENH: Improve itkTanImageFilter and Adaptor coverage.`\
`     ENH: Increase itkSqrtImageFilter and Adaptor coverage.`\
`     ENH: Increase itkTernaryOperatorImageFilter coverage.`\
`     ENH: Increase itkSymmetricEigenAnalysisImageFilter coverage.`\
`     STYLE: Improve itkScalarImagekmeansImageFilter style.`\
`     STYLE: Conform to TEST_SET_GET_VALUE definition.`\
`     BUG: Fix uninitialized variable due to dynamic analysis defect.`\
`     BUG: Fix uninitialized variable defect reported by valgrind.`\
`     ENH: Improve the itkPointSetToPointSetRegistrationTest.`\
`     ENH: Improve the itkPointSetToImageRegistrationTest.`\
`     ENH: Increas BinaryMagnitudeImageFilter coverage.`\
`     STYLE: Remove test name from std output.`\
`     ENH: Increase MagnitudeImageFilter coverage.`\
`     BUG: Fix uninitialized variable defect reported by valgrind.`\
`     BUG: Fix Superclass name in RTTI.`\
`     STYLE: Improve itkFrustumSpatialFunction style.`\
`     STYLE: Improve the itkConicShellInteriorExteriorSpatialFunction style.`\
`     BUG: Fix Superclass template argument list.`\
`     STYLE: Improve the itkTorusInteriorExteriorSpatialFunction style.`\
`     STYLE: Improve the itkCheckerBoardImageFilter class style.`\
`     ENH: Improve the itk::LabelVotingImageFilter coverage.`\
`     ENH: Improve itkCheckerBoardImageFilter coverage.`\
`     STYLE: Improve itk::LabelVotingImageFilter style.`\
`     STYLE: Improve the itkHoughTransform2DCirclesImageFilter style.`\
`     ENH: Add test for itk::FrustumSpatialFunction class.`\
`     ENH: Improve itkConnectedThresholdImageFilter coverage.`\
`     STYLE: Improve itkConnectedThresholdImageFilter style.`\
`     BUG: Fix FrustumSpatialFunction internal precision conversion.`\
`     COMP: Fix implicit conversion warning.`\
`     STYLE: Improve itkThresholdImageFilter style.`\
`     ENH: Add test for itk::TorusInteriorExteriorSpatialFunction.`\
`     BUG: Fix Superclass template argument list.`\
`     ENH: Improve itkUnsharpMaskingImageFilter implementation.`\
`     ENH: Improve the itkUnsharpMaskingImageFilter coverage.`\
`     ENH: Fix UnsharpMaskingImageFilter test inconsistencies.`\
`     BUG: Add missing itkTypeMacro.`\
`     DOC: Document the member variables.`\
`     BUG: Fix the itkImageSource RTTI class name,`\
`     STYLE: Improve itkLabelImageGaussianInterpolateImageFunction style.`\
`     ENH: Finish itkGaussianInterpolateImageFunction PrintSelf.`\
`     STYLE: Improve itkLabelOverlapMeasurementImageFilter style.`

KWSys Robot (6):

`     KWSys 2016-06-30 (96f06c8e)`\
`     KWSys 2016-10-23 (b630d2f5)`\
`     KWSys 2016-11-03 (37306a1c)`\
`     KWSys 2016-11-08 (2b3e2b1c)`\
`     KWSys 2016-11-09 (18c65411)`\
`     KWSys 2016-11-21 (cb55cf5a)`

Maeliss Jallais (1):

`     BUG: Add unsigned and signed short to the wrapping of vnl_matrix`

Matthew McCormick (85):

`     PERF: Simplify HilbertPath numberOfPathVertices computation.`\
`     BUG: CID 1355469 NNetClassifierTest4 unintended integer division.`\
`     BUG: Update Cuberille Remote for version check fix.`\
`     ENH: Bump ITK version to 4.11.0.`\
`     BUG: Fix HDF5ImageIO type information.`\
`     BUG: Fix H5File memory leak in HDF5ImageIO.`\
`     DOC: Collect Francois Budin's contributions in .mailmap`\
`     BUG: Limit WRAP_ITK_MODULES when building externally`\
`     STYLE: Improvements to ResourceProbe report output.`\
`     ENH: Add a useTabs argument to ResourceProbe::Report.`\
`     ENH: Add standard error measure to the ResourceProbe`\
`     ENH: Add itk_python_add_test function.`\
`     BUG: Remove VNL file from subtree merge.`\
`     COMP: Fix wrapping with a space in the Python include path`\
`     BUG: Fix PermuteAxesImageFilter pipeline method visibility`\
`     BUG: Initialize PermuteOrder and FlipAxes in OrientImageFilter`\
`     BUG: ResampleImageFilter honor isInside output of the transform method`\
`     COMP: Avoid recursive include of itkMath.h`\
`     COMP: Fix VXL header installation locations`\
`     BUG: ClampImageFilterTest for older GCC, InPlaceOn`\
`     DOC: Add CONTRIBUTING.md file to the top level.`\
`     COMP: Update VariationalRegistration to address Doxygen warnings`\
`     BUG: Compiler detections file installed into ITK build tree location`\
`     COMP: Do not use string(TIMESTAMP.`\
`     COMP: Remove HDF5 -std=c99 for C++ files`\
`     BUG: Do not build HDF5 static library with a shared build`\
`     ENH: Add PerformanceBenchmarking Remote Module`\
`     COMP: Remove duplicate wrappings for ResampleImageFilter`\
`     BUG: Put Python test output files in the build tree`\
`     BUG: Improve HDF5ImageIO::CloseDataSet name`\
`     COMP: Use add_python_test PythonLazyLoadingImage`\
`     COMP: Address missing override it itkFactoryTestLib.cxx`\
`     BUG: Index,Size,Offset constructors present in Python with C++11`\
`     COMP: Address missing override it itkFactoryTestLib.cxx`\
`     BUG: PerformanceBenchmarking as EXCLUDE_FROM_DEFAULT`\
`     ENH: Bump SetupForDevelopment version`\
`     BUG: Add missing ZLib deflate support to HDF5`\
`     BUG: Address memory leak, remove NumPy build dep in BridgeNumPy`\
`     COMP: Do not set ITK_LIBRARY_BUILD_TYPE in ITKTransformFactory`\
`     COMP: Do not set ITK_LIBRARY_BUILD_TYPE in ITKTransformFactory`\
`     BUG: Check when ITK_WRAP_VECTOR_COMPONENTS doesn't include ITK_WRAP_IMAGE_DIMS`\
`     BUG: RichardsonLucyDeconvolutionImageFilter with non-null input Image Origin`\
`     BUG: Fix inconsistent Twister start with Initialize(seed) and SetSeed(seed)`\
`     BUG: Do not hard code CMake scripts in HDF5`\
`     COMP: Workaround Emscripten ITKCommon test build failure`\
`     COMP: Do embed fancy HDF5 libsettings with Emscripten`\
`     COMP: Add missing H5T_patch_vlen_file declaration`\
`     ENH: Bump CastXML to 2016-10-11 master.`\
`     COMP: Workaround Emscripten ITKCommon test build failure`\
`     BUG: Swap CastXML hashes for Mac OSX and Windows`\
`     ENH: Sync ExternalData.cmake with upstream CMake 3.6.2`\
`     COMP: Fix VNL tests when cross-compiling`\
`     ENH: ExternalData multi-algorithm support`\
`     ENH: ExternalData support for data.kitware.com`\
`     BUG: Install missing H5pubconf.h`\
`     BUG: Use SpacePrecisionType in TileImageFilter`\
`     BUG: Use internal ExternalData_Add_Target`\
`     ENH: Run .sha512, .md5 simultaneous modification pre-commit check`\
`     BUG: Correct CastXML Windows binary`\
`     BUG: Support non-zero Index in LevelSetNeighborhoodExtractor`\
`     ENH: Add ArchiveTestingDataOnGirder.py`\
`     BUG: Correct AtanRegularizationHeavisideStepFunction derivative`\
`     ENH: Add Utilities/Maintenance/ContentLinkSynchronization.sh`\
`     BUG: Remove extra HessianToObjectness content links`\
`     ENH: Wrap SpatialFunction float types with ITK_WRAP_float`\
`     BUG: Bump PerformanceBenchmarking to 2016-11-04`\
`     BUG: itk_python_expression_add_test too many quotes.`\
`     ENH: Wrap VectorImage with complex real pixel types`\
`     ENH: Bump PerformanceBenchmarking to 2016-11-07`\
`     BUG: Do not assume zero Index in ReinitializeLevelSetImageFilter`\
`     ENH: Create itk_module_add_library macro`\
`     BUG: Update computeCodeCoverageLocally.sh for KWStyle addition`\
`     COMP: Install a newer version of CMake on CircleCI`\
`     ENH: Use GitHub Pages as the first ExternalData resource`\
`     ENH: Add tests to demonstrate OSX dynamic_cast failure`\
`     BUG: Use random seed with for MersenneTwisterRandomVariateGenerator.`\
`     BUG: Enable program global timestamp`\
`     BUG: Set random number seed in Mattes metric test`\
`     BUG: Notify builder that ITK_DYNAMIC_LOADING is required with wrapping`\
`     BUG: Define ITK_DYNAMIC_LOADING before ITK_WRAP_PYTHON`\
`     BUG: Set random number seed mutual information metric tests`\
`     BUG: Wrap std::vector< itk.Point >`\
`     BUG: Fix wrapping of LandmarkBasedTransformInitializer`\
`     BUG: Rename UnsharpMaskingImageFilter to UnsharpMaskImageFilter`\
`     DOC: Add Dženan Zukić to .mailmap`

Max Smolens (4):

`     COMP: CID-1266557 StatisticsLabelMapFilter uninitialized scalar field`\
`     BUG: CID-1355438 QuadEdgeTest1 resource leaks`\
`     COMP: CID-1355472 MIRegistrationFunction unused value`\
`     COMP: Fix link errors for VNL template instantiations on Windows`

Mayeul Chassagnard (7):

`     BUG: Test added and error fixed in HDF5ImageIO`\
`     ENH: Update add_library TO itk_module_add_library`\
`     COMP: Set Policy CMP0023 target_link_libraries for Modules/ThirdParty/VNLI...`\
`     BUG: Add ITK_TEMPLATE_EXPORT to template classes`\
`     BUG: Fix errors linked to dyn_cast merge`\
`     BUG: Restore old ITKModule_TEMPLATE_EXPORT specification for classes`\
`     BUG: dash3win7 dashboard build error unresolved external symbol`

Michka Popoff (3):

`     ENH: Update UpdatepygccxmlFromUpstream.sh for v1.8.0`\
`     ENH: Update igenerator.py for pygccxml v1.8.0`\
`     COMP: Use pygccxml's public API for apply definitions`

Pierre Barbier de Reuille (2):

`     COMP: Fix function naming error when using FFTWD`\
`     COMP: Fix function naming error when using FFTWD`

Sean McBride (1):

`     COMP: Bypass HDF5 bugs under TSan`

Simon Rit (2):

`     COMP: remove C++11 compiler warning for CUDA compilations`\
`     COMP: remove C++11 compiler warning for CUDA compilations`

Somesh Kashyap (2):

`     BUG: Override TransformCategoryType for AzimuthElevationToCartesianTransform`\
`     BUG: -Added test case for  itkAzimuthElevationToCartesianTransform`

Sumedha Singla (1):

`     ENH: Updated the git tag for ITK-Minimal-Path-Extraction remote module`

Taylor Braun-Jones (4):

`     COMP: Skip path length checks if ITK_SKIP_PATH_LENGTH_CHECKS is enabled`\
`     COMP: Fix truncation from double to float warning`\
`     DOC: Fix incorrect itkFactorylessNewMacro documentation`\
`     COMP: Only include the headers for required OpenCV modules`

Thien Nguyen (1):

`     PERF: SmapsFileParser unnecessary dynamic_cast`

VXL Maintainers (4):

`     VNL 2016-05-15 (14f97ab4)`\
`     VNL 2016-06-22 (23a93adb)`\
`     VNL 2016-06-29 (d62a2d70)`\
`     VNL 2016-07-06 (acfa62cc)`

Vladimir S. FONOV (1):

`     COMP: Build against GCC 5.3.1`

Zach Williamson (2):

`     ENH: Update Remote Module Tags`\
`     BUG: Fix Python Wrappings in C++11`

Ziv Yaniv (1):

`     BUG: Metric sampling percentage accepted values outside (0.0, 1.0].`

ITK Sphinx Examples Changes

------------------------------------------------------------------------

Matt McCormick (6):

`     BUG: Use GDCM ITK module name`\
`     ENH: Rename ReadDICOMSeriesAndWrite3DImage`\
`     BUG: Add tests for ReadDICOMSeriesAndWrite3DImage`\
`     ENH: Bump ITK Superbuild version to 2016-09-20 master`\
`     ENH: Add Python version of ReadDICOMSeriesAndWrite3DImage`\
`     ENH: Add Python version of CreateAnRGBImage`

Michka Popoff (5):

`     ENH: Use same Python interpreter as ITK for wrapping tests`\
`     BUG: Fix ResampleAnImage example (Python3)`\
`     ENH: Add Python example for ApplyAFilterOnlyToASpecifiedRegionOfAnImage`\
`     ENH: Add 7 Python examples to Core/Common`\
`     ENH: Add BoundingBoxOfAPointSet Python example`

ITK Software Guide Changes

------------------------------------------------------------------------

Matt McCormick (8):

`     DOC: Move the location for obtaining the software`\
`     DOC: Remove reference to ITKApps`\
`     ENH: Bump ITK ExternalProject version to 2016-11-02 master`\
`     DOC: Document the ITK module registry`\
`     ENH: Bump ITK ExternalProject version to v4.11rc01 master`\
`     DOC: Update CMake hyperlinks`\
`     DOC: Update minimum required CMake version to 2.8.9`\
`     DOC: Add section on static and shared libraries.`
