/*
 * Copyright (c) 2006-2012. QLogic Corporation. All rights reserved.
 * Copyright (c) 2003-2006, PathScale, Inc. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if !defined(PSM_USE_SYS_UUID)

#define STDC_HEADERS 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRING_H 1
#define HAVE_MEMORY_H 1
#define HAVE_STRINGS_H 1
#define HAVE_INTTYPES_H 1
#define HAVE_STDINT_H 1
#define HAVE_UNISTD_H 1
#define ENABLE_HTREE 1
#define ENABLE_SWAPFS 1
#define HAVE_LONG_LONG 1
#define HAVE_LONG_DOUBLE 1
#define HAVE_WCHAR_T 1
#define HAVE_WINT_T 1
#define HAVE_INTTYPES_H_WITH_UINTMAX 1
#define HAVE_STDINT_H_WITH_UINTMAX 1
#define HAVE_INTMAX_T 1
#define HAVE_POSIX_PRINTF 1
#define HAVE_ALLOCA_H 1
#define HAVE_ALLOCA 1
#define HAVE_STDLIB_H 1
#define HAVE_UNISTD_H 1
#define HAVE_GETPAGESIZE 1
#define HAVE_MMAP 1
#define INTDIV0_RAISES_SIGFPE 1
#define HAVE_UNSIGNED_LONG_LONG 1
#define HAVE_UINTMAX_T 1
#define HAVE_INTTYPES_H 1
#define HAVE_STDINT_H 1
#define HAVE_STDINT_H 1
#define HAVE_ARGZ_H 1
#define HAVE_LIMITS_H 1
#define HAVE_LOCALE_H 1
#define HAVE_NL_TYPES_H 1
#define HAVE_MALLOC_H 1
#define HAVE_STDDEF_H 1
#define HAVE_STDLIB_H 1
#define HAVE_STRING_H 1
#define HAVE_UNISTD_H 1
#define HAVE_SYS_PARAM_H 1
#define HAVE_ASPRINTF 1
#define HAVE_FWPRINTF 1
#define HAVE_GETCWD 1
#define HAVE_GETEGID 1
#define HAVE_GETEUID 1
#define HAVE_GETGID 1
#define HAVE_GETUID 1
#define HAVE_MEMPCPY 1
#define HAVE_MUNMAP 1
#define HAVE_PUTENV 1
#define HAVE_SETENV 1
#define HAVE_SETLOCALE 1
#define HAVE_SNPRINTF 1
#define HAVE_STPCPY 1
#define HAVE_STRCASECMP 1
#define HAVE_STRDUP 1
#define HAVE_STRTOUL 1
#define HAVE_TSEARCH 1
#define HAVE_WCSLEN 1
#define HAVE___ARGZ_COUNT 1
#define HAVE___ARGZ_STRINGIFY 1
#define HAVE___ARGZ_NEXT 1
#define HAVE___FSETLOCKING 1
#define HAVE_DECL__SNPRINTF 0
#define HAVE_DECL__SNWPRINTF 0
#define HAVE_DECL_FEOF_UNLOCKED 1
#define HAVE_DECL_FGETS_UNLOCKED 0
#define HAVE_DECL_GETC_UNLOCKED 1
#define HAVE_ICONV 1
#define ICONV_CONST 
#define HAVE_LANGINFO_CODESET 1
#define HAVE_LC_MESSAGES 1
#define ENABLE_NLS 1
#define HAVE_GETTEXT 1
#define HAVE_DCGETTEXT 1
#define HAVE_STDLIB_H 1
#define HAVE_UNISTD_H 1
#define HAVE_STDARG_H 1
#define HAVE_STDINT_H 1
#define HAVE_ERRNO_H 1
#define HAVE_MALLOC_H 1
#define HAVE_MNTENT_H 1
#define HAVE_PATHS_H 1
#define HAVE_DIRENT_H 1
#define HAVE_GETOPT_H 1
#define HAVE_SETJMP_H 1
#define HAVE_SIGNAL_H 1
#define HAVE_TERMIOS_H 1
#define HAVE_LINUX_FD_H 1
#define HAVE_LINUX_MAJOR_H 1
#define HAVE_SYS_IOCTL_H 1
#define HAVE_SYS_PRCTL_H 1
#define HAVE_SYS_QUEUE_H 1
#define HAVE_SYS_SOCKET_H 1
#define HAVE_SYS_SYSMACROS_H 1
#define HAVE_SYS_TIME_H 1
#define HAVE_SYS_STAT_H 1
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_WAIT_H 1
#define HAVE_SYS_RESOURCE_H 1
#define HAVE_NETINET_IN_H 1
#define HAVE_SYS_MOUNT_H 1
#define HAVE_NET_IF_H 1
#define HAVE_VPRINTF 1
#define HAVE_RECLEN_DIRENT 1
#define HAVE_TYPE_SSIZE_T 1
#define HAVE_LSEEK64_PROTOTYPE 1
#define SIZEOF_SHORT 2
#define SIZEOF_INT 4
#define SIZEOF_LONG 8
#define SIZEOF_LONG_LONG 8
#define HAVE_INTTYPES_H 1
#define HAVE_INTPTR_T 1
#define HAVE_GETRUSAGE 1
#define HAVE_LLSEEK 1
#define HAVE_LSEEK64 1
#define HAVE_OPEN64 1
#define HAVE_STRTOULL 1
#define HAVE_STRCASECMP 1
#define HAVE_SRANDOM 1
#define HAVE_FCHOWN 1
#define HAVE_MALLINFO 1
#define HAVE_FDATASYNC 1
#define HAVE_STRNLEN 1
#define HAVE_STRPTIME 1
#define HAVE_SYSCONF 1
#define HAVE_PATHCONF 1
#define HAVE_POSIX_MEMALIGN 1
#define HAVE_MEMALIGN 1
#define HAVE_VALLOC 1
#define HAVE___SECURE_GETENV 1
#define HAVE_PRCTL 1
#define HAVE_DLOPEN 1
#define HAVE_EXT2_IOCTLS 1

#include "pack.c"
#include "unpack.c"
#include "clear.c"
#include "compare.c"
#include "copy.c"
#include "gen_uuid.c"
#include "isnull.c"
#include "parse.c"
#include "unparse.c"
#include "psm_help.h"

#else /* PSM_USE_SYS_UUID */
#include <uuid/uuid.h>
#include "psm_user.h"
#endif

void
__psm_uuid_generate(psm_uuid_t uuid_out)
{
    uuid_generate(uuid_out);
    return;
}
PSMI_API_DECL(psm_uuid_generate)

int
psmi_uuid_compare(const psm_uuid_t uuA, const psm_uuid_t uuB)
{
    return uuid_compare(uuA, uuB);
}

void
psmi_uuid_unparse(const uuid_t uu, char *out)
{
    uuid_unparse_lower(uu, out);
}

int
psmi_uuid_parse(const char *in, uuid_t uu)
{
    return uuid_parse(in, uu);
}

