/* colormapper.c generated by valac 0.22.1, the Vala compiler
 * generated from colormapper.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "gtk/gtk.h"
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COLOR_SCHEME (color_scheme_get_type ())
#define COLOR_SCHEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOR_SCHEME, ColorScheme))
#define COLOR_SCHEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOR_SCHEME, ColorSchemeClass))
#define IS_COLOR_SCHEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOR_SCHEME))
#define IS_COLOR_SCHEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOR_SCHEME))
#define COLOR_SCHEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOR_SCHEME, ColorSchemeClass))

typedef struct _ColorScheme ColorScheme;
typedef struct _ColorSchemeClass ColorSchemeClass;
typedef struct _ColorSchemePrivate ColorSchemePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecColorScheme ParamSpecColorScheme;

#define TYPE_COLOR_MAPPER (color_mapper_get_type ())
#define COLOR_MAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOR_MAPPER, ColorMapper))
#define COLOR_MAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOR_MAPPER, ColorMapperClass))
#define IS_COLOR_MAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOR_MAPPER))
#define IS_COLOR_MAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOR_MAPPER))
#define COLOR_MAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOR_MAPPER, ColorMapperClass))

typedef struct _ColorMapper ColorMapper;
typedef struct _ColorMapperClass ColorMapperClass;
typedef struct _ColorMapperPrivate ColorMapperPrivate;
#define _color_scheme_unref0(var) ((var == NULL) ? NULL : (var = (color_scheme_unref (var), NULL)))

struct _ColorScheme {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ColorSchemePrivate * priv;
	gchar* label;
	gchar** colors;
	gint colors_length1;
	gint _colors_size_;
	GdkRGBA rgbas[16];
};

struct _ColorSchemeClass {
	GTypeClass parent_class;
	void (*finalize) (ColorScheme *self);
};

struct _ParamSpecColorScheme {
	GParamSpec parent_instance;
};

struct _ColorMapper {
	GObject parent_instance;
	ColorMapperPrivate * priv;
};

struct _ColorMapperClass {
	GObjectClass parent_class;
};

struct _ColorMapperPrivate {
	gchar* _color_scheme;
};


static gpointer color_scheme_parent_class = NULL;
static gpointer color_mapper_parent_class = NULL;
static GHashTable* color_mapper_schemes;
static GHashTable* color_mapper_schemes = NULL;
static GdkRGBA color_mapper_tangorgbas[27];
static GdkRGBA color_mapper_tangorgbas[27] = {0};
static GdkRGBA color_mapper_grayrgbas[9];
static GdkRGBA color_mapper_grayrgbas[9] = {0};

gpointer color_scheme_ref (gpointer instance);
void color_scheme_unref (gpointer instance);
GParamSpec* param_spec_color_scheme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_color_scheme (GValue* value, gpointer v_object);
void value_take_color_scheme (GValue* value, gpointer v_object);
gpointer value_get_color_scheme (const GValue* value);
GType color_scheme_get_type (void) G_GNUC_CONST;
enum  {
	COLOR_SCHEME_DUMMY_PROPERTY
};
ColorScheme* color_scheme_new (const gchar* label, gchar** colors, int colors_length1);
ColorScheme* color_scheme_construct (GType object_type, const gchar* label, gchar** colors, int colors_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void color_scheme_finalize (ColorScheme* obj);
GType color_mapper_get_type (void) G_GNUC_CONST;
#define COLOR_MAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COLOR_MAPPER, ColorMapperPrivate))
enum  {
	COLOR_MAPPER_DUMMY_PROPERTY,
	COLOR_MAPPER_COLOR_SCHEME
};
static ColorScheme* color_mapper_scheme (const gchar* name);
static GdkRGBA* color_mapper_schemergbas (const gchar* name, int* result_length1);
static GdkRGBA* _vala_array_dup2 (GdkRGBA* self, int length);
gchar* color_mapper_schemelabel (const gchar* name);
gboolean color_mapper_parse_colorname (const gchar* value, GdkRGBA* rgba);
void color_mapper_add_palette (ColorMapper* self, GtkColorChooser* chooser);
const gchar* color_mapper_get_color_scheme (ColorMapper* self);
ColorMapper* color_mapper_new (void);
ColorMapper* color_mapper_construct (GType object_type);
void color_mapper_set_color_scheme (ColorMapper* self, const gchar* value);
static void color_mapper_finalize (GObject* obj);
static void _vala_color_mapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_color_mapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* COLOR_MAPPER_colorschemes[4] = {"traditional", "ambiance", "radiance", "xosview"};
static const gchar* COLOR_MAPPER_colornames[16] = {"cpu1", "cpu2", "cpu3", "cpu4", "mem1", "mem2", "mem3", "mem4", "net1", "net2", "net3", "swap1", "load1", "disk1", "disk2", "background"};
static const gchar* COLOR_MAPPER_tangocolors[27] = {"#ef2929", "#cc0000", "#a40000", "#fcaf3e", "#f57900", "#ce5c00", "#fce94f", "#edd400", "#c4a000", "#8ae234", "#73d216", "#4e9a06", "#729fcf", "#3465a4", "#204a87", "#ad7fa8", "#75507b", "#5c3566", "#e9b96e", "#c17d11", "#8f5902", "#888a85", "#555753", "#2e3436", "#eeeeec", "#d3d7cf", "#babdb6"};
static const gchar* COLOR_MAPPER_graycolors[9] = {"#000000", "#2e3436", "#555753", "#888a85", "#babdb6", "#d3d7cf", "#eeeeec", "#f3f3f3", "#ffffff"};

static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ColorScheme* color_scheme_construct (GType object_type, const gchar* label, gchar** colors, int colors_length1) {
	ColorScheme* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (label != NULL, NULL);
	self = (ColorScheme*) g_type_create_instance (object_type);
	_tmp0_ = label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->label);
	self->label = _tmp1_;
	_tmp2_ = colors;
	_tmp2__length1 = colors_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->colors = (_vala_array_free (self->colors, self->colors_length1, (GDestroyNotify) g_free), NULL);
	self->colors = _tmp3_;
	self->colors_length1 = _tmp3__length1;
	self->_colors_size_ = self->colors_length1;
	{
		guint j = 0U;
		guint jsize = 0U;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		j = (guint) 0;
		_tmp4_ = colors;
		_tmp4__length1 = colors_length1;
		jsize = (guint) _tmp4__length1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				guint _tmp8_ = 0U;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				guint _tmp12_ = 0U;
				const gchar* _tmp13_ = NULL;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					guint _tmp7_ = 0U;
					_tmp7_ = j;
					j = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = j;
				_tmp9_ = jsize;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = j;
				_tmp11_ = colors;
				_tmp11__length1 = colors_length1;
				_tmp12_ = j;
				_tmp13_ = _tmp11_[_tmp12_];
				gdk_rgba_parse (&self->rgbas[_tmp10_], _tmp13_);
			}
		}
	}
	return self;
}


ColorScheme* color_scheme_new (const gchar* label, gchar** colors, int colors_length1) {
	return color_scheme_construct (TYPE_COLOR_SCHEME, label, colors, colors_length1);
}


static void value_color_scheme_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_color_scheme_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		color_scheme_unref (value->data[0].v_pointer);
	}
}


static void value_color_scheme_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = color_scheme_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_color_scheme_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_color_scheme_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ColorScheme* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = color_scheme_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_color_scheme_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ColorScheme** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = color_scheme_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_color_scheme (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecColorScheme* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COLOR_SCHEME), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_color_scheme (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COLOR_SCHEME), NULL);
	return value->data[0].v_pointer;
}


void value_set_color_scheme (GValue* value, gpointer v_object) {
	ColorScheme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COLOR_SCHEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COLOR_SCHEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		color_scheme_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		color_scheme_unref (old);
	}
}


void value_take_color_scheme (GValue* value, gpointer v_object) {
	ColorScheme* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COLOR_SCHEME));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COLOR_SCHEME));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		color_scheme_unref (old);
	}
}


static void color_scheme_class_init (ColorSchemeClass * klass) {
	color_scheme_parent_class = g_type_class_peek_parent (klass);
	COLOR_SCHEME_CLASS (klass)->finalize = color_scheme_finalize;
}


static void color_scheme_instance_init (ColorScheme * self) {
	self->ref_count = 1;
}


static void color_scheme_finalize (ColorScheme* obj) {
	ColorScheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOR_SCHEME, ColorScheme);
	_g_free0 (self->label);
	self->colors = (_vala_array_free (self->colors, self->colors_length1, (GDestroyNotify) g_free), NULL);
}


/******************************************************************************
 * Copyright (C) 2013  Michael Hofmann <mh21@mh21.de>                         *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType color_scheme_get_type (void) {
	static volatile gsize color_scheme_type_id__volatile = 0;
	if (g_once_init_enter (&color_scheme_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_color_scheme_init, value_color_scheme_free_value, value_color_scheme_copy_value, value_color_scheme_peek_pointer, "p", value_color_scheme_collect_value, "p", value_color_scheme_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ColorSchemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) color_scheme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColorScheme), 0, (GInstanceInitFunc) color_scheme_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType color_scheme_type_id;
		color_scheme_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ColorScheme", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&color_scheme_type_id__volatile, color_scheme_type_id);
	}
	return color_scheme_type_id__volatile;
}


gpointer color_scheme_ref (gpointer instance) {
	ColorScheme* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void color_scheme_unref (gpointer instance) {
	ColorScheme* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COLOR_SCHEME_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _color_scheme_ref0 (gpointer self) {
	return self ? color_scheme_ref (self) : NULL;
}


static ColorScheme* color_mapper_scheme (const gchar* name) {
	ColorScheme* result = NULL;
	ColorScheme* scheme = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	ColorScheme* _tmp3_ = NULL;
	ColorScheme* _tmp4_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = color_mapper_schemes;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _color_scheme_ref0 ((ColorScheme*) _tmp2_);
	scheme = _tmp3_;
	_tmp4_ = scheme;
	if (_tmp4_ == NULL) {
		GHashTable* _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		ColorScheme* _tmp7_ = NULL;
		_tmp5_ = color_mapper_schemes;
		_tmp6_ = g_hash_table_lookup (_tmp5_, "traditional");
		_tmp7_ = _color_scheme_ref0 ((ColorScheme*) _tmp6_);
		_color_scheme_unref0 (scheme);
		scheme = _tmp7_;
	}
	result = scheme;
	return result;
}


static GdkRGBA* _vala_array_dup2 (GdkRGBA* self, int length) {
	return g_memdup (self, length * sizeof (GdkRGBA));
}


static GdkRGBA* color_mapper_schemergbas (const gchar* name, int* result_length1) {
	GdkRGBA* result = NULL;
	const gchar* _tmp0_ = NULL;
	ColorScheme* _tmp1_ = NULL;
	ColorScheme* _tmp2_ = NULL;
	GdkRGBA* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GdkRGBA* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GdkRGBA* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = color_mapper_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (_tmp2_->rgbas != NULL) ? _vala_array_dup2 (_tmp2_->rgbas, 16) : ((gpointer) _tmp2_->rgbas);
	_tmp3__length1 = 16;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_color_scheme_unref0 (_tmp2_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}


gchar* color_mapper_schemelabel (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	ColorScheme* _tmp1_ = NULL;
	ColorScheme* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = color_mapper_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->label;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_color_scheme_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gboolean color_mapper_parse_colorname (const gchar* value, GdkRGBA* rgba) {
	gboolean result = FALSE;
	gchar** parts = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (rgba != NULL, FALSE);
	_tmp0_ = value;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	if (_tmp3__length1 == 2) {
		GdkRGBA* rgbas = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GdkRGBA* _tmp7_ = NULL;
		gint rgbas_length1 = 0;
		gint _rgbas_size_ = 0;
		_tmp4_ = parts;
		_tmp4__length1 = parts_length1;
		_tmp5_ = _tmp4_[0];
		_tmp7_ = color_mapper_schemergbas (_tmp5_, &_tmp6_);
		rgbas = _tmp7_;
		rgbas_length1 = _tmp6_;
		_rgbas_size_ = rgbas_length1;
		{
			guint j = 0U;
			guint jsize = 0U;
			j = (guint) 0;
			jsize = (guint) G_N_ELEMENTS (COLOR_MAPPER_colornames);
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_ = FALSE;
					guint _tmp11_ = 0U;
					guint _tmp12_ = 0U;
					guint _tmp13_ = 0U;
					const gchar* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						guint _tmp10_ = 0U;
						_tmp10_ = j;
						j = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = j;
					_tmp12_ = jsize;
					if (!(_tmp11_ < _tmp12_)) {
						break;
					}
					_tmp13_ = j;
					_tmp14_ = COLOR_MAPPER_colornames[_tmp13_];
					_tmp15_ = parts;
					_tmp15__length1 = parts_length1;
					_tmp16_ = _tmp15_[1];
					if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
						GdkRGBA* _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						guint _tmp18_ = 0U;
						GdkRGBA _tmp19_ = {0};
						_tmp17_ = rgbas;
						_tmp17__length1 = rgbas_length1;
						_tmp18_ = j;
						_tmp19_ = _tmp17_[_tmp18_];
						*rgba = _tmp19_;
						result = TRUE;
						rgbas = (g_free (rgbas), NULL);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
			}
		}
		rgbas = (g_free (rgbas), NULL);
	}
	_tmp20_ = value;
	_tmp21_ = gdk_rgba_parse (rgba, _tmp20_);
	result = _tmp21_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void color_mapper_add_palette (ColorMapper* self, GtkColorChooser* chooser) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_COLOR_MAPPER (self));
	g_return_if_fail (GTK_IS_COLOR_CHOOSER (chooser));
	_tmp0_ = gtk_check_version ((guint) 3, (guint) 8, (guint) 0);
	if (_tmp0_ == NULL) {
		GtkColorChooser* _tmp1_ = NULL;
		GtkColorChooser* _tmp2_ = NULL;
		GtkColorChooser* _tmp3_ = NULL;
		GtkColorChooser* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GdkRGBA* _tmp7_ = NULL;
		GdkRGBA* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		_tmp1_ = chooser;
		gtk_color_chooser_add_palette (_tmp1_, GTK_ORIENTATION_VERTICAL, 0, 0, NULL);
		_tmp2_ = chooser;
		gtk_color_chooser_add_palette (_tmp2_, GTK_ORIENTATION_VERTICAL, 3, 27, color_mapper_tangorgbas);
		_tmp3_ = chooser;
		gtk_color_chooser_add_palette (_tmp3_, GTK_ORIENTATION_HORIZONTAL, 9, 9, color_mapper_grayrgbas);
		_tmp4_ = chooser;
		_tmp5_ = self->priv->_color_scheme;
		_tmp7_ = color_mapper_schemergbas (_tmp5_, &_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp6_;
		gtk_color_chooser_add_palette (_tmp4_, GTK_ORIENTATION_HORIZONTAL, 8, _tmp6_, _tmp8_);
		_tmp8_ = (g_free (_tmp8_), NULL);
	}
}


ColorMapper* color_mapper_construct (GType object_type) {
	ColorMapper * self = NULL;
	self = (ColorMapper*) g_object_new (object_type, NULL);
	return self;
}


ColorMapper* color_mapper_new (void) {
	return color_mapper_construct (TYPE_COLOR_MAPPER);
}


const gchar* color_mapper_get_color_scheme (ColorMapper* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_COLOR_MAPPER (self), NULL);
	_tmp0_ = self->priv->_color_scheme;
	result = _tmp0_;
	return result;
}


void color_mapper_set_color_scheme (ColorMapper* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_COLOR_MAPPER (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_color_scheme);
	self->priv->_color_scheme = _tmp1_;
	g_object_notify ((GObject *) self, "color-scheme");
}


static void color_mapper_class_init (ColorMapperClass * klass) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GDestroyNotify _tmp2_ = NULL;
	GDestroyNotify _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	ColorScheme* _tmp40_ = NULL;
	GHashTable* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gchar** _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	ColorScheme* _tmp62_ = NULL;
	GHashTable* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_ = NULL;
	gchar** _tmp82_ = NULL;
	gchar** _tmp83_ = NULL;
	gint _tmp83__length1 = 0;
	ColorScheme* _tmp84_ = NULL;
	GHashTable* _tmp85_ = NULL;
	gchar* _tmp86_ = NULL;
	const gchar* _tmp87_ = NULL;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	gchar* _tmp92_ = NULL;
	gchar* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_ = NULL;
	gchar* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	gchar** _tmp104_ = NULL;
	gchar** _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	ColorScheme* _tmp106_ = NULL;
	color_mapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ColorMapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_color_mapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_color_mapper_set_property;
	G_OBJECT_CLASS (klass)->finalize = color_mapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COLOR_MAPPER_COLOR_SCHEME, g_param_spec_string ("color-scheme", "color-scheme", "color-scheme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_free;
	_tmp3_ = g_object_unref;
	_tmp4_ = g_hash_table_new_full (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	color_mapper_schemes = _tmp4_;
	{
		guint j = 0U;
		j = (guint) 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				guint _tmp8_ = 0U;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				const gchar* _tmp11_ = NULL;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					guint _tmp7_ = 0U;
					_tmp7_ = j;
					j = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = j;
				if (!(_tmp8_ < ((guint) 27))) {
					break;
				}
				_tmp9_ = j;
				_tmp10_ = j;
				_tmp11_ = COLOR_MAPPER_tangocolors[_tmp10_];
				gdk_rgba_parse (&color_mapper_tangorgbas[_tmp9_], _tmp11_);
			}
		}
	}
	{
		guint j = 0U;
		j = (guint) 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				guint _tmp15_ = 0U;
				guint _tmp16_ = 0U;
				guint _tmp17_ = 0U;
				const gchar* _tmp18_ = NULL;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					guint _tmp14_ = 0U;
					_tmp14_ = j;
					j = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = j;
				if (!(_tmp15_ < ((guint) 9))) {
					break;
				}
				_tmp16_ = j;
				_tmp17_ = j;
				_tmp18_ = COLOR_MAPPER_graycolors[_tmp17_];
				gdk_rgba_parse (&color_mapper_grayrgbas[_tmp16_], _tmp18_);
			}
		}
	}
	_tmp19_ = color_mapper_schemes;
	_tmp20_ = g_strdup ("traditional");
	_tmp21_ = _ ("Traditional");
	_tmp22_ = g_strdup ("#0072b3");
	_tmp23_ = g_strdup ("#0092e6");
	_tmp24_ = g_strdup ("#00a3ff");
	_tmp25_ = g_strdup ("#002f3d");
	_tmp26_ = g_strdup ("#00b35b");
	_tmp27_ = g_strdup ("#00e675");
	_tmp28_ = g_strdup ("#00ff82");
	_tmp29_ = g_strdup ("#aaf5d0");
	_tmp30_ = g_strdup ("#fce94f");
	_tmp31_ = g_strdup ("#edd400");
	_tmp32_ = g_strdup ("#c4a000");
	_tmp33_ = g_strdup ("#8b00c3");
	_tmp34_ = g_strdup ("#d50000");
	_tmp35_ = g_strdup ("#c65000");
	_tmp36_ = g_strdup ("#ff6700");
	_tmp37_ = g_strdup ("rgba(0,0,0,.25)");
	_tmp38_ = g_new0 (gchar*, 16 + 1);
	_tmp38_[0] = _tmp22_;
	_tmp38_[1] = _tmp23_;
	_tmp38_[2] = _tmp24_;
	_tmp38_[3] = _tmp25_;
	_tmp38_[4] = _tmp26_;
	_tmp38_[5] = _tmp27_;
	_tmp38_[6] = _tmp28_;
	_tmp38_[7] = _tmp29_;
	_tmp38_[8] = _tmp30_;
	_tmp38_[9] = _tmp31_;
	_tmp38_[10] = _tmp32_;
	_tmp38_[11] = _tmp33_;
	_tmp38_[12] = _tmp34_;
	_tmp38_[13] = _tmp35_;
	_tmp38_[14] = _tmp36_;
	_tmp38_[15] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 16;
	_tmp40_ = color_scheme_new (_tmp21_, _tmp39_, 16);
	g_hash_table_insert (_tmp19_, _tmp20_, _tmp40_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = color_mapper_schemes;
	_tmp42_ = g_strdup ("ambiance");
	_tmp43_ = _ ("Ambiance");
	_tmp44_ = g_strdup ("#dfdbd2");
	_tmp45_ = g_strdup ("#dfdbd2");
	_tmp46_ = g_strdup ("#dfdbd2");
	_tmp47_ = g_strdup ("#a39f96");
	_tmp48_ = g_strdup ("#dfdbd2");
	_tmp49_ = g_strdup ("#dfdbd2");
	_tmp50_ = g_strdup ("#a39f96");
	_tmp51_ = g_strdup ("#a39f96");
	_tmp52_ = g_strdup ("#dfdbd2");
	_tmp53_ = g_strdup ("#a39f96");
	_tmp54_ = g_strdup ("#a39f96");
	_tmp55_ = g_strdup ("#dfdbd2");
	_tmp56_ = g_strdup ("#dfdbd2");
	_tmp57_ = g_strdup ("#dfdbd2");
	_tmp58_ = g_strdup ("#a39f96");
	_tmp59_ = g_strdup ("rgba(0,0,0,0)");
	_tmp60_ = g_new0 (gchar*, 16 + 1);
	_tmp60_[0] = _tmp44_;
	_tmp60_[1] = _tmp45_;
	_tmp60_[2] = _tmp46_;
	_tmp60_[3] = _tmp47_;
	_tmp60_[4] = _tmp48_;
	_tmp60_[5] = _tmp49_;
	_tmp60_[6] = _tmp50_;
	_tmp60_[7] = _tmp51_;
	_tmp60_[8] = _tmp52_;
	_tmp60_[9] = _tmp53_;
	_tmp60_[10] = _tmp54_;
	_tmp60_[11] = _tmp55_;
	_tmp60_[12] = _tmp56_;
	_tmp60_[13] = _tmp57_;
	_tmp60_[14] = _tmp58_;
	_tmp60_[15] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 16;
	_tmp62_ = color_scheme_new (_tmp43_, _tmp61_, 16);
	g_hash_table_insert (_tmp41_, _tmp42_, _tmp62_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp63_ = color_mapper_schemes;
	_tmp64_ = g_strdup ("radiance");
	_tmp65_ = _ ("Radiance");
	_tmp66_ = g_strdup ("#3c3c3c");
	_tmp67_ = g_strdup ("#3c3c3c");
	_tmp68_ = g_strdup ("#3c3c3c");
	_tmp69_ = g_strdup ("#a39f96");
	_tmp70_ = g_strdup ("#3c3c3c");
	_tmp71_ = g_strdup ("#3c3c3c");
	_tmp72_ = g_strdup ("#a39f96");
	_tmp73_ = g_strdup ("#a39f96");
	_tmp74_ = g_strdup ("#3c3c3c");
	_tmp75_ = g_strdup ("#a39f96");
	_tmp76_ = g_strdup ("#a39f96");
	_tmp77_ = g_strdup ("#3c3c3c");
	_tmp78_ = g_strdup ("#3c3c3c");
	_tmp79_ = g_strdup ("#3c3c3c");
	_tmp80_ = g_strdup ("#a39f96");
	_tmp81_ = g_strdup ("rgba(0,0,0,0)");
	_tmp82_ = g_new0 (gchar*, 16 + 1);
	_tmp82_[0] = _tmp66_;
	_tmp82_[1] = _tmp67_;
	_tmp82_[2] = _tmp68_;
	_tmp82_[3] = _tmp69_;
	_tmp82_[4] = _tmp70_;
	_tmp82_[5] = _tmp71_;
	_tmp82_[6] = _tmp72_;
	_tmp82_[7] = _tmp73_;
	_tmp82_[8] = _tmp74_;
	_tmp82_[9] = _tmp75_;
	_tmp82_[10] = _tmp76_;
	_tmp82_[11] = _tmp77_;
	_tmp82_[12] = _tmp78_;
	_tmp82_[13] = _tmp79_;
	_tmp82_[14] = _tmp80_;
	_tmp82_[15] = _tmp81_;
	_tmp83_ = _tmp82_;
	_tmp83__length1 = 16;
	_tmp84_ = color_scheme_new (_tmp65_, _tmp83_, 16);
	g_hash_table_insert (_tmp63_, _tmp64_, _tmp84_);
	_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
	_tmp85_ = color_mapper_schemes;
	_tmp86_ = g_strdup ("xosview");
	_tmp87_ = _ ("XOSView");
	_tmp88_ = g_strdup ("#2e8b57");
	_tmp89_ = g_strdup ("#ffa500");
	_tmp90_ = g_strdup ("#ffff00");
	_tmp91_ = g_strdup ("#add8e6");
	_tmp92_ = g_strdup ("#2e8b57");
	_tmp93_ = g_strdup ("#0000ff");
	_tmp94_ = g_strdup ("#ffa500");
	_tmp95_ = g_strdup ("#ff0000");
	_tmp96_ = g_strdup ("#87ceeb");
	_tmp97_ = g_strdup ("#836fff");
	_tmp98_ = g_strdup ("#0000ff");
	_tmp99_ = g_strdup ("#2e8b57");
	_tmp100_ = g_strdup ("#2e8b57");
	_tmp101_ = g_strdup ("#87ceeb");
	_tmp102_ = g_strdup ("#836fff");
	_tmp103_ = g_strdup ("rgba(127,255,212,0)");
	_tmp104_ = g_new0 (gchar*, 16 + 1);
	_tmp104_[0] = _tmp88_;
	_tmp104_[1] = _tmp89_;
	_tmp104_[2] = _tmp90_;
	_tmp104_[3] = _tmp91_;
	_tmp104_[4] = _tmp92_;
	_tmp104_[5] = _tmp93_;
	_tmp104_[6] = _tmp94_;
	_tmp104_[7] = _tmp95_;
	_tmp104_[8] = _tmp96_;
	_tmp104_[9] = _tmp97_;
	_tmp104_[10] = _tmp98_;
	_tmp104_[11] = _tmp99_;
	_tmp104_[12] = _tmp100_;
	_tmp104_[13] = _tmp101_;
	_tmp104_[14] = _tmp102_;
	_tmp104_[15] = _tmp103_;
	_tmp105_ = _tmp104_;
	_tmp105__length1 = 16;
	_tmp106_ = color_scheme_new (_tmp87_, _tmp105_, 16);
	g_hash_table_insert (_tmp85_, _tmp86_, _tmp106_);
	_tmp105_ = (_vala_array_free (_tmp105_, _tmp105__length1, (GDestroyNotify) g_free), NULL);
}


static void color_mapper_instance_init (ColorMapper * self) {
	self->priv = COLOR_MAPPER_GET_PRIVATE (self);
}


static void color_mapper_finalize (GObject* obj) {
	ColorMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOR_MAPPER, ColorMapper);
	_g_free0 (self->priv->_color_scheme);
	G_OBJECT_CLASS (color_mapper_parent_class)->finalize (obj);
}


GType color_mapper_get_type (void) {
	static volatile gsize color_mapper_type_id__volatile = 0;
	if (g_once_init_enter (&color_mapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ColorMapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) color_mapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColorMapper), 0, (GInstanceInitFunc) color_mapper_instance_init, NULL };
		GType color_mapper_type_id;
		color_mapper_type_id = g_type_register_static (G_TYPE_OBJECT, "ColorMapper", &g_define_type_info, 0);
		g_once_init_leave (&color_mapper_type_id__volatile, color_mapper_type_id);
	}
	return color_mapper_type_id__volatile;
}


static void _vala_color_mapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ColorMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COLOR_MAPPER, ColorMapper);
	switch (property_id) {
		case COLOR_MAPPER_COLOR_SCHEME:
		g_value_set_string (value, color_mapper_get_color_scheme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_color_mapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ColorMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COLOR_MAPPER, ColorMapper);
	switch (property_id) {
		case COLOR_MAPPER_COLOR_SCHEME:
		color_mapper_set_color_scheme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



