#NEXUS

BEGIN TAXA;
	DIMENSIONS NTAX = 25;
	TAXLABELS
		'RUFESCENS' 'SORENSENI' 'WALALLENSIS' 'KAMTSCHATKANA' 'SIEBOLDII' 'DISCUS_HANNAI' 'GIGANTEA' 'CORRUGATA' 'CRACHERODII' 'FULGENS' 'ROEI' 'SCALARIS' 'LAEVIGATA' 'CYCLOBATES' 'RUBRA' 'CONICOPORA' 'PUSTULATA' 'MIDAE' 'OVINA' 'DIVERSICOLOR' 'VARIA' 'AUSTRALIS' 'TUBERCULATA' 'COCCINEA' 'IRIS' ;
END;

BEGIN CHARACTERS;
	DIMENSIONS NCHAR = 402;
	FORMAT
		DATATYPE = DNA
		GAP=-
		MISSING=?
	;

MATRIX
	'RUFESCENS'      CGCAGCTGGCATTATGTTGAACCCAAGTTTTTAAACAAGGCTTTTGAAGTTGCACTGAAGGTACAGATCATTGCTGGATTCGATAGAGGGCTGGTCAAATGGCTTAGAGTTCATGGCAGAACATTGTCTACCGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGGCGAATTACATGCTCTGGATAAATAAGAAGATCGATGCACTGGGCAGAACTCCAGTTGTTGGTGACTACACACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGCTTACTTTTACGACTTCCTGAAAGATAAGAACATGATCCCAAAATATCTGCCATACATGGAAGAAATTAATAGAATGCGCCCGGCAGATGTCCCAGTTAAATACATG
	'SORENSENI'      CGCCGCTGGCATTATGTTCCACCCAAGTTTTTAAACAAGGCTTTTGAAGTTGCACTGAAGGTACAGATCATTGCTGGATTCGATAGAACGCTGGTCAAATGGCTTAGAACTCATGGCGGAACATTGTCTCACGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGGCGAACTACATGCTCTGGATAAATAAGAAGACCGATGCACTGGGCAGAACTCCAGTTGTTGGTGACTACACACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGATTACTTTTACAACTTCCTGAAAGGGAGGAACATGATCCCAAAATATCTGCCATACATGGAAGAAATTAATAGAATGCGCTCGGCAGATATCCCAGTTAAATACATG
	'WALALLENSIS'    CGCCGCTGGAATTTTGTTACACCCAGGGAGGTAAACAAGGCTTTTGAAGTTGCACTGAAGGTACAGATCATTGCTGGATTCGATAGAACGCTGGTCAAATGGCTTAGAGCTCATGGCAGATCATTGTCTCACGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGGCGAATTACATGCTCTGGGTAAATAAGAAGATCGATGCACTGGGCAGAACTGCAGTTGTTGCTGACTACACACGGTTAGGTGCCGAAATTGGAAGACGTATTGACATGGATTACTTTTACAACTTCCTGAAAGGAAGGAACATGATCCCAAAATATCTGCCATACATGGAAGAAATTAATAGAATGCGCTCGGCAGATATCCCAATTAGATAC---
	'KAMTSCHATKANA'  CGCAGCTGGACTTATGTTCAACCCAAGTTTTTAAACAAGGCTTTTGAAGTTGCACTGAAGGAAGAGATCATTGTTCGATGGGATAGAAAGCTGGCCAAATGGCTTAGAGTTAATGGCGGACCATTGTCTCACGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGGCGAATTACATGCTCTGGATAAATAAGAAGACCGATGCACTGGGCAGAACTCCAGTTGTTGGTGACTACAGACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGTTTTCTTTTACAAATTCCTGTCAGGGAGGAACATGATCCCAAAATATATGCCATACATGGAGCAGATTAATAGAATGCGCGCGGCAGATATCCCAGTTAAATACATG
	'SIEBOLDII'      CGCCGCTGGCATTTTGTTCAACATCAGTATGTAGACAAGGCTTTTGAAATTGCACTGAAGGAAGAGATCGTTGCTGGATTCGACAGAACGCTGGTCAAATGGCTTAGAGTTCATGGCAGAGGTTTGACTCCAGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGATAGTCAAGAAGATCGATGCACTGGGCAGAACTCCAGTTGTTGGTGACTACAGACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGATTATTTTTACAACTTCCTGAAAAATAGGAACATGATCCCAAAATATATGCCATACATGGAAGAACTTAATAGAATGCCCGCGAGAGATATCCCAGTTAAAAAC---
	'DISCUS_HANNAI'  CGCCGCTGGAATTTTGTTCGACATCAGTATGTAAACAAGGCTTTTGAAATTGCACTGAAGGAAGAGATCGTTGCTGGATTCGATAGAACGCTGAACAAATGGCTTAGCGCTCATGGCAGAGGTTTGACTCCAGATCAGAGGAAGGCGCTGTTCTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGGTAGTGAAGAAGATCGATGCACTGGGCAGAACTCCAGTTGTTGCTGACTACAGACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGATTATTTTTACAACTTCCTGAAAAATAGGAACATGATCCCAAAATATGTGAGATACATGGCCGCACTTAATAGAATGCCAGCGAGAGATATCCCAGTTAAAAAC---
	'GIGANTEA'       CGCCGCTGGAATTTTGTTCGACATCAGTATGTAAACAAGGCTTTTGAAATTGCACTGAAGGAAGAGATCGTTGCTGGATTCGATAGAACGCTGAACAAATGGCTTAGCGCTCATGGCAGAGGTTTGACTCCAGATCAGAGGAAGGCGCTGTTCTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGGTAGTGAAGAAGATCGATGCACTGGGCAGAACTCCAGTTGTTGCTGACTACAGACGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGATTATTTTTACAACTTCCTGAAAAATAGGAACATGATCCCAAAATATGTGGGATACATGGCCGAACTTAATAGAATGCCAGCGAGAGATATCCCAGTTAAAAAC---
	'CORRUGATA'      CGCCGCTTCCGTTTTATTCCACATAAGTATATACGCAAGGAGTTTGAAGTTGCACTGAAGGTAGAGATCATTGCCGGATTCGATAGAACGCTGGTCAAATGGCTTAGAGTTCATGGCGGACGTTTGAGTACAGTTCAGAAGAAGGCGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGATAGTGAGGAAGACCGATGCACTGGGCAGACCTCCAGTTGTTGCTGACTACAGTCGGTTAGGTGCCGAAATTGGAAGACGTATTGATATGGCATATTTTTACAACTTCCTGAACGGGAGGAACATGATCCCAAAATATCTGCCATACATGGAGGAAATTAATAGAATGCGCCCGGCAGATGTCCCAGTTGCAAAC---
	'CRACHERODII'    CGCCGCTATCAATTTGTTCAACATCAGTATATTCGCAAGGCTTTTGAAGTTGCACTGAAGGTAGAGATCATTGCTGGATTCGACAGAACGCTGGTCAAATGGCTTAGAAATCATGGCAGAGGTTTGAATGAAAATCAGAGGAAGGTGCTGTACTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGATAGTGAAGAAGACCAATGCACTGGGCAGACCTCCAGTTGTTGCTGACTACCGTGCGTTGGGTGCCGAAATTGGAAGACGTATTGATATGGGATATTTTTACAACTTCCTGAAAAATAGGGTCATGATCCCAAAATATTTGCCATACATGCGAAGACTTAATAATATGCGCCCGGAAGATGTCCCAGTTGCAAACAAC
	'FULGENS'        CGCCGATGGACTTTTGTTCGATATCATTATATAAACAAGGCTTATGAAGTTACAATGAAGATACAGATCATTTCTGGATTCGATAGACAGCTGACCGCATGGCTCAGAGTTCATGGCAGACGTTTGACTAATAATCAGAAGAAGACGCTGTTCTTCGTCAATAGACGTTACATGCAGACCCACTGGCAGAATTACATGCTCTGGGTTAAGAGGAAGATCAAGGCACTGGGCAGACCCGCAGCTGTTGGTGACTACACTCGGTTAGGTGCCGAAATAGGAAGACGTGTTGATATGGTATTTTTTTACAACTTCCTGTCCGGGAGAAAAATGATCCCACCATACAGCGCATATATGGCAAAACTTAATGCCTTGCGCCCGGCAGATGTCCCAGTTAAAAAC---
	'ROEI'           CGCCATTGGCACTTTGTTGCCCACAAACATGTTTCCAGGCCTTTTGAAGTTGCACTGAAGGTCCAGATCATTGCTGGGTTTGATAGACAGTTGGCCTCCTGGCTTCAACGTCATGGCAGGCGTTTAAGCGCAATTCAGAAGAAGACGCTGTACTTCGTTAATAGGCGTTACATGCAGACTCACTGGCAAGCTTACATGGTGTGGATAGTCAAGCAGATAGAAAAACTTGGTAGGTCACCCAACGTTGGCGACTACAGCTACGTTGGTGCCGAGATCGGAAGACGTATTCCTTTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTCAATGGCGTCAGTACATGGCAAACCTTATGGCCAAACGCGTGGAAGATATCCCAGTT---------
	'SCALARIS'       CGCCGATGGGTCTTTACGCCCCACAAACATGTTGCCAGGCAATTTGAAGTTGCACTGAAGGTCCAGATCATTGCTGGGTTTGATAGAAAGTTGGTTAACTGGCTTCGACGTCATGGCAAGTATGTGAGCGCAATTCAGAGGAAGTCGCTGTACTTCGTTAATAGGCGTTACATGCAGACTCACTGGCAAGCTTACATGGTGTGGATAGTCAAGCAAGTAGCCAAACTTGGTAGGCCACCCACCGTTAGCGACTACAGCTACGTTGGTGCCGAGATCGGAAGACGTATTCCTTTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTGAAATGCGTCAGTACATGAGAGACCTTAATGCCAAACGCGTGGAAGATATCCCAGTT---------
	'LAEVIGATA'      CGCCGATGGCACTTTGTTCCCCACACACATGTTGCCAGGCCTTTTGAAGTTGCACTGAAGGTCCAGATCATTGCTGGGTTTGATAGAAAGTTGGTTGCCTGGCTTCAACGTCATGGCAGGCATCTAAGCGCAATTCAGAAGAAGTCGCTGTACTTCGTTAATAGGCGTTACATGCAGACTCACTGGCAAGCTTACATGGTGTGGATAGCTAAGCAAGTAGCCAAACTTGGTAGGGCACCCACCGTTAACGACTACAGTCGCATTGGTGCCGAGATCGGAAGACGTATTCCTTTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTCGAATGCGTCAGTTCATGAGAGACCTTATTGCCAAACCCGTGCAAGATATCCCAATT---------
	'CYCLOBATES'     CGCCGATGGCACTTTACTGCCCACAGGAGAATTTCCAGGCGTTTTGAAGCTGCACTGAAGGTCCAGATCATTCTTGGGTTTGATAAAAAGTTGGCCACCTGGCTTGCACGTTATGGCAAGAATTTGAGCGCAATTCATAAGAAGACGCTGTACTTCTATAATAGGCGTCACATGCAGACTCACTGGCAATCCTACATGAGGTTCACAGAGAAGGATATAAGAAAACTTGGTAGGCCACCCAACAGTAACGACTACACTCGCATTGGTGCCGAGATCGGAAGACGTATTCCTATTGAATTGATGTACAGCTTTATGGTCAGGAGAAACATGATCCCTAGATGGCGTCCGTATATGGGAGTCCTTCTGTCCAAACGCAAGGAAGATATCCCAGTTAAT------
	'RUBRA'          CGCCGATGGCACTTTGTTGCCCACAGACATGTTTCCAGGCAATTTGAAGTTGCACTGAAGGTCCAGATCATGGCTGGGTTTGATAAAAAGTTGACCAATTGGCTTGCACGTCATGGCAGGAATTTGAGCCCAATTCAGAAGAAGACGCTGTACTTCGTTAATAGGCGTTACATGCAGACTCACTGGCAGATGTACATGCAGTTCATAGTCAAGGAGATAGACAAACTTGGTAGGGCACCCAACGTTAACGACTACAGTCGCGTTGGTGCCGAGATCGGAAGACGTATTCCTCTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTAGATGGCGTCAGTACATGGGAAACCTTCTGGCCAAACGCGTGGAAAATATCCCAATT---------
	'CONICOPORA'     CGCCGATGGCACTTTGTTGCCCACAGACATGTTTCCAGGCAATTTGAAGTTGCACTGAAGGTCCAGATCATGGCTGGGTTTGATAAAAAGTTGGCCAATTGGCTTGCACGTCATGGCAGGAATTTGAGCCCAATTCAGAAGAAGACGCTGTACTTCGTTAATAGGCGTTACATGCAGACTCACTGGCAGATGTACATGCAGTTCATAGTCAAGGAGATAAACAAACTTGGTAGGGCACCCAACGTTAACGACTACAGTCGCGTTGGTGCCGAGATCGGAAGACGTATTCCTCTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTAGATGGCGTCAGTACATGGGAAACCTTCTGGCCAAACGCGTGGAAAATATCCCAATT---------
	'PUSTULATA'      CGCCACTGGGGCTTTGTTCCACACAGACGTCTTGCCAGGCAATTTGAAGTTGCACTGAAGGTACAGATCATCGCTGGGTTTGATAGAAAATTGTCTGGCTGGCTTACCCGTCATGGCAGTCGTTTAAGTCCAATTCAGAGGAAGACGCTGTACTTTGTCAACAGACGTTATATGCAGACTCTCTGGCAAAACTACTTTCGGTTCGTAGCGAGGAGAATCGGCAAACTTGGAAGGGCTCCCAACGTGAACGACTACAATGCCGTAGGTGCCGAAATCGGAAGACGTGTTCCTTTGGAAGTGACCTATAGCTTTTTGGTCAGGCGAAACTTGATCCCAACTTGGCGTCAGTACATGGCAAATCTTTTGGCCAGACGTGTGGAAGATATCCCAGTT---------
	'MIDAE'          CGCCGTTTTTATTTTATTAGGCACCAGTATCTTGCCAAGCCATTTGAAGTTGCACTCAAGGTACAGATCGTTGCTGGGTTTGACAGAAAGTTGACTGCCTGGCTTCGACGTCATGGCAGCCATGTGAGCGCAATTAAGAGGAAGACGCTGTACTTCGTTAATAGACGTTACATGCAGACTCACTGGCAAGCCTACATGGTGTGGATTGTCAGGAAGATCAAAGCACTTGGAAGGCCACCCACCGTCGCAGATTACACTGCACTTGGTGCCGAGATCGGAAGACGTATTCCTTTGGAAGTAACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCTTCCTGGCGTCCGTACATGGCAAGACTTATGGCCAAACGTCCGGCAGATATCCCAATT---------
	'OVINA'          CGCCGTTGGGCCTTTATTCCCCCCACACGTATTCCCAGGGCTCATGAAGTTGCACTGAAGGTACAGATCATTGCTGGCTGGAACAGAAAGCTGGCCAACTGGCTTGCACGACATGGCAGTCGTTTGAGTGCAATTCAGAAGAAGACGCTGTACTTTGTGAACAGACGTTATATGCAGACTCACTGGCCATCCTACATGATATTTGTCAAGAAGCAGATAGCTAGACTTGGTAGGCCAGGCAACACTAACGACTACAGTCGCCTGGGTGCCGAGATCGGAAGACGTATTCCTATGGAAGTAAACTACAGCTTTCTGGTCAGGAGAAACTTGATCCCACGATGGCGTCAGTACATGGCAAACCTCATGGCCAAACGCGTGGAAGATATCCCAGTT---------
	'DIVERSICOLOR'   CGCGGTTGGGGCTATATTCCCCGCACACGTCTAAACAGGGCTTTTGAAGTTGCACTGAAGGTGCAGATCATCGCTGGGTTTGATAGAAAGCTGACCAGCTGGCTTGGACGCCATGGTAGTCGTTTGAGTGCAATTCAGAGGAAGACGCTGTACTTCGTTAACAGGCGCTATCTGCAAACTCACTGGTCAGCCTACATGGTTTGGATAAACAAGCGGATAGCCGCACTTGGTAGAACAGCCACGACTGCAGACTACAATAACCTTGGTGCCGAGATCGGAAGACGTATTCCTATGGAAGTAACATACAGCTTTTTGGTCAGGAGAAACTTGATCCCCAAATGGCGTCCATATATGGCAGCCATTATGGCCAAATCAGCGGCAGATCTTGAAGTTGCA------
	'VARIA'          CGCCGTTGGACCTTTATTCCGCGCAAACGTCTTCCGATGGCTCATGAAGTTGCATTAAAGGTAGAGATCATTGCTGGGTTCAACAAAAAACTGGACATCTGGCTTGCACGACATGGCAGTCGTTTGAGTCCAATTCAGAAGAAGACGCTGTACTTTGTGAACAGACGTTATATGCAGACTCACTGGTCTAATTACATGTTGTGGGTTAAAAGGCGGATAAATAGTCTTGGAAGGCCAGGTACTACGGCAGACTACAGAAACCTCGGTGCTGAGATTGGAAGACGTGTTCCTTTGGAATTAACCTATAGCTTTTTGGTCCGGAGAAACTTGATCCCACAATGGCGTCAGTACATGGCAGACCTTATGGCCAGACGCGTGGCAGATATCCCAGTTGCA------
	'AUSTRALIS'      CGCCGTTGGAGATTTGTTCCCCACGTACAAGTTAACAGGTCTTTTGAAGTGGCACTGAAGGTACAGATCATTGCTGGGTTTGATAGAAAGTTGACAAGCTGGCTTTCACGTCATGGGCGTCGTCTGAACGCAGTTCAGAGGAAGACGTTGTACTTCGTCAACAGACGTTACATGCAGACTCACTGGCAATCTTACATGGTGTGGATAAACAAGCAGATCGCCAAACTTGGAAGGACTGCCACCGATGCCGACTACGCTAGCGTTGGTGCCGAAATCGGAAGACGTATTCCTCTGGAACTTACCTACAGCTTTTTGGTCAGGAGAAACTTGATCCCAAGATGGCGCCCATACATGGCAGCCCTTATGGCCAAGCGCGTGCAAGATATCCCAGTTGCAAAT---
	'TUBERCULATA'    ---------------------------CACCTTACCAGGCAATTTGAAGTTGCTCTGAAGGTACAGATCATTGCTGGGTTTGATAAAAAGTTGGCTACCTGGATTAACCGTCATGGCAGTGGTTTAAGCGCAGTTCAGAAGAAGACGCTGTACTTTGTCAACAGACGTTATATGCAGACTTACTGGCAAAACTACATGCTGTTCGTAGATGAGAAGATACGAAAACTTGGAAGGGCTCCCAACGTTAACGACTACACTGCCATCGGTGCCGAAATTGGAAGACGTGTTCCTTTGCAAATAACATACCCCATTATGATCAAGTACCACATTCTTCCAAAATGGCGTCCGTACATGGGAAAAATTTTGGCCCTACGTGTGGAAGATATCCCAGTTGATTAT---
	'COCCINEA'       ---------------------------CAACTTACCAGGCAATTTGAAGTTGCTCTGAAGGTACAGATCATTGCTGGGTTTGATAAAAAGTTGGCTGCCTGGATTAACCGTCATGGCAGGGGTTTAAGTGCAGTTCAGAAGAAGACGCTGTACTTTGTCAACAGACGTTATATGCAGACTTACTGGCAAAACTACATGCTGTTCGTAGATGAGAAGATACGAAAACTTGGAAGGGCTCCCAACGTTAACGACTACACTGCCATCGGTGCCGAAATTGGAAGACGTGTTCCTTTGCAAATAACATACCCCATTTTGATCAAGTACAACATTCTTCCAAAATGGCATCCGTACATGGGGAAAGTTTTGAGCCTACGTGTGGAAGATATCCCAGTTGATTAT---
	'IRIS'           ---GGGTGGGGCTATCCACCAGGGACCTTTTTATCAAAAGCTAAGTTAAGTGCACTGAAGACACAGATCATTGCTGGGTTCGATAGAAAGCTGGCCAGTTGGCTTAGACGTCATGGCAATCGTTTGAGCGCAATTCAGAAGAAGACGCTGTACTTCGTCAATAGACGTTACATGCAGACTCACTGGCGCTCTTACATGAAATTCGTACGAAATCAGATGAAATTACTTGGTAGAGCTGAAACCACTGCGGACTACAATCGCGTAGGTGCCGCAATTGGAAAACGCATTCCCTTGGAAATAACGTACAGCTTTTTAGTCAGGAGGAACTTGATACCTAAATGGAAACCGTACATGGCACGACTTATGGCCAGACGCCCAGGTGATATCCCAACTTCG------;
END;

BEGIN TREES;
	TREE tree = ((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);
END;

BEGIN HYPHY;

/* test preamble */

	_testDescription 		= " fit the general bivariate MG94xREV model with 5 rate classes to a lysin alignment.";
	_expectedLL 			= -4342.96;
	ExecuteAFile 			("../Shared/TestInstrumentation.bf");
	startTestTimer 			(_testDescription);

/* end test preamble */


global codonFactor=1;
global S_0=0.5;
S_0:>1e-07;
global S_1=1.342438557686713;
global S_2=1.462721607130293;
global S_3=0.006904038502130698;
global P_3=0.501243626308445;
P_3:<1;
global P_1=0.2971856621456794;
P_1:<1;
global S_4=0.0109507280714569;
global P_4=0.5698460657243346;
P_4:<1;
global P_2=0.4830442031378996;
P_2:<1;
global R_0=0.08222210929495997;
global CT=0.6291171928769415;
global AT=0.4609446887622178;
global CG=0.6064196635287339;
global AC=0.7886604510211515;
global NS_4=1.698773849849638;
global GT=0.2558607550004903;
global NS_3=0.3303428965899049;
global NS_2=2.741773900106499;
global NS_1=1.032408633517949;
global NS_0:=R_0*S_0;
global c_scale:=P_1*S_0+(1-P_1)*P_2*S_1+(1-P_1)*(1-P_2)*P_3*S_2+(1-P_1)*(1-P_2)*(1-P_3)*P_4*S_3+(1-P_1)*(1-P_2)*(1-P_3)*(1-P_4)*S_4;

rate_matrix_0={61,61};
rate_matrix_0[0][1]:=NS_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[0][2]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[0][3]:=NS_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[0][4]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[0][8]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[0][12]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[0][16]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[0][32]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[1][0]:=NS_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[1][2]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[1][3]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[1][5]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[1][9]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[1][13]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[1][17]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[1][33]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[1][48]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[2][0]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[2][1]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[2][3]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[2][6]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[2][10]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[2][14]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[2][18]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[2][34]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[3][0]:=NS_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[3][1]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[3][2]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[3][7]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[3][11]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[3][15]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[3][19]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[3][35]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[3][49]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[4][0]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[4][5]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[4][6]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[4][7]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[4][8]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[4][12]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[4][20]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[4][36]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[4][50]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[5][1]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[5][4]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[5][6]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[5][7]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[5][9]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[5][13]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[5][21]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[5][37]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[5][51]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[6][2]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[6][4]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[6][5]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[6][7]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[6][10]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[6][14]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[6][22]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[6][38]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[6][52]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[7][3]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[7][4]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[7][5]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[7][6]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[7][11]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[7][15]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[7][23]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[7][39]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[7][53]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[8][0]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[8][4]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[8][9]:=NS_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[8][10]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[8][11]:=NS_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[8][12]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[8][24]:=S_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[8][40]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[9][1]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[9][5]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[9][8]:=NS_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[9][10]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[9][11]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[9][13]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[9][25]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[9][41]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[9][54]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[10][2]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[10][6]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[10][8]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[10][9]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[10][11]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[10][14]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[10][26]:=S_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[10][42]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[10][55]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[11][3]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[11][7]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[11][8]:=NS_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[11][9]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[11][10]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[11][15]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[11][27]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[11][43]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[11][56]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[12][0]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[12][4]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[12][8]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[12][13]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[12][14]:=NS_0/c_scale*synRate*0.260597;
rate_matrix_0[12][15]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[12][28]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[12][44]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[12][57]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[13][1]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[13][5]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[13][9]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[13][12]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[13][14]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[13][15]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[13][29]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[13][45]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[13][58]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[14][2]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[14][6]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[14][10]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[14][12]:=NS_0/c_scale*synRate*0.210149;
rate_matrix_0[14][13]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[14][15]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[14][30]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[14][46]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[14][59]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[15][3]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[15][7]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[15][11]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[15][12]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[15][13]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[15][14]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[15][31]:=NS_0/c_scale*AC*synRate*0.223284;
rate_matrix_0[15][47]:=NS_0/c_scale*synRate*0.264776;
rate_matrix_0[15][60]:=NS_0/c_scale*AT*synRate*0.171642;
rate_matrix_0[16][0]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[16][17]:=NS_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[16][18]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[16][19]:=NS_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[16][20]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[16][24]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[16][28]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[16][32]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[17][1]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[17][16]:=NS_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[17][18]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[17][19]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[17][21]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[17][25]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[17][29]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[17][33]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[17][48]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[18][2]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[18][16]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[18][17]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[18][19]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[18][22]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[18][26]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[18][30]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[18][34]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[19][3]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[19][16]:=NS_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[19][17]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[19][18]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[19][23]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[19][27]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[19][31]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[19][35]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[19][49]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[20][4]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[20][16]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[20][21]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[20][22]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[20][23]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[20][24]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[20][28]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[20][36]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[20][50]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[21][5]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[21][17]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[21][20]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[21][22]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[21][23]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[21][25]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[21][29]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[21][37]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[21][51]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[22][6]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[22][18]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[22][20]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[22][21]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[22][23]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[22][26]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[22][30]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[22][38]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[22][52]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[23][7]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[23][19]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[23][20]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[23][21]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[23][22]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[23][27]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[23][31]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[23][39]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[23][53]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[24][8]:=S_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[24][16]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[24][20]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[24][25]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[24][26]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[24][27]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[24][28]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[24][40]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[25][9]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[25][17]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[25][21]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[25][24]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[25][26]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[25][27]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[25][29]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[25][41]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[25][54]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[26][10]:=S_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[26][18]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[26][22]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[26][24]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[26][25]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[26][27]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[26][30]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[26][42]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[26][55]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[27][11]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[27][19]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[27][23]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[27][24]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[27][25]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[27][26]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[27][31]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[27][43]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[27][56]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[28][12]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[28][16]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[28][20]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[28][24]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[28][29]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[28][30]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[28][31]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[28][44]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[28][57]:=S_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[29][13]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[29][17]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[29][21]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[29][25]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[29][28]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[29][30]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[29][31]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[29][45]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[29][58]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[30][14]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[30][18]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[30][22]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[30][26]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[30][28]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[30][29]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[30][31]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[30][46]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[30][59]:=S_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[31][15]:=NS_0/c_scale*AC*synRate*0.340299;
rate_matrix_0[31][19]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[31][23]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[31][27]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[31][28]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[31][29]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[31][30]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[31][47]:=NS_0/c_scale*CG*synRate*0.264776;
rate_matrix_0[31][60]:=NS_0/c_scale*CT*synRate*0.171642;
rate_matrix_0[32][0]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[32][16]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[32][33]:=NS_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[32][34]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[32][35]:=NS_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[32][36]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[32][40]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[32][44]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[33][1]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[33][17]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[33][32]:=NS_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[33][34]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[33][35]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[33][37]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[33][41]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[33][45]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[33][48]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[34][2]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[34][18]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[34][32]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[34][33]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[34][35]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[34][38]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[34][42]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[34][46]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[35][3]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[35][19]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[35][32]:=NS_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[35][33]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[35][34]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[35][39]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[35][43]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[35][47]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[35][49]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[36][4]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[36][20]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[36][32]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[36][37]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[36][38]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[36][39]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[36][40]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[36][44]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[36][50]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[37][5]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[37][21]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[37][33]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[37][36]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[37][38]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[37][39]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[37][41]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[37][45]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[37][51]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[38][6]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[38][22]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[38][34]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[38][36]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[38][37]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[38][39]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[38][42]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[38][46]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[38][52]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[39][7]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[39][23]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[39][35]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[39][36]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[39][37]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[39][38]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[39][43]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[39][47]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[39][53]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[40][8]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[40][24]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[40][32]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[40][36]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[40][41]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[40][42]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[40][43]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[40][44]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[41][9]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[41][25]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[41][33]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[41][37]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[41][40]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[41][42]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[41][43]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[41][45]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[41][54]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[42][10]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[42][26]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[42][34]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[42][38]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[42][40]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[42][41]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[42][43]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[42][46]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[42][55]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[43][11]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[43][27]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[43][35]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[43][39]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[43][40]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[43][41]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[43][42]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[43][47]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[43][56]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[44][12]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[44][28]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[44][32]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[44][36]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[44][40]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[44][45]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[44][46]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[44][47]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[44][57]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[45][13]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[45][29]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[45][33]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[45][37]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[45][41]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[45][44]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[45][46]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[45][47]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[45][58]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[46][14]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[46][30]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[46][34]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[46][38]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[46][42]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[46][44]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[46][45]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[46][47]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[46][59]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[47][15]:=NS_0/c_scale*synRate*0.340299;
rate_matrix_0[47][31]:=NS_0/c_scale*CG*synRate*0.223284;
rate_matrix_0[47][35]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[47][39]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[47][43]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[47][44]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[47][45]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[47][46]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[47][60]:=NS_0/c_scale*GT*synRate*0.171642;
rate_matrix_0[48][1]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[48][17]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[48][33]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[48][49]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[48][51]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[48][54]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[48][58]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[49][3]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[49][19]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[49][35]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[49][48]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[49][53]:=NS_0/c_scale*AC*synRate*0.166866;
rate_matrix_0[49][56]:=NS_0/c_scale*synRate*0.221194;
rate_matrix_0[49][60]:=NS_0/c_scale*AT*synRate*0.306866;
rate_matrix_0[50][4]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[50][20]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[50][36]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[50][51]:=S_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[50][52]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[50][53]:=S_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[50][57]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[51][5]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[51][21]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[51][37]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[51][48]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[51][50]:=S_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[51][52]:=S_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[51][53]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[51][54]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[51][58]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[52][6]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[52][22]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[52][38]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[52][50]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[52][51]:=S_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[52][53]:=S_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[52][55]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[52][59]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[53][7]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[53][23]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[53][39]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[53][49]:=NS_0/c_scale*AC*synRate*0.305075;
rate_matrix_0[53][50]:=S_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[53][51]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[53][52]:=S_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[53][56]:=NS_0/c_scale*CG*synRate*0.221194;
rate_matrix_0[53][60]:=NS_0/c_scale*CT*synRate*0.306866;
rate_matrix_0[54][9]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[54][25]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[54][41]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[54][48]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[54][51]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[54][55]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[54][56]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[54][58]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[55][10]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[55][26]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[55][42]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[55][52]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[55][54]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[55][56]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[55][59]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[56][11]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[56][27]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[56][43]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[56][49]:=NS_0/c_scale*synRate*0.305075;
rate_matrix_0[56][53]:=NS_0/c_scale*CG*synRate*0.166866;
rate_matrix_0[56][54]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[56][55]:=NS_0/c_scale*GT*synRate*0.260597;
rate_matrix_0[56][60]:=NS_0/c_scale*GT*synRate*0.306866;
rate_matrix_0[57][12]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[57][28]:=S_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[57][44]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[57][50]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[57][58]:=NS_0/c_scale*AC*synRate*0.250149;
rate_matrix_0[57][59]:=S_0/c_scale*synRate*0.260597;
rate_matrix_0[57][60]:=NS_0/c_scale*AT*synRate*0.279104;
rate_matrix_0[58][13]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[58][29]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[58][45]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[58][48]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[58][51]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[58][54]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[58][57]:=NS_0/c_scale*AC*synRate*0.210149;
rate_matrix_0[58][59]:=NS_0/c_scale*CG*synRate*0.260597;
rate_matrix_0[58][60]:=S_0/c_scale*CT*synRate*0.279104;
rate_matrix_0[59][14]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[59][30]:=S_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[59][46]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[59][52]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[59][55]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[59][57]:=S_0/c_scale*synRate*0.210149;
rate_matrix_0[59][58]:=NS_0/c_scale*CG*synRate*0.250149;
rate_matrix_0[59][60]:=NS_0/c_scale*GT*synRate*0.279104;
rate_matrix_0[60][15]:=NS_0/c_scale*AT*synRate*0.340299;
rate_matrix_0[60][31]:=NS_0/c_scale*CT*synRate*0.223284;
rate_matrix_0[60][47]:=NS_0/c_scale*GT*synRate*0.264776;
rate_matrix_0[60][49]:=NS_0/c_scale*AT*synRate*0.305075;
rate_matrix_0[60][53]:=NS_0/c_scale*CT*synRate*0.166866;
rate_matrix_0[60][56]:=NS_0/c_scale*GT*synRate*0.221194;
rate_matrix_0[60][57]:=NS_0/c_scale*AT*synRate*0.210149;
rate_matrix_0[60][58]:=S_0/c_scale*CT*synRate*0.250149;
rate_matrix_0[60][59]:=NS_0/c_scale*GT*synRate*0.260597;

vectorOfFrequencies={
{   0.0225528119491}
{   0.0268455346781}
{   0.0279667682267}
{   0.0299529533699}
{   0.0123356378469}
{   0.0146836143689}
{   0.0152968918187}
{   0.0163832690154}
{   0.0163518920296}
{   0.0194643260239}
{   0.0202772752015}
{   0.0217173566019}
{   0.0226852159332}
{   0.0270031405568}
{   0.0281309566898}
{   0.0301288024112}
{   0.0147978099456}
{   0.0176144385432}
{   0.0183501251172}
{    0.019653341334}
{  0.00809390974518}
{  0.00963451188417}
{   0.0100369079653}
{   0.0107497238803}
{   0.0107291361738}
{   0.0127713297069}
{   0.0133047384656}
{   0.0142496339809}
{   0.0148846855421}
{   0.0177178501197}
{    0.018457855793}
{   0.0197687229856}
{   0.0175476703499}
{   0.0208877098767}
{   0.0217601082606}
{   0.0233054996834}
{   0.0095979919037}
{   0.0114248824081}
{    0.011902055301}
{   0.0127473329971}
{   0.0127229195003}
{   0.0151446115642}
{   0.0157771430735}
{   0.0168976274613}
{    0.017650689941}
{   0.0210103383104}
{   0.0218878584069}
{   0.0234423225779}
{   0.0135405109122}
{   0.0151078492875}
{  0.00622192259823}
{  0.00740620900187}
{  0.00771553754013}
{  0.00826349095077}
{  0.00981753286294}
{   0.0102275730183}
{    0.010953929865}
{   0.0114421045277}
{   0.0136200051054}
{   0.0141888597339}
{   0.0151965450758}
}
;
Model MG94model_0=(rate_matrix_0,vectorOfFrequencies,0);
rate_matrix_1={61,61};
rate_matrix_1[0][1]:=NS_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[0][2]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[0][3]:=NS_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[0][4]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[0][8]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[0][12]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[0][16]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[0][32]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[1][0]:=NS_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[1][2]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[1][3]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[1][5]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[1][9]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[1][13]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[1][17]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[1][33]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[1][48]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[2][0]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[2][1]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[2][3]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[2][6]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[2][10]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[2][14]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[2][18]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[2][34]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[3][0]:=NS_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[3][1]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[3][2]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[3][7]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[3][11]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[3][15]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[3][19]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[3][35]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[3][49]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[4][0]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[4][5]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[4][6]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[4][7]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[4][8]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[4][12]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[4][20]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[4][36]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[4][50]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[5][1]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[5][4]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[5][6]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[5][7]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[5][9]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[5][13]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[5][21]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[5][37]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[5][51]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[6][2]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[6][4]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[6][5]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[6][7]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[6][10]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[6][14]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[6][22]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[6][38]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[6][52]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[7][3]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[7][4]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[7][5]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[7][6]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[7][11]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[7][15]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[7][23]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[7][39]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[7][53]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[8][0]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[8][4]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[8][9]:=NS_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[8][10]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[8][11]:=NS_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[8][12]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[8][24]:=S_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[8][40]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[9][1]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[9][5]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[9][8]:=NS_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[9][10]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[9][11]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[9][13]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[9][25]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[9][41]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[9][54]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[10][2]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[10][6]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[10][8]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[10][9]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[10][11]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[10][14]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[10][26]:=S_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[10][42]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[10][55]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[11][3]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[11][7]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[11][8]:=NS_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[11][9]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[11][10]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[11][15]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[11][27]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[11][43]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[11][56]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[12][0]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[12][4]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[12][8]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[12][13]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[12][14]:=NS_1/c_scale*synRate*0.260597;
rate_matrix_1[12][15]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[12][28]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[12][44]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[12][57]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[13][1]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[13][5]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[13][9]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[13][12]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[13][14]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[13][15]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[13][29]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[13][45]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[13][58]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[14][2]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[14][6]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[14][10]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[14][12]:=NS_1/c_scale*synRate*0.210149;
rate_matrix_1[14][13]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[14][15]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[14][30]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[14][46]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[14][59]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[15][3]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[15][7]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[15][11]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[15][12]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[15][13]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[15][14]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[15][31]:=NS_1/c_scale*AC*synRate*0.223284;
rate_matrix_1[15][47]:=NS_1/c_scale*synRate*0.264776;
rate_matrix_1[15][60]:=NS_1/c_scale*AT*synRate*0.171642;
rate_matrix_1[16][0]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[16][17]:=NS_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[16][18]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[16][19]:=NS_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[16][20]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[16][24]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[16][28]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[16][32]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[17][1]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[17][16]:=NS_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[17][18]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[17][19]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[17][21]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[17][25]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[17][29]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[17][33]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[17][48]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[18][2]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[18][16]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[18][17]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[18][19]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[18][22]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[18][26]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[18][30]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[18][34]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[19][3]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[19][16]:=NS_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[19][17]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[19][18]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[19][23]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[19][27]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[19][31]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[19][35]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[19][49]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[20][4]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[20][16]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[20][21]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[20][22]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[20][23]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[20][24]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[20][28]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[20][36]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[20][50]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[21][5]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[21][17]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[21][20]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[21][22]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[21][23]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[21][25]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[21][29]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[21][37]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[21][51]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[22][6]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[22][18]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[22][20]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[22][21]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[22][23]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[22][26]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[22][30]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[22][38]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[22][52]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[23][7]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[23][19]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[23][20]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[23][21]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[23][22]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[23][27]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[23][31]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[23][39]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[23][53]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[24][8]:=S_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[24][16]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[24][20]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[24][25]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[24][26]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[24][27]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[24][28]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[24][40]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[25][9]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[25][17]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[25][21]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[25][24]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[25][26]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[25][27]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[25][29]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[25][41]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[25][54]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[26][10]:=S_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[26][18]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[26][22]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[26][24]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[26][25]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[26][27]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[26][30]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[26][42]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[26][55]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[27][11]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[27][19]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[27][23]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[27][24]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[27][25]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[27][26]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[27][31]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[27][43]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[27][56]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[28][12]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[28][16]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[28][20]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[28][24]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[28][29]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[28][30]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[28][31]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[28][44]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[28][57]:=S_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[29][13]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[29][17]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[29][21]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[29][25]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[29][28]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[29][30]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[29][31]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[29][45]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[29][58]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[30][14]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[30][18]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[30][22]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[30][26]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[30][28]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[30][29]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[30][31]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[30][46]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[30][59]:=S_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[31][15]:=NS_1/c_scale*AC*synRate*0.340299;
rate_matrix_1[31][19]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[31][23]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[31][27]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[31][28]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[31][29]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[31][30]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[31][47]:=NS_1/c_scale*CG*synRate*0.264776;
rate_matrix_1[31][60]:=NS_1/c_scale*CT*synRate*0.171642;
rate_matrix_1[32][0]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[32][16]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[32][33]:=NS_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[32][34]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[32][35]:=NS_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[32][36]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[32][40]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[32][44]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[33][1]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[33][17]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[33][32]:=NS_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[33][34]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[33][35]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[33][37]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[33][41]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[33][45]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[33][48]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[34][2]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[34][18]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[34][32]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[34][33]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[34][35]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[34][38]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[34][42]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[34][46]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[35][3]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[35][19]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[35][32]:=NS_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[35][33]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[35][34]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[35][39]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[35][43]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[35][47]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[35][49]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[36][4]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[36][20]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[36][32]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[36][37]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[36][38]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[36][39]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[36][40]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[36][44]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[36][50]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[37][5]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[37][21]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[37][33]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[37][36]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[37][38]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[37][39]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[37][41]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[37][45]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[37][51]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[38][6]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[38][22]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[38][34]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[38][36]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[38][37]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[38][39]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[38][42]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[38][46]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[38][52]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[39][7]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[39][23]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[39][35]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[39][36]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[39][37]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[39][38]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[39][43]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[39][47]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[39][53]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[40][8]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[40][24]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[40][32]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[40][36]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[40][41]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[40][42]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[40][43]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[40][44]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[41][9]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[41][25]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[41][33]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[41][37]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[41][40]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[41][42]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[41][43]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[41][45]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[41][54]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[42][10]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[42][26]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[42][34]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[42][38]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[42][40]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[42][41]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[42][43]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[42][46]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[42][55]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[43][11]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[43][27]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[43][35]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[43][39]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[43][40]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[43][41]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[43][42]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[43][47]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[43][56]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[44][12]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[44][28]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[44][32]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[44][36]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[44][40]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[44][45]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[44][46]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[44][47]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[44][57]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[45][13]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[45][29]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[45][33]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[45][37]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[45][41]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[45][44]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[45][46]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[45][47]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[45][58]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[46][14]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[46][30]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[46][34]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[46][38]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[46][42]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[46][44]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[46][45]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[46][47]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[46][59]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[47][15]:=NS_1/c_scale*synRate*0.340299;
rate_matrix_1[47][31]:=NS_1/c_scale*CG*synRate*0.223284;
rate_matrix_1[47][35]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[47][39]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[47][43]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[47][44]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[47][45]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[47][46]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[47][60]:=NS_1/c_scale*GT*synRate*0.171642;
rate_matrix_1[48][1]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[48][17]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[48][33]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[48][49]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[48][51]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[48][54]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[48][58]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[49][3]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[49][19]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[49][35]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[49][48]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[49][53]:=NS_1/c_scale*AC*synRate*0.166866;
rate_matrix_1[49][56]:=NS_1/c_scale*synRate*0.221194;
rate_matrix_1[49][60]:=NS_1/c_scale*AT*synRate*0.306866;
rate_matrix_1[50][4]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[50][20]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[50][36]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[50][51]:=S_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[50][52]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[50][53]:=S_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[50][57]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[51][5]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[51][21]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[51][37]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[51][48]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[51][50]:=S_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[51][52]:=S_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[51][53]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[51][54]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[51][58]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[52][6]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[52][22]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[52][38]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[52][50]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[52][51]:=S_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[52][53]:=S_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[52][55]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[52][59]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[53][7]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[53][23]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[53][39]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[53][49]:=NS_1/c_scale*AC*synRate*0.305075;
rate_matrix_1[53][50]:=S_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[53][51]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[53][52]:=S_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[53][56]:=NS_1/c_scale*CG*synRate*0.221194;
rate_matrix_1[53][60]:=NS_1/c_scale*CT*synRate*0.306866;
rate_matrix_1[54][9]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[54][25]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[54][41]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[54][48]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[54][51]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[54][55]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[54][56]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[54][58]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[55][10]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[55][26]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[55][42]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[55][52]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[55][54]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[55][56]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[55][59]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[56][11]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[56][27]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[56][43]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[56][49]:=NS_1/c_scale*synRate*0.305075;
rate_matrix_1[56][53]:=NS_1/c_scale*CG*synRate*0.166866;
rate_matrix_1[56][54]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[56][55]:=NS_1/c_scale*GT*synRate*0.260597;
rate_matrix_1[56][60]:=NS_1/c_scale*GT*synRate*0.306866;
rate_matrix_1[57][12]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[57][28]:=S_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[57][44]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[57][50]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[57][58]:=NS_1/c_scale*AC*synRate*0.250149;
rate_matrix_1[57][59]:=S_1/c_scale*synRate*0.260597;
rate_matrix_1[57][60]:=NS_1/c_scale*AT*synRate*0.279104;
rate_matrix_1[58][13]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[58][29]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[58][45]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[58][48]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[58][51]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[58][54]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[58][57]:=NS_1/c_scale*AC*synRate*0.210149;
rate_matrix_1[58][59]:=NS_1/c_scale*CG*synRate*0.260597;
rate_matrix_1[58][60]:=S_1/c_scale*CT*synRate*0.279104;
rate_matrix_1[59][14]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[59][30]:=S_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[59][46]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[59][52]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[59][55]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[59][57]:=S_1/c_scale*synRate*0.210149;
rate_matrix_1[59][58]:=NS_1/c_scale*CG*synRate*0.250149;
rate_matrix_1[59][60]:=NS_1/c_scale*GT*synRate*0.279104;
rate_matrix_1[60][15]:=NS_1/c_scale*AT*synRate*0.340299;
rate_matrix_1[60][31]:=NS_1/c_scale*CT*synRate*0.223284;
rate_matrix_1[60][47]:=NS_1/c_scale*GT*synRate*0.264776;
rate_matrix_1[60][49]:=NS_1/c_scale*AT*synRate*0.305075;
rate_matrix_1[60][53]:=NS_1/c_scale*CT*synRate*0.166866;
rate_matrix_1[60][56]:=NS_1/c_scale*GT*synRate*0.221194;
rate_matrix_1[60][57]:=NS_1/c_scale*AT*synRate*0.210149;
rate_matrix_1[60][58]:=S_1/c_scale*CT*synRate*0.250149;
rate_matrix_1[60][59]:=NS_1/c_scale*GT*synRate*0.260597;


Model MG94model_1=(rate_matrix_1,vectorOfFrequencies,0);
rate_matrix_2={61,61};
rate_matrix_2[0][1]:=NS_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[0][2]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[0][3]:=NS_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[0][4]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[0][8]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[0][12]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[0][16]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[0][32]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[1][0]:=NS_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[1][2]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[1][3]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[1][5]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[1][9]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[1][13]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[1][17]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[1][33]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[1][48]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[2][0]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[2][1]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[2][3]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[2][6]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[2][10]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[2][14]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[2][18]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[2][34]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[3][0]:=NS_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[3][1]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[3][2]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[3][7]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[3][11]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[3][15]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[3][19]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[3][35]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[3][49]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[4][0]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[4][5]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[4][6]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[4][7]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[4][8]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[4][12]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[4][20]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[4][36]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[4][50]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[5][1]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[5][4]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[5][6]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[5][7]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[5][9]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[5][13]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[5][21]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[5][37]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[5][51]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[6][2]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[6][4]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[6][5]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[6][7]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[6][10]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[6][14]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[6][22]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[6][38]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[6][52]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[7][3]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[7][4]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[7][5]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[7][6]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[7][11]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[7][15]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[7][23]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[7][39]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[7][53]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[8][0]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[8][4]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[8][9]:=NS_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[8][10]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[8][11]:=NS_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[8][12]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[8][24]:=S_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[8][40]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[9][1]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[9][5]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[9][8]:=NS_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[9][10]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[9][11]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[9][13]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[9][25]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[9][41]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[9][54]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[10][2]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[10][6]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[10][8]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[10][9]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[10][11]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[10][14]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[10][26]:=S_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[10][42]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[10][55]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[11][3]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[11][7]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[11][8]:=NS_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[11][9]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[11][10]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[11][15]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[11][27]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[11][43]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[11][56]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[12][0]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[12][4]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[12][8]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[12][13]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[12][14]:=NS_2/c_scale*synRate*0.260597;
rate_matrix_2[12][15]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[12][28]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[12][44]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[12][57]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[13][1]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[13][5]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[13][9]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[13][12]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[13][14]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[13][15]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[13][29]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[13][45]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[13][58]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[14][2]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[14][6]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[14][10]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[14][12]:=NS_2/c_scale*synRate*0.210149;
rate_matrix_2[14][13]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[14][15]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[14][30]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[14][46]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[14][59]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[15][3]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[15][7]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[15][11]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[15][12]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[15][13]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[15][14]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[15][31]:=NS_2/c_scale*AC*synRate*0.223284;
rate_matrix_2[15][47]:=NS_2/c_scale*synRate*0.264776;
rate_matrix_2[15][60]:=NS_2/c_scale*AT*synRate*0.171642;
rate_matrix_2[16][0]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[16][17]:=NS_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[16][18]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[16][19]:=NS_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[16][20]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[16][24]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[16][28]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[16][32]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[17][1]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[17][16]:=NS_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[17][18]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[17][19]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[17][21]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[17][25]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[17][29]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[17][33]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[17][48]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[18][2]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[18][16]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[18][17]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[18][19]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[18][22]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[18][26]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[18][30]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[18][34]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[19][3]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[19][16]:=NS_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[19][17]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[19][18]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[19][23]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[19][27]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[19][31]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[19][35]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[19][49]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[20][4]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[20][16]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[20][21]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[20][22]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[20][23]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[20][24]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[20][28]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[20][36]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[20][50]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[21][5]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[21][17]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[21][20]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[21][22]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[21][23]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[21][25]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[21][29]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[21][37]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[21][51]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[22][6]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[22][18]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[22][20]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[22][21]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[22][23]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[22][26]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[22][30]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[22][38]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[22][52]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[23][7]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[23][19]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[23][20]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[23][21]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[23][22]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[23][27]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[23][31]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[23][39]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[23][53]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[24][8]:=S_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[24][16]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[24][20]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[24][25]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[24][26]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[24][27]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[24][28]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[24][40]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[25][9]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[25][17]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[25][21]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[25][24]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[25][26]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[25][27]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[25][29]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[25][41]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[25][54]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[26][10]:=S_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[26][18]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[26][22]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[26][24]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[26][25]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[26][27]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[26][30]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[26][42]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[26][55]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[27][11]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[27][19]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[27][23]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[27][24]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[27][25]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[27][26]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[27][31]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[27][43]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[27][56]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[28][12]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[28][16]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[28][20]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[28][24]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[28][29]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[28][30]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[28][31]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[28][44]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[28][57]:=S_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[29][13]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[29][17]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[29][21]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[29][25]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[29][28]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[29][30]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[29][31]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[29][45]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[29][58]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[30][14]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[30][18]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[30][22]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[30][26]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[30][28]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[30][29]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[30][31]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[30][46]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[30][59]:=S_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[31][15]:=NS_2/c_scale*AC*synRate*0.340299;
rate_matrix_2[31][19]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[31][23]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[31][27]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[31][28]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[31][29]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[31][30]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[31][47]:=NS_2/c_scale*CG*synRate*0.264776;
rate_matrix_2[31][60]:=NS_2/c_scale*CT*synRate*0.171642;
rate_matrix_2[32][0]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[32][16]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[32][33]:=NS_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[32][34]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[32][35]:=NS_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[32][36]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[32][40]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[32][44]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[33][1]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[33][17]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[33][32]:=NS_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[33][34]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[33][35]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[33][37]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[33][41]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[33][45]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[33][48]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[34][2]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[34][18]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[34][32]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[34][33]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[34][35]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[34][38]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[34][42]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[34][46]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[35][3]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[35][19]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[35][32]:=NS_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[35][33]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[35][34]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[35][39]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[35][43]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[35][47]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[35][49]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[36][4]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[36][20]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[36][32]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[36][37]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[36][38]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[36][39]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[36][40]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[36][44]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[36][50]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[37][5]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[37][21]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[37][33]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[37][36]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[37][38]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[37][39]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[37][41]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[37][45]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[37][51]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[38][6]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[38][22]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[38][34]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[38][36]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[38][37]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[38][39]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[38][42]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[38][46]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[38][52]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[39][7]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[39][23]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[39][35]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[39][36]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[39][37]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[39][38]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[39][43]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[39][47]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[39][53]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[40][8]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[40][24]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[40][32]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[40][36]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[40][41]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[40][42]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[40][43]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[40][44]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[41][9]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[41][25]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[41][33]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[41][37]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[41][40]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[41][42]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[41][43]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[41][45]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[41][54]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[42][10]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[42][26]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[42][34]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[42][38]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[42][40]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[42][41]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[42][43]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[42][46]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[42][55]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[43][11]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[43][27]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[43][35]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[43][39]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[43][40]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[43][41]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[43][42]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[43][47]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[43][56]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[44][12]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[44][28]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[44][32]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[44][36]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[44][40]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[44][45]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[44][46]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[44][47]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[44][57]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[45][13]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[45][29]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[45][33]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[45][37]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[45][41]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[45][44]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[45][46]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[45][47]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[45][58]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[46][14]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[46][30]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[46][34]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[46][38]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[46][42]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[46][44]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[46][45]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[46][47]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[46][59]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[47][15]:=NS_2/c_scale*synRate*0.340299;
rate_matrix_2[47][31]:=NS_2/c_scale*CG*synRate*0.223284;
rate_matrix_2[47][35]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[47][39]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[47][43]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[47][44]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[47][45]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[47][46]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[47][60]:=NS_2/c_scale*GT*synRate*0.171642;
rate_matrix_2[48][1]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[48][17]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[48][33]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[48][49]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[48][51]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[48][54]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[48][58]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[49][3]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[49][19]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[49][35]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[49][48]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[49][53]:=NS_2/c_scale*AC*synRate*0.166866;
rate_matrix_2[49][56]:=NS_2/c_scale*synRate*0.221194;
rate_matrix_2[49][60]:=NS_2/c_scale*AT*synRate*0.306866;
rate_matrix_2[50][4]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[50][20]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[50][36]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[50][51]:=S_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[50][52]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[50][53]:=S_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[50][57]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[51][5]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[51][21]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[51][37]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[51][48]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[51][50]:=S_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[51][52]:=S_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[51][53]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[51][54]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[51][58]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[52][6]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[52][22]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[52][38]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[52][50]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[52][51]:=S_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[52][53]:=S_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[52][55]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[52][59]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[53][7]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[53][23]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[53][39]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[53][49]:=NS_2/c_scale*AC*synRate*0.305075;
rate_matrix_2[53][50]:=S_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[53][51]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[53][52]:=S_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[53][56]:=NS_2/c_scale*CG*synRate*0.221194;
rate_matrix_2[53][60]:=NS_2/c_scale*CT*synRate*0.306866;
rate_matrix_2[54][9]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[54][25]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[54][41]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[54][48]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[54][51]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[54][55]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[54][56]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[54][58]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[55][10]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[55][26]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[55][42]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[55][52]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[55][54]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[55][56]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[55][59]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[56][11]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[56][27]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[56][43]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[56][49]:=NS_2/c_scale*synRate*0.305075;
rate_matrix_2[56][53]:=NS_2/c_scale*CG*synRate*0.166866;
rate_matrix_2[56][54]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[56][55]:=NS_2/c_scale*GT*synRate*0.260597;
rate_matrix_2[56][60]:=NS_2/c_scale*GT*synRate*0.306866;
rate_matrix_2[57][12]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[57][28]:=S_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[57][44]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[57][50]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[57][58]:=NS_2/c_scale*AC*synRate*0.250149;
rate_matrix_2[57][59]:=S_2/c_scale*synRate*0.260597;
rate_matrix_2[57][60]:=NS_2/c_scale*AT*synRate*0.279104;
rate_matrix_2[58][13]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[58][29]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[58][45]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[58][48]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[58][51]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[58][54]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[58][57]:=NS_2/c_scale*AC*synRate*0.210149;
rate_matrix_2[58][59]:=NS_2/c_scale*CG*synRate*0.260597;
rate_matrix_2[58][60]:=S_2/c_scale*CT*synRate*0.279104;
rate_matrix_2[59][14]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[59][30]:=S_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[59][46]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[59][52]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[59][55]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[59][57]:=S_2/c_scale*synRate*0.210149;
rate_matrix_2[59][58]:=NS_2/c_scale*CG*synRate*0.250149;
rate_matrix_2[59][60]:=NS_2/c_scale*GT*synRate*0.279104;
rate_matrix_2[60][15]:=NS_2/c_scale*AT*synRate*0.340299;
rate_matrix_2[60][31]:=NS_2/c_scale*CT*synRate*0.223284;
rate_matrix_2[60][47]:=NS_2/c_scale*GT*synRate*0.264776;
rate_matrix_2[60][49]:=NS_2/c_scale*AT*synRate*0.305075;
rate_matrix_2[60][53]:=NS_2/c_scale*CT*synRate*0.166866;
rate_matrix_2[60][56]:=NS_2/c_scale*GT*synRate*0.221194;
rate_matrix_2[60][57]:=NS_2/c_scale*AT*synRate*0.210149;
rate_matrix_2[60][58]:=S_2/c_scale*CT*synRate*0.250149;
rate_matrix_2[60][59]:=NS_2/c_scale*GT*synRate*0.260597;


Model MG94model_2=(rate_matrix_2,vectorOfFrequencies,0);
rate_matrix_3={61,61};
rate_matrix_3[0][1]:=NS_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[0][2]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[0][3]:=NS_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[0][4]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[0][8]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[0][12]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[0][16]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[0][32]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[1][0]:=NS_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[1][2]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[1][3]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[1][5]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[1][9]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[1][13]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[1][17]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[1][33]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[1][48]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[2][0]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[2][1]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[2][3]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[2][6]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[2][10]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[2][14]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[2][18]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[2][34]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[3][0]:=NS_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[3][1]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[3][2]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[3][7]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[3][11]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[3][15]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[3][19]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[3][35]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[3][49]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[4][0]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[4][5]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[4][6]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[4][7]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[4][8]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[4][12]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[4][20]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[4][36]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[4][50]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[5][1]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[5][4]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[5][6]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[5][7]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[5][9]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[5][13]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[5][21]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[5][37]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[5][51]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[6][2]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[6][4]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[6][5]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[6][7]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[6][10]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[6][14]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[6][22]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[6][38]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[6][52]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[7][3]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[7][4]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[7][5]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[7][6]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[7][11]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[7][15]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[7][23]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[7][39]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[7][53]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[8][0]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[8][4]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[8][9]:=NS_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[8][10]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[8][11]:=NS_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[8][12]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[8][24]:=S_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[8][40]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[9][1]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[9][5]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[9][8]:=NS_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[9][10]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[9][11]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[9][13]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[9][25]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[9][41]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[9][54]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[10][2]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[10][6]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[10][8]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[10][9]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[10][11]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[10][14]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[10][26]:=S_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[10][42]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[10][55]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[11][3]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[11][7]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[11][8]:=NS_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[11][9]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[11][10]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[11][15]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[11][27]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[11][43]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[11][56]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[12][0]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[12][4]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[12][8]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[12][13]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[12][14]:=NS_3/c_scale*synRate*0.260597;
rate_matrix_3[12][15]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[12][28]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[12][44]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[12][57]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[13][1]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[13][5]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[13][9]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[13][12]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[13][14]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[13][15]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[13][29]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[13][45]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[13][58]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[14][2]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[14][6]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[14][10]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[14][12]:=NS_3/c_scale*synRate*0.210149;
rate_matrix_3[14][13]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[14][15]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[14][30]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[14][46]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[14][59]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[15][3]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[15][7]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[15][11]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[15][12]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[15][13]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[15][14]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[15][31]:=NS_3/c_scale*AC*synRate*0.223284;
rate_matrix_3[15][47]:=NS_3/c_scale*synRate*0.264776;
rate_matrix_3[15][60]:=NS_3/c_scale*AT*synRate*0.171642;
rate_matrix_3[16][0]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[16][17]:=NS_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[16][18]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[16][19]:=NS_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[16][20]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[16][24]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[16][28]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[16][32]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[17][1]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[17][16]:=NS_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[17][18]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[17][19]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[17][21]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[17][25]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[17][29]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[17][33]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[17][48]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[18][2]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[18][16]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[18][17]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[18][19]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[18][22]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[18][26]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[18][30]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[18][34]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[19][3]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[19][16]:=NS_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[19][17]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[19][18]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[19][23]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[19][27]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[19][31]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[19][35]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[19][49]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[20][4]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[20][16]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[20][21]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[20][22]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[20][23]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[20][24]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[20][28]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[20][36]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[20][50]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[21][5]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[21][17]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[21][20]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[21][22]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[21][23]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[21][25]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[21][29]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[21][37]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[21][51]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[22][6]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[22][18]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[22][20]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[22][21]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[22][23]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[22][26]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[22][30]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[22][38]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[22][52]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[23][7]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[23][19]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[23][20]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[23][21]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[23][22]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[23][27]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[23][31]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[23][39]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[23][53]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[24][8]:=S_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[24][16]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[24][20]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[24][25]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[24][26]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[24][27]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[24][28]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[24][40]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[25][9]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[25][17]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[25][21]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[25][24]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[25][26]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[25][27]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[25][29]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[25][41]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[25][54]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[26][10]:=S_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[26][18]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[26][22]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[26][24]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[26][25]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[26][27]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[26][30]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[26][42]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[26][55]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[27][11]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[27][19]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[27][23]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[27][24]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[27][25]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[27][26]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[27][31]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[27][43]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[27][56]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[28][12]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[28][16]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[28][20]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[28][24]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[28][29]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[28][30]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[28][31]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[28][44]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[28][57]:=S_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[29][13]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[29][17]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[29][21]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[29][25]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[29][28]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[29][30]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[29][31]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[29][45]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[29][58]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[30][14]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[30][18]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[30][22]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[30][26]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[30][28]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[30][29]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[30][31]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[30][46]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[30][59]:=S_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[31][15]:=NS_3/c_scale*AC*synRate*0.340299;
rate_matrix_3[31][19]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[31][23]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[31][27]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[31][28]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[31][29]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[31][30]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[31][47]:=NS_3/c_scale*CG*synRate*0.264776;
rate_matrix_3[31][60]:=NS_3/c_scale*CT*synRate*0.171642;
rate_matrix_3[32][0]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[32][16]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[32][33]:=NS_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[32][34]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[32][35]:=NS_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[32][36]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[32][40]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[32][44]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[33][1]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[33][17]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[33][32]:=NS_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[33][34]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[33][35]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[33][37]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[33][41]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[33][45]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[33][48]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[34][2]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[34][18]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[34][32]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[34][33]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[34][35]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[34][38]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[34][42]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[34][46]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[35][3]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[35][19]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[35][32]:=NS_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[35][33]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[35][34]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[35][39]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[35][43]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[35][47]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[35][49]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[36][4]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[36][20]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[36][32]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[36][37]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[36][38]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[36][39]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[36][40]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[36][44]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[36][50]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[37][5]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[37][21]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[37][33]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[37][36]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[37][38]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[37][39]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[37][41]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[37][45]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[37][51]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[38][6]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[38][22]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[38][34]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[38][36]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[38][37]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[38][39]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[38][42]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[38][46]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[38][52]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[39][7]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[39][23]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[39][35]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[39][36]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[39][37]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[39][38]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[39][43]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[39][47]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[39][53]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[40][8]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[40][24]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[40][32]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[40][36]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[40][41]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[40][42]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[40][43]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[40][44]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[41][9]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[41][25]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[41][33]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[41][37]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[41][40]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[41][42]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[41][43]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[41][45]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[41][54]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[42][10]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[42][26]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[42][34]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[42][38]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[42][40]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[42][41]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[42][43]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[42][46]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[42][55]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[43][11]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[43][27]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[43][35]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[43][39]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[43][40]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[43][41]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[43][42]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[43][47]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[43][56]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[44][12]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[44][28]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[44][32]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[44][36]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[44][40]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[44][45]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[44][46]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[44][47]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[44][57]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[45][13]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[45][29]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[45][33]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[45][37]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[45][41]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[45][44]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[45][46]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[45][47]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[45][58]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[46][14]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[46][30]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[46][34]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[46][38]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[46][42]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[46][44]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[46][45]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[46][47]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[46][59]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[47][15]:=NS_3/c_scale*synRate*0.340299;
rate_matrix_3[47][31]:=NS_3/c_scale*CG*synRate*0.223284;
rate_matrix_3[47][35]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[47][39]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[47][43]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[47][44]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[47][45]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[47][46]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[47][60]:=NS_3/c_scale*GT*synRate*0.171642;
rate_matrix_3[48][1]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[48][17]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[48][33]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[48][49]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[48][51]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[48][54]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[48][58]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[49][3]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[49][19]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[49][35]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[49][48]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[49][53]:=NS_3/c_scale*AC*synRate*0.166866;
rate_matrix_3[49][56]:=NS_3/c_scale*synRate*0.221194;
rate_matrix_3[49][60]:=NS_3/c_scale*AT*synRate*0.306866;
rate_matrix_3[50][4]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[50][20]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[50][36]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[50][51]:=S_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[50][52]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[50][53]:=S_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[50][57]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[51][5]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[51][21]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[51][37]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[51][48]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[51][50]:=S_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[51][52]:=S_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[51][53]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[51][54]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[51][58]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[52][6]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[52][22]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[52][38]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[52][50]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[52][51]:=S_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[52][53]:=S_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[52][55]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[52][59]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[53][7]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[53][23]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[53][39]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[53][49]:=NS_3/c_scale*AC*synRate*0.305075;
rate_matrix_3[53][50]:=S_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[53][51]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[53][52]:=S_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[53][56]:=NS_3/c_scale*CG*synRate*0.221194;
rate_matrix_3[53][60]:=NS_3/c_scale*CT*synRate*0.306866;
rate_matrix_3[54][9]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[54][25]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[54][41]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[54][48]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[54][51]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[54][55]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[54][56]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[54][58]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[55][10]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[55][26]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[55][42]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[55][52]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[55][54]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[55][56]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[55][59]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[56][11]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[56][27]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[56][43]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[56][49]:=NS_3/c_scale*synRate*0.305075;
rate_matrix_3[56][53]:=NS_3/c_scale*CG*synRate*0.166866;
rate_matrix_3[56][54]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[56][55]:=NS_3/c_scale*GT*synRate*0.260597;
rate_matrix_3[56][60]:=NS_3/c_scale*GT*synRate*0.306866;
rate_matrix_3[57][12]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[57][28]:=S_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[57][44]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[57][50]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[57][58]:=NS_3/c_scale*AC*synRate*0.250149;
rate_matrix_3[57][59]:=S_3/c_scale*synRate*0.260597;
rate_matrix_3[57][60]:=NS_3/c_scale*AT*synRate*0.279104;
rate_matrix_3[58][13]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[58][29]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[58][45]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[58][48]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[58][51]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[58][54]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[58][57]:=NS_3/c_scale*AC*synRate*0.210149;
rate_matrix_3[58][59]:=NS_3/c_scale*CG*synRate*0.260597;
rate_matrix_3[58][60]:=S_3/c_scale*CT*synRate*0.279104;
rate_matrix_3[59][14]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[59][30]:=S_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[59][46]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[59][52]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[59][55]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[59][57]:=S_3/c_scale*synRate*0.210149;
rate_matrix_3[59][58]:=NS_3/c_scale*CG*synRate*0.250149;
rate_matrix_3[59][60]:=NS_3/c_scale*GT*synRate*0.279104;
rate_matrix_3[60][15]:=NS_3/c_scale*AT*synRate*0.340299;
rate_matrix_3[60][31]:=NS_3/c_scale*CT*synRate*0.223284;
rate_matrix_3[60][47]:=NS_3/c_scale*GT*synRate*0.264776;
rate_matrix_3[60][49]:=NS_3/c_scale*AT*synRate*0.305075;
rate_matrix_3[60][53]:=NS_3/c_scale*CT*synRate*0.166866;
rate_matrix_3[60][56]:=NS_3/c_scale*GT*synRate*0.221194;
rate_matrix_3[60][57]:=NS_3/c_scale*AT*synRate*0.210149;
rate_matrix_3[60][58]:=S_3/c_scale*CT*synRate*0.250149;
rate_matrix_3[60][59]:=NS_3/c_scale*GT*synRate*0.260597;


Model MG94model_3=(rate_matrix_3,vectorOfFrequencies,0);
rate_matrix_4={61,61};
rate_matrix_4[0][1]:=NS_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[0][2]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[0][3]:=NS_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[0][4]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[0][8]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[0][12]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[0][16]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[0][32]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[1][0]:=NS_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[1][2]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[1][3]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[1][5]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[1][9]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[1][13]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[1][17]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[1][33]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[1][48]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[2][0]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[2][1]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[2][3]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[2][6]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[2][10]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[2][14]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[2][18]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[2][34]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[3][0]:=NS_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[3][1]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[3][2]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[3][7]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[3][11]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[3][15]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[3][19]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[3][35]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[3][49]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[4][0]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[4][5]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[4][6]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[4][7]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[4][8]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[4][12]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[4][20]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[4][36]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[4][50]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[5][1]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[5][4]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[5][6]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[5][7]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[5][9]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[5][13]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[5][21]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[5][37]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[5][51]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[6][2]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[6][4]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[6][5]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[6][7]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[6][10]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[6][14]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[6][22]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[6][38]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[6][52]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[7][3]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[7][4]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[7][5]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[7][6]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[7][11]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[7][15]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[7][23]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[7][39]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[7][53]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[8][0]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[8][4]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[8][9]:=NS_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[8][10]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[8][11]:=NS_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[8][12]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[8][24]:=S_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[8][40]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[9][1]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[9][5]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[9][8]:=NS_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[9][10]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[9][11]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[9][13]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[9][25]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[9][41]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[9][54]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[10][2]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[10][6]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[10][8]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[10][9]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[10][11]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[10][14]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[10][26]:=S_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[10][42]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[10][55]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[11][3]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[11][7]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[11][8]:=NS_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[11][9]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[11][10]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[11][15]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[11][27]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[11][43]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[11][56]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[12][0]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[12][4]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[12][8]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[12][13]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[12][14]:=NS_4/c_scale*synRate*0.260597;
rate_matrix_4[12][15]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[12][28]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[12][44]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[12][57]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[13][1]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[13][5]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[13][9]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[13][12]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[13][14]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[13][15]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[13][29]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[13][45]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[13][58]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[14][2]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[14][6]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[14][10]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[14][12]:=NS_4/c_scale*synRate*0.210149;
rate_matrix_4[14][13]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[14][15]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[14][30]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[14][46]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[14][59]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[15][3]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[15][7]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[15][11]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[15][12]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[15][13]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[15][14]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[15][31]:=NS_4/c_scale*AC*synRate*0.223284;
rate_matrix_4[15][47]:=NS_4/c_scale*synRate*0.264776;
rate_matrix_4[15][60]:=NS_4/c_scale*AT*synRate*0.171642;
rate_matrix_4[16][0]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[16][17]:=NS_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[16][18]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[16][19]:=NS_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[16][20]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[16][24]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[16][28]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[16][32]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[17][1]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[17][16]:=NS_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[17][18]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[17][19]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[17][21]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[17][25]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[17][29]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[17][33]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[17][48]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[18][2]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[18][16]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[18][17]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[18][19]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[18][22]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[18][26]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[18][30]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[18][34]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[19][3]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[19][16]:=NS_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[19][17]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[19][18]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[19][23]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[19][27]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[19][31]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[19][35]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[19][49]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[20][4]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[20][16]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[20][21]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[20][22]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[20][23]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[20][24]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[20][28]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[20][36]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[20][50]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[21][5]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[21][17]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[21][20]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[21][22]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[21][23]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[21][25]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[21][29]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[21][37]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[21][51]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[22][6]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[22][18]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[22][20]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[22][21]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[22][23]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[22][26]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[22][30]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[22][38]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[22][52]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[23][7]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[23][19]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[23][20]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[23][21]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[23][22]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[23][27]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[23][31]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[23][39]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[23][53]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[24][8]:=S_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[24][16]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[24][20]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[24][25]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[24][26]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[24][27]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[24][28]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[24][40]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[25][9]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[25][17]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[25][21]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[25][24]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[25][26]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[25][27]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[25][29]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[25][41]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[25][54]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[26][10]:=S_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[26][18]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[26][22]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[26][24]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[26][25]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[26][27]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[26][30]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[26][42]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[26][55]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[27][11]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[27][19]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[27][23]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[27][24]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[27][25]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[27][26]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[27][31]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[27][43]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[27][56]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[28][12]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[28][16]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[28][20]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[28][24]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[28][29]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[28][30]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[28][31]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[28][44]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[28][57]:=S_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[29][13]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[29][17]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[29][21]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[29][25]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[29][28]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[29][30]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[29][31]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[29][45]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[29][58]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[30][14]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[30][18]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[30][22]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[30][26]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[30][28]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[30][29]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[30][31]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[30][46]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[30][59]:=S_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[31][15]:=NS_4/c_scale*AC*synRate*0.340299;
rate_matrix_4[31][19]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[31][23]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[31][27]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[31][28]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[31][29]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[31][30]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[31][47]:=NS_4/c_scale*CG*synRate*0.264776;
rate_matrix_4[31][60]:=NS_4/c_scale*CT*synRate*0.171642;
rate_matrix_4[32][0]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[32][16]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[32][33]:=NS_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[32][34]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[32][35]:=NS_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[32][36]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[32][40]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[32][44]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[33][1]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[33][17]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[33][32]:=NS_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[33][34]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[33][35]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[33][37]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[33][41]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[33][45]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[33][48]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[34][2]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[34][18]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[34][32]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[34][33]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[34][35]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[34][38]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[34][42]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[34][46]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[35][3]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[35][19]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[35][32]:=NS_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[35][33]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[35][34]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[35][39]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[35][43]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[35][47]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[35][49]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[36][4]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[36][20]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[36][32]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[36][37]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[36][38]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[36][39]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[36][40]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[36][44]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[36][50]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[37][5]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[37][21]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[37][33]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[37][36]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[37][38]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[37][39]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[37][41]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[37][45]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[37][51]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[38][6]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[38][22]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[38][34]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[38][36]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[38][37]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[38][39]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[38][42]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[38][46]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[38][52]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[39][7]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[39][23]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[39][35]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[39][36]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[39][37]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[39][38]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[39][43]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[39][47]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[39][53]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[40][8]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[40][24]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[40][32]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[40][36]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[40][41]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[40][42]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[40][43]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[40][44]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[41][9]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[41][25]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[41][33]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[41][37]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[41][40]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[41][42]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[41][43]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[41][45]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[41][54]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[42][10]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[42][26]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[42][34]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[42][38]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[42][40]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[42][41]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[42][43]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[42][46]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[42][55]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[43][11]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[43][27]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[43][35]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[43][39]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[43][40]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[43][41]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[43][42]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[43][47]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[43][56]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[44][12]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[44][28]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[44][32]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[44][36]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[44][40]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[44][45]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[44][46]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[44][47]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[44][57]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[45][13]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[45][29]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[45][33]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[45][37]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[45][41]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[45][44]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[45][46]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[45][47]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[45][58]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[46][14]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[46][30]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[46][34]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[46][38]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[46][42]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[46][44]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[46][45]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[46][47]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[46][59]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[47][15]:=NS_4/c_scale*synRate*0.340299;
rate_matrix_4[47][31]:=NS_4/c_scale*CG*synRate*0.223284;
rate_matrix_4[47][35]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[47][39]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[47][43]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[47][44]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[47][45]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[47][46]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[47][60]:=NS_4/c_scale*GT*synRate*0.171642;
rate_matrix_4[48][1]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[48][17]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[48][33]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[48][49]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[48][51]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[48][54]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[48][58]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[49][3]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[49][19]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[49][35]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[49][48]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[49][53]:=NS_4/c_scale*AC*synRate*0.166866;
rate_matrix_4[49][56]:=NS_4/c_scale*synRate*0.221194;
rate_matrix_4[49][60]:=NS_4/c_scale*AT*synRate*0.306866;
rate_matrix_4[50][4]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[50][20]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[50][36]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[50][51]:=S_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[50][52]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[50][53]:=S_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[50][57]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[51][5]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[51][21]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[51][37]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[51][48]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[51][50]:=S_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[51][52]:=S_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[51][53]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[51][54]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[51][58]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[52][6]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[52][22]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[52][38]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[52][50]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[52][51]:=S_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[52][53]:=S_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[52][55]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[52][59]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[53][7]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[53][23]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[53][39]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[53][49]:=NS_4/c_scale*AC*synRate*0.305075;
rate_matrix_4[53][50]:=S_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[53][51]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[53][52]:=S_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[53][56]:=NS_4/c_scale*CG*synRate*0.221194;
rate_matrix_4[53][60]:=NS_4/c_scale*CT*synRate*0.306866;
rate_matrix_4[54][9]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[54][25]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[54][41]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[54][48]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[54][51]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[54][55]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[54][56]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[54][58]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[55][10]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[55][26]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[55][42]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[55][52]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[55][54]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[55][56]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[55][59]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[56][11]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[56][27]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[56][43]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[56][49]:=NS_4/c_scale*synRate*0.305075;
rate_matrix_4[56][53]:=NS_4/c_scale*CG*synRate*0.166866;
rate_matrix_4[56][54]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[56][55]:=NS_4/c_scale*GT*synRate*0.260597;
rate_matrix_4[56][60]:=NS_4/c_scale*GT*synRate*0.306866;
rate_matrix_4[57][12]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[57][28]:=S_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[57][44]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[57][50]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[57][58]:=NS_4/c_scale*AC*synRate*0.250149;
rate_matrix_4[57][59]:=S_4/c_scale*synRate*0.260597;
rate_matrix_4[57][60]:=NS_4/c_scale*AT*synRate*0.279104;
rate_matrix_4[58][13]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[58][29]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[58][45]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[58][48]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[58][51]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[58][54]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[58][57]:=NS_4/c_scale*AC*synRate*0.210149;
rate_matrix_4[58][59]:=NS_4/c_scale*CG*synRate*0.260597;
rate_matrix_4[58][60]:=S_4/c_scale*CT*synRate*0.279104;
rate_matrix_4[59][14]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[59][30]:=S_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[59][46]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[59][52]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[59][55]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[59][57]:=S_4/c_scale*synRate*0.210149;
rate_matrix_4[59][58]:=NS_4/c_scale*CG*synRate*0.250149;
rate_matrix_4[59][60]:=NS_4/c_scale*GT*synRate*0.279104;
rate_matrix_4[60][15]:=NS_4/c_scale*AT*synRate*0.340299;
rate_matrix_4[60][31]:=NS_4/c_scale*CT*synRate*0.223284;
rate_matrix_4[60][47]:=NS_4/c_scale*GT*synRate*0.264776;
rate_matrix_4[60][49]:=NS_4/c_scale*AT*synRate*0.305075;
rate_matrix_4[60][53]:=NS_4/c_scale*CT*synRate*0.166866;
rate_matrix_4[60][56]:=NS_4/c_scale*GT*synRate*0.221194;
rate_matrix_4[60][57]:=NS_4/c_scale*AT*synRate*0.210149;
rate_matrix_4[60][58]:=S_4/c_scale*CT*synRate*0.250149;
rate_matrix_4[60][59]:=NS_4/c_scale*GT*synRate*0.260597;


Model MG94model_4=(rate_matrix_4,vectorOfFrequencies,0);

UseModel (MG94model_0);
Tree tree_1_0=((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);

UseModel (MG94model_1);
Tree tree_1_1=((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);

UseModel (MG94model_2);
Tree tree_1_2=((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);

UseModel (MG94model_3);
Tree tree_1_3=((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);

UseModel (MG94model_4);
Tree tree_1_4=((FULGENS,(((KAMTSCHATKANA,(RUFESCENS,(SORENSENI,WALALLENSIS)Node9)Node7)Node5,(SIEBOLDII,(DISCUS_HANNAI,GIGANTEA)Node14)Node12)Node4,(CORRUGATA,CRACHERODII)Node17)Node3)Node1,IRIS,((PUSTULATA,(COCCINEA,TUBERCULATA)Node24)Node22,(AUSTRALIS,((MIDAE,((ROEI,(SCALARIS,LAEVIGATA)Node35)Node33,(CYCLOBATES,(RUBRA,CONICOPORA)Node40)Node38)Node32)Node30,((OVINA,VARIA)Node44,DIVERSICOLOR)Node43)Node29)Node27)Node21);

tree_1_0.GIGANTEA.synRate:=0/codonFactor;
tree_1_2.COCCINEA.synRate:=tree_1_0.COCCINEA.synRate;
tree_1_3.Node30.synRate:=tree_1_0.Node30.synRate;
tree_1_3.Node32.synRate:=tree_1_0.Node32.synRate;
tree_1_3.Node38.synRate:=tree_1_0.Node38.synRate;
tree_1_2.Node4.synRate:=tree_1_0.Node4.synRate;
tree_1_1.SORENSENI.synRate:=tree_1_0.SORENSENI.synRate;
tree_1_3.Node40.synRate:=tree_1_0.Node40.synRate;
tree_1_0.CORRUGATA.synRate:=0.0782842/codonFactor;
tree_1_0.KAMTSCHATKANA.synRate:=0.122733/codonFactor;
tree_1_3.CONICOPORA.synRate:=tree_1_0.CONICOPORA.synRate;
tree_1_2.Node1.synRate:=tree_1_0.Node1.synRate;
tree_1_3.RUBRA.synRate:=tree_1_0.RUBRA.synRate;
tree_1_3.CYCLOBATES.synRate:=tree_1_0.CYCLOBATES.synRate;
tree_1_1.DISCUS_HANNAI.synRate:=tree_1_0.DISCUS_HANNAI.synRate;
tree_1_3.Node33.synRate:=tree_1_0.Node33.synRate;
tree_1_3.Node35.synRate:=tree_1_0.Node35.synRate;
tree_1_0.IRIS.synRate:=0.45025/codonFactor;
tree_1_3.LAEVIGATA.synRate:=tree_1_0.LAEVIGATA.synRate;
tree_1_1.Node17.synRate:=tree_1_0.Node17.synRate;
tree_1_3.SCALARIS.synRate:=tree_1_0.SCALARIS.synRate;
tree_1_0.Node5.synRate:=0.107292/codonFactor;
tree_1_3.ROEI.synRate:=tree_1_0.ROEI.synRate;
tree_1_1.PUSTULATA.synRate:=tree_1_0.PUSTULATA.synRate;
tree_1_3.MIDAE.synRate:=tree_1_0.MIDAE.synRate;
tree_1_2.WALALLENSIS.synRate:=tree_1_0.WALALLENSIS.synRate;
tree_1_2.SIEBOLDII.synRate:=tree_1_0.SIEBOLDII.synRate;
tree_1_3.AUSTRALIS.synRate:=tree_1_0.AUSTRALIS.synRate;
tree_1_3.Node22.synRate:=tree_1_0.Node22.synRate;
tree_1_2.Node21.synRate:=tree_1_0.Node21.synRate;
tree_1_2.TUBERCULATA.synRate:=tree_1_0.TUBERCULATA.synRate;
tree_1_2.Node9.synRate:=tree_1_0.Node9.synRate;
tree_1_1.Node7.synRate:=tree_1_0.Node7.synRate;
tree_1_2.Node27.synRate:=tree_1_0.Node27.synRate;
tree_1_2.RUFESCENS.synRate:=tree_1_0.RUFESCENS.synRate;
tree_1_1.CRACHERODII.synRate:=tree_1_0.CRACHERODII.synRate;
tree_1_2.Node29.synRate:=tree_1_0.Node29.synRate;
tree_1_2.Node43.synRate:=tree_1_0.Node43.synRate;
tree_1_1.Node3.synRate:=tree_1_0.Node3.synRate;
tree_1_2.DIVERSICOLOR.synRate:=tree_1_0.DIVERSICOLOR.synRate;
tree_1_0.Node14.synRate:=0.0908203/codonFactor;
tree_1_2.Node44.synRate:=tree_1_0.Node44.synRate;
tree_1_1.Node24.synRate:=tree_1_0.Node24.synRate;
tree_1_2.VARIA.synRate:=tree_1_0.VARIA.synRate;
tree_1_2.OVINA.synRate:=tree_1_0.OVINA.synRate;
tree_1_1.FULGENS.synRate:=tree_1_0.FULGENS.synRate;
tree_1_2.Node30.synRate:=tree_1_0.Node30.synRate;
tree_1_0.Node12.synRate:=0.0682704/codonFactor;
tree_1_1.COCCINEA.synRate:=tree_1_0.COCCINEA.synRate;
tree_1_2.Node32.synRate:=tree_1_0.Node32.synRate;
tree_1_2.Node38.synRate:=tree_1_0.Node38.synRate;
tree_1_1.Node4.synRate:=tree_1_0.Node4.synRate;
tree_1_2.Node40.synRate:=tree_1_0.Node40.synRate;
tree_1_2.CONICOPORA.synRate:=tree_1_0.CONICOPORA.synRate;
tree_1_1.Node1.synRate:=tree_1_0.Node1.synRate;
tree_1_0.SORENSENI.synRate:=0.0195577/codonFactor;
tree_1_1.Node14.synRate:=tree_1_0.Node14.synRate;
tree_1_2.RUBRA.synRate:=tree_1_0.RUBRA.synRate;
tree_1_1.KAMTSCHATKANA.synRate:=tree_1_0.KAMTSCHATKANA.synRate;
tree_1_2.CYCLOBATES.synRate:=tree_1_0.CYCLOBATES.synRate;
tree_1_0.DISCUS_HANNAI.synRate:=0.0102967/codonFactor;
tree_1_2.Node33.synRate:=tree_1_0.Node33.synRate;
tree_1_2.Node35.synRate:=tree_1_0.Node35.synRate;
tree_1_2.LAEVIGATA.synRate:=tree_1_0.LAEVIGATA.synRate;
tree_1_0.Node17.synRate:=0.0366778/codonFactor;
tree_1_2.SCALARIS.synRate:=tree_1_0.SCALARIS.synRate;
tree_1_1.WALALLENSIS.synRate:=tree_1_0.WALALLENSIS.synRate;
tree_1_2.ROEI.synRate:=tree_1_0.ROEI.synRate;
tree_1_1.SIEBOLDII.synRate:=tree_1_0.SIEBOLDII.synRate;
tree_1_0.PUSTULATA.synRate:=0.154803/codonFactor;
tree_1_2.MIDAE.synRate:=tree_1_0.MIDAE.synRate;
tree_1_2.AUSTRALIS.synRate:=tree_1_0.AUSTRALIS.synRate;
tree_1_2.Node22.synRate:=tree_1_0.Node22.synRate;
tree_1_1.TUBERCULATA.synRate:=tree_1_0.TUBERCULATA.synRate;
tree_1_1.Node9.synRate:=tree_1_0.Node9.synRate;
tree_1_1.Node21.synRate:=tree_1_0.Node21.synRate;
tree_1_1.Node5.synRate:=tree_1_0.Node5.synRate;
tree_1_1.RUFESCENS.synRate:=tree_1_0.RUFESCENS.synRate;
tree_1_0.CRACHERODII.synRate:=0.192895/codonFactor;
tree_1_1.Node27.synRate:=tree_1_0.Node27.synRate;
tree_1_0.Node7.synRate:=0.0153686/codonFactor;
tree_1_1.IRIS.synRate:=tree_1_0.IRIS.synRate;
tree_1_0.Node3.synRate:=0.119326/codonFactor;
tree_1_1.Node29.synRate:=tree_1_0.Node29.synRate;
tree_1_1.Node43.synRate:=tree_1_0.Node43.synRate;
tree_1_1.CORRUGATA.synRate:=tree_1_0.CORRUGATA.synRate;
tree_1_1.DIVERSICOLOR.synRate:=tree_1_0.DIVERSICOLOR.synRate;
tree_1_1.Node44.synRate:=tree_1_0.Node44.synRate;
tree_1_0.Node24.synRate:=0.235419/codonFactor;
tree_1_2.Node3.synRate:=tree_1_0.Node3.synRate;
tree_1_1.GIGANTEA.synRate:=tree_1_0.GIGANTEA.synRate;
tree_1_1.VARIA.synRate:=tree_1_0.VARIA.synRate;
tree_1_1.OVINA.synRate:=tree_1_0.OVINA.synRate;
tree_1_0.FULGENS.synRate:=0.235828/codonFactor;
tree_1_1.Node30.synRate:=tree_1_0.Node30.synRate;
tree_1_2.Node24.synRate:=tree_1_0.Node24.synRate;
tree_1_1.Node32.synRate:=tree_1_0.Node32.synRate;
tree_1_1.Node12.synRate:=tree_1_0.Node12.synRate;
tree_1_0.COCCINEA.synRate:=0.0444038/codonFactor;
tree_1_1.Node38.synRate:=tree_1_0.Node38.synRate;
tree_1_2.FULGENS.synRate:=tree_1_0.FULGENS.synRate;
tree_1_2.CRACHERODII.synRate:=tree_1_0.CRACHERODII.synRate;
tree_1_1.Node40.synRate:=tree_1_0.Node40.synRate;
tree_1_1.CONICOPORA.synRate:=tree_1_0.CONICOPORA.synRate;
tree_1_1.RUBRA.synRate:=tree_1_0.RUBRA.synRate;
tree_1_0.Node4.synRate:=0.0429988/codonFactor;
tree_1_1.CYCLOBATES.synRate:=tree_1_0.CYCLOBATES.synRate;
tree_1_2.Node5.synRate:=tree_1_0.Node5.synRate;
tree_1_0.Node1.synRate:=0.371054/codonFactor;
tree_1_1.Node33.synRate:=tree_1_0.Node33.synRate;
tree_1_1.Node35.synRate:=tree_1_0.Node35.synRate;
tree_1_1.LAEVIGATA.synRate:=tree_1_0.LAEVIGATA.synRate;
tree_1_2.CORRUGATA.synRate:=tree_1_0.CORRUGATA.synRate;
tree_1_1.SCALARIS.synRate:=tree_1_0.SCALARIS.synRate;
tree_1_1.ROEI.synRate:=tree_1_0.ROEI.synRate;
tree_1_2.Node14.synRate:=tree_1_0.Node14.synRate;
tree_1_2.Node12.synRate:=tree_1_0.Node12.synRate;
tree_1_1.MIDAE.synRate:=tree_1_0.MIDAE.synRate;
tree_1_2.GIGANTEA.synRate:=tree_1_0.GIGANTEA.synRate;
tree_1_1.AUSTRALIS.synRate:=tree_1_0.AUSTRALIS.synRate;
tree_1_0.WALALLENSIS.synRate:=0.0865036/codonFactor;
tree_1_1.Node22.synRate:=tree_1_0.Node22.synRate;
tree_1_2.KAMTSCHATKANA.synRate:=tree_1_0.KAMTSCHATKANA.synRate;
tree_1_0.SIEBOLDII.synRate:=0.0158806/codonFactor;
tree_1_2.IRIS.synRate:=tree_1_0.IRIS.synRate;
tree_1_0.Node21.synRate:=0.0995652/codonFactor;
tree_1_0.Node27.synRate:=0.0411943/codonFactor;
tree_1_2.Node7.synRate:=tree_1_0.Node7.synRate;
tree_1_0.TUBERCULATA.synRate:=0.0179456/codonFactor;
tree_1_0.Node29.synRate:=0.0257492/codonFactor;
tree_1_0.Node43.synRate:=0.0863398/codonFactor;
tree_1_0.Node9.synRate:=0.0174759/codonFactor;
tree_1_2.PUSTULATA.synRate:=tree_1_0.PUSTULATA.synRate;
tree_1_0.RUFESCENS.synRate:=0.0627486/codonFactor;
tree_1_3.Node21.synRate:=tree_1_0.Node21.synRate;
tree_1_2.Node17.synRate:=tree_1_0.Node17.synRate;
tree_1_3.Node27.synRate:=tree_1_0.Node27.synRate;
tree_1_0.DIVERSICOLOR.synRate:=0.252516/codonFactor;
tree_1_2.DISCUS_HANNAI.synRate:=tree_1_0.DISCUS_HANNAI.synRate;
tree_1_0.Node44.synRate:=0.103799/codonFactor;
tree_1_3.OVINA.synRate:=tree_1_0.OVINA.synRate;
tree_1_2.SORENSENI.synRate:=tree_1_0.SORENSENI.synRate;
tree_1_0.VARIA.synRate:=0.236554/codonFactor;
tree_1_3.Node44.synRate:=tree_1_0.Node44.synRate;
tree_1_3.Node43.synRate:=tree_1_0.Node43.synRate;
tree_1_0.OVINA.synRate:=0.11803/codonFactor;
tree_1_3.Node29.synRate:=tree_1_0.Node29.synRate;
tree_1_0.Node30.synRate:=0.0696769/codonFactor;
tree_1_3.DIVERSICOLOR.synRate:=tree_1_0.DIVERSICOLOR.synRate;
tree_1_3.VARIA.synRate:=tree_1_0.VARIA.synRate;
tree_1_3.DISCUS_HANNAI.synRate:=tree_1_0.DISCUS_HANNAI.synRate;
tree_1_0.Node32.synRate:=0.0493371/codonFactor;
tree_1_3.Node7.synRate:=tree_1_0.Node7.synRate;
tree_1_3.KAMTSCHATKANA.synRate:=tree_1_0.KAMTSCHATKANA.synRate;
tree_1_0.Node38.synRate:=0.103847/codonFactor;
tree_1_3.IRIS.synRate:=tree_1_0.IRIS.synRate;
tree_1_0.Node40.synRate:=0.0687337/codonFactor;
tree_1_0.CONICOPORA.synRate:=0.0024627/codonFactor;
tree_1_3.Node5.synRate:=tree_1_0.Node5.synRate;
tree_1_0.RUBRA.synRate:=0.0079888/codonFactor;
tree_1_3.Node14.synRate:=tree_1_0.Node14.synRate;
tree_1_3.GIGANTEA.synRate:=tree_1_0.GIGANTEA.synRate;
tree_1_0.CYCLOBATES.synRate:=0.271919/codonFactor;
tree_1_3.Node17.synRate:=tree_1_0.Node17.synRate;
tree_1_0.Node33.synRate:=0.0169797/codonFactor;
tree_1_3.Node12.synRate:=tree_1_0.Node12.synRate;
tree_1_0.Node35.synRate:=0.0894217/codonFactor;
tree_1_0.LAEVIGATA.synRate:=0.0720711/codonFactor;
tree_1_3.SORENSENI.synRate:=tree_1_0.SORENSENI.synRate;
tree_1_0.SCALARIS.synRate:=0.0984683/codonFactor;
tree_1_3.PUSTULATA.synRate:=tree_1_0.PUSTULATA.synRate;
tree_1_3.CORRUGATA.synRate:=tree_1_0.CORRUGATA.synRate;
tree_1_0.ROEI.synRate:=0.0626071/codonFactor;
tree_1_0.MIDAE.synRate:=0.300024/codonFactor;
tree_1_3.RUFESCENS.synRate:=tree_1_0.RUFESCENS.synRate;
tree_1_3.Node9.synRate:=tree_1_0.Node9.synRate;
tree_1_0.AUSTRALIS.synRate:=0.203935/codonFactor;
tree_1_3.TUBERCULATA.synRate:=tree_1_0.TUBERCULATA.synRate;
tree_1_0.Node22.synRate:=0.159581/codonFactor;
tree_1_3.SIEBOLDII.synRate:=tree_1_0.SIEBOLDII.synRate;
tree_1_3.WALALLENSIS.synRate:=tree_1_0.WALALLENSIS.synRate;
tree_1_3.Node1.synRate:=tree_1_0.Node1.synRate;
tree_1_3.Node4.synRate:=tree_1_0.Node4.synRate;
tree_1_3.COCCINEA.synRate:=tree_1_0.COCCINEA.synRate;
tree_1_3.FULGENS.synRate:=tree_1_0.FULGENS.synRate;
tree_1_3.Node24.synRate:=tree_1_0.Node24.synRate;
tree_1_3.Node3.synRate:=tree_1_0.Node3.synRate;
tree_1_3.CRACHERODII.synRate:=tree_1_0.CRACHERODII.synRate;
tree_1_4.FULGENS.synRate:=tree_1_0.FULGENS.synRate;
tree_1_4.KAMTSCHATKANA.synRate:=tree_1_0.KAMTSCHATKANA.synRate;
tree_1_4.RUFESCENS.synRate:=tree_1_0.RUFESCENS.synRate;
tree_1_4.SORENSENI.synRate:=tree_1_0.SORENSENI.synRate;
tree_1_4.WALALLENSIS.synRate:=tree_1_0.WALALLENSIS.synRate;
tree_1_4.Node9.synRate:=tree_1_0.Node9.synRate;
tree_1_4.Node7.synRate:=tree_1_0.Node7.synRate;
tree_1_4.Node5.synRate:=tree_1_0.Node5.synRate;
tree_1_4.SIEBOLDII.synRate:=tree_1_0.SIEBOLDII.synRate;
tree_1_4.DISCUS_HANNAI.synRate:=tree_1_0.DISCUS_HANNAI.synRate;
tree_1_4.GIGANTEA.synRate:=tree_1_0.GIGANTEA.synRate;
tree_1_4.Node14.synRate:=tree_1_0.Node14.synRate;
tree_1_4.Node12.synRate:=tree_1_0.Node12.synRate;
tree_1_4.Node4.synRate:=tree_1_0.Node4.synRate;
tree_1_4.CORRUGATA.synRate:=tree_1_0.CORRUGATA.synRate;
tree_1_4.CRACHERODII.synRate:=tree_1_0.CRACHERODII.synRate;
tree_1_4.Node17.synRate:=tree_1_0.Node17.synRate;
tree_1_4.Node3.synRate:=tree_1_0.Node3.synRate;
tree_1_4.Node1.synRate:=tree_1_0.Node1.synRate;
tree_1_4.IRIS.synRate:=tree_1_0.IRIS.synRate;
tree_1_4.PUSTULATA.synRate:=tree_1_0.PUSTULATA.synRate;
tree_1_4.COCCINEA.synRate:=tree_1_0.COCCINEA.synRate;
tree_1_4.TUBERCULATA.synRate:=tree_1_0.TUBERCULATA.synRate;
tree_1_4.Node24.synRate:=tree_1_0.Node24.synRate;
tree_1_4.Node22.synRate:=tree_1_0.Node22.synRate;
tree_1_4.AUSTRALIS.synRate:=tree_1_0.AUSTRALIS.synRate;
tree_1_4.MIDAE.synRate:=tree_1_0.MIDAE.synRate;
tree_1_4.ROEI.synRate:=tree_1_0.ROEI.synRate;
tree_1_4.SCALARIS.synRate:=tree_1_0.SCALARIS.synRate;
tree_1_4.LAEVIGATA.synRate:=tree_1_0.LAEVIGATA.synRate;
tree_1_4.Node35.synRate:=tree_1_0.Node35.synRate;
tree_1_4.Node33.synRate:=tree_1_0.Node33.synRate;
tree_1_4.CYCLOBATES.synRate:=tree_1_0.CYCLOBATES.synRate;
tree_1_4.RUBRA.synRate:=tree_1_0.RUBRA.synRate;
tree_1_4.CONICOPORA.synRate:=tree_1_0.CONICOPORA.synRate;
tree_1_4.Node40.synRate:=tree_1_0.Node40.synRate;
tree_1_4.Node38.synRate:=tree_1_0.Node38.synRate;
tree_1_4.Node32.synRate:=tree_1_0.Node32.synRate;
tree_1_4.Node30.synRate:=tree_1_0.Node30.synRate;
tree_1_4.OVINA.synRate:=tree_1_0.OVINA.synRate;
tree_1_4.VARIA.synRate:=tree_1_0.VARIA.synRate;
tree_1_4.Node44.synRate:=tree_1_0.Node44.synRate;
tree_1_4.DIVERSICOLOR.synRate:=tree_1_0.DIVERSICOLOR.synRate;
tree_1_4.Node43.synRate:=tree_1_0.Node43.synRate;
tree_1_4.Node29.synRate:=tree_1_0.Node29.synRate;
tree_1_4.Node27.synRate:=tree_1_0.Node27.synRate;
tree_1_4.Node21.synRate:=tree_1_0.Node21.synRate;
DataSet ds_1 = ReadDataFile(USE_NEXUS_FILE_DATA);
DataSetFilter filteredData_1 = CreateFilter(ds_1,3,"0-401","9,3,0-2,4-8,24,16,23,22,21,17,10-15,18,20,19","TAA,TAG,TGA");

AUTO_PARALLELIZE_OPTIMIZE = 2;

VERBOSITY_LEVEL			    = 1;


LikelihoodFunction lf = (filteredData_1,tree_1_0,filteredData_1,tree_1_1,filteredData_1,tree_1_2,filteredData_1,tree_1_3,filteredData_1,tree_1_4,"Log(P_1*SITE_LIKELIHOOD[0]+(1-P_1)*P_2*SITE_LIKELIHOOD[1]+(1-P_1)*(1-P_2)*P_3*SITE_LIKELIHOOD[2]+(1-P_1)*(1-P_2)*(1-P_3)*P_4*SITE_LIKELIHOOD[3]+(1-P_1)*(1-P_2)*(1-P_3)*(1-P_4)*SITE_LIKELIHOOD[4])");

Optimize (res, lf);

/* test epilogue */
	timeMatrix = endTestTimer 				  (_testDescription);
	if (logTestResult (Abs (res[1][0] - _expectedLL) < 0.01))
	{
		return timeMatrix;
	}
	return 0;
/* end test epilogue */

END;
