{-# LANGUAGE CPP #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.Functions
-- Copyright   :  (c) Sven Panne 2015
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All raw functions from the
-- <http://www.opengl.org/registry/ OpenGL registry>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.Functions (
  glAccum,
  glAccumxOES,
  glActiveProgramEXT,
  glActiveShaderProgram,
  glActiveShaderProgramEXT,
  glActiveStencilFaceEXT,
  glActiveTexture,
  glActiveTextureARB,
  glActiveVaryingNV,
  glAlphaFragmentOp1ATI,
  glAlphaFragmentOp2ATI,
  glAlphaFragmentOp3ATI,
  glAlphaFunc,
  glAlphaFuncQCOM,
  glAlphaFuncx,
  glAlphaFuncxOES,
  glApplyTextureEXT,
  glAreProgramsResidentNV,
  glAreTexturesResident,
  glAreTexturesResidentEXT,
  glArrayElement,
  glArrayElementEXT,
  glArrayObjectATI,
  glAsyncMarkerSGIX,
  glAttachObjectARB,
  glAttachShader,
  glBegin,
  glBeginConditionalRender,
  glBeginConditionalRenderNV,
  glBeginConditionalRenderNVX,
  glBeginFragmentShaderATI,
  glBeginOcclusionQueryNV,
  glBeginPerfMonitorAMD,
  glBeginPerfQueryINTEL,
  glBeginQuery,
  glBeginQueryARB,
  glBeginQueryEXT,
  glBeginQueryIndexed,
  glBeginTransformFeedback,
  glBeginTransformFeedbackEXT,
  glBeginTransformFeedbackNV,
  glBeginVertexShaderEXT,
  glBeginVideoCaptureNV,
  glBindAttribLocation,
  glBindAttribLocationARB,
  glBindBuffer,
  glBindBufferARB,
  glBindBufferBase,
  glBindBufferBaseEXT,
  glBindBufferBaseNV,
  glBindBufferOffsetEXT,
  glBindBufferOffsetNV,
  glBindBufferRange,
  glBindBufferRangeEXT,
  glBindBufferRangeNV,
  glBindBuffersBase,
  glBindBuffersRange,
  glBindFragDataLocation,
  glBindFragDataLocationEXT,
  glBindFragDataLocationIndexed,
  glBindFragmentShaderATI,
  glBindFramebuffer,
  glBindFramebufferEXT,
  glBindFramebufferOES,
  glBindImageTexture,
  glBindImageTextureEXT,
  glBindImageTextures,
  glBindLightParameterEXT,
  glBindMaterialParameterEXT,
  glBindMultiTextureEXT,
  glBindParameterEXT,
  glBindProgramARB,
  glBindProgramNV,
  glBindProgramPipeline,
  glBindProgramPipelineEXT,
  glBindRenderbuffer,
  glBindRenderbufferEXT,
  glBindRenderbufferOES,
  glBindSampler,
  glBindSamplers,
  glBindTexGenParameterEXT,
  glBindTexture,
  glBindTextureEXT,
  glBindTextureUnit,
  glBindTextureUnitParameterEXT,
  glBindTextures,
  glBindTransformFeedback,
  glBindTransformFeedbackNV,
  glBindVertexArray,
  glBindVertexArrayAPPLE,
  glBindVertexArrayOES,
  glBindVertexBuffer,
  glBindVertexBuffers,
  glBindVertexShaderEXT,
  glBindVideoCaptureStreamBufferNV,
  glBindVideoCaptureStreamTextureNV,
  glBinormal3bEXT,
  glBinormal3bvEXT,
  glBinormal3dEXT,
  glBinormal3dvEXT,
  glBinormal3fEXT,
  glBinormal3fvEXT,
  glBinormal3iEXT,
  glBinormal3ivEXT,
  glBinormal3sEXT,
  glBinormal3svEXT,
  glBinormalPointerEXT,
  glBitmap,
  glBitmapxOES,
  glBlendBarrierKHR,
  glBlendBarrierNV,
  glBlendColor,
  glBlendColorEXT,
  glBlendColorxOES,
  glBlendEquation,
  glBlendEquationEXT,
  glBlendEquationIndexedAMD,
  glBlendEquationOES,
  glBlendEquationSeparate,
  glBlendEquationSeparateEXT,
  glBlendEquationSeparateIndexedAMD,
  glBlendEquationSeparateOES,
  glBlendEquationSeparatei,
  glBlendEquationSeparateiARB,
  glBlendEquationSeparateiEXT,
  glBlendEquationSeparateiOES,
  glBlendEquationi,
  glBlendEquationiARB,
  glBlendEquationiEXT,
  glBlendEquationiOES,
  glBlendFunc,
  glBlendFuncIndexedAMD,
  glBlendFuncSeparate,
  glBlendFuncSeparateEXT,
  glBlendFuncSeparateINGR,
  glBlendFuncSeparateIndexedAMD,
  glBlendFuncSeparateOES,
  glBlendFuncSeparatei,
  glBlendFuncSeparateiARB,
  glBlendFuncSeparateiEXT,
  glBlendFuncSeparateiOES,
  glBlendFunci,
  glBlendFunciARB,
  glBlendFunciEXT,
  glBlendFunciOES,
  glBlendParameteriNV,
  glBlitFramebuffer,
  glBlitFramebufferANGLE,
  glBlitFramebufferEXT,
  glBlitFramebufferNV,
  glBlitNamedFramebuffer,
  glBufferAddressRangeNV,
  glBufferData,
  glBufferDataARB,
  glBufferPageCommitmentARB,
  glBufferParameteriAPPLE,
  glBufferStorage,
  glBufferSubData,
  glBufferSubDataARB,
  glCallList,
  glCallLists,
  glCheckFramebufferStatus,
  glCheckFramebufferStatusEXT,
  glCheckFramebufferStatusOES,
  glCheckNamedFramebufferStatus,
  glCheckNamedFramebufferStatusEXT,
  glClampColor,
  glClampColorARB,
  glClear,
  glClearAccum,
  glClearAccumxOES,
  glClearBufferData,
  glClearBufferSubData,
  glClearBufferfi,
  glClearBufferfv,
  glClearBufferiv,
  glClearBufferuiv,
  glClearColor,
  glClearColorIiEXT,
  glClearColorIuiEXT,
  glClearColorx,
  glClearColorxOES,
  glClearDepth,
  glClearDepthdNV,
  glClearDepthf,
  glClearDepthfOES,
  glClearDepthx,
  glClearDepthxOES,
  glClearIndex,
  glClearNamedBufferData,
  glClearNamedBufferDataEXT,
  glClearNamedBufferSubData,
  glClearNamedBufferSubDataEXT,
  glClearNamedFramebufferfi,
  glClearNamedFramebufferfv,
  glClearNamedFramebufferiv,
  glClearNamedFramebufferuiv,
  glClearStencil,
  glClearTexImage,
  glClearTexSubImage,
  glClientActiveTexture,
  glClientActiveTextureARB,
  glClientActiveVertexStreamATI,
  glClientAttribDefaultEXT,
  glClientWaitSync,
  glClientWaitSyncAPPLE,
  glClipControl,
  glClipPlane,
  glClipPlanef,
  glClipPlanefIMG,
  glClipPlanefOES,
  glClipPlanex,
  glClipPlanexIMG,
  glClipPlanexOES,
  glColor3b,
  glColor3bv,
  glColor3d,
  glColor3dv,
  glColor3f,
  glColor3fVertex3fSUN,
  glColor3fVertex3fvSUN,
  glColor3fv,
  glColor3hNV,
  glColor3hvNV,
  glColor3i,
  glColor3iv,
  glColor3s,
  glColor3sv,
  glColor3ub,
  glColor3ubv,
  glColor3ui,
  glColor3uiv,
  glColor3us,
  glColor3usv,
  glColor3xOES,
  glColor3xvOES,
  glColor4b,
  glColor4bv,
  glColor4d,
  glColor4dv,
  glColor4f,
  glColor4fNormal3fVertex3fSUN,
  glColor4fNormal3fVertex3fvSUN,
  glColor4fv,
  glColor4hNV,
  glColor4hvNV,
  glColor4i,
  glColor4iv,
  glColor4s,
  glColor4sv,
  glColor4ub,
  glColor4ubVertex2fSUN,
  glColor4ubVertex2fvSUN,
  glColor4ubVertex3fSUN,
  glColor4ubVertex3fvSUN,
  glColor4ubv,
  glColor4ui,
  glColor4uiv,
  glColor4us,
  glColor4usv,
  glColor4x,
  glColor4xOES,
  glColor4xvOES,
  glColorFormatNV,
  glColorFragmentOp1ATI,
  glColorFragmentOp2ATI,
  glColorFragmentOp3ATI,
  glColorMask,
  glColorMaskIndexedEXT,
  glColorMaski,
  glColorMaskiEXT,
  glColorMaskiOES,
  glColorMaterial,
  glColorP3ui,
  glColorP3uiv,
  glColorP4ui,
  glColorP4uiv,
  glColorPointer,
  glColorPointerEXT,
  glColorPointerListIBM,
  glColorPointervINTEL,
  glColorSubTable,
  glColorSubTableEXT,
  glColorTable,
  glColorTableEXT,
  glColorTableParameterfv,
  glColorTableParameterfvSGI,
  glColorTableParameteriv,
  glColorTableParameterivSGI,
  glColorTableSGI,
  glCombinerInputNV,
  glCombinerOutputNV,
  glCombinerParameterfNV,
  glCombinerParameterfvNV,
  glCombinerParameteriNV,
  glCombinerParameterivNV,
  glCombinerStageParameterfvNV,
  glCompileShader,
  glCompileShaderARB,
  glCompileShaderIncludeARB,
  glCompressedMultiTexImage1DEXT,
  glCompressedMultiTexImage2DEXT,
  glCompressedMultiTexImage3DEXT,
  glCompressedMultiTexSubImage1DEXT,
  glCompressedMultiTexSubImage2DEXT,
  glCompressedMultiTexSubImage3DEXT,
  glCompressedTexImage1D,
  glCompressedTexImage1DARB,
  glCompressedTexImage2D,
  glCompressedTexImage2DARB,
  glCompressedTexImage3D,
  glCompressedTexImage3DARB,
  glCompressedTexImage3DOES,
  glCompressedTexSubImage1D,
  glCompressedTexSubImage1DARB,
  glCompressedTexSubImage2D,
  glCompressedTexSubImage2DARB,
  glCompressedTexSubImage3D,
  glCompressedTexSubImage3DARB,
  glCompressedTexSubImage3DOES,
  glCompressedTextureImage1DEXT,
  glCompressedTextureImage2DEXT,
  glCompressedTextureImage3DEXT,
  glCompressedTextureSubImage1D,
  glCompressedTextureSubImage1DEXT,
  glCompressedTextureSubImage2D,
  glCompressedTextureSubImage2DEXT,
  glCompressedTextureSubImage3D,
  glCompressedTextureSubImage3DEXT,
  glConvolutionFilter1D,
  glConvolutionFilter1DEXT,
  glConvolutionFilter2D,
  glConvolutionFilter2DEXT,
  glConvolutionParameterf,
  glConvolutionParameterfEXT,
  glConvolutionParameterfv,
  glConvolutionParameterfvEXT,
  glConvolutionParameteri,
  glConvolutionParameteriEXT,
  glConvolutionParameteriv,
  glConvolutionParameterivEXT,
  glConvolutionParameterxOES,
  glConvolutionParameterxvOES,
  glCopyBufferSubData,
  glCopyBufferSubDataNV,
  glCopyColorSubTable,
  glCopyColorSubTableEXT,
  glCopyColorTable,
  glCopyColorTableSGI,
  glCopyConvolutionFilter1D,
  glCopyConvolutionFilter1DEXT,
  glCopyConvolutionFilter2D,
  glCopyConvolutionFilter2DEXT,
  glCopyImageSubData,
  glCopyImageSubDataEXT,
  glCopyImageSubDataNV,
  glCopyImageSubDataOES,
  glCopyMultiTexImage1DEXT,
  glCopyMultiTexImage2DEXT,
  glCopyMultiTexSubImage1DEXT,
  glCopyMultiTexSubImage2DEXT,
  glCopyMultiTexSubImage3DEXT,
  glCopyNamedBufferSubData,
  glCopyPathNV,
  glCopyPixels,
  glCopyTexImage1D,
  glCopyTexImage1DEXT,
  glCopyTexImage2D,
  glCopyTexImage2DEXT,
  glCopyTexSubImage1D,
  glCopyTexSubImage1DEXT,
  glCopyTexSubImage2D,
  glCopyTexSubImage2DEXT,
  glCopyTexSubImage3D,
  glCopyTexSubImage3DEXT,
  glCopyTexSubImage3DOES,
  glCopyTextureImage1DEXT,
  glCopyTextureImage2DEXT,
  glCopyTextureLevelsAPPLE,
  glCopyTextureSubImage1D,
  glCopyTextureSubImage1DEXT,
  glCopyTextureSubImage2D,
  glCopyTextureSubImage2DEXT,
  glCopyTextureSubImage3D,
  glCopyTextureSubImage3DEXT,
  glCoverFillPathInstancedNV,
  glCoverFillPathNV,
  glCoverStrokePathInstancedNV,
  glCoverStrokePathNV,
  glCoverageMaskNV,
  glCoverageModulationNV,
  glCoverageModulationTableNV,
  glCoverageOperationNV,
  glCreateBuffers,
  glCreateFramebuffers,
  glCreatePerfQueryINTEL,
  glCreateProgram,
  glCreateProgramObjectARB,
  glCreateProgramPipelines,
  glCreateQueries,
  glCreateRenderbuffers,
  glCreateSamplers,
  glCreateShader,
  glCreateShaderObjectARB,
  glCreateShaderProgramEXT,
  glCreateShaderProgramv,
  glCreateShaderProgramvEXT,
  glCreateSyncFromCLeventARB,
  glCreateTextures,
  glCreateTransformFeedbacks,
  glCreateVertexArrays,
  glCullFace,
  glCullParameterdvEXT,
  glCullParameterfvEXT,
  glCurrentPaletteMatrixARB,
  glCurrentPaletteMatrixOES,
  glDebugMessageCallback,
  glDebugMessageCallbackAMD,
  glDebugMessageCallbackARB,
  glDebugMessageCallbackKHR,
  glDebugMessageControl,
  glDebugMessageControlARB,
  glDebugMessageControlKHR,
  glDebugMessageEnableAMD,
  glDebugMessageInsert,
  glDebugMessageInsertAMD,
  glDebugMessageInsertARB,
  glDebugMessageInsertKHR,
  glDeformSGIX,
  glDeformationMap3dSGIX,
  glDeformationMap3fSGIX,
  glDeleteAsyncMarkersSGIX,
  glDeleteBuffers,
  glDeleteBuffersARB,
  glDeleteFencesAPPLE,
  glDeleteFencesNV,
  glDeleteFragmentShaderATI,
  glDeleteFramebuffers,
  glDeleteFramebuffersEXT,
  glDeleteFramebuffersOES,
  glDeleteLists,
  glDeleteNamedStringARB,
  glDeleteNamesAMD,
  glDeleteObjectARB,
  glDeleteOcclusionQueriesNV,
  glDeletePathsNV,
  glDeletePerfMonitorsAMD,
  glDeletePerfQueryINTEL,
  glDeleteProgram,
  glDeleteProgramPipelines,
  glDeleteProgramPipelinesEXT,
  glDeleteProgramsARB,
  glDeleteProgramsNV,
  glDeleteQueries,
  glDeleteQueriesARB,
  glDeleteQueriesEXT,
  glDeleteRenderbuffers,
  glDeleteRenderbuffersEXT,
  glDeleteRenderbuffersOES,
  glDeleteSamplers,
  glDeleteShader,
  glDeleteSync,
  glDeleteSyncAPPLE,
  glDeleteTextures,
  glDeleteTexturesEXT,
  glDeleteTransformFeedbacks,
  glDeleteTransformFeedbacksNV,
  glDeleteVertexArrays,
  glDeleteVertexArraysAPPLE,
  glDeleteVertexArraysOES,
  glDeleteVertexShaderEXT,
  glDepthBoundsEXT,
  glDepthBoundsdNV,
  glDepthFunc,
  glDepthMask,
  glDepthRange,
  glDepthRangeArrayfvNV,
  glDepthRangeArrayv,
  glDepthRangeIndexed,
  glDepthRangeIndexedfNV,
  glDepthRangedNV,
  glDepthRangef,
  glDepthRangefOES,
  glDepthRangex,
  glDepthRangexOES,
  glDetachObjectARB,
  glDetachShader,
  glDetailTexFuncSGIS,
  glDisable,
  glDisableClientState,
  glDisableClientStateIndexedEXT,
  glDisableClientStateiEXT,
  glDisableDriverControlQCOM,
  glDisableIndexedEXT,
  glDisableVariantClientStateEXT,
  glDisableVertexArrayAttrib,
  glDisableVertexArrayAttribEXT,
  glDisableVertexArrayEXT,
  glDisableVertexAttribAPPLE,
  glDisableVertexAttribArray,
  glDisableVertexAttribArrayARB,
  glDisablei,
  glDisableiEXT,
  glDisableiNV,
  glDisableiOES,
  glDiscardFramebufferEXT,
  glDispatchCompute,
  glDispatchComputeGroupSizeARB,
  glDispatchComputeIndirect,
  glDrawArrays,
  glDrawArraysEXT,
  glDrawArraysIndirect,
  glDrawArraysInstanced,
  glDrawArraysInstancedANGLE,
  glDrawArraysInstancedARB,
  glDrawArraysInstancedBaseInstance,
  glDrawArraysInstancedBaseInstanceEXT,
  glDrawArraysInstancedEXT,
  glDrawArraysInstancedNV,
  glDrawBuffer,
  glDrawBuffers,
  glDrawBuffersARB,
  glDrawBuffersATI,
  glDrawBuffersEXT,
  glDrawBuffersIndexedEXT,
  glDrawBuffersNV,
  glDrawElementArrayAPPLE,
  glDrawElementArrayATI,
  glDrawElements,
  glDrawElementsBaseVertex,
  glDrawElementsBaseVertexEXT,
  glDrawElementsBaseVertexOES,
  glDrawElementsIndirect,
  glDrawElementsInstanced,
  glDrawElementsInstancedANGLE,
  glDrawElementsInstancedARB,
  glDrawElementsInstancedBaseInstance,
  glDrawElementsInstancedBaseInstanceEXT,
  glDrawElementsInstancedBaseVertex,
  glDrawElementsInstancedBaseVertexBaseInstance,
  glDrawElementsInstancedBaseVertexBaseInstanceEXT,
  glDrawElementsInstancedBaseVertexEXT,
  glDrawElementsInstancedBaseVertexOES,
  glDrawElementsInstancedEXT,
  glDrawElementsInstancedNV,
  glDrawMeshArraysSUN,
  glDrawPixels,
  glDrawRangeElementArrayAPPLE,
  glDrawRangeElementArrayATI,
  glDrawRangeElements,
  glDrawRangeElementsBaseVertex,
  glDrawRangeElementsBaseVertexEXT,
  glDrawRangeElementsBaseVertexOES,
  glDrawRangeElementsEXT,
  glDrawTexfOES,
  glDrawTexfvOES,
  glDrawTexiOES,
  glDrawTexivOES,
  glDrawTexsOES,
  glDrawTexsvOES,
  glDrawTextureNV,
  glDrawTexxOES,
  glDrawTexxvOES,
  glDrawTransformFeedback,
  glDrawTransformFeedbackInstanced,
  glDrawTransformFeedbackNV,
  glDrawTransformFeedbackStream,
  glDrawTransformFeedbackStreamInstanced,
  glEGLImageTargetRenderbufferStorageOES,
  glEGLImageTargetTexture2DOES,
  glEdgeFlag,
  glEdgeFlagFormatNV,
  glEdgeFlagPointer,
  glEdgeFlagPointerEXT,
  glEdgeFlagPointerListIBM,
  glEdgeFlagv,
  glElementPointerAPPLE,
  glElementPointerATI,
  glEnable,
  glEnableClientState,
  glEnableClientStateIndexedEXT,
  glEnableClientStateiEXT,
  glEnableDriverControlQCOM,
  glEnableIndexedEXT,
  glEnableVariantClientStateEXT,
  glEnableVertexArrayAttrib,
  glEnableVertexArrayAttribEXT,
  glEnableVertexArrayEXT,
  glEnableVertexAttribAPPLE,
  glEnableVertexAttribArray,
  glEnableVertexAttribArrayARB,
  glEnablei,
  glEnableiEXT,
  glEnableiNV,
  glEnableiOES,
  glEnd,
  glEndConditionalRender,
  glEndConditionalRenderNV,
  glEndConditionalRenderNVX,
  glEndFragmentShaderATI,
  glEndList,
  glEndOcclusionQueryNV,
  glEndPerfMonitorAMD,
  glEndPerfQueryINTEL,
  glEndQuery,
  glEndQueryARB,
  glEndQueryEXT,
  glEndQueryIndexed,
  glEndTilingQCOM,
  glEndTransformFeedback,
  glEndTransformFeedbackEXT,
  glEndTransformFeedbackNV,
  glEndVertexShaderEXT,
  glEndVideoCaptureNV,
  glEvalCoord1d,
  glEvalCoord1dv,
  glEvalCoord1f,
  glEvalCoord1fv,
  glEvalCoord1xOES,
  glEvalCoord1xvOES,
  glEvalCoord2d,
  glEvalCoord2dv,
  glEvalCoord2f,
  glEvalCoord2fv,
  glEvalCoord2xOES,
  glEvalCoord2xvOES,
  glEvalMapsNV,
  glEvalMesh1,
  glEvalMesh2,
  glEvalPoint1,
  glEvalPoint2,
  glExecuteProgramNV,
  glExtGetBufferPointervQCOM,
  glExtGetBuffersQCOM,
  glExtGetFramebuffersQCOM,
  glExtGetProgramBinarySourceQCOM,
  glExtGetProgramsQCOM,
  glExtGetRenderbuffersQCOM,
  glExtGetShadersQCOM,
  glExtGetTexLevelParameterivQCOM,
  glExtGetTexSubImageQCOM,
  glExtGetTexturesQCOM,
  glExtIsProgramBinaryQCOM,
  glExtTexObjectStateOverrideiQCOM,
  glExtractComponentEXT,
  glFeedbackBuffer,
  glFeedbackBufferxOES,
  glFenceSync,
  glFenceSyncAPPLE,
  glFinalCombinerInputNV,
  glFinish,
  glFinishAsyncSGIX,
  glFinishFenceAPPLE,
  glFinishFenceNV,
  glFinishObjectAPPLE,
  glFinishTextureSUNX,
  glFlush,
  glFlushMappedBufferRange,
  glFlushMappedBufferRangeAPPLE,
  glFlushMappedBufferRangeEXT,
  glFlushMappedNamedBufferRange,
  glFlushMappedNamedBufferRangeEXT,
  glFlushPixelDataRangeNV,
  glFlushRasterSGIX,
  glFlushStaticDataIBM,
  glFlushVertexArrayRangeAPPLE,
  glFlushVertexArrayRangeNV,
  glFogCoordFormatNV,
  glFogCoordPointer,
  glFogCoordPointerEXT,
  glFogCoordPointerListIBM,
  glFogCoordd,
  glFogCoorddEXT,
  glFogCoorddv,
  glFogCoorddvEXT,
  glFogCoordf,
  glFogCoordfEXT,
  glFogCoordfv,
  glFogCoordfvEXT,
  glFogCoordhNV,
  glFogCoordhvNV,
  glFogFuncSGIS,
  glFogf,
  glFogfv,
  glFogi,
  glFogiv,
  glFogx,
  glFogxOES,
  glFogxv,
  glFogxvOES,
  glFragmentColorMaterialSGIX,
  glFragmentCoverageColorNV,
  glFragmentLightModelfSGIX,
  glFragmentLightModelfvSGIX,
  glFragmentLightModeliSGIX,
  glFragmentLightModelivSGIX,
  glFragmentLightfSGIX,
  glFragmentLightfvSGIX,
  glFragmentLightiSGIX,
  glFragmentLightivSGIX,
  glFragmentMaterialfSGIX,
  glFragmentMaterialfvSGIX,
  glFragmentMaterialiSGIX,
  glFragmentMaterialivSGIX,
  glFrameTerminatorGREMEDY,
  glFrameZoomSGIX,
  glFramebufferDrawBufferEXT,
  glFramebufferDrawBuffersEXT,
  glFramebufferParameteri,
  glFramebufferReadBufferEXT,
  glFramebufferRenderbuffer,
  glFramebufferRenderbufferEXT,
  glFramebufferRenderbufferOES,
  glFramebufferSampleLocationsfvNV,
  glFramebufferTexture,
  glFramebufferTexture1D,
  glFramebufferTexture1DEXT,
  glFramebufferTexture2D,
  glFramebufferTexture2DEXT,
  glFramebufferTexture2DMultisampleEXT,
  glFramebufferTexture2DMultisampleIMG,
  glFramebufferTexture2DOES,
  glFramebufferTexture3D,
  glFramebufferTexture3DEXT,
  glFramebufferTexture3DOES,
  glFramebufferTextureARB,
  glFramebufferTextureEXT,
  glFramebufferTextureFaceARB,
  glFramebufferTextureFaceEXT,
  glFramebufferTextureLayer,
  glFramebufferTextureLayerARB,
  glFramebufferTextureLayerEXT,
  glFramebufferTextureOES,
  glFreeObjectBufferATI,
  glFrontFace,
  glFrustum,
  glFrustumf,
  glFrustumfOES,
  glFrustumx,
  glFrustumxOES,
  glGenAsyncMarkersSGIX,
  glGenBuffers,
  glGenBuffersARB,
  glGenFencesAPPLE,
  glGenFencesNV,
  glGenFragmentShadersATI,
  glGenFramebuffers,
  glGenFramebuffersEXT,
  glGenFramebuffersOES,
  glGenLists,
  glGenNamesAMD,
  glGenOcclusionQueriesNV,
  glGenPathsNV,
  glGenPerfMonitorsAMD,
  glGenProgramPipelines,
  glGenProgramPipelinesEXT,
  glGenProgramsARB,
  glGenProgramsNV,
  glGenQueries,
  glGenQueriesARB,
  glGenQueriesEXT,
  glGenRenderbuffers,
  glGenRenderbuffersEXT,
  glGenRenderbuffersOES,
  glGenSamplers,
  glGenSymbolsEXT,
  glGenTextures,
  glGenTexturesEXT,
  glGenTransformFeedbacks,
  glGenTransformFeedbacksNV,
  glGenVertexArrays,
  glGenVertexArraysAPPLE,
  glGenVertexArraysOES,
  glGenVertexShadersEXT,
  glGenerateMipmap,
  glGenerateMipmapEXT,
  glGenerateMipmapOES,
  glGenerateMultiTexMipmapEXT,
  glGenerateTextureMipmap,
  glGenerateTextureMipmapEXT,
  glGetActiveAtomicCounterBufferiv,
  glGetActiveAttrib,
  glGetActiveAttribARB,
  glGetActiveSubroutineName,
  glGetActiveSubroutineUniformName,
  glGetActiveSubroutineUniformiv,
  glGetActiveUniform,
  glGetActiveUniformARB,
  glGetActiveUniformBlockName,
  glGetActiveUniformBlockiv,
  glGetActiveUniformName,
  glGetActiveUniformsiv,
  glGetActiveVaryingNV,
  glGetArrayObjectfvATI,
  glGetArrayObjectivATI,
  glGetAttachedObjectsARB,
  glGetAttachedShaders,
  glGetAttribLocation,
  glGetAttribLocationARB,
  glGetBooleanIndexedvEXT,
  glGetBooleani_v,
  glGetBooleanv,
  glGetBufferParameteri64v,
  glGetBufferParameteriv,
  glGetBufferParameterivARB,
  glGetBufferParameterui64vNV,
  glGetBufferPointerv,
  glGetBufferPointervARB,
  glGetBufferPointervOES,
  glGetBufferSubData,
  glGetBufferSubDataARB,
  glGetClipPlane,
  glGetClipPlanef,
  glGetClipPlanefOES,
  glGetClipPlanex,
  glGetClipPlanexOES,
  glGetColorTable,
  glGetColorTableEXT,
  glGetColorTableParameterfv,
  glGetColorTableParameterfvEXT,
  glGetColorTableParameterfvSGI,
  glGetColorTableParameteriv,
  glGetColorTableParameterivEXT,
  glGetColorTableParameterivSGI,
  glGetColorTableSGI,
  glGetCombinerInputParameterfvNV,
  glGetCombinerInputParameterivNV,
  glGetCombinerOutputParameterfvNV,
  glGetCombinerOutputParameterivNV,
  glGetCombinerStageParameterfvNV,
  glGetCompressedMultiTexImageEXT,
  glGetCompressedTexImage,
  glGetCompressedTexImageARB,
  glGetCompressedTextureImage,
  glGetCompressedTextureImageEXT,
  glGetCompressedTextureSubImage,
  glGetConvolutionFilter,
  glGetConvolutionFilterEXT,
  glGetConvolutionParameterfv,
  glGetConvolutionParameterfvEXT,
  glGetConvolutionParameteriv,
  glGetConvolutionParameterivEXT,
  glGetConvolutionParameterxvOES,
  glGetCoverageModulationTableNV,
  glGetDebugMessageLog,
  glGetDebugMessageLogAMD,
  glGetDebugMessageLogARB,
  glGetDebugMessageLogKHR,
  glGetDetailTexFuncSGIS,
  glGetDoubleIndexedvEXT,
  glGetDoublei_v,
  glGetDoublei_vEXT,
  glGetDoublev,
  glGetDriverControlStringQCOM,
  glGetDriverControlsQCOM,
  glGetError,
  glGetFenceivNV,
  glGetFinalCombinerInputParameterfvNV,
  glGetFinalCombinerInputParameterivNV,
  glGetFirstPerfQueryIdINTEL,
  glGetFixedv,
  glGetFixedvOES,
  glGetFloatIndexedvEXT,
  glGetFloati_v,
  glGetFloati_vEXT,
  glGetFloati_vNV,
  glGetFloatv,
  glGetFogFuncSGIS,
  glGetFragDataIndex,
  glGetFragDataLocation,
  glGetFragDataLocationEXT,
  glGetFragmentLightfvSGIX,
  glGetFragmentLightivSGIX,
  glGetFragmentMaterialfvSGIX,
  glGetFragmentMaterialivSGIX,
  glGetFramebufferAttachmentParameteriv,
  glGetFramebufferAttachmentParameterivEXT,
  glGetFramebufferAttachmentParameterivOES,
  glGetFramebufferParameteriv,
  glGetFramebufferParameterivEXT,
  glGetGraphicsResetStatus,
  glGetGraphicsResetStatusARB,
  glGetGraphicsResetStatusEXT,
  glGetGraphicsResetStatusKHR,
  glGetHandleARB,
  glGetHistogram,
  glGetHistogramEXT,
  glGetHistogramParameterfv,
  glGetHistogramParameterfvEXT,
  glGetHistogramParameteriv,
  glGetHistogramParameterivEXT,
  glGetHistogramParameterxvOES,
  glGetImageHandleARB,
  glGetImageHandleNV,
  glGetImageTransformParameterfvHP,
  glGetImageTransformParameterivHP,
  glGetInfoLogARB,
  glGetInstrumentsSGIX,
  glGetInteger64i_v,
  glGetInteger64v,
  glGetInteger64vAPPLE,
  glGetIntegerIndexedvEXT,
  glGetIntegeri_v,
  glGetIntegeri_vEXT,
  glGetIntegerui64i_vNV,
  glGetIntegerui64vNV,
  glGetIntegerv,
  glGetInternalformatSampleivNV,
  glGetInternalformati64v,
  glGetInternalformativ,
  glGetInvariantBooleanvEXT,
  glGetInvariantFloatvEXT,
  glGetInvariantIntegervEXT,
  glGetLightfv,
  glGetLightiv,
  glGetLightxOES,
  glGetLightxv,
  glGetLightxvOES,
  glGetListParameterfvSGIX,
  glGetListParameterivSGIX,
  glGetLocalConstantBooleanvEXT,
  glGetLocalConstantFloatvEXT,
  glGetLocalConstantIntegervEXT,
  glGetMapAttribParameterfvNV,
  glGetMapAttribParameterivNV,
  glGetMapControlPointsNV,
  glGetMapParameterfvNV,
  glGetMapParameterivNV,
  glGetMapdv,
  glGetMapfv,
  glGetMapiv,
  glGetMapxvOES,
  glGetMaterialfv,
  glGetMaterialiv,
  glGetMaterialxOES,
  glGetMaterialxv,
  glGetMaterialxvOES,
  glGetMinmax,
  glGetMinmaxEXT,
  glGetMinmaxParameterfv,
  glGetMinmaxParameterfvEXT,
  glGetMinmaxParameteriv,
  glGetMinmaxParameterivEXT,
  glGetMultiTexEnvfvEXT,
  glGetMultiTexEnvivEXT,
  glGetMultiTexGendvEXT,
  glGetMultiTexGenfvEXT,
  glGetMultiTexGenivEXT,
  glGetMultiTexImageEXT,
  glGetMultiTexLevelParameterfvEXT,
  glGetMultiTexLevelParameterivEXT,
  glGetMultiTexParameterIivEXT,
  glGetMultiTexParameterIuivEXT,
  glGetMultiTexParameterfvEXT,
  glGetMultiTexParameterivEXT,
  glGetMultisamplefv,
  glGetMultisamplefvNV,
  glGetNamedBufferParameteri64v,
  glGetNamedBufferParameteriv,
  glGetNamedBufferParameterivEXT,
  glGetNamedBufferParameterui64vNV,
  glGetNamedBufferPointerv,
  glGetNamedBufferPointervEXT,
  glGetNamedBufferSubData,
  glGetNamedBufferSubDataEXT,
  glGetNamedFramebufferAttachmentParameteriv,
  glGetNamedFramebufferAttachmentParameterivEXT,
  glGetNamedFramebufferParameteriv,
  glGetNamedFramebufferParameterivEXT,
  glGetNamedProgramLocalParameterIivEXT,
  glGetNamedProgramLocalParameterIuivEXT,
  glGetNamedProgramLocalParameterdvEXT,
  glGetNamedProgramLocalParameterfvEXT,
  glGetNamedProgramStringEXT,
  glGetNamedProgramivEXT,
  glGetNamedRenderbufferParameteriv,
  glGetNamedRenderbufferParameterivEXT,
  glGetNamedStringARB,
  glGetNamedStringivARB,
  glGetNextPerfQueryIdINTEL,
  glGetObjectBufferfvATI,
  glGetObjectBufferivATI,
  glGetObjectLabel,
  glGetObjectLabelEXT,
  glGetObjectLabelKHR,
  glGetObjectParameterfvARB,
  glGetObjectParameterivAPPLE,
  glGetObjectParameterivARB,
  glGetObjectPtrLabel,
  glGetObjectPtrLabelKHR,
  glGetOcclusionQueryivNV,
  glGetOcclusionQueryuivNV,
  glGetPathColorGenfvNV,
  glGetPathColorGenivNV,
  glGetPathCommandsNV,
  glGetPathCoordsNV,
  glGetPathDashArrayNV,
  glGetPathLengthNV,
  glGetPathMetricRangeNV,
  glGetPathMetricsNV,
  glGetPathParameterfvNV,
  glGetPathParameterivNV,
  glGetPathSpacingNV,
  glGetPathTexGenfvNV,
  glGetPathTexGenivNV,
  glGetPerfCounterInfoINTEL,
  glGetPerfMonitorCounterDataAMD,
  glGetPerfMonitorCounterInfoAMD,
  glGetPerfMonitorCounterStringAMD,
  glGetPerfMonitorCountersAMD,
  glGetPerfMonitorGroupStringAMD,
  glGetPerfMonitorGroupsAMD,
  glGetPerfQueryDataINTEL,
  glGetPerfQueryIdByNameINTEL,
  glGetPerfQueryInfoINTEL,
  glGetPixelMapfv,
  glGetPixelMapuiv,
  glGetPixelMapusv,
  glGetPixelMapxv,
  glGetPixelTexGenParameterfvSGIS,
  glGetPixelTexGenParameterivSGIS,
  glGetPixelTransformParameterfvEXT,
  glGetPixelTransformParameterivEXT,
  glGetPointerIndexedvEXT,
  glGetPointeri_vEXT,
  glGetPointerv,
  glGetPointervEXT,
  glGetPointervKHR,
  glGetPolygonStipple,
  glGetProgramBinary,
  glGetProgramBinaryOES,
  glGetProgramEnvParameterIivNV,
  glGetProgramEnvParameterIuivNV,
  glGetProgramEnvParameterdvARB,
  glGetProgramEnvParameterfvARB,
  glGetProgramInfoLog,
  glGetProgramInterfaceiv,
  glGetProgramLocalParameterIivNV,
  glGetProgramLocalParameterIuivNV,
  glGetProgramLocalParameterdvARB,
  glGetProgramLocalParameterfvARB,
  glGetProgramNamedParameterdvNV,
  glGetProgramNamedParameterfvNV,
  glGetProgramParameterdvNV,
  glGetProgramParameterfvNV,
  glGetProgramPipelineInfoLog,
  glGetProgramPipelineInfoLogEXT,
  glGetProgramPipelineiv,
  glGetProgramPipelineivEXT,
  glGetProgramResourceIndex,
  glGetProgramResourceLocation,
  glGetProgramResourceLocationIndex,
  glGetProgramResourceName,
  glGetProgramResourcefvNV,
  glGetProgramResourceiv,
  glGetProgramStageiv,
  glGetProgramStringARB,
  glGetProgramStringNV,
  glGetProgramSubroutineParameteruivNV,
  glGetProgramiv,
  glGetProgramivARB,
  glGetProgramivNV,
  glGetQueryBufferObjecti64v,
  glGetQueryBufferObjectiv,
  glGetQueryBufferObjectui64v,
  glGetQueryBufferObjectuiv,
  glGetQueryIndexediv,
  glGetQueryObjecti64v,
  glGetQueryObjecti64vEXT,
  glGetQueryObjectiv,
  glGetQueryObjectivARB,
  glGetQueryObjectivEXT,
  glGetQueryObjectui64v,
  glGetQueryObjectui64vEXT,
  glGetQueryObjectuiv,
  glGetQueryObjectuivARB,
  glGetQueryObjectuivEXT,
  glGetQueryiv,
  glGetQueryivARB,
  glGetQueryivEXT,
  glGetRenderbufferParameteriv,
  glGetRenderbufferParameterivEXT,
  glGetRenderbufferParameterivOES,
  glGetSamplerParameterIiv,
  glGetSamplerParameterIivEXT,
  glGetSamplerParameterIivOES,
  glGetSamplerParameterIuiv,
  glGetSamplerParameterIuivEXT,
  glGetSamplerParameterIuivOES,
  glGetSamplerParameterfv,
  glGetSamplerParameteriv,
  glGetSeparableFilter,
  glGetSeparableFilterEXT,
  glGetShaderInfoLog,
  glGetShaderPrecisionFormat,
  glGetShaderSource,
  glGetShaderSourceARB,
  glGetShaderiv,
  glGetSharpenTexFuncSGIS,
  glGetString,
  glGetStringi,
  glGetSubroutineIndex,
  glGetSubroutineUniformLocation,
  glGetSynciv,
  glGetSyncivAPPLE,
  glGetTexBumpParameterfvATI,
  glGetTexBumpParameterivATI,
  glGetTexEnvfv,
  glGetTexEnviv,
  glGetTexEnvxv,
  glGetTexEnvxvOES,
  glGetTexFilterFuncSGIS,
  glGetTexGendv,
  glGetTexGenfv,
  glGetTexGenfvOES,
  glGetTexGeniv,
  glGetTexGenivOES,
  glGetTexGenxvOES,
  glGetTexImage,
  glGetTexLevelParameterfv,
  glGetTexLevelParameteriv,
  glGetTexLevelParameterxvOES,
  glGetTexParameterIiv,
  glGetTexParameterIivEXT,
  glGetTexParameterIivOES,
  glGetTexParameterIuiv,
  glGetTexParameterIuivEXT,
  glGetTexParameterIuivOES,
  glGetTexParameterPointervAPPLE,
  glGetTexParameterfv,
  glGetTexParameteriv,
  glGetTexParameterxv,
  glGetTexParameterxvOES,
  glGetTextureHandleARB,
  glGetTextureHandleNV,
  glGetTextureImage,
  glGetTextureImageEXT,
  glGetTextureLevelParameterfv,
  glGetTextureLevelParameterfvEXT,
  glGetTextureLevelParameteriv,
  glGetTextureLevelParameterivEXT,
  glGetTextureParameterIiv,
  glGetTextureParameterIivEXT,
  glGetTextureParameterIuiv,
  glGetTextureParameterIuivEXT,
  glGetTextureParameterfv,
  glGetTextureParameterfvEXT,
  glGetTextureParameteriv,
  glGetTextureParameterivEXT,
  glGetTextureSamplerHandleARB,
  glGetTextureSamplerHandleNV,
  glGetTextureSubImage,
  glGetTrackMatrixivNV,
  glGetTransformFeedbackVarying,
  glGetTransformFeedbackVaryingEXT,
  glGetTransformFeedbackVaryingNV,
  glGetTransformFeedbacki64_v,
  glGetTransformFeedbacki_v,
  glGetTransformFeedbackiv,
  glGetTranslatedShaderSourceANGLE,
  glGetUniformBlockIndex,
  glGetUniformBufferSizeEXT,
  glGetUniformIndices,
  glGetUniformLocation,
  glGetUniformLocationARB,
  glGetUniformOffsetEXT,
  glGetUniformSubroutineuiv,
  glGetUniformdv,
  glGetUniformfv,
  glGetUniformfvARB,
  glGetUniformi64vNV,
  glGetUniformiv,
  glGetUniformivARB,
  glGetUniformui64vNV,
  glGetUniformuiv,
  glGetUniformuivEXT,
  glGetVariantArrayObjectfvATI,
  glGetVariantArrayObjectivATI,
  glGetVariantBooleanvEXT,
  glGetVariantFloatvEXT,
  glGetVariantIntegervEXT,
  glGetVariantPointervEXT,
  glGetVaryingLocationNV,
  glGetVertexArrayIndexed64iv,
  glGetVertexArrayIndexediv,
  glGetVertexArrayIntegeri_vEXT,
  glGetVertexArrayIntegervEXT,
  glGetVertexArrayPointeri_vEXT,
  glGetVertexArrayPointervEXT,
  glGetVertexArrayiv,
  glGetVertexAttribArrayObjectfvATI,
  glGetVertexAttribArrayObjectivATI,
  glGetVertexAttribIiv,
  glGetVertexAttribIivEXT,
  glGetVertexAttribIuiv,
  glGetVertexAttribIuivEXT,
  glGetVertexAttribLdv,
  glGetVertexAttribLdvEXT,
  glGetVertexAttribLi64vNV,
  glGetVertexAttribLui64vARB,
  glGetVertexAttribLui64vNV,
  glGetVertexAttribPointerv,
  glGetVertexAttribPointervARB,
  glGetVertexAttribPointervNV,
  glGetVertexAttribdv,
  glGetVertexAttribdvARB,
  glGetVertexAttribdvNV,
  glGetVertexAttribfv,
  glGetVertexAttribfvARB,
  glGetVertexAttribfvNV,
  glGetVertexAttribiv,
  glGetVertexAttribivARB,
  glGetVertexAttribivNV,
  glGetVideoCaptureStreamdvNV,
  glGetVideoCaptureStreamfvNV,
  glGetVideoCaptureStreamivNV,
  glGetVideoCaptureivNV,
  glGetVideoi64vNV,
  glGetVideoivNV,
  glGetVideoui64vNV,
  glGetVideouivNV,
  glGetnColorTable,
  glGetnColorTableARB,
  glGetnCompressedTexImage,
  glGetnCompressedTexImageARB,
  glGetnConvolutionFilter,
  glGetnConvolutionFilterARB,
  glGetnHistogram,
  glGetnHistogramARB,
  glGetnMapdv,
  glGetnMapdvARB,
  glGetnMapfv,
  glGetnMapfvARB,
  glGetnMapiv,
  glGetnMapivARB,
  glGetnMinmax,
  glGetnMinmaxARB,
  glGetnPixelMapfv,
  glGetnPixelMapfvARB,
  glGetnPixelMapuiv,
  glGetnPixelMapuivARB,
  glGetnPixelMapusv,
  glGetnPixelMapusvARB,
  glGetnPolygonStipple,
  glGetnPolygonStippleARB,
  glGetnSeparableFilter,
  glGetnSeparableFilterARB,
  glGetnTexImage,
  glGetnTexImageARB,
  glGetnUniformdv,
  glGetnUniformdvARB,
  glGetnUniformfv,
  glGetnUniformfvARB,
  glGetnUniformfvEXT,
  glGetnUniformfvKHR,
  glGetnUniformiv,
  glGetnUniformivARB,
  glGetnUniformivEXT,
  glGetnUniformivKHR,
  glGetnUniformuiv,
  glGetnUniformuivARB,
  glGetnUniformuivKHR,
  glGlobalAlphaFactorbSUN,
  glGlobalAlphaFactordSUN,
  glGlobalAlphaFactorfSUN,
  glGlobalAlphaFactoriSUN,
  glGlobalAlphaFactorsSUN,
  glGlobalAlphaFactorubSUN,
  glGlobalAlphaFactoruiSUN,
  glGlobalAlphaFactorusSUN,
  glHint,
  glHintPGI,
  glHistogram,
  glHistogramEXT,
  glIglooInterfaceSGIX,
  glImageTransformParameterfHP,
  glImageTransformParameterfvHP,
  glImageTransformParameteriHP,
  glImageTransformParameterivHP,
  glImportSyncEXT,
  glIndexFormatNV,
  glIndexFuncEXT,
  glIndexMask,
  glIndexMaterialEXT,
  glIndexPointer,
  glIndexPointerEXT,
  glIndexPointerListIBM,
  glIndexd,
  glIndexdv,
  glIndexf,
  glIndexfv,
  glIndexi,
  glIndexiv,
  glIndexs,
  glIndexsv,
  glIndexub,
  glIndexubv,
  glIndexxOES,
  glIndexxvOES,
  glInitNames,
  glInsertComponentEXT,
  glInsertEventMarkerEXT,
  glInstrumentsBufferSGIX,
  glInterleavedArrays,
  glInterpolatePathsNV,
  glInvalidateBufferData,
  glInvalidateBufferSubData,
  glInvalidateFramebuffer,
  glInvalidateNamedFramebufferData,
  glInvalidateNamedFramebufferSubData,
  glInvalidateSubFramebuffer,
  glInvalidateTexImage,
  glInvalidateTexSubImage,
  glIsAsyncMarkerSGIX,
  glIsBuffer,
  glIsBufferARB,
  glIsBufferResidentNV,
  glIsEnabled,
  glIsEnabledIndexedEXT,
  glIsEnabledi,
  glIsEnablediEXT,
  glIsEnablediNV,
  glIsEnablediOES,
  glIsFenceAPPLE,
  glIsFenceNV,
  glIsFramebuffer,
  glIsFramebufferEXT,
  glIsFramebufferOES,
  glIsImageHandleResidentARB,
  glIsImageHandleResidentNV,
  glIsList,
  glIsNameAMD,
  glIsNamedBufferResidentNV,
  glIsNamedStringARB,
  glIsObjectBufferATI,
  glIsOcclusionQueryNV,
  glIsPathNV,
  glIsPointInFillPathNV,
  glIsPointInStrokePathNV,
  glIsProgram,
  glIsProgramARB,
  glIsProgramNV,
  glIsProgramPipeline,
  glIsProgramPipelineEXT,
  glIsQuery,
  glIsQueryARB,
  glIsQueryEXT,
  glIsRenderbuffer,
  glIsRenderbufferEXT,
  glIsRenderbufferOES,
  glIsSampler,
  glIsShader,
  glIsSync,
  glIsSyncAPPLE,
  glIsTexture,
  glIsTextureEXT,
  glIsTextureHandleResidentARB,
  glIsTextureHandleResidentNV,
  glIsTransformFeedback,
  glIsTransformFeedbackNV,
  glIsVariantEnabledEXT,
  glIsVertexArray,
  glIsVertexArrayAPPLE,
  glIsVertexArrayOES,
  glIsVertexAttribEnabledAPPLE,
  glLabelObjectEXT,
  glLightEnviSGIX,
  glLightModelf,
  glLightModelfv,
  glLightModeli,
  glLightModeliv,
  glLightModelx,
  glLightModelxOES,
  glLightModelxv,
  glLightModelxvOES,
  glLightf,
  glLightfv,
  glLighti,
  glLightiv,
  glLightx,
  glLightxOES,
  glLightxv,
  glLightxvOES,
  glLineStipple,
  glLineWidth,
  glLineWidthx,
  glLineWidthxOES,
  glLinkProgram,
  glLinkProgramARB,
  glListBase,
  glListParameterfSGIX,
  glListParameterfvSGIX,
  glListParameteriSGIX,
  glListParameterivSGIX,
  glLoadIdentity,
  glLoadIdentityDeformationMapSGIX,
  glLoadMatrixd,
  glLoadMatrixf,
  glLoadMatrixx,
  glLoadMatrixxOES,
  glLoadName,
  glLoadPaletteFromModelViewMatrixOES,
  glLoadProgramNV,
  glLoadTransposeMatrixd,
  glLoadTransposeMatrixdARB,
  glLoadTransposeMatrixf,
  glLoadTransposeMatrixfARB,
  glLoadTransposeMatrixxOES,
  glLockArraysEXT,
  glLogicOp,
  glMakeBufferNonResidentNV,
  glMakeBufferResidentNV,
  glMakeImageHandleNonResidentARB,
  glMakeImageHandleNonResidentNV,
  glMakeImageHandleResidentARB,
  glMakeImageHandleResidentNV,
  glMakeNamedBufferNonResidentNV,
  glMakeNamedBufferResidentNV,
  glMakeTextureHandleNonResidentARB,
  glMakeTextureHandleNonResidentNV,
  glMakeTextureHandleResidentARB,
  glMakeTextureHandleResidentNV,
  glMap1d,
  glMap1f,
  glMap1xOES,
  glMap2d,
  glMap2f,
  glMap2xOES,
  glMapBuffer,
  glMapBufferARB,
  glMapBufferOES,
  glMapBufferRange,
  glMapBufferRangeEXT,
  glMapControlPointsNV,
  glMapGrid1d,
  glMapGrid1f,
  glMapGrid1xOES,
  glMapGrid2d,
  glMapGrid2f,
  glMapGrid2xOES,
  glMapNamedBuffer,
  glMapNamedBufferEXT,
  glMapNamedBufferRange,
  glMapNamedBufferRangeEXT,
  glMapObjectBufferATI,
  glMapParameterfvNV,
  glMapParameterivNV,
  glMapTexture2DINTEL,
  glMapVertexAttrib1dAPPLE,
  glMapVertexAttrib1fAPPLE,
  glMapVertexAttrib2dAPPLE,
  glMapVertexAttrib2fAPPLE,
  glMaterialf,
  glMaterialfv,
  glMateriali,
  glMaterialiv,
  glMaterialx,
  glMaterialxOES,
  glMaterialxv,
  glMaterialxvOES,
  glMatrixFrustumEXT,
  glMatrixIndexPointerARB,
  glMatrixIndexPointerOES,
  glMatrixIndexubvARB,
  glMatrixIndexuivARB,
  glMatrixIndexusvARB,
  glMatrixLoad3x2fNV,
  glMatrixLoad3x3fNV,
  glMatrixLoadIdentityEXT,
  glMatrixLoadTranspose3x3fNV,
  glMatrixLoadTransposedEXT,
  glMatrixLoadTransposefEXT,
  glMatrixLoaddEXT,
  glMatrixLoadfEXT,
  glMatrixMode,
  glMatrixMult3x2fNV,
  glMatrixMult3x3fNV,
  glMatrixMultTranspose3x3fNV,
  glMatrixMultTransposedEXT,
  glMatrixMultTransposefEXT,
  glMatrixMultdEXT,
  glMatrixMultfEXT,
  glMatrixOrthoEXT,
  glMatrixPopEXT,
  glMatrixPushEXT,
  glMatrixRotatedEXT,
  glMatrixRotatefEXT,
  glMatrixScaledEXT,
  glMatrixScalefEXT,
  glMatrixTranslatedEXT,
  glMatrixTranslatefEXT,
  glMemoryBarrier,
  glMemoryBarrierByRegion,
  glMemoryBarrierEXT,
  glMinSampleShading,
  glMinSampleShadingARB,
  glMinSampleShadingOES,
  glMinmax,
  glMinmaxEXT,
  glMultMatrixd,
  glMultMatrixf,
  glMultMatrixx,
  glMultMatrixxOES,
  glMultTransposeMatrixd,
  glMultTransposeMatrixdARB,
  glMultTransposeMatrixf,
  glMultTransposeMatrixfARB,
  glMultTransposeMatrixxOES,
  glMultiDrawArrays,
  glMultiDrawArraysEXT,
  glMultiDrawArraysIndirect,
  glMultiDrawArraysIndirectAMD,
  glMultiDrawArraysIndirectBindlessCountNV,
  glMultiDrawArraysIndirectBindlessNV,
  glMultiDrawArraysIndirectCountARB,
  glMultiDrawArraysIndirectEXT,
  glMultiDrawElementArrayAPPLE,
  glMultiDrawElements,
  glMultiDrawElementsBaseVertex,
  glMultiDrawElementsBaseVertexEXT,
  glMultiDrawElementsBaseVertexOES,
  glMultiDrawElementsEXT,
  glMultiDrawElementsIndirect,
  glMultiDrawElementsIndirectAMD,
  glMultiDrawElementsIndirectBindlessCountNV,
  glMultiDrawElementsIndirectBindlessNV,
  glMultiDrawElementsIndirectCountARB,
  glMultiDrawElementsIndirectEXT,
  glMultiDrawRangeElementArrayAPPLE,
  glMultiModeDrawArraysIBM,
  glMultiModeDrawElementsIBM,
  glMultiTexBufferEXT,
  glMultiTexCoord1bOES,
  glMultiTexCoord1bvOES,
  glMultiTexCoord1d,
  glMultiTexCoord1dARB,
  glMultiTexCoord1dv,
  glMultiTexCoord1dvARB,
  glMultiTexCoord1f,
  glMultiTexCoord1fARB,
  glMultiTexCoord1fv,
  glMultiTexCoord1fvARB,
  glMultiTexCoord1hNV,
  glMultiTexCoord1hvNV,
  glMultiTexCoord1i,
  glMultiTexCoord1iARB,
  glMultiTexCoord1iv,
  glMultiTexCoord1ivARB,
  glMultiTexCoord1s,
  glMultiTexCoord1sARB,
  glMultiTexCoord1sv,
  glMultiTexCoord1svARB,
  glMultiTexCoord1xOES,
  glMultiTexCoord1xvOES,
  glMultiTexCoord2bOES,
  glMultiTexCoord2bvOES,
  glMultiTexCoord2d,
  glMultiTexCoord2dARB,
  glMultiTexCoord2dv,
  glMultiTexCoord2dvARB,
  glMultiTexCoord2f,
  glMultiTexCoord2fARB,
  glMultiTexCoord2fv,
  glMultiTexCoord2fvARB,
  glMultiTexCoord2hNV,
  glMultiTexCoord2hvNV,
  glMultiTexCoord2i,
  glMultiTexCoord2iARB,
  glMultiTexCoord2iv,
  glMultiTexCoord2ivARB,
  glMultiTexCoord2s,
  glMultiTexCoord2sARB,
  glMultiTexCoord2sv,
  glMultiTexCoord2svARB,
  glMultiTexCoord2xOES,
  glMultiTexCoord2xvOES,
  glMultiTexCoord3bOES,
  glMultiTexCoord3bvOES,
  glMultiTexCoord3d,
  glMultiTexCoord3dARB,
  glMultiTexCoord3dv,
  glMultiTexCoord3dvARB,
  glMultiTexCoord3f,
  glMultiTexCoord3fARB,
  glMultiTexCoord3fv,
  glMultiTexCoord3fvARB,
  glMultiTexCoord3hNV,
  glMultiTexCoord3hvNV,
  glMultiTexCoord3i,
  glMultiTexCoord3iARB,
  glMultiTexCoord3iv,
  glMultiTexCoord3ivARB,
  glMultiTexCoord3s,
  glMultiTexCoord3sARB,
  glMultiTexCoord3sv,
  glMultiTexCoord3svARB,
  glMultiTexCoord3xOES,
  glMultiTexCoord3xvOES,
  glMultiTexCoord4bOES,
  glMultiTexCoord4bvOES,
  glMultiTexCoord4d,
  glMultiTexCoord4dARB,
  glMultiTexCoord4dv,
  glMultiTexCoord4dvARB,
  glMultiTexCoord4f,
  glMultiTexCoord4fARB,
  glMultiTexCoord4fv,
  glMultiTexCoord4fvARB,
  glMultiTexCoord4hNV,
  glMultiTexCoord4hvNV,
  glMultiTexCoord4i,
  glMultiTexCoord4iARB,
  glMultiTexCoord4iv,
  glMultiTexCoord4ivARB,
  glMultiTexCoord4s,
  glMultiTexCoord4sARB,
  glMultiTexCoord4sv,
  glMultiTexCoord4svARB,
  glMultiTexCoord4x,
  glMultiTexCoord4xOES,
  glMultiTexCoord4xvOES,
  glMultiTexCoordP1ui,
  glMultiTexCoordP1uiv,
  glMultiTexCoordP2ui,
  glMultiTexCoordP2uiv,
  glMultiTexCoordP3ui,
  glMultiTexCoordP3uiv,
  glMultiTexCoordP4ui,
  glMultiTexCoordP4uiv,
  glMultiTexCoordPointerEXT,
  glMultiTexEnvfEXT,
  glMultiTexEnvfvEXT,
  glMultiTexEnviEXT,
  glMultiTexEnvivEXT,
  glMultiTexGendEXT,
  glMultiTexGendvEXT,
  glMultiTexGenfEXT,
  glMultiTexGenfvEXT,
  glMultiTexGeniEXT,
  glMultiTexGenivEXT,
  glMultiTexImage1DEXT,
  glMultiTexImage2DEXT,
  glMultiTexImage3DEXT,
  glMultiTexParameterIivEXT,
  glMultiTexParameterIuivEXT,
  glMultiTexParameterfEXT,
  glMultiTexParameterfvEXT,
  glMultiTexParameteriEXT,
  glMultiTexParameterivEXT,
  glMultiTexRenderbufferEXT,
  glMultiTexSubImage1DEXT,
  glMultiTexSubImage2DEXT,
  glMultiTexSubImage3DEXT,
  glNamedBufferData,
  glNamedBufferDataEXT,
  glNamedBufferPageCommitmentARB,
  glNamedBufferPageCommitmentEXT,
  glNamedBufferStorage,
  glNamedBufferStorageEXT,
  glNamedBufferSubData,
  glNamedBufferSubDataEXT,
  glNamedCopyBufferSubDataEXT,
  glNamedFramebufferDrawBuffer,
  glNamedFramebufferDrawBuffers,
  glNamedFramebufferParameteri,
  glNamedFramebufferParameteriEXT,
  glNamedFramebufferReadBuffer,
  glNamedFramebufferRenderbuffer,
  glNamedFramebufferRenderbufferEXT,
  glNamedFramebufferSampleLocationsfvNV,
  glNamedFramebufferTexture,
  glNamedFramebufferTexture1DEXT,
  glNamedFramebufferTexture2DEXT,
  glNamedFramebufferTexture3DEXT,
  glNamedFramebufferTextureEXT,
  glNamedFramebufferTextureFaceEXT,
  glNamedFramebufferTextureLayer,
  glNamedFramebufferTextureLayerEXT,
  glNamedProgramLocalParameter4dEXT,
  glNamedProgramLocalParameter4dvEXT,
  glNamedProgramLocalParameter4fEXT,
  glNamedProgramLocalParameter4fvEXT,
  glNamedProgramLocalParameterI4iEXT,
  glNamedProgramLocalParameterI4ivEXT,
  glNamedProgramLocalParameterI4uiEXT,
  glNamedProgramLocalParameterI4uivEXT,
  glNamedProgramLocalParameters4fvEXT,
  glNamedProgramLocalParametersI4ivEXT,
  glNamedProgramLocalParametersI4uivEXT,
  glNamedProgramStringEXT,
  glNamedRenderbufferStorage,
  glNamedRenderbufferStorageEXT,
  glNamedRenderbufferStorageMultisample,
  glNamedRenderbufferStorageMultisampleCoverageEXT,
  glNamedRenderbufferStorageMultisampleEXT,
  glNamedStringARB,
  glNewList,
  glNewObjectBufferATI,
  glNormal3b,
  glNormal3bv,
  glNormal3d,
  glNormal3dv,
  glNormal3f,
  glNormal3fVertex3fSUN,
  glNormal3fVertex3fvSUN,
  glNormal3fv,
  glNormal3hNV,
  glNormal3hvNV,
  glNormal3i,
  glNormal3iv,
  glNormal3s,
  glNormal3sv,
  glNormal3x,
  glNormal3xOES,
  glNormal3xvOES,
  glNormalFormatNV,
  glNormalP3ui,
  glNormalP3uiv,
  glNormalPointer,
  glNormalPointerEXT,
  glNormalPointerListIBM,
  glNormalPointervINTEL,
  glNormalStream3bATI,
  glNormalStream3bvATI,
  glNormalStream3dATI,
  glNormalStream3dvATI,
  glNormalStream3fATI,
  glNormalStream3fvATI,
  glNormalStream3iATI,
  glNormalStream3ivATI,
  glNormalStream3sATI,
  glNormalStream3svATI,
  glObjectLabel,
  glObjectLabelKHR,
  glObjectPtrLabel,
  glObjectPtrLabelKHR,
  glObjectPurgeableAPPLE,
  glObjectUnpurgeableAPPLE,
  glOrtho,
  glOrthof,
  glOrthofOES,
  glOrthox,
  glOrthoxOES,
  glPNTrianglesfATI,
  glPNTrianglesiATI,
  glPassTexCoordATI,
  glPassThrough,
  glPassThroughxOES,
  glPatchParameterfv,
  glPatchParameteri,
  glPatchParameteriEXT,
  glPatchParameteriOES,
  glPathColorGenNV,
  glPathCommandsNV,
  glPathCoordsNV,
  glPathCoverDepthFuncNV,
  glPathDashArrayNV,
  glPathFogGenNV,
  glPathGlyphIndexArrayNV,
  glPathGlyphIndexRangeNV,
  glPathGlyphRangeNV,
  glPathGlyphsNV,
  glPathMemoryGlyphIndexArrayNV,
  glPathParameterfNV,
  glPathParameterfvNV,
  glPathParameteriNV,
  glPathParameterivNV,
  glPathStencilDepthOffsetNV,
  glPathStencilFuncNV,
  glPathStringNV,
  glPathSubCommandsNV,
  glPathSubCoordsNV,
  glPathTexGenNV,
  glPauseTransformFeedback,
  glPauseTransformFeedbackNV,
  glPixelDataRangeNV,
  glPixelMapfv,
  glPixelMapuiv,
  glPixelMapusv,
  glPixelMapx,
  glPixelStoref,
  glPixelStorei,
  glPixelStorex,
  glPixelTexGenParameterfSGIS,
  glPixelTexGenParameterfvSGIS,
  glPixelTexGenParameteriSGIS,
  glPixelTexGenParameterivSGIS,
  glPixelTexGenSGIX,
  glPixelTransferf,
  glPixelTransferi,
  glPixelTransferxOES,
  glPixelTransformParameterfEXT,
  glPixelTransformParameterfvEXT,
  glPixelTransformParameteriEXT,
  glPixelTransformParameterivEXT,
  glPixelZoom,
  glPixelZoomxOES,
  glPointAlongPathNV,
  glPointParameterf,
  glPointParameterfARB,
  glPointParameterfEXT,
  glPointParameterfSGIS,
  glPointParameterfv,
  glPointParameterfvARB,
  glPointParameterfvEXT,
  glPointParameterfvSGIS,
  glPointParameteri,
  glPointParameteriNV,
  glPointParameteriv,
  glPointParameterivNV,
  glPointParameterx,
  glPointParameterxOES,
  glPointParameterxv,
  glPointParameterxvOES,
  glPointSize,
  glPointSizePointerOES,
  glPointSizex,
  glPointSizexOES,
  glPollAsyncSGIX,
  glPollInstrumentsSGIX,
  glPolygonMode,
  glPolygonOffset,
  glPolygonOffsetClampEXT,
  glPolygonOffsetEXT,
  glPolygonOffsetx,
  glPolygonOffsetxOES,
  glPolygonStipple,
  glPopAttrib,
  glPopClientAttrib,
  glPopDebugGroup,
  glPopDebugGroupKHR,
  glPopGroupMarkerEXT,
  glPopMatrix,
  glPopName,
  glPresentFrameDualFillNV,
  glPresentFrameKeyedNV,
  glPrimitiveBoundingBoxEXT,
  glPrimitiveBoundingBoxOES,
  glPrimitiveRestartIndex,
  glPrimitiveRestartIndexNV,
  glPrimitiveRestartNV,
  glPrioritizeTextures,
  glPrioritizeTexturesEXT,
  glPrioritizeTexturesxOES,
  glProgramBinary,
  glProgramBinaryOES,
  glProgramBufferParametersIivNV,
  glProgramBufferParametersIuivNV,
  glProgramBufferParametersfvNV,
  glProgramEnvParameter4dARB,
  glProgramEnvParameter4dvARB,
  glProgramEnvParameter4fARB,
  glProgramEnvParameter4fvARB,
  glProgramEnvParameterI4iNV,
  glProgramEnvParameterI4ivNV,
  glProgramEnvParameterI4uiNV,
  glProgramEnvParameterI4uivNV,
  glProgramEnvParameters4fvEXT,
  glProgramEnvParametersI4ivNV,
  glProgramEnvParametersI4uivNV,
  glProgramLocalParameter4dARB,
  glProgramLocalParameter4dvARB,
  glProgramLocalParameter4fARB,
  glProgramLocalParameter4fvARB,
  glProgramLocalParameterI4iNV,
  glProgramLocalParameterI4ivNV,
  glProgramLocalParameterI4uiNV,
  glProgramLocalParameterI4uivNV,
  glProgramLocalParameters4fvEXT,
  glProgramLocalParametersI4ivNV,
  glProgramLocalParametersI4uivNV,
  glProgramNamedParameter4dNV,
  glProgramNamedParameter4dvNV,
  glProgramNamedParameter4fNV,
  glProgramNamedParameter4fvNV,
  glProgramParameter4dNV,
  glProgramParameter4dvNV,
  glProgramParameter4fNV,
  glProgramParameter4fvNV,
  glProgramParameteri,
  glProgramParameteriARB,
  glProgramParameteriEXT,
  glProgramParameters4dvNV,
  glProgramParameters4fvNV,
  glProgramPathFragmentInputGenNV,
  glProgramStringARB,
  glProgramSubroutineParametersuivNV,
  glProgramUniform1d,
  glProgramUniform1dEXT,
  glProgramUniform1dv,
  glProgramUniform1dvEXT,
  glProgramUniform1f,
  glProgramUniform1fEXT,
  glProgramUniform1fv,
  glProgramUniform1fvEXT,
  glProgramUniform1i,
  glProgramUniform1i64NV,
  glProgramUniform1i64vNV,
  glProgramUniform1iEXT,
  glProgramUniform1iv,
  glProgramUniform1ivEXT,
  glProgramUniform1ui,
  glProgramUniform1ui64NV,
  glProgramUniform1ui64vNV,
  glProgramUniform1uiEXT,
  glProgramUniform1uiv,
  glProgramUniform1uivEXT,
  glProgramUniform2d,
  glProgramUniform2dEXT,
  glProgramUniform2dv,
  glProgramUniform2dvEXT,
  glProgramUniform2f,
  glProgramUniform2fEXT,
  glProgramUniform2fv,
  glProgramUniform2fvEXT,
  glProgramUniform2i,
  glProgramUniform2i64NV,
  glProgramUniform2i64vNV,
  glProgramUniform2iEXT,
  glProgramUniform2iv,
  glProgramUniform2ivEXT,
  glProgramUniform2ui,
  glProgramUniform2ui64NV,
  glProgramUniform2ui64vNV,
  glProgramUniform2uiEXT,
  glProgramUniform2uiv,
  glProgramUniform2uivEXT,
  glProgramUniform3d,
  glProgramUniform3dEXT,
  glProgramUniform3dv,
  glProgramUniform3dvEXT,
  glProgramUniform3f,
  glProgramUniform3fEXT,
  glProgramUniform3fv,
  glProgramUniform3fvEXT,
  glProgramUniform3i,
  glProgramUniform3i64NV,
  glProgramUniform3i64vNV,
  glProgramUniform3iEXT,
  glProgramUniform3iv,
  glProgramUniform3ivEXT,
  glProgramUniform3ui,
  glProgramUniform3ui64NV,
  glProgramUniform3ui64vNV,
  glProgramUniform3uiEXT,
  glProgramUniform3uiv,
  glProgramUniform3uivEXT,
  glProgramUniform4d,
  glProgramUniform4dEXT,
  glProgramUniform4dv,
  glProgramUniform4dvEXT,
  glProgramUniform4f,
  glProgramUniform4fEXT,
  glProgramUniform4fv,
  glProgramUniform4fvEXT,
  glProgramUniform4i,
  glProgramUniform4i64NV,
  glProgramUniform4i64vNV,
  glProgramUniform4iEXT,
  glProgramUniform4iv,
  glProgramUniform4ivEXT,
  glProgramUniform4ui,
  glProgramUniform4ui64NV,
  glProgramUniform4ui64vNV,
  glProgramUniform4uiEXT,
  glProgramUniform4uiv,
  glProgramUniform4uivEXT,
  glProgramUniformHandleui64ARB,
  glProgramUniformHandleui64NV,
  glProgramUniformHandleui64vARB,
  glProgramUniformHandleui64vNV,
  glProgramUniformMatrix2dv,
  glProgramUniformMatrix2dvEXT,
  glProgramUniformMatrix2fv,
  glProgramUniformMatrix2fvEXT,
  glProgramUniformMatrix2x3dv,
  glProgramUniformMatrix2x3dvEXT,
  glProgramUniformMatrix2x3fv,
  glProgramUniformMatrix2x3fvEXT,
  glProgramUniformMatrix2x4dv,
  glProgramUniformMatrix2x4dvEXT,
  glProgramUniformMatrix2x4fv,
  glProgramUniformMatrix2x4fvEXT,
  glProgramUniformMatrix3dv,
  glProgramUniformMatrix3dvEXT,
  glProgramUniformMatrix3fv,
  glProgramUniformMatrix3fvEXT,
  glProgramUniformMatrix3x2dv,
  glProgramUniformMatrix3x2dvEXT,
  glProgramUniformMatrix3x2fv,
  glProgramUniformMatrix3x2fvEXT,
  glProgramUniformMatrix3x4dv,
  glProgramUniformMatrix3x4dvEXT,
  glProgramUniformMatrix3x4fv,
  glProgramUniformMatrix3x4fvEXT,
  glProgramUniformMatrix4dv,
  glProgramUniformMatrix4dvEXT,
  glProgramUniformMatrix4fv,
  glProgramUniformMatrix4fvEXT,
  glProgramUniformMatrix4x2dv,
  glProgramUniformMatrix4x2dvEXT,
  glProgramUniformMatrix4x2fv,
  glProgramUniformMatrix4x2fvEXT,
  glProgramUniformMatrix4x3dv,
  glProgramUniformMatrix4x3dvEXT,
  glProgramUniformMatrix4x3fv,
  glProgramUniformMatrix4x3fvEXT,
  glProgramUniformui64NV,
  glProgramUniformui64vNV,
  glProgramVertexLimitNV,
  glProvokingVertex,
  glProvokingVertexEXT,
  glPushAttrib,
  glPushClientAttrib,
  glPushClientAttribDefaultEXT,
  glPushDebugGroup,
  glPushDebugGroupKHR,
  glPushGroupMarkerEXT,
  glPushMatrix,
  glPushName,
  glQueryCounter,
  glQueryCounterEXT,
  glQueryMatrixxOES,
  glQueryObjectParameteruiAMD,
  glRasterPos2d,
  glRasterPos2dv,
  glRasterPos2f,
  glRasterPos2fv,
  glRasterPos2i,
  glRasterPos2iv,
  glRasterPos2s,
  glRasterPos2sv,
  glRasterPos2xOES,
  glRasterPos2xvOES,
  glRasterPos3d,
  glRasterPos3dv,
  glRasterPos3f,
  glRasterPos3fv,
  glRasterPos3i,
  glRasterPos3iv,
  glRasterPos3s,
  glRasterPos3sv,
  glRasterPos3xOES,
  glRasterPos3xvOES,
  glRasterPos4d,
  glRasterPos4dv,
  glRasterPos4f,
  glRasterPos4fv,
  glRasterPos4i,
  glRasterPos4iv,
  glRasterPos4s,
  glRasterPos4sv,
  glRasterPos4xOES,
  glRasterPos4xvOES,
  glRasterSamplesEXT,
  glReadBuffer,
  glReadBufferIndexedEXT,
  glReadBufferNV,
  glReadInstrumentsSGIX,
  glReadPixels,
  glReadnPixels,
  glReadnPixelsARB,
  glReadnPixelsEXT,
  glReadnPixelsKHR,
  glRectd,
  glRectdv,
  glRectf,
  glRectfv,
  glRecti,
  glRectiv,
  glRects,
  glRectsv,
  glRectxOES,
  glRectxvOES,
  glReferencePlaneSGIX,
  glReleaseShaderCompiler,
  glRenderMode,
  glRenderbufferStorage,
  glRenderbufferStorageEXT,
  glRenderbufferStorageMultisample,
  glRenderbufferStorageMultisampleANGLE,
  glRenderbufferStorageMultisampleAPPLE,
  glRenderbufferStorageMultisampleCoverageNV,
  glRenderbufferStorageMultisampleEXT,
  glRenderbufferStorageMultisampleIMG,
  glRenderbufferStorageMultisampleNV,
  glRenderbufferStorageOES,
  glReplacementCodePointerSUN,
  glReplacementCodeubSUN,
  glReplacementCodeubvSUN,
  glReplacementCodeuiColor3fVertex3fSUN,
  glReplacementCodeuiColor3fVertex3fvSUN,
  glReplacementCodeuiColor4fNormal3fVertex3fSUN,
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN,
  glReplacementCodeuiColor4ubVertex3fSUN,
  glReplacementCodeuiColor4ubVertex3fvSUN,
  glReplacementCodeuiNormal3fVertex3fSUN,
  glReplacementCodeuiNormal3fVertex3fvSUN,
  glReplacementCodeuiSUN,
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN,
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN,
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN,
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN,
  glReplacementCodeuiTexCoord2fVertex3fSUN,
  glReplacementCodeuiTexCoord2fVertex3fvSUN,
  glReplacementCodeuiVertex3fSUN,
  glReplacementCodeuiVertex3fvSUN,
  glReplacementCodeuivSUN,
  glReplacementCodeusSUN,
  glReplacementCodeusvSUN,
  glRequestResidentProgramsNV,
  glResetHistogram,
  glResetHistogramEXT,
  glResetMinmax,
  glResetMinmaxEXT,
  glResizeBuffersMESA,
  glResolveDepthValuesNV,
  glResolveMultisampleFramebufferAPPLE,
  glResumeTransformFeedback,
  glResumeTransformFeedbackNV,
  glRotated,
  glRotatef,
  glRotatex,
  glRotatexOES,
  glSampleCoverage,
  glSampleCoverageARB,
  glSampleCoverageOES,
  glSampleCoveragex,
  glSampleCoveragexOES,
  glSampleMapATI,
  glSampleMaskEXT,
  glSampleMaskIndexedNV,
  glSampleMaskSGIS,
  glSampleMaski,
  glSamplePatternEXT,
  glSamplePatternSGIS,
  glSamplerParameterIiv,
  glSamplerParameterIivEXT,
  glSamplerParameterIivOES,
  glSamplerParameterIuiv,
  glSamplerParameterIuivEXT,
  glSamplerParameterIuivOES,
  glSamplerParameterf,
  glSamplerParameterfv,
  glSamplerParameteri,
  glSamplerParameteriv,
  glScaled,
  glScalef,
  glScalex,
  glScalexOES,
  glScissor,
  glScissorArrayv,
  glScissorArrayvNV,
  glScissorIndexed,
  glScissorIndexedNV,
  glScissorIndexedv,
  glScissorIndexedvNV,
  glSecondaryColor3b,
  glSecondaryColor3bEXT,
  glSecondaryColor3bv,
  glSecondaryColor3bvEXT,
  glSecondaryColor3d,
  glSecondaryColor3dEXT,
  glSecondaryColor3dv,
  glSecondaryColor3dvEXT,
  glSecondaryColor3f,
  glSecondaryColor3fEXT,
  glSecondaryColor3fv,
  glSecondaryColor3fvEXT,
  glSecondaryColor3hNV,
  glSecondaryColor3hvNV,
  glSecondaryColor3i,
  glSecondaryColor3iEXT,
  glSecondaryColor3iv,
  glSecondaryColor3ivEXT,
  glSecondaryColor3s,
  glSecondaryColor3sEXT,
  glSecondaryColor3sv,
  glSecondaryColor3svEXT,
  glSecondaryColor3ub,
  glSecondaryColor3ubEXT,
  glSecondaryColor3ubv,
  glSecondaryColor3ubvEXT,
  glSecondaryColor3ui,
  glSecondaryColor3uiEXT,
  glSecondaryColor3uiv,
  glSecondaryColor3uivEXT,
  glSecondaryColor3us,
  glSecondaryColor3usEXT,
  glSecondaryColor3usv,
  glSecondaryColor3usvEXT,
  glSecondaryColorFormatNV,
  glSecondaryColorP3ui,
  glSecondaryColorP3uiv,
  glSecondaryColorPointer,
  glSecondaryColorPointerEXT,
  glSecondaryColorPointerListIBM,
  glSelectBuffer,
  glSelectPerfMonitorCountersAMD,
  glSeparableFilter2D,
  glSeparableFilter2DEXT,
  glSetFenceAPPLE,
  glSetFenceNV,
  glSetFragmentShaderConstantATI,
  glSetInvariantEXT,
  glSetLocalConstantEXT,
  glSetMultisamplefvAMD,
  glShadeModel,
  glShaderBinary,
  glShaderOp1EXT,
  glShaderOp2EXT,
  glShaderOp3EXT,
  glShaderSource,
  glShaderSourceARB,
  glShaderStorageBlockBinding,
  glSharpenTexFuncSGIS,
  glSpriteParameterfSGIX,
  glSpriteParameterfvSGIX,
  glSpriteParameteriSGIX,
  glSpriteParameterivSGIX,
  glStartInstrumentsSGIX,
  glStartTilingQCOM,
  glStencilClearTagEXT,
  glStencilFillPathInstancedNV,
  glStencilFillPathNV,
  glStencilFunc,
  glStencilFuncSeparate,
  glStencilFuncSeparateATI,
  glStencilMask,
  glStencilMaskSeparate,
  glStencilOp,
  glStencilOpSeparate,
  glStencilOpSeparateATI,
  glStencilOpValueAMD,
  glStencilStrokePathInstancedNV,
  glStencilStrokePathNV,
  glStencilThenCoverFillPathInstancedNV,
  glStencilThenCoverFillPathNV,
  glStencilThenCoverStrokePathInstancedNV,
  glStencilThenCoverStrokePathNV,
  glStopInstrumentsSGIX,
  glStringMarkerGREMEDY,
  glSubpixelPrecisionBiasNV,
  glSwizzleEXT,
  glSyncTextureINTEL,
  glTagSampleBufferSGIX,
  glTangent3bEXT,
  glTangent3bvEXT,
  glTangent3dEXT,
  glTangent3dvEXT,
  glTangent3fEXT,
  glTangent3fvEXT,
  glTangent3iEXT,
  glTangent3ivEXT,
  glTangent3sEXT,
  glTangent3svEXT,
  glTangentPointerEXT,
  glTbufferMask3DFX,
  glTessellationFactorAMD,
  glTessellationModeAMD,
  glTestFenceAPPLE,
  glTestFenceNV,
  glTestObjectAPPLE,
  glTexBuffer,
  glTexBufferARB,
  glTexBufferEXT,
  glTexBufferOES,
  glTexBufferRange,
  glTexBufferRangeEXT,
  glTexBufferRangeOES,
  glTexBumpParameterfvATI,
  glTexBumpParameterivATI,
  glTexCoord1bOES,
  glTexCoord1bvOES,
  glTexCoord1d,
  glTexCoord1dv,
  glTexCoord1f,
  glTexCoord1fv,
  glTexCoord1hNV,
  glTexCoord1hvNV,
  glTexCoord1i,
  glTexCoord1iv,
  glTexCoord1s,
  glTexCoord1sv,
  glTexCoord1xOES,
  glTexCoord1xvOES,
  glTexCoord2bOES,
  glTexCoord2bvOES,
  glTexCoord2d,
  glTexCoord2dv,
  glTexCoord2f,
  glTexCoord2fColor3fVertex3fSUN,
  glTexCoord2fColor3fVertex3fvSUN,
  glTexCoord2fColor4fNormal3fVertex3fSUN,
  glTexCoord2fColor4fNormal3fVertex3fvSUN,
  glTexCoord2fColor4ubVertex3fSUN,
  glTexCoord2fColor4ubVertex3fvSUN,
  glTexCoord2fNormal3fVertex3fSUN,
  glTexCoord2fNormal3fVertex3fvSUN,
  glTexCoord2fVertex3fSUN,
  glTexCoord2fVertex3fvSUN,
  glTexCoord2fv,
  glTexCoord2hNV,
  glTexCoord2hvNV,
  glTexCoord2i,
  glTexCoord2iv,
  glTexCoord2s,
  glTexCoord2sv,
  glTexCoord2xOES,
  glTexCoord2xvOES,
  glTexCoord3bOES,
  glTexCoord3bvOES,
  glTexCoord3d,
  glTexCoord3dv,
  glTexCoord3f,
  glTexCoord3fv,
  glTexCoord3hNV,
  glTexCoord3hvNV,
  glTexCoord3i,
  glTexCoord3iv,
  glTexCoord3s,
  glTexCoord3sv,
  glTexCoord3xOES,
  glTexCoord3xvOES,
  glTexCoord4bOES,
  glTexCoord4bvOES,
  glTexCoord4d,
  glTexCoord4dv,
  glTexCoord4f,
  glTexCoord4fColor4fNormal3fVertex4fSUN,
  glTexCoord4fColor4fNormal3fVertex4fvSUN,
  glTexCoord4fVertex4fSUN,
  glTexCoord4fVertex4fvSUN,
  glTexCoord4fv,
  glTexCoord4hNV,
  glTexCoord4hvNV,
  glTexCoord4i,
  glTexCoord4iv,
  glTexCoord4s,
  glTexCoord4sv,
  glTexCoord4xOES,
  glTexCoord4xvOES,
  glTexCoordFormatNV,
  glTexCoordP1ui,
  glTexCoordP1uiv,
  glTexCoordP2ui,
  glTexCoordP2uiv,
  glTexCoordP3ui,
  glTexCoordP3uiv,
  glTexCoordP4ui,
  glTexCoordP4uiv,
  glTexCoordPointer,
  glTexCoordPointerEXT,
  glTexCoordPointerListIBM,
  glTexCoordPointervINTEL,
  glTexEnvf,
  glTexEnvfv,
  glTexEnvi,
  glTexEnviv,
  glTexEnvx,
  glTexEnvxOES,
  glTexEnvxv,
  glTexEnvxvOES,
  glTexFilterFuncSGIS,
  glTexGend,
  glTexGendv,
  glTexGenf,
  glTexGenfOES,
  glTexGenfv,
  glTexGenfvOES,
  glTexGeni,
  glTexGeniOES,
  glTexGeniv,
  glTexGenivOES,
  glTexGenxOES,
  glTexGenxvOES,
  glTexImage1D,
  glTexImage2D,
  glTexImage2DMultisample,
  glTexImage2DMultisampleCoverageNV,
  glTexImage3D,
  glTexImage3DEXT,
  glTexImage3DMultisample,
  glTexImage3DMultisampleCoverageNV,
  glTexImage3DOES,
  glTexImage4DSGIS,
  glTexPageCommitmentARB,
  glTexParameterIiv,
  glTexParameterIivEXT,
  glTexParameterIivOES,
  glTexParameterIuiv,
  glTexParameterIuivEXT,
  glTexParameterIuivOES,
  glTexParameterf,
  glTexParameterfv,
  glTexParameteri,
  glTexParameteriv,
  glTexParameterx,
  glTexParameterxOES,
  glTexParameterxv,
  glTexParameterxvOES,
  glTexRenderbufferNV,
  glTexStorage1D,
  glTexStorage1DEXT,
  glTexStorage2D,
  glTexStorage2DEXT,
  glTexStorage2DMultisample,
  glTexStorage3D,
  glTexStorage3DEXT,
  glTexStorage3DMultisample,
  glTexStorage3DMultisampleOES,
  glTexStorageSparseAMD,
  glTexSubImage1D,
  glTexSubImage1DEXT,
  glTexSubImage2D,
  glTexSubImage2DEXT,
  glTexSubImage3D,
  glTexSubImage3DEXT,
  glTexSubImage3DOES,
  glTexSubImage4DSGIS,
  glTextureBarrier,
  glTextureBarrierNV,
  glTextureBuffer,
  glTextureBufferEXT,
  glTextureBufferRange,
  glTextureBufferRangeEXT,
  glTextureColorMaskSGIS,
  glTextureImage1DEXT,
  glTextureImage2DEXT,
  glTextureImage2DMultisampleCoverageNV,
  glTextureImage2DMultisampleNV,
  glTextureImage3DEXT,
  glTextureImage3DMultisampleCoverageNV,
  glTextureImage3DMultisampleNV,
  glTextureLightEXT,
  glTextureMaterialEXT,
  glTextureNormalEXT,
  glTexturePageCommitmentEXT,
  glTextureParameterIiv,
  glTextureParameterIivEXT,
  glTextureParameterIuiv,
  glTextureParameterIuivEXT,
  glTextureParameterf,
  glTextureParameterfEXT,
  glTextureParameterfv,
  glTextureParameterfvEXT,
  glTextureParameteri,
  glTextureParameteriEXT,
  glTextureParameteriv,
  glTextureParameterivEXT,
  glTextureRangeAPPLE,
  glTextureRenderbufferEXT,
  glTextureStorage1D,
  glTextureStorage1DEXT,
  glTextureStorage2D,
  glTextureStorage2DEXT,
  glTextureStorage2DMultisample,
  glTextureStorage2DMultisampleEXT,
  glTextureStorage3D,
  glTextureStorage3DEXT,
  glTextureStorage3DMultisample,
  glTextureStorage3DMultisampleEXT,
  glTextureStorageSparseAMD,
  glTextureSubImage1D,
  glTextureSubImage1DEXT,
  glTextureSubImage2D,
  glTextureSubImage2DEXT,
  glTextureSubImage3D,
  glTextureSubImage3DEXT,
  glTextureView,
  glTextureViewEXT,
  glTextureViewOES,
  glTrackMatrixNV,
  glTransformFeedbackAttribsNV,
  glTransformFeedbackBufferBase,
  glTransformFeedbackBufferRange,
  glTransformFeedbackStreamAttribsNV,
  glTransformFeedbackVaryings,
  glTransformFeedbackVaryingsEXT,
  glTransformFeedbackVaryingsNV,
  glTransformPathNV,
  glTranslated,
  glTranslatef,
  glTranslatex,
  glTranslatexOES,
  glUniform1d,
  glUniform1dv,
  glUniform1f,
  glUniform1fARB,
  glUniform1fv,
  glUniform1fvARB,
  glUniform1i,
  glUniform1i64NV,
  glUniform1i64vNV,
  glUniform1iARB,
  glUniform1iv,
  glUniform1ivARB,
  glUniform1ui,
  glUniform1ui64NV,
  glUniform1ui64vNV,
  glUniform1uiEXT,
  glUniform1uiv,
  glUniform1uivEXT,
  glUniform2d,
  glUniform2dv,
  glUniform2f,
  glUniform2fARB,
  glUniform2fv,
  glUniform2fvARB,
  glUniform2i,
  glUniform2i64NV,
  glUniform2i64vNV,
  glUniform2iARB,
  glUniform2iv,
  glUniform2ivARB,
  glUniform2ui,
  glUniform2ui64NV,
  glUniform2ui64vNV,
  glUniform2uiEXT,
  glUniform2uiv,
  glUniform2uivEXT,
  glUniform3d,
  glUniform3dv,
  glUniform3f,
  glUniform3fARB,
  glUniform3fv,
  glUniform3fvARB,
  glUniform3i,
  glUniform3i64NV,
  glUniform3i64vNV,
  glUniform3iARB,
  glUniform3iv,
  glUniform3ivARB,
  glUniform3ui,
  glUniform3ui64NV,
  glUniform3ui64vNV,
  glUniform3uiEXT,
  glUniform3uiv,
  glUniform3uivEXT,
  glUniform4d,
  glUniform4dv,
  glUniform4f,
  glUniform4fARB,
  glUniform4fv,
  glUniform4fvARB,
  glUniform4i,
  glUniform4i64NV,
  glUniform4i64vNV,
  glUniform4iARB,
  glUniform4iv,
  glUniform4ivARB,
  glUniform4ui,
  glUniform4ui64NV,
  glUniform4ui64vNV,
  glUniform4uiEXT,
  glUniform4uiv,
  glUniform4uivEXT,
  glUniformBlockBinding,
  glUniformBufferEXT,
  glUniformHandleui64ARB,
  glUniformHandleui64NV,
  glUniformHandleui64vARB,
  glUniformHandleui64vNV,
  glUniformMatrix2dv,
  glUniformMatrix2fv,
  glUniformMatrix2fvARB,
  glUniformMatrix2x3dv,
  glUniformMatrix2x3fv,
  glUniformMatrix2x3fvNV,
  glUniformMatrix2x4dv,
  glUniformMatrix2x4fv,
  glUniformMatrix2x4fvNV,
  glUniformMatrix3dv,
  glUniformMatrix3fv,
  glUniformMatrix3fvARB,
  glUniformMatrix3x2dv,
  glUniformMatrix3x2fv,
  glUniformMatrix3x2fvNV,
  glUniformMatrix3x4dv,
  glUniformMatrix3x4fv,
  glUniformMatrix3x4fvNV,
  glUniformMatrix4dv,
  glUniformMatrix4fv,
  glUniformMatrix4fvARB,
  glUniformMatrix4x2dv,
  glUniformMatrix4x2fv,
  glUniformMatrix4x2fvNV,
  glUniformMatrix4x3dv,
  glUniformMatrix4x3fv,
  glUniformMatrix4x3fvNV,
  glUniformSubroutinesuiv,
  glUniformui64NV,
  glUniformui64vNV,
  glUnlockArraysEXT,
  glUnmapBuffer,
  glUnmapBufferARB,
  glUnmapBufferOES,
  glUnmapNamedBuffer,
  glUnmapNamedBufferEXT,
  glUnmapObjectBufferATI,
  glUnmapTexture2DINTEL,
  glUpdateObjectBufferATI,
  glUseProgram,
  glUseProgramObjectARB,
  glUseProgramStages,
  glUseProgramStagesEXT,
  glUseShaderProgramEXT,
  glVDPAUFiniNV,
  glVDPAUGetSurfaceivNV,
  glVDPAUInitNV,
  glVDPAUIsSurfaceNV,
  glVDPAUMapSurfacesNV,
  glVDPAURegisterOutputSurfaceNV,
  glVDPAURegisterVideoSurfaceNV,
  glVDPAUSurfaceAccessNV,
  glVDPAUUnmapSurfacesNV,
  glVDPAUUnregisterSurfaceNV,
  glValidateProgram,
  glValidateProgramARB,
  glValidateProgramPipeline,
  glValidateProgramPipelineEXT,
  glVariantArrayObjectATI,
  glVariantPointerEXT,
  glVariantbvEXT,
  glVariantdvEXT,
  glVariantfvEXT,
  glVariantivEXT,
  glVariantsvEXT,
  glVariantubvEXT,
  glVariantuivEXT,
  glVariantusvEXT,
  glVertex2bOES,
  glVertex2bvOES,
  glVertex2d,
  glVertex2dv,
  glVertex2f,
  glVertex2fv,
  glVertex2hNV,
  glVertex2hvNV,
  glVertex2i,
  glVertex2iv,
  glVertex2s,
  glVertex2sv,
  glVertex2xOES,
  glVertex2xvOES,
  glVertex3bOES,
  glVertex3bvOES,
  glVertex3d,
  glVertex3dv,
  glVertex3f,
  glVertex3fv,
  glVertex3hNV,
  glVertex3hvNV,
  glVertex3i,
  glVertex3iv,
  glVertex3s,
  glVertex3sv,
  glVertex3xOES,
  glVertex3xvOES,
  glVertex4bOES,
  glVertex4bvOES,
  glVertex4d,
  glVertex4dv,
  glVertex4f,
  glVertex4fv,
  glVertex4hNV,
  glVertex4hvNV,
  glVertex4i,
  glVertex4iv,
  glVertex4s,
  glVertex4sv,
  glVertex4xOES,
  glVertex4xvOES,
  glVertexArrayAttribBinding,
  glVertexArrayAttribFormat,
  glVertexArrayAttribIFormat,
  glVertexArrayAttribLFormat,
  glVertexArrayBindVertexBufferEXT,
  glVertexArrayBindingDivisor,
  glVertexArrayColorOffsetEXT,
  glVertexArrayEdgeFlagOffsetEXT,
  glVertexArrayElementBuffer,
  glVertexArrayFogCoordOffsetEXT,
  glVertexArrayIndexOffsetEXT,
  glVertexArrayMultiTexCoordOffsetEXT,
  glVertexArrayNormalOffsetEXT,
  glVertexArrayParameteriAPPLE,
  glVertexArrayRangeAPPLE,
  glVertexArrayRangeNV,
  glVertexArraySecondaryColorOffsetEXT,
  glVertexArrayTexCoordOffsetEXT,
  glVertexArrayVertexAttribBindingEXT,
  glVertexArrayVertexAttribDivisorEXT,
  glVertexArrayVertexAttribFormatEXT,
  glVertexArrayVertexAttribIFormatEXT,
  glVertexArrayVertexAttribIOffsetEXT,
  glVertexArrayVertexAttribLFormatEXT,
  glVertexArrayVertexAttribLOffsetEXT,
  glVertexArrayVertexAttribOffsetEXT,
  glVertexArrayVertexBindingDivisorEXT,
  glVertexArrayVertexBuffer,
  glVertexArrayVertexBuffers,
  glVertexArrayVertexOffsetEXT,
  glVertexAttrib1d,
  glVertexAttrib1dARB,
  glVertexAttrib1dNV,
  glVertexAttrib1dv,
  glVertexAttrib1dvARB,
  glVertexAttrib1dvNV,
  glVertexAttrib1f,
  glVertexAttrib1fARB,
  glVertexAttrib1fNV,
  glVertexAttrib1fv,
  glVertexAttrib1fvARB,
  glVertexAttrib1fvNV,
  glVertexAttrib1hNV,
  glVertexAttrib1hvNV,
  glVertexAttrib1s,
  glVertexAttrib1sARB,
  glVertexAttrib1sNV,
  glVertexAttrib1sv,
  glVertexAttrib1svARB,
  glVertexAttrib1svNV,
  glVertexAttrib2d,
  glVertexAttrib2dARB,
  glVertexAttrib2dNV,
  glVertexAttrib2dv,
  glVertexAttrib2dvARB,
  glVertexAttrib2dvNV,
  glVertexAttrib2f,
  glVertexAttrib2fARB,
  glVertexAttrib2fNV,
  glVertexAttrib2fv,
  glVertexAttrib2fvARB,
  glVertexAttrib2fvNV,
  glVertexAttrib2hNV,
  glVertexAttrib2hvNV,
  glVertexAttrib2s,
  glVertexAttrib2sARB,
  glVertexAttrib2sNV,
  glVertexAttrib2sv,
  glVertexAttrib2svARB,
  glVertexAttrib2svNV,
  glVertexAttrib3d,
  glVertexAttrib3dARB,
  glVertexAttrib3dNV,
  glVertexAttrib3dv,
  glVertexAttrib3dvARB,
  glVertexAttrib3dvNV,
  glVertexAttrib3f,
  glVertexAttrib3fARB,
  glVertexAttrib3fNV,
  glVertexAttrib3fv,
  glVertexAttrib3fvARB,
  glVertexAttrib3fvNV,
  glVertexAttrib3hNV,
  glVertexAttrib3hvNV,
  glVertexAttrib3s,
  glVertexAttrib3sARB,
  glVertexAttrib3sNV,
  glVertexAttrib3sv,
  glVertexAttrib3svARB,
  glVertexAttrib3svNV,
  glVertexAttrib4Nbv,
  glVertexAttrib4NbvARB,
  glVertexAttrib4Niv,
  glVertexAttrib4NivARB,
  glVertexAttrib4Nsv,
  glVertexAttrib4NsvARB,
  glVertexAttrib4Nub,
  glVertexAttrib4NubARB,
  glVertexAttrib4Nubv,
  glVertexAttrib4NubvARB,
  glVertexAttrib4Nuiv,
  glVertexAttrib4NuivARB,
  glVertexAttrib4Nusv,
  glVertexAttrib4NusvARB,
  glVertexAttrib4bv,
  glVertexAttrib4bvARB,
  glVertexAttrib4d,
  glVertexAttrib4dARB,
  glVertexAttrib4dNV,
  glVertexAttrib4dv,
  glVertexAttrib4dvARB,
  glVertexAttrib4dvNV,
  glVertexAttrib4f,
  glVertexAttrib4fARB,
  glVertexAttrib4fNV,
  glVertexAttrib4fv,
  glVertexAttrib4fvARB,
  glVertexAttrib4fvNV,
  glVertexAttrib4hNV,
  glVertexAttrib4hvNV,
  glVertexAttrib4iv,
  glVertexAttrib4ivARB,
  glVertexAttrib4s,
  glVertexAttrib4sARB,
  glVertexAttrib4sNV,
  glVertexAttrib4sv,
  glVertexAttrib4svARB,
  glVertexAttrib4svNV,
  glVertexAttrib4ubNV,
  glVertexAttrib4ubv,
  glVertexAttrib4ubvARB,
  glVertexAttrib4ubvNV,
  glVertexAttrib4uiv,
  glVertexAttrib4uivARB,
  glVertexAttrib4usv,
  glVertexAttrib4usvARB,
  glVertexAttribArrayObjectATI,
  glVertexAttribBinding,
  glVertexAttribDivisor,
  glVertexAttribDivisorANGLE,
  glVertexAttribDivisorARB,
  glVertexAttribDivisorEXT,
  glVertexAttribDivisorNV,
  glVertexAttribFormat,
  glVertexAttribFormatNV,
  glVertexAttribI1i,
  glVertexAttribI1iEXT,
  glVertexAttribI1iv,
  glVertexAttribI1ivEXT,
  glVertexAttribI1ui,
  glVertexAttribI1uiEXT,
  glVertexAttribI1uiv,
  glVertexAttribI1uivEXT,
  glVertexAttribI2i,
  glVertexAttribI2iEXT,
  glVertexAttribI2iv,
  glVertexAttribI2ivEXT,
  glVertexAttribI2ui,
  glVertexAttribI2uiEXT,
  glVertexAttribI2uiv,
  glVertexAttribI2uivEXT,
  glVertexAttribI3i,
  glVertexAttribI3iEXT,
  glVertexAttribI3iv,
  glVertexAttribI3ivEXT,
  glVertexAttribI3ui,
  glVertexAttribI3uiEXT,
  glVertexAttribI3uiv,
  glVertexAttribI3uivEXT,
  glVertexAttribI4bv,
  glVertexAttribI4bvEXT,
  glVertexAttribI4i,
  glVertexAttribI4iEXT,
  glVertexAttribI4iv,
  glVertexAttribI4ivEXT,
  glVertexAttribI4sv,
  glVertexAttribI4svEXT,
  glVertexAttribI4ubv,
  glVertexAttribI4ubvEXT,
  glVertexAttribI4ui,
  glVertexAttribI4uiEXT,
  glVertexAttribI4uiv,
  glVertexAttribI4uivEXT,
  glVertexAttribI4usv,
  glVertexAttribI4usvEXT,
  glVertexAttribIFormat,
  glVertexAttribIFormatNV,
  glVertexAttribIPointer,
  glVertexAttribIPointerEXT,
  glVertexAttribL1d,
  glVertexAttribL1dEXT,
  glVertexAttribL1dv,
  glVertexAttribL1dvEXT,
  glVertexAttribL1i64NV,
  glVertexAttribL1i64vNV,
  glVertexAttribL1ui64ARB,
  glVertexAttribL1ui64NV,
  glVertexAttribL1ui64vARB,
  glVertexAttribL1ui64vNV,
  glVertexAttribL2d,
  glVertexAttribL2dEXT,
  glVertexAttribL2dv,
  glVertexAttribL2dvEXT,
  glVertexAttribL2i64NV,
  glVertexAttribL2i64vNV,
  glVertexAttribL2ui64NV,
  glVertexAttribL2ui64vNV,
  glVertexAttribL3d,
  glVertexAttribL3dEXT,
  glVertexAttribL3dv,
  glVertexAttribL3dvEXT,
  glVertexAttribL3i64NV,
  glVertexAttribL3i64vNV,
  glVertexAttribL3ui64NV,
  glVertexAttribL3ui64vNV,
  glVertexAttribL4d,
  glVertexAttribL4dEXT,
  glVertexAttribL4dv,
  glVertexAttribL4dvEXT,
  glVertexAttribL4i64NV,
  glVertexAttribL4i64vNV,
  glVertexAttribL4ui64NV,
  glVertexAttribL4ui64vNV,
  glVertexAttribLFormat,
  glVertexAttribLFormatNV,
  glVertexAttribLPointer,
  glVertexAttribLPointerEXT,
  glVertexAttribP1ui,
  glVertexAttribP1uiv,
  glVertexAttribP2ui,
  glVertexAttribP2uiv,
  glVertexAttribP3ui,
  glVertexAttribP3uiv,
  glVertexAttribP4ui,
  glVertexAttribP4uiv,
  glVertexAttribParameteriAMD,
  glVertexAttribPointer,
  glVertexAttribPointerARB,
  glVertexAttribPointerNV,
  glVertexAttribs1dvNV,
  glVertexAttribs1fvNV,
  glVertexAttribs1hvNV,
  glVertexAttribs1svNV,
  glVertexAttribs2dvNV,
  glVertexAttribs2fvNV,
  glVertexAttribs2hvNV,
  glVertexAttribs2svNV,
  glVertexAttribs3dvNV,
  glVertexAttribs3fvNV,
  glVertexAttribs3hvNV,
  glVertexAttribs3svNV,
  glVertexAttribs4dvNV,
  glVertexAttribs4fvNV,
  glVertexAttribs4hvNV,
  glVertexAttribs4svNV,
  glVertexAttribs4ubvNV,
  glVertexBindingDivisor,
  glVertexBlendARB,
  glVertexBlendEnvfATI,
  glVertexBlendEnviATI,
  glVertexFormatNV,
  glVertexP2ui,
  glVertexP2uiv,
  glVertexP3ui,
  glVertexP3uiv,
  glVertexP4ui,
  glVertexP4uiv,
  glVertexPointer,
  glVertexPointerEXT,
  glVertexPointerListIBM,
  glVertexPointervINTEL,
  glVertexStream1dATI,
  glVertexStream1dvATI,
  glVertexStream1fATI,
  glVertexStream1fvATI,
  glVertexStream1iATI,
  glVertexStream1ivATI,
  glVertexStream1sATI,
  glVertexStream1svATI,
  glVertexStream2dATI,
  glVertexStream2dvATI,
  glVertexStream2fATI,
  glVertexStream2fvATI,
  glVertexStream2iATI,
  glVertexStream2ivATI,
  glVertexStream2sATI,
  glVertexStream2svATI,
  glVertexStream3dATI,
  glVertexStream3dvATI,
  glVertexStream3fATI,
  glVertexStream3fvATI,
  glVertexStream3iATI,
  glVertexStream3ivATI,
  glVertexStream3sATI,
  glVertexStream3svATI,
  glVertexStream4dATI,
  glVertexStream4dvATI,
  glVertexStream4fATI,
  glVertexStream4fvATI,
  glVertexStream4iATI,
  glVertexStream4ivATI,
  glVertexStream4sATI,
  glVertexStream4svATI,
  glVertexWeightPointerEXT,
  glVertexWeightfEXT,
  glVertexWeightfvEXT,
  glVertexWeighthNV,
  glVertexWeighthvNV,
  glVideoCaptureNV,
  glVideoCaptureStreamParameterdvNV,
  glVideoCaptureStreamParameterfvNV,
  glVideoCaptureStreamParameterivNV,
  glViewport,
  glViewportArrayv,
  glViewportArrayvNV,
  glViewportIndexedf,
  glViewportIndexedfNV,
  glViewportIndexedfv,
  glViewportIndexedfvNV,
  glWaitSync,
  glWaitSyncAPPLE,
  glWeightPathsNV,
  glWeightPointerARB,
  glWeightPointerOES,
  glWeightbvARB,
  glWeightdvARB,
  glWeightfvARB,
  glWeightivARB,
  glWeightsvARB,
  glWeightubvARB,
  glWeightuivARB,
  glWeightusvARB,
  glWindowPos2d,
  glWindowPos2dARB,
  glWindowPos2dMESA,
  glWindowPos2dv,
  glWindowPos2dvARB,
  glWindowPos2dvMESA,
  glWindowPos2f,
  glWindowPos2fARB,
  glWindowPos2fMESA,
  glWindowPos2fv,
  glWindowPos2fvARB,
  glWindowPos2fvMESA,
  glWindowPos2i,
  glWindowPos2iARB,
  glWindowPos2iMESA,
  glWindowPos2iv,
  glWindowPos2ivARB,
  glWindowPos2ivMESA,
  glWindowPos2s,
  glWindowPos2sARB,
  glWindowPos2sMESA,
  glWindowPos2sv,
  glWindowPos2svARB,
  glWindowPos2svMESA,
  glWindowPos3d,
  glWindowPos3dARB,
  glWindowPos3dMESA,
  glWindowPos3dv,
  glWindowPos3dvARB,
  glWindowPos3dvMESA,
  glWindowPos3f,
  glWindowPos3fARB,
  glWindowPos3fMESA,
  glWindowPos3fv,
  glWindowPos3fvARB,
  glWindowPos3fvMESA,
  glWindowPos3i,
  glWindowPos3iARB,
  glWindowPos3iMESA,
  glWindowPos3iv,
  glWindowPos3ivARB,
  glWindowPos3ivMESA,
  glWindowPos3s,
  glWindowPos3sARB,
  glWindowPos3sMESA,
  glWindowPos3sv,
  glWindowPos3svARB,
  glWindowPos3svMESA,
  glWindowPos4dMESA,
  glWindowPos4dvMESA,
  glWindowPos4fMESA,
  glWindowPos4fvMESA,
  glWindowPos4iMESA,
  glWindowPos4ivMESA,
  glWindowPos4sMESA,
  glWindowPos4svMESA,
  glWriteMaskEXT
) where

-- Make the foreign imports happy.
import Foreign.C.Types

import Control.Monad.IO.Class ( MonadIO(..) )
import Foreign.Marshal.Error ( throwIf )
import Foreign.Ptr ( Ptr, FunPtr, nullFunPtr )
import System.IO.Unsafe ( unsafePerformIO )

import Graphics.Rendering.OpenGL.Raw.GetProcAddress ( getProcAddress )
import Graphics.Rendering.OpenGL.Raw.Types

getCommand :: String -> IO (FunPtr a)
getCommand cmd =
  throwIfNullFunPtr ("unknown OpenGL command " ++ cmd) $ getProcAddress cmd

throwIfNullFunPtr :: String -> IO (FunPtr a) -> IO (FunPtr a)
throwIfNullFunPtr = throwIf (== nullFunPtr) . const

-- glAccum ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAccum.xml OpenGL 2.x>
glAccum
  :: MonadIO m
  => GLenum -- ^ @op@ of type @AccumOp@.
  -> GLfloat -- ^ @value@ of type @CoordF@.
  -> m ()
glAccum v1 v2 = liftIO $ dyn_glAccum ptr_glAccum v1 v2

foreign import CALLCONV "dynamic" dyn_glAccum
  :: FunPtr (GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glAccum #-}
ptr_glAccum :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glAccum = unsafePerformIO $ getCommand "glAccum"

-- glAccumxOES -----------------------------------------------------------------

glAccumxOES
  :: MonadIO m
  => GLenum -- ^ @op@.
  -> GLfixed -- ^ @value@.
  -> m ()
glAccumxOES v1 v2 = liftIO $ dyn_glAccumxOES ptr_glAccumxOES v1 v2

foreign import CALLCONV "dynamic" dyn_glAccumxOES
  :: FunPtr (GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glAccumxOES #-}
ptr_glAccumxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAccumxOES = unsafePerformIO $ getCommand "glAccumxOES"

-- glActiveProgramEXT ----------------------------------------------------------

glActiveProgramEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m ()
glActiveProgramEXT v1 = liftIO $ dyn_glActiveProgramEXT ptr_glActiveProgramEXT v1

foreign import CALLCONV "dynamic" dyn_glActiveProgramEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glActiveProgramEXT #-}
ptr_glActiveProgramEXT :: FunPtr (GLuint -> IO ())
ptr_glActiveProgramEXT = unsafePerformIO $ getCommand "glActiveProgramEXT"

-- glActiveShaderProgram -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glActiveShaderProgram.xhtml OpenGL 4.x>
glActiveShaderProgram
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLuint -- ^ @program@.
  -> m ()
glActiveShaderProgram v1 v2 = liftIO $ dyn_glActiveShaderProgram ptr_glActiveShaderProgram v1 v2

foreign import CALLCONV "dynamic" dyn_glActiveShaderProgram
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glActiveShaderProgram #-}
ptr_glActiveShaderProgram :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glActiveShaderProgram = unsafePerformIO $ getCommand "glActiveShaderProgram"

-- glActiveShaderProgramEXT ----------------------------------------------------

glActiveShaderProgramEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLuint -- ^ @program@.
  -> m ()
glActiveShaderProgramEXT v1 v2 = liftIO $ dyn_glActiveShaderProgramEXT ptr_glActiveShaderProgramEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glActiveShaderProgramEXT
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glActiveShaderProgramEXT #-}
ptr_glActiveShaderProgramEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glActiveShaderProgramEXT = unsafePerformIO $ getCommand "glActiveShaderProgramEXT"

-- glActiveStencilFaceEXT ------------------------------------------------------

glActiveStencilFaceEXT
  :: MonadIO m
  => GLenum -- ^ @face@ of type @StencilFaceDirection@.
  -> m ()
glActiveStencilFaceEXT v1 = liftIO $ dyn_glActiveStencilFaceEXT ptr_glActiveStencilFaceEXT v1

foreign import CALLCONV "dynamic" dyn_glActiveStencilFaceEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glActiveStencilFaceEXT #-}
ptr_glActiveStencilFaceEXT :: FunPtr (GLenum -> IO ())
ptr_glActiveStencilFaceEXT = unsafePerformIO $ getCommand "glActiveStencilFaceEXT"

-- glActiveTexture -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glActiveTexture.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glActiveTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glActiveTexture.xhtml OpenGL 4.x>
glActiveTexture
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glActiveTexture v1 = liftIO $ dyn_glActiveTexture ptr_glActiveTexture v1

foreign import CALLCONV "dynamic" dyn_glActiveTexture
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glActiveTexture #-}
ptr_glActiveTexture :: FunPtr (GLenum -> IO ())
ptr_glActiveTexture = unsafePerformIO $ getCommand "glActiveTexture"

-- glActiveTextureARB ----------------------------------------------------------

glActiveTextureARB
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glActiveTextureARB v1 = liftIO $ dyn_glActiveTextureARB ptr_glActiveTextureARB v1

foreign import CALLCONV "dynamic" dyn_glActiveTextureARB
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glActiveTextureARB #-}
ptr_glActiveTextureARB :: FunPtr (GLenum -> IO ())
ptr_glActiveTextureARB = unsafePerformIO $ getCommand "glActiveTextureARB"

-- glActiveVaryingNV -----------------------------------------------------------

glActiveVaryingNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glActiveVaryingNV v1 v2 = liftIO $ dyn_glActiveVaryingNV ptr_glActiveVaryingNV v1 v2

foreign import CALLCONV "dynamic" dyn_glActiveVaryingNV
  :: FunPtr (GLuint -> Ptr GLchar -> IO ())
  ->         GLuint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glActiveVaryingNV #-}
ptr_glActiveVaryingNV :: FunPtr (GLuint -> Ptr GLchar -> IO ())
ptr_glActiveVaryingNV = unsafePerformIO $ getCommand "glActiveVaryingNV"

-- glAlphaFragmentOp1ATI -------------------------------------------------------

glAlphaFragmentOp1ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> m ()
glAlphaFragmentOp1ATI v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glAlphaFragmentOp1ATI ptr_glAlphaFragmentOp1ATI v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glAlphaFragmentOp1ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glAlphaFragmentOp1ATI #-}
ptr_glAlphaFragmentOp1ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp1ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp1ATI"

-- glAlphaFragmentOp2ATI -------------------------------------------------------

glAlphaFragmentOp2ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> m ()
glAlphaFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glAlphaFragmentOp2ATI ptr_glAlphaFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glAlphaFragmentOp2ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glAlphaFragmentOp2ATI #-}
ptr_glAlphaFragmentOp2ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp2ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp2ATI"

-- glAlphaFragmentOp3ATI -------------------------------------------------------

glAlphaFragmentOp3ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> GLuint -- ^ @arg3@.
  -> GLuint -- ^ @arg3Rep@.
  -> GLuint -- ^ @arg3Mod@.
  -> m ()
glAlphaFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn_glAlphaFragmentOp3ATI ptr_glAlphaFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

foreign import CALLCONV "dynamic" dyn_glAlphaFragmentOp3ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glAlphaFragmentOp3ATI #-}
ptr_glAlphaFragmentOp3ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp3ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp3ATI"

-- glAlphaFunc -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAlphaFunc.xml OpenGL 2.x>
glAlphaFunc
  :: MonadIO m
  => GLenum -- ^ @func@ of type @AlphaFunction@.
  -> GLfloat -- ^ @ref@.
  -> m ()
glAlphaFunc v1 v2 = liftIO $ dyn_glAlphaFunc ptr_glAlphaFunc v1 v2

foreign import CALLCONV "dynamic" dyn_glAlphaFunc
  :: FunPtr (GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glAlphaFunc #-}
ptr_glAlphaFunc :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glAlphaFunc = unsafePerformIO $ getCommand "glAlphaFunc"

-- glAlphaFuncQCOM -------------------------------------------------------------

glAlphaFuncQCOM
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLclampf -- ^ @ref@.
  -> m ()
glAlphaFuncQCOM v1 v2 = liftIO $ dyn_glAlphaFuncQCOM ptr_glAlphaFuncQCOM v1 v2

foreign import CALLCONV "dynamic" dyn_glAlphaFuncQCOM
  :: FunPtr (GLenum -> GLclampf -> IO ())
  ->         GLenum -> GLclampf -> IO ()

{-# NOINLINE ptr_glAlphaFuncQCOM #-}
ptr_glAlphaFuncQCOM :: FunPtr (GLenum -> GLclampf -> IO ())
ptr_glAlphaFuncQCOM = unsafePerformIO $ getCommand "glAlphaFuncQCOM"

-- glAlphaFuncx ----------------------------------------------------------------

glAlphaFuncx
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLfixed -- ^ @ref@.
  -> m ()
glAlphaFuncx v1 v2 = liftIO $ dyn_glAlphaFuncx ptr_glAlphaFuncx v1 v2

foreign import CALLCONV "dynamic" dyn_glAlphaFuncx
  :: FunPtr (GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glAlphaFuncx #-}
ptr_glAlphaFuncx :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAlphaFuncx = unsafePerformIO $ getCommand "glAlphaFuncx"

-- glAlphaFuncxOES -------------------------------------------------------------

glAlphaFuncxOES
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLfixed -- ^ @ref@ of type @ClampedFixed@.
  -> m ()
glAlphaFuncxOES v1 v2 = liftIO $ dyn_glAlphaFuncxOES ptr_glAlphaFuncxOES v1 v2

foreign import CALLCONV "dynamic" dyn_glAlphaFuncxOES
  :: FunPtr (GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glAlphaFuncxOES #-}
ptr_glAlphaFuncxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAlphaFuncxOES = unsafePerformIO $ getCommand "glAlphaFuncxOES"

-- glApplyTextureEXT -----------------------------------------------------------

glApplyTextureEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @LightTextureModeEXT@.
  -> m ()
glApplyTextureEXT v1 = liftIO $ dyn_glApplyTextureEXT ptr_glApplyTextureEXT v1

foreign import CALLCONV "dynamic" dyn_glApplyTextureEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glApplyTextureEXT #-}
ptr_glApplyTextureEXT :: FunPtr (GLenum -> IO ())
ptr_glApplyTextureEXT = unsafePerformIO $ getCommand "glApplyTextureEXT"

-- glAreProgramsResidentNV -----------------------------------------------------

glAreProgramsResidentNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type @Boolean@.
  -> m GLboolean -- ^ of type @Boolean@.
glAreProgramsResidentNV v1 v2 v3 = liftIO $ dyn_glAreProgramsResidentNV ptr_glAreProgramsResidentNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glAreProgramsResidentNV
  :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
  ->         GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean

{-# NOINLINE ptr_glAreProgramsResidentNV #-}
ptr_glAreProgramsResidentNV :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreProgramsResidentNV = unsafePerformIO $ getCommand "glAreProgramsResidentNV"

-- glAreTexturesResident -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAreTexturesResident.xml OpenGL 2.x>
glAreTexturesResident
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type @Boolean@.
  -> m GLboolean -- ^ of type @Boolean@.
glAreTexturesResident v1 v2 v3 = liftIO $ dyn_glAreTexturesResident ptr_glAreTexturesResident v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glAreTexturesResident
  :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
  ->         GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean

{-# NOINLINE ptr_glAreTexturesResident #-}
ptr_glAreTexturesResident :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreTexturesResident = unsafePerformIO $ getCommand "glAreTexturesResident"

-- glAreTexturesResidentEXT ----------------------------------------------------

glAreTexturesResidentEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type @Boolean@.
  -> m GLboolean -- ^ of type @Boolean@.
glAreTexturesResidentEXT v1 v2 v3 = liftIO $ dyn_glAreTexturesResidentEXT ptr_glAreTexturesResidentEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glAreTexturesResidentEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
  ->         GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean

{-# NOINLINE ptr_glAreTexturesResidentEXT #-}
ptr_glAreTexturesResidentEXT :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreTexturesResidentEXT = unsafePerformIO $ getCommand "glAreTexturesResidentEXT"

-- glArrayElement --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glArrayElement.xml OpenGL 2.x>
glArrayElement
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glArrayElement v1 = liftIO $ dyn_glArrayElement ptr_glArrayElement v1

foreign import CALLCONV "dynamic" dyn_glArrayElement
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glArrayElement #-}
ptr_glArrayElement :: FunPtr (GLint -> IO ())
ptr_glArrayElement = unsafePerformIO $ getCommand "glArrayElement"

-- glArrayElementEXT -----------------------------------------------------------

glArrayElementEXT
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glArrayElementEXT v1 = liftIO $ dyn_glArrayElementEXT ptr_glArrayElementEXT v1

foreign import CALLCONV "dynamic" dyn_glArrayElementEXT
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glArrayElementEXT #-}
ptr_glArrayElementEXT :: FunPtr (GLint -> IO ())
ptr_glArrayElementEXT = unsafePerformIO $ getCommand "glArrayElementEXT"

-- glArrayObjectATI ------------------------------------------------------------

glArrayObjectATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @ScalarType@.
  -> GLsizei -- ^ @stride@.
  -> GLuint -- ^ @buffer@.
  -> GLuint -- ^ @offset@.
  -> m ()
glArrayObjectATI v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glArrayObjectATI ptr_glArrayObjectATI v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glArrayObjectATI
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glArrayObjectATI #-}
ptr_glArrayObjectATI :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLuint -> GLuint -> IO ())
ptr_glArrayObjectATI = unsafePerformIO $ getCommand "glArrayObjectATI"

-- glAsyncMarkerSGIX -----------------------------------------------------------

glAsyncMarkerSGIX
  :: MonadIO m
  => GLuint -- ^ @marker@.
  -> m ()
glAsyncMarkerSGIX v1 = liftIO $ dyn_glAsyncMarkerSGIX ptr_glAsyncMarkerSGIX v1

foreign import CALLCONV "dynamic" dyn_glAsyncMarkerSGIX
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glAsyncMarkerSGIX #-}
ptr_glAsyncMarkerSGIX :: FunPtr (GLuint -> IO ())
ptr_glAsyncMarkerSGIX = unsafePerformIO $ getCommand "glAsyncMarkerSGIX"

-- glAttachObjectARB -----------------------------------------------------------

glAttachObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> m ()
glAttachObjectARB v1 v2 = liftIO $ dyn_glAttachObjectARB ptr_glAttachObjectARB v1 v2

foreign import CALLCONV "dynamic" dyn_glAttachObjectARB
  :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
  ->         GLhandleARB -> GLhandleARB -> IO ()

{-# NOINLINE ptr_glAttachObjectARB #-}
ptr_glAttachObjectARB :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
ptr_glAttachObjectARB = unsafePerformIO $ getCommand "glAttachObjectARB"

-- glAttachShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glAttachShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glAttachShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glAttachShader.xhtml OpenGL 4.x>
glAttachShader
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @shader@.
  -> m ()
glAttachShader v1 v2 = liftIO $ dyn_glAttachShader ptr_glAttachShader v1 v2

foreign import CALLCONV "dynamic" dyn_glAttachShader
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glAttachShader #-}
ptr_glAttachShader :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glAttachShader = unsafePerformIO $ getCommand "glAttachShader"

-- glBegin ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBegin.xml OpenGL 2.x>
glBegin
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> m ()
glBegin v1 = liftIO $ dyn_glBegin ptr_glBegin v1

foreign import CALLCONV "dynamic" dyn_glBegin
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBegin #-}
ptr_glBegin :: FunPtr (GLenum -> IO ())
ptr_glBegin = unsafePerformIO $ getCommand "glBegin"

-- glBeginConditionalRender ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginConditionalRender.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginConditionalRender.xhtml OpenGL 4.x>
glBeginConditionalRender
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @mode@ of type @TypeEnum@.
  -> m ()
glBeginConditionalRender v1 v2 = liftIO $ dyn_glBeginConditionalRender ptr_glBeginConditionalRender v1 v2

foreign import CALLCONV "dynamic" dyn_glBeginConditionalRender
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBeginConditionalRender #-}
ptr_glBeginConditionalRender :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBeginConditionalRender = unsafePerformIO $ getCommand "glBeginConditionalRender"

-- glBeginConditionalRenderNV --------------------------------------------------

glBeginConditionalRenderNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @mode@ of type @TypeEnum@.
  -> m ()
glBeginConditionalRenderNV v1 v2 = liftIO $ dyn_glBeginConditionalRenderNV ptr_glBeginConditionalRenderNV v1 v2

foreign import CALLCONV "dynamic" dyn_glBeginConditionalRenderNV
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBeginConditionalRenderNV #-}
ptr_glBeginConditionalRenderNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBeginConditionalRenderNV = unsafePerformIO $ getCommand "glBeginConditionalRenderNV"

-- glBeginConditionalRenderNVX -------------------------------------------------

glBeginConditionalRenderNVX
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBeginConditionalRenderNVX v1 = liftIO $ dyn_glBeginConditionalRenderNVX ptr_glBeginConditionalRenderNVX v1

foreign import CALLCONV "dynamic" dyn_glBeginConditionalRenderNVX
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBeginConditionalRenderNVX #-}
ptr_glBeginConditionalRenderNVX :: FunPtr (GLuint -> IO ())
ptr_glBeginConditionalRenderNVX = unsafePerformIO $ getCommand "glBeginConditionalRenderNVX"

-- glBeginFragmentShaderATI ----------------------------------------------------

glBeginFragmentShaderATI
  :: MonadIO m
  => m ()
glBeginFragmentShaderATI = liftIO $ dyn_glBeginFragmentShaderATI ptr_glBeginFragmentShaderATI

foreign import CALLCONV "dynamic" dyn_glBeginFragmentShaderATI
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glBeginFragmentShaderATI #-}
ptr_glBeginFragmentShaderATI :: FunPtr (IO ())
ptr_glBeginFragmentShaderATI = unsafePerformIO $ getCommand "glBeginFragmentShaderATI"

-- glBeginOcclusionQueryNV -----------------------------------------------------

glBeginOcclusionQueryNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBeginOcclusionQueryNV v1 = liftIO $ dyn_glBeginOcclusionQueryNV ptr_glBeginOcclusionQueryNV v1

foreign import CALLCONV "dynamic" dyn_glBeginOcclusionQueryNV
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBeginOcclusionQueryNV #-}
ptr_glBeginOcclusionQueryNV :: FunPtr (GLuint -> IO ())
ptr_glBeginOcclusionQueryNV = unsafePerformIO $ getCommand "glBeginOcclusionQueryNV"

-- glBeginPerfMonitorAMD -------------------------------------------------------

glBeginPerfMonitorAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> m ()
glBeginPerfMonitorAMD v1 = liftIO $ dyn_glBeginPerfMonitorAMD ptr_glBeginPerfMonitorAMD v1

foreign import CALLCONV "dynamic" dyn_glBeginPerfMonitorAMD
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBeginPerfMonitorAMD #-}
ptr_glBeginPerfMonitorAMD :: FunPtr (GLuint -> IO ())
ptr_glBeginPerfMonitorAMD = unsafePerformIO $ getCommand "glBeginPerfMonitorAMD"

-- glBeginPerfQueryINTEL -------------------------------------------------------

glBeginPerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glBeginPerfQueryINTEL v1 = liftIO $ dyn_glBeginPerfQueryINTEL ptr_glBeginPerfQueryINTEL v1

foreign import CALLCONV "dynamic" dyn_glBeginPerfQueryINTEL
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBeginPerfQueryINTEL #-}
ptr_glBeginPerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glBeginPerfQueryINTEL = unsafePerformIO $ getCommand "glBeginPerfQueryINTEL"

-- glBeginQuery ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBeginQuery.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginQuery.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginQuery.xhtml OpenGL 4.x>
glBeginQuery
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQuery v1 v2 = liftIO $ dyn_glBeginQuery ptr_glBeginQuery v1 v2

foreign import CALLCONV "dynamic" dyn_glBeginQuery
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBeginQuery #-}
ptr_glBeginQuery :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQuery = unsafePerformIO $ getCommand "glBeginQuery"

-- glBeginQueryARB -------------------------------------------------------------

glBeginQueryARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryARB v1 v2 = liftIO $ dyn_glBeginQueryARB ptr_glBeginQueryARB v1 v2

foreign import CALLCONV "dynamic" dyn_glBeginQueryARB
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBeginQueryARB #-}
ptr_glBeginQueryARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQueryARB = unsafePerformIO $ getCommand "glBeginQueryARB"

-- glBeginQueryEXT -------------------------------------------------------------

glBeginQueryEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryEXT v1 v2 = liftIO $ dyn_glBeginQueryEXT ptr_glBeginQueryEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBeginQueryEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBeginQueryEXT #-}
ptr_glBeginQueryEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQueryEXT = unsafePerformIO $ getCommand "glBeginQueryEXT"

-- glBeginQueryIndexed ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBeginQueryIndexed.xhtml OpenGL 4.x>
glBeginQueryIndexed
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryIndexed v1 v2 v3 = liftIO $ dyn_glBeginQueryIndexed ptr_glBeginQueryIndexed v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBeginQueryIndexed
  :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBeginQueryIndexed #-}
ptr_glBeginQueryIndexed :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBeginQueryIndexed = unsafePerformIO $ getCommand "glBeginQueryIndexed"

-- glBeginTransformFeedback ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginTransformFeedback.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginTransformFeedback.xhtml OpenGL 4.x>
glBeginTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedback v1 = liftIO $ dyn_glBeginTransformFeedback ptr_glBeginTransformFeedback v1

foreign import CALLCONV "dynamic" dyn_glBeginTransformFeedback
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBeginTransformFeedback #-}
ptr_glBeginTransformFeedback :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedback = unsafePerformIO $ getCommand "glBeginTransformFeedback"

-- glBeginTransformFeedbackEXT -------------------------------------------------

glBeginTransformFeedbackEXT
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedbackEXT v1 = liftIO $ dyn_glBeginTransformFeedbackEXT ptr_glBeginTransformFeedbackEXT v1

foreign import CALLCONV "dynamic" dyn_glBeginTransformFeedbackEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBeginTransformFeedbackEXT #-}
ptr_glBeginTransformFeedbackEXT :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedbackEXT = unsafePerformIO $ getCommand "glBeginTransformFeedbackEXT"

-- glBeginTransformFeedbackNV --------------------------------------------------

glBeginTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedbackNV v1 = liftIO $ dyn_glBeginTransformFeedbackNV ptr_glBeginTransformFeedbackNV v1

foreign import CALLCONV "dynamic" dyn_glBeginTransformFeedbackNV
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBeginTransformFeedbackNV #-}
ptr_glBeginTransformFeedbackNV :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedbackNV = unsafePerformIO $ getCommand "glBeginTransformFeedbackNV"

-- glBeginVertexShaderEXT ------------------------------------------------------

glBeginVertexShaderEXT
  :: MonadIO m
  => m ()
glBeginVertexShaderEXT = liftIO $ dyn_glBeginVertexShaderEXT ptr_glBeginVertexShaderEXT

foreign import CALLCONV "dynamic" dyn_glBeginVertexShaderEXT
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glBeginVertexShaderEXT #-}
ptr_glBeginVertexShaderEXT :: FunPtr (IO ())
ptr_glBeginVertexShaderEXT = unsafePerformIO $ getCommand "glBeginVertexShaderEXT"

-- glBeginVideoCaptureNV -------------------------------------------------------

glBeginVideoCaptureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> m ()
glBeginVideoCaptureNV v1 = liftIO $ dyn_glBeginVideoCaptureNV ptr_glBeginVideoCaptureNV v1

foreign import CALLCONV "dynamic" dyn_glBeginVideoCaptureNV
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBeginVideoCaptureNV #-}
ptr_glBeginVideoCaptureNV :: FunPtr (GLuint -> IO ())
ptr_glBeginVideoCaptureNV = unsafePerformIO $ getCommand "glBeginVideoCaptureNV"

-- glBindAttribLocation --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindAttribLocation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindAttribLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindAttribLocation.xhtml OpenGL 4.x>
glBindAttribLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> Ptr GLchar -- ^ @name@.
  -> m ()
glBindAttribLocation v1 v2 v3 = liftIO $ dyn_glBindAttribLocation ptr_glBindAttribLocation v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindAttribLocation
  :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glBindAttribLocation #-}
ptr_glBindAttribLocation :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindAttribLocation = unsafePerformIO $ getCommand "glBindAttribLocation"

-- glBindAttribLocationARB -----------------------------------------------------

glBindAttribLocationARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLcharARB -- ^ @name@.
  -> m ()
glBindAttribLocationARB v1 v2 v3 = liftIO $ dyn_glBindAttribLocationARB ptr_glBindAttribLocationARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindAttribLocationARB
  :: FunPtr (GLhandleARB -> GLuint -> Ptr GLcharARB -> IO ())
  ->         GLhandleARB -> GLuint -> Ptr GLcharARB -> IO ()

{-# NOINLINE ptr_glBindAttribLocationARB #-}
ptr_glBindAttribLocationARB :: FunPtr (GLhandleARB -> GLuint -> Ptr GLcharARB -> IO ())
ptr_glBindAttribLocationARB = unsafePerformIO $ getCommand "glBindAttribLocationARB"

-- glBindBuffer ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindBuffer.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBuffer.xhtml OpenGL 4.x>
glBindBuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBuffer v1 v2 = liftIO $ dyn_glBindBuffer ptr_glBindBuffer v1 v2

foreign import CALLCONV "dynamic" dyn_glBindBuffer
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindBuffer #-}
ptr_glBindBuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindBuffer = unsafePerformIO $ getCommand "glBindBuffer"

-- glBindBufferARB -------------------------------------------------------------

glBindBufferARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferARB v1 v2 = liftIO $ dyn_glBindBufferARB ptr_glBindBufferARB v1 v2

foreign import CALLCONV "dynamic" dyn_glBindBufferARB
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindBufferARB #-}
ptr_glBindBufferARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindBufferARB = unsafePerformIO $ getCommand "glBindBufferARB"

-- glBindBufferBase ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferBase.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBufferBase.xhtml OpenGL 4.x>
glBindBufferBase
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBase v1 v2 v3 = liftIO $ dyn_glBindBufferBase ptr_glBindBufferBase v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindBufferBase
  :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBindBufferBase #-}
ptr_glBindBufferBase :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBase = unsafePerformIO $ getCommand "glBindBufferBase"

-- glBindBufferBaseEXT ---------------------------------------------------------

glBindBufferBaseEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBaseEXT v1 v2 v3 = liftIO $ dyn_glBindBufferBaseEXT ptr_glBindBufferBaseEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindBufferBaseEXT
  :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBindBufferBaseEXT #-}
ptr_glBindBufferBaseEXT :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBaseEXT = unsafePerformIO $ getCommand "glBindBufferBaseEXT"

-- glBindBufferBaseNV ----------------------------------------------------------

glBindBufferBaseNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBaseNV v1 v2 v3 = liftIO $ dyn_glBindBufferBaseNV ptr_glBindBufferBaseNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindBufferBaseNV
  :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBindBufferBaseNV #-}
ptr_glBindBufferBaseNV :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBaseNV = unsafePerformIO $ getCommand "glBindBufferBaseNV"

-- glBindBufferOffsetEXT -------------------------------------------------------

glBindBufferOffsetEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> m ()
glBindBufferOffsetEXT v1 v2 v3 v4 = liftIO $ dyn_glBindBufferOffsetEXT ptr_glBindBufferOffsetEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindBufferOffsetEXT
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLintptr -> IO ()

{-# NOINLINE ptr_glBindBufferOffsetEXT #-}
ptr_glBindBufferOffsetEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
ptr_glBindBufferOffsetEXT = unsafePerformIO $ getCommand "glBindBufferOffsetEXT"

-- glBindBufferOffsetNV --------------------------------------------------------

glBindBufferOffsetNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> m ()
glBindBufferOffsetNV v1 v2 v3 v4 = liftIO $ dyn_glBindBufferOffsetNV ptr_glBindBufferOffsetNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindBufferOffsetNV
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLintptr -> IO ()

{-# NOINLINE ptr_glBindBufferOffsetNV #-}
ptr_glBindBufferOffsetNV :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
ptr_glBindBufferOffsetNV = unsafePerformIO $ getCommand "glBindBufferOffsetNV"

-- glBindBufferRange -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBufferRange.xhtml OpenGL 4.x>
glBindBufferRange
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRange v1 v2 v3 v4 v5 = liftIO $ dyn_glBindBufferRange ptr_glBindBufferRange v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBindBufferRange
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glBindBufferRange #-}
ptr_glBindBufferRange :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRange = unsafePerformIO $ getCommand "glBindBufferRange"

-- glBindBufferRangeEXT --------------------------------------------------------

glBindBufferRangeEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRangeEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glBindBufferRangeEXT ptr_glBindBufferRangeEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBindBufferRangeEXT
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glBindBufferRangeEXT #-}
ptr_glBindBufferRangeEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRangeEXT = unsafePerformIO $ getCommand "glBindBufferRangeEXT"

-- glBindBufferRangeNV ---------------------------------------------------------

glBindBufferRangeNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRangeNV v1 v2 v3 v4 v5 = liftIO $ dyn_glBindBufferRangeNV ptr_glBindBufferRangeNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBindBufferRangeNV
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glBindBufferRangeNV #-}
ptr_glBindBufferRangeNV :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRangeNV = unsafePerformIO $ getCommand "glBindBufferRangeNV"

-- glBindBuffersBase -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindBuffersBase.xhtml OpenGL 4.x>
glBindBuffersBase
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindBuffersBase v1 v2 v3 v4 = liftIO $ dyn_glBindBuffersBase ptr_glBindBuffersBase v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindBuffersBase
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glBindBuffersBase #-}
ptr_glBindBuffersBase :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindBuffersBase = unsafePerformIO $ getCommand "glBindBuffersBase"

-- glBindBuffersRange ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindBuffersRange.xhtml OpenGL 4.x>
glBindBuffersRange
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLintptr -- ^ @offsets@ pointing to @count@ elements of type @GLintptr@.
  -> Ptr GLsizeiptr -- ^ @sizes@ pointing to @count@ elements of type @GLsizeiptr@.
  -> m ()
glBindBuffersRange v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glBindBuffersRange ptr_glBindBuffersRange v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glBindBuffersRange
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizeiptr -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizeiptr -> IO ()

{-# NOINLINE ptr_glBindBuffersRange #-}
ptr_glBindBuffersRange :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizeiptr -> IO ())
ptr_glBindBuffersRange = unsafePerformIO $ getCommand "glBindBuffersRange"

-- glBindFragDataLocation ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFragDataLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFragDataLocation.xhtml OpenGL 4.x>
glBindFragDataLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @color@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glBindFragDataLocation v1 v2 v3 = liftIO $ dyn_glBindFragDataLocation ptr_glBindFragDataLocation v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindFragDataLocation
  :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glBindFragDataLocation #-}
ptr_glBindFragDataLocation :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocation = unsafePerformIO $ getCommand "glBindFragDataLocation"

-- glBindFragDataLocationEXT ---------------------------------------------------

glBindFragDataLocationEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @color@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glBindFragDataLocationEXT v1 v2 v3 = liftIO $ dyn_glBindFragDataLocationEXT ptr_glBindFragDataLocationEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindFragDataLocationEXT
  :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glBindFragDataLocationEXT #-}
ptr_glBindFragDataLocationEXT :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocationEXT = unsafePerformIO $ getCommand "glBindFragDataLocationEXT"

-- glBindFragDataLocationIndexed -----------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFragDataLocationIndexed.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFragDataLocationIndexed.xhtml OpenGL 4.x>
glBindFragDataLocationIndexed
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @colorNumber@.
  -> GLuint -- ^ @index@.
  -> Ptr GLchar -- ^ @name@.
  -> m ()
glBindFragDataLocationIndexed v1 v2 v3 v4 = liftIO $ dyn_glBindFragDataLocationIndexed ptr_glBindFragDataLocationIndexed v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindFragDataLocationIndexed
  :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLuint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glBindFragDataLocationIndexed #-}
ptr_glBindFragDataLocationIndexed :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocationIndexed = unsafePerformIO $ getCommand "glBindFragDataLocationIndexed"

-- glBindFragmentShaderATI -----------------------------------------------------

glBindFragmentShaderATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBindFragmentShaderATI v1 = liftIO $ dyn_glBindFragmentShaderATI ptr_glBindFragmentShaderATI v1

foreign import CALLCONV "dynamic" dyn_glBindFragmentShaderATI
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindFragmentShaderATI #-}
ptr_glBindFragmentShaderATI :: FunPtr (GLuint -> IO ())
ptr_glBindFragmentShaderATI = unsafePerformIO $ getCommand "glBindFragmentShaderATI"

-- glBindFramebuffer -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFramebuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFramebuffer.xhtml OpenGL 4.x>
glBindFramebuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebuffer v1 v2 = liftIO $ dyn_glBindFramebuffer ptr_glBindFramebuffer v1 v2

foreign import CALLCONV "dynamic" dyn_glBindFramebuffer
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindFramebuffer #-}
ptr_glBindFramebuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebuffer = unsafePerformIO $ getCommand "glBindFramebuffer"

-- glBindFramebufferEXT --------------------------------------------------------

glBindFramebufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebufferEXT v1 v2 = liftIO $ dyn_glBindFramebufferEXT ptr_glBindFramebufferEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindFramebufferEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindFramebufferEXT #-}
ptr_glBindFramebufferEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebufferEXT = unsafePerformIO $ getCommand "glBindFramebufferEXT"

-- glBindFramebufferOES --------------------------------------------------------

glBindFramebufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebufferOES v1 v2 = liftIO $ dyn_glBindFramebufferOES ptr_glBindFramebufferOES v1 v2

foreign import CALLCONV "dynamic" dyn_glBindFramebufferOES
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindFramebufferOES #-}
ptr_glBindFramebufferOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebufferOES = unsafePerformIO $ getCommand "glBindFramebufferOES"

-- glBindImageTexture ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindImageTexture.xhtml OpenGL 4.x>
glBindImageTexture
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type @Boolean@.
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @access@.
  -> GLenum -- ^ @format@.
  -> m ()
glBindImageTexture v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glBindImageTexture ptr_glBindImageTexture v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glBindImageTexture
  :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBindImageTexture #-}
ptr_glBindImageTexture :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLenum -> IO ())
ptr_glBindImageTexture = unsafePerformIO $ getCommand "glBindImageTexture"

-- glBindImageTextureEXT -------------------------------------------------------

glBindImageTextureEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type @Boolean@.
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @access@.
  -> GLint -- ^ @format@.
  -> m ()
glBindImageTextureEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glBindImageTextureEXT ptr_glBindImageTextureEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glBindImageTextureEXT
  :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLint -> IO ())
  ->         GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glBindImageTextureEXT #-}
ptr_glBindImageTextureEXT :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLint -> IO ())
ptr_glBindImageTextureEXT = unsafePerformIO $ getCommand "glBindImageTextureEXT"

-- glBindImageTextures ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindImageTextures.xhtml OpenGL 4.x>
glBindImageTextures
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @textures@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindImageTextures v1 v2 v3 = liftIO $ dyn_glBindImageTextures ptr_glBindImageTextures v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindImageTextures
  :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glBindImageTextures #-}
ptr_glBindImageTextures :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindImageTextures = unsafePerformIO $ getCommand "glBindImageTextures"

-- glBindLightParameterEXT -----------------------------------------------------

glBindLightParameterEXT
  :: MonadIO m
  => GLenum -- ^ @light@ of type @LightName@.
  -> GLenum -- ^ @value@ of type @LightParameter@.
  -> m GLuint
glBindLightParameterEXT v1 v2 = liftIO $ dyn_glBindLightParameterEXT ptr_glBindLightParameterEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindLightParameterEXT
  :: FunPtr (GLenum -> GLenum -> IO GLuint)
  ->         GLenum -> GLenum -> IO GLuint

{-# NOINLINE ptr_glBindLightParameterEXT #-}
ptr_glBindLightParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindLightParameterEXT = unsafePerformIO $ getCommand "glBindLightParameterEXT"

-- glBindMaterialParameterEXT --------------------------------------------------

glBindMaterialParameterEXT
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @value@ of type @MaterialParameter@.
  -> m GLuint
glBindMaterialParameterEXT v1 v2 = liftIO $ dyn_glBindMaterialParameterEXT ptr_glBindMaterialParameterEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindMaterialParameterEXT
  :: FunPtr (GLenum -> GLenum -> IO GLuint)
  ->         GLenum -> GLenum -> IO GLuint

{-# NOINLINE ptr_glBindMaterialParameterEXT #-}
ptr_glBindMaterialParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindMaterialParameterEXT = unsafePerformIO $ getCommand "glBindMaterialParameterEXT"

-- glBindMultiTextureEXT -------------------------------------------------------

glBindMultiTextureEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindMultiTextureEXT v1 v2 v3 = liftIO $ dyn_glBindMultiTextureEXT ptr_glBindMultiTextureEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindMultiTextureEXT
  :: FunPtr (GLenum -> GLenum -> GLuint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindMultiTextureEXT #-}
ptr_glBindMultiTextureEXT :: FunPtr (GLenum -> GLenum -> GLuint -> IO ())
ptr_glBindMultiTextureEXT = unsafePerformIO $ getCommand "glBindMultiTextureEXT"

-- glBindParameterEXT ----------------------------------------------------------

glBindParameterEXT
  :: MonadIO m
  => GLenum -- ^ @value@ of type @VertexShaderParameterEXT@.
  -> m GLuint
glBindParameterEXT v1 = liftIO $ dyn_glBindParameterEXT ptr_glBindParameterEXT v1

foreign import CALLCONV "dynamic" dyn_glBindParameterEXT
  :: FunPtr (GLenum -> IO GLuint)
  ->         GLenum -> IO GLuint

{-# NOINLINE ptr_glBindParameterEXT #-}
ptr_glBindParameterEXT :: FunPtr (GLenum -> IO GLuint)
ptr_glBindParameterEXT = unsafePerformIO $ getCommand "glBindParameterEXT"

-- glBindProgramARB ------------------------------------------------------------

glBindProgramARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @program@.
  -> m ()
glBindProgramARB v1 v2 = liftIO $ dyn_glBindProgramARB ptr_glBindProgramARB v1 v2

foreign import CALLCONV "dynamic" dyn_glBindProgramARB
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindProgramARB #-}
ptr_glBindProgramARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindProgramARB = unsafePerformIO $ getCommand "glBindProgramARB"

-- glBindProgramNV -------------------------------------------------------------

glBindProgramNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindProgramNV v1 v2 = liftIO $ dyn_glBindProgramNV ptr_glBindProgramNV v1 v2

foreign import CALLCONV "dynamic" dyn_glBindProgramNV
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindProgramNV #-}
ptr_glBindProgramNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindProgramNV = unsafePerformIO $ getCommand "glBindProgramNV"

-- glBindProgramPipeline -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindProgramPipeline.xhtml OpenGL 4.x>
glBindProgramPipeline
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m ()
glBindProgramPipeline v1 = liftIO $ dyn_glBindProgramPipeline ptr_glBindProgramPipeline v1

foreign import CALLCONV "dynamic" dyn_glBindProgramPipeline
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindProgramPipeline #-}
ptr_glBindProgramPipeline :: FunPtr (GLuint -> IO ())
ptr_glBindProgramPipeline = unsafePerformIO $ getCommand "glBindProgramPipeline"

-- glBindProgramPipelineEXT ----------------------------------------------------

glBindProgramPipelineEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m ()
glBindProgramPipelineEXT v1 = liftIO $ dyn_glBindProgramPipelineEXT ptr_glBindProgramPipelineEXT v1

foreign import CALLCONV "dynamic" dyn_glBindProgramPipelineEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindProgramPipelineEXT #-}
ptr_glBindProgramPipelineEXT :: FunPtr (GLuint -> IO ())
ptr_glBindProgramPipelineEXT = unsafePerformIO $ getCommand "glBindProgramPipelineEXT"

-- glBindRenderbuffer ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindRenderbuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindRenderbuffer.xhtml OpenGL 4.x>
glBindRenderbuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbuffer v1 v2 = liftIO $ dyn_glBindRenderbuffer ptr_glBindRenderbuffer v1 v2

foreign import CALLCONV "dynamic" dyn_glBindRenderbuffer
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindRenderbuffer #-}
ptr_glBindRenderbuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbuffer = unsafePerformIO $ getCommand "glBindRenderbuffer"

-- glBindRenderbufferEXT -------------------------------------------------------

glBindRenderbufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbufferEXT v1 v2 = liftIO $ dyn_glBindRenderbufferEXT ptr_glBindRenderbufferEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindRenderbufferEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindRenderbufferEXT #-}
ptr_glBindRenderbufferEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbufferEXT = unsafePerformIO $ getCommand "glBindRenderbufferEXT"

-- glBindRenderbufferOES -------------------------------------------------------

glBindRenderbufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbufferOES v1 v2 = liftIO $ dyn_glBindRenderbufferOES ptr_glBindRenderbufferOES v1 v2

foreign import CALLCONV "dynamic" dyn_glBindRenderbufferOES
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindRenderbufferOES #-}
ptr_glBindRenderbufferOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbufferOES = unsafePerformIO $ getCommand "glBindRenderbufferOES"

-- glBindSampler ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindSampler.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindSampler.xhtml OpenGL 4.x>
glBindSampler
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @sampler@.
  -> m ()
glBindSampler v1 v2 = liftIO $ dyn_glBindSampler ptr_glBindSampler v1 v2

foreign import CALLCONV "dynamic" dyn_glBindSampler
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBindSampler #-}
ptr_glBindSampler :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glBindSampler = unsafePerformIO $ getCommand "glBindSampler"

-- glBindSamplers --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindSamplers.xhtml OpenGL 4.x>
glBindSamplers
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindSamplers v1 v2 v3 = liftIO $ dyn_glBindSamplers ptr_glBindSamplers v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindSamplers
  :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glBindSamplers #-}
ptr_glBindSamplers :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindSamplers = unsafePerformIO $ getCommand "glBindSamplers"

-- glBindTexGenParameterEXT ----------------------------------------------------

glBindTexGenParameterEXT
  :: MonadIO m
  => GLenum -- ^ @unit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @value@ of type @TextureGenParameter@.
  -> m GLuint
glBindTexGenParameterEXT v1 v2 v3 = liftIO $ dyn_glBindTexGenParameterEXT ptr_glBindTexGenParameterEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindTexGenParameterEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> IO GLuint)
  ->         GLenum -> GLenum -> GLenum -> IO GLuint

{-# NOINLINE ptr_glBindTexGenParameterEXT #-}
ptr_glBindTexGenParameterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> IO GLuint)
ptr_glBindTexGenParameterEXT = unsafePerformIO $ getCommand "glBindTexGenParameterEXT"

-- glBindTexture ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindTexture.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindTexture.xhtml OpenGL 4.x>
glBindTexture
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindTexture v1 v2 = liftIO $ dyn_glBindTexture ptr_glBindTexture v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTexture
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindTexture #-}
ptr_glBindTexture :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTexture = unsafePerformIO $ getCommand "glBindTexture"

-- glBindTextureEXT ------------------------------------------------------------

glBindTextureEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindTextureEXT v1 v2 = liftIO $ dyn_glBindTextureEXT ptr_glBindTextureEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTextureEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindTextureEXT #-}
ptr_glBindTextureEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTextureEXT = unsafePerformIO $ getCommand "glBindTextureEXT"

-- glBindTextureUnit -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTextureUnit.xhtml OpenGL 4.x>
glBindTextureUnit
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @texture@.
  -> m ()
glBindTextureUnit v1 v2 = liftIO $ dyn_glBindTextureUnit ptr_glBindTextureUnit v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTextureUnit
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glBindTextureUnit #-}
ptr_glBindTextureUnit :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glBindTextureUnit = unsafePerformIO $ getCommand "glBindTextureUnit"

-- glBindTextureUnitParameterEXT -----------------------------------------------

glBindTextureUnitParameterEXT
  :: MonadIO m
  => GLenum -- ^ @unit@ of type @TextureUnit@.
  -> GLenum -- ^ @value@ of type @VertexShaderTextureUnitParameter@.
  -> m GLuint
glBindTextureUnitParameterEXT v1 v2 = liftIO $ dyn_glBindTextureUnitParameterEXT ptr_glBindTextureUnitParameterEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTextureUnitParameterEXT
  :: FunPtr (GLenum -> GLenum -> IO GLuint)
  ->         GLenum -> GLenum -> IO GLuint

{-# NOINLINE ptr_glBindTextureUnitParameterEXT #-}
ptr_glBindTextureUnitParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindTextureUnitParameterEXT = unsafePerformIO $ getCommand "glBindTextureUnitParameterEXT"

-- glBindTextures --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTextures.xhtml OpenGL 4.x>
glBindTextures
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @textures@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindTextures v1 v2 v3 = liftIO $ dyn_glBindTextures ptr_glBindTextures v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBindTextures
  :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glBindTextures #-}
ptr_glBindTextures :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindTextures = unsafePerformIO $ getCommand "glBindTextures"

-- glBindTransformFeedback -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTransformFeedback.xhtml OpenGL 4.x>
glBindTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindTransformFeedback v1 v2 = liftIO $ dyn_glBindTransformFeedback ptr_glBindTransformFeedback v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTransformFeedback
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindTransformFeedback #-}
ptr_glBindTransformFeedback :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTransformFeedback = unsafePerformIO $ getCommand "glBindTransformFeedback"

-- glBindTransformFeedbackNV ---------------------------------------------------

glBindTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindTransformFeedbackNV v1 v2 = liftIO $ dyn_glBindTransformFeedbackNV ptr_glBindTransformFeedbackNV v1 v2

foreign import CALLCONV "dynamic" dyn_glBindTransformFeedbackNV
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindTransformFeedbackNV #-}
ptr_glBindTransformFeedbackNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTransformFeedbackNV = unsafePerformIO $ getCommand "glBindTransformFeedbackNV"

-- glBindVertexArray -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindVertexArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindVertexArray.xhtml OpenGL 4.x>
glBindVertexArray
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArray v1 = liftIO $ dyn_glBindVertexArray ptr_glBindVertexArray v1

foreign import CALLCONV "dynamic" dyn_glBindVertexArray
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindVertexArray #-}
ptr_glBindVertexArray :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArray = unsafePerformIO $ getCommand "glBindVertexArray"

-- glBindVertexArrayAPPLE ------------------------------------------------------

glBindVertexArrayAPPLE
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArrayAPPLE v1 = liftIO $ dyn_glBindVertexArrayAPPLE ptr_glBindVertexArrayAPPLE v1

foreign import CALLCONV "dynamic" dyn_glBindVertexArrayAPPLE
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindVertexArrayAPPLE #-}
ptr_glBindVertexArrayAPPLE :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArrayAPPLE = unsafePerformIO $ getCommand "glBindVertexArrayAPPLE"

-- glBindVertexArrayOES --------------------------------------------------------

glBindVertexArrayOES
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArrayOES v1 = liftIO $ dyn_glBindVertexArrayOES ptr_glBindVertexArrayOES v1

foreign import CALLCONV "dynamic" dyn_glBindVertexArrayOES
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindVertexArrayOES #-}
ptr_glBindVertexArrayOES :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArrayOES = unsafePerformIO $ getCommand "glBindVertexArrayOES"

-- glBindVertexBuffer ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindVertexBuffer.xhtml OpenGL 4.x>
glBindVertexBuffer
  :: MonadIO m
  => GLuint -- ^ @bindingindex@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glBindVertexBuffer v1 v2 v3 v4 = liftIO $ dyn_glBindVertexBuffer ptr_glBindVertexBuffer v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindVertexBuffer
  :: FunPtr (GLuint -> GLuint -> GLintptr -> GLsizei -> IO ())
  ->         GLuint -> GLuint -> GLintptr -> GLsizei -> IO ()

{-# NOINLINE ptr_glBindVertexBuffer #-}
ptr_glBindVertexBuffer :: FunPtr (GLuint -> GLuint -> GLintptr -> GLsizei -> IO ())
ptr_glBindVertexBuffer = unsafePerformIO $ getCommand "glBindVertexBuffer"

-- glBindVertexBuffers ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindVertexBuffers.xhtml OpenGL 4.x>
glBindVertexBuffers
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLintptr -- ^ @offsets@ pointing to @count@ elements of type @GLintptr@.
  -> Ptr GLsizei -- ^ @strides@ pointing to @count@ elements of type @GLsizei@.
  -> m ()
glBindVertexBuffers v1 v2 v3 v4 v5 = liftIO $ dyn_glBindVertexBuffers ptr_glBindVertexBuffers v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBindVertexBuffers
  :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizei -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizei -> IO ()

{-# NOINLINE ptr_glBindVertexBuffers #-}
ptr_glBindVertexBuffers :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizei -> IO ())
ptr_glBindVertexBuffers = unsafePerformIO $ getCommand "glBindVertexBuffers"

-- glBindVertexShaderEXT -------------------------------------------------------

glBindVertexShaderEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBindVertexShaderEXT v1 = liftIO $ dyn_glBindVertexShaderEXT ptr_glBindVertexShaderEXT v1

foreign import CALLCONV "dynamic" dyn_glBindVertexShaderEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glBindVertexShaderEXT #-}
ptr_glBindVertexShaderEXT :: FunPtr (GLuint -> IO ())
ptr_glBindVertexShaderEXT = unsafePerformIO $ getCommand "glBindVertexShaderEXT"

-- glBindVideoCaptureStreamBufferNV --------------------------------------------

glBindVideoCaptureStreamBufferNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @frame_region@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> m ()
glBindVideoCaptureStreamBufferNV v1 v2 v3 v4 = liftIO $ dyn_glBindVideoCaptureStreamBufferNV ptr_glBindVideoCaptureStreamBufferNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBindVideoCaptureStreamBufferNV
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptrARB -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLintptrARB -> IO ()

{-# NOINLINE ptr_glBindVideoCaptureStreamBufferNV #-}
ptr_glBindVideoCaptureStreamBufferNV :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptrARB -> IO ())
ptr_glBindVideoCaptureStreamBufferNV = unsafePerformIO $ getCommand "glBindVideoCaptureStreamBufferNV"

-- glBindVideoCaptureStreamTextureNV -------------------------------------------

glBindVideoCaptureStreamTextureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @frame_region@.
  -> GLenum -- ^ @target@.
  -> GLuint -- ^ @texture@.
  -> m ()
glBindVideoCaptureStreamTextureNV v1 v2 v3 v4 v5 = liftIO $ dyn_glBindVideoCaptureStreamTextureNV ptr_glBindVideoCaptureStreamTextureNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBindVideoCaptureStreamTextureNV
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLenum -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glBindVideoCaptureStreamTextureNV #-}
ptr_glBindVideoCaptureStreamTextureNV :: FunPtr (GLuint -> GLuint -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glBindVideoCaptureStreamTextureNV = unsafePerformIO $ getCommand "glBindVideoCaptureStreamTextureNV"

-- glBinormal3bEXT -------------------------------------------------------------

glBinormal3bEXT
  :: MonadIO m
  => GLbyte -- ^ @bx@.
  -> GLbyte -- ^ @by@.
  -> GLbyte -- ^ @bz@.
  -> m ()
glBinormal3bEXT v1 v2 v3 = liftIO $ dyn_glBinormal3bEXT ptr_glBinormal3bEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormal3bEXT
  :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
  ->         GLbyte -> GLbyte -> GLbyte -> IO ()

{-# NOINLINE ptr_glBinormal3bEXT #-}
ptr_glBinormal3bEXT :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glBinormal3bEXT = unsafePerformIO $ getCommand "glBinormal3bEXT"

-- glBinormal3bvEXT ------------------------------------------------------------

glBinormal3bvEXT
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @3@ elements of type @GLbyte@.
  -> m ()
glBinormal3bvEXT v1 = liftIO $ dyn_glBinormal3bvEXT ptr_glBinormal3bvEXT v1

foreign import CALLCONV "dynamic" dyn_glBinormal3bvEXT
  :: FunPtr (Ptr GLbyte -> IO ())
  ->         Ptr GLbyte -> IO ()

{-# NOINLINE ptr_glBinormal3bvEXT #-}
ptr_glBinormal3bvEXT :: FunPtr (Ptr GLbyte -> IO ())
ptr_glBinormal3bvEXT = unsafePerformIO $ getCommand "glBinormal3bvEXT"

-- glBinormal3dEXT -------------------------------------------------------------

glBinormal3dEXT
  :: MonadIO m
  => GLdouble -- ^ @bx@ of type @CoordD@.
  -> GLdouble -- ^ @by@ of type @CoordD@.
  -> GLdouble -- ^ @bz@ of type @CoordD@.
  -> m ()
glBinormal3dEXT v1 v2 v3 = liftIO $ dyn_glBinormal3dEXT ptr_glBinormal3dEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormal3dEXT
  :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glBinormal3dEXT #-}
ptr_glBinormal3dEXT :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glBinormal3dEXT = unsafePerformIO $ getCommand "glBinormal3dEXT"

-- glBinormal3dvEXT ------------------------------------------------------------

glBinormal3dvEXT
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @3@ elements of type @CoordD@.
  -> m ()
glBinormal3dvEXT v1 = liftIO $ dyn_glBinormal3dvEXT ptr_glBinormal3dvEXT v1

foreign import CALLCONV "dynamic" dyn_glBinormal3dvEXT
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glBinormal3dvEXT #-}
ptr_glBinormal3dvEXT :: FunPtr (Ptr GLdouble -> IO ())
ptr_glBinormal3dvEXT = unsafePerformIO $ getCommand "glBinormal3dvEXT"

-- glBinormal3fEXT -------------------------------------------------------------

glBinormal3fEXT
  :: MonadIO m
  => GLfloat -- ^ @bx@ of type @CoordF@.
  -> GLfloat -- ^ @by@ of type @CoordF@.
  -> GLfloat -- ^ @bz@ of type @CoordF@.
  -> m ()
glBinormal3fEXT v1 v2 v3 = liftIO $ dyn_glBinormal3fEXT ptr_glBinormal3fEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormal3fEXT
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glBinormal3fEXT #-}
ptr_glBinormal3fEXT :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBinormal3fEXT = unsafePerformIO $ getCommand "glBinormal3fEXT"

-- glBinormal3fvEXT ------------------------------------------------------------

glBinormal3fvEXT
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @CoordF@.
  -> m ()
glBinormal3fvEXT v1 = liftIO $ dyn_glBinormal3fvEXT ptr_glBinormal3fvEXT v1

foreign import CALLCONV "dynamic" dyn_glBinormal3fvEXT
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glBinormal3fvEXT #-}
ptr_glBinormal3fvEXT :: FunPtr (Ptr GLfloat -> IO ())
ptr_glBinormal3fvEXT = unsafePerformIO $ getCommand "glBinormal3fvEXT"

-- glBinormal3iEXT -------------------------------------------------------------

glBinormal3iEXT
  :: MonadIO m
  => GLint -- ^ @bx@.
  -> GLint -- ^ @by@.
  -> GLint -- ^ @bz@.
  -> m ()
glBinormal3iEXT v1 v2 v3 = liftIO $ dyn_glBinormal3iEXT ptr_glBinormal3iEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormal3iEXT
  :: FunPtr (GLint -> GLint -> GLint -> IO ())
  ->         GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glBinormal3iEXT #-}
ptr_glBinormal3iEXT :: FunPtr (GLint -> GLint -> GLint -> IO ())
ptr_glBinormal3iEXT = unsafePerformIO $ getCommand "glBinormal3iEXT"

-- glBinormal3ivEXT ------------------------------------------------------------

glBinormal3ivEXT
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @3@ elements of type @GLint@.
  -> m ()
glBinormal3ivEXT v1 = liftIO $ dyn_glBinormal3ivEXT ptr_glBinormal3ivEXT v1

foreign import CALLCONV "dynamic" dyn_glBinormal3ivEXT
  :: FunPtr (Ptr GLint -> IO ())
  ->         Ptr GLint -> IO ()

{-# NOINLINE ptr_glBinormal3ivEXT #-}
ptr_glBinormal3ivEXT :: FunPtr (Ptr GLint -> IO ())
ptr_glBinormal3ivEXT = unsafePerformIO $ getCommand "glBinormal3ivEXT"

-- glBinormal3sEXT -------------------------------------------------------------

glBinormal3sEXT
  :: MonadIO m
  => GLshort -- ^ @bx@.
  -> GLshort -- ^ @by@.
  -> GLshort -- ^ @bz@.
  -> m ()
glBinormal3sEXT v1 v2 v3 = liftIO $ dyn_glBinormal3sEXT ptr_glBinormal3sEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormal3sEXT
  :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
  ->         GLshort -> GLshort -> GLshort -> IO ()

{-# NOINLINE ptr_glBinormal3sEXT #-}
ptr_glBinormal3sEXT :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
ptr_glBinormal3sEXT = unsafePerformIO $ getCommand "glBinormal3sEXT"

-- glBinormal3svEXT ------------------------------------------------------------

glBinormal3svEXT
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @3@ elements of type @GLshort@.
  -> m ()
glBinormal3svEXT v1 = liftIO $ dyn_glBinormal3svEXT ptr_glBinormal3svEXT v1

foreign import CALLCONV "dynamic" dyn_glBinormal3svEXT
  :: FunPtr (Ptr GLshort -> IO ())
  ->         Ptr GLshort -> IO ()

{-# NOINLINE ptr_glBinormal3svEXT #-}
ptr_glBinormal3svEXT :: FunPtr (Ptr GLshort -> IO ())
ptr_glBinormal3svEXT = unsafePerformIO $ getCommand "glBinormal3svEXT"

-- glBinormalPointerEXT --------------------------------------------------------

glBinormalPointerEXT
  :: MonadIO m
  => GLenum -- ^ @type@ of type @BinormalPointerTypeEXT@.
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glBinormalPointerEXT v1 v2 v3 = liftIO $ dyn_glBinormalPointerEXT ptr_glBinormalPointerEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBinormalPointerEXT
  :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glBinormalPointerEXT #-}
ptr_glBinormalPointerEXT :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glBinormalPointerEXT = unsafePerformIO $ getCommand "glBinormalPointerEXT"

-- glBitmap --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBitmap.xml OpenGL 2.x>
glBitmap
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLfloat -- ^ @xorig@ of type @CoordF@.
  -> GLfloat -- ^ @yorig@ of type @CoordF@.
  -> GLfloat -- ^ @xmove@ of type @CoordF@.
  -> GLfloat -- ^ @ymove@ of type @CoordF@.
  -> Ptr GLubyte -- ^ @bitmap@ pointing to @COMPSIZE(width,height)@ elements of type @GLubyte@.
  -> m ()
glBitmap v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glBitmap ptr_glBitmap v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glBitmap
  :: FunPtr (GLsizei -> GLsizei -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> Ptr GLubyte -> IO ())
  ->         GLsizei -> GLsizei -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glBitmap #-}
ptr_glBitmap :: FunPtr (GLsizei -> GLsizei -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> Ptr GLubyte -> IO ())
ptr_glBitmap = unsafePerformIO $ getCommand "glBitmap"

-- glBitmapxOES ----------------------------------------------------------------

glBitmapxOES
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLfixed -- ^ @xorig@.
  -> GLfixed -- ^ @yorig@.
  -> GLfixed -- ^ @xmove@.
  -> GLfixed -- ^ @ymove@.
  -> Ptr GLubyte -- ^ @bitmap@ pointing to @COMPSIZE(width,height)@ elements of type @GLubyte@.
  -> m ()
glBitmapxOES v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glBitmapxOES ptr_glBitmapxOES v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glBitmapxOES
  :: FunPtr (GLsizei -> GLsizei -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> Ptr GLubyte -> IO ())
  ->         GLsizei -> GLsizei -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glBitmapxOES #-}
ptr_glBitmapxOES :: FunPtr (GLsizei -> GLsizei -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> Ptr GLubyte -> IO ())
ptr_glBitmapxOES = unsafePerformIO $ getCommand "glBitmapxOES"

-- glBlendBarrierKHR -----------------------------------------------------------

glBlendBarrierKHR
  :: MonadIO m
  => m ()
glBlendBarrierKHR = liftIO $ dyn_glBlendBarrierKHR ptr_glBlendBarrierKHR

foreign import CALLCONV "dynamic" dyn_glBlendBarrierKHR
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glBlendBarrierKHR #-}
ptr_glBlendBarrierKHR :: FunPtr (IO ())
ptr_glBlendBarrierKHR = unsafePerformIO $ getCommand "glBlendBarrierKHR"

-- glBlendBarrierNV ------------------------------------------------------------

glBlendBarrierNV
  :: MonadIO m
  => m ()
glBlendBarrierNV = liftIO $ dyn_glBlendBarrierNV ptr_glBlendBarrierNV

foreign import CALLCONV "dynamic" dyn_glBlendBarrierNV
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glBlendBarrierNV #-}
ptr_glBlendBarrierNV :: FunPtr (IO ())
ptr_glBlendBarrierNV = unsafePerformIO $ getCommand "glBlendBarrierNV"

-- glBlendColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendColor.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendColor.xhtml OpenGL 4.x>
glBlendColor
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glBlendColor v1 v2 v3 v4 = liftIO $ dyn_glBlendColor ptr_glBlendColor v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendColor
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glBlendColor #-}
ptr_glBlendColor :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBlendColor = unsafePerformIO $ getCommand "glBlendColor"

-- glBlendColorEXT -------------------------------------------------------------

glBlendColorEXT
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glBlendColorEXT v1 v2 v3 v4 = liftIO $ dyn_glBlendColorEXT ptr_glBlendColorEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendColorEXT
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glBlendColorEXT #-}
ptr_glBlendColorEXT :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBlendColorEXT = unsafePerformIO $ getCommand "glBlendColorEXT"

-- glBlendColorxOES ------------------------------------------------------------

glBlendColorxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glBlendColorxOES v1 v2 v3 v4 = liftIO $ dyn_glBlendColorxOES ptr_glBlendColorxOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendColorxOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glBlendColorxOES #-}
ptr_glBlendColorxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glBlendColorxOES = unsafePerformIO $ getCommand "glBlendColorxOES"

-- glBlendEquation -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendEquation.xhtml OpenGL 4.x>
glBlendEquation
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @BlendEquationMode@.
  -> m ()
glBlendEquation v1 = liftIO $ dyn_glBlendEquation ptr_glBlendEquation v1

foreign import CALLCONV "dynamic" dyn_glBlendEquation
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquation #-}
ptr_glBlendEquation :: FunPtr (GLenum -> IO ())
ptr_glBlendEquation = unsafePerformIO $ getCommand "glBlendEquation"

-- glBlendEquationEXT ----------------------------------------------------------

glBlendEquationEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @BlendEquationModeEXT@.
  -> m ()
glBlendEquationEXT v1 = liftIO $ dyn_glBlendEquationEXT ptr_glBlendEquationEXT v1

foreign import CALLCONV "dynamic" dyn_glBlendEquationEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationEXT #-}
ptr_glBlendEquationEXT :: FunPtr (GLenum -> IO ())
ptr_glBlendEquationEXT = unsafePerformIO $ getCommand "glBlendEquationEXT"

-- glBlendEquationIndexedAMD ---------------------------------------------------

glBlendEquationIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationIndexedAMD v1 v2 = liftIO $ dyn_glBlendEquationIndexedAMD ptr_glBlendEquationIndexedAMD v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationIndexedAMD
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationIndexedAMD #-}
ptr_glBlendEquationIndexedAMD :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationIndexedAMD = unsafePerformIO $ getCommand "glBlendEquationIndexedAMD"

-- glBlendEquationOES ----------------------------------------------------------

glBlendEquationOES
  :: MonadIO m
  => GLenum -- ^ @mode@.
  -> m ()
glBlendEquationOES v1 = liftIO $ dyn_glBlendEquationOES ptr_glBlendEquationOES v1

foreign import CALLCONV "dynamic" dyn_glBlendEquationOES
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationOES #-}
ptr_glBlendEquationOES :: FunPtr (GLenum -> IO ())
ptr_glBlendEquationOES = unsafePerformIO $ getCommand "glBlendEquationOES"

-- glBlendEquationSeparate -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquationSeparate.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquationSeparate.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendEquationSeparate.xhtml OpenGL 4.x>
glBlendEquationSeparate
  :: MonadIO m
  => GLenum -- ^ @modeRGB@ of type @BlendEquationModeEXT@.
  -> GLenum -- ^ @modeAlpha@ of type @BlendEquationModeEXT@.
  -> m ()
glBlendEquationSeparate v1 v2 = liftIO $ dyn_glBlendEquationSeparate ptr_glBlendEquationSeparate v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparate
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparate #-}
ptr_glBlendEquationSeparate :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparate = unsafePerformIO $ getCommand "glBlendEquationSeparate"

-- glBlendEquationSeparateEXT --------------------------------------------------

glBlendEquationSeparateEXT
  :: MonadIO m
  => GLenum -- ^ @modeRGB@ of type @BlendEquationModeEXT@.
  -> GLenum -- ^ @modeAlpha@ of type @BlendEquationModeEXT@.
  -> m ()
glBlendEquationSeparateEXT v1 v2 = liftIO $ dyn_glBlendEquationSeparateEXT ptr_glBlendEquationSeparateEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateEXT
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateEXT #-}
ptr_glBlendEquationSeparateEXT :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateEXT = unsafePerformIO $ getCommand "glBlendEquationSeparateEXT"

-- glBlendEquationSeparateIndexedAMD -------------------------------------------

glBlendEquationSeparateIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateIndexedAMD v1 v2 v3 = liftIO $ dyn_glBlendEquationSeparateIndexedAMD ptr_glBlendEquationSeparateIndexedAMD v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateIndexedAMD
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateIndexedAMD #-}
ptr_glBlendEquationSeparateIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateIndexedAMD = unsafePerformIO $ getCommand "glBlendEquationSeparateIndexedAMD"

-- glBlendEquationSeparateOES --------------------------------------------------

glBlendEquationSeparateOES
  :: MonadIO m
  => GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateOES v1 v2 = liftIO $ dyn_glBlendEquationSeparateOES ptr_glBlendEquationSeparateOES v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateOES
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateOES #-}
ptr_glBlendEquationSeparateOES :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateOES = unsafePerformIO $ getCommand "glBlendEquationSeparateOES"

-- glBlendEquationSeparatei ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendEquationSeparate.xhtml OpenGL 4.x>
glBlendEquationSeparatei
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparatei v1 v2 v3 = liftIO $ dyn_glBlendEquationSeparatei ptr_glBlendEquationSeparatei v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparatei
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparatei #-}
ptr_glBlendEquationSeparatei :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparatei = unsafePerformIO $ getCommand "glBlendEquationSeparatei"

-- glBlendEquationSeparateiARB -------------------------------------------------

glBlendEquationSeparateiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiARB v1 v2 v3 = liftIO $ dyn_glBlendEquationSeparateiARB ptr_glBlendEquationSeparateiARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateiARB
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateiARB #-}
ptr_glBlendEquationSeparateiARB :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiARB = unsafePerformIO $ getCommand "glBlendEquationSeparateiARB"

-- glBlendEquationSeparateiEXT -------------------------------------------------

glBlendEquationSeparateiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiEXT v1 v2 v3 = liftIO $ dyn_glBlendEquationSeparateiEXT ptr_glBlendEquationSeparateiEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateiEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateiEXT #-}
ptr_glBlendEquationSeparateiEXT :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiEXT = unsafePerformIO $ getCommand "glBlendEquationSeparateiEXT"

-- glBlendEquationSeparateiOES -------------------------------------------------

glBlendEquationSeparateiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiOES v1 v2 v3 = liftIO $ dyn_glBlendEquationSeparateiOES ptr_glBlendEquationSeparateiOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendEquationSeparateiOES
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationSeparateiOES #-}
ptr_glBlendEquationSeparateiOES :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiOES = unsafePerformIO $ getCommand "glBlendEquationSeparateiOES"

-- glBlendEquationi ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendEquation.xhtml OpenGL 4.x>
glBlendEquationi
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationi v1 v2 = liftIO $ dyn_glBlendEquationi ptr_glBlendEquationi v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationi
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationi #-}
ptr_glBlendEquationi :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationi = unsafePerformIO $ getCommand "glBlendEquationi"

-- glBlendEquationiARB ---------------------------------------------------------

glBlendEquationiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiARB v1 v2 = liftIO $ dyn_glBlendEquationiARB ptr_glBlendEquationiARB v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationiARB
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationiARB #-}
ptr_glBlendEquationiARB :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiARB = unsafePerformIO $ getCommand "glBlendEquationiARB"

-- glBlendEquationiEXT ---------------------------------------------------------

glBlendEquationiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiEXT v1 v2 = liftIO $ dyn_glBlendEquationiEXT ptr_glBlendEquationiEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationiEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationiEXT #-}
ptr_glBlendEquationiEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiEXT = unsafePerformIO $ getCommand "glBlendEquationiEXT"

-- glBlendEquationiOES ---------------------------------------------------------

glBlendEquationiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiOES v1 v2 = liftIO $ dyn_glBlendEquationiOES ptr_glBlendEquationiOES v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendEquationiOES
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendEquationiOES #-}
ptr_glBlendEquationiOES :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiOES = unsafePerformIO $ getCommand "glBlendEquationiOES"

-- glBlendFunc -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFunc.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFunc.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendFunc.xhtml OpenGL 4.x>
glBlendFunc
  :: MonadIO m
  => GLenum -- ^ @sfactor@ of type @BlendingFactorSrc@.
  -> GLenum -- ^ @dfactor@ of type @BlendingFactorDest@.
  -> m ()
glBlendFunc v1 v2 = liftIO $ dyn_glBlendFunc ptr_glBlendFunc v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendFunc
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFunc #-}
ptr_glBlendFunc :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendFunc = unsafePerformIO $ getCommand "glBlendFunc"

-- glBlendFuncIndexedAMD -------------------------------------------------------

glBlendFuncIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFuncIndexedAMD v1 v2 v3 = liftIO $ dyn_glBlendFuncIndexedAMD ptr_glBlendFuncIndexedAMD v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendFuncIndexedAMD
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncIndexedAMD #-}
ptr_glBlendFuncIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncIndexedAMD = unsafePerformIO $ getCommand "glBlendFuncIndexedAMD"

-- glBlendFuncSeparate ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFuncSeparate.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFuncSeparate.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendFuncSeparate.xhtml OpenGL 4.x>
glBlendFuncSeparate
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparate v1 v2 v3 v4 = liftIO $ dyn_glBlendFuncSeparate ptr_glBlendFuncSeparate v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparate
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparate #-}
ptr_glBlendFuncSeparate :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparate = unsafePerformIO $ getCommand "glBlendFuncSeparate"

-- glBlendFuncSeparateEXT ------------------------------------------------------

glBlendFuncSeparateEXT
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparateEXT v1 v2 v3 v4 = liftIO $ dyn_glBlendFuncSeparateEXT ptr_glBlendFuncSeparateEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateEXT #-}
ptr_glBlendFuncSeparateEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateEXT = unsafePerformIO $ getCommand "glBlendFuncSeparateEXT"

-- glBlendFuncSeparateINGR -----------------------------------------------------

glBlendFuncSeparateINGR
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparateINGR v1 v2 v3 v4 = liftIO $ dyn_glBlendFuncSeparateINGR ptr_glBlendFuncSeparateINGR v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateINGR
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateINGR #-}
ptr_glBlendFuncSeparateINGR :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateINGR = unsafePerformIO $ getCommand "glBlendFuncSeparateINGR"

-- glBlendFuncSeparateIndexedAMD -----------------------------------------------

glBlendFuncSeparateIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateIndexedAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glBlendFuncSeparateIndexedAMD ptr_glBlendFuncSeparateIndexedAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateIndexedAMD
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateIndexedAMD #-}
ptr_glBlendFuncSeparateIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateIndexedAMD = unsafePerformIO $ getCommand "glBlendFuncSeparateIndexedAMD"

-- glBlendFuncSeparateOES ------------------------------------------------------

glBlendFuncSeparateOES
  :: MonadIO m
  => GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateOES v1 v2 v3 v4 = liftIO $ dyn_glBlendFuncSeparateOES ptr_glBlendFuncSeparateOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateOES
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateOES #-}
ptr_glBlendFuncSeparateOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateOES = unsafePerformIO $ getCommand "glBlendFuncSeparateOES"

-- glBlendFuncSeparatei --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendFuncSeparate.xhtml OpenGL 4.x>
glBlendFuncSeparatei
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparatei v1 v2 v3 v4 v5 = liftIO $ dyn_glBlendFuncSeparatei ptr_glBlendFuncSeparatei v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparatei
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparatei #-}
ptr_glBlendFuncSeparatei :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparatei = unsafePerformIO $ getCommand "glBlendFuncSeparatei"

-- glBlendFuncSeparateiARB -----------------------------------------------------

glBlendFuncSeparateiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiARB v1 v2 v3 v4 v5 = liftIO $ dyn_glBlendFuncSeparateiARB ptr_glBlendFuncSeparateiARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateiARB
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateiARB #-}
ptr_glBlendFuncSeparateiARB :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiARB = unsafePerformIO $ getCommand "glBlendFuncSeparateiARB"

-- glBlendFuncSeparateiEXT -----------------------------------------------------

glBlendFuncSeparateiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glBlendFuncSeparateiEXT ptr_glBlendFuncSeparateiEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateiEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateiEXT #-}
ptr_glBlendFuncSeparateiEXT :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiEXT = unsafePerformIO $ getCommand "glBlendFuncSeparateiEXT"

-- glBlendFuncSeparateiOES -----------------------------------------------------

glBlendFuncSeparateiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiOES v1 v2 v3 v4 v5 = liftIO $ dyn_glBlendFuncSeparateiOES ptr_glBlendFuncSeparateiOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glBlendFuncSeparateiOES
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFuncSeparateiOES #-}
ptr_glBlendFuncSeparateiOES :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiOES = unsafePerformIO $ getCommand "glBlendFuncSeparateiOES"

-- glBlendFunci ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendFunc.xhtml OpenGL 4.x>
glBlendFunci
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunci v1 v2 v3 = liftIO $ dyn_glBlendFunci ptr_glBlendFunci v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendFunci
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFunci #-}
ptr_glBlendFunci :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunci = unsafePerformIO $ getCommand "glBlendFunci"

-- glBlendFunciARB -------------------------------------------------------------

glBlendFunciARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciARB v1 v2 v3 = liftIO $ dyn_glBlendFunciARB ptr_glBlendFunciARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendFunciARB
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFunciARB #-}
ptr_glBlendFunciARB :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciARB = unsafePerformIO $ getCommand "glBlendFunciARB"

-- glBlendFunciEXT -------------------------------------------------------------

glBlendFunciEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciEXT v1 v2 v3 = liftIO $ dyn_glBlendFunciEXT ptr_glBlendFunciEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendFunciEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFunciEXT #-}
ptr_glBlendFunciEXT :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciEXT = unsafePerformIO $ getCommand "glBlendFunciEXT"

-- glBlendFunciOES -------------------------------------------------------------

glBlendFunciOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciOES v1 v2 v3 = liftIO $ dyn_glBlendFunciOES ptr_glBlendFunciOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBlendFunciOES
  :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
  ->         GLuint -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glBlendFunciOES #-}
ptr_glBlendFunciOES :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciOES = unsafePerformIO $ getCommand "glBlendFunciOES"

-- glBlendParameteriNV ---------------------------------------------------------

glBlendParameteriNV
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLint -- ^ @value@.
  -> m ()
glBlendParameteriNV v1 v2 = liftIO $ dyn_glBlendParameteriNV ptr_glBlendParameteriNV v1 v2

foreign import CALLCONV "dynamic" dyn_glBlendParameteriNV
  :: FunPtr (GLenum -> GLint -> IO ())
  ->         GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glBlendParameteriNV #-}
ptr_glBlendParameteriNV :: FunPtr (GLenum -> GLint -> IO ())
ptr_glBlendParameteriNV = unsafePerformIO $ getCommand "glBlendParameteriNV"

-- glBlitFramebuffer -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBlitFramebuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlitFramebuffer.xhtml OpenGL 4.x>
glBlitFramebuffer
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@ of type @ClearBufferMask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glBlitFramebuffer ptr_glBlitFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glBlitFramebuffer
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ()

{-# NOINLINE ptr_glBlitFramebuffer #-}
ptr_glBlitFramebuffer :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebuffer = unsafePerformIO $ getCommand "glBlitFramebuffer"

-- glBlitFramebufferANGLE ------------------------------------------------------

glBlitFramebufferANGLE
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferANGLE v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glBlitFramebufferANGLE ptr_glBlitFramebufferANGLE v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glBlitFramebufferANGLE
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ()

{-# NOINLINE ptr_glBlitFramebufferANGLE #-}
ptr_glBlitFramebufferANGLE :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferANGLE = unsafePerformIO $ getCommand "glBlitFramebufferANGLE"

-- glBlitFramebufferEXT --------------------------------------------------------

glBlitFramebufferEXT
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@ of type @ClearBufferMask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glBlitFramebufferEXT ptr_glBlitFramebufferEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glBlitFramebufferEXT
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ()

{-# NOINLINE ptr_glBlitFramebufferEXT #-}
ptr_glBlitFramebufferEXT :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferEXT = unsafePerformIO $ getCommand "glBlitFramebufferEXT"

-- glBlitFramebufferNV ---------------------------------------------------------

glBlitFramebufferNV
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glBlitFramebufferNV ptr_glBlitFramebufferNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glBlitFramebufferNV
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ()

{-# NOINLINE ptr_glBlitFramebufferNV #-}
ptr_glBlitFramebufferNV :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferNV = unsafePerformIO $ getCommand "glBlitFramebufferNV"

-- glBlitNamedFramebuffer ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlitFramebuffer.xhtml OpenGL 4.x>
glBlitNamedFramebuffer
  :: MonadIO m
  => GLuint -- ^ @readFramebuffer@.
  -> GLuint -- ^ @drawFramebuffer@.
  -> GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitNamedFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn_glBlitNamedFramebuffer ptr_glBlitNamedFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

foreign import CALLCONV "dynamic" dyn_glBlitNamedFramebuffer
  :: FunPtr (GLuint -> GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
  ->         GLuint -> GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ()

{-# NOINLINE ptr_glBlitNamedFramebuffer #-}
ptr_glBlitNamedFramebuffer :: FunPtr (GLuint -> GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitNamedFramebuffer = unsafePerformIO $ getCommand "glBlitNamedFramebuffer"

-- glBufferAddressRangeNV ------------------------------------------------------

glBufferAddressRangeNV
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> GLuint64EXT -- ^ @address@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glBufferAddressRangeNV v1 v2 v3 v4 = liftIO $ dyn_glBufferAddressRangeNV ptr_glBufferAddressRangeNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferAddressRangeNV
  :: FunPtr (GLenum -> GLuint -> GLuint64EXT -> GLsizeiptr -> IO ())
  ->         GLenum -> GLuint -> GLuint64EXT -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glBufferAddressRangeNV #-}
ptr_glBufferAddressRangeNV :: FunPtr (GLenum -> GLuint -> GLuint64EXT -> GLsizeiptr -> IO ())
ptr_glBufferAddressRangeNV = unsafePerformIO $ getCommand "glBufferAddressRangeNV"

-- glBufferData ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBufferData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBufferData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBufferData.xhtml OpenGL 4.x>
glBufferData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLenum -- ^ @usage@ of type @BufferUsageARB@.
  -> m ()
glBufferData v1 v2 v3 v4 = liftIO $ dyn_glBufferData ptr_glBufferData v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferData
  :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLenum -> IO ())
  ->         GLenum -> GLsizeiptr -> Ptr a -> GLenum -> IO ()

{-# NOINLINE ptr_glBufferData #-}
ptr_glBufferData :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLenum -> IO ())
ptr_glBufferData = unsafePerformIO $ getCommand "glBufferData"

-- glBufferDataARB -------------------------------------------------------------

glBufferDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLenum -- ^ @usage@ of type @BufferUsageARB@.
  -> m ()
glBufferDataARB v1 v2 v3 v4 = liftIO $ dyn_glBufferDataARB ptr_glBufferDataARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferDataARB
  :: FunPtr (GLenum -> GLsizeiptrARB -> Ptr a -> GLenum -> IO ())
  ->         GLenum -> GLsizeiptrARB -> Ptr a -> GLenum -> IO ()

{-# NOINLINE ptr_glBufferDataARB #-}
ptr_glBufferDataARB :: FunPtr (GLenum -> GLsizeiptrARB -> Ptr a -> GLenum -> IO ())
ptr_glBufferDataARB = unsafePerformIO $ getCommand "glBufferDataARB"

-- glBufferPageCommitmentARB ---------------------------------------------------

glBufferPageCommitmentARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@.
  -> GLboolean -- ^ @commit@.
  -> m ()
glBufferPageCommitmentARB v1 v2 v3 v4 = liftIO $ dyn_glBufferPageCommitmentARB ptr_glBufferPageCommitmentARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferPageCommitmentARB
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> GLboolean -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> GLboolean -> IO ()

{-# NOINLINE ptr_glBufferPageCommitmentARB #-}
ptr_glBufferPageCommitmentARB :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> GLboolean -> IO ())
ptr_glBufferPageCommitmentARB = unsafePerformIO $ getCommand "glBufferPageCommitmentARB"

-- glBufferParameteriAPPLE -----------------------------------------------------

glBufferParameteriAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glBufferParameteriAPPLE v1 v2 v3 = liftIO $ dyn_glBufferParameteriAPPLE ptr_glBufferParameteriAPPLE v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glBufferParameteriAPPLE
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glBufferParameteriAPPLE #-}
ptr_glBufferParameteriAPPLE :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glBufferParameteriAPPLE = unsafePerformIO $ getCommand "glBufferParameteriAPPLE"

-- glBufferStorage -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBufferStorage.xhtml OpenGL 4.x>
glBufferStorage
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizeiptr -- ^ @size@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLbitfield -- ^ @flags@.
  -> m ()
glBufferStorage v1 v2 v3 v4 = liftIO $ dyn_glBufferStorage ptr_glBufferStorage v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferStorage
  :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLbitfield -> IO ())
  ->         GLenum -> GLsizeiptr -> Ptr a -> GLbitfield -> IO ()

{-# NOINLINE ptr_glBufferStorage #-}
ptr_glBufferStorage :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLbitfield -> IO ())
ptr_glBufferStorage = unsafePerformIO $ getCommand "glBufferStorage"

-- glBufferSubData -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBufferSubData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBufferSubData.xhtml OpenGL 4.x>
glBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glBufferSubData v1 v2 v3 v4 = liftIO $ dyn_glBufferSubData ptr_glBufferSubData v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferSubData
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ()

{-# NOINLINE ptr_glBufferSubData #-}
ptr_glBufferSubData :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glBufferSubData = unsafePerformIO $ getCommand "glBufferSubData"

-- glBufferSubDataARB ----------------------------------------------------------

glBufferSubDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glBufferSubDataARB v1 v2 v3 v4 = liftIO $ dyn_glBufferSubDataARB ptr_glBufferSubDataARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glBufferSubDataARB
  :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
  ->         GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ()

{-# NOINLINE ptr_glBufferSubDataARB #-}
ptr_glBufferSubDataARB :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
ptr_glBufferSubDataARB = unsafePerformIO $ getCommand "glBufferSubDataARB"

-- glCallList ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCallList.xml OpenGL 2.x>
glCallList
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> m ()
glCallList v1 = liftIO $ dyn_glCallList ptr_glCallList v1

foreign import CALLCONV "dynamic" dyn_glCallList
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glCallList #-}
ptr_glCallList :: FunPtr (GLuint -> IO ())
ptr_glCallList = unsafePerformIO $ getCommand "glCallList"

-- glCallLists -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCallLists.xml OpenGL 2.x>
glCallLists
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> GLenum -- ^ @type@ of type @ListNameType@.
  -> Ptr a -- ^ @lists@ pointing to @COMPSIZE(n,type)@ elements of type @a@.
  -> m ()
glCallLists v1 v2 v3 = liftIO $ dyn_glCallLists ptr_glCallLists v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCallLists
  :: FunPtr (GLsizei -> GLenum -> Ptr a -> IO ())
  ->         GLsizei -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glCallLists #-}
ptr_glCallLists :: FunPtr (GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glCallLists = unsafePerformIO $ getCommand "glCallLists"

-- glCheckFramebufferStatus ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glCheckFramebufferStatus.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCheckFramebufferStatus.xhtml OpenGL 4.x>
glCheckFramebufferStatus
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum
glCheckFramebufferStatus v1 = liftIO $ dyn_glCheckFramebufferStatus ptr_glCheckFramebufferStatus v1

foreign import CALLCONV "dynamic" dyn_glCheckFramebufferStatus
  :: FunPtr (GLenum -> IO GLenum)
  ->         GLenum -> IO GLenum

{-# NOINLINE ptr_glCheckFramebufferStatus #-}
ptr_glCheckFramebufferStatus :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatus = unsafePerformIO $ getCommand "glCheckFramebufferStatus"

-- glCheckFramebufferStatusEXT -------------------------------------------------

glCheckFramebufferStatusEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum
glCheckFramebufferStatusEXT v1 = liftIO $ dyn_glCheckFramebufferStatusEXT ptr_glCheckFramebufferStatusEXT v1

foreign import CALLCONV "dynamic" dyn_glCheckFramebufferStatusEXT
  :: FunPtr (GLenum -> IO GLenum)
  ->         GLenum -> IO GLenum

{-# NOINLINE ptr_glCheckFramebufferStatusEXT #-}
ptr_glCheckFramebufferStatusEXT :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatusEXT = unsafePerformIO $ getCommand "glCheckFramebufferStatusEXT"

-- glCheckFramebufferStatusOES -------------------------------------------------

glCheckFramebufferStatusOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m GLenum
glCheckFramebufferStatusOES v1 = liftIO $ dyn_glCheckFramebufferStatusOES ptr_glCheckFramebufferStatusOES v1

foreign import CALLCONV "dynamic" dyn_glCheckFramebufferStatusOES
  :: FunPtr (GLenum -> IO GLenum)
  ->         GLenum -> IO GLenum

{-# NOINLINE ptr_glCheckFramebufferStatusOES #-}
ptr_glCheckFramebufferStatusOES :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatusOES = unsafePerformIO $ getCommand "glCheckFramebufferStatusOES"

-- glCheckNamedFramebufferStatus -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCheckFramebufferStatus.xhtml OpenGL 4.x>
glCheckNamedFramebufferStatus
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @target@.
  -> m GLenum
glCheckNamedFramebufferStatus v1 v2 = liftIO $ dyn_glCheckNamedFramebufferStatus ptr_glCheckNamedFramebufferStatus v1 v2

foreign import CALLCONV "dynamic" dyn_glCheckNamedFramebufferStatus
  :: FunPtr (GLuint -> GLenum -> IO GLenum)
  ->         GLuint -> GLenum -> IO GLenum

{-# NOINLINE ptr_glCheckNamedFramebufferStatus #-}
ptr_glCheckNamedFramebufferStatus :: FunPtr (GLuint -> GLenum -> IO GLenum)
ptr_glCheckNamedFramebufferStatus = unsafePerformIO $ getCommand "glCheckNamedFramebufferStatus"

-- glCheckNamedFramebufferStatusEXT --------------------------------------------

glCheckNamedFramebufferStatusEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum -- ^ of type @FramebufferStatus@.
glCheckNamedFramebufferStatusEXT v1 v2 = liftIO $ dyn_glCheckNamedFramebufferStatusEXT ptr_glCheckNamedFramebufferStatusEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glCheckNamedFramebufferStatusEXT
  :: FunPtr (GLuint -> GLenum -> IO GLenum)
  ->         GLuint -> GLenum -> IO GLenum

{-# NOINLINE ptr_glCheckNamedFramebufferStatusEXT #-}
ptr_glCheckNamedFramebufferStatusEXT :: FunPtr (GLuint -> GLenum -> IO GLenum)
ptr_glCheckNamedFramebufferStatusEXT = unsafePerformIO $ getCommand "glCheckNamedFramebufferStatusEXT"

-- glClampColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClampColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClampColor.xhtml OpenGL 4.x>
glClampColor
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ClampColorTargetARB@.
  -> GLenum -- ^ @clamp@ of type @ClampColorModeARB@.
  -> m ()
glClampColor v1 v2 = liftIO $ dyn_glClampColor ptr_glClampColor v1 v2

foreign import CALLCONV "dynamic" dyn_glClampColor
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glClampColor #-}
ptr_glClampColor :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClampColor = unsafePerformIO $ getCommand "glClampColor"

-- glClampColorARB -------------------------------------------------------------

glClampColorARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ClampColorTargetARB@.
  -> GLenum -- ^ @clamp@ of type @ClampColorModeARB@.
  -> m ()
glClampColorARB v1 v2 = liftIO $ dyn_glClampColorARB ptr_glClampColorARB v1 v2

foreign import CALLCONV "dynamic" dyn_glClampColorARB
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glClampColorARB #-}
ptr_glClampColorARB :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClampColorARB = unsafePerformIO $ getCommand "glClampColorARB"

-- glClear ---------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClear.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClear.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClear.xhtml OpenGL 4.x>
glClear
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type @ClearBufferMask@.
  -> m ()
glClear v1 = liftIO $ dyn_glClear ptr_glClear v1

foreign import CALLCONV "dynamic" dyn_glClear
  :: FunPtr (GLbitfield -> IO ())
  ->         GLbitfield -> IO ()

{-# NOINLINE ptr_glClear #-}
ptr_glClear :: FunPtr (GLbitfield -> IO ())
ptr_glClear = unsafePerformIO $ getCommand "glClear"

-- glClearAccum ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearAccum.xml OpenGL 2.x>
glClearAccum
  :: MonadIO m
  => GLfloat -- ^ @red@.
  -> GLfloat -- ^ @green@.
  -> GLfloat -- ^ @blue@.
  -> GLfloat -- ^ @alpha@.
  -> m ()
glClearAccum v1 v2 v3 v4 = liftIO $ dyn_glClearAccum ptr_glClearAccum v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearAccum
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glClearAccum #-}
ptr_glClearAccum :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glClearAccum = unsafePerformIO $ getCommand "glClearAccum"

-- glClearAccumxOES ------------------------------------------------------------

glClearAccumxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glClearAccumxOES v1 v2 v3 v4 = liftIO $ dyn_glClearAccumxOES ptr_glClearAccumxOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearAccumxOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glClearAccumxOES #-}
ptr_glClearAccumxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearAccumxOES = unsafePerformIO $ getCommand "glClearAccumxOES"

-- glClearBufferData -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferData.xhtml OpenGL 4.x>
glClearBufferData
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearBufferData v1 v2 v3 v4 v5 = liftIO $ dyn_glClearBufferData ptr_glClearBufferData v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glClearBufferData
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearBufferData #-}
ptr_glClearBufferData :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearBufferData = unsafePerformIO $ getCommand "glClearBufferData"

-- glClearBufferSubData --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferSubData.xhtml OpenGL 4.x>
glClearBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearBufferSubData v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glClearBufferSubData ptr_glClearBufferSubData v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glClearBufferSubData
  :: FunPtr (GLenum -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearBufferSubData #-}
ptr_glClearBufferSubData :: FunPtr (GLenum -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearBufferSubData = unsafePerformIO $ getCommand "glClearBufferSubData"

-- glClearBufferfi -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearBufferfi
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> GLfloat -- ^ @depth@.
  -> GLint -- ^ @stencil@.
  -> m ()
glClearBufferfi v1 v2 v3 v4 = liftIO $ dyn_glClearBufferfi ptr_glClearBufferfi v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearBufferfi
  :: FunPtr (GLenum -> GLint -> GLfloat -> GLint -> IO ())
  ->         GLenum -> GLint -> GLfloat -> GLint -> IO ()

{-# NOINLINE ptr_glClearBufferfi #-}
ptr_glClearBufferfi :: FunPtr (GLenum -> GLint -> GLfloat -> GLint -> IO ())
ptr_glClearBufferfi = unsafePerformIO $ getCommand "glClearBufferfi"

-- glClearBufferfv -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearBufferfv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLfloat@.
  -> m ()
glClearBufferfv v1 v2 v3 = liftIO $ dyn_glClearBufferfv ptr_glClearBufferfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glClearBufferfv
  :: FunPtr (GLenum -> GLint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glClearBufferfv #-}
ptr_glClearBufferfv :: FunPtr (GLenum -> GLint -> Ptr GLfloat -> IO ())
ptr_glClearBufferfv = unsafePerformIO $ getCommand "glClearBufferfv"

-- glClearBufferiv -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearBufferiv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLint@.
  -> m ()
glClearBufferiv v1 v2 v3 = liftIO $ dyn_glClearBufferiv ptr_glClearBufferiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glClearBufferiv
  :: FunPtr (GLenum -> GLint -> Ptr GLint -> IO ())
  ->         GLenum -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glClearBufferiv #-}
ptr_glClearBufferiv :: FunPtr (GLenum -> GLint -> Ptr GLint -> IO ())
ptr_glClearBufferiv = unsafePerformIO $ getCommand "glClearBufferiv"

-- glClearBufferuiv ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearBufferuiv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLuint -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLuint@.
  -> m ()
glClearBufferuiv v1 v2 v3 = liftIO $ dyn_glClearBufferuiv ptr_glClearBufferuiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glClearBufferuiv
  :: FunPtr (GLenum -> GLint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glClearBufferuiv #-}
ptr_glClearBufferuiv :: FunPtr (GLenum -> GLint -> Ptr GLuint -> IO ())
ptr_glClearBufferuiv = unsafePerformIO $ getCommand "glClearBufferuiv"

-- glClearColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearColor.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearColor.xhtml OpenGL 4.x>
glClearColor
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glClearColor v1 v2 v3 v4 = liftIO $ dyn_glClearColor ptr_glClearColor v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearColor
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glClearColor #-}
ptr_glClearColor :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glClearColor = unsafePerformIO $ getCommand "glClearColor"

-- glClearColorIiEXT -----------------------------------------------------------

glClearColorIiEXT
  :: MonadIO m
  => GLint -- ^ @red@.
  -> GLint -- ^ @green@.
  -> GLint -- ^ @blue@.
  -> GLint -- ^ @alpha@.
  -> m ()
glClearColorIiEXT v1 v2 v3 v4 = liftIO $ dyn_glClearColorIiEXT ptr_glClearColorIiEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearColorIiEXT
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glClearColorIiEXT #-}
ptr_glClearColorIiEXT :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glClearColorIiEXT = unsafePerformIO $ getCommand "glClearColorIiEXT"

-- glClearColorIuiEXT ----------------------------------------------------------

glClearColorIuiEXT
  :: MonadIO m
  => GLuint -- ^ @red@.
  -> GLuint -- ^ @green@.
  -> GLuint -- ^ @blue@.
  -> GLuint -- ^ @alpha@.
  -> m ()
glClearColorIuiEXT v1 v2 v3 v4 = liftIO $ dyn_glClearColorIuiEXT ptr_glClearColorIuiEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearColorIuiEXT
  :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glClearColorIuiEXT #-}
ptr_glClearColorIuiEXT :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glClearColorIuiEXT = unsafePerformIO $ getCommand "glClearColorIuiEXT"

-- glClearColorx ---------------------------------------------------------------

glClearColorx
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glClearColorx v1 v2 v3 v4 = liftIO $ dyn_glClearColorx ptr_glClearColorx v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearColorx
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glClearColorx #-}
ptr_glClearColorx :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearColorx = unsafePerformIO $ getCommand "glClearColorx"

-- glClearColorxOES ------------------------------------------------------------

glClearColorxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glClearColorxOES v1 v2 v3 v4 = liftIO $ dyn_glClearColorxOES ptr_glClearColorxOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearColorxOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glClearColorxOES #-}
ptr_glClearColorxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearColorxOES = unsafePerformIO $ getCommand "glClearColorxOES"

-- glClearDepth ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearDepth.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearDepth.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearDepth.xhtml OpenGL 4.x>
glClearDepth
  :: MonadIO m
  => GLdouble -- ^ @depth@.
  -> m ()
glClearDepth v1 = liftIO $ dyn_glClearDepth ptr_glClearDepth v1

foreign import CALLCONV "dynamic" dyn_glClearDepth
  :: FunPtr (GLdouble -> IO ())
  ->         GLdouble -> IO ()

{-# NOINLINE ptr_glClearDepth #-}
ptr_glClearDepth :: FunPtr (GLdouble -> IO ())
ptr_glClearDepth = unsafePerformIO $ getCommand "glClearDepth"

-- glClearDepthdNV -------------------------------------------------------------

glClearDepthdNV
  :: MonadIO m
  => GLdouble -- ^ @depth@.
  -> m ()
glClearDepthdNV v1 = liftIO $ dyn_glClearDepthdNV ptr_glClearDepthdNV v1

foreign import CALLCONV "dynamic" dyn_glClearDepthdNV
  :: FunPtr (GLdouble -> IO ())
  ->         GLdouble -> IO ()

{-# NOINLINE ptr_glClearDepthdNV #-}
ptr_glClearDepthdNV :: FunPtr (GLdouble -> IO ())
ptr_glClearDepthdNV = unsafePerformIO $ getCommand "glClearDepthdNV"

-- glClearDepthf ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearDepth.xhtml OpenGL 4.x>
glClearDepthf
  :: MonadIO m
  => GLfloat -- ^ @d@.
  -> m ()
glClearDepthf v1 = liftIO $ dyn_glClearDepthf ptr_glClearDepthf v1

foreign import CALLCONV "dynamic" dyn_glClearDepthf
  :: FunPtr (GLfloat -> IO ())
  ->         GLfloat -> IO ()

{-# NOINLINE ptr_glClearDepthf #-}
ptr_glClearDepthf :: FunPtr (GLfloat -> IO ())
ptr_glClearDepthf = unsafePerformIO $ getCommand "glClearDepthf"

-- glClearDepthfOES ------------------------------------------------------------

glClearDepthfOES
  :: MonadIO m
  => GLclampf -- ^ @depth@ of type @ClampedFloat32@.
  -> m ()
glClearDepthfOES v1 = liftIO $ dyn_glClearDepthfOES ptr_glClearDepthfOES v1

foreign import CALLCONV "dynamic" dyn_glClearDepthfOES
  :: FunPtr (GLclampf -> IO ())
  ->         GLclampf -> IO ()

{-# NOINLINE ptr_glClearDepthfOES #-}
ptr_glClearDepthfOES :: FunPtr (GLclampf -> IO ())
ptr_glClearDepthfOES = unsafePerformIO $ getCommand "glClearDepthfOES"

-- glClearDepthx ---------------------------------------------------------------

glClearDepthx
  :: MonadIO m
  => GLfixed -- ^ @depth@.
  -> m ()
glClearDepthx v1 = liftIO $ dyn_glClearDepthx ptr_glClearDepthx v1

foreign import CALLCONV "dynamic" dyn_glClearDepthx
  :: FunPtr (GLfixed -> IO ())
  ->         GLfixed -> IO ()

{-# NOINLINE ptr_glClearDepthx #-}
ptr_glClearDepthx :: FunPtr (GLfixed -> IO ())
ptr_glClearDepthx = unsafePerformIO $ getCommand "glClearDepthx"

-- glClearDepthxOES ------------------------------------------------------------

glClearDepthxOES
  :: MonadIO m
  => GLfixed -- ^ @depth@ of type @ClampedFixed@.
  -> m ()
glClearDepthxOES v1 = liftIO $ dyn_glClearDepthxOES ptr_glClearDepthxOES v1

foreign import CALLCONV "dynamic" dyn_glClearDepthxOES
  :: FunPtr (GLfixed -> IO ())
  ->         GLfixed -> IO ()

{-# NOINLINE ptr_glClearDepthxOES #-}
ptr_glClearDepthxOES :: FunPtr (GLfixed -> IO ())
ptr_glClearDepthxOES = unsafePerformIO $ getCommand "glClearDepthxOES"

-- glClearIndex ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearIndex.xml OpenGL 2.x>
glClearIndex
  :: MonadIO m
  => GLfloat -- ^ @c@ of type @MaskedColorIndexValueF@.
  -> m ()
glClearIndex v1 = liftIO $ dyn_glClearIndex ptr_glClearIndex v1

foreign import CALLCONV "dynamic" dyn_glClearIndex
  :: FunPtr (GLfloat -> IO ())
  ->         GLfloat -> IO ()

{-# NOINLINE ptr_glClearIndex #-}
ptr_glClearIndex :: FunPtr (GLfloat -> IO ())
ptr_glClearIndex = unsafePerformIO $ getCommand "glClearIndex"

-- glClearNamedBufferData ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferData.xhtml OpenGL 4.x>
glClearNamedBufferData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@.
  -> m ()
glClearNamedBufferData v1 v2 v3 v4 v5 = liftIO $ dyn_glClearNamedBufferData ptr_glClearNamedBufferData v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glClearNamedBufferData
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearNamedBufferData #-}
ptr_glClearNamedBufferData :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferData = unsafePerformIO $ getCommand "glClearNamedBufferData"

-- glClearNamedBufferDataEXT ---------------------------------------------------

glClearNamedBufferDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearNamedBufferDataEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glClearNamedBufferDataEXT ptr_glClearNamedBufferDataEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glClearNamedBufferDataEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearNamedBufferDataEXT #-}
ptr_glClearNamedBufferDataEXT :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferDataEXT = unsafePerformIO $ getCommand "glClearNamedBufferDataEXT"

-- glClearNamedBufferSubData ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferSubData.xhtml OpenGL 4.x>
glClearNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@.
  -> m ()
glClearNamedBufferSubData v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glClearNamedBufferSubData ptr_glClearNamedBufferSubData v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glClearNamedBufferSubData
  :: FunPtr (GLuint -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearNamedBufferSubData #-}
ptr_glClearNamedBufferSubData :: FunPtr (GLuint -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferSubData = unsafePerformIO $ getCommand "glClearNamedBufferSubData"

-- glClearNamedBufferSubDataEXT ------------------------------------------------

glClearNamedBufferSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizeiptr -- ^ @offset@ of type @BufferSize@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearNamedBufferSubDataEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glClearNamedBufferSubDataEXT ptr_glClearNamedBufferSubDataEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glClearNamedBufferSubDataEXT
  :: FunPtr (GLuint -> GLenum -> GLsizeiptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLsizeiptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearNamedBufferSubDataEXT #-}
ptr_glClearNamedBufferSubDataEXT :: FunPtr (GLuint -> GLenum -> GLsizeiptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferSubDataEXT = unsafePerformIO $ getCommand "glClearNamedBufferSubDataEXT"

-- glClearNamedFramebufferfi ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearNamedFramebufferfi
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLfloat -- ^ @depth@.
  -> GLint -- ^ @stencil@.
  -> m ()
glClearNamedFramebufferfi v1 v2 v3 v4 = liftIO $ dyn_glClearNamedFramebufferfi ptr_glClearNamedFramebufferfi v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearNamedFramebufferfi
  :: FunPtr (GLuint -> GLenum -> GLfloat -> GLint -> IO ())
  ->         GLuint -> GLenum -> GLfloat -> GLint -> IO ()

{-# NOINLINE ptr_glClearNamedFramebufferfi #-}
ptr_glClearNamedFramebufferfi :: FunPtr (GLuint -> GLenum -> GLfloat -> GLint -> IO ())
ptr_glClearNamedFramebufferfi = unsafePerformIO $ getCommand "glClearNamedFramebufferfi"

-- glClearNamedFramebufferfv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearNamedFramebufferfv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLfloat -- ^ @value@.
  -> m ()
glClearNamedFramebufferfv v1 v2 v3 v4 = liftIO $ dyn_glClearNamedFramebufferfv ptr_glClearNamedFramebufferfv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearNamedFramebufferfv
  :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> GLint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glClearNamedFramebufferfv #-}
ptr_glClearNamedFramebufferfv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLfloat -> IO ())
ptr_glClearNamedFramebufferfv = unsafePerformIO $ getCommand "glClearNamedFramebufferfv"

-- glClearNamedFramebufferiv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearNamedFramebufferiv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLint -- ^ @value@.
  -> m ()
glClearNamedFramebufferiv v1 v2 v3 v4 = liftIO $ dyn_glClearNamedFramebufferiv ptr_glClearNamedFramebufferiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearNamedFramebufferiv
  :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glClearNamedFramebufferiv #-}
ptr_glClearNamedFramebufferiv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLint -> IO ())
ptr_glClearNamedFramebufferiv = unsafePerformIO $ getCommand "glClearNamedFramebufferiv"

-- glClearNamedFramebufferuiv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>
glClearNamedFramebufferuiv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLuint -- ^ @value@.
  -> m ()
glClearNamedFramebufferuiv v1 v2 v3 v4 = liftIO $ dyn_glClearNamedFramebufferuiv ptr_glClearNamedFramebufferuiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glClearNamedFramebufferuiv
  :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> GLint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glClearNamedFramebufferuiv #-}
ptr_glClearNamedFramebufferuiv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLuint -> IO ())
ptr_glClearNamedFramebufferuiv = unsafePerformIO $ getCommand "glClearNamedFramebufferuiv"

-- glClearStencil --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearStencil.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearStencil.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearStencil.xhtml OpenGL 4.x>
glClearStencil
  :: MonadIO m
  => GLint -- ^ @s@ of type @StencilValue@.
  -> m ()
glClearStencil v1 = liftIO $ dyn_glClearStencil ptr_glClearStencil v1

foreign import CALLCONV "dynamic" dyn_glClearStencil
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glClearStencil #-}
ptr_glClearStencil :: FunPtr (GLint -> IO ())
ptr_glClearStencil = unsafePerformIO $ getCommand "glClearStencil"

-- glClearTexImage -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearTexImage.xhtml OpenGL 4.x>
glClearTexImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearTexImage v1 v2 v3 v4 v5 = liftIO $ dyn_glClearTexImage ptr_glClearTexImage v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glClearTexImage
  :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearTexImage #-}
ptr_glClearTexImage :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearTexImage = unsafePerformIO $ getCommand "glClearTexImage"

-- glClearTexSubImage ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearTexSubImage.xhtml OpenGL 4.x>
glClearTexSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearTexSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glClearTexSubImage ptr_glClearTexSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glClearTexSubImage
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glClearTexSubImage #-}
ptr_glClearTexSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearTexSubImage = unsafePerformIO $ getCommand "glClearTexSubImage"

-- glClientActiveTexture -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClientActiveTexture.xml OpenGL 2.x>
glClientActiveTexture
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glClientActiveTexture v1 = liftIO $ dyn_glClientActiveTexture ptr_glClientActiveTexture v1

foreign import CALLCONV "dynamic" dyn_glClientActiveTexture
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glClientActiveTexture #-}
ptr_glClientActiveTexture :: FunPtr (GLenum -> IO ())
ptr_glClientActiveTexture = unsafePerformIO $ getCommand "glClientActiveTexture"

-- glClientActiveTextureARB ----------------------------------------------------

glClientActiveTextureARB
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glClientActiveTextureARB v1 = liftIO $ dyn_glClientActiveTextureARB ptr_glClientActiveTextureARB v1

foreign import CALLCONV "dynamic" dyn_glClientActiveTextureARB
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glClientActiveTextureARB #-}
ptr_glClientActiveTextureARB :: FunPtr (GLenum -> IO ())
ptr_glClientActiveTextureARB = unsafePerformIO $ getCommand "glClientActiveTextureARB"

-- glClientActiveVertexStreamATI -----------------------------------------------

glClientActiveVertexStreamATI
  :: MonadIO m
  => GLenum -- ^ @stream@ of type @VertexStreamATI@.
  -> m ()
glClientActiveVertexStreamATI v1 = liftIO $ dyn_glClientActiveVertexStreamATI ptr_glClientActiveVertexStreamATI v1

foreign import CALLCONV "dynamic" dyn_glClientActiveVertexStreamATI
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glClientActiveVertexStreamATI #-}
ptr_glClientActiveVertexStreamATI :: FunPtr (GLenum -> IO ())
ptr_glClientActiveVertexStreamATI = unsafePerformIO $ getCommand "glClientActiveVertexStreamATI"

-- glClientAttribDefaultEXT ----------------------------------------------------

glClientAttribDefaultEXT
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type @ClientAttribMask@.
  -> m ()
glClientAttribDefaultEXT v1 = liftIO $ dyn_glClientAttribDefaultEXT ptr_glClientAttribDefaultEXT v1

foreign import CALLCONV "dynamic" dyn_glClientAttribDefaultEXT
  :: FunPtr (GLbitfield -> IO ())
  ->         GLbitfield -> IO ()

{-# NOINLINE ptr_glClientAttribDefaultEXT #-}
ptr_glClientAttribDefaultEXT :: FunPtr (GLbitfield -> IO ())
ptr_glClientAttribDefaultEXT = unsafePerformIO $ getCommand "glClientAttribDefaultEXT"

-- glClientWaitSync ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClientWaitSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClientWaitSync.xhtml OpenGL 4.x>
glClientWaitSync
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> GLbitfield -- ^ @flags@.
  -> GLuint64 -- ^ @timeout@.
  -> m GLenum
glClientWaitSync v1 v2 v3 = liftIO $ dyn_glClientWaitSync ptr_glClientWaitSync v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glClientWaitSync
  :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
  ->         GLsync -> GLbitfield -> GLuint64 -> IO GLenum

{-# NOINLINE ptr_glClientWaitSync #-}
ptr_glClientWaitSync :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
ptr_glClientWaitSync = unsafePerformIO $ getCommand "glClientWaitSync"

-- glClientWaitSyncAPPLE -------------------------------------------------------

glClientWaitSyncAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> GLbitfield -- ^ @flags@.
  -> GLuint64 -- ^ @timeout@.
  -> m GLenum
glClientWaitSyncAPPLE v1 v2 v3 = liftIO $ dyn_glClientWaitSyncAPPLE ptr_glClientWaitSyncAPPLE v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glClientWaitSyncAPPLE
  :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
  ->         GLsync -> GLbitfield -> GLuint64 -> IO GLenum

{-# NOINLINE ptr_glClientWaitSyncAPPLE #-}
ptr_glClientWaitSyncAPPLE :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
ptr_glClientWaitSyncAPPLE = unsafePerformIO $ getCommand "glClientWaitSyncAPPLE"

-- glClipControl ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClipControl.xhtml OpenGL 4.x>
glClipControl
  :: MonadIO m
  => GLenum -- ^ @origin@.
  -> GLenum -- ^ @depth@.
  -> m ()
glClipControl v1 v2 = liftIO $ dyn_glClipControl ptr_glClipControl v1 v2

foreign import CALLCONV "dynamic" dyn_glClipControl
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glClipControl #-}
ptr_glClipControl :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClipControl = unsafePerformIO $ getCommand "glClipControl"

-- glClipPlane -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClipPlane.xml OpenGL 2.x>
glClipPlane
  :: MonadIO m
  => GLenum -- ^ @plane@ of type @ClipPlaneName@.
  -> Ptr GLdouble -- ^ @equation@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glClipPlane v1 v2 = liftIO $ dyn_glClipPlane ptr_glClipPlane v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlane
  :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glClipPlane #-}
ptr_glClipPlane :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glClipPlane = unsafePerformIO $ getCommand "glClipPlane"

-- glClipPlanef ----------------------------------------------------------------

glClipPlanef
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfloat -- ^ @eqn@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanef v1 v2 = liftIO $ dyn_glClipPlanef ptr_glClipPlanef v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanef
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glClipPlanef #-}
ptr_glClipPlanef :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanef = unsafePerformIO $ getCommand "glClipPlanef"

-- glClipPlanefIMG -------------------------------------------------------------

glClipPlanefIMG
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfloat -- ^ @eqn@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanefIMG v1 v2 = liftIO $ dyn_glClipPlanefIMG ptr_glClipPlanefIMG v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanefIMG
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glClipPlanefIMG #-}
ptr_glClipPlanefIMG :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanefIMG = unsafePerformIO $ getCommand "glClipPlanefIMG"

-- glClipPlanefOES -------------------------------------------------------------

glClipPlanefOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanefOES v1 v2 = liftIO $ dyn_glClipPlanefOES ptr_glClipPlanefOES v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanefOES
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glClipPlanefOES #-}
ptr_glClipPlanefOES :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanefOES = unsafePerformIO $ getCommand "glClipPlanefOES"

-- glClipPlanex ----------------------------------------------------------------

glClipPlanex
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanex v1 v2 = liftIO $ dyn_glClipPlanex ptr_glClipPlanex v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanex
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glClipPlanex #-}
ptr_glClipPlanex :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanex = unsafePerformIO $ getCommand "glClipPlanex"

-- glClipPlanexIMG -------------------------------------------------------------

glClipPlanexIMG
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfixed -- ^ @eqn@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanexIMG v1 v2 = liftIO $ dyn_glClipPlanexIMG ptr_glClipPlanexIMG v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanexIMG
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glClipPlanexIMG #-}
ptr_glClipPlanexIMG :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanexIMG = unsafePerformIO $ getCommand "glClipPlanexIMG"

-- glClipPlanexOES -------------------------------------------------------------

glClipPlanexOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanexOES v1 v2 = liftIO $ dyn_glClipPlanexOES ptr_glClipPlanexOES v1 v2

foreign import CALLCONV "dynamic" dyn_glClipPlanexOES
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glClipPlanexOES #-}
ptr_glClipPlanexOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanexOES = unsafePerformIO $ getCommand "glClipPlanexOES"

-- glColor3b -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3b
  :: MonadIO m
  => GLbyte -- ^ @red@ of type @ColorB@.
  -> GLbyte -- ^ @green@ of type @ColorB@.
  -> GLbyte -- ^ @blue@ of type @ColorB@.
  -> m ()
glColor3b v1 v2 v3 = liftIO $ dyn_glColor3b ptr_glColor3b v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3b
  :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
  ->         GLbyte -> GLbyte -> GLbyte -> IO ()

{-# NOINLINE ptr_glColor3b #-}
ptr_glColor3b :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glColor3b = unsafePerformIO $ getCommand "glColor3b"

-- glColor3bv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3bv
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @3@ elements of type @ColorB@.
  -> m ()
glColor3bv v1 = liftIO $ dyn_glColor3bv ptr_glColor3bv v1

foreign import CALLCONV "dynamic" dyn_glColor3bv
  :: FunPtr (Ptr GLbyte -> IO ())
  ->         Ptr GLbyte -> IO ()

{-# NOINLINE ptr_glColor3bv #-}
ptr_glColor3bv :: FunPtr (Ptr GLbyte -> IO ())
ptr_glColor3bv = unsafePerformIO $ getCommand "glColor3bv"

-- glColor3d -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3d
  :: MonadIO m
  => GLdouble -- ^ @red@ of type @ColorD@.
  -> GLdouble -- ^ @green@ of type @ColorD@.
  -> GLdouble -- ^ @blue@ of type @ColorD@.
  -> m ()
glColor3d v1 v2 v3 = liftIO $ dyn_glColor3d ptr_glColor3d v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3d
  :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glColor3d #-}
ptr_glColor3d :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glColor3d = unsafePerformIO $ getCommand "glColor3d"

-- glColor3dv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @3@ elements of type @ColorD@.
  -> m ()
glColor3dv v1 = liftIO $ dyn_glColor3dv ptr_glColor3dv v1

foreign import CALLCONV "dynamic" dyn_glColor3dv
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glColor3dv #-}
ptr_glColor3dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glColor3dv = unsafePerformIO $ getCommand "glColor3dv"

-- glColor3f -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3f
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> m ()
glColor3f v1 v2 v3 = liftIO $ dyn_glColor3f ptr_glColor3f v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3f
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor3f #-}
ptr_glColor3f :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor3f = unsafePerformIO $ getCommand "glColor3f"

-- glColor3fVertex3fSUN --------------------------------------------------------

glColor3fVertex3fSUN
  :: MonadIO m
  => GLfloat -- ^ @r@.
  -> GLfloat -- ^ @g@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor3fVertex3fSUN v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColor3fVertex3fSUN ptr_glColor3fVertex3fSUN v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColor3fVertex3fSUN
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor3fVertex3fSUN #-}
ptr_glColor3fVertex3fSUN :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor3fVertex3fSUN = unsafePerformIO $ getCommand "glColor3fVertex3fSUN"

-- glColor3fVertex3fvSUN -------------------------------------------------------

glColor3fVertex3fvSUN
  :: MonadIO m
  => Ptr GLfloat -- ^ @c@ pointing to @3@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor3fVertex3fvSUN v1 v2 = liftIO $ dyn_glColor3fVertex3fvSUN ptr_glColor3fVertex3fvSUN v1 v2

foreign import CALLCONV "dynamic" dyn_glColor3fVertex3fvSUN
  :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor3fVertex3fvSUN #-}
ptr_glColor3fVertex3fvSUN :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> IO ())
ptr_glColor3fVertex3fvSUN = unsafePerformIO $ getCommand "glColor3fVertex3fvSUN"

-- glColor3fv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @ColorF@.
  -> m ()
glColor3fv v1 = liftIO $ dyn_glColor3fv ptr_glColor3fv v1

foreign import CALLCONV "dynamic" dyn_glColor3fv
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor3fv #-}
ptr_glColor3fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glColor3fv = unsafePerformIO $ getCommand "glColor3fv"

-- glColor3hNV -----------------------------------------------------------------

glColor3hNV
  :: MonadIO m
  => GLhalfNV -- ^ @red@ of type @Half16NV@.
  -> GLhalfNV -- ^ @green@ of type @Half16NV@.
  -> GLhalfNV -- ^ @blue@ of type @Half16NV@.
  -> m ()
glColor3hNV v1 v2 v3 = liftIO $ dyn_glColor3hNV ptr_glColor3hNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3hNV
  :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
  ->         GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ()

{-# NOINLINE ptr_glColor3hNV #-}
ptr_glColor3hNV :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
ptr_glColor3hNV = unsafePerformIO $ getCommand "glColor3hNV"

-- glColor3hvNV ----------------------------------------------------------------

glColor3hvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @v@ pointing to @3@ elements of type @Half16NV@.
  -> m ()
glColor3hvNV v1 = liftIO $ dyn_glColor3hvNV ptr_glColor3hvNV v1

foreign import CALLCONV "dynamic" dyn_glColor3hvNV
  :: FunPtr (Ptr GLhalfNV -> IO ())
  ->         Ptr GLhalfNV -> IO ()

{-# NOINLINE ptr_glColor3hvNV #-}
ptr_glColor3hvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glColor3hvNV = unsafePerformIO $ getCommand "glColor3hvNV"

-- glColor3i -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3i
  :: MonadIO m
  => GLint -- ^ @red@ of type @ColorI@.
  -> GLint -- ^ @green@ of type @ColorI@.
  -> GLint -- ^ @blue@ of type @ColorI@.
  -> m ()
glColor3i v1 v2 v3 = liftIO $ dyn_glColor3i ptr_glColor3i v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3i
  :: FunPtr (GLint -> GLint -> GLint -> IO ())
  ->         GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glColor3i #-}
ptr_glColor3i :: FunPtr (GLint -> GLint -> GLint -> IO ())
ptr_glColor3i = unsafePerformIO $ getCommand "glColor3i"

-- glColor3iv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3iv
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @3@ elements of type @ColorI@.
  -> m ()
glColor3iv v1 = liftIO $ dyn_glColor3iv ptr_glColor3iv v1

foreign import CALLCONV "dynamic" dyn_glColor3iv
  :: FunPtr (Ptr GLint -> IO ())
  ->         Ptr GLint -> IO ()

{-# NOINLINE ptr_glColor3iv #-}
ptr_glColor3iv :: FunPtr (Ptr GLint -> IO ())
ptr_glColor3iv = unsafePerformIO $ getCommand "glColor3iv"

-- glColor3s -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3s
  :: MonadIO m
  => GLshort -- ^ @red@ of type @ColorS@.
  -> GLshort -- ^ @green@ of type @ColorS@.
  -> GLshort -- ^ @blue@ of type @ColorS@.
  -> m ()
glColor3s v1 v2 v3 = liftIO $ dyn_glColor3s ptr_glColor3s v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3s
  :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
  ->         GLshort -> GLshort -> GLshort -> IO ()

{-# NOINLINE ptr_glColor3s #-}
ptr_glColor3s :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
ptr_glColor3s = unsafePerformIO $ getCommand "glColor3s"

-- glColor3sv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3sv
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @3@ elements of type @ColorS@.
  -> m ()
glColor3sv v1 = liftIO $ dyn_glColor3sv ptr_glColor3sv v1

foreign import CALLCONV "dynamic" dyn_glColor3sv
  :: FunPtr (Ptr GLshort -> IO ())
  ->         Ptr GLshort -> IO ()

{-# NOINLINE ptr_glColor3sv #-}
ptr_glColor3sv :: FunPtr (Ptr GLshort -> IO ())
ptr_glColor3sv = unsafePerformIO $ getCommand "glColor3sv"

-- glColor3ub ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3ub
  :: MonadIO m
  => GLubyte -- ^ @red@ of type @ColorUB@.
  -> GLubyte -- ^ @green@ of type @ColorUB@.
  -> GLubyte -- ^ @blue@ of type @ColorUB@.
  -> m ()
glColor3ub v1 v2 v3 = liftIO $ dyn_glColor3ub ptr_glColor3ub v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3ub
  :: FunPtr (GLubyte -> GLubyte -> GLubyte -> IO ())
  ->         GLubyte -> GLubyte -> GLubyte -> IO ()

{-# NOINLINE ptr_glColor3ub #-}
ptr_glColor3ub :: FunPtr (GLubyte -> GLubyte -> GLubyte -> IO ())
ptr_glColor3ub = unsafePerformIO $ getCommand "glColor3ub"

-- glColor3ubv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3ubv
  :: MonadIO m
  => Ptr GLubyte -- ^ @v@ pointing to @3@ elements of type @ColorUB@.
  -> m ()
glColor3ubv v1 = liftIO $ dyn_glColor3ubv ptr_glColor3ubv v1

foreign import CALLCONV "dynamic" dyn_glColor3ubv
  :: FunPtr (Ptr GLubyte -> IO ())
  ->         Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glColor3ubv #-}
ptr_glColor3ubv :: FunPtr (Ptr GLubyte -> IO ())
ptr_glColor3ubv = unsafePerformIO $ getCommand "glColor3ubv"

-- glColor3ui ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3ui
  :: MonadIO m
  => GLuint -- ^ @red@ of type @ColorUI@.
  -> GLuint -- ^ @green@ of type @ColorUI@.
  -> GLuint -- ^ @blue@ of type @ColorUI@.
  -> m ()
glColor3ui v1 v2 v3 = liftIO $ dyn_glColor3ui ptr_glColor3ui v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3ui
  :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glColor3ui #-}
ptr_glColor3ui :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glColor3ui = unsafePerformIO $ getCommand "glColor3ui"

-- glColor3uiv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3uiv
  :: MonadIO m
  => Ptr GLuint -- ^ @v@ pointing to @3@ elements of type @ColorUI@.
  -> m ()
glColor3uiv v1 = liftIO $ dyn_glColor3uiv ptr_glColor3uiv v1

foreign import CALLCONV "dynamic" dyn_glColor3uiv
  :: FunPtr (Ptr GLuint -> IO ())
  ->         Ptr GLuint -> IO ()

{-# NOINLINE ptr_glColor3uiv #-}
ptr_glColor3uiv :: FunPtr (Ptr GLuint -> IO ())
ptr_glColor3uiv = unsafePerformIO $ getCommand "glColor3uiv"

-- glColor3us ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3us
  :: MonadIO m
  => GLushort -- ^ @red@ of type @ColorUS@.
  -> GLushort -- ^ @green@ of type @ColorUS@.
  -> GLushort -- ^ @blue@ of type @ColorUS@.
  -> m ()
glColor3us v1 v2 v3 = liftIO $ dyn_glColor3us ptr_glColor3us v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3us
  :: FunPtr (GLushort -> GLushort -> GLushort -> IO ())
  ->         GLushort -> GLushort -> GLushort -> IO ()

{-# NOINLINE ptr_glColor3us #-}
ptr_glColor3us :: FunPtr (GLushort -> GLushort -> GLushort -> IO ())
ptr_glColor3us = unsafePerformIO $ getCommand "glColor3us"

-- glColor3usv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor3usv
  :: MonadIO m
  => Ptr GLushort -- ^ @v@ pointing to @3@ elements of type @ColorUS@.
  -> m ()
glColor3usv v1 = liftIO $ dyn_glColor3usv ptr_glColor3usv v1

foreign import CALLCONV "dynamic" dyn_glColor3usv
  :: FunPtr (Ptr GLushort -> IO ())
  ->         Ptr GLushort -> IO ()

{-# NOINLINE ptr_glColor3usv #-}
ptr_glColor3usv :: FunPtr (Ptr GLushort -> IO ())
ptr_glColor3usv = unsafePerformIO $ getCommand "glColor3usv"

-- glColor3xOES ----------------------------------------------------------------

glColor3xOES
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> m ()
glColor3xOES v1 v2 v3 = liftIO $ dyn_glColor3xOES ptr_glColor3xOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor3xOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glColor3xOES #-}
ptr_glColor3xOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor3xOES = unsafePerformIO $ getCommand "glColor3xOES"

-- glColor3xvOES ---------------------------------------------------------------

glColor3xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @components@ pointing to @3@ elements of type @GLfixed@.
  -> m ()
glColor3xvOES v1 = liftIO $ dyn_glColor3xvOES ptr_glColor3xvOES v1

foreign import CALLCONV "dynamic" dyn_glColor3xvOES
  :: FunPtr (Ptr GLfixed -> IO ())
  ->         Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glColor3xvOES #-}
ptr_glColor3xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glColor3xvOES = unsafePerformIO $ getCommand "glColor3xvOES"

-- glColor4b -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4b
  :: MonadIO m
  => GLbyte -- ^ @red@ of type @ColorB@.
  -> GLbyte -- ^ @green@ of type @ColorB@.
  -> GLbyte -- ^ @blue@ of type @ColorB@.
  -> GLbyte -- ^ @alpha@ of type @ColorB@.
  -> m ()
glColor4b v1 v2 v3 v4 = liftIO $ dyn_glColor4b ptr_glColor4b v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4b
  :: FunPtr (GLbyte -> GLbyte -> GLbyte -> GLbyte -> IO ())
  ->         GLbyte -> GLbyte -> GLbyte -> GLbyte -> IO ()

{-# NOINLINE ptr_glColor4b #-}
ptr_glColor4b :: FunPtr (GLbyte -> GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glColor4b = unsafePerformIO $ getCommand "glColor4b"

-- glColor4bv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4bv
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @4@ elements of type @ColorB@.
  -> m ()
glColor4bv v1 = liftIO $ dyn_glColor4bv ptr_glColor4bv v1

foreign import CALLCONV "dynamic" dyn_glColor4bv
  :: FunPtr (Ptr GLbyte -> IO ())
  ->         Ptr GLbyte -> IO ()

{-# NOINLINE ptr_glColor4bv #-}
ptr_glColor4bv :: FunPtr (Ptr GLbyte -> IO ())
ptr_glColor4bv = unsafePerformIO $ getCommand "glColor4bv"

-- glColor4d -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4d
  :: MonadIO m
  => GLdouble -- ^ @red@ of type @ColorD@.
  -> GLdouble -- ^ @green@ of type @ColorD@.
  -> GLdouble -- ^ @blue@ of type @ColorD@.
  -> GLdouble -- ^ @alpha@ of type @ColorD@.
  -> m ()
glColor4d v1 v2 v3 v4 = liftIO $ dyn_glColor4d ptr_glColor4d v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4d
  :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glColor4d #-}
ptr_glColor4d :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glColor4d = unsafePerformIO $ getCommand "glColor4d"

-- glColor4dv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @4@ elements of type @ColorD@.
  -> m ()
glColor4dv v1 = liftIO $ dyn_glColor4dv ptr_glColor4dv v1

foreign import CALLCONV "dynamic" dyn_glColor4dv
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glColor4dv #-}
ptr_glColor4dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glColor4dv = unsafePerformIO $ getCommand "glColor4dv"

-- glColor4f -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4f
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glColor4f v1 v2 v3 v4 = liftIO $ dyn_glColor4f ptr_glColor4f v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4f
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor4f #-}
ptr_glColor4f :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4f = unsafePerformIO $ getCommand "glColor4f"

-- glColor4fNormal3fVertex3fSUN ------------------------------------------------

glColor4fNormal3fVertex3fSUN
  :: MonadIO m
  => GLfloat -- ^ @r@.
  -> GLfloat -- ^ @g@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @a@.
  -> GLfloat -- ^ @nx@.
  -> GLfloat -- ^ @ny@.
  -> GLfloat -- ^ @nz@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor4fNormal3fVertex3fSUN v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glColor4fNormal3fVertex3fSUN ptr_glColor4fNormal3fVertex3fSUN v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glColor4fNormal3fVertex3fSUN
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor4fNormal3fVertex3fSUN #-}
ptr_glColor4fNormal3fVertex3fSUN :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4fNormal3fVertex3fSUN = unsafePerformIO $ getCommand "glColor4fNormal3fVertex3fSUN"

-- glColor4fNormal3fVertex3fvSUN -----------------------------------------------

glColor4fNormal3fVertex3fvSUN
  :: MonadIO m
  => Ptr GLfloat -- ^ @c@ pointing to @4@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @n@ pointing to @3@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor4fNormal3fVertex3fvSUN v1 v2 v3 = liftIO $ dyn_glColor4fNormal3fVertex3fvSUN ptr_glColor4fNormal3fVertex3fvSUN v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColor4fNormal3fVertex3fvSUN
  :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> Ptr GLfloat -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor4fNormal3fVertex3fvSUN #-}
ptr_glColor4fNormal3fVertex3fvSUN :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> Ptr GLfloat -> IO ())
ptr_glColor4fNormal3fVertex3fvSUN = unsafePerformIO $ getCommand "glColor4fNormal3fVertex3fvSUN"

-- glColor4fv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @4@ elements of type @ColorF@.
  -> m ()
glColor4fv v1 = liftIO $ dyn_glColor4fv ptr_glColor4fv v1

foreign import CALLCONV "dynamic" dyn_glColor4fv
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor4fv #-}
ptr_glColor4fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glColor4fv = unsafePerformIO $ getCommand "glColor4fv"

-- glColor4hNV -----------------------------------------------------------------

glColor4hNV
  :: MonadIO m
  => GLhalfNV -- ^ @red@ of type @Half16NV@.
  -> GLhalfNV -- ^ @green@ of type @Half16NV@.
  -> GLhalfNV -- ^ @blue@ of type @Half16NV@.
  -> GLhalfNV -- ^ @alpha@ of type @Half16NV@.
  -> m ()
glColor4hNV v1 v2 v3 v4 = liftIO $ dyn_glColor4hNV ptr_glColor4hNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4hNV
  :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
  ->         GLhalfNV -> GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ()

{-# NOINLINE ptr_glColor4hNV #-}
ptr_glColor4hNV :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
ptr_glColor4hNV = unsafePerformIO $ getCommand "glColor4hNV"

-- glColor4hvNV ----------------------------------------------------------------

glColor4hvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @v@ pointing to @4@ elements of type @Half16NV@.
  -> m ()
glColor4hvNV v1 = liftIO $ dyn_glColor4hvNV ptr_glColor4hvNV v1

foreign import CALLCONV "dynamic" dyn_glColor4hvNV
  :: FunPtr (Ptr GLhalfNV -> IO ())
  ->         Ptr GLhalfNV -> IO ()

{-# NOINLINE ptr_glColor4hvNV #-}
ptr_glColor4hvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glColor4hvNV = unsafePerformIO $ getCommand "glColor4hvNV"

-- glColor4i -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4i
  :: MonadIO m
  => GLint -- ^ @red@ of type @ColorI@.
  -> GLint -- ^ @green@ of type @ColorI@.
  -> GLint -- ^ @blue@ of type @ColorI@.
  -> GLint -- ^ @alpha@ of type @ColorI@.
  -> m ()
glColor4i v1 v2 v3 v4 = liftIO $ dyn_glColor4i ptr_glColor4i v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4i
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glColor4i #-}
ptr_glColor4i :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glColor4i = unsafePerformIO $ getCommand "glColor4i"

-- glColor4iv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4iv
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @4@ elements of type @ColorI@.
  -> m ()
glColor4iv v1 = liftIO $ dyn_glColor4iv ptr_glColor4iv v1

foreign import CALLCONV "dynamic" dyn_glColor4iv
  :: FunPtr (Ptr GLint -> IO ())
  ->         Ptr GLint -> IO ()

{-# NOINLINE ptr_glColor4iv #-}
ptr_glColor4iv :: FunPtr (Ptr GLint -> IO ())
ptr_glColor4iv = unsafePerformIO $ getCommand "glColor4iv"

-- glColor4s -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4s
  :: MonadIO m
  => GLshort -- ^ @red@ of type @ColorS@.
  -> GLshort -- ^ @green@ of type @ColorS@.
  -> GLshort -- ^ @blue@ of type @ColorS@.
  -> GLshort -- ^ @alpha@ of type @ColorS@.
  -> m ()
glColor4s v1 v2 v3 v4 = liftIO $ dyn_glColor4s ptr_glColor4s v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4s
  :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> IO ())
  ->         GLshort -> GLshort -> GLshort -> GLshort -> IO ()

{-# NOINLINE ptr_glColor4s #-}
ptr_glColor4s :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> IO ())
ptr_glColor4s = unsafePerformIO $ getCommand "glColor4s"

-- glColor4sv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4sv
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @4@ elements of type @ColorS@.
  -> m ()
glColor4sv v1 = liftIO $ dyn_glColor4sv ptr_glColor4sv v1

foreign import CALLCONV "dynamic" dyn_glColor4sv
  :: FunPtr (Ptr GLshort -> IO ())
  ->         Ptr GLshort -> IO ()

{-# NOINLINE ptr_glColor4sv #-}
ptr_glColor4sv :: FunPtr (Ptr GLshort -> IO ())
ptr_glColor4sv = unsafePerformIO $ getCommand "glColor4sv"

-- glColor4ub ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4ub
  :: MonadIO m
  => GLubyte -- ^ @red@ of type @ColorUB@.
  -> GLubyte -- ^ @green@ of type @ColorUB@.
  -> GLubyte -- ^ @blue@ of type @ColorUB@.
  -> GLubyte -- ^ @alpha@ of type @ColorUB@.
  -> m ()
glColor4ub v1 v2 v3 v4 = liftIO $ dyn_glColor4ub ptr_glColor4ub v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4ub
  :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> IO ())
  ->         GLubyte -> GLubyte -> GLubyte -> GLubyte -> IO ()

{-# NOINLINE ptr_glColor4ub #-}
ptr_glColor4ub :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> IO ())
ptr_glColor4ub = unsafePerformIO $ getCommand "glColor4ub"

-- glColor4ubVertex2fSUN -------------------------------------------------------

glColor4ubVertex2fSUN
  :: MonadIO m
  => GLubyte -- ^ @r@.
  -> GLubyte -- ^ @g@.
  -> GLubyte -- ^ @b@.
  -> GLubyte -- ^ @a@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> m ()
glColor4ubVertex2fSUN v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColor4ubVertex2fSUN ptr_glColor4ubVertex2fSUN v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColor4ubVertex2fSUN
  :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> IO ())
  ->         GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor4ubVertex2fSUN #-}
ptr_glColor4ubVertex2fSUN :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> IO ())
ptr_glColor4ubVertex2fSUN = unsafePerformIO $ getCommand "glColor4ubVertex2fSUN"

-- glColor4ubVertex2fvSUN ------------------------------------------------------

glColor4ubVertex2fvSUN
  :: MonadIO m
  => Ptr GLubyte -- ^ @c@ pointing to @4@ elements of type @GLubyte@.
  -> Ptr GLfloat -- ^ @v@ pointing to @2@ elements of type @GLfloat@.
  -> m ()
glColor4ubVertex2fvSUN v1 v2 = liftIO $ dyn_glColor4ubVertex2fvSUN ptr_glColor4ubVertex2fvSUN v1 v2

foreign import CALLCONV "dynamic" dyn_glColor4ubVertex2fvSUN
  :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
  ->         Ptr GLubyte -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor4ubVertex2fvSUN #-}
ptr_glColor4ubVertex2fvSUN :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glColor4ubVertex2fvSUN = unsafePerformIO $ getCommand "glColor4ubVertex2fvSUN"

-- glColor4ubVertex3fSUN -------------------------------------------------------

glColor4ubVertex3fSUN
  :: MonadIO m
  => GLubyte -- ^ @r@.
  -> GLubyte -- ^ @g@.
  -> GLubyte -- ^ @b@.
  -> GLubyte -- ^ @a@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor4ubVertex3fSUN v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glColor4ubVertex3fSUN ptr_glColor4ubVertex3fSUN v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glColor4ubVertex3fSUN
  :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glColor4ubVertex3fSUN #-}
ptr_glColor4ubVertex3fSUN :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4ubVertex3fSUN = unsafePerformIO $ getCommand "glColor4ubVertex3fSUN"

-- glColor4ubVertex3fvSUN ------------------------------------------------------

glColor4ubVertex3fvSUN
  :: MonadIO m
  => Ptr GLubyte -- ^ @c@ pointing to @4@ elements of type @GLubyte@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor4ubVertex3fvSUN v1 v2 = liftIO $ dyn_glColor4ubVertex3fvSUN ptr_glColor4ubVertex3fvSUN v1 v2

foreign import CALLCONV "dynamic" dyn_glColor4ubVertex3fvSUN
  :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
  ->         Ptr GLubyte -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColor4ubVertex3fvSUN #-}
ptr_glColor4ubVertex3fvSUN :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glColor4ubVertex3fvSUN = unsafePerformIO $ getCommand "glColor4ubVertex3fvSUN"

-- glColor4ubv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4ubv
  :: MonadIO m
  => Ptr GLubyte -- ^ @v@ pointing to @4@ elements of type @ColorUB@.
  -> m ()
glColor4ubv v1 = liftIO $ dyn_glColor4ubv ptr_glColor4ubv v1

foreign import CALLCONV "dynamic" dyn_glColor4ubv
  :: FunPtr (Ptr GLubyte -> IO ())
  ->         Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glColor4ubv #-}
ptr_glColor4ubv :: FunPtr (Ptr GLubyte -> IO ())
ptr_glColor4ubv = unsafePerformIO $ getCommand "glColor4ubv"

-- glColor4ui ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4ui
  :: MonadIO m
  => GLuint -- ^ @red@ of type @ColorUI@.
  -> GLuint -- ^ @green@ of type @ColorUI@.
  -> GLuint -- ^ @blue@ of type @ColorUI@.
  -> GLuint -- ^ @alpha@ of type @ColorUI@.
  -> m ()
glColor4ui v1 v2 v3 v4 = liftIO $ dyn_glColor4ui ptr_glColor4ui v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4ui
  :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glColor4ui #-}
ptr_glColor4ui :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColor4ui = unsafePerformIO $ getCommand "glColor4ui"

-- glColor4uiv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4uiv
  :: MonadIO m
  => Ptr GLuint -- ^ @v@ pointing to @4@ elements of type @ColorUI@.
  -> m ()
glColor4uiv v1 = liftIO $ dyn_glColor4uiv ptr_glColor4uiv v1

foreign import CALLCONV "dynamic" dyn_glColor4uiv
  :: FunPtr (Ptr GLuint -> IO ())
  ->         Ptr GLuint -> IO ()

{-# NOINLINE ptr_glColor4uiv #-}
ptr_glColor4uiv :: FunPtr (Ptr GLuint -> IO ())
ptr_glColor4uiv = unsafePerformIO $ getCommand "glColor4uiv"

-- glColor4us ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4us
  :: MonadIO m
  => GLushort -- ^ @red@ of type @ColorUS@.
  -> GLushort -- ^ @green@ of type @ColorUS@.
  -> GLushort -- ^ @blue@ of type @ColorUS@.
  -> GLushort -- ^ @alpha@ of type @ColorUS@.
  -> m ()
glColor4us v1 v2 v3 v4 = liftIO $ dyn_glColor4us ptr_glColor4us v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4us
  :: FunPtr (GLushort -> GLushort -> GLushort -> GLushort -> IO ())
  ->         GLushort -> GLushort -> GLushort -> GLushort -> IO ()

{-# NOINLINE ptr_glColor4us #-}
ptr_glColor4us :: FunPtr (GLushort -> GLushort -> GLushort -> GLushort -> IO ())
ptr_glColor4us = unsafePerformIO $ getCommand "glColor4us"

-- glColor4usv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>
glColor4usv
  :: MonadIO m
  => Ptr GLushort -- ^ @v@ pointing to @4@ elements of type @ColorUS@.
  -> m ()
glColor4usv v1 = liftIO $ dyn_glColor4usv ptr_glColor4usv v1

foreign import CALLCONV "dynamic" dyn_glColor4usv
  :: FunPtr (Ptr GLushort -> IO ())
  ->         Ptr GLushort -> IO ()

{-# NOINLINE ptr_glColor4usv #-}
ptr_glColor4usv :: FunPtr (Ptr GLushort -> IO ())
ptr_glColor4usv = unsafePerformIO $ getCommand "glColor4usv"

-- glColor4x -------------------------------------------------------------------

glColor4x
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glColor4x v1 v2 v3 v4 = liftIO $ dyn_glColor4x ptr_glColor4x v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4x
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glColor4x #-}
ptr_glColor4x :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor4x = unsafePerformIO $ getCommand "glColor4x"

-- glColor4xOES ----------------------------------------------------------------

glColor4xOES
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glColor4xOES v1 v2 v3 v4 = liftIO $ dyn_glColor4xOES ptr_glColor4xOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColor4xOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glColor4xOES #-}
ptr_glColor4xOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor4xOES = unsafePerformIO $ getCommand "glColor4xOES"

-- glColor4xvOES ---------------------------------------------------------------

glColor4xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @components@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glColor4xvOES v1 = liftIO $ dyn_glColor4xvOES ptr_glColor4xvOES v1

foreign import CALLCONV "dynamic" dyn_glColor4xvOES
  :: FunPtr (Ptr GLfixed -> IO ())
  ->         Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glColor4xvOES #-}
ptr_glColor4xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glColor4xvOES = unsafePerformIO $ getCommand "glColor4xvOES"

-- glColorFormatNV -------------------------------------------------------------

glColorFormatNV
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glColorFormatNV v1 v2 v3 = liftIO $ dyn_glColorFormatNV ptr_glColorFormatNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorFormatNV
  :: FunPtr (GLint -> GLenum -> GLsizei -> IO ())
  ->         GLint -> GLenum -> GLsizei -> IO ()

{-# NOINLINE ptr_glColorFormatNV #-}
ptr_glColorFormatNV :: FunPtr (GLint -> GLenum -> GLsizei -> IO ())
ptr_glColorFormatNV = unsafePerformIO $ getCommand "glColorFormatNV"

-- glColorFragmentOp1ATI -------------------------------------------------------

glColorFragmentOp1ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> m ()
glColorFragmentOp1ATI v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glColorFragmentOp1ATI ptr_glColorFragmentOp1ATI v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glColorFragmentOp1ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glColorFragmentOp1ATI #-}
ptr_glColorFragmentOp1ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp1ATI = unsafePerformIO $ getCommand "glColorFragmentOp1ATI"

-- glColorFragmentOp2ATI -------------------------------------------------------

glColorFragmentOp2ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> m ()
glColorFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glColorFragmentOp2ATI ptr_glColorFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glColorFragmentOp2ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glColorFragmentOp2ATI #-}
ptr_glColorFragmentOp2ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp2ATI = unsafePerformIO $ getCommand "glColorFragmentOp2ATI"

-- glColorFragmentOp3ATI -------------------------------------------------------

glColorFragmentOp3ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> GLuint -- ^ @arg3@.
  -> GLuint -- ^ @arg3Rep@.
  -> GLuint -- ^ @arg3Mod@.
  -> m ()
glColorFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 = liftIO $ dyn_glColorFragmentOp3ATI ptr_glColorFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13

foreign import CALLCONV "dynamic" dyn_glColorFragmentOp3ATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glColorFragmentOp3ATI #-}
ptr_glColorFragmentOp3ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp3ATI = unsafePerformIO $ getCommand "glColorFragmentOp3ATI"

-- glColorMask -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorMask.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glColorMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glColorMask.xhtml OpenGL 4.x>
glColorMask
  :: MonadIO m
  => GLboolean -- ^ @red@ of type @Boolean@.
  -> GLboolean -- ^ @green@ of type @Boolean@.
  -> GLboolean -- ^ @blue@ of type @Boolean@.
  -> GLboolean -- ^ @alpha@ of type @Boolean@.
  -> m ()
glColorMask v1 v2 v3 v4 = liftIO $ dyn_glColorMask ptr_glColorMask v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColorMask
  :: FunPtr (GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glColorMask #-}
ptr_glColorMask :: FunPtr (GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMask = unsafePerformIO $ getCommand "glColorMask"

-- glColorMaskIndexedEXT -------------------------------------------------------

glColorMaskIndexedEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type @Boolean@.
  -> GLboolean -- ^ @g@ of type @Boolean@.
  -> GLboolean -- ^ @b@ of type @Boolean@.
  -> GLboolean -- ^ @a@ of type @Boolean@.
  -> m ()
glColorMaskIndexedEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glColorMaskIndexedEXT ptr_glColorMaskIndexedEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorMaskIndexedEXT
  :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glColorMaskIndexedEXT #-}
ptr_glColorMaskIndexedEXT :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskIndexedEXT = unsafePerformIO $ getCommand "glColorMaskIndexedEXT"

-- glColorMaski ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glColorMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glColorMask.xhtml OpenGL 4.x>
glColorMaski
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type @Boolean@.
  -> GLboolean -- ^ @g@ of type @Boolean@.
  -> GLboolean -- ^ @b@ of type @Boolean@.
  -> GLboolean -- ^ @a@ of type @Boolean@.
  -> m ()
glColorMaski v1 v2 v3 v4 v5 = liftIO $ dyn_glColorMaski ptr_glColorMaski v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorMaski
  :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glColorMaski #-}
ptr_glColorMaski :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaski = unsafePerformIO $ getCommand "glColorMaski"

-- glColorMaskiEXT -------------------------------------------------------------

glColorMaskiEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type @Boolean@.
  -> GLboolean -- ^ @g@ of type @Boolean@.
  -> GLboolean -- ^ @b@ of type @Boolean@.
  -> GLboolean -- ^ @a@ of type @Boolean@.
  -> m ()
glColorMaskiEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glColorMaskiEXT ptr_glColorMaskiEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorMaskiEXT
  :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glColorMaskiEXT #-}
ptr_glColorMaskiEXT :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskiEXT = unsafePerformIO $ getCommand "glColorMaskiEXT"

-- glColorMaskiOES -------------------------------------------------------------

glColorMaskiOES
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type @Boolean@.
  -> GLboolean -- ^ @g@ of type @Boolean@.
  -> GLboolean -- ^ @b@ of type @Boolean@.
  -> GLboolean -- ^ @a@ of type @Boolean@.
  -> m ()
glColorMaskiOES v1 v2 v3 v4 v5 = liftIO $ dyn_glColorMaskiOES ptr_glColorMaskiOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorMaskiOES
  :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glColorMaskiOES #-}
ptr_glColorMaskiOES :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskiOES = unsafePerformIO $ getCommand "glColorMaskiOES"

-- glColorMaterial -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorMaterial.xml OpenGL 2.x>
glColorMaterial
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @mode@ of type @ColorMaterialParameter@.
  -> m ()
glColorMaterial v1 v2 = liftIO $ dyn_glColorMaterial ptr_glColorMaterial v1 v2

foreign import CALLCONV "dynamic" dyn_glColorMaterial
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glColorMaterial #-}
ptr_glColorMaterial :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glColorMaterial = unsafePerformIO $ getCommand "glColorMaterial"

-- glColorP3ui -----------------------------------------------------------------

glColorP3ui
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @color@.
  -> m ()
glColorP3ui v1 v2 = liftIO $ dyn_glColorP3ui ptr_glColorP3ui v1 v2

foreign import CALLCONV "dynamic" dyn_glColorP3ui
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glColorP3ui #-}
ptr_glColorP3ui :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glColorP3ui = unsafePerformIO $ getCommand "glColorP3ui"

-- glColorP3uiv ----------------------------------------------------------------

glColorP3uiv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLuint -- ^ @color@ pointing to @1@ elements of type @GLuint@.
  -> m ()
glColorP3uiv v1 v2 = liftIO $ dyn_glColorP3uiv ptr_glColorP3uiv v1 v2

foreign import CALLCONV "dynamic" dyn_glColorP3uiv
  :: FunPtr (GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glColorP3uiv #-}
ptr_glColorP3uiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glColorP3uiv = unsafePerformIO $ getCommand "glColorP3uiv"

-- glColorP4ui -----------------------------------------------------------------

glColorP4ui
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @color@.
  -> m ()
glColorP4ui v1 v2 = liftIO $ dyn_glColorP4ui ptr_glColorP4ui v1 v2

foreign import CALLCONV "dynamic" dyn_glColorP4ui
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glColorP4ui #-}
ptr_glColorP4ui :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glColorP4ui = unsafePerformIO $ getCommand "glColorP4ui"

-- glColorP4uiv ----------------------------------------------------------------

glColorP4uiv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLuint -- ^ @color@ pointing to @1@ elements of type @GLuint@.
  -> m ()
glColorP4uiv v1 v2 = liftIO $ dyn_glColorP4uiv ptr_glColorP4uiv v1 v2

foreign import CALLCONV "dynamic" dyn_glColorP4uiv
  :: FunPtr (GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glColorP4uiv #-}
ptr_glColorP4uiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glColorP4uiv = unsafePerformIO $ getCommand "glColorP4uiv"

-- glColorPointer --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorPointer.xml OpenGL 2.x>
glColorPointer
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @ColorPointerType@.
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride)@ elements of type @a@.
  -> m ()
glColorPointer v1 v2 v3 v4 = liftIO $ dyn_glColorPointer ptr_glColorPointer v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glColorPointer
  :: FunPtr (GLint -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLint -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorPointer #-}
ptr_glColorPointer :: FunPtr (GLint -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glColorPointer = unsafePerformIO $ getCommand "glColorPointer"

-- glColorPointerEXT -----------------------------------------------------------

glColorPointerEXT
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @ColorPointerType@.
  -> GLsizei -- ^ @stride@.
  -> GLsizei -- ^ @count@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride,count)@ elements of type @a@.
  -> m ()
glColorPointerEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glColorPointerEXT ptr_glColorPointerEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorPointerEXT
  :: FunPtr (GLint -> GLenum -> GLsizei -> GLsizei -> Ptr a -> IO ())
  ->         GLint -> GLenum -> GLsizei -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorPointerEXT #-}
ptr_glColorPointerEXT :: FunPtr (GLint -> GLenum -> GLsizei -> GLsizei -> Ptr a -> IO ())
ptr_glColorPointerEXT = unsafePerformIO $ getCommand "glColorPointerEXT"

-- glColorPointerListIBM -------------------------------------------------------

glColorPointerListIBM
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @ColorPointerType@.
  -> GLint -- ^ @stride@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride)@ elements of type @Ptr a@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glColorPointerListIBM v1 v2 v3 v4 v5 = liftIO $ dyn_glColorPointerListIBM ptr_glColorPointerListIBM v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glColorPointerListIBM
  :: FunPtr (GLint -> GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
  ->         GLint -> GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ()

{-# NOINLINE ptr_glColorPointerListIBM #-}
ptr_glColorPointerListIBM :: FunPtr (GLint -> GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
ptr_glColorPointerListIBM = unsafePerformIO $ getCommand "glColorPointerListIBM"

-- glColorPointervINTEL --------------------------------------------------------

glColorPointervINTEL
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @VertexPointerType@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @4@ elements of type @Ptr a@.
  -> m ()
glColorPointervINTEL v1 v2 v3 = liftIO $ dyn_glColorPointervINTEL ptr_glColorPointervINTEL v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorPointervINTEL
  :: FunPtr (GLint -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLint -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glColorPointervINTEL #-}
ptr_glColorPointervINTEL :: FunPtr (GLint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glColorPointervINTEL = unsafePerformIO $ getCommand "glColorPointervINTEL"

-- glColorSubTable -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorSubTable.xml OpenGL 2.x>
glColorSubTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type,count)@ elements of type @a@.
  -> m ()
glColorSubTable v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColorSubTable ptr_glColorSubTable v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColorSubTable
  :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorSubTable #-}
ptr_glColorSubTable :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorSubTable = unsafePerformIO $ getCommand "glColorSubTable"

-- glColorSubTableEXT ----------------------------------------------------------

glColorSubTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type,count)@ elements of type @a@.
  -> m ()
glColorSubTableEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColorSubTableEXT ptr_glColorSubTableEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColorSubTableEXT
  :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorSubTableEXT #-}
ptr_glColorSubTableEXT :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorSubTableEXT = unsafePerformIO $ getCommand "glColorSubTableEXT"

-- glColorTable ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTable.xml OpenGL 2.x>
glColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTable v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColorTable ptr_glColorTable v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColorTable
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorTable #-}
ptr_glColorTable :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTable = unsafePerformIO $ getCommand "glColorTable"

-- glColorTableEXT -------------------------------------------------------------

glColorTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalFormat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTableEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColorTableEXT ptr_glColorTableEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColorTableEXT
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorTableEXT #-}
ptr_glColorTableEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTableEXT = unsafePerformIO $ getCommand "glColorTableEXT"

-- glColorTableParameterfv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameter.xml OpenGL 2.x>
glColorTableParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glColorTableParameterfv v1 v2 v3 = liftIO $ dyn_glColorTableParameterfv ptr_glColorTableParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorTableParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColorTableParameterfv #-}
ptr_glColorTableParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glColorTableParameterfv = unsafePerformIO $ getCommand "glColorTableParameterfv"

-- glColorTableParameterfvSGI --------------------------------------------------

glColorTableParameterfvSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPNameSGI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glColorTableParameterfvSGI v1 v2 v3 = liftIO $ dyn_glColorTableParameterfvSGI ptr_glColorTableParameterfvSGI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorTableParameterfvSGI
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glColorTableParameterfvSGI #-}
ptr_glColorTableParameterfvSGI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glColorTableParameterfvSGI = unsafePerformIO $ getCommand "glColorTableParameterfvSGI"

-- glColorTableParameteriv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameter.xml OpenGL 2.x>
glColorTableParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glColorTableParameteriv v1 v2 v3 = liftIO $ dyn_glColorTableParameteriv ptr_glColorTableParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorTableParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glColorTableParameteriv #-}
ptr_glColorTableParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glColorTableParameteriv = unsafePerformIO $ getCommand "glColorTableParameteriv"

-- glColorTableParameterivSGI --------------------------------------------------

glColorTableParameterivSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPNameSGI@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glColorTableParameterivSGI v1 v2 v3 = liftIO $ dyn_glColorTableParameterivSGI ptr_glColorTableParameterivSGI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glColorTableParameterivSGI
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glColorTableParameterivSGI #-}
ptr_glColorTableParameterivSGI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glColorTableParameterivSGI = unsafePerformIO $ getCommand "glColorTableParameterivSGI"

-- glColorTableSGI -------------------------------------------------------------

glColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTableSGI v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glColorTableSGI ptr_glColorTableSGI v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glColorTableSGI
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glColorTableSGI #-}
ptr_glColorTableSGI :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTableSGI = unsafePerformIO $ getCommand "glColorTableSGI"

-- glCombinerInputNV -----------------------------------------------------------

glCombinerInputNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @input@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @mapping@ of type @CombinerMappingNV@.
  -> GLenum -- ^ @componentUsage@ of type @CombinerComponentUsageNV@.
  -> m ()
glCombinerInputNV v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCombinerInputNV ptr_glCombinerInputNV v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCombinerInputNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glCombinerInputNV #-}
ptr_glCombinerInputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glCombinerInputNV = unsafePerformIO $ getCommand "glCombinerInputNV"

-- glCombinerOutputNV ----------------------------------------------------------

glCombinerOutputNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @abOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @cdOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @sumOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @scale@ of type @CombinerScaleNV@.
  -> GLenum -- ^ @bias@ of type @CombinerBiasNV@.
  -> GLboolean -- ^ @abDotProduct@ of type @Boolean@.
  -> GLboolean -- ^ @cdDotProduct@ of type @Boolean@.
  -> GLboolean -- ^ @muxSum@ of type @Boolean@.
  -> m ()
glCombinerOutputNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCombinerOutputNV ptr_glCombinerOutputNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCombinerOutputNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLboolean -> GLboolean -> GLboolean -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLboolean -> GLboolean -> GLboolean -> IO ()

{-# NOINLINE ptr_glCombinerOutputNV #-}
ptr_glCombinerOutputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glCombinerOutputNV = unsafePerformIO $ getCommand "glCombinerOutputNV"

-- glCombinerParameterfNV ------------------------------------------------------

glCombinerParameterfNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> GLfloat -- ^ @param@.
  -> m ()
glCombinerParameterfNV v1 v2 = liftIO $ dyn_glCombinerParameterfNV ptr_glCombinerParameterfNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCombinerParameterfNV
  :: FunPtr (GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glCombinerParameterfNV #-}
ptr_glCombinerParameterfNV :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glCombinerParameterfNV = unsafePerformIO $ getCommand "glCombinerParameterfNV"

-- glCombinerParameterfvNV -----------------------------------------------------

glCombinerParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glCombinerParameterfvNV v1 v2 = liftIO $ dyn_glCombinerParameterfvNV ptr_glCombinerParameterfvNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCombinerParameterfvNV
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCombinerParameterfvNV #-}
ptr_glCombinerParameterfvNV :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glCombinerParameterfvNV = unsafePerformIO $ getCommand "glCombinerParameterfvNV"

-- glCombinerParameteriNV ------------------------------------------------------

glCombinerParameteriNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> GLint -- ^ @param@.
  -> m ()
glCombinerParameteriNV v1 v2 = liftIO $ dyn_glCombinerParameteriNV ptr_glCombinerParameteriNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCombinerParameteriNV
  :: FunPtr (GLenum -> GLint -> IO ())
  ->         GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glCombinerParameteriNV #-}
ptr_glCombinerParameteriNV :: FunPtr (GLenum -> GLint -> IO ())
ptr_glCombinerParameteriNV = unsafePerformIO $ getCommand "glCombinerParameteriNV"

-- glCombinerParameterivNV -----------------------------------------------------

glCombinerParameterivNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glCombinerParameterivNV v1 v2 = liftIO $ dyn_glCombinerParameterivNV ptr_glCombinerParameterivNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCombinerParameterivNV
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glCombinerParameterivNV #-}
ptr_glCombinerParameterivNV :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glCombinerParameterivNV = unsafePerformIO $ getCommand "glCombinerParameterivNV"

-- glCombinerStageParameterfvNV ------------------------------------------------

glCombinerStageParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glCombinerStageParameterfvNV v1 v2 v3 = liftIO $ dyn_glCombinerStageParameterfvNV ptr_glCombinerStageParameterfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCombinerStageParameterfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCombinerStageParameterfvNV #-}
ptr_glCombinerStageParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCombinerStageParameterfvNV = unsafePerformIO $ getCommand "glCombinerStageParameterfvNV"

-- glCompileShader -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompileShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompileShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompileShader.xhtml OpenGL 4.x>
glCompileShader
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> m ()
glCompileShader v1 = liftIO $ dyn_glCompileShader ptr_glCompileShader v1

foreign import CALLCONV "dynamic" dyn_glCompileShader
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glCompileShader #-}
ptr_glCompileShader :: FunPtr (GLuint -> IO ())
ptr_glCompileShader = unsafePerformIO $ getCommand "glCompileShader"

-- glCompileShaderARB ----------------------------------------------------------

glCompileShaderARB
  :: MonadIO m
  => GLhandleARB -- ^ @shaderObj@ of type @handleARB@.
  -> m ()
glCompileShaderARB v1 = liftIO $ dyn_glCompileShaderARB ptr_glCompileShaderARB v1

foreign import CALLCONV "dynamic" dyn_glCompileShaderARB
  :: FunPtr (GLhandleARB -> IO ())
  ->         GLhandleARB -> IO ()

{-# NOINLINE ptr_glCompileShaderARB #-}
ptr_glCompileShaderARB :: FunPtr (GLhandleARB -> IO ())
ptr_glCompileShaderARB = unsafePerformIO $ getCommand "glCompileShaderARB"

-- glCompileShaderIncludeARB ---------------------------------------------------

glCompileShaderIncludeARB
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @path@ pointing to @count@ elements of type @Ptr GLchar@.
  -> Ptr GLint -- ^ @length@ pointing to @count@ elements of type @GLint@.
  -> m ()
glCompileShaderIncludeARB v1 v2 v3 v4 = liftIO $ dyn_glCompileShaderIncludeARB ptr_glCompileShaderIncludeARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glCompileShaderIncludeARB
  :: FunPtr (GLuint -> GLsizei -> Ptr (Ptr GLchar) -> Ptr GLint -> IO ())
  ->         GLuint -> GLsizei -> Ptr (Ptr GLchar) -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glCompileShaderIncludeARB #-}
ptr_glCompileShaderIncludeARB :: FunPtr (GLuint -> GLsizei -> Ptr (Ptr GLchar) -> Ptr GLint -> IO ())
ptr_glCompileShaderIncludeARB = unsafePerformIO $ getCommand "glCompileShaderIncludeARB"

-- glCompressedMultiTexImage1DEXT ----------------------------------------------

glCompressedMultiTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedMultiTexImage1DEXT ptr_glCompressedMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexImage1DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexImage1DEXT #-}
ptr_glCompressedMultiTexImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage1DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage1DEXT"

-- glCompressedMultiTexImage2DEXT ----------------------------------------------

glCompressedMultiTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedMultiTexImage2DEXT ptr_glCompressedMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexImage2DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexImage2DEXT #-}
ptr_glCompressedMultiTexImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage2DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage2DEXT"

-- glCompressedMultiTexImage3DEXT ----------------------------------------------

glCompressedMultiTexImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCompressedMultiTexImage3DEXT ptr_glCompressedMultiTexImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexImage3DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexImage3DEXT #-}
ptr_glCompressedMultiTexImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage3DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage3DEXT"

-- glCompressedMultiTexSubImage1DEXT -------------------------------------------

glCompressedMultiTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedMultiTexSubImage1DEXT ptr_glCompressedMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexSubImage1DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexSubImage1DEXT #-}
ptr_glCompressedMultiTexSubImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage1DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage1DEXT"

-- glCompressedMultiTexSubImage2DEXT -------------------------------------------

glCompressedMultiTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCompressedMultiTexSubImage2DEXT ptr_glCompressedMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexSubImage2DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexSubImage2DEXT #-}
ptr_glCompressedMultiTexSubImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage2DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage2DEXT"

-- glCompressedMultiTexSubImage3DEXT -------------------------------------------

glCompressedMultiTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn_glCompressedMultiTexSubImage3DEXT ptr_glCompressedMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

foreign import CALLCONV "dynamic" dyn_glCompressedMultiTexSubImage3DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedMultiTexSubImage3DEXT #-}
ptr_glCompressedMultiTexSubImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage3DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage3DEXT"

-- glCompressedTexImage1D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage1D.xhtml OpenGL 4.x>
glCompressedTexImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCompressedTexImage1D ptr_glCompressedTexImage1D v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage1D
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage1D #-}
ptr_glCompressedTexImage1D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage1D = unsafePerformIO $ getCommand "glCompressedTexImage1D"

-- glCompressedTexImage1DARB ---------------------------------------------------

glCompressedTexImage1DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage1DARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCompressedTexImage1DARB ptr_glCompressedTexImage1DARB v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage1DARB
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage1DARB #-}
ptr_glCompressedTexImage1DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage1DARB = unsafePerformIO $ getCommand "glCompressedTexImage1DARB"

-- glCompressedTexImage2D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage2D.xhtml OpenGL 4.x>
glCompressedTexImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedTexImage2D ptr_glCompressedTexImage2D v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage2D
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage2D #-}
ptr_glCompressedTexImage2D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage2D = unsafePerformIO $ getCommand "glCompressedTexImage2D"

-- glCompressedTexImage2DARB ---------------------------------------------------

glCompressedTexImage2DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedTexImage2DARB ptr_glCompressedTexImage2DARB v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage2DARB
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage2DARB #-}
ptr_glCompressedTexImage2DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage2DARB = unsafePerformIO $ getCommand "glCompressedTexImage2DARB"

-- glCompressedTexImage3D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage3D.xhtml OpenGL 4.x>
glCompressedTexImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTexImage3D ptr_glCompressedTexImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage3D
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage3D #-}
ptr_glCompressedTexImage3D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3D = unsafePerformIO $ getCommand "glCompressedTexImage3D"

-- glCompressedTexImage3DARB ---------------------------------------------------

glCompressedTexImage3DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTexImage3DARB ptr_glCompressedTexImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage3DARB
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage3DARB #-}
ptr_glCompressedTexImage3DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3DARB = unsafePerformIO $ getCommand "glCompressedTexImage3DARB"

-- glCompressedTexImage3DOES ---------------------------------------------------

glCompressedTexImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTexImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTexImage3DOES ptr_glCompressedTexImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTexImage3DOES
  :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexImage3DOES #-}
ptr_glCompressedTexImage3DOES :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3DOES = unsafePerformIO $ getCommand "glCompressedTexImage3DOES"

-- glCompressedTexSubImage1D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage1D.xhtml OpenGL 4.x>
glCompressedTexSubImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCompressedTexSubImage1D ptr_glCompressedTexSubImage1D v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage1D
  :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage1D #-}
ptr_glCompressedTexSubImage1D :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage1D = unsafePerformIO $ getCommand "glCompressedTexSubImage1D"

-- glCompressedTexSubImage1DARB ------------------------------------------------

glCompressedTexSubImage1DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage1DARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCompressedTexSubImage1DARB ptr_glCompressedTexSubImage1DARB v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage1DARB
  :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage1DARB #-}
ptr_glCompressedTexSubImage1DARB :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage1DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage1DARB"

-- glCompressedTexSubImage2D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage2D.xhtml OpenGL 4.x>
glCompressedTexSubImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTexSubImage2D ptr_glCompressedTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage2D
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage2D #-}
ptr_glCompressedTexSubImage2D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage2D = unsafePerformIO $ getCommand "glCompressedTexSubImage2D"

-- glCompressedTexSubImage2DARB ------------------------------------------------

glCompressedTexSubImage2DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTexSubImage2DARB ptr_glCompressedTexSubImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage2DARB
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage2DARB #-}
ptr_glCompressedTexSubImage2DARB :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage2DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage2DARB"

-- glCompressedTexSubImage3D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage3D.xhtml OpenGL 4.x>
glCompressedTexSubImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glCompressedTexSubImage3D ptr_glCompressedTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage3D
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage3D #-}
ptr_glCompressedTexSubImage3D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3D = unsafePerformIO $ getCommand "glCompressedTexSubImage3D"

-- glCompressedTexSubImage3DARB ------------------------------------------------

glCompressedTexSubImage3DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glCompressedTexSubImage3DARB ptr_glCompressedTexSubImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage3DARB
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage3DARB #-}
ptr_glCompressedTexSubImage3DARB :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage3DARB"

-- glCompressedTexSubImage3DOES ------------------------------------------------

glCompressedTexSubImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glCompressedTexSubImage3DOES ptr_glCompressedTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glCompressedTexSubImage3DOES
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTexSubImage3DOES #-}
ptr_glCompressedTexSubImage3DOES :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3DOES = unsafePerformIO $ getCommand "glCompressedTexSubImage3DOES"

-- glCompressedTextureImage1DEXT -----------------------------------------------

glCompressedTextureImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedTextureImage1DEXT ptr_glCompressedTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedTextureImage1DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureImage1DEXT #-}
ptr_glCompressedTextureImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage1DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage1DEXT"

-- glCompressedTextureImage2DEXT -----------------------------------------------

glCompressedTextureImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTextureImage2DEXT ptr_glCompressedTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTextureImage2DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureImage2DEXT #-}
ptr_glCompressedTextureImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage2DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage2DEXT"

-- glCompressedTextureImage3DEXT -----------------------------------------------

glCompressedTextureImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCompressedTextureImage3DEXT ptr_glCompressedTextureImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCompressedTextureImage3DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureImage3DEXT #-}
ptr_glCompressedTextureImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage3DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage3DEXT"

-- glCompressedTextureSubImage1D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage1D.xhtml OpenGL 4.x>
glCompressedTextureSubImage1D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCompressedTextureSubImage1D ptr_glCompressedTextureSubImage1D v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage1D
  :: FunPtr (GLuint -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage1D #-}
ptr_glCompressedTextureSubImage1D :: FunPtr (GLuint -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage1D = unsafePerformIO $ getCommand "glCompressedTextureSubImage1D"

-- glCompressedTextureSubImage1DEXT --------------------------------------------

glCompressedTextureSubImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCompressedTextureSubImage1DEXT ptr_glCompressedTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage1DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage1DEXT #-}
ptr_glCompressedTextureSubImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage1DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage1DEXT"

-- glCompressedTextureSubImage2D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage2D.xhtml OpenGL 4.x>
glCompressedTextureSubImage2D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCompressedTextureSubImage2D ptr_glCompressedTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage2D
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage2D #-}
ptr_glCompressedTextureSubImage2D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage2D = unsafePerformIO $ getCommand "glCompressedTextureSubImage2D"

-- glCompressedTextureSubImage2DEXT --------------------------------------------

glCompressedTextureSubImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCompressedTextureSubImage2DEXT ptr_glCompressedTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage2DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage2DEXT #-}
ptr_glCompressedTextureSubImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage2DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage2DEXT"

-- glCompressedTextureSubImage3D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage3D.xhtml OpenGL 4.x>
glCompressedTextureSubImage3D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glCompressedTextureSubImage3D ptr_glCompressedTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage3D
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage3D #-}
ptr_glCompressedTextureSubImage3D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage3D = unsafePerformIO $ getCommand "glCompressedTextureSubImage3D"

-- glCompressedTextureSubImage3DEXT --------------------------------------------

glCompressedTextureSubImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn_glCompressedTextureSubImage3DEXT ptr_glCompressedTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

foreign import CALLCONV "dynamic" dyn_glCompressedTextureSubImage3DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glCompressedTextureSubImage3DEXT #-}
ptr_glCompressedTextureSubImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage3DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage3DEXT"

-- glConvolutionFilter1D -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter1D.xml OpenGL 2.x>
glConvolutionFilter1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glConvolutionFilter1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glConvolutionFilter1D ptr_glConvolutionFilter1D v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glConvolutionFilter1D
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glConvolutionFilter1D #-}
ptr_glConvolutionFilter1D :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter1D = unsafePerformIO $ getCommand "glConvolutionFilter1D"

-- glConvolutionFilter1DEXT ----------------------------------------------------

glConvolutionFilter1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glConvolutionFilter1DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glConvolutionFilter1DEXT ptr_glConvolutionFilter1DEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glConvolutionFilter1DEXT
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glConvolutionFilter1DEXT #-}
ptr_glConvolutionFilter1DEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter1DEXT = unsafePerformIO $ getCommand "glConvolutionFilter1DEXT"

-- glConvolutionFilter2D -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter2D.xml OpenGL 2.x>
glConvolutionFilter2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glConvolutionFilter2D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glConvolutionFilter2D ptr_glConvolutionFilter2D v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glConvolutionFilter2D
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glConvolutionFilter2D #-}
ptr_glConvolutionFilter2D :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter2D = unsafePerformIO $ getCommand "glConvolutionFilter2D"

-- glConvolutionFilter2DEXT ----------------------------------------------------

glConvolutionFilter2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glConvolutionFilter2DEXT ptr_glConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glConvolutionFilter2DEXT
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glConvolutionFilter2DEXT #-}
ptr_glConvolutionFilter2DEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter2DEXT = unsafePerformIO $ getCommand "glConvolutionFilter2DEXT"

-- glConvolutionParameterf -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>
glConvolutionParameterf
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> GLfloat -- ^ @params@ of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterf v1 v2 v3 = liftIO $ dyn_glConvolutionParameterf ptr_glConvolutionParameterf v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterf
  :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glConvolutionParameterf #-}
ptr_glConvolutionParameterf :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glConvolutionParameterf = unsafePerformIO $ getCommand "glConvolutionParameterf"

-- glConvolutionParameterfEXT --------------------------------------------------

glConvolutionParameterfEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> GLfloat -- ^ @params@ of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfEXT v1 v2 v3 = liftIO $ dyn_glConvolutionParameterfEXT ptr_glConvolutionParameterfEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterfEXT
  :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glConvolutionParameterfEXT #-}
ptr_glConvolutionParameterfEXT :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glConvolutionParameterfEXT = unsafePerformIO $ getCommand "glConvolutionParameterfEXT"

-- glConvolutionParameterfv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>
glConvolutionParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfv v1 v2 v3 = liftIO $ dyn_glConvolutionParameterfv ptr_glConvolutionParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glConvolutionParameterfv #-}
ptr_glConvolutionParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glConvolutionParameterfv = unsafePerformIO $ getCommand "glConvolutionParameterfv"

-- glConvolutionParameterfvEXT -------------------------------------------------

glConvolutionParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfvEXT v1 v2 v3 = liftIO $ dyn_glConvolutionParameterfvEXT ptr_glConvolutionParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glConvolutionParameterfvEXT #-}
ptr_glConvolutionParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glConvolutionParameterfvEXT = unsafePerformIO $ getCommand "glConvolutionParameterfvEXT"

-- glConvolutionParameteri -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>
glConvolutionParameteri
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> GLint -- ^ @params@ of type @CheckedInt32@.
  -> m ()
glConvolutionParameteri v1 v2 v3 = liftIO $ dyn_glConvolutionParameteri ptr_glConvolutionParameteri v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameteri
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glConvolutionParameteri #-}
ptr_glConvolutionParameteri :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glConvolutionParameteri = unsafePerformIO $ getCommand "glConvolutionParameteri"

-- glConvolutionParameteriEXT --------------------------------------------------

glConvolutionParameteriEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> GLint -- ^ @params@ of type @CheckedInt32@.
  -> m ()
glConvolutionParameteriEXT v1 v2 v3 = liftIO $ dyn_glConvolutionParameteriEXT ptr_glConvolutionParameteriEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameteriEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glConvolutionParameteriEXT #-}
ptr_glConvolutionParameteriEXT :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glConvolutionParameteriEXT = unsafePerformIO $ getCommand "glConvolutionParameteriEXT"

-- glConvolutionParameteriv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>
glConvolutionParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glConvolutionParameteriv v1 v2 v3 = liftIO $ dyn_glConvolutionParameteriv ptr_glConvolutionParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glConvolutionParameteriv #-}
ptr_glConvolutionParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glConvolutionParameteriv = unsafePerformIO $ getCommand "glConvolutionParameteriv"

-- glConvolutionParameterivEXT -------------------------------------------------

glConvolutionParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glConvolutionParameterivEXT v1 v2 v3 = liftIO $ dyn_glConvolutionParameterivEXT ptr_glConvolutionParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glConvolutionParameterivEXT #-}
ptr_glConvolutionParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glConvolutionParameterivEXT = unsafePerformIO $ getCommand "glConvolutionParameterivEXT"

-- glConvolutionParameterxOES --------------------------------------------------

glConvolutionParameterxOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glConvolutionParameterxOES v1 v2 v3 = liftIO $ dyn_glConvolutionParameterxOES ptr_glConvolutionParameterxOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterxOES
  :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glConvolutionParameterxOES #-}
ptr_glConvolutionParameterxOES :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glConvolutionParameterxOES = unsafePerformIO $ getCommand "glConvolutionParameterxOES"

-- glConvolutionParameterxvOES -------------------------------------------------

glConvolutionParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glConvolutionParameterxvOES v1 v2 v3 = liftIO $ dyn_glConvolutionParameterxvOES ptr_glConvolutionParameterxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glConvolutionParameterxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glConvolutionParameterxvOES #-}
ptr_glConvolutionParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glConvolutionParameterxvOES = unsafePerformIO $ getCommand "glConvolutionParameterxvOES"

-- glCopyBufferSubData ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyBufferSubData.xhtml OpenGL 4.x>
glCopyBufferSubData
  :: MonadIO m
  => GLenum -- ^ @readTarget@.
  -> GLenum -- ^ @writeTarget@.
  -> GLintptr -- ^ @readOffset@ of type @BufferOffset@.
  -> GLintptr -- ^ @writeOffset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyBufferSubData v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyBufferSubData ptr_glCopyBufferSubData v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyBufferSubData
  :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glCopyBufferSubData #-}
ptr_glCopyBufferSubData :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyBufferSubData = unsafePerformIO $ getCommand "glCopyBufferSubData"

-- glCopyBufferSubDataNV -------------------------------------------------------

glCopyBufferSubDataNV
  :: MonadIO m
  => GLenum -- ^ @readTarget@.
  -> GLenum -- ^ @writeTarget@.
  -> GLintptr -- ^ @readOffset@ of type @BufferOffset@.
  -> GLintptr -- ^ @writeOffset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyBufferSubDataNV v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyBufferSubDataNV ptr_glCopyBufferSubDataNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyBufferSubDataNV
  :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glCopyBufferSubDataNV #-}
ptr_glCopyBufferSubDataNV :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyBufferSubDataNV = unsafePerformIO $ getCommand "glCopyBufferSubDataNV"

-- glCopyColorSubTable ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorSubTable.xml OpenGL 2.x>
glCopyColorSubTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorSubTable v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyColorSubTable ptr_glCopyColorSubTable v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyColorSubTable
  :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyColorSubTable #-}
ptr_glCopyColorSubTable :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorSubTable = unsafePerformIO $ getCommand "glCopyColorSubTable"

-- glCopyColorSubTableEXT ------------------------------------------------------

glCopyColorSubTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorSubTableEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyColorSubTableEXT ptr_glCopyColorSubTableEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyColorSubTableEXT
  :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyColorSubTableEXT #-}
ptr_glCopyColorSubTableEXT :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorSubTableEXT = unsafePerformIO $ getCommand "glCopyColorSubTableEXT"

-- glCopyColorTable ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorTable.xml OpenGL 2.x>
glCopyColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorTable v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyColorTable ptr_glCopyColorTable v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyColorTable
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyColorTable #-}
ptr_glCopyColorTable :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorTable = unsafePerformIO $ getCommand "glCopyColorTable"

-- glCopyColorTableSGI ---------------------------------------------------------

glCopyColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorTableSGI v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyColorTableSGI ptr_glCopyColorTableSGI v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyColorTableSGI
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyColorTableSGI #-}
ptr_glCopyColorTableSGI :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorTableSGI = unsafePerformIO $ getCommand "glCopyColorTableSGI"

-- glCopyConvolutionFilter1D ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter1D.xml OpenGL 2.x>
glCopyConvolutionFilter1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyConvolutionFilter1D v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyConvolutionFilter1D ptr_glCopyConvolutionFilter1D v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyConvolutionFilter1D
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyConvolutionFilter1D #-}
ptr_glCopyConvolutionFilter1D :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter1D = unsafePerformIO $ getCommand "glCopyConvolutionFilter1D"

-- glCopyConvolutionFilter1DEXT ------------------------------------------------

glCopyConvolutionFilter1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyConvolutionFilter1DEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyConvolutionFilter1DEXT ptr_glCopyConvolutionFilter1DEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyConvolutionFilter1DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyConvolutionFilter1DEXT #-}
ptr_glCopyConvolutionFilter1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter1DEXT = unsafePerformIO $ getCommand "glCopyConvolutionFilter1DEXT"

-- glCopyConvolutionFilter2D ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter2D.xml OpenGL 2.x>
glCopyConvolutionFilter2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyConvolutionFilter2D v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCopyConvolutionFilter2D ptr_glCopyConvolutionFilter2D v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCopyConvolutionFilter2D
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyConvolutionFilter2D #-}
ptr_glCopyConvolutionFilter2D :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter2D = unsafePerformIO $ getCommand "glCopyConvolutionFilter2D"

-- glCopyConvolutionFilter2DEXT ------------------------------------------------

glCopyConvolutionFilter2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCopyConvolutionFilter2DEXT ptr_glCopyConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCopyConvolutionFilter2DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyConvolutionFilter2DEXT #-}
ptr_glCopyConvolutionFilter2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter2DEXT = unsafePerformIO $ getCommand "glCopyConvolutionFilter2DEXT"

-- glCopyImageSubData ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyImageSubData.xhtml OpenGL 4.x>
glCopyImageSubData
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubData v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn_glCopyImageSubData ptr_glCopyImageSubData v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

foreign import CALLCONV "dynamic" dyn_glCopyImageSubData
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyImageSubData #-}
ptr_glCopyImageSubData :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubData = unsafePerformIO $ getCommand "glCopyImageSubData"

-- glCopyImageSubDataEXT -------------------------------------------------------

glCopyImageSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubDataEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn_glCopyImageSubDataEXT ptr_glCopyImageSubDataEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

foreign import CALLCONV "dynamic" dyn_glCopyImageSubDataEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyImageSubDataEXT #-}
ptr_glCopyImageSubDataEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataEXT = unsafePerformIO $ getCommand "glCopyImageSubDataEXT"

-- glCopyImageSubDataNV --------------------------------------------------------

glCopyImageSubDataNV
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> m ()
glCopyImageSubDataNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn_glCopyImageSubDataNV ptr_glCopyImageSubDataNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

foreign import CALLCONV "dynamic" dyn_glCopyImageSubDataNV
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyImageSubDataNV #-}
ptr_glCopyImageSubDataNV :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataNV = unsafePerformIO $ getCommand "glCopyImageSubDataNV"

-- glCopyImageSubDataOES -------------------------------------------------------

glCopyImageSubDataOES
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubDataOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn_glCopyImageSubDataOES ptr_glCopyImageSubDataOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

foreign import CALLCONV "dynamic" dyn_glCopyImageSubDataOES
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyImageSubDataOES #-}
ptr_glCopyImageSubDataOES :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataOES = unsafePerformIO $ getCommand "glCopyImageSubDataOES"

-- glCopyMultiTexImage1DEXT ----------------------------------------------------

glCopyMultiTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyMultiTexImage1DEXT ptr_glCopyMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyMultiTexImage1DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyMultiTexImage1DEXT #-}
ptr_glCopyMultiTexImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyMultiTexImage1DEXT = unsafePerformIO $ getCommand "glCopyMultiTexImage1DEXT"

-- glCopyMultiTexImage2DEXT ----------------------------------------------------

glCopyMultiTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyMultiTexImage2DEXT ptr_glCopyMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyMultiTexImage2DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyMultiTexImage2DEXT #-}
ptr_glCopyMultiTexImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyMultiTexImage2DEXT = unsafePerformIO $ getCommand "glCopyMultiTexImage2DEXT"

-- glCopyMultiTexSubImage1DEXT -------------------------------------------------

glCopyMultiTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCopyMultiTexSubImage1DEXT ptr_glCopyMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCopyMultiTexSubImage1DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyMultiTexSubImage1DEXT #-}
ptr_glCopyMultiTexSubImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage1DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage1DEXT"

-- glCopyMultiTexSubImage2DEXT -------------------------------------------------

glCopyMultiTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyMultiTexSubImage2DEXT ptr_glCopyMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyMultiTexSubImage2DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyMultiTexSubImage2DEXT #-}
ptr_glCopyMultiTexSubImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage2DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage2DEXT"

-- glCopyMultiTexSubImage3DEXT -------------------------------------------------

glCopyMultiTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCopyMultiTexSubImage3DEXT ptr_glCopyMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCopyMultiTexSubImage3DEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyMultiTexSubImage3DEXT #-}
ptr_glCopyMultiTexSubImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage3DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage3DEXT"

-- glCopyNamedBufferSubData ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyBufferSubData.xhtml OpenGL 4.x>
glCopyNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @readBuffer@.
  -> GLuint -- ^ @writeBuffer@.
  -> GLintptr -- ^ @readOffset@.
  -> GLintptr -- ^ @writeOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyNamedBufferSubData v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyNamedBufferSubData ptr_glCopyNamedBufferSubData v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyNamedBufferSubData
  :: FunPtr (GLuint -> GLuint -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLuint -> GLuint -> GLintptr -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glCopyNamedBufferSubData #-}
ptr_glCopyNamedBufferSubData :: FunPtr (GLuint -> GLuint -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyNamedBufferSubData = unsafePerformIO $ getCommand "glCopyNamedBufferSubData"

-- glCopyPathNV ----------------------------------------------------------------

glCopyPathNV
  :: MonadIO m
  => GLuint -- ^ @resultPath@ of type @Path@.
  -> GLuint -- ^ @srcPath@ of type @Path@.
  -> m ()
glCopyPathNV v1 v2 = liftIO $ dyn_glCopyPathNV ptr_glCopyPathNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCopyPathNV
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glCopyPathNV #-}
ptr_glCopyPathNV :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glCopyPathNV = unsafePerformIO $ getCommand "glCopyPathNV"

-- glCopyPixels ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyPixels.xml OpenGL 2.x>
glCopyPixels
  :: MonadIO m
  => GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @type@ of type @PixelCopyType@.
  -> m ()
glCopyPixels v1 v2 v3 v4 v5 = liftIO $ dyn_glCopyPixels ptr_glCopyPixels v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glCopyPixels
  :: FunPtr (GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> IO ())
  ->         GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> IO ()

{-# NOINLINE ptr_glCopyPixels #-}
ptr_glCopyPixels :: FunPtr (GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> IO ())
ptr_glCopyPixels = unsafePerformIO $ getCommand "glCopyPixels"

-- glCopyTexImage1D ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexImage1D.xhtml OpenGL 4.x>
glCopyTexImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCopyTexImage1D ptr_glCopyTexImage1D v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCopyTexImage1D
  :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTexImage1D #-}
ptr_glCopyTexImage1D :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage1D = unsafePerformIO $ getCommand "glCopyTexImage1D"

-- glCopyTexImage1DEXT ---------------------------------------------------------

glCopyTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCopyTexImage1DEXT ptr_glCopyTexImage1DEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCopyTexImage1DEXT
  :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTexImage1DEXT #-}
ptr_glCopyTexImage1DEXT :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage1DEXT = unsafePerformIO $ getCommand "glCopyTexImage1DEXT"

-- glCopyTexImage2D ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexImage2D.xhtml OpenGL 4.x>
glCopyTexImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTexImage2D ptr_glCopyTexImage2D v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTexImage2D
  :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTexImage2D #-}
ptr_glCopyTexImage2D :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage2D = unsafePerformIO $ getCommand "glCopyTexImage2D"

-- glCopyTexImage2DEXT ---------------------------------------------------------

glCopyTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @PixelInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTexImage2DEXT ptr_glCopyTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTexImage2DEXT
  :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTexImage2DEXT #-}
ptr_glCopyTexImage2DEXT :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage2DEXT = unsafePerformIO $ getCommand "glCopyTexImage2DEXT"

-- glCopyTexSubImage1D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage1D.xhtml OpenGL 4.x>
glCopyTexSubImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTexSubImage1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCopyTexSubImage1D ptr_glCopyTexSubImage1D v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage1D
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage1D #-}
ptr_glCopyTexSubImage1D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTexSubImage1D = unsafePerformIO $ getCommand "glCopyTexSubImage1D"

-- glCopyTexSubImage1DEXT ------------------------------------------------------

glCopyTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTexSubImage1DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCopyTexSubImage1DEXT ptr_glCopyTexSubImage1DEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage1DEXT
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage1DEXT #-}
ptr_glCopyTexSubImage1DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTexSubImage1DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage1DEXT"

-- glCopyTexSubImage2D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage2D.xhtml OpenGL 4.x>
glCopyTexSubImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTexSubImage2D ptr_glCopyTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage2D
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage2D #-}
ptr_glCopyTexSubImage2D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage2D = unsafePerformIO $ getCommand "glCopyTexSubImage2D"

-- glCopyTexSubImage2DEXT ------------------------------------------------------

glCopyTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTexSubImage2DEXT ptr_glCopyTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage2DEXT
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage2DEXT #-}
ptr_glCopyTexSubImage2DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage2DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage2DEXT"

-- glCopyTexSubImage3D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage3D.xhtml OpenGL 4.x>
glCopyTexSubImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTexSubImage3D ptr_glCopyTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage3D
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage3D #-}
ptr_glCopyTexSubImage3D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3D = unsafePerformIO $ getCommand "glCopyTexSubImage3D"

-- glCopyTexSubImage3DEXT ------------------------------------------------------

glCopyTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTexSubImage3DEXT ptr_glCopyTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage3DEXT
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage3DEXT #-}
ptr_glCopyTexSubImage3DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage3DEXT"

-- glCopyTexSubImage3DOES ------------------------------------------------------

glCopyTexSubImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTexSubImage3DOES ptr_glCopyTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTexSubImage3DOES
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTexSubImage3DOES #-}
ptr_glCopyTexSubImage3DOES :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3DOES = unsafePerformIO $ getCommand "glCopyTexSubImage3DOES"

-- glCopyTextureImage1DEXT -----------------------------------------------------

glCopyTextureImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTextureImage1DEXT ptr_glCopyTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTextureImage1DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTextureImage1DEXT #-}
ptr_glCopyTextureImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTextureImage1DEXT = unsafePerformIO $ getCommand "glCopyTextureImage1DEXT"

-- glCopyTextureImage2DEXT -----------------------------------------------------

glCopyTextureImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTextureImage2DEXT ptr_glCopyTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTextureImage2DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glCopyTextureImage2DEXT #-}
ptr_glCopyTextureImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTextureImage2DEXT = unsafePerformIO $ getCommand "glCopyTextureImage2DEXT"

-- glCopyTextureLevelsAPPLE ----------------------------------------------------

glCopyTextureLevelsAPPLE
  :: MonadIO m
  => GLuint -- ^ @destinationTexture@.
  -> GLuint -- ^ @sourceTexture@.
  -> GLint -- ^ @sourceBaseLevel@.
  -> GLsizei -- ^ @sourceLevelCount@.
  -> m ()
glCopyTextureLevelsAPPLE v1 v2 v3 v4 = liftIO $ dyn_glCopyTextureLevelsAPPLE ptr_glCopyTextureLevelsAPPLE v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glCopyTextureLevelsAPPLE
  :: FunPtr (GLuint -> GLuint -> GLint -> GLsizei -> IO ())
  ->         GLuint -> GLuint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureLevelsAPPLE #-}
ptr_glCopyTextureLevelsAPPLE :: FunPtr (GLuint -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureLevelsAPPLE = unsafePerformIO $ getCommand "glCopyTextureLevelsAPPLE"

-- glCopyTextureSubImage1D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage1D.xhtml OpenGL 4.x>
glCopyTextureSubImage1D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTextureSubImage1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glCopyTextureSubImage1D ptr_glCopyTextureSubImage1D v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage1D
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage1D #-}
ptr_glCopyTextureSubImage1D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureSubImage1D = unsafePerformIO $ getCommand "glCopyTextureSubImage1D"

-- glCopyTextureSubImage1DEXT --------------------------------------------------

glCopyTextureSubImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCopyTextureSubImage1DEXT ptr_glCopyTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage1DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage1DEXT #-}
ptr_glCopyTextureSubImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureSubImage1DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage1DEXT"

-- glCopyTextureSubImage2D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage2D.xhtml OpenGL 4.x>
glCopyTextureSubImage2D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glCopyTextureSubImage2D ptr_glCopyTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage2D
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage2D #-}
ptr_glCopyTextureSubImage2D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage2D = unsafePerformIO $ getCommand "glCopyTextureSubImage2D"

-- glCopyTextureSubImage2DEXT --------------------------------------------------

glCopyTextureSubImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTextureSubImage2DEXT ptr_glCopyTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage2DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage2DEXT #-}
ptr_glCopyTextureSubImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage2DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage2DEXT"

-- glCopyTextureSubImage3D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage3D.xhtml OpenGL 4.x>
glCopyTextureSubImage3D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glCopyTextureSubImage3D ptr_glCopyTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage3D
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage3D #-}
ptr_glCopyTextureSubImage3D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage3D = unsafePerformIO $ getCommand "glCopyTextureSubImage3D"

-- glCopyTextureSubImage3DEXT --------------------------------------------------

glCopyTextureSubImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glCopyTextureSubImage3DEXT ptr_glCopyTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glCopyTextureSubImage3DEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glCopyTextureSubImage3DEXT #-}
ptr_glCopyTextureSubImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage3DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage3DEXT"

-- glCoverFillPathInstancedNV --------------------------------------------------

glCoverFillPathInstancedNV
  :: MonadIO m
  => GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @transformValues@ pointing to @COMPSIZE(numPaths,transformType)@ elements of type @GLfloat@.
  -> m ()
glCoverFillPathInstancedNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCoverFillPathInstancedNV ptr_glCoverFillPathInstancedNV v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCoverFillPathInstancedNV
  :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCoverFillPathInstancedNV #-}
ptr_glCoverFillPathInstancedNV :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCoverFillPathInstancedNV = unsafePerformIO $ getCommand "glCoverFillPathInstancedNV"

-- glCoverFillPathNV -----------------------------------------------------------

glCoverFillPathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> m ()
glCoverFillPathNV v1 v2 = liftIO $ dyn_glCoverFillPathNV ptr_glCoverFillPathNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCoverFillPathNV
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glCoverFillPathNV #-}
ptr_glCoverFillPathNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glCoverFillPathNV = unsafePerformIO $ getCommand "glCoverFillPathNV"

-- glCoverStrokePathInstancedNV ------------------------------------------------

glCoverStrokePathInstancedNV
  :: MonadIO m
  => GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @transformValues@ pointing to @COMPSIZE(numPaths,transformType)@ elements of type @GLfloat@.
  -> m ()
glCoverStrokePathInstancedNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glCoverStrokePathInstancedNV ptr_glCoverStrokePathInstancedNV v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glCoverStrokePathInstancedNV
  :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCoverStrokePathInstancedNV #-}
ptr_glCoverStrokePathInstancedNV :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCoverStrokePathInstancedNV = unsafePerformIO $ getCommand "glCoverStrokePathInstancedNV"

-- glCoverStrokePathNV ---------------------------------------------------------

glCoverStrokePathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> m ()
glCoverStrokePathNV v1 v2 = liftIO $ dyn_glCoverStrokePathNV ptr_glCoverStrokePathNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCoverStrokePathNV
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glCoverStrokePathNV #-}
ptr_glCoverStrokePathNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glCoverStrokePathNV = unsafePerformIO $ getCommand "glCoverStrokePathNV"

-- glCoverageMaskNV ------------------------------------------------------------

glCoverageMaskNV
  :: MonadIO m
  => GLboolean -- ^ @mask@.
  -> m ()
glCoverageMaskNV v1 = liftIO $ dyn_glCoverageMaskNV ptr_glCoverageMaskNV v1

foreign import CALLCONV "dynamic" dyn_glCoverageMaskNV
  :: FunPtr (GLboolean -> IO ())
  ->         GLboolean -> IO ()

{-# NOINLINE ptr_glCoverageMaskNV #-}
ptr_glCoverageMaskNV :: FunPtr (GLboolean -> IO ())
ptr_glCoverageMaskNV = unsafePerformIO $ getCommand "glCoverageMaskNV"

-- glCoverageModulationNV ------------------------------------------------------

glCoverageModulationNV
  :: MonadIO m
  => GLenum -- ^ @components@.
  -> m ()
glCoverageModulationNV v1 = liftIO $ dyn_glCoverageModulationNV ptr_glCoverageModulationNV v1

foreign import CALLCONV "dynamic" dyn_glCoverageModulationNV
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glCoverageModulationNV #-}
ptr_glCoverageModulationNV :: FunPtr (GLenum -> IO ())
ptr_glCoverageModulationNV = unsafePerformIO $ getCommand "glCoverageModulationNV"

-- glCoverageModulationTableNV -------------------------------------------------

glCoverageModulationTableNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glCoverageModulationTableNV v1 v2 = liftIO $ dyn_glCoverageModulationTableNV ptr_glCoverageModulationTableNV v1 v2

foreign import CALLCONV "dynamic" dyn_glCoverageModulationTableNV
  :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
  ->         GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCoverageModulationTableNV #-}
ptr_glCoverageModulationTableNV :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glCoverageModulationTableNV = unsafePerformIO $ getCommand "glCoverageModulationTableNV"

-- glCoverageOperationNV -------------------------------------------------------

glCoverageOperationNV
  :: MonadIO m
  => GLenum -- ^ @operation@.
  -> m ()
glCoverageOperationNV v1 = liftIO $ dyn_glCoverageOperationNV ptr_glCoverageOperationNV v1

foreign import CALLCONV "dynamic" dyn_glCoverageOperationNV
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glCoverageOperationNV #-}
ptr_glCoverageOperationNV :: FunPtr (GLenum -> IO ())
ptr_glCoverageOperationNV = unsafePerformIO $ getCommand "glCoverageOperationNV"

-- glCreateBuffers -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateBuffers.xhtml OpenGL 4.x>
glCreateBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@.
  -> m ()
glCreateBuffers v1 v2 = liftIO $ dyn_glCreateBuffers ptr_glCreateBuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateBuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateBuffers #-}
ptr_glCreateBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateBuffers = unsafePerformIO $ getCommand "glCreateBuffers"

-- glCreateFramebuffers --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateFramebuffers.xhtml OpenGL 4.x>
glCreateFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@.
  -> m ()
glCreateFramebuffers v1 v2 = liftIO $ dyn_glCreateFramebuffers ptr_glCreateFramebuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateFramebuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateFramebuffers #-}
ptr_glCreateFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateFramebuffers = unsafePerformIO $ getCommand "glCreateFramebuffers"

-- glCreatePerfQueryINTEL ------------------------------------------------------

glCreatePerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> Ptr GLuint -- ^ @queryHandle@.
  -> m ()
glCreatePerfQueryINTEL v1 v2 = liftIO $ dyn_glCreatePerfQueryINTEL ptr_glCreatePerfQueryINTEL v1 v2

foreign import CALLCONV "dynamic" dyn_glCreatePerfQueryINTEL
  :: FunPtr (GLuint -> Ptr GLuint -> IO ())
  ->         GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreatePerfQueryINTEL #-}
ptr_glCreatePerfQueryINTEL :: FunPtr (GLuint -> Ptr GLuint -> IO ())
ptr_glCreatePerfQueryINTEL = unsafePerformIO $ getCommand "glCreatePerfQueryINTEL"

-- glCreateProgram -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCreateProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCreateProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCreateProgram.xhtml OpenGL 4.x>
glCreateProgram
  :: MonadIO m
  => m GLuint
glCreateProgram = liftIO $ dyn_glCreateProgram ptr_glCreateProgram

foreign import CALLCONV "dynamic" dyn_glCreateProgram
  :: FunPtr (IO GLuint)
  ->         IO GLuint

{-# NOINLINE ptr_glCreateProgram #-}
ptr_glCreateProgram :: FunPtr (IO GLuint)
ptr_glCreateProgram = unsafePerformIO $ getCommand "glCreateProgram"

-- glCreateProgramObjectARB ----------------------------------------------------

glCreateProgramObjectARB
  :: MonadIO m
  => m GLhandleARB -- ^ of type @handleARB@.
glCreateProgramObjectARB = liftIO $ dyn_glCreateProgramObjectARB ptr_glCreateProgramObjectARB

foreign import CALLCONV "dynamic" dyn_glCreateProgramObjectARB
  :: FunPtr (IO GLhandleARB)
  ->         IO GLhandleARB

{-# NOINLINE ptr_glCreateProgramObjectARB #-}
ptr_glCreateProgramObjectARB :: FunPtr (IO GLhandleARB)
ptr_glCreateProgramObjectARB = unsafePerformIO $ getCommand "glCreateProgramObjectARB"

-- glCreateProgramPipelines ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateProgramPipelines.xhtml OpenGL 4.x>
glCreateProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@.
  -> m ()
glCreateProgramPipelines v1 v2 = liftIO $ dyn_glCreateProgramPipelines ptr_glCreateProgramPipelines v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateProgramPipelines
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateProgramPipelines #-}
ptr_glCreateProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateProgramPipelines = unsafePerformIO $ getCommand "glCreateProgramPipelines"

-- glCreateQueries -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateQueries.xhtml OpenGL 4.x>
glCreateQueries
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@.
  -> m ()
glCreateQueries v1 v2 v3 = liftIO $ dyn_glCreateQueries ptr_glCreateQueries v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCreateQueries
  :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLenum -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateQueries #-}
ptr_glCreateQueries :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateQueries = unsafePerformIO $ getCommand "glCreateQueries"

-- glCreateRenderbuffers -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateRenderbuffers.xhtml OpenGL 4.x>
glCreateRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@.
  -> m ()
glCreateRenderbuffers v1 v2 = liftIO $ dyn_glCreateRenderbuffers ptr_glCreateRenderbuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateRenderbuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateRenderbuffers #-}
ptr_glCreateRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateRenderbuffers = unsafePerformIO $ getCommand "glCreateRenderbuffers"

-- glCreateSamplers ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateSamplers.xhtml OpenGL 4.x>
glCreateSamplers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @samplers@.
  -> m ()
glCreateSamplers v1 v2 = liftIO $ dyn_glCreateSamplers ptr_glCreateSamplers v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateSamplers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateSamplers #-}
ptr_glCreateSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateSamplers = unsafePerformIO $ getCommand "glCreateSamplers"

-- glCreateShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCreateShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCreateShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCreateShader.xhtml OpenGL 4.x>
glCreateShader
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> m GLuint
glCreateShader v1 = liftIO $ dyn_glCreateShader ptr_glCreateShader v1

foreign import CALLCONV "dynamic" dyn_glCreateShader
  :: FunPtr (GLenum -> IO GLuint)
  ->         GLenum -> IO GLuint

{-# NOINLINE ptr_glCreateShader #-}
ptr_glCreateShader :: FunPtr (GLenum -> IO GLuint)
ptr_glCreateShader = unsafePerformIO $ getCommand "glCreateShader"

-- glCreateShaderObjectARB -----------------------------------------------------

glCreateShaderObjectARB
  :: MonadIO m
  => GLenum -- ^ @shaderType@.
  -> m GLhandleARB -- ^ of type @handleARB@.
glCreateShaderObjectARB v1 = liftIO $ dyn_glCreateShaderObjectARB ptr_glCreateShaderObjectARB v1

foreign import CALLCONV "dynamic" dyn_glCreateShaderObjectARB
  :: FunPtr (GLenum -> IO GLhandleARB)
  ->         GLenum -> IO GLhandleARB

{-# NOINLINE ptr_glCreateShaderObjectARB #-}
ptr_glCreateShaderObjectARB :: FunPtr (GLenum -> IO GLhandleARB)
ptr_glCreateShaderObjectARB = unsafePerformIO $ getCommand "glCreateShaderObjectARB"

-- glCreateShaderProgramEXT ----------------------------------------------------

glCreateShaderProgramEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLchar -- ^ @string@.
  -> m GLuint
glCreateShaderProgramEXT v1 v2 = liftIO $ dyn_glCreateShaderProgramEXT ptr_glCreateShaderProgramEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateShaderProgramEXT
  :: FunPtr (GLenum -> Ptr GLchar -> IO GLuint)
  ->         GLenum -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glCreateShaderProgramEXT #-}
ptr_glCreateShaderProgramEXT :: FunPtr (GLenum -> Ptr GLchar -> IO GLuint)
ptr_glCreateShaderProgramEXT = unsafePerformIO $ getCommand "glCreateShaderProgramEXT"

-- glCreateShaderProgramv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateShaderProgram.xhtml OpenGL 4.x>
glCreateShaderProgramv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @strings@ pointing to @count@ elements of type @Ptr GLchar@.
  -> m GLuint
glCreateShaderProgramv v1 v2 v3 = liftIO $ dyn_glCreateShaderProgramv ptr_glCreateShaderProgramv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCreateShaderProgramv
  :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
  ->         GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint

{-# NOINLINE ptr_glCreateShaderProgramv #-}
ptr_glCreateShaderProgramv :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
ptr_glCreateShaderProgramv = unsafePerformIO $ getCommand "glCreateShaderProgramv"

-- glCreateShaderProgramvEXT ---------------------------------------------------

glCreateShaderProgramvEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @strings@ pointing to @count@ elements of type @Ptr GLchar@.
  -> m GLuint
glCreateShaderProgramvEXT v1 v2 v3 = liftIO $ dyn_glCreateShaderProgramvEXT ptr_glCreateShaderProgramvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCreateShaderProgramvEXT
  :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
  ->         GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint

{-# NOINLINE ptr_glCreateShaderProgramvEXT #-}
ptr_glCreateShaderProgramvEXT :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
ptr_glCreateShaderProgramvEXT = unsafePerformIO $ getCommand "glCreateShaderProgramvEXT"

-- glCreateSyncFromCLeventARB --------------------------------------------------

glCreateSyncFromCLeventARB
  :: MonadIO m
  => Ptr a -- ^ @context@ pointing to elements of type @cl_context@.
  -> Ptr b -- ^ @event@ pointing to elements of type @cl_event@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync -- ^ of type @sync@.
glCreateSyncFromCLeventARB v1 v2 v3 = liftIO $ dyn_glCreateSyncFromCLeventARB ptr_glCreateSyncFromCLeventARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCreateSyncFromCLeventARB
  :: FunPtr (Ptr a -> Ptr b -> GLbitfield -> IO GLsync)
  ->         Ptr a -> Ptr b -> GLbitfield -> IO GLsync

{-# NOINLINE ptr_glCreateSyncFromCLeventARB #-}
ptr_glCreateSyncFromCLeventARB :: FunPtr (Ptr a -> Ptr b -> GLbitfield -> IO GLsync)
ptr_glCreateSyncFromCLeventARB = unsafePerformIO $ getCommand "glCreateSyncFromCLeventARB"

-- glCreateTextures ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateTextures.xhtml OpenGL 4.x>
glCreateTextures
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@.
  -> m ()
glCreateTextures v1 v2 v3 = liftIO $ dyn_glCreateTextures ptr_glCreateTextures v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glCreateTextures
  :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLenum -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateTextures #-}
ptr_glCreateTextures :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateTextures = unsafePerformIO $ getCommand "glCreateTextures"

-- glCreateTransformFeedbacks --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateTransformFeedbacks.xhtml OpenGL 4.x>
glCreateTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@.
  -> m ()
glCreateTransformFeedbacks v1 v2 = liftIO $ dyn_glCreateTransformFeedbacks ptr_glCreateTransformFeedbacks v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateTransformFeedbacks
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateTransformFeedbacks #-}
ptr_glCreateTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateTransformFeedbacks = unsafePerformIO $ getCommand "glCreateTransformFeedbacks"

-- glCreateVertexArrays --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateVertexArrays.xhtml OpenGL 4.x>
glCreateVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@.
  -> m ()
glCreateVertexArrays v1 v2 = liftIO $ dyn_glCreateVertexArrays ptr_glCreateVertexArrays v1 v2

foreign import CALLCONV "dynamic" dyn_glCreateVertexArrays
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glCreateVertexArrays #-}
ptr_glCreateVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateVertexArrays = unsafePerformIO $ getCommand "glCreateVertexArrays"

-- glCullFace ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCullFace.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCullFace.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCullFace.xhtml OpenGL 4.x>
glCullFace
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @CullFaceMode@.
  -> m ()
glCullFace v1 = liftIO $ dyn_glCullFace ptr_glCullFace v1

foreign import CALLCONV "dynamic" dyn_glCullFace
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glCullFace #-}
ptr_glCullFace :: FunPtr (GLenum -> IO ())
ptr_glCullFace = unsafePerformIO $ getCommand "glCullFace"

-- glCullParameterdvEXT --------------------------------------------------------

glCullParameterdvEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CullParameterEXT@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glCullParameterdvEXT v1 v2 = liftIO $ dyn_glCullParameterdvEXT ptr_glCullParameterdvEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glCullParameterdvEXT
  :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glCullParameterdvEXT #-}
ptr_glCullParameterdvEXT :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glCullParameterdvEXT = unsafePerformIO $ getCommand "glCullParameterdvEXT"

-- glCullParameterfvEXT --------------------------------------------------------

glCullParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CullParameterEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glCullParameterfvEXT v1 v2 = liftIO $ dyn_glCullParameterfvEXT ptr_glCullParameterfvEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glCullParameterfvEXT
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glCullParameterfvEXT #-}
ptr_glCullParameterfvEXT :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glCullParameterfvEXT = unsafePerformIO $ getCommand "glCullParameterfvEXT"

-- glCurrentPaletteMatrixARB ---------------------------------------------------

glCurrentPaletteMatrixARB
  :: MonadIO m
  => GLint -- ^ @index@.
  -> m ()
glCurrentPaletteMatrixARB v1 = liftIO $ dyn_glCurrentPaletteMatrixARB ptr_glCurrentPaletteMatrixARB v1

foreign import CALLCONV "dynamic" dyn_glCurrentPaletteMatrixARB
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glCurrentPaletteMatrixARB #-}
ptr_glCurrentPaletteMatrixARB :: FunPtr (GLint -> IO ())
ptr_glCurrentPaletteMatrixARB = unsafePerformIO $ getCommand "glCurrentPaletteMatrixARB"

-- glCurrentPaletteMatrixOES ---------------------------------------------------

glCurrentPaletteMatrixOES
  :: MonadIO m
  => GLuint -- ^ @matrixpaletteindex@.
  -> m ()
glCurrentPaletteMatrixOES v1 = liftIO $ dyn_glCurrentPaletteMatrixOES ptr_glCurrentPaletteMatrixOES v1

foreign import CALLCONV "dynamic" dyn_glCurrentPaletteMatrixOES
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glCurrentPaletteMatrixOES #-}
ptr_glCurrentPaletteMatrixOES :: FunPtr (GLuint -> IO ())
ptr_glCurrentPaletteMatrixOES = unsafePerformIO $ getCommand "glCurrentPaletteMatrixOES"

-- glDebugMessageCallback ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageCallback.xhtml OpenGL 4.x>
glDebugMessageCallback
  :: MonadIO m
  => GLDEBUGPROC -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallback v1 v2 = liftIO $ dyn_glDebugMessageCallback ptr_glDebugMessageCallback v1 v2

foreign import CALLCONV "dynamic" dyn_glDebugMessageCallback
  :: FunPtr (GLDEBUGPROC -> Ptr a -> IO ())
  ->         GLDEBUGPROC -> Ptr a -> IO ()

{-# NOINLINE ptr_glDebugMessageCallback #-}
ptr_glDebugMessageCallback :: FunPtr (GLDEBUGPROC -> Ptr a -> IO ())
ptr_glDebugMessageCallback = unsafePerformIO $ getCommand "glDebugMessageCallback"

-- glDebugMessageCallbackAMD ---------------------------------------------------

glDebugMessageCallbackAMD
  :: MonadIO m
  => GLDEBUGPROCAMD -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallbackAMD v1 v2 = liftIO $ dyn_glDebugMessageCallbackAMD ptr_glDebugMessageCallbackAMD v1 v2

foreign import CALLCONV "dynamic" dyn_glDebugMessageCallbackAMD
  :: FunPtr (GLDEBUGPROCAMD -> Ptr a -> IO ())
  ->         GLDEBUGPROCAMD -> Ptr a -> IO ()

{-# NOINLINE ptr_glDebugMessageCallbackAMD #-}
ptr_glDebugMessageCallbackAMD :: FunPtr (GLDEBUGPROCAMD -> Ptr a -> IO ())
ptr_glDebugMessageCallbackAMD = unsafePerformIO $ getCommand "glDebugMessageCallbackAMD"

-- glDebugMessageCallbackARB ---------------------------------------------------

glDebugMessageCallbackARB
  :: MonadIO m
  => GLDEBUGPROCARB -- ^ @callback@.
  -> Ptr a -- ^ @userParam@ pointing to @COMPSIZE(callback)@ elements of type @a@.
  -> m ()
glDebugMessageCallbackARB v1 v2 = liftIO $ dyn_glDebugMessageCallbackARB ptr_glDebugMessageCallbackARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDebugMessageCallbackARB
  :: FunPtr (GLDEBUGPROCARB -> Ptr a -> IO ())
  ->         GLDEBUGPROCARB -> Ptr a -> IO ()

{-# NOINLINE ptr_glDebugMessageCallbackARB #-}
ptr_glDebugMessageCallbackARB :: FunPtr (GLDEBUGPROCARB -> Ptr a -> IO ())
ptr_glDebugMessageCallbackARB = unsafePerformIO $ getCommand "glDebugMessageCallbackARB"

-- glDebugMessageCallbackKHR ---------------------------------------------------

glDebugMessageCallbackKHR
  :: MonadIO m
  => GLDEBUGPROCKHR -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallbackKHR v1 v2 = liftIO $ dyn_glDebugMessageCallbackKHR ptr_glDebugMessageCallbackKHR v1 v2

foreign import CALLCONV "dynamic" dyn_glDebugMessageCallbackKHR
  :: FunPtr (GLDEBUGPROCKHR -> Ptr a -> IO ())
  ->         GLDEBUGPROCKHR -> Ptr a -> IO ()

{-# NOINLINE ptr_glDebugMessageCallbackKHR #-}
ptr_glDebugMessageCallbackKHR :: FunPtr (GLDEBUGPROCKHR -> Ptr a -> IO ())
ptr_glDebugMessageCallbackKHR = unsafePerformIO $ getCommand "glDebugMessageCallbackKHR"

-- glDebugMessageControl -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageControl.xhtml OpenGL 4.x>
glDebugMessageControl
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type @Boolean@.
  -> m ()
glDebugMessageControl v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageControl ptr_glDebugMessageControl v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageControl
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ()

{-# NOINLINE ptr_glDebugMessageControl #-}
ptr_glDebugMessageControl :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControl = unsafePerformIO $ getCommand "glDebugMessageControl"

-- glDebugMessageControlARB ----------------------------------------------------

glDebugMessageControlARB
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type @Boolean@.
  -> m ()
glDebugMessageControlARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageControlARB ptr_glDebugMessageControlARB v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageControlARB
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ()

{-# NOINLINE ptr_glDebugMessageControlARB #-}
ptr_glDebugMessageControlARB :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControlARB = unsafePerformIO $ getCommand "glDebugMessageControlARB"

-- glDebugMessageControlKHR ----------------------------------------------------

glDebugMessageControlKHR
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@.
  -> GLboolean -- ^ @enabled@.
  -> m ()
glDebugMessageControlKHR v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageControlKHR ptr_glDebugMessageControlKHR v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageControlKHR
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ()

{-# NOINLINE ptr_glDebugMessageControlKHR #-}
ptr_glDebugMessageControlKHR :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControlKHR = unsafePerformIO $ getCommand "glDebugMessageControlKHR"

-- glDebugMessageEnableAMD -----------------------------------------------------

glDebugMessageEnableAMD
  :: MonadIO m
  => GLenum -- ^ @category@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type @Boolean@.
  -> m ()
glDebugMessageEnableAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glDebugMessageEnableAMD ptr_glDebugMessageEnableAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDebugMessageEnableAMD
  :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ()

{-# NOINLINE ptr_glDebugMessageEnableAMD #-}
ptr_glDebugMessageEnableAMD :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageEnableAMD = unsafePerformIO $ getCommand "glDebugMessageEnableAMD"

-- glDebugMessageInsert --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageInsert.xhtml OpenGL 4.x>
glDebugMessageInsert
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @COMPSIZE(buf,length)@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsert v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageInsert ptr_glDebugMessageInsert v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageInsert
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glDebugMessageInsert #-}
ptr_glDebugMessageInsert :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsert = unsafePerformIO $ getCommand "glDebugMessageInsert"

-- glDebugMessageInsertAMD -----------------------------------------------------

glDebugMessageInsertAMD
  :: MonadIO m
  => GLenum -- ^ @category@.
  -> GLenum -- ^ @severity@.
  -> GLuint -- ^ @id@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @length@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsertAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glDebugMessageInsertAMD ptr_glDebugMessageInsertAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDebugMessageInsertAMD
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glDebugMessageInsertAMD #-}
ptr_glDebugMessageInsertAMD :: FunPtr (GLenum -> GLenum -> GLuint -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertAMD = unsafePerformIO $ getCommand "glDebugMessageInsertAMD"

-- glDebugMessageInsertARB -----------------------------------------------------

glDebugMessageInsertARB
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @length@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsertARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageInsertARB ptr_glDebugMessageInsertARB v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageInsertARB
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glDebugMessageInsertARB #-}
ptr_glDebugMessageInsertARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertARB = unsafePerformIO $ getCommand "glDebugMessageInsertARB"

-- glDebugMessageInsertKHR -----------------------------------------------------

glDebugMessageInsertKHR
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@.
  -> m ()
glDebugMessageInsertKHR v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDebugMessageInsertKHR ptr_glDebugMessageInsertKHR v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDebugMessageInsertKHR
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glDebugMessageInsertKHR #-}
ptr_glDebugMessageInsertKHR :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertKHR = unsafePerformIO $ getCommand "glDebugMessageInsertKHR"

-- glDeformSGIX ----------------------------------------------------------------

glDeformSGIX
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type @FfdMaskSGIX@.
  -> m ()
glDeformSGIX v1 = liftIO $ dyn_glDeformSGIX ptr_glDeformSGIX v1

foreign import CALLCONV "dynamic" dyn_glDeformSGIX
  :: FunPtr (GLbitfield -> IO ())
  ->         GLbitfield -> IO ()

{-# NOINLINE ptr_glDeformSGIX #-}
ptr_glDeformSGIX :: FunPtr (GLbitfield -> IO ())
ptr_glDeformSGIX = unsafePerformIO $ getCommand "glDeformSGIX"

-- glDeformationMap3dSGIX ------------------------------------------------------

glDeformationMap3dSGIX
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FfdTargetSGIX@.
  -> GLdouble -- ^ @u1@ of type @CoordD@.
  -> GLdouble -- ^ @u2@ of type @CoordD@.
  -> GLint -- ^ @ustride@.
  -> GLint -- ^ @uorder@ of type @CheckedInt32@.
  -> GLdouble -- ^ @v1@ of type @CoordD@.
  -> GLdouble -- ^ @v2@ of type @CoordD@.
  -> GLint -- ^ @vstride@.
  -> GLint -- ^ @vorder@ of type @CheckedInt32@.
  -> GLdouble -- ^ @w1@ of type @CoordD@.
  -> GLdouble -- ^ @w2@ of type @CoordD@.
  -> GLint -- ^ @wstride@.
  -> GLint -- ^ @worder@ of type @CheckedInt32@.
  -> Ptr GLdouble -- ^ @points@ pointing to @COMPSIZE(target,ustride,uorder,vstride,vorder,wstride,worder)@ elements of type @CoordD@.
  -> m ()
glDeformationMap3dSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 = liftIO $ dyn_glDeformationMap3dSGIX ptr_glDeformationMap3dSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14

foreign import CALLCONV "dynamic" dyn_glDeformationMap3dSGIX
  :: FunPtr (GLenum -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glDeformationMap3dSGIX #-}
ptr_glDeformationMap3dSGIX :: FunPtr (GLenum -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> Ptr GLdouble -> IO ())
ptr_glDeformationMap3dSGIX = unsafePerformIO $ getCommand "glDeformationMap3dSGIX"

-- glDeformationMap3fSGIX ------------------------------------------------------

glDeformationMap3fSGIX
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FfdTargetSGIX@.
  -> GLfloat -- ^ @u1@ of type @CoordF@.
  -> GLfloat -- ^ @u2@ of type @CoordF@.
  -> GLint -- ^ @ustride@.
  -> GLint -- ^ @uorder@ of type @CheckedInt32@.
  -> GLfloat -- ^ @v1@ of type @CoordF@.
  -> GLfloat -- ^ @v2@ of type @CoordF@.
  -> GLint -- ^ @vstride@.
  -> GLint -- ^ @vorder@ of type @CheckedInt32@.
  -> GLfloat -- ^ @w1@ of type @CoordF@.
  -> GLfloat -- ^ @w2@ of type @CoordF@.
  -> GLint -- ^ @wstride@.
  -> GLint -- ^ @worder@ of type @CheckedInt32@.
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target,ustride,uorder,vstride,vorder,wstride,worder)@ elements of type @CoordF@.
  -> m ()
glDeformationMap3fSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 = liftIO $ dyn_glDeformationMap3fSGIX ptr_glDeformationMap3fSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14

foreign import CALLCONV "dynamic" dyn_glDeformationMap3fSGIX
  :: FunPtr (GLenum -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glDeformationMap3fSGIX #-}
ptr_glDeformationMap3fSGIX :: FunPtr (GLenum -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> Ptr GLfloat -> IO ())
ptr_glDeformationMap3fSGIX = unsafePerformIO $ getCommand "glDeformationMap3fSGIX"

-- glDeleteAsyncMarkersSGIX ----------------------------------------------------

glDeleteAsyncMarkersSGIX
  :: MonadIO m
  => GLuint -- ^ @marker@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeleteAsyncMarkersSGIX v1 v2 = liftIO $ dyn_glDeleteAsyncMarkersSGIX ptr_glDeleteAsyncMarkersSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteAsyncMarkersSGIX
  :: FunPtr (GLuint -> GLsizei -> IO ())
  ->         GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDeleteAsyncMarkersSGIX #-}
ptr_glDeleteAsyncMarkersSGIX :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeleteAsyncMarkersSGIX = unsafePerformIO $ getCommand "glDeleteAsyncMarkersSGIX"

-- glDeleteBuffers -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteBuffers.xhtml OpenGL 4.x>
glDeleteBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteBuffers v1 v2 = liftIO $ dyn_glDeleteBuffers ptr_glDeleteBuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteBuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteBuffers #-}
ptr_glDeleteBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteBuffers = unsafePerformIO $ getCommand "glDeleteBuffers"

-- glDeleteBuffersARB ----------------------------------------------------------

glDeleteBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteBuffersARB v1 v2 = liftIO $ dyn_glDeleteBuffersARB ptr_glDeleteBuffersARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteBuffersARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteBuffersARB #-}
ptr_glDeleteBuffersARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteBuffersARB = unsafePerformIO $ getCommand "glDeleteBuffersARB"

-- glDeleteFencesAPPLE ---------------------------------------------------------

glDeleteFencesAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glDeleteFencesAPPLE v1 v2 = liftIO $ dyn_glDeleteFencesAPPLE ptr_glDeleteFencesAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteFencesAPPLE
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFencesAPPLE #-}
ptr_glDeleteFencesAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFencesAPPLE = unsafePerformIO $ getCommand "glDeleteFencesAPPLE"

-- glDeleteFencesNV ------------------------------------------------------------

glDeleteFencesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glDeleteFencesNV v1 v2 = liftIO $ dyn_glDeleteFencesNV ptr_glDeleteFencesNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteFencesNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFencesNV #-}
ptr_glDeleteFencesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFencesNV = unsafePerformIO $ getCommand "glDeleteFencesNV"

-- glDeleteFragmentShaderATI ---------------------------------------------------

glDeleteFragmentShaderATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDeleteFragmentShaderATI v1 = liftIO $ dyn_glDeleteFragmentShaderATI ptr_glDeleteFragmentShaderATI v1

foreign import CALLCONV "dynamic" dyn_glDeleteFragmentShaderATI
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFragmentShaderATI #-}
ptr_glDeleteFragmentShaderATI :: FunPtr (GLuint -> IO ())
ptr_glDeleteFragmentShaderATI = unsafePerformIO $ getCommand "glDeleteFragmentShaderATI"

-- glDeleteFramebuffers --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteFramebuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteFramebuffers.xhtml OpenGL 4.x>
glDeleteFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffers v1 v2 = liftIO $ dyn_glDeleteFramebuffers ptr_glDeleteFramebuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteFramebuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFramebuffers #-}
ptr_glDeleteFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffers = unsafePerformIO $ getCommand "glDeleteFramebuffers"

-- glDeleteFramebuffersEXT -----------------------------------------------------

glDeleteFramebuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffersEXT v1 v2 = liftIO $ dyn_glDeleteFramebuffersEXT ptr_glDeleteFramebuffersEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteFramebuffersEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFramebuffersEXT #-}
ptr_glDeleteFramebuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffersEXT = unsafePerformIO $ getCommand "glDeleteFramebuffersEXT"

-- glDeleteFramebuffersOES -----------------------------------------------------

glDeleteFramebuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffersOES v1 v2 = liftIO $ dyn_glDeleteFramebuffersOES ptr_glDeleteFramebuffersOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteFramebuffersOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteFramebuffersOES #-}
ptr_glDeleteFramebuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffersOES = unsafePerformIO $ getCommand "glDeleteFramebuffersOES"

-- glDeleteLists ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteLists.xml OpenGL 2.x>
glDeleteLists
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeleteLists v1 v2 = liftIO $ dyn_glDeleteLists ptr_glDeleteLists v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteLists
  :: FunPtr (GLuint -> GLsizei -> IO ())
  ->         GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDeleteLists #-}
ptr_glDeleteLists :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeleteLists = unsafePerformIO $ getCommand "glDeleteLists"

-- glDeleteNamedStringARB ------------------------------------------------------

glDeleteNamedStringARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> m ()
glDeleteNamedStringARB v1 v2 = liftIO $ dyn_glDeleteNamedStringARB ptr_glDeleteNamedStringARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteNamedStringARB
  :: FunPtr (GLint -> Ptr GLchar -> IO ())
  ->         GLint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glDeleteNamedStringARB #-}
ptr_glDeleteNamedStringARB :: FunPtr (GLint -> Ptr GLchar -> IO ())
ptr_glDeleteNamedStringARB = unsafePerformIO $ getCommand "glDeleteNamedStringARB"

-- glDeleteNamesAMD ------------------------------------------------------------

glDeleteNamesAMD
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @num@.
  -> Ptr GLuint -- ^ @names@ pointing to @num@ elements of type @GLuint@.
  -> m ()
glDeleteNamesAMD v1 v2 v3 = liftIO $ dyn_glDeleteNamesAMD ptr_glDeleteNamesAMD v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDeleteNamesAMD
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteNamesAMD #-}
ptr_glDeleteNamesAMD :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glDeleteNamesAMD = unsafePerformIO $ getCommand "glDeleteNamesAMD"

-- glDeleteObjectARB -----------------------------------------------------------

glDeleteObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> m ()
glDeleteObjectARB v1 = liftIO $ dyn_glDeleteObjectARB ptr_glDeleteObjectARB v1

foreign import CALLCONV "dynamic" dyn_glDeleteObjectARB
  :: FunPtr (GLhandleARB -> IO ())
  ->         GLhandleARB -> IO ()

{-# NOINLINE ptr_glDeleteObjectARB #-}
ptr_glDeleteObjectARB :: FunPtr (GLhandleARB -> IO ())
ptr_glDeleteObjectARB = unsafePerformIO $ getCommand "glDeleteObjectARB"

-- glDeleteOcclusionQueriesNV --------------------------------------------------

glDeleteOcclusionQueriesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteOcclusionQueriesNV v1 v2 = liftIO $ dyn_glDeleteOcclusionQueriesNV ptr_glDeleteOcclusionQueriesNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteOcclusionQueriesNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteOcclusionQueriesNV #-}
ptr_glDeleteOcclusionQueriesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteOcclusionQueriesNV = unsafePerformIO $ getCommand "glDeleteOcclusionQueriesNV"

-- glDeletePathsNV -------------------------------------------------------------

glDeletePathsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeletePathsNV v1 v2 = liftIO $ dyn_glDeletePathsNV ptr_glDeletePathsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDeletePathsNV
  :: FunPtr (GLuint -> GLsizei -> IO ())
  ->         GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDeletePathsNV #-}
ptr_glDeletePathsNV :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeletePathsNV = unsafePerformIO $ getCommand "glDeletePathsNV"

-- glDeletePerfMonitorsAMD -----------------------------------------------------

glDeletePerfMonitorsAMD
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @monitors@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeletePerfMonitorsAMD v1 v2 = liftIO $ dyn_glDeletePerfMonitorsAMD ptr_glDeletePerfMonitorsAMD v1 v2

foreign import CALLCONV "dynamic" dyn_glDeletePerfMonitorsAMD
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeletePerfMonitorsAMD #-}
ptr_glDeletePerfMonitorsAMD :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeletePerfMonitorsAMD = unsafePerformIO $ getCommand "glDeletePerfMonitorsAMD"

-- glDeletePerfQueryINTEL ------------------------------------------------------

glDeletePerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glDeletePerfQueryINTEL v1 = liftIO $ dyn_glDeletePerfQueryINTEL ptr_glDeletePerfQueryINTEL v1

foreign import CALLCONV "dynamic" dyn_glDeletePerfQueryINTEL
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDeletePerfQueryINTEL #-}
ptr_glDeletePerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glDeletePerfQueryINTEL = unsafePerformIO $ getCommand "glDeletePerfQueryINTEL"

-- glDeleteProgram -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteProgram.xhtml OpenGL 4.x>
glDeleteProgram
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m ()
glDeleteProgram v1 = liftIO $ dyn_glDeleteProgram ptr_glDeleteProgram v1

foreign import CALLCONV "dynamic" dyn_glDeleteProgram
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDeleteProgram #-}
ptr_glDeleteProgram :: FunPtr (GLuint -> IO ())
ptr_glDeleteProgram = unsafePerformIO $ getCommand "glDeleteProgram"

-- glDeleteProgramPipelines ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDeleteProgramPipelines.xhtml OpenGL 4.x>
glDeleteProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramPipelines v1 v2 = liftIO $ dyn_glDeleteProgramPipelines ptr_glDeleteProgramPipelines v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteProgramPipelines
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteProgramPipelines #-}
ptr_glDeleteProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramPipelines = unsafePerformIO $ getCommand "glDeleteProgramPipelines"

-- glDeleteProgramPipelinesEXT -------------------------------------------------

glDeleteProgramPipelinesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramPipelinesEXT v1 v2 = liftIO $ dyn_glDeleteProgramPipelinesEXT ptr_glDeleteProgramPipelinesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteProgramPipelinesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteProgramPipelinesEXT #-}
ptr_glDeleteProgramPipelinesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramPipelinesEXT = unsafePerformIO $ getCommand "glDeleteProgramPipelinesEXT"

-- glDeleteProgramsARB ---------------------------------------------------------

glDeleteProgramsARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramsARB v1 v2 = liftIO $ dyn_glDeleteProgramsARB ptr_glDeleteProgramsARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteProgramsARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteProgramsARB #-}
ptr_glDeleteProgramsARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramsARB = unsafePerformIO $ getCommand "glDeleteProgramsARB"

-- glDeleteProgramsNV ----------------------------------------------------------

glDeleteProgramsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramsNV v1 v2 = liftIO $ dyn_glDeleteProgramsNV ptr_glDeleteProgramsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteProgramsNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteProgramsNV #-}
ptr_glDeleteProgramsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramsNV = unsafePerformIO $ getCommand "glDeleteProgramsNV"

-- glDeleteQueries -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteQueries.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteQueries.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteQueries.xhtml OpenGL 4.x>
glDeleteQueries
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueries v1 v2 = liftIO $ dyn_glDeleteQueries ptr_glDeleteQueries v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteQueries
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteQueries #-}
ptr_glDeleteQueries :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueries = unsafePerformIO $ getCommand "glDeleteQueries"

-- glDeleteQueriesARB ----------------------------------------------------------

glDeleteQueriesARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueriesARB v1 v2 = liftIO $ dyn_glDeleteQueriesARB ptr_glDeleteQueriesARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteQueriesARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteQueriesARB #-}
ptr_glDeleteQueriesARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueriesARB = unsafePerformIO $ getCommand "glDeleteQueriesARB"

-- glDeleteQueriesEXT ----------------------------------------------------------

glDeleteQueriesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueriesEXT v1 v2 = liftIO $ dyn_glDeleteQueriesEXT ptr_glDeleteQueriesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteQueriesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteQueriesEXT #-}
ptr_glDeleteQueriesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueriesEXT = unsafePerformIO $ getCommand "glDeleteQueriesEXT"

-- glDeleteRenderbuffers -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteRenderbuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteRenderbuffers.xhtml OpenGL 4.x>
glDeleteRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffers v1 v2 = liftIO $ dyn_glDeleteRenderbuffers ptr_glDeleteRenderbuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteRenderbuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteRenderbuffers #-}
ptr_glDeleteRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffers = unsafePerformIO $ getCommand "glDeleteRenderbuffers"

-- glDeleteRenderbuffersEXT ----------------------------------------------------

glDeleteRenderbuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffersEXT v1 v2 = liftIO $ dyn_glDeleteRenderbuffersEXT ptr_glDeleteRenderbuffersEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteRenderbuffersEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteRenderbuffersEXT #-}
ptr_glDeleteRenderbuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffersEXT = unsafePerformIO $ getCommand "glDeleteRenderbuffersEXT"

-- glDeleteRenderbuffersOES ----------------------------------------------------

glDeleteRenderbuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffersOES v1 v2 = liftIO $ dyn_glDeleteRenderbuffersOES ptr_glDeleteRenderbuffersOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteRenderbuffersOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteRenderbuffersOES #-}
ptr_glDeleteRenderbuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffersOES = unsafePerformIO $ getCommand "glDeleteRenderbuffersOES"

-- glDeleteSamplers ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteSamplers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteSamplers.xhtml OpenGL 4.x>
glDeleteSamplers
  :: MonadIO m
  => GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glDeleteSamplers v1 v2 = liftIO $ dyn_glDeleteSamplers ptr_glDeleteSamplers v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteSamplers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteSamplers #-}
ptr_glDeleteSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteSamplers = unsafePerformIO $ getCommand "glDeleteSamplers"

-- glDeleteShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteShader.xhtml OpenGL 4.x>
glDeleteShader
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> m ()
glDeleteShader v1 = liftIO $ dyn_glDeleteShader ptr_glDeleteShader v1

foreign import CALLCONV "dynamic" dyn_glDeleteShader
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDeleteShader #-}
ptr_glDeleteShader :: FunPtr (GLuint -> IO ())
ptr_glDeleteShader = unsafePerformIO $ getCommand "glDeleteShader"

-- glDeleteSync ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteSync.xhtml OpenGL 4.x>
glDeleteSync
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> m ()
glDeleteSync v1 = liftIO $ dyn_glDeleteSync ptr_glDeleteSync v1

foreign import CALLCONV "dynamic" dyn_glDeleteSync
  :: FunPtr (GLsync -> IO ())
  ->         GLsync -> IO ()

{-# NOINLINE ptr_glDeleteSync #-}
ptr_glDeleteSync :: FunPtr (GLsync -> IO ())
ptr_glDeleteSync = unsafePerformIO $ getCommand "glDeleteSync"

-- glDeleteSyncAPPLE -----------------------------------------------------------

glDeleteSyncAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> m ()
glDeleteSyncAPPLE v1 = liftIO $ dyn_glDeleteSyncAPPLE ptr_glDeleteSyncAPPLE v1

foreign import CALLCONV "dynamic" dyn_glDeleteSyncAPPLE
  :: FunPtr (GLsync -> IO ())
  ->         GLsync -> IO ()

{-# NOINLINE ptr_glDeleteSyncAPPLE #-}
ptr_glDeleteSyncAPPLE :: FunPtr (GLsync -> IO ())
ptr_glDeleteSyncAPPLE = unsafePerformIO $ getCommand "glDeleteSyncAPPLE"

-- glDeleteTextures ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteTextures.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteTextures.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteTextures.xhtml OpenGL 4.x>
glDeleteTextures
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glDeleteTextures v1 v2 = liftIO $ dyn_glDeleteTextures ptr_glDeleteTextures v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteTextures
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteTextures #-}
ptr_glDeleteTextures :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTextures = unsafePerformIO $ getCommand "glDeleteTextures"

-- glDeleteTexturesEXT ---------------------------------------------------------

glDeleteTexturesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glDeleteTexturesEXT v1 v2 = liftIO $ dyn_glDeleteTexturesEXT ptr_glDeleteTexturesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteTexturesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteTexturesEXT #-}
ptr_glDeleteTexturesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTexturesEXT = unsafePerformIO $ getCommand "glDeleteTexturesEXT"

-- glDeleteTransformFeedbacks --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDeleteTransformFeedbacks.xhtml OpenGL 4.x>
glDeleteTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteTransformFeedbacks v1 v2 = liftIO $ dyn_glDeleteTransformFeedbacks ptr_glDeleteTransformFeedbacks v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteTransformFeedbacks
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteTransformFeedbacks #-}
ptr_glDeleteTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTransformFeedbacks = unsafePerformIO $ getCommand "glDeleteTransformFeedbacks"

-- glDeleteTransformFeedbacksNV ------------------------------------------------

glDeleteTransformFeedbacksNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteTransformFeedbacksNV v1 v2 = liftIO $ dyn_glDeleteTransformFeedbacksNV ptr_glDeleteTransformFeedbacksNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteTransformFeedbacksNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteTransformFeedbacksNV #-}
ptr_glDeleteTransformFeedbacksNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTransformFeedbacksNV = unsafePerformIO $ getCommand "glDeleteTransformFeedbacksNV"

-- glDeleteVertexArrays --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteVertexArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteVertexArrays.xhtml OpenGL 4.x>
glDeleteVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArrays v1 v2 = liftIO $ dyn_glDeleteVertexArrays ptr_glDeleteVertexArrays v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteVertexArrays
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteVertexArrays #-}
ptr_glDeleteVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArrays = unsafePerformIO $ getCommand "glDeleteVertexArrays"

-- glDeleteVertexArraysAPPLE ---------------------------------------------------

glDeleteVertexArraysAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArraysAPPLE v1 v2 = liftIO $ dyn_glDeleteVertexArraysAPPLE ptr_glDeleteVertexArraysAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteVertexArraysAPPLE
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteVertexArraysAPPLE #-}
ptr_glDeleteVertexArraysAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArraysAPPLE = unsafePerformIO $ getCommand "glDeleteVertexArraysAPPLE"

-- glDeleteVertexArraysOES -----------------------------------------------------

glDeleteVertexArraysOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArraysOES v1 v2 = liftIO $ dyn_glDeleteVertexArraysOES ptr_glDeleteVertexArraysOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDeleteVertexArraysOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glDeleteVertexArraysOES #-}
ptr_glDeleteVertexArraysOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArraysOES = unsafePerformIO $ getCommand "glDeleteVertexArraysOES"

-- glDeleteVertexShaderEXT -----------------------------------------------------

glDeleteVertexShaderEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDeleteVertexShaderEXT v1 = liftIO $ dyn_glDeleteVertexShaderEXT ptr_glDeleteVertexShaderEXT v1

foreign import CALLCONV "dynamic" dyn_glDeleteVertexShaderEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDeleteVertexShaderEXT #-}
ptr_glDeleteVertexShaderEXT :: FunPtr (GLuint -> IO ())
ptr_glDeleteVertexShaderEXT = unsafePerformIO $ getCommand "glDeleteVertexShaderEXT"

-- glDepthBoundsEXT ------------------------------------------------------------

glDepthBoundsEXT
  :: MonadIO m
  => GLclampd -- ^ @zmin@ of type @ClampedFloat64@.
  -> GLclampd -- ^ @zmax@ of type @ClampedFloat64@.
  -> m ()
glDepthBoundsEXT v1 v2 = liftIO $ dyn_glDepthBoundsEXT ptr_glDepthBoundsEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthBoundsEXT
  :: FunPtr (GLclampd -> GLclampd -> IO ())
  ->         GLclampd -> GLclampd -> IO ()

{-# NOINLINE ptr_glDepthBoundsEXT #-}
ptr_glDepthBoundsEXT :: FunPtr (GLclampd -> GLclampd -> IO ())
ptr_glDepthBoundsEXT = unsafePerformIO $ getCommand "glDepthBoundsEXT"

-- glDepthBoundsdNV ------------------------------------------------------------

glDepthBoundsdNV
  :: MonadIO m
  => GLdouble -- ^ @zmin@.
  -> GLdouble -- ^ @zmax@.
  -> m ()
glDepthBoundsdNV v1 v2 = liftIO $ dyn_glDepthBoundsdNV ptr_glDepthBoundsdNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthBoundsdNV
  :: FunPtr (GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glDepthBoundsdNV #-}
ptr_glDepthBoundsdNV :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthBoundsdNV = unsafePerformIO $ getCommand "glDepthBoundsdNV"

-- glDepthFunc -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthFunc.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthFunc.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthFunc.xhtml OpenGL 4.x>
glDepthFunc
  :: MonadIO m
  => GLenum -- ^ @func@ of type @DepthFunction@.
  -> m ()
glDepthFunc v1 = liftIO $ dyn_glDepthFunc ptr_glDepthFunc v1

foreign import CALLCONV "dynamic" dyn_glDepthFunc
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glDepthFunc #-}
ptr_glDepthFunc :: FunPtr (GLenum -> IO ())
ptr_glDepthFunc = unsafePerformIO $ getCommand "glDepthFunc"

-- glDepthMask -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthMask.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthMask.xhtml OpenGL 4.x>
glDepthMask
  :: MonadIO m
  => GLboolean -- ^ @flag@ of type @Boolean@.
  -> m ()
glDepthMask v1 = liftIO $ dyn_glDepthMask ptr_glDepthMask v1

foreign import CALLCONV "dynamic" dyn_glDepthMask
  :: FunPtr (GLboolean -> IO ())
  ->         GLboolean -> IO ()

{-# NOINLINE ptr_glDepthMask #-}
ptr_glDepthMask :: FunPtr (GLboolean -> IO ())
ptr_glDepthMask = unsafePerformIO $ getCommand "glDepthMask"

-- glDepthRange ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthRange.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthRange.xhtml OpenGL 4.x>
glDepthRange
  :: MonadIO m
  => GLdouble -- ^ @near@.
  -> GLdouble -- ^ @far@.
  -> m ()
glDepthRange v1 v2 = liftIO $ dyn_glDepthRange ptr_glDepthRange v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRange
  :: FunPtr (GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glDepthRange #-}
ptr_glDepthRange :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthRange = unsafePerformIO $ getCommand "glDepthRange"

-- glDepthRangeArrayfvNV -------------------------------------------------------

glDepthRangeArrayfvNV
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glDepthRangeArrayfvNV v1 v2 v3 = liftIO $ dyn_glDepthRangeArrayfvNV ptr_glDepthRangeArrayfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDepthRangeArrayfvNV
  :: FunPtr (GLuint -> GLsizei -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glDepthRangeArrayfvNV #-}
ptr_glDepthRangeArrayfvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glDepthRangeArrayfvNV = unsafePerformIO $ getCommand "glDepthRangeArrayfvNV"

-- glDepthRangeArrayv ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRangeArray.xhtml OpenGL 4.x>
glDepthRangeArrayv
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLdouble -- ^ @v@ pointing to @COMPSIZE(count)@ elements of type @GLdouble@.
  -> m ()
glDepthRangeArrayv v1 v2 v3 = liftIO $ dyn_glDepthRangeArrayv ptr_glDepthRangeArrayv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDepthRangeArrayv
  :: FunPtr (GLuint -> GLsizei -> Ptr GLdouble -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glDepthRangeArrayv #-}
ptr_glDepthRangeArrayv :: FunPtr (GLuint -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glDepthRangeArrayv = unsafePerformIO $ getCommand "glDepthRangeArrayv"

-- glDepthRangeIndexed ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRangeIndexed.xhtml OpenGL 4.x>
glDepthRangeIndexed
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLdouble -- ^ @n@.
  -> GLdouble -- ^ @f@.
  -> m ()
glDepthRangeIndexed v1 v2 v3 = liftIO $ dyn_glDepthRangeIndexed ptr_glDepthRangeIndexed v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDepthRangeIndexed
  :: FunPtr (GLuint -> GLdouble -> GLdouble -> IO ())
  ->         GLuint -> GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glDepthRangeIndexed #-}
ptr_glDepthRangeIndexed :: FunPtr (GLuint -> GLdouble -> GLdouble -> IO ())
ptr_glDepthRangeIndexed = unsafePerformIO $ getCommand "glDepthRangeIndexed"

-- glDepthRangeIndexedfNV ------------------------------------------------------

glDepthRangeIndexedfNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glDepthRangeIndexedfNV v1 v2 v3 = liftIO $ dyn_glDepthRangeIndexedfNV ptr_glDepthRangeIndexedfNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDepthRangeIndexedfNV
  :: FunPtr (GLuint -> GLfloat -> GLfloat -> IO ())
  ->         GLuint -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glDepthRangeIndexedfNV #-}
ptr_glDepthRangeIndexedfNV :: FunPtr (GLuint -> GLfloat -> GLfloat -> IO ())
ptr_glDepthRangeIndexedfNV = unsafePerformIO $ getCommand "glDepthRangeIndexedfNV"

-- glDepthRangedNV -------------------------------------------------------------

glDepthRangedNV
  :: MonadIO m
  => GLdouble -- ^ @zNear@.
  -> GLdouble -- ^ @zFar@.
  -> m ()
glDepthRangedNV v1 v2 = liftIO $ dyn_glDepthRangedNV ptr_glDepthRangedNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRangedNV
  :: FunPtr (GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glDepthRangedNV #-}
ptr_glDepthRangedNV :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthRangedNV = unsafePerformIO $ getCommand "glDepthRangedNV"

-- glDepthRangef ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRange.xhtml OpenGL 4.x>
glDepthRangef
  :: MonadIO m
  => GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glDepthRangef v1 v2 = liftIO $ dyn_glDepthRangef ptr_glDepthRangef v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRangef
  :: FunPtr (GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glDepthRangef #-}
ptr_glDepthRangef :: FunPtr (GLfloat -> GLfloat -> IO ())
ptr_glDepthRangef = unsafePerformIO $ getCommand "glDepthRangef"

-- glDepthRangefOES ------------------------------------------------------------

glDepthRangefOES
  :: MonadIO m
  => GLclampf -- ^ @n@ of type @ClampedFloat32@.
  -> GLclampf -- ^ @f@ of type @ClampedFloat32@.
  -> m ()
glDepthRangefOES v1 v2 = liftIO $ dyn_glDepthRangefOES ptr_glDepthRangefOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRangefOES
  :: FunPtr (GLclampf -> GLclampf -> IO ())
  ->         GLclampf -> GLclampf -> IO ()

{-# NOINLINE ptr_glDepthRangefOES #-}
ptr_glDepthRangefOES :: FunPtr (GLclampf -> GLclampf -> IO ())
ptr_glDepthRangefOES = unsafePerformIO $ getCommand "glDepthRangefOES"

-- glDepthRangex ---------------------------------------------------------------

glDepthRangex
  :: MonadIO m
  => GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glDepthRangex v1 v2 = liftIO $ dyn_glDepthRangex ptr_glDepthRangex v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRangex
  :: FunPtr (GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glDepthRangex #-}
ptr_glDepthRangex :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glDepthRangex = unsafePerformIO $ getCommand "glDepthRangex"

-- glDepthRangexOES ------------------------------------------------------------

glDepthRangexOES
  :: MonadIO m
  => GLfixed -- ^ @n@ of type @ClampedFixed@.
  -> GLfixed -- ^ @f@ of type @ClampedFixed@.
  -> m ()
glDepthRangexOES v1 v2 = liftIO $ dyn_glDepthRangexOES ptr_glDepthRangexOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDepthRangexOES
  :: FunPtr (GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glDepthRangexOES #-}
ptr_glDepthRangexOES :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glDepthRangexOES = unsafePerformIO $ getCommand "glDepthRangexOES"

-- glDetachObjectARB -----------------------------------------------------------

glDetachObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLhandleARB -- ^ @attachedObj@ of type @handleARB@.
  -> m ()
glDetachObjectARB v1 v2 = liftIO $ dyn_glDetachObjectARB ptr_glDetachObjectARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDetachObjectARB
  :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
  ->         GLhandleARB -> GLhandleARB -> IO ()

{-# NOINLINE ptr_glDetachObjectARB #-}
ptr_glDetachObjectARB :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
ptr_glDetachObjectARB = unsafePerformIO $ getCommand "glDetachObjectARB"

-- glDetachShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDetachShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDetachShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDetachShader.xhtml OpenGL 4.x>
glDetachShader
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @shader@.
  -> m ()
glDetachShader v1 v2 = liftIO $ dyn_glDetachShader ptr_glDetachShader v1 v2

foreign import CALLCONV "dynamic" dyn_glDetachShader
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDetachShader #-}
ptr_glDetachShader :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDetachShader = unsafePerformIO $ getCommand "glDetachShader"

-- glDetailTexFuncSGIS ---------------------------------------------------------

glDetailTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @points@ pointing to @n*2@ elements of type @GLfloat@.
  -> m ()
glDetailTexFuncSGIS v1 v2 v3 = liftIO $ dyn_glDetailTexFuncSGIS ptr_glDetailTexFuncSGIS v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDetailTexFuncSGIS
  :: FunPtr (GLenum -> GLsizei -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glDetailTexFuncSGIS #-}
ptr_glDetailTexFuncSGIS :: FunPtr (GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glDetailTexFuncSGIS = unsafePerformIO $ getCommand "glDetailTexFuncSGIS"

-- glDisable -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>
glDisable
  :: MonadIO m
  => GLenum -- ^ @cap@ of type @EnableCap@.
  -> m ()
glDisable v1 = liftIO $ dyn_glDisable ptr_glDisable v1

foreign import CALLCONV "dynamic" dyn_glDisable
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glDisable #-}
ptr_glDisable :: FunPtr (GLenum -> IO ())
ptr_glDisable = unsafePerformIO $ getCommand "glDisable"

-- glDisableClientState --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableClientState.xml OpenGL 2.x>
glDisableClientState
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> m ()
glDisableClientState v1 = liftIO $ dyn_glDisableClientState ptr_glDisableClientState v1

foreign import CALLCONV "dynamic" dyn_glDisableClientState
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glDisableClientState #-}
ptr_glDisableClientState :: FunPtr (GLenum -> IO ())
ptr_glDisableClientState = unsafePerformIO $ getCommand "glDisableClientState"

-- glDisableClientStateIndexedEXT ----------------------------------------------

glDisableClientStateIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableClientStateIndexedEXT v1 v2 = liftIO $ dyn_glDisableClientStateIndexedEXT ptr_glDisableClientStateIndexedEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableClientStateIndexedEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableClientStateIndexedEXT #-}
ptr_glDisableClientStateIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableClientStateIndexedEXT = unsafePerformIO $ getCommand "glDisableClientStateIndexedEXT"

-- glDisableClientStateiEXT ----------------------------------------------------

glDisableClientStateiEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableClientStateiEXT v1 v2 = liftIO $ dyn_glDisableClientStateiEXT ptr_glDisableClientStateiEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableClientStateiEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableClientStateiEXT #-}
ptr_glDisableClientStateiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableClientStateiEXT = unsafePerformIO $ getCommand "glDisableClientStateiEXT"

-- glDisableDriverControlQCOM --------------------------------------------------

glDisableDriverControlQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> m ()
glDisableDriverControlQCOM v1 = liftIO $ dyn_glDisableDriverControlQCOM ptr_glDisableDriverControlQCOM v1

foreign import CALLCONV "dynamic" dyn_glDisableDriverControlQCOM
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDisableDriverControlQCOM #-}
ptr_glDisableDriverControlQCOM :: FunPtr (GLuint -> IO ())
ptr_glDisableDriverControlQCOM = unsafePerformIO $ getCommand "glDisableDriverControlQCOM"

-- glDisableIndexedEXT ---------------------------------------------------------

glDisableIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableIndexedEXT v1 v2 = liftIO $ dyn_glDisableIndexedEXT ptr_glDisableIndexedEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableIndexedEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableIndexedEXT #-}
ptr_glDisableIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableIndexedEXT = unsafePerformIO $ getCommand "glDisableIndexedEXT"

-- glDisableVariantClientStateEXT ----------------------------------------------

glDisableVariantClientStateEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDisableVariantClientStateEXT v1 = liftIO $ dyn_glDisableVariantClientStateEXT ptr_glDisableVariantClientStateEXT v1

foreign import CALLCONV "dynamic" dyn_glDisableVariantClientStateEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDisableVariantClientStateEXT #-}
ptr_glDisableVariantClientStateEXT :: FunPtr (GLuint -> IO ())
ptr_glDisableVariantClientStateEXT = unsafePerformIO $ getCommand "glDisableVariantClientStateEXT"

-- glDisableVertexArrayAttrib --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>
glDisableVertexArrayAttrib
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableVertexArrayAttrib v1 v2 = liftIO $ dyn_glDisableVertexArrayAttrib ptr_glDisableVertexArrayAttrib v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableVertexArrayAttrib
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableVertexArrayAttrib #-}
ptr_glDisableVertexArrayAttrib :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDisableVertexArrayAttrib = unsafePerformIO $ getCommand "glDisableVertexArrayAttrib"

-- glDisableVertexArrayAttribEXT -----------------------------------------------

glDisableVertexArrayAttribEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableVertexArrayAttribEXT v1 v2 = liftIO $ dyn_glDisableVertexArrayAttribEXT ptr_glDisableVertexArrayAttribEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableVertexArrayAttribEXT
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableVertexArrayAttribEXT #-}
ptr_glDisableVertexArrayAttribEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDisableVertexArrayAttribEXT = unsafePerformIO $ getCommand "glDisableVertexArrayAttribEXT"

-- glDisableVertexArrayEXT -----------------------------------------------------

glDisableVertexArrayEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @array@ of type @EnableCap@.
  -> m ()
glDisableVertexArrayEXT v1 v2 = liftIO $ dyn_glDisableVertexArrayEXT ptr_glDisableVertexArrayEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableVertexArrayEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glDisableVertexArrayEXT #-}
ptr_glDisableVertexArrayEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glDisableVertexArrayEXT = unsafePerformIO $ getCommand "glDisableVertexArrayEXT"

-- glDisableVertexAttribAPPLE --------------------------------------------------

glDisableVertexAttribAPPLE
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> m ()
glDisableVertexAttribAPPLE v1 v2 = liftIO $ dyn_glDisableVertexAttribAPPLE ptr_glDisableVertexAttribAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableVertexAttribAPPLE
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glDisableVertexAttribAPPLE #-}
ptr_glDisableVertexAttribAPPLE :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glDisableVertexAttribAPPLE = unsafePerformIO $ getCommand "glDisableVertexAttribAPPLE"

-- glDisableVertexAttribArray --------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableVertexAttribArray.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnableVertexAttribArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>
glDisableVertexAttribArray
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glDisableVertexAttribArray v1 = liftIO $ dyn_glDisableVertexAttribArray ptr_glDisableVertexAttribArray v1

foreign import CALLCONV "dynamic" dyn_glDisableVertexAttribArray
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDisableVertexAttribArray #-}
ptr_glDisableVertexAttribArray :: FunPtr (GLuint -> IO ())
ptr_glDisableVertexAttribArray = unsafePerformIO $ getCommand "glDisableVertexAttribArray"

-- glDisableVertexAttribArrayARB -----------------------------------------------

glDisableVertexAttribArrayARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glDisableVertexAttribArrayARB v1 = liftIO $ dyn_glDisableVertexAttribArrayARB ptr_glDisableVertexAttribArrayARB v1

foreign import CALLCONV "dynamic" dyn_glDisableVertexAttribArrayARB
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glDisableVertexAttribArrayARB #-}
ptr_glDisableVertexAttribArrayARB :: FunPtr (GLuint -> IO ())
ptr_glDisableVertexAttribArrayARB = unsafePerformIO $ getCommand "glDisableVertexAttribArrayARB"

-- glDisablei ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>
glDisablei
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisablei v1 v2 = liftIO $ dyn_glDisablei ptr_glDisablei v1 v2

foreign import CALLCONV "dynamic" dyn_glDisablei
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisablei #-}
ptr_glDisablei :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisablei = unsafePerformIO $ getCommand "glDisablei"

-- glDisableiEXT ---------------------------------------------------------------

glDisableiEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiEXT v1 v2 = liftIO $ dyn_glDisableiEXT ptr_glDisableiEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableiEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableiEXT #-}
ptr_glDisableiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiEXT = unsafePerformIO $ getCommand "glDisableiEXT"

-- glDisableiNV ----------------------------------------------------------------

glDisableiNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiNV v1 v2 = liftIO $ dyn_glDisableiNV ptr_glDisableiNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableiNV
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableiNV #-}
ptr_glDisableiNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiNV = unsafePerformIO $ getCommand "glDisableiNV"

-- glDisableiOES ---------------------------------------------------------------

glDisableiOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiOES v1 v2 = liftIO $ dyn_glDisableiOES ptr_glDisableiOES v1 v2

foreign import CALLCONV "dynamic" dyn_glDisableiOES
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDisableiOES #-}
ptr_glDisableiOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiOES = unsafePerformIO $ getCommand "glDisableiOES"

-- glDiscardFramebufferEXT -----------------------------------------------------

glDiscardFramebufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@ pointing to @numAttachments@ elements of type @GLenum@.
  -> m ()
glDiscardFramebufferEXT v1 v2 v3 = liftIO $ dyn_glDiscardFramebufferEXT ptr_glDiscardFramebufferEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDiscardFramebufferEXT
  :: FunPtr (GLenum -> GLsizei -> Ptr GLenum -> IO ())
  ->         GLenum -> GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDiscardFramebufferEXT #-}
ptr_glDiscardFramebufferEXT :: FunPtr (GLenum -> GLsizei -> Ptr GLenum -> IO ())
ptr_glDiscardFramebufferEXT = unsafePerformIO $ getCommand "glDiscardFramebufferEXT"

-- glDispatchCompute -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDispatchCompute.xhtml OpenGL 4.x>
glDispatchCompute
  :: MonadIO m
  => GLuint -- ^ @num_groups_x@.
  -> GLuint -- ^ @num_groups_y@.
  -> GLuint -- ^ @num_groups_z@.
  -> m ()
glDispatchCompute v1 v2 v3 = liftIO $ dyn_glDispatchCompute ptr_glDispatchCompute v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDispatchCompute
  :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDispatchCompute #-}
ptr_glDispatchCompute :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glDispatchCompute = unsafePerformIO $ getCommand "glDispatchCompute"

-- glDispatchComputeGroupSizeARB -----------------------------------------------

glDispatchComputeGroupSizeARB
  :: MonadIO m
  => GLuint -- ^ @num_groups_x@.
  -> GLuint -- ^ @num_groups_y@.
  -> GLuint -- ^ @num_groups_z@.
  -> GLuint -- ^ @group_size_x@.
  -> GLuint -- ^ @group_size_y@.
  -> GLuint -- ^ @group_size_z@.
  -> m ()
glDispatchComputeGroupSizeARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDispatchComputeGroupSizeARB ptr_glDispatchComputeGroupSizeARB v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDispatchComputeGroupSizeARB
  :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDispatchComputeGroupSizeARB #-}
ptr_glDispatchComputeGroupSizeARB :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glDispatchComputeGroupSizeARB = unsafePerformIO $ getCommand "glDispatchComputeGroupSizeARB"

-- glDispatchComputeIndirect ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDispatchComputeIndirect.xhtml OpenGL 4.x>
glDispatchComputeIndirect
  :: MonadIO m
  => GLintptr -- ^ @indirect@ of type @BufferOffset@.
  -> m ()
glDispatchComputeIndirect v1 = liftIO $ dyn_glDispatchComputeIndirect ptr_glDispatchComputeIndirect v1

foreign import CALLCONV "dynamic" dyn_glDispatchComputeIndirect
  :: FunPtr (GLintptr -> IO ())
  ->         GLintptr -> IO ()

{-# NOINLINE ptr_glDispatchComputeIndirect #-}
ptr_glDispatchComputeIndirect :: FunPtr (GLintptr -> IO ())
ptr_glDispatchComputeIndirect = unsafePerformIO $ getCommand "glDispatchComputeIndirect"

-- glDrawArrays ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawArrays.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawArrays.xhtml OpenGL 4.x>
glDrawArrays
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawArrays v1 v2 v3 = liftIO $ dyn_glDrawArrays ptr_glDrawArrays v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawArrays
  :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArrays #-}
ptr_glDrawArrays :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawArrays = unsafePerformIO $ getCommand "glDrawArrays"

-- glDrawArraysEXT -------------------------------------------------------------

glDrawArraysEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawArraysEXT v1 v2 v3 = liftIO $ dyn_glDrawArraysEXT ptr_glDrawArraysEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawArraysEXT
  :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysEXT #-}
ptr_glDrawArraysEXT :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawArraysEXT = unsafePerformIO $ getCommand "glDrawArraysEXT"

-- glDrawArraysIndirect --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysIndirect.xhtml OpenGL 4.x>
glDrawArraysIndirect
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> Ptr a -- ^ @indirect@.
  -> m ()
glDrawArraysIndirect v1 v2 = liftIO $ dyn_glDrawArraysIndirect ptr_glDrawArraysIndirect v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawArraysIndirect
  :: FunPtr (GLenum -> Ptr a -> IO ())
  ->         GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawArraysIndirect #-}
ptr_glDrawArraysIndirect :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glDrawArraysIndirect = unsafePerformIO $ getCommand "glDrawArraysIndirect"

-- glDrawArraysInstanced -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArraysInstanced.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysInstanced.xhtml OpenGL 4.x>
glDrawArraysInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawArraysInstanced v1 v2 v3 v4 = liftIO $ dyn_glDrawArraysInstanced ptr_glDrawArraysInstanced v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstanced
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysInstanced #-}
ptr_glDrawArraysInstanced :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstanced = unsafePerformIO $ getCommand "glDrawArraysInstanced"

-- glDrawArraysInstancedANGLE --------------------------------------------------

glDrawArraysInstancedANGLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedANGLE v1 v2 v3 v4 = liftIO $ dyn_glDrawArraysInstancedANGLE ptr_glDrawArraysInstancedANGLE v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedANGLE
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedANGLE #-}
ptr_glDrawArraysInstancedANGLE :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedANGLE = unsafePerformIO $ getCommand "glDrawArraysInstancedANGLE"

-- glDrawArraysInstancedARB ----------------------------------------------------

glDrawArraysInstancedARB
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedARB v1 v2 v3 v4 = liftIO $ dyn_glDrawArraysInstancedARB ptr_glDrawArraysInstancedARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedARB
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedARB #-}
ptr_glDrawArraysInstancedARB :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedARB = unsafePerformIO $ getCommand "glDrawArraysInstancedARB"

-- glDrawArraysInstancedBaseInstance -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysInstancedBaseInstance.xhtml OpenGL 4.x>
glDrawArraysInstancedBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawArraysInstancedBaseInstance v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawArraysInstancedBaseInstance ptr_glDrawArraysInstancedBaseInstance v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedBaseInstance
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedBaseInstance #-}
ptr_glDrawArraysInstancedBaseInstance :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
ptr_glDrawArraysInstancedBaseInstance = unsafePerformIO $ getCommand "glDrawArraysInstancedBaseInstance"

-- glDrawArraysInstancedBaseInstanceEXT ----------------------------------------

glDrawArraysInstancedBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawArraysInstancedBaseInstanceEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawArraysInstancedBaseInstanceEXT ptr_glDrawArraysInstancedBaseInstanceEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedBaseInstanceEXT
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedBaseInstanceEXT #-}
ptr_glDrawArraysInstancedBaseInstanceEXT :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
ptr_glDrawArraysInstancedBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawArraysInstancedBaseInstanceEXT"

-- glDrawArraysInstancedEXT ----------------------------------------------------

glDrawArraysInstancedEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedEXT v1 v2 v3 v4 = liftIO $ dyn_glDrawArraysInstancedEXT ptr_glDrawArraysInstancedEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedEXT
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedEXT #-}
ptr_glDrawArraysInstancedEXT :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedEXT = unsafePerformIO $ getCommand "glDrawArraysInstancedEXT"

-- glDrawArraysInstancedNV -----------------------------------------------------

glDrawArraysInstancedNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedNV v1 v2 v3 v4 = liftIO $ dyn_glDrawArraysInstancedNV ptr_glDrawArraysInstancedNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawArraysInstancedNV
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawArraysInstancedNV #-}
ptr_glDrawArraysInstancedNV :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedNV = unsafePerformIO $ getCommand "glDrawArraysInstancedNV"

-- glDrawBuffer ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawBuffer.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawBuffer.xhtml OpenGL 4.x>
glDrawBuffer
  :: MonadIO m
  => GLenum -- ^ @buf@ of type @DrawBufferMode@.
  -> m ()
glDrawBuffer v1 = liftIO $ dyn_glDrawBuffer ptr_glDrawBuffer v1

foreign import CALLCONV "dynamic" dyn_glDrawBuffer
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffer #-}
ptr_glDrawBuffer :: FunPtr (GLenum -> IO ())
ptr_glDrawBuffer = unsafePerformIO $ getCommand "glDrawBuffer"

-- glDrawBuffers ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawBuffers.xhtml OpenGL 4.x>
glDrawBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffers v1 v2 = liftIO $ dyn_glDrawBuffers ptr_glDrawBuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawBuffers
  :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
  ->         GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffers #-}
ptr_glDrawBuffers :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffers = unsafePerformIO $ getCommand "glDrawBuffers"

-- glDrawBuffersARB ------------------------------------------------------------

glDrawBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffersARB v1 v2 = liftIO $ dyn_glDrawBuffersARB ptr_glDrawBuffersARB v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawBuffersARB
  :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
  ->         GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffersARB #-}
ptr_glDrawBuffersARB :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersARB = unsafePerformIO $ getCommand "glDrawBuffersARB"

-- glDrawBuffersATI ------------------------------------------------------------

glDrawBuffersATI
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffersATI v1 v2 = liftIO $ dyn_glDrawBuffersATI ptr_glDrawBuffersATI v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawBuffersATI
  :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
  ->         GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffersATI #-}
ptr_glDrawBuffersATI :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersATI = unsafePerformIO $ getCommand "glDrawBuffersATI"

-- glDrawBuffersEXT ------------------------------------------------------------

glDrawBuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@.
  -> m ()
glDrawBuffersEXT v1 v2 = liftIO $ dyn_glDrawBuffersEXT ptr_glDrawBuffersEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawBuffersEXT
  :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
  ->         GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffersEXT #-}
ptr_glDrawBuffersEXT :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersEXT = unsafePerformIO $ getCommand "glDrawBuffersEXT"

-- glDrawBuffersIndexedEXT -----------------------------------------------------

glDrawBuffersIndexedEXT
  :: MonadIO m
  => GLint -- ^ @n@.
  -> Ptr GLenum -- ^ @location@ pointing to @n@ elements of type @GLenum@.
  -> Ptr GLint -- ^ @indices@ pointing to @n@ elements of type @GLint@.
  -> m ()
glDrawBuffersIndexedEXT v1 v2 v3 = liftIO $ dyn_glDrawBuffersIndexedEXT ptr_glDrawBuffersIndexedEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawBuffersIndexedEXT
  :: FunPtr (GLint -> Ptr GLenum -> Ptr GLint -> IO ())
  ->         GLint -> Ptr GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glDrawBuffersIndexedEXT #-}
ptr_glDrawBuffersIndexedEXT :: FunPtr (GLint -> Ptr GLenum -> Ptr GLint -> IO ())
ptr_glDrawBuffersIndexedEXT = unsafePerformIO $ getCommand "glDrawBuffersIndexedEXT"

-- glDrawBuffersNV -------------------------------------------------------------

glDrawBuffersNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @GLenum@.
  -> m ()
glDrawBuffersNV v1 v2 = liftIO $ dyn_glDrawBuffersNV ptr_glDrawBuffersNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawBuffersNV
  :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
  ->         GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glDrawBuffersNV #-}
ptr_glDrawBuffersNV :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersNV = unsafePerformIO $ getCommand "glDrawBuffersNV"

-- glDrawElementArrayAPPLE -----------------------------------------------------

glDrawElementArrayAPPLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawElementArrayAPPLE v1 v2 v3 = liftIO $ dyn_glDrawElementArrayAPPLE ptr_glDrawElementArrayAPPLE v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawElementArrayAPPLE
  :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementArrayAPPLE #-}
ptr_glDrawElementArrayAPPLE :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawElementArrayAPPLE = unsafePerformIO $ getCommand "glDrawElementArrayAPPLE"

-- glDrawElementArrayATI -------------------------------------------------------

glDrawElementArrayATI
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawElementArrayATI v1 v2 = liftIO $ dyn_glDrawElementArrayATI ptr_glDrawElementArrayATI v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawElementArrayATI
  :: FunPtr (GLenum -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementArrayATI #-}
ptr_glDrawElementArrayATI :: FunPtr (GLenum -> GLsizei -> IO ())
ptr_glDrawElementArrayATI = unsafePerformIO $ getCommand "glDrawElementArrayATI"

-- glDrawElements --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawElements.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElements.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElements.xhtml OpenGL 4.x>
glDrawElements
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawElements v1 v2 v3 v4 = liftIO $ dyn_glDrawElements ptr_glDrawElements v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawElements
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawElements #-}
ptr_glDrawElements :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawElements = unsafePerformIO $ getCommand "glDrawElements"

-- glDrawElementsBaseVertex ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsBaseVertex.xhtml OpenGL 4.x>
glDrawElementsBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertex v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsBaseVertex ptr_glDrawElementsBaseVertex v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsBaseVertex
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsBaseVertex #-}
ptr_glDrawElementsBaseVertex :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertex = unsafePerformIO $ getCommand "glDrawElementsBaseVertex"

-- glDrawElementsBaseVertexEXT -------------------------------------------------

glDrawElementsBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertexEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsBaseVertexEXT ptr_glDrawElementsBaseVertexEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsBaseVertexEXT
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsBaseVertexEXT #-}
ptr_glDrawElementsBaseVertexEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertexEXT = unsafePerformIO $ getCommand "glDrawElementsBaseVertexEXT"

-- glDrawElementsBaseVertexOES -------------------------------------------------

glDrawElementsBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertexOES v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsBaseVertexOES ptr_glDrawElementsBaseVertexOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsBaseVertexOES
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsBaseVertexOES #-}
ptr_glDrawElementsBaseVertexOES :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertexOES = unsafePerformIO $ getCommand "glDrawElementsBaseVertexOES"

-- glDrawElementsIndirect ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsIndirect.xhtml OpenGL 4.x>
glDrawElementsIndirect
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indirect@.
  -> m ()
glDrawElementsIndirect v1 v2 v3 = liftIO $ dyn_glDrawElementsIndirect ptr_glDrawElementsIndirect v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawElementsIndirect
  :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawElementsIndirect #-}
ptr_glDrawElementsIndirect :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
ptr_glDrawElementsIndirect = unsafePerformIO $ getCommand "glDrawElementsIndirect"

-- glDrawElementsInstanced -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstanced.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstanced.xhtml OpenGL 4.x>
glDrawElementsInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawElementsInstanced v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsInstanced ptr_glDrawElementsInstanced v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstanced
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementsInstanced #-}
ptr_glDrawElementsInstanced :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstanced = unsafePerformIO $ getCommand "glDrawElementsInstanced"

-- glDrawElementsInstancedANGLE ------------------------------------------------

glDrawElementsInstancedANGLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedANGLE v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsInstancedANGLE ptr_glDrawElementsInstancedANGLE v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedANGLE
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedANGLE #-}
ptr_glDrawElementsInstancedANGLE :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedANGLE = unsafePerformIO $ getCommand "glDrawElementsInstancedANGLE"

-- glDrawElementsInstancedARB --------------------------------------------------

glDrawElementsInstancedARB
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedARB v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsInstancedARB ptr_glDrawElementsInstancedARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedARB
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedARB #-}
ptr_glDrawElementsInstancedARB :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedARB = unsafePerformIO $ getCommand "glDrawElementsInstancedARB"

-- glDrawElementsInstancedBaseInstance -----------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseInstance.xhtml OpenGL 4.x>
glDrawElementsInstancedBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseInstance v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawElementsInstancedBaseInstance ptr_glDrawElementsInstancedBaseInstance v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseInstance
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseInstance #-}
ptr_glDrawElementsInstancedBaseInstance :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseInstance = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseInstance"

-- glDrawElementsInstancedBaseInstanceEXT --------------------------------------

glDrawElementsInstancedBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseInstanceEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawElementsInstancedBaseInstanceEXT ptr_glDrawElementsInstancedBaseInstanceEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseInstanceEXT
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseInstanceEXT #-}
ptr_glDrawElementsInstancedBaseInstanceEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseInstanceEXT"

-- glDrawElementsInstancedBaseVertex -------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstancedBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseVertex.xhtml OpenGL 4.x>
glDrawElementsInstancedBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertex v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawElementsInstancedBaseVertex ptr_glDrawElementsInstancedBaseVertex v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseVertex
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertex #-}
ptr_glDrawElementsInstancedBaseVertex :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertex = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertex"

-- glDrawElementsInstancedBaseVertexBaseInstance -------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseVertexBaseInstance.xhtml OpenGL 4.x>
glDrawElementsInstancedBaseVertexBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseVertexBaseInstance v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glDrawElementsInstancedBaseVertexBaseInstance ptr_glDrawElementsInstancedBaseVertexBaseInstance v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseVertexBaseInstance
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexBaseInstance #-}
ptr_glDrawElementsInstancedBaseVertexBaseInstance :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseVertexBaseInstance = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexBaseInstance"

-- glDrawElementsInstancedBaseVertexBaseInstanceEXT ----------------------------

glDrawElementsInstancedBaseVertexBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseVertexBaseInstanceEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glDrawElementsInstancedBaseVertexBaseInstanceEXT ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseVertexBaseInstanceEXT
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT #-}
ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexBaseInstanceEXT"

-- glDrawElementsInstancedBaseVertexEXT ----------------------------------------

glDrawElementsInstancedBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertexEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawElementsInstancedBaseVertexEXT ptr_glDrawElementsInstancedBaseVertexEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseVertexEXT
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexEXT #-}
ptr_glDrawElementsInstancedBaseVertexEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertexEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexEXT"

-- glDrawElementsInstancedBaseVertexOES ----------------------------------------

glDrawElementsInstancedBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertexOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawElementsInstancedBaseVertexOES ptr_glDrawElementsInstancedBaseVertexOES v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedBaseVertexOES
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexOES #-}
ptr_glDrawElementsInstancedBaseVertexOES :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertexOES = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexOES"

-- glDrawElementsInstancedEXT --------------------------------------------------

glDrawElementsInstancedEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsInstancedEXT ptr_glDrawElementsInstancedEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedEXT
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedEXT #-}
ptr_glDrawElementsInstancedEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedEXT"

-- glDrawElementsInstancedNV ---------------------------------------------------

glDrawElementsInstancedNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedNV v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawElementsInstancedNV ptr_glDrawElementsInstancedNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawElementsInstancedNV
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawElementsInstancedNV #-}
ptr_glDrawElementsInstancedNV :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedNV = unsafePerformIO $ getCommand "glDrawElementsInstancedNV"

-- glDrawMeshArraysSUN ---------------------------------------------------------

glDrawMeshArraysSUN
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @width@.
  -> m ()
glDrawMeshArraysSUN v1 v2 v3 v4 = liftIO $ dyn_glDrawMeshArraysSUN ptr_glDrawMeshArraysSUN v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawMeshArraysSUN
  :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
  ->         GLenum -> GLint -> GLsizei -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawMeshArraysSUN #-}
ptr_glDrawMeshArraysSUN :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawMeshArraysSUN = unsafePerformIO $ getCommand "glDrawMeshArraysSUN"

-- glDrawPixels ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawPixels.xml OpenGL 2.x>
glDrawPixels
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glDrawPixels v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawPixels ptr_glDrawPixels v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawPixels
  :: FunPtr (GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawPixels #-}
ptr_glDrawPixels :: FunPtr (GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glDrawPixels = unsafePerformIO $ getCommand "glDrawPixels"

-- glDrawRangeElementArrayAPPLE ------------------------------------------------

glDrawRangeElementArrayAPPLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawRangeElementArrayAPPLE v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawRangeElementArrayAPPLE ptr_glDrawRangeElementArrayAPPLE v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementArrayAPPLE
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawRangeElementArrayAPPLE #-}
ptr_glDrawRangeElementArrayAPPLE :: FunPtr (GLenum -> GLuint -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glDrawRangeElementArrayAPPLE = unsafePerformIO $ getCommand "glDrawRangeElementArrayAPPLE"

-- glDrawRangeElementArrayATI --------------------------------------------------

glDrawRangeElementArrayATI
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawRangeElementArrayATI v1 v2 v3 v4 = liftIO $ dyn_glDrawRangeElementArrayATI ptr_glDrawRangeElementArrayATI v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementArrayATI
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawRangeElementArrayATI #-}
ptr_glDrawRangeElementArrayATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
ptr_glDrawRangeElementArrayATI = unsafePerformIO $ getCommand "glDrawRangeElementArrayATI"

-- glDrawRangeElements ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawRangeElements.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElements.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawRangeElements.xhtml OpenGL 4.x>
glDrawRangeElements
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawRangeElements v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawRangeElements ptr_glDrawRangeElements v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawRangeElements
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawRangeElements #-}
ptr_glDrawRangeElements :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawRangeElements = unsafePerformIO $ getCommand "glDrawRangeElements"

-- glDrawRangeElementsBaseVertex -----------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElementsBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawRangeElementsBaseVertex.xhtml OpenGL 4.x>
glDrawRangeElementsBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertex v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glDrawRangeElementsBaseVertex ptr_glDrawRangeElementsBaseVertex v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementsBaseVertex
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawRangeElementsBaseVertex #-}
ptr_glDrawRangeElementsBaseVertex :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertex = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertex"

-- glDrawRangeElementsBaseVertexEXT --------------------------------------------

glDrawRangeElementsBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertexEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glDrawRangeElementsBaseVertexEXT ptr_glDrawRangeElementsBaseVertexEXT v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementsBaseVertexEXT
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawRangeElementsBaseVertexEXT #-}
ptr_glDrawRangeElementsBaseVertexEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertexEXT = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertexEXT"

-- glDrawRangeElementsBaseVertexOES --------------------------------------------

glDrawRangeElementsBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertexOES v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glDrawRangeElementsBaseVertexOES ptr_glDrawRangeElementsBaseVertexOES v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementsBaseVertexOES
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ()

{-# NOINLINE ptr_glDrawRangeElementsBaseVertexOES #-}
ptr_glDrawRangeElementsBaseVertexOES :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertexOES = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertexOES"

-- glDrawRangeElementsEXT ------------------------------------------------------

glDrawRangeElementsEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawRangeElementsEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glDrawRangeElementsEXT ptr_glDrawRangeElementsEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glDrawRangeElementsEXT
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glDrawRangeElementsEXT #-}
ptr_glDrawRangeElementsEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawRangeElementsEXT = unsafePerformIO $ getCommand "glDrawRangeElementsEXT"

-- glDrawTexfOES ---------------------------------------------------------------

glDrawTexfOES
  :: MonadIO m
  => GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> GLfloat -- ^ @width@.
  -> GLfloat -- ^ @height@.
  -> m ()
glDrawTexfOES v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawTexfOES ptr_glDrawTexfOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawTexfOES
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glDrawTexfOES #-}
ptr_glDrawTexfOES :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glDrawTexfOES = unsafePerformIO $ getCommand "glDrawTexfOES"

-- glDrawTexfvOES --------------------------------------------------------------

glDrawTexfvOES
  :: MonadIO m
  => Ptr GLfloat -- ^ @coords@.
  -> m ()
glDrawTexfvOES v1 = liftIO $ dyn_glDrawTexfvOES ptr_glDrawTexfvOES v1

foreign import CALLCONV "dynamic" dyn_glDrawTexfvOES
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glDrawTexfvOES #-}
ptr_glDrawTexfvOES :: FunPtr (Ptr GLfloat -> IO ())
ptr_glDrawTexfvOES = unsafePerformIO $ getCommand "glDrawTexfvOES"

-- glDrawTexiOES ---------------------------------------------------------------

glDrawTexiOES
  :: MonadIO m
  => GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLint -- ^ @z@.
  -> GLint -- ^ @width@.
  -> GLint -- ^ @height@.
  -> m ()
glDrawTexiOES v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawTexiOES ptr_glDrawTexiOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawTexiOES
  :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> IO ())
  ->         GLint -> GLint -> GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glDrawTexiOES #-}
ptr_glDrawTexiOES :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glDrawTexiOES = unsafePerformIO $ getCommand "glDrawTexiOES"

-- glDrawTexivOES --------------------------------------------------------------

glDrawTexivOES
  :: MonadIO m
  => Ptr GLint -- ^ @coords@.
  -> m ()
glDrawTexivOES v1 = liftIO $ dyn_glDrawTexivOES ptr_glDrawTexivOES v1

foreign import CALLCONV "dynamic" dyn_glDrawTexivOES
  :: FunPtr (Ptr GLint -> IO ())
  ->         Ptr GLint -> IO ()

{-# NOINLINE ptr_glDrawTexivOES #-}
ptr_glDrawTexivOES :: FunPtr (Ptr GLint -> IO ())
ptr_glDrawTexivOES = unsafePerformIO $ getCommand "glDrawTexivOES"

-- glDrawTexsOES ---------------------------------------------------------------

glDrawTexsOES
  :: MonadIO m
  => GLshort -- ^ @x@.
  -> GLshort -- ^ @y@.
  -> GLshort -- ^ @z@.
  -> GLshort -- ^ @width@.
  -> GLshort -- ^ @height@.
  -> m ()
glDrawTexsOES v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawTexsOES ptr_glDrawTexsOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawTexsOES
  :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> GLshort -> IO ())
  ->         GLshort -> GLshort -> GLshort -> GLshort -> GLshort -> IO ()

{-# NOINLINE ptr_glDrawTexsOES #-}
ptr_glDrawTexsOES :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> GLshort -> IO ())
ptr_glDrawTexsOES = unsafePerformIO $ getCommand "glDrawTexsOES"

-- glDrawTexsvOES --------------------------------------------------------------

glDrawTexsvOES
  :: MonadIO m
  => Ptr GLshort -- ^ @coords@.
  -> m ()
glDrawTexsvOES v1 = liftIO $ dyn_glDrawTexsvOES ptr_glDrawTexsvOES v1

foreign import CALLCONV "dynamic" dyn_glDrawTexsvOES
  :: FunPtr (Ptr GLshort -> IO ())
  ->         Ptr GLshort -> IO ()

{-# NOINLINE ptr_glDrawTexsvOES #-}
ptr_glDrawTexsvOES :: FunPtr (Ptr GLshort -> IO ())
ptr_glDrawTexsvOES = unsafePerformIO $ getCommand "glDrawTexsvOES"

-- glDrawTextureNV -------------------------------------------------------------

glDrawTextureNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLuint -- ^ @sampler@.
  -> GLfloat -- ^ @x0@.
  -> GLfloat -- ^ @y0@.
  -> GLfloat -- ^ @x1@.
  -> GLfloat -- ^ @y1@.
  -> GLfloat -- ^ @z@.
  -> GLfloat -- ^ @s0@.
  -> GLfloat -- ^ @t0@.
  -> GLfloat -- ^ @s1@.
  -> GLfloat -- ^ @t1@.
  -> m ()
glDrawTextureNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glDrawTextureNV ptr_glDrawTextureNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glDrawTextureNV
  :: FunPtr (GLuint -> GLuint -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLuint -> GLuint -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glDrawTextureNV #-}
ptr_glDrawTextureNV :: FunPtr (GLuint -> GLuint -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glDrawTextureNV = unsafePerformIO $ getCommand "glDrawTextureNV"

-- glDrawTexxOES ---------------------------------------------------------------

glDrawTexxOES
  :: MonadIO m
  => GLfixed -- ^ @x@.
  -> GLfixed -- ^ @y@.
  -> GLfixed -- ^ @z@.
  -> GLfixed -- ^ @width@.
  -> GLfixed -- ^ @height@.
  -> m ()
glDrawTexxOES v1 v2 v3 v4 v5 = liftIO $ dyn_glDrawTexxOES ptr_glDrawTexxOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glDrawTexxOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glDrawTexxOES #-}
ptr_glDrawTexxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glDrawTexxOES = unsafePerformIO $ getCommand "glDrawTexxOES"

-- glDrawTexxvOES --------------------------------------------------------------

glDrawTexxvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@.
  -> m ()
glDrawTexxvOES v1 = liftIO $ dyn_glDrawTexxvOES ptr_glDrawTexxvOES v1

foreign import CALLCONV "dynamic" dyn_glDrawTexxvOES
  :: FunPtr (Ptr GLfixed -> IO ())
  ->         Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glDrawTexxvOES #-}
ptr_glDrawTexxvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glDrawTexxvOES = unsafePerformIO $ getCommand "glDrawTexxvOES"

-- glDrawTransformFeedback -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedback.xhtml OpenGL 4.x>
glDrawTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @id@.
  -> m ()
glDrawTransformFeedback v1 v2 = liftIO $ dyn_glDrawTransformFeedback ptr_glDrawTransformFeedback v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawTransformFeedback
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawTransformFeedback #-}
ptr_glDrawTransformFeedback :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDrawTransformFeedback = unsafePerformIO $ getCommand "glDrawTransformFeedback"

-- glDrawTransformFeedbackInstanced --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackInstanced.xhtml OpenGL 4.x>
glDrawTransformFeedbackInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @id@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawTransformFeedbackInstanced v1 v2 v3 = liftIO $ dyn_glDrawTransformFeedbackInstanced ptr_glDrawTransformFeedbackInstanced v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawTransformFeedbackInstanced
  :: FunPtr (GLenum -> GLuint -> GLsizei -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawTransformFeedbackInstanced #-}
ptr_glDrawTransformFeedbackInstanced :: FunPtr (GLenum -> GLuint -> GLsizei -> IO ())
ptr_glDrawTransformFeedbackInstanced = unsafePerformIO $ getCommand "glDrawTransformFeedbackInstanced"

-- glDrawTransformFeedbackNV ---------------------------------------------------

glDrawTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @id@.
  -> m ()
glDrawTransformFeedbackNV v1 v2 = liftIO $ dyn_glDrawTransformFeedbackNV ptr_glDrawTransformFeedbackNV v1 v2

foreign import CALLCONV "dynamic" dyn_glDrawTransformFeedbackNV
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawTransformFeedbackNV #-}
ptr_glDrawTransformFeedbackNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDrawTransformFeedbackNV = unsafePerformIO $ getCommand "glDrawTransformFeedbackNV"

-- glDrawTransformFeedbackStream -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackStream.xhtml OpenGL 4.x>
glDrawTransformFeedbackStream
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @id@.
  -> GLuint -- ^ @stream@.
  -> m ()
glDrawTransformFeedbackStream v1 v2 v3 = liftIO $ dyn_glDrawTransformFeedbackStream ptr_glDrawTransformFeedbackStream v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glDrawTransformFeedbackStream
  :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
  ->         GLenum -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glDrawTransformFeedbackStream #-}
ptr_glDrawTransformFeedbackStream :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glDrawTransformFeedbackStream = unsafePerformIO $ getCommand "glDrawTransformFeedbackStream"

-- glDrawTransformFeedbackStreamInstanced --------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackStreamInstanced.xhtml OpenGL 4.x>
glDrawTransformFeedbackStreamInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @PrimitiveType@.
  -> GLuint -- ^ @id@.
  -> GLuint -- ^ @stream@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawTransformFeedbackStreamInstanced v1 v2 v3 v4 = liftIO $ dyn_glDrawTransformFeedbackStreamInstanced ptr_glDrawTransformFeedbackStreamInstanced v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glDrawTransformFeedbackStreamInstanced
  :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
  ->         GLenum -> GLuint -> GLuint -> GLsizei -> IO ()

{-# NOINLINE ptr_glDrawTransformFeedbackStreamInstanced #-}
ptr_glDrawTransformFeedbackStreamInstanced :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
ptr_glDrawTransformFeedbackStreamInstanced = unsafePerformIO $ getCommand "glDrawTransformFeedbackStreamInstanced"

-- glEGLImageTargetRenderbufferStorageOES --------------------------------------

glEGLImageTargetRenderbufferStorageOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLeglImageOES -- ^ @image@.
  -> m ()
glEGLImageTargetRenderbufferStorageOES v1 v2 = liftIO $ dyn_glEGLImageTargetRenderbufferStorageOES ptr_glEGLImageTargetRenderbufferStorageOES v1 v2

foreign import CALLCONV "dynamic" dyn_glEGLImageTargetRenderbufferStorageOES
  :: FunPtr (GLenum -> GLeglImageOES -> IO ())
  ->         GLenum -> GLeglImageOES -> IO ()

{-# NOINLINE ptr_glEGLImageTargetRenderbufferStorageOES #-}
ptr_glEGLImageTargetRenderbufferStorageOES :: FunPtr (GLenum -> GLeglImageOES -> IO ())
ptr_glEGLImageTargetRenderbufferStorageOES = unsafePerformIO $ getCommand "glEGLImageTargetRenderbufferStorageOES"

-- glEGLImageTargetTexture2DOES ------------------------------------------------

glEGLImageTargetTexture2DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLeglImageOES -- ^ @image@.
  -> m ()
glEGLImageTargetTexture2DOES v1 v2 = liftIO $ dyn_glEGLImageTargetTexture2DOES ptr_glEGLImageTargetTexture2DOES v1 v2

foreign import CALLCONV "dynamic" dyn_glEGLImageTargetTexture2DOES
  :: FunPtr (GLenum -> GLeglImageOES -> IO ())
  ->         GLenum -> GLeglImageOES -> IO ()

{-# NOINLINE ptr_glEGLImageTargetTexture2DOES #-}
ptr_glEGLImageTargetTexture2DOES :: FunPtr (GLenum -> GLeglImageOES -> IO ())
ptr_glEGLImageTargetTexture2DOES = unsafePerformIO $ getCommand "glEGLImageTargetTexture2DOES"

-- glEdgeFlag ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlag.xml OpenGL 2.x>
glEdgeFlag
  :: MonadIO m
  => GLboolean -- ^ @flag@ of type @Boolean@.
  -> m ()
glEdgeFlag v1 = liftIO $ dyn_glEdgeFlag ptr_glEdgeFlag v1

foreign import CALLCONV "dynamic" dyn_glEdgeFlag
  :: FunPtr (GLboolean -> IO ())
  ->         GLboolean -> IO ()

{-# NOINLINE ptr_glEdgeFlag #-}
ptr_glEdgeFlag :: FunPtr (GLboolean -> IO ())
ptr_glEdgeFlag = unsafePerformIO $ getCommand "glEdgeFlag"

-- glEdgeFlagFormatNV ----------------------------------------------------------

glEdgeFlagFormatNV
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> m ()
glEdgeFlagFormatNV v1 = liftIO $ dyn_glEdgeFlagFormatNV ptr_glEdgeFlagFormatNV v1

foreign import CALLCONV "dynamic" dyn_glEdgeFlagFormatNV
  :: FunPtr (GLsizei -> IO ())
  ->         GLsizei -> IO ()

{-# NOINLINE ptr_glEdgeFlagFormatNV #-}
ptr_glEdgeFlagFormatNV :: FunPtr (GLsizei -> IO ())
ptr_glEdgeFlagFormatNV = unsafePerformIO $ getCommand "glEdgeFlagFormatNV"

-- glEdgeFlagPointer -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlagPointer.xml OpenGL 2.x>
glEdgeFlagPointer
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(stride)@ elements of type @a@.
  -> m ()
glEdgeFlagPointer v1 v2 = liftIO $ dyn_glEdgeFlagPointer ptr_glEdgeFlagPointer v1 v2

foreign import CALLCONV "dynamic" dyn_glEdgeFlagPointer
  :: FunPtr (GLsizei -> Ptr a -> IO ())
  ->         GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glEdgeFlagPointer #-}
ptr_glEdgeFlagPointer :: FunPtr (GLsizei -> Ptr a -> IO ())
ptr_glEdgeFlagPointer = unsafePerformIO $ getCommand "glEdgeFlagPointer"

-- glEdgeFlagPointerEXT --------------------------------------------------------

glEdgeFlagPointerEXT
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLboolean -- ^ @pointer@ pointing to @COMPSIZE(stride,count)@ elements of type @Boolean@.
  -> m ()
glEdgeFlagPointerEXT v1 v2 v3 = liftIO $ dyn_glEdgeFlagPointerEXT ptr_glEdgeFlagPointerEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glEdgeFlagPointerEXT
  :: FunPtr (GLsizei -> GLsizei -> Ptr GLboolean -> IO ())
  ->         GLsizei -> GLsizei -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glEdgeFlagPointerEXT #-}
ptr_glEdgeFlagPointerEXT :: FunPtr (GLsizei -> GLsizei -> Ptr GLboolean -> IO ())
ptr_glEdgeFlagPointerEXT = unsafePerformIO $ getCommand "glEdgeFlagPointerEXT"

-- glEdgeFlagPointerListIBM ----------------------------------------------------

glEdgeFlagPointerListIBM
  :: MonadIO m
  => GLint -- ^ @stride@.
  -> Ptr (Ptr GLboolean) -- ^ @pointer@ pointing to @COMPSIZE(stride)@ elements of type @Ptr BooleanPointer@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glEdgeFlagPointerListIBM v1 v2 v3 = liftIO $ dyn_glEdgeFlagPointerListIBM ptr_glEdgeFlagPointerListIBM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glEdgeFlagPointerListIBM
  :: FunPtr (GLint -> Ptr (Ptr GLboolean) -> GLint -> IO ())
  ->         GLint -> Ptr (Ptr GLboolean) -> GLint -> IO ()

{-# NOINLINE ptr_glEdgeFlagPointerListIBM #-}
ptr_glEdgeFlagPointerListIBM :: FunPtr (GLint -> Ptr (Ptr GLboolean) -> GLint -> IO ())
ptr_glEdgeFlagPointerListIBM = unsafePerformIO $ getCommand "glEdgeFlagPointerListIBM"

-- glEdgeFlagv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlag.xml OpenGL 2.x>
glEdgeFlagv
  :: MonadIO m
  => Ptr GLboolean -- ^ @flag@ pointing to @1@ elements of type @Boolean@.
  -> m ()
glEdgeFlagv v1 = liftIO $ dyn_glEdgeFlagv ptr_glEdgeFlagv v1

foreign import CALLCONV "dynamic" dyn_glEdgeFlagv
  :: FunPtr (Ptr GLboolean -> IO ())
  ->         Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glEdgeFlagv #-}
ptr_glEdgeFlagv :: FunPtr (Ptr GLboolean -> IO ())
ptr_glEdgeFlagv = unsafePerformIO $ getCommand "glEdgeFlagv"

-- glElementPointerAPPLE -------------------------------------------------------

glElementPointerAPPLE
  :: MonadIO m
  => GLenum -- ^ @type@ of type @ElementPointerTypeATI@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type)@ elements of type @a@.
  -> m ()
glElementPointerAPPLE v1 v2 = liftIO $ dyn_glElementPointerAPPLE ptr_glElementPointerAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glElementPointerAPPLE
  :: FunPtr (GLenum -> Ptr a -> IO ())
  ->         GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glElementPointerAPPLE #-}
ptr_glElementPointerAPPLE :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glElementPointerAPPLE = unsafePerformIO $ getCommand "glElementPointerAPPLE"

-- glElementPointerATI ---------------------------------------------------------

glElementPointerATI
  :: MonadIO m
  => GLenum -- ^ @type@ of type @ElementPointerTypeATI@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type)@ elements of type @a@.
  -> m ()
glElementPointerATI v1 v2 = liftIO $ dyn_glElementPointerATI ptr_glElementPointerATI v1 v2

foreign import CALLCONV "dynamic" dyn_glElementPointerATI
  :: FunPtr (GLenum -> Ptr a -> IO ())
  ->         GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glElementPointerATI #-}
ptr_glElementPointerATI :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glElementPointerATI = unsafePerformIO $ getCommand "glElementPointerATI"

-- glEnable --------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>
glEnable
  :: MonadIO m
  => GLenum -- ^ @cap@ of type @EnableCap@.
  -> m ()
glEnable v1 = liftIO $ dyn_glEnable ptr_glEnable v1

foreign import CALLCONV "dynamic" dyn_glEnable
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glEnable #-}
ptr_glEnable :: FunPtr (GLenum -> IO ())
ptr_glEnable = unsafePerformIO $ getCommand "glEnable"

-- glEnableClientState ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableClientState.xml OpenGL 2.x>
glEnableClientState
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> m ()
glEnableClientState v1 = liftIO $ dyn_glEnableClientState ptr_glEnableClientState v1

foreign import CALLCONV "dynamic" dyn_glEnableClientState
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glEnableClientState #-}
ptr_glEnableClientState :: FunPtr (GLenum -> IO ())
ptr_glEnableClientState = unsafePerformIO $ getCommand "glEnableClientState"

-- glEnableClientStateIndexedEXT -----------------------------------------------

glEnableClientStateIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableClientStateIndexedEXT v1 v2 = liftIO $ dyn_glEnableClientStateIndexedEXT ptr_glEnableClientStateIndexedEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableClientStateIndexedEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableClientStateIndexedEXT #-}
ptr_glEnableClientStateIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableClientStateIndexedEXT = unsafePerformIO $ getCommand "glEnableClientStateIndexedEXT"

-- glEnableClientStateiEXT -----------------------------------------------------

glEnableClientStateiEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableClientStateiEXT v1 v2 = liftIO $ dyn_glEnableClientStateiEXT ptr_glEnableClientStateiEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableClientStateiEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableClientStateiEXT #-}
ptr_glEnableClientStateiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableClientStateiEXT = unsafePerformIO $ getCommand "glEnableClientStateiEXT"

-- glEnableDriverControlQCOM ---------------------------------------------------

glEnableDriverControlQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> m ()
glEnableDriverControlQCOM v1 = liftIO $ dyn_glEnableDriverControlQCOM ptr_glEnableDriverControlQCOM v1

foreign import CALLCONV "dynamic" dyn_glEnableDriverControlQCOM
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEnableDriverControlQCOM #-}
ptr_glEnableDriverControlQCOM :: FunPtr (GLuint -> IO ())
ptr_glEnableDriverControlQCOM = unsafePerformIO $ getCommand "glEnableDriverControlQCOM"

-- glEnableIndexedEXT ----------------------------------------------------------

glEnableIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableIndexedEXT v1 v2 = liftIO $ dyn_glEnableIndexedEXT ptr_glEnableIndexedEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableIndexedEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableIndexedEXT #-}
ptr_glEnableIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableIndexedEXT = unsafePerformIO $ getCommand "glEnableIndexedEXT"

-- glEnableVariantClientStateEXT -----------------------------------------------

glEnableVariantClientStateEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glEnableVariantClientStateEXT v1 = liftIO $ dyn_glEnableVariantClientStateEXT ptr_glEnableVariantClientStateEXT v1

foreign import CALLCONV "dynamic" dyn_glEnableVariantClientStateEXT
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEnableVariantClientStateEXT #-}
ptr_glEnableVariantClientStateEXT :: FunPtr (GLuint -> IO ())
ptr_glEnableVariantClientStateEXT = unsafePerformIO $ getCommand "glEnableVariantClientStateEXT"

-- glEnableVertexArrayAttrib ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>
glEnableVertexArrayAttrib
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableVertexArrayAttrib v1 v2 = liftIO $ dyn_glEnableVertexArrayAttrib ptr_glEnableVertexArrayAttrib v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableVertexArrayAttrib
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableVertexArrayAttrib #-}
ptr_glEnableVertexArrayAttrib :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glEnableVertexArrayAttrib = unsafePerformIO $ getCommand "glEnableVertexArrayAttrib"

-- glEnableVertexArrayAttribEXT ------------------------------------------------

glEnableVertexArrayAttribEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableVertexArrayAttribEXT v1 v2 = liftIO $ dyn_glEnableVertexArrayAttribEXT ptr_glEnableVertexArrayAttribEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableVertexArrayAttribEXT
  :: FunPtr (GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableVertexArrayAttribEXT #-}
ptr_glEnableVertexArrayAttribEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glEnableVertexArrayAttribEXT = unsafePerformIO $ getCommand "glEnableVertexArrayAttribEXT"

-- glEnableVertexArrayEXT ------------------------------------------------------

glEnableVertexArrayEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @array@ of type @EnableCap@.
  -> m ()
glEnableVertexArrayEXT v1 v2 = liftIO $ dyn_glEnableVertexArrayEXT ptr_glEnableVertexArrayEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableVertexArrayEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glEnableVertexArrayEXT #-}
ptr_glEnableVertexArrayEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glEnableVertexArrayEXT = unsafePerformIO $ getCommand "glEnableVertexArrayEXT"

-- glEnableVertexAttribAPPLE ---------------------------------------------------

glEnableVertexAttribAPPLE
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> m ()
glEnableVertexAttribAPPLE v1 v2 = liftIO $ dyn_glEnableVertexAttribAPPLE ptr_glEnableVertexAttribAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableVertexAttribAPPLE
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glEnableVertexAttribAPPLE #-}
ptr_glEnableVertexAttribAPPLE :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glEnableVertexAttribAPPLE = unsafePerformIO $ getCommand "glEnableVertexAttribAPPLE"

-- glEnableVertexAttribArray ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableVertexAttribArray.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnableVertexAttribArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>
glEnableVertexAttribArray
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glEnableVertexAttribArray v1 = liftIO $ dyn_glEnableVertexAttribArray ptr_glEnableVertexAttribArray v1

foreign import CALLCONV "dynamic" dyn_glEnableVertexAttribArray
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEnableVertexAttribArray #-}
ptr_glEnableVertexAttribArray :: FunPtr (GLuint -> IO ())
ptr_glEnableVertexAttribArray = unsafePerformIO $ getCommand "glEnableVertexAttribArray"

-- glEnableVertexAttribArrayARB ------------------------------------------------

glEnableVertexAttribArrayARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glEnableVertexAttribArrayARB v1 = liftIO $ dyn_glEnableVertexAttribArrayARB ptr_glEnableVertexAttribArrayARB v1

foreign import CALLCONV "dynamic" dyn_glEnableVertexAttribArrayARB
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEnableVertexAttribArrayARB #-}
ptr_glEnableVertexAttribArrayARB :: FunPtr (GLuint -> IO ())
ptr_glEnableVertexAttribArrayARB = unsafePerformIO $ getCommand "glEnableVertexAttribArrayARB"

-- glEnablei -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>
glEnablei
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnablei v1 v2 = liftIO $ dyn_glEnablei ptr_glEnablei v1 v2

foreign import CALLCONV "dynamic" dyn_glEnablei
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnablei #-}
ptr_glEnablei :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnablei = unsafePerformIO $ getCommand "glEnablei"

-- glEnableiEXT ----------------------------------------------------------------

glEnableiEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiEXT v1 v2 = liftIO $ dyn_glEnableiEXT ptr_glEnableiEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableiEXT
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableiEXT #-}
ptr_glEnableiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiEXT = unsafePerformIO $ getCommand "glEnableiEXT"

-- glEnableiNV -----------------------------------------------------------------

glEnableiNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiNV v1 v2 = liftIO $ dyn_glEnableiNV ptr_glEnableiNV v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableiNV
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableiNV #-}
ptr_glEnableiNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiNV = unsafePerformIO $ getCommand "glEnableiNV"

-- glEnableiOES ----------------------------------------------------------------

glEnableiOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiOES v1 v2 = liftIO $ dyn_glEnableiOES ptr_glEnableiOES v1 v2

foreign import CALLCONV "dynamic" dyn_glEnableiOES
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEnableiOES #-}
ptr_glEnableiOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiOES = unsafePerformIO $ getCommand "glEnableiOES"

-- glEnd -----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBegin.xml OpenGL 2.x>
glEnd
  :: MonadIO m
  => m ()
glEnd = liftIO $ dyn_glEnd ptr_glEnd

foreign import CALLCONV "dynamic" dyn_glEnd
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEnd #-}
ptr_glEnd :: FunPtr (IO ())
ptr_glEnd = unsafePerformIO $ getCommand "glEnd"

-- glEndConditionalRender ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginConditionalRender.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginConditionalRender.xhtml OpenGL 4.x>
glEndConditionalRender
  :: MonadIO m
  => m ()
glEndConditionalRender = liftIO $ dyn_glEndConditionalRender ptr_glEndConditionalRender

foreign import CALLCONV "dynamic" dyn_glEndConditionalRender
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndConditionalRender #-}
ptr_glEndConditionalRender :: FunPtr (IO ())
ptr_glEndConditionalRender = unsafePerformIO $ getCommand "glEndConditionalRender"

-- glEndConditionalRenderNV ----------------------------------------------------

glEndConditionalRenderNV
  :: MonadIO m
  => m ()
glEndConditionalRenderNV = liftIO $ dyn_glEndConditionalRenderNV ptr_glEndConditionalRenderNV

foreign import CALLCONV "dynamic" dyn_glEndConditionalRenderNV
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndConditionalRenderNV #-}
ptr_glEndConditionalRenderNV :: FunPtr (IO ())
ptr_glEndConditionalRenderNV = unsafePerformIO $ getCommand "glEndConditionalRenderNV"

-- glEndConditionalRenderNVX ---------------------------------------------------

glEndConditionalRenderNVX
  :: MonadIO m
  => m ()
glEndConditionalRenderNVX = liftIO $ dyn_glEndConditionalRenderNVX ptr_glEndConditionalRenderNVX

foreign import CALLCONV "dynamic" dyn_glEndConditionalRenderNVX
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndConditionalRenderNVX #-}
ptr_glEndConditionalRenderNVX :: FunPtr (IO ())
ptr_glEndConditionalRenderNVX = unsafePerformIO $ getCommand "glEndConditionalRenderNVX"

-- glEndFragmentShaderATI ------------------------------------------------------

glEndFragmentShaderATI
  :: MonadIO m
  => m ()
glEndFragmentShaderATI = liftIO $ dyn_glEndFragmentShaderATI ptr_glEndFragmentShaderATI

foreign import CALLCONV "dynamic" dyn_glEndFragmentShaderATI
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndFragmentShaderATI #-}
ptr_glEndFragmentShaderATI :: FunPtr (IO ())
ptr_glEndFragmentShaderATI = unsafePerformIO $ getCommand "glEndFragmentShaderATI"

-- glEndList -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glNewList.xml OpenGL 2.x>
glEndList
  :: MonadIO m
  => m ()
glEndList = liftIO $ dyn_glEndList ptr_glEndList

foreign import CALLCONV "dynamic" dyn_glEndList
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndList #-}
ptr_glEndList :: FunPtr (IO ())
ptr_glEndList = unsafePerformIO $ getCommand "glEndList"

-- glEndOcclusionQueryNV -------------------------------------------------------

glEndOcclusionQueryNV
  :: MonadIO m
  => m ()
glEndOcclusionQueryNV = liftIO $ dyn_glEndOcclusionQueryNV ptr_glEndOcclusionQueryNV

foreign import CALLCONV "dynamic" dyn_glEndOcclusionQueryNV
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndOcclusionQueryNV #-}
ptr_glEndOcclusionQueryNV :: FunPtr (IO ())
ptr_glEndOcclusionQueryNV = unsafePerformIO $ getCommand "glEndOcclusionQueryNV"

-- glEndPerfMonitorAMD ---------------------------------------------------------

glEndPerfMonitorAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> m ()
glEndPerfMonitorAMD v1 = liftIO $ dyn_glEndPerfMonitorAMD ptr_glEndPerfMonitorAMD v1

foreign import CALLCONV "dynamic" dyn_glEndPerfMonitorAMD
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEndPerfMonitorAMD #-}
ptr_glEndPerfMonitorAMD :: FunPtr (GLuint -> IO ())
ptr_glEndPerfMonitorAMD = unsafePerformIO $ getCommand "glEndPerfMonitorAMD"

-- glEndPerfQueryINTEL ---------------------------------------------------------

glEndPerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glEndPerfQueryINTEL v1 = liftIO $ dyn_glEndPerfQueryINTEL ptr_glEndPerfQueryINTEL v1

foreign import CALLCONV "dynamic" dyn_glEndPerfQueryINTEL
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEndPerfQueryINTEL #-}
ptr_glEndPerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glEndPerfQueryINTEL = unsafePerformIO $ getCommand "glEndPerfQueryINTEL"

-- glEndQuery ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBeginQuery.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginQuery.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginQuery.xhtml OpenGL 4.x>
glEndQuery
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQuery v1 = liftIO $ dyn_glEndQuery ptr_glEndQuery v1

foreign import CALLCONV "dynamic" dyn_glEndQuery
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glEndQuery #-}
ptr_glEndQuery :: FunPtr (GLenum -> IO ())
ptr_glEndQuery = unsafePerformIO $ getCommand "glEndQuery"

-- glEndQueryARB ---------------------------------------------------------------

glEndQueryARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQueryARB v1 = liftIO $ dyn_glEndQueryARB ptr_glEndQueryARB v1

foreign import CALLCONV "dynamic" dyn_glEndQueryARB
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glEndQueryARB #-}
ptr_glEndQueryARB :: FunPtr (GLenum -> IO ())
ptr_glEndQueryARB = unsafePerformIO $ getCommand "glEndQueryARB"

-- glEndQueryEXT ---------------------------------------------------------------

glEndQueryEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQueryEXT v1 = liftIO $ dyn_glEndQueryEXT ptr_glEndQueryEXT v1

foreign import CALLCONV "dynamic" dyn_glEndQueryEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glEndQueryEXT #-}
ptr_glEndQueryEXT :: FunPtr (GLenum -> IO ())
ptr_glEndQueryEXT = unsafePerformIO $ getCommand "glEndQueryEXT"

-- glEndQueryIndexed -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBeginQueryIndexed.xhtml OpenGL 4.x>
glEndQueryIndexed
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEndQueryIndexed v1 v2 = liftIO $ dyn_glEndQueryIndexed ptr_glEndQueryIndexed v1 v2

foreign import CALLCONV "dynamic" dyn_glEndQueryIndexed
  :: FunPtr (GLenum -> GLuint -> IO ())
  ->         GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glEndQueryIndexed #-}
ptr_glEndQueryIndexed :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEndQueryIndexed = unsafePerformIO $ getCommand "glEndQueryIndexed"

-- glEndTilingQCOM -------------------------------------------------------------

glEndTilingQCOM
  :: MonadIO m
  => GLbitfield -- ^ @preserveMask@.
  -> m ()
glEndTilingQCOM v1 = liftIO $ dyn_glEndTilingQCOM ptr_glEndTilingQCOM v1

foreign import CALLCONV "dynamic" dyn_glEndTilingQCOM
  :: FunPtr (GLbitfield -> IO ())
  ->         GLbitfield -> IO ()

{-# NOINLINE ptr_glEndTilingQCOM #-}
ptr_glEndTilingQCOM :: FunPtr (GLbitfield -> IO ())
ptr_glEndTilingQCOM = unsafePerformIO $ getCommand "glEndTilingQCOM"

-- glEndTransformFeedback ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginTransformFeedback.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginTransformFeedback.xhtml OpenGL 4.x>
glEndTransformFeedback
  :: MonadIO m
  => m ()
glEndTransformFeedback = liftIO $ dyn_glEndTransformFeedback ptr_glEndTransformFeedback

foreign import CALLCONV "dynamic" dyn_glEndTransformFeedback
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndTransformFeedback #-}
ptr_glEndTransformFeedback :: FunPtr (IO ())
ptr_glEndTransformFeedback = unsafePerformIO $ getCommand "glEndTransformFeedback"

-- glEndTransformFeedbackEXT ---------------------------------------------------

glEndTransformFeedbackEXT
  :: MonadIO m
  => m ()
glEndTransformFeedbackEXT = liftIO $ dyn_glEndTransformFeedbackEXT ptr_glEndTransformFeedbackEXT

foreign import CALLCONV "dynamic" dyn_glEndTransformFeedbackEXT
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndTransformFeedbackEXT #-}
ptr_glEndTransformFeedbackEXT :: FunPtr (IO ())
ptr_glEndTransformFeedbackEXT = unsafePerformIO $ getCommand "glEndTransformFeedbackEXT"

-- glEndTransformFeedbackNV ----------------------------------------------------

glEndTransformFeedbackNV
  :: MonadIO m
  => m ()
glEndTransformFeedbackNV = liftIO $ dyn_glEndTransformFeedbackNV ptr_glEndTransformFeedbackNV

foreign import CALLCONV "dynamic" dyn_glEndTransformFeedbackNV
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndTransformFeedbackNV #-}
ptr_glEndTransformFeedbackNV :: FunPtr (IO ())
ptr_glEndTransformFeedbackNV = unsafePerformIO $ getCommand "glEndTransformFeedbackNV"

-- glEndVertexShaderEXT --------------------------------------------------------

glEndVertexShaderEXT
  :: MonadIO m
  => m ()
glEndVertexShaderEXT = liftIO $ dyn_glEndVertexShaderEXT ptr_glEndVertexShaderEXT

foreign import CALLCONV "dynamic" dyn_glEndVertexShaderEXT
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glEndVertexShaderEXT #-}
ptr_glEndVertexShaderEXT :: FunPtr (IO ())
ptr_glEndVertexShaderEXT = unsafePerformIO $ getCommand "glEndVertexShaderEXT"

-- glEndVideoCaptureNV ---------------------------------------------------------

glEndVideoCaptureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> m ()
glEndVideoCaptureNV v1 = liftIO $ dyn_glEndVideoCaptureNV ptr_glEndVideoCaptureNV v1

foreign import CALLCONV "dynamic" dyn_glEndVideoCaptureNV
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glEndVideoCaptureNV #-}
ptr_glEndVideoCaptureNV :: FunPtr (GLuint -> IO ())
ptr_glEndVideoCaptureNV = unsafePerformIO $ getCommand "glEndVideoCaptureNV"

-- glEvalCoord1d ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord1d
  :: MonadIO m
  => GLdouble -- ^ @u@ of type @CoordD@.
  -> m ()
glEvalCoord1d v1 = liftIO $ dyn_glEvalCoord1d ptr_glEvalCoord1d v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1d
  :: FunPtr (GLdouble -> IO ())
  ->         GLdouble -> IO ()

{-# NOINLINE ptr_glEvalCoord1d #-}
ptr_glEvalCoord1d :: FunPtr (GLdouble -> IO ())
ptr_glEvalCoord1d = unsafePerformIO $ getCommand "glEvalCoord1d"

-- glEvalCoord1dv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord1dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @u@ pointing to @1@ elements of type @CoordD@.
  -> m ()
glEvalCoord1dv v1 = liftIO $ dyn_glEvalCoord1dv ptr_glEvalCoord1dv v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1dv
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glEvalCoord1dv #-}
ptr_glEvalCoord1dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glEvalCoord1dv = unsafePerformIO $ getCommand "glEvalCoord1dv"

-- glEvalCoord1f ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord1f
  :: MonadIO m
  => GLfloat -- ^ @u@ of type @CoordF@.
  -> m ()
glEvalCoord1f v1 = liftIO $ dyn_glEvalCoord1f ptr_glEvalCoord1f v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1f
  :: FunPtr (GLfloat -> IO ())
  ->         GLfloat -> IO ()

{-# NOINLINE ptr_glEvalCoord1f #-}
ptr_glEvalCoord1f :: FunPtr (GLfloat -> IO ())
ptr_glEvalCoord1f = unsafePerformIO $ getCommand "glEvalCoord1f"

-- glEvalCoord1fv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord1fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @u@ pointing to @1@ elements of type @CoordF@.
  -> m ()
glEvalCoord1fv v1 = liftIO $ dyn_glEvalCoord1fv ptr_glEvalCoord1fv v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1fv
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glEvalCoord1fv #-}
ptr_glEvalCoord1fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glEvalCoord1fv = unsafePerformIO $ getCommand "glEvalCoord1fv"

-- glEvalCoord1xOES ------------------------------------------------------------

glEvalCoord1xOES
  :: MonadIO m
  => GLfixed -- ^ @u@.
  -> m ()
glEvalCoord1xOES v1 = liftIO $ dyn_glEvalCoord1xOES ptr_glEvalCoord1xOES v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1xOES
  :: FunPtr (GLfixed -> IO ())
  ->         GLfixed -> IO ()

{-# NOINLINE ptr_glEvalCoord1xOES #-}
ptr_glEvalCoord1xOES :: FunPtr (GLfixed -> IO ())
ptr_glEvalCoord1xOES = unsafePerformIO $ getCommand "glEvalCoord1xOES"

-- glEvalCoord1xvOES -----------------------------------------------------------

glEvalCoord1xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@ pointing to @1@ elements of type @GLfixed@.
  -> m ()
glEvalCoord1xvOES v1 = liftIO $ dyn_glEvalCoord1xvOES ptr_glEvalCoord1xvOES v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord1xvOES
  :: FunPtr (Ptr GLfixed -> IO ())
  ->         Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glEvalCoord1xvOES #-}
ptr_glEvalCoord1xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glEvalCoord1xvOES = unsafePerformIO $ getCommand "glEvalCoord1xvOES"

-- glEvalCoord2d ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord2d
  :: MonadIO m
  => GLdouble -- ^ @u@ of type @CoordD@.
  -> GLdouble -- ^ @v@ of type @CoordD@.
  -> m ()
glEvalCoord2d v1 v2 = liftIO $ dyn_glEvalCoord2d ptr_glEvalCoord2d v1 v2

foreign import CALLCONV "dynamic" dyn_glEvalCoord2d
  :: FunPtr (GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glEvalCoord2d #-}
ptr_glEvalCoord2d :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glEvalCoord2d = unsafePerformIO $ getCommand "glEvalCoord2d"

-- glEvalCoord2dv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord2dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @u@ pointing to @2@ elements of type @CoordD@.
  -> m ()
glEvalCoord2dv v1 = liftIO $ dyn_glEvalCoord2dv ptr_glEvalCoord2dv v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord2dv
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glEvalCoord2dv #-}
ptr_glEvalCoord2dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glEvalCoord2dv = unsafePerformIO $ getCommand "glEvalCoord2dv"

-- glEvalCoord2f ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord2f
  :: MonadIO m
  => GLfloat -- ^ @u@ of type @CoordF@.
  -> GLfloat -- ^ @v@ of type @CoordF@.
  -> m ()
glEvalCoord2f v1 v2 = liftIO $ dyn_glEvalCoord2f ptr_glEvalCoord2f v1 v2

foreign import CALLCONV "dynamic" dyn_glEvalCoord2f
  :: FunPtr (GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glEvalCoord2f #-}
ptr_glEvalCoord2f :: FunPtr (GLfloat -> GLfloat -> IO ())
ptr_glEvalCoord2f = unsafePerformIO $ getCommand "glEvalCoord2f"

-- glEvalCoord2fv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>
glEvalCoord2fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @u@ pointing to @2@ elements of type @CoordF@.
  -> m ()
glEvalCoord2fv v1 = liftIO $ dyn_glEvalCoord2fv ptr_glEvalCoord2fv v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord2fv
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glEvalCoord2fv #-}
ptr_glEvalCoord2fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glEvalCoord2fv = unsafePerformIO $ getCommand "glEvalCoord2fv"

-- glEvalCoord2xOES ------------------------------------------------------------

glEvalCoord2xOES
  :: MonadIO m
  => GLfixed -- ^ @u@.
  -> GLfixed -- ^ @v@.
  -> m ()
glEvalCoord2xOES v1 v2 = liftIO $ dyn_glEvalCoord2xOES ptr_glEvalCoord2xOES v1 v2

foreign import CALLCONV "dynamic" dyn_glEvalCoord2xOES
  :: FunPtr (GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glEvalCoord2xOES #-}
ptr_glEvalCoord2xOES :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glEvalCoord2xOES = unsafePerformIO $ getCommand "glEvalCoord2xOES"

-- glEvalCoord2xvOES -----------------------------------------------------------

glEvalCoord2xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@ pointing to @2@ elements of type @GLfixed@.
  -> m ()
glEvalCoord2xvOES v1 = liftIO $ dyn_glEvalCoord2xvOES ptr_glEvalCoord2xvOES v1

foreign import CALLCONV "dynamic" dyn_glEvalCoord2xvOES
  :: FunPtr (Ptr GLfixed -> IO ())
  ->         Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glEvalCoord2xvOES #-}
ptr_glEvalCoord2xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glEvalCoord2xvOES = unsafePerformIO $ getCommand "glEvalCoord2xvOES"

-- glEvalMapsNV ----------------------------------------------------------------

glEvalMapsNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @mode@ of type @EvalMapsModeNV@.
  -> m ()
glEvalMapsNV v1 v2 = liftIO $ dyn_glEvalMapsNV ptr_glEvalMapsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glEvalMapsNV
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glEvalMapsNV #-}
ptr_glEvalMapsNV :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glEvalMapsNV = unsafePerformIO $ getCommand "glEvalMapsNV"

-- glEvalMesh1 -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh.xml OpenGL 2.x>
glEvalMesh1
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @MeshMode1@.
  -> GLint -- ^ @i1@ of type @CheckedInt32@.
  -> GLint -- ^ @i2@ of type @CheckedInt32@.
  -> m ()
glEvalMesh1 v1 v2 v3 = liftIO $ dyn_glEvalMesh1 ptr_glEvalMesh1 v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glEvalMesh1
  :: FunPtr (GLenum -> GLint -> GLint -> IO ())
  ->         GLenum -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glEvalMesh1 #-}
ptr_glEvalMesh1 :: FunPtr (GLenum -> GLint -> GLint -> IO ())
ptr_glEvalMesh1 = unsafePerformIO $ getCommand "glEvalMesh1"

-- glEvalMesh2 -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh.xml OpenGL 2.x>
glEvalMesh2
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @MeshMode2@.
  -> GLint -- ^ @i1@ of type @CheckedInt32@.
  -> GLint -- ^ @i2@ of type @CheckedInt32@.
  -> GLint -- ^ @j1@ of type @CheckedInt32@.
  -> GLint -- ^ @j2@ of type @CheckedInt32@.
  -> m ()
glEvalMesh2 v1 v2 v3 v4 v5 = liftIO $ dyn_glEvalMesh2 ptr_glEvalMesh2 v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glEvalMesh2
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glEvalMesh2 #-}
ptr_glEvalMesh2 :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glEvalMesh2 = unsafePerformIO $ getCommand "glEvalMesh2"

-- glEvalPoint1 ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint.xml OpenGL 2.x>
glEvalPoint1
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glEvalPoint1 v1 = liftIO $ dyn_glEvalPoint1 ptr_glEvalPoint1 v1

foreign import CALLCONV "dynamic" dyn_glEvalPoint1
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glEvalPoint1 #-}
ptr_glEvalPoint1 :: FunPtr (GLint -> IO ())
ptr_glEvalPoint1 = unsafePerformIO $ getCommand "glEvalPoint1"

-- glEvalPoint2 ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint.xml OpenGL 2.x>
glEvalPoint2
  :: MonadIO m
  => GLint -- ^ @i@ of type @CheckedInt32@.
  -> GLint -- ^ @j@ of type @CheckedInt32@.
  -> m ()
glEvalPoint2 v1 v2 = liftIO $ dyn_glEvalPoint2 ptr_glEvalPoint2 v1 v2

foreign import CALLCONV "dynamic" dyn_glEvalPoint2
  :: FunPtr (GLint -> GLint -> IO ())
  ->         GLint -> GLint -> IO ()

{-# NOINLINE ptr_glEvalPoint2 #-}
ptr_glEvalPoint2 :: FunPtr (GLint -> GLint -> IO ())
ptr_glEvalPoint2 = unsafePerformIO $ getCommand "glEvalPoint2"

-- glExecuteProgramNV ----------------------------------------------------------

glExecuteProgramNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @id@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glExecuteProgramNV v1 v2 v3 = liftIO $ dyn_glExecuteProgramNV ptr_glExecuteProgramNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExecuteProgramNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glExecuteProgramNV #-}
ptr_glExecuteProgramNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glExecuteProgramNV = unsafePerformIO $ getCommand "glExecuteProgramNV"

-- glExtGetBufferPointervQCOM --------------------------------------------------

glExtGetBufferPointervQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glExtGetBufferPointervQCOM v1 v2 = liftIO $ dyn_glExtGetBufferPointervQCOM ptr_glExtGetBufferPointervQCOM v1 v2

foreign import CALLCONV "dynamic" dyn_glExtGetBufferPointervQCOM
  :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glExtGetBufferPointervQCOM #-}
ptr_glExtGetBufferPointervQCOM :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glExtGetBufferPointervQCOM = unsafePerformIO $ getCommand "glExtGetBufferPointervQCOM"

-- glExtGetBuffersQCOM ---------------------------------------------------------

glExtGetBuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @buffers@ pointing to @maxBuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxBuffers@.
  -> Ptr GLint -- ^ @numBuffers@ pointing to @1@ elements of type @GLint@.
  -> m ()
glExtGetBuffersQCOM v1 v2 v3 = liftIO $ dyn_glExtGetBuffersQCOM ptr_glExtGetBuffersQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetBuffersQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetBuffersQCOM #-}
ptr_glExtGetBuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetBuffersQCOM = unsafePerformIO $ getCommand "glExtGetBuffersQCOM"

-- glExtGetFramebuffersQCOM ----------------------------------------------------

glExtGetFramebuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @framebuffers@ pointing to @maxFramebuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxFramebuffers@.
  -> Ptr GLint -- ^ @numFramebuffers@ pointing to @1@ elements of type @GLint@.
  -> m ()
glExtGetFramebuffersQCOM v1 v2 v3 = liftIO $ dyn_glExtGetFramebuffersQCOM ptr_glExtGetFramebuffersQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetFramebuffersQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetFramebuffersQCOM #-}
ptr_glExtGetFramebuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetFramebuffersQCOM = unsafePerformIO $ getCommand "glExtGetFramebuffersQCOM"

-- glExtGetProgramBinarySourceQCOM ---------------------------------------------

glExtGetProgramBinarySourceQCOM
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @source@.
  -> Ptr GLint -- ^ @length@.
  -> m ()
glExtGetProgramBinarySourceQCOM v1 v2 v3 v4 = liftIO $ dyn_glExtGetProgramBinarySourceQCOM ptr_glExtGetProgramBinarySourceQCOM v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glExtGetProgramBinarySourceQCOM
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLchar -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetProgramBinarySourceQCOM #-}
ptr_glExtGetProgramBinarySourceQCOM :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> Ptr GLint -> IO ())
ptr_glExtGetProgramBinarySourceQCOM = unsafePerformIO $ getCommand "glExtGetProgramBinarySourceQCOM"

-- glExtGetProgramsQCOM --------------------------------------------------------

glExtGetProgramsQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @programs@ pointing to @maxPrograms@ elements of type @GLuint@.
  -> GLint -- ^ @maxPrograms@.
  -> Ptr GLint -- ^ @numPrograms@ pointing to @1@ elements of type @GLint@.
  -> m ()
glExtGetProgramsQCOM v1 v2 v3 = liftIO $ dyn_glExtGetProgramsQCOM ptr_glExtGetProgramsQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetProgramsQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetProgramsQCOM #-}
ptr_glExtGetProgramsQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetProgramsQCOM = unsafePerformIO $ getCommand "glExtGetProgramsQCOM"

-- glExtGetRenderbuffersQCOM ---------------------------------------------------

glExtGetRenderbuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @renderbuffers@ pointing to @maxRenderbuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxRenderbuffers@.
  -> Ptr GLint -- ^ @numRenderbuffers@ pointing to @1@ elements of type @GLint@.
  -> m ()
glExtGetRenderbuffersQCOM v1 v2 v3 = liftIO $ dyn_glExtGetRenderbuffersQCOM ptr_glExtGetRenderbuffersQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetRenderbuffersQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetRenderbuffersQCOM #-}
ptr_glExtGetRenderbuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetRenderbuffersQCOM = unsafePerformIO $ getCommand "glExtGetRenderbuffersQCOM"

-- glExtGetShadersQCOM ---------------------------------------------------------

glExtGetShadersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @shaders@ pointing to @maxShaders@ elements of type @GLuint@.
  -> GLint -- ^ @maxShaders@.
  -> Ptr GLint -- ^ @numShaders@ pointing to @1@ elements of type @GLint@.
  -> m ()
glExtGetShadersQCOM v1 v2 v3 = liftIO $ dyn_glExtGetShadersQCOM ptr_glExtGetShadersQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetShadersQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetShadersQCOM #-}
ptr_glExtGetShadersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetShadersQCOM = unsafePerformIO $ getCommand "glExtGetShadersQCOM"

-- glExtGetTexLevelParameterivQCOM ---------------------------------------------

glExtGetTexLevelParameterivQCOM
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @face@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glExtGetTexLevelParameterivQCOM v1 v2 v3 v4 v5 = liftIO $ dyn_glExtGetTexLevelParameterivQCOM ptr_glExtGetTexLevelParameterivQCOM v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glExtGetTexLevelParameterivQCOM
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetTexLevelParameterivQCOM #-}
ptr_glExtGetTexLevelParameterivQCOM :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glExtGetTexLevelParameterivQCOM = unsafePerformIO $ getCommand "glExtGetTexLevelParameterivQCOM"

-- glExtGetTexSubImageQCOM -----------------------------------------------------

glExtGetTexSubImageQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @texels@.
  -> m ()
glExtGetTexSubImageQCOM v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glExtGetTexSubImageQCOM ptr_glExtGetTexSubImageQCOM v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glExtGetTexSubImageQCOM
  :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glExtGetTexSubImageQCOM #-}
ptr_glExtGetTexSubImageQCOM :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glExtGetTexSubImageQCOM = unsafePerformIO $ getCommand "glExtGetTexSubImageQCOM"

-- glExtGetTexturesQCOM --------------------------------------------------------

glExtGetTexturesQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @textures@.
  -> GLint -- ^ @maxTextures@.
  -> Ptr GLint -- ^ @numTextures@.
  -> m ()
glExtGetTexturesQCOM v1 v2 v3 = liftIO $ dyn_glExtGetTexturesQCOM ptr_glExtGetTexturesQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtGetTexturesQCOM
  :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
  ->         Ptr GLuint -> GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glExtGetTexturesQCOM #-}
ptr_glExtGetTexturesQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetTexturesQCOM = unsafePerformIO $ getCommand "glExtGetTexturesQCOM"

-- glExtIsProgramBinaryQCOM ----------------------------------------------------

glExtIsProgramBinaryQCOM
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m GLboolean
glExtIsProgramBinaryQCOM v1 = liftIO $ dyn_glExtIsProgramBinaryQCOM ptr_glExtIsProgramBinaryQCOM v1

foreign import CALLCONV "dynamic" dyn_glExtIsProgramBinaryQCOM
  :: FunPtr (GLuint -> IO GLboolean)
  ->         GLuint -> IO GLboolean

{-# NOINLINE ptr_glExtIsProgramBinaryQCOM #-}
ptr_glExtIsProgramBinaryQCOM :: FunPtr (GLuint -> IO GLboolean)
ptr_glExtIsProgramBinaryQCOM = unsafePerformIO $ getCommand "glExtIsProgramBinaryQCOM"

-- glExtTexObjectStateOverrideiQCOM --------------------------------------------

glExtTexObjectStateOverrideiQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glExtTexObjectStateOverrideiQCOM v1 v2 v3 = liftIO $ dyn_glExtTexObjectStateOverrideiQCOM ptr_glExtTexObjectStateOverrideiQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtTexObjectStateOverrideiQCOM
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glExtTexObjectStateOverrideiQCOM #-}
ptr_glExtTexObjectStateOverrideiQCOM :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glExtTexObjectStateOverrideiQCOM = unsafePerformIO $ getCommand "glExtTexObjectStateOverrideiQCOM"

-- glExtractComponentEXT -------------------------------------------------------

glExtractComponentEXT
  :: MonadIO m
  => GLuint -- ^ @res@.
  -> GLuint -- ^ @src@.
  -> GLuint -- ^ @num@.
  -> m ()
glExtractComponentEXT v1 v2 v3 = liftIO $ dyn_glExtractComponentEXT ptr_glExtractComponentEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glExtractComponentEXT
  :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
  ->         GLuint -> GLuint -> GLuint -> IO ()

{-# NOINLINE ptr_glExtractComponentEXT #-}
ptr_glExtractComponentEXT :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glExtractComponentEXT = unsafePerformIO $ getCommand "glExtractComponentEXT"

-- glFeedbackBuffer ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFeedbackBuffer.xml OpenGL 2.x>
glFeedbackBuffer
  :: MonadIO m
  => GLsizei -- ^ @size@.
  -> GLenum -- ^ @type@ of type @FeedbackType@.
  -> Ptr GLfloat -- ^ @buffer@ pointing to @size@ elements of type @FeedbackElement@.
  -> m ()
glFeedbackBuffer v1 v2 v3 = liftIO $ dyn_glFeedbackBuffer ptr_glFeedbackBuffer v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFeedbackBuffer
  :: FunPtr (GLsizei -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLsizei -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFeedbackBuffer #-}
ptr_glFeedbackBuffer :: FunPtr (GLsizei -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFeedbackBuffer = unsafePerformIO $ getCommand "glFeedbackBuffer"

-- glFeedbackBufferxOES --------------------------------------------------------

glFeedbackBufferxOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> GLenum -- ^ @type@.
  -> Ptr GLfixed -- ^ @buffer@ pointing to @n@ elements of type @GLfixed@.
  -> m ()
glFeedbackBufferxOES v1 v2 v3 = liftIO $ dyn_glFeedbackBufferxOES ptr_glFeedbackBufferxOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFeedbackBufferxOES
  :: FunPtr (GLsizei -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLsizei -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glFeedbackBufferxOES #-}
ptr_glFeedbackBufferxOES :: FunPtr (GLsizei -> GLenum -> Ptr GLfixed -> IO ())
ptr_glFeedbackBufferxOES = unsafePerformIO $ getCommand "glFeedbackBufferxOES"

-- glFenceSync -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFenceSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFenceSync.xhtml OpenGL 4.x>
glFenceSync
  :: MonadIO m
  => GLenum -- ^ @condition@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync -- ^ of type @sync@.
glFenceSync v1 v2 = liftIO $ dyn_glFenceSync ptr_glFenceSync v1 v2

foreign import CALLCONV "dynamic" dyn_glFenceSync
  :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
  ->         GLenum -> GLbitfield -> IO GLsync

{-# NOINLINE ptr_glFenceSync #-}
ptr_glFenceSync :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
ptr_glFenceSync = unsafePerformIO $ getCommand "glFenceSync"

-- glFenceSyncAPPLE ------------------------------------------------------------

glFenceSyncAPPLE
  :: MonadIO m
  => GLenum -- ^ @condition@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync
glFenceSyncAPPLE v1 v2 = liftIO $ dyn_glFenceSyncAPPLE ptr_glFenceSyncAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glFenceSyncAPPLE
  :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
  ->         GLenum -> GLbitfield -> IO GLsync

{-# NOINLINE ptr_glFenceSyncAPPLE #-}
ptr_glFenceSyncAPPLE :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
ptr_glFenceSyncAPPLE = unsafePerformIO $ getCommand "glFenceSyncAPPLE"

-- glFinalCombinerInputNV ------------------------------------------------------

glFinalCombinerInputNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @input@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @mapping@ of type @CombinerMappingNV@.
  -> GLenum -- ^ @componentUsage@ of type @CombinerComponentUsageNV@.
  -> m ()
glFinalCombinerInputNV v1 v2 v3 v4 = liftIO $ dyn_glFinalCombinerInputNV ptr_glFinalCombinerInputNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFinalCombinerInputNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glFinalCombinerInputNV #-}
ptr_glFinalCombinerInputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glFinalCombinerInputNV = unsafePerformIO $ getCommand "glFinalCombinerInputNV"

-- glFinish --------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFinish.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFinish.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFinish.xhtml OpenGL 4.x>
glFinish
  :: MonadIO m
  => m ()
glFinish = liftIO $ dyn_glFinish ptr_glFinish

foreign import CALLCONV "dynamic" dyn_glFinish
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFinish #-}
ptr_glFinish :: FunPtr (IO ())
ptr_glFinish = unsafePerformIO $ getCommand "glFinish"

-- glFinishAsyncSGIX -----------------------------------------------------------

glFinishAsyncSGIX
  :: MonadIO m
  => Ptr GLuint -- ^ @markerp@ pointing to @1@ elements of type @GLuint@.
  -> m GLint
glFinishAsyncSGIX v1 = liftIO $ dyn_glFinishAsyncSGIX ptr_glFinishAsyncSGIX v1

foreign import CALLCONV "dynamic" dyn_glFinishAsyncSGIX
  :: FunPtr (Ptr GLuint -> IO GLint)
  ->         Ptr GLuint -> IO GLint

{-# NOINLINE ptr_glFinishAsyncSGIX #-}
ptr_glFinishAsyncSGIX :: FunPtr (Ptr GLuint -> IO GLint)
ptr_glFinishAsyncSGIX = unsafePerformIO $ getCommand "glFinishAsyncSGIX"

-- glFinishFenceAPPLE ----------------------------------------------------------

glFinishFenceAPPLE
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m ()
glFinishFenceAPPLE v1 = liftIO $ dyn_glFinishFenceAPPLE ptr_glFinishFenceAPPLE v1

foreign import CALLCONV "dynamic" dyn_glFinishFenceAPPLE
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glFinishFenceAPPLE #-}
ptr_glFinishFenceAPPLE :: FunPtr (GLuint -> IO ())
ptr_glFinishFenceAPPLE = unsafePerformIO $ getCommand "glFinishFenceAPPLE"

-- glFinishFenceNV -------------------------------------------------------------

glFinishFenceNV
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m ()
glFinishFenceNV v1 = liftIO $ dyn_glFinishFenceNV ptr_glFinishFenceNV v1

foreign import CALLCONV "dynamic" dyn_glFinishFenceNV
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glFinishFenceNV #-}
ptr_glFinishFenceNV :: FunPtr (GLuint -> IO ())
ptr_glFinishFenceNV = unsafePerformIO $ getCommand "glFinishFenceNV"

-- glFinishObjectAPPLE ---------------------------------------------------------

glFinishObjectAPPLE
  :: MonadIO m
  => GLenum -- ^ @object@ of type @ObjectTypeAPPLE@.
  -> GLint -- ^ @name@.
  -> m ()
glFinishObjectAPPLE v1 v2 = liftIO $ dyn_glFinishObjectAPPLE ptr_glFinishObjectAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glFinishObjectAPPLE
  :: FunPtr (GLenum -> GLint -> IO ())
  ->         GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFinishObjectAPPLE #-}
ptr_glFinishObjectAPPLE :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFinishObjectAPPLE = unsafePerformIO $ getCommand "glFinishObjectAPPLE"

-- glFinishTextureSUNX ---------------------------------------------------------

glFinishTextureSUNX
  :: MonadIO m
  => m ()
glFinishTextureSUNX = liftIO $ dyn_glFinishTextureSUNX ptr_glFinishTextureSUNX

foreign import CALLCONV "dynamic" dyn_glFinishTextureSUNX
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFinishTextureSUNX #-}
ptr_glFinishTextureSUNX :: FunPtr (IO ())
ptr_glFinishTextureSUNX = unsafePerformIO $ getCommand "glFinishTextureSUNX"

-- glFlush ---------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFlush.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFlush.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFlush.xhtml OpenGL 4.x>
glFlush
  :: MonadIO m
  => m ()
glFlush = liftIO $ dyn_glFlush ptr_glFlush

foreign import CALLCONV "dynamic" dyn_glFlush
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFlush #-}
ptr_glFlush :: FunPtr (IO ())
ptr_glFlush = unsafePerformIO $ getCommand "glFlush"

-- glFlushMappedBufferRange ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFlushMappedBufferRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFlushMappedBufferRange.xhtml OpenGL 4.x>
glFlushMappedBufferRange
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glFlushMappedBufferRange v1 v2 v3 = liftIO $ dyn_glFlushMappedBufferRange ptr_glFlushMappedBufferRange v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFlushMappedBufferRange
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glFlushMappedBufferRange #-}
ptr_glFlushMappedBufferRange :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRange = unsafePerformIO $ getCommand "glFlushMappedBufferRange"

-- glFlushMappedBufferRangeAPPLE -----------------------------------------------

glFlushMappedBufferRangeAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glFlushMappedBufferRangeAPPLE v1 v2 v3 = liftIO $ dyn_glFlushMappedBufferRangeAPPLE ptr_glFlushMappedBufferRangeAPPLE v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFlushMappedBufferRangeAPPLE
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glFlushMappedBufferRangeAPPLE #-}
ptr_glFlushMappedBufferRangeAPPLE :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRangeAPPLE = unsafePerformIO $ getCommand "glFlushMappedBufferRangeAPPLE"

-- glFlushMappedBufferRangeEXT -------------------------------------------------

glFlushMappedBufferRangeEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@.
  -> m ()
glFlushMappedBufferRangeEXT v1 v2 v3 = liftIO $ dyn_glFlushMappedBufferRangeEXT ptr_glFlushMappedBufferRangeEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFlushMappedBufferRangeEXT
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glFlushMappedBufferRangeEXT #-}
ptr_glFlushMappedBufferRangeEXT :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRangeEXT = unsafePerformIO $ getCommand "glFlushMappedBufferRangeEXT"

-- glFlushMappedNamedBufferRange -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glFlushMappedBufferRange.xhtml OpenGL 4.x>
glFlushMappedNamedBufferRange
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glFlushMappedNamedBufferRange v1 v2 v3 = liftIO $ dyn_glFlushMappedNamedBufferRange ptr_glFlushMappedNamedBufferRange v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFlushMappedNamedBufferRange
  :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLuint -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glFlushMappedNamedBufferRange #-}
ptr_glFlushMappedNamedBufferRange :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedNamedBufferRange = unsafePerformIO $ getCommand "glFlushMappedNamedBufferRange"

-- glFlushMappedNamedBufferRangeEXT --------------------------------------------

glFlushMappedNamedBufferRangeEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@.
  -> m ()
glFlushMappedNamedBufferRangeEXT v1 v2 v3 = liftIO $ dyn_glFlushMappedNamedBufferRangeEXT ptr_glFlushMappedNamedBufferRangeEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFlushMappedNamedBufferRangeEXT
  :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
  ->         GLuint -> GLintptr -> GLsizeiptr -> IO ()

{-# NOINLINE ptr_glFlushMappedNamedBufferRangeEXT #-}
ptr_glFlushMappedNamedBufferRangeEXT :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedNamedBufferRangeEXT = unsafePerformIO $ getCommand "glFlushMappedNamedBufferRangeEXT"

-- glFlushPixelDataRangeNV -----------------------------------------------------

glFlushPixelDataRangeNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @PixelDataRangeTargetNV@.
  -> m ()
glFlushPixelDataRangeNV v1 = liftIO $ dyn_glFlushPixelDataRangeNV ptr_glFlushPixelDataRangeNV v1

foreign import CALLCONV "dynamic" dyn_glFlushPixelDataRangeNV
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glFlushPixelDataRangeNV #-}
ptr_glFlushPixelDataRangeNV :: FunPtr (GLenum -> IO ())
ptr_glFlushPixelDataRangeNV = unsafePerformIO $ getCommand "glFlushPixelDataRangeNV"

-- glFlushRasterSGIX -----------------------------------------------------------

glFlushRasterSGIX
  :: MonadIO m
  => m ()
glFlushRasterSGIX = liftIO $ dyn_glFlushRasterSGIX ptr_glFlushRasterSGIX

foreign import CALLCONV "dynamic" dyn_glFlushRasterSGIX
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFlushRasterSGIX #-}
ptr_glFlushRasterSGIX :: FunPtr (IO ())
ptr_glFlushRasterSGIX = unsafePerformIO $ getCommand "glFlushRasterSGIX"

-- glFlushStaticDataIBM --------------------------------------------------------

glFlushStaticDataIBM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glFlushStaticDataIBM v1 = liftIO $ dyn_glFlushStaticDataIBM ptr_glFlushStaticDataIBM v1

foreign import CALLCONV "dynamic" dyn_glFlushStaticDataIBM
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glFlushStaticDataIBM #-}
ptr_glFlushStaticDataIBM :: FunPtr (GLenum -> IO ())
ptr_glFlushStaticDataIBM = unsafePerformIO $ getCommand "glFlushStaticDataIBM"

-- glFlushVertexArrayRangeAPPLE ------------------------------------------------

glFlushVertexArrayRangeAPPLE
  :: MonadIO m
  => GLsizei -- ^ @length@.
  -> Ptr a -- ^ @pointer@ pointing to @length@ elements of type @a@.
  -> m ()
glFlushVertexArrayRangeAPPLE v1 v2 = liftIO $ dyn_glFlushVertexArrayRangeAPPLE ptr_glFlushVertexArrayRangeAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glFlushVertexArrayRangeAPPLE
  :: FunPtr (GLsizei -> Ptr a -> IO ())
  ->         GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glFlushVertexArrayRangeAPPLE #-}
ptr_glFlushVertexArrayRangeAPPLE :: FunPtr (GLsizei -> Ptr a -> IO ())
ptr_glFlushVertexArrayRangeAPPLE = unsafePerformIO $ getCommand "glFlushVertexArrayRangeAPPLE"

-- glFlushVertexArrayRangeNV ---------------------------------------------------

glFlushVertexArrayRangeNV
  :: MonadIO m
  => m ()
glFlushVertexArrayRangeNV = liftIO $ dyn_glFlushVertexArrayRangeNV ptr_glFlushVertexArrayRangeNV

foreign import CALLCONV "dynamic" dyn_glFlushVertexArrayRangeNV
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFlushVertexArrayRangeNV #-}
ptr_glFlushVertexArrayRangeNV :: FunPtr (IO ())
ptr_glFlushVertexArrayRangeNV = unsafePerformIO $ getCommand "glFlushVertexArrayRangeNV"

-- glFogCoordFormatNV ----------------------------------------------------------

glFogCoordFormatNV
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glFogCoordFormatNV v1 v2 = liftIO $ dyn_glFogCoordFormatNV ptr_glFogCoordFormatNV v1 v2

foreign import CALLCONV "dynamic" dyn_glFogCoordFormatNV
  :: FunPtr (GLenum -> GLsizei -> IO ())
  ->         GLenum -> GLsizei -> IO ()

{-# NOINLINE ptr_glFogCoordFormatNV #-}
ptr_glFogCoordFormatNV :: FunPtr (GLenum -> GLsizei -> IO ())
ptr_glFogCoordFormatNV = unsafePerformIO $ getCommand "glFogCoordFormatNV"

-- glFogCoordPointer -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordPointer.xml OpenGL 2.x>
glFogCoordPointer
  :: MonadIO m
  => GLenum -- ^ @type@ of type @FogPointerTypeEXT@.
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glFogCoordPointer v1 v2 v3 = liftIO $ dyn_glFogCoordPointer ptr_glFogCoordPointer v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFogCoordPointer
  :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glFogCoordPointer #-}
ptr_glFogCoordPointer :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glFogCoordPointer = unsafePerformIO $ getCommand "glFogCoordPointer"

-- glFogCoordPointerEXT --------------------------------------------------------

glFogCoordPointerEXT
  :: MonadIO m
  => GLenum -- ^ @type@ of type @FogPointerTypeEXT@.
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glFogCoordPointerEXT v1 v2 v3 = liftIO $ dyn_glFogCoordPointerEXT ptr_glFogCoordPointerEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFogCoordPointerEXT
  :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glFogCoordPointerEXT #-}
ptr_glFogCoordPointerEXT :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glFogCoordPointerEXT = unsafePerformIO $ getCommand "glFogCoordPointerEXT"

-- glFogCoordPointerListIBM ----------------------------------------------------

glFogCoordPointerListIBM
  :: MonadIO m
  => GLenum -- ^ @type@ of type @FogPointerTypeIBM@.
  -> GLint -- ^ @stride@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @Ptr a@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glFogCoordPointerListIBM v1 v2 v3 v4 = liftIO $ dyn_glFogCoordPointerListIBM ptr_glFogCoordPointerListIBM v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFogCoordPointerListIBM
  :: FunPtr (GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
  ->         GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ()

{-# NOINLINE ptr_glFogCoordPointerListIBM #-}
ptr_glFogCoordPointerListIBM :: FunPtr (GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
ptr_glFogCoordPointerListIBM = unsafePerformIO $ getCommand "glFogCoordPointerListIBM"

-- glFogCoordd -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>
glFogCoordd
  :: MonadIO m
  => GLdouble -- ^ @coord@ of type @CoordD@.
  -> m ()
glFogCoordd v1 = liftIO $ dyn_glFogCoordd ptr_glFogCoordd v1

foreign import CALLCONV "dynamic" dyn_glFogCoordd
  :: FunPtr (GLdouble -> IO ())
  ->         GLdouble -> IO ()

{-# NOINLINE ptr_glFogCoordd #-}
ptr_glFogCoordd :: FunPtr (GLdouble -> IO ())
ptr_glFogCoordd = unsafePerformIO $ getCommand "glFogCoordd"

-- glFogCoorddEXT --------------------------------------------------------------

glFogCoorddEXT
  :: MonadIO m
  => GLdouble -- ^ @coord@ of type @CoordD@.
  -> m ()
glFogCoorddEXT v1 = liftIO $ dyn_glFogCoorddEXT ptr_glFogCoorddEXT v1

foreign import CALLCONV "dynamic" dyn_glFogCoorddEXT
  :: FunPtr (GLdouble -> IO ())
  ->         GLdouble -> IO ()

{-# NOINLINE ptr_glFogCoorddEXT #-}
ptr_glFogCoorddEXT :: FunPtr (GLdouble -> IO ())
ptr_glFogCoorddEXT = unsafePerformIO $ getCommand "glFogCoorddEXT"

-- glFogCoorddv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>
glFogCoorddv
  :: MonadIO m
  => Ptr GLdouble -- ^ @coord@ pointing to @1@ elements of type @CoordD@.
  -> m ()
glFogCoorddv v1 = liftIO $ dyn_glFogCoorddv ptr_glFogCoorddv v1

foreign import CALLCONV "dynamic" dyn_glFogCoorddv
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glFogCoorddv #-}
ptr_glFogCoorddv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glFogCoorddv = unsafePerformIO $ getCommand "glFogCoorddv"

-- glFogCoorddvEXT -------------------------------------------------------------

glFogCoorddvEXT
  :: MonadIO m
  => Ptr GLdouble -- ^ @coord@ pointing to @1@ elements of type @CoordD@.
  -> m ()
glFogCoorddvEXT v1 = liftIO $ dyn_glFogCoorddvEXT ptr_glFogCoorddvEXT v1

foreign import CALLCONV "dynamic" dyn_glFogCoorddvEXT
  :: FunPtr (Ptr GLdouble -> IO ())
  ->         Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glFogCoorddvEXT #-}
ptr_glFogCoorddvEXT :: FunPtr (Ptr GLdouble -> IO ())
ptr_glFogCoorddvEXT = unsafePerformIO $ getCommand "glFogCoorddvEXT"

-- glFogCoordf -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>
glFogCoordf
  :: MonadIO m
  => GLfloat -- ^ @coord@ of type @CoordF@.
  -> m ()
glFogCoordf v1 = liftIO $ dyn_glFogCoordf ptr_glFogCoordf v1

foreign import CALLCONV "dynamic" dyn_glFogCoordf
  :: FunPtr (GLfloat -> IO ())
  ->         GLfloat -> IO ()

{-# NOINLINE ptr_glFogCoordf #-}
ptr_glFogCoordf :: FunPtr (GLfloat -> IO ())
ptr_glFogCoordf = unsafePerformIO $ getCommand "glFogCoordf"

-- glFogCoordfEXT --------------------------------------------------------------

glFogCoordfEXT
  :: MonadIO m
  => GLfloat -- ^ @coord@ of type @CoordF@.
  -> m ()
glFogCoordfEXT v1 = liftIO $ dyn_glFogCoordfEXT ptr_glFogCoordfEXT v1

foreign import CALLCONV "dynamic" dyn_glFogCoordfEXT
  :: FunPtr (GLfloat -> IO ())
  ->         GLfloat -> IO ()

{-# NOINLINE ptr_glFogCoordfEXT #-}
ptr_glFogCoordfEXT :: FunPtr (GLfloat -> IO ())
ptr_glFogCoordfEXT = unsafePerformIO $ getCommand "glFogCoordfEXT"

-- glFogCoordfv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>
glFogCoordfv
  :: MonadIO m
  => Ptr GLfloat -- ^ @coord@ pointing to @1@ elements of type @CoordF@.
  -> m ()
glFogCoordfv v1 = liftIO $ dyn_glFogCoordfv ptr_glFogCoordfv v1

foreign import CALLCONV "dynamic" dyn_glFogCoordfv
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFogCoordfv #-}
ptr_glFogCoordfv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glFogCoordfv = unsafePerformIO $ getCommand "glFogCoordfv"

-- glFogCoordfvEXT -------------------------------------------------------------

glFogCoordfvEXT
  :: MonadIO m
  => Ptr GLfloat -- ^ @coord@ pointing to @1@ elements of type @CoordF@.
  -> m ()
glFogCoordfvEXT v1 = liftIO $ dyn_glFogCoordfvEXT ptr_glFogCoordfvEXT v1

foreign import CALLCONV "dynamic" dyn_glFogCoordfvEXT
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFogCoordfvEXT #-}
ptr_glFogCoordfvEXT :: FunPtr (Ptr GLfloat -> IO ())
ptr_glFogCoordfvEXT = unsafePerformIO $ getCommand "glFogCoordfvEXT"

-- glFogCoordhNV ---------------------------------------------------------------

glFogCoordhNV
  :: MonadIO m
  => GLhalfNV -- ^ @fog@ of type @Half16NV@.
  -> m ()
glFogCoordhNV v1 = liftIO $ dyn_glFogCoordhNV ptr_glFogCoordhNV v1

foreign import CALLCONV "dynamic" dyn_glFogCoordhNV
  :: FunPtr (GLhalfNV -> IO ())
  ->         GLhalfNV -> IO ()

{-# NOINLINE ptr_glFogCoordhNV #-}
ptr_glFogCoordhNV :: FunPtr (GLhalfNV -> IO ())
ptr_glFogCoordhNV = unsafePerformIO $ getCommand "glFogCoordhNV"

-- glFogCoordhvNV --------------------------------------------------------------

glFogCoordhvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @fog@ pointing to @1@ elements of type @Half16NV@.
  -> m ()
glFogCoordhvNV v1 = liftIO $ dyn_glFogCoordhvNV ptr_glFogCoordhvNV v1

foreign import CALLCONV "dynamic" dyn_glFogCoordhvNV
  :: FunPtr (Ptr GLhalfNV -> IO ())
  ->         Ptr GLhalfNV -> IO ()

{-# NOINLINE ptr_glFogCoordhvNV #-}
ptr_glFogCoordhvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glFogCoordhvNV = unsafePerformIO $ getCommand "glFogCoordhvNV"

-- glFogFuncSGIS ---------------------------------------------------------------

glFogFuncSGIS
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @points@ pointing to @n*2@ elements of type @GLfloat@.
  -> m ()
glFogFuncSGIS v1 v2 = liftIO $ dyn_glFogFuncSGIS ptr_glFogFuncSGIS v1 v2

foreign import CALLCONV "dynamic" dyn_glFogFuncSGIS
  :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
  ->         GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFogFuncSGIS #-}
ptr_glFogFuncSGIS :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glFogFuncSGIS = unsafePerformIO $ getCommand "glFogFuncSGIS"

-- glFogf ----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>
glFogf
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FogParameter@.
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFogf v1 v2 = liftIO $ dyn_glFogf ptr_glFogf v1 v2

foreign import CALLCONV "dynamic" dyn_glFogf
  :: FunPtr (GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glFogf #-}
ptr_glFogf :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glFogf = unsafePerformIO $ getCommand "glFogf"

-- glFogfv ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>
glFogfv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FogParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFogfv v1 v2 = liftIO $ dyn_glFogfv ptr_glFogfv v1 v2

foreign import CALLCONV "dynamic" dyn_glFogfv
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFogfv #-}
ptr_glFogfv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glFogfv = unsafePerformIO $ getCommand "glFogfv"

-- glFogi ----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>
glFogi
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FogParameter@.
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFogi v1 v2 = liftIO $ dyn_glFogi ptr_glFogi v1 v2

foreign import CALLCONV "dynamic" dyn_glFogi
  :: FunPtr (GLenum -> GLint -> IO ())
  ->         GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFogi #-}
ptr_glFogi :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFogi = unsafePerformIO $ getCommand "glFogi"

-- glFogiv ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>
glFogiv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FogParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFogiv v1 v2 = liftIO $ dyn_glFogiv ptr_glFogiv v1 v2

foreign import CALLCONV "dynamic" dyn_glFogiv
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glFogiv #-}
ptr_glFogiv :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glFogiv = unsafePerformIO $ getCommand "glFogiv"

-- glFogx ----------------------------------------------------------------------

glFogx
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glFogx v1 v2 = liftIO $ dyn_glFogx ptr_glFogx v1 v2

foreign import CALLCONV "dynamic" dyn_glFogx
  :: FunPtr (GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glFogx #-}
ptr_glFogx :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glFogx = unsafePerformIO $ getCommand "glFogx"

-- glFogxOES -------------------------------------------------------------------

glFogxOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glFogxOES v1 v2 = liftIO $ dyn_glFogxOES ptr_glFogxOES v1 v2

foreign import CALLCONV "dynamic" dyn_glFogxOES
  :: FunPtr (GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glFogxOES #-}
ptr_glFogxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glFogxOES = unsafePerformIO $ getCommand "glFogxOES"

-- glFogxv ---------------------------------------------------------------------

glFogxv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glFogxv v1 v2 = liftIO $ dyn_glFogxv ptr_glFogxv v1 v2

foreign import CALLCONV "dynamic" dyn_glFogxv
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glFogxv #-}
ptr_glFogxv :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glFogxv = unsafePerformIO $ getCommand "glFogxv"

-- glFogxvOES ------------------------------------------------------------------

glFogxvOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glFogxvOES v1 v2 = liftIO $ dyn_glFogxvOES ptr_glFogxvOES v1 v2

foreign import CALLCONV "dynamic" dyn_glFogxvOES
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glFogxvOES #-}
ptr_glFogxvOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glFogxvOES = unsafePerformIO $ getCommand "glFogxvOES"

-- glFragmentColorMaterialSGIX -------------------------------------------------

glFragmentColorMaterialSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @mode@ of type @MaterialParameter@.
  -> m ()
glFragmentColorMaterialSGIX v1 v2 = liftIO $ dyn_glFragmentColorMaterialSGIX ptr_glFragmentColorMaterialSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glFragmentColorMaterialSGIX
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glFragmentColorMaterialSGIX #-}
ptr_glFragmentColorMaterialSGIX :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glFragmentColorMaterialSGIX = unsafePerformIO $ getCommand "glFragmentColorMaterialSGIX"

-- glFragmentCoverageColorNV ---------------------------------------------------

glFragmentCoverageColorNV
  :: MonadIO m
  => GLuint -- ^ @color@.
  -> m ()
glFragmentCoverageColorNV v1 = liftIO $ dyn_glFragmentCoverageColorNV ptr_glFragmentCoverageColorNV v1

foreign import CALLCONV "dynamic" dyn_glFragmentCoverageColorNV
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glFragmentCoverageColorNV #-}
ptr_glFragmentCoverageColorNV :: FunPtr (GLuint -> IO ())
ptr_glFragmentCoverageColorNV = unsafePerformIO $ getCommand "glFragmentCoverageColorNV"

-- glFragmentLightModelfSGIX ---------------------------------------------------

glFragmentLightModelfSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FragmentLightModelParameterSGIX@.
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentLightModelfSGIX v1 v2 = liftIO $ dyn_glFragmentLightModelfSGIX ptr_glFragmentLightModelfSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glFragmentLightModelfSGIX
  :: FunPtr (GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentLightModelfSGIX #-}
ptr_glFragmentLightModelfSGIX :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glFragmentLightModelfSGIX = unsafePerformIO $ getCommand "glFragmentLightModelfSGIX"

-- glFragmentLightModelfvSGIX --------------------------------------------------

glFragmentLightModelfvSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FragmentLightModelParameterSGIX@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentLightModelfvSGIX v1 v2 = liftIO $ dyn_glFragmentLightModelfvSGIX ptr_glFragmentLightModelfvSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glFragmentLightModelfvSGIX
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentLightModelfvSGIX #-}
ptr_glFragmentLightModelfvSGIX :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentLightModelfvSGIX = unsafePerformIO $ getCommand "glFragmentLightModelfvSGIX"

-- glFragmentLightModeliSGIX ---------------------------------------------------

glFragmentLightModeliSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FragmentLightModelParameterSGIX@.
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentLightModeliSGIX v1 v2 = liftIO $ dyn_glFragmentLightModeliSGIX ptr_glFragmentLightModeliSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glFragmentLightModeliSGIX
  :: FunPtr (GLenum -> GLint -> IO ())
  ->         GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFragmentLightModeliSGIX #-}
ptr_glFragmentLightModeliSGIX :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFragmentLightModeliSGIX = unsafePerformIO $ getCommand "glFragmentLightModeliSGIX"

-- glFragmentLightModelivSGIX --------------------------------------------------

glFragmentLightModelivSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @FragmentLightModelParameterSGIX@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentLightModelivSGIX v1 v2 = liftIO $ dyn_glFragmentLightModelivSGIX ptr_glFragmentLightModelivSGIX v1 v2

foreign import CALLCONV "dynamic" dyn_glFragmentLightModelivSGIX
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glFragmentLightModelivSGIX #-}
ptr_glFragmentLightModelivSGIX :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glFragmentLightModelivSGIX = unsafePerformIO $ getCommand "glFragmentLightModelivSGIX"

-- glFragmentLightfSGIX --------------------------------------------------------

glFragmentLightfSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentLightfSGIX v1 v2 v3 = liftIO $ dyn_glFragmentLightfSGIX ptr_glFragmentLightfSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentLightfSGIX
  :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentLightfSGIX #-}
ptr_glFragmentLightfSGIX :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glFragmentLightfSGIX = unsafePerformIO $ getCommand "glFragmentLightfSGIX"

-- glFragmentLightfvSGIX -------------------------------------------------------

glFragmentLightfvSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentLightfvSGIX v1 v2 v3 = liftIO $ dyn_glFragmentLightfvSGIX ptr_glFragmentLightfvSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentLightfvSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentLightfvSGIX #-}
ptr_glFragmentLightfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentLightfvSGIX = unsafePerformIO $ getCommand "glFragmentLightfvSGIX"

-- glFragmentLightiSGIX --------------------------------------------------------

glFragmentLightiSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentLightiSGIX v1 v2 v3 = liftIO $ dyn_glFragmentLightiSGIX ptr_glFragmentLightiSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentLightiSGIX
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFragmentLightiSGIX #-}
ptr_glFragmentLightiSGIX :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFragmentLightiSGIX = unsafePerformIO $ getCommand "glFragmentLightiSGIX"

-- glFragmentLightivSGIX -------------------------------------------------------

glFragmentLightivSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentLightivSGIX v1 v2 v3 = liftIO $ dyn_glFragmentLightivSGIX ptr_glFragmentLightivSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentLightivSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glFragmentLightivSGIX #-}
ptr_glFragmentLightivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glFragmentLightivSGIX = unsafePerformIO $ getCommand "glFragmentLightivSGIX"

-- glFragmentMaterialfSGIX -----------------------------------------------------

glFragmentMaterialfSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentMaterialfSGIX v1 v2 v3 = liftIO $ dyn_glFragmentMaterialfSGIX ptr_glFragmentMaterialfSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentMaterialfSGIX
  :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentMaterialfSGIX #-}
ptr_glFragmentMaterialfSGIX :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glFragmentMaterialfSGIX = unsafePerformIO $ getCommand "glFragmentMaterialfSGIX"

-- glFragmentMaterialfvSGIX ----------------------------------------------------

glFragmentMaterialfvSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentMaterialfvSGIX v1 v2 v3 = liftIO $ dyn_glFragmentMaterialfvSGIX ptr_glFragmentMaterialfvSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentMaterialfvSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFragmentMaterialfvSGIX #-}
ptr_glFragmentMaterialfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentMaterialfvSGIX = unsafePerformIO $ getCommand "glFragmentMaterialfvSGIX"

-- glFragmentMaterialiSGIX -----------------------------------------------------

glFragmentMaterialiSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentMaterialiSGIX v1 v2 v3 = liftIO $ dyn_glFragmentMaterialiSGIX ptr_glFragmentMaterialiSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentMaterialiSGIX
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFragmentMaterialiSGIX #-}
ptr_glFragmentMaterialiSGIX :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFragmentMaterialiSGIX = unsafePerformIO $ getCommand "glFragmentMaterialiSGIX"

-- glFragmentMaterialivSGIX ----------------------------------------------------

glFragmentMaterialivSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentMaterialivSGIX v1 v2 v3 = liftIO $ dyn_glFragmentMaterialivSGIX ptr_glFragmentMaterialivSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFragmentMaterialivSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glFragmentMaterialivSGIX #-}
ptr_glFragmentMaterialivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glFragmentMaterialivSGIX = unsafePerformIO $ getCommand "glFragmentMaterialivSGIX"

-- glFrameTerminatorGREMEDY ----------------------------------------------------

glFrameTerminatorGREMEDY
  :: MonadIO m
  => m ()
glFrameTerminatorGREMEDY = liftIO $ dyn_glFrameTerminatorGREMEDY ptr_glFrameTerminatorGREMEDY

foreign import CALLCONV "dynamic" dyn_glFrameTerminatorGREMEDY
  :: FunPtr (IO ())
  ->         IO ()

{-# NOINLINE ptr_glFrameTerminatorGREMEDY #-}
ptr_glFrameTerminatorGREMEDY :: FunPtr (IO ())
ptr_glFrameTerminatorGREMEDY = unsafePerformIO $ getCommand "glFrameTerminatorGREMEDY"

-- glFrameZoomSGIX -------------------------------------------------------------

glFrameZoomSGIX
  :: MonadIO m
  => GLint -- ^ @factor@ of type @CheckedInt32@.
  -> m ()
glFrameZoomSGIX v1 = liftIO $ dyn_glFrameZoomSGIX ptr_glFrameZoomSGIX v1

foreign import CALLCONV "dynamic" dyn_glFrameZoomSGIX
  :: FunPtr (GLint -> IO ())
  ->         GLint -> IO ()

{-# NOINLINE ptr_glFrameZoomSGIX #-}
ptr_glFrameZoomSGIX :: FunPtr (GLint -> IO ())
ptr_glFrameZoomSGIX = unsafePerformIO $ getCommand "glFrameZoomSGIX"

-- glFramebufferDrawBufferEXT --------------------------------------------------

glFramebufferDrawBufferEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @mode@ of type @DrawBufferMode@.
  -> m ()
glFramebufferDrawBufferEXT v1 v2 = liftIO $ dyn_glFramebufferDrawBufferEXT ptr_glFramebufferDrawBufferEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glFramebufferDrawBufferEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glFramebufferDrawBufferEXT #-}
ptr_glFramebufferDrawBufferEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glFramebufferDrawBufferEXT = unsafePerformIO $ getCommand "glFramebufferDrawBufferEXT"

-- glFramebufferDrawBuffersEXT -------------------------------------------------

glFramebufferDrawBuffersEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferMode@.
  -> m ()
glFramebufferDrawBuffersEXT v1 v2 v3 = liftIO $ dyn_glFramebufferDrawBuffersEXT ptr_glFramebufferDrawBuffersEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFramebufferDrawBuffersEXT
  :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLenum -> IO ()

{-# NOINLINE ptr_glFramebufferDrawBuffersEXT #-}
ptr_glFramebufferDrawBuffersEXT :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> IO ())
ptr_glFramebufferDrawBuffersEXT = unsafePerformIO $ getCommand "glFramebufferDrawBuffersEXT"

-- glFramebufferParameteri -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glFramebufferParameteri.xhtml OpenGL 4.x>
glFramebufferParameteri
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glFramebufferParameteri v1 v2 v3 = liftIO $ dyn_glFramebufferParameteri ptr_glFramebufferParameteri v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glFramebufferParameteri
  :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferParameteri #-}
ptr_glFramebufferParameteri :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFramebufferParameteri = unsafePerformIO $ getCommand "glFramebufferParameteri"

-- glFramebufferReadBufferEXT --------------------------------------------------

glFramebufferReadBufferEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @mode@ of type @ReadBufferMode@.
  -> m ()
glFramebufferReadBufferEXT v1 v2 = liftIO $ dyn_glFramebufferReadBufferEXT ptr_glFramebufferReadBufferEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glFramebufferReadBufferEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glFramebufferReadBufferEXT #-}
ptr_glFramebufferReadBufferEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glFramebufferReadBufferEXT = unsafePerformIO $ getCommand "glFramebufferReadBufferEXT"

-- glFramebufferRenderbuffer ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferRenderbuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferRenderbuffer.xhtml OpenGL 4.x>
glFramebufferRenderbuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @renderbuffertarget@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbuffer v1 v2 v3 v4 = liftIO $ dyn_glFramebufferRenderbuffer ptr_glFramebufferRenderbuffer v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferRenderbuffer
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glFramebufferRenderbuffer #-}
ptr_glFramebufferRenderbuffer :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbuffer = unsafePerformIO $ getCommand "glFramebufferRenderbuffer"

-- glFramebufferRenderbufferEXT ------------------------------------------------

glFramebufferRenderbufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @renderbuffertarget@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbufferEXT v1 v2 v3 v4 = liftIO $ dyn_glFramebufferRenderbufferEXT ptr_glFramebufferRenderbufferEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferRenderbufferEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glFramebufferRenderbufferEXT #-}
ptr_glFramebufferRenderbufferEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbufferEXT = unsafePerformIO $ getCommand "glFramebufferRenderbufferEXT"

-- glFramebufferRenderbufferOES ------------------------------------------------

glFramebufferRenderbufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @renderbuffertarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbufferOES v1 v2 v3 v4 = liftIO $ dyn_glFramebufferRenderbufferOES ptr_glFramebufferRenderbufferOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferRenderbufferOES
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> IO ()

{-# NOINLINE ptr_glFramebufferRenderbufferOES #-}
ptr_glFramebufferRenderbufferOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbufferOES = unsafePerformIO $ getCommand "glFramebufferRenderbufferOES"

-- glFramebufferSampleLocationsfvNV --------------------------------------------

glFramebufferSampleLocationsfvNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glFramebufferSampleLocationsfvNV v1 v2 v3 v4 = liftIO $ dyn_glFramebufferSampleLocationsfvNV ptr_glFramebufferSampleLocationsfvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferSampleLocationsfvNV
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glFramebufferSampleLocationsfvNV #-}
ptr_glFramebufferSampleLocationsfvNV :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glFramebufferSampleLocationsfvNV = unsafePerformIO $ getCommand "glFramebufferSampleLocationsfvNV"

-- glFramebufferTexture --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>
glFramebufferTexture
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture v1 v2 v3 v4 = liftIO $ dyn_glFramebufferTexture ptr_glFramebufferTexture v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture #-}
ptr_glFramebufferTexture :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture = unsafePerformIO $ getCommand "glFramebufferTexture"

-- glFramebufferTexture1D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>
glFramebufferTexture1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture1D v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTexture1D ptr_glFramebufferTexture1D v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture1D
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture1D #-}
ptr_glFramebufferTexture1D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture1D = unsafePerformIO $ getCommand "glFramebufferTexture1D"

-- glFramebufferTexture1DEXT ---------------------------------------------------

glFramebufferTexture1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture1DEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTexture1DEXT ptr_glFramebufferTexture1DEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture1DEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture1DEXT #-}
ptr_glFramebufferTexture1DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture1DEXT = unsafePerformIO $ getCommand "glFramebufferTexture1DEXT"

-- glFramebufferTexture2D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>
glFramebufferTexture2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2D v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTexture2D ptr_glFramebufferTexture2D v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture2D
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture2D #-}
ptr_glFramebufferTexture2D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2D = unsafePerformIO $ getCommand "glFramebufferTexture2D"

-- glFramebufferTexture2DEXT ---------------------------------------------------

glFramebufferTexture2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2DEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTexture2DEXT ptr_glFramebufferTexture2DEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture2DEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture2DEXT #-}
ptr_glFramebufferTexture2DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2DEXT = unsafePerformIO $ getCommand "glFramebufferTexture2DEXT"

-- glFramebufferTexture2DMultisampleEXT ----------------------------------------

glFramebufferTexture2DMultisampleEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @samples@.
  -> m ()
glFramebufferTexture2DMultisampleEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFramebufferTexture2DMultisampleEXT ptr_glFramebufferTexture2DMultisampleEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture2DMultisampleEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glFramebufferTexture2DMultisampleEXT #-}
ptr_glFramebufferTexture2DMultisampleEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTexture2DMultisampleEXT = unsafePerformIO $ getCommand "glFramebufferTexture2DMultisampleEXT"

-- glFramebufferTexture2DMultisampleIMG ----------------------------------------

glFramebufferTexture2DMultisampleIMG
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @samples@.
  -> m ()
glFramebufferTexture2DMultisampleIMG v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFramebufferTexture2DMultisampleIMG ptr_glFramebufferTexture2DMultisampleIMG v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture2DMultisampleIMG
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ()

{-# NOINLINE ptr_glFramebufferTexture2DMultisampleIMG #-}
ptr_glFramebufferTexture2DMultisampleIMG :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTexture2DMultisampleIMG = unsafePerformIO $ getCommand "glFramebufferTexture2DMultisampleIMG"

-- glFramebufferTexture2DOES ---------------------------------------------------

glFramebufferTexture2DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2DOES v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTexture2DOES ptr_glFramebufferTexture2DOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture2DOES
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture2DOES #-}
ptr_glFramebufferTexture2DOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2DOES = unsafePerformIO $ getCommand "glFramebufferTexture2DOES"

-- glFramebufferTexture3D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>
glFramebufferTexture3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3D v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFramebufferTexture3D ptr_glFramebufferTexture3D v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture3D
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture3D #-}
ptr_glFramebufferTexture3D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3D = unsafePerformIO $ getCommand "glFramebufferTexture3D"

-- glFramebufferTexture3DEXT ---------------------------------------------------

glFramebufferTexture3DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFramebufferTexture3DEXT ptr_glFramebufferTexture3DEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture3DEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture3DEXT #-}
ptr_glFramebufferTexture3DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3DEXT = unsafePerformIO $ getCommand "glFramebufferTexture3DEXT"

-- glFramebufferTexture3DOES ---------------------------------------------------

glFramebufferTexture3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3DOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFramebufferTexture3DOES ptr_glFramebufferTexture3DOES v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFramebufferTexture3DOES
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTexture3DOES #-}
ptr_glFramebufferTexture3DOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3DOES = unsafePerformIO $ getCommand "glFramebufferTexture3DOES"

-- glFramebufferTextureARB -----------------------------------------------------

glFramebufferTextureARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureARB v1 v2 v3 v4 = liftIO $ dyn_glFramebufferTextureARB ptr_glFramebufferTextureARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureARB
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureARB #-}
ptr_glFramebufferTextureARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureARB = unsafePerformIO $ getCommand "glFramebufferTextureARB"

-- glFramebufferTextureEXT -----------------------------------------------------

glFramebufferTextureEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureEXT v1 v2 v3 v4 = liftIO $ dyn_glFramebufferTextureEXT ptr_glFramebufferTextureEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureEXT
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureEXT #-}
ptr_glFramebufferTextureEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureEXT = unsafePerformIO $ getCommand "glFramebufferTextureEXT"

-- glFramebufferTextureFaceARB -------------------------------------------------

glFramebufferTextureFaceARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @face@ of type @TextureTarget@.
  -> m ()
glFramebufferTextureFaceARB v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTextureFaceARB ptr_glFramebufferTextureFaceARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureFaceARB
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ()

{-# NOINLINE ptr_glFramebufferTextureFaceARB #-}
ptr_glFramebufferTextureFaceARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
ptr_glFramebufferTextureFaceARB = unsafePerformIO $ getCommand "glFramebufferTextureFaceARB"

-- glFramebufferTextureFaceEXT -------------------------------------------------

glFramebufferTextureFaceEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @face@ of type @TextureTarget@.
  -> m ()
glFramebufferTextureFaceEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTextureFaceEXT ptr_glFramebufferTextureFaceEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureFaceEXT
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ()

{-# NOINLINE ptr_glFramebufferTextureFaceEXT #-}
ptr_glFramebufferTextureFaceEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
ptr_glFramebufferTextureFaceEXT = unsafePerformIO $ getCommand "glFramebufferTextureFaceEXT"

-- glFramebufferTextureLayer ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTextureLayer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTextureLayer.xhtml OpenGL 4.x>
glFramebufferTextureLayer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayer v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTextureLayer ptr_glFramebufferTextureLayer v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureLayer
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureLayer #-}
ptr_glFramebufferTextureLayer :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayer = unsafePerformIO $ getCommand "glFramebufferTextureLayer"

-- glFramebufferTextureLayerARB ------------------------------------------------

glFramebufferTextureLayerARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayerARB v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTextureLayerARB ptr_glFramebufferTextureLayerARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureLayerARB
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureLayerARB #-}
ptr_glFramebufferTextureLayerARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayerARB = unsafePerformIO $ getCommand "glFramebufferTextureLayerARB"

-- glFramebufferTextureLayerEXT ------------------------------------------------

glFramebufferTextureLayerEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayerEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glFramebufferTextureLayerEXT ptr_glFramebufferTextureLayerEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureLayerEXT
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureLayerEXT #-}
ptr_glFramebufferTextureLayerEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayerEXT = unsafePerformIO $ getCommand "glFramebufferTextureLayerEXT"

-- glFramebufferTextureOES -----------------------------------------------------

glFramebufferTextureOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureOES v1 v2 v3 v4 = liftIO $ dyn_glFramebufferTextureOES ptr_glFramebufferTextureOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glFramebufferTextureOES
  :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
  ->         GLenum -> GLenum -> GLuint -> GLint -> IO ()

{-# NOINLINE ptr_glFramebufferTextureOES #-}
ptr_glFramebufferTextureOES :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureOES = unsafePerformIO $ getCommand "glFramebufferTextureOES"

-- glFreeObjectBufferATI -------------------------------------------------------

glFreeObjectBufferATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m ()
glFreeObjectBufferATI v1 = liftIO $ dyn_glFreeObjectBufferATI ptr_glFreeObjectBufferATI v1

foreign import CALLCONV "dynamic" dyn_glFreeObjectBufferATI
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glFreeObjectBufferATI #-}
ptr_glFreeObjectBufferATI :: FunPtr (GLuint -> IO ())
ptr_glFreeObjectBufferATI = unsafePerformIO $ getCommand "glFreeObjectBufferATI"

-- glFrontFace -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFrontFace.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFrontFace.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFrontFace.xhtml OpenGL 4.x>
glFrontFace
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @FrontFaceDirection@.
  -> m ()
glFrontFace v1 = liftIO $ dyn_glFrontFace ptr_glFrontFace v1

foreign import CALLCONV "dynamic" dyn_glFrontFace
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glFrontFace #-}
ptr_glFrontFace :: FunPtr (GLenum -> IO ())
ptr_glFrontFace = unsafePerformIO $ getCommand "glFrontFace"

-- glFrustum -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFrustum.xml OpenGL 2.x>
glFrustum
  :: MonadIO m
  => GLdouble -- ^ @left@.
  -> GLdouble -- ^ @right@.
  -> GLdouble -- ^ @bottom@.
  -> GLdouble -- ^ @top@.
  -> GLdouble -- ^ @zNear@.
  -> GLdouble -- ^ @zFar@.
  -> m ()
glFrustum v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFrustum ptr_glFrustum v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFrustum
  :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
  ->         GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ()

{-# NOINLINE ptr_glFrustum #-}
ptr_glFrustum :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glFrustum = unsafePerformIO $ getCommand "glFrustum"

-- glFrustumf ------------------------------------------------------------------

glFrustumf
  :: MonadIO m
  => GLfloat -- ^ @l@.
  -> GLfloat -- ^ @r@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @t@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glFrustumf v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFrustumf ptr_glFrustumf v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFrustumf
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glFrustumf #-}
ptr_glFrustumf :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glFrustumf = unsafePerformIO $ getCommand "glFrustumf"

-- glFrustumfOES ---------------------------------------------------------------

glFrustumfOES
  :: MonadIO m
  => GLfloat -- ^ @l@.
  -> GLfloat -- ^ @r@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @t@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glFrustumfOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFrustumfOES ptr_glFrustumfOES v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFrustumfOES
  :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
  ->         GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ()

{-# NOINLINE ptr_glFrustumfOES #-}
ptr_glFrustumfOES :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glFrustumfOES = unsafePerformIO $ getCommand "glFrustumfOES"

-- glFrustumx ------------------------------------------------------------------

glFrustumx
  :: MonadIO m
  => GLfixed -- ^ @l@.
  -> GLfixed -- ^ @r@.
  -> GLfixed -- ^ @b@.
  -> GLfixed -- ^ @t@.
  -> GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glFrustumx v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFrustumx ptr_glFrustumx v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFrustumx
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glFrustumx #-}
ptr_glFrustumx :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glFrustumx = unsafePerformIO $ getCommand "glFrustumx"

-- glFrustumxOES ---------------------------------------------------------------

glFrustumxOES
  :: MonadIO m
  => GLfixed -- ^ @l@.
  -> GLfixed -- ^ @r@.
  -> GLfixed -- ^ @b@.
  -> GLfixed -- ^ @t@.
  -> GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glFrustumxOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glFrustumxOES ptr_glFrustumxOES v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glFrustumxOES
  :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
  ->         GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ()

{-# NOINLINE ptr_glFrustumxOES #-}
ptr_glFrustumxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glFrustumxOES = unsafePerformIO $ getCommand "glFrustumxOES"

-- glGenAsyncMarkersSGIX -------------------------------------------------------

glGenAsyncMarkersSGIX
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint
glGenAsyncMarkersSGIX v1 = liftIO $ dyn_glGenAsyncMarkersSGIX ptr_glGenAsyncMarkersSGIX v1

foreign import CALLCONV "dynamic" dyn_glGenAsyncMarkersSGIX
  :: FunPtr (GLsizei -> IO GLuint)
  ->         GLsizei -> IO GLuint

{-# NOINLINE ptr_glGenAsyncMarkersSGIX #-}
ptr_glGenAsyncMarkersSGIX :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenAsyncMarkersSGIX = unsafePerformIO $ getCommand "glGenAsyncMarkersSGIX"

-- glGenBuffers ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenBuffers.xhtml OpenGL 4.x>
glGenBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenBuffers v1 v2 = liftIO $ dyn_glGenBuffers ptr_glGenBuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glGenBuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenBuffers #-}
ptr_glGenBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenBuffers = unsafePerformIO $ getCommand "glGenBuffers"

-- glGenBuffersARB -------------------------------------------------------------

glGenBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenBuffersARB v1 v2 = liftIO $ dyn_glGenBuffersARB ptr_glGenBuffersARB v1 v2

foreign import CALLCONV "dynamic" dyn_glGenBuffersARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenBuffersARB #-}
ptr_glGenBuffersARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenBuffersARB = unsafePerformIO $ getCommand "glGenBuffersARB"

-- glGenFencesAPPLE ------------------------------------------------------------

glGenFencesAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glGenFencesAPPLE v1 v2 = liftIO $ dyn_glGenFencesAPPLE ptr_glGenFencesAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glGenFencesAPPLE
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenFencesAPPLE #-}
ptr_glGenFencesAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFencesAPPLE = unsafePerformIO $ getCommand "glGenFencesAPPLE"

-- glGenFencesNV ---------------------------------------------------------------

glGenFencesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glGenFencesNV v1 v2 = liftIO $ dyn_glGenFencesNV ptr_glGenFencesNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGenFencesNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenFencesNV #-}
ptr_glGenFencesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFencesNV = unsafePerformIO $ getCommand "glGenFencesNV"

-- glGenFragmentShadersATI -----------------------------------------------------

glGenFragmentShadersATI
  :: MonadIO m
  => GLuint -- ^ @range@.
  -> m GLuint
glGenFragmentShadersATI v1 = liftIO $ dyn_glGenFragmentShadersATI ptr_glGenFragmentShadersATI v1

foreign import CALLCONV "dynamic" dyn_glGenFragmentShadersATI
  :: FunPtr (GLuint -> IO GLuint)
  ->         GLuint -> IO GLuint

{-# NOINLINE ptr_glGenFragmentShadersATI #-}
ptr_glGenFragmentShadersATI :: FunPtr (GLuint -> IO GLuint)
ptr_glGenFragmentShadersATI = unsafePerformIO $ getCommand "glGenFragmentShadersATI"

-- glGenFramebuffers -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenFramebuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenFramebuffers.xhtml OpenGL 4.x>
glGenFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffers v1 v2 = liftIO $ dyn_glGenFramebuffers ptr_glGenFramebuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glGenFramebuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenFramebuffers #-}
ptr_glGenFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffers = unsafePerformIO $ getCommand "glGenFramebuffers"

-- glGenFramebuffersEXT --------------------------------------------------------

glGenFramebuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffersEXT v1 v2 = liftIO $ dyn_glGenFramebuffersEXT ptr_glGenFramebuffersEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenFramebuffersEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenFramebuffersEXT #-}
ptr_glGenFramebuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffersEXT = unsafePerformIO $ getCommand "glGenFramebuffersEXT"

-- glGenFramebuffersOES --------------------------------------------------------

glGenFramebuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffersOES v1 v2 = liftIO $ dyn_glGenFramebuffersOES ptr_glGenFramebuffersOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGenFramebuffersOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenFramebuffersOES #-}
ptr_glGenFramebuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffersOES = unsafePerformIO $ getCommand "glGenFramebuffersOES"

-- glGenLists ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenLists.xml OpenGL 2.x>
glGenLists
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint -- ^ of type @List@.
glGenLists v1 = liftIO $ dyn_glGenLists ptr_glGenLists v1

foreign import CALLCONV "dynamic" dyn_glGenLists
  :: FunPtr (GLsizei -> IO GLuint)
  ->         GLsizei -> IO GLuint

{-# NOINLINE ptr_glGenLists #-}
ptr_glGenLists :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenLists = unsafePerformIO $ getCommand "glGenLists"

-- glGenNamesAMD ---------------------------------------------------------------

glGenNamesAMD
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @num@.
  -> Ptr GLuint -- ^ @names@ pointing to @num@ elements of type @GLuint@.
  -> m ()
glGenNamesAMD v1 v2 v3 = liftIO $ dyn_glGenNamesAMD ptr_glGenNamesAMD v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGenNamesAMD
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenNamesAMD #-}
ptr_glGenNamesAMD :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGenNamesAMD = unsafePerformIO $ getCommand "glGenNamesAMD"

-- glGenOcclusionQueriesNV -----------------------------------------------------

glGenOcclusionQueriesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenOcclusionQueriesNV v1 v2 = liftIO $ dyn_glGenOcclusionQueriesNV ptr_glGenOcclusionQueriesNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGenOcclusionQueriesNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenOcclusionQueriesNV #-}
ptr_glGenOcclusionQueriesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenOcclusionQueriesNV = unsafePerformIO $ getCommand "glGenOcclusionQueriesNV"

-- glGenPathsNV ----------------------------------------------------------------

glGenPathsNV
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint -- ^ of type @Path@.
glGenPathsNV v1 = liftIO $ dyn_glGenPathsNV ptr_glGenPathsNV v1

foreign import CALLCONV "dynamic" dyn_glGenPathsNV
  :: FunPtr (GLsizei -> IO GLuint)
  ->         GLsizei -> IO GLuint

{-# NOINLINE ptr_glGenPathsNV #-}
ptr_glGenPathsNV :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenPathsNV = unsafePerformIO $ getCommand "glGenPathsNV"

-- glGenPerfMonitorsAMD --------------------------------------------------------

glGenPerfMonitorsAMD
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @monitors@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenPerfMonitorsAMD v1 v2 = liftIO $ dyn_glGenPerfMonitorsAMD ptr_glGenPerfMonitorsAMD v1 v2

foreign import CALLCONV "dynamic" dyn_glGenPerfMonitorsAMD
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenPerfMonitorsAMD #-}
ptr_glGenPerfMonitorsAMD :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenPerfMonitorsAMD = unsafePerformIO $ getCommand "glGenPerfMonitorsAMD"

-- glGenProgramPipelines -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenProgramPipelines.xhtml OpenGL 4.x>
glGenProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramPipelines v1 v2 = liftIO $ dyn_glGenProgramPipelines ptr_glGenProgramPipelines v1 v2

foreign import CALLCONV "dynamic" dyn_glGenProgramPipelines
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenProgramPipelines #-}
ptr_glGenProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramPipelines = unsafePerformIO $ getCommand "glGenProgramPipelines"

-- glGenProgramPipelinesEXT ----------------------------------------------------

glGenProgramPipelinesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramPipelinesEXT v1 v2 = liftIO $ dyn_glGenProgramPipelinesEXT ptr_glGenProgramPipelinesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenProgramPipelinesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenProgramPipelinesEXT #-}
ptr_glGenProgramPipelinesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramPipelinesEXT = unsafePerformIO $ getCommand "glGenProgramPipelinesEXT"

-- glGenProgramsARB ------------------------------------------------------------

glGenProgramsARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramsARB v1 v2 = liftIO $ dyn_glGenProgramsARB ptr_glGenProgramsARB v1 v2

foreign import CALLCONV "dynamic" dyn_glGenProgramsARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenProgramsARB #-}
ptr_glGenProgramsARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramsARB = unsafePerformIO $ getCommand "glGenProgramsARB"

-- glGenProgramsNV -------------------------------------------------------------

glGenProgramsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramsNV v1 v2 = liftIO $ dyn_glGenProgramsNV ptr_glGenProgramsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGenProgramsNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenProgramsNV #-}
ptr_glGenProgramsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramsNV = unsafePerformIO $ getCommand "glGenProgramsNV"

-- glGenQueries ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenQueries.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenQueries.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenQueries.xhtml OpenGL 4.x>
glGenQueries
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueries v1 v2 = liftIO $ dyn_glGenQueries ptr_glGenQueries v1 v2

foreign import CALLCONV "dynamic" dyn_glGenQueries
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenQueries #-}
ptr_glGenQueries :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueries = unsafePerformIO $ getCommand "glGenQueries"

-- glGenQueriesARB -------------------------------------------------------------

glGenQueriesARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueriesARB v1 v2 = liftIO $ dyn_glGenQueriesARB ptr_glGenQueriesARB v1 v2

foreign import CALLCONV "dynamic" dyn_glGenQueriesARB
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenQueriesARB #-}
ptr_glGenQueriesARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueriesARB = unsafePerformIO $ getCommand "glGenQueriesARB"

-- glGenQueriesEXT -------------------------------------------------------------

glGenQueriesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueriesEXT v1 v2 = liftIO $ dyn_glGenQueriesEXT ptr_glGenQueriesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenQueriesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenQueriesEXT #-}
ptr_glGenQueriesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueriesEXT = unsafePerformIO $ getCommand "glGenQueriesEXT"

-- glGenRenderbuffers ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenRenderbuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenRenderbuffers.xhtml OpenGL 4.x>
glGenRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffers v1 v2 = liftIO $ dyn_glGenRenderbuffers ptr_glGenRenderbuffers v1 v2

foreign import CALLCONV "dynamic" dyn_glGenRenderbuffers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenRenderbuffers #-}
ptr_glGenRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffers = unsafePerformIO $ getCommand "glGenRenderbuffers"

-- glGenRenderbuffersEXT -------------------------------------------------------

glGenRenderbuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffersEXT v1 v2 = liftIO $ dyn_glGenRenderbuffersEXT ptr_glGenRenderbuffersEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenRenderbuffersEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenRenderbuffersEXT #-}
ptr_glGenRenderbuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffersEXT = unsafePerformIO $ getCommand "glGenRenderbuffersEXT"

-- glGenRenderbuffersOES -------------------------------------------------------

glGenRenderbuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffersOES v1 v2 = liftIO $ dyn_glGenRenderbuffersOES ptr_glGenRenderbuffersOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGenRenderbuffersOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenRenderbuffersOES #-}
ptr_glGenRenderbuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffersOES = unsafePerformIO $ getCommand "glGenRenderbuffersOES"

-- glGenSamplers ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenSamplers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenSamplers.xhtml OpenGL 4.x>
glGenSamplers
  :: MonadIO m
  => GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glGenSamplers v1 v2 = liftIO $ dyn_glGenSamplers ptr_glGenSamplers v1 v2

foreign import CALLCONV "dynamic" dyn_glGenSamplers
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenSamplers #-}
ptr_glGenSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenSamplers = unsafePerformIO $ getCommand "glGenSamplers"

-- glGenSymbolsEXT -------------------------------------------------------------

glGenSymbolsEXT
  :: MonadIO m
  => GLenum -- ^ @datatype@ of type @DataTypeEXT@.
  -> GLenum -- ^ @storagetype@ of type @VertexShaderStorageTypeEXT@.
  -> GLenum -- ^ @range@ of type @ParameterRangeEXT@.
  -> GLuint -- ^ @components@.
  -> m GLuint
glGenSymbolsEXT v1 v2 v3 v4 = liftIO $ dyn_glGenSymbolsEXT ptr_glGenSymbolsEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGenSymbolsEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO GLuint)
  ->         GLenum -> GLenum -> GLenum -> GLuint -> IO GLuint

{-# NOINLINE ptr_glGenSymbolsEXT #-}
ptr_glGenSymbolsEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO GLuint)
ptr_glGenSymbolsEXT = unsafePerformIO $ getCommand "glGenSymbolsEXT"

-- glGenTextures ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenTextures.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenTextures.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenTextures.xhtml OpenGL 4.x>
glGenTextures
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glGenTextures v1 v2 = liftIO $ dyn_glGenTextures ptr_glGenTextures v1 v2

foreign import CALLCONV "dynamic" dyn_glGenTextures
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenTextures #-}
ptr_glGenTextures :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTextures = unsafePerformIO $ getCommand "glGenTextures"

-- glGenTexturesEXT ------------------------------------------------------------

glGenTexturesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glGenTexturesEXT v1 v2 = liftIO $ dyn_glGenTexturesEXT ptr_glGenTexturesEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenTexturesEXT
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenTexturesEXT #-}
ptr_glGenTexturesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTexturesEXT = unsafePerformIO $ getCommand "glGenTexturesEXT"

-- glGenTransformFeedbacks -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenTransformFeedbacks.xhtml OpenGL 4.x>
glGenTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenTransformFeedbacks v1 v2 = liftIO $ dyn_glGenTransformFeedbacks ptr_glGenTransformFeedbacks v1 v2

foreign import CALLCONV "dynamic" dyn_glGenTransformFeedbacks
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenTransformFeedbacks #-}
ptr_glGenTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTransformFeedbacks = unsafePerformIO $ getCommand "glGenTransformFeedbacks"

-- glGenTransformFeedbacksNV ---------------------------------------------------

glGenTransformFeedbacksNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenTransformFeedbacksNV v1 v2 = liftIO $ dyn_glGenTransformFeedbacksNV ptr_glGenTransformFeedbacksNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGenTransformFeedbacksNV
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenTransformFeedbacksNV #-}
ptr_glGenTransformFeedbacksNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTransformFeedbacksNV = unsafePerformIO $ getCommand "glGenTransformFeedbacksNV"

-- glGenVertexArrays -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenVertexArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenVertexArrays.xhtml OpenGL 4.x>
glGenVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArrays v1 v2 = liftIO $ dyn_glGenVertexArrays ptr_glGenVertexArrays v1 v2

foreign import CALLCONV "dynamic" dyn_glGenVertexArrays
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenVertexArrays #-}
ptr_glGenVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArrays = unsafePerformIO $ getCommand "glGenVertexArrays"

-- glGenVertexArraysAPPLE ------------------------------------------------------

glGenVertexArraysAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArraysAPPLE v1 v2 = liftIO $ dyn_glGenVertexArraysAPPLE ptr_glGenVertexArraysAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glGenVertexArraysAPPLE
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenVertexArraysAPPLE #-}
ptr_glGenVertexArraysAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArraysAPPLE = unsafePerformIO $ getCommand "glGenVertexArraysAPPLE"

-- glGenVertexArraysOES --------------------------------------------------------

glGenVertexArraysOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArraysOES v1 v2 = liftIO $ dyn_glGenVertexArraysOES ptr_glGenVertexArraysOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGenVertexArraysOES
  :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
  ->         GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGenVertexArraysOES #-}
ptr_glGenVertexArraysOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArraysOES = unsafePerformIO $ getCommand "glGenVertexArraysOES"

-- glGenVertexShadersEXT -------------------------------------------------------

glGenVertexShadersEXT
  :: MonadIO m
  => GLuint -- ^ @range@.
  -> m GLuint
glGenVertexShadersEXT v1 = liftIO $ dyn_glGenVertexShadersEXT ptr_glGenVertexShadersEXT v1

foreign import CALLCONV "dynamic" dyn_glGenVertexShadersEXT
  :: FunPtr (GLuint -> IO GLuint)
  ->         GLuint -> IO GLuint

{-# NOINLINE ptr_glGenVertexShadersEXT #-}
ptr_glGenVertexShadersEXT :: FunPtr (GLuint -> IO GLuint)
ptr_glGenVertexShadersEXT = unsafePerformIO $ getCommand "glGenVertexShadersEXT"

-- glGenerateMipmap ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenerateMipmap.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenerateMipmap.xhtml OpenGL 4.x>
glGenerateMipmap
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmap v1 = liftIO $ dyn_glGenerateMipmap ptr_glGenerateMipmap v1

foreign import CALLCONV "dynamic" dyn_glGenerateMipmap
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glGenerateMipmap #-}
ptr_glGenerateMipmap :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmap = unsafePerformIO $ getCommand "glGenerateMipmap"

-- glGenerateMipmapEXT ---------------------------------------------------------

glGenerateMipmapEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmapEXT v1 = liftIO $ dyn_glGenerateMipmapEXT ptr_glGenerateMipmapEXT v1

foreign import CALLCONV "dynamic" dyn_glGenerateMipmapEXT
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glGenerateMipmapEXT #-}
ptr_glGenerateMipmapEXT :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmapEXT = unsafePerformIO $ getCommand "glGenerateMipmapEXT"

-- glGenerateMipmapOES ---------------------------------------------------------

glGenerateMipmapOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmapOES v1 = liftIO $ dyn_glGenerateMipmapOES ptr_glGenerateMipmapOES v1

foreign import CALLCONV "dynamic" dyn_glGenerateMipmapOES
  :: FunPtr (GLenum -> IO ())
  ->         GLenum -> IO ()

{-# NOINLINE ptr_glGenerateMipmapOES #-}
ptr_glGenerateMipmapOES :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmapOES = unsafePerformIO $ getCommand "glGenerateMipmapOES"

-- glGenerateMultiTexMipmapEXT -------------------------------------------------

glGenerateMultiTexMipmapEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> m ()
glGenerateMultiTexMipmapEXT v1 v2 = liftIO $ dyn_glGenerateMultiTexMipmapEXT ptr_glGenerateMultiTexMipmapEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenerateMultiTexMipmapEXT
  :: FunPtr (GLenum -> GLenum -> IO ())
  ->         GLenum -> GLenum -> IO ()

{-# NOINLINE ptr_glGenerateMultiTexMipmapEXT #-}
ptr_glGenerateMultiTexMipmapEXT :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glGenerateMultiTexMipmapEXT = unsafePerformIO $ getCommand "glGenerateMultiTexMipmapEXT"

-- glGenerateTextureMipmap -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenerateMipmap.xhtml OpenGL 4.x>
glGenerateTextureMipmap
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m ()
glGenerateTextureMipmap v1 = liftIO $ dyn_glGenerateTextureMipmap ptr_glGenerateTextureMipmap v1

foreign import CALLCONV "dynamic" dyn_glGenerateTextureMipmap
  :: FunPtr (GLuint -> IO ())
  ->         GLuint -> IO ()

{-# NOINLINE ptr_glGenerateTextureMipmap #-}
ptr_glGenerateTextureMipmap :: FunPtr (GLuint -> IO ())
ptr_glGenerateTextureMipmap = unsafePerformIO $ getCommand "glGenerateTextureMipmap"

-- glGenerateTextureMipmapEXT --------------------------------------------------

glGenerateTextureMipmapEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> m ()
glGenerateTextureMipmapEXT v1 v2 = liftIO $ dyn_glGenerateTextureMipmapEXT ptr_glGenerateTextureMipmapEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGenerateTextureMipmapEXT
  :: FunPtr (GLuint -> GLenum -> IO ())
  ->         GLuint -> GLenum -> IO ()

{-# NOINLINE ptr_glGenerateTextureMipmapEXT #-}
ptr_glGenerateTextureMipmapEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glGenerateTextureMipmapEXT = unsafePerformIO $ getCommand "glGenerateTextureMipmapEXT"

-- glGetActiveAtomicCounterBufferiv --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveAtomicCounterBufferiv.xhtml OpenGL 4.x>
glGetActiveAtomicCounterBufferiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @bufferIndex@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetActiveAtomicCounterBufferiv v1 v2 v3 v4 = liftIO $ dyn_glGetActiveAtomicCounterBufferiv ptr_glGetActiveAtomicCounterBufferiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetActiveAtomicCounterBufferiv
  :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetActiveAtomicCounterBufferiv #-}
ptr_glGetActiveAtomicCounterBufferiv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveAtomicCounterBufferiv = unsafePerformIO $ getCommand "glGetActiveAtomicCounterBufferiv"

-- glGetActiveAttrib -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveAttrib.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveAttrib.xhtml OpenGL 4.x>
glGetActiveAttrib
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ elements of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveAttrib v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetActiveAttrib ptr_glGetActiveAttrib v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetActiveAttrib
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveAttrib #-}
ptr_glGetActiveAttrib :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveAttrib = unsafePerformIO $ getCommand "glGetActiveAttrib"

-- glGetActiveAttribARB --------------------------------------------------------

glGetActiveAttribARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ elements of type @GLenum@.
  -> Ptr GLcharARB -- ^ @name@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetActiveAttribARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetActiveAttribARB ptr_glGetActiveAttribARB v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetActiveAttribARB
  :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
  ->         GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ()

{-# NOINLINE ptr_glGetActiveAttribARB #-}
ptr_glGetActiveAttribARB :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
ptr_glGetActiveAttribARB = unsafePerformIO $ getCommand "glGetActiveAttribARB"

-- glGetActiveSubroutineName ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineName.xhtml OpenGL 4.x>
glGetActiveSubroutineName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufsize@ elements of type @GLchar@.
  -> m ()
glGetActiveSubroutineName v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetActiveSubroutineName ptr_glGetActiveSubroutineName v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetActiveSubroutineName
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveSubroutineName #-}
ptr_glGetActiveSubroutineName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveSubroutineName = unsafePerformIO $ getCommand "glGetActiveSubroutineName"

-- glGetActiveSubroutineUniformName --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineUniformName.xhtml OpenGL 4.x>
glGetActiveSubroutineUniformName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufsize@ elements of type @GLchar@.
  -> m ()
glGetActiveSubroutineUniformName v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetActiveSubroutineUniformName ptr_glGetActiveSubroutineUniformName v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetActiveSubroutineUniformName
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveSubroutineUniformName #-}
ptr_glGetActiveSubroutineUniformName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveSubroutineUniformName = unsafePerformIO $ getCommand "glGetActiveSubroutineUniformName"

-- glGetActiveSubroutineUniformiv ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineUniform.xhtml OpenGL 4.x>
glGetActiveSubroutineUniformiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @values@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetActiveSubroutineUniformiv v1 v2 v3 v4 v5 = liftIO $ dyn_glGetActiveSubroutineUniformiv ptr_glGetActiveSubroutineUniformiv v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetActiveSubroutineUniformiv
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetActiveSubroutineUniformiv #-}
ptr_glGetActiveSubroutineUniformiv :: FunPtr (GLuint -> GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveSubroutineUniformiv = unsafePerformIO $ getCommand "glGetActiveSubroutineUniformiv"

-- glGetActiveUniform ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveUniform.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniform.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniform.xhtml OpenGL 4.x>
glGetActiveUniform
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ elements of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniform v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetActiveUniform ptr_glGetActiveUniform v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetActiveUniform
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveUniform #-}
ptr_glGetActiveUniform :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveUniform = unsafePerformIO $ getCommand "glGetActiveUniform"

-- glGetActiveUniformARB -------------------------------------------------------

glGetActiveUniformARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ elements of type @GLenum@.
  -> Ptr GLcharARB -- ^ @name@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetActiveUniformARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetActiveUniformARB ptr_glGetActiveUniformARB v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetActiveUniformARB
  :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
  ->         GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ()

{-# NOINLINE ptr_glGetActiveUniformARB #-}
ptr_glGetActiveUniformARB :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
ptr_glGetActiveUniformARB = unsafePerformIO $ getCommand "glGetActiveUniformARB"

-- glGetActiveUniformBlockName -------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlockName.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformBlockName.xhtml OpenGL 4.x>
glGetActiveUniformBlockName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformBlockIndex@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @uniformBlockName@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniformBlockName v1 v2 v3 v4 v5 = liftIO $ dyn_glGetActiveUniformBlockName ptr_glGetActiveUniformBlockName v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetActiveUniformBlockName
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveUniformBlockName #-}
ptr_glGetActiveUniformBlockName :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveUniformBlockName = unsafePerformIO $ getCommand "glGetActiveUniformBlockName"

-- glGetActiveUniformBlockiv ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlock.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformBlock.xhtml OpenGL 4.x>
glGetActiveUniformBlockiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformBlockIndex@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(program,uniformBlockIndex,pname)@ elements of type @GLint@.
  -> m ()
glGetActiveUniformBlockiv v1 v2 v3 v4 = liftIO $ dyn_glGetActiveUniformBlockiv ptr_glGetActiveUniformBlockiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetActiveUniformBlockiv
  :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetActiveUniformBlockiv #-}
ptr_glGetActiveUniformBlockiv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveUniformBlockiv = unsafePerformIO $ getCommand "glGetActiveUniformBlockiv"

-- glGetActiveUniformName ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformName.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformName.xhtml OpenGL 4.x>
glGetActiveUniformName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformIndex@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @uniformName@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniformName v1 v2 v3 v4 v5 = liftIO $ dyn_glGetActiveUniformName ptr_glGetActiveUniformName v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetActiveUniformName
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveUniformName #-}
ptr_glGetActiveUniformName :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveUniformName = unsafePerformIO $ getCommand "glGetActiveUniformName"

-- glGetActiveUniformsiv -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformsiv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformsiv.xhtml OpenGL 4.x>
glGetActiveUniformsiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @uniformCount@.
  -> Ptr GLuint -- ^ @uniformIndices@ pointing to @uniformCount@ elements of type @GLuint@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(uniformCount,pname)@ elements of type @GLint@.
  -> m ()
glGetActiveUniformsiv v1 v2 v3 v4 v5 = liftIO $ dyn_glGetActiveUniformsiv ptr_glGetActiveUniformsiv v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetActiveUniformsiv
  :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetActiveUniformsiv #-}
ptr_glGetActiveUniformsiv :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveUniformsiv = unsafePerformIO $ getCommand "glGetActiveUniformsiv"

-- glGetActiveVaryingNV --------------------------------------------------------

glGetActiveVaryingNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLsizei -- ^ @size@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ elements of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(program,index,bufSize)@ elements of type @GLchar@.
  -> m ()
glGetActiveVaryingNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetActiveVaryingNV ptr_glGetActiveVaryingNV v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetActiveVaryingNV
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetActiveVaryingNV #-}
ptr_glGetActiveVaryingNV :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveVaryingNV = unsafePerformIO $ getCommand "glGetActiveVaryingNV"

-- glGetArrayObjectfvATI -------------------------------------------------------

glGetArrayObjectfvATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ elements of type @GLfloat@.
  -> m ()
glGetArrayObjectfvATI v1 v2 v3 = liftIO $ dyn_glGetArrayObjectfvATI ptr_glGetArrayObjectfvATI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetArrayObjectfvATI
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetArrayObjectfvATI #-}
ptr_glGetArrayObjectfvATI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetArrayObjectfvATI = unsafePerformIO $ getCommand "glGetArrayObjectfvATI"

-- glGetArrayObjectivATI -------------------------------------------------------

glGetArrayObjectivATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type @EnableCap@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetArrayObjectivATI v1 v2 v3 = liftIO $ dyn_glGetArrayObjectivATI ptr_glGetArrayObjectivATI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetArrayObjectivATI
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetArrayObjectivATI #-}
ptr_glGetArrayObjectivATI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetArrayObjectivATI = unsafePerformIO $ getCommand "glGetArrayObjectivATI"

-- glGetAttachedObjectsARB -----------------------------------------------------

glGetAttachedObjectsARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLsizei -- ^ @maxCount@.
  -> Ptr GLsizei -- ^ @count@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLhandleARB -- ^ @obj@ pointing to @maxCount@ elements of type @handleARB@.
  -> m ()
glGetAttachedObjectsARB v1 v2 v3 v4 = liftIO $ dyn_glGetAttachedObjectsARB ptr_glGetAttachedObjectsARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetAttachedObjectsARB
  :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLhandleARB -> IO ())
  ->         GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLhandleARB -> IO ()

{-# NOINLINE ptr_glGetAttachedObjectsARB #-}
ptr_glGetAttachedObjectsARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLhandleARB -> IO ())
ptr_glGetAttachedObjectsARB = unsafePerformIO $ getCommand "glGetAttachedObjectsARB"

-- glGetAttachedShaders --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetAttachedShaders.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetAttachedShaders.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetAttachedShaders.xhtml OpenGL 4.x>
glGetAttachedShaders
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @maxCount@.
  -> Ptr GLsizei -- ^ @count@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLuint -- ^ @shaders@ pointing to @maxCount@ elements of type @GLuint@.
  -> m ()
glGetAttachedShaders v1 v2 v3 v4 = liftIO $ dyn_glGetAttachedShaders ptr_glGetAttachedShaders v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetAttachedShaders
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLuint -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetAttachedShaders #-}
ptr_glGetAttachedShaders :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLuint -> IO ())
ptr_glGetAttachedShaders = unsafePerformIO $ getCommand "glGetAttachedShaders"

-- glGetAttribLocation ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetAttribLocation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetAttribLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetAttribLocation.xhtml OpenGL 4.x>
glGetAttribLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetAttribLocation v1 v2 = liftIO $ dyn_glGetAttribLocation ptr_glGetAttribLocation v1 v2

foreign import CALLCONV "dynamic" dyn_glGetAttribLocation
  :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
  ->         GLuint -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetAttribLocation #-}
ptr_glGetAttribLocation :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetAttribLocation = unsafePerformIO $ getCommand "glGetAttribLocation"

-- glGetAttribLocationARB ------------------------------------------------------

glGetAttribLocationARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> Ptr GLcharARB -- ^ @name@.
  -> m GLint
glGetAttribLocationARB v1 v2 = liftIO $ dyn_glGetAttribLocationARB ptr_glGetAttribLocationARB v1 v2

foreign import CALLCONV "dynamic" dyn_glGetAttribLocationARB
  :: FunPtr (GLhandleARB -> Ptr GLcharARB -> IO GLint)
  ->         GLhandleARB -> Ptr GLcharARB -> IO GLint

{-# NOINLINE ptr_glGetAttribLocationARB #-}
ptr_glGetAttribLocationARB :: FunPtr (GLhandleARB -> Ptr GLcharARB -> IO GLint)
ptr_glGetAttribLocationARB = unsafePerformIO $ getCommand "glGetAttribLocationARB"

-- glGetBooleanIndexedvEXT -----------------------------------------------------

glGetBooleanIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @Boolean@.
  -> m ()
glGetBooleanIndexedvEXT v1 v2 v3 = liftIO $ dyn_glGetBooleanIndexedvEXT ptr_glGetBooleanIndexedvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBooleanIndexedvEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
  ->         GLenum -> GLuint -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glGetBooleanIndexedvEXT #-}
ptr_glGetBooleanIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
ptr_glGetBooleanIndexedvEXT = unsafePerformIO $ getCommand "glGetBooleanIndexedvEXT"

-- glGetBooleani_v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetBooleani_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @Boolean@.
  -> m ()
glGetBooleani_v v1 v2 v3 = liftIO $ dyn_glGetBooleani_v ptr_glGetBooleani_v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBooleani_v
  :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
  ->         GLenum -> GLuint -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glGetBooleani_v #-}
ptr_glGetBooleani_v :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
ptr_glGetBooleani_v = unsafePerformIO $ getCommand "glGetBooleani_v"

-- glGetBooleanv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetBooleanv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPName@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @Boolean@.
  -> m ()
glGetBooleanv v1 v2 = liftIO $ dyn_glGetBooleanv ptr_glGetBooleanv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetBooleanv
  :: FunPtr (GLenum -> Ptr GLboolean -> IO ())
  ->         GLenum -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glGetBooleanv #-}
ptr_glGetBooleanv :: FunPtr (GLenum -> Ptr GLboolean -> IO ())
ptr_glGetBooleanv = unsafePerformIO $ getCommand "glGetBooleanv"

-- glGetBufferParameteri64v ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>
glGetBufferParameteri64v
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetBufferParameteri64v v1 v2 v3 = liftIO $ dyn_glGetBufferParameteri64v ptr_glGetBufferParameteri64v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferParameteri64v
  :: FunPtr (GLenum -> GLenum -> Ptr GLint64 -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetBufferParameteri64v #-}
ptr_glGetBufferParameteri64v :: FunPtr (GLenum -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetBufferParameteri64v = unsafePerformIO $ getCommand "glGetBufferParameteri64v"

-- glGetBufferParameteriv ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferParameteriv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>
glGetBufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetBufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetBufferParameteriv ptr_glGetBufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetBufferParameteriv #-}
ptr_glGetBufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetBufferParameteriv = unsafePerformIO $ getCommand "glGetBufferParameteriv"

-- glGetBufferParameterivARB ---------------------------------------------------

glGetBufferParameterivARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetBufferParameterivARB v1 v2 v3 = liftIO $ dyn_glGetBufferParameterivARB ptr_glGetBufferParameterivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferParameterivARB
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetBufferParameterivARB #-}
ptr_glGetBufferParameterivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetBufferParameterivARB = unsafePerformIO $ getCommand "glGetBufferParameterivARB"

-- glGetBufferParameterui64vNV -------------------------------------------------

glGetBufferParameterui64vNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetBufferParameterui64vNV v1 v2 v3 = liftIO $ dyn_glGetBufferParameterui64vNV ptr_glGetBufferParameterui64vNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferParameterui64vNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLuint64EXT -> IO ())
  ->         GLenum -> GLenum -> Ptr GLuint64EXT -> IO ()

{-# NOINLINE ptr_glGetBufferParameterui64vNV #-}
ptr_glGetBufferParameterui64vNV :: FunPtr (GLenum -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetBufferParameterui64vNV = unsafePerformIO $ getCommand "glGetBufferParameterui64vNV"

-- glGetBufferPointerv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferPointerv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferPointerv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferPointerv.xhtml OpenGL 4.x>
glGetBufferPointerv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPointerNameARB@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetBufferPointerv v1 v2 v3 = liftIO $ dyn_glGetBufferPointerv ptr_glGetBufferPointerv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferPointerv
  :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetBufferPointerv #-}
ptr_glGetBufferPointerv :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointerv = unsafePerformIO $ getCommand "glGetBufferPointerv"

-- glGetBufferPointervARB ------------------------------------------------------

glGetBufferPointervARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPointerNameARB@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetBufferPointervARB v1 v2 v3 = liftIO $ dyn_glGetBufferPointervARB ptr_glGetBufferPointervARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferPointervARB
  :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetBufferPointervARB #-}
ptr_glGetBufferPointervARB :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointervARB = unsafePerformIO $ getCommand "glGetBufferPointervARB"

-- glGetBufferPointervOES ------------------------------------------------------

glGetBufferPointervOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetBufferPointervOES v1 v2 v3 = liftIO $ dyn_glGetBufferPointervOES ptr_glGetBufferPointervOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetBufferPointervOES
  :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetBufferPointervOES #-}
ptr_glGetBufferPointervOES :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointervOES = unsafePerformIO $ getCommand "glGetBufferPointervOES"

-- glGetBufferSubData ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferSubData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferSubData.xhtml OpenGL 4.x>
glGetBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glGetBufferSubData v1 v2 v3 v4 = liftIO $ dyn_glGetBufferSubData ptr_glGetBufferSubData v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetBufferSubData
  :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
  ->         GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetBufferSubData #-}
ptr_glGetBufferSubData :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetBufferSubData = unsafePerformIO $ getCommand "glGetBufferSubData"

-- glGetBufferSubDataARB -------------------------------------------------------

glGetBufferSubDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glGetBufferSubDataARB v1 v2 v3 v4 = liftIO $ dyn_glGetBufferSubDataARB ptr_glGetBufferSubDataARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetBufferSubDataARB
  :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
  ->         GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetBufferSubDataARB #-}
ptr_glGetBufferSubDataARB :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
ptr_glGetBufferSubDataARB = unsafePerformIO $ getCommand "glGetBufferSubDataARB"

-- glGetClipPlane --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetClipPlane.xml OpenGL 2.x>
glGetClipPlane
  :: MonadIO m
  => GLenum -- ^ @plane@ of type @ClipPlaneName@.
  -> Ptr GLdouble -- ^ @equation@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetClipPlane v1 v2 = liftIO $ dyn_glGetClipPlane ptr_glGetClipPlane v1 v2

foreign import CALLCONV "dynamic" dyn_glGetClipPlane
  :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetClipPlane #-}
ptr_glGetClipPlane :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glGetClipPlane = unsafePerformIO $ getCommand "glGetClipPlane"

-- glGetClipPlanef -------------------------------------------------------------

glGetClipPlanef
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetClipPlanef v1 v2 = liftIO $ dyn_glGetClipPlanef ptr_glGetClipPlanef v1 v2

foreign import CALLCONV "dynamic" dyn_glGetClipPlanef
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetClipPlanef #-}
ptr_glGetClipPlanef :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetClipPlanef = unsafePerformIO $ getCommand "glGetClipPlanef"

-- glGetClipPlanefOES ----------------------------------------------------------

glGetClipPlanefOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetClipPlanefOES v1 v2 = liftIO $ dyn_glGetClipPlanefOES ptr_glGetClipPlanefOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGetClipPlanefOES
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetClipPlanefOES #-}
ptr_glGetClipPlanefOES :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetClipPlanefOES = unsafePerformIO $ getCommand "glGetClipPlanefOES"

-- glGetClipPlanex -------------------------------------------------------------

glGetClipPlanex
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glGetClipPlanex v1 v2 = liftIO $ dyn_glGetClipPlanex ptr_glGetClipPlanex v1 v2

foreign import CALLCONV "dynamic" dyn_glGetClipPlanex
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetClipPlanex #-}
ptr_glGetClipPlanex :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetClipPlanex = unsafePerformIO $ getCommand "glGetClipPlanex"

-- glGetClipPlanexOES ----------------------------------------------------------

glGetClipPlanexOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glGetClipPlanexOES v1 v2 = liftIO $ dyn_glGetClipPlanexOES ptr_glGetClipPlanexOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGetClipPlanexOES
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetClipPlanexOES #-}
ptr_glGetClipPlanexOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetClipPlanexOES = unsafePerformIO $ getCommand "glGetClipPlanexOES"

-- glGetColorTable -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTable.xml OpenGL 2.x>
glGetColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTable v1 v2 v3 v4 = liftIO $ dyn_glGetColorTable ptr_glGetColorTable v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetColorTable
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetColorTable #-}
ptr_glGetColorTable :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTable = unsafePerformIO $ getCommand "glGetColorTable"

-- glGetColorTableEXT ----------------------------------------------------------

glGetColorTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTableEXT v1 v2 v3 v4 = liftIO $ dyn_glGetColorTableEXT ptr_glGetColorTableEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetColorTableEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetColorTableEXT #-}
ptr_glGetColorTableEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTableEXT = unsafePerformIO $ getCommand "glGetColorTableEXT"

-- glGetColorTableParameterfv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameter.xml OpenGL 2.x>
glGetColorTableParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfv v1 v2 v3 = liftIO $ dyn_glGetColorTableParameterfv ptr_glGetColorTableParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetColorTableParameterfv #-}
ptr_glGetColorTableParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfv = unsafePerformIO $ getCommand "glGetColorTableParameterfv"

-- glGetColorTableParameterfvEXT -----------------------------------------------

glGetColorTableParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfvEXT v1 v2 v3 = liftIO $ dyn_glGetColorTableParameterfvEXT ptr_glGetColorTableParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetColorTableParameterfvEXT #-}
ptr_glGetColorTableParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfvEXT = unsafePerformIO $ getCommand "glGetColorTableParameterfvEXT"

-- glGetColorTableParameterfvSGI -----------------------------------------------

glGetColorTableParameterfvSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPNameSGI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfvSGI v1 v2 v3 = liftIO $ dyn_glGetColorTableParameterfvSGI ptr_glGetColorTableParameterfvSGI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameterfvSGI
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetColorTableParameterfvSGI #-}
ptr_glGetColorTableParameterfvSGI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfvSGI = unsafePerformIO $ getCommand "glGetColorTableParameterfvSGI"

-- glGetColorTableParameteriv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameter.xml OpenGL 2.x>
glGetColorTableParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameteriv v1 v2 v3 = liftIO $ dyn_glGetColorTableParameteriv ptr_glGetColorTableParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetColorTableParameteriv #-}
ptr_glGetColorTableParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameteriv = unsafePerformIO $ getCommand "glGetColorTableParameteriv"

-- glGetColorTableParameterivEXT -----------------------------------------------

glGetColorTableParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetColorTableParameterivEXT ptr_glGetColorTableParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetColorTableParameterivEXT #-}
ptr_glGetColorTableParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameterivEXT = unsafePerformIO $ getCommand "glGetColorTableParameterivEXT"

-- glGetColorTableParameterivSGI -----------------------------------------------

glGetColorTableParameterivSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPNameSGI@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameterivSGI v1 v2 v3 = liftIO $ dyn_glGetColorTableParameterivSGI ptr_glGetColorTableParameterivSGI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetColorTableParameterivSGI
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetColorTableParameterivSGI #-}
ptr_glGetColorTableParameterivSGI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameterivSGI = unsafePerformIO $ getCommand "glGetColorTableParameterivSGI"

-- glGetColorTableSGI ----------------------------------------------------------

glGetColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTargetSGI@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTableSGI v1 v2 v3 v4 = liftIO $ dyn_glGetColorTableSGI ptr_glGetColorTableSGI v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetColorTableSGI
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetColorTableSGI #-}
ptr_glGetColorTableSGI :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTableSGI = unsafePerformIO $ getCommand "glGetColorTableSGI"

-- glGetCombinerInputParameterfvNV ---------------------------------------------

glGetCombinerInputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerInputParameterfvNV v1 v2 v3 v4 v5 = liftIO $ dyn_glGetCombinerInputParameterfvNV ptr_glGetCombinerInputParameterfvNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetCombinerInputParameterfvNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetCombinerInputParameterfvNV #-}
ptr_glGetCombinerInputParameterfvNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerInputParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerInputParameterfvNV"

-- glGetCombinerInputParameterivNV ---------------------------------------------

glGetCombinerInputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetCombinerInputParameterivNV v1 v2 v3 v4 v5 = liftIO $ dyn_glGetCombinerInputParameterivNV ptr_glGetCombinerInputParameterivNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetCombinerInputParameterivNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetCombinerInputParameterivNV #-}
ptr_glGetCombinerInputParameterivNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetCombinerInputParameterivNV = unsafePerformIO $ getCommand "glGetCombinerInputParameterivNV"

-- glGetCombinerOutputParameterfvNV --------------------------------------------

glGetCombinerOutputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerOutputParameterfvNV v1 v2 v3 v4 = liftIO $ dyn_glGetCombinerOutputParameterfvNV ptr_glGetCombinerOutputParameterfvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetCombinerOutputParameterfvNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetCombinerOutputParameterfvNV #-}
ptr_glGetCombinerOutputParameterfvNV :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerOutputParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerOutputParameterfvNV"

-- glGetCombinerOutputParameterivNV --------------------------------------------

glGetCombinerOutputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetCombinerOutputParameterivNV v1 v2 v3 v4 = liftIO $ dyn_glGetCombinerOutputParameterivNV ptr_glGetCombinerOutputParameterivNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetCombinerOutputParameterivNV
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetCombinerOutputParameterivNV #-}
ptr_glGetCombinerOutputParameterivNV :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetCombinerOutputParameterivNV = unsafePerformIO $ getCommand "glGetCombinerOutputParameterivNV"

-- glGetCombinerStageParameterfvNV ---------------------------------------------

glGetCombinerStageParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerStageParameterfvNV v1 v2 v3 = liftIO $ dyn_glGetCombinerStageParameterfvNV ptr_glGetCombinerStageParameterfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetCombinerStageParameterfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetCombinerStageParameterfvNV #-}
ptr_glGetCombinerStageParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerStageParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerStageParameterfvNV"

-- glGetCompressedMultiTexImageEXT ---------------------------------------------

glGetCompressedMultiTexImageEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @lod@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,lod)@ elements of type @a@.
  -> m ()
glGetCompressedMultiTexImageEXT v1 v2 v3 v4 = liftIO $ dyn_glGetCompressedMultiTexImageEXT ptr_glGetCompressedMultiTexImageEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetCompressedMultiTexImageEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedMultiTexImageEXT #-}
ptr_glGetCompressedMultiTexImageEXT :: FunPtr (GLenum -> GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedMultiTexImageEXT = unsafePerformIO $ getCommand "glGetCompressedMultiTexImageEXT"

-- glGetCompressedTexImage -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetCompressedTexImage.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetCompressedTexImage.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTexImage.xhtml OpenGL 4.x>
glGetCompressedTexImage
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,level)@ elements of type @CompressedTextureARB@.
  -> m ()
glGetCompressedTexImage v1 v2 v3 = liftIO $ dyn_glGetCompressedTexImage ptr_glGetCompressedTexImage v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetCompressedTexImage
  :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
  ->         GLenum -> GLint -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedTexImage #-}
ptr_glGetCompressedTexImage :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTexImage = unsafePerformIO $ getCommand "glGetCompressedTexImage"

-- glGetCompressedTexImageARB --------------------------------------------------

glGetCompressedTexImageARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,level)@ elements of type @CompressedTextureARB@.
  -> m ()
glGetCompressedTexImageARB v1 v2 v3 = liftIO $ dyn_glGetCompressedTexImageARB ptr_glGetCompressedTexImageARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetCompressedTexImageARB
  :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
  ->         GLenum -> GLint -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedTexImageARB #-}
ptr_glGetCompressedTexImageARB :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTexImageARB = unsafePerformIO $ getCommand "glGetCompressedTexImageARB"

-- glGetCompressedTextureImage -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTexImage.xhtml OpenGL 4.x>
glGetCompressedTextureImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetCompressedTextureImage v1 v2 v3 v4 = liftIO $ dyn_glGetCompressedTextureImage ptr_glGetCompressedTextureImage v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetCompressedTextureImage
  :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedTextureImage #-}
ptr_glGetCompressedTextureImage :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glGetCompressedTextureImage = unsafePerformIO $ getCommand "glGetCompressedTextureImage"

-- glGetCompressedTextureImageEXT ----------------------------------------------

glGetCompressedTextureImageEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @lod@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,lod)@ elements of type @a@.
  -> m ()
glGetCompressedTextureImageEXT v1 v2 v3 v4 = liftIO $ dyn_glGetCompressedTextureImageEXT ptr_glGetCompressedTextureImageEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetCompressedTextureImageEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedTextureImageEXT #-}
ptr_glGetCompressedTextureImageEXT :: FunPtr (GLuint -> GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTextureImageEXT = unsafePerformIO $ getCommand "glGetCompressedTextureImageEXT"

-- glGetCompressedTextureSubImage ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTextureSubImage.xhtml OpenGL 4.x>
glGetCompressedTextureSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetCompressedTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn_glGetCompressedTextureSubImage ptr_glGetCompressedTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

foreign import CALLCONV "dynamic" dyn_glGetCompressedTextureSubImage
  :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetCompressedTextureSubImage #-}
ptr_glGetCompressedTextureSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLsizei -> Ptr a -> IO ())
ptr_glGetCompressedTextureSubImage = unsafePerformIO $ getCommand "glGetCompressedTextureSubImage"

-- glGetConvolutionFilter ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionFilter.xml OpenGL 2.x>
glGetConvolutionFilter
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetConvolutionFilter v1 v2 v3 v4 = liftIO $ dyn_glGetConvolutionFilter ptr_glGetConvolutionFilter v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetConvolutionFilter
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetConvolutionFilter #-}
ptr_glGetConvolutionFilter :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetConvolutionFilter = unsafePerformIO $ getCommand "glGetConvolutionFilter"

-- glGetConvolutionFilterEXT ---------------------------------------------------

glGetConvolutionFilterEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetConvolutionFilterEXT v1 v2 v3 v4 = liftIO $ dyn_glGetConvolutionFilterEXT ptr_glGetConvolutionFilterEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetConvolutionFilterEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetConvolutionFilterEXT #-}
ptr_glGetConvolutionFilterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetConvolutionFilterEXT = unsafePerformIO $ getCommand "glGetConvolutionFilterEXT"

-- glGetConvolutionParameterfv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameter.xml OpenGL 2.x>
glGetConvolutionParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @GetConvolutionParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetConvolutionParameterfv v1 v2 v3 = liftIO $ dyn_glGetConvolutionParameterfv ptr_glGetConvolutionParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetConvolutionParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetConvolutionParameterfv #-}
ptr_glGetConvolutionParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetConvolutionParameterfv = unsafePerformIO $ getCommand "glGetConvolutionParameterfv"

-- glGetConvolutionParameterfvEXT ----------------------------------------------

glGetConvolutionParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetConvolutionParameterfvEXT v1 v2 v3 = liftIO $ dyn_glGetConvolutionParameterfvEXT ptr_glGetConvolutionParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetConvolutionParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetConvolutionParameterfvEXT #-}
ptr_glGetConvolutionParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetConvolutionParameterfvEXT = unsafePerformIO $ getCommand "glGetConvolutionParameterfvEXT"

-- glGetConvolutionParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameter.xml OpenGL 2.x>
glGetConvolutionParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @GetConvolutionParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetConvolutionParameteriv v1 v2 v3 = liftIO $ dyn_glGetConvolutionParameteriv ptr_glGetConvolutionParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetConvolutionParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetConvolutionParameteriv #-}
ptr_glGetConvolutionParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetConvolutionParameteriv = unsafePerformIO $ getCommand "glGetConvolutionParameteriv"

-- glGetConvolutionParameterivEXT ----------------------------------------------

glGetConvolutionParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTargetEXT@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameterEXT@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetConvolutionParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetConvolutionParameterivEXT ptr_glGetConvolutionParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetConvolutionParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetConvolutionParameterivEXT #-}
ptr_glGetConvolutionParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetConvolutionParameterivEXT = unsafePerformIO $ getCommand "glGetConvolutionParameterivEXT"

-- glGetConvolutionParameterxvOES ----------------------------------------------

glGetConvolutionParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetConvolutionParameterxvOES v1 v2 v3 = liftIO $ dyn_glGetConvolutionParameterxvOES ptr_glGetConvolutionParameterxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetConvolutionParameterxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetConvolutionParameterxvOES #-}
ptr_glGetConvolutionParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetConvolutionParameterxvOES = unsafePerformIO $ getCommand "glGetConvolutionParameterxvOES"

-- glGetCoverageModulationTableNV ----------------------------------------------

glGetCoverageModulationTableNV
  :: MonadIO m
  => GLsizei -- ^ @bufsize@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glGetCoverageModulationTableNV v1 v2 = liftIO $ dyn_glGetCoverageModulationTableNV ptr_glGetCoverageModulationTableNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGetCoverageModulationTableNV
  :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
  ->         GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetCoverageModulationTableNV #-}
ptr_glGetCoverageModulationTableNV :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetCoverageModulationTableNV = unsafePerformIO $ getCommand "glGetCoverageModulationTableNV"

-- glGetDebugMessageLog --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetDebugMessageLog.xhtml OpenGL 4.x>
glGetDebugMessageLog
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLog v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glGetDebugMessageLog ptr_glGetDebugMessageLog v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glGetDebugMessageLog
  :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetDebugMessageLog #-}
ptr_glGetDebugMessageLog :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLog = unsafePerformIO $ getCommand "glGetDebugMessageLog"

-- glGetDebugMessageLogAMD -----------------------------------------------------

glGetDebugMessageLogAMD
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLenum -- ^ @categories@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @severities@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @message@ pointing to @bufsize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogAMD v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetDebugMessageLogAMD ptr_glGetDebugMessageLogAMD v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetDebugMessageLogAMD
  :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLuint -> Ptr GLuint -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLsizei -> Ptr GLenum -> Ptr GLuint -> Ptr GLuint -> Ptr GLsizei -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetDebugMessageLogAMD #-}
ptr_glGetDebugMessageLogAMD :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLuint -> Ptr GLuint -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogAMD = unsafePerformIO $ getCommand "glGetDebugMessageLogAMD"

-- glGetDebugMessageLogARB -----------------------------------------------------

glGetDebugMessageLogARB
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogARB v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glGetDebugMessageLogARB ptr_glGetDebugMessageLogARB v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glGetDebugMessageLogARB
  :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetDebugMessageLogARB #-}
ptr_glGetDebugMessageLogARB :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogARB = unsafePerformIO $ getCommand "glGetDebugMessageLogARB"

-- glGetDebugMessageLogKHR -----------------------------------------------------

glGetDebugMessageLogKHR
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogKHR v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glGetDebugMessageLogKHR ptr_glGetDebugMessageLogKHR v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glGetDebugMessageLogKHR
  :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetDebugMessageLogKHR #-}
ptr_glGetDebugMessageLogKHR :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogKHR = unsafePerformIO $ getCommand "glGetDebugMessageLogKHR"

-- glGetDetailTexFuncSGIS ------------------------------------------------------

glGetDetailTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetDetailTexFuncSGIS v1 v2 = liftIO $ dyn_glGetDetailTexFuncSGIS ptr_glGetDetailTexFuncSGIS v1 v2

foreign import CALLCONV "dynamic" dyn_glGetDetailTexFuncSGIS
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetDetailTexFuncSGIS #-}
ptr_glGetDetailTexFuncSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetDetailTexFuncSGIS = unsafePerformIO $ getCommand "glGetDetailTexFuncSGIS"

-- glGetDoubleIndexedvEXT ------------------------------------------------------

glGetDoubleIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLdouble@.
  -> m ()
glGetDoubleIndexedvEXT v1 v2 v3 = liftIO $ dyn_glGetDoubleIndexedvEXT ptr_glGetDoubleIndexedvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetDoubleIndexedvEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetDoubleIndexedvEXT #-}
ptr_glGetDoubleIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoubleIndexedvEXT = unsafePerformIO $ getCommand "glGetDoubleIndexedvEXT"

-- glGetDoublei_v --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetDoublei_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLdouble@.
  -> m ()
glGetDoublei_v v1 v2 v3 = liftIO $ dyn_glGetDoublei_v ptr_glGetDoublei_v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetDoublei_v
  :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetDoublei_v #-}
ptr_glGetDoublei_v :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoublei_v = unsafePerformIO $ getCommand "glGetDoublei_v"

-- glGetDoublei_vEXT -----------------------------------------------------------

glGetDoublei_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetDoublei_vEXT v1 v2 v3 = liftIO $ dyn_glGetDoublei_vEXT ptr_glGetDoublei_vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetDoublei_vEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetDoublei_vEXT #-}
ptr_glGetDoublei_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoublei_vEXT = unsafePerformIO $ getCommand "glGetDoublei_vEXT"

-- glGetDoublev ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetDoublev
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPName@.
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetDoublev v1 v2 = liftIO $ dyn_glGetDoublev ptr_glGetDoublev v1 v2

foreign import CALLCONV "dynamic" dyn_glGetDoublev
  :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetDoublev #-}
ptr_glGetDoublev :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glGetDoublev = unsafePerformIO $ getCommand "glGetDoublev"

-- glGetDriverControlStringQCOM ------------------------------------------------

glGetDriverControlStringQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @driverControlString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetDriverControlStringQCOM v1 v2 v3 v4 = liftIO $ dyn_glGetDriverControlStringQCOM ptr_glGetDriverControlStringQCOM v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetDriverControlStringQCOM
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetDriverControlStringQCOM #-}
ptr_glGetDriverControlStringQCOM :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetDriverControlStringQCOM = unsafePerformIO $ getCommand "glGetDriverControlStringQCOM"

-- glGetDriverControlsQCOM -----------------------------------------------------

glGetDriverControlsQCOM
  :: MonadIO m
  => Ptr GLint -- ^ @num@.
  -> GLsizei -- ^ @size@.
  -> Ptr GLuint -- ^ @driverControls@ pointing to @size@ elements of type @GLuint@.
  -> m ()
glGetDriverControlsQCOM v1 v2 v3 = liftIO $ dyn_glGetDriverControlsQCOM ptr_glGetDriverControlsQCOM v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetDriverControlsQCOM
  :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
  ->         Ptr GLint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetDriverControlsQCOM #-}
ptr_glGetDriverControlsQCOM :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetDriverControlsQCOM = unsafePerformIO $ getCommand "glGetDriverControlsQCOM"

-- glGetError ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetError.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetError.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetError.xhtml OpenGL 4.x>
glGetError
  :: MonadIO m
  => m GLenum -- ^ of type @ErrorCode@.
glGetError = liftIO $ dyn_glGetError ptr_glGetError

foreign import CALLCONV "dynamic" dyn_glGetError
  :: FunPtr (IO GLenum)
  ->         IO GLenum

{-# NOINLINE ptr_glGetError #-}
ptr_glGetError :: FunPtr (IO GLenum)
ptr_glGetError = unsafePerformIO $ getCommand "glGetError"

-- glGetFenceivNV --------------------------------------------------------------

glGetFenceivNV
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> GLenum -- ^ @pname@ of type @FenceParameterNameNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFenceivNV v1 v2 v3 = liftIO $ dyn_glGetFenceivNV ptr_glGetFenceivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFenceivNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFenceivNV #-}
ptr_glGetFenceivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFenceivNV = unsafePerformIO $ getCommand "glGetFenceivNV"

-- glGetFinalCombinerInputParameterfvNV ----------------------------------------

glGetFinalCombinerInputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFinalCombinerInputParameterfvNV v1 v2 v3 = liftIO $ dyn_glGetFinalCombinerInputParameterfvNV ptr_glGetFinalCombinerInputParameterfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFinalCombinerInputParameterfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFinalCombinerInputParameterfvNV #-}
ptr_glGetFinalCombinerInputParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFinalCombinerInputParameterfvNV = unsafePerformIO $ getCommand "glGetFinalCombinerInputParameterfvNV"

-- glGetFinalCombinerInputParameterivNV ----------------------------------------

glGetFinalCombinerInputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFinalCombinerInputParameterivNV v1 v2 v3 = liftIO $ dyn_glGetFinalCombinerInputParameterivNV ptr_glGetFinalCombinerInputParameterivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFinalCombinerInputParameterivNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFinalCombinerInputParameterivNV #-}
ptr_glGetFinalCombinerInputParameterivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFinalCombinerInputParameterivNV = unsafePerformIO $ getCommand "glGetFinalCombinerInputParameterivNV"

-- glGetFirstPerfQueryIdINTEL --------------------------------------------------

glGetFirstPerfQueryIdINTEL
  :: MonadIO m
  => Ptr GLuint -- ^ @queryId@.
  -> m ()
glGetFirstPerfQueryIdINTEL v1 = liftIO $ dyn_glGetFirstPerfQueryIdINTEL ptr_glGetFirstPerfQueryIdINTEL v1

foreign import CALLCONV "dynamic" dyn_glGetFirstPerfQueryIdINTEL
  :: FunPtr (Ptr GLuint -> IO ())
  ->         Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetFirstPerfQueryIdINTEL #-}
ptr_glGetFirstPerfQueryIdINTEL :: FunPtr (Ptr GLuint -> IO ())
ptr_glGetFirstPerfQueryIdINTEL = unsafePerformIO $ getCommand "glGetFirstPerfQueryIdINTEL"

-- glGetFixedv -----------------------------------------------------------------

glGetFixedv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@.
  -> m ()
glGetFixedv v1 v2 = liftIO $ dyn_glGetFixedv ptr_glGetFixedv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFixedv
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetFixedv #-}
ptr_glGetFixedv :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetFixedv = unsafePerformIO $ getCommand "glGetFixedv"

-- glGetFixedvOES --------------------------------------------------------------

glGetFixedvOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetFixedvOES v1 v2 = liftIO $ dyn_glGetFixedvOES ptr_glGetFixedvOES v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFixedvOES
  :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetFixedvOES #-}
ptr_glGetFixedvOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetFixedvOES = unsafePerformIO $ getCommand "glGetFixedvOES"

-- glGetFloatIndexedvEXT -------------------------------------------------------

glGetFloatIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloatIndexedvEXT v1 v2 v3 = liftIO $ dyn_glGetFloatIndexedvEXT ptr_glGetFloatIndexedvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFloatIndexedvEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFloatIndexedvEXT #-}
ptr_glGetFloatIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloatIndexedvEXT = unsafePerformIO $ getCommand "glGetFloatIndexedvEXT"

-- glGetFloati_v ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetFloati_v
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_v v1 v2 v3 = liftIO $ dyn_glGetFloati_v ptr_glGetFloati_v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFloati_v
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFloati_v #-}
ptr_glGetFloati_v :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_v = unsafePerformIO $ getCommand "glGetFloati_v"

-- glGetFloati_vEXT ------------------------------------------------------------

glGetFloati_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_vEXT v1 v2 v3 = liftIO $ dyn_glGetFloati_vEXT ptr_glGetFloati_vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFloati_vEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFloati_vEXT #-}
ptr_glGetFloati_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_vEXT = unsafePerformIO $ getCommand "glGetFloati_vEXT"

-- glGetFloati_vNV -------------------------------------------------------------

glGetFloati_vNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_vNV v1 v2 v3 = liftIO $ dyn_glGetFloati_vNV ptr_glGetFloati_vNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFloati_vNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFloati_vNV #-}
ptr_glGetFloati_vNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_vNV = unsafePerformIO $ getCommand "glGetFloati_vNV"

-- glGetFloatv -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetFloatv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPName@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFloatv v1 v2 = liftIO $ dyn_glGetFloatv ptr_glGetFloatv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFloatv
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFloatv #-}
ptr_glGetFloatv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFloatv = unsafePerformIO $ getCommand "glGetFloatv"

-- glGetFogFuncSGIS ------------------------------------------------------------

glGetFogFuncSGIS
  :: MonadIO m
  => Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE()@ elements of type @GLfloat@.
  -> m ()
glGetFogFuncSGIS v1 = liftIO $ dyn_glGetFogFuncSGIS ptr_glGetFogFuncSGIS v1

foreign import CALLCONV "dynamic" dyn_glGetFogFuncSGIS
  :: FunPtr (Ptr GLfloat -> IO ())
  ->         Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFogFuncSGIS #-}
ptr_glGetFogFuncSGIS :: FunPtr (Ptr GLfloat -> IO ())
ptr_glGetFogFuncSGIS = unsafePerformIO $ getCommand "glGetFogFuncSGIS"

-- glGetFragDataIndex ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFragDataIndex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFragDataIndex.xhtml OpenGL 4.x>
glGetFragDataIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetFragDataIndex v1 v2 = liftIO $ dyn_glGetFragDataIndex ptr_glGetFragDataIndex v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFragDataIndex
  :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
  ->         GLuint -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetFragDataIndex #-}
ptr_glGetFragDataIndex :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataIndex = unsafePerformIO $ getCommand "glGetFragDataIndex"

-- glGetFragDataLocation -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFragDataLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFragDataLocation.xhtml OpenGL 4.x>
glGetFragDataLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetFragDataLocation v1 v2 = liftIO $ dyn_glGetFragDataLocation ptr_glGetFragDataLocation v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFragDataLocation
  :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
  ->         GLuint -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetFragDataLocation #-}
ptr_glGetFragDataLocation :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataLocation = unsafePerformIO $ getCommand "glGetFragDataLocation"

-- glGetFragDataLocationEXT ----------------------------------------------------

glGetFragDataLocationEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetFragDataLocationEXT v1 v2 = liftIO $ dyn_glGetFragDataLocationEXT ptr_glGetFragDataLocationEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGetFragDataLocationEXT
  :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
  ->         GLuint -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetFragDataLocationEXT #-}
ptr_glGetFragDataLocationEXT :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataLocationEXT = unsafePerformIO $ getCommand "glGetFragDataLocationEXT"

-- glGetFragmentLightfvSGIX ----------------------------------------------------

glGetFragmentLightfvSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFragmentLightfvSGIX v1 v2 v3 = liftIO $ dyn_glGetFragmentLightfvSGIX ptr_glGetFragmentLightfvSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFragmentLightfvSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFragmentLightfvSGIX #-}
ptr_glGetFragmentLightfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFragmentLightfvSGIX = unsafePerformIO $ getCommand "glGetFragmentLightfvSGIX"

-- glGetFragmentLightivSGIX ----------------------------------------------------

glGetFragmentLightivSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFragmentLightivSGIX v1 v2 v3 = liftIO $ dyn_glGetFragmentLightivSGIX ptr_glGetFragmentLightivSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFragmentLightivSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFragmentLightivSGIX #-}
ptr_glGetFragmentLightivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFragmentLightivSGIX = unsafePerformIO $ getCommand "glGetFragmentLightivSGIX"

-- glGetFragmentMaterialfvSGIX -------------------------------------------------

glGetFragmentMaterialfvSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFragmentMaterialfvSGIX v1 v2 v3 = liftIO $ dyn_glGetFragmentMaterialfvSGIX ptr_glGetFragmentMaterialfvSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFragmentMaterialfvSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetFragmentMaterialfvSGIX #-}
ptr_glGetFragmentMaterialfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFragmentMaterialfvSGIX = unsafePerformIO $ getCommand "glGetFragmentMaterialfvSGIX"

-- glGetFragmentMaterialivSGIX -------------------------------------------------

glGetFragmentMaterialivSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFragmentMaterialivSGIX v1 v2 v3 = liftIO $ dyn_glGetFragmentMaterialivSGIX ptr_glGetFragmentMaterialivSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFragmentMaterialivSGIX
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFragmentMaterialivSGIX #-}
ptr_glGetFragmentMaterialivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFragmentMaterialivSGIX = unsafePerformIO $ getCommand "glGetFragmentMaterialivSGIX"

-- glGetFramebufferAttachmentParameteriv ---------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFramebufferAttachmentParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferAttachmentParameter.xhtml OpenGL 4.x>
glGetFramebufferAttachmentParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameteriv v1 v2 v3 v4 = liftIO $ dyn_glGetFramebufferAttachmentParameteriv ptr_glGetFramebufferAttachmentParameteriv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetFramebufferAttachmentParameteriv
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFramebufferAttachmentParameteriv #-}
ptr_glGetFramebufferAttachmentParameteriv :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameteriv = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameteriv"

-- glGetFramebufferAttachmentParameterivEXT ------------------------------------

glGetFramebufferAttachmentParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameterivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetFramebufferAttachmentParameterivEXT ptr_glGetFramebufferAttachmentParameterivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetFramebufferAttachmentParameterivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFramebufferAttachmentParameterivEXT #-}
ptr_glGetFramebufferAttachmentParameterivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameterivEXT = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameterivEXT"

-- glGetFramebufferAttachmentParameterivOES ------------------------------------

glGetFramebufferAttachmentParameterivOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameterivOES v1 v2 v3 v4 = liftIO $ dyn_glGetFramebufferAttachmentParameterivOES ptr_glGetFramebufferAttachmentParameterivOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetFramebufferAttachmentParameterivOES
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFramebufferAttachmentParameterivOES #-}
ptr_glGetFramebufferAttachmentParameterivOES :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameterivOES = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameterivOES"

-- glGetFramebufferParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferParameter.xhtml OpenGL 4.x>
glGetFramebufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetFramebufferParameteriv ptr_glGetFramebufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFramebufferParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFramebufferParameteriv #-}
ptr_glGetFramebufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferParameteriv = unsafePerformIO $ getCommand "glGetFramebufferParameteriv"

-- glGetFramebufferParameterivEXT ----------------------------------------------

glGetFramebufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @pname@ of type @GetFramebufferParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetFramebufferParameterivEXT ptr_glGetFramebufferParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetFramebufferParameterivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetFramebufferParameterivEXT #-}
ptr_glGetFramebufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferParameterivEXT = unsafePerformIO $ getCommand "glGetFramebufferParameterivEXT"

-- glGetGraphicsResetStatus ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetGraphicsResetStatus.xhtml OpenGL 4.x>
glGetGraphicsResetStatus
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatus = liftIO $ dyn_glGetGraphicsResetStatus ptr_glGetGraphicsResetStatus

foreign import CALLCONV "dynamic" dyn_glGetGraphicsResetStatus
  :: FunPtr (IO GLenum)
  ->         IO GLenum

{-# NOINLINE ptr_glGetGraphicsResetStatus #-}
ptr_glGetGraphicsResetStatus :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatus = unsafePerformIO $ getCommand "glGetGraphicsResetStatus"

-- glGetGraphicsResetStatusARB -------------------------------------------------

glGetGraphicsResetStatusARB
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusARB = liftIO $ dyn_glGetGraphicsResetStatusARB ptr_glGetGraphicsResetStatusARB

foreign import CALLCONV "dynamic" dyn_glGetGraphicsResetStatusARB
  :: FunPtr (IO GLenum)
  ->         IO GLenum

{-# NOINLINE ptr_glGetGraphicsResetStatusARB #-}
ptr_glGetGraphicsResetStatusARB :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusARB = unsafePerformIO $ getCommand "glGetGraphicsResetStatusARB"

-- glGetGraphicsResetStatusEXT -------------------------------------------------

glGetGraphicsResetStatusEXT
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusEXT = liftIO $ dyn_glGetGraphicsResetStatusEXT ptr_glGetGraphicsResetStatusEXT

foreign import CALLCONV "dynamic" dyn_glGetGraphicsResetStatusEXT
  :: FunPtr (IO GLenum)
  ->         IO GLenum

{-# NOINLINE ptr_glGetGraphicsResetStatusEXT #-}
ptr_glGetGraphicsResetStatusEXT :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusEXT = unsafePerformIO $ getCommand "glGetGraphicsResetStatusEXT"

-- glGetGraphicsResetStatusKHR -------------------------------------------------

glGetGraphicsResetStatusKHR
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusKHR = liftIO $ dyn_glGetGraphicsResetStatusKHR ptr_glGetGraphicsResetStatusKHR

foreign import CALLCONV "dynamic" dyn_glGetGraphicsResetStatusKHR
  :: FunPtr (IO GLenum)
  ->         IO GLenum

{-# NOINLINE ptr_glGetGraphicsResetStatusKHR #-}
ptr_glGetGraphicsResetStatusKHR :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusKHR = unsafePerformIO $ getCommand "glGetGraphicsResetStatusKHR"

-- glGetHandleARB --------------------------------------------------------------

glGetHandleARB
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> m GLhandleARB -- ^ of type @handleARB@.
glGetHandleARB v1 = liftIO $ dyn_glGetHandleARB ptr_glGetHandleARB v1

foreign import CALLCONV "dynamic" dyn_glGetHandleARB
  :: FunPtr (GLenum -> IO GLhandleARB)
  ->         GLenum -> IO GLhandleARB

{-# NOINLINE ptr_glGetHandleARB #-}
ptr_glGetHandleARB :: FunPtr (GLenum -> IO GLhandleARB)
ptr_glGetHandleARB = unsafePerformIO $ getCommand "glGetHandleARB"

-- glGetHistogram --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogram.xml OpenGL 2.x>
glGetHistogram
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLboolean -- ^ @reset@ of type @Boolean@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetHistogram v1 v2 v3 v4 v5 = liftIO $ dyn_glGetHistogram ptr_glGetHistogram v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetHistogram
  :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetHistogram #-}
ptr_glGetHistogram :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetHistogram = unsafePerformIO $ getCommand "glGetHistogram"

-- glGetHistogramEXT -----------------------------------------------------------

glGetHistogramEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTargetEXT@.
  -> GLboolean -- ^ @reset@ of type @Boolean@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetHistogramEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glGetHistogramEXT ptr_glGetHistogramEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetHistogramEXT
  :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetHistogramEXT #-}
ptr_glGetHistogramEXT :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetHistogramEXT = unsafePerformIO $ getCommand "glGetHistogramEXT"

-- glGetHistogramParameterfv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameter.xml OpenGL 2.x>
glGetHistogramParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetHistogramParameterfv v1 v2 v3 = liftIO $ dyn_glGetHistogramParameterfv ptr_glGetHistogramParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetHistogramParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetHistogramParameterfv #-}
ptr_glGetHistogramParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetHistogramParameterfv = unsafePerformIO $ getCommand "glGetHistogramParameterfv"

-- glGetHistogramParameterfvEXT ------------------------------------------------

glGetHistogramParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTargetEXT@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPNameEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetHistogramParameterfvEXT v1 v2 v3 = liftIO $ dyn_glGetHistogramParameterfvEXT ptr_glGetHistogramParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetHistogramParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetHistogramParameterfvEXT #-}
ptr_glGetHistogramParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetHistogramParameterfvEXT = unsafePerformIO $ getCommand "glGetHistogramParameterfvEXT"

-- glGetHistogramParameteriv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameter.xml OpenGL 2.x>
glGetHistogramParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetHistogramParameteriv v1 v2 v3 = liftIO $ dyn_glGetHistogramParameteriv ptr_glGetHistogramParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetHistogramParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetHistogramParameteriv #-}
ptr_glGetHistogramParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetHistogramParameteriv = unsafePerformIO $ getCommand "glGetHistogramParameteriv"

-- glGetHistogramParameterivEXT ------------------------------------------------

glGetHistogramParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTargetEXT@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPNameEXT@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetHistogramParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetHistogramParameterivEXT ptr_glGetHistogramParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetHistogramParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetHistogramParameterivEXT #-}
ptr_glGetHistogramParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetHistogramParameterivEXT = unsafePerformIO $ getCommand "glGetHistogramParameterivEXT"

-- glGetHistogramParameterxvOES ------------------------------------------------

glGetHistogramParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetHistogramParameterxvOES v1 v2 v3 = liftIO $ dyn_glGetHistogramParameterxvOES ptr_glGetHistogramParameterxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetHistogramParameterxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetHistogramParameterxvOES #-}
ptr_glGetHistogramParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetHistogramParameterxvOES = unsafePerformIO $ getCommand "glGetHistogramParameterxvOES"

-- glGetImageHandleARB ---------------------------------------------------------

glGetImageHandleARB
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@.
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @format@.
  -> m GLuint64
glGetImageHandleARB v1 v2 v3 v4 v5 = liftIO $ dyn_glGetImageHandleARB ptr_glGetImageHandleARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetImageHandleARB
  :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
  ->         GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64

{-# NOINLINE ptr_glGetImageHandleARB #-}
ptr_glGetImageHandleARB :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
ptr_glGetImageHandleARB = unsafePerformIO $ getCommand "glGetImageHandleARB"

-- glGetImageHandleNV ----------------------------------------------------------

glGetImageHandleNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type @Boolean@.
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @format@.
  -> m GLuint64
glGetImageHandleNV v1 v2 v3 v4 v5 = liftIO $ dyn_glGetImageHandleNV ptr_glGetImageHandleNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetImageHandleNV
  :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
  ->         GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64

{-# NOINLINE ptr_glGetImageHandleNV #-}
ptr_glGetImageHandleNV :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
ptr_glGetImageHandleNV = unsafePerformIO $ getCommand "glGetImageHandleNV"

-- glGetImageTransformParameterfvHP --------------------------------------------

glGetImageTransformParameterfvHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetImageTransformParameterfvHP v1 v2 v3 = liftIO $ dyn_glGetImageTransformParameterfvHP ptr_glGetImageTransformParameterfvHP v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetImageTransformParameterfvHP
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetImageTransformParameterfvHP #-}
ptr_glGetImageTransformParameterfvHP :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetImageTransformParameterfvHP = unsafePerformIO $ getCommand "glGetImageTransformParameterfvHP"

-- glGetImageTransformParameterivHP --------------------------------------------

glGetImageTransformParameterivHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetImageTransformParameterivHP v1 v2 v3 = liftIO $ dyn_glGetImageTransformParameterivHP ptr_glGetImageTransformParameterivHP v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetImageTransformParameterivHP
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetImageTransformParameterivHP #-}
ptr_glGetImageTransformParameterivHP :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetImageTransformParameterivHP = unsafePerformIO $ getCommand "glGetImageTransformParameterivHP"

-- glGetInfoLogARB -------------------------------------------------------------

glGetInfoLogARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLcharARB -- ^ @infoLog@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetInfoLogARB v1 v2 v3 v4 = liftIO $ dyn_glGetInfoLogARB ptr_glGetInfoLogARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetInfoLogARB
  :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
  ->         GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ()

{-# NOINLINE ptr_glGetInfoLogARB #-}
ptr_glGetInfoLogARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
ptr_glGetInfoLogARB = unsafePerformIO $ getCommand "glGetInfoLogARB"

-- glGetInstrumentsSGIX --------------------------------------------------------

glGetInstrumentsSGIX
  :: MonadIO m
  => m GLint
glGetInstrumentsSGIX = liftIO $ dyn_glGetInstrumentsSGIX ptr_glGetInstrumentsSGIX

foreign import CALLCONV "dynamic" dyn_glGetInstrumentsSGIX
  :: FunPtr (IO GLint)
  ->         IO GLint

{-# NOINLINE ptr_glGetInstrumentsSGIX #-}
ptr_glGetInstrumentsSGIX :: FunPtr (IO GLint)
ptr_glGetInstrumentsSGIX = unsafePerformIO $ getCommand "glGetInstrumentsSGIX"

-- glGetInteger64i_v -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetInteger64i_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint64 -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint64@.
  -> m ()
glGetInteger64i_v v1 v2 v3 = liftIO $ dyn_glGetInteger64i_v ptr_glGetInteger64i_v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetInteger64i_v
  :: FunPtr (GLenum -> GLuint -> Ptr GLint64 -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetInteger64i_v #-}
ptr_glGetInteger64i_v :: FunPtr (GLenum -> GLuint -> Ptr GLint64 -> IO ())
ptr_glGetInteger64i_v = unsafePerformIO $ getCommand "glGetInteger64i_v"

-- glGetInteger64v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetInteger64v
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetInteger64v v1 v2 = liftIO $ dyn_glGetInteger64v ptr_glGetInteger64v v1 v2

foreign import CALLCONV "dynamic" dyn_glGetInteger64v
  :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
  ->         GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetInteger64v #-}
ptr_glGetInteger64v :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
ptr_glGetInteger64v = unsafePerformIO $ getCommand "glGetInteger64v"

-- glGetInteger64vAPPLE --------------------------------------------------------

glGetInteger64vAPPLE
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@.
  -> m ()
glGetInteger64vAPPLE v1 v2 = liftIO $ dyn_glGetInteger64vAPPLE ptr_glGetInteger64vAPPLE v1 v2

foreign import CALLCONV "dynamic" dyn_glGetInteger64vAPPLE
  :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
  ->         GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetInteger64vAPPLE #-}
ptr_glGetInteger64vAPPLE :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
ptr_glGetInteger64vAPPLE = unsafePerformIO $ getCommand "glGetInteger64vAPPLE"

-- glGetIntegerIndexedvEXT -----------------------------------------------------

glGetIntegerIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint@.
  -> m ()
glGetIntegerIndexedvEXT v1 v2 v3 = liftIO $ dyn_glGetIntegerIndexedvEXT ptr_glGetIntegerIndexedvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetIntegerIndexedvEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetIntegerIndexedvEXT #-}
ptr_glGetIntegerIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegerIndexedvEXT = unsafePerformIO $ getCommand "glGetIntegerIndexedvEXT"

-- glGetIntegeri_v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetIntegeri_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint@.
  -> m ()
glGetIntegeri_v v1 v2 v3 = liftIO $ dyn_glGetIntegeri_v ptr_glGetIntegeri_v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetIntegeri_v
  :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetIntegeri_v #-}
ptr_glGetIntegeri_v :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegeri_v = unsafePerformIO $ getCommand "glGetIntegeri_v"

-- glGetIntegeri_vEXT ----------------------------------------------------------

glGetIntegeri_vEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@.
  -> m ()
glGetIntegeri_vEXT v1 v2 v3 = liftIO $ dyn_glGetIntegeri_vEXT ptr_glGetIntegeri_vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetIntegeri_vEXT
  :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetIntegeri_vEXT #-}
ptr_glGetIntegeri_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegeri_vEXT = unsafePerformIO $ getCommand "glGetIntegeri_vEXT"

-- glGetIntegerui64i_vNV -------------------------------------------------------

glGetIntegerui64i_vNV
  :: MonadIO m
  => GLenum -- ^ @value@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint64EXT -- ^ @result@ pointing to @COMPSIZE(value)@ elements of type @GLuint64EXT@.
  -> m ()
glGetIntegerui64i_vNV v1 v2 v3 = liftIO $ dyn_glGetIntegerui64i_vNV ptr_glGetIntegerui64i_vNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetIntegerui64i_vNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint64EXT -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint64EXT -> IO ()

{-# NOINLINE ptr_glGetIntegerui64i_vNV #-}
ptr_glGetIntegerui64i_vNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint64EXT -> IO ())
ptr_glGetIntegerui64i_vNV = unsafePerformIO $ getCommand "glGetIntegerui64i_vNV"

-- glGetIntegerui64vNV ---------------------------------------------------------

glGetIntegerui64vNV
  :: MonadIO m
  => GLenum -- ^ @value@.
  -> Ptr GLuint64EXT -- ^ @result@ pointing to @COMPSIZE(value)@ elements of type @GLuint64EXT@.
  -> m ()
glGetIntegerui64vNV v1 v2 = liftIO $ dyn_glGetIntegerui64vNV ptr_glGetIntegerui64vNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGetIntegerui64vNV
  :: FunPtr (GLenum -> Ptr GLuint64EXT -> IO ())
  ->         GLenum -> Ptr GLuint64EXT -> IO ()

{-# NOINLINE ptr_glGetIntegerui64vNV #-}
ptr_glGetIntegerui64vNV :: FunPtr (GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetIntegerui64vNV = unsafePerformIO $ getCommand "glGetIntegerui64vNV"

-- glGetIntegerv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>
glGetIntegerv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPName@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetIntegerv v1 v2 = liftIO $ dyn_glGetIntegerv ptr_glGetIntegerv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetIntegerv
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetIntegerv #-}
ptr_glGetIntegerv :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetIntegerv = unsafePerformIO $ getCommand "glGetIntegerv"

-- glGetInternalformatSampleivNV -----------------------------------------------

glGetInternalformatSampleivNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizei -- ^ @samples@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetInternalformatSampleivNV v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetInternalformatSampleivNV ptr_glGetInternalformatSampleivNV v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetInternalformatSampleivNV
  :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLsizei -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLsizei -> GLenum -> GLsizei -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetInternalformatSampleivNV #-}
ptr_glGetInternalformatSampleivNV :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetInternalformatSampleivNV = unsafePerformIO $ getCommand "glGetInternalformatSampleivNV"

-- glGetInternalformati64v -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetInternalformat.xhtml OpenGL 4.x>
glGetInternalformati64v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint64 -- ^ @params@ pointing to @bufSize@ elements of type @GLint64@.
  -> m ()
glGetInternalformati64v v1 v2 v3 v4 v5 = liftIO $ dyn_glGetInternalformati64v ptr_glGetInternalformati64v v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetInternalformati64v
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint64 -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetInternalformati64v #-}
ptr_glGetInternalformati64v :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint64 -> IO ())
ptr_glGetInternalformati64v = unsafePerformIO $ getCommand "glGetInternalformati64v"

-- glGetInternalformativ -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetInternalformat.xhtml OpenGL 4.x>
glGetInternalformativ
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetInternalformativ v1 v2 v3 v4 v5 = liftIO $ dyn_glGetInternalformativ ptr_glGetInternalformativ v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetInternalformativ
  :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetInternalformativ #-}
ptr_glGetInternalformativ :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetInternalformativ = unsafePerformIO $ getCommand "glGetInternalformativ"

-- glGetInvariantBooleanvEXT ---------------------------------------------------

glGetInvariantBooleanvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @Boolean@.
  -> m ()
glGetInvariantBooleanvEXT v1 v2 v3 = liftIO $ dyn_glGetInvariantBooleanvEXT ptr_glGetInvariantBooleanvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetInvariantBooleanvEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
  ->         GLuint -> GLenum -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glGetInvariantBooleanvEXT #-}
ptr_glGetInvariantBooleanvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
ptr_glGetInvariantBooleanvEXT = unsafePerformIO $ getCommand "glGetInvariantBooleanvEXT"

-- glGetInvariantFloatvEXT -----------------------------------------------------

glGetInvariantFloatvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLfloat@.
  -> m ()
glGetInvariantFloatvEXT v1 v2 v3 = liftIO $ dyn_glGetInvariantFloatvEXT ptr_glGetInvariantFloatvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetInvariantFloatvEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetInvariantFloatvEXT #-}
ptr_glGetInvariantFloatvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetInvariantFloatvEXT = unsafePerformIO $ getCommand "glGetInvariantFloatvEXT"

-- glGetInvariantIntegervEXT ---------------------------------------------------

glGetInvariantIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLint@.
  -> m ()
glGetInvariantIntegervEXT v1 v2 v3 = liftIO $ dyn_glGetInvariantIntegervEXT ptr_glGetInvariantIntegervEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetInvariantIntegervEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetInvariantIntegervEXT #-}
ptr_glGetInvariantIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetInvariantIntegervEXT = unsafePerformIO $ getCommand "glGetInvariantIntegervEXT"

-- glGetLightfv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetLight.xml OpenGL 2.x>
glGetLightfv
  :: MonadIO m
  => GLenum -- ^ @light@ of type @LightName@.
  -> GLenum -- ^ @pname@ of type @LightParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetLightfv v1 v2 v3 = liftIO $ dyn_glGetLightfv ptr_glGetLightfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLightfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetLightfv #-}
ptr_glGetLightfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetLightfv = unsafePerformIO $ getCommand "glGetLightfv"

-- glGetLightiv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetLight.xml OpenGL 2.x>
glGetLightiv
  :: MonadIO m
  => GLenum -- ^ @light@ of type @LightName@.
  -> GLenum -- ^ @pname@ of type @LightParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetLightiv v1 v2 v3 = liftIO $ dyn_glGetLightiv ptr_glGetLightiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLightiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetLightiv #-}
ptr_glGetLightiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetLightiv = unsafePerformIO $ getCommand "glGetLightiv"

-- glGetLightxOES --------------------------------------------------------------

glGetLightxOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxOES v1 v2 v3 = liftIO $ dyn_glGetLightxOES ptr_glGetLightxOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLightxOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetLightxOES #-}
ptr_glGetLightxOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxOES = unsafePerformIO $ getCommand "glGetLightxOES"

-- glGetLightxv ----------------------------------------------------------------

glGetLightxv
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxv v1 v2 v3 = liftIO $ dyn_glGetLightxv ptr_glGetLightxv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLightxv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetLightxv #-}
ptr_glGetLightxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxv = unsafePerformIO $ getCommand "glGetLightxv"

-- glGetLightxvOES -------------------------------------------------------------

glGetLightxvOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxvOES v1 v2 v3 = liftIO $ dyn_glGetLightxvOES ptr_glGetLightxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLightxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetLightxvOES #-}
ptr_glGetLightxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxvOES = unsafePerformIO $ getCommand "glGetLightxvOES"

-- glGetListParameterfvSGIX ----------------------------------------------------

glGetListParameterfvSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type @ListParameterName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glGetListParameterfvSGIX v1 v2 v3 = liftIO $ dyn_glGetListParameterfvSGIX ptr_glGetListParameterfvSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetListParameterfvSGIX
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetListParameterfvSGIX #-}
ptr_glGetListParameterfvSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetListParameterfvSGIX = unsafePerformIO $ getCommand "glGetListParameterfvSGIX"

-- glGetListParameterivSGIX ----------------------------------------------------

glGetListParameterivSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type @ListParameterName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glGetListParameterivSGIX v1 v2 v3 = liftIO $ dyn_glGetListParameterivSGIX ptr_glGetListParameterivSGIX v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetListParameterivSGIX
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetListParameterivSGIX #-}
ptr_glGetListParameterivSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetListParameterivSGIX = unsafePerformIO $ getCommand "glGetListParameterivSGIX"

-- glGetLocalConstantBooleanvEXT -----------------------------------------------

glGetLocalConstantBooleanvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @Boolean@.
  -> m ()
glGetLocalConstantBooleanvEXT v1 v2 v3 = liftIO $ dyn_glGetLocalConstantBooleanvEXT ptr_glGetLocalConstantBooleanvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLocalConstantBooleanvEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
  ->         GLuint -> GLenum -> Ptr GLboolean -> IO ()

{-# NOINLINE ptr_glGetLocalConstantBooleanvEXT #-}
ptr_glGetLocalConstantBooleanvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
ptr_glGetLocalConstantBooleanvEXT = unsafePerformIO $ getCommand "glGetLocalConstantBooleanvEXT"

-- glGetLocalConstantFloatvEXT -------------------------------------------------

glGetLocalConstantFloatvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLfloat@.
  -> m ()
glGetLocalConstantFloatvEXT v1 v2 v3 = liftIO $ dyn_glGetLocalConstantFloatvEXT ptr_glGetLocalConstantFloatvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLocalConstantFloatvEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetLocalConstantFloatvEXT #-}
ptr_glGetLocalConstantFloatvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetLocalConstantFloatvEXT = unsafePerformIO $ getCommand "glGetLocalConstantFloatvEXT"

-- glGetLocalConstantIntegervEXT -----------------------------------------------

glGetLocalConstantIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLint@.
  -> m ()
glGetLocalConstantIntegervEXT v1 v2 v3 = liftIO $ dyn_glGetLocalConstantIntegervEXT ptr_glGetLocalConstantIntegervEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetLocalConstantIntegervEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetLocalConstantIntegervEXT #-}
ptr_glGetLocalConstantIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetLocalConstantIntegervEXT = unsafePerformIO $ getCommand "glGetLocalConstantIntegervEXT"

-- glGetMapAttribParameterfvNV -------------------------------------------------

glGetMapAttribParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @MapAttribParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMapAttribParameterfvNV v1 v2 v3 v4 = liftIO $ dyn_glGetMapAttribParameterfvNV ptr_glGetMapAttribParameterfvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMapAttribParameterfvNV
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMapAttribParameterfvNV #-}
ptr_glGetMapAttribParameterfvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapAttribParameterfvNV = unsafePerformIO $ getCommand "glGetMapAttribParameterfvNV"

-- glGetMapAttribParameterivNV -------------------------------------------------

glGetMapAttribParameterivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @MapAttribParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMapAttribParameterivNV v1 v2 v3 v4 = liftIO $ dyn_glGetMapAttribParameterivNV ptr_glGetMapAttribParameterivNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMapAttribParameterivNV
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMapAttribParameterivNV #-}
ptr_glGetMapAttribParameterivNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapAttribParameterivNV = unsafePerformIO $ getCommand "glGetMapAttribParameterivNV"

-- glGetMapControlPointsNV -----------------------------------------------------

glGetMapControlPointsNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @type@ of type @MapTypeNV@.
  -> GLsizei -- ^ @ustride@.
  -> GLsizei -- ^ @vstride@.
  -> GLboolean -- ^ @packed@ of type @Boolean@.
  -> Ptr a -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @a@.
  -> m ()
glGetMapControlPointsNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetMapControlPointsNV ptr_glGetMapControlPointsNV v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetMapControlPointsNV
  :: FunPtr (GLenum -> GLuint -> GLenum -> GLsizei -> GLsizei -> GLboolean -> Ptr a -> IO ())
  ->         GLenum -> GLuint -> GLenum -> GLsizei -> GLsizei -> GLboolean -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetMapControlPointsNV #-}
ptr_glGetMapControlPointsNV :: FunPtr (GLenum -> GLuint -> GLenum -> GLsizei -> GLsizei -> GLboolean -> Ptr a -> IO ())
ptr_glGetMapControlPointsNV = unsafePerformIO $ getCommand "glGetMapControlPointsNV"

-- glGetMapParameterfvNV -------------------------------------------------------

glGetMapParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @pname@ of type @MapParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(target,pname)@ elements of type @GLfloat@.
  -> m ()
glGetMapParameterfvNV v1 v2 v3 = liftIO $ dyn_glGetMapParameterfvNV ptr_glGetMapParameterfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapParameterfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMapParameterfvNV #-}
ptr_glGetMapParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapParameterfvNV = unsafePerformIO $ getCommand "glGetMapParameterfvNV"

-- glGetMapParameterivNV -------------------------------------------------------

glGetMapParameterivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @pname@ of type @MapParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(target,pname)@ elements of type @GLint@.
  -> m ()
glGetMapParameterivNV v1 v2 v3 = liftIO $ dyn_glGetMapParameterivNV ptr_glGetMapParameterivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapParameterivNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMapParameterivNV #-}
ptr_glGetMapParameterivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapParameterivNV = unsafePerformIO $ getCommand "glGetMapParameterivNV"

-- glGetMapdv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>
glGetMapdv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MapTarget@.
  -> GLenum -- ^ @query@ of type @GetMapQuery@.
  -> Ptr GLdouble -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLdouble@.
  -> m ()
glGetMapdv v1 v2 v3 = liftIO $ dyn_glGetMapdv ptr_glGetMapdv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapdv
  :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetMapdv #-}
ptr_glGetMapdv :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetMapdv = unsafePerformIO $ getCommand "glGetMapdv"

-- glGetMapfv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>
glGetMapfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MapTarget@.
  -> GLenum -- ^ @query@ of type @GetMapQuery@.
  -> Ptr GLfloat -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLfloat@.
  -> m ()
glGetMapfv v1 v2 v3 = liftIO $ dyn_glGetMapfv ptr_glGetMapfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMapfv #-}
ptr_glGetMapfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapfv = unsafePerformIO $ getCommand "glGetMapfv"

-- glGetMapiv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>
glGetMapiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MapTarget@.
  -> GLenum -- ^ @query@ of type @GetMapQuery@.
  -> Ptr GLint -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLint@.
  -> m ()
glGetMapiv v1 v2 v3 = liftIO $ dyn_glGetMapiv ptr_glGetMapiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMapiv #-}
ptr_glGetMapiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapiv = unsafePerformIO $ getCommand "glGetMapiv"

-- glGetMapxvOES ---------------------------------------------------------------

glGetMapxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> Ptr GLfixed -- ^ @v@ pointing to @COMPSIZE(query)@ elements of type @GLfixed@.
  -> m ()
glGetMapxvOES v1 v2 v3 = liftIO $ dyn_glGetMapxvOES ptr_glGetMapxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMapxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetMapxvOES #-}
ptr_glGetMapxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMapxvOES = unsafePerformIO $ getCommand "glGetMapxvOES"

-- glGetMaterialfv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterial.xml OpenGL 2.x>
glGetMaterialfv
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMaterialfv v1 v2 v3 = liftIO $ dyn_glGetMaterialfv ptr_glGetMaterialfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMaterialfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMaterialfv #-}
ptr_glGetMaterialfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMaterialfv = unsafePerformIO $ getCommand "glGetMaterialfv"

-- glGetMaterialiv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterial.xml OpenGL 2.x>
glGetMaterialiv
  :: MonadIO m
  => GLenum -- ^ @face@ of type @MaterialFace@.
  -> GLenum -- ^ @pname@ of type @MaterialParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMaterialiv v1 v2 v3 = liftIO $ dyn_glGetMaterialiv ptr_glGetMaterialiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMaterialiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMaterialiv #-}
ptr_glGetMaterialiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMaterialiv = unsafePerformIO $ getCommand "glGetMaterialiv"

-- glGetMaterialxOES -----------------------------------------------------------

glGetMaterialxOES
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glGetMaterialxOES v1 v2 v3 = liftIO $ dyn_glGetMaterialxOES ptr_glGetMaterialxOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMaterialxOES
  :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
  ->         GLenum -> GLenum -> GLfixed -> IO ()

{-# NOINLINE ptr_glGetMaterialxOES #-}
ptr_glGetMaterialxOES :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glGetMaterialxOES = unsafePerformIO $ getCommand "glGetMaterialxOES"

-- glGetMaterialxv -------------------------------------------------------------

glGetMaterialxv
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetMaterialxv v1 v2 v3 = liftIO $ dyn_glGetMaterialxv ptr_glGetMaterialxv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMaterialxv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetMaterialxv #-}
ptr_glGetMaterialxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMaterialxv = unsafePerformIO $ getCommand "glGetMaterialxv"

-- glGetMaterialxvOES ----------------------------------------------------------

glGetMaterialxvOES
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetMaterialxvOES v1 v2 v3 = liftIO $ dyn_glGetMaterialxvOES ptr_glGetMaterialxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMaterialxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetMaterialxvOES #-}
ptr_glGetMaterialxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMaterialxvOES = unsafePerformIO $ getCommand "glGetMaterialxvOES"

-- glGetMinmax -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmax.xml OpenGL 2.x>
glGetMinmax
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLboolean -- ^ @reset@ of type @Boolean@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetMinmax v1 v2 v3 v4 v5 = liftIO $ dyn_glGetMinmax ptr_glGetMinmax v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetMinmax
  :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetMinmax #-}
ptr_glGetMinmax :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMinmax = unsafePerformIO $ getCommand "glGetMinmax"

-- glGetMinmaxEXT --------------------------------------------------------------

glGetMinmaxEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTargetEXT@.
  -> GLboolean -- ^ @reset@ of type @Boolean@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetMinmaxEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glGetMinmaxEXT ptr_glGetMinmaxEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetMinmaxEXT
  :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetMinmaxEXT #-}
ptr_glGetMinmaxEXT :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMinmaxEXT = unsafePerformIO $ getCommand "glGetMinmaxEXT"

-- glGetMinmaxParameterfv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameter.xml OpenGL 2.x>
glGetMinmaxParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMinmaxParameterfv v1 v2 v3 = liftIO $ dyn_glGetMinmaxParameterfv ptr_glGetMinmaxParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMinmaxParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMinmaxParameterfv #-}
ptr_glGetMinmaxParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMinmaxParameterfv = unsafePerformIO $ getCommand "glGetMinmaxParameterfv"

-- glGetMinmaxParameterfvEXT ---------------------------------------------------

glGetMinmaxParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTargetEXT@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPNameEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMinmaxParameterfvEXT v1 v2 v3 = liftIO $ dyn_glGetMinmaxParameterfvEXT ptr_glGetMinmaxParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMinmaxParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMinmaxParameterfvEXT #-}
ptr_glGetMinmaxParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMinmaxParameterfvEXT = unsafePerformIO $ getCommand "glGetMinmaxParameterfvEXT"

-- glGetMinmaxParameteriv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameter.xml OpenGL 2.x>
glGetMinmaxParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMinmaxParameteriv v1 v2 v3 = liftIO $ dyn_glGetMinmaxParameteriv ptr_glGetMinmaxParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMinmaxParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMinmaxParameteriv #-}
ptr_glGetMinmaxParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMinmaxParameteriv = unsafePerformIO $ getCommand "glGetMinmaxParameteriv"

-- glGetMinmaxParameterivEXT ---------------------------------------------------

glGetMinmaxParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTargetEXT@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPNameEXT@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMinmaxParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetMinmaxParameterivEXT ptr_glGetMinmaxParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMinmaxParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMinmaxParameterivEXT #-}
ptr_glGetMinmaxParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMinmaxParameterivEXT = unsafePerformIO $ getCommand "glGetMinmaxParameterivEXT"

-- glGetMultiTexEnvfvEXT -------------------------------------------------------

glGetMultiTexEnvfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureEnvTarget@.
  -> GLenum -- ^ @pname@ of type @TextureEnvParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexEnvfvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexEnvfvEXT ptr_glGetMultiTexEnvfvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexEnvfvEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultiTexEnvfvEXT #-}
ptr_glGetMultiTexEnvfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexEnvfvEXT = unsafePerformIO $ getCommand "glGetMultiTexEnvfvEXT"

-- glGetMultiTexEnvivEXT -------------------------------------------------------

glGetMultiTexEnvivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureEnvTarget@.
  -> GLenum -- ^ @pname@ of type @TextureEnvParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexEnvivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexEnvivEXT ptr_glGetMultiTexEnvivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexEnvivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMultiTexEnvivEXT #-}
ptr_glGetMultiTexEnvivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexEnvivEXT = unsafePerformIO $ getCommand "glGetMultiTexEnvivEXT"

-- glGetMultiTexGendvEXT -------------------------------------------------------

glGetMultiTexGendvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetMultiTexGendvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexGendvEXT ptr_glGetMultiTexGendvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexGendvEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetMultiTexGendvEXT #-}
ptr_glGetMultiTexGendvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetMultiTexGendvEXT = unsafePerformIO $ getCommand "glGetMultiTexGendvEXT"

-- glGetMultiTexGenfvEXT -------------------------------------------------------

glGetMultiTexGenfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexGenfvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexGenfvEXT ptr_glGetMultiTexGenfvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexGenfvEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultiTexGenfvEXT #-}
ptr_glGetMultiTexGenfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexGenfvEXT = unsafePerformIO $ getCommand "glGetMultiTexGenfvEXT"

-- glGetMultiTexGenivEXT -------------------------------------------------------

glGetMultiTexGenivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexGenivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexGenivEXT ptr_glGetMultiTexGenivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexGenivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMultiTexGenivEXT #-}
ptr_glGetMultiTexGenivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexGenivEXT = unsafePerformIO $ getCommand "glGetMultiTexGenivEXT"

-- glGetMultiTexImageEXT -------------------------------------------------------

glGetMultiTexImageEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetMultiTexImageEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetMultiTexImageEXT ptr_glGetMultiTexImageEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetMultiTexImageEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetMultiTexImageEXT #-}
ptr_glGetMultiTexImageEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMultiTexImageEXT = unsafePerformIO $ getCommand "glGetMultiTexImageEXT"

-- glGetMultiTexLevelParameterfvEXT --------------------------------------------

glGetMultiTexLevelParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexLevelParameterfvEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glGetMultiTexLevelParameterfvEXT ptr_glGetMultiTexLevelParameterfvEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetMultiTexLevelParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultiTexLevelParameterfvEXT #-}
ptr_glGetMultiTexLevelParameterfvEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexLevelParameterfvEXT = unsafePerformIO $ getCommand "glGetMultiTexLevelParameterfvEXT"

-- glGetMultiTexLevelParameterivEXT --------------------------------------------

glGetMultiTexLevelParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexLevelParameterivEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glGetMultiTexLevelParameterivEXT ptr_glGetMultiTexLevelParameterivEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetMultiTexLevelParameterivEXT
  :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMultiTexLevelParameterivEXT #-}
ptr_glGetMultiTexLevelParameterivEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexLevelParameterivEXT = unsafePerformIO $ getCommand "glGetMultiTexLevelParameterivEXT"

-- glGetMultiTexParameterIivEXT ------------------------------------------------

glGetMultiTexParameterIivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexParameterIivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexParameterIivEXT ptr_glGetMultiTexParameterIivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexParameterIivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMultiTexParameterIivEXT #-}
ptr_glGetMultiTexParameterIivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexParameterIivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterIivEXT"

-- glGetMultiTexParameterIuivEXT -----------------------------------------------

glGetMultiTexParameterIuivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetMultiTexParameterIuivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexParameterIuivEXT ptr_glGetMultiTexParameterIuivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexParameterIuivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetMultiTexParameterIuivEXT #-}
ptr_glGetMultiTexParameterIuivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetMultiTexParameterIuivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterIuivEXT"

-- glGetMultiTexParameterfvEXT -------------------------------------------------

glGetMultiTexParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexParameterfvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexParameterfvEXT ptr_glGetMultiTexParameterfvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultiTexParameterfvEXT #-}
ptr_glGetMultiTexParameterfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexParameterfvEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterfvEXT"

-- glGetMultiTexParameterivEXT -------------------------------------------------

glGetMultiTexParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexParameterivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetMultiTexParameterivEXT ptr_glGetMultiTexParameterivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetMultiTexParameterivEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetMultiTexParameterivEXT #-}
ptr_glGetMultiTexParameterivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexParameterivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterivEXT"

-- glGetMultisamplefv ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetMultisample.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetMultisample.xhtml OpenGL 4.x>
glGetMultisamplefv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @val@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultisamplefv v1 v2 v3 = liftIO $ dyn_glGetMultisamplefv ptr_glGetMultisamplefv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMultisamplefv
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultisamplefv #-}
ptr_glGetMultisamplefv :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetMultisamplefv = unsafePerformIO $ getCommand "glGetMultisamplefv"

-- glGetMultisamplefvNV --------------------------------------------------------

glGetMultisamplefvNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetMultisamplePNameNV@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @val@ pointing to @2@ elements of type @GLfloat@.
  -> m ()
glGetMultisamplefvNV v1 v2 v3 = liftIO $ dyn_glGetMultisamplefvNV ptr_glGetMultisamplefvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetMultisamplefvNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetMultisamplefvNV #-}
ptr_glGetMultisamplefvNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetMultisamplefvNV = unsafePerformIO $ getCommand "glGetMultisamplefvNV"

-- glGetNamedBufferParameteri64v -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>
glGetNamedBufferParameteri64v
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@.
  -> m ()
glGetNamedBufferParameteri64v v1 v2 v3 = liftIO $ dyn_glGetNamedBufferParameteri64v ptr_glGetNamedBufferParameteri64v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferParameteri64v
  :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetNamedBufferParameteri64v #-}
ptr_glGetNamedBufferParameteri64v :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetNamedBufferParameteri64v = unsafePerformIO $ getCommand "glGetNamedBufferParameteri64v"

-- glGetNamedBufferParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>
glGetNamedBufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedBufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetNamedBufferParameteriv ptr_glGetNamedBufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferParameteriv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedBufferParameteriv #-}
ptr_glGetNamedBufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedBufferParameteriv = unsafePerformIO $ getCommand "glGetNamedBufferParameteriv"

-- glGetNamedBufferParameterivEXT ----------------------------------------------

glGetNamedBufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedBufferParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetNamedBufferParameterivEXT ptr_glGetNamedBufferParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferParameterivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedBufferParameterivEXT #-}
ptr_glGetNamedBufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedBufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedBufferParameterivEXT"

-- glGetNamedBufferParameterui64vNV --------------------------------------------

glGetNamedBufferParameterui64vNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetNamedBufferParameterui64vNV v1 v2 v3 = liftIO $ dyn_glGetNamedBufferParameterui64vNV ptr_glGetNamedBufferParameterui64vNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferParameterui64vNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint64EXT -> IO ()

{-# NOINLINE ptr_glGetNamedBufferParameterui64vNV #-}
ptr_glGetNamedBufferParameterui64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetNamedBufferParameterui64vNV = unsafePerformIO $ getCommand "glGetNamedBufferParameterui64vNV"

-- glGetNamedBufferPointerv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferPointerv.xhtml OpenGL 4.x>
glGetNamedBufferPointerv
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetNamedBufferPointerv v1 v2 v3 = liftIO $ dyn_glGetNamedBufferPointerv ptr_glGetNamedBufferPointerv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferPointerv
  :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLuint -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetNamedBufferPointerv #-}
ptr_glGetNamedBufferPointerv :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetNamedBufferPointerv = unsafePerformIO $ getCommand "glGetNamedBufferPointerv"

-- glGetNamedBufferPointervEXT -------------------------------------------------

glGetNamedBufferPointervEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetNamedBufferPointervEXT v1 v2 v3 = liftIO $ dyn_glGetNamedBufferPointervEXT ptr_glGetNamedBufferPointervEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferPointervEXT
  :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLuint -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetNamedBufferPointervEXT #-}
ptr_glGetNamedBufferPointervEXT :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetNamedBufferPointervEXT = unsafePerformIO $ getCommand "glGetNamedBufferPointervEXT"

-- glGetNamedBufferSubData -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferSubData.xhtml OpenGL 4.x>
glGetNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glGetNamedBufferSubData v1 v2 v3 v4 = liftIO $ dyn_glGetNamedBufferSubData ptr_glGetNamedBufferSubData v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferSubData
  :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
  ->         GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetNamedBufferSubData #-}
ptr_glGetNamedBufferSubData :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetNamedBufferSubData = unsafePerformIO $ getCommand "glGetNamedBufferSubData"

-- glGetNamedBufferSubDataEXT --------------------------------------------------

glGetNamedBufferSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(size)@ elements of type @a@.
  -> m ()
glGetNamedBufferSubDataEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedBufferSubDataEXT ptr_glGetNamedBufferSubDataEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedBufferSubDataEXT
  :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
  ->         GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetNamedBufferSubDataEXT #-}
ptr_glGetNamedBufferSubDataEXT :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetNamedBufferSubDataEXT = unsafePerformIO $ getCommand "glGetNamedBufferSubDataEXT"

-- glGetNamedFramebufferAttachmentParameteriv ----------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferAttachmentParameter.xhtml OpenGL 4.x>
glGetNamedFramebufferAttachmentParameteriv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedFramebufferAttachmentParameteriv v1 v2 v3 v4 = liftIO $ dyn_glGetNamedFramebufferAttachmentParameteriv ptr_glGetNamedFramebufferAttachmentParameteriv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedFramebufferAttachmentParameteriv
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedFramebufferAttachmentParameteriv #-}
ptr_glGetNamedFramebufferAttachmentParameteriv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferAttachmentParameteriv = unsafePerformIO $ getCommand "glGetNamedFramebufferAttachmentParameteriv"

-- glGetNamedFramebufferAttachmentParameterivEXT -------------------------------

glGetNamedFramebufferAttachmentParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@ of type @FramebufferAttachmentParameterName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedFramebufferAttachmentParameterivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedFramebufferAttachmentParameterivEXT ptr_glGetNamedFramebufferAttachmentParameterivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedFramebufferAttachmentParameterivEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedFramebufferAttachmentParameterivEXT #-}
ptr_glGetNamedFramebufferAttachmentParameterivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferAttachmentParameterivEXT = unsafePerformIO $ getCommand "glGetNamedFramebufferAttachmentParameterivEXT"

-- glGetNamedFramebufferParameteriv --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferParameter.xhtml OpenGL 4.x>
glGetNamedFramebufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetNamedFramebufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetNamedFramebufferParameteriv ptr_glGetNamedFramebufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedFramebufferParameteriv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedFramebufferParameteriv #-}
ptr_glGetNamedFramebufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferParameteriv = unsafePerformIO $ getCommand "glGetNamedFramebufferParameteriv"

-- glGetNamedFramebufferParameterivEXT -----------------------------------------

glGetNamedFramebufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @pname@ of type @GetFramebufferParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedFramebufferParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetNamedFramebufferParameterivEXT ptr_glGetNamedFramebufferParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedFramebufferParameterivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedFramebufferParameterivEXT #-}
ptr_glGetNamedFramebufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedFramebufferParameterivEXT"

-- glGetNamedProgramLocalParameterIivEXT ---------------------------------------

glGetNamedProgramLocalParameterIivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetNamedProgramLocalParameterIivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramLocalParameterIivEXT ptr_glGetNamedProgramLocalParameterIivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramLocalParameterIivEXT
  :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedProgramLocalParameterIivEXT #-}
ptr_glGetNamedProgramLocalParameterIivEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetNamedProgramLocalParameterIivEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterIivEXT"

-- glGetNamedProgramLocalParameterIuivEXT --------------------------------------

glGetNamedProgramLocalParameterIuivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetNamedProgramLocalParameterIuivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramLocalParameterIuivEXT ptr_glGetNamedProgramLocalParameterIuivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramLocalParameterIuivEXT
  :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetNamedProgramLocalParameterIuivEXT #-}
ptr_glGetNamedProgramLocalParameterIuivEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetNamedProgramLocalParameterIuivEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterIuivEXT"

-- glGetNamedProgramLocalParameterdvEXT ----------------------------------------

glGetNamedProgramLocalParameterdvEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetNamedProgramLocalParameterdvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramLocalParameterdvEXT ptr_glGetNamedProgramLocalParameterdvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramLocalParameterdvEXT
  :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLuint -> GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetNamedProgramLocalParameterdvEXT #-}
ptr_glGetNamedProgramLocalParameterdvEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetNamedProgramLocalParameterdvEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterdvEXT"

-- glGetNamedProgramLocalParameterfvEXT ----------------------------------------

glGetNamedProgramLocalParameterfvEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetNamedProgramLocalParameterfvEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramLocalParameterfvEXT ptr_glGetNamedProgramLocalParameterfvEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramLocalParameterfvEXT
  :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetNamedProgramLocalParameterfvEXT #-}
ptr_glGetNamedProgramLocalParameterfvEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetNamedProgramLocalParameterfvEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterfvEXT"

-- glGetNamedProgramStringEXT --------------------------------------------------

glGetNamedProgramStringEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLenum -- ^ @pname@ of type @ProgramStringProperty@.
  -> Ptr a -- ^ @string@ pointing to @COMPSIZE(program,pname)@ elements of type @a@.
  -> m ()
glGetNamedProgramStringEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramStringEXT ptr_glGetNamedProgramStringEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramStringEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetNamedProgramStringEXT #-}
ptr_glGetNamedProgramStringEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetNamedProgramStringEXT = unsafePerformIO $ getCommand "glGetNamedProgramStringEXT"

-- glGetNamedProgramivEXT ------------------------------------------------------

glGetNamedProgramivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLenum -- ^ @pname@ of type @ProgramProperty@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetNamedProgramivEXT v1 v2 v3 v4 = liftIO $ dyn_glGetNamedProgramivEXT ptr_glGetNamedProgramivEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedProgramivEXT
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedProgramivEXT #-}
ptr_glGetNamedProgramivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedProgramivEXT = unsafePerformIO $ getCommand "glGetNamedProgramivEXT"

-- glGetNamedRenderbufferParameteriv -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetRenderbufferParameter.xhtml OpenGL 4.x>
glGetNamedRenderbufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedRenderbufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetNamedRenderbufferParameteriv ptr_glGetNamedRenderbufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedRenderbufferParameteriv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedRenderbufferParameteriv #-}
ptr_glGetNamedRenderbufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedRenderbufferParameteriv = unsafePerformIO $ getCommand "glGetNamedRenderbufferParameteriv"

-- glGetNamedRenderbufferParameterivEXT ----------------------------------------

glGetNamedRenderbufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@ of type @Renderbuffer@.
  -> GLenum -- ^ @pname@ of type @RenderbufferParameterName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedRenderbufferParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetNamedRenderbufferParameterivEXT ptr_glGetNamedRenderbufferParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetNamedRenderbufferParameterivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedRenderbufferParameterivEXT #-}
ptr_glGetNamedRenderbufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedRenderbufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedRenderbufferParameterivEXT"

-- glGetNamedStringARB ---------------------------------------------------------

glGetNamedStringARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @stringlen@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLchar -- ^ @string@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetNamedStringARB v1 v2 v3 v4 v5 = liftIO $ dyn_glGetNamedStringARB ptr_glGetNamedStringARB v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetNamedStringARB
  :: FunPtr (GLint -> Ptr GLchar -> GLsizei -> Ptr GLint -> Ptr GLchar -> IO ())
  ->         GLint -> Ptr GLchar -> GLsizei -> Ptr GLint -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetNamedStringARB #-}
ptr_glGetNamedStringARB :: FunPtr (GLint -> Ptr GLchar -> GLsizei -> Ptr GLint -> Ptr GLchar -> IO ())
ptr_glGetNamedStringARB = unsafePerformIO $ getCommand "glGetNamedStringARB"

-- glGetNamedStringivARB -------------------------------------------------------

glGetNamedStringivARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedStringivARB v1 v2 v3 v4 = liftIO $ dyn_glGetNamedStringivARB ptr_glGetNamedStringivARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetNamedStringivARB
  :: FunPtr (GLint -> Ptr GLchar -> GLenum -> Ptr GLint -> IO ())
  ->         GLint -> Ptr GLchar -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetNamedStringivARB #-}
ptr_glGetNamedStringivARB :: FunPtr (GLint -> Ptr GLchar -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedStringivARB = unsafePerformIO $ getCommand "glGetNamedStringivARB"

-- glGetNextPerfQueryIdINTEL ---------------------------------------------------

glGetNextPerfQueryIdINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> Ptr GLuint -- ^ @nextQueryId@.
  -> m ()
glGetNextPerfQueryIdINTEL v1 v2 = liftIO $ dyn_glGetNextPerfQueryIdINTEL ptr_glGetNextPerfQueryIdINTEL v1 v2

foreign import CALLCONV "dynamic" dyn_glGetNextPerfQueryIdINTEL
  :: FunPtr (GLuint -> Ptr GLuint -> IO ())
  ->         GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetNextPerfQueryIdINTEL #-}
ptr_glGetNextPerfQueryIdINTEL :: FunPtr (GLuint -> Ptr GLuint -> IO ())
ptr_glGetNextPerfQueryIdINTEL = unsafePerformIO $ getCommand "glGetNextPerfQueryIdINTEL"

-- glGetObjectBufferfvATI ------------------------------------------------------

glGetObjectBufferfvATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ elements of type @GLfloat@.
  -> m ()
glGetObjectBufferfvATI v1 v2 v3 = liftIO $ dyn_glGetObjectBufferfvATI ptr_glGetObjectBufferfvATI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetObjectBufferfvATI
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetObjectBufferfvATI #-}
ptr_glGetObjectBufferfvATI :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetObjectBufferfvATI = unsafePerformIO $ getCommand "glGetObjectBufferfvATI"

-- glGetObjectBufferivATI ------------------------------------------------------

glGetObjectBufferivATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetObjectBufferivATI v1 v2 v3 = liftIO $ dyn_glGetObjectBufferivATI ptr_glGetObjectBufferivATI v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetObjectBufferivATI
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetObjectBufferivATI #-}
ptr_glGetObjectBufferivATI :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectBufferivATI = unsafePerformIO $ getCommand "glGetObjectBufferivATI"

-- glGetObjectLabel ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetObjectLabel.xhtml OpenGL 4.x>
glGetObjectLabel
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @name@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabel v1 v2 v3 v4 v5 = liftIO $ dyn_glGetObjectLabel ptr_glGetObjectLabel v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetObjectLabel
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetObjectLabel #-}
ptr_glGetObjectLabel :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabel = unsafePerformIO $ getCommand "glGetObjectLabel"

-- glGetObjectLabelEXT ---------------------------------------------------------

glGetObjectLabelEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @object@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabelEXT v1 v2 v3 v4 v5 = liftIO $ dyn_glGetObjectLabelEXT ptr_glGetObjectLabelEXT v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetObjectLabelEXT
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetObjectLabelEXT #-}
ptr_glGetObjectLabelEXT :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabelEXT = unsafePerformIO $ getCommand "glGetObjectLabelEXT"

-- glGetObjectLabelKHR ---------------------------------------------------------

glGetObjectLabelKHR
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @name@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabelKHR v1 v2 v3 v4 v5 = liftIO $ dyn_glGetObjectLabelKHR ptr_glGetObjectLabelKHR v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetObjectLabelKHR
  :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetObjectLabelKHR #-}
ptr_glGetObjectLabelKHR :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabelKHR = unsafePerformIO $ getCommand "glGetObjectLabelKHR"

-- glGetObjectParameterfvARB ---------------------------------------------------

glGetObjectParameterfvARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetObjectParameterfvARB v1 v2 v3 = liftIO $ dyn_glGetObjectParameterfvARB ptr_glGetObjectParameterfvARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetObjectParameterfvARB
  :: FunPtr (GLhandleARB -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLhandleARB -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetObjectParameterfvARB #-}
ptr_glGetObjectParameterfvARB :: FunPtr (GLhandleARB -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetObjectParameterfvARB = unsafePerformIO $ getCommand "glGetObjectParameterfvARB"

-- glGetObjectParameterivAPPLE -------------------------------------------------

glGetObjectParameterivAPPLE
  :: MonadIO m
  => GLenum -- ^ @objectType@.
  -> GLuint -- ^ @name@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetObjectParameterivAPPLE v1 v2 v3 v4 = liftIO $ dyn_glGetObjectParameterivAPPLE ptr_glGetObjectParameterivAPPLE v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetObjectParameterivAPPLE
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetObjectParameterivAPPLE #-}
ptr_glGetObjectParameterivAPPLE :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectParameterivAPPLE = unsafePerformIO $ getCommand "glGetObjectParameterivAPPLE"

-- glGetObjectParameterivARB ---------------------------------------------------

glGetObjectParameterivARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetObjectParameterivARB v1 v2 v3 = liftIO $ dyn_glGetObjectParameterivARB ptr_glGetObjectParameterivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetObjectParameterivARB
  :: FunPtr (GLhandleARB -> GLenum -> Ptr GLint -> IO ())
  ->         GLhandleARB -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetObjectParameterivARB #-}
ptr_glGetObjectParameterivARB :: FunPtr (GLhandleARB -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectParameterivARB = unsafePerformIO $ getCommand "glGetObjectParameterivARB"

-- glGetObjectPtrLabel ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetObjectPtrLabel.xhtml OpenGL 4.x>
glGetObjectPtrLabel
  :: MonadIO m
  => Ptr a -- ^ @ptr@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectPtrLabel v1 v2 v3 v4 = liftIO $ dyn_glGetObjectPtrLabel ptr_glGetObjectPtrLabel v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetObjectPtrLabel
  :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetObjectPtrLabel #-}
ptr_glGetObjectPtrLabel :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectPtrLabel = unsafePerformIO $ getCommand "glGetObjectPtrLabel"

-- glGetObjectPtrLabelKHR ------------------------------------------------------

glGetObjectPtrLabelKHR
  :: MonadIO m
  => Ptr a -- ^ @ptr@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectPtrLabelKHR v1 v2 v3 v4 = liftIO $ dyn_glGetObjectPtrLabelKHR ptr_glGetObjectPtrLabelKHR v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetObjectPtrLabelKHR
  :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetObjectPtrLabelKHR #-}
ptr_glGetObjectPtrLabelKHR :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectPtrLabelKHR = unsafePerformIO $ getCommand "glGetObjectPtrLabelKHR"

-- glGetOcclusionQueryivNV -----------------------------------------------------

glGetOcclusionQueryivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @OcclusionQueryParameterNameNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetOcclusionQueryivNV v1 v2 v3 = liftIO $ dyn_glGetOcclusionQueryivNV ptr_glGetOcclusionQueryivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetOcclusionQueryivNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetOcclusionQueryivNV #-}
ptr_glGetOcclusionQueryivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetOcclusionQueryivNV = unsafePerformIO $ getCommand "glGetOcclusionQueryivNV"

-- glGetOcclusionQueryuivNV ----------------------------------------------------

glGetOcclusionQueryuivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @OcclusionQueryParameterNameNV@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetOcclusionQueryuivNV v1 v2 v3 = liftIO $ dyn_glGetOcclusionQueryuivNV ptr_glGetOcclusionQueryuivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetOcclusionQueryuivNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetOcclusionQueryuivNV #-}
ptr_glGetOcclusionQueryuivNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetOcclusionQueryuivNV = unsafePerformIO $ getCommand "glGetOcclusionQueryuivNV"

-- glGetPathColorGenfvNV -------------------------------------------------------

glGetPathColorGenfvNV
  :: MonadIO m
  => GLenum -- ^ @color@ of type @PathColor@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPathColorGenfvNV v1 v2 v3 = liftIO $ dyn_glGetPathColorGenfvNV ptr_glGetPathColorGenfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathColorGenfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathColorGenfvNV #-}
ptr_glGetPathColorGenfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathColorGenfvNV = unsafePerformIO $ getCommand "glGetPathColorGenfvNV"

-- glGetPathColorGenivNV -------------------------------------------------------

glGetPathColorGenivNV
  :: MonadIO m
  => GLenum -- ^ @color@ of type @PathColor@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPathColorGenivNV v1 v2 v3 = liftIO $ dyn_glGetPathColorGenivNV ptr_glGetPathColorGenivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathColorGenivNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPathColorGenivNV #-}
ptr_glGetPathColorGenivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathColorGenivNV = unsafePerformIO $ getCommand "glGetPathColorGenivNV"

-- glGetPathCommandsNV ---------------------------------------------------------

glGetPathCommandsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLubyte -- ^ @commands@ pointing to @COMPSIZE(path)@ elements of type @PathCommand@.
  -> m ()
glGetPathCommandsNV v1 v2 = liftIO $ dyn_glGetPathCommandsNV ptr_glGetPathCommandsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPathCommandsNV
  :: FunPtr (GLuint -> Ptr GLubyte -> IO ())
  ->         GLuint -> Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glGetPathCommandsNV #-}
ptr_glGetPathCommandsNV :: FunPtr (GLuint -> Ptr GLubyte -> IO ())
ptr_glGetPathCommandsNV = unsafePerformIO $ getCommand "glGetPathCommandsNV"

-- glGetPathCoordsNV -----------------------------------------------------------

glGetPathCoordsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLfloat -- ^ @coords@ pointing to @COMPSIZE(path)@ elements of type @GLfloat@.
  -> m ()
glGetPathCoordsNV v1 v2 = liftIO $ dyn_glGetPathCoordsNV ptr_glGetPathCoordsNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPathCoordsNV
  :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
  ->         GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathCoordsNV #-}
ptr_glGetPathCoordsNV :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
ptr_glGetPathCoordsNV = unsafePerformIO $ getCommand "glGetPathCoordsNV"

-- glGetPathDashArrayNV --------------------------------------------------------

glGetPathDashArrayNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLfloat -- ^ @dashArray@ pointing to @COMPSIZE(path)@ elements of type @GLfloat@.
  -> m ()
glGetPathDashArrayNV v1 v2 = liftIO $ dyn_glGetPathDashArrayNV ptr_glGetPathDashArrayNV v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPathDashArrayNV
  :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
  ->         GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathDashArrayNV #-}
ptr_glGetPathDashArrayNV :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
ptr_glGetPathDashArrayNV = unsafePerformIO $ getCommand "glGetPathDashArrayNV"

-- glGetPathLengthNV -----------------------------------------------------------

glGetPathLengthNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLsizei -- ^ @startSegment@.
  -> GLsizei -- ^ @numSegments@.
  -> m GLfloat
glGetPathLengthNV v1 v2 v3 = liftIO $ dyn_glGetPathLengthNV ptr_glGetPathLengthNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathLengthNV
  :: FunPtr (GLuint -> GLsizei -> GLsizei -> IO GLfloat)
  ->         GLuint -> GLsizei -> GLsizei -> IO GLfloat

{-# NOINLINE ptr_glGetPathLengthNV #-}
ptr_glGetPathLengthNV :: FunPtr (GLuint -> GLsizei -> GLsizei -> IO GLfloat)
ptr_glGetPathLengthNV = unsafePerformIO $ getCommand "glGetPathLengthNV"

-- glGetPathMetricRangeNV ------------------------------------------------------

glGetPathMetricRangeNV
  :: MonadIO m
  => GLbitfield -- ^ @metricQueryMask@ of type @PathMetricMask@.
  -> GLuint -- ^ @firstPathName@ of type @Path@.
  -> GLsizei -- ^ @numPaths@.
  -> GLsizei -- ^ @stride@.
  -> Ptr GLfloat -- ^ @metrics@ pointing to @COMPSIZE(metricQueryMask,numPaths,stride)@ elements of type @GLfloat@.
  -> m ()
glGetPathMetricRangeNV v1 v2 v3 v4 v5 = liftIO $ dyn_glGetPathMetricRangeNV ptr_glGetPathMetricRangeNV v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetPathMetricRangeNV
  :: FunPtr (GLbitfield -> GLuint -> GLsizei -> GLsizei -> Ptr GLfloat -> IO ())
  ->         GLbitfield -> GLuint -> GLsizei -> GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathMetricRangeNV #-}
ptr_glGetPathMetricRangeNV :: FunPtr (GLbitfield -> GLuint -> GLsizei -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetPathMetricRangeNV = unsafePerformIO $ getCommand "glGetPathMetricRangeNV"

-- glGetPathMetricsNV ----------------------------------------------------------

glGetPathMetricsNV
  :: MonadIO m
  => GLbitfield -- ^ @metricQueryMask@ of type @PathMetricMask@.
  -> GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLsizei -- ^ @stride@.
  -> Ptr GLfloat -- ^ @metrics@ pointing to @COMPSIZE(metricQueryMask,numPaths,stride)@ elements of type @GLfloat@.
  -> m ()
glGetPathMetricsNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetPathMetricsNV ptr_glGetPathMetricsNV v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetPathMetricsNV
  :: FunPtr (GLbitfield -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
  ->         GLbitfield -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathMetricsNV #-}
ptr_glGetPathMetricsNV :: FunPtr (GLbitfield -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetPathMetricsNV = unsafePerformIO $ getCommand "glGetPathMetricsNV"

-- glGetPathParameterfvNV ------------------------------------------------------

glGetPathParameterfvNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @pname@ of type @PathParameter@.
  -> Ptr GLfloat -- ^ @value@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetPathParameterfvNV v1 v2 v3 = liftIO $ dyn_glGetPathParameterfvNV ptr_glGetPathParameterfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathParameterfvNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathParameterfvNV #-}
ptr_glGetPathParameterfvNV :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathParameterfvNV = unsafePerformIO $ getCommand "glGetPathParameterfvNV"

-- glGetPathParameterivNV ------------------------------------------------------

glGetPathParameterivNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @pname@ of type @PathParameter@.
  -> Ptr GLint -- ^ @value@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetPathParameterivNV v1 v2 v3 = liftIO $ dyn_glGetPathParameterivNV ptr_glGetPathParameterivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathParameterivNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPathParameterivNV #-}
ptr_glGetPathParameterivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathParameterivNV = unsafePerformIO $ getCommand "glGetPathParameterivNV"

-- glGetPathSpacingNV ----------------------------------------------------------

glGetPathSpacingNV
  :: MonadIO m
  => GLenum -- ^ @pathListMode@ of type @PathListMode@.
  -> GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLfloat -- ^ @advanceScale@.
  -> GLfloat -- ^ @kerningScale@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @returnedSpacing@ pointing to @COMPSIZE(pathListMode,numPaths)@ elements of type @GLfloat@.
  -> m ()
glGetPathSpacingNV v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn_glGetPathSpacingNV ptr_glGetPathSpacingNV v1 v2 v3 v4 v5 v6 v7 v8 v9

foreign import CALLCONV "dynamic" dyn_glGetPathSpacingNV
  :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLfloat -> GLfloat -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLfloat -> GLfloat -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathSpacingNV #-}
ptr_glGetPathSpacingNV :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLfloat -> GLfloat -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathSpacingNV = unsafePerformIO $ getCommand "glGetPathSpacingNV"

-- glGetPathTexGenfvNV ---------------------------------------------------------

glGetPathTexGenfvNV
  :: MonadIO m
  => GLenum -- ^ @texCoordSet@ of type @TextureUnit@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPathTexGenfvNV v1 v2 v3 = liftIO $ dyn_glGetPathTexGenfvNV ptr_glGetPathTexGenfvNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathTexGenfvNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPathTexGenfvNV #-}
ptr_glGetPathTexGenfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathTexGenfvNV = unsafePerformIO $ getCommand "glGetPathTexGenfvNV"

-- glGetPathTexGenivNV ---------------------------------------------------------

glGetPathTexGenivNV
  :: MonadIO m
  => GLenum -- ^ @texCoordSet@ of type @TextureUnit@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPathTexGenivNV v1 v2 v3 = liftIO $ dyn_glGetPathTexGenivNV ptr_glGetPathTexGenivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPathTexGenivNV
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPathTexGenivNV #-}
ptr_glGetPathTexGenivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathTexGenivNV = unsafePerformIO $ getCommand "glGetPathTexGenivNV"

-- glGetPerfCounterInfoINTEL ---------------------------------------------------

glGetPerfCounterInfoINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> GLuint -- ^ @counterId@.
  -> GLuint -- ^ @counterNameLength@.
  -> Ptr GLchar -- ^ @counterName@.
  -> GLuint -- ^ @counterDescLength@.
  -> Ptr GLchar -- ^ @counterDesc@.
  -> Ptr GLuint -- ^ @counterOffset@.
  -> Ptr GLuint -- ^ @counterDataSize@.
  -> Ptr GLuint -- ^ @counterTypeEnum@.
  -> Ptr GLuint -- ^ @counterDataTypeEnum@.
  -> Ptr GLuint64 -- ^ @rawCounterMaxValue@.
  -> m ()
glGetPerfCounterInfoINTEL v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn_glGetPerfCounterInfoINTEL ptr_glGetPerfCounterInfoINTEL v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

foreign import CALLCONV "dynamic" dyn_glGetPerfCounterInfoINTEL
  :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint64 -> IO ())
  ->         GLuint -> GLuint -> GLuint -> Ptr GLchar -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint64 -> IO ()

{-# NOINLINE ptr_glGetPerfCounterInfoINTEL #-}
ptr_glGetPerfCounterInfoINTEL :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint64 -> IO ())
ptr_glGetPerfCounterInfoINTEL = unsafePerformIO $ getCommand "glGetPerfCounterInfoINTEL"

-- glGetPerfMonitorCounterDataAMD ----------------------------------------------

glGetPerfMonitorCounterDataAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @dataSize@.
  -> Ptr GLuint -- ^ @data@ pointing to @dataSize@ elements of type @GLuint@.
  -> Ptr GLint -- ^ @bytesWritten@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetPerfMonitorCounterDataAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glGetPerfMonitorCounterDataAMD ptr_glGetPerfMonitorCounterDataAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorCounterDataAMD
  :: FunPtr (GLuint -> GLenum -> GLsizei -> Ptr GLuint -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLsizei -> Ptr GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorCounterDataAMD #-}
ptr_glGetPerfMonitorCounterDataAMD :: FunPtr (GLuint -> GLenum -> GLsizei -> Ptr GLuint -> Ptr GLint -> IO ())
ptr_glGetPerfMonitorCounterDataAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterDataAMD"

-- glGetPerfMonitorCounterInfoAMD ----------------------------------------------

glGetPerfMonitorCounterInfoAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLuint -- ^ @counter@.
  -> GLenum -- ^ @pname@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @a@.
  -> m ()
glGetPerfMonitorCounterInfoAMD v1 v2 v3 v4 = liftIO $ dyn_glGetPerfMonitorCounterInfoAMD ptr_glGetPerfMonitorCounterInfoAMD v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorCounterInfoAMD
  :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLuint -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorCounterInfoAMD #-}
ptr_glGetPerfMonitorCounterInfoAMD :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr a -> IO ())
ptr_glGetPerfMonitorCounterInfoAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterInfoAMD"

-- glGetPerfMonitorCounterStringAMD --------------------------------------------

glGetPerfMonitorCounterStringAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLuint -- ^ @counter@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @counterString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetPerfMonitorCounterStringAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glGetPerfMonitorCounterStringAMD ptr_glGetPerfMonitorCounterStringAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorCounterStringAMD
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorCounterStringAMD #-}
ptr_glGetPerfMonitorCounterStringAMD :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetPerfMonitorCounterStringAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterStringAMD"

-- glGetPerfMonitorCountersAMD -------------------------------------------------

glGetPerfMonitorCountersAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> Ptr GLint -- ^ @numCounters@ pointing to @1@ elements of type @GLint@.
  -> Ptr GLint -- ^ @maxActiveCounters@ pointing to @1@ elements of type @GLint@.
  -> GLsizei -- ^ @counterSize@.
  -> Ptr GLuint -- ^ @counters@ pointing to @counterSize@ elements of type @GLuint@.
  -> m ()
glGetPerfMonitorCountersAMD v1 v2 v3 v4 v5 = liftIO $ dyn_glGetPerfMonitorCountersAMD ptr_glGetPerfMonitorCountersAMD v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorCountersAMD
  :: FunPtr (GLuint -> Ptr GLint -> Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
  ->         GLuint -> Ptr GLint -> Ptr GLint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorCountersAMD #-}
ptr_glGetPerfMonitorCountersAMD :: FunPtr (GLuint -> Ptr GLint -> Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetPerfMonitorCountersAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCountersAMD"

-- glGetPerfMonitorGroupStringAMD ----------------------------------------------

glGetPerfMonitorGroupStringAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @groupString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetPerfMonitorGroupStringAMD v1 v2 v3 v4 = liftIO $ dyn_glGetPerfMonitorGroupStringAMD ptr_glGetPerfMonitorGroupStringAMD v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorGroupStringAMD
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorGroupStringAMD #-}
ptr_glGetPerfMonitorGroupStringAMD :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetPerfMonitorGroupStringAMD = unsafePerformIO $ getCommand "glGetPerfMonitorGroupStringAMD"

-- glGetPerfMonitorGroupsAMD ---------------------------------------------------

glGetPerfMonitorGroupsAMD
  :: MonadIO m
  => Ptr GLint -- ^ @numGroups@ pointing to @1@ elements of type @GLint@.
  -> GLsizei -- ^ @groupsSize@.
  -> Ptr GLuint -- ^ @groups@ pointing to @groupsSize@ elements of type @GLuint@.
  -> m ()
glGetPerfMonitorGroupsAMD v1 v2 v3 = liftIO $ dyn_glGetPerfMonitorGroupsAMD ptr_glGetPerfMonitorGroupsAMD v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPerfMonitorGroupsAMD
  :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
  ->         Ptr GLint -> GLsizei -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPerfMonitorGroupsAMD #-}
ptr_glGetPerfMonitorGroupsAMD :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetPerfMonitorGroupsAMD = unsafePerformIO $ getCommand "glGetPerfMonitorGroupsAMD"

-- glGetPerfQueryDataINTEL -----------------------------------------------------

glGetPerfQueryDataINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> GLuint -- ^ @flags@.
  -> GLsizei -- ^ @dataSize@.
  -> Ptr a -- ^ @data@.
  -> Ptr GLuint -- ^ @bytesWritten@.
  -> m ()
glGetPerfQueryDataINTEL v1 v2 v3 v4 v5 = liftIO $ dyn_glGetPerfQueryDataINTEL ptr_glGetPerfQueryDataINTEL v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetPerfQueryDataINTEL
  :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr a -> Ptr GLuint -> IO ())
  ->         GLuint -> GLuint -> GLsizei -> Ptr a -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPerfQueryDataINTEL #-}
ptr_glGetPerfQueryDataINTEL :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr a -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryDataINTEL = unsafePerformIO $ getCommand "glGetPerfQueryDataINTEL"

-- glGetPerfQueryIdByNameINTEL -------------------------------------------------

glGetPerfQueryIdByNameINTEL
  :: MonadIO m
  => Ptr GLchar -- ^ @queryName@.
  -> Ptr GLuint -- ^ @queryId@.
  -> m ()
glGetPerfQueryIdByNameINTEL v1 v2 = liftIO $ dyn_glGetPerfQueryIdByNameINTEL ptr_glGetPerfQueryIdByNameINTEL v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPerfQueryIdByNameINTEL
  :: FunPtr (Ptr GLchar -> Ptr GLuint -> IO ())
  ->         Ptr GLchar -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPerfQueryIdByNameINTEL #-}
ptr_glGetPerfQueryIdByNameINTEL :: FunPtr (Ptr GLchar -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryIdByNameINTEL = unsafePerformIO $ getCommand "glGetPerfQueryIdByNameINTEL"

-- glGetPerfQueryInfoINTEL -----------------------------------------------------

glGetPerfQueryInfoINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> GLuint -- ^ @queryNameLength@.
  -> Ptr GLchar -- ^ @queryName@.
  -> Ptr GLuint -- ^ @dataSize@.
  -> Ptr GLuint -- ^ @noCounters@.
  -> Ptr GLuint -- ^ @noInstances@.
  -> Ptr GLuint -- ^ @capsMask@.
  -> m ()
glGetPerfQueryInfoINTEL v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn_glGetPerfQueryInfoINTEL ptr_glGetPerfQueryInfoINTEL v1 v2 v3 v4 v5 v6 v7

foreign import CALLCONV "dynamic" dyn_glGetPerfQueryInfoINTEL
  :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> IO ())
  ->         GLuint -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPerfQueryInfoINTEL #-}
ptr_glGetPerfQueryInfoINTEL :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryInfoINTEL = unsafePerformIO $ getCommand "glGetPerfQueryInfoINTEL"

-- glGetPixelMapfv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>
glGetPixelMapfv
  :: MonadIO m
  => GLenum -- ^ @map@ of type @PixelMap@.
  -> Ptr GLfloat -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLfloat@.
  -> m ()
glGetPixelMapfv v1 v2 = liftIO $ dyn_glGetPixelMapfv ptr_glGetPixelMapfv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPixelMapfv
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPixelMapfv #-}
ptr_glGetPixelMapfv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelMapfv = unsafePerformIO $ getCommand "glGetPixelMapfv"

-- glGetPixelMapuiv ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>
glGetPixelMapuiv
  :: MonadIO m
  => GLenum -- ^ @map@ of type @PixelMap@.
  -> Ptr GLuint -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLuint@.
  -> m ()
glGetPixelMapuiv v1 v2 = liftIO $ dyn_glGetPixelMapuiv ptr_glGetPixelMapuiv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPixelMapuiv
  :: FunPtr (GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetPixelMapuiv #-}
ptr_glGetPixelMapuiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glGetPixelMapuiv = unsafePerformIO $ getCommand "glGetPixelMapuiv"

-- glGetPixelMapusv ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>
glGetPixelMapusv
  :: MonadIO m
  => GLenum -- ^ @map@ of type @PixelMap@.
  -> Ptr GLushort -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLushort@.
  -> m ()
glGetPixelMapusv v1 v2 = liftIO $ dyn_glGetPixelMapusv ptr_glGetPixelMapusv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPixelMapusv
  :: FunPtr (GLenum -> Ptr GLushort -> IO ())
  ->         GLenum -> Ptr GLushort -> IO ()

{-# NOINLINE ptr_glGetPixelMapusv #-}
ptr_glGetPixelMapusv :: FunPtr (GLenum -> Ptr GLushort -> IO ())
ptr_glGetPixelMapusv = unsafePerformIO $ getCommand "glGetPixelMapusv"

-- glGetPixelMapxv -------------------------------------------------------------

glGetPixelMapxv
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLint -- ^ @size@.
  -> Ptr GLfixed -- ^ @values@ pointing to @size@ elements of type @GLfixed@.
  -> m ()
glGetPixelMapxv v1 v2 v3 = liftIO $ dyn_glGetPixelMapxv ptr_glGetPixelMapxv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPixelMapxv
  :: FunPtr (GLenum -> GLint -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLint -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetPixelMapxv #-}
ptr_glGetPixelMapxv :: FunPtr (GLenum -> GLint -> Ptr GLfixed -> IO ())
ptr_glGetPixelMapxv = unsafePerformIO $ getCommand "glGetPixelMapxv"

-- glGetPixelTexGenParameterfvSGIS ---------------------------------------------

glGetPixelTexGenParameterfvSGIS
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @PixelTexGenParameterNameSGIS@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glGetPixelTexGenParameterfvSGIS v1 v2 = liftIO $ dyn_glGetPixelTexGenParameterfvSGIS ptr_glGetPixelTexGenParameterfvSGIS v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPixelTexGenParameterfvSGIS
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPixelTexGenParameterfvSGIS #-}
ptr_glGetPixelTexGenParameterfvSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelTexGenParameterfvSGIS = unsafePerformIO $ getCommand "glGetPixelTexGenParameterfvSGIS"

-- glGetPixelTexGenParameterivSGIS ---------------------------------------------

glGetPixelTexGenParameterivSGIS
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @PixelTexGenParameterNameSGIS@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glGetPixelTexGenParameterivSGIS v1 v2 = liftIO $ dyn_glGetPixelTexGenParameterivSGIS ptr_glGetPixelTexGenParameterivSGIS v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPixelTexGenParameterivSGIS
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPixelTexGenParameterivSGIS #-}
ptr_glGetPixelTexGenParameterivSGIS :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetPixelTexGenParameterivSGIS = unsafePerformIO $ getCommand "glGetPixelTexGenParameterivSGIS"

-- glGetPixelTransformParameterfvEXT -------------------------------------------

glGetPixelTransformParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPixelTransformParameterfvEXT v1 v2 v3 = liftIO $ dyn_glGetPixelTransformParameterfvEXT ptr_glGetPixelTransformParameterfvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPixelTransformParameterfvEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetPixelTransformParameterfvEXT #-}
ptr_glGetPixelTransformParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelTransformParameterfvEXT = unsafePerformIO $ getCommand "glGetPixelTransformParameterfvEXT"

-- glGetPixelTransformParameterivEXT -------------------------------------------

glGetPixelTransformParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPixelTransformParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetPixelTransformParameterivEXT ptr_glGetPixelTransformParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPixelTransformParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetPixelTransformParameterivEXT #-}
ptr_glGetPixelTransformParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPixelTransformParameterivEXT = unsafePerformIO $ getCommand "glGetPixelTransformParameterivEXT"

-- glGetPointerIndexedvEXT -----------------------------------------------------

glGetPointerIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr (Ptr a) -- ^ @data@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetPointerIndexedvEXT v1 v2 v3 = liftIO $ dyn_glGetPointerIndexedvEXT ptr_glGetPointerIndexedvEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPointerIndexedvEXT
  :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLuint -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetPointerIndexedvEXT #-}
ptr_glGetPointerIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
ptr_glGetPointerIndexedvEXT = unsafePerformIO $ getCommand "glGetPointerIndexedvEXT"

-- glGetPointeri_vEXT ----------------------------------------------------------

glGetPointeri_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetPointeri_vEXT v1 v2 v3 = liftIO $ dyn_glGetPointeri_vEXT ptr_glGetPointeri_vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetPointeri_vEXT
  :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLuint -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetPointeri_vEXT #-}
ptr_glGetPointeri_vEXT :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
ptr_glGetPointeri_vEXT = unsafePerformIO $ getCommand "glGetPointeri_vEXT"

-- glGetPointerv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPointerv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetPointerv.xhtml OpenGL 4.x>
glGetPointerv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPointervPName@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetPointerv v1 v2 = liftIO $ dyn_glGetPointerv ptr_glGetPointerv v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPointerv
  :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetPointerv #-}
ptr_glGetPointerv :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointerv = unsafePerformIO $ getCommand "glGetPointerv"

-- glGetPointervEXT ------------------------------------------------------------

glGetPointervEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetPointervPName@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetPointervEXT v1 v2 = liftIO $ dyn_glGetPointervEXT ptr_glGetPointervEXT v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPointervEXT
  :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetPointervEXT #-}
ptr_glGetPointervEXT :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointervEXT = unsafePerformIO $ getCommand "glGetPointervEXT"

-- glGetPointervKHR ------------------------------------------------------------

glGetPointervKHR
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetPointervKHR v1 v2 = liftIO $ dyn_glGetPointervKHR ptr_glGetPointervKHR v1 v2

foreign import CALLCONV "dynamic" dyn_glGetPointervKHR
  :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetPointervKHR #-}
ptr_glGetPointervKHR :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointervKHR = unsafePerformIO $ getCommand "glGetPointervKHR"

-- glGetPolygonStipple ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPolygonStipple.xml OpenGL 2.x>
glGetPolygonStipple
  :: MonadIO m
  => Ptr GLubyte -- ^ @mask@ pointing to @COMPSIZE()@ elements of type @GLubyte@.
  -> m ()
glGetPolygonStipple v1 = liftIO $ dyn_glGetPolygonStipple ptr_glGetPolygonStipple v1

foreign import CALLCONV "dynamic" dyn_glGetPolygonStipple
  :: FunPtr (Ptr GLubyte -> IO ())
  ->         Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glGetPolygonStipple #-}
ptr_glGetPolygonStipple :: FunPtr (Ptr GLubyte -> IO ())
ptr_glGetPolygonStipple = unsafePerformIO $ getCommand "glGetPolygonStipple"

-- glGetProgramBinary ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramBinary.xhtml OpenGL 4.x>
glGetProgramBinary
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLenum -- ^ @binaryFormat@ pointing to @1@ elements of type @GLenum@.
  -> Ptr a -- ^ @binary@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetProgramBinary v1 v2 v3 v4 v5 = liftIO $ dyn_glGetProgramBinary ptr_glGetProgramBinary v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetProgramBinary
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetProgramBinary #-}
ptr_glGetProgramBinary :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
ptr_glGetProgramBinary = unsafePerformIO $ getCommand "glGetProgramBinary"

-- glGetProgramBinaryOES -------------------------------------------------------

glGetProgramBinaryOES
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLenum -- ^ @binaryFormat@ pointing to @1@ elements of type @GLenum@.
  -> Ptr a -- ^ @binary@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetProgramBinaryOES v1 v2 v3 v4 v5 = liftIO $ dyn_glGetProgramBinaryOES ptr_glGetProgramBinaryOES v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetProgramBinaryOES
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetProgramBinaryOES #-}
ptr_glGetProgramBinaryOES :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
ptr_glGetProgramBinaryOES = unsafePerformIO $ getCommand "glGetProgramBinaryOES"

-- glGetProgramEnvParameterIivNV -----------------------------------------------

glGetProgramEnvParameterIivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramEnvParameterIivNV v1 v2 v3 = liftIO $ dyn_glGetProgramEnvParameterIivNV ptr_glGetProgramEnvParameterIivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramEnvParameterIivNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramEnvParameterIivNV #-}
ptr_glGetProgramEnvParameterIivNV :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetProgramEnvParameterIivNV = unsafePerformIO $ getCommand "glGetProgramEnvParameterIivNV"

-- glGetProgramEnvParameterIuivNV ----------------------------------------------

glGetProgramEnvParameterIuivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetProgramEnvParameterIuivNV v1 v2 v3 = liftIO $ dyn_glGetProgramEnvParameterIuivNV ptr_glGetProgramEnvParameterIuivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramEnvParameterIuivNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetProgramEnvParameterIuivNV #-}
ptr_glGetProgramEnvParameterIuivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramEnvParameterIuivNV = unsafePerformIO $ getCommand "glGetProgramEnvParameterIuivNV"

-- glGetProgramEnvParameterdvARB -----------------------------------------------

glGetProgramEnvParameterdvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramEnvParameterdvARB v1 v2 v3 = liftIO $ dyn_glGetProgramEnvParameterdvARB ptr_glGetProgramEnvParameterdvARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramEnvParameterdvARB
  :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetProgramEnvParameterdvARB #-}
ptr_glGetProgramEnvParameterdvARB :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetProgramEnvParameterdvARB = unsafePerformIO $ getCommand "glGetProgramEnvParameterdvARB"

-- glGetProgramEnvParameterfvARB -----------------------------------------------

glGetProgramEnvParameterfvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramEnvParameterfvARB v1 v2 v3 = liftIO $ dyn_glGetProgramEnvParameterfvARB ptr_glGetProgramEnvParameterfvARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramEnvParameterfvARB
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetProgramEnvParameterfvARB #-}
ptr_glGetProgramEnvParameterfvARB :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetProgramEnvParameterfvARB = unsafePerformIO $ getCommand "glGetProgramEnvParameterfvARB"

-- glGetProgramInfoLog ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetProgramInfoLog.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetProgramInfoLog.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetProgramInfoLog.xhtml OpenGL 4.x>
glGetProgramInfoLog
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramInfoLog v1 v2 v3 v4 = liftIO $ dyn_glGetProgramInfoLog ptr_glGetProgramInfoLog v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramInfoLog
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetProgramInfoLog #-}
ptr_glGetProgramInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramInfoLog = unsafePerformIO $ getCommand "glGetProgramInfoLog"

-- glGetProgramInterfaceiv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramInterface.xhtml OpenGL 4.x>
glGetProgramInterfaceiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramInterfaceiv v1 v2 v3 v4 = liftIO $ dyn_glGetProgramInterfaceiv ptr_glGetProgramInterfaceiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramInterfaceiv
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramInterfaceiv #-}
ptr_glGetProgramInterfaceiv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramInterfaceiv = unsafePerformIO $ getCommand "glGetProgramInterfaceiv"

-- glGetProgramLocalParameterIivNV ---------------------------------------------

glGetProgramLocalParameterIivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramLocalParameterIivNV v1 v2 v3 = liftIO $ dyn_glGetProgramLocalParameterIivNV ptr_glGetProgramLocalParameterIivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramLocalParameterIivNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramLocalParameterIivNV #-}
ptr_glGetProgramLocalParameterIivNV :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetProgramLocalParameterIivNV = unsafePerformIO $ getCommand "glGetProgramLocalParameterIivNV"

-- glGetProgramLocalParameterIuivNV --------------------------------------------

glGetProgramLocalParameterIuivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetProgramLocalParameterIuivNV v1 v2 v3 = liftIO $ dyn_glGetProgramLocalParameterIuivNV ptr_glGetProgramLocalParameterIuivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramLocalParameterIuivNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetProgramLocalParameterIuivNV #-}
ptr_glGetProgramLocalParameterIuivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramLocalParameterIuivNV = unsafePerformIO $ getCommand "glGetProgramLocalParameterIuivNV"

-- glGetProgramLocalParameterdvARB ---------------------------------------------

glGetProgramLocalParameterdvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramLocalParameterdvARB v1 v2 v3 = liftIO $ dyn_glGetProgramLocalParameterdvARB ptr_glGetProgramLocalParameterdvARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramLocalParameterdvARB
  :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetProgramLocalParameterdvARB #-}
ptr_glGetProgramLocalParameterdvARB :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetProgramLocalParameterdvARB = unsafePerformIO $ getCommand "glGetProgramLocalParameterdvARB"

-- glGetProgramLocalParameterfvARB ---------------------------------------------

glGetProgramLocalParameterfvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramLocalParameterfvARB v1 v2 v3 = liftIO $ dyn_glGetProgramLocalParameterfvARB ptr_glGetProgramLocalParameterfvARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramLocalParameterfvARB
  :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetProgramLocalParameterfvARB #-}
ptr_glGetProgramLocalParameterfvARB :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetProgramLocalParameterfvARB = unsafePerformIO $ getCommand "glGetProgramLocalParameterfvARB"

-- glGetProgramNamedParameterdvNV ----------------------------------------------

glGetProgramNamedParameterdvNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLsizei -- ^ @len@.
  -> Ptr GLubyte -- ^ @name@ pointing to @1@ elements of type @GLubyte@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramNamedParameterdvNV v1 v2 v3 v4 = liftIO $ dyn_glGetProgramNamedParameterdvNV ptr_glGetProgramNamedParameterdvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramNamedParameterdvNV
  :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLdouble -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetProgramNamedParameterdvNV #-}
ptr_glGetProgramNamedParameterdvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLdouble -> IO ())
ptr_glGetProgramNamedParameterdvNV = unsafePerformIO $ getCommand "glGetProgramNamedParameterdvNV"

-- glGetProgramNamedParameterfvNV ----------------------------------------------

glGetProgramNamedParameterfvNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLsizei -- ^ @len@.
  -> Ptr GLubyte -- ^ @name@ pointing to @1@ elements of type @GLubyte@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramNamedParameterfvNV v1 v2 v3 v4 = liftIO $ dyn_glGetProgramNamedParameterfvNV ptr_glGetProgramNamedParameterfvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramNamedParameterfvNV
  :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetProgramNamedParameterfvNV #-}
ptr_glGetProgramNamedParameterfvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glGetProgramNamedParameterfvNV = unsafePerformIO $ getCommand "glGetProgramNamedParameterfvNV"

-- glGetProgramParameterdvNV ---------------------------------------------------

glGetProgramParameterdvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramParameterdvNV v1 v2 v3 v4 = liftIO $ dyn_glGetProgramParameterdvNV ptr_glGetProgramParameterdvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramParameterdvNV
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetProgramParameterdvNV #-}
ptr_glGetProgramParameterdvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetProgramParameterdvNV = unsafePerformIO $ getCommand "glGetProgramParameterdvNV"

-- glGetProgramParameterfvNV ---------------------------------------------------

glGetProgramParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramParameterfvNV v1 v2 v3 v4 = liftIO $ dyn_glGetProgramParameterfvNV ptr_glGetProgramParameterfvNV v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramParameterfvNV
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetProgramParameterfvNV #-}
ptr_glGetProgramParameterfvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetProgramParameterfvNV = unsafePerformIO $ getCommand "glGetProgramParameterfvNV"

-- glGetProgramPipelineInfoLog -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramPipelineInfoLog.xhtml OpenGL 4.x>
glGetProgramPipelineInfoLog
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramPipelineInfoLog v1 v2 v3 v4 = liftIO $ dyn_glGetProgramPipelineInfoLog ptr_glGetProgramPipelineInfoLog v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramPipelineInfoLog
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetProgramPipelineInfoLog #-}
ptr_glGetProgramPipelineInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramPipelineInfoLog = unsafePerformIO $ getCommand "glGetProgramPipelineInfoLog"

-- glGetProgramPipelineInfoLogEXT ----------------------------------------------

glGetProgramPipelineInfoLogEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramPipelineInfoLogEXT v1 v2 v3 v4 = liftIO $ dyn_glGetProgramPipelineInfoLogEXT ptr_glGetProgramPipelineInfoLogEXT v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramPipelineInfoLogEXT
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetProgramPipelineInfoLogEXT #-}
ptr_glGetProgramPipelineInfoLogEXT :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramPipelineInfoLogEXT = unsafePerformIO $ getCommand "glGetProgramPipelineInfoLogEXT"

-- glGetProgramPipelineiv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramPipeline.xhtml OpenGL 4.x>
glGetProgramPipelineiv
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramPipelineiv v1 v2 v3 = liftIO $ dyn_glGetProgramPipelineiv ptr_glGetProgramPipelineiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramPipelineiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramPipelineiv #-}
ptr_glGetProgramPipelineiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramPipelineiv = unsafePerformIO $ getCommand "glGetProgramPipelineiv"

-- glGetProgramPipelineivEXT ---------------------------------------------------

glGetProgramPipelineivEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetProgramPipelineivEXT v1 v2 v3 = liftIO $ dyn_glGetProgramPipelineivEXT ptr_glGetProgramPipelineivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramPipelineivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramPipelineivEXT #-}
ptr_glGetProgramPipelineivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramPipelineivEXT = unsafePerformIO $ getCommand "glGetProgramPipelineivEXT"

-- glGetProgramResourceIndex ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceIndex.xhtml OpenGL 4.x>
glGetProgramResourceIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLuint
glGetProgramResourceIndex v1 v2 v3 = liftIO $ dyn_glGetProgramResourceIndex ptr_glGetProgramResourceIndex v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramResourceIndex
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLenum -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetProgramResourceIndex #-}
ptr_glGetProgramResourceIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
ptr_glGetProgramResourceIndex = unsafePerformIO $ getCommand "glGetProgramResourceIndex"

-- glGetProgramResourceLocation ------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceLocation.xhtml OpenGL 4.x>
glGetProgramResourceLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetProgramResourceLocation v1 v2 v3 = liftIO $ dyn_glGetProgramResourceLocation ptr_glGetProgramResourceLocation v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramResourceLocation
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
  ->         GLuint -> GLenum -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetProgramResourceLocation #-}
ptr_glGetProgramResourceLocation :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetProgramResourceLocation = unsafePerformIO $ getCommand "glGetProgramResourceLocation"

-- glGetProgramResourceLocationIndex -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceLocationIndex.xhtml OpenGL 4.x>
glGetProgramResourceLocationIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetProgramResourceLocationIndex v1 v2 v3 = liftIO $ dyn_glGetProgramResourceLocationIndex ptr_glGetProgramResourceLocationIndex v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramResourceLocationIndex
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
  ->         GLuint -> GLenum -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetProgramResourceLocationIndex #-}
ptr_glGetProgramResourceLocationIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetProgramResourceLocationIndex = unsafePerformIO $ getCommand "glGetProgramResourceLocationIndex"

-- glGetProgramResourceName ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceName.xhtml OpenGL 4.x>
glGetProgramResourceName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramResourceName v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetProgramResourceName ptr_glGetProgramResourceName v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetProgramResourceName
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetProgramResourceName #-}
ptr_glGetProgramResourceName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramResourceName = unsafePerformIO $ getCommand "glGetProgramResourceName"

-- glGetProgramResourcefvNV ----------------------------------------------------

glGetProgramResourcefvNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @propCount@.
  -> Ptr GLenum -- ^ @props@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetProgramResourcefvNV v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glGetProgramResourcefvNV ptr_glGetProgramResourcefvNV v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glGetProgramResourcefvNV
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetProgramResourcefvNV #-}
ptr_glGetProgramResourcefvNV :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetProgramResourcefvNV = unsafePerformIO $ getCommand "glGetProgramResourcefvNV"

-- glGetProgramResourceiv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResource.xhtml OpenGL 4.x>
glGetProgramResourceiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @propCount@.
  -> Ptr GLenum -- ^ @props@ pointing to @propCount@ elements of type @GLenum@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetProgramResourceiv v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn_glGetProgramResourceiv ptr_glGetProgramResourceiv v1 v2 v3 v4 v5 v6 v7 v8

foreign import CALLCONV "dynamic" dyn_glGetProgramResourceiv
  :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramResourceiv #-}
ptr_glGetProgramResourceiv :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetProgramResourceiv = unsafePerformIO $ getCommand "glGetProgramResourceiv"

-- glGetProgramStageiv ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramStage.xhtml OpenGL 4.x>
glGetProgramStageiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @values@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetProgramStageiv v1 v2 v3 v4 = liftIO $ dyn_glGetProgramStageiv ptr_glGetProgramStageiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetProgramStageiv
  :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramStageiv #-}
ptr_glGetProgramStageiv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramStageiv = unsafePerformIO $ getCommand "glGetProgramStageiv"

-- glGetProgramStringARB -------------------------------------------------------

glGetProgramStringARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLenum -- ^ @pname@ of type @ProgramStringPropertyARB@.
  -> Ptr a -- ^ @string@ pointing to @COMPSIZE(target,pname)@ elements of type @a@.
  -> m ()
glGetProgramStringARB v1 v2 v3 = liftIO $ dyn_glGetProgramStringARB ptr_glGetProgramStringARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramStringARB
  :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetProgramStringARB #-}
ptr_glGetProgramStringARB :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetProgramStringARB = unsafePerformIO $ getCommand "glGetProgramStringARB"

-- glGetProgramStringNV --------------------------------------------------------

glGetProgramStringNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLubyte -- ^ @program@ pointing to @COMPSIZE(id,pname)@ elements of type @ProgramCharacterNV@.
  -> m ()
glGetProgramStringNV v1 v2 v3 = liftIO $ dyn_glGetProgramStringNV ptr_glGetProgramStringNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramStringNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLubyte -> IO ())
  ->         GLuint -> GLenum -> Ptr GLubyte -> IO ()

{-# NOINLINE ptr_glGetProgramStringNV #-}
ptr_glGetProgramStringNV :: FunPtr (GLuint -> GLenum -> Ptr GLubyte -> IO ())
ptr_glGetProgramStringNV = unsafePerformIO $ getCommand "glGetProgramStringNV"

-- glGetProgramSubroutineParameteruivNV ----------------------------------------

glGetProgramSubroutineParameteruivNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @param@ pointing to @COMPSIZE(target)@ elements of type @GLuint@.
  -> m ()
glGetProgramSubroutineParameteruivNV v1 v2 v3 = liftIO $ dyn_glGetProgramSubroutineParameteruivNV ptr_glGetProgramSubroutineParameteruivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramSubroutineParameteruivNV
  :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
  ->         GLenum -> GLuint -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetProgramSubroutineParameteruivNV #-}
ptr_glGetProgramSubroutineParameteruivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramSubroutineParameteruivNV = unsafePerformIO $ getCommand "glGetProgramSubroutineParameteruivNV"

-- glGetProgramiv --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetProgram.xhtml OpenGL 4.x>
glGetProgramiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramiv v1 v2 v3 = liftIO $ dyn_glGetProgramiv ptr_glGetProgramiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramiv #-}
ptr_glGetProgramiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramiv = unsafePerformIO $ getCommand "glGetProgramiv"

-- glGetProgramivARB -----------------------------------------------------------

glGetProgramivARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLenum -- ^ @pname@ of type @ProgramPropertyARB@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ elements of type @GLint@.
  -> m ()
glGetProgramivARB v1 v2 v3 = liftIO $ dyn_glGetProgramivARB ptr_glGetProgramivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramivARB
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramivARB #-}
ptr_glGetProgramivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramivARB = unsafePerformIO $ getCommand "glGetProgramivARB"

-- glGetProgramivNV ------------------------------------------------------------

glGetProgramivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramivNV v1 v2 v3 = liftIO $ dyn_glGetProgramivNV ptr_glGetProgramivNV v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetProgramivNV
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetProgramivNV #-}
ptr_glGetProgramivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramivNV = unsafePerformIO $ getCommand "glGetProgramivNV"

-- glGetQueryBufferObjecti64v --------------------------------------------------

glGetQueryBufferObjecti64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjecti64v v1 v2 v3 v4 = liftIO $ dyn_glGetQueryBufferObjecti64v ptr_glGetQueryBufferObjecti64v v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetQueryBufferObjecti64v
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLintptr -> IO ()

{-# NOINLINE ptr_glGetQueryBufferObjecti64v #-}
ptr_glGetQueryBufferObjecti64v :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjecti64v = unsafePerformIO $ getCommand "glGetQueryBufferObjecti64v"

-- glGetQueryBufferObjectiv ----------------------------------------------------

glGetQueryBufferObjectiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectiv v1 v2 v3 v4 = liftIO $ dyn_glGetQueryBufferObjectiv ptr_glGetQueryBufferObjectiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetQueryBufferObjectiv
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLintptr -> IO ()

{-# NOINLINE ptr_glGetQueryBufferObjectiv #-}
ptr_glGetQueryBufferObjectiv :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectiv = unsafePerformIO $ getCommand "glGetQueryBufferObjectiv"

-- glGetQueryBufferObjectui64v -------------------------------------------------

glGetQueryBufferObjectui64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectui64v v1 v2 v3 v4 = liftIO $ dyn_glGetQueryBufferObjectui64v ptr_glGetQueryBufferObjectui64v v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetQueryBufferObjectui64v
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLintptr -> IO ()

{-# NOINLINE ptr_glGetQueryBufferObjectui64v #-}
ptr_glGetQueryBufferObjectui64v :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectui64v = unsafePerformIO $ getCommand "glGetQueryBufferObjectui64v"

-- glGetQueryBufferObjectuiv ---------------------------------------------------

glGetQueryBufferObjectuiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectuiv v1 v2 v3 v4 = liftIO $ dyn_glGetQueryBufferObjectuiv ptr_glGetQueryBufferObjectuiv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetQueryBufferObjectuiv
  :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
  ->         GLuint -> GLuint -> GLenum -> GLintptr -> IO ()

{-# NOINLINE ptr_glGetQueryBufferObjectuiv #-}
ptr_glGetQueryBufferObjectuiv :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectuiv = unsafePerformIO $ getCommand "glGetQueryBufferObjectuiv"

-- glGetQueryIndexediv ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetQueryIndexed.xhtml OpenGL 4.x>
glGetQueryIndexediv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryIndexediv v1 v2 v3 v4 = liftIO $ dyn_glGetQueryIndexediv ptr_glGetQueryIndexediv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetQueryIndexediv
  :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryIndexediv #-}
ptr_glGetQueryIndexediv :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryIndexediv = unsafePerformIO $ getCommand "glGetQueryIndexediv"

-- glGetQueryObjecti64v --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>
glGetQueryObjecti64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetQueryObjecti64v v1 v2 v3 = liftIO $ dyn_glGetQueryObjecti64v ptr_glGetQueryObjecti64v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjecti64v
  :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetQueryObjecti64v #-}
ptr_glGetQueryObjecti64v :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetQueryObjecti64v = unsafePerformIO $ getCommand "glGetQueryObjecti64v"

-- glGetQueryObjecti64vEXT -----------------------------------------------------

glGetQueryObjecti64vEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetQueryObjecti64vEXT v1 v2 v3 = liftIO $ dyn_glGetQueryObjecti64vEXT ptr_glGetQueryObjecti64vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjecti64vEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint64 -> IO ()

{-# NOINLINE ptr_glGetQueryObjecti64vEXT #-}
ptr_glGetQueryObjecti64vEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetQueryObjecti64vEXT = unsafePerformIO $ getCommand "glGetQueryObjecti64vEXT"

-- glGetQueryObjectiv ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObject.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>
glGetQueryObjectiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryObjectiv v1 v2 v3 = liftIO $ dyn_glGetQueryObjectiv ptr_glGetQueryObjectiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectiv #-}
ptr_glGetQueryObjectiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectiv = unsafePerformIO $ getCommand "glGetQueryObjectiv"

-- glGetQueryObjectivARB -------------------------------------------------------

glGetQueryObjectivARB
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryObjectivARB v1 v2 v3 = liftIO $ dyn_glGetQueryObjectivARB ptr_glGetQueryObjectivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectivARB
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectivARB #-}
ptr_glGetQueryObjectivARB :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectivARB = unsafePerformIO $ getCommand "glGetQueryObjectivARB"

-- glGetQueryObjectivEXT -------------------------------------------------------

glGetQueryObjectivEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetQueryObjectivEXT v1 v2 v3 = liftIO $ dyn_glGetQueryObjectivEXT ptr_glGetQueryObjectivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectivEXT #-}
ptr_glGetQueryObjectivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectivEXT = unsafePerformIO $ getCommand "glGetQueryObjectivEXT"

-- glGetQueryObjectui64v -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>
glGetQueryObjectui64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64@.
  -> m ()
glGetQueryObjectui64v v1 v2 v3 = liftIO $ dyn_glGetQueryObjectui64v ptr_glGetQueryObjectui64v v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectui64v
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint64 -> IO ()

{-# NOINLINE ptr_glGetQueryObjectui64v #-}
ptr_glGetQueryObjectui64v :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
ptr_glGetQueryObjectui64v = unsafePerformIO $ getCommand "glGetQueryObjectui64v"

-- glGetQueryObjectui64vEXT ----------------------------------------------------

glGetQueryObjectui64vEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64@.
  -> m ()
glGetQueryObjectui64vEXT v1 v2 v3 = liftIO $ dyn_glGetQueryObjectui64vEXT ptr_glGetQueryObjectui64vEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectui64vEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint64 -> IO ()

{-# NOINLINE ptr_glGetQueryObjectui64vEXT #-}
ptr_glGetQueryObjectui64vEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
ptr_glGetQueryObjectui64vEXT = unsafePerformIO $ getCommand "glGetQueryObjectui64vEXT"

-- glGetQueryObjectuiv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObject.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>
glGetQueryObjectuiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetQueryObjectuiv v1 v2 v3 = liftIO $ dyn_glGetQueryObjectuiv ptr_glGetQueryObjectuiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectuiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectuiv #-}
ptr_glGetQueryObjectuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuiv = unsafePerformIO $ getCommand "glGetQueryObjectuiv"

-- glGetQueryObjectuivARB ------------------------------------------------------

glGetQueryObjectuivARB
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetQueryObjectuivARB v1 v2 v3 = liftIO $ dyn_glGetQueryObjectuivARB ptr_glGetQueryObjectuivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectuivARB
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectuivARB #-}
ptr_glGetQueryObjectuivARB :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuivARB = unsafePerformIO $ getCommand "glGetQueryObjectuivARB"

-- glGetQueryObjectuivEXT ------------------------------------------------------

glGetQueryObjectuivEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@.
  -> m ()
glGetQueryObjectuivEXT v1 v2 v3 = liftIO $ dyn_glGetQueryObjectuivEXT ptr_glGetQueryObjectuivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryObjectuivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetQueryObjectuivEXT #-}
ptr_glGetQueryObjectuivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuivEXT = unsafePerformIO $ getCommand "glGetQueryObjectuivEXT"

-- glGetQueryiv ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryiv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryiv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryiv.xhtml OpenGL 4.x>
glGetQueryiv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryiv v1 v2 v3 = liftIO $ dyn_glGetQueryiv ptr_glGetQueryiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryiv #-}
ptr_glGetQueryiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryiv = unsafePerformIO $ getCommand "glGetQueryiv"

-- glGetQueryivARB -------------------------------------------------------------

glGetQueryivARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryivARB v1 v2 v3 = liftIO $ dyn_glGetQueryivARB ptr_glGetQueryivARB v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryivARB
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryivARB #-}
ptr_glGetQueryivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryivARB = unsafePerformIO $ getCommand "glGetQueryivARB"

-- glGetQueryivEXT -------------------------------------------------------------

glGetQueryivEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetQueryivEXT v1 v2 v3 = liftIO $ dyn_glGetQueryivEXT ptr_glGetQueryivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetQueryivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetQueryivEXT #-}
ptr_glGetQueryivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryivEXT = unsafePerformIO $ getCommand "glGetQueryivEXT"

-- glGetRenderbufferParameteriv ------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetRenderbufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetRenderbufferParameter.xhtml OpenGL 4.x>
glGetRenderbufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameteriv v1 v2 v3 = liftIO $ dyn_glGetRenderbufferParameteriv ptr_glGetRenderbufferParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetRenderbufferParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetRenderbufferParameteriv #-}
ptr_glGetRenderbufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameteriv = unsafePerformIO $ getCommand "glGetRenderbufferParameteriv"

-- glGetRenderbufferParameterivEXT ---------------------------------------------

glGetRenderbufferParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameterivEXT v1 v2 v3 = liftIO $ dyn_glGetRenderbufferParameterivEXT ptr_glGetRenderbufferParameterivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetRenderbufferParameterivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetRenderbufferParameterivEXT #-}
ptr_glGetRenderbufferParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameterivEXT = unsafePerformIO $ getCommand "glGetRenderbufferParameterivEXT"

-- glGetRenderbufferParameterivOES ---------------------------------------------

glGetRenderbufferParameterivOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameterivOES v1 v2 v3 = liftIO $ dyn_glGetRenderbufferParameterivOES ptr_glGetRenderbufferParameterivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetRenderbufferParameterivOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetRenderbufferParameterivOES #-}
ptr_glGetRenderbufferParameterivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameterivOES = unsafePerformIO $ getCommand "glGetRenderbufferParameterivOES"

-- glGetSamplerParameterIiv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>
glGetSamplerParameterIiv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIiv v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIiv ptr_glGetSamplerParameterIiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIiv #-}
ptr_glGetSamplerParameterIiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIiv = unsafePerformIO $ getCommand "glGetSamplerParameterIiv"

-- glGetSamplerParameterIivEXT -------------------------------------------------

glGetSamplerParameterIivEXT
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIivEXT v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIivEXT ptr_glGetSamplerParameterIivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIivEXT #-}
ptr_glGetSamplerParameterIivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIivEXT = unsafePerformIO $ getCommand "glGetSamplerParameterIivEXT"

-- glGetSamplerParameterIivOES -------------------------------------------------

glGetSamplerParameterIivOES
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIivOES v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIivOES ptr_glGetSamplerParameterIivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIivOES
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIivOES #-}
ptr_glGetSamplerParameterIivOES :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIivOES = unsafePerformIO $ getCommand "glGetSamplerParameterIivOES"

-- glGetSamplerParameterIuiv ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>
glGetSamplerParameterIuiv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuiv v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIuiv ptr_glGetSamplerParameterIuiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIuiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIuiv #-}
ptr_glGetSamplerParameterIuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuiv = unsafePerformIO $ getCommand "glGetSamplerParameterIuiv"

-- glGetSamplerParameterIuivEXT ------------------------------------------------

glGetSamplerParameterIuivEXT
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuivEXT v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIuivEXT ptr_glGetSamplerParameterIuivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIuivEXT
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIuivEXT #-}
ptr_glGetSamplerParameterIuivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuivEXT = unsafePerformIO $ getCommand "glGetSamplerParameterIuivEXT"

-- glGetSamplerParameterIuivOES ------------------------------------------------

glGetSamplerParameterIuivOES
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuivOES v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterIuivOES ptr_glGetSamplerParameterIuivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterIuivOES
  :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterIuivOES #-}
ptr_glGetSamplerParameterIuivOES :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuivOES = unsafePerformIO $ getCommand "glGetSamplerParameterIuivOES"

-- glGetSamplerParameterfv -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>
glGetSamplerParameterfv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetSamplerParameterfv v1 v2 v3 = liftIO $ dyn_glGetSamplerParameterfv ptr_glGetSamplerParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameterfv
  :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLuint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetSamplerParameterfv #-}
ptr_glGetSamplerParameterfv :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetSamplerParameterfv = unsafePerformIO $ getCommand "glGetSamplerParameterfv"

-- glGetSamplerParameteriv -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>
glGetSamplerParameteriv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameteriv v1 v2 v3 = liftIO $ dyn_glGetSamplerParameteriv ptr_glGetSamplerParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSamplerParameteriv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSamplerParameteriv #-}
ptr_glGetSamplerParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameteriv = unsafePerformIO $ getCommand "glGetSamplerParameteriv"

-- glGetSeparableFilter --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetSeparableFilter.xml OpenGL 2.x>
glGetSeparableFilter
  :: MonadIO m
  => GLenum -- ^ @target@ of type @SeparableTarget@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @row@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> Ptr b -- ^ @column@ pointing to @COMPSIZE(target,format,type)@ elements of type @b@.
  -> Ptr c -- ^ @span@ pointing to @COMPSIZE(target,format,type)@ elements of type @c@.
  -> m ()
glGetSeparableFilter v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetSeparableFilter ptr_glGetSeparableFilter v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetSeparableFilter
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ()

{-# NOINLINE ptr_glGetSeparableFilter #-}
ptr_glGetSeparableFilter :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
ptr_glGetSeparableFilter = unsafePerformIO $ getCommand "glGetSeparableFilter"

-- glGetSeparableFilterEXT -----------------------------------------------------

glGetSeparableFilterEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @SeparableTargetEXT@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @row@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> Ptr b -- ^ @column@ pointing to @COMPSIZE(target,format,type)@ elements of type @b@.
  -> Ptr c -- ^ @span@ pointing to @COMPSIZE(target,format,type)@ elements of type @c@.
  -> m ()
glGetSeparableFilterEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetSeparableFilterEXT ptr_glGetSeparableFilterEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetSeparableFilterEXT
  :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
  ->         GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ()

{-# NOINLINE ptr_glGetSeparableFilterEXT #-}
ptr_glGetSeparableFilterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
ptr_glGetSeparableFilterEXT = unsafePerformIO $ getCommand "glGetSeparableFilterEXT"

-- glGetShaderInfoLog ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderInfoLog.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShaderInfoLog.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShaderInfoLog.xhtml OpenGL 4.x>
glGetShaderInfoLog
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetShaderInfoLog v1 v2 v3 v4 = liftIO $ dyn_glGetShaderInfoLog ptr_glGetShaderInfoLog v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetShaderInfoLog
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetShaderInfoLog #-}
ptr_glGetShaderInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetShaderInfoLog = unsafePerformIO $ getCommand "glGetShaderInfoLog"

-- glGetShaderPrecisionFormat --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetShaderPrecisionFormat.xhtml OpenGL 4.x>
glGetShaderPrecisionFormat
  :: MonadIO m
  => GLenum -- ^ @shadertype@.
  -> GLenum -- ^ @precisiontype@.
  -> Ptr GLint -- ^ @range@ pointing to @2@ elements of type @GLint@.
  -> Ptr GLint -- ^ @precision@ pointing to @2@ elements of type @GLint@.
  -> m ()
glGetShaderPrecisionFormat v1 v2 v3 v4 = liftIO $ dyn_glGetShaderPrecisionFormat ptr_glGetShaderPrecisionFormat v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetShaderPrecisionFormat
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetShaderPrecisionFormat #-}
ptr_glGetShaderPrecisionFormat :: FunPtr (GLenum -> GLenum -> Ptr GLint -> Ptr GLint -> IO ())
ptr_glGetShaderPrecisionFormat = unsafePerformIO $ getCommand "glGetShaderPrecisionFormat"

-- glGetShaderSource -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderSource.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShaderSource.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShaderSource.xhtml OpenGL 4.x>
glGetShaderSource
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @source@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetShaderSource v1 v2 v3 v4 = liftIO $ dyn_glGetShaderSource ptr_glGetShaderSource v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetShaderSource
  :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
  ->         GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ()

{-# NOINLINE ptr_glGetShaderSource #-}
ptr_glGetShaderSource :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetShaderSource = unsafePerformIO $ getCommand "glGetShaderSource"

-- glGetShaderSourceARB --------------------------------------------------------

glGetShaderSourceARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLcharARB -- ^ @source@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetShaderSourceARB v1 v2 v3 v4 = liftIO $ dyn_glGetShaderSourceARB ptr_glGetShaderSourceARB v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetShaderSourceARB
  :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
  ->         GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ()

{-# NOINLINE ptr_glGetShaderSourceARB #-}
ptr_glGetShaderSourceARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
ptr_glGetShaderSourceARB = unsafePerformIO $ getCommand "glGetShaderSourceARB"

-- glGetShaderiv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShader.xhtml OpenGL 4.x>
glGetShaderiv
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetShaderiv v1 v2 v3 = liftIO $ dyn_glGetShaderiv ptr_glGetShaderiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetShaderiv
  :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
  ->         GLuint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetShaderiv #-}
ptr_glGetShaderiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetShaderiv = unsafePerformIO $ getCommand "glGetShaderiv"

-- glGetSharpenTexFuncSGIS -----------------------------------------------------

glGetSharpenTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetSharpenTexFuncSGIS v1 v2 = liftIO $ dyn_glGetSharpenTexFuncSGIS ptr_glGetSharpenTexFuncSGIS v1 v2

foreign import CALLCONV "dynamic" dyn_glGetSharpenTexFuncSGIS
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetSharpenTexFuncSGIS #-}
ptr_glGetSharpenTexFuncSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetSharpenTexFuncSGIS = unsafePerformIO $ getCommand "glGetSharpenTexFuncSGIS"

-- glGetString -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetString.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetString.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetString.xhtml OpenGL 4.x>
glGetString
  :: MonadIO m
  => GLenum -- ^ @name@ of type @StringName@.
  -> m (Ptr GLubyte) -- ^ pointing to elements of type @String@.
glGetString v1 = liftIO $ dyn_glGetString ptr_glGetString v1

foreign import CALLCONV "dynamic" dyn_glGetString
  :: FunPtr (GLenum -> IO (Ptr GLubyte))
  ->         GLenum -> IO (Ptr GLubyte)

{-# NOINLINE ptr_glGetString #-}
ptr_glGetString :: FunPtr (GLenum -> IO (Ptr GLubyte))
ptr_glGetString = unsafePerformIO $ getCommand "glGetString"

-- glGetStringi ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetString.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetString.xhtml OpenGL 4.x>
glGetStringi
  :: MonadIO m
  => GLenum -- ^ @name@.
  -> GLuint -- ^ @index@.
  -> m (Ptr GLubyte) -- ^ pointing to elements of type @String@.
glGetStringi v1 v2 = liftIO $ dyn_glGetStringi ptr_glGetStringi v1 v2

foreign import CALLCONV "dynamic" dyn_glGetStringi
  :: FunPtr (GLenum -> GLuint -> IO (Ptr GLubyte))
  ->         GLenum -> GLuint -> IO (Ptr GLubyte)

{-# NOINLINE ptr_glGetStringi #-}
ptr_glGetStringi :: FunPtr (GLenum -> GLuint -> IO (Ptr GLubyte))
ptr_glGetStringi = unsafePerformIO $ getCommand "glGetStringi"

-- glGetSubroutineIndex --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetSubroutineIndex.xhtml OpenGL 4.x>
glGetSubroutineIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLuint
glGetSubroutineIndex v1 v2 v3 = liftIO $ dyn_glGetSubroutineIndex ptr_glGetSubroutineIndex v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSubroutineIndex
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
  ->         GLuint -> GLenum -> Ptr GLchar -> IO GLuint

{-# NOINLINE ptr_glGetSubroutineIndex #-}
ptr_glGetSubroutineIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
ptr_glGetSubroutineIndex = unsafePerformIO $ getCommand "glGetSubroutineIndex"

-- glGetSubroutineUniformLocation ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetSubroutineUniformLocation.xhtml OpenGL 4.x>
glGetSubroutineUniformLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetSubroutineUniformLocation v1 v2 v3 = liftIO $ dyn_glGetSubroutineUniformLocation ptr_glGetSubroutineUniformLocation v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetSubroutineUniformLocation
  :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
  ->         GLuint -> GLenum -> Ptr GLchar -> IO GLint

{-# NOINLINE ptr_glGetSubroutineUniformLocation #-}
ptr_glGetSubroutineUniformLocation :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetSubroutineUniformLocation = unsafePerformIO $ getCommand "glGetSubroutineUniformLocation"

-- glGetSynciv -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSync.xhtml OpenGL 4.x>
glGetSynciv
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ elements of type @GLsizei@.
  -> Ptr GLint -- ^ @values@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetSynciv v1 v2 v3 v4 v5 = liftIO $ dyn_glGetSynciv ptr_glGetSynciv v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetSynciv
  :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
  ->         GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSynciv #-}
ptr_glGetSynciv :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetSynciv = unsafePerformIO $ getCommand "glGetSynciv"

-- glGetSyncivAPPLE ------------------------------------------------------------

glGetSyncivAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLint -- ^ @values@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetSyncivAPPLE v1 v2 v3 v4 v5 = liftIO $ dyn_glGetSyncivAPPLE ptr_glGetSyncivAPPLE v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetSyncivAPPLE
  :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
  ->         GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetSyncivAPPLE #-}
ptr_glGetSyncivAPPLE :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetSyncivAPPLE = unsafePerformIO $ getCommand "glGetSyncivAPPLE"

-- glGetTexBumpParameterfvATI --------------------------------------------------

glGetTexBumpParameterfvATI
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetTexBumpParameterATI@.
  -> Ptr GLfloat -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexBumpParameterfvATI v1 v2 = liftIO $ dyn_glGetTexBumpParameterfvATI ptr_glGetTexBumpParameterfvATI v1 v2

foreign import CALLCONV "dynamic" dyn_glGetTexBumpParameterfvATI
  :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexBumpParameterfvATI #-}
ptr_glGetTexBumpParameterfvATI :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexBumpParameterfvATI = unsafePerformIO $ getCommand "glGetTexBumpParameterfvATI"

-- glGetTexBumpParameterivATI --------------------------------------------------

glGetTexBumpParameterivATI
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetTexBumpParameterATI@.
  -> Ptr GLint -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexBumpParameterivATI v1 v2 = liftIO $ dyn_glGetTexBumpParameterivATI ptr_glGetTexBumpParameterivATI v1 v2

foreign import CALLCONV "dynamic" dyn_glGetTexBumpParameterivATI
  :: FunPtr (GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexBumpParameterivATI #-}
ptr_glGetTexBumpParameterivATI :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetTexBumpParameterivATI = unsafePerformIO $ getCommand "glGetTexBumpParameterivATI"

-- glGetTexEnvfv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnv.xml OpenGL 2.x>
glGetTexEnvfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureEnvTarget@.
  -> GLenum -- ^ @pname@ of type @TextureEnvParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexEnvfv v1 v2 v3 = liftIO $ dyn_glGetTexEnvfv ptr_glGetTexEnvfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexEnvfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexEnvfv #-}
ptr_glGetTexEnvfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexEnvfv = unsafePerformIO $ getCommand "glGetTexEnvfv"

-- glGetTexEnviv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnv.xml OpenGL 2.x>
glGetTexEnviv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureEnvTarget@.
  -> GLenum -- ^ @pname@ of type @TextureEnvParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexEnviv v1 v2 v3 = liftIO $ dyn_glGetTexEnviv ptr_glGetTexEnviv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexEnviv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexEnviv #-}
ptr_glGetTexEnviv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexEnviv = unsafePerformIO $ getCommand "glGetTexEnviv"

-- glGetTexEnvxv ---------------------------------------------------------------

glGetTexEnvxv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexEnvxv v1 v2 v3 = liftIO $ dyn_glGetTexEnvxv ptr_glGetTexEnvxv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexEnvxv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexEnvxv #-}
ptr_glGetTexEnvxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexEnvxv = unsafePerformIO $ getCommand "glGetTexEnvxv"

-- glGetTexEnvxvOES ------------------------------------------------------------

glGetTexEnvxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexEnvxvOES v1 v2 v3 = liftIO $ dyn_glGetTexEnvxvOES ptr_glGetTexEnvxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexEnvxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexEnvxvOES #-}
ptr_glGetTexEnvxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexEnvxvOES = unsafePerformIO $ getCommand "glGetTexEnvxvOES"

-- glGetTexFilterFuncSGIS ------------------------------------------------------

glGetTexFilterFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @filter@ of type @TextureFilterSGIS@.
  -> Ptr GLfloat -- ^ @weights@ pointing to @COMPSIZE(target,filter)@ elements of type @GLfloat@.
  -> m ()
glGetTexFilterFuncSGIS v1 v2 v3 = liftIO $ dyn_glGetTexFilterFuncSGIS ptr_glGetTexFilterFuncSGIS v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexFilterFuncSGIS
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexFilterFuncSGIS #-}
ptr_glGetTexFilterFuncSGIS :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexFilterFuncSGIS = unsafePerformIO $ getCommand "glGetTexFilterFuncSGIS"

-- glGetTexGendv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>
glGetTexGendv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetTexGendv v1 v2 v3 = liftIO $ dyn_glGetTexGendv ptr_glGetTexGendv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGendv
  :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
  ->         GLenum -> GLenum -> Ptr GLdouble -> IO ()

{-# NOINLINE ptr_glGetTexGendv #-}
ptr_glGetTexGendv :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetTexGendv = unsafePerformIO $ getCommand "glGetTexGendv"

-- glGetTexGenfv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>
glGetTexGenfv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexGenfv v1 v2 v3 = liftIO $ dyn_glGetTexGenfv ptr_glGetTexGenfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGenfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexGenfv #-}
ptr_glGetTexGenfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexGenfv = unsafePerformIO $ getCommand "glGetTexGenfv"

-- glGetTexGenfvOES ------------------------------------------------------------

glGetTexGenfvOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexGenfvOES v1 v2 v3 = liftIO $ dyn_glGetTexGenfvOES ptr_glGetTexGenfvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGenfvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexGenfvOES #-}
ptr_glGetTexGenfvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexGenfvOES = unsafePerformIO $ getCommand "glGetTexGenfvOES"

-- glGetTexGeniv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>
glGetTexGeniv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type @TextureCoordName@.
  -> GLenum -- ^ @pname@ of type @TextureGenParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexGeniv v1 v2 v3 = liftIO $ dyn_glGetTexGeniv ptr_glGetTexGeniv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGeniv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexGeniv #-}
ptr_glGetTexGeniv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexGeniv = unsafePerformIO $ getCommand "glGetTexGeniv"

-- glGetTexGenivOES ------------------------------------------------------------

glGetTexGenivOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexGenivOES v1 v2 v3 = liftIO $ dyn_glGetTexGenivOES ptr_glGetTexGenivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGenivOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexGenivOES #-}
ptr_glGetTexGenivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexGenivOES = unsafePerformIO $ getCommand "glGetTexGenivOES"

-- glGetTexGenxvOES ------------------------------------------------------------

glGetTexGenxvOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexGenxvOES v1 v2 v3 = liftIO $ dyn_glGetTexGenxvOES ptr_glGetTexGenxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexGenxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexGenxvOES #-}
ptr_glGetTexGenxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexGenxvOES = unsafePerformIO $ getCommand "glGetTexGenxvOES"

-- glGetTexImage ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexImage.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexImage.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexImage.xhtml OpenGL 4.x>
glGetTexImage
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetTexImage v1 v2 v3 v4 v5 = liftIO $ dyn_glGetTexImage ptr_glGetTexImage v1 v2 v3 v4 v5

foreign import CALLCONV "dynamic" dyn_glGetTexImage
  :: FunPtr (GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetTexImage #-}
ptr_glGetTexImage :: FunPtr (GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetTexImage = unsafePerformIO $ getCommand "glGetTexImage"

-- glGetTexLevelParameterfv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>
glGetTexLevelParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexLevelParameterfv v1 v2 v3 v4 = liftIO $ dyn_glGetTexLevelParameterfv ptr_glGetTexLevelParameterfv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetTexLevelParameterfv
  :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexLevelParameterfv #-}
ptr_glGetTexLevelParameterfv :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexLevelParameterfv = unsafePerformIO $ getCommand "glGetTexLevelParameterfv"

-- glGetTexLevelParameteriv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>
glGetTexLevelParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexLevelParameteriv v1 v2 v3 v4 = liftIO $ dyn_glGetTexLevelParameteriv ptr_glGetTexLevelParameteriv v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetTexLevelParameteriv
  :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLint -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexLevelParameteriv #-}
ptr_glGetTexLevelParameteriv :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexLevelParameteriv = unsafePerformIO $ getCommand "glGetTexLevelParameteriv"

-- glGetTexLevelParameterxvOES -------------------------------------------------

glGetTexLevelParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexLevelParameterxvOES v1 v2 v3 v4 = liftIO $ dyn_glGetTexLevelParameterxvOES ptr_glGetTexLevelParameterxvOES v1 v2 v3 v4

foreign import CALLCONV "dynamic" dyn_glGetTexLevelParameterxvOES
  :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLint -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexLevelParameterxvOES #-}
ptr_glGetTexLevelParameterxvOES :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexLevelParameterxvOES = unsafePerformIO $ getCommand "glGetTexLevelParameterxvOES"

-- glGetTexParameterIiv --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>
glGetTexParameterIiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIiv v1 v2 v3 = liftIO $ dyn_glGetTexParameterIiv ptr_glGetTexParameterIiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIiv #-}
ptr_glGetTexParameterIiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIiv = unsafePerformIO $ getCommand "glGetTexParameterIiv"

-- glGetTexParameterIivEXT -----------------------------------------------------

glGetTexParameterIivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIivEXT v1 v2 v3 = liftIO $ dyn_glGetTexParameterIivEXT ptr_glGetTexParameterIivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIivEXT #-}
ptr_glGetTexParameterIivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIivEXT = unsafePerformIO $ getCommand "glGetTexParameterIivEXT"

-- glGetTexParameterIivOES -----------------------------------------------------

glGetTexParameterIivOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIivOES v1 v2 v3 = liftIO $ dyn_glGetTexParameterIivOES ptr_glGetTexParameterIivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIivOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIivOES #-}
ptr_glGetTexParameterIivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIivOES = unsafePerformIO $ getCommand "glGetTexParameterIivOES"

-- glGetTexParameterIuiv -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>
glGetTexParameterIuiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuiv v1 v2 v3 = liftIO $ dyn_glGetTexParameterIuiv ptr_glGetTexParameterIuiv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIuiv
  :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIuiv #-}
ptr_glGetTexParameterIuiv :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuiv = unsafePerformIO $ getCommand "glGetTexParameterIuiv"

-- glGetTexParameterIuivEXT ----------------------------------------------------

glGetTexParameterIuivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuivEXT v1 v2 v3 = liftIO $ dyn_glGetTexParameterIuivEXT ptr_glGetTexParameterIuivEXT v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIuivEXT
  :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIuivEXT #-}
ptr_glGetTexParameterIuivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuivEXT = unsafePerformIO $ getCommand "glGetTexParameterIuivEXT"

-- glGetTexParameterIuivOES ----------------------------------------------------

glGetTexParameterIuivOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuivOES v1 v2 v3 = liftIO $ dyn_glGetTexParameterIuivOES ptr_glGetTexParameterIuivOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterIuivOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLuint -> IO ()

{-# NOINLINE ptr_glGetTexParameterIuivOES #-}
ptr_glGetTexParameterIuivOES :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuivOES = unsafePerformIO $ getCommand "glGetTexParameterIuivOES"

-- glGetTexParameterPointervAPPLE ----------------------------------------------

glGetTexParameterPointervAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ elements of type @Ptr a@.
  -> m ()
glGetTexParameterPointervAPPLE v1 v2 v3 = liftIO $ dyn_glGetTexParameterPointervAPPLE ptr_glGetTexParameterPointervAPPLE v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterPointervAPPLE
  :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
  ->         GLenum -> GLenum -> Ptr (Ptr a) -> IO ()

{-# NOINLINE ptr_glGetTexParameterPointervAPPLE #-}
ptr_glGetTexParameterPointervAPPLE :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetTexParameterPointervAPPLE = unsafePerformIO $ getCommand "glGetTexParameterPointervAPPLE"

-- glGetTexParameterfv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>
glGetTexParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexParameterfv v1 v2 v3 = liftIO $ dyn_glGetTexParameterfv ptr_glGetTexParameterfv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterfv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfloat -> IO ()

{-# NOINLINE ptr_glGetTexParameterfv #-}
ptr_glGetTexParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexParameterfv = unsafePerformIO $ getCommand "glGetTexParameterfv"

-- glGetTexParameteriv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>
glGetTexParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLenum -- ^ @pname@ of type @GetTextureParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameteriv v1 v2 v3 = liftIO $ dyn_glGetTexParameteriv ptr_glGetTexParameteriv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameteriv
  :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
  ->         GLenum -> GLenum -> Ptr GLint -> IO ()

{-# NOINLINE ptr_glGetTexParameteriv #-}
ptr_glGetTexParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameteriv = unsafePerformIO $ getCommand "glGetTexParameteriv"

-- glGetTexParameterxv ---------------------------------------------------------

glGetTexParameterxv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexParameterxv v1 v2 v3 = liftIO $ dyn_glGetTexParameterxv ptr_glGetTexParameterxv v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterxv
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexParameterxv #-}
ptr_glGetTexParameterxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexParameterxv = unsafePerformIO $ getCommand "glGetTexParameterxv"

-- glGetTexParameterxvOES ------------------------------------------------------

glGetTexParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexParameterxvOES v1 v2 v3 = liftIO $ dyn_glGetTexParameterxvOES ptr_glGetTexParameterxvOES v1 v2 v3

foreign import CALLCONV "dynamic" dyn_glGetTexParameterxvOES
  :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
  ->         GLenum -> GLenum -> Ptr GLfixed -> IO ()

{-# NOINLINE ptr_glGetTexParameterxvOES #-}
ptr_glGetTexParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexParameterxvOES = unsafePerformIO $ getCommand "glGetTexParameterxvOES"

-- glGetTextureHandleARB -------------------------------------------------------

glGetTextureHandleARB
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m GLuint64
glGetTextureHandleARB v1 = liftIO $ dyn_glGetTextureHandleARB ptr_glGetTextureHandleARB v1

foreign import CALLCONV "dynamic" dyn_glGetTextureHandleARB
  :: FunPtr (GLuint -> IO GLuint64)
  ->         GLuint -> IO GLuint64

{-# NOINLINE ptr_glGetTextureHandleARB #-}
ptr_glGetTextureHandleARB :: FunPtr (GLuint -> IO GLuint64)
ptr_glGetTextureHandleARB = unsafePerformIO $ getCommand "glGetTextureHandleARB"

-- glGetTextureHandleNV --------------------------------------------------------

glGetTextureHandleNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m GLuint64
glGetTextureHandleNV v1 = liftIO $ dyn_glGetTextureHandleNV ptr_glGetTextureHandleNV v1

foreign import CALLCONV "dynamic" dyn_glGetTextureHandleNV
  :: FunPtr (GLuint -> IO GLuint64)
  ->         GLuint -> IO GLuint64

{-# NOINLINE ptr_glGetTextureHandleNV #-}
ptr_glGetTextureHandleNV :: FunPtr (GLuint -> IO GLuint64)
ptr_glGetTextureHandleNV = unsafePerformIO $ getCommand "glGetTextureHandleNV"

-- glGetTextureImage -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexImage.xhtml OpenGL 4.x>
glGetTextureImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetTextureImage v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetTextureImage ptr_glGetTextureImage v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetTextureImage
  :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
  ->         GLuint -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ()

{-# NOINLINE ptr_glGetTextureImage #-}
ptr_glGetTextureImage :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetTextureImage = unsafePerformIO $ getCommand "glGetTextureImage"

-- glGetTextureImageEXT --------------------------------------------------------

glGetTextureImageEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type @TextureTarget@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type @PixelFormat@.
  -> GLenum -- ^ @type@ of type @PixelType@.
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetTextureImageEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn_glGetTextureImageEXT ptr_glGetTextureImageEXT v1 v2 v3 v4 v5 v6

foreign import CALLCONV "dynamic" dyn_glGetTextureImageEXT
  :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
  ->         GLuint -> GLenum -> GLint