/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusBikePowerPcc
extends AntPlusCommonPcc {
    private static final String TAG = AntPlusBikePowerPcc.class.getSimpleName();
    IRawPowerOnlyDataReceiver mRawPowerOnlyDataReceiver;
    IPedalPowerBalanceReceiver mPedalPowerBalanceReceiver;
    IInstantaneousCadenceReceiver mInstantaneousCadenceReceiver;
    IRawWheelTorqueDataReceiver mRawWheelTorqueDataReceiver;
    IRawCrankTorqueDataReceiver mRawCrankTorqueDataReceiver;
    ITorqueEffectivenessReceiver mTorqueEffectivenessReceiver;
    IPedalSmoothnessReceiver mPedalSmoothnessReceiver;
    IRawCtfDataReceiver mRawCtfDataReceiver;
    ICalibrationMessageReceiver mCalibrationMessageReceiver;
    ICalibrationMessageReceiver mRequestCalibrationMessageReceiver;
    IAutoZeroStatusReceiver mAutoZeroStatusReceiver;
    IAutoZeroStatusReceiver mRequestAutoZeroStatusReceiver;
    ICalculatedPowerReceiver mCalculatedPowerReceiver;
    ICalculatedTorqueReceiver mCalculatedTorqueReceiver;
    ICalculatedCrankCadenceReceiver mCalculatedCrankCadenceReceiver;
    CalculatedWheelSpeedReceiver mCalculatedWheelSpeedReceiver;
    CalculatedWheelDistanceReceiver mCalculatedWheelDistanceReceiver;
    IMeasurementOutputDataReceiver mMeasurementOutputDataReceiver;
    IMeasurementOutputDataReceiver mRequestMeasurementOutputDataReceiver;
    ICrankParametersReceiver mCrankParametersReceiver;
    ICrankParametersReceiver mRequestCrankParametersReceiver;
    Handler pccHandler = new Handler();
    Runnable unsubscribeRequestCalibrationMessageReceiver = new Runnable(){

        public void run() {
            AntPlusBikePowerPcc.this.subscribeRequestCalibrationMessageEvent(null);
        }
    };
    Runnable unsubscribeRequestAutoZeroStatusReceiver = new Runnable(){

        public void run() {
            AntPlusBikePowerPcc.this.subscribeRequestAutoZeroStatusEvent(null);
        }
    };
    Runnable unsubscibeRequestMeasurementOutputDataReceiver = new Runnable(){

        public void run() {
            AntPlusBikePowerPcc.this.subscribeRequestMeasurementOutputDataEvent(null);
        }
    };
    Runnable unsubscribeRequestCrankParametersReceiver = new Runnable(){

        public void run() {
            AntPlusBikePowerPcc.this.subscribeRequestCrankParametersEvent(null);
        }
    };

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 10800;
    }

    public static PccReleaseHandle<AntPlusBikePowerPcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikePowerPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikePowerPcc potentialRetObj = new AntPlusBikePowerPcc();
        return AntPlusBikePowerPcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBikePowerPcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikePowerPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusBikePowerPcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBikePowerPcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikePowerPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikePowerPcc potentialRetObj = new AntPlusBikePowerPcc();
        return AntPlusBikePowerPcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusBikePowerPcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusBikePowerPcc potentialRetObj = new AntPlusBikePowerPcc();
        return AntPlusBikePowerPcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusBikePowerPcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.bikepower.BikePowerService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Bike Power";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mRawPowerOnlyDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long powerOnlyUpdateEventCount = b.getLong("long_powerOnlyUpdateEventCount");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                long accumulatedPower = b.getLong("long_accumulatedPower");
                this.mRawPowerOnlyDataReceiver.onNewRawPowerOnlyData(estTimestamp, eventFlags, powerOnlyUpdateEventCount, instantaneousPower, accumulatedPower);
                break;
            }
            case 202: {
                if (this.mPedalPowerBalanceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                boolean rightPedalIndicator = b.getBoolean("bool_rightPedalIndicator");
                int pedalPowerPercentage = b.getInt("int_pedalPowerPercentage");
                this.mPedalPowerBalanceReceiver.onNewPedalPowerBalance(estTimestamp, eventFlags, rightPedalIndicator, pedalPowerPercentage);
                break;
            }
            case 203: {
                if (this.mInstantaneousCadenceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                this.mInstantaneousCadenceReceiver.onNewInstantaneousCadence(estTimestamp, eventFlags, dataSource, instantaneousCadence);
                break;
            }
            case 204: {
                if (this.mRawWheelTorqueDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long wheelTorqueUpdateEventCount = b.getLong("long_wheelTorqueUpdateEventCount");
                long accumulatedWheelTicks = b.getLong("long_accumulatedWheelTicks");
                BigDecimal accumulatedWheelPeriod = (BigDecimal)b.getSerializable("decimal_accumulatedWheelPeriod");
                BigDecimal accumulatedWheelTorque = (BigDecimal)b.getSerializable("decimal_accumulatedWheelTorque");
                this.mRawWheelTorqueDataReceiver.onNewRawWheelTorqueData(estTimestamp, eventFlags, wheelTorqueUpdateEventCount, accumulatedWheelTicks, accumulatedWheelPeriod, accumulatedWheelTorque);
                break;
            }
            case 205: {
                if (this.mRawCrankTorqueDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long crankTorqueUpdateEventCount = b.getLong("long_crankTorqueUpdateEventCount");
                long accumulatedCrankTicks = b.getLong("long_accumulatedCrankTicks");
                BigDecimal accumulatedCrankPeriod = (BigDecimal)b.getSerializable("decimal_accumulatedCrankPeriod");
                BigDecimal accumulatedCrankTorque = (BigDecimal)b.getSerializable("decimal_accumulatedCrankTorque");
                this.mRawCrankTorqueDataReceiver.onNewRawCrankTorqueData(estTimestamp, eventFlags, crankTorqueUpdateEventCount, accumulatedCrankTicks, accumulatedCrankPeriod, accumulatedCrankTorque);
                break;
            }
            case 206: {
                if (this.mTorqueEffectivenessReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long powerOnlyUpdateEventCount = b.getLong("long_powerOnlyUpdateEventCount");
                BigDecimal leftTorqueEffectiveness = (BigDecimal)b.getSerializable("decimal_leftTorqueEffectiveness");
                BigDecimal rightTorqueEffectiveness = (BigDecimal)b.getSerializable("decimal_rightTorqueEffectiveness");
                this.mTorqueEffectivenessReceiver.onNewTorqueEffectiveness(estTimestamp, eventFlags, powerOnlyUpdateEventCount, leftTorqueEffectiveness, rightTorqueEffectiveness);
                break;
            }
            case 207: {
                if (this.mPedalSmoothnessReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long powerOnlyUpdateEventCount = b.getLong("long_powerOnlyUpdateEventCount");
                boolean separatePedalSmoothnessSupport = b.getBoolean("bool_separatePedalSmoothnessSupport");
                BigDecimal leftOrCombinedPedalSmoothness = (BigDecimal)b.getSerializable("decimal_leftOrCombinedPedalSmoothness");
                BigDecimal rightPedalSmoothness = (BigDecimal)b.getSerializable("decimal_rightPedalSmoothness");
                this.mPedalSmoothnessReceiver.onNewPedalSmoothness(estTimestamp, eventFlags, powerOnlyUpdateEventCount, separatePedalSmoothnessSupport, leftOrCombinedPedalSmoothness, rightPedalSmoothness);
                break;
            }
            case 208: {
                if (this.mRawCtfDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long ctfUpdateEventCount = b.getLong("long_ctfUpdateEventCount");
                BigDecimal instantaneousSlope = (BigDecimal)b.getSerializable("decimal_instantaneousSlope");
                BigDecimal accumulatedTimeStamp = (BigDecimal)b.getSerializable("decimal_accumulatedTimeStamp");
                long accumulatedTorqueTicksStamp = b.getLong("long_accumulatedTorqueTicksStamp");
                this.mRawCtfDataReceiver.onNewRawCtfData(estTimestamp, eventFlags, ctfUpdateEventCount, instantaneousSlope, accumulatedTimeStamp, accumulatedTorqueTicksStamp);
                break;
            }
            case 209: {
                if (this.mCalibrationMessageReceiver == null && this.mRequestCalibrationMessageReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                if (this.mCalibrationMessageReceiver != null) {
                    this.mCalibrationMessageReceiver.onNewCalibrationMessage(estTimestamp, eventFlags, (CalibrationMessage)b.getParcelable("parcelable_CalibrationMessage"));
                }
                if (this.mRequestCalibrationMessageReceiver == null) break;
                this.mRequestCalibrationMessageReceiver.onNewCalibrationMessage(estTimestamp, eventFlags, (CalibrationMessage)b.getParcelable("parcelable_CalibrationMessage"));
                this.pccHandler.removeCallbacksAndMessages((Object)this.unsubscribeRequestCalibrationMessageReceiver);
                this.pccHandler.postDelayed(this.unsubscribeRequestCalibrationMessageReceiver, 5000L);
                break;
            }
            case 210: {
                if (this.mAutoZeroStatusReceiver == null && this.mRequestAutoZeroStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                AutoZeroStatus autoZeroStatus = AutoZeroStatus.getValueFromInt(b.getInt("int_autoZeroStatus"));
                if (this.mAutoZeroStatusReceiver != null) {
                    this.mAutoZeroStatusReceiver.onNewAutoZeroStatus(estTimestamp, eventFlags, autoZeroStatus);
                }
                if (this.mRequestAutoZeroStatusReceiver == null) break;
                this.mRequestAutoZeroStatusReceiver.onNewAutoZeroStatus(estTimestamp, eventFlags, autoZeroStatus);
                this.pccHandler.removeCallbacksAndMessages((Object)this.unsubscribeRequestAutoZeroStatusReceiver);
                this.pccHandler.postDelayed(this.unsubscribeRequestAutoZeroStatusReceiver, 5000L);
                break;
            }
            case 211: {
                if (this.mCalculatedPowerReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                BigDecimal calculatedPower = (BigDecimal)b.getSerializable("decimal_calculatedPower");
                this.mCalculatedPowerReceiver.onNewCalculatedPower(estTimestamp, eventFlags, dataSource, calculatedPower);
                break;
            }
            case 212: {
                if (this.mCalculatedTorqueReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                BigDecimal calculatedTorque = (BigDecimal)b.getSerializable("decimal_calculatedTorque");
                this.mCalculatedTorqueReceiver.onNewCalculatedTorque(estTimestamp, eventFlags, dataSource, calculatedTorque);
                break;
            }
            case 213: {
                if (this.mCalculatedCrankCadenceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                BigDecimal calculatedCrankCadence = (BigDecimal)b.getSerializable("decimal_calculatedCrankCadence");
                this.mCalculatedCrankCadenceReceiver.onNewCalculatedCrankCadence(estTimestamp, eventFlags, dataSource, calculatedCrankCadence);
                break;
            }
            case 214: {
                if (this.mCalculatedWheelSpeedReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                BigDecimal calculatedWheelSpeed = (BigDecimal)b.getSerializable("decimal_calculatedWheelSpeed");
                this.mCalculatedWheelSpeedReceiver.onNewRawCalculatedWheelSpeed(estTimestamp, eventFlags, dataSource, calculatedWheelSpeed);
                break;
            }
            case 215: {
                if (this.mCalculatedWheelDistanceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                DataSource dataSource = DataSource.getValueFromInt(b.getInt("int_dataSource"));
                BigDecimal calculatedWheelDistance = (BigDecimal)b.getSerializable("decimal_calculatedWheelDistance");
                this.mCalculatedWheelDistanceReceiver.onNewRawCalculatedWheelDistance(estTimestamp, eventFlags, dataSource, calculatedWheelDistance);
                break;
            }
            case 216: {
                if (this.mMeasurementOutputDataReceiver == null && this.mRequestMeasurementOutputDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int numOfDataTypes = b.getInt("int_numOfDataTypes");
                int dataType = b.getInt("int_dataType");
                BigDecimal timeStamp = (BigDecimal)b.getSerializable("decimal_timeStamp");
                BigDecimal measurementValue = (BigDecimal)b.getSerializable("decimal_measurementValue");
                if (this.mMeasurementOutputDataReceiver != null) {
                    this.mMeasurementOutputDataReceiver.onNewMeasurementOutputData(estTimestamp, eventFlags, numOfDataTypes, dataType, timeStamp, measurementValue);
                }
                if (this.mRequestMeasurementOutputDataReceiver == null) break;
                this.mRequestMeasurementOutputDataReceiver.onNewMeasurementOutputData(estTimestamp, eventFlags, numOfDataTypes, dataType, timeStamp, measurementValue);
                this.pccHandler.removeCallbacksAndMessages((Object)this.unsubscibeRequestMeasurementOutputDataReceiver);
                this.pccHandler.postDelayed(this.unsubscibeRequestMeasurementOutputDataReceiver, 5000L);
                break;
            }
            case 217: {
                if (this.mCrankParametersReceiver == null && this.mRequestCrankParametersReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(this.getClass().getClassLoader());
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                if (this.mCrankParametersReceiver != null) {
                    this.mCrankParametersReceiver.onNewCrankParameters(estTimestamp, eventFlags, (CrankParameters)b.getParcelable("parcelable_CrankParameters"));
                }
                if (this.mRequestCrankParametersReceiver == null) break;
                this.mRequestCrankParametersReceiver.onNewCrankParameters(estTimestamp, eventFlags, (CrankParameters)b.getParcelable("parcelable_CrankParameters"));
                this.pccHandler.removeCallbacksAndMessages((Object)this.unsubscribeRequestCrankParametersReceiver);
                this.pccHandler.postDelayed(this.unsubscribeRequestCrankParametersReceiver, 5000L);
                break;
            }
            case 218: {
                AntPlusCommonPcc.IRequestFinishedReceiver tempReceiver = this.mRequestFinishedReceiver;
                this.mRequestFinishedReceiver = null;
                this.mCommandLock.release();
                if (tempReceiver == null) break;
                Bundle b = eventMsg.getData();
                int requestStatus = b.getInt("int_requestStatus");
                tempReceiver.onNewRequestFinished(RequestStatus.getValueFromInt(requestStatus));
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeRawPowerOnlyDataEvent(IRawPowerOnlyDataReceiver RawPowerOnlyDataReceiver) {
        this.mRawPowerOnlyDataReceiver = RawPowerOnlyDataReceiver;
        if (RawPowerOnlyDataReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    public void subscribePedalPowerBalanceEvent(IPedalPowerBalanceReceiver PedalPowerBalanceReceiver) {
        this.mPedalPowerBalanceReceiver = PedalPowerBalanceReceiver;
        if (PedalPowerBalanceReceiver != null) {
            this.subscribeToEvent(202);
        } else {
            this.unsubscribeFromEvent(202);
        }
    }

    public void subscribeInstantaneousCadenceEvent(IInstantaneousCadenceReceiver InstantaneousCadenceReceiver) {
        this.mInstantaneousCadenceReceiver = InstantaneousCadenceReceiver;
        if (InstantaneousCadenceReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    public void subscribeRawWheelTorqueDataEvent(IRawWheelTorqueDataReceiver RawWheelTorqueDataReceiver) {
        this.mRawWheelTorqueDataReceiver = RawWheelTorqueDataReceiver;
        if (RawWheelTorqueDataReceiver != null) {
            this.subscribeToEvent(204);
        } else {
            this.unsubscribeFromEvent(204);
        }
    }

    public void subscribeRawCrankTorqueDataEvent(IRawCrankTorqueDataReceiver RawCrankTorqueDataReceiver) {
        this.mRawCrankTorqueDataReceiver = RawCrankTorqueDataReceiver;
        if (RawCrankTorqueDataReceiver != null) {
            this.subscribeToEvent(205);
        } else {
            this.unsubscribeFromEvent(205);
        }
    }

    public void subscribeTorqueEffectivenessEvent(ITorqueEffectivenessReceiver TorqueEffectivenessReceiver) {
        this.mTorqueEffectivenessReceiver = TorqueEffectivenessReceiver;
        if (TorqueEffectivenessReceiver != null) {
            this.subscribeToEvent(206);
        } else {
            this.unsubscribeFromEvent(206);
        }
    }

    public void subscribePedalSmoothnessEvent(IPedalSmoothnessReceiver PedalSmoothnessReceiver) {
        this.mPedalSmoothnessReceiver = PedalSmoothnessReceiver;
        if (PedalSmoothnessReceiver != null) {
            this.subscribeToEvent(207);
        } else {
            this.unsubscribeFromEvent(207);
        }
    }

    public void subscribeRawCtfDataEvent(IRawCtfDataReceiver RawCtfDataReceiver) {
        this.mRawCtfDataReceiver = RawCtfDataReceiver;
        if (RawCtfDataReceiver != null) {
            this.subscribeToEvent(208);
        } else {
            this.unsubscribeFromEvent(208);
        }
    }

    public void subscribeCalibrationMessageEvent(ICalibrationMessageReceiver calibrationMessageReceiver) {
        if (this.mRequestCalibrationMessageReceiver == null) {
            if (calibrationMessageReceiver != null && this.mCalibrationMessageReceiver == null) {
                this.subscribeToEvent(209);
            } else if (calibrationMessageReceiver == null && this.mCalibrationMessageReceiver != null) {
                this.unsubscribeFromEvent(209);
            }
        }
        this.mCalibrationMessageReceiver = calibrationMessageReceiver;
    }

    private void subscribeRequestCalibrationMessageEvent(ICalibrationMessageReceiver calibrationMessageReceiver) {
        if (this.mCalibrationMessageReceiver == null) {
            if (calibrationMessageReceiver != null && this.mRequestCalibrationMessageReceiver == null) {
                this.subscribeToEvent(209);
            } else if (calibrationMessageReceiver == null && this.mRequestCalibrationMessageReceiver != null) {
                this.unsubscribeFromEvent(209);
            }
        }
        this.mRequestCalibrationMessageReceiver = calibrationMessageReceiver;
    }

    public void subscribeAutoZeroStatusEvent(IAutoZeroStatusReceiver autoZeroStatusReceiver) {
        if (this.mRequestAutoZeroStatusReceiver == null) {
            if (autoZeroStatusReceiver != null && this.mAutoZeroStatusReceiver == null) {
                this.subscribeToEvent(210);
            } else if (autoZeroStatusReceiver == null && this.mAutoZeroStatusReceiver != null) {
                this.unsubscribeFromEvent(210);
            }
        }
        this.mAutoZeroStatusReceiver = autoZeroStatusReceiver;
    }

    private void subscribeRequestAutoZeroStatusEvent(IAutoZeroStatusReceiver autoZeroStatusReceiver) {
        if (this.mAutoZeroStatusReceiver == null) {
            if (autoZeroStatusReceiver != null && this.mRequestAutoZeroStatusReceiver == null) {
                this.subscribeToEvent(210);
            } else if (autoZeroStatusReceiver == null && this.mRequestAutoZeroStatusReceiver != null) {
                this.unsubscribeFromEvent(210);
            }
        }
        this.mRequestAutoZeroStatusReceiver = autoZeroStatusReceiver;
    }

    public void subscribeCalculatedPowerEvent(ICalculatedPowerReceiver CalculatedPowerReceiver) {
        this.mCalculatedPowerReceiver = CalculatedPowerReceiver;
        if (CalculatedPowerReceiver != null) {
            this.subscribeToEvent(211);
        } else {
            this.unsubscribeFromEvent(211);
        }
    }

    public void subscribeCalculatedTorqueEvent(ICalculatedTorqueReceiver CalculatedTorqueReceiver) {
        this.mCalculatedTorqueReceiver = CalculatedTorqueReceiver;
        if (CalculatedTorqueReceiver != null) {
            this.subscribeToEvent(212);
        } else {
            this.unsubscribeFromEvent(212);
        }
    }

    public void subscribeCalculatedCrankCadenceEvent(ICalculatedCrankCadenceReceiver CalculatedCrankCadenceReceiver) {
        this.mCalculatedCrankCadenceReceiver = CalculatedCrankCadenceReceiver;
        if (CalculatedCrankCadenceReceiver != null) {
            this.subscribeToEvent(213);
        } else {
            this.unsubscribeFromEvent(213);
        }
    }

    public void subscribeCalculatedWheelSpeedEvent(CalculatedWheelSpeedReceiver CalculatedWheelSpeedReceiver2) {
        this.mCalculatedWheelSpeedReceiver = CalculatedWheelSpeedReceiver2;
        if (CalculatedWheelSpeedReceiver2 != null) {
            this.subscribeToEvent(214);
        } else {
            this.unsubscribeFromEvent(214);
        }
    }

    public void subscribeCalculatedWheelDistanceEvent(CalculatedWheelDistanceReceiver CalculatedWheelDistanceReceiver2) {
        this.mCalculatedWheelDistanceReceiver = CalculatedWheelDistanceReceiver2;
        if (CalculatedWheelDistanceReceiver2 != null) {
            this.subscribeToEvent(215);
        } else {
            this.unsubscribeFromEvent(215);
        }
    }

    public void subscribeMeasurementOutputDataEvent(IMeasurementOutputDataReceiver measurementOutputDataReceiver) {
        if (this.mRequestMeasurementOutputDataReceiver == null) {
            if (measurementOutputDataReceiver != null && this.mMeasurementOutputDataReceiver == null) {
                this.subscribeToEvent(216);
            }
            if (measurementOutputDataReceiver == null && this.mMeasurementOutputDataReceiver != null) {
                this.unsubscribeFromEvent(216);
            }
        }
        this.mMeasurementOutputDataReceiver = measurementOutputDataReceiver;
    }

    private void subscribeRequestMeasurementOutputDataEvent(IMeasurementOutputDataReceiver measurementOutputDataReceiver) {
        if (this.mMeasurementOutputDataReceiver == null) {
            if (measurementOutputDataReceiver != null && this.mRequestMeasurementOutputDataReceiver == null) {
                this.subscribeToEvent(216);
            } else if (measurementOutputDataReceiver == null && this.mRequestMeasurementOutputDataReceiver != null) {
                this.unsubscribeFromEvent(216);
            }
        }
        this.mRequestMeasurementOutputDataReceiver = measurementOutputDataReceiver;
    }

    public void subscribeCrankParametersEvent(ICrankParametersReceiver crankParametersReceiver) {
        if (this.mRequestCrankParametersReceiver == null) {
            if (crankParametersReceiver != null && this.mCrankParametersReceiver == null) {
                this.subscribeToEvent(217);
            } else if (crankParametersReceiver == null && this.mCrankParametersReceiver != null) {
                this.unsubscribeFromEvent(217);
            }
        }
        this.mCrankParametersReceiver = crankParametersReceiver;
    }

    private void subscribeRequestCrankParametersEvent(ICrankParametersReceiver crankParametersReceiver) {
        if (this.mCrankParametersReceiver == null) {
            if (crankParametersReceiver != null && this.mRequestCrankParametersReceiver == null) {
                this.subscribeToEvent(217);
            } else if (crankParametersReceiver == null && this.mRequestCrankParametersReceiver != null) {
                this.unsubscribeFromEvent(217);
            }
        }
        this.mRequestCrankParametersReceiver = crankParametersReceiver;
    }

    public boolean requestManualCalibration(AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestManualCalibration(requestFinishedReceiver, this.mRequestCalibrationMessageReceiver, this.mRequestMeasurementOutputDataReceiver);
    }

    public boolean requestManualCalibration(AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICalibrationMessageReceiver calibrationMessageReceiver, IMeasurementOutputDataReceiver measurementOutputDataReceiver) {
        String cmdName = "requestManualCalibration";
        int whatCmd = 20001;
        this.subscribeRequestCalibrationMessageEvent(calibrationMessageReceiver);
        this.subscribeRequestMeasurementOutputDataEvent(measurementOutputDataReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, requestFinishedReceiver);
    }

    public boolean requestSetAutoZero(boolean autoZeroEnable, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestSetAutoZero(autoZeroEnable, requestFinishedReceiver, this.mRequestCalibrationMessageReceiver, this.mRequestAutoZeroStatusReceiver);
    }

    public boolean requestSetAutoZero(boolean autoZeroEnable, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICalibrationMessageReceiver calibrationMessageReceiver, IAutoZeroStatusReceiver autoZeroStatusReceiver) {
        String cmdName = "requestSetAutoZero";
        int whatCmd = 20002;
        Bundle params = new Bundle();
        params.putBoolean("bool_autoZeroEnable", autoZeroEnable);
        this.subscribeRequestCalibrationMessageEvent(calibrationMessageReceiver);
        this.subscribeRequestAutoZeroStatusEvent(autoZeroStatusReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver);
    }

    public boolean requestSetCtfSlope(BigDecimal slope, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestSetCtfSlope(slope, requestFinishedReceiver, this.mRequestCalibrationMessageReceiver);
    }

    public boolean requestSetCtfSlope(BigDecimal slope, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICalibrationMessageReceiver calibrationMessageReceiver) {
        String cmdName = "requestSetCtfSlope";
        int whatCmd = 20003;
        Bundle params = new Bundle();
        params.putSerializable("decimal_slope", (Serializable)slope);
        this.subscribeRequestCalibrationMessageEvent(calibrationMessageReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver);
    }

    public boolean requestCustomCalibrationParameters(byte[] manufacturerSpecificParameters, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestCustomCalibrationParameters(manufacturerSpecificParameters, requestFinishedReceiver, this.mRequestCalibrationMessageReceiver);
    }

    public boolean requestCustomCalibrationParameters(byte[] manufacturerSpecificParameters, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICalibrationMessageReceiver calibrationMessageReceiver) {
        String cmdName = "requestCustomCalibrationParameters";
        int whatCmd = 20004;
        Bundle params = new Bundle();
        params.putByteArray("arrayByte_manufacturerSpecificParameters", manufacturerSpecificParameters);
        this.subscribeRequestCalibrationMessageEvent(calibrationMessageReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver);
    }

    public boolean requestSetCustomCalibrationParameters(byte[] manufacturerSpecificParameters, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestSetCustomCalibrationParameters(manufacturerSpecificParameters, requestFinishedReceiver, this.mRequestCalibrationMessageReceiver);
    }

    public boolean requestSetCustomCalibrationParameters(byte[] manufacturerSpecificParameters, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICalibrationMessageReceiver calibrationMessageReceiver) {
        String cmdName = "requestSetCustomCalibrationParameters";
        int whatCmd = 20005;
        Bundle params = new Bundle();
        params.putByteArray("arrayByte_manufacturerSpecificParameters", manufacturerSpecificParameters);
        this.subscribeRequestCalibrationMessageEvent(calibrationMessageReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver);
    }

    public boolean requestCrankParameters(AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        return this.requestCrankParameters(requestFinishedReceiver, this.mRequestCrankParametersReceiver);
    }

    public boolean requestCrankParameters(AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver, ICrankParametersReceiver crankParametersReceiver) {
        String cmdName = "requestCrankParameters";
        int whatCmd = 20006;
        this.subscribeRequestCrankParametersEvent(crankParametersReceiver);
        return this.sendRequestCommand(cmdName, whatCmd, requestFinishedReceiver);
    }

    public boolean requestSetCrankParameters(CrankLengthSetting crankLengthSetting, BigDecimal fullCrankLength, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        String cmdName = "requestSetCrankParameters";
        int whatCmd = 20007;
        Bundle params = new Bundle();
        params.putInt("int_crankLengthSetting", crankLengthSetting.getIntValue());
        params.putSerializable("decimal_fullCrankLength", (Serializable)fullCrankLength);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver);
    }

    public boolean requestCommandBurst(int requestedCommandId, byte[] commandData, AntPlusCommonPcc.IRequestFinishedReceiver requestFinishedReceiver) {
        String cmdName = "requestCommandBurst";
        int whatCmd = 104;
        Bundle params = new Bundle();
        params.putInt("int_requestedCommandId", requestedCommandId);
        params.putByteArray("arrayByte_commandData", commandData);
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver, 20206);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICrankParametersReceiver {
        public void onNewCrankParameters(long var1, EnumSet<EventFlag> var3, CrankParameters var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMeasurementOutputDataReceiver {
        public void onNewMeasurementOutputData(long var1, EnumSet<EventFlag> var3, int var4, int var5, BigDecimal var6, BigDecimal var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CalculatedWheelDistanceReceiver {
        BigDecimal wheelCircumference;
        BigDecimal initialDistanceZeroVal = null;

        public CalculatedWheelDistanceReceiver(BigDecimal wheelCircumference) {
            this.wheelCircumference = wheelCircumference;
        }

        public abstract void onNewCalculatedWheelDistance(long var1, EnumSet<EventFlag> var3, DataSource var4, BigDecimal var5);

        private void onNewRawCalculatedWheelDistance(long estTimestamp, EnumSet<EventFlag> eventFlags, DataSource dataSource, BigDecimal rawCalculatedWheelDistance) {
            if (this.initialDistanceZeroVal == null) {
                this.initialDistanceZeroVal = rawCalculatedWheelDistance.multiply(this.wheelCircumference);
            }
            this.onNewCalculatedWheelDistance(estTimestamp, eventFlags, dataSource, rawCalculatedWheelDistance.multiply(this.wheelCircumference).subtract(this.initialDistanceZeroVal));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CalculatedWheelSpeedReceiver {
        BigDecimal wheelCircumference;

        public CalculatedWheelSpeedReceiver(BigDecimal wheelCircumference) {
            this.wheelCircumference = wheelCircumference;
        }

        public abstract void onNewCalculatedWheelSpeed(long var1, EnumSet<EventFlag> var3, DataSource var4, BigDecimal var5);

        private void onNewRawCalculatedWheelSpeed(long estTimestamp, EnumSet<EventFlag> eventFlags, DataSource dataSource, BigDecimal rawCalculatedWheelSpeed) {
            this.onNewCalculatedWheelSpeed(estTimestamp, eventFlags, dataSource, rawCalculatedWheelSpeed.multiply(this.wheelCircumference));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalculatedCrankCadenceReceiver {
        public void onNewCalculatedCrankCadence(long var1, EnumSet<EventFlag> var3, DataSource var4, BigDecimal var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalculatedTorqueReceiver {
        public void onNewCalculatedTorque(long var1, EnumSet<EventFlag> var3, DataSource var4, BigDecimal var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalculatedPowerReceiver {
        public void onNewCalculatedPower(long var1, EnumSet<EventFlag> var3, DataSource var4, BigDecimal var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IAutoZeroStatusReceiver {
        public void onNewAutoZeroStatus(long var1, EnumSet<EventFlag> var3, AutoZeroStatus var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalibrationMessageReceiver {
        public void onNewCalibrationMessage(long var1, EnumSet<EventFlag> var3, CalibrationMessage var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawCtfDataReceiver {
        public void onNewRawCtfData(long var1, EnumSet<EventFlag> var3, long var4, BigDecimal var6, BigDecimal var7, long var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPedalSmoothnessReceiver {
        public void onNewPedalSmoothness(long var1, EnumSet<EventFlag> var3, long var4, boolean var6, BigDecimal var7, BigDecimal var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITorqueEffectivenessReceiver {
        public void onNewTorqueEffectiveness(long var1, EnumSet<EventFlag> var3, long var4, BigDecimal var6, BigDecimal var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawCrankTorqueDataReceiver {
        public void onNewRawCrankTorqueData(long var1, EnumSet<EventFlag> var3, long var4, long var6, BigDecimal var8, BigDecimal var9);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawWheelTorqueDataReceiver {
        public void onNewRawWheelTorqueData(long var1, EnumSet<EventFlag> var3, long var4, long var6, BigDecimal var8, BigDecimal var9);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IInstantaneousCadenceReceiver {
        public void onNewInstantaneousCadence(long var1, EnumSet<EventFlag> var3, DataSource var4, int var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPedalPowerBalanceReceiver {
        public void onNewPedalPowerBalance(long var1, EnumSet<EventFlag> var3, boolean var4, int var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawPowerOnlyDataReceiver {
        public void onNewRawPowerOnlyData(long var1, EnumSet<EventFlag> var3, long var4, int var6, long var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrankLengthSetting {
        AUTO_CRANK_LENGTH(254),
        MANUAL_CRANK_LENGTH(65280),
        INVALID(255);

        private final int intValue;

        private CrankLengthSetting(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static CrankLengthSetting getValueFromInt(int intValue) {
            switch (intValue) {
                case 254: {
                    return AUTO_CRANK_LENGTH;
                }
                case 65280: {
                    return MANUAL_CRANK_LENGTH;
                }
            }
            return INVALID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CustomCalibrationStatus {
        UNDEFINED,
        CUSTOM_CALIBRATION_NOT_REQUIRED,
        CUSTOM_CALIBRATION_REQUIRED;


        public int getIntValue() {
            return this.ordinal();
        }

        public static CustomCalibrationStatus getValueFromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return UNDEFINED;
                }
                case 1: {
                    return CUSTOM_CALIBRATION_NOT_REQUIRED;
                }
                case 2: {
                    return CUSTOM_CALIBRATION_REQUIRED;
                }
                case 3: {
                    return UNDEFINED;
                }
            }
            throw new IllegalArgumentException("Undefined Custom Calibration Status");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SensorAvailabilityStatus {
        UNDEFINED,
        LEFT_SENSOR_PRESENT,
        RIGHT_SENSOR_PRESENT,
        LEFT_AND_RIGHT_SENSOR_PRESENT;


        public int getIntValue() {
            return this.ordinal();
        }

        public static SensorAvailabilityStatus getValueFromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return UNDEFINED;
                }
                case 1: {
                    return LEFT_SENSOR_PRESENT;
                }
                case 2: {
                    return RIGHT_SENSOR_PRESENT;
                }
                case 3: {
                    return LEFT_AND_RIGHT_SENSOR_PRESENT;
                }
            }
            throw new IllegalArgumentException("Undefined Sensor Availability Status");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SensorSoftwareMismatchStatus {
        UNDEFINED,
        MISMATCH_RIGHT_SENSOR_OLDER,
        MISMATCH_LEFT_SENSOR_OLDER,
        SW_MATCHES;


        public int getIntValue() {
            return this.ordinal();
        }

        public static SensorSoftwareMismatchStatus getValueFromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return UNDEFINED;
                }
                case 1: {
                    return MISMATCH_RIGHT_SENSOR_OLDER;
                }
                case 2: {
                    return MISMATCH_LEFT_SENSOR_OLDER;
                }
                case 3: {
                    return SW_MATCHES;
                }
            }
            throw new IllegalArgumentException("Undefined Sensor Software Mismatch Status");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrankLengthStatus {
        INVALID_CRANK_LENGTH,
        DEFAULT_USED,
        SET_MANUALLY,
        SET_AUTOMATICALLY;


        public int getIntValue() {
            return this.ordinal();
        }

        public static CrankLengthStatus getValueFromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return INVALID_CRANK_LENGTH;
                }
                case 1: {
                    return DEFAULT_USED;
                }
                case 2: {
                    return SET_MANUALLY;
                }
                case 3: {
                    return SET_AUTOMATICALLY;
                }
            }
            throw new IllegalArgumentException("Undefined Crank Length Status");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MeasurementDataType {
        COUNTDOWN_PERCENTAGE(0),
        COUNTDOWN_TIME(1),
        TORQUE_WHOLE_SENSOR(8),
        TORQUE_LEFT(9),
        TORQUE_RIGHT(10),
        FORCE_WHOLE_SENSOR(16),
        FORCE_LEFT(17),
        FORCE_RIGHT(18),
        ZERO_OFFSET(24),
        TEMPERATURE(25),
        VOLTAGE(26),
        INVALID(-1),
        UNRECOGNIZED(-2);

        private int intValue;

        private MeasurementDataType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static MeasurementDataType getValueFromInt(int intValue) {
            for (MeasurementDataType dataType : MeasurementDataType.values()) {
                if (dataType.getIntValue() != intValue) continue;
                return dataType;
            }
            MeasurementDataType unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSource {
        POWER_ONLY_DATA(16),
        WHEEL_TORQUE_DATA(17),
        CRANK_TORQUE_DATA(18),
        CTF_DATA(32),
        COAST_OR_STOP_DETECTED(65536),
        INITIAL_VALUE_POWER_ONLY_DATA(65296),
        INITIAL_VALUE_WHEEL_TORQUE_DATA(65297),
        INITIAL_VALUE_CRANK_TORQUE_DATA(65298),
        INITIAL_VALUE_CTF_DATA(65312),
        INVALID(-1),
        INVALID_CTF_CAL_REQ(-2),
        UNRECOGNIZED(-3);

        private int intValue;

        private DataSource(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static DataSource getValueFromInt(int intValue) {
            for (DataSource source : DataSource.values()) {
                if (source.getIntValue() != intValue) continue;
                return source;
            }
            DataSource unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutoZeroStatus {
        OFF(0),
        ON(1),
        NOT_SUPPORTED(255),
        INVALID(-1),
        UNKNOWN(-2),
        UNRECOGNIZED(-3);

        private int intValue;

        private AutoZeroStatus(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static AutoZeroStatus getValueFromInt(int intValue) {
            for (AutoZeroStatus status : AutoZeroStatus.values()) {
                if (status.getIntValue() != intValue) continue;
                return status;
            }
            AutoZeroStatus unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CalibrationId {
        GENERAL_CALIBRATION_SUCCESS(172),
        GENERAL_CALIBRATION_FAIL(175),
        CTF_MESSAGE(16),
        CTF_ZERO_OFFSET(4097),
        CTF_SLOPE_ACK(1092610),
        CTF_SERIAL_NUMBER_ACK(1092611),
        CAPABILITIES(18),
        CUSTOM_CALIBRATION_RESPONSE(187),
        CUSTOM_CALIBRATION_UPDATE_SUCCESS(189),
        INVALID(-1),
        UNRECOGNIZED(-2);

        private int intValue;

        private CalibrationId(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static CalibrationId getValueFromInt(int intValue) {
            for (CalibrationId ident : CalibrationId.values()) {
                if (ident.getIntValue() != intValue) continue;
                return ident;
            }
            CalibrationId unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_BIKEPOWERPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_BIKEPOWERPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.bikepower.BikePowerService";
        public static final int MSG_EVENT_BIKEPOWER_whatRAWPOWERONLYDATA = 201;
        public static final String MSG_EVENT_BIKEPOWER_RAWPOWERONLYDATA_PARAM_longPOWERONLYUPDATEEVENTCOUNT = "long_powerOnlyUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_RAWPOWERONLYDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
        public static final String MSG_EVENT_BIKEPOWER_RAWPOWERONLYDATA_PARAM_longACCUMULATEDPOWER = "long_accumulatedPower";
        public static final int MSG_EVENT_BIKEPOWER_whatPEDALPOWERBALANCE = 202;
        public static final String MSG_EVENT_BIKEPOWER_PEDALPOWERBALANCE_PARAM_boolRIGHTPEDALINDICATOR = "bool_rightPedalIndicator";
        public static final String MSG_EVENT_BIKEPOWER_PEDALPOWERBALANCE_PARAM_intPEDALPOWERPERCENTAGE = "int_pedalPowerPercentage";
        public static final int MSG_EVENT_BIKEPOWER_whatINSTANTANEOUSCADENCE = 203;
        public static final String MSG_EVENT_BIKEPOWER_INSTANTANEOUSCADENCE_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_INSTANTANEOUSCADENCE_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final int MSG_EVENT_BIKEPOWER_whatRAWWHEELTORQUEDATA = 204;
        public static final String MSG_EVENT_BIKEPOWER_RAWWHEELTORQUEDATA_PARAM_longWHEELTORQUEUPDATEEVENTCOUNT = "long_wheelTorqueUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_RAWWHEELTORQUEDATA_PARAM_longACCUMULATEDWHEELTICKS = "long_accumulatedWheelTicks";
        public static final String MSG_EVENT_BIKEPOWER_RAWWHEELTORQUEDATA_PARAM_decimalACCUMULATEDWHEELPERIOD = "decimal_accumulatedWheelPeriod";
        public static final String MSG_EVENT_BIKEPOWER_RAWWHEELTORQUEDATA_PARAM_decimalACCUMULATEDWHEELTORQUE = "decimal_accumulatedWheelTorque";
        public static final int MSG_EVENT_BIKEPOWER_whatRAWCRANKTORQUEDATA = 205;
        public static final String MSG_EVENT_BIKEPOWER_RAWCRANKTORQUEDATA_PARAM_longCRANKTORQUEUPDATEEVENTCOUNT = "long_crankTorqueUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_RAWCRANKTORQUEDATA_PARAM_longACCUMULATEDCRANKTICKS = "long_accumulatedCrankTicks";
        public static final String MSG_EVENT_BIKEPOWER_RAWCRANKTORQUEDATA_PARAM_decimalACCUMULATEDCRANKPERIOD = "decimal_accumulatedCrankPeriod";
        public static final String MSG_EVENT_BIKEPOWER_RAWCRANKTORQUEDATA_PARAM_decimalACCUMULATEDCRANKTORQUE = "decimal_accumulatedCrankTorque";
        public static final int MSG_EVENT_BIKEPOWER_whatTORQUEEFFECTIVENESS = 206;
        public static final String MSG_EVENT_BIKEPOWER_TORQUEEFFECTIVENESS_PARAM_longPOWERONLYUPDATEEVENTCOUNT = "long_powerOnlyUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_TORQUEEFFECTIVENESS_PARAM_decimalLEFTTORQUEEFFECTIVENESS = "decimal_leftTorqueEffectiveness";
        public static final String MSG_EVENT_BIKEPOWER_TORQUEEFFECTIVENESS_PARAM_decimalRIGHTTORQUEEFFECTIVENESS = "decimal_rightTorqueEffectiveness";
        public static final int MSG_EVENT_BIKEPOWER_whatPEDALSMOOTHNESS = 207;
        public static final String MSG_EVENT_BIKEPOWER_PEDALSMOOTHNESS_PARAM_longPOWERONLYUPDATEEVENTCOUNT = "long_powerOnlyUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_PEDALSMOOTHNESS_PARAM_boolSEPARATEPEDALSMOOTHNESSSUPPORT = "bool_separatePedalSmoothnessSupport";
        public static final String MSG_EVENT_BIKEPOWER_PEDALSMOOTHNESS_PARAM_decimalLEFTORCOMBINEDPEDALSMOOTHNESS = "decimal_leftOrCombinedPedalSmoothness";
        public static final String MSG_EVENT_BIKEPOWER_PEDALSMOOTHNESS_PARAM_decimalRIGHTPEDALSMOOTHNESS = "decimal_rightPedalSmoothness";
        public static final int MSG_EVENT_BIKEPOWER_whatRAWCTFDATA = 208;
        public static final String MSG_EVENT_BIKEPOWER_RAWCTFDATA_PARAM_longCTFUPDATEEVENTCOUNT = "long_ctfUpdateEventCount";
        public static final String MSG_EVENT_BIKEPOWER_RAWCTFDATA_PARAM_decimalINSTANTANEOUSSLOPE = "decimal_instantaneousSlope";
        public static final String MSG_EVENT_BIKEPOWER_RAWCTFDATA_PARAM_decimalACCUMULATEDTIMESTAMP = "decimal_accumulatedTimeStamp";
        public static final String MSG_EVENT_BIKEPOWER_RAWCTFDATA_PARAM_longACCUMULATEDTORQUETICKSSTAMP = "long_accumulatedTorqueTicksStamp";
        public static final int MSG_EVENT_BIKEPOWER_whatCALIBRATIONMESSAGE = 209;
        public static final int MSG_EVENT_BIKEPOWER_whatAUTOZEROSTATUS = 210;
        public static final String MSG_EVENT_BIKEPOWER_AUTOZEROSTATUS_PARAM_intAUTOZEROSTATUS = "int_autoZeroStatus";
        public static final int MSG_EVENT_BIKEPOWER_whatCALCULATEDPOWER = 211;
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDPOWER_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDPOWER_PARAM_decimalCALCULATEDPOWER = "decimal_calculatedPower";
        public static final int MSG_EVENT_BIKEPOWER_whatCALCULATEDTORQUE = 212;
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDTORQUE_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDTORQUE_PARAM_decimalCALCULATEDTORQUE = "decimal_calculatedTorque";
        public static final int MSG_EVENT_BIKEPOWER_whatCALCULATEDCRANKCADENCE = 213;
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDCRANKCADENCE_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDCRANKCADENCE_PARAM_decimalCALCULATEDCRANKCADENCE = "decimal_calculatedCrankCadence";
        public static final int MSG_EVENT_BIKEPOWER_whatCALCULATEDWHEELSPEED = 214;
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDWHEELSPEED_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDWHEELSPEED_PARAM_decimalCALCULATEDWHEELSPEED = "decimal_calculatedWheelSpeed";
        public static final int MSG_EVENT_BIKEPOWER_whatCALCULATEDWHEELDISTANCE = 215;
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDWHEELDISTANCE_PARAM_intDATASOURCE = "int_dataSource";
        public static final String MSG_EVENT_BIKEPOWER_CALCULATEDWHEELDISTANCE_PARAM_decimalCALCULATEDWHEELDISTANCE = "decimal_calculatedWheelDistance";
        public static final int MSG_EVENT_BIKEPOWER_whatMEASUREMENTOUTPUTDATA = 216;
        public static final String MSG_EVENT_BIKEPOWER_MEASUREMENTOUTPUTDATA_PARAM_intNUMOFDATATYPES = "int_numOfDataTypes";
        public static final String MSG_EVENT_BIKEPOWER_MEASUREMENTOUTPUTDATA_PARAM_intDATATYPE = "int_dataType";
        public static final String MSG_EVENT_BIKEPOWER_MEASUREMENTOUTPUTDATA_PARAM_decimalTIMESTAMP = "decimal_timeStamp";
        public static final String MSG_EVENT_BIKEPOWER_MEASUREMENTOUTPUTDATA_PARAM_decimalMEASUREMENTVALUE = "decimal_measurementValue";
        public static final int MSG_EVENT_BIKEPOWER_whatCRANKPARAMETERS = 217;
        public static final int MSG_EVENT_BIKEPOWER_whatREQUESTFINISHED = 218;
        public static final String MSG_EVENT_BIKEPOWER_REQUESTFINISHED_PARAM_intREQUESTSTATUS = "int_requestStatus";
        public static final int MSG_CMD_BIKEPOWER_whatREQUESTMANUALCALIBRATION = 20001;
        public static final int MSG_CMD_BIKEPOWER_whatSETAUTOZERO = 20002;
        public static final String MSG_CMD_BIKEPOWER_SETAUTOZERO_PARAM_boolAUTOZEROENABLE = "bool_autoZeroEnable";
        public static final int MSG_CMD_BIKEPOWER_whatSETCTFSLOPE = 20003;
        public static final String MSG_CMD_BIKEPOWER_SETCTFSLOPE_PARAM_decimalSLOPE = "decimal_slope";
        public static final int MSG_CMD_BIKEPOWER_whatREQUESTCUSTOMCALIBRATIONPARAMETERS = 20004;
        public static final String MSG_CMD_BIKEPOWER_REQUESTCUSTOMCALIBRATIONPARAMETERS_PARAM_arrayByteMANUFACTURERSPECIFICPARAMETERS = "arrayByte_manufacturerSpecificParameters";
        public static final int MSG_CMD_BIKEPOWER_whatSETCUSTOMCALIBRATIONPARAMETERS = 20005;
        public static final String MSG_CMD_BIKEPOWER_SETCUSTOMCALIBRATIONPARAMETERS_PARAM_arrayByteMANUFACTURERSPECIFICPARAMETERS = "arrayByte_manufacturerSpecificParameters";
        public static final int MSG_CMD_BIKEPOWER_whatREQUESTCRANKPARAMETERS = 20006;
        public static final int MSG_CMD_BIKEPOWER_whatSETCRANKPARAMETERS = 20007;
        public static final String MSG_CMD_BIKEPOWER_SETCRANKPARAMETERS_PARAM_intCRANKLENGTHSETTING = "int_crankLengthSetting";
        public static final String MSG_CMD_BIKEPOWER_SETCRANKPARAMETERS_PARAM_decimalFULLCRANKLENGTH = "decimal_fullCrankLength";
    }

    public static class CrankParameters
    implements Parcelable {
        private final int ipcVersionNumber;
        public static final String KEY_DEFAULT_CRANKPARAMETERSKEY = "parcelable_CrankParameters";
        private final BigDecimal fullCrankLength;
        private final CrankLengthStatus crankLengthStatus;
        private final SensorSoftwareMismatchStatus sensorSoftwareMismatchStatus;
        private final SensorAvailabilityStatus sensorAvailabilityStatus;
        private final CustomCalibrationStatus customCalibrationStatus;
        private final boolean autoCrankLengthSupport;
        public static final Parcelable.Creator<CrankParameters> CREATOR = new Parcelable.Creator<CrankParameters>(){

            public CrankParameters createFromParcel(Parcel source) {
                return new CrankParameters(source);
            }

            public CrankParameters[] newArray(int size) {
                return new CrankParameters[size];
            }
        };

        public CrankParameters(BigDecimal fullCrankLength, CrankLengthStatus crankLengthStatus, SensorSoftwareMismatchStatus sensorSoftwareMismatchStatus, SensorAvailabilityStatus sensorAvailabilityStatus, CustomCalibrationStatus customCalibrationStatus, boolean autoCrankLengthSupport) {
            this.ipcVersionNumber = 1;
            this.fullCrankLength = fullCrankLength;
            this.crankLengthStatus = crankLengthStatus;
            this.sensorSoftwareMismatchStatus = sensorSoftwareMismatchStatus;
            this.sensorAvailabilityStatus = sensorAvailabilityStatus;
            this.customCalibrationStatus = customCalibrationStatus;
            this.autoCrankLengthSupport = autoCrankLengthSupport;
        }

        public CrankParameters(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " CrankParameters parcel with version 1 parser.");
            }
            this.fullCrankLength = new BigDecimal(in.readString());
            this.crankLengthStatus = CrankLengthStatus.getValueFromInt(in.readInt());
            this.sensorSoftwareMismatchStatus = SensorSoftwareMismatchStatus.getValueFromInt(in.readInt());
            this.sensorAvailabilityStatus = SensorAvailabilityStatus.getValueFromInt(in.readInt());
            this.customCalibrationStatus = CustomCalibrationStatus.getValueFromInt(in.readInt());
            this.autoCrankLengthSupport = in.readByte() != 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeString(this.fullCrankLength.toString());
            dest.writeInt(this.crankLengthStatus.getIntValue());
            dest.writeInt(this.sensorSoftwareMismatchStatus.getIntValue());
            dest.writeInt(this.sensorAvailabilityStatus.getIntValue());
            dest.writeInt(this.customCalibrationStatus.getIntValue());
            dest.writeByte((byte)(this.autoCrankLengthSupport ? 1 : 0));
        }

        public int describeContents() {
            return 0;
        }

        public BigDecimal getFullCrankLength() {
            return this.fullCrankLength;
        }

        public CrankLengthStatus getCrankLengthStatus() {
            return this.crankLengthStatus;
        }

        public SensorSoftwareMismatchStatus getSensorSoftwareMismatchStatus() {
            return this.sensorSoftwareMismatchStatus;
        }

        public SensorAvailabilityStatus getSensorAvailabilityStatus() {
            return this.sensorAvailabilityStatus;
        }

        public CustomCalibrationStatus getCustomCalibrationStatus() {
            return this.customCalibrationStatus;
        }

        public boolean isAutoCrankLengthSupported() {
            return this.autoCrankLengthSupport;
        }
    }

    public static class CalibrationMessage
    implements Parcelable {
        public static final String KEY_DEFAULT_CALIBRATIONMESSAGEKEY = "parcelable_CalibrationMessage";
        private final int ipcVersionNumber;
        public final CalibrationId calibrationId;
        public final Integer calibrationData;
        public final Integer ctfOffset;
        public final byte[] manufacturerSpecificData;
        public static final Parcelable.Creator<CalibrationMessage> CREATOR = new Parcelable.Creator<CalibrationMessage>(){

            public CalibrationMessage createFromParcel(Parcel source) {
                return new CalibrationMessage(source);
            }

            public CalibrationMessage[] newArray(int size) {
                return new CalibrationMessage[size];
            }
        };

        public CalibrationMessage(CalibrationId calibrationId, Integer calibrationData, Integer ctfOffset, byte[] manufacturerSpecificData) {
            this.ipcVersionNumber = 1;
            this.calibrationId = calibrationId;
            this.calibrationData = calibrationData;
            this.ctfOffset = ctfOffset;
            this.manufacturerSpecificData = manufacturerSpecificData;
        }

        public CalibrationMessage(Parcel in) {
            this.ipcVersionNumber = 1;
            int incomingVersion = in.readInt();
            if (incomingVersion != 1) {
                LogAnt.i(TAG, "Decoding version " + incomingVersion + " CalibrationMessage parcel with version 1 parser.");
            }
            this.calibrationId = CalibrationId.getValueFromInt(in.readInt());
            this.calibrationData = (Integer)in.readValue(Integer.class.getClassLoader());
            this.ctfOffset = (Integer)in.readValue(Integer.class.getClassLoader());
            this.manufacturerSpecificData = (byte[])in.readValue(byte[].class.getClassLoader());
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ipcVersionNumber);
            dest.writeInt(this.calibrationId.getIntValue());
            dest.writeValue((Object)this.calibrationData);
            dest.writeValue((Object)this.ctfOffset);
            dest.writeValue((Object)this.manufacturerSpecificData);
        }

        public int describeContents() {
            return 0;
        }
    }
}

