/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.common.FitFileCommon;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.uuid.UniqueIdGenerator;
import com.garmin.fit.Bool;
import com.garmin.fit.BufferEncoder;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.Gender;
import com.garmin.fit.HrmProfileMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.UserProfileMesg;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusFitnessEquipmentPcc
extends AntPlusCommonPcc {
    private static final String TAG = AntPlusFitnessEquipmentPcc.class.getSimpleName();
    ILapOccuredReceiver mLapOccuredReceiver;
    IFitnessEquipmentStateReceiver mFitnessEquipmentStateReceiver;
    IGeneralFitnessEquipmentDataReceiver mGeneralFitnessEquipmentDataReceiver;
    IGeneralSettingsReceiver mGeneralSettingsReceiver;
    IGeneralMetabolicDataReceiver mGeneralMetabolicDataReceiver;
    ITreadmillDataReceiver mTreadmillDataReceiver;
    IEllipticalDataReceiver mEllipticalDataReceiver;
    IBikeDataReceiver mBikeDataReceiver;
    IRowerDataReceiver mRowerDataReceiver;
    IClimberDataReceiver mClimberDataReceiver;
    INordicSkierDataReceiver mNordicSkierDataReceiver;
    final boolean mIsTrainer;
    private TreadmillMethods mTreadmillMethods = new TreadmillMethods();
    private EllipticalMethods mEllipticalMethods = new EllipticalMethods();
    private BikeMethods mBikeMethods = new BikeMethods();
    private RowerMethods mRowerMethods = new RowerMethods();
    private ClimberMethods mClimberMethods = new ClimberMethods();
    private NordicSkierMethods mNordicSkierMethods = new NordicSkierMethods();

    @Override
    protected int getRequiredServiceVersionForBind() {
        if (this.mIsTrainer) {
            return 20209;
        }
        return 10100;
    }

    public static PccReleaseHandle<AntPlusFitnessEquipmentPcc> requestNewPersonalSessionAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusFitnessEquipmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IFitnessEquipmentStateReceiver feStateReceiver, int channelDeviceNumber) {
        return AntPlusFitnessEquipmentPcc.requestNewPersonalSessionAccess(bindToContext, resultReceiver, stateReceiver, feStateReceiver, channelDeviceNumber, null, null);
    }

    public static PccReleaseHandle<AntPlusFitnessEquipmentPcc> requestNewPersonalSessionAccess(Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusFitnessEquipmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IFitnessEquipmentStateReceiver feStateReceiver, int channelDeviceNumber, Settings settings, FitFileCommon.FitFile[] selectedFiles) {
        Bundle b = new Bundle();
        b.putInt("int_RequestAccessMode", 300);
        b.putInt("int_ChannelDeviceId", channelDeviceNumber);
        Settings cachedSettings = settings;
        if (settings == null) {
            cachedSettings = new Settings("Invalid", Settings.Gender.UNKNOWN, 0, 0.0f, 0.0f);
        }
        if (channelDeviceNumber == 0) {
            try {
                Context pluginContext = bindToContext.createPackageContext("com.dsi.ant.plugins.antplus", 4);
                cachedSettings.setSerialNumber(UniqueIdGenerator.getFourByteUniqueId(pluginContext));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            cachedSettings.setSerialNumber(channelDeviceNumber);
        }
        b.putParcelable("parcelable_settings", (Parcelable)cachedSettings.toFitFile());
        if (selectedFiles != null && selectedFiles.length != 0) {
            b.putParcelableArray("arrayParcelable_fitFiles", (Parcelable[])selectedFiles);
        }
        AntPlusFitnessEquipmentPcc potentialRetObj = new AntPlusFitnessEquipmentPcc(false);
        potentialRetObj.mFitnessEquipmentStateReceiver = feStateReceiver;
        return AntPlusFitnessEquipmentPcc.requestAccess_Helper_Main(bindToContext, b, potentialRetObj, new AntPluginPcc.RequestAccessResultHandler(), resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusFitnessEquipmentPcc> requestNewOpenAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusFitnessEquipmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IFitnessEquipmentStateReceiver feStateReceiver) {
        return AntPlusFitnessEquipmentPcc.requestNewOpenAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver, feStateReceiver);
    }

    public static PccReleaseHandle<AntPlusFitnessEquipmentPcc> requestNewOpenAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusFitnessEquipmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IFitnessEquipmentStateReceiver feStateReceiver) {
        throw new IllegalAccessError("This feature requires the members-only plugin lib. See readme and http://www.thisisant.com/business/go-ant/levels-and-benefits/");
    }

    public static PccReleaseHandle<AntPlusFitnessEquipmentPcc> requestNewOpenAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusFitnessEquipmentPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver, IFitnessEquipmentStateReceiver feStateReceiver) {
        throw new IllegalAccessError("This feature requires the members-only plugin lib. See readme and http://www.thisisant.com/business/go-ant/levels-and-benefits/");
    }

    public static AsyncScanController<AntPlusFitnessEquipmentPcc> requestNewOpenAccess(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver, IFitnessEquipmentStateReceiver feStateReceiver) {
        throw new IllegalAccessError("This feature requires the members-only plugin lib. See readme and http://www.thisisant.com/business/go-ant/levels-and-benefits/");
    }

    private AntPlusFitnessEquipmentPcc(boolean isFEC) {
        this.mIsTrainer = isFEC;
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.fitnessequipment.FitnessEquipmentService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Fitness Equipment";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mLapOccuredReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int lapCount = b.getInt("int_lapCount");
                this.mLapOccuredReceiver.onNewLapOccured(estTimestamp, eventFlags, lapCount);
                break;
            }
            case 202: {
                if (this.mFitnessEquipmentStateReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                EquipmentType equipmentTypeCode = EquipmentType.getValueFromInt(b.getInt("int_equipmentTypeCode"));
                EquipmentState stateCode = EquipmentState.getValueFromInt(b.getInt("int_stateCode"));
                this.mFitnessEquipmentStateReceiver.onNewFitnessEquipmentState(estTimestamp, eventFlags, equipmentTypeCode, stateCode);
                break;
            }
            case 203: {
                if (this.mGeneralFitnessEquipmentDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal elapsedTime = (BigDecimal)b.getSerializable("decimal_elapsedTime");
                long cumulativeDistance = b.getLong("long_cumulativeDistance");
                BigDecimal instantaneousSpeed = (BigDecimal)b.getSerializable("decimal_instantaneousSpeed");
                boolean virtualSpeed = b.getBoolean("bool_virtualInstantaneousSpeed", false);
                int instantaneousHeartRate = b.getInt("int_instantaneousHeartRate");
                HeartRateDataSource heartRateDataSourceCode = HeartRateDataSource.getValueFromInt(b.getInt("int_heartRateDataSourceCode"));
                this.mGeneralFitnessEquipmentDataReceiver.onNewGeneralFitnessEquipmentData(estTimestamp, eventFlags, elapsedTime, cumulativeDistance, instantaneousSpeed, virtualSpeed, instantaneousHeartRate, heartRateDataSourceCode);
                break;
            }
            case 204: {
                if (this.mGeneralSettingsReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal cycleLength = (BigDecimal)b.getSerializable("decimal_cycleLength");
                BigDecimal inclinePercentage = (BigDecimal)b.getSerializable("decimal_inclinePercentage");
                int resistanceLevel = b.getInt("int_resistanceLevel");
                this.mGeneralSettingsReceiver.onNewGeneralSettings(estTimestamp, eventFlags, cycleLength, inclinePercentage, resistanceLevel);
                break;
            }
            case 205: {
                if (this.mGeneralMetabolicDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal instantaneousMetabolicEquivalents = (BigDecimal)b.getSerializable("decimal_instantaneousMetabolicEquivalents");
                BigDecimal instantaneousCaloricBurn = (BigDecimal)b.getSerializable("decimal_instantaneousCaloricBurn");
                long cumulativeCalories = b.getLong("long_cumulativeCalories");
                this.mGeneralMetabolicDataReceiver.onNewGeneralMetabolicData(estTimestamp, eventFlags, instantaneousMetabolicEquivalents, instantaneousCaloricBurn, cumulativeCalories);
                break;
            }
            case 206: {
                if (this.mTreadmillDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                BigDecimal cumulativeNegVertDistance = (BigDecimal)b.getSerializable("decimal_cumulativeNegVertDistance");
                BigDecimal cumulativePosVertDistance = (BigDecimal)b.getSerializable("decimal_cumulativePosVertDistance");
                this.mTreadmillDataReceiver.onNewTreadmillData(estTimestamp, eventFlags, instantaneousCadence, cumulativeNegVertDistance, cumulativePosVertDistance);
                break;
            }
            case 207: {
                if (this.mEllipticalDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal cumulativePosVertDistance = (BigDecimal)b.getSerializable("decimal_cumulativePosVertDistance");
                long cumulativeStrides = b.getLong("long_cumulativeStrides");
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                this.mEllipticalDataReceiver.onNewEllipticalData(estTimestamp, eventFlags, cumulativePosVertDistance, cumulativeStrides, instantaneousCadence, instantaneousPower);
                break;
            }
            case 208: {
                if (this.mBikeDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                this.mBikeDataReceiver.onNewBikeData(estTimestamp, eventFlags, instantaneousCadence, instantaneousPower);
                break;
            }
            case 209: {
                if (this.mRowerDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeStrokes = b.getLong("long_cumulativeStrokes");
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                this.mRowerDataReceiver.onNewRowerData(estTimestamp, eventFlags, cumulativeStrokes, instantaneousCadence, instantaneousPower);
                break;
            }
            case 210: {
                if (this.mClimberDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeStrideCycles = b.getLong("long_cumulativeStrideCycles");
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                this.mClimberDataReceiver.onNewClimberData(estTimestamp, eventFlags, cumulativeStrideCycles, instantaneousCadence, instantaneousPower);
                break;
            }
            case 211: {
                if (this.mNordicSkierDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeStrides = b.getLong("long_cumulativeStrides");
                int instantaneousCadence = b.getInt("int_instantaneousCadence");
                int instantaneousPower = b.getInt("int_instantaneousPower");
                this.mNordicSkierDataReceiver.onNewNordicSkierData(estTimestamp, eventFlags, cumulativeStrides, instantaneousCadence, instantaneousPower);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public TreadmillMethods getTreadmillMethods() {
        return this.mTreadmillMethods;
    }

    public EllipticalMethods getEllipticalMethods() {
        return this.mEllipticalMethods;
    }

    public BikeMethods getBikeMethods() {
        return this.mBikeMethods;
    }

    public RowerMethods getRowerMethods() {
        return this.mRowerMethods;
    }

    public ClimberMethods getClimberMethods() {
        return this.mClimberMethods;
    }

    public NordicSkierMethods getNordicSkierMethods() {
        return this.mNordicSkierMethods;
    }

    public void subscribeLapOccuredEvent(ILapOccuredReceiver LapOccuredReceiver) {
        this.mLapOccuredReceiver = LapOccuredReceiver;
        if (LapOccuredReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    public void subscribeGeneralFitnessEquipmentDataEvent(IGeneralFitnessEquipmentDataReceiver GeneralFitnessEquipmentDataReceiver) {
        this.mGeneralFitnessEquipmentDataReceiver = GeneralFitnessEquipmentDataReceiver;
        if (GeneralFitnessEquipmentDataReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    public void subscribeGeneralSettingsEvent(IGeneralSettingsReceiver GeneralSettingsReceiver) {
        this.mGeneralSettingsReceiver = GeneralSettingsReceiver;
        if (GeneralSettingsReceiver != null) {
            this.subscribeToEvent(204);
        } else {
            this.unsubscribeFromEvent(204);
        }
    }

    public void subscribeGeneralMetabolicDataEvent(IGeneralMetabolicDataReceiver GeneralMetabolicDataReceiver) {
        this.mGeneralMetabolicDataReceiver = GeneralMetabolicDataReceiver;
        if (GeneralMetabolicDataReceiver != null) {
            this.subscribeToEvent(205);
        } else {
            this.unsubscribeFromEvent(205);
        }
    }

    public class NordicSkierMethods {
        public void subscribeNordicSkierDataEvent(INordicSkierDataReceiver NordicSkierDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mNordicSkierDataReceiver = NordicSkierDataReceiver;
            if (NordicSkierDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(211);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(211);
            }
        }
    }

    public class ClimberMethods {
        public void subscribeClimberDataEvent(IClimberDataReceiver ClimberDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mClimberDataReceiver = ClimberDataReceiver;
            if (ClimberDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(210);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(210);
            }
        }
    }

    public class RowerMethods {
        public void subscribeRowerDataEvent(IRowerDataReceiver RowerDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mRowerDataReceiver = RowerDataReceiver;
            if (RowerDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(209);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(209);
            }
        }
    }

    public class BikeMethods {
        public void subscribeBikeDataEvent(IBikeDataReceiver BikeDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mBikeDataReceiver = BikeDataReceiver;
            if (BikeDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(208);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(208);
            }
        }
    }

    public class EllipticalMethods {
        public void subscribeEllipticalDataEvent(IEllipticalDataReceiver EllipticalDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mEllipticalDataReceiver = EllipticalDataReceiver;
            if (EllipticalDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(207);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(207);
            }
        }
    }

    public class TreadmillMethods {
        public void subscribeTreadmillDataEvent(ITreadmillDataReceiver TreadmillDataReceiver) {
            AntPlusFitnessEquipmentPcc.this.mTreadmillDataReceiver = TreadmillDataReceiver;
            if (TreadmillDataReceiver != null) {
                AntPlusFitnessEquipmentPcc.this.subscribeToEvent(206);
            } else {
                AntPlusFitnessEquipmentPcc.this.unsubscribeFromEvent(206);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface INordicSkierDataReceiver {
        public void onNewNordicSkierData(long var1, EnumSet<EventFlag> var3, long var4, int var6, int var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IClimberDataReceiver {
        public void onNewClimberData(long var1, EnumSet<EventFlag> var3, long var4, int var6, int var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRowerDataReceiver {
        public void onNewRowerData(long var1, EnumSet<EventFlag> var3, long var4, int var6, int var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBikeDataReceiver {
        public void onNewBikeData(long var1, EnumSet<EventFlag> var3, int var4, int var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IEllipticalDataReceiver {
        public void onNewEllipticalData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, long var5, int var7, int var8);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITreadmillDataReceiver {
        public void onNewTreadmillData(long var1, EnumSet<EventFlag> var3, int var4, BigDecimal var5, BigDecimal var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGeneralMetabolicDataReceiver {
        public void onNewGeneralMetabolicData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, BigDecimal var5, long var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGeneralSettingsReceiver {
        public void onNewGeneralSettings(long var1, EnumSet<EventFlag> var3, BigDecimal var4, BigDecimal var5, int var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IGeneralFitnessEquipmentDataReceiver {
        public void onNewGeneralFitnessEquipmentData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, long var5, BigDecimal var7, boolean var8, int var9, HeartRateDataSource var10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFitnessEquipmentStateReceiver {
        public void onNewFitnessEquipmentState(long var1, EnumSet<EventFlag> var3, EquipmentType var4, EquipmentState var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ILapOccuredReceiver {
        public void onNewLapOccured(long var1, EnumSet<EventFlag> var3, int var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeartRateDataSource {
        HAND_CONTACT_SENSOR(3),
        EM_5KHz(2),
        ANTPLUS_HRM(1),
        UNKNOWN(0),
        UNRECOGNIZED(-1);

        private int intValue;

        private HeartRateDataSource(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static HeartRateDataSource getValueFromInt(int intValue) {
            for (HeartRateDataSource source : HeartRateDataSource.values()) {
                if (source.getIntValue() != intValue) continue;
                return source;
            }
            HeartRateDataSource unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EquipmentState {
        ASLEEP_OFF(1),
        READY(2),
        IN_USE(3),
        FINISHED_PAUSED(4),
        UNRECOGNIZED(-1);

        private int intValue;

        private EquipmentState(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static EquipmentState getValueFromInt(int intValue) {
            for (EquipmentState state : EquipmentState.values()) {
                if (state.getIntValue() != intValue) continue;
                return state;
            }
            EquipmentState unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EquipmentType {
        GENERAL(16),
        TREADMILL(19),
        ELLIPTICAL(20),
        BIKE(21),
        ROWER(22),
        CLIMBER(23),
        NORDICSKIER(24),
        TRAINER(25),
        UNKNOWN(-1),
        UNRECOGNIZED(-2);

        private int intValue;

        private EquipmentType(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static EquipmentType getValueFromInt(int intValue) {
            for (EquipmentType type : EquipmentType.values()) {
                if (type.getIntValue() != intValue) continue;
                return type;
            }
            EquipmentType unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_FITNESSEQUIPMENTPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_FITNESSEQUIPMENTPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.fitnessequipment.FitnessEquipmentService";
        public static final int MSG_REQACC_PARAM_MODE_iFESTARTSESSION = 300;
        public static final String MSG_REQACC_PARAM_parcelableSETTINGS = "parcelable_settings";
        public static final String MSG_REQACC_PARAM_arrayParcelableFITFILES = "arrayParcelable_fitFiles";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatLAPOCCURED = 201;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_LAPOCCURED_PARAM_intLAPCOUNT = "int_lapCount";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatFITNESSEQUIPMENTSTATE = 202;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_FITNESSEQUIPMENTSTATE_PARAM_intEQUIPMENTTYPECODE = "int_equipmentTypeCode";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_FITNESSEQUIPMENTSTATE_PARAM_intSTATECODE = "int_stateCode";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatGENERALFITNESSEQUIPMENTDATA = 203;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_decimalELAPSEDTIME = "decimal_elapsedTime";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_longCUMULATIVEDISTANCE = "long_cumulativeDistance";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_decimalINSTANTANEOUSSPEED = "decimal_instantaneousSpeed";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_intINSTANTANEOUSHEARTRATE = "int_instantaneousHeartRate";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_intHEARTRATEDATASOURCECODE = "int_heartRateDataSourceCode";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALFITNESSEQUIPMENTDATA_PARAM_boolVIRTUALINSTANTANEOUSSPEED = "bool_virtualInstantaneousSpeed";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatGENERALSETTINGS = 204;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALSETTINGS_PARAM_decimalCYCLELENGTH = "decimal_cycleLength";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALSETTINGS_PARAM_decimalINCLINEPERCENTAGE = "decimal_inclinePercentage";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALSETTINGS_PARAM_intRESISTANCELEVEL = "int_resistanceLevel";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatGENERALMETABOLICDATA = 205;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALMETABOLICDATA_PARAM_decimalINSTANTANEOUSMETABOLICEQUIVALENTS = "decimal_instantaneousMetabolicEquivalents";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALMETABOLICDATA_PARAM_decimalINSTANTANEOUSCALORICBURN = "decimal_instantaneousCaloricBurn";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_GENERALMETABOLICDATA_PARAM_longCUMULATIVECALORIES = "long_cumulativeCalories";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatTREADMILLDATA = 206;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_TREADMILLDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_TREADMILLDATA_PARAM_decimalCUMULATIVENEGVERTDISTANCE = "decimal_cumulativeNegVertDistance";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_TREADMILLDATA_PARAM_decimalCUMULATIVEPOSVERTDISTANCE = "decimal_cumulativePosVertDistance";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatELLIPTICALDATA = 207;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ELLIPTICALDATA_PARAM_decimalCUMULATIVEPOSVERTDISTANCE = "decimal_cumulativePosVertDistance";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ELLIPTICALDATA_PARAM_longCUMULATIVESTRIDES = "long_cumulativeStrides";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ELLIPTICALDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ELLIPTICALDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatBIKEDATA = 208;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_BIKEDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_BIKEDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatROWERDATA = 209;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ROWERDATA_PARAM_longCUMULATIVESTROKES = "long_cumulativeStrokes";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ROWERDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_ROWERDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatCLIMBERDATA = 210;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_CLIMBERDATA_PARAM_longCUMULATIVESTRIDECYCLES = "long_cumulativeStrideCycles";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_CLIMBERDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_CLIMBERDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
        public static final int MSG_EVENT_FITNESSEQUIPMENT_whatNORDICSKIERDATA = 211;
        public static final String MSG_EVENT_FITNESSEQUIPMENT_NORDICSKIERDATA_PARAM_longCUMULATIVESTRIDES = "long_cumulativeStrides";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_NORDICSKIERDATA_PARAM_intINSTANTANEOUSCADENCE = "int_instantaneousCadence";
        public static final String MSG_EVENT_FITNESSEQUIPMENT_NORDICSKIERDATA_PARAM_intINSTANTANEOUSPOWER = "int_instantaneousPower";
    }

    public static class Settings {
        FileIdMesg fileId = new FileIdMesg();
        UserProfileMesg userProfile = new UserProfileMesg();
        HrmProfileMesg hrmProfile = new HrmProfileMesg();

        public Settings(String friendlyName, Gender gender, short age, float height, float weight) {
            this.fileId.setType(File.SETTINGS);
            this.fileId.setManufacturer(Integer.valueOf(15));
            this.fileId.setProduct(Integer.valueOf(65532));
            this.userProfile.setFriendlyName(friendlyName);
            if (gender == Gender.FEMALE) {
                this.userProfile.setGender(com.garmin.fit.Gender.FEMALE);
            } else if (gender == Gender.MALE) {
                this.userProfile.setGender(com.garmin.fit.Gender.MALE);
            } else {
                this.userProfile.setGender(com.garmin.fit.Gender.INVALID);
            }
            this.userProfile.setAge(Short.valueOf(age));
            this.userProfile.setHeight(Float.valueOf(height));
            this.userProfile.setWeight(Float.valueOf(weight));
            this.hrmProfile.setEnabled(Bool.FALSE);
            this.hrmProfile.setHrmAntId(Integer.valueOf(0));
            this.hrmProfile.setHrmAntIdTransType(Short.valueOf((short)0));
        }

        public void setPairedHrmId(int deviceNumber, short transType) {
            this.hrmProfile.setEnabled(Bool.TRUE);
            this.hrmProfile.setHrmAntId(Integer.valueOf(deviceNumber));
            this.hrmProfile.setHrmAntIdTransType(Short.valueOf(transType));
        }

        void setSerialNumber(long serialNumber) {
            this.fileId.setSerialNumber(Long.valueOf(serialNumber));
        }

        public FitFileCommon.FitFile toFitFile() {
            BufferEncoder encoder = new BufferEncoder();
            encoder.open();
            encoder.write((Mesg)this.fileId);
            encoder.write((Mesg)this.userProfile);
            if (this.hrmProfile.getEnabled() == Bool.TRUE) {
                encoder.write((Mesg)this.userProfile);
            }
            byte[] buffer = encoder.close();
            FitFileCommon.FitFile settingsFile = new FitFileCommon.FitFile(buffer);
            settingsFile.setFileType(File.SETTINGS.getValue());
            return settingsFile;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Gender {
            MALE,
            FEMALE,
            UNKNOWN;

        }
    }
}

