// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v3"
	"gopkg.in/gorethink/gorethink.v3/internal/compare"
)

// Tests insertion into tables
func TestMutationInsertSuite(t *testing.T) {
	suite.Run(t, new(MutationInsertSuite))
}

type MutationInsertSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *MutationInsertSuite) SetupTest() {
	suite.T().Log("Setting up MutationInsertSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

	r.DB("test").TableDrop("tbl").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl").Wait().Exec(suite.session)
	suite.Require().NoError(err)
}

func (suite *MutationInsertSuite) TearDownSuite() {
	suite.T().Log("Tearing down MutationInsertSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DB("test").TableDrop("tbl").Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *MutationInsertSuite) TestCases() {
	suite.T().Log("Running MutationInsertSuite: Tests insertion into tables")

	tbl := r.DB("test").Table("tbl")
	_ = tbl // Prevent any noused variable errors

	{
		// mutation/insert.yaml line #6
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* r.db('test').table_create('test2') */

		suite.T().Log("About to run line #6: r.DB('test').TableCreate('test2')")

		runAndAssert(suite.Suite, expected_, r.DB("test").TableCreate("test2"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	// mutation/insert.yaml line #9
	// tbl2 = r.db('test').table('test2')
	suite.T().Log("Possibly executing: var tbl2 r.Term = r.DB('test').Table('test2')")

	tbl2 := r.DB("test").Table("test2")
	_ = tbl2 // Prevent any noused variable errors

	{
		// mutation/insert.yaml line #12
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':0,'a':0}) */

		suite.T().Log("About to run line #12: tbl.Insert(map[interface{}]interface{}{'id': 0, 'a': 0, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 0, "a": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	{
		// mutation/insert.yaml line #14
		/* 1 */
		var expected_ int = 1
		/* tbl.count() */

		suite.T().Log("About to run line #14: tbl.Count()")

		runAndAssert(suite.Suite, expected_, tbl.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// mutation/insert.yaml line #18
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':1, 'a':1}, durability='hard') */

		suite.T().Log("About to run line #18: tbl.Insert(map[interface{}]interface{}{'id': 1, 'a': 1, }).OptArgs(r.InsertOpts{Durability: 'hard', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 1, "a": 1}).OptArgs(r.InsertOpts{Durability: "hard"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// mutation/insert.yaml line #22
		/* 2 */
		var expected_ int = 2
		/* tbl.count() */

		suite.T().Log("About to run line #22: tbl.Count()")

		runAndAssert(suite.Suite, expected_, tbl.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #22")
	}

	{
		// mutation/insert.yaml line #26
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':2, 'a':2}, durability='soft') */

		suite.T().Log("About to run line #26: tbl.Insert(map[interface{}]interface{}{'id': 2, 'a': 2, }).OptArgs(r.InsertOpts{Durability: 'soft', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 2, "a": 2}).OptArgs(r.InsertOpts{Durability: "soft"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #26")
	}

	{
		// mutation/insert.yaml line #30
		/* 3 */
		var expected_ int = 3
		/* tbl.count() */

		suite.T().Log("About to run line #30: tbl.Count()")

		runAndAssert(suite.Suite, expected_, tbl.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #30")
	}

	{
		// mutation/insert.yaml line #34
		/* err('ReqlQueryLogicError', 'Durability option `wrong` unrecognized (options are "hard" and "soft").', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Durability option `wrong` unrecognized (options are \"hard\" and \"soft\").")
		/* tbl.insert({'id':3, 'a':3}, durability='wrong') */

		suite.T().Log("About to run line #34: tbl.Insert(map[interface{}]interface{}{'id': 3, 'a': 3, }).OptArgs(r.InsertOpts{Durability: 'wrong', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 3, "a": 3}).OptArgs(r.InsertOpts{Durability: "wrong"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// mutation/insert.yaml line #38
		/* 3 */
		var expected_ int = 3
		/* tbl.count() */

		suite.T().Log("About to run line #38: tbl.Count()")

		runAndAssert(suite.Suite, expected_, tbl.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #38")
	}

	{
		// mutation/insert.yaml line #42
		/* {'deleted':1,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 1, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 0}
		/* tbl.get(2).delete() */

		suite.T().Log("About to run line #42: tbl.Get(2).Delete()")

		runAndAssert(suite.Suite, expected_, tbl.Get(2).Delete(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #42")
	}

	{
		// mutation/insert.yaml line #46
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':2} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 2}
		/* tbl.insert([{'id':2,'a':2}, {'id':3,'a':3}]) */

		suite.T().Log("About to run line #46: tbl.Insert([]interface{}{map[interface{}]interface{}{'id': 2, 'a': 2, }, map[interface{}]interface{}{'id': 3, 'a': 3, }})")

		runAndAssert(suite.Suite, expected_, tbl.Insert([]interface{}{map[interface{}]interface{}{"id": 2, "a": 2}, map[interface{}]interface{}{"id": 3, "a": 3}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// mutation/insert.yaml line #50
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':4} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 4}
		/* tbl2.insert(tbl) */

		suite.T().Log("About to run line #50: tbl2.Insert(tbl)")

		runAndAssert(suite.Suite, expected_, tbl2.Insert(tbl), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #50")
	}

	{
		// mutation/insert.yaml line #54
		/* {'first_error':"Duplicate primary key `id`:\n{\n\t\"a\":\t2,\n\t\"id\":\t2\n}\n{\n\t\"b\":\t20,\n\t\"id\":\t2\n}",'deleted':0,'replaced':0,'unchanged':0,'errors':1,'skipped':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"first_error": "Duplicate primary key `id`:\n{\n\t\"a\":\t2,\n\t\"id\":\t2\n}\n{\n\t\"b\":\t20,\n\t\"id\":\t2\n}", "deleted": 0, "replaced": 0, "unchanged": 0, "errors": 1, "skipped": 0, "inserted": 0}
		/* tbl.insert({'id':2,'b':20}) */

		suite.T().Log("About to run line #54: tbl.Insert(map[interface{}]interface{}{'id': 2, 'b': 20, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 2, "b": 20}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #54")
	}

	{
		// mutation/insert.yaml line #58
		/* {'first_error':"Duplicate primary key `id`:\n{\n\t\"a\":\t2,\n\t\"id\":\t2\n}\n{\n\t\"b\":\t20,\n\t\"id\":\t2\n}",'deleted':0,'replaced':0,'unchanged':0,'errors':1,'skipped':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"first_error": "Duplicate primary key `id`:\n{\n\t\"a\":\t2,\n\t\"id\":\t2\n}\n{\n\t\"b\":\t20,\n\t\"id\":\t2\n}", "deleted": 0, "replaced": 0, "unchanged": 0, "errors": 1, "skipped": 0, "inserted": 0}
		/* tbl.insert({'id':2,'b':20}, conflict='error') */

		suite.T().Log("About to run line #58: tbl.Insert(map[interface{}]interface{}{'id': 2, 'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'error', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 2, "b": 20}).OptArgs(r.InsertOpts{Conflict: "error"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #58")
	}

	{
		// mutation/insert.yaml line #64
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':15,'b':20}, conflict='error') */

		suite.T().Log("About to run line #64: tbl.Insert(map[interface{}]interface{}{'id': 15, 'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'error', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 15, "b": 20}).OptArgs(r.InsertOpts{Conflict: "error"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #64")
	}

	{
		// mutation/insert.yaml line #69
		/* {'id':15,'b':20} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 15, "b": 20}
		/* tbl.get(15) */

		suite.T().Log("About to run line #69: tbl.Get(15)")

		runAndAssert(suite.Suite, expected_, tbl.Get(15), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #69")
	}

	{
		// mutation/insert.yaml line #73
		/* {'deleted':0,'replaced':1,'unchanged':0,'errors':0,'skipped':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 1, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 0}
		/* tbl.insert({'id':2,'b':20}, conflict='replace') */

		suite.T().Log("About to run line #73: tbl.Insert(map[interface{}]interface{}{'id': 2, 'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'replace', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 2, "b": 20}).OptArgs(r.InsertOpts{Conflict: "replace"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// mutation/insert.yaml line #78
		/* {'id':2,'b':20} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 2, "b": 20}
		/* tbl.get(2) */

		suite.T().Log("About to run line #78: tbl.Get(2)")

		runAndAssert(suite.Suite, expected_, tbl.Get(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #78")
	}

	{
		// mutation/insert.yaml line #82
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':20,'b':20}, conflict='replace') */

		suite.T().Log("About to run line #82: tbl.Insert(map[interface{}]interface{}{'id': 20, 'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'replace', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 20, "b": 20}).OptArgs(r.InsertOpts{Conflict: "replace"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #82")
	}

	{
		// mutation/insert.yaml line #87
		/* {'id':20,'b':20} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 20, "b": 20}
		/* tbl.get(20) */

		suite.T().Log("About to run line #87: tbl.Get(20)")

		runAndAssert(suite.Suite, expected_, tbl.Get(20), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #87")
	}

	{
		// mutation/insert.yaml line #91
		/* {'deleted':0,'replaced':1,'unchanged':0,'errors':0,'skipped':0,'inserted':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 1, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 0}
		/* tbl.insert({'id':2,'c':30}, conflict='update') */

		suite.T().Log("About to run line #91: tbl.Insert(map[interface{}]interface{}{'id': 2, 'c': 30, }).OptArgs(r.InsertOpts{Conflict: 'update', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 2, "c": 30}).OptArgs(r.InsertOpts{Conflict: "update"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #91")
	}

	{
		// mutation/insert.yaml line #96
		/* {'id':2, 'b':20, 'c':30} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 2, "b": 20, "c": 30}
		/* tbl.get(2) */

		suite.T().Log("About to run line #96: tbl.Get(2)")

		runAndAssert(suite.Suite, expected_, tbl.Get(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #96")
	}

	{
		// mutation/insert.yaml line #100
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tbl.insert({'id':30,'b':20}, conflict='update') */

		suite.T().Log("About to run line #100: tbl.Insert(map[interface{}]interface{}{'id': 30, 'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'update', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 30, "b": 20}).OptArgs(r.InsertOpts{Conflict: "update"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// mutation/insert.yaml line #105
		/* {'id':30,'b':20} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 30, "b": 20}
		/* tbl.get(30) */

		suite.T().Log("About to run line #105: tbl.Get(30)")

		runAndAssert(suite.Suite, expected_, tbl.Get(30), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #105")
	}

	{
		// mutation/insert.yaml line #109
		/* err('ReqlQueryLogicError', 'Conflict option `wrong` unrecognized (options are "error", "replace" and "update").', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Conflict option `wrong` unrecognized (options are \"error\", \"replace\" and \"update\").")
		/* tbl.insert({'id':3, 'a':3}, conflict='wrong') */

		suite.T().Log("About to run line #109: tbl.Insert(map[interface{}]interface{}{'id': 3, 'a': 3, }).OptArgs(r.InsertOpts{Conflict: 'wrong', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 3, "a": 3}).OptArgs(r.InsertOpts{Conflict: "wrong"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #109")
	}

	// mutation/insert.yaml line #120
	// tblpkey = r.db('test').table('testpkey')
	suite.T().Log("Possibly executing: var tblpkey r.Term = r.DB('test').Table('testpkey')")

	tblpkey := r.DB("test").Table("testpkey")
	_ = tblpkey // Prevent any noused variable errors

	{
		// mutation/insert.yaml line #115
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* r.db('test').table_create('testpkey', primary_key='foo') */

		suite.T().Log("About to run line #115: r.DB('test').TableCreate('testpkey').OptArgs(r.TableCreateOpts{PrimaryKey: 'foo', })")

		runAndAssert(suite.Suite, expected_, r.DB("test").TableCreate("testpkey").OptArgs(r.TableCreateOpts{PrimaryKey: "foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #115")
	}

	{
		// mutation/insert.yaml line #122
		/* {'deleted':0,'replaced':0,'generated_keys':arrlen(1,uuid()),'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "generated_keys": arrlen(1, compare.IsUUID()), "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tblpkey.insert({}) */

		suite.T().Log("About to run line #122: tblpkey.Insert(map[interface{}]interface{}{})")

		runAndAssert(suite.Suite, expected_, tblpkey.Insert(map[interface{}]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #122")
	}

	{
		// mutation/insert.yaml line #125
		/* [{'foo':uuid()}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"foo": compare.IsUUID()}}
		/* tblpkey */

		suite.T().Log("About to run line #125: tblpkey")

		runAndAssert(suite.Suite, expected_, tblpkey, suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #125")
	}

	{
		// mutation/insert.yaml line #129
		/* {'deleted':0,'replaced':0,'generated_keys':arrlen(1,uuid()),'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "generated_keys": arrlen(1, compare.IsUUID()), "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tblpkey.insert({'b':20}, conflict='replace') */

		suite.T().Log("About to run line #129: tblpkey.Insert(map[interface{}]interface{}{'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'replace', })")

		runAndAssert(suite.Suite, expected_, tblpkey.Insert(map[interface{}]interface{}{"b": 20}).OptArgs(r.InsertOpts{Conflict: "replace"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #129")
	}

	{
		// mutation/insert.yaml line #135
		/* {'deleted':0,'replaced':0,'generated_keys':arrlen(1,uuid()),'unchanged':0,'errors':0,'skipped':0,'inserted':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "generated_keys": arrlen(1, compare.IsUUID()), "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 1}
		/* tblpkey.insert({'b':20}, conflict='update') */

		suite.T().Log("About to run line #135: tblpkey.Insert(map[interface{}]interface{}{'b': 20, }).OptArgs(r.InsertOpts{Conflict: 'update', })")

		runAndAssert(suite.Suite, expected_, tblpkey.Insert(map[interface{}]interface{}{"b": 20}).OptArgs(r.InsertOpts{Conflict: "update"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #135")
	}

	{
		// mutation/insert.yaml line #140
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* r.db('test').table_drop('testpkey') */

		suite.T().Log("About to run line #140: r.DB('test').TableDrop('testpkey')")

		runAndAssert(suite.Suite, expected_, r.DB("test").TableDrop("testpkey"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #140")
	}

	{
		// mutation/insert.yaml line #144
		/* {'deleted':0,'replaced':0,'unchanged':0,'errors':0,'skipped':0,'inserted':7} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 7}
		/* tbl.for_each(lambda  row:          tbl2.insert(row.merge({'id':row['id']  +  100 }))   ) */

		suite.T().Log("About to run line #144: tbl.ForEach(func(row r.Term) interface{} { return tbl2.Insert(row.Merge(map[interface{}]interface{}{'id': row.AtIndex('id').Add(100), }))})")

		runAndAssert(suite.Suite, expected_, tbl.ForEach(func(row r.Term) interface{} {
			return tbl2.Insert(row.Merge(map[interface{}]interface{}{"id": row.AtIndex("id").Add(100)}))
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #144")
	}

	{
		// mutation/insert.yaml line #150
		/* partial({'errors':1,'first_error':'`r.minval` and `r.maxval` cannot be written to disk.'}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"errors": 1, "first_error": "`r.minval` and `r.maxval` cannot be written to disk."})
		/* tbl.insert({'value':r.minval}) */

		suite.T().Log("About to run line #150: tbl.Insert(map[interface{}]interface{}{'value': r.MinVal, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"value": r.MinVal}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #150")
	}

	{
		// mutation/insert.yaml line #154
		/* partial({'errors':1,'first_error':'`r.minval` and `r.maxval` cannot be written to disk.'}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"errors": 1, "first_error": "`r.minval` and `r.maxval` cannot be written to disk."})
		/* tbl.insert({'value':r.maxval}) */

		suite.T().Log("About to run line #154: tbl.Insert(map[interface{}]interface{}{'value': r.MaxVal, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"value": r.MaxVal}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #154")
	}

	{
		// mutation/insert.yaml line #159
		/* {'changes': [{'new_val': {'id': 666}, 'old_val': None},{'error': 'Duplicate primary key `id`:\n{\n\t"id":\t666\n}\n{\n\t"id":\t666\n}','new_val': {'id': 666},'old_val': {'id': 666}}],'deleted': 0,'errors': 1,'first_error': 'Duplicate primary key `id`:\n{\n\t"id":\t666\n}\n{\n\t"id":\t666\n}','inserted': 1,'replaced': 0,'skipped': 0,'unchanged': 0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"changes": []interface{}{map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 666}, "old_val": nil}, map[interface{}]interface{}{"error": "Duplicate primary key `id`:\n{\n\t\"id\":\t666\n}\n{\n\t\"id\":\t666\n}", "new_val": map[interface{}]interface{}{"id": 666}, "old_val": map[interface{}]interface{}{"id": 666}}}, "deleted": 0, "errors": 1, "first_error": "Duplicate primary key `id`:\n{\n\t\"id\":\t666\n}\n{\n\t\"id\":\t666\n}", "inserted": 1, "replaced": 0, "skipped": 0, "unchanged": 0}
		/* tbl.insert([{'id':666}, {'id':666}], return_changes="always") */

		suite.T().Log("About to run line #159: tbl.Insert([]interface{}{map[interface{}]interface{}{'id': 666, }, map[interface{}]interface{}{'id': 666, }}).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert([]interface{}{map[interface{}]interface{}{"id": 666}, map[interface{}]interface{}{"id": 666}}).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// mutation/insert.yaml line #163
		/* partial({'changes':[{'old_val': None, 'new_val': {'id': 100+i, 'ordered-num': i}} for i in range(1,100)] }) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": (func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"old_val": nil, "new_val": map[interface{}]interface{}{"id": 100 + i, "ordered-num": i}})
			}
			return res
		}())})
		/* tbl.insert([{'id':100+i, 'ordered-num':i} for i in range(1,100)], return_changes="always") */

		suite.T().Log("About to run line #163: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 1; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': r.Add(100, i), 'ordered-num': i, })\n    }\n    return res\n}())).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": r.Add(100, i), "ordered-num": i})
			}
			return res
		}())).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #163")
	}

	{
		// mutation/insert.yaml line #167
		/* partial({'changes':[{'old_val': None, 'new_val': {'id': [1,"blah", 200+i], 'ordered-num': i}} for i in range(1,100)] }) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": (func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"old_val": nil, "new_val": map[interface{}]interface{}{"id": []interface{}{1, "blah", 200 + i}, "ordered-num": i}})
			}
			return res
		}())})
		/* tbl.insert([{'id':[1, "blah", 200+i], 'ordered-num':i} for i in range(1,100)], return_changes="always") */

		suite.T().Log("About to run line #167: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 1; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': []interface{}{1, 'blah', r.Add(200, i)}, 'ordered-num': i, })\n    }\n    return res\n}())).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": []interface{}{1, "blah", r.Add(200, i)}, "ordered-num": i})
			}
			return res
		}())).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #167")
	}

	{
		// mutation/insert.yaml line #171
		/* partial({'changes':[{'old_val': None, 'new_val': {'id': [1,"blah", 300+i], 'ordered-num': i}} for i in range(1,100)] }) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": (func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"old_val": nil, "new_val": map[interface{}]interface{}{"id": []interface{}{1, "blah", 300 + i}, "ordered-num": i}})
			}
			return res
		}())})
		/* tbl.insert([{'id':[1, "blah", 300+i], 'ordered-num':i} for i in range(1,100)], return_changes=true) */

		suite.T().Log("About to run line #171: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 1; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': []interface{}{1, 'blah', r.Add(300, i)}, 'ordered-num': i, })\n    }\n    return res\n}())).OptArgs(r.InsertOpts{ReturnChanges: true, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": []interface{}{1, "blah", r.Add(300, i)}, "ordered-num": i})
			}
			return res
		}())).OptArgs(r.InsertOpts{ReturnChanges: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #171")
	}

	{
		// mutation/insert.yaml line #175
		/* partial({'changes':[{'old_val': {'id':100+i, 'ordered-num':i}, 'new_val': {'id':100+i, 'ordered-num':i}, 'error':'Duplicate primary key `id`:\n{\n\t"id":\t'+str(100+i)+',\n\t"ordered-num":\t'+str(i)+'\n}\n{\n\t"id":\t'+str(100+i)+',\n\t"ordered-num":\t'+str(i)+'\n}'} for i in range(1,100)]}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": (func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"old_val": map[interface{}]interface{}{"id": 100 + i, "ordered-num": i}, "new_val": map[interface{}]interface{}{"id": 100 + i, "ordered-num": i}, "error": "Duplicate primary key `id`:\n{\n\t\"id\":\t" + str(100+i) + ",\n\t\"ordered-num\":\t" + str(i) + "\n}\n{\n\t\"id\":\t" + str(100+i) + ",\n\t\"ordered-num\":\t" + str(i) + "\n}"})
			}
			return res
		}())})
		/* tbl.insert([{'id':100 + i, 'ordered-num':i} for i in range(1,100)], return_changes="always") */

		suite.T().Log("About to run line #175: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 1; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': r.Add(100, i), 'ordered-num': i, })\n    }\n    return res\n}())).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": r.Add(100, i), "ordered-num": i})
			}
			return res
		}())).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #175")
	}

	{
		// mutation/insert.yaml line #179
		/* {'changes': [{'error': 'Duplicate primary key `id`:\n{\n\t"id":\t123,\n\t"ordered-num":\t23\n}\n{\n\t"id":\t123\n}', 'new_val': {'id': 123, 'ordered-num': 23}, 'old_val': {'id': 123, 'ordered-num': 23}}, {'error': 'Primary key too long (max 127 characters): "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"', 'new_val': None, 'old_val': None}, {'new_val': {'id': 321}, 'old_val': None}], 'deleted': 0, 'errors': 2, 'first_error': 'Primary key too long (max 127 characters): "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"', 'inserted': 1, 'replaced': 0, 'skipped': 0, 'unchanged': 0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"changes": []interface{}{map[interface{}]interface{}{"error": "Duplicate primary key `id`:\n{\n\t\"id\":\t123,\n\t\"ordered-num\":\t23\n}\n{\n\t\"id\":\t123\n}", "new_val": map[interface{}]interface{}{"id": 123, "ordered-num": 23}, "old_val": map[interface{}]interface{}{"id": 123, "ordered-num": 23}}, map[interface{}]interface{}{"error": "Primary key too long (max 127 characters): \"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\"", "new_val": nil, "old_val": nil}, map[interface{}]interface{}{"new_val": map[interface{}]interface{}{"id": 321}, "old_val": nil}}, "deleted": 0, "errors": 2, "first_error": "Primary key too long (max 127 characters): \"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\"", "inserted": 1, "replaced": 0, "skipped": 0, "unchanged": 0}
		/* tbl.insert([{'id':123}, {'id':'a'*500}, {'id':321}], return_changes="always") */

		suite.T().Log("About to run line #179: tbl.Insert([]interface{}{map[interface{}]interface{}{'id': 123, }, map[interface{}]interface{}{'id': 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', }, map[interface{}]interface{}{'id': 321, }}).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert([]interface{}{map[interface{}]interface{}{"id": 123}, map[interface{}]interface{}{"id": "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}, map[interface{}]interface{}{"id": 321}}).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #179")
	}

	{
		// mutation/insert.yaml line #183
		/* partial({'changes':[]}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": []interface{}{}})
		/* tbl.insert([{'id':100 + i, 'ordered-num':i} for i in range(1,100)], return_changes=true) */

		suite.T().Log("About to run line #183: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 1; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': r.Add(100, i), 'ordered-num': i, })\n    }\n    return res\n}())).OptArgs(r.InsertOpts{ReturnChanges: true, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 1; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": r.Add(100, i), "ordered-num": i})
			}
			return res
		}())).OptArgs(r.InsertOpts{ReturnChanges: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #183")
	}

	{
		// mutation/insert.yaml line #186
		/* partial({'changes': [{'old_val': None, 'new_val': None, 'error': '`r.minval` and `r.maxval` cannot be written to disk.'}]}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"changes": []interface{}{map[interface{}]interface{}{"old_val": nil, "new_val": nil, "error": "`r.minval` and `r.maxval` cannot be written to disk."}}})
		/* tbl.insert({'a':r.minval}, return_changes="always") */

		suite.T().Log("About to run line #186: tbl.Insert(map[interface{}]interface{}{'a': r.MinVal, }).OptArgs(r.InsertOpts{ReturnChanges: 'always', })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"a": r.MinVal}).OptArgs(r.InsertOpts{ReturnChanges: "always"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #186")
	}

	{
		// mutation/insert.yaml line #192
		/* partial({'inserted':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"inserted": 1})
		/* tbl.insert({'id':42, 'foo':1, 'bar':1}) */

		suite.T().Log("About to run line #192: tbl.Insert(map[interface{}]interface{}{'id': 42, 'foo': 1, 'bar': 1, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42, "foo": 1, "bar": 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #192")
	}

	{
		// mutation/insert.yaml line #194
		/* partial({'replaced':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"replaced": 1})
		/* tbl.insert({'id':42, 'foo':5, 'bar':5}, conflict=lambda id, old_row, new_row: old_row.merge(new_row.pluck("bar"))) */

		suite.T().Log("About to run line #194: tbl.Insert(map[interface{}]interface{}{'id': 42, 'foo': 5, 'bar': 5, }).OptArgs(r.InsertOpts{Conflict: func(id r.Term, old_row r.Term, new_row r.Term) interface{} { return old_row.Merge(new_row.Pluck('bar'))}, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42, "foo": 5, "bar": 5}).OptArgs(r.InsertOpts{Conflict: func(id r.Term, old_row r.Term, new_row r.Term) interface{} {
			return old_row.Merge(new_row.Pluck("bar"))
		}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #194")
	}

	{
		// mutation/insert.yaml line #196
		/* {'id':42, 'foo':1, 'bar':5} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 42, "foo": 1, "bar": 5}
		/* tbl.get(42) */

		suite.T().Log("About to run line #196: tbl.Get(42)")

		runAndAssert(suite.Suite, expected_, tbl.Get(42), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	{
		// mutation/insert.yaml line #214
		/* partial({'first_error': 'Inserted value must be an OBJECT (got NUMBER):\n2'}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"first_error": "Inserted value must be an OBJECT (got NUMBER):\n2"})
		/* tbl.insert({'id':42, 'foo':1, 'bar':1}, conflict=lambda a,b,c: 2) */

		suite.T().Log("About to run line #214: tbl.Insert(map[interface{}]interface{}{'id': 42, 'foo': 1, 'bar': 1, }).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} { return 2}, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42, "foo": 1, "bar": 1}).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} { return 2 }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #214")
	}

	{
		// mutation/insert.yaml line #218
		/* err("ReqlQueryLogicError", "The conflict function passed to `insert` should expect 3 arguments.") */
		var expected_ Err = err("ReqlQueryLogicError", "The conflict function passed to `insert` should expect 3 arguments.")
		/* tbl.insert({'id':42}, conflict=lambda a,b: a) */

		suite.T().Log("About to run line #218: tbl.Insert(map[interface{}]interface{}{'id': 42, }).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term) interface{} { return a}, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42}).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term) interface{} { return a }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #218")
	}

	{
		// mutation/insert.yaml line #222
		/* err("ReqlQueryLogicError", "The conflict function passed to `insert` must be deterministic.") */
		var expected_ Err = err("ReqlQueryLogicError", "The conflict function passed to `insert` must be deterministic.")
		/* tbl.insert({'id':42}, conflict=lambda a,b,c: tbl.get(42)) */

		suite.T().Log("About to run line #222: tbl.Insert(map[interface{}]interface{}{'id': 42, }).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} { return tbl.Get(42)}, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42}).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} { return tbl.Get(42) }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #222")
	}

	{
		// mutation/insert.yaml line #225
		/* partial({'replaced': 1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"replaced": 1})
		/* tbl.insert({'id':42}, conflict=lambda a,b,c: {'id':42, 'num':'424'}) */

		suite.T().Log("About to run line #225: tbl.Insert(map[interface{}]interface{}{'id': 42, }).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} { return map[interface{}]interface{}{'id': 42, 'num': '424', }}, })")

		runAndAssert(suite.Suite, expected_, tbl.Insert(map[interface{}]interface{}{"id": 42}).OptArgs(r.InsertOpts{Conflict: func(a r.Term, b r.Term, c r.Term) interface{} {
			return map[interface{}]interface{}{"id": 42, "num": "424"}
		}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #225")
	}

	{
		// mutation/insert.yaml line #227
		/* {'id':42, 'num':'424'} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 42, "num": "424"}
		/* tbl.get(42) */

		suite.T().Log("About to run line #227: tbl.Get(42)")

		runAndAssert(suite.Suite, expected_, tbl.Get(42), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #227")
	}

	{
		// mutation/insert.yaml line #231
		/* err('ReqlQueryLogicError','Cannot convert `r.minval` to JSON.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot convert `r.minval` to JSON.")
		/* r.minval */

		suite.T().Log("About to run line #231: r.MinVal")

		runAndAssert(suite.Suite, expected_, r.MinVal, suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// mutation/insert.yaml line #234
		/* err('ReqlQueryLogicError','Cannot convert `r.maxval` to JSON.') */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot convert `r.maxval` to JSON.")
		/* r.maxval */

		suite.T().Log("About to run line #234: r.MaxVal")

		runAndAssert(suite.Suite, expected_, r.MaxVal, suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #234")
	}

	{
		// mutation/insert.yaml line #238
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* r.db('test').table_drop('test2') */

		suite.T().Log("About to run line #238: r.DB('test').TableDrop('test2')")

		runAndAssert(suite.Suite, expected_, r.DB("test").TableDrop("test2"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #238")
	}
}
