// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/service.proto

package monitoring

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/monitoredres"
	calendarperiod "google.golang.org/genproto/googleapis/type/calendarperiod"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// `ServiceLevelObjective.View` determines what form of
// `ServiceLevelObjective` is returned from `GetServiceLevelObjective`,
// `ListServiceLevelObjectives`, and `ListServiceLevelObjectiveVersions` RPCs.
type ServiceLevelObjective_View int32

const (
	// Same as FULL.
	ServiceLevelObjective_VIEW_UNSPECIFIED ServiceLevelObjective_View = 0
	// Return the embedded `ServiceLevelIndicator` in the form in which it was
	// defined. If it was defined using a `BasicSli`, return that `BasicSli`.
	ServiceLevelObjective_FULL ServiceLevelObjective_View = 2
	// For `ServiceLevelIndicator`s using `BasicSli` articulation, instead
	// return the `ServiceLevelIndicator` with its mode of computation fully
	// spelled out as a `RequestBasedSli`. For `ServiceLevelIndicator`s using
	// `RequestBasedSli` or `WindowsBasedSli`, return the
	// `ServiceLevelIndicator` as it was provided.
	ServiceLevelObjective_EXPLICIT ServiceLevelObjective_View = 1
)

var ServiceLevelObjective_View_name = map[int32]string{
	0: "VIEW_UNSPECIFIED",
	2: "FULL",
	1: "EXPLICIT",
}

var ServiceLevelObjective_View_value = map[string]int32{
	"VIEW_UNSPECIFIED": 0,
	"FULL":             2,
	"EXPLICIT":         1,
}

func (x ServiceLevelObjective_View) String() string {
	return proto.EnumName(ServiceLevelObjective_View_name, int32(x))
}

func (ServiceLevelObjective_View) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{1, 0}
}

// A `Service` is a discrete, autonomous, and network-accessible unit, designed
// to solve an individual concern
// ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
// Stackdriver Monitoring, a `Service` acts as the root resource under which
// operational aspects of the service are accessible.
type Service struct {
	// Resource name for this Service. Of the form
	// `projects/{project_id}/services/{service_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name used for UI elements listing this Service.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// REQUIRED. Service-identifying atoms specifying the underlying service.
	//
	// Types that are valid to be assigned to Identifier:
	//	*Service_Custom_
	//	*Service_AppEngine_
	//	*Service_CloudEndpoints_
	//	*Service_ClusterIstio_
	Identifier isService_Identifier `protobuf_oneof:"identifier"`
	// Configuration for how to query telemetry on a Service.
	Telemetry            *Service_Telemetry `protobuf:"bytes,13,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Service) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

type isService_Identifier interface {
	isService_Identifier()
}

type Service_Custom_ struct {
	Custom *Service_Custom `protobuf:"bytes,6,opt,name=custom,proto3,oneof"`
}

type Service_AppEngine_ struct {
	AppEngine *Service_AppEngine `protobuf:"bytes,7,opt,name=app_engine,json=appEngine,proto3,oneof"`
}

type Service_CloudEndpoints_ struct {
	CloudEndpoints *Service_CloudEndpoints `protobuf:"bytes,8,opt,name=cloud_endpoints,json=cloudEndpoints,proto3,oneof"`
}

type Service_ClusterIstio_ struct {
	ClusterIstio *Service_ClusterIstio `protobuf:"bytes,9,opt,name=cluster_istio,json=clusterIstio,proto3,oneof"`
}

func (*Service_Custom_) isService_Identifier() {}

func (*Service_AppEngine_) isService_Identifier() {}

func (*Service_CloudEndpoints_) isService_Identifier() {}

func (*Service_ClusterIstio_) isService_Identifier() {}

func (m *Service) GetIdentifier() isService_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (m *Service) GetCustom() *Service_Custom {
	if x, ok := m.GetIdentifier().(*Service_Custom_); ok {
		return x.Custom
	}
	return nil
}

func (m *Service) GetAppEngine() *Service_AppEngine {
	if x, ok := m.GetIdentifier().(*Service_AppEngine_); ok {
		return x.AppEngine
	}
	return nil
}

func (m *Service) GetCloudEndpoints() *Service_CloudEndpoints {
	if x, ok := m.GetIdentifier().(*Service_CloudEndpoints_); ok {
		return x.CloudEndpoints
	}
	return nil
}

func (m *Service) GetClusterIstio() *Service_ClusterIstio {
	if x, ok := m.GetIdentifier().(*Service_ClusterIstio_); ok {
		return x.ClusterIstio
	}
	return nil
}

func (m *Service) GetTelemetry() *Service_Telemetry {
	if m != nil {
		return m.Telemetry
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Service) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Service_Custom_)(nil),
		(*Service_AppEngine_)(nil),
		(*Service_CloudEndpoints_)(nil),
		(*Service_ClusterIstio_)(nil),
	}
}

// Custom view of service telemetry. Currently a place-holder pending final
// design.
type Service_Custom struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service_Custom) Reset()         { *m = Service_Custom{} }
func (m *Service_Custom) String() string { return proto.CompactTextString(m) }
func (*Service_Custom) ProtoMessage()    {}
func (*Service_Custom) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0, 0}
}

func (m *Service_Custom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service_Custom.Unmarshal(m, b)
}
func (m *Service_Custom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service_Custom.Marshal(b, m, deterministic)
}
func (m *Service_Custom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service_Custom.Merge(m, src)
}
func (m *Service_Custom) XXX_Size() int {
	return xxx_messageInfo_Service_Custom.Size(m)
}
func (m *Service_Custom) XXX_DiscardUnknown() {
	xxx_messageInfo_Service_Custom.DiscardUnknown(m)
}

var xxx_messageInfo_Service_Custom proto.InternalMessageInfo

// App Engine service. Learn more at https://cloud.google.com/appengine.
type Service_AppEngine struct {
	// The ID of the App Engine module underlying this service. Corresponds to
	// the `module_id` resource label in the `gae_app` monitored resource:
	// https://cloud.google.com/monitoring/api/resources#tag_gae_app
	ModuleId             string   `protobuf:"bytes,1,opt,name=module_id,json=moduleId,proto3" json:"module_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service_AppEngine) Reset()         { *m = Service_AppEngine{} }
func (m *Service_AppEngine) String() string { return proto.CompactTextString(m) }
func (*Service_AppEngine) ProtoMessage()    {}
func (*Service_AppEngine) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0, 1}
}

func (m *Service_AppEngine) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service_AppEngine.Unmarshal(m, b)
}
func (m *Service_AppEngine) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service_AppEngine.Marshal(b, m, deterministic)
}
func (m *Service_AppEngine) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service_AppEngine.Merge(m, src)
}
func (m *Service_AppEngine) XXX_Size() int {
	return xxx_messageInfo_Service_AppEngine.Size(m)
}
func (m *Service_AppEngine) XXX_DiscardUnknown() {
	xxx_messageInfo_Service_AppEngine.DiscardUnknown(m)
}

var xxx_messageInfo_Service_AppEngine proto.InternalMessageInfo

func (m *Service_AppEngine) GetModuleId() string {
	if m != nil {
		return m.ModuleId
	}
	return ""
}

// Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
type Service_CloudEndpoints struct {
	// The name of the Cloud Endpoints service underlying this service.
	// Corresponds to the `service` resource label in the `api` monitored
	// resource: https://cloud.google.com/monitoring/api/resources#tag_api
	Service              string   `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service_CloudEndpoints) Reset()         { *m = Service_CloudEndpoints{} }
func (m *Service_CloudEndpoints) String() string { return proto.CompactTextString(m) }
func (*Service_CloudEndpoints) ProtoMessage()    {}
func (*Service_CloudEndpoints) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0, 2}
}

func (m *Service_CloudEndpoints) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service_CloudEndpoints.Unmarshal(m, b)
}
func (m *Service_CloudEndpoints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service_CloudEndpoints.Marshal(b, m, deterministic)
}
func (m *Service_CloudEndpoints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service_CloudEndpoints.Merge(m, src)
}
func (m *Service_CloudEndpoints) XXX_Size() int {
	return xxx_messageInfo_Service_CloudEndpoints.Size(m)
}
func (m *Service_CloudEndpoints) XXX_DiscardUnknown() {
	xxx_messageInfo_Service_CloudEndpoints.DiscardUnknown(m)
}

var xxx_messageInfo_Service_CloudEndpoints proto.InternalMessageInfo

func (m *Service_CloudEndpoints) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

// Istio service. Learn more at http://istio.io.
type Service_ClusterIstio struct {
	// The location of the Kubernetes cluster in which this Istio service is
	// defined. Corresponds to the `location` resource label in `k8s_cluster`
	// resources.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The name of the Kubernetes cluster in which this Istio service is
	// defined. Corresponds to the `cluster_name` resource label in
	// `k8s_cluster` resources.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// The namespace of the Istio service underlying this service. Corresponds
	// to the `destination_service_namespace` metric label in Istio metrics.
	ServiceNamespace string `protobuf:"bytes,3,opt,name=service_namespace,json=serviceNamespace,proto3" json:"service_namespace,omitempty"`
	// The name of the Istio service underlying this service. Corresponds to the
	// `destination_service_name` metric label in Istio metrics.
	ServiceName          string   `protobuf:"bytes,4,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service_ClusterIstio) Reset()         { *m = Service_ClusterIstio{} }
func (m *Service_ClusterIstio) String() string { return proto.CompactTextString(m) }
func (*Service_ClusterIstio) ProtoMessage()    {}
func (*Service_ClusterIstio) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0, 3}
}

func (m *Service_ClusterIstio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service_ClusterIstio.Unmarshal(m, b)
}
func (m *Service_ClusterIstio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service_ClusterIstio.Marshal(b, m, deterministic)
}
func (m *Service_ClusterIstio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service_ClusterIstio.Merge(m, src)
}
func (m *Service_ClusterIstio) XXX_Size() int {
	return xxx_messageInfo_Service_ClusterIstio.Size(m)
}
func (m *Service_ClusterIstio) XXX_DiscardUnknown() {
	xxx_messageInfo_Service_ClusterIstio.DiscardUnknown(m)
}

var xxx_messageInfo_Service_ClusterIstio proto.InternalMessageInfo

func (m *Service_ClusterIstio) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Service_ClusterIstio) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Service_ClusterIstio) GetServiceNamespace() string {
	if m != nil {
		return m.ServiceNamespace
	}
	return ""
}

func (m *Service_ClusterIstio) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Configuration for how to query telemetry on a Service.
type Service_Telemetry struct {
	// The full name of the resource that defines this service. Formatted as
	// described in https://cloud.google.com/apis/design/resource_names.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Service_Telemetry) Reset()         { *m = Service_Telemetry{} }
func (m *Service_Telemetry) String() string { return proto.CompactTextString(m) }
func (*Service_Telemetry) ProtoMessage()    {}
func (*Service_Telemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{0, 4}
}

func (m *Service_Telemetry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service_Telemetry.Unmarshal(m, b)
}
func (m *Service_Telemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service_Telemetry.Marshal(b, m, deterministic)
}
func (m *Service_Telemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service_Telemetry.Merge(m, src)
}
func (m *Service_Telemetry) XXX_Size() int {
	return xxx_messageInfo_Service_Telemetry.Size(m)
}
func (m *Service_Telemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_Service_Telemetry.DiscardUnknown(m)
}

var xxx_messageInfo_Service_Telemetry proto.InternalMessageInfo

func (m *Service_Telemetry) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// A Service-Level Objective (SLO) describes a level of desired good service. It
// consists of a service-level indicator (SLI), a performance goal, and a period
// over which the objective is to be evaluated against that goal. The SLO can
// use SLIs defined in a number of different manners. Typical SLOs might include
// "99% of requests in each rolling week have latency below 200 milliseconds" or
// "99.5% of requests in each calendar month return successfully."
type ServiceLevelObjective struct {
	// Resource name for this `ServiceLevelObjective`.
	// Of the form
	// `projects/{project_id}/services/{service_id}/serviceLevelObjectives/{slo_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name used for UI elements listing this SLO.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The definition of good service, used to measure and calculate the quality
	// of the `Service`'s performance with respect to a single aspect of service
	// quality.
	ServiceLevelIndicator *ServiceLevelIndicator `protobuf:"bytes,3,opt,name=service_level_indicator,json=serviceLevelIndicator,proto3" json:"service_level_indicator,omitempty"`
	// The fraction of service that must be good in order for this objective to be
	// met. `0 < goal <= 0.999`.
	Goal float64 `protobuf:"fixed64,4,opt,name=goal,proto3" json:"goal,omitempty"`
	// The time period over which the objective will be evaluated.
	//
	// Types that are valid to be assigned to Period:
	//	*ServiceLevelObjective_RollingPeriod
	//	*ServiceLevelObjective_CalendarPeriod
	Period               isServiceLevelObjective_Period `protobuf_oneof:"period"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ServiceLevelObjective) Reset()         { *m = ServiceLevelObjective{} }
func (m *ServiceLevelObjective) String() string { return proto.CompactTextString(m) }
func (*ServiceLevelObjective) ProtoMessage()    {}
func (*ServiceLevelObjective) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{1}
}

func (m *ServiceLevelObjective) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceLevelObjective.Unmarshal(m, b)
}
func (m *ServiceLevelObjective) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceLevelObjective.Marshal(b, m, deterministic)
}
func (m *ServiceLevelObjective) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceLevelObjective.Merge(m, src)
}
func (m *ServiceLevelObjective) XXX_Size() int {
	return xxx_messageInfo_ServiceLevelObjective.Size(m)
}
func (m *ServiceLevelObjective) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceLevelObjective.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceLevelObjective proto.InternalMessageInfo

func (m *ServiceLevelObjective) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceLevelObjective) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ServiceLevelObjective) GetServiceLevelIndicator() *ServiceLevelIndicator {
	if m != nil {
		return m.ServiceLevelIndicator
	}
	return nil
}

func (m *ServiceLevelObjective) GetGoal() float64 {
	if m != nil {
		return m.Goal
	}
	return 0
}

type isServiceLevelObjective_Period interface {
	isServiceLevelObjective_Period()
}

type ServiceLevelObjective_RollingPeriod struct {
	RollingPeriod *duration.Duration `protobuf:"bytes,5,opt,name=rolling_period,json=rollingPeriod,proto3,oneof"`
}

type ServiceLevelObjective_CalendarPeriod struct {
	CalendarPeriod calendarperiod.CalendarPeriod `protobuf:"varint,6,opt,name=calendar_period,json=calendarPeriod,proto3,enum=google.type.CalendarPeriod,oneof"`
}

func (*ServiceLevelObjective_RollingPeriod) isServiceLevelObjective_Period() {}

func (*ServiceLevelObjective_CalendarPeriod) isServiceLevelObjective_Period() {}

func (m *ServiceLevelObjective) GetPeriod() isServiceLevelObjective_Period {
	if m != nil {
		return m.Period
	}
	return nil
}

func (m *ServiceLevelObjective) GetRollingPeriod() *duration.Duration {
	if x, ok := m.GetPeriod().(*ServiceLevelObjective_RollingPeriod); ok {
		return x.RollingPeriod
	}
	return nil
}

func (m *ServiceLevelObjective) GetCalendarPeriod() calendarperiod.CalendarPeriod {
	if x, ok := m.GetPeriod().(*ServiceLevelObjective_CalendarPeriod); ok {
		return x.CalendarPeriod
	}
	return calendarperiod.CalendarPeriod_CALENDAR_PERIOD_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ServiceLevelObjective) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ServiceLevelObjective_RollingPeriod)(nil),
		(*ServiceLevelObjective_CalendarPeriod)(nil),
	}
}

// A Service-Level Indicator (SLI) describes the "performance" of a service. For
// some services, the SLI is well-defined. In such cases, the SLI can be
// described easily by referencing the well-known SLI and providing the needed
// parameters. Alternatively, a "custom" SLI can be defined with a query to the
// underlying metric store. An SLI is defined to be `good_service /
// total_service` over any queried time interval. The value of performance
// always falls into the range `0 <= performance <= 1`. A custom SLI describes
// how to compute this ratio, whether this is by dividing values from a pair of
// time series, cutting a `Distribution` into good and bad counts, or counting
// time windows in which the service complies with a criterion. For separation
// of concerns, a single Service-Level Indicator measures performance for only
// one aspect of service quality, such as fraction of successful queries or
// fast-enough queries.
type ServiceLevelIndicator struct {
	// Service level indicators can be grouped by whether the "unit" of service
	// being measured is based on counts of good requests or on counts of good
	// time windows
	//
	// Types that are valid to be assigned to Type:
	//	*ServiceLevelIndicator_BasicSli
	//	*ServiceLevelIndicator_RequestBased
	//	*ServiceLevelIndicator_WindowsBased
	Type                 isServiceLevelIndicator_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ServiceLevelIndicator) Reset()         { *m = ServiceLevelIndicator{} }
func (m *ServiceLevelIndicator) String() string { return proto.CompactTextString(m) }
func (*ServiceLevelIndicator) ProtoMessage()    {}
func (*ServiceLevelIndicator) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{2}
}

func (m *ServiceLevelIndicator) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceLevelIndicator.Unmarshal(m, b)
}
func (m *ServiceLevelIndicator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceLevelIndicator.Marshal(b, m, deterministic)
}
func (m *ServiceLevelIndicator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceLevelIndicator.Merge(m, src)
}
func (m *ServiceLevelIndicator) XXX_Size() int {
	return xxx_messageInfo_ServiceLevelIndicator.Size(m)
}
func (m *ServiceLevelIndicator) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceLevelIndicator.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceLevelIndicator proto.InternalMessageInfo

type isServiceLevelIndicator_Type interface {
	isServiceLevelIndicator_Type()
}

type ServiceLevelIndicator_BasicSli struct {
	BasicSli *BasicSli `protobuf:"bytes,4,opt,name=basic_sli,json=basicSli,proto3,oneof"`
}

type ServiceLevelIndicator_RequestBased struct {
	RequestBased *RequestBasedSli `protobuf:"bytes,1,opt,name=request_based,json=requestBased,proto3,oneof"`
}

type ServiceLevelIndicator_WindowsBased struct {
	WindowsBased *WindowsBasedSli `protobuf:"bytes,2,opt,name=windows_based,json=windowsBased,proto3,oneof"`
}

func (*ServiceLevelIndicator_BasicSli) isServiceLevelIndicator_Type() {}

func (*ServiceLevelIndicator_RequestBased) isServiceLevelIndicator_Type() {}

func (*ServiceLevelIndicator_WindowsBased) isServiceLevelIndicator_Type() {}

func (m *ServiceLevelIndicator) GetType() isServiceLevelIndicator_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ServiceLevelIndicator) GetBasicSli() *BasicSli {
	if x, ok := m.GetType().(*ServiceLevelIndicator_BasicSli); ok {
		return x.BasicSli
	}
	return nil
}

func (m *ServiceLevelIndicator) GetRequestBased() *RequestBasedSli {
	if x, ok := m.GetType().(*ServiceLevelIndicator_RequestBased); ok {
		return x.RequestBased
	}
	return nil
}

func (m *ServiceLevelIndicator) GetWindowsBased() *WindowsBasedSli {
	if x, ok := m.GetType().(*ServiceLevelIndicator_WindowsBased); ok {
		return x.WindowsBased
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ServiceLevelIndicator) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ServiceLevelIndicator_BasicSli)(nil),
		(*ServiceLevelIndicator_RequestBased)(nil),
		(*ServiceLevelIndicator_WindowsBased)(nil),
	}
}

// An SLI measuring performance on a well-known service type. Performance will
// be computed on the basis of pre-defined metrics. The type of the
// `service_resource` determines the metrics to use and the
// `service_resource.labels` and `metric_labels` are used to construct a
// monitoring filter to filter that metric down to just the data relevant to
// this service.
type BasicSli struct {
	// OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
	// other methods will not be used to calculate performance for this SLI. If
	// omitted, this SLI applies to all the Service's methods. For service types
	// that don't support breaking down by method, setting this field will result
	// in an error.
	Method []string `protobuf:"bytes,7,rep,name=method,proto3" json:"method,omitempty"`
	// OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
	// from other locations will not be used to calculate performance for this
	// SLI. If omitted, this SLI applies to all locations in which the Service has
	// activity. For service types that don't support breaking down by location,
	// setting this field will result in an error.
	Location []string `protobuf:"bytes,8,rep,name=location,proto3" json:"location,omitempty"`
	// OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
	// from other API versions will not be used to calculate performance for this
	// SLI. If omitted, this SLI applies to all API versions. For service types
	// that don't support breaking down by version, setting this field will result
	// in an error.
	Version []string `protobuf:"bytes,9,rep,name=version,proto3" json:"version,omitempty"`
	// This SLI can be evaluated on the basis of availability or latency.
	//
	// Types that are valid to be assigned to SliCriteria:
	//	*BasicSli_Availability
	//	*BasicSli_Latency
	SliCriteria          isBasicSli_SliCriteria `protobuf_oneof:"sli_criteria"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *BasicSli) Reset()         { *m = BasicSli{} }
func (m *BasicSli) String() string { return proto.CompactTextString(m) }
func (*BasicSli) ProtoMessage()    {}
func (*BasicSli) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{3}
}

func (m *BasicSli) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicSli.Unmarshal(m, b)
}
func (m *BasicSli) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicSli.Marshal(b, m, deterministic)
}
func (m *BasicSli) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicSli.Merge(m, src)
}
func (m *BasicSli) XXX_Size() int {
	return xxx_messageInfo_BasicSli.Size(m)
}
func (m *BasicSli) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicSli.DiscardUnknown(m)
}

var xxx_messageInfo_BasicSli proto.InternalMessageInfo

func (m *BasicSli) GetMethod() []string {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *BasicSli) GetLocation() []string {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *BasicSli) GetVersion() []string {
	if m != nil {
		return m.Version
	}
	return nil
}

type isBasicSli_SliCriteria interface {
	isBasicSli_SliCriteria()
}

type BasicSli_Availability struct {
	Availability *BasicSli_AvailabilityCriteria `protobuf:"bytes,2,opt,name=availability,proto3,oneof"`
}

type BasicSli_Latency struct {
	Latency *BasicSli_LatencyCriteria `protobuf:"bytes,3,opt,name=latency,proto3,oneof"`
}

func (*BasicSli_Availability) isBasicSli_SliCriteria() {}

func (*BasicSli_Latency) isBasicSli_SliCriteria() {}

func (m *BasicSli) GetSliCriteria() isBasicSli_SliCriteria {
	if m != nil {
		return m.SliCriteria
	}
	return nil
}

func (m *BasicSli) GetAvailability() *BasicSli_AvailabilityCriteria {
	if x, ok := m.GetSliCriteria().(*BasicSli_Availability); ok {
		return x.Availability
	}
	return nil
}

func (m *BasicSli) GetLatency() *BasicSli_LatencyCriteria {
	if x, ok := m.GetSliCriteria().(*BasicSli_Latency); ok {
		return x.Latency
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BasicSli) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BasicSli_Availability)(nil),
		(*BasicSli_Latency)(nil),
	}
}

// Future parameters for the availability SLI.
type BasicSli_AvailabilityCriteria struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BasicSli_AvailabilityCriteria) Reset()         { *m = BasicSli_AvailabilityCriteria{} }
func (m *BasicSli_AvailabilityCriteria) String() string { return proto.CompactTextString(m) }
func (*BasicSli_AvailabilityCriteria) ProtoMessage()    {}
func (*BasicSli_AvailabilityCriteria) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{3, 0}
}

func (m *BasicSli_AvailabilityCriteria) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicSli_AvailabilityCriteria.Unmarshal(m, b)
}
func (m *BasicSli_AvailabilityCriteria) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicSli_AvailabilityCriteria.Marshal(b, m, deterministic)
}
func (m *BasicSli_AvailabilityCriteria) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicSli_AvailabilityCriteria.Merge(m, src)
}
func (m *BasicSli_AvailabilityCriteria) XXX_Size() int {
	return xxx_messageInfo_BasicSli_AvailabilityCriteria.Size(m)
}
func (m *BasicSli_AvailabilityCriteria) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicSli_AvailabilityCriteria.DiscardUnknown(m)
}

var xxx_messageInfo_BasicSli_AvailabilityCriteria proto.InternalMessageInfo

// Parameters for a latency threshold SLI.
type BasicSli_LatencyCriteria struct {
	// Good service is defined to be the count of requests made to this service
	// that return in no more than `threshold`.
	Threshold            *duration.Duration `protobuf:"bytes,3,opt,name=threshold,proto3" json:"threshold,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BasicSli_LatencyCriteria) Reset()         { *m = BasicSli_LatencyCriteria{} }
func (m *BasicSli_LatencyCriteria) String() string { return proto.CompactTextString(m) }
func (*BasicSli_LatencyCriteria) ProtoMessage()    {}
func (*BasicSli_LatencyCriteria) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{3, 1}
}

func (m *BasicSli_LatencyCriteria) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicSli_LatencyCriteria.Unmarshal(m, b)
}
func (m *BasicSli_LatencyCriteria) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicSli_LatencyCriteria.Marshal(b, m, deterministic)
}
func (m *BasicSli_LatencyCriteria) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicSli_LatencyCriteria.Merge(m, src)
}
func (m *BasicSli_LatencyCriteria) XXX_Size() int {
	return xxx_messageInfo_BasicSli_LatencyCriteria.Size(m)
}
func (m *BasicSli_LatencyCriteria) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicSli_LatencyCriteria.DiscardUnknown(m)
}

var xxx_messageInfo_BasicSli_LatencyCriteria proto.InternalMessageInfo

func (m *BasicSli_LatencyCriteria) GetThreshold() *duration.Duration {
	if m != nil {
		return m.Threshold
	}
	return nil
}

// Range of numerical values, inclusive of `min` and exclusive of `max`. If the
// open range "< range.max" is desired, set `range.min = -infinity`. If the open
// range ">= range.min" is desired, set `range.max = infinity`.
type Range struct {
	// Range minimum.
	Min float64 `protobuf:"fixed64,1,opt,name=min,proto3" json:"min,omitempty"`
	// Range maximum.
	Max                  float64  `protobuf:"fixed64,2,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Range) Reset()         { *m = Range{} }
func (m *Range) String() string { return proto.CompactTextString(m) }
func (*Range) ProtoMessage()    {}
func (*Range) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{4}
}

func (m *Range) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Range.Unmarshal(m, b)
}
func (m *Range) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Range.Marshal(b, m, deterministic)
}
func (m *Range) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Range.Merge(m, src)
}
func (m *Range) XXX_Size() int {
	return xxx_messageInfo_Range.Size(m)
}
func (m *Range) XXX_DiscardUnknown() {
	xxx_messageInfo_Range.DiscardUnknown(m)
}

var xxx_messageInfo_Range proto.InternalMessageInfo

func (m *Range) GetMin() float64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Range) GetMax() float64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// Service Level Indicators for which atomic units of service are counted
// directly.
type RequestBasedSli struct {
	// The means to compute a ratio of `good_service` to `total_service`.
	//
	// Types that are valid to be assigned to Method:
	//	*RequestBasedSli_GoodTotalRatio
	//	*RequestBasedSli_DistributionCut
	Method               isRequestBasedSli_Method `protobuf_oneof:"method"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *RequestBasedSli) Reset()         { *m = RequestBasedSli{} }
func (m *RequestBasedSli) String() string { return proto.CompactTextString(m) }
func (*RequestBasedSli) ProtoMessage()    {}
func (*RequestBasedSli) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{5}
}

func (m *RequestBasedSli) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestBasedSli.Unmarshal(m, b)
}
func (m *RequestBasedSli) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestBasedSli.Marshal(b, m, deterministic)
}
func (m *RequestBasedSli) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestBasedSli.Merge(m, src)
}
func (m *RequestBasedSli) XXX_Size() int {
	return xxx_messageInfo_RequestBasedSli.Size(m)
}
func (m *RequestBasedSli) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestBasedSli.DiscardUnknown(m)
}

var xxx_messageInfo_RequestBasedSli proto.InternalMessageInfo

type isRequestBasedSli_Method interface {
	isRequestBasedSli_Method()
}

type RequestBasedSli_GoodTotalRatio struct {
	GoodTotalRatio *TimeSeriesRatio `protobuf:"bytes,1,opt,name=good_total_ratio,json=goodTotalRatio,proto3,oneof"`
}

type RequestBasedSli_DistributionCut struct {
	DistributionCut *DistributionCut `protobuf:"bytes,3,opt,name=distribution_cut,json=distributionCut,proto3,oneof"`
}

func (*RequestBasedSli_GoodTotalRatio) isRequestBasedSli_Method() {}

func (*RequestBasedSli_DistributionCut) isRequestBasedSli_Method() {}

func (m *RequestBasedSli) GetMethod() isRequestBasedSli_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *RequestBasedSli) GetGoodTotalRatio() *TimeSeriesRatio {
	if x, ok := m.GetMethod().(*RequestBasedSli_GoodTotalRatio); ok {
		return x.GoodTotalRatio
	}
	return nil
}

func (m *RequestBasedSli) GetDistributionCut() *DistributionCut {
	if x, ok := m.GetMethod().(*RequestBasedSli_DistributionCut); ok {
		return x.DistributionCut
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RequestBasedSli) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RequestBasedSli_GoodTotalRatio)(nil),
		(*RequestBasedSli_DistributionCut)(nil),
	}
}

// A `TimeSeriesRatio` specifies two `TimeSeries` to use for computing the
// `good_service / total_service` ratio. The specified `TimeSeries` must have
// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
// DELTA` or `MetricKind = CUMULATIVE`. The `TimeSeriesRatio` must specify
// exactly two of good, bad, and total, and the relationship `good_service +
// bad_service = total_service` will be assumed.
type TimeSeriesRatio struct {
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying good service provided. Must have
	// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
	// DELTA` or `MetricKind = CUMULATIVE`.
	GoodServiceFilter string `protobuf:"bytes,4,opt,name=good_service_filter,json=goodServiceFilter,proto3" json:"good_service_filter,omitempty"`
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying bad service, either demanded service
	// that was not provided or demanded service that was of inadequate quality.
	// Must have `ValueType = DOUBLE` or `ValueType = INT64` and must have
	// `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
	BadServiceFilter string `protobuf:"bytes,5,opt,name=bad_service_filter,json=badServiceFilter,proto3" json:"bad_service_filter,omitempty"`
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying total demanded service. Must have
	// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
	// DELTA` or `MetricKind = CUMULATIVE`.
	TotalServiceFilter   string   `protobuf:"bytes,6,opt,name=total_service_filter,json=totalServiceFilter,proto3" json:"total_service_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeSeriesRatio) Reset()         { *m = TimeSeriesRatio{} }
func (m *TimeSeriesRatio) String() string { return proto.CompactTextString(m) }
func (*TimeSeriesRatio) ProtoMessage()    {}
func (*TimeSeriesRatio) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{6}
}

func (m *TimeSeriesRatio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeSeriesRatio.Unmarshal(m, b)
}
func (m *TimeSeriesRatio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeSeriesRatio.Marshal(b, m, deterministic)
}
func (m *TimeSeriesRatio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSeriesRatio.Merge(m, src)
}
func (m *TimeSeriesRatio) XXX_Size() int {
	return xxx_messageInfo_TimeSeriesRatio.Size(m)
}
func (m *TimeSeriesRatio) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSeriesRatio.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSeriesRatio proto.InternalMessageInfo

func (m *TimeSeriesRatio) GetGoodServiceFilter() string {
	if m != nil {
		return m.GoodServiceFilter
	}
	return ""
}

func (m *TimeSeriesRatio) GetBadServiceFilter() string {
	if m != nil {
		return m.BadServiceFilter
	}
	return ""
}

func (m *TimeSeriesRatio) GetTotalServiceFilter() string {
	if m != nil {
		return m.TotalServiceFilter
	}
	return ""
}

// A `DistributionCut` defines a `TimeSeries` and thresholds used for measuring
// good service and total service. The `TimeSeries` must have `ValueType =
// DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`. The
// computed `good_service` will be the count of values x in the `Distribution`
// such that `range.min <= x < range.max`.
type DistributionCut struct {
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` aggregating values. Must have `ValueType =
	// DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
	DistributionFilter string `protobuf:"bytes,4,opt,name=distribution_filter,json=distributionFilter,proto3" json:"distribution_filter,omitempty"`
	// Range of values considered "good." For a one-sided range, set one bound to
	// an infinite value.
	Range                *Range   `protobuf:"bytes,5,opt,name=range,proto3" json:"range,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DistributionCut) Reset()         { *m = DistributionCut{} }
func (m *DistributionCut) String() string { return proto.CompactTextString(m) }
func (*DistributionCut) ProtoMessage()    {}
func (*DistributionCut) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{7}
}

func (m *DistributionCut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DistributionCut.Unmarshal(m, b)
}
func (m *DistributionCut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DistributionCut.Marshal(b, m, deterministic)
}
func (m *DistributionCut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DistributionCut.Merge(m, src)
}
func (m *DistributionCut) XXX_Size() int {
	return xxx_messageInfo_DistributionCut.Size(m)
}
func (m *DistributionCut) XXX_DiscardUnknown() {
	xxx_messageInfo_DistributionCut.DiscardUnknown(m)
}

var xxx_messageInfo_DistributionCut proto.InternalMessageInfo

func (m *DistributionCut) GetDistributionFilter() string {
	if m != nil {
		return m.DistributionFilter
	}
	return ""
}

func (m *DistributionCut) GetRange() *Range {
	if m != nil {
		return m.Range
	}
	return nil
}

// A `WindowsBasedSli` defines `good_service` as the count of time windows for
// which the provided service was of good quality. Criteria for determining
// if service was good are embedded in the `window_criterion`.
type WindowsBasedSli struct {
	// The criterion to use for evaluating window goodness.
	//
	// Types that are valid to be assigned to WindowCriterion:
	//	*WindowsBasedSli_GoodBadMetricFilter
	//	*WindowsBasedSli_GoodTotalRatioThreshold
	//	*WindowsBasedSli_MetricMeanInRange
	//	*WindowsBasedSli_MetricSumInRange
	WindowCriterion isWindowsBasedSli_WindowCriterion `protobuf_oneof:"window_criterion"`
	// Duration over which window quality is evaluated. Must be an integer
	// fraction of a day and at least `60s`.
	WindowPeriod         *duration.Duration `protobuf:"bytes,4,opt,name=window_period,json=windowPeriod,proto3" json:"window_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *WindowsBasedSli) Reset()         { *m = WindowsBasedSli{} }
func (m *WindowsBasedSli) String() string { return proto.CompactTextString(m) }
func (*WindowsBasedSli) ProtoMessage()    {}
func (*WindowsBasedSli) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{8}
}

func (m *WindowsBasedSli) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsBasedSli.Unmarshal(m, b)
}
func (m *WindowsBasedSli) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsBasedSli.Marshal(b, m, deterministic)
}
func (m *WindowsBasedSli) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsBasedSli.Merge(m, src)
}
func (m *WindowsBasedSli) XXX_Size() int {
	return xxx_messageInfo_WindowsBasedSli.Size(m)
}
func (m *WindowsBasedSli) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsBasedSli.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsBasedSli proto.InternalMessageInfo

type isWindowsBasedSli_WindowCriterion interface {
	isWindowsBasedSli_WindowCriterion()
}

type WindowsBasedSli_GoodBadMetricFilter struct {
	GoodBadMetricFilter string `protobuf:"bytes,5,opt,name=good_bad_metric_filter,json=goodBadMetricFilter,proto3,oneof"`
}

type WindowsBasedSli_GoodTotalRatioThreshold struct {
	GoodTotalRatioThreshold *WindowsBasedSli_PerformanceThreshold `protobuf:"bytes,2,opt,name=good_total_ratio_threshold,json=goodTotalRatioThreshold,proto3,oneof"`
}

type WindowsBasedSli_MetricMeanInRange struct {
	MetricMeanInRange *WindowsBasedSli_MetricRange `protobuf:"bytes,6,opt,name=metric_mean_in_range,json=metricMeanInRange,proto3,oneof"`
}

type WindowsBasedSli_MetricSumInRange struct {
	MetricSumInRange *WindowsBasedSli_MetricRange `protobuf:"bytes,7,opt,name=metric_sum_in_range,json=metricSumInRange,proto3,oneof"`
}

func (*WindowsBasedSli_GoodBadMetricFilter) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_GoodTotalRatioThreshold) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_MetricMeanInRange) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_MetricSumInRange) isWindowsBasedSli_WindowCriterion() {}

func (m *WindowsBasedSli) GetWindowCriterion() isWindowsBasedSli_WindowCriterion {
	if m != nil {
		return m.WindowCriterion
	}
	return nil
}

func (m *WindowsBasedSli) GetGoodBadMetricFilter() string {
	if x, ok := m.GetWindowCriterion().(*WindowsBasedSli_GoodBadMetricFilter); ok {
		return x.GoodBadMetricFilter
	}
	return ""
}

func (m *WindowsBasedSli) GetGoodTotalRatioThreshold() *WindowsBasedSli_PerformanceThreshold {
	if x, ok := m.GetWindowCriterion().(*WindowsBasedSli_GoodTotalRatioThreshold); ok {
		return x.GoodTotalRatioThreshold
	}
	return nil
}

func (m *WindowsBasedSli) GetMetricMeanInRange() *WindowsBasedSli_MetricRange {
	if x, ok := m.GetWindowCriterion().(*WindowsBasedSli_MetricMeanInRange); ok {
		return x.MetricMeanInRange
	}
	return nil
}

func (m *WindowsBasedSli) GetMetricSumInRange() *WindowsBasedSli_MetricRange {
	if x, ok := m.GetWindowCriterion().(*WindowsBasedSli_MetricSumInRange); ok {
		return x.MetricSumInRange
	}
	return nil
}

func (m *WindowsBasedSli) GetWindowPeriod() *duration.Duration {
	if m != nil {
		return m.WindowPeriod
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*WindowsBasedSli) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*WindowsBasedSli_GoodBadMetricFilter)(nil),
		(*WindowsBasedSli_GoodTotalRatioThreshold)(nil),
		(*WindowsBasedSli_MetricMeanInRange)(nil),
		(*WindowsBasedSli_MetricSumInRange)(nil),
	}
}

// A `PerformanceThreshold` is used when each window is good when that window
// has a sufficiently high `performance`.
type WindowsBasedSli_PerformanceThreshold struct {
	// The means, either a request-based SLI or a basic SLI, by which to compute
	// performance over a window.
	//
	// Types that are valid to be assigned to Type:
	//	*WindowsBasedSli_PerformanceThreshold_Performance
	//	*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance
	Type isWindowsBasedSli_PerformanceThreshold_Type `protobuf_oneof:"type"`
	// If window `performance >= threshold`, the window is counted as good.
	Threshold            float64  `protobuf:"fixed64,2,opt,name=threshold,proto3" json:"threshold,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsBasedSli_PerformanceThreshold) Reset()         { *m = WindowsBasedSli_PerformanceThreshold{} }
func (m *WindowsBasedSli_PerformanceThreshold) String() string { return proto.CompactTextString(m) }
func (*WindowsBasedSli_PerformanceThreshold) ProtoMessage()    {}
func (*WindowsBasedSli_PerformanceThreshold) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{8, 0}
}

func (m *WindowsBasedSli_PerformanceThreshold) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsBasedSli_PerformanceThreshold.Unmarshal(m, b)
}
func (m *WindowsBasedSli_PerformanceThreshold) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsBasedSli_PerformanceThreshold.Marshal(b, m, deterministic)
}
func (m *WindowsBasedSli_PerformanceThreshold) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsBasedSli_PerformanceThreshold.Merge(m, src)
}
func (m *WindowsBasedSli_PerformanceThreshold) XXX_Size() int {
	return xxx_messageInfo_WindowsBasedSli_PerformanceThreshold.Size(m)
}
func (m *WindowsBasedSli_PerformanceThreshold) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsBasedSli_PerformanceThreshold.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsBasedSli_PerformanceThreshold proto.InternalMessageInfo

type isWindowsBasedSli_PerformanceThreshold_Type interface {
	isWindowsBasedSli_PerformanceThreshold_Type()
}

type WindowsBasedSli_PerformanceThreshold_Performance struct {
	Performance *RequestBasedSli `protobuf:"bytes,1,opt,name=performance,proto3,oneof"`
}

type WindowsBasedSli_PerformanceThreshold_BasicSliPerformance struct {
	BasicSliPerformance *BasicSli `protobuf:"bytes,3,opt,name=basic_sli_performance,json=basicSliPerformance,proto3,oneof"`
}

func (*WindowsBasedSli_PerformanceThreshold_Performance) isWindowsBasedSli_PerformanceThreshold_Type() {
}

func (*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance) isWindowsBasedSli_PerformanceThreshold_Type() {
}

func (m *WindowsBasedSli_PerformanceThreshold) GetType() isWindowsBasedSli_PerformanceThreshold_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *WindowsBasedSli_PerformanceThreshold) GetPerformance() *RequestBasedSli {
	if x, ok := m.GetType().(*WindowsBasedSli_PerformanceThreshold_Performance); ok {
		return x.Performance
	}
	return nil
}

func (m *WindowsBasedSli_PerformanceThreshold) GetBasicSliPerformance() *BasicSli {
	if x, ok := m.GetType().(*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance); ok {
		return x.BasicSliPerformance
	}
	return nil
}

func (m *WindowsBasedSli_PerformanceThreshold) GetThreshold() float64 {
	if m != nil {
		return m.Threshold
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*WindowsBasedSli_PerformanceThreshold) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*WindowsBasedSli_PerformanceThreshold_Performance)(nil),
		(*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance)(nil),
	}
}

// A `MetricRange` is used when each window is good when the value x of a
// single `TimeSeries` satisfies `range.min <= x < range.max`. The provided
// `TimeSeries` must have `ValueType = INT64` or `ValueType = DOUBLE` and
// `MetricKind = GAUGE`.
type WindowsBasedSli_MetricRange struct {
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying the `TimeSeries` to use for evaluating window quality.
	TimeSeries string `protobuf:"bytes,1,opt,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
	// Range of values considered "good." For a one-sided range, set one bound
	// to an infinite value.
	Range                *Range   `protobuf:"bytes,4,opt,name=range,proto3" json:"range,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowsBasedSli_MetricRange) Reset()         { *m = WindowsBasedSli_MetricRange{} }
func (m *WindowsBasedSli_MetricRange) String() string { return proto.CompactTextString(m) }
func (*WindowsBasedSli_MetricRange) ProtoMessage()    {}
func (*WindowsBasedSli_MetricRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_72cc01277ee8f421, []int{8, 1}
}

func (m *WindowsBasedSli_MetricRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowsBasedSli_MetricRange.Unmarshal(m, b)
}
func (m *WindowsBasedSli_MetricRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowsBasedSli_MetricRange.Marshal(b, m, deterministic)
}
func (m *WindowsBasedSli_MetricRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowsBasedSli_MetricRange.Merge(m, src)
}
func (m *WindowsBasedSli_MetricRange) XXX_Size() int {
	return xxx_messageInfo_WindowsBasedSli_MetricRange.Size(m)
}
func (m *WindowsBasedSli_MetricRange) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowsBasedSli_MetricRange.DiscardUnknown(m)
}

var xxx_messageInfo_WindowsBasedSli_MetricRange proto.InternalMessageInfo

func (m *WindowsBasedSli_MetricRange) GetTimeSeries() string {
	if m != nil {
		return m.TimeSeries
	}
	return ""
}

func (m *WindowsBasedSli_MetricRange) GetRange() *Range {
	if m != nil {
		return m.Range
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.monitoring.v3.ServiceLevelObjective_View", ServiceLevelObjective_View_name, ServiceLevelObjective_View_value)
	proto.RegisterType((*Service)(nil), "google.monitoring.v3.Service")
	proto.RegisterType((*Service_Custom)(nil), "google.monitoring.v3.Service.Custom")
	proto.RegisterType((*Service_AppEngine)(nil), "google.monitoring.v3.Service.AppEngine")
	proto.RegisterType((*Service_CloudEndpoints)(nil), "google.monitoring.v3.Service.CloudEndpoints")
	proto.RegisterType((*Service_ClusterIstio)(nil), "google.monitoring.v3.Service.ClusterIstio")
	proto.RegisterType((*Service_Telemetry)(nil), "google.monitoring.v3.Service.Telemetry")
	proto.RegisterType((*ServiceLevelObjective)(nil), "google.monitoring.v3.ServiceLevelObjective")
	proto.RegisterType((*ServiceLevelIndicator)(nil), "google.monitoring.v3.ServiceLevelIndicator")
	proto.RegisterType((*BasicSli)(nil), "google.monitoring.v3.BasicSli")
	proto.RegisterType((*BasicSli_AvailabilityCriteria)(nil), "google.monitoring.v3.BasicSli.AvailabilityCriteria")
	proto.RegisterType((*BasicSli_LatencyCriteria)(nil), "google.monitoring.v3.BasicSli.LatencyCriteria")
	proto.RegisterType((*Range)(nil), "google.monitoring.v3.Range")
	proto.RegisterType((*RequestBasedSli)(nil), "google.monitoring.v3.RequestBasedSli")
	proto.RegisterType((*TimeSeriesRatio)(nil), "google.monitoring.v3.TimeSeriesRatio")
	proto.RegisterType((*DistributionCut)(nil), "google.monitoring.v3.DistributionCut")
	proto.RegisterType((*WindowsBasedSli)(nil), "google.monitoring.v3.WindowsBasedSli")
	proto.RegisterType((*WindowsBasedSli_PerformanceThreshold)(nil), "google.monitoring.v3.WindowsBasedSli.PerformanceThreshold")
	proto.RegisterType((*WindowsBasedSli_MetricRange)(nil), "google.monitoring.v3.WindowsBasedSli.MetricRange")
}

func init() { proto.RegisterFile("google/monitoring/v3/service.proto", fileDescriptor_72cc01277ee8f421) }

var fileDescriptor_72cc01277ee8f421 = []byte{
	// 1367 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x5b, 0x6f, 0x1b, 0xc5,
	0x17, 0xb7, 0x73, 0xf1, 0xe5, 0xd8, 0x89, 0xdd, 0x49, 0x9a, 0xfa, 0xbf, 0xfd, 0xab, 0x17, 0x17,
	0x44, 0xd4, 0x56, 0xeb, 0x36, 0x01, 0x21, 0x81, 0xa8, 0x54, 0xa7, 0x0e, 0x76, 0x95, 0x96, 0x74,
	0x93, 0xa6, 0x80, 0x2a, 0xad, 0xc6, 0xbb, 0x13, 0x77, 0xd0, 0xee, 0xce, 0xb2, 0x3b, 0xeb, 0x34,
	0x9f, 0x83, 0x67, 0x1e, 0x90, 0x78, 0xe2, 0x81, 0x0f, 0xc1, 0x23, 0xdf, 0x81, 0x4f, 0xc1, 0x1b,
	0x12, 0x12, 0x9a, 0x5b, 0xbc, 0x76, 0xdd, 0x24, 0xf0, 0xb6, 0x73, 0xce, 0xef, 0xfc, 0xce, 0x65,
	0xce, 0x39, 0x63, 0x43, 0x7b, 0xc4, 0xd8, 0x28, 0x20, 0x9d, 0x90, 0x45, 0x94, 0xb3, 0x84, 0x46,
	0xa3, 0xce, 0x78, 0xbb, 0x93, 0x92, 0x64, 0x4c, 0x3d, 0x62, 0xc7, 0x09, 0xe3, 0x0c, 0xad, 0x2b,
	0x8c, 0x3d, 0xc1, 0xd8, 0xe3, 0x6d, 0xeb, 0x8e, 0xb6, 0xc4, 0x31, 0x35, 0xd6, 0xc4, 0x77, 0x13,
	0x92, 0xb2, 0x2c, 0x31, 0xa6, 0xd6, 0x0d, 0x0d, 0x92, 0xa7, 0x61, 0x76, 0xdc, 0xf1, 0xb3, 0x04,
	0x73, 0xca, 0x22, 0xad, 0xbf, 0x39, 0xab, 0xe7, 0x34, 0x24, 0x29, 0xc7, 0x61, 0xac, 0x01, 0xb7,
	0x35, 0x80, 0x9f, 0xc6, 0xa4, 0xe3, 0xe1, 0x80, 0x44, 0x3e, 0x4e, 0xdc, 0x98, 0x24, 0x94, 0xf9,
	0x0a, 0xd2, 0xfe, 0x7b, 0x19, 0xca, 0x07, 0x2a, 0x60, 0x84, 0x60, 0x29, 0xc2, 0x21, 0x69, 0x15,
	0x6f, 0x15, 0x37, 0xab, 0x8e, 0xfc, 0x46, 0xb7, 0xa1, 0xee, 0xd3, 0x34, 0x0e, 0xf0, 0xa9, 0x2b,
	0x75, 0x0b, 0x52, 0x57, 0xd3, 0xb2, 0xe7, 0x02, 0xf2, 0x08, 0x4a, 0x5e, 0x96, 0x72, 0x16, 0xb6,
	0x4a, 0xb7, 0x8a, 0x9b, 0xb5, 0xad, 0x0f, 0xec, 0x79, 0x29, 0xdb, 0xda, 0x8b, 0xbd, 0x23, 0xb1,
	0xfd, 0x82, 0xa3, 0xad, 0x50, 0x1f, 0x00, 0xc7, 0xb1, 0x4b, 0xa2, 0x11, 0x8d, 0x48, 0xab, 0x2c,
	0x39, 0x3e, 0x3a, 0x9f, 0xe3, 0x71, 0x1c, 0xf7, 0x24, 0xbc, 0x5f, 0x70, 0xaa, 0xd8, 0x1c, 0xd0,
	0x2b, 0x68, 0x78, 0x01, 0xcb, 0x7c, 0x97, 0x44, 0x7e, 0xcc, 0x68, 0xc4, 0xd3, 0x56, 0x45, 0xd2,
	0xdd, 0xbf, 0x20, 0x24, 0x61, 0xd4, 0x33, 0x36, 0xfd, 0x82, 0xb3, 0xea, 0x4d, 0x49, 0xd0, 0x0b,
	0x58, 0xf1, 0x82, 0x2c, 0xe5, 0x24, 0x71, 0x69, 0xca, 0x29, 0x6b, 0x55, 0x25, 0xed, 0xdd, 0x8b,
	0x68, 0xa5, 0xc9, 0x40, 0x58, 0xf4, 0x0b, 0x4e, 0xdd, 0xcb, 0x9d, 0x51, 0x0f, 0xaa, 0x9c, 0x04,
	0x24, 0x24, 0x3c, 0x39, 0x6d, 0xad, 0x5c, 0x26, 0xe9, 0x43, 0x03, 0x77, 0x26, 0x96, 0x56, 0x05,
	0x4a, 0xaa, 0xa0, 0xd6, 0x26, 0x54, 0xcf, 0xca, 0x82, 0xae, 0x43, 0x35, 0x64, 0x7e, 0x16, 0x10,
	0x97, 0xfa, 0xfa, 0x3e, 0x2b, 0x4a, 0x30, 0xf0, 0xad, 0xbb, 0xb0, 0x3a, 0x9d, 0x31, 0x6a, 0x41,
	0x59, 0x77, 0xad, 0x06, 0x9b, 0xa3, 0xf5, 0x63, 0x11, 0xea, 0xf9, 0x3c, 0x90, 0x05, 0x95, 0x80,
	0x79, 0xb2, 0x0d, 0x0d, 0xb1, 0x39, 0x8b, 0x66, 0x31, 0x65, 0xca, 0x37, 0x8b, 0x96, 0xc9, 0x66,
	0xb9, 0x07, 0x57, 0x34, 0xb5, 0x84, 0xa4, 0x31, 0xf6, 0x48, 0x6b, 0x51, 0xe2, 0x9a, 0x5a, 0xf1,
	0xdc, 0xc8, 0x05, 0x5f, 0x1e, 0xdc, 0x5a, 0x52, 0x7c, 0x39, 0x9c, 0xf5, 0x00, 0xaa, 0x67, 0x75,
	0x41, 0x77, 0x60, 0xc5, 0x8c, 0x90, 0x9b, 0xeb, 0xe4, 0xba, 0x11, 0x0a, 0x8b, 0x6e, 0x1d, 0x80,
	0xfa, 0x24, 0xe2, 0xf4, 0x98, 0x92, 0xa4, 0xfd, 0xc3, 0x22, 0x5c, 0xd5, 0x05, 0xde, 0x23, 0x63,
	0x12, 0x7c, 0x35, 0xfc, 0x8e, 0x78, 0x9c, 0x8e, 0x2f, 0x37, 0x0d, 0xb5, 0x77, 0xa7, 0xc1, 0x83,
	0x6b, 0x26, 0xe6, 0x40, 0x10, 0xba, 0x34, 0xf2, 0xa9, 0x87, 0x39, 0x4b, 0x64, 0x9a, 0xb5, 0xad,
	0x7b, 0xe7, 0xde, 0xb2, 0x0c, 0x62, 0x60, 0x4c, 0x9c, 0xab, 0xe9, 0x3c, 0xb1, 0x88, 0x6d, 0xc4,
	0x70, 0x20, 0x0b, 0x52, 0x74, 0xe4, 0x37, 0xea, 0xc2, 0x6a, 0xc2, 0x82, 0x80, 0x46, 0x23, 0x3d,
	0xe1, 0xad, 0x65, 0xe9, 0xef, 0x7f, 0xc6, 0x9f, 0x59, 0x13, 0xf6, 0x13, 0xbd, 0x46, 0xfa, 0x05,
	0x67, 0x45, 0x9b, 0xec, 0x4b, 0x0b, 0xb4, 0x0b, 0x8d, 0x99, 0x35, 0x21, 0x67, 0x7a, 0x75, 0xeb,
	0xba, 0x21, 0x11, 0xab, 0xc4, 0xde, 0xd1, 0x18, 0x65, 0x25, 0xe7, 0x65, 0x4a, 0xd2, 0xfe, 0x18,
	0x96, 0x8e, 0x28, 0x39, 0x41, 0xeb, 0xd0, 0x3c, 0x1a, 0xf4, 0x5e, 0xb9, 0x2f, 0x9f, 0x1f, 0xec,
	0xf7, 0x76, 0x06, 0xbb, 0x83, 0xde, 0x93, 0x66, 0x01, 0x55, 0x60, 0x69, 0xf7, 0xe5, 0xde, 0x5e,
	0x73, 0x01, 0xd5, 0xa1, 0xd2, 0xfb, 0x7a, 0x7f, 0x6f, 0xb0, 0x33, 0x38, 0x6c, 0x16, 0xbb, 0x15,
	0x28, 0x29, 0xa7, 0xed, 0xbf, 0x8a, 0xd3, 0xb7, 0x32, 0xc9, 0xfc, 0x0b, 0xa8, 0x0e, 0x71, 0x4a,
	0x3d, 0x37, 0x0d, 0xa8, 0x4c, 0xbf, 0xb6, 0x75, 0x63, 0x7e, 0x41, 0xbb, 0x02, 0x76, 0x10, 0xd0,
	0x7e, 0xc1, 0xa9, 0x0c, 0xf5, 0x37, 0xda, 0x13, 0x1d, 0xf2, 0x7d, 0x46, 0x52, 0xee, 0x0e, 0x71,
	0x4a, 0xd4, 0x6c, 0xd4, 0xb6, 0x3e, 0x9c, 0x4f, 0xe1, 0x28, 0x68, 0x57, 0x20, 0x15, 0x53, 0x3d,
	0xc9, 0x89, 0x04, 0xdb, 0x09, 0x8d, 0x7c, 0x76, 0x92, 0x6a, 0xb6, 0x85, 0xf3, 0xd8, 0x5e, 0x29,
	0x68, 0x9e, 0xed, 0x24, 0x27, 0xea, 0x96, 0x60, 0x49, 0x54, 0xb7, 0xfd, 0xe7, 0x02, 0x54, 0x4c,
	0xf0, 0x68, 0x03, 0x4a, 0x21, 0xe1, 0x6f, 0x98, 0xdf, 0x2a, 0xdf, 0x5a, 0xdc, 0xac, 0x3a, 0xfa,
	0x34, 0x35, 0x86, 0x15, 0xa9, 0x99, 0x8c, 0x61, 0x0b, 0xca, 0x63, 0x92, 0xa4, 0x42, 0x55, 0x95,
	0x2a, 0x73, 0x44, 0xdf, 0x40, 0x1d, 0x8f, 0x31, 0x0d, 0xf0, 0x90, 0x06, 0x94, 0x9f, 0xea, 0x78,
	0xb7, 0xcf, 0x2f, 0xa0, 0xfd, 0x38, 0x67, 0xb2, 0x93, 0x50, 0x4e, 0x12, 0x8a, 0x45, 0xf4, 0x79,
	0x2a, 0xf4, 0x14, 0xca, 0x01, 0xe6, 0x24, 0xf2, 0x4e, 0x75, 0x9f, 0xdb, 0x17, 0xb0, 0xee, 0x29,
	0x74, 0x8e, 0xd0, 0x10, 0x58, 0x1b, 0xb0, 0x3e, 0xcf, 0xa7, 0xf5, 0x14, 0x1a, 0x33, 0x56, 0xe8,
	0x53, 0xa8, 0xf2, 0x37, 0x09, 0x49, 0xdf, 0xb0, 0xc0, 0xd7, 0x8e, 0xdf, 0xdf, 0xf0, 0xce, 0x04,
	0xdb, 0x5d, 0x85, 0x7a, 0x1a, 0x50, 0xd7, 0xd3, 0x44, 0xed, 0x7b, 0xb0, 0xec, 0xe0, 0x68, 0x44,
	0x50, 0x13, 0x16, 0x43, 0xaa, 0x76, 0x5b, 0xd1, 0x11, 0x9f, 0x52, 0x82, 0xdf, 0xca, 0x62, 0x09,
	0x09, 0x7e, 0xdb, 0xfe, 0xad, 0x08, 0x8d, 0x99, 0xe6, 0x40, 0x2f, 0xa0, 0x39, 0x62, 0xcc, 0x77,
	0x39, 0xe3, 0x38, 0x70, 0xa5, 0xc3, 0xf3, 0xbb, 0xeb, 0x90, 0x86, 0xe4, 0x80, 0x24, 0x94, 0xa4,
	0x0e, 0x56, 0x2f, 0xc4, 0xaa, 0x20, 0x38, 0x14, 0xf6, 0x52, 0x82, 0x1c, 0x68, 0xfa, 0x34, 0xe5,
	0x09, 0x1d, 0x66, 0x22, 0x7c, 0xd7, 0xcb, 0xb8, 0xce, 0xf1, 0x3d, 0x94, 0x4f, 0x72, 0xe8, 0x9d,
	0x8c, 0xf7, 0x0b, 0x4e, 0xc3, 0x9f, 0x16, 0x89, 0x21, 0x53, 0x2d, 0xd4, 0xfe, 0xa9, 0x08, 0x8d,
	0x99, 0x18, 0x90, 0x0d, 0x6b, 0x32, 0x09, 0xb3, 0xc2, 0x8e, 0x69, 0xc0, 0x49, 0xa2, 0x17, 0xef,
	0x15, 0xa1, 0xd2, 0x63, 0xb9, 0x2b, 0x15, 0xe8, 0x3e, 0xa0, 0x21, 0x7e, 0x07, 0xbe, 0xac, 0xf6,
	0xf9, 0x10, 0xcf, 0xa0, 0x1f, 0xc0, 0xba, 0xaa, 0xce, 0x0c, 0xbe, 0x24, 0xf1, 0x48, 0xea, 0xa6,
	0x2c, 0xda, 0x19, 0x34, 0x66, 0x72, 0x42, 0x1d, 0x58, 0x9b, 0x2a, 0xca, 0x54, 0x88, 0x28, 0xaf,
	0xd2, 0x5e, 0x1f, 0xc2, 0x72, 0x22, 0x6e, 0x56, 0xef, 0xc3, 0xeb, 0xef, 0x99, 0x75, 0x01, 0x71,
	0x14, 0xb2, 0xfd, 0x73, 0x09, 0x1a, 0x33, 0xe3, 0x8a, 0x3e, 0x81, 0x0d, 0x59, 0x1a, 0x91, 0xaf,
	0x78, 0x6e, 0xa8, 0x37, 0x95, 0x6e, 0xbf, 0xe0, 0xc8, 0xd2, 0x75, 0xb1, 0xff, 0x4c, 0x6a, 0xb5,
	0xf7, 0x53, 0xb0, 0x66, 0xdb, 0xc2, 0x9d, 0x74, 0xac, 0x1a, 0xc0, 0xcf, 0x2e, 0xb5, 0x30, 0xec,
	0x7d, 0x92, 0x1c, 0xb3, 0x24, 0xc4, 0x91, 0x47, 0x0e, 0x0d, 0x43, 0xbf, 0xe0, 0x5c, 0x9b, 0xee,
	0x9a, 0x33, 0x15, 0xf2, 0x61, 0x5d, 0x07, 0x1a, 0x12, 0x1c, 0xb9, 0x34, 0x72, 0x55, 0x1d, 0xd4,
	0xcf, 0xb4, 0x87, 0x97, 0x73, 0xaa, 0x92, 0x91, 0xd5, 0xe9, 0x17, 0x9c, 0x2b, 0x8a, 0xf0, 0x19,
	0xc1, 0xd1, 0x20, 0x52, 0xf3, 0x32, 0x84, 0x35, 0xed, 0x25, 0xcd, 0xc2, 0x89, 0x93, 0xf2, 0x7f,
	0x77, 0xd2, 0x54, 0x7c, 0x07, 0x59, 0x68, 0x7c, 0x3c, 0x32, 0x8b, 0xd6, 0xbc, 0x4a, 0x4b, 0x17,
	0x4d, 0xba, 0x5e, 0xad, 0xea, 0x3d, 0xb2, 0xfe, 0x28, 0xc2, 0xfa, 0xbc, 0xea, 0xa1, 0x01, 0xd4,
	0xe2, 0x89, 0xfc, 0xdf, 0xbe, 0x06, 0x79, 0x5b, 0x74, 0x08, 0x57, 0xcf, 0x5e, 0x26, 0x37, 0x4f,
	0xba, 0x78, 0xc9, 0x57, 0x6a, 0xcd, 0xbc, 0x52, 0xb9, 0x48, 0xd1, 0xff, 0xf3, 0xfb, 0x4d, 0x6d,
	0xa0, 0xdc, 0x12, 0xd3, 0x4f, 0x86, 0x85, 0xa1, 0x96, 0x2b, 0x21, 0xba, 0x09, 0x35, 0xf1, 0x57,
	0x40, 0x8c, 0x19, 0x25, 0xa9, 0xfe, 0x05, 0x03, 0xfc, 0x6c, 0xd6, 0x27, 0x23, 0xb1, 0x74, 0xd9,
	0x91, 0xe8, 0x22, 0x68, 0xea, 0x2b, 0xd0, 0x2b, 0x93, 0x45, 0xdd, 0x5f, 0x8b, 0xd0, 0xf2, 0x58,
	0x38, 0xd7, 0xba, 0xbb, 0xa1, 0x27, 0xf9, 0xd9, 0x99, 0x74, 0x5f, 0xdc, 0xd2, 0x7e, 0xf1, 0xdb,
	0x47, 0x1a, 0x3f, 0x62, 0x01, 0x8e, 0x46, 0x36, 0x4b, 0x46, 0x9d, 0x11, 0x89, 0xe4, 0x1d, 0x76,
	0x94, 0x0a, 0xc7, 0x34, 0x9d, 0xfe, 0x57, 0xf5, 0xf9, 0xe4, 0xf4, 0xcb, 0x82, 0xf5, 0xa5, 0x22,
	0x90, 0xbf, 0x62, 0xed, 0x89, 0x03, 0xfb, 0x68, 0xfb, 0x77, 0xa3, 0x7c, 0x2d, 0x95, 0xaf, 0x27,
	0xca, 0xd7, 0x47, 0xdb, 0xc3, 0x92, 0x74, 0xb2, 0xfd, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd2,
	0x68, 0xce, 0xe2, 0xb9, 0x0d, 0x00, 0x00,
}
