/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ContractProperties struct for ContractProperties
type ContractProperties struct {
	// The contract number.
	ContractNumber *int64 `json:"contractNumber,omitempty"`
	// The contract owner's user name.
	Owner *string `json:"owner,omitempty"`
	// The registration domain of the contract.
	RegDomain      *string         `json:"regDomain,omitempty"`
	ResourceLimits *ResourceLimits `json:"resourceLimits,omitempty"`
	// The contract status.
	Status *string `json:"status,omitempty"`
}

// NewContractProperties instantiates a new ContractProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContractProperties() *ContractProperties {
	this := ContractProperties{}

	return &this
}

// NewContractPropertiesWithDefaults instantiates a new ContractProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContractPropertiesWithDefaults() *ContractProperties {
	this := ContractProperties{}
	return &this
}

// GetContractNumber returns the ContractNumber field value
// If the value is explicit nil, nil is returned
func (o *ContractProperties) GetContractNumber() *int64 {
	if o == nil {
		return nil
	}

	return o.ContractNumber

}

// GetContractNumberOk returns a tuple with the ContractNumber field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContractProperties) GetContractNumberOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.ContractNumber, true
}

// SetContractNumber sets field value
func (o *ContractProperties) SetContractNumber(v int64) {

	o.ContractNumber = &v

}

// HasContractNumber returns a boolean if a field has been set.
func (o *ContractProperties) HasContractNumber() bool {
	if o != nil && o.ContractNumber != nil {
		return true
	}

	return false
}

// GetOwner returns the Owner field value
// If the value is explicit nil, nil is returned
func (o *ContractProperties) GetOwner() *string {
	if o == nil {
		return nil
	}

	return o.Owner

}

// GetOwnerOk returns a tuple with the Owner field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContractProperties) GetOwnerOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Owner, true
}

// SetOwner sets field value
func (o *ContractProperties) SetOwner(v string) {

	o.Owner = &v

}

// HasOwner returns a boolean if a field has been set.
func (o *ContractProperties) HasOwner() bool {
	if o != nil && o.Owner != nil {
		return true
	}

	return false
}

// GetRegDomain returns the RegDomain field value
// If the value is explicit nil, nil is returned
func (o *ContractProperties) GetRegDomain() *string {
	if o == nil {
		return nil
	}

	return o.RegDomain

}

// GetRegDomainOk returns a tuple with the RegDomain field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContractProperties) GetRegDomainOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.RegDomain, true
}

// SetRegDomain sets field value
func (o *ContractProperties) SetRegDomain(v string) {

	o.RegDomain = &v

}

// HasRegDomain returns a boolean if a field has been set.
func (o *ContractProperties) HasRegDomain() bool {
	if o != nil && o.RegDomain != nil {
		return true
	}

	return false
}

// GetResourceLimits returns the ResourceLimits field value
// If the value is explicit nil, nil is returned
func (o *ContractProperties) GetResourceLimits() *ResourceLimits {
	if o == nil {
		return nil
	}

	return o.ResourceLimits

}

// GetResourceLimitsOk returns a tuple with the ResourceLimits field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContractProperties) GetResourceLimitsOk() (*ResourceLimits, bool) {
	if o == nil {
		return nil, false
	}

	return o.ResourceLimits, true
}

// SetResourceLimits sets field value
func (o *ContractProperties) SetResourceLimits(v ResourceLimits) {

	o.ResourceLimits = &v

}

// HasResourceLimits returns a boolean if a field has been set.
func (o *ContractProperties) HasResourceLimits() bool {
	if o != nil && o.ResourceLimits != nil {
		return true
	}

	return false
}

// GetStatus returns the Status field value
// If the value is explicit nil, nil is returned
func (o *ContractProperties) GetStatus() *string {
	if o == nil {
		return nil
	}

	return o.Status

}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ContractProperties) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Status, true
}

// SetStatus sets field value
func (o *ContractProperties) SetStatus(v string) {

	o.Status = &v

}

// HasStatus returns a boolean if a field has been set.
func (o *ContractProperties) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

func (o ContractProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ContractNumber != nil {
		toSerialize["contractNumber"] = o.ContractNumber
	}

	if o.Owner != nil {
		toSerialize["owner"] = o.Owner
	}

	if o.RegDomain != nil {
		toSerialize["regDomain"] = o.RegDomain
	}

	if o.ResourceLimits != nil {
		toSerialize["resourceLimits"] = o.ResourceLimits
	}

	if o.Status != nil {
		toSerialize["status"] = o.Status
	}

	return json.Marshal(toSerialize)
}

type NullableContractProperties struct {
	value *ContractProperties
	isSet bool
}

func (v NullableContractProperties) Get() *ContractProperties {
	return v.value
}

func (v *NullableContractProperties) Set(val *ContractProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableContractProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableContractProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContractProperties(val *ContractProperties) *NullableContractProperties {
	return &NullableContractProperties{value: val, isSet: true}
}

func (v NullableContractProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContractProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
