//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package eventgrid

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/eventgrid/mgmt/2021-10-15-preview/eventgrid"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ChannelProvisioningState = original.ChannelProvisioningState

const (
	ChannelProvisioningStateCanceled  ChannelProvisioningState = original.ChannelProvisioningStateCanceled
	ChannelProvisioningStateCreating  ChannelProvisioningState = original.ChannelProvisioningStateCreating
	ChannelProvisioningStateDeleting  ChannelProvisioningState = original.ChannelProvisioningStateDeleting
	ChannelProvisioningStateFailed    ChannelProvisioningState = original.ChannelProvisioningStateFailed
	ChannelProvisioningStateSucceeded ChannelProvisioningState = original.ChannelProvisioningStateSucceeded
	ChannelProvisioningStateUpdating  ChannelProvisioningState = original.ChannelProvisioningStateUpdating
)

type ChannelType = original.ChannelType

const (
	ChannelTypePartnerDestination ChannelType = original.ChannelTypePartnerDestination
	ChannelTypePartnerTopic       ChannelType = original.ChannelTypePartnerTopic
)

type ClientAuthenticationType = original.ClientAuthenticationType

const (
	ClientAuthenticationTypeAzureAD                     ClientAuthenticationType = original.ClientAuthenticationTypeAzureAD
	ClientAuthenticationTypePartnerClientAuthentication ClientAuthenticationType = original.ClientAuthenticationTypePartnerClientAuthentication
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DataResidencyBoundary = original.DataResidencyBoundary

const (
	DataResidencyBoundaryWithinGeopair DataResidencyBoundary = original.DataResidencyBoundaryWithinGeopair
	DataResidencyBoundaryWithinRegion  DataResidencyBoundary = original.DataResidencyBoundaryWithinRegion
)

type DomainProvisioningState = original.DomainProvisioningState

const (
	DomainProvisioningStateCanceled  DomainProvisioningState = original.DomainProvisioningStateCanceled
	DomainProvisioningStateCreating  DomainProvisioningState = original.DomainProvisioningStateCreating
	DomainProvisioningStateDeleting  DomainProvisioningState = original.DomainProvisioningStateDeleting
	DomainProvisioningStateFailed    DomainProvisioningState = original.DomainProvisioningStateFailed
	DomainProvisioningStateSucceeded DomainProvisioningState = original.DomainProvisioningStateSucceeded
	DomainProvisioningStateUpdating  DomainProvisioningState = original.DomainProvisioningStateUpdating
)

type DomainTopicProvisioningState = original.DomainTopicProvisioningState

const (
	DomainTopicProvisioningStateCanceled  DomainTopicProvisioningState = original.DomainTopicProvisioningStateCanceled
	DomainTopicProvisioningStateCreating  DomainTopicProvisioningState = original.DomainTopicProvisioningStateCreating
	DomainTopicProvisioningStateDeleting  DomainTopicProvisioningState = original.DomainTopicProvisioningStateDeleting
	DomainTopicProvisioningStateFailed    DomainTopicProvisioningState = original.DomainTopicProvisioningStateFailed
	DomainTopicProvisioningStateSucceeded DomainTopicProvisioningState = original.DomainTopicProvisioningStateSucceeded
	DomainTopicProvisioningStateUpdating  DomainTopicProvisioningState = original.DomainTopicProvisioningStateUpdating
)

type EndpointType = original.EndpointType

const (
	EndpointTypePartnerDestinationInfo EndpointType = original.EndpointTypePartnerDestinationInfo
	EndpointTypeWebHook                EndpointType = original.EndpointTypeWebHook
)

type EndpointTypeBasicDeadLetterDestination = original.EndpointTypeBasicDeadLetterDestination

const (
	EndpointTypeBasicDeadLetterDestinationEndpointTypeDeadLetterDestination EndpointTypeBasicDeadLetterDestination = original.EndpointTypeBasicDeadLetterDestinationEndpointTypeDeadLetterDestination
	EndpointTypeBasicDeadLetterDestinationEndpointTypeStorageBlob           EndpointTypeBasicDeadLetterDestination = original.EndpointTypeBasicDeadLetterDestinationEndpointTypeStorageBlob
)

type EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestination

const (
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeAzureFunction                EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeAzureFunction
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventHub                     EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventHub
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventSubscriptionDestination EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeEventSubscriptionDestination
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeHybridConnection             EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeHybridConnection
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypePartnerDestination           EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypePartnerDestination
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusQueue              EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusQueue
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusTopic              EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeServiceBusTopic
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeStorageQueue                 EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeStorageQueue
	EndpointTypeBasicEventSubscriptionDestinationEndpointTypeWebHook                      EndpointTypeBasicEventSubscriptionDestination = original.EndpointTypeBasicEventSubscriptionDestinationEndpointTypeWebHook
)

type EndpointTypeBasicPartnerUpdateDestinationInfo = original.EndpointTypeBasicPartnerUpdateDestinationInfo

const (
	EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypePartnerUpdateDestinationInfo EndpointTypeBasicPartnerUpdateDestinationInfo = original.EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypePartnerUpdateDestinationInfo
	EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypeWebHook                      EndpointTypeBasicPartnerUpdateDestinationInfo = original.EndpointTypeBasicPartnerUpdateDestinationInfoEndpointTypeWebHook
)

type EventChannelProvisioningState = original.EventChannelProvisioningState

const (
	EventChannelProvisioningStateCanceled  EventChannelProvisioningState = original.EventChannelProvisioningStateCanceled
	EventChannelProvisioningStateCreating  EventChannelProvisioningState = original.EventChannelProvisioningStateCreating
	EventChannelProvisioningStateDeleting  EventChannelProvisioningState = original.EventChannelProvisioningStateDeleting
	EventChannelProvisioningStateFailed    EventChannelProvisioningState = original.EventChannelProvisioningStateFailed
	EventChannelProvisioningStateSucceeded EventChannelProvisioningState = original.EventChannelProvisioningStateSucceeded
	EventChannelProvisioningStateUpdating  EventChannelProvisioningState = original.EventChannelProvisioningStateUpdating
)

type EventDefinitionKind = original.EventDefinitionKind

const (
	EventDefinitionKindInline EventDefinitionKind = original.EventDefinitionKindInline
)

type EventDeliverySchema = original.EventDeliverySchema

const (
	EventDeliverySchemaCloudEventSchemaV10 EventDeliverySchema = original.EventDeliverySchemaCloudEventSchemaV10
	EventDeliverySchemaCustomInputSchema   EventDeliverySchema = original.EventDeliverySchemaCustomInputSchema
	EventDeliverySchemaEventGridSchema     EventDeliverySchema = original.EventDeliverySchemaEventGridSchema
)

type EventSubscriptionIdentityType = original.EventSubscriptionIdentityType

const (
	EventSubscriptionIdentityTypeSystemAssigned EventSubscriptionIdentityType = original.EventSubscriptionIdentityTypeSystemAssigned
	EventSubscriptionIdentityTypeUserAssigned   EventSubscriptionIdentityType = original.EventSubscriptionIdentityTypeUserAssigned
)

type EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningState

const (
	EventSubscriptionProvisioningStateAwaitingManualAction EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateAwaitingManualAction
	EventSubscriptionProvisioningStateCanceled             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateCanceled
	EventSubscriptionProvisioningStateCreating             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateCreating
	EventSubscriptionProvisioningStateDeleting             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateDeleting
	EventSubscriptionProvisioningStateFailed               EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateFailed
	EventSubscriptionProvisioningStateSucceeded            EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateSucceeded
	EventSubscriptionProvisioningStateUpdating             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateUpdating
)

type IPActionType = original.IPActionType

const (
	IPActionTypeAllow IPActionType = original.IPActionTypeAllow
)

type IdentityType = original.IdentityType

const (
	IdentityTypeNone                       IdentityType = original.IdentityTypeNone
	IdentityTypeSystemAssigned             IdentityType = original.IdentityTypeSystemAssigned
	IdentityTypeSystemAssignedUserAssigned IdentityType = original.IdentityTypeSystemAssignedUserAssigned
	IdentityTypeUserAssigned               IdentityType = original.IdentityTypeUserAssigned
)

type InputSchema = original.InputSchema

const (
	InputSchemaCloudEventSchemaV10 InputSchema = original.InputSchemaCloudEventSchemaV10
	InputSchemaCustomEventSchema   InputSchema = original.InputSchemaCustomEventSchema
	InputSchemaEventGridSchema     InputSchema = original.InputSchemaEventGridSchema
)

type InputSchemaMappingType = original.InputSchemaMappingType

const (
	InputSchemaMappingTypeInputSchemaMapping InputSchemaMappingType = original.InputSchemaMappingTypeInputSchemaMapping
	InputSchemaMappingTypeJSON               InputSchemaMappingType = original.InputSchemaMappingTypeJSON
)

type OperatorType = original.OperatorType

const (
	OperatorTypeAdvancedFilter            OperatorType = original.OperatorTypeAdvancedFilter
	OperatorTypeBoolEquals                OperatorType = original.OperatorTypeBoolEquals
	OperatorTypeIsNotNull                 OperatorType = original.OperatorTypeIsNotNull
	OperatorTypeIsNullOrUndefined         OperatorType = original.OperatorTypeIsNullOrUndefined
	OperatorTypeNumberGreaterThan         OperatorType = original.OperatorTypeNumberGreaterThan
	OperatorTypeNumberGreaterThanOrEquals OperatorType = original.OperatorTypeNumberGreaterThanOrEquals
	OperatorTypeNumberIn                  OperatorType = original.OperatorTypeNumberIn
	OperatorTypeNumberInRange             OperatorType = original.OperatorTypeNumberInRange
	OperatorTypeNumberLessThan            OperatorType = original.OperatorTypeNumberLessThan
	OperatorTypeNumberLessThanOrEquals    OperatorType = original.OperatorTypeNumberLessThanOrEquals
	OperatorTypeNumberNotIn               OperatorType = original.OperatorTypeNumberNotIn
	OperatorTypeNumberNotInRange          OperatorType = original.OperatorTypeNumberNotInRange
	OperatorTypeStringBeginsWith          OperatorType = original.OperatorTypeStringBeginsWith
	OperatorTypeStringContains            OperatorType = original.OperatorTypeStringContains
	OperatorTypeStringEndsWith            OperatorType = original.OperatorTypeStringEndsWith
	OperatorTypeStringIn                  OperatorType = original.OperatorTypeStringIn
	OperatorTypeStringNotBeginsWith       OperatorType = original.OperatorTypeStringNotBeginsWith
	OperatorTypeStringNotContains         OperatorType = original.OperatorTypeStringNotContains
	OperatorTypeStringNotEndsWith         OperatorType = original.OperatorTypeStringNotEndsWith
	OperatorTypeStringNotIn               OperatorType = original.OperatorTypeStringNotIn
)

type ParentType = original.ParentType

const (
	ParentTypeDomains           ParentType = original.ParentTypeDomains
	ParentTypePartnerNamespaces ParentType = original.ParentTypePartnerNamespaces
	ParentTypeTopics            ParentType = original.ParentTypeTopics
)

type PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningState

const (
	PartnerConfigurationProvisioningStateCanceled  PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateCanceled
	PartnerConfigurationProvisioningStateCreating  PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateCreating
	PartnerConfigurationProvisioningStateDeleting  PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateDeleting
	PartnerConfigurationProvisioningStateFailed    PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateFailed
	PartnerConfigurationProvisioningStateSucceeded PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateSucceeded
	PartnerConfigurationProvisioningStateUpdating  PartnerConfigurationProvisioningState = original.PartnerConfigurationProvisioningStateUpdating
)

type PartnerDestinationActivationState = original.PartnerDestinationActivationState

const (
	PartnerDestinationActivationStateActivated      PartnerDestinationActivationState = original.PartnerDestinationActivationStateActivated
	PartnerDestinationActivationStateNeverActivated PartnerDestinationActivationState = original.PartnerDestinationActivationStateNeverActivated
)

type PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningState

const (
	PartnerDestinationProvisioningStateCanceled  PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateCanceled
	PartnerDestinationProvisioningStateCreating  PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateCreating
	PartnerDestinationProvisioningStateDeleting  PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateDeleting
	PartnerDestinationProvisioningStateFailed    PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateFailed
	PartnerDestinationProvisioningStateSucceeded PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateSucceeded
	PartnerDestinationProvisioningStateUpdating  PartnerDestinationProvisioningState = original.PartnerDestinationProvisioningStateUpdating
)

type PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningState

const (
	PartnerNamespaceProvisioningStateCanceled  PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateCanceled
	PartnerNamespaceProvisioningStateCreating  PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateCreating
	PartnerNamespaceProvisioningStateDeleting  PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateDeleting
	PartnerNamespaceProvisioningStateFailed    PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateFailed
	PartnerNamespaceProvisioningStateSucceeded PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateSucceeded
	PartnerNamespaceProvisioningStateUpdating  PartnerNamespaceProvisioningState = original.PartnerNamespaceProvisioningStateUpdating
)

type PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningState

const (
	PartnerRegistrationProvisioningStateCanceled  PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateCanceled
	PartnerRegistrationProvisioningStateCreating  PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateCreating
	PartnerRegistrationProvisioningStateDeleting  PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateDeleting
	PartnerRegistrationProvisioningStateFailed    PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateFailed
	PartnerRegistrationProvisioningStateSucceeded PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateSucceeded
	PartnerRegistrationProvisioningStateUpdating  PartnerRegistrationProvisioningState = original.PartnerRegistrationProvisioningStateUpdating
)

type PartnerRegistrationVisibilityState = original.PartnerRegistrationVisibilityState

const (
	PartnerRegistrationVisibilityStateGenerallyAvailable PartnerRegistrationVisibilityState = original.PartnerRegistrationVisibilityStateGenerallyAvailable
	PartnerRegistrationVisibilityStateHidden             PartnerRegistrationVisibilityState = original.PartnerRegistrationVisibilityStateHidden
	PartnerRegistrationVisibilityStatePublicPreview      PartnerRegistrationVisibilityState = original.PartnerRegistrationVisibilityStatePublicPreview
)

type PartnerTopicActivationState = original.PartnerTopicActivationState

const (
	PartnerTopicActivationStateActivated      PartnerTopicActivationState = original.PartnerTopicActivationStateActivated
	PartnerTopicActivationStateDeactivated    PartnerTopicActivationState = original.PartnerTopicActivationStateDeactivated
	PartnerTopicActivationStateNeverActivated PartnerTopicActivationState = original.PartnerTopicActivationStateNeverActivated
)

type PartnerTopicProvisioningState = original.PartnerTopicProvisioningState

const (
	PartnerTopicProvisioningStateCanceled  PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateCanceled
	PartnerTopicProvisioningStateCreating  PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateCreating
	PartnerTopicProvisioningStateDeleting  PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateDeleting
	PartnerTopicProvisioningStateFailed    PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateFailed
	PartnerTopicProvisioningStateSucceeded PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateSucceeded
	PartnerTopicProvisioningStateUpdating  PartnerTopicProvisioningState = original.PartnerTopicProvisioningStateUpdating
)

type PartnerTopicReadinessState = original.PartnerTopicReadinessState

const (
	PartnerTopicReadinessStateActivatedByUser       PartnerTopicReadinessState = original.PartnerTopicReadinessStateActivatedByUser
	PartnerTopicReadinessStateDeactivatedByUser     PartnerTopicReadinessState = original.PartnerTopicReadinessStateDeactivatedByUser
	PartnerTopicReadinessStateDeletedByUser         PartnerTopicReadinessState = original.PartnerTopicReadinessStateDeletedByUser
	PartnerTopicReadinessStateNotActivatedByUserYet PartnerTopicReadinessState = original.PartnerTopicReadinessStateNotActivatedByUserYet
)

type PartnerTopicRoutingMode = original.PartnerTopicRoutingMode

const (
	PartnerTopicRoutingModeChannelNameHeader    PartnerTopicRoutingMode = original.PartnerTopicRoutingModeChannelNameHeader
	PartnerTopicRoutingModeSourceEventAttribute PartnerTopicRoutingMode = original.PartnerTopicRoutingModeSourceEventAttribute
)

type PersistedConnectionStatus = original.PersistedConnectionStatus

const (
	PersistedConnectionStatusApproved     PersistedConnectionStatus = original.PersistedConnectionStatusApproved
	PersistedConnectionStatusDisconnected PersistedConnectionStatus = original.PersistedConnectionStatusDisconnected
	PersistedConnectionStatusPending      PersistedConnectionStatus = original.PersistedConnectionStatusPending
	PersistedConnectionStatusRejected     PersistedConnectionStatus = original.PersistedConnectionStatusRejected
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type ReadinessState = original.ReadinessState

const (
	ReadinessStateActivated      ReadinessState = original.ReadinessStateActivated
	ReadinessStateNeverActivated ReadinessState = original.ReadinessStateNeverActivated
)

type ResourceKind = original.ResourceKind

const (
	ResourceKindAzure    ResourceKind = original.ResourceKindAzure
	ResourceKindAzureArc ResourceKind = original.ResourceKindAzureArc
)

type ResourceProvisioningState = original.ResourceProvisioningState

const (
	ResourceProvisioningStateCanceled  ResourceProvisioningState = original.ResourceProvisioningStateCanceled
	ResourceProvisioningStateCreating  ResourceProvisioningState = original.ResourceProvisioningStateCreating
	ResourceProvisioningStateDeleting  ResourceProvisioningState = original.ResourceProvisioningStateDeleting
	ResourceProvisioningStateFailed    ResourceProvisioningState = original.ResourceProvisioningStateFailed
	ResourceProvisioningStateSucceeded ResourceProvisioningState = original.ResourceProvisioningStateSucceeded
	ResourceProvisioningStateUpdating  ResourceProvisioningState = original.ResourceProvisioningStateUpdating
)

type ResourceRegionType = original.ResourceRegionType

const (
	ResourceRegionTypeGlobalResource   ResourceRegionType = original.ResourceRegionTypeGlobalResource
	ResourceRegionTypeRegionalResource ResourceRegionType = original.ResourceRegionTypeRegionalResource
)

type Sku = original.Sku

const (
	SkuBasic   Sku = original.SkuBasic
	SkuPremium Sku = original.SkuPremium
)

type TopicProvisioningState = original.TopicProvisioningState

const (
	TopicProvisioningStateCanceled  TopicProvisioningState = original.TopicProvisioningStateCanceled
	TopicProvisioningStateCreating  TopicProvisioningState = original.TopicProvisioningStateCreating
	TopicProvisioningStateDeleting  TopicProvisioningState = original.TopicProvisioningStateDeleting
	TopicProvisioningStateFailed    TopicProvisioningState = original.TopicProvisioningStateFailed
	TopicProvisioningStateSucceeded TopicProvisioningState = original.TopicProvisioningStateSucceeded
	TopicProvisioningStateUpdating  TopicProvisioningState = original.TopicProvisioningStateUpdating
)

type TopicTypeProvisioningState = original.TopicTypeProvisioningState

const (
	TopicTypeProvisioningStateCanceled  TopicTypeProvisioningState = original.TopicTypeProvisioningStateCanceled
	TopicTypeProvisioningStateCreating  TopicTypeProvisioningState = original.TopicTypeProvisioningStateCreating
	TopicTypeProvisioningStateDeleting  TopicTypeProvisioningState = original.TopicTypeProvisioningStateDeleting
	TopicTypeProvisioningStateFailed    TopicTypeProvisioningState = original.TopicTypeProvisioningStateFailed
	TopicTypeProvisioningStateSucceeded TopicTypeProvisioningState = original.TopicTypeProvisioningStateSucceeded
	TopicTypeProvisioningStateUpdating  TopicTypeProvisioningState = original.TopicTypeProvisioningStateUpdating
)

type Type = original.Type

const (
	TypeDeliveryAttributeMapping Type = original.TypeDeliveryAttributeMapping
	TypeDynamic                  Type = original.TypeDynamic
	TypeStatic                   Type = original.TypeStatic
)

type VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningState

const (
	VerifiedPartnerProvisioningStateCanceled  VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateCanceled
	VerifiedPartnerProvisioningStateCreating  VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateCreating
	VerifiedPartnerProvisioningStateDeleting  VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateDeleting
	VerifiedPartnerProvisioningStateFailed    VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateFailed
	VerifiedPartnerProvisioningStateSucceeded VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateSucceeded
	VerifiedPartnerProvisioningStateUpdating  VerifiedPartnerProvisioningState = original.VerifiedPartnerProvisioningStateUpdating
)

type AdvancedFilter = original.AdvancedFilter
type AzureADPartnerClientAuthentication = original.AzureADPartnerClientAuthentication
type AzureADPartnerClientAuthenticationProperties = original.AzureADPartnerClientAuthenticationProperties
type AzureFunctionEventSubscriptionDestination = original.AzureFunctionEventSubscriptionDestination
type AzureFunctionEventSubscriptionDestinationProperties = original.AzureFunctionEventSubscriptionDestinationProperties
type BaseClient = original.BaseClient
type BasicAdvancedFilter = original.BasicAdvancedFilter
type BasicDeadLetterDestination = original.BasicDeadLetterDestination
type BasicDeliveryAttributeMapping = original.BasicDeliveryAttributeMapping
type BasicEventSubscriptionDestination = original.BasicEventSubscriptionDestination
type BasicInputSchemaMapping = original.BasicInputSchemaMapping
type BasicPartnerClientAuthentication = original.BasicPartnerClientAuthentication
type BasicPartnerDestinationInfo = original.BasicPartnerDestinationInfo
type BasicPartnerUpdateDestinationInfo = original.BasicPartnerUpdateDestinationInfo
type BoolEqualsAdvancedFilter = original.BoolEqualsAdvancedFilter
type Channel = original.Channel
type ChannelProperties = original.ChannelProperties
type ChannelUpdateParameters = original.ChannelUpdateParameters
type ChannelUpdateParametersProperties = original.ChannelUpdateParametersProperties
type ChannelsClient = original.ChannelsClient
type ChannelsDeleteFuture = original.ChannelsDeleteFuture
type ChannelsListResult = original.ChannelsListResult
type ChannelsListResultIterator = original.ChannelsListResultIterator
type ChannelsListResultPage = original.ChannelsListResultPage
type ConnectionState = original.ConnectionState
type DeadLetterDestination = original.DeadLetterDestination
type DeadLetterWithResourceIdentity = original.DeadLetterWithResourceIdentity
type DeliveryAttributeListResult = original.DeliveryAttributeListResult
type DeliveryAttributeMapping = original.DeliveryAttributeMapping
type DeliveryWithResourceIdentity = original.DeliveryWithResourceIdentity
type Domain = original.Domain
type DomainEventSubscriptionsClient = original.DomainEventSubscriptionsClient
type DomainEventSubscriptionsCreateOrUpdateFuture = original.DomainEventSubscriptionsCreateOrUpdateFuture
type DomainEventSubscriptionsDeleteFuture = original.DomainEventSubscriptionsDeleteFuture
type DomainEventSubscriptionsUpdateFuture = original.DomainEventSubscriptionsUpdateFuture
type DomainProperties = original.DomainProperties
type DomainRegenerateKeyRequest = original.DomainRegenerateKeyRequest
type DomainSharedAccessKeys = original.DomainSharedAccessKeys
type DomainTopic = original.DomainTopic
type DomainTopicEventSubscriptionsClient = original.DomainTopicEventSubscriptionsClient
type DomainTopicEventSubscriptionsCreateOrUpdateFuture = original.DomainTopicEventSubscriptionsCreateOrUpdateFuture
type DomainTopicEventSubscriptionsDeleteFuture = original.DomainTopicEventSubscriptionsDeleteFuture
type DomainTopicEventSubscriptionsUpdateFuture = original.DomainTopicEventSubscriptionsUpdateFuture
type DomainTopicProperties = original.DomainTopicProperties
type DomainTopicsClient = original.DomainTopicsClient
type DomainTopicsCreateOrUpdateFuture = original.DomainTopicsCreateOrUpdateFuture
type DomainTopicsDeleteFuture = original.DomainTopicsDeleteFuture
type DomainTopicsListResult = original.DomainTopicsListResult
type DomainTopicsListResultIterator = original.DomainTopicsListResultIterator
type DomainTopicsListResultPage = original.DomainTopicsListResultPage
type DomainUpdateParameterProperties = original.DomainUpdateParameterProperties
type DomainUpdateParameters = original.DomainUpdateParameters
type DomainsClient = original.DomainsClient
type DomainsCreateOrUpdateFuture = original.DomainsCreateOrUpdateFuture
type DomainsDeleteFuture = original.DomainsDeleteFuture
type DomainsListResult = original.DomainsListResult
type DomainsListResultIterator = original.DomainsListResultIterator
type DomainsListResultPage = original.DomainsListResultPage
type DomainsUpdateFuture = original.DomainsUpdateFuture
type DynamicDeliveryAttributeMapping = original.DynamicDeliveryAttributeMapping
type DynamicDeliveryAttributeMappingProperties = original.DynamicDeliveryAttributeMappingProperties
type EventChannel = original.EventChannel
type EventChannelDestination = original.EventChannelDestination
type EventChannelFilter = original.EventChannelFilter
type EventChannelProperties = original.EventChannelProperties
type EventChannelSource = original.EventChannelSource
type EventChannelsClient = original.EventChannelsClient
type EventChannelsDeleteFuture = original.EventChannelsDeleteFuture
type EventChannelsListResult = original.EventChannelsListResult
type EventChannelsListResultIterator = original.EventChannelsListResultIterator
type EventChannelsListResultPage = original.EventChannelsListResultPage
type EventHubEventSubscriptionDestination = original.EventHubEventSubscriptionDestination
type EventHubEventSubscriptionDestinationProperties = original.EventHubEventSubscriptionDestinationProperties
type EventSubscription = original.EventSubscription
type EventSubscriptionDestination = original.EventSubscriptionDestination
type EventSubscriptionFilter = original.EventSubscriptionFilter
type EventSubscriptionFullURL = original.EventSubscriptionFullURL
type EventSubscriptionIdentity = original.EventSubscriptionIdentity
type EventSubscriptionProperties = original.EventSubscriptionProperties
type EventSubscriptionUpdateParameters = original.EventSubscriptionUpdateParameters
type EventSubscriptionsClient = original.EventSubscriptionsClient
type EventSubscriptionsCreateOrUpdateFuture = original.EventSubscriptionsCreateOrUpdateFuture
type EventSubscriptionsDeleteFuture = original.EventSubscriptionsDeleteFuture
type EventSubscriptionsListResult = original.EventSubscriptionsListResult
type EventSubscriptionsListResultIterator = original.EventSubscriptionsListResultIterator
type EventSubscriptionsListResultPage = original.EventSubscriptionsListResultPage
type EventSubscriptionsUpdateFuture = original.EventSubscriptionsUpdateFuture
type EventType = original.EventType
type EventTypeInfo = original.EventTypeInfo
type EventTypeProperties = original.EventTypeProperties
type EventTypesListResult = original.EventTypesListResult
type ExtendedLocation = original.ExtendedLocation
type ExtensionTopic = original.ExtensionTopic
type ExtensionTopicProperties = original.ExtensionTopicProperties
type ExtensionTopicsClient = original.ExtensionTopicsClient
type HybridConnectionEventSubscriptionDestination = original.HybridConnectionEventSubscriptionDestination
type HybridConnectionEventSubscriptionDestinationProperties = original.HybridConnectionEventSubscriptionDestinationProperties
type IdentityInfo = original.IdentityInfo
type InboundIPRule = original.InboundIPRule
type InlineEventProperties = original.InlineEventProperties
type InputSchemaMapping = original.InputSchemaMapping
type IsNotNullAdvancedFilter = original.IsNotNullAdvancedFilter
type IsNullOrUndefinedAdvancedFilter = original.IsNullOrUndefinedAdvancedFilter
type JSONField = original.JSONField
type JSONFieldWithDefault = original.JSONFieldWithDefault
type JSONInputSchemaMapping = original.JSONInputSchemaMapping
type JSONInputSchemaMappingProperties = original.JSONInputSchemaMappingProperties
type NumberGreaterThanAdvancedFilter = original.NumberGreaterThanAdvancedFilter
type NumberGreaterThanOrEqualsAdvancedFilter = original.NumberGreaterThanOrEqualsAdvancedFilter
type NumberInAdvancedFilter = original.NumberInAdvancedFilter
type NumberInRangeAdvancedFilter = original.NumberInRangeAdvancedFilter
type NumberLessThanAdvancedFilter = original.NumberLessThanAdvancedFilter
type NumberLessThanOrEqualsAdvancedFilter = original.NumberLessThanOrEqualsAdvancedFilter
type NumberNotInAdvancedFilter = original.NumberNotInAdvancedFilter
type NumberNotInRangeAdvancedFilter = original.NumberNotInRangeAdvancedFilter
type Operation = original.Operation
type OperationInfo = original.OperationInfo
type OperationsClient = original.OperationsClient
type OperationsListResult = original.OperationsListResult
type Partner = original.Partner
type PartnerAuthorization = original.PartnerAuthorization
type PartnerClientAuthentication = original.PartnerClientAuthentication
type PartnerConfiguration = original.PartnerConfiguration
type PartnerConfigurationProperties = original.PartnerConfigurationProperties
type PartnerConfigurationUpdateParameterProperties = original.PartnerConfigurationUpdateParameterProperties
type PartnerConfigurationUpdateParameters = original.PartnerConfigurationUpdateParameters
type PartnerConfigurationsClient = original.PartnerConfigurationsClient
type PartnerConfigurationsCreateOrUpdateFuture = original.PartnerConfigurationsCreateOrUpdateFuture
type PartnerConfigurationsDeleteFuture = original.PartnerConfigurationsDeleteFuture
type PartnerConfigurationsListResult = original.PartnerConfigurationsListResult
type PartnerConfigurationsListResultIterator = original.PartnerConfigurationsListResultIterator
type PartnerConfigurationsListResultPage = original.PartnerConfigurationsListResultPage
type PartnerConfigurationsUpdateFuture = original.PartnerConfigurationsUpdateFuture
type PartnerDestination = original.PartnerDestination
type PartnerDestinationInfo = original.PartnerDestinationInfo
type PartnerDestinationProperties = original.PartnerDestinationProperties
type PartnerDestinationUpdateParameters = original.PartnerDestinationUpdateParameters
type PartnerDestinationsClient = original.PartnerDestinationsClient
type PartnerDestinationsDeleteFuture = original.PartnerDestinationsDeleteFuture
type PartnerDestinationsListResult = original.PartnerDestinationsListResult
type PartnerDestinationsListResultIterator = original.PartnerDestinationsListResultIterator
type PartnerDestinationsListResultPage = original.PartnerDestinationsListResultPage
type PartnerDetails = original.PartnerDetails
type PartnerEventSubscriptionDestination = original.PartnerEventSubscriptionDestination
type PartnerEventSubscriptionDestinationProperties = original.PartnerEventSubscriptionDestinationProperties
type PartnerNamespace = original.PartnerNamespace
type PartnerNamespaceProperties = original.PartnerNamespaceProperties
type PartnerNamespaceRegenerateKeyRequest = original.PartnerNamespaceRegenerateKeyRequest
type PartnerNamespaceSharedAccessKeys = original.PartnerNamespaceSharedAccessKeys
type PartnerNamespaceUpdateParameterProperties = original.PartnerNamespaceUpdateParameterProperties
type PartnerNamespaceUpdateParameters = original.PartnerNamespaceUpdateParameters
type PartnerNamespacesClient = original.PartnerNamespacesClient
type PartnerNamespacesCreateOrUpdateFuture = original.PartnerNamespacesCreateOrUpdateFuture
type PartnerNamespacesDeleteFuture = original.PartnerNamespacesDeleteFuture
type PartnerNamespacesListResult = original.PartnerNamespacesListResult
type PartnerNamespacesListResultIterator = original.PartnerNamespacesListResultIterator
type PartnerNamespacesListResultPage = original.PartnerNamespacesListResultPage
type PartnerNamespacesUpdateFuture = original.PartnerNamespacesUpdateFuture
type PartnerRegistration = original.PartnerRegistration
type PartnerRegistrationProperties = original.PartnerRegistrationProperties
type PartnerRegistrationUpdateParameters = original.PartnerRegistrationUpdateParameters
type PartnerRegistrationsClient = original.PartnerRegistrationsClient
type PartnerRegistrationsCreateOrUpdateFuture = original.PartnerRegistrationsCreateOrUpdateFuture
type PartnerRegistrationsDeleteFuture = original.PartnerRegistrationsDeleteFuture
type PartnerRegistrationsListResult = original.PartnerRegistrationsListResult
type PartnerRegistrationsListResultIterator = original.PartnerRegistrationsListResultIterator
type PartnerRegistrationsListResultPage = original.PartnerRegistrationsListResultPage
type PartnerRegistrationsUpdateFuture = original.PartnerRegistrationsUpdateFuture
type PartnerTopic = original.PartnerTopic
type PartnerTopicEventSubscriptionsClient = original.PartnerTopicEventSubscriptionsClient
type PartnerTopicEventSubscriptionsCreateOrUpdateFuture = original.PartnerTopicEventSubscriptionsCreateOrUpdateFuture
type PartnerTopicEventSubscriptionsDeleteFuture = original.PartnerTopicEventSubscriptionsDeleteFuture
type PartnerTopicEventSubscriptionsUpdateFuture = original.PartnerTopicEventSubscriptionsUpdateFuture
type PartnerTopicInfo = original.PartnerTopicInfo
type PartnerTopicProperties = original.PartnerTopicProperties
type PartnerTopicUpdateParameters = original.PartnerTopicUpdateParameters
type PartnerTopicsClient = original.PartnerTopicsClient
type PartnerTopicsDeleteFuture = original.PartnerTopicsDeleteFuture
type PartnerTopicsListResult = original.PartnerTopicsListResult
type PartnerTopicsListResultIterator = original.PartnerTopicsListResultIterator
type PartnerTopicsListResultPage = original.PartnerTopicsListResultPage
type PartnerUpdateDestinationInfo = original.PartnerUpdateDestinationInfo
type PartnerUpdateTopicInfo = original.PartnerUpdateTopicInfo
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateEndpointConnectionsUpdateFuture = original.PrivateEndpointConnectionsUpdateFuture
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkResourcesListResult = original.PrivateLinkResourcesListResult
type PrivateLinkResourcesListResultIterator = original.PrivateLinkResourcesListResultIterator
type PrivateLinkResourcesListResultPage = original.PrivateLinkResourcesListResultPage
type Resource = original.Resource
type ResourceMoveChangeHistory = original.ResourceMoveChangeHistory
type ResourceSku = original.ResourceSku
type RetryPolicy = original.RetryPolicy
type ServiceBusQueueEventSubscriptionDestination = original.ServiceBusQueueEventSubscriptionDestination
type ServiceBusQueueEventSubscriptionDestinationProperties = original.ServiceBusQueueEventSubscriptionDestinationProperties
type ServiceBusTopicEventSubscriptionDestination = original.ServiceBusTopicEventSubscriptionDestination
type ServiceBusTopicEventSubscriptionDestinationProperties = original.ServiceBusTopicEventSubscriptionDestinationProperties
type StaticDeliveryAttributeMapping = original.StaticDeliveryAttributeMapping
type StaticDeliveryAttributeMappingProperties = original.StaticDeliveryAttributeMappingProperties
type StorageBlobDeadLetterDestination = original.StorageBlobDeadLetterDestination
type StorageBlobDeadLetterDestinationProperties = original.StorageBlobDeadLetterDestinationProperties
type StorageQueueEventSubscriptionDestination = original.StorageQueueEventSubscriptionDestination
type StorageQueueEventSubscriptionDestinationProperties = original.StorageQueueEventSubscriptionDestinationProperties
type StringBeginsWithAdvancedFilter = original.StringBeginsWithAdvancedFilter
type StringContainsAdvancedFilter = original.StringContainsAdvancedFilter
type StringEndsWithAdvancedFilter = original.StringEndsWithAdvancedFilter
type StringInAdvancedFilter = original.StringInAdvancedFilter
type StringNotBeginsWithAdvancedFilter = original.StringNotBeginsWithAdvancedFilter
type StringNotContainsAdvancedFilter = original.StringNotContainsAdvancedFilter
type StringNotEndsWithAdvancedFilter = original.StringNotEndsWithAdvancedFilter
type StringNotInAdvancedFilter = original.StringNotInAdvancedFilter
type SystemData = original.SystemData
type SystemTopic = original.SystemTopic
type SystemTopicEventSubscriptionsClient = original.SystemTopicEventSubscriptionsClient
type SystemTopicEventSubscriptionsCreateOrUpdateFuture = original.SystemTopicEventSubscriptionsCreateOrUpdateFuture
type SystemTopicEventSubscriptionsDeleteFuture = original.SystemTopicEventSubscriptionsDeleteFuture
type SystemTopicEventSubscriptionsUpdateFuture = original.SystemTopicEventSubscriptionsUpdateFuture
type SystemTopicProperties = original.SystemTopicProperties
type SystemTopicUpdateParameters = original.SystemTopicUpdateParameters
type SystemTopicsClient = original.SystemTopicsClient
type SystemTopicsCreateOrUpdateFuture = original.SystemTopicsCreateOrUpdateFuture
type SystemTopicsDeleteFuture = original.SystemTopicsDeleteFuture
type SystemTopicsListResult = original.SystemTopicsListResult
type SystemTopicsListResultIterator = original.SystemTopicsListResultIterator
type SystemTopicsListResultPage = original.SystemTopicsListResultPage
type SystemTopicsUpdateFuture = original.SystemTopicsUpdateFuture
type Topic = original.Topic
type TopicEventSubscriptionsClient = original.TopicEventSubscriptionsClient
type TopicEventSubscriptionsCreateOrUpdateFuture = original.TopicEventSubscriptionsCreateOrUpdateFuture
type TopicEventSubscriptionsDeleteFuture = original.TopicEventSubscriptionsDeleteFuture
type TopicEventSubscriptionsUpdateFuture = original.TopicEventSubscriptionsUpdateFuture
type TopicProperties = original.TopicProperties
type TopicRegenerateKeyRequest = original.TopicRegenerateKeyRequest
type TopicSharedAccessKeys = original.TopicSharedAccessKeys
type TopicTypeInfo = original.TopicTypeInfo
type TopicTypeProperties = original.TopicTypeProperties
type TopicTypesClient = original.TopicTypesClient
type TopicTypesListResult = original.TopicTypesListResult
type TopicUpdateParameterProperties = original.TopicUpdateParameterProperties
type TopicUpdateParameters = original.TopicUpdateParameters
type TopicsClient = original.TopicsClient
type TopicsCreateOrUpdateFuture = original.TopicsCreateOrUpdateFuture
type TopicsDeleteFuture = original.TopicsDeleteFuture
type TopicsListResult = original.TopicsListResult
type TopicsListResultIterator = original.TopicsListResultIterator
type TopicsListResultPage = original.TopicsListResultPage
type TopicsRegenerateKeyFuture = original.TopicsRegenerateKeyFuture
type TopicsUpdateFuture = original.TopicsUpdateFuture
type TrackedResource = original.TrackedResource
type UserIdentityProperties = original.UserIdentityProperties
type VerifiedPartner = original.VerifiedPartner
type VerifiedPartnerProperties = original.VerifiedPartnerProperties
type VerifiedPartnersClient = original.VerifiedPartnersClient
type VerifiedPartnersListResult = original.VerifiedPartnersListResult
type VerifiedPartnersListResultIterator = original.VerifiedPartnersListResultIterator
type VerifiedPartnersListResultPage = original.VerifiedPartnersListResultPage
type WebHookEventSubscriptionDestination = original.WebHookEventSubscriptionDestination
type WebHookEventSubscriptionDestinationProperties = original.WebHookEventSubscriptionDestinationProperties
type WebhookPartnerDestinationInfo = original.WebhookPartnerDestinationInfo
type WebhookPartnerDestinationProperties = original.WebhookPartnerDestinationProperties
type WebhookUpdatePartnerDestinationInfo = original.WebhookUpdatePartnerDestinationInfo

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewChannelsClient(subscriptionID string) ChannelsClient {
	return original.NewChannelsClient(subscriptionID)
}
func NewChannelsClientWithBaseURI(baseURI string, subscriptionID string) ChannelsClient {
	return original.NewChannelsClientWithBaseURI(baseURI, subscriptionID)
}
func NewChannelsListResultIterator(page ChannelsListResultPage) ChannelsListResultIterator {
	return original.NewChannelsListResultIterator(page)
}
func NewChannelsListResultPage(cur ChannelsListResult, getNextPage func(context.Context, ChannelsListResult) (ChannelsListResult, error)) ChannelsListResultPage {
	return original.NewChannelsListResultPage(cur, getNextPage)
}
func NewDomainEventSubscriptionsClient(subscriptionID string) DomainEventSubscriptionsClient {
	return original.NewDomainEventSubscriptionsClient(subscriptionID)
}
func NewDomainEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) DomainEventSubscriptionsClient {
	return original.NewDomainEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainTopicEventSubscriptionsClient(subscriptionID string) DomainTopicEventSubscriptionsClient {
	return original.NewDomainTopicEventSubscriptionsClient(subscriptionID)
}
func NewDomainTopicEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) DomainTopicEventSubscriptionsClient {
	return original.NewDomainTopicEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainTopicsClient(subscriptionID string) DomainTopicsClient {
	return original.NewDomainTopicsClient(subscriptionID)
}
func NewDomainTopicsClientWithBaseURI(baseURI string, subscriptionID string) DomainTopicsClient {
	return original.NewDomainTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainTopicsListResultIterator(page DomainTopicsListResultPage) DomainTopicsListResultIterator {
	return original.NewDomainTopicsListResultIterator(page)
}
func NewDomainTopicsListResultPage(cur DomainTopicsListResult, getNextPage func(context.Context, DomainTopicsListResult) (DomainTopicsListResult, error)) DomainTopicsListResultPage {
	return original.NewDomainTopicsListResultPage(cur, getNextPage)
}
func NewDomainsClient(subscriptionID string) DomainsClient {
	return original.NewDomainsClient(subscriptionID)
}
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return original.NewDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainsListResultIterator(page DomainsListResultPage) DomainsListResultIterator {
	return original.NewDomainsListResultIterator(page)
}
func NewDomainsListResultPage(cur DomainsListResult, getNextPage func(context.Context, DomainsListResult) (DomainsListResult, error)) DomainsListResultPage {
	return original.NewDomainsListResultPage(cur, getNextPage)
}
func NewEventChannelsClient(subscriptionID string) EventChannelsClient {
	return original.NewEventChannelsClient(subscriptionID)
}
func NewEventChannelsClientWithBaseURI(baseURI string, subscriptionID string) EventChannelsClient {
	return original.NewEventChannelsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventChannelsListResultIterator(page EventChannelsListResultPage) EventChannelsListResultIterator {
	return original.NewEventChannelsListResultIterator(page)
}
func NewEventChannelsListResultPage(cur EventChannelsListResult, getNextPage func(context.Context, EventChannelsListResult) (EventChannelsListResult, error)) EventChannelsListResultPage {
	return original.NewEventChannelsListResultPage(cur, getNextPage)
}
func NewEventSubscriptionsClient(subscriptionID string) EventSubscriptionsClient {
	return original.NewEventSubscriptionsClient(subscriptionID)
}
func NewEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) EventSubscriptionsClient {
	return original.NewEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventSubscriptionsListResultIterator(page EventSubscriptionsListResultPage) EventSubscriptionsListResultIterator {
	return original.NewEventSubscriptionsListResultIterator(page)
}
func NewEventSubscriptionsListResultPage(cur EventSubscriptionsListResult, getNextPage func(context.Context, EventSubscriptionsListResult) (EventSubscriptionsListResult, error)) EventSubscriptionsListResultPage {
	return original.NewEventSubscriptionsListResultPage(cur, getNextPage)
}
func NewExtensionTopicsClient(subscriptionID string) ExtensionTopicsClient {
	return original.NewExtensionTopicsClient(subscriptionID)
}
func NewExtensionTopicsClientWithBaseURI(baseURI string, subscriptionID string) ExtensionTopicsClient {
	return original.NewExtensionTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerConfigurationsClient(subscriptionID string) PartnerConfigurationsClient {
	return original.NewPartnerConfigurationsClient(subscriptionID)
}
func NewPartnerConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) PartnerConfigurationsClient {
	return original.NewPartnerConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerConfigurationsListResultIterator(page PartnerConfigurationsListResultPage) PartnerConfigurationsListResultIterator {
	return original.NewPartnerConfigurationsListResultIterator(page)
}
func NewPartnerConfigurationsListResultPage(cur PartnerConfigurationsListResult, getNextPage func(context.Context, PartnerConfigurationsListResult) (PartnerConfigurationsListResult, error)) PartnerConfigurationsListResultPage {
	return original.NewPartnerConfigurationsListResultPage(cur, getNextPage)
}
func NewPartnerDestinationsClient(subscriptionID string) PartnerDestinationsClient {
	return original.NewPartnerDestinationsClient(subscriptionID)
}
func NewPartnerDestinationsClientWithBaseURI(baseURI string, subscriptionID string) PartnerDestinationsClient {
	return original.NewPartnerDestinationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerDestinationsListResultIterator(page PartnerDestinationsListResultPage) PartnerDestinationsListResultIterator {
	return original.NewPartnerDestinationsListResultIterator(page)
}
func NewPartnerDestinationsListResultPage(cur PartnerDestinationsListResult, getNextPage func(context.Context, PartnerDestinationsListResult) (PartnerDestinationsListResult, error)) PartnerDestinationsListResultPage {
	return original.NewPartnerDestinationsListResultPage(cur, getNextPage)
}
func NewPartnerNamespacesClient(subscriptionID string) PartnerNamespacesClient {
	return original.NewPartnerNamespacesClient(subscriptionID)
}
func NewPartnerNamespacesClientWithBaseURI(baseURI string, subscriptionID string) PartnerNamespacesClient {
	return original.NewPartnerNamespacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerNamespacesListResultIterator(page PartnerNamespacesListResultPage) PartnerNamespacesListResultIterator {
	return original.NewPartnerNamespacesListResultIterator(page)
}
func NewPartnerNamespacesListResultPage(cur PartnerNamespacesListResult, getNextPage func(context.Context, PartnerNamespacesListResult) (PartnerNamespacesListResult, error)) PartnerNamespacesListResultPage {
	return original.NewPartnerNamespacesListResultPage(cur, getNextPage)
}
func NewPartnerRegistrationsClient(subscriptionID string) PartnerRegistrationsClient {
	return original.NewPartnerRegistrationsClient(subscriptionID)
}
func NewPartnerRegistrationsClientWithBaseURI(baseURI string, subscriptionID string) PartnerRegistrationsClient {
	return original.NewPartnerRegistrationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerRegistrationsListResultIterator(page PartnerRegistrationsListResultPage) PartnerRegistrationsListResultIterator {
	return original.NewPartnerRegistrationsListResultIterator(page)
}
func NewPartnerRegistrationsListResultPage(cur PartnerRegistrationsListResult, getNextPage func(context.Context, PartnerRegistrationsListResult) (PartnerRegistrationsListResult, error)) PartnerRegistrationsListResultPage {
	return original.NewPartnerRegistrationsListResultPage(cur, getNextPage)
}
func NewPartnerTopicEventSubscriptionsClient(subscriptionID string) PartnerTopicEventSubscriptionsClient {
	return original.NewPartnerTopicEventSubscriptionsClient(subscriptionID)
}
func NewPartnerTopicEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) PartnerTopicEventSubscriptionsClient {
	return original.NewPartnerTopicEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerTopicsClient(subscriptionID string) PartnerTopicsClient {
	return original.NewPartnerTopicsClient(subscriptionID)
}
func NewPartnerTopicsClientWithBaseURI(baseURI string, subscriptionID string) PartnerTopicsClient {
	return original.NewPartnerTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPartnerTopicsListResultIterator(page PartnerTopicsListResultPage) PartnerTopicsListResultIterator {
	return original.NewPartnerTopicsListResultIterator(page)
}
func NewPartnerTopicsListResultPage(cur PartnerTopicsListResult, getNextPage func(context.Context, PartnerTopicsListResult) (PartnerTopicsListResult, error)) PartnerTopicsListResultPage {
	return original.NewPartnerTopicsListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesListResultIterator(page PrivateLinkResourcesListResultPage) PrivateLinkResourcesListResultIterator {
	return original.NewPrivateLinkResourcesListResultIterator(page)
}
func NewPrivateLinkResourcesListResultPage(cur PrivateLinkResourcesListResult, getNextPage func(context.Context, PrivateLinkResourcesListResult) (PrivateLinkResourcesListResult, error)) PrivateLinkResourcesListResultPage {
	return original.NewPrivateLinkResourcesListResultPage(cur, getNextPage)
}
func NewSystemTopicEventSubscriptionsClient(subscriptionID string) SystemTopicEventSubscriptionsClient {
	return original.NewSystemTopicEventSubscriptionsClient(subscriptionID)
}
func NewSystemTopicEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) SystemTopicEventSubscriptionsClient {
	return original.NewSystemTopicEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSystemTopicsClient(subscriptionID string) SystemTopicsClient {
	return original.NewSystemTopicsClient(subscriptionID)
}
func NewSystemTopicsClientWithBaseURI(baseURI string, subscriptionID string) SystemTopicsClient {
	return original.NewSystemTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSystemTopicsListResultIterator(page SystemTopicsListResultPage) SystemTopicsListResultIterator {
	return original.NewSystemTopicsListResultIterator(page)
}
func NewSystemTopicsListResultPage(cur SystemTopicsListResult, getNextPage func(context.Context, SystemTopicsListResult) (SystemTopicsListResult, error)) SystemTopicsListResultPage {
	return original.NewSystemTopicsListResultPage(cur, getNextPage)
}
func NewTopicEventSubscriptionsClient(subscriptionID string) TopicEventSubscriptionsClient {
	return original.NewTopicEventSubscriptionsClient(subscriptionID)
}
func NewTopicEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) TopicEventSubscriptionsClient {
	return original.NewTopicEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicTypesClient(subscriptionID string) TopicTypesClient {
	return original.NewTopicTypesClient(subscriptionID)
}
func NewTopicTypesClientWithBaseURI(baseURI string, subscriptionID string) TopicTypesClient {
	return original.NewTopicTypesClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicsClient(subscriptionID string) TopicsClient {
	return original.NewTopicsClient(subscriptionID)
}
func NewTopicsClientWithBaseURI(baseURI string, subscriptionID string) TopicsClient {
	return original.NewTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicsListResultIterator(page TopicsListResultPage) TopicsListResultIterator {
	return original.NewTopicsListResultIterator(page)
}
func NewTopicsListResultPage(cur TopicsListResult, getNextPage func(context.Context, TopicsListResult) (TopicsListResult, error)) TopicsListResultPage {
	return original.NewTopicsListResultPage(cur, getNextPage)
}
func NewVerifiedPartnersClient(subscriptionID string) VerifiedPartnersClient {
	return original.NewVerifiedPartnersClient(subscriptionID)
}
func NewVerifiedPartnersClientWithBaseURI(baseURI string, subscriptionID string) VerifiedPartnersClient {
	return original.NewVerifiedPartnersClientWithBaseURI(baseURI, subscriptionID)
}
func NewVerifiedPartnersListResultIterator(page VerifiedPartnersListResultPage) VerifiedPartnersListResultIterator {
	return original.NewVerifiedPartnersListResultIterator(page)
}
func NewVerifiedPartnersListResultPage(cur VerifiedPartnersListResult, getNextPage func(context.Context, VerifiedPartnersListResult) (VerifiedPartnersListResult, error)) VerifiedPartnersListResultPage {
	return original.NewVerifiedPartnersListResultPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleChannelProvisioningStateValues() []ChannelProvisioningState {
	return original.PossibleChannelProvisioningStateValues()
}
func PossibleChannelTypeValues() []ChannelType {
	return original.PossibleChannelTypeValues()
}
func PossibleClientAuthenticationTypeValues() []ClientAuthenticationType {
	return original.PossibleClientAuthenticationTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDataResidencyBoundaryValues() []DataResidencyBoundary {
	return original.PossibleDataResidencyBoundaryValues()
}
func PossibleDomainProvisioningStateValues() []DomainProvisioningState {
	return original.PossibleDomainProvisioningStateValues()
}
func PossibleDomainTopicProvisioningStateValues() []DomainTopicProvisioningState {
	return original.PossibleDomainTopicProvisioningStateValues()
}
func PossibleEndpointTypeBasicDeadLetterDestinationValues() []EndpointTypeBasicDeadLetterDestination {
	return original.PossibleEndpointTypeBasicDeadLetterDestinationValues()
}
func PossibleEndpointTypeBasicEventSubscriptionDestinationValues() []EndpointTypeBasicEventSubscriptionDestination {
	return original.PossibleEndpointTypeBasicEventSubscriptionDestinationValues()
}
func PossibleEndpointTypeBasicPartnerUpdateDestinationInfoValues() []EndpointTypeBasicPartnerUpdateDestinationInfo {
	return original.PossibleEndpointTypeBasicPartnerUpdateDestinationInfoValues()
}
func PossibleEndpointTypeValues() []EndpointType {
	return original.PossibleEndpointTypeValues()
}
func PossibleEventChannelProvisioningStateValues() []EventChannelProvisioningState {
	return original.PossibleEventChannelProvisioningStateValues()
}
func PossibleEventDefinitionKindValues() []EventDefinitionKind {
	return original.PossibleEventDefinitionKindValues()
}
func PossibleEventDeliverySchemaValues() []EventDeliverySchema {
	return original.PossibleEventDeliverySchemaValues()
}
func PossibleEventSubscriptionIdentityTypeValues() []EventSubscriptionIdentityType {
	return original.PossibleEventSubscriptionIdentityTypeValues()
}
func PossibleEventSubscriptionProvisioningStateValues() []EventSubscriptionProvisioningState {
	return original.PossibleEventSubscriptionProvisioningStateValues()
}
func PossibleIPActionTypeValues() []IPActionType {
	return original.PossibleIPActionTypeValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleInputSchemaMappingTypeValues() []InputSchemaMappingType {
	return original.PossibleInputSchemaMappingTypeValues()
}
func PossibleInputSchemaValues() []InputSchema {
	return original.PossibleInputSchemaValues()
}
func PossibleOperatorTypeValues() []OperatorType {
	return original.PossibleOperatorTypeValues()
}
func PossibleParentTypeValues() []ParentType {
	return original.PossibleParentTypeValues()
}
func PossiblePartnerConfigurationProvisioningStateValues() []PartnerConfigurationProvisioningState {
	return original.PossiblePartnerConfigurationProvisioningStateValues()
}
func PossiblePartnerDestinationActivationStateValues() []PartnerDestinationActivationState {
	return original.PossiblePartnerDestinationActivationStateValues()
}
func PossiblePartnerDestinationProvisioningStateValues() []PartnerDestinationProvisioningState {
	return original.PossiblePartnerDestinationProvisioningStateValues()
}
func PossiblePartnerNamespaceProvisioningStateValues() []PartnerNamespaceProvisioningState {
	return original.PossiblePartnerNamespaceProvisioningStateValues()
}
func PossiblePartnerRegistrationProvisioningStateValues() []PartnerRegistrationProvisioningState {
	return original.PossiblePartnerRegistrationProvisioningStateValues()
}
func PossiblePartnerRegistrationVisibilityStateValues() []PartnerRegistrationVisibilityState {
	return original.PossiblePartnerRegistrationVisibilityStateValues()
}
func PossiblePartnerTopicActivationStateValues() []PartnerTopicActivationState {
	return original.PossiblePartnerTopicActivationStateValues()
}
func PossiblePartnerTopicProvisioningStateValues() []PartnerTopicProvisioningState {
	return original.PossiblePartnerTopicProvisioningStateValues()
}
func PossiblePartnerTopicReadinessStateValues() []PartnerTopicReadinessState {
	return original.PossiblePartnerTopicReadinessStateValues()
}
func PossiblePartnerTopicRoutingModeValues() []PartnerTopicRoutingMode {
	return original.PossiblePartnerTopicRoutingModeValues()
}
func PossiblePersistedConnectionStatusValues() []PersistedConnectionStatus {
	return original.PossiblePersistedConnectionStatusValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleReadinessStateValues() []ReadinessState {
	return original.PossibleReadinessStateValues()
}
func PossibleResourceKindValues() []ResourceKind {
	return original.PossibleResourceKindValues()
}
func PossibleResourceProvisioningStateValues() []ResourceProvisioningState {
	return original.PossibleResourceProvisioningStateValues()
}
func PossibleResourceRegionTypeValues() []ResourceRegionType {
	return original.PossibleResourceRegionTypeValues()
}
func PossibleSkuValues() []Sku {
	return original.PossibleSkuValues()
}
func PossibleTopicProvisioningStateValues() []TopicProvisioningState {
	return original.PossibleTopicProvisioningStateValues()
}
func PossibleTopicTypeProvisioningStateValues() []TopicTypeProvisioningState {
	return original.PossibleTopicTypeProvisioningStateValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleVerifiedPartnerProvisioningStateValues() []VerifiedPartnerProvisioningState {
	return original.PossibleVerifiedPartnerProvisioningStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
