// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about the account selected as the delegated administrator
// for GuardDuty.
//
// There might be regional differences because some data sources might not be
// available in all the Amazon Web Services Regions where GuardDuty is presently
// supported. For more information, see [Regions and endpoints].
//
// [Regions and endpoints]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html
func (c *Client) DescribeOrganizationConfiguration(ctx context.Context, params *DescribeOrganizationConfigurationInput, optFns ...func(*Options)) (*DescribeOrganizationConfigurationOutput, error) {
	if params == nil {
		params = &DescribeOrganizationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeOrganizationConfiguration", params, optFns, c.addOperationDescribeOrganizationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeOrganizationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeOrganizationConfigurationInput struct {

	// The ID of the detector to retrieve information about the delegated
	// administrator from.
	//
	// This member is required.
	DetectorId *string

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	MaxResults *int32

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls to
	// the action, fill nextToken in the request with the value of NextToken from the
	// previous response to continue listing data.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeOrganizationConfigurationOutput struct {

	// Indicates whether the maximum number of allowed member accounts are already
	// associated with the delegated administrator account for your organization.
	//
	// This member is required.
	MemberAccountLimitReached *bool

	// Indicates whether GuardDuty is automatically enabled for accounts added to the
	// organization.
	//
	// Even though this is still supported, we recommend using
	// AutoEnableOrganizationMembers to achieve the similar results.
	//
	// Deprecated: This field is deprecated, use AutoEnableOrganizationMembers instead
	AutoEnable *bool

	// Indicates the auto-enablement configuration of GuardDuty or any of the
	// corresponding protection plans for the member accounts in the organization.
	//
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have GuardDuty or any of the corresponding protection plans enabled
	//   automatically.
	//
	//   - ALL : Indicates that all accounts in the organization have GuardDuty and any
	//   of the corresponding protection plans enabled automatically. This includes NEW
	//   accounts that join the organization and accounts that may have been suspended or
	//   removed from the organization in GuardDuty.
	//
	//   - NONE : Indicates that GuardDuty or any of the corresponding protection plans
	//   will not be automatically enabled for any account in the organization. The
	//   administrator must manage GuardDuty for each account in the organization
	//   individually.
	//
	// When you update the auto-enable setting from ALL or NEW to NONE , this action
	//   doesn't disable the corresponding option for your existing accounts. This
	//   configuration will apply to the new accounts that join the organization. After
	//   you update the auto-enable settings, no new account will have the corresponding
	//   option as enabled.
	AutoEnableOrganizationMembers types.AutoEnableMembers

	// Describes which data sources are enabled automatically for member accounts.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources *types.OrganizationDataSourceConfigurationsResult

	// A list of features that are configured for this organization.
	Features []types.OrganizationFeatureConfigurationResult

	// The pagination parameter to be used on the next list operation to retrieve more
	// items.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeOrganizationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeOrganizationConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeOrganizationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeOrganizationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeOrganizationConfigurationPaginatorOptions is the paginator options for
// DescribeOrganizationConfiguration
type DescribeOrganizationConfigurationPaginatorOptions struct {
	// You can use this parameter to indicate the maximum number of items that you
	// want in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeOrganizationConfigurationPaginator is a paginator for
// DescribeOrganizationConfiguration
type DescribeOrganizationConfigurationPaginator struct {
	options   DescribeOrganizationConfigurationPaginatorOptions
	client    DescribeOrganizationConfigurationAPIClient
	params    *DescribeOrganizationConfigurationInput
	nextToken *string
	firstPage bool
}

// NewDescribeOrganizationConfigurationPaginator returns a new
// DescribeOrganizationConfigurationPaginator
func NewDescribeOrganizationConfigurationPaginator(client DescribeOrganizationConfigurationAPIClient, params *DescribeOrganizationConfigurationInput, optFns ...func(*DescribeOrganizationConfigurationPaginatorOptions)) *DescribeOrganizationConfigurationPaginator {
	if params == nil {
		params = &DescribeOrganizationConfigurationInput{}
	}

	options := DescribeOrganizationConfigurationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeOrganizationConfigurationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeOrganizationConfigurationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeOrganizationConfiguration page.
func (p *DescribeOrganizationConfigurationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeOrganizationConfigurationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeOrganizationConfiguration(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeOrganizationConfigurationAPIClient is a client that implements the
// DescribeOrganizationConfiguration operation.
type DescribeOrganizationConfigurationAPIClient interface {
	DescribeOrganizationConfiguration(context.Context, *DescribeOrganizationConfigurationInput, ...func(*Options)) (*DescribeOrganizationConfigurationOutput, error)
}

var _ DescribeOrganizationConfigurationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeOrganizationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeOrganizationConfiguration",
	}
}
