/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 28 "parser.y" /* yacc.c:339  */

#include "config.h"

#include <stdlib.h>
#include <string.h>

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;
struct cb_statement		*current_statement = NULL;
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_field		*external_defined_fields_ws;
struct cb_field		*external_defined_fields_global;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

cb_tree				cobc_printer_node = NULL;
int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;

/* Local variables */

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static struct cb_statement	*main_statement;

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static unsigned int		inspect_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static int			call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;
 
static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static const char		*backup_source_file = NULL;
static int			backup_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

static void
begin_statement (const char *name, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable, _("unreachable statement '%s'"), name);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
}

static void
restore_backup_pos (cb_tree item)
{
	item->source_file = backup_source_file;
	item->source_line = backup_source_line;
}

static void
begin_statement_from_backup_pos (const char *name, const unsigned int term)
{
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	restore_backup_pos (CB_TREE (current_statement));
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, CB_TREE (current_statement), _("unreachable statement '%s'"), name);
	}
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (NULL);
	new_statement->common = current_statement->common;
	new_statement->name = current_statement->name;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	current_statement = new_statement;
	main_statement->body = cb_list_add (main_statement->body,
					    CB_TREE (current_statement));
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* functions for storing current position and
   assigning it to a cb_tree after its parsing is finished */
static COB_INLINE
void backup_current_pos (void)
{
	backup_source_file = cb_source_file;
	backup_source_line = cb_source_line;
}

#if 0 /* currently not used */
static COB_INLINE
void set_pos_from_backup (cb_tree x)
{
	x->source_file = backup_source_file;
	x->source_line = backup_source_line;
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		x;
	cb_tree		entry_conv;
	struct cb_field	*f, *ret_f;
	int			param_num;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	param_num = 1;
	for (l = using_list; l; l = CB_CHAIN (l)) {
		x = CB_VALUE (l);
		if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
			f = CB_FIELD (cb_ref (x));
			if (!current_program->flag_chained) {
				if (f->storage != CB_STORAGE_LINKAGE) {
					cb_error_x (x, _("'%s' is not in LINKAGE SECTION"), f->name);
				}
				if (f->flag_item_based || f->flag_external) {
					cb_error_x (x, _("'%s' cannot be BASED/EXTERNAL"), f->name);
				}
				f->flag_is_pdiv_parm = 1;
			} else {
				if (f->storage != CB_STORAGE_WORKING) {
					cb_error_x (x, _("'%s' is not in WORKING-STORAGE SECTION"), f->name);
				}
				f->flag_chained = 1;
				f->param_num = param_num;
				param_num++;
			}
			if (f->level != 01 && f->level != 77) {
				cb_error_x (x, _("'%s' not level 01 or 77"), f->name);
			}
			if (f->redefines) {
				cb_error_x (x, _("'%s' REDEFINES field not allowed here"), f->name);
			}
			/* add a "receiving" entry for the USING parameter */
			if (cb_listing_xref) {
				cobc_xref_link (&f->xref, CB_REFERENCE (x)->common.source_line, 1);
			}
		}
	}


	if (current_program->returning &&
		cb_ref (current_program->returning) != cb_error_node) {
		ret_f = CB_FIELD (cb_ref (current_program->returning));
		if (ret_f->redefines) {
			cb_error_x (current_program->returning,
				_("'%s' REDEFINES field not allowed here"), ret_f->name);
		}
	} else {
		ret_f = NULL;
	}

	/* Check returning item against using items when FUNCTION */
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION && ret_f) {
		for (l = using_list; l; l = CB_CHAIN (l)) {
			x = CB_VALUE (l);
			if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
				f = CB_FIELD (cb_ref (x));
				if (ret_f == f) {
					cb_error_x (x, _("'%s' USING item duplicates RETURNING item"), f->name);
				}
			}
		}
	}

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
	label->source_line = backup_source_line;
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", current_statement->name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static int
literal_value (cb_tree x)
{
	if (x == cb_space) {
		return ' ';
	} else if (x == cb_zero) {
		return '0';
	} else if (x == cb_quote) {
		return cb_flag_apostrophe ? '\'' : '"';
	} else if (x == cb_null) {
		return 0;
	} else if (x == cb_low) {
		return 0;
	} else if (x == cb_high) {
		return 255;
	} else if (CB_TREE_CLASS (x) == CB_CLASS_NUMERIC) {
		return cb_get_int (x);
	} else {
		return CB_LITERAL (x)->data[0];
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

static void
emit_duplicate_clause_message (const char *clause)
{
	/* FIXME: replace by a new warning level that is set
	   to warn/error depending on cb_relaxed_syntax_checks */
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("duplicate %s clause"), clause);
	} else {
		cb_error (_("duplicate %s clause"), clause);
	}
}

static void
check_repeated (const char *clause, const cob_flags_t bitval, cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		*already_seen |= bitval;
	}
}

static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("Cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_relaxed_syntax_checks) {
					cb_warning (COBC_WARN_FILLER, _("TO phrase without DEPENDING phrase"));
					cb_warning (COBC_WARN_FILLER, _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				} else {
					cb_error (_("TO phrase without DEPENDING phrase"));
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
			}
		} else {
			current_field->occurs_max = 0;
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("%s header missing - assumed"), s);
	} else {
		cb_error (_("%s header missing"), s);
	}
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TO-DO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	main_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = 0;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	const char	*elt_name;
	const char	*elt_id;
	cb_tree		l;

	/* Error if a program with the same name has been defined. */
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		elt_name = ((struct cb_program *) CB_VALUE (l))->program_name;
		elt_id = ((struct cb_program *) CB_VALUE (l))->orig_program_id;
		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x ((cb_tree) program,
				    _("redefinition of program name '%s'"),
				    elt_name);
		} else if (strcmp (prog_id, elt_id) == 0) {
		        cb_error_x ((cb_tree) program,
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list,
					 (cb_tree) program);
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l = (struct cb_list *) defined_prog_list;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_entry (program->program_id, 0, NULL, NULL);
		}
	}
	program->last_source_line = backup_source_line;

	if (program->nested_level == 0) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = (struct cb_list *) defined_prog_list;
		while (l) {
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (0 == strcmp (program->orig_program_id,
					 CB_PROGRAM (l->value)->orig_program_id)
			    && program->nested_level == CB_PROGRAM (l->value)->nested_level) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_set_intr_when_compiled ();
		cb_build_registers ();
		cb_add_external_defined_registers ();
	} else {
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}
	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	    && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const int organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
	}

	return 0;
}

/* verifies that no conflicting clauses are used and inherits the definition of the original field */
static void
inherit_same_as ()
{
	/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
	static const cob_flags_t	allowed_clauses =
		SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7;
	cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
	if (tested != SYN_CLAUSE_30) {
		cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"), "SAME AS");
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	} else {
		struct cb_field* fld = CB_FIELD (current_field->same_as);
		current_field = copy_into_field (fld, current_field, 1);
	}
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("cannot specify both %s and %s; %s is ignored"),
			clause, conflicting, clause);
	} else {
		cb_error (_("cannot specify both %s and %s"),
			clause, conflicting);
	}

}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
	current_field->flag_usage_defined = 1;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
			   || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (!(previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & (COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		     | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
		   && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node) {
		return cb_error_node;
	}
	if (!CB_REF_OR_FIELD_P(x)) {
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node; 
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	    || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *x_list)
{
	return (cb_tree) x_list != cb_null
		&& cb_list_length ((cb_tree) x_list) == 1
		&& is_screen_field (x_list->value);
}

static int
contains_only_screen_fields (struct cb_list *x_list)
{
	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (!is_screen_field (x_list->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *x_list)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (is_screen_field (x_list->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (cb_tree x_list, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields ((struct cb_list *) x_list)) {
		if (!contains_one_screen_field ((struct cb_list *) x_list)
		    || attr_ptr) {
			cb_verify_x (x_list, cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens ((struct cb_list *) x_list)) {
		cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (x_list, cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (cb_tree x_list, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (cb_tree x_list, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (x_list, _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	    && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ((last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		     || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		    && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) return;
	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2157 "parser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOKEN_EOF = 0,
    THREEDIMENSIONAL = 258,
    ABSENT = 259,
    ACCEPT = 260,
    ACCESS = 261,
    ACTIVEX = 262,
    ACTION = 263,
    ACTUAL = 264,
    ADD = 265,
    ADDRESS = 266,
    ADJUSTABLE_COLUMNS = 267,
    ADVANCING = 268,
    AFTER = 269,
    ALIGNMENT = 270,
    ALL = 271,
    ALLOCATE = 272,
    ALLOWING = 273,
    ALPHABET = 274,
    ALPHABETIC = 275,
    ALPHABETIC_LOWER = 276,
    ALPHABETIC_UPPER = 277,
    ALPHANUMERIC = 278,
    ALPHANUMERIC_EDITED = 279,
    ALSO = 280,
    ALTER = 281,
    ALTERNATE = 282,
    AND = 283,
    ANY = 284,
    APPLY = 285,
    ARE = 286,
    AREA = 287,
    AREAS = 288,
    ARGUMENT_NUMBER = 289,
    ARGUMENT_VALUE = 290,
    ARITHMETIC = 291,
    AS = 292,
    ASCENDING = 293,
    ASCII = 294,
    ASSIGN = 295,
    AT = 296,
    ATTRIBUTE = 297,
    ATTRIBUTES = 298,
    AUTO = 299,
    AUTO_DECIMAL = 300,
    AUTO_SPIN = 301,
    AUTOMATIC = 302,
    AWAY_FROM_ZERO = 303,
    BACKGROUND_COLOR = 304,
    BACKGROUND_HIGH = 305,
    BACKGROUND_LOW = 306,
    BACKGROUND_STANDARD = 307,
    BAR = 308,
    BASED = 309,
    BEFORE = 310,
    BELL = 311,
    BINARY = 312,
    BINARY_C_LONG = 313,
    BINARY_CHAR = 314,
    BINARY_DOUBLE = 315,
    BINARY_LONG = 316,
    BINARY_SEQUENTIAL = 317,
    BINARY_SHORT = 318,
    BIT = 319,
    BITMAP = 320,
    BITMAP_END = 321,
    BITMAP_HANDLE = 322,
    BITMAP_NUMBER = 323,
    BITMAP_START = 324,
    BITMAP_TIMER = 325,
    BITMAP_TRAILING = 326,
    BITMAP_TRANSPARENT_COLOR = 327,
    BITMAP_WIDTH = 328,
    BLANK = 329,
    BLINK = 330,
    BLOCK = 331,
    BOTTOM = 332,
    BOX = 333,
    BOXED = 334,
    BULK_ADDITION = 335,
    BUSY = 336,
    BUTTONS = 337,
    BY = 338,
    BYTE_LENGTH = 339,
    C = 340,
    CALENDAR_FONT = 341,
    CALL = 342,
    CANCEL = 343,
    CANCEL_BUTTON = 344,
    CAPACITY = 345,
    CARD_PUNCH = 346,
    CARD_READER = 347,
    CASSETTE = 348,
    CCOL = 349,
    CD = 350,
    CELL = 351,
    CELL_COLOR = 352,
    CELL_DATA = 353,
    CELL_FONT = 354,
    CELL_PROTECTION = 355,
    CENTER = 356,
    CENTERED = 357,
    CENTERED_HEADINGS = 358,
    CENTURY_DATE = 359,
    CF = 360,
    CH = 361,
    CHAINING = 362,
    CHARACTER = 363,
    CHARACTERS = 364,
    CHECK_BOX = 365,
    CLASS = 366,
    CLASSIFICATION = 367,
    CLASS_NAME = 368,
    CLEAR_SELECTION = 369,
    CLINE = 370,
    CLINES = 371,
    CLOSE = 372,
    COBOL = 373,
    CODE = 374,
    CODE_SET = 375,
    COLLATING = 376,
    COL = 377,
    COLOR = 378,
    COLORS = 379,
    COLS = 380,
    COLUMN = 381,
    COLUMN_COLOR = 382,
    COLUMN_DIVIDERS = 383,
    COLUMN_FONT = 384,
    COLUMN_HEADINGS = 385,
    COLUMN_PROTECTION = 386,
    COLUMNS = 387,
    COMBO_BOX = 388,
    COMMA = 389,
    COMMAND_LINE = 390,
    COMMA_DELIM = 391,
    COMMIT = 392,
    COMMON = 393,
    COMMUNICATION = 394,
    COMP = 395,
    COMPUTE = 396,
    COMP_0 = 397,
    COMP_1 = 398,
    COMP_2 = 399,
    COMP_3 = 400,
    COMP_4 = 401,
    COMP_5 = 402,
    COMP_6 = 403,
    COMP_N = 404,
    COMP_X = 405,
    CONCATENATE_FUNC = 406,
    CONDITION = 407,
    CONFIGURATION = 408,
    CONSTANT = 409,
    CONTAINS = 410,
    CONTENT = 411,
    CONTENT_LENGTH_FUNC = 412,
    CONTENT_OF_FUNC = 413,
    CONTINUE = 414,
    CONTROL = 415,
    CONTROLS = 416,
    CONVERSION = 417,
    CONVERTING = 418,
    COPY = 419,
    COPY_SELECTION = 420,
    CORE_INDEX = 421,
    CORRESPONDING = 422,
    COUNT = 423,
    CRT = 424,
    CRT_UNDER = 425,
    CSIZE = 426,
    CURRENCY = 427,
    CURRENT_DATE_FUNC = 428,
    CURSOR = 429,
    CURSOR_COL = 430,
    CURSOR_COLOR = 431,
    CURSOR_FRAME_WIDTH = 432,
    CURSOR_ROW = 433,
    CURSOR_X = 434,
    CURSOR_Y = 435,
    CUSTOM_PRINT_TEMPLATE = 436,
    CYCLE = 437,
    CYL_INDEX = 438,
    CYL_OVERFLOW = 439,
    DASHED = 440,
    DATA = 441,
    DATA_COLUMNS = 442,
    DATA_TYPES = 443,
    DATE = 444,
    DATE_ENTRY = 445,
    DAY = 446,
    DAY_OF_WEEK = 447,
    DE = 448,
    DEBUGGING = 449,
    DECIMAL_POINT = 450,
    DECLARATIVES = 451,
    DEFAULT = 452,
    DEFAULT_BUTTON = 453,
    DEFAULT_FONT = 454,
    DELETE = 455,
    DELIMITED = 456,
    DELIMITER = 457,
    DEPENDING = 458,
    DESCENDING = 459,
    DESTINATION = 460,
    DESTROY = 461,
    DETAIL = 462,
    DISABLE = 463,
    DISC = 464,
    DISK = 465,
    DISP = 466,
    DISPLAY = 467,
    DISPLAY_COLUMNS = 468,
    DISPLAY_FORMAT = 469,
    DISPLAY_OF_FUNC = 470,
    DIVIDE = 471,
    DIVIDERS = 472,
    DIVIDER_COLOR = 473,
    DIVISION = 474,
    DOTDASH = 475,
    DOTTED = 476,
    DRAG_COLOR = 477,
    DROP_DOWN = 478,
    DROP_LIST = 479,
    DOWN = 480,
    DUPLICATES = 481,
    DYNAMIC = 482,
    EBCDIC = 483,
    EC = 484,
    ECHO = 485,
    EGI = 486,
    EIGHTY_EIGHT = 487,
    ENABLE = 488,
    ENABLED = 489,
    ELEMENT = 490,
    ELSE = 491,
    EMI = 492,
    ENCRYPTION = 493,
    ENCODING = 494,
    END = 495,
    END_ACCEPT = 496,
    END_ADD = 497,
    END_CALL = 498,
    END_COMPUTE = 499,
    END_COLOR = 500,
    END_DELETE = 501,
    END_DISPLAY = 502,
    END_DIVIDE = 503,
    END_EVALUATE = 504,
    END_FUNCTION = 505,
    END_IF = 506,
    END_JSON = 507,
    END_MODIFY = 508,
    END_MULTIPLY = 509,
    END_PERFORM = 510,
    END_PROGRAM = 511,
    END_READ = 512,
    END_RECEIVE = 513,
    END_RETURN = 514,
    END_REWRITE = 515,
    END_SEARCH = 516,
    END_START = 517,
    END_STRING = 518,
    END_SUBTRACT = 519,
    END_UNSTRING = 520,
    END_WRITE = 521,
    END_XML = 522,
    ENGRAVED = 523,
    ENSURE_VISIBLE = 524,
    ENTRY = 525,
    ENTRY_CONVENTION = 526,
    ENTRY_FIELD = 527,
    ENTRY_REASON = 528,
    ENVIRONMENT = 529,
    ENVIRONMENT_NAME = 530,
    ENVIRONMENT_VALUE = 531,
    EOL = 532,
    EOP = 533,
    EOS = 534,
    EQUAL = 535,
    ERASE = 536,
    ERROR = 537,
    ESCAPE = 538,
    ESCAPE_BUTTON = 539,
    ESI = 540,
    EVALUATE = 541,
    EVENT = 542,
    EVENT_LIST = 543,
    EVENT_STATUS = 544,
    EVERY = 545,
    EXCEPTION = 546,
    EXCEPTION_CONDITION = 547,
    EXCEPTION_VALUE = 548,
    EXPAND = 549,
    EXCLUSIVE = 550,
    EXIT = 551,
    EXPONENTIATION = 552,
    EXTEND = 553,
    EXTENDED_SEARCH = 554,
    EXTERNAL = 555,
    EXTERNAL_FORM = 556,
    F = 557,
    FD = 558,
    FH__FCD = 559,
    FH__KEYDEF = 560,
    FILE_CONTROL = 561,
    FILE_ID = 562,
    FILE_LIMIT = 563,
    FILE_LIMITS = 564,
    FILE_NAME = 565,
    FILE_POS = 566,
    FILL_COLOR = 567,
    FILL_COLOR2 = 568,
    FILL_PERCENT = 569,
    FILLER = 570,
    FINAL = 571,
    FINISH_REASON = 572,
    FIRST = 573,
    FIXED = 574,
    FIXED_FONT = 575,
    FIXED_WIDTH = 576,
    FLAT = 577,
    FLAT_BUTTONS = 578,
    FLOAT_BINARY_128 = 579,
    FLOAT_BINARY_32 = 580,
    FLOAT_BINARY_64 = 581,
    FLOAT_DECIMAL_16 = 582,
    FLOAT_DECIMAL_34 = 583,
    FLOAT_DECIMAL_7 = 584,
    FLOAT_EXTENDED = 585,
    FLOAT_LONG = 586,
    FLOAT_SHORT = 587,
    FLOATING = 588,
    FONT = 589,
    FOOTING = 590,
    FOR = 591,
    FOREGROUND_COLOR = 592,
    FOREVER = 593,
    FORMATTED_DATE_FUNC = 594,
    FORMATTED_DATETIME_FUNC = 595,
    FORMATTED_TIME_FUNC = 596,
    FRAME = 597,
    FRAMED = 598,
    FREE = 599,
    FROM = 600,
    FROM_CRT = 601,
    FULL = 602,
    FULL_HEIGHT = 603,
    FUNCTION = 604,
    FUNCTION_ID = 605,
    FUNCTION_NAME = 606,
    GENERATE = 607,
    GIVING = 608,
    GLOBAL = 609,
    GO = 610,
    GO_BACK = 611,
    GO_FORWARD = 612,
    GO_HOME = 613,
    GO_SEARCH = 614,
    GOBACK = 615,
    GRAPHICAL = 616,
    GREATER = 617,
    GREATER_OR_EQUAL = 618,
    GRID = 619,
    GROUP = 620,
    GROUP_VALUE = 621,
    HANDLE = 622,
    HAS_CHILDREN = 623,
    HEADING = 624,
    HEADING_COLOR = 625,
    HEADING_DIVIDER_COLOR = 626,
    HEADING_FONT = 627,
    HEAVY = 628,
    HEIGHT_IN_CELLS = 629,
    HELP_ID = 630,
    HIDDEN_DATA = 631,
    HIGHLIGHT = 632,
    HIGH_COLOR = 633,
    HIGH_VALUE = 634,
    HOT_TRACK = 635,
    HSCROLL = 636,
    HSCROLL_POS = 637,
    ICON = 638,
    ID = 639,
    IDENTIFIED = 640,
    IDENTIFICATION = 641,
    IF = 642,
    IGNORE = 643,
    IGNORING = 644,
    IN = 645,
    INDEPENDENT = 646,
    INDEX = 647,
    INDEXED = 648,
    INDICATE = 649,
    INITIALIZE = 650,
    INITIALIZED = 651,
    INITIATE = 652,
    INPUT = 653,
    INPUT_OUTPUT = 654,
    INQUIRE = 655,
    INSERTION_INDEX = 656,
    INSERT_ROWS = 657,
    INSPECT = 658,
    INTERMEDIATE = 659,
    INTO = 660,
    INTRINSIC = 661,
    INVALID = 662,
    INVALID_KEY = 663,
    IS = 664,
    ITEM = 665,
    ITEM_TEXT = 666,
    ITEM_TO_ADD = 667,
    ITEM_TO_DELETE = 668,
    ITEM_TO_EMPTY = 669,
    ITEM_VALUE = 670,
    I_O = 671,
    I_O_CONTROL = 672,
    JSON = 673,
    JUSTIFIED = 674,
    KEPT = 675,
    KEY = 676,
    KEYBOARD = 677,
    LABEL = 678,
    LABEL_OFFSET = 679,
    LARGE_FONT = 680,
    LARGE_OFFSET = 681,
    LAST = 682,
    LAST_ROW = 683,
    LAYOUT_DATA = 684,
    LAYOUT_MANAGER = 685,
    LEADING = 686,
    LEADING_SHIFT = 687,
    LEAVE = 688,
    LEFT = 689,
    LEFTLINE = 690,
    LEFT_TEXT = 691,
    LENGTH = 692,
    LENGTH_OF = 693,
    LENGTH_FUNC = 694,
    LESS = 695,
    LESS_OR_EQUAL = 696,
    LEVEL_NUMBER = 697,
    LIMIT = 698,
    LIMITS = 699,
    LINAGE = 700,
    LINAGE_COUNTER = 701,
    LINE = 702,
    LINE_COUNTER = 703,
    LINE_LIMIT = 704,
    LINE_SEQUENTIAL = 705,
    LINES = 706,
    LINES_AT_ROOT = 707,
    LINKAGE = 708,
    LIST_BOX = 709,
    LITERAL = 710,
    LM_RESIZE = 711,
    LOC = 712,
    LOCALE = 713,
    LOCALE_DATE_FUNC = 714,
    LOCALE_TIME_FUNC = 715,
    LOCALE_TIME_FROM_FUNC = 716,
    LOCAL_STORAGE = 717,
    LOCK = 718,
    LOCK_HOLDING = 719,
    LONG_DATE = 720,
    LOWER = 721,
    LOWERED = 722,
    LOWER_CASE_FUNC = 723,
    LOWLIGHT = 724,
    LOW_COLOR = 725,
    LOW_VALUE = 726,
    MAGNETIC_TAPE = 727,
    MANUAL = 728,
    MASS_UPDATE = 729,
    MASTER_INDEX = 730,
    MAX_LINES = 731,
    MAX_PROGRESS = 732,
    MAX_TEXT = 733,
    MAX_VAL = 734,
    MEMORY = 735,
    MEDIUM_FONT = 736,
    MENU = 737,
    MERGE = 738,
    MESSAGE = 739,
    MINUS = 740,
    MIN_VAL = 741,
    MNEMONIC_NAME = 742,
    MODE = 743,
    MODIFY = 744,
    MODULES = 745,
    MOVE = 746,
    MULTILINE = 747,
    MULTIPLE = 748,
    MULTIPLY = 749,
    NAME = 750,
    NAMESPACE = 751,
    NAMESPACE_PREFIX = 752,
    NATIONAL = 753,
    NATIONAL_EDITED = 754,
    NATIONAL_OF_FUNC = 755,
    NATIVE = 756,
    NAVIGATE_URL = 757,
    NEAREST_AWAY_FROM_ZERO = 758,
    NEAREST_EVEN = 759,
    NEAREST_TOWARD_ZERO = 760,
    NEGATIVE = 761,
    NESTED = 762,
    NEW = 763,
    NEXT = 764,
    NEXT_ITEM = 765,
    NEXT_GROUP = 766,
    NEXT_PAGE = 767,
    NO = 768,
    NO_ADVANCING = 769,
    NO_AUTOSEL = 770,
    NO_AUTO_DEFAULT = 771,
    NO_BOX = 772,
    NO_DATA = 773,
    NO_DIVIDERS = 774,
    NO_ECHO = 775,
    NO_F4 = 776,
    NO_FOCUS = 777,
    NO_GROUP_TAB = 778,
    NO_KEY_LETTER = 779,
    NOMINAL = 780,
    NO_SEARCH = 781,
    NO_UPDOWN = 782,
    NONNUMERIC = 783,
    NORMAL = 784,
    NOT = 785,
    NOTAB = 786,
    NOTHING = 787,
    NOTIFY = 788,
    NOTIFY_CHANGE = 789,
    NOTIFY_DBLCLICK = 790,
    NOTIFY_SELCHANGE = 791,
    NOT_END = 792,
    NOT_EOP = 793,
    NOT_ESCAPE = 794,
    NOT_EQUAL = 795,
    NOT_EXCEPTION = 796,
    NOT_INVALID_KEY = 797,
    NOT_OVERFLOW = 798,
    NOT_SIZE_ERROR = 799,
    NUM_COL_HEADINGS = 800,
    NUM_ROWS = 801,
    NUMBER = 802,
    NUMBERS = 803,
    NUMERIC = 804,
    NUMERIC_EDITED = 805,
    NUMVALC_FUNC = 806,
    OBJECT = 807,
    OBJECT_COMPUTER = 808,
    OCCURS = 809,
    OF = 810,
    OFF = 811,
    OK_BUTTON = 812,
    OMITTED = 813,
    ON = 814,
    ONLY = 815,
    OPEN = 816,
    OPTIONAL = 817,
    OPTIONS = 818,
    OR = 819,
    ORDER = 820,
    ORGANIZATION = 821,
    OTHER = 822,
    OTHERS = 823,
    OUTPUT = 824,
    OVERLAP_LEFT = 825,
    OVERLAP_TOP = 826,
    OVERLINE = 827,
    PACKED_DECIMAL = 828,
    PADDING = 829,
    PASCAL = 830,
    PAGE = 831,
    PAGE_COUNTER = 832,
    PAGE_SETUP = 833,
    PAGED = 834,
    PARAGRAPH = 835,
    PARENT = 836,
    PARSE = 837,
    PASSWORD = 838,
    PERFORM = 839,
    PERMANENT = 840,
    PH = 841,
    PF = 842,
    PHYSICAL = 843,
    PICTURE = 844,
    PICTURE_SYMBOL = 845,
    PIXEL = 846,
    PLACEMENT = 847,
    PLUS = 848,
    POINTER = 849,
    POP_UP = 850,
    POS = 851,
    POSITION = 852,
    POSITION_SHIFT = 853,
    POSITIVE = 854,
    PRESENT = 855,
    PREVIOUS = 856,
    PRINT = 857,
    PRINT_CONTROL = 858,
    PRINT_NO_PROMPT = 859,
    PRINT_PREVIEW = 860,
    PRINTER = 861,
    PRINTER_1 = 862,
    PRINTING = 863,
    PRIORITY = 864,
    PROCEDURE = 865,
    PROCEDURES = 866,
    PROCEED = 867,
    PROCESSING = 868,
    PROGRAM = 869,
    PROGRAM_ID = 870,
    PROGRAM_NAME = 871,
    PROGRAM_POINTER = 872,
    PROGRESS = 873,
    PROHIBITED = 874,
    PROMPT = 875,
    PROPERTIES = 876,
    PROPERTY = 877,
    PROTECTED = 878,
    PROTOTYPE = 879,
    PURGE = 880,
    PUSH_BUTTON = 881,
    QUERY_INDEX = 882,
    QUEUE = 883,
    QUOTE = 884,
    RADIO_BUTTON = 885,
    RAISE = 886,
    RAISED = 887,
    RANDOM = 888,
    RD = 889,
    READ = 890,
    READERS = 891,
    READ_ONLY = 892,
    READY_TRACE = 893,
    RECEIVE = 894,
    RECORD = 895,
    RECORD_DATA = 896,
    RECORD_OVERFLOW = 897,
    RECORD_TO_ADD = 898,
    RECORD_TO_DELETE = 899,
    RECORDING = 900,
    RECORDS = 901,
    RECURSIVE = 902,
    REDEFINES = 903,
    REEL = 904,
    REFERENCE = 905,
    REFERENCES = 906,
    REFRESH = 907,
    REGION_COLOR = 908,
    RELATIVE = 909,
    RELEASE = 910,
    REMAINDER = 911,
    REMOVAL = 912,
    RENAMES = 913,
    REORG_CRITERIA = 914,
    REPLACE = 915,
    REPLACING = 916,
    REPORT = 917,
    REPORTING = 918,
    REPORTS = 919,
    REPOSITORY = 920,
    REQUIRED = 921,
    REREAD = 922,
    RERUN = 923,
    RESERVE = 924,
    RESET = 925,
    RESET_TRACE = 926,
    RESET_GRID = 927,
    RESET_LIST = 928,
    RESET_TABS = 929,
    RESIDENT = 930,
    RETRY = 931,
    RETURN = 932,
    RETURNING = 933,
    REVERSE = 934,
    REVERSE_FUNC = 935,
    REVERSE_VIDEO = 936,
    REVERSED = 937,
    REWIND = 938,
    REWRITE = 939,
    RF = 940,
    RH = 941,
    RIGHT = 942,
    RIGHT_ALIGN = 943,
    RIMMED = 944,
    ROLLBACK = 945,
    ROUNDED = 946,
    ROUNDING = 947,
    ROW_COLOR = 948,
    ROW_COLOR_PATTERN = 949,
    ROW_DIVIDERS = 950,
    ROW_FONT = 951,
    ROW_HEADINGS = 952,
    ROW_PROTECTION = 953,
    RUN = 954,
    S = 955,
    SAME = 956,
    SAVE_AS = 957,
    SAVE_AS_NO_PROMPT = 958,
    SCREEN = 959,
    SCREEN_CONTROL = 960,
    SCROLL = 961,
    SCROLL_BAR = 962,
    SD = 963,
    SEARCH = 964,
    SEARCH_OPTIONS = 965,
    SEARCH_TEXT = 966,
    SECONDS = 967,
    SECTION = 968,
    SECURE = 969,
    SEGMENT = 970,
    SEGMENT_LIMIT = 971,
    SELECT = 972,
    SELECTION_INDEX = 973,
    SELECTION_TEXT = 974,
    SELECT_ALL = 975,
    SELF_ACT = 976,
    SEMI_COLON = 977,
    SEND = 978,
    SENTENCE = 979,
    SEPARATE = 980,
    SEPARATION = 981,
    SEQUENCE = 982,
    SEQUENTIAL = 983,
    SET = 984,
    SEVENTY_EIGHT = 985,
    SHADING = 986,
    SHADOW = 987,
    SHARING = 988,
    SHORT_DATE = 989,
    SHOW_LINES = 990,
    SHOW_NONE = 991,
    SHOW_SEL_ALWAYS = 992,
    SIGN = 993,
    SIGNED = 994,
    SIGNED_INT = 995,
    SIGNED_LONG = 996,
    SIGNED_SHORT = 997,
    SIXTY_SIX = 998,
    SIZE = 999,
    SIZE_ERROR = 1000,
    SMALL_FONT = 1001,
    SORT = 1002,
    SORT_MERGE = 1003,
    SORT_ORDER = 1004,
    SOURCE = 1005,
    SOURCE_COMPUTER = 1006,
    SPACE = 1007,
    SPECIAL_NAMES = 1008,
    SPINNER = 1009,
    SQUARE = 1010,
    STANDARD = 1011,
    STANDARD_1 = 1012,
    STANDARD_2 = 1013,
    STANDARD_BINARY = 1014,
    STANDARD_DECIMAL = 1015,
    START = 1016,
    START_X = 1017,
    START_Y = 1018,
    STATIC = 1019,
    STATIC_LIST = 1020,
    STATUS = 1021,
    STATUS_BAR = 1022,
    STATUS_TEXT = 1023,
    STDCALL = 1024,
    STEP = 1025,
    STOP = 1026,
    STRING = 1027,
    STYLE = 1028,
    SUB_QUEUE_1 = 1029,
    SUB_QUEUE_2 = 1030,
    SUB_QUEUE_3 = 1031,
    SUBSTITUTE_FUNC = 1032,
    SUBSTITUTE_CASE_FUNC = 1033,
    SUBTRACT = 1034,
    SUBWINDOW = 1035,
    SUM = 1036,
    SUPPRESS = 1037,
    SUPPRESS_XML = 1038,
    SYMBOLIC = 1039,
    SYNCHRONIZED = 1040,
    SYSTEM_DEFAULT = 1041,
    SYSTEM_INFO = 1042,
    SYSTEM_OFFSET = 1043,
    TAB = 1044,
    TAB_TO_ADD = 1045,
    TAB_TO_DELETE = 1046,
    TABLE = 1047,
    TALLYING = 1048,
    TEMPORARY = 1049,
    TAPE = 1050,
    TERMINAL = 1051,
    TERMINATE = 1052,
    TERMINAL_INFO = 1053,
    TERMINATION_VALUE = 1054,
    TEST = 1055,
    TEXT = 1056,
    THAN = 1057,
    THEN = 1058,
    THREAD = 1059,
    THREADS = 1060,
    THRU = 1061,
    THUMB_POSITION = 1062,
    TILED_HEADINGS = 1063,
    TIME = 1064,
    TIME_OUT = 1065,
    TIMES = 1066,
    TITLE = 1067,
    TITLE_POSITION = 1068,
    TO = 1069,
    TOK_AMPER = 1070,
    TOK_CLOSE_PAREN = 1071,
    TOK_COLON = 1072,
    TOK_DIV = 1073,
    TOK_DOT = 1074,
    TOK_EQUAL = 1075,
    TOK_EXTERN = 1076,
    TOK_FALSE = 1077,
    TOK_FILE = 1078,
    TOK_GREATER = 1079,
    TOK_INITIAL = 1080,
    TOK_LESS = 1081,
    TOK_MINUS = 1082,
    TOK_MUL = 1083,
    TOK_NULL = 1084,
    TOK_OVERFLOW = 1085,
    TOK_OPEN_PAREN = 1086,
    TOK_PLUS = 1087,
    TOK_TRUE = 1088,
    TOP = 1089,
    TOWARD_GREATER = 1090,
    TOWARD_LESSER = 1091,
    TRACK = 1092,
    TRACKS = 1093,
    TRACK_AREA = 1094,
    TRACK_LIMIT = 1095,
    TRADITIONAL_FONT = 1096,
    TRAILING = 1097,
    TRAILING_SHIFT = 1098,
    TRANSACTION = 1099,
    TRANSFORM = 1100,
    TRANSPARENT = 1101,
    TREE_VIEW = 1102,
    TRIM_FUNC = 1103,
    TRUNCATION = 1104,
    TYPE = 1105,
    U = 1106,
    UCS_4 = 1107,
    UNBOUNDED = 1108,
    UNDERLINE = 1109,
    UNFRAMED = 1110,
    UNIT = 1111,
    UNLOCK = 1112,
    UNSIGNED = 1113,
    UNSIGNED_INT = 1114,
    UNSIGNED_LONG = 1115,
    UNSIGNED_SHORT = 1116,
    UNSORTED = 1117,
    UNSTRING = 1118,
    UNTIL = 1119,
    UP = 1120,
    UPDATE = 1121,
    UPDATERS = 1122,
    UPON = 1123,
    UPON_ARGUMENT_NUMBER = 1124,
    UPON_COMMAND_LINE = 1125,
    UPON_ENVIRONMENT_NAME = 1126,
    UPON_ENVIRONMENT_VALUE = 1127,
    UPPER = 1128,
    UPPER_CASE_FUNC = 1129,
    USAGE = 1130,
    USE = 1131,
    USE_ALT = 1132,
    USE_RETURN = 1133,
    USE_TAB = 1134,
    USER = 1135,
    USER_DEFAULT = 1136,
    USER_FUNCTION_NAME = 1137,
    USING = 1138,
    UTF_8 = 1139,
    UTF_16 = 1140,
    V = 1141,
    VALIDATE = 1142,
    VALIDATING = 1143,
    VALUE = 1144,
    VALUE_FORMAT = 1145,
    VARIABLE = 1146,
    VARIANT = 1147,
    VARYING = 1148,
    VERTICAL = 1149,
    VERY_HEAVY = 1150,
    VIRTUAL_WIDTH = 1151,
    VISIBLE = 1152,
    VOLATILE = 1153,
    VPADDING = 1154,
    VSCROLL = 1155,
    VSCROLL_BAR = 1156,
    VSCROLL_POS = 1157,
    VTOP = 1158,
    WAIT = 1159,
    WEB_BROWSER = 1160,
    WHEN = 1161,
    WHEN_COMPILED_FUNC = 1162,
    WHEN_XML = 1163,
    WIDTH = 1164,
    WIDTH_IN_CELLS = 1165,
    WINDOW = 1166,
    WITH = 1167,
    WORD = 1168,
    WORDS = 1169,
    WORKING_STORAGE = 1170,
    WRAP = 1171,
    WRITE = 1172,
    WRITE_ONLY = 1173,
    WRITE_VERIFY = 1174,
    WRITERS = 1175,
    X = 1176,
    XML = 1177,
    XML_DECLARATION = 1178,
    Y = 1179,
    YYYYDDD = 1180,
    YYYYMMDD = 1181,
    ZERO = 1182,
    SHIFT_PREFER = 1183
  };
#endif
/* Tokens.  */
#define TOKEN_EOF 0
#define THREEDIMENSIONAL 258
#define ABSENT 259
#define ACCEPT 260
#define ACCESS 261
#define ACTIVEX 262
#define ACTION 263
#define ACTUAL 264
#define ADD 265
#define ADDRESS 266
#define ADJUSTABLE_COLUMNS 267
#define ADVANCING 268
#define AFTER 269
#define ALIGNMENT 270
#define ALL 271
#define ALLOCATE 272
#define ALLOWING 273
#define ALPHABET 274
#define ALPHABETIC 275
#define ALPHABETIC_LOWER 276
#define ALPHABETIC_UPPER 277
#define ALPHANUMERIC 278
#define ALPHANUMERIC_EDITED 279
#define ALSO 280
#define ALTER 281
#define ALTERNATE 282
#define AND 283
#define ANY 284
#define APPLY 285
#define ARE 286
#define AREA 287
#define AREAS 288
#define ARGUMENT_NUMBER 289
#define ARGUMENT_VALUE 290
#define ARITHMETIC 291
#define AS 292
#define ASCENDING 293
#define ASCII 294
#define ASSIGN 295
#define AT 296
#define ATTRIBUTE 297
#define ATTRIBUTES 298
#define AUTO 299
#define AUTO_DECIMAL 300
#define AUTO_SPIN 301
#define AUTOMATIC 302
#define AWAY_FROM_ZERO 303
#define BACKGROUND_COLOR 304
#define BACKGROUND_HIGH 305
#define BACKGROUND_LOW 306
#define BACKGROUND_STANDARD 307
#define BAR 308
#define BASED 309
#define BEFORE 310
#define BELL 311
#define BINARY 312
#define BINARY_C_LONG 313
#define BINARY_CHAR 314
#define BINARY_DOUBLE 315
#define BINARY_LONG 316
#define BINARY_SEQUENTIAL 317
#define BINARY_SHORT 318
#define BIT 319
#define BITMAP 320
#define BITMAP_END 321
#define BITMAP_HANDLE 322
#define BITMAP_NUMBER 323
#define BITMAP_START 324
#define BITMAP_TIMER 325
#define BITMAP_TRAILING 326
#define BITMAP_TRANSPARENT_COLOR 327
#define BITMAP_WIDTH 328
#define BLANK 329
#define BLINK 330
#define BLOCK 331
#define BOTTOM 332
#define BOX 333
#define BOXED 334
#define BULK_ADDITION 335
#define BUSY 336
#define BUTTONS 337
#define BY 338
#define BYTE_LENGTH 339
#define C 340
#define CALENDAR_FONT 341
#define CALL 342
#define CANCEL 343
#define CANCEL_BUTTON 344
#define CAPACITY 345
#define CARD_PUNCH 346
#define CARD_READER 347
#define CASSETTE 348
#define CCOL 349
#define CD 350
#define CELL 351
#define CELL_COLOR 352
#define CELL_DATA 353
#define CELL_FONT 354
#define CELL_PROTECTION 355
#define CENTER 356
#define CENTERED 357
#define CENTERED_HEADINGS 358
#define CENTURY_DATE 359
#define CF 360
#define CH 361
#define CHAINING 362
#define CHARACTER 363
#define CHARACTERS 364
#define CHECK_BOX 365
#define CLASS 366
#define CLASSIFICATION 367
#define CLASS_NAME 368
#define CLEAR_SELECTION 369
#define CLINE 370
#define CLINES 371
#define CLOSE 372
#define COBOL 373
#define CODE 374
#define CODE_SET 375
#define COLLATING 376
#define COL 377
#define COLOR 378
#define COLORS 379
#define COLS 380
#define COLUMN 381
#define COLUMN_COLOR 382
#define COLUMN_DIVIDERS 383
#define COLUMN_FONT 384
#define COLUMN_HEADINGS 385
#define COLUMN_PROTECTION 386
#define COLUMNS 387
#define COMBO_BOX 388
#define COMMA 389
#define COMMAND_LINE 390
#define COMMA_DELIM 391
#define COMMIT 392
#define COMMON 393
#define COMMUNICATION 394
#define COMP 395
#define COMPUTE 396
#define COMP_0 397
#define COMP_1 398
#define COMP_2 399
#define COMP_3 400
#define COMP_4 401
#define COMP_5 402
#define COMP_6 403
#define COMP_N 404
#define COMP_X 405
#define CONCATENATE_FUNC 406
#define CONDITION 407
#define CONFIGURATION 408
#define CONSTANT 409
#define CONTAINS 410
#define CONTENT 411
#define CONTENT_LENGTH_FUNC 412
#define CONTENT_OF_FUNC 413
#define CONTINUE 414
#define CONTROL 415
#define CONTROLS 416
#define CONVERSION 417
#define CONVERTING 418
#define COPY 419
#define COPY_SELECTION 420
#define CORE_INDEX 421
#define CORRESPONDING 422
#define COUNT 423
#define CRT 424
#define CRT_UNDER 425
#define CSIZE 426
#define CURRENCY 427
#define CURRENT_DATE_FUNC 428
#define CURSOR 429
#define CURSOR_COL 430
#define CURSOR_COLOR 431
#define CURSOR_FRAME_WIDTH 432
#define CURSOR_ROW 433
#define CURSOR_X 434
#define CURSOR_Y 435
#define CUSTOM_PRINT_TEMPLATE 436
#define CYCLE 437
#define CYL_INDEX 438
#define CYL_OVERFLOW 439
#define DASHED 440
#define DATA 441
#define DATA_COLUMNS 442
#define DATA_TYPES 443
#define DATE 444
#define DATE_ENTRY 445
#define DAY 446
#define DAY_OF_WEEK 447
#define DE 448
#define DEBUGGING 449
#define DECIMAL_POINT 450
#define DECLARATIVES 451
#define DEFAULT 452
#define DEFAULT_BUTTON 453
#define DEFAULT_FONT 454
#define DELETE 455
#define DELIMITED 456
#define DELIMITER 457
#define DEPENDING 458
#define DESCENDING 459
#define DESTINATION 460
#define DESTROY 461
#define DETAIL 462
#define DISABLE 463
#define DISC 464
#define DISK 465
#define DISP 466
#define DISPLAY 467
#define DISPLAY_COLUMNS 468
#define DISPLAY_FORMAT 469
#define DISPLAY_OF_FUNC 470
#define DIVIDE 471
#define DIVIDERS 472
#define DIVIDER_COLOR 473
#define DIVISION 474
#define DOTDASH 475
#define DOTTED 476
#define DRAG_COLOR 477
#define DROP_DOWN 478
#define DROP_LIST 479
#define DOWN 480
#define DUPLICATES 481
#define DYNAMIC 482
#define EBCDIC 483
#define EC 484
#define ECHO 485
#define EGI 486
#define EIGHTY_EIGHT 487
#define ENABLE 488
#define ENABLED 489
#define ELEMENT 490
#define ELSE 491
#define EMI 492
#define ENCRYPTION 493
#define ENCODING 494
#define END 495
#define END_ACCEPT 496
#define END_ADD 497
#define END_CALL 498
#define END_COMPUTE 499
#define END_COLOR 500
#define END_DELETE 501
#define END_DISPLAY 502
#define END_DIVIDE 503
#define END_EVALUATE 504
#define END_FUNCTION 505
#define END_IF 506
#define END_JSON 507
#define END_MODIFY 508
#define END_MULTIPLY 509
#define END_PERFORM 510
#define END_PROGRAM 511
#define END_READ 512
#define END_RECEIVE 513
#define END_RETURN 514
#define END_REWRITE 515
#define END_SEARCH 516
#define END_START 517
#define END_STRING 518
#define END_SUBTRACT 519
#define END_UNSTRING 520
#define END_WRITE 521
#define END_XML 522
#define ENGRAVED 523
#define ENSURE_VISIBLE 524
#define ENTRY 525
#define ENTRY_CONVENTION 526
#define ENTRY_FIELD 527
#define ENTRY_REASON 528
#define ENVIRONMENT 529
#define ENVIRONMENT_NAME 530
#define ENVIRONMENT_VALUE 531
#define EOL 532
#define EOP 533
#define EOS 534
#define EQUAL 535
#define ERASE 536
#define ERROR 537
#define ESCAPE 538
#define ESCAPE_BUTTON 539
#define ESI 540
#define EVALUATE 541
#define EVENT 542
#define EVENT_LIST 543
#define EVENT_STATUS 544
#define EVERY 545
#define EXCEPTION 546
#define EXCEPTION_CONDITION 547
#define EXCEPTION_VALUE 548
#define EXPAND 549
#define EXCLUSIVE 550
#define EXIT 551
#define EXPONENTIATION 552
#define EXTEND 553
#define EXTENDED_SEARCH 554
#define EXTERNAL 555
#define EXTERNAL_FORM 556
#define F 557
#define FD 558
#define FH__FCD 559
#define FH__KEYDEF 560
#define FILE_CONTROL 561
#define FILE_ID 562
#define FILE_LIMIT 563
#define FILE_LIMITS 564
#define FILE_NAME 565
#define FILE_POS 566
#define FILL_COLOR 567
#define FILL_COLOR2 568
#define FILL_PERCENT 569
#define FILLER 570
#define FINAL 571
#define FINISH_REASON 572
#define FIRST 573
#define FIXED 574
#define FIXED_FONT 575
#define FIXED_WIDTH 576
#define FLAT 577
#define FLAT_BUTTONS 578
#define FLOAT_BINARY_128 579
#define FLOAT_BINARY_32 580
#define FLOAT_BINARY_64 581
#define FLOAT_DECIMAL_16 582
#define FLOAT_DECIMAL_34 583
#define FLOAT_DECIMAL_7 584
#define FLOAT_EXTENDED 585
#define FLOAT_LONG 586
#define FLOAT_SHORT 587
#define FLOATING 588
#define FONT 589
#define FOOTING 590
#define FOR 591
#define FOREGROUND_COLOR 592
#define FOREVER 593
#define FORMATTED_DATE_FUNC 594
#define FORMATTED_DATETIME_FUNC 595
#define FORMATTED_TIME_FUNC 596
#define FRAME 597
#define FRAMED 598
#define FREE 599
#define FROM 600
#define FROM_CRT 601
#define FULL 602
#define FULL_HEIGHT 603
#define FUNCTION 604
#define FUNCTION_ID 605
#define FUNCTION_NAME 606
#define GENERATE 607
#define GIVING 608
#define GLOBAL 609
#define GO 610
#define GO_BACK 611
#define GO_FORWARD 612
#define GO_HOME 613
#define GO_SEARCH 614
#define GOBACK 615
#define GRAPHICAL 616
#define GREATER 617
#define GREATER_OR_EQUAL 618
#define GRID 619
#define GROUP 620
#define GROUP_VALUE 621
#define HANDLE 622
#define HAS_CHILDREN 623
#define HEADING 624
#define HEADING_COLOR 625
#define HEADING_DIVIDER_COLOR 626
#define HEADING_FONT 627
#define HEAVY 628
#define HEIGHT_IN_CELLS 629
#define HELP_ID 630
#define HIDDEN_DATA 631
#define HIGHLIGHT 632
#define HIGH_COLOR 633
#define HIGH_VALUE 634
#define HOT_TRACK 635
#define HSCROLL 636
#define HSCROLL_POS 637
#define ICON 638
#define ID 639
#define IDENTIFIED 640
#define IDENTIFICATION 641
#define IF 642
#define IGNORE 643
#define IGNORING 644
#define IN 645
#define INDEPENDENT 646
#define INDEX 647
#define INDEXED 648
#define INDICATE 649
#define INITIALIZE 650
#define INITIALIZED 651
#define INITIATE 652
#define INPUT 653
#define INPUT_OUTPUT 654
#define INQUIRE 655
#define INSERTION_INDEX 656
#define INSERT_ROWS 657
#define INSPECT 658
#define INTERMEDIATE 659
#define INTO 660
#define INTRINSIC 661
#define INVALID 662
#define INVALID_KEY 663
#define IS 664
#define ITEM 665
#define ITEM_TEXT 666
#define ITEM_TO_ADD 667
#define ITEM_TO_DELETE 668
#define ITEM_TO_EMPTY 669
#define ITEM_VALUE 670
#define I_O 671
#define I_O_CONTROL 672
#define JSON 673
#define JUSTIFIED 674
#define KEPT 675
#define KEY 676
#define KEYBOARD 677
#define LABEL 678
#define LABEL_OFFSET 679
#define LARGE_FONT 680
#define LARGE_OFFSET 681
#define LAST 682
#define LAST_ROW 683
#define LAYOUT_DATA 684
#define LAYOUT_MANAGER 685
#define LEADING 686
#define LEADING_SHIFT 687
#define LEAVE 688
#define LEFT 689
#define LEFTLINE 690
#define LEFT_TEXT 691
#define LENGTH 692
#define LENGTH_OF 693
#define LENGTH_FUNC 694
#define LESS 695
#define LESS_OR_EQUAL 696
#define LEVEL_NUMBER 697
#define LIMIT 698
#define LIMITS 699
#define LINAGE 700
#define LINAGE_COUNTER 701
#define LINE 702
#define LINE_COUNTER 703
#define LINE_LIMIT 704
#define LINE_SEQUENTIAL 705
#define LINES 706
#define LINES_AT_ROOT 707
#define LINKAGE 708
#define LIST_BOX 709
#define LITERAL 710
#define LM_RESIZE 711
#define LOC 712
#define LOCALE 713
#define LOCALE_DATE_FUNC 714
#define LOCALE_TIME_FUNC 715
#define LOCALE_TIME_FROM_FUNC 716
#define LOCAL_STORAGE 717
#define LOCK 718
#define LOCK_HOLDING 719
#define LONG_DATE 720
#define LOWER 721
#define LOWERED 722
#define LOWER_CASE_FUNC 723
#define LOWLIGHT 724
#define LOW_COLOR 725
#define LOW_VALUE 726
#define MAGNETIC_TAPE 727
#define MANUAL 728
#define MASS_UPDATE 729
#define MASTER_INDEX 730
#define MAX_LINES 731
#define MAX_PROGRESS 732
#define MAX_TEXT 733
#define MAX_VAL 734
#define MEMORY 735
#define MEDIUM_FONT 736
#define MENU 737
#define MERGE 738
#define MESSAGE 739
#define MINUS 740
#define MIN_VAL 741
#define MNEMONIC_NAME 742
#define MODE 743
#define MODIFY 744
#define MODULES 745
#define MOVE 746
#define MULTILINE 747
#define MULTIPLE 748
#define MULTIPLY 749
#define NAME 750
#define NAMESPACE 751
#define NAMESPACE_PREFIX 752
#define NATIONAL 753
#define NATIONAL_EDITED 754
#define NATIONAL_OF_FUNC 755
#define NATIVE 756
#define NAVIGATE_URL 757
#define NEAREST_AWAY_FROM_ZERO 758
#define NEAREST_EVEN 759
#define NEAREST_TOWARD_ZERO 760
#define NEGATIVE 761
#define NESTED 762
#define NEW 763
#define NEXT 764
#define NEXT_ITEM 765
#define NEXT_GROUP 766
#define NEXT_PAGE 767
#define NO 768
#define NO_ADVANCING 769
#define NO_AUTOSEL 770
#define NO_AUTO_DEFAULT 771
#define NO_BOX 772
#define NO_DATA 773
#define NO_DIVIDERS 774
#define NO_ECHO 775
#define NO_F4 776
#define NO_FOCUS 777
#define NO_GROUP_TAB 778
#define NO_KEY_LETTER 779
#define NOMINAL 780
#define NO_SEARCH 781
#define NO_UPDOWN 782
#define NONNUMERIC 783
#define NORMAL 784
#define NOT 785
#define NOTAB 786
#define NOTHING 787
#define NOTIFY 788
#define NOTIFY_CHANGE 789
#define NOTIFY_DBLCLICK 790
#define NOTIFY_SELCHANGE 791
#define NOT_END 792
#define NOT_EOP 793
#define NOT_ESCAPE 794
#define NOT_EQUAL 795
#define NOT_EXCEPTION 796
#define NOT_INVALID_KEY 797
#define NOT_OVERFLOW 798
#define NOT_SIZE_ERROR 799
#define NUM_COL_HEADINGS 800
#define NUM_ROWS 801
#define NUMBER 802
#define NUMBERS 803
#define NUMERIC 804
#define NUMERIC_EDITED 805
#define NUMVALC_FUNC 806
#define OBJECT 807
#define OBJECT_COMPUTER 808
#define OCCURS 809
#define OF 810
#define OFF 811
#define OK_BUTTON 812
#define OMITTED 813
#define ON 814
#define ONLY 815
#define OPEN 816
#define OPTIONAL 817
#define OPTIONS 818
#define OR 819
#define ORDER 820
#define ORGANIZATION 821
#define OTHER 822
#define OTHERS 823
#define OUTPUT 824
#define OVERLAP_LEFT 825
#define OVERLAP_TOP 826
#define OVERLINE 827
#define PACKED_DECIMAL 828
#define PADDING 829
#define PASCAL 830
#define PAGE 831
#define PAGE_COUNTER 832
#define PAGE_SETUP 833
#define PAGED 834
#define PARAGRAPH 835
#define PARENT 836
#define PARSE 837
#define PASSWORD 838
#define PERFORM 839
#define PERMANENT 840
#define PH 841
#define PF 842
#define PHYSICAL 843
#define PICTURE 844
#define PICTURE_SYMBOL 845
#define PIXEL 846
#define PLACEMENT 847
#define PLUS 848
#define POINTER 849
#define POP_UP 850
#define POS 851
#define POSITION 852
#define POSITION_SHIFT 853
#define POSITIVE 854
#define PRESENT 855
#define PREVIOUS 856
#define PRINT 857
#define PRINT_CONTROL 858
#define PRINT_NO_PROMPT 859
#define PRINT_PREVIEW 860
#define PRINTER 861
#define PRINTER_1 862
#define PRINTING 863
#define PRIORITY 864
#define PROCEDURE 865
#define PROCEDURES 866
#define PROCEED 867
#define PROCESSING 868
#define PROGRAM 869
#define PROGRAM_ID 870
#define PROGRAM_NAME 871
#define PROGRAM_POINTER 872
#define PROGRESS 873
#define PROHIBITED 874
#define PROMPT 875
#define PROPERTIES 876
#define PROPERTY 877
#define PROTECTED 878
#define PROTOTYPE 879
#define PURGE 880
#define PUSH_BUTTON 881
#define QUERY_INDEX 882
#define QUEUE 883
#define QUOTE 884
#define RADIO_BUTTON 885
#define RAISE 886
#define RAISED 887
#define RANDOM 888
#define RD 889
#define READ 890
#define READERS 891
#define READ_ONLY 892
#define READY_TRACE 893
#define RECEIVE 894
#define RECORD 895
#define RECORD_DATA 896
#define RECORD_OVERFLOW 897
#define RECORD_TO_ADD 898
#define RECORD_TO_DELETE 899
#define RECORDING 900
#define RECORDS 901
#define RECURSIVE 902
#define REDEFINES 903
#define REEL 904
#define REFERENCE 905
#define REFERENCES 906
#define REFRESH 907
#define REGION_COLOR 908
#define RELATIVE 909
#define RELEASE 910
#define REMAINDER 911
#define REMOVAL 912
#define RENAMES 913
#define REORG_CRITERIA 914
#define REPLACE 915
#define REPLACING 916
#define REPORT 917
#define REPORTING 918
#define REPORTS 919
#define REPOSITORY 920
#define REQUIRED 921
#define REREAD 922
#define RERUN 923
#define RESERVE 924
#define RESET 925
#define RESET_TRACE 926
#define RESET_GRID 927
#define RESET_LIST 928
#define RESET_TABS 929
#define RESIDENT 930
#define RETRY 931
#define RETURN 932
#define RETURNING 933
#define REVERSE 934
#define REVERSE_FUNC 935
#define REVERSE_VIDEO 936
#define REVERSED 937
#define REWIND 938
#define REWRITE 939
#define RF 940
#define RH 941
#define RIGHT 942
#define RIGHT_ALIGN 943
#define RIMMED 944
#define ROLLBACK 945
#define ROUNDED 946
#define ROUNDING 947
#define ROW_COLOR 948
#define ROW_COLOR_PATTERN 949
#define ROW_DIVIDERS 950
#define ROW_FONT 951
#define ROW_HEADINGS 952
#define ROW_PROTECTION 953
#define RUN 954
#define S 955
#define SAME 956
#define SAVE_AS 957
#define SAVE_AS_NO_PROMPT 958
#define SCREEN 959
#define SCREEN_CONTROL 960
#define SCROLL 961
#define SCROLL_BAR 962
#define SD 963
#define SEARCH 964
#define SEARCH_OPTIONS 965
#define SEARCH_TEXT 966
#define SECONDS 967
#define SECTION 968
#define SECURE 969
#define SEGMENT 970
#define SEGMENT_LIMIT 971
#define SELECT 972
#define SELECTION_INDEX 973
#define SELECTION_TEXT 974
#define SELECT_ALL 975
#define SELF_ACT 976
#define SEMI_COLON 977
#define SEND 978
#define SENTENCE 979
#define SEPARATE 980
#define SEPARATION 981
#define SEQUENCE 982
#define SEQUENTIAL 983
#define SET 984
#define SEVENTY_EIGHT 985
#define SHADING 986
#define SHADOW 987
#define SHARING 988
#define SHORT_DATE 989
#define SHOW_LINES 990
#define SHOW_NONE 991
#define SHOW_SEL_ALWAYS 992
#define SIGN 993
#define SIGNED 994
#define SIGNED_INT 995
#define SIGNED_LONG 996
#define SIGNED_SHORT 997
#define SIXTY_SIX 998
#define SIZE 999
#define SIZE_ERROR 1000
#define SMALL_FONT 1001
#define SORT 1002
#define SORT_MERGE 1003
#define SORT_ORDER 1004
#define SOURCE 1005
#define SOURCE_COMPUTER 1006
#define SPACE 1007
#define SPECIAL_NAMES 1008
#define SPINNER 1009
#define SQUARE 1010
#define STANDARD 1011
#define STANDARD_1 1012
#define STANDARD_2 1013
#define STANDARD_BINARY 1014
#define STANDARD_DECIMAL 1015
#define START 1016
#define START_X 1017
#define START_Y 1018
#define STATIC 1019
#define STATIC_LIST 1020
#define STATUS 1021
#define STATUS_BAR 1022
#define STATUS_TEXT 1023
#define STDCALL 1024
#define STEP 1025
#define STOP 1026
#define STRING 1027
#define STYLE 1028
#define SUB_QUEUE_1 1029
#define SUB_QUEUE_2 1030
#define SUB_QUEUE_3 1031
#define SUBSTITUTE_FUNC 1032
#define SUBSTITUTE_CASE_FUNC 1033
#define SUBTRACT 1034
#define SUBWINDOW 1035
#define SUM 1036
#define SUPPRESS 1037
#define SUPPRESS_XML 1038
#define SYMBOLIC 1039
#define SYNCHRONIZED 1040
#define SYSTEM_DEFAULT 1041
#define SYSTEM_INFO 1042
#define SYSTEM_OFFSET 1043
#define TAB 1044
#define TAB_TO_ADD 1045
#define TAB_TO_DELETE 1046
#define TABLE 1047
#define TALLYING 1048
#define TEMPORARY 1049
#define TAPE 1050
#define TERMINAL 1051
#define TERMINATE 1052
#define TERMINAL_INFO 1053
#define TERMINATION_VALUE 1054
#define TEST 1055
#define TEXT 1056
#define THAN 1057
#define THEN 1058
#define THREAD 1059
#define THREADS 1060
#define THRU 1061
#define THUMB_POSITION 1062
#define TILED_HEADINGS 1063
#define TIME 1064
#define TIME_OUT 1065
#define TIMES 1066
#define TITLE 1067
#define TITLE_POSITION 1068
#define TO 1069
#define TOK_AMPER 1070
#define TOK_CLOSE_PAREN 1071
#define TOK_COLON 1072
#define TOK_DIV 1073
#define TOK_DOT 1074
#define TOK_EQUAL 1075
#define TOK_EXTERN 1076
#define TOK_FALSE 1077
#define TOK_FILE 1078
#define TOK_GREATER 1079
#define TOK_INITIAL 1080
#define TOK_LESS 1081
#define TOK_MINUS 1082
#define TOK_MUL 1083
#define TOK_NULL 1084
#define TOK_OVERFLOW 1085
#define TOK_OPEN_PAREN 1086
#define TOK_PLUS 1087
#define TOK_TRUE 1088
#define TOP 1089
#define TOWARD_GREATER 1090
#define TOWARD_LESSER 1091
#define TRACK 1092
#define TRACKS 1093
#define TRACK_AREA 1094
#define TRACK_LIMIT 1095
#define TRADITIONAL_FONT 1096
#define TRAILING 1097
#define TRAILING_SHIFT 1098
#define TRANSACTION 1099
#define TRANSFORM 1100
#define TRANSPARENT 1101
#define TREE_VIEW 1102
#define TRIM_FUNC 1103
#define TRUNCATION 1104
#define TYPE 1105
#define U 1106
#define UCS_4 1107
#define UNBOUNDED 1108
#define UNDERLINE 1109
#define UNFRAMED 1110
#define UNIT 1111
#define UNLOCK 1112
#define UNSIGNED 1113
#define UNSIGNED_INT 1114
#define UNSIGNED_LONG 1115
#define UNSIGNED_SHORT 1116
#define UNSORTED 1117
#define UNSTRING 1118
#define UNTIL 1119
#define UP 1120
#define UPDATE 1121
#define UPDATERS 1122
#define UPON 1123
#define UPON_ARGUMENT_NUMBER 1124
#define UPON_COMMAND_LINE 1125
#define UPON_ENVIRONMENT_NAME 1126
#define UPON_ENVIRONMENT_VALUE 1127
#define UPPER 1128
#define UPPER_CASE_FUNC 1129
#define USAGE 1130
#define USE 1131
#define USE_ALT 1132
#define USE_RETURN 1133
#define USE_TAB 1134
#define USER 1135
#define USER_DEFAULT 1136
#define USER_FUNCTION_NAME 1137
#define USING 1138
#define UTF_8 1139
#define UTF_16 1140
#define V 1141
#define VALIDATE 1142
#define VALIDATING 1143
#define VALUE 1144
#define VALUE_FORMAT 1145
#define VARIABLE 1146
#define VARIANT 1147
#define VARYING 1148
#define VERTICAL 1149
#define VERY_HEAVY 1150
#define VIRTUAL_WIDTH 1151
#define VISIBLE 1152
#define VOLATILE 1153
#define VPADDING 1154
#define VSCROLL 1155
#define VSCROLL_BAR 1156
#define VSCROLL_POS 1157
#define VTOP 1158
#define WAIT 1159
#define WEB_BROWSER 1160
#define WHEN 1161
#define WHEN_COMPILED_FUNC 1162
#define WHEN_XML 1163
#define WIDTH 1164
#define WIDTH_IN_CELLS 1165
#define WINDOW 1166
#define WITH 1167
#define WORD 1168
#define WORDS 1169
#define WORKING_STORAGE 1170
#define WRAP 1171
#define WRITE 1172
#define WRITE_ONLY 1173
#define WRITE_VERIFY 1174
#define WRITERS 1175
#define X 1176
#define XML 1177
#define XML_DECLARATION 1178
#define Y 1179
#define YYYYDDD 1180
#define YYYYMMDD 1181
#define ZERO 1182
#define SHIFT_PREFER 1183

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 4066 "parser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   19098

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  929
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1305
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3166
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4481

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   1183

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  3170,  3170,  3170,  3204,  3205,  3209,  3209,  3218,  3219,
    3223,  3224,  3228,  3228,  3240,  3251,  3259,  3263,  3267,  3268,
    3273,  3272,  3285,  3284,  3299,  3303,  3297,  3314,  3315,  3319,
    3328,  3328,  3333,  3337,  3332,  3353,  3352,  3368,  3379,  3386,
    3387,  3394,  3395,  3398,  3400,  3401,  3405,  3414,  3423,  3424,
    3431,  3432,  3436,  3440,  3444,  3450,  3452,  3456,  3462,  3464,
    3472,  3479,  3481,  3485,  3492,  3496,  3500,  3516,  3519,  3529,
    3531,  3538,  3542,  3546,  3552,  3554,  3561,  3565,  3569,  3573,
    3582,  3587,  3588,  3597,  3601,  3602,  3612,  3614,  3618,  3619,
    3623,  3624,  3625,  3626,  3627,  3634,  3633,  3644,  3645,  3648,
    3649,  3662,  3661,  3675,  3676,  3677,  3678,  3682,  3683,  3687,
    3688,  3689,  3690,  3694,  3702,  3711,  3710,  3718,  3722,  3728,
    3732,  3737,  3744,  3754,  3770,  3781,  3785,  3789,  3793,  3800,
    3801,  3808,  3807,  3820,  3822,  3823,  3830,  3831,  3835,  3839,
    3845,  3846,  3853,  3860,  3865,  3876,  3890,  3893,  3894,  3897,
    3901,  3902,  3903,  3904,  3905,  3906,  3907,  3908,  3909,  3910,
    3911,  3912,  3913,  3914,  3922,  3921,  3940,  3951,  3972,  3980,
    3983,  3984,  3988,  3995,  4010,  4031,  4030,  4055,  4054,  4063,
    4062,  4072,  4074,  4078,  4082,  4083,  4089,  4095,  4101,  4110,
    4111,  4118,  4125,  4135,  4141,  4149,  4159,  4163,  4170,  4174,
    4179,  4178,  4189,  4193,  4200,  4201,  4202,  4203,  4204,  4205,
    4209,  4210,  4217,  4232,  4235,  4242,  4250,  4254,  4265,  4285,
    4293,  4304,  4305,  4312,  4326,  4327,  4331,  4352,  4373,  4374,
    4378,  4382,  4400,  4402,  4406,  4413,  4415,  4425,  4446,  4513,
    4516,  4525,  4544,  4560,  4578,  4596,  4613,  4631,  4630,  4658,
    4664,  4665,  4674,  4675,  4683,  4684,  4689,  4688,  4728,  4729,
    4735,  4736,  4745,  4746,  4747,  4748,  4749,  4750,  4751,  4752,
    4753,  4754,  4755,  4756,  4757,  4758,  4759,  4760,  4761,  4762,
    4763,  4789,  4799,  4809,  4820,  4831,  4862,  4865,  4869,  4873,
    4877,  4882,  4886,  4894,  4898,  4902,  4910,  4911,  4912,  4913,
    4917,  4918,  4919,  4920,  4921,  4922,  4923,  4927,  4935,  4939,
    4947,  4951,  4958,  4959,  4965,  4972,  4973,  4974,  4981,  5041,
    5044,  5049,  5048,  5074,  5077,  5081,  5085,  5095,  5106,  5105,
    5113,  5117,  5123,  5127,  5132,  5139,  5149,  5160,  5175,  5192,
    5194,  5195,  5201,  5201,  5208,  5212,  5216,  5223,  5224,  5225,
    5229,  5235,  5236,  5240,  5246,  5247,  5263,  5264,  5268,  5274,
    5280,  5286,  5299,  5310,  5309,  5318,  5328,  5341,  5353,  5368,
    5407,  5410,  5417,  5418,  5422,  5422,  5426,  5431,  5449,  5460,
    5467,  5468,  5474,  5482,  5483,  5484,  5490,  5498,  5499,  5505,
    5515,  5525,  5535,  5545,  5546,  5553,  5561,  5562,  5563,  5570,
    5571,  5575,  5576,  5577,  5578,  5584,  5612,  5613,  5614,  5615,
    5621,  5626,  5630,  5634,  5635,  5642,  5643,  5644,  5645,  5646,
    5647,  5648,  5649,  5656,  5655,  5671,  5672,  5676,  5679,  5680,
    5686,  5690,  5694,  5695,  5704,  5701,  5715,  5716,  5720,  5728,
    5729,  5737,  5738,  5742,  5762,  5761,  5784,  5791,  5795,  5801,
    5802,  5806,  5816,  5831,  5832,  5833,  5834,  5835,  5836,  5837,
    5838,  5839,  5846,  5853,  5853,  5853,  5859,  5868,  5877,  5887,
    5888,  5895,  5896,  5900,  5901,  5908,  5919,  5924,  5935,  5936,
    5940,  5941,  5947,  5958,  5976,  5977,  5981,  5982,  5983,  5987,
    5994,  6001,  6010,  6019,  6020,  6021,  6022,  6023,  6032,  6033,
    6039,  6076,  6077,  6087,  6102,  6103,  6107,  6121,  6139,  6141,
    6140,  6158,  6159,  6163,  6180,  6179,  6200,  6201,  6205,  6206,
    6207,  6210,  6212,  6213,  6217,  6218,  6222,  6223,  6224,  6225,
    6226,  6227,  6228,  6229,  6230,  6231,  6232,  6236,  6240,  6242,
    6246,  6247,  6251,  6252,  6253,  6254,  6255,  6256,  6257,  6260,
    6262,  6263,  6267,  6268,  6272,  6273,  6274,  6275,  6276,  6277,
    6281,  6286,  6288,  6287,  6303,  6307,  6307,  6329,  6330,  6334,
    6335,  6336,  6338,  6337,  6357,  6374,  6380,  6382,  6386,  6393,
    6397,  6408,  6411,  6423,  6424,  6426,  6430,  6434,  6440,  6444,
    6448,  6452,  6456,  6460,  6464,  6472,  6476,  6480,  6484,  6488,
    6492,  6503,  6504,  6508,  6509,  6513,  6514,  6515,  6519,  6520,
    6524,  6568,  6571,  6579,  6578,  6591,  6619,  6618,  6633,  6637,
    6644,  6650,  6654,  6661,  6662,  6666,  6667,  6668,  6669,  6670,
    6671,  6672,  6673,  6674,  6675,  6678,  6680,  6684,  6688,  6692,
    6693,  6694,  6695,  6696,  6697,  6698,  6699,  6700,  6701,  6702,
    6703,  6704,  6705,  6706,  6707,  6708,  6709,  6716,  6737,  6797,
    6825,  6828,  6836,  6837,  6841,  6866,  6865,  6877,  6885,  6902,
    6914,  6931,  6948,  6969,  6970,  6977,  6979,  6987,  7002,  7003,
    7004,  7017,  7024,  7028,  7033,  7037,  7042,  7052,  7056,  7060,
    7064,  7068,  7072,  7076,  7080,  7084,  7088,  7092,  7096,  7101,
    7106,  7110,  7114,  7118,  7123,  7127,  7132,  7136,  7141,  7146,
    7151,  7156,  7161,  7170,  7175,  7180,  7189,  7193,  7197,  7201,
    7205,  7209,  7213,  7217,  7221,  7230,  7239,  7243,  7247,  7251,
    7255,  7259,  7267,  7268,  7271,  7273,  7274,  7275,  7276,  7277,
    7278,  7281,  7283,  7289,  7296,  7309,  7318,  7319,  7328,  7335,
    7347,  7365,  7366,  7370,  7371,  7375,  7376,  7379,  7380,  7385,
    7386,  7393,  7394,  7400,  7402,  7404,  7403,  7412,  7413,  7417,
    7441,  7442,  7446,  7479,  7480,  7483,  7485,  7488,  7495,  7496,
    7501,  7512,  7523,  7543,  7544,  7545,  7552,  7563,  7590,  7589,
    7598,  7599,  7603,  7604,  7607,  7609,  7621,  7630,  7645,  7668,
    7687,  7689,  7688,  7708,  7710,  7709,  7725,  7727,  7726,  7737,
    7738,  7745,  7744,  7774,  7775,  7776,  7783,  7789,  7794,  7795,
    7801,  7808,  7809,  7810,  7814,  7821,  7822,  7826,  7836,  7875,
    7886,  7887,  7901,  7914,  7915,  7918,  7919,  7924,  7925,  7926,
    7927,  7928,  7929,  7941,  7955,  7969,  7983,  7997,  8010,  8011,
    8016,  8015,  8025,  8037,  8038,  8042,  8043,  8044,  8045,  8046,
    8047,  8048,  8049,  8050,  8051,  8052,  8053,  8054,  8055,  8056,
    8057,  8061,  8068,  8072,  8076,  8077,  8078,  8085,  8089,  8097,
    8100,  8108,  8118,  8119,  8124,  8127,  8132,  8136,  8144,  8151,
    8160,  8165,  8172,  8173,  8174,  8178,  8186,  8187,  8188,  8195,
    8199,  8206,  8211,  8217,  8224,  8230,  8240,  8244,  8251,  8253,
    8257,  8261,  8265,  8269,  8276,  8284,  8285,  8288,  8290,  8294,
    8298,  8315,  8330,  8333,  8335,  8339,  8343,  8347,  8354,  8374,
    8378,  8379,  8383,  8412,  8420,  8429,  8431,  8430,  8453,  8454,
    8458,  8459,  8463,  8466,  8465,  8516,  8528,  8515,  8572,  8592,
    8594,  8598,  8603,  8608,  8612,  8616,  8621,  8626,  8631,  8636,
    8645,  8649,  8653,  8657,  8661,  8667,  8671,  8676,  8682,  8686,
    8691,  8696,  8701,  8706,  8711,  8716,  8725,  8729,  8733,  8738,
    8742,  8746,  8750,  8754,  8758,  8762,  8766,  8777,  8782,  8787,
    8788,  8789,  8790,  8791,  8792,  8793,  8794,  8795,  8804,  8809,
    8820,  8821,  8828,  8829,  8830,  8831,  8832,  8833,  8834,  8835,
    8836,  8839,  8842,  8843,  8844,  8845,  8846,  8847,  8854,  8855,
    8860,  8861,  8864,  8866,  8867,  8871,  8872,  8876,  8877,  8881,
    8882,  8886,  8887,  8891,  8892,  8893,  8894,  8895,  8898,  8899,
    8900,  8901,  8902,  8904,  8905,  8907,  8908,  8912,  8913,  8914,
    8915,  8917,  8919,  8921,  8922,  8923,  8924,  8925,  8926,  8927,
    8928,  8929,  8935,  8936,  8937,  8938,  8939,  8940,  8941,  8942,
    8943,  8944,  8948,  8949,  8951,  8952,  8953,  8954,  8959,  8961,
    8962,  8963,  8967,  8975,  8976,  8977,  8978,  8979,  8980,  8981,
    8982,  8983,  8984,  8985,  8987,  8989,  8990,  8991,  8995,  8996,
    8997,  8998,  8999,  9000,  9001,  9002,  9003,  9004,  9009,  9010,
    9011,  9012,  9013,  9015,  9016,  9017,  9018,  9023,  9024,  9035,
    9036,  9060,  9061,  9078,  9081,  9082,  9083,  9086,  9090,  9091,
    9092,  9093,  9094,  9095,  9096,  9097,  9098,  9099,  9100,  9101,
    9102,  9103,  9104,  9105,  9111,  9112,  9113,  9133,  9134,  9135,
    9136,  9137,  9138,  9139,  9140,  9144,  9145,  9146,  9147,  9148,
    9149,  9155,  9156,  9157,  9158,  9159,  9160,  9161,  9162,  9167,
    9169,  9170,  9171,  9176,  9177,  9178,  9182,  9183,  9184,  9185,
    9186,  9187,  9198,  9199,  9200,  9201,  9206,  9209,  9210,  9211,
    9212,  9213,  9215,  9220,  9221,  9222,  9228,  9229,  9230,  9231,
    9232,  9233,  9234,  9235,  9236,  9237,  9241,  9242,  9243,  9244,
    9245,  9246,  9247,  9248,  9249,  9250,  9251,  9252,  9253,  9254,
    9256,  9257,  9258,  9259,  9260,  9261,  9262,  9263,  9264,  9265,
    9266,  9267,  9268,  9269,  9270,  9271,  9272,  9275,  9276,  9277,
    9285,  9286,  9287,  9291,  9292,  9293,  9297,  9298,  9301,  9302,
    9303,  9306,  9315,  9316,  9317,  9318,  9319,  9320,  9321,  9322,
    9323,  9324,  9325,  9326,  9327,  9329,  9330,  9331,  9332,  9333,
    9334,  9335,  9336,  9337,  9338,  9345,  9349,  9353,  9354,  9355,
    9356,  9357,  9358,  9359,  9360,  9366,  9367,  9368,  9373,  9374,
    9379,  9384,  9385,  9389,  9394,  9395,  9399,  9400,  9401,  9406,
    9407,  9411,  9412,  9416,  9417,  9421,  9425,  9425,  9429,  9433,
    9433,  9437,  9441,  9442,  9446,  9447,  9451,  9459,  9461,  9465,
    9472,  9482,  9485,  9489,  9496,  9508,  9518,  9527,  9532,  9542,
    9563,  9531,  9591,  9591,  9625,  9629,  9628,  9642,  9641,  9661,
    9662,  9667,  9683,  9685,  9689,  9699,  9701,  9709,  9717,  9725,
    9731,  9735,  9771,  9773,  9781,  9784,  9797,  9802,  9812,  9840,
    9842,  9841,  9878,  9879,  9883,  9884,  9885,  9903,  9904,  9916,
    9915,  9961,  9962,  9966, 10011, 10031, 10034, 10064, 10069, 10063,
   10082, 10082, 10119, 10126, 10127, 10128, 10129, 10130, 10131, 10132,
   10133, 10134, 10135, 10136, 10137, 10138, 10139, 10140, 10141, 10142,
   10143, 10144, 10145, 10146, 10147, 10148, 10149, 10150, 10151, 10152,
   10153, 10155, 10156, 10157, 10158, 10159, 10160, 10161, 10162, 10163,
   10164, 10165, 10166, 10167, 10168, 10169, 10171, 10172, 10173, 10174,
   10175, 10176, 10177, 10178, 10179, 10180, 10181, 10182, 10183, 10184,
   10185, 10186, 10187, 10188, 10189, 10190, 10191, 10192, 10207, 10219,
   10218, 10229, 10228, 10263, 10262, 10273, 10277, 10281, 10287, 10293,
   10298, 10303, 10308, 10313, 10319, 10325, 10329, 10335, 10339, 10344,
   10348, 10352, 10356, 10360, 10364, 10368, 10372, 10386, 10393, 10394,
   10401, 10401, 10413, 10417, 10421, 10428, 10432, 10436, 10443, 10444,
   10448, 10450, 10454, 10455, 10459, 10460, 10464, 10468, 10469, 10478,
   10479, 10484, 10485, 10489, 10490, 10494, 10510, 10526, 10539, 10547,
   10555, 10562, 10568, 10574, 10579, 10585, 10590, 10595, 10608, 10613,
   10618, 10624, 10630, 10636, 10643, 10647, 10651, 10655, 10659, 10670,
   10675, 10680, 10685, 10690, 10695, 10701, 10707, 10712, 10718, 10724,
   10730, 10737, 10742, 10747, 10754, 10761, 10767, 10770, 10770, 10774,
   10785, 10786, 10787, 10791, 10792, 10793, 10797, 10798, 10802, 10806,
   10825, 10824, 10833, 10837, 10844, 10848, 10856, 10857, 10861, 10865,
   10876, 10875, 10885, 10889, 10900, 10902, 10915, 10916, 10924, 10923,
   10932, 10933, 10937, 10943, 10943, 10950, 10949, 10966, 10965, 11034,
   11038, 11037, 11053, 11057, 11061, 11069, 11072, 11080, 11088, 11092,
   11096, 11100, 11104, 11123, 11129, 11149, 11153, 11163, 11167, 11172,
   11176, 11175, 11192, 11193, 11198, 11206, 11251, 11253, 11257, 11266,
   11279, 11282, 11286, 11290, 11295, 11318, 11319, 11323, 11324, 11328,
   11332, 11336, 11347, 11351, 11358, 11362, 11370, 11374, 11381, 11388,
   11392, 11403, 11402, 11414, 11418, 11425, 11426, 11436, 11435, 11443,
   11444, 11448, 11453, 11461, 11462, 11463, 11464, 11465, 11470, 11469,
   11481, 11482, 11490, 11489, 11498, 11505, 11509, 11519, 11531, 11530,
   11551, 11552, 11552, 11567, 11566, 11575, 11582, 11593, 11592, 11601,
   11605, 11609, 11614, 11622, 11626, 11637, 11636, 11645, 11648, 11650,
   11656, 11658, 11659, 11660, 11661, 11669, 11668, 11680, 11684, 11688,
   11692, 11696, 11697, 11698, 11699, 11700, 11701, 11702, 11706, 11714,
   11723, 11724, 11729, 11728, 11772, 11776, 11782, 11784, 11788, 11789,
   11793, 11794, 11798, 11802, 11807, 11811, 11812, 11816, 11820, 11824,
   11828, 11835, 11836, 11841, 11840, 11857, 11864, 11864, 11876, 11880,
   11888, 11889, 11890, 11901, 11900, 11918, 11920, 11924, 11925, 11929,
   11933, 11934, 11935, 11936, 11941, 11946, 11940, 11960, 11961, 11966,
   11971, 11965, 11990, 11989, 12011, 12012, 12013, 12017, 12018, 12023,
   12026, 12033, 12046, 12058, 12065, 12066, 12072, 12073, 12077, 12078,
   12079, 12080, 12081, 12082, 12086, 12089, 12093, 12094, 12095, 12099,
   12100, 12101, 12102, 12106, 12107, 12112, 12113, 12117, 12127, 12143,
   12148, 12154, 12160, 12165, 12170, 12176, 12182, 12188, 12194, 12201,
   12205, 12209, 12213, 12217, 12222, 12227, 12232, 12237, 12243, 12248,
   12253, 12260, 12270, 12274, 12285, 12284, 12293, 12297, 12301, 12305,
   12309, 12316, 12320, 12331, 12330, 12342, 12341, 12349, 12348, 12358,
   12382, 12395, 12394, 12421, 12429, 12430, 12435, 12446, 12457, 12471,
   12479, 12487, 12488, 12493, 12499, 12509, 12521, 12527, 12537, 12550,
   12549, 12561, 12559, 12573, 12574, 12579, 12654, 12655, 12656, 12657,
   12661, 12662, 12666, 12670, 12681, 12680, 12692, 12696, 12721, 12735,
   12758, 12781, 12802, 12826, 12829, 12837, 12836, 12845, 12856, 12855,
   12864, 12877, 12876, 12889, 12894, 12905, 12909, 12920, 12940, 12939,
   12948, 12952, 12958, 12965, 12968, 12975, 12981, 12987, 12992, 13004,
   13003, 13011, 13019, 13020, 13024, 13025, 13026, 13031, 13034, 13041,
   13045, 13053, 13060, 13061, 13062, 13063, 13064, 13065, 13066, 13078,
   13081, 13091, 13090, 13098, 13105, 13118, 13117, 13129, 13130, 13137,
   13136, 13145, 13149, 13150, 13151, 13155, 13156, 13157, 13158, 13165,
   13164, 13185, 13195, 13203, 13207, 13214, 13219, 13224, 13229, 13234,
   13239, 13247, 13248, 13252, 13257, 13263, 13265, 13266, 13267, 13268,
   13272, 13300, 13303, 13307, 13311, 13315, 13322, 13329, 13339, 13338,
   13351, 13356, 13349, 13368, 13371, 13378, 13379, 13383, 13391, 13395,
   13405, 13404, 13414, 13421, 13423, 13430, 13429, 13442, 13441, 13454,
   13455, 13459, 13463, 13474, 13473, 13481, 13485, 13496, 13495, 13504,
   13508, 13515, 13519, 13530, 13529, 13538, 13539, 13543, 13581, 13582,
   13586, 13587, 13588, 13589, 13593, 13594, 13598, 13599, 13600, 13604,
   13605, 13613, 13614, 13618, 13619, 13625, 13634, 13635, 13636, 13641,
   13642, 13643, 13647, 13654, 13670, 13671, 13672, 13678, 13677, 13689,
   13701, 13698, 13715, 13712, 13728, 13736, 13743, 13747, 13760, 13767,
   13779, 13782, 13787, 13791, 13804, 13811, 13812, 13816, 13817, 13820,
   13821, 13826, 13869, 13873, 13883, 13882, 13895, 13894, 13902, 13907,
   13917, 13932, 13931, 13941, 13970, 13971, 13975, 13979, 13983, 13987,
   13994, 13998, 14005, 14009, 14012, 14014, 14018, 14026, 14031, 14036,
   14043, 14045, 14049, 14053, 14057, 14064, 14065, 14069, 14070, 14074,
   14078, 14088, 14099, 14098, 14107, 14112, 14113, 14117, 14118, 14119,
   14123, 14124, 14128, 14132, 14133, 14137, 14141, 14145, 14155, 14154,
   14162, 14172, 14183, 14182, 14191, 14198, 14202, 14213, 14212, 14224,
   14233, 14236, 14240, 14244, 14251, 14255, 14265, 14277, 14276, 14285,
   14289, 14298, 14299, 14304, 14307, 14315, 14319, 14326, 14334, 14338,
   14349, 14348, 14356, 14359, 14364, 14366, 14370, 14376, 14377, 14378,
   14379, 14382, 14384, 14391, 14390, 14404, 14405, 14406, 14407, 14408,
   14409, 14410, 14411, 14415, 14416, 14420, 14421, 14427, 14436, 14443,
   14444, 14448, 14452, 14456, 14462, 14468, 14472, 14476, 14480, 14489,
   14493, 14497, 14501, 14505, 14514, 14523, 14524, 14528, 14537, 14538,
   14542, 14546, 14555, 14564, 14576, 14575, 14584, 14583, 14635, 14636,
   14653, 14654, 14657, 14658, 14667, 14670, 14675, 14680, 14690, 14707,
   14712, 14722, 14740, 14739, 14749, 14762, 14765, 14773, 14776, 14781,
   14786, 14794, 14795, 14796, 14797, 14798, 14799, 14803, 14811, 14812,
   14816, 14820, 14830, 14833, 14834, 14838, 14849, 14848, 14859, 14867,
   14878, 14885, 14889, 14893, 14901, 14913, 14916, 14923, 14927, 14934,
   14935, 14936, 14937, 14944, 14943, 14952, 14959, 14959, 14969, 14970,
   14974, 14988, 14989, 14994, 14995, 14999, 15000, 15004, 15008, 15019,
   15018, 15027, 15031, 15035, 15039, 15047, 15051, 15061, 15072, 15073,
   15080, 15079, 15087, 15094, 15107, 15106, 15114, 15128, 15127, 15135,
   15152, 15151, 15161, 15169, 15170, 15175, 15176, 15181, 15188, 15189,
   15194, 15201, 15202, 15206, 15207, 15211, 15215, 15225, 15224, 15239,
   15244, 15256, 15255, 15264, 15265, 15266, 15267, 15268, 15272, 15299,
   15302, 15314, 15324, 15329, 15334, 15339, 15347, 15387, 15388, 15392,
   15452, 15462, 15485, 15486, 15487, 15488, 15492, 15501, 15508, 15519,
   15552, 15553, 15557, 15563, 15579, 15580, 15587, 15586, 15598, 15608,
   15609, 15614, 15617, 15621, 15625, 15632, 15633, 15637, 15638, 15639,
   15643, 15647, 15657, 15656, 15669, 15680, 15667, 15691, 15693, 15697,
   15698, 15702, 15706, 15718, 15727, 15737, 15740, 15750, 15753, 15761,
   15764, 15773, 15777, 15784, 15792, 15795, 15804, 15808, 15815, 15823,
   15826, 15830, 15831, 15832, 15835, 15837, 15845, 15846, 15850, 15855,
   15860, 15867, 15872, 15877, 15885, 15889, 15896, 15900, 15911, 15910,
   15927, 15922, 15933, 15935, 15938, 15940, 15943, 15945, 15949, 15950,
   15966, 15967, 15968, 15978, 15982, 15989, 15997, 15998, 16002, 16003,
   16007, 16015, 16016, 16021, 16022, 16023, 16033, 16037, 16044, 16052,
   16053, 16057, 16065, 16066, 16067, 16077, 16081, 16088, 16096, 16097,
   16101, 16109, 16110, 16111, 16121, 16125, 16132, 16140, 16141, 16145,
   16155, 16156, 16157, 16167, 16171, 16178, 16186, 16187, 16191, 16201,
   16202, 16203, 16213, 16217, 16224, 16232, 16233, 16237, 16248, 16249,
   16256, 16258, 16267, 16271, 16278, 16286, 16287, 16291, 16301, 16302,
   16312, 16316, 16323, 16331, 16332, 16336, 16346, 16347, 16351, 16352,
   16362, 16366, 16373, 16381, 16382, 16386, 16397, 16400, 16409, 16412,
   16420, 16424, 16433, 16437, 16444, 16445, 16451, 16456, 16464, 16471,
   16471, 16482, 16483, 16487, 16488, 16490, 16492, 16494, 16495, 16497,
   16498, 16499, 16500, 16501, 16503, 16504, 16505, 16508, 16510, 16514,
   16517, 16519, 16520, 16521, 16522, 16523, 16524, 16526, 16527, 16528,
   16529, 16530, 16533, 16534, 16538, 16539, 16543, 16544, 16548, 16549,
   16553, 16557, 16563, 16567, 16573, 16575, 16576, 16580, 16581, 16582,
   16586, 16587, 16588, 16592, 16596, 16600, 16601, 16602, 16605, 16606,
   16616, 16628, 16637, 16653, 16662, 16678, 16693, 16694, 16699, 16708,
   16714, 16724, 16738, 16760, 16764, 16785, 16789, 16810, 16822, 16836,
   16850, 16851, 16856, 16862, 16863, 16868, 16877, 16879, 16884, 16898,
   16899, 16900, 16907, 16918, 16919, 16923, 16931, 16932, 16936, 16937,
   16941, 16951, 16955, 16962, 16971, 16972, 16978, 16987, 16998, 17015,
   17019, 17026, 17027, 17028, 17035, 17036, 17040, 17044, 17051, 17052,
   17056, 17057, 17061, 17062, 17063, 17064, 17068, 17072, 17076, 17080,
   17084, 17105, 17115, 17119, 17126, 17127, 17128, 17132, 17133, 17134,
   17135, 17136, 17140, 17144, 17151, 17152, 17153, 17154, 17158, 17162,
   17169, 17181, 17193, 17207, 17208, 17212, 17213, 17217, 17224, 17231,
   17232, 17239, 17240, 17247, 17248, 17249, 17253, 17254, 17258, 17262,
   17266, 17270, 17271, 17275, 17279, 17280, 17284, 17288, 17289, 17298,
   17302, 17307, 17308, 17314, 17318, 17322, 17326, 17327, 17333, 17337,
   17341, 17342, 17346, 17353, 17363, 17382, 17401, 17419, 17426, 17433,
   17440, 17450, 17454, 17461, 17465, 17472, 17482, 17492, 17502, 17515,
   17541, 17545, 17553, 17553, 17566, 17571, 17579, 17587, 17591, 17601,
   17618, 17640, 17660, 17664, 17671, 17685, 17686, 17687, 17688, 17689,
   17690, 17694, 17698, 17715, 17719, 17726, 17727, 17728, 17729, 17730,
   17731, 17732, 17736, 17737, 17738, 17739, 17745, 17749, 17753, 17757,
   17761, 17765, 17770, 17774, 17778, 17782, 17786, 17790, 17794, 17798,
   17805, 17806, 17810, 17811, 17812, 17813, 17817, 17818, 17819, 17820,
   17821, 17825, 17829, 17833, 17840, 17844, 17848, 17855, 17862, 17869,
   17879, 17879, 17895, 17902, 17912, 17919, 17929, 17933, 17946, 17950,
   17965, 17973, 17974, 17978, 17979, 17980, 17984, 17985, 17990, 17993,
   18001, 18004, 18011, 18013, 18014, 18018, 18019, 18023, 18024, 18025,
   18030, 18033, 18046, 18050, 18058, 18062, 18066, 18070, 18074, 18078,
   18082, 18086, 18093, 18094, 18098, 18099, 18109, 18110, 18119, 18123,
   18127, 18131, 18138, 18139, 18140, 18141, 18142, 18143, 18144, 18145,
   18146, 18147, 18148, 18149, 18150, 18151, 18152, 18153, 18154, 18155,
   18156, 18157, 18158, 18159, 18160, 18161, 18162, 18163, 18164, 18165,
   18166, 18167, 18168, 18169, 18170, 18171, 18172, 18173, 18174, 18175,
   18176, 18177, 18178, 18179, 18180, 18181, 18182, 18183, 18184, 18185,
   18186, 18187, 18188, 18192, 18193, 18194, 18195, 18196, 18197, 18198,
   18199, 18200, 18201, 18202, 18203, 18204, 18205, 18206, 18207, 18208,
   18209, 18210, 18211, 18212, 18213, 18214, 18221, 18221, 18222, 18222,
   18223, 18223, 18224, 18224, 18225, 18225, 18225, 18226, 18226, 18227,
   18227, 18228, 18228, 18229, 18229, 18230, 18230, 18231, 18231, 18232,
   18232, 18233, 18233, 18234, 18234, 18235, 18235, 18236, 18236, 18237,
   18237, 18238, 18238, 18239, 18239, 18240, 18240, 18241, 18241, 18242,
   18242, 18243, 18243, 18244, 18244, 18245, 18245, 18245, 18246, 18246,
   18246, 18247, 18247, 18248, 18248, 18249, 18249, 18250, 18250, 18251,
   18251, 18252, 18252, 18252, 18253, 18253, 18253, 18254, 18254, 18254,
   18254, 18255, 18255, 18255, 18256, 18256, 18257, 18257, 18258, 18258,
   18258, 18259, 18259, 18259, 18260, 18260, 18261, 18261, 18262, 18262,
   18263, 18263, 18264, 18264, 18265, 18265, 18266, 18266, 18267, 18267,
   18268, 18268, 18269, 18269, 18269, 18270, 18270, 18270, 18270, 18271,
   18271, 18272, 18272, 18273, 18273, 18274, 18274, 18275, 18275, 18276,
   18276, 18277, 18277, 18277, 18278, 18278, 18279, 18279, 18280, 18280,
   18281, 18281, 18281, 18282, 18282, 18283, 18283, 18284, 18284, 18285,
   18285, 18286, 18286, 18287, 18287, 18288, 18288, 18289, 18289, 18290,
   18290, 18291, 18291, 18292, 18292, 18293, 18293, 18294, 18294, 18295,
   18295, 18295, 18299, 18299, 18300, 18300, 18301, 18301, 18302, 18302,
   18302, 18302, 18303, 18303, 18304, 18304, 18305, 18305, 18306, 18306,
   18307, 18307, 18308, 18308, 18309, 18309, 18310, 18310, 18310, 18311,
   18311, 18312, 18312, 18313, 18313, 18314, 18314, 18315, 18315, 18316,
   18316, 18319, 18319, 18320, 18320, 18321, 18321, 18322, 18322, 18323,
   18323, 18324, 18324, 18325, 18325, 18326, 18326
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "$undefined", "\"3D\"", "ABSENT", "ACCEPT",
  "ACCESS", "\"ACTIVE-X\"", "ACTION", "ACTUAL", "ADD", "ADDRESS",
  "\"ADJUSTABLE-COLUMNS\"", "ADVANCING", "AFTER", "ALIGNMENT", "ALL",
  "ALLOCATE", "ALLOWING", "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"",
  "\"ALPHABETIC-UPPER\"", "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"",
  "ALSO", "ALTER", "ALTERNATE", "AND", "ANY", "APPLY", "ARE", "AREA",
  "AREAS", "\"ARGUMENT-NUMBER\"", "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS",
  "ASCENDING", "ASCII", "ASSIGN", "AT", "ATTRIBUTE", "ATTRIBUTES", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BAR", "BASED", "BEFORE", "BELL", "BINARY",
  "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"", "BUSY",
  "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"", "CALL",
  "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"", "CLASS",
  "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"", "CLINE",
  "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING", "COL",
  "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-TYPES\"", "DATE", "\"DATE-ENTRY\"", "DAY", "\"DAY-OF-WEEK\"",
  "DE", "DEBUGGING", "\"DECIMAL-POINT\"", "DECLARATIVES", "DEFAULT",
  "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISP", "DISPLAY",
  "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"", "\"FUNCTION DISPLAY-OF\"",
  "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"", "DIVISION", "DOTDASH",
  "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"", "\"DROP-LIST\"", "DOWN",
  "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI",
  "\"level-number 88\"", "ENABLE", "ENABLED", "ELEMENT", "ELSE", "EMI",
  "ENCRYPTION", "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"",
  "\"END-CALL\"", "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"",
  "\"END-DISPLAY\"", "\"END-DIVIDE\"", "\"END-EVALUATE\"",
  "\"END FUNCTION\"", "\"END-IF\"", "\"END-JSON\"", "\"END-MODIFY\"",
  "\"END-MULTIPLY\"", "\"END-PERFORM\"", "\"END PROGRAM\"", "\"END-READ\"",
  "\"END-RECEIVE\"", "\"END-RETURN\"", "\"END-REWRITE\"", "\"END-SEARCH\"",
  "\"END-START\"", "\"END-STRING\"", "\"END-SUBTRACT\"",
  "\"END-UNSTRING\"", "\"END-WRITE\"", "\"END-XML\"", "ENGRAVED",
  "\"ENSURE-VISIBLE\"", "ENTRY", "\"ENTRY-CONVENTION\"", "\"ENTRY-FIELD\"",
  "\"ENTRY-REASON\"", "ENVIRONMENT", "\"ENVIRONMENT-NAME\"",
  "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS", "EQUAL", "ERASE", "ERROR",
  "ESCAPE", "\"ESCAPE-BUTTON\"", "ESI", "EVALUATE", "EVENT",
  "\"EVENT-LIST\"", "\"EVENT STATUS\"", "EVERY", "EXCEPTION",
  "\"EXCEPTION CONDITION\"", "\"EXCEPTION-VALUE\"", "EXPAND", "EXCLUSIVE",
  "EXIT", "\"exponentiation operator\"", "EXTEND", "\"EXTENDED-SEARCH\"",
  "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FD", "\"FH--FCD\"",
  "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"", "\"FILE-LIMIT\"",
  "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"", "\"FILL-COLOR\"",
  "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER", "FINAL",
  "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "\"FUNCTION FORMATTED-DATE\"",
  "\"FUNCTION FORMATTED-DATETIME\"", "\"FUNCTION FORMATTED-TIME\"",
  "FRAME", "FRAMED", "FREE", "FROM", "\"FROM CRT\"", "FULL",
  "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"", "\"GO-SEARCH\"",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "\"GROUP-VALUE\"", "HANDLE", "\"HAS-CHILDREN\"", "HEADING",
  "\"HEADING-COLOR\"", "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"",
  "HEAVY", "\"HEIGHT-IN-CELLS\"", "\"HELP-ID\"", "\"HIDDEN-DATA\"",
  "HIGHLIGHT", "\"HIGH-COLOR\"", "\"HIGH-VALUE\"", "\"HOT-TRACK\"",
  "HSCROLL", "\"HSCROLL-POS\"", "ICON", "ID", "IDENTIFIED",
  "IDENTIFICATION", "IF", "IGNORE", "IGNORING", "IN", "INDEPENDENT",
  "INDEX", "INDEXED", "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE",
  "INPUT", "\"INPUT-OUTPUT\"", "INQUIRE", "\"INSERTION-INDEX\"",
  "\"INSERT-ROWS\"", "INSPECT", "INTERMEDIATE", "INTO", "INTRINSIC",
  "INVALID", "\"INVALID KEY\"", "IS", "ITEM", "\"ITEM-TEXT\"",
  "\"ITEM-TO_ADD\"", "\"ITEM-TO_DELETE\"", "\"ITEM-TO_EMPTY\"",
  "\"ITEM-VALUE\"", "\"I-O\"", "\"I-O-CONTROL\"", "JSON", "JUSTIFIED",
  "KEPT", "KEY", "KEYBOARD", "LABEL", "\"LABEL-OFFSET\"", "\"LARGE-FONT\"",
  "\"LARGE-OFFSET\"", "LAST", "\"LAST-ROW\"", "\"LAYOUT-DATA\"",
  "\"LAYOUT-MANAGER\"", "LEADING", "\"LEADING-SHIFT\"", "LEAVE", "LEFT",
  "LEFTLINE", "\"LEFT-TEXT\"", "LENGTH", "\"LENGTH OF\"",
  "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS", "\"LESS OR EQUAL\"",
  "\"level-number\"", "LIMIT", "LIMITS", "LINAGE", "\"LINAGE-COUNTER\"",
  "LINE", "\"LINE-COUNTER\"", "\"LINE LIMIT\"", "\"LINE-SEQUENTIAL\"",
  "LINES", "\"LINES-AT-ROOT\"", "LINKAGE", "\"LIST-BOX\"", "\"Literal\"",
  "\"LM-RESIZE\"", "LOC", "LOCALE", "\"FUNCTION LOCALE-DATE\"",
  "\"FUNCTION LOCALE-TIME\"", "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"",
  "\"LOCAL-STORAGE\"", "LOCK", "\"LOCK-HOLDING\"", "\"LONG-DATE\"",
  "LOWER", "LOWERED", "\"FUNCTION LOWER-CASE\"", "LOWLIGHT",
  "\"LOW-COLOR\"", "\"LOW-VALUE\"", "\"MAGNETIC-TAPE\"", "MANUAL",
  "\"MASS-UPDATE\"", "\"MASTER-INDEX\"", "\"MAX-LINES\"",
  "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"", "MEMORY",
  "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE", "MINUS", "\"MIN-VAL\"",
  "\"Mnemonic name\"", "MODE", "MODIFY", "MODULES", "MOVE", "MULTILINE",
  "MULTIPLE", "MULTIPLY", "NAME", "NAMESPACE", "\"NAMESPACE-PREFIX\"",
  "NATIONAL", "\"NATIONAL-EDITED\"", "\"FUNCTION NATIONAL-OF\"", "NATIVE",
  "\"NAVIGATE-URL\"", "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "NOMINAL", "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NONNUMERIC", "NORMAL",
  "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT END\"",
  "\"NOT EOP\"", "\"NOT ESCAPE\"", "\"NOT EQUAL\"", "\"NOT EXCEPTION\"",
  "\"NOT INVALID KEY\"", "\"NOT OVERFLOW\"", "\"NOT SIZE ERROR\"",
  "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER", "NUMBERS", "NUMERIC",
  "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"", "OBJECT",
  "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"", "OMITTED",
  "ON", "ONLY", "OPEN", "OPTIONAL", "OPTIONS", "OR", "ORDER",
  "ORGANIZATION", "OTHER", "OTHERS", "OUTPUT", "\"OVERLAP-LEFT\"",
  "\"OVERLAP-TOP\"", "OVERLINE", "\"PACKED-DECIMAL\"", "PADDING", "PASCAL",
  "PAGE", "\"PAGE-COUNTER\"", "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH",
  "PARENT", "PARSE", "PASSWORD", "PERFORM", "PERMANENT", "PH", "PF",
  "PHYSICAL", "PICTURE", "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT",
  "PLUS", "POINTER", "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"",
  "POSITIVE", "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PROTOTYPE", "PURGE", "\"PUSH-BUTTON\"",
  "\"QUERY-INDEX\"", "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE",
  "RAISED", "RANDOM", "RD", "READ", "READERS", "\"READ-ONLY\"",
  "\"READY TRACE\"", "RECEIVE", "RECORD", "\"RECORD-DATA\"",
  "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"", "\"RECORD-TO-DELETE\"",
  "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL", "REFERENCE",
  "REFERENCES", "REFRESH", "\"REGION-COLOR\"", "RELATIVE", "RELEASE",
  "REMAINDER", "REMOVAL", "RENAMES", "\"REORG-CRITERIA\"", "REPLACE",
  "REPLACING", "REPORT", "REPORTING", "REPORTS", "REPOSITORY", "REQUIRED",
  "REREAD", "RERUN", "RESERVE", "RESET", "\"RESET TRACE\"",
  "\"RESET-GRID\"", "\"RESET-LIST\"", "\"RESET-TABS\"", "RESIDENT",
  "RETRY", "RETURN", "RETURNING", "REVERSE", "\"FUNCTION REVERSE\"",
  "\"REVERSE-VIDEO\"", "REVERSED", "REWIND", "REWRITE", "RF", "RH",
  "RIGHT", "\"RIGHT-ALIGN\"", "RIMMED", "ROLLBACK", "ROUNDED", "ROUNDING",
  "\"ROW-COLOR\"", "\"ROW-COLOR-PATTERN\"", "\"ROW-DIVIDERS\"",
  "\"ROW-FONT\"", "\"ROW-HEADINGS\"", "\"ROW-PROTECTION\"", "RUN", "S",
  "SAME", "\"SAVE-AS\"", "\"SAVE-AS-NO-PROMPT\"", "SCREEN",
  "\"SCREEN CONTROL\"", "SCROLL", "\"SCROLL-BAR\"", "SD", "SEARCH",
  "\"SEARCH-OPTIONS\"", "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE",
  "SEGMENT", "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"", "\"SUB-QUEUE-3\"",
  "\"FUNCTION SUBSTITUTE\"", "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT",
  "SUBWINDOW", "SUM", "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC",
  "SYNCHRONIZED", "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"",
  "\"SYSTEM-OFFSET\"", "TAB", "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"",
  "TABLE", "TALLYING", "TEMPORARY", "TAPE", "TERMINAL", "TERMINATE",
  "\"TERMINAL-INFO\"", "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN",
  "THEN", "THREAD", "THREADS", "THRU", "\"THUMB-POSITION\"",
  "\"TILED-HEADINGS\"", "TIME", "\"TIME-OUT\"", "TIMES", "TITLE",
  "\"TITLE-POSITION\"", "TO", "\"&\"", "\")\"", "\":\"", "\"/\"", "\".\"",
  "\"=\"", "\"EXTERN\"", "\"FALSE\"", "\"FILE\"", "\">\"", "\"INITIAL\"",
  "\"<\"", "\"-\"", "\"*\"", "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"",
  "\"TRUE\"", "TOP", "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK",
  "TRACKS", "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"",
  "TRAILING", "\"TRAILING-SHIFT\"", "TRANSACTION", "TRANSFORM",
  "TRANSPARENT", "\"TREE-VIEW\"", "\"FUNCTION TRIM\"", "TRUNCATION",
  "TYPE", "U", "\"UCS-4\"", "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT",
  "UNLOCK", "UNSIGNED", "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"",
  "\"UNSIGNED-SHORT\"", "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE",
  "UPDATERS", "UPON", "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALIDATE", "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VISIBLE", "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"",
  "\"VSCROLL-POS\"", "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN",
  "\"FUNCTION WHEN-COMPILED\"", "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"",
  "WINDOW", "WITH", "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"",
  "WRAP", "WRITE", "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X",
  "XML", "\"XML-DECLARATION\"", "Y", "YYYYDDD", "YYYYMMDD", "ZERO",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "_program_body", "$@6", "$@7",
  "_identification_header", "identification_header",
  "identification_or_id", "program_id_paragraph", "$@8", "$@9",
  "function_id_paragraph", "$@10", "program_id_name", "end_program_name",
  "_as_literal", "_program_type", "program_type_clause",
  "init_or_recurse_or_resident_and_common", "init_or_recurse_or_resident",
  "_is_prototype", "is_prototype", "_options_paragraph",
  "_options_clauses", "_arithmetic_clause", "arithmetic_choice",
  "_default_rounded_clause", "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "_configuration_section",
  "_configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "source_computer_paragraph", "$@11", "_source_computer_entry",
  "_with_debugging_mode", "object_computer_paragraph", "$@12",
  "_object_computer_entry", "object_clauses_list", "object_clauses",
  "object_computer_memory", "object_computer_sequence",
  "program_collating_sequence", "$@13", "program_coll_sequence_values",
  "object_computer_segment", "object_computer_class", "locale_class",
  "computer_words", "repository_paragraph", "$@14", "_repository_entry",
  "repository_list", "repository_name", "repository_name_list",
  "special_names_header", "special_names_sentence", "special_name_list",
  "special_name", "mnemonic_name_clause", "$@15", "mnemonic_choices",
  "_special_name_mnemonic_on_off", "on_off_clauses", "on_off_clauses_1",
  "alphabet_name_clause", "@16", "alphabet_definition", "@17", "@18",
  "alphabet_target_alphanumeric", "alphabet_target_national",
  "alphabet_type_alphanumeric", "alphabet_type_national",
  "alphabet_type_common", "alphabet_literal_list", "alphabet_literal",
  "@19", "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "symbolic_characters_clause", "_sym_in_word", "symbolic_collection",
  "symbolic_chars_list", "symbolic_chars_phrase", "char_list",
  "integer_list", "symbolic_constant_clause", "symbolic_constant_list",
  "symbolic_constant", "class_name_clause", "class_item_list",
  "class_item", "_class_type", "_in_alphabet", "locale_clause",
  "currency_sign_clause", "_with_pic_symbol", "decimal_point_clause",
  "numeric_sign_clause", "cursor_clause", "crt_status_clause",
  "screen_control", "event_status", "top_clause", "$@20",
  "_input_output_section", "_input_output_header", "_file_control_header",
  "_file_control_sequence", "file_control_entry", "$@21",
  "_select_clauses_or_error", "_select_clause_sequence", "select_clause",
  "assign_clause", "_assign_device_or_line_adv_file", "assign_device",
  "general_device_name", "line_seq_device_name", "line_adv_file",
  "_ext_clause", "ext_clause", "assignment_name", "access_mode_clause",
  "access_mode", "alternative_record_key_clause", "_password_clause",
  "password_clause", "$@22", "_suppress_clause",
  "collating_sequence_clause", "collating_sequence", "$@23",
  "coll_sequence_values", "collating_sequence_clause_key", "alphabet_name",
  "file_status_clause", "_file_or_sort", "lock_mode_clause", "$@24",
  "lock_mode", "_lock_with", "_with_rollback", "with_rollback",
  "_with_mass_update", "organization_clause", "organization",
  "padding_character_clause", "record_delimiter_clause", "$@25",
  "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@26", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@27",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event", "_data_division",
  "$@28", "_data_division_header", "data_division_header",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@29", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "_communication_section", "$@30",
  "_communication_description_sequence", "communication_description",
  "communication_description_entry", "$@31",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses",
  "_working_storage_section", "$@32", "_record_description_list", "$@33",
  "record_description_list", "data_description", "$@34", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@35", "constant_entry", "$@36", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "same_as_clause",
  "external_clause", "_as_extname", "_global_clause", "global_clause",
  "special_names_clause", "$@37", "special_names_target",
  "volatile_clause", "picture_clause", "_pic_locale_format",
  "_is_locale_name", "locale_name", "usage_clause", "usage",
  "double_usage", "_font_name", "_layout_name", "sign_clause",
  "report_occurs_clause", "_occurs_step", "occurs_clause",
  "_occurs_to_integer", "_occurs_from_integer", "_occurs_integer_to",
  "_occurs_depending", "_capacity_in", "_occurs_initialized",
  "_occurs_keys_and_indexed", "$@38", "occurs_keys", "occurs_key_list",
  "occurs_key_field", "ascending_or_descending", "_occurs_indexed",
  "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "$@39",
  "value_item_list", "value_item", "_false_is", "any_length_clause",
  "external_form_clause", "identified_by_clause", "_local_storage_section",
  "$@40", "_linkage_section", "$@41", "_report_section", "$@42",
  "_report_description_sequence", "report_description", "$@43",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@44", "_report_group_options", "report_group_option", "type_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "report_varying_clause", "line_clause", "line_keyword_clause",
  "_line_clause_options", "line_clause_option", "column_clause",
  "col_keyword_clause", "_orientation", "_left_right_center",
  "col_or_plus", "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@45",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@46", "$@47", "$@48", "_screen_options",
  "screen_option", "control_definition", "control_type_name",
  "control_type", "control_item", "_control_attributes_and_screen_options",
  "control_attributes", "control_attribute", "control_style",
  "control_property", "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause", "_procedure_division",
  "procedure_division", "$@49", "$@50", "$@51", "$@52",
  "_procedure_using_chaining", "$@53", "$@54", "procedure_param_list",
  "procedure_param", "_procedure_type", "_size_optional",
  "size_is_integer", "_acu_size", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@55",
  "_procedure_list", "procedure", "section_header", "$@56",
  "_use_statement", "paragraph_header", "invalid_statement", "_segment",
  "statement_list", "@57", "@58", "statements", "$@59", "statement",
  "accept_statement", "$@60", "accept_body", "$@61", "$@62",
  "accp_identifier", "field_with_pos_specifier", "$@63", "pos_specifier",
  "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "line_number", "column_number",
  "mode_is_block", "accp_attr", "_key_dest", "key_dest", "no_echo",
  "reverse_video", "update_default", "_end_accept", "add_statement",
  "$@64", "add_body", "_add_to", "_end_add", "allocate_statement", "$@65",
  "allocate_body", "_loc", "allocate_returning", "alter_statement", "$@66",
  "alter_body", "alter_entry", "_proceed_to", "call_statement", "$@67",
  "call_body", "$@68", "_conv_linkage", "$@69", "conv_linkage_option",
  "_mnemonic_conv", "mnemonic_conv", "program_or_prototype",
  "_id_or_lit_or_func_as", "nested_or_prototype", "call_using", "$@70",
  "call_param_list", "call_param", "_call_type", "call_returning",
  "return_give", "null_or_omitted", "call_exception_phrases",
  "_call_on_exception", "call_on_exception", "_call_not_on_exception",
  "call_not_on_exception", "_end_call", "cancel_statement", "$@71",
  "cancel_body", "id_or_lit_or_program_name", "close_statement", "$@72",
  "close_body", "close_files", "_close_option", "close_window", "$@73",
  "_close_display_option", "compute_statement", "$@74", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "$@75",
  "_continue_after_phrase", "$@76", "destroy_statement", "$@77",
  "destroy_body", "delete_statement", "$@78", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@79",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@80", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@81", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "display_upon", "crt_under", "display_erase", "$@82",
  "display_pos_specifier", "field_or_literal_or_erase_with_pos_specifier",
  "$@83", "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@84", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@85", "$@86", "sub_or_window", "display_floating_window", "$@87",
  "$@88", "display_initial_window", "$@89", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "_end_display",
  "divide_statement", "$@90", "divide_body", "_end_divide",
  "enable_statement", "$@91", "entry_statement", "$@92", "$@93",
  "entry_body", "entry_goto_body", "evaluate_statement", "$@94",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "evaluate_case",
  "evaluate_other", "evaluate_when_list", "$@95", "$@96",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "_end_evaluate", "exit_statement", "$@97", "exit_body",
  "exit_program_returning", "free_statement", "$@98", "free_body",
  "generate_statement", "$@99", "generate_body", "goto_statement", "$@100",
  "go_body", "goto_depending", "goback_statement", "if_statement", "$@101",
  "if_else_statements", "_if_then", "if_true", "if_false", "_end_if",
  "initialize_statement", "$@102", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@103", "initiate_body", "inquire_statement", "$@104", "inquire_body",
  "inspect_statement", "$@105", "inspect_body", "send_identifier",
  "inspect_list", "inspect_tallying", "$@106", "inspect_replacing",
  "inspect_converting", "tallying_list", "tallying_item", "replacing_list",
  "replacing_item", "rep_keyword", "replacing_region", "inspect_region",
  "inspect_before", "inspect_after", "json_generate_statement", "$@107",
  "json_generate_body", "$@108", "$@109", "_json_suppress",
  "json_suppress_list", "json_suppress_entry", "_end_json",
  "json_parse_statement", "$@110", "json_parse_body", "_with_detail",
  "merge_statement", "$@111", "modify_statement", "$@112", "modify_body",
  "_end_modify", "move_statement", "$@113", "move_body",
  "multiply_statement", "$@114", "multiply_body", "_end_multiply",
  "open_statement", "$@115", "open_body", "open_file_entry",
  "_open_exclusive", "open_mode", "_open_sharing", "_open_option",
  "lock_allowing", "open_lock_option", "allowing_option", "allowing_all",
  "open_option_sequential", "osvs_input_mode", "perform_statement",
  "$@116", "perform_body", "$@117", "$@118", "_end_perform",
  "end_perform_or_dot", "perform_procedure", "_perform_option",
  "perform_test", "cond_or_exit", "perform_varying_list",
  "perform_varying", "_by_phrase", "purge_statement", "$@119",
  "raise_statement", "$@120", "raise_body", "exception_name",
  "read_statement", "$@121", "read_body", "_read_into", "_lock_phrases",
  "ignoring_lock", "advancing_lock_or_retry", "_retry_phrase",
  "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@122", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@123", "release_body",
  "reset_statement", "return_statement", "$@124", "return_body",
  "_end_return", "rewrite_statement", "$@125", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search_statement", "$@126", "search_body", "search_varying",
  "search_at_end", "search_whens", "search_when", "_end_search",
  "send_statement", "$@127", "send_body", "_from_identifier",
  "from_identifier", "with_indicator", "_replacing_line", "set_statement",
  "$@128", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@129", "sort_body", "@130", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@131", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "disallowed_op",
  "not_equal_op", "_end_start", "start_transaction_statement",
  "_transaction", "transaction", "stop_statement", "$@132",
  "stop_returning", "_status_x", "stop_argument", "stop_literal",
  "string_statement", "$@133", "string_body", "string_items", "$@134",
  "string_item_list", "string_item", "_string_delimited",
  "string_delimiter", "_with_pointer", "_end_string", "subtract_statement",
  "$@135", "subtract_body", "_end_subtract", "suppress_statement",
  "_printing", "terminate_statement", "$@136", "terminate_body",
  "transform_statement", "$@137", "transform_body", "unlock_statement",
  "$@138", "unlock_body", "unstring_statement", "$@139", "unstring_body",
  "_unstring_delimited", "unstring_delimited_list",
  "unstring_delimited_item", "unstring_into", "unstring_into_item",
  "_unstring_into_delimiter", "_unstring_tallying", "_end_unstring",
  "validate_statement", "$@140", "validate_fields", "use_statement",
  "$@141", "use_phrase", "use_file_exception", "use_global",
  "use_file_exception_target", "use_debugging", "debugging_list",
  "debugging_target", "_all_refs", "use_start_end", "program_start_end",
  "use_reporting", "use_exception_list", "use_exception", "use_ex_keyw",
  "write_statement", "$@142", "write_body", "from_option", "write_option",
  "before_or_after", "write_handler", "_end_write",
  "xml_generate_statement", "$@143", "xml_generate_body", "$@144", "$@145",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_name_of",
  "identifier_name_list", "identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@146", "xml_parse_body", "$@147",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_display_exception_phrases",
  "_disp_on_exception", "disp_on_exception", "_disp_not_on_exception",
  "disp_not_on_exception", "_xml_exception_phrases", "_xml_on_exception",
  "xml_on_exception", "_xml_not_on_exception", "xml_not_on_exception",
  "_json_exception_phrases", "_json_on_exception", "json_on_exception",
  "_json_not_on_exception", "json_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@148", "expr_tokens",
  "expr_token", "_not_expr", "not_expr", "condition_or_class", "eq", "gt",
  "lt", "ge", "le", "exp_list", "_e_sep", "exp", "exp_term", "exp_factor",
  "exp_unary", "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "length_of_register", "report_x_list", "expr_x",
  "arith_x", "arith_nonzero_x", "numeric_literal", "non_numeric_literal",
  "nonzero_numeric_literal", "prog_or_entry", "alnum_or_id",
  "simple_display_value", "simple_display_all_value", "inspect_from",
  "inspect_to", "simple_value", "simple_all_value", "id_or_lit",
  "id_or_lit_or_func", "id_or_lit_or_length_or_func", "num_id_or_lit",
  "positive_id_or_lit", "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit",
  "from_parameter", "sub_identifier", "table_identifier",
  "sub_identifier_1", "display_identifier", "numeric_identifier",
  "identifier_or_file_name", "identifier_field", "identifier",
  "identifier_1", "identifier_list", "target_identifier",
  "target_identifier_1", "display_identifier_or_alphabet_name",
  "qualified_word", "unqualified_word", "$@149", "unqualified_word_check",
  "subref", "refmod", "integer", "symbolic_integer",
  "unsigned_pos_integer", "integer_or_zero", "class_value", "literal",
  "basic_literal", "basic_value", "zero_spaces_high_low_values",
  "function", "func_no_parm", "func_one_parm", "func_multi_parm",
  "func_refmod", "func_args", "trim_args", "length_arg", "$@150",
  "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "flag_initialized", "flag_initialized_to", "to_init_val", "_flag_next",
  "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_advancing", "_after",
  "_are", "_area", "_areas", "_as", "_at", "_before", "_binary", "_box",
  "_by", "_character", "_characters", "_collating", "_contains",
  "_controls", "_control", "_data", "_end_of", "_every", "_file", "_for",
  "_from", "_in", "_in_equal", "_in_order", "_index", "_indicate",
  "_initial", "_into", "_is", "_is_equal", "_is_are", "_is_are_equal",
  "_is_in", "_key", "_line", "_line_or_lines", "_limits", "_lines",
  "_lock", "_message", "_mode", "_new", "_number", "_number_or_numbers",
  "_of", "_on", "_on_for", "_onoff_status", "_other", "_others",
  "_procedure", "_program", "_protected", "_record", "_records", "_right",
  "_sign", "_signed", "_sign_is", "_size", "_standard", "_status",
  "_symbolic", "_tape", "_terminal", "_then", "_times", "_to", "_up",
  "_when", "_when_set_to", "_with", "_with_for", "column_or_col",
  "columns_or_cols", "column_or_cols", "column_or_col_or_position_or_pos",
  "comp_equal", "exception_or_error", "file_limit_or_limits", "in_of",
  "label_option", "line_or_lines", "lock_records",
  "object_char_or_word_or_modules", "records", "reel_or_unit",
  "size_or_length", "length_of", "track_or_tracks", "using_or_varying",
  "detail_keyword", "ch_keyword", "cf_keyword", "ph_keyword", "pf_keyword",
  "rh_keyword", "rf_keyword", "control_keyword", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183
};
# endif

#define YYPACT_NINF -3857

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-3857)))

#define YYTABLE_NINF -3134

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -3857,  1286,  1588, -3857, -3857, -3857,  1816, -3857,   739, -3857,
   -3857,  1326, -3857, -3857, -3857,    -7, -3857,  1153,   724, -3857,
    1331, -3857, -3857, -3857,   739,   739,   975,  1728,  1711, -3857,
    1283,  1083,  1135,  1783,  1749, -3857,  1658, -3857,  1854,  1319,
    1896,  1394,  1697,  1302,   -77,   -77, -3857, -3857,  1783, -3857,
   -3857, -3857, -3857,  1228,  1430,  1877, -3857,  1941, -3857,  1348,
   -3857,  1360,  1484, -3857,  1930,   121,   121,  1473,  1527,  1658,
    1658,  1658,   121,  1530,  1452,  1460,  1658,  1466,  1479,   330,
   -3857, -3857, -3857,  1302, -3857, -3857, -3857, -3857, -3857, -3857,
    1400, -3857, -3857, -3857, -3857,  1924, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2280,
    2280,   -68, -3857,   -68, -3857, -3857, -3857, -3857, -3857,  1834,
    1658,  1932,  1519,  1576,  1640, -3857, -3857,  1538,  1544, -3857,
   -3857, -3857, -3857,  1136,  1658, -3857,  1658,  1442,  2237,  1442,
    1658,  1658, -3857, -3857,  1442, -3857, -3857, -3857,  1461,  1470,
    1658,  1571, -3857, -3857, -3857, -3857,  1475, -3857,  1940,  1162,
   -3857, -3857, -3857,  1580,  1581, -3857,  1658,    96,  1680,  1583,
   -3857,  2185, -3857, -3857, -3857,  1586,    -3, -3857, -3857,   -96,
    1136, -3857,  1658,   617,  1442,  1952,   937, -3857, -3857, -3857,
   -3857,  1956,  1570,   648,   -20, -3857,  1500, -3857,  1461, -3857,
    1658, -3857,  1470, -3857,   153, -3857,   121, -3857, -3857, -3857,
   -3857, -3857,  1277,   -74,  1658,   113, -3857, -3857,  1597, -3857,
    1799,  -102, -3857, -3857,   806, -3857, -3857, -3857, -3857,  1658,
   -3857, -3857,  8137,  8825, -3857, -3857, -3857,  1518, -3857,   882,
     128,  1616,   -70, -3857, -3857,   631, -3857, -3857, -3857,   624,
    1474, -3857, -3857, -3857,  -239, -3857, -3857,  1442, -3857,  1718,
   -3857,  1700, -3857,  1658, -3857, -3857,   461, -3857, -3857, -3857,
   -3857, -3857,   257,  2336,  2328,   130,  1537, -3857,   169, -3857,
   -3857,   -33, -3857,   276, -3857, -3857, -3857, -3857,  1997, -3857,
     -74, -3857,  2044,   121,   121, -3857,  1277, -3857, -3857,  1637,
   -3857,  1036, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1265,   725,  9394, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1614, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
    2123, -3857, -3857, -3857, -3857, -3857,   -40, -3857, -3857, -3857,
   -3857, -3857,   942, -3857, -3857, -3857, -3857,  1736, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1614,
   -3857, -3857, -3857, -3857,  1614,  1357, -3857, -3857,  1863, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857,  1234, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  1760,  2335, -3857,   397,  1657, -3857, -3857,
   -3857,  1913, -3857,   121,  1478, -3857,  1920,  1288, -3857,   174,
   -3857, -3857, -3857, -3857, -3857, -3857,  1658,  1658, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1317, -3857,  1674,
   -3857, -3857,  1891, -3857, -3857, -3857,  1658,  2027, -3857, -3857,
   -3857, -3857,   745,  1658, -3857, -3857,  1756,  2078, -3857,  2280,
    1190,  2280,  1666, -3857, -3857,  1668,  2297,  1569, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857,  1679, -3857, -3857,  1997,
   -3857,   121, -3857, -3857, -3857, -3857, -3857, -3857,   756, -3857,
   -3857, -3857, -3857,  1875, -3857,  2357, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1585, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   698, 13467,
   17992,  -184,   725,   618,   830, -3857, -3857, -3857,   458,  2484,
    -408,   139,  1014, 12820, 14319,  1014,  2144,   725,  1180,  1257,
     458,  1442,  1686, -3857, -3857, 14319, -3857,  6124,   458,  1589,
      78,  5117, -3857, -3857,  1442,    78,  6381, 14319, -3857,  2208,
    -104,  1592,   -80,  1593,  1592,  1442,  1593,  -400, -3857,   140,
    1592,   216,  1442,  1593, -3857, -3857, -3857, -3857, -3857,  1442,
   -3857, -3857, -3857, -3857, -3857, -3857,  1676, -3857, 13591, -3857,
   -3857,  1589,   111,  1442,  1593,  5171,  1442,  -400, -3857, -3857,
    1689,  1796,  2049,  1461,  1461,  1461,   926,  1693, 15608, -3857,
   -3857, -3857,  2071, -3857, -3857, -3857, -3857,  1920,  1686,  1686,
    1959,  1920,  1920,  1686,  1920,  1920,  1686,  1920,  1920,  1692,
   -3857,  2226,  -181, -3857, -3857, -3857,  2485,  1699, -3857, -3857,
     110,  1694,  1609, -3857, -3857,  1474,  2068,  2027, -3857, -3857,
    -169, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
    2036, -3857,  1569, -3857, -3857, -3857, -3857, -3857, -3857,    76,
   -3857,  1117,  2291, -3857, 16580,  1703,  2052,  2192,  1959, -3857,
   -3857, -3857,  1442, -3857, -3857,  1710,  1712,  1714, -3857, -3857,
    1716,   937,   937,  1719,  1721,  1723, -3857, -3857,  1725,   937,
   -3857, -3857, -3857,  1442,  1726, -3857,  1714, -3857,  2311, -3857,
   13666, -3857, -3857,  9674, -3857, -3857, -3857,  1729,  1731,  1732,
   -3857, 18027, 17992, 18027, -3857,    88,   497, -3857,  2262, -3857,
   -3857,  9674, -3857,   427,  1679, -3857, -3857,  -184, -3857,  1750,
   -3857,   937, -3857,  2322,  -104, -3857, -3857,   618, -3857, -3857,
   -3857, -3857, -3857,  1593, -3857,   971,  1959,  2323, -3857,   198,
   -3857,  1879, -3857, -3857,  1676,  1679, -3857, -3857,  1593,  2320,
    1931,  2412, -3857, -3857,  1442,  1778,  1779, -3857, -3857, -3857,
    1592, -3857,  2215, -3857,  1549,  2499, -3857, -3857, -3857, -3857,
   -3857,  2333,  1059, 13842, -3857, -3857, -3857, -3857,  1669,  1703,
   -3857, -3857, -3857, -3857, -3857,  2215, 12269,  1555,  1559,  2337,
     277, -3857,  1769,  2129, -3857, -3857, -3857,  2338,   102, -3857,
   -3857, -3857,  8987, -3857, -3857,  2406,   -40, -3857, -3857, -3857,
     458, -3857, -3857, -3857, -3857, -3857,  2319, -3857, -3857,  1793,
   -3857, -3857,   392, -3857,  1589, -3857, -3857,  1442, 11781,  -142,
   -3857,   807, -3857,    98, -3857, -3857, -3857,  1442,  1442, -3857,
   -3857, -3857,  1767, 10995,  -142,  2346, 14319, -3857,  1787,  2348,
    2517, -3857,  1459, -3857,  1507, -3857, -3857,  4319,  1800, -3857,
   -3857,  1690, -3857, -3857,  2349,  1224,  2347,  -143, -3857,  2263,
   -3857,  2350,  1931,  1698,  2352, -3857,  2263,  1442,  2355,  1717,
   -3857, -3857,  2268,  9674,  2316, -3857, -3857, -3857, -3857, -3857,
   -3857,  2130, -3857,   458, -3857, -3857, -3857,  2011,  -178, -3857,
     331,  2583, -3857,   150, -3857,  2364,  1554, 13114, -3857, 17992,
    1798, -3857,  2367,  2222, 14319,  1442,  1442,  2368, 13966,  1589,
   -3857, -3857,   689, -3857, -3857, -3857, -3857,  8458, -3857,  2286,
   -3857, -3857,  1477, -3857,  2369,  2434, -3857, -3857,  1442, -3857,
    2370,  2263,  1442,  1442, -3857,  1818,  1925,  2186, -3857, -3857,
    1982,  1822, -3857,  1827, -3857, -3857, -3857,  2494, -3857,  1440,
    8959,  1442,  1442,  2027, -3857,  2027,  1593,  1593,  2027,  1593,
    1593,  1442,  1593,  1593, -3857,  1855, -3857,  1222, -3857, -3857,
   -3857, -3857,  2313, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   797, -3857,
     151, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
      60, -3857, -3857, -3857, -3857, -3857, -3857,  1738,   -43, -3857,
   -3857,   223, -3857, -3857,  1974, -3857, -3857, 16580,   665, -3857,
   -3857,  1658, -3857, 16580, -3857, -3857, -3857,  1217,  1844,  7915,
      41,  1442, -3857,  2486,  3575,   -67,  1842, 17992, 17992, 11293,
   -3857, -3857,  1744,  1746, 17992, 17992, 17992,  9674,  1753,  1848,
    9674, -3857, -3857, -3857, 14362,  2314, -3857, -3857,  1679, -3857,
   17992, -3857,  9674, 17992, -3857, -3857,  1252, -3857,  2273, 17992,
   17992, 17992, 17992, 17992, -3857,  1679, -3857, -3857,  2216, -3857,
    2060,  2219, -3857, -3857,  5171, -3857,  1442,   971, -3857, -3857,
   -3857,   -25,   858,  1442, -3857, -3857, -3857, -3857, -3857, 17992,
    2187, -3857,  1798, -3857, 17992,  1593, -3857, -3857, -3857, -3857,
    2000, -3857, -3857, -3857, -3857, -3857, -3857,  -131,  1669, -3857,
    1766, -3857, 14319, -3857, -3857, -3857, -3857, -3857,  2138,  2389,
   -3857, -3857, 12269,   341,  5066, -3857,  1188,  1817,  1775,  1059,
    1059,  1059,  1059, -3857, -3857, 14319, 14362, -3857,  1585, -3857,
   -3857,  1180, -3857, -3857,  1781, -3857,   255, -3857, -3857,   670,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, 12563, -3857,
   -3857, -3857,  3124, -3857, -3857, -3857,  2234,   -37, -3857,  2455,
    1888,  2377, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,  2027, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,   -95, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, 11781, -3857,   -95,   -95,   -95,  -142, -3857,  1147,
     189, -3857, -3857,  2032, -3857, -3857,  2442,  2351,  2442,  2293,
     155, 17992, -3857, -3857,  -118,  6999, -3857, -3857,   143, 15955,
    -142, -3857, -3857,  1892,   458, -3857, -3857, 14362, -3857, -3857,
   -3857, -3857, -3857,  1972,  1959, -3857,  1370, -3857,  2340,  2340,
    -422,  1902,  1391,  1898, -3857,  1185, -3857, -3857,  1911, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857,  1931, -3857, -3857, -3857,
   -3857,  2307,  5117, -3857, -3857, -3857,  2308, -3857, -3857, -3857,
    2000,  2474, -3857, -3857,  1442,  2474,  1442,  1803,    94,  1903,
   -3857, -3857,  1679, -3857,  1904, -3857, -3857,   403,  1908,  1277,
   -3857, -3857, 13322, -3857,  2633,   264,   159, -3857, -3857, -3857,
    1658, -3857,   253, 14319, -3857, -3857,  1013,    82,  1261, 17992,
   -3857, -3857, -3857,  1442, 14319, -3857,  2522,  2379,  2380, -3857,
   -3857, 14362, -3857, -3857, -3857, -3857,  9674, -3857, -3857, -3857,
   -3857, -3857,  2644,  2324, -3857, -3857, -3857,   432,  2463,  2386,
    2463,     0,   882, -3857,  1914,  2022,  2075,  1849,   953, -3857,
   -3857, -3857, 16832,   953,  2584,  1658,  1510,  1510,  1658,    25,
    1834,  1658,  2709, -3857,  2188, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,   121,   145,  1923, -3857,  5874,
    1442, -3857,  1920,  1920,  1438,  1593, -3857,  1593,  1920,  1593,
    1593,  1920,  1593,  1593, -3857,  2584,  1959,  1959,  2098,  1593,
   -3857, -3857, -3857,   797, -3857, -3857, -3857, -3857,   937, -3857,
   -3857,   636, -3857, -3857, -3857, -3857,  2292,    90,    90,   733,
    1927,  1672, -3857, -3857, -3857, -3857,  2671, -3857, -3857, -3857,
    2201, -3857, -3857, -3857, -3857,  2201,  -175, -3857,  1658, -3857,
   -3857, -3857, -3857, -3857,  1658, -3857, -3857,  1658, -3857,  1658,
   -3857, -3857, -3857, -3857, -3857,    87, -3857, -3857, -3857,  2641,
   -3857, -3857, -3857, -3857, -3857, -3857,   -15, -3857, -3857, -3857,
    2736, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2330,  2009,
     173, -3857,  2618,  -362, -3857, -3857, -3857, -3857, -3857,  1672,
   -3857, -3857, -3857,  1829,  1833, -3857,  9674,  1672,  2343,  1993,
    1995,  2218, -3857, -3857, -3857, -3857, -3857,  2275, -3857, -3857,
   -3857, -3857, -3857, -3857,   256, -3857,  1442,   379,  1171,  1955,
     395,  1964, -3857,   410,  -258,  9674, -3857, -3857,   366,  1965,
    1966,  1968,   424, -3857,  1679, -3857,  1970, -3857,  1442,   430,
    1975,  1959,  2419,   210, -3857,   265,    67,   458,  1361,  1976,
     435, -3857,  1979,  2216,   497,   497, -3857, -3857, -3857,  2027,
    2112,  1980,  -184, -3857, -3857,  1278,  2759,   641, -3857, -3857,
    2115,  2146, -3857,  1182,  1658, -3857, -3857,  1165, -3857,  1878,
     957, -3857, -3857, -3857,  2383, -3857, -3857, 14319, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,    62, -3857, -3857,  6294, -3857,
   -3857,  2784,  -118, -3857, -3857, -3857, -3857,   -99, -3857,  1658,
   -3857,     2,  -118, -3857, -3857, -3857, -3857,    -1,  1658, -3857,
   -3857, -3857,  5066, -3857, -3857,  1188, -3857, -3857,  1679,  1442,
   -3857, -3857, -3857, -3857, -3857, -3857,  2452,   210,  2453,  2354,
    1928, -3857,  4596,  2243, -3857, -3857, -3857, -3857, -3857, -3857,
    1885,  3124, -3857, -3857, -3857, -3857, -3857,  1686, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,   141, -3857,  1920,
   -3857, -3857, -3857,  2562, -3857,  1686, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  2153,  1686, -3857, -3857, -3857, -3857, -3857,
    1442, -3857,  1442,  1442,  1442, -3857,  2001, -3857, -3857,  1679,
   -3857,  2733, -3857, -3857, -3857,   428, -3857,  1147,  5030, -3857,
   -3857, -3857,  1442, -3857,  1442,   104,   338,  2591, -3857, -3857,
     564, -3857, -3857, -3857, -3857, 14319, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,   458,   458,   210,
    2466,  1803,  2000,  1391,  2430,  9033,    -8,  5154,  1442,  -184,
    2002, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   432,
    2308,  1442, -3857, -3857, -3857, -3857,  1442,  1021,   947, -3857,
    1916, -3857,  1919, -3857,   432,    65,  9674,  2267,  1242,   696,
   -3857,  1959,   256,  2272, -3857, -3857, -3857, 14319,  1277,  1277,
    1277,  1277,  1277,  1277,  1277,  1277,   264, -3857,   868,   957,
    -113, -3857,  2062,  2062, -3857, -3857, -3857, 17992, 17386,  1261,
    -278, -3857,  2644, -3857,  1442,  1442,   210,  2477,  2027,  2017,
   -3857,  2816,  1442,   861, -3857, -3857,  2000,  2828, -3857, -3857,
    1442, -3857,  2164,  2606, -3857, -3857, -3857,  2028,  2133,  2145,
     288, -3857,  1961, -3857,  2498,  1442,  1086, -3857, -3857,  -344,
    -331,  -326,   579,  1067, -3857,  1954, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,  3809, -3857,  2175, -3857,  1074, -3857,  2405, -3857,
   -3857,  1442,  2827,  2457, -3857, -3857, -3857,   883, -3857, -3857,
   -3857,  1658, -3857, -3857, 17068, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857,  1094,  -127,  1244,  2516,
   -3857,  2027,  1609,   288,   288,  1962,  -186,   681,  2027,  1981,
    1658, -3857, -3857, -3857,   -78,  1556, -3857, -3857, -3857, -3857,
    1834,  2343,  1931,  1686, -3857, -3857, -3857,  2148,  2343,  1658,
    2764,   405,  -122,   945,  1803, -3857, -3857, -3857,  1658,  1658,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2111, -3857,
    2417, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  2161,  2832,   288, -3857,  1593,  1593,
   -3857, -3857,  1920, -3857,  1593,  1593,  1593,   988,  1593, -3857,
    1593,   797, -3857,  1738,  1658,  1658,  1977, -3857,   112, -3857,
    -347,  -303,   250, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1684,  1442,  1806, -3857, -3857, -3857,   665,   665, -3857,
   -3857, -3857, -3857,   665,   665,  -175,   665, -3857, -3857, -3857,
    1658,   564, -3857,   564, -3857,  -175,  2430,  1658,  2076,   817,
    2436,  2436, -3857, -3857, -3857,  1672, -3857, -3857, -3857, -3857,
   -3857, -3857,   144, -3857, -3857, -3857, -3857,  1879, 14704,  1729,
   17610,  1729, -3857,  2077, -3857, -3857,  1442,  1729,  1729,  1729,
    9674, -3857,  1879,  -120,  1729,   -67, -3857, -3857, -3857,  2353,
    2149,   310,  2542,   210, 17850,  1729,  1729,   477, -3857,  2112,
   -3857,   458, -3857, -3857, -3857,  2340, -3857, -3857, -3857, -3857,
   -3857,  2385, -3857, -3857, -3857,   806, -3857, -3857, 17992, -3857,
   -3857, -3857, -3857,  2358,  2488,   814,  1817,  1016, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   665, -3857,
   -3857,   665, -3857, -3857, -3857, -3857,   -92,  2663,   665,   564,
     564,   665, -3857, -3857, -3857,  3268,  3268,   458, -3857,   458,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2880, -3857,
    2100,    11,  4596, -3857, -3857, -3857, -3857, -3857,  1442, -3857,
   -3857, -3857,  2672,  2020,  1655,   199,  2021, -3857, -3857, -3857,
   -3857,   477,  9674, -3857, -3857,  2829, -3857,   436, -3857, -3857,
    5030, -3857,   436,  2575,  2578,  2747,   -19, -3857, -3857,  2189,
   -3857, -3857,  2343,  1300, -3857, -3857, -3857, 14319,   458, -3857,
     458,   368,  1593, -3857,  1442, -3857, -3857,     3, -3857, -3857,
   -3857,  2903, -3857,  2573, -3857, -3857, -3857,   260,   985, -3857,
   -3857, -3857, -3857,  2382,  2680,   957, -3857,  1444, -3857, -3857,
    6124, -3857,  1919,  2261, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,    70, -3857, 14319, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   -12, -3857,
    1442, -3857, -3857, -3857,  1024, -3857, -3857, -3857, 17992, -3857,
   14319, 14319,  1171, -3857,  1445,  -221,  2327, 14090,  1879,  1879,
   -3857,   458,  2104, -3857,   477, -3857,  2362, -3857,  9674, -3857,
    2725,  2135, -3857,   947, -3857,   894,  2747,  2432,  2043,  9674,
    2837,   882, -3857,  2114,  2221, -3857,  2055,  1658, -3857,  2131,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  2008,  3968, -3857, -3857,  2846,  2085,
    2127,  -145, -3857, -3857, -3857,  1442, -3857, -3857, -3857, -3857,
    3988, -3857,  2905, -3857,  2644, -3857,  2223,  2223,  2030, -3857,
    2055, -3857,  2139,  2608, -3857, -3857, -3857,  1962, -3857, -3857,
   -3857, -3857, -3857, -3857,  2504,    97,  2430,   447,  1658, -3857,
   -3857,  1658, -3857,  1658,  1658,  2343,  1205, -3857,  1658,  1200,
    1658,  1658,  1658,  1658, -3857,  2260, -3857,   368,   681,  2027,
    1658,  1834,  2394, -3857,  2228,   681,  1593,  1593,  1593,  1593,
    1593,  1593, -3857,  2360, -3857, -3857,  2933, -3857, -3857, -3857,
   -3857, -3857, -3857,  1658,  2217,  2397, -3857, -3857, -3857,  2767,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,   814, -3857,  1743, -3857, -3857,
    1442,   696, -3857, -3857,  2151, -3857, -3857, -3857,  1658,  1053,
   -3857, -3857,  -188, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  2615, -3857, -3857, -3857,  2611, -3857, -3857,
   -3857, -3857, -3857, -3857,  2612, -3857, -3857,  1451, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,  1585,  2754, -3857,  -311, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  -118,  -118,  -118,
    -118, 14319, -3857,  1016, -3857,  7770, -3857, -3857, -3857, -3857,
    1959, -3857, -3857, -3857, -3857, -3857, -3857,  1095,   665,  2485,
   -3857, -3857, -3857, 11195, -3857, -3857, -3857,   596, -3857, -3857,
   -3857, -3857,  3836, 11195,   210,  2312,   210,  2315,    95,  4596,
   -3857, -3857, -3857, -3857, -3857,  2880, -3857, -3857, -3857, -3857,
    1655, -3857,  2786, -3857, -3857,  1686, -3857,   436, -3857, -3857,
     436,   477,  2154,  2154, -3857,  2956,  2918, -3857, -3857, -3857,
    2430, -3857,  2479,  2769,    68, -3857, -3857,  2415, -3857, -3857,
     210,  2414,  2414,  2423, -3857,   675, -3857,  2729, -3857, -3857,
   -3857,  1442, 14319,  1920,  2523,  2564, -3857,   753, -3857, -3857,
   -3857,   301, -3857, -3857, -3857,  2801,  2471, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  2528, -3857, -3857, -3857,  2545, -3857,
    1959,  1959, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1171,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2451,  2166,  1658,
   -3857, -3857, -3857,  -188,  2615,   210,  2121, -3857, -3857,  2816,
   -3857,  2430,  2747,  2430,  -221,  1344, -3857, -3857,  1786, -3857,
   -3857,  1803,  2387, -3857,   121, -3857,   882, -3857,   882, -3857,
    2182, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
    2197, -3857,  2055, -3857,  1872,  1442, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,  1002, -3857, -3857,  2546, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  2430,  2659,  2194,  2027,  2194,  2264,  2094,
   -3857, -3857, -3857, -3857, -3857,  2554, -3857,   814,   390,  2764,
   -3857, -3857, -3857,  2055,  2027,   188,  1442, -3857, -3857, -3857,
   -3857,  2027, -3857,  1700, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,   824,   824,    39,  1442,  1658, -3857, -3857,  2150,
   -3857,  1442, -3857, -3857,   681, -3857,  1442,  1442, -3857, -3857,
   -3857, -3857,  2901,  1438,  1442,  1658,  1442,   -43, -3857,   681,
    2205,  1593, -3857,  2027, -3857,   797,    35,  1216,  1143,  1658,
   -3857, -3857,  2099,  2195, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,   696, -3857, -3857,  2623,  2811, -3857,  1928,
   -3857, -3857, -3857,  3268, 14319, 14319, 14319, 14319, -3857, -3857,
   -3857, -3857, -3857,  1442, -3857,  -118, -3857, -3857, -3857, -3857,
    2207,   997, -3857, -3857,   458, -3857,   458, 13059, -3857,  1124,
      51, -3857, -3857, -3857, -3857, -3857,  2934,  2824, -3857, -3857,
     436, -3857, 14319, 14319, -3857, -3857,  1442,  2479,  1959,  2239,
   -3857,  2413,  1593,     5,  1442, -3857, -3857, -3857, -3857, -3857,
   -3857,   138, -3857, -3857, -3857, -3857, -3857,  2511, -3857,  -203,
   -3857, -3857,  2512,  1105, -3857, -3857, -3857,  2948,  2569, -3857,
    1658,  1553, -3857, -3857,   -86,  2570,  2572, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1593,
    1593, -3857, -3857, -3857, -3857, -3857, -3857,  1442, -3857,  2811,
   -3857, -3857, -3857,  2224, -3857,  1442, -3857,  1442, -3857, -3857,
   -3857, -3857, -3857,  2500,  2758, -3857, -3857, -3857, -3857,   177,
    -387,  2427, -3857, -3857, -3857, -3857, -3857,   357,  -366, -3857,
   -3857,  1959, -3857, -3857,  2055, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857,  2132,  2027,  2230, -3857,
    2839, -3857,  2843,  1658, -3857, -3857, -3857, -3857,  2281, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1442,    58,
    2901,  1383, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1442, -3857, -3857, -3857, -3857,  2703, -3857, -3857, -3857,
   -3857,  3036, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   585,
     918, -3857, -3857, -3857, -3857, -3857,   164,  -317, -3857, -3857,
   -3857,  1442,   268,  1658, -3857,   655,  1609,  2246,   681, -3857,
   -3857,  2556,  3033, -3857, -3857, -3857,  1058,  -208, -3857, -3857,
   -3857, -3857,   696,  2623,  -188,   -40, 11195, -3857, -3857, -3857,
   -3857, -3857,  1442,  -118, -3857, -3857,  -188,  -188, -3857, -3857,
   14319, -3857, -3857, -3857, -3857, 14319, -3857, -3857, -3857, -3857,
   -3857,  2239,  1442,  1442,  1226,  1658,  1593,  1593,  2447, -3857,
   -3857, -3857,  2490, -3857, -3857, -3857, -3857, -3857, -3857,  2376,
   -3857, -3857, -3857, -3857,  6378,  2199, -3857,  1442, -3857, -3857,
    2382,  2680, -3857, -3857, -3857, -3857, -3857, -3857,  -188,  1137,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2565,
     177, -3857,   125,  2155, -3857, -3857,  1658, -3857,  2439,   776,
   -3857,  2341, -3857,  2242,  1442, -3857, -3857, -3857,  2027,  2678,
    1920,  1920,   290,  2027, -3857,   681,   681, -3857, -3857, -3857,
   -3857,  2740, -3857, -3857,  2139,  2027,  -317,  1442,  1692, -3857,
   -3857, -3857, -3857,  1442, -3857, -3857, -3857, -3857, -3857,  1658,
   -3857,  2493, -3857, -3857, -3857,   820,   244,   820, -3857,  1609,
    1658,  1658,  1609,   681, -3857,  1658,  1658, -3857, -3857,  2597,
   -3857,   133,  2269,   696, -3857,   -29,   283, -3857, 14319, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1442, -3857,  1658,
    1442, -3857, -3857, -3857, -3857, -3857,  2543,  2796,  -184,  1593,
    1658, -3857, -3857, -3857, -3857,  9674, -3857, -3857, -3857, -3857,
    6124, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,  1784, -3857, -3857, -3857,  1595, -3857,  1690,  2475,
    2897,  1658,  2479, -3857, -3857,  9674, -3857, -3857, -3857,  -184,
      50,  1589, -3857, 14976, -3857, -3857,   776,  2276,  2278,  1658,
   -3857, -3857,   290,  1442,  1442,  2644, -3857,  2705, -3857,   338,
    2343,  1359, -3857, -3857, -3857,  3055,  2901, -3857,   -39, -3857,
   -3857, -3857, -3857, -3857,   -39, -3857,  1442,  1442,  -111, -3857,
   -3857,  2411, -3857,  2628, -3857, -3857,  1609,  1609, -3857, -3857,
   -3857, -3857,  2366,    -6,   696, -3857, -3857, -3857, -3857, -3857,
    2574,   -21,  1959, -3857, -3857, -3857, -3857, -3857,  1442, -3857,
    1226, -3857,   276, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  -184, -3857,  1679, -3857, -3857,  2443,  2361, -3857,  2288,
      15,  1920,  9674,  2266, -3857, -3857, -3857, -3857,  -237, -3857,
    2294,  2034,  2300, -3857, -3857,   357, -3857,   290, -3857, -3857,
   -3857, -3857,  1658,   338,   681,  2911,  2493,   996,  1658, -3857,
   -3857, -3857, -3857, -3857,  2561, -3857, -3857,    35,  1216, -3857,
   -3857,  1658,  2926, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1442, -3857, -3857, -3857, -3857,  1442, -3857,  1642,  1593,
    2301, -3857, -3857, -3857,   147,  2626,  1959,  2344,  1294,   481,
      56,   166, -3857, -3857,  2425, -3857, -3857, -3857,  1977, -3857,
   -3857, -3857, -3857, -3857,  1920, -3857,  2356, -3857,  2900,  1442,
    1297,  2630,  3106,  -175,  2321, -3857, -3857, -3857, -3857,  2520,
   -3857,  1593,  1263,   147, -3857, -3857,  1658, -3857,  1442,   208,
   -3857, -3857, -3857, -3857,  2593,  2848,   195,  2720,  2721,  2942,
    2711, -3857,   481, -3857,  1350,   870,  2331,   230, 17466,   564,
   -3857, -3857, -3857,  1977, -3857,  1442,  2248, -3857, -3857, -3857,
    1536, -3857, -3857,   849,  1658,  1658, -3857, -3857, -3857,  1920,
   -3857, -3857, -3857,  2594,  1442, -3857,  9674,  1442, -3857,  1658,
    1028,   852,   208, -3857, -3857,  1294, -3857, -3857, -3857, -3857,
   -3857, -3857,  1658,  2598,  1442,  1658,  1658,  1658,  1658, -3857,
    2734,    52,  2735, -3857,  2722, -3857,  1754, -3857, -3857,  1442,
    2989,  1287,  2737,    63,  2739,  2728, -3857,   979, -3857, -3857,
    1442,  2372, -3857,   288,   288,  1864, -3857, -3857, -3857, -3857,
    2808,  3047,   -94, -3857,  1658, -3857, -3857, -3857, -3857,   791,
   -3857,  2201,  2201,  1658,  -118,     2,  1658,  5117, -3857, -3857,
   -3857, -3857,  2201,  -118, -3857,  2941,  2027, -3857,  3065, -3857,
   -3857,  -118, -3857, -3857,  1442, -3857, -3857,  1442, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2820,
    2201, -3857, -3857, -3857, -3857, -3857, -3857,   132,   849, -3857,
   -3857,  1609,  1609,    14, -3857, -3857, -3857, -3857,   320, -3857,
   -3857, -3857,   320,   320, -3857, -3857, -3857, -3857, -3857, -3857,
    2616, -3857, -3857, -3857,  1442,  2027, -3857,  1442,  1442,  1442,
    1442,  1658,  1658,  1658,  1658,  1658, -3857,  1442,  1658,  1658,
    1658,  1658,  1658,  1658,  1658,  1658,  1658,  1658,  1658, -3857,
    1442,  1658, -3857, -3857,   288,   288,   711,  2743, -3857,  1658,
   -3857, -3857,  1442,  1442, -3857, -3857,   665, -3857, -3857, -3857,
    1658, -3857,  1658,   665,   564, -3857, -3857,   665, -3857, -3857,
     665,  2194,  1658,   564, -3857, -3857, -3857, -3857, 10148,  1569,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,  1593, -3857, -3857, -3857, -3857,   852, -3857,  2194,
   -3857, -3857, -3857, -3857,  1442,  1442,  1442,  1442,  1442,  1442,
    1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,  1442,
    1442,  1442,  1442, -3857, -3857, -3857, -3857, -3857,  1542, -3857,
   -3857, -3857, 15377, -3857,   814,  1442, -3857, -3857,  1035,  1035,
   -3857, -3857, -3857, -3857, -3857,   160, -3857,   814, -3857, -3857,
   -3857, -3857, -3857, -3857,  2705, -3857, -3857, -3857, -3857, -3857,
    1442, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,  1442, -3857,  1917,   760,   778, -3857, -3857,   711,
    2374, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857,   665, -3857, -3857,   665, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  1442,  1442,   266,  1658,  1658,  1905,  1658,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1895, -3857, -3857,
   -3857, -3857,  1442, -3857, -3857, -3857,  1658,   711,   711, -3857,
    2806,  1658,  1658,   711, 16456,  1442,   711, -3857, -3857, -3857,
     711,   711, -3857, -3857, -3857, -3857,  2785,  1764,  2709,  1658,
    2027, -3857,  1658,  1959, -3857,  1658,  1442, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   109,
   -3857, -3857,   893, -3857,   903, -3857, -3857, -3857, -3857,  1764,
    1442, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   288, -3857,
    1397,  2230, 18171, 18171,  1546,  2836,  2679,  2679,  1922,  6124,
   -3857, -3857,   893,   -49, -3857, -3857, -3857,  2027,   -49, -3857,
     309,  1442, -3857, -3857, -3857, -3857, -3857, -3857,  2027, -3857,
    2194,  1879, 16392, -3857, -3857,  1656,  1683, -3857, -3857,  1722,
   -3857, -3857, -3857, -3857,    17,    17, -3857, -3857, -3857, -3857,
   18171, -3857,   869,   869,  2679,  2679, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,   288, -3857,  1442, -3857,  2843, -3857,
    1920,  1442, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,   -93,   137,  3103, -3857, -3857, -3857,   869, -3857, -3857,
    2613,  2619, -3857, -3857,  2418,   -81, -3857,  2627, -3857,  2627,
   -3857,  2627, -3857,  2627, 18171, -3857, -3857, -3857,  2027, -3857,
   -3857, -3857, -3857,  2620, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,    12,     1,     3,     5,    27,     4,    58,    31,
      30,    27,     8,    10,    11,     0,    28,     0,     0,    13,
      81,     9,    35,    32,    58,    58,     0,    61,     0,    24,
      84,     0,     0,    16,     0,    29,  3009,    59,    67,     0,
     436,     0,   250,    86,     0,     0,    20,    14,    17,    18,
      22,    15,  3010,     0,     0,    69,    82,     0,    25,   439,
     437,     0,     0,    80,   252,     0,     0,     0,  3076,  3009,
    3009,  3009,     0,     0,     0,     0,  3009,     0,     0,  2971,
     247,   164,    83,    87,    88,    90,    91,    94,    92,    93,
       0,   147,   150,   151,   152,   213,   153,   155,   154,   156,
     157,   158,   159,   160,   161,   162,   163,    38,    37,    41,
      41,     0,    19,     0,    63,    64,    65,    66,    62,  3040,
    3009,    74,     0,  1332,     0,   441,    85,     0,     0,   254,
    2647,  2646,   175,   232,  3009,  3077,  3009,     0,     0,     0,
    3009,  3009,   101,   131,     0,    95,   145,  2972,     0,     0,
    3009,  3009,    89,   149,   146,   148,     0,   212,     0,    55,
      33,    40,    39,     0,     0,  3041,  3009,     0,     0,     0,
     438,     0,    26,  1327,  1380,     0,   434,   251,   253,   393,
     181,  2990,  3009,     0,     0,     0,  2750,   243,  2635,   241,
     246,     0,     0,   103,   133,   245,    97,   580,   223,   224,
    3009,  2648,   215,   216,  3014,   219,     0,  2759,  2184,  2183,
     165,   169,   172,  3055,  3009,     0,   214,    42,     0,    56,
       0,  3009,    21,    23,     0,    71,    73,    72,    70,  3009,
      60,  1328,     0,     0,   440,   447,   448,   561,   442,   564,
       0,     0,  2847,   255,   249,   396,   176,   177,   179,     0,
       0,   233,   234,   244,   239,  3128,  3129,     0,   237,     0,
    2970,  3083,  3066,  3009,   129,   102,  3065,   107,   109,   110,
     111,   112,  3065,     0,  2973,     0,     0,   132,     0,   136,
      96,    99,   225,     0,   217,  3016,  3015,   220,     0,   248,
    3055,  3058,  3057,     0,     0,   166,   170,    36,    57,     0,
      45,     0,  2854,  2855,  2856,  2857,  2858,  2859,  2860,  2861,
      68,     0,  1595,     0,  1449,  1560,  1570,  1578,  1585,  1641,
    1647,  2253,  1662,  1668,  1677,  1673,  1685,  1695,  1824,  1833,
    1835,  1841,  1874,  1885,  1888,  1891,  1883,  1898,  1909,  1931,
    1935,  1939,     0,  1995,  1997,  2003,  2007,     0,  2013,  2047,
    2074,  2076,  2081,  2111,  2112,  2128,  2131,  2132,  2137,  2253,
    2147,  2160,  2173,  2214,  2232,     0,  2273,  2289,  2298,  2300,
    1362,  2304,  2307,  2310,  2327,  2366,     0,  1382,  1383,  1384,
    1385,  1386,  1387,  1388,  1389,  1391,  1390,  1392,  1394,  1393,
    1395,  1396,  1397,  1398,  1399,  1400,  1401,  1402,  1403,  1404,
    1405,  1406,  1407,  1408,  1409,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,  1417,  1418,  1419,  1420,  1421,  1422,  1423,  1424,
    1425,  1426,  1427,  1428,  1429,  1430,  1431,  1432,  1433,  1434,
    1435,  1436,  1437,  1438,  1439,  1440,  1441,  1442,  1443,  1444,
    1445,  1446,  1381,     0,   508,   443,  2830,     0,  2617,   444,
     395,     0,  2848,     0,     0,   423,  3050,   406,   394,     0,
     399,   401,   402,   414,   403,   404,  3009,  3009,   182,   183,
    2768,  2764,  2769,  2767,  2765,  2770,  2766,   235,   228,   230,
    3108,   238,     0,  2751,   242,  3084,  3009,     0,   106,   108,
     104,   130,  3065,  3009,  2974,   114,     0,     0,   143,    41,
       0,    41,     0,   134,   137,     0,     0,     0,  2779,  2775,
    2780,  2778,  2776,  2781,  2777,   226,  2771,  2773,  2760,   218,
     221,     0,  3056,   173,   167,   168,   171,    34,    46,    49,
      53,    54,    52,  3065,    47,    48,    76,    77,    78,    79,
      75,  1599,  1602,  1601,  1597,  1598,  1600,  1589,  1596,  2872,
    2873,  2874,  2875,  2876,  2877,  2878,  2879,  2880,  2881,  2882,
    2883,  2884,  2870,  2923,  2924,  2925,  2926,  2927,  2928,  2929,
    2930,  2931,  2932,  2933,  2934,  2935,  2936,  2937,  2938,  2939,
    2940,  2941,  2942,  2943,  2944,  2945,  2885,  2886,  2887,  2888,
    2889,  2890,  2891,  2892,  2893,  2894,  2896,  2895,  2897,  2898,
    2899,  2900,  2901,  2902,  2903,  2904,  2905,  2906,  2907,  2908,
    2909,  2910,  2911,  2912,  2913,  2914,  2915,  2916,  2917,  2868,
    2918,  2919,  2920,  2921,  2922,  1448,  2869,  2871,  1480,     0,
       0,     0,  1595,     0,     0,  2255,  1667,  2254,     0,  1670,
       0,     0,  1690,  1736,     0,  1690,     0,  1595,  2539,  1876,
       0,     0,  3099,  1626,  1625,     0,  1897,     0,     0,     0,
       0,     0,  1978,  1990,     0,     0,     0,     0,  1447,  2018,
    2526,     0,     0,     0,     0,     0,     0,     0,  2146,     0,
       0,     0,     0,     0,  2252,  2269,  2272,  2256,  2270,  2531,
    2271,  2258,  2267,  2259,  2268,  2736,  2740,  2276,     0,  2299,
    2297,     0,  1380,     0,     0,     0,     0,     0,  2382,  2428,
       0,     0,   800,     0,     0,     0,   566,     0,     0,   570,
     571,   569,     0,   446,   449,  2849,   256,  3050,  3099,  3099,
    3048,  3050,  3050,  3099,  3050,  3050,  3099,  3050,  3050,  2987,
    3051,  2985,     0,   407,   408,   409,  2952,     0,   397,   400,
       0,     0,     0,   229,   227,     0,     0,     0,   123,   105,
    2752,   115,   138,   139,   142,   144,   140,   141,   135,    98,
       0,  2772,     0,   222,   174,    51,    44,    50,  1590,  1334,
    1479,  2750,  1558,  1451,  1490,     0,  3038,  1478,  3048,  2806,
    2804,  2807,     0,  2800,  2808,     0,     0,  2814,  3145,  3146,
       0,  2600,  2602,     0,     0,     0,  2803,  2670,     0,  2604,
    2805,  2809,  2810,     0,     0,  2802,  2814,  2801,  1568,  2664,
    1566,  2656,  2659,     0,  2658,  2662,  2663,  2811,     0,     0,
    2671,     0,     0,     0,  1571,     0,  2589,  2592,  2594,  2597,
    2680,     0,  2599,  2836,  2678,  2679,  2632,  1579,  1580,     0,
    2628,  2630,  2629,  1639,  2526,  2709,  1646,  1642,  1643,  1645,
    2708,  1658,  1648,  1649,  1650,  1653,  3048,  1665,  2744,     0,
    2606,  2850,  2651,  2743,  2748,  2652,  1671,  1669,     0,  1683,
    3069,  2977,  1674,  2741,  1676,  3093,     0,  1692,  1694,  1686,
       0,  1733,  1767,  1766,  2775,  2965,  1715,  1765,  1758,  1764,
    1757,  1822,  2453,  2654,  1710,  1712,  1702,  1703,  1716,     0,
    1704,  1705,  1754,  1706,  1707,  1767,  1709,     0,  2658,  1831,
       0,  1834,     0,     0,  1836,  1848,  1847,  1872,     0,  1844,
    1846,  2538,  3009,  1878,  1882,  1880,  1883,  1881,  1875,  1886,
    1887,  2649,  1889,  1890,  3100,  1892,  2626,  1884,  2537,  1903,
    2536,  1910,  1912,  2619,  1932,  1933,  1021,  1773,     0,     0,
    1936,  1020,  1940,     0,  1942,  1943,  1944,     0,     0,  1996,
    2218,  2729,  2730,  2845,     0,  2001,     0,  2004,     0,  2011,
       0,  2019,  2014,  2015,     0,  2994,  2048,  2060,     0,  2618,
    2075,     0,  2077,  2079,  2109,  2842,  2126,     0,  2129,  2369,
    2609,  2135,  3069,     0,  2144,  2610,  2369,     0,  2158,  2151,
    2612,  2161,  2164,     0,     0,  2622,  2174,  2175,  2176,  2177,
    2178,  2179,  2205,  2180,  2208,  2181,  2182,     0,     0,  2620,
       0,     0,  2728,  2748,  2215,  2250,  2237,  2260,  2530,     0,
    2738,  2739,  2287,     0,     0,     0,     0,  2295,     0,  2301,
    2302,  1368,  1374,  1363,  1364,  1365,  1367,     0,  2305,     0,
    2732,  2308,  3071,  2711,  2325,  2313,  2710,  2712,  2328,  2329,
    2380,  2369,     0,     0,   562,     0,     0,   803,   613,   616,
       0,     0,   567,     0,   577,   578,   572,   579,   575,  3009,
       0,     0,     0,     0,  3049,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2988,  3091,  2986,     0,   312,   431,
     313,  2953,  2989,   398,   188,   187,   208,   204,  2752,   209,
     193,   207,   205,   185,   186,   206,   178,   184,   195,   196,
     198,   190,   191,   192,   180,   189,   337,   236,   231,   240,
       0,   126,   128,   127,   124,   125,  2640,     0,  2989,   100,
    2774,     0,  1337,  1335,  1356,  1559,  1450,  1490,  2960,  2962,
    1495,  3009,  1476,  1491,  1492,  1494,  1496,     0,     0,  2979,
       0,     0,  3039,     0,     0,     0,     0,     0,     0,     0,
    2798,  2820,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2799,  1569,  1561,     0,     0,  2657,  2665,  2666,  2667,
       0,  2786,     0,     0,  2596,  2677,     0,  2595,  2838,     0,
       0,     0,     0,     0,  2681,  2682,  2683,  2837,  1574,  1581,
    1583,     0,  1640,  1586,  1605,  1644,     0,  1653,  3141,  3142,
    1651,     0,  1654,     0,  1666,  1663,  3123,  3122,  2607,     0,
    2852,  2608,  2746,  2747,     0,  1680,  1681,  1684,  1678,  3070,
    2094,  2978,  1675,  2742,  3094,  1691,  1693,  1688,  1716,  1768,
       0,  2966,     0,  1823,  1696,  1377,  1377,  1701,  2459,  2456,
    1711,  1708,  2655,  3107,     0,  1735,     0,  1769,     0,  2453,
    2453,  2453,  2453,  1832,  1825,     0,     0,  1837,  1589,  1873,
    1842,  2539,  1859,  1843,  1850,  1851,  1377,  2555,  2553,  3010,
    2559,  2556,  2548,  2552,  2550,  2551,  2547,  2549,  2540,  2541,
    2554,  2543,     0,  1879,  1877,  2650,     0,  1895,  1904,  1905,
    1914,     0,  1934,  1772,  1105,  1133,  1102,  1183,  1118,  1117,
    1182,  1184,  1206,  1185,  1169,  1252,  1286,  1202,  1231,  1205,
    1228,  1274,  1177,  1200,  1196,  1203,  1226,  1272,  1104,  1107,
    1213,  1210,  1103,  1209,  1208,  1258,  1130,  1212,  1131,  1287,
    1135,  1195,  1224,  1075,  1221,  1248,  1239,  1276,  1073,  1249,
    1259,  1222,  1157,  1159,  1158,  1225,  1260,  1261,  1262,  1263,
    1121,  1122,  1251,  1214,  1216,  1215,  1077,  1220,  1155,  1236,
    1129,  1238,  1245,  1246,  1137,  1139,  1250,  1142,  1082,  1234,
    1074,  1180,  1156,  1128,  1099,  1257,  1098,  1101,  1100,  1255,
    1247,  1223,  1207,  1268,  1243,  1244,  1179,  1265,  1266,  1267,
    1256,  1271,     0,  1132,  1233,  1229,  1232,  1264,  1219,  1230,
    1138,  1171,  1201,  1197,  1193,  1204,  1227,  1269,  1270,  1237,
    1140,  1141,  1106,  1273,  1134,  1178,  1136,  1217,  1218,  1254,
    1170,  1172,  1072,  1143,  1160,  1181,  1253,  1285,  1211,  1076,
    1194,  1235,  1176,  1199,  1198,  2995,  1032,  1047,  1048,  1049,
    1050,  1051,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,
    1060,  1061,  1937,  1291,  2995,  2995,  2995,  1938,  1294,     0,
    1965,  1949,  1941,  1946,  1947,  1948,  1988,     0,  1988,     0,
    2222,     0,  2731,  2846,  3011,  1999,  1025,  1027,  3017,     0,
    2000,  2002,  1998,     0,     0,  2012,  2008,     0,  2016,  2023,
    2020,  2022,  2021,  2024,  3048,  2062,  2632,  2714,  2528,  2528,
       0,  2058,     0,     0,  2713,  2629,   583,  2715,     0,  2527,
    2080,  2078,  2110,  2082,  2843,  2844,  3069,  2127,  2113,  2115,
    2116,     0,     0,  2130,  2136,  2133,  2084,  2611,  2145,  2138,
    2094,  2153,  2159,  2148,     0,  2153,     0,  3107,  2162,     0,
    2697,  2703,  2704,  2705,     0,  2206,  2209,     0,     0,     0,
    2621,  2186,     0,  2185,     0,     0,  2746,  2251,  2233,  2239,
    3009,  2240,  2235,     0,  2257,  2262,     0,  2584,  2582,     0,
    2737,  2288,  2274,     0,  2277,  2278,  2281,     0,     0,  2296,
    2290,     0,  2303,  1369,  1373,  1366,     0,  3072,  3073,  2309,
    2326,  2311,  2967,     0,  2330,  2381,  2367,  2371,  2426,     0,
    2426,  2432,   564,   509,     0,     0,   806,     0,   662,  2830,
     568,   574,  3009,   581,  2975,  3009,     0,     0,  3009,  2975,
    3040,  3009,  2950,   445,     0,   450,   453,   454,   455,   456,
     457,   458,   459,   460,   461,     0,     0,     0,   257,  3069,
     410,  2633,  3050,  3050,     0,   418,  2613,   411,  3050,   412,
     420,  3050,   413,   422,  3092,  2975,  3048,  3048,     0,     0,
     194,   197,   200,     0,  3136,  3138,  3137,   113,  2754,  2753,
     116,     0,  2752,  1593,  1594,  1592,     0,  1342,  1342,     0,
       0,  2440,  2718,  1507,  2716,  2717,     0,  1493,  3119,  3118,
    3044,  3121,  3120,  1505,  1506,  3044,     0,  1511,  3009,  1525,
    1526,  1527,  1513,  1515,  3009,  2980,  1516,  3009,  1557,  3009,
    1518,  1521,  1519,  1520,  1522,     0,  1551,  1552,  1529,  1531,
    3068,  1532,  1555,  1553,  1554,  1523,  3101,  1534,  1524,  1512,
    2948,  1536,  1556,  1539,  1497,  1528,  1533,  1538,     0,     0,
       0,  2690,     0,  1485,  1489,  1488,  1481,  1477,  1472,  2440,
    3115,  3114,  1469,  1460,  1462,  1463,     0,  2440,  3024,     0,
       0,     0,  1503,  1453,  1458,  1457,  1467,     0,  1475,  1455,
    1474,  1456,  2694,  2693,     0,  2669,     0,  2584,  2582,     0,
    2584,     0,  2816,  2584,     0,     0,  2601,  2603,  2584,     0,
       0,     0,  2584,  2674,  2675,  2676,     0,  2605,     0,  2584,
       0,  3048,  2744,  2480,  1567,  2748,  2652,     0,     0,     0,
    2584,  2598,  2840,  1574,  2588,  2587,  2591,  2590,  2593,     0,
    1576,     0,     0,  2631,  1587,     0,  1603,  1660,  1652,  1657,
       0,     0,  2653,  2480,  3009,  2851,  2745,     0,  1682,  2989,
    2516,  2095,  2096,  1687,     0,  1734,  1759,  1743,  2458,  1378,
    2461,  2454,  2460,  2455,  2457,     0,  1725,  1724,  1713,  1720,
    1722,     0,  3011,  1810,  1811,  1812,  1799,     0,  1802,  3009,
    1803,  2983,  3011,  1806,  1807,  1813,  1808,  3101,  3009,  1809,
    1816,  1814,  1717,  1718,  1742,  1737,  1738,  1740,  1741,     0,
    1755,  1762,  1699,  1700,  1697,  1698,     0,  2480,     0,     0,
    1609,  1845,     0,  1859,  1852,  1849,  1854,  1855,  1861,  1853,
       0,  2558,  2542,  2569,  2570,  2571,  2560,  3099,  2577,  2580,
    2579,  2581,  2573,  2566,  2568,  2567,  2572,  2574,  2576,  2578,
    2544,  2561,  2562,  2563,  2564,  2565,  2625,  1895,  2623,  3050,
    1893,  2627,  1906,  1907,  1377,  3099,  1922,  1923,  1925,  1927,
    1928,  1924,  1926,  1917,  3099,  1913,  1031,  1290,  2996,  2997,
       0,  1292,     0,     0,     0,  1295,     0,  2749,  2699,  2700,
    1966,     0,  1968,  1967,  1969,  1951,  1961,     0,     0,  1945,
    1989,  1979,     0,  1991,     0,  2224,     0,     0,  3012,  3013,
       0,  1026,  3019,  3018,  3020,     0,  1067,  1192,  1153,  1097,
    1163,  1083,  1186,  1161,  1111,  1079,  1191,  1278,  1188,  1174,
    1108,  1175,  1173,  1144,  1146,  1149,  1109,  1162,  1116,  1165,
    1114,  1154,  1151,  1065,  1166,  1187,  1078,  1120,  1241,  1279,
    1091,  1148,  1085,  1092,  1112,  1084,  1167,  1281,  1168,  1080,
    1127,  1282,  1064,  1071,  1094,  1124,  1125,  1095,  1110,  1068,
    1069,  1126,  1062,  1147,  1093,  1283,  1150,  1189,  1070,  1277,
    1240,  1284,  1242,  1096,  1113,  1145,  1063,  1190,  1280,  1081,
    1115,  1123,  1090,  1275,  1088,  1089,  1164,  1152,  1086,  1087,
    1119,  1066,  1030,  1033,  1034,  1035,  1036,  1037,  1038,  1039,
    1040,  1041,  1042,  1043,  1044,  1045,  1046,     0,  2005,  2480,
       0,  3107,  2094,     0,  2993,  2060,  2050,     0,     0,     0,
       0,   592,   588,   591,   590,   589,   594,   732,   605,   601,
     603,   604,   606,   602,   607,   733,   595,  2691,   608,   609,
     584,   597,   598,   599,   593,   596,   587,   586,  2061,     0,
    2084,     0,  2370,  2725,  2726,  2727,     0,     0,  2140,  1377,
       0,  2152,     0,  2166,  2371,     0,     0,     0,     0,     0,
    2207,  3048,     0,     0,  2211,  2210,  2202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2188,  2189,  2845,  2516,
       0,  2261,  3087,  3087,  2585,  2586,  2756,     0,     0,     0,
    2285,  2279,  2967,  2280,     0,     0,  2480,     0,  1375,     0,
    2968,  2831,     0,  2285,  2376,  2375,  2094,  2946,  2427,  2383,
       0,  2429,  2434,     0,   563,   511,   801,     0,     0,   935,
    3014,   614,     0,   663,     0,     0,     0,   787,   682,  3078,
    3078,  3078,  3078,  3078,   683,  3103,   684,   685,   686,   688,
     689,   690,   691,   693,   692,   695,   728,   726,   727,   729,
     730,   694,   700,   696,  3074,   731,   755,   697,   673,   698,
     699,     0,  2957,  3081,   711,   712,   710,   783,   714,   715,
     713,  3009,   671,   573,  3009,   637,   639,   640,   641,   643,
     642,   656,   644,   645,   678,   687,   646,   647,   648,   649,
     650,   651,   652,   653,   654,   655,     0,     0,  2957,     0,
    2976,     0,     0,  3014,  3014,     0,     0,     0,     0,     0,
    3009,   504,  2951,   505,     0,     0,   506,   451,   452,   259,
    3040,  3024,  3069,  3099,  3126,  3127,   358,     0,  3024,  3009,
    2969,  3024,   360,     0,  3107,   341,   258,   340,  3009,  3009,
     261,   262,   267,   272,   269,   327,   270,   273,     0,   274,
       0,   264,   357,   265,   266,   271,   268,   263,   275,   276,
     277,   278,   279,   280,     0,  2963,  3014,  2634,     0,     0,
    3147,  3148,  3050,  2614,     0,     0,     0,     0,     0,   432,
     405,     0,   199,     0,  3009,  3009,   117,  1591,  1342,  1339,
    1345,     0,  1342,  1357,  1358,  1329,  2446,  2447,  2451,  2452,
    1452,  2448,  1547,  2443,  1377,  1510,  3045,     0,     0,  2761,
    1498,  2719,  2720,     0,     0,     0,     0,  1514,  1550,  1537,
    3009,  2532,  3102,  2532,  2949,     0,  2993,  3009,     0,     0,
       0,     0,  1473,  1459,  1461,  2440,  1470,  3025,  1464,  1465,
    1466,  1504,  2959,  1468,  2696,  2668,  2695,  2850,     0,  2811,
       0,  2811,  2815,     0,  2790,  2821,     0,  2811,  2811,  2811,
       0,  2792,  2850,     0,  2811,     0,  1377,  1377,  1562,  2486,
    2483,  2746,  2747,  2480,     0,  2811,  2811,     0,  2839,  1576,
    1575,     0,  1572,  1584,  1582,  2528,  1607,  1608,  1604,  1606,
    1659,     0,  1656,  1655,  1664,     0,  1672,  2099,     0,  1377,
    1377,  1679,  2517,  2523,  2520,     0,  1769,  1745,  1380,  1731,
    1732,  1729,  1728,  1730,  1727,  1721,  1723,  1726,     0,  1800,
    1801,     0,  1299,  1301,  1804,  1805,     0,     0,     0,  2532,
    2532,     0,  1719,  1739,  1770,  3107,  3107,     0,  1826,     0,
    1840,  1838,  1610,  1839,  1869,  1866,  1868,  1867,  1860,  1863,
    1870,  1377,     0,  2546,  2545,  2575,  1894,  2624,     0,  1377,
    1908,  1899,  1902,     0,     0,  1929,     0,  1293,  1298,  1297,
    1296,     0,     0,  1962,  1964,     0,  1957,  1971,  1958,  1959,
    1950,  1953,  1971,     0,  2703,  2534,  1993,  2225,  2216,     0,
     773,   774,  3024,  2998,  1029,  1289,  1288,  1028,  2006,  2009,
       0,     0,     0,   585,     0,  2049,  1377,     0,  2067,  2063,
    2068,  2064,  2069,     0,  2059,   600,  2066,  2086,  2117,  2085,
    1377,  1377,  2134,  2505,     0,  2516,  2141,     0,  2154,  2539,
       0,  2149,  2155,  2171,  2170,  2169,  2168,  2167,  2187,  2212,
    2722,  2213,  2721,  2723,  2724,     0,  2199,     0,  2204,  2191,
    2192,  2193,  2197,  2194,  2198,  2195,  2196,  2190,  2846,  2249,
       0,  2246,  2247,  2241,     0,  2234,  3144,  3143,     0,  3088,
    2265,  2265,  2583,  2757,     0,  2489,     0,     0,  2850,  2850,
    2291,     0,     0,  1376,     0,  2832,  2314,  2315,     0,  2318,
    2321,  2323,  2319,  2140,  2947,     0,  2534,     0,  2436,     0,
     510,   564,   804,     0,     0,   435,     0,  3009,   664,   611,
     796,   797,  3079,   725,   724,   717,   716,   723,   722,   721,
     720,   719,   718,  3104,     0,     0,  3075,   781,   759,     0,
     751,   675,   672,   657,  2958,     0,  3082,   784,   785,   782,
       0,   638,   660,   798,  2967,   665,  2862,  2862,     0,   615,
       0,   582,   473,   501,  3139,  3140,  2643,   482,  2641,  3131,
    3130,   475,  2645,  2644,  3034,  2971,  2993,     0,  3009,   479,
     478,  3009,   507,  3009,  3009,  3024,   308,   361,  3009,  3069,
    3009,  3009,  3009,  3009,   380,  2954,   381,     0,     0,     0,
    3009,  3040,   328,  2964,     0,     0,   415,   416,     0,   419,
     421,   424,   425,   428,   433,   430,   201,   202,  2755,  2752,
    2752,   118,  1340,  3009,     0,  1354,  1350,  1343,  1344,  1359,
    2441,  2449,  1377,  1548,  1549,  2733,  2442,  2444,  2450,  1508,
    1509,  1542,  1540,  1517,  1541,     0,  1544,     0,  1543,  1545,
       0,     0,  1484,  1483,     0,  1487,  1486,  1471,  3009,  1454,
    1499,  1501,  2480,  2827,  2796,  2829,  2797,  2791,  2825,  2793,
    2794,  2795,  2823,  2864,  2818,  2819,  2789,  2653,  2488,  2485,
    2481,  2487,  2482,  2484,  2745,  1563,  2812,     0,  2787,  2788,
    2841,  2706,  2707,  1573,  1577,  1589,     0,  2853,     0,  2522,
    2525,  2518,  2524,  2519,  2521,  1689,  1760,  3011,  3011,  3011,
    3011,     0,  1744,  1746,  1747,     0,  1819,  1817,  1300,  1302,
    3048,  1818,  1821,  1820,  1815,  1788,  1785,  3021,     0,  2952,
    1784,  1787,  1778,  1756,  1774,  1780,  1781,  1791,  1782,  1776,
    1795,  1796,     0,  1763,  2480,  2606,  2480,  2606,  1616,     0,
    2539,  1865,  1857,  1858,  1856,  1862,  1896,  1901,  1906,  1915,
    1918,  1919,  2981,  3096,  1911,  3099,  1916,  1971,  2701,  2702,
    1971,     0,  3005,  3005,  1956,  1972,  1973,  1954,  1960,  1955,
    2993,  1980,  2399,     0,  2226,   328,  2220,     0,  2999,  2223,
    2480,  3059,  3059,     0,  2025,  2026,  2529,  2054,  2056,  2057,
    2053,     0,     0,  3050,     0,  2105,  2087,  2100,  2093,  2089,
    2102,     0,  1377,  1377,  2114,  2123,  2120,  2504,  2507,  2498,
    2506,  2499,  2139,  2142,     0,  1377,  1377,  2156,  3026,  2163,
    3048,  3048,  2203,  2248,  2238,  2242,  2243,  2244,  2245,  2236,
    2263,  2266,  2264,  2758,  1377,  1377,  2275,  2495,  2492,  3009,
    2283,  2282,  2284,  2480,  2864,  2480,  1371,  2306,  2698,  2831,
    2317,  2993,  2534,  2993,  2489,  2377,  2374,  2373,  3028,  2384,
    2435,  3107,     0,  2433,     0,   512,   564,   802,   564,   807,
       0,   632,   634,   633,   627,   631,   629,   630,   626,   628,
     625,   793,   788,   790,     0,     0,   610,   786,  1015,  1011,
    1012,  1005,  1009,  1017,  1003,   734,  1010,  1002,   741,  1008,
     705,  1004,  1006,  1007,  1016,   702,   704,  1013,   706,  1014,
     701,   709,   708,  2993,   753,  3097,   756,  3097,     0,     0,
     658,  2735,   681,   680,   679,     0,   659,     0,     0,  2969,
     743,   744,   619,   618,     0,   463,     0,   500,  2642,  3035,
     484,     0,   466,  3083,   493,   495,   499,   498,   494,   496,
     492,   497,     0,     0,     0,     0,  3009,   311,   310,   286,
     309,     0,   360,   356,     0,   363,     0,     0,  2955,  2956,
     379,   382,  2971,     0,     0,  3009,     0,  2989,   359,   386,
       0,   417,   426,     0,   427,     0,   119,   120,     0,  3009,
    1349,  1355,     0,     0,  1330,  2445,  1530,  3132,  3133,  2533,
    1546,  1535,  1482,     0,  1500,  1564,  3001,  2866,  2813,  1609,
    1661,  2098,  2097,  3107,     0,     0,     0,     0,  1753,  1748,
    2984,  3023,  3022,     0,  1777,  3011,  1775,  1790,  1789,  1792,
       0,     0,  1783,  1828,     0,  1827,     0,  1611,  1612,  1345,
       0,  1864,  1871,  1377,  1920,  2982,     0,     0,  1952,  1963,
    1971,  3006,     0,     0,  1974,  1975,     0,  2399,  3048,  1983,
    1994,     0,     0,  2229,  2219,  3000,  2010,  3060,   383,   384,
     385,     0,  2046,  3111,  2044,  2045,  2043,  3110,  2017,  2027,
    2028,  2030,     0,     0,  2055,  2051,  2070,  2072,     0,  2090,
    3009,  2516,  2088,  2101,     0,     0,     0,  2104,  2125,  2122,
    2118,  2124,  2119,  2121,  2143,  2150,  2157,  3027,  2172,     0,
       0,  2497,  2494,  2490,  2496,  2491,  2493,     0,  2293,  2866,
    2292,  2331,  1370,     0,  2316,     0,  2320,     0,  2312,  1377,
    1377,  2368,  2379,  2513,  2510,  2378,  3029,  3030,  2372,  2387,
       0,     0,   514,   513,   805,   809,   936,     0,   794,   791,
     622,  3048,   625,   617,   620,   623,   612,   735,   736,   740,
     739,   738,   737,   703,   742,   707,     0,     0,   751,  3098,
       0,   752,   757,  3009,   677,   676,   661,   799,     0,   667,
     670,   669,   666,  2863,   474,   465,   464,   462,   502,   483,
    2971,   471,   480,   477,   481,   476,   316,   317,   315,   314,
     389,     0,   300,   301,   302,   296,   297,   291,   303,   304,
     292,     0,   305,   306,   295,   293,   294,   299,   298,     0,
     285,   289,   290,   287,   390,   362,     0,   370,   378,   391,
     392,  2636,     0,  3009,   329,     0,     0,     0,     0,   429,
     203,     0,     0,  1346,  1347,  1351,     0,  1352,  1360,  1362,
    1502,  3002,     0,  3001,  2480,  1620,  1761,  1752,  1751,  1749,
    1750,  1798,     0,  3011,  1793,  1794,  2480,  2480,  1613,  1614,
       0,  1618,  1617,  1619,  1900,     0,  1930,  1970,  1977,  1976,
    2535,  1983,     0,     0,  2471,  3009,  2227,     0,     0,  2217,
    2221,  2041,  3061,  2038,  2040,  2039,  2032,  2037,  2029,     0,
    2035,  2033,  2034,  2031,     0,     0,  2092,     0,  2083,  2108,
    2505,  2502,  2107,  2091,  2103,  2200,  2201,  2286,  2480,  2339,
    1372,  2322,  2324,  2512,  2515,  2508,  2514,  2509,  2511,  2395,
    2388,  2389,     0,     0,  2437,  2438,  3009,   516,   808,   938,
     792,     0,   789,     0,     0,   624,   760,   754,     0,   761,
    3050,  3050,   763,     0,   668,     0,     0,   485,   486,   487,
     488,     0,   467,  2992,   473,     0,   370,     0,  2987,  3149,
    3150,   282,   281,     0,   367,   366,   365,   368,   364,  3009,
     372,   319,   374,  2637,   338,   347,   354,   347,   343,     0,
    3009,  3009,   330,     0,   387,  3009,  3009,  1348,  1341,     0,
    1362,  1380,     0,     0,  1565,  1629,  3007,  1797,     0,  1830,
    1829,  1615,  2661,  2660,  2734,  1921,  1981,  2400,  2401,  3009,
    1984,  1985,  1987,  1377,  1377,  1992,  2477,  2474,     0,  2230,
    3009,  3062,  2036,  2042,  2692,     0,  2073,  2685,  2684,  2686,
       0,  2106,  2500,  2501,  2503,  2294,  2960,  2365,  2364,  2340,
    2332,  2333,  2948,  2334,  2335,  2336,  2337,  2360,     0,     0,
       0,  3009,  2399,  2390,  2394,     0,  2393,  2391,  2439,     0,
    2989,     0,   810,     0,   942,   937,   939,     0,     0,  3009,
     621,   762,   763,     0,     0,  2967,   748,   768,   769,   770,
    3024,   767,   674,   491,   490,  2959,  2971,   472,  2833,   284,
     307,   283,   373,   321,  2833,   320,   371,     0,  3036,   345,
     350,     0,   346,     0,   344,   336,     0,     0,   331,   388,
    2752,  2752,     0,  1380,     0,  2867,  1377,  1377,  1377,  1588,
    1636,  1632,  3048,  3008,  1623,  1628,  1627,  1622,     0,  1779,
    2471,  2402,     0,  1986,  2476,  2479,  2472,  2478,  2473,  2475,
    2228,     0,  2687,  2688,  2689,  2071,     0,  3085,  2361,  2362,
       0,  3050,     0,  2404,  2392,  2430,   515,   517,  3005,   811,
       0,   943,     0,   940,  3106,     0,   750,   763,   758,  2752,
     764,   771,  3009,     0,     0,   469,   319,     0,  3009,   369,
     376,   377,   375,  3037,     0,   353,   355,   332,   333,   121,
     122,  3009,     0,  2865,  1634,  1638,  1635,  1630,  1637,  1631,
    1633,     0,  1621,  1982,  2403,  2231,     0,  3086,     0,     0,
    2363,  2358,  2357,  2356,     0,  2397,  3048,  2414,  2462,   538,
       0,     0,   948,   949,     0,   941,   795,   749,   777,   778,
     780,  2752,   766,   489,  3050,   468,   323,  2835,     0,     0,
       0,     0,     0,     0,     0,  1624,  2359,  3125,  3124,  3063,
    2615,     0,  2352,  2346,  2347,  2349,  3009,  2396,     0,     0,
    2385,  1377,  1377,  2431,  2468,  2465,  3009,     0,     0,     0,
       0,   519,   539,   540,   521,   549,     0,  3009,  3080,     0,
     946,  1000,   779,   772,  2638,     0,     0,   318,  2834,   322,
       0,  3134,  3135,   351,  3009,  3009,  1353,  1361,  3064,  3050,
    2616,  2355,  2350,  2353,     0,  2348,     0,  2405,  2406,  3009,
       0,     0,  2415,  2416,  2418,  2462,  2467,  2470,  2463,  2469,
    2464,  2466,  3009,     0,     0,  3009,  3009,  3009,  3009,   541,
       0,  3039,     0,  3090,     0,   518,   522,   524,   523,     0,
       0,     0,     0,     0,     0,     0,   520,   550,   552,   551,
       0,     0,   815,  3014,  3014,  3031,   848,   814,   818,   819,
       0,     0,     0,   972,  3009,   960,   961,   962,   953,  3103,
     954,  3044,  3044,  3009,  3011,  2983,  3009,     0,   977,   970,
     957,   971,  3044,  3011,   958,     0,     0,   969,   979,   976,
     974,  3011,   959,   973,     0,   980,   968,     0,   995,   989,
     993,   992,   990,   994,   950,   996,   991,   975,   963,     0,
    3044,  1001,  1019,  1018,  1022,  2639,   470,     0,   351,   348,
     352,     0,     0,     0,  2354,  2351,  2398,  2407,     0,  2411,
    2413,  2412,  2409,  2409,  2423,  2419,  2784,  2785,  2782,  2783,
    2420,  2424,  2417,  2386,     0,     0,   547,     0,     0,     0,
       0,  3009,  3009,  3009,  3009,  3009,   525,     0,  3009,  3009,
    3009,  3009,  3009,  3009,  3009,  3009,  3009,  3009,  3009,   553,
       0,  3009,  3165,  3166,  3014,  3014,     0,   812,   816,  3009,
     824,   820,   822,   823,   825,   827,     0,   951,   952,   985,
    3009,   983,  3009,     0,     0,   955,   956,     0,   998,   981,
       0,  3097,  3009,     0,   999,   997,  1325,   984,  2845,     0,
     326,   210,   211,   325,   349,   334,   335,  2345,  2342,  2344,
    2343,  2338,  2341,  2408,  2422,  2410,  2421,     0,   542,  3097,
     546,   544,   548,   543,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3032,  3033,  2763,   835,   830,  3028,   834,
    2762,   833,     0,   849,     0,   821,   826,   988,  1321,  1317,
     986,   966,   967,   987,   982,  1314,  1324,     0,   965,   964,
    1024,  1023,   324,  2425,   775,   534,   530,   531,   535,   533,
       0,   536,   526,   532,   527,   528,   529,   558,   554,   555,
     559,   557,     0,   556,   828,  3029,  3030,   829,   832,     0,
       0,   850,   579,   817,  1309,  1306,  1310,  1307,  1322,  1305,
    1323,  1308,     0,  1318,  1319,     0,  1315,  1313,  1311,  1312,
     978,   545,   776,     0,     0,     0,  3009,  3009,     0,  3009,
     836,   837,   838,   839,   840,   841,   831,     0,   852,   853,
    1320,  1316,     0,   560,  3152,  3151,  3009,     0,     0,  3154,
       0,  3009,  3009,     0,  3080,     0,     0,   847,   843,  3153,
       0,     0,   842,   907,  3113,  3112,  3003,  3044,  2950,  3009,
       0,   906,  3009,  3048,   851,  3009,     0,   858,   859,   860,
     869,   861,   863,   866,   854,   855,   856,   865,   867,     0,
     870,   857,   917,   862,     0,   864,   868,  3116,  3117,  3044,
       0,   844,   846,   845,  3004,   934,  3047,  3046,  3014,   916,
       0,   751,     0,     0,     0,     0,  3042,  3042,     0,     0,
     919,   914,   917,     0,  1304,   921,   929,   930,     0,   932,
     923,     0,   915,   894,   892,   893,   888,   891,     0,   889,
    3097,  2850,   896,  2672,  3156,     0,     0,  3158,  3160,     0,
    3164,  3162,   871,   876,  3052,  3052,   873,   877,   872,   878,
       0,  3043,   908,   908,  3042,  3042,   901,   918,   920,   931,
     928,   927,   925,   926,  3014,   924,     0,   890,   757,   933,
    3050,     0,   895,  2673,  3155,  3159,  3157,  3163,  3161,  3054,
    3053,   879,   884,     0,   912,   910,   902,   908,   911,   904,
       0,     0,   922,   537,   746,     0,   898,   882,   874,   882,
     887,   882,   875,   882,     0,   909,   903,   905,     0,   745,
     900,   897,   899,     0,   881,   880,   886,   885,   913,   747,
     883
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  3183, -3857, -3857,
   -3857, -3857, -3857, -3857,  3150, -3857, -3857, -3857,  2295, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  3154,
    3087,  1380, -3857, -3857, -3857,  2674, -3857,  2982, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  3121, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  2935,  1125, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  3010, -3857, -3857, -3857, -3857,  2930, -3857, -3857, -3857,
   -3857,  3120, -3857, -3857, -3857, -3857,  2915, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2461, -3857,  2086,
   -3857, -3857, -1631, -3857, -3857, -3857, -3857, -3857,  3011, -3857,
   -3857, -3857, -3857,  3017, -3857, -3857,  2744, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  -600, -3857, -3857, -3857, -3857,  1207, -3857, -3857, -3857,
   -2259, -3857, -3857, -3857, -3857, -3857,  -397,  -835, -3534, -3857,
   -3857,   415, -3857, -3857, -3857, -3857, -3857,  -371, -3857, -3857,
   -3857,  -511, -3857, -3857, -3857, -3857,   411, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  2770, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,   400, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  -364, -3857, -3857,
   -3857,    49, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857,  -742, -3857, -3857,
   -3857,  -676, -3857, -3857,  -749, -3857, -3857, -3857, -1568, -3857,
   -3857,  2524, -3857, -3321, -3857, -3450,  -705, -3857,  -967,  1106,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3177, -3857,
   -3857, -3857, -3857, -1891, -3857, -3857,   939, -3857, -3857, -3857,
   -3857, -3857,  1607, -3857, -3857, -3857, -3857, -2604, -3857, -3857,
   -3857, -2509,   478, -1267, -3857, -3857, -2500, -3857, -3857, -3857,
   -3289, -3857, -3857, -1181, -3857, -3857, -3301, -3857,  -563,  -470,
   -3857,  1235, -3857, -3454, -3857,  -616, -2495, -3857, -3857, -2462,
   -3857, -1621, -3857,   474, -2688, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  -867, -2327, -3857, -3857,  -993, -1933, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -2124, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -2341, -3857, -3857, -3857, -3857, -1115,
   -3857, -3857, -3857, -3857, -3857, -3857, -1119, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  -447, -3857, -3857, -3857, -3857,  -888,
   -3857,  -602, -3857,  2600, -3857, -3857, -1487, -3857,  -683, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  1785,  2289, -1030,  -745,  -744, -3857, -2187,
   -3857,  -943, -3857, -3857, -3857, -3857,  -748, -3857,  -775, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1568,  -168, -3857,     8,   434, -3857, -3857, -3857, -3857,
   -3857, -3085, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -1114,
   -3857, -3857,  -135, -3857,  3046, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  2373, -1574, -3857,  2124, -3857,  2125, -3857,
     407, -3857,  -738, -3857, -3857, -1036, -3857, -3857,   414,  2118,
   -1158,  1545, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1446,   782, -3857, -3857, -3857,  2445, -3857, -3857, -3857,
   -3857, -3857, -1230, -3857, -3857,   810, -3857, -3857, -3857, -3857,
      55, -3857, -3857,    28, -3857, -3857,  -999, -3857, -3857, -3857,
    -465, -3857,  -463, -3857, -3857, -3857, -3857,  2444, -3857, -3857,
   -3857, -3857,  2072, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,  2655, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857,  2399, -3857, -3857,  2045, -3857, -3857,  1417,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1392, -3857,
   -3857, -3857, -3857,   375, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  2395,   775,  2647, -2349, -2583, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -1795, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  2023, -3857, -3857,  2019, -3857, -3857,
   -3857, -3857,   734,   346, -3857, -3857, -3857, -3857, -3857,  2381,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1351,
   -3857, -3857, -3857, -3857, -3857, -3857,   342, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,   339,  2003, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  1831, -3857, -3857,   716, -3857,  1322, -3857, -3857, -2355,
     332,   337, -3857, -3857, -3857, -3857, -3857,  -176, -3857,  -313,
    1840, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  2359, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
      30, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -1798,
    1208, -3857, -3857, -3857,   319, -3857, -3857, -3857, -3857, -3857,
   -3857,  -346, -3857, -3857, -3857,  1174, -3857, -3857, -3857, -1347,
     699, -3857, -3857,   321, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,   313, -3857,   315, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,   628,
   -1369, -3857, -3857, -3857, -3857, -3857, -3857,  1788,   693, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  -155, -3857, -3857, -3857, -3857,  1151, -3857, -3857, -3857,
    2339, -3857,  2342, -3857, -3857, -3857, -3857,  2676, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857,  3002,  2998, -3857, -3857, -3857,
     662, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,  1765,
   -3857, -3857,  1144, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,   297, -3857,  1145, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -3857,  -514, -3857, -3857, -3857, -3857, -3857,  -302, -3857, -3857,
   -3857, -3857,   864,  1203,  1219, -3857, -3857, -3857, -3857, -3857,
   -3857, -3857, -3857, -3857,  -171, -3857, -3857, -3857, -2986, -3857,
    -256, -3857, -3857,  -555,  -680, -3545, -3857, -3857,  -557, -3857,
   -3857,  1770, -3857, -3857, -3857, -3857, -3857, -3857, -3857, -3857,
   -1588, -3857,   964, -3857, -3857,   970, -3857,  1160, -3857,  2134,
   -3857,  2142,  -553, -3857,  -494, -3857,  -491,  -356, -3857,  -242,
   -3857,  -240, -1783, -3857,   917, -3857,   919,   335, -3857,   353,
   -3857,   358, -3857, -3857, -3857, -2518,  -116, -2086, -3857, -3857,
      72, -3857,    66, -2117,   349, -3857,   892, -3857,   904,  2585,
   -1431,  2757,  -501, -2408, -2116,  -625, -1838, -3857, -3857,  2137,
   -3857,  2143,  1502, -1930,   752,   755,   757,   758,  1112,   399,
    -509,  1116,  1119, -3857,  1427,   167, -1129,  -601,  -660,  2746,
    2440, -1070, -3857,  -236,  1218,  -695, -3857,  -976, -3857,  1483,
   -3857,  -564, -3857,  2233,   289,  -125, -3857, -3857, -1069, -3857,
     669, -2684,   -44,  3253,  -568,  -595, -3857,  -566,  2285, -3857,
     -42,    64, -3857, -1102, -2200, -3857,  -110, -3857, -3857, -3857,
    1267,  -962, -3857,  1453,   470, -2657,   748,  -638,  2240, -3857,
   -2318, -2362, -2690,  -441,  -550,  -664,  -743,  -598, -3857, -2384,
   -3857,  -476,  2196,  -711, -3857, -3857, -3857, -2296,   -97, -1929,
   -3857,  1056,  -764,  -821,  -151,  2951, -3857, -2233,  2716,  -259,
    3721,  -505,  -694,  -587, -3857, -3857, -3857,  -232,  2658, -3857,
   -3857, -3857, -3857,  1183, -3857, -3857,  1836, -3857,  -257, -3857,
   -3857, -3857, -3857,  1268, -3857, -2432, -3857,   956,   701,   409,
     135, -3857, -3857, -3857, -3857,  -191,  -826,   544, -3857,  1166,
   -2175, -3857, -3857, -3857, -1572, -2201, -2693, -1355, -1200, -3857,
   -3857, -3857, -3857, -3857,  -100,  -177, -3857, -2039,   906, -3857,
      13, -3857, -2821, -3857,   -35, -1848, -2194, -3857, -3857, -2254,
   -3857,  -699, -3857, -3857, -3857,  2715, -1561, -2409, -1694,  -847,
    -763,  -656,  -902,  3214,   493, -3857, -3857,  2974, -3857,  -812,
   -3857, -3857, -3857,   205, -3857,   336, -3857,  1295, -3486, -3857,
   -3857, -3857, -3078,  -591,  1603, -3857, -3857,   -65, -3857, -3857,
   -1167, -3857,  2345, -3857, -3857, -3857,  -651, -3857,  -687,  -416,
   -3857,  1868,  1109, -3857, -3857,   314, -3857, -3856,  -846, -3857,
   -3857, -3857, -3857, -3857, -3857
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     4,     5,     6,    11,    12,     7,     8,
      13,    14,    47,    48,    49,   111,    51,   113,    19,    40,
     123,    15,    16,    17,    24,    32,   221,    25,    31,   109,
     163,   159,   299,   533,   534,   535,   218,   219,    20,    37,
      38,   118,    55,   121,   228,   169,   540,    29,    30,    42,
      43,    82,    83,    84,    85,   196,   280,   505,    86,   193,
     265,   266,   267,   268,   269,   495,  1148,  1700,   270,   271,
    1144,   272,    87,   194,   277,   278,   279,   500,    88,    89,
      90,    91,    92,   151,   210,   525,   211,   212,    93,   180,
     246,   466,   467,   247,   248,  1126,  1134,  1127,  1128,  1129,
    2411,  2836,  1130,  4153,    94,   157,    95,   202,   203,   204,
     519,    96,   198,   199,    97,   477,   478,   182,   754,    98,
      99,   481,   100,   101,   102,   103,   104,   105,   106,   150,
      63,    64,   129,   179,   243,  1090,  1668,  1669,  2370,  2371,
    3449,  3450,  3451,  3452,  3453,  3189,  3190,  1109,  2372,  3429,
    2373,  3734,  3735,  3818,  3927,  2374,  2375,  3207,  3464,  2376,
    1137,  2377,  2378,  2379,  2380,  3618,  3739,  4059,  3740,  3742,
    2381,  2382,  2383,  2384,  3456,  3608,  2385,  3611,  3612,  3736,
    3737,  3820,  2386,  2387,  2815,  2388,  3014,  2389,  3209,  2390,
    2391,  2392,  2393,   244,   245,   458,   459,   460,   461,   746,
     462,   463,   464,   739,  2831,  2832,  3214,   465,   741,  1687,
      58,   237,    59,    60,   125,   176,   238,   239,   724,   240,
    1089,  1655,  1656,  3417,  1657,  3875,  3594,  3165,  1658,  1659,
    2801,  3423,  1660,  1661,  3419,  3587,  3588,  3589,  3590,  1662,
    3180,  3181,  1663,  3167,  1664,  1665,  2345,   712,  2245,  2730,
    3095,  3096,  3567,  3700,  3797,  3975,  3976,  3977,  3978,  3911,
    3912,  3913,  3986,  3987,  3988,  3989,   444,  1632,   445,   446,
     716,   717,  1642,   718,  1085,  1086,   200,  2328,  3110,  2160,
    2161,  2162,  2163,  2164,   719,  3116,   720,  1637,   721,  1638,
    2779,  3383,  3384,  3111,  2303,  2304,  2305,  2306,  2307,  2308,
    3156,  2252,  2309,  2310,  3158,  3412,  2311,  2312,  2762,  3148,
    3405,  2313,  2314,  2315,  3393,  3395,  2316,  4330,  4469,  2317,
    3147,  3398,  2759,  3582,  3144,  3712,  3716,  3813,  3717,  3718,
    3719,  3720,  4271,  3721,  3868,  3869,  2318,  2319,  2769,  2320,
    2321,  2322,  3378,  3112,  3113,  3572,  2323,  2324,  2325,  1077,
    2731,  1636,  3098,  2249,  3375,  3568,  3702,  3861,  3917,  3997,
    3998,  4121,  4122,  4123,  4124,  3999,  4196,  4197,  4198,  4244,
    4280,  4281,  4282,  4283,  4284,  4285,  4117,  4203,  4289,  4304,
    4334,  4335,  4402,  4458,  4474,  4462,  4336,  4386,  4387,  4337,
    4432,  4471,  4338,  4339,  4446,  4447,  4340,  4341,  4342,  4371,
    4372,  4343,  4344,  4424,  4425,  4375,  4376,  4377,  4345,  4346,
    2735,  3569,  3705,  3706,  3707,  3863,  3864,  4054,  3918,  4044,
    3920,  3142,  4051,   958,  4148,  1505,  1506,  1507,  1508,  2112,
    1466,  2113,  1467,  2114,  1468,  2115,  1469,  2116,  1470,  2117,
    1471,  2118,  1472,  2119,  2120,  1473,  2121,  1474,  2122,  1475,
    1476,  2123,  1477,  2124,  1478,  1479,  2125,  1480,  2126,  1481,
    2624,  1986,  1482,  1483,  1487,  1488,  2554,  2555,  4373,  4374,
    4259,  4260,  4261,  4214,  4268,  4269,  4131,  4265,  4129,  4262,
    4045,  4046,   172,   173,   312,  2849,  3479,   174,  1154,  1708,
    1707,  2418,  2419,  2420,  2845,  2846,  3628,  3222,  1710,  3224,
    3630,   702,  1053,  1054,  2228,  3352,  1055,  1056,  2712,  1878,
    1879,  2538,  1057,   233,   377,   378,   628,   782,  1157,  2472,
     783,   784,   785,  1171,  1772,  1773,  1162,  1163,  1164,  2879,
    2880,  1799,  2952,  1723,  1724,  1166,  1764,  2852,  2853,  4047,
    1911,  1767,  1156,   379,   629,   818,  1195,  1193,   380,   630,
     834,  1850,  2512,   381,   631,   847,   848,  1852,   382,   632,
     853,  2515,   779,  1151,  1706,   547,   548,  1854,  1855,  2518,
    2573,  2968,  3267,  3268,  3269,  3635,   655,  3767,  3759,  3839,
    3760,  3837,  3761,  1223,   383,   633,   857,   858,   384,   634,
     862,   863,  1230,   864,  1226,  2520,   385,   638,   867,  1235,
     386,   387,   639,   877,  1244,   388,   641,   882,   389,   640,
     879,  1245,  1248,   390,   642,   889,  1873,   890,   391,   643,
     901,   902,   903,   904,  1273,   905,  1275,  1912,  1888,  1889,
    1890,  2543,   906,  1258,   907,   908,   909,  1915,  1916,   910,
    2537,  2932,  2933,  2934,   911,  1277,  2565,   912,   913,  2536,
    3243,   914,  2566,   915,  1260,  1920,   959,  2953,  2954,  2955,
    2956,  2957,  3260,  2958,  2959,  2960,  2961,  1913,  1264,   392,
     644,   919,  1284,   393,   645,   394,   647,  1929,   924,  2571,
     395,   648,   927,   928,   929,  1293,  1294,  1295,  1935,  1296,
    1932,  2582,  2578,  2579,  2971,  1290,   396,   649,   938,   656,
     397,   650,   939,   398,   651,   942,   399,   652,   945,  1970,
     400,   401,   657,  1973,  1319,  1974,  2589,  2591,   402,   658,
     951,  1320,  1983,  2595,  2980,  2981,  2982,  2984,   403,   659,
     954,   404,   660,   960,   405,   661,   962,   963,  1492,  1493,
    2008,  1494,  1495,  2610,  2611,  2005,  2006,  2007,  2604,  2994,
    2995,  2996,   406,   967,  1496,  3287,  3770,  3514,  3650,  3651,
    2011,   407,   968,  1498,  3002,   408,   664,   409,   665,   975,
    1512,   410,   666,   977,   411,   667,   979,  1516,   412,   669,
     982,   983,   984,  1523,  2132,  3308,  3309,  3533,  3526,  3527,
    3310,  3311,   413,   670,   986,  2636,  2637,  3315,  3020,  1528,
    1529,  1530,  2639,  2641,  2642,  3535,   414,   671,   415,   672,
     992,  1541,   416,   673,   994,  2177,  3025,  3026,  3027,  1870,
    1871,  1872,  3322,  3029,  3321,  3538,  1543,   417,   418,   674,
     996,  1551,  3034,  3332,  3035,  3330,  3036,  1548,   419,   675,
     998,   420,   421,   676,  1001,  1555,   422,   677,  1004,  2655,
    2656,  1559,   423,   424,   679,  1008,  1565,  2180,  2661,  2662,
    1563,   425,   680,  1011,  1567,  1568,  2184,  3049,   426,   681,
    1016,   213,  1584,  1017,  1018,  2206,  2207,  1019,  1020,  1021,
    1022,  1023,  1024,  1025,  1026,   427,   682,   969,  3004,  1500,
    3294,  2015,  2618,  3293,  3519,   428,   683,  1035,  2209,  1592,
    2690,  2691,  2692,  1588,   429,   636,   637,   430,  1037,  1594,
    3060,   691,   692,   431,   697,  1042,  1043,  1044,  1604,  1605,
    2223,  3071,  2705,  1602,   432,   698,  1047,  1610,   433,   700,
     434,   701,  1049,   435,   703,  1058,   436,   704,  1061,   437,
     705,  1064,  1623,  2716,  2717,  2233,  2719,  3082,  3084,  1621,
     438,   706,  1068,  3353,  3549,  3680,  3681,  3682,  4161,  3683,
    3893,  3894,  3944,  3684,  3853,  3685,  3686,  3687,  3688,   439,
     707,  1070,  1553,  2236,  2237,  3361,  1626,   440,  1072,  1628,
    3369,  3955,  3559,  3560,  3561,  3697,  3692,  3897,  3289,  3647,
    3648,  3857,  3947,  3948,  4164,  4165,  3900,  3952,  3953,  4075,
    4080,  2239,   441,  1073,  1630,  3858,  2242,  2728,  3092,  3564,
    2430,  2856,  2431,  2432,  2850,  2433,  2434,  1267,  1883,  1268,
    1881,  1269,  3903,  3960,  3904,  3958,  3905,  3655,  3778,  3656,
    3776,  3657,  2498,  2902,  2499,  2900,  2500,  3066,  3345,  3067,
    3343,  3068,  2652,  3539,  3673,  2653,  3039,  3040,  3362,  3557,
    3363,  3555,  3364,  2531,  2532,  2923,  2533,  2921,  2534,   987,
    2135,   693,  2866,  3001,   949,   950,   931,   932,  1308,  1309,
    1940,  1310,  1960,  1961,  1962,  1963,  1964,  1965,  1597,  2217,
    1808,   836,   837,   838,   839,   819,   869,  1238,  1005,  1006,
    1009,  1675,  3850,  1676,   786,   955,  1028,  1029,  1967,  1968,
    1317,  1531,   850,   851,  1670,  2793,  3614,  3923,  1145,  2787,
    2788,  2794,   132,   205,   940,   871,  1271,   820,   821,  3641,
     822,   823,  4392,  1822,   842,  3666,  1774,  2166,  3667,  1804,
    2475,  2612,  3077,  1996,  2987,  1570,  2910,   859,  1065,  1533,
    1713,  2440,  2671,  2672,  2172,  1714,   970,  1032,  1059,  2613,
    3643,  3150,   824,   695,   884,   872,   873,  1998,   696,  1146,
    1147,  1699,  1040,  1041,  1715,   520,  2442,  4201,   479,   825,
     516,   517,  4081,   826,   827,   828,   829,  1201,  1180,  1830,
    1814,  1815,  1826,  1819,  1809,  1811,   722,  2718,  3816,  1218,
    1843,  2508,  1546,  1509,   453,  1241,  1865,   310,  3160,  3237,
    3484,   625,   626,   627,  2725,  2455,  2343,  1112,  3200,  2765,
    1167,  1168,  2824,  1262,  2421,   273,   149,   496,  2331,  1252,
    1768,  3276,  2556,  1107,  1105,   183,  3595,   988,  1990,  3009,
    3482,  4355,  3282,  3768,  1312,  2020,   288,  2025,  3253,  2468,
    3338,  3368,  4116,  3170,  3824,  3980,   166,  4412,  4130,  4358,
    1095,   742,  4441,   293,  3298,  3662,  3939,   274,  1769,  2395,
    1619,  2757,   136,  2744,  2327,   486,  3848,  2700,  3981,  1685,
    1255,  2985,  3400,  2557,  2453,  2754,  3573,  2962,  3313,  4347,
    4248,  4349,  4050,  1239,  3889,  2396,   257,  2791,  3229,  3933,
    1697,  2335,  1232,  2698,   830,  2402,  3603,  4296,  4302,  4405,
    4406,  4407,  4408,  4409,  4002
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     214,    53,   771,   249,   449,   917,  1050,  1801,  1078,  1079,
    1080,  1766,   187,  1087,   190,   999,  2251,  1031,  2021,   195,
    1527,  2640,   133,   930,   515,  1175,  2437,  1677,   140,  1679,
    1680,  2438,  1682,  1683,   137,   138,   139,   870,  1593,   232,
     188,   144,   188,   845,  2548,  2882,  1165,   188,  2854,  1690,
    2231,  1569,  1580,  1243,  2558,   941,  2736,   290,  1930,   253,
    2893,   946,  2412,   941,  2244,  1833,   971,   849,  1250,  3402,
    1189,  1091,  3093,  2783,   966,  1096,  1097,   916,  1099,  1100,
    2524,  1102,  1103,  2863,   971,   167,   941,   188,  1829,  2340,
     952,  2654,  2695,  2869,  2580,  2634,  2547,  2804,  2136,   184,
    1839,   185,  3172,  1233,  2808,   191,   192,  2812,  2813,  3579,
    1242, -1333,  1197,  1030,   130,   206,   215,  2562,  1067,  2859,
    2860,   835,   130,  4366,   220,  2861,  2862,  1291,  2864,   447,
    1214,   224,  1048, -1331,  3202,  3585,  3041,  1092,  1093,  2784,
    2785,  3210,  1098,  2447,  2568,  1101,   497,   250,  4149,  1114,
    1182,  1183,  1880,  4460,  3521,   881,  1007,  1927,  1188,  2810,
     483, -3107,   289,  3892,  4367,   283,  1969,  3916,  3694,  1694,
     502,   296,  3283,  2230,  2022,   747,  1692,  1770,  2230,   294,
    2330,  3231,  1939,  1152,   285,  1158,   301, -3107, -3107,   482,
    1556,  2462, -2730, -3050,   311,  2230,  2458,  1208,  1800,  2466,
    1221, -2731,  2825,  1802,   454,  2000,   147,  3501,  1502,   866,
    2451,   991,  1243,  2178,   225,   971,   506,  2963,  2214,  1600,
   -3107,   866,  4120,  4457,  2559,   494,  3604,   866,   487,  2798,
    2936,  2539,  2540,  2937,  3832,  4470,  1199,  1887,   956, -3107,
    2941,  4092, -3099,  2944,   845,   845,   845, -2052,  3703,   523,
     524, -2967,  4105,  3801,  1216,  3851,  4266,  2998,  3018,  1322,
    2972,  1489,  3756,  3810,    52,  2165,  3426,  1150,  1947,  1586,
    3756,   846, -3107,  3023,  1108,  1465,  3073,  3074,  2693,  2552,
    2439,  2553,   295,   849,  1738,  -813,   985, -3024,  1484,  1141,
   -3107,  2018,   507,   181,  3762,  1988,  2664,  3415,  2001,  2467,
     235,  3511,  2665,  1608,  2776,  2988,  2799,    52,  1703,  1015,
   -3107,  2894,  4157,   653,  2394,  3615, -3107,  2448,  3089,   285,
    2198,   241,  3064,  1206,  2696, -2165,  -813,  -813,  2620,   275,
    2483, -2165,  3859,  2230,  3326,   291,   758,  1272,  1115,  2199,
    1802,  1549,   866,    22,  1969,  1315,  2629,  2847,  2549, -3107,
    2666, -3107,  3823,  4439,  1612,  2938,  2496,  1315,  3517, -3050,
    1285, -1333,  4069,  3962,  3695,   260,    52, -1333,  3006, -2969,
    3256,   181,  2789,   507,  3050,  3051,  2620,  3043,   107, -2165,
    3256, -3107,  1158, -1331,  3011,  3703,   181,   161,  2129, -1331,
    3993,  3994,  3704, -3107,  3631,  2742, -3095,  2843,   865,  4060,
    1537,  3241,   965,   866,   880,  4074,   207,  3088,  2742,   726,
    4421,  3806,  4158,  2742,   866,   878, -3107,  2870,   846,  1165,
   -2771,  1866,  4301,  1003,  3379,  1165,  1573,  3044,   941,  3991,
    4159,   750,   751,  3609,    52,  1315,  3563,   995,  1859,   147,
    1002,  1524,  2137,  2710,  2000,  2347,  2234,  1036,   971,  2338,
    2992,   757,   845,  4461,  3914,  1577, -3105,  1995,   760,  4294,
     451, -1333, -3070, -2959,  1805,  2460,  3291, -2959,  1062,   866,
    2461,  2138,  3915,  4295, -3107,  3379,  4070,   774,  1236,  3306,
    1995,   498,  2226, -1331,   148,  2406,  2854,  2235,  1860,  1116,
    1013,  2993,   452,   507,  2621, -1333,  1771, -1333,  3950,  2348,
    3242,  3991,  2214,  3610,  1936,   448,  3867,  2002,  4403,  3459,
    3455,  2844,  3757,   186,  2743,  2214,  1209, -1331,   275, -1331,
    -813,  1210,  1862,  4163,  4060,  3467,   186,  2745,  4368,  3704,
    1598,  2214,  2747, -2989,   852,  1886, -2677,  2001,  3042,   108,
    3571,   874,  2621,  3480,  3046,  3753,  2214,  1803,   162,  1015,
    1695,  3186,  2023,   874,   943,  4071,  1581,  2497,  2484,  3408,
    2214,   874,   286,  3616,  3409,  1117,  2214,   972,  1118,   260,
    2790,  2214,  1550, -2969,  3518,  -813,  4440,   508,  1000, -3108,
    1000,  1119,  1010,  4160,  1033,   972,  2848,  4150,  3281,   508,
     845,   845,   845,   870,   276,   508,  1966,   845,   845,   845,
    1825,   507,  1485,  1825,    52,  2550,  1140,  2811,    23,  3065,
    1000,  1120,  2939,   845,  3605,  1825,   845,  1142, -2740,  2410,
    2003,   242,   845,   845,   845,   845,   845,  1227,  1771,   713,
    3254,  2697,  3278,  2416,   480,  3279,  1579,  1067,   654,    52,
     251,  2200,  1246,  1014,   801,  1110,   802,   468, -3107,  3024,
    2707,  3522,   845,   509,  2229,   508,   801,   845,   802,  2414,
    2619,   454,   801, -2738,   802,   509,   930,   455,  2541,   510,
    1486,   509,  3427,   480,  3356,  1818,  1818,  1818,  3620,  3410,
   -3107,   510,  1286,  3715,  1803,   870,  3906,   510,  3763,  3325,
   -3107,  1838,   292,  3301,   841,  2988,  1877,   286,  3257,  2201,
   -2993,  3502,  2019,  1015,   480,   236,  3793, -3107,  2503,   480,
     508,  2474,  1143,  2485,   740,  2777,   972,   -43, -3107,  1169,
    2905,  3326,  2895, -3107, -2677,  1989, -1333,  3592,  1536,   186,
    1863,   509,   186,  2202,  2170,  1867,   508,   261,   186,  1121,
   -2967,  3617,  -813,  4422,  2580, -2967,  2002,   510, -1331,  3174,
     852,  4267,  4251,  1971,  2496, -3109,   260,  3173,  3053,  1490,
   -2969,  2133, -2967,  3907,  3043,  1866,  3175,  3428, -3009, -3065,
    4272,   508,   874, -3107,  3523,   809,  3852,   801,  1997,   802,
    2837,   480,   508,   276,  3624,  2632,   509,   809, -2959,  2803,
   -1338, -3024,  3632,   809,   798,   799,  4202,   840,  1704,  1465,
    1231,  3758,   510,  3540,  2215,   868,  3995, -1965,  1957,  3758,
     541, -2052,   509,  1051,  3044,  3764,   944,   868,  3327,   186,
     186,  2167,  3019,  1217,  2465,   868,  2467,   511,   510,  1161,
    2973, -2973,   186,   186,  3416,  2800,  2203,   508,   801,   511,
     802,  3765,   456,   874,  2016,   511,   186,   509,   868,   801,
    2452,   802,  1887,   260,   302,   874,   508, -2969,   509,  2003,
    2592,  4093,  1122,   510,  2452,   226,  2165,  1123,  1124,  3796,
   -3009,   262,  4106,   480,   510,   457,   186,  2877,  4195,   480,
     491,  3012,   772, -1965,  4151,  2874,  3302,  1321,  2878,  2723,
    1535,  1491,  3586,   480,  3486,   841,   841,   841,  2216, -1965,
   -2967,  3723,  3724,  3256,   801,   511,   802,  1052,   809,  2544,
    1010,  3171,   480,   509,   845,  1209,   870,   227, -3009,   941,
    1210,  3606,  1538,  2407,  2408,  3507,   874,   448, -1336,   510,
    1051, -1338,   509,   874,  -288,  1689,  1869, -2959, -2959,  3749,
    3503,   261,  1673,  3755,  1674,  2204,  2128,  1678,   510,   972,
     512,  3292,  1051,  1762,   186,  2497,  1688,  1693,  3413,  1153,
     511,  3286,   512,  2024,   508,  2175,  1671,  1672,   512,   809,
     480,  1701,  1596,   263,  1696,  2542,  1681,  3860,   186, -2967,
     809,  1039,  1315,   186, -2967,  -813,   511,  3963,   503,   957,
    1599,   186,  1705,   748,   188,   188,  4423, -3107,   840,   840,
     840, -2967,  2983,  3013,   188,  3524, -2165, -2165,  1292,  1868,
     870,  3303,   845, -3095,  2502,  4369,  2398,  2399,  1237,   207,
     689,   511,  2404,  3674,  1052,  2405,   131,   513,   512,  1573,
    3258,  2004,   511,  3815,   131,   809,   868,  1125,  3794,   513,
     509,   448,  3355,   499,  3357,   513,  1052,  2413,  3696,  3996,
     186,  1532,   186,   186,  1666,  1861,   510, -1965,  3525,  4152,
     186,   972,  2441,  4216,  3833,  2658,   201,   480,  2495, -1336,
    4069,  2501,  4390,   855,  1937,   262,   490,  3607,  -813,  3244,
    3245,  3246,  3247,   512,  2915,  2492,   186,   511,  2215,   480,
    2219,  4224,  1169,  2476,  1158,  3411,  1039,  1835,  1169,  3235,
   -3107,  2215,  3627,   841,  3396,   513,   511,   868,  3304,   512,
    3982,   186,  3766,  1702,  -565,   252,  3951,  2215,  2205,   868,
     207,   186,   469,   186,   455,   514,  1716,   714,   261,   186,
    3873,  2580,  2215, -3070,  2415,  3855,  2792,   514, -3109, -2967,
     715,  1599,   480,   514,   512,  1582,  2215,  3176,  1947, -3109,
    1886,   207,  2215,  3621, -3107,   512,   480,  2215,   713, -2989,
     513,  1938,  1231,  3097, -3107,   480,   207,  3262,  1527,   186,
     491,  3032,   480, -3107,   528, -2959,  1116,   263,  3676, -2959,
   -1965,  3263, -2824,  3265,  4070,  3530,   513,  3473, -3107,  1835,
     868,   764,  1874,  1209,   181, -2826,  1583,   868,  1210,  1573,
    1300,  3387,  3157,   514,  3542,  3327,   840,  3622,  1891,  1885,
     512, -2828,   542,  2927,   511, -3132, -3107,  2188, -2830,  3982,
     852,   513,  3877,  3385,  2668,   261,  2482,  3296,  1825,   512,
     971,  4076,   513, -3133,   856,  3541,   870, -1771,  4127, -2989,
   -2822,   841,   841,   841,   186, -2677, -2817,  3908,   841,   841,
     841,  2506,  1117,   480, -2677, -2677,   780, -1965,   514, -2677,
    3205,  2650,   262,  4071,   841,  3909, -3107,   841,  1119,   855,
    2004,  1987,  1771,   841,   841,   841,   841,   841,  3030,  3422,
     488,  2764,  3910,  3259,   514, -2618,     3,   513,  2514,  4066,
    3348,  2423,  3350,  2174,   662,  2212,  1997,  -288,  3177,   456,
     543,  2758,    18,   841,   480,   186,   513, -3009,   841,   303,
     304,   305,  4428,  2588,  4038,  1211,   186,  2767,  2742,   514,
    2858,    65,  3388,  4077,  -565,  1212,    -7,   255,  2826,  2827,
     514, -2989,   457,  3178,  2829,  2830,   529,   512,  3179,  1718,
    3474, -1965,  3305,  1719,   840,   840,   840,  2841, -1303,   207,
    1265,   840,   840,   840,  3983, -1965,  2585,  3306,   207,   262,
    3745,  1832,    52,  3748,   263,  2529,  3677,   840, -2830,   653,
     840,   186,    26,  -288,  3689, -3065,   840,   840,   840,   840,
     840,  1015,  2898,  2899,  2593,   514,  1948,  1949,  2892,  -288,
     186,   489,  2140,  2596,  2772,  2773,  3270,  -765,  2688,  2928,
     207,   153,  1613,   530,   514,  4370,   840,  3492,  2689,  4039,
   -3107,   840,   885,    66,   513,  2919,  2920,   874,  4040,    65,
    1835,  1573,  2167,  4041,  2190,   306,  1121,  3389,  2675,  3678,
     886,   531,  3187,  4444, -3107,  2017,    41,  2749,  2964,  2403,
    2966,  2403,   854,  2403,  2403,  4445,  2403,  2403,  2738,  2141,
    2142,  2143,  2144,  1832,  2145, -3107,  4042,   923,  2814,  2627,
   -3107,   263,  1686,  3983,  1950,  1951,  3812,  2974,  3599,  1914,
    3086,    67,   181,   181,    68,  2977,    69,   186,  3600,  2774,
     874,  2476,  2709,  3390, -3107,  3251,  4255,  3827,  3828,   544,
     160,  3679,   256,  3575,   545,  4128,  4255,    70,   186,  2530,
   -2959,  3010,  2185,  3033,  3252,  3188,   714,   255,  1614,  3878,
   -3107,    66,   514,   207,  1835, -2989,  1644,  3653, -3038,  2755,
    4254,  3936,  3017,  2740,   663,  2673,   508,  2210,  3373,   207,
    3374,   186,   941,  1315,  2146,  2147,  3037,  3038,  2931, -3107,
    2805,   765,  2213,    27,  4038,  2397,   546,  -288,  1537,  1122,
    3814, -1771,   181,   480,  3785,  2208,  4072,   130,  2651,  2628,
    1645,   264,  3015,  -765,   759,   841,  2243,   508,  3531,    67,
    2768,    52,    68,   188,    69,  2644, -1326,  4073,   186,  3532,
    2763,   532,  3075,   887,  3470,  3901,   708,  3307,   448,  2778,
    3970,    71,  1712,  2356,   186,    70,   766, -2557,   207,  1573,
    1266, -2618,   509,  2254,  4078,    28,   933,  2326,  2329,   186,
    2332,   781,  -565,  2337,  2339,   727,  2341,   489,   510, -1771,
    1228,  2346,  3359,  2670,   186,  -565,  1646,   971,  4255,   972,
     845,   845,  -503,  2873, -2989,  2741,  3984,  1228,  4195,  4039,
    2990,   307,   308,   509,   728,  3638,  2424,  2357,  4040, -2959,
   -2959,  4394,  4299,  4041,  3973,   309,   714, -3107,  3030,   510,
     298,   729,   730,   841,  1720,   480, -3089,  1780,   840,   715,
    -288,  3985,   256, -3132,  1781,  1976,  -503,   207,  1977,  1978,
    2904,   868,  3499,   530,  1832,  3239,  4042, -3132,  1957,    71,
    3007, -3133,  2528,  2443,   654,  3270,   470,  2753,  2510,  2444,
    4327,  3634,  2445,  3494,  2446, -3133,  4395,   752,  2702,  2704,
       9,   531,    10,  3639,  3640,  2148,  2149,  2150,  2151,  2152,
    2153,  2154,  2155,  2156,  1125,  4257,  2496,   186,  3593,   114,
     186,   972,  3738,  1544,  2881,  4257,   874,   186,  3225,  4294,
     874,   861,  -503,   448,   868,  3984,  2828,  -288,  3391,  3087,
    4211, -2959,  2529,  4295,   981,   852,  3080, -2018,  3211,  4218,
      72,   480,  2806,  3973,    36,  3675,   840,  3654,   536,   537,
    3216,  3217,   471,   480,   186, -3089,   511,   731,  1832,  4079,
    3985,  2441,   186,   186,  2897,  2516, -3009,  2673,   472,  2673,
    3930,  2441,  2521,  2650,    35,  4328,  4206,  2878,  2454,  4112,
    4113,  -288,  4155,  4156,  4329,  1519,  2742,   186,  4207,  4331,
     888,  -288,   685,  1721,  1722,  4210,   709,   511,  3941,  4213,
   -1303,  1712,  4215,  1891,  3677,  1545, -1326,  1229,  2929,  2525,
     874,  -288, -1326,   208,  3971,  3902,   209,   934, -2991,  3786,
    1249,   935,  4332,  3392,  1229,  -288,  2157,  2775,  1958,    52,
    1959,    73,   207,   470,  3192,    74,  -503, -2018,    72,   480,
    3780,   532,  4256,  1647,  2551,  3008,  2930,  4257,  2843,  2626,
    1560,   936,  1589,  2561,  3942, -2018,  1536,  2526,  4206,   763,
    3870,   767,  3360,   480,   538,  1648,  2530,  3678,   507,   990,
    1997,   845,   997,   845,  2517,  2673,  2673,  2925,  1012,   512,
    3101,  3795,    44,  1825,  1975,  1520,  4383,  3043,  1976,  4384,
    -503,  1977,  1978,  3495,  3943,  4099,  2914,   845,  3328,  3329,
    4193,  4194, -3038,  1521,  3887,  2751, -1326,  2497,   743,   471,
      39,  3335,  3336,  3888,  2931,  1627,  4414,  3931,    -6,  3870,
     512,   845,   732,  3932,  4290,   472,   473,  4291,   508,    73,
    3341,  3342,  2868,   733,    45,  2426,  1524,  3044,  4413,  4429,
   -1326,  2529, -1326,  2427,  1805,  -503,  2965,    75,  2967,  2702,
     937,  2702,    -6,  4385,    -6,  1590,   513,  4415, -3089,  -503,
      52,  1591,  2844,  3845,   115,  2158,   686,   116,   117,  4245,
    4255,  4434,  1209,  4246,  3970,  2907, -2740,  1210,  1209,    50,
     868,  -503,   925,  1210,   868,  4450,  4451,    76,  2159,  1209,
    2867,  4299,  2867,   926,  1210,  1573,  1039,   513,  4435,  2918,
    1780,  4258,  4263,  1573,   509,  4309,   207,  1781, -2018,   870,
     874,   874,   874,  1315,  3045,   744,   745,  4100,  2674,    46,
     510,  -945,   852,  2679,  2680,  2681,  2682,  2683,  2684,  2685,
    2686,    54,  4436,    77,  3151,    78,   687,  4437,  2942,  2943,
     186,  4101,  4102,  4103,  2194,  4300,  2631,    52,  1841,   474,
    1538,   507,  4449,  1116,   514,  2195,  1522,  2713,  2218,  1209,
    1649,   734,    57,  3101,  1210,  1650,    79,  -945,  1209,  2426,
    2651,  4438,   972,  1210,   868,  2530,    62,  2427,  4294,  -945,
   -3089,   186,  1651,   473,  1652,    76,  4465,    61,  1257,   688,
     870,   845,  4295,  2657,   539,   514,  3972,  1617,  2867,  2867,
     735,   119,  4396,  1618, -3089, -3089, -3089,   208,   972,   874,
     209,  1573,  4397,  4398,  3973,  2760,    80,   736,    56,  1524,
    4418,  2881,  1573,  3809,  -945,  4420,   475,  3382,   120,  1117,
    2333,  3974,  1118,  1979,  1980,  2706,  2334,  4378,  2739,  3504,
     122,   689,  4391,  4393,  4382,  1119,  4134,  -945,  2706,  3102,
    2833,   124,  2835,  4388,  2403,  4140,  3931,  3250,  2504,   126,
    2782, -2775,  3932,  4143,    79, -2775,   171,  2795,  1209,  3059,
    3227, -1326,  4433,  1210,  3228,  1120,  -503,   127,   511,  1532,
       9,  -503,    10,    -6,  1981,  1982,  2478,  2673,  4399,  2480,
    4443,  2428,  2816,  2429,   181,    81,  2527,  2486,  -503,   154,
    -503,  2490,  3516,  2428,  -945,  2429,   474,  3226,  2493,  4257,
    4452,  4400,  4401,  3366,    80,  4275,   128,  3367,  3971,   134,
     188,  3432,  3433,  3434,   476,  3553,  3554,  2884,  2912,  2886,
    2842,   508,  4276,  4416,  2842,  2889,  2890,  2891,  1204,  1653,
    1207,  3063,  2896,   186,  4478,   135,  2770,  3238,   141,  2326,
     186,   142,  1209,  2908,  2909,  2400,  2401,  1210,  1209,   143,
    1997,   841,   841,  1210,   690,   145,  4277,  3339,  3340,  1807,
    1810,  1813,  3198,  3199,   868,   868,   868,  4043,   146,  2817,
    2674,  2802,  2674,   475,   186,  2797,  -945,  4114,  4115,   798,
     799,  2436,  4356,    81,   156,  1840,  4287,   158,  4132,    33,
      34,   512,   165,  1121,  2809,  1844,  1845,   509,  4132,  1654,
    1846,  1847,  1848,  2818,  2819,  4475,   168,  4476,   170,  4477,
     972,   972,  2989,   510,  4278,  3272,   972,   972,   972,   972,
    2875,  2876,  3102,   175,   972,   186,   972,   177,   972,  3435,
    3436,  2888,  3437,   178,  4307,  4308,  4279,  3318,  1820,  1821,
    4312,   189,   229,  4351,   197,  -503,  -945,  4352,  4353,  2839,
    2840,  3380, -3089,   201,   840,   840,  1979,  1980,   216,   188,
    1992,  1993,  1994,   868,  3277,   217,   737,   738,   513,   222,
     223,   476,   230,  2935,   231,   234,   874,   254,  2674,  2674,
    3570,   258,   259,   264,   874,  2865,   297,  3382, -2709, -2709,
   -2709, -2709,  2871,   298,  1279,  1280,  1281,  1282, -2708, -2708,
   -2708, -2708,  3118,   443,   508,   450,  3103,  1981,  1982,  1922,
    1923,  1924,  1925,   484,   485,  -503,  1122,  3659,   493,   494,
     501,   972,   518,   522,   972,  2912,   527,  -945,   635,   646,
     668,   972,   972,   972,   972,  2746,  2748,  2750,  2752,   131,
     874,   699,   874,   710,   711,   725,   723,  1536,  3119,   740,
     755,   756,   207,   761,   762,   768,  3636,   769,  -945,   262,
    3120,   770,   798,   799,   772,   777,   514,   778,   876,   922,
     944,   511,   953,   981, -3089,   989,   448,  1039,  1074,  1075,
     509,  1076,  1082,  1088,  1094,  1104,  1106,  1111,  1113,  3407,
    3972,  1536,  1136,  1139,  1149,  3512,   510,  4043, -3089, -3089,
   -3089,   874,  1155,   874,  1170,  3121,  1172,  1174,  3973,  3774,
    3775,  1177,   841,  1178,   841,  1179,  1131,  1181,  3438,  3439,
    1184,  3003,  1185,  1192,  1186,  3974,  1187,  1190,  3122,  1213,
    1200,   694,  1202,  1203,  1220,  1222,  1247,  1234,   841,  2673,
    1240,  1249,  3440,  1251,  1254,  1256,  1259,  1261,  1132,  1133,
    1263,  1274,  3031,  1287,  1288,  1283,  -945,  1289,  1313,  1316,
    2403,  2403,   841,  2403,  2403,  2833,  1318,  3441,  1501,  1511,
    1517,  1514,  1515,  1540,  1539,  1547,  1542,  1574,  1552,  1554,
    1564,  1557,  1558,  1566,   874,  3123,  1562,  1015,  3574,  3103,
    1578,  1125,  3442,  4357,   512,  1585,  1587,  1603,   972,  1599,
    1601,  1616,  1609,  3381,  1620,  1622,  1625,  1633,  1634,  1635,
    1639,  1640,  3834,  3835,  3836,   840,  1641,   840,  1643,   181,
    1684,  1698,  1709,  1726,  1777,  4357,  1806,  1816,  2657,  1817,
    -945,  4221,  1828,  3496,  -945,  3497,  1827,  1837,  3203,  1842,
     868,   840,  1851,  1849,   846,  1864,  1869,  1876,   868,  1266,
    1265,  3829,  3830,  4333,   511,  1919,  1921,  1933,  3104,  1966,
    3105,  1972,  1985,  1490,  2010,   840,  2012,  3124,  2014,  3106,
    3107,   513,  3114,  3108,  3109,  2131,  2127,  2134,  2139,  2168,
    3565,  2169,  2171,  2176,  2179,   480,  2197,  2186,  2187,  3443,
    2674,   188,  2189,  2222,  2224,  2225,  3149,  2230,   188,  2232,
    2238,  2240,  2989,  2246,   868,  2247,   868,  2248,  2250,  2330,
    2342,  -945,  2349,  2344,  2409,  2417,  2425,  2435,  2436,  2450,
    2454,  2456,  3444,  2457,  2459,  2463,  3445,  3446,  2464,  2469,
    4048,  2470,   841,  3182,  2467,  2471,  3183,  3126,  3184,  3185,
    2473,  2479, -2664,  3191,   972,  3194,  3195,  3196,  3197,  2403,
    2481,  2487,  2488,  3447,  2489,  3204,  2491,  3956,  3957,  3644,
    2511,  2494,  2505,  2507,  2513,   868,  2519,   868,  2522,   514,
    1532,  -945,  3924,  2523,  2535,  2567,  2569,   512,  3218,  2570,
    2581,  2572,  2583,  2590,  2594,  2601,  2602,  2623,  2673,  2630,
     985,  2645,  2659,  2669,   787,  2660,   843,  2677,  2699,   860,
    2711,  2714,  2715,  1892,  1893,  1894,  1895,   883,  3866,   918,
    1896,  2724,  2727,  3233,  1532,  2729,  2733,  2732,  3127,  2734,
    2737,   972,  2738,  1536,  4055,  1536,   961,   964,  1897,  1898,
    2753,   961,  2756,  2761,  2764,   840,  2766,   874,   993,   874,
    2781,  3104,   260,  3105,  2796,  2786,  2807,  2820,   868,  3129,
    2821,  -945,  3106,  3107,   513,  1038,  3108,  3109,  2822,  2823,
   -2752,  1771,  2872,  2887,  2497, -2739,  2529,  2496,  2916,  1060,
    2530,  1066,  1069,  2940,  1536,  2969,  2970,  1899,  2978,  2979,
    2986,  2999,  2991,   874, -2733,  3000,  3005,  3021,  3022,  2651,
    2650,  3069,  3048,  3076,  3713,  3714,  3079,  3081,  3083,   920,
    3090,  3091,  3094,  3099,  3100,  3117,  3143,  3115,  3145,  -945,
     947,  3146,  3155,  3162,  3166,  3448,  1900,  3669,  3159,  3206,
    3312,   978,   980,  3164,  3782,  3169,  3208,  3213,  3215,  3221,
    3236,  3219,  3324,  3223, -2669, -2737,  3240,  3232,  3264,  2673,
    2992,  3266,  3275,  2993,  3288,  2403,  3290,  3919,   874,  3281,
    3295,  3297,   514,  3300,  3314,  3320,  3319,  3032,  1176,  3033,
    4048,  3334,  3337,  4162,  3064,  3401,  3065,  3351,  1087,  3841,
    3371,  3376,  3394,  3377,  3397,  3399,  3799,  3404,  3403,  3406,
     147,  3468,  3477,  3414,  3478,  3481,  3483,  3505,  3386,  3493,
    3420,  3506,  3513,  3515, -3108,  3529,  3370,  1205,  1205,  1205,
    3465,  3534,  3536,  3543,  3347,  3544,  3359,  3566,  3360,  3471,
    3472,  1671,  3580,  3550,  3578,  3576,  3581,  3584,  3597,  3598,
    3372,  3131,  3623,   860,  3625,  3132,  3626,  3660,  3661,  3663,
    3430,  3691,  3469,  3670,  3709,  1901,  3454,  3475,  3698,   188,
    3708,  3457,  3458,  3701,  3711,  3725,  3733,  3752,  3784,  3461,
    1253,  3463,  2674,  3754,  3654,  3424,  3424,  3653,   188,  3790,
    2673,  3791,  3804,  3898,   188,  3803,  3676,   188,  3715,   188,
     188,  3825,  3826,  3545,  3546,  1196,  3846,   188,  1573,   188,
    3831,  3849,   188,  3862,  3874,  3757,  3856,  3847,  1536,  3865,
    3880,  1902,  3884,  3896,  3891,  1536,  3928,  3899,  3934,  3935,
    3938,   868,  3133,   868,  3902,  3854,   972,  4348,  3926,  3901,
    3937,  3965,  3966,  3895,  1943,  1944,  1945,  3967,  3968,  4064,
    3992,  3431,  4085,  1323,  4057,  4091,  4094,  4098,  4104,  4095,
    4107,  1903,  4118,  1497,  1499,  4108,  4119,   874,  4111,   874,
    3462,  2448,  3466,  4142,  4146,  4309,  1532,   868,  1532,  4354,
    4167,  4410,  3895,  1534,  3476, -2830,  4464,  4411,  4468,  4466,
    3602,  4473,  3134,  4288,    21,  4467,  4480,  3520,   112,   110,
     164,  1196,   775,   300,   152,  1573,   281,   492,   504,  1571,
     155,   526,  1135,   284,  1691,   282,  3876,  1311,  3925,  2441,
    3744,   753,  2617,  4154,  3193,  3728,  3822,  1532,  3201,   749,
    3726,  3212,  3425,  3151,  4096,  1205,  3969,  1946,  4109,  2633,
    1081,  1607,   868,  2771,  3312,  2253,  3577,  4454,  3154,  3811,
    3872,  2622,  3922,  1904,  3163,  4205,  4286,  4417,  4419,  3802,
    4220,  1513,  3921,  1510,  1624,   973,  4264,  1991,  1629,  1631,
    4135,  4136,  3137,  1000,  4139,  4147,  2422,  3500,  3220,   442,
    2403,  1711,  1276,  4063,  3230,  3537,  3234,  1765,  1717,  2509,
    2449,  2913,  1219,  2397,  3485,  3498,  3840,  3838,  2546,  1858,
     921,  1225,  1270,  1875,  3562,  2545,  3596,  2563,  3249,  1158,
    1278,  2926,   974,  1934,  1931,  3271,  2975,  1314,  2586,  3274,
    3273,   188,  1595,  1984,  2009,  3475,  2997,  2603,  3285,  1606,
    3139,  2674,  3284,  1196,   188,  3646,  3613,  3773,  2013,  3528,
    3316,  1518,  3789,  2635,  2647,  2945,  3028,  2946,  3323,  3333,
    3331,  3085,  3601,  2182,  3591,  3047,  1905,  2687,  1034,  1573,
    1575,   678,   684,  3062,   188,  1576,  1775,  1776,  3583,  2221,
   -1786,   188,  3690,  1205,  1205,  1205,  3354,  2721,  2722,  3945,
    1205,  1205,  1205,  1823,  3788,   972,  1823,  2663,  2646,  3693,
   -2959,  3771,  4067,  4166, -2959,  4082,  1205,  2857,  1823,  1205,
    2241,  2851,  4083,  1884,  1947,  1205,  1205,  1205,  1205,  1205,
    1882,  3961,  3629,  3959,  3843,  3779,  3777,  2903,  2901,  3358,
    1066,  3346,  1857,  2403,  3672,  3344,  2924,  3401,  3619,  3556,
    2175,   868,  3722,   868,  3365,  1205,  3558,  2922,  1027,  1224,
    1205,  1532,  1941,  2584,  3727,  1942,  3055,  1561,  1532,  3056,
    2587,  3057,  3058,  1071,  1853,  3418,  3168,   287,  3642,  2676,
    2605,  3280,  3078,  1752,  1856,  1753,  1754,  4138,  4065,  2838,
     773,  1138,  1917,  4223,  1191,  2255,  2694,  3819,  3161,  1834,
    3658,  2917,  2674,  3349,  3548,  1906,  1948,  1949,   188,   188,
    1907,  3787,  4359,  3255,  2780,  3562,  3633,  4252,  3730,  4247,
    3729,  1173,  4380,  4442,   521,  3299,  3731,   776,  2701,  3421,
    2560,  4249,  1725,  3844,  4058,  2336,  2834,  3460,  4404,     0,
       0,     0,     0,  3798,     0,     0,   188,     0,  1908,     0,
       0,  3699,     0,     0,     0,     0,   972,     0,     0,     0,
    1909,     0,     0,     0,     0,     0,  1536,     0,     0,     0,
    3741,  3743,  3741,     0,     0,     0,     0,  1196,     0,     0,
    4363,   852,     0,     0,  1950,  1951,  4253,     0,     0,     0,
    1926,  1928,     0,     0,  3732,     0,     0,     0,     0,  4270,
       0,     0,     0,     0,     0,  3746,  3747,     0,  3807,  3808,
    3750,  3751,     0,  1311,     0,     0,     0,     0,  3665,     0,
       0,     0,   852,  2674,     0,     0,     0,     0,     0,  1778,
    1779,  3821,  3821,  3890,  3772,     0,   188,   188,     0,     0,
       0,     0,     0,     0,     0,  3781,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,  2947,     0,     0,  1910,   188,
     188,     0,     0,     0,  4222,     0,     0,     0,     0,     0,
    3881,  3882,     0,     0,     0,  3940,  3792,   972,     0,     0,
       0,     0,     0,  3817,  1953,     0,     0,     0,     0,  3817,
       0,     0,     0,  1954,  3805,     0,     0,     0,     0,     0,
       0,     0,  1955,     0,   852,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1205,     0,     0,
    1780,     0, -1786,     0,     0,     0,     0,  1781,     0,     0,
    1782,     0,     0,     0,     0, -2959,     0,   188,     0,  2948,
       0,     0,     0,  1956,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2173,     0,
       0,     0,     0,     0,  3929,     0,     0,     0,  2174,     0,
    2181,     0,  2183,     0,  1783,     0,  1784,  1785,  4053,     0,
       0,     0,     0,     0,  4455,   845,   845,  3871,     0,     0,
       0,     0,   188,  3879,     0,     0,   972,     0,     0,     0,
       0,     0,     0,     0,     0,  1205,  3883,     0,     0,  2220,
    4056,     0,  2130,     0,     0,   845,     0,     0,     0,     0,
       0,     0,  1571,     0,     0,     0, -3048,     0,     0,     0,
       0,     0,     0,   845,     0,     0,     0,     0,   188,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1786,
       0,  1787,  4001,     0,     0,     0,     0,     0,  1788,     0,
       0,  3946, -3048,  2949, -2959, -2959,  1789,  2196,  3741,  1532,
       0,  3964,     0,     0, -3048,  4141,     0,   845,  2211,     0,
       0,     0,  4000,  4049,     0,  1892,  1893,  1894,  1895,  1606,
       0,     0,  1896,     0,     0,     0,  2227,     0,     0,  4061,
    4062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1897,  1898,     0,     0,  4068,     0,     0,     0,     0, -3048,
       0,     0,     0,     0,     0,     0,  2403,  4084,     0,     0,
    4087,  4088,  4089,  4090,  4169,     0,     0,     0,     0,     0,
       0,     0, -3048,     0,  1957,     0,     0,     0,  1958,     0,
    1959,     0,     0,     0,     0, -1786,     0,     0,     0,  1899,
       0,     0,     0,     0,     0,  4200,  1775,     0,     0,  4126,
       0,     0,     0,  1790,     0,  3118,     0,     0,  4133,     0,
       0,  4137,  1571,  4212,     0,     0,     0,     0,     0,  3152,
       0,     0,  4219,  3741,     0,     0,     0,     0,  1900, -3048,
    2950,     0,  2477,     0,     0,     0,     0,     0,     0,     0,
       0,  1823,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3119,  1791,     0,     0,     0,  1792,     0,     0,   972,
       0,     0,     0,  3120,     0,     0,   972,     0,     0,     0,
     972,     0,     0,   972,     0,  2258,  2259,  2260,  2261,  2262,
       0,  2263,  2264,     0,     0,     0,  4174,  4175,  4176,  4177,
    4178,     0,  1015,  4180,  4181,  4182,  4183,  4184,  4185,  4186,
    4187,  4188,  4189,  4190,     0,     0,  4192,     0,  3121,     0,
   -1786, -3048,     0,     0,  4204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4208,     0,  4209,  4200,     0,
       0,  3122,  2951,     0,     0,     0,     0,  4217,     0,     0,
       0,  1917,     0,  4049,     0,  2564,     0,  1901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2266,     0,
    2267,  2268,  2147,  2269,  2270,  2271,  2272,  2273,  2274,     0,
       0,     0,     0, -3048,     0,     0,  4200,  4200,     0,     0,
       0, -3048,  4200,     0,     0,  4200,     0,     0,  3123,  4200,
    4200,     0,  1196,     0,     0,   972,     0,     0,   972,  4361,
       0,     0,     0,  1902,     0,     0,     0,     0,     0,     0,
     480,     0,     0,     0,     0,     0,  2597,     0,  2598,  2599,
    2600,     0,     0,  4379,     0,     0,     0,     0,     0,     0,
    2275,     0,     0,     0,  2614,     0,     0,     0,  2615,  4389,
    2616,     0,     0,  1903,     0,     0,  2625,     0,     0,     0,
       0,     0,  4200,     0,     0,     0,  4379,  4200,     0,     0,
       0,     0, -3048,     0,     0,     0,     0,  4427,     0, -3048,
    3124,  4297,  4298,     0,  4303,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4306,     0, -3048,     0,     0,  4310,  4311,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1793,
       0,     0,     0,     0,  4360,     0,     0,  4362,     0,     0,
    4364, -3048,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3125,     0,     0,  1904,     0,     0,     0,     0,
    3126,     0,  2276,  2277,  2278,  2279,  2280,  4479,     0,  2155,
    2281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1534,     0,     0,  2643,   507,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3261,
       0,   844,     0,     0,     0,  2282,     0,     0,     0,   875,
       0,     0,  1794,     0,  1094,     0,     0,  2648,     0,     0,
       0,   875,  2649,  1795,     0,     0,     0,     0,     0,   875,
    2283,  2667,  1571,     0,  1796,     0,     0,     0,     0,     0,
       0,  3127,     0,     0,     0,     0,     0,     0,  3128,     0,
       0,     0,   875,  1524,     0,     0,     0,     0,  1905,     0,
       0,     0,     0,  1205,  1205,     0,     0,     0,     0,     0,
    2708,     0,  3129,     0,     0,     0,   841,   841,  2720,  2720,
       0,     0,     0,     0,     0, -3048,  2726,     0,     0, -3048,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3130,     0,     0,     0,     0,  1797,   841,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     789,     0,     0,     0,   841,     0,   790,   791,     0,     0,
       0,     0,  2678,     0,     0,     0,  2285,     0,  1798,     0,
       0,     0,   793,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1752, -3048,  1753,  1754,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   841,   840,
     840,     0,     0,     0,     0,     0,     0,  1906,     0,     0,
       0,     0,  1907,     0,  1198,     0,     0,     0,     0,     0,
       0,     0,   844,   844,   844,     0,     0,     0,     0,   840,
       0,  2287,  1215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3048,   840,     0,     0,
    1908,     0,  2289,     0,     0,     0,     0,     0,     0, -3048,
     875,     0,  1909,     0,  3131,     0,     0,  2574,  3132,     0,
       0,     0,     0,     0,     0,  2290,     0, -2539,     0,     0,
       0,     0, -2539, -3048,     0,     0, -2539, -2539, -2539,     0,
       0,     0,     0,     0, -2539,  2575,     0,     0,  2855,     0,
       0,   840,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1775, -3048,  1525,   794,   795,
     796,   875,     0,     0,     0,     0,     0,     0,     0,     0,
     797,     0,     0,   875,  1205,  3133,  1205,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1823,     0,     0,     0,
    1910,     0,     0,     0,     0,     0,     0,     0,   508,     0,
    1205, -3048,     0,  2911,     0,     0,     0,     0,     0, -2539,
       0,     0,     0,     0, -3048,     0,     0,     0,     0,     0,
   -3048,     0, -3048,     0,  1205,     0,     0,     0,  2294,  2295,
    2296,   860,     0,     0,  1572,  3134,     0,     0,     0,     0,
       0,     0,     0,     0,   875,     0,     0, -2539,  3135,     0,
       0,   875,     0, -2539, -2539,     0,   798,   799,   800,     0,
     844,     0,     0,     0,     0,     0,     0,     0,     0, -2539,
       0,     0,  3136,     0,  1526,     0,     0,     0,   803,   804,
     805,     0,     0,     0,  2976,     0,     0,   806,     0,     0,
     510,     0,     0,     0,     0,     0,     0,     0,  1571,     0,
       0,     0,     0,     0,     0,     0,  2614,     0,     0,     0,
       0,     0,     0,     0,     0,  3137,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3016,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2298,  2299,  2300,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3138,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     808,     0,     0,  3139,     0,     0, -2539,     0,     0,  3140,
       0,  3141,     0,     0,     0,     0,  3054,     0,     0,     0,
       0,     0,     0, -2539,  1205,     0,     0,     0,   844,   844,
     844,  3153,     0,     0,     0,   844,   844,   844,  1824,     0,
    2911,  1824,  1196,     0,  1571,  1836,     0,     0,     0,     0,
       0,   844,     0,  1824,   844,  1571,     0,     0,     0,     0,
     844,   844,   844,   844,   844, -2539, -2539, -2539,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2539,   511,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2539, -2539,
     844,     0,  3052,     0,     0,   844,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2539,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3061,  3061,     0,     0,     0,
       0,     0,  3072,     0,     0,     0,     0,  1918,     0,   810,
       0,     0,     0,     0,     0, -2539,     0,  1836,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2539, -2539, -2539, -2539, -2539,     0,     0,
       0,     0, -2539,     0, -2539,     0,  2606,     0,     0,     0,
       0, -2539,     0,     0,     0, -2539, -2539, -2539,     0,     0,
       0,   860,     0,     0, -2539,     0,  2855, -2539,     0,     0,
       0,   512,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2539,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   811,   812,     0,     0,
       0,     0, -2539,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,  1893,  1894,  1895, -3107,
       0,     0,  1896,     0,     0,     0, -2539,     0,     0,     0,
       0,     0,     0,   507,     0,     0, -2539,     0,     0,  2607,
    1897,  1898,     0,     0,     0, -2539,     0, -2539,   513,     0,
       0,     0,     0,     0, -2539,   948,     0,     0,     0,     0,
   -2539,     0,     0,     0,     0, -2539,     0,   814,     0,     0,
   -2539,     0,     0, -2539, -2539, -2539, -2539,     0,     0,     0,
       0,   789, -2539, -2065,     0,     0,     0,   790,   791,  1899,
       0,     0,     0,   815,     0, -2539,     0,     0,     0,     0,
       0,   816,     0,   793,     0,     0,     0,     0,     0,     0,
    1999,     0, -2065,     0,     0,     0,  3248,  2643,     0,     0,
       0,     0,   844,     0,     0, -2539,   817,     0,  1900,     0,
       0,   480,   186,     0,     0,   875,     0,     0,  1836,     0,
       0,     0,     0,     0,     0,     0,   514,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2539,   789,     0,
       0,     0,     0,     0,   790,   791, -2539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     793,     0,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0, -2539,     0,  3317,     0,     0,
       0, -2539, -2539,     0,     0,     0,     0,     0,     0,     0,
     844,     0,   789,     0,     0,     0,     0, -2539,   790,   791,
       0,     0,  1836,     0,     0,     0,     0,  1572,     0,     0,
       0,     0,     0,     0,   793,     0,     0,  1901, -2539,     0,
       0,     0,     0,   860,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   794,
     795,   796,     0, -2539, -2539,     0,     0,     0,     0,     0,
       0,   797,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1902,     0,     0,     0,     0,     0,   508,
       0,     0, -2539,     0, -2539,     0, -2539,     0,  2576,     0,
   -2539,     0, -2539, -2539, -2539, -2539,     0, -2539, -2539,  2577,
       0,     0,     0,     0, -2539,     0,     0,     0,     0,     0,
       0,     0,     0,  1903, -2539,     0,     0,     0,     0,  3491,
    2638, -2539,     0,     0,     0,     0,   794,   795,   796,     0,
       0,  2608,     0,     0,     0,     0,     0,     0,   797,   800,
   -2539,     0,     0,     0,     0,     0,     0,     0, -2539,     0,
       0,     0,  3510,     0,     0,   509,     0,     0,     0,   803,
     804,   805,     0, -2539, -2539, -2539,   508,     0,   806,     0,
       0,   510,     0, -2539,     0, -2539,     0,  1572,     0, -2539,
     794,   795,   796,     0,     0,     0, -2539, -2539,     0,     0,
       0,     0,   797, -2539,     0,     0,     0,     0,     0,  3487,
    3488,  3489,  3490, -2539,     0,  1904,  1824,     0,     0,     0,
       0,     0,     0,  3547,     0,     0,     0,     0,     0,     0,
       0,  3551,     0,  3552,   875,     0,   800,     0,   875,     0,
       0,     0,     0, -2539,     0,     0,     0,  3508,  3509,     0,
       0,     0,   509,     0,     0,     0,   803,   804,   805,     0,
       0,   808,     0,     0,     0,   806,     0,     0,   510,     0,
       0, -2539, -2539, -2539, -2539, -2539,     0,     0,     0,     0,
   -2539,     0, -2539,     0,     0,     0,     0,     0,     0, -2539,
     800,     0,     0, -2539, -2539, -2539,     0,     0,     0,     0,
       0,     0, -2539,     0,     0, -2539,  1063,     0,     0,     0,
     803,   804,   805,     0,     0,     0,  1918,     0,  1905,   806,
       0, -2539,     0,     0,     0,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   511,
   -2539,     0,     0,     0,     0,     0,     0,     0,   808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2539,     0,     0,     0,  3637,     0,
       0,     0,     0,     0, -2539,     0,     0,     0,     0,     0,
       0,     0,     0, -2539,     0, -2539,     0,     0,  3649,  3652,
     810,     0, -2539,     0,     0,     0,     0,     0, -2539,     0,
       0,     0,   808,     0,     0,     0,     0,     0,  1999,  1572,
    3668, -2539,     0,  3671,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1752,   511,  1753,  1754,     0,
       0,     0,     0, -2539,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1906,     0,     0,
    3710,     0,  1907,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   512, -2539,     0,     0,     0,     0,     0,     0,
    3645,     0,     0,     0,     0,     0,     0,   810,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   811,   812,     0,
    1908,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2539,     0,     0,     0,     0,     0,
       0,     0,     0,  3649,     0,     0,  3652,     0,   875,   875,
     875,   810,     0,     0,     0,     0,     0,     0,     0,   513,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   512,
       0,     0,  2609,     0,     0,     0,     0,     0,   814,     0,
    2350,     0,     0,  2351,     0,     0,     0,     0,     0,     0,
       0,  1571,     0,     0,   811,   812,     0,     0,     0,     0,
       0,  2352,     0,     0,   815,     0, -2539,  1572,     0,     0,
       0,     0,   816,     0,  2353,     0,     0,     0,     0,     0,
    1910,     0,     0,  3769,     0,     0,     0,     0,     0,     0,
       0, -2539, -2539,     0,     0,     0,     0,   817,   844,   844,
       0,     0,     0,   186,     0,     0,   513,   875,   811,   812,
       0,     0,     0,     0,     0,     0,     0,   514,     0,     0,
       0,     0,     0,     0,  3842,   814,     0,     0,     0,     0,
   -2539,     0, -2539,     0, -2539,     0,     0,     0, -2539,     0,
   -2539, -2539, -2539, -2539,     0, -2539, -2539,     0,  1571,     0,
       0,   815,     0,     0,     0,   494,     0,     0,     0,   816,
       0,     0, -2539,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   814,
       0,     0,     0,     0,   817,     0,     0,     0, -2539,     0,
     186,     0,     0,     0,     0,     0, -2539,  3885,     0,     0,
       0,     0,  3886,     0,   514,   815,     0,     0,     0,     0,
       0,     0,     0,   816,     0,     0,     0,     0,     0,     0,
       0, -2539,     0,     0,     0,     0,     0, -2539,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   817,     0,
       0, -2539,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3949,  3954,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3979,  3990,     0,     0,     0,  4052,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   948,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2539,     0,     0,     0,     0,
   -2539,     0,  1571,  3949, -2539, -2539, -2539,     0,  3954,     0,
       0,     0, -2539,     0,     0,     0,     0,     0,     0,     0,
    4086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4097,     0,     0,     0,     0,
       0,     0,  2354,  2355,     0,     0,  4110,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4125,   844,
       0,   844,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1824,     0,  2173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   875,   844,     0,     0,     0,     0,
    4144,     0,   875,  4145,     0,     0,     0, -2539,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   844,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2356,     0,     0,
       0,     0,     0,     0,     0, -2539,     0,     0,     0,     0,
    4168, -2539, -2539,  4170,  4171,  4172,  4173,     0,   875,     0,
     875,     0,     0,  4179,     0,     0,     0, -2539,     0,     0,
       0,     0,     0,     0,     0,     0,  4191,     0,     0,     0,
       0,     0,  4199,     0,     0,     0,     0,     0,  4125,  4125,
       0,  2357,     0,  1572,     0,     0,     0,     0,     0,     0,
    2855,  1572,     0,     0,     0,  1158,     0,  -342,     0,  2855,
       0,     0,     0, -3107, -3107, -3107, -3107,     0,     0,   875,
   -3107,   875,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3107, -3107,
    4225,  4226,  4227,  4228,  4229,  4230,  4231,  4232,  4233,  4234,
    4235,  4236,  4237,  4238,  4239,  4240,  4241,  4242,  4243,     0,
       0,     0,   788,     0,     0,     0,     0,   507,     0,  2358,
     860,  4125,     0,     0, -2539,     0,     0,     0,     0,     0,
       0,     0,     0,   860,     0,     0, -2959, -3107,     0,   844,
   -2959, -2539,     0,     0,     0,     0,  4273,     0,     0,     0,
       0,     0,   875,     0,     0,     0,     0,     0,  4274,  1572,
    2359,     0,     0,     0,     0,  4199,     0,     0,  2360,     0,
    1572,     0,     0,     0,     0,     0, -3107,     0,     0,     0,
       0,     0,     0, -2539, -2539, -2539,     0,     0,     0,  4292,
    4293,     0,     0,     0,     0, -2539,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2539, -2539,  4305,     0,
       0,     0,     0,  4199,  4199,     0,     0,     0,     0,  4199,
       0,  4350,  4199, -2539,     0,     0,  4199,  4199,     0,     0,
       0,     0,     0,     0,  2361,     0,     0,     0,     0,     0,
       0,     0,  4365,     0,     0,     0,     0,     0,  2362,   789,
       0,     0,   789, -2539,     0,   790,   791,     0,   790,   791,
       0,     0,     0,  2363,     0,     0,  4381,     0,   976,     0,
       0,   793,     0,     0,   793,     0,     0,     0,  1205,  1205,
       0, -2539, -2539, -2539, -2539, -2539,     0,     0,     0,     0,
   -2539,     0, -2539,     0,     0, -3107,     0,  4426,     0, -2539,
       0,     0,     0, -2539, -2539, -2539,     0,     0,  1205,     0,
       0,     0, -2539,     0,     0, -2539,     0,     0,     0,     0,
       0, -2973,     0,     0,     0,     0,  1205,  2364,  4448,  4448,
       0, -2539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2365,  4453,     0,     0,     0,     0,  4456,     0,     0,
   -2539, -3107,     0,     0,     0,     0,     0,  4459,  4463,     0,
    -339,     0,     0,  4448,     0,     0,     0,     0,     0,     0,
       0,  4472,     0,     0, -2539,     0,     0,     0,     0,     0,
    1205,     0,     0,     0, -2539,     0,     0,     0,     0,     0,
       0, -3107,     0, -2539,     0, -2539,     0,     0,     0,     0,
       0,     0, -2539,     0,     0,   875,     0,   875, -2539,     0,
       0,     0,     0,  2366,     0,     0,     0,  2367,     0,     0,
       0, -2539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2368,  2369,     0,     0,   794,   795,   796,
     794,   795,   796, -2539,     0,     0,     0,     0,     0,   797,
       0,   875,   797,     0,     0,     0,     0,     0,     0,     0,
       0, -2959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2539,     0,     0,     0,     0,     0,     0,
     508,     0,     0, -3107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   875,     0,     0,     0,
       0,     0,     0,     0, -2539,     0,     0,     0, -3107,     0,
       0,     0,     0,     0,     0,   798,   799,   800,   798,   799,
     800,     0,     0,     0,     0,     0,     0,   801,     0,   802,
       0,     0,     0,  3664,     0,     0,   509,   803,   804,   805,
     803,   804,   805,     0,     0,     0,   806,     0,     0,   806,
       0,     0,   510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3107,     0,   807,     0,
       0,     0,     0,     0,     0,     0, -2539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2959, -2959,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2539, -2539,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   808,
       0,     0,   808,     0,     0,     0,     0,     0,     0,     0,
   -2539,     0, -2539,     0, -2539,     0,     0,     0, -2539,     0,
   -2539, -2539, -2539, -2539,     0, -2539, -2539,     0,   809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2539, -3107,     0, -3107, -3107,     0,     0,     0,
       0,     0,     0,     0,     0,   875,     0,   875,     0,     0,
       0,     0,     0,     0,     0, -3107,     0,     0, -2539,     0,
   -3107,     0, -2845,     0,     0,     0, -2539,  1324,     0,     0,
     511, -2845,     0,     0,  1325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2845,     0,     0,     0,
       0, -2539,     0,     0,     0,     0,     0, -2539, -3107,     0,
       0,     0,     0,     0,  1326, -2845,     0,     0,     0,     0,
   -3107, -2539,     0,     0,     0,     0,     0,     0,   810,     0,
       0,   810,     0,     0,     0,  1327,  1328,  1329,  1330,  1331,
    1332,  1333,  1334,     0,     0,     0, -2845, -2845, -2845,     0,
    1335, -2845,     0,     0,     0,  1336,     0,     0, -2845,     0,
       0,     0,     0,     0,     0,     0,  1337,  1338,  1339,  1340,
   -2845,     0, -2845, -2845,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1341,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1342,     0,     0,  1343,  1344,  1345, -2845,
    1346,     0,     0,   512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3107,     0,
       0,     0,     0,     0,     0,   811,   812,     0,   811,   812,
       0,     0,  1885,     0,  1347,     0,     0,     0,     0,     0,
       0,     0,     0,  1348,  1349,  1350,  1351,  1352,  1353,  1354,
    1355,     0,     0,     0, -2845,     0,  1356,  1357,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2845,     0,     0,
       0,     0,     0,     0,     0,     0,   480,     0,     0,     0,
     513,     0,  1358,  1359,     0,     0,  1360,  1361,     0, -2845,
   -2845,  1362, -2845, -2845,     0,     0,   814,     0,     0,   814,
       0,     0,     0,  1363,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1364,     0,     0,     0,     0,     0,
       0,     0,   815,     0,     0,   815,     0,     0,     0,     0,
     816,     0,     0,   816,     0,     0,     0, -2845,  1365,     0,
       0,     0,  1366,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2845,     0,   817,     0,  1367,   817,     0,
       0,   186,  1368,  1369,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   514,  1370,
    1371,  1372,  1373,  1374,     0,     0,  1375,     0,     0,     0,
   -2845, -2845, -2845,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2845,     0,     0,     0,     0, -2845,     0,     0,
       0,     0,     0,     0,     0,  1376,  1377,  1378,  1379,     0,
       0,     0,     0,     0,  1380,  1381,     0,  1382,     0,  1383,
    1384,  1385, -2845, -2845,  1386,  1387,     0,  1388,     0, -2845,
   -2845,  1389,     0,     0,     0,     0,  3783,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1390,  1391,     0,     0,     0,     0,     0,     0,     0,  1392,
    1393,  1394,  1395,  1396,  1397,     0,  1572,     0,     0,     0,
       0,     0,     0,  1398,     0,     0,     0,  1399,  1400,     0,
       0,  1401,     0, -2845,     0, -2845,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2845,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2845, -2845, -2845,     0,     0,  1402,
       0,     0,     0,  1403,     0,  1404,  1405,  1406,  1407,     0,
       0,     0,     0,     0,     0,  1408,     0,     0,     0,     0,
       0, -2845,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1409,     0,     0,     0,     0,     0,     0,     0,  1410,
       0,     0,     0,  1572, -2845, -2845, -2845,     0, -2845,     0,
   -2845, -2845,     0, -2845,     0, -2845, -2845,     0,     0,  1503,
   -2845,     0, -2845, -2845, -2845, -2845,     0,     0,     0,     0,
       0,     0,     0,     0,  1411,  1412,     0,     0, -2845,     0,
       0,     0,     0,     0,     0,     0, -2845,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2845,
   -2845,     0,     0,     0,     0,     0,     0,  1413, -2845,     0,
    1414,     0,     0,     0, -2845,     0,     0,     0,     0,     0,
       0,  1415,     0,     0,     0,     0,     0,  1416,     0,     0,
       0,  1417,     0,  1418,  1419,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1420,     0,     0,
    1421,  1422,     0,     0,     0,     0,  1423,     0,     0,     0,
       0, -2845,     0,     0,     0,     0, -2845,     0,     0,     0,
    1424,     0,  1425,  1426,     0,     0,     0,     0,     0,     0,
       0,  1427,  1428,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1572,     0,     0,
       0,  1429,  1430,  1431,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2845, -2845,     0,
       0,     0,  1432,  1433,  1434,  1435, -2845,  1436,     0,     0,
       0,  1437,  1438,     0,     0,     0,     0,     0,     0,  1439,
    1440,     0,     0,     0,     0,     0,     0,  1441,  1442,  1443,
   -2845,     0,     0,     0,     0,  1444,     0,     0,     0,     0,
    1445,     0,     0, -2845, -2845, -2845, -2845,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1446,     0,
       0,     0,     0, -2845, -2845,     0,     0,     0,     0,     0,
       0,  1447,  1448,     0, -2845,     0,     0,  1449,     0,     0,
       0,   313,  1504,     0,     0,   314,     0,     0,     0,     0,
     315,     0,     0,     0,     0,     0,     0,   316,     0,  1450,
    1451,     0,     0, -2845,     0,     0,   317,     0,  1452,     0,
       0,     0,     0,     0,     0,     0,  1453, -2845, -2845,     0,
       0,     0,  1454,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1455,     0,     0, -2845,     0,     0,     0,  1456,
       0,     0,     0,     0, -2845,     0,     0,   318,   319,     0,
       0, -2845,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2845,     0,     0,     0, -2845, -2845, -2845,     0,
       0,     0,     0,     0,     0,     0,     0,   320,     0,  1457,
       0,     0,     0, -2845, -2845,  1458,  1459,     0,  1460, -2845,
   -2845,  1461, -2845,     0,     0,     0,     0,   321,  1462, -2845,
       0,   322,     0,     0,     0,     0,     0,     0,     0,     0,
    1463,     0,     0,  1464,     0,     0,     0,     0,     0,   323,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1379,     0,     0,  1727,
       0,     0,     0,     0,  1728,  1729,  1730,  1731,     0,     0,
     324,  1732,     0,     0,     0,     0,   325,     0,   326,     0,
       0,     0,   327,     0,     0,     0,   328,     0,     0,     0,
    1733,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   329,     0,     0, -1379,     0,     0,     0,
   -1379, -1379, -1379, -1379, -1379,     0, -1379, -1379, -1379, -1379,
       0, -1379, -1379,     0, -1379, -1379,     0, -1379, -1379, -1379,
   -1379, -1379, -1379, -1379, -1379, -1379, -1379, -1379,  1734,     0,
     330,     0,     0,     0,     0,     0,     0,     0, -1379,     0,
       0,     0,     0, -1379,     0,     0,   331,     0,     0,     0,
       0, -1379,     0,     0,     0,     0,   332,     0,     0,     0,
       0,     0,     0,     0,     0,  1735,     0,  1736,     0,     0,
       0,     0,     0,   844,   844,     0,     0,     0,     0,  1737,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1738,   844,   333,     0,     0,     0,     0,     0,
       0,     0,   334,     0,     0,   335,     0,     0,     0,     0,
     336,   844,     0,     0,     0,     0,     0,     0,   313,     0,
       0,     0,   314,     0,     0,     0,     0,   315,     0,     0,
       0,     0,     0,     0,   316,     0,     0,   337,     0,     0,
       0,     0,     0,   317,     0,   338,     0,   339,     0,     0,
     340,     0,     0,   341,     0,     0,     0,     0, -1379,     0,
       0,     0,     0,     0,     0,   844,     0,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   318,   319,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1739,   343,   320,     0,     0,     0,     0,   344,
       0,   345,  1740,     0,   346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,   322,   347,
       0,     0,     0,     0,     0,     0,     0,     0, -1379,     0,
       0,     0,  1741,     0,     0,     0,   323,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1379, -1379, -1379,
       0, -1379, -1379, -1379, -1379,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   348,     0,     0,     0,     0,     0,   324,     0,     0,
       0,     0,     0,   325,     0,   326,     0,     0,     0,   327,
    1742,     0,     0,   328,   349,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1743,     0,     0,  1744,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   350,     0,     0,     0,     0,
       0,   351,     0,     0,     0,   352,     0,   330,   353,   354,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   331,     0,   355,     0,     0,  1745,     0,
       0,     0,     0,   332,     0,  1746,     0,     0,     0,     0,
       0,   356,     0,     0,     0,     0,     0,   357,     0,     0,
       0,     0,     0,     0,   358,     0,     0,     0,     0,   313,
     359,     0,     0,   314,     0,     0,     0,     0,   315,     0,
       0,  1747,     0,     0,     0,   316,     0,     0,     0,   360,
       0,   333,     0,     0,   317,     0,     0,  1748,     0,   334,
       0,     0,   335,   361,     0,     0,     0,   336,     0,   362,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1379,     0,   363,     0,     0,
       0,     0,     0,     0,   337,     0,     0,     0,     0,     0,
       0,   364,   338,     0,   339,  1749,     0,   340,  1750,     0,
     341,   365,   366,     0,     0,   318,   319,     0,     0,   367,
       0,     0,   368,     0,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   369,     0,     0,
       0,     0,     0,     0,     0,   320,     0,     0,     0,     0,
       0,  1751,     0,     0,     0,     0,     0,     0,     0, -1379,
       0,     0,     0,     0,  1752,   321,  1753,  1754,     0,   322,
   -1379,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   371,  1755,   323,     0,     0,
     343,  1756,     0,     0,     0,     0,   344,   372,   345,  1757,
       0,   346,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   347,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   374,   324, -3067,
       0,     0,     0,     0,   325,     0,   326,     0,     0,     0,
     327,  1758,     0,     0,   328,     0, -1379,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   375,     0,     0,
       0,   329,   376,     0,     0,     0,     0,     0,   348,     0,
       0,     0,     0,     0,  1759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   349,     0,     0,     0,  1760,     0,     0,   330,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   331,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   332,     0,     0,     0,     0,     0,
       0,     0,   350,     0,     0,     0,     0,     0,   351,  1761,
       0,     0,   352,     0,     0,   353,   354,     0,     0,     0,
       0,  1762,     0,     0,     0,     0,     0,     0,  1763,     0,
       0,     0,   355,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   333,     0,     0,     0,     0,     0,   356,     0,
     334,     0,     0,   335,   357,     0,     0,     0,   336,     0,
       0,   358,     0,     0,     0,     0,   313,   359,     0,     0,
     314,     0,     0,     0,     0,   315,     0,     0,     0,     0,
       0,     0,   316,     0,     0,   337,   360,     0,     0,     0,
       0,   317,     0,   338,     0,   339,     0,     0,   340,     0,
     361,   341,     0,     0,     0,     0,   362,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   342,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
       0,     0,   318,   319,     0,     0,   367,     0,     0,   368,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   369,     0,     0,     0,     0,     0,
       0,   343,   320,     0,     0,     0,     0,   344,     0,   345,
       0,     0,   346,     0,     0,     0,   370,     0,     0,     0,
    1667,     0,   321,     0,     0,  -260,   322,   347,  -260,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   371,     0,   323,     0,  -260,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,     0,   788,  -260,
     373,     0,     0,   507,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1297,  -260,     0,     0,   348,
       0,     0,     0,     0,   374,   324,     0,     0,     0,     0,
       0,   325,     0,   326,     0,     0,     0,   327,     0,     0,
       0,   328,   349,     0,     0,     0,     0,     0,     0,   507,
       0,     0,     0,     0,   375,     0,     0,     0,   329,   376,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -260,     0,     0,   350,     0,     0,     0,     0,     0,   351,
       0,     0,     0,   352,     0,   330,   353,   354,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   331,     0,   355,     0,     0,     0,  1524,     0,     0,
       0,   332,     0,     0,     0,     0,     0,     0,     0,   356,
       0,     0,     0,     0,     0,   357,     0,     0,   789,     0,
       0,     0,   358,     0,   790,   791,     0,     0,   359,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     793,     0,     0,     0,     0,     0,     0,   360,     0,   333,
       0,     0,     0,     0,     0,     0,     0,   334,     0,     0,
     335,   361,     0,     0,   789,   336,     0,   362,     0,     0,
     790,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   363,   793,     0,     0,     0,
       0,     0,   337,     0,     0,     0,     0,     0,     0,   364,
     338,     0,   339,     0,     0,   340,     0,     0,   341,   365,
     366,     0,     0,     0,     0,     0,     0,   367,     0,     0,
     368,     0,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -260,  -260,     0,
       0,     0,     0,     0,     0,     0,     0,  1615,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   371,     0,     0,     0,     0,   343,     0,
       0,     0,     0,     0,   344,   372,   345,     0,     0,   346,
       0,   373,     0,     0,     0,     0,   794,   795,   796,     0,
       0,     0,     0,     0,   347,     0,     0,     0,   797,     0,
       0,     0,     0,     0,     0,   374,     0,     0,     0,     0,
       0,     0,  -260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   508,     0,     0,     0,
       0,  1525,   794,   795,   796,   375,     0,     0,     0,     0,
     376,     0,     0,     0,   797,     0,   348,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1299,     0,     0,   549,
       0,     0,     0,     0,   550,     0,  -260,     0,     0,   349,
       0,   551,   508,     0,     0,     0,     0,     0,     0,     0,
     552,     0,  -260,     0,   798,   799,   800,     0,     0,     0,
       0,     0,     0,   801,     0,   802,     0,     0,     0,     0,
       0,     0,   509,     0,     0,     0,   803,   804,   805,     0,
     350,     0,     0,     0,     0,   806,   351,     0,   510,     0,
     352,     0,     0,   353,   354,     0,     0,     0,     0,     0,
     798,   799,   800,     0,   807,     0,     0,     0,     0,     0,
     355,   553,   554,     0,  -260,     0,     0,     0,   509,     0,
       0,     0,   803,   804,   805,     0,   356,     0,     0,     0,
       0,   806,   357,     0,   510,     0,     0,     0,     0,   358,
       0,   555,     0,     0,     0,   359,     0,  1300,     0,     0,
       0,     0,     0,     0,     0,  -260,     0,     0,     0,     0,
       0,   556,     0,  -260,   360,   557,     0,     0,   808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   361,     0,
       0,  1301,     0,   558,   362,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   809,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   808,     0,   364,     0,     0,     0,
       0,     0,     0,     0,   559,     0,   365,   366,     0,  -260,
       0,     0,     0,     0,   367,     0,   560,   368,     0,     0,
     561,     0,     0,  -260,     0,     0,   511,     0,     0,     0,
       0,     0,   369,     0,     0,     0,     0,     0,  -260,     0,
     562,     0,     0,     0,     0,   563,   564,   565,   566,     0,
     567,   568,   569,   570,     0,   571,     0,   572,   573,   574,
       0,   575,   576,   577,   578,   579,   580,   581,   582,   583,
     584,   585,   511,     0,   586,     0,     0,   810,     0,     0,
     371,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     587,     0,   372,     0,     0,     0,  -260,  -260,   373,     0,
     588,     0,  -260,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -260,     0,     0,     0,
       0,     0,   374,   810,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -260,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   589,   512,
       0,     0,   375,     0,     0,     0,   590,   376,     0,   591,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   811,   812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -260,     0,
       0,   593,  -260,     0,     0,   512,     0,     0,     0,   594,
       0,   595,     0,     0,   596,     0,     0,   597,  -260,  -260,
       0,     0,     0,  1302,     0,  1303,     0,     0,     0,     0,
     811,   812,     0,     0,  1304,  1305,   513,     0,  1306,  1307,
       0,     0,     0,     0,     0,   789,     0,     0,     0,     0,
       0,   790,   791, -3107,     0,   814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   793,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   815,   513,     0,     0,     0,     0,     0,     0,   816,
       0,     0,     0,     0,     0,     0,     0,   598,     0,     0,
       0,   814,     0,   599,     0,   600,     0,     0,   601,     0,
       0,     0,     0,     0,   817,     0,     0, -2065,     0,     0,
     186,     0,     0,   602,     0,     0,     0,   815,     0,     0,
       0,     0,     0,     0,   514,   816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2065,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     817,     0,     0,     0,     0,   480,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,     0,     0,     0,
     514,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   604,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   794,   795,   796,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   797,     0,     0,     0,   605,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   606,
       0,     0,     0,   508,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   607,     0,     0,     0,     0,     0,     0,   608,     0,
       0,     0,     0,     0,   609,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   610,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   800,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   611,     0,     0,     0,     0,     0,   509,
       0,     0,     0,   803,   804,   805,     0,     0,     0,     0,
       0,   612,   806,     0,     0,   510,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   613,  1324,     0,     0,     0,
       0,     0,     0,  1325,     0,   614,   615,     0,     0,     0,
       0,     0,     0,   616,     0,     0,   617,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   618,  4003,  1326,     0,     0,     0,  4004,  4005,  4006,
    4007,     0,     0,     0,  4008,  2258,  2259,  2260,  2261,  2262,
       0,  2263,  2264,   619,  1327,  1328,  1329,  1330,  1331,  1332,
    1333,  1334,  4009,  4010,     0,   808,     0,     0,     0,  1335,
       0,     0,     0,     0,  1336,     0,     0,     0,     0,   620,
       0,     0,  4011,     0,     0,  1337,  1338,  1339,  1340,     0,
       0,   621,     0,     0,     0,     0,     0,   622,     0,     0,
       0,     0,  1341,  4012,     0,     0,     0,     0,     0,     0,
    1718,  4013,  1342,     0,  1719,  1343,  1344,  1345,     0,  1346,
       0,     0,     0,     0,     0,     0,     0,     0,  2266,     0,
    2267,  2268,  2147,  2269,  2270,  2271,  2272,  2273,  2274,     0,
       0,     0,     0,   511,     0,     0,     0,     0,     0,     0,
       0,   623,     0,  1347,     0,     0,   624,     0,     0,  4014,
       0,     0,  1348,  1349,  1350,  1351,  1352,  1353,  1354,  1355,
       0,     0,     0,     0,     0,  1356,  1357,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   810,     0,     0,     0,     0,     0,
    2275,  1358,  1359,     0,     0,  1360,  1361,     0,     0,     0,
    1362,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1363,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1364,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1365,     0,     0,
       0,  1366,     0,     0,     0,     0,   512,     0,     0,  4015,
       0,     0,     0,     0,     0,     0,  1367,     0,     0,     0,
       0,  1368,  1369,     0,     0,     0,     0,     0,     0,     0,
       0,   811,   812,     0,     0,     0,     0,     0,  1370,  1371,
    1372,  1373,  1374,     0,     0,  1375,     0,     0,     0,     0,
       0,     0,  2276,  2277,  2278,  2279,  2280,     0,     0,  2155,
    2281,     0,     0,     0,     0,  4016,     0,     0,     0,     0,
       0,     0,     0,  4017,     0,  4018,     0,     0,     0,     0,
       0,     0, -3009,   513,  1376,  1377,  1378,  1379,     0,     0,
       0,     0,  4019,  1380,  1381,  2282,  1382,     0,  1383,  1384,
    1385,     0,   814,  1386,  1387,  4020,  1388,     0,     0,     0,
    1389,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2283,     0,     0,     0,     0,     0,     0,     0,   815,  1390,
    1391,     0,     0,     0,     0,     0,   816,    52,  1392,  1393,
    1394,  1395,  1396,  1397,     0,     0,     0,  2284,     0,     0,
       0,     0,  1398,     0,     0,     0,  1399,  1400,     0, -3080,
    1401,   817,     0,  4021,     0,     0,     0,   186,     0,     0,
       0,     0,     0,     0,     0,  4022,     0,     0,     0,  4023,
       0,   514,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4024,  1402,     0,
       0,     0,  1403,     0,  1404,  1405,  1406,  1407,     0,     0,
       0,     0,     0,     0,  1408,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2285,     0,     0,     0,
    1409,     0,     0,     0,     0,     0,     0,     0,  1410,     0,
       0,  4025,     0,     0,     0,     0,     0,     0,  1746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1503,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1411,  1412,     0,     0,     0,     0,     0,
       0,     0,  4026,     0,  1747,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4027,  2287,     0,     0,     0,     0,  1413,     0,     0,  1414,
       0,     0,     0,     0,     0,     0,     0,  2288,     0,     0,
    1415,     0,  2289,     0,  1721,  1722,  1416,     0,     0,     0,
    1417,     0,  1418,  1419,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2290,  1420,     0,  4028,  1421,
    1422,     0,     0,     0,     0,  1423,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1424,
       0,  1425,  1426,     0,     0,     0,     0,     0,     0,     0,
    1427,  1428,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4029,     0,     0,     0,     0,     0,
    1429,  1430,  1431,     0,     0,     0,     0,  1752,     0,  1753,
    1754,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1432,  1433,  1434,  1435,     0,  1436,     0,     0,     0,
    1437,  1438,     0,     0,     0,     0,     0,     0,  1439,  1440,
       0,     0,  4030,     0,     0,     0,  1441,  1442,  1443,     0,
       0,     0,     0,     0,  1444,     0,     0,     0,     0,  1445,
       0,     0,     0,     0,     0,     0,  2293,     0,  2294,  2295,
    2296,     0,  4031,     0,     0,     0,     0,  1446,     0,     0,
       0,     0,     0,     0,  4032,     0,     0,     0,     0,     0,
    1447,  1448,     0,     0,     0,     0,  1449,     0,     0,     0,
       0,  1504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4033,  1450,  1451,
       0,     0,     0,     0,     0,     0,     0,  1452,     0,     0,
       0,     0,     0,     0,     0,  1453,     0,     0,     0,     0,
       0,  1454,  4034,     0,     0,     0,     0,  -947,     0,     0,
       0,     0,     0,  4035,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3080,  1455,     0,     0,     0,     0,     0,     0,  1456,     0,
       0,     0,  4036,  1324,     0,     0,     0,  2298,  2299,  2300,
    1325,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2301,     0,     0,     0,     0,     0,     0,
       0,  4037,     0,     0,     0,     0,     0,  2250,  1457,     0,
    1326,     0,     0,     0,  1458,  1459,     0,  1460,     0,     0,
    1461,     0,     0,     0,     0,     0,     0,  1462,     0,     0,
       0,  1327,  1328,  1329,  1330,  1331,  1332,  1333,  1334,  1463,
       0,     0,  1464,     0,     0,     0,  1335,     0,     0,     0,
       0,  1336,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1337,  1338,  1339,  1340,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1341,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1342,
       0,     0,  1343,  1344,  1345,     0,  1346,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1347,     0,     0,     0,     0,     0,     0,     0,     0,  1348,
    1349,  1350,  1351,  1352,  1353,  1354,  1355,     0,     0,     0,
       0,     0,  1356,  1357,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1358,  1359,
       0,     0,  1360,  1361,     0,     0,     0,  1362,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1363,
       0,     0,     0,     0,     0,     0,  1158,     0,     0,     0,
    1364,     0,     0,     0, -3107, -3107, -3107, -3107,     0,     0,
       0, -3107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1365,     0,     0,     0,  1366, -3107,
   -3107,     0,  2945,     0,  2946,     0,     0,     0,     0,     0,
       0,     0,     0,  1367,     0,     0,     0,     0,  1368,  1369,
       0,     0,     0,     0,     0,     0,     0, -1786,     0,     0,
       0,     0,     0,     0,     0,  1370,  1371,  1372,  1373,  1374,
       0,     0,  1375,     0,     0,     0,     0, -2959, -3107,     0,
       0, -2959,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1376,  1377,  1378,  1379,     0,     0, -3107,     0,     0,
    1380,  1381,     0,  1382,     0,  1383,  1384,  1385,     0,     0,
    1386,  1387,     0,  1388,     0,     0,     0,  1389,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1390,  1391,     0,     0,
       0,     0,     0,     0,     0,  1392,  1393,  1394,  1395,  1396,
    1397,     0,     0,     0,     0,     0,     0,     0,     0,  1398,
       0,     0,     0,  1399,  1400,     0,     0,  1401,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   789,     0,     0,     0,     0,     0,
     790,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1402,   793,     0,     0,  1403,
       0,  1404,  1405,  1406,  1407,     0, -3107,     0,     0,     0,
       0,  1408,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1409,     0,     0,
       0,     0,     0,     0,     0,  1410,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0, -3107,     0,     0,     0,     0,     0,     0,     0,
    1411,  1412,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2947,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3107,  1413,     0,     0,  1414,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1415,     0,     0,
       0,     0,     0,  1416,     0,     0,     0,  1417,     0,  1418,
    1419,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1420,     0,     0,  1421,  1422,     0,     0,
       0,     0,  1423,     0,     0,     0,     0,     0,     0, -1786,
       0,     0,   794,   795,   796,     0,  1424,     0,  1425,  1426,
       0,     0, -2959,     0,   797,     0,  2948,  1427,  1428,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3107,     0,     0,  1429,  1430,  1431,
       0,     0,   508,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1432,  1433,
    1434,  1435,     0,  1436,     0,     0,     0,  1437,  1438,     0,
       0,     0,     0,     0,     0,  1439,  1440,     0, -3107,     0,
       0,     0,     0,  1441,  1442,  1443,     0,     0,     0,     0,
       0,  1444,     0,     0,     0,     0,  1445,     0,     0,     0,
     798,   799,   800,     0,     0,     0,     0,     0,     0,   801,
       0,   802,     0,     0,  1446,     0,     0,     0,   509,     0,
       0,     0,   803,   804,   805,     0,     0,  1447,  1448,     0,
       0,   806,     0,  1449,   510,     0,     0, -3107,  1504,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1450,  1451,     0,     0,  1324,
    2949, -2959, -2959,     0,  1452,     0,  1325,     0,     0,     0,
       0,     0,  1453,     0,     0,     0,     0,     0,  1454,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1326,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1455,     0,
       0,     0,     0,     0,   808,  1456,     0,  1327,  1328,  1329,
    1330,  1331,  1332,  1333,  1334,     0,     0,     0,     0,     0,
       0,     0,  1335,     0,     0,     0,     0,  1336,     0,     0,
     809,     0,     0,     0, -3107,     0, -3107, -3107,  1337,  1338,
    1339,  1340, -1786,     0,     0,  1457,     0,     0,     0,     0,
       0,  1458,  1459,     0,  1460,  1341, -3107,  1461,     0,     0,
       0, -3107,     0,     0,  1462,  1342,     0,     0,  1343,  1344,
    1345,     0,  1346,     0,     0,     0,  1463,     0,     0,  1464,
       0,     0,   511,     0,     0,     0,     0,  2950,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3107,
       0,     0,     0,     0,     0,     0,  1347,     0,     0,     0,
       0, -3107,     0,     0,     0,  1348,  1349,  1350,  1351,  1352,
    1353,  1354,  1355,     0,     0,     0,     0,     0,  1356,  1357,
       0,     0,     0,   810,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1358,  1359,     0,     0,  1360,  1361,
       0,     0,     0,  1362,     0,     0,     0, -1786,     0,     0,
       0,     0,     0,     0,     0,  1363,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1364,     0,     0,  2951,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   512,     0,     0,     0, -3107,
    1365,     0,     0,     0,  1366,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
     811,   812,     0,     0,  1368,  1369,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1370,  1371,  1372,  1373,  1374,     0,     0,  1375,     0,
       0,     0,     0,     0,     0,     0,     0,   480,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     831,     0,   513,     0,   832,   833,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1376,  1377,  1378,
    1379,   814,     0,     0,     0,     0,  1380,  1381,     0,  1382,
       0,  1383,  1384,  1385,     0,     0,  1386,  1387,     0,  1388,
       0,     0,     0,  1389,     0,     0,     0,   815,     0,     0,
       0,     0,     0,     0,     0,   816,     0,     0,     0,     0,
       0,     0,  1390,  1391,     0,     0,     0,     0,     0,     0,
       0,  1392,  1393,  1394,  1395,  1396,  1397,     0,     0,     0,
     817,     0,     0,     0,     0,  1398,   186,     0,     0,  1399,
    1400,     0,     0,  1401,     0,     0,     0,     0,     0,     0,
     514,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1402,     0,     0,     0,  1403,     0,  1404,  1405,  1406,
    1407,     0,     0,     0,     0,     0,     0,  1408,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     788,     0,     0,  1409,     0,   507,     0,     0,     0,     0,
       0,  1410,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1714,     0,     0,     0,     0,     0,     0,     0, -1714, -1714,
   -1714, -1714,     0,     0,     0, -1714,  1411,  1412,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1714, -1714,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1413,
       0,     0,  1414,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1415,     0,     0,     0,     0,     0,  1416,
       0,     0,     0,  1417,     0,  1418,  1419,     0,     0,     0,
       0, -1714, -1714,     0,     0, -1714,     0,     0,     0,  1420,
       0,     0,  1421,  1422,     0,     0,     0,     0,  1423,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     789,     0,  1424,     0,  1425,  1426,   790,   791,     0,     0,
       0, -1714,     0,  1427,  1428,     0,     0,     0,     0,     0,
       0,     0,   793,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1429,  1430,  1431,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1432,  1433,  1434,  1435,     0,  1436,
       0,     0,     0,  1437,  1438,     0,     0,     0,     0,     0,
       0,  1439,  1440,     0,     0,     0,     0,     0,     0,  1441,
    1442,  1443,     0,     0,     0,     0,     0,  1444,     0,     0,
       0,     0,  1445,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1446,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1447,  1448,     0,     0,     0,     0,  1449,
   -1714,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1450,  1451,     0,   788,     0,     0,     0,     0,   507,
    1452,     0,     0, -3009, -3009, -3009,     0,     0,  1453,     0,
       0,  1297,     0,     0,  1454,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1714,     0,   794,   795,
     796,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     797,     0,     0,     0,  1455,     0,     0,     0,     0,     0,
       0,  1456,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1714,     0,   508,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1457,     0,     0,     0,     0, -3009,  1458,  1459,     0,
    1460,     0,     0,  1461,     0,     0,     0,     0,     0,     0,
    1462,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1463,     0,     0,  1464,   798,   799,   800,     0,
       0,     0,     0,     0,   789,   801, -1714,   802,     0,     0,
     790,   791,     0,     0,   509,     0,     0,     0,   803,   804,
     805,     0,     0,     0,     0,     0,   793,   806, -1714,     0,
     510,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   807, -1714,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1714,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   788,     0,     0,     0,     0,   507,     0,     0,     0,
       0, -1714,     0, -3009,     0,     0,   809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1298,     0,     0,     0,     0, -1714, -1714,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   511,     0,
       0,     0,   794,   795,   796,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   797,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3009, -3009,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   508,     0,     0,     0,     0,     0, -1714,   810,
   -1714, -1714,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1714,   789,  1299,     0,     0, -1714,     0,   790,   791,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   793,     0,     0,     0,     0,     0,     0,
     798,   799,   800, -3009, -3009,     0,     0,     0,     0,   801,
       0,   802,     0, -1714,     0,     0,     0,     0,   509,     0,
       0,   512,   803,   804,   805, -1714,     0,     0,     0,     0,
       0,   806,     0,     0,   510,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   811,   812,     0,     0,
     807,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3009,
   -1616,     0,     0,     0,     0, -1616,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1300,     0,     0,     0,     0,   513,     0,
       0,   891,     0, -3009,     0,     0,     0,     0,     0,     0,
       0,     0, -3009,     0,   808,     0,     0,   814,     0,     0,
       0, -3009,     0, -1714,     0,   788,     0,  1301,     0,     0,
     507,     0,     0,     0,     0,     0,     0, -1714,     0,     0,
     809,     0,  2230,   815,     0,     0,     0,     0,     0,     0,
       0,   816,     0,   892,     0,     0,     0,     0,     0,   794,
     795,   796, -3009,     0,     0,     0,     0,     0,     0,     0,
       0,   797,     0,     0,     0,     0,   817,     0,     0,     0,
       0, -1714,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   511,     0,     0,     0,   514,     0,     0,   508,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1616,   893,     0,     0,     0, -2967, -1616, -1616,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1616,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   810,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   798,   799,   800,
       0,     0,     0,     0,     0,   789,   801,     0,   802,     0,
       0,   790,   791,     0,     0,   894,     0,     0,     0,   803,
     804,   805,     0,     0,     0,     0,     0,   793,   806,     0,
       0,   510,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   895,     0,     0,   807,     0,     0,
       0,     0,     0,     0,     0,   512,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2191,     0,     0,     0,     0,   507,     0,
     811,   812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   808,     0,     0,     0,     0,     0,     0,   896,  1302,
       0,  1303,     0, -3009,     0,     0,     0, -3009,     0, -3009,
    1304,  1305,   513,     0,  1306,  1307, -3107,   809, -1616, -1616,
   -1616,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1616,   814,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   815, -1616,     0,
       0,     0,     0,     0,     0,   816,     0,     0,     0,   511,
       0,     0,     0,   794,   795,   796,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   797,     0,   653,     0,     0,
     817,     0,     0,   789,     0,     0,   186,     0,   788,   790,
     791,     0,     0,   507,     0,     0,     0,     0,     0,     0,
     514,     0,     0,   508,     0,   793, -1616, -1616, -1616,     0,
     810,     0,     0,     0,     0, -1616,     0, -1616,     0,     0,
       0,     0,     0,     0, -1616,     0,     0,     0, -1616, -1616,
   -1616,     0,     0,     0,     0,     0,     0, -1616,     0,     0,
   -1616,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1616,     0,     0,     0,
       0,   798,   799,   800,     0,     0,     0,     0,     0,     0,
     801,     0,   802,     0,     0,     0,     0,     0,     0,   509,
       0,     0,   512,   803,   804,   805,   897,     0,     0,     0,
       0,     0,   806,     0,     0,   510,     0,     0,     0,     0,
       0,     0,  2192,     0,     0,     0,     0,   811,   812,     0,
     898,   807,   788,     0,     0,     0,     0,   507,     0,     0,
   -1616,     0,     0,     0,     0,     0,     0, -1616,   789,     0,
       0,     0,     0,     0,   790,   791,     0,     0,     0,     0,
       0,     0,     0,     0,   792,     0, -1616,     0,     0,     0,
     793,     0,     0, -3107,     0,   899,     0,     0,     0,   513,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   794,   795,   796,     0,   808,     0,     0,   814,     0,
       0,     0,     0,   797,     0,     0,     0,   788,     0,     0,
       0,     0,   507,     0,     0,     0,     0,     0, -1616,     0,
       0,   809,     0,     0,   815,     0,     0,     0,     0,     0,
       0,   508,   816,     0,     0,     0,     0,     0,     0, -2967,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   817,     0,     0,
       0,   900,     0,   186,     0,     0,     0,     0,     0, -1616,
       0,     0,   789,   511,     0,     0,     0,   514,   790,   791,
       0,     0,     0,     0,     0,     0,     0,     0,  1045,   798,
     799,   800,     0,     0,   793,     0,     0,     0,   801,     0,
     802,     0,     0,     0,     0,     0,     0,   509,     0,     0,
       0,   803,   804,   805,     0,     0,     0,     0,     0,     0,
     806,     0,   654,   510,   810,     0,     0,     0,     0,     0,
       0,     0,     0, -1616,     0,     0,   794,   795,   796,   807,
       0, -1616,     0,     0,     0,     0,     0,   789,   797,     0,
       0,     0,     0,   790,   791,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1616, -1616,     0,   793,
       0,     0,     0,     0,     0,     0,   508,     0,     0,     0,
       0,     0,     0,   788,     0,     0,     0,     0,   507,     0,
       0,     0,     0,     0,     0,     0,   512,     0,     0,     0,
       0,     0,     0,   808,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1616,     0,
       0,   811,   812,     0,     0,     0,     0,     0,     0,   809,
       0,     0,     0,     0,   798,   799,   800, -1616,     0,     0,
       0,     0,     0,   801,     0,   802,     0, -1616,     0,     0,
       0,     0,   509,     0,     0,     0,   803,   804,   805,     0,
     794,   795,   796, -1616,     0,   806,     0,     0,   510,     0,
       0, -1616,   797,   513,     0,     0,     0,     0, -2967,     0,
       0,   511,     0,     0,   807,     0,     0,     0,     0,     0,
       0,     0,   814,     0,     0,     0, -1616,     0,     0,     0,
     508,     0, -1616,     0,     0,     0,     0,   788,     0,     0,
       0,     0,   507,     0,     0,     0, -1616,     0,   815,     0,
       0,     0,     0,   789,     0,     0,   816,     0,     0,   790,
     791,     0,   810,     0,     0,   794,   795,   796,     0,     0,
       0,     0,     0,     0,     0,   793,     0,   797,   808,     0,
       0,   817,     0,     0,     0,     0,   480,   186,   798,   799,
     800,     0,     0,     0,     0,     0,     0,   801,     0,   802,
       0,   514,     0,     0,   809,   508,   509,     0,     0,     0,
     803,   804,   805,     0,     0,     0,     0,     0,     0,   806,
       0,     0,   510,     0,     0,     0,  2193,     0,     0,     0,
       0,     0,     0,     0,   512,     0,     0,     0,   807,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   511,     0,     0,   811,
     812,   788,     0,   798,   799,   800,   507,     0,     0,     0,
       0,     0,   801,     0,   802,     0,     0,   789,     0,     0,
       0,   509,     0,   790,   791,   803,   804,   805,     0,     0,
       0,     0,     0,     0,   806,     0,     0,   510,     0,   793,
       0,     0,   808,     0,  2194,     0,     0,   810,     0,     0,
       0,   513,     0,   807,     0,  2195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   809,     0,
     814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   794,   795,   796,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   797,     0,     0,   815,     0,     0,     0,
       0,     0,     0,     0,   816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   808,     0,   512,
     511,   508,     0,     0,     0,     0,     0,     0,     0,   817,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,   789,     0,   809,   811,   812,     0,   790,   791,   514,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   813,
       0,     0,     0,   793,     0,     0,     0,     0,     0,     0,
       0,   810,     0,     0,     0,     0,     0,     0,     0,   798,
     799,   800,     0,     0,     0,     0,     0,     0,   801,     0,
     802,     0,     0,     0,     0,   511,   513,   509,     0,     0,
       0,   803,   804,   805,     0,   794,   795,   796,     0,     0,
     806,  1611,     0,   510,     0,   814,     0,   797,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   807,
     788,     0,     0,     0,     0,   507,     0,     0,     0,     0,
       0,   815,     0,   512,     0,   508,   810,     0,     0,   816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   811,   812,
       0,     0,     0,  1831,   817,     0,     0,     0,   507,     0,
     186,     0,     0,  1046,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   808,   514,     0,     0,     0,     0,     0,
     896,     0,     0,   798,   799,   800,     0,     0,     0,     0,
       0,     0,   801,     0,   802,     0,     0,     0,   512,   809,
     513,   509,     0,     0,     0,   803,   804,   805,     0,   794,
     795,   796,     0,     0,   806,     0,     0,   510,     0,   814,
       0,   797,     0,   811,   812,     0,     0,     0,     0,     0,
       0,     0,     0,   807,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   815,     0,     0,     0,   508,
     789,   511,     0,   816,     0,     0,   790,   791,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   793,     0,     0,   513,     0,     0,   817,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   789,   814,     0,     0,   808,   514,   790,
     791,     0,   810,     0,     0,     0,     0,   798,   799,   800,
       0,     0,     0,     0,     0,   793,   801,     0,   802,     0,
     815,     0,     0,   809,     0,   509,     0,     0,   816,   803,
     804,   805,     0,     0,     0,     0,     0,     0,   806,     0,
       0,   510,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   817,     0,     0,     0,   807,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   514,   512,   511,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   811,
     812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   808,     0,     0,     0,     0,   810,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   794,   795,
     796,     0,     0,     0,     0,     0,     0,   809,     0,     0,
     797,   513,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,   508,     0,
       0,   794,   795,   796,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   797,     0,     0,   815,     0,   512,   511,
       0,     0,     0,     0,   816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   508,     0,   811,   812,     0,     0,     0,     0,   817,
       0,     0,     0,     0,     0,   186,   798,   799,   800,     0,
       0,     0,     0,     0,     0,   801,     0,   802,     0,   514,
     810,     0,     0,     0,   509,     0,     0,     0,   803,   804,
     805,     0,     0,     0,     0,     0,     0,   806,     0,     0,
     510,     0,     0,     0,     0,   513,     0,     0,     0,   798,
     799,   800,     0,     0,     0,     0,   807,     0,   801,     0,
     802,     0,     0,     0,   814,     0,     0,   509,     0,     0,
       0,   803,   804,   805,     0,     0,     0,     0,     0,     0,
     806,     0,     0,   510,  3070,     0,     0,     0,     0,     0,
     815,     0,   512,     0,     0,     0,     0,     0,   816,   807,
       0,     0,     0,     0,     0,   789,     0,     0,     0,     0,
       0,   790,   791,     0,     0,     0,     0,   811,   812,     0,
     808,     0,     0,   817,     0,     0,     0,   793,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   514,     0,     0,   809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   808,     0,     0,     0,     0,     0,   513,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   814,   809,
       0,     0,     0,     0,     0,     0,     0,     0,   511,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   815,     0,     0,     0,     0,     0,
       0,     0,   816,     0,     0,     0,     0,  3800,     0,     0,
       0,     0,     0,  -576,     0,     0,     0,     0,     0,     0,
       0,   511,     0,     0,     0,     0,     0,   817,     0,   810,
       0,     0,     0,   186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   514,     0,     0,
    -576,     0,     0,     0,     0,  -576,  -576,  -576,  -576,  -576,
       0,     0,  -576,  -576,  -576,  -576,  -576,  -576,     0,  -576,
    -576,  -576,   810,   794,   795,   796,     0,     0,     0,     0,
    -576,  -576,     0,     0,     0,   797,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -576,   512,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   508,     0,     0,  -576,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,   811,   812,  -576,  -576,
       0,     0,  -576,     0,     0,     0,     0,     0,     0,  -576,
       0,     0,     0,     0,   512,     0,  -576,     0,  -576,  -576,
    -576,  -576,  -576,  -576,  -576,  -576,  -576,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   811,
     812,   798,   799,   800,     0,     0,     0,  -576,   513,     0,
     801,     0,   802,     0,     0,     0,     0,     0,     0,   509,
       0,     0,     0,   803,   804,   805,  -576,   814,     0,     0,
       0,     0,   806,     0,     0,   510,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -576,     0,
       0,   513,     0,   815,     0,     0,     0,     0,     0,     0,
       0,   816,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   817,     0,     0,     0,
       0,     0,   186,     0,     0,     0,   815,     0,     0,     0,
       0,     0,     0,     0,   816,     0,   514,     0,  -576,     0,
       0,     0,     0,     0,     0,   808,     0,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   817,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,   809,     0,     0,     0,     0,     0,     0,     0,   514,
       0,  1084,     0,     0,     0,     0,     0,     0,     0,     0,
    -576,  -576,  -576,  -576,  -576,     0,     0,  -576,  -576,     0,
       0,     0,     0,  -576,     0,     0,     0,     0,  -576,     0,
       0,  -576,     0,  -576,     0,     0,     0,     0,     0,     0,
    -576,     0,     0,   511,     0,     0,     0,     0,     0,     0,
    -576,     0,     0,  -576,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -576,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -576,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4250,     0,
       0,  -576,     0,     0,   810,  -576,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -576,     0,     0,     0,  -576,
       0,     0,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,  -576,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -576,     0,     0,     0,  -576,     0,     0,
    -576,     0,     0,     0,  -576,  -576,  -576,  -576,  -576,     0,
    -576,  -576,     0,     0,     0,  -576,     0,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,   512,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -576,     0,     0,     0,     0,     0,
       0,   811,   812,     0,     0,     0,     0,     0,     0,  -576,
       0,     0,  2883,     0,     0,     0,  -576,     0,     0,  -576,
       0,     0,  -576,  -576,     0,     0,     0,     0,     0,  -576,
       0,     0,     0,     0,     0,     0,     0,  -576,     0,  -576,
    -576,  -576,  -576,  -576,  -576,  -576,  -576,  -576,  -576,     0,
    -576,   831,  -576,   513,     0,   832,   833,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -576,  -576,
       0,     0,   814,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -576,     0,     0,     0,     0,
    -576,     0,  -576,  -576,     0,     0,     0,     0,   815,     0,
       0,     0,     0,     0,     0,     0,   816,     0,     0,  -576,
       0,     0,     0,  -576,     0,     0,  -576,     0,     0,     0,
       0,     0,  -576,     0,     0,     0,  -576,     0,     0,  1083,
       0,   817,     0,     0,     0,     0,     0,   186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   514,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,  -576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -576,     0,  -576,  -576,     0,
       0,     0,  -576,     0,     0,  -576,  -576,  -576,  -576,  -576,
       0,  -576,  -576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -576,  -576,     0,     0,     0,     0,     0,     0,
    -576,     0,  1084,     0,     0,     0,     0,     0,     0,     0,
       0,  -576,  -576,  -576,  -576,  -576,     0,     0,  -576,  -576,
       0,     0,     0,     0,  -576,     0,  -576,  -576,  -576,     0,
    -576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -576,  -576,  -576,     0,     0,     0,  -576,     0,
    -576,  -576,  -576,  -576,  -576,  -576,  -576,  -576,  -576,     0,
       0,     0,     0,     0,     0,  -576,     0,     0,     0,  -576,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -576,     0,     0,     0,     0,  -576,  -576,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,     0,     0,  -576,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -576,     0,
    -576,     0,     0,  -576,  -576,     0,     0,     0,  -576,     0,
    -576,     0,     0,     0,     0,  -576,  -576,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,     0,     0,     0,  -576,
       0,     0,     0,     0,     0,  -576,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -576,     0,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,     0,     0,  -576,   197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -576,  -576,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1084,     0,     0,     0,     0,     0,     0,
       0,  -576,  -576,  -576,  -576,  -576,  -576,     0,     0,  -576,
    -576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -576,     0,     0,     0,     0,     0,     0,     0,  2026,     0,
       0,     0,  -576,     0,     0,     0,  -576,  2027,     0,     0,
       0,  -576,     0,     0,     0,  -576,     0,  -576,     0,     0,
       0,     0,  2028,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -576,  -576,     0,     0,     0,     0,     0,
    -576,  2029,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,  2030,  2031,  2032,     0,     0,  2033,     0,  -576,
       0,     0,     0,     0,  2034,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2035,     0,  2036,  2037,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2038,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -576,     0,     0,     0,
       0,     0,     0,     0,     0,  -576,     0,  -576,  -576,  -576,
       0,     0,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2039,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2040,     0,     0,     0,     0,  -576,     0,
       0,     0,  -576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2041,  2042,     0,  2043,  2044,
       0,  -576,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -576,  -576,     0,     0,
       0,     0,  -576,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -576,
       0,     0,     0,  2045,     0,  -576,     0,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,  -576,  -576,  -576,  2046,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -576,     0,     0,     0,  -576,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -576,     0,     0,     0,
    -576,     0,     0,     0,     0,     0,  2047,  2048,  2049,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     197,     0,     0,     0,     0,     0,     0,     0,  2050,     0,
       0,     0,     0,  2051,     0,     0,     0,     0,     0,  -576,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2052,  2053,
       0,     0,     0,     0,     0,  2054,  2055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -576,     0,  -576,  -576,
    -576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -576,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2056,
       0,  2057,     0,  -576,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2058,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2059,  2060,  2061,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2062,     0,     0,
    -576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4313,     0,     0,     0,     0,     0,     0,  -576,  -576,  -576,
    2063,  2064,  2065,     0,  2066,     0,  2067,  2068,     0,  2069,
       0,  2070,  2071,  -576,     0,     0,  2072,     0,  2073,  2074,
    2075,  2076,     0,     0,     0,     0,     0,  -576,     0,     0,
       0,     0,     0,     0,  2077,     0,  -576,     0,     0,     0,
       0,     0,  2078,  2258,  2259,  2260,  2261,  2262,     0,  2263,
    2264,   197,     0,     0,     0,  2079,  2080,     0,     0,     0,
    2265,     0,     0,     0,  2081,     0,     0,     0,     0,     0,
    2082,     0,     0,   789,     0,     0,     0,     0,     0,   790,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   793,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4314,     0,
       0,  1780,  4315,     0,     0,     0,     0,  2083,  1781,     0,
       0,     0,  2084,     0,     0,     0,  2266,     0,  2267,  2268,
    2147,  2269,  2270,  2271,  2272,  2273,  2274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1158,     0,     0, -3107,     0,     0,     0,     0, -3107,
   -3107, -3107, -3107,     0,     0,  1159, -3107,     0,     0,     0,
       0,     0,     0,  2085,  2086,     0,     0,     0,     0,     0,
       0,     0,  2087,     0,     0, -3107,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2275,     0,
       0,     0,     0,     0,     0,     0,  2088,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2089,
    2090,  2091,  2092,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2959, -3107,     0,     0, -2959,     0,     0,  2093,
    2094,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2095,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   794,   795,   796,     0,     0,     0,     0,     0,     0,
   -3107,     0, -3107,   797,     0,     0,     0,     0,     0,  2096,
       0,     0,     0,     0, -3107,     0,     0,     0,     0,     0,
       0,     0,     0,  2097,  2098,     0,     0,     0,     0,     0,
       0,   508,     0,     0,     0,     0,     0, -3107,     0,     0,
    2276,  2277,  2278,  2279,  2280,     0,     0,  2155,  2281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2099,     0,     0,     0,     0,     0,     0,     0,     0,
    2100,     0,     0,     0,     0,     0,     0,  2101,     0,     0,
       0,  4316,     0,  2282,     0,     0,     0,     0,  2102,   798,
     799,   800,  2103,  2104,  2105,     0,     0,     0,   801,     0,
     802,     0,     0,     0,     0,     0,     0,   509,  2283,  2106,
    2107,   803,   804,   805,     0,  2108,  2109,     0,  2110,     0,
     806,  2256,     0,   510,     0,  2111,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2284,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2257,     0,     0,  2258,
    2259,  2260,  2261,  2262,     0,  2263,  2264,     0,     0,     0,
       0,     0,     0,  4317,     0,     0,  2265,  4318,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3107,     0,     0,
       0,     0,     0,     0,     0,     0,  1160, -3107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   808,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2285,     0,     0, -3107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4319,     0,   809,
       0,     0,  2266,     0,  2267,  2268,  2147,  2269,  2270,  2271,
    2272,  2273,  2274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3107,     0,     0,     0,     0,     0,     0,     0,     0,
    4320,     0,     0,     0,     0, -3107,     0,     0,     0,     0,
       0,   511,     0,     0,     0,     0,     0, -2959,     0,  2287,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2275,  2288, -3107,     0,     0, -3107,
    2289,     0,     0,     0,     0,     0,  4321,     0,     0,     0,
       0,     0,  4430,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,   810,  2290,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3107,     0,     0,     0,  2256,     0,     0,
   -3107,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2257,     0,     0,  2258,  2259,  2260,  2261,  2262,
       0,  2263,  2264,     0,     0,     0, -3107,     0,     0,     0,
       0,     0,  2265,     0,   512,     0,     0,     0,     0,     0,
       0,     0, -3107,     0,     0,     0,  2276,  2277,  2278,  2279,
    2280,     0,     0,  2155,  2281,     0,     0,     0,     0,   811,
     812,     0,     0,     0,     0,     0, -2959, -2959,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2293,     0,  2294,  2295,  2296,  2282,
   -3107,     0,     0, -3107,     0,     0,  4322,     0,  2266,     0,
    2267,  2268,  2147,  2269,  2270,  2271,  2272,  2273,  2274,     0,
       0,   513,     0,     0,  2283,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4323,     0,     0,
     814,    52,     0,     0,     0,     0, -3107,     0,     0,     0,
       0,  2284,     0,     0,     0,     0,     0,     0,     0, -3107,
    4431, -3107, -3107, -3080,     0,     0,   815,     0,     0,     0,
       0,     0,     0,     0,   816,  4324,     0,     0,     0,     0,
    2275, -3107,     0,     0,     0,     0, -3107,     0,     0,     0,
       0,     0,     0,     0, -3107,     0,     0,     0,     0,   817,
       0,     0,     0,     0,     0,   186,  4325,     0,     0,     0,
       0,     0,     0,     0,     0,  2298,  2299,  2300,     0,   514,
       0,     0,     0,     0, -3107,     0,     0,     0,     0,     0,
    2285,  2301,     0,     0,     0,     0, -3107,     0,     0,     0,
       0,     0,     0,     0,     0,  2250,     0,     0,     0,  4326,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3107,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2286,     0,     0, -2961,
   -3107,     0,  2276,  2277,  2278,  2279,  2280,     0,     0,  2155,
    2281,     0,     0,     0,     0,  2287,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2288,     0,     0,     0,     0,  2289,     0,     0,     0,
       0,     0,     0,     0, -3107,  2282,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3107,     0,     0,  2290,
       0,     0,     0, -3107,     0,     0,     0,     0,     0,     0,
    2283,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    52,     0,     0,
    2291,     0,     0,     0,     0,     0,     0,  2284,     0,     0,
       0,     0,   480,     0,     0,     0,     0,     0,     0, -3080,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4003,     0,     0,     0,     0,  4004,  4005,  4006,  4007,     0,
       0,     0,  4008,  2258,  2259,  2260,  2261,  2262,     0,  2263,
    2264,     0,     0,  2292,     0,     0,     0,   789,     0,     0,
    4009,  4010,     0,   790,   791,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   793,
    4011,     0,     0,     0,     0,     0,  2285,     0,     0,     0,
    2293,     0,  2294,  2295,  2296,     0,     0,     0,     0,     0,
       0,  4012,     0,     0,     0,     0,     0,     0,  1718,  4013,
       0,     0,  1719,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2266,     0,  2267,  2268,
    2147,  2269,  2270,  2271,  2272,  2273,  2274,  2297,     0,     0,
       0,     0,  2286,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4014,     0,     0,
       0,  2287,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -635,     0,     0,     0,     0,     0,  2288,     0,     0,
       0,     0,  2289,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3080,     0,     0,     0,  2275,     0,
       0,     0,     0,     0,     0,  2290,     0,     0,     0,     0,
       0,  2298,  2299,  2300,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2301,     0,     0,
       0,     0,     0,     0,     0,     0,  2291,     0,     0,     0,
       0,  2250,     0,     0,     0,   794,   795,   796,     0,     0,
    2302,     0,     0,     0,     0,     0,     0,   797,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4015,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   789,     0,     0,     0,   508,     0,   790,   791,  2292,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   793,     0,     0,     0,     0,     0,     0,
    2276,  2277,  2278,  2279,  2280,     0,     0,  2155,  2281,     0,
       0,     0,     0,  4016,     0,     0,  2293,     0,  2294,  2295,
    2296,  4017,     0,  4018,     0,     0,     0,     0,     0,     0,
   -3009,     0,     0,   798,   799,   800,     0,     0,     0,     0,
    4019,     0,   801,  2282,   802,     0,     0,     0,     0,     0,
       0,   509,     0,  4020,     0,   803,   804,   805,     0,     0,
       0,     0,     0,  2297,   806,     0,     0,   510,  2283,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2284,     0,  -636,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4021,     0,     0,     0,     0,     0,     0,     0,     0,
   -3080,     0,     0,  4022,     0,     0,     0,  4023,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2298,  2299,  2300,
       0,     0,     0,     0,     0,  4024,     0,   808,     0,     0,
       0,     0,     0,  2301,     0,     0,     0,     0,     0,   794,
     795,   796,     0,     0,     0,     0,     0,  2250,     0,     0,
       0,   797,     0,   809,  2285,     0,  2302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4025,
       0,     0,     0,     0,     0,     0,  1746,     0,     0,   508,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   789,     0,     0,     0,     0,     0,   790,   791,     0,
       0,     0,     0,     0,     0,   511,     0,     0,     0,     0,
    4026,     0,  1747,   793,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4027,  2287,
       0,     0,     0,     0,     0,     0,     0,   798,   799,   800,
       0,     0,     0,     0,     0,  2288,   801,     0,   802,     0,
    2289,     0,  1721,  1722,     0,   509,   810,     0,     0,   803,
     804,   805,     0,     0,     0,     0,     0,     0,   806,     0,
       0,   510,     0,  2290,     0,     0,  4028,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4029,     0,     0,     0,     0,     0,   512,     0,
       0,     0,     0,   789,     0,  1752,     0,  1753,  1754,   790,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   808,     0,   811,   812,   793,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   789,     0,
    4030,     0,     0,     0,   790,   791,     0,   809,     0,   794,
     795,   796,     0,     0,     0,     0,     0,     0,     0,     0,
     793,   797,  2703,     0,  2293,     0,  2294,  2295,  2296,     0,
    4031,     0,     0,   831,     0,   513,     0,   832,   833,     0,
       0,     0,  4032,     0,     0,     0,     0,     0,     0,   508,
       0,     0,     0,     0,   814,     0,     0,     0,     0,   511,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4033,     0,     0,     0,     0,
     815,     0,     0,     0,     0,     0,     0,     0,   816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4034,     0,     0,     0,     0,  -944,     0,   798,   799,   800,
     810,  4035,     0,   817,     0,     0,   801,     0,   802,   186,
       0,     0,     0,     0,     0,   509,     0,     0,     0,   803,
     804,   805,     0,   514,     0,     0,     0,     0,   806,     0,
    4036,   510,   789,     0,     0,  2298,  2299,  2300,   790,   791,
       0,   794,   795,   796,     0,     0,     0,     0,     0,     0,
       0,  2301,     0,   797,   793,     0,     0,     0,     0,  4037,
       0,     0,     0,     0,     0,  2250,     0,     0,     0,     0,
       0,     0,   512,     0,     0,     0,   794,   795,   796,     0,
       0,   508,     0,     0,     0,     0,     0,     0,   797,     0,
       0,     0,     0,     0,     0,     0,     0,   811,   812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2885,     0,
       0,   808,     0,     0,     0,     0,   508,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   809,     0,   798,
     799,   800,     0,     0,     0,     0,     0,   831,   801,   513,
     802,   832,   833,     0,     0,     0,     0,   509,     0,     0,
       0,   803,   804,   805,     0,     0,     0,     0,   814,     0,
     806,     0,     0,   510,   798,   799,   800,     0,     0,     0,
       0,     0,     0,   801,     0,   802,     0,     0,     0,   511,
       0,     0,   509,     0,   815,     0,   803,   804,   805,     0,
       0,     0,   816,     0,     0,   806,     0,     0,   510,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     794,   795,   796,     0,     0,     0,     0,   817,     0,     0,
       0,     0,   797,   186,     0,     0,     0,     0,     0,     0,
     810,     0,     0,     0,     0,     0,     0,   514,     0,     0,
       0,     0,     0,   808,     0,     0,     0,     0,     0,     0,
     508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   809,
       0,     0,     0,     0,     0,     0,     0,     0,   808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   512,     0,   809,     0,     0,     0,   798,   799,
     800,     0,     0,     0,     0,     0,     0,   801,     0,   802,
       0,   511,     0,     0,     0,     0,   509,   811,   812,     0,
     803,   804,   805,     0,     0,     0,     0,     0,     0,   806,
       0,     0,   510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   511,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2906,     0,     0,     0,
       0,     0,   810,     0,     0,     0,     0,   831,     0,   513,
       0,   832,   833,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   814,     0,
       0,     0,     0,     0,     0,     0,     0,   810,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   808,     0,   815,     0,     0,     0,     0,     0,
       0,     0,   816,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   512,     0,     0,     0,   809,     0,
       0,     0,     0,     0,     0,     0,     0,   817,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,     0,   811,
     812,     0,     0,     0,     0,     0,     0,   514,     0,   512,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     511,     0,     0,     0,   811,   812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   831,
       0,   513,     0,   832,   833,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   810,     0,     0,     0,     0,   513,     0,   832,     0,
       0,     0,     0,     0,     0,     0,   815,     0,     0,     0,
       0,     0,     0,     0,   816,   814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   817,
       0,   815,     0,     0,     0,   186,     0,     0,     0,   816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   514,
       0,     0,     0,   512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   817,     0,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,     0,     0,   811,   812,
       0,     0,     0,     0,   514,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     513,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   815,     0,     0,     0,     0,
       0,     0,     0,   816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   817,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   514
};

static const yytype_int16 yycheck[] =
{
     151,    36,   507,   180,   240,   643,   701,  1174,   713,   714,
     715,  1169,   137,   718,   139,   675,  1637,   681,  1505,   144,
     987,  2137,    66,   648,   283,   788,  1720,  1097,    72,  1099,
    1100,  1725,  1102,  1103,    69,    70,    71,   638,  1037,   174,
     137,    76,   139,   630,  1892,  2477,   784,   144,  2432,  1118,
    1622,  1013,  1028,   874,  1902,   650,  2250,   212,  1288,   184,
    2492,   652,  1693,   658,  1632,  1194,   664,   631,   880,  3147,
     813,   727,  2729,  2332,   661,   731,   732,   643,   734,   735,
    1863,   737,   738,  2445,   682,   120,   681,   184,  1190,  1650,
     658,  2177,  2209,  2455,  1932,  2134,  1891,  2351,  1529,   134,
    1202,   136,  2795,   866,  2358,   140,   141,  2361,  2362,  3398,
     874,     0,   823,   681,     1,   150,   151,  1912,   705,  2437,
    2438,   630,     1,    14,   159,  2443,  2444,    25,  2446,     1,
     841,   166,   698,     0,  2818,    77,  2654,   728,   729,  2333,
    2334,  2825,   733,    56,  1927,   736,    16,   182,    16,    39,
     801,   802,  1266,    16,    16,    16,    16,  1286,   809,  2360,
     257,   194,   206,    16,    55,   200,   203,     1,    43,   109,
       1,   215,  2993,    83,    31,     1,    25,   136,    83,   214,
     155,  2871,  1296,   107,    31,    41,   221,   226,   207,   254,
    1002,  1779,    42,    38,   229,    83,  1770,   109,  1174,  1787,
     851,    42,  2396,   270,    30,    16,   109,   156,   972,    11,
     225,   291,  1033,  1560,   118,   813,   281,  2566,   136,  1040,
      43,    11,   316,   316,   225,   121,    62,    11,   263,   307,
    2548,   169,   170,  2551,   240,   316,   823,  1273,   160,   239,
    2558,   189,   240,  2561,   831,   832,   833,   255,  3569,   293,
     294,   156,   189,  3703,   841,   240,    96,  2612,   255,   954,
     249,   163,   291,  3717,   409,  1532,   227,   772,   280,  1033,
     291,   455,   480,    13,   455,   958,  2708,  2709,  2208,   277,
     455,   279,   169,   847,   197,   119,   390,   409,   430,   458,
     421,   409,    16,   336,    11,   390,   231,   109,   109,   421,
     303,  3287,   237,  1046,   431,  2601,   384,   409,    85,   487,
     513,   431,   298,   353,  1669,    47,   594,   230,  2726,    31,
      56,   417,   543,   832,   437,   231,   160,   161,    38,   349,
     588,   237,   569,    83,   420,   409,   487,   903,   228,    75,
     270,   484,    11,   350,   203,   940,  2129,   650,   447,   119,
     285,   590,   463,   336,  1049,   447,   544,   952,   353,   204,
      83,   250,    42,   168,   239,   108,   409,   256,  2622,   112,
    2953,   336,   558,    16,   304,   305,    38,   463,   455,   285,
    2963,   226,    41,   250,    16,  3706,   336,   455,  1517,   256,
     160,   161,  3569,   335,  3479,   739,   197,   744,   634,  3933,
     987,   712,   661,    11,   640,  3950,   455,  2725,   739,   453,
     101,  3712,   398,   739,    11,   823,   239,  2456,   455,  1157,
     353,  1242,  4278,   823,  3112,  1163,  1013,   513,  1023,  3915,
     416,   466,   467,   750,   409,  1030,   823,   673,   463,   109,
     676,    84,   864,  2226,    16,   300,    14,   683,  1046,  1649,
      14,   486,  1039,   316,   398,  1023,   822,  1487,   493,   193,
     530,   350,    57,   122,  1175,   827,   398,   126,   704,    11,
     832,   893,   416,   207,   513,  3163,   156,   521,   280,   682,
    1510,   351,  1611,   350,   154,  1685,  2870,    55,   513,   379,
     274,    55,   562,    16,   204,   384,   455,   386,   290,   354,
     811,  3987,   136,   820,   249,   913,  3807,   318,  4364,  3202,
    3194,   858,   541,   913,   858,   136,   827,   384,   349,   386,
     354,   832,  1233,  4068,  4058,  3209,   913,   858,   419,  3706,
    1039,   136,   858,   498,   631,  1273,   109,   109,  2655,   616,
     906,   638,   204,  3233,  2660,  3630,   136,   614,   616,   487,
     490,  2805,   409,   650,   651,   235,   225,   745,   816,   169,
     136,   658,   409,   295,   174,   455,   136,   664,   458,   108,
     756,   136,   715,   112,   569,   409,   559,   379,   675,   690,
     677,   471,   679,   569,   681,   682,   889,   455,   825,   379,
    1177,  1178,  1179,  1194,   614,   379,   455,  1184,  1185,  1186,
    1187,    16,   744,  1190,   409,   704,   757,   202,   615,   830,
     707,   501,   704,  1200,   450,  1202,  1203,   786,   353,  1689,
     431,   717,  1209,  1210,  1211,  1212,  1213,   863,   455,   232,
    2948,   744,  2987,  1702,   912,  2990,   814,  1224,   678,   409,
      23,   377,   878,   427,   446,   742,   448,    23,   388,   389,
    2222,   513,  1239,   455,  1616,   379,   446,  1244,   448,    23,
    2015,    30,   446,   353,   448,   455,  1291,   493,   606,   471,
     812,   455,   633,   912,  3082,  1184,  1185,  1186,    23,   289,
     420,   471,   405,   393,   614,  1286,   205,   471,   405,   388,
     437,  1200,   766,    18,   630,  2991,  1262,   409,   102,   435,
     804,   650,   820,   487,   912,   708,  3692,   315,  1837,   912,
     379,   455,   881,  1815,   559,   842,   813,   819,   474,   784,
    2503,   420,   842,   463,   297,   820,   615,  3420,   987,   913,
    1239,   455,   913,   469,  1546,  1244,   379,   480,   913,   629,
     650,   473,   576,   434,  2582,   650,   318,   471,   615,   302,
     847,   591,  4202,  1317,   544,    80,   108,  2796,  2688,   661,
     112,  1524,   650,   282,   463,  1586,   319,   728,   913,   121,
    4224,   379,   869,   513,   636,   577,   761,   446,  1489,   448,
    2411,   912,   379,   614,  3468,  2132,   455,   577,   447,  2350,
     678,   913,  3482,   577,   437,   438,  4117,   630,   575,  1482,
     865,   830,   471,  3321,   722,   638,   576,   379,   820,   830,
      85,   819,   455,   819,   513,   532,   814,   650,   904,   913,
     913,  1532,   819,   396,  1786,   658,   421,   629,   471,   488,
     819,   727,   913,   913,   646,   913,   572,   379,   446,   629,
     448,   558,   668,   940,  1500,   629,   913,   455,   681,   446,
     865,   448,  1888,   108,    48,   952,   379,   112,   455,   431,
    1974,   809,   752,   471,   865,   769,  2133,   757,   758,   819,
     913,   614,   809,   912,   471,   701,   913,  2465,   927,   912,
     913,   513,   815,   455,   752,  2459,   211,   952,   744,  2236,
     987,   793,   834,   912,  3243,   831,   832,   833,   816,   471,
     650,  3585,  3586,  3486,   446,   629,   448,   913,   577,  1885,
    1007,   814,   912,   455,  1501,   827,  1517,   821,   893,  1514,
     832,   757,   987,  1686,  1687,  3280,  1023,   913,   678,   471,
     819,   819,   455,  1030,    16,  1112,   676,   596,   597,  3623,
     889,   480,  1093,  3633,  1095,   681,  1514,  1098,   471,  1046,
     752,   883,   819,   866,   913,   745,  1107,   806,  3159,   883,
     629,  3000,   752,   820,   379,  1552,  1091,  1092,   752,   577,
     912,  1148,  1037,   716,   914,   913,  1101,  3798,   913,   889,
     577,   831,  1577,   913,   889,   819,   629,   792,   819,   911,
     831,   913,   769,   819,  1091,  1092,   687,   744,   831,   832,
     833,   889,   803,   635,  1101,   867,   912,   913,   906,  1245,
    1611,   336,  1599,   814,  1835,   906,  1672,  1673,   820,   455,
     804,   629,  1678,  3541,   913,  1681,   913,   829,   752,  1616,
     434,   842,   629,  3726,   913,   577,   869,   927,  3695,   829,
     455,   913,  3081,   913,  3083,   829,   913,  1698,   923,   819,
     913,   987,   913,   913,  1089,  1232,   471,   629,   920,   927,
     913,  1158,  1726,  4141,  3754,  2179,   913,   912,  1831,   819,
      42,  1835,  4361,   455,   819,   614,   819,   913,   912,  2927,
    2928,  2929,  2930,   752,  2515,  1828,   913,   629,   722,   912,
    1599,  4169,  1157,  1804,    41,   705,   831,  1194,  1163,  2882,
     923,   722,    44,  1039,  3143,   829,   629,   940,   433,   752,
     240,   913,   829,  1148,   232,   498,   908,   722,   854,   952,
     455,   913,   498,   913,   493,   927,  1161,   730,   480,   913,
    3814,  2969,   722,   728,   498,  3792,   455,   927,   463,   889,
     743,   831,   912,   927,   752,   814,   722,   700,   280,   474,
    1888,   455,   722,   498,   513,   752,   912,   722,   232,    23,
     829,   906,  1227,  2731,   904,   912,   455,  2962,  2135,   913,
     913,   186,   912,   420,   138,   122,   379,   716,    41,   126,
     752,  2964,   816,  2966,   156,    80,   829,    44,   513,  1286,
    1023,     1,  1257,   827,   336,   816,   865,  1030,   832,  1786,
     530,   199,  2774,   927,  3321,   904,  1039,  3466,  1273,   868,
     752,   816,   487,   197,   629,   455,   463,   814,   442,   240,
    1317,   829,   226,  3114,  2186,   480,   816,  3010,  1815,   752,
    1828,   379,   829,   455,   616,  3321,  1837,   430,   447,    23,
     816,  1177,  1178,  1179,   913,   818,   816,   766,  1184,  1185,
    1186,   816,   455,   912,   827,   828,   558,   829,   927,   832,
    2821,   240,   614,   235,  1200,   784,   513,  1203,   471,   455,
     842,  1422,   455,  1209,  1210,  1211,  1212,  1213,  2647,   455,
     819,    37,   801,   687,   927,   168,     0,   829,  1852,  3946,
    3073,   558,  3075,  1552,   352,   282,  2007,   379,   851,   668,
     575,   227,   563,  1239,   912,   913,   829,   354,  1244,   503,
     504,   505,  4390,  1969,  3918,   818,   913,   434,   739,   927,
    2434,    19,   320,   471,   442,   828,     0,   390,  2398,  2399,
     927,   194,   701,   886,  2404,  2405,   300,   752,   891,   122,
     197,   913,   667,   126,  1177,  1178,  1179,  2416,   455,   455,
     291,  1184,  1185,  1186,   484,   927,  1947,   682,   455,   614,
    3619,  1194,   409,  3622,   716,   408,   229,  1200,   442,   353,
    1203,   913,   219,   455,  3549,   727,  1209,  1210,  1211,  1212,
    1213,   487,  2496,  2497,  1975,   927,   362,   363,  2490,   471,
     913,   266,     1,  1984,   300,   301,  2968,    38,   530,   383,
     455,     1,   713,   647,   927,   512,  1239,  3255,   540,  3918,
     463,  1244,   398,   111,   829,  2529,  2530,  1514,  3918,    19,
    1517,  2008,  2133,  3918,  1579,   619,   629,   425,  2191,   292,
     416,   675,   227,   564,   463,  1500,   153,   858,  2567,  1675,
    2569,  1677,   632,  1679,  1680,   576,  1682,  1683,   354,    58,
      59,    60,    61,  1286,    63,   594,  3918,   647,   513,  2025,
     513,   716,   240,   484,   440,   441,  3720,  2581,   883,   281,
     576,   169,   336,   336,   172,  2589,   174,   913,   893,   385,
    1577,  2192,  2225,   481,   513,   390,   593,  3746,  3747,   764,
     110,   354,   555,  3384,   769,   704,   593,   195,   913,   542,
     447,  2630,  1567,   518,   409,   300,   730,   390,   819,   513,
     690,   111,   927,   455,  1611,   657,    76,   291,   168,  2282,
     485,  3883,  2636,   437,   582,  2189,   379,  1592,  3096,   455,
    3098,   913,  2127,  2128,   143,   144,  2650,  2651,  2537,   690,
    2352,   351,   529,   819,  4148,  1670,   821,   629,  2135,   752,
    3725,   744,   336,   912,  3670,  1590,   528,     1,   537,  2127,
     120,   913,  2632,   204,   819,  1501,  1631,   379,   463,   169,
     687,   409,   172,  1670,   174,  2139,     0,   549,   913,   474,
    2291,   825,  2711,   569,  3215,   291,   352,   912,   913,   345,
     240,   289,   927,   393,   913,   195,   406,   927,   455,  2186,
     541,   484,   455,  1638,   752,   274,   349,  1642,  1643,   913,
    1645,   913,   730,  1648,  1649,   137,  1651,   492,   471,   812,
     649,  1665,   278,   927,   913,   743,   186,  2225,   593,  1726,
    2217,  2218,    76,   816,   498,   549,   766,   649,   927,  4148,
    2602,   835,   836,   455,   166,  3493,   913,   447,  4148,   596,
     597,   105,   106,  4148,   784,   849,   730,   904,  3027,   471,
     624,   183,   184,  1599,   447,   912,   796,   125,  1501,   743,
     752,   801,   555,   913,   132,    20,   120,   455,    23,    24,
    2501,  1514,   558,   647,  1517,  2915,  4148,   927,   820,   289,
     390,   913,  1869,  1728,   678,  3267,   379,   906,  1849,  1734,
    4304,  3484,  1737,   706,  1739,   927,   160,   390,  2217,  2218,
     384,   675,   386,  3496,  3497,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   927,   832,   544,   913,   345,   501,
     913,  1828,   912,   509,  2472,   832,  1833,   913,  2852,   193,
    1837,   911,   186,   913,  1577,   766,  2402,   829,   746,  2725,
    4134,   614,   408,   207,   295,  1852,  2718,   298,  2828,  4143,
     458,   912,  2353,   784,    36,  3548,  1599,   541,   503,   504,
    2839,  2840,   455,   912,   913,   796,   629,   299,  1611,   927,
     801,  2445,   913,   913,  2495,   507,   624,  2451,   471,  2453,
     493,  2455,  1857,   240,   819,  4304,  4123,   744,    14,  3993,
    3994,   883,  4061,  4062,  4304,   298,   739,   913,  4126,  4304,
     796,   893,   455,   596,   597,  4133,   582,   629,   555,  4137,
     927,   927,  4140,  1888,   229,   601,   250,   856,   812,  1864,
    1927,   913,   256,   556,   484,   541,   559,   580,   455,    55,
     640,   584,  4304,   841,   856,   927,   455,   753,   824,   409,
     826,   549,   455,   379,   654,   553,   300,   398,   458,   912,
    3658,   825,   827,   423,  1899,   565,   850,   832,   744,  2020,
    1006,   614,   318,  1908,   611,   416,  2135,   712,  4205,   499,
    3809,   501,   538,   912,   619,   445,   542,   292,    16,   671,
    2601,  2478,   674,  2480,   616,  2559,  2560,  2535,   680,   752,
      28,  3699,   819,  2490,    16,   398,   509,   463,    20,   512,
     354,    23,    24,   916,   651,   628,  2511,  2504,  3032,  3033,
    4114,  4115,   168,   416,   282,   858,   350,   745,   640,   455,
     219,  3045,  3046,   291,  2933,  1071,    14,   640,   350,  3868,
     752,  2528,   464,   646,  4262,   471,   629,  4265,   379,   549,
    3064,  3065,  2453,   475,   819,   283,    84,   513,  4367,  4391,
     384,   408,   386,   291,  2675,   409,  2567,   665,  2569,  2478,
     713,  2480,   384,   576,   386,   421,   829,    55,   628,   423,
     409,   427,   858,  3781,   756,   594,   629,   759,   760,   447,
     593,   335,   827,   451,   240,  2504,   811,   832,   827,   250,
    1833,   445,   822,   832,  1837,  4414,  4415,   705,   617,   827,
    2451,   106,  2453,   833,   832,  2602,   831,   829,   335,  2528,
     125,  4208,  4209,  2610,   455,   369,   455,   132,   569,  2630,
    2127,  2128,  2129,  2628,  2659,   747,   748,   750,  2189,   256,
     471,     7,  2139,  2198,  2199,  2200,  2201,  2202,  2203,  2204,
    2205,   197,   369,   751,  2765,   753,   699,   335,  2559,  2560,
     913,   774,   775,   776,   822,   160,  2131,   409,   816,   752,
    2135,    16,  4413,   379,   927,   833,   569,  2228,   817,   827,
     640,   603,   186,    28,   832,   645,   784,    53,   827,   283,
     537,   369,  2189,   832,  1927,   542,   399,   291,   193,    65,
     750,   913,   662,   629,   664,   705,  4447,   713,   890,   752,
    2711,  2698,   207,  2178,   849,   927,   766,   640,  2559,  2560,
     642,   691,   576,   646,   774,   775,   776,   556,  2225,  2226,
     559,  2718,   586,   587,   784,  2286,   834,   659,   819,    84,
    4373,  2879,  2729,  3715,   110,  4378,   829,  3114,   271,   455,
     640,   801,   458,   498,   499,  2220,   646,  4344,  2255,  3273,
     219,   804,  4362,  4363,  4358,   471,  4014,   133,  2233,   297,
    2406,   823,  2408,  4360,  2410,  4023,   640,  2940,   817,   819,
    2331,   811,   646,  4031,   784,   815,   610,  2338,   827,  2698,
     447,   615,  4392,   832,   451,   501,   640,   713,   629,  2135,
     384,   645,   386,   615,   549,   550,  1807,  2871,   662,  1810,
    4410,   539,  2363,   541,   336,   913,   338,  1818,   662,   819,
     664,  1822,  3292,   539,   190,   541,   752,  2865,  1829,   832,
    4424,   685,   686,   447,   834,   318,   306,   451,   484,   766,
    2337,    91,    92,    93,   927,  3359,  3360,  2479,  2507,  2481,
    2418,   379,   335,  4369,  2422,  2487,  2488,  2489,   831,   819,
     833,   816,  2494,   913,  4464,   738,  2301,   816,   738,  2304,
     913,   819,   827,  2505,  2506,   837,   838,   832,   827,   819,
    2991,  2217,  2218,   832,   927,   819,   369,  3050,  3051,  1177,
    1178,  1179,    32,    33,  2127,  2128,  2129,  3918,   819,  2364,
    2451,  2345,  2453,   829,   913,  2340,   272,   443,   444,   437,
     438,   547,   548,   913,   390,  1203,  4249,    37,  4012,    24,
      25,   752,   488,   629,  2359,  1209,  1210,   455,  4022,   889,
    1211,  1212,  1213,  2368,  2369,  4459,   404,  4461,   819,  4463,
    2437,  2438,  2601,   471,   427,  2970,  2443,  2444,  2445,  2446,
    2460,  2461,   297,   713,  2451,   913,  2453,   819,  2455,   209,
     210,  2486,   212,   819,  4297,  4298,   449,  3023,  1185,  1186,
    4303,   134,   692,  4306,   913,   819,   342,  4310,  4311,  2414,
    2415,   509,   628,   913,  2217,  2218,   498,   499,   913,  2486,
    1484,  1485,  1486,  2226,  2985,   455,   918,   919,   829,   819,
     819,   927,   819,  2538,   219,   819,  2503,   455,  2559,  2560,
    3377,   455,   842,   913,  2511,  2450,   819,  3384,   869,   870,
     871,   872,  2457,   624,   869,   870,   871,   872,   869,   870,
     871,   872,     7,   915,   379,   819,   564,   549,   550,  1279,
    1280,  1281,  1282,   725,   744,   889,   752,  3517,   112,   121,
     913,  2548,   455,   409,  2551,  2714,   819,   423,   844,   336,
     724,  2558,  2559,  2560,  2561,  2260,  2261,  2262,  2263,   913,
    2567,   608,  2569,   713,   139,   562,   819,  2736,    53,   559,
     806,   590,   455,   727,   406,   819,  3485,   819,   454,   614,
      65,   194,   437,   438,   815,   138,   927,   912,    14,   355,
     814,   629,   913,   295,   750,   913,   913,   831,   819,   713,
     455,   462,   819,   442,   555,   823,   290,    32,   819,  3157,
     766,  2780,   913,   455,   488,  3288,   471,  4148,   774,   775,
     776,  2628,   241,  2630,   831,   110,   484,   345,   784,  3653,
    3654,   831,  2478,   831,  2480,   831,   852,   831,   398,   399,
     831,  2616,   831,   242,   831,   801,   831,   831,   133,   297,
     831,   365,   831,   831,   814,   243,   246,   244,  2504,  3233,
     691,   640,   422,   161,   796,   796,   361,    78,   884,   885,
     247,   912,  2647,   814,   455,   248,   552,   249,   182,   270,
    2826,  2827,  2528,  2829,  2830,  2831,   803,   447,   831,   253,
      83,   814,   254,   913,   804,   258,   257,   291,   345,   259,
     893,   913,   260,   345,  2711,   190,   261,   487,  3381,   564,
     609,   927,   472,  4317,   752,    42,   262,   405,  2725,   831,
     263,   345,   264,   761,   265,   201,   266,   819,   713,   453,
     658,   819,  3756,  3757,  3758,  2478,   819,  2480,   154,   336,
     795,   913,   678,   809,   168,  4349,   814,   913,  2723,   913,
     626,  4148,   814,  3264,   630,  3266,   913,   353,  2819,   396,
    2503,  2504,   612,   457,   455,   488,   676,   911,  2511,   541,
     291,  3750,  3751,  4304,   629,   868,   911,   906,   816,   455,
     818,   236,   315,   661,   252,  2528,   345,   272,   405,   827,
     828,   829,  2737,   831,   832,   733,   814,   367,   806,   811,
    3370,   800,   405,   405,   240,   912,    83,   814,   814,   569,
    2871,  2818,   814,   201,   345,   345,  2761,    83,  2825,   405,
     267,   345,  2991,   819,  2567,   713,  2569,   662,   889,   155,
      31,   707,   819,   555,   646,   453,   819,    76,   547,   108,
      14,   421,   602,   744,   136,   926,   606,   607,   925,   766,
    3918,   766,  2698,  2798,   421,   547,  2801,   342,  2803,  2804,
     495,   816,   353,  2808,  2871,  2810,  2811,  2812,  2813,  3015,
     816,   816,   816,   633,   816,  2820,   816,  3901,  3902,  3500,
     678,   816,   816,   814,   814,  2628,    37,  2630,   683,   927,
    2736,   767,  3871,   657,   421,   353,   353,   752,  2843,   455,
     567,   883,   927,   251,   661,   814,    83,   226,  3482,   353,
     390,   819,   906,   556,   628,   906,   630,   555,   766,   633,
     353,   814,    16,    49,    50,    51,    52,   641,  3805,   643,
      56,    13,   678,  2878,  2780,   239,   713,   819,   423,   704,
     889,  2948,   354,  3112,  3923,  3114,   660,   661,    74,    75,
     906,   665,   687,   458,    37,  2698,   409,  2964,   672,  2966,
     354,   816,   108,   818,   893,   913,   728,   766,  2711,   454,
     463,   847,   827,   828,   829,   689,   831,   832,   727,    57,
     913,   455,   816,   816,   745,   353,   408,   544,   513,   703,
     542,   705,   706,   240,  3163,    25,   806,   123,   236,   889,
     889,   336,    83,  3010,   336,   168,   727,    14,   345,   537,
     240,   594,   661,   819,  3580,  3581,   564,   202,   793,   644,
     498,   888,    95,   819,   713,   927,    90,   806,   853,   905,
     655,   814,    37,   913,   336,   795,   162,  3534,   725,   555,
    3015,   666,   667,   814,  3665,   451,   728,   597,    25,   562,
     345,   744,  3027,   196,   353,   353,   212,   816,   656,  3633,
      14,   656,   186,    55,   495,  3211,   207,   552,  3075,   825,
     565,   567,   927,   560,   255,   421,   463,   186,   792,   518,
    4148,   463,   447,  4063,   543,  3146,   830,   876,  3703,  3762,
     613,   819,   456,   806,   345,   811,  3701,   913,   744,   455,
     109,   806,   913,  3164,   819,   392,   205,    83,  3115,   812,
    3171,   197,   783,   610,   513,   513,  3091,   831,   832,   833,
    3207,    83,   463,   463,  3069,   463,   278,   610,   538,  3216,
    3217,  3166,   203,   819,   814,   913,   203,   766,   345,    13,
    3094,   626,   806,   857,   498,   630,    23,   610,   568,   683,
    3185,   496,  3213,   864,   822,   281,  3191,  3218,   913,  3166,
     729,  3196,  3197,   634,   396,   335,   583,   480,  3665,  3204,
     884,  3206,  3233,   814,   541,  3182,  3183,   291,  3185,   614,
    3754,   194,   814,  3856,  3191,   819,    41,  3194,   393,  3196,
    3197,   690,   474,  3339,  3340,   820,   663,  3204,  3695,  3206,
     744,   823,  3209,   819,   203,   541,   850,   756,  3377,   819,
     559,   337,   196,   497,   823,  3384,   226,   783,   498,    23,
     610,  2964,   707,  2966,   541,  3791,  3233,  4304,   782,   291,
     819,   421,   421,  3854,    20,    21,    22,   205,   437,   555,
     819,  3186,   554,   957,   906,   421,   421,   168,   421,   437,
     421,   377,   354,   967,   968,   437,   119,  3264,   796,  3266,
    3205,   230,  3207,   108,   354,   369,  3112,  3010,  3114,   394,
     564,   345,  3893,   987,  3219,   442,    83,   508,   770,   576,
    3449,   564,   767,   819,    11,   576,   576,  3294,    48,    45,
     113,   916,   528,   221,    83,  3792,   196,   272,   278,  1013,
      90,   296,   751,   202,  1128,   198,  3816,   932,  3874,  3883,
    3617,   477,  2015,  4058,  2809,  3596,  3737,  3163,  2817,   459,
    3594,  2831,  3183,  3944,  3976,  1039,  3912,   113,  3987,  2133,
     716,  1045,  3075,  2304,  3309,  1638,  3397,  4428,  2770,  3719,
    3813,  2016,  3868,   469,  2780,  4122,  4249,  4372,  4377,  3706,
    4148,   976,  3864,   974,  1068,   665,  4209,  1482,  1072,  1073,
    4015,  4015,   847,  3370,  4022,  4050,  1708,  3269,  2844,   233,
    3516,  1157,   909,  3939,  2870,  3320,  2879,  1169,  1163,  1843,
    1745,  2509,   847,  3418,  3239,  3267,  3761,  3760,   514,  1227,
     645,   857,   903,  1258,  3369,  1888,  3431,  1915,  2933,    41,
     915,  2536,   665,  1294,  1291,  2969,  2582,   936,  1967,  2980,
    2978,  3418,  1037,  1320,  1493,  3476,  2610,  2005,  2996,  1044,
     905,  3482,  2995,  1048,  3431,  3511,  3461,  3650,  1498,  3309,
    3021,   982,  3688,  2135,  2170,    77,  2647,    79,  3027,  3036,
    3035,  2723,  3449,  1565,  3419,  2662,   572,  2206,   682,  3946,
    1021,   359,   364,  2701,  3461,  1023,  1170,  1171,  3403,  1604,
     102,  3468,  3549,  1177,  1178,  1179,  3079,  2233,  2233,  3893,
    1184,  1185,  1186,  1187,  3686,  3482,  1190,  2184,  2169,  3560,
     122,  3647,  3947,  4073,   126,  3952,  1200,  2433,  1202,  1203,
    1630,  2431,  3955,  1269,   280,  1209,  1210,  1211,  1212,  1213,
    1268,  3905,  3477,  3904,  3770,  3657,  3656,  2500,  2499,  3084,
    1224,  3068,  1226,  3659,  3540,  3067,  2534,  3578,  3463,  3363,
    4017,  3264,  3583,  3266,  3085,  1239,  3364,  2533,   681,   854,
    1244,  3377,  1299,  1941,  3595,  1308,  2694,  1007,  3384,  2694,
    1967,  2694,  2694,   707,  1221,  3166,  2787,   204,  3500,  2192,
    2007,  2991,  2714,   679,  1224,   681,   682,  4017,  3944,  2413,
     519,   755,  1276,  4167,   816,  1639,  2208,  3734,  2777,  1194,
    3515,  2525,  3633,  3074,  3349,   701,   362,   363,  3585,  3586,
     706,  3682,  4318,  2949,  2328,  3560,  3483,  4202,  3598,  4198,
    3597,   786,  4349,  4405,   290,  3012,  3603,   533,  2213,  3173,
    1907,  4198,  1167,  3772,  3930,  1647,  2407,  3203,  4364,    -1,
      -1,    -1,    -1,  3700,    -1,    -1,  3623,    -1,   744,    -1,
      -1,  3566,    -1,    -1,    -1,    -1,  3633,    -1,    -1,    -1,
     756,    -1,    -1,    -1,    -1,    -1,  3805,    -1,    -1,    -1,
    3615,  3616,  3617,    -1,    -1,    -1,    -1,  1272,    -1,    -1,
    4323,  3658,    -1,    -1,   440,   441,  4204,    -1,    -1,    -1,
    1285,  1286,    -1,    -1,  3609,    -1,    -1,    -1,    -1,  4217,
      -1,    -1,    -1,    -1,    -1,  3620,  3621,    -1,  3713,  3714,
    3625,  3626,    -1,  1308,    -1,    -1,    -1,    -1,  3534,    -1,
      -1,    -1,  3699,  3754,    -1,    -1,    -1,    -1,    -1,    34,
      35,  3736,  3737,  3849,  3649,    -1,  3713,  3714,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3660,    -1,    -1,    -1,    -1,
     506,    -1,    -1,    -1,    -1,   367,    -1,    -1,   854,  3736,
    3737,    -1,    -1,    -1,  4149,    -1,    -1,    -1,    -1,    -1,
    3827,  3828,    -1,    -1,    -1,  3891,  3691,  3754,    -1,    -1,
      -1,    -1,    -1,  3728,   540,    -1,    -1,    -1,    -1,  3734,
      -1,    -1,    -1,   549,  3709,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   558,    -1,  3781,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1501,    -1,    -1,
     125,    -1,   434,    -1,    -1,    -1,    -1,   132,    -1,    -1,
     135,    -1,    -1,    -1,    -1,   447,    -1,  3814,    -1,   451,
      -1,    -1,    -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1552,    -1,
      -1,    -1,    -1,    -1,  3879,    -1,    -1,    -1,  4017,    -1,
    1564,    -1,  1566,    -1,   189,    -1,   191,   192,  3919,    -1,
      -1,    -1,    -1,    -1,  4430,  4362,  4363,  3812,    -1,    -1,
      -1,    -1,  3879,  3818,    -1,    -1,  3883,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1599,  3831,    -1,    -1,  1603,
    3925,    -1,  1517,    -1,    -1,  4392,    -1,    -1,    -1,    -1,
      -1,    -1,  1616,    -1,    -1,    -1,     7,    -1,    -1,    -1,
      -1,    -1,    -1,  4410,    -1,    -1,    -1,    -1,  3925,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
      -1,   276,  3917,    -1,    -1,    -1,    -1,    -1,   283,    -1,
      -1,  3896,    53,   595,   596,   597,   291,  1582,  3933,  3805,
      -1,  3906,    -1,    -1,    65,  4026,    -1,  4464,  1593,    -1,
      -1,    -1,  3917,  3918,    -1,    49,    50,    51,    52,  1604,
      -1,    -1,    56,    -1,    -1,    -1,  1611,    -1,    -1,  3934,
    3935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      74,    75,    -1,    -1,  3949,    -1,    -1,    -1,    -1,   110,
      -1,    -1,    -1,    -1,    -1,    -1,  4162,  3962,    -1,    -1,
    3965,  3966,  3967,  3968,  4085,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   133,    -1,   820,    -1,    -1,    -1,   824,    -1,
     826,    -1,    -1,    -1,    -1,   687,    -1,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,  4116,  1770,    -1,    -1,  4004,
      -1,    -1,    -1,   398,    -1,     7,    -1,    -1,  4013,    -1,
      -1,  4016,  1786,  4134,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,  4143,  4058,    -1,    -1,    -1,    -1,   162,   190,
     732,    -1,  1806,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    53,   447,    -1,    -1,    -1,   451,    -1,    -1,  4126,
      -1,    -1,    -1,    65,    -1,    -1,  4133,    -1,    -1,    -1,
    4137,    -1,    -1,  4140,    -1,    57,    58,    59,    60,    61,
      -1,    63,    64,    -1,    -1,    -1,  4091,  4092,  4093,  4094,
    4095,    -1,   487,  4098,  4099,  4100,  4101,  4102,  4103,  4104,
    4105,  4106,  4107,  4108,    -1,    -1,  4111,    -1,   110,    -1,
     812,   272,    -1,    -1,  4119,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4130,    -1,  4132,  4249,    -1,
      -1,   133,   834,    -1,    -1,    -1,    -1,  4142,    -1,    -1,
      -1,  1915,    -1,  4148,    -1,  1919,    -1,   281,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
      -1,    -1,    -1,   334,    -1,    -1,  4297,  4298,    -1,    -1,
      -1,   342,  4303,    -1,    -1,  4306,    -1,    -1,   190,  4310,
    4311,    -1,  1877,    -1,    -1,  4262,    -1,    -1,  4265,  4320,
      -1,    -1,    -1,   337,    -1,    -1,    -1,    -1,    -1,    -1,
     912,    -1,    -1,    -1,    -1,    -1,  1990,    -1,  1992,  1993,
    1994,    -1,    -1,  4344,    -1,    -1,    -1,    -1,    -1,    -1,
     212,    -1,    -1,    -1,  2008,    -1,    -1,    -1,  2012,  4360,
    2014,    -1,    -1,   377,    -1,    -1,  2020,    -1,    -1,    -1,
      -1,    -1,  4373,    -1,    -1,    -1,  4377,  4378,    -1,    -1,
      -1,    -1,   423,    -1,    -1,    -1,    -1,  4388,    -1,   430,
     272,  4276,  4277,    -1,  4279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4296,    -1,   454,    -1,    -1,  4301,  4302,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   704,
      -1,    -1,    -1,    -1,  4319,    -1,    -1,  4322,    -1,    -1,
    4325,   482,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   334,    -1,    -1,   469,    -1,    -1,    -1,    -1,
     342,    -1,   324,   325,   326,   327,   328,  4468,    -1,   331,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2135,    -1,    -1,  2138,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,
      -1,   630,    -1,    -1,    -1,   367,    -1,    -1,    -1,   638,
      -1,    -1,   787,    -1,   555,    -1,    -1,  2171,    -1,    -1,
      -1,   650,  2176,   798,    -1,    -1,    -1,    -1,    -1,   658,
     392,  2185,  2186,    -1,   809,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,   430,    -1,
      -1,    -1,   681,    84,    -1,    -1,    -1,    -1,   572,    -1,
      -1,    -1,    -1,  2217,  2218,    -1,    -1,    -1,    -1,    -1,
    2224,    -1,   454,    -1,    -1,    -1,  4362,  4363,  2232,  2233,
      -1,    -1,    -1,    -1,    -1,   626,  2240,    -1,    -1,   630,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     482,    -1,    -1,    -1,    -1,   880,  4392,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,    -1,    -1,  4410,    -1,   157,   158,    -1,    -1,
      -1,    -1,  2197,    -1,    -1,    -1,   498,    -1,   913,    -1,
      -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   679,   707,   681,   682,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4464,  4362,
    4363,    -1,    -1,    -1,    -1,    -1,    -1,   701,    -1,    -1,
      -1,    -1,   706,    -1,   823,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   831,   832,   833,    -1,    -1,    -1,    -1,  4392,
      -1,   573,   841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   767,  4410,    -1,    -1,
     744,    -1,   594,    -1,    -1,    -1,    -1,    -1,    -1,   780,
     869,    -1,   756,    -1,   626,    -1,    -1,     1,   630,    -1,
      -1,    -1,    -1,    -1,    -1,   617,    -1,    11,    -1,    -1,
      -1,    -1,    16,   804,    -1,    -1,    20,    21,    22,    -1,
      -1,    -1,    -1,    -1,    28,    29,    -1,    -1,  2432,    -1,
      -1,  4464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2459,   847,   338,   339,   340,
     341,   940,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,    -1,    -1,   952,  2478,   707,  2480,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2490,    -1,    -1,    -1,
     854,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,
    2504,   892,    -1,  2507,    -1,    -1,    -1,    -1,    -1,   113,
      -1,    -1,    -1,    -1,   905,    -1,    -1,    -1,    -1,    -1,
     911,    -1,   913,    -1,  2528,    -1,    -1,    -1,   740,   741,
     742,  2535,    -1,    -1,  1013,   767,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1023,    -1,    -1,   151,   780,    -1,
      -1,  1030,    -1,   157,   158,    -1,   437,   438,   439,    -1,
    1039,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
      -1,    -1,   804,    -1,   455,    -1,    -1,    -1,   459,   460,
     461,    -1,    -1,    -1,  2588,    -1,    -1,   468,    -1,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2602,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2610,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   847,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2634,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   859,   860,   861,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     551,    -1,    -1,   905,    -1,    -1,   280,    -1,    -1,   911,
      -1,   913,    -1,    -1,    -1,    -1,  2690,    -1,    -1,    -1,
      -1,    -1,    -1,   297,  2698,    -1,    -1,    -1,  1177,  1178,
    1179,   913,    -1,    -1,    -1,  1184,  1185,  1186,  1187,    -1,
    2714,  1190,  2627,    -1,  2718,  1194,    -1,    -1,    -1,    -1,
      -1,  1200,    -1,  1202,  1203,  2729,    -1,    -1,    -1,    -1,
    1209,  1210,  1211,  1212,  1213,   339,   340,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   629,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
    1239,    -1,  2677,    -1,    -1,  1244,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2700,  2701,    -1,    -1,    -1,
      -1,    -1,  2707,    -1,    -1,    -1,    -1,  1276,    -1,   680,
      -1,    -1,    -1,    -1,    -1,   409,    -1,  1286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   437,   438,   439,   440,   441,    -1,    -1,
      -1,    -1,   446,    -1,   448,    -1,    16,    -1,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,   460,   461,    -1,    -1,
      -1,  2865,    -1,    -1,   468,    -1,  2870,   471,    -1,    -1,
      -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   777,   778,    -1,    -1,
      -1,    -1,   506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    49,    50,    51,    52,   800,
      -1,    -1,    56,    -1,    -1,    -1,   530,    -1,    -1,    -1,
      -1,    -1,    -1,    16,    -1,    -1,   540,    -1,    -1,   109,
      74,    75,    -1,    -1,    -1,   549,    -1,   551,   829,    -1,
      -1,    -1,    -1,    -1,   558,     1,    -1,    -1,    -1,    -1,
     564,    -1,    -1,    -1,    -1,    11,    -1,   848,    -1,    -1,
      16,    -1,    -1,   577,    20,    21,    22,    -1,    -1,    -1,
      -1,   151,    28,   864,    -1,    -1,    -1,   157,   158,   123,
      -1,    -1,    -1,   874,    -1,   599,    -1,    -1,    -1,    -1,
      -1,   882,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,
    1489,    -1,   893,    -1,    -1,    -1,  2931,  3021,    -1,    -1,
      -1,    -1,  1501,    -1,    -1,   629,   907,    -1,   162,    -1,
      -1,   912,   913,    -1,    -1,  1514,    -1,    -1,  1517,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,   680,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1577,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,  3022,    -1,    -1,
      -1,   157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1599,    -1,   151,    -1,    -1,    -1,    -1,   173,   157,   158,
      -1,    -1,  1611,    -1,    -1,    -1,    -1,  1616,    -1,    -1,
      -1,    -1,    -1,    -1,   173,    -1,    -1,   281,   752,    -1,
      -1,    -1,    -1,  3157,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,
     340,   341,    -1,   777,   778,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   337,    -1,    -1,    -1,    -1,    -1,   379,
      -1,    -1,   816,    -1,   818,    -1,   820,    -1,   822,    -1,
     824,    -1,   826,   827,   828,   829,    -1,   831,   832,   833,
      -1,    -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   377,   848,    -1,    -1,    -1,    -1,  3253,
     296,   297,    -1,    -1,    -1,    -1,   339,   340,   341,    -1,
      -1,   431,    -1,    -1,    -1,    -1,    -1,    -1,   351,   439,
     874,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   882,    -1,
      -1,    -1,  3286,    -1,    -1,   455,    -1,    -1,    -1,   459,
     460,   461,    -1,   339,   340,   341,   379,    -1,   468,    -1,
      -1,   471,    -1,   907,    -1,   351,    -1,  1786,    -1,   913,
     339,   340,   341,    -1,    -1,    -1,   362,   363,    -1,    -1,
      -1,    -1,   351,   927,    -1,    -1,    -1,    -1,    -1,  3244,
    3245,  3246,  3247,   379,    -1,   469,  1815,    -1,    -1,    -1,
      -1,    -1,    -1,  3347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3355,    -1,  3357,  1833,    -1,   439,    -1,  1837,    -1,
      -1,    -1,    -1,   409,    -1,    -1,    -1,  3282,  3283,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,   460,   461,    -1,
      -1,   551,    -1,    -1,    -1,   468,    -1,    -1,   471,    -1,
      -1,   437,   438,   439,   440,   441,    -1,    -1,    -1,    -1,
     446,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,   455,
     439,    -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,
      -1,    -1,   468,    -1,    -1,   471,   455,    -1,    -1,    -1,
     459,   460,   461,    -1,    -1,    -1,  1915,    -1,   572,   468,
      -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,  1927,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   629,
     506,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,  3492,    -1,
      -1,    -1,    -1,    -1,   540,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   549,    -1,   551,    -1,    -1,  3512,  3513,
     680,    -1,   558,    -1,    -1,    -1,    -1,    -1,   564,    -1,
      -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,  2007,  2008,
    3534,   577,    -1,  3537,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   679,   629,   681,   682,    -1,
      -1,    -1,    -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   701,    -1,    -1,
    3574,    -1,   706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   752,   629,    -1,    -1,    -1,    -1,    -1,    -1,
    3505,    -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,   778,    -1,
     744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   756,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3647,    -1,    -1,  3650,    -1,  2127,  2128,
    2129,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   829,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   752,
      -1,    -1,   842,    -1,    -1,    -1,    -1,    -1,   848,    -1,
       6,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3695,    -1,    -1,   777,   778,    -1,    -1,    -1,    -1,
      -1,    27,    -1,    -1,   874,    -1,   752,  2186,    -1,    -1,
      -1,    -1,   882,    -1,    40,    -1,    -1,    -1,    -1,    -1,
     854,    -1,    -1,  3638,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,   907,  2217,  2218,
      -1,    -1,    -1,   913,    -1,    -1,   829,  2226,   777,   778,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,
      -1,    -1,    -1,    -1,  3768,   848,    -1,    -1,    -1,    -1,
     816,    -1,   818,    -1,   820,    -1,    -1,    -1,   824,    -1,
     826,   827,   828,   829,    -1,   831,   832,    -1,  3792,    -1,
      -1,   874,    -1,    -1,    -1,   121,    -1,    -1,    -1,   882,
      -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,
      -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,   874,    -1,
     913,    -1,    -1,    -1,    -1,    -1,   882,  3841,    -1,    -1,
      -1,    -1,  3846,    -1,   927,   874,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   907,    -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,   927,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3898,  3899,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3914,  3915,    -1,    -1,    -1,  3919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,
      16,    -1,  3946,  3947,    20,    21,    22,    -1,  3952,    -1,
      -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3979,    -1,    -1,    -1,    -1,
      -1,    -1,   308,   309,    -1,    -1,  3990,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4002,  2478,
      -1,  2480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2490,    -1,  4017,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2503,  2504,    -1,    -1,    -1,    -1,
    4034,    -1,  2511,  4037,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
    4084,   157,   158,  4087,  4088,  4089,  4090,    -1,  2567,    -1,
    2569,    -1,    -1,  4097,    -1,    -1,    -1,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4110,    -1,    -1,    -1,
      -1,    -1,  4116,    -1,    -1,    -1,    -1,    -1,  4122,  4123,
      -1,   447,    -1,  2602,    -1,    -1,    -1,    -1,    -1,    -1,
    4134,  2610,    -1,    -1,    -1,    41,    -1,   463,    -1,  4143,
      -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,  2628,
      56,  2630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    74,    75,
    4174,  4175,  4176,  4177,  4178,  4179,  4180,  4181,  4182,  4183,
    4184,  4185,  4186,  4187,  4188,  4189,  4190,  4191,  4192,    -1,
      -1,    -1,    11,    -1,    -1,    -1,    -1,    16,    -1,   525,
    4204,  4205,    -1,    -1,   280,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4217,    -1,    -1,   122,   123,    -1,  2698,
     126,   297,    -1,    -1,    -1,    -1,  4230,    -1,    -1,    -1,
      -1,    -1,  2711,    -1,    -1,    -1,    -1,    -1,  4242,  2718,
     566,    -1,    -1,    -1,    -1,  4249,    -1,    -1,   574,    -1,
    2729,    -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,
      -1,    -1,    -1,   339,   340,   341,    -1,    -1,    -1,  4273,
    4274,    -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,  4292,    -1,
      -1,    -1,    -1,  4297,  4298,    -1,    -1,    -1,    -1,  4303,
      -1,  4305,  4306,   379,    -1,    -1,  4310,  4311,    -1,    -1,
      -1,    -1,    -1,    -1,   640,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4326,    -1,    -1,    -1,    -1,    -1,   654,   151,
      -1,    -1,   151,   409,    -1,   157,   158,    -1,   157,   158,
      -1,    -1,    -1,   669,    -1,    -1,  4350,    -1,   167,    -1,
      -1,   173,    -1,    -1,   173,    -1,    -1,    -1,  4362,  4363,
      -1,   437,   438,   439,   440,   441,    -1,    -1,    -1,    -1,
     446,    -1,   448,    -1,    -1,   281,    -1,  4381,    -1,   455,
      -1,    -1,    -1,   459,   460,   461,    -1,    -1,  4392,    -1,
      -1,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,   727,    -1,    -1,    -1,    -1,  4410,   733,  4412,  4413,
      -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   747,  4426,    -1,    -1,    -1,    -1,  4431,    -1,    -1,
     506,   337,    -1,    -1,    -1,    -1,    -1,  4441,  4442,    -1,
     766,    -1,    -1,  4447,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4455,    -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,
    4464,    -1,    -1,    -1,   540,    -1,    -1,    -1,    -1,    -1,
      -1,   377,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
      -1,    -1,   558,    -1,    -1,  2964,    -1,  2966,   564,    -1,
      -1,    -1,    -1,   819,    -1,    -1,    -1,   823,    -1,    -1,
      -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   839,   840,    -1,    -1,   339,   340,   341,
     339,   340,   341,   599,    -1,    -1,    -1,    -1,    -1,   351,
      -1,  3010,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   447,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   629,    -1,    -1,    -1,    -1,    -1,    -1,
     379,    -1,    -1,   469,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   488,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3075,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   437,   438,   439,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,    -1,   446,    -1,   448,
      -1,    -1,    -1,   455,    -1,    -1,   455,   459,   460,   461,
     459,   460,   461,    -1,    -1,    -1,   468,    -1,    -1,   468,
      -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   572,    -1,   487,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     596,   597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   551,
      -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     816,    -1,   818,    -1,   820,    -1,    -1,    -1,   824,    -1,
     826,   827,   828,   829,    -1,   831,   832,    -1,   577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   848,   679,    -1,   681,   682,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3264,    -1,  3266,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   701,    -1,    -1,   874,    -1,
     706,    -1,     3,    -1,    -1,    -1,   882,     8,    -1,    -1,
     629,    12,    -1,    -1,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    -1,    -1,
      -1,   907,    -1,    -1,    -1,    -1,    -1,   913,   744,    -1,
      -1,    -1,    -1,    -1,    45,    46,    -1,    -1,    -1,    -1,
     756,   927,    -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,
      -1,   680,    -1,    -1,    -1,    66,    67,    68,    69,    70,
      71,    72,    73,    -1,    -1,    -1,    77,    78,    79,    -1,
      81,    82,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    98,    99,   100,
     101,    -1,   103,   104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,   127,   128,   129,   130,
     131,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   854,    -1,
      -1,    -1,    -1,    -1,    -1,   777,   778,    -1,   777,   778,
      -1,    -1,   868,    -1,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   174,   175,   176,   177,   178,   179,   180,
     181,    -1,    -1,    -1,   185,    -1,   187,   188,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,    -1,    -1,
     829,    -1,   213,   214,    -1,    -1,   217,   218,    -1,   220,
     221,   222,   223,   224,    -1,    -1,   848,    -1,    -1,   848,
      -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   874,    -1,    -1,   874,    -1,    -1,    -1,    -1,
     882,    -1,    -1,   882,    -1,    -1,    -1,   268,   269,    -1,
      -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,   907,    -1,   288,   907,    -1,
      -1,   913,   293,   294,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,   310,
     311,   312,   313,   314,    -1,    -1,   317,    -1,    -1,    -1,
     321,   322,   323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   343,    -1,    -1,    -1,    -1,   348,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,   357,   358,   359,    -1,
      -1,    -1,    -1,    -1,   365,   366,    -1,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,    -1,   378,    -1,   380,
     381,   382,    -1,    -1,    -1,    -1,  3665,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     401,   402,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,
     411,   412,   413,   414,   415,    -1,  3695,    -1,    -1,    -1,
      -1,    -1,    -1,   424,    -1,    -1,    -1,   428,   429,    -1,
      -1,   432,    -1,   434,    -1,   436,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   452,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   465,   466,   467,    -1,    -1,   470,
      -1,    -1,    -1,   474,    -1,   476,   477,   478,   479,    -1,
      -1,    -1,    -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,
      -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   510,
      -1,    -1,    -1,  3792,   515,   516,   517,    -1,   519,    -1,
     521,   522,    -1,   524,    -1,   526,   527,    -1,    -1,   530,
     531,    -1,   533,   534,   535,   536,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   545,   546,    -1,    -1,   549,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   557,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   570,
     571,    -1,    -1,    -1,    -1,    -1,    -1,   578,   579,    -1,
     581,    -1,    -1,    -1,   585,    -1,    -1,    -1,    -1,    -1,
      -1,   592,    -1,    -1,    -1,    -1,    -1,   598,    -1,    -1,
      -1,   602,    -1,   604,   605,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   618,    -1,    -1,
     621,   622,    -1,    -1,    -1,    -1,   627,    -1,    -1,    -1,
      -1,   632,    -1,    -1,    -1,    -1,   637,    -1,    -1,    -1,
     641,    -1,   643,   644,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3946,    -1,    -1,
      -1,   672,   673,   674,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   688,   689,    -1,
      -1,    -1,   693,   694,   695,   696,   697,   698,    -1,    -1,
      -1,   702,   703,    -1,    -1,    -1,    -1,    -1,    -1,   710,
     711,    -1,    -1,    -1,    -1,    -1,    -1,   718,   719,   720,
     721,    -1,    -1,    -1,    -1,   726,    -1,    -1,    -1,    -1,
     731,    -1,    -1,   734,   735,   736,   737,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   749,    -1,
      -1,    -1,    -1,   754,   755,    -1,    -1,    -1,    -1,    -1,
      -1,   762,   763,    -1,   765,    -1,    -1,   768,    -1,    -1,
      -1,     1,   773,    -1,    -1,     5,    -1,    -1,    -1,    -1,
      10,    -1,    -1,    -1,    -1,    -1,    -1,    17,    -1,   790,
     791,    -1,    -1,   794,    -1,    -1,    26,    -1,   799,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   807,   808,   809,    -1,
      -1,    -1,   813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   843,    -1,    -1,   846,    -1,    -1,    -1,   850,
      -1,    -1,    -1,    -1,   855,    -1,    -1,    87,    88,    -1,
      -1,   862,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   873,    -1,    -1,    -1,   877,   878,   879,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,   890,
      -1,    -1,    -1,   894,   895,   896,   897,    -1,   899,   900,
     901,   902,   903,    -1,    -1,    -1,    -1,   137,   909,   910,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     921,    -1,    -1,   924,    -1,    -1,    -1,    -1,    -1,   159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,    44,
      -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,
     200,    56,    -1,    -1,    -1,    -1,   206,    -1,   208,    -1,
      -1,    -1,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,   236,    -1,    -1,    -1,
     240,   241,   242,   243,   244,    -1,   246,   247,   248,   249,
      -1,   251,   252,    -1,   254,   255,    -1,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   123,    -1,
     270,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,    -1,
      -1,    -1,    -1,   283,    -1,    -1,   286,    -1,    -1,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   160,    -1,   162,    -1,    -1,
      -1,    -1,    -1,  4362,  4363,    -1,    -1,    -1,    -1,   174,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   197,  4392,   344,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   352,    -1,    -1,   355,    -1,    -1,    -1,    -1,
     360,  4410,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    10,    -1,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    26,    -1,   395,    -1,   397,    -1,    -1,
     400,    -1,    -1,   403,    -1,    -1,    -1,    -1,   408,    -1,
      -1,    -1,    -1,    -1,    -1,  4464,    -1,    -1,   418,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   337,   483,   117,    -1,    -1,    -1,    -1,   489,
      -1,   491,   347,    -1,   494,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   509,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   518,    -1,
      -1,    -1,   377,    -1,    -1,    -1,   159,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   537,   538,   539,
      -1,   541,   542,   543,   544,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,    -1,    -1,   200,    -1,    -1,
      -1,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,   212,
     435,    -1,    -1,   216,   584,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   466,    -1,    -1,   469,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   625,    -1,    -1,    -1,    -1,
      -1,   631,    -1,    -1,    -1,   635,    -1,   270,   638,   639,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   286,    -1,   655,    -1,    -1,   513,    -1,
      -1,    -1,    -1,   296,    -1,   520,    -1,    -1,    -1,    -1,
      -1,   671,    -1,    -1,    -1,    -1,    -1,   677,    -1,    -1,
      -1,    -1,    -1,    -1,   684,    -1,    -1,    -1,    -1,     1,
     690,    -1,    -1,     5,    -1,    -1,    -1,    -1,    10,    -1,
      -1,   556,    -1,    -1,    -1,    17,    -1,    -1,    -1,   709,
      -1,   344,    -1,    -1,    26,    -1,    -1,   572,    -1,   352,
      -1,    -1,   355,   723,    -1,    -1,    -1,   360,    -1,   729,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   745,    -1,   747,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,
      -1,   761,   395,    -1,   397,   620,    -1,   400,   623,    -1,
     403,   771,   772,    -1,    -1,    87,    88,    -1,    -1,   779,
      -1,    -1,   782,    -1,    -1,   418,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   797,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,
      -1,   666,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   819,
      -1,    -1,    -1,    -1,   679,   137,   681,   682,    -1,   141,
     830,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   845,   701,   159,    -1,    -1,
     483,   706,    -1,    -1,    -1,    -1,   489,   857,   491,   714,
      -1,   494,    -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   509,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   887,   200,   744,
      -1,    -1,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,
     212,   756,    -1,    -1,   216,    -1,   906,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   917,    -1,    -1,
      -1,   233,   922,    -1,    -1,    -1,    -1,    -1,   561,    -1,
      -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   584,    -1,    -1,    -1,   810,    -1,    -1,   270,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   625,    -1,    -1,    -1,    -1,    -1,   631,   854,
      -1,    -1,   635,    -1,    -1,   638,   639,    -1,    -1,    -1,
      -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,   873,    -1,
      -1,    -1,   655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,    -1,    -1,    -1,    -1,    -1,   671,    -1,
     352,    -1,    -1,   355,   677,    -1,    -1,    -1,   360,    -1,
      -1,   684,    -1,    -1,    -1,    -1,     1,   690,    -1,    -1,
       5,    -1,    -1,    -1,    -1,    10,    -1,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,   387,   709,    -1,    -1,    -1,
      -1,    26,    -1,   395,    -1,   397,    -1,    -1,   400,    -1,
     723,   403,    -1,    -1,    -1,    -1,   729,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   418,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   747,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   771,   772,
      -1,    -1,    87,    88,    -1,    -1,   779,    -1,    -1,   782,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   797,    -1,    -1,    -1,    -1,    -1,
      -1,   483,   117,    -1,    -1,    -1,    -1,   489,    -1,   491,
      -1,    -1,   494,    -1,    -1,    -1,   819,    -1,    -1,    -1,
       1,    -1,   137,    -1,    -1,     6,   141,   509,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   845,    -1,   159,    -1,    27,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   857,    -1,    -1,    -1,    11,    40,
     863,    -1,    -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    57,    -1,    -1,   561,
      -1,    -1,    -1,    -1,   887,   200,    -1,    -1,    -1,    -1,
      -1,   206,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,
      -1,   216,   584,    -1,    -1,    -1,    -1,    -1,    -1,    16,
      -1,    -1,    -1,    -1,   917,    -1,    -1,    -1,   233,   922,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     121,    -1,    -1,   625,    -1,    -1,    -1,    -1,    -1,   631,
      -1,    -1,    -1,   635,    -1,   270,   638,   639,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   286,    -1,   655,    -1,    -1,    -1,    84,    -1,    -1,
      -1,   296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   671,
      -1,    -1,    -1,    -1,    -1,   677,    -1,    -1,   151,    -1,
      -1,    -1,   684,    -1,   157,   158,    -1,    -1,   690,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,    -1,    -1,    -1,    -1,    -1,    -1,   709,    -1,   344,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   352,    -1,    -1,
     355,   723,    -1,    -1,   151,   360,    -1,   729,    -1,    -1,
     157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   747,   173,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,   761,
     395,    -1,   397,    -1,    -1,   400,    -1,    -1,   403,   771,
     772,    -1,    -1,    -1,    -1,    -1,    -1,   779,    -1,    -1,
     782,    -1,    -1,   418,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   797,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   308,   309,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   819,    -1,    -1,
      -1,    -1,    -1,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   845,    -1,    -1,    -1,    -1,   483,    -1,
      -1,    -1,    -1,    -1,   489,   857,   491,    -1,    -1,   494,
      -1,   863,    -1,    -1,    -1,    -1,   339,   340,   341,    -1,
      -1,    -1,    -1,    -1,   509,    -1,    -1,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,   887,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,   338,   339,   340,   341,   917,    -1,    -1,    -1,    -1,
     922,    -1,    -1,    -1,   351,    -1,   561,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,     5,
      -1,    -1,    -1,    -1,    10,    -1,   447,    -1,    -1,   584,
      -1,    17,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      26,    -1,   463,    -1,   437,   438,   439,    -1,    -1,    -1,
      -1,    -1,    -1,   446,    -1,   448,    -1,    -1,    -1,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,   460,   461,    -1,
     625,    -1,    -1,    -1,    -1,   468,   631,    -1,   471,    -1,
     635,    -1,    -1,   638,   639,    -1,    -1,    -1,    -1,    -1,
     437,   438,   439,    -1,   487,    -1,    -1,    -1,    -1,    -1,
     655,    87,    88,    -1,   525,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,   460,   461,    -1,   671,    -1,    -1,    -1,
      -1,   468,   677,    -1,   471,    -1,    -1,    -1,    -1,   684,
      -1,   117,    -1,    -1,    -1,   690,    -1,   530,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,    -1,
      -1,   137,    -1,   574,   709,   141,    -1,    -1,   551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   723,    -1,
      -1,   564,    -1,   159,   729,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   551,    -1,   761,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,   771,   772,    -1,   640,
      -1,    -1,    -1,    -1,   779,    -1,   212,   782,    -1,    -1,
     216,    -1,    -1,   654,    -1,    -1,   629,    -1,    -1,    -1,
      -1,    -1,   797,    -1,    -1,    -1,    -1,    -1,   669,    -1,
     236,    -1,    -1,    -1,    -1,   241,   242,   243,   244,    -1,
     246,   247,   248,   249,    -1,   251,    -1,   253,   254,   255,
      -1,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   629,    -1,   270,    -1,    -1,   680,    -1,    -1,
     845,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     286,    -1,   857,    -1,    -1,    -1,   727,   728,   863,    -1,
     296,    -1,   733,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   747,    -1,    -1,    -1,
      -1,    -1,   887,   680,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   766,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,   752,
      -1,    -1,   917,    -1,    -1,    -1,   352,   922,    -1,   355,
      -1,    -1,    -1,    -1,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   777,   778,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   819,    -1,
      -1,   387,   823,    -1,    -1,   752,    -1,    -1,    -1,   395,
      -1,   397,    -1,    -1,   400,    -1,    -1,   403,   839,   840,
      -1,    -1,    -1,   816,    -1,   818,    -1,    -1,    -1,    -1,
     777,   778,    -1,    -1,   827,   828,   829,    -1,   831,   832,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
      -1,   157,   158,   800,    -1,   848,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   874,   829,    -1,    -1,    -1,    -1,    -1,    -1,   882,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   483,    -1,    -1,
      -1,   848,    -1,   489,    -1,   491,    -1,    -1,   494,    -1,
      -1,    -1,    -1,    -1,   907,    -1,    -1,   864,    -1,    -1,
     913,    -1,    -1,   509,    -1,    -1,    -1,   874,    -1,    -1,
      -1,    -1,    -1,    -1,   927,   882,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   893,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     907,    -1,    -1,    -1,    -1,   912,   913,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,    -1,
     927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   584,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   339,   340,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,   635,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   655,
      -1,    -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   677,    -1,    -1,    -1,    -1,    -1,    -1,   684,    -1,
      -1,    -1,    -1,    -1,   690,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   709,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   439,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   729,    -1,    -1,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,   460,   461,    -1,    -1,    -1,    -1,
      -1,   747,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   761,     8,    -1,    -1,    -1,
      -1,    -1,    -1,    15,    -1,   771,   772,    -1,    -1,    -1,
      -1,    -1,    -1,   779,    -1,    -1,   782,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   797,    44,    45,    -1,    -1,    -1,    49,    50,    51,
      52,    -1,    -1,    -1,    56,    57,    58,    59,    60,    61,
      -1,    63,    64,   819,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,   551,    -1,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,   845,
      -1,    -1,    94,    -1,    -1,    97,    98,    99,   100,    -1,
      -1,   857,    -1,    -1,    -1,    -1,    -1,   863,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,    -1,    -1,
     122,   123,   124,    -1,   126,   127,   128,   129,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
      -1,    -1,    -1,   629,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   917,    -1,   165,    -1,    -1,   922,    -1,    -1,   171,
      -1,    -1,   174,   175,   176,   177,   178,   179,   180,   181,
      -1,    -1,    -1,    -1,    -1,   187,   188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,
     212,   213,   214,    -1,    -1,   217,   218,    -1,    -1,    -1,
     222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,
      -1,   273,    -1,    -1,    -1,    -1,   752,    -1,    -1,   281,
      -1,    -1,    -1,    -1,    -1,    -1,   288,    -1,    -1,    -1,
      -1,   293,   294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,    -1,   310,   311,
     312,   313,   314,    -1,    -1,   317,    -1,    -1,    -1,    -1,
      -1,    -1,   324,   325,   326,   327,   328,    -1,    -1,   331,
     332,    -1,    -1,    -1,    -1,   337,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   345,    -1,   347,    -1,    -1,    -1,    -1,
      -1,    -1,   354,   829,   356,   357,   358,   359,    -1,    -1,
      -1,    -1,   364,   365,   366,   367,   368,    -1,   370,   371,
     372,    -1,   848,   375,   376,   377,   378,    -1,    -1,    -1,
     382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   874,   401,
     402,    -1,    -1,    -1,    -1,    -1,   882,   409,   410,   411,
     412,   413,   414,   415,    -1,    -1,    -1,   419,    -1,    -1,
      -1,    -1,   424,    -1,    -1,    -1,   428,   429,    -1,   431,
     432,   907,    -1,   435,    -1,    -1,    -1,   913,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   447,    -1,    -1,    -1,   451,
      -1,   927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,   470,    -1,
      -1,    -1,   474,    -1,   476,   477,   478,   479,    -1,    -1,
      -1,    -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,
     502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   510,    -1,
      -1,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   545,   546,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     572,   573,    -1,    -1,    -1,    -1,   578,    -1,    -1,   581,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,
     592,    -1,   594,    -1,   596,   597,   598,    -1,    -1,    -1,
     602,    -1,   604,   605,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   617,   618,    -1,   620,   621,
     622,    -1,    -1,    -1,    -1,   627,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   641,
      -1,   643,   644,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   666,    -1,    -1,    -1,    -1,    -1,
     672,   673,   674,    -1,    -1,    -1,    -1,   679,    -1,   681,
     682,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   693,   694,   695,   696,    -1,   698,    -1,    -1,    -1,
     702,   703,    -1,    -1,    -1,    -1,    -1,    -1,   710,   711,
      -1,    -1,   714,    -1,    -1,    -1,   718,   719,   720,    -1,
      -1,    -1,    -1,    -1,   726,    -1,    -1,    -1,    -1,   731,
      -1,    -1,    -1,    -1,    -1,    -1,   738,    -1,   740,   741,
     742,    -1,   744,    -1,    -1,    -1,    -1,   749,    -1,    -1,
      -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,    -1,    -1,
     762,   763,    -1,    -1,    -1,    -1,   768,    -1,    -1,    -1,
      -1,   773,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   789,   790,   791,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   799,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   807,    -1,    -1,    -1,    -1,
      -1,   813,   814,    -1,    -1,    -1,    -1,   819,    -1,    -1,
      -1,    -1,    -1,   825,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     842,   843,    -1,    -1,    -1,    -1,    -1,    -1,   850,    -1,
      -1,    -1,   854,     8,    -1,    -1,    -1,   859,   860,   861,
      15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   875,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   883,    -1,    -1,    -1,    -1,    -1,   889,   890,    -1,
      45,    -1,    -1,    -1,   896,   897,    -1,   899,    -1,    -1,
     902,    -1,    -1,    -1,    -1,    -1,    -1,   909,    -1,    -1,
      -1,    66,    67,    68,    69,    70,    71,    72,    73,   921,
      -1,    -1,   924,    -1,    -1,    -1,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    99,   100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   124,
      -1,    -1,   127,   128,   129,    -1,   131,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,
     175,   176,   177,   178,   179,   180,   181,    -1,    -1,    -1,
      -1,    -1,   187,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   213,   214,
      -1,    -1,   217,   218,    -1,    -1,    -1,   222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   234,
      -1,    -1,    -1,    -1,    -1,    -1,    41,    -1,    -1,    -1,
     245,    -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,
      -1,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,   273,    74,
      75,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   288,    -1,    -1,    -1,    -1,   293,   294,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   310,   311,   312,   313,   314,
      -1,    -1,   317,    -1,    -1,    -1,    -1,   122,   123,    -1,
      -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   356,   357,   358,   359,    -1,    -1,   162,    -1,    -1,
     365,   366,    -1,   368,    -1,   370,   371,   372,    -1,    -1,
     375,   376,    -1,   378,    -1,    -1,    -1,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   401,   402,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   410,   411,   412,   413,   414,
     415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   424,
      -1,    -1,    -1,   428,   429,    -1,    -1,   432,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,
     157,   158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   470,   173,    -1,    -1,   474,
      -1,   476,   477,   478,   479,    -1,   281,    -1,    -1,    -1,
      -1,   486,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   502,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,   337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     545,   546,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   377,   578,    -1,    -1,   581,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   592,    -1,    -1,
      -1,    -1,    -1,   598,    -1,    -1,    -1,   602,    -1,   604,
     605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   618,    -1,    -1,   621,   622,    -1,    -1,
      -1,    -1,   627,    -1,    -1,    -1,    -1,    -1,    -1,   434,
      -1,    -1,   339,   340,   341,    -1,   641,    -1,   643,   644,
      -1,    -1,   447,    -1,   351,    -1,   451,   652,   653,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   469,    -1,    -1,   672,   673,   674,
      -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   693,   694,
     695,   696,    -1,   698,    -1,    -1,    -1,   702,   703,    -1,
      -1,    -1,    -1,    -1,    -1,   710,   711,    -1,   513,    -1,
      -1,    -1,    -1,   718,   719,   720,    -1,    -1,    -1,    -1,
      -1,   726,    -1,    -1,    -1,    -1,   731,    -1,    -1,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,    -1,    -1,   446,
      -1,   448,    -1,    -1,   749,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,   460,   461,    -1,    -1,   762,   763,    -1,
      -1,   468,    -1,   768,   471,    -1,    -1,   572,   773,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   790,   791,    -1,    -1,     8,
     595,   596,   597,    -1,   799,    -1,    15,    -1,    -1,    -1,
      -1,    -1,   807,    -1,    -1,    -1,    -1,    -1,   813,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   843,    -1,
      -1,    -1,    -1,    -1,   551,   850,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
     577,    -1,    -1,    -1,   679,    -1,   681,   682,    97,    98,
      99,   100,   687,    -1,    -1,   890,    -1,    -1,    -1,    -1,
      -1,   896,   897,    -1,   899,   114,   701,   902,    -1,    -1,
      -1,   706,    -1,    -1,   909,   124,    -1,    -1,   127,   128,
     129,    -1,   131,    -1,    -1,    -1,   921,    -1,    -1,   924,
      -1,    -1,   629,    -1,    -1,    -1,    -1,   732,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   744,
      -1,    -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,
      -1,   756,    -1,    -1,    -1,   174,   175,   176,   177,   178,
     179,   180,   181,    -1,    -1,    -1,    -1,    -1,   187,   188,
      -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,   214,    -1,    -1,   217,   218,
      -1,    -1,    -1,   222,    -1,    -1,    -1,   812,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,    -1,   834,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,   854,
     269,    -1,    -1,    -1,   273,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   288,
     777,   778,    -1,    -1,   293,   294,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,   311,   312,   313,   314,    -1,    -1,   317,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,   816,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     827,    -1,   829,    -1,   831,   832,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,   357,   358,
     359,   848,    -1,    -1,    -1,    -1,   365,   366,    -1,   368,
      -1,   370,   371,   372,    -1,    -1,   375,   376,    -1,   378,
      -1,    -1,    -1,   382,    -1,    -1,    -1,   874,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,
      -1,    -1,   401,   402,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   410,   411,   412,   413,   414,   415,    -1,    -1,    -1,
     907,    -1,    -1,    -1,    -1,   424,   913,    -1,    -1,   428,
     429,    -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,
     927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   470,    -1,    -1,    -1,   474,    -1,   476,   477,   478,
     479,    -1,    -1,    -1,    -1,    -1,    -1,   486,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    -1,    -1,   502,    -1,    16,    -1,    -1,    -1,    -1,
      -1,   510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      41,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,
      51,    52,    -1,    -1,    -1,    56,   545,   546,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   578,
      -1,    -1,   581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   592,    -1,    -1,    -1,    -1,    -1,   598,
      -1,    -1,    -1,   602,    -1,   604,   605,    -1,    -1,    -1,
      -1,   122,   123,    -1,    -1,   126,    -1,    -1,    -1,   618,
      -1,    -1,   621,   622,    -1,    -1,    -1,    -1,   627,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,    -1,   641,    -1,   643,   644,   157,   158,    -1,    -1,
      -1,   162,    -1,   652,   653,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   672,   673,   674,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   693,   694,   695,   696,    -1,   698,
      -1,    -1,    -1,   702,   703,    -1,    -1,    -1,    -1,    -1,
      -1,   710,   711,    -1,    -1,    -1,    -1,    -1,    -1,   718,
     719,   720,    -1,    -1,    -1,    -1,    -1,   726,    -1,    -1,
      -1,    -1,   731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   762,   763,    -1,    -1,    -1,    -1,   768,
     281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   790,   791,    -1,    11,    -1,    -1,    -1,    -1,    16,
     799,    -1,    -1,    20,    21,    22,    -1,    -1,   807,    -1,
      -1,    28,    -1,    -1,   813,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   337,    -1,   339,   340,
     341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,    -1,    -1,    -1,   843,    -1,    -1,    -1,    -1,    -1,
      -1,   850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,   379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   890,    -1,    -1,    -1,    -1,   113,   896,   897,    -1,
     899,    -1,    -1,   902,    -1,    -1,    -1,    -1,    -1,    -1,
     909,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   921,    -1,    -1,   924,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,   151,   446,   447,   448,    -1,    -1,
     157,   158,    -1,    -1,   455,    -1,    -1,    -1,   459,   460,
     461,    -1,    -1,    -1,    -1,    -1,   173,   468,   469,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   487,   488,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    11,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,
      -1,   572,    -1,   280,    -1,    -1,   577,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     297,    -1,    -1,    -1,    -1,   596,   597,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,
      -1,    -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,    -1,    -1,    -1,    -1,    -1,   679,   680,
     681,   682,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     701,   151,   409,    -1,    -1,   706,    -1,   157,   158,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,
     437,   438,   439,   440,   441,    -1,    -1,    -1,    -1,   446,
      -1,   448,    -1,   744,    -1,    -1,    -1,    -1,   455,    -1,
      -1,   752,   459,   460,   461,   756,    -1,    -1,    -1,    -1,
      -1,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   777,   778,    -1,    -1,
     487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   506,
      11,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,   829,    -1,
      -1,   281,    -1,   540,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   549,    -1,   551,    -1,    -1,   848,    -1,    -1,
      -1,   558,    -1,   854,    -1,    11,    -1,   564,    -1,    -1,
      16,    -1,    -1,    -1,    -1,    -1,    -1,   868,    -1,    -1,
     577,    -1,    83,   874,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   882,    -1,   333,    -1,    -1,    -1,    -1,    -1,   339,
     340,   341,   599,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,
      -1,   912,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   629,    -1,    -1,    -1,   927,    -1,    -1,   379,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   391,    -1,    -1,    -1,   156,   157,   158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,   151,   446,    -1,   448,    -1,
      -1,   157,   158,    -1,    -1,   455,    -1,    -1,    -1,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,   173,   468,    -1,
      -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   484,    -1,    -1,   487,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,    16,    -1,
     777,   778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,   558,   816,
      -1,   818,    -1,   820,    -1,    -1,    -1,   824,    -1,   826,
     827,   828,   829,    -1,   831,   832,   282,   577,   339,   340,
     341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   874,   379,    -1,
      -1,    -1,    -1,    -1,    -1,   882,    -1,    -1,    -1,   629,
      -1,    -1,    -1,   339,   340,   341,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,    -1,   353,    -1,    -1,
     907,    -1,    -1,   151,    -1,    -1,   913,    -1,    11,   157,
     158,    -1,    -1,    16,    -1,    -1,    -1,    -1,    -1,    -1,
     927,    -1,    -1,   379,    -1,   173,   437,   438,   439,    -1,
     680,    -1,    -1,    -1,    -1,   446,    -1,   448,    -1,    -1,
      -1,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,   460,
     461,    -1,    -1,    -1,    -1,    -1,    -1,   468,    -1,    -1,
     471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   487,    -1,    -1,    -1,
      -1,   437,   438,   439,    -1,    -1,    -1,    -1,    -1,    -1,
     446,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,   455,
      -1,    -1,   752,   459,   460,   461,   756,    -1,    -1,    -1,
      -1,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,   270,    -1,    -1,    -1,    -1,   777,   778,    -1,
     780,   487,    11,    -1,    -1,    -1,    -1,    16,    -1,    -1,
     551,    -1,    -1,    -1,    -1,    -1,    -1,   558,   151,    -1,
      -1,    -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   167,    -1,   577,    -1,    -1,    -1,
     173,    -1,    -1,   529,    -1,   825,    -1,    -1,    -1,   829,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   339,   340,   341,    -1,   551,    -1,    -1,   848,    -1,
      -1,    -1,    -1,   351,    -1,    -1,    -1,    11,    -1,    -1,
      -1,    -1,    16,    -1,    -1,    -1,    -1,    -1,   629,    -1,
      -1,   577,    -1,    -1,   874,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   882,    -1,    -1,    -1,    -1,    -1,    -1,   650,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,   911,    -1,   913,    -1,    -1,    -1,    -1,    -1,   680,
      -1,    -1,   151,   629,    -1,    -1,    -1,   927,   157,   158,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   167,   437,
     438,   439,    -1,    -1,   173,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,    -1,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,
     468,    -1,   678,   471,   680,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   744,    -1,    -1,   339,   340,   341,   487,
      -1,   752,    -1,    -1,    -1,    -1,    -1,   151,   351,    -1,
      -1,    -1,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   777,   778,    -1,   173,
      -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,    16,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   829,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,   437,   438,   439,   848,    -1,    -1,
      -1,    -1,    -1,   446,    -1,   448,    -1,   858,    -1,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,   460,   461,    -1,
     339,   340,   341,   874,    -1,   468,    -1,    -1,   471,    -1,
      -1,   882,   351,   829,    -1,    -1,    -1,    -1,   889,    -1,
      -1,   629,    -1,    -1,   487,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   848,    -1,    -1,    -1,   907,    -1,    -1,    -1,
     379,    -1,   913,    -1,    -1,    -1,    -1,    11,    -1,    -1,
      -1,    -1,    16,    -1,    -1,    -1,   927,    -1,   874,    -1,
      -1,    -1,    -1,   151,    -1,    -1,   882,    -1,    -1,   157,
     158,    -1,   680,    -1,    -1,   339,   340,   341,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   173,    -1,   351,   551,    -1,
      -1,   907,    -1,    -1,    -1,    -1,   912,   913,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,    -1,   446,    -1,   448,
      -1,   927,    -1,    -1,   577,   379,   455,    -1,    -1,    -1,
     459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,   468,
      -1,    -1,   471,    -1,    -1,    -1,   744,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,   487,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,   777,
     778,    11,    -1,   437,   438,   439,    16,    -1,    -1,    -1,
      -1,    -1,   446,    -1,   448,    -1,    -1,   151,    -1,    -1,
      -1,   455,    -1,   157,   158,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,    -1,   468,    -1,    -1,   471,    -1,   173,
      -1,    -1,   551,    -1,   822,    -1,    -1,   680,    -1,    -1,
      -1,   829,    -1,   487,    -1,   833,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,    -1,   874,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   551,    -1,   752,
     629,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
      -1,   151,    -1,   577,   777,   778,    -1,   157,   158,   927,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   792,
      -1,    -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,
     438,   439,    -1,    -1,    -1,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,    -1,    -1,   629,   829,   455,    -1,    -1,
      -1,   459,   460,   461,    -1,   339,   340,   341,    -1,    -1,
     468,   345,    -1,   471,    -1,   848,    -1,   351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   487,
      11,    -1,    -1,    -1,    -1,    16,    -1,    -1,    -1,    -1,
      -1,   874,    -1,   752,    -1,   379,   680,    -1,    -1,   882,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,   778,
      -1,    -1,    -1,    11,   907,    -1,    -1,    -1,    16,    -1,
     913,    -1,    -1,   792,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   551,   927,    -1,    -1,    -1,    -1,    -1,
     558,    -1,    -1,   437,   438,   439,    -1,    -1,    -1,    -1,
      -1,    -1,   446,    -1,   448,    -1,    -1,    -1,   752,   577,
     829,   455,    -1,    -1,    -1,   459,   460,   461,    -1,   339,
     340,   341,    -1,    -1,   468,    -1,    -1,   471,    -1,   848,
      -1,   351,    -1,   777,   778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   874,    -1,    -1,    -1,   379,
     151,   629,    -1,   882,    -1,    -1,   157,   158,    -1,    -1,
     814,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,    -1,    -1,   829,    -1,    -1,   907,    -1,
      -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,   848,    -1,    -1,   551,   927,   157,
     158,    -1,   680,    -1,    -1,    -1,    -1,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,   173,   446,    -1,   448,    -1,
     874,    -1,    -1,   577,    -1,   455,    -1,    -1,   882,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,    -1,   468,    -1,
      -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   907,    -1,    -1,    -1,   487,    -1,   913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   927,   752,   629,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,
     778,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   551,    -1,    -1,    -1,    -1,   680,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,   340,
     341,    -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,    -1,
     351,   829,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,
      -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,    -1,   874,    -1,   752,   629,
      -1,    -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,    -1,   777,   778,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,    -1,   913,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,    -1,   446,    -1,   448,    -1,   927,
     680,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,   460,
     461,    -1,    -1,    -1,    -1,    -1,    -1,   468,    -1,    -1,
     471,    -1,    -1,    -1,    -1,   829,    -1,    -1,    -1,   437,
     438,   439,    -1,    -1,    -1,    -1,   487,    -1,   446,    -1,
     448,    -1,    -1,    -1,   848,    -1,    -1,   455,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,
     468,    -1,    -1,   471,   744,    -1,    -1,    -1,    -1,    -1,
     874,    -1,   752,    -1,    -1,    -1,    -1,    -1,   882,   487,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
      -1,   157,   158,    -1,    -1,    -1,    -1,   777,   778,    -1,
     551,    -1,    -1,   907,    -1,    -1,    -1,   173,    -1,   913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   927,    -1,    -1,   577,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,   829,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,   577,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   874,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   882,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      -1,    -1,    -1,     7,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   629,    -1,    -1,    -1,    -1,    -1,   907,    -1,   680,
      -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,
      44,    -1,    -1,    -1,    -1,    49,    50,    51,    52,    53,
      -1,    -1,    56,    57,    58,    59,    60,    61,    -1,    63,
      64,    65,   680,   339,   340,   341,    -1,    -1,    -1,    -1,
      74,    75,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      94,   752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,   777,   778,   122,   123,
      -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,   133,
      -1,    -1,    -1,    -1,   752,    -1,   140,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,
     778,   437,   438,   439,    -1,    -1,    -1,   171,   829,    -1,
     446,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,   460,   461,   190,   848,    -1,    -1,
      -1,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,    -1,
      -1,   829,    -1,   874,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   882,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,
      -1,    -1,   913,    -1,    -1,    -1,   874,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   882,    -1,   927,    -1,   272,    -1,
      -1,    -1,    -1,    -1,    -1,   551,    -1,   281,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
      -1,   577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,
      -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     324,   325,   326,   327,   328,    -1,    -1,   331,   332,    -1,
      -1,    -1,    -1,   337,    -1,    -1,    -1,    -1,   342,    -1,
      -1,   345,    -1,   347,    -1,    -1,    -1,    -1,    -1,    -1,
     354,    -1,    -1,   629,    -1,    -1,    -1,    -1,    -1,    -1,
     364,    -1,    -1,   367,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,     4,    -1,    -1,   680,   409,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,    -1,
      -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   447,    -1,    -1,    -1,   451,    -1,    -1,
     454,    -1,    -1,    -1,    57,    58,    59,    60,    61,    -1,
      63,    64,    -1,    -1,    -1,   469,    -1,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,    -1,    -1,   513,
      -1,    -1,   788,    -1,    -1,    -1,   520,    -1,    -1,   122,
      -1,    -1,   125,   126,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   552,    -1,
     554,   827,   556,   829,    -1,   831,   832,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   572,   573,
      -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,    -1,    -1,
     594,    -1,   596,   597,    -1,    -1,    -1,    -1,   874,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   882,    -1,    -1,   212,
      -1,    -1,    -1,   617,    -1,    -1,   620,    -1,    -1,    -1,
      -1,    -1,   626,    -1,    -1,    -1,   630,    -1,    -1,     1,
      -1,   907,    -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   927,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,   666,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   679,    -1,   681,   682,    -1,
      -1,    -1,    54,    -1,    -1,    57,    58,    59,    60,    61,
      -1,    63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    74,   707,    -1,    -1,    -1,    -1,    -1,    -1,
     714,    -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   324,   325,   326,   327,   328,    -1,    -1,   331,   332,
      -1,    -1,    -1,    -1,   738,    -1,   740,   741,   742,    -1,
     744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   756,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   365,   767,   367,    -1,    -1,    -1,   140,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
      -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,   392,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     814,    -1,    -1,    -1,    -1,   819,   419,    -1,    -1,    -1,
      -1,   825,    -1,    -1,    -1,    -1,    -1,    -1,   431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   842,    -1,
     212,    -1,    -1,   847,   447,    -1,    -1,    -1,   451,    -1,
     854,    -1,    -1,    -1,    -1,   859,   860,   861,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   883,
      -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,    -1,
      -1,   905,    -1,    -1,    -1,    -1,    -1,    -1,   511,   913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   300,   301,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   554,   324,   325,   326,   327,   328,    -1,    -1,   331,
     332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     573,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,    -1,
      -1,    -1,   354,    -1,    -1,    -1,   589,    12,    -1,    -1,
      -1,   594,    -1,    -1,    -1,   367,    -1,   600,    -1,    -1,
      -1,    -1,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   385,   617,    -1,    -1,    -1,    -1,    -1,
     392,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,
      -1,    -1,    77,    78,    79,    -1,    -1,    82,    -1,   431,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,    -1,   103,   104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   738,    -1,   740,   741,   742,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     185,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,   781,    -1,
      -1,    -1,   554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   220,   221,    -1,   223,   224,
      -1,   573,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   819,   589,    -1,    -1,
      -1,    -1,   594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   842,
      -1,    -1,    -1,   268,    -1,   617,    -1,   850,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   859,   860,   861,   284,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   875,    -1,    -1,    -1,   648,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,    -1,
     893,    -1,    -1,    -1,    -1,    -1,   321,   322,   323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   343,    -1,
      -1,    -1,    -1,   348,    -1,    -1,    -1,    -1,    -1,   701,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,   374,
      -1,    -1,    -1,    -1,    -1,   380,   381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   738,    -1,   740,   741,
     742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   753,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
      -1,   436,    -1,   785,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   452,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     465,   466,   467,    -1,    -1,    -1,    -1,   819,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,    -1,    -1,
     842,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,    -1,    -1,    -1,    -1,    -1,   859,   860,   861,
     515,   516,   517,    -1,   519,    -1,   521,   522,    -1,   524,
      -1,   526,   527,   875,    -1,    -1,   531,    -1,   533,   534,
     535,   536,    -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,
      -1,    -1,    -1,    -1,   549,    -1,   898,    -1,    -1,    -1,
      -1,    -1,   557,    57,    58,    59,    60,    61,    -1,    63,
      64,   913,    -1,    -1,    -1,   570,   571,    -1,    -1,    -1,
      74,    -1,    -1,    -1,   579,    -1,    -1,    -1,    -1,    -1,
     585,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,
     158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   122,    -1,
      -1,   125,   126,    -1,    -1,    -1,    -1,   632,   132,    -1,
      -1,    -1,   637,    -1,    -1,    -1,   140,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    41,    -1,    -1,    44,    -1,    -1,    -1,    -1,    49,
      50,    51,    52,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    -1,    -1,   688,   689,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   697,    -1,    -1,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   721,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   734,
     735,   736,   737,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   122,   123,    -1,    -1,   126,    -1,    -1,   754,
     755,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     765,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,    -1,
     160,    -1,   162,   351,    -1,    -1,    -1,    -1,    -1,   794,
      -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   808,   809,    -1,    -1,    -1,    -1,    -1,
      -1,   379,    -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,
     324,   325,   326,   327,   328,    -1,    -1,   331,   332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     855,    -1,    -1,    -1,    -1,    -1,    -1,   862,    -1,    -1,
      -1,   365,    -1,   367,    -1,    -1,    -1,    -1,   873,   437,
     438,   439,   877,   878,   879,    -1,    -1,    -1,   446,    -1,
     448,    -1,    -1,    -1,    -1,    -1,    -1,   455,   392,   894,
     895,   459,   460,   461,    -1,   900,   901,    -1,   903,    -1,
     468,    29,    -1,   471,    -1,   910,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,    57,
      58,    59,    60,    61,    -1,    63,    64,    -1,    -1,    -1,
      -1,    -1,    -1,   447,    -1,    -1,    74,   451,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   337,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   498,    -1,    -1,   377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,   577,
      -1,    -1,   140,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   421,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     554,    -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,
      -1,   629,    -1,    -1,    -1,    -1,    -1,   447,    -1,   573,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   212,   589,   466,    -1,    -1,   469,
     594,    -1,    -1,    -1,    -1,    -1,   600,    -1,    -1,    -1,
      -1,    -1,   670,    -1,    -1,    -1,    -1,    -1,   488,    -1,
      -1,    -1,   680,   617,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   513,    -1,    -1,    -1,    29,    -1,    -1,
     520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    54,    -1,    -1,    57,    58,    59,    60,    61,
      -1,    63,    64,    -1,    -1,    -1,   556,    -1,    -1,    -1,
      -1,    -1,    74,    -1,   752,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   572,    -1,    -1,    -1,   324,   325,   326,   327,
     328,    -1,    -1,   331,   332,    -1,    -1,    -1,    -1,   777,
     778,    -1,    -1,    -1,    -1,    -1,   596,   597,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   738,    -1,   740,   741,   742,   367,
     620,    -1,    -1,   623,    -1,    -1,   750,    -1,   140,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,    -1,
      -1,   829,    -1,    -1,   392,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   781,    -1,    -1,
     848,   409,    -1,    -1,    -1,    -1,   666,    -1,    -1,    -1,
      -1,   419,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   679,
     868,   681,   682,   431,    -1,    -1,   874,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   882,   819,    -1,    -1,    -1,    -1,
     212,   701,    -1,    -1,    -1,    -1,   706,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   714,    -1,    -1,    -1,    -1,   907,
      -1,    -1,    -1,    -1,    -1,   913,   850,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   859,   860,   861,    -1,   927,
      -1,    -1,    -1,    -1,   744,    -1,    -1,    -1,    -1,    -1,
     498,   875,    -1,    -1,    -1,    -1,   756,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,    -1,   893,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   789,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   554,    -1,    -1,   809,
     810,    -1,   324,   325,   326,   327,   328,    -1,    -1,   331,
     332,    -1,    -1,    -1,    -1,   573,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   589,    -1,    -1,    -1,    -1,   594,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   854,   367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   866,    -1,    -1,   617,
      -1,    -1,    -1,   873,    -1,    -1,    -1,    -1,    -1,    -1,
     392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,
     648,    -1,    -1,    -1,    -1,    -1,    -1,   419,    -1,    -1,
      -1,    -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,   431,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    -1,    -1,    49,    50,    51,    52,    -1,
      -1,    -1,    56,    57,    58,    59,    60,    61,    -1,    63,
      64,    -1,    -1,   701,    -1,    -1,    -1,   151,    -1,    -1,
      74,    75,    -1,   157,   158,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,
      94,    -1,    -1,    -1,    -1,    -1,   498,    -1,    -1,    -1,
     738,    -1,   740,   741,   742,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,   122,   123,
      -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   140,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   785,    -1,    -1,
      -1,    -1,   554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   171,    -1,    -1,
      -1,   573,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   819,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,
      -1,    -1,   594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   842,    -1,    -1,    -1,   212,    -1,
      -1,    -1,    -1,    -1,    -1,   617,    -1,    -1,    -1,    -1,
      -1,   859,   860,   861,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   875,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   648,    -1,    -1,    -1,
      -1,   889,    -1,    -1,    -1,   339,   340,   341,    -1,    -1,
     898,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,    -1,    -1,   379,    -1,   157,   158,   701,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   173,    -1,    -1,    -1,    -1,    -1,    -1,
     324,   325,   326,   327,   328,    -1,    -1,   331,   332,    -1,
      -1,    -1,    -1,   337,    -1,    -1,   738,    -1,   740,   741,
     742,   345,    -1,   347,    -1,    -1,    -1,    -1,    -1,    -1,
     354,    -1,    -1,   437,   438,   439,    -1,    -1,    -1,    -1,
     364,    -1,   446,   367,   448,    -1,    -1,    -1,    -1,    -1,
      -1,   455,    -1,   377,    -1,   459,   460,   461,    -1,    -1,
      -1,    -1,    -1,   785,   468,    -1,    -1,   471,   392,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   419,    -1,   819,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     842,    -1,    -1,   447,    -1,    -1,    -1,   451,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   859,   860,   861,
      -1,    -1,    -1,    -1,    -1,   469,    -1,   551,    -1,    -1,
      -1,    -1,    -1,   875,    -1,    -1,    -1,    -1,    -1,   339,
     340,   341,    -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,
      -1,   351,    -1,   577,   498,    -1,   898,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   379,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,    -1,    -1,    -1,    -1,   157,   158,    -1,
      -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,    -1,
     554,    -1,   556,   173,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   572,   573,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,   438,   439,
      -1,    -1,    -1,    -1,    -1,   589,   446,    -1,   448,    -1,
     594,    -1,   596,   597,    -1,   455,   680,    -1,    -1,   459,
     460,   461,    -1,    -1,    -1,    -1,    -1,    -1,   468,    -1,
      -1,   471,    -1,   617,    -1,    -1,   620,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   666,    -1,    -1,    -1,    -1,    -1,   752,    -1,
      -1,    -1,    -1,   151,    -1,   679,    -1,   681,   682,   157,
     158,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   551,    -1,   777,   778,   173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,
     714,    -1,    -1,    -1,   157,   158,    -1,   577,    -1,   339,
     340,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     173,   351,   816,    -1,   738,    -1,   740,   741,   742,    -1,
     744,    -1,    -1,   827,    -1,   829,    -1,   831,   832,    -1,
      -1,    -1,   756,    -1,    -1,    -1,    -1,    -1,    -1,   379,
      -1,    -1,    -1,    -1,   848,    -1,    -1,    -1,    -1,   629,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,
     874,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   882,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     814,    -1,    -1,    -1,    -1,   819,    -1,   437,   438,   439,
     680,   825,    -1,   907,    -1,    -1,   446,    -1,   448,   913,
      -1,    -1,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
     460,   461,    -1,   927,    -1,    -1,    -1,    -1,   468,    -1,
     854,   471,   151,    -1,    -1,   859,   860,   861,   157,   158,
      -1,   339,   340,   341,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   875,    -1,   351,   173,    -1,    -1,    -1,    -1,   883,
      -1,    -1,    -1,    -1,    -1,   889,    -1,    -1,    -1,    -1,
      -1,    -1,   752,    -1,    -1,    -1,   339,   340,   341,    -1,
      -1,   379,    -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,   778,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   788,    -1,
      -1,   551,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,    -1,   437,
     438,   439,    -1,    -1,    -1,    -1,    -1,   827,   446,   829,
     448,   831,   832,    -1,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,   460,   461,    -1,    -1,    -1,    -1,   848,    -1,
     468,    -1,    -1,   471,   437,   438,   439,    -1,    -1,    -1,
      -1,    -1,    -1,   446,    -1,   448,    -1,    -1,    -1,   629,
      -1,    -1,   455,    -1,   874,    -1,   459,   460,   461,    -1,
      -1,    -1,   882,    -1,    -1,   468,    -1,    -1,   471,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     339,   340,   341,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,   351,   913,    -1,    -1,    -1,    -1,    -1,    -1,
     680,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,    -1,
      -1,    -1,    -1,   551,    -1,    -1,    -1,    -1,    -1,    -1,
     379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   577,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   752,    -1,   577,    -1,    -1,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,    -1,   446,    -1,   448,
      -1,   629,    -1,    -1,    -1,    -1,   455,   777,   778,    -1,
     459,   460,   461,    -1,    -1,    -1,    -1,    -1,    -1,   468,
      -1,    -1,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   816,    -1,    -1,    -1,
      -1,    -1,   680,    -1,    -1,    -1,    -1,   827,    -1,   829,
      -1,   831,   832,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   680,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   551,    -1,   874,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,   577,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,   777,
     778,    -1,    -1,    -1,    -1,    -1,    -1,   927,    -1,   752,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     629,    -1,    -1,    -1,   777,   778,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,
      -1,   829,    -1,   831,   832,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   680,    -1,    -1,    -1,    -1,   829,    -1,   831,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   874,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   882,   848,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,
      -1,   874,    -1,    -1,    -1,   913,    -1,    -1,    -1,   882,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927,
      -1,    -1,    -1,   752,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   907,    -1,    -1,    -1,    -1,    -1,
     913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   777,   778,
      -1,    -1,    -1,    -1,   927,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     829,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   848,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   874,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,
      -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   927
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   930,   931,     0,   932,   933,   934,   937,   938,   384,
     386,   935,   936,   939,   940,   950,   951,   952,   563,   947,
     967,   936,   350,   615,   953,   956,   219,   819,   274,   976,
     977,   957,   954,   947,   947,   819,    36,   968,   969,   219,
     948,   153,   978,   979,   819,   819,   256,   941,   942,   943,
     250,   945,   409,  2163,   197,   971,   819,   186,  1139,  1141,
    1142,   713,   399,  1059,  1060,    19,   111,   169,   172,   174,
     195,   289,   458,   549,   553,   665,   705,   751,   753,   784,
     834,   913,   980,   981,   982,   983,   987,  1001,  1007,  1008,
    1009,  1010,  1011,  1017,  1033,  1035,  1040,  1043,  1048,  1049,
    1051,  1052,  1053,  1054,  1055,  1056,  1057,   455,   616,   958,
     958,   944,   943,   946,   501,   756,   759,   760,   970,   691,
     271,   972,   219,   949,   823,  1143,   819,   713,   306,  1061,
       1,   913,  2041,  2041,   766,   738,  2191,  2163,  2163,  2163,
    2041,   738,   819,   819,  2163,   819,   819,   109,   154,  2145,
    1058,  1012,   982,     1,   819,  1010,   390,  1034,    37,   960,
     960,   455,   616,   959,   959,   488,  2175,  2163,   404,   974,
     819,   610,  1411,  1412,  1416,   713,  1144,   819,   819,  1062,
    1018,   336,  1046,  2154,  2163,  2163,   913,  2034,  2087,   134,
    2034,  2163,  2163,   988,  1002,  2034,   984,   913,  1041,  1042,
    1205,   913,  1036,  1037,  1038,  2042,  2163,   455,   556,   559,
    1013,  1015,  1016,  1800,  2093,  2163,   913,   455,   965,   966,
    2163,   955,   819,   819,  2163,   118,   769,   821,   973,   692,
     819,   219,  1441,  1442,   819,   303,   708,  1140,  1145,  1146,
    1148,   417,   717,  1063,  1122,  1123,  1019,  1022,  1023,  2154,
    2163,    23,   498,  2034,   455,   390,   555,  2215,   455,   842,
     108,   480,   614,   716,   913,   989,   990,   991,   992,   993,
     997,   998,  1000,  2144,  2186,   349,   614,  1003,  1004,  1005,
     985,  1000,  1042,  2163,  1037,    31,   409,  2042,  2165,  2041,
    1800,   409,   766,  2182,  2163,   169,  2041,   819,   624,   961,
     966,  2163,    48,   503,   504,   505,   619,   835,   836,   849,
    2126,  2163,  1413,     1,     5,    10,    17,    26,    87,    88,
     117,   137,   141,   159,   200,   206,   208,   212,   216,   233,
     270,   286,   296,   344,   352,   355,   360,   387,   395,   397,
     400,   403,   418,   483,   489,   491,   494,   509,   561,   584,
     625,   631,   635,   638,   639,   655,   671,   677,   684,   690,
     709,   723,   729,   747,   761,   771,   772,   779,   782,   797,
     819,   845,   857,   863,   887,   917,   922,  1443,  1444,  1472,
    1477,  1482,  1487,  1513,  1517,  1525,  1529,  1530,  1534,  1537,
    1542,  1547,  1598,  1602,  1604,  1609,  1625,  1629,  1632,  1635,
    1639,  1640,  1647,  1657,  1660,  1663,  1681,  1690,  1694,  1696,
    1700,  1703,  1707,  1721,  1735,  1737,  1741,  1756,  1757,  1767,
    1770,  1771,  1775,  1781,  1782,  1790,  1797,  1814,  1824,  1833,
    1836,  1842,  1853,  1857,  1859,  1862,  1865,  1868,  1879,  1898,
    1906,  1931,  1443,   915,  1195,  1197,  1198,     1,   913,  2022,
     819,   530,   562,  2123,    30,   493,   668,   701,  1124,  1125,
    1126,  1127,  1129,  1130,  1131,  1136,  1020,  1021,    23,   498,
     379,   455,   471,   629,   752,   829,   927,  1044,  1045,  2097,
     912,  1050,  2206,  2087,   725,   744,  2194,  2163,   819,   991,
     819,   913,   990,   112,   121,   994,  2146,    16,   351,   913,
    1006,   913,     1,   819,  1005,   986,  2206,    16,   379,   455,
     471,   629,   752,   829,   927,  2098,  2099,  2100,   455,  1039,
    2094,  2182,   409,  2041,  2041,  1014,  1015,   819,   138,   300,
     647,   675,   825,   962,   963,   964,   503,   504,   619,   849,
     975,    85,   487,   575,   764,   769,   821,  1494,  1495,     5,
      10,    17,    26,    87,    88,   117,   137,   141,   159,   200,
     212,   216,   236,   241,   242,   243,   244,   246,   247,   248,
     249,   251,   253,   254,   255,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   270,   286,   296,   344,
     352,   355,   360,   387,   395,   397,   400,   403,   483,   489,
     491,   494,   509,   561,   584,   635,   655,   677,   684,   690,
     709,   729,   747,   761,   771,   772,   779,   782,   797,   819,
     845,   857,   863,   917,   922,  2130,  2131,  2132,  1445,  1473,
    1478,  1483,  1488,  1514,  1518,   844,  1834,  1835,  1526,  1531,
    1538,  1535,  1543,  1548,  1599,  1603,   336,  1605,  1610,  1626,
    1630,  1633,  1636,   353,   678,  1505,  1628,  1641,  1648,  1658,
    1661,  1664,   352,   582,  1695,  1697,  1701,  1704,   724,  1708,
    1722,  1736,  1738,  1742,  1758,  1768,  1772,  1776,  1834,  1783,
    1791,  1798,  1815,  1825,  1835,   455,   629,   699,   752,   804,
     927,  1840,  1841,  1990,  2081,  2082,  2087,  1843,  1854,   608,
    1858,  1860,  1430,  1863,  1866,  1869,  1880,  1899,   352,   582,
     713,   139,  1176,   232,   730,   743,  1199,  1200,  1202,  1213,
    1215,  1217,  2115,   819,  1147,   562,  2041,   137,   166,   183,
     184,   299,   464,   475,   603,   642,   659,   918,   919,  1132,
     559,  1137,  2180,   640,   747,   748,  1128,     1,   819,  1126,
    2163,  2163,   390,  1045,  1047,   806,   590,  2163,  2093,   819,
    2163,   727,   406,   960,     1,   351,   406,   960,   819,   819,
     194,  2100,   815,  2094,  2041,   964,  2186,   138,   912,  1491,
     558,   913,  1446,  1449,  1450,  1451,  2023,  2081,    11,   151,
     157,   158,   167,   173,   339,   340,   341,   351,   437,   438,
     439,   446,   448,   459,   460,   461,   468,   487,   551,   577,
     680,   777,   778,   792,   848,   874,   882,   907,  1474,  2014,
    2046,  2047,  2049,  2050,  2081,  2098,  2102,  2103,  2104,  2105,
    2223,   827,   831,   832,  1479,  2009,  2010,  2011,  2012,  2013,
    2014,  2050,  2053,  2081,  2099,  2102,   455,  1484,  1485,  2030,
    2031,  2032,  2087,  1489,  1494,   455,   616,  1515,  1516,  2066,
    2081,   911,  1519,  1520,  1522,  2022,    11,  1527,  2014,  2015,
    2016,  2044,  2084,  2085,  2087,  2099,    14,  1532,   823,  1539,
    2022,    16,  1536,  2081,  2083,   398,   416,   569,   796,  1544,
    1546,   281,   333,   391,   455,   484,   558,   756,   780,   825,
     911,  1549,  1550,  1551,  1552,  1554,  1561,  1563,  1564,  1565,
    1568,  1573,  1576,  1577,  1580,  1582,  2046,  2066,  2081,  1600,
    2047,  1544,   355,  1494,  1607,   822,   833,  1611,  1612,  1613,
    1994,  1995,  1996,   349,   580,   584,   614,   713,  1627,  1631,
    2043,  2044,  1634,  2087,   814,  1637,  2202,  2047,     1,  1993,
    1994,  1649,  2043,   913,  1659,  2024,   160,   911,  1352,  1585,
    1662,  2081,  1665,  1666,  2081,  2098,  2102,  1682,  1691,  1816,
    2075,  2076,  2087,  1352,  1585,  1698,   167,  1702,  2047,  1705,
    2047,   295,  1709,  1710,  1711,   390,  1723,  1988,  2156,   913,
    2023,   291,  1739,  2081,  1743,  2022,  1759,  2023,  1769,  2017,
    2087,  1773,  2022,   823,  1777,  2017,  2018,    16,  1784,  2019,
    2087,  1792,  2023,   274,   427,   487,  1799,  1802,  1803,  1806,
    1807,  1808,  1809,  1810,  1811,  1812,  1813,  1990,  2025,  2026,
    2043,  2074,  2076,  2087,  1816,  1826,  2022,  1837,  2081,   831,
    2091,  2092,  1844,  1845,  1846,   167,   792,  1855,  2046,  1861,
    2024,   819,   913,  1431,  1432,  1435,  1436,  1441,  1864,  2077,
    2081,  1867,  2022,   455,  1870,  2067,  2081,  2102,  1881,  2081,
    1900,  2018,  1907,  1932,   819,   713,   462,  1278,  1205,  1205,
    1205,  1200,   819,     1,   315,  1203,  1204,  1205,   442,  1149,
    1064,  2180,  2202,  2202,   555,  2179,  2180,  2180,  2202,  2180,
    2180,  2202,  2180,  2180,   823,  2153,   290,  2152,   455,  1076,
    2087,    32,  2136,   819,    39,   228,   379,   455,   458,   471,
     501,   629,   752,   757,   758,   927,  1024,  1026,  1027,  1028,
    1031,   852,   884,   885,  1025,  1026,   913,  1089,  2097,   455,
    2093,   458,   786,   881,   999,  2037,  2088,  2089,   995,   488,
    2100,  1492,   107,   883,  1417,   241,  1471,  1447,    41,    55,
     346,   488,  1455,  1456,  1457,  1461,  1464,  2139,  2140,  2206,
     831,  1452,   484,  2174,   345,  2179,  2081,   831,   831,   831,
    2107,   831,  2215,  2215,   831,   831,   831,   831,  2215,  2075,
     831,  2107,   242,  1476,   814,  1475,  2047,  2082,  2099,  2102,
     831,  2106,   831,   831,  2013,  2081,  2009,  2013,   109,   827,
     832,   818,   828,   297,  2082,  2099,  2102,   396,  2118,  1485,
     814,  2215,   243,  1512,  1988,  1516,  1523,  2022,   649,   856,
    1521,  2206,  2221,  2179,   244,  1528,   280,   820,  2016,  2212,
     691,  2124,  2091,  2092,  1533,  1540,  2022,   246,  1541,   640,
    2188,   161,  2148,  2081,   796,  2199,   796,  2023,  1562,   361,
    1583,    78,  2142,   247,  1597,   291,   541,  1946,  1948,  1950,
    1552,  2045,  2046,  1553,   912,  1555,  1452,  1574,  1583,   869,
     870,   871,   872,   248,  1601,    83,   405,   814,   455,   249,
    1624,    25,   906,  1614,  1615,  1616,  1618,    28,   297,   409,
     530,   564,   816,   818,   827,   828,   831,   832,  1997,  1998,
    2000,  2047,  2163,   182,  1628,  2044,   270,  2029,   803,  1643,
    1650,  2206,  2024,  2081,     8,    15,    45,    66,    67,    68,
      69,    70,    71,    72,    73,    81,    86,    97,    98,    99,
     100,   114,   124,   127,   128,   129,   131,   165,   174,   175,
     176,   177,   178,   179,   180,   181,   187,   188,   213,   214,
     217,   218,   222,   234,   245,   269,   273,   288,   293,   294,
     310,   311,   312,   313,   314,   317,   356,   357,   358,   359,
     365,   366,   368,   370,   371,   372,   375,   376,   378,   382,
     401,   402,   410,   411,   412,   413,   414,   415,   424,   428,
     429,   432,   470,   474,   476,   477,   478,   479,   486,   502,
     510,   545,   546,   578,   581,   592,   598,   602,   604,   605,
     618,   621,   622,   627,   641,   643,   644,   652,   653,   672,
     673,   674,   693,   694,   695,   696,   698,   702,   703,   710,
     711,   718,   719,   720,   726,   731,   749,   762,   763,   768,
     790,   791,   799,   807,   813,   843,   850,   890,   896,   897,
     899,   902,   909,   921,   924,  1357,  1359,  1361,  1363,  1365,
    1367,  1369,  1371,  1374,  1376,  1378,  1379,  1381,  1383,  1384,
    1386,  1388,  1391,  1392,   430,   744,   812,  1393,  1394,   163,
     661,   793,  1667,  1668,  1670,  1671,  1683,  2081,  1692,  2081,
    1818,   831,  2091,   530,   773,  1354,  1355,  1356,  1357,  2122,
    1393,   253,  1699,  2047,   814,   254,  1706,    83,  1710,   298,
     398,   416,   569,  1712,    84,   338,   455,  1207,  1728,  1729,
    1730,  2030,  2050,  2068,  2081,  2087,  2098,  2102,  2206,   804,
     913,  1740,   257,  1755,   509,   601,  2121,   258,  1766,   484,
     715,  1760,   345,  1901,   259,  1774,  2188,   913,   260,  1780,
    1901,  2019,   261,  1789,   893,  1785,   345,  1793,  1794,  2060,
    2064,  2081,  2099,  2102,   291,  1809,  1811,  2043,   609,   814,
    2026,   225,   814,   865,  1801,    42,  2091,   262,  1832,   318,
     421,   427,  1828,  1505,  1838,  2047,  2206,  2007,  2009,   831,
    2092,   263,  1852,   405,  1847,  1848,  2047,  2081,  2075,   264,
    1856,   345,  2024,   713,   819,   819,   345,   640,   646,  2189,
     265,  1878,   201,  1871,  2081,   266,  1905,  1901,  1908,  2081,
    1933,  2081,  1196,   819,   713,   453,  1280,  1216,  1218,   658,
     819,   819,  1201,   154,    76,   120,   186,   423,   445,   640,
     645,   662,   664,   819,   889,  1150,  1151,  1153,  1157,  1158,
    1161,  1162,  1168,  1171,  1173,  1174,  2163,     1,  1065,  1066,
    2033,  2034,  2034,  2093,  2093,  2020,  2022,  2020,  2093,  2020,
    2020,  2034,  2020,  2020,   795,  2198,   240,  1138,  2093,  2154,
    2037,  1028,    25,   806,   109,   490,   914,  2219,   913,  2090,
     996,  2154,  2163,    85,   575,   769,  1493,  1419,  1418,   678,
    1427,  1455,   927,  2069,  2074,  2093,  2163,  1457,   122,   126,
     447,   596,   597,  1462,  1463,  2211,   809,    44,    49,    50,
      51,    52,    56,    75,   123,   160,   162,   174,   197,   337,
     347,   377,   435,   466,   469,   513,   520,   556,   572,   620,
     623,   666,   679,   681,   682,   701,   706,   714,   756,   789,
     810,   854,   866,   873,  1465,  1468,  1469,  1470,  2149,  2187,
     136,   455,  1453,  1454,  2055,  2081,  2081,   168,    34,    35,
     125,   132,   135,   189,   191,   192,   274,   276,   283,   291,
     398,   447,   451,   704,   787,   798,   809,   880,   913,  1460,
    2026,  2209,   270,   614,  2058,  2082,   814,  2007,  2009,  2113,
    2007,  2114,   816,  2007,  2109,  2110,   913,   913,  2009,  2112,
    2112,  2112,  2052,  2081,  2099,  2102,  2111,   913,   814,  2052,
    2108,    11,  2014,  2015,  2047,  2087,  2099,   353,  2009,  2052,
    2007,   816,   396,  2119,  2010,  2010,  2011,  2011,  2011,   457,
    1480,   612,  1486,  2032,  1496,  1497,  2067,  2081,  1521,   463,
     513,  2154,  2082,  2009,   488,  2125,  2092,  2009,  2022,   676,
    1748,  1749,  1750,  1545,  2206,  1555,   911,  2046,  1438,  1439,
    1438,  1949,  1950,  1947,  1948,   868,  1461,  1464,  1557,  1558,
    1559,  2206,    49,    50,    51,    52,    56,    74,    75,   123,
     162,   281,   337,   377,   469,   572,   701,   706,   744,   756,
     854,  1469,  1556,  1596,   281,  1566,  1567,  2081,  2099,   868,
    1584,   911,  1946,  1946,  1946,  1946,  2047,  2015,  2047,  1606,
    1491,  1613,  1619,   906,  1616,  1617,   249,   819,   906,  1438,
    1999,  2000,  1998,    20,    21,    22,   113,   280,   362,   363,
     440,   441,   506,   540,   549,   558,   599,   820,   824,   826,
    2001,  2002,  2003,  2004,  2005,  2006,   455,  2027,  2028,   203,
    1638,  2030,   236,  1642,  1644,    16,    20,    23,    24,   498,
     499,   549,   550,  1651,  1655,   315,  1390,  2093,   390,   820,
    2157,  1392,  2157,  2157,  2157,  1394,  2062,  2082,  2086,  2099,
      16,   109,   318,   431,   842,  1674,  1675,  1676,  1669,  1670,
     252,  1689,   345,  1689,   405,  1820,  2180,  2206,   409,   820,
    2164,  1355,    31,   409,   820,  2166,     3,    12,    27,    46,
      77,    78,    79,    82,    89,   101,   103,   104,   130,   185,
     198,   220,   221,   223,   224,   268,   284,   321,   322,   323,
     343,   348,   373,   374,   380,   381,   434,   436,   452,   465,
     466,   467,   492,   515,   516,   517,   519,   521,   522,   524,
     526,   527,   531,   533,   534,   535,   536,   549,   557,   570,
     571,   579,   585,   632,   637,   688,   689,   697,   721,   734,
     735,   736,   737,   754,   755,   765,   794,   808,   809,   846,
     855,   862,   873,   877,   878,   879,   894,   895,   900,   901,
     903,   910,  1358,  1360,  1362,  1364,  1366,  1368,  1370,  1372,
    1373,  1375,  1377,  1380,  1382,  1385,  1387,   814,  2043,  2015,
    2047,   733,  1713,  2179,   367,  1989,  1989,   864,   893,   806,
       1,    58,    59,    60,    61,    63,   143,   144,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   455,   594,   617,
    1208,  1209,  1210,  1211,  1212,  1242,  2056,  2082,   811,   800,
    2188,   405,  2073,  2081,  2098,  2102,   405,  1744,  1748,   240,
    1786,  2081,  1786,  2081,  1795,  2206,   814,   814,   814,   814,
    1800,    11,   270,   744,   822,   833,  2047,    83,    56,    75,
     377,   435,   469,   572,   681,   854,  1804,  1805,  2163,  1827,
    2206,  2047,   282,   529,   136,   722,   816,  2008,   817,  2009,
    2081,  1848,   201,  1849,   345,   345,  2015,  2047,  1433,  2060,
      83,  2143,   405,  1874,    14,    55,  1902,  1903,   267,  1930,
     345,  1930,  1935,  2206,  1197,  1177,   819,   713,   662,  1282,
     889,  1270,  1230,  1231,  2163,  2115,    29,    54,    57,    58,
      59,    60,    61,    63,    64,    74,   140,   142,   143,   145,
     146,   147,   148,   149,   150,   212,   324,   325,   326,   327,
     328,   332,   367,   392,   419,   498,   554,   573,   589,   594,
     617,   648,   701,   738,   740,   741,   742,   785,   859,   860,
     861,   875,   898,  1223,  1224,  1225,  1226,  1227,  1228,  1231,
    1232,  1235,  1236,  1240,  1241,  1242,  1245,  1248,  1265,  1266,
    1268,  1269,  1270,  1275,  1276,  1277,  2163,  2193,  1206,  2163,
     155,  2147,  2163,   640,   646,  2220,  2220,  2163,  2147,  2163,
    2175,  2163,    31,  2135,   555,  1175,  2041,   300,   354,   819,
       6,     9,    27,    40,   308,   309,   393,   447,   525,   566,
     574,   640,   654,   669,   733,   747,   819,   823,   839,   840,
    1067,  1068,  1077,  1079,  1084,  1085,  1088,  1090,  1091,  1092,
    1093,  1099,  1100,  1101,  1102,  1105,  1111,  1112,  1114,  1116,
    1118,  1119,  1120,  1121,  2146,  2188,  2214,  2034,  2180,  2180,
     837,   838,  2224,  2022,  2180,  2180,  2147,  2179,  2179,   646,
    2020,  1029,  1031,  2215,    23,   498,  2037,   453,  1420,  1421,
    1422,  2143,  1420,   558,   913,   819,   283,   291,   539,   541,
    1939,  1941,  1942,  1944,  1945,    76,   547,  2177,  2177,   455,
    2070,  2074,  2095,  2163,  2163,  2163,  2163,    56,   230,  1470,
     108,   225,   865,  2203,    14,  2134,   421,   744,  1453,   136,
     827,   832,  1939,   926,   925,  2060,  1939,   421,  2168,   766,
     766,   547,  1448,   495,   455,  2059,  2082,  2081,  2008,   816,
    2008,   816,   816,   588,   816,  2052,  2008,   816,   816,   816,
    2008,   816,  2075,  2008,   816,  2179,   544,   745,  1961,  1963,
    1965,  2091,  2092,  2015,   817,   816,   816,   814,  2120,  1480,
    2093,   678,  1481,   814,  2030,  1490,   507,   616,  1498,    37,
    1524,  2206,   683,   657,  1961,  2163,   712,   338,  2154,   408,
     542,  1982,  1983,  1985,  1987,   421,  1578,  1569,  1440,   169,
     170,   606,   913,  1560,  2026,  1558,   514,  1596,  2164,   447,
     704,  2163,   277,   279,  1395,  1396,  2151,  2202,  2164,   225,
    2203,  2163,  1596,  1567,  2081,  1575,  1581,   353,  1961,   353,
     455,  1608,   883,  1499,     1,    29,   822,   833,  1621,  1622,
    1995,   567,  1620,   927,  2001,  2202,  1638,  2028,  2180,  1645,
     251,  1646,  1438,  2202,   661,  1652,  2202,  2081,  2081,  2081,
    2081,   814,    83,  1675,  1677,  2062,    16,   109,   431,   842,
    1672,  1673,  2060,  2078,  2081,  2081,  2081,  1085,  1821,  2146,
      38,   204,  1260,   226,  1389,  2081,  2093,  2046,  2043,  1961,
     353,  2206,  1748,  1208,  2156,  1729,  1724,  1725,   296,  1731,
    1993,  1732,  1733,  2081,  2030,   819,  1903,  1744,  2081,  2081,
     240,   537,  1971,  1974,  1976,  1778,  1779,  2206,  1438,   906,
     906,  1787,  1788,  1902,   231,   237,   285,  2081,  2060,   556,
     927,  2071,  2072,  2074,  2093,  2179,  2059,   555,  2047,  1800,
    1800,  1800,  1800,  1800,  1800,  1800,  1800,  1805,   530,   540,
    1829,  1830,  1831,  2002,  2122,  1982,   437,   744,  2222,   766,
    2196,  2196,  2009,   816,  2009,  1851,  2206,  2143,  2081,  2075,
    1961,   353,  1437,  2093,   814,    16,  1872,  1873,  2116,  1875,
    2081,  1851,  1875,  1748,    13,  2133,  2081,   678,  1936,   239,
    1178,  1279,   819,   713,   704,  1339,  2165,   889,   354,  2087,
     437,   549,   739,   858,  2192,   858,  2192,   858,  2192,   858,
    2192,   858,  2192,   906,  2204,  2179,   687,  2190,   227,  1251,
    2093,   458,  1237,  2082,    37,  2138,   409,   434,   687,  1267,
    2163,  1225,   300,   301,   385,   753,   431,   842,   345,  1219,
    2138,   354,  2093,  1089,  2165,  2165,   913,  2038,  2039,   558,
     756,  2216,   455,  2034,  2040,  2093,   893,  2163,   307,   384,
     913,  1159,  2041,  2175,  2168,  2188,  2202,   728,  2168,  2163,
    2144,   202,  2168,  2168,   513,  1113,  2093,  2206,  2163,  2163,
     766,   463,   727,    57,  2141,  2165,  2020,  2020,  2180,  2020,
    2020,  1133,  1134,  2022,  2221,  2022,  1030,  1031,  2090,  2163,
    2163,  2037,  1421,   744,   858,  1423,  1424,   650,   889,  1414,
    1943,  1944,  1466,  1467,  2078,  2081,  1940,  1941,  1438,  2069,
    2069,  2069,  2069,  2070,  2069,  2163,  1991,  2072,  1991,  2070,
    2156,  2163,   816,   816,  1453,  2055,  2055,  1939,   744,  1458,
    1459,  1461,  2124,   788,  2106,   788,  2106,   816,  2034,  2106,
    2106,  2106,  2052,  2124,   431,   842,  2106,  2082,  1438,  1438,
    1964,  1965,  1962,  1963,  2092,  1961,   816,  2009,  2106,  2106,
    2065,  2081,  2098,  1481,  2044,  1989,   513,  2126,  2009,  1438,
    1438,  1986,  1987,  1984,  1985,  2066,  1584,   197,   383,   812,
     850,  1505,  1570,  1571,  1572,  1441,  2069,  2069,   447,   704,
     240,  2069,  1991,  1991,  2069,    77,    79,   367,   451,   595,
     732,   834,  1461,  1586,  1587,  1588,  1589,  1590,  1592,  1593,
    1594,  1595,  2206,  1586,  2015,  2016,  2015,  2016,  1500,    25,
     806,  1623,   249,   819,  1438,  1621,  2081,  1438,   236,   889,
    1653,  1654,  1655,   803,  1656,  2200,   889,  2063,  2086,  2098,
    2060,    83,    14,    55,  1678,  1679,  1680,  1673,  1678,   336,
     168,  1992,  1693,  2206,  1817,   727,  2168,   390,   565,  2158,
    2015,    16,   513,   635,  1115,  2020,  2081,  1438,   255,   819,
    1727,    14,   345,    13,   389,  1745,  1746,  1747,  1749,  1752,
    1779,  2206,   186,   518,  1761,  1763,  1765,  1438,  1438,  1975,
    1976,  1974,  1982,   463,   513,  1994,  1993,  1787,   661,  1796,
     304,   305,  2047,  2002,  2081,  2003,  2004,  2005,  2006,  2009,
    1839,  2047,  1839,   816,   543,   830,  1966,  1968,  1970,   594,
     744,  1850,  2047,  2124,  2124,  2015,   819,  2061,  2065,   564,
    2060,   202,  1876,   793,  1877,  1778,   576,  2026,  2069,  1992,
     498,   888,  1937,  2064,    95,  1179,  1180,  1197,  1281,   819,
     713,    28,   297,   564,   816,   818,   827,   828,   831,   832,
    1207,  1222,  1272,  1273,  2163,   806,  1214,   927,     7,    53,
      65,   110,   133,   190,   272,   334,   342,   423,   430,   454,
     482,   626,   630,   707,   767,   780,   804,   847,   892,   905,
     911,   913,  1350,    90,  1253,   853,   814,  1249,  1238,  2163,
    2080,  2082,     1,   913,  1241,    37,  1229,  2143,  1233,   725,
    2127,  2127,   913,  1272,   814,  1156,   336,  1172,  2039,   451,
    2172,   814,  2145,  2156,   302,   319,   700,   851,   886,   891,
    1169,  1170,  2163,  2163,  2163,  2163,  2168,   227,   300,  1074,
    1075,  2163,   654,  1100,  2163,  2163,  2163,  2163,    32,    33,
    2137,  1115,  2040,  2093,  2163,  2175,   555,  1086,   728,  1117,
    2040,  2020,  1134,   597,  1135,    25,  2037,  2037,  2163,   744,
    1424,   562,  1426,   196,  1428,  1438,  2066,   447,   451,  2217,
    1467,  2071,   816,  2163,  1459,  1961,   345,  2128,   816,  1491,
     212,   712,   811,  1579,  2164,  2164,  2164,  2164,  2047,  1572,
    2179,   390,   409,  2167,  2069,  2136,  1587,   102,   434,   687,
    1591,   513,  1596,  1961,   656,  1961,   656,  1501,  1502,  1503,
    2143,  1622,  1994,  1645,  1654,   186,  2150,  2202,  1678,  1678,
    2063,   825,  2161,  2161,  1680,  1679,  2156,  1684,   495,  1917,
     207,   398,   883,  1822,  1819,   565,  1961,   567,  2183,  2183,
     560,    18,   211,   336,   433,   667,   682,   912,  1714,  1715,
    1719,  1720,  2206,  2207,   255,  1726,  1733,  2047,  2180,   463,
     421,  1753,  1751,  1752,  2206,   388,   420,   904,  1438,  1438,
    1764,  1765,  1762,  1763,   463,  1438,  1438,   447,  2169,  2179,
    2179,  1438,  1438,  1969,  1970,  1967,  1968,  2163,  1961,  2128,
    1961,   876,  1434,  1882,  1873,  2156,  1992,  2156,  1966,   278,
     538,  1904,  1977,  1979,  1981,  1983,   447,   451,  2170,  1909,
    2206,   613,  2041,  1197,  1197,  1283,   819,   806,  1271,  1273,
     509,   761,  1207,  1220,  1221,  1222,  2087,   199,   320,   425,
     481,   746,   841,  1243,   456,  1244,  2156,   345,  1250,   811,
    2201,  2093,  2201,   744,   913,  1239,   455,  2066,   169,   174,
     289,   705,  1234,  2144,  2093,   109,   646,  1152,  2033,  1163,
    2093,  2194,   455,  1160,  2087,  1160,   227,   633,   728,  1078,
    2034,  2163,    91,    92,    93,   209,   210,   212,   398,   399,
     422,   447,   472,   569,   602,   606,   607,   633,   795,  1069,
    1070,  1071,  1072,  1073,  2034,  2040,  1103,  2034,  2034,  2145,
    2224,  2034,  2163,  2034,  1087,  2154,  2163,  2040,   806,  2093,
    1031,  2154,  2154,    44,   197,  2093,  2163,   913,   819,  1415,
    2071,   392,  2159,   205,  2129,  1499,  1586,  2047,  2047,  2047,
    2047,  2081,  2164,   812,   706,   916,  2016,  2016,  1502,   558,
    1423,   156,   650,   889,  1438,    83,   197,  1678,  2047,  2047,
    2081,  1917,  2179,   783,  1686,   610,  2020,   353,   569,  1823,
    2087,    16,   513,   636,   867,   920,  1717,  1718,  1719,   513,
      80,   463,   474,  1716,    83,  1734,   463,  2163,  1754,  1972,
    1974,  1976,  1982,   463,   463,  2022,  2022,  2081,  2129,  1883,
     819,  2081,  2081,  1438,  1438,  1980,  1981,  1978,  1979,  1911,
    1912,  1913,  2206,   823,  1938,  2017,   610,  1181,  1284,  1340,
    1207,   906,  1274,  2205,  2179,  1222,   913,  2093,   814,  1249,
     203,   203,  1252,  2163,   766,    77,   834,  1164,  1165,  1166,
    1167,  2206,  2145,   345,  1155,  2155,  2034,   345,    13,   883,
     893,  2087,  2098,  2225,    62,   450,   757,   913,  1104,   750,
     820,  1106,  1107,  2034,  2035,    47,   295,   473,  1094,  2163,
      23,   498,  1089,   806,  2040,   498,    23,    44,  1425,  2206,
    1429,  1430,  2071,  2159,  1961,  1504,  1505,  2081,  2164,  1961,
    1961,  2048,  2049,  2079,  2082,  2047,  1686,  1918,  1919,  2081,
    1687,  1688,  2081,   291,   541,  1956,  1958,  1960,  2163,  2020,
     610,   568,  2184,   683,   455,  2050,  2054,  2057,  2081,  2102,
     864,  2081,  1975,  1973,  1974,  1961,    41,   229,   292,   354,
    1884,  1885,  1886,  1888,  1892,  1894,  1895,  1896,  1897,  2139,
    2154,   496,  1915,  1913,    43,   239,   923,  1914,   913,  2163,
    1182,   634,  1285,  1202,  1217,  1341,  1342,  1343,   729,   822,
    2081,   396,  1254,  2180,  2180,   393,  1255,  1257,  1258,  1259,
    1260,  1262,  2093,  2040,  2040,   335,  1156,  2093,  1106,  2087,
    2153,  2087,  2163,   583,  1080,  1081,  1108,  1109,   912,  1095,
    1097,  2206,  1098,  2206,  1095,  1089,  2163,  2163,  1089,  2040,
    2163,  2163,   480,  1430,   814,  2071,   291,   541,   830,  1507,
    1509,  1511,    11,   405,   532,   558,   829,  1506,  2162,  2047,
    1685,  1919,  2163,  1688,  1438,  1438,  1959,  1960,  1957,  1958,
    1728,  2163,  2082,  2099,  2102,  1993,    55,  2134,  1896,  1740,
     614,   194,  2163,  1917,  2064,  1728,   819,  1183,  2154,  2024,
       1,  1204,  1343,   819,   814,  2163,  1255,  2034,  2034,  2143,
    1262,  1258,  2168,  1256,  2139,  2145,  2117,  2206,  1082,  2117,
    1110,  2034,  1110,   463,  2173,   690,   474,  1089,  1089,  2037,
    2037,   744,   240,  2071,  1438,  1438,  1438,  1510,  1511,  1508,
    1509,  2179,  2081,  1956,  2098,  1728,   663,   756,  2195,   823,
    2021,   240,   761,  1893,  2180,  2064,   850,  1920,  1934,   569,
    2161,  1286,   819,  1344,  1345,   819,  1207,  1255,  1263,  1264,
    2088,  2163,  1257,  2040,   203,  1154,  1080,   226,   513,  2163,
     559,  2154,  2154,  2163,   196,  2081,  2081,   282,   291,  2213,
    2022,   823,    16,  1889,  1890,  2082,   497,  1916,  2179,   783,
    1925,   291,   541,  1951,  1953,  1955,   205,   282,   766,   784,
     801,  1188,  1189,  1190,   398,   416,     1,  1287,  1347,   552,
    1349,  1350,  1264,  2036,  2037,  2180,   782,  1083,   226,  2034,
     493,   640,   646,  2218,   498,    23,  2070,   819,   610,  2185,
    2022,   555,   611,   651,  1891,  1890,  2163,  1921,  1922,  2081,
     290,   908,  1926,  1927,  2081,  1910,  1438,  1438,  1954,  1955,
    1952,  1953,   168,   792,  2163,   421,   421,   205,   437,  1190,
     240,   484,   766,   784,   801,  1184,  1185,  1186,  1187,  2081,
    2174,  2197,   240,   484,   766,   801,  1191,  1192,  1193,  1194,
    2081,  2197,   819,   160,   161,   576,   819,  1288,  1289,  1294,
    2163,  2206,  2233,    44,    49,    50,    51,    52,    56,    74,
      75,    94,   115,   123,   171,   281,   337,   345,   347,   364,
     377,   435,   447,   451,   469,   513,   554,   572,   620,   666,
     714,   744,   756,   789,   814,   825,   854,   883,  1236,  1240,
    1245,  1265,  1268,  1270,  1348,  1409,  1410,  1468,  1469,  2163,
    2211,  1351,  2081,  2093,  1346,  2037,  2034,   906,  2218,  1096,
    1097,  2163,  2163,  2180,   555,  2080,  2064,  1922,  2163,    42,
     156,   235,   528,   549,  1924,  1928,   379,   471,   752,   927,
    1929,  2101,  1927,  1951,  2163,   554,  2081,  2163,  2163,  2163,
    2163,   421,   189,   809,   421,   437,  1186,  2081,   168,   628,
     750,   774,   775,   776,   421,   189,   809,   421,   437,  1193,
    2081,   796,  2165,  2165,   443,   444,  2171,  1305,   354,   119,
     316,  1290,  1291,  1292,  1293,  2081,  2163,   447,   704,  1407,
    2177,  1405,  2177,  2163,  2164,  1395,  1396,  2163,  2073,  1405,
    2164,  2093,   108,  2164,  2081,  2081,   354,  1407,  1353,    16,
     455,   752,   927,  1032,  1096,  1089,  1089,   298,   398,   416,
     569,  1887,  2020,  1924,  1923,  1924,  1923,   564,  2081,  2093,
    2081,  2081,  2081,  2081,  2163,  2163,  2163,  2163,  2163,  2081,
    2163,  2163,  2163,  2163,  2163,  2163,  2163,  2163,  2163,  2163,
    2163,  2081,  2163,  2165,  2165,   927,  1295,  1296,  1297,  2081,
    2093,  2096,  1202,  1306,  2163,  1292,  1293,  2069,  2163,  2163,
    2069,  2078,  2093,  2069,  1402,  2069,  2201,  2163,  2078,  2093,
    1348,  1355,  2100,  2101,  2201,  2081,  2081,  2081,  2081,  2081,
    2081,  2081,  2081,  2081,  2081,  2081,  2081,  2081,  2081,  2081,
    2081,  2081,  2081,  2081,  1298,   447,   451,  2170,  2209,  2217,
       1,  1204,  1205,  2066,   485,   593,   827,   832,  1398,  1399,
    1400,  1401,  1408,  1398,  1400,  1406,    96,   591,  1403,  1404,
    2066,  1261,  1262,  2081,  2081,   318,   335,   369,   427,   449,
    1299,  1300,  1301,  1302,  1303,  1304,  1296,  1297,   819,  1307,
    2069,  2069,  2081,  2081,   193,   207,  2226,  2163,  2163,   106,
     160,  2226,  2227,  2163,  1308,  2081,  2163,  1297,  1297,   369,
    2163,  2163,  1297,     4,   122,   126,   365,   447,   451,   511,
     554,   600,   750,   781,   819,   850,   893,  1236,  1240,  1245,
    1246,  1265,  1268,  1270,  1309,  1310,  1315,  1318,  1321,  1322,
    1325,  1326,  1327,  1330,  1331,  1337,  1338,  2208,  2209,  2210,
    2081,  1297,  1297,  1297,   394,  2160,   548,  2177,  2178,  2135,
    2163,  2093,  2163,  2179,  2163,  2081,    14,    55,   419,   906,
     512,  1328,  1329,  1397,  1398,  1334,  1335,  1336,  1398,  2093,
    2178,  2081,  2165,   509,   512,   576,  1316,  1317,  1398,  2093,
    1249,  2053,  2051,  2053,   105,   160,   576,   586,   587,   662,
     685,   686,  1311,  2226,  2227,  2228,  2229,  2230,  2231,  2232,
     345,   508,  2176,  2176,    14,    55,  1993,  1328,  2096,  1335,
    2096,   101,   434,   687,  1332,  1333,  2081,  2093,  2201,  2124,
     670,   868,  1319,  2053,   335,   335,   369,   335,   369,   336,
     559,  2181,  2181,  2053,   564,   576,  1323,  1324,  2081,  1323,
    2176,  2176,  2165,  2081,  1252,  2180,  2081,   316,  1312,  2081,
      16,   316,  1314,  2081,    83,  1323,   576,   576,   770,  1247,
     316,  1320,  2081,   564,  1313,  1313,  1313,  1313,  2053,  2093,
     576
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   929,   931,   930,   932,   932,   934,   933,   935,   935,
     936,   936,   938,   937,   939,   940,   941,   941,   942,   942,
     944,   943,   946,   945,   948,   949,   947,   950,   950,   951,
     952,   952,   954,   955,   953,   957,   956,   958,   958,   959,
     959,   960,   960,   961,   961,   961,   962,   962,   962,   962,
     963,   963,   964,   964,   964,   965,   965,   966,   967,   967,
     968,   969,   969,   970,   970,   970,   970,   971,   971,   972,
     972,   973,   973,   973,   974,   974,   975,   975,   975,   975,
     976,   977,   977,   978,   979,   979,   980,   980,   981,   981,
     982,   982,   982,   982,   982,   984,   983,   985,   985,   986,
     986,   988,   987,   989,   989,   989,   989,   990,   990,   991,
     991,   991,   991,   992,   993,   995,   994,   996,   996,   996,
     996,   996,   996,   997,   998,   999,   999,   999,   999,  1000,
    1000,  1002,  1001,  1003,  1003,  1003,  1004,  1004,  1005,  1005,
    1005,  1005,  1005,  1006,  1006,  1007,  1008,  1009,  1009,  1009,
    1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,
    1010,  1010,  1010,  1010,  1012,  1011,  1013,  1013,  1013,  1013,
    1014,  1014,  1015,  1016,  1016,  1018,  1017,  1020,  1019,  1021,
    1019,  1022,  1022,  1023,  1024,  1024,  1024,  1024,  1024,  1025,
    1025,  1025,  1025,  1026,  1026,  1026,  1027,  1027,  1028,  1028,
    1029,  1028,  1030,  1030,  1031,  1031,  1031,  1031,  1031,  1031,
    1032,  1032,  1033,  1034,  1034,  1035,  1036,  1036,  1037,  1038,
    1038,  1039,  1039,  1040,  1041,  1041,  1042,  1043,  1044,  1044,
    1045,  1045,  1046,  1046,  1046,  1047,  1047,  1048,  1049,  1050,
    1050,  1051,  1052,  1053,  1054,  1055,  1056,  1058,  1057,  1059,
    1060,  1060,  1061,  1061,  1062,  1062,  1064,  1063,  1065,  1065,
    1066,  1066,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1068,  1068,  1068,  1068,  1068,  1069,  1069,  1069,  1070,
    1070,  1070,  1070,  1070,  1070,  1070,  1071,  1071,  1071,  1071,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1073,  1074,  1074,
    1075,  1075,  1076,  1076,  1077,  1078,  1078,  1078,  1079,  1080,
    1080,  1082,  1081,  1083,  1083,  1083,  1083,  1084,  1086,  1085,
    1087,  1087,  1087,  1087,  1087,  1087,  1088,  1089,  1090,  1091,
    1091,  1091,  1093,  1092,  1094,  1094,  1094,  1095,  1095,  1095,
    1095,  1096,  1096,  1097,  1098,  1098,  1099,  1099,  1100,  1100,
    1100,  1100,  1101,  1103,  1102,  1104,  1104,  1104,  1104,  1105,
    1106,  1106,  1107,  1107,  1109,  1108,  1108,  1110,  1111,  1112,
    1113,  1113,  1114,  1115,  1115,  1115,  1116,  1117,  1117,  1118,
    1119,  1120,  1121,  1122,  1122,  1123,  1124,  1124,  1124,  1125,
    1125,  1126,  1126,  1126,  1126,  1127,  1128,  1128,  1128,  1128,
    1129,  1129,  1129,  1129,  1129,  1130,  1130,  1130,  1130,  1130,
    1130,  1130,  1130,  1132,  1131,  1133,  1133,  1134,  1135,  1135,
    1136,  1137,  1138,  1138,  1140,  1139,  1141,  1141,  1142,  1143,
    1143,  1144,  1144,  1145,  1147,  1146,  1146,  1148,  1148,  1149,
    1149,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,
    1150,  1150,  1151,  1152,  1152,  1152,  1153,  1153,  1153,  1154,
    1154,  1155,  1155,  1156,  1156,  1157,  1158,  1158,  1159,  1159,
    1160,  1160,  1161,  1162,  1163,  1163,  1164,  1164,  1164,  1165,
    1166,  1167,  1168,  1169,  1169,  1169,  1169,  1169,  1170,  1170,
    1171,  1172,  1172,  1173,  1174,  1174,  1175,  1175,  1176,  1177,
    1176,  1178,  1178,  1179,  1181,  1180,  1182,  1182,  1183,  1183,
    1183,  1184,  1184,  1184,  1185,  1185,  1186,  1186,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,  1187,  1188,  1188,
    1189,  1189,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1191,
    1191,  1191,  1192,  1192,  1193,  1193,  1193,  1193,  1193,  1193,
    1194,  1195,  1196,  1195,  1197,  1198,  1197,  1199,  1199,  1200,
    1200,  1200,  1201,  1200,  1200,  1202,  1203,  1203,  1204,  1204,
    1205,  1206,  1206,  1207,  1207,  1207,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1209,  1209,  1210,  1210,  1211,  1211,  1211,  1212,  1212,
    1213,  1214,  1214,  1216,  1215,  1217,  1218,  1217,  1219,  1219,
    1220,  1220,  1220,  1221,  1221,  1222,  1222,  1222,  1222,  1222,
    1222,  1222,  1222,  1222,  1222,  1223,  1223,  1224,  1224,  1225,
    1225,  1225,  1225,  1225,  1225,  1225,  1225,  1225,  1225,  1225,
    1225,  1225,  1225,  1225,  1225,  1225,  1225,  1226,  1227,  1228,
    1229,  1229,  1230,  1230,  1231,  1233,  1232,  1234,  1234,  1234,
    1234,  1235,  1236,  1237,  1237,  1238,  1238,  1239,  1240,  1240,
    1240,  1240,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,
    1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,
    1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,
    1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,
    1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,  1241,
    1241,  1241,  1242,  1242,  1243,  1243,  1243,  1243,  1243,  1243,
    1243,  1244,  1244,  1245,  1245,  1246,  1247,  1247,  1248,  1248,
    1248,  1249,  1249,  1250,  1250,  1251,  1251,  1252,  1252,  1253,
    1253,  1254,  1254,  1255,  1255,  1256,  1255,  1255,  1255,  1257,
    1258,  1258,  1259,  1260,  1260,  1261,  1261,  1262,  1263,  1263,
    1264,  1265,  1266,  1267,  1267,  1267,  1268,  1269,  1271,  1270,
    1272,  1272,  1273,  1273,  1274,  1274,  1275,  1275,  1276,  1277,
    1278,  1279,  1278,  1280,  1281,  1280,  1282,  1283,  1282,  1284,
    1284,  1286,  1285,  1287,  1287,  1287,  1288,  1288,  1288,  1288,
    1289,  1290,  1290,  1290,  1291,  1292,  1292,  1293,  1294,  1295,
    1295,  1295,  1296,  1297,  1297,  1298,  1298,  1299,  1299,  1299,
    1299,  1299,  1299,  1300,  1301,  1302,  1303,  1304,  1305,  1305,
    1307,  1306,  1306,  1308,  1308,  1309,  1309,  1309,  1309,  1309,
    1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,  1309,
    1309,  1310,  1311,  1311,  1311,  1311,  1311,  1311,  1311,  1312,
    1312,  1312,  1313,  1313,  1314,  1314,  1314,  1314,  1315,  1316,
    1316,  1316,  1317,  1317,  1317,  1318,  1319,  1319,  1319,  1320,
    1320,  1321,  1321,  1321,  1321,  1321,  1322,  1322,  1323,  1323,
    1324,  1324,  1324,  1325,  1326,  1327,  1327,  1328,  1328,  1329,
    1329,  1330,  1331,  1332,  1332,  1333,  1333,  1333,  1334,  1334,
    1335,  1335,  1336,  1337,  1338,  1339,  1340,  1339,  1341,  1341,
    1342,  1342,  1343,  1344,  1343,  1345,  1346,  1343,  1343,  1347,
    1347,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1349,  1349,  1350,  1350,  1350,  1350,  1350,  1350,  1350,  1350,
    1350,  1350,  1350,  1350,  1350,  1350,  1350,  1350,  1351,  1351,
    1352,  1352,  1353,  1353,  1353,  1354,  1354,  1355,  1355,  1356,
    1356,  1357,  1357,  1358,  1358,  1358,  1358,  1358,  1358,  1358,
    1358,  1358,  1358,  1358,  1358,  1358,  1358,  1359,  1359,  1359,
    1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
    1359,  1359,  1360,  1360,  1360,  1360,  1360,  1360,  1360,  1360,
    1360,  1360,  1361,  1361,  1361,  1361,  1361,  1361,  1362,  1362,
    1362,  1362,  1363,  1364,  1364,  1364,  1364,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1367,  1367,  1368,
    1368,  1369,  1369,  1370,  1370,  1370,  1370,  1370,  1371,  1371,
    1371,  1371,  1371,  1371,  1371,  1371,  1371,  1371,  1371,  1371,
    1371,  1371,  1371,  1371,  1372,  1372,  1372,  1373,  1373,  1373,
    1373,  1373,  1373,  1373,  1373,  1374,  1374,  1374,  1374,  1374,
    1374,  1375,  1375,  1375,  1375,  1375,  1375,  1375,  1375,  1376,
    1376,  1376,  1376,  1377,  1377,  1377,  1378,  1378,  1378,  1378,
    1378,  1378,  1379,  1379,  1379,  1379,  1380,  1380,  1380,  1380,
    1380,  1380,  1380,  1381,  1381,  1381,  1381,  1381,  1381,  1381,
    1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,
    1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,
    1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,
    1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,  1381,
    1382,  1382,  1382,  1383,  1383,  1383,  1383,  1383,  1383,  1383,
    1383,  1383,  1384,  1384,  1384,  1384,  1384,  1384,  1384,  1384,
    1384,  1384,  1384,  1384,  1384,  1384,  1384,  1384,  1384,  1384,
    1384,  1384,  1384,  1384,  1384,  1385,  1386,  1387,  1387,  1387,
    1387,  1387,  1387,  1387,  1387,  1388,  1388,  1388,  1389,  1389,
    1390,  1391,  1391,  1392,  1393,  1393,  1394,  1394,  1394,  1395,
    1395,  1396,  1396,  1397,  1397,  1398,  1399,  1399,  1400,  1401,
    1401,  1402,  1403,  1403,  1404,  1404,  1405,  1406,  1406,  1406,
    1407,  1408,  1408,  1408,  1409,  1410,  1411,  1411,  1413,  1414,
    1415,  1412,  1416,  1412,  1417,  1418,  1417,  1419,  1417,  1420,
    1420,  1421,  1422,  1422,  1422,  1423,  1423,  1423,  1423,  1423,
    1423,  1424,  1425,  1425,  1426,  1426,  1427,  1427,  1427,  1428,
    1429,  1428,  1430,  1430,  1431,  1431,  1431,  1431,  1431,  1433,
    1432,  1434,  1434,  1435,  1436,  1437,  1437,  1439,  1440,  1438,
    1442,  1441,  1441,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,
    1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1443,  1445,
    1444,  1447,  1446,  1448,  1446,  1446,  1446,  1446,  1446,  1446,
    1446,  1446,  1446,  1446,  1446,  1446,  1446,  1446,  1446,  1446,
    1446,  1446,  1446,  1446,  1446,  1446,  1446,  1446,  1449,  1449,
    1451,  1450,  1452,  1452,  1452,  1453,  1453,  1453,  1454,  1454,
    1455,  1455,  1456,  1456,  1457,  1457,  1457,  1457,  1457,  1458,
    1458,  1459,  1459,  1460,  1460,  1461,  1461,  1461,  1462,  1463,
    1464,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,
    1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,
    1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,  1465,
    1465,  1465,  1465,  1465,  1465,  1465,  1465,  1466,  1466,  1467,
    1468,  1468,  1468,  1469,  1469,  1469,  1470,  1470,  1471,  1471,
    1473,  1472,  1474,  1474,  1474,  1474,  1475,  1475,  1476,  1476,
    1478,  1477,  1479,  1479,  1480,  1480,  1481,  1481,  1483,  1482,
    1484,  1484,  1485,  1486,  1486,  1488,  1487,  1490,  1489,  1491,
    1492,  1491,  1493,  1493,  1493,  1494,  1494,  1495,  1495,  1495,
    1495,  1495,  1495,  1496,  1496,  1497,  1497,  1498,  1498,  1499,
    1500,  1499,  1501,  1501,  1502,  1502,  1503,  1503,  1503,  1503,
    1504,  1504,  1504,  1504,  1504,  1505,  1505,  1506,  1506,  1507,
    1507,  1507,  1508,  1508,  1509,  1509,  1510,  1510,  1511,  1512,
    1512,  1514,  1513,  1515,  1515,  1516,  1516,  1518,  1517,  1519,
    1519,  1520,  1520,  1521,  1521,  1521,  1521,  1521,  1523,  1522,
    1524,  1524,  1526,  1525,  1527,  1528,  1528,  1529,  1531,  1530,
    1532,  1533,  1532,  1535,  1534,  1536,  1536,  1538,  1537,  1539,
    1539,  1540,  1540,  1541,  1541,  1543,  1542,  1544,  1545,  1545,
    1546,  1546,  1546,  1546,  1546,  1548,  1547,  1549,  1549,  1549,
    1549,  1549,  1549,  1549,  1549,  1549,  1549,  1549,  1550,  1550,
    1551,  1551,  1553,  1552,  1554,  1554,  1555,  1555,  1556,  1556,
    1557,  1557,  1558,  1558,  1558,  1558,  1558,  1559,  1559,  1559,
    1559,  1560,  1560,  1562,  1561,  1563,  1565,  1564,  1566,  1566,
    1567,  1567,  1567,  1569,  1568,  1570,  1570,  1571,  1571,  1572,
    1572,  1572,  1572,  1572,  1574,  1575,  1573,  1576,  1576,  1578,
    1579,  1577,  1581,  1580,  1582,  1582,  1582,  1583,  1583,  1584,
    1584,  1585,  1585,  1585,  1586,  1586,  1587,  1587,  1587,  1587,
    1587,  1587,  1587,  1587,  1588,  1589,  1590,  1590,  1590,  1591,
    1591,  1591,  1591,  1592,  1592,  1593,  1593,  1594,  1595,  1596,
    1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,
    1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,  1596,
    1596,  1596,  1597,  1597,  1599,  1598,  1600,  1600,  1600,  1600,
    1600,  1601,  1601,  1603,  1602,  1605,  1604,  1606,  1604,  1607,
    1608,  1610,  1609,  1611,  1612,  1612,  1613,  1613,  1613,  1614,
    1614,  1615,  1615,  1616,  1616,  1616,  1617,  1617,  1617,  1619,
    1618,  1620,  1618,  1621,  1621,  1622,  1622,  1622,  1622,  1622,
    1623,  1623,  1624,  1624,  1626,  1625,  1627,  1627,  1627,  1627,
    1627,  1627,  1627,  1628,  1628,  1630,  1629,  1631,  1633,  1632,
    1634,  1636,  1635,  1637,  1637,  1638,  1638,  1639,  1641,  1640,
    1642,  1642,  1642,  1643,  1643,  1644,  1645,  1646,  1646,  1648,
    1647,  1649,  1650,  1650,  1651,  1651,  1651,  1652,  1652,  1653,
    1653,  1654,  1655,  1655,  1655,  1655,  1655,  1655,  1655,  1656,
    1656,  1658,  1657,  1659,  1659,  1661,  1660,  1662,  1662,  1664,
    1663,  1665,  1666,  1666,  1666,  1667,  1667,  1667,  1667,  1669,
    1668,  1670,  1671,  1672,  1672,  1673,  1673,  1673,  1673,  1673,
    1673,  1674,  1674,  1675,  1675,  1676,  1676,  1676,  1676,  1676,
    1677,  1678,  1678,  1678,  1678,  1678,  1679,  1680,  1682,  1681,
    1684,  1685,  1683,  1686,  1686,  1687,  1687,  1688,  1689,  1689,
    1691,  1690,  1692,  1693,  1693,  1695,  1694,  1697,  1696,  1698,
    1698,  1699,  1699,  1701,  1700,  1702,  1702,  1704,  1703,  1705,
    1705,  1706,  1706,  1708,  1707,  1709,  1709,  1710,  1711,  1711,
    1712,  1712,  1712,  1712,  1713,  1713,  1714,  1714,  1714,  1714,
    1714,  1715,  1715,  1716,  1716,  1716,  1717,  1717,  1717,  1718,
    1718,  1718,  1719,  1719,  1720,  1720,  1720,  1722,  1721,  1723,
    1724,  1723,  1725,  1723,  1726,  1726,  1727,  1727,  1728,  1728,
    1729,  1729,  1729,  1729,  1729,  1730,  1730,  1731,  1731,  1732,
    1732,  1733,  1734,  1734,  1736,  1735,  1738,  1737,  1739,  1739,
    1740,  1742,  1741,  1743,  1744,  1744,  1745,  1745,  1745,  1745,
    1746,  1746,  1747,  1747,  1748,  1748,  1749,  1750,  1750,  1750,
    1751,  1751,  1752,  1752,  1752,  1753,  1753,  1754,  1754,  1755,
    1755,  1756,  1758,  1757,  1759,  1760,  1760,  1761,  1761,  1761,
    1762,  1762,  1763,  1764,  1764,  1765,  1766,  1766,  1768,  1767,
    1769,  1770,  1772,  1771,  1773,  1774,  1774,  1776,  1775,  1777,
    1778,  1778,  1779,  1779,  1780,  1780,  1781,  1783,  1782,  1784,
    1784,  1785,  1785,  1786,  1786,  1787,  1787,  1788,  1789,  1789,
    1791,  1790,  1792,  1792,  1793,  1793,  1794,  1795,  1795,  1795,
    1795,  1796,  1796,  1798,  1797,  1799,  1799,  1799,  1799,  1799,
    1799,  1799,  1799,  1800,  1800,  1801,  1801,  1802,  1803,  1804,
    1804,  1805,  1805,  1805,  1805,  1805,  1805,  1805,  1805,  1806,
    1806,  1806,  1806,  1806,  1807,  1808,  1808,  1809,  1810,  1810,
    1811,  1811,  1812,  1813,  1815,  1814,  1817,  1816,  1818,  1818,
    1819,  1819,  1820,  1820,  1821,  1821,  1822,  1822,  1822,  1823,
    1823,  1823,  1825,  1824,  1826,  1827,  1827,  1828,  1828,  1828,
    1828,  1829,  1829,  1829,  1829,  1829,  1829,  1830,  1831,  1831,
    1832,  1832,  1833,  1834,  1834,  1835,  1837,  1836,  1836,  1836,
    1838,  1838,  1838,  1838,  1838,  1839,  1839,  1840,  1840,  1841,
    1841,  1841,  1841,  1843,  1842,  1844,  1846,  1845,  1847,  1847,
    1848,  1849,  1849,  1850,  1850,  1851,  1851,  1852,  1852,  1854,
    1853,  1855,  1855,  1855,  1855,  1856,  1856,  1857,  1858,  1858,
    1860,  1859,  1861,  1861,  1863,  1862,  1864,  1866,  1865,  1867,
    1869,  1868,  1870,  1871,  1871,  1872,  1872,  1873,  1874,  1874,
    1875,  1876,  1876,  1877,  1877,  1878,  1878,  1880,  1879,  1881,
    1881,  1883,  1882,  1884,  1884,  1884,  1884,  1884,  1885,  1886,
    1886,  1887,  1887,  1887,  1887,  1887,  1888,  1889,  1889,  1890,
    1890,  1890,  1891,  1891,  1891,  1891,  1892,  1893,  1893,  1894,
    1895,  1895,  1896,  1896,  1897,  1897,  1899,  1898,  1900,  1901,
    1901,  1902,  1902,  1902,  1902,  1903,  1903,  1904,  1904,  1904,
    1905,  1905,  1907,  1906,  1909,  1910,  1908,  1911,  1911,  1912,
    1912,  1913,  1914,  1914,  1914,  1915,  1915,  1916,  1916,  1917,
    1917,  1918,  1918,  1919,  1920,  1920,  1921,  1921,  1922,  1923,
    1923,  1924,  1924,  1924,  1925,  1925,  1926,  1926,  1927,  1927,
    1927,  1928,  1928,  1928,  1929,  1929,  1930,  1930,  1932,  1931,
    1934,  1933,  1935,  1935,  1936,  1936,  1937,  1937,  1938,  1938,
    1939,  1939,  1939,  1940,  1940,  1941,  1942,  1942,  1943,  1943,
    1944,  1945,  1945,  1946,  1946,  1946,  1947,  1947,  1948,  1949,
    1949,  1950,  1951,  1951,  1951,  1952,  1952,  1953,  1954,  1954,
    1955,  1956,  1956,  1956,  1957,  1957,  1958,  1959,  1959,  1960,
    1961,  1961,  1961,  1962,  1962,  1963,  1964,  1964,  1965,  1966,
    1966,  1966,  1967,  1967,  1968,  1969,  1969,  1970,  1971,  1971,
    1972,  1972,  1973,  1973,  1974,  1975,  1975,  1976,  1977,  1977,
    1978,  1978,  1979,  1980,  1980,  1981,  1982,  1982,  1983,  1983,
    1984,  1984,  1985,  1986,  1986,  1987,  1988,  1988,  1989,  1989,
    1990,  1990,  1991,  1991,  1992,  1992,  1993,  1993,  1994,  1996,
    1995,  1997,  1997,  1998,  1998,  1998,  1998,  1998,  1998,  1998,
    1998,  1998,  1998,  1998,  1998,  1998,  1998,  1999,  1999,  2000,
    2001,  2001,  2001,  2001,  2001,  2001,  2001,  2001,  2001,  2001,
    2001,  2001,  2001,  2001,  2002,  2002,  2003,  2003,  2004,  2004,
    2005,  2006,  2007,  2007,  2008,  2008,  2008,  2009,  2009,  2009,
    2010,  2010,  2010,  2011,  2011,  2012,  2012,  2012,  2013,  2013,
    2014,  2014,  2014,  2014,  2014,  2014,  2015,  2015,  2016,  2017,
    2018,  2018,  2019,  2020,  2020,  2021,  2021,  2022,  2023,  2024,
    2025,  2025,  2026,  2027,  2027,  2028,  2029,  2029,  2030,  2031,
    2031,  2031,  2032,  2033,  2033,  2034,  2035,  2035,  2036,  2036,
    2037,  2038,  2038,  2039,  2040,  2040,  2041,  2041,  2042,  2043,
    2043,  2044,  2044,  2044,  2045,  2045,  2046,  2046,  2047,  2047,
    2048,  2048,  2049,  2049,  2049,  2049,  2049,  2049,  2049,  2049,
    2049,  2050,  2051,  2051,  2052,  2052,  2052,  2053,  2053,  2053,
    2053,  2053,  2053,  2053,  2054,  2054,  2054,  2054,  2054,  2054,
    2055,  2056,  2057,  2058,  2058,  2059,  2059,  2060,  2061,  2062,
    2062,  2063,  2063,  2064,  2064,  2064,  2065,  2065,  2066,  2066,
    2067,  2067,  2067,  2068,  2068,  2068,  2069,  2069,  2069,  2070,
    2070,  2071,  2071,  2072,  2072,  2073,  2073,  2073,  2074,  2075,
    2076,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2082,  2082,
    2082,  2083,  2083,  2084,  2084,  2085,  2085,  2085,  2085,  2086,
    2087,  2087,  2089,  2088,  2090,  2090,  2091,  2092,  2092,  2093,
    2094,  2095,  2096,  2096,  2097,  2097,  2097,  2097,  2097,  2097,
    2097,  2098,  2098,  2099,  2099,  2100,  2100,  2100,  2100,  2100,
    2100,  2100,  2101,  2101,  2101,  2101,  2102,  2102,  2102,  2102,
    2102,  2102,  2102,  2102,  2102,  2102,  2102,  2102,  2102,  2102,
    2103,  2103,  2104,  2104,  2104,  2104,  2105,  2105,  2105,  2105,
    2105,  2106,  2106,  2106,  2107,  2107,  2107,  2108,  2108,  2108,
    2110,  2109,  2111,  2111,  2112,  2112,  2113,  2113,  2114,  2114,
    2115,  2116,  2116,  2117,  2117,  2117,  2118,  2118,  2119,  2119,
    2120,  2120,  2121,  2121,  2121,  2122,  2122,  2123,  2123,  2123,
    2124,  2124,  2125,  2125,  2126,  2126,  2126,  2126,  2126,  2126,
    2126,  2126,  2127,  2127,  2128,  2128,  2129,  2129,  2130,  2130,
    2130,  2130,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,  2131,
    2131,  2131,  2131,  2132,  2132,  2132,  2132,  2132,  2132,  2132,
    2132,  2132,  2132,  2132,  2132,  2132,  2132,  2132,  2132,  2132,
    2132,  2132,  2132,  2132,  2132,  2132,  2133,  2133,  2134,  2134,
    2135,  2135,  2136,  2136,  2137,  2137,  2137,  2138,  2138,  2139,
    2139,  2140,  2140,  2141,  2141,  2142,  2142,  2143,  2143,  2144,
    2144,  2145,  2145,  2146,  2146,  2147,  2147,  2148,  2148,  2149,
    2149,  2150,  2150,  2151,  2151,  2152,  2152,  2153,  2153,  2154,
    2154,  2155,  2155,  2156,  2156,  2157,  2157,  2157,  2158,  2158,
    2158,  2159,  2159,  2160,  2160,  2161,  2161,  2162,  2162,  2163,
    2163,  2164,  2164,  2164,  2165,  2165,  2165,  2166,  2166,  2166,
    2166,  2167,  2167,  2167,  2168,  2168,  2169,  2169,  2170,  2170,
    2170,  2171,  2171,  2171,  2172,  2172,  2173,  2173,  2174,  2174,
    2175,  2175,  2176,  2176,  2177,  2177,  2178,  2178,  2179,  2179,
    2180,  2180,  2181,  2181,  2181,  2182,  2182,  2182,  2182,  2183,
    2183,  2184,  2184,  2185,  2185,  2186,  2186,  2187,  2187,  2188,
    2188,  2189,  2189,  2189,  2190,  2190,  2191,  2191,  2192,  2192,
    2193,  2193,  2193,  2194,  2194,  2195,  2195,  2196,  2196,  2197,
    2197,  2198,  2198,  2199,  2199,  2200,  2200,  2201,  2201,  2202,
    2202,  2203,  2203,  2204,  2204,  2205,  2205,  2206,  2206,  2207,
    2207,  2207,  2208,  2208,  2209,  2209,  2210,  2210,  2211,  2211,
    2211,  2211,  2212,  2212,  2213,  2213,  2214,  2214,  2215,  2215,
    2216,  2216,  2217,  2217,  2218,  2218,  2219,  2219,  2219,  2220,
    2220,  2221,  2221,  2222,  2222,  2223,  2223,  2224,  2224,  2225,
    2225,  2226,  2226,  2227,  2227,  2228,  2228,  2229,  2229,  2230,
    2230,  2231,  2231,  2232,  2232,  2233,  2233
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     2,     1,     2,
       1,     1,     0,     2,     4,     4,     0,     1,     1,     2,
       0,     4,     0,     4,     0,     0,     6,     0,     1,     3,
       1,     1,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     0,     2,     0,     3,     1,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     0,     1,     2,     0,     3,
       5,     0,     3,     1,     1,     1,     1,     0,     5,     0,
       3,     1,     1,     1,     0,     4,     1,     1,     1,     1,
       3,     0,     3,     2,     0,     3,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     0,     4,     0,     3,     0,
       3,     0,     4,     0,     2,     3,     2,     1,     2,     1,
       1,     1,     1,     5,     2,     0,     4,     2,     3,     4,
       4,     8,     8,     3,     4,     1,     1,     1,     1,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     3,     3,
       3,     3,     3,     1,     2,     2,     2,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     3,     2,     3,     3,     1,
       0,     1,     1,     3,     4,     0,     4,     0,     4,     0,
       4,     0,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     2,     1,     3,
       0,     4,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     0,     2,     3,     1,     2,     3,     1,
       2,     1,     2,     3,     1,     2,     3,     6,     1,     2,
       1,     3,     0,     2,     2,     0,     2,     4,     5,     0,
       3,     3,     5,     3,     4,     3,     3,     0,     4,     4,
       0,     3,     0,     2,     0,     2,     0,     5,     2,     2,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     5,     6,     6,     4,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     0,     1,
       1,     1,     1,     1,     4,     1,     1,     1,     9,     0,
       1,     0,     4,     0,     4,     3,     3,     1,     0,     4,
       2,     3,     4,     4,     8,     8,     6,     1,     5,     0,
       1,     1,     0,     5,     2,     2,     2,     0,     5,     6,
       1,     0,     1,     2,     0,     2,     3,     1,     1,     3,
       1,     2,     4,     0,     5,     1,     1,     1,     1,     7,
       0,     2,     1,     2,     0,     2,     2,     1,     4,     3,
       1,     1,     3,     2,     2,     2,     3,     3,     4,     4,
       4,     4,     4,     0,     2,     2,     0,     2,     3,     1,
       2,     1,     1,     1,     1,     5,     0,     1,     1,     1,
       4,     4,     4,     4,     1,     6,     6,     7,     4,     6,
       4,     6,     4,     0,     6,     1,     2,     2,     0,     2,
       6,     2,     2,     3,     0,    10,     0,     1,     3,     0,
       3,     0,     2,     2,     0,     5,     3,     1,     1,     0,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     0,     1,     1,     4,     6,     9,     0,
       3,     0,     2,     0,     2,     3,     5,     5,     1,     1,
       1,     1,     3,     5,     0,     2,     1,     1,     1,     4,
       2,     2,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     0,     2,     2,     2,     2,     1,     2,     0,     0,
       5,     0,     2,     2,     0,     5,     0,     2,     4,     3,
       4,     0,     1,     1,     1,     2,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,    11,     0,     1,
       1,     2,     4,     4,     4,     6,     4,     3,     4,     0,
       1,     1,     1,     2,     4,     4,     4,     4,     4,     4,
       6,     0,     0,     5,     0,     0,     2,     2,     3,     1,
       1,     1,     0,     4,     3,     2,     0,     1,     1,     1,
       1,     0,     2,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     0,     2,     0,     4,     5,     0,     7,     2,     2,
       1,     3,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     3,
       0,     2,     0,     1,     2,     0,     4,     1,     2,     1,
       1,     1,     2,     0,     5,     0,     2,     1,     1,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     4,     3,     3,     3,     4,     3,     3,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     1,     3,     3,     6,     0,     2,     6,     8,
       7,     0,     2,     0,     2,     0,     2,     0,     3,     0,
       3,     0,     1,     0,     2,     0,     3,     1,     1,     1,
       1,     2,     4,     1,     1,     0,     1,     3,     1,     2,
       1,     2,     2,     0,     1,     1,     3,     1,     0,     5,
       1,     2,     3,     1,     0,     4,     2,     2,     2,     4,
       0,     0,     5,     0,     0,     5,     0,     0,     5,     0,
       2,     0,     6,     0,     2,     2,     2,     4,     1,     1,
       2,     2,     1,     1,     1,     1,     2,     1,     4,     2,
       1,     3,     2,     1,     1,     0,     2,     1,     1,     1,
       1,     1,     3,     3,     4,     4,     4,     3,     0,     2,
       0,     5,     3,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     3,     3,     1,     1,     1,     0,
       2,     2,     0,     2,     0,     2,     2,     1,     3,     1,
       2,     1,     1,     1,     1,     4,     0,     3,     2,     1,
       1,     3,     4,     5,     4,     5,     1,     1,     0,     2,
       1,     1,     1,     6,     2,     3,     2,     0,     2,     1,
       2,     2,     4,     0,     1,     1,     1,     1,     2,     1,
       1,     2,     1,     4,     2,     0,     0,     5,     0,     1,
       2,     3,     1,     0,     4,     0,     0,     6,     3,     0,
       2,     2,     2,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     1,
       1,     2,     3,     2,     2,     2,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     2,     1,     2,     1,     3,     3,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     2,     3,     3,     3,     1,
       2,     1,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     0,     1,     4,     0,     1,     1,
       4,     0,     1,     1,     3,     2,     0,     1,     0,     0,
       0,    12,     0,     4,     0,     0,     3,     0,     3,     1,
       2,     5,     0,     2,     2,     0,     3,     3,     4,     2,
       1,     3,     0,     5,     0,     1,     0,     2,     2,     0,
       0,     7,     0,     2,     1,     1,     2,     1,     1,     0,
       6,     0,     2,     2,     1,     0,     1,     0,     0,     3,
       0,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     0,
       4,     0,     4,     0,     5,     3,     3,     3,     3,     4,
       3,     4,     3,     3,     4,     4,     4,     3,     4,     3,
       4,     5,     3,     4,     3,     3,     2,     3,     1,     1,
       0,     3,     5,     4,     4,     1,     3,     3,     1,     1,
       0,     1,     1,     2,     1,     1,     1,     2,     3,     1,
       2,     1,     3,     1,     2,     2,     2,     2,     3,     3,
       3,     1,     1,     1,     2,     1,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     1,     1,     1,     4,     1,     2,     1,     1,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     4,     4,     5,     6,     8,     0,     2,     0,     1,
       0,     3,     4,     5,     0,     2,     0,     2,     0,     3,
       1,     2,     4,     0,     2,     0,     4,     0,     9,     0,
       0,     4,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     0,     2,     1,     1,     0,
       0,     3,     1,     2,     2,     3,     0,     2,     2,     2,
       0,     3,     2,     2,     4,     1,     1,     1,     1,     0,
       2,     2,     0,     1,     2,     2,     0,     1,     2,     0,
       1,     0,     3,     1,     2,     1,     1,     0,     3,     1,
       1,     2,     3,     0,     1,     3,     3,     2,     0,     4,
       0,     3,     0,     4,     4,     0,     1,     2,     0,     3,
       0,     0,     4,     0,     3,     2,     1,     0,     4,     4,
       2,     1,     2,     0,     1,     0,     3,     3,     0,     3,
       0,     2,     1,     2,     1,     0,     4,     3,     3,     3,
       3,     2,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     2,     0,     3,     1,     1,     0,     2,     1,     2,
       1,     2,     1,     2,     1,     1,     2,     2,     2,     2,
       2,     1,     1,     0,     3,     2,     0,     3,     1,     2,
       1,     1,     1,     0,     5,     0,     1,     1,     2,     3,
       3,     3,     3,     2,     0,     0,     5,     1,     1,     0,
       0,     7,     0,     5,     1,     1,     1,     0,     1,     0,
       2,     1,     2,     1,     1,     2,     1,     2,     1,     5,
       1,     1,     1,     2,     1,     1,     0,     1,     1,     1,
       1,     0,     1,     3,     3,     1,     1,     4,     3,     1,
       2,     2,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     3,     3,     3,
       3,     3,     0,     1,     0,     4,     4,     6,     6,     8,
       8,     0,     1,     0,     3,     0,     3,     0,     6,     4,
       1,     0,     4,     2,     1,     3,     1,     1,     1,     2,
       1,     1,     2,     2,     2,     2,     3,     3,     3,     0,
       3,     0,     4,     1,     3,     2,     1,     1,     1,     1,
       0,     2,     0,     1,     0,     3,     0,     2,     1,     2,
       1,     1,     1,     0,     2,     0,     3,     1,     0,     3,
       1,     0,     3,     3,     4,     0,     3,     2,     0,     6,
       5,     3,     2,     0,     1,     0,     0,     0,     1,     0,
       3,     5,     0,     2,     0,     3,     3,     0,     2,     1,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     3,     1,     2,     0,     3,     2,     2,     0,
       3,     2,     1,     1,     1,     2,     1,     1,     1,     0,
       3,     2,     5,     1,     2,     2,     2,     1,     1,     1,
       2,     1,     2,     4,     2,     0,     1,     1,     1,     1,
       4,     0,     1,     1,     2,     2,     3,     3,     0,     5,
       0,     0,     9,     0,     2,     1,     2,     1,     0,     1,
       0,     5,     7,     0,     2,     0,     3,     0,     4,     2,
       2,     0,     1,     0,     3,     3,     4,     0,     4,     4,
       6,     0,     1,     0,     3,     1,     2,     6,     0,     1,
       1,     1,     1,     1,     0,     3,     0,     1,     1,     2,
       1,     2,     2,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     0,     3,     4,
       0,     6,     0,     5,     0,     1,     1,     1,     1,     3,
       0,     2,     1,     3,     3,     0,     3,     1,     1,     1,
       3,     6,     0,     2,     0,     3,     0,     3,     2,     1,
       1,     0,     4,     7,     0,     2,     0,     1,     2,     1,
       2,     3,     3,     1,     0,     1,     1,     4,     4,     2,
       0,     1,     1,     3,     2,     0,     3,     1,     1,     0,
       1,     1,     0,     4,     5,     1,     1,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     1,     0,     3,
       2,     1,     0,     4,     4,     0,     1,     0,     4,     5,
       0,     1,     2,     3,     0,     1,     2,     0,     4,     4,
       6,     0,     2,     0,     2,     1,     2,     3,     0,     1,
       0,     3,     2,     5,     0,     1,     2,     2,     2,     2,
       2,     0,     2,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     1,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     4,
       7,     7,     3,     5,     4,     1,     2,     3,     1,     2,
       3,     3,     4,     4,     0,     3,     0,     7,     0,     5,
       0,     2,     0,     3,     0,     1,     0,     2,     4,     0,
       2,     4,     0,     4,     4,     0,     3,     0,     4,     1,
       1,     1,     2,     2,     2,     2,     1,     1,     2,     1,
       0,     1,     2,     0,     1,     1,     0,     4,     2,     2,
       0,     2,     1,     4,     4,     0,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     5,     0,     2,     1,     2,
       2,     0,     3,     1,     1,     0,     4,     0,     1,     0,
       4,     4,     6,     6,     8,     0,     1,     2,     0,     1,
       0,     3,     1,     2,     0,     3,     5,     0,     3,     2,
       0,     4,     6,     0,     3,     1,     3,     2,     2,     2,
       3,     0,     3,     0,     3,     0,     1,     0,     3,     1,
       2,     0,     3,     1,     1,     1,     1,     1,     7,     0,
       1,     1,     1,     1,     1,     1,     4,     1,     2,     1,
       2,     3,     0,     1,     2,     1,     3,     1,     1,     4,
       1,     2,     2,     3,     1,     1,     0,     4,     6,     0,
       2,     0,     4,     3,     3,     1,     1,     0,     1,     1,
       0,     1,     0,     5,     0,     0,    12,     0,     1,     1,
       2,     2,     2,     1,     1,     0,     4,     0,     3,     0,
       3,     1,     2,     3,     0,     3,     1,     2,     3,     0,
       1,     1,     1,     1,     0,     2,     1,     2,     1,     2,
       2,     2,     2,     1,     1,     3,     0,     1,     0,     5,
       0,    10,     0,     3,     0,     2,     0,     3,     1,     2,
       0,     2,     2,     0,     1,     3,     1,     1,     0,     1,
       2,     1,     1,     0,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     2,     2,     0,     1,     2,     0,     1,     2,
       0,     2,     2,     0,     1,     2,     0,     1,     2,     0,
       2,     2,     0,     1,     2,     0,     1,     2,     2,     2,
       2,     2,     0,     1,     2,     0,     1,     2,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     1,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     2,     0,     3,
       2,     1,     0,     2,     0,     3,     1,     1,     1,     0,
       2,     1,     2,     1,     2,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     3,     0,     1,     1,     3,     3,     1,
       3,     3,     1,     3,     1,     2,     2,     1,     3,     1,
       1,     3,     1,     3,     1,     3,     1,     2,     2,     1,
       1,     2,     1,     1,     2,     2,     3,     1,     1,     1,
       1,     2,     1,     1,     2,     1,     0,     2,     1,     1,
       1,     3,     1,     1,     2,     1,     0,     1,     1,     2,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     3,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     3,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     1,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     3,     2,     2,
       1,     1,     2,     1,     1,     3,     2,     2,     1,     1,
       1,     3,     0,     2,     1,     3,     3,     4,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     5,     5,     5,
       4,     5,     4,     5,     5,     5,     5,     5,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     5,     0,     3,     2,     1,     3,     3,
       0,     2,     1,     3,     1,     3,     1,     3,     1,     3,
       0,     0,     1,     0,     3,     2,     0,     1,     0,     2,
       0,     2,     0,     1,     1,     0,     1,     0,     1,     2,
       0,     2,     0,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     0,     5,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     3,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     1,     0,     1,     1,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     2,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     1,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     2,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     3,     0,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     1,     2,     1,     2,
       1,     2,     1,     2,     1,     2,     2
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 3170 "parser.y" /* yacc.c:1646  */
    {
	clear_initial_values ();
	current_program = NULL;
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;
	current_program = cb_build_program (NULL, 0);
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
  }
#line 12266 "parser.c" /* yacc.c:1646  */
    break;

  case 3:
#line 3182 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		backup_current_pos ();
		emit_entry (current_program->program_id, 0, NULL, NULL);
	}
  }
#line 12290 "parser.c" /* yacc.c:1646  */
    break;

  case 6:
#line 3209 "parser.y" /* yacc.c:1646  */
    {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 12300 "parser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 3228 "parser.y" /* yacc.c:1646  */
    {
	program_init_without_program_id ();
  }
#line 12308 "parser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 3233 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12317 "parser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 3259 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 12326 "parser.c" /* yacc.c:1646  */
    break;

  case 20:
#line 3273 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
  }
#line 12334 "parser.c" /* yacc.c:1646  */
    break;

  case 21:
#line 3277 "parser.y" /* yacc.c:1646  */
    {
	first_nested_program = 0;
	clean_up_program ((yyvsp[-1]), COB_MODULE_TYPE_PROGRAM);
  }
#line 12343 "parser.c" /* yacc.c:1646  */
    break;

  case 22:
#line 3285 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
  }
#line 12351 "parser.c" /* yacc.c:1646  */
    break;

  case 23:
#line 3289 "parser.y" /* yacc.c:1646  */
    {
	clean_up_program ((yyvsp[-1]), COB_MODULE_TYPE_FUNCTION);
  }
#line 12359 "parser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 3299 "parser.y" /* yacc.c:1646  */
    {
	cb_validate_program_environment (current_program);
  }
#line 12367 "parser.c" /* yacc.c:1646  */
    break;

  case 25:
#line 3303 "parser.y" /* yacc.c:1646  */
    {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
  }
#line 12377 "parser.c" /* yacc.c:1646  */
    break;

  case 29:
#line 3320 "parser.y" /* yacc.c:1646  */
    {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 12386 "parser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 3333 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_id = 1;
  }
#line 12394 "parser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 3337 "parser.y" /* yacc.c:1646  */
    {
	if (setup_program ((yyvsp[-1]), (yyvsp[0]), COB_MODULE_TYPE_PROGRAM)) {
		YYABORT;
	}

	setup_prototype ((yyvsp[-1]), (yyvsp[0]), COB_MODULE_TYPE_PROGRAM, 1);
  }
#line 12406 "parser.c" /* yacc.c:1646  */
    break;

  case 34:
#line 3345 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12415 "parser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 3353 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_id = 1;
  }
#line 12423 "parser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 3357 "parser.y" /* yacc.c:1646  */
    {
	if (setup_program ((yyvsp[-3]), (yyvsp[-2]), COB_MODULE_TYPE_FUNCTION)) {
		YYABORT;
	}
	setup_prototype ((yyvsp[-3]), (yyvsp[-2]), COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 12436 "parser.c" /* yacc.c:1646  */
    break;

  case 37:
#line 3369 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REFERENCE_P ((yyvsp[0])) && CB_WORD_COUNT ((yyvsp[0])) > 0) {
		redefinition_error ((yyvsp[0]));
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	(yyval) = (yyvsp[0]);
  }
#line 12451 "parser.c" /* yacc.c:1646  */
    break;

  case 38:
#line 3380 "parser.y" /* yacc.c:1646  */
    {
	cb_trim_program_id ((yyvsp[0]));
  }
#line 12459 "parser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 3388 "parser.y" /* yacc.c:1646  */
    {
	cb_trim_program_id ((yyvsp[0]));
  }
#line 12467 "parser.c" /* yacc.c:1646  */
    break;

  case 41:
#line 3394 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 12473 "parser.c" /* yacc.c:1646  */
    break;

  case 42:
#line 3395 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 12479 "parser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 3406 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12492 "parser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 3415 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 12505 "parser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 3425 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("CALL prototypes"));
  }
#line 12513 "parser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 3437 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_initial = 1;
  }
#line 12521 "parser.c" /* yacc.c:1646  */
    break;

  case 53:
#line 3441 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_recursive = 1;
  }
#line 12529 "parser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 3445 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_resident = 1;
  }
#line 12537 "parser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 3457 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("CALL prototypes"));
  }
#line 12545 "parser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 3466 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 12553 "parser.c" /* yacc.c:1646  */
    break;

  case 63:
#line 3486 "parser.y" /* yacc.c:1646  */
    {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 12564 "parser.c" /* yacc.c:1646  */
    break;

  case 64:
#line 3493 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 12572 "parser.c" /* yacc.c:1646  */
    break;

  case 65:
#line 3497 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 12580 "parser.c" /* yacc.c:1646  */
    break;

  case 66:
#line 3501 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 12588 "parser.c" /* yacc.c:1646  */
    break;

  case 67:
#line 3516 "parser.y" /* yacc.c:1646  */
    {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 12596 "parser.c" /* yacc.c:1646  */
    break;

  case 68:
#line 3520 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		default_rounded_mode = (yyvsp[0]);
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 12608 "parser.c" /* yacc.c:1646  */
    break;

  case 70:
#line 3532 "parser.y" /* yacc.c:1646  */
    {
	current_program->entry_convention = (yyvsp[0]);
  }
#line 12616 "parser.c" /* yacc.c:1646  */
    break;

  case 71:
#line 3539 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_COBOL);
  }
#line 12624 "parser.c" /* yacc.c:1646  */
    break;

  case 72:
#line 3543 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 12632 "parser.c" /* yacc.c:1646  */
    break;

  case 73:
#line 3547 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_STDCALL);
  }
#line 12640 "parser.c" /* yacc.c:1646  */
    break;

  case 75:
#line 3555 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 12648 "parser.c" /* yacc.c:1646  */
    break;

  case 76:
#line 3562 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 12656 "parser.c" /* yacc.c:1646  */
    break;

  case 77:
#line 3566 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 12664 "parser.c" /* yacc.c:1646  */
    break;

  case 78:
#line 3570 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 12672 "parser.c" /* yacc.c:1646  */
    break;

  case 79:
#line 3574 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 12680 "parser.c" /* yacc.c:1646  */
    break;

  case 82:
#line 3589 "parser.y" /* yacc.c:1646  */
    {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 12688 "parser.c" /* yacc.c:1646  */
    break;

  case 85:
#line 3603 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 12700 "parser.c" /* yacc.c:1646  */
    break;

  case 95:
#line 3634 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 12711 "parser.c" /* yacc.c:1646  */
    break;

  case 100:
#line 3650 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 12722 "parser.c" /* yacc.c:1646  */
    break;

  case 101:
#line 3662 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 12733 "parser.c" /* yacc.c:1646  */
    break;

  case 102:
#line 3669 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 12741 "parser.c" /* yacc.c:1646  */
    break;

  case 113:
#line 3695 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 12749 "parser.c" /* yacc.c:1646  */
    break;

  case 114:
#line 3703 "parser.y" /* yacc.c:1646  */
    {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 12758 "parser.c" /* yacc.c:1646  */
    break;

  case 115:
#line 3711 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 12766 "parser.c" /* yacc.c:1646  */
    break;

  case 117:
#line 3719 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[0]);
  }
#line 12774 "parser.c" /* yacc.c:1646  */
    break;

  case 118:
#line 3723 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[-1]);
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 12784 "parser.c" /* yacc.c:1646  */
    break;

  case 119:
#line 3729 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[0]);
  }
#line 12792 "parser.c" /* yacc.c:1646  */
    break;

  case 120:
#line 3733 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 12801 "parser.c" /* yacc.c:1646  */
    break;

  case 121:
#line 3739 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[-4]);
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 12811 "parser.c" /* yacc.c:1646  */
    break;

  case 122:
#line 3746 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[-4]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[-4]);
	alphanumeric_collation = (yyvsp[0]);
  }
#line 12821 "parser.c" /* yacc.c:1646  */
    break;

  case 123:
#line 3755 "parser.y" /* yacc.c:1646  */
    {
	int segnum;

	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		segnum = cb_get_int ((yyvsp[0]));
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			(yyval) = NULL;
		}
	}
	/* Ignore */
  }
#line 12838 "parser.c" /* yacc.c:1646  */
    break;

  case 124:
#line 3771 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = (yyvsp[0]);
	}
  }
#line 12850 "parser.c" /* yacc.c:1646  */
    break;

  case 125:
#line 3782 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 12858 "parser.c" /* yacc.c:1646  */
    break;

  case 126:
#line 3786 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 12866 "parser.c" /* yacc.c:1646  */
    break;

  case 127:
#line 3790 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 12874 "parser.c" /* yacc.c:1646  */
    break;

  case 128:
#line 3794 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 12882 "parser.c" /* yacc.c:1646  */
    break;

  case 131:
#line 3808 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 12893 "parser.c" /* yacc.c:1646  */
    break;

  case 132:
#line 3815 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_repository = 0;
  }
#line 12901 "parser.c" /* yacc.c:1646  */
    break;

  case 135:
#line 3824 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 12909 "parser.c" /* yacc.c:1646  */
    break;

  case 138:
#line 3836 "parser.y" /* yacc.c:1646  */
    {
	functions_are_all = 1;
  }
#line 12917 "parser.c" /* yacc.c:1646  */
    break;

  case 139:
#line 3840 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1]) != cb_error_node) {
		setup_prototype ((yyvsp[-1]), (yyvsp[0]), COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 12927 "parser.c" /* yacc.c:1646  */
    break;

  case 141:
#line 3847 "parser.y" /* yacc.c:1646  */
    {
	  if ((yyvsp[-1]) != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype ((yyvsp[-1]), (yyvsp[0]), COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 12938 "parser.c" /* yacc.c:1646  */
    break;

  case 142:
#line 3854 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 12946 "parser.c" /* yacc.c:1646  */
    break;

  case 143:
#line 3861 "parser.y" /* yacc.c:1646  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, (yyvsp[0]));
  }
#line 12955 "parser.c" /* yacc.c:1646  */
    break;

  case 144:
#line 3866 "parser.y" /* yacc.c:1646  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, (yyvsp[0]));
  }
#line 12964 "parser.c" /* yacc.c:1646  */
    break;

  case 145:
#line 3877 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
  }
#line 12979 "parser.c" /* yacc.c:1646  */
    break;

  case 164:
#line 3922 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated ((yyvsp[0]));
	}
  }
#line 12998 "parser.c" /* yacc.c:1646  */
    break;

  case 166:
#line 3941 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 13012 "parser.c" /* yacc.c:1646  */
    break;

  case 167:
#line 3952 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE ((yyvsp[0]))) {
			CB_SYSTEM_NAME(save_tree)->value = (yyvsp[-2]);
			cb_define ((yyvsp[0]), save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					(yyvsp[0]), save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (strcasecmp (CB_NAME((yyvsp[0])), "EXTERN" ) == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "STDCALL") == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "STATIC" ) == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "C"      ) == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "PASCAL" ) == 0) {
				remove_context_sensitivity (CB_NAME((yyvsp[0])), CB_CS_CALL);
			}
		}
	}
  }
#line 13037 "parser.c" /* yacc.c:1646  */
    break;

  case 168:
#line 3973 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree && CB_VALID_TREE ((yyvsp[-1]))) {
		cb_define ((yyvsp[-1]), save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				(yyvsp[-1]), save_tree);
	}
  }
#line 13049 "parser.c" /* yacc.c:1646  */
    break;

  case 172:
#line 3989 "parser.y" /* yacc.c:1646  */
    {
	  check_on_off_duplicate = 0;
  }
#line 13057 "parser.c" /* yacc.c:1646  */
    break;

  case 173:
#line 3996 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name ((yyvsp[0]), save_tree, (yyvsp[-2]) == cb_int1);
	if (x) {
		if ((yyvsp[-2]) == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, (yyvsp[0]), x);
	}
  }
#line 13076 "parser.c" /* yacc.c:1646  */
    break;

  case 174:
#line 4011 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name ((yyvsp[0]), save_tree, (yyvsp[-2]) == cb_int1);
	if (x) {
		if ((yyvsp[-2]) == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, (yyvsp[0]), x);
	}
  }
#line 13095 "parser.c" /* yacc.c:1646  */
    break;

  case 175:
#line 4031 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		(yyval) = NULL;
	} else {
		/* Returns null on error */
		(yyval) = cb_build_alphabet_name ((yyvsp[0]));
	}
  }
#line 13112 "parser.c" /* yacc.c:1646  */
    break;

  case 176:
#line 4044 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1])) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, (yyvsp[-1]));
	}
	cobc_cs_check = 0;
  }
#line 13124 "parser.c" /* yacc.c:1646  */
    break;

  case 177:
#line 4055 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if ((yyvsp[-1])) {
		CB_ALPHABET_NAME ((yyvsp[-1]))->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 13135 "parser.c" /* yacc.c:1646  */
    break;

  case 179:
#line 4063 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if ((yyvsp[-1])) {
		CB_ALPHABET_NAME((yyvsp[-1]))->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 13146 "parser.c" /* yacc.c:1646  */
    break;

  case 185:
#line 4084 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13156 "parser.c" /* yacc.c:1646  */
    break;

  case 186:
#line 4090 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13166 "parser.c" /* yacc.c:1646  */
    break;

  case 187:
#line 4096 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 13176 "parser.c" /* yacc.c:1646  */
    break;

  case 188:
#line 4102 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 13186 "parser.c" /* yacc.c:1646  */
    break;

  case 190:
#line 4112 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_PENDING_X ((yyvsp[(-1) - (1)]), "ALPHABET UCS-4");
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 13197 "parser.c" /* yacc.c:1646  */
    break;

  case 191:
#line 4119 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_PENDING_X ((yyvsp[(-1) - (1)]), "ALPHABET UTF-8");
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 13208 "parser.c" /* yacc.c:1646  */
    break;

  case 192:
#line 4126 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_PENDING_X ((yyvsp[(-1) - (1)]), "ALPHABET UTF-16");
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 13219 "parser.c" /* yacc.c:1646  */
    break;

  case 193:
#line 4136 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 13229 "parser.c" /* yacc.c:1646  */
    break;

  case 194:
#line 4142 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (2)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (2)]))->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME ((yyvsp[(-1) - (2)]))->custom_list = (yyvsp[0]);
		CB_PENDING_X ((yyvsp[(-1) - (2)]), "LOCALE ALPHABET");
	}
  }
#line 13241 "parser.c" /* yacc.c:1646  */
    break;

  case 195:
#line 4150 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->custom_list = (yyvsp[0]);
	}
  }
#line 13252 "parser.c" /* yacc.c:1646  */
    break;

  case 196:
#line 4160 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 13260 "parser.c" /* yacc.c:1646  */
    break;

  case 197:
#line 4164 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 13268 "parser.c" /* yacc.c:1646  */
    break;

  case 198:
#line 4171 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13276 "parser.c" /* yacc.c:1646  */
    break;

  case 199:
#line 4175 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 13284 "parser.c" /* yacc.c:1646  */
    break;

  case 200:
#line 4179 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[-1]));
  }
#line 13292 "parser.c" /* yacc.c:1646  */
    break;

  case 201:
#line 4183 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 13300 "parser.c" /* yacc.c:1646  */
    break;

  case 202:
#line 4190 "parser.y" /* yacc.c:1646  */
    {
	cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 13308 "parser.c" /* yacc.c:1646  */
    break;

  case 203:
#line 4194 "parser.y" /* yacc.c:1646  */
    {
	cb_list_add ((yyvsp[-3]), (yyvsp[0]));
  }
#line 13316 "parser.c" /* yacc.c:1646  */
    break;

  case 204:
#line 4200 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 13322 "parser.c" /* yacc.c:1646  */
    break;

  case 205:
#line 4201 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 13328 "parser.c" /* yacc.c:1646  */
    break;

  case 206:
#line 4202 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 13334 "parser.c" /* yacc.c:1646  */
    break;

  case 207:
#line 4203 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 13340 "parser.c" /* yacc.c:1646  */
    break;

  case 208:
#line 4204 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_norm_high; }
#line 13346 "parser.c" /* yacc.c:1646  */
    break;

  case 209:
#line 4205 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_norm_low; }
#line 13352 "parser.c" /* yacc.c:1646  */
    break;

  case 210:
#line 4209 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 13358 "parser.c" /* yacc.c:1646  */
    break;

  case 211:
#line 4210 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 13364 "parser.c" /* yacc.c:1646  */
    break;

  case 212:
#line 4218 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else if ((yyvsp[-1])) {
		CB_CHAIN_PAIR (current_program->symbolic_char_list, (yyvsp[-1]), (yyvsp[0]));
	}
  }
#line 13379 "parser.c" /* yacc.c:1646  */
    break;

  case 213:
#line 4232 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 13387 "parser.c" /* yacc.c:1646  */
    break;

  case 214:
#line 4236 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13395 "parser.c" /* yacc.c:1646  */
    break;

  case 215:
#line 4244 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13403 "parser.c" /* yacc.c:1646  */
    break;

  case 216:
#line 4251 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13411 "parser.c" /* yacc.c:1646  */
    break;

  case 217:
#line 4255 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
	} else {
		(yyval) = (yyvsp[-1]);
	}
  }
#line 13423 "parser.c" /* yacc.c:1646  */
    break;

  case 218:
#line 4266 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length ((yyvsp[-2])) != cb_list_length ((yyvsp[0]))) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		(yyval) = NULL;
	} else {
		l1 = (yyvsp[-2]);
		l2 = (yyvsp[0]);
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		(yyval) = (yyvsp[-2]);
	}
  }
#line 13444 "parser.c" /* yacc.c:1646  */
    break;

  case 219:
#line 4286 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		(yyval) = NULL;
	} else {
		(yyval) = CB_LIST_INIT ((yyvsp[0]));
	}
  }
#line 13456 "parser.c" /* yacc.c:1646  */
    break;

  case 220:
#line 4294 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		(yyval) = (yyvsp[-1]);
	} else {
		(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
	}
  }
#line 13468 "parser.c" /* yacc.c:1646  */
    break;

  case 221:
#line 4304 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 13474 "parser.c" /* yacc.c:1646  */
    break;

  case 222:
#line 4305 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 13480 "parser.c" /* yacc.c:1646  */
    break;

  case 223:
#line 4314 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 13494 "parser.c" /* yacc.c:1646  */
    break;

  case 226:
#line 4332 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *f;
	cb_tree v;

	v = CB_LIST_INIT ((yyvsp[0]));
	f = CB_FIELD (cb_build_constant ((yyvsp[-2]), v));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = v;
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 13514 "parser.c" /* yacc.c:1646  */
    break;

  case 227:
#line 4353 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name ((yyvsp[-4]), (yyvsp[-1]));
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
	}
  }
#line 13536 "parser.c" /* yacc.c:1646  */
    break;

  case 228:
#line 4373 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 13542 "parser.c" /* yacc.c:1646  */
    break;

  case 229:
#line 4374 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 13548 "parser.c" /* yacc.c:1646  */
    break;

  case 230:
#line 4379 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13556 "parser.c" /* yacc.c:1646  */
    break;

  case 231:
#line 4383 "parser.y" /* yacc.c:1646  */
    {
	if (CB_TREE_CLASS ((yyvsp[-2])) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P ((yyvsp[-2])) && CB_LITERAL ((yyvsp[-2]))->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS ((yyvsp[0])) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P ((yyvsp[0])) && CB_LITERAL ((yyvsp[0]))->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (literal_value ((yyvsp[-2])) <= literal_value ((yyvsp[0]))) {
		(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
	} else {
		(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-2]));
	}
  }
#line 13576 "parser.c" /* yacc.c:1646  */
    break;

  case 233:
#line 4403 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 13584 "parser.c" /* yacc.c:1646  */
    break;

  case 234:
#line 4407 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[0]), "NATIONAL CLASS");
	(yyval) = cb_int0;
  }
#line 13593 "parser.c" /* yacc.c:1646  */
    break;

  case 236:
#line 4416 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[0]), _("CLASS IS integer IN alphabet-name"));
	(yyval) = (yyvsp[0]);
  }
#line 13602 "parser.c" /* yacc.c:1646  */
    break;

  case 237:
#line 4426 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name ((yyvsp[-2]), (yyvsp[0]));
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 13622 "parser.c" /* yacc.c:1646  */
    break;

  case 238:
#line 4447 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if ((yyvsp[0])) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL ((yyvsp[-1]))->data;

			CB_PENDING_X ((yyvsp[-1]), _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x ((yyvsp[-1]), _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL ((yyvsp[-1]))->data);
		}
		if ((yyvsp[0])) {
			set_currency_picture_symbol ((yyvsp[0]));
		} else {
			if (!error_ind) {
				set_currency_picture_symbol ((yyvsp[-1]));
			}
		}
	}
  }
#line 13688 "parser.c" /* yacc.c:1646  */
    break;

  case 239:
#line 4513 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 13696 "parser.c" /* yacc.c:1646  */
    break;

  case 240:
#line 4517 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 13704 "parser.c" /* yacc.c:1646  */
    break;

  case 241:
#line 4526 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 13721 "parser.c" /* yacc.c:1646  */
    break;

  case 242:
#line 4545 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 13736 "parser.c" /* yacc.c:1646  */
    break;

  case 243:
#line 4561 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = (yyvsp[0]);
	}
  }
#line 13752 "parser.c" /* yacc.c:1646  */
    break;

  case 244:
#line 4579 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = (yyvsp[0]);
	}
  }
#line 13768 "parser.c" /* yacc.c:1646  */
    break;

  case 245:
#line 4597 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 13784 "parser.c" /* yacc.c:1646  */
    break;

  case 246:
#line 4614 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 13800 "parser.c" /* yacc.c:1646  */
    break;

  case 247:
#line 4631 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 13819 "parser.c" /* yacc.c:1646  */
    break;

  case 248:
#line 4646 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree && CB_VALID_TREE ((yyvsp[0]))) {
		cb_define ((yyvsp[0]), save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				(yyvsp[0]), save_tree);
	}
  }
#line 13831 "parser.c" /* yacc.c:1646  */
    break;

  case 251:
#line 4666 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 13840 "parser.c" /* yacc.c:1646  */
    break;

  case 253:
#line 4676 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 13850 "parser.c" /* yacc.c:1646  */
    break;

  case 256:
#line 4689 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE ((yyvsp[0]))) {
		/* Build new file */
		current_file = build_file ((yyvsp[0]));
		current_file->optional = CB_INTEGER ((yyvsp[-1]))->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else if (current_program->file_list) {
		current_program->file_list
			= CB_CHAIN (current_program->file_list);
	}
	key_type = NO_KEY;
  }
#line 13874 "parser.c" /* yacc.c:1646  */
    break;

  case 257:
#line 4709 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	if (CB_VALID_TREE ((yyvsp[-2]))) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, (yyvsp[-2]));
	}
  }
#line 13895 "parser.c" /* yacc.c:1646  */
    break;

  case 259:
#line 4730 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 13903 "parser.c" /* yacc.c:1646  */
    break;

  case 261:
#line 4737 "parser.y" /* yacc.c:1646  */
    {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 13912 "parser.c" /* yacc.c:1646  */
    break;

  case 281:
#line 4790 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
  }
#line 13926 "parser.c" /* yacc.c:1646  */
    break;

  case 282:
#line 4800 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
  }
#line 13940 "parser.c" /* yacc.c:1646  */
    break;

  case 283:
#line 4810 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
        cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
  }
#line 13955 "parser.c" /* yacc.c:1646  */
    break;

  case 284:
#line 4821 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, _("ASSIGN DISK FROM"));

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
  }
#line 13970 "parser.c" /* yacc.c:1646  */
    break;

  case 285:
#line 4832 "parser.y" /* yacc.c:1646  */
    {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 14001 "parser.c" /* yacc.c:1646  */
    break;

  case 286:
#line 4862 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 14009 "parser.c" /* yacc.c:1646  */
    break;

  case 287:
#line 4866 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 14017 "parser.c" /* yacc.c:1646  */
    break;

  case 289:
#line 4874 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 14025 "parser.c" /* yacc.c:1646  */
    break;

  case 290:
#line 4878 "parser.y" /* yacc.c:1646  */
    {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 14034 "parser.c" /* yacc.c:1646  */
    break;

  case 291:
#line 4883 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 14042 "parser.c" /* yacc.c:1646  */
    break;

  case 292:
#line 4887 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 14050 "parser.c" /* yacc.c:1646  */
    break;

  case 293:
#line 4895 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
  }
#line 14058 "parser.c" /* yacc.c:1646  */
    break;

  case 294:
#line 4899 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
  }
#line 14066 "parser.c" /* yacc.c:1646  */
    break;

  case 295:
#line 4903 "parser.y" /* yacc.c:1646  */
    {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
  }
#line 14074 "parser.c" /* yacc.c:1646  */
    break;

  case 307:
#line 4928 "parser.y" /* yacc.c:1646  */
    {
	current_file->flag_line_adv = 1;
  }
#line 14082 "parser.c" /* yacc.c:1646  */
    break;

  case 308:
#line 4935 "parser.y" /* yacc.c:1646  */
    {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 14091 "parser.c" /* yacc.c:1646  */
    break;

  case 309:
#line 4940 "parser.y" /* yacc.c:1646  */
    {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 14100 "parser.c" /* yacc.c:1646  */
    break;

  case 310:
#line 4948 "parser.y" /* yacc.c:1646  */
    {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 14108 "parser.c" /* yacc.c:1646  */
    break;

  case 311:
#line 4952 "parser.y" /* yacc.c:1646  */
    {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 14116 "parser.c" /* yacc.c:1646  */
    break;

  case 314:
#line 4966 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 14124 "parser.c" /* yacc.c:1646  */
    break;

  case 315:
#line 4972 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 14130 "parser.c" /* yacc.c:1646  */
    break;

  case 316:
#line 4973 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 14136 "parser.c" /* yacc.c:1646  */
    break;

  case 317:
#line 4974 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 14142 "parser.c" /* yacc.c:1646  */
    break;

  case 318:
#line 4982 "parser.y" /* yacc.c:1646  */
    {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = (yyvsp[-4]);
	p->component_list = NULL;
	if ((yyvsp[-2])) {
		p->duplicates = CB_INTEGER ((yyvsp[-2]))->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = (yyvsp[-1]);
	if ((yyvsp[0])
	 && CB_LITERAL_P ((yyvsp[0]))
	 && !CB_NUMERIC_LITERAL_P((yyvsp[0]))) {
		p->suppress = (yyvsp[0]);
	} else 
	if ((yyvsp[0])) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER ((yyvsp[0]))->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if ((yyvsp[-3])) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field((yyvsp[-4]));
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 14202 "parser.c" /* yacc.c:1646  */
    break;

  case 319:
#line 5041 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14210 "parser.c" /* yacc.c:1646  */
    break;

  case 321:
#line 5049 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("PASSWORD clause");
  }
#line 14218 "parser.c" /* yacc.c:1646  */
    break;

  case 322:
#line 5053 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14226 "parser.c" /* yacc.c:1646  */
    break;

  case 323:
#line 5074 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14234 "parser.c" /* yacc.c:1646  */
    break;

  case 324:
#line 5078 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (literal_value ((yyvsp[0])));
  }
#line 14242 "parser.c" /* yacc.c:1646  */
    break;

  case 325:
#line 5082 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (literal_value ((yyvsp[0])));
  }
#line 14250 "parser.c" /* yacc.c:1646  */
    break;

  case 326:
#line 5086 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14258 "parser.c" /* yacc.c:1646  */
    break;

  case 327:
#line 5096 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 14269 "parser.c" /* yacc.c:1646  */
    break;

  case 328:
#line 5106 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 14277 "parser.c" /* yacc.c:1646  */
    break;

  case 330:
#line 5114 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[0]);
  }
#line 14285 "parser.c" /* yacc.c:1646  */
    break;

  case 331:
#line 5118 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[-1]);
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 14295 "parser.c" /* yacc.c:1646  */
    break;

  case 332:
#line 5124 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[0]);
  }
#line 14303 "parser.c" /* yacc.c:1646  */
    break;

  case 333:
#line 5128 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 14312 "parser.c" /* yacc.c:1646  */
    break;

  case 334:
#line 5134 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = (yyvsp[-4]);
	CB_PENDING_X ((yyvsp[0]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[0]);
  }
#line 14322 "parser.c" /* yacc.c:1646  */
    break;

  case 335:
#line 5141 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[-4]), "NATIONAL COLLATING SEQUENCE");
	national_collation = (yyvsp[-4]);
	alphanumeric_collation = (yyvsp[0]);
  }
#line 14332 "parser.c" /* yacc.c:1646  */
    break;

  case 336:
#line 5150 "parser.y" /* yacc.c:1646  */
    {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-2])));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 14344 "parser.c" /* yacc.c:1646  */
    break;

  case 337:
#line 5161 "parser.y" /* yacc.c:1646  */
    {
	if (CB_ALPHABET_NAME_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not an alphabet-name"),
			cb_name ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 14358 "parser.c" /* yacc.c:1646  */
    break;

  case 338:
#line 5176 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = (yyvsp[-1]);
	if ((yyvsp[0])) {
		/* add a compiler configuration if either */
		if (cb_std_define != CB_STD_IBM
		 && cb_std_define != CB_STD_MVS
		 && !cb_relaxed_syntax_checks) {
			cb_verify (CB_UNCONFORMABLE, "VSAM STATUS");
		} else {
			cb_warning (cb_warn_extra, _("%s ignored"), "VSAM STATUS");
		}
	}
  }
#line 14377 "parser.c" /* yacc.c:1646  */
    break;

  case 342:
#line 5201 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 14385 "parser.c" /* yacc.c:1646  */
    break;

  case 344:
#line 5209 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 14393 "parser.c" /* yacc.c:1646  */
    break;

  case 345:
#line 5213 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 14401 "parser.c" /* yacc.c:1646  */
    break;

  case 346:
#line 5217 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 14409 "parser.c" /* yacc.c:1646  */
    break;

  case 349:
#line 5226 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 14417 "parser.c" /* yacc.c:1646  */
    break;

  case 350:
#line 5230 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= (COB_LOCK_ROLLBACK|COB_LOCK_MULTIPLE);
  }
#line 14425 "parser.c" /* yacc.c:1646  */
    break;

  case 353:
#line 5241 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 14433 "parser.c" /* yacc.c:1646  */
    break;

  case 355:
#line 5248 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 14447 "parser.c" /* yacc.c:1646  */
    break;

  case 358:
#line 5269 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 14457 "parser.c" /* yacc.c:1646  */
    break;

  case 359:
#line 5275 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 14467 "parser.c" /* yacc.c:1646  */
    break;

  case 360:
#line 5281 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 14477 "parser.c" /* yacc.c:1646  */
    break;

  case 361:
#line 5287 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 14488 "parser.c" /* yacc.c:1646  */
    break;

  case 362:
#line 5300 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 14497 "parser.c" /* yacc.c:1646  */
    break;

  case 363:
#line 5310 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 14506 "parser.c" /* yacc.c:1646  */
    break;

  case 365:
#line 5319 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_extra,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 14520 "parser.c" /* yacc.c:1646  */
    break;

  case 366:
#line 5329 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	    && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	    && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 14537 "parser.c" /* yacc.c:1646  */
    break;

  case 367:
#line 5342 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	    && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 14553 "parser.c" /* yacc.c:1646  */
    break;

  case 368:
#line 5354 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_extra,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name ((yyvsp[0])));
	}
  }
#line 14567 "parser.c" /* yacc.c:1646  */
    break;

  case 369:
#line 5369 "parser.y" /* yacc.c:1646  */
    {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = (yyvsp[-3]);
	key_type = RECORD_KEY;

	/* handle split keys */
	if ((yyvsp[-2])) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field ((yyvsp[-3]));
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = (yyvsp[-1]);
	if ((yyvsp[0])) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER ((yyvsp[0]))->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 14606 "parser.c" /* yacc.c:1646  */
    break;

  case 370:
#line 5407 "parser.y" /* yacc.c:1646  */
    {
  	(yyval) = NULL;
  }
#line 14614 "parser.c" /* yacc.c:1646  */
    break;

  case 371:
#line 5411 "parser.y" /* yacc.c:1646  */
    {
  	(yyval) = cb_int0;
  }
#line 14622 "parser.c" /* yacc.c:1646  */
    break;

  case 374:
#line 5422 "parser.y" /* yacc.c:1646  */
    {
	key_component_list = NULL;
  }
#line 14630 "parser.c" /* yacc.c:1646  */
    break;

  case 377:
#line 5432 "parser.y" /* yacc.c:1646  */
    {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = (yyvsp[0]);
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 14647 "parser.c" /* yacc.c:1646  */
    break;

  case 378:
#line 5450 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = (yyvsp[0]);
	key_type = RELATIVE_KEY;
  }
#line 14657 "parser.c" /* yacc.c:1646  */
    break;

  case 379:
#line 5461 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 14665 "parser.c" /* yacc.c:1646  */
    break;

  case 382:
#line 5475 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = (yyvsp[0]);
  }
#line 14674 "parser.c" /* yacc.c:1646  */
    break;

  case 383:
#line 5482 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_SHARE_ALL_OTHER); }
#line 14680 "parser.c" /* yacc.c:1646  */
    break;

  case 384:
#line 5483 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_SHARE_NO_OTHER); }
#line 14686 "parser.c" /* yacc.c:1646  */
    break;

  case 385:
#line 5484 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_SHARE_READ_ONLY); }
#line 14692 "parser.c" /* yacc.c:1646  */
    break;

  case 386:
#line 5491 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 14701 "parser.c" /* yacc.c:1646  */
    break;

  case 389:
#line 5506 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 14710 "parser.c" /* yacc.c:1646  */
    break;

  case 390:
#line 5516 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 14719 "parser.c" /* yacc.c:1646  */
    break;

  case 391:
#line 5526 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 14728 "parser.c" /* yacc.c:1646  */
    break;

  case 392:
#line 5536 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 14737 "parser.c" /* yacc.c:1646  */
    break;

  case 394:
#line 5547 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 14745 "parser.c" /* yacc.c:1646  */
    break;

  case 395:
#line 5554 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 14755 "parser.c" /* yacc.c:1646  */
    break;

  case 398:
#line 5564 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 14763 "parser.c" /* yacc.c:1646  */
    break;

  case 405:
#line 5585 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER ((yyvsp[-3]))->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 14792 "parser.c" /* yacc.c:1646  */
    break;

  case 406:
#line 5612 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 14798 "parser.c" /* yacc.c:1646  */
    break;

  case 407:
#line 5613 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 14804 "parser.c" /* yacc.c:1646  */
    break;

  case 408:
#line 5614 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 14810 "parser.c" /* yacc.c:1646  */
    break;

  case 409:
#line 5615 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 14816 "parser.c" /* yacc.c:1646  */
    break;

  case 410:
#line 5622 "parser.y" /* yacc.c:1646  */
    {
	current_program->apply_commit = (yyvsp[0]);
	CB_PENDING("APPLY COMMIT");
  }
#line 14825 "parser.c" /* yacc.c:1646  */
    break;

  case 411:
#line 5627 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 14833 "parser.c" /* yacc.c:1646  */
    break;

  case 412:
#line 5631 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 14841 "parser.c" /* yacc.c:1646  */
    break;

  case 414:
#line 5636 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 14849 "parser.c" /* yacc.c:1646  */
    break;

  case 423:
#line 5656 "parser.y" /* yacc.c:1646  */
    {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 14858 "parser.c" /* yacc.c:1646  */
    break;

  case 424:
#line 5661 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 14870 "parser.c" /* yacc.c:1646  */
    break;

  case 434:
#line 5704 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_WORKING;
  }
#line 14878 "parser.c" /* yacc.c:1646  */
    break;

  case 438:
#line 5721 "parser.y" /* yacc.c:1646  */
    {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 14886 "parser.c" /* yacc.c:1646  */
    break;

  case 440:
#line 5730 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 14896 "parser.c" /* yacc.c:1646  */
    break;

  case 443:
#line 5744 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE ((yyvsp[0]))) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD ((yyvsp[0])));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 14913 "parser.c" /* yacc.c:1646  */
    break;

  case 444:
#line 5762 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE ((yyvsp[0]))) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref ((yyvsp[0])));
	if (CB_VALID_TREE (current_file)) {
		if ((yyvsp[-1]) == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x ((yyvsp[0]), _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 14939 "parser.c" /* yacc.c:1646  */
    break;

  case 446:
#line 5785 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 14947 "parser.c" /* yacc.c:1646  */
    break;

  case 447:
#line 5792 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 14955 "parser.c" /* yacc.c:1646  */
    break;

  case 448:
#line 5796 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 14963 "parser.c" /* yacc.c:1646  */
    break;

  case 451:
#line 5807 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	current_file->flag_external = 1;
  }
#line 14977 "parser.c" /* yacc.c:1646  */
    break;

  case 452:
#line 5817 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 14996 "parser.c" /* yacc.c:1646  */
    break;

  case 462:
#line 5847 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 15005 "parser.c" /* yacc.c:1646  */
    break;

  case 466:
#line 5860 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_extra, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, (yyvsp[-1]));
	}
  }
#line 15018 "parser.c" /* yacc.c:1646  */
    break;

  case 467:
#line 5869 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_extra, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size ((yyvsp[-3]), (yyvsp[-1]));
	}
  }
#line 15031 "parser.c" /* yacc.c:1646  */
    break;

  case 468:
#line 5879 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size ((yyvsp[-3]), (yyvsp[-2]));
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 15042 "parser.c" /* yacc.c:1646  */
    break;

  case 470:
#line 5889 "parser.y" /* yacc.c:1646  */
    {
	current_file->record_depending = (yyvsp[0]);
  }
#line 15050 "parser.c" /* yacc.c:1646  */
    break;

  case 471:
#line 5895 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 15056 "parser.c" /* yacc.c:1646  */
    break;

  case 472:
#line 5896 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 15062 "parser.c" /* yacc.c:1646  */
    break;

  case 473:
#line 5900 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 15068 "parser.c" /* yacc.c:1646  */
    break;

  case 474:
#line 5901 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 15074 "parser.c" /* yacc.c:1646  */
    break;

  case 475:
#line 5909 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 15083 "parser.c" /* yacc.c:1646  */
    break;

  case 476:
#line 5920 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 15092 "parser.c" /* yacc.c:1646  */
    break;

  case 477:
#line 5925 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	}
  }
#line 15104 "parser.c" /* yacc.c:1646  */
    break;

  case 482:
#line 5948 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 15113 "parser.c" /* yacc.c:1646  */
    break;

  case 483:
#line 5960 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = (yyvsp[-2]);
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 15132 "parser.c" /* yacc.c:1646  */
    break;

  case 489:
#line 5988 "parser.y" /* yacc.c:1646  */
    {
	current_file->latfoot = (yyvsp[0]);
  }
#line 15140 "parser.c" /* yacc.c:1646  */
    break;

  case 490:
#line 5995 "parser.y" /* yacc.c:1646  */
    {
	current_file->lattop = (yyvsp[0]);
  }
#line 15148 "parser.c" /* yacc.c:1646  */
    break;

  case 491:
#line 6002 "parser.y" /* yacc.c:1646  */
    {
	current_file->latbot = (yyvsp[0]);
  }
#line 15156 "parser.c" /* yacc.c:1646  */
    break;

  case 492:
#line 6011 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 15166 "parser.c" /* yacc.c:1646  */
    break;

  case 497:
#line 6024 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 15176 "parser.c" /* yacc.c:1646  */
    break;

  case 500:
#line 6040 "parser.y" /* yacc.c:1646  */
    {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE ((yyvsp[-1]))) {
		al = CB_ALPHABET_NAME (cb_ref ((yyvsp[-1])));
		switch (al->alphabet_type) {
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
		case CB_ALPHABET_CUSTOM:
			current_file->code_set = al;
			CB_PENDING ("CODE-SET");
			break;
		default:
			if (cb_warn_extra) {
				cb_warning_x (cb_warn_extra, (yyvsp[-1]), _("ignoring CODE-SET '%s'"),
						  cb_name ((yyvsp[-1])));
			} else {
				CB_PENDING ("CODE-SET");
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 15215 "parser.c" /* yacc.c:1646  */
    break;

  case 502:
#line 6078 "parser.y" /* yacc.c:1646  */
    {
	  CB_PENDING ("FOR sub-records");
	  current_file->code_set_items = CB_LIST ((yyvsp[0]));
  }
#line 15224 "parser.c" /* yacc.c:1646  */
    break;

  case 503:
#line 6088 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = (yyvsp[0]);
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 15240 "parser.c" /* yacc.c:1646  */
    break;

  case 506:
#line 6108 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[0]))) {
		current_report = build_report ((yyvsp[0]));
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15258 "parser.c" /* yacc.c:1646  */
    break;

  case 507:
#line 6122 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[0]))) {
		current_report = build_report ((yyvsp[0]));
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 15276 "parser.c" /* yacc.c:1646  */
    break;

  case 509:
#line 6141 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 15295 "parser.c" /* yacc.c:1646  */
    break;

  case 513:
#line 6165 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE ((yyvsp[0]))) {
			cb_finalize_cd (current_cd, CB_FIELD ((yyvsp[0])));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 15309 "parser.c" /* yacc.c:1646  */
    break;

  case 514:
#line 6180 "parser.y" /* yacc.c:1646  */
    {
	/* CD internally defines a new file */
	if (CB_VALID_TREE ((yyvsp[0]))) {
		current_cd = cb_build_cd ((yyvsp[0]));

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 15331 "parser.c" /* yacc.c:1646  */
    break;

  case 562:
#line 6288 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 15341 "parser.c" /* yacc.c:1646  */
    break;

  case 563:
#line 6294 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD ((yyvsp[0])));
	}
  }
#line 15351 "parser.c" /* yacc.c:1646  */
    break;

  case 564:
#line 6303 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 15359 "parser.c" /* yacc.c:1646  */
    break;

  case 565:
#line 6307 "parser.y" /* yacc.c:1646  */
    {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 15370 "parser.c" /* yacc.c:1646  */
    break;

  case 566:
#line 6314 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *p;
	/* finalize last field if target of SAME AS */
	if (current_field && !CB_INVALID_TREE (current_field->same_as)) {
		inherit_same_as ();
	}

	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	(yyval) = CB_TREE (description_field);
  }
#line 15387 "parser.c" /* yacc.c:1646  */
    break;

  case 572:
#line 6338 "parser.y" /* yacc.c:1646  */
    {
	if (current_field && !CB_INVALID_TREE (current_field->same_as)) {
		/* finalize last field if target of SAME AS */
		inherit_same_as ();
	}
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 15402 "parser.c" /* yacc.c:1646  */
    break;

  case 573:
#line 6349 "parser.y" /* yacc.c:1646  */
    {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 15415 "parser.c" /* yacc.c:1646  */
    break;

  case 574:
#line 6358 "parser.y" /* yacc.c:1646  */
    {
#if 0 /* works fine without, leads to invalid free otherwise [COB_TREE_DEBUG] */
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-2]));
#endif
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 15433 "parser.c" /* yacc.c:1646  */
    break;

  case 575:
#line 6375 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15441 "parser.c" /* yacc.c:1646  */
    break;

  case 578:
#line 6387 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15452 "parser.c" /* yacc.c:1646  */
    break;

  case 580:
#line 6398 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	qualifier = (yyvsp[0]);
	keys_list = NULL;
	non_const_word = 0;
  }
#line 15463 "parser.c" /* yacc.c:1646  */
    break;

  case 581:
#line 6408 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 15471 "parser.c" /* yacc.c:1646  */
    break;

  case 582:
#line 6412 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		(yyval) = NULL;
	} else {
		(yyval) = cb_null;
	}
  }
#line 15484 "parser.c" /* yacc.c:1646  */
    break;

  case 583:
#line 6423 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 15490 "parser.c" /* yacc.c:1646  */
    break;

  case 584:
#line 6424 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_const_length ((yyvsp[0])); }
#line 15496 "parser.c" /* yacc.c:1646  */
    break;

  case 585:
#line 6426 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_const_length ((yyvsp[0])); }
#line 15502 "parser.c" /* yacc.c:1646  */
    break;

  case 586:
#line 6431 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15510 "parser.c" /* yacc.c:1646  */
    break;

  case 587:
#line 6435 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15518 "parser.c" /* yacc.c:1646  */
    break;

  case 588:
#line 6441 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 15526 "parser.c" /* yacc.c:1646  */
    break;

  case 589:
#line 6445 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int2;
  }
#line 15534 "parser.c" /* yacc.c:1646  */
    break;

  case 590:
#line 6449 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int4;
  }
#line 15542 "parser.c" /* yacc.c:1646  */
    break;

  case 591:
#line 6453 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int8;
  }
#line 15550 "parser.c" /* yacc.c:1646  */
    break;

  case 592:
#line 6457 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(long));
  }
#line 15558 "parser.c" /* yacc.c:1646  */
    break;

  case 593:
#line 6461 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(void *));
  }
#line 15566 "parser.c" /* yacc.c:1646  */
    break;

  case 594:
#line 6465 "parser.y" /* yacc.c:1646  */
    {
	if (cb_binary_comp_1) {
		(yyval) = cb_int2;
	} else {
		(yyval) = cb_int ((int)sizeof(float));
	}
  }
#line 15578 "parser.c" /* yacc.c:1646  */
    break;

  case 595:
#line 6473 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(float));
  }
#line 15586 "parser.c" /* yacc.c:1646  */
    break;

  case 596:
#line 6477 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(double));
  }
#line 15594 "parser.c" /* yacc.c:1646  */
    break;

  case 597:
#line 6481 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int4;
  }
#line 15602 "parser.c" /* yacc.c:1646  */
    break;

  case 598:
#line 6485 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int8;
  }
#line 15610 "parser.c" /* yacc.c:1646  */
    break;

  case 599:
#line 6489 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int16;
  }
#line 15618 "parser.c" /* yacc.c:1646  */
    break;

  case 600:
#line 6493 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 15630 "parser.c" /* yacc.c:1646  */
    break;

  case 610:
#line 6525 "parser.y" /* yacc.c:1646  */
    {
	cb_tree renames_target = cb_ref ((yyvsp[-1]));

	size_t sav = cb_needs_01;
	cb_needs_01 = 0;

	non_const_word = 0;

	if (set_current_field ((yyvsp[-5]), (yyvsp[-4]))) {
		/* error in the definition, no further checks possible */
	} else if (renames_target == cb_error_node) {
		/* error in the target, skip further checks */
		current_field->flag_invalid = 1;
	} else {
		cb_tree renames_thru = (yyvsp[0]);

		current_field->redefines = CB_FIELD (renames_target);
		if (renames_thru) {
			renames_thru = cb_ref (renames_thru);
		}
		if (CB_VALID_TREE (renames_thru)) {
			current_field->rename_thru = CB_FIELD (renames_thru);
		} else {
			/* If there is no THRU clause, RENAMES acts like REDEFINES. */
			current_field->pic = current_field->redefines->pic;
		}

		if (cb_validate_renames_item (current_field, (yyvsp[-1]), (yyvsp[0]))) {
			current_field->flag_invalid = 1;
		} else {
			/* ensure the reference was validated as this
			   also calculates the reference' picture and size */
			if (!current_field->redefines->flag_is_verified) {
				cb_validate_field (current_field->redefines);
			}
		}
	}
	cb_needs_01 = sav;
  }
#line 15674 "parser.c" /* yacc.c:1646  */
    break;

  case 611:
#line 6568 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 15682 "parser.c" /* yacc.c:1646  */
    break;

  case 612:
#line 6572 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]) == cb_error_node ? NULL : (yyvsp[0]);
  }
#line 15690 "parser.c" /* yacc.c:1646  */
    break;

  case 613:
#line 6579 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
  }
#line 15700 "parser.c" /* yacc.c:1646  */
    break;

  case 614:
#line 6585 "parser.y" /* yacc.c:1646  */
    {
	cb_validate_88_item (current_field);
  }
#line 15708 "parser.c" /* yacc.c:1646  */
    break;

  case 615:
#line 6592 "parser.y" /* yacc.c:1646  */
    {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level ((yyvsp[-4]));
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-4]));
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if ((yyvsp[0])) {
		if (cb_verify(cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant ((yyvsp[-3]), (yyvsp[0]));
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = (yyvsp[0]);
			cb_needs_01 = 1;
			if ((yyvsp[-1])) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 15739 "parser.c" /* yacc.c:1646  */
    break;

  case 616:
#line 6619 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
  }
#line 15749 "parser.c" /* yacc.c:1646  */
    break;

  case 617:
#line 6626 "parser.y" /* yacc.c:1646  */
    {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 15758 "parser.c" /* yacc.c:1646  */
    break;

  case 618:
#line 6634 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15766 "parser.c" /* yacc.c:1646  */
    break;

  case 619:
#line 6638 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT(cb_build_const_from ((yyvsp[0])));
  }
#line 15774 "parser.c" /* yacc.c:1646  */
    break;

  case 620:
#line 6645 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE (current_field)) {
		current_field->values = (yyvsp[0]);
	}
  }
#line 15784 "parser.c" /* yacc.c:1646  */
    break;

  case 621:
#line 6651 "parser.y" /* yacc.c:1646  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_start (current_field, (yyvsp[0])));
  }
#line 15792 "parser.c" /* yacc.c:1646  */
    break;

  case 622:
#line 6655 "parser.y" /* yacc.c:1646  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_next (current_field));
  }
#line 15800 "parser.c" /* yacc.c:1646  */
    break;

  case 623:
#line 6661 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 15806 "parser.c" /* yacc.c:1646  */
    break;

  case 624:
#line 6662 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 15812 "parser.c" /* yacc.c:1646  */
    break;

  case 625:
#line 6666 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 15818 "parser.c" /* yacc.c:1646  */
    break;

  case 626:
#line 6667 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("(", 1); }
#line 15824 "parser.c" /* yacc.c:1646  */
    break;

  case 627:
#line 6668 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal (")", 1); }
#line 15830 "parser.c" /* yacc.c:1646  */
    break;

  case 628:
#line 6669 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("+", 1); }
#line 15836 "parser.c" /* yacc.c:1646  */
    break;

  case 629:
#line 6670 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("-", 1); }
#line 15842 "parser.c" /* yacc.c:1646  */
    break;

  case 630:
#line 6671 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("*", 1); }
#line 15848 "parser.c" /* yacc.c:1646  */
    break;

  case 631:
#line 6672 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("/", 1); }
#line 15854 "parser.c" /* yacc.c:1646  */
    break;

  case 632:
#line 6673 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("&", 1); }
#line 15860 "parser.c" /* yacc.c:1646  */
    break;

  case 633:
#line 6674 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("|", 1); }
#line 15866 "parser.c" /* yacc.c:1646  */
    break;

  case 634:
#line 6675 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("^", 1); }
#line 15872 "parser.c" /* yacc.c:1646  */
    break;

  case 637:
#line 6685 "parser.y" /* yacc.c:1646  */
    {
	save_tree = cb_int0;
  }
#line 15880 "parser.c" /* yacc.c:1646  */
    break;

  case 657:
#line 6717 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if (save_tree != NULL) {
		cb_verify_x ((yyvsp[0]), cb_free_redefines_position,
			     _("REDEFINES clause not following entry-name"));
	}

	current_field->redefines = cb_resolve_redefines (current_field, (yyvsp[0]));
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 15899 "parser.c" /* yacc.c:1646  */
    break;

  case 658:
#line 6738 "parser.y" /* yacc.c:1646  */
    {
	cb_tree x = (yyvsp[0]);
	check_repeated ("SAME AS", SYN_CLAUSE_30, &check_pic_duplicate);
	
	/* note: syntax checks for conflicting clauses done in inherit_same_as */
	if (cb_verify (cb_same_as_clause, _("SAME AS clause"))
	 && x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));
		if (f->storage == CB_STORAGE_SCREEN) {
			cb_error (_("SCREEN item cannot be used here"));
			x = cb_error_node;
		} else if (f->storage == CB_STORAGE_REPORT) {
			cb_error (_("REPORT item cannot be used here"));
			x = cb_error_node;
		} else if (f->level == 88) {
			cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
			x = cb_error_node;
		} else if (current_field->level == 77) {
			if (f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p;
			for (p = current_field; p; p = p->parent) {
				if (p == f) {
					cb_error (_ ("SAME AS item may not reference itself"));
					x = cb_error_node;
					break;
				}
			}
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("SAME AS item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("SAME AS item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->same_as = x;
	} else {
		current_field->same_as = cb_ref (x);
	}
  }
#line 15957 "parser.c" /* yacc.c:1646  */
    break;

  case 659:
#line 6798 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 15985 "parser.c" /* yacc.c:1646  */
    break;

  case 660:
#line 6825 "parser.y" /* yacc.c:1646  */
    {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 15993 "parser.c" /* yacc.c:1646  */
    break;

  case 661:
#line 6829 "parser.y" /* yacc.c:1646  */
    {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL ((yyvsp[0]))->data);
  }
#line 16001 "parser.c" /* yacc.c:1646  */
    break;

  case 664:
#line 6842 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 16024 "parser.c" /* yacc.c:1646  */
    break;

  case 665:
#line 6866 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_verify (cb_special_names_clause, "SPECIAL-NAMES clause");
	}
  }
#line 16036 "parser.c" /* yacc.c:1646  */
    break;

  case 667:
#line 6878 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		current_program->cursor_pos = cb_build_reference (current_field->name);
	}
  }
#line 16048 "parser.c" /* yacc.c:1646  */
    break;

  case 668:
#line 6886 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->crt_status) {
		emit_duplicate_clause_message ("CRT STATUS");
	} else {
		current_program->crt_status = cb_build_reference (current_field->name);
	}
  }
#line 16060 "parser.c" /* yacc.c:1646  */
    break;

  case 669:
#line 6903 "parser.y" /* yacc.c:1646  */
    {
#if 0 /* not yet implemented */
	if (current_program->screen_control) {
		emit_duplicate_clause_message ("SCREEN CONTROL");
	} else {
		CB_PENDING ("SCREEN CONTROL");
	}
#else
	CB_PENDING ("SCREEN CONTROL");
#endif
  }
#line 16076 "parser.c" /* yacc.c:1646  */
    break;

  case 670:
#line 6915 "parser.y" /* yacc.c:1646  */
    {
#if 0 /* not yet implemented */
	if (current_program->event_status) {
		emit_duplicate_clause_message ("EVENT STATUS");
	} else {
		CB_PENDING ("EVENT STATUS");
	}
#else
	CB_PENDING ("EVENT STATUS");
#endif
  }
#line 16092 "parser.c" /* yacc.c:1646  */
    break;

  case 671:
#line 6932 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VOLATILE", SYN_CLAUSE_24, &check_pic_duplicate);
	/* note: there is no reason to check current_storage as we only parse
	         volatile_clause and its parent tokens where applicable,
	         same is true for level 66,78,88 */
	/* missing part: always generate and initialize storage */
	CB_UNFINISHED ("VOLATILE");
	current_field->flag_volatile = 1;
	/* TODO: set VOLATILE flag for all parent fields */
  }
#line 16107 "parser.c" /* yacc.c:1646  */
    break;

  case 672:
#line 6950 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE ((yyvsp[-1]));

	if ((yyvsp[0]) && (yyvsp[0]) != cb_error_node) {
		if (  (current_field->pic->category != CB_CATEGORY_NUMERIC
		    && current_field->pic->category != CB_CATEGORY_NUMERIC_EDITED)
		 || strpbrk (current_field->pic->orig, " CRDB-*") /* the standard seems to forbid also ',' */) {
			cb_error_x ((yyvsp[-1]), _("a locale-format PICTURE string must only consist of '9', '.', '+', 'Z' and the currency-sign"));
		} else {
			/* TODO: check that not in or part of CONSTANT RECORD */
			CB_PENDING_X ((yyvsp[-1]), "locale-format PICTURE");
		}
	}
  }
#line 16127 "parser.c" /* yacc.c:1646  */
    break;

  case 673:
#line 6969 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16133 "parser.c" /* yacc.c:1646  */
    break;

  case 674:
#line 6971 "parser.y" /* yacc.c:1646  */
    {
	/* $2 -> optional locale-name to be used */
	(yyval) = (yyvsp[0]);
  }
#line 16142 "parser.c" /* yacc.c:1646  */
    break;

  case 676:
#line 6980 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16150 "parser.c" /* yacc.c:1646  */
    break;

  case 677:
#line 6988 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LOCALE_NAME_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a locale-name"),	cb_name ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 16163 "parser.c" /* yacc.c:1646  */
    break;

  case 680:
#line 7005 "parser.y" /* yacc.c:1646  */
    {
	if (is_reserved_word (CB_NAME ((yyvsp[0])))) {
		cb_error_x ((yyvsp[0]), _("'%s' is not a valid USAGE"), CB_NAME ((yyvsp[0])));
	} else if (is_default_reserved_word (CB_NAME ((yyvsp[0])))) {
		cb_error_x ((yyvsp[0]), _("'%s' is not defined, but is a reserved word in another dialect"),
				CB_NAME ((yyvsp[0])));
	} else {
		cb_error_x ((yyvsp[0]), _("unknown USAGE: %s"), CB_NAME ((yyvsp[0])));
	}
	check_and_set_usage (CB_USAGE_ERROR);
	YYERROR;
  }
#line 16180 "parser.c" /* yacc.c:1646  */
    break;

  case 681:
#line 7018 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_ERROR);
  }
#line 16188 "parser.c" /* yacc.c:1646  */
    break;

  case 682:
#line 7025 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16196 "parser.c" /* yacc.c:1646  */
    break;

  case 683:
#line 7029 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BIT);
	CB_PENDING ("USAGE BIT");
  }
#line 16205 "parser.c" /* yacc.c:1646  */
    break;

  case 684:
#line 7034 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16213 "parser.c" /* yacc.c:1646  */
    break;

  case 685:
#line 7038 "parser.y" /* yacc.c:1646  */
    {
	/* see FR #310 */
	CB_PENDING ("USAGE COMP-0");
  }
#line 16222 "parser.c" /* yacc.c:1646  */
    break;

  case 686:
#line 7043 "parser.y" /* yacc.c:1646  */
    {
	current_field->flag_comp_1 = 1;
	if (cb_binary_comp_1) {
		check_and_set_usage (CB_USAGE_SIGNED_SHORT);
		current_field->flag_synchronized = 1;
	} else {
		check_and_set_usage (CB_USAGE_FLOAT);
	}
  }
#line 16236 "parser.c" /* yacc.c:1646  */
    break;

  case 687:
#line 7053 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 16244 "parser.c" /* yacc.c:1646  */
    break;

  case 688:
#line 7057 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16252 "parser.c" /* yacc.c:1646  */
    break;

  case 689:
#line 7061 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 16260 "parser.c" /* yacc.c:1646  */
    break;

  case 690:
#line 7065 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 16268 "parser.c" /* yacc.c:1646  */
    break;

  case 691:
#line 7069 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 16276 "parser.c" /* yacc.c:1646  */
    break;

  case 692:
#line 7073 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 16284 "parser.c" /* yacc.c:1646  */
    break;

  case 693:
#line 7077 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_N);
  }
#line 16292 "parser.c" /* yacc.c:1646  */
    break;

  case 694:
#line 7081 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 16300 "parser.c" /* yacc.c:1646  */
    break;

  case 695:
#line 7085 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 16308 "parser.c" /* yacc.c:1646  */
    break;

  case 696:
#line 7089 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 16316 "parser.c" /* yacc.c:1646  */
    break;

  case 697:
#line 7093 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 16324 "parser.c" /* yacc.c:1646  */
    break;

  case 698:
#line 7097 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16333 "parser.c" /* yacc.c:1646  */
    break;

  case 699:
#line 7102 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 16342 "parser.c" /* yacc.c:1646  */
    break;

  case 700:
#line 7107 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 16350 "parser.c" /* yacc.c:1646  */
    break;

  case 701:
#line 7111 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 16358 "parser.c" /* yacc.c:1646  */
    break;

  case 702:
#line 7115 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 16366 "parser.c" /* yacc.c:1646  */
    break;

  case 703:
#line 7119 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 16375 "parser.c" /* yacc.c:1646  */
    break;

  case 704:
#line 7124 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 16383 "parser.c" /* yacc.c:1646  */
    break;

  case 705:
#line 7128 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 16392 "parser.c" /* yacc.c:1646  */
    break;

  case 706:
#line 7133 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 16400 "parser.c" /* yacc.c:1646  */
    break;

  case 707:
#line 7137 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 16409 "parser.c" /* yacc.c:1646  */
    break;

  case 708:
#line 7142 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	CB_PENDING ("HANDLE OF control-type");
  }
#line 16418 "parser.c" /* yacc.c:1646  */
    break;

  case 709:
#line 7147 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
	cb_error_x ((yyvsp[0]), _("unknown HANDLE type: %s"), CB_NAME ((yyvsp[0])));
  }
#line 16427 "parser.c" /* yacc.c:1646  */
    break;

  case 710:
#line 7152 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
	current_field->flag_synchronized = 1;
  }
#line 16436 "parser.c" /* yacc.c:1646  */
    break;

  case 711:
#line 7157 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
	current_field->flag_synchronized = 1;
  }
#line 16445 "parser.c" /* yacc.c:1646  */
    break;

  case 712:
#line 7162 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
	current_field->flag_synchronized = 1;
  }
#line 16458 "parser.c" /* yacc.c:1646  */
    break;

  case 713:
#line 7171 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
	current_field->flag_synchronized = 1;
  }
#line 16467 "parser.c" /* yacc.c:1646  */
    break;

  case 714:
#line 7176 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
	current_field->flag_synchronized = 1;
  }
#line 16476 "parser.c" /* yacc.c:1646  */
    break;

  case 715:
#line 7181 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
	current_field->flag_synchronized = 1;
  }
#line 16489 "parser.c" /* yacc.c:1646  */
    break;

  case 716:
#line 7190 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 16497 "parser.c" /* yacc.c:1646  */
    break;

  case 717:
#line 7194 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 16505 "parser.c" /* yacc.c:1646  */
    break;

  case 718:
#line 7198 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 16513 "parser.c" /* yacc.c:1646  */
    break;

  case 719:
#line 7202 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 16521 "parser.c" /* yacc.c:1646  */
    break;

  case 720:
#line 7206 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 16529 "parser.c" /* yacc.c:1646  */
    break;

  case 721:
#line 7210 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 16537 "parser.c" /* yacc.c:1646  */
    break;

  case 722:
#line 7214 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
  }
#line 16545 "parser.c" /* yacc.c:1646  */
    break;

  case 723:
#line 7218 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
  }
#line 16553 "parser.c" /* yacc.c:1646  */
    break;

  case 724:
#line 7222 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
	current_field->flag_synchronized = 1;
  }
#line 16566 "parser.c" /* yacc.c:1646  */
    break;

  case 725:
#line 7231 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
	current_field->flag_synchronized = 1;
  }
#line 16579 "parser.c" /* yacc.c:1646  */
    break;

  case 726:
#line 7240 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN32);
  }
#line 16587 "parser.c" /* yacc.c:1646  */
    break;

  case 727:
#line 7244 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN64);
  }
#line 16595 "parser.c" /* yacc.c:1646  */
    break;

  case 728:
#line 7248 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN128);
  }
#line 16603 "parser.c" /* yacc.c:1646  */
    break;

  case 729:
#line 7252 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC64);
  }
#line 16611 "parser.c" /* yacc.c:1646  */
    break;

  case 730:
#line 7256 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC128);
  }
#line 16619 "parser.c" /* yacc.c:1646  */
    break;

  case 731:
#line 7260 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	CB_UNFINISHED ("USAGE NATIONAL");
  }
#line 16628 "parser.c" /* yacc.c:1646  */
    break;

  case 743:
#line 7290 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = ((yyvsp[0]) ? 1 : 0);
	current_field->flag_sign_leading  = 1;
  }
#line 16639 "parser.c" /* yacc.c:1646  */
    break;

  case 744:
#line 7297 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = ((yyvsp[0]) ? 1 : 0);
	current_field->flag_sign_leading  = 0;
  }
#line 16650 "parser.c" /* yacc.c:1646  */
    break;

  case 745:
#line 7311 "parser.y" /* yacc.c:1646  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-4]), (yyvsp[-3]));
  }
#line 16660 "parser.c" /* yacc.c:1646  */
    break;

  case 747:
#line 7320 "parser.y" /* yacc.c:1646  */
    {
	current_field->step_count = cb_get_int ((yyvsp[0]));
  }
#line 16668 "parser.c" /* yacc.c:1646  */
    break;

  case 748:
#line 7330 "parser.y" /* yacc.c:1646  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-4]), (yyvsp[-3]));
  }
#line 16678 "parser.c" /* yacc.c:1646  */
    break;

  case 749:
#line 7337 "parser.y" /* yacc.c:1646  */
    {
	current_field->flag_unbounded = 1;
	if (current_field->parent) {
		current_field->parent->flag_unbounded = 1;
	}
	current_field->depending = (yyvsp[-1]);
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-6]), cb_int0);
  }
#line 16693 "parser.c" /* yacc.c:1646  */
    break;

  case 750:
#line 7349 "parser.y" /* yacc.c:1646  */
    {
	setup_occurs ();
	current_field->occurs_min = (yyvsp[-3]) ? cb_get_int ((yyvsp[-3])) : 0;
	if ((yyvsp[-2])) {
		current_field->occurs_max = cb_get_int ((yyvsp[-2]));
		if (current_field->occurs_max <= current_field->occurs_min) {
			cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
		}
	} else {
		current_field->occurs_max = 0;
	}
	CB_PENDING ("OCCURS DYNAMIC");
  }
#line 16711 "parser.c" /* yacc.c:1646  */
    break;

  case 751:
#line 7365 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16717 "parser.c" /* yacc.c:1646  */
    break;

  case 752:
#line 7366 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 16723 "parser.c" /* yacc.c:1646  */
    break;

  case 753:
#line 7370 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16729 "parser.c" /* yacc.c:1646  */
    break;

  case 754:
#line 7371 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 16735 "parser.c" /* yacc.c:1646  */
    break;

  case 755:
#line 7375 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16741 "parser.c" /* yacc.c:1646  */
    break;

  case 756:
#line 7376 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 16747 "parser.c" /* yacc.c:1646  */
    break;

  case 758:
#line 7381 "parser.y" /* yacc.c:1646  */
    {
	current_field->depending = (yyvsp[0]);
  }
#line 16755 "parser.c" /* yacc.c:1646  */
    break;

  case 760:
#line 7387 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_index ((yyvsp[0]), cb_zero, 0, current_field);
	CB_FIELD_PTR ((yyval))->index_type = CB_STATIC_INT_INDEX;
  }
#line 16764 "parser.c" /* yacc.c:1646  */
    break;

  case 762:
#line 7395 "parser.y" /* yacc.c:1646  */
    {
	/* current_field->initialized = 1; */
  }
#line 16772 "parser.c" /* yacc.c:1646  */
    break;

  case 765:
#line 7404 "parser.y" /* yacc.c:1646  */
    {
	if (!cb_relaxed_syntax_checks) {
		cb_error (_("INDEXED should follow ASCENDING/DESCENDING"));
	} else {
		cb_warning (cb_warn_extra, _("INDEXED should follow ASCENDING/DESCENDING"));
	}
  }
#line 16784 "parser.c" /* yacc.c:1646  */
    break;

  case 769:
#line 7418 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_tree		l;
		struct cb_key	*keys;
		int		i;
		int		nkeys;

		l = (yyvsp[0]);
		nkeys = cb_list_length ((yyvsp[0]));
		keys = cobc_parse_malloc (sizeof (struct cb_key) * nkeys);

		for (i = 0; i < nkeys; i++) {
			keys[i].dir = CB_PURPOSE_INT (l);
			keys[i].key = CB_VALUE (l);
			l = CB_CHAIN (l);
		}
		current_field->keys = keys;
		current_field->nkeys = nkeys;
	}
  }
#line 16809 "parser.c" /* yacc.c:1646  */
    break;

  case 772:
#line 7447 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l, item;
	struct cb_field *field;

	for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = (yyvsp[-3]);
		item = CB_VALUE (l);
		if (item == cb_error_node) {
			continue;
		}
		/* internally reference-modify each of the given keys */
		if (qualifier
#if 0 /* Simon: those are never reference-modified ... */
		  && !CB_REFERENCE(item)->chain
#endif /* the following is perfectly fine and would raise a syntax error
		  if we add the self-reference */
		  && strcasecmp (CB_NAME(item), CB_NAME(qualifier))) {
			/* reference by the OCCURS item */
			CB_REFERENCE(item)->chain = qualifier;
		}
		/* reference all the way up as later fields may have same name */
		for (field = CB_FIELD(cb_ref(qualifier))->parent; field; field = field->parent) {
			if (field->flag_filler) continue;
			CB_REFERENCE(item)->chain = cb_build_reference(field->name);
		}
	}
	keys_list = cb_list_append (keys_list, (yyvsp[0]));
	(yyval) = keys_list;
  }
#line 16843 "parser.c" /* yacc.c:1646  */
    break;

  case 773:
#line 7479 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_ASCENDING); }
#line 16849 "parser.c" /* yacc.c:1646  */
    break;

  case 774:
#line 7480 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_DESCENDING); }
#line 16855 "parser.c" /* yacc.c:1646  */
    break;

  case 777:
#line 7489 "parser.y" /* yacc.c:1646  */
    {
	current_field->index_list = (yyvsp[0]);
  }
#line 16863 "parser.c" /* yacc.c:1646  */
    break;

  case 778:
#line 7495 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 16869 "parser.c" /* yacc.c:1646  */
    break;

  case 779:
#line 7497 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 16875 "parser.c" /* yacc.c:1646  */
    break;

  case 780:
#line 7502 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_index ((yyvsp[0]), cb_int1, 1U, current_field);
	CB_FIELD_PTR ((yyval))->index_type = CB_STATIC_INT_INDEX;
  }
#line 16884 "parser.c" /* yacc.c:1646  */
    break;

  case 781:
#line 7513 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("JUSTIFIED", SYN_CLAUSE_8, &check_pic_duplicate);
	current_field->flag_justified = 1;
  }
#line 16893 "parser.c" /* yacc.c:1646  */
    break;

  case 782:
#line 7524 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SYNCHRONIZED", SYN_CLAUSE_9, &check_pic_duplicate);
	if (cb_verify (cb_synchronized_clause, _("SYNCHRONIZED clause"))) {
		current_field->flag_synchronized = 1;
	}
	if (with_attrs && cb_verify (cb_sync_left_right, _("LEFT/RIGHT phrases in SYNCHRONIZED clause"))) {
		if (current_field->flag_synchronized) {
			if (with_attrs == 1) {
				current_field->flag_sync_left = 1;
			} else {
				current_field->flag_sync_right = 1;
			}
		}
		CB_PENDING ("SYNCHRONIZED LEFT/RIGHT");
	}
  }
#line 16914 "parser.c" /* yacc.c:1646  */
    break;

  case 783:
#line 7543 "parser.y" /* yacc.c:1646  */
    { with_attrs = 0; }
#line 16920 "parser.c" /* yacc.c:1646  */
    break;

  case 784:
#line 7544 "parser.y" /* yacc.c:1646  */
    { with_attrs = 1; }
#line 16926 "parser.c" /* yacc.c:1646  */
    break;

  case 785:
#line 7545 "parser.y" /* yacc.c:1646  */
    { with_attrs = -1; }
#line 16932 "parser.c" /* yacc.c:1646  */
    break;

  case 786:
#line 7553 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK", SYN_CLAUSE_10, &check_pic_duplicate);
	current_field->flag_blank_zero = 1;
  }
#line 16941 "parser.c" /* yacc.c:1646  */
    break;

  case 787:
#line 7564 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BASED", SYN_CLAUSE_11, &check_pic_duplicate);
	if (current_storage == CB_STORAGE_FILE) {
		cb_error (_("%s not allowed here"), "BASED");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "BASED");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "BASED");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "REDEFINES");
	} else if (current_field->flag_any_length) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else {
		current_field->flag_item_based = 1;
	}
  }
#line 16966 "parser.c" /* yacc.c:1646  */
    break;

  case 788:
#line 7590 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = (yyvsp[0]);
  }
#line 16975 "parser.c" /* yacc.c:1646  */
    break;

  case 790:
#line 7598 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 16981 "parser.c" /* yacc.c:1646  */
    break;

  case 791:
#line 7599 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 16987 "parser.c" /* yacc.c:1646  */
    break;

  case 792:
#line 7603 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0])); }
#line 16993 "parser.c" /* yacc.c:1646  */
    break;

  case 795:
#line 7610 "parser.y" /* yacc.c:1646  */
    {
	if (current_field->level != 88) {
		cb_error (_("FALSE clause only allowed for 88 level"));
	}
	current_field->false_88 = CB_LIST_INIT ((yyvsp[0]));
  }
#line 17004 "parser.c" /* yacc.c:1646  */
    break;

  case 796:
#line 7622 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else {
		current_field->flag_any_length = 1;
	}
  }
#line 17017 "parser.c" /* yacc.c:1646  */
    break;

  case 797:
#line 7631 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY NUMERIC");
	} else {
		current_field->flag_any_length = 1;
		current_field->flag_any_numeric = 1;
	}
  }
#line 17031 "parser.c" /* yacc.c:1646  */
    break;

  case 798:
#line 7646 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("EXTERNAL-FORM", SYN_CLAUSE_2, &check_pic_duplicate);
	CB_PENDING ("EXTERNAL-FORM");
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL-FORM");
	} else if (current_field->level != 1) {	/* docs say: at group level */
		cb_error (_("%s only allowed at 01 level"), "EXTERNAL-FORM");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL-FORM");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s combination not allowed"), "EXTERNAL-FORM", "REDEFINES");
	} else {
		current_field->flag_is_external_form = 1;
	}
  }
#line 17051 "parser.c" /* yacc.c:1646  */
    break;

  case 799:
#line 7669 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("IDENTIFIED BY", SYN_CLAUSE_3, &check_pic_duplicate);
	if (!current_field->flag_is_external_form) {
		CB_PENDING ("EXTERNAL-FORM (IDENTIFIED BY)");
		if (current_storage != CB_STORAGE_WORKING) {
			cb_error (_("%s not allowed here"), "IDENTIFIED BY");
		} else if (!qualifier) {
			cb_error (_("%s requires a data name"), "IDENTIFIED BY");
		} else if (current_field->redefines) {
			cb_error (_("%s and %s combination not allowed"), "IDENTIFIED BY", "REDEFINES");
		}
	}
	current_field->external_form_identifier = (yyvsp[0]);
  }
#line 17070 "parser.c" /* yacc.c:1646  */
    break;

  case 801:
#line 7689 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LOCAL_STORAGE_SECTION;
	current_storage = CB_STORAGE_LOCAL;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "LOCAL-STORAGE");
	}
  }
#line 17083 "parser.c" /* yacc.c:1646  */
    break;

  case 802:
#line 7698 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_program->local_storage = CB_FIELD ((yyvsp[0]));
	}
  }
#line 17093 "parser.c" /* yacc.c:1646  */
    break;

  case 804:
#line 7710 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LINKAGE_SECTION;
	current_storage = CB_STORAGE_LINKAGE;
  }
#line 17103 "parser.c" /* yacc.c:1646  */
    break;

  case 805:
#line 7716 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_program->linkage_storage = CB_FIELD ((yyvsp[0]));
	}
  }
#line 17113 "parser.c" /* yacc.c:1646  */
    break;

  case 807:
#line 7727 "parser.y" /* yacc.c:1646  */
    {
	header_check |= COBC_HD_REPORT_SECTION;
	current_storage = CB_STORAGE_REPORT;
	description_field = NULL;
	current_program->flag_report = 1;
	cb_clear_real_field ();
  }
#line 17125 "parser.c" /* yacc.c:1646  */
    break;

  case 811:
#line 7745 "parser.y" /* yacc.c:1646  */
    {
	if (CB_INVALID_TREE ((yyvsp[0]))) {
		YYERROR;
	} else {
		current_field = NULL;
		control_field = NULL;
		description_field = NULL;
		current_report = CB_REPORT_PTR ((yyvsp[0]));
	}
	check_duplicate = 0;
  }
#line 17141 "parser.c" /* yacc.c:1646  */
    break;

  case 812:
#line 7758 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *p;

	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	current_program->report_storage = description_field;
	current_program->flag_report = 1;
	if (current_report->records == NULL) {
		current_report->records = description_field;
	}
	finalize_report (current_report, description_field);
	(yyval) = CB_TREE (description_field);
  }
#line 17160 "parser.c" /* yacc.c:1646  */
    break;

  case 815:
#line 7777 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 17168 "parser.c" /* yacc.c:1646  */
    break;

  case 816:
#line 7784 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_1, &check_duplicate);
	current_report->global = 1;
	cb_error (_("GLOBAL is not allowed with RD"));
  }
#line 17178 "parser.c" /* yacc.c:1646  */
    break;

  case 817:
#line 7790 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CODE", SYN_CLAUSE_2, &check_duplicate);
	current_report->code_clause = (yyvsp[0]);
  }
#line 17187 "parser.c" /* yacc.c:1646  */
    break;

  case 820:
#line 7802 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONTROL", SYN_CLAUSE_3, &check_duplicate);
  }
#line 17195 "parser.c" /* yacc.c:1646  */
    break;

  case 824:
#line 7815 "parser.y" /* yacc.c:1646  */
    {
	current_report->control_final = 1;
  }
#line 17203 "parser.c" /* yacc.c:1646  */
    break;

  case 827:
#line 7827 "parser.y" /* yacc.c:1646  */
    {
	/* Add field to current control list */
	CB_ADD_TO_CHAIN ((yyvsp[0]), current_report->controls);
  }
#line 17212 "parser.c" /* yacc.c:1646  */
    break;

  case 828:
#line 7838 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PAGE", SYN_CLAUSE_4, &check_duplicate);
	if (!current_report->heading) {
		current_report->heading = 1;
	}
	if (!current_report->first_detail) {
		current_report->first_detail = current_report->heading;
	}
	if (!current_report->last_control) {
		if (current_report->last_detail) {
			current_report->last_control = current_report->last_detail;
		} else if (current_report->footing) {
			current_report->last_control = current_report->footing;
		} else {
			current_report->last_control = current_report->lines;
		}
		if (current_report->t_last_detail) {
			current_report->t_last_control = current_report->t_last_detail;
		} else if (current_report->t_footing) {
			current_report->t_last_control = current_report->t_footing;
		} else if(current_report->t_lines) {
			current_report->t_last_control = current_report->t_lines;
		}
	}
	if (!current_report->last_detail && !current_report->footing) {
		current_report->last_detail = current_report->lines;
		current_report->footing = current_report->lines;
	} else if (!current_report->last_detail) {
		current_report->last_detail = current_report->footing;
	} else if (!current_report->footing) {
		current_report->footing = current_report->last_detail;
	}
	/* PAGE LIMIT values checked in finalize_report in typeck.c */
  }
#line 17251 "parser.c" /* yacc.c:1646  */
    break;

  case 829:
#line 7876 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[-1]))) {
		current_report->lines = cb_get_int ((yyvsp[-1]));
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = (yyvsp[-1]);
	}
  }
#line 17266 "parser.c" /* yacc.c:1646  */
    break;

  case 831:
#line 7888 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[-2]))) {
		current_report->lines = cb_get_int ((yyvsp[-2]));
		if (current_report->lines > 999) {
			cb_error ("PAGE LIMIT lines > 999");
		}
	} else {
		current_report->t_lines = (yyvsp[-2]);
	}
  }
#line 17281 "parser.c" /* yacc.c:1646  */
    break;

  case 832:
#line 7902 "parser.y" /* yacc.c:1646  */
    {
	/* may be repeated later by page detail */
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P ((yyvsp[-1]))) {
		current_report->columns = cb_get_int ((yyvsp[-1]));
	} else {
		current_report->t_columns = (yyvsp[-1]);
	}
  }
#line 17295 "parser.c" /* yacc.c:1646  */
    break;

  case 842:
#line 7930 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINE LIMIT", SYN_CLAUSE_5, &check_duplicate);
	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->columns = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_columns = (yyvsp[0]);
	}
  }
#line 17308 "parser.c" /* yacc.c:1646  */
    break;

  case 843:
#line 7942 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("HEADING", SYN_CLAUSE_6, &check_duplicate);
	error_if_no_page_lines_limit ("HEADING");

	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->heading = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_heading = (yyvsp[0]);
	}
  }
#line 17323 "parser.c" /* yacc.c:1646  */
    break;

  case 844:
#line 7956 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FIRST DETAIL", SYN_CLAUSE_7, &check_duplicate);
	error_if_no_page_lines_limit ("FIRST DETAIL");

	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->first_detail = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_first_detail = (yyvsp[0]);
	}
  }
#line 17338 "parser.c" /* yacc.c:1646  */
    break;

  case 845:
#line 7970 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LAST CONTROL HEADING", SYN_CLAUSE_8, &check_duplicate);
	error_if_no_page_lines_limit ("LAST CONTROL HEADING");

	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->last_control = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_last_control = (yyvsp[0]);
	}
  }
#line 17353 "parser.c" /* yacc.c:1646  */
    break;

  case 846:
#line 7984 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LAST DETAIL", SYN_CLAUSE_9, &check_duplicate);
	error_if_no_page_lines_limit ("LAST DETAIL");

	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->last_detail = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_last_detail = (yyvsp[0]);
	}
  }
#line 17368 "parser.c" /* yacc.c:1646  */
    break;

  case 847:
#line 7998 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOOTING", SYN_CLAUSE_10, &check_duplicate);
	error_if_no_page_lines_limit ("FOOTING");

	if (CB_LITERAL_P ((yyvsp[0]))) {
		current_report->footing = cb_get_int ((yyvsp[0]));
	} else {
		current_report->t_footing = (yyvsp[0]);
	}
  }
#line 17383 "parser.c" /* yacc.c:1646  */
    break;

  case 850:
#line 8016 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 17396 "parser.c" /* yacc.c:1646  */
    break;

  case 852:
#line 8026 "parser.y" /* yacc.c:1646  */
    {
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-2]));
	cb_unput_dot ();
	yyerrok;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 17410 "parser.c" /* yacc.c:1646  */
    break;

  case 871:
#line 8062 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("TYPE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 17418 "parser.c" /* yacc.c:1646  */
    break;

  case 872:
#line 8069 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_HEADING;
  }
#line 17426 "parser.c" /* yacc.c:1646  */
    break;

  case 873:
#line 8073 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_HEADING;
  }
#line 17434 "parser.c" /* yacc.c:1646  */
    break;

  case 876:
#line 8079 "parser.y" /* yacc.c:1646  */
    {
	if (current_report != NULL) {
		current_report->has_detail = 1;
	}
	current_field->report_flag |= COB_REPORT_DETAIL;
  }
#line 17445 "parser.c" /* yacc.c:1646  */
    break;

  case 877:
#line 8086 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_PAGE_FOOTING;
  }
#line 17453 "parser.c" /* yacc.c:1646  */
    break;

  case 878:
#line 8090 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_FOOTING;
  }
#line 17461 "parser.c" /* yacc.c:1646  */
    break;

  case 879:
#line 8097 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
  }
#line 17469 "parser.c" /* yacc.c:1646  */
    break;

  case 880:
#line 8101 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING;
	current_field->report_control = (yyvsp[-1]);
	if ((yyvsp[0])) {
		current_field->report_flag |= COB_REPORT_PAGE;
	}
  }
#line 17481 "parser.c" /* yacc.c:1646  */
    break;

  case 881:
#line 8109 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_HEADING_FINAL;
  }
#line 17489 "parser.c" /* yacc.c:1646  */
    break;

  case 882:
#line 8118 "parser.y" /* yacc.c:1646  */
    {(yyval) = NULL;}
#line 17495 "parser.c" /* yacc.c:1646  */
    break;

  case 883:
#line 8119 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int0;}
#line 17501 "parser.c" /* yacc.c:1646  */
    break;

  case 884:
#line 8124 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
  }
#line 17509 "parser.c" /* yacc.c:1646  */
    break;

  case 885:
#line 8128 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_control = (yyvsp[-1]);
  }
#line 17518 "parser.c" /* yacc.c:1646  */
    break;

  case 886:
#line 8133 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING_FINAL;
  }
#line 17526 "parser.c" /* yacc.c:1646  */
    break;

  case 887:
#line 8137 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_CONTROL_FOOTING;
	current_field->report_flag |= COB_REPORT_ALL;
  }
#line 17535 "parser.c" /* yacc.c:1646  */
    break;

  case 888:
#line 8145 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NEXT GROUP", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 17543 "parser.c" /* yacc.c:1646  */
    break;

  case 889:
#line 8152 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P((yyvsp[0])) && CB_LITERAL ((yyvsp[0]))->sign > 0) {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	} else {
		current_field->report_flag |= COB_REPORT_NEXT_GROUP_LINE;
	}
	current_field->next_group_line = cb_get_int ((yyvsp[0]));
  }
#line 17556 "parser.c" /* yacc.c:1646  */
    break;

  case 890:
#line 8161 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PLUS;
	current_field->next_group_line = cb_get_int((yyvsp[0]));
  }
#line 17565 "parser.c" /* yacc.c:1646  */
    break;

  case 891:
#line 8166 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_NEXT_GROUP_PAGE;
  }
#line 17573 "parser.c" /* yacc.c:1646  */
    break;

  case 895:
#line 8179 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SUM", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->report_sum_list = (yyvsp[-1]);
	build_sum_counter (current_report, current_field);
  }
#line 17583 "parser.c" /* yacc.c:1646  */
    break;

  case 898:
#line 8189 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_sum_upon = (yyvsp[0]);
  }
#line 17591 "parser.c" /* yacc.c:1646  */
    break;

  case 899:
#line 8196 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_reset = (yyvsp[0]);
  }
#line 17599 "parser.c" /* yacc.c:1646  */
    break;

  case 900:
#line 8200 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_RESET_FINAL;
  }
#line 17607 "parser.c" /* yacc.c:1646  */
    break;

  case 901:
#line 8207 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_when = (yyvsp[0]);
  }
#line 17616 "parser.c" /* yacc.c:1646  */
    break;

  case 902:
#line 8212 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
  }
#line 17626 "parser.c" /* yacc.c:1646  */
    break;

  case 903:
#line 8218 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag &= ~COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17637 "parser.c" /* yacc.c:1646  */
    break;

  case 904:
#line 8225 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
  }
#line 17647 "parser.c" /* yacc.c:1646  */
    break;

  case 905:
#line 8231 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_BEFORE;
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17658 "parser.c" /* yacc.c:1646  */
    break;

  case 906:
#line 8241 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
  }
#line 17666 "parser.c" /* yacc.c:1646  */
    break;

  case 907:
#line 8245 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_PRESENT;
	current_field->report_flag |= COB_REPORT_NEGATE;
  }
#line 17675 "parser.c" /* yacc.c:1646  */
    break;

  case 910:
#line 8258 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_PAGE;
  }
#line 17683 "parser.c" /* yacc.c:1646  */
    break;

  case 911:
#line 8262 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_control = (yyvsp[0]);
  }
#line 17691 "parser.c" /* yacc.c:1646  */
    break;

  case 913:
#line 8270 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("RW VARYING clause");
  }
#line 17699 "parser.c" /* yacc.c:1646  */
    break;

  case 914:
#line 8277 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINE", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_LINE;
  }
#line 17708 "parser.c" /* yacc.c:1646  */
    break;

  case 919:
#line 8295 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_LINE_NEXT_PAGE;
  }
#line 17716 "parser.c" /* yacc.c:1646  */
    break;

  case 920:
#line 8299 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_line = cb_get_int ((yyvsp[0]));
	if ((CB_LITERAL_P((yyvsp[0])) && CB_LITERAL ((yyvsp[0]))->sign > 0)) {
		current_field->report_flag |= COB_REPORT_LINE_PLUS;
	}
	if ((yyvsp[-1])) {
		current_field->report_flag |= COB_REPORT_LINE_PLUS;
		if (current_field->report_line == 0) {
			CB_PENDING ("LINE PLUS 0");
		}
	}
  }
#line 17733 "parser.c" /* yacc.c:1646  */
    break;

  case 921:
#line 8316 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_18, &check_pic_duplicate);
	if((current_field->report_flag & (COB_REPORT_COLUMN_LEFT|COB_REPORT_COLUMN_RIGHT|COB_REPORT_COLUMN_CENTER))
	&& (current_field->report_flag & COB_REPORT_COLUMN_PLUS)) {
		if (cb_relaxed_syntax_checks) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is not recommended with LEFT, RIGHT or CENTER"));
		} else {
			cb_error (_("PLUS is not allowed with LEFT, RIGHT or CENTER"));
		}
	}
  }
#line 17749 "parser.c" /* yacc.c:1646  */
    break;

  case 925:
#line 8340 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_LEFT;
  }
#line 17757 "parser.c" /* yacc.c:1646  */
    break;

  case 926:
#line 8344 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_RIGHT;
  }
#line 17765 "parser.c" /* yacc.c:1646  */
    break;

  case 927:
#line 8348 "parser.y" /* yacc.c:1646  */
    {
	current_field->report_flag |= COB_REPORT_COLUMN_CENTER;
  }
#line 17773 "parser.c" /* yacc.c:1646  */
    break;

  case 928:
#line 8355 "parser.y" /* yacc.c:1646  */
    {
	int colnum = cb_get_int ((yyvsp[0]));
	if (colnum != 0) {
		if (current_field->parent
		 && current_field->parent->children == current_field) {
			cb_warning (COBC_WARN_FILLER, _("PLUS is ignored on first field of line"));
			if (current_field->step_count == 0)
				current_field->step_count = colnum;
		} else {
			current_field->report_flag |= COB_REPORT_COLUMN_PLUS;
		}
	} else {
		colnum = 0;
	}
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17797 "parser.c" /* yacc.c:1646  */
    break;

  case 932:
#line 8384 "parser.y" /* yacc.c:1646  */
    {
	int colnum;
	colnum = cb_get_int ((yyvsp[0]));
	if (CB_LITERAL_P((yyvsp[0])) && CB_LITERAL ((yyvsp[0]))->sign > 0) {
		if(current_field->parent
		&& current_field->parent->children == current_field) {
			cb_warning (COBC_WARN_FILLER,_("PLUS is ignored on first field of line"));
		} else {
			current_field->report_flag |= COB_REPORT_COLUMN_PLUS;
		}
	}
	if (colnum < 0) {
		/* already handled by integer check */
	} else if (colnum == 0) {
		cb_error (_("invalid COLUMN integer; must be > 0"));
	} else if (colnum <= current_field->report_column) {
		cb_warning (COBC_WARN_FILLER, _("COLUMN numbers should increase"));
	}
	current_field->report_column_list =
			cb_list_append (current_field->report_column_list, CB_LIST_INIT ((yyvsp[0])));
	if (current_field->report_column == 0) {
		current_field->report_column = colnum;
	}
	current_field->report_num_col++;
  }
#line 17827 "parser.c" /* yacc.c:1646  */
    break;

  case 933:
#line 8413 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SOURCE", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->report_source = (yyvsp[-1]);
  }
#line 17836 "parser.c" /* yacc.c:1646  */
    break;

  case 934:
#line 8421 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GROUP", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->report_flag |= COB_REPORT_GROUP_INDICATE;
  }
#line 17845 "parser.c" /* yacc.c:1646  */
    break;

  case 936:
#line 8431 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = CB_CS_SCREEN;
	current_storage = CB_STORAGE_SCREEN;
	current_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 17857 "parser.c" /* yacc.c:1646  */
    break;

  case 937:
#line 8439 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *p;

	if (description_field) {
		for (p = description_field; p; p = p->sister) {
			cb_validate_field (p);
		}
		current_program->screen_storage = description_field;
		current_program->flag_screen = 1;
	}
	cobc_cs_check = 0;
  }
#line 17874 "parser.c" /* yacc.c:1646  */
    break;

  case 943:
#line 8466 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17889 "parser.c" /* yacc.c:1646  */
    break;

  case 944:
#line 8477 "parser.y" /* yacc.c:1646  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
  }
#line 17931 "parser.c" /* yacc.c:1646  */
    break;

  case 945:
#line 8516 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}

	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 17947 "parser.c" /* yacc.c:1646  */
    break;

  case 946:
#line 8528 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL CONTROL");
	current_field->usage = CB_USAGE_CONTROL;
  }
#line 17956 "parser.c" /* yacc.c:1646  */
    break;

  case 947:
#line 8533 "parser.y" /* yacc.c:1646  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
	cobc_cs_check = CB_CS_SCREEN;
  }
#line 17999 "parser.c" /* yacc.c:1646  */
    break;

  case 948:
#line 8573 "parser.y" /* yacc.c:1646  */
    {
	/*
	  Tree associated with level number has already been freed; we don't
	  need to do anything here.
	*/
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if	1	/* RXWRXW Screen field */
	if (current_field) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	}
#endif
	current_field = cb_get_real_field ();
  }
#line 18021 "parser.c" /* yacc.c:1646  */
    break;

  case 951:
#line 8599 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				       "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 18030 "parser.c" /* yacc.c:1646  */
    break;

  case 952:
#line 8604 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				       "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 18039 "parser.c" /* yacc.c:1646  */
    break;

  case 953:
#line 8609 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("BELL", COB_SCREEN_BELL);
  }
#line 18047 "parser.c" /* yacc.c:1646  */
    break;

  case 954:
#line 8613 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("BLINK", COB_SCREEN_BLINK);
  }
#line 18055 "parser.c" /* yacc.c:1646  */
    break;

  case 955:
#line 8617 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				       "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 18064 "parser.c" /* yacc.c:1646  */
    break;

  case 956:
#line 8622 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				       "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 18073 "parser.c" /* yacc.c:1646  */
    break;

  case 957:
#line 8627 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				       "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 18082 "parser.c" /* yacc.c:1646  */
    break;

  case 958:
#line 8632 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 18091 "parser.c" /* yacc.c:1646  */
    break;

  case 959:
#line 8637 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD intensity");
#if 0 /* in general we could simply remove high/low, but for syntax checks
	we still need a flag */
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
#endif
  }
#line 18104 "parser.c" /* yacc.c:1646  */
    break;

  case 960:
#line 8646 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18112 "parser.c" /* yacc.c:1646  */
    break;

  case 961:
#line 8650 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18120 "parser.c" /* yacc.c:1646  */
    break;

  case 962:
#line 8654 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 18128 "parser.c" /* yacc.c:1646  */
    break;

  case 963:
#line 8658 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("REVERSE-VIDEO", COB_SCREEN_REVERSE);
  }
#line 18136 "parser.c" /* yacc.c:1646  */
    break;

  case 964:
#line 8662 "parser.y" /* yacc.c:1646  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int ((yyvsp[0]));
  }
#line 18146 "parser.c" /* yacc.c:1646  */
    break;

  case 965:
#line 8668 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("screen positions from data-item"));
  }
#line 18154 "parser.c" /* yacc.c:1646  */
    break;

  case 966:
#line 8672 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("screen positions from data-item"));
	CB_PENDING ("SIZE clause");
  }
#line 18163 "parser.c" /* yacc.c:1646  */
    break;

  case 967:
#line 8677 "parser.y" /* yacc.c:1646  */
    {
	/* set_screen_attr ("SIZE", COB_SCREEN_SIZE); */
	CB_PENDING ("SIZE clause");
	current_field->size = cb_get_int ((yyvsp[0]));
  }
#line 18173 "parser.c" /* yacc.c:1646  */
    break;

  case 968:
#line 8683 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("UNDERLINE", COB_SCREEN_UNDERLINE);
  }
#line 18181 "parser.c" /* yacc.c:1646  */
    break;

  case 969:
#line 8687 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("OVERLINE", COB_SCREEN_OVERLINE);
	CB_PENDING ("OVERLINE");
  }
#line 18190 "parser.c" /* yacc.c:1646  */
    break;

  case 970:
#line 8692 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("GRID", COB_SCREEN_GRID);
	CB_PENDING ("GRID");
  }
#line 18199 "parser.c" /* yacc.c:1646  */
    break;

  case 971:
#line 8697 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("LEFTLINE", COB_SCREEN_LEFTLINE);
	CB_PENDING ("LEFTLINE");
  }
#line 18208 "parser.c" /* yacc.c:1646  */
    break;

  case 972:
#line 8702 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				       "TAB", COB_SCREEN_TAB);
  }
#line 18217 "parser.c" /* yacc.c:1646  */
    break;

  case 973:
#line 8707 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("TAB", COB_SCREEN_TAB,
				       "AUTO", COB_SCREEN_AUTO);
  }
#line 18226 "parser.c" /* yacc.c:1646  */
    break;

  case 974:
#line 8712 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				       "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 18235 "parser.c" /* yacc.c:1646  */
    break;

  case 975:
#line 8717 "parser.y" /* yacc.c:1646  */
    {
	if (cb_no_echo_means_secure) {
		set_screen_attr ("SECURE", COB_SCREEN_SECURE);
	} else {
		set_screen_attr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					       "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 18248 "parser.c" /* yacc.c:1646  */
    break;

  case 976:
#line 8726 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("REQUIRED", COB_SCREEN_REQUIRED);
  }
#line 18256 "parser.c" /* yacc.c:1646  */
    break;

  case 977:
#line 8730 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("FULL", COB_SCREEN_FULL);
  }
#line 18264 "parser.c" /* yacc.c:1646  */
    break;

  case 978:
#line 8734 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
	current_field->screen_prompt = (yyvsp[0]);
  }
#line 18273 "parser.c" /* yacc.c:1646  */
    break;

  case 979:
#line 8739 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
  }
#line 18281 "parser.c" /* yacc.c:1646  */
    break;

  case 980:
#line 8743 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("INITIAL", COB_SCREEN_INITIAL);
  }
#line 18289 "parser.c" /* yacc.c:1646  */
    break;

  case 981:
#line 8747 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 18297 "parser.c" /* yacc.c:1646  */
    break;

  case 982:
#line 8751 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("LINES clause");	/* note: should only occur with controls */
  }
#line 18305 "parser.c" /* yacc.c:1646  */
    break;

  case 983:
#line 8755 "parser.y" /* yacc.c:1646  */
    {
	/*check_repeated ("CLINE", SYN_CLAUSE_5000, &check_pic_duplicate);*/
  }
#line 18313 "parser.c" /* yacc.c:1646  */
    break;

  case 984:
#line 8759 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 18321 "parser.c" /* yacc.c:1646  */
    break;

  case 985:
#line 8763 "parser.y" /* yacc.c:1646  */
    {
	/*check_repeated ("CCOL", SYN_CLAUSE_5001, &check_pic_duplicate);*/
  }
#line 18329 "parser.c" /* yacc.c:1646  */
    break;

  case 986:
#line 8767 "parser.y" /* yacc.c:1646  */
    {
#if 0 /* TODO: implement, and add reverse to BACKGROUND/FOREGROUND-COLOR */
	check_repeated ("COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "BACKGROUND-COLOR", COB_SCREEN_BACKGROUND_COLOR);
	set_screen_attr_with_conflict ("COLOR", COB_SCREEN_COLOR,
				       "FOREGROUND-COLOR", FOREGROUND_COLOR);
#endif
	CB_PENDING ("COLOR clause");
  }
#line 18344 "parser.c" /* yacc.c:1646  */
    break;

  case 987:
#line 8778 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_18, &check_pic_duplicate);
	current_field->screen_foreg = (yyvsp[0]);
  }
#line 18353 "parser.c" /* yacc.c:1646  */
    break;

  case 988:
#line 8783 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->screen_backg = (yyvsp[0]);
  }
#line 18362 "parser.c" /* yacc.c:1646  */
    break;

  case 997:
#line 8796 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = check_not_88_level ((yyvsp[0]));

	check_repeated ("USING", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->screen_from = (yyval);
	current_field->screen_to = (yyval);
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18375 "parser.c" /* yacc.c:1646  */
    break;

  case 998:
#line 8805 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FROM", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->screen_from = (yyvsp[0]);
  }
#line 18384 "parser.c" /* yacc.c:1646  */
    break;

  case 999:
#line 8810 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = check_not_88_level ((yyvsp[0]));

	check_repeated ("TO", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->screen_to = (yyval);
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 18396 "parser.c" /* yacc.c:1646  */
    break;

  case 1001:
#line 8822 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check |= CB_CS_GRAPHICAL_CONTROL;
  }
#line 18404 "parser.c" /* yacc.c:1646  */
    break;

  case 1303:
#line 9416 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18410 "parser.c" /* yacc.c:1646  */
    break;

  case 1304:
#line 9417 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18416 "parser.c" /* yacc.c:1646  */
    break;

  case 1305:
#line 9421 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 18422 "parser.c" /* yacc.c:1646  */
    break;

  case 1308:
#line 9429 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 18428 "parser.c" /* yacc.c:1646  */
    break;

  case 1312:
#line 9441 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 18434 "parser.c" /* yacc.c:1646  */
    break;

  case 1313:
#line 9442 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 18440 "parser.c" /* yacc.c:1646  */
    break;

  case 1314:
#line 9446 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18446 "parser.c" /* yacc.c:1646  */
    break;

  case 1315:
#line 9447 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 18452 "parser.c" /* yacc.c:1646  */
    break;

  case 1316:
#line 9452 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_field->screen_line = (yyvsp[0]);
	}
  }
#line 18462 "parser.c" /* yacc.c:1646  */
    break;

  case 1318:
#line 9462 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_PLUS;
  }
#line 18470 "parser.c" /* yacc.c:1646  */
    break;

  case 1319:
#line 9466 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_MINUS;
  }
#line 18478 "parser.c" /* yacc.c:1646  */
    break;

  case 1320:
#line 9473 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_field->screen_column = (yyvsp[0]);
	}
  }
#line 18488 "parser.c" /* yacc.c:1646  */
    break;

  case 1321:
#line 9482 "parser.y" /* yacc.c:1646  */
    {
	/* Nothing */
  }
#line 18496 "parser.c" /* yacc.c:1646  */
    break;

  case 1322:
#line 9486 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_PLUS;
  }
#line 18504 "parser.c" /* yacc.c:1646  */
    break;

  case 1323:
#line 9490 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_MINUS;
  }
#line 18512 "parser.c" /* yacc.c:1646  */
    break;

  case 1324:
#line 9497 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("OCCURS screen items"));
	check_repeated ("OCCURS", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->occurs_max = cb_get_int ((yyvsp[-1]));
	current_field->occurs_min = current_field->occurs_max;
	current_field->indexes++;
	current_field->flag_occurs = 1;
  }
#line 18525 "parser.c" /* yacc.c:1646  */
    break;

  case 1325:
#line 9509 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("GLOBAL screen items"));
  }
#line 18533 "parser.c" /* yacc.c:1646  */
    break;

  case 1326:
#line 9518 "parser.y" /* yacc.c:1646  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 18547 "parser.c" /* yacc.c:1646  */
    break;

  case 1328:
#line 9532 "parser.y" /* yacc.c:1646  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	cobc_in_procedure = 1U;
	cb_set_system_names ();
	backup_current_pos ();
  }
#line 18561 "parser.c" /* yacc.c:1646  */
    break;

  case 1329:
#line 9542 "parser.y" /* yacc.c:1646  */
    {
	cb_tree call_conv = (yyvsp[-4]);
	if ((yyvsp[-3])) {
		call_conv = (yyvsp[-3]);
		if ((yyvsp[-4])) {
			/* note: $4 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x ((yyvsp[-3]), _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if (call_conv) {
		if (current_program->entry_convention) {
			cb_warning (COBC_WARN_FILLER, _("overriding convention specified in ENTRY-CONVENTION"));
		}
		current_program->entry_convention = call_conv;
	} else if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	header_check |= COBC_HD_PROCEDURE_DIVISION;
  }
#line 18586 "parser.c" /* yacc.c:1646  */
    break;

  case 1330:
#line 9563 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_main
	 && !current_program->flag_chained && (yyvsp[-4])) {
		cb_error (_("executable program requested but PROCEDURE/ENTRY has USING clause"));
	}
	/* Main entry point */
	emit_entry (current_program->program_id, 0, (yyvsp[-4]), NULL);
	current_program->num_proc_params = cb_list_length ((yyvsp[-4]));
	if (current_program->source_name) {
		emit_entry (current_program->source_name, 1, (yyvsp[-4]), NULL);
	}
  }
#line 18603 "parser.c" /* yacc.c:1646  */
    break;

  case 1331:
#line 9576 "parser.y" /* yacc.c:1646  */
    {
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
  }
#line 18622 "parser.c" /* yacc.c:1646  */
    break;

  case 1332:
#line 9591 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	/* No PROCEDURE DIVISION header here */
	/* Only a statement is allowed as first element */
	/* Thereafter, sections/paragraphs may be used */
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	cobc_in_procedure = 1U;
	label = cb_build_reference ("MAIN SECTION");
	current_section = CB_LABEL (cb_build_label (label, NULL));
	current_section->flag_section = 1;
	current_section->flag_dummy_section = 1;
	current_section->flag_skip_label = !!skip_statements;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->xref.skip = 1;
	emit_statement (CB_TREE (current_section));
	label = cb_build_reference ("MAIN PARAGRAPH");
	current_paragraph = CB_LABEL (cb_build_label (label, NULL));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_dummy_paragraph = 1;
	current_paragraph->xref.skip = 1;
	emit_statement (CB_TREE (current_paragraph));
	cb_set_system_names ();
  }
#line 18656 "parser.c" /* yacc.c:1646  */
    break;

  case 1334:
#line 9625 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 18664 "parser.c" /* yacc.c:1646  */
    break;

  case 1335:
#line 9629 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 18673 "parser.c" /* yacc.c:1646  */
    break;

  case 1336:
#line 9634 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 18685 "parser.c" /* yacc.c:1646  */
    break;

  case 1337:
#line 9642 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("CHAINING invalid in user FUNCTION"));
	} else {
		current_program->flag_chained = 1;
	}
  }
#line 18698 "parser.c" /* yacc.c:1646  */
    break;

  case 1338:
#line 9651 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of arguments exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 18710 "parser.c" /* yacc.c:1646  */
    break;

  case 1339:
#line 9661 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18716 "parser.c" /* yacc.c:1646  */
    break;

  case 1340:
#line 9663 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 18722 "parser.c" /* yacc.c:1646  */
    break;

  case 1341:
#line 9668 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;
	struct cb_field	*f;

	x = cb_build_identifier ((yyvsp[-1]), 0);
	if ((yyvsp[-2]) == cb_int1 && CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
		f = CB_FIELD (cb_ref (x));
		f->flag_is_pdiv_opt = 1;
	}

	(yyval) = CB_BUILD_PAIR (cb_int (call_mode), x);
	CB_SIZES ((yyval)) = size_mode;
  }
#line 18740 "parser.c" /* yacc.c:1646  */
    break;

  case 1343:
#line 9686 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 18748 "parser.c" /* yacc.c:1646  */
    break;

  case 1344:
#line 9690 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error (_("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 18760 "parser.c" /* yacc.c:1646  */
    break;

  case 1346:
#line 9702 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO;
	}
  }
#line 18772 "parser.c" /* yacc.c:1646  */
    break;

  case 1347:
#line 9710 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_4;
	}
  }
#line 18784 "parser.c" /* yacc.c:1646  */
    break;

  case 1348:
#line 9718 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO | CB_SIZE_UNSIGNED;
	}
  }
#line 18796 "parser.c" /* yacc.c:1646  */
    break;

  case 1349:
#line 9726 "parser.y" /* yacc.c:1646  */
    {
	if (size_mode) {
		size_mode |= CB_SIZE_UNSIGNED;
	}
  }
#line 18806 "parser.c" /* yacc.c:1646  */
    break;

  case 1351:
#line 9736 "parser.y" /* yacc.c:1646  */
    {
	unsigned char *s = CB_LITERAL ((yyvsp[0]))->data;
	size_mode = 0;

	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else if (CB_LITERAL ((yyvsp[0]))->size != 1) {
		cb_error_x ((yyvsp[0]), _("invalid value for SIZE"));
	} else {
		size_mode = 0;
		switch (*s) {
		case '1':
			size_mode = CB_SIZE_1;
			break;
		case '2':
			size_mode = CB_SIZE_2;
			break;
		case '4':
			size_mode = CB_SIZE_4;
			break;
		case '8':
			size_mode = CB_SIZE_8;
			break;
		default:
			cb_error_x ((yyvsp[0]), _("invalid value for SIZE"));
			break;
		}
	}
  }
#line 18840 "parser.c" /* yacc.c:1646  */
    break;

  case 1353:
#line 9774 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING_X ((yyvsp[-1]), _("MEMORY SIZE phrase in CALL statement"));
  }
#line 18848 "parser.c" /* yacc.c:1646  */
    break;

  case 1354:
#line 9781 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 18856 "parser.c" /* yacc.c:1646  */
    break;

  case 1355:
#line 9785 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error (_("OPTIONAL only allowed for BY REFERENCE items"));
		(yyval) = cb_int0;
	} else {
		(yyval) = cb_int1;
	}
  }
#line 18869 "parser.c" /* yacc.c:1646  */
    break;

  case 1356:
#line 9797 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause is required for a FUNCTION"));
	}
  }
#line 18879 "parser.c" /* yacc.c:1646  */
    break;

  case 1357:
#line 9803 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_main) {
		cb_error (_("RETURNING clause cannot be OMITTED for main program"));
	}
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("RETURNING clause cannot be OMITTED for a FUNCTION"));
	}
	current_program->flag_void = 1;
  }
#line 18893 "parser.c" /* yacc.c:1646  */
    break;

  case 1358:
#line 9813 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		/* standard rule: returning item is allocated in the
		   activating runtime element */
		if (f->storage != CB_STORAGE_LINKAGE) {
			cb_error (_("RETURNING item is not defined in LINKAGE SECTION"));
		} else if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01"));
		} else if (f->flag_occurs) {
			cb_error (_("RETURNING item should not have OCCURS"));
		} else {
			if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
				if (f->flag_any_length) {
					cb_error (_("function RETURNING item may not be ANY LENGTH"));
				}

				f->flag_is_returning = 1;
			}
			current_program->returning = (yyvsp[0]);
		}
	}
  }
#line 18923 "parser.c" /* yacc.c:1646  */
    break;

  case 1360:
#line 9842 "parser.y" /* yacc.c:1646  */
    {
	in_declaratives = 1;
	emit_statement (cb_build_comment ("DECLARATIVES"));
  }
#line 18932 "parser.c" /* yacc.c:1646  */
    break;

  case 1361:
#line 9848 "parser.y" /* yacc.c:1646  */
    {
	if (needs_field_debug) {
		start_debug = 1;
	}
	in_declaratives = 0;
	in_debugging = 0;
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		current_paragraph = NULL;
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		current_section->flag_fatal_check = 1;
		emit_statement (cb_build_perform_exit (current_section));
		current_section = NULL;
	}
	skip_statements = 0;
	emit_statement (cb_build_comment ("END DECLARATIVES"));
	check_unreached = 0;
  }
#line 18962 "parser.c" /* yacc.c:1646  */
    break;

  case 1366:
#line 9886 "parser.y" /* yacc.c:1646  */
    {
	if (next_label_list) {
		cb_tree	plabel;
		char	name[32];

		snprintf (name, sizeof(name), "L$%d", next_label_id);
		plabel = cb_build_label (cb_build_reference (name), NULL);
		CB_LABEL (plabel)->flag_next_sentence = 1;
		emit_statement (plabel);
		current_program->label_list =
			cb_list_append (current_program->label_list, next_label_list);
		next_label_list = NULL;
		next_label_id++;
	}
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 18984 "parser.c" /* yacc.c:1646  */
    break;

  case 1368:
#line 9905 "parser.y" /* yacc.c:1646  */
    {
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 18993 "parser.c" /* yacc.c:1646  */
    break;

  case 1369:
#line 9916 "parser.y" /* yacc.c:1646  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[-1]), 0) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph/section */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
	if (current_program->flag_debugging && !in_debugging) {
		if (current_paragraph || current_section) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new section */
	current_section = CB_LABEL (cb_build_label ((yyvsp[-1]), NULL));
	current_section->flag_section = 1;
	/* Careful here, one negation */
	current_section->flag_real_label = !in_debugging;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->flag_skip_label = !!skip_statements;
	current_paragraph = NULL;
  }
#line 19036 "parser.c" /* yacc.c:1646  */
    break;

  case 1370:
#line 9956 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (CB_TREE (current_section));
  }
#line 19044 "parser.c" /* yacc.c:1646  */
    break;

  case 1373:
#line 9967 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[-1]), 1) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		if (current_program->flag_debugging && !in_debugging) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new paragraph */
	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->flag_skip_label = !!skip_statements;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	current_paragraph = CB_LABEL (cb_build_label ((yyvsp[-1]), current_section));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_real_label = !in_debugging;
	current_paragraph->segment = current_section->segment;
	emit_statement (CB_TREE (current_paragraph));
  }
#line 19090 "parser.c" /* yacc.c:1646  */
    break;

  case 1374:
#line 10012 "parser.y" /* yacc.c:1646  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[0]), 0) != cb_error_node) {
		if (is_reserved_word (CB_NAME ((yyvsp[0])))) {
			cb_error_x ((yyvsp[0]), _("'%s' is not a statement"), CB_NAME ((yyvsp[0])));
		} else if (is_default_reserved_word (CB_NAME ((yyvsp[0])))) {
			cb_error_x ((yyvsp[0]), _("unknown statement '%s'; it may exist in another dialect"),
				    CB_NAME ((yyvsp[0])));
		} else {
			cb_error_x ((yyvsp[0]), _("unknown statement '%s'"), CB_NAME ((yyvsp[0])));
		}
	}
	YYERROR;
  }
#line 19110 "parser.c" /* yacc.c:1646  */
    break;

  case 1375:
#line 10031 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19118 "parser.c" /* yacc.c:1646  */
    break;

  case 1376:
#line 10035 "parser.y" /* yacc.c:1646  */
    {
	int segnum = cb_get_int ((yyvsp[0]));

	(yyval) = NULL;
	if (cb_verify (cb_section_segments, _("section segments"))) {
		if (segnum > 99) {
			cb_error (_("SECTION segment-number must be less than or equal to 99"));
		} else {
			if (in_declaratives && segnum > 49) {
				cb_error (_("SECTION segment-number in DECLARATIVES must be less than 50"));
			}
			if (!in_declaratives) {
				current_program->flag_segments = 1;
				current_section->segment = segnum;
			} else {
				/* Simon: old version did not allow segments in declaratives at all
					ToDo: check codegen for possible missing parts */
				CB_PENDING (_("SECTION segment within DECLARATIVES"));
			}
		}
	}
  }
#line 19145 "parser.c" /* yacc.c:1646  */
    break;

  case 1377:
#line 10064 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = current_program->exec_list;
	current_program->exec_list = NULL;
	check_unreached = 0;
  }
#line 19155 "parser.c" /* yacc.c:1646  */
    break;

  case 1378:
#line 10069 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_TREE (current_statement);
	current_statement = NULL;
  }
#line 19164 "parser.c" /* yacc.c:1646  */
    break;

  case 1379:
#line 10074 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_reverse (current_program->exec_list);
	current_program->exec_list = (yyvsp[-2]);
	current_statement = CB_STATEMENT ((yyvsp[-1]));
  }
#line 19174 "parser.c" /* yacc.c:1646  */
    break;

  case 1380:
#line 10082 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_skip_label = !!skip_statements;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->xref.skip = 1;
		emit_statement (CB_TREE (current_section));
	}
	if (!current_paragraph) {
		label = cb_build_reference ("MAIN PARAGRAPH");
		current_paragraph = CB_LABEL (cb_build_label (label, NULL));
		CB_TREE (current_paragraph)->source_file
			= CB_TREE (current_section)->source_file;
		CB_TREE (current_paragraph)->source_line
			= CB_TREE (current_section)->source_line;
		current_paragraph->flag_declaratives = !!in_declaratives;
		current_paragraph->flag_skip_label = !!skip_statements;
		current_paragraph->flag_dummy_paragraph = 1;
		current_paragraph->xref.skip = 1;
		emit_statement (CB_TREE (current_paragraph));
	}
	if (check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0) == 1) {
		if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM) {
			backup_current_pos ();
			emit_entry (current_program->program_id, 0, NULL, NULL);
		}
	}
  }
#line 19212 "parser.c" /* yacc.c:1646  */
    break;

  case 1381:
#line 10116 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 19220 "parser.c" /* yacc.c:1646  */
    break;

  case 1382:
#line 10120 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 19228 "parser.c" /* yacc.c:1646  */
    break;

  case 1447:
#line 10194 "parser.y" /* yacc.c:1646  */
    {
	if (cb_verify (cb_next_sentence_phrase, "NEXT SENTENCE")) {
		cb_tree label;
		char	name[32];

		begin_statement ("NEXT SENTENCE", 0);
		sprintf (name, "L$%d", next_label_id);
		label = cb_build_reference (name);
		next_label_list = cb_list_add (next_label_list, label);
		emit_statement (cb_build_goto (label, NULL));
	}
	check_unreached = 0;
  }
#line 19246 "parser.c" /* yacc.c:1646  */
    break;

  case 1448:
#line 10208 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
	cobc_cs_check = 0;
  }
#line 19255 "parser.c" /* yacc.c:1646  */
    break;

  case 1449:
#line 10219 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ACCEPT", TERM_ACCEPT);
	cobc_cs_check = CB_CS_ACCEPT;
  }
#line 19264 "parser.c" /* yacc.c:1646  */
    break;

  case 1451:
#line 10229 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19274 "parser.c" /* yacc.c:1646  */
    break;

  case 1452:
#line 10235 "parser.y" /* yacc.c:1646  */
    {
	/* Check for invalid use of screen clauses */
	if (current_statement->attr_ptr
	 || (!is_screen_field ((yyvsp[-3])) && line_column)) {
		cb_verify_x ((yyvsp[-3]), cb_accept_display_extensions,
			     _("non-standard ACCEPT"));
	}

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	if ((yyvsp[-3]) == cb_null && current_statement->attr_ptr) {
		if (current_statement->attr_ptr->prompt) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("PROMPT clause"));
		}
		if (current_statement->attr_ptr->size_is) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("SIZE IS clause"));
		}
	}
	cobc_cs_check = 0;
	cb_emit_accept ((yyvsp[-3]), line_column, current_statement->attr_ptr);
  }
#line 19306 "parser.c" /* yacc.c:1646  */
    break;

  case 1453:
#line 10263 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19316 "parser.c" /* yacc.c:1646  */
    break;

  case 1454:
#line 10269 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	CB_PENDING ("ACCEPT FROM SCREEN");
  }
#line 19325 "parser.c" /* yacc.c:1646  */
    break;

  case 1455:
#line 10274 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_line_or_col ((yyvsp[-2]), 0);
  }
#line 19333 "parser.c" /* yacc.c:1646  */
    break;

  case 1456:
#line 10278 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_line_or_col ((yyvsp[-2]), 1);
  }
#line 19341 "parser.c" /* yacc.c:1646  */
    break;

  case 1457:
#line 10282 "parser.y" /* yacc.c:1646  */
    {
	/* information about terminal and its capabilities
	cb_emit_accept_terminal_info ($1); */
	CB_PENDING ("ACCEPT FROM TERMINAL INFO");
  }
#line 19351 "parser.c" /* yacc.c:1646  */
    break;

  case 1458:
#line 10288 "parser.y" /* yacc.c:1646  */
    {
	/* information about OS and runtime features
	cb_emit_accept_system_info ($1); */
	CB_PENDING ("ACCEPT FROM SYSTEM INFO");
  }
#line 19361 "parser.c" /* yacc.c:1646  */
    break;

  case 1459:
#line 10294 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date_yyyymmdd ((yyvsp[-3]));
  }
#line 19370 "parser.c" /* yacc.c:1646  */
    break;

  case 1460:
#line 10299 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date ((yyvsp[-2]));
  }
#line 19379 "parser.c" /* yacc.c:1646  */
    break;

  case 1461:
#line 10304 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day_yyyyddd ((yyvsp[-3]));
  }
#line 19388 "parser.c" /* yacc.c:1646  */
    break;

  case 1462:
#line 10309 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day ((yyvsp[-2]));
  }
#line 19397 "parser.c" /* yacc.c:1646  */
    break;

  case 1463:
#line 10314 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_day_of_week ((yyvsp[-2]));
  }
#line 19405 "parser.c" /* yacc.c:1646  */
    break;

  case 1464:
#line 10320 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_escape_key ((yyvsp[-3]));
  }
#line 19413 "parser.c" /* yacc.c:1646  */
    break;

  case 1465:
#line 10326 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_exception_status ((yyvsp[-3]));
  }
#line 19421 "parser.c" /* yacc.c:1646  */
    break;

  case 1466:
#line 10330 "parser.y" /* yacc.c:1646  */
    {
	/* check is data from keyboard available? "1", else "0"
	cb_emit_accept_input_status ($1); */
	CB_PENDING ("ACCEPT FROM INPUT STATUS");
  }
#line 19431 "parser.c" /* yacc.c:1646  */
    break;

  case 1467:
#line 10336 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_time ((yyvsp[-2]));
  }
#line 19439 "parser.c" /* yacc.c:1646  */
    break;

  case 1468:
#line 10340 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_user_name ((yyvsp[-3]));
  }
#line 19448 "parser.c" /* yacc.c:1646  */
    break;

  case 1469:
#line 10345 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_command_line ((yyvsp[-2]));
  }
#line 19456 "parser.c" /* yacc.c:1646  */
    break;

  case 1470:
#line 10349 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_environment ((yyvsp[-3]));
  }
#line 19464 "parser.c" /* yacc.c:1646  */
    break;

  case 1471:
#line 10353 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_get_environment ((yyvsp[-1]), (yyvsp[-4]));
  }
#line 19472 "parser.c" /* yacc.c:1646  */
    break;

  case 1472:
#line 10357 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_arg_number ((yyvsp[-2]));
  }
#line 19480 "parser.c" /* yacc.c:1646  */
    break;

  case 1473:
#line 10361 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_arg_value ((yyvsp[-3]));
  }
#line 19488 "parser.c" /* yacc.c:1646  */
    break;

  case 1474:
#line 10365 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_mnemonic ((yyvsp[-2]), (yyvsp[0]));
  }
#line 19496 "parser.c" /* yacc.c:1646  */
    break;

  case 1475:
#line 10369 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_name ((yyvsp[-2]), (yyvsp[0]));
  }
#line 19504 "parser.c" /* yacc.c:1646  */
    break;

  case 1476:
#line 10373 "parser.y" /* yacc.c:1646  */
    {
	cb_verify_x ((yyvsp[-1]), cb_accept_display_extensions,
		     _("non-standard ACCEPT"));

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	cobc_cs_check = 0;
	cb_emit_accept ((yyvsp[-1]), line_column, current_statement->attr_ptr);
  }
#line 19522 "parser.c" /* yacc.c:1646  */
    break;

  case 1477:
#line 10387 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("ACCEPT MESSAGE COUNT");
  }
#line 19530 "parser.c" /* yacc.c:1646  */
    break;

  case 1479:
#line 10395 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 19538 "parser.c" /* yacc.c:1646  */
    break;

  case 1480:
#line 10401 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 19548 "parser.c" /* yacc.c:1646  */
    break;

  case 1481:
#line 10407 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 19556 "parser.c" /* yacc.c:1646  */
    break;

  case 1482:
#line 10414 "parser.y" /* yacc.c:1646  */
    {
	line_column = CB_BUILD_PAIR ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 19564 "parser.c" /* yacc.c:1646  */
    break;

  case 1483:
#line 10418 "parser.y" /* yacc.c:1646  */
    {
	line_column = CB_BUILD_PAIR ((yyvsp[-2]), cb_int0);
  }
#line 19572 "parser.c" /* yacc.c:1646  */
    break;

  case 1484:
#line 10422 "parser.y" /* yacc.c:1646  */
    {
	line_column = CB_BUILD_PAIR (cb_int0, (yyvsp[-1]));
  }
#line 19580 "parser.c" /* yacc.c:1646  */
    break;

  case 1485:
#line 10429 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 19588 "parser.c" /* yacc.c:1646  */
    break;

  case 1486:
#line 10433 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_binary_op ((yyvsp[-2]), '+', (yyvsp[0]));
  }
#line 19596 "parser.c" /* yacc.c:1646  */
    break;

  case 1487:
#line 10437 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_binary_op ((yyvsp[-2]), '-', (yyvsp[0]));
  }
#line 19604 "parser.c" /* yacc.c:1646  */
    break;

  case 1495:
#line 10461 "parser.y" /* yacc.c:1646  */
    {
	  check_repeated ("FROM CRT", SYN_CLAUSE_2, &check_duplicate);
  }
#line 19612 "parser.c" /* yacc.c:1646  */
    break;

  case 1496:
#line 10465 "parser.y" /* yacc.c:1646  */
    {
	  check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 19620 "parser.c" /* yacc.c:1646  */
    break;

  case 1498:
#line 10470 "parser.y" /* yacc.c:1646  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, (yyvsp[0]), NULL, NULL, 0);
  }
#line 19630 "parser.c" /* yacc.c:1646  */
    break;

  case 1505:
#line 10495 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict ("LINE", SYN_CLAUSE_1,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P ((yyvsp[0])) && cb_get_int ((yyvsp[0])) == 0) || (yyvsp[0]) == cb_zero) {
		cb_verify (cb_accept_display_extensions, "LINE 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR ((yyvsp[0]), cb_int0);
	} else {
		CB_PAIR_X (line_column) = (yyvsp[0]);
	}
  }
#line 19650 "parser.c" /* yacc.c:1646  */
    break;

  case 1506:
#line 10511 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict ("COLUMN", SYN_CLAUSE_2,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P ((yyvsp[0])) && cb_get_int ((yyvsp[0])) == 0) || (yyvsp[0]) == cb_zero) {
		cb_verify (cb_accept_display_extensions, "COLUMN 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (cb_int0, (yyvsp[0]));
	} else {
		CB_PAIR_Y (line_column) = (yyvsp[0]);
	}
  }
#line 19670 "parser.c" /* yacc.c:1646  */
    break;

  case 1507:
#line 10527 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict (_("AT screen-location"), SYN_CLAUSE_3,
				_("LINE or COLUMN"), SYN_CLAUSE_1 | SYN_CLAUSE_2,
				1, &check_line_col_duplicate);

	cb_verify (cb_accept_display_extensions, "AT clause");

	line_column = (yyvsp[0]);
  }
#line 19684 "parser.c" /* yacc.c:1646  */
    break;

  case 1508:
#line 10540 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	(yyval) = (yyvsp[0]);
  }
#line 19693 "parser.c" /* yacc.c:1646  */
    break;

  case 1509:
#line 10548 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: arithmetic expression should be possible, too, only numeric literals! */
	(yyval) = (yyvsp[0]);
  }
#line 19702 "parser.c" /* yacc.c:1646  */
    break;

  case 1510:
#line 10556 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 19710 "parser.c" /* yacc.c:1646  */
    break;

  case 1511:
#line 10563 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("AUTO", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				    "TAB", COB_SCREEN_TAB);
  }
#line 19720 "parser.c" /* yacc.c:1646  */
    break;

  case 1512:
#line 10569 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("TAB", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("TAB", COB_SCREEN_TAB,
				    "AUTO", COB_SCREEN_AUTO);
  }
#line 19730 "parser.c" /* yacc.c:1646  */
    break;

  case 1513:
#line 10575 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 19739 "parser.c" /* yacc.c:1646  */
    break;

  case 1514:
#line 10580 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	/* FIXME: do we need a COB_NO_SCREEN_BELL here?
	set_dispattr (COB_SCREEN_BELL); */
  }
#line 19749 "parser.c" /* yacc.c:1646  */
    break;

  case 1515:
#line 10586 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_8, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 19758 "parser.c" /* yacc.c:1646  */
    break;

  case 1516:
#line 10591 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_9, &check_duplicate);
	CB_PENDING ("ACCEPT CONVERSION");
  }
#line 19767 "parser.c" /* yacc.c:1646  */
    break;

  case 1517:
#line 10596 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	if (current_program->cursor_pos) {
		emit_duplicate_clause_message ("CURSOR");
	} else {
		/* TODO: actually reasonable and easy extension: an 
		         *offset within the field* [auto-correct to 1/max]
				 (when variable also stored back on return)
		*/
		CB_PENDING ("ACCEPT ... WITH CURSOR");
	}
  }
#line 19784 "parser.c" /* yacc.c:1646  */
    break;

  case 1518:
#line 10609 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FULL", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr (COB_SCREEN_FULL);
  }
#line 19793 "parser.c" /* yacc.c:1646  */
    break;

  case 1519:
#line 10614 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LEFTLINE", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr (COB_SCREEN_LEFTLINE);
  }
#line 19802 "parser.c" /* yacc.c:1646  */
    break;

  case 1520:
#line 10619 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWER", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr_with_conflict ("LOWER", COB_SCREEN_LOWER,
				    "UPPER", COB_SCREEN_UPPER);
  }
#line 19812 "parser.c" /* yacc.c:1646  */
    break;

  case 1521:
#line 10625 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 19822 "parser.c" /* yacc.c:1646  */
    break;

  case 1522:
#line 10631 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 19832 "parser.c" /* yacc.c:1646  */
    break;

  case 1523:
#line 10638 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 19842 "parser.c" /* yacc.c:1646  */
    break;

  case 1524:
#line 10644 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 19850 "parser.c" /* yacc.c:1646  */
    break;

  case 1525:
#line 10648 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19858 "parser.c" /* yacc.c:1646  */
    break;

  case 1526:
#line 10652 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19866 "parser.c" /* yacc.c:1646  */
    break;

  case 1527:
#line 10656 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 19874 "parser.c" /* yacc.c:1646  */
    break;

  case 1528:
#line 10660 "parser.y" /* yacc.c:1646  */
    {
	if (cb_no_echo_means_secure) {
		check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
		set_dispattr (COB_SCREEN_SECURE);
	} else {
		check_repeated ("NO-ECHO", SYN_CLAUSE_15, &check_duplicate);
		set_dispattr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					    "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 19889 "parser.c" /* yacc.c:1646  */
    break;

  case 1529:
#line 10671 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 19898 "parser.c" /* yacc.c:1646  */
    break;

  case 1530:
#line 10676 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, (yyvsp[0]), NULL, COB_SCREEN_PROMPT);
  }
#line 19907 "parser.c" /* yacc.c:1646  */
    break;

  case 1531:
#line 10681 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_dispattr (COB_SCREEN_PROMPT);
  }
#line 19916 "parser.c" /* yacc.c:1646  */
    break;

  case 1532:
#line 10686 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REQUIRED", SYN_CLAUSE_18, &check_duplicate);
	set_dispattr (COB_SCREEN_REQUIRED);
  }
#line 19925 "parser.c" /* yacc.c:1646  */
    break;

  case 1533:
#line 10691 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_19, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 19934 "parser.c" /* yacc.c:1646  */
    break;

  case 1534:
#line 10696 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
	set_dispattr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				    "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 19944 "parser.c" /* yacc.c:1646  */
    break;

  case 1535:
#line 10702 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("SIZE", SYN_CLAUSE_21, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, (yyvsp[0]), 0);
  }
#line 19954 "parser.c" /* yacc.c:1646  */
    break;

  case 1536:
#line 10708 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_22, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 19963 "parser.c" /* yacc.c:1646  */
    break;

  case 1537:
#line 10713 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NO UPDATE", SYN_CLAUSE_23, &check_duplicate);
	set_dispattr_with_conflict ("NO UPDATE", COB_SCREEN_NO_UPDATE,
				    "UPDATE", COB_SCREEN_UPDATE);
  }
#line 19973 "parser.c" /* yacc.c:1646  */
    break;

  case 1538:
#line 10719 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPDATE", SYN_CLAUSE_24, &check_duplicate);
	set_dispattr_with_conflict ("UPDATE", COB_SCREEN_UPDATE,
				    "NO UPDATE", COB_SCREEN_NO_UPDATE);
  }
#line 19983 "parser.c" /* yacc.c:1646  */
    break;

  case 1539:
#line 10725 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPPER", SYN_CLAUSE_25, &check_duplicate);
	set_dispattr_with_conflict ("UPPER", COB_SCREEN_UPPER,
				    "LOWER", COB_SCREEN_LOWER);
  }
#line 19993 "parser.c" /* yacc.c:1646  */
    break;

  case 1540:
#line 10731 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: arithmetic expression should be possible, too! */
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 20004 "parser.c" /* yacc.c:1646  */
    break;

  case 1541:
#line 10738 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	set_attribs ((yyvsp[0]), NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 20013 "parser.c" /* yacc.c:1646  */
    break;

  case 1542:
#line 10743 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	set_attribs (NULL, (yyvsp[0]), NULL, NULL, NULL, NULL, 0);
  }
#line 20022 "parser.c" /* yacc.c:1646  */
    break;

  case 1543:
#line 10748 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_28, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 20033 "parser.c" /* yacc.c:1646  */
    break;

  case 1544:
#line 10755 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 20044 "parser.c" /* yacc.c:1646  */
    break;

  case 1545:
#line 10762 "parser.y" /* yacc.c:1646  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, (yyvsp[0]), NULL, NULL, 0);
  }
#line 20054 "parser.c" /* yacc.c:1646  */
    break;

  case 1549:
#line 10775 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONTROL KEY", SYN_CLAUSE_29, &check_duplicate);
	CB_PENDING ("CONTROL KEY");
#if 0 /* should generate the following *after* the ACCEPT is finished */
	cb_emit_accept_escape_key ((yyvsp[0]));
#endif
  }
#line 20066 "parser.c" /* yacc.c:1646  */
    break;

  case 1558:
#line 10803 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), ACCEPT);
  }
#line 20074 "parser.c" /* yacc.c:1646  */
    break;

  case 1559:
#line 10807 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), ACCEPT);
# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
	if (current_statement->attr_ptr) {
		print_bits (current_statement->attr_ptr->dispattrs);
	} else {
		fputs("No Attribs", stderr);
	}
#endif
  }
#line 20090 "parser.c" /* yacc.c:1646  */
    break;

  case 1560:
#line 10825 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ADD", TERM_ADD);
  }
#line 20098 "parser.c" /* yacc.c:1646  */
    break;

  case 1562:
#line 10834 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '+', cb_build_binary_list ((yyvsp[-3]), '+'));
  }
#line 20106 "parser.c" /* yacc.c:1646  */
    break;

  case 1563:
#line 10838 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-3])) {
		cb_list_add ((yyvsp[-4]), (yyvsp[-3]));
	}
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_list ((yyvsp[-4]), '+'));
  }
#line 20117 "parser.c" /* yacc.c:1646  */
    break;

  case 1564:
#line 10845 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_corresponding (cb_build_add, (yyvsp[-2]), (yyvsp[-4]), (yyvsp[-1]));
  }
#line 20125 "parser.c" /* yacc.c:1646  */
    break;

  case 1565:
#line 10849 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("ADD TABLE");
	cb_emit_tab_arithmetic (cb_build_add, (yyvsp[-4]), (yyvsp[-6]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 20134 "parser.c" /* yacc.c:1646  */
    break;

  case 1566:
#line 10856 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 20140 "parser.c" /* yacc.c:1646  */
    break;

  case 1567:
#line 10857 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20146 "parser.c" /* yacc.c:1646  */
    break;

  case 1568:
#line 10862 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), ADD);
  }
#line 20154 "parser.c" /* yacc.c:1646  */
    break;

  case 1569:
#line 10866 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), ADD);
  }
#line 20162 "parser.c" /* yacc.c:1646  */
    break;

  case 1570:
#line 10876 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ALLOCATE", 0);
	cobc_cs_check = CB_CS_ALLOCATE;
	current_statement->flag_no_based = 1;
  }
#line 20172 "parser.c" /* yacc.c:1646  */
    break;

  case 1572:
#line 10886 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_allocate ((yyvsp[-3]), (yyvsp[0]), NULL, (yyvsp[-2]));
  }
#line 20180 "parser.c" /* yacc.c:1646  */
    break;

  case 1573:
#line 10890 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		cb_error_x (CB_TREE (current_statement),
			    _("ALLOCATE CHARACTERS requires RETURNING clause"));
	} else {
		cb_emit_allocate (NULL, (yyvsp[0]), (yyvsp[-4]), (yyvsp[-2]));
	}
  }
#line 20193 "parser.c" /* yacc.c:1646  */
    break;

  case 1575:
#line 10903 "parser.y" /* yacc.c:1646  */
    {
	int adressing = cb_get_int ((yyvsp[0]));

	if (adressing == 24
	 || adressing == 31) {
		cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "LOC");
	} else {
		cb_error (_("addressing mode should be either 24 or 31 bit"));
	}
  }
#line 20208 "parser.c" /* yacc.c:1646  */
    break;

  case 1576:
#line 10915 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 20214 "parser.c" /* yacc.c:1646  */
    break;

  case 1577:
#line 10916 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20220 "parser.c" /* yacc.c:1646  */
    break;

  case 1578:
#line 10924 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ALTER", 0);
	cb_verify (cb_alter_statement, "ALTER");
  }
#line 20229 "parser.c" /* yacc.c:1646  */
    break;

  case 1582:
#line 10938 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_alter ((yyvsp[-3]), (yyvsp[0]));
  }
#line 20237 "parser.c" /* yacc.c:1646  */
    break;

  case 1585:
#line 10950 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CALL", TERM_CALL);
	cobc_cs_check = CB_CS_CALL;
	call_nothing = 0;
	cobc_allow_program_name = 1;
	backup_current_pos ();
  }
#line 20249 "parser.c" /* yacc.c:1646  */
    break;

  case 1586:
#line 10959 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 20257 "parser.c" /* yacc.c:1646  */
    break;

  case 1587:
#line 10966 "parser.y" /* yacc.c:1646  */
    {
	cobc_allow_program_name = 0;
  }
#line 20265 "parser.c" /* yacc.c:1646  */
    break;

  case 1588:
#line 10974 "parser.y" /* yacc.c:1646  */
    {
	int call_conv = 0;
	int call_conv_local = 0;

	if (current_program->prog_type == COB_MODULE_TYPE_PROGRAM
	    && !current_program->flag_recursive
	    && is_recursive_call ((yyvsp[-6]))) {
		cb_warning_x (COBC_WARN_FILLER, (yyvsp[-6]),
			_("recursive program call - assuming RECURSIVE attribute"));
		current_program->flag_recursive = 1;
	}
	call_conv = current_call_convention;
	if ((yyvsp[-3])) {
		if (current_call_convention & CB_CONV_STATIC_LINK) {
			call_conv = CB_INTEGER ((yyvsp[-3]))->val | CB_CONV_STATIC_LINK;
		} else {
			call_conv = CB_INTEGER ((yyvsp[-3]))->val;
		}
		if ((yyvsp[-8])) {
			/* note: $1 is likely to be a reference to SPECIAL-NAMES */
			cb_error_x ((yyvsp[-3]), _("%s and %s are mutually exclusive"),
				"CALL-CONVENTION", "WITH LINKAGE");
		}
	}
	if ((CB_PAIR_X ((yyvsp[0])) != NULL)
	 && (call_conv & CB_CONV_STATIC_LINK)) {
		cb_warning_x (COBC_WARN_FILLER, (yyvsp[-6]),
		    _("STATIC CALL convention ignored because of ON EXCEPTION"));
		call_conv &= ~CB_CONV_STATIC_LINK;
	}
	if ((yyvsp[-8])) {
		if (CB_INTEGER_P ((yyvsp[-8]))) {
			call_conv_local = CB_INTEGER ((yyvsp[-8]))->val;
			if ((CB_PAIR_X ((yyvsp[0])) != NULL)
			 && (call_conv_local & CB_CONV_STATIC_LINK)) {
				cb_warning_x (COBC_WARN_FILLER, (yyvsp[-8]),
					_("ON EXCEPTION ignored because of STATIC CALL"));
				CB_PAIR_X ((yyvsp[0])) = NULL;
			}
			call_conv |= call_conv_local;
			if (CB_INTEGER ((yyvsp[-8]))->val & CB_CONV_COBOL) {
				call_conv &= ~CB_CONV_STDCALL;
			} else {
				call_conv &= ~CB_CONV_COBOL;
			}
		} else {
			call_conv = cb_get_int((yyvsp[-8]));
		}
	}
	/* For CALL ... RETURNING NOTHING, set the call convention bit */
	if (call_nothing) {
		call_conv |= CB_CONV_NO_RET_UPD;
	}
	cb_emit_call ((yyvsp[-6]), (yyvsp[-2]), (yyvsp[-1]), CB_PAIR_X ((yyvsp[0])), CB_PAIR_Y ((yyvsp[0])),
		      cb_int (call_conv), (yyvsp[-7]), (yyvsp[-4]), backup_source_line);
  }
#line 20326 "parser.c" /* yacc.c:1646  */
    break;

  case 1589:
#line 11034 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20334 "parser.c" /* yacc.c:1646  */
    break;

  case 1590:
#line 11038 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: hack - fake cs for context-sensitive WITH ... LINKAGE */
	cobc_cs_check |= CB_CS_OPTIONS;
	backup_current_pos ();
  }
#line 20344 "parser.c" /* yacc.c:1646  */
    break;

  case 1591:
#line 11044 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	restore_backup_pos ((yyval));
	cobc_cs_check ^= CB_CS_OPTIONS;
	cb_verify_x ((yyval), cb_call_convention_linkage, "WITH ... LINKAGE");
  }
#line 20355 "parser.c" /* yacc.c:1646  */
    break;

  case 1592:
#line 11054 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_STDCALL);
  }
#line 20363 "parser.c" /* yacc.c:1646  */
    break;

  case 1593:
#line 11058 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_C);
  }
#line 20371 "parser.c" /* yacc.c:1646  */
    break;

  case 1594:
#line 11062 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_PASCAL);
  }
#line 20379 "parser.c" /* yacc.c:1646  */
    break;

  case 1595:
#line 11069 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20387 "parser.c" /* yacc.c:1646  */
    break;

  case 1596:
#line 11073 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_call_convention_mnemonic, "CALL-/ENTRY-CONVENTION");
	(yyval) = (yyvsp[0]);
  }
#line 20396 "parser.c" /* yacc.c:1646  */
    break;

  case 1597:
#line 11081 "parser.y" /* yacc.c:1646  */
    {
	if (current_call_convention & CB_CONV_COBOL) {
		(yyval) = cb_int (CB_CONV_STATIC_LINK | CB_CONV_COBOL);
	} else {
		(yyval) = cb_int (CB_CONV_STATIC_LINK);
	}
  }
#line 20408 "parser.c" /* yacc.c:1646  */
    break;

  case 1598:
#line 11089 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_STDCALL);
  }
#line 20416 "parser.c" /* yacc.c:1646  */
    break;

  case 1599:
#line 11093 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_C);
  }
#line 20424 "parser.c" /* yacc.c:1646  */
    break;

  case 1600:
#line 11097 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_C);
  }
#line 20432 "parser.c" /* yacc.c:1646  */
    break;

  case 1601:
#line 11101 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_PASCAL);
  }
#line 20440 "parser.c" /* yacc.c:1646  */
    break;

  case 1602:
#line 11105 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	x = cb_ref ((yyvsp[0]));
	if (CB_VALID_TREE (x)) {
		if (CB_SYSTEM_NAME(x)->token != CB_FEATURE_CONVENTION) {
			cb_error_x ((yyvsp[0]), _("invalid mnemonic name"));
			(yyval) = NULL;
		} else {
			(yyval) = CB_SYSTEM_NAME(x)->value;
		}
	} else {
		(yyval) = NULL;
	}
  }
#line 20460 "parser.c" /* yacc.c:1646  */
    break;

  case 1603:
#line 11124 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[0]))) {
		cb_trim_program_id ((yyvsp[0]));
	}
  }
#line 20470 "parser.c" /* yacc.c:1646  */
    break;

  case 1604:
#line 11130 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
	/* hack to push the prototype name */
	if ((yyvsp[0]) && CB_REFERENCE_P ((yyvsp[0]))) {
		if ((yyvsp[-1])) {
			cb_warning_x (COBC_WARN_FILLER, (yyvsp[-1]), _("id/literal ignored, using prototype name"));
		}
		(yyval) = (yyvsp[0]);
	} else if ((yyvsp[-1]) && CB_LITERAL_P ((yyvsp[-1]))) {
		(yyval) = (yyvsp[-1]);
	} else {
		cb_error (_("NESTED phrase is only valid with literal"));
		(yyval) = cb_error_node;
	}
  }
#line 20490 "parser.c" /* yacc.c:1646  */
    break;

  case 1605:
#line 11149 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20498 "parser.c" /* yacc.c:1646  */
    break;

  case 1606:
#line 11154 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[-1]))) {
		cb_trim_program_id ((yyvsp[-1]));
	}
	(yyval) = (yyvsp[-1]);
  }
#line 20509 "parser.c" /* yacc.c:1646  */
    break;

  case 1607:
#line 11164 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("NESTED phrase for CALL statement");
  }
#line 20517 "parser.c" /* yacc.c:1646  */
    break;

  case 1609:
#line 11172 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20525 "parser.c" /* yacc.c:1646  */
    break;

  case 1610:
#line 11176 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 20534 "parser.c" /* yacc.c:1646  */
    break;

  case 1611:
#line 11181 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error_x (CB_TREE (current_statement),
			    _("number of arguments exceeds maximum %d"),
			    MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 20547 "parser.c" /* yacc.c:1646  */
    break;

  case 1612:
#line 11192 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20553 "parser.c" /* yacc.c:1646  */
    break;

  case 1613:
#line 11194 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 20559 "parser.c" /* yacc.c:1646  */
    break;

  case 1614:
#line 11199 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error_x (CB_TREE (current_statement),
			    _("OMITTED only allowed when arguments are passed BY REFERENCE"));
	}
	(yyval) = CB_BUILD_PAIR (cb_int (call_mode), cb_null);
  }
#line 20571 "parser.c" /* yacc.c:1646  */
    break;

  case 1615:
#line 11207 "parser.y" /* yacc.c:1646  */
    {
	int	save_mode;	/* internal single parameter only mode */

	save_mode = call_mode;
	if (CB_LITERAL_P((yyvsp[0]))) {
		/* literals become BY CONTENT */
		if (CB_NUMERIC_LITERAL_P ((yyvsp[0]))) {
			/* If not BY VALUE numeric-literals become BY CONTENT */
			if (call_mode != CB_CALL_BY_VALUE) {
				call_mode = CB_CALL_BY_CONTENT;
			}
		} else {
			call_mode = CB_CALL_BY_CONTENT;
		}
	}
	if (call_mode != CB_CALL_BY_REFERENCE) {
		if (CB_FILE_P ((yyvsp[0])) || (CB_REFERENCE_P ((yyvsp[0])) &&
		    CB_FILE_P (CB_REFERENCE ((yyvsp[0]))->value))) {
			cb_error_x (CB_TREE (current_statement),
				    _("invalid file name reference"));
		} else if (call_mode == CB_CALL_BY_VALUE) {
			/* FIXME: compiler configuration needed, IBM allows one-byte
			          alphanumeric items [--> a `char`], too, while
			          COBOL 2002/2014 allow only numeric literals
			   --> revise after rw-merge */
			if (cb_category_is_alpha ((yyvsp[0]))) {
				cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]),
					      _("BY CONTENT assumed for alphanumeric item '%s'"),
						  cb_name ((yyvsp[0])));
				call_mode = CB_CALL_BY_CONTENT;
			} else if (cb_category_is_national ((yyvsp[0]))) {
				cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]),
					      _("BY CONTENT assumed for national item '%s'"),
						  cb_name ((yyvsp[0])));
				call_mode = CB_CALL_BY_CONTENT;
			}
		}
	}
	(yyval) = CB_BUILD_PAIR (cb_int (call_mode), (yyvsp[0]));
	CB_SIZES ((yyval)) = size_mode;
	call_mode = save_mode;
  }
#line 20618 "parser.c" /* yacc.c:1646  */
    break;

  case 1617:
#line 11254 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 20626 "parser.c" /* yacc.c:1646  */
    break;

  case 1618:
#line 11258 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY CONTENT");
	} else {
		call_mode = CB_CALL_BY_CONTENT;
	}
  }
#line 20639 "parser.c" /* yacc.c:1646  */
    break;

  case 1619:
#line 11267 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 20652 "parser.c" /* yacc.c:1646  */
    break;

  case 1620:
#line 11279 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20660 "parser.c" /* yacc.c:1646  */
    break;

  case 1621:
#line 11283 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20668 "parser.c" /* yacc.c:1646  */
    break;

  case 1622:
#line 11287 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 20676 "parser.c" /* yacc.c:1646  */
    break;

  case 1623:
#line 11291 "parser.y" /* yacc.c:1646  */
    {
	call_nothing = CB_CONV_NO_RET_UPD;
	(yyval) = cb_null;
  }
#line 20685 "parser.c" /* yacc.c:1646  */
    break;

  case 1624:
#line 11296 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01 or 77"));
			(yyval) = NULL;
		} else if (f->storage != CB_STORAGE_LINKAGE &&
			   !f->flag_item_based) {
			cb_error (_("RETURNING item must be a LINKAGE SECTION item or have BASED clause"));
			(yyval) = NULL;
		} else {
			(yyval) = cb_build_address ((yyvsp[0]));
		}
	} else {
		(yyval) = NULL;
	}
  }
#line 20709 "parser.c" /* yacc.c:1646  */
    break;

  case 1629:
#line 11329 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR (NULL, NULL);
  }
#line 20717 "parser.c" /* yacc.c:1646  */
    break;

  case 1630:
#line 11333 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20725 "parser.c" /* yacc.c:1646  */
    break;

  case 1631:
#line 11337 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
	(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-1]));
  }
#line 20737 "parser.c" /* yacc.c:1646  */
    break;

  case 1632:
#line 11348 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20745 "parser.c" /* yacc.c:1646  */
    break;

  case 1633:
#line 11352 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20753 "parser.c" /* yacc.c:1646  */
    break;

  case 1634:
#line 11359 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20761 "parser.c" /* yacc.c:1646  */
    break;

  case 1635:
#line 11363 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_call_overflow, "ON OVERFLOW");
	(yyval) = (yyvsp[0]);
  }
#line 20770 "parser.c" /* yacc.c:1646  */
    break;

  case 1636:
#line 11371 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 20778 "parser.c" /* yacc.c:1646  */
    break;

  case 1637:
#line 11375 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20786 "parser.c" /* yacc.c:1646  */
    break;

  case 1638:
#line 11382 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20794 "parser.c" /* yacc.c:1646  */
    break;

  case 1639:
#line 11389 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), CALL);
  }
#line 20802 "parser.c" /* yacc.c:1646  */
    break;

  case 1640:
#line 11393 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), CALL);
  }
#line 20810 "parser.c" /* yacc.c:1646  */
    break;

  case 1641:
#line 11403 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CANCEL", 0);
	cobc_allow_program_name = 1;
  }
#line 20819 "parser.c" /* yacc.c:1646  */
    break;

  case 1642:
#line 11408 "parser.y" /* yacc.c:1646  */
    {
	cobc_allow_program_name = 0;
  }
#line 20827 "parser.c" /* yacc.c:1646  */
    break;

  case 1643:
#line 11415 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_cancel ((yyvsp[0]));
  }
#line 20835 "parser.c" /* yacc.c:1646  */
    break;

  case 1644:
#line 11419 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_cancel ((yyvsp[0]));
  }
#line 20843 "parser.c" /* yacc.c:1646  */
    break;

  case 1646:
#line 11427 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
  }
#line 20851 "parser.c" /* yacc.c:1646  */
    break;

  case 1647:
#line 11436 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CLOSE", 0);
  }
#line 20859 "parser.c" /* yacc.c:1646  */
    break;

  case 1651:
#line 11449 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_close ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20868 "parser.c" /* yacc.c:1646  */
    break;

  case 1652:
#line 11454 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_close ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20877 "parser.c" /* yacc.c:1646  */
    break;

  case 1653:
#line 11461 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_NORMAL); }
#line 20883 "parser.c" /* yacc.c:1646  */
    break;

  case 1654:
#line 11462 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_UNIT); }
#line 20889 "parser.c" /* yacc.c:1646  */
    break;

  case 1655:
#line 11463 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_UNIT_REMOVAL); }
#line 20895 "parser.c" /* yacc.c:1646  */
    break;

  case 1656:
#line 11464 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_NO_REWIND); }
#line 20901 "parser.c" /* yacc.c:1646  */
    break;

  case 1657:
#line 11465 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_LOCK); }
#line 20907 "parser.c" /* yacc.c:1646  */
    break;

  case 1658:
#line 11470 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "CLOSE WINDOW";
  }
#line 20916 "parser.c" /* yacc.c:1646  */
    break;

  case 1659:
#line 11475 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_close_window ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20924 "parser.c" /* yacc.c:1646  */
    break;

  case 1660:
#line 11481 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 20930 "parser.c" /* yacc.c:1646  */
    break;

  case 1661:
#line 11482 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 20936 "parser.c" /* yacc.c:1646  */
    break;

  case 1662:
#line 11490 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("COMPUTE", TERM_COMPUTE);
  }
#line 20944 "parser.c" /* yacc.c:1646  */
    break;

  case 1664:
#line 11499 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-3]), 0, (yyvsp[-1]));
  }
#line 20952 "parser.c" /* yacc.c:1646  */
    break;

  case 1665:
#line 11506 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), COMPUTE);
  }
#line 20960 "parser.c" /* yacc.c:1646  */
    break;

  case 1666:
#line 11510 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), COMPUTE);
  }
#line 20968 "parser.c" /* yacc.c:1646  */
    break;

  case 1667:
#line 11520 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("COMMIT", 0);
	cb_emit_commit ();
  }
#line 20977 "parser.c" /* yacc.c:1646  */
    break;

  case 1668:
#line 11531 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
  }
#line 20985 "parser.c" /* yacc.c:1646  */
    break;

  case 1669:
#line 11535 "parser.y" /* yacc.c:1646  */
    {
	if (!(yyvsp[0])) {
		/* Do not check unreached for CONTINUE without after phrase */
		unsigned int	save_unreached = check_unreached;
		check_unreached = 0;
		begin_statement_from_backup_pos ("CONTINUE", 0);
		cb_emit_continue (NULL);
		check_unreached = save_unreached;
	} else {
		begin_statement_from_backup_pos ("CONTINUE AFTER", 0);
		cb_emit_continue ((yyvsp[0]));
	}
  }
#line 21003 "parser.c" /* yacc.c:1646  */
    break;

  case 1670:
#line 11551 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL;}
#line 21009 "parser.c" /* yacc.c:1646  */
    break;

  case 1671:
#line 11552 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: hack - fake cs for context-sensitive SECONDS */
	cobc_cs_check = CB_CS_RETRY;
  }
#line 21018 "parser.c" /* yacc.c:1646  */
    break;

  case 1672:
#line 11557 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 21026 "parser.c" /* yacc.c:1646  */
    break;

  case 1673:
#line 11567 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DESTROY", 0);
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 21035 "parser.c" /* yacc.c:1646  */
    break;

  case 1675:
#line 11576 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_destroy (NULL);
  }
#line 21043 "parser.c" /* yacc.c:1646  */
    break;

  case 1676:
#line 11583 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_destroy ((yyvsp[0]));
  }
#line 21051 "parser.c" /* yacc.c:1646  */
    break;

  case 1677:
#line 11593 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DELETE", TERM_DELETE);
  }
#line 21059 "parser.c" /* yacc.c:1646  */
    break;

  case 1679:
#line 11602 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_delete ((yyvsp[-3]));
  }
#line 21067 "parser.c" /* yacc.c:1646  */
    break;

  case 1681:
#line 11610 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file ((yyvsp[0]));
  }
#line 21076 "parser.c" /* yacc.c:1646  */
    break;

  case 1682:
#line 11615 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file ((yyvsp[0]));
  }
#line 21085 "parser.c" /* yacc.c:1646  */
    break;

  case 1683:
#line 11623 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DELETE);
  }
#line 21093 "parser.c" /* yacc.c:1646  */
    break;

  case 1684:
#line 11627 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DELETE);
  }
#line 21101 "parser.c" /* yacc.c:1646  */
    break;

  case 1685:
#line 11637 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DISABLE", 0);
  }
#line 21109 "parser.c" /* yacc.c:1646  */
    break;

  case 1689:
#line 11651 "parser.y" /* yacc.c:1646  */
    {
	/* Add cb_verify for <= COBOL-85 */
  }
#line 21117 "parser.c" /* yacc.c:1646  */
    break;

  case 1695:
#line 11669 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DISPLAY", TERM_DISPLAY);
	cobc_cs_check = CB_CS_DISPLAY;
	display_type = UNKNOWN_DISPLAY;
	is_first_display_item = 1;
  }
#line 21128 "parser.c" /* yacc.c:1646  */
    break;

  case 1697:
#line 11681 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_env_name ((yyvsp[-2]));
  }
#line 21136 "parser.c" /* yacc.c:1646  */
    break;

  case 1698:
#line 11685 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_env_value ((yyvsp[-2]));
  }
#line 21144 "parser.c" /* yacc.c:1646  */
    break;

  case 1699:
#line 11689 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arg_number ((yyvsp[-2]));
  }
#line 21152 "parser.c" /* yacc.c:1646  */
    break;

  case 1700:
#line 11693 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_command_line ((yyvsp[-2]));
  }
#line 21160 "parser.c" /* yacc.c:1646  */
    break;

  case 1708:
#line 11707 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) != NULL) {
		error_if_different_display_type ((yyvsp[0]), NULL, NULL, NULL);
		cb_emit_display ((yyvsp[0]), NULL, cb_int1, NULL, NULL, 0,
				 display_type);
	}
  }
#line 21172 "parser.c" /* yacc.c:1646  */
    break;

  case 1709:
#line 11715 "parser.y" /* yacc.c:1646  */
    {
	set_display_type ((yyvsp[0]), NULL, NULL, NULL);
	cb_emit_display ((yyvsp[0]), NULL, cb_int1, NULL, NULL, 1,
			 display_type);
  }
#line 21182 "parser.c" /* yacc.c:1646  */
    break;

  case 1712:
#line 11729 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	advancing_value = cb_int1;
	upon_value = NULL;
	line_column = NULL;
  }
#line 21194 "parser.c" /* yacc.c:1646  */
    break;

  case 1713:
#line 11737 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2]) == cb_null) {
		/* Emit DISPLAY OMITTED. */
		CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY OMITTED");
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	/* Emit device or screen DISPLAY. */

	/*
	  Check that disp_list does not contain an invalid mix of fields.
	*/
	if (display_type == UNKNOWN_DISPLAY) {
		set_display_type ((yyvsp[-2]), upon_value, line_column,
				  current_statement->attr_ptr);
	} else {
		error_if_different_display_type ((yyvsp[-2]), upon_value,
						 line_column,
						 current_statement->attr_ptr);
	}

	if (display_type == SCREEN_DISPLAY
	    || display_type == FIELD_ON_SCREEN_DISPLAY) {
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	cb_emit_display ((yyvsp[-2]), upon_value, advancing_value, line_column,
			 current_statement->attr_ptr,
			 is_first_display_item, display_type);

	is_first_display_item = 0;
  }
#line 21231 "parser.c" /* yacc.c:1646  */
    break;

  case 1714:
#line 11773 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21239 "parser.c" /* yacc.c:1646  */
    break;

  case 1715:
#line 11777 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 21247 "parser.c" /* yacc.c:1646  */
    break;

  case 1722:
#line 11799 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPON", SYN_CLAUSE_1, &check_duplicate);
  }
#line 21255 "parser.c" /* yacc.c:1646  */
    break;

  case 1723:
#line 11803 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NO ADVANCING", SYN_CLAUSE_2, &check_duplicate);
	advancing_value = cb_int0;
  }
#line 21264 "parser.c" /* yacc.c:1646  */
    break;

  case 1724:
#line 11808 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 21272 "parser.c" /* yacc.c:1646  */
    break;

  case 1727:
#line 11817 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_build_display_mnemonic ((yyvsp[0]));
  }
#line 21280 "parser.c" /* yacc.c:1646  */
    break;

  case 1728:
#line 11821 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_build_display_name ((yyvsp[0]));
  }
#line 21288 "parser.c" /* yacc.c:1646  */
    break;

  case 1729:
#line 11825 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_int2;
  }
#line 21296 "parser.c" /* yacc.c:1646  */
    break;

  case 1730:
#line 11829 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_null;
  }
#line 21304 "parser.c" /* yacc.c:1646  */
    break;

  case 1733:
#line 11841 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = SYN_CLAUSE_10;
	check_line_col_duplicate = 0;
	line_column = NULL;
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21316 "parser.c" /* yacc.c:1646  */
    break;

  case 1734:
#line 11849 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_display (CB_LIST_INIT (cb_space), cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21324 "parser.c" /* yacc.c:1646  */
    break;

  case 1735:
#line 11858 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_display ((yyvsp[-1]), cb_null, cb_int1, line_column, NULL, 1, FIELD_ON_SCREEN_DISPLAY);
  }
#line 21332 "parser.c" /* yacc.c:1646  */
    break;

  case 1736:
#line 11864 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
  }
#line 21342 "parser.c" /* yacc.c:1646  */
    break;

  case 1737:
#line 11870 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21350 "parser.c" /* yacc.c:1646  */
    break;

  case 1738:
#line 11877 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 21358 "parser.c" /* yacc.c:1646  */
    break;

  case 1739:
#line 11881 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 21366 "parser.c" /* yacc.c:1646  */
    break;

  case 1742:
#line 11891 "parser.y" /* yacc.c:1646  */
    {
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
	(yyval) = cb_space;
  }
#line 21376 "parser.c" /* yacc.c:1646  */
    break;

  case 1743:
#line 11901 "parser.y" /* yacc.c:1646  */
    {
	CB_UNFINISHED_X (CB_TREE(current_statement), "DISPLAY MESSAGE");
	upon_value = NULL;
  }
#line 21385 "parser.c" /* yacc.c:1646  */
    break;

  case 1744:
#line 11906 "parser.y" /* yacc.c:1646  */
    {
	/* for now: minimal support for display and prompt only */
	if (upon_value) {
		cb_emit_display (CB_LIST_INIT (upon_value), NULL, NULL, NULL,
				 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	}
	cb_emit_display ((yyvsp[-2]), NULL, NULL, NULL,
			 NULL, 1, FIELD_ON_SCREEN_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
  }
#line 21400 "parser.c" /* yacc.c:1646  */
    break;

  case 1749:
#line 11930 "parser.y" /* yacc.c:1646  */
    {
	upon_value = (yyvsp[0]);
  }
#line 21408 "parser.c" /* yacc.c:1646  */
    break;

  case 1754:
#line 11941 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY WINDOW";
  }
#line 21417 "parser.c" /* yacc.c:1646  */
    break;

  case 1755:
#line 11946 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21428 "parser.c" /* yacc.c:1646  */
    break;

  case 1756:
#line 11953 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_display_window (NULL, upon_value, (yyvsp[-2]), line_column,
			 current_statement->attr_ptr);
  }
#line 21437 "parser.c" /* yacc.c:1646  */
    break;

  case 1759:
#line 11966 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY FLOATING WINDOW";
  }
#line 21446 "parser.c" /* yacc.c:1646  */
    break;

  case 1760:
#line 11971 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 21457 "parser.c" /* yacc.c:1646  */
    break;

  case 1761:
#line 11978 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-5])) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (cb_int0, upon_value, (yyvsp[-2]), line_column,
			 current_statement->attr_ptr);
  }
#line 21470 "parser.c" /* yacc.c:1646  */
    break;

  case 1762:
#line 11990 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY INITIAL WINDOW";
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
	/* TODO: initialize attributes for SHADOW, BOTTOM */
  }
#line 21484 "parser.c" /* yacc.c:1646  */
    break;

  case 1763:
#line 12000 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-3])) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window ((yyvsp[-4]), upon_value, NULL, line_column,
			 current_statement->attr_ptr);
  }
#line 21497 "parser.c" /* yacc.c:1646  */
    break;

  case 1764:
#line 12011 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int1;}
#line 21503 "parser.c" /* yacc.c:1646  */
    break;

  case 1765:
#line 12012 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int2;}
#line 21509 "parser.c" /* yacc.c:1646  */
    break;

  case 1766:
#line 12013 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int3;}
#line 21515 "parser.c" /* yacc.c:1646  */
    break;

  case 1767:
#line 12017 "parser.y" /* yacc.c:1646  */
    {(yyval) = NULL;}
#line 21521 "parser.c" /* yacc.c:1646  */
    break;

  case 1768:
#line 12018 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int1;}
#line 21527 "parser.c" /* yacc.c:1646  */
    break;

  case 1769:
#line 12023 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21535 "parser.c" /* yacc.c:1646  */
    break;

  case 1770:
#line 12027 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21543 "parser.c" /* yacc.c:1646  */
    break;

  case 1771:
#line 12034 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		if (f->usage != CB_USAGE_HNDL_WINDOW
		 && f->usage != CB_USAGE_HNDL_SUBWINDOW) {
			cb_error_x ((yyvsp[0]), _("HANDLE must be a %s HANDLE"), "WINDOW");
		}
	}
	(yyval) = (yyvsp[0]);
  }
#line 21560 "parser.c" /* yacc.c:1646  */
    break;

  case 1772:
#line 12047 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		if (f->usage != CB_USAGE_HNDL) {
			cb_error_x ((yyvsp[0]), _("HANDLE must be a generic HANDLE"));
		}
	}
	(yyval) = (yyvsp[0]);
  }
#line 21576 "parser.c" /* yacc.c:1646  */
    break;

  case 1773:
#line 12059 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 21584 "parser.c" /* yacc.c:1646  */
    break;

  case 1777:
#line 12074 "parser.y" /* yacc.c:1646  */
    {
	/* TODO: store */
  }
#line 21592 "parser.c" /* yacc.c:1646  */
    break;

  case 1784:
#line 12086 "parser.y" /* yacc.c:1646  */
    { /* TODO: set attribute */ }
#line 21598 "parser.c" /* yacc.c:1646  */
    break;

  case 1785:
#line 12089 "parser.y" /* yacc.c:1646  */
    { /* TODO: set attribute */ }
#line 21604 "parser.c" /* yacc.c:1646  */
    break;

  case 1786:
#line 12093 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21610 "parser.c" /* yacc.c:1646  */
    break;

  case 1787:
#line 12094 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21616 "parser.c" /* yacc.c:1646  */
    break;

  case 1788:
#line 12095 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21622 "parser.c" /* yacc.c:1646  */
    break;

  case 1789:
#line 12099 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21628 "parser.c" /* yacc.c:1646  */
    break;

  case 1790:
#line 12100 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21634 "parser.c" /* yacc.c:1646  */
    break;

  case 1791:
#line 12101 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21640 "parser.c" /* yacc.c:1646  */
    break;

  case 1792:
#line 12102 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 21646 "parser.c" /* yacc.c:1646  */
    break;

  case 1797:
#line 12118 "parser.y" /* yacc.c:1646  */
    {
	if (upon_value) {
		emit_duplicate_clause_message("POP-UP AREA");
	}
	upon_value = (yyvsp[0]);
  }
#line 21657 "parser.c" /* yacc.c:1646  */
    break;

  case 1798:
#line 12128 "parser.y" /* yacc.c:1646  */
    {
	if (!strcmp (current_statement->name, "DISPLAY WINDOW")) {
		cb_error_x ((yyvsp[0]), _("HANDLE clause invalid for %s"),
			current_statement->name);
		upon_value = cb_error_node;
	} else{
		if (upon_value) {
			emit_duplicate_clause_message("POP-UP AREA / HANDLE IN");
		}
		upon_value = (yyvsp[0]);
	}
  }
#line 21674 "parser.c" /* yacc.c:1646  */
    break;

  case 1799:
#line 12144 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BELL", SYN_CLAUSE_4, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 21683 "parser.c" /* yacc.c:1646  */
    break;

  case 1800:
#line 12149 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK LINE", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				    "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 21693 "parser.c" /* yacc.c:1646  */
    break;

  case 1801:
#line 12155 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK SCREEN", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				    "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 21703 "parser.c" /* yacc.c:1646  */
    break;

  case 1802:
#line 12161 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 21712 "parser.c" /* yacc.c:1646  */
    break;

  case 1803:
#line 12166 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_8, &check_duplicate);
	cb_warning (COBC_WARN_FILLER, _("ignoring %s phrase"), "CONVERSION");
  }
#line 21721 "parser.c" /* yacc.c:1646  */
    break;

  case 1804:
#line 12171 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ERASE EOL", SYN_CLAUSE_9, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				    "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 21731 "parser.c" /* yacc.c:1646  */
    break;

  case 1805:
#line 12177 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ERASE EOS", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 21741 "parser.c" /* yacc.c:1646  */
    break;

  case 1806:
#line 12183 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 21751 "parser.c" /* yacc.c:1646  */
    break;

  case 1807:
#line 12189 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 21761 "parser.c" /* yacc.c:1646  */
    break;

  case 1808:
#line 12196 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SAME phrase");
	/* may not be specified along with the UNDERLINED, BLINK, REVERSED,
	HIGH, LOW, STANDARD, COLOR, FOREGROUND-COLOR, or BACKGROUND-COLOR phrases */
  }
#line 21771 "parser.c" /* yacc.c:1646  */
    break;

  case 1809:
#line 12202 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("STANDARD intensity");
  }
#line 21779 "parser.c" /* yacc.c:1646  */
    break;

  case 1810:
#line 12206 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21787 "parser.c" /* yacc.c:1646  */
    break;

  case 1811:
#line 12210 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21795 "parser.c" /* yacc.c:1646  */
    break;

  case 1812:
#line 12214 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("BACKGROUND intensity");
  }
#line 21803 "parser.c" /* yacc.c:1646  */
    break;

  case 1813:
#line 12218 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 21812 "parser.c" /* yacc.c:1646  */
    break;

  case 1814:
#line 12223 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 21821 "parser.c" /* yacc.c:1646  */
    break;

  case 1815:
#line 12228 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_15, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, (yyvsp[0]), 0);
  }
#line 21830 "parser.c" /* yacc.c:1646  */
    break;

  case 1816:
#line 12233 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 21839 "parser.c" /* yacc.c:1646  */
    break;

  case 1817:
#line 12238 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	CB_PENDING ("COLOR");
  }
#line 21849 "parser.c" /* yacc.c:1646  */
    break;

  case 1818:
#line 12244 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	set_attribs ((yyvsp[0]), NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 21858 "parser.c" /* yacc.c:1646  */
    break;

  case 1819:
#line 12249 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	set_attribs (NULL, (yyvsp[0]), NULL, NULL, NULL, NULL, 0);
  }
#line 21867 "parser.c" /* yacc.c:1646  */
    break;

  case 1820:
#line 12254 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 21878 "parser.c" /* yacc.c:1646  */
    break;

  case 1821:
#line 12261 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_20, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 21889 "parser.c" /* yacc.c:1646  */
    break;

  case 1822:
#line 12271 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DISPLAY);
  }
#line 21897 "parser.c" /* yacc.c:1646  */
    break;

  case 1823:
#line 12275 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DISPLAY);
  }
#line 21905 "parser.c" /* yacc.c:1646  */
    break;

  case 1824:
#line 12285 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DIVIDE", TERM_DIVIDE);
  }
#line 21913 "parser.c" /* yacc.c:1646  */
    break;

  case 1826:
#line 12294 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '/', (yyvsp[-3]));
  }
#line 21921 "parser.c" /* yacc.c:1646  */
    break;

  case 1827:
#line 12298 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-3]), '/', (yyvsp[-5])));
  }
#line 21929 "parser.c" /* yacc.c:1646  */
    break;

  case 1828:
#line 12302 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-5]), '/', (yyvsp[-3])));
  }
#line 21937 "parser.c" /* yacc.c:1646  */
    break;

  case 1829:
#line 12306 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_divide ((yyvsp[-5]), (yyvsp[-7]), (yyvsp[-3]), (yyvsp[-1]));
  }
#line 21945 "parser.c" /* yacc.c:1646  */
    break;

  case 1830:
#line 12310 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_divide ((yyvsp[-7]), (yyvsp[-5]), (yyvsp[-3]), (yyvsp[-1]));
  }
#line 21953 "parser.c" /* yacc.c:1646  */
    break;

  case 1831:
#line 12317 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DIVIDE);
  }
#line 21961 "parser.c" /* yacc.c:1646  */
    break;

  case 1832:
#line 12321 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DIVIDE);
  }
#line 21969 "parser.c" /* yacc.c:1646  */
    break;

  case 1833:
#line 12331 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ENABLE", 0);
  }
#line 21977 "parser.c" /* yacc.c:1646  */
    break;

  case 1835:
#line 12342 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY", 0);
	backup_current_pos ();
  }
#line 21987 "parser.c" /* yacc.c:1646  */
    break;

  case 1837:
#line 12349 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY FOR GO TO", 0);
	backup_current_pos ();
  }
#line 21997 "parser.c" /* yacc.c:1646  */
    break;

  case 1839:
#line 12359 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "ENTRY");
	} else if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "ENTRY");
	} else if (cb_verify (cb_entry_statement, "ENTRY")) {
		cb_tree call_conv = (yyvsp[-3]);
		if ((yyvsp[-1])) {
			call_conv = (yyvsp[-1]);
			if ((yyvsp[-3])) {
				/* note: $1 is likely to be a reference to SPECIAL-NAMES */
				cb_error_x ((yyvsp[-1]), _("%s and %s are mutually exclusive"),
					"CALL-CONVENTION", "WITH LINKAGE");
			}
		}
		if (!cobc_check_valid_name ((char *)(CB_LITERAL ((yyvsp[-2]))->data), ENTRY_NAME)) {
			emit_entry ((char *)(CB_LITERAL ((yyvsp[-2]))->data), 1, (yyvsp[0]), call_conv);
		}
	}
  }
#line 22022 "parser.c" /* yacc.c:1646  */
    break;

  case 1840:
#line 12383 "parser.y" /* yacc.c:1646  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		emit_entry_goto ((char *)(CB_LITERAL ((yyvsp[0]))->data));
	}
  }
#line 22032 "parser.c" /* yacc.c:1646  */
    break;

  case 1841:
#line 12395 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("EVALUATE", TERM_EVALUATE);
	eval_level++;
	if (eval_level >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_level = 0;
		eval_inc = 0;
		eval_inc2 = 0;
		YYERROR;
	} else {
		for (eval_inc = 0; eval_inc < EVAL_DEPTH; ++eval_inc) {
			eval_check[eval_level][eval_inc] = NULL;
		}
		eval_inc = 0;
		eval_inc2 = 0;
	}
	cb_end_cond (cb_any);
	cb_save_cond ();
	cb_true_side ();
  }
#line 22058 "parser.c" /* yacc.c:1646  */
    break;

  case 1843:
#line 12422 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_evaluate ((yyvsp[-1]), (yyvsp[0]));
	eval_level--;
  }
#line 22067 "parser.c" /* yacc.c:1646  */
    break;

  case 1844:
#line 12429 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 22073 "parser.c" /* yacc.c:1646  */
    break;

  case 1845:
#line 12431 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 22079 "parser.c" /* yacc.c:1646  */
    break;

  case 1846:
#line 12436 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	eval_check[eval_level][eval_inc++] = (yyvsp[0]);
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22094 "parser.c" /* yacc.c:1646  */
    break;

  case 1847:
#line 12447 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_true;
	eval_check[eval_level][eval_inc++] = NULL;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22109 "parser.c" /* yacc.c:1646  */
    break;

  case 1848:
#line 12458 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_false;
	eval_check[eval_level][eval_inc++] = cb_false;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 22124 "parser.c" /* yacc.c:1646  */
    break;

  case 1849:
#line 12472 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
	} else {
		(yyval) = (yyvsp[-1]);
	}
  }
#line 22136 "parser.c" /* yacc.c:1646  */
    break;

  case 1850:
#line 12481 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 22144 "parser.c" /* yacc.c:1646  */
    break;

  case 1851:
#line 12487 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 22150 "parser.c" /* yacc.c:1646  */
    break;

  case 1852:
#line 12489 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 22156 "parser.c" /* yacc.c:1646  */
    break;

  case 1853:
#line 12495 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_CHAIN ((yyvsp[0]), (yyvsp[-1]));
	eval_inc2 = 0;
  }
#line 22165 "parser.c" /* yacc.c:1646  */
    break;

  case 1854:
#line 12500 "parser.y" /* yacc.c:1646  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	(yyval) = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), (yyvsp[-1]));
  }
#line 22179 "parser.c" /* yacc.c:1646  */
    break;

  case 1855:
#line 12510 "parser.y" /* yacc.c:1646  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	(yyval) = CB_BUILD_CHAIN (CB_LIST_INIT (cb_build_continue ()), (yyvsp[-1]));
  }
#line 22192 "parser.c" /* yacc.c:1646  */
    break;

  case 1856:
#line 12523 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_CHAIN ((yyvsp[0]), NULL);
	eval_inc2 = 0;
  }
#line 22201 "parser.c" /* yacc.c:1646  */
    break;

  case 1857:
#line 12528 "parser.y" /* yacc.c:1646  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Note: we don't clear the EVALUATE terminator here
	         as we'd have to skip this later
	         [side effect: possible warning about missing terminator] */
	(yyval) = NULL;
  }
#line 22215 "parser.c" /* yacc.c:1646  */
    break;

  case 1858:
#line 12538 "parser.y" /* yacc.c:1646  */
    {
	eval_inc2 = 0;
	cb_verify (cb_missing_statement,
		_("WHEN OTHER without imperative statement"));
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
	(yyval) = NULL;
  }
#line 22228 "parser.c" /* yacc.c:1646  */
    break;

  case 1859:
#line 12550 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
  }
#line 22236 "parser.c" /* yacc.c:1646  */
    break;

  case 1860:
#line 12554 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
	restore_backup_pos ((yyval));
	eval_inc2 = 0;
  }
#line 22246 "parser.c" /* yacc.c:1646  */
    break;

  case 1861:
#line 12561 "parser.y" /* yacc.c:1646  */
    {
	backup_current_pos ();
  }
#line 22254 "parser.c" /* yacc.c:1646  */
    break;

  case 1862:
#line 12565 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-3]), (yyvsp[0]));
	restore_backup_pos ((yyval));
	eval_inc2 = 0;
  }
#line 22264 "parser.c" /* yacc.c:1646  */
    break;

  case 1863:
#line 12573 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 22270 "parser.c" /* yacc.c:1646  */
    break;

  case 1864:
#line 12575 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 22276 "parser.c" /* yacc.c:1646  */
    break;

  case 1865:
#line 12580 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	not0;
	cb_tree	e1;
	cb_tree	e2;
	cb_tree	x;
	cb_tree	parm1;

	not0 = cb_int0;
	e2 = (yyvsp[0]);
	x = NULL;
	parm1 = (yyvsp[-1]);
	if (eval_check[eval_level][eval_inc2]
	 && eval_check[eval_level][eval_inc2] != cb_false) {
		/* Check if the first token is NOT */
		/* It may belong to the EVALUATE, however see */
		/* below when it may be part of a partial expression */
		if (CB_PURPOSE_INT (parm1) == '!') {
			/* Pop stack if subject not TRUE / FALSE */
			not0 = cb_int1;
			x = parm1;
			parm1 = CB_CHAIN (parm1);
		}
		/* Partial expression handling */
		switch (CB_PURPOSE_INT (parm1)) {
		/* Relational conditions */
		case '<':
		case '>':
		case '[':
		case ']':
		case '~':
		case '=':
		/* Class conditions */
		case '9':
		case 'A':
		case 'L':
		case 'U':
		case 'P':
		case 'N':
		case 'O':
		case 'C':
			if (e2) {
				cb_error_x (e2, _("invalid THROUGH usage"));
				e2 = NULL;
			}
			not0 = CB_PURPOSE (parm1);
			if (x) {
				/* Rebind the NOT to the partial expression */
				parm1 = cb_build_list (cb_int ('!'), NULL, parm1);
			}
			/* Insert subject at head of list */
			parm1 = cb_build_list (cb_int ('x'),
					    eval_check[eval_level][eval_inc2], parm1);
			break;
		}
	}

	/* Build expr now */
	e1 = cb_build_expr (parm1);

	eval_inc2++;
	(yyval) = CB_BUILD_PAIR (not0, CB_BUILD_PAIR (e1, e2));

	if (eval_check[eval_level][eval_inc2-1] == cb_false) {
		/* It was  EVALUATE FALSE; So flip condition */
		if (e1 == cb_true)
			e1 = cb_false;
		else if (e1 == cb_false)
			e1 = cb_true;
	}
	cb_terminate_cond ();
	cb_end_cond (e1);
	cb_save_cond ();
	cb_true_side ();
  }
#line 22355 "parser.c" /* yacc.c:1646  */
    break;

  case 1866:
#line 12654 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_any; eval_inc2++; }
#line 22361 "parser.c" /* yacc.c:1646  */
    break;

  case 1867:
#line 12655 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; eval_inc2++; }
#line 22367 "parser.c" /* yacc.c:1646  */
    break;

  case 1868:
#line 12656 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_false; eval_inc2++; }
#line 22373 "parser.c" /* yacc.c:1646  */
    break;

  case 1869:
#line 12657 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_error_node; eval_inc2++; }
#line 22379 "parser.c" /* yacc.c:1646  */
    break;

  case 1870:
#line 12661 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 22385 "parser.c" /* yacc.c:1646  */
    break;

  case 1871:
#line 12662 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 22391 "parser.c" /* yacc.c:1646  */
    break;

  case 1872:
#line 12667 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), EVALUATE);
  }
#line 22399 "parser.c" /* yacc.c:1646  */
    break;

  case 1873:
#line 12671 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), EVALUATE);
  }
#line 22407 "parser.c" /* yacc.c:1646  */
    break;

  case 1874:
#line 12681 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("EXIT", 0);
	cobc_cs_check = CB_CS_EXIT;
  }
#line 22416 "parser.c" /* yacc.c:1646  */
    break;

  case 1875:
#line 12686 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 22424 "parser.c" /* yacc.c:1646  */
    break;

  case 1876:
#line 12693 "parser.y" /* yacc.c:1646  */
    {
  /* TODO: add warning/error if there's another statement in the paragraph */
  }
#line 22432 "parser.c" /* yacc.c:1646  */
    break;

  case 1877:
#line 12697 "parser.y" /* yacc.c:1646  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_PROGRAM) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM not allowed within a FUNCTION"));
	}
	if (current_program->flag_main) {
		check_unreached = 0;
	} else {
		check_unreached = 1;
	}
	if ((yyvsp[0])) {
		if (!current_program->cb_return_code) {
			cb_error_x ((yyvsp[0]), _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move ((yyvsp[0]), CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	current_statement->name = (const char *)"EXIT PROGRAM";
	cb_emit_exit (0);
  }
#line 22461 "parser.c" /* yacc.c:1646  */
    break;

  case 1878:
#line 12722 "parser.y" /* yacc.c:1646  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != COB_MODULE_TYPE_FUNCTION) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION only allowed within a FUNCTION"));
	}
	check_unreached = 1;
	current_statement->name = (const char *)"EXIT FUNCTION";
	cb_emit_exit (0);
  }
#line 22479 "parser.c" /* yacc.c:1646  */
    break;

  case 1879:
#line 12736 "parser.y" /* yacc.c:1646  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->cycle_label) {
			sprintf (name, "EXIT PERFORM CYCLE %d", cb_id);
			p->cycle_label = cb_build_reference (name);
			plabel = cb_build_label (p->cycle_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM CYCLE";
		cb_emit_goto (CB_LIST_INIT (p->cycle_label), NULL);
		check_unreached = 1;
	}
  }
#line 22506 "parser.c" /* yacc.c:1646  */
    break;

  case 1880:
#line 12759 "parser.y" /* yacc.c:1646  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->exit_label) {
			sprintf (name, "EXIT PERFORM %d", cb_id);
			p->exit_label = cb_build_reference (name);
			plabel = cb_build_label (p->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM";
		cb_emit_goto (CB_LIST_INIT (p->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22533 "parser.c" /* yacc.c:1646  */
    break;

  case 1881:
#line 12782 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_section) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT SECTION is only valid with an active SECTION"));
	} else {
		if (!current_section->exit_label) {
			sprintf (name, "EXIT SECTION %d", cb_id);
			current_section->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_section->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT SECTION";
		cb_emit_goto (CB_LIST_INIT (current_section->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22558 "parser.c" /* yacc.c:1646  */
    break;

  case 1882:
#line 12803 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_paragraph) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PARAGRAPH is only valid with an active PARAGRAPH"));
	} else {
		if (!current_paragraph->exit_label) {
			sprintf (name, "EXIT PARAGRAPH %d", cb_id);
			current_paragraph->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_paragraph->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PARAGRAPH";
		cb_emit_goto (CB_LIST_INIT (current_paragraph->exit_label), NULL);
		check_unreached = 1;
	}
  }
#line 22583 "parser.c" /* yacc.c:1646  */
    break;

  case 1883:
#line 12826 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 22589 "parser.c" /* yacc.c:1646  */
    break;

  case 1884:
#line 12829 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 22595 "parser.c" /* yacc.c:1646  */
    break;

  case 1885:
#line 12837 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("FREE", 0);
	current_statement->flag_no_based = 1;
  }
#line 22604 "parser.c" /* yacc.c:1646  */
    break;

  case 1887:
#line 12846 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_free ((yyvsp[0]));
  }
#line 22612 "parser.c" /* yacc.c:1646  */
    break;

  case 1888:
#line 12856 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("GENERATE", 0);
  }
#line 22620 "parser.c" /* yacc.c:1646  */
    break;

  case 1890:
#line 12865 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
		cb_emit_generate ((yyvsp[0]));
	}
  }
#line 22631 "parser.c" /* yacc.c:1646  */
    break;

  case 1891:
#line 12877 "parser.y" /* yacc.c:1646  */
    {
	if (!current_paragraph->flag_statement) {
		current_paragraph->flag_first_is_goto = 1;
	}
	begin_statement ("GO TO", 0);
	save_debug = start_debug;
	start_debug = 0;
  }
#line 22644 "parser.c" /* yacc.c:1646  */
    break;

  case 1893:
#line 12890 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_goto ((yyvsp[-1]), (yyvsp[0]));
	start_debug = save_debug;
  }
#line 22653 "parser.c" /* yacc.c:1646  */
    break;

  case 1894:
#line 12895 "parser.y" /* yacc.c:1646  */
    {
	if (cb_verify (cb_goto_entry, "ENTRY FOR GO TO")) {
		cb_emit_goto_entry ((yyvsp[-1]), (yyvsp[0]));
	}
	start_debug = save_debug;
  }
#line 22664 "parser.c" /* yacc.c:1646  */
    break;

  case 1895:
#line 12905 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 1;
	(yyval) = NULL;
  }
#line 22673 "parser.c" /* yacc.c:1646  */
    break;

  case 1896:
#line 12910 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 0;
	(yyval) = (yyvsp[0]);
  }
#line 22682 "parser.c" /* yacc.c:1646  */
    break;

  case 1897:
#line 12921 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("GOBACK", 0);
	check_unreached = 1;
	if ((yyvsp[0])) {
		if (!current_program->cb_return_code) {
			cb_error_x ((yyvsp[0]), _("RETURNING/GIVING not allowed for non-returning runtime elements"));
		} else {
			cb_emit_move ((yyvsp[0]), CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	cb_emit_exit (1U);
  }
#line 22699 "parser.c" /* yacc.c:1646  */
    break;

  case 1898:
#line 12940 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("IF", TERM_IF);
  }
#line 22707 "parser.c" /* yacc.c:1646  */
    break;

  case 1900:
#line 12949 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (5)]), (yyvsp[-3]), (yyvsp[0]));
  }
#line 22715 "parser.c" /* yacc.c:1646  */
    break;

  case 1901:
#line 12953 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (3)]), NULL, (yyvsp[0]));
	cb_verify (cb_missing_statement,
		_("IF without imperative statement"));
  }
#line 22725 "parser.c" /* yacc.c:1646  */
    break;

  case 1902:
#line 12959 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (2)]), (yyvsp[0]), NULL);
  }
#line 22733 "parser.c" /* yacc.c:1646  */
    break;

  case 1903:
#line 12965 "parser.y" /* yacc.c:1646  */
    {
	cb_save_cond ();
  }
#line 22741 "parser.c" /* yacc.c:1646  */
    break;

  case 1904:
#line 12969 "parser.y" /* yacc.c:1646  */
    {
	cb_save_cond ();
  }
#line 22749 "parser.c" /* yacc.c:1646  */
    break;

  case 1905:
#line 12975 "parser.y" /* yacc.c:1646  */
    {
	cb_true_side ();
  }
#line 22757 "parser.c" /* yacc.c:1646  */
    break;

  case 1906:
#line 12981 "parser.y" /* yacc.c:1646  */
    {
	cb_false_side ();
  }
#line 22765 "parser.c" /* yacc.c:1646  */
    break;

  case 1907:
#line 12988 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-4) - (0)]), IF);
	cb_terminate_cond ();
  }
#line 22774 "parser.c" /* yacc.c:1646  */
    break;

  case 1908:
#line 12993 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-4) - (1)]), IF);
	cb_terminate_cond ();
  }
#line 22783 "parser.c" /* yacc.c:1646  */
    break;

  case 1909:
#line 13004 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INITIALIZE", 0);
  }
#line 22791 "parser.c" /* yacc.c:1646  */
    break;

  case 1911:
#line 13013 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_initialize ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 22799 "parser.c" /* yacc.c:1646  */
    break;

  case 1912:
#line 13019 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 22805 "parser.c" /* yacc.c:1646  */
    break;

  case 1913:
#line 13020 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; }
#line 22811 "parser.c" /* yacc.c:1646  */
    break;

  case 1914:
#line 13024 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 22817 "parser.c" /* yacc.c:1646  */
    break;

  case 1915:
#line 13025 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; }
#line 22823 "parser.c" /* yacc.c:1646  */
    break;

  case 1916:
#line 13026 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-2]); }
#line 22829 "parser.c" /* yacc.c:1646  */
    break;

  case 1917:
#line 13031 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 22837 "parser.c" /* yacc.c:1646  */
    break;

  case 1918:
#line 13035 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 22845 "parser.c" /* yacc.c:1646  */
    break;

  case 1919:
#line 13042 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 22853 "parser.c" /* yacc.c:1646  */
    break;

  case 1920:
#line 13047 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
  }
#line 22861 "parser.c" /* yacc.c:1646  */
    break;

  case 1921:
#line 13054 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-3]), (yyvsp[0]));
  }
#line 22869 "parser.c" /* yacc.c:1646  */
    break;

  case 1922:
#line 13060 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHABETIC); }
#line 22875 "parser.c" /* yacc.c:1646  */
    break;

  case 1923:
#line 13061 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHANUMERIC); }
#line 22881 "parser.c" /* yacc.c:1646  */
    break;

  case 1924:
#line 13062 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NUMERIC); }
#line 22887 "parser.c" /* yacc.c:1646  */
    break;

  case 1925:
#line 13063 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHANUMERIC_EDITED); }
#line 22893 "parser.c" /* yacc.c:1646  */
    break;

  case 1926:
#line 13064 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NUMERIC_EDITED); }
#line 22899 "parser.c" /* yacc.c:1646  */
    break;

  case 1927:
#line 13065 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NATIONAL); }
#line 22905 "parser.c" /* yacc.c:1646  */
    break;

  case 1928:
#line 13066 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NATIONAL_EDITED); }
#line 22911 "parser.c" /* yacc.c:1646  */
    break;

  case 1929:
#line 13078 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 22919 "parser.c" /* yacc.c:1646  */
    break;

  case 1930:
#line 13082 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_true;
  }
#line 22927 "parser.c" /* yacc.c:1646  */
    break;

  case 1931:
#line 13091 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INITIATE", 0);
  }
#line 22935 "parser.c" /* yacc.c:1646  */
    break;

  case 1933:
#line 13099 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
		cb_emit_initiate ((yyvsp[0]));
	}
  }
#line 22946 "parser.c" /* yacc.c:1646  */
    break;

  case 1934:
#line 13106 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
		cb_emit_initiate ((yyvsp[0]));
	}
  }
#line 22957 "parser.c" /* yacc.c:1646  */
    break;

  case 1935:
#line 13118 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INQUIRE", 0);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 22966 "parser.c" /* yacc.c:1646  */
    break;

  case 1936:
#line 13123 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 22974 "parser.c" /* yacc.c:1646  */
    break;

  case 1939:
#line 13137 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INSPECT", 0);
	inspect_keyword = 0;
  }
#line 22983 "parser.c" /* yacc.c:1646  */
    break;

  case 1949:
#line 13165 "parser.y" /* yacc.c:1646  */
    {
	previous_tallying_phrase = NO_PHRASE;
	cb_init_tallying ();
  }
#line 22992 "parser.c" /* yacc.c:1646  */
    break;

  case 1950:
#line 13170 "parser.y" /* yacc.c:1646  */
    {
	if (!(previous_tallying_phrase == CHARACTERS_PHRASE
	      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
		cb_error (_("TALLYING clause is incomplete"));
	} else {
		cb_emit_inspect ((yyvsp[-3]), (yyvsp[0]), TALLYING_CLAUSE);
	}

	(yyval) = (yyvsp[-3]);
  }
#line 23007 "parser.c" /* yacc.c:1646  */
    break;

  case 1951:
#line 13186 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_inspect ((yyvsp[-2]), (yyvsp[0]), REPLACING_CLAUSE);
	inspect_keyword = 0;
  }
#line 23016 "parser.c" /* yacc.c:1646  */
    break;

  case 1952:
#line 13196 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x = cb_build_converting ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
	cb_emit_inspect ((yyvsp[-5]), x, CONVERTING_CLAUSE);
  }
#line 23025 "parser.c" /* yacc.c:1646  */
    break;

  case 1953:
#line 13204 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 23033 "parser.c" /* yacc.c:1646  */
    break;

  case 1954:
#line 13208 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
  }
#line 23041 "parser.c" /* yacc.c:1646  */
    break;

  case 1955:
#line 13215 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (FOR_PHRASE);
	(yyval) = cb_build_tallying_data ((yyvsp[-1]));
  }
#line 23050 "parser.c" /* yacc.c:1646  */
    break;

  case 1956:
#line 13220 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (CHARACTERS_PHRASE);
	(yyval) = cb_build_tallying_characters ((yyvsp[0]));
  }
#line 23059 "parser.c" /* yacc.c:1646  */
    break;

  case 1957:
#line 13225 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_all ();
  }
#line 23068 "parser.c" /* yacc.c:1646  */
    break;

  case 1958:
#line 13230 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_leading ();
  }
#line 23077 "parser.c" /* yacc.c:1646  */
    break;

  case 1959:
#line 13235 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_trailing ();
  }
#line 23086 "parser.c" /* yacc.c:1646  */
    break;

  case 1960:
#line 13240 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (VALUE_REGION_PHRASE);
	(yyval) = cb_build_tallying_value ((yyvsp[-1]), (yyvsp[0]));
  }
#line 23095 "parser.c" /* yacc.c:1646  */
    break;

  case 1961:
#line 13247 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23101 "parser.c" /* yacc.c:1646  */
    break;

  case 1962:
#line 13248 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 23107 "parser.c" /* yacc.c:1646  */
    break;

  case 1963:
#line 13253 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_replacing_characters ((yyvsp[-1]), (yyvsp[0]));
	inspect_keyword = 0;
  }
#line 23116 "parser.c" /* yacc.c:1646  */
    break;

  case 1964:
#line 13258 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 23124 "parser.c" /* yacc.c:1646  */
    break;

  case 1966:
#line 13265 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 1; }
#line 23130 "parser.c" /* yacc.c:1646  */
    break;

  case 1967:
#line 13266 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 2; }
#line 23136 "parser.c" /* yacc.c:1646  */
    break;

  case 1968:
#line 13267 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 3; }
#line 23142 "parser.c" /* yacc.c:1646  */
    break;

  case 1969:
#line 13268 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 4; }
#line 23148 "parser.c" /* yacc.c:1646  */
    break;

  case 1970:
#line 13273 "parser.y" /* yacc.c:1646  */
    {
	switch (inspect_keyword) {
		case 1:
			(yyval) = cb_build_replacing_all ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 2:
			(yyval) = cb_build_replacing_leading ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 3:
			(yyval) = cb_build_replacing_first ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 4:
			(yyval) = cb_build_replacing_trailing ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		default:
			cb_error_x (CB_TREE (current_statement),
				    _("INSPECT missing ALL/FIRST/LEADING/TRAILING"));
			(yyval) = cb_build_replacing_all ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
	}
  }
#line 23174 "parser.c" /* yacc.c:1646  */
    break;

  case 1971:
#line 13300 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_inspect_region_start ();
  }
#line 23182 "parser.c" /* yacc.c:1646  */
    break;

  case 1972:
#line 13304 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_build_inspect_region_start (), (yyvsp[0]));
  }
#line 23190 "parser.c" /* yacc.c:1646  */
    break;

  case 1973:
#line 13308 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_build_inspect_region_start (), (yyvsp[0]));
  }
#line 23198 "parser.c" /* yacc.c:1646  */
    break;

  case 1974:
#line 13312 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_list_add (cb_build_inspect_region_start (), (yyvsp[-1])), (yyvsp[0]));
  }
#line 23206 "parser.c" /* yacc.c:1646  */
    break;

  case 1975:
#line 13316 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_list_add (cb_build_inspect_region_start (), (yyvsp[-1])), (yyvsp[0]));
  }
#line 23214 "parser.c" /* yacc.c:1646  */
    break;

  case 1976:
#line 13323 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_FUNCALL_1 ("cob_inspect_before", (yyvsp[0]));
  }
#line 23222 "parser.c" /* yacc.c:1646  */
    break;

  case 1977:
#line 13330 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_FUNCALL_1 ("cob_inspect_after", (yyvsp[0]));
  }
#line 23230 "parser.c" /* yacc.c:1646  */
    break;

  case 1978:
#line 13339 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("JSON GENERATE", TERM_JSON);
	cobc_in_json_generate_body = 1;
	cobc_cs_check = CB_CS_JSON_GENERATE;
  }
#line 23240 "parser.c" /* yacc.c:1646  */
    break;

  case 1980:
#line 13351 "parser.y" /* yacc.c:1646  */
    {
	ml_suppress_list = NULL;
  }
#line 23248 "parser.c" /* yacc.c:1646  */
    break;

  case 1981:
#line 13356 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_json_generate_body = 0;
	cobc_cs_check = 0;
  }
#line 23257 "parser.c" /* yacc.c:1646  */
    break;

  case 1982:
#line 13361 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_json_generate ((yyvsp[-8]), (yyvsp[-6]), (yyvsp[-5]), (yyvsp[-3]), ml_suppress_list);
  }
#line 23265 "parser.c" /* yacc.c:1646  */
    break;

  case 1983:
#line 13368 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 23273 "parser.c" /* yacc.c:1646  */
    break;

  case 1984:
#line 13372 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 23281 "parser.c" /* yacc.c:1646  */
    break;

  case 1987:
#line 13384 "parser.y" /* yacc.c:1646  */
    {
	error_if_following_every_clause ();
	add_identifier_to_ml_suppress_conds ((yyvsp[0]));
  }
#line 23290 "parser.c" /* yacc.c:1646  */
    break;

  case 1988:
#line 13392 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), JSON);
  }
#line 23298 "parser.c" /* yacc.c:1646  */
    break;

  case 1989:
#line 13396 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), JSON);
  }
#line 23306 "parser.c" /* yacc.c:1646  */
    break;

  case 1990:
#line 13405 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("JSON PARSE", TERM_JSON);
	CB_PENDING (_("JSON PARSE"));
  }
#line 23315 "parser.c" /* yacc.c:1646  */
    break;

  case 1995:
#line 13430 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MERGE", 0);
	current_statement->flag_merge = 1;
  }
#line 23324 "parser.c" /* yacc.c:1646  */
    break;

  case 1997:
#line 13442 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MODIFY", TERM_MODIFY);
	cobc_cs_check = CB_CS_INQUIRE_MODIFY;
  }
#line 23333 "parser.c" /* yacc.c:1646  */
    break;

  case 1998:
#line 13448 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 23341 "parser.c" /* yacc.c:1646  */
    break;

  case 2001:
#line 13460 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), MODIFY);
  }
#line 23349 "parser.c" /* yacc.c:1646  */
    break;

  case 2002:
#line 13464 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), MODIFY);
  }
#line 23357 "parser.c" /* yacc.c:1646  */
    break;

  case 2003:
#line 13474 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MOVE", 0);
  }
#line 23365 "parser.c" /* yacc.c:1646  */
    break;

  case 2005:
#line 13482 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move ((yyvsp[-2]), (yyvsp[0]));
  }
#line 23373 "parser.c" /* yacc.c:1646  */
    break;

  case 2006:
#line 13486 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move_corresponding ((yyvsp[-2]), (yyvsp[0]));
  }
#line 23381 "parser.c" /* yacc.c:1646  */
    break;

  case 2007:
#line 13496 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MULTIPLY", TERM_MULTIPLY);
  }
#line 23389 "parser.c" /* yacc.c:1646  */
    break;

  case 2009:
#line 13505 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '*', (yyvsp[-3]));
  }
#line 23397 "parser.c" /* yacc.c:1646  */
    break;

  case 2010:
#line 13509 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-5]), '*', (yyvsp[-3])));
  }
#line 23405 "parser.c" /* yacc.c:1646  */
    break;

  case 2011:
#line 13516 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), MULTIPLY);
  }
#line 23413 "parser.c" /* yacc.c:1646  */
    break;

  case 2012:
#line 13520 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), MULTIPLY);
  }
#line 23421 "parser.c" /* yacc.c:1646  */
    break;

  case 2013:
#line 13530 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("OPEN", 0);
	cobc_cs_check = CB_CS_OPEN;
  }
#line 23430 "parser.c" /* yacc.c:1646  */
    break;

  case 2017:
#line 13544 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;
	cb_tree x;
	cb_tree retry;
	int	retry_times, retry_seconds, retry_forever;

	if (((yyvsp[-5]) && (yyvsp[-3])) || ((yyvsp[-5]) && (yyvsp[0])) || ((yyvsp[-3]) && (yyvsp[0]))) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s and %s are mutually exclusive"), "SHARING", _("LOCK clauses"));
	}
	if ((yyvsp[0])) {
		x = (yyvsp[0]);
	} else if ((yyvsp[-3])) {
		x = (yyvsp[-3]);
	} else {
		x = (yyvsp[-5]);
	}
	retry = current_statement->retry;
	retry_times = current_statement->flag_retry_times;
	retry_seconds = current_statement->flag_retry_seconds;
	retry_forever = current_statement->flag_retry_forever;

	for (l = (yyvsp[-1]); l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			begin_implicit_statement ();
			current_statement->retry = retry;
			current_statement->flag_retry_times = retry_times;
			current_statement->flag_retry_seconds = retry_seconds;
			current_statement->flag_retry_forever = retry_forever;
			cb_emit_open (CB_VALUE (l), (yyvsp[-4]), x);
		}
	}
  }
#line 23468 "parser.c" /* yacc.c:1646  */
    break;

  case 2018:
#line 13581 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23474 "parser.c" /* yacc.c:1646  */
    break;

  case 2019:
#line 13582 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23480 "parser.c" /* yacc.c:1646  */
    break;

  case 2020:
#line 13586 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_INPUT); }
#line 23486 "parser.c" /* yacc.c:1646  */
    break;

  case 2021:
#line 13587 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_OUTPUT); }
#line 23492 "parser.c" /* yacc.c:1646  */
    break;

  case 2022:
#line 13588 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_I_O); }
#line 23498 "parser.c" /* yacc.c:1646  */
    break;

  case 2023:
#line 13589 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_EXTEND); }
#line 23504 "parser.c" /* yacc.c:1646  */
    break;

  case 2024:
#line 13593 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23510 "parser.c" /* yacc.c:1646  */
    break;

  case 2025:
#line 13594 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23516 "parser.c" /* yacc.c:1646  */
    break;

  case 2026:
#line 13598 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23522 "parser.c" /* yacc.c:1646  */
    break;

  case 2027:
#line 13599 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23528 "parser.c" /* yacc.c:1646  */
    break;

  case 2028:
#line 13600 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23534 "parser.c" /* yacc.c:1646  */
    break;

  case 2029:
#line 13604 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 23540 "parser.c" /* yacc.c:1646  */
    break;

  case 2030:
#line 13606 "parser.y" /* yacc.c:1646  */
    {
	  (void)cb_verify (CB_OBSOLETE, "OPEN LEAVE/REREAD/DISP");
	  (yyval) = NULL;
  }
#line 23549 "parser.c" /* yacc.c:1646  */
    break;

  case 2031:
#line 13613 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23555 "parser.c" /* yacc.c:1646  */
    break;

  case 2032:
#line 13614 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23561 "parser.c" /* yacc.c:1646  */
    break;

  case 2033:
#line 13618 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23567 "parser.c" /* yacc.c:1646  */
    break;

  case 2034:
#line 13620 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH MASS-UPDATE");
  }
#line 23577 "parser.c" /* yacc.c:1646  */
    break;

  case 2035:
#line 13626 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE);
	/* TODO: check for indexed; pass extra flag to fileio */
	CB_PENDING ("WITH BULK-ADDITION");
  }
#line 23587 "parser.c" /* yacc.c:1646  */
    break;

  case 2036:
#line 13634 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 23593 "parser.c" /* yacc.c:1646  */
    break;

  case 2037:
#line 13635 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23599 "parser.c" /* yacc.c:1646  */
    break;

  case 2038:
#line 13636 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23605 "parser.c" /* yacc.c:1646  */
    break;

  case 2042:
#line 13648 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: only allow for sequential files */
	/* FIXME: only allow with INPUT or OUTPUT */
	CB_PENDING ("OPEN WITH NO REWIND");
	(yyval) = NULL;
  }
#line 23616 "parser.c" /* yacc.c:1646  */
    break;

  case 2043:
#line 13655 "parser.y" /* yacc.c:1646  */
    {
	/* FIXME: only allow for sequential / line-sequential files */
	/* FIXME: only allow with INPUT */
	/* FIXME: add actual compiler configuration */
	if (cb_warn_obsolete == COBC_WARN_AS_ERROR) {
		(void)cb_verify (CB_OBSOLETE, "OPEN REVERSED");
	} else {
		/* FIXME: set file attribute */
		CB_PENDING ("OPEN REVERSED");
	};
	(yyval) = NULL;
  }
#line 23633 "parser.c" /* yacc.c:1646  */
    break;

  case 2047:
#line 13678 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("PERFORM", TERM_PERFORM);
	/* Turn off field debug - PERFORM is special */
	save_debug = start_debug;
	start_debug = 0;
	cobc_cs_check = CB_CS_PERFORM;
  }
#line 23645 "parser.c" /* yacc.c:1646  */
    break;

  case 2049:
#line 13693 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_perform ((yyvsp[0]), (yyvsp[-2]), (yyvsp[-3]), (yyvsp[-1]));
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23655 "parser.c" /* yacc.c:1646  */
    break;

  case 2050:
#line 13701 "parser.y" /* yacc.c:1646  */
    {
	CB_ADD_TO_CHAIN ((yyvsp[-1]), perform_stack);
	/* Restore field debug before inline statements */
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23666 "parser.c" /* yacc.c:1646  */
    break;

  case 2051:
#line 13708 "parser.y" /* yacc.c:1646  */
    {
	perform_stack = CB_CHAIN (perform_stack);
	cb_emit_perform ((yyvsp[-4]), (yyvsp[-1]), (yyvsp[-5]), (yyvsp[-3]));
  }
#line 23675 "parser.c" /* yacc.c:1646  */
    break;

  case 2052:
#line 13715 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_missing_statement,
		_("inline PERFORM without imperative statement"));
  }
#line 23684 "parser.c" /* yacc.c:1646  */
    break;

  case 2053:
#line 13720 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_perform ((yyvsp[-3]), NULL, (yyvsp[-4]), (yyvsp[-2]));
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 23694 "parser.c" /* yacc.c:1646  */
    break;

  case 2054:
#line 13729 "parser.y" /* yacc.c:1646  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING ((yyvsp[(-6) - (0)]), PERFORM);
	} else {
		TERMINATOR_ERROR ((yyvsp[(-6) - (0)]), PERFORM);
	}
  }
#line 23706 "parser.c" /* yacc.c:1646  */
    break;

  case 2055:
#line 13737 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-6) - (1)]), PERFORM);
  }
#line 23714 "parser.c" /* yacc.c:1646  */
    break;

  case 2056:
#line 13744 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-3) - (1)]), PERFORM);
  }
#line 23722 "parser.c" /* yacc.c:1646  */
    break;

  case 2057:
#line 13748 "parser.y" /* yacc.c:1646  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING ((yyvsp[(-3) - (1)]), PERFORM);
	} else {
		TERMINATOR_ERROR ((yyvsp[(-3) - (1)]), PERFORM);
	}
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
  }
#line 23736 "parser.c" /* yacc.c:1646  */
    break;

  case 2058:
#line 13761 "parser.y" /* yacc.c:1646  */
    {
	/* Return from $1 */
	CB_REFERENCE ((yyvsp[0]))->length = cb_true;
	CB_REFERENCE ((yyvsp[0]))->flag_decl_ok = 1;
	(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[0]));
  }
#line 23747 "parser.c" /* yacc.c:1646  */
    break;

  case 2059:
#line 13768 "parser.y" /* yacc.c:1646  */
    {
	/* Return from $3 */
	CB_REFERENCE ((yyvsp[0]))->length = cb_true;
	CB_REFERENCE ((yyvsp[-2]))->flag_decl_ok = 1;
	CB_REFERENCE ((yyvsp[0]))->flag_decl_ok = 1;
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 23759 "parser.c" /* yacc.c:1646  */
    break;

  case 2060:
#line 13779 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_once (NULL);
  }
#line 23767 "parser.c" /* yacc.c:1646  */
    break;

  case 2061:
#line 13783 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_times ((yyvsp[-1]));
	current_program->loop_counter++;
  }
#line 23776 "parser.c" /* yacc.c:1646  */
    break;

  case 2062:
#line 13788 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_forever (NULL);
  }
#line 23784 "parser.c" /* yacc.c:1646  */
    break;

  case 2063:
#line 13792 "parser.y" /* yacc.c:1646  */
    {
	cb_tree varying;

	if (!(yyvsp[0])) {
		(yyval) = cb_build_perform_forever (NULL);
	} else {
		if ((yyvsp[-2]) == CB_AFTER)
			cb_build_perform_after_until();
		varying = CB_LIST_INIT (cb_build_perform_varying (NULL, NULL, NULL, (yyvsp[0])));
		(yyval) = cb_build_perform_until ((yyvsp[-2]), varying);
	}
  }
#line 23801 "parser.c" /* yacc.c:1646  */
    break;

  case 2064:
#line 13805 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_until ((yyvsp[-2]), (yyvsp[0]));
  }
#line 23809 "parser.c" /* yacc.c:1646  */
    break;

  case 2065:
#line 13811 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BEFORE; }
#line 23815 "parser.c" /* yacc.c:1646  */
    break;

  case 2066:
#line 13812 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23821 "parser.c" /* yacc.c:1646  */
    break;

  case 2067:
#line 13816 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 23827 "parser.c" /* yacc.c:1646  */
    break;

  case 2068:
#line 13817 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 23833 "parser.c" /* yacc.c:1646  */
    break;

  case 2069:
#line 13820 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 23839 "parser.c" /* yacc.c:1646  */
    break;

  case 2070:
#line 13822 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 23845 "parser.c" /* yacc.c:1646  */
    break;

  case 2071:
#line 13827 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;
	int		data_type_ok = 1;

	if ((yyvsp[-5]) != cb_error_node
	 && (yyvsp[-3]) != cb_error_node
	 && (yyvsp[-2]) != cb_error_node) {

		if (cb_tree_category ((yyvsp[-5])) != CB_CATEGORY_NUMERIC) {
			x = cb_ref ((yyvsp[-5]));
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			(yyval) = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category ((yyvsp[-3])) != CB_CATEGORY_NUMERIC) {
			x = cb_ref ((yyvsp[-3]));
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			(yyval) = cb_int1;
			data_type_ok = 0;
		}
		if (cb_tree_category ((yyvsp[-2])) != CB_CATEGORY_NUMERIC) {
			x = cb_ref ((yyvsp[-2]));
			cb_error_x (CB_TREE (current_statement),
				_("PERFORM VARYING '%s' (line %d of %s) is not a numeric field"),
				cb_name (x),x->source_line, x->source_file);
			(yyval) = cb_int1;
			data_type_ok = 0;
		}

		if (data_type_ok) {
			(yyval) = cb_build_perform_varying ((yyvsp[-5]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[0]));
		}
	}
  }
#line 23888 "parser.c" /* yacc.c:1646  */
    break;

  case 2072:
#line 13869 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_perform_varying_without_by, _("PERFORM VARYING without BY phrase"));
	(yyval) = cb_build_numeric_literal (0, "1", 0);
  }
#line 23897 "parser.c" /* yacc.c:1646  */
    break;

  case 2073:
#line 13874 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 23905 "parser.c" /* yacc.c:1646  */
    break;

  case 2074:
#line 13883 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("PURGE", 0);
  }
#line 23913 "parser.c" /* yacc.c:1646  */
    break;

  case 2075:
#line 13887 "parser.y" /* yacc.c:1646  */
    {
  }
#line 23920 "parser.c" /* yacc.c:1646  */
    break;

  case 2076:
#line 13895 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RAISE", 0);
  }
#line 23928 "parser.c" /* yacc.c:1646  */
    break;

  case 2078:
#line 13903 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("RAISE statement");
	/* TODO: check for level 3 error here */
  }
#line 23937 "parser.c" /* yacc.c:1646  */
    break;

  case 2079:
#line 13908 "parser.y" /* yacc.c:1646  */
    {
	/* easy cheating here as we don't have any OO in */
	cb_error(_("'%s' is not an object-reference"), cb_name ((yyvsp[0])));
  }
#line 23946 "parser.c" /* yacc.c:1646  */
    break;

  case 2080:
#line 13918 "parser.y" /* yacc.c:1646  */
    {
	/* TODO:
	cb_tree exception = get_exception (CB_NAME($1));
	if (!exception) {
		cb_error (_("'%s' is not an exception-name"), CB_NAME ($1));
	}
	*/
  }
#line 23959 "parser.c" /* yacc.c:1646  */
    break;

  case 2081:
#line 13932 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("READ", TERM_READ);
	cobc_cs_check = CB_CS_READ;
  }
#line 23968 "parser.c" /* yacc.c:1646  */
    break;

  case 2083:
#line 13942 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;

	if (CB_VALID_TREE ((yyvsp[-6]))) {
		struct cb_file	*cf;

		cf = CB_FILE(cb_ref ((yyvsp[-6])));
		if ((yyvsp[-2]) && (cf->lock_mode & COB_LOCK_AUTOMATIC)) {
			cb_error_x (CB_TREE (current_statement),
				    _("LOCK clause invalid with file LOCK AUTOMATIC"));
		} else if ((yyvsp[-1]) &&
		      (cf->organization != COB_ORG_RELATIVE &&
		       cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("KEY clause invalid with this file type"));
		} else if (current_statement->handler_type == INVALID_KEY_HANDLER &&
			   (cf->organization != COB_ORG_RELATIVE &&
			    cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("INVALID KEY clause invalid with this file type"));
		} else {
			cb_emit_read ((yyvsp[-6]), (yyvsp[-5]), (yyvsp[-3]), (yyvsp[-1]), (yyvsp[-2]));
		}
	}
  }
#line 23998 "parser.c" /* yacc.c:1646  */
    break;

  case 2084:
#line 13970 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 24004 "parser.c" /* yacc.c:1646  */
    break;

  case 2085:
#line 13971 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 24010 "parser.c" /* yacc.c:1646  */
    break;

  case 2086:
#line 13976 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 24018 "parser.c" /* yacc.c:1646  */
    break;

  case 2087:
#line 13980 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int3;
  }
#line 24026 "parser.c" /* yacc.c:1646  */
    break;

  case 2088:
#line 13984 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 24034 "parser.c" /* yacc.c:1646  */
    break;

  case 2089:
#line 13988 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 24042 "parser.c" /* yacc.c:1646  */
    break;

  case 2090:
#line 13995 "parser.y" /* yacc.c:1646  */
    {
	current_statement->flag_ignore_lock = 1;
  }
#line 24050 "parser.c" /* yacc.c:1646  */
    break;

  case 2091:
#line 13999 "parser.y" /* yacc.c:1646  */
    {
	current_statement->flag_ignore_lock = 1;
  }
#line 24058 "parser.c" /* yacc.c:1646  */
    break;

  case 2092:
#line 14006 "parser.y" /* yacc.c:1646  */
    {
	current_statement->flag_advancing_lock = 1;
  }
#line 24066 "parser.c" /* yacc.c:1646  */
    break;

  case 2096:
#line 14019 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 24074 "parser.c" /* yacc.c:1646  */
    break;

  case 2097:
#line 14027 "parser.y" /* yacc.c:1646  */
    {
	current_statement->retry = (yyvsp[-1]);
	current_statement->flag_retry_times = 1;
  }
#line 24083 "parser.c" /* yacc.c:1646  */
    break;

  case 2098:
#line 14032 "parser.y" /* yacc.c:1646  */
    {
	current_statement->retry = (yyvsp[-1]);
	current_statement->flag_retry_seconds = 1;
  }
#line 24092 "parser.c" /* yacc.c:1646  */
    break;

  case 2099:
#line 14037 "parser.y" /* yacc.c:1646  */
    {
	current_statement->retry = NULL;
	current_statement->flag_retry_forever = 1;
  }
#line 24101 "parser.c" /* yacc.c:1646  */
    break;

  case 2102:
#line 14050 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 24109 "parser.c" /* yacc.c:1646  */
    break;

  case 2103:
#line 14054 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int5;
  }
#line 24117 "parser.c" /* yacc.c:1646  */
    break;

  case 2104:
#line 14058 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int4;
  }
#line 24125 "parser.c" /* yacc.c:1646  */
    break;

  case 2105:
#line 14064 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 24131 "parser.c" /* yacc.c:1646  */
    break;

  case 2106:
#line 14065 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 24137 "parser.c" /* yacc.c:1646  */
    break;

  case 2109:
#line 14075 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), READ);
  }
#line 24145 "parser.c" /* yacc.c:1646  */
    break;

  case 2110:
#line 14079 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), READ);
  }
#line 24153 "parser.c" /* yacc.c:1646  */
    break;

  case 2111:
#line 14089 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("READY TRACE", 0);
	cb_emit_ready_trace ();
  }
#line 24162 "parser.c" /* yacc.c:1646  */
    break;

  case 2112:
#line 14099 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RECEIVE", TERM_RECEIVE);
  }
#line 24170 "parser.c" /* yacc.c:1646  */
    break;

  case 2126:
#line 14142 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), RECEIVE);
  }
#line 24178 "parser.c" /* yacc.c:1646  */
    break;

  case 2127:
#line 14146 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), RECEIVE);
  }
#line 24186 "parser.c" /* yacc.c:1646  */
    break;

  case 2128:
#line 14155 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RELEASE", 0);
  }
#line 24194 "parser.c" /* yacc.c:1646  */
    break;

  case 2130:
#line 14163 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_release ((yyvsp[-1]), (yyvsp[0]));
  }
#line 24202 "parser.c" /* yacc.c:1646  */
    break;

  case 2131:
#line 14173 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RESET TRACE", 0);
	cb_emit_reset_trace ();
  }
#line 24211 "parser.c" /* yacc.c:1646  */
    break;

  case 2132:
#line 14183 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RETURN", TERM_RETURN);
  }
#line 24219 "parser.c" /* yacc.c:1646  */
    break;

  case 2134:
#line 14192 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_return ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 24227 "parser.c" /* yacc.c:1646  */
    break;

  case 2135:
#line 14199 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), RETURN);
  }
#line 24235 "parser.c" /* yacc.c:1646  */
    break;

  case 2136:
#line 14203 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), RETURN);
  }
#line 24243 "parser.c" /* yacc.c:1646  */
    break;

  case 2137:
#line 14213 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("REWRITE", TERM_REWRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 24254 "parser.c" /* yacc.c:1646  */
    break;

  case 2139:
#line 14225 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_rewrite ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]));
	start_debug = save_debug;
  }
#line 24263 "parser.c" /* yacc.c:1646  */
    break;

  case 2140:
#line 14233 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 24271 "parser.c" /* yacc.c:1646  */
    break;

  case 2142:
#line 14241 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 24279 "parser.c" /* yacc.c:1646  */
    break;

  case 2143:
#line 14245 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int2;
  }
#line 24287 "parser.c" /* yacc.c:1646  */
    break;

  case 2144:
#line 14252 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), REWRITE);
  }
#line 24295 "parser.c" /* yacc.c:1646  */
    break;

  case 2145:
#line 14256 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), REWRITE);
  }
#line 24303 "parser.c" /* yacc.c:1646  */
    break;

  case 2146:
#line 14266 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ROLLBACK", 0);
	cb_emit_rollback ();
  }
#line 24312 "parser.c" /* yacc.c:1646  */
    break;

  case 2147:
#line 14277 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SEARCH", TERM_SEARCH);
  }
#line 24320 "parser.c" /* yacc.c:1646  */
    break;

  case 2149:
#line 14286 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_search ((yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 24328 "parser.c" /* yacc.c:1646  */
    break;

  case 2150:
#line 14291 "parser.y" /* yacc.c:1646  */
    {
	current_statement->name = (const char *)"SEARCH ALL";
	cb_emit_search_all ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 24337 "parser.c" /* yacc.c:1646  */
    break;

  case 2151:
#line 14298 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 24343 "parser.c" /* yacc.c:1646  */
    break;

  case 2152:
#line 14299 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 24349 "parser.c" /* yacc.c:1646  */
    break;

  case 2153:
#line 14304 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 24357 "parser.c" /* yacc.c:1646  */
    break;

  case 2154:
#line 14309 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 24365 "parser.c" /* yacc.c:1646  */
    break;

  case 2155:
#line 14316 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 24373 "parser.c" /* yacc.c:1646  */
    break;

  case 2156:
#line 14320 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[0]), (yyvsp[-1]));
  }
#line 24381 "parser.c" /* yacc.c:1646  */
    break;

  case 2157:
#line 14328 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_if_check_break ((yyvsp[-1]), (yyvsp[0]));
  }
#line 24389 "parser.c" /* yacc.c:1646  */
    break;

  case 2158:
#line 14335 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), SEARCH);
  }
#line 24397 "parser.c" /* yacc.c:1646  */
    break;

  case 2159:
#line 14339 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), SEARCH);
  }
#line 24405 "parser.c" /* yacc.c:1646  */
    break;

  case 2160:
#line 14349 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SEND", 0);
  }
#line 24413 "parser.c" /* yacc.c:1646  */
    break;

  case 2162:
#line 14357 "parser.y" /* yacc.c:1646  */
    {
  }
#line 24420 "parser.c" /* yacc.c:1646  */
    break;

  case 2163:
#line 14360 "parser.y" /* yacc.c:1646  */
    {
  }
#line 24427 "parser.c" /* yacc.c:1646  */
    break;

  case 2166:
#line 14371 "parser.y" /* yacc.c:1646  */
    {
  }
#line 24434 "parser.c" /* yacc.c:1646  */
    break;

  case 2173:
#line 14391 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SET", 0);
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	cobc_cs_check = CB_CS_SET;
  }
#line 24445 "parser.c" /* yacc.c:1646  */
    break;

  case 2174:
#line 14398 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 24453 "parser.c" /* yacc.c:1646  */
    break;

  case 2183:
#line 14415 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 24459 "parser.c" /* yacc.c:1646  */
    break;

  case 2184:
#line 14416 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 24465 "parser.c" /* yacc.c:1646  */
    break;

  case 2185:
#line 14420 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 24471 "parser.c" /* yacc.c:1646  */
    break;

  case 2186:
#line 14421 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 24477 "parser.c" /* yacc.c:1646  */
    break;

  case 2187:
#line 14428 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_setenv ((yyvsp[-2]), (yyvsp[0]));
  }
#line 24485 "parser.c" /* yacc.c:1646  */
    break;

  case 2188:
#line 14437 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_attribute ((yyvsp[-2]), set_attr_val_on, set_attr_val_off);
  }
#line 24493 "parser.c" /* yacc.c:1646  */
    break;

  case 2191:
#line 14449 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_BELL);
  }
#line 24501 "parser.c" /* yacc.c:1646  */
    break;

  case 2192:
#line 14453 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_BLINK);
  }
#line 24509 "parser.c" /* yacc.c:1646  */
    break;

  case 2193:
#line 14457 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_HIGHLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_HIGHLIGHT);
  }
#line 24519 "parser.c" /* yacc.c:1646  */
    break;

  case 2194:
#line 14463 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_LOWLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_LOWLIGHT);
  }
#line 24529 "parser.c" /* yacc.c:1646  */
    break;

  case 2195:
#line 14469 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_REVERSE);
  }
#line 24537 "parser.c" /* yacc.c:1646  */
    break;

  case 2196:
#line 14473 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_UNDERLINE);
  }
#line 24545 "parser.c" /* yacc.c:1646  */
    break;

  case 2197:
#line 14477 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_LEFTLINE);
  }
#line 24553 "parser.c" /* yacc.c:1646  */
    break;

  case 2198:
#line 14481 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_OVERLINE);
  }
#line 24561 "parser.c" /* yacc.c:1646  */
    break;

  case 2199:
#line 14490 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to ((yyvsp[-3]), cb_build_ppointer ((yyvsp[0])));
  }
#line 24569 "parser.c" /* yacc.c:1646  */
    break;

  case 2200:
#line 14494 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to_fcd ((yyvsp[-6]), (yyvsp[0]));
  }
#line 24577 "parser.c" /* yacc.c:1646  */
    break;

  case 2201:
#line 14498 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to_fcdkey ((yyvsp[-6]), (yyvsp[0]));
  }
#line 24585 "parser.c" /* yacc.c:1646  */
    break;

  case 2202:
#line 14502 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to ((yyvsp[-2]), (yyvsp[0]));
  }
#line 24593 "parser.c" /* yacc.c:1646  */
    break;

  case 2203:
#line 14506 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move (cb_build_length ((yyvsp[0])), (yyvsp[-4]));
  }
#line 24601 "parser.c" /* yacc.c:1646  */
    break;

  case 2204:
#line 14515 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_up_down ((yyvsp[-3]), (yyvsp[-2]), (yyvsp[0]));
  }
#line 24609 "parser.c" /* yacc.c:1646  */
    break;

  case 2207:
#line 14529 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_on_off ((yyvsp[-2]), (yyvsp[0]));
  }
#line 24617 "parser.c" /* yacc.c:1646  */
    break;

  case 2210:
#line 14543 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_true ((yyvsp[-2]));
  }
#line 24625 "parser.c" /* yacc.c:1646  */
    break;

  case 2211:
#line 14547 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_false ((yyvsp[-2]));
  }
#line 24633 "parser.c" /* yacc.c:1646  */
    break;

  case 2212:
#line 14556 "parser.y" /* yacc.c:1646  */
    {
	  cb_emit_set_last_exception_to_off ();
  }
#line 24641 "parser.c" /* yacc.c:1646  */
    break;

  case 2213:
#line 14565 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_thread_priority ((yyvsp[-3]), (yyvsp[0]));
	CB_PENDING ("THREAD");
  }
#line 24650 "parser.c" /* yacc.c:1646  */
    break;

  case 2214:
#line 14576 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SORT", 0);
  }
#line 24658 "parser.c" /* yacc.c:1646  */
    break;

  case 2216:
#line 14584 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x = cb_ref ((yyvsp[-3]));

	(yyval) = NULL;
	if (CB_VALID_TREE (x)) {
		if ((yyvsp[-2]) == NULL || CB_VALUE((yyvsp[-2])) == NULL) {
			if (CB_FILE_P (x)) {
				cb_error (_("file sort requires KEY phrase"));
				(yyvsp[-2]) = cb_error_node;
			} else {
				struct cb_field	*f = CB_FIELD_PTR (x);
/* TODO: add compiler configuration cb_sort_without_keys
				if (f->nkeys
				 && cb_verify (cb_sort_without_keys, _("table SORT without keys"))) {
*/
				if ((yyvsp[-2]) != NULL || f->nkeys) {
					cb_tree lparm;
					if ((yyvsp[-2]) == NULL) {
						/* create reference to first key */
						x = cb_ref (f->keys[0].key);
					}
					/* use the OCCURS field / its defined KEY as single sort key */
					lparm = cb_list_add (NULL, x);
					/* search order is either specified, otherwise derived from definition */
					if ((yyvsp[-2]) != NULL) {
						CB_PURPOSE (lparm) = CB_PURPOSE ((yyvsp[-2]));
					} else {
						CB_PURPOSE (lparm) = cb_int (f->keys[0].dir);
					}
					(yyvsp[-2]) = cb_list_append (NULL, lparm);
				} else {
					cb_error (_("table SORT requires KEY phrase"));
					(yyvsp[-2]) = cb_error_node;
				}
			}
		}
		if (CB_VALID_TREE ((yyvsp[-2]))) {
			cb_emit_sort_init ((yyvsp[-3]), (yyvsp[-2]), alphanumeric_collation, national_collation);
			(yyval) = (yyvsp[-3]);
		}
	}
  }
#line 24705 "parser.c" /* yacc.c:1646  */
    break;

  case 2217:
#line 14627 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2]) && CB_VALID_TREE ((yyvsp[-6]))) {
		cb_emit_sort_finish ((yyvsp[-6]));
	}
  }
#line 24715 "parser.c" /* yacc.c:1646  */
    break;

  case 2218:
#line 14635 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 24721 "parser.c" /* yacc.c:1646  */
    break;

  case 2219:
#line 14638 "parser.y" /* yacc.c:1646  */
    {
	cb_tree lparm = (yyvsp[0]);
	cb_tree l;

	if (lparm == NULL) {
		lparm = CB_LIST_INIT (NULL);
	}
	for (l = lparm; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = (yyvsp[-2]);
	}
	(yyval) = cb_list_append ((yyvsp[-4]), lparm);
  }
#line 24738 "parser.c" /* yacc.c:1646  */
    break;

  case 2220:
#line 14653 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 24744 "parser.c" /* yacc.c:1646  */
    break;

  case 2221:
#line 14654 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 24750 "parser.c" /* yacc.c:1646  */
    break;

  case 2223:
#line 14659 "parser.y" /* yacc.c:1646  */
    {
	/* The GnuCOBOL sort is a stable sort. ie. dups are per default in order */
	/* Therefore nothing to do here */
  }
#line 24759 "parser.c" /* yacc.c:1646  */
    break;

  case 2224:
#line 14667 "parser.y" /* yacc.c:1646  */
    {
	alphanumeric_collation = national_collation = NULL;
  }
#line 24767 "parser.c" /* yacc.c:1646  */
    break;

  case 2226:
#line 14675 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) && CB_FILE_P (cb_ref ((yyvsp[0])))) {
		cb_error (_("file sort requires USING or INPUT PROCEDURE"));
	}
  }
#line 24777 "parser.c" /* yacc.c:1646  */
    break;

  case 2227:
#line 14681 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[-2])))) {
			cb_error (_("USING invalid with table SORT"));
		} else {
			cb_emit_sort_using ((yyvsp[-2]), (yyvsp[0]));
		}
	}
  }
#line 24791 "parser.c" /* yacc.c:1646  */
    break;

  case 2228:
#line 14691 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-4])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[-4])))) {
			cb_error (_("INPUT PROCEDURE invalid with table SORT"));
		} else if (current_statement->flag_merge) {
			cb_error (_("INPUT PROCEDURE invalid with MERGE"));
		} else {
			cb_emit_sort_input ((yyvsp[0]));
		}
	}
	cobc_cs_check = 0;
  }
#line 24808 "parser.c" /* yacc.c:1646  */
    break;

  case 2229:
#line 14707 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (0)]) && CB_FILE_P (cb_ref ((yyvsp[(-1) - (0)])))) {
		cb_error (_("file sort requires GIVING or OUTPUT PROCEDURE"));
	}
  }
#line 24818 "parser.c" /* yacc.c:1646  */
    break;

  case 2230:
#line 14713 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (2)])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[(-1) - (2)])))) {
			cb_error (_("GIVING invalid with table SORT"));
		} else {
			cb_emit_sort_giving ((yyvsp[(-1) - (2)]), (yyvsp[0]));
		}
	}
  }
#line 24832 "parser.c" /* yacc.c:1646  */
    break;

  case 2231:
#line 14723 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (4)])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[(-1) - (4)])))) {
			cb_error (_("OUTPUT PROCEDURE invalid with table SORT"));
		} else {
			cb_emit_sort_output ((yyvsp[0]));
		}
	}
	cobc_cs_check = 0;
  }
#line 24847 "parser.c" /* yacc.c:1646  */
    break;

  case 2232:
#line 14740 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("START", TERM_START);
	start_tree = cb_int (COB_EQ);
  }
#line 24856 "parser.c" /* yacc.c:1646  */
    break;

  case 2234:
#line 14750 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1]) && !(yyvsp[-2])) {
		cb_error_x (CB_TREE (current_statement),
			    _("SIZE/LENGTH invalid here"));
	} else {
		cb_emit_start ((yyvsp[-3]), start_tree, (yyvsp[-2]), (yyvsp[-1]));
	}
  }
#line 24869 "parser.c" /* yacc.c:1646  */
    break;

  case 2235:
#line 14762 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 24877 "parser.c" /* yacc.c:1646  */
    break;

  case 2236:
#line 14766 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 24885 "parser.c" /* yacc.c:1646  */
    break;

  case 2237:
#line 14773 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 24893 "parser.c" /* yacc.c:1646  */
    break;

  case 2238:
#line 14777 "parser.y" /* yacc.c:1646  */
    {
	start_tree = (yyvsp[-1]);
	(yyval) = (yyvsp[0]);
  }
#line 24902 "parser.c" /* yacc.c:1646  */
    break;

  case 2239:
#line 14782 "parser.y" /* yacc.c:1646  */
    {
	start_tree = cb_int (COB_FI);
	(yyval) = NULL;
  }
#line 24911 "parser.c" /* yacc.c:1646  */
    break;

  case 2240:
#line 14787 "parser.y" /* yacc.c:1646  */
    {
	start_tree = cb_int (COB_LA);
	(yyval) = NULL;
  }
#line 24920 "parser.c" /* yacc.c:1646  */
    break;

  case 2241:
#line 14794 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_EQ); }
#line 24926 "parser.c" /* yacc.c:1646  */
    break;

  case 2242:
#line 14795 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_LE : COB_GT); }
#line 24932 "parser.c" /* yacc.c:1646  */
    break;

  case 2243:
#line 14796 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_GE : COB_LT); }
#line 24938 "parser.c" /* yacc.c:1646  */
    break;

  case 2244:
#line 14797 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_LT : COB_GE); }
#line 24944 "parser.c" /* yacc.c:1646  */
    break;

  case 2245:
#line 14798 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_GT : COB_LE); }
#line 24950 "parser.c" /* yacc.c:1646  */
    break;

  case 2246:
#line 14799 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_NE); }
#line 24956 "parser.c" /* yacc.c:1646  */
    break;

  case 2247:
#line 14804 "parser.y" /* yacc.c:1646  */
    {
	cb_error_x (CB_TREE (current_statement),
		    _("NOT EQUAL condition not allowed on START statement"));
  }
#line 24965 "parser.c" /* yacc.c:1646  */
    break;

  case 2250:
#line 14817 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), START);
  }
#line 24973 "parser.c" /* yacc.c:1646  */
    break;

  case 2251:
#line 14821 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), START);
  }
#line 24981 "parser.c" /* yacc.c:1646  */
    break;

  case 2255:
#line 14839 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("TRANSACTION");
  }
#line 24989 "parser.c" /* yacc.c:1646  */
    break;

  case 2256:
#line 14849 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP RUN", 0);
	cobc_cs_check = CB_CS_STOP;
  }
#line 24998 "parser.c" /* yacc.c:1646  */
    break;

  case 2257:
#line 14854 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_stop_run ((yyvsp[0]));
	check_unreached = 1;
	cobc_cs_check = 0;
  }
#line 25008 "parser.c" /* yacc.c:1646  */
    break;

  case 2258:
#line 14860 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP", 0);
	cb_emit_display (CB_LIST_INIT ((yyvsp[0])), cb_int0, cb_int1, NULL,
			 NULL, 1, DEVICE_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
	cobc_cs_check = 0;
  }
#line 25020 "parser.c" /* yacc.c:1646  */
    break;

  case 2259:
#line 14868 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP THREAD", 0);
	cb_emit_stop_thread ((yyvsp[0]));
	cobc_cs_check = 0;
	cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]), _("%s is replaced by %s"), "STOP THREAD", "STOP RUN");
  }
#line 25031 "parser.c" /* yacc.c:1646  */
    break;

  case 2260:
#line 14878 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->cb_return_code) {
		(yyval) = current_program->cb_return_code;
	} else {
		(yyval) = cb_int0;
	}
  }
#line 25043 "parser.c" /* yacc.c:1646  */
    break;

  case 2261:
#line 14886 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 25051 "parser.c" /* yacc.c:1646  */
    break;

  case 2262:
#line 14890 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 25059 "parser.c" /* yacc.c:1646  */
    break;

  case 2263:
#line 14894 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = (yyvsp[0]);
	} else {
		(yyval) = cb_int1;
	}
  }
#line 25071 "parser.c" /* yacc.c:1646  */
    break;

  case 2264:
#line 14902 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = (yyvsp[0]);
	} else {
		(yyval) = cb_int0;
	}
  }
#line 25083 "parser.c" /* yacc.c:1646  */
    break;

  case 2265:
#line 14913 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 25091 "parser.c" /* yacc.c:1646  */
    break;

  case 2266:
#line 14917 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 25099 "parser.c" /* yacc.c:1646  */
    break;

  case 2267:
#line 14924 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_stop_literal_statement, _("STOP literal"));
  }
#line 25107 "parser.c" /* yacc.c:1646  */
    break;

  case 2268:
#line 14928 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_stop_identifier_statement, _("STOP identifier"));
  }
#line 25115 "parser.c" /* yacc.c:1646  */
    break;

  case 2269:
#line 14934 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25121 "parser.c" /* yacc.c:1646  */
    break;

  case 2270:
#line 14935 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 25127 "parser.c" /* yacc.c:1646  */
    break;

  case 2271:
#line 14936 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 25133 "parser.c" /* yacc.c:1646  */
    break;

  case 2272:
#line 14937 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 25139 "parser.c" /* yacc.c:1646  */
    break;

  case 2273:
#line 14944 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STRING", TERM_STRING);
  }
#line 25147 "parser.c" /* yacc.c:1646  */
    break;

  case 2275:
#line 14953 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_string ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 25155 "parser.c" /* yacc.c:1646  */
    break;

  case 2276:
#line 14959 "parser.y" /* yacc.c:1646  */
    {
	save_tree = NULL;
  }
#line 25163 "parser.c" /* yacc.c:1646  */
    break;

  case 2277:
#line 14963 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = save_tree;
  }
#line 25171 "parser.c" /* yacc.c:1646  */
    break;

  case 2280:
#line 14975 "parser.y" /* yacc.c:1646  */
    {
	if (!save_tree) {
		save_tree = CB_LIST_INIT ((yyvsp[-1]));
	} else {
		save_tree = cb_list_add (save_tree, (yyvsp[-1]));
	}
	if ((yyvsp[0])) {
		save_tree = cb_list_add (save_tree, (yyvsp[0]));
	}
  }
#line 25186 "parser.c" /* yacc.c:1646  */
    break;

  case 2281:
#line 14988 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25192 "parser.c" /* yacc.c:1646  */
    break;

  case 2282:
#line 14990 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25198 "parser.c" /* yacc.c:1646  */
    break;

  case 2283:
#line 14994 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR (cb_int0, NULL); }
#line 25204 "parser.c" /* yacc.c:1646  */
    break;

  case 2284:
#line 14995 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR ((yyvsp[0]), NULL); }
#line 25210 "parser.c" /* yacc.c:1646  */
    break;

  case 2285:
#line 14999 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25216 "parser.c" /* yacc.c:1646  */
    break;

  case 2286:
#line 15000 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25222 "parser.c" /* yacc.c:1646  */
    break;

  case 2287:
#line 15005 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), STRING);
  }
#line 25230 "parser.c" /* yacc.c:1646  */
    break;

  case 2288:
#line 15009 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), STRING);
  }
#line 25238 "parser.c" /* yacc.c:1646  */
    break;

  case 2289:
#line 15019 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SUBTRACT", TERM_SUBTRACT);
  }
#line 25246 "parser.c" /* yacc.c:1646  */
    break;

  case 2291:
#line 15028 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '-', cb_build_binary_list ((yyvsp[-3]), '+'));
  }
#line 25254 "parser.c" /* yacc.c:1646  */
    break;

  case 2292:
#line 15032 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_list (CB_BUILD_CHAIN ((yyvsp[-3]), (yyvsp[-5])), '-'));
  }
#line 25262 "parser.c" /* yacc.c:1646  */
    break;

  case 2293:
#line 15036 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_corresponding (cb_build_sub, (yyvsp[-2]), (yyvsp[-4]), (yyvsp[-1]));
  }
#line 25270 "parser.c" /* yacc.c:1646  */
    break;

  case 2294:
#line 15040 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SUBTRACT TABLE");
	cb_emit_tab_arithmetic (cb_build_sub, (yyvsp[-4]), (yyvsp[-6]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 25279 "parser.c" /* yacc.c:1646  */
    break;

  case 2295:
#line 15048 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), SUBTRACT);
  }
#line 25287 "parser.c" /* yacc.c:1646  */
    break;

  case 2296:
#line 15052 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), SUBTRACT);
  }
#line 25295 "parser.c" /* yacc.c:1646  */
    break;

  case 2297:
#line 15062 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SUPPRESS", 0);
	if (!in_declaratives) {
		cb_error_x (CB_TREE (current_statement),
			    _("SUPPRESS statement must be within DECLARATIVES"));
	}
	cb_emit_suppress (control_field);
  }
#line 25308 "parser.c" /* yacc.c:1646  */
    break;

  case 2300:
#line 15080 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("TERMINATE", 0);
  }
#line 25316 "parser.c" /* yacc.c:1646  */
    break;

  case 2302:
#line 15088 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
	    cb_emit_terminate ((yyvsp[0]));
	}
  }
#line 25327 "parser.c" /* yacc.c:1646  */
    break;

  case 2303:
#line 15095 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
		cb_emit_terminate ((yyvsp[0]));
	}
  }
#line 25338 "parser.c" /* yacc.c:1646  */
    break;

  case 2304:
#line 15107 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("TRANSFORM", 0);
  }
#line 25346 "parser.c" /* yacc.c:1646  */
    break;

  case 2306:
#line 15115 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	x = cb_build_converting ((yyvsp[-2]), (yyvsp[0]), cb_build_inspect_region_start ());
	cb_emit_inspect ((yyvsp[-4]), x, TRANSFORM_STATEMENT);
  }
#line 25357 "parser.c" /* yacc.c:1646  */
    break;

  case 2307:
#line 15128 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("UNLOCK", 0);
  }
#line 25365 "parser.c" /* yacc.c:1646  */
    break;

  case 2309:
#line 15136 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[-1]))) {
		if (CB_FILE (cb_ref ((yyvsp[-1])))->organization == COB_ORG_SORT) {
			cb_error_x (CB_TREE (current_statement),
				    _("UNLOCK invalid for SORT files"));
		} else {
			cb_emit_unlock ((yyvsp[-1]));
		}
	}
  }
#line 25380 "parser.c" /* yacc.c:1646  */
    break;

  case 2310:
#line 15152 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("UNSTRING", TERM_UNSTRING);
  }
#line 25388 "parser.c" /* yacc.c:1646  */
    break;

  case 2312:
#line 15163 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_unstring ((yyvsp[-5]), (yyvsp[-4]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 25396 "parser.c" /* yacc.c:1646  */
    break;

  case 2313:
#line 15169 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25402 "parser.c" /* yacc.c:1646  */
    break;

  case 2314:
#line 15171 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25408 "parser.c" /* yacc.c:1646  */
    break;

  case 2315:
#line 15175 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 25414 "parser.c" /* yacc.c:1646  */
    break;

  case 2316:
#line 15177 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 25420 "parser.c" /* yacc.c:1646  */
    break;

  case 2317:
#line 15182 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_unstring_delimited ((yyvsp[-1]), (yyvsp[0]));
  }
#line 25428 "parser.c" /* yacc.c:1646  */
    break;

  case 2318:
#line 15188 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 25434 "parser.c" /* yacc.c:1646  */
    break;

  case 2319:
#line 15190 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 25440 "parser.c" /* yacc.c:1646  */
    break;

  case 2320:
#line 15195 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_unstring_into ((yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 25448 "parser.c" /* yacc.c:1646  */
    break;

  case 2321:
#line 15201 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25454 "parser.c" /* yacc.c:1646  */
    break;

  case 2322:
#line 15202 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25460 "parser.c" /* yacc.c:1646  */
    break;

  case 2323:
#line 15206 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25466 "parser.c" /* yacc.c:1646  */
    break;

  case 2324:
#line 15207 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25472 "parser.c" /* yacc.c:1646  */
    break;

  case 2325:
#line 15212 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), UNSTRING);
  }
#line 25480 "parser.c" /* yacc.c:1646  */
    break;

  case 2326:
#line 15216 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), UNSTRING);
  }
#line 25488 "parser.c" /* yacc.c:1646  */
    break;

  case 2327:
#line 15225 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("VALIDATE", 0);
  }
#line 25496 "parser.c" /* yacc.c:1646  */
    break;

  case 2328:
#line 15229 "parser.y" /* yacc.c:1646  */
    {
#if 0	/* FIXME: at least add syntax checks here */
	cb_emit_validate ((yyvsp[0]));
#else
	CB_PENDING ("VALIDATE");
#endif
  }
#line 25508 "parser.c" /* yacc.c:1646  */
    break;

  case 2329:
#line 15240 "parser.y" /* yacc.c:1646  */
    {
	check_validate_item ((yyvsp[0]));
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 25517 "parser.c" /* yacc.c:1646  */
    break;

  case 2330:
#line 15245 "parser.y" /* yacc.c:1646  */
    {
	check_validate_item ((yyvsp[0]));
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 25526 "parser.c" /* yacc.c:1646  */
    break;

  case 2331:
#line 15256 "parser.y" /* yacc.c:1646  */
    {
	skip_statements = 0;
	in_debugging = 0;
  }
#line 25535 "parser.c" /* yacc.c:1646  */
    break;

  case 2338:
#line 15274 "parser.y" /* yacc.c:1646  */
    {
	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (!current_section) {
		cb_error (_("SECTION header missing before USE statement"));
	} else {
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 1;
		current_section->flag_skip_label = 0;
		CB_EXCEPTION_ENABLE (COB_EC_I_O) = 1;
		if (use_global_ind) {
			current_section->flag_global = 1;
			current_program->global_list =
				cb_list_add (current_program->global_list,
					     CB_TREE (current_section));
		}
		emit_statement (cb_build_comment ("USE AFTER ERROR"));
	}
  }
#line 25561 "parser.c" /* yacc.c:1646  */
    break;

  case 2339:
#line 15299 "parser.y" /* yacc.c:1646  */
    {
	use_global_ind = 0;
  }
#line 25569 "parser.c" /* yacc.c:1646  */
    break;

  case 2340:
#line 15303 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		use_global_ind = 1;
		current_program->flag_global_use = 1;
	}
  }
#line 25582 "parser.c" /* yacc.c:1646  */
    break;

  case 2341:
#line 15315 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;

	for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			setup_use_file (CB_FILE (cb_ref (CB_VALUE (l))));
		}
	}
  }
#line 25596 "parser.c" /* yacc.c:1646  */
    break;

  case 2342:
#line 15325 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_INPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_INPUT].handler_prog = current_program;
  }
#line 25605 "parser.c" /* yacc.c:1646  */
    break;

  case 2343:
#line 15330 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_OUTPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_OUTPUT].handler_prog = current_program;
  }
#line 25614 "parser.c" /* yacc.c:1646  */
    break;

  case 2344:
#line 15335 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_I_O].handler_label = current_section;
	current_program->global_handler[COB_OPEN_I_O].handler_prog = current_program;
  }
#line 25623 "parser.c" /* yacc.c:1646  */
    break;

  case 2345:
#line 15340 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_EXTEND].handler_label = current_section;
	current_program->global_handler[COB_OPEN_EXTEND].handler_prog = current_program;
  }
#line 25632 "parser.c" /* yacc.c:1646  */
    break;

  case 2346:
#line 15348 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		plabel;
	char		name[64];

	cb_verify (cb_use_for_debugging, "USE FOR DEBUGGING");

	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (current_program->nested_level) {
		cb_error (_("USE DEBUGGING not supported in contained program"));
	} else {
		in_debugging = 1;
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 0;
		current_section->flag_is_debug_sect = 1;
		if (!needs_debug_item) {
			needs_debug_item = 1;
			cb_build_debug_item ();
		}
		if (!current_program->flag_debugging) {
			skip_statements = 1;
			current_section->flag_skip_label = 1;
		} else {
			current_program->flag_gen_debug = 1;
			sprintf (name, "EXIT SECTION %d", cb_id);
			plabel = cb_build_reference (name);
			plabel = cb_build_label (plabel, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
			current_section->exit_label = plabel;
			emit_statement (cb_build_comment ("USE FOR DEBUGGING"));
		}
	}
  }
#line 25673 "parser.c" /* yacc.c:1646  */
    break;

  case 2349:
#line 15393 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_debugging) {

		cb_tree		z = CB_LIST_INIT ((yyvsp[0]));
		current_program->debug_list =
			cb_list_append (current_program->debug_list, z);
		/* Check backward refs to file/data names */
		if (CB_WORD_COUNT ((yyvsp[0])) > 0) {
			cb_tree		l = CB_VALUE (CB_WORD_ITEMS ((yyvsp[0])));
			switch (CB_TREE_TAG (l)) {
			case CB_TAG_CD:
				if (CB_CD (l)->flag_field_debug) {
					cb_error_x ((yyvsp[0]), _("duplicate DEBUGGING target: '%s'"),
					    cb_name (l));
				} else {
					CB_CD (l)->debug_section = current_section;
					CB_CD (l)->flag_field_debug = 1;
				}
				break;
			case CB_TAG_FILE:
				if (CB_FILE (l)->flag_fl_debug) {
					cb_error_x ((yyvsp[0]), _("duplicate DEBUGGING target: '%s'"),
					    cb_name (l));
				} else {
					CB_FILE (l)->debug_section = current_section;
					CB_FILE (l)->flag_fl_debug = 1;
				}
				break;
			case CB_TAG_FIELD:
				{
					struct cb_field* fld;
					cb_tree		x = cb_ref ((yyvsp[0]));
					if (!x || !CB_FIELD_P (x)) {
						break;
					}
					fld = CB_FIELD (x);
					if (fld->flag_item_78) {
						cb_error_x ((yyvsp[0]), _("constant item cannot be used here"));
					} else if (fld->flag_field_debug) {
						cb_error_x ((yyvsp[0]), _("duplicate DEBUGGING target: '%s'"),
							cb_name (x));
					} else {
						needs_field_debug = 1;
						fld->debug_section = current_section;
						fld->flag_field_debug = 1;
						CB_PURPOSE (z) = x;
					}
				}
				break;
			default:
				/* Label refs will be checked later (forward/backward ref) */
				break;
			}
		}
		CB_REFERENCE ((yyvsp[0]))->debug_section = current_section;
		CB_REFERENCE ((yyvsp[0]))->flag_debug_code = 1;
		CB_REFERENCE ((yyvsp[0]))->flag_all_debug = 0;
	}
  }
#line 25737 "parser.c" /* yacc.c:1646  */
    break;

  case 2350:
#line 15453 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_debugging) {
		if (current_program->all_procedure) {
			cb_error (_("duplicate USE DEBUGGING ON ALL PROCEDURES"));
		} else {
			current_program->all_procedure = current_section;
		}
	}
  }
#line 25751 "parser.c" /* yacc.c:1646  */
    break;

  case 2351:
#line 15463 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_debugging && (yyvsp[0]) != cb_error_node) {
		cb_tree x = cb_ref ((yyvsp[0]));
		struct cb_field *fld = CB_FIELD (x);
		if (fld->flag_field_debug) {
			cb_error_x ((yyvsp[0]), _("duplicate DEBUGGING target: '%s'"),
				cb_name (x));
		} else {
			struct cb_reference *r = CB_REFERENCE ((yyvsp[0]));
			needs_field_debug = 1;
			fld->debug_section = current_section;
			fld->flag_field_debug = 1;
			fld->flag_all_debug = 1;
			r->debug_section = current_section;
			r->flag_debug_code = 1;
			r->flag_all_debug = 1;
			CB_CHAIN_PAIR (current_program->debug_list, x, (yyvsp[0]));
		}
	}
  }
#line 25776 "parser.c" /* yacc.c:1646  */
    break;

  case 2356:
#line 15493 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "USE AT");
	}
  }
#line 25786 "parser.c" /* yacc.c:1646  */
    break;

  case 2357:
#line 15502 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM START"));
	backup_current_pos ();
	CB_PENDING ("USE AT PROGRAM START");
	/* emit_entry ("_AT_START", 0, NULL, NULL); */
  }
#line 25797 "parser.c" /* yacc.c:1646  */
    break;

  case 2358:
#line 15509 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM END"));
	backup_current_pos ();
	CB_PENDING ("USE AT PROGRAM END");
	/* emit_entry ("_AT_END", 0, NULL, NULL); */
  }
#line 25808 "parser.c" /* yacc.c:1646  */
    break;

  case 2359:
#line 15520 "parser.y" /* yacc.c:1646  */
    {
	char *wrk;
	cb_tree x;
	struct cb_field		*f;
	struct cb_report	*r;

	x = cb_ref ((yyvsp[0]));
	if (!CB_FIELD_P (x)) {
		cb_error_x ((yyvsp[0]), _("'%s' is not a report group"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	} else {
		control_field = f = CB_FIELD (x);
		f->report_decl_id = current_section->id;
		if ((r = f->report) != NULL) {
			r->has_declarative = 1;
		}
	}
	wrk = cobc_main_malloc (COB_MINI_BUFF);
	snprintf (wrk, COB_MINI_MAX, "USE BEFORE REPORTING %s is %s%d",
		cb_name ((yyvsp[0])), CB_PREFIX_LABEL, current_section->id);
	current_section->flag_real_label = 1;
	current_section->flag_declaratives = 1;
	current_section->flag_begin = 1;
	current_section->flag_return = 1;
	current_section->flag_declarative_exit = 1;
	current_section->flag_real_label = 1;
	current_section->flag_skip_label = 0;
	emit_statement (cb_build_comment (wrk));
  }
#line 25842 "parser.c" /* yacc.c:1646  */
    break;

  case 2362:
#line 15558 "parser.y" /* yacc.c:1646  */
    {
	current_section->flag_real_label = 1;
	emit_statement (cb_build_comment ("USE AFTER EXCEPTION CONDITION"));
	CB_PENDING ("USE AFTER EXCEPTION CONDITION");
  }
#line 25852 "parser.c" /* yacc.c:1646  */
    break;

  case 2363:
#line 15564 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;

	for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			setup_use_file (CB_FILE (cb_ref (CB_VALUE (l))));
		}
	}
	current_section->flag_real_label = 1;
	emit_statement(cb_build_comment("USE AFTER EXCEPTION CONDITION"));
	CB_PENDING("USE AFTER EXCEPTION CONDITION");
  }
#line 25869 "parser.c" /* yacc.c:1646  */
    break;

  case 2366:
#line 15587 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("WRITE", TERM_WRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 25880 "parser.c" /* yacc.c:1646  */
    break;

  case 2368:
#line 15599 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[-5]))) {
		cb_emit_write ((yyvsp[-5]), (yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]));
	}
	start_debug = save_debug;
  }
#line 25891 "parser.c" /* yacc.c:1646  */
    break;

  case 2369:
#line 15608 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 25897 "parser.c" /* yacc.c:1646  */
    break;

  case 2370:
#line 15609 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 25903 "parser.c" /* yacc.c:1646  */
    break;

  case 2371:
#line 15614 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 25911 "parser.c" /* yacc.c:1646  */
    break;

  case 2372:
#line 15618 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_lines ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 25919 "parser.c" /* yacc.c:1646  */
    break;

  case 2373:
#line 15622 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_mnemonic ((yyvsp[-2]), (yyvsp[0]));
  }
#line 25927 "parser.c" /* yacc.c:1646  */
    break;

  case 2374:
#line 15626 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_page ((yyvsp[-2]));
  }
#line 25935 "parser.c" /* yacc.c:1646  */
    break;

  case 2375:
#line 15632 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BEFORE; }
#line 25941 "parser.c" /* yacc.c:1646  */
    break;

  case 2376:
#line 15633 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_AFTER; }
#line 25947 "parser.c" /* yacc.c:1646  */
    break;

  case 2380:
#line 15644 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), WRITE);
  }
#line 25955 "parser.c" /* yacc.c:1646  */
    break;

  case 2381:
#line 15648 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), WRITE);
  }
#line 25963 "parser.c" /* yacc.c:1646  */
    break;

  case 2382:
#line 15657 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("XML GENERATE", TERM_XML);
	cobc_in_xml_generate_body = 1;
	cobc_cs_check = CB_CS_XML_GENERATE;
  }
#line 25973 "parser.c" /* yacc.c:1646  */
    break;

  case 2384:
#line 15669 "parser.y" /* yacc.c:1646  */
    {
	xml_encoding = NULL;
	with_xml_dec = 0;
	with_attrs = 0;
	ml_suppress_list = NULL;
  }
#line 25984 "parser.c" /* yacc.c:1646  */
    break;

  case 2385:
#line 15680 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_xml_generate_body = 0;
	cobc_cs_check = 0;
  }
#line 25993 "parser.c" /* yacc.c:1646  */
    break;

  case 2386:
#line 15685 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_xml_generate ((yyvsp[-11]), (yyvsp[-9]), (yyvsp[-8]), xml_encoding, with_xml_dec,
			      with_attrs, (yyvsp[-5]), (yyvsp[-4]), (yyvsp[-3]), ml_suppress_list);
  }
#line 26002 "parser.c" /* yacc.c:1646  */
    break;

  case 2392:
#line 15707 "parser.y" /* yacc.c:1646  */
    {
	xml_encoding = (yyvsp[0]);
	if (with_xml_dec) {
		cb_error (_("ENCODING clause must come before XML-DECLARATION"));
	} else if (with_attrs) {
		cb_error (_("ENCODING clause must come before ATTRIBUTES"));
	}
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE ENCODING clause"));
	CB_PENDING ("XML GENERATE ENCODING");
  }
#line 26018 "parser.c" /* yacc.c:1646  */
    break;

  case 2393:
#line 15719 "parser.y" /* yacc.c:1646  */
    {
	with_xml_dec = 1;
	if (with_attrs) {
		cb_error (_("XML-DECLARATION clause must come before ATTRIBUTES"));
	}
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE XML-DECLARATION clause"));
  }
#line 26031 "parser.c" /* yacc.c:1646  */
    break;

  case 2394:
#line 15728 "parser.y" /* yacc.c:1646  */
    {
	with_attrs = 1;
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE WITH ATTRIBUTES clause"));
  }
#line 26041 "parser.c" /* yacc.c:1646  */
    break;

  case 2395:
#line 15737 "parser.y" /* yacc.c:1646  */
    {
	 (yyval) = NULL;
  }
#line 26049 "parser.c" /* yacc.c:1646  */
    break;

  case 2396:
#line 15741 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-1]), (yyvsp[0]));
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE NAMESPACE clause"));
  }
#line 26059 "parser.c" /* yacc.c:1646  */
    break;

  case 2397:
#line 15750 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 26067 "parser.c" /* yacc.c:1646  */
    break;

  case 2398:
#line 15754 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 26075 "parser.c" /* yacc.c:1646  */
    break;

  case 2399:
#line 15761 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26083 "parser.c" /* yacc.c:1646  */
    break;

  case 2400:
#line 15765 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE NAME OF clause"));
  }
#line 26093 "parser.c" /* yacc.c:1646  */
    break;

  case 2401:
#line 15774 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 26101 "parser.c" /* yacc.c:1646  */
    break;

  case 2402:
#line 15778 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 26109 "parser.c" /* yacc.c:1646  */
    break;

  case 2403:
#line 15785 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 26117 "parser.c" /* yacc.c:1646  */
    break;

  case 2404:
#line 15792 "parser.y" /* yacc.c:1646  */
    {
       (yyval) = NULL;
  }
#line 26125 "parser.c" /* yacc.c:1646  */
    break;

  case 2405:
#line 15796 "parser.y" /* yacc.c:1646  */
    {
       (yyval) = (yyvsp[0]);
       	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE TYPE OF clause"));
  }
#line 26135 "parser.c" /* yacc.c:1646  */
    break;

  case 2406:
#line 15805 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 26143 "parser.c" /* yacc.c:1646  */
    break;

  case 2407:
#line 15809 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 26151 "parser.c" /* yacc.c:1646  */
    break;

  case 2408:
#line 15816 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 26159 "parser.c" /* yacc.c:1646  */
    break;

  case 2409:
#line 15823 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int) CB_ML_ANY_TYPE);
  }
#line 26167 "parser.c" /* yacc.c:1646  */
    break;

  case 2411:
#line 15830 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((int) CB_ML_ATTRIBUTE); }
#line 26173 "parser.c" /* yacc.c:1646  */
    break;

  case 2412:
#line 15831 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((int) CB_ML_ELEMENT); }
#line 26179 "parser.c" /* yacc.c:1646  */
    break;

  case 2413:
#line 15832 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((int) CB_ML_CONTENT); }
#line 26185 "parser.c" /* yacc.c:1646  */
    break;

  case 2415:
#line 15838 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_xml_generate_extra_phrases,
		   _("XML GENERATE SUPPRESS clause"));
  }
#line 26194 "parser.c" /* yacc.c:1646  */
    break;

  case 2418:
#line 15851 "parser.y" /* yacc.c:1646  */
    {
	error_if_following_every_clause ();
	add_identifier_to_ml_suppress_conds ((yyvsp[0]));
  }
#line 26203 "parser.c" /* yacc.c:1646  */
    break;

  case 2419:
#line 15856 "parser.y" /* yacc.c:1646  */
    {
	error_if_following_every_clause ();
	add_type_to_ml_suppress_conds (ml_suppress_category, (enum cb_ml_type) CB_INTEGER ((yyvsp[0]))->val);
  }
#line 26212 "parser.c" /* yacc.c:1646  */
    break;

  case 2420:
#line 15861 "parser.y" /* yacc.c:1646  */
    {
	add_when_to_ml_suppress_conds ((yyvsp[0]));
  }
#line 26220 "parser.c" /* yacc.c:1646  */
    break;

  case 2421:
#line 15868 "parser.y" /* yacc.c:1646  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_NUMERIC;
	(yyval) = (yyvsp[0]);
  }
#line 26229 "parser.c" /* yacc.c:1646  */
    break;

  case 2422:
#line 15873 "parser.y" /* yacc.c:1646  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_NONNUMERIC;
	(yyval) = (yyvsp[0]);
  }
#line 26238 "parser.c" /* yacc.c:1646  */
    break;

  case 2423:
#line 15878 "parser.y" /* yacc.c:1646  */
    {
	ml_suppress_category = CB_ML_SUPPRESS_CAT_ANY;
	(yyval) = (yyvsp[0]);
  }
#line 26247 "parser.c" /* yacc.c:1646  */
    break;

  case 2424:
#line 15886 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 26255 "parser.c" /* yacc.c:1646  */
    break;

  case 2425:
#line 15890 "parser.y" /* yacc.c:1646  */
    {
       (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0]));
  }
#line 26263 "parser.c" /* yacc.c:1646  */
    break;

  case 2426:
#line 15897 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), XML);
  }
#line 26271 "parser.c" /* yacc.c:1646  */
    break;

  case 2427:
#line 15901 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), XML);
  }
#line 26279 "parser.c" /* yacc.c:1646  */
    break;

  case 2428:
#line 15911 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("XML PARSE", TERM_XML);
	/* TO-DO: Add xml-parse and xml-parse-extra-phrases config options. */
	CB_PENDING (_("XML PARSE"));
	cobc_cs_check = CB_CS_XML_PARSE;
  }
#line 26290 "parser.c" /* yacc.c:1646  */
    break;

  case 2430:
#line 15927 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 26298 "parser.c" /* yacc.c:1646  */
    break;

  case 2439:
#line 15951 "parser.y" /* yacc.c:1646  */
    {
	if (CB_FILE_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a file name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 26311 "parser.c" /* yacc.c:1646  */
    break;

  case 2442:
#line 15969 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26322 "parser.c" /* yacc.c:1646  */
    break;

  case 2443:
#line 15979 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26330 "parser.c" /* yacc.c:1646  */
    break;

  case 2444:
#line 15983 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26338 "parser.c" /* yacc.c:1646  */
    break;

  case 2445:
#line 15990 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26347 "parser.c" /* yacc.c:1646  */
    break;

  case 2450:
#line 16008 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26356 "parser.c" /* yacc.c:1646  */
    break;

  case 2455:
#line 16024 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26367 "parser.c" /* yacc.c:1646  */
    break;

  case 2456:
#line 16034 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26375 "parser.c" /* yacc.c:1646  */
    break;

  case 2457:
#line 16038 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26383 "parser.c" /* yacc.c:1646  */
    break;

  case 2458:
#line 16045 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26392 "parser.c" /* yacc.c:1646  */
    break;

  case 2461:
#line 16058 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26401 "parser.c" /* yacc.c:1646  */
    break;

  case 2464:
#line 16068 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			   _("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26412 "parser.c" /* yacc.c:1646  */
    break;

  case 2465:
#line 16078 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26420 "parser.c" /* yacc.c:1646  */
    break;

  case 2466:
#line 16082 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26428 "parser.c" /* yacc.c:1646  */
    break;

  case 2467:
#line 16089 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = XML_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26437 "parser.c" /* yacc.c:1646  */
    break;

  case 2470:
#line 16102 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = XML_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26446 "parser.c" /* yacc.c:1646  */
    break;

  case 2473:
#line 16112 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			   _("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 26457 "parser.c" /* yacc.c:1646  */
    break;

  case 2474:
#line 16122 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26465 "parser.c" /* yacc.c:1646  */
    break;

  case 2475:
#line 16126 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26473 "parser.c" /* yacc.c:1646  */
    break;

  case 2476:
#line 16133 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = JSON_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26482 "parser.c" /* yacc.c:1646  */
    break;

  case 2479:
#line 16146 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = JSON_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26491 "parser.c" /* yacc.c:1646  */
    break;

  case 2482:
#line 16158 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT SIZE ERROR before SIZE ERROR"));
	}
  }
#line 26502 "parser.c" /* yacc.c:1646  */
    break;

  case 2483:
#line 16168 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26510 "parser.c" /* yacc.c:1646  */
    break;

  case 2484:
#line 16172 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26518 "parser.c" /* yacc.c:1646  */
    break;

  case 2485:
#line 16179 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26527 "parser.c" /* yacc.c:1646  */
    break;

  case 2488:
#line 16192 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26536 "parser.c" /* yacc.c:1646  */
    break;

  case 2491:
#line 16204 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT OVERFLOW before OVERFLOW"));
	}
  }
#line 26547 "parser.c" /* yacc.c:1646  */
    break;

  case 2492:
#line 16214 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26555 "parser.c" /* yacc.c:1646  */
    break;

  case 2493:
#line 16218 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26563 "parser.c" /* yacc.c:1646  */
    break;

  case 2494:
#line 16225 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26572 "parser.c" /* yacc.c:1646  */
    break;

  case 2497:
#line 16238 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26581 "parser.c" /* yacc.c:1646  */
    break;

  case 2499:
#line 16250 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
  }
#line 26589 "parser.c" /* yacc.c:1646  */
    break;

  case 2501:
#line 16259 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
	}
  }
#line 26599 "parser.c" /* yacc.c:1646  */
    break;

  case 2502:
#line 16268 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26607 "parser.c" /* yacc.c:1646  */
    break;

  case 2503:
#line 16272 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26615 "parser.c" /* yacc.c:1646  */
    break;

  case 2504:
#line 16279 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26624 "parser.c" /* yacc.c:1646  */
    break;

  case 2507:
#line 16292 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26633 "parser.c" /* yacc.c:1646  */
    break;

  case 2509:
#line 16303 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT AT END-OF-PAGE before AT END-OF-PAGE"));
	}
  }
#line 26644 "parser.c" /* yacc.c:1646  */
    break;

  case 2510:
#line 16313 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26652 "parser.c" /* yacc.c:1646  */
    break;

  case 2511:
#line 16317 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26660 "parser.c" /* yacc.c:1646  */
    break;

  case 2512:
#line 16324 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26669 "parser.c" /* yacc.c:1646  */
    break;

  case 2515:
#line 16337 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26678 "parser.c" /* yacc.c:1646  */
    break;

  case 2519:
#line 16353 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT INVALID KEY before INVALID KEY"));
	}
  }
#line 26689 "parser.c" /* yacc.c:1646  */
    break;

  case 2520:
#line 16363 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26697 "parser.c" /* yacc.c:1646  */
    break;

  case 2521:
#line 16367 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 26705 "parser.c" /* yacc.c:1646  */
    break;

  case 2522:
#line 16374 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 26714 "parser.c" /* yacc.c:1646  */
    break;

  case 2525:
#line 16387 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 26723 "parser.c" /* yacc.c:1646  */
    break;

  case 2526:
#line 16397 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26731 "parser.c" /* yacc.c:1646  */
    break;

  case 2527:
#line 16401 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
	CB_PENDING ("THREAD");
  }
#line 26740 "parser.c" /* yacc.c:1646  */
    break;

  case 2528:
#line 16409 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26748 "parser.c" /* yacc.c:1646  */
    break;

  case 2529:
#line 16413 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_PENDING ("THREAD");
  }
#line 26757 "parser.c" /* yacc.c:1646  */
    break;

  case 2530:
#line 16421 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 26765 "parser.c" /* yacc.c:1646  */
    break;

  case 2531:
#line 16425 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 26773 "parser.c" /* yacc.c:1646  */
    break;

  case 2532:
#line 16434 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_one;
  }
#line 26781 "parser.c" /* yacc.c:1646  */
    break;

  case 2533:
#line 16438 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 26789 "parser.c" /* yacc.c:1646  */
    break;

  case 2534:
#line 16444 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 26795 "parser.c" /* yacc.c:1646  */
    break;

  case 2535:
#line 16445 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 26801 "parser.c" /* yacc.c:1646  */
    break;

  case 2536:
#line 16452 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_cond ((yyvsp[0]));
	cb_end_cond ((yyval));
  }
#line 26810 "parser.c" /* yacc.c:1646  */
    break;

  case 2537:
#line 16457 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_error_node;
	cb_end_cond ((yyval));
  }
#line 26819 "parser.c" /* yacc.c:1646  */
    break;

  case 2538:
#line 16465 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_expr ((yyvsp[0]));
  }
#line 26827 "parser.c" /* yacc.c:1646  */
    break;

  case 2539:
#line 16471 "parser.y" /* yacc.c:1646  */
    {
	current_expr = NULL;
	cb_exp_line = cb_source_line;
  }
#line 26836 "parser.c" /* yacc.c:1646  */
    break;

  case 2540:
#line 16476 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_reverse (current_expr);
  }
#line 26844 "parser.c" /* yacc.c:1646  */
    break;

  case 2543:
#line 16487 "parser.y" /* yacc.c:1646  */
    { push_expr ('x', (yyvsp[0])); }
#line 26850 "parser.c" /* yacc.c:1646  */
    break;

  case 2546:
#line 16492 "parser.y" /* yacc.c:1646  */
    { push_expr ('x', cb_zero); }
#line 26856 "parser.c" /* yacc.c:1646  */
    break;

  case 2547:
#line 16494 "parser.y" /* yacc.c:1646  */
    { push_expr ('(', NULL); }
#line 26862 "parser.c" /* yacc.c:1646  */
    break;

  case 2548:
#line 16495 "parser.y" /* yacc.c:1646  */
    { push_expr (')', NULL); }
#line 26868 "parser.c" /* yacc.c:1646  */
    break;

  case 2549:
#line 16497 "parser.y" /* yacc.c:1646  */
    { push_expr ('+', NULL); }
#line 26874 "parser.c" /* yacc.c:1646  */
    break;

  case 2550:
#line 16498 "parser.y" /* yacc.c:1646  */
    { push_expr ('-', NULL); }
#line 26880 "parser.c" /* yacc.c:1646  */
    break;

  case 2551:
#line 16499 "parser.y" /* yacc.c:1646  */
    { push_expr ('*', NULL); }
#line 26886 "parser.c" /* yacc.c:1646  */
    break;

  case 2552:
#line 16500 "parser.y" /* yacc.c:1646  */
    { push_expr ('/', NULL); }
#line 26892 "parser.c" /* yacc.c:1646  */
    break;

  case 2553:
#line 16501 "parser.y" /* yacc.c:1646  */
    { push_expr ('^', NULL); }
#line 26898 "parser.c" /* yacc.c:1646  */
    break;

  case 2555:
#line 16504 "parser.y" /* yacc.c:1646  */
    { push_expr ('&', NULL); }
#line 26904 "parser.c" /* yacc.c:1646  */
    break;

  case 2556:
#line 16505 "parser.y" /* yacc.c:1646  */
    { push_expr ('|', NULL); }
#line 26910 "parser.c" /* yacc.c:1646  */
    break;

  case 2559:
#line 16514 "parser.y" /* yacc.c:1646  */
    { push_expr ('!', NULL); }
#line 26916 "parser.c" /* yacc.c:1646  */
    break;

  case 2560:
#line 16517 "parser.y" /* yacc.c:1646  */
    { push_expr ('C', (yyvsp[0])); }
#line 26922 "parser.c" /* yacc.c:1646  */
    break;

  case 2561:
#line 16519 "parser.y" /* yacc.c:1646  */
    { push_expr ('=', NULL); }
#line 26928 "parser.c" /* yacc.c:1646  */
    break;

  case 2562:
#line 16520 "parser.y" /* yacc.c:1646  */
    { push_expr ('>', NULL); }
#line 26934 "parser.c" /* yacc.c:1646  */
    break;

  case 2563:
#line 16521 "parser.y" /* yacc.c:1646  */
    { push_expr ('<', NULL); }
#line 26940 "parser.c" /* yacc.c:1646  */
    break;

  case 2564:
#line 16522 "parser.y" /* yacc.c:1646  */
    { push_expr (']', NULL); }
#line 26946 "parser.c" /* yacc.c:1646  */
    break;

  case 2565:
#line 16523 "parser.y" /* yacc.c:1646  */
    { push_expr ('[', NULL); }
#line 26952 "parser.c" /* yacc.c:1646  */
    break;

  case 2566:
#line 16524 "parser.y" /* yacc.c:1646  */
    { push_expr ('~', NULL); }
#line 26958 "parser.c" /* yacc.c:1646  */
    break;

  case 2567:
#line 16526 "parser.y" /* yacc.c:1646  */
    { push_expr ('O', NULL); }
#line 26964 "parser.c" /* yacc.c:1646  */
    break;

  case 2568:
#line 16527 "parser.y" /* yacc.c:1646  */
    { push_expr ('9', NULL); }
#line 26970 "parser.c" /* yacc.c:1646  */
    break;

  case 2569:
#line 16528 "parser.y" /* yacc.c:1646  */
    { push_expr ('A', NULL); }
#line 26976 "parser.c" /* yacc.c:1646  */
    break;

  case 2570:
#line 16529 "parser.y" /* yacc.c:1646  */
    { push_expr ('L', NULL); }
#line 26982 "parser.c" /* yacc.c:1646  */
    break;

  case 2571:
#line 16530 "parser.y" /* yacc.c:1646  */
    { push_expr ('U', NULL); }
#line 26988 "parser.c" /* yacc.c:1646  */
    break;

  case 2572:
#line 16533 "parser.y" /* yacc.c:1646  */
    { push_expr ('P', NULL); }
#line 26994 "parser.c" /* yacc.c:1646  */
    break;

  case 2573:
#line 16534 "parser.y" /* yacc.c:1646  */
    { push_expr ('N', NULL); }
#line 27000 "parser.c" /* yacc.c:1646  */
    break;

  case 2582:
#line 16564 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 27008 "parser.c" /* yacc.c:1646  */
    break;

  case 2583:
#line 16568 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0]));
  }
#line 27016 "parser.c" /* yacc.c:1646  */
    break;

  case 2587:
#line 16580 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '+', (yyvsp[0])); }
#line 27022 "parser.c" /* yacc.c:1646  */
    break;

  case 2588:
#line 16581 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '-', (yyvsp[0])); }
#line 27028 "parser.c" /* yacc.c:1646  */
    break;

  case 2589:
#line 16582 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27034 "parser.c" /* yacc.c:1646  */
    break;

  case 2590:
#line 16586 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '*', (yyvsp[0])); }
#line 27040 "parser.c" /* yacc.c:1646  */
    break;

  case 2591:
#line 16587 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '/', (yyvsp[0])); }
#line 27046 "parser.c" /* yacc.c:1646  */
    break;

  case 2592:
#line 16588 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27052 "parser.c" /* yacc.c:1646  */
    break;

  case 2593:
#line 16593 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_binary_op ((yyvsp[-2]), '^', (yyvsp[0]));
  }
#line 27060 "parser.c" /* yacc.c:1646  */
    break;

  case 2594:
#line 16596 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27066 "parser.c" /* yacc.c:1646  */
    break;

  case 2595:
#line 16600 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27072 "parser.c" /* yacc.c:1646  */
    break;

  case 2596:
#line 16601 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op (cb_zero, '-', (yyvsp[0])); }
#line 27078 "parser.c" /* yacc.c:1646  */
    break;

  case 2597:
#line 16602 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27084 "parser.c" /* yacc.c:1646  */
    break;

  case 2598:
#line 16605 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 27090 "parser.c" /* yacc.c:1646  */
    break;

  case 2599:
#line 16606 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 27096 "parser.c" /* yacc.c:1646  */
    break;

  case 2600:
#line 16617 "parser.y" /* yacc.c:1646  */
    {
	if (current_linage > 1) {
		cb_error (_("LINAGE-COUNTER must be qualified here"))