#ifndef __GM_WORLD_VIEW_H__
#define __GM_WORLD_VIEW_H__

#include <gtk/gtk.h>
#include "gm-support.h"
#include "gm-world.h"
#include "gm-world-input-view.h"
#include "gm-world-text-view.h"
#include "gm-searchable.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_WORLD_VIEW					(gm_world_view_get_type())
#define GM_WORLD_VIEW(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_WORLD_VIEW, GmWorldView))
#define GM_WORLD_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_WORLD_VIEW, GmWorldView const))
#define GM_WORLD_VIEW_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_WORLD_VIEW, GmWorldViewClass))
#define GM_IS_WORLD_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_WORLD_VIEW))
#define GM_IS_WORLD_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_WORLD_VIEW))
#define GM_WORLD_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_WORLD_VIEW, GmWorldViewClass))

/* Private structure type */
typedef struct _GmWorldViewPrivate GmWorldViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmWorldView GmWorldView;
 
struct _GmWorldView {
	GtkNotebook notebook;
	
	/*< private > */
	GmWorldViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmWorldViewClass 	GmWorldViewClass;

struct _GmWorldViewClass {
	GtkNotebookClass parent_class;

	/* Signals */
};

GType gm_world_view_get_type(void) G_GNUC_CONST;
GtkWidget *gm_world_view_new(GmWorld *world);

gboolean gm_world_view_find_first(GmWorldView *view, const gchar *str,
		GmSearchableSearchFlags flags);
gboolean gm_world_view_find_next(GmWorldView *view, const gchar *str,
		GmSearchableSearchFlags flags);
gboolean gm_world_view_can_find(GmWorldView *view);
gboolean gm_world_view_page_can_find(GmWorldView *view, gint page_num);

gboolean gm_world_view_replace(GmWorldView *view, gchar const *replace);
gboolean gm_world_view_replace_all(GmWorldView *view, gchar const *str, 
		gchar const *replace, GmSearchableSearchFlags flags);
gboolean gm_world_view_can_replace(GmWorldView *view);
gboolean gm_world_view_page_can_replace(GmWorldView *view, gint page_num);

GmWorld *gm_world_view_world(GmWorldView *view);
GmWorldInputView *gm_world_view_input(GmWorldView *view);
GmWorldTextView *gm_world_view_text_view(GmWorldView *view);
GtkHPaned *gm_world_view_hpaned(GmWorldView *view);

GtkTextBuffer *gm_world_view_buffer(GmWorldView *view);
gboolean gm_world_view_text_active(GmWorldView *view);

void gm_world_view_open_log(GmWorldView *view, const gchar *filename);
void gm_world_view_set_userlist_width(GmWorldView *view, gint width);
void gm_world_view_set_focus(GmWorldView *view);

void gm_world_view_update_status(GmWorldView *view, gchar const *status);
void gm_world_view_flash_status(GmWorldView *view, gchar const *status,
		guint seconds);

G_END_DECLS
#endif /* __GM_WORLD_VIEW_H__ */
