#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif /* HAVE_CONFIG_H */

#ifndef DO_WITH_GSL

/* This test is not performed */
int main()
{
    return 0;
}

#else

#include <stdio.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_histogram.h>


int main(void)
{
  FILE* out_file; /* output stream*/
  int i;
  double cut_off;
  double sigma;
  const int sample_no=100000;   /* sample numbers */
  const int bin_no=100;      /* number of bins in histogram */
  gsl_histogram* my_hist;
  gsl_rng* my_rng;

  out_file=stdout;
  my_hist=gsl_histogram_calloc_uniform(bin_no,-10,10);
  my_rng=gsl_rng_alloc(gsl_rng_default);

  sigma=1;
  cut_off=-4;

  fprintf(out_file,"plot '-' using 1:3 title '1st',");
  fprintf(out_file,"'-' using 1:3 title '2nd',");
  fprintf(out_file,"'-' using 1:3 title '3rd'\n");
  while (cut_off<=4)
    {
      fprintf(out_file,"# cut_off %f, sigma %f\n",cut_off,sigma);
      gsl_histogram_reset(my_hist);
      for (i=0;i<sample_no;i++)
	gsl_histogram_increment(my_hist,gsl_ran_gaussian_tail(my_rng,cut_off,sigma));
      gsl_histogram_fprintf(out_file,my_hist,"%f","%f");
      fprintf(out_file,"e\n");
      cut_off+=4;
    }
  return 0;
}

#endif
