/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.PlayerWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class PlayerWrappers {
    public static final String[] PLAYER_CLASS_NAMES = new String[]{"HumanFillerPlayer", "RemotePlayer", "Sachin", "Dieter", "Isadora", "Margaret", "Rosita", "Luigi", "Makhaya", "Claudius", "Basil", "Wanda", "Mainoumi", "Omar", "Shirley", "Hugo", "Eldine", "Aleksandr", "Manuelito", "Che", "Cochise", "Jefferson"};
    public static final String PLAYER_PACKAGE = "friendless.games.filler.player";
    private static Random rng = new Random();
    private PlayerWrapper[] wrappers;
    private boolean[] selected;
    private ResourceBundle resources;

    public PlayerWrappers(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.wrappers = PlayerWrappers.getPlayerList(resourceBundle);
        this.selected = new boolean[this.wrappers.length];
        int n = 0;
        while (n < this.selected.length) {
            this.selected[n] = true;
            ++n;
        }
    }

    public PlayerWrappers(ResourceBundle resourceBundle, List list) {
        this.wrappers = new PlayerWrapper[list.size()];
        this.wrappers = list.toArray(this.wrappers);
        this.selected = new boolean[this.wrappers.length];
        int n = 0;
        while (n < this.selected.length) {
            this.selected[n] = true;
            ++n;
        }
    }

    public PlayerWrappers getSelected() {
        ArrayList<PlayerWrapper> arrayList = new ArrayList<PlayerWrapper>(this.wrappers.length);
        int n = 0;
        while (n < this.wrappers.length) {
            if (this.selected[n]) {
                arrayList.add(this.wrappers[n]);
            }
            ++n;
        }
        return new PlayerWrappers(this.resources, arrayList);
    }

    public ListModel getListModel() {
        DefaultListModel<PlayerWrapper> defaultListModel = new DefaultListModel<PlayerWrapper>();
        int n = 0;
        while (n < this.wrappers.length) {
            defaultListModel.addElement(this.wrappers[n]);
            ++n;
        }
        return defaultListModel;
    }

    public ComboBoxModel getComboBoxModel() {
        DefaultComboBoxModel<PlayerWrapper> defaultComboBoxModel = new DefaultComboBoxModel<PlayerWrapper>();
        int n = 0;
        while (n < this.wrappers.length) {
            defaultComboBoxModel.addElement(this.wrappers[n]);
            ++n;
        }
        return defaultComboBoxModel;
    }

    private static PlayerWrapper[] getPlayerList(ResourceBundle resourceBundle) {
        PlayerWrapper[] playerWrapperArray = new PlayerWrapper[PLAYER_CLASS_NAMES.length];
        int n = 0;
        while (n < playerWrapperArray.length) {
            try {
                playerWrapperArray[n] = new PlayerWrapper("friendless.games.filler.player." + PLAYER_CLASS_NAMES[n], resourceBundle);
            }
            catch (Exception exception) {
                String string = resourceBundle.getString("filler.string.cantload");
                String string2 = MessageFormat.format(string, PLAYER_CLASS_NAMES[n]);
                System.out.println(string2);
                exception.printStackTrace();
            }
            playerWrapperArray[n].setRatings();
            ++n;
        }
        return playerWrapperArray;
    }

    public int size() {
        return this.wrappers.length;
    }

    public PlayerWrapper get(int n) {
        return this.wrappers[n];
    }

    public void sortByRatings() {
        int n = 1;
        while (n < this.wrappers.length) {
            PlayerWrapper playerWrapper = this.wrappers[n];
            int n2 = 0;
            while (n2 < n) {
                PlayerWrapper playerWrapper2 = this.wrappers[n2];
                if (playerWrapper.getRating() > playerWrapper2.getRating()) {
                    PlayerWrapper playerWrapper3 = this.wrappers[n];
                    this.wrappers[n] = this.wrappers[n2];
                    this.wrappers[n2] = playerWrapper3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void sortByRandom() {
        int n = this.wrappers.length - 1;
        while (n > 1) {
            int n2 = rng.nextInt(n);
            PlayerWrapper playerWrapper = this.wrappers[n];
            this.wrappers[n] = this.wrappers[n2];
            this.wrappers[n2] = playerWrapper;
            --n;
        }
    }

    public boolean contains(PlayerWrapper playerWrapper) {
        if (playerWrapper == null) {
            return false;
        }
        int n = 0;
        while (n < this.wrappers.length) {
            if (playerWrapper.equals(this.wrappers[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSelected(PlayerWrapper playerWrapper) {
        if (playerWrapper == null) {
            return false;
        }
        int n = 0;
        while (n < this.wrappers.length) {
            if (playerWrapper.equals(this.wrappers[n])) {
                return this.selected[n];
            }
            ++n;
        }
        return false;
    }

    public void setSelection(PlayerWrapper playerWrapper, boolean bl) {
        if (playerWrapper == null) {
            return;
        }
        int n = 0;
        while (n < this.wrappers.length) {
            if (playerWrapper.equals(this.wrappers[n])) {
                this.selected[n] = bl;
            }
            ++n;
        }
    }

    public PlayerWrapper[] toArray() {
        PlayerWrapper[] playerWrapperArray = (PlayerWrapper[])this.wrappers.clone();
        return playerWrapperArray;
    }

    public String toString() {
        return Arrays.asList(this.wrappers).toString();
    }
}

