/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinarySerializedObject;

public class BinarySetType
implements BinaryObject {
    public static final int computeBytes(SetType st) {
        return 10;
    }

    public static final SetType read(BinaryReader reader, int index) throws IOException, VisADException {
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int dIndex = file.readInt();
        MathType dom = (MathType)cache.get(dIndex);
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no SetType end-marker)");
        }
        SetType st = new SetType(dom);
        cache.add(index, st);
        return st;
    }

    public static final int write(BinaryWriter writer, SetType st, Set set, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(st);
        if (index < 0) {
            index = cache.add(st);
            if (index < 0) {
                throw new IOException("Couldn't cache SetType " + st);
            }
            if (!(st.getClass().equals(SetType.class) || st instanceof SetType && st instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, st, token);
                return index;
            }
            MathType domain = st.getDomain();
            boolean isRealTupleType = false;
            if (domain instanceof RealTupleType) {
                RealTupleType rtt = domain;
                if (rtt.getDimension() == 1 && rtt.getCoordinateSystem() == null && rtt.getDefaultSet() == null) {
                    try {
                        domain = rtt.getComponent(0);
                    }
                    catch (VisADException ve) {
                        throw new IOException("Couldn't get SetType domain: " + ve.getMessage());
                    }
                } else {
                    isRealTupleType = true;
                }
            }
            int dIndex = isRealTupleType ? BinaryRealTupleType.write(writer, domain, token) : BinaryMathType.write(writer, domain, token);
            int objLen = BinarySetType.computeBytes(st);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(4);
            file.writeInt(dIndex);
            file.writeByte(80);
        }
        return index;
    }
}

