#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import screen_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Reads attributes of current cursor position")

    def run(self):
        # is it enabled?
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "general", "hasattributes"
        ):
            return
        # is a vertical change?
        if not (
            self.env["runtime"]["CursorManager"].is_cursor_vertical_move()
            or self.env["runtime"]["CursorManager"].is_cursor_horizontal_move()
        ):
            return

        cursor_pos = self.env["screen"]["new_cursor"]

        if not self.env["runtime"]["AttributeManager"].has_attributes(
            cursor_pos
        ):
            return
        self.env["runtime"]["OutputManager"].present_text(
            "has attribute", sound_icon="HasAttributes", interrupt=False
        )

    def set_callback(self, callback):
        pass
