/*
 * $Id: sig_telephone.c,v 1.34 2012-07-05 21:09:31 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_telephone.h"

void
sig_telephone_send_data(
	const struct sig_telephone* b,
	void *s, 
	uint8_t data
) 
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv_data(b->member[nr].s, data);
	}
}

void
sig_telephone_send_ctrl(
	const struct sig_telephone *b,
	void *s,
	enum sig_telephone_protocol proto
) 
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv_ctrl(b->member[nr].s, proto);
	}
}

void
sig_telephone_dial(
	const struct sig_telephone *b,
	void *s,
	uint32_t number
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv_dial(b->member[nr].s, number);
	}
}

void
sig_telephone_connect(
	struct sig_telephone *b,
	void *s,
	const struct sig_telephone_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_TELEPHONE);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_telephone *
sig_telephone_create(const char *name)
{
	struct sig_telephone *b;

	b = shm_alloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_TELEPHONE;
	b->nmembers = 0;

	return b;
}

void
sig_telephone_destroy(struct sig_telephone *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_TELEPHONE);

	shm_free(sig);
}

void
sig_telephone_suspend(struct sig_telephone *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_telephone_resume(struct sig_telephone *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
