(defun points-on-circle (&optional (dia 200.0) (segments 64) )
  (let ((points) (anginc (/ 2pi segments)) (ang 0.0) x y)
    (dotimes (s segments)
	(setq x (* dia (cos ang))
	      y (* dia (sin ang)))
	(push (integer-vector (round x) (round y)) points)
	(incf ang anginc))
    (coerce (nreverse points) vector)))

(defun draw-lines (points &optional (skip 30) 
		(color 5)
		(count (length points))
		(offset #i(210 210)))
  (let ((point1 (elt points 0)) (point2) (index 0) (size (length points)))
     (send *viewsurface* :foreground 
		(aref image::*x-rainbow32-lut* color) ) ; (mod index 32)
     (dotimes (i count)
	(setq index (mod (incf index skip) size))
	(setq point2 (elt points index))
	(send *viewsurface* :draw-line (v+ offset point1) (v+ offset point2))
	(setq point1 point2)))
   (xflush)
  )
