/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.StringLike;

public class RegRes
implements Cloneable {
    protected int[] marks = null;
    protected boolean didMatch_ = false;
    protected StringLike src = null;
    protected int charsMatched_ = 0;
    protected int matchFrom_ = 0;
    protected int numSubs_ = 0;

    public String getString() {
        return ((Object)this.src).toString();
    }

    public StringLike getStringLike() {
        return this.src;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("match=" + this.matchedFrom() + ":" + this.charsMatched());
        if (!this.didMatch()) {
            return sb.toString();
        }
        for (int i = 0; i < this.numSubs(); ++i) {
            int n = i + 1;
            sb.append(" sub(" + n + ")=" + this.matchedFrom(n) + ":" + this.charsMatched(n));
        }
        return sb.toString();
    }

    public RegRes() {
    }

    public RegRes(RegRes r) {
        this.copyOutOf(r);
    }

    public void copyOutOf(RegRes r) {
        if (r.marks == null) {
            this.marks = null;
        } else {
            try {
                this.marks = new int[r.marks.length];
                for (int i = 0; i < this.marks.length; ++i) {
                    this.marks[i] = r.marks[i];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.didMatch_ = r.didMatch_;
        this.src = r.src;
        this.charsMatched_ = r.charsMatched_;
        this.matchFrom_ = r.matchFrom_;
        this.numSubs_ = r.numSubs_;
    }

    public Object clone() {
        return new RegRes(this);
    }

    public boolean equals(RegRes r) {
        if (this.charsMatched_ != r.charsMatched_ || this.matchFrom_ != r.matchFrom_ || this.didMatch_ != r.didMatch_ || this.numSubs_ != r.numSubs_ || !this.src.unwrap().equals(r.src.unwrap())) {
            return false;
        }
        if (this.marks == null && r.marks != null) {
            return false;
        }
        if (this.marks != null && r.marks == null) {
            return false;
        }
        for (int i = 1; i <= this.numSubs_; ++i) {
            if (this.matchedFrom(i) != r.matchedFrom(i)) {
                return false;
            }
            if (this.charsMatched(i) == r.charsMatched(i)) continue;
            return false;
        }
        return true;
    }

    public String stringMatched() {
        int mf = this.matchedFrom();
        int cm = this.charsMatched();
        return !this.didMatch_ || mf < 0 || cm < 0 ? null : this.src.substring(mf, mf + cm);
    }

    public int matchedFrom(int i) {
        if (this.marks == null || i > this.numSubs_) {
            return -1;
        }
        return this.marks[i];
    }

    public int charsMatched(int i) {
        if (this.marks == null || i > this.numSubs_ || !this.didMatch_) {
            return -1;
        }
        int mf = this.matchedFrom(i);
        return mf < 0 ? -1 : this.marks[i + this.numSubs_] - this.matchedFrom(i);
    }

    public int matchedTo(int i) {
        if (this.marks == null || i > this.numSubs_ || !this.didMatch_) {
            return -1;
        }
        return this.marks[i + this.numSubs_];
    }

    public String stringMatched(int i) {
        int mf = this.matchedFrom(i);
        int cm = this.charsMatched(i);
        return !this.didMatch_ || mf < 0 || cm < 0 ? null : this.src.substring(mf, mf + cm);
    }

    public String left() {
        int mf = this.matchedFrom();
        return !this.didMatch_ || mf < 0 ? null : this.src.substring(0, mf);
    }

    public String left(int i) {
        int mf = this.matchedFrom(i);
        return !this.didMatch_ || mf < 0 ? null : this.src.substring(0, mf);
    }

    public String right() {
        int mf = this.matchedFrom();
        int cm = this.charsMatched();
        return !this.didMatch_ || mf < 0 || cm < 0 ? null : this.src.substring(mf + cm, this.src.length());
    }

    public String right(int i) {
        int mf = this.matchedFrom(i);
        int cm = this.charsMatched(i);
        return !this.didMatch_ || mf < 0 || cm < 0 ? null : this.src.substring(mf + cm, this.src.length());
    }

    public int matchedFrom() {
        return !this.didMatch_ ? -1 : this.matchFrom_;
    }

    public int charsMatched() {
        return !this.didMatch_ || this.matchFrom_ < 0 ? -1 : this.charsMatched_;
    }

    public int matchedTo() {
        return !this.didMatch_ ? -1 : this.matchFrom_ + this.charsMatched_;
    }

    public int numSubs() {
        return this.numSubs_;
    }

    public boolean didMatch() {
        return this.didMatch_;
    }

    public int matchFrom() {
        return this.matchedFrom();
    }

    public String substring() {
        return this.stringMatched();
    }

    public int matchFrom(int i) {
        return this.matchedFrom(i);
    }

    public String substring(int i) {
        return this.stringMatched(i);
    }
}

