# Aspire.Hosting.AppHost library

Provides the core APIs and MSBuild logic for .NET Aspire AppHost projects.

## Getting started

### Install the package

In your project, install the .NET Aspire AppHost library with [NuGet](https://www.nuget.org):

```dotnetcli
dotnet add package Aspire.Hosting.AppHost
```

## Usage example

Then, in the _Program.cs_ file of `AppHost`, add project, container, and executable resources:

```csharp
var builder = DistributedApplication.CreateBuilder(args);

// The Projects.MyApp type is generated by custom MSBuild targets added
// by the Aspire.Hosting.AppHost package when the MyApp project is added
// as a project reference.
var app = builder.AddProject<Projects.MyApp>("myapp");

builder.Build().Run();
```

## Additional documentation
https://learn.microsoft.com/dotnet/aspire/

## Feedback & contributing

https://github.com/dotnet/aspire
