/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file diagnostics/basic_exceptions/invalid_argument.hpp
 *
 * @brief Exception in case of in invalid argument
 *
 * @author Christian Schallhart
 *
 * @version $Id: invalid_argument.hpp 296 2007-11-27 00:21:41Z tautschn $
 *
 */

#ifndef DIAGNOSTICS__BASIC_EXCEPTIONS__INVALID_ARGUMENT_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__BASIC_EXCEPTIONS__INVALID_ARGUMENT_HPP__INCLUDE_GUARD

#include <diagnostics/basic_exceptions/low_level_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Invalid_Argument 
 *
 * @brief The exception to be used if an argument is invalid. Please
 * note that Invalid_Argument is a @ref Low_Level_Exception -- and
 * thus its use is restricted.
 *
 * @nosubgrouping
 */
class Invalid_Argument
    : public Low_Level_Exception
{
    typedef Invalid_Argument Self;
    typedef Low_Level_Exception Super;
public:
    virtual ~Invalid_Argument() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    explicit Invalid_Argument(::std::string const & what);
    virtual char const * name() const;
    Invalid_Argument(Self const & other);
};

DIAGNOSTICS_NAMESPACE_END;

#endif /* DIAGNOSTICS__BASIC_EXCEPTIONS__INVALID_ARGUMENT_HPP__INCLUDE_GUARD */
