/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class GeneralComparison
extends BinaryExpression
implements ComparisonExpression {
    protected int singletonOperator;
    protected transient AtomicComparer comparer;

    public GeneralComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
        this.singletonOperator = GeneralComparison.getSingletonOperator(n);
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.singletonOperator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        if (this.operand0 == EmptySequence.getInstance() || this.operand1 == EmptySequence.getInstance()) {
            return BooleanValue.FALSE;
        }
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.operand0 = ExpressionTool.unsorted(optimizer, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(optimizer, this.operand1, false);
        SequenceType sequenceType = SequenceType.ATOMIC_SEQUENCE;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        int n = itemType2.getPrimitiveType();
        int n2 = itemType3.getPrimitiveType();
        int n3 = this.operand0.getCardinality();
        int n4 = this.operand1.getCardinality();
        if (n3 == 8192 || n4 == 8192) {
            return BooleanValue.FALSE;
        }
        if (itemType2 != Type.ANY_ATOMIC_TYPE && itemType2 != Type.UNTYPED_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE && itemType3 != Type.UNTYPED_ATOMIC_TYPE && !Type.isComparable(n, n2, Token.isOrderedOperator(this.singletonOperator))) {
            StaticError staticError = new StaticError("Cannot compare " + itemType2.toString(staticContext.getNamePool()) + " to " + itemType3.toString(staticContext.getNamePool()));
            staticError.setErrorCode("XPTY0004");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (n3 == 16384 && n4 == 16384 && itemType2 != Type.ANY_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE) {
            Expression expression3 = this.operand0;
            Expression expression4 = this.operand1;
            if (itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
                if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                    expression3 = new CastExpression(this.operand0, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression3);
                    expression4 = new CastExpression(this.operand1, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression4);
                } else if (typeHierarchy.isSubType(itemType3, Type.NUMBER_TYPE)) {
                    expression3 = new CastExpression(this.operand0, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression3);
                } else {
                    expression3 = new CastExpression(this.operand0, (AtomicType)itemType3, false);
                    this.adoptChildExpression(expression3);
                }
            } else if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                if (typeHierarchy.isSubType(itemType2, Type.NUMBER_TYPE)) {
                    expression4 = new CastExpression(this.operand1, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression4);
                } else {
                    expression4 = new CastExpression(this.operand1, (AtomicType)itemType2, false);
                    this.adoptChildExpression(expression4);
                }
            }
            ValueComparison valueComparison = new ValueComparison(expression3, this.singletonOperator, expression4);
            ExpressionTool.copyLocationInfo(this, valueComparison);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.simplify(staticContext).typeCheck(staticContext, itemType);
        }
        Comparator comparator = staticContext.getCollation(staticContext.getDefaultCollationName());
        if (comparator == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = GenericAtomicComparer.makeAtomicComparer(n, n2, comparator, staticContext.getConfiguration());
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
        }
        return this;
    }

    private static Expression makeMinOrMax(Expression expression, StaticContext staticContext, String string) {
        FunctionCall functionCall = SystemFunction.makeSystemFunction(string, 1, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{expression};
        functionCall.setArguments(expressionArray);
        ((Minimax)functionCall).setIgnoreNaN(true);
        return functionCall;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        if (this.operand0 == EmptySequence.getInstance() || this.operand1 == EmptySequence.getInstance()) {
            return BooleanValue.FALSE;
        }
        this.operand0 = ExpressionTool.unsorted(optimizer, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(optimizer, this.operand1, false);
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        if (!Cardinality.allowsMany(n) && !Cardinality.allowsMany(n2)) {
            SingletonComparison singletonComparison = new SingletonComparison(this.operand0, this.singletonOperator, this.operand1);
            ExpressionTool.copyLocationInfo(this, singletonComparison);
            singletonComparison.setParentExpression(this.getParentExpression());
            singletonComparison.setComparator(this.comparer, staticContext.makeEarlyEvaluationContext());
            return singletonComparison.optimize(optimizer, staticContext, itemType);
        }
        if (!Cardinality.allowsMany(n)) {
            GeneralComparison generalComparison = this.getInverseComparison();
            ExpressionTool.copyLocationInfo(this, generalComparison);
            generalComparison.setParentExpression(this.getParentExpression());
            generalComparison.comparer = this.comparer;
            return generalComparison.optimize(optimizer, staticContext, itemType);
        }
        if (n == 16384 && n2 == 16384 && itemType2 != Type.ANY_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE) {
            Expression expression = this.operand0;
            Expression expression2 = this.operand1;
            if (itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
                if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                    expression = new CastExpression(this.operand0, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression);
                    expression2 = new CastExpression(this.operand1, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression2);
                } else if (typeHierarchy.isSubType(itemType3, Type.NUMBER_TYPE)) {
                    expression = new CastExpression(this.operand0, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression);
                } else {
                    expression = new CastExpression(this.operand0, (AtomicType)itemType3, false);
                    this.adoptChildExpression(expression);
                }
            } else if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                if (typeHierarchy.isSubType(itemType2, Type.NUMBER_TYPE)) {
                    expression2 = new CastExpression(this.operand1, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression2);
                } else {
                    expression2 = new CastExpression(this.operand1, (AtomicType)itemType2, false);
                    this.adoptChildExpression(expression2);
                }
            }
            ValueComparison valueComparison = new ValueComparison(expression, this.singletonOperator, expression2);
            ExpressionTool.copyLocationInfo(this, valueComparison);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.simplify(staticContext).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        Comparator comparator = staticContext.getCollation(staticContext.getDefaultCollationName());
        if (comparator == null) {
            comparator = CodepointCollator.getInstance();
        }
        int n3 = itemType2.getPrimitiveType();
        int n4 = itemType3.getPrimitiveType();
        this.comparer = GenericAtomicComparer.makeAtomicComparer(n3, n4, comparator, staticContext.getConfiguration());
        if (this.operator != 6 && this.operator != 22 && (typeHierarchy.isSubType(itemType2, Type.NUMBER_TYPE) || typeHierarchy.isSubType(itemType3, Type.NUMBER_TYPE))) {
            Object object;
            Serializable serializable;
            Expression expression = this.operand0;
            if (!typeHierarchy.isSubType(itemType2, Type.NUMBER_TYPE)) {
                serializable = new RoleLocator(1, Token.tokens[this.operator], 0, null);
                ((RoleLocator)serializable).setSourceLocator(this);
                expression = TypeChecker.staticTypeCheck(expression, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)serializable, staticContext);
            }
            serializable = this.operand1;
            if (!typeHierarchy.isSubType(itemType3, Type.NUMBER_TYPE)) {
                object = new RoleLocator(1, Token.tokens[this.operator], 1, null);
                ((RoleLocator)object).setSourceLocator(this);
                serializable = TypeChecker.staticTypeCheck((Expression)serializable, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)object, staticContext);
            }
            if (n2 == 16384) {
                object = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object).setVariableName("qq:" + object.hashCode());
                SequenceType sequenceType = SequenceType.makeSequenceType(expression.getItemType(typeHierarchy), 16384);
                ((RangeVariableDeclaration)object).setRequiredType(sequenceType);
                VariableReference variableReference = new VariableReference((VariableDeclaration)object);
                ValueComparison valueComparison = new ValueComparison(variableReference, this.singletonOperator, (Expression)serializable);
                QuantifiedExpression quantifiedExpression = new QuantifiedExpression();
                quantifiedExpression.setOperator(31);
                quantifiedExpression.setVariableDeclaration((RangeVariableDeclaration)object);
                quantifiedExpression.setSequence(expression);
                quantifiedExpression.setAction(valueComparison);
                quantifiedExpression.setLocationId(this.getLocationId());
                quantifiedExpression.setParentExpression(this.getParentExpression());
                return quantifiedExpression.typeCheck(staticContext, itemType);
            }
            switch (this.operator) {
                case 12: 
                case 14: {
                    object = new ValueComparison(GeneralComparison.makeMinOrMax(expression, staticContext, "min"), this.singletonOperator, GeneralComparison.makeMinOrMax((Expression)serializable, staticContext, "max"));
                    ((ValueComparison)object).setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                case 11: 
                case 13: {
                    object = new ValueComparison(GeneralComparison.makeMinOrMax(expression, staticContext, "max"), this.singletonOperator, GeneralComparison.makeMinOrMax((Expression)serializable, staticContext, "min"));
                    ((ValueComparison)object).setResultWhenEmpty(BooleanValue.FALSE);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator " + this.operator);
                }
            }
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            ((ComputedExpression)object).setParentExpression(this.getParentExpression());
            return ((ValueComparison)object).typeCheck(staticContext, itemType);
        }
        if (this.operand0 instanceof RangeExpression && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), Type.INTEGER_TYPE) && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            Expression expression = ((RangeExpression)this.operand0).operand0;
            Expression expression3 = ((RangeExpression)this.operand0).operand1;
            if (this.operand1 instanceof Position) {
                PositionRange positionRange = new PositionRange(expression, expression3);
                ExpressionTool.copyLocationInfo(this, positionRange);
                positionRange.setParentExpression(this.getParentExpression());
                return positionRange;
            }
            IntegerRangeTest integerRangeTest = new IntegerRangeTest(this.operand1, expression, expression3);
            ExpressionTool.copyLocationInfo(this, integerRangeTest);
            integerRangeTest.setParentExpression(this.getParentExpression());
            return integerRangeTest;
        }
        if (this.operand0 instanceof IntegerRange && typeHierarchy.isSubType(this.operand1.getItemType(typeHierarchy), Type.INTEGER_TYPE) && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            long l = ((IntegerRange)this.operand0).getStart();
            long l2 = ((IntegerRange)this.operand0).getEnd();
            if (this.operand1 instanceof Position) {
                PositionRange positionRange = new PositionRange(new IntegerValue(l), new IntegerValue(l2));
                ExpressionTool.copyLocationInfo(this, positionRange);
                positionRange.setParentExpression(this.getParentExpression());
                return positionRange;
            }
            IntegerRangeTest integerRangeTest = new IntegerRangeTest(this.operand1, new IntegerValue(l), new IntegerValue(l2));
            ExpressionTool.copyLocationInfo(this, integerRangeTest);
            integerRangeTest.setParentExpression(this.getParentExpression());
            return integerRangeTest;
        }
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            SequenceIterator sequenceIterator = this.operand0.iterate(xPathContext);
            SequenceIterator sequenceIterator2 = this.operand1.iterate(xPathContext);
            Value value = (Value)SequenceExtent.makeSequenceExtent(sequenceIterator2);
            int n = value.getLength();
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                AtomicValue atomicValue2;
                AtomicValue atomicValue3 = (AtomicValue)value.itemAt(0);
                while ((atomicValue2 = (AtomicValue)sequenceIterator.next()) != null) {
                    if (!GeneralComparison.compare(atomicValue2, this.singletonOperator, atomicValue3, this.comparer, xPathContext)) continue;
                    return true;
                }
                return false;
            }
            while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
                AtomicValue atomicValue4;
                SequenceIterator sequenceIterator3 = value.iterate(null);
                while ((atomicValue4 = (AtomicValue)sequenceIterator3.next()) != null) {
                    if (!GeneralComparison.compare(atomicValue, this.singletonOperator, atomicValue4, this.comparer, xPathContext)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
        catch (ValidationException validationException) {
            DynamicError dynamicError = new DynamicError(validationException);
            dynamicError.setXPathContext(xPathContext);
            if (validationException.getLineNumber() == -1) {
                dynamicError.setLocator(this);
            } else {
                dynamicError.setLocator(validationException);
            }
            dynamicError.setErrorCode(validationException.getErrorCodeLocalPart());
            throw dynamicError;
        }
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer, XPathContext xPathContext) throws XPathException {
        TypeHierarchy typeHierarchy;
        AtomicValue atomicValue3 = atomicValue;
        AtomicValue atomicValue4 = atomicValue2;
        if (atomicValue instanceof UntypedAtomicValue) {
            if (atomicValue2 instanceof NumericValue) {
                atomicValue3 = atomicValue.convert(517, xPathContext);
            } else if (!(atomicValue2 instanceof UntypedAtomicValue)) {
                typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
                atomicValue3 = atomicValue.convert(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), xPathContext);
            }
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            if (atomicValue instanceof NumericValue) {
                atomicValue4 = atomicValue2.convert(517, xPathContext);
            } else if (!(atomicValue instanceof UntypedAtomicValue)) {
                typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
                atomicValue4 = atomicValue2.convert(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), xPathContext);
            }
        }
        return ValueComparison.compare(atomicValue3, n, atomicValue4, atomicComparer);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    private static int getSingletonOperator(int n) {
        switch (n) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return n;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparison(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    protected String displayOperator() {
        return "many-to-many " + super.displayOperator();
    }
}

