macro(TEST variable)
  SET(expected "${ARGN}")
  if ( "${expected}" STREQUAL "UNDEFINED" )
    if (DEFINED ${variable})
      message(FATAL_ERROR "'${variable}' shall be undefined but has value '${${variable}}'")
    endif()
  elseif( "${expected}" STREQUAL "FALSE" )
    if (NOT ${variable} STREQUAL "FALSE")
      message(FATAL_ERROR "'${variable}' shall be FALSE")
    endif()
  elseif( "${expected}" STREQUAL "TRUE" )
    if (NOT ${variable} STREQUAL "TRUE")
      message(FATAL_ERROR "'${variable}' shall be TRUE")
    endif()
  else()
    if (NOT ${variable} STREQUAL "${expected}")
      message(FATAL_ERROR "'${variable}' shall be '${expected}'")
    endif()
  endif()
endmacro()
