#include "TicTacToeGame.h"

// Constructor
TicTacToeGame::TicTacToeGame() {

	alive = true;
	loadGraphics();

	mousePress = CL_Mouse::sig_key_down().connect(this, &TicTacToeGame::handleMousePress);
}

// Destructor
TicTacToeGame::~TicTacToeGame() {

	// Delete the surfaces
	delete board;
	delete o;
	delete x;
	delete menu;
}

void TicTacToeGame::loadGraphics() {

	// create loads the file with the given name and stores it for us; we only
	// need a pointer to access it.
	board = new CL_Surface("board.tga");
	o = new CL_Surface("o.tga");
	x = new CL_Surface("x.tga");
	menu = new CL_Surface("menu.tga");
}

void TicTacToeGame::run() {

	while (alive && !CL_Keyboard::get_keycode(CL_KEY_ESCAPE)) {

		// Game update function
		paint();

		CL_Display::flip();
		CL_System::sleep(10);
		CL_System::keep_alive();
	}
}

void TicTacToeGame::paint() {

	// First we want to clear the screen to a certain R, G, B color
	// 0, 0, 0, is black (255 is the alpha paramater - we want it full)
	// Black is the default clear color, so you could just use CL_Display::clear() here
	CL_Display::clear(CL_Color(0, 0, 0, 255));

	// Paint the board to the screen
	board->draw(75, 25);

	// Paint a sample move to the screen
	o->draw(200, 150);

	// Paint the 'restart / quit' menu below the board
	menu->draw(75, 400);
}

void TicTacToeGame::handleMousePress(const CL_InputEvent &key) {

	// Since a clicked happened, get the screen coordinates of the mouse
	int x = key.mouse_pos.x, y = key.mouse_pos.y;

	// 4 points forming a box around the 'Quit' label
	int quitX = 300, quitY = 400, quitWidth = 85, quitHeight = 20;

	// See if the x and y mouse coordinates lie inside that box
	if (x > quitX && x < quitX+quitWidth && y > quitY && y < quitY+quitHeight) {
		alive = false;
	}
}
