;; tests for checking whether the cl-plplot interface works
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'asdf)

(pushnew "./" asdf:*central-registry* :test #'equal)
(asdf:operate 'asdf:load-source-op :cl-plplot)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage :cl-plplot-test
  (:use :common-lisp :cl-plplot :cl-plplot-system)
  (:export :plot-sys :plot-win))

(in-package :cl-plplot-test)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter gdev "null")

(defun my-make-array (dims)
  (make-array dims :initial-element 0.0 :element-type 'float))

(defun my-make-vector (dim init-fn)
  (let ((vec (make-array dim :initial-element 0.0 :element-type 'float)))
    (dotimes (i dim)
      (setf (aref vec i) (funcall init-fn i)))
    vec))

(defun plot-sys ()
  (plsdev gdev)
  (plinit)
  (plcol0 1)
  (plwid 2)
  (plenv 0 6 0 36 0 0)
  (plcol0 2)
  (pllab "(x)" "(y)" "y = x#u2")
  (let ((xs (my-make-array 6))
        (ys (my-make-array 6))
        (x (my-make-array 60))
        (y (my-make-array 60)))
    (dotimes (i 6)
      (setf (aref xs i) i)
      (setf (aref ys i) (* i i)))
    (plcol0 4)
    (plpoin xs ys 9)
    (dotimes (i 60)
      (let ((tmp (* 0.1 i)))
        (setf (aref x i) tmp)
        (setf (aref y i) (* tmp tmp))))
    (plcol0 3)
    (plline x y))
  (plend))

(defun plot-win ()
  (let* ((x (my-make-vector 40 #'(lambda(x) (* 0.1 x))))
         (y (my-make-vector 40 #'(lambda(x) (* (* 0.1 x) (* 0.1 x)))))
         (p (new-x-y-plot x y))
         (w (basic-window)))
    (add-plot-to-window w p)
    (render w gdev)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(plot-sys)
(plot-win)
