from __future__ import absolute_import, division, print_function

from six.moves import cStringIO as StringIO
from mmtbx.ncs import ncs
import sys
from six.moves import zip
from six.moves import range

def remove_blank(text):
  return text.replace("\n"," ").replace(".0 "," ").replace(". "," ").replace(" ","")

text1="""

Summary of NCS information
Wed Jul  1 10:54:17 2015
source_info ncs.ncs_spec

new_ncs_group
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth    3.2161   -7.6562  -13.0956
CHAIN A
RMSD 0
MATCHING 7
  RESSEQ 92:98

new_operator

rota_matrix    0.4525   -0.3091   -0.8365
rota_matrix    0.7737    0.6025    0.1959
rota_matrix    0.4434   -0.7359    0.5118
tran_orth    -0.1318    4.4033   -9.9054

center_orth   -9.2303   -5.9527   -6.7960
CHAIN R
RMSD 0.0007
MATCHING 7
  RESSEQ 92:98


"""

expected_text_group_specification=text1

expected_text_resolve="""
new_ncs_group
rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth    3.2161   -7.6562  -13.0956

rota_matrix    0.4525   -0.3091   -0.8365
rota_matrix    0.7737    0.6025    0.1959
rota_matrix    0.4434   -0.7359    0.5118
tran_orth    -0.1318    4.4033   -9.9054

center_orth   -9.2303   -5.9527   -6.7960

"""

expected_text_refine="""
refinement.pdb_interpretation.ncs_group {
  reference = chain 'A' and (resseq 92:98 )
  selection = chain 'R' and (resseq 92:98 )
}
"""

def tst_01():
  print("Read ncs-spec file and write out text...", end=' ')
  f=open('ncs.ncs_spec','w')
  print(text1, file=f)
  f.close()


  from mmtbx.ncs.ncs import ncs
  ncs_object=ncs()
  ncs_object.read_ncs('ncs.ncs_spec',quiet=True)

  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  found_text=f.getvalue()
  expected_text=expected_text_group_specification

  if remove_blank(" ".join(found_text.split("source_info")[1:]) ) != \
     remove_blank(" ".join(expected_text.split("source_info")[1:])):
    print("Expected: \n%s \nFound: \n%s" %(expected_text_group_specification,found_text))
    raise AssertionError("FAILED")

  f=StringIO()
  ncs_object.format_all_for_resolve(out=f)
  found_text=f.getvalue()
  if remove_blank(found_text)!=remove_blank(expected_text_resolve):
    print("Expected: \n%s \nFound: \n%s" %(expected_text_resolve,found_text))
    raise AssertionError("FAILED")

  f=StringIO()
  ncs_object.format_all_for_phenix_refine(out=f)
  found_text=f.getvalue()
  if remove_blank(found_text)!=remove_blank(expected_text_refine):
    print("Expected: \n%s \nFound: \n%s" %(expected_text_refine,found_text))
    raise AssertionError("FAILED")

  print("OK")

text_helical="""
REMARK 350   BIOMT1   1 -0.982450 -0.186524  0.000000        0.00000
REMARK 350   BIOMT2   1  0.186524 -0.982450  0.000000        0.00000
REMARK 350   BIOMT3   1  0.000000  0.000000  1.000000      -35.25000
REMARK 350   BIOMT1   2 -0.980683  0.195604  0.000000        0.00000
REMARK 350   BIOMT2   2 -0.195604 -0.980683  0.000000        0.00000
REMARK 350   BIOMT3   2  0.000000  0.000000  1.000000      -33.84000
REMARK 350   BIOMT1   3 -0.835712  0.549169  0.000000        0.00000
REMARK 350   BIOMT2   3 -0.549169 -0.835712  0.000000        0.00000
REMARK 350   BIOMT3   3  0.000000  0.000000  1.000000      -32.43000
REMARK 350   BIOMT1   4 -0.568705  0.822541  0.000000        0.00000
REMARK 350   BIOMT2   4 -0.822541 -0.568705  0.000000        0.00000
REMARK 350   BIOMT3   4  0.000000  0.000000  1.000000      -31.02000
REMARK 350   BIOMT1   5 -0.218654  0.975802  0.000000        0.00000
REMARK 350   BIOMT2   5 -0.975802 -0.218654  0.000000        0.00000
REMARK 350   BIOMT3   5  0.000000  0.000000  1.000000      -29.61000
REMARK 350   BIOMT1   6  0.163326  0.986572  0.000000        0.00000
REMARK 350   BIOMT2   6 -0.986572  0.163326  0.000000        0.00000
REMARK 350   BIOMT3   6  0.000000  0.000000  1.000000      -28.20000
REMARK 350   BIOMT1   7  0.521456  0.853278  0.000000        0.00000
REMARK 350   BIOMT2   7 -0.853278  0.521456  0.000000        0.00000
REMARK 350   BIOMT3   7  0.000000  0.000000  1.000000      -26.79000
REMARK 350   BIOMT1   8  0.803441  0.595384  0.000000        0.00000
REMARK 350   BIOMT2   8 -0.595384  0.803441  0.000000        0.00000
REMARK 350   BIOMT3   8  0.000000  0.000000  1.000000      -25.38000
REMARK 350   BIOMT1   9  0.968104  0.250549  0.000000        0.00000
REMARK 350   BIOMT2   9 -0.250549  0.968104  0.000000        0.00000
REMARK 350   BIOMT3   9  0.000000  0.000000  1.000000      -23.97000
REMARK 350   BIOMT1  10  0.991399 -0.130872  0.000000        0.00000
REMARK 350   BIOMT2  10  0.130872  0.991399  0.000000        0.00000
REMARK 350   BIOMT3  10  0.000000  0.000000  1.000000      -22.56000
REMARK 350   BIOMT1  11  0.869926 -0.493183  0.000000        0.00000
REMARK 350   BIOMT2  11  0.493183  0.869926  0.000000        0.00000
REMARK 350   BIOMT3  11  0.000000  0.000000  1.000000      -21.15000
REMARK 350   BIOMT1  12  0.621421 -0.783477  0.000000        0.00000
REMARK 350   BIOMT2  12  0.783477  0.621421  0.000000        0.00000
REMARK 350   BIOMT3  12  0.000000  0.000000  1.000000      -19.74000
REMARK 350   BIOMT1  13  0.282174 -0.959363  0.000000        0.00000
REMARK 350   BIOMT2  13  0.959363  0.282174  0.000000        0.00000
REMARK 350   BIOMT3  13  0.000000  0.000000  1.000000      -18.33000
REMARK 350   BIOMT1  14 -0.098278 -0.995159  0.000000        0.00000
REMARK 350   BIOMT2  14  0.995159 -0.098278  0.000000        0.00000
REMARK 350   BIOMT3  14  0.000000  0.000000  1.000000      -16.92000
REMARK 350   BIOMT1  15 -0.464378 -0.885637  0.000000        0.00000
REMARK 350   BIOMT2  15  0.885637 -0.464378  0.000000        0.00000
REMARK 350   BIOMT3  15  0.000000  0.000000  1.000000      -15.51000
REMARK 350   BIOMT1  16 -0.762668 -0.646790  0.000000        0.00000
REMARK 350   BIOMT2  16  0.646790 -0.762668  0.000000        0.00000
REMARK 350   BIOMT3  16  0.000000  0.000000  1.000000      -14.10000
REMARK 350   BIOMT1  17 -0.949590 -0.313495  0.000000        0.00000
REMARK 350   BIOMT2  17  0.313495 -0.949590  0.000000        0.00000
REMARK 350   BIOMT3  17  0.000000  0.000000  1.000000      -12.69000
REMARK 350   BIOMT1  18 -0.997847  0.065577  0.000000        0.00000
REMARK 350   BIOMT2  18 -0.065577 -0.997847  0.000000        0.00000
REMARK 350   BIOMT3  18  0.000000  0.000000  1.000000      -11.28000
REMARK 350   BIOMT1  19 -0.900395  0.435074  0.000000        0.00000
REMARK 350   BIOMT2  19 -0.435074 -0.900395  0.000000        0.00000
REMARK 350   BIOMT3  19  0.000000  0.000000  1.000000       -9.87000
REMARK 350   BIOMT1  20 -0.671462  0.741039  0.000000        0.00000
REMARK 350   BIOMT2  20 -0.741039 -0.671462  0.000000        0.00000
REMARK 350   BIOMT3  20  0.000000  0.000000  1.000000       -8.46000
REMARK 350   BIOMT1  21 -0.344479  0.938794  0.000000        0.00000
REMARK 350   BIOMT2  21 -0.938794 -0.344479  0.000000        0.00000
REMARK 350   BIOMT3  21  0.000000  0.000000  1.000000       -7.05000
REMARK 350   BIOMT1  22  0.032806  0.999462  0.000000        0.00000
REMARK 350   BIOMT2  22 -0.999462  0.032806  0.000000        0.00000
REMARK 350   BIOMT3  22  0.000000  0.000000  1.000000       -5.64000
REMARK 350   BIOMT1  23  0.405301  0.914183  0.000000        0.00000
REMARK 350   BIOMT2  23 -0.914183  0.405301  0.000000        0.00000
REMARK 350   BIOMT3  23  0.000000  0.000000  1.000000       -4.23000
REMARK 350   BIOMT1  24  0.718612  0.695411  0.000000        0.00000
REMARK 350   BIOMT2  24 -0.695411  0.718612  0.000000        0.00000
REMARK 350   BIOMT3  24  0.000000  0.000000  1.000000       -2.82000
REMARK 350   BIOMT1  25  0.926988  0.375092  0.000000        0.00000
REMARK 350   BIOMT2  25 -0.375092  0.926988  0.000000        0.00000
REMARK 350   BIOMT3  25  0.000000  0.000000  1.000000       -1.41000
REMARK 350   BIOMT1  26  1.000000 -0.000000  0.000000        0.00000
REMARK 350   BIOMT2  26  0.000000  1.000000  0.000000        0.00000
REMARK 350   BIOMT3  26  0.000000  0.000000  1.000000       -0.00000
REMARK 350   BIOMT1  27  0.926988 -0.375092  0.000000        0.00000
REMARK 350   BIOMT2  27  0.375092  0.926988  0.000000        0.00000
REMARK 350   BIOMT3  27  0.000000  0.000000  1.000000        1.41000
REMARK 350   BIOMT1  28  0.718612 -0.695411  0.000000        0.00000
REMARK 350   BIOMT2  28  0.695411  0.718612  0.000000        0.00000
REMARK 350   BIOMT3  28  0.000000  0.000000  1.000000        2.82000
REMARK 350   BIOMT1  29  0.405301 -0.914183  0.000000        0.00000
REMARK 350   BIOMT2  29  0.914183  0.405301  0.000000        0.00000
REMARK 350   BIOMT3  29  0.000000  0.000000  1.000000        4.23000
REMARK 350   BIOMT1  30  0.032806 -0.999462  0.000000        0.00000
REMARK 350   BIOMT2  30  0.999462  0.032806  0.000000        0.00000
REMARK 350   BIOMT3  30  0.000000  0.000000  1.000000        5.64000
REMARK 350   BIOMT1  31 -0.344479 -0.938794  0.000000        0.00000
REMARK 350   BIOMT2  31  0.938794 -0.344479  0.000000        0.00000
REMARK 350   BIOMT3  31  0.000000  0.000000  1.000000        7.05000
REMARK 350   BIOMT1  32 -0.671462 -0.741039  0.000000        0.00000
REMARK 350   BIOMT2  32  0.741039 -0.671462  0.000000        0.00000
REMARK 350   BIOMT3  32  0.000000  0.000000  1.000000        8.46000
REMARK 350   BIOMT1  33 -0.900395 -0.435074  0.000000        0.00000
REMARK 350   BIOMT2  33  0.435074 -0.900395  0.000000        0.00000
REMARK 350   BIOMT3  33  0.000000  0.000000  1.000000        9.87000
REMARK 350   BIOMT1  34 -0.997847 -0.065577  0.000000        0.00000
REMARK 350   BIOMT2  34  0.065577 -0.997847  0.000000        0.00000
REMARK 350   BIOMT3  34  0.000000  0.000000  1.000000       11.28000
REMARK 350   BIOMT1  35 -0.949590  0.313495  0.000000        0.00000
REMARK 350   BIOMT2  35 -0.313495 -0.949590  0.000000        0.00000
REMARK 350   BIOMT3  35  0.000000  0.000000  1.000000       12.69000
REMARK 350   BIOMT1  36 -0.762668  0.646790  0.000000        0.00000
REMARK 350   BIOMT2  36 -0.646790 -0.762668  0.000000        0.00000
REMARK 350   BIOMT3  36  0.000000  0.000000  1.000000       14.10000
REMARK 350   BIOMT1  37 -0.464378  0.885637  0.000000        0.00000
REMARK 350   BIOMT2  37 -0.885637 -0.464378  0.000000        0.00000
REMARK 350   BIOMT3  37  0.000000  0.000000  1.000000       15.51000
REMARK 350   BIOMT1  38 -0.098278  0.995159  0.000000        0.00000
REMARK 350   BIOMT2  38 -0.995159 -0.098278  0.000000        0.00000
REMARK 350   BIOMT3  38  0.000000  0.000000  1.000000       16.92000
REMARK 350   BIOMT1  39  0.282174  0.959363  0.000000        0.00000
REMARK 350   BIOMT2  39 -0.959363  0.282174  0.000000        0.00000
REMARK 350   BIOMT3  39  0.000000  0.000000  1.000000       18.33000
REMARK 350   BIOMT1  40  0.621421  0.783477  0.000000        0.00000
REMARK 350   BIOMT2  40 -0.783477  0.621421  0.000000        0.00000
REMARK 350   BIOMT3  40  0.000000  0.000000  1.000000       19.74000
REMARK 350   BIOMT1  41  0.869926  0.493183  0.000000        0.00000
REMARK 350   BIOMT2  41 -0.493183  0.869926  0.000000        0.00000
REMARK 350   BIOMT3  41  0.000000  0.000000  1.000000       21.15000
REMARK 350   BIOMT1  42  0.991399  0.130872  0.000000        0.00000
REMARK 350   BIOMT2  42 -0.130872  0.991399  0.000000        0.00000
REMARK 350   BIOMT3  42  0.000000  0.000000  1.000000       22.56000
REMARK 350   BIOMT1  43  0.968104 -0.250549  0.000000        0.00000
REMARK 350   BIOMT2  43  0.250549  0.968104  0.000000        0.00000
REMARK 350   BIOMT3  43  0.000000  0.000000  1.000000       23.97000
REMARK 350   BIOMT1  44  0.803441 -0.595384  0.000000        0.00000
REMARK 350   BIOMT2  44  0.595384  0.803441  0.000000        0.00000
REMARK 350   BIOMT3  44  0.000000  0.000000  1.000000       25.38000
REMARK 350   BIOMT1  45  0.521456 -0.853278  0.000000        0.00000
REMARK 350   BIOMT2  45  0.853278  0.521456  0.000000        0.00000
REMARK 350   BIOMT3  45  0.000000  0.000000  1.000000       26.79000
REMARK 350   BIOMT1  46  0.163326 -0.986572  0.000000        0.00000
REMARK 350   BIOMT2  46  0.986572  0.163326  0.000000        0.00000
REMARK 350   BIOMT3  46  0.000000  0.000000  1.000000       28.20000
REMARK 350   BIOMT1  47 -0.218654 -0.975802  0.000000        0.00000
REMARK 350   BIOMT2  47  0.975802 -0.218654  0.000000        0.00000
REMARK 350   BIOMT3  47  0.000000  0.000000  1.000000       29.61000
REMARK 350   BIOMT1  48 -0.568705 -0.822541  0.000000        0.00000
REMARK 350   BIOMT2  48  0.822541 -0.568705  0.000000        0.00000
REMARK 350   BIOMT3  48  0.000000  0.000000  1.000000       31.02000
REMARK 350   BIOMT1  49 -0.835712 -0.549169  0.000000        0.00000
REMARK 350   BIOMT2  49  0.549169 -0.835712  0.000000        0.00000
REMARK 350   BIOMT3  49  0.000000  0.000000  1.000000       32.43000
REMARK 350   BIOMT1  50 -0.980683 -0.195604  0.000000        0.00000
REMARK 350   BIOMT2  50  0.195604 -0.980683  0.000000        0.00000
REMARK 350   BIOMT3  50  0.000000  0.000000  1.000000       33.84000
"""
text_point_group="""
new_ncs_group
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth   18.1267   39.0869   16.3485

new_operator

rota_matrix    0.6235    0.7818    0.0000
rota_matrix   -0.7818    0.6235    0.0000
rota_matrix   -0.0000   -0.0000    1.0000
tran_orth   -14.8728   23.9186    0.0000

center_orth    8.7170   35.2568   16.3490

new_operator

rota_matrix   -0.2225    0.9749    0.0000
rota_matrix   -0.9749   -0.2225    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth    -5.4432   50.4629   -0.0007

center_orth    5.8467   25.5100   16.3495

new_operator

rota_matrix   -0.9010    0.4339   -0.0000
rota_matrix   -0.4339   -0.9010    0.0000
rota_matrix   -0.0000    0.0000    1.0000
tran_orth    21.1858   59.6326    0.0000

center_orth   11.6703   17.1839   16.3485

new_operator

rota_matrix   -0.9010   -0.4339   -0.0000
rota_matrix    0.4339   -0.9010   -0.0000
rota_matrix   -0.0000   -0.0000    1.0000
tran_orth    44.9594   44.5364   -0.0006

center_orth   21.8108   16.5521   16.3495

new_operator

rota_matrix   -0.2225   -0.9749    0.0000
rota_matrix    0.9749   -0.2225   -0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth    47.9895   16.5293    0.0005

center_orth   28.6368   24.0954   16.3473

new_operator

rota_matrix    0.6235   -0.7818    0.0000
rota_matrix    0.7818    0.6235    0.0000
rota_matrix   -0.0000    0.0000    1.0000
tran_orth    27.9737   -3.2911    0.0000

center_orth   26.9919   34.1217   16.3485
"""
text_nothing="""
new_ncs_group
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth   18.1267   39.0869   16.3485

new_operator

rota_matrix    0.6235    0.7818    0.0000
rota_matrix   -0.7818    0.6235    0.0000
rota_matrix   -0.0000   -0.0000    1.0000
tran_orth   -14.8728   23.9186    0.0000

center_orth    8.7170   35.2568   16.3490

new_operator

rota_matrix   -0.2225    0.9749    0.0000
rota_matrix   -0.9749   -0.2225    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth    -5.4432   50.4629   -0.0007

center_orth    5.8467   25.5100   16.3495

new_operator

rota_matrix   -0.9010    0.4339   -0.0000
rota_matrix   -0.4339   -0.9010    0.0000
rota_matrix   -0.0000    0.0000    1.0000
tran_orth    21.1858   59.6326    0.0000

center_orth   11.6703   17.1839   16.3485

new_operator

rota_matrix   -0.9010   -0.4339   -0.0000
rota_matrix    0.4339   -0.9010   -0.0000
rota_matrix   -0.0000   -0.0000    1.0000
tran_orth    44.9594   44.5364   -0.0006

center_orth   21.8108   16.5521   16.3495

new_operator

rota_matrix   -0.2225   -0.9749    0.0000
rota_matrix    0.9749   -0.2225   -0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth    47.9895   16.5293    0.0005

center_orth   28.6368   24.0954   16.3473

"""

text_helical_requires_reordering="""
REMARK 350 MOLECULE CAN BE GENERATED BY APPLYING BIOMT TRANSFORMATIONS
REMARK 350   BIOMT1   1  1.000000  0.000000  0.000000        0.00000
REMARK 350   BIOMT2   1  0.000000  1.000000 -0.000000        0.00000
REMARK 350   BIOMT3   1  0.000000 -0.000000  1.000000        0.00000
REMARK 350   BIOMT1   2  0.923478 -0.383651  0.000000       -0.00000
REMARK 350   BIOMT2   2  0.383651  0.923478 -0.000000        0.00000
REMARK 350   BIOMT3   2  0.000000 -0.000000  1.000000      -67.58400
REMARK 350   BIOMT1   3  0.712149 -0.702029  0.000000       -0.00000
REMARK 350   BIOMT2   3  0.702029  0.712149  0.000000        0.00000
REMARK 350   BIOMT3   3  0.000000 -0.000000  1.000000      -66.17600
REMARK 350   BIOMT1   4  0.396828 -0.917893  0.000000       -0.00000
REMARK 350   BIOMT2   4  0.917893  0.396828  0.000000        0.00000
REMARK 350   BIOMT3   4  0.000000 -0.000000  1.000000      -64.76800
REMARK 350   BIOMT1   5  0.023560 -0.999722  0.000000       -0.00000
REMARK 350   BIOMT2   5  0.999722  0.023560  0.000000        0.00000
REMARK 350   BIOMT3   5  0.000000 -0.000000  1.000000      -63.36000
REMARK 350   BIOMT1   6 -0.353148 -0.935567  0.000000       -0.00000
REMARK 350   BIOMT2   6  0.935567 -0.353148  0.000000        0.00000
REMARK 350   BIOMT3   6  0.000000 -0.000000  1.000000      -61.95200
REMARK 350   BIOMT1   7 -0.678288 -0.734796  0.000000       -0.00000
REMARK 350   BIOMT2   7  0.734796 -0.678288  0.000000        0.00000
REMARK 350   BIOMT3   7  0.000000 -0.000000  1.000000      -60.54400
REMARK 350   BIOMT1   8 -0.904381 -0.426727  0.000000       -0.00000
REMARK 350   BIOMT2   8  0.426727 -0.904381  0.000000        0.00000
REMARK 350   BIOMT3   8 -0.000000 -0.000000  1.000000      -59.13600
REMARK 350   BIOMT1   9 -0.998411 -0.056344  0.000000       -0.00000
REMARK 350   BIOMT2   9  0.056344 -0.998411  0.000000        0.00000
REMARK 350   BIOMT3   9 -0.000000 -0.000000  1.000000      -57.72800
REMARK 350   BIOMT1  10 -0.946649  0.322266 -0.000000       -0.00000
REMARK 350   BIOMT2  10 -0.322266 -0.946649 -0.000000        0.00000
REMARK 350   BIOMT3  10  0.000000  0.000000  1.000000      -56.32000
REMARK 350   BIOMT1  11 -0.756653  0.653817  0.000000       -0.00000
REMARK 350   BIOMT2  11 -0.653817 -0.756653 -0.000000        0.00000
REMARK 350   BIOMT3  11  0.000000  0.000000  1.000000      -54.91200
REMARK 350   BIOMT1  12 -0.456166  0.889895  0.000000       -0.00000
REMARK 350   BIOMT2  12 -0.889895 -0.456166 -0.000000        0.00000
REMARK 350   BIOMT3  12  0.000000  0.000000  1.000000      -53.50400
REMARK 350   BIOMT1  13 -0.089068  0.996026  0.000000       -0.00000
REMARK 350   BIOMT2  13 -0.996026 -0.089068 -0.000000        0.00000
REMARK 350   BIOMT3  13  0.000000  0.000000  1.000000      -52.09600
REMARK 350   BIOMT1  14  0.291036  0.956712  0.000000       -0.00000
REMARK 350   BIOMT2  14 -0.956712  0.291036 -0.000000        0.00000
REMARK 350   BIOMT3  14  0.000000  0.000000  1.000000      -50.68800
REMARK 350   BIOMT1  15  0.628642  0.777695  0.000000       -0.00000
REMARK 350   BIOMT2  15 -0.777695  0.628642 -0.000000        0.00000
REMARK 350   BIOMT3  15  0.000000  0.000000  1.000000      -49.28000
REMARK 350   BIOMT1  16  0.874450  0.485115  0.000000       -0.00000
REMARK 350   BIOMT2  16 -0.485115  0.874450 -0.000000        0.00000
REMARK 350   BIOMT3  16  0.000000 -0.000000  1.000000      -47.87200
REMARK 350   BIOMT1  17  0.992567  0.121696  0.000000       -0.00000
REMARK 350   BIOMT2  17 -0.121696  0.992567 -0.000000        0.00000
REMARK 350   BIOMT3  17  0.000000 -0.000000  1.000000      -46.46400
REMARK 350   BIOMT1  18  0.965745 -0.259493  0.000000       -0.00000
REMARK 350   BIOMT2  18  0.259493  0.965745 -0.000000        0.00000
REMARK 350   BIOMT3  18  0.000000 -0.000000  1.000000      -45.05600
REMARK 350   BIOMT1  19  0.797900 -0.602790  0.000000       -0.00000
REMARK 350   BIOMT2  19  0.602790  0.797900  0.000000        0.00000
REMARK 350   BIOMT3  19  0.000000 -0.000000  1.000000      -43.64800
REMARK 350   BIOMT1  20  0.513541 -0.858065  0.000000       -0.00000
REMARK 350   BIOMT2  20  0.858065  0.513541  0.000000        0.00000
REMARK 350   BIOMT3  20  0.000000 -0.000000  1.000000      -42.24000
REMARK 350   BIOMT1  21  0.154193 -0.988041  0.000000       -0.00000
REMARK 350   BIOMT2  21  0.988041  0.154193  0.000000        0.00000
REMARK 350   BIOMT3  21  0.000000 -0.000000  1.000000      -40.83200
REMARK 350   BIOMT1  22 -0.227671 -0.973738  0.000000       -0.00000
REMARK 350   BIOMT2  22  0.973738 -0.227671  0.000000        0.00000
REMARK 350   BIOMT3  22  0.000000 -0.000000  1.000000      -39.42400
REMARK 350   BIOMT1  23 -0.576290 -0.817245  0.000000       -0.00000
REMARK 350   BIOMT2  23  0.817245 -0.576290  0.000000        0.00000
REMARK 350   BIOMT3  23  0.000000 -0.000000  1.000000      -38.01600
REMARK 350   BIOMT1  24 -0.840756 -0.541415  0.000000       -0.00000
REMARK 350   BIOMT2  24  0.541415 -0.840756  0.000000        0.00000
REMARK 350   BIOMT3  24  0.000000 -0.000000  1.000000      -36.60800
REMARK 350   BIOMT1  25 -0.982450 -0.186524  0.000000       -0.00000
REMARK 350   BIOMT2  25  0.186524 -0.982450  0.000000        0.00000
REMARK 350   BIOMT3  25 -0.000000 -0.000000  1.000000      -35.20000
REMARK 350   BIOMT1  26 -0.980683  0.195604 -0.000000       -0.00000
REMARK 350   BIOMT2  26 -0.195604 -0.980683 -0.000000        0.00000
REMARK 350   BIOMT3  26  0.000000  0.000000  1.000000      -33.79200
REMARK 350   BIOMT1  27 -0.835712  0.549169  0.000000       -0.00000
REMARK 350   BIOMT2  27 -0.549169 -0.835712 -0.000000        0.00000
REMARK 350   BIOMT3  27  0.000000  0.000000  1.000000      -32.38400
REMARK 350   BIOMT1  28 -0.568705  0.822541  0.000000       -0.00000
REMARK 350   BIOMT2  28 -0.822541 -0.568705 -0.000000        0.00000
REMARK 350   BIOMT3  28  0.000000  0.000000  1.000000      -30.97600
REMARK 350   BIOMT1  29 -0.218654  0.975802  0.000000       -0.00000
REMARK 350   BIOMT2  29 -0.975802 -0.218654 -0.000000        0.00000
REMARK 350   BIOMT3  29  0.000000  0.000000  1.000000      -29.56800
REMARK 350   BIOMT1  30  0.163326  0.986572  0.000000       -0.00000
REMARK 350   BIOMT2  30 -0.986572  0.163326 -0.000000        0.00000
REMARK 350   BIOMT3  30  0.000000  0.000000  1.000000      -28.16000
REMARK 350   BIOMT1  31  0.521456  0.853278  0.000000       -0.00000
REMARK 350   BIOMT2  31 -0.853278  0.521456 -0.000000        0.00000
REMARK 350   BIOMT3  31  0.000000  0.000000  1.000000      -26.75200
REMARK 350   BIOMT1  32  0.803441  0.595384  0.000000       -0.00000
REMARK 350   BIOMT2  32 -0.595384  0.803441 -0.000000        0.00000
REMARK 350   BIOMT3  32  0.000000  0.000000  1.000000      -25.34400
REMARK 350   BIOMT1  33  0.968104  0.250549  0.000000       -0.00000
REMARK 350   BIOMT2  33 -0.250549  0.968104 -0.000000        0.00000
REMARK 350   BIOMT3  33  0.000000 -0.000000  1.000000      -23.93600
REMARK 350   BIOMT1  34  0.991399 -0.130872  0.000000       -0.00000
REMARK 350   BIOMT2  34  0.130872  0.991399 -0.000000        0.00000
REMARK 350   BIOMT3  34  0.000000 -0.000000  1.000000      -22.52800
REMARK 350   BIOMT1  35  0.869926 -0.493183  0.000000       -0.00000
REMARK 350   BIOMT2  35  0.493183  0.869926 -0.000000        0.00000
REMARK 350   BIOMT3  35  0.000000 -0.000000  1.000000      -21.12000
REMARK 350   BIOMT1  36  0.621421 -0.783477  0.000000       -0.00000
REMARK 350   BIOMT2  36  0.783477  0.621421  0.000000        0.00000
REMARK 350   BIOMT3  36  0.000000 -0.000000  1.000000      -19.71200
REMARK 350   BIOMT1  37  0.282174 -0.959363  0.000000       -0.00000
REMARK 350   BIOMT2  37  0.959363  0.282174  0.000000        0.00000
REMARK 350   BIOMT3  37  0.000000 -0.000000  1.000000      -18.30400
REMARK 350   BIOMT1  38 -0.098278 -0.995159  0.000000       -0.00000
REMARK 350   BIOMT2  38  0.995159 -0.098278  0.000000        0.00000
REMARK 350   BIOMT3  38  0.000000 -0.000000  1.000000      -16.89600
REMARK 350   BIOMT1  39 -0.464378 -0.885637  0.000000       -0.00000
REMARK 350   BIOMT2  39  0.885637 -0.464378  0.000000       -0.00000
REMARK 350   BIOMT3  39  0.000000 -0.000000  1.000000      -15.48800
REMARK 350   BIOMT1  40 -0.762668 -0.646790  0.000000       -0.00000
REMARK 350   BIOMT2  40  0.646790 -0.762668  0.000000       -0.00000
REMARK 350   BIOMT3  40  0.000000 -0.000000  1.000000      -14.08000
REMARK 350   BIOMT1  41 -0.949590 -0.313495  0.000000       -0.00000
REMARK 350   BIOMT2  41  0.313495 -0.949590  0.000000       -0.00000
REMARK 350   BIOMT3  41 -0.000000 -0.000000  1.000000      -12.67200
REMARK 350   BIOMT1  42 -0.997848  0.065577 -0.000000       -0.00000
REMARK 350   BIOMT2  42 -0.065577 -0.997848 -0.000000       -0.00000
REMARK 350   BIOMT3  42  0.000000  0.000000  1.000000      -11.26400
REMARK 350   BIOMT1  43 -0.900395  0.435074 -0.000000       -0.00000
REMARK 350   BIOMT2  43 -0.435074 -0.900395 -0.000000       -0.00000
REMARK 350   BIOMT3  43  0.000000  0.000000  1.000000       -9.85600
REMARK 350   BIOMT1  44 -0.671462  0.741039  0.000000       -0.00000
REMARK 350   BIOMT2  44 -0.741039 -0.671462 -0.000000       -0.00000
REMARK 350   BIOMT3  44  0.000000  0.000000  1.000000       -8.44800
REMARK 350   BIOMT1  45 -0.344479  0.938794  0.000000       -0.00000
REMARK 350   BIOMT2  45 -0.938794 -0.344479 -0.000000       -0.00000
REMARK 350   BIOMT3  45  0.000000  0.000000  1.000000       -7.04000
REMARK 350   BIOMT1  46  0.032806  0.999462  0.000000       -0.00000
REMARK 350   BIOMT2  46 -0.999462  0.032806 -0.000000       -0.00000
REMARK 350   BIOMT3  46  0.000000  0.000000  1.000000       -5.63200
REMARK 350   BIOMT1  47  0.405301  0.914183  0.000000       -0.00000
REMARK 350   BIOMT2  47 -0.914183  0.405301 -0.000000       -0.00000
REMARK 350   BIOMT3  47  0.000000  0.000000  1.000000       -4.22400
REMARK 350   BIOMT1  48  0.718612  0.695411  0.000000       -0.00000
REMARK 350   BIOMT2  48 -0.695411  0.718612 -0.000000       -0.00000
REMARK 350   BIOMT3  48  0.000000  0.000000  1.000000       -2.81600
REMARK 350   BIOMT1  49  0.926988  0.375092  0.000000       -0.00000
REMARK 350   BIOMT2  49 -0.375092  0.926988 -0.000000        0.00000
REMARK 350   BIOMT3  49  0.000000 -0.000000  1.000000       -1.40800
"""

text_helical_requires_reordering_2="""
REMARK 350 MOLECULE CAN BE GENERATED BY APPLYING BIOMT  TRANSFORMATIONS
REMARK 350   BIOMT1   1  1.000000  0.000000  0.000000        0.00000
REMARK 350   BIOMT2   1  0.000000  1.000000  0.000000        0.00000
REMARK 350   BIOMT3   1  0.000000  0.000000  1.000000        0.00000
REMARK 350   BIOMT1   2 -0.956100  0.293039  0.000000      249.45917
REMARK 350   BIOMT2   2 -0.293039 -0.956100  0.000000      337.37095
REMARK 350   BIOMT3   2  0.000000  0.000000  1.000000      -64.48000
REMARK 350   BIOMT1   3 -0.828842  0.559482  0.000000      190.40401
REMARK 350   BIOMT2   3 -0.559482 -0.828842  0.000000      358.24869
REMARK 350   BIOMT3   3  0.000000  0.000000  1.000000      -63.24000
REMARK 350   BIOMT1   4 -0.629320  0.777146  0.000000      127.82616
REMARK 350   BIOMT2   4 -0.777146 -0.629320  0.000000      360.96995
REMARK 350   BIOMT3   4  0.000000  0.000000  1.000000      -62.00000
REMARK 350   BIOMT1   5 -0.374930  0.927053  0.000000       67.18158
REMARK 350   BIOMT2   5 -0.927053 -0.374930  0.000000      345.29749
REMARK 350   BIOMT3   5  0.000000  0.000000  1.000000      -60.76000
REMARK 350   BIOMT1   6 -0.087851  0.996134  0.000000       13.75764
REMARK 350   BIOMT2   6 -0.996134 -0.087851  0.000000      312.59772
REMARK 350   BIOMT3   6  0.000000  0.000000  1.000000      -59.52000
REMARK 350   BIOMT1   7  0.206887  0.978365  0.000000      -27.78781
REMARK 350   BIOMT2   7 -0.978365  0.206887  0.000000      265.72163
REMARK 350   BIOMT3   7  0.000000  0.000000  1.000000      -58.28000
REMARK 350   BIOMT1   8  0.483588  0.875296  0.000000      -53.83256
REMARK 350   BIOMT2   8 -0.875296  0.483588  0.000000      208.75617
REMARK 350   BIOMT3   8  0.000000  0.000000  1.000000      -57.04000
REMARK 350   BIOMT1   9  0.718126  0.695913  0.000000      -62.10586
REMARK 350   BIOMT2   9 -0.695913  0.718126  0.000000      146.66797
REMARK 350   BIOMT3   9  0.000000  0.000000  1.000000      -55.80000
REMARK 350   BIOMT1  10  0.890054  0.455856  0.000000      -51.88640
REMARK 350   BIOMT2  10 -0.455856  0.890054  0.000000       84.87028
REMARK 350   BIOMT3  10  0.000000  0.000000  1.000000      -54.56000
REMARK 350   BIOMT1  11  0.984381  0.176054  0.000000      -24.06518
REMARK 350   BIOMT2  11 -0.176054  0.984381  0.000000       28.75102
REMARK 350   BIOMT3  11  0.000000  0.000000  1.000000      -53.32000
REMARK 350   BIOMT1  12  0.992883 -0.119097  0.000000       18.93218
REMARK 350   BIOMT2  12  0.119097  0.992883  0.000000      -16.79696
REMARK 350   BIOMT3  12  0.000000  0.000000  1.000000      -52.08000
REMARK 350   BIOMT1  13  0.914819 -0.403865  0.000000       73.35689
REMARK 350   BIOMT2  13  0.403865  0.914819  0.000000      -47.80251
REMARK 350   BIOMT3  13  0.000000  0.000000  1.000000      -50.84000
REMARK 350   BIOMT1  14  0.756995 -0.653421  0.000000      134.46383
REMARK 350   BIOMT2  14  0.653421  0.756995  0.000000      -61.56235
REMARK 350   BIOMT3  14  0.000000  0.000000  1.000000      -49.60000
REMARK 350   BIOMT1  15  0.533172 -0.846007  0.000000      196.92532
REMARK 350   BIOMT2  15  0.846007  0.533172  0.000000      -56.87681
REMARK 350   BIOMT3  15  0.000000  0.000000  1.000000      -48.36000
REMARK 350   BIOMT1  16  0.262863 -0.964833  0.000000      255.29556
REMARK 350   BIOMT2  16  0.964833  0.262863  0.000000      -34.15441
REMARK 350   BIOMT3  16  0.000000  0.000000  1.000000      -47.12000
REMARK 350   BIOMT1  17 -0.030364 -0.999539  0.000000      304.48545
REMARK 350   BIOMT2  17  0.999539 -0.030364  0.000000        4.62377
REMARK 350   BIOMT3  17  0.000000  0.000000  1.000000      -45.88000
REMARK 350   BIOMT1  18 -0.320944 -0.947098  0.000000      340.20629
REMARK 350   BIOMT2  18  0.947098 -0.320944  0.000000       56.07680
REMARK 350   BIOMT3  18  0.000000  0.000000  1.000000      -44.64000
REMARK 350   BIOMT1  19 -0.583541 -0.812084  0.000000      359.34371
REMARK 350   BIOMT2  19  0.812084 -0.583541  0.000000      115.71865
REMARK 350   BIOMT3  19  0.000000  0.000000  1.000000      -43.40000
REMARK 350   BIOMT1  20 -0.795262 -0.606266  0.000000      360.22919
REMARK 350   BIOMT2  20  0.606266 -0.795262  0.000000      178.34938
REMARK 350   BIOMT3  20  0.000000  0.000000  1.000000      -42.16000
REMARK 350   BIOMT1  21 -0.937646 -0.347590  0.000000      342.78553
REMARK 350   BIOMT2  21  0.347590 -0.937646  0.000000      238.50842
REMARK 350   BIOMT3  21  0.000000  0.000000  1.000000      -40.92000
REMARK 350   BIOMT1  22 -0.998281 -0.058609  0.000000      308.53357
REMARK 350   BIOMT2  22  0.058609 -0.998281  0.000000      290.95073
REMARK 350   BIOMT3  22  0.000000  0.000000  1.000000      -39.68000
REMARK 350   BIOMT1  23 -0.971879  0.235481  0.000000      260.45962
REMARK 350   BIOMT2  23 -0.235481 -0.971879  0.000000      331.10404
REMARK 350   BIOMT3  23  0.000000  0.000000  1.000000      -38.44000
REMARK 350   BIOMT1  24 -0.860742  0.509041  0.000000      202.75509
REMARK 350   BIOMT2  24 -0.509041 -0.860742  0.000000      355.46752
REMARK 350   BIOMT3  24  0.000000  0.000000  1.000000      -37.20000
REMARK 350   BIOMT1  25 -0.674560  0.738220  0.000000      140.45103
REMARK 350   BIOMT2  25 -0.738220 -0.674560  0.000000      361.91701
REMARK 350   BIOMT3  25  0.000000  0.000000  1.000000      -35.96000
REMARK 350   BIOMT1  26 -0.429566  0.903036  0.000000       78.97951
REMARK 350   BIOMT2  26 -0.903036 -0.429566  0.000000      349.89019
REMARK 350   BIOMT3  26  0.000000  0.000000  1.000000      -34.72000
REMARK 350   BIOMT1  27 -0.147119  0.989119  0.000000       23.70001
REMARK 350   BIOMT2  27 -0.989119 -0.147119  0.000000      320.43566
REMARK 350   BIOMT3  27  0.000000  0.000000  1.000000      -33.48000
REMARK 350   BIOMT1  28  0.148155  0.988964  0.000000      -20.56783
REMARK 350   BIOMT2  28 -0.988964  0.148155  0.000000      276.12144
REMARK 350   BIOMT3  28  0.000000  0.000000  1.000000      -32.24000
REMARK 350   BIOMT1  29  0.430511  0.902585  0.000000      -49.96446
REMARK 350   BIOMT2  29 -0.902585  0.430511  0.000000      220.81113
REMARK 350   BIOMT3  29  0.000000  0.000000  1.000000      -31.00000
REMARK 350   BIOMT1  30  0.675333  0.737513  0.000000      -61.92689
REMARK 350   BIOMT2  30 -0.737513  0.675333  0.000000      159.32705
REMARK 350   BIOMT3  30  0.000000  0.000000  1.000000      -29.76000
REMARK 350   BIOMT1  31  0.861275  0.508140  0.000000      -55.41216
REMARK 350   BIOMT2  31 -0.508140  0.861275  0.000000       97.02977
REMARK 350   BIOMT3  31  0.000000  0.000000  1.000000      -28.52000
REMARK 350   BIOMT1  32  0.972125  0.234463  0.000000      -30.98826
REMARK 350   BIOMT2  32 -0.234463  0.972125  0.000000       39.35079
REMARK 350   BIOMT3  32  0.000000  0.000000  1.000000      -27.28000
REMARK 350   BIOMT1  33  0.998219 -0.059655  0.000000        9.21536
REMARK 350   BIOMT2  33  0.059655  0.998219  0.000000       -8.68108
REMARK 350   BIOMT3  33  0.000000  0.000000  1.000000      -26.04000
REMARK 350   BIOMT1  34  0.937282 -0.348572  0.000000       61.69351
REMARK 350   BIOMT2  34  0.348572  0.937282  0.000000      -42.87811
REMARK 350   BIOMT3  34  0.000000  0.000000  1.000000      -24.80000
REMARK 350   BIOMT1  35  0.794627 -0.607098  0.000000      121.87079
REMARK 350   BIOMT2  35  0.607098  0.794627  0.000000      -60.25876
REMARK 350   BIOMT3  35  0.000000  0.000000  1.000000      -23.56000
REMARK 350   BIOMT1  36  0.582690 -0.812694  0.000000      184.50055
REMARK 350   BIOMT2  36  0.812694  0.582690  0.000000      -59.30770
REMARK 350   BIOMT3  36  0.000000  0.000000  1.000000      -22.32000
REMARK 350   BIOMT1  37  0.319952 -0.947434  0.000000      244.12234
REMARK 350   BIOMT2  37  0.947434  0.319952  0.000000      -40.10783
REMARK 350   BIOMT3  37  0.000000  0.000000  1.000000      -21.08000
REMARK 350   BIOMT1  38  0.029317 -0.999570  0.000000      295.53792
REMARK 350   BIOMT2  38  0.999570  0.029317  0.000000       -4.33312
REMARK 350   BIOMT3  38  0.000000  0.000000  1.000000      -19.84000
REMARK 350   BIOMT1  39 -0.263873 -0.964557  0.000000      334.26457
REMARK 350   BIOMT2  39  0.964557 -0.263873  0.000000       44.89734
REMARK 350   BIOMT3  39  0.000000  0.000000  1.000000      -18.60000
REMARK 350   BIOMT1  40 -0.534057 -0.845448  0.000000      356.92584
REMARK 350   BIOMT2  40  0.845448 -0.534057  0.000000      103.29134
REMARK 350   BIOMT3  40  0.000000  0.000000  1.000000      -17.36000
REMARK 350   BIOMT1  41 -0.757679 -0.652628  0.000000      361.54596
REMARK 350   BIOMT2  41  0.652628 -0.757679  0.000000      165.75771
REMARK 350   BIOMT3  41  0.000000  0.000000  1.000000      -16.12000
REMARK 350   BIOMT1  42 -0.915241 -0.402906  0.000000      347.72214
REMARK 350   BIOMT2  42  0.402906 -0.915241  0.000000      226.85021
REMARK 350   BIOMT3  42  0.000000  0.000000  1.000000      -14.88000
REMARK 350   BIOMT1  43 -0.993007 -0.118057  0.000000      316.65962
REMARK 350   BIOMT2  43  0.118057 -0.993007  0.000000      281.24241
REMARK 350   BIOMT3  43  0.000000  0.000000  1.000000      -13.64000
REMARK 350   BIOMT1  44 -0.984196  0.177085  0.000000      271.06663
REMARK 350   BIOMT2  44 -0.177085 -0.984196  0.000000      324.19205
REMARK 350   BIOMT3  44  0.000000  0.000000  1.000000      -12.40000
REMARK 350   BIOMT1  45 -0.889576  0.456787  0.000000      214.91827
REMARK 350   BIOMT2  45 -0.456787 -0.889576  0.000000      351.95450
REMARK 350   BIOMT3  45  0.000000  0.000000  1.000000      -11.16000
REMARK 350   BIOMT1  46 -0.717397  0.696664  0.000000      153.10991
REMARK 350   BIOMT2  46 -0.696664 -0.717397  0.000000      362.10924
REMARK 350   BIOMT3  46  0.000000  0.000000  1.000000       -9.92000
REMARK 350   BIOMT1  47 -0.482671  0.875802  0.000000       91.03041
REMARK 350   BIOMT2  47 -0.875802 -0.482671  0.000000      353.77092
REMARK 350   BIOMT3  47  0.000000  0.000000  1.000000       -8.68000
REMARK 350   BIOMT1  48 -0.205863  0.978581  0.000000       34.09226
REMARK 350   BIOMT2  48 -0.978581 -0.205863  0.000000      327.66653
REMARK 350   BIOMT3  48  0.000000  0.000000  1.000000       -7.44000
REMARK 350   BIOMT1  49  0.088894  0.996041  0.000000      -12.74030
REMARK 350   BIOMT2  49 -0.996041  0.088894  0.000000      286.07202
REMARK 350   BIOMT3  49  0.000000  0.000000  1.000000       -6.20000
REMARK 350   BIOMT1  50  0.375901  0.926660  0.000000      -45.38411
REMARK 350   BIOMT2  50 -0.926660  0.375901  0.000000      232.61386
REMARK 350   BIOMT3  50  0.000000  0.000000  1.000000       -4.96000
REMARK 350   BIOMT1  51  0.630134  0.776487  0.000000      -60.99306
REMARK 350   BIOMT2  51 -0.776487  0.630134  0.000000      171.95290
REMARK 350   BIOMT3  51  0.000000  0.000000  1.000000       -3.72000
REMARK 350   BIOMT1  52  0.829428  0.558614  0.000000      -58.20626
REMARK 350   BIOMT2  52 -0.558614  0.829428  0.000000      109.37793
REMARK 350   BIOMT3  52  0.000000  0.000000  1.000000       -2.48000
REMARK 350   BIOMT1  53  0.956407  0.292038  0.000000      -37.26669
REMARK 350   BIOMT2  53 -0.292038  0.956407  0.000000       50.34467
REMARK 350   BIOMT3  53  0.000000  0.000000  1.000000       -1.24000
REMARK 350   BIOMT1  54  0.956407 -0.292038  0.000000       50.34467
REMARK 350   BIOMT2  54  0.292038  0.956407  0.000000      -37.26669
REMARK 350   BIOMT3  54  0.000000  0.000000  1.000000        1.24000
REMARK 350   BIOMT1  55  0.829428 -0.558614  0.000000      109.37793
REMARK 350   BIOMT2  55  0.558614  0.829428  0.000000      -58.20626
REMARK 350   BIOMT3  55  0.000000  0.000000  1.000000        2.48000
REMARK 350   BIOMT1  56  0.630134 -0.776487  0.000000      171.95290
REMARK 350   BIOMT2  56  0.776487  0.630134  0.000000      -60.99306
REMARK 350   BIOMT3  56  0.000000  0.000000  1.000000        3.72000
REMARK 350   BIOMT1  57  0.375901 -0.926660  0.000000      232.61386
REMARK 350   BIOMT2  57  0.926660  0.375901  0.000000      -45.38411
REMARK 350   BIOMT3  57  0.000000  0.000000  1.000000        4.96000
REMARK 350   BIOMT1  58  0.088894 -0.996041  0.000000      286.07202
REMARK 350   BIOMT2  58  0.996041  0.088894  0.000000      -12.74030
REMARK 350   BIOMT3  58  0.000000  0.000000  1.000000        6.20000
REMARK 350   BIOMT1  59 -0.205863 -0.978581  0.000000      327.66653
REMARK 350   BIOMT2  59  0.978581 -0.205863  0.000000       34.09226
REMARK 350   BIOMT3  59  0.000000  0.000000  1.000000        7.44000
REMARK 350   BIOMT1  60 -0.482671 -0.875802  0.000000      353.77092
REMARK 350   BIOMT2  60  0.875802 -0.482671  0.000000       91.03041
REMARK 350   BIOMT3  60  0.000000  0.000000  1.000000        8.68000
REMARK 350   BIOMT1  61 -0.717397 -0.696664  0.000000      362.10924
REMARK 350   BIOMT2  61  0.696664 -0.717397  0.000000      153.10991
REMARK 350   BIOMT3  61  0.000000  0.000000  1.000000        9.92000
REMARK 350   BIOMT1  62 -0.889576 -0.456787  0.000000      351.95450
REMARK 350   BIOMT2  62  0.456787 -0.889576  0.000000      214.91827
REMARK 350   BIOMT3  62  0.000000  0.000000  1.000000       11.16000
REMARK 350   BIOMT1  63 -0.984196 -0.177085  0.000000      324.19205
REMARK 350   BIOMT2  63  0.177085 -0.984196  0.000000      271.06663
REMARK 350   BIOMT3  63  0.000000  0.000000  1.000000       12.40000
REMARK 350   BIOMT1  64 -0.993007  0.118057  0.000000      281.24241
REMARK 350   BIOMT2  64 -0.118057 -0.993007  0.000000      316.65962
REMARK 350   BIOMT3  64  0.000000  0.000000  1.000000       13.64000
REMARK 350   BIOMT1  65 -0.915241  0.402906  0.000000      226.85021
REMARK 350   BIOMT2  65 -0.402906 -0.915241  0.000000      347.72214
REMARK 350   BIOMT3  65  0.000000  0.000000  1.000000       14.88000
REMARK 350   BIOMT1  66 -0.757679  0.652628  0.000000      165.75771
REMARK 350   BIOMT2  66 -0.652628 -0.757679  0.000000      361.54596
REMARK 350   BIOMT3  66  0.000000  0.000000  1.000000       16.12000
REMARK 350   BIOMT1  67 -0.534057  0.845448  0.000000      103.29134
REMARK 350   BIOMT2  67 -0.845448 -0.534057  0.000000      356.92584
REMARK 350   BIOMT3  67  0.000000  0.000000  1.000000       17.36000
REMARK 350   BIOMT1  68 -0.263873  0.964557  0.000000       44.89734
REMARK 350   BIOMT2  68 -0.964557 -0.263873  0.000000      334.26457
REMARK 350   BIOMT3  68  0.000000  0.000000  1.000000       18.60000
REMARK 350   BIOMT1  69  0.029317  0.999570  0.000000       -4.33312
REMARK 350   BIOMT2  69 -0.999570  0.029317  0.000000      295.53792
REMARK 350   BIOMT3  69  0.000000  0.000000  1.000000       19.84000
REMARK 350   BIOMT1  70  0.319952  0.947434  0.000000      -40.10783
REMARK 350   BIOMT2  70 -0.947434  0.319952  0.000000      244.12234
REMARK 350   BIOMT3  70  0.000000  0.000000  1.000000       21.08000
REMARK 350   BIOMT1  71  0.582690  0.812694  0.000000      -59.30770
REMARK 350   BIOMT2  71 -0.812694  0.582690  0.000000      184.50055
REMARK 350   BIOMT3  71  0.000000  0.000000  1.000000       22.32000
REMARK 350   BIOMT1  72  0.794627  0.607098  0.000000      -60.25876
REMARK 350   BIOMT2  72 -0.607098  0.794627  0.000000      121.87079
REMARK 350   BIOMT3  72  0.000000  0.000000  1.000000       23.56000
REMARK 350   BIOMT1  73  0.937282  0.348572  0.000000      -42.87811
REMARK 350   BIOMT2  73 -0.348572  0.937282  0.000000       61.69351
REMARK 350   BIOMT3  73  0.000000  0.000000  1.000000       24.80000
REMARK 350   BIOMT1  74  0.998219  0.059655  0.000000       -8.68108
REMARK 350   BIOMT2  74 -0.059655  0.998219  0.000000        9.21536
REMARK 350   BIOMT3  74  0.000000  0.000000  1.000000       26.04000
REMARK 350   BIOMT1  75  0.972125 -0.234463  0.000000       39.35079
REMARK 350   BIOMT2  75  0.234463  0.972125  0.000000      -30.98826
REMARK 350   BIOMT3  75  0.000000  0.000000  1.000000       27.28000
REMARK 350   BIOMT1  76  0.861275 -0.508140  0.000000       97.02977
REMARK 350   BIOMT2  76  0.508140  0.861275  0.000000      -55.41216
REMARK 350   BIOMT3  76  0.000000  0.000000  1.000000       28.52000
REMARK 350   BIOMT1  77  0.675333 -0.737513  0.000000      159.32705
REMARK 350   BIOMT2  77  0.737513  0.675333  0.000000      -61.92689
REMARK 350   BIOMT3  77  0.000000  0.000000  1.000000       29.76000
REMARK 350   BIOMT1  78  0.430511 -0.902585  0.000000      220.81113
REMARK 350   BIOMT2  78  0.902585  0.430511  0.000000      -49.96446
REMARK 350   BIOMT3  78  0.000000  0.000000  1.000000       31.00000
REMARK 350   BIOMT1  79  0.148155 -0.988964  0.000000      276.12144
REMARK 350   BIOMT2  79  0.988964  0.148155  0.000000      -20.56783
REMARK 350   BIOMT3  79  0.000000  0.000000  1.000000       32.24000
REMARK 350   BIOMT1  80 -0.147119 -0.989119  0.000000      320.43566
REMARK 350   BIOMT2  80  0.989119 -0.147119  0.000000       23.70001
REMARK 350   BIOMT3  80  0.000000  0.000000  1.000000       33.48000
REMARK 350   BIOMT1  81 -0.429566 -0.903036  0.000000      349.89019
REMARK 350   BIOMT2  81  0.903036 -0.429566  0.000000       78.97951
REMARK 350   BIOMT3  81  0.000000  0.000000  1.000000       34.72000
REMARK 350   BIOMT1  82 -0.674560 -0.738220  0.000000      361.91701
REMARK 350   BIOMT2  82  0.738220 -0.674560  0.000000      140.45103
REMARK 350   BIOMT3  82  0.000000  0.000000  1.000000       35.96000
REMARK 350   BIOMT1  83 -0.860742 -0.509041  0.000000      355.46752
REMARK 350   BIOMT2  83  0.509041 -0.860742  0.000000      202.75509
REMARK 350   BIOMT3  83  0.000000  0.000000  1.000000       37.20000
REMARK 350   BIOMT1  84 -0.971879 -0.235481  0.000000      331.10404
REMARK 350   BIOMT2  84  0.235481 -0.971879  0.000000      260.45962
REMARK 350   BIOMT3  84  0.000000  0.000000  1.000000       38.44000
REMARK 350   BIOMT1  85 -0.998281  0.058609  0.000000      290.95073
REMARK 350   BIOMT2  85 -0.058609 -0.998281  0.000000      308.53357
REMARK 350   BIOMT3  85  0.000000  0.000000  1.000000       39.68000
REMARK 350   BIOMT1  86 -0.937646  0.347590  0.000000      238.50842
REMARK 350   BIOMT2  86 -0.347590 -0.937646  0.000000      342.78553
REMARK 350   BIOMT3  86  0.000000  0.000000  1.000000       40.92000
REMARK 350   BIOMT1  87 -0.795262  0.606266  0.000000      178.34938
REMARK 350   BIOMT2  87 -0.606266 -0.795262  0.000000      360.22919
REMARK 350   BIOMT3  87  0.000000  0.000000  1.000000       42.16000
REMARK 350   BIOMT1  88 -0.583541  0.812084  0.000000      115.71865
REMARK 350   BIOMT2  88 -0.812084 -0.583541  0.000000      359.34371
REMARK 350   BIOMT3  88  0.000000  0.000000  1.000000       43.40000
REMARK 350   BIOMT1  89 -0.320944  0.947098  0.000000       56.07680
REMARK 350   BIOMT2  89 -0.947098 -0.320944  0.000000      340.20629
REMARK 350   BIOMT3  89  0.000000  0.000000  1.000000       44.64000
REMARK 350   BIOMT1  90 -0.030364  0.999539  0.000000        4.62377
REMARK 350   BIOMT2  90 -0.999539 -0.030364  0.000000      304.48545
REMARK 350   BIOMT3  90  0.000000  0.000000  1.000000       45.88000
REMARK 350   BIOMT1  91  0.262863  0.964833  0.000000      -34.15441
REMARK 350   BIOMT2  91 -0.964833  0.262863  0.000000      255.29556
REMARK 350   BIOMT3  91  0.000000  0.000000  1.000000       47.12000
REMARK 350   BIOMT1  92  0.533172  0.846007  0.000000      -56.87681
REMARK 350   BIOMT2  92 -0.846007  0.533172  0.000000      196.92532
REMARK 350   BIOMT3  92  0.000000  0.000000  1.000000       48.36000
REMARK 350   BIOMT1  93  0.756995  0.653421  0.000000      -61.56235
REMARK 350   BIOMT2  93 -0.653421  0.756995  0.000000      134.46383
REMARK 350   BIOMT3  93  0.000000  0.000000  1.000000       49.60000
REMARK 350   BIOMT1  94  0.914819  0.403865  0.000000      -47.80251
REMARK 350   BIOMT2  94 -0.403865  0.914819  0.000000       73.35689
REMARK 350   BIOMT3  94  0.000000  0.000000  1.000000       50.84000
REMARK 350   BIOMT1  95  0.992883  0.119097  0.000000      -16.79696
REMARK 350   BIOMT2  95 -0.119097  0.992883  0.000000       18.93218
REMARK 350   BIOMT3  95  0.000000  0.000000  1.000000       52.08000
REMARK 350   BIOMT1  96  0.984381 -0.176054  0.000000       28.75102
REMARK 350   BIOMT2  96  0.176054  0.984381  0.000000      -24.06518
REMARK 350   BIOMT3  96  0.000000  0.000000  1.000000       53.32000
REMARK 350   BIOMT1  97  0.890054 -0.455856  0.000000       84.87028
REMARK 350   BIOMT2  97  0.455856  0.890054  0.000000      -51.88640
REMARK 350   BIOMT3  97  0.000000  0.000000  1.000000       54.56000
REMARK 350   BIOMT1  98  0.718126 -0.695913  0.000000      146.66797
REMARK 350   BIOMT2  98  0.695913  0.718126  0.000000      -62.10586
REMARK 350   BIOMT3  98  0.000000  0.000000  1.000000       55.80000
REMARK 350   BIOMT1  99  0.483588 -0.875296  0.000000      208.75617
REMARK 350   BIOMT2  99  0.875296  0.483588  0.000000      -53.83256
REMARK 350   BIOMT3  99  0.000000  0.000000  1.000000       57.04000
REMARK 350   BIOMT1 100  0.206887 -0.978365  0.000000      265.72163
REMARK 350   BIOMT2 100  0.978365  0.206887  0.000000      -27.78781
REMARK 350   BIOMT3 100  0.000000  0.000000  1.000000       58.28000
REMARK 350   BIOMT1 101 -0.087851 -0.996134  0.000000      312.59772
REMARK 350   BIOMT2 101  0.996134 -0.087851  0.000000       13.75764
REMARK 350   BIOMT3 101  0.000000  0.000000  1.000000       59.52000
REMARK 350   BIOMT1 102 -0.374930 -0.927053  0.000000      345.29749
REMARK 350   BIOMT2 102  0.927053 -0.374930  0.000000       67.18158
REMARK 350   BIOMT3 102  0.000000  0.000000  1.000000       60.76000
REMARK 350   BIOMT1 103 -0.629320 -0.777146  0.000000      360.96995
REMARK 350   BIOMT2 103  0.777146 -0.629320  0.000000      127.82616
REMARK 350   BIOMT3 103  0.000000  0.000000  1.000000       62.00000
REMARK 350   BIOMT1 104 -0.828842 -0.559482  0.000000      358.24869
REMARK 350   BIOMT2 104  0.559482 -0.828842  0.000000      190.40401
REMARK 350   BIOMT3 104  0.000000  0.000000  1.000000       63.24000
REMARK 350   BIOMT1 105 -0.956100 -0.293039  0.000000      337.37095
REMARK 350   BIOMT2 105  0.293039 -0.956100  0.000000      249.45917
REMARK 350   BIOMT3 105  0.000000  0.000000  1.000000       64.48000
REMARK 350   BIOMT1 106 -0.999999 -0.001047  0.000000      300.15700
REMARK 350   BIOMT2 106  0.001047 -0.999999  0.000000      299.84284
REMARK 350   BIOMT3 106  0.000000  0.000000  1.000000       65.72000

"""

text_helical_short="""
new_operator

rota_matrix    0.9270    0.3751    0.0000
rota_matrix   -0.3751    0.9270    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000   -1.4100

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    1.0000   -0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000   -0.0000

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    0.9270   -0.3751    0.0000
rota_matrix    0.3751    0.9270    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    1.4100

center_orth    0.0000    0.0000    0.0000
"""

text_helical_short_a="""
new_operator

rota_matrix    1.0000    0.0000   -0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    0.9270    0.3751   -0.0000
rota_matrix   -0.3751    0.9270    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth     0.0000    0.0000   -1.4100

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    0.7186    0.6954   -0.0000
rota_matrix   -0.6954    0.7186    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth     0.0000    0.0000   -2.8200

center_orth    0.0000    0.0000    0.0000
"""

text_helical_short_b="""
new_operator

rota_matrix    0.7186   -0.6954    0.0000
rota_matrix    0.6954    0.7186   -0.0000
rota_matrix   -0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    2.8200

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    0.9270   -0.3751    0.0000
rota_matrix    0.3751    0.9270   -0.0000
rota_matrix   -0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    1.4100

center_orth    0.0000    0.0000    0.0000
new_operator

rota_matrix    1.0000    0.0000   -0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000   -0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth    0.0000    0.0000    0.0000
"""
def tst_02():

  print("Test short helical and point_group symmetry...", end=' ')
  from mmtbx.ncs.ncs import ncs
  f=open('helical.ncs_spec','w')
  print(text_helical_short, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()
  print("OK")

  print("Test helical and point_group symmetry...", end=' ')
  from mmtbx.ncs.ncs import ncs
  f=open('helical.ncs_spec','w')
  print(text_helical, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()

  f=open('point_group.ncs_spec','w')
  print(text_point_group, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('point_group.ncs_spec',quiet=True)
  assert not ncs_object.is_helical_along_z()
  assert ncs_object.is_point_group_symmetry()

  f=open('nothing.ncs_spec','w')
  print(text_nothing, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('nothing.ncs_spec',quiet=True)
  assert not ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()

  f=open('helical_requires_reordering.ncs_spec','w')
  print(text_helical_requires_reordering, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical_requires_reordering.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()

  f=open('helical_requires_reordering_2.ncs_spec','w')
  print(text_helical_requires_reordering_2, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical_requires_reordering_2.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()
  print("OK")

  print("Test helical extending z_range...", end=' ')
  from mmtbx.ncs.ncs import ncs
  f=open('helical.ncs_spec','w')
  print(text_helical_short, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  ncs_object.invert_matrices()
  assert ncs_object.is_helical_along_z()
  ncs_group=ncs_object.ncs_groups()[0]
  r_forwards,t_forwards=ncs_group.helix_rt_forwards()
  found=False
  from mmtbx.ncs.ncs import is_same_transform
  for r2,t2 in zip(
    ncs_group.rota_matrices_inv(),ncs_group.translations_orth_inv()):
     if is_same_transform(r_forwards,t_forwards,r2,t2):
       found=True
       break
  assert found
  ncs_group.extend_helix_operators(z_range=40)
  assert ncs_group.n_ncs_oper()==57
  assert ncs_group.is_helical_along_z()

  print("OK")


def tst_02a():

  print("Test short helical and point_group symmetry with identity at start...", end=' ')
  from mmtbx.ncs.ncs import ncs
  f=open('helical.ncs_spec','w')
  print(text_helical_short_a, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()
  print("OK")

def tst_02b():

  print("Test short helical and point_group symmetry with identity at end...", end=' ')
  from mmtbx.ncs.ncs import ncs
  f=open('helical.ncs_spec','w')
  print(text_helical_short_b, file=f)
  f.close()
  ncs_object=ncs()
  ncs_object.read_ncs('helical.ncs_spec',quiet=True)
  assert ncs_object.is_helical_along_z()
  assert not ncs_object.is_point_group_symmetry()
  print("OK")


text2="""
Summary of NCS information
Wed Dec 30 10:36:10 2015
/Users/terwill/unix/misc/cryo/emd_3063

source_info temp_dir/pseudo_ha.pdb




new_ncs_group
NCS_CC 0.99
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth    -0.0000   -0.0000   -0.0000

center_orth  -72.7684  -30.3322  -82.7957
new_operator

rota_matrix   -1.0000   -0.0023   -0.0059
rota_matrix    0.0024   -0.9998   -0.0209
rota_matrix   -0.0059   -0.0209    0.9998
tran_orth    -1.9886   -2.6166    1.3404

center_orth   71.2074   29.6271  -83.1177
new_operator

rota_matrix    0.0108   -0.9999    0.0007
rota_matrix    0.9997    0.0108   -0.0241
rota_matrix    0.0241    0.0009    0.9997
tran_orth    -0.7179   -2.8574    0.9201

center_orth  -30.2612   71.6728  -83.0767
new_operator

rota_matrix   -0.0108    0.9999    0.0018
rota_matrix   -0.9997   -0.0108   -0.0241
rota_matrix   -0.0241   -0.0021    0.9997
tran_orth     0.4240   -3.6743    0.8246

center_orth   29.4566  -72.7242  -83.0880
"""

expected_text2="""
source_info temp_dir/pseudo_ha.pdb




new_ncs_group
NCS_CC 0.99
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth  100.9116  143.3478  102.3243
new_operator

rota_matrix   -1.0000   -0.0023   -0.0059
rota_matrix    0.0024   -0.9998   -0.0209
rota_matrix   -0.0059   -0.0209    0.9998
tran_orth   172.7836  174.9324    1.3774

center_orth   71.2074   29.6271  102.0023
new_operator

rota_matrix    0.0108   -0.9999    0.0007
rota_matrix    0.9997    0.0108   -0.0241
rota_matrix    0.0241    0.0009    0.9997
tran_orth   170.9568    1.6561   -3.2101

center_orth  143.4188   71.6728  102.0433
new_operator

rota_matrix   -0.0108    0.9999    0.0018
rota_matrix   -0.9997   -0.0108   -0.0241
rota_matrix   -0.0241   -0.0021    0.9997
tran_orth     0.1082  176.3428    1.2449

center_orth   29.4566  100.9558  102.0320
"""

expected_text2b="""
Summary of NCS information
Wed Dec 30 19:56:31 2015
/Users/terwill/unix/misc/junk

source_info temp_dir/pseudo_ha.pdb




new_ncs_group
NCS_CC 0.99
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth     0.0000    0.0000    0.0000

center_orth   27.2316   69.6678  -182.7957
new_operator

rota_matrix   -1.0000   -0.0023   -0.0059
rota_matrix    0.0024   -0.9998   -0.0209
rota_matrix   -0.0059   -0.0209    0.9998
tran_orth   197.6514  195.0334    4.0004

center_orth  171.2074  129.6271  -183.1177
new_operator

rota_matrix    0.0108   -0.9999    0.0007
rota_matrix    0.9997    0.0108   -0.0241
rota_matrix    0.0241    0.0009    0.9997
tran_orth   198.2621   -6.3174   -1.6099

center_orth   69.7388  171.6728  -183.0767
new_operator

rota_matrix   -0.0108    0.9999    0.0018
rota_matrix   -0.9997   -0.0108   -0.0241
rota_matrix   -0.0241   -0.0021    0.9997
tran_orth     1.6940  194.9657    3.4146

center_orth  129.4566   27.2758  -183.0880
"""

expected_text2c="""
Summary of NCS information
Fri May 20 15:01:59 2016
/Users/terwill/Desktop/working/Jan_2015/phenix/cryo-pdb/3j9c/build

source_info temp_dir/pseudo_ha.pdb




new_ncs_group
NCS_CC 0.99
new_operator

rota_matrix    1.0000    0.0000    0.0000
rota_matrix    0.0000    1.0000    0.0000
rota_matrix    0.0000    0.0000    1.0000
tran_orth    -0.0000   -0.0000   -0.0000

center_orth  -36.3842  -15.1661  -41.3978
new_operator

rota_matrix   -1.0000   -0.0023   -0.0059
rota_matrix    0.0024   -0.9998   -0.0209
rota_matrix   -0.0059   -0.0209    0.9998
tran_orth    -0.9943   -1.3083    0.6702

center_orth   35.6037   14.8135  -41.5588
new_operator

rota_matrix    0.0108   -0.9999    0.0007
rota_matrix    0.9997    0.0108   -0.0241
rota_matrix    0.0241    0.0009    0.9997
tran_orth    -0.3589   -1.4287    0.4601

center_orth  -15.1306   35.8364  -41.5384
new_operator

rota_matrix   -0.0108    0.9999    0.0018
rota_matrix   -0.9997   -0.0108   -0.0241
rota_matrix   -0.0241   -0.0021    0.9997
tran_orth     0.2120   -1.8372    0.4123

center_orth   14.7283  -36.3621  -41.5440
"""
def tst_03():
  print("Map NCS operators to place them in (0,1)")

  f=open('ncs.ncs_spec','w')
  print(text2, file=f)
  f.close()


  from mmtbx.ncs.ncs import ncs
  ncs_object=ncs()
  ncs_object.read_ncs('ncs.ncs_spec',quiet=True)

  from cctbx import uctbx
  uc=uctbx.unit_cell((173.680,173.680,185.120,90.00,90.00,90.00))
  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  start_text=f.getvalue()
  ncs_object.map_inside_unit_cell(unit_cell=uc)
  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  found_text=f.getvalue()

  if remove_blank(" ".join(found_text.split("source_info")[1:]) ) != \
     remove_blank(" ".join(expected_text2.split("source_info")[1:])):
    print("Expected: \n%s \nFound: \n%s" %(expected_text_group_specification,found_text))
    raise AssertionError("FAILED")


  print("OK")

def tst_04():
  print("Offset NCS operators")

  f=open('ncs.ncs_spec','w')
  print(text2, file=f)
  f.close()


  from mmtbx.ncs.ncs import ncs
  ncs_object=ncs()
  ncs_object.read_ncs('ncs.ncs_spec',quiet=True)

  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  start_text=f.getvalue()
  ncs_object=ncs_object.coordinate_offset(coordinate_offset=(100.,100.,-100.))
  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  found_text=f.getvalue()

  if remove_blank(" ".join(found_text.split("source_info")[1:]) ) != \
     remove_blank(" ".join(expected_text2b.split("source_info")[1:])):
    print("Expected: \n%s \nFound: \n%s" %(expected_text_group_specification,found_text))
    raise AssertionError("FAILED")


  print("OK")

def tst_05():
  print("Magnify NCS operators")

  f=open('ncs.ncs_spec','w')
  print(text2, file=f)
  f.close()


  from mmtbx.ncs.ncs import ncs
  ncs_object=ncs()
  ncs_object.read_ncs('ncs.ncs_spec',quiet=True)

  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  start_text=f.getvalue()
  ncs_object.adjust_magnification(magnification=0.5)
  f=StringIO()
  ncs_object.format_all_for_group_specification(out=f)
  found_text=f.getvalue()

  if remove_blank(" ".join(found_text.split("source_info")[1:]) ) != \
     remove_blank(" ".join(expected_text2c.split("source_info")[1:])):
    print("Expected: \n%s \nFound: \n%s" %(expected_text2c,found_text))
    raise AssertionError("FAILED")


  print("OK")

expected_text6="""
  11.70    22.34   39.00  ::   11.70    22.34   39.00
   4.80    50.92   39.00  ::    4.80    50.92   39.00
 -16.50    30.66   39.00  ::  -16.50    30.66   39.00
  41.70     5.02    5.67  ::   41.70     5.02    5.67
  34.80    33.60    5.67  ::   34.80    33.60    5.67
  13.50    13.34    5.67  ::   13.50    13.34    5.67
 -18.30    39.66   72.33  ::  -18.30    39.66   72.33
   4.80    16.28   72.33  ::    4.80    16.28   72.33
  13.50    47.98   72.33  ::   13.50    47.98   72.33
"""
def tst_06():
  print("Convert space group operators to NCS operators")

  from mmtbx.ncs.ncs import crystal_symmetry_to_ncs
  from cctbx import crystal
  from cctbx import sgtbx
  from cctbx import uctbx
  from scitbx import matrix
  from cctbx.array_family import flex

  SpaceGroup=sgtbx.space_group_info(symbol=str('h3'))
  unit_cell=uctbx.unit_cell((60.,60.,100.,90.,90.,120.,))
  crystal_symmetry=crystal.symmetry(
  unit_cell=unit_cell,space_group_info=SpaceGroup)

  ncs_obj=crystal_symmetry_to_ncs(crystal_symmetry)

  # apply ncs or apply crystal symmetry and make sure we get same answer.
  xyz_fract=matrix.col((0.41,0.43,0.39))

  sites_fract=flex.vec3_double()
  sites_fract.append(xyz_fract)

  sites_cart=crystal_symmetry.unit_cell().orthogonalize(sites_fract)

  ncs_group=ncs_obj.ncs_groups()[0]
  ncs_sites_cart=flex.vec3_double()
  for xyz_cart in sites_cart:
      for i0 in range(len(ncs_group.translations_orth())):
        r=ncs_group.rota_matrices_inv()[i0] # inverse maps pos 0 on to pos i
        t=ncs_group.translations_orth_inv()[i0]
        new_xyz_cart=r * matrix.col(xyz_cart) + t
        ncs_sites_cart.append(new_xyz_cart)

  cryst_sites_frac=flex.vec3_double()
  from mmtbx.ncs.ncs import offset_inside_cell
  for xyz_frac in sites_fract:
    for rt_mx in crystal_symmetry.space_group().all_ops():
      xyz_frac_ncs=rt_mx*xyz_frac
      coordinate_offset=matrix.col(offset_inside_cell(xyz_frac_ncs,
        unit_cell=crystal_symmetry.unit_cell(),orthogonalize=False))
      cryst_sites_frac.append(matrix.col(xyz_frac_ncs)+coordinate_offset)
  cryst_sites_cart=crystal_symmetry.unit_cell().orthogonalize(cryst_sites_frac)

  f=StringIO()

  for ncs_xx,cryst_xx in zip(ncs_sites_cart,cryst_sites_cart):
    text= "%7.2f  %7.2f %7.2f  :: %7.2f  %7.2f %7.2f " %(
       tuple(list(ncs_xx)+list(cryst_xx)))
    print(text, file=f)
    assert "%7.2f  %7.2f %7.2f" %(ncs_xx) == "%7.2f  %7.2f %7.2f" %(cryst_xx)

  found_text=f.getvalue()

  if remove_blank(found_text) != remove_blank(expected_text6):
    print("Expected: \n%s \nFound: \n%s" %(expected_text6,found_text))
    raise AssertionError("FAILED")

  print("OK")

def tst_07():
  print("Generate operators for point-group symmetries")
  from mmtbx.ncs.ncs import generate_ncs_ops
  ncs_list=generate_ncs_ops(symmetry="ALL",op_max=3,
    out=sys.stdout)
  helical_ncs_list=generate_ncs_ops(symmetry="helical",helical_rot_deg=23,
    helical_trans_z_angstrom=8, max_helical_ops_to_check=5,
    out=sys.stdout)
  ncs_list+=helical_ncs_list

  name_and_ops_list=[]
  for ncs_obj in ncs_list:
    print(ncs_obj.get_ncs_name(),ncs_obj.max_operators())
    assert ncs_obj.is_helical_along_z() or ncs_obj.is_point_group_symmetry()
    #print ncs_obj.is_helical_along_z() or ncs_obj.is_point_group_symmetry()
    from six.moves import cStringIO as StringIO
    f=StringIO()
    ncs_obj.display_all(log=f)
    text=f.getvalue()
    #print text
    name_and_ops_list.append([ncs_obj.get_ncs_name(),ncs_obj.max_operators()])

  print(name_and_ops_list)
  assert name_and_ops_list==[['I (b)', 60], ['I (d)', 60], ['I (f)', 60], ['I (a)', 60], ['I (c)', 60], ['I (e)', 60], ['O (a)', 24], ['O (b)', 24], ['T (a)', 12], ['T (b)', 12], ['T (c)', 12], ['C2 ', 2], ['C3 ', 3], ['D2 (a)', 4], ['D2 (b)', 4], ['D3 (a)', 6], ['D3 (b)', 6], ['Helical 23.00 deg    8.00 Z-trans ', 5]]


  print("OK")



if __name__=="__main__":
  tst_07()
  tst_01()
  tst_02()
  tst_02a()
  tst_02b()
  tst_03()
  tst_04()
  tst_05()
  tst_06()

