// Copyright © 2015-2017 winapi-rs developers
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use ctypes::c_void;
use shared::basetsd::{INT8, LONG_PTR, SIZE_T, UINT16, UINT64, UINT8};
use shared::dxgiformat::DXGI_FORMAT;
use shared::dxgitype::DXGI_SAMPLE_DESC;
use shared::guiddef::{IID, REFGUID, REFIID};
use shared::minwindef::{BOOL, BYTE, DWORD, FLOAT, INT, LPCVOID, UINT};
use shared::windef::RECT;
use um::d3dcommon::{D3D_FEATURE_LEVEL, D3D_PRIMITIVE, D3D_PRIMITIVE_TOPOLOGY, ID3DBlob};
use um::minwinbase::SECURITY_ATTRIBUTES;
use um::unknwnbase::{IUnknown, IUnknownVtbl};
use um::winnt::{HANDLE, HRESULT, LPCSTR, LPCWSTR, LUID};
pub const D3D12_16BIT_INDEX_STRIP_CUT_VALUE: UINT = 0xffff;
pub const D3D12_32BIT_INDEX_STRIP_CUT_VALUE: UINT = 0xffffffff;
pub const D3D12_8BIT_INDEX_STRIP_CUT_VALUE: UINT = 0xff;
pub const D3D12_APPEND_ALIGNED_ELEMENT: UINT = 0xffffffff;
pub const D3D12_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: UINT = 9;
pub const D3D12_CLIP_OR_CULL_DISTANCE_COUNT: UINT = 8;
pub const D3D12_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: UINT = 2;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: UINT = 14;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: UINT = 4;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: UINT = 15;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT: UINT = 16;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: UINT = 15;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: UINT = 64;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: UINT = 1;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: UINT = 128;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: UINT = 128;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COUNT: UINT = 16;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_COMMONSHADER_SAMPLER_SLOT_COUNT: UINT = 16;
pub const D3D12_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: UINT = 32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COUNT: UINT = 4096;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: UINT = 3;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READ_PORTS: UINT = 3;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: INT = 10;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: INT = -10;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: INT = -8;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: INT = 7;
pub const D3D12_CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT: UINT = 256;
pub const D3D12_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 256;
pub const D3D12_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: UINT = 64;
pub const D3D12_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 240;
pub const D3D12_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: UINT = 68;
pub const D3D12_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 224;
pub const D3D12_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: UINT = 72;
pub const D3D12_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 208;
pub const D3D12_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: UINT = 76;
pub const D3D12_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 192;
pub const D3D12_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: UINT = 84;
pub const D3D12_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 176;
pub const D3D12_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: UINT = 92;
pub const D3D12_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 160;
pub const D3D12_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: UINT = 100;
pub const D3D12_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 144;
pub const D3D12_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: UINT = 112;
pub const D3D12_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 128;
pub const D3D12_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: UINT = 128;
pub const D3D12_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 112;
pub const D3D12_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: UINT = 144;
pub const D3D12_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 96;
pub const D3D12_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: UINT = 168;
pub const D3D12_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 80;
pub const D3D12_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: UINT = 204;
pub const D3D12_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 64;
pub const D3D12_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: UINT = 256;
pub const D3D12_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 48;
pub const D3D12_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: UINT = 340;
pub const D3D12_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 32;
pub const D3D12_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: UINT = 512;
pub const D3D12_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: UINT = 16;
pub const D3D12_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: UINT = 768;
pub const D3D12_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: UINT = 1;
pub const D3D12_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: UINT = 256;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: UINT = 768;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_X: UINT = 768;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_Y: UINT = 768;
pub const D3D12_CS_4_X_UAV_REGISTER_COUNT: UINT = 1;
pub const D3D12_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: UINT = 65535;
pub const D3D12_CS_TGSM_REGISTER_COUNT: UINT = 8192;
pub const D3D12_CS_TGSM_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_CS_THREADGROUPID_REGISTER_COMPONENTS: UINT = 3;
pub const D3D12_CS_THREADGROUPID_REGISTER_COUNT: UINT = 1;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: UINT = 1;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COMPONENTS: UINT = 3;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COUNT: UINT = 1;
pub const D3D12_CS_THREADID_REGISTER_COMPONENTS: UINT = 3;
pub const D3D12_CS_THREADID_REGISTER_COUNT: UINT = 1;
pub const D3D12_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: UINT = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_X: UINT = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_Y: UINT = 1024;
pub const D3D12_CS_THREAD_GROUP_MAX_Z: UINT = 64;
pub const D3D12_CS_THREAD_GROUP_MIN_X: UINT = 1;
pub const D3D12_CS_THREAD_GROUP_MIN_Y: UINT = 1;
pub const D3D12_CS_THREAD_GROUP_MIN_Z: UINT = 1;
pub const D3D12_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: UINT = 16384;
pub const D3D12_DEFAULT_BLEND_FACTOR_ALPHA: FLOAT = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_BLUE: FLOAT = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_GREEN: FLOAT = 1.0;
pub const D3D12_DEFAULT_BLEND_FACTOR_RED: FLOAT = 1.0;
pub const D3D12_DEFAULT_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D12_DEFAULT_DEPTH_BIAS: UINT = 0;
pub const D3D12_DEFAULT_DEPTH_BIAS_CLAMP: FLOAT = 0.0;
pub const D3D12_DEFAULT_MAX_ANISOTROPY: UINT = 16;
pub const D3D12_DEFAULT_MIP_LOD_BIAS: FLOAT = 0.0;
pub const D3D12_DEFAULT_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: UINT = 4194304;
pub const D3D12_DEFAULT_RENDER_TARGET_ARRAY_INDEX: UINT = 0;
pub const D3D12_DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT: UINT = 65536;
pub const D3D12_DEFAULT_SAMPLE_MASK: UINT = 0xffffffff;
pub const D3D12_DEFAULT_SCISSOR_ENDX: UINT = 0;
pub const D3D12_DEFAULT_SCISSOR_ENDY: UINT = 0;
pub const D3D12_DEFAULT_SCISSOR_STARTX: UINT = 0;
pub const D3D12_DEFAULT_SCISSOR_STARTY: UINT = 0;
pub const D3D12_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: FLOAT = 0.0;
pub const D3D12_DEFAULT_STENCIL_READ_MASK: UINT = 0xff;
pub const D3D12_DEFAULT_STENCIL_REFERENCE: UINT = 0;
pub const D3D12_DEFAULT_STENCIL_WRITE_MASK: UINT = 0xff;
pub const D3D12_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: UINT = 0;
pub const D3D12_DEFAULT_VIEWPORT_HEIGHT: UINT = 0;
pub const D3D12_DEFAULT_VIEWPORT_MAX_DEPTH: FLOAT = 0.0;
pub const D3D12_DEFAULT_VIEWPORT_MIN_DEPTH: FLOAT = 0.0;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTX: UINT = 0;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTY: UINT = 0;
pub const D3D12_DEFAULT_VIEWPORT_WIDTH: UINT = 0;
pub const D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND: UINT = 0xffffffff;
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_END: UINT = 0xfffffff7;
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_START: UINT = 0xfffffff0;
pub const D3D12_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: UINT = 3968;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: UINT = 3;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: UINT = 1;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_DS_OUTPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_FLOAT16_FUSED_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D12_FLOAT32_MAX: FLOAT = 3.402823466e+38;
pub const D3D12_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: FLOAT = 0.6;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: FLOAT = 2.4;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: FLOAT = 1.0;
pub const D3D12_FLOAT_TO_SRGB_OFFSET: FLOAT = 0.055;
pub const D3D12_FLOAT_TO_SRGB_SCALE_1: FLOAT = 12.92;
pub const D3D12_FLOAT_TO_SRGB_SCALE_2: FLOAT = 1.055;
pub const D3D12_FLOAT_TO_SRGB_THRESHOLD: FLOAT = 0.0031308;
pub const D3D12_FTOI_INSTRUCTION_MAX_INPUT: FLOAT = 2147483647.999;
pub const D3D12_FTOI_INSTRUCTION_MIN_INPUT: FLOAT = -2147483648.999;
pub const D3D12_FTOU_INSTRUCTION_MAX_INPUT: FLOAT = 4294967295.999;
pub const D3D12_FTOU_INSTRUCTION_MIN_INPUT: FLOAT = 0.0;
pub const D3D12_GS_INPUT_INSTANCE_ID_READS_PER_INST: UINT = 2;
pub const D3D12_GS_INPUT_INSTANCE_ID_READ_PORTS: UINT = 1;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COUNT: UINT = 1;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_GS_INPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_GS_INPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_GS_INPUT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_GS_INPUT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_GS_INPUT_REGISTER_VERTICES: UINT = 32;
pub const D3D12_GS_MAX_INSTANCE_COUNT: UINT = 32;
pub const D3D12_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: UINT = 1024;
pub const D3D12_GS_OUTPUT_ELEMENTS: UINT = 32;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_GS_OUTPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: UINT = 0xffffffff;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: UINT = 0xffffffff;
pub const D3D12_HS_MAXTESSFACTOR_LOWER_BOUND: FLOAT = 1.0;
pub const D3D12_HS_MAXTESSFACTOR_UPPER_BOUND: FLOAT = 64.0;
pub const D3D12_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: UINT = 3968;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: UINT = 1;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: UINT = 32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: UINT = 128;
pub const D3D12_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: UINT = 0;
pub const D3D12_IA_DEFAULT_PRIMITIVE_TOPOLOGY: UINT = 0;
pub const D3D12_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: UINT = 0;
pub const D3D12_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: UINT = 1;
pub const D3D12_IA_INSTANCE_ID_BIT_COUNT: UINT = 32;
pub const D3D12_IA_INTEGER_ARITHMETIC_BIT_COUNT: UINT = 32;
pub const D3D12_IA_PATCH_MAX_CONTROL_POINT_COUNT: UINT = 32;
pub const D3D12_IA_PRIMITIVE_ID_BIT_COUNT: UINT = 32;
pub const D3D12_IA_VERTEX_ID_BIT_COUNT: UINT = 32;
pub const D3D12_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: UINT = 32;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: UINT = 128;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: UINT = 32;
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: UINT = 0xffffffff;
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_REMAINDER: UINT = 0xffffffff;
pub const D3D12_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: UINT = 0xffffffff;
pub const D3D12_KEEP_UNORDERED_ACCESS_VIEWS: UINT = 0xffffffff;
pub const D3D12_LINEAR_GAMMA: FLOAT = 1.0;
pub const D3D12_MAJOR_VERSION: UINT = 12;
pub const D3D12_MAX_BORDER_COLOR_COMPONENT: FLOAT = 1.0;
pub const D3D12_MAX_DEPTH: FLOAT = 1.0;
pub const D3D12_MAX_LIVE_STATIC_SAMPLERS: UINT = 2032;
pub const D3D12_MAX_MAXANISOTROPY: UINT = 16;
pub const D3D12_MAX_MULTISAMPLE_SAMPLE_COUNT: UINT = 32;
pub const D3D12_MAX_POSITION_VALUE: FLOAT = 3.402823466e+34;
pub const D3D12_MAX_ROOT_COST: UINT = 64;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_1: UINT = 1000000;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_2: UINT = 1000000;
pub const D3D12_MAX_SHADER_VISIBLE_SAMPLER_HEAP_SIZE: UINT = 2048;
pub const D3D12_MAX_TEXTURE_DIMENSION_2_TO_EXP: UINT = 17;
pub const D3D12_MINOR_VERSION: UINT = 0;
pub const D3D12_MIN_BORDER_COLOR_COMPONENT: FLOAT = 0.0;
pub const D3D12_MIN_DEPTH: FLOAT = 0.0;
pub const D3D12_MIN_MAXANISOTROPY: UINT = 0;
pub const D3D12_MIP_LOD_BIAS_MAX: FLOAT = 15.99;
pub const D3D12_MIP_LOD_BIAS_MIN: FLOAT = -16.0;
pub const D3D12_MIP_LOD_FRACTIONAL_BIT_COUNT: UINT = 8;
pub const D3D12_MIP_LOD_RANGE_BIT_COUNT: UINT = 8;
pub const D3D12_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: FLOAT = 1.4;
pub const D3D12_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: UINT = 0;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_END: UINT = 0xffffffff;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_START: UINT = 0xfffffff8;
pub const D3D12_PACKED_TILE: UINT = 0xffffffff;
pub const D3D12_PIXEL_ADDRESS_RANGE_BIT_COUNT: UINT = 15;
pub const D3D12_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: UINT = 16;
pub const D3D12_PS_CS_UAV_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_PS_CS_UAV_REGISTER_COUNT: UINT = 8;
pub const D3D12_PS_CS_UAV_REGISTER_READS_PER_INST: UINT = 1;
pub const D3D12_PS_CS_UAV_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_PS_FRONTFACING_DEFAULT_VALUE: UINT = 0xffffffff;
pub const D3D12_PS_FRONTFACING_FALSE_VALUE: UINT = 0;
pub const D3D12_PS_FRONTFACING_TRUE_VALUE: UINT = 0xffffffff;
pub const D3D12_PS_INPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_PS_INPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_PS_INPUT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_PS_INPUT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.0;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COUNT: UINT = 1;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENTS: UINT = 1;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COUNT: UINT = 1;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_PS_OUTPUT_REGISTER_COUNT: UINT = 8;
pub const D3D12_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: FLOAT = 0.5;
pub const D3D12_RAW_UAV_SRV_BYTE_ALIGNMENT: UINT = 16;
pub const D3D12_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: UINT = 4096;
pub const D3D12_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: UINT = 27;
pub const D3D12_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: UINT = 4096;
pub const D3D12_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: UINT = 4096;
pub const D3D12_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: UINT = 32;
pub const D3D12_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: UINT = 32;
pub const D3D12_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: UINT = 16384;
pub const D3D12_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: UINT = 1024;
pub const D3D12_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: UINT = 4096;
pub const D3D12_REQ_MAXANISOTROPY: UINT = 16;
pub const D3D12_REQ_MIP_LEVELS: UINT = 15;
pub const D3D12_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: UINT = 2048;
pub const D3D12_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: UINT = 4096;
pub const D3D12_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: UINT = 16384;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: UINT = 128;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: FLOAT = 0.25;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: UINT = 2048;
pub const D3D12_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: UINT = 20;
pub const D3D12_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: UINT = 4096;
pub const D3D12_REQ_SUBRESOURCES: UINT = 30720;
pub const D3D12_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: UINT = 2048;
pub const D3D12_REQ_TEXTURE1D_U_DIMENSION: UINT = 16384;
pub const D3D12_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: UINT = 2048;
pub const D3D12_REQ_TEXTURE2D_U_OR_V_DIMENSION: UINT = 16384;
pub const D3D12_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: UINT = 2048;
pub const D3D12_REQ_TEXTURECUBE_DIMENSION: UINT = 16384;
pub const D3D12_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: UINT = 0;
pub const D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES: UINT = 0xffffffff;
pub const D3D12_SHADER_MAJOR_VERSION: UINT = 5;
pub const D3D12_SHADER_MAX_INSTANCES: UINT = 65535;
pub const D3D12_SHADER_MAX_INTERFACES: UINT = 253;
pub const D3D12_SHADER_MAX_INTERFACE_CALL_SITES: UINT = 4096;
pub const D3D12_SHADER_MAX_TYPES: UINT = 65535;
pub const D3D12_SHADER_MINOR_VERSION: UINT = 1;
pub const D3D12_SHIFT_INSTRUCTION_PAD_VALUE: UINT = 0;
pub const D3D12_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: UINT = 5;
pub const D3D12_SIMULTANEOUS_RENDER_TARGET_COUNT: UINT = 8;
pub const D3D12_SMALL_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: UINT = 65536;
pub const D3D12_SMALL_RESOURCE_PLACEMENT_ALIGNMENT: UINT = 4096;
pub const D3D12_SO_BUFFER_MAX_STRIDE_IN_BYTES: UINT = 2048;
pub const D3D12_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: UINT = 512;
pub const D3D12_SO_BUFFER_SLOT_COUNT: UINT = 4;
pub const D3D12_SO_DDI_REGISTER_INDEX_DENOTING_GAP: UINT = 0xffffffff;
pub const D3D12_SO_NO_RASTERIZED_STREAM: UINT = 0xffffffff;
pub const D3D12_SO_OUTPUT_COMPONENT_COUNT: UINT = 128;
pub const D3D12_SO_STREAM_COUNT: UINT = 4;
pub const D3D12_SPEC_DATE_DAY: UINT = 14;
pub const D3D12_SPEC_DATE_MONTH: UINT = 11;
pub const D3D12_SPEC_DATE_YEAR: UINT = 2014;
pub const D3D12_SPEC_VERSION: FLOAT = 1.16;
pub const D3D12_SRGB_GAMMA: FLOAT = 2.2;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_1: FLOAT = 12.92;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_2: FLOAT = 1.055;
pub const D3D12_SRGB_TO_FLOAT_EXPONENT: FLOAT = 2.4;
pub const D3D12_SRGB_TO_FLOAT_OFFSET: FLOAT = 0.055;
pub const D3D12_SRGB_TO_FLOAT_THRESHOLD: FLOAT = 0.04045;
pub const D3D12_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: FLOAT = 0.5;
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: UINT = 64;
pub const D3D12_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: UINT = 4;
pub const D3D12_STANDARD_PIXEL_COMPONENT_COUNT: UINT = 128;
pub const D3D12_STANDARD_PIXEL_ELEMENT_COUNT: UINT = 32;
pub const D3D12_STANDARD_VECTOR_SIZE: UINT = 4;
pub const D3D12_STANDARD_VERTEX_ELEMENT_COUNT: UINT = 32;
pub const D3D12_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: UINT = 64;
pub const D3D12_SUBPIXEL_FRACTIONAL_BIT_COUNT: UINT = 8;
pub const D3D12_SUBTEXEL_FRACTIONAL_BIT_COUNT: UINT = 8;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_END: UINT = 0xffffffff;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_START: UINT = 0xfffffff0;
pub const D3D12_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: UINT = 64;
pub const D3D12_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: UINT = 64;
pub const D3D12_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: UINT = 63;
pub const D3D12_TESSELLATOR_MAX_TESSELLATION_FACTOR: UINT = 64;
pub const D3D12_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: UINT = 2;
pub const D3D12_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: UINT = 1;
pub const D3D12_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: UINT = 1;
pub const D3D12_TEXEL_ADDRESS_RANGE_BIT_COUNT: UINT = 16;
pub const D3D12_TEXTURE_DATA_PITCH_ALIGNMENT: UINT = 256;
pub const D3D12_TEXTURE_DATA_PLACEMENT_ALIGNMENT: UINT = 512;
pub const D3D12_TILED_RESOURCE_TILE_SIZE_IN_BYTES: UINT = 65536;
pub const D3D12_UAV_COUNTER_PLACEMENT_ALIGNMENT: UINT = 4096;
pub const D3D12_UAV_SLOT_COUNT: UINT = 64;
pub const D3D12_UNBOUND_MEMORY_ACCESS_RESULT: UINT = 0;
pub const D3D12_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: UINT = 15;
pub const D3D12_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: UINT = 16;
pub const D3D12_VIEWPORT_BOUNDS_MAX: INT = 32767;
pub const D3D12_VIEWPORT_BOUNDS_MIN: INT = -32768;
pub const D3D12_VS_INPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_VS_INPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_VS_INPUT_REGISTER_READS_PER_INST: UINT = 2;
pub const D3D12_VS_INPUT_REGISTER_READ_PORTS: UINT = 1;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENTS: UINT = 4;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: UINT = 32;
pub const D3D12_VS_OUTPUT_REGISTER_COUNT: UINT = 32;
pub const D3D12_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: UINT = 10;
pub const D3D12_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: UINT = 25;
pub const D3D12_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: UINT = 25;
pub type D3D12_GPU_VIRTUAL_ADDRESS = UINT64;
ENUM!{enum D3D12_COMMAND_LIST_TYPE {
    D3D12_COMMAND_LIST_TYPE_DIRECT = 0,
    D3D12_COMMAND_LIST_TYPE_BUNDLE = 1,
    D3D12_COMMAND_LIST_TYPE_COMPUTE = 2,
    D3D12_COMMAND_LIST_TYPE_COPY = 3,
}}
ENUM!{enum D3D12_COMMAND_QUEUE_FLAGS {
    D3D12_COMMAND_QUEUE_FLAG_NONE = 0x0,
    D3D12_COMMAND_QUEUE_FLAG_DISABLE_GPU_TIMEOUT = 0x1,
}}
ENUM!{enum D3D12_COMMAND_QUEUE_PRIORITY {
    D3D12_COMMAND_QUEUE_PRIORITY_NORMAL = 0,
    D3D12_COMMAND_QUEUE_PRIORITY_HIGH = 100,
    D3D12_COMMAND_QUEUE_PRIORITY_GLOBAL_REALTIME = 10000,
}}
STRUCT!{struct D3D12_COMMAND_QUEUE_DESC {
    Type: D3D12_COMMAND_LIST_TYPE,
    Priority: INT,
    Flags: D3D12_COMMAND_QUEUE_FLAGS,
    NodeMask: UINT,
}}
ENUM!{enum D3D12_PRIMITIVE_TOPOLOGY_TYPE {
    D3D12_PRIMITIVE_TOPOLOGY_TYPE_UNDEFINED = 0,
    D3D12_PRIMITIVE_TOPOLOGY_TYPE_POINT = 1,
    D3D12_PRIMITIVE_TOPOLOGY_TYPE_LINE = 2,
    D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE = 3,
    D3D12_PRIMITIVE_TOPOLOGY_TYPE_PATCH = 4,
}}
ENUM!{enum D3D12_INPUT_CLASSIFICATION {
    D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA = 0,
    D3D12_INPUT_CLASSIFICATION_PER_INSTANCE_DATA = 1,
}}
STRUCT!{struct D3D12_INPUT_ELEMENT_DESC {
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    Format: DXGI_FORMAT,
    InputSlot: UINT,
    AlignedByteOffset: UINT,
    InputSlotClass: D3D12_INPUT_CLASSIFICATION,
    InstanceDataStepRate: UINT,
}}
ENUM!{enum D3D12_FILL_MODE {
    D3D12_FILL_MODE_WIREFRAME = 2,
    D3D12_FILL_MODE_SOLID = 3,
}}
pub type D3D12_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY;
pub type D3D12_PRIMITIVE = D3D_PRIMITIVE;
ENUM!{enum D3D12_CULL_MODE {
    D3D12_CULL_MODE_NONE = 1,
    D3D12_CULL_MODE_FRONT = 2,
    D3D12_CULL_MODE_BACK = 3,
}}
STRUCT!{struct D3D12_SO_DECLARATION_ENTRY {
    Stream: UINT,
    SemanticName: LPCSTR,
    SemanticIndex: UINT,
    StartComponent: BYTE,
    ComponentCount: BYTE,
    OutputSlot: BYTE,
}}
STRUCT!{struct D3D12_VIEWPORT {
    TopLeftX: FLOAT,
    TopLeftY: FLOAT,
    Width: FLOAT,
    Height: FLOAT,
    MinDepth: FLOAT,
    MaxDepth: FLOAT,
}}
pub type D3D12_RECT = RECT;
STRUCT!{struct D3D12_BOX {
    left: UINT,
    top: UINT,
    front: UINT,
    right: UINT,
    bottom: UINT,
    back: UINT,
}}
ENUM!{enum D3D12_COMPARISON_FUNC {
    D3D12_COMPARISON_FUNC_NEVER = 1,
    D3D12_COMPARISON_FUNC_LESS = 2,
    D3D12_COMPARISON_FUNC_EQUAL = 3,
    D3D12_COMPARISON_FUNC_LESS_EQUAL = 4,
    D3D12_COMPARISON_FUNC_GREATER = 5,
    D3D12_COMPARISON_FUNC_NOT_EQUAL = 6,
    D3D12_COMPARISON_FUNC_GREATER_EQUAL = 7,
    D3D12_COMPARISON_FUNC_ALWAYS = 8,
}}
ENUM!{enum D3D12_DEPTH_WRITE_MASK {
    D3D12_DEPTH_WRITE_MASK_ZERO = 0,
    D3D12_DEPTH_WRITE_MASK_ALL = 1,
}}
ENUM!{enum D3D12_STENCIL_OP {
    D3D12_STENCIL_OP_KEEP = 1,
    D3D12_STENCIL_OP_ZERO = 2,
    D3D12_STENCIL_OP_REPLACE = 3,
    D3D12_STENCIL_OP_INCR_SAT = 4,
    D3D12_STENCIL_OP_DECR_SAT = 5,
    D3D12_STENCIL_OP_INVERT = 6,
    D3D12_STENCIL_OP_INCR = 7,
    D3D12_STENCIL_OP_DECR = 8,
}}
STRUCT!{struct D3D12_DEPTH_STENCILOP_DESC {
    StencilFailOp: D3D12_STENCIL_OP,
    StencilDepthFailOp: D3D12_STENCIL_OP,
    StencilPassOp: D3D12_STENCIL_OP,
    StencilFunc: D3D12_COMPARISON_FUNC,
}}
STRUCT!{struct D3D12_DEPTH_STENCIL_DESC {
    DepthEnable: BOOL,
    DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    DepthFunc: D3D12_COMPARISON_FUNC,
    StencilEnable: BOOL,
    StencilReadMask: UINT8,
    StencilWriteMask: UINT8,
    FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    BackFace: D3D12_DEPTH_STENCILOP_DESC,
}}
STRUCT!{struct D3D12_DEPTH_STENCIL_DESC1 {
    DepthEnable: BOOL,
    DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    DepthFunc: D3D12_COMPARISON_FUNC,
    StencilEnable: BOOL,
    StencilReadMask: UINT8,
    StencilWriteMask: UINT8,
    FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    BackFace: D3D12_DEPTH_STENCILOP_DESC,
    DepthBoundsTestEnable: BOOL,
}}
ENUM!{enum D3D12_BLEND {
    D3D12_BLEND_ZERO = 1,
    D3D12_BLEND_ONE = 2,
    D3D12_BLEND_SRC_COLOR = 3,
    D3D12_BLEND_INV_SRC_COLOR = 4,
    D3D12_BLEND_SRC_ALPHA = 5,
    D3D12_BLEND_INV_SRC_ALPHA = 6,
    D3D12_BLEND_DEST_ALPHA = 7,
    D3D12_BLEND_INV_DEST_ALPHA = 8,
    D3D12_BLEND_DEST_COLOR = 9,
    D3D12_BLEND_INV_DEST_COLOR = 10,
    D3D12_BLEND_SRC_ALPHA_SAT = 11,
    D3D12_BLEND_BLEND_FACTOR = 14,
    D3D12_BLEND_INV_BLEND_FACTOR = 15,
    D3D12_BLEND_SRC1_COLOR = 16,
    D3D12_BLEND_INV_SRC1_COLOR = 17,
    D3D12_BLEND_SRC1_ALPHA = 18,
    D3D12_BLEND_INV_SRC1_ALPHA = 19,
}}
ENUM!{enum D3D12_BLEND_OP {
    D3D12_BLEND_OP_ADD = 1,
    D3D12_BLEND_OP_SUBTRACT = 2,
    D3D12_BLEND_OP_REV_SUBTRACT = 3,
    D3D12_BLEND_OP_MIN = 4,
    D3D12_BLEND_OP_MAX = 5,
}}
ENUM!{enum D3D12_COLOR_WRITE_ENABLE {
    D3D12_COLOR_WRITE_ENABLE_RED = 1,
    D3D12_COLOR_WRITE_ENABLE_GREEN = 2,
    D3D12_COLOR_WRITE_ENABLE_BLUE = 4,
    D3D12_COLOR_WRITE_ENABLE_ALPHA = 8,
    D3D12_COLOR_WRITE_ENABLE_ALL = D3D12_COLOR_WRITE_ENABLE_RED | D3D12_COLOR_WRITE_ENABLE_GREEN
        | D3D12_COLOR_WRITE_ENABLE_BLUE | D3D12_COLOR_WRITE_ENABLE_ALPHA,
}}
ENUM!{enum D3D12_LOGIC_OP {
    D3D12_LOGIC_OP_CLEAR = 0,
    D3D12_LOGIC_OP_SET = 1,
    D3D12_LOGIC_OP_COPY = 2,
    D3D12_LOGIC_OP_COPY_INVERTED = 3,
    D3D12_LOGIC_OP_NOOP = 4,
    D3D12_LOGIC_OP_INVERT = 5,
    D3D12_LOGIC_OP_AND = 6,
    D3D12_LOGIC_OP_NAND = 7,
    D3D12_LOGIC_OP_OR = 8,
    D3D12_LOGIC_OP_NOR = 9,
    D3D12_LOGIC_OP_XOR = 10,
    D3D12_LOGIC_OP_EQUIV = 11,
    D3D12_LOGIC_OP_AND_REVERSE = 12,
    D3D12_LOGIC_OP_AND_INVERTED = 13,
    D3D12_LOGIC_OP_OR_REVERSE = 14,
    D3D12_LOGIC_OP_OR_INVERTED = 15,
}}
STRUCT!{struct D3D12_RENDER_TARGET_BLEND_DESC {
    BlendEnable: BOOL,
    LogicOpEnable: BOOL,
    SrcBlend: D3D12_BLEND,
    DestBlend: D3D12_BLEND,
    BlendOp: D3D12_BLEND_OP,
    SrcBlendAlpha: D3D12_BLEND,
    DestBlendAlpha: D3D12_BLEND,
    BlendOpAlpha: D3D12_BLEND_OP,
    LogicOp: D3D12_LOGIC_OP,
    RenderTargetWriteMask: UINT8,
}}
STRUCT!{struct D3D12_BLEND_DESC {
    AlphaToCoverageEnable: BOOL,
    IndependentBlendEnable: BOOL,
    RenderTarget: [D3D12_RENDER_TARGET_BLEND_DESC; 8],
}}
ENUM!{enum D3D12_CONSERVATIVE_RASTERIZATION_MODE {
    D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF = 0,
    D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON = 1,
}}
STRUCT!{struct D3D12_RASTERIZER_DESC {
    FillMode: D3D12_FILL_MODE,
    CullMode: D3D12_CULL_MODE,
    FrontCounterClockwise: BOOL,
    DepthBias: INT,
    DepthBiasClamp: FLOAT,
    SlopeScaledDepthBias: FLOAT,
    DepthClipEnable: BOOL,
    MultisampleEnable: BOOL,
    AntialiasedLineEnable: BOOL,
    ForcedSampleCount: UINT,
    ConservativeRaster: D3D12_CONSERVATIVE_RASTERIZATION_MODE,
}}
RIDL!{#[uuid(0xc54a6b66, 0x72df, 0x4ee8, 0x8b, 0xe5, 0xa9, 0x46, 0xa1, 0x42, 0x92, 0x14)]
interface ID3D12RootSignature(ID3D12RootSignatureVtbl):
    ID3D12DeviceChild(ID3D12DeviceChildVtbl) {}}
STRUCT!{struct D3D12_SHADER_BYTECODE {
    pShaderBytecode: *const c_void,
    BytecodeLength: SIZE_T,
}}
STRUCT!{struct D3D12_STREAM_OUTPUT_DESC {
    pSODeclaration: *const D3D12_SO_DECLARATION_ENTRY,
    NumEntries: UINT,
    pBufferStrides: *const UINT,
    NumStrides: UINT,
    RasterizedStream: UINT,
}}
STRUCT!{struct D3D12_INPUT_LAYOUT_DESC {
    pInputElementDescs: *const D3D12_INPUT_ELEMENT_DESC,
    NumElements: UINT,
}}
ENUM!{enum D3D12_INDEX_BUFFER_STRIP_CUT_VALUE {
    D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_DISABLED = 0,
    D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFF = 1,
    D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFFFFFF = 2,
}}
STRUCT!{struct D3D12_CACHED_PIPELINE_STATE {
    pCachedBlob: *const c_void,
    CachedBlobSizeInBytes: SIZE_T,
}}
ENUM!{enum D3D12_PIPELINE_STATE_FLAGS {
    D3D12_PIPELINE_STATE_FLAG_NONE = 0,
    D3D12_PIPELINE_STATE_FLAG_TOOL_DEBUG = 0x1,
}}
STRUCT!{struct D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    pRootSignature: *mut ID3D12RootSignature,
    VS: D3D12_SHADER_BYTECODE,
    PS: D3D12_SHADER_BYTECODE,
    DS: D3D12_SHADER_BYTECODE,
    HS: D3D12_SHADER_BYTECODE,
    GS: D3D12_SHADER_BYTECODE,
    StreamOutput: D3D12_STREAM_OUTPUT_DESC,
    BlendState: D3D12_BLEND_DESC,
    SampleMask: UINT,
    RasterizerState: D3D12_RASTERIZER_DESC,
    DepthStencilState: D3D12_DEPTH_STENCIL_DESC,
    InputLayout: D3D12_INPUT_LAYOUT_DESC,
    IBStripCutValue: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE,
    PrimitiveTopologyType: D3D12_PRIMITIVE_TOPOLOGY_TYPE,
    NumRenderTargets: UINT,
    RTVFormats: [DXGI_FORMAT; 8],
    DSVFormat: DXGI_FORMAT,
    SampleDesc: DXGI_SAMPLE_DESC,
    NodeMask: UINT,
    CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    Flags: D3D12_PIPELINE_STATE_FLAGS,
}}
STRUCT!{struct D3D12_COMPUTE_PIPELINE_STATE_DESC {
    pRootSignature: *mut ID3D12RootSignature,
    CS: D3D12_SHADER_BYTECODE,
    NodeMask: UINT,
    CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    Flags: D3D12_PIPELINE_STATE_FLAGS,
}}
STRUCT!{struct D3D12_RT_FORMAT_ARRAY {
    RTFormats: [DXGI_FORMAT; 8],
    NumRenderTargets: UINT,
}}
STRUCT!{struct D3D12_PIPELINE_STATE_STREAM_DESC {
    SizeInBytes: SIZE_T,
    pPipelineStateSubobjectStream: *mut c_void,
}}
ENUM!{enum D3D12_PIPELINE_STATE_SUBOBJECT_TYPE {
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE = 0,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS = 1,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS = 2,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS = 3,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS = 4,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS = 5,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS = 6,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT = 7,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND = 8,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK = 9,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER = 10,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL = 11,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT = 12,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE = 13,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY = 14,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS = 15,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT = 16,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC = 17,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK = 18,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO = 19,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS = 20,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1 = 21,
    D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID = 22,
}}
ENUM!{enum D3D12_FEATURE {
    D3D12_FEATURE_D3D12_OPTIONS = 0,
    D3D12_FEATURE_ARCHITECTURE = 1,
    D3D12_FEATURE_FEATURE_LEVELS = 2,
    D3D12_FEATURE_FORMAT_SUPPORT = 3,
    D3D12_FEATURE_MULTISAMPLE_QUALITY_LEVELS = 4,
    D3D12_FEATURE_FORMAT_INFO = 5,
    D3D12_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT = 6,
    D3D12_FEATURE_SHADER_MODEL = 7,
    D3D12_FEATURE_D3D12_OPTIONS1 = 8,
    D3D12_FEATURE_ROOT_SIGNATURE = 12,
    D3D12_FEATURE_ARCHITECTURE1 = 16,
    D3D12_FEATURE_D3D12_OPTIONS2 = 18,
    D3D12_FEATURE_SHADER_CACHE = 19,
    D3D12_FEATURE_COMMAND_QUEUE_PRIORITY = 20,
}}
ENUM!{enum D3D12_SHADER_MIN_PRECISION_SUPPORT {
    D3D12_SHADER_MIN_PRECISION_SUPPORT_NONE = 0,
    D3D12_SHADER_MIN_PRECISION_SUPPORT_10_BIT = 0x1,
    D3D12_SHADER_MIN_PRECISION_SUPPORT_16_BIT = 0x2,
}}
ENUM!{enum D3D12_TILED_RESOURCES_TIER {
    D3D12_TILED_RESOURCES_TIER_NOT_SUPPORTED = 0,
    D3D12_TILED_RESOURCES_TIER_1 = 1,
    D3D12_TILED_RESOURCES_TIER_2 = 2,
    D3D12_TILED_RESOURCES_TIER_3 = 3,
}}
ENUM!{enum D3D12_RESOURCE_BINDING_TIER {
    D3D12_RESOURCE_BINDING_TIER_1 = 1,
    D3D12_RESOURCE_BINDING_TIER_2 = 2,
    D3D12_RESOURCE_BINDING_TIER_3 = 3,
}}
ENUM!{enum D3D12_CONSERVATIVE_RASTERIZATION_TIER {
    D3D12_CONSERVATIVE_RASTERIZATION_TIER_NOT_SUPPORTED = 0,
    D3D12_CONSERVATIVE_RASTERIZATION_TIER_1 = 1,
    D3D12_CONSERVATIVE_RASTERIZATION_TIER_2 = 2,
    D3D12_CONSERVATIVE_RASTERIZATION_TIER_3 = 3,
}}
ENUM!{enum D3D12_FORMAT_SUPPORT1 {
    D3D12_FORMAT_SUPPORT1_NONE = 0,
    D3D12_FORMAT_SUPPORT1_BUFFER = 0x1,
    D3D12_FORMAT_SUPPORT1_IA_VERTEX_BUFFER = 0x2,
    D3D12_FORMAT_SUPPORT1_IA_INDEX_BUFFER = 0x4,
    D3D12_FORMAT_SUPPORT1_SO_BUFFER = 0x8,
    D3D12_FORMAT_SUPPORT1_TEXTURE1D = 0x10,
    D3D12_FORMAT_SUPPORT1_TEXTURE2D = 0x20,
    D3D12_FORMAT_SUPPORT1_TEXTURE3D = 0x40,
    D3D12_FORMAT_SUPPORT1_TEXTURECUBE = 0x80,
    D3D12_FORMAT_SUPPORT1_SHADER_LOAD = 0x100,
    D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE = 0x200,
    D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_COMPARISON = 0x400,
    D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_MONO_TEXT = 0x800,
    D3D12_FORMAT_SUPPORT1_MIP = 0x1000,
    D3D12_FORMAT_SUPPORT1_RENDER_TARGET = 0x4000,
    D3D12_FORMAT_SUPPORT1_BLENDABLE = 0x8000,
    D3D12_FORMAT_SUPPORT1_DEPTH_STENCIL = 0x10000,
    D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RESOLVE = 0x40000,
    D3D12_FORMAT_SUPPORT1_DISPLAY = 0x80000,
    D3D12_FORMAT_SUPPORT1_CAST_WITHIN_BIT_LAYOUT = 0x100000,
    D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RENDERTARGET = 0x200000,
    D3D12_FORMAT_SUPPORT1_MULTISAMPLE_LOAD = 0x400000,
    D3D12_FORMAT_SUPPORT1_SHADER_GATHER = 0x800000,
    D3D12_FORMAT_SUPPORT1_BACK_BUFFER_CAST = 0x1000000,
    D3D12_FORMAT_SUPPORT1_TYPED_UNORDERED_ACCESS_VIEW = 0x2000000,
    D3D12_FORMAT_SUPPORT1_SHADER_GATHER_COMPARISON = 0x4000000,
    D3D12_FORMAT_SUPPORT1_DECODER_OUTPUT = 0x8000000,
    D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_OUTPUT = 0x10000000,
    D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_INPUT = 0x20000000,
    D3D12_FORMAT_SUPPORT1_VIDEO_ENCODER = 0x40000000,
}}
ENUM!{enum D3D12_FORMAT_SUPPORT2 {
    D3D12_FORMAT_SUPPORT2_NONE = 0,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_ADD = 0x1,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS = 0x2,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 0x4,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE = 0x8,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX = 0x10,
    D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX = 0x20,
    D3D12_FORMAT_SUPPORT2_UAV_TYPED_LOAD = 0x40,
    D3D12_FORMAT_SUPPORT2_UAV_TYPED_STORE = 0x80,
    D3D12_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP = 0x100,
    D3D12_FORMAT_SUPPORT2_TILED = 0x200,
    D3D12_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY = 0x4000,
}}
ENUM!{enum D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_NONE = 0,
    D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_TILED_RESOURCE = 0x1,
}}
ENUM!{enum D3D12_CROSS_NODE_SHARING_TIER {
    D3D12_CROSS_NODE_SHARING_TIER_NOT_SUPPORTED = 0,
    D3D12_CROSS_NODE_SHARING_TIER_1_EMULATED = 1,
    D3D12_CROSS_NODE_SHARING_TIER_1 = 2,
    D3D12_CROSS_NODE_SHARING_TIER_2 = 3,
}}
ENUM!{enum D3D12_RESOURCE_HEAP_TIER {
    D3D12_RESOURCE_HEAP_TIER_1 = 1,
    D3D12_RESOURCE_HEAP_TIER_2 = 2,
}}
ENUM!{enum D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER {
    D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_NOT_SUPPORTED = 0,
    D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_1 = 1,
    D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_2 = 2,
}}
STRUCT!{struct D3D12_FEATURE_DATA_D3D12_OPTIONS {
    DoublePrecisionFloatShaderOps: BOOL,
    OutputMergerLogicOp: BOOL,
    MinPrecisionSupport: D3D12_SHADER_MIN_PRECISION_SUPPORT,
    TiledResourcesTier: D3D12_TILED_RESOURCES_TIER,
    ResourceBindingTier: D3D12_RESOURCE_BINDING_TIER,
    PSSpecifiedStencilRefSupported: BOOL,
    TypedUAVLoadAdditionalFormats: BOOL,
    ROVsSupported: BOOL,
    ConservativeRasterizationTier: D3D12_CONSERVATIVE_RASTERIZATION_TIER,
    MaxGPUVirtualAddressBitsPerResource: UINT,
    StandardSwizzle64KBSupported: BOOL,
    CrossNodeSharingTier: D3D12_CROSS_NODE_SHARING_TIER,
    CrossAdapterRowMajorTextureSupported: BOOL,
    VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation: BOOL,
    ResourceHeapTier: D3D12_RESOURCE_HEAP_TIER,
}}
STRUCT!{struct D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    WaveOps: BOOL,
    WaveLaneCountMin: UINT,
    WaveLaneCountMax: UINT,
    TotalLaneCount: UINT,
    ExpandedComputeResourceStates: BOOL,
    Int64ShaderOps: BOOL,
}}
STRUCT!{struct D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    DepthBoundsTestSupported: BOOL,
    ProgrammableSamplePositionsTier: D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER,
}}
ENUM!{enum D3D_ROOT_SIGNATURE_VERSION {
    D3D_ROOT_SIGNATURE_VERSION_1 = 0x1,
    D3D_ROOT_SIGNATURE_VERSION_1_0 = 0x1,
    D3D_ROOT_SIGNATURE_VERSION_1_1 = 0x2,
}}
STRUCT!{struct D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    HighestVersion: D3D_ROOT_SIGNATURE_VERSION,
}}
STRUCT!{struct D3D12_FEATURE_DATA_ARCHITECTURE {
    NodeIndex: UINT,
    TileBasedRenderer: BOOL,
    UMA: BOOL,
    CacheCoherentUMA: BOOL,
}}
STRUCT!{struct D3D12_FEATURE_DATA_ARCHITECTURE1 {
    NodeIndex: UINT,
    TileBasedRenderer: BOOL,
    UMA: BOOL,
    CacheCoherentUMA: BOOL,
    IsolatedMMU: BOOL,
}}
STRUCT!{struct D3D12_FEATURE_DATA_FEATURE_LEVELS {
    NumFeatureLevels: UINT,
    pFeatureLevelsRequested: *const D3D_FEATURE_LEVEL,
    MaxSupportedFeatureLevel: D3D_FEATURE_LEVEL,
}}
ENUM!{enum D3D_SHADER_MODEL {
    D3D_SHADER_MODEL_5_1 = 0x51,
    D3D_SHADER_MODEL_6_0 = 0x60,
}}
STRUCT!{struct D3D12_FEATURE_DATA_SHADER_MODEL {
    HighestShaderModel: D3D_SHADER_MODEL,
}}
STRUCT!{struct D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    Format: DXGI_FORMAT,
    Support1: D3D12_FORMAT_SUPPORT1,
    Support2: D3D12_FORMAT_SUPPORT2,
}}
STRUCT!{struct D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    Format: DXGI_FORMAT,
    SampleCount: UINT,
    Flags: D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS,
    NumQualityLevels: UINT,
}}
STRUCT!{struct D3D12_FEATURE_DATA_FORMAT_INFO {
    Format: DXGI_FORMAT,
    PlaneCount: UINT8,
}}
STRUCT!{struct D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    MaxGPUVirtualAddressBitsPerResource: UINT,
    MaxGPUVirtualAddressBitsPerProcess: UINT,
}}
ENUM!{enum D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    D3D12_SHADER_CACHE_SUPPORT_NONE = 0,
    D3D12_SHADER_CACHE_SUPPORT_SINGLE_PSO = 0x1,
    D3D12_SHADER_CACHE_SUPPORT_LIBRARY = 0x2,
    D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_INPROC_CACHE = 0x4,
    D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_DISK_CACHE = 0x8,
}}
STRUCT!{struct D3D12_FEATURE_DATA_SHADER_CACHE {
    SupportFlags: D3D12_SHADER_CACHE_SUPPORT_FLAGS,
}}
STRUCT!{struct D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    CommandListType: D3D12_COMMAND_LIST_TYPE,
    Priority: UINT,
    PriorityForTypeIsSupported: BOOL,
}}
STRUCT!{struct D3D12_RESOURCE_ALLOCATION_INFO {
    SizeInBytes: UINT64,
    Alignment: UINT64,
}}
ENUM!{enum D3D12_HEAP_TYPE {
    D3D12_HEAP_TYPE_DEFAULT = 1,
    D3D12_HEAP_TYPE_UPLOAD = 2,
    D3D12_HEAP_TYPE_READBACK = 3,
    D3D12_HEAP_TYPE_CUSTOM = 4,
}}
ENUM!{enum D3D12_CPU_PAGE_PROPERTY {
    D3D12_CPU_PAGE_PROPERTY_UNKNOWN = 0,
    D3D12_CPU_PAGE_PROPERTY_NOT_AVAILABLE = 1,
    D3D12_CPU_PAGE_PROPERTY_WRITE_COMBINE = 2,
    D3D12_CPU_PAGE_PROPERTY_WRITE_BACK = 3,
}}
ENUM!{enum D3D12_MEMORY_POOL {
    D3D12_MEMORY_POOL_UNKNOWN = 0,
    D3D12_MEMORY_POOL_L0 = 1,
    D3D12_MEMORY_POOL_L1 = 2,
}}
STRUCT!{struct D3D12_HEAP_PROPERTIES {
    Type: D3D12_HEAP_TYPE,
    CPUPageProperty: D3D12_CPU_PAGE_PROPERTY,
    MemoryPoolPreference: D3D12_MEMORY_POOL,
    CreationNodeMask: UINT,
    VisibleNodeMask: UINT,
}}
ENUM!{enum D3D12_HEAP_FLAGS {
    D3D12_HEAP_FLAG_NONE = 0,
    D3D12_HEAP_FLAG_SHARED = 0x1,
    D3D12_HEAP_FLAG_DENY_BUFFERS = 0x4,
    D3D12_HEAP_FLAG_ALLOW_DISPLAY = 0x8,
    D3D12_HEAP_FLAG_SHARED_CROSS_ADAPTER = 0x20,
    D3D12_HEAP_FLAG_DENY_RT_DS_TEXTURES = 0x40,
    D3D12_HEAP_FLAG_DENY_NON_RT_DS_TEXTURES = 0x80,
    D3D12_HEAP_FLAG_HARDWARE_PROTECTED = 0x100,
    D3D12_HEAP_FLAG_ALLOW_WRITE_WATCH = 0x200,
    D3D12_HEAP_FLAG_ALLOW_ALL_BUFFERS_AND_TEXTURES = 0,
    D3D12_HEAP_FLAG_ALLOW_ONLY_BUFFERS = 0xc0,
    D3D12_HEAP_FLAG_ALLOW_ONLY_NON_RT_DS_TEXTURES = 0x44,
    D3D12_HEAP_FLAG_ALLOW_ONLY_RT_DS_TEXTURES = 0x84,
}}
STRUCT!{struct D3D12_HEAP_DESC {
    SizeInBytes: UINT64,
    Properties: D3D12_HEAP_PROPERTIES,
    Alignment: UINT64,
    Flags: D3D12_HEAP_FLAGS,
}}
ENUM!{enum D3D12_RESOURCE_DIMENSION {
    D3D12_RESOURCE_DIMENSION_UNKNOWN = 0,
    D3D12_RESOURCE_DIMENSION_BUFFER = 1,
    D3D12_RESOURCE_DIMENSION_TEXTURE1D = 2,
    D3D12_RESOURCE_DIMENSION_TEXTURE2D = 3,
    D3D12_RESOURCE_DIMENSION_TEXTURE3D = 4,
}}
ENUM!{enum D3D12_TEXTURE_LAYOUT {
    D3D12_TEXTURE_LAYOUT_UNKNOWN = 0,
    D3D12_TEXTURE_LAYOUT_ROW_MAJOR = 1,
    D3D12_TEXTURE_LAYOUT_64KB_UNDEFINED_SWIZZLE = 2,
    D3D12_TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE = 3,
}}
ENUM!{enum D3D12_RESOURCE_FLAGS {
    D3D12_RESOURCE_FLAG_NONE = 0,
    D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET = 0x1,
    D3D12_RESOURCE_FLAG_ALLOW_DEPTH_STENCIL = 0x2,
    D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS = 0x4,
    D3D12_RESOURCE_FLAG_DENY_SHADER_RESOURCE = 0x8,
    D3D12_RESOURCE_FLAG_ALLOW_CROSS_ADAPTER = 0x10,
    D3D12_RESOURCE_FLAG_ALLOW_SIMULTANEOUS_ACCESS = 0x20,
}}
STRUCT!{struct D3D12_RESOURCE_DESC {
    Dimension: D3D12_RESOURCE_DIMENSION,
    Alignment: UINT64,
    Width: UINT64,
    Height: UINT,
    DepthOrArraySize: UINT16,
    MipLevels: UINT16,
    Format: DXGI_FORMAT,
    SampleDesc: DXGI_SAMPLE_DESC,
    Layout: D3D12_TEXTURE_LAYOUT,
    Flags: D3D12_RESOURCE_FLAGS,
}}
STRUCT!{struct D3D12_DEPTH_STENCIL_VALUE {
    Depth: FLOAT,
    Stencil: UINT8,
}}
UNION!{union D3D12_CLEAR_VALUE_u {
    [u32; 4],
    Color Color_mut: [FLOAT; 4],
    DepthStencil DepthStencil_mut: D3D12_DEPTH_STENCIL_VALUE,
}}
STRUCT!{struct D3D12_CLEAR_VALUE {
    Format: DXGI_FORMAT,
    u: D3D12_CLEAR_VALUE_u,
}}
STRUCT!{struct D3D12_RANGE {
    Begin: SIZE_T,
    End: SIZE_T,
}}
STRUCT!{struct D3D12_RANGE_UINT64 {
    Begin: UINT64,
    End: UINT64,
}}
STRUCT!{struct D3D12_SUBRESOURCE_RANGE_UINT64 {
    Subresource: UINT,
    Range: D3D12_RANGE_UINT64,
}}
STRUCT!{struct D3D12_SUBRESOURCE_INFO {
    Offset: UINT64,
    RowPitch: UINT,
    DepthPitch: UINT,
}}
STRUCT!{struct D3D12_TILED_RESOURCE_COORDINATE {
    X: UINT,
    Y: UINT,
    Z: UINT,
    Subresource: UINT,
}}
STRUCT!{struct D3D12_TILE_REGION_SIZE {
    NumTiles: UINT,
    UseBox: BOOL,
    Width: UINT,
    Height: UINT16,
    Depth: UINT16,
}}
ENUM!{enum D3D12_TILE_RANGE_FLAGS {
    D3D12_TILE_RANGE_FLAG_NONE = 0,
    D3D12_TILE_RANGE_FLAG_NULL = 1,
    D3D12_TILE_RANGE_FLAG_SKIP = 2,
    D3D12_TILE_RANGE_FLAG_REUSE_SINGLE_TILE = 4,
}}
STRUCT!{struct D3D12_SUBRESOURCE_TILING {
    WidthInTiles: UINT,
    HeightInTiles: UINT16,
    DepthInTiles: UINT16,
    StartTileIndexInOverallResource: UINT,
}}
STRUCT!{struct D3D12_TILE_SHAPE {
    WidthInTexels: UINT,
    HeightInTexels: UINT,
    DepthInTexels: UINT,
}}
STRUCT!{struct D3D12_PACKED_MIP_INFO {
    NumStandardMips: UINT8,
    NumPackedMips: UINT8,
    NumTilesForPackedMips: UINT,
    StartTileIndexInOverallResource: UINT,
}}
ENUM!{enum D3D12_TILE_MAPPING_FLAGS {
    D3D12_TILE_MAPPING_FLAG_NONE = 0,
    D3D12_TILE_MAPPING_FLAG_NO_HAZARD = 0x1,
}}
ENUM!{enum D3D12_TILE_COPY_FLAGS {
    D3D12_TILE_COPY_FLAG_NONE = 0,
    D3D12_TILE_COPY_FLAG_NO_HAZARD = 0x1,
    D3D12_TILE_COPY_FLAG_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE = 0x2,
    D3D12_TILE_COPY_FLAG_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER = 0x4,
}}
ENUM!{enum D3D12_RESOURCE_STATES {
    D3D12_RESOURCE_STATE_COMMON = 0,
    D3D12_RESOURCE_STATE_VERTEX_AND_CONSTANT_BUFFER = 0x1,
    D3D12_RESOURCE_STATE_INDEX_BUFFER = 0x2,
    D3D12_RESOURCE_STATE_RENDER_TARGET = 0x4,
    D3D12_RESOURCE_STATE_UNORDERED_ACCESS = 0x8,
    D3D12_RESOURCE_STATE_DEPTH_WRITE = 0x10,
    D3D12_RESOURCE_STATE_DEPTH_READ = 0x20,
    D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE = 0x40,
    D3D12_RESOURCE_STATE_PIXEL_SHADER_RESOURCE = 0x80,
    D3D12_RESOURCE_STATE_STREAM_OUT = 0x100,
    D3D12_RESOURCE_STATE_INDIRECT_ARGUMENT = 0x200,
    D3D12_RESOURCE_STATE_COPY_DEST = 0x400,
    D3D12_RESOURCE_STATE_COPY_SOURCE = 0x800,
    D3D12_RESOURCE_STATE_RESOLVE_DEST = 0x1000,
    D3D12_RESOURCE_STATE_RESOLVE_SOURCE = 0x2000,
    D3D12_RESOURCE_STATE_GENERIC_READ = 0x1 | 0x2 | 0x40 | 0x80 | 0x200 | 0x800,
    D3D12_RESOURCE_STATE_PRESENT = 0,
    D3D12_RESOURCE_STATE_PREDICATION = 0x200,
}}
ENUM!{enum D3D12_RESOURCE_BARRIER_TYPE {
    D3D12_RESOURCE_BARRIER_TYPE_TRANSITION = 0,
    D3D12_RESOURCE_BARRIER_TYPE_ALIASING = 1,
    D3D12_RESOURCE_BARRIER_TYPE_UAV = 2,
}}
STRUCT!{struct D3D12_RESOURCE_TRANSITION_BARRIER {
    pResource: *mut ID3D12Resource,
    Subresource: UINT,
    StateBefore: D3D12_RESOURCE_STATES,
    StateAfter: D3D12_RESOURCE_STATES,
}}
STRUCT!{struct D3D12_RESOURCE_ALIASING_BARRIER {
    pResourceBefore: *mut ID3D12Resource,
    pResourceAfter: *mut ID3D12Resource,
}}
STRUCT!{struct D3D12_RESOURCE_UAV_BARRIER {
    pResource: *mut ID3D12Resource,
}}
ENUM!{enum D3D12_RESOURCE_BARRIER_FLAGS {
    D3D12_RESOURCE_BARRIER_FLAG_NONE = 0x0,
    D3D12_RESOURCE_BARRIER_FLAG_BEGIN_ONLY = 0x1,
    D3D12_RESOURCE_BARRIER_FLAG_END_ONLY = 0x2,
}}
UNION!{union D3D12_RESOURCE_BARRIER_u {
    [u32; 4] [u64; 3],
    Transition Transition_mut: D3D12_RESOURCE_TRANSITION_BARRIER,
    Aliasing Aliasing_mut: D3D12_RESOURCE_ALIASING_BARRIER,
    UAV UAV_mut: D3D12_RESOURCE_UAV_BARRIER,
}}
STRUCT!{struct D3D12_RESOURCE_BARRIER {
    Type: D3D12_RESOURCE_BARRIER_TYPE,
    Flags: D3D12_RESOURCE_BARRIER_FLAGS,
    u: D3D12_RESOURCE_BARRIER_u,
}}
STRUCT!{struct D3D12_SUBRESOURCE_FOOTPRINT {
    Format: DXGI_FORMAT,
    Width: UINT,
    Height: UINT,
    Depth: UINT,
    RowPitch: UINT,
}}
STRUCT!{struct D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    Offset: UINT64,
    Footprint: D3D12_SUBRESOURCE_FOOTPRINT,
}}
ENUM!{enum D3D12_TEXTURE_COPY_TYPE {
    D3D12_TEXTURE_COPY_TYPE_SUBRESOURCE_INDEX = 0,
    D3D12_TEXTURE_COPY_TYPE_PLACED_FOOTPRINT = 1,
}}
UNION!{union D3D12_TEXTURE_COPY_LOCATION_u {
    [u64; 4],
    PlacedFootprint PlacedFootprint_mut: D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
    SubresourceIndex SubresourceIndex_mut: UINT,
}}
STRUCT!{struct D3D12_TEXTURE_COPY_LOCATION {
    pResource: *mut ID3D12Resource,
    Type: D3D12_TEXTURE_COPY_TYPE,
    u: D3D12_TEXTURE_COPY_LOCATION_u,
}}
ENUM!{enum D3D12_RESOLVE_MODE {
    D3D12_RESOLVE_MODE_DECOMPRESS = 0,
    D3D12_RESOLVE_MODE_MIN = 1,
    D3D12_RESOLVE_MODE_MAX = 2,
    D3D12_RESOLVE_MODE_AVERAGE = 3,
}}
STRUCT!{struct D3D12_SAMPLE_POSITION {
    X: INT8,
    Y: INT8,
}}
ENUM!{enum D3D12_SHADER_COMPONENT_MAPPING {
    D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_0 = 0,
    D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_1 = 1,
    D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_2 = 2,
    D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_3 = 3,
    D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_0 = 4,
    D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_1 = 5,
}}
pub const D3D12_SHADER_COMPONENT_MAPPING_MASK: UINT = 0x7;
pub const D3D12_SHADER_COMPONENT_MAPPING_SHIFT: UINT = 3;
pub const D3D12_SHADER_COMPONENT_MAPPING_ALWAYS_SET_BIT_AVOIDING_ZEROMEM_MISTAKES: UINT = 1
    << (D3D12_SHADER_COMPONENT_MAPPING_SHIFT * 4);
// D3D12_ENCODE_SHADER_4_COMPONENT_MAPPING
// D3D12_DECODE_SHADER_4_COMPONENT_MAPPING
// D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING
ENUM!{enum D3D12_BUFFER_SRV_FLAGS {
    D3D12_BUFFER_SRV_FLAG_NONE = 0x0,
    D3D12_BUFFER_SRV_FLAG_RAW = 0x1,
}}
STRUCT!{struct D3D12_BUFFER_SRV {
    FirstElement: UINT64,
    NumElements: UINT,
    StructureByteStride: UINT,
    Flags: D3D12_BUFFER_SRV_FLAGS,
}}
STRUCT!{struct D3D12_TEX1D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEX1D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEX2D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    PlaneSlice: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEX2D_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
    PlaneSlice: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEX3D_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEXCUBE_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEXCUBE_ARRAY_SRV {
    MostDetailedMip: UINT,
    MipLevels: UINT,
    First2DArrayFace: UINT,
    NumCubes: UINT,
    ResourceMinLODClamp: FLOAT,
}}
STRUCT!{struct D3D12_TEX2DMS_SRV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D12_TEX2DMS_ARRAY_SRV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
ENUM!{enum D3D12_SRV_DIMENSION {
    D3D12_SRV_DIMENSION_UNKNOWN = 0,
    D3D12_SRV_DIMENSION_BUFFER = 1,
    D3D12_SRV_DIMENSION_TEXTURE1D = 2,
    D3D12_SRV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D12_SRV_DIMENSION_TEXTURE2D = 4,
    D3D12_SRV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D12_SRV_DIMENSION_TEXTURE2DMS = 6,
    D3D12_SRV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D12_SRV_DIMENSION_TEXTURE3D = 8,
    D3D12_SRV_DIMENSION_TEXTURECUBE = 9,
    D3D12_SRV_DIMENSION_TEXTURECUBEARRAY = 10,
}}
UNION!{union D3D12_SHADER_RESOURCE_VIEW_DESC_u {
    [u64; 3],
    Buffer Buffer_mut: D3D12_BUFFER_SRV,
    Texture1D Texture1D_mut: D3D12_TEX1D_SRV,
    Texture1DArray Texture1DArray_mut: D3D12_TEX1D_ARRAY_SRV,
    Texture2D Texture2D_mut: D3D12_TEX2D_SRV,
    Texture2DArray Texture2DArray_mut: D3D12_TEX2D_ARRAY_SRV,
    Texture2DMS Texture2DMS_mut: D3D12_TEX2DMS_SRV,
    Texture2DMSArray Texture2DMSArray_mut: D3D12_TEX2DMS_ARRAY_SRV,
    Texture3D Texture3D_mut: D3D12_TEX3D_SRV,
    TextureCube TextureCube_mut: D3D12_TEXCUBE_SRV,
    TextureCubeArray TextureCubeArray_mut: D3D12_TEXCUBE_ARRAY_SRV,
}}
STRUCT!{struct D3D12_SHADER_RESOURCE_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D12_SRV_DIMENSION,
    Shader4ComponentMapping: UINT,
    u: D3D12_SHADER_RESOURCE_VIEW_DESC_u,
}}
STRUCT!{struct D3D12_CONSTANT_BUFFER_VIEW_DESC {
    BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    SizeInBytes: UINT,
}}
ENUM!{enum D3D12_FILTER {
    D3D12_FILTER_MIN_MAG_MIP_POINT = 0,
    D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x1,
    D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x4,
    D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x5,
    D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
    D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
    D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
    D3D12_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
    D3D12_FILTER_ANISOTROPIC = 0x55,
    D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT = 0x80,
    D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR = 0x81,
    D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x84,
    D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR = 0x85,
    D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT = 0x90,
    D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x91,
    D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT = 0x94,
    D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR = 0x95,
    D3D12_FILTER_COMPARISON_ANISOTROPIC = 0xd5,
    D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT = 0x100,
    D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x101,
    D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x104,
    D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x105,
    D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x110,
    D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x111,
    D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x114,
    D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR = 0x115,
    D3D12_FILTER_MINIMUM_ANISOTROPIC = 0x155,
    D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT = 0x180,
    D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x181,
    D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x184,
    D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x185,
    D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x190,
    D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x191,
    D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x194,
    D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR = 0x195,
    D3D12_FILTER_MAXIMUM_ANISOTROPIC = 0x1d5,
}}
ENUM!{enum D3D12_FILTER_TYPE {
    D3D12_FILTER_TYPE_POINT = 0,
    D3D12_FILTER_TYPE_LINEAR = 1,
}}
ENUM!{enum D3D12_FILTER_REDUCTION_TYPE {
    D3D12_FILTER_REDUCTION_TYPE_STANDARD = 0,
    D3D12_FILTER_REDUCTION_TYPE_COMPARISON = 1,
    D3D12_FILTER_REDUCTION_TYPE_MINIMUM = 2,
    D3D12_FILTER_REDUCTION_TYPE_MAXIMUM = 3,
}}
pub const D3D12_FILTER_REDUCTION_TYPE_MASK: UINT = 0x3;
pub const D3D12_FILTER_REDUCTION_TYPE_SHIFT: UINT = 7;
pub const D3D12_FILTER_TYPE_MASK: UINT = 0x3;
pub const D3D12_MIN_FILTER_SHIFT: UINT = 4;
pub const D3D12_MAG_FILTER_SHIFT: UINT = 2;
pub const D3D12_MIP_FILTER_SHIFT: UINT = 0;
pub const D3D12_ANISOTROPIC_FILTERING_BIT: UINT = 0x40;
// D3D12_ENCODE_BASIC_FILTER
// D3D12_ENCODE_ANISOTROPIC_FILTER
// D3D12_DECODE_MIN_FILTER
// D3D12_DECODE_MAG_FILTER
// D3D12_DECODE_MIP_FILTER
// D3D12_DECODE_FILTER_REDUCTION
// D3D12_DECODE_IS_COMPARISON_FILTER
// D3D12_DECODE_IS_ANISOTROPIC_FILTER
ENUM!{enum D3D12_TEXTURE_ADDRESS_MODE {
    D3D12_TEXTURE_ADDRESS_MODE_WRAP = 1,
    D3D12_TEXTURE_ADDRESS_MODE_MIRROR = 2,
    D3D12_TEXTURE_ADDRESS_MODE_CLAMP = 3,
    D3D12_TEXTURE_ADDRESS_MODE_BORDER = 4,
    D3D12_TEXTURE_ADDRESS_MODE_MIRROR_ONCE = 5,
}}
STRUCT!{struct D3D12_SAMPLER_DESC {
    Filter: D3D12_FILTER,
    AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    MipLODBias: FLOAT,
    MaxAnisotropy: UINT,
    ComparisonFunc: D3D12_COMPARISON_FUNC,
    BorderColor: [FLOAT; 4],
    MinLOD: FLOAT,
    MaxLOD: FLOAT,
}}
ENUM!{enum D3D12_BUFFER_UAV_FLAGS {
    D3D12_BUFFER_UAV_FLAG_NONE = 0,
    D3D12_BUFFER_UAV_FLAG_RAW = 0x1,
}}
STRUCT!{struct D3D12_BUFFER_UAV {
    FirstElement: UINT64,
    NumElements: UINT,
    StructureByteStride: UINT,
    CounterOffsetInBytes: UINT64,
    Flags: D3D12_BUFFER_UAV_FLAGS,
}}
STRUCT!{struct D3D12_TEX1D_UAV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D12_TEX1D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D12_TEX2D_UAV {
    MipSlice: UINT,
    PlaneSlice: UINT,
}}
STRUCT!{struct D3D12_TEX2D_ARRAY_UAV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
    PlaneSlice: UINT,
}}
STRUCT!{struct D3D12_TEX3D_UAV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
ENUM!{enum D3D12_UAV_DIMENSION {
    D3D12_UAV_DIMENSION_UNKNOWN = 0,
    D3D12_UAV_DIMENSION_BUFFER = 1,
    D3D12_UAV_DIMENSION_TEXTURE1D = 2,
    D3D12_UAV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D12_UAV_DIMENSION_TEXTURE2D = 4,
    D3D12_UAV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D12_UAV_DIMENSION_TEXTURE3D = 8,
}}
UNION!{union D3D12_UNORDERED_ACCESS_VIEW_DESC_u {
    [u64; 4],
    Buffer Buffer_mut: D3D12_BUFFER_UAV,
    Texture1D Texture1D_mut: D3D12_TEX1D_UAV,
    Texture1DArray Texture1DArray_mut: D3D12_TEX1D_ARRAY_UAV,
    Texture2D Texture2D_mut: D3D12_TEX2D_UAV,
    Texture2DArray Texture2DArray_mut: D3D12_TEX2D_ARRAY_UAV,
    Texture3D Texture3D_mut: D3D12_TEX3D_UAV,
}}
STRUCT!{struct D3D12_UNORDERED_ACCESS_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D12_UAV_DIMENSION,
    u: D3D12_UNORDERED_ACCESS_VIEW_DESC_u,
}}
STRUCT!{struct D3D12_BUFFER_RTV {
    FirstElement: UINT64,
    NumElements: UINT,
}}
STRUCT!{struct D3D12_TEX1D_RTV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D12_TEX1D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D12_TEX2D_RTV {
    MipSlice: UINT,
    PlaneSlice: UINT,
}}
STRUCT!{struct D3D12_TEX2DMS_RTV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D12_TEX2D_ARRAY_RTV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
    PlaneSlice: UINT,
}}
STRUCT!{struct D3D12_TEX2DMS_ARRAY_RTV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D12_TEX3D_RTV {
    MipSlice: UINT,
    FirstWSlice: UINT,
    WSize: UINT,
}}
ENUM!{enum D3D12_RTV_DIMENSION {
    D3D12_RTV_DIMENSION_UNKNOWN = 0,
    D3D12_RTV_DIMENSION_BUFFER = 1,
    D3D12_RTV_DIMENSION_TEXTURE1D = 2,
    D3D12_RTV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D12_RTV_DIMENSION_TEXTURE2D = 4,
    D3D12_RTV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D12_RTV_DIMENSION_TEXTURE2DMS = 6,
    D3D12_RTV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D12_RTV_DIMENSION_TEXTURE3D = 8,
}}
UNION!{union D3D12_RENDER_TARGET_VIEW_DESC_u {
    [u64; 2],
    Buffer Buffer_mut: D3D12_BUFFER_RTV,
    Texture1D Texture1D_mut: D3D12_TEX1D_RTV,
    Texture1DArray Texture1DArray_mut: D3D12_TEX1D_ARRAY_RTV,
    Texture2D Texture2D_mut: D3D12_TEX2D_RTV,
    Texture2DArray Texture2DArray_mut: D3D12_TEX2D_ARRAY_RTV,
    Texture2DMS Texture2DMS_mut: D3D12_TEX2DMS_RTV,
    Texture2DMSArray Texture2DMSArray_mut: D3D12_TEX2DMS_ARRAY_RTV,
    Texture3D Texture3D_mut: D3D12_TEX3D_RTV,
}}
STRUCT!{struct D3D12_RENDER_TARGET_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D12_RTV_DIMENSION,
    u: D3D12_RENDER_TARGET_VIEW_DESC_u,
}}
STRUCT!{struct D3D12_TEX1D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D12_TEX1D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D12_TEX2D_DSV {
    MipSlice: UINT,
}}
STRUCT!{struct D3D12_TEX2D_ARRAY_DSV {
    MipSlice: UINT,
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
STRUCT!{struct D3D12_TEX2DMS_DSV {
    UnusedField_NothingToDefine: UINT,
}}
STRUCT!{struct D3D12_TEX2DMS_ARRAY_DSV {
    FirstArraySlice: UINT,
    ArraySize: UINT,
}}
ENUM!{enum D3D12_DSV_FLAGS {
    D3D12_DSV_FLAG_NONE = 0x0,
    D3D12_DSV_FLAG_READ_ONLY_DEPTH = 0x1,
    D3D12_DSV_FLAG_READ_ONLY_STENCIL = 0x2,
}}
ENUM!{enum D3D12_DSV_DIMENSION {
    D3D12_DSV_DIMENSION_UNKNOWN = 0,
    D3D12_DSV_DIMENSION_TEXTURE1D = 1,
    D3D12_DSV_DIMENSION_TEXTURE1DARRAY = 2,
    D3D12_DSV_DIMENSION_TEXTURE2D = 3,
    D3D12_DSV_DIMENSION_TEXTURE2DARRAY = 4,
    D3D12_DSV_DIMENSION_TEXTURE2DMS = 5,
    D3D12_DSV_DIMENSION_TEXTURE2DMSARRAY = 6,
}}
UNION!{union D3D12_DEPTH_STENCIL_VIEW_DESC_u {
    [u32; 3],
    Texture1D Texture1D_mut: D3D12_TEX1D_DSV,
    Texture1DArray Texture1DArray_mut: D3D12_TEX1D_ARRAY_DSV,
    Texture2D Texture2D_mut: D3D12_TEX2D_DSV,
    Texture2DArray Texture2DArray_mut: D3D12_TEX2D_ARRAY_DSV,
    Texture2DMS Texture2DMS_mut: D3D12_TEX2DMS_DSV,
    Texture2DMSArray Texture2DMSArray_mut: D3D12_TEX2DMS_ARRAY_DSV,
}}
STRUCT!{struct D3D12_DEPTH_STENCIL_VIEW_DESC {
    Format: DXGI_FORMAT,
    ViewDimension: D3D12_DSV_DIMENSION,
    Flags: D3D12_DSV_FLAGS,
    u: D3D12_DEPTH_STENCIL_VIEW_DESC_u,
}}
ENUM!{enum D3D12_CLEAR_FLAGS {
    D3D12_CLEAR_FLAG_DEPTH = 0x1,
    D3D12_CLEAR_FLAG_STENCIL = 0x2,
}}
ENUM!{enum D3D12_FENCE_FLAGS {
    D3D12_FENCE_FLAG_NONE = 0x0,
    D3D12_FENCE_FLAG_SHARED = 0x1,
    D3D12_FENCE_FLAG_SHARED_CROSS_ADAPTER = 0x2,
}}
ENUM!{enum D3D12_DESCRIPTOR_HEAP_TYPE {
    D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV = 0,
    D3D12_DESCRIPTOR_HEAP_TYPE_SAMPLER = 1,
    D3D12_DESCRIPTOR_HEAP_TYPE_RTV = 2,
    D3D12_DESCRIPTOR_HEAP_TYPE_DSV = 3,
    D3D12_DESCRIPTOR_HEAP_TYPE_NUM_TYPES = 4,
}}
ENUM!{enum D3D12_DESCRIPTOR_HEAP_FLAGS {
    D3D12_DESCRIPTOR_HEAP_FLAG_NONE = 0x0,
    D3D12_DESCRIPTOR_HEAP_FLAG_SHADER_VISIBLE = 0x1,
}}
STRUCT!{struct D3D12_DESCRIPTOR_HEAP_DESC {
    Type: D3D12_DESCRIPTOR_HEAP_TYPE,
    NumDescriptors: UINT,
    Flags: D3D12_DESCRIPTOR_HEAP_FLAGS,
    NodeMask: UINT,
}}
ENUM!{enum D3D12_DESCRIPTOR_RANGE_TYPE {
    D3D12_DESCRIPTOR_RANGE_TYPE_SRV = 0,
    D3D12_DESCRIPTOR_RANGE_TYPE_UAV = 1,
    D3D12_DESCRIPTOR_RANGE_TYPE_CBV = 2,
    D3D12_DESCRIPTOR_RANGE_TYPE_SAMPLER = 3,
}}
STRUCT!{struct D3D12_DESCRIPTOR_RANGE {
    RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    NumDescriptors: UINT,
    BaseShaderRegister: UINT,
    RegisterSpace: UINT,
    OffsetInDescriptorsFromTableStart: UINT,
}}
STRUCT!{struct D3D12_ROOT_DESCRIPTOR_TABLE {
    NumDescriptorRanges: UINT,
    pDescriptorRanges: *const D3D12_DESCRIPTOR_RANGE,
}}
STRUCT!{struct D3D12_ROOT_CONSTANTS {
    ShaderRegister: UINT,
    RegisterSpace: UINT,
    Num32BitValues: UINT,
}}
STRUCT!{struct D3D12_ROOT_DESCRIPTOR {
    ShaderRegister: UINT,
    RegisterSpace: UINT,
}}
ENUM!{enum D3D12_SHADER_VISIBILITY {
    D3D12_SHADER_VISIBILITY_ALL = 0,
    D3D12_SHADER_VISIBILITY_VERTEX = 1,
    D3D12_SHADER_VISIBILITY_HULL = 2,
    D3D12_SHADER_VISIBILITY_DOMAIN = 3,
    D3D12_SHADER_VISIBILITY_GEOMETRY = 4,
    D3D12_SHADER_VISIBILITY_PIXEL = 5,
}}
ENUM!{enum D3D12_ROOT_PARAMETER_TYPE {
    D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE = 0,
    D3D12_ROOT_PARAMETER_TYPE_32BIT_CONSTANTS = 1,
    D3D12_ROOT_PARAMETER_TYPE_CBV = 2,
    D3D12_ROOT_PARAMETER_TYPE_SRV = 3,
    D3D12_ROOT_PARAMETER_TYPE_UAV = 4,
}}
UNION!{union D3D12_ROOT_PARAMETER_u {
    [u32; 3] [u64; 2],
    DescriptorTable DescriptorTable_mut: D3D12_ROOT_DESCRIPTOR_TABLE,
    Constants Constants_mut: D3D12_ROOT_CONSTANTS,
    Descriptor Descriptor_mut: D3D12_ROOT_DESCRIPTOR,
}}
STRUCT!{struct D3D12_ROOT_PARAMETER {
    ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    u: D3D12_ROOT_PARAMETER_u,
    ShaderVisibility: D3D12_SHADER_VISIBILITY,
}}
ENUM!{enum D3D12_ROOT_SIGNATURE_FLAGS {
    D3D12_ROOT_SIGNATURE_FLAG_NONE = 0x0,
    D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT = 0x1,
    D3D12_ROOT_SIGNATURE_FLAG_DENY_VERTEX_SHADER_ROOT_ACCESS = 0x2,
    D3D12_ROOT_SIGNATURE_FLAG_DENY_HULL_SHADER_ROOT_ACCESS = 0x4,
    D3D12_ROOT_SIGNATURE_FLAG_DENY_DOMAIN_SHADER_ROOT_ACCESS = 0x8,
    D3D12_ROOT_SIGNATURE_FLAG_DENY_GEOMETRY_SHADER_ROOT_ACCESS = 0x10,
    D3D12_ROOT_SIGNATURE_FLAG_DENY_PIXEL_SHADER_ROOT_ACCESS = 0x20,
    D3D12_ROOT_SIGNATURE_FLAG_ALLOW_STREAM_OUTPUT = 0x40,
}}
ENUM!{enum D3D12_STATIC_BORDER_COLOR {
    D3D12_STATIC_BORDER_COLOR_TRANSPARENT_BLACK = 0,
    D3D12_STATIC_BORDER_COLOR_OPAQUE_BLACK = 1,
    D3D12_STATIC_BORDER_COLOR_OPAQUE_WHITE = 2,
}}
STRUCT!{struct D3D12_STATIC_SAMPLER_DESC {
    Filter: D3D12_FILTER,
    AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    MipLODBias: FLOAT,
    MaxAnisotropy: UINT,
    ComparisonFunc: D3D12_COMPARISON_FUNC,
    BorderColor: D3D12_STATIC_BORDER_COLOR,
    MinLOD: FLOAT,
    MaxLOD: FLOAT,
    ShaderRegister: UINT,
    RegisterSpace: UINT,
    ShaderVisibility: D3D12_SHADER_VISIBILITY,
}}
STRUCT!{struct D3D12_ROOT_SIGNATURE_DESC {
    NumParameters: UINT,
    pParameters: *const D3D12_ROOT_PARAMETER,
    NumStaticSamplers: UINT,
    pStaticSamplers: *const D3D12_STATIC_SAMPLER_DESC,
    Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}}
ENUM!{enum D3D12_DESCRIPTOR_RANGE_FLAGS {
    D3D12_DESCRIPTOR_RANGE_FLAG_NONE = 0,
    D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_VOLATILE = 0x1,
    D3D12_DESCRIPTOR_RANGE_FLAG_DATA_VOLATILE = 0x2,
    D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE = 0x4,
    D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC = 0x8,
}}
STRUCT!{struct D3D12_DESCRIPTOR_RANGE1 {
    RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    NumDescriptors: UINT,
    BaseShaderRegister: UINT,
    RegisterSpace: UINT,
    Flags: D3D12_DESCRIPTOR_RANGE_FLAGS,
    OffsetInDescriptorsFromTableStart: UINT,
}}
STRUCT!{struct D3D12_ROOT_DESCRIPTOR_TABLE1 {
    NumDescriptorRanges: UINT,
    pDescriptorRanges: *const D3D12_DESCRIPTOR_RANGE1,
}}
ENUM!{enum D3D12_ROOT_DESCRIPTOR_FLAGS {
    D3D12_ROOT_DESCRIPTOR_FLAG_NONE = 0,
    D3D12_ROOT_DESCRIPTOR_FLAG_DATA_VOLATILE = 0x2,
    D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE = 0x4,
    D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC = 0x8,
}}
STRUCT!{struct D3D12_ROOT_DESCRIPTOR1 {
    ShaderRegister: UINT,
    RegisterSpace: UINT,
    Flags: D3D12_ROOT_DESCRIPTOR_FLAGS,
}}
UNION!{union D3D12_ROOT_PARAMETER1_u {
    [u32; 3] [u64; 2],
    DescriptorTable DescriptorTable_mut: D3D12_ROOT_DESCRIPTOR_TABLE1,
    Constants Constants_mut: D3D12_ROOT_CONSTANTS,
    Descriptor Descriptor_mut: D3D12_ROOT_DESCRIPTOR1,
}}
STRUCT!{struct D3D12_ROOT_PARAMETER1 {
    ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    u: D3D12_ROOT_PARAMETER1_u,
    ShaderVisibility: D3D12_SHADER_VISIBILITY,
}}
STRUCT!{struct D3D12_ROOT_SIGNATURE_DESC1 {
    NumParameters: UINT,
    pParameters: *const D3D12_ROOT_PARAMETER1,
    NumStaticSamplers: UINT,
    pStaticSamplers: *const D3D12_STATIC_SAMPLER_DESC,
    Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}}
UNION!{union D3D12_VERSIONED_ROOT_SIGNATURE_DESC_u {
    [u32; 5] [u64; 5],
    Desc_1_0 Desc_1_0_mut: D3D12_ROOT_SIGNATURE_DESC,
    Desc_1_1 Desc_1_1_mut: D3D12_ROOT_SIGNATURE_DESC1,
}}
STRUCT!{struct D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    Version: UINT,
    u: D3D12_VERSIONED_ROOT_SIGNATURE_DESC_u,
}}
RIDL!{#[uuid(0x34ab647b, 0x3cc8, 0x46ac, 0x84, 0x1b, 0xc0, 0x96, 0x56, 0x45, 0xc0, 0x46)]
interface ID3D12RootSignatureDeserializer(ID3D12RootSignatureDeserializerVtbl):
    IUnknown(IUnknownVtbl) {
    fn GetRootSignatureDesc() -> *const D3D12_ROOT_SIGNATURE_DESC,
}}
RIDL!{#[uuid(0x7f91ce67, 0x090c, 0x4bb7, 0xb7, 0x8e, 0xed, 0x8f, 0xf2, 0xe3, 0x1d, 0xa0)]
interface ID3D12VersionedRootSignatureDeserializer(ID3D12VersionedRootSignatureDeserializerVtbl):
    IUnknown(IUnknownVtbl) {
    fn GetRootSignatureDescAtVersion(
        convertToVersion: D3D_ROOT_SIGNATURE_VERSION,
        ppDesc: *mut *mut D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
    ) -> HRESULT,
    fn GetUnconvertedRootSignatureDesc() -> *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
}}
FN!{stdcall PFN_D3D12_SERIALIZE_ROOT_SIGNATURE(
    pRootSignature: *const D3D12_ROOT_SIGNATURE_DESC,
    Version: D3D_ROOT_SIGNATURE_VERSION,
    ppBlob: *mut *mut ID3DBlob,
    ppErrorBlob: *mut *mut ID3DBlob,
) -> HRESULT}
extern "system" {
    pub fn D3D12SerializeRootSignature(
        pRootSignature: *const D3D12_ROOT_SIGNATURE_DESC,
        Version: D3D_ROOT_SIGNATURE_VERSION,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT;
}
FN!{stdcall PFN_D3D12_CREATE_ROOT_SIGNATURE_DESERIALIZER(
    pSrcData: LPCVOID,
    SrcDataSizeInBytes: SIZE_T,
    pRootSignatureDeserializerInterface: REFIID,
    ppRootSignatureDeserializer: *mut *mut c_void,
) -> HRESULT}
extern "system" {
    pub fn D3D12CreateRootSignatureDeserializer(
        pSrcData: LPCVOID,
        SrcDataSizeInBytes: SIZE_T,
        pRootSignatureDeserializerInterface: REFGUID,
        ppRootSignatureDeserializer: *mut *mut c_void,
    ) -> HRESULT;
}
FN!{stdcall PFN_D3D12_SERIALIZE_VERSIONED_ROOT_SIGNATURE(
    pRootSignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
    ppBlob: *mut *mut ID3DBlob,
    ppErrorBlob: *mut *mut ID3DBlob,
) -> HRESULT}
extern "system" {
    pub fn D3D12SerializeVersionedRootSignature(
        pRootSignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC,
        ppBlob: *mut *mut ID3DBlob,
        ppErrorBlob: *mut *mut ID3DBlob,
    ) -> HRESULT;
}
FN!{stdcall PFN_D3D12_CREATE_VERSIONED_ROOT_SIGNATURE_DESERIALIZER(
    pSrcData: LPCVOID,
    SrcDataSizeInBytes: SIZE_T,
    pRootSignatureDeserializerInterface: REFIID,
    ppRootSignatureDeserializer: *mut *mut c_void,
) -> HRESULT}
extern "system" {
    pub fn D3D12CreateVersionedRootSignatureDeserializer(
        pSrcData: LPCVOID,
        SrcDataSizeInBytes: SIZE_T,
        pRootSignatureDeserializerInterface: REFIID,
        ppRootSignatureDeserializer: *mut *mut c_void,
    ) -> HRESULT;
}
STRUCT!{struct D3D12_CPU_DESCRIPTOR_HANDLE {
    ptr: SIZE_T,
}}
STRUCT!{struct D3D12_GPU_DESCRIPTOR_HANDLE {
    ptr: UINT64,
}}
STRUCT!{struct D3D12_DISCARD_REGION {
    NumRects: UINT,
    pRects: *const D3D12_RECT,
    FirstSubresource: UINT,
    NumSubresources: UINT,
}}
ENUM!{enum D3D12_QUERY_HEAP_TYPE {
    D3D12_QUERY_HEAP_TYPE_OCCLUSION = 0,
    D3D12_QUERY_HEAP_TYPE_TIMESTAMP = 1,
    D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS = 2,
    D3D12_QUERY_HEAP_TYPE_SO_STATISTICS = 3,
}}
STRUCT!{struct D3D12_QUERY_HEAP_DESC {
    Type: D3D12_QUERY_HEAP_TYPE,
    Count: UINT,
    NodeMask: UINT,
}}
ENUM!{enum D3D12_QUERY_TYPE {
    D3D12_QUERY_TYPE_OCCLUSION = 0,
    D3D12_QUERY_TYPE_BINARY_OCCLUSION = 1,
    D3D12_QUERY_TYPE_TIMESTAMP = 2,
    D3D12_QUERY_TYPE_PIPELINE_STATISTICS = 3,
    D3D12_QUERY_TYPE_SO_STATISTICS_STREAM0 = 4,
    D3D12_QUERY_TYPE_SO_STATISTICS_STREAM1 = 5,
    D3D12_QUERY_TYPE_SO_STATISTICS_STREAM2 = 6,
    D3D12_QUERY_TYPE_SO_STATISTICS_STREAM3 = 7,
}}
ENUM!{enum D3D12_PREDICATION_OP {
    D3D12_PREDICATION_OP_EQUAL_ZERO = 0,
    D3D12_PREDICATION_OP_NOT_EQUAL_ZERO = 1,
}}
STRUCT!{struct D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    IAVertices: UINT64,
    IAPrimitives: UINT64,
    VSInvocations: UINT64,
    GSInvocations: UINT64,
    GSPrimitives: UINT64,
    CInvocations: UINT64,
    CPrimitives: UINT64,
    PSInvocations: UINT64,
    HSInvocations: UINT64,
    DSInvocations: UINT64,
    CSInvocations: UINT64,
}}
STRUCT!{struct D3D12_QUERY_DATA_SO_STATISTICS {
    NumPrimitivesWritten: UINT64,
    PrimitivesStorageNeeded: UINT64,
}}
STRUCT!{struct D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    SizeInBytes: UINT64,
    BufferFilledSizeLocation: D3D12_GPU_VIRTUAL_ADDRESS,
}}
STRUCT!{struct D3D12_DRAW_ARGUMENTS {
    VertexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartVertexLocation: UINT,
    StartInstanceLocation: UINT,
}}
STRUCT!{struct D3D12_DRAW_INDEXED_ARGUMENTS {
    IndexCountPerInstance: UINT,
    InstanceCount: UINT,
    StartIndexLocation: UINT,
    BaseVertexLocation: INT,
    StartInstanceLocation: UINT,
}}
STRUCT!{struct D3D12_DISPATCH_ARGUMENTS {
    ThreadGroupCountX: UINT,
    ThreadGroupCountY: UINT,
    ThreadGroupCountZ: UINT,
}}
STRUCT!{struct D3D12_VERTEX_BUFFER_VIEW {
    BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    SizeInBytes: UINT,
    StrideInBytes: UINT,
}}
STRUCT!{struct D3D12_INDEX_BUFFER_VIEW {
    BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    SizeInBytes: UINT,
    Format: DXGI_FORMAT,
}}
ENUM!{enum D3D12_INDIRECT_ARGUMENT_TYPE {
    D3D12_INDIRECT_ARGUMENT_TYPE_DRAW = 0,
    D3D12_INDIRECT_ARGUMENT_TYPE_DRAW_INDEXED = 1,
    D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH = 2,
    D3D12_INDIRECT_ARGUMENT_TYPE_VERTEX_BUFFER_VIEW = 3,
    D3D12_INDIRECT_ARGUMENT_TYPE_INDEX_BUFFER_VIEW = 4,
    D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT = 5,
    D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT_BUFFER_VIEW = 6,
    D3D12_INDIRECT_ARGUMENT_TYPE_SHADER_RESOURCE_VIEW = 7,
    D3D12_INDIRECT_ARGUMENT_TYPE_UNORDERED_ACCESS_VIEW = 8,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC_VertexBuffer {
    Slot: UINT,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC_Constant {
    RootParameterIndex: UINT,
    DestOffsetIn32BitValues: UINT,
    Num32BitValuesToSet: UINT,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC_ConstantBufferView {
    RootParameterIndex: UINT,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC_ShaderResourceView {
    RootParameterIndex: UINT,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC_UnorderedAccessView {
    RootParameterIndex: UINT,
}}
UNION!{union D3D12_INDIRECT_ARGUMENT_DESC_u {
    [u32; 3],
    VertexBuffer VertexBuffer_mut: D3D12_INDIRECT_ARGUMENT_DESC_VertexBuffer,
    Constant Constant_mut: D3D12_INDIRECT_ARGUMENT_DESC_Constant,
    ConstantBufferView ConstantBufferView_mut: D3D12_INDIRECT_ARGUMENT_DESC_ConstantBufferView,
    ShaderResourceView ShaderResourceView_mut: D3D12_INDIRECT_ARGUMENT_DESC_ShaderResourceView,
    UnorderedAccessView UnorderedAccessView_mut: D3D12_INDIRECT_ARGUMENT_DESC_UnorderedAccessView,
}}
STRUCT!{struct D3D12_INDIRECT_ARGUMENT_DESC {
    Type: D3D12_INDIRECT_ARGUMENT_TYPE,
    u: D3D12_INDIRECT_ARGUMENT_DESC_u,
}}
STRUCT!{struct D3D12_COMMAND_SIGNATURE_DESC {
    ByteStride: UINT,
    NumArgumentDescs: UINT,
    pArgumentDescs: *const D3D12_INDIRECT_ARGUMENT_DESC,
    NodeMask: UINT,
}}
RIDL!{#[uuid(0xc4fec28f, 0x7966, 0x4e95, 0x9f, 0x94, 0xf4, 0x31, 0xcb, 0x56, 0xc3, 0xb8)]
interface ID3D12Object(ID3D12ObjectVtbl): IUnknown(IUnknownVtbl) {
    fn GetPrivateData(
        guid: REFGUID,
        pDataSize: *mut UINT,
        pData: *mut c_void,
    ) -> HRESULT,
    fn SetPrivateData(
        guid: REFGUID,
        DataSize: UINT,
        pData: *const c_void,
    ) -> HRESULT,
    fn SetPrivateDataInterface(
        guid: REFGUID,
        pData: *const IUnknown,
    ) -> HRESULT,
    fn SetName(
        Name: LPCWSTR,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x905db94b, 0xa00c, 0x4140, 0x9d, 0xf5, 0x2b, 0x64, 0xca, 0x9e, 0xa3, 0x57)]
interface ID3D12DeviceChild(ID3D12DeviceChildVtbl): ID3D12Object(ID3D12ObjectVtbl) {
    fn GetDevice(
        riid: REFIID,
        ppvDevice: *mut *mut c_void,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x63ee58fb, 0x1268, 0x4835, 0x86, 0xda, 0xf0, 0x08, 0xce, 0x62, 0xf0, 0xd6)]
interface ID3D12Pageable(ID3D12PageableVtbl): ID3D12DeviceChild(ID3D12DeviceChildVtbl) {}}
RIDL!(#[uuid(0x6b3b2502, 0x6e51, 0x45b3, 0x90, 0xee, 0x98, 0x84, 0x26, 0x5e, 0x8d, 0xf3)]
interface ID3D12Heap(ID3D12HeapVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    #[fixme] fn GetDesc() -> D3D12_HEAP_DESC,
});
RIDL!(#[uuid(0x696442be, 0xa72e, 0x4059, 0xbc, 0x79, 0x5b, 0x5c, 0x98, 0x04, 0x0f, 0xad)]
interface ID3D12Resource(ID3D12ResourceVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    fn Map(
        Subresource: UINT,
        pReadRange: *const D3D12_RANGE,
        ppData: *mut *mut c_void,
    ) -> HRESULT,
    fn Unmap(
        Subresource: UINT,
        pWrittenRange: *const D3D12_RANGE,
    ) -> (),
    #[fixme] fn GetDesc() -> D3D12_RESOURCE_DESC,
    fn GetGPUVirtualAddress() -> D3D12_GPU_VIRTUAL_ADDRESS,
    fn WriteToSubresource(
        DstSubresource: UINT,
        pDstBox: *const D3D12_BOX,
        pSrcData: *const c_void,
        SrcRowPitch: UINT,
        SrcDepthPitch: UINT,
    ) -> HRESULT,
    fn ReadFromSubresource(
        pDstData: *mut c_void,
        DstRowPitch: UINT,
        DstDepthPitch: UINT,
        SrcSubresource: UINT,
        pSrcBox: *const D3D12_BOX,
    ) -> HRESULT,
    fn GetHeapProperties(
        pHeapProperties: *mut D3D12_HEAP_PROPERTIES,
        pHeapFlags: *mut D3D12_HEAP_FLAGS,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x6102dee4, 0xaf59, 0x4b09, 0xb9, 0x99, 0xb4, 0x4d, 0x73, 0xf0, 0x9b, 0x24)]
interface ID3D12CommandAllocator(ID3D12CommandAllocatorVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    fn Reset() -> HRESULT,
});
RIDL!(#[uuid(0x0a753dcf, 0xc4d8, 0x4b91, 0xad, 0xf6, 0xbe, 0x5a, 0x60, 0xd9, 0x5a, 0x76)]
interface ID3D12Fence(ID3D12FenceVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    fn GetCompletedValue() -> UINT64,
    fn SetEventOnCompletion(
        Value: UINT64,
        hEvent: HANDLE,
    ) -> HRESULT,
    fn Signal(
        Value: UINT64,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x765a30f3, 0xf624, 0x4c6f, 0xa8, 0x28, 0xac, 0xe9, 0x48, 0x62, 0x24, 0x45)]
interface ID3D12PipelineState(ID3D12PipelineStateVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    fn GetCachedBlob(
        ppBlob: *mut *mut ID3DBlob,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x8efb471d, 0x616c, 0x4f49, 0x90, 0xf7, 0x12, 0x7b, 0xb7, 0x63, 0xfa, 0x51)]
interface ID3D12DescriptorHeap(ID3D12DescriptorHeapVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    #[fixme] fn GetDesc() -> D3D12_DESCRIPTOR_HEAP_DESC,
    #[fixme] fn GetCPUDescriptorHandleForHeapStart() -> D3D12_CPU_DESCRIPTOR_HANDLE,
    #[fixme] fn GetGPUDescriptorHandleForHeapStart() -> D3D12_GPU_DESCRIPTOR_HANDLE,
});
RIDL!{#[uuid(0x0d9658ae, 0xed45, 0x469e, 0xa6, 0x1d, 0x97, 0x0e, 0xc5, 0x83, 0xca, 0xb4)]
interface ID3D12QueryHeap(ID3D12QueryHeapVtbl): ID3D12Pageable(ID3D12PageableVtbl) {}}
RIDL!{#[uuid(0xc36a797c, 0xec80, 0x4f0a, 0x89, 0x85, 0xa7, 0xb2, 0x47, 0x50, 0x82, 0xd1)]
interface ID3D12CommandSignature(ID3D12CommandSignatureVtbl):
    ID3D12Pageable(ID3D12PageableVtbl) {}}
RIDL!(#[uuid(0x7116d91c, 0xe7e4, 0x47ce, 0xb8, 0xc6, 0xec, 0x81, 0x68, 0xf4, 0x37, 0xe5)]
interface ID3D12CommandList(ID3D12CommandListVtbl): ID3D12DeviceChild(ID3D12DeviceChildVtbl) {
    fn GetType() -> D3D12_COMMAND_LIST_TYPE,
});
RIDL!{#[uuid(0x5b160d0f, 0xac1b, 0x4185, 0x8b, 0xa8, 0xb3, 0xae, 0x42, 0xa5, 0xa4, 0x55)]
interface ID3D12GraphicsCommandList(ID3D12GraphicsCommandListVtbl):
    ID3D12CommandList(ID3D12CommandListVtbl) {
    fn Close() -> HRESULT,
    fn Reset(
        pAllocator: *mut ID3D12CommandAllocator,
        pInitialState: *mut ID3D12PipelineState,
    ) -> HRESULT,
    fn ClearState(
        pPipelineState: *mut ID3D12PipelineState,
    ) -> (),
    fn DrawInstanced(
        VertexCountPerInstance: UINT,
        InstanceCount: UINT,
        StartVertexLocation: UINT,
        StartInstanceLocation: UINT,
    ) -> (),
    fn DrawIndexedInstanced(
        IndexCountPerInstance: UINT,
        InstanceCount: UINT,
        StartIndexLocation: UINT,
        BaseVertexLocation: INT,
        StartInstanceLocation: UINT,
    ) -> (),
    fn Dispatch(
        ThreadGroupCountX: UINT,
        ThreadGroupCountY: UINT,
        ThreadGroupCountZ: UINT,
    ) -> (),
    fn CopyBufferRegion(
        pDstBuffer: *mut ID3D12Resource,
        DstOffset: UINT64,
        pSrcBuffer: *mut ID3D12Resource,
        SrcOffset: UINT64,
        NumBytes: UINT64,
    ) -> (),
    fn CopyTextureRegion(
        pDst: *const D3D12_TEXTURE_COPY_LOCATION,
        DstX: UINT,
        DstY: UINT,
        DstZ: UINT,
        pSrc: *const D3D12_TEXTURE_COPY_LOCATION,
        pSrcBox: *const D3D12_BOX,
    ) -> (),
    fn CopyResource(
        pDstResource: *mut ID3D12Resource,
        pSrcResource: *mut ID3D12Resource,
    ) -> (),
    fn CopyTiles(
        pTiledResource: *mut ID3D12Resource,
        pTileRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
        pTileRegionSize: *const D3D12_TILE_REGION_SIZE,
        pBuffer: *mut ID3D12Resource,
        BufferStartOffsetInBytes: UINT64,
        Flags: D3D12_TILE_COPY_FLAGS,
    ) -> (),
    fn ResolveSubresource(
        pDstResource: *mut ID3D12Resource,
        DstSubresource: UINT,
        pSrcResource: *mut ID3D12Resource,
        SrcSubresource: UINT,
        Format: DXGI_FORMAT,
    ) -> (),
    fn IASetPrimitiveTopology(
        PrimitiveTopology: D3D12_PRIMITIVE_TOPOLOGY,
    ) -> (),
    fn RSSetViewports(
        NumViewports: UINT,
        pViewports: *const D3D12_VIEWPORT,
    ) -> (),
    fn RSSetScissorRects(
        NumRects: UINT,
        pRects: *const D3D12_RECT,
    ) -> (),
    fn OMSetBlendFactor(
        BlendFactor: *const [FLOAT; 4],
    ) -> (),
    fn OMSetStencilRef(
        StencilRef: UINT,
    ) -> (),
    fn SetPipelineState(
        pPipelineState: *mut ID3D12PipelineState,
    ) -> (),
    fn ResourceBarrier(
        NumBarriers: UINT,
        pBarriers: *const D3D12_RESOURCE_BARRIER,
    ) -> (),
    fn ExecuteBundle(
        pCommandList: *mut ID3D12GraphicsCommandList,
    ) -> (),
    fn SetDescriptorHeaps(
        NumDescriptorHeaps: UINT,
        ppDescriptorHeaps: *mut *mut ID3D12DescriptorHeap,
    ) -> (),
    fn SetComputeRootSignature(
        pRootSignature: *mut ID3D12RootSignature,
    ) -> (),
    fn SetGraphicsRootSignature(
        pRootSignature: *mut ID3D12RootSignature,
    ) -> (),
    fn SetComputeRootDescriptorTable(
        RootParameterIndex: UINT,
        BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn SetGraphicsRootDescriptorTable(
        RootParameterIndex: UINT,
        BaseDescriptor: D3D12_GPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn SetComputeRoot32BitConstant(
        RootParameterIndex: UINT,
        SrcData: UINT,
        DestOffsetIn32BitValues: UINT,
    ) -> (),
    fn SetGraphicsRoot32BitConstant(
        RootParameterIndex: UINT,
        SrcData: UINT,
        DestOffsetIn32BitValues: UINT,
    ) -> (),
    fn SetComputeRoot32BitConstants(
        RootParameterIndex: UINT,
        Num32BitValuesToSet: UINT,
        pSrcData: *const c_void,
        DestOffsetIn32BitValues: UINT,
    ) -> (),
    fn SetGraphicsRoot32BitConstants(
        RootParameterIndex: UINT,
        Num32BitValuesToSet: UINT,
        pSrcData: *const c_void,
        DestOffsetIn32BitValues: UINT,
    ) -> (),
    fn SetComputeRootConstantBufferView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn SetGraphicsRootConstantBufferView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn SetComputeRootShaderResourceView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn SetGraphicsRootShaderResourceView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn SetComputeRootUnorderedAccessView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn SetGraphicsRootUnorderedAccessView(
        RootParameterIndex: UINT,
        BufferLocation: D3D12_GPU_VIRTUAL_ADDRESS,
    ) -> (),
    fn IASetIndexBuffer(
        pView: *const D3D12_INDEX_BUFFER_VIEW,
    ) -> (),
    fn IASetVertexBuffers(
        StartSlot: UINT,
        NumViews: UINT,
        pViews: *const D3D12_VERTEX_BUFFER_VIEW,
    ) -> (),
    fn SOSetTargets(
        StartSlot: UINT,
        NumViews: UINT,
        pViews: *const D3D12_STREAM_OUTPUT_BUFFER_VIEW,
    ) -> (),
    fn OMSetRenderTargets(
        NumRenderTargetDescriptors: UINT,
        pRenderTargetDescriptors: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        RTsSingleHandleToDescriptorRange: BOOL,
        pDepthStencilDescriptor: *const D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn ClearDepthStencilView(
        DepthStencilView: D3D12_CPU_DESCRIPTOR_HANDLE,
        ClearFlags: D3D12_CLEAR_FLAGS,
        Depth: FLOAT,
        Stencil: UINT8,
        NumRects: UINT,
        pRects: *const D3D12_RECT,
    ) -> (),
    fn ClearRenderTargetView(
        RenderTargetView: D3D12_CPU_DESCRIPTOR_HANDLE,
        ColorRGBA: *const [FLOAT; 4],
        NumRects: UINT,
        pRects: *const D3D12_RECT,
    ) -> (),
    fn ClearUnorderedAccessViewUint(
        ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
        ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
        pResource: *mut ID3D12Resource,
        Values: *const [UINT; 4],
        NumRects: UINT,
        pRects: *const D3D12_RECT,
    ) -> (),
    fn ClearUnorderedAccessViewFloat(
        ViewGPUHandleInCurrentHeap: D3D12_GPU_DESCRIPTOR_HANDLE,
        ViewCPUHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
        pResource: *mut ID3D12Resource,
        Values: *const [FLOAT; 4],
        NumRects: UINT,
        pRects: *const D3D12_RECT,
    ) -> (),
    fn DiscardResource(
        pResource: *mut ID3D12Resource,
        pRegion: *const D3D12_DISCARD_REGION,
    ) -> (),
    fn BeginQuery(
        pQueryHeap: *mut ID3D12QueryHeap,
        Type: D3D12_QUERY_TYPE,
        Index: UINT,
    ) -> (),
    fn EndQuery(
        pQueryHeap: *mut ID3D12QueryHeap,
        Type: D3D12_QUERY_TYPE,
        Index: UINT,
    ) -> (),
    fn ResolveQueryData(
        pQueryHeap: *mut ID3D12QueryHeap,
        Type: D3D12_QUERY_TYPE,
        StartIndex: UINT,
        NumQueries: UINT,
        pDestinationBuffer: *mut ID3D12Resource,
        AlignedDestinationBufferOffset: UINT64,
    ) -> (),
    fn SetPredication(
        pBuffer: *mut ID3D12Resource,
        AlignedBufferOffset: UINT64,
        Operation: D3D12_PREDICATION_OP,
    ) -> (),
    fn SetMarker(
        Metadata: UINT,
        pData: *const c_void,
        Size: UINT,
    ) -> (),
    fn BeginEvent(
        Metadata: UINT,
        pData: *const c_void,
        Size: UINT,
    ) -> (),
    fn EndEvent() -> (),
    fn ExecuteIndirect(
        pCommandSignature: *mut ID3D12CommandSignature,
        MaxCommandCount: UINT,
        pArgumentBuffer: *mut ID3D12Resource,
        ArgumentBufferOffset: UINT64,
        pCountBuffer: *mut ID3D12Resource,
        CountBufferOffset: UINT64,
    ) -> (),
}}
RIDL!{#[uuid(0x553103fb, 0x1fe7, 0x4557, 0xbb, 0x38, 0x94, 0x6d, 0x7d, 0x0e, 0x7c, 0xa7)]
interface ID3D12GraphicsCommandList1(ID3D12GraphicsCommandList1Vtbl):
    ID3D12GraphicsCommandList(ID3D12GraphicsCommandListVtbl) {
    fn AtomicCopyBufferUINT(
        pDstBuffer: *mut ID3D12Resource,
        DstOffset: UINT64,
        pSrcBuffer: *mut ID3D12Resource,
        SrcOffset: UINT64,
        Dependencies: UINT,
        ppDependentResources: *const *mut ID3D12Resource,
        pDependentSubresourceRanges: *mut D3D12_SUBRESOURCE_RANGE_UINT64,
    ) -> (),
    fn AtomicCopyBufferUINT64(
        pDstBuffer: *mut ID3D12Resource,
        DstOffset: UINT64,
        pSrcBuffer: *mut ID3D12Resource,
        SrcOffset: UINT64,
        Dependencies: UINT,
        ppDependentResources: *const *mut ID3D12Resource,
        pDependentSubresourceRanges: *mut D3D12_SUBRESOURCE_RANGE_UINT64,
    ) -> (),
    fn OMSetDepthBounds(
        Min: FLOAT,
        Max: FLOAT,
    ) -> (),
    fn SetSamplePositions(
        NumSamplesPerPixel: UINT,
        NumPixels: UINT,
        pSamplePositions: *mut D3D12_SAMPLE_POSITION,
    ) -> (),
    fn ResolveSubresourceRegion(
        pDstResource: *mut ID3D12Resource,
        DstSubresource: UINT,
        DstX: UINT,
        DstY: UINT,
        pSrcResource: *mut ID3D12Resource,
        SrcSubresource: UINT,
        pSrcRect: *mut D3D12_RECT,
        Format: DXGI_FORMAT,
        ResolveMode: D3D12_RESOLVE_MODE,
    ) -> (),
}}
RIDL!(#[uuid(0x0ec870a6, 0x5d7e, 0x4c22, 0x8c, 0xfc, 0x5b, 0xaa, 0xe0, 0x76, 0x16, 0xed)]
interface ID3D12CommandQueue(ID3D12CommandQueueVtbl): ID3D12Pageable(ID3D12PageableVtbl) {
    fn UpdateTileMappings(
        pResource: *mut ID3D12Resource,
        NumResourceRegions: UINT,
        pResourceRegionStartCoordinates: *const D3D12_TILED_RESOURCE_COORDINATE,
        pResourceRegionSizes: *const D3D12_TILE_REGION_SIZE,
        pHeap: *mut ID3D12Heap,
        NumRanges: UINT,
        pRangeFlags: *const D3D12_TILE_RANGE_FLAGS,
        pHeapRangeStartOffsets: *const UINT,
        pRangeTileCounts: *const UINT,
        Flags: D3D12_TILE_MAPPING_FLAGS,
    ) -> (),
    fn CopyTileMappings(
        pDstResource: *mut ID3D12Resource,
        pDstRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
        pSrcResource: *mut ID3D12Resource,
        pSrcRegionStartCoordinate: *const D3D12_TILED_RESOURCE_COORDINATE,
        pRegionSize: *const D3D12_TILE_REGION_SIZE,
        Flags: D3D12_TILE_MAPPING_FLAGS,
    ) -> (),
    fn ExecuteCommandLists(
        NumCommandLists: UINT,
        ppCommandLists: *const *mut ID3D12CommandList,
    ) -> (),
    fn SetMarker(
        Metadata: UINT,
        pData: *const c_void,
        Size: UINT,
    ) -> (),
    fn BeginEvent(
        Metadata: UINT,
        pData: *const c_void,
        Size: UINT,
    ) -> (),
    fn EndEvent() -> (),
    fn Signal(
        pFence: *mut ID3D12Fence,
        Value: UINT64,
    ) -> HRESULT,
    fn Wait(
        pFence: *mut ID3D12Fence,
        Value: UINT64,
    ) -> HRESULT,
    fn GetTimestampFrequency(
        pFrequency: *mut UINT64,
    ) -> HRESULT,
    fn GetClockCalibration(
        pGpuTimestamp: *mut UINT64,
        pCpuTimestamp: *mut UINT64,
    ) -> HRESULT,
    #[fixme] fn GetDesc() -> D3D12_COMMAND_QUEUE_DESC,
});
RIDL!(#[uuid(0x189819f1, 0x1db6, 0x4b57, 0xbe, 0x54, 0x18, 0x21, 0x33, 0x9b, 0x85, 0xf7)]
interface ID3D12Device(ID3D12DeviceVtbl): ID3D12Object(ID3D12ObjectVtbl) {
    fn GetNodeCount() -> UINT,
    fn CreateCommandQueue(
        pDesc: *const D3D12_COMMAND_QUEUE_DESC,
        riid: REFGUID,
        ppCommandQueue: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateCommandAllocator(
        type_: D3D12_COMMAND_LIST_TYPE,
        riid: REFGUID,
        ppCommandAllocator: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateGraphicsPipelineState(
        pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
        riid: REFGUID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateComputePipelineState(
        pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
        riid: REFGUID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateCommandList(
        nodeMask: UINT,
        type_: D3D12_COMMAND_LIST_TYPE,
        pCommandAllocator: *mut ID3D12CommandAllocator,
        pInitialState: *mut ID3D12PipelineState,
        riid: REFGUID,
        ppCommandList: *mut *mut c_void,
    ) -> HRESULT,
    fn CheckFeatureSupport(
        Feature: D3D12_FEATURE,
        pFeatureSupportData: *mut c_void,
        FeatureSupportDataSize: UINT,
    ) -> HRESULT,
    fn CreateDescriptorHeap(
        pDescriptorHeapDesc: *const D3D12_DESCRIPTOR_HEAP_DESC,
        riid: REFGUID,
        ppvHeap: *mut *mut c_void,
    ) -> HRESULT,
    fn GetDescriptorHandleIncrementSize(
        DescriptorHeapType: D3D12_DESCRIPTOR_HEAP_TYPE,
    ) -> UINT,
    fn CreateRootSignature(
        nodeMask: UINT,
        pBlobWithRootSignature: *const c_void,
        blobLengthInBytes: SIZE_T,
        riid: REFGUID,
        ppvRootSignature: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateConstantBufferView(
        pDesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CreateShaderResourceView(
        pResource: *mut ID3D12Resource,
        pDesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CreateUnorderedAccessView(
        pResource: *mut ID3D12Resource,
        pCounterResource: *mut ID3D12Resource,
        pDesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CreateRenderTargetView(
        pResource: *mut ID3D12Resource,
        pDesc: *const D3D12_RENDER_TARGET_VIEW_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CreateDepthStencilView(
        pResource: *mut ID3D12Resource,
        pDesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CreateSampler(
        pDesc: *const D3D12_SAMPLER_DESC,
        DestDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    ) -> (),
    fn CopyDescriptors(
        NumDestDescriptorRanges: UINT,
        pDestDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        pDestDescriptorRangeSizes: *const UINT,
        NumSrcDescriptorRanges: UINT,
        pSrcDescriptorRangeStarts: *const D3D12_CPU_DESCRIPTOR_HANDLE,
        pSrcDescriptorRangeSizes: *const UINT,
        DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
    ) -> (),
    fn CopyDescriptorsSimple(
        NumDescriptors: UINT,
        DestDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
        SrcDescriptorRangeStart: D3D12_CPU_DESCRIPTOR_HANDLE,
        DescriptorHeapsType: D3D12_DESCRIPTOR_HEAP_TYPE,
    ) -> (),
    #[fixme] fn GetResourceAllocationInfo(
        visibleMask: UINT,
        numResourceDescs: UINT,
        pResourceDescs: *const D3D12_RESOURCE_DESC,
    ) -> D3D12_RESOURCE_ALLOCATION_INFO,
    #[fixme] fn GetCustomHeapProperties(
        nodeMask: UINT,
        heapType: D3D12_HEAP_TYPE,
    ) -> D3D12_HEAP_PROPERTIES,
    fn CreateCommittedResource(
        pHeapProperties: *const D3D12_HEAP_PROPERTIES,
        HeapFlags: D3D12_HEAP_FLAGS,
        pResourceDesc: *const D3D12_RESOURCE_DESC,
        InitialResourceState: D3D12_RESOURCE_STATES,
        pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
        riidResource: REFGUID,
        ppvResource: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateHeap(
        pDesc: *const D3D12_HEAP_DESC,
        riid: REFGUID,
        ppvHeap: *mut *mut c_void,
    ) -> HRESULT,
    fn CreatePlacedResource(
        pHeap: *mut ID3D12Heap,
        HeapOffset: UINT64,
        pDesc: *const D3D12_RESOURCE_DESC,
        InitialState: D3D12_RESOURCE_STATES,
        pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
        riid: REFGUID,
        ppvResource: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateReservedResource(
        pDesc: *const D3D12_RESOURCE_DESC,
        InitialState: D3D12_RESOURCE_STATES,
        pOptimizedClearValue: *const D3D12_CLEAR_VALUE,
        riid: REFGUID,
        ppvResource: *mut *mut c_void,
    ) -> HRESULT,
    fn CreateSharedHandle(
        pObject: *mut ID3D12DeviceChild,
        pAttributes: *const SECURITY_ATTRIBUTES,
        Access: DWORD,
        Name: LPCWSTR,
        pHandle: *mut HANDLE,
    ) -> HRESULT,
    fn OpenSharedHandle(
        NTHandle: HANDLE,
        riid: REFGUID,
        ppvObj: *mut *mut c_void,
    ) -> HRESULT,
    fn OpenSharedHandleByName(
        Name: LPCWSTR,
        Access: DWORD,
        pNTHandle: *mut HANDLE,
    ) -> HRESULT,
    fn MakeResident(
        NumObjects: UINT,
        ppObjects: *mut *mut ID3D12Pageable,
    ) -> HRESULT,
    fn Evict(
        NumObjects: UINT,
        ppObjects: *mut *mut ID3D12Pageable,
    ) -> HRESULT,
    fn CreateFence(
        InitialValue: UINT64,
        Flags: D3D12_FENCE_FLAGS,
        riid: REFGUID,
        ppFence: *mut *mut c_void,
    ) -> HRESULT,
    fn GetDeviceRemovedReason() -> HRESULT,
    fn GetCopyableFootprints(
        pResourceDesc: *const D3D12_RESOURCE_DESC,
        FirstSubresource: UINT,
        NumSubresources: UINT,
        BaseOffset: UINT64,
        pLayouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
        pNumRows: *mut UINT,
        pRowSizeInBytes: *mut UINT64,
        pTotalBytes: *mut UINT64,
    ) -> (),
    fn CreateQueryHeap(
        pDesc: *const D3D12_QUERY_HEAP_DESC,
        riid: REFGUID,
        ppvHeap: *mut *mut c_void,
    ) -> HRESULT,
    fn SetStablePowerState(
        Enable: BOOL,
    ) -> HRESULT,
    fn CreateCommandSignature(
        pDesc: *const D3D12_COMMAND_SIGNATURE_DESC,
        pRootSignature: *mut ID3D12RootSignature,
        riid: REFGUID,
        ppvCommandSignature: *mut *mut c_void,
    ) -> HRESULT,
    fn GetResourceTiling(
        pTiledResource: *mut ID3D12Resource,
        pNumTilesForEntireResource: *mut UINT,
        pPackedMipDesc: *mut D3D12_PACKED_MIP_INFO,
        pStandardTileShapeForNonPackedMips: *mut D3D12_TILE_SHAPE,
        pNumSubresourceTilings: *mut UINT,
        FirstSubresourceTilingToGet: UINT,
        pSubresourceTilingsForNonPackedMips: *mut D3D12_SUBRESOURCE_TILING,
    ) -> (),
    #[fixme] fn GetAdapterLuid() -> LUID,
});
RIDL!(#[uuid(0xc64226a8, 0x9201, 0x46af, 0xb4, 0xcc, 0x53, 0xfb, 0x9f, 0xf7, 0x41, 0x4f)]
interface ID3D12PipelineLibrary(ID3D12PipelineLibraryVtbl): ID3D12DeviceChild(ID3D12DeviceChildVtbl) {
    fn StorePipeline(
        pName: LPCWSTR,
        pPipeline: *mut ID3D12PipelineState,
    ) -> HRESULT,
    fn LoadGraphicsPipeline(
        pName: LPCWSTR,
        pDesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC,
        riid: REFIID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
    fn LoadComputePipeline(
        pName: LPCWSTR,
        pDesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC,
        riid: REFIID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
    fn GetSerializedSize() -> SIZE_T,
    fn Serialize(
        pData: *mut c_void,
        DataSizeInBytes: SIZE_T,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x80eabf42, 0x2568, 0x4e5e, 0xbd, 0x82, 0xc3, 0x7f, 0x86, 0x96, 0x1d, 0xc3)]
interface ID3D12PipelineLibrary1(ID3D12PipelineLibrary1Vtbl): ID3D12PipelineLibrary(ID3D12PipelineLibraryVtbl) {
    fn LoadPipeline(
        pName: LPCWSTR,
        pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
        riid: REFIID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
});
ENUM!{enum D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    D3D12_MULTIPLE_FENCE_WAIT_FLAG_NONE = 0,
    D3D12_MULTIPLE_FENCE_WAIT_FLAG_ANY = 0x1,
    D3D12_MULTIPLE_FENCE_WAIT_FLAG_ALL = 0,
}}
ENUM!{enum D3D12_RESIDENCY_PRIORITY {
    D3D12_RESIDENCY_PRIORITY_MINIMUM = 0x28000000,
    D3D12_RESIDENCY_PRIORITY_LOW = 0x50000000,
    D3D12_RESIDENCY_PRIORITY_NORMAL = 0x78000000,
    D3D12_RESIDENCY_PRIORITY_HIGH = 0xa0010000,
    D3D12_RESIDENCY_PRIORITY_MAXIMUM = 0xc8000000,
}}
RIDL!(#[uuid(0x77acce80, 0x638e, 0x4e65, 0x88, 0x95, 0xc1, 0xf2, 0x33, 0x86, 0x86, 0x3e)]
interface ID3D12Device1(ID3D12Device1Vtbl): ID3D12Device(ID3D12DeviceVtbl) {
    fn CreatePipelineLibrary(
        pLibraryBlob: *const c_void,
        BlobLength: SIZE_T,
        riid: REFIID,
        ppPipelineLibrary: *mut *mut c_void,
    ) -> HRESULT,
    fn SetEventOnMultipleFenceCompletion(
        ppFences: *const *mut ID3D12Fence,
        pFenceValues: *const UINT64,
        NumFences: UINT,
        Flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS,
        hEvent: HANDLE,
    ) -> HRESULT,
    fn SetResidencyPriority(
        NumObjects: UINT,
        ppObjects: *const *mut ID3D12Pageable,
        pPriorities: *const D3D12_RESIDENCY_PRIORITY,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x30baa41e, 0xb15b, 0x475c, 0xa0, 0xbb, 0x1a, 0xf5, 0xc5, 0xb6, 0x43, 0x28)]
interface ID3D12Device2(ID3D12Device2Vtbl): ID3D12Device1(ID3D12Device1Vtbl) {
    fn CreatePipelineState(
        pDesc: *const D3D12_PIPELINE_STATE_STREAM_DESC,
        riid: REFIID,
        ppPipelineState: *mut *mut c_void,
    ) -> HRESULT,
});
RIDL!(#[uuid(0x7071e1f0, 0xe84b, 0x4b33, 0x97, 0x4f, 0x12, 0xfa, 0x49, 0xde, 0x65, 0xc5)]
interface ID3D12Tools(ID3D12ToolsVtbl): IUnknown(IUnknownVtbl) {
    fn EnableShaderInstrumentation(
        bEnable: BOOL,
    ) -> (),
    fn ShaderInstrumentationEnabled() -> BOOL,
});
STRUCT!{struct D3D12_SUBRESOURCE_DATA {
    pData: *const c_void,
    RowPitch: LONG_PTR,
    SlicePitch: LONG_PTR,
}}
STRUCT!{struct D3D12_MEMCPY_DEST {
    pData: *mut c_void,
    RowPitch: SIZE_T,
    SlicePitch: SIZE_T,
}}
FN!{stdcall PFN_D3D12_CREATE_DEVICE(
    *mut IUnknown,
    D3D_FEATURE_LEVEL,
    REFIID,
    *mut *mut c_void,
) -> HRESULT}
extern "system" {
    pub fn D3D12CreateDevice(
        pAdapter: *mut IUnknown,
        MinimumFeatureLevel: D3D_FEATURE_LEVEL,
        riid: REFGUID,
        ppDevice: *mut *mut c_void,
    ) -> HRESULT;
}
FN!{stdcall PFN_D3D12_GET_DEBUG_INTERFACE(
    REFIID,
    *mut *mut c_void,
) -> HRESULT}
extern "system" {
    pub fn D3D12GetDebugInterface(
        riid: REFGUID,
        ppvDebug: *mut *mut c_void
    ) -> HRESULT;
    pub fn D3D12EnableExperimentalFeatures(
        NumFeatures: UINT,
        pIIDs: *const IID,
        pConfigurationStructs: *mut c_void,
        pConfigurationStructSizes: *mut UINT,
    ) -> HRESULT;
}
DEFINE_GUID!{IID_ID3D12Object,
    0xc4fec28f, 0x7966, 0x4e95, 0x9f, 0x94, 0xf4, 0x31, 0xcb, 0x56, 0xc3, 0xb8}
DEFINE_GUID!{IID_ID3D12DeviceChild,
    0x905db94b, 0xa00c, 0x4140, 0x9d, 0xf5, 0x2b, 0x64, 0xca, 0x9e, 0xa3, 0x57}
DEFINE_GUID!{IID_ID3D12RootSignature,
    0xc54a6b66, 0x72df, 0x4ee8, 0x8b, 0xe5, 0xa9, 0x46, 0xa1, 0x42, 0x92, 0x14}
DEFINE_GUID!{IID_ID3D12RootSignatureDeserializer,
    0x34AB647B, 0x3CC8, 0x46AC, 0x84, 0x1B, 0xC0, 0x96, 0x56, 0x45, 0xC0, 0x46}
DEFINE_GUID!{IID_ID3D12VersionedRootSignatureDeserializer,
    0x7F91CE67, 0x090C, 0x4BB7, 0xB7, 0x8E, 0xED, 0x8F, 0xF2, 0xE3, 0x1D, 0xA0}
DEFINE_GUID!{IID_ID3D12Pageable,
    0x63ee58fb, 0x1268, 0x4835, 0x86, 0xda, 0xf0, 0x08, 0xce, 0x62, 0xf0, 0xd6}
DEFINE_GUID!{IID_ID3D12Heap,
    0x6b3b2502, 0x6e51, 0x45b3, 0x90, 0xee, 0x98, 0x84, 0x26, 0x5e, 0x8d, 0xf3}
DEFINE_GUID!{IID_ID3D12Resource,
    0x696442be, 0xa72e, 0x4059, 0xbc, 0x79, 0x5b, 0x5c, 0x98, 0x04, 0x0f, 0xad}
DEFINE_GUID!{IID_ID3D12CommandAllocator,
    0x6102dee4, 0xaf59, 0x4b09, 0xb9, 0x99, 0xb4, 0x4d, 0x73, 0xf0, 0x9b, 0x24}
DEFINE_GUID!{IID_ID3D12Fence,
    0x0a753dcf, 0xc4d8, 0x4b91, 0xad, 0xf6, 0xbe, 0x5a, 0x60, 0xd9, 0x5a, 0x76}
DEFINE_GUID!{IID_ID3D12PipelineState,
    0x765a30f3, 0xf624, 0x4c6f, 0xa8, 0x28, 0xac, 0xe9, 0x48, 0x62, 0x24, 0x45}
DEFINE_GUID!{IID_ID3D12DescriptorHeap,
    0x8efb471d, 0x616c, 0x4f49, 0x90, 0xf7, 0x12, 0x7b, 0xb7, 0x63, 0xfa, 0x51}
DEFINE_GUID!{IID_ID3D12QueryHeap,
    0x0d9658ae, 0xed45, 0x469e, 0xa6, 0x1d, 0x97, 0x0e, 0xc5, 0x83, 0xca, 0xb4}
DEFINE_GUID!{IID_ID3D12CommandSignature,
    0xc36a797c, 0xec80, 0x4f0a, 0x89, 0x85, 0xa7, 0xb2, 0x47, 0x50, 0x82, 0xd1}
DEFINE_GUID!{IID_ID3D12CommandList,
    0x7116d91c, 0xe7e4, 0x47ce, 0xb8, 0xc6, 0xec, 0x81, 0x68, 0xf4, 0x37, 0xe5}
DEFINE_GUID!{IID_ID3D12GraphicsCommandList,
    0x5b160d0f, 0xac1b, 0x4185, 0x8b, 0xa8, 0xb3, 0xae, 0x42, 0xa5, 0xa4, 0x55}
DEFINE_GUID!{IID_ID3D12GraphicsCommandList1,
    0x553103fb, 0x1fe7, 0x4557, 0xbb, 0x38, 0x94, 0x6d, 0x7d, 0x0e, 0x7c, 0xa7}
DEFINE_GUID!{IID_ID3D12CommandQueue,
    0x0ec870a6, 0x5d7e, 0x4c22, 0x8c, 0xfc, 0x5b, 0xaa, 0xe0, 0x76, 0x16, 0xed}
DEFINE_GUID!{IID_ID3D12Device,
    0x189819f1, 0x1db6, 0x4b57, 0xbe, 0x54, 0x18, 0x21, 0x33, 0x9b, 0x85, 0xf7}
DEFINE_GUID!{IID_ID3D12PipelineLibrary,
    0xc64226a8, 0x9201, 0x46af, 0xb4, 0xcc, 0x53, 0xfb, 0x9f, 0xf7, 0x41, 0x4f}
DEFINE_GUID!{IID_ID3D12PipelineLibrary1,
    0x80eabf42, 0x2568, 0x4e5e, 0xbd, 0x82, 0xc3, 0x7f, 0x86, 0x96, 0x1d, 0xc3}
DEFINE_GUID!{IID_ID3D12Device1,
    0x77acce80, 0x638e, 0x4e65, 0x88, 0x95, 0xc1, 0xf2, 0x33, 0x86, 0x86, 0x3e}
DEFINE_GUID!{IID_ID3D12Device2,
    0x30baa41e, 0xb15b, 0x475c, 0xa0, 0xbb, 0x1a, 0xf5, 0xc5, 0xb6, 0x43, 0x28}
DEFINE_GUID!{IID_ID3D12Tools,
    0x7071e1f0, 0xe84b, 0x4b33, 0x97, 0x4f, 0x12, 0xfa, 0x49, 0xde, 0x65, 0xc5}
