# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

"""Version Control for Human Beings.

Bazaar Explorer is a desktop application providing an easy-to-use
interface to the Bazaar version control system. It is designed to
be simple enough for casual users of version control, yet powerful
enough for experts to use as their primary interface to Bazaar.

Please visit the home page, http://doc.bazaar.canonical.com/explorer/en/,
for more information.
"""

version_info = (1, 3, 0, 'final', 0)
__version__ = '.'.join(map(str, version_info))


from bzrlib import ignores
from bzrlib.commands import plugin_cmds


ignores.add_runtime_ignores(['./.bzrbranches'])


lazy_commands = (
    # name, aliases, module
    ('cmd_explorer',               ['explore'], 'bzrlib.plugins.explorer.lib.commands'),
    ('cmd_init_workspace',         ['new'],     'bzrlib.plugins.explorer.lib.commands'),
    ('cmd_qinit_workspace',        ['qnew'],    'bzrlib.plugins.explorer.lib.commands'),
    ('cmd_qcheckout_ala_explorer', [],          'bzrlib.plugins.explorer.lib.commands'),
)

for name, aliases, module in lazy_commands:
    plugin_cmds.register_lazy(name, aliases, module)


def load_tests(basic_tests, module, loader):
    from bzrlib.plugins.explorer.tests import load_tests
    return load_tests(basic_tests, module, loader)
