//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/SpecularInstrumentEditor.cpp
//! @brief     Implements class SpecularInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Instrument/SpecularInstrumentEditor.h"
#include "GUI/Model/Device/InstrumentItems.h"
#include "GUI/View/Device/BackgroundForm.h"
#include "GUI/View/Instrument/PolarizationAnalysisEditor.h"
#include "GUI/View/Instrument/ScanEditor.h"

SpecularInstrumentEditor::SpecularInstrumentEditor(QWidget* parent,
                                                   SpecularInstrumentItem* instrument,
                                                   MultiInstrumentNotifier* ec)
    : QWidget(parent)
    , m_ec(ec, instrument)
{
    ASSERT(instrument);
    auto* layout = new QVBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);

    auto* scanEditor = new ScanEditor(this, instrument->scanItem(), &m_ec);
    layout->addWidget(scanEditor);

    auto* polMatricesAnalysisEditor = new PolarizationAnalysisEditor(this, instrument);
    layout->addWidget(polMatricesAnalysisEditor);

    auto* backgroundForm = new BackgroundForm(this, instrument);
    layout->addWidget(backgroundForm);

    layout->addStretch();

    connect(scanEditor, &ScanEditor::dataChanged, this, &SpecularInstrumentEditor::dataChanged);
    connect(polMatricesAnalysisEditor, &PolarizationAnalysisEditor::dataChanged, this,
            &SpecularInstrumentEditor::dataChanged);
    connect(backgroundForm, &BackgroundForm::dataChanged, this,
            &SpecularInstrumentEditor::dataChanged);
}
