//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/CoordName.h
//! @brief     Defines namespace GUI::Util::CoordName
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_UTIL_COORDNAME_H
#define BORNAGAIN_GUI_SUPPORT_UTIL_COORDNAME_H

#include "Device/Coord/Tags.h"
#include <QString>

//! Conversions between enum and QString.

namespace GUI::Util::CoordName {

//! Returns axes units names from their domain counterpart
QString nameFromCoord(Coords units);

//! Returns domain axes units type from their GUI name
Coords coordFromName(const QString& name);

} // namespace GUI::Util::CoordName

#endif // BORNAGAIN_GUI_SUPPORT_UTIL_COORDNAME_H
