/////////////////////////////////////////////////////////////////////////
// $Id: guest2host.cc,v 1.21 2009/12/04 19:50:27 sshwarts Exp $
/////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2001-2009  The Bochs Project
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
/////////////////////////////////////////////////////////////////////////

#include "iodev.h"
#include "guest2host.h"

#define LOG_THIS  bx_g2h.

bx_g2h_c bx_g2h;

bx_g2h_c::bx_g2h_c()
{
  put("G2H");
  unsigned i;

  for (i=0; i<BX_MAX_G2H_CHANNELS; i++) {
    s.callback[i].f = NULL;
    s.callback[i].used = 0;
  }
}

bx_g2h_c::~bx_g2h_c()
{
  // nothing for now
}

void bx_g2h_c::init(void)
{
  BX_DEBUG(("Init $Id: guest2host.cc,v 1.21 2009/12/04 19:50:27 sshwarts Exp $"));
  // Reserve a dword port for this interface
  for (Bit32u addr=BX_G2H_PORT; addr<=(BX_G2H_PORT+3); addr++) {
    bx_devices.register_io_read_handler(&bx_g2h,
      inp_handler, addr, "g2h");
    bx_devices.register_io_write_handler(&bx_g2h,
      outp_handler, addr, "g2h");
  }
  memset(&bx_g2h.s, 0, sizeof(bx_g2h.s));
}

void bx_g2h_c::reset(unsigned type)
{
}

unsigned bx_g2h_c::acquire_channel(bx_g2h_callback_t f)
{
  unsigned i;

  for (i=0; i<BX_MAX_G2H_CHANNELS; i++) {
    if (bx_g2h.s.callback[i].used==0) {
      bx_g2h.s.callback[i].f = f;
      bx_g2h.s.callback[i].used = 1;
      return(i);
    }
  }

  BX_INFO(("g2h: attempt to acquire channel: maxed out"));
  return BX_G2H_ERROR; // No more free channels
}

unsigned bx_g2h_c::deacquire_channel(unsigned channel)
{
  if ((channel >= BX_MAX_G2H_CHANNELS) ||
      (bx_g2h.s.callback[channel].used==0))
  {
    BX_PANIC(("g2h: attempt to deacquire channel %u: not acquired", channel));
  }
  bx_g2h.s.callback[channel].used = 0;
  bx_g2h.s.callback[channel].f = NULL;
  return 0;
}


// static IO port read callback handler
// redirects to non-static class handler to avoid virtual functions

Bit32u bx_g2h_c::inp_handler(void *this_ptr, Bit32u addr, unsigned io_len)
{
  UNUSED(this_ptr);

  if (addr != BX_G2H_PORT)
    BX_PANIC(("g2h: IO read not aligned on dword boundary."));
  if (io_len != 4)
    BX_PANIC(("g2h: IO read not dword."));

  BX_PANIC(("g2h: IO read not complete."));
  return(0);
}

void bx_g2h_c::outp_handler(void *this_ptr, Bit32u addr, Bit32u val32, unsigned io_len)
{
  UNUSED(this_ptr);

  if (addr != BX_G2H_PORT)
    BX_PANIC(("g2h: IO write not aligned on dword boundary."));
  if (io_len != 4)
    BX_PANIC(("g2h: IO write not dword."));

  if ((bx_g2h.s.packet_count==0) && (val32!=BX_G2H_MAGIC)) {
    BX_INFO(("g2h: IO W: Not magic header."));
    return;
  }
  bx_g2h.s.guest_packet[bx_g2h.s.packet_count++] = val32;
  if (bx_g2h.s.packet_count >= BX_G2H_PACKET_SIZE) {
    unsigned channel;

    // Full packet received from guest.  Pass on to the host code.
    channel = bx_g2h.s.guest_packet[1];
    if (channel >= BX_MAX_G2H_CHANNELS) {
      BX_PANIC(("g2h: channel (%u) out of bounds", channel));
    }
    if (bx_g2h.s.callback[channel].used==0) {
      BX_PANIC(("g2h: channel (%u) not active", channel));
    }
    bx_g2h.s.callback[channel].f(&bx_g2h.s.guest_packet);
    bx_g2h.s.packet_count = 0; // Ready for next packet
  }
}
