/////////////////////////////////////////////////////////////////////////,,,,
// $Id: ia_opcodes.h,v 1.73 2011/02/11 09:56:23 sshwarts Exp $,,,
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2008-2010 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA B 02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

// bx_define_opcode is a macro with 5 fields:
//   - Opcode name
//   - Opcode execution function (/m form)
//   - Opcode execution function (/r form)
//   - x86 ISA externsions that enable this instruction
//   - special attributes (PREPARE_SSE, PREPARE_AVX and etc)

// in case of complex /m form instruction (load+op) /m form execution function
// directly calls the /r form.

bx_define_opcode(BX_IA_ERROR, &BX_CPU_C::BxError, &BX_CPU_C::BxError, 0, 0)

bx_define_opcode(BX_IA_AAA, NULL, &BX_CPU_C::AAA, 0, 0)
bx_define_opcode(BX_IA_AAD, NULL, &BX_CPU_C::AAD, 0, 0)
bx_define_opcode(BX_IA_AAM, NULL, &BX_CPU_C::AAM, 0, 0)
bx_define_opcode(BX_IA_AAS, NULL, &BX_CPU_C::AAS, 0, 0)
bx_define_opcode(BX_IA_DAA, NULL, &BX_CPU_C::DAA, 0, 0)
bx_define_opcode(BX_IA_DAS, NULL, &BX_CPU_C::DAS, 0, 0)
bx_define_opcode(BX_IA_ADC_EbGb, &BX_CPU_C::ADC_EbGbM, &BX_CPU_C::ADC_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADC_EdGd, &BX_CPU_C::ADC_EdGdM, &BX_CPU_C::ADC_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADC_EwGw, &BX_CPU_C::ADC_EwGwM, &BX_CPU_C::ADC_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADD_EbGb, &BX_CPU_C::ADD_EbGbM, &BX_CPU_C::ADD_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADD_EdGd, &BX_CPU_C::ADD_EdGdM, &BX_CPU_C::ADD_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADD_EwGw, &BX_CPU_C::ADD_EwGwM, &BX_CPU_C::ADD_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_AND_EbGb, &BX_CPU_C::AND_EbGbM, &BX_CPU_C::AND_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_AND_EdGd, &BX_CPU_C::AND_EdGdM, &BX_CPU_C::AND_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_AND_EwGw, &BX_CPU_C::AND_EwGwM, &BX_CPU_C::AND_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_CMP_EbGb, &BX_CPU_C::CMP_EbGbM, &BX_CPU_C::CMP_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_CMP_EdGd, &BX_CPU_C::CMP_EdGdM, &BX_CPU_C::CMP_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_CMP_EwGw, &BX_CPU_C::CMP_EwGwM, &BX_CPU_C::CMP_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_OR_EbGb, &BX_CPU_C::OR_EbGbM, &BX_CPU_C::OR_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_OR_EdGd, &BX_CPU_C::OR_EdGdM, &BX_CPU_C::OR_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_OR_EwGw, &BX_CPU_C::OR_EwGwM, &BX_CPU_C::OR_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SBB_EbGb, &BX_CPU_C::SBB_EbGbM, &BX_CPU_C::SBB_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SBB_EdGd, &BX_CPU_C::SBB_EdGdM, &BX_CPU_C::SBB_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SBB_EwGw, &BX_CPU_C::SBB_EwGwM, &BX_CPU_C::SBB_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SUB_EbGb, &BX_CPU_C::SUB_EbGbM, &BX_CPU_C::SUB_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SUB_EdGd, &BX_CPU_C::SUB_EdGdM, &BX_CPU_C::SUB_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_SUB_EwGw, &BX_CPU_C::SUB_EwGwM, &BX_CPU_C::SUB_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_XOR_EbGb, &BX_CPU_C::XOR_EbGbM, &BX_CPU_C::XOR_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_XOR_EdGd, &BX_CPU_C::XOR_EdGdM, &BX_CPU_C::XOR_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_XOR_EwGw, &BX_CPU_C::XOR_EwGwM, &BX_CPU_C::XOR_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_ADC_ALIb, NULL, &BX_CPU_C::ADC_ALIb, 0, 0)
bx_define_opcode(BX_IA_ADC_AXIw, NULL, &BX_CPU_C::ADC_AXIw, 0, 0)
bx_define_opcode(BX_IA_ADC_EAXId, NULL, &BX_CPU_C::ADC_EAXId, 0, 0)
bx_define_opcode(BX_IA_ADD_EbIb, &BX_CPU_C::ADD_EbIbM, &BX_CPU_C::ADD_EbIbR, 0, 0)
bx_define_opcode(BX_IA_OR_EbIb, &BX_CPU_C::OR_EbIbM, &BX_CPU_C::OR_EbIbR, 0, 0)
bx_define_opcode(BX_IA_ADC_EbIb, &BX_CPU_C::ADC_EbIbM, &BX_CPU_C::ADC_EbIbR, 0, 0)
bx_define_opcode(BX_IA_SBB_EbIb, &BX_CPU_C::SBB_EbIbM, &BX_CPU_C::SBB_EbIbR, 0, 0)
bx_define_opcode(BX_IA_AND_EbIb, &BX_CPU_C::AND_EbIbM, &BX_CPU_C::AND_EbIbR, 0, 0)
bx_define_opcode(BX_IA_SUB_EbIb, &BX_CPU_C::SUB_EbIbM, &BX_CPU_C::SUB_EbIbR, 0, 0)
bx_define_opcode(BX_IA_XOR_EbIb, &BX_CPU_C::XOR_EbIbM, &BX_CPU_C::XOR_EbIbR, 0, 0)
bx_define_opcode(BX_IA_CMP_EbIb, &BX_CPU_C::CMP_EbIbM, &BX_CPU_C::CMP_EbIbR, 0, 0)
bx_define_opcode(BX_IA_ADD_EwIw, &BX_CPU_C::ADD_EwIwM, &BX_CPU_C::ADD_EwIwR, 0, 0)
bx_define_opcode(BX_IA_OR_EwIw, &BX_CPU_C::OR_EwIwM, &BX_CPU_C::OR_EwIwR, 0, 0)
bx_define_opcode(BX_IA_ADC_EwIw, &BX_CPU_C::ADC_EwIwM, &BX_CPU_C::ADC_EwIwR, 0, 0)
bx_define_opcode(BX_IA_SBB_EwIw, &BX_CPU_C::SBB_EwIwM, &BX_CPU_C::SBB_EwIwR, 0, 0)
bx_define_opcode(BX_IA_AND_EwIw, &BX_CPU_C::AND_EwIwM, &BX_CPU_C::AND_EwIwR, 0, 0)
bx_define_opcode(BX_IA_SUB_EwIw, &BX_CPU_C::SUB_EwIwM, &BX_CPU_C::SUB_EwIwR, 0, 0)
bx_define_opcode(BX_IA_XOR_EwIw, &BX_CPU_C::XOR_EwIwM, &BX_CPU_C::XOR_EwIwR, 0, 0)
bx_define_opcode(BX_IA_CMP_EwIw, &BX_CPU_C::CMP_EwIwM, &BX_CPU_C::CMP_EwIwR, 0, 0)
bx_define_opcode(BX_IA_ADD_EdId, &BX_CPU_C::ADD_EdIdM, &BX_CPU_C::ADD_EdIdR, 0, 0)
bx_define_opcode(BX_IA_OR_EdId, &BX_CPU_C::OR_EdIdM, &BX_CPU_C::OR_EdIdR, 0, 0)
bx_define_opcode(BX_IA_ADC_EdId, &BX_CPU_C::ADC_EdIdM, &BX_CPU_C::ADC_EdIdR, 0, 0)
bx_define_opcode(BX_IA_SBB_EdId, &BX_CPU_C::SBB_EdIdM, &BX_CPU_C::SBB_EdIdR, 0, 0)
bx_define_opcode(BX_IA_AND_EdId, &BX_CPU_C::AND_EdIdM, &BX_CPU_C::AND_EdIdR, 0, 0)
bx_define_opcode(BX_IA_SUB_EdId, &BX_CPU_C::SUB_EdIdM, &BX_CPU_C::SUB_EdIdR, 0, 0)
bx_define_opcode(BX_IA_XOR_EdId, &BX_CPU_C::XOR_EdIdM, &BX_CPU_C::XOR_EdIdR, 0, 0)
bx_define_opcode(BX_IA_CMP_EdId, &BX_CPU_C::CMP_EdIdM, &BX_CPU_C::CMP_EdIdR, 0, 0)
bx_define_opcode(BX_IA_ADC_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADC_GbEbR, 0, 0)
bx_define_opcode(BX_IA_ADC_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADC_GwEwR, 0, 0)
bx_define_opcode(BX_IA_ADC_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADC_GdEdR, 0, 0)
bx_define_opcode(BX_IA_ADD_ALIb, NULL, &BX_CPU_C::ADD_ALIb, 0, 0)
bx_define_opcode(BX_IA_ADD_AXIw, NULL, &BX_CPU_C::ADD_AXIw, 0, 0)
bx_define_opcode(BX_IA_ADD_EAXId, NULL, &BX_CPU_C::ADD_EAXId, 0, 0)
bx_define_opcode(BX_IA_ADD_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADD_GbEbR, 0, 0)
bx_define_opcode(BX_IA_ADD_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADD_GwEwR, 0, 0)
bx_define_opcode(BX_IA_ADD_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADD_GdEdR, 0, 0)
bx_define_opcode(BX_IA_AND_ALIb, NULL, &BX_CPU_C::AND_ALIb, 0, 0)
bx_define_opcode(BX_IA_AND_AXIw, NULL, &BX_CPU_C::AND_AXIw, 0, 0)
bx_define_opcode(BX_IA_AND_EAXId, NULL, &BX_CPU_C::AND_EAXId, 0, 0)
bx_define_opcode(BX_IA_AND_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::AND_GbEbR, 0, 0)
bx_define_opcode(BX_IA_AND_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::AND_GwEwR, 0, 0)
bx_define_opcode(BX_IA_AND_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::AND_GdEdR, 0, 0)
bx_define_opcode(BX_IA_ARPL_EwGw, &BX_CPU_C::ARPL_EwGw, &BX_CPU_C::ARPL_EwGw, 0, 0)
bx_define_opcode(BX_IA_BOUND_GdMa, &BX_CPU_C::BOUND_GdMa, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_BOUND_GwMa, &BX_CPU_C::BOUND_GwMa, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_BSF_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSF_GdEdR, 0, 0)
bx_define_opcode(BX_IA_BSF_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSF_GwEwR, 0, 0)
bx_define_opcode(BX_IA_BSR_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSR_GdEdR, 0, 0)
bx_define_opcode(BX_IA_BSR_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSR_GwEwR, 0, 0)
bx_define_opcode(BX_IA_BT_EwIb, &BX_CPU_C::BT_EwIbM, &BX_CPU_C::BT_EwIbR, 0, 0)
bx_define_opcode(BX_IA_BTS_EwIb, &BX_CPU_C::BTS_EwIbM, &BX_CPU_C::BTS_EwIbR, 0, 0)
bx_define_opcode(BX_IA_BTR_EwIb, &BX_CPU_C::BTR_EwIbM, &BX_CPU_C::BTR_EwIbR, 0, 0)
bx_define_opcode(BX_IA_BTC_EwIb, &BX_CPU_C::BTC_EwIbM, &BX_CPU_C::BTC_EwIbR, 0, 0)
bx_define_opcode(BX_IA_BT_EdIb, &BX_CPU_C::BT_EdIbM, &BX_CPU_C::BT_EdIbR, 0, 0)
bx_define_opcode(BX_IA_BTS_EdIb, &BX_CPU_C::BTS_EdIbM, &BX_CPU_C::BTS_EdIbR, 0, 0)
bx_define_opcode(BX_IA_BTR_EdIb, &BX_CPU_C::BTR_EdIbM, &BX_CPU_C::BTR_EdIbR, 0, 0)
bx_define_opcode(BX_IA_BTC_EdIb, &BX_CPU_C::BTC_EdIbM, &BX_CPU_C::BTC_EdIbR, 0, 0)
bx_define_opcode(BX_IA_BT_EdGd, &BX_CPU_C::BT_EdGdM, &BX_CPU_C::BT_EdGdR, 0, 0)
bx_define_opcode(BX_IA_BT_EwGw, &BX_CPU_C::BT_EwGwM, &BX_CPU_C::BT_EwGwR, 0, 0)
bx_define_opcode(BX_IA_BTC_EdGd, &BX_CPU_C::BTC_EdGdM, &BX_CPU_C::BTC_EdGdR, 0, 0)
bx_define_opcode(BX_IA_BTC_EwGw, &BX_CPU_C::BTC_EwGwM, &BX_CPU_C::BTC_EwGwR, 0, 0)
bx_define_opcode(BX_IA_BTR_EdGd, &BX_CPU_C::BTR_EdGdM, &BX_CPU_C::BTR_EdGdR, 0, 0)
bx_define_opcode(BX_IA_BTR_EwGw, &BX_CPU_C::BTR_EwGwM, &BX_CPU_C::BTR_EwGwR, 0, 0)
bx_define_opcode(BX_IA_BTS_EdGd, &BX_CPU_C::BTS_EdGdM, &BX_CPU_C::BTS_EdGdR, 0, 0)
bx_define_opcode(BX_IA_BTS_EwGw, &BX_CPU_C::BTS_EwGwM, &BX_CPU_C::BTS_EwGwR, 0, 0)
bx_define_opcode(BX_IA_CALL_Ed, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CALL_EdR, 0, 0)
bx_define_opcode(BX_IA_CALL_Ew, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CALL_EwR, 0, 0)
bx_define_opcode(BX_IA_CALL_Jd, NULL, &BX_CPU_C::CALL_Jd, 0, 0)
bx_define_opcode(BX_IA_CALL_Jw, NULL, &BX_CPU_C::CALL_Jw, 0, 0)
bx_define_opcode(BX_IA_CALL16_Ap, NULL, &BX_CPU_C::CALL16_Ap, 0, 0)
bx_define_opcode(BX_IA_CALL32_Ap, NULL, &BX_CPU_C::CALL32_Ap, 0, 0)
bx_define_opcode(BX_IA_CALL16_Ep, &BX_CPU_C::CALL16_Ep, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_CALL32_Ep, &BX_CPU_C::CALL32_Ep, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_CBW, NULL, &BX_CPU_C::CBW, 0, 0)
bx_define_opcode(BX_IA_CDQ, NULL, &BX_CPU_C::CDQ, 0, 0)
bx_define_opcode(BX_IA_CLC, NULL, &BX_CPU_C::CLC, 0, 0)
bx_define_opcode(BX_IA_CLD, NULL, &BX_CPU_C::CLD, 0, 0)
bx_define_opcode(BX_IA_CLFLUSH, &BX_CPU_C::CLFLUSH, &BX_CPU_C::BxError, BX_CPU_CLFLUSH, 0)
bx_define_opcode(BX_IA_CLI, NULL, &BX_CPU_C::CLI, 0, 0)
bx_define_opcode(BX_IA_CLTS, NULL, &BX_CPU_C::CLTS, 0, 0)
bx_define_opcode(BX_IA_CMC, NULL, &BX_CPU_C::CMC, 0, 0)
bx_define_opcode(BX_IA_CMP_ALIb, NULL, &BX_CPU_C::CMP_ALIb, 0, 0)
bx_define_opcode(BX_IA_CMP_AXIw, NULL, &BX_CPU_C::CMP_AXIw, 0, 0)
bx_define_opcode(BX_IA_CMP_EAXId, NULL, &BX_CPU_C::CMP_EAXId, 0, 0)
bx_define_opcode(BX_IA_CMP_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::CMP_GbEbR, 0, 0)
bx_define_opcode(BX_IA_CMP_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMP_GwEwR, 0, 0)
bx_define_opcode(BX_IA_CMP_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMP_GdEdR, 0, 0)
bx_define_opcode(BX_IA_CMPXCHG_IBTS, &BX_CPU_C::CMPXCHG_IBTS, &BX_CPU_C::CMPXCHG_IBTS, 0, 0)
bx_define_opcode(BX_IA_CMPXCHG_XBTS, &BX_CPU_C::CMPXCHG_XBTS, &BX_CPU_C::CMPXCHG_XBTS, 0, 0)
bx_define_opcode(BX_IA_CWD, NULL, &BX_CPU_C::CWD, 0, 0)
bx_define_opcode(BX_IA_CWDE, NULL, &BX_CPU_C::CWDE, 0, 0)
bx_define_opcode(BX_IA_DEC_Eb, &BX_CPU_C::DEC_EbM, &BX_CPU_C::DEC_EbR, 0, 0)
bx_define_opcode(BX_IA_DEC_Ew, &BX_CPU_C::DEC_EwM, &BX_CPU_C::DEC_RX, 0, 0)
bx_define_opcode(BX_IA_DEC_Ed, &BX_CPU_C::DEC_EdM, &BX_CPU_C::DEC_ERX, 0, 0)
bx_define_opcode(BX_IA_DEC_RX, NULL, &BX_CPU_C::DEC_RX, 0, 0)
bx_define_opcode(BX_IA_DEC_ERX, NULL, &BX_CPU_C::DEC_ERX, 0, 0)
bx_define_opcode(BX_IA_ENTER16_IwIb, NULL, &BX_CPU_C::ENTER16_IwIb, 0, 0)
bx_define_opcode(BX_IA_ENTER32_IwIb, NULL, &BX_CPU_C::ENTER32_IwIb, 0, 0)
bx_define_opcode(BX_IA_HLT, NULL, &BX_CPU_C::HLT, 0, 0)
bx_define_opcode(BX_IA_IMUL_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdR, 0, 0)
bx_define_opcode(BX_IA_IMUL_GdEdId, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdIdR, 0, 0)
bx_define_opcode(BX_IA_IMUL_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwR, 0, 0)
bx_define_opcode(BX_IA_IMUL_GwEwIw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwIwR, 0, 0)
bx_define_opcode(BX_IA_IN_ALDX, NULL, &BX_CPU_C::IN_ALDX, 0, 0)
bx_define_opcode(BX_IA_IN_ALIb, NULL, &BX_CPU_C::IN_ALIb, 0, 0)
bx_define_opcode(BX_IA_IN_AXDX, NULL, &BX_CPU_C::IN_AXDX, 0, 0)
bx_define_opcode(BX_IA_IN_AXIb, NULL, &BX_CPU_C::IN_AXIb, 0, 0)
bx_define_opcode(BX_IA_IN_EAXDX, NULL, &BX_CPU_C::IN_EAXDX, 0, 0)
bx_define_opcode(BX_IA_IN_EAXIb, NULL, &BX_CPU_C::IN_EAXIb, 0, 0)
bx_define_opcode(BX_IA_INC_Eb, &BX_CPU_C::INC_EbM, &BX_CPU_C::INC_EbR, 0, 0)
bx_define_opcode(BX_IA_INC_Ew, &BX_CPU_C::INC_EwM, &BX_CPU_C::INC_RX, 0, 0)
bx_define_opcode(BX_IA_INC_Ed, &BX_CPU_C::INC_EdM, &BX_CPU_C::INC_ERX, 0, 0)
bx_define_opcode(BX_IA_INC_RX, NULL, &BX_CPU_C::INC_RX, 0, 0)
bx_define_opcode(BX_IA_INC_ERX, NULL, &BX_CPU_C::INC_ERX, 0, 0)
bx_define_opcode(BX_IA_INT_Ib, NULL, &BX_CPU_C::INT_Ib, 0, 0)
bx_define_opcode(BX_IA_INT1, NULL, &BX_CPU_C::INT1, 0, 0)
bx_define_opcode(BX_IA_INT3, NULL, &BX_CPU_C::INT3, 0, 0)
bx_define_opcode(BX_IA_INTO, NULL, &BX_CPU_C::INTO, 0, 0)
bx_define_opcode(BX_IA_IRET16, NULL, &BX_CPU_C::IRET16, 0, 0)
bx_define_opcode(BX_IA_IRET32, NULL, &BX_CPU_C::IRET32, 0, 0)
bx_define_opcode(BX_IA_JB_Jd, NULL, &BX_CPU_C::JB_Jd, 0, 0)
bx_define_opcode(BX_IA_JB_Jw, NULL, &BX_CPU_C::JB_Jw, 0, 0)
bx_define_opcode(BX_IA_JBE_Jd, NULL, &BX_CPU_C::JBE_Jd, 0, 0)
bx_define_opcode(BX_IA_JBE_Jw, NULL, &BX_CPU_C::JBE_Jw, 0, 0)
bx_define_opcode(BX_IA_JCXZ_Jb, NULL, &BX_CPU_C::JCXZ_Jb, 0, 0)
bx_define_opcode(BX_IA_JECXZ_Jb, NULL, &BX_CPU_C::JECXZ_Jb, 0, 0)
bx_define_opcode(BX_IA_JL_Jd, NULL, &BX_CPU_C::JL_Jd, 0, 0)
bx_define_opcode(BX_IA_JL_Jw, NULL, &BX_CPU_C::JL_Jw, 0, 0)
bx_define_opcode(BX_IA_JLE_Jd, NULL, &BX_CPU_C::JLE_Jd, 0, 0)
bx_define_opcode(BX_IA_JLE_Jw, NULL, &BX_CPU_C::JLE_Jw, 0, 0)
bx_define_opcode(BX_IA_JMP_Ap, NULL, &BX_CPU_C::JMP_Ap, 0, 0)
bx_define_opcode(BX_IA_JMP_Ed, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::JMP_EdR, 0, 0)
bx_define_opcode(BX_IA_JMP_Ew, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::JMP_EwR, 0, 0)
bx_define_opcode(BX_IA_JMP_Jd, NULL, &BX_CPU_C::JMP_Jd, 0, 0)
bx_define_opcode(BX_IA_JMP_Jw, NULL, &BX_CPU_C::JMP_Jw, 0, 0)
bx_define_opcode(BX_IA_JMP16_Ep, &BX_CPU_C::JMP16_Ep, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_JMP32_Ep, &BX_CPU_C::JMP32_Ep, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_JNB_Jd, NULL, &BX_CPU_C::JNB_Jd, 0, 0)
bx_define_opcode(BX_IA_JNB_Jw, NULL, &BX_CPU_C::JNB_Jw, 0, 0)
bx_define_opcode(BX_IA_JNBE_Jd, NULL, &BX_CPU_C::JNBE_Jd, 0, 0)
bx_define_opcode(BX_IA_JNBE_Jw, NULL, &BX_CPU_C::JNBE_Jw, 0, 0)
bx_define_opcode(BX_IA_JNL_Jd, NULL, &BX_CPU_C::JNL_Jd, 0, 0)
bx_define_opcode(BX_IA_JNL_Jw, NULL, &BX_CPU_C::JNL_Jw, 0, 0)
bx_define_opcode(BX_IA_JNLE_Jd, NULL, &BX_CPU_C::JNLE_Jd, 0, 0)
bx_define_opcode(BX_IA_JNLE_Jw, NULL, &BX_CPU_C::JNLE_Jw, 0, 0)
bx_define_opcode(BX_IA_JNO_Jd, NULL, &BX_CPU_C::JNO_Jd, 0, 0)
bx_define_opcode(BX_IA_JNO_Jw, NULL, &BX_CPU_C::JNO_Jw, 0, 0)
bx_define_opcode(BX_IA_JNP_Jd, NULL, &BX_CPU_C::JNP_Jd, 0, 0)
bx_define_opcode(BX_IA_JNP_Jw, NULL, &BX_CPU_C::JNP_Jw, 0, 0)
bx_define_opcode(BX_IA_JNS_Jd, NULL, &BX_CPU_C::JNS_Jd, 0, 0)
bx_define_opcode(BX_IA_JNS_Jw, NULL, &BX_CPU_C::JNS_Jw, 0, 0)
bx_define_opcode(BX_IA_JNZ_Jd, NULL, &BX_CPU_C::JNZ_Jd, 0, 0)
bx_define_opcode(BX_IA_JNZ_Jw, NULL, &BX_CPU_C::JNZ_Jw, 0, 0)
bx_define_opcode(BX_IA_JO_Jd, NULL, &BX_CPU_C::JO_Jd, 0, 0)
bx_define_opcode(BX_IA_JO_Jw, NULL, &BX_CPU_C::JO_Jw, 0, 0)
bx_define_opcode(BX_IA_JP_Jd, NULL, &BX_CPU_C::JP_Jd, 0, 0)
bx_define_opcode(BX_IA_JP_Jw, NULL, &BX_CPU_C::JP_Jw, 0, 0)
bx_define_opcode(BX_IA_JS_Jd, NULL, &BX_CPU_C::JS_Jd, 0, 0)
bx_define_opcode(BX_IA_JS_Jw, NULL, &BX_CPU_C::JS_Jw, 0, 0)
bx_define_opcode(BX_IA_JZ_Jd, NULL, &BX_CPU_C::JZ_Jd, 0, 0)
bx_define_opcode(BX_IA_JZ_Jw, NULL, &BX_CPU_C::JZ_Jw, 0, 0)
bx_define_opcode(BX_IA_LAHF, NULL, &BX_CPU_C::LAHF, 0, 0)
bx_define_opcode(BX_IA_LAR_GvEw, &BX_CPU_C::LAR_GvEw, &BX_CPU_C::LAR_GvEw, 0, 0)
bx_define_opcode(BX_IA_LDS_GdMp, &BX_CPU_C::LDS_GdMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LDS_GwMp, &BX_CPU_C::LDS_GwMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LEA_GdM, &BX_CPU_C::LEA_GdM, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LEA_GwM, &BX_CPU_C::LEA_GwM, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LEAVE16, NULL, &BX_CPU_C::LEAVE16, 0, 0)
bx_define_opcode(BX_IA_LEAVE32, NULL, &BX_CPU_C::LEAVE32, 0, 0)
bx_define_opcode(BX_IA_LES_GdMp, &BX_CPU_C::LES_GdMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LES_GwMp, &BX_CPU_C::LES_GwMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LFS_GdMp, &BX_CPU_C::LFS_GdMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LFS_GwMp, &BX_CPU_C::LFS_GwMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LGDT_Ms, &BX_CPU_C::LGDT_Ms, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LGS_GdMp, &BX_CPU_C::LGS_GdMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LGS_GwMp, &BX_CPU_C::LGS_GwMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LIDT_Ms, &BX_CPU_C::LIDT_Ms, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LLDT_Ew, &BX_CPU_C::LLDT_Ew, &BX_CPU_C::LLDT_Ew, 0, 0)
bx_define_opcode(BX_IA_LMSW_Ew, &BX_CPU_C::LMSW_Ew, &BX_CPU_C::LMSW_Ew, 0, 0)
bx_define_opcode(BX_IA_LOOP16_Jb, NULL, &BX_CPU_C::LOOP16_Jb, 0, 0)
bx_define_opcode(BX_IA_LOOPE16_Jb, NULL, &BX_CPU_C::LOOPE16_Jb, 0, 0)
bx_define_opcode(BX_IA_LOOPNE16_Jb, NULL, &BX_CPU_C::LOOPNE16_Jb, 0, 0)
bx_define_opcode(BX_IA_LOOP32_Jb, NULL, &BX_CPU_C::LOOP32_Jb, 0, 0)
bx_define_opcode(BX_IA_LOOPE32_Jb, NULL, &BX_CPU_C::LOOPE32_Jb, 0, 0)
bx_define_opcode(BX_IA_LOOPNE32_Jb, NULL, &BX_CPU_C::LOOPNE32_Jb, 0, 0)
bx_define_opcode(BX_IA_LSL_GvEw, &BX_CPU_C::LSL_GvEw, &BX_CPU_C::LSL_GvEw, 0, 0)
bx_define_opcode(BX_IA_LSS_GdMp, &BX_CPU_C::LSS_GdMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LSS_GwMp, &BX_CPU_C::LSS_GwMp, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_LTR_Ew, &BX_CPU_C::LTR_Ew, &BX_CPU_C::LTR_Ew, 0, 0)
bx_define_opcode(BX_IA_MOV_ALOd, NULL, &BX_CPU_C::MOV_ALOd, 0, 0)
bx_define_opcode(BX_IA_MOV_AXOd, NULL, &BX_CPU_C::MOV_AXOd, 0, 0)
bx_define_opcode(BX_IA_MOV_CR0Rd, NULL, &BX_CPU_C::MOV_CR0Rd, 0, 0)
bx_define_opcode(BX_IA_MOV_CR2Rd, NULL, &BX_CPU_C::MOV_CR2Rd, 0, 0)
bx_define_opcode(BX_IA_MOV_CR3Rd, NULL, &BX_CPU_C::MOV_CR3Rd, 0, 0)
bx_define_opcode(BX_IA_MOV_CR4Rd, NULL, &BX_CPU_C::MOV_CR4Rd, BX_CPU_486, 0)
bx_define_opcode(BX_IA_MOV_RdCR0, NULL, &BX_CPU_C::MOV_RdCR0, 0, 0)
bx_define_opcode(BX_IA_MOV_RdCR2, NULL, &BX_CPU_C::MOV_RdCR2, 0, 0)
bx_define_opcode(BX_IA_MOV_RdCR3, NULL, &BX_CPU_C::MOV_RdCR3, 0, 0)
bx_define_opcode(BX_IA_MOV_RdCR4, NULL, &BX_CPU_C::MOV_RdCR4, BX_CPU_486, 0)
bx_define_opcode(BX_IA_MOV_RdDd, NULL, &BX_CPU_C::MOV_RdDd, 0, 0)
bx_define_opcode(BX_IA_MOV_DdRd, NULL, &BX_CPU_C::MOV_DdRd, 0, 0)
bx_define_opcode(BX_IA_MOV_EAXOd, NULL, &BX_CPU_C::MOV_EAXOd, 0, 0)
bx_define_opcode(BX_IA_MOV_EbIb, &BX_CPU_C::MOV_EbIbM, &BX_CPU_C::MOV_RLIb, 0, 0)
bx_define_opcode(BX_IA_MOV_EdId, &BX_CPU_C::MOV_EdIdM, &BX_CPU_C::MOV_ERXId, 0, 0)
bx_define_opcode(BX_IA_MOV_EwIw, &BX_CPU_C::MOV_EwIwM, &BX_CPU_C::MOV_RXIw, 0, 0)
bx_define_opcode(BX_IA_MOV_ERXId, NULL, &BX_CPU_C::MOV_ERXId, 0, 0)
bx_define_opcode(BX_IA_MOV_EwSw, &BX_CPU_C::MOV_EwSwM, &BX_CPU_C::MOV_EwSwR, 0, 0)
bx_define_opcode(BX_IA_MOV_GbEb, &BX_CPU_C::MOV_GbEbM, &BX_CPU_C::MOV_GbEbR, 0, 0)
bx_define_opcode(BX_IA_MOV_EbGb, &BX_CPU_C::MOV_EbGbM, &BX_CPU_C::MOV_GbEbR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_MOV_GwEw, &BX_CPU_C::MOV_GwEwM, &BX_CPU_C::MOV_GwEwR, 0, 0)
bx_define_opcode(BX_IA_MOV_EwGw, &BX_CPU_C::MOV_EwGwM, &BX_CPU_C::MOV_GwEwR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_MOV32_GdEd, &BX_CPU_C::MOV32_GdEdM, &BX_CPU_C::MOV_GdEdR, 0, 0)
bx_define_opcode(BX_IA_MOV32_EdGd, &BX_CPU_C::MOV32_EdGdM, &BX_CPU_C::MOV_GdEdR, 0, 0) /* dstRM */
bx_define_opcode(BX_IA_MOV_OdAL, NULL, &BX_CPU_C::MOV_OdAL, 0, 0)
bx_define_opcode(BX_IA_MOV_OdAX, NULL, &BX_CPU_C::MOV_OdAX, 0, 0)
bx_define_opcode(BX_IA_MOV_OdEAX, NULL, &BX_CPU_C::MOV_OdEAX, 0, 0)
bx_define_opcode(BX_IA_MOV_RHIb, NULL, &BX_CPU_C::MOV_RHIb, 0, 0)
bx_define_opcode(BX_IA_MOV_RLIb, NULL, &BX_CPU_C::MOV_RLIb, 0, 0)
bx_define_opcode(BX_IA_MOV_RXIw, NULL, &BX_CPU_C::MOV_RXIw, 0, 0)
bx_define_opcode(BX_IA_MOV_SwEw, &BX_CPU_C::MOV_SwEw, &BX_CPU_C::MOV_SwEw, 0, 0)
bx_define_opcode(BX_IA_MOV_RdTd, &BX_CPU_C::MOV_RdTd, &BX_CPU_C::MOV_RdTd, 0, 0)
bx_define_opcode(BX_IA_MOV_TdRd, &BX_CPU_C::MOV_TdRd, &BX_CPU_C::MOV_TdRd, 0, 0)
bx_define_opcode(BX_IA_MOVSX_GdEb, &BX_CPU_C::MOVSX_GdEbM, &BX_CPU_C::MOVSX_GdEbR, 0, 0)
bx_define_opcode(BX_IA_MOVSX_GdEw, &BX_CPU_C::MOVSX_GdEwM, &BX_CPU_C::MOVSX_GdEwR, 0, 0)
bx_define_opcode(BX_IA_MOVSX_GwEb, &BX_CPU_C::MOVSX_GwEbM, &BX_CPU_C::MOVSX_GwEbR, 0, 0)
bx_define_opcode(BX_IA_MOVZX_GdEb, &BX_CPU_C::MOVZX_GdEbM, &BX_CPU_C::MOVZX_GdEbR, 0, 0)
bx_define_opcode(BX_IA_MOVZX_GdEw, &BX_CPU_C::MOVZX_GdEwM, &BX_CPU_C::MOVZX_GdEwR, 0, 0)
bx_define_opcode(BX_IA_MOVZX_GwEb, &BX_CPU_C::MOVZX_GwEbM, &BX_CPU_C::MOVZX_GwEbR, 0, 0)
bx_define_opcode(BX_IA_NOP, &BX_CPU_C::NOP, &BX_CPU_C::NOP, 0, 0)
bx_define_opcode(BX_IA_PAUSE, NULL, &BX_CPU_C::PAUSE, 0, 0)
bx_define_opcode(BX_IA_OR_ALIb, NULL, &BX_CPU_C::OR_ALIb, 0, 0)
bx_define_opcode(BX_IA_OR_AXIw, NULL, &BX_CPU_C::OR_AXIw, 0, 0)
bx_define_opcode(BX_IA_OR_EAXId, NULL, &BX_CPU_C::OR_EAXId, 0, 0)
bx_define_opcode(BX_IA_OR_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::OR_GbEbR, 0, 0)
bx_define_opcode(BX_IA_OR_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::OR_GwEwR, 0, 0)
bx_define_opcode(BX_IA_OR_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::OR_GdEdR, 0, 0)
bx_define_opcode(BX_IA_OUT_DXAL, NULL, &BX_CPU_C::OUT_DXAL, 0, 0)
bx_define_opcode(BX_IA_OUT_DXAX, NULL, &BX_CPU_C::OUT_DXAX, 0, 0)
bx_define_opcode(BX_IA_OUT_DXEAX, NULL, &BX_CPU_C::OUT_DXEAX, 0, 0)
bx_define_opcode(BX_IA_OUT_IbAL, NULL, &BX_CPU_C::OUT_IbAL, 0, 0)
bx_define_opcode(BX_IA_OUT_IbAX, NULL, &BX_CPU_C::OUT_IbAX, 0, 0)
bx_define_opcode(BX_IA_OUT_IbEAX, NULL, &BX_CPU_C::OUT_IbEAX, 0, 0)
bx_define_opcode(BX_IA_POP_Ew, &BX_CPU_C::POP_EwM, &BX_CPU_C::POP_RX, 0, 0)
bx_define_opcode(BX_IA_POP_Ed, &BX_CPU_C::POP_EdM, &BX_CPU_C::POP_ERX, 0, 0)
bx_define_opcode(BX_IA_POP_RX, NULL, &BX_CPU_C::POP_RX, 0, 0)
bx_define_opcode(BX_IA_POP_ERX, NULL, &BX_CPU_C::POP_ERX, 0, 0)
bx_define_opcode(BX_IA_POP16_DS, NULL, &BX_CPU_C::POP16_DS, 0, 0)
bx_define_opcode(BX_IA_POP16_ES, NULL, &BX_CPU_C::POP16_ES, 0, 0)
bx_define_opcode(BX_IA_POP16_FS, NULL, &BX_CPU_C::POP16_FS, 0, 0)
bx_define_opcode(BX_IA_POP16_GS, NULL, &BX_CPU_C::POP16_GS, 0, 0)
bx_define_opcode(BX_IA_POP16_SS, NULL, &BX_CPU_C::POP16_SS, 0, 0)
bx_define_opcode(BX_IA_POP32_DS, NULL, &BX_CPU_C::POP32_DS, 0, 0)
bx_define_opcode(BX_IA_POP32_ES, NULL, &BX_CPU_C::POP32_ES, 0, 0)
bx_define_opcode(BX_IA_POP32_FS, NULL, &BX_CPU_C::POP32_FS, 0, 0)
bx_define_opcode(BX_IA_POP32_GS, NULL, &BX_CPU_C::POP32_GS, 0, 0)
bx_define_opcode(BX_IA_POP32_SS, NULL, &BX_CPU_C::POP32_SS, 0, 0)
bx_define_opcode(BX_IA_POPAD16, NULL, &BX_CPU_C::POPAD16, 0, 0)
bx_define_opcode(BX_IA_POPAD32, NULL, &BX_CPU_C::POPAD32, 0, 0)
bx_define_opcode(BX_IA_POPF_Fd, NULL, &BX_CPU_C::POPF_Fd, 0, 0)
bx_define_opcode(BX_IA_POPF_Fw, NULL, &BX_CPU_C::POPF_Fw, 0, 0)
bx_define_opcode(BX_IA_PUSH_Ew, &BX_CPU_C::PUSH_EwM, &BX_CPU_C::PUSH_RX, 0, 0)
bx_define_opcode(BX_IA_PUSH_Ed, &BX_CPU_C::PUSH_EdM, &BX_CPU_C::PUSH_ERX, 0, 0)
bx_define_opcode(BX_IA_PUSH_RX, NULL, &BX_CPU_C::PUSH_RX, 0, 0)
bx_define_opcode(BX_IA_PUSH_ERX, NULL, &BX_CPU_C::PUSH_ERX, 0, 0)
bx_define_opcode(BX_IA_PUSH_Id, NULL, &BX_CPU_C::PUSH_Id, 0, 0)
bx_define_opcode(BX_IA_PUSH_Iw, NULL, &BX_CPU_C::PUSH_Iw, 0, 0)
bx_define_opcode(BX_IA_PUSH16_CS, NULL, &BX_CPU_C::PUSH16_CS, 0, 0)
bx_define_opcode(BX_IA_PUSH16_DS, NULL, &BX_CPU_C::PUSH16_DS, 0, 0)
bx_define_opcode(BX_IA_PUSH16_ES, NULL, &BX_CPU_C::PUSH16_ES, 0, 0)
bx_define_opcode(BX_IA_PUSH16_FS, NULL, &BX_CPU_C::PUSH16_FS, 0, 0)
bx_define_opcode(BX_IA_PUSH16_GS, NULL, &BX_CPU_C::PUSH16_GS, 0, 0)
bx_define_opcode(BX_IA_PUSH16_SS, NULL, &BX_CPU_C::PUSH16_SS, 0, 0)
bx_define_opcode(BX_IA_PUSH32_CS, NULL, &BX_CPU_C::PUSH32_CS, 0, 0)
bx_define_opcode(BX_IA_PUSH32_DS, NULL, &BX_CPU_C::PUSH32_DS, 0, 0)
bx_define_opcode(BX_IA_PUSH32_ES, NULL, &BX_CPU_C::PUSH32_ES, 0, 0)
bx_define_opcode(BX_IA_PUSH32_FS, NULL, &BX_CPU_C::PUSH32_FS, 0, 0)
bx_define_opcode(BX_IA_PUSH32_GS, NULL, &BX_CPU_C::PUSH32_GS, 0, 0)
bx_define_opcode(BX_IA_PUSH32_SS, NULL, &BX_CPU_C::PUSH32_SS, 0, 0)
bx_define_opcode(BX_IA_PUSHAD16, NULL, &BX_CPU_C::PUSHAD16, 0, 0)
bx_define_opcode(BX_IA_PUSHAD32, NULL, &BX_CPU_C::PUSHAD32, 0, 0)
bx_define_opcode(BX_IA_PUSHF_Fd, NULL, &BX_CPU_C::PUSHF_Fd, 0, 0)
bx_define_opcode(BX_IA_PUSHF_Fw, NULL, &BX_CPU_C::PUSHF_Fw, 0, 0)
bx_define_opcode(BX_IA_REP_CMPSB_XbYb, NULL, &BX_CPU_C::REP_CMPSB_XbYb, 0, 0)
bx_define_opcode(BX_IA_REP_CMPSD_XdYd, NULL, &BX_CPU_C::REP_CMPSD_XdYd, 0, 0)
bx_define_opcode(BX_IA_REP_CMPSW_XwYw, NULL, &BX_CPU_C::REP_CMPSW_XwYw, 0, 0)
bx_define_opcode(BX_IA_REP_INSB_YbDX, NULL, &BX_CPU_C::REP_INSB_YbDX, 0, 0)
bx_define_opcode(BX_IA_REP_INSD_YdDX, NULL, &BX_CPU_C::REP_INSD_YdDX, 0, 0)
bx_define_opcode(BX_IA_REP_INSW_YwDX, NULL, &BX_CPU_C::REP_INSW_YwDX, 0, 0)
bx_define_opcode(BX_IA_REP_LODSB_ALXb, NULL, &BX_CPU_C::REP_LODSB_ALXb, 0, 0)
bx_define_opcode(BX_IA_REP_LODSD_EAXXd, NULL, &BX_CPU_C::REP_LODSD_EAXXd, 0, 0)
bx_define_opcode(BX_IA_REP_LODSW_AXXw, NULL, &BX_CPU_C::REP_LODSW_AXXw, 0, 0)
bx_define_opcode(BX_IA_REP_MOVSB_XbYb, NULL, &BX_CPU_C::REP_MOVSB_XbYb, 0, 0)
bx_define_opcode(BX_IA_REP_MOVSD_XdYd, NULL, &BX_CPU_C::REP_MOVSD_XdYd, 0, 0)
bx_define_opcode(BX_IA_REP_MOVSW_XwYw, NULL, &BX_CPU_C::REP_MOVSW_XwYw, 0, 0)
bx_define_opcode(BX_IA_REP_OUTSB_DXXb, NULL, &BX_CPU_C::REP_OUTSB_DXXb, 0, 0)
bx_define_opcode(BX_IA_REP_OUTSD_DXXd, NULL, &BX_CPU_C::REP_OUTSD_DXXd, 0, 0)
bx_define_opcode(BX_IA_REP_OUTSW_DXXw, NULL, &BX_CPU_C::REP_OUTSW_DXXw, 0, 0)
bx_define_opcode(BX_IA_REP_SCASB_ALXb, NULL, &BX_CPU_C::REP_SCASB_ALXb, 0, 0)
bx_define_opcode(BX_IA_REP_SCASD_EAXXd, NULL, &BX_CPU_C::REP_SCASD_EAXXd, 0, 0)
bx_define_opcode(BX_IA_REP_SCASW_AXXw, NULL, &BX_CPU_C::REP_SCASW_AXXw, 0, 0)
bx_define_opcode(BX_IA_REP_STOSB_YbAL, NULL, &BX_CPU_C::REP_STOSB_YbAL, 0, 0)
bx_define_opcode(BX_IA_REP_STOSD_YdEAX, NULL, &BX_CPU_C::REP_STOSD_YdEAX, 0, 0)
bx_define_opcode(BX_IA_REP_STOSW_YwAX, NULL, &BX_CPU_C::REP_STOSW_YwAX, 0, 0)
bx_define_opcode(BX_IA_RETfar16, NULL, &BX_CPU_C::RETfar16, 0, 0)
bx_define_opcode(BX_IA_RETfar16_Iw, NULL, &BX_CPU_C::RETfar16_Iw, 0, 0)
bx_define_opcode(BX_IA_RETfar32, NULL, &BX_CPU_C::RETfar32, 0, 0)
bx_define_opcode(BX_IA_RETfar32_Iw, NULL, &BX_CPU_C::RETfar32_Iw, 0, 0)
bx_define_opcode(BX_IA_RETnear16, NULL, &BX_CPU_C::RETnear16, 0, 0)
bx_define_opcode(BX_IA_RETnear16_Iw, NULL, &BX_CPU_C::RETnear16_Iw, 0, 0)
bx_define_opcode(BX_IA_RETnear32, NULL, &BX_CPU_C::RETnear32, 0, 0)
bx_define_opcode(BX_IA_RETnear32_Iw, NULL, &BX_CPU_C::RETnear32_Iw, 0, 0)
bx_define_opcode(BX_IA_ROL_Eb, &BX_CPU_C::ROL_EbM, &BX_CPU_C::ROL_EbR, 0, 0)
bx_define_opcode(BX_IA_ROR_Eb, &BX_CPU_C::ROR_EbM, &BX_CPU_C::ROR_EbR, 0, 0)
bx_define_opcode(BX_IA_RCL_Eb, &BX_CPU_C::RCL_EbM, &BX_CPU_C::RCL_EbR, 0, 0)
bx_define_opcode(BX_IA_RCR_Eb, &BX_CPU_C::RCR_EbM, &BX_CPU_C::RCR_EbR, 0, 0)
bx_define_opcode(BX_IA_SHL_Eb, &BX_CPU_C::SHL_EbM, &BX_CPU_C::SHL_EbR, 0, 0)
bx_define_opcode(BX_IA_SHR_Eb, &BX_CPU_C::SHR_EbM, &BX_CPU_C::SHR_EbR, 0, 0)
bx_define_opcode(BX_IA_SAR_Eb, &BX_CPU_C::SAR_EbM, &BX_CPU_C::SAR_EbR, 0, 0)
bx_define_opcode(BX_IA_ROL_Ew, &BX_CPU_C::ROL_EwM, &BX_CPU_C::ROL_EwR, 0, 0)
bx_define_opcode(BX_IA_ROR_Ew, &BX_CPU_C::ROR_EwM, &BX_CPU_C::ROR_EwR, 0, 0)
bx_define_opcode(BX_IA_RCL_Ew, &BX_CPU_C::RCL_EwM, &BX_CPU_C::RCL_EwR, 0, 0)
bx_define_opcode(BX_IA_RCR_Ew, &BX_CPU_C::RCR_EwM, &BX_CPU_C::RCR_EwR, 0, 0)
bx_define_opcode(BX_IA_SHL_Ew, &BX_CPU_C::SHL_EwM, &BX_CPU_C::SHL_EwR, 0, 0)
bx_define_opcode(BX_IA_SHR_Ew, &BX_CPU_C::SHR_EwM, &BX_CPU_C::SHR_EwR, 0, 0)
bx_define_opcode(BX_IA_SAR_Ew, &BX_CPU_C::SAR_EwM, &BX_CPU_C::SAR_EwR, 0, 0)
bx_define_opcode(BX_IA_ROL_Ed, &BX_CPU_C::ROL_EdM, &BX_CPU_C::ROL_EdR, 0, 0)
bx_define_opcode(BX_IA_ROR_Ed, &BX_CPU_C::ROR_EdM, &BX_CPU_C::ROR_EdR, 0, 0)
bx_define_opcode(BX_IA_RCL_Ed, &BX_CPU_C::RCL_EdM, &BX_CPU_C::RCL_EdR, 0, 0)
bx_define_opcode(BX_IA_RCR_Ed, &BX_CPU_C::RCR_EdM, &BX_CPU_C::RCR_EdR, 0, 0)
bx_define_opcode(BX_IA_SHL_Ed, &BX_CPU_C::SHL_EdM, &BX_CPU_C::SHL_EdR, 0, 0)
bx_define_opcode(BX_IA_SHR_Ed, &BX_CPU_C::SHR_EdM, &BX_CPU_C::SHR_EdR, 0, 0)
bx_define_opcode(BX_IA_SAR_Ed, &BX_CPU_C::SAR_EdM, &BX_CPU_C::SAR_EdR, 0, 0)
bx_define_opcode(BX_IA_RSM, NULL, &BX_CPU_C::RSM, 0, 0)
bx_define_opcode(BX_IA_SAHF, NULL, &BX_CPU_C::SAHF, 0, 0)
bx_define_opcode(BX_IA_SALC, NULL, &BX_CPU_C::SALC, 0, 0)
bx_define_opcode(BX_IA_SBB_ALIb, NULL, &BX_CPU_C::SBB_ALIb, 0, 0)
bx_define_opcode(BX_IA_SBB_AXIw, NULL, &BX_CPU_C::SBB_AXIw, 0, 0)
bx_define_opcode(BX_IA_SBB_EAXId, NULL, &BX_CPU_C::SBB_EAXId, 0, 0)
bx_define_opcode(BX_IA_SBB_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SBB_GbEbR, 0, 0)
bx_define_opcode(BX_IA_SBB_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SBB_GwEwR, 0, 0)
bx_define_opcode(BX_IA_SBB_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SBB_GdEdR, 0, 0)
bx_define_opcode(BX_IA_SETB_Eb, &BX_CPU_C::SETB_EbM, &BX_CPU_C::SETB_EbR, 0, 0)
bx_define_opcode(BX_IA_SETBE_Eb, &BX_CPU_C::SETBE_EbM, &BX_CPU_C::SETBE_EbR, 0, 0)
bx_define_opcode(BX_IA_SETL_Eb, &BX_CPU_C::SETL_EbM, &BX_CPU_C::SETL_EbR, 0, 0)
bx_define_opcode(BX_IA_SETLE_Eb, &BX_CPU_C::SETLE_EbM, &BX_CPU_C::SETLE_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNB_Eb, &BX_CPU_C::SETNB_EbM, &BX_CPU_C::SETNB_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNBE_Eb, &BX_CPU_C::SETNBE_EbM, &BX_CPU_C::SETNBE_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNL_Eb, &BX_CPU_C::SETNL_EbM, &BX_CPU_C::SETNL_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNLE_Eb, &BX_CPU_C::SETNLE_EbM, &BX_CPU_C::SETNLE_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNO_Eb, &BX_CPU_C::SETNO_EbM, &BX_CPU_C::SETNO_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNP_Eb, &BX_CPU_C::SETNP_EbM, &BX_CPU_C::SETNP_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNS_Eb, &BX_CPU_C::SETNS_EbM, &BX_CPU_C::SETNS_EbR, 0, 0)
bx_define_opcode(BX_IA_SETNZ_Eb, &BX_CPU_C::SETNZ_EbM, &BX_CPU_C::SETNZ_EbR, 0, 0)
bx_define_opcode(BX_IA_SETO_Eb, &BX_CPU_C::SETO_EbM, &BX_CPU_C::SETO_EbR, 0, 0)
bx_define_opcode(BX_IA_SETP_Eb, &BX_CPU_C::SETP_EbM, &BX_CPU_C::SETP_EbR, 0, 0)
bx_define_opcode(BX_IA_SETS_Eb, &BX_CPU_C::SETS_EbM, &BX_CPU_C::SETS_EbR, 0, 0)
bx_define_opcode(BX_IA_SETZ_Eb, &BX_CPU_C::SETZ_EbM, &BX_CPU_C::SETZ_EbR, 0, 0)
bx_define_opcode(BX_IA_SGDT_Ms, &BX_CPU_C::SGDT_Ms, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_SHLD_EdGd, &BX_CPU_C::SHLD_EdGdM, &BX_CPU_C::SHLD_EdGdR, 0, 0)
bx_define_opcode(BX_IA_SHLD_EwGw, &BX_CPU_C::SHLD_EwGwM, &BX_CPU_C::SHLD_EwGwR, 0, 0)
bx_define_opcode(BX_IA_SHRD_EdGd, &BX_CPU_C::SHRD_EdGdM, &BX_CPU_C::SHRD_EdGdR, 0, 0)
bx_define_opcode(BX_IA_SHRD_EwGw, &BX_CPU_C::SHRD_EwGwM, &BX_CPU_C::SHRD_EwGwR, 0, 0)
bx_define_opcode(BX_IA_SIDT_Ms, &BX_CPU_C::SIDT_Ms, &BX_CPU_C::BxError, 0, 0)
bx_define_opcode(BX_IA_SLDT_Ew, &BX_CPU_C::SLDT_Ew, &BX_CPU_C::SLDT_Ew, 0, 0)
bx_define_opcode(BX_IA_SMSW_Ew, &BX_CPU_C::SMSW_EwM, &BX_CPU_C::SMSW_EwR, 0, 0)
bx_define_opcode(BX_IA_STC, NULL, &BX_CPU_C::STC, 0, 0)
bx_define_opcode(BX_IA_STD, NULL, &BX_CPU_C::STD, 0, 0)
bx_define_opcode(BX_IA_STI, NULL, &BX_CPU_C::STI, 0, 0)
bx_define_opcode(BX_IA_STR_Ew, &BX_CPU_C::STR_Ew, &BX_CPU_C::STR_Ew, 0, 0)
bx_define_opcode(BX_IA_SUB_ALIb, NULL, &BX_CPU_C::SUB_ALIb, 0, 0)
bx_define_opcode(BX_IA_SUB_AXIw, NULL, &BX_CPU_C::SUB_AXIw, 0, 0)
bx_define_opcode(BX_IA_SUB_EAXId, NULL, &BX_CPU_C::SUB_EAXId, 0, 0)
bx_define_opcode(BX_IA_SUB_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SUB_GbEbR, 0, 0)
bx_define_opcode(BX_IA_SUB_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SUB_GwEwR, 0, 0)
bx_define_opcode(BX_IA_SUB_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SUB_GdEdR, 0, 0)
bx_define_opcode(BX_IA_TEST_ALIb, NULL, &BX_CPU_C::TEST_ALIb, 0, 0)
bx_define_opcode(BX_IA_TEST_AXIw, NULL, &BX_CPU_C::TEST_AXIw, 0, 0)
bx_define_opcode(BX_IA_TEST_EAXId, NULL, &BX_CPU_C::TEST_EAXId, 0, 0)
bx_define_opcode(BX_IA_TEST_EbGb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbGbR, 0, 0)
bx_define_opcode(BX_IA_TEST_EbIb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbIbR, 0, 0)
bx_define_opcode(BX_IA_NOT_Eb, &BX_CPU_C::NOT_EbM, &BX_CPU_C::NOT_EbR, 0, 0)
bx_define_opcode(BX_IA_NEG_Eb, &BX_CPU_C::NEG_EbM, &BX_CPU_C::NEG_EbR, 0, 0)
bx_define_opcode(BX_IA_MUL_ALEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::MUL_ALEbR, 0, 0)
bx_define_opcode(BX_IA_IMUL_ALEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IMUL_ALEbR, 0, 0)
bx_define_opcode(BX_IA_DIV_ALEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::DIV_ALEbR, 0, 0)
bx_define_opcode(BX_IA_IDIV_ALEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IDIV_ALEbR, 0, 0)
bx_define_opcode(BX_IA_TEST_EwIw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwIwR, 0, 0)
bx_define_opcode(BX_IA_NOT_Ew, &BX_CPU_C::NOT_EwM, &BX_CPU_C::NOT_EwR, 0, 0)
bx_define_opcode(BX_IA_NEG_Ew, &BX_CPU_C::NEG_EwM, &BX_CPU_C::NEG_EwR, 0, 0)
bx_define_opcode(BX_IA_MUL_AXEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::MUL_AXEwR, 0, 0)
bx_define_opcode(BX_IA_IMUL_AXEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_AXEwR, 0, 0)
bx_define_opcode(BX_IA_DIV_AXEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::DIV_AXEwR, 0, 0)
bx_define_opcode(BX_IA_IDIV_AXEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IDIV_AXEwR, 0, 0)
bx_define_opcode(BX_IA_TEST_EdId, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdIdR, 0, 0)
bx_define_opcode(BX_IA_NOT_Ed, &BX_CPU_C::NOT_EdM, &BX_CPU_C::NOT_EdR, 0, 0)
bx_define_opcode(BX_IA_NEG_Ed, &BX_CPU_C::NEG_EdM, &BX_CPU_C::NEG_EdR, 0, 0)
bx_define_opcode(BX_IA_MUL_EAXEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::MUL_EAXEdR, 0, 0)
bx_define_opcode(BX_IA_IMUL_EAXEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_EAXEdR, 0, 0)
bx_define_opcode(BX_IA_DIV_EAXEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::DIV_EAXEdR, 0, 0)
bx_define_opcode(BX_IA_IDIV_EAXEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IDIV_EAXEdR, 0, 0)
bx_define_opcode(BX_IA_TEST_EdGd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdGdR, 0, 0)
bx_define_opcode(BX_IA_TEST_EwGw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwGwR, 0, 0)
bx_define_opcode(BX_IA_VERR_Ew, &BX_CPU_C::VERR_Ew, &BX_CPU_C::VERR_Ew, 0, 0)
bx_define_opcode(BX_IA_VERW_Ew, &BX_CPU_C::VERW_Ew, &BX_CPU_C::VERW_Ew, 0, 0)
bx_define_opcode(BX_IA_XCHG_EbGb, &BX_CPU_C::XCHG_EbGbM, &BX_CPU_C::XCHG_EbGbR, 0, 0)
bx_define_opcode(BX_IA_XCHG_EwGw, &BX_CPU_C::XCHG_EwGwM, &BX_CPU_C::XCHG_EwGwR, 0, 0)
bx_define_opcode(BX_IA_XCHG_EdGd, &BX_CPU_C::XCHG_EdGdM, &BX_CPU_C::XCHG_EdGdR, 0, 0)
bx_define_opcode(BX_IA_XCHG_RXAX, NULL, &BX_CPU_C::XCHG_RXAX, 0, 0)
bx_define_opcode(BX_IA_XCHG_ERXEAX, NULL, &BX_CPU_C::XCHG_ERXEAX, 0, 0)
bx_define_opcode(BX_IA_XLAT, NULL, &BX_CPU_C::XLAT, 0, 0)
bx_define_opcode(BX_IA_XOR_ALIb, NULL, &BX_CPU_C::XOR_ALIb, 0, 0)
bx_define_opcode(BX_IA_XOR_AXIw, NULL, &BX_CPU_C::XOR_AXIw, 0, 0)
bx_define_opcode(BX_IA_XOR_EAXId, NULL, &BX_CPU_C::XOR_EAXId, 0, 0)
bx_define_opcode(BX_IA_XOR_GbEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::XOR_GbEbR, 0, 0)
bx_define_opcode(BX_IA_XOR_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::XOR_GwEwR, 0, 0)
bx_define_opcode(BX_IA_XOR_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::XOR_GdEdR, 0, 0)

bx_define_opcode(BX_IA_SYSENTER, NULL, &BX_CPU_C::SYSENTER, BX_CPU_SYSENTER_SYSEXIT, 0)
bx_define_opcode(BX_IA_SYSEXIT, NULL, &BX_CPU_C::SYSEXIT, BX_CPU_SYSENTER_SYSEXIT, 0)

bx_define_opcode(BX_IA_MONITOR, &BX_CPU_C::BxError, &BX_CPU_C::MONITOR, BX_CPU_MONITOR_MWAIT, 0)
bx_define_opcode(BX_IA_MWAIT, &BX_CPU_C::BxError, &BX_CPU_C::MWAIT, BX_CPU_MONITOR_MWAIT, 0)

bx_define_opcode(BX_IA_FWAIT, NULL, &BX_CPU_C::FWAIT, BX_CPU_X87, 0)
#if BX_SUPPORT_FPU
bx_define_opcode(BX_IA_FLD_STi, &BX_CPU_C::FLD_STi, &BX_CPU_C::FLD_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLD_SINGLE_REAL, &BX_CPU_C::FLD_SINGLE_REAL, &BX_CPU_C::FLD_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLD_DOUBLE_REAL, &BX_CPU_C::FLD_DOUBLE_REAL, &BX_CPU_C::FLD_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLD_EXTENDED_REAL, &BX_CPU_C::FLD_EXTENDED_REAL, &BX_CPU_C::FLD_EXTENDED_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FILD_WORD_INTEGER, &BX_CPU_C::FILD_WORD_INTEGER, &BX_CPU_C::FILD_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FILD_DWORD_INTEGER, &BX_CPU_C::FILD_DWORD_INTEGER, &BX_CPU_C::FILD_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FILD_QWORD_INTEGER, &BX_CPU_C::FILD_QWORD_INTEGER, &BX_CPU_C::FILD_QWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FBLD_PACKED_BCD, &BX_CPU_C::FBLD_PACKED_BCD, &BX_CPU_C::FBLD_PACKED_BCD, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FST_STi, &BX_CPU_C::FST_STi, &BX_CPU_C::FST_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSTP_STi, &BX_CPU_C::FST_STi, &BX_CPU_C::FST_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FST_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSTP_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FST_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSTP_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSTP_EXTENDED_REAL, &BX_CPU_C::FSTP_EXTENDED_REAL, &BX_CPU_C::FSTP_EXTENDED_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIST_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISTP_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIST_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISTP_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISTP_QWORD_INTEGER, &BX_CPU_C::FISTP_QWORD_INTEGER, &BX_CPU_C::FISTP_QWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FBSTP_PACKED_BCD, &BX_CPU_C::FBSTP_PACKED_BCD, &BX_CPU_C::FBSTP_PACKED_BCD, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISTTP16, &BX_CPU_C::FISTTP16, &BX_CPU_C::FISTTP16, BX_CPU_X87 | BX_CPU_SSE3, 0)
bx_define_opcode(BX_IA_FISTTP32, &BX_CPU_C::FISTTP32, &BX_CPU_C::FISTTP32, BX_CPU_X87 | BX_CPU_SSE3, 0)
bx_define_opcode(BX_IA_FISTTP64, &BX_CPU_C::FISTTP64, &BX_CPU_C::FISTTP64, BX_CPU_X87 | BX_CPU_SSE3, 0)
bx_define_opcode(BX_IA_FNINIT, &BX_CPU_C::FNINIT, &BX_CPU_C::FNINIT, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNCLEX, &BX_CPU_C::FNCLEX, &BX_CPU_C::FNCLEX, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FRSTOR, &BX_CPU_C::FRSTOR, &BX_CPU_C::FRSTOR, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNSAVE, &BX_CPU_C::FNSAVE, &BX_CPU_C::FNSAVE, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDENV, &BX_CPU_C::FLDENV, &BX_CPU_C::FLDENV, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNSTENV, &BX_CPU_C::FNSTENV, &BX_CPU_C::FNSTENV, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDCW, &BX_CPU_C::FLDCW, &BX_CPU_C::FLDCW, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNSTCW, &BX_CPU_C::FNSTCW, &BX_CPU_C::FNSTCW, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNSTSW, &BX_CPU_C::FNSTSW, &BX_CPU_C::FNSTSW, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNSTSW_AX, &BX_CPU_C::FNSTSW_AX, &BX_CPU_C::FNSTSW_AX, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLD1, &BX_CPU_C::FLD1, &BX_CPU_C::FLD1, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDL2T, &BX_CPU_C::FLDL2T, &BX_CPU_C::FLDL2T, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDL2E, &BX_CPU_C::FLDL2E, &BX_CPU_C::FLDL2E, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDPI, &BX_CPU_C::FLDPI, &BX_CPU_C::FLDPI, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDLG2, &BX_CPU_C::FLDLG2, &BX_CPU_C::FLDLG2, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDLN2, &BX_CPU_C::FLDLN2, &BX_CPU_C::FLDLN2, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FLDZ, &BX_CPU_C::FLDZ, &BX_CPU_C::FLDZ, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FADD_ST0_STj, &BX_CPU_C::FADD_ST0_STj, &BX_CPU_C::FADD_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FADD_STi_ST0, &BX_CPU_C::FADD_STi_ST0, &BX_CPU_C::FADD_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FADD_SINGLE_REAL, &BX_CPU_C::FADD_SINGLE_REAL, &BX_CPU_C::FADD_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FADD_DOUBLE_REAL, &BX_CPU_C::FADD_DOUBLE_REAL, &BX_CPU_C::FADD_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIADD_WORD_INTEGER, &BX_CPU_C::FIADD_WORD_INTEGER, &BX_CPU_C::FIADD_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIADD_DWORD_INTEGER, &BX_CPU_C::FIADD_DWORD_INTEGER, &BX_CPU_C::FIADD_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FMUL_ST0_STj, &BX_CPU_C::FMUL_ST0_STj, &BX_CPU_C::FMUL_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FMUL_STi_ST0, &BX_CPU_C::FMUL_STi_ST0, &BX_CPU_C::FMUL_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FMUL_SINGLE_REAL, &BX_CPU_C::FMUL_SINGLE_REAL, &BX_CPU_C::FMUL_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FMUL_DOUBLE_REAL, &BX_CPU_C::FMUL_DOUBLE_REAL, &BX_CPU_C::FMUL_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIMUL_WORD_INTEGER , &BX_CPU_C::FIMUL_WORD_INTEGER , &BX_CPU_C::FIMUL_WORD_INTEGER , BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIMUL_DWORD_INTEGER, &BX_CPU_C::FIMUL_DWORD_INTEGER, &BX_CPU_C::FIMUL_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUB_ST0_STj, &BX_CPU_C::FSUB_ST0_STj, &BX_CPU_C::FSUB_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUBR_ST0_STj, &BX_CPU_C::FSUBR_ST0_STj, &BX_CPU_C::FSUBR_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUB_STi_ST0, &BX_CPU_C::FSUB_STi_ST0, &BX_CPU_C::FSUB_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUBR_STi_ST0, &BX_CPU_C::FSUBR_STi_ST0, &BX_CPU_C::FSUBR_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUB_SINGLE_REAL, &BX_CPU_C::FSUB_SINGLE_REAL, &BX_CPU_C::FSUB_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUBR_SINGLE_REAL, &BX_CPU_C::FSUBR_SINGLE_REAL, &BX_CPU_C::FSUBR_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUB_DOUBLE_REAL, &BX_CPU_C::FSUB_DOUBLE_REAL, &BX_CPU_C::FSUB_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSUBR_DOUBLE_REAL, &BX_CPU_C::FSUBR_DOUBLE_REAL, &BX_CPU_C::FSUBR_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISUB_WORD_INTEGER, &BX_CPU_C::FISUB_WORD_INTEGER, &BX_CPU_C::FISUB_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISUBR_WORD_INTEGER, &BX_CPU_C::FISUBR_WORD_INTEGER, &BX_CPU_C::FISUBR_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISUB_DWORD_INTEGER, &BX_CPU_C::FISUB_DWORD_INTEGER, &BX_CPU_C::FISUB_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FISUBR_DWORD_INTEGER, &BX_CPU_C::FISUBR_DWORD_INTEGER, &BX_CPU_C::FISUBR_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIV_ST0_STj, &BX_CPU_C::FDIV_ST0_STj, &BX_CPU_C::FDIV_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIVR_ST0_STj, &BX_CPU_C::FDIVR_ST0_STj, &BX_CPU_C::FDIVR_ST0_STj, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIV_STi_ST0, &BX_CPU_C::FDIV_STi_ST0, &BX_CPU_C::FDIV_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIVR_STi_ST0, &BX_CPU_C::FDIVR_STi_ST0, &BX_CPU_C::FDIVR_STi_ST0, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIV_SINGLE_REAL, &BX_CPU_C::FDIV_SINGLE_REAL, &BX_CPU_C::FDIV_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIVR_SINGLE_REAL, &BX_CPU_C::FDIVR_SINGLE_REAL, &BX_CPU_C::FDIVR_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIV_DOUBLE_REAL, &BX_CPU_C::FDIV_DOUBLE_REAL, &BX_CPU_C::FDIV_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDIVR_DOUBLE_REAL, &BX_CPU_C::FDIVR_DOUBLE_REAL, &BX_CPU_C::FDIVR_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIDIV_WORD_INTEGER, &BX_CPU_C::FIDIV_WORD_INTEGER, &BX_CPU_C::FIDIV_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIDIVR_WORD_INTEGER, &BX_CPU_C::FIDIVR_WORD_INTEGER, &BX_CPU_C::FIDIVR_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIDIV_DWORD_INTEGER, &BX_CPU_C::FIDIV_DWORD_INTEGER, &BX_CPU_C::FIDIV_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FIDIVR_DWORD_INTEGER, &BX_CPU_C::FIDIVR_DWORD_INTEGER, &BX_CPU_C::FIDIVR_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOM_STi, &BX_CPU_C::FCOM_STi, &BX_CPU_C::FCOM_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOMP_STi, &BX_CPU_C::FCOM_STi, &BX_CPU_C::FCOM_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FUCOM_STi, &BX_CPU_C::FUCOM_STi, &BX_CPU_C::FUCOM_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FUCOMP_STi, &BX_CPU_C::FUCOM_STi, &BX_CPU_C::FUCOM_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOMI_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, BX_CPU_X87 | BX_CPU_P6, 0)
bx_define_opcode(BX_IA_FCOMIP_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, BX_CPU_X87 | BX_CPU_P6, 0)
bx_define_opcode(BX_IA_FUCOMI_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, BX_CPU_X87 | BX_CPU_P6, 0)
bx_define_opcode(BX_IA_FUCOMIP_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, BX_CPU_X87 | BX_CPU_P6, 0)
bx_define_opcode(BX_IA_FCOM_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOMP_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOM_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOMP_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FICOM_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FICOMP_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FICOM_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FICOMP_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCMOV_ST0_STj, &BX_CPU_C::FCMOV_ST0_STj, &BX_CPU_C::FCMOV_ST0_STj, BX_CPU_X87 | BX_CPU_P6, 0)
bx_define_opcode(BX_IA_FCOMPP, &BX_CPU_C::FCOMPP, &BX_CPU_C::FCOMPP, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FUCOMPP, &BX_CPU_C::FUCOMPP, &BX_CPU_C::FUCOMPP, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FXCH_STi, &BX_CPU_C::FXCH_STi, &BX_CPU_C::FXCH_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FNOP, &BX_CPU_C::FNOP, &BX_CPU_C::FNOP, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FPLEGACY, &BX_CPU_C::FPLEGACY, &BX_CPU_C::FPLEGACY, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCHS, &BX_CPU_C::FCHS, &BX_CPU_C::FCHS, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FABS, &BX_CPU_C::FABS, &BX_CPU_C::FABS, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FTST, &BX_CPU_C::FTST, &BX_CPU_C::FTST, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FXAM, &BX_CPU_C::FXAM, &BX_CPU_C::FXAM, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FDECSTP, &BX_CPU_C::FDECSTP, &BX_CPU_C::FDECSTP, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FINCSTP, &BX_CPU_C::FINCSTP, &BX_CPU_C::FINCSTP, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FFREE_STi, &BX_CPU_C::FFREE_STi, &BX_CPU_C::FFREE_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FFREEP_STi, &BX_CPU_C::FFREEP_STi, &BX_CPU_C::FFREEP_STi, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_F2XM1, &BX_CPU_C::F2XM1, &BX_CPU_C::F2XM1, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FYL2X, &BX_CPU_C::FYL2X, &BX_CPU_C::FYL2X, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FPTAN, &BX_CPU_C::FPTAN, &BX_CPU_C::FPTAN, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FPATAN, &BX_CPU_C::FPATAN, &BX_CPU_C::FPATAN, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FXTRACT, &BX_CPU_C::FXTRACT, &BX_CPU_C::FXTRACT, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FPREM1, &BX_CPU_C::FPREM1, &BX_CPU_C::FPREM1, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FPREM, &BX_CPU_C::FPREM, &BX_CPU_C::FPREM, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FYL2XP1, &BX_CPU_C::FYL2XP1, &BX_CPU_C::FYL2XP1, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSQRT, &BX_CPU_C::FSQRT, &BX_CPU_C::FSQRT, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSINCOS, &BX_CPU_C::FSINCOS, &BX_CPU_C::FSINCOS, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FRNDINT, &BX_CPU_C::FRNDINT, &BX_CPU_C::FRNDINT, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSCALE, &BX_CPU_C::FSCALE, &BX_CPU_C::FSCALE, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FSIN, &BX_CPU_C::FSIN, &BX_CPU_C::FSIN, BX_CPU_X87, 0)
bx_define_opcode(BX_IA_FCOS, &BX_CPU_C::FCOS, &BX_CPU_C::FCOS, BX_CPU_X87, 0)
#else
bx_define_opcode(BX_IA_FPU_ESC, &BX_CPU_C::FPU_ESC, &BX_CPU_C::FPU_ESC, 0, 0)
#endif

// 486 new instructions
bx_define_opcode(BX_IA_CPUID, NULL, &BX_CPU_C::CPUID, BX_CPU_486, 0)
bx_define_opcode(BX_IA_BSWAP_RX, NULL, &BX_CPU_C::BSWAP_RX, BX_CPU_486, 0)
bx_define_opcode(BX_IA_BSWAP_ERX, NULL, &BX_CPU_C::BSWAP_ERX, BX_CPU_486, 0)
bx_define_opcode(BX_IA_INVD, NULL, &BX_CPU_C::INVD, BX_CPU_486, 0)
bx_define_opcode(BX_IA_WBINVD, NULL, &BX_CPU_C::WBINVD, BX_CPU_486, 0)
bx_define_opcode(BX_IA_XADD_EbGb, &BX_CPU_C::XADD_EbGbM, &BX_CPU_C::XADD_EbGbR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_XADD_EwGw, &BX_CPU_C::XADD_EwGwM, &BX_CPU_C::XADD_EwGwR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_XADD_EdGd, &BX_CPU_C::XADD_EdGdM, &BX_CPU_C::XADD_EdGdR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_CMPXCHG_EbGb, &BX_CPU_C::CMPXCHG_EbGbM, &BX_CPU_C::CMPXCHG_EbGbR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_CMPXCHG_EwGw, &BX_CPU_C::CMPXCHG_EwGwM, &BX_CPU_C::CMPXCHG_EwGwR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_CMPXCHG_EdGd, &BX_CPU_C::CMPXCHG_EdGdM, &BX_CPU_C::CMPXCHG_EdGdR, BX_CPU_486, 0)
bx_define_opcode(BX_IA_INVLPG, &BX_CPU_C::INVLPG, &BX_CPU_C::BxError, 0, 0)
// 486 new instructions

// Pentium new instructions
bx_define_opcode(BX_IA_CMPXCHG8B, &BX_CPU_C::CMPXCHG8B, &BX_CPU_C::BxError, BX_CPU_PENTIUM, 0)
bx_define_opcode(BX_IA_WRMSR, NULL, &BX_CPU_C::WRMSR, BX_CPU_PENTIUM, 0)
bx_define_opcode(BX_IA_RDMSR, NULL, &BX_CPU_C::RDMSR, BX_CPU_PENTIUM, 0)
bx_define_opcode(BX_IA_RDTSC, NULL, &BX_CPU_C::RDTSC, BX_CPU_PENTIUM, 0)
// Pentium new instructions

// MMX
bx_define_opcode(BX_IA_PUNPCKLBW_PqQd, &BX_CPU_C::PUNPCKLBW_PqQd, &BX_CPU_C::PUNPCKLBW_PqQd, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PUNPCKLWD_PqQd, &BX_CPU_C::PUNPCKLWD_PqQd, &BX_CPU_C::PUNPCKLWD_PqQd, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PUNPCKLDQ_PqQd, &BX_CPU_C::PUNPCKLDQ_PqQd, &BX_CPU_C::PUNPCKLDQ_PqQd, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PACKSSWB_PqQq, &BX_CPU_C::PACKSSWB_PqQq, &BX_CPU_C::PACKSSWB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPGTB_PqQq, &BX_CPU_C::PCMPGTB_PqQq, &BX_CPU_C::PCMPGTB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPGTW_PqQq, &BX_CPU_C::PCMPGTW_PqQq, &BX_CPU_C::PCMPGTW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPGTD_PqQq, &BX_CPU_C::PCMPGTD_PqQq, &BX_CPU_C::PCMPGTD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PACKUSWB_PqQq, &BX_CPU_C::PACKUSWB_PqQq, &BX_CPU_C::PACKUSWB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PUNPCKHBW_PqQq, &BX_CPU_C::PUNPCKHBW_PqQq, &BX_CPU_C::PUNPCKHBW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PUNPCKHWD_PqQq, &BX_CPU_C::PUNPCKHWD_PqQq, &BX_CPU_C::PUNPCKHWD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PUNPCKHDQ_PqQq, &BX_CPU_C::PUNPCKHDQ_PqQq, &BX_CPU_C::PUNPCKHDQ_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PACKSSDW_PqQq, &BX_CPU_C::PACKSSDW_PqQq, &BX_CPU_C::PACKSSDW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_MOVD_PqEd, &BX_CPU_C::MOVD_PqEdM, &BX_CPU_C::MOVD_PqEdR, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_MOVQ_PqQq, &BX_CPU_C::MOVQ_PqQqM, &BX_CPU_C::MOVQ_PqQqR, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPEQB_PqQq, &BX_CPU_C::PCMPEQB_PqQq, &BX_CPU_C::PCMPEQB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPEQW_PqQq, &BX_CPU_C::PCMPEQW_PqQq, &BX_CPU_C::PCMPEQW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PCMPEQD_PqQq, &BX_CPU_C::PCMPEQD_PqQq, &BX_CPU_C::PCMPEQD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_EMMS, NULL, &BX_CPU_C::EMMS, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_MOVD_EdPd, &BX_CPU_C::MOVD_EdPdM, &BX_CPU_C::MOVD_EdPdR, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_MOVQ_QqPq, &BX_CPU_C::MOVQ_QqPqM, &BX_CPU_C::MOVQ_QqPqR, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLW_PqQq, &BX_CPU_C::PSRLW_PqQq, &BX_CPU_C::PSRLW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLD_PqQq, &BX_CPU_C::PSRLD_PqQq, &BX_CPU_C::PSRLD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLQ_PqQq, &BX_CPU_C::PSRLQ_PqQq, &BX_CPU_C::PSRLQ_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PMULLW_PqQq, &BX_CPU_C::PMULLW_PqQq, &BX_CPU_C::PMULLW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBUSB_PqQq, &BX_CPU_C::PSUBUSB_PqQq, &BX_CPU_C::PSUBUSB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBUSW_PqQq, &BX_CPU_C::PSUBUSW_PqQq, &BX_CPU_C::PSUBUSW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PAND_PqQq, &BX_CPU_C::PAND_PqQq, &BX_CPU_C::PAND_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDUSB_PqQq, &BX_CPU_C::PADDUSB_PqQq, &BX_CPU_C::PADDUSB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDUSW_PqQq, &BX_CPU_C::PADDUSW_PqQq, &BX_CPU_C::PADDUSW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PANDN_PqQq, &BX_CPU_C::PANDN_PqQq, &BX_CPU_C::PANDN_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRAW_PqQq, &BX_CPU_C::PSRAW_PqQq, &BX_CPU_C::PSRAW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRAD_PqQq, &BX_CPU_C::PSRAD_PqQq, &BX_CPU_C::PSRAD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PMULHW_PqQq, &BX_CPU_C::PMULHW_PqQq, &BX_CPU_C::PMULHW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBSB_PqQq, &BX_CPU_C::PSUBSB_PqQq, &BX_CPU_C::PSUBSB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBSW_PqQq, &BX_CPU_C::PSUBSW_PqQq, &BX_CPU_C::PSUBSW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_POR_PqQq, &BX_CPU_C::POR_PqQq, &BX_CPU_C::POR_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDSB_PqQq, &BX_CPU_C::PADDSB_PqQq, &BX_CPU_C::PADDSB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDSW_PqQq, &BX_CPU_C::PADDSW_PqQq, &BX_CPU_C::PADDSW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PXOR_PqQq, &BX_CPU_C::PXOR_PqQq, &BX_CPU_C::PXOR_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLW_PqQq, &BX_CPU_C::PSLLW_PqQq, &BX_CPU_C::PSLLW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLD_PqQq, &BX_CPU_C::PSLLD_PqQq, &BX_CPU_C::PSLLD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLQ_PqQq, &BX_CPU_C::PSLLQ_PqQq, &BX_CPU_C::PSLLQ_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PMADDWD_PqQq, &BX_CPU_C::PMADDWD_PqQq, &BX_CPU_C::PMADDWD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBB_PqQq, &BX_CPU_C::PSUBB_PqQq, &BX_CPU_C::PSUBB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBW_PqQq, &BX_CPU_C::PSUBW_PqQq, &BX_CPU_C::PSUBW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSUBD_PqQq, &BX_CPU_C::PSUBD_PqQq, &BX_CPU_C::PSUBD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDB_PqQq, &BX_CPU_C::PADDB_PqQq, &BX_CPU_C::PADDB_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDW_PqQq, &BX_CPU_C::PADDW_PqQq, &BX_CPU_C::PADDW_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PADDD_PqQq, &BX_CPU_C::PADDD_PqQq, &BX_CPU_C::PADDD_PqQq, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLW_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLW_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRAW_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRAW_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLW_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLW_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLD_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLD_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRAD_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRAD_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLD_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLD_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSRLQ_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLQ_PqIb, BX_CPU_MMX, 0)
bx_define_opcode(BX_IA_PSLLQ_PqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLQ_PqIb, BX_CPU_MMX, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVQ_EqPq, &BX_CPU_C::MOVQ_QqPqM, &BX_CPU_C::MOVQ_EqPqR, BX_CPU_MMX | BX_CPU_X86_64, 0)
#endif
// MMX

bx_define_opcode(BX_IA_FEMMS, NULL, &BX_CPU_C::EMMS, BX_CPU_3DNOW, 0)
#if BX_SUPPORT_3DNOW
bx_define_opcode(BX_IA_PF2ID_PqQq, &BX_CPU_C::PF2ID_PqQq, &BX_CPU_C::PF2ID_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PF2IW_PqQq, &BX_CPU_C::PF2IW_PqQq, &BX_CPU_C::PF2IW_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFACC_PqQq, &BX_CPU_C::PFACC_PqQq, &BX_CPU_C::PFACC_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFADD_PqQq, &BX_CPU_C::PFADD_PqQq, &BX_CPU_C::PFADD_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFCMPEQ_PqQq, &BX_CPU_C::PFCMPEQ_PqQq, &BX_CPU_C::PFCMPEQ_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFCMPGE_PqQq, &BX_CPU_C::PFCMPGE_PqQq, &BX_CPU_C::PFCMPGE_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFCMPGT_PqQq, &BX_CPU_C::PFCMPGT_PqQq, &BX_CPU_C::PFCMPGT_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFMAX_PqQq, &BX_CPU_C::PFMAX_PqQq, &BX_CPU_C::PFMAX_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFMIN_PqQq, &BX_CPU_C::PFMIN_PqQq, &BX_CPU_C::PFMIN_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFMUL_PqQq, &BX_CPU_C::PFMUL_PqQq, &BX_CPU_C::PFMUL_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFNACC_PqQq, &BX_CPU_C::PFNACC_PqQq, &BX_CPU_C::PFNACC_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFPNACC_PqQq, &BX_CPU_C::PFPNACC_PqQq, &BX_CPU_C::PFPNACC_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFRCP_PqQq, &BX_CPU_C::PFRCP_PqQq, &BX_CPU_C::PFRCP_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFRCPIT1_PqQq, &BX_CPU_C::PFRCPIT1_PqQq, &BX_CPU_C::PFRCPIT1_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFRCPIT2_PqQq, &BX_CPU_C::PFRCPIT2_PqQq, &BX_CPU_C::PFRCPIT2_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFRSQIT1_PqQq, &BX_CPU_C::PFRSQIT1_PqQq, &BX_CPU_C::PFRSQIT1_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFRSQRT_PqQq, &BX_CPU_C::PFRSQRT_PqQq, &BX_CPU_C::PFRSQRT_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFSUB_PqQq, &BX_CPU_C::PFSUB_PqQq, &BX_CPU_C::PFSUB_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PFSUBR_PqQq, &BX_CPU_C::PFSUBR_PqQq, &BX_CPU_C::PFSUBR_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PI2FD_PqQq, &BX_CPU_C::PI2FD_PqQq, &BX_CPU_C::PI2FD_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PI2FW_PqQq, &BX_CPU_C::PI2FW_PqQq, &BX_CPU_C::PI2FW_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PMULHRW_PqQq, &BX_CPU_C::PMULHRW_PqQq, &BX_CPU_C::PMULHRW_PqQq, BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PSWAPD_PqQq, &BX_CPU_C::PSWAPD_PqQq, &BX_CPU_C::PSWAPD_PqQq, BX_CPU_3DNOW, 0)
#endif
bx_define_opcode(BX_IA_PREFETCHW, &BX_CPU_C::NOP, &BX_CPU_C::NOP, BX_CPU_3DNOW | BX_CPU_X86_64, 0)

// P6 new instructions
bx_define_opcode(BX_IA_CMOVB_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVB_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVB_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVB_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVBE_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVBE_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVBE_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVBE_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVL_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVL_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVL_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVL_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVLE_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVLE_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVLE_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVLE_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNB_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNB_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNB_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNB_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNBE_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNBE_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNBE_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNBE_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNL_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNL_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNL_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNL_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNLE_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNLE_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNLE_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNLE_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNO_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNO_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNO_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNO_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNP_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNP_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNP_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNP_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNS_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNS_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNS_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNS_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNZ_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNZ_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVNZ_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNZ_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVO_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVO_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVO_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVO_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVP_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVP_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVP_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVP_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVS_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVS_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVS_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVS_GwEwR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVZ_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVZ_GdEdR, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_CMOVZ_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVZ_GwEwR, BX_CPU_P6, 0)

bx_define_opcode(BX_IA_RDPMC, NULL, &BX_CPU_C::RDPMC, BX_CPU_P6, 0)
bx_define_opcode(BX_IA_UD2A, &BX_CPU_C::UndefinedOpcode, &BX_CPU_C::UndefinedOpcode, 0, 0)
bx_define_opcode(BX_IA_UD2B, &BX_CPU_C::UndefinedOpcode, &BX_CPU_C::UndefinedOpcode, 0, 0)
// P6 new instructions

// FXSAVE
bx_define_opcode(BX_IA_FXSAVE, &BX_CPU_C::FXSAVE, &BX_CPU_C::BxError, BX_CPU_FXSAVE_FXRSTOR, 0)
bx_define_opcode(BX_IA_FXRSTOR, &BX_CPU_C::FXRSTOR, &BX_CPU_C::BxError, BX_CPU_FXSAVE_FXRSTOR, 0)

// SSE
bx_define_opcode(BX_IA_LDMXCSR, &BX_CPU_C::LDMXCSR, &BX_CPU_C::BxError, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_STMXCSR, &BX_CPU_C::STMXCSR, &BX_CPU_C::BxError, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PREFETCH, &BX_CPU_C::PREFETCH, &BX_CPU_C::NOP, BX_CPU_SSE, 0)
// SSE

// SSE
bx_define_opcode(BX_IA_ANDPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ORPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ORPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_XORPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::XORPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ANDNPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDNPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVUPS_VpsWps, &BX_CPU_C::MOVUPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVUPS_WpsVps, &BX_CPU_C::MOVUPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_MOVSS_VssWss, &BX_CPU_C::MOVSS_VssWssM, &BX_CPU_C::MOVSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVSS_WssVss, &BX_CPU_C::MOVSS_WssVssM, &BX_CPU_C::MOVSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_MOVLPS_VpsMq, &BX_CPU_C::MOVLPS_VpsMq, &BX_CPU_C::MOVHLPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVLPS_MqVps, &BX_CPU_C::MOVLPS_MqVps, &BX_CPU_C::BxError, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVHPS_VpsMq, &BX_CPU_C::MOVHPS_VpsMq, &BX_CPU_C::MOVLHPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVHPS_MqVps, &BX_CPU_C::MOVHPS_MqVps, &BX_CPU_C::BxError, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVAPS_VpsWps, &BX_CPU_C::MOVAPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVAPS_WpsVps, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_CVTPI2PS_VpsQq, &BX_CPU_C::CVTPI2PS_VpsQqM, &BX_CPU_C::CVTPI2PS_VpsQqR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSI2SS_VssEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CVTSI2SS_VssEdR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTPS_MpsVps, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::BxError, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTPS2PI_PqWps, &BX_CPU_C::CVTTPS2PI_PqWps, &BX_CPU_C::CVTTPS2PI_PqWps, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTSS2SI_GdWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CVTTSS2SI_GdWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPS2PI_PqWps, &BX_CPU_C::CVTPS2PI_PqWps, &BX_CPU_C::CVTPS2PI_PqWps, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSS2SI_GdWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CVTSS2SI_GdWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UCOMISS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::UCOMISS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_COMISS_VpsWps, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::COMISS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVMSKPS_GdVRps, &BX_CPU_C::BxError, &BX_CPU_C::MOVMSKPS_GdVRps, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SQRTPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SQRTPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SQRTSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::SQRTSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_RSQRTPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::RSQRTPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_RSQRTSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::RSQRTSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_RCPPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::RCPPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_RCPSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::RCPSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ADDPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::ADDSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MULPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MULPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MULSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::MULSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SUBPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SUBPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SUBSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::SUBSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MINPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MINPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MINSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::MINSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DIVPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::DIVPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DIVSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::DIVSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MAXPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MAXPS_VpsWpsR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MAXSS_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::MAXSS_VssWssR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSHUFW_PqQqIb, &BX_CPU_C::PSHUFW_PqQqIb, &BX_CPU_C::PSHUFW_PqQqIb, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PSHUFLW_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSHUFLW_VdqWdqIbR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CMPPS_VpsWpsIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CMPPS_VpsWpsIbR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CMPSS_VssWssIb, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CMPSS_VssWssIbR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PINSRW_PqEwIb, &BX_CPU_C::PINSRW_PqEwIb, &BX_CPU_C::PINSRW_PqEwIb, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PEXTRW_GdPqIb, &BX_CPU_C::BxError, &BX_CPU_C::PEXTRW_GdPqIb, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_SHUFPS_VpsWpsIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SHUFPS_VpsWpsIbR, BX_CPU_SSE, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVMSKB_GdPRq, &BX_CPU_C::BxError, &BX_CPU_C::PMOVMSKB_GdPRq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PMINUB_PqQq, &BX_CPU_C::PMINUB_PqQq, &BX_CPU_C::PMINUB_PqQq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PMAXUB_PqQq, &BX_CPU_C::PMAXUB_PqQq, &BX_CPU_C::PMAXUB_PqQq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PAVGB_PqQq, &BX_CPU_C::PAVGB_PqQq, &BX_CPU_C::PAVGB_PqQq, BX_CPU_SSE, 0)
bx_define_opcode(BX_IA_PAVGW_PqQq, &BX_CPU_C::PAVGW_PqQq, &BX_CPU_C::PAVGW_PqQq, BX_CPU_SSE, 0)
bx_define_opcode(BX_IA_PMULHUW_PqQq, &BX_CPU_C::PMULHUW_PqQq, &BX_CPU_C::PMULHUW_PqQq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_MOVNTQ_MqPq, &BX_CPU_C::MOVNTQ_MqPq, &BX_CPU_C::BxError, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PMINSW_PqQq, &BX_CPU_C::PMINSW_PqQq, &BX_CPU_C::PMINSW_PqQq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_PMAXSW_PqQq, &BX_CPU_C::PMAXSW_PqQq, &BX_CPU_C::PMAXSW_PqQq, BX_CPU_SSE, 0)
bx_define_opcode(BX_IA_PSADBW_PqQq, &BX_CPU_C::PSADBW_PqQq, &BX_CPU_C::PSADBW_PqQq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
bx_define_opcode(BX_IA_MASKMOVQ_PqPRq, &BX_CPU_C::BxError, &BX_CPU_C::MASKMOVQ_PqPRq, BX_CPU_SSE | BX_CPU_3DNOW, 0)
// SSE

// SSE2
bx_define_opcode(BX_IA_MOVSD_VsdWsd, &BX_CPU_C::MOVQ_VqWqM, &BX_CPU_C::MOVSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVSD_WsdVsd, &BX_CPU_C::MOVLPS_MqVps, &BX_CPU_C::MOVSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPI2PD_VpdQq, &BX_CPU_C::CVTPI2PD_VpdQqM, &BX_CPU_C::CVTPI2PD_VpdQqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CVTSI2SD_VsdEdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTPD2PI_PqWpd, &BX_CPU_C::CVTTPD2PI_PqWpd, &BX_CPU_C::CVTTPD2PI_PqWpd, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTSD2SI_GdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTTSD2SI_GdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPD2PI_PqWpd, &BX_CPU_C::CVTPD2PI_PqWpd, &BX_CPU_C::CVTPD2PI_PqWpd, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSD2SI_GdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTSD2SI_GdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UCOMISD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::UCOMISD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_COMISD_VpdWpd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::COMISD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVMSKPD_GdVRpd, &BX_CPU_C::BxError, &BX_CPU_C::MOVMSKPD_GdVRpd, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SQRTPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SQRTPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SQRTSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::SQRTSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ADDPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::ADDSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MULPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MULPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MULSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::MULSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPS2PD_VpsWps, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTPS2PD_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPD2PS_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTPD2PS_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSD2SS_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTSD2SS_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSS2SD_VssWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CVTSS2SD_VssWssR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTDQ2PS_VpsWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTDQ2PS_VpsWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPS2DQ_VdqWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTPS2DQ_VdqWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTPS2DQ_VdqWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTTPS2DQ_VdqWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SUBPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SUBPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SUBSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::SUBSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MINPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MINPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MINSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::MINSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DIVPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::DIVPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DIVSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::DIVSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MAXPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MAXPD_VpdWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MAXSD_VsdWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::MAXSD_VsdWsdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UNPCKHPD_VpdWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UNPCKLPD_VpdWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKHDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::UNPCKHPS_VpsWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKLDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::UNPCKLPS_VpsWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVAPD_VpdWpd, &BX_CPU_C::MOVAPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVAPD_WpdVpd, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_MOVDQA_VdqWdq, &BX_CPU_C::MOVAPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVDQA_WdqVdq, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_MOVDQU_VdqWdq, &BX_CPU_C::MOVUPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVDQU_WdqVdq, &BX_CPU_C::MOVUPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_MOVHPD_MqVsd, &BX_CPU_C::MOVHPS_MqVps, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVHPD_VsdMq, &BX_CPU_C::MOVHPS_VpsMq, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVLPD_MqVsd, &BX_CPU_C::MOVLPS_MqVps, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVLPD_VsdMq, &BX_CPU_C::MOVLPS_VpsMq, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTDQ_MdqVdq, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTPD_MpdVpd, &BX_CPU_C::MOVAPS_WpsVpsM, &BX_CPU_C::BxError, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVUPD_VpdWpd, &BX_CPU_C::MOVUPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVUPD_WpdVpd, &BX_CPU_C::MOVUPS_WpsVpsM, &BX_CPU_C::MOVAPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE) /* dstRM */
bx_define_opcode(BX_IA_ANDNPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDNPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ANDPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ORPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ORPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_XORPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::XORPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PAND_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PANDN_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ANDNPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_POR_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ORPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PXOR_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::XORPS_VpsWpsR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKLBW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKLBW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKLWD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKLWD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UNPCKLPS_VpsWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::UNPCKLPS_VpsWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PACKSSWB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PACKSSWB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPGTB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPGTB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPGTW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPGTW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPGTD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPGTD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PACKUSWB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PACKUSWB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKHBW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKHBW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKHWD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKHWD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_UNPCKHPS_VpsWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::UNPCKHPS_VpsWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PACKSSDW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PACKSSDW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKLQDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PUNPCKHQDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVD_VdqEd, &BX_CPU_C::MOVSS_VssWssM, &BX_CPU_C::MOVD_VdqEdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSHUFD_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSHUFD_VdqWdqIbR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSHUFHW_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSHUFHW_VdqWdqIbR, BX_CPU_SSE2, BX_PREPARE_SSE) 
bx_define_opcode(BX_IA_PCMPEQB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPEQB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPEQW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPEQW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPEQD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPEQD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVD_EdVd, &BX_CPU_C::MOVSS_WssVssM, &BX_CPU_C::MOVD_EdVdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVQ_VqWq, &BX_CPU_C::MOVQ_VqWqM, &BX_CPU_C::MOVQ_VqWqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CMPPD_VpdWpdIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CMPPD_VpdWpdIbR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CMPSD_VsdWsdIb, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CMPSD_VsdWsdIbR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTI_MdGd, &BX_CPU_C::MOVNTI_MdGd, &BX_CPU_C::BxError, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_PINSRW_VdqEwIb, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::PINSRW_VdqEwIbR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PEXTRW_GdUdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PEXTRW_GdUdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_SHUFPD_VpdWpdIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::SHUFPD_VpdWpdIbR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSRLW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSRLD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSRLQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDQ_PqQq, &BX_CPU_C::PADDQ_PqQq, &BX_CPU_C::PADDQ_PqQq, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_PADDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULLW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULLW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVQ_WqVq, &BX_CPU_C::MOVLPS_MqVps, &BX_CPU_C::MOVQ_VqWqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVDQ2Q_PqVRq, &BX_CPU_C::BxError, &BX_CPU_C::MOVDQ2Q_PqVRq, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVQ2DQ_VdqQq, &BX_CPU_C::BxError, &BX_CPU_C::MOVQ2DQ_VdqQq, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVMSKB_GdUdq, &BX_CPU_C::BxError, &BX_CPU_C::PMOVMSKB_GdUdq, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBUSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBUSB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBUSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBUSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINUB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINUB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDUSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDUSB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDUSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDUSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXUB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXUB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PAVGB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PAVGB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRAW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSRAW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRAD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSRAD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PAVGW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PAVGW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULHUW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULHUW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULHW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULHW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTPD2DQ_VqWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTTPD2DQ_VqWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTPD2DQ_VqWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::CVTPD2DQ_VqWpdR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTDQ2PD_VpdWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTDQ2PD_VpdWqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBSB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDSB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXSW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSLLW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSLLD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSLLQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULUDQ_PqQq, &BX_CPU_C::PMULUDQ_PqQq, &BX_CPU_C::PMULUDQ_PqQq, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_PMULUDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULUDQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMADDWD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMADDWD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSADBW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSADBW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MASKMOVDQU_VdqUdq, &BX_CPU_C::BxError, &BX_CPU_C::MASKMOVDQU_VdqUdq, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSUBQ_PqQq, &BX_CPU_C::PSUBQ_PqQq, &BX_CPU_C::PSUBQ_PqQq, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_PSUBQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSUBQ_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDB_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDW_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PADDD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PADDD_VdqWdqR, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLW_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLW_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRAW_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRAW_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLW_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLW_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLD_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLD_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRAD_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRAD_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLD_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLD_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLQ_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLQ_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSRLDQ_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSRLDQ_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLQ_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLQ_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSLLDQ_UdqIb, &BX_CPU_C::BxError, &BX_CPU_C::PSLLDQ_UdqIb, BX_CPU_SSE2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_LFENCE, &BX_CPU_C::BxError, &BX_CPU_C::NOP, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_SFENCE, &BX_CPU_C::BxError, &BX_CPU_C::NOP, BX_CPU_SSE2, 0)
bx_define_opcode(BX_IA_MFENCE, &BX_CPU_C::BxError, &BX_CPU_C::NOP, BX_CPU_SSE2, 0)
// SSE2

// SSE3
bx_define_opcode(BX_IA_MOVDDUP_VpdWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::MOVDDUP_VpdWqR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVSLDUP_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MOVSLDUP_VpsWpsR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVSHDUP_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MOVSHDUP_VpsWpsR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_HADDPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::HADDPD_VpdWpdR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_HADDPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::HADDPS_VpsWpsR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_HSUBPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::HSUBPD_VpdWpdR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_HSUBPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::HSUBPS_VpsWpsR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDSUBPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ADDSUBPD_VpdWpdR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ADDSUBPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ADDSUBPS_VpsWpsR, BX_CPU_SSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_LDDQU_VdqMdq, &BX_CPU_C::MOVUPS_VpsWpsM, &BX_CPU_C::BxError, BX_CPU_SSE3, BX_PREPARE_SSE)
// SSE3

// SSSE3
bx_define_opcode(BX_IA_PSHUFB_PqQq, &BX_CPU_C::PSHUFB_PqQq, &BX_CPU_C::PSHUFB_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHADDW_PqQq, &BX_CPU_C::PHADDW_PqQq, &BX_CPU_C::PHADDW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHADDD_PqQq, &BX_CPU_C::PHADDD_PqQq, &BX_CPU_C::PHADDD_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHADDSW_PqQq, &BX_CPU_C::PHADDSW_PqQq, &BX_CPU_C::PHADDSW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PMADDUBSW_PqQq, &BX_CPU_C::PMADDUBSW_PqQq, &BX_CPU_C::PMADDUBSW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHSUBSW_PqQq, &BX_CPU_C::PHSUBSW_PqQq, &BX_CPU_C::PHSUBSW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHSUBW_PqQq, &BX_CPU_C::PHSUBW_PqQq, &BX_CPU_C::PHSUBW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PHSUBD_PqQq, &BX_CPU_C::PHSUBD_PqQq, &BX_CPU_C::PHSUBD_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PSIGNB_PqQq, &BX_CPU_C::PSIGNB_PqQq, &BX_CPU_C::PSIGNB_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PSIGNW_PqQq, &BX_CPU_C::PSIGNW_PqQq, &BX_CPU_C::PSIGNW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PSIGND_PqQq, &BX_CPU_C::PSIGND_PqQq, &BX_CPU_C::PSIGND_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PMULHRSW_PqQq, &BX_CPU_C::PMULHRSW_PqQq, &BX_CPU_C::PMULHRSW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PABSB_PqQq, &BX_CPU_C::PABSB_PqQq, &BX_CPU_C::PABSB_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PABSW_PqQq, &BX_CPU_C::PABSW_PqQq, &BX_CPU_C::PABSW_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PABSD_PqQq, &BX_CPU_C::PABSD_PqQq, &BX_CPU_C::PABSD_PqQq, BX_CPU_SSSE3, 0)
bx_define_opcode(BX_IA_PALIGNR_PqQqIb, &BX_CPU_C::PALIGNR_PqQqIb, &BX_CPU_C::PALIGNR_PqQqIb, BX_CPU_SSSE3, 0)

bx_define_opcode(BX_IA_PSHUFB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSHUFB_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHADDW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHADDW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHADDD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHADDD_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHADDSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHADDSW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMADDUBSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMADDUBSW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHSUBSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHSUBSW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHSUBW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHSUBW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHSUBD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHSUBD_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSIGNB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSIGNB_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSIGNW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSIGNW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PSIGND_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PSIGND_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULHRSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULHRSW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PABSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PABSB_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PABSW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PABSW_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PABSD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PABSD_VdqWdqR, BX_CPU_SSSE3, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PALIGNR_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PALIGNR_VdqWdqIbR, BX_CPU_SSSE3, BX_PREPARE_SSE)
// SSSE3

// SSE4.1
bx_define_opcode(BX_IA_PBLENDVB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PBLENDVB_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_BLENDVPS_VpsWps, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::BLENDVPS_VpsWpsR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_BLENDVPD_VpdWpd, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::BLENDVPD_VpdWpdR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PTEST_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PTEST_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULDQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULDQ_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPEQQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPEQQ_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PACKUSDW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PACKUSDW_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXBW_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVSXBW_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXBD_VdqWd, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::PMOVSXBD_VdqWdR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXBQ_VdqWw, &BX_CPU_C::LOAD_Ww, &BX_CPU_C::PMOVSXBQ_VdqWwR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXWD_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVSXWD_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXWQ_VdqWd, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::PMOVSXWQ_VdqWdR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVSXDQ_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVSXDQ_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXBW_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVZXBW_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXBD_VdqWd, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::PMOVZXBD_VdqWdR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXBQ_VdqWw, &BX_CPU_C::LOAD_Ww, &BX_CPU_C::PMOVZXBQ_VdqWwR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXWD_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVZXWD_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXWQ_VdqWd, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::PMOVZXWQ_VdqWdR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMOVZXDQ_VdqWq, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::PMOVZXDQ_VdqWqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINSB_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINSD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINSD_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINUW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINUW_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMINUD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMINUD_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXSB_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXSB_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXSD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXSD_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXUW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXUW_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMAXUD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMAXUD_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PMULLD_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PMULLD_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PHMINPOSUW_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PHMINPOSUW_VdqWdqR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ROUNDPS_VpsWpsIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ROUNDPS_VpsWpsIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ROUNDPD_VpdWpdIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::ROUNDPD_VpdWpdIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ROUNDSS_VssWssIb, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::ROUNDSS_VssWssIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_ROUNDSD_VsdWsdIb, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::ROUNDSD_VsdWsdIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_BLENDPS_VpsWpsIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::BLENDPS_VpsWpsIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_BLENDPD_VpdWpdIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::BLENDPD_VpdWpdIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PBLENDW_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PBLENDW_VdqWdqIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PEXTRB_EbdVdqIb, &BX_CPU_C::PEXTRB_EbdVdqIbM, &BX_CPU_C::PEXTRB_EbdVdqIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PEXTRW_EwdVdqIb, &BX_CPU_C::PEXTRW_EwdVdqIbM, &BX_CPU_C::PEXTRW_EwdVdqIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PEXTRD_EdVdqIb, &BX_CPU_C::PEXTRD_EdVdqIbM, &BX_CPU_C::PEXTRD_EdVdqIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_EXTRACTPS_EdVpsIb, &BX_CPU_C::EXTRACTPS_EdVpsIbM, &BX_CPU_C::EXTRACTPS_EdVpsIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PINSRB_VdqEbIb, &BX_CPU_C::PINSRB_VdqEbIb, &BX_CPU_C::PINSRB_VdqEbIb, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_INSERTPS_VpsWssIb, &BX_CPU_C::INSERTPS_VpsWssIb, &BX_CPU_C::INSERTPS_VpsWssIb, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PINSRD_VdqEdIb, &BX_CPU_C::PINSRD_VdqEdIbM, &BX_CPU_C::PINSRD_VdqEdIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DPPS_VpsWpsIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::DPPS_VpsWpsIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_DPPD_VpdWpdIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::DPPD_VpdWpdIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MPSADBW_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::MPSADBW_VdqWdqIbR, BX_CPU_SSE4_1, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTDQA_VdqMdq, &BX_CPU_C::MOVAPS_VpsWpsM, &BX_CPU_C::BxError, BX_CPU_SSE4_1, BX_PREPARE_SSE)
// SSE4.1

// SSE4.2
bx_define_opcode(BX_IA_CRC32_GdEb, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::CRC32_GdEbR, BX_CPU_SSE4_2, 0)
bx_define_opcode(BX_IA_CRC32_GdEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CRC32_GdEwR, BX_CPU_SSE4_2, 0)
bx_define_opcode(BX_IA_CRC32_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CRC32_GdEdR, BX_CPU_SSE4_2, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_CRC32_GdEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CRC32_GdEqR, BX_CPU_SSE4_2 | BX_CPU_X86_64, 0)
#endif
bx_define_opcode(BX_IA_PCMPGTQ_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCMPGTQ_VdqWdqR, BX_CPU_SSE4_2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPESTRM_VdqWdqIb, &BX_CPU_C::LOADU_Wdq, &BX_CPU_C::PCMPESTRM_VdqWdqIbR, BX_CPU_SSE4_2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPESTRI_VdqWdqIb, &BX_CPU_C::LOADU_Wdq, &BX_CPU_C::PCMPESTRI_VdqWdqIbR, BX_CPU_SSE4_2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPISTRM_VdqWdqIb, &BX_CPU_C::LOADU_Wdq, &BX_CPU_C::PCMPISTRM_VdqWdqIbR, BX_CPU_SSE4_2, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCMPISTRI_VdqWdqIb, &BX_CPU_C::LOADU_Wdq, &BX_CPU_C::PCMPISTRI_VdqWdqIbR, BX_CPU_SSE4_2, BX_PREPARE_SSE)
// SSE4.2

// MOVBE instruction
bx_define_opcode(BX_IA_MOVBE_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::MOVBE_GwEwR, BX_CPU_MOVBE, 0)
bx_define_opcode(BX_IA_MOVBE_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::MOVBE_GdEdR, BX_CPU_MOVBE, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVBE_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::MOVBE_GqEqR, BX_CPU_MOVBE | BX_CPU_X86_64, 0)
#endif
bx_define_opcode(BX_IA_MOVBE_EwGw, &BX_CPU_C::MOVBE_EwGw, &BX_CPU_C::MOVBE_EwGw, BX_CPU_MOVBE, 0)
bx_define_opcode(BX_IA_MOVBE_EdGd, &BX_CPU_C::MOVBE_EdGd, &BX_CPU_C::MOVBE_EdGd, BX_CPU_MOVBE, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVBE_EqGq, &BX_CPU_C::MOVBE_EqGq, &BX_CPU_C::MOVBE_EqGq, BX_CPU_MOVBE | BX_CPU_X86_64, 0)
#endif
// MOVBE instruction

// POPCNT instruction
bx_define_opcode(BX_IA_POPCNT_GdEd, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::POPCNT_GdEdR, BX_CPU_SSE4_2, 0)
bx_define_opcode(BX_IA_POPCNT_GwEw, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::POPCNT_GwEwR, BX_CPU_SSE4_2, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_POPCNT_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::POPCNT_GqEqR, BX_CPU_SSE4_2 | BX_CPU_X86_64, 0)
#endif
// POPCNT instruction

// XSAVE extensions
bx_define_opcode(BX_IA_XRSTOR, &BX_CPU_C::XRSTOR, &BX_CPU_C::BxError, BX_CPU_XSAVE, 0)
bx_define_opcode(BX_IA_XSAVE, &BX_CPU_C::XSAVE, &BX_CPU_C::BxError, BX_CPU_XSAVE, 0)
bx_define_opcode(BX_IA_XSETBV, &BX_CPU_C::BxError, &BX_CPU_C::XSETBV, BX_CPU_XSAVE, 0)
bx_define_opcode(BX_IA_XGETBV, &BX_CPU_C::BxError, &BX_CPU_C::XGETBV, BX_CPU_XSAVE, 0)

// AES instructions
bx_define_opcode(BX_IA_AESIMC_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESIMC_VdqWdqR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_AESENC_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESENC_VdqWdqR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_AESENCLAST_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESENCLAST_VdqWdqR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_AESDEC_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESDEC_VdqWdqR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_AESDECLAST_VdqWdq, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESDECLAST_VdqWdqR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_AESKEYGENASSIST_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::AESKEYGENASSIST_VdqWdqIbR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_PCLMULQDQ_VdqWdqIb, &BX_CPU_C::LOAD_Wdq, &BX_CPU_C::PCLMULQDQ_VdqWdqIbR, BX_CPU_AES_PCLMULQDQ, BX_PREPARE_SSE)

#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_ADD_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADD_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_OR_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::OR_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ADC_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADC_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SBB_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SBB_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_AND_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::AND_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SUB_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SUB_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XOR_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::XOR_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMP_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMP_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ADD_EqGq, &BX_CPU_C::ADD_EqGqM, &BX_CPU_C::ADD_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_OR_EqGq, &BX_CPU_C::OR_EqGqM, &BX_CPU_C::OR_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_ADC_EqGq, &BX_CPU_C::ADC_EqGqM, &BX_CPU_C::ADC_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_SBB_EqGq, &BX_CPU_C::SBB_EqGqM, &BX_CPU_C::SBB_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_AND_EqGq, &BX_CPU_C::AND_EqGqM, &BX_CPU_C::AND_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_SUB_EqGq, &BX_CPU_C::SUB_EqGqM, &BX_CPU_C::SUB_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_XOR_EqGq, &BX_CPU_C::XOR_EqGqM, &BX_CPU_C::XOR_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_CMP_EqGq, &BX_CPU_C::CMP_EqGqM, &BX_CPU_C::CMP_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_ADD_RAXId, NULL, &BX_CPU_C::ADD_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_OR_RAXId, NULL, &BX_CPU_C::OR_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ADC_RAXId, NULL, &BX_CPU_C::ADC_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SBB_RAXId, NULL, &BX_CPU_C::SBB_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_AND_RAXId, NULL, &BX_CPU_C::AND_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SUB_RAXId, NULL, &BX_CPU_C::SUB_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XOR_RAXId, NULL, &BX_CPU_C::XOR_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMP_RAXId, NULL, &BX_CPU_C::CMP_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ADD_EqId, &BX_CPU_C::ADD_EqIdM, &BX_CPU_C::ADD_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_OR_EqId, &BX_CPU_C::OR_EqIdM, &BX_CPU_C::OR_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ADC_EqId, &BX_CPU_C::ADC_EqIdM, &BX_CPU_C::ADC_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SBB_EqId, &BX_CPU_C::SBB_EqIdM, &BX_CPU_C::SBB_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_AND_EqId, &BX_CPU_C::AND_EqIdM, &BX_CPU_C::AND_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SUB_EqId, &BX_CPU_C::SUB_EqIdM, &BX_CPU_C::SUB_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XOR_EqId, &BX_CPU_C::XOR_EqIdM, &BX_CPU_C::XOR_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMP_EqId, &BX_CPU_C::CMP_EqIdM, &BX_CPU_C::CMP_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_TEST_EqGq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_TEST_RAXId, NULL, &BX_CPU_C::TEST_RAXId, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XCHG_EqGq, &BX_CPU_C::XCHG_EqGqM, &BX_CPU_C::XCHG_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LEA_GqM, &BX_CPU_C::LEA_GqM, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV64_GdEd, &BX_CPU_C::MOV64_GdEdM, &BX_CPU_C::MOV_GdEdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV64_EdGd, &BX_CPU_C::MOV64_EdGdM, &BX_CPU_C::MOV_GdEdR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_MOV_RAXOq, NULL, &BX_CPU_C::MOV_RAXOq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_OqRAX, NULL, &BX_CPU_C::MOV_OqRAX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_EAXOq, NULL, &BX_CPU_C::MOV_EAXOq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_OqEAX, NULL, &BX_CPU_C::MOV_OqEAX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_AXOq, NULL, &BX_CPU_C::MOV_AXOq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_OqAX, NULL, &BX_CPU_C::MOV_OqAX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_ALOq, NULL, &BX_CPU_C::MOV_ALOq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_OqAL, NULL, &BX_CPU_C::MOV_OqAL, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_EqGq, &BX_CPU_C::MOV_EqGqM, &BX_CPU_C::MOV_GqEqR, BX_CPU_X86_64, 0) /* dstRM */
bx_define_opcode(BX_IA_MOV_GqEq, &BX_CPU_C::MOV_GqEqM, &BX_CPU_C::MOV_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_EqId, &BX_CPU_C::MOV_EqIdM, &BX_CPU_C::MOV_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_REP_MOVSQ_XqYq, NULL, &BX_CPU_C::REP_MOVSQ_XqYq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_REP_CMPSQ_XqYq, NULL, &BX_CPU_C::REP_CMPSQ_XqYq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_REP_STOSQ_YqRAX, NULL, &BX_CPU_C::REP_STOSQ_YqRAX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_REP_LODSQ_RAXXq, NULL, &BX_CPU_C::REP_LODSQ_RAXXq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_REP_SCASQ_RAXXq, NULL, &BX_CPU_C::REP_SCASQ_RAXXq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CALL_Jq, NULL, &BX_CPU_C::CALL_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JMP_Jq, NULL, &BX_CPU_C::JMP_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JO_Jq, NULL, &BX_CPU_C::JO_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNO_Jq, NULL, &BX_CPU_C::JNO_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JB_Jq, NULL, &BX_CPU_C::JB_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNB_Jq, NULL, &BX_CPU_C::JNB_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JZ_Jq, NULL, &BX_CPU_C::JZ_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNZ_Jq, NULL, &BX_CPU_C::JNZ_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JBE_Jq, NULL, &BX_CPU_C::JBE_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNBE_Jq, NULL, &BX_CPU_C::JNBE_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JS_Jq, NULL, &BX_CPU_C::JS_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNS_Jq, NULL, &BX_CPU_C::JNS_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JP_Jq, NULL, &BX_CPU_C::JP_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNP_Jq, NULL, &BX_CPU_C::JNP_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JL_Jq, NULL, &BX_CPU_C::JL_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNL_Jq, NULL, &BX_CPU_C::JNL_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JLE_Jq, NULL, &BX_CPU_C::JLE_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JNLE_Jq, NULL, &BX_CPU_C::JNLE_Jq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ENTER64_IwIb, NULL, &BX_CPU_C::ENTER64_IwIb, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LEAVE64, NULL, &BX_CPU_C::LEAVE64, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_IRET64, NULL, &BX_CPU_C::IRET64, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SHLD_EqGq, &BX_CPU_C::SHLD_EqGqM, &BX_CPU_C::SHLD_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SHRD_EqGq, &BX_CPU_C::SHRD_EqGqM, &BX_CPU_C::SHRD_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_IMUL_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_IMUL_GqEqId, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVZX_GqEb, &BX_CPU_C::MOVZX_GqEbM, &BX_CPU_C::MOVZX_GqEbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVZX_GqEw, &BX_CPU_C::MOVZX_GqEwM, &BX_CPU_C::MOVZX_GqEwR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVSX_GqEb, &BX_CPU_C::MOVSX_GqEbM, &BX_CPU_C::MOVSX_GqEbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVSX_GqEw, &BX_CPU_C::MOVSX_GqEwM, &BX_CPU_C::MOVSX_GqEwR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVSX_GqEd, &BX_CPU_C::MOVSX_GqEdM, &BX_CPU_C::MOVSX_GqEdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BSWAP_RRX, NULL, &BX_CPU_C::BSWAP_RRX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BSF_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSF_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BSR_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSR_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BT_EqGq, &BX_CPU_C::BT_EqGqM, &BX_CPU_C::BT_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTS_EqGq, &BX_CPU_C::BTS_EqGqM, &BX_CPU_C::BTS_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTR_EqGq, &BX_CPU_C::BTR_EqGqM, &BX_CPU_C::BTR_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTC_EqGq, &BX_CPU_C::BTC_EqGqM, &BX_CPU_C::BTC_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BT_EqIb, &BX_CPU_C::BT_EqIbM, &BX_CPU_C::BT_EqIbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTS_EqIb, &BX_CPU_C::BTS_EqIbM, &BX_CPU_C::BTS_EqIbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTR_EqIb, &BX_CPU_C::BTR_EqIbM, &BX_CPU_C::BTR_EqIbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_BTC_EqIb, &BX_CPU_C::BTC_EqIbM, &BX_CPU_C::BTC_EqIbR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ROL_Eq, &BX_CPU_C::ROL_EqM, &BX_CPU_C::ROL_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_ROR_Eq, &BX_CPU_C::ROR_EqM, &BX_CPU_C::ROR_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RCL_Eq, &BX_CPU_C::RCL_EqM, &BX_CPU_C::RCL_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RCR_Eq, &BX_CPU_C::RCR_EqM, &BX_CPU_C::RCR_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SHL_Eq, &BX_CPU_C::SHL_EqM, &BX_CPU_C::SHL_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SHR_Eq, &BX_CPU_C::SHR_EqM, &BX_CPU_C::SHR_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SAR_Eq, &BX_CPU_C::SAR_EqM, &BX_CPU_C::SAR_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_TEST_EqId, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqIdR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_NOT_Eq, &BX_CPU_C::NOT_EqM, &BX_CPU_C::NOT_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_NEG_Eq, &BX_CPU_C::NEG_EqM, &BX_CPU_C::NEG_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MUL_RAXEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::MUL_RAXEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_IMUL_RAXEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_RAXEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_DIV_RAXEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::DIV_RAXEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_IDIV_RAXEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IDIV_RAXEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_INC_Eq, &BX_CPU_C::INC_EqM, &BX_CPU_C::INC_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_DEC_Eq, &BX_CPU_C::DEC_EqM, &BX_CPU_C::DEC_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CALL_Eq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CALL_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CALL64_Ep, &BX_CPU_C::CALL64_Ep, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JMP_Eq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::JMP_EqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JMP64_Ep, &BX_CPU_C::JMP64_Ep, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSHF_Fq, NULL, &BX_CPU_C::PUSHF_Fq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_POPF_Fq, NULL, &BX_CPU_C::POPF_Fq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMPXCHG_EqGq, &BX_CPU_C::CMPXCHG_EqGqM, &BX_CPU_C::CMPXCHG_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CDQE, NULL, &BX_CPU_C::CDQE, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CQO, NULL, &BX_CPU_C::CQO, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XADD_EqGq, &BX_CPU_C::XADD_EqGqM, &BX_CPU_C::XADD_EqGqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RETnear64_Iw, NULL, &BX_CPU_C::RETnear64_Iw, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RETnear64, NULL, &BX_CPU_C::RETnear64, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RETfar64_Iw, NULL, &BX_CPU_C::RETfar64_Iw, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RETfar64, NULL, &BX_CPU_C::RETfar64_Iw, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVO_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVO_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNO_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNO_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVB_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVB_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNB_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNB_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVZ_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVZ_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNZ_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNZ_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVBE_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVBE_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNBE_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNBE_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVS_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVS_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNS_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNS_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVP_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVP_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNP_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNP_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVL_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVL_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNL_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNL_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVLE_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVLE_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMOVNLE_GqEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNLE_GqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RRXIq, NULL, &BX_CPU_C::MOV_RRXIq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSH_Eq, &BX_CPU_C::PUSH_EqM, &BX_CPU_C::PUSH_RRX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSH_RRX, NULL, &BX_CPU_C::PUSH_RRX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_POP_Eq, &BX_CPU_C::POP_EqM, &BX_CPU_C::POP_RRX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_POP_RRX, NULL, &BX_CPU_C::POP_RRX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_XCHG_RRXRAX, NULL, &BX_CPU_C::XCHG_RRXRAX, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSH64_Id, NULL, &BX_CPU_C::PUSH64_Id, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSH64_FS, NULL, &BX_CPU_C::PUSH64_FS, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_POP64_FS, NULL, &BX_CPU_C::POP64_FS, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_PUSH64_GS, NULL, &BX_CPU_C::PUSH64_GS, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_POP64_GS, NULL, &BX_CPU_C::POP64_GS, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LSS_GqMp, &BX_CPU_C::LSS_GqMp, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LFS_GqMp, &BX_CPU_C::LFS_GqMp, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LGS_GqMp, &BX_CPU_C::LGS_GqMp, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SGDT64_Ms, &BX_CPU_C::SGDT64_Ms, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SIDT64_Ms, &BX_CPU_C::SIDT64_Ms, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LGDT64_Ms, &BX_CPU_C::LGDT64_Ms, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LIDT64_Ms, &BX_CPU_C::LIDT64_Ms, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_CMPXCHG16B, &BX_CPU_C::CMPXCHG16B, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LOOPNE64_Jb, NULL, &BX_CPU_C::LOOPNE64_Jb, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LOOPE64_Jb, NULL, &BX_CPU_C::LOOPE64_Jb, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_LOOP64_Jb, NULL, &BX_CPU_C::LOOP64_Jb, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_JRCXZ_Jb, NULL, &BX_CPU_C::JRCXZ_Jb, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVQ_EqVq, &BX_CPU_C::MOVLPS_MqVps, &BX_CPU_C::MOVQ_EqVqR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVQ_PqEq, &BX_CPU_C::MOVQ_PqQqM, &BX_CPU_C::MOVQ_PqEqR, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOVQ_VdqEq, &BX_CPU_C::MOVQ_VqWqM, &BX_CPU_C::MOVQ_VdqEqR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSI2SS_VssEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CVTSI2SS_VssEqR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEq, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CVTSI2SD_VsdEqR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTSS2SI_GqWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CVTTSS2SI_GqWssR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTTSD2SI_GqWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTTSD2SI_GqWsdR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSS2SI_GqWss, &BX_CPU_C::LOAD_Wss, &BX_CPU_C::CVTSS2SI_GqWssR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_CVTSD2SI_GqWsd, &BX_CPU_C::LOAD_Wsd, &BX_CPU_C::CVTSD2SI_GqWsdR, BX_CPU_X86_64, BX_PREPARE_SSE)
bx_define_opcode(BX_IA_MOVNTI_MqGq, &BX_CPU_C::MOVNTI_MqGq, &BX_CPU_C::BxError, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SYSCALL, NULL, &BX_CPU_C::SYSCALL, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SYSRET, NULL, &BX_CPU_C::SYSRET, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_CR0Rq, NULL, &BX_CPU_C::MOV_CR0Rq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_CR2Rq, NULL, &BX_CPU_C::MOV_CR2Rq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_CR3Rq, NULL, &BX_CPU_C::MOV_CR3Rq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_CR4Rq, NULL, &BX_CPU_C::MOV_CR4Rq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RqCR0, NULL, &BX_CPU_C::MOV_RqCR0, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RqCR2, NULL, &BX_CPU_C::MOV_RqCR2, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RqCR3, NULL, &BX_CPU_C::MOV_RqCR3, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RqCR4, NULL, &BX_CPU_C::MOV_RqCR4, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_DqRq, NULL, &BX_CPU_C::MOV_DqRq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_MOV_RqDq, NULL, &BX_CPU_C::MOV_RqDq, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_SWAPGS, &BX_CPU_C::BxError, &BX_CPU_C::SWAPGS, BX_CPU_X86_64, 0)
bx_define_opcode(BX_IA_RDFSBASE, &BX_CPU_C::BxError, &BX_CPU_C::RDFSBASE, BX_CPU_X86_64 | BX_CPU_FSGSBASE, 0)
bx_define_opcode(BX_IA_RDGSBASE, &BX_CPU_C::BxError, &BX_CPU_C::RDGSBASE, BX_CPU_X86_64 | BX_CPU_FSGSBASE, 0)
bx_define_opcode(BX_IA_WRFSBASE, &BX_CPU_C::BxError, &BX_CPU_C::WRFSBASE, BX_CPU_X86_64 | BX_CPU_FSGSBASE, 0)
bx_define_opcode(BX_IA_WRGSBASE, &BX_CPU_C::BxError, &BX_CPU_C::WRGSBASE, BX_CPU_X86_64 | BX_CPU_FSGSBASE, 0)
#endif

bx_define_opcode(BX_IA_RDTSCP, &BX_CPU_C::BxError, &BX_CPU_C::RDTSCP, BX_CPU_X86_64, 0)

// VMX
bx_define_opcode(BX_IA_VMXON_Mq, &BX_CPU_C::VMXON, &BX_CPU_C::BxError, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMXOFF, &BX_CPU_C::BxError, &BX_CPU_C::VMXOFF, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMCALL, &BX_CPU_C::BxError, &BX_CPU_C::VMCALL, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMLAUNCH, &BX_CPU_C::BxError, &BX_CPU_C::VMLAUNCH, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMRESUME, &BX_CPU_C::BxError, &BX_CPU_C::VMLAUNCH, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMCLEAR_Mq, &BX_CPU_C::VMCLEAR, &BX_CPU_C::BxError, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMPTRLD_Mq, &BX_CPU_C::VMPTRLD, &BX_CPU_C::BxError, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMPTRST_Mq, &BX_CPU_C::VMPTRST, &BX_CPU_C::BxError, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMREAD_EdGd, &BX_CPU_C::VMREAD, &BX_CPU_C::VMREAD, BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMWRITE_GdEd, &BX_CPU_C::VMWRITE, &BX_CPU_C::VMWRITE, BX_CPU_VMX, 0)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_VMREAD_EqGq, &BX_CPU_C::VMREAD, &BX_CPU_C::VMREAD, BX_CPU_X86_64 | BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_VMWRITE_GqEq, &BX_CPU_C::VMWRITE, &BX_CPU_C::VMWRITE, BX_CPU_X86_64 | BX_CPU_VMX, 0)
#endif
bx_define_opcode(BX_IA_INVEPT, &BX_CPU_C::INVEPT, &BX_CPU_C::BxError, BX_CPU_X86_64 | BX_CPU_VMX, 0)
bx_define_opcode(BX_IA_INVVPID, &BX_CPU_C::INVVPID, &BX_CPU_C::BxError, BX_CPU_X86_64 | BX_CPU_VMX, 0)
// VMX
