/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2004-03-09 20:09
 */

#include "bdict.h"
#include "binteger.h"
#include "bstring.h"
#include "blist.h"

int
CBDict::parse (const char *buf, unsigned long bufLen)
{
  int result = -1;

  if (buf[0] != 'd')
    {
      return result;
    }

  unsigned long index = 1;
  int ret = 0;
  for (; index < bufLen;)
    {
      CBString strKey;

      ret = strKey.parse (&buf[index], bufLen - index - 1);
      if (ret > 0)
	{
	  index += ret;
	  if (index < bufLen)
	    {
	      CBObject *value = NULL;
	      if (isdigit (buf[index]))
		{
		  value = new CBString;
		}
	      else if (buf[index] == 'i')
		{
		  value = new CBInteger;
		}
	      else if (buf[index] == 'l')
		{
		  value = new CBList;
		}
	      else if (buf[index] == 'd')
		{
		  value = new CBDict;
		}
	      else
		{
		  break;
		}
	      ret = value->parse (&buf[index], bufLen - index);
	      if (ret > 0)
		{
		  index += ret;
		  m_value[strKey.getValue ()] = value;
		}
	      else
		{
		  delete value;
		  break;
		}
	    }
	}
      else
	{
	  break;
	}
      if (index < bufLen && buf[index] == 'e')
	{
	  result = index + 1;
	  break;
	}
    }
  if (result == -1)
    {
      clear ();
    }

  return result;
};
