# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Tue Feb  1 23:42:12 2005

import BIB
import wx

class Pref_Editor(wx.Panel):
	def __init__(self, *args, **kwds):
		self.bibedit = BIB.EDIT.copy()	# copy to avoid modification before hitting OK
		self.__lastType = None			# previously selected RefType. For self.RefType EVT_CHOICE evt
		# begin wxGlade: Pref_Editor.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.label_1 = wx.StaticText(self, -1, _("Reference type"))
		self.RefType = wx.Choice(self, -1, choices=[])
		self.label_4 = wx.StaticText(self, -1, _("Fields"))
		self.Fields = wx.ListBox(self, -1, choices=[], style=wx.LB_SINGLE)
		self.AddMain = wx.Button(self, -1, _("Add"))
		self.RemoveMain = wx.Button(self, -1, _("Remove"))
		self.UpMain = wx.Button(self, -1, _("Up"))
		self.DownMain = wx.Button(self, -1, _("Down"))
		self.AddSup = wx.Button(self, -1, _("Add"))
		self.RemoveSup = wx.Button(self, -1, _("Remove"))
		self.UpSup = wx.Button(self, -1, _("Up"))
		self.DownSup = wx.Button(self, -1, _("Down"))
		self.label_2 = wx.StaticText(self, -1, _("Main fields (+ Abstract)"))
		self.MainFields = wx.ListBox(self, -1, choices=[], style=wx.LB_SINGLE)
		self.label_3 = wx.StaticText(self, -1, _("Supplementary fields"))
		self.SupplFields = wx.ListBox(self, -1, choices=[], style=wx.LB_SINGLE)

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: Pref_Editor.__set_properties
		self.RefType.SetSelection(0)
		# end wxGlade
		self.RefType.AppendItems([BIB.NAME_TYPE[t] for t in BIB.BIB_TYPE])
		self.RefType.SetSelection(0)
		self.__setFields()						# set the fields according to current settings

	def __do_layout(self):
		# begin wxGlade: Pref_Editor.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_4 = wx.BoxSizer(wx.VERTICAL)
		sizer_3 = wx.BoxSizer(wx.VERTICAL)
		sizer_6 = wx.BoxSizer(wx.VERTICAL)
		sizer_5 = wx.BoxSizer(wx.VERTICAL)
		sizer_2 = wx.BoxSizer(wx.VERTICAL)
		sizer_2.Add(self.label_1, 0, wx.ALL, 2)
		sizer_2.Add(self.RefType, 0, wx.ALL|wx.EXPAND, 2)
		sizer_2.Add(self.label_4, 0, wx.ALL, 2)
		sizer_2.Add(self.Fields, 1, wx.ALL|wx.EXPAND, 2)
		sizer_1.Add(sizer_2, 1, wx.ALL|wx.EXPAND, 2)
		sizer_5.Add((20, 20), 0, 0, 0)
		sizer_5.Add(self.AddMain, 0, 0, 0)
		sizer_5.Add(self.RemoveMain, 0, 0, 0)
		sizer_5.Add(self.UpMain, 0, 0, 0)
		sizer_5.Add(self.DownMain, 0, 0, 0)
		sizer_3.Add(sizer_5, 1, 0, 0)
		sizer_6.Add((20, 20), 0, 0, 0)
		sizer_6.Add(self.AddSup, 0, 0, 0)
		sizer_6.Add(self.RemoveSup, 0, 0, 0)
		sizer_6.Add(self.UpSup, 0, 0, 0)
		sizer_6.Add(self.DownSup, 0, 0, 0)
		sizer_3.Add(sizer_6, 1, 0, 0)
		sizer_1.Add(sizer_3, 0, wx.ALL|wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 2)
		sizer_4.Add(self.label_2, 0, wx.ALL, 2)
		sizer_4.Add(self.MainFields, 1, wx.EXPAND, 0)
		sizer_4.Add(self.label_3, 0, wx.ALL, 2)
		sizer_4.Add(self.SupplFields, 1, wx.EXPAND, 0)
		sizer_1.Add(sizer_4, 1, wx.ALL|wx.EXPAND, 2)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

	def __set_evt(self):
		wx.EVT_CHOICE(self,self.RefType.GetId(),self.onType)
		wx.EVT_BUTTON(self,self.AddMain.GetId(),self.onAddMain)
		wx.EVT_BUTTON(self,self.RemoveMain.GetId(),self.onRemoveMain)
		wx.EVT_BUTTON(self,self.UpMain.GetId(),self.onUpMain)
		wx.EVT_BUTTON(self,self.DownMain.GetId(),self.onDownMain)
		wx.EVT_BUTTON(self,self.AddSup.GetId(),self.onAddSup)
		wx.EVT_BUTTON(self,self.RemoveSup.GetId(),self.onRemoveSup)
		wx.EVT_BUTTON(self,self.UpSup.GetId(),self.onUpSup)
		wx.EVT_BUTTON(self,self.DownSup.GetId(),self.onDownSup)

	def onType(self,event):
		self.__saveChoice(self.__lastType)
		self.__setFields()
		self.__lastType = event.GetString()

	def __saveChoice(self,typeRef):
		if typeRef:
			tmp1,tmp2 = [],[]
			for item in xrange(self.MainFields.GetCount()):
				tmp1.append(BIB.FIELD_NAME[self.MainFields.GetString(item)])
			for item in xrange(self.SupplFields.GetCount()):
				tmp2.append(BIB.FIELD_NAME[self.SupplFields.GetString(item)])
			self.bibedit[typeRef] = tuple(tmp1) , tuple(tmp2)

	def __setFields(self):
		reftype = BIB.TYPE_NAME[self.RefType.GetStringSelection()]	# current ref type
		# setting Main fields
		self.MainFields.Clear()
		self.MainFields.InsertItems([BIB.NAME_FIELD[field] for field in self.bibedit[reftype][0]],0)
		# setting Supplementary fields
		self.SupplFields.Clear()
		self.SupplFields.InsertItems([BIB.NAME_FIELD[field] for field in self.bibedit[reftype][1]],0)
		# setting possible fields
		self.Fields.Clear()
		for field in BIB.BIB_FIELDS[3:-1]:
			tmpfield = BIB.NAME_FIELD[field]
			if tmpfield not in self.MainFields.GetStrings() and tmpfield not in self.SupplFields.GetStrings():
				self.Fields.Append(tmpfield)

	def onAddMain(self,event):
		item = self.Fields.GetSelection()
		if item != -1:
			self.MainFields.Append(self.Fields.GetString(item))
			self.Fields.Delete(item)
			self.MainFields.SetSelection(self.MainFields.GetCount() -1)

	def onRemoveMain(self,event):
		item = self.MainFields.GetSelection()
		if item != -1:
			self.Fields.Append(self.MainFields.GetString(item))
			self.MainFields.Delete(item)

	def onUpMain(self,event):
		item = self.MainFields.GetSelection()
		if item > 0:
			self.MainFields.InsertItems((self.MainFields.GetString(item),),item-1)
			self.MainFields.Delete(item+1)
			self.MainFields.SetSelection(item-1)

	def onDownMain(self,event):
		item = self.MainFields.GetSelection()
		if item != -1 and item+1 < self.MainFields.GetCount():
			self.MainFields.InsertItems((self.MainFields.GetString(item),),item+2)
			self.MainFields.Delete(item)
			self.MainFields.SetSelection(item+1)

	def onAddSup(self,event):
		item = self.Fields.GetSelection()
		if item != -1:
			self.SupplFields.Append(self.Fields.GetString(item))
			self.Fields.Delete(item)
			self.SupplFields.SetSelection(self.SupplFields.GetCount() -1)

	def onRemoveSup(self,event):
		item = self.SupplFields.GetSelection()
		if item != -1:
			self.Fields.Append(self.SupplFields.GetString(item))
			self.SupplFields.Delete(item)

	def onUpSup(self,event):
		item = self.SupplFields.GetSelection()
		if item > 0:
			self.SupplFields.InsertItems((self.SupplFields.GetString(item),),item-1)
			self.SupplFields.Delete(item+1)
			self.SupplFields.SetSelection(item-1)

	def onDownSup(self,event):
		item = self.SupplFields.GetSelection()
		if item != -1 and item+1 < self.SupplFields.GetCount():
			self.SupplFields.InsertItems((self.SupplFields.GetString(item),),item+2)
			self.SupplFields.Delete(item)
			self.SupplFields.SetSelection(item+1)

	def getSettings(self):
		"""Return the Printing settings"""
		self.__saveChoice(BIB.TYPE_NAME[self.RefType.GetStringSelection()])				# saving last modifications
		return self.bibedit

# end of class Pref_Editor


