//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_39.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot39(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[39] = {1.571613618132672e-02,1.414830048914107e-01,3.932186023483968e-01,7.713284360788133e-01,1.276425274368880e+00,
    1.909334663596226e+00,2.671102470876819e+00,3.563004621230473e+00,4.586559253495662e+00,5.743541583945743e+00,7.036001844270942e+00,8.466286755550328e+00,
    1.003706511763564e+01,1.175135824147279e+01,1.361257614040442e+01,1.562456063930049e+01,1.779163687673834e+01,2.011867509257462e+01,2.261116514995490e+01,
    2.527530699343292e+01,2.811812127646630e+01,3.114758582669629e+01,3.437280564655622e+01,3.780422706716250e+01,4.145391095997715e+01,4.533588634146724e+01,
    4.946661559282549e+01,5.386561814392992e+01,5.855632496290653e+01,6.356727931650277e+01,6.893387537141712e+01,7.470096740337739e+01,8.092696055954460e+01,
    8.769058409016425e+01,9.510292101724212e+01,1.033308766544542e+02,1.126494824260676e+02,1.235852735955694e+02,1.374943368493242e+02};
  constexpr double aw[39] = {2.468265921334473e-01,2.177439564163269e-01,1.694210883381108e-01,1.162201191647133e-01,7.024633469707303e-02,
    3.737996430587537e-02,1.749348862159024e-02,7.190957220422882e-03,2.592482535680938e-03,8.182750269406580e-04,2.256597998205592e-04,5.424629880485159e-05,
    1.133699839583300e-05,2.053702858231855e-06,3.213816725399362e-07,4.328082092479813e-08,4.994592938548768e-09,4.915189598223187e-10,4.102565151657011e-11,
    2.886560496200262e-12,1.700195781355176e-13,8.317318967561869e-15,3.349071221434938e-16,1.098597343564958e-17,2.901028854938575e-19,6.082053819583228e-21,
    9.960470558573057e-23,1.249924853737202e-24,1.174462960833294e-26,8.034302891078219e-29,3.864581126624081e-31,1.250783951936298e-33,2.572371299657925e-36,
    3.112600022097255e-39,1.988404448243757e-42,5.702185273062599e-46,5.626705361999555e-50,1.152993559639697e-54,1.363383330001917e-60};
  constexpr double x[14976] = {  7.906207866116642e-04, -5.001977095024906e-06,  2.372482193912555e-08, -9.997423106688797e-11,  3.946911952915268e-13,
 -1.494711622151156e-15,  5.498194393820276e-18, -1.979103784541229e-20,  7.004136760497501e-23, -2.444907324972677e-25,  8.436357780060230e-28, -2.882189422526145e-30,
  7.108273578077450e-03, -4.483119185489703e-05,  2.113078987004109e-07, -8.811173828215605e-10,  3.423715477828093e-12, -1.267697533742008e-14,  4.522891822681700e-17,
 -1.563939004178349e-19,  5.255634346707775e-22, -1.717656859797187e-24,  5.453590013383143e-27, -1.677074192500893e-29,  1.970461827978645e-02, -1.234994030651169e-04,
  5.747950362330295e-07, -2.346071296226884e-09,  8.820606524667294e-12, -3.112764074432560e-14,  1.037438514132986e-16, -3.259829492353926e-19,  9.561406042727866e-22,
 -2.556435293091026e-24,  5.877141301112152e-27, -9.498413080606580e-30,  3.850194641698646e-02, -2.390500208537054e-04,  1.091478020211617e-06, -4.310214545927412e-09,
  1.537524684359194e-11, -5.002932045884163e-14,  1.469320458928067e-16, -3.744744678104000e-19,  7.303191960229051e-22, -4.292223008597300e-25, -5.439457541821307e-27,
  3.876409862333350e-29,  6.338422795015733e-02, -3.886072465074555e-04,  1.728884389546851e-06, -6.520743328415369e-09,  2.153536892993026e-11, -6.144670877733727e-14,
  1.405362207639973e-16, -1.801221458603248e-19, -4.661877759557982e-22,  4.846890490526790e-24, -2.404054581234728e-26,  8.955544129191169e-29,  9.419774893964172e-02,
 -5.684454991384528e-04,  2.446589895450081e-06, -8.682973340407102e-09,  2.567545470441957e-11, -5.846937631641773e-14,  6.409840327097302e-17,  2.713610792796474e-19,
 -2.303833595668543e-21,  1.029623793202961e-23, -3.284419102982132e-26,  6.695293233338964e-29,  1.307519591586792e-01, -7.740795519905517e-04,  3.198481303749188e-06,
 -1.049125660684393e-08,  2.638517332108734e-11, -3.720360027267503e-14, -7.890301955320472e-17,  8.550389133081020e-19, -3.841985730425494e-21,  1.116861317670763e-23,
 -1.466733577278861e-26, -6.335798256062744e-29,  1.728205273501098e-01, -1.000373350131414e-03,  3.935347755115042e-06, -1.166146469798460e-08,  2.273123370318100e-11,
  1.871134170953352e-15, -2.584006886349007e-16,  1.337147783261249e-18, -3.952601173856276e-21,  4.130729902090765e-24,  3.059826941194898e-26, -2.293026294434432e-28,
  2.201426011590890e-01, -1.241665044816363e-03,  4.607660483645943e-06, -1.196181146234855e-08,  1.445000971918253e-11,  5.353142641318357e-14, -4.239926712333541e-16,
  1.460798819028545e-18, -1.948614760028285e-21, -9.706876175498580e-24,  7.853856533498168e-26, -2.785092594229924e-28,  2.724242680558169e-01, -1.491905389730161e-03,
  5.168389493205393e-06, -1.123891974267583e-08,  2.038384982794769e-12,  1.085593823540714e-13, -5.187422544152690e-16,  1.055845596937379e-18,  1.904914782382158e-21,
 -2.410840988098234e-23,  9.162810172999718e-26, -9.856759772364681e-29,  3.293402127799313e-01, -1.744806309121645e-03,  5.575702473162994e-06, -9.436468643568506e-09,
 -1.327447894288144e-11,  1.554944968856356e-13, -4.966852961789447e-16,  1.288362850723122e-19,  6.295544771802067e-21, -3.033440175012392e-23,  4.496983675706142e-26,
  2.581710774903507e-28,  3.905355659846679e-01, -1.993996175543644e-03,  5.795396094906458e-06, -6.604453623734930e-09, -2.967355910674278e-11,  1.830375771518000e-13,
 -3.388082983874018e-16, -1.106779742448397e-18,  9.300205763172850e-21, -2.200873510351402e-23, -5.059807314062191e-26,  5.624408533343309e-28,  4.556279378287251e-01,
 -2.233178132831705e-03,  5.802922760594110e-06, -2.897988392611508e-09, -4.500327801879087e-11,  1.825949104903885e-13, -6.240654312577050e-17, -2.279313017232167e-18,
  9.209259368956476e-21,  4.337524941644083e-25, -1.463520096037997e-25,  5.503024561060862e-28,  5.242096292535553e-01, -2.456287674589879e-03,  5.584896359143431e-06,
  1.434407551884807e-09, -5.707659176792440e-11,  1.503985918758091e-13,  2.795591276843688e-16, -2.975618802499319e-18,  5.379856521236343e-21,  2.852850642683673e-23,
 -1.804879123354357e-25,  1.331363938351741e-28,  5.958500125925041e-01, -2.657645645242956e-03,  5.139987704149833e-06,  6.072054812671439e-09, -6.400199562647775e-11,
  8.871043904748314e-14,  6.096679486352407e-16, -2.887515484233424e-18, -1.294309658180469e-21,  4.903503872720510e-23, -1.171895123728412e-25, -4.878060459339961e-28,
  6.700980719874362e-01, -2.832102873835277e-03,  4.479152795643084e-06,  1.065095347282570e-08, -6.447864904331500e-11,  5.800108860918482e-15,  8.452394763047601e-16,
 -1.934743935413826e-18, -8.566415189185453e-21,  5.040674855724402e-23,  2.492059711620909e-26, -9.155479371086927e-28,  7.464850928428205e-01, -2.975172782876420e-03,
  3.625173250825700e-06,  1.479749047264462e-08, -5.801347207086007e-11, -8.535421586662522e-14,  9.204489961240856e-16, -3.163695958674038e-19, -1.365606762047102e-20,
  2.919469175557169e-23,  1.759411756500052e-25, -8.208427102524500e-28,  8.245274882345500e-01, -3.083148536581499e-03,  2.611526321631712e-06,  1.816375847948503e-08,
 -4.502492194642358e-11, -1.694165542958498e-13,  8.051606283919060e-16,  1.533722962911862e-18, -1.438684346871051e-20, -7.204283288271157e-24,  2.514529886322842e-25,
 -1.937712032308974e-28,  9.037297488223777e-01, -3.153201603784497e-03,  1.480639822866932e-06,  2.046101175507624e-08, -2.681472452940855e-11, -2.316324770486787e-13,
  5.149454043848003e-16,  3.077239812575374e-18, -1.015163545068927e-20, -4.331061038289199e-23,  2.024975692558139e-25,  6.110226577792509e-28,  9.835875014057879e-01,
 -3.183459007391259e-03,  2.816229283343878e-07,  2.148790887999907e-08, -5.408688533965733e-12, -2.607519539997116e-13,  1.090698877767869e-16,  3.845452801959140e-18,
 -2.262729110113884e-21, -6.276803855027319e-23,  4.778545022455748e-26,  1.090568116873566e-27,  1.063590659832146e+00, -3.173057008905393e-03, -9.324049096348458e-07,
  2.115065505670666e-08,  1.671213146432232e-11, -2.513169584728671e-13, -3.234151293612582e-16,  3.596486167834700e-18,  6.500626715158700e-21, -5.641081237964969e-23,
 -1.335493169359737e-25,  9.316753214790511e-28,  1.143226650535584e+00, -3.122169525253126e-03, -2.107239603223835e-06,  1.947292016310458e-08,  3.695136900219225e-11,
 -2.048168321566702e-13, -6.859429139276827e-16,  2.399540317941566e-18,  1.298026130199676e-20, -2.696145311753674e-23, -2.461038004305278e-25,  2.306264765440511e-28,
  1.221983693581396e+00, -3.032010185279620e-03, -3.190608128620899e-06,  1.659440322727212e-08,  5.295816332468382e-11, -1.294481543903690e-13, -8.990385552617630e-16,
  6.146452664879675e-19,  1.490539374492110e-20,  1.220213472716731e-23, -2.330253396319921e-25, -5.683719615815603e-28,  1.299354118743107e+00, -2.904807591835118e-03,
 -4.135101690747726e-06,  1.275804417124034e-08,  6.295458997550544e-11, -3.851245381276671e-14, -9.204710292935003e-16, -1.226219573213555e-18,  1.179082108372337e-20,
  4.364072259677366e-23, -1.078728600060040e-25, -9.754041272837912e-28,  1.374837694880123e+00, -2.743754046921064e-03, -4.900855542836855e-06,  8.287037083364702e-09,
  6.597980226921276e-11,  5.222009373598260e-14, -7.553440091370432e-16, -2.595050919093009e-18,  5.079416828759035e-21,  5.436620772335855e-23,  5.583663021406831e-26,
 -7.807256448438891e-28,  1.447944949747432e+00, -2.552928704445830e-03, -5.457816501776335e-06,  3.553857390166115e-09,  6.201327893993101e-11,  1.276257858883311e-13,
 -4.533625487441819e-16, -3.138481196999945e-18, -2.521722423249490e-21,  4.182643752460996e-23,  1.699609331073704e-25, -1.731570936931393e-28,  1.518200456391209e+00,
 -2.337196818560245e-03, -5.787460728746631e-06, -1.055634321447832e-09,  5.195801624794696e-11,  1.761591177402935e-13, -9.418863656282583e-17, -2.783197942697173e-18,
 -8.202575218233231e-21,  1.435345771061965e-23,  1.828237999685882e-25,  4.217942091794049e-28,  1.585146061502075e+00, -2.102087434905240e-03, -5.883854551257807e-06,
 -5.179400595891454e-09,  3.748626732908914e-11,  1.919780923649556e-13,  2.347805312927301e-16, -1.740814333413156e-18, -1.018561707445875e-20, -1.387453314734546e-23,
  1.045777727890509e-25,  6.497810429865462e-28,  1.648344030547530e+00, -1.853652506404431e-03, -5.753988412262838e-06, -8.513954786056087e-09,  2.077207956845674e-11,
  1.758188328311987e-13,  4.617407621429107e-16, -4.145014647042750e-19, -8.342154937309072e-21, -3.036824730691179e-23, -6.611527227025548e-27,  4.506546293771511e-28,
  1.707380084222784e+00, -1.598310983571724e-03, -5.417356364677690e-06, -1.084302876115627e-08,  4.152905791568212e-12,  1.344545762648048e-13,  5.482426367845834e-16,
  7.541979047978725e-19, -4.053211776761955e-21, -3.020407091452493e-23, -8.525355696682481e-26,  4.825738080290204e-29,  1.761866300780633e+00, -1.342681911649700e-03,
 -4.904798410060864e-06, -1.205719574780652e-08, -1.022602979513242e-11,  7.889125846052723e-14,  4.965105042606448e-16,  1.439253436814373e-18,  5.644028775227482e-22,
 -1.729192460033918e-23, -9.780085801798247e-26, -2.546998542891773e-28,  1.811443859167048e+00, -1.093410944884966e-03, -4.256667681087832e-06, -1.216238351059308e-08,
 -2.072811802199959e-11,  2.173410275606817e-14,  3.446848523638640e-16,  1.528122704945456e-18,  3.662195856880175e-21, -8.658402821461284e-25, -5.608599267212314e-26,
 -2.991245698724011e-28,  1.855785598662647e+00, -8.569949458951255e-04, -3.520426178740947e-06, -1.127636642371945e-08, -2.645238234800674e-11, -2.565868710796567e-14,
  1.520374714130097e-16,  1.131510830826196e-18,  4.412665602528571e-21,  1.029759448022473e-23, -2.224643723712840e-28, -1.439941574074988e-28,  1.894598372061640e+00,
 -6.396094621461550e-04, -2.747808787249301e-06, -9.613591267581235e-09, -2.733563335655935e-11, -5.558069702633256e-14, -2.081311677785366e-17,  5.085867075486875e-19,
  3.187929842361689e-21,  1.241314429806499e-23,  3.294427434961990e-26,  3.428912601933742e-29,  1.927625171818480e+00, -4.469438505002810e-04, -1.991723173095662e-06,
 -7.459935182443142e-09, -2.411481989450248e-11, -6.540057923997787e-14, -1.303105375397725e-16, -5.568356325528541e-20,  1.147549100248113e-21,  7.584176773026092e-24,
  3.235038371001963e-26,  1.047459621776626e-28,  1.954647014265878e+00, -2.840486367522764e-04, -1.303070913882046e-06, -5.140078847548972e-09, -1.815775286558704e-11,
 -5.770443026657231e-14, -1.613074946256119e-16, -3.676637395469231e-19, -4.882961272102421e-22,  1.116726042016319e-24,  1.258430392555556e-26,  6.582526883321937e-29,
  1.975484588387397e+00, -1.551992715667145e-04, -7.276810851197874e-07, -2.980980947920909e-09, -1.119220257058097e-11, -3.916742797622243e-14, -1.281461504241523e-16,
 -3.890423072731414e-19, -1.071797041243644e-21, -2.530832658055504e-24, -4.205164550664664e-27,  1.576175290385998e-30,  1.989999815051732e+00, -6.377912724878161e-05,
 -3.035377972329017e-07, -1.275355835609432e-09, -4.980168987010129e-12, -1.846927704219696e-14, -6.572046225931667e-17, -2.254283059913876e-19, -7.462129451508959e-22,
 -2.379545105259884e-24, -7.272845030750592e-27, -2.109285375998200e-29,  1.998099413537077e+00, -1.217152289013086e-05, -5.840575499306155e-08, -2.488095380290827e-10,
 -9.921195149682507e-13, -3.790575711347274e-15, -1.404880901634835e-17, -5.087394108670260e-20, -1.808127119789013e-22, -6.325788067256634e-25, -2.182722474147003e-27,
 -7.437618278538489e-30,  7.709850259646041e-04, -4.816872152896208e-06,  2.256205773171516e-08, -9.389134011226191e-11,  3.660729186796004e-13, -1.369159381712949e-15,
  4.974145719508767e-18, -1.768426791932376e-20,  6.181776820625314e-23, -2.131496113002985e-25,  7.265506260181796e-28, -2.452173475233092e-30,  6.932264061891891e-03,
 -4.318210994213776e-05,  2.010549870482733e-07, -8.283087281170295e-10,  3.180685794728902e-12, -1.164218487901901e-14,  4.107633748257755e-17, -1.405245415531032e-19,
  4.674827370172798e-22, -1.513595139746277e-24,  4.765640606593613e-27, -1.455332267328173e-29,  1.921964241250898e-02, -1.190113014427512e-04,  5.474688445437380e-07,
 -2.209789774597326e-09,  8.222230418132888e-12, -2.874394461233976e-14,  9.503116312821744e-17, -2.968144050048234e-19,  8.682394081254056e-22, -2.329742162240751e-24,
  5.457185655817745e-27, -9.545193191461070e-30,  3.756288821097228e-02, -2.305209797403411e-04,  1.041199061020048e-06, -4.072027205997751e-09,  1.440908839974460e-11,
 -4.662614964350681e-14,  1.367713400499407e-16, -3.513902895442020e-19,  7.113395283922542e-22, -6.151156552331261e-25, -3.912421454577219e-27,  3.090448353408784e-29,
  6.185697368579904e-02, -3.750834016674996e-04,  1.652662899066375e-06, -6.185827382799007e-09,  2.033974687882819e-11, -5.813589147658534e-14,  1.353089003133060e-16,
 -1.924264472858237e-19, -3.080920202864738e-22,  3.960497881256566e-24, -2.036540408901995e-26,  7.770369842431008e-29,  9.196246221834220e-02, -5.492826672896906e-04,
  2.344820746687348e-06, -8.281435143251547e-09,  2.452202460858289e-11, -5.684783440587422e-14,  7.071834496206497e-17,  2.033212521164955e-19, -1.956105584219358e-21,
  9.041499080112176e-24, -2.989399924918595e-26,  6.679348799000177e-29,  1.277060293726315e-01, -7.489881622890683e-04,  3.075094335093239e-06, -1.007514140454435e-08,
  2.562403358153068e-11, -3.882350494935830e-14, -5.662353161973307e-17,  7.384102734082104e-19, -3.451077453750622e-21,  1.053382605737546e-23, -1.689311764844618e-26,
 -3.877940899098583e-29,  1.688811219722106e-01, -9.694441347833156e-04,  3.797592554805656e-06, -1.129779005741904e-08,  2.270959961858862e-11, -3.895347932324557e-15,
 -2.227073871551638e-16,  1.213261048230248e-18, -3.784186761133494e-21,  5.164776484840632e-24,  2.139107954663072e-26, -1.898999451943492e-28,  2.152487601015301e-01,
 -1.205373919650528e-03,  4.465539524511718e-06, -1.172258538895011e-08,  1.542215538922622e-11,  4.383908271557042e-14, -3.840116319159094e-16,  1.393434636950088e-18,
 -2.244421349069541e-21, -6.805243109627492e-24,  6.668010090716236e-26, -2.597336328978208e-28,  2.665384875657054e-01, -1.451097026825603e-03,  5.033787627017767e-06,
 -1.118960235612164e-08,  4.087501434019730e-12,  9.647044366499618e-14, -4.884506600708412e-16,  1.103614593839022e-18,  1.101831061735108e-21, -2.054167990021565e-23,
  8.644579701966518e-26, -1.346612081566440e-28,  3.224494768203182e-01, -1.700657018338079e-03,  5.461291032140182e-06, -9.624627241491163e-09, -1.028338785940891e-11,
  1.436391073482663e-13, -4.904190499030959e-16,  3.131889036037956e-19,  5.238382145918612e-21, -2.833460771680283e-23,  5.439451832759587e-26,  1.723212067933030e-28,
  3.826517946500204e-01, -1.947957816469562e-03,  5.713413336068271e-06, -7.050396304132086e-09, -2.609646108326815e-11,  1.745671846505163e-13, -3.657532615087458e-16,
 -8.221937627502487e-19,  8.477217224533789e-21, -2.356056911509264e-23, -2.756646410709667e-26,  4.838649301302832e-28,  4.467878348983169e-01, -2.186905818171159e-03,
  5.763946776381028e-06, -3.588928133510771e-09, -4.137135484071466e-11,  1.803645801738000e-13, -1.221069919118812e-16, -1.985449171813804e-18,  9.125361816960389e-21,
 -4.933617712000172e-24, -1.219993165724090e-25,  5.527431073451154e-28,  5.144739242987173e-01, -2.411554946152095e-03,  5.596730264350994e-06,  5.455824371681609e-10,
 -5.400817005787717e-11,  1.561285560629202e-13,  1.987965159487382e-16, -2.788410771763814e-18,  6.278662005288013e-21,  2.146076320492196e-23, -1.720930908098106e-25,
  2.438196701566456e-28,  5.853021068983135e-01, -2.616251553653331e-03,  5.206769219181114e-06,  5.062984007113876e-09, -6.208803281043581e-11,  1.023691821582448e-13,
  5.284963628575835e-16, -2.901633019806087e-18,  3.818397417644409e-22,  4.396611348783370e-23, -1.350825739918178e-25, -3.267049341139985e-28,  6.588421116700177e-01,
 -2.795775928012575e-03,  4.600781633751072e-06,  9.621306343294066e-09, -6.416433034613419e-11,  2.540648785830106e-14,  7.875026162696487e-16, -2.179719788754219e-18,
 -6.743299129057937e-21,  5.062449800474623e-23, -1.332658631400058e-26, -8.186782959936908e-28,  7.346435066541814e-01, -2.945477018950411e-03,  3.797121387032743e-06,
  1.385681462311514e-08, -5.950061706779859e-11, -6.341810256312024e-14,  9.056399994047012e-16, -7.352612098977147e-19, -1.248726623831876e-20,  3.549074266461922e-23,
  1.384633240823042e-25, -8.755231870379356e-28,  8.122380413346103e-01, -3.061396963003362e-03,  2.825060654588112e-06,  1.741731667181511e-08, -4.821680562486389e-11,
 -1.496295618428313e-13,  8.416343020698823e-16,  1.071115352467054e-18, -1.446773550350946e-20,  2.625551420385624e-24,  2.386557290531159e-25, -3.835304039888175e-28,
  8.911421769259228e-01, -3.140381997818440e-03,  1.723447126483754e-06,  1.999561507209175e-08, -3.131700361319189e-11, -2.182779266354753e-13,  5.963372223736202e-16,
  2.729052948084639e-18, -1.155907173861852e-20, -3.473165196094875e-23,  2.249708340032744e-25,  4.080698414877826e-28,  9.708598018260526e-01, -3.180176470739494e-03,
  5.387870648321794e-07,  2.135982821286449e-08, -1.058888044443675e-11, -2.568524590010822e-13,  2.153923318039857e-16,  3.737352828444880e-18, -4.476566882223704e-21,
 -5.991498442428701e-23,  9.433446975920351e-26,  1.017489631068219e-27,  1.050885126678331e+00, -3.179496855610124e-03, -6.771598251151863e-07,  2.137745135052767e-08,
  1.161644288770851e-11, -2.578489072418858e-13, -2.201134063286264e-16,  3.771065004032106e-18,  4.383896632099957e-21, -6.089669464243570e-23, -8.992515079459290e-26,
  1.044102319658186e-27,  1.130705750314547e+00, -3.138083008154813e-03, -1.870155241951209e-06,  2.003050058035444e-08,  3.269608674091969e-11, -2.204272441279903e-13,
 -6.130999547270012e-16,  2.797502717915994e-18,  1.183549410901546e-20, -3.653742945784069e-23, -2.310880491930043e-25,  4.510686844006679e-28,  1.209805884351831e+00,
 -3.056724318678098e-03, -2.986480521202709e-06,  1.741985661515418e-08,  5.015510503549462e-11, -1.507643205869336e-13, -8.750979284199997e-16,  1.096801299368941e-18,
  1.517130582411185e-20,  2.429846769027705e-24, -2.543143776784882e-25, -3.934614245452285e-28,  1.287669720447564e+00, -2.937258961984344e-03, -3.975990856354272e-06,
  1.375794443575166e-08,  6.196087317811028e-11, -6.097171287099859e-14, -9.492931294558590e-16, -8.246929535318693e-19,  1.327388136194740e-20,  3.846873406127544e-23,
 -1.506139688439815e-25, -9.598742478224581e-28,  1.363784920251256e+00, -2.782545094123502e-03, -4.795045828786026e-06,  9.350059814941556e-09,  6.683713865514426e-11,
  3.324008971772028e-14, -8.254329545155768e-16, -2.400833289917543e-18,  7.068143278914667e-21,  5.587109049050772e-23,  1.841297581640746e-26, -9.171139827850365e-28,
  1.437646204022623e+00, -2.596403593692074e-03, -5.409134702294113e-06,  4.565868770064746e-09,  6.444982851824405e-11,  1.156828742891685e-13, -5.421341355624339e-16,
 -3.193790082903084e-18, -8.958916693766978e-22,  4.842208335865757e-23,  1.585422211826632e-25, -3.486838243971207e-28,  1.508759009820833e+00, -2.383532775427025e-03,
 -5.795024577546070e-06, -1.962704476785178e-10,  5.545212995999025e-11,  1.729343042293661e-13, -1.757049857723790e-16, -3.035966474535552e-18, -7.549963308973021e-21,
  2.201313063616154e-23,  1.994945362271086e-25,  3.304125994390310e-28,  1.576643191237042e+00, -2.149396392568420e-03, -5.942281026380504e-06, -4.548614910838889e-09,
  4.137803613932771e-11,  1.969906490488855e-13,  1.814055680310912e-16, -2.073881815247910e-18, -1.060280420488557e-20, -9.107839740237251e-24,  1.340116365648231e-25,
  6.846510348037396e-28,  1.640836717980473e+00, -1.900087162391969e-03, -5.854043771351007e-06, -8.152872891462083e-09,  2.439817373036791e-11,  1.867301623982351e-13,
  4.462329525284330e-16, -6.989529514806469e-19, -9.435113455094242e-21, -3.020532035895283e-23,  1.552836243801467e-26,  5.563759260371001e-28,  1.700899340386533e+00,
 -1.642168961229108e-03, -5.546982956103456e-06, -1.075434772470911e-08,  6.975205975341713e-12,  1.478501255193252e-13,  5.673762133234216e-16,  6.064449718669441e-19,
 -5.201215748712261e-21, -3.354805105664861e-23, -8.132637917065585e-26,  1.332722018819807e-28,  1.756416176249280e+00, -1.382501701616889e-03, -5.050412254894289e-06,
 -1.220752844270255e-08, -8.525769871452512e-12,  9.129253786601620e-14,  5.369633599321988e-16,  1.446577398364587e-18, -1.311982782597612e-22, -2.142510136235096e-23,
 -1.087601937866553e-25, -2.412189827791679e-28,  1.807001176451189e+00, -1.128053682761081e-03, -4.404590341766491e-06, -1.249009168800662e-08, -2.020717756158849e-11,
  3.053318600964019e-14,  3.891050262954522e-16,  1.644354799471003e-18,  3.587362042599939e-21, -3.384563958769236e-24, -7.014863476763829e-26, -3.400709260621454e-28,
  1.852300424848913e+00, -8.857068536198723e-04, -3.658298266924715e-06, -1.170350061092498e-08, -2.692641691425203e-11, -2.161330179864622e-14,  1.857522918226468e-16,
  1.278632698546750e-18,  4.781579351392124e-21,  1.014951245973451e-23, -7.503734286276688e-27, -1.882281521371892e-28,  1.891995228031064e+00, -6.620609047513556e-04,
 -2.865832860696814e-06, -1.005987639859743e-08, -2.845102760889769e-11, -5.589737706810579e-14, -5.075487169632640e-18,  6.180074979550112e-19,  3.658853144534439e-21,
  1.375735027862364e-23,  3.416389993864124e-26,  2.024642057326234e-29,  1.925804952498089e+00, -4.632423725200033e-04, -2.083601134070355e-06, -7.856406770506783e-09,
 -2.545420974943482e-11, -6.854233084467809e-14, -1.313126959786269e-16, -1.433454443877739e-20,  1.445013207889726e-21,  8.973747357165948e-24,  3.721203777487061e-26,
  1.162577998273698e-28,  1.953489572848295e+00, -2.947249558516302e-04, -1.366533780253594e-06, -5.440049478628436e-09, -1.935139808552140e-11, -6.170107006821890e-14,
 -1.718140656940986e-16, -3.825429346119253e-19, -4.382999792080894e-22,  1.681933938051551e-24,  1.577701225801479e-26,  7.968717861904190e-29,  1.974851917471528e+00,
 -1.611669122510916e-04, -7.645537100234141e-07, -3.166493854605644e-09, -1.200720894535891e-11, -4.237761476172123e-14, -1.395334273828089e-16, -4.248298487154123e-19,
 -1.165910076466491e-21, -2.696766028334683e-24, -4.067820075615627e-27,  4.831976738239658e-30,  1.989739743060826e+00, -6.627002995365880e-05, -3.193326367920050e-07,
 -1.358081518867990e-09, -5.365852998766987e-12, -2.012509155964843e-14, -7.238004737745783e-17, -2.507357491196286e-19, -8.373442005346729e-22, -2.689850917755614e-24,
 -8.263632027551646e-27, -2.400233326804660e-29,  1.998049773655188e+00, -1.265098752755864e-05, -6.148927539723624e-08, -2.653087583877401e-10, -1.071421596024060e-12,
 -4.145516251511817e-15, -1.555783092969285e-17, -5.704182583044530e-20, -2.052393183199683e-22, -7.268028304020100e-25, -2.538038034944033e-27, -8.750785478866730e-30,
  7.520715324151676e-04, -4.640784943335097e-06,  2.146962156564456e-08, -8.824691704993149e-11,  3.398445439753467e-13, -1.255505160191180e-15,  4.505565812443059e-18,
 -1.582346885112327e-20,  5.464251496318068e-23, -1.861344717216975e-25,  6.268403272604967e-28, -2.090348303154897e-30,  6.762690748935595e-03, -4.161258107280774e-05,
  1.914131142280978e-07, -7.792282494511304e-10,  2.957390235840874e-12, -1.070192767105268e-14,  3.734314622908364e-17, -1.264013511785936e-19,  4.162756052114970e-22,
 -1.335192332005383e-24,  4.168443038736928e-27, -1.263825301759344e-29,  1.875219186495876e-02, -1.147354270484026e-04,  5.217221241900003e-07, -2.082711968575251e-09,
  7.669501732187424e-12, -2.655986279426489e-14,  8.709701809384830e-17, -2.703313653297472e-19,  7.881969870967579e-22, -2.119814264538490e-24,  5.040559955675045e-27,
 -9.360895253222899e-30,  3.665715944401032e-02, -2.223829950154657e-04,  9.936878024682709e-07, -3.848766924948160e-09,  1.350860677826845e-11, -4.345915389331649e-14,
  1.272475625145812e-16, -3.290093962206738e-19,  6.866878625534303e-22, -7.464041432681719e-25, -2.698807607676811e-27,  2.447437728723814e-29,  6.038262025802432e-02,
 -3.621535730075805e-04,  1.580347782979502e-06, -5.869518582877740e-09,  1.920906154366528e-11, -5.495412093311997e-14,  1.298032856449917e-16, -2.001548725049864e-19,
 -1.793826148069934e-22,  3.211049844292124e-24, -1.718424480420326e-26,  6.709692529901175e-29,  8.980222859535976e-02, -5.309150260128508e-04,  2.247760423465030e-06,
 -7.898084374163617e-09,  2.340246614682459e-11, -5.508905881654333e-14,  7.558232511801904e-17,  1.457087179286223e-19, -1.651431077389327e-21,  7.904049377338284e-24,
 -2.699282580079469e-26,  6.483386750123158e-29,  1.247585222833537e-01, -7.248641041160446e-04,  2.956626701448231e-06, -9.671435655523461e-09,  2.483558552540491e-11,
 -3.994649729369309e-14, -3.743806491297057e-17,  6.339098930388019e-19, -3.084378615437999e-21,  9.829983943903457e-24, -1.815931401509137e-26, -1.958816559706884e-29,
  1.650632569922819e-01, -9.395995190078845e-04,  3.664195715005998e-06, -1.093533882330748e-08,  2.258092459347262e-11, -8.846175818687476e-15, -1.904023558292992e-16,
  1.095291422003865e-18, -3.584769432738193e-21,  5.863953546473025e-24,  1.382334401285165e-26, -1.548109072031597e-28,  2.104978281447732e-01, -1.170208029279522e-03,
  4.326376374379698e-06, -1.146930428389403e-08,  1.620989172255126e-11,  3.508267324811185e-14, -3.460342503610941e-16,  1.318186129740582e-18, -2.444096683404687e-21,
 -4.360197050328832e-24,  5.573589642900737e-26, -2.372869495543492e-28,  2.608137914084346e-01, -1.411362572372821e-03,  4.899966435020353e-06, -1.110939343227884e-08,
  5.902202924183631e-12,  8.512176681333233e-14, -4.571623142118328e-16,  1.127696475900545e-18,  4.230721619196459e-22, -1.721002586375504e-23,  7.996842411150009e-26,
 -1.578311599723961e-28,  3.157334942656275e-01, -1.657431255077289e-03,  5.344901039229571e-06, -9.766815386080908e-09, -7.527502020914562e-12,  1.319922964449344e-13,
 -4.794532392321254e-16,  4.649297948185937e-19,  4.259121844074271e-21, -2.602960004941288e-23,  6.032446094848733e-26,  9.935736024446895e-29,  3.749508324922436e-01,
 -1.902595764834225e-03,  5.626416969473442e-06, -7.440493160067583e-09, -2.269460783641777e-11,  1.655427125652432e-13, -3.851056863466935e-16, -5.646662801715816e-19,
  7.614105117693074e-21, -2.426100235556237e-23, -8.038121163615696e-27,  4.038877090930871e-28,  4.381321464889519e-01, -2.140977492490802e-03,  5.717026463335536e-06,
 -4.222189015891433e-09, -3.779770219451712e-11,  1.767997021439426e-13, -1.736445477251688e-16, -1.697173840771943e-18,  8.865738285749922e-21, -9.331301313875187e-24,
 -9.802102403194168e-26,  5.341291993952230e-28,  5.049172732383109e-01, -2.366769367433051e-03,  5.598196282305108e-06, -2.933346126566549e-10, -5.084409169469621e-11,
  1.599861369897151e-13,  1.236406581026688e-16, -2.576438145179222e-18,  6.930171658016448e-21,  1.481797942982127e-23, -1.594427991702116e-25,  3.266742597719776e-28,
  5.749207701468080e-01, -2.574371104670865e-03,  5.261634296768188e-06,  4.086616130202342e-09, -5.992037773985288e-11,  1.140809514639242e-13,  4.476520627493243e-16,
 -2.865157892567880e-18,  1.864310139804525e-21,  3.832061629491647e-23, -1.460943804893517e-25, -1.760475538600611e-28,  6.477333271034779e-01, -2.758525259751088e-03,
  4.710097571142451e-06,  8.599747831116746e-09, -6.347226245727744e-11,  4.355145961696459e-14,  7.237223120907346e-16, -2.366517005102744e-18, -4.938790067127015e-21,
  4.940459772959741e-23, -4.680450311435343e-26, -7.001993175250699e-28,  7.229233826727756e-01, -2.914451193681013e-03,  3.957653051699786e-06,  1.289583101160060e-08,
 -6.055352131078194e-11, -4.197372739223245e-14,  8.796576484352621e-16, -1.113417930576254e-18, -1.111925567953792e-20,  4.025217883913321e-23,  9.951772129310517e-26,
 -8.880495480163448e-28,  8.000389593630655e-01, -3.037973781797339e-03,  3.029344466462204e-06,  1.662301380061584e-08, -5.100524510493225e-11, -1.291226068321519e-13,
  8.651711255431406e-16,  6.114665476602133e-19, -1.420590422519884e-20,  1.178490192865984e-23,  2.181492685964412e-25, -5.430560289293525e-28,  8.786097312987776e-01,
 -3.125643476112489e-03,  1.960246599645671e-06,  1.946042138417445e-08, -3.553347241021614e-11, -2.030917615300944e-13,  6.673968406683612e-16,  2.340925406453944e-18,
 -1.264366978509424e-20, -2.543581020172230e-23,  2.382773041700470e-25,  1.962694056602970e-28,  9.581493353047261e-01, -3.174844171057662e-03,  7.939199545179568e-07,
  2.114962586703420e-08, -1.566585116233802e-11, -2.504454445932806e-13,  3.177141395813871e-16,  3.560405656698590e-18, -6.555078278550822e-21, -5.527781237892678e-23,
  1.366667121403364e-25,  8.998819632387030e-28,  1.038157933326846e+00, -3.183885250489591e-03, -4.196862417070198e-07,  2.152180774326021e-08,  6.415263547962776e-12,
 -2.618507472176863e-13, -1.128935952693361e-16,  3.875670282018781e-18,  2.138156914476179e-21, -6.355187767522691e-23, -4.235150035137518e-26,  1.110284719358679e-27,
  1.118125030223284e+00, -3.152074232835274e-03, -1.626798407788205e-06,  2.051759751282043e-08,  2.814695840063719e-11, -2.341601631135227e-13, -5.296777934641812e-16,
  3.153451571834512e-18,  1.035912030125373e-20, -4.532119736720498e-23, -2.065749963103794e-25,  6.603063068262390e-28,  1.197532546246039e+00, -3.079766604061370e-03,
 -2.772730521695889e-06,  1.819708630560212e-08,  4.693256627248044e-11, -1.713432763315482e-13, -8.375917732517288e-16,  1.581688986033335e-18,  1.507203330416975e-20,
 -8.030178281207522e-24, -2.671807318657291e-25, -1.868137659881512e-28,  1.275858138010316e+00, -2.968389754899588e-03, -3.804991549783034e-06,  1.473831808273340e-08,
  6.051199150044503e-11, -8.398261043280611e-14, -9.662384048058621e-16, -3.790152822959229e-19,  1.454026509490518e-20,  3.161443214093293e-23, -1.916442715653292e-25,
 -8.971191425185050e-28,  1.352578755469177e+00, -2.820438434760613e-03, -4.676410355156954e-06,  1.042367371093345e-08,  6.729853143861097e-11,  1.265043881400539e-14,
 -8.891868383528059e-16, -2.142409873740367e-18,  9.082712392217146e-21,  5.576553827975747e-23, -2.450520208376324e-26, -1.028799511113890e-27,  1.427174415473237e+00,
 -2.639439808162213e-03, -5.348083115964441e-06,  5.614837901216564e-09,  6.662612054502586e-11,  1.015969556913319e-13, -6.316910207400287e-16, -3.193376830993146e-18,
  9.572576549765073e-22,  5.440201130240909e-23,  1.390762651512790e-25, -5.377372327672732e-28,  1.499132165047456e+00, -2.429887048823416e-03, -5.791943104111500e-06,
  7.183746174088475e-10,  5.886162349229256e-11,  1.676707871422239e-13, -2.639641605218735e-16, -3.263319219005978e-18, -6.610660480246800e-21,  3.024917563878138e-23,
  2.113912487817256e-25,  2.045762459141081e-28,  1.567950199761361e+00, -2.197141418607533e-03, -5.992761389369715e-06, -3.854831712537211e-09,  4.535648360127313e-11,
  2.006089541424084e-13,  1.185452482987715e-16, -2.417323830793588e-18, -1.082688833512622e-20, -3.139802658596400e-24,  1.644671145437744e-25,  6.950999061510821e-28,
  1.633142094760049e+00, -1.947303926583553e-03, -5.949410914262019e-06, -7.732050678680980e-09,  2.823810709411382e-11,  1.971697884537705e-13,  4.222730092007685e-16,
 -1.018105188286377e-18, -1.050513639325325e-20, -2.906290426228942e-23,  4.237563779811945e-26,  6.638189340750357e-28,  1.694241098464751e+00, -1.687058906746456e-03,
 -5.675265516417699e-06, -1.061834312996192e-08,  1.006965217755069e-11,  1.616509744798919e-13,  5.818405644675292e-16,  4.200677391734235e-19, -6.465824376197480e-21,
 -3.665467680062580e-23, -7.324959783929721e-26,  2.369786726257255e-28,  1.750804431989441e+00, -1.423493136648583e-03, -5.197658511318852e-06, -1.232862000091011e-08,
 -6.567772657284470e-12,  1.046644908873579e-13,  5.772866931938494e-16,  1.429178216633834e-18, -9.833033360607125e-22, -2.598053912449787e-23, -1.188023173845263e-25,
 -2.124115802487473e-28,  1.802417531333589e+00, -1.163895376462933e-03, -4.556389492254860e-06, -1.280799794027684e-08, -1.949933274841582e-11,  4.043704907089748e-14,
  4.367317476089876e-16,  1.756629347423855e-18,  3.411296257451040e-21, -6.501644860478668e-24, -8.599550201053383e-26, -3.798593712137926e-28,  1.848698164815117e+00,
 -9.155423629868088e-04, -3.801338656423073e-06, -1.213752670089846e-08, -2.731111167928927e-11, -1.670800089208014e-14,  2.237505729904158e-16,  1.437414356702705e-18,
  5.139429849918197e-21,  9.668969442873285e-24, -1.690303673305936e-26, -2.403565944524602e-28,  1.889300355498451e+00, -6.854782653603882e-04, -2.989319573176565e-06,
 -1.052403691169072e-08, -2.956872127313126e-11, -5.579784073651618e-14,  1.394423268856310e-17,  7.432802030314714e-19,  4.178881666638826e-21,  1.513627073678697e-23,
  3.463506958079236e-26,  3.124754562487086e-32,  1.923918038389772e+00, -4.802953179597084e-04, -2.180367412193587e-06, -8.274812169720886e-09, -2.685657561479032e-11,
 -7.169311776229402e-14, -1.310160242863604e-16,  3.737224188943105e-20,  1.796124384758857e-21,  1.056791506394798e-23,  4.257938360133271e-26,  1.276490710474434e-28,
  1.952288387484203e+00, -3.059237073083413e-04, -1.433713566679899e-06, -5.759771734311504e-09, -2.062753040714228e-11, -6.595466648636799e-14, -1.827116141994491e-16,
 -3.954708098120812e-19, -3.655040862810786e-22,  2.387769562633475e-24,  1.963416326241077e-26,  9.608585781080703e-29,  1.974194771612424e+00, -1.674386652136260e-04,
 -8.037328981881704e-07, -3.365575689071930e-09, -1.288923495050639e-11, -4.587346659531126e-14, -1.519658069003748e-16, -4.637232259303460e-19, -1.265860468326068e-21,
 -2.854025610153915e-24, -3.763184905849678e-27,  9.227059523124517e-30,  1.989469448303022e+00, -6.889136968833518e-05, -3.361583318558719e-07, -1.447252007726863e-09,
 -5.786310746460930e-12, -2.194957955324249e-14, -7.979080309556466e-17, -2.791460343058484e-19, -9.403916698436273e-22, -3.042457355090952e-24, -9.390635205640494e-27,
 -2.729061575492823e-29,  1.997998165293303e+00, -1.315593441355526e-05, -6.477864024471523e-08, -2.831356306427768e-10, -1.158199112056068e-12, -4.538837288691627e-15,
 -1.725102690744971e-17, -6.404849523077298e-20, -2.333283786628632e-22, -8.364656773356820e-25, -2.956493519085213e-27, -1.031534221712198e-29,  7.338453278526427e-04,
 -4.473173256042779e-06,  2.044247363215898e-08, -8.300455707636640e-11,  3.157808844405336e-13, -1.152496701805682e-15,  4.086014658846194e-18, -1.417745684970292e-20,
  4.837169176522597e-23, -1.628067986447026e-25,  5.417641644431356e-28, -1.785278636771493e-30,  6.599244927707614e-03, -4.011789066123758e-05,  1.823393759385330e-07,
 -7.335747954597055e-10,  2.752034954243434e-12, -9.846701052641631e-15,  3.398339708814681e-17, -1.138184793661976e-19,  3.710805704914916e-22, -1.179071683063939e-24,
  3.649635660111538e-27, -1.098373258721185e-29,  1.830144231741944e-02, -1.106595737705804e-04,  4.974486842113824e-07, -1.964138467562935e-09,  7.158609084711656e-12,
 -2.455758472057723e-14,  7.986965247193947e-17, -2.462919619972567e-19,  7.154144278237317e-22, -1.926338129845377e-24,  4.635744751005893e-27, -9.018792870503934e-30,
  3.578323906405374e-02, -2.146146240623159e-04,  9.487712716203816e-07, -3.639419838118443e-09,  1.266922964700818e-11, -4.051330200974469e-14,  1.183387592143308e-16,
 -3.074841404628290e-19,  6.581187881479451e-22, -8.344407926771215e-25, -1.741183499723111e-27,  1.923196585644908e-29,  5.895885271463463e-02, -3.497873852110560e-04,
  1.511721903230796e-06, -5.570798909865762e-09,  1.814067504644120e-11, -5.190664055317796e-14,  1.241350507807624e-16, -2.041726116728347e-19, -7.547211880613203e-23,
  2.579871359023874e-24, -1.444319685507279e-26,  5.768831554228570e-29,  8.771394128063439e-02, -5.133057682928725e-04,  2.155194011744834e-06, -7.532359322866554e-09,
  2.231912542296360e-11, -5.323184085195278e-14,  7.896365120079945e-17,  9.721280093191776e-20, -1.385640362449499e-21,  6.880526880831079e-24, -2.420647775396085e-26,
  6.165852941012605e-29,  1.219056463214510e-01, -7.016686251433516e-04,  2.842927182981053e-06, -9.280500707617703e-09,  2.402905187991016e-11, -4.064284830462318e-14,
 -2.101819751109989e-17,  5.407302548523420e-19, -2.743738992169454e-21,  9.090994951867036e-24, -1.868327303735447e-26, -4.903409304358083e-30,  1.613626636133172e-01,
 -9.108047225483124e-04,  3.535132803086530e-06, -1.057569750611838e-08,  2.236072248106903e-11, -1.306057841256234e-14, -1.613077505449414e-16,  9.840503960590632e-19,
 -3.365270158265012e-21,  6.290010226755503e-24,  7.703221778779330e-27, -1.240902869237810e-28,  2.058853526738061e-01, -1.136143085343851e-03,  4.190322599396141e-06,
 -1.120477162885755e-08,  1.683144037724153e-11,  2.721179377349424e-14, -3.102406399381540e-16,  1.237873843133499e-18, -2.563385884304131e-21, -2.332499835491629e-24,
  4.582624405385687e-26, -2.129681988853982e-28,  2.552458987002190e-01, -1.372694360812820e-03,  4.767274604010540e-06, -1.100192408638314e-08,  7.497482477006270e-12,
  7.452975637314236e-14, -4.254860958105401e-16,  1.131925305882047e-18, -1.406264535459692e-22, -1.415457863444509e-23,  7.271243059567426e-26, -1.704299276582656e-28,
  3.091885427528398e-01, -1.615142704793109e-03,  5.227061716844663e-06, -9.866757165718838e-09, -5.001594427163323e-12,  1.206561870911017e-13, -4.646646263901265e-16,
  5.867017676413902e-19,  3.366372213236284e-21, -2.354781375558156e-23,  6.332653425524127e-26,  3.916515725941859e-29,  3.674298982398163e-01, -1.857947497345857e-03,
  5.535059987185952e-06, -7.777627119884908e-09, -1.947732075053108e-11,  1.561371724253143e-13, -3.976367715697457e-16, -3.350179377043402e-19,  6.738993247970097e-21,
 -2.425025009328002e-23,  8.009324223349569e-27,  3.261622148028571e-28,  4.296593738940777e-01, -2.095453959645334e-03,  5.662847527295375e-06, -4.798906315708199e-09,
 -3.430706776250681e-11,  1.720937047753051e-13, -2.172491969228959e-16, -1.419556328420685e-18,  8.464818336017604e-21, -1.279130241409917e-23, -7.523168400313162e-26,
  4.995159378848187e-28,  4.955397254133193e-01, -2.322011462722468e-03,  5.589901281339016e-06, -1.081105141391108e-09, -4.762040711394257e-11,  1.621133386833892e-13,
  5.467669460216841e-17, -2.347339139742340e-18,  7.352455378787179e-21,  8.746180300149719e-24, -1.437369952577141e-25,  3.830288187522555e-28,  5.647077596835048e-01,
 -2.532097994004531e-03,  5.304998444176171e-06,  3.146699637796201e-09, -5.753778029213083e-11,  1.238698833080136e-13,  3.684621272923375e-16, -2.784567815663206e-18,
  3.137173016518008e-21,  3.236290920382373e-23, -1.508081417081300e-25, -4.116133706787847e-29,  6.367752169279610e-01, -2.720448883524932e-03,  4.807232946600706e-06,
  7.592080769602152e-09, -6.243299254469120e-11,  6.010941575418140e-14,  6.555117216285903e-16, -2.496520569039724e-18, -3.201003623641559e-21,  4.695428445443580e-23,
 -7.475250549853031e-26, -5.687047600354347e-28,  7.113298571026881e-01, -2.882187496339763e-03,  4.106565868141333e-06,  1.192139464210802e-08, -6.118460527573236e-11,
 -2.127489495518231e-14,  8.437234005478196e-16, -1.445356764360938e-18, -9.607900992599057e-21,  4.345635296520551e-23,  6.087830421054873e-26, -8.624221708981041e-28,
  7.879367772608764e-01, -3.012955183741347e-03,  3.223842575794687e-06,  1.578740334757576e-08, -5.337893296631850e-11, -1.082039645867688e-13,  8.760034480708992e-16,
  1.653006958531287e-19, -1.363070007708844e-20,  1.999383835032505e-23,  1.913962496990410e-25, -6.667574974558088e-28,  8.661399862873512e-01, -3.109037371131405e-03,
  2.190229280315742e-06,  1.886028288212258e-08, -3.943006281489084e-11, -1.863341859084150e-13,  7.271539236671862e-16,  1.923529611271752e-18, -1.338628466808012e-20,
 -1.579413939047386e-23,  2.422813511845598e-25, -1.292735256502773e-29,  9.454642621973479e-01, -3.167482268310353e-03,  1.046047682777955e-06,  2.085934872199145e-08,
 -2.059056382135181e-11, -2.416495112745316e-13,  4.141776176844263e-16,  3.319933109971024e-18, -8.437525891212571e-21, -4.906242938791450e-23,  1.729730818081962e-25,
  7.449712354464591e-28,  1.025417314940140e+00, -3.186208347485806e-03, -1.609818807534952e-07,  2.158244563553654e-08,  1.159975113175627e-12, -2.632523600157729e-13,
 -3.762650497575691e-18,  3.907254597842356e-18, -1.683472194535651e-22, -6.426048548908025e-23,  7.037011317666277e-27,  1.126183771577647e-27,  1.105492274188536e+00,
 -3.164096479703444e-03, -1.378041829087892e-06,  2.092982319621664e-08,  2.334397148705174e-11, -2.457769749592558e-13, -4.369965656680249e-16,  3.457303920580794e-18,
  8.586346046894645e-21, -5.294629716679674e-23, -1.733238344272524e-25,  8.463300292724050e-28,  1.185170516789897e+00, -3.101062489893374e-03, -2.549976540722172e-06,
  1.891951625613425e-08,  4.330854625389803e-11, -1.908598721034047e-13, -7.866104494919867e-16,  2.057293891422890e-18,  1.458919611954043e-20, -1.881560076689866e-23,
 -2.704190751729675e-25,  4.247690123408798e-29,  1.263924842296070e+00, -2.998105924621759e-03, -3.622382099073606e-06,  1.569181010483088e-08,  5.859985846030473e-11,
 -1.072461068384918e-13, -9.701766837314560e-16,  1.029280976391705e-19,  1.553114852213128e-20,  2.318853301845723e-23, -2.288366452282436e-25, -7.853717292214869e-28,
  1.341222997222032e+00, -2.857331064466493e-03, -4.544861072497495e-06,  1.150129500333934e-08,  6.733345396567989e-11, -9.375205936767461e-15, -9.448053260001349e-16,
 -1.819921428930929e-18,  1.106148156206130e-20,  5.385448818595333e-23, -7.160879454176684e-26, -1.105743431187301e-27,  1.416531539419519e+00, -2.681936689640793e-03,
 -5.274244650714518e-06,  6.696257302627095e-09,  6.849923693954765e-11,  8.536870482775528e-14, -7.203749269662521e-16, -3.130385054174497e-18,  3.009643004346943e-21,
  5.943473745512796e-23,  1.111443354603884e-25, -7.319481403211884e-28,  1.489320023294836e+00, -2.476171848845728e-03, -5.777562431003891e-06,  1.686612226562984e-09,
  6.214416757220766e-11,  1.602163328258364e-13, -3.581232419327768e-16, -3.455789914371675e-18, -5.367722449782736e-21,  3.884006972268558e-23,  2.169834655203607e-25,
  4.396767755159663e-29,  1.559065474757523e+00, -2.245255898868344e-03, -6.034532309426578e-06, -3.096899677407352e-09,  4.939142844726040e-11,  2.026026116965676e-13,
  4.600214043569744e-17, -2.764263444790145e-18, -1.081416272167164e-20,  4.046949102409169e-24,  1.947199021277277e-25,  6.743215580481886e-28,  1.625257112086241e+00,
 -1.995262368340459e-03, -6.039352776538493e-06, -7.248153543056633e-09,  3.228033894769195e-11,  2.069233171547477e-13,  3.889051468032435e-16, -1.370623652426472e-18,
 -1.151356850279179e-20, -2.675273972036103e-23,  7.388745697663832e-26,  7.673487426823671e-28,  1.687401255792351e+00, -1.732967721745718e-03, -5.801609790150765e-06,
 -1.043060225651319e-08,  1.344314003700565e-11,  1.757316714105492e-13,  5.905034932527450e-16,  1.915052255422401e-19, -7.835305836701547e-21, -3.934140380416892e-23,
 -6.019426364746295e-26,  3.595002724804592e-28,  1.745026357625512e+00, -1.465667800885292e-03, -5.346160903484914e-06, -1.241619173262306e-08, -4.332714821097506e-12,
  1.189951223333818e-13,  6.167159154495663e-16,  1.381813009012952e-18, -2.006280917886337e-21, -3.090697539764610e-23, -1.271711590985543e-25, -1.645222882190349e-28,
  1.797688066786073e+00, -1.200966514872390e-03, -4.711928824053589e-06, -1.311293089617381e-08, -1.858172936873997e-11,  5.152093289355948e-14,  4.874055173436701e-16,
  1.861348638797953e-18,  3.111191635384664e-21, -1.028672426503537e-23, -1.035213178034314e-25, -4.158943814627976e-28,  1.844974240974160e+00, -9.465431255734496e-04,
 -3.949620887509448e-06, -1.257687197455823e-08, -2.758821411204946e-11, -1.083611530576199e-14,  2.663519128786246e-16,  1.607293244429468e-18,  5.472638506268361e-21,
  8.764157864852343e-24, -2.877765534009225e-26, -3.007852273955800e-28,  1.886509802031018e+00, -7.099061030680732e-04, -3.118483361030609e-06, -1.100603856886852e-08,
 -3.067956544620796e-11, -5.519781312322940e-14,  3.671203902124806e-17,  8.859898499765916e-19,  4.748656802596976e-21,  1.651409447672197e-23,  3.405278451562237e-26,
 -2.791499155413720e-29,  1.921961331895620e+00, -4.981428633112207e-04, -2.282291259095191e-06, -8.716158646043264e-09, -2.832176195423557e-11, -7.481808692712829e-14,
 -1.291053360790143e-16,  1.012752339775621e-19,  2.208609488586979e-21,  1.238663837887235e-23,  4.843454747530133e-26,  1.383127653424199e-28,  1.951041307440133e+00,
 -3.176755973911084e-04, -1.504855382606359e-06, -6.100607010996802e-09, -2.199137792515338e-11, -7.047386002539713e-14, -1.939344899558743e-16, -4.056314175710158e-19,
 -2.643395841787153e-22,  3.263149580857589e-24,  2.427538695826883e-26,  1.153894158722241e-28,  1.973511896398400e+00, -1.740336529414930e-04, -8.453881036670895e-07,
 -3.579345864570255e-09, -1.384425186332281e-11, -4.968113026988596e-14, -1.655328107706709e-16, -5.059028434867036e-19, -1.371202632410816e-21, -2.994828598485319e-24,
 -3.234379722363369e-27,  1.508026949222200e-29,  1.989188392033008e+00, -7.165171236887130e-05, -3.540956729504122e-07, -1.543451679576363e-09, -6.245103246605344e-12,
 -2.396185620684338e-14, -8.804518407545143e-17, -3.110659303983809e-19, -1.056980367293914e-21, -3.443157304008009e-24, -1.067133500708631e-26, -3.099453026673133e-29,
  1.997944483125065e+00, -1.368807612421580e-05, -6.829052513149884e-08, -3.024161510265613e-10, -1.253265847832102e-12, -4.975254607046414e-15, -1.915361085902652e-17,
 -7.202055050912066e-20, -2.656839480712754e-22, -9.643286892171074e-25, -3.450253620164452e-27, -1.218314731782816e-29,  7.162735250533084e-04, -4.313533511160415e-06,
  1.947599016229453e-08, -7.813126612492924e-11,  2.936803209720114e-13, -1.059026333247012e-15,  3.709864226982157e-18, -1.271930586694447e-20,  4.288251124650761e-23,
 -1.426282672268108e-25,  4.690386465112484e-28, -1.527548212960796e-30,  6.441636080798085e-03, -3.869365337476527e-05,  1.737943155681898e-07, -6.910744539139133e-10,
  2.563005580095848e-12, -9.068038940478571e-15,  3.095653815648406e-17, -1.025957901176000e-19,  3.311492541765263e-22, -1.042315857199831e-24,  3.198567664612198e-27,
 -9.553669250465115e-30,  1.786661662729185e-02, -1.067723524639889e-04,  4.745503721399832e-07, -1.853428084701704e-09,  6.686080619072534e-12, -2.272094303920392e-14,
  7.328380854947948e-17, -2.244732519513738e-19,  6.493094834416965e-22, -1.748719841821654e-24,  4.248414381943917e-27, -8.573938276121920e-30,  3.493968909728364e-02,
 -2.071957606031319e-04,  9.062882327966701e-07, -3.443042863140172e-09,  1.188667971450918e-11, -3.777413490018591e-14,  1.100194378608811e-16, -2.869168441090862e-19,
  6.270170779489899e-22, -8.884826782086300e-25, -9.919100572560250e-28,  1.497305014904487e-29,  5.758347420683624e-02, -3.379561519253583e-04,  1.446580081760118e-06,
 -5.288693247077328e-09,  1.713187052369264e-11, -4.899619228862870e-14,  1.183976014612256e-16, -2.052084023449999e-19,  7.592816376758243e-24,  2.050392237180396e-24,
 -1.209108287706689e-26,  4.940447391727261e-29,  8.569463731705772e-02, -4.964197788834758e-04,  2.066913538756504e-06, -7.183666603846094e-09,  2.127363541331326e-11,
 -5.130883787472219e-14,  8.110077824362913e-17,  5.665385939347039e-20, -1.154726325263742e-21,  5.965409784770553e-24, -2.157812813482684e-26,  5.771636530889790e-29,
  1.191437624832652e-01, -6.793641977417077e-04,  2.733841064053498e-06, -8.902561167920015e-09,  2.321232691208474e-11, -4.097522379981202e-14, -7.058774698716720e-18,
  4.580225760349837e-19, -2.429935058138990e-21,  8.342821966592838e-24, -1.864558009176213e-26,  6.063581030863002e-30,  1.577752116536411e-01, -8.830252326604471e-04,
  3.410361786101578e-06, -1.022021683234685e-08,  2.206296688360712e-11, -1.661328120774068e-14, -1.352275744037328e-16,  8.800340764408003e-19, -3.134525070378444e-21,
  6.497035808793197e-24,  2.840959234719864e-27, -9.760061331747343e-29,  2.014069804459424e-01, -1.103153716643690e-03,  4.057497839249696e-06, -1.093150763269006e-08,
  1.730397780782666e-11,  2.017260943728200e-14, -2.767387744303134e-16,  1.154837861853412e-18, -2.616552774053035e-21, -6.795547306371403e-25,  3.700189005192523e-26,
 -1.881494820993046e-28,  2.498305645283166e-01, -1.335082107287695e-03,  4.636018695086523e-06, -1.087058367865567e-08,  8.888523593951265e-12,  6.469745733707402e-14,
 -3.939278759302402e-16,  1.119818776923223e-18, -5.996627612084066e-22, -1.139783899579588e-23,  6.509407344824242e-26, -1.746457850315634e-28,  3.028108533638509e-01,
 -1.573800996346640e-03,  5.108258163898070e-06, -9.928077814747368e-09, -2.698599905342170e-12,  1.097127749041818e-13, -4.468527824131705e-16,  6.813534749057134e-19,
  2.564523214227956e-21, -2.099528902594617e-23,  6.394953770251406e-26, -8.929274125937670e-30,  3.600860709399136e-01, -1.814045407435734e-03,  5.439960002189762e-06,
 -8.064803583917860e-09, -1.645064742242752e-11,  1.465048883011670e-13, -4.041288502647307e-16, -1.332497110425398e-19,  5.875009848090689e-21, -2.366470984661612e-23,
  2.073730999470340e-26,  2.533699824384681e-28,  4.213677860676172e-01, -2.050390598775537e-03,  5.602079801574091e-06, -5.320580669230685e-09, -3.092039671529270e-11,
  1.664329167021400e-13, -2.532776574778303e-16, -1.156588484659706e-18,  7.955345894558323e-21, -1.537382969417791e-23, -5.422918301377777e-26,  4.536565940212922e-28,
  4.863410178580295e-01, -2.277356851502772e-03,  5.572463626417099e-06, -1.817044087619428e-09, -4.437020320329335e-11,  1.626637119713487e-13, -7.715283845159705e-18,
 -2.108098752735618e-18,  7.567993369039723e-21,  3.344916141382305e-24, -1.260913986766370e-25,  4.153196882417372e-28,  5.546644649892664e-01, -2.489522423871648e-03,
  5.337318451517080e-06,  2.246368517449213e-09, -5.497820407127644e-11,  1.317897384424240e-13,  2.920665196500818e-16, -2.666702871798317e-18,  4.193545256778198e-21,
  2.632986145850243e-23, -1.500024106180307e-25,  7.439239591343273e-29,  6.259708902721864e-01, -2.681643485048123e-03,  4.892386724249983e-06,  6.603601227363106e-09,
 -6.107919679646104e-11,  7.499283142025163e-14,  5.844248265582417e-16, -2.572530657112641e-18, -1.570137260014299e-21,  4.350378613194753e-23, -9.677762107717467e-26,
 -4.322332553068496e-28,  6.998676946686069e-01, -2.848779409925049e-03,  4.243738365136545e-06,  1.094012282363270e-08, -6.141106099085645e-11, -1.544454872267224e-15,
  7.991871822645807e-16, -1.727382126651884e-18, -8.008652693938956e-21,  4.514751610496661e-23,  2.410375588985233e-26, -8.043292500104975e-28,  7.759377171447811e-01,
 -2.986421323888355e-03,  3.408099326207506e-06,  1.491717079020541e-08, -5.533264824909189e-11, -8.717291296192514e-14,  8.746437141250986e-16, -2.579467824329642e-19,
 -1.278044556544266e-20,  2.703508949662090e-23,  1.600478916006705e-25, -7.516594943083941e-28,  8.537402983461186e-01, -3.090621245267782e-03,  2.412647527731550e-06,
  1.820055405112679e-08, -4.297811917528538e-11, -1.682850491943680e-13,  7.749435305994428e-16,  1.487936824031081e-18, -1.378110735352757e-20, -6.173240486780901e-24,
  2.373349961785065e-25, -2.089285211167420e-28,  9.328126468111003e-01, -3.158118602386564e-03,  1.294225519115890e-06,  2.049180690309121e-08, -2.531678623742266e-11,
 -2.306258437586267e-13,  5.031000839604418e-16,  3.023068702552400e-18, -1.007180474637310e-20, -4.154008209646480e-23,  2.018109673806075e-25,  5.620786172420075e-28,
  1.012671546024031e+00, -3.186460329619029e-03,  9.794516358223563e-08,  2.155891711202344e-08, -4.097125671867392e-12, -2.620325680504908e-13,  1.052182281038240e-16,
  3.865004366499335e-18, -2.464770493355516e-21, -6.299466854713335e-23,  5.599667261756559e-26,  1.090912766340399e-27,  1.092815438734106e+00, -3.174110210380126e-03,
 -1.124806896921567e-06,  2.126346602961087e-08,  1.833154679708826e-11, -2.550739973776299e-13, -3.366410217923666e-16,  3.700307601087109e-18,  6.564898063075000e-21,
 -5.908697641401141e-23, -1.326034585690598e-25,  9.981285987750084e-28,  1.172726921328634e+00, -3.120542682184385e-03, -2.318913959586170e-06,  1.958091020243953e-08,
  3.930749796215187e-11, -2.089952179624466e-13, -7.225869327436927e-16,  2.511230606526674e-18,  1.371822349655792e-20, -2.952455917632345e-23, -2.632746856070585e-25,
  2.831174065634210e-28,  1.251875675338648e+00, -3.026316006592234e-03, -3.428529666730322e-06,  1.661098535222116e-08,  5.622262064438508e-11, -1.304388962188008e-13,
 -9.602242203640111e-16,  6.114497775442503e-19,  1.619323605775409e-20,  1.338752211701450e-23, -2.600520191132447e-25, -6.259190501054084e-28,  1.329721855112500e+00,
 -2.893119598524553e-03, -4.400391744928172e-06,  1.257588162438815e-08,  6.691528322613470e-11, -3.262025976512594e-14, -9.905206185965842e-16, -1.435582672160210e-18,
  1.293683349672036e-20,  5.000390715847720e-23, -1.211610674779131e-25, -1.138683803458518e-27,  1.405719940129018e+00, -2.723790471193191e-03, -5.187260416755704e-06,
  7.804935137664755e-09,  7.002668608062085e-11,  6.704078616286843e-14, -8.063499917579606e-16, -2.999050417301530e-18,  5.221041211747111e-21,  6.317999804714922e-23,
  7.474062746323904e-26, -9.209657018244871e-28,  1.479323047263498e+00, -2.522294247363192e-03, -5.751253104826450e-06,  2.706053297074625e-09,  6.525461230788795e-11,
  1.504421718235784e-13, -4.570679478524837e-16, -3.603509483879507e-18, -3.813279279872547e-21,  4.750343419728978e-23,  2.147756183241282e-25, -1.494327755212636e-28,
  1.549987682653376e+00, -2.293667065847535e-03, -6.066819689980525e-06, -2.274187434639825e-09,  5.344805052190247e-11,  2.027389563218305e-13, -3.620902916861980e-17,
 -3.106425136112030e-18, -1.052124862433649e-20,  1.241486660720849e-23,  2.232502889243270e-25,  6.157840624954955e-28,  1.617178894923177e+00, -2.043916003920255e-03,
 -6.123093531871754e-06, -6.698067065384532e-09,  3.650881508933061e-11,  2.157540102244971e-13,  3.452292777301534e-16, -1.753829257732430e-18, -1.241507177769903e-20,
 -2.309367696930210e-23,  1.097403627858654e-25,  8.598464333010688e-28,  1.680375771943596e+00, -1.779877340319338e-03, -5.925367994878015e-06, -1.018662363546031e-08,
  1.709977660006590e-11,  1.899384440816555e-13,  5.921393846200269e-16, -8.231659576146741e-20, -9.290761560176413e-21, -4.139275578222844e-23, -4.135165330642976e-26,
  4.997346950421273e-28,  1.739077202798307e+00, -1.509034057652632e-03, -5.495489967510364e-06, -1.246565874180793e-08, -1.801708587803844e-12,  1.342522752430721e-13,
  6.543335211857554e-16,  1.298814788148314e-18, -3.212069424814021e-21, -3.611953916124105e-23, -1.329411912727916e-25, -9.363634794992684e-29,  1.792807806255824e+00,
 -1.239296337848325e-03, -4.871031729315964e-06, -1.340134172224510e-08, -1.743005526502245e-11,  6.385495687439142e-14,  5.408555134399054e-16,  1.954146080439031e-18,
  2.661839659247474e-21, -1.480271464812470e-23, -1.224889299937282e-25, -4.447584333632445e-28,  1.841123908082743e+00, -9.787513006594786e-04, -4.103197803850574e-06,
 -1.301965419479556e-08, -2.773726313926816e-11, -3.883546879998012e-15,  3.138535578323122e-16,  1.787216616913102e-18,  5.764060927175128e-21,  7.328713601520000e-24,
 -4.349559775502799e-26, -3.695708973469456e-28,  1.883619433534913e+00, -7.353906881959218e-04, -3.253537313819292e-06, -1.150568664292996e-08, -3.177261028635950e-11,
 -5.400130180090981e-14,  6.373838476368677e-17,  1.047718870333693e-18,  5.367293965040525e-21,  1.784136716254633e-23,  3.203811044911375e-26, -6.539448981531016e-29,
  1.919931570327309e+00, -5.168273873301275e-04, -2.389653974281586e-06, -9.181444971343781e-09, -2.984883620861869e-11, -7.787417448710041e-14, -1.252104003599778e-16,
  1.794714313844995e-19,  2.690893963596758e-21,  1.444855846479571e-23,  5.472773823614179e-26,  1.473947082509206e-28,  1.949746055130302e+00, -3.300133600257996e-04,
 -1.580221181535550e-06, -6.464001643328316e-09, -2.344832382945679e-11, -7.526542029413159e-14, -2.053915381274207e-16, -4.120129950458786e-19, -1.281065137438544e-22,
  4.342105998738899e-24,  2.983695320840400e-26,  1.379840950802051e-28,  1.972801958129140e+00, -1.809724089508257e-04, -8.897028043544699e-07, -3.809023636696167e-09,
 -1.487877578186842e-11, -5.382895983080213e-14, -1.803287670770030e-16, -5.515298964764431e-19, -1.481166265406238e-21, -3.108813816469576e-24, -2.408775360724049e-27,
  2.279149723166321e-29,  1.988895999903341e+00, -7.456029928410426e-05, -3.732328180051958e-07, -1.647325071041984e-09, -6.746196962265269e-12, -2.618339836418078e-14,
 -9.724779484454194e-17, -3.469576815012002e-19, -1.188956824139588e-21, -3.898474879342564e-24, -1.212479827193830e-26, -3.514895061481128e-29,  1.997888614697105e+00,
 -1.424926491695970e-05, -7.204319895402498e-08, -3.232901249779020e-10, -1.357536253963968e-12, -5.460133942159965e-15, -2.129462778539710e-17, -8.110561174467621e-20,
 -3.030188272353867e-22, -1.113688630947711e-24, -4.034008215073541e-27, -1.441752021086251e-29,  6.993251795648644e-04, -4.161397588468849e-06,  1.856592466842632e-08,
 -7.359710589728573e-11,  2.733620960525851e-13, -9.741128335182704e-16,  3.372188197994149e-18, -1.142572582440862e-20,  3.807001679578294e-23, -1.251441146287558e-25,
  4.067571905837201e-28, -1.309385909342408e-30,  6.289590621035968e-03, -3.733578681240834e-05,  1.657416138938156e-07, -6.514778391412938e-10,  2.388847727730816e-12,
 -8.358390583199111e-15,  2.822674128505597e-17, -9.257549437656489e-20,  2.958310019243166e-22, -9.224033051597851e-25,  2.806064296953533e-27, -8.316947556123442e-30,
  1.744698168554723e-02, -1.030631293464198e-04,  4.529364068524812e-07, -1.749992679073934e-09,  6.248752658670338e-12, -2.103526375851236e-14,  6.728021367290782e-17,
 -2.046705426028617e-19,  5.893248304610079e-22, -1.586182547388636e-24,  3.882143723563434e-27, -8.067312879798317e-30,  3.412514948528169e-02, -2.001075441193038e-04,
  8.660883661187362e-07, -3.258759074983154e-09,  1.115696254557233e-11, -3.522783495495593e-14,  1.022618139565963e-16, -2.673704975426496e-19,  5.944664760258024e-22,
 -9.160510619743372e-25, -4.115983732135162e-28,  1.152602576693283e-29,  5.625439942145782e-02, -3.266327821591965e-04,  1.384728579655172e-06, -5.022270271240632e-09,
  1.617989710911197e-11, -4.622350745130475e-14,  1.126656229763902e-16, -2.038736308971156e-19,  7.320503404124565e-23,  1.608019670754660e-24, -1.008031998900868e-26,
  4.215701830464329e-29,  8.374149092660353e-02, -4.802235774415426e-04,  1.982718288544990e-06, -6.851391629171584e-09,  2.026703057478009e-11, -4.934736639124684e-14,
  8.220089445160498e-17,  2.297700193533422e-20, -9.549072748406242e-22,  5.151810288959750e-24, -1.913370414307292e-26,  5.334629827269146e-29,  1.164693793860439e-01,
 -6.579145407335438e-04,  2.629211651499236e-06, -8.537724971980129e-09,  2.239212287368385e-11, -4.099925306707362e-14,  4.721375416885002e-18,  3.849268532827117e-19,
 -2.142930540258291e-21,  7.604870087506612e-24, -1.819424626337232e-26,  1.400453217765236e-29,  1.542969082125905e-01, -8.562269340096549e-04,  3.289825715373978e-06,
 -9.870035647180819e-09,  2.170018490018021e-11, -1.957416928508462e-14, -1.119556157570760e-16,  7.834855178758736e-19, -2.899557867036915e-21,  6.531691878133332e-24,
 -9.441550838236021e-28, -7.507788813679058e-29,  1.970584614324813e-01, -1.071213711242372e-03,  3.927993104134046e-06, -1.065176641397508e-08,  1.764358290484413e-11,
  1.390943013287458e-14, -2.455772627647537e-16,  1.070986644495529e-18, -2.616304676918195e-21,  6.421694189123914e-25,  2.926146859323430e-26, -1.638377593680875e-28,
  2.445635897726347e-01, -1.298513233009630e-03,  4.506466054602737e-06, -1.071851877294767e-08,  1.009045704831813e-11,  5.561691749989728e-14, -3.628997884558491e-16,
  1.094551915358374e-18, -9.649676945579351e-22, -8.947519745371447e-24,  5.743815017520395e-26, -1.724402498467421e-28,  2.965966261540461e-01, -1.533412049779206e-03,
  4.988932705561293e-06, -9.954277420724678e-09, -6.099987389758499e-13,  9.922583544074727e-14, -4.267360934125746e-16,  7.518171402068972e-19,  1.854534213993634e-21,
 -1.845682945411735e-23,  6.270378571988882e-26, -4.597321242006810e-29,  3.529163097173618e-01, -1.770917093307473e-03,  5.341698080648312e-06, -8.305101040922711e-09,
 -1.361773631652461e-11,  1.367814870858596e-13, -4.053546494297196e-16,  4.130042366258965e-20,  5.040515082830157e-21, -2.263222689988852e-23,  3.040565537746458e-26,
  1.873204862181008e-28,  4.132554410425414e-01, -2.005837507803295e-03,  5.535373222484969e-06, -5.789018523936419e-09, -2.765500171377679e-11,  1.599938803100094e-13,
 -2.821841063068438e-16, -9.112532484194165e-19,  7.367516086503349e-21, -1.715896018981090e-23, -3.541270574247703e-26,  4.008041099752573e-28,  4.773205950623090e-01,
 -2.232876182217068e-03,  5.546506829670468e-06, -2.500970781353283e-09, -4.112342002102340e-11,  1.617976671962710e-13, -6.334021667952376e-17, -1.864933662715336e-18,
  7.602074404788710e-21, -1.328506059088674e-24, -1.074971386747665e-25,  4.267139801938171e-28,  5.447919222684523e-01, -2.446730801972284e-03,  5.359085112366108e-06,
  1.388159361816664e-09, -5.227827948440818e-11,  1.379193212351537e-13,  2.194118344920215e-16, -2.518493253590785e-18,  5.034477270210009e-21,  2.042456426938293e-23,
 -1.445754939159499e-25,  1.687042548538333e-28,  6.153230730952376e-01, -2.642203913118327e-03,  4.965818232842423e-06,  5.639070447245456e-09, -5.944493601123641e-11,
  8.815039886224520e-14,  5.119204588378918e-16, -2.598498796345218e-18, -7.790020784367041e-23,  3.929223617966392e-23, -1.128204550707305e-25, -2.978517207888082e-28,
  6.885412847155679e-01, -2.814321076577561e-03,  4.369126687446655e-06,  9.958323928681088e-09, -6.125420614130195e-11,  1.702818456973486e-14,  7.474778769736992e-16,
 -1.957535839988719e-18, -6.374309732115481e-21,  4.542689563816575e-23, -9.523751272610840e-27, -7.205520583760710e-28,  7.640476737303110e-01, -2.958455680669463e-03,
  3.581739593145305e-06,  1.401903801238903e-08, -5.686701190938189e-11, -6.631340618448955e-14,  8.618503077389377e-16, -6.501789773539797e-19, -1.170007148040362e-20,
  3.275928999227909e-23,  1.258297003732960e-25, -7.973327477964406e-28,  8.414177821351098e-01, -3.070458377661167e-03,  2.626820518674782e-06,  1.748700232943927e-08,
 -4.615471724687500e-11, -1.492364305163601e-13,  8.104113589598631e-16,  1.045196638845656e-18, -1.383516429753519e-20,  3.083280132455106e-24,  2.242247794394750e-25,
 -3.826727139888719e-28,  9.202024272089045e-01, -3.146788423817003e-03,  1.537546779533305e-06,  2.005052233804313e-08, -2.980189665161209e-11, -2.175734352591575e-13,
  5.830203950845321e-16,  2.678446763516624e-18, -1.141651032720243e-20, -3.303106201553787e-23,  2.221806400731763e-25,  3.618837325942002e-28,  9.999289082088080e-01,
 -3.184643451923339e-03,  3.560864479011653e-07,  2.145161170278268e-08, -9.303813718221053e-12, -2.582196794151478e-13,  2.119968260216324e-16,  3.750371752384894e-18,
 -4.680881254042321e-21, -5.981615440836758e-23,  1.023158131718802e-25,  1.006803503860720e-27,  1.080102623530421e+00, -3.182083423393310e-03, -8.680551496587700e-07,
  2.151555558739256e-08,  1.315777951995728e-11, -2.618883397763125e-13, -2.304179035081420e-16,  3.875414623111294e-18,  4.353204118105720e-21, -6.347744098577891e-23,
 -8.612935298483458e-26,  1.106547303023721e-27,  1.160209150793409e+00, -3.138143742204130e-03, -2.080310438961952e-06,  2.017547346768221e-08,  3.496012014618115e-11,
 -2.254449798572512e-13, -6.463008271380071e-16,  2.931203753196641e-18,  1.246943064996221e-20, -3.973544361912377e-23, -2.455259178015973e-25,  5.223001926890079e-28,
  1.239716838590378e+00, -3.052931830445300e-03, -3.223890598128391e-06,  1.748843180621023e-08,  5.338507991861781e-11, -1.532199033673140e-13, -9.357912125123847e-16,
  1.135286410825116e-18,  1.648182329854463e-20,  2.491348656277256e-24, -2.832804935523367e-25, -4.233692585669470e-28,  1.318079951836935e+00, -2.927700947247815e-03,
 -4.243083046846918e-06,  1.364000247138295e-08,  6.602214587315432e-11, -5.682670333767625e-14, -1.024657847189898e-15, -9.938350955030918e-19,  1.463767069349842e-20,
  4.415696526030238e-23, -1.710504670097861e-25, -1.119988084331206e-27,  1.394742402268468e+00, -2.764894775451691e-03, -5.086837869478011e-06,  8.935008976152848e-09,
  7.116728251719954e-11,  4.670170493282522e-14, -8.876388077429958e-16, -2.795090841911973e-18,  7.539089805499120e-21,  6.530690519305934e-23,  3.035118327343640e-26,
 -1.092871660497180e-27,  1.469142081238589e+00, -2.568156407760427e-03, -5.712418755587952e-06,  3.773567292217103e-09,  6.814552233486274e-11,  1.382496121171961e-13,
 -5.594057455858826e-16, -3.696530992580319e-18, -1.950675496497502e-21,  5.589958210684650e-23,  2.034176193523756e-25, -3.709343797544508e-28,  1.540715793366473e+00,
 -2.342295938787631e-03, -6.088845354021128e-06, -1.386657861585662e-09,  5.748689946902681e-11,  2.007886118124446e-13, -1.278226759168804e-16, -3.434179174752713e-18,
 -9.907280685976988e-21,  2.186007501237451e-23,  2.482680711690660e-25,  5.138333362483359e-28,  1.608904766813225e+00, -2.093211998211992e-03, -6.199821682098324e-06,
 -6.078972716996440e-09,  4.090253747933840e-11,  2.234045973198391e-13,  2.904415991200224e-16, -2.163490894949580e-18, -1.315809908311803e-20, -1.792419406078132e-23,
  1.492661462532829e-25,  9.327848056978037e-28,  1.673160689464267e+00, -1.827764297356996e-03, -6.045838043014997e-06, -9.881866314859028e-09,  2.104029273338730e-11,
  2.040871483543914e-13,  5.854462273145629e-16, -4.037367603746765e-19, -1.080496921869126e-20, -4.256231999855152e-23, -1.599529137485110e-26,  6.549836667746221e-28,
  1.732952190922394e+00, -1.553596609409602e-03, -5.645159432782610e-06, -1.247214032425844e-08,  1.043257414245850e-12,  1.503798283330291e-13,  6.890584930549355e-16,
  1.174190905713211e-18, -4.608844007248693e-21, -4.149289696154097e-23, -1.350154137581518e-25,  4.077868118952086e-30,  1.787771659335500e+00, -1.278912495325849e-03,
 -5.033476635209455e-06, -1.366928176780214e-08, -1.601867127223159e-11,  7.750118033173835e-14,  5.966770301654795e-16,  2.029814309762179e-18,  2.035976357835106e-21,
 -2.009976938702017e-23, -1.424907972554473e-25, -4.621093381348156e-28,  1.837142251566087e+00, -1.012209374185227e-03, -4.262097621474663e-06, -1.346364511519853e-08,
 -2.773544710876773e-11,  4.270517101159423e-15,  3.665150007667722e-16,  1.975519005181865e-18,  5.992459286035931e-21,  5.241641367394825e-24, -6.141663447814849e-26,
 -4.462507930894005e-28,  1.880624927444765e+00, -7.619799833063576e-04, -3.394691067639609e-06, -1.202259516980176e-08, -3.283486002951718e-11, -5.209953672700151e-14,
  9.557734521661264e-17,  1.229989818440307e-18,  6.031835624216282e-21,  1.905182074678497e-23,  2.812758503719746e-26, -1.144439727792368e-28,  1.917825316905244e+00,
 -5.363935667867658e-04, -2.502748722954068e-06, -9.671647603028969e-09, -3.143591077028218e-11, -8.080869538353068e-14, -1.188983978514570e-16,  2.743377221459830e-19,
  3.252028639533361e-21,  1.676948546444346e-23,  6.136489178358847e-26,  1.537241375412304e-28,  1.948400217729965e+00, -3.429718956640619e-04, -1.660090793827509e-06,
 -6.851489051177241e-09, -2.500386240014001e-11, -8.033356383548799e-14, -2.169600810620193e-16, -4.133686928702241e-19,  5.122246774318708e-23,  5.664463589554141e-24,
  3.647224747441138e-26,  1.642583168028788e-28,  1.972063537939391e+00, -1.882769949214632e-04, -9.368757538733446e-07, -4.055937179745103e-09, -1.599991287350724e-11,
 -5.834762420796736e-14, -1.964521119897905e-16, -6.007343654904635e-19, -1.594551276464829e-21, -3.182335085958592e-24, -1.194023146973170e-27,  3.286061758040564e-29,
  1.988591659140341e+00, -7.762710903649704e-05, -3.936660547986381e-07, -1.759583759381087e-09, -7.294014082284848e-12, -2.863835559107235e-14, -1.075170463861796e-16,
 -3.873465287384407e-19, -1.338416527144662e-21, -4.415726350973967e-24, -1.377152967767818e-26, -3.978375287944126e-29,  1.997830439843737e+00, -1.484150616817872e-05,
 -7.605669972928221e-08, -3.459128869909315e-10, -1.472039415179112e-12, -5.999590401330649e-15, -2.370759406778456e-17, -9.147612666311311e-20, -3.461757841322282e-22,
 -1.288489534352129e-24, -4.725533816007408e-27, -1.709593872807568e-29,  6.829711536798996e-04, -4.016329950326859e-06,  1.770837319717469e-08, -6.937487942885479e-11,
  2.546639451912687e-13, -8.968857527147828e-16,  3.068667714647126e-18, -1.027653738706990e-20,  3.384432911264899e-23, -1.099694179591107e-25,  3.533246026648637e-28,
 -1.124364238199395e-30,  6.142850728156166e-03, -3.604048754087006e-05,  1.581478095353657e-07, -6.145576727788796e-10,  2.228249773805630e-12, -7.711014359249686e-15,
  2.576231808201584e-17, -8.361923984433013e-20,  2.645596472184504e-22, -8.171534031909500e-25,  2.464222572719088e-27, -7.246773333092639e-30,  1.704184550930034e-02,
 -9.952196949259545e-05,  4.325227706433174e-07, -1.653292456127720e-09,  5.843741235241661e-12, -1.948722864238266e-14,  6.180508128192580e-17, -1.866965039683902e-19,
  5.349332827431472e-22, -1.437839066873144e-24,  3.538952992106734e-27, -7.529072861407020e-30,  3.333833327172583e-02, -1.933322756245690e-04,  8.280315003435485e-07,
 -3.085753285526081e-09,  1.047635326528031e-11, -3.286126887793570e-14,  9.503678617036397e-17, -2.488774537516723e-19,  5.613065798229774e-22, -9.232341041304834e-25,
  3.222157191079232e-29,  8.747281573466079e-30,  5.496964837919413e-02, -3.157916908778034e-04,  1.325984569617178e-06, -4.770642698170829e-09,  1.528200590939303e-11,
 -4.358771853585258e-14,  1.069981253893788e-16, -2.006791586023850e-19,  1.242653352836748e-22,  1.239983902774609e-24, -8.367387375577544e-27,  3.585081864200798e-29,
  8.185180708821617e-02, -4.646852596098163e-04,  1.902415002337688e-06, -6.534907369869013e-09,  1.929984643649448e-11, -4.737011139548871e-14,  8.244330672570593e-17,
 -4.755788738655657e-21, -7.826648066689047e-22,  4.432074370292244e-24, -1.688623070959317e-26,  4.879918861424508e-29,  1.138791482589205e-01, -6.372846299240103e-04,
  2.528881565751502e-06, -8.186001201534599e-09,  2.157410496474608e-11, -4.076410549266216e-14,  1.457945809654206e-17,  3.205943365512814e-19, -1.882090073669246e-21,
  6.891204301486622e-24, -1.744896237940582e-26,  1.951563422556628e-29,  1.509238958577825e-01, -8.303762182123860e-04,  3.173455133437973e-06, -9.526103273059284e-09,
  2.128355584545606e-11, -2.200812087432784e-14, -9.128176131505837e-17,  6.944485230500695e-19, -2.665839503611837e-21,  6.433669404005464e-24, -3.819390100885106e-27,
 -5.618233738413211e-29,  1.928356517433809e-01, -1.040296233030888e-03,  3.801873861480263e-06, -1.036755378549028e-08,  1.786521318760327e-11,  8.365995877425847e-15,
 -2.167567348676861e-16,  9.878469977085001e-19, -2.573792595991897e-21,  1.675356684614732e-24,  2.256619995547292e-26, -1.407366894431881e-28,  2.394408296724248e-01,
 -1.262973167354900e-03,  4.378847715793200e-06, -1.054863562100034e-08,  1.111816265307640e-11,  4.727132055472663e-14, -3.327299884139755e-16,  1.058947858128807e-18,
 -1.247536117806361e-21, -6.799993398421639e-24,  4.998875750347068e-26, -1.655170714788746e-28,  2.905420443132331e-01, -1.493978412126609e-03,  4.869486522981673e-06,
 -9.948710460489366e-09,  1.273838543622372e-12,  8.924288900452258e-14, -4.049508448571528e-16,  8.010106848470499e-19,  1.234667274353971e-21, -1.599782215682737e-23,
  6.004819876796652e-26, -7.323261155299128e-29,  3.459174723663205e-01, -1.728585653059582e-03,  5.240818130877113e-06, -8.501627654976345e-09, -1.097920698704667e-11,
  1.270843348775301e-13, -4.020608108060401e-16,  1.898105242764099e-19,  4.249470839514087e-21, -2.126889071710955e-23,  3.733689688738390e-26,  1.290770980882248e-28,
  4.053202067155255e-01, -1.961839676314145e-03,  5.463354501482708e-06, -6.206275701810698e-09, -2.452477978630492e-11,  1.529413418915735e-13, -3.044931684797502e-16,
 -6.856161650715478e-19,  6.728397360068272e-21, -1.823917152930010e-23, -1.900760404408908e-26,  3.445937151758741e-28,  4.684776289010043e-01, -2.188635114437757e-03,
  5.512653803561568e-06, -3.133157731038754e-09, -3.790675622373481e-11,  1.596783004341016e-13, -1.121655237532236e-16, -1.623225668808609e-18,  7.481371583228443e-21,
 -5.253499383122755e-24, -8.879624965457700e-26,  4.207695706884045e-28,  5.350908301262015e-01, -2.403805497737457e-03,  5.370816198720606e-06,  5.740364542752318e-10,
 -4.947284933885778e-11,  1.423578360839457e-13,  1.512521405452400e-16, -2.346725632424473e-18,  5.667667787092600e-21,  1.481293952523630e-23, -1.354770019674000e-25,
  2.413123565786814e-28,  6.048341164589552e-01, -2.602222722693897e-03,  5.027840638399111e-06,  4.702698352813564e-09, -5.756495654393338e-11,  9.956438787681530e-14,
  4.393338959712472e-16, -2.579253597268515e-18,  1.252578104629903e-21,  3.455527667136765e-23, -1.231058745141910e-25, -1.713805395348352e-28,  6.773546397892470e-01,
 -2.778906692552147e-03,  4.482760514874099e-06,  8.981936819988787e-09, -6.073880017596887e-11,  3.428837901842518e-14,  6.900561580754087e-16, -2.135481683720572e-18,
 -4.753177418108173e-21,  4.444084840871059e-23, -3.903358372381601e-26, -6.183762580645461e-28,  7.522722023273444e-01, -2.929144411455498e-03,  3.744468671044629e-06,
  1.309967259306990e-08, -5.798812447091113e-11, -4.588864366466833e-14,  8.385874840396050e-16, -1.004809483181917e-18, -1.043864524767518e-20,  3.708577415385356e-23,
  9.043445059441828e-26, -8.056391837758751e-28,  8.291792887511642e-01, -3.048617211410865e-03,  2.832138645930830e-06,  1.672571485314457e-08, -4.894283451878633e-11,
 -1.294852362008992e-13,  8.335075350732655e-16,  6.059427045539170e-19, -1.356719450108138e-20,  1.167068426277431e-23,  2.040927742690363e-25, -5.271266494719165e-28,
  9.076413862282340e-01, -3.133534056273142e-03,  1.775150997576503e-06,  1.953966524320825e-08, -3.400758353336731e-11, -2.027233064832887e-13,  6.527359351222072e-16,
  2.295835294129748e-18, -1.244237305688661e-20, -2.388603144695593e-23,  2.335672530308906e-25,  1.556104652261914e-28,  9.871976580191107e-01, -3.180768004137670e-03,
  6.124431894703743e-07,  2.126174735227786e-08, -1.440891803520889e-11, -2.518905161242320e-13,  3.145925987593765e-16,  3.567003959269796e-18, -6.750229379315780e-21,
 -5.487217390358159e-23,  1.439529465070487e-25,  8.792053552999945e-28,  1.067362040662207e+00, -3.187991938844509e-03, -6.087790539360387e-07,  2.168391461029483e-08,
  7.873574181504653e-12, -2.661026218638415e-13, -1.203037808744534e-16,  3.977585792805031e-18,  2.017934762718880e-21, -6.592785774553223e-23, -3.596521304075978e-26,
  1.165018990135310e-27,  1.147624837159722e+00, -3.153808641846753e-03, -1.835000031316114e-06,  2.069795011565307e-08,  3.030298349746181e-11, -2.399276141247902e-13,
 -5.588690986940136e-16,  3.305491479575716e-18,  1.086833205827039e-20, -4.902930678217019e-23, -2.175322524684174e-25,  7.465733408691706e-28,  1.227454878322745e+00,
 -3.077869230526153e-03, -3.009009494586975e-06,  1.831686950908338e-08,  5.009897486638494e-11, -1.752378341045386e-13, -8.966216361411593e-16,  1.661920421289731e-18,
  1.636367326548288e-20, -9.144685632357566e-24, -2.967885994688132e-25, -1.856562169957949e-28,  1.306302320587017e+00, -2.960973028580819e-03, -4.073106748484630e-06,
  1.468591988827340e-08,  6.463771950731093e-11, -8.169807118810616e-14, -1.045698544015902e-15, -5.014111259996732e-19,  1.609244503599663e-20,  3.634734167992952e-23,
 -2.188811491376625e-25, -1.044501685286043e-27,  1.383602140233627e+00, -2.805141177139317e-03, -4.972758700367968e-06,  1.007997419729440e-08,  7.188209416779908e-11,
  2.448866273965857e-14, -9.621692857100446e-16, -2.516085641585647e-18,  9.899993739860181e-21,  6.551482638503961e-23, -2.099054071845927e-26, -1.234827283039741e-27,
  1.458778370137321e+00, -2.613655885768048e-03, -5.660505192529658e-06,  4.885250828900890e-09,  7.076784510401802e-11,  1.235767008884158e-13, -6.634689967111167e-16,
 -3.725220157611634e-18,  2.036011596856074e-22,  6.363981465922810e-23,  1.818306937749988e-25, -6.128663596964521e-28,  1.531249105175445e+00, -2.391057320809620e-03,
 -6.099834616310047e-06, -4.349413008808903e-10,  6.146402373606897e-11,  1.965319553903822e-13, -2.282859384985069e-16, -3.736662254501306e-18, -8.936478284049099e-21,
  3.220252839731638e-23,  2.677664450831654e-25,  3.644016427643157e-28,  1.600432275828784e+00, -2.143090894939148e-03, -6.268694095597925e-06, -5.388430105572564e-09,
  4.543518034001055e-11,  2.296001300459134e-13,  2.238807053039104e-16, -2.593640824797828e-18, -1.368586342202170e-20, -1.111737005346719e-23,  1.913943921200655e-25,
  9.764625550357203e-28,  1.665752156338995e+00, -1.876599293174240e-03, -6.162263412481903e-06, -9.511808830173227e-09,  2.526141917743887e-11,  2.179617127306257e-13,
  5.690700847531705e-16, -7.740759121011679e-19, -1.234134616011789e-20, -4.257755171629488e-23,  1.644062390439809e-26,  8.205830097446520e-28,  1.726646534760559e+00,
 -1.599356029372151e-03, -5.794622772910211e-06, -1.243047804039933e-08,  4.218798961586214e-12,  1.672936772922771e-13,  7.196390976574136e-16,  1.001768093978067e-18,
 -6.199438172733118e-21, -4.685456024754742e-23, -1.321361579685125e-25,  1.320264901208852e-28,  1.782574428873247e+00, -1.319840668057680e-03, -5.198992084623521e-06,
 -1.391238280512917e-08, -1.432080649479106e-11,  9.251009983977697e-14,  6.543070946266940e-16,  2.082248165902389e-18,  1.204874336691571e-21, -2.620763014788642e-23,
 -1.629066371318802e-25, -4.626120359658927e-28,  1.833024186632548e+00, -1.046959944472904e-03, -4.426319546748647e-06, -1.390623185179647e-08, -2.755748002736508e-11,
  1.375247666718013e-14,  4.245389125786987e-16,  2.169782910507825e-18,  6.131987578747843e-21,  2.368161027884282e-24, -8.286490656319496e-26, -5.296294689688097e-28,
  1.877521766025323e+00, -7.897236058193611e-04, -3.542148305258606e-06, -1.255615211319179e-08, -3.385100714464024e-11, -4.936995150457182e-14,  1.328239170432150e-16,
  1.434188680265712e-18,  6.736582735409004e-21,  2.005879385522656e-23,  2.176354112795340e-26, -1.773004802426294e-28,  1.915638951378730e+00, -5.568884700457465e-04,
 -2.621880169928851e-06, -1.018770377955387e-08, -3.307993489171555e-11, -8.355774503556020e-14, -1.096658218672432e-16,  3.885488940294658e-19,  3.901552370202206e-21,
  1.936032560581172e-23,  6.819196913997859e-26,  1.557308943416107e-28,  1.947001238216629e+00, -3.565884185043294e-04, -1.744762980562616e-06, -7.264691065161762e-09,
 -2.666353982186473e-11, -8.567911359258431e-14, -2.284787089092809e-16, -4.081706303119838e-19,  2.832229129527194e-22,  7.276519743233221e-24,  4.435134706000483e-26,
  1.945772184987249e-28,  1.971295125433391e+00, -1.959711282949296e-04, -9.871223467908266e-07, -4.321533403233145e-09, -1.721540657922844e-11, -6.327019365281157e-14,
 -2.140043043002433e-16, -6.535992100391952e-19, -1.709594211050808e-21, -3.197578053128727e-24,  5.268306350371655e-28,  4.591026651080747e-29,  1.988274715459490e+00,
 -8.086292592701957e-05, -4.155006510192510e-07, -1.881014100350783e-09, -7.893489436921447e-12, -3.135390362432288e-14, -1.189870359517119e-16, -4.328291437124608e-19,
 -1.507733407701030e-21, -5.003072060307663e-24, -1.563315927106559e-26, -4.491932812435537e-29,  1.997769830044944e+00, -1.546697330395456e-05, -8.035303246248801e-08,
 -3.704572607362092e-10, -1.597935169718668e-12, -6.600604611162125e-15, -2.643125454733159e-17, -1.033339275179927e-19, -3.961532365932724e-22, -1.493459560735245e-24,
 -5.546387953967351e-27, -2.031340933941752e-29,  6.671839913846734e-04, -3.877925028114473e-06,  1.689974313810909e-08, -6.543985216029637e-11,  2.374400205092745e-13,
 -8.265718258753946e-16,  2.795510673665431e-18, -9.254227424302197e-21,  3.012834261587544e-23, -9.677774561272616e-26,  3.074035068591674e-28, -9.671556070435208e-31,
  6.001173277027359e-03, -3.480420925530898e-05,  1.509820468564410e-07, -5.801066238182115e-10,  2.080027625697144e-12, -7.119884658955989e-15,  2.353521175685433e-17,
 -7.560559428544909e-20,  2.368421095172022e-22, -7.246792086361704e-25,  2.166234188356088e-27, -6.320092636395123e-30,  1.665055455102681e-02, -9.613958497338674e-05,
  4.132316550482351e-07, -1.562831702273796e-09,  5.468416251610429e-12, -1.806474926556536e-14,  5.680963877474110e-17, -1.703801518457717e-19,  4.856407514040140e-22,
 -1.302745345581672e-24,  3.219726059132440e-27, -6.981081300287257e-30,  3.257802211404908e-02, -1.868533393670308e-04,  7.919868974418746e-07, -2.923267841522966e-09,
  9.841382621804856e-12, -3.066200983342487e-14,  8.831469219568338e-17, -2.314464666346146e-19,  5.281797356278457e-22, -9.149402343713538e-25,  3.662400482540981e-28,
  6.517072296150170e-30,  5.372734058202257e-02, -3.054087138210652e-04,  1.270175608672780e-06, -4.532967014906002e-09,  1.443547843756925e-11, -4.108670336845950e-14,
  1.014410474443612e-16, -1.960500487314131e-19,  1.632451296157685e-22,  9.351716437405903e-25, -6.912989913436200e-27,  3.038969413504442e-29,  8.002301535394485e-02,
 -4.497744368911726e-04,  1.825817982881920e-06, -6.233581632985440e-09,  1.837220579860066e-11, -4.539575722473562e-14,  8.198259170588085e-17, -2.737442998439277e-20,
 -6.347629789136557e-22,  3.798226042666959e-24, -1.483928792542947e-26,  4.425625282068287e-29,  1.113698579111237e-01, -6.174406991223795e-04,  2.432693830734570e-06,
 -7.847315834858589e-09,  2.076301481562514e-11, -4.031305998304477e-14,  2.274926806442220e-17,  2.642038345764900e-19, -1.646352056077003e-21,  6.211599608629559e-24,
 -1.650519306833327e-26,  2.310302893260643e-29,  1.476524504110655e-01, -8.054400751683543e-04,  3.061170222240951e-06, -9.189200269838068e-09,  2.082301189923751e-11,
 -2.397497527666523e-14, -7.299691652589342e-17,  6.128134248565496e-19, -2.437528764090688e-21,  6.236281082900183e-24, -5.936116870764682e-27, -4.053644739738168e-29,
  1.887345157337036e-01, -1.010374014456799e-03,  3.679182907791697e-06, -1.008064522829522e-08,  1.798270408496322e-11,  3.486505662593594e-15, -1.902398371846398e-16,
  9.066131267667655e-19, -2.498665589854349e-21,  2.460596911017316e-24,  1.685193674696915e-26, -1.193048625073244e-28,  2.344582012307666e-01, -1.228445626914891e-03,
  4.253361252919909e-06, -1.036360548990747e-08,  1.198611133600002e-11,  3.963688347511419e-14, -3.036724764552960e-16,  1.015481738425908e-18, -1.458073910796399e-21,
 -4.943289711773817e-24,  4.292087091879235e-26, -1.553146812575008e-28,  2.846432870108210e-01, -1.455499579304165e-03,  4.750281496765064e-06, -9.914570538161783e-09,
  2.963345688290834e-12,  7.979715713404050e-14, -3.820527282743002e-16,  8.317621847239493e-19,  7.011471765720214e-22, -1.366644754847725e-23,  5.638349654872589e-26,
 -9.206932333934795e-29,  3.390863327548574e-01, -1.687069982712312e-03,  5.137826778086081e-06, -8.657483685993519e-09, -8.533507943574018e-12,  1.175133209156262e-13,
 -3.949553456398933e-16,  3.138411314972367e-19,  3.511901544499330e-21, -1.967714296487314e-23,  4.188644758296961e-26,  7.909350650214475e-29,  3.975597808910314e-01,
 -1.918437182415553e-03,  5.386624452510422e-06, -6.574604719939593e-09, -2.154046313744411e-11,  1.454268574632393e-13, -3.207756888092205e-16, -4.809312952297902e-19,
  6.061603493652658e-21, -1.871295119117331e-23, -5.093883557540332e-27,  2.879935250437656e-28,  4.598110385466354e-01, -2.144694344532049e-03,  5.471521735025678e-06,
 -3.714278535263824e-09, -3.474365243264472e-11,  1.564677783097850e-13, -1.542972988853720e-16, -1.387497363939394e-18,  7.232731077446373e-21, -8.439977988787787e-24,
 -7.067100200728797e-26,  4.011481539879600e-28,  5.255615661103935e-01, -2.360824653456986e-03,  5.373049777553849e-06, -1.945766147466155e-10, -4.659460660334009e-11,
  1.452203378095766e-13,  8.815577435281583e-17, -2.157852097543958e-18,  6.106103509526890e-21,  9.622887915227125e-24, -1.236497295971882e-25,  2.929427556164139e-28,
  5.945060065225929e-01, -2.561789770795568e-03,  5.078814284183098e-06,  3.798137782949061e-09, -5.547405023746795e-11,  1.092474166359230e-13,  3.678561125175602e-16,
 -2.520230295262414e-18,  2.406431387182599e-21,  2.951483491071498e-23, -1.280846538245978e-25, -5.725570913115008e-29,  6.663113965667292e-01, -2.742629938557072e-03,
  4.584738320772985e-06,  8.016481370853848e-09, -5.989234498778567e-11,  5.011648370188637e-14,  6.283713142315808e-16, -2.262338041687361e-18, -3.187670930558070e-21,
  4.236811805203930e-23, -6.377680143614748e-26, -5.050568089525954e-28,  7.406165094048638e-01, -2.898575713268949e-03,  3.896071110164043e-06,  1.216560370777540e-08,
 -5.870710501307929e-11, -2.613664930578226e-14,  8.059815908100388e-16, -1.316855643211002e-18, -9.046944635370658e-21,  3.999935840250751e-23,  5.542965581090621e-26,
 -7.803364049551754e-28,  8.170313862335735e-01, -3.025170770112467e-03,  3.028066786183696e-06,  1.592300364834032e-08, -5.133137485125857e-11, -1.093260742042488e-13,
  8.444699492870060e-16,  1.800428751133811e-19, -1.300601673513288e-20,  1.933543628675056e-23,  1.783400872848957e-25, -6.375808628093133e-28,  8.951371239755859e-01,
 -3.118404496927834e-03,  2.006231269999877e-06,  1.896398038265708e-08, -3.790042174322491e-11, -1.863319648160063e-13,  7.113287844186806e-16,  1.885733931794809e-18,
 -1.313299896901420e-20, -1.446639139837908e-23,  2.359467468189216e-25, -4.578672186874713e-29,  9.744859949521379e-01, -3.174852194016332e-03,  8.660360743423908e-07,
  2.099134590564725e-08, -1.936326991224058e-11, -2.431679729646917e-13,  4.111559869096212e-16,  3.320574538398074e-18, -8.613070881087668e-21, -4.838611320971745e-23,
  1.791605412047858e-25,  7.160387953776407e-28,  1.054601982908605e+00, -3.191819607069293e-03, -3.479922476651430e-07,  2.176719647130294e-08,  2.531698378318228e-12,
 -2.676483473866131e-13, -8.385542196882530e-18,  4.004008273368779e-18, -3.689529388911137e-22, -6.633583338077794e-23,  1.560339508512567e-26,  1.170093158091004e-27,
  1.134981826785803e+00, -3.167487267345903e-03, -1.583876168763152e-06,  2.114371282191399e-08,  2.537799545922358e-11, -2.521922167603935e-13, -4.617232539458327e-16,
  3.623425778029141e-18,  8.955122943460042e-21, -5.701339188355694e-23, -1.802412676581332e-25,  9.428241530066059e-28,  1.215096668208172e+00, -3.101048743700079e-03,
 -2.784516957408676e-06,  1.908926274021036e-08,  4.638310244126940e-11, -1.961395634853834e-13, -8.428228354419847e-16,  2.177987946887834e-18,  1.581949533861326e-20,
 -2.110384674500103e-23, -2.992603316878565e-25,  7.625129217819947e-29,  1.294394399540608e+00, -2.992835510013973e-03, -3.890728837000220e-06,  1.570568440644852e-08,
  6.275195887172554e-11, -1.069039736456466e-13, -1.052344486374391e-15,  3.270555533523798e-20,  1.723259240266447e-20,  2.670818326834126e-23, -2.620991525295511e-25,
 -9.103042839974372e-28,  1.372302805105293e+00, -2.844419827096116e-03, -4.844886294483229e-06,  1.123272794001898e-08,  7.213543454099238e-11,  5.891643067164091e-16,
 -1.027831701117058e-15, -2.161819646012038e-18,  1.223001633240245e-20,  6.355585146049059e-23, -7.768145000026748e-26, -1.333937076083150e-27,  1.448233577205437e+00,
 -2.658686004374873e-03, -5.595009808131719e-06,  6.036408035877586e-09,  7.307171072963020e-11,  1.064046729303728e-13, -7.673298483194373e-16, -3.680701808465469e-18,
  2.618382600165363e-21,  7.029993101082281e-23,  1.493406777402494e-25, -8.645192108502197e-28,  1.521587269476187e+00, -2.439859860092474e-03, -6.099024717397370e-06,
  5.795943669483141e-10,  6.533123728080752e-11,  1.897664058517522e-13, -3.367268400202070e-16, -4.001985601249595e-18, -7.581024782560283e-21,  4.317896612756834e-23,
  2.796086514916854e-25,  1.657790808232025e-28,  1.591759221532274e+00, -2.193486383217248e-03, -6.328841067412584e-06, -4.624464844894341e-09,  5.007477480122481e-11,
  2.340520006794624e-13,  1.450783509518390e-16, -3.036430132298879e-18, -1.393788462823360e-20, -2.597895752838952e-24,  2.346094630849159e-25,  9.804314942366747e-28,
  1.658146450197432e+00, -1.926346760108872e-03, -6.273833785827992e-06, -9.072018372067351e-09,  2.975523802538946e-11,  2.313132689922260e-13,  5.416379349934604e-16,
 -1.193323136256805e-18, -1.385314611985500e-20, -4.114803273483145e-23,  5.626723365577182e-26,  9.895729434416383e-28,  1.720155453925383e+00, -1.646308266559244e-03,
 -5.943270026069298e-06, -1.233526274605779e-08,  7.739535300227378e-12,  1.848775978361444e-13,  7.446504850526754e-16,  7.753917561300839e-19, -7.979536157388356e-21,
 -5.197895814248457e-23, -1.229133610149079e-25,  2.927371929744045e-28,  1.777210819679873e+00, -1.362104148111346e-03, -5.367251600922648e-06, -1.412584098684691e-08,
 -1.230882960603496e-11,  1.089165446044999e-13,  7.129987954781849e-16,  2.104411345693897e-18,  1.392413821523237e-22, -3.312623565905085e-23, -1.828592804080584e-25,
 -4.399299651417092e-28,  1.828764458318433e+00, -1.083045471005714e-03, -4.595828919763421e-06, -1.434437648119451e-08, -2.717550524551159e-11,  2.469268564037619e-14,
  4.880479485930556e-16,  2.366683745039560e-18,  6.151729444881620e-21, -1.438150095392562e-24, -1.080911992429429e-25, -6.175221349076528e-28,  1.874305229865380e+00,
 -8.186727688842532e-04, -3.696103812042680e-06, -1.310548011702671e-08, -3.480314694944656e-11, -4.567525777467584e-14,  1.761088505074228e-16,  1.661464654880120e-18,
  7.472290783854651e-21,  2.075130505970085e-23,  1.228669425895038e-26, -2.563305303019586e-28,  1.913368660279049e+00, -5.783616468463233e-04, -2.747363889636931e-06,
 -1.073049102001894e-08, -3.477645264613224e-11, -8.604440116390240e-14, -9.692994853348486e-17,  5.250899276474974e-19,  4.649267827553578e-21,  2.222430332360035e-23,
  7.497530964337061e-26,  1.513489678413992e-28,  1.945546405805440e+00, -3.709026121899197e-04, -1.834556497042460e-06, -7.705318160858540e-09, -2.843287634890086e-11,
 -9.129846909126238e-14, -2.397386812101840e-16, -3.945564980656254e-19,  5.792632782284966e-22,  9.231681372154764e-24,  5.365920154482048e-26,  2.292439721495248e-28,
  1.970495111786292e+00, -2.040803212782879e-04, -1.040676106215350e-06, -4.607388535941831e-09, -1.853368624771981e-11, -6.863219429926864e-14, -2.330882324673427e-16,
 -7.101397390774795e-19, -1.823799110142597e-21, -3.131460306135870e-24,  2.901326239204340e-27,  6.271295957768935e-29,  1.987944469693066e+00, -8.427941552797209e-05,
 -4.388518028866499e-07, -2.012485935811293e-09, -8.550134953297828e-12, -3.436064587801864e-14, -1.318096764819078e-16, -4.840830326873920e-19, -1.699590922500330e-21,
 -5.669551344509245e-24, -1.773189069737592e-26, -5.056008363068498e-29,  1.997706647721334e+00, -1.612802441237148e-05, -8.495639216366045e-08, -3.971157967081527e-10,
 -1.736532744221453e-12, -7.271158663798149e-15, -2.951047948390703e-17, -1.169156943116923e-19, -4.541363997383547e-22, -1.734278840130649e-24, -6.522769806087841e-27,
 -2.418668615043326e-29,  6.519378032834887e-04, -3.745804845362898e-06,  1.613672518889549e-08, -6.176950415899555e-11,  2.215590676458518e-13, -7.624831824191261e-16,
  2.549382491741350e-18, -8.343572042431994e-21,  2.685579428512373e-23, -8.529175130538907e-26,  2.678704448984217e-28, -8.333348111081433e-31,  5.864328849361659e-03,
 -3.362364285723280e-05,  1.442158483813255e-07, -5.479353780965647e-10,  1.943111235799264e-12, -6.579610156427930e-15,  2.152055457017427e-17, -6.842786779848288e-20,
  2.122485716659071e-22, -6.433468087862754e-25,  1.906232438089669e-27, -5.517080728582049e-30,  1.627249120667134e-02, -9.290728723054361e-05,  3.949909554534359e-07,
 -1.478154913333120e-09,  5.120378052373772e-12, -1.675685204958479e-14,  5.224968490297705e-17, -1.555657640382633e-19,  4.409875564082324e-22, -1.179939226002715e-24,
  2.924530190276536e-27, -6.438879028836168e-30,  3.184306209715766e-02, -1.806551300566695e-04,  7.578325862515454e-07, -2.770598648186581e-09,  9.248822772561645e-12,
 -2.861834365582034e-14,  8.206588723480860e-17, -2.150683661451365e-19,  4.955695903792205e-22, -8.951094469668760e-25,  6.123357954267738e-28,  4.735875950270115e-30,
  5.252568949294124e-02, -2.954610265198656e-04,  1.217139116613421e-06, -4.308442808714216e-09,  1.363764875606124e-11, -3.871737148912597e-14,  9.602947527527257e-17,
 -1.903383855939616e-19,  1.922430256413670e-22,  6.839573569205557e-25, -5.682014895446423e-27,  2.568021437710356e-29,  7.825266390672923e-02, -4.354621760149738e-04,
  1.752749119329439e-06, -5.946783056385346e-09,  1.748389304998315e-11, -4.343954579391699e-14,  8.095149477017293e-17, -4.560989626748032e-20, -5.082537980479231e-22,
  3.242288571523049e-24, -1.298972892219137e-26,  3.984431985167778e-29,  1.089384297123903e-01, -5.983502331676042e-04,  2.340492786232210e-06, -7.521525611643080e-09,
  1.996278274794390e-11, -3.968405615296196e-14,  2.944213017997648e-17,  2.149730628439957e-19, -1.434366579669022e-21,  5.572433007931288e-24, -1.543797274863597e-26,
  2.519063384694770e-29,  1.444789784019737e-01, -7.813861681762055e-04,  2.952882711887093e-06, -8.859957585425836e-09,  2.032733831610429e-11, -2.552960434321508e-14,
 -5.689674850538835e-17,  5.383555274344109e-19, -2.217690113598639e-21,  5.967121666380775e-24, -7.428788386219470e-27, -2.775252100353855e-29,  1.847511273837302e-01,
 -9.814195271399425e-04,  3.559943025358861e-06, -9.792603725281793e-09,  1.800878650426743e-11, -7.835773411140478e-16, -1.659598852605640e-16,  8.281933158126832e-19,
 -2.399161976387692e-21,  3.035570764707900e-24,  1.203876960955015e-26, -9.980824387798849e-29,  2.296116895480529e-01, -1.194912872009811e-03,  4.130173557541828e-06,
 -1.016587222554719e-08,  1.270824281956436e-11,  3.268452059477920e-14, -2.759166720160833e-16,  9.662942277599310e-19, -1.606744596671378e-21, -3.359628695421919e-24,
  3.635187096952597e-26, -1.430151074964694e-28,  2.788965409840008e-01, -1.417972302591443e-03,  4.631642205559385e-06, -9.854879700446227e-09,  4.469493842789267e-12,
  7.090945985850290e-14, -3.585201797426105e-16,  8.467541326489752e-19,  2.487382123404635e-22, -1.149606239391569e-23,  5.205012167801587e-26, -1.038483931772114e-28,
  3.324195970381312e-01, -1.646385073528793e-03,  5.033193656287565e-06, -8.775729495544799e-09, -6.277256121054714e-12,  1.081518994509611e-13, -3.846986137662060e-16,
  4.152173349804636e-19,  2.834403055944254e-21, -1.794495884330696e-23,  4.441876038161035e-26,  3.734854396355847e-29,  3.899717104990990e-01, -1.875665408517945e-03,
  5.305755926601263e-06, -6.896406316545819e-09, -1.870989227106630e-11,  1.375879434969027e-13, -3.316275828287047e-16, -2.977541613997108e-19,  5.387174790018129e-21,
 -1.867957193590618e-23,  6.364362136311541e-27,  2.333084057402535e-28,  4.513195102013735e-01, -2.101109669834862e-03,  5.423717583983774e-06, -4.245356075556890e-09,
 -3.165434115658762e-11,  1.523242981708368e-13, -1.899563307983203e-16, -1.161422927048224e-18,  6.882189573361309e-21, -1.092194627971829e-23, -5.364453599725873e-26,
  3.713890661108299e-28,  5.162042039046947e-01, -2.317862047265651e-03,  5.366337938570410e-06, -9.167602529647512e-10, -4.367382112291476e-11,  1.466334043639306e-13,
  3.051687275748810e-17, -1.957842691235281e-18,  6.366707102239964e-21,  4.945524366635621e-24, -1.099835795243372e-25,  3.252264429796337e-28,  5.843403760471070e-01,
 -2.520991865796073e-03,  5.119140020722263e-06,  2.928488426367930e-09, -5.320648331151360e-11,  1.172388139541369e-13,  2.985204105183247e-16, -2.427215853767338e-18,
  3.376414915773923e-21,  2.437131840800865e-23, -1.283717916260377e-25,  4.148794936605625e-29,  6.554148189865651e-01, -2.705583450210014e-03,  4.675222103915951e-06,
  7.067020157667779e-09, -5.874439083915621e-11,  6.442711373531808e-14,  5.638233168475614e-16, -2.340473235579656e-18, -1.713379408388832e-21,  3.940713310226255e-23,
 -8.341460784782800e-26, -3.873710175145755e-28,  7.290854456880490e-01, -2.866839196706228e-03,  4.036408591220382e-06,  1.122314605582472e-08, -5.903955241874900e-11,
 -7.266924185064697e-15,  7.652757438726709e-16, -1.582956685034433e-18, -7.575209441648792e-21,  4.154380049522034e-23,  2.218458368627466e-26, -7.265936633296147e-28,
  8.049803424486610e-01, -3.000196052798017e-03,  3.214146432475510e-06,  1.508531154425932e-08, -5.331505536259485e-11, -8.904463976172238e-14,  8.437985881708010e-16,
 -2.236920533357361e-19, -1.218852478294493e-20,  2.588347878239789e-23,  1.485219313954198e-25, -7.117379383952581e-28,  8.826970320312282e-01, -3.101454961736753e-03,
  2.230040666643236e-06,  1.832870518541195e-08, -4.145231252155391e-11, -1.686743725604469e-13,  7.581804058308777e-16,  1.458959497091458e-18, -1.348490785573301e-20,
 -5.125112565872650e-24,  2.297573298650346e-25, -2.323626257825783e-28,  9.618020301773230e-01, -3.166921953604946e-03,  1.115914682141241e-06,  2.064319389020635e-08,
 -2.412058847784514e-11, -2.322172196972359e-13,  5.000217547927012e-16,  3.018527406959176e-18, -1.021887217879601e-20, -4.064367050618650e-23,  2.065845744062277e-25,
  5.271506755347415e-28,  1.041830791347243e+00, -3.193558437705513e-03, -8.671942626206213e-08,  2.176490704098622e-08, -2.814216243780189e-12, -2.665077875578708e-13,
  1.032038284771989e-16,  3.954212949905301e-18, -2.733488993784838e-21, -6.469244641315800e-23,  6.621316390503260e-26,  1.121708511928543e-27,  1.122288151854935e+00,
 -3.179136862736143e-03, -1.327883628917150e-06,  2.150884296029482e-08,  2.023171460374671e-11, -2.620256662453527e-13, -3.565734291865364e-16,  3.875842690122549e-18,
  6.783319293944301e-21, -6.334405999013862e-23, -1.351514615686207e-25,  1.099286506718544e-27,  1.202649389155205e+00, -3.122396283709399e-03, -2.551125979777318e-06,
  1.979893276193464e-08,  4.226326572347714e-11, -2.155790886366734e-13, -7.748826628450674e-16,  2.669757032882694e-18,  1.484582541242973e-20, -3.292718527551857e-23,
 -2.899187672281328e-25,  3.489391176769449e-28,  1.282362023342468e+00, -3.023190570729019e-03, -3.696311434224001e-06,  1.669124029849545e-08,  6.036171644143920e-11,
 -1.320861250025870e-13, -1.043578849557329e-15,  5.974337256833883e-19,  1.799619134217286e-20,  1.547539847275405e-23, -2.981481050188824e-25, -7.192807616024447e-28,
  1.360848488993618e+00, -2.882620133583778e-03, -4.703172564459043e-06,  1.238562910838021e-08,  7.189587265043004e-11, -2.475885436498963e-14, -1.082544585766323e-15,
 -1.734566580211177e-18,  1.444778534855422e-20,  5.925733367169779e-23, -1.375685823632900e-25, -1.378283866376673e-27,  1.437509800062390e+00, -2.703136304687769e-03,
 -5.515491136854499e-06,  7.221544717495914e-09,  7.500735619247410e-11,  8.676388658658422e-14, -8.688282333192033e-16, -3.555346724252020e-18,  5.246865517856230e-21,
  7.543904537826279e-23,  1.058080972870397e-25, -1.112358906642196e-27,  1.511730315153171e+00, -2.488606181804399e-03, -6.085674067966564e-06,  1.654779123638285e-09,
  6.903653915565678e-11,  1.803143953015796e-13, -4.519295990385609e-16, -4.217538538797257e-18, -5.824129734195615e-21,  5.444001902560467e-23,  2.816488171941817e-25,
 -8.061587180048906e-29,  1.582883682782120e+00, -2.244325108889412e-03, -6.379372461206502e-06, -3.785660759808728e-09,  5.478348640014186e-11,  2.364632216053944e-13,
  5.381347438111165e-17, -3.482043765051394e-18, -1.385217431830246e-20,  7.639633632144691e-24,  2.769310065907732e-25,  9.341413729649779e-28,  1.650340004238297e+00,
 -1.976964437727809e-03, -6.379686582054340e-06, -8.558230423781180e-09,  3.450852542038474e-11,  2.438601788269844e-13,  5.017995892162173e-16, -1.659802597352915e-18,
 -1.528302420276253e-20, -3.797775633772646e-23,  1.034343637979434e-25,  1.152461813759475e-27,  1.713474194409226e+00, -1.694444126868918e-03, -6.090425000144104e-06,
 -1.218087190122582e-08,  1.161740538178191e-11,  2.029791248347072e-13,  7.624987085036285e-16,  4.891862555252224e-19, -9.935677382725948e-21, -5.658307327348167e-23,
 -1.058752700798056e-25,  4.872930895039888e-28,  1.771675448997306e+00, -1.405723377594625e-03, -5.537868389050696e-06, -1.430440583453757e-08, -9.954608458714139e-12,
  1.267349480990637e-13,  7.717951338272983e-16,  2.088337564461473e-18, -1.189511191553353e-21, -4.081458143038707e-23, -2.011720289514125e-25, -3.868078240847023e-28,
  1.824357642618518e+00, -1.120507982391239e-03, -4.770551864830628e-06, -1.477457439077528e-08, -2.655903773876898e-11,  3.722320778099627e-14,  5.570570200938231e-16,
  2.561821530772255e-18,  6.015343110852080e-21, -6.331467520043936e-24, -1.372229995998653e-25, -7.064570355346952e-28,  1.870970391658397e+00, -8.488801967360473e-04,
 -3.856740032932904e-06, -1.366939255139104e-08, -3.567047519713444e-11, -4.086268034802902e-14,  2.260902938012749e-16,  1.912601897247705e-18,  8.225220006062665e-21,
  2.098990587418850e-23, -1.067086649223711e-27, -3.539081531053265e-28,  1.911010426824518e+00, -6.008652123100997e-04, -2.879525505660230e-06, -1.130080245220404e-08,
 -3.651932285409633e-11, -8.817671767817129e-14, -8.002007941099788e-17,  6.872593547173051e-19,  5.504902088498867e-21,  2.535330879357710e-23,  8.137745677999918e-26,
  1.379074949643950e-28,  1.944032845744780e+00, -3.859567940035677e-04, -1.929811150911649e-06, -8.175168271147111e-09, -3.031726568442719e-11, -9.718235141389248e-14,
 -2.504737204160552e-16, -3.702679816509158e-19,  9.527707815068303e-22,  1.159099007158769e-23,  6.459173362469196e-26,  2.684430313288190e-28,  1.969661782264947e+00,
 -2.126320322701047e-04, -1.097790303100034e-06, -4.915219494552797e-09, -1.996391642824222e-11, -7.447161691247202e-14, -2.538059619687384e-16, -7.702768868988115e-19,
 -1.933724166951155e-21, -2.954266992880903e-24,  6.114868657568578e-27,  8.422297184696330e-29,  1.987600174099631e+00, -8.788920828090217e-05, -4.638456947257619e-07,
 -2.154962399725877e-09, -9.270112673955195e-12, -3.769306932912380e-14, -1.461571034248413e-16, -5.418769506075425e-19, -1.917013918523168e-21, -6.425088915700995e-24,
 -2.008960546356332e-26, -5.668515860569303e-29,  1.997640745458888e+00, -1.682722075265165e-05, -8.989341559856824e-08, -4.261033310057541e-10, -1.889312335800017e-12,
 -8.020395544269948e-15, -3.299732939705222e-17, -1.324995184342563e-19, -5.215351426920940e-22, -2.017785746085679e-24, -7.686589155536051e-27, -2.885956324361011e-29,
  6.372081606001435e-04, -3.619616853748413e-06,  1.541626812626777e-08, -5.834330971037726e-11,  2.069028226793929e-13, -7.040070972184547e-16,  2.327346610057079e-18,
 -7.531316319134657e-21,  2.396964149755678e-23, -7.527536183138077e-26,  2.337798205389674e-28, -7.192186169532538e-31,  5.732100821613059e-03, -3.249569826393902e-05,
  1.378229091356290e-07, -5.178709110398957e-10,  1.816532648931389e-12, -6.085362005160393e-15,  1.969628207119421e-17, -6.199222713342572e-20,  1.904040157723537e-22,
 -5.717403627494949e-25,  1.679160177083172e-27, -4.820695455718586e-30,  1.590707150645623e-02, -8.981694331491953e-05,  3.777338099881870e-07, -1.398843280025984e-09,
  4.797436190121942e-12, -1.555357355347888e-14,  4.808517790671797e-17, -1.421117746334887e-19,  4.005485529436026e-22, -1.068468027288834e-24,  2.652859149119417e-27,
 -5.913214818857961e-30,  3.113235982787409e-02, -1.747229852366315e-04,  7.254547424813903e-07, -2.627091420484223e-09,  8.695673072828186e-12, -2.671926294988942e-14,
  7.626117975803315e-17, -1.997206143155059e-19,  4.638326966211345e-22, -8.668889328608916e-25,  7.883943615997612e-28,  3.321219340586034e-30,  5.136299733135556e-02,
 -2.859270674471022e-04,  1.166721864432383e-06, -4.096311784858212e-09,  1.288592039652930e-11, -3.647590139308753e-14,  9.078952662504406e-17, -1.838343792246195e-19,
  2.130354153810201e-22,  4.780391771132275e-25, -4.643353776068750e-27,  2.163410599411855e-29,  7.653841386068953e-02, -4.217209383727090e-04,  1.683037846961446e-06,
 -5.673886000087955e-09,  1.663441799623863e-11, -4.151376834057929e-14,  7.946357177505465e-17, -6.010338645417228e-20, -4.004729436291958e-22,  2.756509550598968e-24,
 -1.132978917198661e-26,  3.564830153919296e-29,  1.065819126148610e-01, -5.799819542907400e-04,  2.252124844295136e-06, -7.208430188560840e-09,  1.917662926083004e-11,
 -3.891021959456475e-14,  3.484810068207075e-17,  1.721660629155388e-19, -1.244603897872399e-21,  4.977430933354566e-24, -1.430532897598000e-26,  2.612909065120921e-29,
  1.414000142498422e-01, -7.581828946713475e-04,  2.848497569131499e-06, -8.538874119031140e-09,  1.980427139038973e-11, -2.672206163316334e-14, -4.278444659836514e-17,
  4.707669619390951e-19, -2.008487312700228e-21,  5.648747464105399e-24, -8.414939823817105e-27, -1.745182898453800e-29,  1.808816710377727e-01, -9.534051320844912e-04,
  3.444159427154410e-06, -9.504797195633857e-09,  1.795511853180629e-11, -4.496912911713220e-15, -1.438282540398446e-16,  7.532532899241441e-19, -2.282223496996396e-21,
  3.434574830405400e-24,  8.038473833574950e-27, -8.236577058297457e-29,  2.248973531732208e-01, -1.162355941386108e-03,  4.009423513338197e-06, -9.957661519221714e-09,
  1.329787431998136e-11,  2.638128331669047e-14, -2.495965068707817e-16,  9.132118149260406e-19, -1.702998986338559e-21, -2.027503941811795e-24,  3.035242331031526e-26,
 -1.295635876489075e-28,  2.732980109326777e-01, -1.381390878685198e-03,  4.513858028471522e-06, -9.772481723175415e-09,  5.803561712475733e-12,  6.259001610797913e-14,
 -3.347590336048064e-16,  8.484847767954052e-19, -1.287654015981443e-22, -9.507592468582481e-24,  4.732964121320962e-26, -1.098720396570820e-28,  3.259139186892643e-01,
 -1.606542305555876e-03,  4.927352052268184e-06, -8.859358806821552e-09, -4.205553605266591e-12,  9.906831035306914e-14, -3.718973736718256e-16,  4.959274230339801e-19,
  2.220665274773654e-21, -1.614586566370173e-23,  4.528922996348447e-26,  3.471119287802242e-30,  3.825534099205458e-01, -1.833555271387579e-03,  5.221292301473658e-06,
 -7.174185456379382e-09, -1.603830128070701e-11,  1.295476970142347e-13, -3.376518768405538e-16, -1.360557132005206e-19,  4.721626318060156e-21, -1.823502880411248e-23,
  1.549058846508747e-26,  1.822224572673865e-28,  4.430015165042149e-01, -2.057932086364882e-03,  5.369834196843747e-06, -4.727711963220777e-09, -2.865595179850699e-11,
  1.473996167919204e-13, -2.194548318713219e-16, -9.478666879555612e-19,  6.454219808312649e-21, -1.275129419383614e-23, -3.809008445567606e-26,  3.347447293001159e-28,
  5.070185309721909e-01, -2.274987004478109e-03,  5.351240985730864e-06, -1.592058474886708e-09, -4.073814980258791e-11,  1.467311310302026e-13, -2.142956221915383e-17,
 -1.752080165419858e-18,  6.469059822293161e-21,  8.380066324166318e-25, -9.528196051390614e-26,  3.404191118647543e-28,  5.743385171960786e-01, -2.479912469731021e-03,
  5.149252635422189e-06,  2.096309296828022e-09, -5.079550064953400e-11,  1.236007437689697e-13,  2.321958607632498e-16, -2.306118617719395e-18,  4.162027287309603e-21,
  1.929826128538841e-23, -1.246863364544660e-25,  1.231356100380414e-28,  6.446678034100672e-01, -2.667858332290518e-03,  4.754431726659611e-06,  6.138131091828401e-09,
 -5.732586570518234e-11,  7.716756578105995e-14,  4.977309696133359e-16, -2.373278099750093e-18, -3.585745358369539e-22,  3.576412947093207e-23, -9.788947363611852e-26,
 -2.712801514243236e-28,  7.176835017201063e-01, -2.834025280363109e-03,  4.165416940889373e-06,  1.027833288401032e-08, -5.900495055366316e-11,  1.054181477452740e-14,
  7.177849627595486e-16, -1.801324198169520e-18, -6.071175930207169e-21,  4.181277953776527e-23, -8.180460862357937e-27, -6.504721644744215e-28,  7.930321104216275e-01,
 -2.973773416292091e-03,  3.389996712732161e-06,  1.421912091838658e-08, -5.489416781142875e-11, -6.891180743312782e-14,  8.322226484715531e-16, -5.977315005188870e-19,
 -1.115746070957478e-20,  3.118429174175874e-23,  1.162431359281217e-25, -7.496084330302322e-28,  8.703282695690012e-01, -3.082746383480068e-03,  2.445897620169348e-06,
  1.763948196316187e-08, -4.464078025542969e-11, -1.500367014745719e-13,  7.929748110004236e-16,  1.026241079645963e-18, -1.350690939229249e-20,  3.810677582440605e-24,
  2.158411742882714e-25, -3.957867057621871e-28,  9.491537561583908e-01, -3.157010672235233e-03,  1.361166357937674e-06,  2.022078980261356e-08, -2.863827812677326e-11,
 -2.192407177090148e-13,  5.797541197628104e-16,  2.669749413902739e-18, -1.152825158139093e-20, -3.197564195084003e-23,  2.253325512382806e-25,  3.235377128566898e-28,
  1.029056822605123e+00, -3.193208647075881e-03,  1.740139366327071e-07,  2.167741035178545e-08, -8.110695062119849e-12, -2.627142957096503e-13,  2.123512689126224e-16,
  3.830084696339206e-18, -5.003075304329000e-21, -6.108235684321387e-23,  1.135729594796975e-25,  1.023181264935059e-27,  1.109552000178292e+00, -3.188722405394031e-03,
 -1.068009610076392e-06,  2.179019862758992e-08,  1.491453176414585e-11, -2.692587589154404e-13, -2.453606047801062e-16,  4.055476159164972e-18,  4.417609832823370e-21,
 -6.774735844565847e-23, -8.423202545550561e-26,  1.206474099088909e-27,  1.190120506512543e+00, -3.141843781281734e-03, -2.309626996689007e-06,  2.043966827942690e-08,
  3.777203962275433e-11, -2.332267261548397e-13, -6.936724976893485e-16,  3.123654037912156e-18,  1.345613368582827e-20, -4.413701683835858e-23, -2.686156658742052e-25,
  6.174056863044265e-28,  1.270211411513969e+00, -3.051943673860708e-03, -3.490313392411711e-06,  1.763454001884047e-08,  5.747122819002842e-11, -1.568657744095533e-13,
 -1.018721407756485e-15,  1.179866060649682e-18,  1.833162283297096e-20,  2.984294836074453e-24, -3.246443555349844e-25, -4.774201380639895e-28,  1.349243726552814e+00,
 -2.919631495107741e-03, -4.547663967698861e-06,  1.353057446763769e-08,  7.113722908253190e-11, -5.126856537515151e-14, -1.124327400594614e-15, -1.239285909294409e-18,
  1.646738502778206e-20,  5.254269446158346e-23, -1.980168508586406e-25, -1.358059371752320e-27,  1.426609584790072e+00, -2.746893073281427e-03, -5.421578391404680e-06,
  8.434378213256826e-09,  7.652616042243116e-11,  6.473892131377221e-14, -9.656138211008667e-16, -3.343277207802132e-18,  8.026424492116805e-21,  7.862332758546300e-23,
  5.174193824554580e-26, -1.340559610687141e-27,  1.501678672270393e+00, -2.537193096963207e-03, -6.059072222740257e-06,  2.787584231271133e-09,  7.252469770601210e-11,
  1.680318202914869e-13, -5.723198209325514e-16, -4.370390713738759e-18, -3.663100240250147e-21,  6.555280878015597e-23,  2.718851510253076e-25, -3.695518276734193e-28,
  1.573804046188066e+00, -2.295526539475451e-03, -6.419384975331054e-06, -2.871254735382189e-09,  5.951751128449464e-11,  2.365350213466799e-13, -4.983247879733590e-17,
 -3.918696117557859e-18, -1.336808597241831e-20,  1.951227987785793e-23,  3.159277879146847e-25,  8.278091250397693e-28,  1.642329434821785e+00, -2.028402964289495e-03,
 -6.478909506982801e-06, -7.966438853229962e-09,  3.950210560813089e-11,  2.552891796423398e-13,  4.482790667782008e-16, -2.169834173644655e-18, -1.656312304993412e-20,
 -3.278184473270996e-23,  1.574167094223054e-25,  1.297148459595543e-27,  1.706598050231500e+00, -1.743748733778496e-03, -6.235342993909689e-06, -1.196151847053273e-08,
  1.586090327508909e-11,  2.214056227181002e-13,  7.714329468597685e-16,  1.378811340157913e-19, -1.204314660169037e-20, -6.032463549190327e-23, -7.954638285196678e-26,
  7.146639036342679e-28,  1.765962858897623e+00, -1.450715444566493e-03, -5.710389942252300e-06, -1.444237577167638e-08, -7.229970510628092e-12,  1.459539974793376e-13,
  8.295035374470984e-16,  2.025179040746881e-18, -2.807569635278392e-21, -4.917798176917423e-23, -2.163323549035589e-25, -2.952837724473684e-28,  1.819798148873481e+00,
 -1.159388739517583e-03, -4.950369437243372e-06, -1.519281210220246e-08, -2.567495830895676e-11,  5.147484975984387e-14,  6.314407183118201e-16,  2.749543888966120e-18,
  5.680885571418100e-21, -1.246756009234411e-23, -1.702007192154514e-25, -7.913464897516762e-28,  1.867512110380266e+00, -8.804000103144664e-04, -4.024223072473918e-06,
 -1.424634460965520e-08, -3.642897268032399e-11, -3.476343954020121e-14,  2.834413981145073e-16,  2.187858466097656e-18,  8.976035456621630e-21,  2.060253077834305e-23,
 -1.916319760300319e-26, -4.722240876457545e-28,  1.908560020505262e+00, -6.244539228014693e-04, -3.018699505956032e-06, -1.189931732702236e-08, -3.830039678539217e-11,
 -8.984550861449184e-14, -5.816886329637178e-17,  8.786594550840055e-19,  6.477617143356605e-21,  2.872317952408746e-23,  8.692796753303497e-26,  1.120125210820447e-28,
  1.942457508438285e+00, -4.017960874405605e-04, -2.030888835495109e-06, -8.676123773905903e-09, -3.232184666505868e-11, -1.033142815502884e-13, -2.603479595609964e-16,
 -3.325804102405097e-19,  1.419512697111456e-21,  1.442343471929540e-23,  7.734893329528655e-26,  3.121590589403742e-28,  1.968793308116197e+00, -2.216558307999354e-04,
 -1.158739716697314e-06, -5.246896039161870e-09, -2.151604573304481e-11, -8.082886177565981e-14, -2.762556309979446e-16, -8.338028171417414e-19, -2.034713674235440e-21,
 -2.627965795686064e-24,  1.039951791884023e-26,  1.116132020945601e-28,  1.987241028321397e+00, -9.170599206237825e-05, -4.906206835341423e-07, -2.309510968639011e-09,
 -1.006031749496888e-11, -4.139006178098418e-14, -1.622243874021039e-16, -6.070823306949663e-19, -2.163399974956889e-21, -7.280456198141127e-24, -2.272647864939464e-26,
 -6.323529985342331e-29,  1.997571965155446e+00, -1.756734740724172e-05, -9.519346592682565e-08, -4.576599163884816e-10, -2.057950153849501e-12, -8.858806463467088e-15,
 -3.695232182656521e-17, -1.504128052614339e-19, -6.000301003566757e-22, -2.352230963121918e-24, -9.076796960374024e-27, -3.450952685511923e-29,  6.229719974478967e-04,
 -3.499031960759844e-06,  1.473555607452889e-08, -5.514254099329050e-11,  1.933646004452726e-13, -6.505970675703255e-16,  2.126813279886920e-18, -6.805901712313835e-21,
  2.142069676109627e-23, -6.652727513046501e-26,  2.043342226076573e-28, -6.217351751935016e-31,  5.604284522474391e-03, -3.141748778346726e-05,  1.317789106123742e-07,
 -4.897549406441682e-10,  1.699415397375191e-12, -5.632810687823500e-15,  1.804279652457962e-17, -5.621606170718189e-20,  1.709809270834232e-22, -5.086320493506511e-25,
  1.480656132957150e-27, -4.216288814583824e-30,  1.555374297361832e-02, -8.686093565047823e-05,  3.613981786205117e-07, -1.324511496974684e-09,  4.497590189502334e-12,
 -1.444586527817195e-14,  4.427985452975049e-17, -1.298896783725168e-19,  3.639324247358369e-22, -9.674076393354359e-25,  2.403816876236539e-27, -5.411230248920160e-30,
  3.044487879025486e-02, -1.690431224384011e-04,  6.947471123409532e-07, -2.492138160344803e-09,  8.179146077172060e-12, -2.495445215498364e-14,  7.087215294631499e-17,
 -1.853709450333237e-19,  4.332243514393143e-22, -8.327786408732720e-25,  9.089964815851407e-28,  2.204939003783400e-30,  5.023765016775653e-02, -2.767864652098015e-04,
  1.118779476024075e-06, -3.895856549246558e-09,  1.217777896284697e-11, -3.435793610464057e-14,  8.573994591831719e-17, -1.767759443173623e-19,  2.271213025626870e-22,
  3.102837559051662e-25, -3.769641439985189e-27,  1.816965022055051e-29,  7.487803380268145e-02, -4.085245199939817e-04,  1.616521054031427e-06, -5.414274491678276e-09,
  1.582307046608429e-11, -3.962819682591349e-14,  7.761557713493291e-17, -7.141523990595843e-20, -3.090287835048695e-22,  2.333511846680620e-24, -9.848701261345603e-27,
  3.172126362413977e-29,  1.042974782407434e-01, -5.623058029827558e-04,  2.167439109182909e-06, -6.907782753465370e-09,  1.840715631496974e-11, -3.802035619207767e-14,
  3.913733144235351e-17,  1.350975556930800e-19, -1.075438353013625e-21,  4.428287765394264e-24, -1.315130325016180e-26,  2.620500236812055e-29,  1.384122172286890e-01,
 -7.357994342724664e-04,  2.747914484410672e-06, -8.226332744143960e-09,  1.926059284418617e-11, -2.759778779938796e-14, -3.047267404918647e-17,  4.096827365243281e-19,
 -1.811352753892160e-21,  5.299341041218502e-24, -8.995880775102542e-27, -9.277193588942707e-30,  1.771224415799438e-01, -9.263032111592223e-04,  3.331821995932235e-06,
 -9.218415333251556e-09,  1.783232771321223e-11, -7.703834127319172e-15, -1.237406073564299e-16,  6.822557040714651e-19, -2.153621680239524e-21,  3.688306541899621e-24,
  4.760106350266697e-27, -6.698783513610223e-29,  2.203113285582545e-01, -1.130754865982832e-03,  3.891224551879638e-06, -9.740991416413751e-09,  1.376763590685686e-11,
  2.069158894028408e-14, -2.247988852408244e-16,  8.577714185243511e-19, -1.755472216785781e-21, -9.233501131195076e-25,  2.495634606892671e-26, -1.156943343090506e-28,
  2.678439287882559e-01, -1.345747422670552e-03,  4.397185307148324e-06, -9.670038793704078e-09,  6.976940528440987e-12,  5.484012113848237e-14, -3.111080518394765e-16,
  8.392437903221706e-19, -4.381335992447846e-22, -7.711818009092251e-24,  4.244854135253804e-26, -1.113361831536695e-28,  3.195659123682684e-01, -1.567549734813918e-03,
  4.820699840863621e-06, -8.911276830083346e-09, -2.312278738263278e-12,  9.031691034675168e-14, -3.571014372730957e-16,  5.580381159568751e-19,  1.671982343876434e-21,
 -1.433957954446006e-23,  4.483127562125786e-26, -2.314981980078376e-29,  3.753021783710205e-01, -1.792133462248941e-03,  5.133746471496159e-06, -7.410511939199258e-09,
 -1.352860668467622e-11,  1.214148087293624e-13, -3.394438969264306e-16,  4.667376649512770e-21,  4.078122529330817e-21, -1.746906491081685e-23,  2.246990677476294e-26,
  1.358667460811126e-28,  4.348553354889044e-01, -2.015207915238173e-03,  5.310447015025136e-06, -5.162918031745788e-09, -2.576265960345535e-11,  1.418371221069264e-13,
 -2.431745517136794e-16, -7.489423453924914e-19,  5.971191252577148e-21, -1.399208886889747e-23, -2.424615033234953e-26,  2.940735177779946e-28,  4.980040664638781e-01,
 -2.232264353407136e-03,  5.328322129117450e-06, -2.220436093759878e-09, -3.781252307608690e-11,  1.456515170257892e-13, -6.759020692449170e-17, -1.545293749244052e-18,
  6.434247246636408e-21, -2.672533249808362e-24, -8.024008152881191e-26,  3.411433509090405e-28,  5.645013954233979e-01, -2.438631452445147e-03,  5.169614476890287e-06,
  1.303638513241971e-09, -4.827290866498756e-11,  1.284142462706372e-13,  1.695867745970504e-16, -2.162768698359845e-18,  4.768481696646100e-21,  1.443928320456299e-23,
 -1.177964557149574e-25,  1.871397571049850e-28,  6.340728856331811e-01, -2.629543719421042e-03,  4.822638987905727e-06,  5.233890490285814e-09, -5.566844330445787e-11,
  8.831555310298218e-14,  4.313065835708096e-16, -2.364929422177255e-18,  8.558773523194136e-22,  3.164269182900369e-23, -1.073839106998450e-25, -1.617066028858238e-28,
  7.064148057937867e-01, -2.800224612186160e-03,  4.283102401997747e-06,  9.336858831313563e-09, -5.862603883900911e-11,  2.714284282265426e-14,  6.648535222335657e-16,
 -1.971635255898188e-18, -4.578466988328440e-21,  4.093930426154123e-23, -3.482209602258322e-26, -5.584176399695963e-28,  7.811923161484365e-01, -2.945985953726305e-03,
  3.555314339892529e-06,  1.333086715987119e-08, -5.607423017659105e-11, -4.917857923607922e-14,  8.106624165023545e-16, -9.359754612507928e-19, -9.959115668565857e-21,
  3.517091378866514e-23,  8.306190680439714e-26, -7.532462877489658e-28,  8.580377415634173e-01, -3.062344870969472e-03,  2.653190238709401e-06,  1.690226653930342e-08,
 -4.744912448062686e-11, -1.307091445506075e-13,  8.156907592693449e-16,  5.978446185645999e-19, -1.321890034799622e-20,  1.205429242311048e-23,  1.953632436771975e-25,
 -5.297719076563309e-28,  9.365490174810820e-01, -3.145158861283979e-03,  1.600924378488199e-06,  1.972827949015040e-08, -3.287811622553005e-11, -2.044722700115388e-13,
  6.491819400848770e-16,  2.284191150470642e-18, -1.251426053359892e-20, -2.273869204092412e-23,  2.350058686850335e-25,  1.165154293499947e-28,  1.016288416084492e+00,
 -3.190778623342066e-03,  4.331918384532670e-07,  2.150591796076257e-08, -1.330543203822733e-11, -2.563510462756557e-13,  3.170284349402204e-16,  3.635765416094680e-18,
 -7.109767392462999e-21, -5.567801361643083e-23,  1.556069611529096e-25,  8.809118613312064e-28,  1.096781683643252e+00, -3.196216907147143e-03, -8.052740725605611e-07,
  2.198546865061812e-08,  9.479740777647276e-12, -2.737710735658466e-13, -1.301988603677279e-16,  4.157271995540757e-18,  1.931034801635845e-21, -7.003560206062837e-23,
 -2.980493730321227e-26,  1.257945265730099e-27,  1.177517744800117e+00, -3.159329779413349e-03, -2.060881637926648e-06,  2.100583068133860e-08,  3.294835312006278e-11,
 -2.487782018773700e-13, -6.004351607930444e-16,  3.526811350773844e-18,  1.168103235166346e-20, -5.426316563291583e-23, -2.358785341272905e-25,  8.661244143709371e-28,
  1.257949153773083e+00, -3.079004337911004e-03, -3.273289475207180e-06,  1.852766515855074e-08,  5.409243817346491e-11, -1.808523573156823e-13, -9.774745230308573e-16,
  1.765654377908745e-18,  1.820098059407753e-20, -1.034095588121087e-23, -3.395579836067496e-25, -1.947748487127021e-28,  1.337493493474448e+00, -2.955344077456243e-03,
 -4.378506516117032e-06,  1.465909033469195e-08,  6.983952344934244e-11, -7.860758673763643e-14, -1.151377226588361e-15, -6.837093756307774e-19,  1.820213624870066e-20,
  4.344851755679343e-23, -2.560267831445574e-25, -1.266687349377596e-27,  1.415535937760715e+00, -2.789839945076093e-03, -5.312980778144747e-06,  9.667864574781926e-09,
  7.758177011752107e-11,  4.047249869987928e-14, -1.055202073554622e-15, -3.040864139309695e-18,  1.087935511881504e-20,  7.945372666285567e-23, -1.161742867738595e-26,
 -1.531873222906530e-27,  1.491433194763237e+00, -2.585511893632009e-03, -6.018550471656613e-06,  3.974076364996563e-09,  7.573800637630097e-11,  1.528167022409961e-13,
 -6.959623047140758e-16, -4.447789867713082e-18, -1.112201590193863e-21,  7.601023014609155e-23,  2.486395219374484e-25, -6.914875546936799e-28,  1.564519034983178e+00,
 -2.347002891819990e-03, -6.447970552457409e-06, -1.881232099446404e-09,  6.422711756832067e-11,  2.339747589319333e-13, -1.654214838063426e-16, -4.332728253375939e-18,
 -1.242980905186390e-20,  3.283170425771695e-23,  3.487744123446347e-25,  6.534934069104590e-28,  1.634111570648225e+00, -2.080605493107193e-03, -6.570544245759056e-06,
 -7.292996086722200e-09,  4.471024100136167e-11,  2.652578765079781e-13,  3.799353371348130e-16, -2.717407359943612e-18, -1.761584304133468e-20, -2.530782459555830e-23,
  2.171014360430816e-25,  1.409076758405682e-27,  1.699522387275600e+00, -1.794200973375297e-03, -6.377209180953896e-06, -1.167131266668551e-08,  2.047423869878135e-11,
  2.399207664947318e-13,  7.695678114129045e-16, -2.827947747609354e-19, -1.426386245639866e-20, -6.280404635515856e-23, -4.255658591876197e-26,  9.709632803588516e-28,
  1.760067530784874e+00, -1.497093535720999e-03, -5.884292643027802e-06, -1.453360191212246e-08, -4.107276234989439e-12,  1.665306942079124e-13,  8.846725644886774e-16,
  1.905316942339963e-18, -4.736536830389371e-21, -5.805411393382125e-23, -2.264685605549633e-25, -1.570735727141336e-28,  1.815080223601566e+00, -1.199727849862322e-03,
 -5.135111265462765e-06, -1.559452552103993e-08, -2.448757534789997e-11,  6.757335241848899e-14,  7.108957403608766e-16,  2.922767472275270e-18,  5.100907973152153e-21,
 -1.999478455789021e-23, -2.066990865480460e-25, -8.651459163627202e-28,  1.863925025992421e+00, -9.132875784493939e-04, -4.198698077445394e-06, -1.483437929420962e-08,
 -3.705108284288810e-11, -2.719258921263763e-14,  3.488328983141284e-16,  2.486767729070163e-18,  9.698562500571072e-21,  1.938068317033427e-23, -4.295443320129018e-26,
 -6.130054853671129e-28,  1.906012986385873e+00, -6.491852408034363e-04, -3.165227671815343e-06, -1.252656601044537e-08, -4.010914948895547e-11, -9.092192902540234e-14,
 -3.050413900073786e-17,  1.103167836588988e-18,  7.575328256892250e-21,  3.228770888853497e-23,  9.098893086364786e-26,  6.942619973590240e-29,  1.940817157860319e+00,
 -4.184686028666597e-04, -2.138174513612362e-06, -9.210146166792488e-09, -3.445134145498363e-11, -1.096687448292950e-13, -2.689417928126658e-16, -2.782232848048580e-19,
  1.997882992780674e-21,  1.780590765032938e-23,  9.212370799415443e-26,  3.600636373367016e-28,  1.967887737766292e+00, -2.311835771480910e-04, -1.223822545520100e-06,
 -5.604453697380045e-09, -2.320085376921914e-11, -8.774659648892318e-14, -3.005272533641328e-16, -9.003369074147393e-19, -2.120562577532718e-21, -2.104136402752414e-24,
  1.604450921165625e-26,  1.463168681861556e-28,  1.986866174951503e+00, -9.574461478003935e-05, -5.193286244510416e-07, -2.477315922374721e-09, -1.092847092687510e-11,
 -4.549549818279966e-14, -1.802325806525442e-16, -6.806856828188066e-19, -2.442548204551257e-21, -8.247164311707406e-24, -2.565890716479264e-26, -7.009446441762590e-29,
  1.997500137079799e+00, -1.835143635880193e-05, -1.008889550458753e-07, -4.920541857045977e-10, -2.244347531360529e-12, -9.798451424208718e-15, -4.144594147560506e-17,
 -1.710418095448868e-19, -6.916289644663639e-22, -2.747591109143294e-24, -1.074104508999869e-26, -4.135613336455082e-29,  6.092075206394561e-04, -3.383742730165261e-06,
  1.409198800010563e-08, -5.215009297889710e-11,  1.808480496164244e-13, -6.017650324505370e-16,  1.945495402729266e-18, -6.157233630724052e-21,  1.916647646605300e-23,
 -5.887553797003721e-26,  1.788599462005080e-28, -5.383174787557829e-31,  5.480686454011557e-03, -3.038631090635734e-05,  1.260613523245306e-07, -4.634425404558561e-10,
  1.590965081711701e-12, -5.218070420203822e-15,  1.654267297675108e-17, -5.102656663017542e-20,  1.536930018565527e-22, -4.529562364799203e-25,  1.306957143699521e-27,
 -3.691270435699717e-30,  1.521198263759086e-02, -8.403212501745803e-05,  3.459264587594476e-07, -1.254804864736290e-09,  4.219012126228872e-12, -1.342550724949208e-14,
  4.080087930208288e-17, -1.187829673098834e-19,  3.307804104381075e-22, -8.758752280155573e-25,  2.176255217740582e-27, -4.937374470773374e-30,  2.977963594332770e-02,
 -1.636025807826236e-04,  6.656104771109841e-07, -2.365173855067224e-09,  7.696653908949100e-12, -2.331426602881850e-14,  6.587139504477822e-17, -1.719802557297890e-19,
  4.039196628732980e-22, -7.947515948557561e-25,  9.859947764648077e-28,  1.330836898905197e-30,  4.914811330175468e-02, -2.680199696660636e-04,  1.073175945578794e-06,
 -3.706399218737392e-09,  1.151080118450669e-11, -3.235874353073232e-14,  8.089345038234517e-17, -1.693569319049121e-19,  2.357617457658936e-22,  1.745825367118079e-25,
 -3.036950652058948e-27,  1.521236429673518e-29,  7.326939457217692e-02, -3.958479924429178e-04,  1.553042946230392e-06, -5.167345364009835e-09,  1.504896684288791e-11,
 -3.779046097336492e-14,  7.548960790506338e-17, -8.003342575365700e-20, -2.317870165718890e-22,  1.966388192680535e-24, -8.533912477244059e-27,  2.809246747256959e-29,
  1.020824160556504e-01, -5.452929143882037e-04,  2.086287878378344e-06, -6.619299256320118e-09,  1.765642906617800e-11, -3.703941251540662e-14,  4.246152169614286e-17,
  1.031349427328112e-19, -9.252121149412841e-22,  3.925171594125353e-24, -1.200856955914327e-26,  2.564990958265487e-29,  1.355123682625207e-01, -7.142057856755558e-04,
  2.651029175515336e-06, -7.922614856478556e-09,  1.870221969524684e-11, -2.819785465180825e-14, -1.978486258209009e-17,  3.547017440913848e-19, -1.627133486289812e-21,
  4.933338729282013e-24, -9.257825948965567e-27, -2.900571461983620e-30,  1.734698441185699e-01, -9.000862814610983e-04,  3.222907325595849e-06, -8.934485704501216e-09,
  1.765006091892010e-11, -1.045203441981446e-14, -1.055820792185431e-16,  6.154955045781898e-19, -2.018088307485983e-21,  3.823841176221215e-24,  2.114061854430575e-27,
 -5.360791568084228e-29,  2.158498336976936e-01, -1.100088862772020e-03,  3.775667076864644e-06, -9.517683673967691e-09,  1.412942846648571e-11,  1.557825503538562e-14,
 -2.015714171205674e-16,  8.012474076745115e-19, -1.771933997317600e-21, -2.283942547966073e-26,  2.016927283640559e-26, -1.019590346017702e-28,  2.625305619253125e-01,
 -1.311032123586823e-03,  4.281849530028999e-06, -9.550031052840884e-09,  8.000971189181258e-12,  4.765368447004997e-14, -2.878449649693380e-16,  8.210996468433349e-19,
 -6.863736764421054e-22, -6.111474797171689e-24,  3.758351832894050e-26, -1.093052028087397e-28,  3.133721666587292e-01, -1.529412372031534e-03,  4.713600655672551e-06,
 -8.934282829206551e-09, -5.903499790542220e-13,  8.193955787272839e-14, -3.408024736941166e-16,  6.036256684603912e-19,  1.187731746366603e-21, -1.257306705553591e-23,
  4.334788371278848e-26, -4.327276758477385e-29,  3.682152163113706e-01, -1.751422693155059e-03,  5.043600282690740e-06, -7.607985609237938e-09, -1.118169269017181e-11,
  1.132838953192009e-13, -3.375794533105874e-16,  1.252895234576972e-19,  3.466741066552476e-21, -1.646316852558158e-23,  2.752651392009933e-26,  9.490091378409723e-29,
  4.268790689871655e-01, -1.972978953128498e-03,  5.246111350094055e-06, -5.552750492970167e-09, -2.298586806280571e-11,  1.357704085533439e-13, -2.615467604481234e-16,
 -5.660862806848667e-19,  5.453024367595675e-21, -1.471555236897046e-23, -1.223526826860954e-26,  2.517825630109922e-28,  4.891600792222407e-01, -2.189754421566633e-03,
  5.298142699085791e-06, -2.802234651843263e-09, -3.491909932380974e-11,  1.435332892764996e-13, -1.079945998832684e-16, -1.341527442919613e-18,  6.283859513600644e-21,
 -5.584406428483628e-24, -6.543384515443232e-26,  3.301662886328852e-28,  5.548296642440066e-01, -2.397224895687094e-03,  5.180709354056056e-06,  5.520191216550886e-10,
 -4.566873703857592e-11,  1.317753296196811e-13,  1.112372905680146e-16, -2.002752618851157e-18,  5.205605525452506e-21,  9.907096077715115e-24, -1.084723043728715e-25,
  2.339225904521671e-28,  6.236322495597497e-01, -2.590726384808675e-03,  4.880161551982304e-06,  4.357865864434091e-09, -5.380396197003332e-11,  9.787641228807572e-14,
  3.656372609791948e-16, -2.320156261525064e-18,  1.916258396247395e-21,  2.723510677098313e-23, -1.122719191691297e-25, -6.242214076372816e-29,  6.952831241337208e-01,
 -2.765527523233416e-03,  4.389537278897159e-06,  8.404032983246215e-09, -5.792816862828616e-11,  4.242165320972208e-14,  6.078159589955479e-16, -2.094880295885763e-18,
 -3.135378447978266e-21,  3.908443680564517e-23, -5.718050196070568e-26, -4.568041551313068e-28,  7.694662488864099e-01, -2.916918877504424e-03,  3.709872560216640e-06,
  1.242685846496766e-08, -5.686554664672850e-11, -3.007198990603801e-14,  7.801879624730875e-16, -1.233831996114072e-18, -8.641096079980356e-21,  3.783638463215444e-23,
  5.040798568682941e-26, -7.263665784189915e-28,  8.458320792219461e-01, -3.040321138170353e-03,  2.851379512166472e-06,  1.612323558240270e-08, -4.986643081845891e-11,
 -1.109790363498789e-13,  8.265840580349629e-16,  1.832437201997421e-19, -1.265019875399175e-20,  1.937051686041487e-23,  1.697155583976549e-25, -6.303061532524496e-28,
  9.239954831473398e-01, -3.131413756881518e-03,  1.834375281095355e-06,  1.917038152291362e-08, -3.680681425398023e-11, -1.881703581233861e-13,  7.074228169456323e-16,
  1.872458015428034e-18, -1.316295810191744e-20, -1.329555923507925e-23,  2.356958645476259e-25, -8.308888501432338e-29,  1.003533861490881e+00, -3.186284810447682e-03,
  6.898177733535135e-07,  2.125246241249707e-08, -1.834826078770276e-11, -2.475482628776115e-13,  4.153523506956478e-16,  3.377456479251176e-18, -8.993248344972771e-21,
 -4.872847118582090e-23,  1.905792503876301e-25,  7.038426903194202e-28,  1.083985605615554e+00, -3.201601635781087e-03, -5.407195241308894e-07,  2.209321102493616e-08,
  3.982526452651391e-12, -2.754943554076869e-13, -1.331018583558470e-17,  4.178602984457383e-18, -5.983397843843425e-22, -7.011863283799961e-23,  2.560140034544524e-26,
  1.250820424586172e-27,  1.164849060166803e+00, -3.174799973752068e-03, -1.805815264185367e-06,  2.149245116293468e-08,  2.783689385668811e-11, -2.619632667037485e-13,
 -4.967575439874889e-16,  3.867606367646885e-18,  9.567516279177544e-21, -6.287011518141363e-23, -1.929081023967145e-25,  1.080218056259291e-27,  1.245582192291132e+00,
 -3.104286895730373e-03, -3.045888061880987e-06,  1.936295115316229e-08,  5.024513998361554e-11, -2.036531092706523e-13, -9.199568865580307e-16,  2.339496555331964e-18,
  1.758297323832411e-20, -2.400494770763783e-23, -3.413837989115938e-25,  1.149565519718116e-28,  1.325603201799757e+00, -2.989649626164179e-03, -4.195949597169338e-06,
  1.576243879313905e-08,  6.798983655596153e-11, -1.064031756495787e-13, -1.162146099745135e-15, -7.829772859642340e-20,  1.956889564505614e-20,  3.213597388717210e-23,
 -3.083993012894122e-25, -1.101817647225564e-27,  1.404292334906742e+00, -2.831858579122394e-03, -5.189496375961908e-06,  1.091424430548064e-08,  7.813128942041004e-11,
  1.416789475791976e-14, -1.135043731525537e-15, -2.647183721487589e-18,  1.371466479350916e-20,  7.759614986518279e-23, -8.226072284099348e-26, -1.668816857848027e-27,
  1.480995181792921e+00, -2.633448714827213e-03, -5.963492903183913e-06,  5.209385222257381e-09,  7.861721206991269e-11,  1.346177232591329e-13, -8.205740086834273e-16,
 -4.437744379061629e-18,  1.794950114687044e-21,  8.524777415106260e-23,  2.107527690596754e-25, -1.032371827131495e-27,  1.555027738043499e+00, -2.398659131572277e-03,
 -6.464225924380743e-06, -8.164200078037000e-10,  6.885685766415415e-11,  2.285050901371677e-13, -2.921092410570246e-16, -4.708826230684351e-18, -1.099042448797481e-20,
  4.729037453894933e-23,  3.723589430274001e-25,  4.063217052350077e-28,  1.625683483404363e+00, -2.133507343422217e-03, -6.653591414084511e-06, -6.534722560682719e-09,
  5.010008738329875e-11,  2.733987979498667e-13,  2.958317262049875e-16, -3.293892921054777e-18, -1.835545694088445e-20, -1.536117745310353e-23,  2.806890745430564e-25,
  1.471697331590425e-27,  1.692242669366542e+00, -1.845772929655888e-03, -6.515137817327199e-06, -1.130433765544872e-08,  2.545643346078156e-11,  2.582416980953404e-13,
  7.549176170548615e-16, -7.756536816514608e-19, -1.654442188002189e-20, -6.357133366345826e-23,  6.216324030373759e-27,  1.248685017766601e-27,  1.753983902172039e+00,
 -1.544866346225825e-03, -6.058976468612632e-06, -1.457150200265480e-08, -5.601166161776996e-13,  1.883839010331165e-13,  9.355727533458544e-16,  1.718549804359166e-18,
 -6.990736755791316e-21, -6.719852702434312e-23, -2.293479237995981e-25,  3.582999239770906e-29,  1.810197955977874e+00, -1.241563828957867e-03, -5.324548700906316e-06,
 -1.597455983467557e-08, -2.295877219560493e-11,  8.563462092002732e-14,  7.948984112387183e-16,  3.072808272334235e-18,  4.222935382604386e-21, -2.904163893184733e-23,
 -2.460338423479547e-25, -9.185334247807455e-28,  1.860203554818317e+00, -9.475993294269103e-04, -4.380283940345107e-06, -1.543106824276290e-08, -3.750539080743378e-11,
 -1.794934422779253e-14,  4.229095556989819e-16,  2.807897879742118e-18,  1.035841823846477e-20,  1.707645397263699e-23, -7.345240314614570e-26, -7.771234107440613e-28,
  1.903364634176514e+00, -6.751193854406943e-04, -3.319457049701791e-06, -1.318288867932944e-08, -4.193226086094581e-11, -9.125487231949130e-14,  3.958086349981395e-18,
  1.364883474890335e-18,  8.803780541830796e-21,  3.597117070851447e-23,  9.271531690379794e-26,  4.955046078518287e-30,  1.939108359233550e+00, -4.360256257440023e-04,
 -2.252077120682460e-06, -9.779267840212995e-09, -3.670985344728413e-11, -1.162089880293605e-13, -2.757353733083873e-16, -2.032917556213975e-19,  2.709178055646711e-21,
  2.182260356024988e-23,  1.090848633131352e-25,  4.113599922153093e-28,  1.966942987270258e+00, -2.412496178859616e-04, -1.293362477784831e-06, -5.990107410677171e-09,
 -2.502999411282549e-11, -9.526949696354028e-14, -3.266971268753720e-16, -9.692697221184781e-19, -2.183098461002891e-21, -1.321441209556029e-24,  2.340870071406686e-26,
  1.900732292660376e-28,  1.986474694668713e+00, -1.000211981969312e-04, -5.501363551560681e-07, -2.659692402813279e-09, -1.188322734177407e-11, -5.005890432957110e-14,
 -2.004321228304236e-16, -7.638018341748263e-19, -2.758682498048044e-21, -9.337256033790040e-24, -2.889647793929803e-26, -7.706420682798284e-29,  1.997425078833047e+00,
 -1.918279231565849e-05, -1.070157092430066e-07, -5.295872184548595e-10, -2.450664832712097e-12, -1.085321944909782e-14, -4.656044435614142e-17, -1.948431663325278e-19,
 -7.987353543676800e-22, -3.215956727683467e-24, -1.273776104449893e-26, -4.967158118828343e-29,  5.958941263798577e-04, -3.273461738444557e-06,  1.348315919275910e-08,
 -4.935032705879634e-11,  1.692660533068368e-13, -5.570745774977707e-16,  1.781370390751443e-18, -5.576482901459220e-21,  1.717022828987582e-23, -5.217301504181470e-26,
  1.567867593610916e-28, -4.668162493434110e-31,  5.361123571037474e-03, -2.939964038089003e-05,  1.206493991330304e-07, -4.388008947338812e-10,  1.490460996135122e-12,
 -4.837650155370524e-15,  1.518040231315194e-17, -4.635951292922108e-20,  1.382897181867855e-22, -4.037872787179092e-25,  1.154814171905487e-27, -3.234816935731773e-30,
  1.488129518931609e-02, -8.132381647622546e-05,  3.312651340160774e-07, -1.189396657191843e-09,  3.960030852645044e-12, -1.248502966611753e-14,  3.761852296379019e-17,
 -1.086861145588065e-19,  3.007646627035034e-22, -7.930371703721483e-25,  1.968876233276434e-27, -4.494108100879613e-30,  2.913569854410450e-02, -1.583891667085605e-04,
  6.379521560396033e-07, -2.245673390100020e-09,  7.245795109229738e-12, -2.178970350204828e-14,  6.123265756614395e-17, -1.595048899886609e-19,  3.760306762513499e-22,
 -7.543530993155240e-25,  1.028995188023415e-27,  6.526872425810174e-31,  4.809292690803341e-02, -2.596093868339133e-04,  1.029783172422618e-06, -3.527299910564785e-09,
  1.088266106807029e-11, -3.047334713556235e-14,  7.625786259066951e-17, -1.617341792354162e-19,  2.400143532078101e-22,  6.572069158499867e-26, -2.424468125580752e-27,
  1.269518679469549e-29,  7.171046427516939e-02, -3.836676449373597e-04,  1.492454877726706e-06, -4.932510706012985e-09,  1.431108955105127e-11, -3.600637664329067e-14,
  7.315501749360818e-17, -8.638149499349950e-20, -1.668527063583225e-22,  1.648753633061995e-24, -7.371986912265977e-27,  2.477372122919531e-29,  9.993412864370872e-02,
 -5.289155911123115e-04,  2.008527040379498e-06, -6.342666404145374e-09,  1.692604874292885e-11, -3.598890091412281e-14,  4.495539985269824e-17,  7.569853979107287e-20,
 -7.922825037476639e-22,  3.467132981803249e-24, -1.090067024143950e-26,  2.464866713493291e-29,  1.326973665928503e-01, -6.933727937928015e-04,  2.557734525149223e-06,
 -7.627913524577418e-09,  1.813428897792557e-11, -2.855923373953719e-14, -1.055598085317198e-17,  3.054034493850662e-19, -1.456215533579895e-21,  4.562007411260663e-24,
 -9.273273828820537e-27,  1.973065975571510e-30,  1.699203932446071e-01, -8.747270941065981e-04,  3.117380574366416e-06, -8.653889004474710e-09,  1.741703930280813e-11,
 -1.278636756937426e-14, -8.923152333756693e-17,  5.531311311350356e-19, -1.879444104424764e-21,  3.864745154652404e-24,  1.487775055924030e-29, -4.210793043166241e-29,
  2.115091710306899e-01, -1.070336509760274e-03,  3.662820748685106e-06, -9.289375634182567e-09,  1.439440055866553e-11,  1.100335743438353e-14, -1.799293792875826e-16,
  7.446795324844488e-19, -1.759279596464915e-21,  6.981430751533276e-25,  1.597604812199467e-26, -8.875563321989101e-29,  2.573542203859318e-01, -1.277233482539368e-03,
  4.168047507449161e-06, -9.414758504420666e-09,  8.886810688398154e-12,  4.101861971447067e-14, -2.651927311235395e-16,  7.958962856650740e-19, -8.804751047984871e-22,
 -4.703125831852887e-24,  3.286755544669763e-26, -1.047007952133259e-28,  3.073292557095094e-01, -1.492132451247475e-03,  4.606385244558697e-06, -8.931056687491468e-09,
  9.680380725574809e-13,  7.396700520298518e-14, -3.234345337077633e-16,  6.347216340789289e-19,  7.658100279964050e-22, -1.088186905036689e-23,  4.110682487294474e-26,
 -5.772910058077563e-29,  3.612896408660236e-01, -1.711441946284827e-03,  4.951304358103727e-06, -7.769206061285358e-09, -8.996687205075357e-12,  1.052360816121072e-13,
 -3.326057861865737e-16,  2.269624701467312e-19,  2.894793311145586e-21, -1.528939915981317e-23,  3.090484708027410e-26,  5.959959627052415e-29,  4.190706603899039e-01,
 -1.931282642377661e-03,  5.177360190655723e-06, -5.899147214269407e-09, -2.033441517961052e-11,  1.293223070960061e-13, -2.750344135464497e-16, -4.001391913336507e-19,
  4.917011667979854e-21, -1.499582751726776e-23, -2.084351610710227e-27,  2.098112932548197e-28,  4.804856057268047e-01, -2.147513068038336e-03,  5.261257891613070e-06,
 -3.338128104787450e-09, -3.207727824552163e-11,  1.405131849725467e-13, -1.427758604206732e-16, -1.144137596972532e-18,  6.039162284447204e-21, -7.916523952575051e-24,
 -5.131760683440923e-26,  3.102196549876695e-28,  5.453236806927324e-01, -2.355764944685646e-03,  5.183036775072341e-06, -1.574702884146209e-10, -4.301097716597923e-11,
  1.337912233036823e-13,  5.754009513258749e-17, -1.831283398830680e-18,  5.486735938613823e-21,  5.784214423886092e-24, -9.744812406125702e-26,  2.646577615319692e-28,
  6.133477373423444e-01, -2.551490397748268e-03,  4.927356844863192e-06,  3.513117537941528e-09, -5.176390335379990e-11,  1.058799380953983e-13,  3.016725631453741e-16,
 -2.244019082135902e-18,  2.815466918228430e-21,  2.271572641546525e-23, -1.130677328873578e-25,  2.396585049445371e-29,  6.842918631907174e-01, -2.730023518350363e-03,
  4.484855081266485e-06,  7.484742210969660e-09, -5.693866405990831e-11,  5.629530230078148e-14,  5.479628202911159e-16, -2.173178671427815e-18, -1.774071487122521e-21,
  3.642613077010561e-23, -7.496764445973685e-26, -3.515568185415417e-28,  7.578588538902172e-01, -2.886658914405275e-03,  3.853519183906508e-06,  1.151320327334508e-08,
 -5.728269576306901e-11, -1.179202159187156e-14,  7.419766422743449e-16, -1.488225886386922e-18, -7.250272526747695e-21,  3.922727433389325e-23,  1.951933995783814e-26,
 -6.738934465331273e-28,  8.337176227450802e-01, -3.016749912114215e-03,  3.040001409928132e-06,  1.530869483931286e-08, -5.188744928122399e-11, -9.112450237063439e-14,
  8.261614466258038e-16, -2.091506192553031e-19, -1.183755181535154e-20,  2.558266353859348e-23,  1.404156414949073e-25, -6.956871418149842e-28,  9.115006205700503e-01,
 -3.115828867713787e-03,  2.060765247553432e-06,  1.855230468134737e-08, -4.039644083554017e-11, -1.706110393284147e-13,  7.538955954350870e-16,  1.445394199641625e-18,
 -1.347328406275011e-20, -3.996106588519602e-24,  2.279462109285676e-25, -2.656482904311251e-28,  9.908013669834125e-01, -3.179751513389297e-03,  9.429243482644335e-07,
  2.091985568538921e-08, -2.319205615771549e-11, -2.364790675356186e-13,  5.056392618643440e-16,  3.063133346513910e-18, -1.060331676666600e-20, -4.054376087972598e-23,
  2.171900885732505e-25,  5.027248152260091e-28,  1.071172227621379e+00, -3.204866253264690e-03, -2.754004432538884e-07,  2.211287470642571e-08, -1.521099073693267e-12,
 -2.744142755705655e-13,  1.030451881518916e-16,  4.119372253640531e-18, -3.091043138176172e-21, -6.800885556111130e-23,  7.941481023758033e-26,  1.185998687627245e-27,
  1.152122610813174e+00, -3.188207688782064e-03, -1.545408400436743e-06,  2.189531698488193e-08,  2.248734818022935e-11, -2.725534780744847e-13, -3.845286346750593e-16,
  4.136160653547355e-18,  7.177240632229066e-21, -6.958301614051166e-23, -1.415236985956949e-25,  1.246633349444296e-27,  1.233117800959843e+00, -3.127711229123413e-03,
 -2.808847347970181e-06,  2.013311267637332e-08,  4.595691898371004e-11, -2.248833160506964e-13, -8.467224305977204e-16,  2.885704885639930e-18,  1.647507406982687e-20,
 -3.746503154873714e-23, -3.292856687822361e-25,  4.352203912437561e-28,  1.313578691929358e+00, -3.022442304220933e-03, -4.000348441287230e-06,  1.683173677193220e-08,
  6.558305032212169e-11, -1.342492473826315e-13, -1.155415156179057e-15,  5.639453442862558e-19,  2.049263742471522e-20,  1.889484695299648e-23, -3.519390491824201e-25,
 -8.660636141152629e-28,  1.392882728149350e+00, -2.872829402894973e-03, -5.051020350765042e-06,  1.216510742617943e-08,  7.813650016590419e-11, -1.391046143438325e-14,
 -1.202606123084433e-15, -2.164399354020389e-18,  1.643096361605776e-20,  7.281201653906126e-23, -1.574303980108293e-25, -1.735115200623236e-27,  1.470366397410210e+00,
 -2.680885026222440e-03, -5.893347761638504e-06,  6.487687328904380e-09,  8.110260975045687e-11,  1.134422470183976e-13, -9.435542972814975e-16, -4.329671159752035e-18,
  5.003742722211704e-21,  9.266822899250418e-23,  1.577803576108107e-25, -1.373843640219644e-27,  1.545329638750064e+00, -2.450393053434814e-03, -6.467263250809735e-06,
  3.214240969365499e-10,  7.334597529422657e-11,  2.198742379745445e-13, -4.286034785823978e-16, -5.030376210145798e-18, -9.016365972141287e-21,  6.245318251218050e-23,
  3.834462583340213e-25,  8.577838702826643e-29,  1.617042519718420e+00, -2.187035696282131e-03, -6.727016872192101e-06, -5.689024148058551e-09,  5.563124750461327e-11,
  2.793252076667719e-13,  1.953125296061112e-16, -3.887821649996170e-18, -1.869070986132804e-20, -2.834342365116830e-24,  3.456227311713576e-25,  1.467302327531825e-27,
  1.684754486613972e+00, -1.898429317370148e-03, -6.648172446113911e-06, -1.085474012338812e-08,  3.080037032769262e-11,  2.760371664710012e-13,  7.254443542669605e-16,
 -1.341531770405926e-18, -1.881450548980265e-20, -6.213946817209099e-23,  6.747148757611234e-26,  1.535999512989063e-27,  1.747706385902003e+00, -1.594037448073594e-03,
 -6.233759935061265e-06, -1.454908658092017e-08,  3.435856177804108e-12,  2.113875029014956e-13,  9.801840340331470e-16,  1.454376509725379e-18, -9.574002948481952e-21,
 -7.627067633904926e-23, -2.224066732495318e-25,  2.903042934865353e-28,  1.805145285180386e+00, -1.284933105177912e-03, -5.518387503989646e-06, -1.632713258812178e-08,
 -2.104826046418329e-11,  1.057588805864957e-13,  8.826577420284303e-16,  3.189235196168023e-18,  2.990465068021787e-21, -3.970031811499719e-23, -2.870556647851064e-25,
 -9.396595142354593e-28,  1.856341885763015e+00, -9.833925172562628e-04, -4.569067262296303e-06, -1.603344750457057e-08, -3.775631517700557e-11, -6.818059119605890e-15,
  5.062592397540654e-16,  3.148566199668273e-18,  1.091156068787305e-20,  1.340106712480627e-23, -1.116787873230108e-25, -9.640652783463924e-28,  1.900610027137677e+00,
 -7.023193646768536e-04, -3.481737385477128e-06, -1.386838688932680e-08, -4.375314311513860e-11, -9.066822080980895e-14,  4.631869174141761e-17,  1.668038582433455e-18,
  1.016532674025305e-20,  3.965916596653623e-23,  9.101093437105471e-26, -8.763418243560754e-29,  1.937327465939867e+00, -4.545218116284810e-04, -2.373030348177119e-06,
 -1.038558024187117e-08, -3.910061694112987e-11, -1.228843897216328e-13, -2.800895131078325e-16, -1.031497684111265e-19,  3.577836744248817e-21,  2.656358609626317e-23,
  1.283521154855664e-25,  4.645739746868672e-28,  1.965956829944926e+00, -2.518909986461550e-04, -1.367710929540077e-06, -6.406265819017581e-09, -2.701603062566643e-11,
 -1.034438337931682e-13, -3.548204712938069e-16, -1.039692051854730e-18, -2.211663023504248e-21, -2.025570538096171e-25,  3.293508998113334e-26,  2.449754641248277e-28,
  1.986065600891958e+00, -1.045532643357906e-04, -5.832273596256686e-07, -2.858102283382168e-09, -1.293429434225530e-11, -5.513620682630888e-14, -2.231066266498019e-16,
 -8.576877681905100e-19, -3.116464800720852e-21, -1.056295127103688e-23, -3.243760365340799e-26, -8.382822514372275e-29,  1.997346594200494e+00, -2.006502165770150e-05,
 -1.136133846809686e-07, -5.705969939843933e-10, -2.679361026512572e-12, -1.203913624479440e-14, -5.239201787378133e-17, -2.223578662094486e-19, -9.242332683820104e-22,
 -3.772013345671900e-24, -1.513874683568657e-26, -5.979407587914855e-29,  5.830123232487889e-04, -3.167920072155501e-06,  1.290684452204424e-08, -4.672893122419649e-11,
  1.585397568545920e-13, -5.161349920116146e-16,  1.632647173871775e-18, -5.055915899689162e-21,  1.540010802538081e-23, -4.629359560332637e-26,  1.376311446560015e-28,
 -4.054285571317024e-31,  5.245422613833791e-03, -2.845510945215712e-05,  1.155237427401541e-07, -4.157081800908872e-10,  1.397248674707808e-12, -4.488410360177895e-15,
  1.394216643268419e-17, -4.215817933945757e-20,  1.245516486195039e-22, -3.603204308544301e-25,  1.021420202940293e-27, -2.837621494550044e-30,  1.456121126743664e-02,
 -7.872972797884973e-05,  3.173644530919229e-07, -1.127985729199995e-09,  3.719117715422907e-12, -1.161764193006019e-14,  3.470586857120805e-17, -9.950361438438115e-20,
  2.735863882615058e-22, -7.181134655438650e-25,  1.780307296993171e-27, -4.082442792134162e-30,  2.851218117995240e-02, -1.533914035357256e-04,  6.116855450404759e-07,
 -2.133148667869262e-09,  6.824342041732248e-12, -2.037237844415752e-14,  5.693095674234030e-17, -1.478984257041395e-19,  3.496202554788859e-22, -7.127823479446245e-25,
  1.045757641194842e-27,  1.325512319950145e-31,  4.707070193534115e-02, -2.515375174474407e-04,  9.884805144930841e-07, -3.357955152837908e-09,  1.029113369157533e-11,
 -2.869663168243121e-14,  7.183706037248832e-17, -1.540335287983454e-19,  2.407632934471115e-22, -2.074092974545398e-26, -1.914170259823571e-27,  1.055833033178794e-29,
  7.019930352672722e-02, -3.719609279271244e-04,  1.434615156378067e-06, -4.709199731840077e-09,  1.360832041649817e-11, -3.428023088395651e-14,  7.067011500117847e-17,
 -9.082593389302105e-20, -1.125510126862269e-22,  1.374767044480780e-24, -6.349259718452038e-27,  2.176434086652634e-29,  9.785012709722367e-02, -5.131472732103101e-04,
  1.934016383274238e-06, -6.077548556008122e-09,  1.621721737734120e-11, -3.488728912765013e-14,  4.673819273747144e-17,  5.226051493742960e-20, -6.750561200335680e-22,
  3.052431440530201e-24, -9.843900106233063e-27,  2.334703496114055e-29,  1.299642263548924e-01, -6.732721683995944e-04,  2.467921568633734e-06, -7.342345328704358e-09,
  1.756123694364799e-11, -2.871507819975241e-14, -2.632888314121510e-18,  2.613609192183520e-19, -1.298628473634476e-21,  4.193963595050956e-24, -9.102494274701438e-27,
  5.604507436913005e-30,  1.664707119234045e-01, -8.501987189147870e-04,  3.015197140266542e-06, -8.377373407162325e-09,  1.714111630944129e-11, -1.474873966466581e-14,
 -7.456494589890258e-17,  4.952116855209295e-19, -1.740721587591237e-21,  3.831280914879825e-24, -1.616951945180053e-27, -3.233806105986916e-29,  2.072857296787023e-01,
 -1.041475903288808e-03,  3.552736624818576e-06, -9.057532340728323e-09,  1.457294082609568e-11,  6.928930546922770e-15, -1.598618951073797e-16,  6.889006358111755e-19,
 -1.723550916707934e-21,  1.262795032278980e-24,  1.234688167810446e-26, -7.635574930581516e-29,  2.523112631861992e-01, -1.244338533536512e-03,  4.055949511897883e-06,
 -9.266344847837136e-09,  9.645324834125796e-12,  3.491808392722684e-14, -2.433257839404274e-16,  7.652569125643075e-19, -1.027217262815508e-21, -3.478783428073961e-24,
  2.839624904103215e-26, -9.830123316244935e-29,  3.014337498246658e-01, -1.455709686985752e-03,  4.499352964620146e-06, -8.904149028284817e-09,  2.371206253523642e-12,
  6.642026127674916e-14, -3.053759049617301e-16,  6.532717793559630e-19,  4.030181617512325e-22, -9.291555329457119e-24,  3.833877051301651e-26, -6.736562637419703e-29,
  3.545225002435829e-01, -1.672206723257381e-03,  4.857278260626690e-06, -7.896746658876024e-09, -6.971224239484066e-12,  9.733976976632700e-14, -3.250349878710756e-16,
  3.110323224909103e-19,  2.367174538816487e-21, -1.400989156878974e-23,  3.285451885315945e-26,  2.993690607651653e-29,  4.114279116960453e-01, -1.890152256657449e-03,
  5.104702501552244e-06, -6.204168428717485e-09, -1.781479504095808e-11,  1.226043153540629e-13, -2.841166607794409e-16, -2.514311696239971e-19,  4.377776479969039e-21,
 -1.490656225592980e-23,  6.254954419318882e-27,  1.696460329801913e-28,  4.719794678455070e-01, -2.105591747756193e-03,  5.218213042437741e-06, -3.829079129654672e-09,
 -2.930376396371939e-11,  1.367236948545100e-13, -1.721516846642856e-16, -9.558142283965183e-19,  5.720441887311442e-21, -9.703609145121044e-24, -3.822887527976292e-26,
  2.838641719696499e-28,  5.359835212870617e-01, -2.314319704279657e-03,  5.177106576288950e-06, -8.241813697259839e-10, -4.032539317134206e-11,  1.345768804825720e-13,
  8.748292040769563e-18, -1.653105297015935e-18,  5.627666012169877e-21,  2.124988254849247e-24, -8.539401991546138e-26,  2.810517000222274e-28,  6.032208607957376e-01,
 -2.511916829741262e-03,  4.964616017710577e-06,  2.702208084870770e-09, -4.957893690352621e-11,  1.123769944122156e-13,  2.402180909115039e-16, -2.141709349605214e-18,
  3.552283039960023e-21,  1.823636946630177e-23, -1.103757790250852e-25,  9.594879553606100e-29,  6.734440738931152e-01, -2.693800807282657e-03,  4.569245288769729e-06,
  6.583424589130640e-09, -5.568620379600226e-11,  6.871099718378256e-14,  4.865118793067622e-16, -2.209574667041758e-18, -5.201546266733829e-22,  3.314884523212048e-23,
 -8.814094359733309e-26, -2.478691129768795e-28,  7.463747275306314e-01, -2.855293719780194e-03,  3.986173795957853e-06,  1.059574633239111e-08, -5.734396703794209e-11,
  5.490465768397132e-15,  6.972712375423050e-16, -1.697545829981441e-18, -5.831002290165157e-21,  3.943508796441694e-23, -8.600593215862196e-27, -6.014853418540862e-28,
  8.217004064813970e-01, -2.991709328391685e-03,  3.218667893133524e-06,  1.446499029500958e-08, -5.351235240774432e-11, -7.140881860599212e-14,  8.151478374630242e-16,
 -5.721932636981231e-19, -1.082296279142102e-20,  3.057559038949607e-23,  1.090074317582928e-25, -7.263799641062004e-28,  8.990716714722986e-01, -3.098463475817587e-03,
  2.279405462063519e-06,  1.787965982408794e-08, -4.362470065081763e-11, -1.520806826142098e-13,  7.883213740934496e-16,  1.013681297442967e-18, -1.345628407494130e-20,
  4.839537636498731e-24,  2.126871222601660e-25, -4.232975700803835e-28,  9.780990282543753e-01, -3.171210628792049e-03,  1.191582316714802e-06,  2.051163394420255e-08,
 -2.779354055535805e-11, -2.233541417385794e-13,  5.864494732980088e-16,  2.702190258436773e-18, -1.190175093119196e-20, -3.147609624427972e-23,  2.346371008712132e-25,
  2.892695548515753e-28,  1.058350035647014e+00, -3.206008868606679e-03, -1.037254384058332e-08,  2.204480419467687e-08, -6.975378281072792e-12, -2.705704970221869e-13,
  2.166397134853362e-16,  3.981999137133592e-18, -5.469883437398612e-21, -6.381967117050390e-23,  1.291844524782602e-25,  1.068052568989495e-27,  1.139346725652811e+00,
 -3.199514281553308e-03, -1.280687212088940e-06,  2.221104438710152e-08,  1.695349673141613e-11, -2.803688133969827e-13, -2.658844726621520e-16,  4.324769528477954e-18,
  4.583913770433586e-21, -7.411050150291933e-23, -8.405910114494103e-26,  1.355198114058365e-27,  1.220563561790271e+00, -3.149203467072132e-03, -2.562990053568938e-06,
  2.083136645036363e-08,  4.126288632809506e-11, -2.441768197669875e-13, -7.587625007747869e-16,  3.388828365710581e-18,  1.489471260250774e-20, -5.016028222958405e-23,
 -3.031986044594225e-25,  7.477255072372277e-28,  1.301426221251973e+00, -3.053619543611930e-03, -3.792165094275740e-06,  1.785808574515146e-08,  6.262243003910343e-11,
 -1.617150944934367e-13, -1.130361504387532e-15,  1.227806595840259e-18,  2.091102680319432e-20,  4.138878400414438e-24, -3.836823294557648e-25, -5.673657828141905e-28,
  1.381311548723908e+00, -2.912632418846822e-03, -4.897552272008132e-06,  1.341147805103279e-08,  7.756507377946656e-11, -4.343845734225762e-14, -1.255463705672372e-15,
 -1.598033686856462e-18,  1.892042458316414e-20,  6.498666459823795e-23, -2.337084346920033e-25, -1.717288703770572e-27,  1.459549088165794e+00, -2.727698175178661e-03,
 -5.807638888598736e-06,  7.802208596565326e-09,  8.313528870476202e-11,  8.936339093681001e-14, -1.062033921812274e-15, -4.115080487103565e-18,  8.437949533426462e-21,
  9.767389398829202e-23,  9.016886325825016e-26, -1.693914027944181e-27,  1.535424643353159e+00, -2.502095450641688e-03, -6.456221773644301e-06,  1.529532232678586e-09,
  7.762902702909079e-11,  2.078671282434416e-13, -5.731342318834367e-16, -5.279965780773729e-18, -6.492051810891129e-21,  7.775671935269678e-23,  3.788970757139193e-25,
 -3.030778893023133e-28,  1.608186334221523e+00, -2.241109346679144e-03, -6.789759486629006e-06, -4.754015695470577e-09,  6.125545975092332e-11,  2.826388189178055e-13,
  7.808449546699066e-17, -4.484763498131245e-18, -1.852850435006798e-20,  1.226230482955934e-23,  4.085630832333913e-25,  1.378276128582804e-27,  1.677053586013284e+00,
 -1.952126921110264e-03, -6.775287281136065e-06, -1.031683629371266e-08,  3.649181740988255e-11,  2.929269980282608e-13,  6.791207714476784e-16, -1.978730179514009e-18,
 -2.098589558970768e-20, -5.800526400498587e-23,  1.412822013183076e-25,  1.816222465366699e-27,  1.741229391973699e+00, -1.644604619477869e-03, -6.407875439530202e-06,
 -1.445899953190109e-08,  7.901959023605237e-12,  2.353633728921033e-13,  1.016192575270243e-15,  1.102389773502585e-18, -1.247599555822452e-20, -8.482198784388612e-23,
 -2.028235423469319e-25,  6.109665989123899e-28,  1.799916009836547e+00, -1.329869464318065e-03, -5.716260115455971e-06, -1.664580181059856e-08, -1.871396182206263e-11,
  1.280236611213637e-13,  9.730649304200063e-16,  3.259765898011360e-18,  1.344635494727655e-21, -5.200584163637073e-23, -3.280358676275977e-25, -9.140367655194158e-28,
  1.852333977569282e+00, -1.020724936475286e-03, -4.765095516466975e-06, -1.663794858521092e-08, -3.776382750589668e-11,  6.429949910253407e-15,  5.993733543622972e-16,
  3.504506480776695e-18,  1.130282669445972e-20,  8.025883444703868e-24, -1.585900345017048e-25, -1.171252575434183e-27,  1.897743970901086e+00, -7.308509845279857e-04,
 -3.652417930245327e-06, -1.458286713674205e-08, -4.555141227528161e-11, -8.895800930441062e-14,  9.779742947455584e-17,  2.016865747676757e-18,  1.165734300710310e-20,
  4.318764775949836e-23,  8.448178915568949e-26, -2.156429446064451e-28,  1.935470605639793e+00, -4.740153867943960e-04, -2.501493259198642e-06, -1.103121758956399e-08,
 -4.162568941790091e-11, -1.296273388560375e-13, -2.812237729367390e-16,  2.767343354858666e-20,  4.631608461168448e-21,  3.212215222567405e-23,  1.499604771453123e-25,
  5.172776581006493e-28,  1.964926885113962e+00, -2.631476954925095e-04, -1.447249457391160e-06, -6.855546050072771e-09, -2.917246356151670e-11, -1.123168561120467e-13,
 -3.849218296672553e-16, -1.110305476560808e-18, -2.192472137803882e-21,  1.349515758630802e-24,  4.516742314794354e-26,  3.135171552393672e-28,  1.985637833901394e+00,
 -1.093598759890302e-04, -6.188036343902455e-07, -3.074172089513047e-09, -1.409256906974171e-11, -6.079057859250970e-14, -2.485770547885253e-16, -9.637566471149422e-19,
 -3.520992074984546e-21, -1.193608311609077e-23, -3.626331894121761e-26, -8.990352640122013e-29,  1.997264471880764e+00, -2.100206493117142e-05, -1.207259403334383e-07,
 -6.154635300218098e-10, -2.933239963491194e-12, -1.337472872613034e-14, -5.905337280702467e-17, -2.542282313431883e-19, -1.071590875034503e-21, -4.433639233516119e-24,
 -1.803244113348932e-26, -7.214475630432210e-29,  5.705436609358157e-04, -3.066865952792406e-06,  1.236098328207385e-08, -4.427279489113492e-11,  1.485977069170447e-13,
 -4.785960635590916e-16,  1.497737614069737e-18, -4.588748958390442e-21,  1.382848162440060e-23, -4.112901159375485e-26,  1.209823909441901e-28, -3.526392099620536e-31,
  5.133419489782434e-03, -2.755050015746662e-05,  1.106664759152664e-07, -3.940525597619735e-10,  1.310733250464766e-12, -4.167524844997590e-15,  1.281564133146975e-17,
 -3.837242363457977e-20,  1.122864105207764e-22, -3.218554357871732e-25,  9.043483724216285e-28, -2.491678501518306e-30,  1.425128586507947e-02, -7.624396143851666e-05,
  3.041781360500183e-07, -1.070294341786554e-09,  3.494873624259677e-12, -1.081716841492405e-14,  3.203854362727602e-17, -9.114908381924018e-20,  2.489738779204497e-22,
 -6.503795765068902e-25,  1.609155385535837e-27, -3.702353024077171e-30,  2.790824299555164e-02, -1.485984845810193e-04,  5.867296887756018e-07, -2.027145923333947e-09,
  6.430228902979284e-12, -1.905448854774769e-14,  5.294263070607998e-17, -1.371130630910283e-19,  3.247132977727432e-22, -6.709594072616848e-25,  1.042528569735284e-27,
 -2.606413034540097e-31,  4.608011624423679e-02, -2.437880990079614e-04,  9.491543611872089e-07, -3.197796250065112e-09,  9.734097098976049e-12, -2.702342809547599e-14,
  6.763177101295537e-17, -1.463549525189325e-19,  2.387452875086710e-22, -8.857108001920695e-26, -1.490510408007644e-27,  8.748921483142479e-30,  6.873406091598752e-02,
 -3.607063983116292e-04,  1.379388829535206e-06, -4.496860159703780e-09,  1.293946871766902e-11, -3.261502859890957e-14,  6.808366738005457e-17, -9.368289305944382e-20,
 -6.740757026662811e-23,  1.139130501905855e-24, -5.452298804353821e-27,  1.905498133986963e-29,  9.582802653082351e-02, -4.979625060220953e-04,  1.862619826538133e-06,
 -5.823593642750054e-09,  1.553079509357716e-11, -3.375035510349182e-14,  4.791505147807043e-17,  3.234290864329548e-20, -5.720125003372411e-22,  2.678792973187967e-24,
 -8.848875464251057e-27,  2.185840310403272e-29,  1.273100730941037e-01, -6.538764954270625e-04,  2.381480346961934e-06, -7.065960977969871e-09,  1.698687256714801e-11,
 -2.869500908244731e-14,  4.125631645584711e-18,  2.221507935825039e-19, -1.154132410057514e-21,  3.835632496559649e-24, -8.795027134158298e-27,  8.220907098943263e-30,
  1.631175300734751e-01, -8.264746163594095e-04,  2.916304170028178e-06, -8.105567974448984e-09,  1.682933707759919e-11, -1.637807475779639e-14, -6.145823144472460e-17,
  4.417002996267207e-19, -1.604279426386963e-21,  3.740668344610998e-24, -2.853928008829609e-27, -2.413184931350729e-29,  2.031759870873142e-01, -1.013484798792978e-03,
  3.445449154537658e-06, -8.823458671757635e-09,  1.467468298928000e-11,  3.317528572437646e-15, -1.413373513377003e-16,  6.345633300388492e-19, -1.669978784343985e-21,
  1.692914990338817e-24,  9.242346207229139e-27, -6.492970898148344e-29,  2.473981037732627e-01, -1.212333047415746e-03,  3.945701362777104e-06, -9.106742836872523e-09,
  1.028700426739082e-11,  2.933156892986372e-14, -2.223760963430171e-16,  7.305930675984061e-19, -1.133031021709426e-21, -2.427279965419623e-24,  2.423399734515150e-26,
 -9.074786474730341e-29,  2.956822250492588e-01, -1.420141519051426e-03,  4.392773376593276e-06, -8.855974455093605e-09,  3.627809140377011e-12,  5.931189755089284e-14,
 -2.869519529130938e-16,  6.611064819320588e-19,  9.539375482091918e-23, -7.819208763082113e-24,  3.523759117872182e-26, -7.300252851373505e-29,  3.479107871646460e-01,
 -1.633729291966927e-03,  4.761910942941892e-06, -7.993132620021460e-09, -5.101689526555604e-12,  8.965153971927100e-14, -3.153395892046113e-16,  3.789679659019024e-19,
  1.886721965572571e-21, -1.267688966663815e-23,  3.361883853899357e-26,  5.664356809200792e-30,  4.039484997944122e-01, -1.849617098413087e-03,  5.028621972954610e-06,
 -6.469961062196393e-09, -1.543138726320472e-11,  1.157163708856534e-13, -2.892757384694123e-16, -1.198662889894621e-19,  3.847340228961195e-21, -1.451828821842880e-23,
  1.288707417472033e-26,  1.323564379506527e-28,  4.636402902726058e-01, -2.064037603520844e-03,  5.169540418035262e-06, -4.276296779129250e-09, -2.661266876022982e-11,
  1.322912532227480e-13, -1.964062061857367e-16, -7.786205817200254e-19,  5.346518109635627e-21, -1.099170460706878e-23, -2.639803454494478e-26,  2.533963321312601e-28,
  5.268089983221206e-01, -2.272953176327704e-03,  5.163433977683973e-06, -1.447859322587803e-09, -3.763539982853781e-11,  1.342517934698265e-13, -3.501052075883577e-17,
 -1.472430907521782e-18,  5.645682076913566e-21, -1.041424066473337e-24, -7.289707488584964e-26,  2.851399950614120e-28,  5.932528138902035e-01, -2.472083508334443e-03,
  4.992358065146342e-06,  1.927218507406523e-09, -4.727853322126130e-11,  1.174360356828745e-13,  1.819343252894780e-16, -2.018374896071021e-18,  4.130503898956319e-21,
  1.392364750899144e-23, -1.048448798714436e-25,  1.529932519333268e-28,  6.627424576881329e-01, -2.656945878781732e-03,  4.642947855032612e-06,  5.704052444323210e-09,
 -5.420023744833481e-11,  7.964406215995435e-14,  4.245851947673858e-16, -2.207825894428421e-18,  6.073820673184663e-22,  2.943443155774369e-23, -9.686668868080733e-26,
 -1.500193970607876e-28,  7.350181147072284e-01, -2.822911316976536e-03,  4.107824255058872e-06,  9.680014052788810e-09, -5.707076607547492e-11,  2.163482330616649e-14,
  6.473403219063035e-16, -1.861539998767265e-18, -4.423687088516092e-21,  3.858637496958061e-23, -3.320505520434876e-26, -5.150793145906650e-28,  8.097861465101992e-01,
 -2.965280322737641e-03,  3.387066887656826e-06,  1.359842406021853e-08, -5.474638887221776e-11, -5.207561767460664e-14,  7.944488507431175e-16, -9.001376590626251e-19,
 -9.651478662429889e-21,  3.429492501705519e-23,  7.697175721042309e-26, -7.247314188172225e-28,  8.867156298623803e-01, -3.079382098807715e-03,  2.489676389575220e-06,
  1.715836845299286e-08, -4.647506872128864e-11, -1.328688119046980e-13,  8.107137100562723e-16,  5.874708703866322e-19, -1.313378075783055e-20,  1.293476673553585e-23,
  1.911488778227693e-25, -5.503079843438556e-28,  9.654347988265436e-01, -3.160701306077408e-03,  1.434908875978438e-06,  2.003199030055420e-08, -3.211397357435427e-11,
 -2.084154368967744e-13,  6.566215074458347e-16,  2.305036495826801e-18, -1.286346141894798e-20, -2.189939296532868e-23,  2.426381369230798e-25,  7.526893709579130e-29,
  1.045527506398776e+00, -3.205036004904069e-03,  2.533179114032122e-07,  2.189022688680619e-08, -1.232587460889936e-11, -2.640550563007650e-13,  3.253474193025024e-16,
  3.771289321913969e-18, -7.663458247029522e-21, -5.775749115569900e-23,  1.727344144475059e-25,  9.048146735092446e-28,  1.126529871516274e+00, -3.208689465975991e-03,
 -1.012713197125894e-06,  2.243713604954950e-08,  1.129219189523981e-11, -2.852828282497140e-13, -1.431423637935184e-16,  4.428235976437908e-18,  1.869954470373868e-21,
 -7.626246513211341e-23, -2.321650867010370e-26,  1.399451339445757e-27,  1.207927338612697e+00, -3.168696635818959e-03, -2.309216690356360e-06,  2.145154812260927e-08,
  3.620520376790835e-11, -2.611963647003398e-13, -6.574902322689670e-16,  3.834295742330669e-18,  1.287936233381896e-20, -6.154348791643804e-23, -2.638760645271228e-25,
  1.033797742844807e-27,  1.289152449361483e+00, -3.083082898269205e-03, -3.571967783445257e-06,  1.883270926907759e-08,  5.912001703377964e-11, -1.883555826341572e-13,
 -1.086613751900806e-15,  1.896338483412186e-18,  2.077865909008688e-20, -1.160819288694577e-23, -4.011311159177320e-25, -2.188929043445782e-28,  1.369583707168954e+00,
 -2.951148065109549e-03, -4.729202299319325e-06,  1.464391799828591e-08,  7.639173151436823e-11, -7.403601576558005e-14, -1.291394303463557e-15, -9.570984005262488e-19,
  2.107368624278643e-20,  5.415283686251955e-23, -3.071745272672953e-25, -1.606237564755259e-27,  1.448545998302182e+00, -2.773762040833606e-03, -5.705977009546341e-06,
  9.145247881354546e-09,  8.465850693410420e-11,  6.252569160132896e-14, -1.172943269868707e-15, -3.788260777458564e-18,  1.200038896226268e-20,  9.970510041183645e-23,
  9.391022702146600e-27, -1.968169962044301e-27,  1.525313108466353e+00, -2.553650381337029e-03, -6.430280367156547e-06,  2.804057385148516e-09,  8.163673244666226e-11,
  1.923170532098237e-13, -7.234402272454567e-16, -5.440032130063112e-18, -3.424372755016580e-21,  9.251832654559943e-23,  3.559359827888475e-25, -7.486337239956307e-28,
  1.599112923466901e+00, -2.295638523784811e-03, -6.840740398934872e-06, -3.728648200231928e-09,  6.691646085479443e-11,  2.829394907498976e-13, -5.570012769699036e-17,
 -5.067342549997565e-18, -1.777870433014896e-20,  2.976969754730042e-23,  4.654277063391682e-25,  1.188765136159364e-27,  1.669135904259797e+00, -2.006814050823719e-03,
 -6.895389956574816e-06, -9.685233549049931e-09,  4.250845837807819e-11,  3.084832716688926e-13,  6.140094251673135e-16, -2.682438205315589e-18, -2.295239750528886e-20,
 -5.067877676972854e-23,  2.268760924789994e-25,  2.067596752636849e-27,  1.734547352121715e+00, -1.696559139228598e-03, -6.580465186981627e-06, -1.429357528630292e-08,
  1.285536759564123e-11,  2.600744083833098e-13,  1.041000359046450e-15,  6.527936862947623e-19, -1.566815441904848e-20, -9.228794180675965e-23, -1.676491838789107e-25,
  9.987684393076152e-28,  1.794503799817460e+00, -1.376403430932121e-03, -5.917717586722028e-06, -1.692344143991362e-08, -1.591254241562373e-11,  1.524755406051356e-13,
  1.064640811522527e-15,  3.270228929797275e-18, -7.732703529355303e-22, -6.591057316255429e-23, -3.665519801132273e-25, -8.246618883944011e-28,  1.848173557329203e+00,
 -1.059654578880145e-03, -4.968369358474191e-06, -1.724032534927812e-08, -3.748321848948141e-11,  2.203351624792165e-14,  7.025973067592800e-16,  3.869490882076948e-18,
  1.146456787395605e-20,  5.870653796220209e-25, -2.149684096055040e-25, -1.393192771721324e-27,  1.894761002309337e+00, -7.607828298658152e-04, -3.831843516325506e-06,
 -1.532577550922231e-08, -4.730230279486386e-11, -8.588959175173844e-14,  1.597304205675080e-16,  2.415407696667293e-18,  1.327021592898644e-20,  4.633008041271967e-23,
  7.139013172114745e-26, -3.873732971276867e-28,  1.933533665580895e+00, -4.945683529133082e-04, -2.637950676914501e-06, -1.171833513140303e-08, -4.428557589310606e-11,
 -1.363495522162794e-13, -2.781915950619468e-16,  1.955903674178681e-19,  5.901597560980559e-21,  3.859050566009925e-23,  1.738107240755736e-25,  5.657305109460183e-28,
  1.963850605887692e+00, -2.750628663078644e-04, -1.532392350751894e-06, -7.340788814139704e-09, -3.151374083049662e-11, -1.219359125928892e-13, -4.169826578226297e-16,
 -1.179310192403314e-18, -2.107830597346210e-21,  3.455848044564226e-24,  6.076871225434021e-26,  3.986312560850279e-28,  1.985190254366129e+00, -1.144617930573593e-04,
 -6.570877834983993e-07, -3.309713240892669e-09, -1.537029245704062e-11, -6.709338929235538e-14, -2.772062846447122e-16, -1.083591360195974e-18, -3.977767932125691e-21,
 -1.346723783387674e-23, -4.032854876153417e-26, -9.457345630987502e-29,  1.997178484076953e+00, -2.199823338674358e-05, -1.284021772776285e-07, -6.646148235370116e-10,
 -3.215504607475993e-12, -1.488145784780842e-14, -6.667686053768171e-17, -2.912185838724502e-19, -1.244988363192966e-21, -5.222649803987198e-24, -2.152802213308190e-26,
 -8.724916617282048e-29,  5.584706642428842e-04, -2.970063477104781e-06,  1.184366545905153e-08, -4.196989670324628e-11,  1.393750881308958e-13, -4.441435121411004e-16,
  1.375231700022306e-18, -4.169023382437793e-21,  1.243133236730705e-23, -3.658616371447859e-26,  1.064910277746014e-28, -3.071725294490244e-31,  5.024958699877111e-03,
 -2.668373258141702e-05,  1.060609781761857e-07, -3.737312782687102e-10,  1.230373532696422e-12, -3.872447021521707e-15,  1.178982446065266e-17, -3.495787455153274e-20,
  1.013251649337106e-22, -2.877824070863373e-25,  8.014988838307617e-28, -2.190098636857338e-30,  1.395109684782284e-02, -7.386097604780516e-05,  2.916631054835884e-07,
 -1.016066184298693e-09,  3.286017342920938e-12, -1.007799036834917e-14,  2.959447647690826e-17, -8.354442799442136e-20,  2.266805052739151e-22, -5.891664316438822e-25,
  1.454045520094107e-27, -3.353088747083996e-30,  2.732308510073770e-02, -1.440002295735612e-04,  5.630088838211605e-07, -1.927243226338299e-09,  6.061540365544713e-12,
 -1.782878326842425e-14,  4.924536248745517e-17, -1.271006899567010e-19,  3.013057620056422e-22, -6.295800772716320e-25,  1.024316209515520e-27, -5.522809165307724e-31,
  4.511991096992068e-02, -2.363457511735446e-04,  9.116977259523011e-07, -3.046287630956331e-09,  9.209532676807182e-12, -2.544858089175706e-14,  6.364023306775080e-17,
 -1.387769024653382e-19,  2.345720318748071e-22, -1.409612446884413e-25, -1.140125031093105e-27,  7.220514396191584e-30,  6.731296868675808e-02, -3.498836664300048e-04,
  1.326647455835786e-06, -4.294959179470236e-09,  1.230329464879079e-11, -3.101270535268630e-14,  6.543622194286320e-17, -9.522429223997552e-20, -3.012918450723085e-23,
  9.370732660256253e-25, -4.668218688207364e-27,  1.663055899673364e-29,  9.386554172754552e-02, -4.833369064215989e-04,  1.794205587067090e-06, -5.580438225033053e-09,
  1.486735063719065e-11, -3.259150833683429e-14,  4.857841266580081e-17,  1.551503369078313e-20, -4.817195618356670e-22,  2.343610512582016e-24, -7.921826559202909e-27,
  2.026964244177890e-29,  1.247321402504232e-01, -6.351592419202324e-04,  2.298300639314774e-06, -6.798754797122422e-09,  1.641444533930755e-11, -2.852539941993182e-14,
  9.849081186815337e-18,  1.873607266066356e-19, -1.022289485676242e-21,  3.491648103249965e-24, -8.391125917420481e-27,  1.001758565042027e-29,  1.598576828806047e-01,
 -8.035286980771620e-04,  2.820641912807056e-06, -7.838995112498199e-09,  1.648799792739242e-11, -1.771033849336948e-14, -4.978926422082554e-17,  3.924940013496622e-19,
 -1.471906787430320e-21,  3.607376088024989e-24, -3.761072316009429e-27, -1.731735948553141e-29,  1.991765101360101e-01, -9.863407361843611e-04,  3.340978028849775e-06,
 -8.588311310117794e-09,  1.470852082529666e-11,  1.326655051596259e-16, -1.243080892734895e-16,  5.821650795481816e-19, -1.603039243287287e-21,  2.008599320741561e-24,
  6.617336719432042e-27, -5.456865371107029e-29,  2.426112146996072e-01, -1.181201719370296e-03,  3.837426439487785e-06, -8.937740815429452e-09,  1.082190087497881e-11,
  2.423585060513293e-14, -2.024389354878115e-16,  6.931173797406132e-19, -1.203905305437252e-21, -1.535398340103960e-24,  2.041979260859110e-26, -8.255626927771927e-29,
  2.900712718019355e-01, -1.385423344294151e-03,  4.286887903781525e-06, -8.788807493883122e-09,  4.746678726103324e-12,  5.264727687372637e-14, -2.684386497835885e-16,
  6.599209100779501e-19, -1.615095493252895e-22, -6.474864529992360e-24,  3.196220605301818e-26, -7.540453644114630e-29,  3.414514513110563e-01, -1.596018928831530e-03,
  4.665561437470463e-06, -8.060822883707174e-09, -3.383447230778988e-12,  8.221713280177544e-14, -3.039499906548494e-16,  4.323008380899281e-19,  1.454564110988242e-21,
 -1.133317362302712e-23,  3.342656341282900e-26, -1.362057479009411e-29,  3.966299919384365e-01, -1.809702704664302e-03,  4.949576175406189e-06, -6.698726751611143e-09,
 -1.318668801588754e-11,  1.087469109627929e-13, -2.909861868660906e-16, -5.003672025605100e-21,  3.335270704450049e-21, -1.389653061081164e-23,  1.795523403015868e-26,
  9.864559177824936e-29,  4.554665175503634e-01, -2.022893581684517e-03,  5.115756503665515e-06, -4.681196061864799e-09, -2.401564875737942e-11,  1.273348483837358e-13,
 -2.158731588832771e-16, -6.140457751298356e-19,  4.934410855682653e-21, -1.183413861235761e-23, -1.596131595251310e-26,  2.207929876297849e-28,  5.177996763397346e-01,
 -2.231725234884456e-03,  5.142535088310559e-06, -2.028604737501425e-09, -3.496200066923924e-11,  1.329371648177284e-13, -7.371882715188500e-17, -1.292907220140513e-18,
  5.558719585358369e-21, -3.707499795968338e-24, -6.045088997716783e-26,  2.791093600487441e-28,  5.834444861367263e-01, -2.432064817136117e-03,  5.011024172477399e-06,
  1.189770043370883e-09, -4.489064689182985e-11,  1.211396559865346e-13,  1.273399584294194e-16, -1.878974156481461e-18,  4.558014159835221e-21,  9.878002063047096e-24,
 -9.712878112081858e-26,  1.953804236845918e-28,  6.521893741977919e-01, -2.619543119336817e-03,  4.706247562790324e-06,  4.850124387475001e-09, -5.251044770023008e-11,
  8.909542570872308e-14,  3.631920777004415e-16, -2.172194535580812e-18,  1.595932734250257e-21,  2.545461670223513e-23, -1.014774869261373e-25, -6.128176465254543e-29,
  7.237929084434531e-01, -2.789599567229801e-03,  4.218522594418506e-06,  8.771169505781106e-09, -5.648700716480369e-11,  3.653079084457415e-14,  5.934421432408055e-16,
 -1.981171273054176e-18, -3.063698110068264e-21,  3.683234034530676e-23, -5.380710805117757e-26, -4.204874337181760e-28,  7.979802306511303e-01, -2.937546026768680e-03,
  3.544961283998398e-06,  1.271517651834539e-08, -5.559945046722555e-11, -3.334503076359053e-14,  7.651106150588025e-16, -1.188698871877921e-18, -8.369066842831008e-21,
  3.674299230064249e-23,  4.565175524950236e-26, -6.945837799328380e-28,  8.744392222213713e-01, -3.058653922291973e-03,  2.691030948690234e-06,  1.639457025853552e-08,
 -4.893678471504558e-11, -1.132613025884733e-13,  8.213592010265259e-16,  1.760667813361107e-19, -1.253661414919240e-20,  2.006655221079600e-23,  1.647632567829316e-25,
 -6.432614445155350e-28,  9.528164618332182e-01, -3.148269545659017e-03,  1.672075095427903e-06,  1.948569758633803e-08, -3.611970856710932e-11, -1.919292041308393e-13,
  7.152945533553240e-16,  1.882667653493355e-18, -1.347689926473899e-20, -1.218863906028450e-23,  2.414162688624582e-25, -1.282329237872036e-28,  1.032713073864370e+00,
 -3.201962481791375e-03,  5.146445448586674e-07,  2.165122371708911e-08, -1.752049025795656e-11, -2.550091477921968e-13,  4.272076495575121e-16,  3.494198405893919e-18,
 -9.609272005775257e-21, -5.010805337329426e-23,  2.082931432238674e-25,  7.067030697205015e-28,  1.113680619226779e+00, -3.215711552179348e-03, -7.425722900002064e-07,
  2.257202145564216e-08,  5.562248569207235e-12, -2.872261361570796e-13, -1.872732949031725e-17,  4.444088538763070e-18, -8.773777198608385e-22, -7.596135574722697e-23,
  3.810936598083864e-26,  1.377159234389182e-27,  1.195217248292601e+00, -3.186131249620697e-03, -2.048497478466686e-06,  2.198821991074158e-08,  3.083240674528783e-11,
 -2.756433528579171e-13, -5.447070564422648e-16,  4.209042694952594e-18,  1.048545761298065e-20, -7.111379669122335e-23, -2.128746884820599e-25,  1.275846770209747e-27,
  1.276764419882917e+00, -3.110738885258397e-03, -3.340428602553440e-06,  1.974709510294796e-08,  5.509680524496794e-11, -2.137225045139112e-13, -1.024292413767725e-15,
  2.551460253083008e-18,  2.007063008575575e-20, -2.773571728336157e-23, -4.024716207315554e-25,  1.615640797652375e-28,  1.357704589781721e+00, -2.988258120404242e-03,
 -4.546196017281578e-06,  1.585264824342453e-08,  7.459930701646259e-11, -1.052731484712218e-13, -1.308476664565891e-15, -2.540549287667035e-19,  2.278547050793349e-20,
  4.050648623845976e-23, -3.736306251146804e-25, -1.398642995554951e-27,  1.437360382166970e+00, -2.818947772971640e-03, -5.588070602428526e-06,  1.050822334385330e-08,
  8.561916093886733e-11,  3.314890582232394e-14, -1.273099277631078e-15, -3.346919132919611e-18,  1.557505402604936e-20,  9.828292288169883e-23, -8.198347164080243e-26,
 -2.171482710481318e-27,  1.514995867289366e+00, -2.604935538393516e-03, -6.388670820730751e-06,  4.140020495234144e-09,  8.529705928048686e-11,  1.731174284498871e-13,
 -8.767753601718441e-16, -5.493646464120089e-18,  1.533483969133546e-22,  1.059566197569451e-22,  3.124539585041987e-25, -1.232165492381398e-27,  1.589820660410155e+00,
 -2.350524791460567e-03, -6.878873826874782e-06, -2.612836524751590e-09,  7.255006233575083e-11,  2.798368939632204e-13, -2.053632779789395e-16, -5.615422984308236e-18,
 -1.635999911712983e-20,  4.935248067411861e-23,  5.115122246145188e-25,  8.867127781182808e-28,  1.660997602687286e+00, -2.062430025422453e-03, -7.007325828039926e-06,
 -8.954967274185102e-09,  4.881896645808878e-11,  3.222335840850700e-13,  5.283577447031088e-16, -3.444172629559694e-18, -2.459097869740447e-20, -3.972155901593414e-23,
  3.224155357699599e-25,  2.263549271479817e-27,  1.727654747278879e+00, -1.749885051519176e-03, -6.750577914393003e-06, -1.404491487942586e-08,  1.830787039083450e-11,
  2.852179857619644e-13,  1.051751094421887e-15,  9.705419465922079e-20, -1.909947589029692e-20, -9.798664325802826e-23, -1.140027977440811e-25,  1.449357332748645e-27,
  1.788902210637489e+00, -1.424561584089833e-03, -6.122221272292517e-06, -1.715222668725984e-08, -1.260012505808077e-11,  1.791206255238266e-13,  1.155483514489185e-15,
  3.204621542127842e-18, -3.418324095554432e-21, -8.125436368037360e-23, -3.993858742519985e-25, -6.524845309701237e-28,  1.843854120497544e+00, -1.100239225170868e-03,
 -5.178834039300807e-06, -1.783557771258647e-08, -3.686493469873428e-11,  4.023741357631000e-14,  8.160698090573770e-16,  4.234911740425938e-18,  1.131554236644969e-20,
 -9.304605428904272e-24, -2.812721337446201e-25, -1.620470740181054e-27,  1.891655378400315e+00, -7.921862105284282e-04, -4.020349790982484e-06, -1.609612252224046e-08,
 -4.897602658183313e-11, -8.119493963504715e-14,  2.335613496866879e-16,  2.867254896247230e-18,  1.498483525934715e-20,  4.878286008754792e-23,  4.961458943881559e-26,
 -6.119082571076591e-28,  1.931512277083080e+00, -5.162466936888707e-04, -2.782913273514056e-06, -1.244908077301247e-08, -4.707877340631697e-11, -1.429377590901652e-13,
 -2.698524449764589e-16,  4.080608828206679e-19,  7.422112282463700e-21,  4.605310550429984e-23,  1.996019778779686e-25,  6.044228665992294e-28,  1.962725265894744e+00,
 -2.876831236460186e-04, -1.623589405681117e-06, -7.865073521344568e-09, -3.405524843515925e-11, -1.323472339116050e-13, -4.509253963979458e-16, -1.244265033215775e-18,
 -1.935174949372008e-21,  6.266747058856242e-24,  8.054112743464316e-26,  5.037115717701113e-28,  1.984721636211488e+00, -1.198816466631872e-04, -6.983253718433393e-07,
 -3.566744919902621e-09, -1.678122361510662e-11, -7.412526973750799e-14, -3.094040345629410e-16, -1.218956595142512e-18, -4.492636246642668e-21, -1.516447996383900e-23,
 -4.454991762718675e-26, -9.679622913121608e-29,  1.997088384932538e+00, -2.305825013255094e-05, -1.366963547827578e-07, -7.185337328179952e-10, -3.529820720515518e-12,
 -1.658423368245757e-14, -7.541823053870957e-17, -3.342404678903537e-19, -1.449475786769077e-21, -6.165726627480268e-24, -2.576057776010588e-26, -1.057645325809457e-28,
  5.467767719140707e-04, -2.877291462091141e-06,  1.135311927480259e-08, -3.980920384862976e-11,  1.308130454084056e-13, -4.124949797501414e-16,  1.263875989615622e-18,
 -3.791497978388508e-21,  1.118775645370173e-23, -3.258487031452668e-26,  9.385918911527240e-29, -2.679525943954305e-31,  4.919892806452004e-03, -2.585285498362552e-05,
  1.016918117875652e-07, -3.546498456655298e-10,  1.155676719410423e-12, -3.600880044670114e-15,  1.085488321536915e-17, -3.187522801452687e-20,  9.151958733043235e-23,
 -2.575696801544901e-25,  7.110534695060654e-28, -1.926950272176380e-30,  1.366024357423480e-02, -7.157556365577608e-05,  2.797792403321524e-07, -9.650645749166967e-10,
  3.091374885625526e-12, -9.394993387744491e-15,  2.735367517847896e-17, -7.661906924120232e-20,  2.064827499350721e-22, -5.338591397280796e-25,  1.313647211913578e-27,
 -3.033411292293078e-30,  2.675594814652033e-02, -1.395870441273492e-04,  5.404523107361113e-07, -1.833048160522104e-09,  5.716500865767095e-12, -1.668853153980168e-14,
  4.581817694528696e-17, -1.178136876392241e-19,  2.793719082191667e-22, -5.891607268453092e-25,  9.951179932628158e-28, -7.630719746122284e-31,  4.418888709711462e-02,
 -2.291959243285043e-04,  8.760098586974886e-07, -2.902925200164990e-09,  8.715524331580335e-12, -2.396700111356902e-14,  5.985874591525390e-17, -1.313599954379270e-19,
  2.287494749843470e-22, -1.806074691902866e-25, -8.515628664698417e-28,  5.932539437893923e-30,  6.593433862644231e-02, -3.394733449172323e-04,  1.276268867504650e-06,
 -4.102984077221126e-09,  1.169852883094741e-11, -2.947431041833443e-14,  6.276126648257909e-17, -9.568331879636759e-20,  4.146991678524046e-25,  7.643255629642430e-25,
 -3.984882296321324e-27,  1.447245030661550e-29,  9.196048292221554e-02, -4.692471279674174e-04,  1.728646289157848e-06, -5.347711792580157e-09,  1.422720579820429e-11,
 -3.142207946542985e-14,  4.880928081191245e-17,  1.390486814981578e-21, -4.028427020306445e-22,  2.044097561773367e-24, -7.065651176412515e-27,  1.864611838334857e-29,
  1.222277656337045e-01, -6.170947555734190e-04,  2.218272588057509e-06, -6.540673173765895e-09,  1.584670744447817e-11, -2.822965101413510e-14,  1.465563590439720e-17,
  1.565947585470474e-19, -9.025220118388673e-22,  3.165197317079540e-24, -7.923104931345952e-27,  1.116055025088987e-29,  1.566881088906629e-01, -7.813353771280312e-04,
  2.728144930107224e-06, -7.578082082706608e-09,  1.612270490882201e-11, -1.877860634243578e-14, -3.943953842732760e-17,  3.474404120177784e-19, -1.344916960058482e-21,
  3.443422968992120e-24, -4.395872418907129e-27, -1.172514363729223e-29,  1.952839557751190e-01, -9.600211510031758e-04,  3.239329888503585e-06, -8.353110409383705e-09,
  1.468263087658937e-11, -2.660849233237580e-15, -1.087144202354122e-16,  5.320713359316554e-19, -1.526518134931324e-21,  2.228078979736609e-24,  4.424125499217310e-27,
 -4.530353132661023e-29,  2.379471315789136e-01, -1.150928340700627e-03,  3.731227610585475e-06, -8.760970126148778e-09,  1.125958183743575e-11,  1.960580466077139e-14,
 -1.835782245277690e-16,  6.538587041526876e-19, -1.245330303426039e-21, -7.887814524245372e-25,  1.697245811781594e-26, -7.413004191266272e-29,  2.845975026072528e-01,
 -1.351548734946204e-03,  4.181911525465236e-06, -8.704780844698047e-09,  5.736691787607465e-12,  4.642569196719738e-14, -2.500665409898318e-16,  6.512633306465316e-19,
 -3.723928751501175e-22, -5.262853382473425e-24,  2.863945276784110e-26, -7.526299359694064e-29,  3.351414108184915e-01, -1.559082154712053e-03,  4.568559742817163e-06,
 -8.102195443544685e-09, -1.811046497559860e-12,  7.507247801645384e-14, -2.912534260028544e-16,  4.725755773782783e-19,  1.070449545862802e-21, -1.001275967061648e-23,
  3.248643378968093e-26, -2.841659586257357e-29,  3.894698603864886e-01, -1.770431058093576e-03,  4.867996076552269e-06, -6.892693536624226e-09, -1.108153744315121e-11,
  1.017731644847301e-13, -2.897062616995129e-16,  9.386714584503523e-20,  2.848886491060160e-21, -1.310056224710003e-23,  2.162657203190605e-26,  6.890696442175974e-29,
  4.474564305876155e-01, -1.982198567630268e-03,  5.057359762583266e-06, -5.045359894624340e-09, -2.152206347440415e-11,  1.219650184232430e-13, -2.309206422020243e-16,
 -4.630658945139957e-19,  4.499142176582215e-21, -1.228804933559582e-23, -6.975486827972918e-27,  1.876876420860784e-28,  5.089548886277879e-01, -2.190691635489255e-03,
  5.114922873772418e-06, -2.566834879776213e-09, -3.232377890582040e-11,  1.307534570500069e-13, -1.074531770157991e-16, -1.117606578646759e-18,  5.384652720249452e-21,
 -5.883525064164356e-24, -4.845227808888031e-26,  2.651511439538749e-28,  5.737964766834723e-01, -2.391931539926659e-03,  5.021072352799774e-06,  4.910505020056438e-10,
 -4.244146721721578e-11,  1.235812636522380e-13,  7.681888644073567e-17, -1.728160412660454e-18,  4.845848516359199e-21,  6.174172841039809e-24, -8.785418953395607e-26,
  2.240282853523427e-28,  6.417868503091895e-01, -2.581674477305868e-03,  4.759468333335025e-06,  4.024665529954883e-09, -5.064626630909974e-11,  9.708876771210997e-14,
  3.032177601478136e-16, -2.107250076861097e-18,  2.438802218026926e-21,  2.136524166228194e-23, -1.024276591890619e-25,  1.608051002709243e-29,  7.127026515333421e-01,
 -2.755445674344074e-03,  4.318380440841538e-06,  7.873977121709581e-09, -5.561851064214787e-11,  5.009785987755318e-14,  5.367929847350573e-16, -2.058444051832205e-18,
 -1.780673212961735e-21,  3.433866453578463e-23, -7.016660239404387e-26, -3.230680312720169e-28,  7.862877108690968e-01, -2.908591175335109e-03,  3.692187046883913e-06,
  1.182123596508296e-08, -5.608557167738813e-11, -1.541080801488836e-14,  7.282787282266412e-16, -1.435051569644059e-18, -7.020687920104491e-21,  3.797211810338654e-23,
  1.619665570744638e-26, -6.408338907774085e-28,  8.622488900047929e-01, -3.036352211329068e-03,  2.882996580057624e-06,  1.559453181663637e-08, -5.100471652970297e-11,
 -9.353414414602266e-14,  8.207900098078870e-16, -2.123311458878904e-19, -1.170259240642141e-20,  2.607146268303815e-23,  1.350616280105762e-25, -7.010311444717049e-28,
  9.402516035182692e-01, -3.133967741559189e-03,  1.902312369422328e-06,  1.887802336240308e-08, -3.978260540186654e-11, -1.741786301322500e-13,  7.619188389063127e-16,
  1.446235550690036e-18, -1.374374074442394e-20, -2.700563089094309e-24,  2.316507815699072e-25, -3.116466551579234e-28,  1.019915096508776e+00, -3.196811216099499e-03,
  7.726108502273173e-07,  2.133068410694798e-08, -2.251040497302469e-11, -2.436184685335093e-13,  5.204808644079226e-16,  3.159504515814059e-18, -1.125627541396190e-20,
 -4.121821566021251e-23,  2.345887503797653e-25,  4.858584149527649e-28,  1.100807608895410e+00, -3.220567597070551e-03, -4.713635896321024e-07,  2.261507904893775e-08,
 -1.767165913397794e-13, -2.861880642598071e-13,  1.049057599095564e-16,  4.372670269622647e-18, -3.570127541025795e-21, -7.324608609978256e-23,  9.702195062490076e-26,
  1.290464034285577e-27,  1.182441629720864e+00, -3.201455831869135e-03, -1.781863042885244e-06,  2.243676590558638e-08,  2.519854181248200e-11, -2.872665899508046e-13,
 -4.225523067023621e-16,  4.502085798182590e-18,  7.786161808224633e-21, -7.844746052907195e-23, -1.524746754534131e-25,  1.458799613422016e-27,  1.264269538981566e+00,
 -3.136499800593018e-03, -3.098319481994857e-06,  2.059313829155173e-08,  5.058268244902639e-11, -2.373766896158329e-13, -9.440320277738488e-16,  3.174658352510807e-18,
  1.878512577974062e-20, -4.357728166170313e-23, -3.867551522947031e-25,  5.526930266147011e-28,  1.345680051386289e+00, -3.023846641521832e-03, -4.348877715174843e-06,
  1.702768627831084e-08,  7.217966459864757e-11, -1.366783172261139e-13, -1.305184329167570e-15,  4.954118440780140e-19,  2.396059377363597e-20,  2.441246161050320e-23,
 -4.288796606691450e-25, -1.097998687695002e-27,  1.425996013500832e+00, -2.863124615212076e-03, -5.453736066675688e-06,  1.188174281453866e-08,  8.596930925846525e-11,
  1.529519705921644e-15, -1.359309089302879e-15, -2.792728751146289e-18,  1.903081109146695e-20,  9.305308775933116e-23, -1.803019545733474e-25, -2.280132185201729e-27,
  1.504474254135542e+00, -2.655822727724468e-03, -6.330691645869900e-06,  5.531276673628475e-09,  8.853654030019994e-11,  1.502331170954163e-13, -1.029938783528568e-15,
 -5.425410939844354e-18,  4.178358259724348e-21,  1.172244350086395e-22,  2.473224981152825e-25, -1.727897010423118e-27,  1.580308329105004e+00, -2.405661041269209e-03,
 -6.903079382873821e-06, -1.407583918778443e-09,  7.808447899961056e-11,  2.729640200214088e-13, -3.696287427143246e-16, -6.106497464262804e-18, -1.420665138017726e-20,
  7.047813186457530e-23,  5.417068676921862e-25,  4.661338991859825e-28,  1.652635104192506e+00, -2.118904697615101e-03, -7.109884002077616e-06, -8.121651863226279e-09,
  5.538216779162042e-11,  3.336667795378876e-13,  4.207080661340571e-16, -4.251277196456297e-18, -2.576443885781726e-20, -2.479329594034600e-23,  4.248028999023197e-25,
  2.373589447399061e-27,  1.720546138025664e+00, -1.804558408566618e-03, -6.917166651479598e-06, -1.370498295262875e-08,  2.426449962105509e-11,  3.104202708858798e-13,
  1.045376232837745e-15, -5.713161160220549e-19, -2.269239763726439e-20, -1.011267479113997e-22, -3.934425440283208e-26,  1.951305353802579e-27,  1.783104700724570e+00,
 -1.474365806180134e-03, -6.329134421424467e-06, -1.732363238769496e-08, -8.733204179371846e-12,  2.079138076568691e-13,  1.243219472883128e-15,  3.045297449272370e-18,
 -6.637309034039928e-21, -9.773116318009816e-23, -4.224525461235280e-25, -3.773544915524314e-28,  1.839368932681784e+00, -1.142535964199972e-03, -5.396369889890701e-06,
 -1.841787347881311e-08, -3.585451503582464e-11,  6.128654567178335e-14,  9.396500358733495e-16,  4.589334818596121e-18,  1.076027899798944e-20, -2.204698742661804e-23,
 -3.574381502039215e-25, -1.838612275486836e-27,  1.888421065689387e+00, -8.251350655146125e-04, -4.218257484922860e-06, -1.689239728186631e-08, -5.053708074848664e-11,
 -7.457024941551495e-14,  3.208241087417404e-16,  3.375194241693103e-18,  1.676953596087661e-20,  5.014939452949552e-23,  1.662463794501878e-26, -8.986657500668817e-28,
  1.929401799198259e+00, -5.391205807107204e-04, -2.936917271994170e-06, -1.322555868879390e-08, -5.000122228290880e-11, -1.492486826552948e-13, -2.548411046907266e-16,
  6.736885068821321e-19,  9.230220562276537e-21,  5.457688462308700e-23,  2.267418000167527e-25,  6.255083794575326e-28,  1.961547944876757e+00, -3.010588304954122e-04,
 -1.721328878332886e-06, -8.431733028851085e-09, -3.681327239705144e-11, -1.435942822695309e-13, -4.865931656058720e-16, -1.301913732434336e-18, -1.645915900449637e-21,
  9.967728029050979e-24,  1.054461755521045e-25,  6.326011414186803e-28,  1.984230658750361e+00, -1.256441332374162e-04, -7.427875703753167e-07, -3.847519907085553e-09,
 -1.834083671609933e-11, -8.197729828931663e-14, -3.456320907017144e-16, -1.371807948393308e-18, -5.071659046143364e-21, -1.703150029036219e-23, -4.878884391046409e-26,
 -9.508047930836613e-29,  1.996993908792257e+00, -2.418729656439257e-05, -1.456688954537187e-07, -7.777659660726473e-10, -3.880391811648523e-12, -1.851202975613922e-14,
 -8.546117011859123e-17, -3.843834999530961e-19, -1.691168384253210e-21, -7.295579314357690e-24, -3.089763283486427e-26, -1.285144679931770e-28,  5.354462798934530e-04,
 -2.788342384990209e-06,  1.088769987600165e-08, -3.778058160542617e-11,  1.228580815032797e-13, -3.833965029494085e-16,  1.162554847319151e-18, -3.451556499823094e-21,
  1.007953309704559e-23, -2.905596887864549e-26,  8.283256914572168e-29, -2.340704016471067e-31,  4.818081938795564e-03, -2.505603472070711e-05,  9.754462705979814e-08,
 -3.367213018004997e-10,  1.086193672133865e-12, -3.350750364855645e-15,  1.000202183566223e-17, -2.908963363558858e-20,  8.273924455249214e-23, -2.307533523064828e-25,
  6.314363183867642e-28, -1.697123568469118e-30,  1.337834561109727e-02, -6.938282603096313e-05,  2.684891503072925e-07, -9.170708227008068e-10,  2.909869912556580e-12,
 -8.763519951181707e-15,  2.529802708316358e-17, -7.030923852427797e-20,  1.881782837418133e-22, -4.838948361302541e-25,  1.186691886486355e-27, -2.741770066016698e-30,
  2.620611005749729e-02, -1.353498820488216e-04,  5.189936929767627e-07, -1.744195668473248e-09,  5.393464534727908e-12, -1.562748980820400e-14,  4.264141814489599e-17,
 -1.092055294331713e-19,  2.588700767193602e-22, -5.500748567068122e-25,  9.581079823629703e-28, -9.098603201370000e-31,  4.328590223458734e-02, -2.223248511747810e-04,
  8.419958778726637e-07, -2.767234710977982e-09,  8.250256732418968e-12, -2.257370724246601e-14,  5.628212434786733e-17, -1.241501258003167e-19,  2.216943370136501e-22,
 -2.097818473248389e-25, -6.150389766305601e-28,  4.849729368037312e-30,  6.459655815569643e-02, -3.294569994868193e-04,  1.228136926916321e-06, -3.920442575464580e-09,
  1.112388842850041e-11, -2.800016376345876e-14,  6.008624358501461e-17, -9.525934968009927e-20,  2.520945844867428e-23,  6.170860488474130e-25, -3.391019076515205e-27,
  1.256011976011297e-29,  9.011075172567419e-02, -4.556708253683076e-04,  1.665819026976412e-06, -5.125040397339128e-09,  1.361047434315095e-11, -3.025158011769181e-14,
  4.867842382911152e-17, -1.037605006327764e-20, -3.341490749441614e-22,  1.777403869382337e-24, -6.280764915657819e-27,  1.703593176937319e-29,  1.197943879103871e-01,
 -5.996582596546144e-04,  2.141287228157625e-06, -6.291622054472562e-09,  1.528597050629322e-11, -2.782846030882722e-14,  1.865265887415677e-17,  1.294770156906125e-19,
 -7.941591505536966e-22,  2.858312560085849e-24, -7.416566330355328e-27,  1.178938443212825e-29,  1.536058479198792e-01, -7.598696091129504e-04,  2.638743173143368e-06,
 -7.323171588745751e-09,  1.573843063536227e-11, -1.961316520065080e-14, -3.029534125511569e-17,  3.063516212085942e-19, -1.224230167856966e-21,  3.258675414147055e-24,
 -4.808518486926983e-27, -7.193666748769637e-30,  1.914950712445992e-01, -9.345034724599707e-04,  3.140499894388197e-06, -8.118750847869221e-09,  1.460450095993805e-11,
 -5.096663997432145e-15, -9.448802292863905e-17,  4.845365346304181e-19, -1.443579548198763e-21,  2.367662666547741e-24,  2.614649543798745e-27, -3.712101502037615e-29,
  2.334024563851984e-01, -1.121495955499616e-03,  3.627189070137240e-06, -8.577913130581472e-09,  1.160909874079134e-11,  1.541509897359759e-14, -1.658314597318483e-16,
  6.136785920018503e-19, -1.262269804363349e-21, -1.726447633502473e-25,  1.389524974383707e-26, -6.577568012134829e-29,  2.792575589818267e-01, -1.318509643363698e-03,
  4.078034479293702e-06, -8.605885578516145e-09,  6.606659048459404e-12,  4.064140557115418e-14, -2.320249433748521e-16,  6.365300011030012e-19, -5.420290452486186e-22,
 -4.183017037810561e-24,  2.536754846022617e-26, -7.318655273279331e-29,  3.289775628405974e-01, -1.522922963090182e-03,  4.471207867063025e-06, -8.119535821109765e-09,
 -3.784073344132893e-13,  6.824472776949709e-14, -2.775941646578381e-16,  5.013107504497071e-19,  7.330470960436512e-22, -8.741770836679794e-24,  3.098401185372692e-26,
 -3.927170213136260e-29,  3.824654961921879e-01, -1.731820800703111e-03,  4.784285875963318e-06, -7.054091132931087e-09, -9.115339352623559e-12,  9.486162546852338e-14,
 -2.858713583781786e-16,  1.776580021793191e-19,  2.393496145058923e-21, -1.218270228489571e-23,  2.407980431793547e-26,  4.328291499330193e-29,  4.396081626033996e-01,
 -1.941987537396056e-03,  4.994828835905473e-06, -5.370503748726154e-09, -1.913915195383368e-11,  1.162831914822912e-13, -2.419376676849906e-16, -3.262095354567803e-19,
  4.053652673205562e-21, -1.241150964629106e-23,  5.669918603598937e-28,  1.553717263463434e-28,  5.002737536208498e-01, -2.149904054857665e-03,  5.081103587605949e-06,
 -3.063245200028066e-09, -2.973693350803008e-11,  1.278183273718340e-13, -1.363682146430104e-16, -9.490381539202174e-19,  5.140722682627080e-21, -7.593754932227279e-24,
 -3.720366482892694e-26,  2.453484817327876e-28,  5.643091089521038e-01, -2.351750746345308e-03,  5.022972421899233e-06, -1.681559338971809e-10, -3.995523353525595e-11,
  1.248619592297045e-13,  3.063002758446899e-17, -1.570195536254174e-18,  5.007292162958489e-21,  2.862786587574914e-24, -7.759671386236074e-26,  2.403126042389999e-28,
  6.315365905173945e-01, -2.543419172433320e-03,  4.802967583094770e-06,  3.230234974264899e-09, -4.863644944621250e-11,  1.036674591180341e-13,  2.454173464656275e-16,
 -2.017690170120439e-18,  3.134557143157976e-21,  1.730226904326583e-23, -1.002498726311420e-25,  8.075508367829702e-29,  7.017505400937780e-01, -2.720535727551647e-03,
  4.407564067489910e-06,  6.992776889269755e-09, -5.449242018214008e-11,  6.228393761328385e-14,  4.785406359096253e-16, -2.096214309732155e-18, -5.981679665049369e-22,
  3.127610887272156e-23, -8.226456645389154e-26, -2.274838336062958e-28,  7.747132980143844e-01, -2.878501532233286e-03,  3.828650530307251e-06,  1.092233666220449e-08,
 -5.622238147055124e-11,  1.561583558468699e-15,  6.851580989646178e-16, -1.637770581531226e-18, -5.648645198890402e-21,  3.807607851070015e-23, -1.047464742161767e-26,
 -5.689814109081296e-28,  8.501507745246656e-01, -3.012553709675559e-03,  3.065176236221351e-06,  1.476455842801470e-08, -5.267910626429497e-11, -7.394794073606187e-14,
  8.097501563844657e-16, -5.708152043302979e-19, -1.067429851960783e-20,  3.084767542812143e-23,  1.035777225072713e-25, -7.245933782534533e-28,  9.277475886623545e-01,
 -3.117854176582904e-03,  2.124917815567719e-06,  1.821463951083929e-08, -4.308029441461522e-11, -1.554563668323998e-13,  7.962542033405489e-16,  1.006638927130383e-18,
 -1.367791856595009e-20,  6.243163481402077e-24,  2.144007477618562e-25, -4.673700311078768e-28,  1.007141825423499e+00, -3.189612945034961e-03,  1.026259551340407e-06,
  2.093224670874059e-08, -2.725090911654119e-11, -2.301073423357913e-13,  6.036942405940983e-16,  2.777410810817970e-18, -1.256669026039596e-20, -3.147473242929397e-23,
  2.509038398836046e-25,  2.551825571390407e-28,  1.087919514795692e+00, -3.223253463971649e-03, -2.001879337228366e-07,  2.256663965495002e-08, -5.865460229385952e-12,
 -2.822164253622279e-13,  2.253506749563267e-16,  4.217094275837423e-18, -6.123791986878746e-21, -6.826829731980761e-23,  1.508116294826743e-25,  1.145653041164363e-27,
  1.169609010875220e+00, -3.214627357455729e-03, -1.510394054560609e-06,  2.279347224457250e-08,  1.936214248179029e-11, -2.958696381288926e-13, -2.934379145783165e-16,
  4.705008092764275e-18,  4.868100845433630e-21, -8.322417605750358e-23, -8.554057435212382e-26,  1.571351845384513e-27,  1.251675550684153e+00, -3.160284495976821e-03,
 -2.846506455709058e-06,  2.136328134786428e-08,  4.561612561581799e-11, -2.589004010598090e-13, -8.469826758500744e-16,  3.747750479841524e-18,  1.694477341459234e-20,
 -5.844799064980170e-23, -3.540208825468312e-25,  9.311829250145764e-28,  1.333516404310112e+00, -3.057800920211886e-03, -4.137711936162228e-06,  1.815899670508869e-08,
  6.913442839241709e-11, -1.677489497817951e-13, -1.280470453271740e-15,  1.272813284540990e-18,  2.451997242920838e-20,  6.398284717049555e-24, -4.690383312890203e-25,
 -7.151019004839780e-28,  1.414457191275990e+00, -2.906160805756294e-03, -5.302906901029629e-06,  1.325569863717878e-08,  8.566770014821180e-11, -3.196039920305742e-14,
 -1.428487151206818e-15, -2.131732980388230e-18,  2.222664589732302e-20,  8.382736418974909e-23, -2.809425180071088e-25, -2.274183493548559e-27,  1.493750126823134e+00,
 -2.706178458298582e-03, -6.255722154882823e-06,  6.970504249485916e-09,  9.128180737042419e-11,  1.237107209340065e-13, -1.179331257632500e-15, -5.222430166088994e-18,
  8.556883982084535e-21,  1.254540716415670e-22,  1.606886941536476e-25, -2.203829678253790e-27,  1.570575159220582e+00, -2.460931589900460e-03, -6.912295845972384e-06,
 -1.150990340471136e-10,  8.344094396730389e-11,  2.619922705289436e-13, -5.465638190625290e-16, -6.516301619213788e-18, -1.127581641756302e-20,  9.240677404115469e-23,
  5.508147231293714e-25, -7.057787835663906e-29,  1.644045131952129e+00, -2.176158034441547e-03, -7.201805253822760e-06, -7.181644048176936e-09,  6.214634687935910e-11,
  3.422414773719151e-13,  2.900202222759691e-16, -5.086535807980779e-18, -2.632588757451326e-20, -5.705217845968775e-24,  5.295422103380322e-25,  2.364995952325461e-27,
  1.713216198097036e+00, -1.860546500354193e-03, -7.079087780408584e-06, -1.326572750310108e-08,  3.072206121387384e-11,  3.352319121388982e-13,  1.018664742206596e-15,
 -1.355848370738759e-18, -2.633918351912902e-20, -1.008278357856745e-22,  5.817591167924451e-26,  2.484375841829130e-27,  1.777104651829595e+00, -1.525832464634101e-03,
 -6.537713845124279e-06, -1.742844777049609e-08, -4.269786878408018e-12,  2.387469262197385e-13,  1.324961956589511e-15,  2.773322857639628e-18, -1.046283555594439e-20,
 -1.148537885953356e-22, -4.307836348148680e-25,  2.041516038462393e-29,  1.834711033513341e+00, -1.186600632338188e-03, -5.620781865837591e-06, -1.898047018833594e-08,
 -3.439266189849364e-11,  8.541823618981372e-14,  1.072832090076881e-15,  4.918043471127280e-18,  9.689198388913953e-21, -3.802092595547760e-23, -4.426333341120048e-25,
 -2.026893511593154e-27,  1.885051729933323e+00, -8.597058170142153e-04, -4.425865582792208e-06, -1.771247021490986e-08, -5.194351253195424e-11, -6.567409616317838e-14,
  4.231141464509129e-16,  3.940750566017967e-18,  1.857645424678969e-20,  4.992364114854174e-23, -3.051861674239000e-26, -1.256631382405092e-27,  1.927197301554362e+00,
 -5.632645750188455e-04, -3.100523655156723e-06, -1.404978330947524e-08, -5.304564944517011e-11, -1.551032539894260e-13, -2.315345255380382e-16,  1.002296196096881e-18,
  1.136488264443786e-20,  6.419733768179189e-23,  2.542287167436925e-25,  6.181179411602431e-28,  1.960315513051684e+00, -3.152444203652314e-04, -1.826140610538325e-06,
 -9.044367486607433e-09, -3.980492238392863e-11, -1.557155508239702e-13, -5.237240433104518e-16, -1.347970548467836e-18, -1.204051471407299e-21,  1.478626794575439e-23,
  1.366232217602942e-25,  7.895237910244585e-28,  1.983715897993839e+00, -1.317762310634369e-04, -7.907741310457457e-07, -4.154553763458449e-09, -2.006654287703421e-11,
 -9.075231525879354e-14, -3.864097232639667e-16, -1.544295919164425e-18, -5.720914127936283e-21, -1.906496598211295e-23, -5.282823239159904e-26, -8.731660245414639e-29,
  1.996894768265356e+00, -2.539106484190425e-05, -1.553871938585203e-07, -8.429293737312797e-10, -4.272047535712348e-12, -2.069861745029218e-14, -9.702280214852227e-17,
 -4.429531925883267e-19, -1.977488817174026e-21, -8.652401647604663e-24, -3.714740349048469e-26, -1.565331641392442e-28,  5.244642886486939e-04, -2.703021409575120e-06,
  1.044587905327066e-08, -3.587471198556574e-11,  1.154615208240823e-13, -3.566194061500755e-16,  1.070274090340542e-18, -3.145127815496258e-21,  9.090757506038182e-24,
 -2.593971213442379e-26,  7.319369428932227e-29, -2.047566905208595e-31,  4.719393333615312e-03, -2.429154989179312e-05,  9.360607604008337e-08, -3.198655521155071e-10,
  1.021514689070276e-12, -3.120184277639075e-15,  9.223364364774656e-18, -2.657015941840685e-20,  7.486932156278036e-23, -2.069282721102450e-25,  5.612805429981726e-28,
 -1.496214108486112e-30,  1.310504153608975e-02, -6.727815385287773e-05,  2.577579690823297e-07, -8.718827359695677e-10,  2.740515028225339e-12, -8.179326527150727e-15,
  2.341111740930255e-17, -6.455732675560851e-20,  1.715841453018543e-22, -4.387599732655352e-25,  1.071983578680743e-27, -2.476433707284776e-30,  2.567288390974058e-02,
 -1.312802102723611e-04,  4.985709807238752e-07, -1.660346052904993e-09,  5.090905761852212e-12, -1.463987079163882e-14,  3.969671238102270e-17, -1.012312137663169e-19,
  2.397472774729787e-22, -5.125828505886400e-25,  9.157910442431575e-28, -1.006321161805126e-30,  4.240986757755058e-02, -2.157195011891178e-04,  8.095664218812810e-07,
 -2.638770172105528e-09,  7.812012837753764e-12, -2.126385619158226e-14,  5.290407303128964e-17, -1.171810890054114e-19,  2.137482270739325e-22, -2.303946764420957e-25,
 -4.222139955649298e-28,  3.941551582088795e-30,  6.329808661104065e-02, -3.198171016731515e-04,  1.182141280522708e-06, -3.746862939324176e-09,  1.057809035838223e-11,
 -2.658999028451587e-14,  5.743343476767377e-17, -9.412233410803574e-20,  4.511151693010330e-23,  4.919858429096182e-25, -2.876281703483178e-27,  1.087230172964153e-29,
  8.831433719187916e-02, -4.425866186131216e-04,  1.605605386999456e-06, -4.912049703780831e-09,  1.301709602974990e-11, -2.908793515585990e-14,  4.824747761314156e-17,
 -2.009208502575582e-20, -2.745082721550763e-22,  1.540700615557496e-24, -5.565780445779460e-27,  1.547346500932705e-29,  1.174295431183937e-01, -5.828258440393108e-04,
  2.067236931923787e-06, -6.051473574799996e-09,  1.473415714696598e-11, -2.734007084094633e-14,  2.193729890116013e-17,  1.056540757497679e-19, -6.964739151670586e-22,
  2.572117892041240e-24, -6.891496581380469e-27,  1.202026015068150e-29,  1.506080388171035e-01, -7.391069251654430e-04,  2.552362938542957e-06, -7.074531471938086e-09,
  1.533956883161396e-11, -2.024163900699691e-14, -2.224858293281671e-17,  2.690155806562947e-19, -1.110445895381832e-21,  3.061131242882344e-24, -5.042333663319812e-27,
 -3.572759250995228e-30,  1.878066939249388e-01, -9.097652094462104e-04,  3.044473165770176e-06, -7.886012991242302e-09,  1.448096284232279e-11, -7.206712852796902e-15,
 -8.155478375082918e-17,  4.397228847696765e-19, -1.356834829850899e-21,  2.441758334255310e-24,  1.142161701368900e-27, -2.997654877863862e-29,  2.289738601539752e-01,
 -1.092887003039231e-03,  3.525378075307854e-06, -8.389911619051540e-09,  1.187896939283005e-11,  1.163677353417419e-14, -1.492141576657523e-16,  5.732882694011767e-19,
 -1.259156027510323e-21,  3.276820426363219e-25,  1.117979908463285e-26, -5.771747539371768e-29,  2.740481175286994e-01, -1.286296593186699e-03,  3.975423951343256e-06,
 -8.493972946586656e-09,  7.365234128618150e-12,  3.528458873629870e-14, -2.144662108306916e-16,  6.169652471165895e-19, -6.751206931163037e-22, -3.231779009067949e-24,
  2.221980909425119e-26, -6.969841872244480e-29,  3.229567932179079e-01, -1.487543039395802e-03,  4.373780992215118e-06, -8.115028348281233e-09,  9.210140903388340e-13,
  6.175327660723915e-14, -2.632746839676389e-16,  5.199686645171771e-19,  4.402128925545985e-22, -7.539395983387471e-24,  2.908035132571970e-26, -4.674671935563438e-29,
  3.756142221392373e-01, -1.693887447665309e-03,  4.698823115927371e-06, -7.185129636857859e-09, -7.286270006440143e-12,  8.806866232380170e-14, -2.798892358880840e-16,
  2.474218606939810e-19,  1.972654352887224e-21, -1.118805727479890e-23,  2.549542580840171e-26,  2.172085365773854e-29,  4.319197144379027e-01, -1.902291722051693e-03,
  4.928621149432802e-06, -5.658443203152547e-09, -1.687221900334961e-11,  1.103813266829554e-13, -2.493225634227266e-16, -2.036244807699569e-19,  3.608810560752277e-21,
 -1.226125121694769e-23,  6.723291061462847e-27,  1.248142288099769e-28,  4.917551910878427e-01, -2.109410157287295e-03,  5.041573659777010e-06, -3.518771731668979e-09,
 -2.721535278845345e-11,  1.242449399022246e-13, -1.606812639423180e-16, -7.891755277013005e-19,  4.843101381922056e-21, -8.872759007115257e-24, -2.691972710173702e-26,
  2.215961648142775e-28,  5.549824456532737e-01, -2.311585716301674e-03,  5.017201346489911e-06, -7.874364369223056e-10, -3.745411044348392e-11,  1.250876748855288e-13,
 -1.108083749115845e-17, -1.408891430946011e-18,  5.057053911201984e-21, -2.724663507453029e-26, -6.686446802717751e-26,  2.458993732765102e-28,  6.214399883407057e-01,
 -2.504853450044843e-03,  4.837130708827283e-06,  2.468939603416101e-09, -4.650871530124621e-11,  1.088914141579856e-13,  1.904144705400972e-16, -1.908184230340862e-18,
  3.686263708575180e-21,  1.337945704909480e-23, -9.551553920955768e-26,  1.322722837461831e-28,  6.909394288644086e-01, -2.684954285032739e-03,  4.486289191986348e-06,
  6.131467631585281e-09, -5.313665273922955e-11,  7.306343909979262e-14,  4.197432890506061e-16, -2.097993681621861e-18,  4.663758676469772e-22,  2.781233190761951e-23,
 -9.026892324431614e-26, -1.375493267818657e-28,  7.632613588124733e-01, -2.847363340219379e-03,  3.954325102934504e-06,  1.002390591533447e-08, -5.603052652088297e-11,
  1.743592400249463e-14,  6.369751442165307e-16, -1.796723812352959e-18, -4.291263555529873e-21,  3.718048403939696e-23, -3.369061581651944e-26, -4.847039186694011e-28,
  8.381507042438204e-01, -2.987338035268567e-03,  3.237248341409427e-06,  1.391091085629377e-08, -5.396521467818506e-11, -5.474327599465579e-14,  7.891575320554899e-16,
 -8.938872697465472e-19, -9.496892232744799e-21,  3.435330610729803e-23,  7.176172817411028e-26, -7.167080031522422e-28,  9.153115381078586e-01, -3.099992478705761e-03,
  2.339258567659214e-06,  1.750152879359772e-08, -4.599629220487851e-11, -1.360572288172992e-13,  8.183577297602244e-16,  5.741541839979687e-19, -1.330410848411377e-20,
  1.436925724644768e-23,  1.910096129852182e-25, -5.901157080989871e-28,  9.944013737280454e-01, -3.180405877550253e-03,  1.274681173978720e-06,  2.046022781607973e-08,
 -3.170210921320854e-11, -2.147318889363462e-13,  6.756754417926553e-16,  2.359102156174256e-18, -1.351704100914037e-20, -2.128169205259984e-23,  2.570876156891839e-25,
  2.737358690300756e-29,  1.075025010182227e+00, -3.223773791005373e-03,  6.986345566846759e-08,  2.242797124019546e-08, -1.144626412343409e-11, -2.754154359861301e-13,
  3.403252441830781e-16,  3.983070104920680e-18, -8.461201262941790e-21, -6.128138049545500e-23,  1.971265097774468e-25,  9.525773323331172e-28,  1.156728074283695e+00,
 -3.225611608706036e-03, -1.235210012319140e-06,  2.305558981185751e-08,  1.338507473040889e-11, -3.013164509164497e-13, -1.599711074774508e-16,  4.812326135043339e-18,
  1.827261228219994e-21, -8.524684000334335e-23, -1.533353042612593e-26,  1.606903216527726e-27,  1.238990509195275e+00, -3.182019103054354e-03, -2.585942283311161e-06,
  2.205064758324056e-08,  4.024364971501869e-11, -2.779095086437933e-13, -7.347897145698774e-16,  4.253670581904264e-18,  1.459657907394508e-20, -7.168522229464120e-23,
 -3.053446828612703e-25,  1.273536190546468e-27,  1.321220403519902e+00, -3.090012445054724e-03, -3.913283156637737e-06,  1.923665170772852e-08,  6.547548188494363e-11,
 -1.979638291871379e-13, -1.233838241405234e-15,  2.057462857623306e-18,  2.440617563673874e-20, -1.286482717466193e-23, -4.908571589583512e-25, -2.678772040789630e-28,
  1.402748741792632e+00, -2.947924546592215e-03, -5.135641597855898e-06,  1.461938661522214e-08,  8.468124738381928e-11, -6.687727548899918e-14, -1.477781052649051e-15,
 -1.374558744912422e-18,  2.501829231048849e-20,  7.061828984249852e-23, -3.785336977470974e-25, -2.139883524881803e-27,  1.482825886481031e+00, -2.755864644877449e-03,
 -6.163236517189183e-06,  8.449219927784341e-09,  9.346131558126967e-11,  9.368718852175057e-14, -1.321039153581288e-15, -4.875305297403374e-18,  1.316437448654098e-20,
  1.298133563208376e-22,  5.421486515392396e-26, -2.623441898196400e-27,  1.560620859940062e+00, -2.516212392198176e-03, -6.905496268726113e-06,  1.261099385598782e-09,
  8.853463796317051e-11,  2.466477136760726e-13, -7.335414955908012e-16, -6.819665958283539e-18, -7.554974997829977e-21,  1.141956974558638e-22,  5.339671365027369e-25,
 -7.105944440745097e-28,  1.635224749678196e+00, -2.234099769163363e-03, -7.281791965116128e-06, -6.132215812791412e-09,  6.904875278185758e-11,  3.473976536523114e-13,
  1.358026613868707e-16, -5.927960677668646e-18, -2.612522424802849e-20,  1.752269335919916e-23,  6.306942094468406e-25,  2.205384058020020e-27,  1.705659750975703e+00,
 -1.917807083005517e-03, -7.235101676153977e-06, -1.271922374286334e-08,  3.766759754760644e-11,  3.591257260010984e-13,  9.683598404222783e-16, -2.256106653320368e-18,
 -2.989931175104709e-20, -9.615624532223467e-23,  1.792955842070481e-25,  3.018081632733900e-27,  1.770895392840653e+00, -1.578971528021565e-03, -6.747101877907973e-06,
 -1.745681143069436e-08,  8.292202376112818e-13,  2.714360768496737e-13,  1.397282399565933e-15,  2.369041075231869e-18, -1.490619479077513e-20, -1.319196176901962e-22,
 -4.185955885812756e-25,  5.577459312444637e-28,  1.829873242934533e+00, -1.232487165478267e-03, -5.851788166553525e-06, -1.951563945519261e-08, -3.241548810462794e-11,
  1.128523138307789e-13,  1.214646912559553e-15,  5.202603484569172e-18,  7.979849251326432e-21, -5.755361166826398e-23, -5.349544187579614e-25, -2.157227840664360e-27,
  1.881540726595034e+00, -8.959771649310428e-04, -4.643443254781277e-06, -1.855348378434240e-08, -5.314615527367704e-11, -5.412644257333846e-14,  5.420452590410238e-16,
  4.563602139572735e-18,  2.033730076297617e-20,  4.747447089930373e-23, -9.511875751524127e-26, -1.693155331159002e-27,  1.924893546409507e+00, -5.887578199436372e-04,
 -3.274316755453977e-06, -1.492362183299663e-08, -5.620078789478456e-11, -1.602800087287172e-13, -1.980170306281224e-16,  1.404965350380083e-18,  1.386549068672170e-20,
  7.489927194423585e-23,  2.805019984614600e-25,  5.675594785018132e-28,  1.959024614145714e+00, -3.302987430164165e-04, -1.938599312637828e-06, -9.706856573362112e-09,
 -4.304800463922851e-11, -1.687416685182659e-13, -5.619186817775139e-16, -1.376857485131967e-18, -5.645246200673577e-22,  2.099921592146538e-23,  1.754031278779742e-25,
  9.789236525597611e-28,  1.983175817045768e+00, -1.383074420838237e-04, -8.426167341303670e-07, -4.490657780354756e-09, -2.197793963620586e-11, -1.005663678113492e-13,
 -4.323191081805596e-16, -1.738761705514553e-18, -6.446178565828063e-21, -2.125077386245459e-23, -5.634050914835118e-26, -7.054910761246190e-29,  1.996790652065246e+00,
 -2.667581730498830e-05, -1.659265456585989e-07, -9.147247801799291e-10, -4.710348190169527e-12, -2.318344598457605e-14, -1.103603587285676e-16, -5.115174358912277e-19,
 -2.317468271348092e-21, -1.028570014011186e-23, -4.476925227536535e-26, -1.911217194286309e-28,  5.138166542309371e-04, -2.621145490931020e-06,  1.002623588706158e-08,
 -3.408302048101449e-11,  1.085790316316012e-13, -3.319575618329523e-16,  9.861467139709868e-19, -2.868616947929704e-21,  8.207527036990088e-24, -2.318441079817244e-26,
  6.475628541746533e-29, -1.793594145229012e-31,  4.623700907588535e-03, -2.355778164375466e-05,  8.986373378310866e-08, -3.040087674715476e-10,  9.612657203462956e-13,
 -2.907487110454902e-15,  8.511851624295580e-18, -2.428932426514918e-20,  6.780864962434190e-23, -1.857402727721389e-25,  4.993993880014332e-28, -1.320423318216099e-30,
  1.283998782130820e-02, -6.525720728870183e-05,  2.475531645736607e-07, -8.293132632724254e-10,  2.582403895535172e-12, -7.638544827079818e-15,  2.167806517736417e-17,
 -5.931129289017435e-20,  1.565350184923965e-22, -3.979872877047415e-25,  9.684046580563643e-28, -2.235586379391658e-30,  2.515561594403009e-02, -1.273699762317574e-04,
  4.791260578101921e-07, -1.581183123869127e-09,  4.807410373554614e-12, -1.372031325612193e-14,  3.696692097499025e-17, -9.384756651907864e-20,  2.219428125064021e-22,
 -4.768561285927325e-25,  8.701294186799812e-28, -1.063529662935045e-30,  4.155974504676919e-02, -2.093675377931772e-04,  7.786373193553009e-07, -2.517112298538478e-09,
  7.399170886346923e-12, -2.003276614339494e-14,  4.971749350504841e-17, -1.104767875168065e-19,  2.051896757978399e-22, -2.440482759762452e-25, -2.659978711873453e-28,
  3.181664752020099e-30,  6.203745171256091e-02, -3.105369835441251e-04,  1.138177112689660e-06, -3.581793891744520e-09,  1.005986201725511e-11, -2.524303423690324e-14,
  5.482072897428034e-17, -9.241667816837172e-20,  6.086324280179961e-23,  3.860512242328669e-25, -2.431258703847359e-27,  9.387837113905435e-30,  8.656931202862748e-02,
 -4.299740570587161e-04,  1.547891436968862e-06, -4.708367530712508e-09,  1.244686623438963e-11, -2.793768950948014e-14,  4.756995903933931e-17, -2.803056902110688e-20,
 -2.228903903066982e-22,  1.331241362207818e-24, -4.918044493905701e-27,  1.398231625231919e-29,  1.151308612245224e-01, -5.665744529910084e-04,  1.996015778970246e-06,
 -5.820071903951079e-09,  1.419284764584769e-11, -2.678051066509896e-14,  2.459713969584987e-17,  8.479628279407620e-20, -6.087120683370190e-22,  2.307033916248422e-24,
 -6.363230943107842e-27,  1.194890255669046e-29,  1.476919171086745e-01, -7.190234577483856e-04,  2.468927712854322e-06, -6.832363554948043e-09,  1.492998619390109e-11,
 -2.068913070749921e-14, -1.519733863614344e-17,  2.352053435761841e-19, -1.003905340556072e-21,  2.857183676654746e-24, -5.134321860726801e-27, -7.255740783270433e-31,
  1.842157508662210e-01, -8.857840255464429e-04,  2.951226092618098e-06, -7.655572908325189e-09,  1.431822771775733e-11, -9.021105612145940e-15, -6.983714170031405e-17,
  3.977169747258604e-19, -1.268409762740581e-21,  2.462950050308727e-24, -3.763414179674099e-29, -2.380480619058475e-29,  2.246580851410248e-01, -1.065083446664291e-03,
  3.425846581646423e-06, -8.198175424304788e-09,  1.207717020946426e-11,  8.243719365785537e-15, -1.337238273685961e-16,  5.332654989190896e-19, -1.239901271227466e-21,
  7.263581892539805e-25,  8.809415451734289e-27, -5.011166782786189e-29,  2.689658952939369e-01, -1.254898857089112e-03,  3.874225736323741e-06, -8.370757501999075e-09,
  8.020840238945488e-12,  3.034215724674266e-14, -1.975099397726723e-16,  5.936654926025587e-19, -7.761942326924248e-22, -2.403065751757951e-24,  1.924837989901226e-26,
 -6.523832551372148e-29,  3.170759852886890e-01, -1.452941970643768e-03,  4.276528728066225e-06, -8.090749933160153e-09,  2.094080178635376e-12,  5.561074260761975e-14,
 -2.485575723961888e-16,  5.299331653863834e-19,  1.892222988586897e-22, -6.418872837297484e-24,  2.691205965033391e-26, -5.138827108038802e-29,  3.689133048241683e-01,
 -1.656643599320557e-03,  4.611959028164070e-06, -7.287981467460274e-09, -5.591473712335027e-12,  8.144122244331442e-14, -2.721368119539642e-16,  3.043008397823995e-19,
  1.588420940341545e-21, -1.015460606559506e-23,  2.604828059105631e-26,  4.024459266599269e-30,  4.243889691860041e-01, -1.863138781714883e-03,  4.859171891764882e-06,
 -5.911064520492878e-09, -1.472482598694418e-11,  1.043418110482018e-13, -2.534732298924364e-16, -9.514288839126993e-20,  3.173492345474459e-21, -1.189095430137196e-23,
  1.158669404170181e-26,  9.669362403589779e-29,  4.833979380071309e-01, -2.069253684173174e-03,  4.996817028294012e-06, -3.934554915995334e-09, -2.477071811397893e-11,
  1.201406371353308e-13, -1.806578620773561e-16, -6.394961909398875e-19,  4.506581136938165e-21, -9.762094103778180e-24, -1.773689056673991e-26,  1.955501898612135e-28,
  5.458163040325410e-01, -2.271495900022633e-03,  5.004238989847744e-06, -1.366715709291820e-09, -3.495811727568335e-11,  1.243666147343219e-13, -4.826794255186504e-17,
 -1.247576442209135e-18,  5.010535649596695e-21, -2.485823348736457e-24, -5.608863099540869e-26,  2.425972749649435e-28,  6.114981386320724e-01, -2.466050378604877e-03,
  4.862365770996955e-06,  1.742453164673871e-09, -4.428944462456753e-11,  1.128339600662492e-13,  1.387039803352073e-16, -1.783242467886636e-18,  4.100669014875386e-21,
  9.687512045403086e-24, -8.880070993130182e-26,  1.708664207620663e-28,  6.802718380891927e-01, -2.648783999706581e-03,  4.554815625293251e-06,  5.293498752304500e-09,
 -5.157939126762393e-11,  8.243493854405782e-14,  3.613538930610778e-16, -2.067756976115322e-18,  1.401393313522438e-21,  2.410518612822868e-23, -9.449536384683629e-26,
 -5.616174085391231e-29,  7.519359149960047e-01, -2.815262800402122e-03,  4.069247194291305e-06,  9.131020486185262e-09, -5.553308395982123e-11,  3.210533752266569e-14,
  5.849435239885859e-16, -1.912928514245776e-18, -2.981922339826648e-21,  3.543284231494722e-23, -5.302653090676934e-26, -3.934877771837173e-28,  8.262541844814533e-01,
 -2.960787079923325e-03,  3.398965789208328e-06,  1.303972844588576e-08, -5.487288228822065e-11, -3.613702109393312e-14,  7.600635956660944e-16, -1.177507523894361e-18,
 -8.216030288817597e-21,  3.660161239985948e-23,  4.091052315844740e-26, -6.815120126622468e-28,  9.029503085198339e-01, -3.080451047624091e-03,  2.544774940968503e-06,
  1.674489070725298e-08, -4.851997515540896e-11, -1.162713057444553e-13,  8.285617831219703e-16,  1.581214708562933e-19, -1.265580760496998e-20,  2.146211136675033e-23,
  1.630000308470528e-25, -6.770273814767247e-28,  9.817016874973519e-01, -3.169235280757207e-03,  1.517021695523286e-06,  1.991953961813322e-08, -3.582948979431228e-11,
 -1.977725345983820e-13,  7.355736359823973e-16,  1.916281793735651e-18, -1.409837548411273e-20, -1.103830001176129e-23,  2.535271089199863e-25, -1.859538125707993e-28,
  1.062132732415871e+00, -3.222141869686634e-03,  3.377200347677061e-07,  2.220124567140056e-08, -1.686402775023323e-11, -2.659418963705252e-13,  4.477402398935971e-16,
  3.678613528840586e-18, -1.051588855809431e-20, -5.262326850180816e-23,  2.341110752909032e-25,  7.237870700874895e-28,  1.143807621248101e+00, -3.234383438881767e-03,
 -9.574573865931888e-07,  2.322137766896278e-08,  7.331289112320189e-12, -3.035350450014546e-13, -2.486876289387923e-17,  4.821715927067937e-18, -1.235679083574713e-21,
 -8.445308761120565e-23,  5.470878194674409e-26,  1.564077914435800e-27,  1.226222748444780e+00, -3.201637692406923e-03, -2.317657533102946e-06,  2.264916370470589e-08,
  3.451901969970007e-11, -2.940649132485974e-13, -6.095517759962504e-16,  4.677228162021451e-18,  1.181038257820433e-20, -8.268969495166020e-23, -2.428050185735227e-25,
  1.557994640291092e-27,  1.308799227927531e+00, -3.120377852949210e-03, -3.676293500417761e-06,  2.025099744815141e-08,  6.122520424089025e-11, -2.267969505614390e-13,
 -1.165392048121405e-15,  2.827246289319359e-18,  2.358806827985740e-20, -3.259337368430389e-23, -4.920168866062957e-25,  2.195258803198803e-28,  1.390876016781815e+00,
 -2.988285029749719e-03, -4.952129971646817e-06,  1.596164775360510e-08,  8.298639403722547e-11, -1.027131662660751e-13, -1.504700198349478e-15, -5.363997475543123e-19,
  2.726592808627379e-20,  5.366305546109322e-23, -4.672749508362829e-25, -1.871797023746786e-27,  1.471704494320480e+00, -2.804739421994663e-03, -6.052817462918826e-06,
  9.957822791109288e-09,  9.500721713833411e-11,  6.039607599997905e-14, -1.450945867448795e-15, -4.379086427158614e-18,  1.784791215436107e-20,  1.295695367761548e-22,
 -6.877593824600638e-26, -2.948258639479482e-27,  1.550445652757882e+00, -2.571371379790137e-03, -6.881704240309972e-06,  2.716095324451868e-09,  9.327595073859947e-11,
  2.267279354748939e-13, -9.272297690313300e-16, -6.991599654806115e-18, -3.068883831821713e-21,  1.347221575910135e-22,  4.871177589791490e-25, -1.429194390115621e-27,
  1.626171403093705e+00, -2.292629141074647e-03, -7.348520176790437e-06, -4.971733181604724e-09,  7.601536877292268e-11,  3.485714154902593e-13, -4.175371615402404e-17,
 -6.748820902869425e-18, -2.501768017575803e-20,  4.460522217275214e-23,  7.209639367304146e-25,  1.866151581643457e-27,  1.697871809550098e+00, -1.976287619607499e-03,
 -7.383875221829275e-06, -1.205784278839914e-08,  4.507682944950769e-11,  3.814970519690859e-13,  8.912849822390628e-16, -3.266617681179427e-18, -3.319847005486716e-20,
 -8.617885530438278e-23,  3.231691534215755e-25,  3.510870559992453e-27,  1.764470227258273e+00, -1.633785619917151e-03, -6.956318900837766e-06, -1.739827055213525e-08,
  6.598364931099943e-12,  3.057084491245473e-13,  1.456200918916008e-15,  1.812884825963706e-18, -1.994905288851777e-20, -1.479812725835038e-22, -3.794769388153503e-25,
  1.245675064131144e-27,  1.824848170265229e+00, -1.280246856443388e-03, -6.089007977154867e-06, -2.001459697316156e-08, -2.985498661352979e-11,  1.437787029009658e-13,
  1.363552776749704e-15,  5.420490993548035e-18,  5.499691070801320e-21, -8.086902230480110e-23, -6.310842994422092e-25, -2.193337417172565e-27,  1.877881092267927e+00,
 -9.340298114040241e-04, -4.871220403015619e-06, -1.941173088402264e-08, -5.408785635623842e-11, -3.950889718780664e-14,  6.791880397480547e-16,  5.240852355028125e-18,
  2.195861648798912e-20,  4.203299490007660e-23, -1.807354797158370e-25, -2.212183457949169e-27,  1.922484969962055e+00, -6.156842196825927e-04, -3.458902075528943e-06,
 -1.584872314493763e-08, -5.945045571874810e-11, -1.645076414404252e-13, -1.520451920161435e-16,  1.894015776636662e-18,  1.676959848446491e-20,  8.659081622564696e-23,
  3.032541410476290e-25,  4.544294617608383e-28,  1.957671646988879e+00, -3.462854370034059e-04, -2.059327978891985e-06, -1.042336919148474e-08, -4.656082860843077e-11,
 -1.826916332312333e-13, -6.005997900473194e-16, -1.381384598349094e-18,  3.286936902666809e-22,  2.894057008801235e-23,  2.233119009080753e-25,  1.205161545618237e-27,
  1.982608755473916e+00, -1.452700621373072e-04, -8.986827558766279e-07, -4.858976159081603e-09, -2.409709061289842e-11, -1.115502823010078e-13, -4.840104671383833e-16,
 -1.957720446893169e-18, -7.252451713077714e-21, -2.355880328325639e-23, -5.884399747313682e-26, -4.067070747432417e-29,  1.996681222595771e+00, -2.804845387302861e-05,
 -1.773712173618588e-07, -9.939486374054978e-10, -5.201708524587418e-12, -2.601269933813615e-14, -1.257793017327776e-16, -5.919637534224099e-19, -2.722121549747469e-21,
 -1.225659465329714e-23, -5.408694887956754e-26, -2.339199627879382e-28,  5.034899427713161e-04, -2.542542551675319e-06,  9.627448228464640e-09, -3.239761003447566e-11,
  1.021701997565875e-13, -3.092249712820536e-16,  9.093804142922787e-19, -2.618845415007210e-21,  7.417672376184807e-24, -2.074528318694966e-26,  5.736052451726920e-29,
 -1.573250353072671e-31,  4.530884859476611e-03, -2.285320707845085e-05,  8.630602647380717e-08, -2.890828413299632e-10,  9.051049758223694e-13, -2.711124731735400e-15,
  7.861150436237008e-18, -2.222268932195191e-20,  6.146799436301332e-23, -1.668794739554650e-25,  4.447614950004351e-28, -1.166473308210667e-30,  1.258285779154199e-02,
 -6.331589802458412e-05,  2.378443647982689e-07, -7.891892545461259e-10,  2.434704086730307e-12, -7.137646802659521e-15,  2.008537496367781e-17, -5.452412532637525e-20,
  1.428816233219306e-22, -3.611526146610859e-25,  8.749179279058382e-28, -2.017397516449935e-30,  2.465368370504986e-02, -1.236115774896700e-04,  4.606044700543055e-07,
 -1.506412482339204e-09,  4.541667404408801e-12, -1.286385301412046e-14,  3.443608610573057e-17, -8.701344040971858e-20,  2.053911141376563e-22, -4.429967098655657e-25,
  8.226463994565490e-28, -1.090433498424976e-30,  4.073454459383172e-02, -2.032572780879492e-04,  7.491292777171504e-07, -2.401867013823171e-09,  7.010201000455751e-12,
 -1.887593271889105e-14,  4.671473452710078e-17, -1.040530812179805e-19,  1.962443660906535e-22, -2.520834240225906e-25, -1.403767670620686e-28,  2.547410804617587e-30,
  6.081324620883138e-02, -3.016007943762650e-04,  1.096144901508480e-06, -3.424804374404992e-09,  9.567949895969764e-12, -2.395815647377638e-14,  5.226228877276461e-17,
 -9.026467418571327e-20,  7.310650363620457e-23,  2.966664766196409e-25, -2.047456349382833e-27,  8.086245415869831e-30,  8.487382895156728e-02, -4.178135837204808e-04,
  1.492567687056417e-06, -4.513625950854562e-09,  1.189946167872704e-11, -2.680619178105655e-14,  4.669218904646759e-17, -3.443305568491857e-20, -1.783622614087336e-22,
  1.146403943844959e-24, -4.334057687742351e-27,  1.257770322328247e-29,  1.128960627362098e-01, -5.508818702502153e-04,  1.927519860370616e-06, -5.597238380027775e-09,
  1.366332200776815e-11, -2.616381385395521e-14,  2.671087397930562e-17,  6.659824827948080e-20, -5.301143067374255e-22,  2.062946675159964e-24, -5.843290646618239e-27,
  1.165339741283062e-29,  1.448548125529612e-01, -6.995959601053186e-04,  2.388358915813305e-06, -6.596811679040361e-09,  1.451307130135957e-11, -2.097837433755345e-14,
 -9.046158277028793e-18,  2.046864532058953e-19, -9.047447746581027e-22,  2.651862064757306e-24, -5.115776114749673e-27,  1.470559686229352e-30,  1.807192580373745e-01,
 -8.625378040324331e-04,  2.860727528806370e-06, -7.428012004575134e-09,  1.412192335702759e-11, -1.056806881087512e-14, -5.925599795081614e-17,  3.585442801665833e-19,
 -1.180008264338741e-21,  2.442111749951592e-24, -9.658571534530461e-28, -1.852789088042472e-29,  2.204519464910987e-01, -1.038066890018766e-03,  3.328632774578054e-06,
 -8.003791085368721e-09,  1.221113726413599e-11,  5.209067722201409e-15, -1.193434775989213e-16,  4.940708640321007e-19, -1.207921618490570e-21,  1.036754891022369e-24,
  6.761790184076153e-27, -4.305940188129996e-29,  2.640076544385260e-01, -1.224304621415448e-03,  3.774565853823226e-06, -8.237821265751172e-09,  8.581612605852369e-12,
  2.579850881906480e-14, -1.812470190520697e-16,  5.675861807225354e-19, -8.495243339453980e-22, -1.689081379547863e-24,  1.648780307984791e-26, -6.016773048425384e-29,
  3.113320278817168e-01, -1.419117444778584e-03,  4.179676427556820e-06, -8.048665995947780e-09,  3.147845758651940e-12,  4.982389644155831e-14, -2.336679557558191e-16,
  5.324942936209918e-19, -2.303324242152005e-23, -5.388447239760593e-24,  2.459236538682425e-26, -5.370989730891121e-29,  3.623599658979412e-01, -1.620099149586630e-03,
  4.524019078934016e-06, -7.364766321644427e-09, -4.027243666809337e-12,  7.501759717900191e-14, -2.629582982093809e-16,  3.494824273635839e-19,  1.241612002488248e-21,
 -9.113538648287623e-24,  2.590224736531240e-26, -1.010157388024675e-29,  4.170137061205674e-01, -1.824552986381965e-03,  4.786893327159739e-06, -6.130298279946205e-09,
 -1.269898148519399e-11,  9.823756872340980e-14, -2.547791763868027e-16, -3.430140109035041e-22,  2.754715696639717e-21, -1.135004776472717e-23,  1.527465502354961e-26,
  7.143690561837115e-29,  4.752005640435600e-01, -2.029474563163930e-03,  4.947302894146852e-06, -4.311905280756559e-09, -2.241263081103377e-11,  1.156059443088876e-13,
 -1.965985206107896e-16, -5.010291323550668e-19,  4.144376859473517e-21, -1.030739340147699e-23, -9.724472280845527e-27,  1.686026444579558e-28,  5.368102712106224e-01,
 -2.231536910495114e-03,  4.984564268489833e-06, -1.906221420911542e-09, -3.248510555930129e-11,  1.228070188704146e-13, -8.097178313595910e-17, -1.089083407528038e-18,
  4.883211863660746e-21, -4.518481669498396e-24, -4.561995963208083e-26,  2.322351794479053e-28,  6.017118506167807e-01, -2.427079688814402e-03,  4.879098432853360e-06,
  1.052039648475777e-09, -4.200344294918646e-11,  1.155788122540371e-13,  9.065791999199445e-17, -1.647111355384048e-18,  4.387374919379126e-21,  6.294478040393318e-24,
 -8.065843753003927e-26,  1.973229409607256e-28,  6.697499618087274e-01, -2.612105288093378e-03,  4.613441868632363e-06,  4.481869703800709e-09, -4.984862773870130e-11,
  9.041850872988292e-14,  3.042097566515686e-16, -2.009760828226975e-18,  2.200746539609511e-21,  2.029761824226207e-23, -9.536682229190144e-26,  1.469572984319980e-29,
  7.407406444528281e-01, -2.782285585198686e-03,  4.173511874196145e-06,  8.248372373059892e-09, -5.475498006600286e-11,  4.549161868051548e-14,  5.302342802656559e-16,
 -1.988382300428787e-18, -1.748441909033806e-21,  3.299294607401222e-23, -6.828930847671668e-26, -3.003336618135389e-28,  8.144663894981848e-01, -2.932984420615022e-03,
  3.550154062052203e-06,  1.215695980014600e-08, -5.541602637234876e-11, -1.831961911981214e-14,  7.236126077257502e-16, -1.419079891013589e-18, -6.876005120731846e-21,
  3.765377997677041e-23,  1.211685824950854e-26, -6.240720408439127e-28,  8.906704744842563e-01, -3.059302460484283e-03,  2.740982474775678e-06,  1.595104883196568e-08,
 -5.064642114594072e-11, -9.637770009407561e-14,  8.274441640249092e-16, -2.333032012698589e-19, -1.177315470798423e-20,  2.736883498366932e-23,  1.319680111815799e-25,
 -7.275988054104274e-28,  9.690505184595581e-01, -3.156153009208215e-03,  1.752489164740355e-06,  1.931560068570968e-08, -3.960432146171940e-11, -1.795261740413925e-13,
  7.828675589436290e-16,  1.460713451984734e-18, -1.431571541748209e-20, -1.118545058156950e-24,  2.410829557343931e-25, -3.749897277647376e-28,  1.049251248748605e+00,
 -3.218379436899229e-03,  6.023424997572607e-07,  2.188948869175809e-08, -2.206726863353541e-11, -2.539998263014900e-13,  5.457587285495389e-16,  3.313659399068751e-18,
 -1.223475024788096e-20, -4.269450566018510e-23,  2.605022674937690e-25,  4.734784365905600e-28,  1.130856535206034e+00, -3.240926939092278e-03, -6.782973638354177e-07,
  2.329012604523760e-08,  1.265520413133963e-12, -3.025190578190769e-13,  1.091324215456382e-16,  4.734084524289259e-18, -4.220272445138582e-21, -8.091770634383816e-23,
  1.212049099506188e-25,  1.446776396382354e-27,  1.213380849150830e+00, -3.219082855559293e-03, -2.042750276909244e-06,  2.315366803795683e-08,  2.850224576909879e-11,
 -3.070827150752155e-13, -4.737584195348405e-16,  5.005794918649503e-18,  8.675878880195558e-21, -9.096348578971783e-23, -1.693652676573678e-25,  1.766378657900155e-27,
  1.296260457939244e+00, -3.148799854284247e-03, -3.427558442832773e-06,  2.119282196740186e-08,  5.641641905317100e-11, -2.537323298646191e-13, -1.075865020716530e-15,
  3.559520012132786e-18,  2.206412115638946e-20, -5.193383463008594e-23, -4.713695228534004e-25,  7.183344986967437e-28,  1.378844887313357e+00, -3.027113507021448e-03,
 -4.752697660954846e-06,  1.727103051138950e-08,  8.057030274797581e-11, -1.389059555437004e-13, -1.507240452244097e-15,  3.632576997680485e-19,  2.884247833924138e-20,
  3.343283327141050e-23, -5.413399259626071e-25, -1.474385727269851e-27,  1.460389484935701e+00, -2.852658064933422e-03, -5.924169274959100e-06,  1.148566913124239e-08,
  9.585733162381997e-11,  2.417082484765269e-14, -1.564868468602683e-15, -3.734110116019268e-18,  2.243100005255468e-20,  1.241565008833228e-22, -2.032846404793224e-25,
 -3.141169597115833e-27,  1.540050302656150e+00, -2.626268933638529e-03, -6.840011063545010e-06,  4.243511197334479e-09,  9.757207950017947e-11,  2.021187590063370e-13,
 -1.123614269585013e-15, -7.008579689607108e-18,  2.114663562126339e-21,  1.527269607489470e-22,  4.075808362010108e-25, -2.189271465572616e-27,  1.616882962242452e+00,
 -2.351634740352081e-03, -7.400653798223794e-06, -3.699836156944570e-09,  8.296100936801742e-11,  3.452129451132038e-13, -2.416466471163394e-16, -7.517975930401568e-18,
 -2.287429223958144e-20,  7.494220655260187e-23,  7.919570147165032e-25,  1.326665422382788e-27,  1.689847618755403e+00, -2.035924549675171e-03, -7.523986497069492e-06,
 -1.127444504701134e-08,  5.291263796742812e-11,  4.016674925035005e-13,  7.844999480591293e-16, -4.375803000813567e-18, -3.602983294800702e-20, -7.003618781351173e-23,
  4.868808700780752e-25,  3.910340399477593e-27,  1.757822464569679e+00, -1.690269016261126e-03, -7.164256741967931e-06, -1.724186857856711e-08,  1.306573968841586e-11,
  3.411892404271788e-13,  1.497203446454041e-15,  1.086469504629796e-18, -2.553426002491787e-20, -1.618277808933641e-22, -3.067307951776367e-25,  2.085430497217480e-27,
  1.819628226441135e+00, -1.329927511118528e-03, -6.331948424176458e-06, -2.046744216902810e-08, -2.663977550182111e-11,  1.783422725288897e-13,  1.517316898917432e-15,
  5.544840704509831e-18,  2.110915838936280e-21, -1.080240341011224e-22, -7.259234441312950e-25, -2.090507437957915e-27,  1.874065537362960e+00, -9.739461036533874e-04,
 -5.109376675013990e-06, -2.028252100923679e-08, -5.470272681888293e-11, -2.136671208426605e-14,  8.359857484664961e-16,  5.966143303303832e-18,  2.331667109433739e-20,
  3.268598705694002e-23, -2.909832749283767e-25, -2.811789522095981e-27,  1.919965662987001e+00, -6.441325967673981e-04, -3.654903162323869e-06, -1.682643076628850e-08,
 -6.277247784499354e-11, -1.674567329074522e-13, -9.101443740772098e-17,  2.482896507595937e-18,  2.010957094449328e-20,  9.906913323157836e-23,  3.192033496280484e-25,
  2.536972355600793e-28,  1.956252745565183e+00, -3.632733299458367e-04, -2.189001398000590e-06, -1.119836940910602e-08, -5.036192774218795e-11, -1.975679578959722e-13,
 -6.389617639876312e-16, -1.352364482832818e-18,  1.544800285981924e-21,  3.900907587331943e-23,  2.820565450101731e-25,  1.471995556407445e-27,  1.982012917536974e+00,
 -1.526994832000500e-04, -9.593795102132190e-07, -5.263027923215546e-09, -2.644883779968011e-11, -1.238513524227094e-13, -5.422064937460207e-16, -2.203825815674303e-18,
 -8.143254401079908e-21, -2.593562650115719e-23, -5.964366683492284e-26,  7.986706767059474e-30,  1.996566113249742e+00, -2.951658864485930e-05, -1.898156805385844e-07,
 -1.081507839859660e-09, -5.753544774678650e-12, -2.924056873861560e-14, -1.436432277792399e-16, -6.865699951092640e-19, -3.204915346209446e-21, -1.464071812132917e-23,
 -6.550550846339330e-26, -2.869980352599307e-28,  4.934713881411337e-04, -2.467050723274456e-06,  9.248284932990670e-09, -3.081120145924407e-11,  9.619814783871325e-14,
 -2.882536256630207e-16,  8.392666668633165e-19, -2.392999546101085e-21,  6.710526917639654e-24, -1.858347867425114e-26,  5.086907290078025e-29, -1.381829682516666e-31,
  4.440831299500297e-03, -2.217639270983507e-05,  8.292216575012009e-08, -2.750248983647594e-10,  8.527198818300158e-13, -2.529707107371126e-15,  7.265573555419045e-18,
 -2.034850043210948e-20,  5.576856802358705e-23, -1.500745018497381e-25,  3.964696350161458e-28, -1.031534101404366e-30,  1.233334065173086e-02, -6.145037263250424e-05,
  2.286031979335394e-07, -7.513503312437940e-10,  2.296650600010889e-12, -6.673413025819751e-15,  1.862080303138469e-17, -5.015335295340762e-20,  1.304892223005492e-22,
 -3.278716735718083e-25,  7.905661173566833e-28, -1.820071516912538e-30,  2.416649429784706e-02, -1.199978334602269e-04,  4.429551734204615e-07, -1.435759930887175e-09,
  4.292461434945842e-12, -1.206589528040481e-14,  3.208937222915819e-17, -8.068983406294096e-20,  1.900239488226427e-22, -4.110530187387165e-25,  7.745110733577980e-28,
 -1.094243826864315e-30,  3.993332166261277e-02, -1.973776550087204e-04,  7.209675893786298e-07, -2.292664008963264e-09,  6.643661521683705e-12, -1.778903972470504e-14,
  4.388779494831602e-17, -9.791933589161925e-20,  1.870938115153401e-22, -2.556193052413550e-25, -4.026142796199150e-29,  2.019347902325546e-30,  5.962412469125118e-02,
 -2.929934592696752e-04,  1.055950178242017e-06, -3.275483185523436e-09,  9.101126401605521e-12, -2.273391680059659e-14,  4.976912640375199e-17, -8.776951754914223e-20,
  8.239490211214709e-23,  2.215378979660014e-25, -1.717259998897352e-27,  6.948096128479880e-30,  8.322611718027594e-02, -4.060864999676020e-04,  1.439529028185989e-06,
 -4.327463006994774e-09,  1.137446269862310e-11, -2.569775674447668e-14,  4.565412913917388e-17, -3.951271944300453e-20, -1.400824531389876e-22,  9.837175412575770e-25,
 -3.809798874289169e-27,  1.126841349914696e-29,  1.107229553774300e-01, -5.357267019255975e-04,  1.861647525083836e-06, -5.382776006749064e-09,  1.314659776389826e-11,
 -2.550222572659866e-14,  2.834898254794261e-17,  5.077873322584543e-20, -4.599329390793176e-22,  1.839345467101503e-24, -5.340101290890858e-27,  1.119677503052244e-29,
  1.420941466283990e-01, -6.808018201383411e-04,  2.310576551756767e-06, -6.367968983431192e-09,  1.409178042682324e-11, -2.112989224175499e-14, -3.706192049905645e-18,
  1.772227577305682e-19, -8.129406809135200e-22,  2.449047777133332e-24, -5.012906147822826e-27,  3.124071014312242e-30,  1.773143193338214e-01, -8.400047037638921e-04,
  2.772939873314912e-06, -7.203826054081410e-09,  1.389713201136001e-11, -1.187392786356083e-14, -4.973224708631238e-17,  3.221817041937449e-19, -1.092971549027693e-21,
  2.388543399395428e-24, -1.680040981776940e-27, -1.406161533700363e-29,  2.163523334655645e-01, -1.011818681435164e-03,  3.233762497272434e-06, -7.807730436770438e-09,
  1.228777431588852e-11,  2.506500488901291e-15, -1.060446800922737e-16,  4.560631552834025e-19, -1.166168797966045e-21,  1.271275621132662e-24,  5.011162149931088e-27,
 -3.661823578675911e-29,  2.591702062772468e-01, -1.194501138102181e-03,  3.676552109502313e-06, -8.096618701281417e-09,  9.055354684949813e-12,  2.163616567721898e-14,
 -1.657434562450291e-16,  5.395506924840834e-19, -8.990837807656642e-22, -1.080944909045201e-24,  1.395830914500778e-26, -5.477700515668804e-29,  3.057218225329845e-01,
 -1.386065439334047e-03,  4.083426539399241e-06, -7.990628277775527e-09,  4.089449908453217e-12,  4.439452772944571e-14, -2.187962700035398e-16,  5.288386970125958e-19,
 -1.998829463183442e-22, -4.452275181757552e-24,  2.221286221537762e-26, -5.417995370482138e-29,  3.559513924837052e-01, -1.584261489333077e-03,  4.435303677837407e-06,
 -7.417538898350957e-09, -2.589187145883680e-12,  6.882821775761426e-14, -2.526644509494764e-16,  3.841634994131715e-19,  9.320354643368402e-22, -8.089770283592847e-24,
  2.520673771514976e-26, -2.101393388757295e-29,  4.097916138833459e-01, -1.786555401041778e-03,  4.712174406597944e-06, -6.318096033606853e-09, -1.079532799719239e-11,
  9.213234110196782e-14, -2.536152202929067e-16,  8.139392063228926e-20,  2.357807344273272e-21, -1.068295129444152e-23,  1.791865252696753e-26,  4.926152155559062e-29,
  4.671614865555077e-01, -1.990109033666961e-03,  4.893483875317648e-06, -4.652271291709825e-09, -2.014875591735350e-11,  1.107338748938423e-13, -2.088268926203256e-16,
 -3.744071682674025e-19,  3.768024797945561e-21, -1.055591703689943e-23, -2.896461353821088e-27,  1.418769869515182e-28,  5.279637194950091e-01, -2.191760544993626e-03,
  4.958651724343913e-06, -2.406449626482717e-09, -3.005077787563739e-11,  1.205152593404145e-13, -1.093052900320953e-16, -9.357557220952961e-19,  4.690124379037723e-21,
 -6.143196748628525e-24, -3.573010081423924e-26,  2.165665932545736e-28,  5.920816614946338e-01, -2.388007652013763e-03,  4.887767200914944e-06,  3.985799965683218e-10,
 -3.967376165180061e-11,  1.172172252100502e-13,  4.653407229468248e-17, -1.503695106773299e-18,  4.558044179401338e-21,  3.247096102910458e-24, -7.159792071730978e-26,
  2.128250073383463e-28,  6.593756773908065e-01, -2.574996042306261e-03,  4.662499746097936e-06,  3.699136329538371e-09, -4.797176146308529e-11,  9.705287006066746e-14,
  2.490270024407270e-16, -1.928379366506434e-18,  2.863120605519805e-21,  1.651416959360309e-23, -9.337441209025253e-26,  7.389333113748960e-29,  7.296788842491173e-01,
 -2.748516388140775e-03,  4.267268076799127e-06,  7.380243747213130e-09, -5.372242920453521e-11,  5.754390060694890e-14,  4.739509313304131e-16, -2.025879923432115e-18,
 -6.128023580771492e-22,  3.002410343204713e-23, -7.949118105128192e-26, -2.095457328827942e-28,  8.027921569008343e-01, -2.904014748991578e-03,  3.690708568758355e-06,
  1.126830188906672e-08, -5.561209337784989e-11, -1.453336460083380e-15,  6.810020645565649e-16, -1.617382421287310e-18, -5.518175062636063e-21,  3.761007206859643e-23,
 -1.376165565728904e-26, -5.499381034820967e-28,  8.784783130090735e-01, -3.036622865666788e-03,  2.927472882285033e-06,  1.512636167384902e-08, -5.237613370592457e-11,
 -7.663905649900200e-14,  8.157923196637240e-16, -5.933240014922641e-19, -1.070064403019839e-20,  3.200018132683396e-23,  9.948441413377050e-26, -7.434271872440523e-28,
  9.564553986756178e-01, -3.141216985614890e-03,  1.980359213420637e-06,  1.865424118861138e-08, -4.300391128066971e-11, -1.602982900545760e-13,  8.173611091623098e-16,
  1.003792196393201e-18, -1.418682834087949e-20,  8.145989544344322e-24,  2.209978873818389e-25, -5.322418206449982e-28,  1.036389023105309e+00, -3.212516385043779e-03,
  8.627326559096431e-07,  2.149651482341437e-08, -2.700900208993028e-11, -2.398338154789881e-13,  6.328435127680921e-16,  2.899602656089051e-18, -1.357985889253690e-20,
 -3.193343205241124e-23,  2.756771032603000e-25,  2.163625451489196e-28,  1.117883744622571e+00, -3.245235506413118e-03, -3.988934405281601e-07,  2.326215839108660e-08,
 -4.748022217230607e-12, -2.983271429692877e-13,  2.393655578301980e-16,  4.553484549204503e-18, -7.031143334783848e-21, -7.484583356349434e-23,  1.810542580672018e-25,
  1.263759260364551e-27,  1.200473603727636e+00, -3.234306199638553e-03, -1.762374589123431e-06,  2.356000113527768e-08,  2.225839172659120e-11, -3.167426668149933e-13,
 -3.302100907010732e-16,  5.229875232870745e-18,  5.298374412601736e-21, -9.614179387438928e-23, -8.868071598573989e-26,  1.885640540336888e-27,  1.283612049385647e+00,
 -3.175188115720375e-03, -3.168000514791588e-06,  2.205351987013328e-08,  5.109204237739439e-11, -2.782791637140227e-13, -9.666203436482459e-16,  4.232089481200242e-18,
  1.986404480480424e-20, -7.001298312719900e-23, -4.290955469189384e-25,  1.197334831625295e-27,  1.366661733365588e+00, -3.064284387603751e-03, -4.537808576274597e-06,
  1.853597030826155e-08,  7.743181297067674e-11, -1.748524177010815e-13, -1.483997357020478e-15,  1.301176693769831e-18,  2.964194975954036e-20,  1.062481067287908e-23,
 -5.953318937664266e-25, -9.627600144818332e-28,  1.448884975719167e+00, -2.899474010508886e-03, -5.777129692312899e-06,  1.302117914354547e-08,  9.595714721653263e-11,
 -1.455550179189117e-14, -1.658715291216172e-15, -2.946645188949751e-18,  2.672074330379366e-20,  1.132395194232932e-22, -3.427788506411692e-25, -3.170239665674639e-27,
  1.529436147111760e+00, -2.680758496633005e-03, -6.779593539142566e-06,  5.835471759791260e-09,  1.013289532679755e-10,  1.728099682754857e-13, -1.318059297450922e-15,
 -6.849995060042199e-18,  7.881034592135639e-21,  1.668796508979895e-22,  2.945634341484559e-25, -2.942152476479602e-27,  1.607357764178539e+00, -2.410994475163667e-03,
 -7.436860954445305e-06, -2.317614068214447e-09,  8.978980621388050e-11,  3.368073863014898e-13, -4.619478767435208e-16, -8.200570466187549e-18, -1.959393587240675e-20,
  1.075829164662122e-22,  8.346311091046128e-25,  5.788805054903535e-28,  1.681582701046429e+00, -2.096642605812021e-03, -7.653931929644194e-06, -1.036259708285040e-08,
  6.112366078883500e-11,  4.188927507059256e-13,  6.454858368230308e-16, -5.564997879004725e-18, -3.815831527045475e-20, -4.703438924295704e-23,  6.649982241312479e-25,
  4.154913530735876e-27,  1.750945455731771e+00, -1.748406594671131e-03, -7.369673320704292e-06, -1.697626549948965e-08,  2.025081711660426e-11,  3.773893820590274e-13,
  1.515293670059383e-15,  1.739884001793511e-19, -3.155627136190680e-20, -1.719831004374115e-22, -1.939053215210747e-25,  3.063850863622691e-27,  1.814205639840506e+00,
 -1.381572497557564e-03, -6.579990889148004e-06, -2.086311235602537e-08, -2.269617484007814e-11,  2.166247795946761e-13,  1.672892524983598e-15,  5.544388066647709e-18,
 -2.322164513294647e-21, -1.388298297188679e-22, -8.122304376085587e-25, -1.796320713442073e-27,  1.870086440410556e+00, -1.015809582310378e-03, -5.358028800854017e-06,
 -2.116003485919595e-08, -5.491545322456431e-11,  7.868838622248278e-16,  1.013643052771796e-15,  6.728604088794968e-18,  2.425229774160147e-20,  1.837976320301968e-23,
 -4.292039982844647e-25, -3.480895035071288e-27,  1.917329350899559e+00, -6.741968200392387e-04, -3.862957327452871e-06, -1.785767718340483e-08, -6.613743464462772e-11,
 -1.687307259794674e-13, -1.193041351268152e-17,  3.185947819615384e-18,  2.390782580374009e-20,  1.119762408023614e-22,  3.238271367532602e-25, -6.612196245486868e-29,
  1.954763757405154e+00, -3.813368670858542e-04, -2.328349704697734e-06, -1.203661708898830e-08, -5.446967021661133e-11, -2.133504700198356e-13, -6.759084981974536e-16,
 -1.278152275567630e-18,  3.168612663832415e-21,  5.167471644149876e-23,  3.534815133429959e-25,  1.781744650406430e-27,  1.981386359131420e+00, -1.606345316599329e-04,
 -1.025159024519058e-06, -5.706754103065155e-09, -2.906114858552926e-11, -1.376351189014977e-13, -6.077054313762391e-16, -2.479807489431120e-18, -9.119618380103295e-21,
 -2.829445196874407e-23, -5.775104957602869e-26,  8.319578006954689e-29,  1.996444925380145e+00, -3.108863712558896e-05, -2.033660388145843e-07, -1.178437109086477e-09,
 -6.374449692824115e-12, -3.293078841784774e-14, -1.643859790557310e-16, -7.980918234296982e-19, -3.782354066603083e-21, -1.753187736324224e-23, -7.953259053925699e-26,
 -3.529730932448201e-28,  4.837488525269021e-04, -2.394517646730963e-06,  8.887598774128935e-09, -2.931707962277380e-11,  9.062919483588851e-14, -2.688916126497985e-16,
  7.751711543097179e-19, -2.188585645070271e-21,  6.076728587135363e-24, -1.666524753237048e-26,  4.516371469206217e-29, -1.215326342520315e-31,  4.353431903871967e-03,
 -2.152598842369586e-05,  7.970208864078172e-08, -2.617768492372609e-10,  8.038243483475636e-13, -2.361973663851589e-15,  6.720008976802329e-18, -1.864737502594535e-20,
  5.064073523272047e-23, -1.350874991532152e-25,  3.537424027942844e-28, -9.131615135106127e-31,  1.209114057847879e-02, -5.965699716414123e-05,  2.198031453334360e-07,
 -7.156478553089726e-10,  2.167539977501417e-12, -6.242904122570262e-15,  1.727323650026120e-17, -4.616060215119465e-20,  1.192362416804031e-22, -2.977969129904220e-25,
  7.144695326901593e-28, -1.641882460974730e-30,  2.369348275348914e-02, -1.165219590720992e-04,  4.261303005326709e-07, -1.368970002609570e-09,  4.058665468045079e-12,
 -1.132218846637682e-14,  2.991300506987889e-17, -7.483994903794683e-20,  1.757721090379156e-22, -3.810326245313010e-25,  7.266073901174042e-28, -1.080758673048596e-30,
  3.915517479752284e-02, -1.917181817622896e-04,  6.940818548749647e-07, -2.189155361417137e-09,  6.298195177223297e-12, -1.676796552146483e-14,  4.122848690937229e-17,
 -9.207971586943433e-20,  1.778827008922170e-22, -2.555877917593192e-25,  3.864484893139074e-29,  1.580826376552769e-30,  5.846880057010213e-02, -2.847006396682987e-04,
  1.017503291720032e-06, -3.133438520960700e-09,  8.658195164052544e-12, -2.156864347511061e-14,  4.734960064698714e-17, -8.501795240023346e-20,  8.920474740899869e-23,
  1.586596352229675e-25, -1.433882572817210e-27,  5.955229476974915e-30,  8.162447907444824e-02, -3.947749307883074e-04,  1.388674651795860e-06, -4.149524096776890e-09,
  1.087137245712259e-11, -2.461580876256683e-14,  4.449013575303053e-17, -4.345720037294827e-20, -1.072955084023712e-22,  8.408783809261499e-25, -3.340972308185096e-27,
  1.005837102893188e-29,  1.086094308366449e-01, -5.210883576195884e-04,  1.798299575915813e-06, -5.176473377308283e-09,  1.264346383046113e-11, -2.480639187482816e-14,
  2.957440327501781e-17,  3.708007075220048e-20, -3.974440932481567e-22,  1.635434126748880e-24, -4.859603141110370e-27,  1.062933622168015e-29,  1.394074299759008e-01,
 -6.626190694118856e-04,  2.235499777977588e-06, -6.145884476931383e-09,  1.366868018555680e-11, -2.116215350923638e-14,  9.048277517205608e-19,  1.525809002876679e-19,
 -7.283475718700425e-22,  2.251665111338765e-24, -4.847456180582604e-27,  4.329619875921650e-30,  1.739981253781495e-01, -8.181632068628212e-04,  2.687820046689257e-06,
 -6.983433624129816e-09,  1.364842833281659e-11, -1.296312196600898e-14, -4.118798296017721e-17,  2.885683053669949e-19, -1.008332156397968e-21,  2.310118469593845e-24,
 -2.213965164849328e-27, -1.032018196194806e-29,  2.123562102746896e-01, -9.863200073106165e-04,  3.141250576404800e-06, -7.610859023491338e-09,  1.231346634455782e-11,
  1.104921152514456e-16, -9.379021713922938e-17,  4.195136491153437e-19, -1.117167074235370e-21,  1.441253321153797e-24,  3.530010541559420e-27, -3.081211428605971e-29,
  2.544504147344459e-01, -1.165474864359294e-03,  3.580275592798737e-06, -7.948482291672582e-09,  9.449506328966399e-12,  1.783632845416707e-14, -1.510439350283443e-16,
  5.102605276015998e-19, -9.285139796364576e-22, -5.692025483781931e-25,  1.166876576899213e-26, -4.929367603818076e-29,  3.002422899695404e-01, -1.353780399194836e-03,
  3.987959977170833e-06, -7.918374245436231e-09,  4.926024422485113e-12,  3.932024218997500e-14, -2.041012341265528e-16,  5.200447623024394e-19, -3.447445271871919e-22,
 -3.611246124521647e-24,  1.984566106479857e-26, -5.321494637973700e-29,  3.496847467932718e-01, -1.549135703539693e-03,  4.346089018591711e-06, -7.448279137795214e-09,
 -1.272374674998516e-12,  6.289645792228695e-14, -2.415327267907539e-16,  4.095215563737845e-19,  6.587059910113218e-22, -7.102564737406560e-24,  2.409469007080821e-26,
 -2.910027212289635e-29,  4.027203029309119e-01, -1.749164072830838e-03,  4.635380641258005e-06, -6.476409897474833e-09, -9.013321653539473e-12,  8.608109969004239e-14,
 -2.503366999016106e-16,  1.508325939564486e-19,  1.986591397782211e-21, -9.928686462580251e-24,  1.965589118127372e-26,  3.021701232632776e-29,  4.592789850727662e-01,
 -1.951189785618439e-03,  4.835794532362898e-06, -4.957209600398394e-09, -1.798497710430902e-11,  1.056095022024539e-13, -2.176794378059746e-16, -2.599211928303272e-19,
  3.387360972673043e-21, -1.055457319027918e-23,  2.776849143922337e-27,  1.162387213432083e-28,  5.192758215532474e-01, -2.152214832378366e-03,  4.926968508903412e-06,
 -2.868130771080599e-09, -2.766874150496553e-11,  1.175942641932524e-13, -1.334403817260692e-16, -7.894677447819055e-19,  4.445490582766956e-21, -7.387304895517750e-24,
 -2.661652063284920e-26,  1.972005498777347e-28,  5.826078504544634e-01, -2.348896995335221e-03,  4.888819001286094e-06, -2.173987708530409e-10, -3.732157378217460e-11,
  1.178453719833293e-13,  6.486352504724241e-18, -1.356501628826591e-18,  4.625668943172342e-21,  5.728652544237691e-25, -6.207021418190580e-26,  2.188099214839938e-28,
  6.491505561277651e-01, -2.537531384573021e-03,  4.702349150038467e-06,  2.947423171424871e-09, -4.597525540192112e-11,  1.023924594256839e-13,  1.963993348467726e-16,
 -1.827960936504027e-18,  3.391320583605200e-21,  1.285897249713072e-23, -8.904199340417393e-26,  1.210530070573943e-28,  7.187536353751540e-01, -2.714038512941088e-03,
  4.350713576739498e-06,  6.530490622380305e-09, -5.246240495977159e-11,  6.823678777477114e-14,  4.171097763853969e-16, -2.028825884237029e-18,  4.088429968585259e-22,
  2.668558145697294e-23, -8.681596162918747e-26, -1.246046447404947e-28,  7.912359842821282e-01, -2.873963324957703e-03,  3.820591304912871e-06,  1.037914814738413e-08,
 -5.548148566718887e-11,  1.432856499256229e-14,  6.334457355847767e-16, -1.772452740385119e-18, -4.179730846555250e-21,  3.660012278191589e-23, -3.611461375758189e-26,
 -4.647337316287823e-28,  8.663797904586588e-01, -3.012491373167327e-03,  3.103913960585841e-06,  1.427713874800275e-08, -5.371466569973670e-11, -5.729700089053730e-14,
  7.945636495777752e-16, -9.166083639744892e-19, -9.484873582244378e-21,  3.532779209627666e-23,  6.701016439904151e-26, -7.278438358333644e-28,  9.439236173769399e-01,
 -3.124490642079349e-03,  2.199979411760554e-06,  1.794160535782146e-08, -4.601169757008826e-11, -1.403953180405032e-13,  8.391675644899936e-16,  5.561637334234730e-19,
 -1.374045139221136e-20,  1.647927076671365e-23,  1.947877380420732e-25, -6.528153612680797e-28,  1.023554384177588e+00, -3.204590396586082e-03,  1.117942425672339e-06,
  2.102684931535198e-08, -3.164747766726533e-11, -2.237213952161537e-13,  7.077910457219636e-16,  2.448795887035584e-18, -1.452936057528420e-20, -2.079045645517119e-23,
  2.796508721659913e-25, -3.343206599031923e-29,  1.104898185807634e+00, -3.247311813012717e-03, -1.203991175266662e-07,  2.313881268580525e-08, -1.064693181225959e-11,
 -2.910802604646577e-13,  3.633186834977654e-16,  4.286879375915897e-18, -9.582429124420254e-21, -6.655766258427487e-23,  2.316340076203545e-25,  1.027816342849328e-27,
  1.187509979404992e+00, -3.247268746012450e-03, -1.477728078082392e-06,  2.386507607419299e-08,  1.585623469444152e-11, -3.228945304915740e-13, -1.819241679333152e-16,
  5.343524179980372e-18,  1.793554295370535e-21, -9.801573959842986e-23, -4.846711179347813e-27,  1.908961229916631e-27,  1.270862304033646e+00, -3.199460084817784e-03,
 -2.898641074405560e-06,  2.282524895984929e-08,  4.530442951341968e-11, -2.999866861573302e-13, -8.396246379676915e-16,  4.824209774728026e-18,  1.704852321312443e-20,
 -8.599243786720156e-23, -3.667558997595631e-25,  1.625432812731473e-27,  1.354333428979355e+00, -3.099676346464782e-03, -4.308065111035824e-06,  1.974498211489338e-08,
  7.358211116372906e-11, -2.099237863681171e-13, -1.434260511899345e-15,  2.251170300420221e-18,  2.958714479098412e-20, -1.386436360417112e-23, -6.247501995610522e-25,
 -3.624034747572193e-28,  1.437195672012182e+00, -2.945039967413500e-03, -5.611680341862288e-06,  1.455197538752384e-08,  9.526177749495748e-11, -5.525445389442744e-14,
 -1.728658050231016e-15, -2.029272870622857e-18,  3.051721740300896e-20,  9.677086341364756e-23, -4.795072344570355e-25, -3.012629123575940e-27,  1.518605122366627e+00,
 -2.734687329643259e-03, -6.699731988205931e-06,  7.482601230272380e-09,  1.044534537253517e-10,  1.389090705000089e-13, -1.505410619075906e-15, -6.499671101879137e-18,
  1.406767255751513e-20,  1.758638208453091e-22,  1.496280723200115e-25, -3.629971885214654e-27,  1.597594655512784e+00, -2.470575677806211e-03, -7.455832376537425e-06,
 -8.277696630494321e-10,  9.639613741229080e-11,  3.228982038619392e-13, -6.997135439372707e-16, -8.759131072772938e-18, -1.511626607690413e-20,  1.412125794204784e-22,
  8.399513868792982e-25, -3.681032239814050e-28,  1.673072904472430e+00, -2.158354198361050e-03, -7.772136178227609e-06, -9.316809435956256e-09,  6.964309194391061e-11,
  4.323752189181737e-13,  4.723551029676709e-16, -6.807662561135235e-18, -3.932843615146340e-20, -1.675308261868855e-23,  8.492385106664456e-25,  4.177364490326623e-27,
  1.743832632932550e+00, -1.808172747289427e-03, -7.571188951239382e-06, -1.658989465184024e-08,  2.816205567136261e-11,  4.136950152719638e-13,  1.505088309156244e-15,
 -9.360891993795180e-19, -3.785194658289134e-20, -1.767300165853103e-22, -3.553414910651270e-26,  4.148499666515048e-27,  1.808572476136467e+00, -1.435219683719759e-03,
 -6.832376887829012e-06, -2.118935716674711e-08, -1.794967419169562e-11,  2.586238717367667e-13,  1.826298152331975e-15,  5.383695798618217e-18, -7.922653873920721e-21,
 -1.727599688289816e-22, -8.803252687005061e-25, -1.252862163773584e-27,  1.865935844383107e+00, -1.059704421285629e-03, -5.617216122865143e-06, -2.203716877815538e-08,
 -5.464072537522649e-11,  2.746330968547493e-14,  1.212983048481915e-15,  7.511638917632736e-18,  2.456614036588885e-20, -2.059701489905720e-24, -5.979760536650451e-25,
 -4.195121284542436e-27,  1.914569373383850e+00, -7.059758929606003e-04, -4.083709973329924e-06, -1.894285667698667e-08, -6.950722381357178e-11, -1.678563128572718e-13,
  8.861060123677414e-17,  4.017983414375560e-18,  2.817028490856852e-20,  1.247435156733170e-22,  3.110649150154319e-25, -5.435086624218911e-28,  1.953200220207443e+00,
 -4.005565681725115e-04, -2.478161897155132e-06, -1.294316121120919e-08, -5.890172962883549e-11, -2.299884550596750e-13, -7.099771868399098e-16, -1.144103843904601e-18,
  5.303214208674212e-21,  6.748260278067516e-23,  4.394789327997405e-25,  2.133997685313909e-27,  1.980726973305144e+00, -1.691178471589665e-04, -1.096523416105843e-06,
 -6.194570760601889e-09, -3.196549894922415e-11, -1.530871980285901e-13, -6.813818883821169e-16, -2.788369824793009e-18, -1.017864986059124e-20, -3.050133774236612e-23,
 -5.177656374006769e-26,  1.955514049000400e-28,  1.996317224898218e+00, -3.277391575388168e-05, -2.181416813499218e-07, -1.285919441224413e-09, -7.074401410213536e-12,
 -3.715849366898902e-14, -1.885264872572121e-16, -9.298712302627097e-19, -4.474714163403931e-21, -2.104668137687439e-23, -9.680570568019701e-26, -4.351578210744187e-28,
  4.743107896932135e-04, -2.324799827468690e-06,  8.544319971225425e-09, -2.790904478722505e-11,  8.543255120176665e-14, -2.510014384138181e-16,  7.165253648809772e-19,
 -2.003391041557032e-21,  5.508049266419521e-24, -1.496123430658222e-26,  4.014252100519471e-29, -1.070326744644814e-31,  4.268583592560706e-03, -2.090072189724647e-05,
  7.663640259282727e-08, -2.492849868433409e-10,  7.581563126334705e-13, -2.206780247343837e-15,  6.219857456114417e-18, -1.710202768816314e-20,  4.602288585540340e-23,
 -1.217098154196267e-25,  3.158984374067168e-28, -8.092442199879450e-31,  1.185597587091685e-02, -5.793234287268076e-05,  2.114194063706693e-07, -6.819439878450172e-10,
  2.046724966522529e-12, -5.843434962798703e-15,  1.603258431978977e-17, -4.251119611418539e-20,  1.090130042531052e-22, -2.706144764861353e-25,  6.458224355573728e-28,
 -1.481197845735983e-30,  2.323411049644191e-02, -1.131775402307507e-04,  4.100849441748742e-07, -1.305804599918511e-09,  3.839234314697014e-12, -1.062879945204586e-14,
  2.789420970877419e-17, -6.942919954793258e-20,  1.625666929897483e-22, -3.529124859416976e-25,  6.795902683523635e-28, -1.054630629024465e-30,  3.839924338968290e-02,
 -1.862689184138750e-04,  6.684057221992999e-07, -2.091014216253377e-09,  5.972525155100152e-12, -1.580878588428923e-14,  3.872856595537007e-17, -8.653426041707136e-20,
  1.687250994647239e-22, -2.527628035277483e-25,  9.996052080004222e-29,  1.217606974140205e-30,  5.734604320479268e-02, -2.767086957416467e-04,  9.807191787068948e-07,
 -2.998297440916434e-09,  8.237995066042329e-12, -2.046049163293656e-14,  4.500984434171224e-17, -8.208258550091590e-20,  9.394483577150884e-23,  1.062817392148397e-25,
 -1.191305899858696e-27,  5.090865238086634e-30,  8.006728690764159e-02, -3.838617907584675e-04,  1.339907954736523e-06, -3.979463072071353e-09,  1.038963346378773e-11,
 -2.356300803447279e-14,  4.322963761624061e-17, -4.643125746815135e-20, -7.932578198391077e-23,  7.157568264755923e-25, -2.923193205475978e-27,  8.947880689055439e-30,
  1.065534615931003e-01, -5.069470301657221e-04,  1.737379421523258e-06, -4.978108085869152e-09,  1.215451074595467e-11, -2.408553136805454e-14,  3.044317904412065e-17,
  2.526725756509419e-20, -3.419563328154027e-22,  1.450219861221319e-24, -4.405765021354583e-27,  9.990707751168647e-30,  1.367922598138631e-01, -6.450263879137323e-04,
  2.163047398209838e-06, -5.930568952495624e-09,  1.324598702914893e-11, -2.109173059452784e-14,  4.862714696105139e-18,  1.305337040564869e-19, -6.507293728697348e-22,
  2.061848017301927e-24, -4.637293718258300e-27,  5.168915861757234e-30,  1.707679521450850e-01, -7.969921589702730e-04,  2.605320370031573e-06, -6.767183896898938e-09,
  1.337991673058510e-11, -1.385824452373127e-14, -3.354742756915064e-17,  2.576143826897724e-19, -9.268625950341118e-22,  2.213434437463024e-24, -2.597662885920820e-27,
 -7.219564336924052e-30,  2.084606165569992e-01, -9.615519752767678e-04,  3.051102048385690e-06, -7.413944263968573e-09,  1.229409732087085e-11, -2.003507333870698e-15,
 -8.253634635089886e-17,  3.846191592446461e-19, -1.063052721297540e-21,  1.556906997331278e-24,  2.290342466235471e-27, -2.563982451699154e-29,  2.498451992646109e-01,
 -1.137211590645737e-03,  3.485812105000462e-06, -7.794628542084594e-09,  9.771122203500120e-12,  1.437934822765832e-14, -1.371750768933726e-16,  4.803061560479177e-19,
 -9.411118763038830e-22, -1.442294287556975e-25,  9.619254279588038e-27, -4.389101207413622e-29,  2.948903759041960e-01, -1.322255403400501e-03,  3.893437487276553e-06,
 -7.833527837022445e-09,  5.664617498865473e-12,  3.459518625508240e-14, -1.897129044670600e-16,  5.070815188444579e-19, -4.610200718807836e-22, -2.863715689723184e-24,
  1.754573897183558e-26, -5.117706153987384e-29,  3.435571749690948e-01, -1.514724761299614e-03,  4.256628023146520e-06, -7.458884719466272e-09, -7.147324475073318e-14,
  5.723942392960841e-14, -2.298081509004154e-16,  4.266924647160081e-19,  4.200363210519181e-22, -6.166213025415975e-24,  2.268175086740032e-26, -3.475556544574942e-29,
  3.957973172314252e-01, -1.712394218269284e-03,  4.556854203938594e-06, -6.607174946047629e-09, -7.351402635516198e-12,  8.013055737466275e-14, -2.452760329276484e-16,
  2.088386404535883e-19,  1.643586127774828e-21, -9.120783694529205e-24,  2.062278580121214e-26,  1.422408107913978e-29,  4.515512151979538e-01, -1.912746108663269e-03,
  4.774650235909237e-06, -5.228357826270258e-09, -1.592555780987221e-11,  1.003097607904050e-13, -2.234966061887380e-16, -1.575740671431925e-19,  3.010562622538635e-21,
 -1.034839157482539e-23,  7.357951991117388e-27,  9.231680021637731e-29,  5.107455653513318e-01, -2.112944102905215e-03,  4.889971769181721e-06, -3.292196788889825e-09,
 -2.535059041641525e-11,  1.141422560992455e-13, -1.535952473885795e-16, -6.516560128805604e-19,  4.162418161359940e-21, -8.284678354882859e-24, -1.840993154157581e-26,
  1.755566976617578e-28,  5.732904529595068e-01, -2.309806850816975e-03,  4.882705115735928e-06, -7.956928465352838e-10, -3.496609969912653e-11,  1.175619887054736e-13,
 -2.942360029393336e-17, -1.208610595654764e-18,  4.603922240196663e-21, -1.717446795815989e-24, -5.245990223871605e-26,  2.168425488798561e-28,  6.390758747327228e-01,
 -2.499783463115004e-03,  4.733372965184653e-06,  2.228440806911285e-09, -4.388435108496436e-11,  1.065045150379598e-13,  1.468004958854150e-16, -1.712708206204142e-18,
  3.791520901525205e-21,  9.415065801005869e-24, -8.289582852927928e-26,  1.564213638715020e-28,  7.079675690534225e-01, -2.678933503393519e-03,  4.424089818798090e-06,
  5.702534663522474e-09, -5.100215291580838e-11,  7.756807875491759e-14,  3.606254020963296e-16, -2.001051555429554e-18,  1.305907526266773e-21,  2.312648758412872e-23,
 -9.058144949520690e-26, -4.811758607759615e-29,  7.798020279889158e-01, -2.842915459310280e-03,  3.939826945859308e-06,  9.494545830166601e-09, -5.504698029750376e-11,
  2.892181115644527e-14,  5.821404076574186e-16, -1.885439676797552e-18, -2.892816030967411e-21,  3.477309167089095e-23, -5.457414270369848e-26, -3.738083207443524e-28,
  8.543805519190727e-01, -2.986989449617480e-03,  3.270048532575931e-06,  1.340956335972297e-08, -5.467216151361289e-11, -3.856855891498185e-14,  7.648439143890483e-16,
 -1.199320227358227e-18, -8.172449557111748e-21,  3.737840096094939e-23,  3.582953652358718e-26, -6.854701462204180e-28,  9.314622001003572e-01, -3.106042331178601e-03,
  2.410772449153000e-06,  1.718405362863437e-08, -4.861719660025344e-11, -1.201175104434420e-13,  8.486840000715900e-16,  1.274072627090908e-19, -1.301412272594821e-20,
  2.366942343483136e-23,  1.641252671713597e-25, -7.344620580208761e-28,  1.010755495117323e+00, -3.194646510475735e-03,  1.367081854593902e-06,  2.048563956817951e-08,
 -3.594675603028238e-11, -2.059647674054044e-13,  7.697510137430256e-16,  1.974032880744065e-18, -1.507745871715444e-20, -9.703334563582146e-24,  2.730296475136039e-25,
 -2.633237426538363e-28,  1.091908766051841e+00, -3.247167678073438e-03,  1.560540608842735e-07,  2.292240286268609e-08, -1.637180612689077e-11, -2.809570185903744e-13,
  4.787114064349195e-16,  3.943776461818222e-18, -1.180153823660851e-20, -5.646610479088963e-23,  2.709520814727528e-25,  7.546188116452589e-28,  1.174499079957555e+00,
 -3.257941226177773e-03, -1.190038706313674e-06,  2.406692642060640e-08,  9.366821087777630e-12, -3.254620585829734e-13, -3.203175840196245e-17,  5.344586988264258e-18,
 -1.718379748634374e-21, -9.654428811178834e-23,  7.788908971138596e-26,  1.836271270456305e-27,  1.258019836943156e+00, -3.221541741518805e-03, -2.620590271366034e-06,
  2.350107408973837e-08,  3.911443329224168e-11, -3.184580536164529e-13, -6.973937600415289e-16,  5.317546073648617e-18,  1.370697389550437e-20, -9.912298743017289e-23,
 -2.872277620834824e-25,  1.974328676083158e-27,  1.341867322990036e+00, -3.133173424998336e-03, -4.064205987826081e-06,  2.088686116034527e-08,  6.904506890539562e-11,
 -2.434832925013064e-13, -1.358082247917102e-15,  3.185130116402770e-18,  2.863608991079972e-20, -3.898322277798661e-23, -6.264201447288741e-25,  2.922175770667594e-28,
  1.425326867658425e+00, -2.989209102845989e-03, -5.427955324282616e-06,  1.606505165124767e-08,  9.373779155727205e-11, -9.731065221611635e-14, -1.771310122345656e-15,
 -1.000937859891244e-18,  3.362457142373205e-20,  7.502946792399494e-23, -6.049801552405232e-25, -2.658147596968767e-27,  1.507559786386000e+00, -2.787897411265714e-03,
 -6.599828087455089e-06,  9.174057999289164e-09,  1.068558831785129e-10,  1.006520781528503e-13, -1.680140944670941e-15, -5.947376054811301e-18,  2.046638633308077e-20,
  1.784783558526066e-22, -2.298524361550348e-26, -4.189684339095420e-27,  1.587593034228268e+00, -2.530235365553433e-03, -7.456301656151882e-06,  7.652355137963749e-10,
  1.026660428107221e-10,  3.031122783477694e-13, -9.509311033659202e-16, -9.155079197047462e-18, -9.434624646367904e-21,  1.741689734720325e-22,  7.997331424338669e-25,
 -1.484212036249744e-27,  1.664314453036681e+00, -2.220958890838829e-03, -7.876964975010894e-06, -8.132791351036154e-09,  7.838778531587741e-11,  4.412818411182195e-13,
  2.640795549815440e-16, -8.068909533638338e-18, -3.927626279353394e-20,  2.083715745107098e-23,  1.028336576152925e-24,  3.910464084077729e-27,  1.736477553747450e+00,
 -1.869530272250463e-03, -7.767284763955750e-06, -1.607115937287599e-08,  3.679432179084517e-11,  4.493598567340036e-13,  1.460963886422617e-15, -2.249045387521439e-18,
 -4.419279442461490e-20, -1.741679223186437e-22,  1.719119965262134e-25,  5.283071616645860e-27,  1.802720662625643e+00, -1.490900261444994e-03, -7.088193797879161e-06,
 -2.143273998017873e-08, -1.232684831580566e-11,  3.042293087683381e-13,  1.972508294945923e-15,  5.023770290881438e-18, -1.478711296004636e-20, -2.088490836052261e-22,
 -9.179319896386660e-25, -4.009416491114490e-28,  1.861605455501555e+00, -1.105714744265068e-03, -5.886884209179557e-06, -2.290537141830702e-08, -5.378284868209719e-11,
  5.918740195350604e-14,  1.434268355507097e-15,  8.291578847878660e-18,  2.401502483511521e-20, -2.988312486888150e-23, -7.984227967520752e-25, -4.911834370666397e-27,
  1.911678663769355e+00, -7.395739900259623e-04, -4.317807248770041e-06, -2.008167358201562e-08, -7.283342637707134e-11, -1.642735182786393e-13,  2.144263342840766e-16,
  4.993628741453072e-18,  3.287760905563280e-20,  1.365239724198368e-22,  2.730084830711158e-25, -1.223885364493340e-27,  1.951557336577344e+00, -4.210195120082981e-04,
 -2.639289217922679e-06, -1.392332336521910e-08, -6.367437899357485e-11, -2.473907793014802e-13, -7.392457532649015e-16, -9.319479002241833e-19,  8.072659580902231e-21,
  8.705196415102838e-23,  5.418287644379252e-25,  2.523685510899029e-27,  1.980032474165498e+00, -1.781963070997692e-04, -1.174030942993754e-06, -6.731428438049742e-09,
 -3.519729316039435e-11, -1.704150900329033e-13, -7.641840917326717e-16, -3.132035726900398e-18, -1.131151104564213e-20, -3.235640473576436e-23, -3.978556983299343e-26,
  3.594099803227181e-28,  1.996182538445320e+00, -3.458275569831393e-05, -2.342772030303962e-07, -1.405310214031131e-09, -7.865013283194876e-12, -4.201247443696066e-14,
 -2.166870116000432e-16, -1.085971441814047e-18, -5.306966352725586e-21, -2.533039972276223e-23, -1.181268046948779e-25, -5.377489779171234e-28,  4.651462107261002e-04,
 -2.257762039739785e-06,  8.217450273084586e-09, -2.658136856928474e-11,  8.058004569236520e-14, -2.344585387551017e-16,  6.628192088267434e-19, -1.835450214690628e-21,
  4.997247723423473e-24, -1.344587568559250e-26,  3.571744782405593e-29, -9.439196874202410e-32,  4.186188228529248e-03, -2.029939343976296e-05,  7.371633511667280e-08,
 -2.374996198549021e-10,  7.154755292849606e-13, -2.063087494003275e-15,  5.760977232111056e-18, -1.569702942883861e-20,  4.186045217685236e-23, -1.097582844245666e-25,
  2.823427926943935e-28, -7.179587862056048e-31,  1.162757815658580e-02, -5.627317297211501e-05,  2.034287740788989e-07, -6.501108292129449e-10,  1.933609671785838e-12,
 -5.472551336570093e-15,  1.488967890966677e-17, -3.917379300784392e-20,  9.972056853856274e-23, -2.460413317974246e-25,  5.838885588010772e-28, -1.336494519985894e-30,
  2.278786390673572e-02, -1.099585109491087e-04,  3.947769565067089e-07, -1.246041735284784e-09,  3.633198459468186e-12, -9.982090342867037e-15,  2.602114891926567e-17,
 -6.442518671871342e-20,  1.503400532121230e-22, -3.266471726976045e-25,  6.339309580111274e-28, -1.019589045614572e-30,  3.766470555267938e-02, -1.810204404971105e-04,
  6.438766415851881e-07, -1.997933530400221e-09,  5.665451151105238e-12, -1.490777408072257e-14,  3.637983363699691e-17, -8.127977774296695e-20,  1.597096714543633e-22,
 -2.477854203912523e-25,  1.467241973941797e-28,  9.175189723878730e-31,  5.625467518094282e-02, -2.690046505769760e-04,  9.455171410190152e-07, -2.869705280956412e-09,
  7.839403202201789e-12, -1.940749219580008e-14,  4.275413133082565e-17, -7.902390506311588e-20,  9.696512419104111e-23,  6.288063521821479e-26, -9.842191821287841e-28,
  4.339629085181890e-30,  7.855297977554766e-02, -3.733307508194777e-04,  1.293136432481334e-06, -3.816943093377862e-09,  9.928641725749432e-12, -2.254136145538243e-14,
  4.189774160989163e-17, -4.857922192048132e-20, -5.557114306981335e-23,  6.063980605534752e-25, -2.552124623481245e-27,  7.934604296471361e-30,  1.045530978263582e-01,
 -4.932836743057220e-04,  1.678793190270748e-06, -4.787449682143289e-09,  1.168015759757090e-11, -2.334759474139328e-14,  3.100507683763797e-17,  1.512681709304354e-20,
 -2.928164243824245e-22,  1.282583259728020e-24, -3.981013700765046e-27,  9.311629295694028e-30,  1.342463173415896e-01, -6.280031051415344e-04,  2.093138288828028e-06,
 -5.722000294731520e-09,  1.282560364481263e-11, -2.093345183806499e-14,  8.237037767144751e-18,  1.108626446392633e-19, -5.797852180412344e-22,  1.881084058784853e-24,
 -4.396957486699413e-27,  5.711735443833708e-30,  1.676211594389209e-01, -7.764708028365320e-04,  2.525389353687157e-06, -6.555363901052205e-09,  1.309526771548705e-11,
 -1.458010299174001e-14, -2.673762652761587e-17,  2.292090903516843e-19, -8.491186067262299e-22,  2.103960323866042e-24, -2.857553852173876e-27, -4.679854377655161e-30,
  2.046626675449616e-01, -9.374956879465605e-04,  2.963313289452194e-06, -7.217663302318236e-09,  1.223507112289065e-11, -3.858939239404327e-15, -7.223471783817509e-17,
  3.515138091232216e-19, -1.005614217296493e-21,  1.627342807060311e-24,  1.264640240593255e-27, -2.108202788595622e-29,  2.453515372834294e-01, -1.109696557513600e-03,
  3.393223513515544e-06, -7.636164256158909e-09,  1.002685888547615e-11,  1.124512395563521e-14, -1.241483951918145e-16,  4.501780760267596e-19, -9.398295706971629e-22,
  2.034641810453457e-25,  7.803270143671452e-27, -3.869646111510494e-29,  2.896630561848211e-01, -1.291482321061230e-03,  3.800001001103232e-06, -7.737601316616526e-09,
  6.312131185294060e-12,  3.021069836552675e-14, -1.757357169307928e-16,  4.908104705824714e-19, -5.520165815168263e-22, -2.206143208480666e-24,  1.535332469332489e-26,
 -4.837479909209084e-29,  3.375658151818623e-01, -1.481029697944440e-03,  4.167151363550889e-06, -7.451165566510112e-09,  1.019136017933109e-12,  5.186871689945371e-14,
 -2.177047264518749e-16,  4.367539258091279e-19,  2.140038090379523e-22, -5.290725962437288e-24,  2.106635867194882e-26, -3.836458304036560e-29,  3.890201452153531e-01,
 -1.676258408885943e-03,  4.476914225736260e-06, -6.712294247743244e-09, -5.807154641190548e-12,  7.431974789905245e-14, -2.387404451417787e-16,  2.563400102059080e-19,
  1.330199809937632e-21, -8.287416597805670e-24,  2.095007986227248e-26,  1.109631918244543e-30,  4.439762218950937e-01, -1.874804049132675e-03,  4.710446345199787e-06,
 -5.467409937713143e-09, -1.397330434886839e-11,  9.490344154108993e-14, -2.266155044640209e-16, -6.713238504693110e-20,  2.644236998433441e-21, -9.979412271462342e-24,
  1.093231700406433e-26,  7.053166556872884e-29,  5.023717687735008e-01, -2.073989077392964e-03,  4.848106419830962e-06, -3.679749699330395e-09, -2.310600950912395e-11,
  1.102517847496319e-13, -1.700226168122986e-16, -5.233580187165431e-19,  3.852715781906137e-21, -8.873230285427763e-24, -1.118322328337208e-26,  1.528412485124522e-28,
  5.641292751736641e-01, -2.270792735537804e-03,  4.869877491914401e-06, -1.336390099233461e-09, -3.262457697349748e-11,  1.164663057726527e-13, -6.121421448306083e-17,
 -1.062660775597301e-18,  4.506604565253781e-21, -3.627065227509328e-24, -4.308188638135212e-26,  2.085099013530881e-28,  6.291526275725203e-01, -2.461821287727668e-03,
  4.755972226279773e-06,  1.543507285272514e-09, -4.172284098469488e-11,  1.094662577668392e-13,  1.005897396224121e-16, -1.586582463677595e-18,  4.072510505848296e-21,
  6.244808216355524e-24, -7.544011861979639e-26,  1.807315308731808e-28,  6.973230344439371e-01, -2.643280814900379e-03,  4.487676694468286e-06,  4.899362409546738e-09,
 -4.936875205120853e-11,  8.555620144278211e-14,  3.053011621401368e-16, -1.946643858305460e-18,  2.072918338160126e-21,  1.948117856068236e-23, -9.120112419656353e-26,
  1.816633248839655e-29,  7.684941038943135e-01, -2.810956029518978e-03,  4.048498483604116e-06,  8.619162623361733e-09, -5.433315576357648e-11,  4.225035364866348e-14,
  5.282371249823420e-16, -1.958432349151206e-18, -1.683995012601470e-21,  3.228828908519664e-23, -6.899660530245438e-26, -2.819674326380254e-28,  8.424859129606287e-01,
 -2.960200325346778e-03,  3.425692508397447e-06,  1.252962322935652e-08, -5.526283762992311e-11, -2.064357634151710e-14,  7.278056178434587e-16, -1.439090030136759e-18,
 -6.808142630220248e-21,  3.822577051636659e-23,  7.003739673085559e-27, -6.217464340909269e-28,  9.190778902222464e-01, -3.085944716274624e-03,  2.612238150406193e-06,
  1.638806674208122e-08, -5.081581339639548e-11, -9.975251361323892e-14,  8.465578378469587e-16, -2.742082151624580e-19, -1.205178663366532e-20,  2.957271116049320e-23,
  1.307265139092108e-25, -7.774216688392879e-28,  9.980003250857168e-01, -3.182736628913162e-03,  1.609326004494699e-06,  1.987855867274725e-08, -3.987711689331058e-11,
 -1.868822361617983e-13,  8.182315964343712e-16,  1.488046494194466e-18, -1.523355181317735e-20,  9.248618563473504e-25,  2.569247635385739e-25, -4.630317859979897e-28,
  1.078924327462660e+00, -3.244823846196048e-03,  4.293678929793424e-07,  2.261616183503820e-08, -2.186733951654597e-11, -2.681873122963719e-13,  5.835597280286197e-16,
  3.535754362862547e-18, -1.363200678992270e-20, -4.504940886070909e-23,  2.977449485248684e-25,  4.613825929956433e-28,  1.161450106464549e+00, -3.266304270306449e-03,
 -9.005511760377713e-07,  2.416473058701575e-08,  2.861968167282261e-12, -3.244444392985112e-13,  1.163295363277441e-16,  5.234746298529540e-18, -5.118789681680950e-21,
 -9.185438757330185e-23,  1.554236506917579e-25,  1.674144662235093e-27,  1.245093540988990e+00, -3.241368262717331e-03, -2.335035384426779e-06,  2.407509380416127e-08,
  3.259019980122732e-11, -3.333626161627974e-13, -5.429129994711244e-16,  5.697031897435413e-18,  9.953426646742099e-21, -1.087940235028828e-22, -1.945255308794721e-25,
  2.221011917718769e-27,  1.329271215406751e+00, -3.164666104748738e-03, -3.807101675502897e-06,  2.195088616387034e-08,  6.385721621246888e-11, -2.749049834254695e-13,
 -1.256314888099600e-15,  4.074231641385205e-18,  2.678656492473452e-20, -6.358577511221383e-23, -5.988378332285644e-25,  9.601080468003536e-28,  1.413284440687129e+00,
 -3.031836289238735e-03, -5.226247604226721e-06,  1.754696951224091e-08,  9.136483229744730e-11, -1.400345005309519e-13, -1.783901096356882e-15,  1.133747408330529e-19,
  3.586317732579842e-20,  4.863846436878506e-23, -7.105892076053276e-25, -2.111929717613508e-27,  1.496303337936046e+00, -2.840226477899585e-03, -6.479422044554527e-06,
  1.089761034719693e-08,  1.084526098827808e-10,  5.841030506559596e-14, -1.836536000265070e-15, -5.190193928739898e-18,  2.682946993560769e-20,  1.737475692549314e-22,
 -2.162473463191694e-25, -4.558568387998605e-27,  1.577352890117974e+00, -2.589820670094901e-03, -7.437067091958978e-06,  2.455062455347333e-09,  1.084791502565471e-10,
  2.771857203903696e-13, -1.210514256802351e-15, -9.350640858834793e-18, -2.607706155398517e-21,  2.044957087225719e-22,  7.076225887342134e-25, -2.716081244310127e-27,
  1.655303998929162e+00, -2.284342990552187e-03, -7.966741098360156e-06, -6.807716691110591e-09,  8.725777095118412e-11,  4.447675590010981e-13,  2.072559974431392e-17,
 -9.305481150038226e-18, -3.774561290417385e-20,  6.525764486321547e-23,  1.188208434898785e-24,  3.294761095998908e-27,  1.728873949739097e+00, -1.932429262670443e-03,
 -7.956303738505364e-06, -1.540867190979368e-08,  4.612619917368420e-11,  4.835017751657867e-13,  1.377261839991937e-15, -3.761733853138134e-18, -5.028002883484730e-20,
 -1.623124352069378e-22,  4.288935454841973e-25,  6.383965991795177e-27,  1.796642017488359e+00, -1.548637456876958e-03, -7.346360803697461e-06, -2.157867394017091e-08,
 -5.757772984942783e-12,  3.531968234473452e-13,  2.105368316047195e-15,  4.423183856253625e-18, -2.296789130667825e-20, -2.455897120467118e-22, -9.102615609130317e-25,
  8.131297355319874e-28,  1.857086645050710e+00, -1.153923802187265e-03, -6.166866478228713e-06, -2.375447624379856e-08, -5.223562719922604e-11,  9.648142621401716e-14,
  1.676983113797577e-15,  9.036248335075884e-18,  2.231045367532036e-20, -6.634205704062938e-23, -1.029289449197262e-24, -5.564642132077345e-27,  1.908649728391425e+00,
 -7.751004266742515e-04, -4.565886720300110e-06, -2.127296281792553e-08, -7.605547491925678e-11, -1.573259277579438e-13,  3.697303193473074e-16,  6.126337459196461e-18,
  3.797377500191736e-20,  1.461124808487426e-22,  1.996161384607521e-25, -2.158505723029455e-27,  1.949829946774575e+00, -4.428198470429519e-04, -2.812648262070700e-06,
 -1.498266823863997e-08, -6.880156350609733e-11, -2.654135703808689e-13, -7.612215021187072e-16, -6.190735394500402e-19,  1.162450610239873e-20,  1.110668109449780e-22,
  6.619359293635613e-25,  2.938282511912294e-27,  1.979300378987838e+00, -1.879215025286592e-04, -1.258302809539047e-06, -7.322878605823847e-09, -3.879631859424682e-11,
 -1.898498611144561e-13, -8.571257546328537e-16, -3.512913910113036e-18, -1.250061104589599e-20, -3.356838848020778e-23, -1.910722498734980e-26,  5.941053256298073e-28,
  1.996040349076968e+00, -3.652663324394523e-05, -2.519246394966378e-07, -1.538165677153603e-09, -8.759833512617800e-12, -4.759791548886025e-14, -2.496156010346993e-16,
 -1.271344992990319e-18, -6.309935762155519e-21, -3.056438431986392e-23, -1.445062236447169e-25, -6.660658942672024e-28,  4.562446520673513e-04, -2.193276776321030e-06,
  7.906057544778966e-09, -2.532875404217722e-11,  7.604588025216021e-14, -2.191499565703195e-16,  6.135945205529837e-19, -1.683015293996993e-21,  4.537942580592067e-24,
 -1.209688701763746e-26,  3.181229481615437e-29, -8.336216861052248e-32,  4.106152336829720e-03, -1.972087121905564e-05,  7.093368762399114e-08, -2.263747398295231e-10,
  6.755615801519086e-13, -1.929950449498982e-15,  5.339635068365659e-18, -1.441859636183176e-20,  3.810505074341697e-23, -9.907200925574426e-26,  2.525551299285064e-28,
 -6.377316625308990e-31,  1.140569164835538e-02, -5.467643035141350e-05,  1.958095206633593e-07, -6.200296330872662e-10,  1.827645151255867e-12, -5.128008873577944e-15,
  1.383618742716805e-17, -3.612005965337213e-20,  9.126966794253120e-23, -2.238225916712096e-25,  5.279960441970746e-28, -1.206369417099305e-30,  2.235425297048964e-02,
 -1.068591320256996e-04,  3.801667628165234e-07, -1.189474366494667e-09,  3.439658376104962e-12, -9.378696694691267e-15,  2.428286260720356e-17, -5.979764689611176e-20,
  1.390264795951120e-22, -3.021754568286642e-25,  5.899534642063258e-28, -9.786254919806246e-31,  3.695077612004967e-02, -1.759638095265815e-04,  6.204356349789483e-07,
 -1.909624880030945e-09,  5.375845436859220e-12, -1.406139876855243e-14,  3.417421728849087e-17, -7.631058561912845e-20,  1.509040659026794e-22, -2.411853481456091e-25,
  1.814788066082918e-28,  6.701544193401291e-31,  5.519356972717984e-02, -2.615761561255232e-04,  9.118206299632201e-07, -2.747325023060477e-09,  7.461336943588528e-12,
 -1.840759262103865e-14,  4.058519060720048e-17, -7.589203855340755e-20,  9.856438543476895e-23,  2.713205891503571e-26, -8.079577023857668e-28,  3.687518274378638e-30,
  7.708006063538421e-02, -3.631662059477814e-04,  1.248271563372176e-06, -3.661637274781560e-09,  9.487758821524220e-12, -2.155231973714670e-14,  4.051577275418786e-17,
 -5.002724946771977e-20, -3.549674205632056e-23,  5.110180816427682e-25, -2.223576460749654e-27,  7.014313167593087e-30,  1.026064644127274e-01, -4.800799845904619e-04,
  1.622449811116103e-06, -4.604262219626999e-09,  1.122067593375777e-11, -2.259940752626157e-14,  3.130417276534027e-17,  6.465515225850956e-21, -2.494128754875447e-22,
  1.131332623456303e-24, -3.586590372813794e-27,  8.615482687307241e-30,  1.317673651447975e-01, -6.115291980248391e-04,  2.025691764750871e-06, -5.520128229127966e-09,
  1.240915235971339e-11, -2.070054821532206e-14,  1.109138933780346e-17,  9.335957575194397e-20, -5.151704470936047e-22,  1.710337385530888e-24, -4.138158321821816e-27,
  6.017027586977280e-30,  1.645551892486691e-01, -7.565788059391323e-04,  2.447972402598657e-06, -6.348205172229333e-09,  1.279775289725821e-11, -1.514779299874928e-14,
 -2.068894992138918e-17,  2.032267517855483e-19, -7.754772375540625e-22,  1.986177102857276e-24, -3.016662010218567e-27, -2.626806751771362e-30,  2.009595539531787e-01,
 -9.141323079913183e-04,  2.877873053620436e-06, -7.022610507015800e-09,  1.214133467706164e-11, -5.478045691249208e-15, -6.283397971468629e-17,  3.202795255249730e-19,
 -9.463317890822442e-22,  1.660587238762512e-24,  4.265281388005978e-28, -1.710700549526126e-29,  2.409664661526575e-01, -1.082914561922322e-03,  3.302559029836710e-06,
 -7.474092959004809e-09,  1.022296922638736e-11,  8.413432721815250e-15, -1.119629409260388e-16,  4.202777241568054e-19, -9.272834596026299e-22,  4.830073778773189e-25,
  6.209561875064256e-27, -3.379960667460152e-29,  2.845573413414471e-01, -1.261451956561442e-03,  3.707774959329418e-06, -7.631998029583548e-09,  6.875271126296296e-12,
  2.615588813577818e-14, -1.622514456225344e-16,  4.719896217816623e-19, -6.208877606049318e-22, -1.633635107010883e-24,  1.329620537816426e-26, -4.506578989637925e-29,
  3.317078050163134e-01, -1.448049788761482e-03,  4.077868538968431e-06, -7.426840112860375e-09,  2.005255052873083e-12,  4.679115636266648e-14, -2.054072360759872e-16,
  4.407138773078167e-19,  3.829226809012844e-23, -4.482509535019152e-24,  1.933048039919617e-26, -4.028963780843405e-29,  3.823862299895150e-01, -1.640766753794144e-03,
  4.395857257380407e-06, -6.793626356458208e-09, -4.377452300889086e-12,  6.868064757001586e-14, -2.310106941770272e-16,  2.942944832809411e-19,  1.046918577397081e-21,
 -7.451702102406145e-24,  2.075940117067737e-26, -9.363027357983759e-30,  4.365519521389471e-01, -1.837386572456014e-03,  4.643557666435909e-06, -5.676094234563565e-09,
 -1.212972747706598e-11,  8.945134571950544e-14, -2.273639665297583e-16,  1.182516926583002e-20,  2.293543404774281e-21, -9.485941062915636e-24,  1.359989845575393e-26,
  5.112653820384043e-29,  4.941530938520626e-01, -2.035386972735921e-03,  4.801803281509994e-06, -4.032032010942590e-09, -2.094289548132362e-11,  1.060090271445819e-13,
 -1.829991879078155e-16, -4.052556780255459e-19,  3.526786957307851e-21, -9.192792852000432e-24, -4.961063934353276e-27,  1.300399096919970e-28,  5.551239084105838e-01,
 -2.231906559751051e-03,  4.850785433587349e-06, -1.839838370228776e-09, -3.031226871860070e-11,  1.146562743854737e-13, -8.897165533508337e-17, -9.208534739678684e-19,
  4.347190301249942e-21, -5.170427299930361e-24, -3.418231252824596e-26,  1.953384648140789e-28,  6.193815394825667e-01, -2.423710603013480e-03,  4.770561552962702e-06,
  8.935727629156987e-10, -3.951289574688254e-11,  1.113622333041116e-13,  5.801965163943076e-17, -1.453231654502697e-18,  4.244969047629216e-21,  3.391148040634870e-24,
 -6.713864245653156e-26,  1.950656374410028e-28,  6.868220675799906e-01, -2.607157527709025e-03,  4.541787349577141e-06,  4.123531092532203e-09, -4.758872933462115e-11,
  9.223747557813118e-14,  2.518242281218444e-16, -1.869790785381849e-18,  2.708925319683667e-21,  1.586617200507374e-23, -8.914769172699078e-26,  7.328977744326249e-29,
  7.573156900345965e-01, -2.778169031859790e-03,  4.146742517461339e-06,  7.757262268672606e-09, -5.336584048919395e-11,  5.426497647550946e-14,  4.728174033527172e-16,
 -1.994277466718232e-18, -5.740427168577952e-22,  2.930674605969559e-23, -7.943428204686116e-26, -1.932871738137471e-28,  8.307008537361241e-01, -2.932208420138451e-03,
  3.570732165763535e-06,  1.164304978683398e-08, -5.550442149658993e-11, -3.683121832740714e-15,  6.846680090021192e-16, -1.634930669760237e-18, -5.433362961466156e-21,
  3.798118562872454e-23, -1.865495860308311e-26, -5.424758427372171e-28,  9.067771329564653e-01, -3.064274150236881e-03,  2.803954363434510e-06,  1.556015385541713e-08,
 -5.260853261518166e-11, -7.956982060041106e-14,  8.336476609609189e-16, -6.418895222220882e-19, -1.090133501354699e-20,  3.411316321163577e-23,  9.624795299126805e-26,
 -7.840971781325912e-28,  9.852966228780835e-01, -3.168918973699339e-03,  1.843920655603924e-06,  1.921170379492083e-08, -4.341529544310575e-11, -1.667996781149307e-13,
  8.530911675061413e-16,  1.003046080379006e-18, -1.502064696574464e-20,  1.074376486906682e-23,  2.328396739647708e-25, -6.250724866289103e-28,  1.065953611864384e+00,
 -3.240309677737829e-03,  6.984881215333086e-07,  2.222416814985202e-08, -2.708327314860984e-11, -2.530445741514101e-13,  6.762264958615429e-16,  3.075914745866890e-18,
 -1.503531352909869e-20, -3.282106822009450e-23,  3.115150640706393e-25,  1.654845619211003e-28,  1.148372317534382e+00, -3.272348486115309e-03, -6.105131667234157e-07,
  2.415881212421567e-08, -3.587237583579681e-12, -3.199151742618411e-13,  2.601214694186980e-16,  5.019377046993392e-18, -8.296475415358832e-21, -8.422950560372450e-23,
  2.240773067266114e-25,  1.435088411138999e-27,  1.232092548920215e+00, -3.258884587794803e-03, -2.043227762539261e-06,  2.454254586028184e-08,  2.580573969902609e-11,
 -3.444460016675161e-13, -3.795353491943046e-16,  5.951568576709282e-18,  5.920777026540033e-21, -1.145737343254363e-22, -9.352122609090134e-26,  2.349794130536283e-27,
  1.316553329585393e+00, -3.194052334753617e-03, -3.537747382631658e-06,  2.292701909192703e-08,  5.806733234525050e-11, -3.035930168318548e-13, -1.130612572068878e-15,
  4.890247424613162e-18,  2.407824196659375e-20, -8.650315774341865e-23, -5.423870524032329e-25,  1.597062117380819e-27,  1.401074843922636e+00, -3.072779392252326e-03,
 -5.007012895541023e-06,  1.898407853308805e-08,  8.813693950612314e-11, -1.826789341859011e-13, -1.764436775078521e-15,  1.283356380874231e-18,  3.708193926742155e-20,
  1.855594327146194e-23, -7.883163060229145e-25, -1.395759761382493e-27,  1.484839631233087e+00, -2.891509196862902e-03, -6.338208607211549e-06,  1.263975531931238e-08,
  1.091688016499662e-10,  1.269226133006266e-14, -1.968915699101656e-15, -4.233637739407263e-18,  3.287980570308494e-20,  1.610306049447391e-22, -4.204961341846085e-25,
 -4.680809969529257e-27,  1.566874843146885e+00, -2.649169446879358e-03, -7.397014758150304e-06,  4.233410965359845e-09,  1.137111148136897e-10,  2.449891248867186e-13,
 -1.472356238785848e-15, -9.311091226189826e-18,  5.231419339249220e-21,  2.300361551009933e-22,  5.601315300794363e-25, -3.987049645339384e-27,  1.646038676120883e+00,
 -2.348379279853947e-03, -8.039763566406467e-06, -5.340493532955184e-09,  9.613629648158622e-11,  4.420043490187913e-13, -2.563177663659126e-16, -1.046631125139560e-17,
 -3.450826932660046e-20,  1.154183830179478e-22,  1.312498846920830e-24,  2.288161948955755e-27,  1.721015779465397e+00, -1.996806016104437e-03, -8.136454863449416e-06,
 -1.459153564014555e-08,  5.611728383759352e-11,  5.151050373222201e-13,  1.248556281541562e-15, -5.460308269440214e-18, -5.574405734407027e-20, -1.392427123100761e-22,
  7.315656779702026e-25,  7.339161377352459e-27,  1.790328284428310e+00, -1.608445130871449e-03, -7.605615522981193e-06, -2.161150090845408e-08,  1.821018862399492e-12,
  4.051203825871158e-13,  2.217549149173140e-15,  3.539820507772262e-18, -3.245188443867941e-20, -2.808392562638045e-22, -8.404567940243571e-25,  2.427810955238408e-27,
  1.852370454791407e+00, -1.204412995671349e-03, -6.456863813570048e-06, -2.457253501944461e-08, -4.988262201661707e-11,  1.398433720488477e-13,  1.939574632332714e-15,
  9.703534908582044e-18,  1.912055529902250e-20, -1.125712040124406e-22, -1.285775455332056e-24, -6.057904797702278e-27,  1.905474626235757e+00, -8.126695454443391e-04,
 -4.828565707636771e-06, -2.251447958083799e-08, -7.909863320108021e-11, -1.462517271208467e-13,  5.590805933839355e-16,  7.426994319531313e-18,  4.335159023117480e-20,
  1.518559738212110e-22,  7.851050285659911e-26, -3.401635434528539e-27,  1.948012499371580e+00, -4.660593251439597e-04, -2.999223633562917e-06, -1.612695714701476e-08,
 -7.429369853054522e-11, -2.838449773027703e-13, -7.727087549301557e-16, -1.777444392555646e-19,  1.613178720412365e-20,  1.402533018571624e-22,  8.004199759639418e-25,
  3.353851039018439e-27,  1.978527988306398e+00, -1.983502717794542e-04, -1.350030814168410e-06, -7.975147643615579e-09, -4.280723165104696e-11, -2.116475410406362e-13,
 -9.612700200932896e-16, -3.932360023938011e-18, -1.371572928562223e-20, -3.372038044712248e-23,  1.391734192443153e-26,  9.255007812730221e-28,  1.995890091387267e+00,
 -3.861831951251462e-05, -2.712560747278540e-07, -1.686276705704546e-09, -9.774705361483447e-12, -5.403973660509740e-14, -2.882138249965281e-16, -1.492043562253507e-18,
 -7.521763587901730e-21, -3.697547613937135e-23, -1.772184318217899e-25, -8.268505132263045e-28,  4.475961456663706e-04, -2.131223739665320e-06,  7.609270810549975e-09,
 -2.414629955609277e-11,  7.180640985593750e-14, -2.049731658002191e-16,  5.684393325127208e-19, -1.544530344694268e-21,  4.124502374554179e-24, -1.089482429610498e-26,
  2.836096368784531e-29, -7.373151549283554e-32,  4.028386842079445e-03, -1.916408684178458e-05,  6.828079307587359e-08, -2.158677185624893e-10,  6.382120805739279e-13,
 -1.806509295531365e-15,  4.952462844375584e-18, -1.325440408049672e-20,  3.471373182484440e-23, -8.950958812191803e-26,  2.260794441997739e-28, -5.672073635575903e-31,
  1.119007244871304e-02, -5.313922616805037e-05,  1.885412920335652e-07, -5.915900877178060e-10,  1.728325413047762e-12, -4.807753986285000e-15,  1.286453171030089e-17,
 -3.332437765613400e-20,  8.357974261497156e-23, -2.037290456072232e-25,  4.775319811546378e-28, -1.089547305413077e-30,  2.193281001282970e-02, -1.038739711583654e-04,
  3.662171887197252e-07, -1.135909319451535e-09,  3.257779264233020e-12, -8.815507172529082e-15,  2.266920897038834e-17, -5.551838162722661e-20,  1.285626694695253e-22,
 -2.794256011208337e-25,  5.478634754624638e-28, -9.341502109942832e-31,  3.625670475711808e-02, -1.710905452984020e-04,  5.980270794476406e-07, -1.825817330426625e-09,
  5.102648987466466e-12, -1.326632021263706e-14,  3.210383092138808e-17, -7.161912339539406e-20,  1.423585871802233e-22, -2.333992774342335e-25,  2.063430154280018e-28,
  4.665937256089046e-31,  5.416164826474876e-02, -2.544114608425396e-04,  8.795570384951472e-07, -2.630836639764448e-09,  7.102755258783724e-12, -1.745869067541948e-14,
  3.850447452780775e-17, -7.272828065626408e-20,  9.899693240472021e-23, -2.113600379422221e-27, -6.584440819487838e-28,  3.121822082302968e-30,  7.564709347271217e-02,
 -3.533532437782435e-04,  1.205228686222856e-06, -3.513229150584351e-09,  9.066322157022850e-12, -2.059686230363937e-14,  3.910175389466778e-17, -5.088537628771870e-20,
 -1.862898529931653e-23,  4.279963458235072e-25, -1.933575567165532e-27,  6.181454164678661e-30,  1.007117580111994e-01, -4.673183727498703e-04,  1.568261066120232e-06,
 -4.428306443451517e-09,  1.077621094360457e-11, -2.184680018288193e-14,  3.137939982384001e-17, -8.910084898619526e-22, -2.111777577489645e-22,  9.952453094470821e-25,
 -3.222845243882897e-27,  7.919578529670297e-30,  1.293532446149430e-01, -5.955852861389766e-04,  1.960627891465432e-06, -5.324878559929582e-09,  1.199800567816670e-11,
 -2.040479314672042e-14,  1.348369269482664e-17,  7.782785007831142e-20, -4.565135239558543e-22,  1.550152649806910e-24, -3.870231016010645e-27,  6.134025788750199e-30,
  1.615675640035327e-01, -7.372962827683408e-04,  2.373012445043256e-06, -6.145889866036573e-09,  1.249027839276864e-11, -1.557878250340143e-14, -1.533543267655839e-17,
  1.795320345234950e-19, -7.061700256051136e-22,  1.863708234446285e-24, -3.094887255946842e-27, -9.927788866284386e-31,  1.973485416223149e-01, -8.914431152677282e-04,
  2.794763422928811e-06, -6.829304586798154e-09,  1.201740255173714e-11, -6.881813899352634e-15, -5.428110728177615e-17,  2.909552904918461e-19, -8.864153400153282e-22,
  1.663642248964220e-24, -2.487883036395971e-28, -1.367527898302611e-29,  2.366870847596905e-01, -1.056850053638543e-03,  3.213856410096046e-06, -7.309321360881481e-09,
  1.036530271000013e-11,  5.864200108056855e-15, -1.006076482732590e-16,  3.909279767266597e-19, -9.057702558888395e-22,  7.030098699546154e-25,  4.823634173199318e-27,
 -2.925945086463075e-29,  2.795702805735162e-01, -1.232154184313983e-03,  3.616867598717313e-06, -7.518015873058102e-09,  7.360507193836071e-12,  2.241814605734568e-14,
 -1.493220254980830e-16,  4.512790700537236e-19, -6.705937415080378e-22, -1.140398975983615e-24,  1.139187526114536e-26, -4.146105031365817e-29,  3.259802881796631e-01,
 -1.415782713942596e-03,  3.988968988088000e-06, -7.387533101802818e-09,  2.892780084568117e-12,  4.200945716744189e-14, -1.930733081369057e-16,  4.395030511391902e-19,
 -1.095898536104390e-22, -3.745001410447703e-24,  1.754078607698470e-26, -4.086275914180969e-29,  3.758929788290997e-01, -1.605927078015599e-03,  4.313957866932576e-06,
 -6.852975060932971e-09, -3.058595922446666e-12,  6.323881734721388e-14, -2.223406205733273e-16,  3.236629984408453e-19,  7.934812947168811e-22, -6.632113298659814e-24,
  2.016103391694467e-26, -1.746911186782809e-29,  4.292762669076443e-01, -1.800513728892691e-03,  4.574338159944169e-06, -5.856153883712817e-09, -1.039519955841276e-11,
  8.400656554910595e-14, -2.260559197746065e-16,  7.986373505079873e-20,  1.962336269554105e-21, -8.902116594229157e-24,  1.546804054952035e-26,  3.419929683558386e-29,
  4.860880605475852e-01, -1.997171620922820e-03,  4.751477562384065e-06, -4.350399157764495e-09, -1.886748925654620e-11,  1.014933267000708e-13, -1.928163079094870e-16,
 -2.977210469018248e-19,  3.193593350440259e-21, -9.283381468103813e-24,  2.704882690449678e-28,  1.079238140547167e-28,  5.462737434996595e-01, -2.193196659979828e-03,
  4.825872669395017e-06, -2.306614170869492e-09, -2.804250444642877e-11,  1.122270863178293e-13, -1.128377790779944e-16, -7.849689023960756e-19,  4.138472767667993e-21,
 -6.370504728303305e-24, -2.594264038266786e-26,  1.787338400605966e-28,  6.097630790176448e-01, -2.385513796910224e-03,  4.777564895141106e-06,  2.792464885813389e-10,
 -3.727494255127712e-11,  1.122818636064483e-13,  1.924566699764136e-17, -1.315940719850748e-18,  4.320800559276429e-21,  8.795085581184478e-25, -5.840226438044365e-26,
  2.007267783809574e-28,  6.764664013684633e-01, -2.570638101307563e-03,  4.586763096912332e-06,  3.377180180406564e-09, -4.568772991887145e-11,  9.766330616172712e-14,
  2.007646863669783e-16, -1.774647337516664e-18,  3.216824431047332e-21,  1.237844618254733e-23, -8.492038700229915e-26,  1.169852552663941e-28,  7.462699309605643e-01,
 -2.744637172245709e-03,  4.234744304125395e-06,  6.912688760375493e-09, -5.217159447615461e-11,  6.494139373954901e-14,  4.168746101961257e-16, -1.996394522642869e-18,
  4.219843615617058e-22,  2.598405576879618e-23, -8.610070909550000e-26, -1.110105436554690e-28,  8.190300153281385e-01, -2.903098793501712e-03,  3.705120756575598e-06,
  1.075526664858666e-08, -5.541756783365262e-11,  1.218118376711016e-14,  6.366600681265135e-16, -1.787110298841405e-18, -4.084991338864255e-21,  3.678330085573028e-23,
 -4.059000838689124e-26, -4.534169744484263e-28,  8.945660618447477e-01, -3.041110051381848e-03,  2.985576777442731e-06,  1.470676643362236e-08, -5.400150821148797e-11,
 -5.981621120493326e-14,  8.109804846285088e-16, -9.704072322959021e-19, -9.612232523824401e-21,  3.727841137816196e-23,  6.220068110736529e-26, -7.586143485225751e-28,
  9.726518928066814e-01, -3.153257501897378e-03,  2.070186772200094e-06,  1.849149212722759e-08, -4.654455117636605e-11, -1.460423610011255e-13,  8.745178454015073e-16,
  5.303151512399441e-19, -1.447321068995518e-20,  1.946884872438411e-23,  2.025410178204244e-25, -7.449808018990636e-28,  1.053005227100468e+00, -3.233662758102066e-03,
  9.624140696982829e-07,  2.175125873839620e-08, -3.197517939682097e-11, -2.358370041107206e-13,  7.554558638989924e-16,  2.578293827136125e-18, -1.599159900383216e-20,
 -2.029943176864462e-23,  3.125089179603171e-25, -1.168321019832628e-28,  1.135274989433428e+00, -3.276074428028152e-03, -3.211617121150740e-07,  2.405061630287567e-08,
 -9.911894668215811e-12, -3.120184853591529e-13,  3.965043799165039e-16,  4.707222055820760e-18, -1.115294468784270e-20, -7.408780044663199e-23,  2.808295431964203e-25,
  1.136320118520481e-27,  1.219026193373749e+00, -3.274045875023282e-03, -1.746468643090700e-06,  2.489988841619698e-08,  1.883932373628503e-11, -3.515375454465013e-13,
 -2.108629659720064e-16,  6.074520008256394e-18,  1.753814040715652e-21, -1.162365154201417e-22,  1.040998750738579e-26,  2.353647845921406e-27,  1.303722280419386e+00,
 -3.221238493386433e-03, -3.257253705829376e-06,  2.380609529126171e-08,  5.173565330254431e-11, -3.290005520509943e-13, -9.833957522896281e-16,  5.606886009696444e-18,
  2.059212571945178e-20, -1.066208612195022e-22, -4.593970378734397e-25,  2.159513864788597e-27,  1.388705090397018e+00, -3.111900578949334e-03, -4.770870788825987e-06,
  2.036275474586377e-08,  8.406350145398739e-11, -2.244597237999241e-13, -1.711833677481558e-15,  2.474475034144801e-18,  3.716975013004780e-20, -1.396333098426049e-23,
 -8.314645801194372e-25, -5.476946383111249e-28,  1.473173185654334e+00, -2.941578461130811e-03, -6.176051383057722e-06,  1.438588134363103e-08,  1.089411419518677e-10,
 -3.586009384590890e-14, -2.071881377260803e-15, -3.092378210770878e-18,  3.832472196115980e-20,  1.401186204760198e-22, -6.238943063703576e-25, -4.514493531430106e-27,
  1.556160179002250e+00, -2.708111072323678e-03, -7.335142327118227e-06,  6.089978908015334e-09,  1.182365450294488e-10,  2.065507629366319e-13, -1.729449427515005e-15,
 -9.007225875854985e-18,  1.387040247202483e-20,  2.485679242691609e-22,  3.576086099730691e-25, -5.200140466780481e-27,  1.636516154705661e+00, -2.412926913830667e-03,
 -8.094330041694997e-06, -3.732028163266459e-09,  1.048905023394141e-10,  4.322154661452953e-13, -5.641362713745420e-16, -1.149378802236077e-17, -2.938741050917982e-20,
  1.695455683107337e-22,  1.383576211984124e-24,  8.765110409327323e-28,  1.712897285760755e+00, -2.062581991557134e-03, -8.305820939545107e-06, -1.360966984121081e-08,
  6.670559349907941e-11,  5.430297400366960e-13,  1.069984723092533e-15, -7.318028750190267e-18, -6.015016631122700e-20, -1.032982473277726e-22,  1.070566888851885e-24,
  8.010697482327552e-27,  1.783771173117379e+00, -1.670326277053407e-03, -7.864501882961759e-06, -2.151462219531974e-08,  1.046301969350899e-11,  4.594040278186277e-13,
  2.300560891757816e-15,  2.333350772750298e-18, -4.313637328777370e-20, -3.117542021737556e-22, -6.905326407401156e-25,  4.453568288550102e-27,  1.847447606621626e+00,
 -1.257260726476527e-03, -6.756422220837281e-06, -2.534565925684548e-08, -4.659790894623996e-11,  1.897185784120154e-13,  2.219156566118956e-15,  1.024009848071361e-17,
  1.407716677008963e-20, -1.694194206283096e-22, -1.558142804607726e-24, -6.262244831449398e-27,  1.902144949241654e+00, -8.524004981569293e-04, -5.106426895855927e-06,
 -2.380265535719106e-08, -8.187181233388826e-11, -1.301764981570565e-13,  7.872822894619572e-16,  8.902001526694379e-18,  4.883486567208672e-20,  1.515587368355185e-22,
 -1.050464670632639e-25, -5.005155449821196e-27,  1.946099019738267e+00, -4.908478540361982e-04, -3.200069917955069e-06, -1.736207971277148e-08, -8.015612920575224e-11,
 -3.023864834254440e-13, -7.696537463618467e-16,  4.257335211153791e-19,  2.179382999362122e-20,  1.753368041524430e-22,  9.564992404278933e-25,  3.729599027981874e-27,
  1.977712363742424e+00, -2.095452989843790e-04, -1.449985932379733e-06, -8.695218795373607e-09, -4.728006692786951e-11, -2.360900062961741e-13, -1.077701979237433e-15,
 -4.390491910669628e-18, -1.490870681296306e-20, -3.222401873186502e-23,  6.426359763058312e-26,  1.387933744562441e-27,  1.995731145990045e+00, -4.087205276678040e-05,
 -2.924666905767450e-07, -1.851708890009598e-09, -1.092820133640396e-11, -6.148667442736409e-14, -3.335710884878444e-16, -1.755480455192371e-18, -8.989750902139889e-21,
 -4.484792680292136e-23, -2.178725712326344e-25, -1.028641887625639e-27,  4.391911910907856e-04, -2.071489371031453e-06,  7.326275710480974e-09, -2.302946590020704e-11,
  6.783994455375558e-14, -1.918350245469783e-16,  5.269828221328808e-19, -1.418608931716490e-21,  3.751950192784570e-24, -9.822710708494761e-27,  2.530596359001466e-29,
 -6.531976803266298e-32,  3.952806822960205e-03, -1.862803125853696e-05,  6.575047709650770e-08, -2.059390327101606e-10,  6.032410610763237e-13, -1.691981058417933e-15,
  4.596419022371449e-18, -1.219342452934037e-20,  3.164832167241287e-23, -8.094672479261057e-26,  2.025150655368371e-28, -5.052222741052330e-31,  1.098048789804433e-02,
 -5.165882925183096e-05,  1.816050105888238e-07, -5.646896582937215e-10,  1.635183774897301e-12, -4.509906639107684e-15,  1.196781602868639e-17, -3.076357913569721e-20,
  7.657805615540658e-23, -1.855549164510127e-25,  4.319366324546259e-28, -9.848875958919672e-31,  2.152308850766721e-02, -1.009978843900892e-04,  3.528932997914109e-07,
 -1.085166292011700e-09,  3.086786178926711e-12, -8.289644596428011e-15,  2.117080780210987e-17, -5.156117543485684e-20,  1.188880265407381e-22, -2.583196211623405e-25,
  5.077709157777844e-28, -8.881266177272287e-31,  3.558177418024856e-02, -1.663925998703276e-04,  5.765985037796813e-07, -1.746256367117298e-09,  4.844867698125015e-12,
 -1.251938523323864e-14,  3.016102053069714e-17, -6.719645660389114e-20,  1.341092531620043e-22, -2.247866193000144e-25,  2.230711627234207e-28,  2.991568452934120e-31,
  5.315787808328746e-02, -2.474993789582680e-04,  8.486575013535619e-07, -2.519936422232711e-09,  6.762659420536881e-12, -1.655866226170295e-14,  3.651238712712899e-17,
 -6.956641981414620e-20,  9.847849620282348e-23, -2.585368778046901e-26, -5.321338448099265e-28,  2.631006816981955e-30,  7.425270059176928e-02, -3.438776142264320e-04,
  1.163926873253446e-06, -3.371412990817009e-09,  8.663653634225205e-12, -1.967557134290375e-14,  3.767083047928316e-17, -5.124938681834564e-20, -4.549819679763711e-24,
  3.558660540425603e-25, -1.678414505211183e-27,  5.429558161955179e-30,  9.886724424058693e-02, -4.549819447422039e-04,  1.516141618652523e-06, -4.259341659451142e-09,
  1.034680016590643e-11, -2.109472535177302e-14,  3.126505672091700e-17, -7.099646349198335e-21, -1.775872407086125e-22,  8.730983552832623e-25, -2.889480555773732e-27,
  7.236215992911900e-30,  1.270018733923712e-01, -5.801526246180770e-04,  1.897867749037406e-06, -5.136156941374946e-09,  1.159331409868341e-11, -2.005663460818058e-14,
  1.546653390589787e-17,  6.408295519037280e-20, -4.034295280624839e-22,  1.400741815459347e-24, -3.600538246092226e-27,  6.103305409147489e-30,  1.586558847488437e-01,
 -7.186038123672113e-04,  2.300450491164315e-06, -5.948556350367119e-09,  1.217541648056423e-11, -1.588900249633576e-14, -1.061498420938601e-17,  1.579841360630384e-19,
 -6.413116938209276e-22,  1.739438641324321e-24, -3.109308356479591e-27,  2.827646622855002e-31,  1.938269709491909e-01, -8.694095566776767e-04,  2.713960674682683e-06,
 -6.638195305822609e-09,  1.186738236376348e-11, -8.089949531783146e-15, -4.652248983028536e-17,  2.635452143606109e-19, -8.268401228474276e-22,  1.642554198116412e-24,
 -7.842647213236544e-28, -1.074327918221786e-29,  2.325105547302511e-01, -1.031487222341285e-03,  3.127143078258640e-06, -7.142665774856921e-09,  1.045931067807833e-11,
  3.577717739759868e-15, -9.006339403119565e-17,  3.623830578827410e-19, -8.772877158476586e-22,  8.714571602834422e-25,  3.628947235740040e-27, -2.511093433900036e-29,
  2.746989652184264e-01, -1.203578073396518e-03,  3.527372193804038e-06, -7.396851318413831e-09,  7.774043647934303e-12,  1.898358746882964e-14, -1.369922027094380e-16,
  4.292476428590115e-19, -7.038756561554808e-22, -7.201157251440375e-25,  9.649476479700121e-27, -3.773009402192175e-29,  3.203804205681656e-01, -1.384224714551200e-03,
  3.900623219866366e-06, -7.334774699505708e-09,  3.687625867591059e-12,  3.752285470106571e-14, -1.808356418177836e-16,  4.339709561842870e-19, -2.322132920467980e-22,
 -3.079254681420965e-24,  1.575008617950444e-26, -4.038145295462290e-29,  3.695377719666795e-01, -1.571745095566324e-03,  4.231469347982824e-06, -6.892081186964284e-09,
 -1.846433344204139e-12,  5.801404736386315e-14, -2.129573696195996e-16,  3.453883248929660e-19,  5.690382177803385e-22, -5.842960831455727e-24,  1.925268195595744e-26,
 -2.350234162853502e-29,  4.221469525091227e-01, -1.764202820714722e-03,  4.503120866031606e-06, -6.009329918864286e-09, -8.769105105903714e-12,  7.861486171462731e-14,
 -2.229879197164835e-16,  1.376529643285141e-19,  1.653319024234162e-21, -8.257733545262989e-24,  1.664576124856509e-26,  1.973298051567981e-29,  4.781750600307589e-01,
 -1.959373598917323e-03,  4.697527657408996e-06, -4.636294116556905e-09, -1.688451549531733e-11,  9.677694056732640e-14, -1.997719422268259e-16, -2.008622867265898e-19,
  2.860673735520348e-21, -9.183835316762964e-24,  4.554849943271083e-27,  8.706467025028537e-29,  5.375779849751068e-01, -2.154707854072887e-03,  4.795574792391365e-06,
 -2.737492255118039e-09, -2.582674768084507e-11,  1.092699760924072e-13, -1.329986900810598e-16, -6.563924005443571e-19,  3.892302150109179e-21, -7.256335763691851e-24,
 -1.848591037884984e-26,  1.599408086446754e-28,  6.002974720026252e-01, -2.347289841931589e-03,  4.777411612289763e-06, -2.991746441541463e-10, -3.502759005867962e-11,
  1.123172411118393e-13, -1.566330894911934e-17, -1.177602085256168e-18,  4.312542680199219e-21, -1.279935329768722e-24, -4.958175173942417e-26,  1.991264694795105e-28,
  6.662574764921476e-01, -2.533794168880048e-03,  4.622968497169803e-06,  2.662047747517752e-09, -4.369024339228752e-11,  1.018973977453703e-13,  1.525780778553010e-16,
 -1.665223851750909e-18,  3.602642185227009e-21,  9.094950771624588e-24, -7.901727494969778e-26,  1.495521238327625e-28,  7.353596436453775e-01, -2.710441497277434e-03,
  4.312732666537967e-06,  6.088858508857986e-09, -5.077723305108235e-11,  7.427796207771194e-14,  3.613004505978397e-16, -1.968597108635770e-18,  1.294445260585215e-21,
  2.246467024202234e-23, -8.933311354561416e-26, -3.751735249361929e-29,  8.074776982372573e-01, -2.872956624404734e-03,  3.828874551587927e-06,  9.871347493888791e-09,
 -5.502527010007861e-11,  2.684699643350048e-14,  5.849875227962336e-16, -1.896993584257042e-18, -2.794576552565770e-21,  3.478805542496967e-23, -5.849094979279191e-26,
 -3.599486120664470e-28,  8.824504877340534e-01, -3.016534284882089e-03,  3.156837750027457e-06,  1.383421937942391e-08, -5.500557231685179e-11, -4.071223864222031e-14,
  7.797076018869951e-16, -1.256110626237410e-18, -8.233348516727498e-21,  3.911250392652246e-23,  2.988553377421467e-26, -7.063196043011340e-28,  9.600733729844312e-01,
 -3.135821290769792e-03,  2.287523718366133e-06,  1.772455701777680e-08, -4.925457888755381e-11, -1.249273800533046e-13,  8.829988052452052e-16,  7.988437282190173e-20,
 -1.363464120164281e-20,  2.688929450475036e-23,  1.679257731933509e-25, -8.212708720518389e-28,  1.040087615045959e+00, -3.224928434328249e-03,  1.220207160504797e-06,
  2.120293055904038e-08, -3.650506390460945e-11, -2.168981715942344e-13,  8.203911133928530e-16,  2.057268023705704e-18, -1.649931980008703e-20, -7.979279145756088e-24,
  3.016422528054379e-25, -3.715480352833290e-28,  1.122167376553807e+00, -3.277492458867369e-03, -3.370999510423970e-08,  2.384266412864424e-08, -1.604664593898254e-11,
 -3.009634673086710e-13,  5.229251100031896e-16,  4.309913268637321e-18, -1.360674141273704e-20, -6.195205611548180e-23,  3.234923584205394e-25,  7.981810686070095e-28,
  1.205903965294805e+00, -3.286817841064076e-03, -1.446094154305674e-06,  2.514485451747612e-08,  1.177175912124827e-11, -3.545547347426355e-13, -4.061802957196734e-17,
  6.063971344831259e-18, -2.398471717383850e-21, -1.137752635035914e-22,  1.117850169442475e-25,  2.234703204965392e-27,  1.290787038846798e+00, -3.246140266503274e-03,
 -2.966835084875559e-06,  2.457999797828160e-08,  4.493271302742668e-11, -3.506473439506332e-13, -8.177788698187942e-16,  6.201068375085746e-18,  1.644721344075632e-20,
 -1.229548114725790e-22, -3.540267910737476e-25,  2.608495655810770e-27,  1.376182733530413e+00, -3.149067623314433e-03, -4.518602939769618e-06,  2.166965094911297e-08,
  7.916977082336425e-11, -2.645785974705378e-13, -1.626017856152601e-15,  3.649414150806606e-18,  3.606505246079769e-20, -4.743456655905989e-23, -8.353319948188006e-25,
  3.801684734582365e-28,  1.461309190053922e+00, -2.990266790096319e-03, -5.992994950905918e-06,  1.612047337826660e-08,  1.077204103638210e-10, -8.648122458077117e-14,
 -2.140576727424983e-15, -1.790477187115617e-18,  4.287294609159536e-20,  1.113075781537472e-22, -8.131878176166305e-25, -4.038123215996870e-27,  1.545210881071908e+00,
 -2.766467432729209e-03, -7.250583085480924e-06,  8.012471808834197e-09,  1.219323586569279e-10,  1.620760597768861e-13, -1.974075568445302e-15, -8.417904331243796e-18,
  2.301821091242194e-20,  2.579726008015762e-22,  1.050059319377271e-25, -6.244411906844125e-27,  1.626734695272952e+00, -2.477831509662026e-03, -8.128762315547070e-06,
 -1.985472541652956e-09,  1.133728271816196e-10,  4.147140409495337e-13, -8.981338707307559e-16, -1.232579978562133e-17, -2.228282192736457e-20,  2.251582237634064e-22,
  1.383992083707455e-24, -9.161244104152127e-28,  1.704513057038743e+00, -2.129662845196242e-03, -8.462370521286316e-06, -1.245417394847152e-08,  7.780524980820369e-11,
  5.660298893074746e-13,  8.376365459257645e-16, -9.293372648321127e-18, -6.301212461068146e-20, -5.332058659225567e-23,  1.430020221601405e-24,  8.242059609709256e-27,
  1.776962405830869e+00, -1.734271430158226e-03, -8.121359921541295e-06, -2.127069003174869e-08,  2.020767610354131e-11,  5.152349634013912e-13,  2.344846815090398e-15,
  7.685091278901179e-19, -5.480331535381535e-20, -3.347739947673492e-22, -4.429374454099429e-25,  6.857549457583078e-27,  1.842308517200959e+00, -1.312541062858410e-03,
 -7.064908674795371e-06, -2.605787872223606e-08, -4.224747770844072e-11,  2.464638331697773e-13,  2.511180120259694e-15,  1.058041574837995e-17,  6.790045093067980e-21,
 -2.372216971700221e-22, -1.830175709684320e-24, -6.012581683513801e-27,  1.898651803726166e+00, -8.944169006784275e-04, -5.400000805787709e-06, -2.513231798988654e-08,
 -8.426527093040974e-11, -1.081090626358884e-13,  1.059228150077440e-15,  1.055074039913444e-17,  5.415722697039056e-20,  1.423924403218387e-22, -3.678646823308834e-25,
 -7.009500362567606e-27,  1.944083076291258e+00, -5.173040617950090e-04, -3.416312674352934e-06, -1.869395769774524e-08, -8.638717718944128e-11, -3.206302159286070e-13,
 -7.469661166649023e-16,  1.231840817933533e-18,  2.883502123984584e-20,  2.169690170406072e-22,  1.127096521534586e-24,  4.000609610585536e-27,  1.976850303294511e+00,
 -2.215757853223985e-04, -1.559027932536467e-06, -9.490922371520288e-09, -5.227075625232802e-11, -2.634850199840643e-13, -1.207484971519458e-15, -4.885505887460643e-18,
 -1.600623015284836e-20, -2.825869997112883e-23,  1.386471091942942e-25,  2.026589727929938e-27,  1.995562833258740e+00, -4.330373716005231e-05, -3.157783419088997e-07,
 -2.036850272724476e-09, -1.224214787316731e-11, -7.011628314711729e-14, -3.870071913217736e-16, -2.070759535035090e-18, -1.077268662220834e-20, -5.453849618096273e-23,
 -2.685013555156572e-25, -1.282238298714648e-27,  4.310207294502638e-04, -2.013966414436607e-06,  7.056310332892624e-09, -2.197404647086155e-11,  6.412657128997784e-14,
 -1.796508422596385e-16,  4.888908461669993e-19, -1.304014531375912e-21,  3.415880729469436e-24, -8.865718801997790e-27,  2.259711772704567e-29, -5.797411252455960e-32,
  3.879331282495312e-03, -1.811175096720478e-05,  6.333602224133137e-08, -1.965520130283124e-10,  5.704775060043748e-13, -1.585652189965867e-15,  4.268754399501248e-18,
 -1.122578261434590e-20,  2.887484458540207e-23, -7.327417752074164e-26,  1.815086949422025e-28, -4.507837734528120e-31,  1.077671596379108e-02, -5.023265625583250e-05,
  1.749827855569627e-07, -5.392329848908241e-10,  1.547789551490589e-12, -4.232744765905646e-15,  1.113976185010486e-17, -2.841670947427175e-20,  7.019888884993249e-23,
 -1.691158541254011e-25,  3.906973433423123e-28, -8.913922867948576e-31,  2.112466195920176e-02, -9.822599879124047e-05,  3.401622526976781e-07, -1.037076932787621e-09,
  2.925959525945204e-12, -7.798448319492140e-15,  1.977898620903458e-17, -4.790170631814800e-20,  1.099448212461350e-22, -2.387767587088257e-25,  4.697069370462413e-28,
 -8.421906385659627e-31,  3.492529847700222e-02, -1.618623331187801e-04,  5.561003975520711e-07, -1.670702886694649e-09,  4.601568711553920e-12, -1.181762122600460e-14,
  2.833839656022719e-17, -6.303269232391931e-20,  1.261803274921389e-22, -2.156430563485239e-25,  2.331026817784012e-28,  1.611730881440504e-31,  5.218127013637130e-02,
 -2.408292613154399e-04,  8.190567033082054e-07, -2.414336301191292e-09,  6.440093207772665e-12, -1.570538419087650e-14,  3.460847780259149e-17, -6.643388915524191e-20,
  9.719133611572744e-23, -4.495360388450712e-26, -4.259667268279934e-28,  2.204569991617824e-30,  7.289556002526053e-02, -3.347257001403193e-04,  1.124288800023540e-06,
 -3.235893989364340e-09,  8.279066936627920e-12, -1.878869627190573e-14,  3.623564554197668e-17, -5.120250462184627e-20,  7.108602015803483e-24,  2.933028068994590e-25,
 -1.454685408125520e-27,  4.751511729476138e-30,  9.707125494878108e-02, -4.430544776624785e-04,  1.466009020888212e-06, -4.097127321996477e-09,  9.932389972123322e-12,
 -2.034736336668063e-14,  3.099127725959685e-17, -1.230122921946275e-20, -1.481611875064455e-22,  7.636902518485972e-25, -2.585751713625111e-27,  6.573529163107250e-30,
  1.247112428417637e-01, -5.652130951296567e-04,  1.837333653451207e-06, -4.953852224561823e-09,  1.119603136965422e-11, -1.966531910919919e-14,  1.708750589656866e-17,
  5.195276472075064e-20, -3.555308003688597e-22,  1.262055713365145e-24, -3.334830069964799e-27,  5.957738911037492e-30,  1.558178292603649e-01, -7.004824516633456e-04,
  2.230226127373351e-06, -5.756304305996529e-09,  1.185543540002461e-11, -1.609294142728402e-14, -6.469493099350391e-18,  1.384401177166005e-19, -5.809247822461619e-22,
  1.615621220365670e-24, -3.074501170521789e-27,  1.253039057373910e-30,  1.903922561308129e-01, -8.480132894055134e-04,  2.635436070569416e-06, -6.449669789397261e-09,
  1.169500047512329e-11, -9.120873550146511e-15, -3.950480699353292e-17,  2.380255086518792e-19, -7.683797821445853e-22,  1.602490102185946e-24, -1.200904038528868e-27,
 -8.266237594418458e-30,  2.284341013101437e-01, -1.006810076047894e-03,  3.042437172941131e-06, -6.974858418640582e-09,  1.051005543481900e-11,  1.534814655602090e-15,
 -8.030478942476473e-17,  3.348377328791856e-19, -8.435583434795183e-22,  9.956481937794349e-25,  2.607846254282700e-27, -2.137068507045770e-29,  2.699405317410794e-01,
 -1.175712002454942e-03,  3.439368247740678e-06, -7.269603843519228e-09,  8.121797556081883e-12,  1.583743522764879e-14, -1.252919896459290e-16,  4.063801478863083e-19,
 -7.232422635793097e-22, -3.662387563890760e-25,  8.071504217181265e-27, -3.400647402821725e-29,  3.149053757279408e-01, -1.353370739420464e-03,  3.812983948039246e-06,
 -7.270000723522138e-09,  4.395661895003167e-12,  3.332767568855452e-14, -1.688043046806747e-16,  4.248846139145796e-19, -3.321517297082923e-22, -2.484461271071145e-24,
  1.399889066600450e-26, -3.910729333642253e-29,  3.633179707007888e-01, -1.538224576515662e-03,  4.148624514945569e-06, -6.912616246624450e-09, -7.364689963106638e-13,
  5.302098951433437e-14, -2.030621419710073e-16,  3.603785259631630e-19,  3.722916322996308e-22, -5.094907571289625e-24,  1.811900714748037e-26, -2.775966356932685e-29,
  4.151617312388831e-01, -1.728468569206796e-03,  4.430218020654794e-06, -6.137346584389555e-09, -7.249983026967226e-12,  7.331511138599446e-14, -2.184367157446818e-16,
  1.859326956646242e-19,  1.368200550783478e-21, -7.578268332472031e-24,  1.723932201841681e-26,  7.623558013149828e-30,  4.704123674273997e-01, -1.922020366964130e-03,
  4.640334238681517e-06, -4.891224286607397e-09, -1.499732533669678e-11,  9.192496436692598e-14, -2.041639149563261e-16, -1.145683083696564e-19,  2.534205502349629e-21,
 -8.930807989338912e-24,  7.956584175057553e-27,  6.785576020486270e-29,  5.290356650061321e-01, -2.116481515303778e-03,  4.760317057478986e-06, -3.133416450905319e-09,
 -2.367468484501615e-11,  1.058712881058840e-13, -1.496741366629970e-16, -5.361476740472992e-19,  3.619407388933508e-21, -7.860837684536294e-24, -1.188436904092822e-26,
  1.400210035888610e-28,  5.909847152576780e-01, -2.309094266385700e-03,  4.770532901173735e-06, -8.416766823613287e-10, -3.278759486847060e-11,  1.115611857125570e-13,
 -4.671370543174720e-17, -1.040703696744653e-18,  4.232861867897407e-21, -3.089786823188631e-24, -4.096513729533450e-26,  1.916909596774922e-28,  6.561964530568933e-01,
 -2.496694370258066e-03,  4.650786660803097e-06,  1.979490783799265e-09, -4.161938489478347e-11,  1.050130646059801e-13,  1.076107432363103e-16, -1.545297304561514e-18,
  3.874821122870086e-21,  6.073114075100475e-24, -7.191318705696176e-26,  1.717253446361796e-28,  7.245873247863174e-01, -2.675661066273324e-03,  4.380974852875402e-06,
  5.288759742255025e-09, -4.920939920800257e-11,  8.229312752762133e-14,  3.068762920250086e-16, -1.914926916063929e-18,  2.038633525588842e-21,  1.887770717209887e-23,
 -8.955491823961571e-26,  2.564483474888755e-29,  7.960478628851039e-01, -2.841866724512689e-03,  3.942068435839688e-06,  8.995983288919063e-09, -5.435228292306780e-11,
  4.024034225687911e-14,  5.308046144581164e-16, -1.966862989457622e-18, -1.587885563529121e-21,  3.215924395396531e-23, -7.227087304726432e-26, -2.668193523350254e-28,
  8.704358902037174e-01, -2.990630557205734e-03,  3.317544237118679e-06,  1.294862052581363e-08, -5.563568444274158e-11, -2.244977335215757e-14,  7.410609396855978e-16,
 -1.496877865426524e-18, -6.811088994798928e-21,  3.970657272022085e-23,  3.507033591954276e-28, -6.332672740533965e-28,  9.475680161124902e-01, -3.116683901940105e-03,
  2.495411240690917e-06,  1.691764669058937e-08, -5.154127644307912e-11, -1.037569314124109e-13,  8.792816023633500e-16, -3.397110407239649e-19, -1.255455217239432e-20,
  3.287064492376718e-23,  1.308952428882530e-25, -8.551727503130021e-28,  1.027209021602196e+00, -3.214159288396761e-03,  1.470998204541199e-06,  2.058523412834669e-08,
 -4.064177675057338e-11, -1.965773873913563e-13,  8.705761361228640e-16,  1.526986375371421e-18, -1.657394416605462e-20,  3.692733211374456e-24,  2.803834016737036e-25,
 -5.876707348587164e-28,  1.109058672641671e+00, -3.276622508471953e-03,  2.506651792993256e-07,  2.353848565286647e-08, -2.193090107282949e-11, -2.870163056877783e-13,
  6.371897491852422e-16,  3.841372993697721e-18, -1.559658434129112e-20, -4.841414731096573e-23,  3.508090745695541e-25,  4.423657340376001e-28,  1.192735471242766e+00,
 -3.297176978344709e-03, -1.143459831660499e-06,  2.527647846479092e-08,  4.684608431134933e-12, -3.535044950215303e-13,  1.274901507982722e-16,  5.922737542377147e-18,
 -6.390735062685426e-21, -1.073976860392965e-22,  2.054103752983644e-25,  2.003858456757817e-27,  1.277756893042373e+00, -3.268683425196315e-03, -2.667796286468707e-06,
  2.524181147890967e-08,  3.773785291483164e-11, -3.681351867354856e-13, -6.374641894626178e-16,  6.654054902300933e-18,  1.179454071946952e-20, -1.347194116865838e-22,
 -2.319813306242133e-25,  2.913243600783700e-27,  1.363515842137436e+00, -3.184155185162522e-03, -4.251148220026991e-06,  2.289195144561562e-08,  7.349689791163099e-11,
 -3.022482189367538e-13, -1.507979537298580e-15,  4.769774194763219e-18,  3.376254369756604e-20, -8.023403668096214e-23, -7.977471770296048e-25,  1.325685812642402e-27,
  1.449253501298694e+00, -3.037407816689357e-03, -5.789274270136848e-06,  1.782735742504851e-08,  1.054738027322084e-10, -1.382981680976950e-13, -2.170947324164184e-15,
 -3.610430159976040e-19,  4.625356593935628e-20,  7.543531341473479e-23, -9.747230294014143e-25, -3.255699159295230e-27,  1.534029658084762e+00, -2.824054103924834e-03,
 -7.142629500761080e-06,  9.986668991465097e-09,  1.246814765495659e-10,  1.119616607195084e-13, -2.198065992468333e-15, -7.532471440352047e-18,  3.231231157109176e-20,
  2.564295553556731e-22, -1.877075547963570e-25, -7.004606389912197e-27,  1.616693202497293e+00, -2.542925451291166e-03, -8.141434600979423e-06, -1.064429183598184e-10,
  1.214232177017813e-10,  3.889446536914028e-13, -1.251944868409133e-15, -1.289858889326871e-17, -1.319579274140611e-20,  2.791118027672174e-22,  1.298355346655173e-24,
 -3.019208085609591e-27,  1.695858092232321e+00, -2.197937579682181e-03, -8.603974438431575e-06, -1.111772548212013e-08,  8.930461939302960e-11,  5.827813799202415e-13,
  5.489869137144462e-16, -1.132872687639236e-17, -6.381511469336589e-20,  1.107318483061717e-23,  1.786986600400635e-24,  7.871466256272772e-27,  1.769893770596378e+00,
 -1.800257003120151e-03, -8.374318294213158e-06, -2.086186833247109e-08,  3.107580977048330e-11,  5.715600945268746e-13,  2.339980653551326e-15, -1.180809999045166e-18,
 -6.709434676942478e-20, -3.456813520824012e-22, -8.282303585675518e-26,  9.546983081209600e-27,  1.836943318310239e+00, -1.370322205348133e-03, -7.381485427917088e-06,
 -2.669102851221208e-08, -3.669142990654722e-11,  3.103033198580702e-13,  2.809086183364253e-15,  1.064642268376027e-17, -3.129593736442315e-21, -3.155090002816966e-22,
 -2.077647553403097e-24, -5.110831854336965e-27,  1.894985793491807e+00, -9.388463333807439e-04, -5.709744682419848e-06, -2.649637451544690e-08, -8.614827657812662e-11,
 -7.894208639446210e-14,  1.379658008348947e-15,  1.236230625925167e-17,  5.893800309213378e-20,  1.208270500121115e-22, -7.280350560116258e-25, -9.429686900310001e-27,
  1.941957744477393e+00, -5.455558640915736e-04, -3.649148070097006e-06, -2.012841371257436e-08, -9.297568890510549e-11, -3.380316998546525e-13, -6.983182048059640e-16,
  2.288583808879077e-18,  3.750022331387485e-20,  2.656123191809193e-22,  1.305579220147104e-24,  4.068460277391625e-27,  1.975938313783033e+00, -2.345182016644452e-04,
 -1.678116123738572e-06, -1.037103419810181e-08, -5.784163633182436e-11, -2.941649649647587e-13, -1.351594154490597e-15, -5.412723616364995e-18, -1.690009553612337e-20,
 -2.069163555828478e-23,  2.460608770240444e-25,  2.900293980242173e-27,  1.995384406210258e+00, -4.593117252891291e-05, -3.414437584465716e-07, -2.244468339818118e-09,
 -1.374226104203352e-11, -8.014107608226163e-14, -4.501252271904698e-16, -2.449088072149714e-18, -1.294378815811573e-20, -6.649554100285956e-23, -3.316724410545131e-25,
 -1.601258052497919e-27,  4.230761190000383e-04, -1.958553512564817e-06,  6.798661388211974e-09, -2.097614014703137e-11,  6.064799334976064e-14, -1.683435478030943e-16,
  4.538619880132975e-19, -1.199643423814317e-21,  3.112387893060437e-24, -8.010901056912815e-27,  2.019042974359844e-29, -5.156598215660541e-32,  3.807882932959998e-03,
 -1.761434449056735e-05,  6.103113513879107e-08, -1.876726158485990e-10,  5.397640326353794e-13, -1.486871924136972e-15,  3.966981626683221e-18, -1.034263018552658e-20,
  2.636301328954174e-23, -6.639600970543144e-26,  1.627472426921699e-28, -4.030546733194402e-31,  1.057854466761585e-02, -4.885826249661432e-05,  1.686578302496876e-07,
 -5.151313310112818e-10,  1.465745038311223e-12, -3.974690176209916e-15,  1.037464889917353e-17, -2.626481477370633e-20,  6.438279865680707e-23, -1.542471808374924e-25,
  3.533420330177120e-28, -8.082174394460919e-31,  2.073712285038180e-02, -9.555369628975099e-05,  3.279931569602439e-07, -9.914839892777342e-10,  2.774630896586057e-12,
 -7.339457878131832e-15,  1.848572688899353e-17, -4.451745300136399e-20,  1.016782370679334e-22, -2.207163774583816e-25,  4.336358649575853e-28, -7.977619913273689e-31,
  3.428662152108725e-02, -1.574924897758828e-04,  5.364860319593777e-07, -1.598932245390506e-09,  4.371876871916046e-12, -1.115822953362445e-14,  2.662885580142137e-17,
 -5.911732095787317e-20,  1.185863971842325e-22, -2.062123159409585e-25,  2.376016490737808e-28,  4.676088515379068e-32,  5.123087695069132e-02, -2.343909677081742e-04,
  7.906926955615989e-07, -2.313763168030428e-09,  6.134142696119955e-12, -1.489675267483491e-14,  3.279160495592705e-17, -6.335276524381337e-20,  9.528865147065431e-23,
 -6.016531557998167e-26, -3.373250846024637e-28,  1.832862812945043e-30,  7.157440305944934e-02, -3.258844889996613e-04,  1.086240613766410e-06, -3.106388345364314e-09,
  7.911873611656173e-12, -1.793620975090747e-14,  3.480666966882741e-17, -5.081691931647248e-20,  1.666882544962093e-23,  2.391121069155446e-25, -1.259304655117716e-27,
  4.139704050293080e-30,  9.532218557438052e-02, -4.315203966628099e-04,  1.417783703766424e-06, -3.941424374383668e-09,  9.532850048552651e-12, -1.960821697281988e-14,
  3.058446062208191e-17, -1.662190927462279e-20, -1.224621031274961e-22,  6.658553549170587e-25, -2.310635713486201e-27,  5.936127703471111e-30,  1.224794155669832e-01,
 -5.507491952324498e-04,  1.778949340131836e-06, -4.777839419607531e-09,  1.080693734843147e-11, -1.923900736489892e-14,  1.838955515853675e-17,  4.127748738313250e-20,
 -3.124352624297115e-22,  1.133842018507242e-24, -3.077564387454283e-27,  5.723308477725436e-30,  1.530511501127979e-01, -6.829137450823062e-04,  2.162277952342927e-06,
 -5.569199365606278e-09,  1.153232724397323e-11, -1.620374110976096e-14, -2.844848890810747e-18,  1.207575091082769e-19, -5.249606767065018e-22,  1.493970494884942e-24,
 -3.002862194367996e-27,  1.963890358231476e-30,  1.870418842476098e-01, -8.272362181380831e-04,  2.559156572570081e-06, -6.264058419137232e-09,  1.150362755775345e-11,
 -9.991737851502051e-15, -3.317572424485277e-17,  2.143504461644175e-19, -7.116365985680155e-22,  1.547816084955638e-24, -1.517755926861487e-27, -6.200475510480020e-30,
  2.244550139495785e-01, -9.828025114652008e-04,  2.959748519588059e-06, -6.806553545576447e-09,  1.052222236904865e-11, -2.830113246970631e-16, -7.130172541038571e-17,
  3.084357135693734e-19, -8.060547292237365e-22,  1.082165341888143e-24,  1.742254013238459e-27, -1.804205133551789e-29,  2.652921642825259e-01, -1.148543765298127e-03,
  3.352922628114915e-06, -7.137280652186945e-09,  8.409384293530504e-12,  1.296434593576933e-14, -1.142389125019025e-16,  3.830848917106452e-19, -7.309661793066100e-22,
 -7.222986623811204e-26,  6.655264074688504e-27, -3.039346605948297e-29,  3.095523497463182e-01, -1.323214583002896e-03,  3.726187217133318e-06, -7.194553803633264e-09,
  5.022659469811883e-12,  2.941785368372923e-14, -1.570690342205040e-16,  4.129294442673149e-19, -4.119232693972988e-22, -1.958412423308530e-24,  1.231697976280435e-26,
 -3.726670120560954e-29,  3.572309248494343e-01, -1.505367507406817e-03,  4.065636564508854e-06, -6.916177732374694e-09,  2.760394746286519e-13,  4.826976696206322e-14,
 -1.928313470808847e-16,  3.694946244234164e-19,  2.016177818980316e-22, -4.395489605292679e-24,  1.683174375505575e-26, -3.053026509669643e-29,  4.083182713726559e-01,
 -1.693323280075480e-03,  4.355921333612159e-06, -6.241898880569207e-09, -5.835659399087282e-12,  6.813980369450129e-14, -2.126577082772472e-16,  2.254835875801827e-19,
  1.107847799042755e-21, -6.885058592468727e-24,  1.734894282134772e-26, -2.295890413045194e-30,  4.627981539973763e-01, -1.885136413101416e-03,  4.580259609506479e-06,
 -5.116740657047819e-09, -1.320803912282914e-11,  8.699540440388005e-14, -2.062843668619598e-16, -3.855092928362778e-20,  2.219096733846125e-21, -8.558071714438259e-24,
  1.055407105292624e-26,  5.053591814407716e-29,  5.206456569976463e-01, -2.078555662715945e-03,  4.720512519762783e-06, -3.495472049443135e-09, -2.159433033974545e-11,
  1.021117865133415e-13, -1.631079059470402e-16, -4.249345325276126e-19,  3.329291132185484e-21, -8.218939495610322e-24, -6.167749857828175e-27,  1.198448759651370e-28,
  5.818245903837012e-01, -2.270979152753698e-03,  4.757358578530929e-06, -1.348498958764906e-09, -3.056986413179866e-11,  1.101055726883140e-13, -7.397596883093389e-17,
 -9.073317746749217e-19,  4.094138498135842e-21, -4.562928017949934e-24, -3.277876484758275e-26,  1.797875244277418e-28,  6.462842228333965e-01, -2.459404221427179e-03,
  4.670614812845022e-06,  1.330508583474101e-09, -3.949672855975314e-11,  1.070906964411128e-13,  6.610733514029347e-17, -1.418345028745633e-18,  4.043538039082200e-21,
  3.352117223271073e-24, -6.404341978411324e-26,  1.845463090243942e-28,  7.139551593362820e-01, -2.640372664343809e-03,  4.439771427693369e-06,  4.514958332337088e-09,
 -4.749418872871607e-11,  8.902271809433414e-14,  2.542689008713329e-16, -1.839505259229109e-18,  2.654171761463113e-21,  1.533421454794000e-23, -8.724068380055434e-26,
  7.768333903433588e-29,  7.847441319916725e-01, -2.809913088080096e-03,  4.044831165509463e-06,  8.133458571790878e-09, -5.342456902504787e-11,  5.231409450394433e-14,
  4.751910209216365e-16, -1.999730899439567e-18, -4.847744793320377e-22,  2.906018309211192e-23, -8.203480502232737e-26, -1.779853569927325e-28,  8.585274113765764e-01,
 -2.963483830347590e-03,  3.467574931146375e-06,  1.205580927798472e-08, -5.591034188798555e-11, -5.190571086488048e-15,  6.963115944125061e-16, -1.692012047020664e-18,
 -5.387889685642063e-21,  3.918824945541834e-23, -2.562866336136437e-26, -5.457396390185795e-28,  9.351424728353105e-01, -3.095922734481208e-03,  2.693410262178751e-06,
  1.607752770522868e-08, -5.340638780528635e-11, -8.281258541387592e-14,  8.643299272927628e-16, -7.215864309754004e-19, -1.128604834873446e-20,  3.735270450260805e-23,
  9.324457478843067e-26, -8.501994087494003e-28,  1.014377468906666e+00, -3.201414557439854e-03,  1.713993376880529e-06,  1.990466201063474e-08, -4.436123195562018e-11,
 -1.752302251745735e-13,  9.059417359066664e-16,  1.000857885687439e-18, -1.624585534266983e-20,  1.433734835404265e-23,  2.506084799558396e-25, -7.577070252728151e-28,
  1.095957973185932e+00, -3.273493735620457e-03,  5.308349987946433e-07,  2.314253505777649e-08, -2.750988736041402e-11, -2.704909604258064e-13,  7.375184040364414e-16,
  3.317135787545430e-18, -1.708317422387769e-20, -3.409712175161669e-23,  3.624746996668245e-25,  9.015700175633887e-29,  1.179530390076610e+00, -3.305110647786839e-03,
 -8.399249891591893e-07,  2.529509365118643e-08, -2.341585434284125e-12, -3.484813120931559e-13,  2.898947955108465e-16,  5.658125949417141e-18, -1.008871055333123e-20,
 -9.750730221747463e-23,  2.867440812802020e-25,  1.679568931206547e-27,  1.264641406725853e+00, -3.288804488489752e-03, -2.361517201907976e-06,  2.578594829830510e-08,
  3.023745035809922e-11, -3.811604548375290e-13, -4.466070982076885e-16,  6.952345105609440e-18,  6.809018473084677e-21, -1.413812631457456e-22, -1.000851057805448e-25,
  3.054019755747911e-27,  1.350712970414871e+00, -3.217046038055778e-03, -3.969594824730209e-06,  2.401762326024452e-08,  6.710145512880116e-11, -3.367178843084098e-13,
 -1.359777634119061e-15,  5.797932513628562e-18,  3.031626275486205e-20, -1.107076426081226e-22, -7.193968414267496e-25,  2.222066997767686e-27,  1.437012636724395e+00,
 -3.082837837429928e-03, -5.565320944929487e-06,  1.948997924794121e-08,  1.021868672004497e-10, -1.903527278119082e-13, -2.159981862954314e-15,  1.154733932714579e-18,
  4.823554517282597e-20,  3.387408505389854e-23, -1.095638201758572e-24, -2.199426903484802e-27,  1.522619966662071e+00, -2.880681715245101e-03, -7.010755631686549e-06,
  1.199655070551162e-08,  1.263767300923107e-10,  5.680247078121106e-14, -2.393125348441505e-15, -6.352834977794263e-18,  4.133301755648884e-20,  2.426169528469596e-22,
 -5.056191029954383e-25, -7.373455285778105e-27,  1.606391277040703e+00, -2.608028430267172e-03, -8.130804209162233e-06,  1.896803642683225e-09,  1.288721840851641e-10,
  3.545259705617859e-13, -1.617436757712326e-15, -1.315036207665225e-17, -2.251015099655812e-21,  3.277229735947688e-22,  1.115487558259496e-24, -5.311540861817974e-27,
  1.686927868841495e+00, -2.267277845229856e-03, -8.728427250780299e-06, -9.595002663454185e-09,  1.010651211338958e-10,  5.919207362296747e-13,  2.033555245377430e-16,
 -1.334997451550542e-17, -6.204874507794470e-20,  8.920862558222948e-23,  2.111640454863316e-24,  6.751390611573033e-27,  1.762557181092596e+00, -1.868243578011947e-03,
 -8.621290364268436e-06, -2.027017017976527e-08,  4.306462627158528e-11,  6.270687645444844e-13,  2.274989321337862e-15, -3.526709985757827e-18, -7.948976555652364e-20,
 -3.397678857219504e-22,  3.989677095179483e-25,  1.235365037747987e-26,  1.831341883766762e+00, -1.430664742247485e-03, -7.705083205423738e-06, -2.722467880093144e-08,
 -2.978714188276697e-11,  3.812761907030148e-13,  3.103959649013034e-15,  1.034808889569539e-17, -1.603403226680225e-20, -4.026611285317959e-22, -2.267058458756075e-24,
 -3.335999951029418e-27,  1.891137005295219e+00, -9.858196568515449e-04, -6.036017354351791e-06, -2.788545702771634e-08, -8.736684498364248e-11, -4.145964218936988e-14,
  1.752815721296644e-15,  1.431143937234094e-17,  6.265636083402131e-20,  8.260739229295909e-23, -1.203392807790044e-24, -1.223519473691517e-26,  1.939715568505075e+00,
 -5.757410215037906e-04, -3.899840685743103e-06, -2.167099607028232e-08, -9.989798912614426e-11, -3.538775674956821e-13, -6.159263886494764e-16,  3.652010380725987e-18,
  4.804501413184501e-20,  3.213648149894246e-22,  1.480038067772955e-24,  3.789641872886589e-27,  1.974972580104360e+00, -2.484571320627182e-04, -1.808321332674485e-06,
 -1.134538188926087e-08, -6.406191276684094e-11, -3.284836243999126e-13, -1.510818560647660e-15, -5.963276987262916e-18, -1.743417771537393e-20, -7.973855299408565e-24,
  3.984428607259151e-25,  4.084606433974816e-27,  1.995195042397834e+00, -4.877432071897181e-05, -3.697514958200652e-07, -2.477778238603302e-09, -1.545891877444878e-11,
 -9.181608684921444e-14, -5.248774696553156e-16, -2.904295599169337e-18, -1.559441566023169e-20, -8.128308217300821e-23, -4.106267423628017e-25, -2.002803176971417e-27,
  4.153491123015837e-04, -1.905154832024951e-06,  6.552660693455623e-09, -2.003212660653600e-11,  5.738738553300189e-14, -1.578429468964285e-16,  4.216240530095598e-19,
 -1.104509755316303e-21,  2.838001328329113e-24, -7.246963267437721e-27,  1.804707046634396e-29, -4.598877027500852e-32,  3.738387994372590e-03, -1.713495910611990e-05,
  5.882991625183665e-08, -1.792692146648713e-10,  5.109556961184483e-13, -1.395046324704851e-15,  3.688848036717283e-18, -9.536035373797122e-21,  2.408577728536757e-23,
 -6.022811496458723e-26,  1.459512279810266e-28, -3.613433720994812e-31,  1.038577154792227e-02, -4.753333343071458e-05,  1.626143856549718e-07, -4.923020782016460e-10,
  1.388682763685449e-12, -3.734295807244064e-15,  9.667261845282520e-18, -2.429075200151499e-20,  5.907594054180911e-23, -1.408024084159283e-25,  3.194320485304414e-28,
 -7.346912783115616e-31,  2.036008165389571e-02, -9.297659856739293e-05,  3.163569465542269e-07, -9.482405200892318e-10,  2.632179217331279e-12, -6.910397852407929e-15,
  1.728361901148339e-17, -4.138760228592088e-20,  9.403632002586090e-23, -2.040604783016989e-25,  3.994622787087916e-28, -7.561555870797661e-31,  3.366511547636486e-02,
 -1.532761778551497e-04,  5.177112917238117e-07, -1.530733363306604e-09,  4.154971315825512e-12, -1.053857839962002e-14,  2.502559459158027e-17, -5.543949801890092e-20,
  1.113340525329746e-22, -1.966965547159481e-25,  2.374866591273658e-28, -4.939387821903464e-32,  5.030579064299087e-02, -2.281748406571563e-04,  7.635067202659683e-07,
 -2.217958202013361e-09,  5.843935715675910e-12, -1.413069821189948e-14,  3.106007354804955e-17, -6.034063600820370e-20,  9.289835506929059e-23, -7.214437010888695e-26,
 -2.640009318891009e-28,  1.506873712917153e-30,  7.028801187034055e-02, -3.173415456710390e-04,  1.049711801294670e-06, -2.982623255834859e-09,  7.561388108606675e-12,
 -1.711785627439093e-14,  3.339249033832825e-17, -5.015516394746172e-20,  2.441253263343603e-23,  1.922159671325434e-25, -1.089533774665852e-27,  3.586050747092147e-30,
  9.361849260038203e-02, -4.203647520136309e-04,  1.371388952193100e-06, -3.791996372115805e-09,  9.147986084290529e-12, -1.888019617866432e-14,  3.006766347732961e-17,
 -2.017450202133765e-20, -1.000936788561613e-22,  5.784720629170018e-25, -2.062975915017759e-27,  5.325530094896040e-30,  1.203045229712071e-01, -5.367440264022023e-04,
  1.722640114040433e-06, -4.607982310120419e-09,  1.042665862991681e-11, -1.878488169244872e-14,  1.941132360007392e-17,  3.190938076999494e-20, -2.737728708758850e-22,
  1.015691072797936e-24, -2.832195529939593e-27,  5.419734787008488e-30,  1.503536727164722e-01, -6.658797308883187e-04,  2.096543959945603e-06, -5.387277321875248e-09,
  1.120783393348819e-11, -1.623329234689771e-14,  3.091000994107335e-19,  1.047962911961157e-19, -4.733174992599198e-22,  1.375743304187567e-24, -2.904932814317065e-27,
  2.453792919353355e-30,  1.837734142088064e-01, -8.070605268335063e-04,  2.485085490570404e-06, -6.081640322438659e-09,  1.129630369156883e-11, -1.071845570638638e-14,
 -2.748443463841265e-17,  1.924573982566957e-19, -6.570689314738834e-22,  1.482173975815779e-24, -1.752006974685512e-27, -4.505267886077889e-30,  2.205706466211844e-01,
 -9.594483768540784e-04,  2.879079530320418e-06, -6.638333362598833e-09,  1.050013435148830e-11, -1.893496588113745e-15, -6.302069410505205e-17,  2.832772406943729e-19,
 -7.660255222106044e-22,  1.136867850402729e-24,  1.014155877274136e-27, -1.511952775962012e-29,  2.607510968040405e-01, -1.122060667636098e-03,  3.268090644954299e-06,
 -7.000801576281444e-09,  8.642109045772722e-12,  1.034868475625632e-14, -1.038400478320831e-16,  3.597011939922662e-19, -7.290876082283278e-22,  1.682581437595408e-25,
  5.394079471236749e-27, -2.696973067380227e-29,  3.043185656096938e-01, -1.293749014281175e-03,  3.640353509797507e-06, -7.109685310058804e-09,  5.574248536916589e-12,
  2.578538981739190e-14, -1.457014908010599e-16,  3.987117711439306e-19, -4.739473678253006e-22, -1.497897572454950e-24,  1.072490203182783e-26, -3.505339835972891e-29,
  3.512739795760267e-01, -1.473174244585274e-03,  3.982699984675380e-06, -6.904285861265415e-09,  1.195996468469872e-12,  4.376655224426044e-14, -1.824180501878873e-16,
  3.735418711861607e-19,  5.517022881037649e-23, -3.749624138388520e-24,  1.545021085930356e-26, -3.208838890898996e-29,  4.016141965027796e-01, -1.658777006070401e-03,
  4.280502403779765e-06, -6.324642152225257e-09, -4.523370029399618e-12,  6.311556291507686e-14, -2.058841609507492e-16,  2.571025089863992e-19,  8.724298232808823e-22,
 -6.195593957199264e-24,  1.706649293188625e-26, -1.023505255748039e-29,  4.553304987266816e-01, -1.848743401879419e-03,  4.517647294824700e-06, -5.314419239378463e-09,
 -1.151768644290876e-11,  8.203936908052550e-14, -2.064153491294069e-16,  2.761626215079826e-20,  1.919098311780436e-21, -8.096093322427393e-24,  1.243325498179800e-26,
  3.521415257329037e-29,  5.124066888018680e-01, -2.040965065065219e-03,  4.676560493728480e-06, -3.824859974048669e-09, -1.959214320618160e-11,  9.806618263615371e-14,
 -1.735593127944480e-16, -3.231689779620524e-19,  3.030185895716332e-21, -8.366049490540526e-24, -1.331656645869933e-27,  1.000945015510714e-28,  5.728166775050052e-01,
 -2.232993160386579e-03,  4.738314218307825e-06, -1.820104731386756e-09, -2.838748890356943e-11,  1.080399299149838e-13, -9.757349479179820e-17, -7.791854188999665e-19,
  3.908140454941952e-21, -5.720121599469418e-24, -2.519114768065523e-26,  1.646700870397776e-28,  6.365214219518367e-01, -2.421986018350624e-03,  4.682860152744040e-06,
  7.157684035829787e-10, -3.734218970131440e-11,  1.082154242123923e-13,  2.821988871170273e-17, -1.287499398242052e-18,  4.120078469801074e-21,  9.547091553783017e-25,
 -5.579292655998901e-26,  1.892433249867729e-28,  7.034650301018246e-01, -2.604650555959165e-03,  4.489451267169472e-06,  3.769609181096570e-09, -4.565683014998836e-11,
  9.451718161154261e-14,  2.040300521933208e-16, -1.746405285201392e-18,  3.144332036828364e-21,  1.192575918843160e-23, -8.288520120058025e-26,  1.184514583460655e-28,
  7.735697946756105e-01, -2.777178480778708e-03,  4.137340392187438e-06,  7.287636314780892e-09, -5.226878172067717e-11,  6.304596014320209e-14,  4.191340538712102e-16,
 -1.999152160451523e-18,  5.006647216209260e-22,  2.564676035335451e-23, -8.804282172141377e-26, -9.653156852700501e-29,  8.467298520229483e-01, -2.935179761737922e-03,
  3.606876720284075e-06,  1.116130486486872e-08, -5.585097119702479e-11,  1.093420387424147e-14,  6.467318948094880e-16, -1.842095251044344e-18, -4.001099886819443e-21,
  3.771067080123576e-23, -4.755109785221411e-26, -4.498327423881963e-28,  9.228030776888558e-01, -3.073618376180967e-03,  2.881162555533246e-06,  1.521089498532571e-08,
 -5.485704244223423e-11, -6.235066411676816e-14,  8.392762211875134e-16, -1.060577641767218e-18, -9.883151380779809e-21,  4.034343781848291e-23,  5.657392649629716e-26,
 -8.116064636663962e-28,  1.001600729949096e+00, -3.186759511535160e-03,  1.948478840994443e-06,  1.916803528939093e-08, -4.764644182897325e-11, -1.532095358483497e-13,
  9.267786111125576e-16,  4.911159069119054e-19, -1.555766931300177e-20,  2.365587646450613e-23,  2.144432018677904e-25, -8.778010008231322e-28,  1.082874239338291e+00,
 -3.268144101382472e-03,  8.057291451254772e-07,  2.266009048456797e-08, -3.273550258671256e-11, -2.517387679415925e-13,  8.225803765369348e-16,  2.753634357624816e-18,
 -1.804963963522302e-20, -1.961797991792962e-23,  3.590820028129077e-25, -2.391596134692244e-28,  1.166298429518645e+00, -3.310617047087081e-03, -5.368372851868413e-07,
  2.520230246541068e-08, -9.229006297721038e-12, -3.396623483404709e-13,  4.432914575328422e-16,  5.281474618036607e-18, -1.337571706120119e-20, -8.467124251440881e-23,
  3.521890133961637e-25,  1.285975739042915e-27,  1.251450375071706e+00, -3.306451258817562e-03, -2.049436297683657e-06,  2.620824602444955e-08,  2.252293068699532e-11,
 -3.895231398404355e-13, -2.496601341858625e-16,  7.088288720432959e-18,  1.679670283637286e-21, -1.426936484971594e-22,  3.424512732181053e-26,  3.023815056414942e-27,
  1.337783123162828e+00, -3.247632222190678e-03, -3.675169427962476e-06,  2.503565565028187e-08,  6.005445073756367e-11, -3.672986947287895e-13, -1.184491403810339e-15,
  6.698937402502940e-18,  2.583859258951587e-20, -1.372875308557969e-22, -6.038950737420442e-25,  3.004096843521165e-27,  1.424593760313300e+00, -3.126397398725733e-03,
 -5.321765973650248e-06,  2.109171021285473e-08,  9.786494102576345e-11, -2.416290621028441e-13, -2.105917757847323e-15,  2.709156567557371e-18,  4.864609162667108e-20,
 -1.152605571362625e-23, -1.165108681241880e-24, -9.293603630981266e-28,  1.510986028065442e+00, -2.936157485617930e-03, -6.854637634616606e-06,  1.402448845869102e-08,
  1.269248273139037e-10, -2.609714824255913e-15, -2.551206003602800e-15, -4.894970019831471e-18,  4.962488339132798e-20,  2.158984862158570e-22, -8.295231497805722e-25,
 -7.265390652929187e-27,  1.595829264788734e+00, -2.672948239576639e-03, -8.095444022799292e-06,  4.013248410452668e-09,  1.355446989290636e-10,  3.112920242307916e-13,
 -1.984823167169145e-15, -1.302551279340782e-17,  1.028759042687430e-20,  3.669826678767037e-22,  8.306368573353484e-25, -7.623093859425647e-27,  1.677718413400958e+00,
 -2.337537432855867e-03, -8.833473861335421e-06, -7.883119316476187e-09,  1.129209186349743e-10,  5.920948732332070e-13, -1.976393570365987e-16, -1.526729701078727e-17,
 -5.724985906939129e-20,  1.790980372177403e-22,  2.368430020882989e-24,  4.773562736125612e-27,  1.754944743419299e+00, -1.938174183286334e-03, -8.859974831862862e-06,
 -1.947787746002841e-08,  5.614246744481113e-11,  6.801849340134524e-13,  2.138819559271134e-15, -6.261896976090116e-18, -9.129578379598300e-20, -3.121318299050725e-22,
  1.002316414811297e-24,  1.502296220429210e-26,  1.825493863750428e+00, -1.493619688255115e-03, -8.034373896967659e-06, -2.763612402419266e-08, -2.139355706880545e-11,
  4.591761749268752e-13,  3.384217460752700e-15,  9.585322016046496e-18, -3.219073558763259e-20, -4.955208077428738e-22, -2.355036063439695e-24, -4.647517341167303e-28,
  1.887094997483006e+00, -1.035470108881244e-03, -6.379049633121591e-06, -2.928753406571263e-08, -8.774172242372055e-11,  5.645532805928890e-15,  2.181980550043619e-15,
  1.635362840684134e-17,  6.462593384519997e-20,  2.281092246650225e-23, -1.808942594168843e-24, -1.532280132899162e-26,  1.937348520896041e+00, -6.080076699803906e-04,
 -4.169718903582901e-06, -2.332674944138072e-08, -1.071141353087981e-10, -3.672478882997549e-13, -4.903234070505956e-16,  5.386298180664757e-18,  6.071826116596881e-20,
  3.837057445915227e-22,  1.631012912253816e-24,  2.962113416122547e-27,  1.973948930911234e+00, -2.634862182762982e-04, -1.950839197713127e-06, -1.242495788767730e-08,
 -7.100803292716719e-11, -3.668101190101758e-13, -1.685619891909122e-15, -6.522310678984897e-18, -1.738714114891928e-20,  1.199324378023209e-23,  6.114812034044236e-25,
  5.674912385446897e-27,  1.994993834653880e+00, -5.185561501561878e-05, -4.010317846520320e-07, -2.740524652289326e-09, -1.742810137555470e-11, -1.054482004049750e-13,
 -6.136475882681757e-16, -3.453486611466423e-18, -1.883875957756978e-20, -9.961101729660163e-23, -5.094480463436012e-25, -2.508214507842803e-27,  4.078318348278327e-04,
 -1.853679715586299e-06,  6.317681939490713e-09, -1.913864384508920e-11,  5.432926337111705e-14, -1.480850588673791e-16,  3.919309547168712e-19, -1.017732509025966e-21,
  2.589630388934676e-24, -6.564076714214829e-27,  1.613244462312949e-29, -4.115649978295564e-32,  3.670776005597965e-03, -1.667278780812271e-05,  5.672683202947083e-08,
 -1.713124099224891e-10,  4.839189071826473e-13, -1.309632949440494e-15,  3.432311376247511e-18, -8.798885581357518e-21,  2.201891962917979e-23, -5.469699943449824e-26,
  1.308684691696065e-28, -3.251007174799571e-31,  1.019820315528439e-02, -4.625567671887801e-05,  1.568376498384186e-07, -4.706682626662347e-10,  1.316262983410081e-12,
 -3.510234194057946e-15,  9.012842009125212e-18, -2.247902012104854e-20,  5.422943382691321e-23, -1.286520602813481e-25,  2.885539993256735e-28, -6.703432958015327e-31,
  1.999316590158195e-02, -9.049055294648580e-05,  3.052262605994091e-07, -9.072091664073325e-10,  2.498027190706665e-12, -6.509163874378785e-15,  1.616581165640417e-17,
 -3.849295942248958e-20,  8.696984151797711e-23, -1.887360316591276e-25,  3.670330004710282e-28, -7.187034962918819e-31,  3.306017938452982e-02, -1.492068483798135e-04,
  4.997345174319815e-07, -1.465907882046211e-09,  3.950082206837759e-12, -9.956195694322001e-15,  2.352211481996305e-17, -5.198827793151879e-20,  1.044232123106018e-22,
 -1.872657469135431e-25,  2.334506347017599e-28, -1.322767843248615e-31,  4.940514103914457e-02, -2.221716805565584e-04,  7.374430430523432e-07, -2.126676208371227e-09,
  5.568641042172521e-12, -1.340519744955657e-14,  2.941174995206899e-17, -5.741135748405866e-20,  9.012625542313317e-23, -8.146579570158571e-26, -2.041736297236580e-28,
  1.217957055421068e-30,  6.903521726673201e-02, -3.090849862180003e-04,  1.014635057447176e-06, -2.864336835103642e-09,  7.226931911170995e-12, -1.633319426501496e-14,
  3.200006460983149e-17, -4.927135822023102e-20,  3.058448259466061e-23,  1.516386662603248e-25, -9.430021938041495e-28,  3.081882850749727e-30,  9.195869109914875e-02,
 -4.095731964138769e-04,  1.326750867928207e-06, -3.648610416254595e-09,  8.777550853247646e-12, -1.816569414257790e-14,  2.946095520047345e-17, -2.305977812129575e-20,
 -8.069914255395238e-23,  5.004655209381866e-25, -1.841612586576456e-27,  4.740372719480507e-30,  1.181847628671683e-01, -5.231812809767475e-04,  1.668332970307055e-06,
 -4.444135754354731e-09,  1.005568710850088e-11, -1.830924532113133e-14,  2.018747972358857e-17,  2.371228282341422e-20, -2.391906239701415e-22,  9.070706527381145e-25,
 -2.601440138669347e-27,  5.060870680855341e-30,  1.477232933344875e-01, -6.493629446565295e-04,  2.032961874126503e-06, -5.210547935201625e-09,  1.088347129449668e-11,
 -1.619232894045903e-14,  3.038636902989461e-18,  9.042035077308961e-20, -4.258553274145485e-22,  1.261806507870676e-24, -2.789724860707508e-27,  2.753771792945821e-30,
  1.805844755806753e-01, -7.874687055657919e-04,  2.413183066485180e-06, -5.902648465914608e-09,  1.107576273463005e-11, -1.131574360280346e-14, -2.238207139175269e-17,
  1.722710372343563e-19, -6.050159878880571e-22,  1.408552744711388e-24, -1.919146928156821e-27, -3.144469868070472e-30,  2.167784179005182e-01, -9.367315279752142e-04,
  2.800426034209519e-06, -6.470713703962652e-09,  1.044776777183163e-11, -3.313543976714673e-15, -5.542590955782338e-17,  2.594258346573585e-19, -7.245213347932464e-22,
  1.164900936664084e-24,  4.059005266653116e-28, -1.259273560951730e-29,  2.563146148611166e-01, -1.096249615431388e-03,  3.184917069261445e-06, -6.861004072400762e-09,
  8.824963335527620e-12,  7.974753858016039e-15, -9.409385130633681e-17,  3.365066858751943e-19, -7.194238419765093e-22,  3.612421896542786e-25,  4.278251369917204e-27,
 -2.379491222180406e-29,  2.992012770632955e-01, -1.264965896923948e-03,  3.555588827146259e-06, -7.016557901548048e-09,  6.055883195745744e-12,  2.242076045975396e-14,
 -1.347574232208558e-16,  3.827624876135388e-19, -5.205150796807955e-22, -1.099045857408732e-24,  9.235334515565734e-27, -3.263217686178894e-29,  3.454444816167606e-01,
 -1.441643660120794e-03,  3.899991495113614e-06, -6.878381584396510e-09,  2.028394891322508e-12,  3.951410807222468e-14, -1.719536201913850e-16,  3.732640335028001e-19,
 -6.903463403102362e-23, -3.160091590522448e-24,  1.402206576745099e-26, -3.268949607575313e-29,  3.950470942314823e-01, -1.624837705816340e-03,  4.204213247865781e-06,
 -6.387183553795702e-09, -3.309872414734082e-12,  5.826368279775123e-14, -1.983270390406106e-16,  2.815823551328369e-19,  6.615498902272781e-22, -5.523882740552931e-24,
  1.647397335485119e-26, -1.643054490585508e-29,  4.480073993194336e-01, -1.812860325502133e-03,  4.452821841150240e-06, -5.485844704686388e-09, -9.926341377383298e-12,
  7.710135341870323e-14, -2.048254531356313e-16,  8.446282774404638e-20,  1.636927045007838e-21, -7.571838887114501e-24,  1.368245462728848e-26,  2.189305483662090e-29,
  5.043173554914205e-01, -2.003741355881381e-03,  4.628845310918602e-06, -4.122872880472467e-09, -1.767315128924488e-11,  9.380285305592388e-14, -1.812958230182480e-16,
 -2.310238775669585e-19,  2.729059407412287e-21, -8.336853241986908e-24,  2.654352807110297e-27,  8.127385678595990e-29,  5.639603688776236e-01, -2.195181569705957e-03,
  4.713818637138167e-06, -2.257152566994170e-09, -2.625180293285784e-11,  1.054502946935413e-13, -1.176721027729811e-16, -6.576003117716327e-19,  3.685779753356494e-21,
 -6.587809440049857e-24, -1.831882875768515e-26,  1.474421973931904e-28,  6.269084439169679e-01, -2.384498772654137e-03,  4.687936031911892e-06,  1.356326462710796e-10,
 -3.517395141640519e-11,  1.084750167088900e-13, -5.982108903451765e-18, -1.155521410572987e-18,  4.116283067933954e-21, -1.110647242476563e-24, -4.749046201029009e-26,
  1.871266105315065e-28,  6.931185282478278e-01, -2.568566277925954e-03,  4.530366719886608e-06,  3.054472286579858e-09, -4.372141979021930e-11,  9.883885467786393e-14,
  1.565994071183600e-16, -1.639546514878670e-18,  3.515326515942179e-21,  8.724149548422198e-24, -7.697781535168829e-26,  1.483217060502490e-28,  7.625278121186205e-01,
 -2.743744068920283e-03,  4.219817553775383e-06,  6.461950723007369e-09, -5.091179153445918e-11,  7.243610134602380e-14,  3.635160039774231e-16, -1.969045028554229e-18,
  1.359734412590103e-21,  2.206200535403879e-23, -9.067134880087455e-26, -2.466609086447550e-29,  8.350476698446246e-01, -2.905804174795266e-03,  3.735460585289265e-06,
  1.027026435561320e-08, -5.548131883707568e-11,  2.582359772482828e-14,  5.935619922658931e-16, -1.948813174232574e-18, -2.682258409789134e-21,  3.544179824291422e-23,
 -6.517307757140539e-26, -3.511292782899946e-28,  9.105558376318770e-01, -3.049853961608290e-03,  3.058389383849405e-06,  1.432428989385229e-08, -5.590521377184102e-11,
 -4.259877048332959e-14,  8.053734483142595e-16, -1.353232745022906e-18, -8.398503379134945e-21,  4.190980726768881e-23,  2.222459856494662e-26, -7.458075724995986e-28,
  9.888863057417413e-01, -3.170264799953179e-03,  2.173824012832335e-06,  1.838239088764770e-08, -5.048737902150342e-11, -1.308572465911944e-13,  9.336994041146950e-16,
  8.474714086508551e-21, -1.456119302272317e-20,  3.143700638187401e-23,  1.741054715550365e-25, -9.475684927005339e-28,  1.069816263699974e+00, -3.260619863483586e-03,
  1.074345018469172e-06,  2.209714191809372e-08, -3.756695313429709e-11, -2.311374393298038e-13,  8.915093456571035e-16,  2.167492089469673e-18, -1.850069775695737e-20,
 -5.553922636241562e-24,  3.420043551551951e-25, -5.295656421280821e-28,  1.153049283089130e+00, -3.313705057425186e-03, -2.355178096830624e-07,  2.500091981534622e-08,
 -1.590414648509585e-11, -3.272998611757958e-13,  5.847421735389764e-16,  4.807503110699782e-18, -1.615781310408653e-20, -6.957810547029025e-23,  3.992935699981483e-25,
  8.506059965964743e-28,  1.238193778748316e+00, -3.321583221007750e-03, -1.733033099369775e-06,  2.650603118538936e-08,  1.468863699946809e-11, -3.931319750735945e-13,
 -5.120443570876639e-17,  7.060368717696535e-18, -3.400977497494290e-21, -1.387088091040401e-22,  1.635739071558382e-25,  2.828741026063924e-27,  1.324735716585643e+00,
 -3.275816099338354e-03, -3.369223575150048e-06,  2.593627988890655e-08,  5.243985500299721e-11, -3.933869398915362e-13, -9.861201494480852e-16,  7.442303084877576e-18,
  2.049508147779154e-20, -1.586059253324586e-22, -4.575741826127082e-25,  3.614440200509239e-27,  1.412004662506405e+00, -3.167932890137397e-03, -5.059438709263279e-06,
  2.261617145038486e-08,  9.253399018385319e-11, -2.910856139350121e-13, -2.008394776258051e-15,  4.250142020579234e-18,  4.738610316712298e-20, -5.854240026830687e-23,
 -1.175502187784240e-24,  4.703426401652736e-28,  1.499132838488350e+00, -2.990286913494332e-03, -6.674171607756475e-06,  1.605149808659788e-08,  1.262501987664317e-10,
 -6.529698790610900e-14, -2.664914013518435e-15, -3.189637324320900e-18,  5.672420796225903e-20,  1.764719684414837e-22, -1.137174833334103e-24, -6.629896577975283e-27,
  1.585008302384007e+00, -2.737481831941137e-03, -8.034076018796782e-06,  6.229058932624242e-09,  1.412648848273494e-10,  2.593293154527500e-13, -2.342900848602507e-15,
 -1.247921046480804e-17,  2.401027446124611e-20,  3.928539378914976e-22,  4.474494881425709e-25, -9.744379118720055e-27,  1.668226373515869e+00, -2.408552001410501e-03,
 -8.916841343075601e-06, -5.982056146646365e-09,  1.246797142308350e-10,  5.820213219434147e-13, -6.496698158877697e-16, -1.697748246100991e-17, -4.905344426930584e-20,
  2.772541574414067e-22,  2.518420839548444e-24,  1.897254062990744e-27,  1.747048829714390e+00, -2.009972597627533e-03, -9.087861905544565e-06, -1.846804505335485e-08,
  7.024353175504303e-11,  7.290724071935961e-13,  1.920959540338078e-15, -9.354076880347007e-18, -1.016451739217619e-19, -2.581264119803678e-22,  1.713948634684139e-24,
  1.721225300847392e-26,  1.819388727411351e+00, -1.559226305368882e-03, -8.367743571708065e-06, -2.790045078914484e-08, -1.137675576256667e-11,  5.434845276726203e-13,
  3.635373735639627e-15,  8.251643113576160e-18, -5.171996333921000e-20, -5.890056801873696e-22, -2.288927325519124e-24,  3.694588999280703e-27,  1.882848792743503e+00,
 -1.087932145472889e-03, -6.738909869002992e-06, -3.068749314120881e-08, -8.706683738357057e-11,  6.374179834226271e-14,  2.668850539236219e-15,  1.841945764108165e-17,
  6.397369261374218e-20, -6.396548883193280e-23, -2.552931038768810e-24, -1.848238301264589e-26,  1.934847960008010e+00, -6.425148023266511e-04, -4.460167158618369e-06,
 -2.509991925460076e-08, -1.145633640443755e-10, -3.769730769994790e-13, -3.101375281410936e-16,  7.563119836012485e-18,  7.573374697675126e-20,  4.511377597276168e-22,
  1.728604793555538e-24,  1.311132013516689e-27,  1.972862800293624e+00, -2.797092161663621e-04, -2.107004850629861e-06, -1.362203729856213e-08, -7.876389926460357e-11,
 -4.095187842767483e-13, -1.875932472346460e-15, -7.066548134777781e-18, -1.644973548604533e-20,  4.202614756698433e-23,  9.055442423751499e-25,  7.788857137379457e-27,
  1.994779780494927e+00, -5.520032056816114e-05, -4.356634589491083e-07, -3.037080329443392e-09, -1.969253996177430e-11, -1.214076945871105e-13, -7.193534135602207e-16,
 -4.117862047521375e-18, -2.281974617513014e-20, -1.223728010866902e-22, -6.332671480393928e-25, -3.143874714708758e-27,  };
  constexpr double w[14976] = {  7.948751231920860e-02, -2.667637324944252e-04,  9.417608261780250e-07, -3.452472847228082e-09,  1.297309598878263e-11,
 -4.944536286226116e-14,  1.897271561920230e-16, -7.294050736351746e-19,  2.801363308656874e-21, -1.073049811747052e-23,  4.095823981600354e-26, -1.557274533050881e-28,
  7.911722673551601e-02, -3.865663225916020e-04,  2.198087344082845e-06, -1.252184825728418e-08,  6.917382866585457e-11, -3.703103782125368e-13,  1.929823149588767e-15,
 -9.832369359646394e-18,  4.913873603709418e-20, -2.414915797445520e-22,  1.169315740493288e-24, -5.586907065259178e-27,  7.838396869550243e-02, -6.221169235515783e-04,
  5.202027463668275e-06, -3.989436559158967e-08,  2.852841908350942e-10, -1.935179139930693e-12,  1.258852785373506e-14, -7.910179878925536e-17,  4.826192264723268e-19,
 -2.870262410025834e-21,  1.668994577259340e-23, -9.511386912813793e-26,  7.730205141569556e-02, -9.655102154043808e-04,  1.088573959355732e-05, -1.068817134761725e-07,
  9.552276819997617e-10, -7.960425824282289e-12,  6.276362256138609e-14, -4.727916961573729e-16,  3.426635274944358e-18, -2.402053923741707e-20,  1.635229547715391e-22,
 -1.084523110698053e-24,  7.589218357671058e-02, -1.405382565824659e-03,  2.052662406350795e-05, -2.518656119207102e-07,  2.752513400448552e-09, -2.760334721404271e-11,
  2.586820355026186e-13, -2.293193284338884e-15,  1.939809524974073e-17, -1.575912370862661e-19,  1.235734141829936e-21, -9.389209717145453e-24,  7.418061392750434e-02,
 -1.927464118450247e-03,  3.561623946426095e-05, -5.361762309184089e-07,  7.045234479427824e-09, -8.371269834049514e-11,  9.190879714577920e-13, -9.458817183329394e-15,
  9.218531312415892e-17, -8.572798847055448e-19,  7.651559141082601e-21, -6.584370006907748e-23,  7.219808139473320e-02, -2.515250855401651e-03,  5.770688919288774e-05,
 -1.049265888416210e-06,  1.634916944981509e-08, -2.273138677679135e-10,  2.890254001909271e-12, -3.415994469933114e-14,  3.796588078461521e-16, -4.002136923449029e-18,
  4.027873863183541e-20, -3.890184951403047e-22,  6.997863720122122e-02, -3.150750092881935e-03,  8.825080540626520e-05, -1.911553550263613e-06,  3.490325133707532e-08,
 -5.618460886099367e-10,  8.192889150889899e-12, -1.101968176938262e-13,  1.384745059571324e-15, -1.641198108922413e-17,  1.848029906187749e-19, -1.988244918259002e-21,
  6.755840980724882e-02, -3.815250393483567e-03,  1.284469531916195e-04, -3.273582327923544e-06,  6.931045398595697e-08, -1.279696786439660e-09,  2.121912045582175e-11,
 -3.222302377789765e-13,  4.544173499816498e-15, -6.012705351580902e-17,  7.524064115515821e-19, -8.959164861222866e-21,  6.497438188016581e-02, -4.490068734433141e-03,
  1.791089559771607e-04, -5.310648676604016e-06,  1.291428594713198e-07, -2.711851263755743e-09,  5.074025241704207e-11, -8.638029106054382e-13,  1.358008650421083e-14,
 -1.993472746782710e-16,  2.755667453774791e-18, -3.610808159301144e-20,  6.226324160938720e-02, -5.157233424029788e-03,  2.405647992907274e-04, -8.212735497962883e-06,
  2.273746730334464e-07, -5.388351350236757e-09,  1.129682753248501e-10, -2.142031705642896e-12,  3.731490406765514e-14, -6.042288704200991e-16,  9.176860289822876e-18,
 -1.316374645012497e-19,  5.946035965541179e-02, -5.800069801604126e-03,  3.125952453750976e-04, -1.217029591647493e-05,  3.804927318559076e-07, -1.010301684680128e-08,
  2.357946922070839e-10, -4.949973468879046e-12,  9.501573499980607e-14, -1.688246249313389e-15,  2.803057988413198e-17, -4.380773734788409e-19,  5.659892930625642e-02,
 -6.403666060238763e-03,  3.944137968285397e-04, -1.735707354701919e-05,  6.081481506051290e-07, -1.797128741495513e-08,  4.640809170108530e-10, -1.072559154126683e-11,
  2.256708980472660e-13, -4.378219265370753e-15,  7.909889453969746e-17, -1.340877775534564e-18,  5.370929256852223e-02, -6.955207410927718e-03,  4.846870846656901e-04,
 -2.391161200539751e-05,  9.322566961910850e-07, -3.046621544035043e-08,  8.654986391986428e-10, -2.190537129933287e-11,  5.027142726790903e-13, -1.060004697524648e-14,
  2.074662572260251e-16, -3.798796796923850e-18,  5.081846040530517e-02, -7.444177172500600e-03,  5.815911486777611e-04, -3.191933952262946e-05,  1.375524282435616e-06,
 -4.941581999233164e-08,  1.535964753137419e-09, -4.235829170646565e-11,  1.055330877242838e-12, -2.407822840819200e-14,  5.084142836997570e-16, -1.001540536801433e-17,
  4.794982236173908e-02, -7.862432347558800e-03,  6.828965247381095e-04, -4.139709391053414e-05,  1.959457114566448e-06, -7.694621724454475e-08,  2.603279124554717e-09,
 -7.785207687549506e-11,  2.096316071119225e-12, -5.153628577377916e-14,  1.169305284413618e-15, -2.468770004340186e-17,  4.512303025497805e-02, -8.204168238678752e-03,
  7.860735075812974e-04, -5.228169934158896e-05,  2.701999745042350e-06, -1.153596628597131e-07,  4.227282365289029e-09, -1.364625995659229e-10,  3.954349901897984e-12,
 -1.043272925073007e-13,  2.533798372463451e-15, -5.712710201365805e-17,  4.235403292688392e-02, -8.465791383728044e-03,  8.884084285450080e-04, -6.442377221146250e-05,
  3.615014502998340e-06, -1.669446386839591e-07,  6.594835784223155e-09, -2.287978093801396e-10,  7.105578259740793e-12, -2.004013370933460e-13,  5.190778152359868e-15,
 -1.245352520899215e-16,  3.965523437495761e-02, -8.645722538920021e-03,  9.871221661985900e-04, -7.758739117176477e-05,  4.701860699593825e-06, -2.337253997908796e-07,
  9.908283629817725e-09, -3.678820400421046e-10,  1.219603801655398e-11, -3.663268776614950e-13,  1.008347765299784e-14, -2.565558119891276e-16,  3.703574569318816e-02,
 -8.744151835573767e-03,  1.079483200389850e-03, -9.145569446155549e-05,  5.955344424979701e-06, -3.171693864089234e-07,  1.436681693133433e-08, -5.685483495089592e-10,
  2.004360615091280e-11, -6.388485304087896e-13,  1.862296773275231e-14, -5.008389517426483e-16,  3.450170175050754e-02, -8.762766959748475e-03,  1.162909090449076e-03,
 -1.056419374064797e-04,  7.356287850184621e-06, -4.178807271129594e-07,  2.014125728362554e-08, -8.462260549551865e-10,  3.160695612272182e-11, -1.065240551757233e-12,
  3.277561301662853e-14, -9.287163369071232e-16,  3.205661586260636e-02, -8.704472711719013e-03,  1.235052064134033e-03, -1.197051099086116e-04,  8.872914293019557e-06,
 -5.353149241431338e-07,  2.734406654730620e-08, -1.215091302309108e-09,  4.791062762602785e-11, -1.701587537040914e-12,  5.507965226855624e-14, -1.639258040886458e-15,
  2.970174928314837e-02, -8.573117065863228e-03,  1.293866228315239e-03, -1.331689124421827e-04,  1.046116973927620e-05, -6.675523580626069e-07,  3.599764615003496e-08,
 -1.685664039406647e-09,  6.992052337219723e-11, -2.608186872820183e-12,  8.853732104763212e-14, -2.759175415230457e-15,  2.743647659172345e-02, -8.373235301519228e-03,
  1.337655583251722e-03, -1.455427321744767e-04,  1.206601345532673e-05, -8.111657985189186e-07,  4.600497261359535e-08, -2.262068430156047e-09,  9.837292477157985e-11,
 -3.841596793508368e-12,  1.363325451958902e-13, -4.435590254504071e-15,  2.525863250513577e-02, -8.109820266707342e-03,  1.365103421806636e-03, -1.563432417146842e-04,
  1.362362091816847e-05, -9.612097727064052e-07,  5.712710257984627e-08, -2.939300591197199e-09,  1.335714306615673e-10, -5.443469991753757e-12,  2.013457681926464e-13,
 -6.819022190518684e-15,  2.316482990858783e-02, -7.788123631562881e-03,  1.375284759834430e-03, -1.651153404880433e-04,  1.506436165696082e-05, -1.111348281757052e-06,
  6.897191970174405e-08, -3.700939001759275e-09,  1.751780238177694e-10, -7.427152776443668e-12,  2.854787136737743e-13, -1.003538729164255e-14,  2.115074273102032e-02,
 -7.413490254561470e-03,  1.367664158839646e-03, -1.714513428694353e-04,  1.631635061492922e-05, -1.254123399941084e-06,  8.099763977960400e-08, -4.517763086536961e-09,
  2.220340252723470e-10, -9.763939351711782e-12,  3.888584697856538e-13, -1.414842367051372e-14,  1.921135051927547e-02, -6.991225604443882e-03,  1.342081688618280e-03,
 -1.750075548199065e-04,  1.730932921041851e-05, -1.381352494465450e-06,  9.253310875425765e-08, -5.347697214836433e-09,  2.720511725103042e-10, -1.237162434794921e-11,
  5.090508681489314e-13, -1.911741902951058e-14,  1.734114413584601e-02, -6.526494567086066e-03,  1.298729882653108e-03, -1.755176401557922e-04,  1.797861321797113e-05,
 -1.484627958549998e-06,  1.028149974048228e-07, -6.137367242665073e-09,  3.222102432525137e-10, -1.510834681543725e-11,  6.404608685000282e-13, -2.475860263262538e-14,
  1.553429392303789e-02, -6.024248881760406e-03,  1.238124422542417e-03, -1.728024318479364e-04,  1.826884796452710e-05, -1.555882040767362e-06,  1.110398723181666e-07,
 -6.825357008637510e-09,  3.686936250386520e-10, -1.777446417606675e-11,  7.741141689267569e-13, -3.072093939740014e-14,  1.378478300071605e-02, -5.489179825695720e-03,
  1.161071013225790e-03, -1.667760726847005e-04,  1.813733408812472e-05, -1.587971764660515e-06,  1.164270974474771e-07, -7.347009687731556e-09,  4.071598095463136e-10,
 -2.012424846380546e-11,  8.979852715016661e-13, -3.648716166596934e-14,  1.208650918533849e-02, -4.925692514728373e-03,  1.068630538165621e-03, -1.574485603039730e-04,
  1.755672485413100e-05, -1.575235746578327e-06,  1.182868779744137e-07, -7.640370738627612e-09,  4.331445499739406e-10, -2.188763515719343e-11,  9.979582688251883e-13,
 -4.140792203479771e-14,  1.043335944505546e-02, -4.337898225974201e-03,  9.620841651920292e-04, -1.449249180087341e-04,  1.651694384095043e-05, -1.513976094562303e-06,
  1.160867308276437e-07, -7.652656386072530e-09,  4.425493366454179e-10, -2.280032373718728e-11,  1.059386718704531e-12, -4.477095525659015e-14,  8.819260978224761e-03,
 -3.729621408253754e-03,  8.428996538385278e-04, -1.294013151236382e-04,  1.502622492467306e-05, -1.402824193048997e-06,  1.095094041585343e-07, -7.346491811606380e-09,
  4.321575543744804e-10, -2.263860895272393e-11,  1.069080795988254e-12, -4.589908457215946e-14,  7.238213174155289e-03, -3.104418524414609e-03,  7.126997397318399e-04,
 -1.111585254939548e-04,  1.311123097411051e-05, -1.242958376756679e-06,  9.849582273893312e-08, -6.705124085511776e-09,  4.001065356472106e-10, -2.125384745638562e-11,
  1.017425542985746e-12, -4.426265684752039e-14,  5.684305778107470e-03, -2.465606864844890e-03,  5.732332451219089e-04, -9.055316051484466e-05,  1.081626178947519e-05,
 -1.038153474157602e-06,  8.326796658914795e-08, -5.735889537107110e-09,  3.462428772274459e-10, -1.860082481187720e-11,  9.002573348625812e-13, -3.958584399359205e-14,
  4.151736040006390e-03, -1.816305338483947e-03,  4.263500677388953e-04, -6.800724404881096e-05,  8.201624373594175e-06, -7.946569589758926e-07,  6.432863961456787e-08,
 -4.471404748453752e-09,  2.723003730554225e-10, -1.475474095356833e-11,  7.201236518229368e-13, -3.192432418250951e-14,  2.634907745793264e-03, -1.159520795033384e-03,
  2.739883351673850e-04, -4.399787113631663e-05,  5.341424206360314e-06, -5.209142428191377e-07,  4.243856768750115e-08, -2.968297838601978e-09,  1.818675916014996e-10,
 -9.913315243593813e-12,  4.866447950362248e-13, -2.169580166751275e-14,  1.130162552018945e-03, -4.989624230651521e-04,  1.183357943484862e-04, -1.907350955866656e-05,
  2.324099510208529e-06, -2.274753794119798e-07,  1.859801503838664e-08, -1.305318416535752e-09,  8.024764414416215e-11, -4.388628752303771e-12,  2.161326261684432e-13,
 -9.665941955121056e-15,  7.843526805907731e-02, -2.593919094828921e-04,  9.015447181499038e-07, -3.252573931407431e-09,  1.202811983564806e-11, -4.512720744605011e-14,
  1.705029305311405e-16, -6.456389374371865e-19,  2.442976888045668e-21, -9.221274084815779e-24,  3.469013580013377e-26, -1.300118766325284e-28,  7.760520502287907e-02,
 -3.695644042482865e-04,  2.054229350988354e-06, -1.147189067694263e-08,  6.220936419871398e-11, -3.271283348005114e-13,  1.675285688706576e-15, -8.390461276588382e-18,
  4.123093374607566e-20, -1.992845855293239e-22,  9.492175796785919e-25, -4.462194192762197e-27,  7.597580726989334e-02, -5.823408745282691e-04,  4.749456330004556e-06,
 -3.562375459120210e-08,  2.494310820221541e-10, -1.657978589256096e-12,  1.057523036270711e-14, -6.519016553831952e-17,  3.903626040942732e-19, -2.279357855171103e-21,
  1.301702246895365e-23, -7.287676371046558e-26,  7.360641087569186e-02, -8.833063885619987e-04,  9.689860338722766e-06, -9.279418279325349e-08,  8.100709469128939e-10,
 -6.601322271358564e-12,  5.093907600150672e-14, -3.758005221586407e-16,  2.668978218463688e-18, -1.834247634172914e-20,  1.224709143184651e-22, -7.969523540242670e-25,
  7.058094179429970e-02, -1.252550308060950e-03,  1.775129571796997e-05, -2.119252448680183e-07,  2.257670629683573e-09, -2.210026781459880e-11,  2.023736934952975e-13,
 -1.754439960941277e-15,  1.452325545194686e-17, -1.155305455035871e-19,  8.875018849028429e-22, -6.609178135328299e-24,  6.700241479235676e-02, -1.666474238742593e-03,
  2.980686668698074e-05, -4.357324165239488e-07,  5.571718040295207e-09, -6.452594439685950e-11,  6.912909727803146e-13, -6.948845264225042e-15,  6.619903663251493e-17,
 -6.021692644684477e-19,  5.260243548581906e-21, -4.432570561284204e-23,  6.298649552579345e-02, -2.099836081087870e-03,  4.654656745606943e-05, -8.205826104106795e-07,
  1.242564641127985e-08, -1.681754526323178e-10,  2.084240194850604e-12, -2.403579285803954e-14,  2.608819664324977e-16, -2.687675769125944e-18,  2.645322754280232e-20,
 -2.500019712561931e-22,  5.865473004803802e-02, -2.527793996888899e-03,  6.832399939175603e-05, -1.433278885621368e-06,  2.540643103434118e-08, -3.977345004565132e-10,
  5.648181912400944e-12, -7.406679674799793e-14,  9.082735705268256e-16, -1.051361756877921e-17,  1.157050926717752e-19, -1.217421402822478e-21,  5.412802714176920e-02,
 -2.927733759305421e-03,  9.505507627194663e-05, -2.344492539663742e-06,  4.815542234324190e-08, -8.640855356353986e-10,  1.394439233838287e-11, -2.063339160230709e-13,
  2.838065409875507e-15, -3.665835928483055e-17,  4.481448257855197e-19, -5.216627932311218e-21,  4.952089291665474e-02, -3.280711020232577e-03,  1.261828775290960e-04,
 -3.619511796605049e-06,  8.535257646459109e-08, -1.741158357430344e-09,  3.169416549058562e-11, -5.255543022845680e-13,  8.056130991862651e-15, -1.154095789384918e-16,
  1.558141933864278e-18, -1.995450018406031e-20,  4.493678334640251e-02, -3.572405854889801e-03,  1.607104178499117e-04, -5.307765482907026e-06,  1.424823505114744e-07,
 -3.279725801224957e-09,  6.688460564583679e-11, -1.235119052060858e-12,  2.097633867299554e-14, -3.314421458048342e-16,  4.915968448878165e-18, -6.891603926363114e-20,
  4.046478299109474e-02, -3.793558088061177e-03,  1.972916946489942e-04, -7.433011043066935e-06,  2.253593675547150e-07, -5.812821236115709e-09,  1.319743402417787e-10,
 -2.698350458684144e-12,  5.049888858265843e-14, -8.756077419562665e-16,  1.419864857860984e-17, -2.168849082120040e-19,  3.617766129964155e-02, -3.939916771124374e-03,
  2.343630355404631e-04, -9.986045383954670e-06,  3.394466976425042e-07, -9.747478787032778e-09,  2.449347135977557e-10, -5.514805111250596e-12,  1.131569455869742e-13,
 -2.142859369824975e-15,  3.781899386314899e-17, -6.267523139217877e-19,  3.213122179794274e-02, -4.011787069012747e-03,  2.702926434360576e-04, -1.292133508276092e-05,
  4.890542945712143e-07, -1.553915610395608e-08,  4.297628028628914e-10, -1.060127292683658e-11,  2.373594840643252e-13, -4.887169264003185e-15,  9.347798591910488e-17,
 -1.673947025705679e-18,  2.836475762999100e-02, -4.013288053683026e-03,  3.035264347214055e-04, -1.615821093070968e-05,  6.765439026300790e-07, -2.364836120140169e-08,
  7.160754973242433e-10, -1.925875323592167e-11,  4.683902822377656e-13, -1.044114319753610e-14,  2.155684458078282e-16, -4.155236796834268e-18,  2.490236522036918e-02,
 -3.951444915460670e-03,  3.327120139807445e-04, -1.958643011972996e-05,  9.016782019333988e-07, -3.448299233161695e-08,  1.137473811200421e-09, -3.320001795658001e-11,
  8.733142922050426e-13, -2.099097798745524e-14,  4.659950752828783e-16, -9.633303658369375e-18,  2.175484522072703e-02, -3.835231686818432e-03,  3.567886095784612e-04,
 -2.307517401164357e-05,  1.161232697869096e-06, -4.833367965084319e-08,  1.728559068832722e-09, -5.451054224910507e-11,  1.544409208812307e-12, -3.987019321565115e-14,
  9.481991424066636e-16, -2.094802609929770e-17,  1.892193015845322e-02, -3.674660636566017e-03,  3.750375343669799e-04, -2.648406374300834e-05,  1.448944073953670e-06,
 -6.531193353880878e-08,  2.520755809040081e-09, -8.552103709489558e-11,  2.599367778549191e-12, -7.180247053362373e-14,  1.822801948940256e-15, -4.288947339750297e-17,
  1.639461213938784e-02, -3.479987714410222e-03,  3.870939414648475e-04, -2.967460387338368e-05,  1.755809987383727e-06, -8.530142365829825e-08,  3.537387089094373e-09,
 -1.285831333911032e-10,  4.176509133377342e-12, -1.229943091027121e-13,  3.321452771968058e-15, -8.296011997561854e-17,  1.415739159474012e-02, -3.261075093676665e-03,
  3.929254198128259e-04, -3.252059005879044e-05,  2.070696638951312e-06, -1.079310513925770e-07,  4.788680327745009e-09, -1.857590263043754e-10,  6.423739894531333e-12,
 -2.009647595813414e-13,  5.753627460391400e-15, -1.520595845712911e-16,  1.219032034616037e-02, -3.026926093724309e-03,  3.927858946391339e-04, -3.491636469572097e-05,
  2.381164348145443e-06, -1.325750355619692e-07,  6.267490970911339e-09, -2.584569339259001e-10,  9.481030183360462e-12, -3.140142917285496e-13,  9.499976252462956e-15,
 -2.648253145022037e-16,  1.047076210970661e-02, -2.785387169800581e-03,  3.871543703943724e-04, -3.678226932371836e-05,  2.674395718028881e-06, -1.583808375754109e-07,
  7.946483597773500e-09, -3.470617760090912e-10,  1.345756005601939e-11, -4.702842229812248e-13,  1.498614066697537e-14, -4.392939315663149e-16,  8.974836286294486e-03,
 -2.542997354866045e-03,  3.766675947353448e-04, -3.806711919108104e-05,  2.938107964105482e-06, -1.843214029044299e-07,  9.777313135120300e-09, -4.506197291215018e-10,
  1.840614704637543e-11, -6.764385989001788e-13,  2.263330625226915e-14, -6.955546390306115e-16,  7.678544119390973e-03, -2.304957431864738e-03,  3.620542117157769e-04,
 -3.874793102751624e-05,  3.161347617882449e-06, -2.092647732467318e-07,  1.169204734033476e-08, -5.666334099324928e-10,  2.429871776552447e-11, -9.360975017595913e-13,
  3.278616810209030e-14, -1.053183811777733e-15,  6.558599556580505e-03, -2.075188296902525e-03,  3.440759196542016e-04, -3.882742045523087e-05,  3.335095680764600e-06,
 -2.320521928873505e-07,  1.360673289831897e-08, -6.910113205590149e-10,  3.100710994328088e-11, -1.248241788200490e-12,  4.562480704234083e-14, -1.527487445590547e-15,
  5.593001272028859e-03, -1.856449120689090e-03,  3.234789951603547e-04, -3.832993546270912e-05,  3.452646718661067e-06, -2.515755572368825e-07,  1.542670157814964e-08,
 -8.181935439771210e-10,  3.829320081101585e-11, -1.605869391220975e-12,  6.107292215883219e-14, -2.124904484704287e-15,  4.761388894196888e-03, -1.650489623079387e-03,
  3.009576094098172e-04, -3.729651916732132e-05,  3.509759338349644e-06, -2.668462289604487e-07,  1.705299535620167e-08, -9.414500720550812e-10,  4.581126439508652e-11,
 -1.995192941134460e-12,  7.871932620091019e-14, -2.838267835165545e-15,  4.045227427378001e-03, -1.458215787417203e-03,  2.771288318170259e-04, -3.577972791482442e-05,
  3.504602890246335e-06, -2.770494270176257e-07,  1.838918984582693e-08, -1.053323725204991e-09,  5.312376625223866e-11, -2.395619215477528e-12,  9.777110215377003e-14,
 -3.642884445871078e-15,  3.427860994278078e-03, -1.279853673299938e-03,  2.525181569602949e-04, -3.383870536018885e-05,  3.437543437406853e-06, -2.815810273502417e-07,
  1.934791504570919e-08, -1.146170787559629e-09,  5.972984289851433e-11, -2.780648473465316e-12,  1.170544564440783e-13, -4.494486407965974e-15,  2.894471940153220e-03,
 -1.115100962532376e-03,  2.275537820185379e-04, -3.153486353275462e-05,  3.310820611357178e-06, -2.800661887382688e-07,  1.985648917492765e-08, -1.212741979504337e-09,
  6.510385875631630e-11, -3.119694329044422e-12,  1.350731063610780e-13, -5.329959390723167e-15,  2.431975258563437e-03, -9.632601029494587e-04,  2.025676293883658e-04,
 -2.892837505098938e-05,  3.128167211376331e-06, -2.723613499549766e-07,  1.986125901402795e-08, -1.246744946542052e-09,  6.874000941966579e-11, -3.380678507855229e-12,
  1.501249783493949e-13, -6.071366853246376e-15,  2.028872098151812e-03, -8.233502375399331e-04,  1.778011546201055e-04, -2.607555459477495e-05,  2.894417509021981e-06,
 -2.585426189898523e-07,  1.933043889969510e-08, -1.243335965322231e-09,  7.019815359047610e-11, -3.533126908386083e-12,  1.604677709489166e-13, -6.633216326500877e-15,
  1.675080345637108e-03, -6.941975241292755e-04,  1.534142049416477e-04, -2.302711162446462e-05,  2.615140676414322e-06, -2.388843371907770e-07,  1.825542552474238e-08,
 -1.199500721037298e-09,  6.914597107467068e-11, -3.551406212901638e-12,  1.645145670545868e-13, -6.932268799399300e-15,  1.361755258930157e-03, -5.745050676293672e-04,
  1.294955139265851e-04, -1.982719220822110e-05,  2.296324820159952e-06, -2.138317213217566e-07,  1.665071258228260e-08, -1.114298958935111e-09,  6.539309313658312e-11,
 -3.417707115276621e-12,  1.610340221417584e-13, -6.898611917515939e-15,  1.081108984351552e-03, -4.629046627581479e-04,  1.060737705646125e-04, -1.651309308887134e-05,
  1.944126539395760e-06, -1.839711142432289e-07,  1.455262610322586e-08, -9.889629033551944e-10,  5.891387510495480e-11, -3.124403747244541e-12,  1.493270102008305e-13,
 -6.486333709080582e-15,  8.262346397059336e-04, -3.579930926691393e-04,  8.312855376465552e-05, -1.311552198007452e-05,  1.564692070204850e-06, -1.500007065137424e-07,
  1.201714871603483e-08, -8.268526582831063e-10,  4.985678451125975e-11, -2.675492614051667e-12,  1.293535053225230e-13, -5.682039887107384e-15,  5.909391568185956e-04,
 -2.583563334490709e-04,  6.060082953763900e-05, -9.659300605361079e-06,  1.164051012392986e-06, -1.127039451943353e-07,  9.117118611232773e-09, -6.332830462516053e-10,
  3.853981736740381e-11, -2.086927633295326e-12,  1.017897382011757e-13, -4.509694756017449e-15,  3.695969431136389e-04, -1.625892527170798e-04,  3.840397466405246e-05,
 -6.164586774891009e-06,  7.480985357480540e-07, -7.292893666671151e-08,  5.939217915892503e-09, -4.152542469165538e-10,  2.543332963116503e-11, -1.385834433041687e-12,
  6.800678319900563e-14, -3.030868903672233e-15,  1.572388048250869e-04, -6.940822867050568e-05,  1.645784745588355e-05, -2.652158040370709e-06,  3.230988933368277e-07,
 -3.161752413418168e-08,  2.584483630407436e-09, -1.813587571216418e-10,  1.114731897897108e-11, -6.095148204533566e-13,  3.001195349551144e-14, -1.341955389340947e-15,
  7.741188247116360e-02, -2.523324708165429e-04,  8.636394503045433e-07, -3.067128022795803e-09,  1.116507646765781e-11, -4.124353542323672e-14,  1.534714348897329e-16,
 -5.725181153727403e-19,  2.134669315553824e-21, -7.941544250013051e-24,  2.945061330920108e-26, -1.088190483936859e-28,  7.615896646204871e-02, -3.536647826738194e-04,
  1.922329721558093e-06, -1.052677408806125e-08,  5.605057981972622e-11, -2.895979584105747e-13,  1.457795806843307e-15, -7.178898567265989e-18,  3.469534938476480e-20,
 -1.649666128265847e-22,  7.731248644858363e-25, -3.576617455847243e-27,  7.371982023587878e-02, -5.459897523696791e-04,  4.344865426045532e-06, -3.188493990460540e-08,
  2.186687001819221e-10, -1.424737782031303e-12,  8.913134015830972e-15, -5.391692998385690e-17,  3.169539154886292e-19, -1.817526682613444e-21,  1.019659959361335e-23,
 -5.609547520759634e-26,  7.022146908993858e-02, -8.100309068655363e-04,  8.649945876317651e-06, -8.082624613385837e-08,  6.894649707138141e-10, -5.495980361300429e-12,
  4.151945774139985e-14, -3.000775437770399e-16,  2.088988205940347e-18, -1.407885188303454e-20,  9.222255108546735e-23, -5.889627194312476e-25,  6.583947969451986e-02,
 -1.120130224805158e-03,  1.541115434493485e-05, -1.790904667085379e-07,  1.860511841588416e-09, -1.778388632939583e-11,  1.591762836103492e-13, -1.349920650131187e-15,
  1.093879567681484e-17, -8.522858546631500e-20,  6.415865355148945e-22, -4.684045199858597e-24,  6.078232926728453e-02, -1.447511488539962e-03,  2.507312459184206e-05,
 -3.560697248993145e-07,  4.432506131463111e-09, -5.004906514861610e-11,  5.233903757232054e-13, -5.140246150583181e-15,  4.788114965114230e-17, -4.261465112053300e-19,
  3.644367888937074e-21, -3.007936536441015e-23,  5.527398736244751e-02, -1.763710770787202e-03,  3.778965949397412e-05, -6.461754171129678e-07,  9.512362780106102e-09,
 -1.253689660217489e-10,  1.514907624893467e-12, -1.705118540038005e-14,  1.807885468127698e-16, -1.820763346516161e-18,  1.753005006699136e-20, -1.621523620548244e-22,
  4.953682414250402e-02, -2.043648819430509e-03,  5.332322973258214e-05, -1.083698491810633e-06,  1.865491941957623e-08, -2.841004653254727e-10,  3.930127453941139e-12,
 -5.025986511665294e-14,  6.016134402295887e-16, -6.803031617327526e-18,  7.319056493133059e-20, -7.532970894770342e-22,  4.377668970345860e-02, -2.267934842339393e-03,
  7.102773651949444e-05, -1.695870130486436e-06,  3.380068081725330e-08, -5.895918572506043e-10,  9.262388940074438e-12, -1.335755615942428e-13,  1.792411442962084e-15,
 -2.260553767829142e-17,  2.700283348271803e-19, -3.073400622402819e-21,  3.817148838818434e-02, -2.424169583139541e-03,  8.991478651491492e-05, -2.495651151516204e-06,
  5.707975362942309e-08, -1.131401600268954e-09,  2.003993449531056e-11, -3.237363671182211e-13,  4.839476523462838e-15, -6.766972613020830e-17,  8.924371072893581e-19,
 -1.117206156467411e-20,  3.286392576795127e-02, -2.507211879838657e-03,  1.087843130934059e-04, -3.476109122500142e-06,  9.048861750239763e-08, -2.023446799068835e-09,
  4.014459260772679e-11, -7.220712385748527e-13,  1.195694510143504e-14, -1.843781838141536e-16,  2.670971423835451e-18, -3.659763617304383e-20,  2.795846543396796e-02,
 -2.518544094186407e-03,  1.263880352553296e-04, -4.607958957246428e-06,  1.354899658576931e-07, -3.395103719156513e-09,  7.499037174823052e-11, -1.493431367082959e-12,
  2.725146912469697e-14, -4.611417427784839e-16,  7.303662358343886e-18, -1.090466616204202e-19,  2.352200525544976e-02, -2.464987882482241e-03,  1.415911085572515e-04,
 -5.841059396682456e-06,  1.926201936181947e-07, -5.374883625942613e-09,  1.314229063400497e-10, -2.882744731307696e-12,  5.768437166471499e-14, -1.066266136539281e-15,
  1.838355635339016e-17, -2.978420946384674e-19,  1.958743321346932e-02, -2.357070676816996e-03,  1.535026407461272e-04, -7.109657344023509e-06,  2.612001118201440e-07,
 -8.068522580783575e-09,  2.172295030457648e-10, -5.222365735675285e-12,  1.140698788443038e-13, -2.293321169877528e-15,  4.286561126619252e-17, -7.506808288905925e-19,
  1.615906905900863e-02, -2.207330005217793e-03,  1.615566493193359e-04, -8.340282464137031e-06,  3.392266286655488e-07, -1.153541550892078e-08,  3.402304393443617e-10,
 -8.922785082526393e-12,  2.118164692320096e-13, -4.612723182873355e-15,  9.310947907396314e-17, -1.755986270157743e-18,  1.321901773249659e-02, -2.028784474215185e-03,
  1.655377999639085e-04, -9.460666356451613e-06,  4.234817767532742e-07, -1.576850140829176e-08,  5.070379810707279e-10, -1.444118988314913e-11,  3.710263275267805e-13,
 -8.717676840620442e-15,  1.893280025419617e-16, -3.831633989519721e-18,  1.073360618511471e-02, -1.833719050538612e-03,  1.655575246149758e-04, -1.040799484480984e-05,
  5.098441192373565e-07, -2.068246617964295e-08,  7.216845009782726e-10, -2.222694690868036e-11,  6.155753162509892e-13, -1.554657805215547e-14,  3.619696086863919e-16,
 -7.834323311149158e-18,  8.659290285618685e-03, -1.632849118165947e-03,  1.619937041329597e-04, -1.113514434603492e-05,  5.937422164184584e-07, -2.611347712298829e-08,
  9.843940701261666e-10, -3.264933318784315e-11,  9.709410440756477e-13, -2.626140293555499e-14,  6.532426499590941e-16, -1.507057249780762e-17,  6.947650682689164e-03,
 -1.434858007762478e-03,  1.554102894912509e-04, -1.161414349016430e-05,  6.706629127077918e-07, -3.183110166744180e-08,  1.290773739496872e-09, -4.591887670433486e-11,
  1.460820274642005e-12, -4.216517242027415e-14,  1.116782128989833e-15, -2.737502938941464e-17,  5.549306644787908e-03, -1.246254429002943e-03,  1.464725317826125e-04,
 -1.183674495773294e-05,  7.366238553332465e-07, -3.756037899061035e-08,  1.631626366477921e-09, -6.201740826492499e-11,  2.102914554007058e-12, -6.455227325609502e-14,
  1.814507867690790e-15, -4.711010686686871e-17,  4.416741968037701e-03, -1.071470942472998e-03,  1.358701392161299e-04, -1.181252673974653e-05,  7.885372919672700e-07,
 -4.300997131127550e-08,  1.993457301666453e-09, -8.065190859103022e-11,  2.904562346149423e-12, -9.450157120526750e-14,  2.810118701469489e-15, -7.703978042112296e-17,
  3.506148889479204e-03, -9.131189786146075e-04,  1.242561286099239e-04, -1.156527240309359e-05,  8.244228137842904e-07, -4.790140635747443e-08,  2.359600906709680e-09,
 -1.012432354263738e-10,  3.859054568198774e-12, -1.326396796189214e-13,  4.159387286102625e-15, -1.200450992180147e-16,  2.778457581016277e-03, -7.723241871710088e-04,
  1.122046347605468e-04, -1.112848733028937e-05,  8.434604858815900e-07, -5.199472282380775e-08,  2.711770702264865e-09, -1.229539198575662e-10,  4.943425530045811e-12,
 -1.789150358759366e-13,  5.898308856182609e-15, -1.786803234771092e-16,  2.199739831301453e-03, -6.490818934247528e-04,  1.001873056694463e-04, -1.054083110810875e-05,
  8.459043572077066e-07, -5.510708274344726e-08,  3.031768594123427e-09, -1.447513916231592e-10,  6.118264994599778e-12, -2.324279502931362e-13,  8.030963252695058e-15,
 -2.546110345836976e-16,  1.741168047967702e-03, -5.425908895196305e-04,  8.856550841221179e-05, -9.842054140451054e-06,  8.328946775017006e-07, -5.712265264476830e-08,
  3.303084583111619e-09, -1.654963401581319e-10,  7.329715056999270e-12, -2.913554493348358e-13,  1.051941046730764e-14, -3.480179869910241e-16,  1.378686363909921e-03,
 -4.515410132619142e-04,  7.759439182767972e-05, -9.069791458754594e-06,  8.062140529254465e-07, -5.799379037183876e-08,  3.512170031180301e-09, -1.840420035164056e-10,
  8.513401857052460e-12, -3.529938188306883e-13,  1.327787992279075e-14, -4.570796856004680e-16,  1.092518885218852e-03, -3.743439102121614e-04,  6.743466034605028e-05,
 -8.257346099422990e-06,  7.680299926901625e-07, -5.773493499423052e-08,  3.649253507619941e-09, -1.993296111768733e-10,  9.599712420909357e-12, -4.139204068697569e-13,
  1.617291004389182e-14, -5.776520409865256e-16,  8.666076818557517e-04, -3.093063295829204e-04,  5.816837795988132e-05, -7.432423132637368e-06,  7.206571864829840e-07,
 -5.641139561739501e-08,  3.708663048346179e-09, -2.104676281863333e-10,  1.051963551440639e-11, -4.702549726957623e-13,  1.903008664076970e-14, -7.032408721009389e-16,
  6.880440558861839e-04, -2.547514761522985e-04,  4.981592260126352e-05, -6.616666222662193e-06,  6.663610356685276e-07, -5.412546207686065e-08,  3.688700692060273e-09,
 -2.167868162062525e-10,  1.121036782925670e-11, -5.179847037020392e-13,  2.164686726194146e-14, -8.253165164468987e-16,  5.465328556227162e-04, -2.090970277725447e-04,
  4.235209725691173e-05, -5.825797782710491e-06,  6.072124191336935e-07, -5.100203386061445e-08,  3.591171140023689e-09, -2.178681507591273e-10,  1.162002097507317e-11,
 -5.533091041280622e-13,  2.380994186759673e-14, -9.339601708286582e-16,  4.339115742482140e-04, -1.708992940896869e-04,  3.572021066473459e-05, -5.070158354648807e-06,
  5.449943087784760e-07, -4.717545892609756e-08,  3.420692339612533e-09, -2.135451666472405e-10,  1.171099612509210e-11, -5.729619197528144e-13,  2.531488827243283e-14,
 -1.018772796974485e-15,  3.437332144031506e-04, -1.388724517880478e-04,  2.984358359704119e-05, -4.355464781416933e-06,  4.811544748826568e-07, -4.277866619667972e-08,
  3.183915185726594e-09, -2.038855899001053e-10,  1.146185613302332e-11, -5.744755018081074e-13,  2.598564228999828e-14, -1.069932330170994e-15,  2.709135146052643e-04,
 -1.118905041784624e-04,  2.463439361748453e-05, -3.683645343102067e-06,  4.167951106854555e-07, -3.793510057324307e-08,  2.888760142610281e-09, -1.891588612505739e-10,
  1.086776171702161e-11, -5.563655580724457e-13,  2.569150277313713e-14, -1.079261825564831e-15,  2.114380979029090e-04, -8.897805015026602e-05,  2.000005721633401e-05,
 -3.053652115235981e-06,  3.526892236823134e-07, -3.275351013683474e-08,  2.543749356693498e-09, -1.697964613973193e-10,  9.939710700114477e-12, -5.182277929286377e-13,
  2.435991998042633e-14, -1.041172303714511e-15,  1.621224653225756e-04, -6.929440936824535e-05,  1.584749788781092e-05, -2.462189297200817e-06,  2.893143555223332e-07,
 -2.732532480935153e-08,  2.157481598204941e-09, -1.463511597590683e-10,  8.702912135487118e-12, -4.607497576051751e-13,  2.198401326734372e-14, -9.533661117890486e-16,
  1.204167324237598e-04, -5.211430564120300e-05,  1.208570278563731e-05, -1.904327850545281e-06,  2.268959125951281e-07, -2.172420198391268e-08,  1.738269836523959e-09,
 -1.194598802707755e-10,  7.194645692410526e-12, -3.856496645174554e-13,  1.862447627343224e-14, -8.172227907427461e-16,  8.424708266234864e-05, -3.680727026582925e-05,
  8.626975864434166e-06, -1.374002317771911e-06,  1.654547471802948e-07, -1.600729130734516e-08,  1.293942016494455e-09, -8.981333884727782e-11,  5.461925273305775e-12,
 -2.955588065413720e-13,  1.440615536201105e-14, -6.378325416896478e-16,  5.188771999169482e-05, -2.281767582867588e-05,  5.387394161899139e-06, -8.644241810826324e-07,
  1.048584540916829e-07, -1.021807073200815e-08,  8.318132579581771e-10, -5.813552399696133e-11,  3.559304105023131e-12, -1.938701825546686e-13,  9.510275278369683e-15,
 -4.236946492803475e-16,  2.188606539277082e-05, -9.659188358835502e-06,  2.289884499046948e-06, -3.689341736474066e-07,  4.493595776248696e-08, -4.396390246268161e-09,
  3.592965838163001e-10, -2.520751091620891e-11,  1.549085014746314e-12, -8.468446823679545e-14,  4.168979032468202e-15, -1.863764334360692e-16,  7.641614192371540e-02,
 -2.455676018748725e-04,  8.278791743365899e-07, -2.894890953034401e-09,  1.037577923305895e-11, -3.774512437312767e-14,  1.383558482106787e-16, -5.085647056341419e-19,
  1.868873825539252e-21, -6.853883846180330e-24,  2.505987889124143e-26, -9.130645950719880e-29,  7.477428553029053e-02, -3.387766124686954e-04,  1.801204129787795e-06,
 -9.674465672772424e-09,  5.059283575718068e-11, -2.569027920168572e-13,  1.271478199706735e-15, -6.157994167802630e-18,  2.927728103837385e-20, -1.369711012768302e-22,
  6.317435491118496e-25, -2.876726173174228e-27,  7.160303702350083e-02, -5.127039207468354e-04,  3.982334310064280e-06, -2.860306943703502e-08,  1.921964896656882e-10,
 -1.227850307612616e-12,  7.536153343429349e-15, -4.474716554736639e-17,  2.583065664426032e-19, -1.455026140076260e-21,  8.020986675497364e-24, -4.337099084535442e-26,
  6.711385596883147e-02, -7.445314809856985e-04,  7.742760099983183e-06, -7.062274868161567e-08,  5.888665979929189e-10, -4.593229713734727e-12,  3.398175539933046e-14,
 -2.406751252939789e-16,  1.642748179369349e-18, -1.086020922004041e-20,  6.980979957980946e-23, -4.376510398625103e-25,  6.159260681122079e-02, -1.004957017225945e-03,
  1.342957939996430e-05, -1.519723074368966e-07,  1.540167810931044e-09, -1.438034162366812e-11,  1.258509378220828e-13, -1.044394470428474e-15,  8.286822026592297e-18,
 -6.325684484369125e-20,  4.667570895691860e-22, -3.341611484334044e-24,  5.536799909527883e-02, -1.262884068247638e-03,  2.119486031293093e-05, -2.925209685041042e-07,
  3.546318557392831e-09, -3.905491060726457e-11,  3.987944668401643e-13, -3.827774074538495e-15,  3.487340469591550e-17, -3.037637974864508e-19,  2.543840468690733e-21,
 -2.057040166860463e-23,  4.877808624571652e-02, -1.490001039407431e-03,  3.087197994341648e-05, -5.122125042954092e-07,  7.333027336041664e-09, -9.414270165138405e-11,
  1.109503381586971e-12, -1.219220086796207e-14,  1.263135116008827e-16, -1.243932624065545e-18,  1.171827598206817e-20, -1.061166740973323e-22,  4.213967283082713e-02,
 -1.664407133781054e-03,  4.193759555696468e-05, -8.259930164531685e-07,  1.381250270925912e-08, -2.046968782067239e-10,  2.759237724066071e-12, -3.442078600308105e-14,
  4.022824974156449e-16, -4.444992307203386e-18,  4.676019094697828e-20, -4.708751224641584e-22,  3.572439758520551e-02, -1.772744511005506e-03,  5.356894052364205e-05,
 -1.238479758497985e-06,  2.395942507832973e-08, -4.063780354248642e-10,  6.216391157156075e-12, -8.739322539615983e-14,  1.144312545538706e-15, -1.409420785103641e-17,
  1.645402188314177e-19, -1.831486054353761e-21,  2.974362507123653e-02, -1.810680921043585e-03,  6.477683117671024e-05, -1.740060992864691e-06,  3.860878598888465e-08,
 -7.437455734777910e-10,  1.282123198752910e-11, -2.018206137974775e-13,  2.942727937048227e-15, -4.017007279452863e-17,  5.175779994441464e-19, -6.334633515385152e-21,
  2.434252588203083e-02, -1.781944464195237e-03,  7.457493891477702e-05, -2.305862308177386e-06,  5.821660511669231e-08, -1.264823301982712e-09,  2.441602439975495e-11,
 -4.278185857982961e-13,  6.908409482034376e-15, -1.039764024086856e-16,  1.471316655736467e-18, -1.970664906648173e-20,  1.960223916783257e-02, -1.696357822408222e-03,
  8.214058402599110e-05, -2.898171597645584e-06,  8.264931830874936e-08, -2.012120385965265e-09,  4.324067949196273e-11, -8.388407363988606e-13,  1.492591123196020e-14,
 -2.465109473364055e-16,  3.813674728416553e-18, -5.565894273339441e-20,  1.554803870676330e-02, -1.567416027774515e-03,  8.693078991288756e-05, -3.471842234136503e-06,
  1.110700727715853e-07, -3.011713922493176e-09,  7.165836444318083e-11, -1.531322552063659e-12,  2.988338609710330e-14, -5.391908014844056e-16,  9.081627721565645e-18,
 -1.438465476013662e-19,  1.216103991210927e-02, -1.409910219986273e-03,  8.873441638022807e-05, -3.981320191339816e-06,  1.419668826722352e-07, -4.263132310048744e-09,
  1.117260119779418e-10, -2.617600699260415e-12,  5.577582908179861e-14, -1.094884455119728e-15,  1.999818462868236e-17, -3.424812610811382e-19,  9.391116171107635e-03,
 -1.237964014784559e-03,  8.766001778481472e-05, -4.387566818482467e-06,  1.733268723642818e-07, -5.733059327344389e-09,  1.646856912214789e-10, -4.211086254311011e-12,
  9.756411514126305e-14, -2.075416050477705e-15,  4.095461941080954e-17, -7.556309366018196e-19,  7.169173007882020e-03, -1.063675521988846e-03,  8.407385351721236e-05,
 -4.663341876431256e-06,  2.029183960890474e-07, -7.355086716767662e-09,  2.304993569751660e-10, -6.405060445529702e-12,  1.607034940273851e-13, -3.690542443272274e-15,
  7.839850132707774e-17, -1.553074917454998e-18,  5.417565905303584e-03, -8.963964650926439e-04,  7.851012817989163e-05, -4.795920176433538e-06,  2.286142103104056e-07,
 -9.036123940598635e-09,  3.075591937045968e-10, -9.249037090138912e-12,  2.503359357479005e-13, -6.183800429176744e-15,  1.409269413692163e-16, -2.987635675487604e-18,
  4.058077025235344e-03, -7.425619008177400e-04,  7.157592239787369e-05, -4.787073279397837e-06,  2.486827436252521e-07, -1.066822429056415e-08,  3.926704321851210e-10,
 -1.272834002231252e-11,  3.702514121466991e-13, -9.803112947755711e-15,  2.388752001641679e-16, -5.402170981142511e-18,  3.017378081449342e-03, -6.059207099280646e-04,
  6.386837718798238e-05, -4.650797983855982e-06,  2.619900499949617e-07, -1.214317090662343e-08,  4.813338358703259e-10, -1.675255167387378e-11,  5.218246781091269e-13,
 -1.475829487689687e-14,  3.832632159818402e-16, -9.217388683258604e-18,  2.230252824333072e-03, -4.880028585383982e-04,  5.591434776103397e-05, -4.409656150205609e-06,
  2.680839398635289e-07, -1.336662796529310e-08,  5.682757360342714e-10, -2.115662864874300e-11,  7.031838894192145e-13, -2.117233497480431e-14,  5.841172712881941e-16,
 -1.489369655171915e-17,  1.641034156316251e-03, -3.886797336189867e-04,  4.813550754847159e-05, -4.090670888187492e-06,  2.671629084814407e-07, -1.426907282425405e-08,
  6.481119189262391e-10, -2.571533620663807e-11,  9.088397780980179e-13, -2.903677408451278e-14,  8.483826062848173e-16, -2.286582103235801e-17,  1.203759627946377e-03,
 -3.067118003272890e-04,  4.083640956378260e-05, -3.721566322391499e-06,  2.599564798074021e-07, -1.481181693373888e-08,  7.160063860870648e-10, -3.016830368591836e-11,
  1.129903151325450e-12, -3.818215155106131e-14,  1.177817970378220e-15, -3.345682396167045e-17,  8.815088026286936e-04, -2.402192964584372e-04,  3.420991158453325e-05,
 -3.327853486939403e-06,  2.475556617516840e-07, -1.498775554197993e-08,  7.682006040417163e-10, -3.425054340783720e-11,  1.354876706552526e-12, -4.827183942349811e-14,
  1.567345530363717e-15, -4.678597776003534e-17,  6.452988049868518e-04, -1.870474825091405e-04,  2.835344765558421e-05, -2.930962585664476e-06,  2.312324034602631e-07,
 -1.481763811719575e-08,  8.023330556550347e-10, -3.772238759361151e-11,  1.570871219478480e-12, -5.882236310110313e-14,  2.004278979289176e-15, -6.268983992038973e-17,
  4.728130250953524e-04, -1.450238861657080e-04,  2.329024708253739e-05, -2.547377844686669e-06,  2.122786417792697e-07, -1.434335992619150e-08,  8.175249542507367e-10,
 -4.039354784376302e-11,  1.765007436987570e-12, -6.924718758587072e-14,  2.468676952569638e-15, -8.067569058183724e-17,  3.471435627689967e-04, -1.121205718178574e-04,
  1.899103151142466e-05, -2.188579199074642e-06,  1.918833327773822e-07, -1.361997612905499e-08,  8.142584120491154e-10, -4.213792305233632e-11,  1.925744663064263e-12,
 -7.891583079986939e-14,  2.934821128871754e-15, -9.992088966471447e-17,  2.556512529434312e-04, -8.654148721702238e-05,  1.539335245462675e-05, -1.861533761750773e-06,
  1.710538545180936e-07, -1.270792786183152e-08,  7.941066155739802e-10, -4.289814228646011e-11,  2.043921477377303e-12, -8.721744998285117e-14,  3.373574897897033e-15,
 -1.193222249495454e-16,  1.889910517648999e-04, -6.675598467814609e-05,  1.241717251629653e-05, -1.569487428055666e-06,  1.505789218962155e-07, -1.166651954448487e-08,
  7.593879961567795e-10, -4.268093330786124e-11,  2.113380685762006e-12, -9.361820246431641e-14,  3.755208539878775e-15, -1.375887998376565e-16,  1.403135739220673e-04,
 -5.149719345204927e-05,  9.976361039026054e-06, -1.312854517202146e-06,  1.310246357763661e-07, -1.054917517919007e-08,  7.128109582945762e-10, -4.154580440324796e-11,
  2.131149304412846e-12, -9.770423996324047e-14,  4.052219295816353e-15, -1.533634575490888e-16,  1.046318734990043e-04, -3.973999678420017e-05,  7.986442350799895e-06,
 -1.090065670116207e-06,  1.127532274253982e-07, -9.400558879188572e-09,  6.571590473230650e-10, -3.959007795863608e-11,  2.097228632941795e-12, -9.920608716438824e-14,
  4.241729367961166e-15, -1.653532690749938e-16,  7.833188129092239e-05, -3.066923903993313e-05,  6.369265168649203e-06, -8.982936929291621e-07,  9.595452370568253e-08,
 -8.255337806227701e-09,  5.950456814878332e-10, -3.693313667694111e-11,  2.014103406240129e-12, -9.800417735791968e-14,  4.307179807656544e-15, -1.724498626787705e-16,
  5.880142923180510e-05, -2.364516532858733e-05,  5.055352020677119e-06, -7.340243165610355e-07,  8.068205800629410e-08, -7.138204911660968e-09,  5.287483877455356e-10,
 -3.370209657336262e-11,  1.886098866172378e-12, -9.411852282755996e-14,  4.239206123588597e-15, -1.738245532633444e-16,  4.415352339342070e-05, -1.817026088056136e-05,
  3.984632785675750e-06, -5.934711356604780e-07,  6.688815901851027e-08, -6.064739361439705e-09,  4.601181119408904e-10, -3.002028812550487e-11,  1.718705984991131e-12,
 -8.768739177243731e-14,  4.035737116976236e-15, -1.689896450948758e-16,  3.302236943224092e-05, -1.385962833080344e-05,  3.106141872841445e-06, -4.728525830231811e-07,
  5.445463599511553e-08, -5.042724265435480e-09,  3.905506082448498e-10, -2.599913489027347e-11,  1.517968444206713e-12, -7.894040627115535e-14,  3.701470963690827e-15,
 -1.578240241761372e-16,  2.441426123390456e-05, -1.041570250557138e-05,  2.377115071778577e-06, -3.685568727675382e-07,  4.321751758164070e-08, -4.073624864761202e-09,
  3.210035567045680e-10, -2.173340368996365e-11,  1.289991285214764e-12, -6.817094713691999e-14,  3.246939446709329e-15, -1.405666907110873e-16,  1.759903689840710e-05,
 -7.607293220137655e-06,  1.761789138725820e-06, -2.772219789068869e-07,  3.298559864558035e-08, -3.154025463282064e-09,  2.520435538989857e-10, -1.729941263679260e-11,
  1.040599128125725e-12, -5.571158010775939e-14,  2.687376374568454e-15, -1.177853629044834e-16,  1.203100751629830e-05, -5.252515124361663e-06,  1.230099512507121e-06,
 -1.957552015388338e-07,  2.355338136290089e-08, -2.276913812346919e-09,  1.839101624691958e-10, -1.275562396755919e-11,  7.751476157411756e-13, -4.191487074013426e-14,
  2.041575858238596e-15, -9.032867452062235e-17,  7.291071182096698e-06, -3.205044600584477e-06,  7.564080301628456e-07, -1.213155038722027e-07,  1.470978611061742e-08,
 -1.432808614647046e-09,  1.165909611302321e-10, -8.145242093685774e-12,  4.984877820663680e-13, -2.714132861590372e-14,  1.330906147187971e-15, -5.927145563016993e-17,
  3.047693041900813e-06, -1.344816907674311e-06,  3.187453887684229e-07, -5.134345151837268e-08,  6.252247472050699e-09, -6.115686675118474e-10,  4.997008150189914e-11,
 -3.505065872103483e-12,  2.153535576723547e-13, -1.177043426942603e-14,  5.793375817010318e-16, -2.589451908266032e-17,  7.544690148139865e-02, -2.390807572579652e-04,
  7.941122173972250e-07, -2.734742011986989e-09,  9.652962707039851e-12, -3.458892516980775e-14,  1.249175338279403e-16, -4.525227048831400e-19,  1.639249952509156e-21,
 -5.927369944718965e-24,  2.137143013733607e-26, -7.679705290191494e-29,  7.344728201314028e-02, -3.248179725351541e-04,  1.689803113107735e-06, -8.904483515934559e-09,
  4.574649676938641e-11, -2.283549223909217e-13,  1.111462686468270e-15, -5.295376527672928e-18,  2.477226169377722e-20, -1.140601556697445e-22,  5.178434356126512e-25,
 -2.321578709780973e-27,  6.961383627696321e-02, -4.821677206890551e-04,  3.656768666515851e-06, -2.571496429508136e-08,  1.693513033669051e-10, -1.061129913539222e-12,
  6.391500223565941e-15, -3.726107510462539e-17,  2.112689003515302e-19, -1.169308891561120e-21,  6.335386941502004e-24, -3.367793005931441e-26,  6.425446414681185e-02,
 -6.858258251803643e-04,  6.948924303632534e-06, -6.189367645985417e-08,  5.046410078096422e-10, -3.852937127258906e-12,  2.792366243517526e-14, -1.938592474793164e-16,
  1.297727019073901e-18, -8.417857361950163e-21,  5.311278288416034e-23, -3.269481317515244e-25,  5.777666600898094e-02, -9.044169663113616e-04,  1.174478246409436e-05,
 -1.294757967634439e-07,  1.280542899178572e-09, -1.168285263100039e-11,  1.000021592527150e-13, -8.123177954427854e-16,  6.312997198439337e-18, -4.722559734500056e-20,
  3.416552928180948e-22, -2.399175226533893e-24,  5.063463655978299e-02, -1.106457750593222e-03,  1.800086916348705e-05, -2.415429238246966e-07,  2.852860884613720e-09,
 -3.065331698924126e-11,  3.057264990186854e-13, -2.868797532852272e-15,  2.557050829403027e-17, -2.180451996860126e-19,  1.788562169738887e-21, -1.417332619689621e-23,
  4.327574401305158e-02, -1.265751058450917e-03,  2.537165441787527e-05, -4.086084589356170e-07,  5.690998251985935e-09, -7.119280665047549e-11,  8.185737349050186e-13,
 -8.784613317089734e-15,  8.895316832927518e-17, -8.568144556741428e-19,  7.899497373652427e-21, -7.004915885701577e-23,  3.609519172605005e-02, -1.365086323155711e-03,
  3.322739845627928e-05, -6.344497169795771e-07,  1.030965024003123e-08, -1.487217921966159e-10,  1.953978568923235e-12, -2.378404587799970e-14,  2.714697178798756e-16,
 -2.931715207868363e-18,  3.016339447578223e-20, -2.972512852936088e-22,  2.940484580745012e-02, -1.397691928730016e-03,  4.076323043929579e-05, -9.128063952394995e-07,
  1.714513949666965e-08, -2.828379714837708e-10,  4.213973375439705e-12, -5.776576044826531e-14,  7.382307533639213e-16, -8.881792636635109e-18,  1.013579719019351e-19,
 -1.103559437266787e-21,  2.341854741609767e-02, -1.366518298052907e-03,  4.716100391441686e-05, -1.226346522140768e-06,  2.640304440992066e-08, -4.944126191351861e-10,
  8.296808662554170e-12, -1.272839789600291e-13,  1.810582207096333e-15, -2.413267141228041e-17,  3.038385152309285e-19, -3.636209259106094e-21,  1.825275990158482e-02,
 -1.281925643561267e-03,  5.175159950375110e-05, -1.548593873818456e-06,  3.792547408566008e-08, -8.006959179005651e-10,  1.504146039873524e-11, -2.567862287044901e-13,
  4.044185007575427e-15, -5.941756370354326e-17,  8.213997012850946e-19, -1.075567180494076e-20,  1.393891865388839e-02, -1.158592899129281e-03,  5.413181620765365e-05,
 -1.848446209592980e-06,  5.112980541702367e-08, -1.209477427358297e-09,  2.529088693409161e-11, -4.779690333205168e-13,  8.293887113554457e-15, -1.337035658289759e-16,
  2.020637190969365e-18, -2.882927528619335e-20,  1.044270769099789e-02, -1.012443000949910e-03,  5.421075519764110e-05, -2.095994197093380e-06,  6.505134378249706e-08,
 -1.714084288061832e-09,  3.968717900721981e-11, -8.262855501499858e-13,  1.572607744477448e-14, -2.769835600963398e-16,  4.557717891536570e-18, -7.057908744406935e-20,
  7.685598634755505e-03, -8.581671348233712e-04,  5.218538552820544e-05, -2.267969014473992e-06,  7.848752945001434e-08, -2.291089066587088e-09,  5.844571325226127e-11,
 -1.334413875403047e-12,  2.773718652025994e-14, -5.316238060275071e-16,  9.488481075139370e-18, -1.589038839508602e-19,  5.564976074670597e-03, -7.076372220139723e-04,
  4.846442198221599e-05, -2.351403296873320e-06,  9.020634663919388e-08, -2.901895836050872e-09,  8.117750506934276e-11, -2.023696096674453e-12,  4.575535540761154e-14,
 -9.506942424837876e-16,  1.833867488931175e-17, -3.309965183012405e-19,  3.970555258659273e-03, -5.692233865520549e-04,  4.356870095520491e-05, -2.344794956306490e-06,
  9.916143492274713e-08, -3.498131607899870e-09,  1.068257075259665e-10, -2.895696794024053e-12,  7.094035320239350e-14, -1.592093964829539e-15,  3.307761470455594e-17,
 -6.413287638563043e-19,  2.796150109554616e-03, -4.478449210885390e-04,  3.803489317667729e-05, -2.256877792556440e-06,  1.046580670978972e-07, -4.029516688613804e-09,
  1.337516218864922e-10, -3.926526234306812e-12,  1.038420000280168e-13, -2.508427113182421e-15,  5.594519184915804e-17, -1.161515543482837e-18,  1.946900212735879e-03,
 -3.454978466592606e-04,  3.234113174425693e-05, -2.103719264290971e-06,  1.064343920711052e-07, -4.452139575203493e-09,  1.599591044650270e-10, -5.066083285598722e-12,
  1.441094915957454e-13, -3.734194573146180e-15,  8.911569762299588e-17, -1.975136777970020e-18,  1.342711040490177e-03, -2.620034223925450e-04,  2.686257673764967e-05,
 -1.905126851121573e-06,  1.046508253946015e-07, -4.735075035778514e-09,  1.834029502845141e-10, -6.243004068181843e-12,  1.903455936516084e-13, -5.273307747782132e-15,
  1.342364421207975e-16, -3.166580411749975e-18,  9.189293739808559e-04, -1.957768362028528e-04,  2.185584483332055e-05, -1.681262707149284e-06,  9.980572932551111e-08,
 -4.863963995155783e-09,  2.023036473323409e-10, -7.374380825668505e-12,  2.401658467679016e-13, -7.090506645359228e-15,  1.919354458749441e-16, -4.804773610445188e-18,
  6.252649881354779e-04, -1.444898977781140e-04,  1.746556361407296e-05, -1.450067650253542e-06,  9.260995343529512e-08, -4.841176101216777e-09,  2.153948118536499e-10,
 -8.377920629049069e-12,  2.904650439796725e-13, -9.109592881453711e-15,  2.614257464874081e-16, -6.924721192534507e-18,  4.237979537727995e-04, -1.055709280623155e-04,
  1.374427817527203e-05, -1.225736020012556e-06,  8.385464678621515e-08, -4.683101448215253e-09,  2.220558286196540e-10, -9.183646960558941e-12,  3.378334865805234e-13,
 -1.121962708193809e-14,  3.403260753356375e-16, -9.511231186634715e-18,  2.866790290946746e-04, -7.653618140427534e-05,  1.067763927382613e-05, -1.018183718468088e-06,
  7.429903259369881e-08, -4.415687816137485e-09,  2.223182061147212e-10, -9.742625917401234e-12,  3.790260402673193e-13, -1.328802979587402e-14,  4.247675629793970e-16,
 -1.248936295963523e-17,  1.939066738773375e-04, -5.517713074127011e-05,  8.208957486876244e-06, -8.332713433446884e-07,  6.459273845793737e-08, -4.069470856120412e-09,
  2.167663893332751e-10, -1.003126153567820e-11,  4.113800222825513e-13, -1.517767963105721e-14,  5.097806466159992e-16, -1.572476976457849e-17,  1.313835666981806e-04,
 -3.964011661104714e-05,  6.259697976453189e-06, -6.734842072826862e-07,  5.523558972854690e-08, -3.675122922427020e-09,  2.063732399315304e-10, -1.005098915759778e-11,
  4.331018006108596e-13, -1.676423731041215e-14,  5.898826727322664e-16, -1.903464216698538e-17,  8.932851577582448e-05, -2.843500644980685e-05,  4.744604175129111e-06,
 -5.387985084749687e-07,  4.656944121061929e-08, -3.260142252415829e-09,  1.923147288525000e-10, -9.824262888534165e-12,  4.433841632011989e-13, -1.795021925370415e-14,
  6.597398110522886e-16, -2.220725312115258e-17,  6.104163992911010e-05, -2.040329616450191e-05,  3.581580422989901e-06, -4.275354485706073e-07,  3.879250520197428e-08,
 -2.846886016556581e-09,  1.758007248225624e-10, -9.388324981233605e-12,  4.423607047738604e-13, -1.867353780410542e-14,  7.147694502619981e-16, -2.502607364256559e-17,
  4.198033442942738e-05, -1.466776237489776e-05,  2.697235784321161e-06, -3.370869472095645e-07,  3.198609015397181e-08, -2.451830213661185e-09,  1.579448826538698e-10,
 -8.788325159466144e-12,  4.309365019391049e-13, -1.890979949720681e-14,  7.515782554650758e-16, -2.729365800944920e-17,  2.908849024112638e-05, -1.057790898403140e-05,
  2.029249671196237e-06, -2.644657031967284e-07,  2.614537291266092e-08, -2.085758782393894e-09,  1.396821526550766e-10, -8.071055874821606e-12,  4.105499772911951e-13,
 -1.866908038864505e-14,  7.681818880783832e-16, -2.885106564419972e-17,  2.032127843427412e-05, -7.659218535765407e-06,  1.526658900196356e-06, -2.066798261843661e-07,
  2.120846160438068e-08, -1.754531833728986e-09,  1.217310979065795e-10, -7.280083108365879e-12,  3.829198696897392e-13, -1.798882802437722e-14,  7.640064854505432e-16,
 -2.959011753989053e-17,  1.431500475568659e-05, -5.569867235939527e-06,  1.148952148454576e-06, -1.609584074261676e-07,  1.708059986384873e-08, -1.460118824810168e-09,
  1.045915041191932e-10, -6.452561813450748e-12,  3.498189264208523e-13, -1.692486659934144e-14,  7.397142721088069e-16, -2.945767644071449e-17,  1.016128658060623e-05,
 -4.065855838661890e-06,  8.646058712657019e-07, -1.248641131488698e-07,  1.365239899414167e-08, -1.201662274336828e-09,  8.856540736335591e-11, -5.617645776664818e-12,
  3.128989410949427e-13, -1.554230126414943e-14,  6.969184869442206e-16, -2.845282079274082e-17,  7.254438916042246e-06, -2.974033197303256e-06,  6.494691606677596e-07,
 -9.632818950453872e-08,  1.081231232956319e-08, -9.764259718620120e-10,  7.379041322333943e-11, -4.796176438414316e-12,  2.735755930342068e-13, -1.390763156165048e-14,
  6.378561450711459e-16, -2.661888826354670e-17,  5.189248744733725e-06, -2.171833054839132e-06,  4.852294775875120e-07, -7.363733492684646e-08,  8.454260435989821e-09,
 -7.805572663116604e-10,  6.027659829833261e-11, -4.001252424752364e-12,  2.329694612027518e-13, -1.208280436951494e-14,  5.650761612374118e-16, -2.403278953772031e-17,
  3.692897200280402e-06, -1.572375844786149e-06,  3.580693504762620e-07, -5.539432465502317e-08,  6.481547857753154e-09, -6.096472707056399e-10,  4.794118940684299e-11,
 -3.239301342433254e-12,  1.918926117175161e-13, -1.012142210131068e-14,  4.811821052262388e-16, -2.079383961423227e-17,  2.579732308410941e-06, -1.113672286512105e-06,
  2.575475372054270e-07, -4.046713921334681e-08,  4.808162317191815e-09, -4.591056644988576e-10,  3.663785830890285e-11, -2.511352474693230e-12,  1.508677535208898e-13,
 -8.066956601218157e-15,  3.886497040005125e-16, -1.701383516014730e-17,  1.721164787901418e-06, -7.508573612179135e-07,  1.756950829290002e-07, -2.793560607530337e-08,
  3.358364660968047e-09, -3.243829314183754e-10,  2.617953519132162e-11, -1.814308065327944e-12,  1.101679401855315e-13, -5.952627723450505e-15,  2.897237029201408e-16,
 -1.280946292521986e-17,  1.025479523672787e-06, -4.506067937001454e-07,  1.062981393176057e-07, -1.704076094903302e-08,  2.065303221750101e-09, -2.010821464641193e-10,
  1.635541997560220e-11, -1.142131577090537e-12,  6.986921698233260e-14, -3.802642988974851e-15,  1.863926561355447e-16, -8.297707592916281e-18,  4.245971764646263e-07,
 -1.873204385898541e-07,  4.438850293360910e-08, -7.148488586527686e-09,  8.702981959267687e-10, -8.511004479476143e-11,  6.952652607507359e-12, -4.875766289377455e-13,
  2.995065809640999e-14, -1.636650112144084e-15,  8.053886696868340e-17, -3.599098947989656e-18,  7.450308004618127e-02, -2.328565530673349e-04,  7.621996851146107e-07,
 -2.585670148078931e-09,  8.990167908854538e-12, -3.173721588776729e-14,  1.129503422570115e-16, -4.033222682879711e-19,  1.440471778134920e-21, -5.136384760676059e-24,
  1.826555654015258e-26, -6.474510974379445e-29,  7.217438735265763e-02, -3.117148577190058e-04,  1.587194821208909e-06, -8.207675855488596e-09,  4.143458680115905e-11,
 -2.033731438903506e-13,  9.737002095401777e-16, -4.564556488562925e-18,  2.101558952728521e-20, -9.525203495522757e-23,  4.257782426211565e-25, -1.879687924490292e-27,
  6.774178232610824e-02, -4.541033865642204e-04,  3.363772534849915e-06, -2.316713117372005e-08,  1.495819463145386e-10, -9.195268974571327e-13,  5.436842902863861e-15,
 -3.112783932633113e-17,  1.733995907545309e-19, -9.432029803524585e-22,  5.023864947530619e-24, -2.626093312058899e-26,  6.161782606362208e-02, -6.330736935941275e-04,
  6.252215886932114e-06, -5.440124238195952e-08,  4.338673863975491e-10, -3.243479374369694e-12,  2.303419593088255e-14, -1.567971967881272e-16,  1.029696514611090e-18,
 -6.555276988473349e-21,  4.060845405770633e-23, -2.455102173090912e-25,  5.433754384096051e-02, -8.163421846849137e-04,  1.030669656418281e-05, -1.107333057801178e-07,
  1.069155666809165e-09, -9.534393271319203e-12,  7.984757228979624e-14, -6.350596571480484e-16,  4.835395335752996e-18, -3.545786684578033e-20,  2.515720515183298e-22,
 -1.733215814327049e-24,  4.647949937621587e-02, -9.733130115383263e-04,  1.535721811004822e-05, -2.004287487411310e-07,  2.307111260334080e-09, -2.419412201408159e-11,
  2.357674996542643e-13, -2.163461205931750e-15,  1.887131627269456e-17, -1.575764846469114e-19,  1.266380141630217e-21, -9.836795571561193e-24,  3.858968293613341e-02,
 -1.080944748620153e-03,  2.097094381580878e-05, -3.279541031197678e-07,  4.445225210169373e-09, -5.420347362042744e-11,  6.082207100407539e-13, -6.376210092744263e-15,
  6.312351176473671e-17, -5.948503952112470e-19,  5.368760118594694e-21, -4.662985339404364e-23,  3.112194706023802e-02, -1.127127056576325e-03,  2.651324677225659e-05,
 -4.909527471367128e-07,  7.754914833785342e-09, -1.089258988610042e-10,  1.395300209590481e-12, -1.657620471107129e-14,  1.848234928824659e-16, -1.951298242035094e-18,
  1.963974326876567e-20, -1.894476624593121e-22,  2.440297528003044e-02, -1.111134074717217e-03,  3.128521912398547e-05, -6.787486476442804e-07,  1.238135807008050e-08,
 -1.987121159122861e-10,  2.884264154976112e-12, -3.856186020046403e-14,  4.810984688355510e-16, -5.655221030865126e-18,  6.309903885371722e-20, -6.721286591056670e-22,
  1.862307765562344e-02, -1.041600059253783e-03,  3.468522306053351e-05, -8.732882609386718e-07,  1.824805794758451e-08, -3.322355974280301e-10,  5.428461625626802e-12,
 -8.118112520343283e-14,  1.126792508184067e-15, -1.466716071350642e-17,  1.804778964961601e-19, -2.112335040201401e-21,  1.384849547279724e-02, -9.330304008531151e-04,
  3.633829711239720e-05, -1.052488332092789e-06,  2.500706312116378e-08, -5.131280131647883e-10,  9.382030287523286e-12, -1.560790272558195e-13,  2.397787791277165e-15,
 -3.439415307495651e-17,  4.645713737775029e-19, -5.947964366638115e-21,  1.004762901137320e-02, -8.020012034471531e-04,  3.615624846752040e-05, -1.194969024385610e-06,
  3.206400864425498e-08, -7.370487011871321e-10,  1.499812780864638e-11, -2.761644163803236e-13,  4.673776622540249e-15, -7.355044500706547e-17,  1.085948930899346e-18,
 -1.514772033492704e-20,  7.122937332043390e-03, -6.639751672633875e-04,  3.432083167433499e-05, -1.284624001664456e-06,  3.867949632909265e-08, -9.904497804489532e-10,
  2.231697433814251e-11, -4.527064425310545e-13,  8.403409336780710e-15, -1.444877161279541e-16,  2.322825038107997e-18, -3.516870517185789e-20,  4.941633204515447e-03,
 -5.312417145346561e-04,  3.120850217083878e-05, -1.313631938636861e-06,  4.411813006555254e-08, -1.251825609480011e-09,  3.108359369522624e-11, -6.915962775325857e-13,
  1.402330096058632e-14, -2.624275178632633e-16,  4.576876204301701e-18, -7.495414336576846e-20,  3.360737730594006e-03, -4.120610515115713e-04,  2.728876630143606e-05,
 -1.283198905396840e-06,  4.779856101557445e-08, -1.495335165354633e-09,  4.073233219502064e-11, -9.898915216726545e-13,  2.184015115921253e-14, -4.432118374554478e-16,
  8.356840262209824e-18, -1.475438585751124e-19,  2.244617252124160e-03, -3.107843866395224e-04,  2.302759331349827e-05, -1.202162604996744e-06,  4.939985527864187e-08,
 -1.695782608018530e-09,  5.045462456928482e-11, -1.333957858106634e-12,  3.190548352494156e-14, -6.996799221896479e-16,  1.421554986611296e-17, -2.697271156168524e-19,
  1.475149458048144e-03, -2.285820806088063e-04,  1.881708615512943e-05, -1.084218760756961e-06,  4.889845877817922e-08, -1.833460502066266e-09,  5.933660323927394e-11,
 -1.700149624778928e-12,  4.392471577769317e-14, -1.037427279170607e-15,  2.263963523987492e-17, -4.602468322080074e-19,  9.558877316116679e-04, -1.644154780727679e-04,
  1.493920644108995e-05, -9.447574287501232e-07,  4.653558998150722e-08, -1.897491511904556e-09,  6.652782622519006e-11, -2.058138828814468e-12,  5.723814320396341e-14,
 -1.451202460243628e-15,  3.391104705527507e-17, -7.364431967526717e-19,  6.120551273019518e-04, -1.159789957409975e-04,  1.156023674631855e-05, -7.981482279458033e-07,
  4.273570056525370e-08, -1.886925984866509e-09,  7.139285591815656e-11, -2.376073649857575e-12,  7.089046059837563e-14, -1.923253629126692e-15,  4.797727099884363e-17,
 -1.109825738699010e-18,  3.881164657374840e-04, -8.045702380387125e-05,  8.746468668547236e-06, -6.559525657773260e-07,  3.800597559595040e-08, -1.809640183137641e-09,
  7.360648636888497e-11, -2.626136179256778e-12,  8.377600671469216e-14, -2.424446899936202e-15,  6.437308468350481e-17, -1.581647601665528e-18,  2.443034140084856e-04,
 -5.504331591377778e-05,  6.490288474448212e-06, -5.261568066808628e-07,  3.284436735071258e-08, -1.679700819657559e-09,  7.317511928056271e-11, -2.789016207079872e-12,
  9.482178030253427e-14, -2.918112498583425e-15,  8.222597428774326e-17, -2.139830353192139e-18,  1.530121739595201e-04, -3.723958691174375e-05,  4.737797594628804e-06,
 -4.132430767229703e-07,  2.767367782698267e-08, -1.514129498648220e-09,  7.039071126124966e-11, -2.856287175048175e-12,  1.031597882514779e-13, -3.365695114287257e-15,
  1.003528874228258e-16, -2.758366514039041e-18,  9.558716435453319e-05, -2.498389049166916e-05,  3.412418004407938e-06, -3.187883218205028e-07,  2.280738968362675e-08,
 -1.329916866612967e-09,  6.574070631965312e-11, -2.830406576889187e-12,  1.082473405224306e-13, -3.732752998631775e-15,  1.174276270344876e-16, -3.399650555692455e-18,
  5.970373641772745e-05, -1.666670867528676e-05,  2.432113463621702e-06, -2.422843047721754e-07,  1.844361517459147e-08, -1.141832605777395e-09,  5.980323818442228e-11,
 -2.722750017390042e-12,  1.099135455101495e-13, -3.993848148301176e-15,  1.321773644356439e-16, -4.019315594009841e-18,  3.737413768274869e-05, -1.108477893042950e-05,
  1.720146668666920e-06, -1.819476864822523e-07,  1.467854963609868e-08, -9.612207050993746e-10,  5.315276747037702e-11, -2.550500913399574e-12,  1.083332948284755e-13,
 -4.135334818371358e-15,  1.435609387078935e-16, -4.572427748353366e-18,  2.350270549329502e-05, -7.368894931152597e-06,  1.210539862397670e-06, -1.353874626843988e-07,
  1.152989874286472e-08, -7.956855272624707e-10,  4.629155147182173e-11, -2.333292305223118e-12,  1.039479234018013e-13, -4.155746951613535e-15,  1.508912602592644e-16,
 -5.019575452606537e-18,  1.487982342362024e-05, -4.908217439996946e-06,  8.498166057903050e-07, -1.000817773010784e-07,  8.962474318075935e-09, -6.494175929277859e-10,
  3.961173440092496e-11, -2.090308015274812e-12,  9.735996629080685e-14, -4.064129808765382e-15,  1.538835645638378e-16, -5.331555640419278e-18,  9.503529645128027e-06,
 -3.282834958633539e-06,  5.964949046870050e-07, -7.367269790703055e-08,  6.910934408037930e-09, -5.238717407888765e-10,  3.338473598845800e-11, -1.838237251835623e-12,
  8.922814022743248e-14, -3.877063746156150e-15,  1.526322441955279e-16, -5.491877184966406e-18,  6.133845462437399e-06, -2.209065439038295e-06,  4.194623633710785e-07,
 -5.411588014297635e-08,  5.297309850747977e-09, -4.185543507954029e-10,  2.777028632686469e-11, -1.590170987920941e-12,  8.018113321598681e-14, -3.615231176359892e-15,
  1.475346427392015e-16, -5.496943244495098e-18,  4.006106531938413e-06, -1.497801968109696e-06,  2.959848564541877e-07, -3.972946957892536e-08,  4.042920597661515e-09,
 -3.317550724102040e-10,  2.283653895031988e-11, -1.355310354265195e-12,  7.075916250295393e-14, -3.300239596030839e-15,  1.391872547667581e-16, -5.354316395219212e-18,
  2.649649856530608e-06, -1.024204161640007e-06,  2.097804967437068e-07, -2.918190485918969e-08,  3.075419778723270e-09, -2.611375067866606e-10,  1.858400579408760e-11,
 -1.139249763874037e-12,  6.138386545448499e-14, -2.952149268832869e-15,  1.282787045844397e-16, -5.079781575565281e-18,  1.774628483695373e-06, -7.063855395384249e-07,
  1.493624727794318e-07, -2.144864635645252e-08,  2.332159653488432e-09, -2.041641252795242e-10,  1.496832220843889e-11, -9.445827190048921e-13,  5.235160688285826e-14,
 -2.587876349517006e-15,  1.154974955797362e-16, -4.693980705619373e-18,  1.202038836188111e-06, -4.908108191257670e-07,  1.067121584451173e-07, -1.575778266530994e-08,
  1.761089121209891e-09, -1.583683915035748e-10,  1.191912264013198e-11, -7.716209212029545e-13,  4.384291862980237e-14, -2.220425566417656e-15,  1.014642515013063e-16,
 -4.219260935555095e-18,  8.207480143858412e-07, -3.424845607990059e-07,  7.626723301889846e-08, -1.153615768242501e-08,  1.320185698147462e-09, -1.215046846575553e-10,
  9.354083484097434e-12, -6.190828638559910e-13,  3.594081795627256e-14, -1.858779758060067e-15,  8.669071895415712e-17, -3.677151664149359e-18,  5.611985768994501e-07,
 -2.384519925264737e-07,  5.417608355667687e-08, -8.361737960330264e-09,  9.761497412942317e-10, -9.161041424263120e-11,  7.188326706798738e-12, -4.846721229740325e-13,
  2.865216468190055e-14, -1.508230104576186e-15,  7.156262030391371e-17, -3.086651523690646e-18,  3.793266007108135e-07, -1.635331950405991e-07,  3.776133370132166e-08,
 -5.924191299319818e-09,  7.028321815528757e-10, -6.701081294854279e-11,  5.339952350513753e-12, -3.655155661727116e-13,  2.192811859853749e-14, -1.170946426648272e-15,
  5.634083569020711e-17, -2.463322343138346e-18,  2.466931356524281e-07, -1.075334723647423e-07,  2.513940877334944e-08, -3.993548468143615e-09,  4.796659623298554e-10,
 -4.628995729895466e-11,  3.732647779635925e-12, -2.584647381655005e-13,  1.568157332194483e-14, -8.466347772661860e-16,  4.117494846518182e-17, -1.819076840045880e-18,
  1.443747041111748e-07, -6.341345408002471e-08,  1.495222413651230e-08, -2.395867611954060e-09,  2.902372563139863e-10, -2.824500543995593e-11,  2.296320703134341e-12,
 -1.602853249534389e-13,  9.801091171157600e-15, -5.331987991393510e-16,  2.612471307953694e-17, -1.162530861649282e-18,  5.918238534297351e-08, -2.610439498333002e-08,
  6.184436659388361e-09, -9.957332729485187e-10,  1.211982178058335e-10, -1.184975319839016e-11,  9.677889011439147e-13, -6.785408958815562e-14,  4.167197012440329e-15,
 -2.276667024544855e-16,  1.120099717183299e-17, -5.004425258813804e-19,  7.358365590774821e-02, -2.268806697301969e-04,  7.320142197263664e-07, -2.446761876889334e-09,
  8.381643150767657e-12, -2.915688115954696e-14,  1.022758259740993e-16, -3.600501037378825e-19,  1.268054920402306e-21, -4.459651207680688e-24,  1.564417261744126e-26,
 -5.470949468899302e-29,  7.095231476901222e-02, -2.994002984711026e-04,  1.492550202382355e-06, -7.576034591461354e-09,  3.759083926891658e-11, -1.814650922966890e-13,
  8.548146387757821e-16, -3.943790884942382e-18,  1.787415315695898e-20, -7.976539636695167e-23,  3.511221388377010e-25, -1.526742510396953e-27,  6.597748409145632e-02,
 -4.282658953390789e-04,  3.099542121691740e-06, -2.091414013810256e-08,  1.324287649509175e-10, -7.989046508880248e-13,  4.638105766086799e-15, -2.608570411508626e-17,
  1.427994623728888e-19, -7.635714397100716e-22,  3.999180302092557e-24, -2.056080435355335e-26,  5.918159259125694e-02, -5.855539562950171e-04,  5.639004924269372e-06,
 -4.794971271588888e-08,  3.741887467407099e-10, -2.739826495448488e-12,  1.907181977688506e-14, -1.273292137759912e-16,  8.205170852512367e-19, -5.127942509214340e-21,
  3.119627738886746e-23, -1.852815096362134e-25,  5.122905878185764e-02, -7.389268451049822e-04,  9.074564621868433e-06, -9.505394244822550e-08,  8.962765036950780e-10,
 -7.815060346313786e-12,  6.405328951582837e-14, -4.989484880952511e-16,  3.723062563128338e-18, -2.676911005367517e-20,  1.863084553246450e-22, -1.259635767252587e-24,
  4.281757007772908e-02, -8.594831874687034e-04,  1.315853010710762e-05, -1.670980195915327e-07,  1.875237922891864e-09, -1.919929826429639e-11,  1.828572207676900e-13,
 -1.641354534308772e-15,  1.401488321683938e-17, -1.146240073022477e-19,  9.027622518585527e-22, -6.875278094271338e-24,  3.457811901593628e-02, -9.277874157449374e-04,
  1.742887453281444e-05, -2.647667702941770e-07,  3.493768242591168e-09, -4.153872743251003e-11,  4.550206100017451e-13, -4.661149837461707e-15,  4.512621862483436e-17,
 -4.161488464922019e-19,  3.677691975049576e-21, -3.129350342587634e-23,  2.700311196359997e-02, -9.366319611660822e-04,  2.129988433763475e-05, -3.826293447921078e-07,
  5.876871135289058e-09, -8.039984203956467e-11,  1.004400334257282e-12, -1.164911158146302e-14,  1.269147809094622e-16, -1.310238017535513e-18,  1.290376684262948e-20,
 -1.218640701606547e-22,  2.041180251300470e-02, -8.903438376956316e-04,  2.420894620216705e-05, -5.090178359959287e-07,  9.020132455750544e-09, -1.408789407776689e-10,
  1.992622517764318e-12, -2.598950942954685e-14,  3.166131193366157e-16, -3.637031682877266e-18,  3.968505063769280e-20, -4.136517631447010e-22,  1.495166611859480e-02,
 -8.015352072415411e-04,  2.575928388867136e-05, -6.281036476308312e-07,  1.274121305545209e-08, -2.255971287530610e-10,  3.589785502513631e-12, -5.234235551110049e-14,
  7.090436547468883e-16, -9.015134662992365e-18,  1.084348462848222e-19, -1.241408070621722e-21,  1.062646374263927e-02, -6.867488034322020e-04,  2.580636636611896e-05,
 -7.235850050675629e-07,  1.668258702484195e-08, -3.327589305076559e-10,  5.922766223570475e-12, -9.603081617326160e-14,  1.439305242398047e-15, -2.015963882750921e-17,
  2.660978353260520e-19, -3.331574035758486e-21,  7.338287557952148e-03, -5.623934866524413e-04,  2.446515042526342e-05, -7.826687739336873e-07,  2.037420187142196e-08,
 -4.551607603006096e-10,  9.014298529419160e-12, -1.617366173262955e-13,  2.669928022443807e-15, -4.102006795217606e-17,  5.917576589606285e-19, -8.070795962396377e-21,
  4.931621101588277e-03, -4.418854296772050e-04,  2.204856292285396e-05, -7.989415669508027e-07,  2.333859844421810e-08, -5.807979285551839e-10,  1.273616118379934e-11,
 -2.517376473049936e-13,  4.557873738522317e-15, -7.650774203996359e-17,  1.201732227961809e-18, -1.779024143476320e-20,  3.230894921013698e-03, -3.342966695959003e-04,
  1.896933680293622e-05, -7.732731929478195e-07,  2.520229837062173e-08, -6.950969438297273e-10,  1.679993964484156e-11, -3.642619385412971e-13,  7.205094801248841e-15,
 -1.316494323459676e-16,  2.243619940124370e-18, -3.593078961090633e-20,  2.067332486862750e-03, -2.443126936757849e-04,  1.564147408855396e-05, -7.127319515983155e-07,
  2.577561859751442e-08, -7.841052046647892e-10,  2.079656570985997e-11, -4.926664846573584e-13,  1.060644305703423e-14, -2.102139065303017e-16,  3.874147494687224e-18,
 -6.690513100397518e-20,  1.294598558791548e-03, -1.730363697124956e-04,  1.240764915477186e-05, -6.281845890413460e-07,  2.507801667441349e-08, -8.375696026995493e-10,
  2.427637684389744e-11, -6.259448240216750e-13,  1.461483419002721e-14, -3.131421598204224e-16,  6.221021187011666e-18, -1.155036193432518e-19,  7.951441154909992e-04,
 -1.191417884603375e-04,  9.503067694696373e-06, -5.315375776054151e-07,  2.330847419096999e-08, -8.509203167619924e-10,  2.684466127958674e-11, -7.505816305389825e-13,
  1.894101701894449e-14, -4.373236140001416e-16,  9.336825607937252e-18, -1.858302001548553e-19,  4.801258046823474e-04, -7.999711575638631e-05,  7.052445942570135e-06,
 -4.334415130209580e-07,  2.077903486599597e-08, -8.256623486101706e-10,  2.824199782546395e-11, -8.532369732687649e-13,  2.319385762846211e-14, -5.752556603558735e-16,
  1.315957287546797e-17, -2.799691323054435e-19,  2.857171202809995e-04, -5.254346005327221e-05,  5.089015949610912e-06, -3.419030968386283e-07,  1.783742131953849e-08,
 -7.682898994182310e-10,  2.838617806290046e-11, -9.234238709277676e-13,  2.695173455907164e-14, -7.158621931132012e-16,  1.749568290508182e-17, -3.967751545832072e-19,
  1.680041266217321e-04, -3.386553710355195e-05,  3.583025193744517e-06, -2.618489868267473e-07,  1.480132291432519e-08, -6.882925739274139e-10,  2.736824518355283e-11,
 -9.553825674717139e-13,  2.984385596379230e-14, -8.463317829615611e-16,  2.203524304190845e-17, -5.312364309374796e-19,  9.787861623572688e-05, -2.148656328959928e-05,
  2.469933967520327e-06, -1.954131444764924e-07,  1.191702091958976e-08, -5.959700420484307e-10,  2.541112812381075e-11, -9.487019565814309e-13,  3.161746633404943e-14,
 -9.544614386061576e-16,  2.639844258705295e-17, -6.747238787096672e-19,  5.665854268966438e-05, -1.346276399305672e-05,  1.672759547783940e-06, -1.426182331752846e-07,
  9.344261679773116e-09, -5.006381161461889e-10,  2.280898552466104e-11, -9.077013134124034e-13,  3.217354973273879e-14, -1.030828681434147e-15,  3.020102398231417e-17,
 -8.161545571734051e-19,  3.268228018001658e-05, -8.357157391548780e-06,  1.116816952033447e-06, -1.021554147876248e-07,  7.161740135463122e-09, -4.095282495781302e-10,
  1.986654132776527e-11, -8.399557621865827e-13,  3.156573933271381e-14, -1.070218879094155e-15,  3.312039764944583e-17, -9.437845240661677e-19,  1.884126909707738e-05,
 -5.156339412065805e-06,  7.375768548586416e-07, -7.206730444384400e-08,  5.384501907572407e-09, -3.274017766038146e-10,  1.685235690922895e-11, -7.545063789199283e-13,
  2.996893661123617e-14, -1.072031126674768e-15,  3.494505023685664e-17, -1.047144846715617e-18,  1.088796069300252e-05, -3.172309207317911e-06,  4.834648721361831e-07,
 -5.024596685347563e-08,  3.985161188900493e-09, -2.567136582069865e-10,  1.397206039715041e-11, -6.602400925666212e-13,  2.763124473036070e-14, -1.039726605164758e-15,
  3.559681262406063e-17, -1.118620113241512e-18,  6.325514753965525e-06, -1.952215233684128e-06,  3.155547448528675e-07, -3.473776142949410e-08,  2.913327185013614e-09,
 -1.980913296716884e-10,  1.136057830671770e-11, -5.647390733183635e-13,  2.482388090843129e-14, -9.796327647391395e-16,  3.512483401472060e-17, -1.154326453419901e-18,
  3.705051484715625e-06, -1.205361404733579e-06,  2.057310190732271e-07, -2.389065250759140e-08,  2.110453055928005e-09, -1.509154896224505e-10,  9.088257877725482e-12,
 -4.736883252184586e-13,  2.180013948428304e-14, -8.995095153444942e-16,  3.367788997798569e-17, -1.154189831375666e-18,  2.193853963179871e-06, -7.488342954572902e-07,
  1.343748493629421e-07, -1.639366984265271e-08,  1.519528008725069e-09, -1.138561538763067e-10,  7.174581283236033e-12, -3.907693681427723e-13,  1.876889070976272e-14,
 -8.072327304898989e-16,  3.146561292561580e-17, -1.121351790556492e-18,  1.316408536142132e-06, -4.693064823773607e-07,  8.816231535863338e-08, -1.125416350177874e-08,
  1.090329790304959e-09, -8.529006142002577e-11,  5.604062379891784e-12, -3.178863886442776e-13,  1.588294717328672e-14, -7.098168254410073e-16,  2.871912301363456e-17,
 -1.061166833330786e-18,  8.021026662045194e-07, -2.973584655166518e-07,  5.823313205238934e-08, -7.746816731665388e-09,  7.814593807821626e-10, -6.358212945021260e-11,
  4.340729212516810e-12, -2.555603431256844e-13,  1.323927394155964e-14, -6.128506529905178e-16,  2.565863246720759e-17, -9.800834924819339e-19,  4.970110383537471e-07,
 -1.907903840374259e-07,  3.878818111347083e-08, -5.355887406161941e-09,  5.603707785495146e-10, -4.724736082834954e-11,  3.339429970733195e-12, -2.033591922559388e-13,
  1.088669792479794e-14, -5.203073611117293e-16,  2.247169072546820e-17, -8.846441710058522e-19,  3.133837361937910e-07, -1.240558048664100e-07,  2.607471665764781e-08,
 -3.722106050551276e-09,  4.023555869474682e-10, -3.502346433210400e-11,  2.553579264451322e-12, -1.602808490002533e-13,  8.836997841648570e-15, -4.346275051975214e-16,
  1.930229695643135e-17, -7.807413224908685e-19,  2.009511584384031e-07, -8.170363592832851e-08,  1.768168817272214e-08, -2.598892270526656e-09,  2.891315831304204e-10,
 -2.588525569410245e-11,  1.939769414852643e-12, -1.250501805925718e-13,  7.076300424053738e-15, -3.569605642095494e-16,  1.624888500506964e-17, -6.731707721902298e-19,
  1.306982837166858e-07, -5.436711319914675e-08,  1.206507346672304e-08, -1.818639936425793e-09,  2.074150133170824e-10, -1.902623341635119e-11,  1.460002449101177e-12,
 -9.632349222158854e-14,  5.574946434225533e-15, -2.874666085677543e-16,  1.336827084203174e-17, -5.654522416109193e-19,  8.570385568305992e-08, -3.633521631616379e-08,
  8.235186630669409e-09, -1.267934313875729e-09,  1.476617453965371e-10, -1.382520242974507e-11,  1.082319773313820e-12, -7.281210685356241e-14,  4.295040622214647e-15,
 -2.256096950666280e-16,  1.068272643377178e-17, -4.598500930345275e-19,  5.596011514490493e-08, -2.409057732765983e-08,  5.553833397236217e-09, -8.699097095564226e-10,
  1.030401460062179e-10, -9.808989231629412e-12,  7.804727819344787e-13, -5.334383316306207e-14,  3.195616202576002e-15, -1.704048106300778e-16,  8.187965517425098e-18,
 -3.575192061048228e-19,  3.542822484611678e-08, -1.543008390702164e-08,  3.603856779763966e-09, -5.719465611697719e-10,  6.863168301927485e-11, -6.617133671995921e-12,
  5.330975622333246e-13, -3.688137204515103e-14,  2.235738691427789e-15, -1.206042474504848e-16,  5.860624748174021e-18, -2.587118301061364e-19,  2.034719347735960e-08,
 -8.933165217534147e-09,  2.105310610805626e-09, -3.371761305491126e-10,  4.082561943534613e-11, -3.971096694397923e-12,  3.226968069272559e-13, -2.251404791467058e-14,
  1.376056840925453e-15, -7.482687778828141e-17,  3.664635951262963e-18, -1.630044394170579e-19,  8.253246980850242e-09, -3.639618953076766e-09,  8.620650249288887e-10,
 -1.387645139405886e-10,  1.688602435754201e-11, -1.650582770364379e-12,  1.347742203192182e-13, -9.447173878861201e-15,  5.800576542326146e-16, -3.168323133172483e-17,
  1.558443388657631e-18, -6.961370991964676e-20,  7.268766266363211e-02, -2.211397642042070e-04,  7.034388942465936e-07, -2.317190666826239e-09,  7.822258215437444e-12,
 -2.681879702603531e-14,  9.273921059642900e-17, -3.219248845790537e-19,  1.118214789900878e-21, -3.879453367970148e-24,  1.342669753956119e-26, -4.633260442812664e-29,
  6.977803267986400e-02, -2.878135905708952e-04,  1.405130251771815e-06, -7.002537314759220e-09,  3.415807153412840e-11, -1.622125813232687e-13,  7.519830153933417e-16,
 -3.415178242110843e-18,  1.524002490304963e-20, -6.697625387088837e-23,  2.903933377788162e-25, -1.243899762252475e-27,  6.431247300907560e-02, -4.044385927054265e-04,
  2.860777258892510e-06, -1.891729591383355e-08,  1.175072196771407e-10, -6.958628841116470e-13,  3.967758042723574e-15, -2.192675024367998e-17,  1.179849676722596e-19,
 -6.203202552116469e-22,  3.195384252640804e-24, -1.616158194852091e-26,  5.692609506101133e-02, -5.426457325405563e-04,  5.097799577055014e-06, -4.237735625186477e-08,
  3.236953110384312e-10, -2.322080790994661e-12,  1.584806998612644e-14, -1.038006069900312e-16,  6.565382869935899e-19, -4.028997782151350e-21,  2.407658614061302e-23,
 -1.405080272906205e-25,  4.841164950050719e-02, -6.706604890275230e-04,  8.015060058616970e-06, -8.188492125626125e-08,  7.542824480454673e-10, -6.432807081238930e-12,
  5.161544877295906e-14, -3.938929732243989e-16,  2.881157816906977e-18, -2.031728632771449e-20,  1.387461386054785e-22, -9.207872905844916e-25,  3.957815783712799e-02,
 -7.617532946406236e-04,  1.132143696274196e-05, -1.399424151691781e-07,  1.531661691237539e-09, -1.531511985215578e-11,  1.426040769172113e-13, -1.252483767937688e-15,
  1.047156836759910e-17, -8.390886658109151e-20,  6.477972905429437e-22, -4.838239434725636e-24,  3.112697203520238e-02, -8.001744123937719e-04,  1.456146694108574e-05,
 -2.149609341582906e-07,  2.762415222465330e-09, -3.203409332070445e-11,  3.426605896333145e-13, -3.430911148066407e-15,  3.249145038398282e-17, -2.932937609361324e-19,
  2.538608563801681e-21, -2.116726078779652e-23,  2.357040812076213e-02, -7.831148034342387e-04,  1.722340622830220e-05, -3.002568114359818e-07,  4.485709206962490e-09,
 -5.978967729415079e-11,  7.286458047675111e-13, -8.252539026893764e-15,  8.787490989672762e-17, -8.873184881506978e-19,  8.552640214597228e-21, -7.909713263470892e-23,
  1.720228621653666e-02, -7.188500524548552e-04,  1.888147199078224e-05, -3.848662384295378e-07,  6.627279542583034e-09, -1.007544523928378e-10,  1.389069352925267e-12,
 -1.767883551751743e-14,  2.103489891539157e-16, -2.361876992533344e-18,  2.520781995860689e-20, -2.571630609569525e-22,  1.211441398589465e-02, -6.224590953038809e-04,
  1.931020740629627e-05, -4.561144369810909e-07,  8.984185659964310e-09, -1.547378049861721e-10,  2.398462755674354e-12, -3.410491105586596e-14,  4.509783087582595e-16,
 -5.601907052786825e-18,  6.587656929370039e-20, -7.378351475227255e-22,  8.243175288608977e-03, -5.109520912578829e-04,  1.852798159644514e-05, -5.030102516698254e-07,
  1.125537278971668e-08, -2.182780385811001e-10,  3.782744921774839e-12, -5.978700121391106e-14,  8.743739226630761e-16, -1.196056327161254e-17,  1.543001127542057e-19,
 -1.889419591049703e-21,  5.427672396421289e-03, -3.993210717345692e-04,  1.676289471205063e-05, -5.191346553414711e-07,  1.311224887342684e-08, -2.847234998664193e-10,
  5.488743343520069e-12, -9.597322431774352e-14,  1.545557945813920e-15, -2.318527839326810e-17,  3.268372067246316e-19, -4.358972554120016e-21,  3.464057657719448e-03,
 -2.982837327093510e-04,  1.436634099892821e-05, -5.039733439754864e-07,  1.428385186281744e-08, -3.454802596576541e-10,  7.373587232311404e-12, -1.420197641663060e-13,
  2.508244199160956e-15, -4.110656158558841e-17,  6.308982568710355e-19, -9.132611593841255e-21,  2.146893931591933e-03, -2.137337720726366e-04,  1.171322010712371e-05,
 -4.623944056510947e-07,  1.462429582571016e-08, -3.920655838264178e-10,  9.223606607983893e-12, -1.948941142831223e-13,  3.760635620657528e-15, -6.709177504765214e-17,
  1.117321929120443e-18, -1.749823086822467e-20,  1.294700714324699e-03, -1.474174825981379e-04,  9.122154924122808e-06, -4.027404170349133e-07,  1.413934284292322e-08,
 -4.182211965377048e-10,  1.079982499624943e-11, -2.493861144184069e-13,  5.238674886064918e-15, -1.013991654355713e-16,  1.826497879095366e-18, -3.085268407380549e-20,
  7.614120192314090e-04, -9.820039243725186e-05,  6.812417430367545e-06, -3.344175771177195e-07,  1.296777538439014e-08, -4.213240856172612e-10,  1.189487429232895e-11,
 -2.990731491758807e-13,  6.815980175148595e-15, -1.426759747117366e-16,  2.771342413166453e-18, -5.034560528046857e-20,  4.377229092939192e-04, -6.338816510394665e-05,
  4.897096036001283e-06, -2.658209261320955e-07,  1.133095716857237e-08, -4.026711812163104e-10,  1.238106018378791e-11, -3.377544316401672e-13,  8.323827953065848e-15,
 -1.878498709649555e-16,  3.923125080490896e-18, -7.643415298654154e-20,  2.466180816673214e-04, -3.978153700916202e-05,  3.401259259911619e-06, -2.030828915411182e-07,
  9.472503349173596e-09, -3.666961197041053e-10,  1.223381604516787e-11, -3.608618265869182e-13,  9.586171333899235e-15, -2.325371046167423e-16,  5.206654528278916e-18,
 -1.084972005719296e-19,  1.365499229051142e-04, -2.435566986170381e-05,  2.291022728418231e-06, -1.497162592783482e-07,  7.607806774355646e-09, -3.195488392360467e-10,
  1.152574112812857e-11, -3.663781324870986e-13,  1.045822613643056e-14, -2.718855007973968e-16,  6.508584234811536e-18, -1.446755208942158e-19,  7.451934994350265e-05,
 -1.459682966294853e-05,  1.502235756835258e-06, -1.069288636980892e-07,  5.894278759245629e-09, -2.675885969366873e-10,  1.039768033694809e-11, -3.550187756643842e-13,
  1.085595215743998e-14, -3.015901555175858e-16,  7.697624263336774e-18, -1.820426093228237e-19,  4.020674607107938e-05, -8.593791019639402e-06,  9.625186016230636e-07,
 -7.427964161085149e-08,  4.423313208649432e-09, -2.162231016646570e-10,  9.019754288594175e-12, -3.297271492316982e-13,  1.076805213624102e-14, -3.187561401691766e-16,
  8.650689728666056e-18, -2.170905628110955e-19,  2.151726340554353e-05, -4.988164950913764e-06,  6.049254303573089e-07, -5.038668592628776e-08,  3.228301735362374e-09,
 -1.692900593978862e-10,  7.555305318047331e-12, -2.947537491981342e-13,  1.024925040083692e-14, -3.223593660827978e-16,  9.276842629622230e-18, -2.463941702503646e-19,
  1.146028123911641e-05, -2.864968774655656e-06,  3.743611889880674e-07, -3.350882164268946e-08,  2.300745583005089e-09, -1.289537256033357e-10,  6.136169412468844e-12,
 -2.546588590479809e-13,  9.399975614325199e-15, -3.132230380138779e-16,  9.532169023838567e-18, -2.672527510351981e-19,  6.095783636086518e-06, -1.634329678322748e-06,
  2.290133675578691e-07, -2.193440764780955e-08,  1.607612337178752e-09, -9.595599438064499e-11,  4.851742517273043e-12, -2.135102688272943e-13,  8.340677273853284e-15,
 -2.935964629656878e-16,  9.422522757039466e-18, -2.781292167336335e-19,  3.249556198920681e-06, -9.294593603523472e-07,  1.390263021393121e-07, -1.418838510838497e-08,
  1.105721620992645e-09, -7.003023376470594e-11,  3.749654051408473e-12, -1.744096107419191e-13,  7.188468598355732e-15, -2.665255445696197e-16,  8.995360223829367e-18,
 -2.787914383338631e-19,  1.742291914961782e-06, -5.289540354264478e-07,  8.407544624634080e-08, -9.104867417536438e-09,  7.515622148059471e-10, -5.032424213264166e-11,
  2.843634828156976e-12, -1.393471407424675e-13,  6.040889946963462e-15, -2.352171140155647e-16,  8.324868528842220e-18, -2.701665982050083e-19,  9.428526142944946e-07,
 -3.023430058366608e-07,  5.084053292143507e-08, -5.818303233178894e-09,  5.067462999906752e-10, -3.574321486760727e-11,  2.124127030171397e-12, -1.093000596870698e-13,
  4.968143798024185e-15, -2.025435596419846e-16,  7.495448084081927e-18, -2.539995599023236e-19,  5.167300672822058e-07, -1.741862296595113e-07,  3.085207322852370e-08,
 -3.715994519858900e-09,  3.401688516256220e-10, -2.518235780287833e-11,  1.568400819657533e-12, -8.446237490920295e-14,  4.012535607274116e-15, -1.707516894384463e-16,
  6.587643745973844e-18, -2.324378771728205e-19,  2.877095113221634e-07, -1.014830643235307e-07,  1.885153184570043e-08, -2.379951656434835e-09,  2.281015995967534e-10,
 -1.765724586868595e-11,  1.148475017640259e-12, -6.450918036194677e-14,  3.192595919875953e-15, -1.413674630431444e-16,  5.668738108204653e-18, -2.076515271874184e-19,
  1.632041126031965e-07, -5.996676261432923e-08,  1.163278745792733e-08, -1.533068032951145e-09,  1.532382069347266e-10, -1.235751125024186e-11,  8.363911269380828e-13,
 -4.883203770122758e-14,  2.509289803279268e-15, -1.152453093919225e-16,  4.788358342110563e-18, -1.815541611383003e-19,  9.452978908969858e-08, -3.602389830902970e-08,
  7.266624334512934e-09, -9.956053126921501e-10,  1.033782569720424e-10, -8.652051170753248e-12,  6.071484582437406e-13, -3.671639565660705e-14,  1.952344862686524e-15,
 -9.269835984119925e-17,  3.978176453061158e-18, -1.556469589348414e-19,  5.598569542348414e-08, -2.203391739491928e-08,  4.602130883359996e-09, -6.528352830514125e-10,
  7.013857828852454e-11, -6.068869171890786e-12,  4.399193520470691e-13, -2.745704427573257e-14,  1.505557394198022e-15, -7.365464896341842e-17,  3.254243465346720e-18,
 -1.309715372232749e-19,  3.390861543568516e-08, -1.372497337792522e-08,  2.955735707967019e-09, -4.323190759941299e-10,  4.786596636964887e-11, -4.265316501718087e-12,
  3.181794792462860e-13, -2.042141527144981e-14,  1.150648361126191e-15, -5.780234670061698e-17,  2.620535701416347e-18, -1.081404306360748e-19,  2.096227501848801e-08,
 -8.690827617877308e-09,  1.921617250587262e-09, -2.885981179607480e-10,  3.279632378282387e-11, -2.997875906732182e-12,  2.292613732920020e-13, -1.507534350956770e-14,
  8.697094515854665e-16, -4.470533030416314e-17,  2.072642389894720e-18, -8.741044825055650e-20,  1.315630848686554e-08, -5.564787422696860e-09,  1.257976985365132e-09,
 -1.931835668284452e-10,  2.244058140231460e-11, -2.095829029857597e-12,  1.636764198908700e-13, -1.098522133822939e-14,  6.465104115991157e-16, -3.388416988280856e-17,
  1.600955114543533e-18, -6.877017475814101e-20,  8.284171697322281e-09, -3.560880783694203e-09,  8.195351223853873e-10, -1.281471325422435e-10,  1.515347488775120e-11,
 -1.440180903672366e-12,  1.144076980088740e-13, -7.807366434204818e-15,  4.669989891666243e-16, -2.486577469958684e-17,  1.193087763945772e-18, -5.202243502175185e-20,
  5.098541161626980e-09, -2.218586806174284e-09,  5.176552698322182e-10, -8.207100409575393e-11,  9.838430748391637e-12, -9.476473199680592e-13,  7.627268326561079e-14,
 -5.271874926261960e-15,  3.192897680095040e-16, -1.720848311111652e-17,  8.355064807860019e-19, -3.685180956790756e-20,  2.870710722379818e-09, -1.259769837628700e-09,
  2.967411177717991e-10, -4.749974214839341e-11,  5.748337882957141e-12, -5.588546571515813e-13,  4.539065349849932e-14, -3.165289079791969e-15,  1.933699188593626e-16,
 -1.051011823421881e-17,  5.144970211339313e-19, -2.287486786070220e-20,  1.151548346609224e-09, -5.077147582576684e-10,  1.202258068187931e-10, -1.934763063445107e-11,
  2.353795788513143e-12, -2.300232841207584e-13,  1.877741875271630e-14, -1.315912864942286e-15,  8.077820395661741e-17, -4.411151433567324e-18,  2.169275211134514e-19,
 -9.687717237044061e-21,  7.181418547360634e-02, -2.156213905418179e-04,  6.763662261554257e-07, -2.196207604568137e-09,  7.307429922597036e-12, -2.469730470482728e-14,
  8.420599500686761e-17, -2.882767792220908e-19,  9.877501529822064e-22, -3.381004638397452e-24,  1.154675943469742e-26, -3.932375127308453e-29,  6.864874100823133e-02,
 -2.768996197021804e-04,  1.324275008424939e-06, -6.481013146180069e-09,  3.108682584218625e-11, -1.452595312312442e-13,  6.628384646733679e-16, -2.963936693080233e-18,
  1.302542140176229e-20, -5.638462413606386e-23,  2.408430526404435e-25, -1.016501070829959e-27,  6.273909712928623e-02, -3.824294679772000e-04,  2.644607338880995e-06,
 -1.714354582686413e-08,  1.044946145013437e-10, -6.075972311343107e-13,  3.403477267570941e-15, -1.848519321919918e-17,  9.779256384996076e-20, -5.056606134539002e-22,
  2.562401206497289e-24, -1.275240674346010e-26,  5.483397605390482e-02, -5.038128039358868e-04,  4.618877819957213e-06, -3.755004544197355e-08,  2.808335361811798e-10,
 -1.974357735459713e-12,  1.321523553560066e-14, -8.493766012691829e-17,  5.274369553674163e-19, -3.179028222748462e-21,  1.866518677425395e-23, -1.070567643042516e-25,
  4.585130253344686e-02, -6.102746784183570e-04,  7.100814676645965e-06, -7.078191539397936e-08,  6.371717734392871e-10, -5.316605495457905e-12,  4.177444823180632e-14,
 -3.124020441181767e-16,  2.240586095516978e-18, -1.550012820461747e-20,  1.038849874089532e-22, -6.768916129546346e-25,  3.670221094585119e-02, -6.775045502768472e-04,
  9.779630869296884e-06, -1.177115680445385e-07,  1.256928107371507e-09, -1.227821349741562e-11,  1.118050602765390e-13, -9.611126206384144e-16,  7.870152202332335e-18,
 -6.180173521875618e-20,  4.678128486263012e-22, -3.427316817593922e-24,  2.814392086569888e-02, -6.932953675531583e-04,  1.222734807340368e-05, -1.754715830362143e-07,
  2.196758804995311e-09, -2.485463426302906e-11,  2.596937826791419e-13, -2.542210902808002e-15,  2.355646443091647e-17, -2.081936519221622e-19,  1.765352553554660e-21,
 -1.442749038068539e-23,  2.069231390953104e-02, -6.586048429501988e-04,  1.401436750410133e-05, -2.371748618317386e-07,  3.447598936095244e-09, -4.478458877852031e-11,
  5.325745539437415e-13, -5.891865785700023e-15,  6.133356111793944e-17, -6.058905689076326e-19,  5.717011729908311e-21, -5.178766633312164e-23,  1.460209655549607e-02,
 -5.846113978017310e-04,  1.483823647078969e-05, -2.932946916926889e-07,  4.909092830447322e-09, -7.266837381631295e-11,  9.767848113501296e-13, -1.213367580144187e-14,
  1.410381863648558e-16, -1.548277503002908e-18,  1.616653410485075e-20, -1.614519052918435e-22,  9.902039822382450e-03, -4.876436127703848e-04,  1.460649876110332e-05,
 -3.342954792839476e-07,  6.395409313419016e-09, -1.071728281456531e-10,  1.618534431914223e-12, -2.244912404227729e-14,  2.898323527556268e-16, -3.517980393550500e-18,
  4.045461432315215e-20, -4.433597253569709e-22,  6.461507663588780e-03, -3.841136156222787e-04,  1.344286059532608e-05, -3.534330696561440e-07,  7.676868940423209e-09,
 -1.447778322995707e-10,  2.443332890403526e-12, -3.765079912770249e-14,  5.373873155425502e-16, -7.180216548418273e-18,  9.054735825653211e-20, -1.084566348391630e-21,
  4.063658202578801e-03, -2.869602843928262e-04,  1.162504737529022e-05, -3.485592888482630e-07,  8.543321589795828e-09, -1.803414457733496e-10,  3.384450094764547e-12,
 -5.767995771128268e-14,  9.062768074472155e-16, -1.327615461321767e-17,  1.829004246240587e-19, -2.385592650086403e-21,  2.467346095053911e-03, -2.041272841823118e-04,
  9.489703267301199e-06, -3.222981937755276e-07,  8.863455136909476e-09, -2.083739039463813e-10,  4.328902547632433e-12, -8.125407796038586e-14,  1.399939951677348e-15,
 -2.240185409000316e-17,  3.359783724186628e-19, -4.755978062747189e-21,  1.449146699416798e-03, -1.387712401403948e-04,  7.344079447737274e-06, -2.807451470574191e-07,
  8.616452016592098e-09, -2.245419544880157e-10,  5.141978661285271e-12, -1.058846970390343e-13,  1.993178642096872e-15, -3.472136638123624e-17,  5.650642583682006e-19,
 -8.654145244776358e-21,  8.250707550868934e-04, -9.048062114045969e-05,  5.410487505968414e-06, -2.314154207995299e-07,  7.886500961776417e-09, -2.268037205791050e-10,
  5.702141915823636e-12, -1.283439408546004e-13,  2.630552171362247e-15, -4.972471614647631e-17,  8.754250358236793e-19, -1.446355100841656e-20,  4.564403120907388e-04,
 -5.677802582355485e-05,  3.809651987169948e-06, -1.812919038695746e-07,  6.827478528039770e-09, -2.157654079862392e-10,  5.932828442432966e-12, -1.454474354603858e-13,
  3.235304138205515e-15, -6.615766780922476e-17,  1.256342705759819e-18, -2.232992640058655e-20,  2.459805220416074e-04, -3.440996179347969e-05,  2.573913941950755e-06,
 -1.355525582310193e-07,  5.615476317992117e-09, -1.942215566263143e-10,  5.819300045216287e-12, -1.548645459239624e-13,  3.726753585166074e-15, -8.219595309223094e-17,
  1.678971281942299e-18, -3.201735321587792e-20,  1.294927841050564e-04, -2.021148247270262e-05,  1.675204786994735e-06, -9.713967463439148e-08,  4.407159235978472e-09,
 -1.661705611757979e-10,  5.405960651141945e-12, -1.556558389621283e-13,  4.040040895270390e-15, -9.583235337152748e-17,  2.099850434641194e-18, -4.285155641460408e-20,
  6.679095557471608e-05, -1.154752086468141e-05,  1.054445875719483e-06, -6.699749979037450e-08,  3.314797500522517e-09, -1.357319045685090e-10,  4.777909654550927e-12,
 -1.483710196226167e-13,  4.141062973809518e-15, -1.053471026155988e-16,  2.469587630226604e-18, -5.379404107965563e-20,  3.386182678514507e-05, -6.441232064401548e-06,
  6.444734151599875e-07, -4.465986161937452e-08,  2.399720709130920e-09, -1.063163256729000e-10,  4.035659868813568e-12, -1.347332830541461e-13,  4.031807417277351e-15,
 -1.096954871967200e-16,  2.743927761478063e-18, -6.363882001272526e-20,  1.693203206100659e-05, -3.521315600219366e-06,  3.840475213879088e-07, -2.889459481563960e-08,
  1.679416692390434e-09, -8.020972516241758e-11,  3.272219527768445e-12, -1.170838754831566e-13,  3.745538132107693e-15, -1.086883160809058e-16,  2.893416541193201e-18,
 -7.127098600047206e-20,  8.380819183542505e-06, -1.894170105861419e-06,  2.240664693075034e-07, -1.822322641593775e-08,  1.141180635588056e-09, -5.854486542261528e-11,
  2.558349477438837e-12, -9.780491010904690e-14,  3.335053436466136e-15, -1.029324813510504e-16,  2.908606290144721e-18, -7.590120498617880e-20,  4.121879920525603e-06,
 -1.006671827621558e-06,  1.285380625824180e-07, -1.125224105362810e-08,  7.562579911639698e-10, -4.152601329049339e-11,  1.937344734409265e-12, -7.888693497193067e-14,
  2.858910538478666e-15, -9.358915519456071e-17,  2.799715043313704e-18, -7.720388933784566e-20,  2.022356660124689e-06, -5.308080536600233e-07,  7.281736120048361e-08,
 -6.832459386706857e-09,  4.909547685404496e-10, -2.875169030379599e-11,  1.427327724753326e-12, -6.171109933059312e-14,  2.369897386200428e-15, -8.205607065856516e-17,
  2.591738366867012e-18, -7.532892729143891e-20,  9.939166926733955e-07, -2.788890011074742e-07,  4.091634412700845e-08, -4.098016292504505e-09,  3.136260667388546e-10,
 -1.951911640115627e-11,  1.027646430558113e-12, -4.702786944659767e-14,  1.908063827604038e-15, -6.967740182366915e-17,  2.317288219856955e-18, -7.080403164157663e-20,
  4.913399082794520e-07, -1.466405489190308e-07,  2.290537729869021e-08, -2.438730659412652e-09,  1.980242215017356e-10, -1.305085449756279e-11,  7.262411694386370e-13,
 -3.506517093129273e-14,  1.498522037288537e-15, -5.754627224805970e-17,  2.009567092243596e-18, -6.437587135505780e-20,  2.453411341650541e-07, -7.749729315713400e-08,
  1.283109217995904e-08, -1.446309233537239e-09,  1.241275343532043e-10, -8.631652571182764e-12,  5.059520476247152e-13, -2.569065890099081e-14,  1.152824053621909e-15,
 -4.641731187596100e-17,  1.697154811316031e-18, -5.684457086747247e-20,  1.242515444162661e-07, -4.134018331553526e-08,  7.223316037745377e-09, -8.584729827834980e-10,
  7.757307595308104e-11, -5.670942471515420e-12,  3.489268844325557e-13, -1.857075829497338e-14,  8.722431659787155e-16, -3.671063860579936e-17,  1.401244565974011e-18,
 -4.893253211009879e-20,  6.407456371683522e-08, -2.234971361987461e-08,  4.103245427494669e-09, -5.120648551635520e-10,  4.852827406355906e-11, -3.715752088319759e-12,
  2.391393243955168e-13, -1.329540199984768e-14,  6.514993902553212e-16, -2.857218854909725e-17,  1.135095839104049e-18, -4.120630790841351e-20,  3.376675631904557e-08,
 -1.229133566214338e-08,  2.360778984428234e-09, -3.080802601578739e-10,  3.050044350432997e-11, -2.436841026076127e-12,  1.634502080703874e-13, -9.459791348230867e-15,
  4.819980244906912e-16, -2.195574504477570e-17,  9.050036653510049e-19, -3.405020285830506e-20,  1.824101356789172e-08, -6.898152193044470e-09,  1.380066511941818e-09,
 -1.875460564199703e-10,  1.931901683334724e-11, -1.604375948113451e-12,  1.117410059365340e-13, -6.708212928320023e-15,  3.541836021464716e-16, -1.670174781951183e-17,
  7.120021807341683e-19, -2.767819326193636e-20,  1.012371422387247e-08, -3.959937245555619e-09,  8.216264962494208e-10, -1.157849030077636e-10,  1.235945817435073e-11,
 -1.062720768196332e-12,  7.656524467523008e-14, -4.750483372725875e-15,  2.589902061074092e-16, -1.259976804463501e-17,  5.536823170540734e-19, -2.216718455218450e-20,
  5.777989010726979e-09, -2.327648618817525e-09,  4.986843078243048e-10, -7.256432905517826e-11,  7.993716855250747e-12, -7.088144555549928e-13,  5.262262494012428e-14,
 -3.361748580943156e-15,  1.885645868075197e-16, -9.431019354714227e-18,  4.257500134772678e-19, -1.749695740060130e-20,  3.387488738612769e-09, -1.399499454328333e-09,
  3.082481218083035e-10, -4.611560358153995e-11,  5.220730513218242e-12, -4.754578071491510e-13,  3.622972050261196e-14, -2.374002477577292e-15,  1.364933790954653e-16,
 -6.992987411189641e-18,  3.231731359243252e-19, -1.358705444353556e-20,  2.030673850392582e-09, -8.568052399895196e-10,  1.931612191960588e-10, -2.958199171158203e-11,
  3.427058305055202e-12, -3.192279707130768e-13,  2.486674115110764e-14, -1.664791267101291e-15,  9.774060992732907e-17, -5.110632354385146e-18,  2.409151805890492e-19,
 -1.032578533550748e-20,  1.230859543999084e-09, -5.282235282090529e-10,  1.213528185678005e-10, -1.894126013610860e-11,  2.235846387347648e-12, -2.121259231101744e-13,
  1.682278509106445e-14, -1.146126724981457e-15,  6.844612271379382e-17, -3.638805311919999e-18,  1.743298513670556e-19, -7.590187404168992e-21,  7.353538106622689e-10,
 -3.196805927171028e-10,  7.451110151736031e-11, -1.180067426292645e-11,  1.413142279798494e-12, -1.359750480044177e-13,  1.093313005311311e-14, -7.549436447532765e-16,
  4.567928908297091e-17, -2.459646123307068e-18,  1.193125534705391e-19, -5.257906101402221e-21,  4.054801214233735e-10, -1.778533179532636e-10,  4.187094426598766e-11,
 -6.698656176358488e-12,  8.102192320708985e-13, -7.872761400449209e-14,  6.390978768262050e-15, -4.454428998232403e-16,  2.719883755735998e-17, -1.477599721848728e-18,
  7.229774540806993e-20, -3.212910158183341e-21,  1.607580994085676e-10, -7.086200573830257e-11,  1.677571939280808e-11, -2.698975195705063e-12,  3.282675089809149e-13,
 -3.207156351550821e-14,  2.617429419862863e-15, -1.833828255539417e-16,  1.125433660222019e-17, -6.144316943343523e-19,  3.020883509102234e-20, -1.348778048611972e-21,
  7.096235761672164e-02, -2.103139279165338e-04,  6.506972962911477e-07, -2.083133171487402e-09,  6.833057448735396e-12, -2.276975947843284e-14,  7.655907573198804e-17,
 -2.585303668591794e-19,  8.739472350066628e-22, -2.951934162590968e-24,  9.949551599930010e-27, -3.344600693425096e-29,  6.756185002570633e-02, -2.666082679648159e-04,
  1.249394039381519e-06, -6.006028509023608e-09,  2.833422993601476e-11, -1.303020020895238e-13,  5.853912388445369e-16, -2.577825468689775e-18,  1.115872571652677e-20,
 -4.758858316823871e-23,  2.002937240121743e-25, -8.331015023816939e-28,  6.125042900891033e-02, -3.620679724928020e-04,  2.448529168087941e-06, -1.556457924319051e-08,
  9.311933866598320e-11, -5.317873230081260e-13,  2.927101218475342e-15, -1.562835689396807e-17,  8.130612085142800e-20, -4.135576921155683e-22,  2.062043654268562e-24,
 -1.009991270772126e-26,  5.288987709959068e-02, -4.685906897795736e-04,  4.193987909522074e-06, -3.335614903263037e-08,  2.443348254439072e-10, -1.683924738940955e-12,
  1.105704426752869e-14, -6.975543214562868e-17,  4.253686658521738e-19, -2.518716628832062e-21,  1.453305795375302e-23, -8.194281642233580e-26,  4.351867187700575e-02,
 -5.567001237444224e-04,  6.309259888639236e-06, -6.138618465416942e-08,  5.401967873723971e-10, -4.411372166771236e-12,  3.395248431621305e-14, -2.488841851091618e-16,
  1.750719452995201e-18, -1.188428502442675e-20,  7.819097073678137e-23, -5.003235555035165e-25,  3.414017995450276e-02, -6.045935332497621e-04,  8.480101971799791e-06,
 -9.942810159442156e-08,  1.036156049960112e-09, -9.891301014813555e-12,  8.810940010368589e-14, -7.415296079576397e-16,  5.948690727134260e-18, -4.578993228245935e-20,
  3.399278855807013e-22, -2.443451848142310e-24,  2.555383750305525e-02, -6.033373937001530e-04,  1.031720818696962e-05, -1.439842964433020e-07,  1.756639409091752e-09,
 -1.939745332625076e-11,  1.980288493754879e-13, -1.895846593499019e-15,  1.719311153488182e-17, -1.488140626301398e-19,  1.236467401888280e-21, -9.906762676051795e-24,
  1.826533862035758e-02, -5.570003730972149e-04,  1.147178623881429e-05, -1.885366797339953e-07,  2.667428389039844e-09, -3.377936433774301e-11,  3.920912776808461e-13,
 -4.238151445875883e-15,  4.314191254358554e-17, -4.170431527516875e-19,  3.853093171719816e-21, -3.419467352251494e-23,  1.248052158229537e-02, -4.787510969795570e-04,
  1.174584300514739e-05, -2.252093743682838e-07,  3.665066913629991e-09, -5.283982052099351e-11,  6.926630396434615e-13, -8.400143226861268e-15,  9.540925215892404e-17,
 -1.024223447274370e-18,  1.046514433622413e-20, -1.023322184800245e-22,  8.162020022581479e-03, -3.852484341756629e-04,  1.114447330731274e-05, -2.472022702696278e-07,
  4.594444023259649e-09, -7.492960704578081e-11,  1.102788056413804e-12, -1.492309010022741e-14,  1.881507561707982e-16, -2.232057502130806e-18,  2.510394442270054e-20,
 -2.692577955414754e-22,  5.115959903075885e-03, -2.916484197027312e-04,  9.852509020339484e-06, -2.509078195454201e-07,  5.291433437173839e-09, -9.706130157938647e-11,
  1.595491187687066e-12, -2.397499298472141e-14,  3.340192432086087e-16, -4.360041699830110e-18,  5.375542155824564e-20, -6.299223108537168e-22,  3.078279606752961e-03,
 -2.086149186847129e-04,  8.156395490141290e-06, -2.368028037101607e-07,  5.633173767077917e-09, -1.156138060788577e-10,  2.112562841489527e-12, -3.509689220281550e-14,
  5.381030352653813e-16, -7.698723537028483e-18,  1.036666410846973e-19, -1.322517016768091e-21,  1.781205453237826e-03, -1.415526664957498e-04,  6.351861673002405e-06,
 -2.088690185583728e-07,  5.573937094347983e-09, -1.273810942814280e-10,  2.576085028435255e-12, -4.712666229598630e-14,  7.921635252859727e-16, -1.237832190320006e-17,
  1.814285453905573e-19, -2.511667574280657e-21,  9.931384591726864e-04, -9.145296256903359e-05,  4.673367534184435e-06, -1.729952356784785e-07,  5.152402521595266e-09,
 -1.305200602808879e-10,  2.909496002237184e-12, -5.839079378695293e-14,  1.072326553703819e-15, -1.824059661277704e-17,  2.901015823631358e-19, -4.345139540590391e-21,
  5.347566060916514e-04, -5.646140409629308e-05,  3.262033558117568e-06, -1.351541420955459e-07,  4.470787390703290e-09, -1.250038595319315e-10,  3.059700758906320e-12,
 -6.712620531438960e-14,  1.342400083919989e-15, -2.478088119029890e-17,  4.264051942021748e-19, -6.890608274031335e-21,  2.787496607365105e-04, -3.342955569300846e-05,
  2.168910186856376e-06, -1.000376085980567e-07,  3.658422175413559e-09, -1.124452593776698e-10,  3.011067849755501e-12, -7.197136104410101e-14,  1.562422664516445e-15,
 -3.120901286912140e-17,  5.793912074035059e-19, -1.007476407007042e-20,  1.410426494739600e-04, -1.905012306897058e-05,  1.379250606291782e-06, -7.045483442302800e-08,
  2.835978868210826e-09, -9.544790529845398e-11,  2.786383900578853e-12, -7.232728156478428e-14,  1.699355295932500e-15, -3.662571913915836e-17,  7.316500749141168e-19,
 -1.365485190538469e-20,  6.947670360419289e-05, -1.048699688064285e-05,  8.422831245329920e-07, -4.741784029275103e-08,  2.091973968616111e-09, -7.680726245434307e-11,
  2.436082507703931e-12, -6.845637279949527e-14,  1.735690374493410e-15, -4.025358832416308e-17,  8.630199450133912e-19, -1.724449828580232e-20,  3.342465196395394e-05,
 -5.598099110774009e-06,  4.959983959379456e-07, -3.062953413741887e-08,  1.475027392149129e-09, -5.886289328405013e-11,  2.021637822957508e-12, -6.131342244740065e-14,
  1.672824613579496e-15, -4.163394128425574e-17,  9.555623816409612e-19, -2.039303924611386e-20,  1.575916377633407e-05, -2.909249756955379e-06,  2.828440634269536e-07,
 -1.907305219477213e-08,  9.986162109753223e-10, -4.316027718477229e-11,  1.599931386934037e-12, -5.221245180015472e-14,  1.528559545054372e-15, -4.071860667989330e-17,
  9.979496203256208e-19, -2.269254200042898e-20,  7.308884271490717e-06, -1.477955184706769e-06,  1.568735853240594e-07, -1.150099296377648e-08,  6.521474917682641e-10,
 -3.041935099945362e-11,  1.213173191460227e-12, -4.247345356259375e-14,  1.330527300266179e-15, -3.783568055871608e-17,  9.877200209626212e-19, -2.387376354978426e-20,
  3.347687711815037e-06, -7.371387329594774e-07,  8.500423052373250e-08, -6.746646495084721e-09,  4.127370232431747e-10, -2.070556390272285e-11,  8.855727644233123e-13,
 -3.316235484840389e-14,  1.108493627954354e-15, -3.356052450667659e-17,  9.308619873376480e-19, -2.385832728081443e-20,  1.520705654097581e-06, -3.625706408076343e-07,
  4.520998854790751e-08, -3.868399909819270e-09,  2.543633239138397e-10, -1.367654974320768e-11,  6.252975466656308e-13, -2.497084975458227e-14,  8.881326722348078e-16,
 -2.855162454520420e-17,  8.392800688588838e-19, -2.275470545866983e-20,  6.881442117724521e-07, -1.766912944239455e-07,  2.371414496032008e-08, -2.178554853437550e-09,
  1.533918913720029e-10, -8.809096853746826e-12,  4.291563284903429e-13, -1.822108167121009e-14,  6.875978954539160e-16, -2.340812100698021e-17,  7.273409071365104e-19,
 -2.080816237564964e-20,  3.116442942897527e-07, -8.572489546471351e-08,  1.232789373617038e-08, -1.211001860943830e-09,  9.096288734092546e-11, -5.560199624284447e-12,
  2.876964203965759e-13, -1.294708772951665e-14,  5.168741581559728e-16, -1.858201255787326e-17,  6.087085911411050e-19, -1.832870439336661e-20,  1.419252265791311e-07,
 -4.161104388906752e-08,  6.383314157952772e-09, -6.677816888998617e-10,  5.330986220356601e-11, -3.456252442700728e-12,  1.893100142640051e-13, -9.001835316041847e-15,
  3.790562133553978e-16, -1.435005108774336e-17,  4.942345976679797e-19, -1.562229497479219e-20,  6.531193423983617e-08, -2.030891090930956e-08,  3.308740341816399e-09,
 -3.671289233319800e-10,  3.103123851824647e-11, -2.126281866184662e-12,  1.228708741571733e-13, -6.153681012713431e-15,  2.724834027892282e-16, -1.083081747830773e-17,
  3.910967211278969e-19, -1.294226007499227e-20,  3.051891800947795e-08, -1.001610383227110e-08,  1.725455804413796e-09, -2.022332767958498e-10,  1.802906698932968e-11,
 -1.300894840774734e-12,  7.903733417032383e-14, -4.155449951448368e-15,  1.928805210902777e-16, -8.025439619250287e-18,  3.029512770682441e-19, -1.046635244938086e-20,
  1.454954212806507e-08, -5.015865197505236e-09,  9.096424287979642e-10, -1.121555550834891e-10,  1.050478210559735e-11, -7.952294823774242e-13,  5.061831045242853e-14,
 -2.784339222121000e-15,  1.350348960112852e-16, -5.863107603813981e-18,  2.306768541686670e-19, -8.295814946676510e-21,  7.108426210885594e-09, -2.562149556201303e-09,
  4.870060402271145e-10, -6.290305644184844e-11,  6.165339017936452e-12, -4.878087120876080e-13,  3.241230552450891e-14, -1.858814949946166e-15,  9.387585775605693e-17,
 -4.239650499708363e-18,  1.733084436919512e-19, -6.468349148407014e-21,  3.573281339408818e-09, -1.340397524568427e-09,  2.658541182407575e-10, -3.582014556641638e-11,
  3.659053944945841e-12, -3.014097241333269e-13,  2.082749023645842e-14, -1.240821126377757e-15,  6.502953642741644e-17, -3.044544961275072e-18,  1.288886735176982e-19,
 -4.976702651778925e-21,  1.853978748310973e-09, -7.205072370010579e-10,  1.484531135096452e-10, -2.077539144068375e-11,  2.202650578364121e-12, -1.881457667736673e-13,
  1.346851520532209e-14, -8.304661968103839e-16,  4.500337846977199e-17, -2.176611736207871e-18,  9.510689464601226e-20, -3.786814178718803e-21,  9.947176048611706e-10,
 -3.987138491310772e-10,  8.495698860930290e-11, -1.229512217588380e-11,  1.347233918175364e-12, -1.188425160239781e-13,  8.778507501514539e-15, -5.580671035221274e-16,
  3.115425301319771e-17, -1.551004861864683e-18,  6.970530978996170e-20, -2.852281760317594e-21,  5.517721047109894e-10, -2.271103446388899e-10,  4.981849937623599e-11,
 -7.422740928434627e-12,  8.369653517492946e-13, -7.592618913121203e-14,  5.763611772300756e-15, -3.762774692607635e-16,  2.155671242248476e-17, -1.100583664714963e-18,
  5.069079408349691e-20, -2.124218255510341e-21,  3.152454880973243e-10, -1.326643714732728e-10,  2.982199697040155e-11, -4.553923190262355e-12,  5.260696933251858e-13,
 -4.886702656298594e-14,  3.796288684369985e-15, -2.534885064108016e-16,  1.484445016152521e-17, -7.742586845731131e-19,  3.641069106633925e-20, -1.556947323214526e-21,
  1.835887633366521e-10, -7.865287743758766e-11,  1.803529428699905e-11, -2.809665774034876e-12,  3.310345838501759e-13, -3.134940762477694e-14,  2.481750318510584e-15,
 -1.687867378138749e-16,  1.006284586620805e-17, -5.340937601613232e-19,  2.554683395040419e-20, -1.110569434934501e-21,  1.063050123491366e-10, -4.616781420214119e-11,
  1.074875829755604e-11, -1.700414093762463e-12,  2.034001009677107e-13, -1.955023976864808e-14,  1.570277298867115e-15, -1.083171141613372e-16,  6.547331521429381e-18,
 -3.522018555033919e-19,  1.706830840548885e-20, -7.514752398537690e-22,  5.734165891852243e-11, -2.513866830697338e-11,  5.914868160465627e-12, -9.457343155439402e-13,
  1.143235800325719e-13, -1.110239361115890e-14,  9.007790713408204e-16, -6.274941585931230e-17,  3.829482758867587e-18, -2.079333021390147e-19,  1.016891763886011e-20,
 -4.516864254302012e-22,  2.245462361658979e-11, -9.895677763321967e-12,  2.342064324060593e-12, -3.767037449559380e-13,  4.580498451555302e-14, -4.473939024260559e-15,
  3.650325847460156e-16, -2.556841613892099e-17,  1.568756076994751e-18, -8.562514921993953e-20,  4.208775548303251e-21, -1.878704458712705e-22,  7.013135732274099e-02,
 -2.052065153202284e-04,  6.263409605019417e-07, -1.977349986374127e-09,  6.395466015889743e-12, -2.101614318747512e-14,  6.969630935852621e-17, -2.321903453915929e-19,
  7.745005402279197e-22, -2.581868282512222e-24,  8.589705614349813e-27, -2.850575459689700e-29,  6.651496142563174e-02, -2.568938913262216e-04,  1.179958191368283e-06,
 -5.572789634906347e-09,  2.586303929600357e-11, -1.170799411898500e-13,  5.179643081151336e-16, -2.246679906671961e-18,  9.581336542111829e-21, -4.026401382752492e-23,
  1.670145434887555e-25, -6.847337320797447e-28,  5.984018540009256e-02, -3.432022947277552e-04,  2.270354663958798e-06, -1.415608251948733e-08,  8.315211446302811e-11,
 -4.665072269787041e-13,  2.523802848603692e-15, -1.324968105880647e-17,  6.780157429673991e-20, -3.393169535308180e-22,  1.665067403618011e-24, -8.028137083199603e-27,
  5.108017364379647e-02, -4.365758916629069e-04,  3.816103828873534e-06, -2.970243883189366e-08,  2.131594237927721e-10, -1.440535307796009e-12,  9.281586891083697e-15,
 -5.748890805241299e-17,  3.443447573976639e-19, -2.003540774250046e-21,  1.136352762838251e-23, -6.299900854590699e-26,  4.138835313391787e-02, -5.090320769304381e-04,
  5.621710263605241e-06, -5.340684190494437e-08,  4.595845861471223e-10, -3.674181784856227e-12,  2.770779830318146e-14, -1.991434349492144e-16,  1.374254191103848e-18,
 -9.156135257854940e-21,  5.915120385659521e-23, -3.717784121776709e-25,  3.185030987845200e-02, -5.412577537619604e-04,  7.380261251056588e-06, -8.432400928847917e-08,
  8.578995278090569e-10, -8.005753181477110e-12,  6.978132830132686e-14, -5.751189689056762e-16,  4.521136098800920e-18, -3.412205495522391e-20,  2.484853357840152e-22,
 -1.752879760192137e-24,  2.329525813902220e-02, -5.272610602160032e-04,  8.746021413510973e-06, -1.187404189588556e-07,  1.412218963423484e-09, -1.522422395503871e-11,
  1.519056950758686e-13, -1.422630218019221e-15,  1.263015194410430e-17, -1.070871599645214e-19,  8.720740269210018e-22, -6.851575391454780e-24,  1.620751747182391e-02,
 -4.735985156284249e-04,  9.444677166326847e-06, -1.507889451066721e-07,  2.077081900352019e-09, -2.565006899894914e-11,  2.906897464209747e-13, -3.070794026759474e-15,
  3.057455081842122e-17, -2.892883105054370e-19,  2.617651876818137e-21, -2.276391895371079e-23,  1.073764320103686e-02, -3.946723262424159e-04,  9.363024002807962e-06,
 -1.741936144435349e-07,  2.757106398973419e-09, -3.872474111637612e-11,  4.951879959161503e-13, -5.864264812122300e-15,  6.509969132976767e-17, -6.835532426336437e-19,
  6.835931839398545e-21, -6.546271268729864e-23,  6.782175558311444e-03, -3.068138768170038e-04,  8.573956666926495e-06, -1.843725819879833e-07,  3.329900044571020e-09,
 -5.286435055817095e-11,  7.584113385495154e-13, -1.001515554047067e-14,  1.233379619464390e-16, -1.430331300940772e-18,  1.573687714454316e-20, -1.652199110939641e-22,
  4.089790517299441e-03, -2.235677200947186e-04,  7.291696585606319e-06, -1.799024059356475e-07,  3.684426721725945e-09, -6.574873280934196e-11,  1.052907146423232e-12,
 -1.543155248378629e-14,  2.098947221358507e-16, -2.677102688390054e-18,  3.227466385161830e-20, -3.700657609629634e-22,  2.358277374922485e-03, -1.533574286642642e-04,
  5.787329581512306e-06, -1.627175855673362e-07,  3.757378128999508e-09, -7.498913737252839e-11,  1.334362205285521e-12, -2.161328975081604e-14,  3.234013032556683e-16,
 -4.519571934376029e-18,  5.949123600971730e-20, -7.424212293328607e-22,  1.302660654155471e-03, -9.942120479786589e-05,  4.306228882186729e-06, -1.371097168608438e-07,
  3.550915537817601e-09, -7.889170506593357e-11,  1.553294825352508e-12, -2.769782481047620e-14,  4.542789192316223e-16, -6.932421437412747e-18,  9.930847958252634e-20,
 -1.344651195504720e-21,  6.906978052355994e-04, -6.114458259476025e-05,  3.016835392955252e-06, -1.081391931302210e-07,  3.125579257111127e-09, -7.696899729215101e-11,
  1.670270433463867e-12, -3.267090448798801e-14,  5.853797494207317e-16, -9.723770221970171e-18,  1.511396348014412e-19, -2.214014322063583e-21,  3.523272541562414e-04,
 -3.580341576362605e-05,  1.998244305790506e-06, -8.019352941660484e-08,  2.574770631338662e-09, -6.999114429117022e-11,  1.667874421206276e-12, -3.566583687657942e-14,
  6.959248960196514e-16, -1.254610634276459e-17,  2.109970033848072e-19, -3.334973804214042e-21,  1.733390653527175e-04, -2.003342625305073e-05,  1.256518720346126e-06,
 -5.616306473621439e-08,  1.994255483977449e-09, -5.960965891637970e-11,  1.554409868470354e-12, -3.622217362086576e-14,  7.673987409083130e-16, -1.497266007777605e-17,
  2.717289426413420e-19, -4.622365464705833e-21,  8.247938323494586e-05, -1.075105678192645e-05,  7.531749423779185e-07, -3.730922324432908e-08,  1.458953759856431e-09,
 -4.777392331492235e-11,  1.358655167128574e-12, -3.439531575483359e-14,  7.889294364687548e-16, -1.661418386410334e-17,  3.245485552040372e-19, -5.927411799981230e-21,
  3.807342282716901e-05, -5.554709910457808e-06,  4.321536961360247e-07, -2.361262523672446e-08,  1.012746286637377e-09, -3.619943424546115e-11,  1.119122136076396e-12,
 -3.068679963689961e-14,  7.599354170950942e-16, -1.722852536073606e-17,  3.613606821367673e-19, -7.069051031838967e-21,  1.710733817816299e-05, -2.773976885143074e-06,
  2.383695323809012e-07, -1.430127282478185e-08,  6.701256219348154e-10, -2.605498734755640e-11,  8.728643201909754e-13, -2.584862017210614e-14,  6.892371455703856e-16,
 -1.677884451748180e-17,  3.769620243541841e-19, -7.880458485493993e-21,  7.509577413888012e-06, -1.344545972739944e-06,  1.269551110787113e-07, -8.327127866045138e-09,
  4.246611041579434e-10, -1.789883802157784e-11,  6.477502833528301e-13, -2.065693225775078e-14,  5.914779864390204e-16, -1.542262609181700e-17,  3.702532414504189e-19,
 -8.252696357932475e-21,  3.233290214358203e-06, -6.352941617674200e-07,  6.558860404826001e-08, -4.683335267965196e-09,  2.589668107121154e-10, -1.179262375937298e-11,
  4.596007724833695e-13, -1.573860979058967e-14,  4.826376828580669e-16, -1.344544080293131e-17,  3.441000449447652e-19, -8.158969841249966e-21,  1.371290407134253e-06,
 -2.939667624669641e-07,  3.302641392127222e-08, -2.556674375657598e-09,  1.527236845660923e-10, -7.488680386123749e-12,  3.133489987661587e-13, -1.148948866559143e-14,
  3.763350316636025e-16, -1.117286442227555e-17,  3.040888674806106e-19, -7.652572439116900e-21,  5.755231993204187e-07, -1.338597213492459e-07,  1.628976107834557e-08,
 -1.361611990954268e-09,  8.754699968639227e-11, -4.607064440129458e-12,  2.063292650762360e-13, -8.077375002422811e-15,  2.818305516559539e-16, -8.894096805081571e-18,
  2.568064744729051e-19, -6.843148540090388e-21,  2.401958461449212e-07, -6.028916563763741e-08,  7.911216631565502e-09, -7.111553006495215e-10,  4.903751228045083e-11,
 -2.760203284043979e-12,  1.318982650977419e-13, -5.496907198959187e-15,  2.037438957735089e-16, -6.816916627015103e-18,  2.082949803814232e-19, -5.863202241833803e-21,
  1.002015114392214e-07, -2.700062087190078e-08,  3.803523022818846e-09, -3.662323838245410e-10,  2.698427285975961e-11, -1.619137570407494e-12,  8.229436940846614e-14,
 -3.640214487985835e-15,  1.429282409686062e-16, -5.056464943299612e-18,  1.630843943496646e-19, -4.837338699991383e-21,  4.200725883861158e-08, -1.209050936753532e-08,
  1.820342280566359e-09, -1.869988263745774e-10,  1.466838877173790e-11, -9.350257763458474e-13,  5.038442861755700e-14, -2.358335478256728e-15,  9.780537724762788e-17,
 -3.648516969775771e-18,  1.238815120343196e-19, -3.862181136373151e-21,  1.779601135028439e-08, -5.443816984896299e-09,  8.721747653946086e-10, -9.520483073341571e-11,
  7.920793750199576e-12, -5.345088736049866e-13,  3.043518006981429e-14, -1.502701029263531e-15,  6.562886264593477e-17, -2.574119909827391e-18,  9.175917120384171e-20,
 -2.998868466607927e-21,  7.661440743924596e-09, -2.478721857878430e-09,  4.207387062504036e-10, -4.860402368741635e-11,  4.272617173870810e-12, -3.041333800265134e-13,
  1.823694527888254e-14, -9.467276840392239e-16,  4.340734503414413e-17, -1.784774419470891e-18,  6.660245828622877e-20, -2.275514983469998e-21,  3.370628258211708e-09,
 -1.147811155586702e-09,  2.055050023099256e-10, -2.502035834540396e-11,  2.314916907951726e-12, -1.731744364626847e-13,  1.089704413291260e-14, -5.927817286778478e-16,
  2.844105171187473e-17, -1.222089423378660e-18,  4.759883795817990e-20, -1.695164980369793e-21,  1.523551124043508e-09, -5.434880350612450e-10,  1.021820525156757e-10,
 -1.305660246110846e-11,  1.266358286119790e-12, -9.918082616654833e-14,  6.525374009972926e-15, -3.706676888754016e-16,  1.854755608202529e-17, -8.301812548888001e-19,
  3.364288809551020e-20, -1.245147057359615e-21,  7.110356865230835e-10, -2.644547443601221e-10,  5.197705874683110e-11, -6.940418523330248e-12,  7.027691841766005e-13,
 -5.739802573028231e-14,  3.933556056365207e-15, -2.324757456168759e-16,  1.208947198252676e-17, -5.617609551930894e-19,  2.360894796949020e-20, -9.051890561002244e-22,
  3.440495804638199e-10, -1.327951744141172e-10,  2.716035352395701e-11, -3.773280815022501e-12,  3.972020202386762e-13, -3.369320326143860e-14,  2.395736118541492e-15,
 -1.467578985662430e-16,  7.902630119773863e-18, -3.798730671073698e-19,  1.649990844522077e-20, -6.531897601579277e-22,  1.731006646591498e-10, -6.901683281722408e-11,
  1.462143708644990e-11, -2.103925603036133e-12,  2.292448866504337e-13, -2.011187702907469e-14,  1.477726252733338e-15, -9.345892358099109e-17,  5.191345811688323e-18,
 -2.571990512395103e-19,  1.150479368659207e-20, -4.686277901731616e-22,  9.062857053746650e-11, -3.715597598733139e-11,  8.115331292813220e-12, -1.203941657838150e-12,
  1.351794700054508e-13, -1.221248295734908e-14,  9.233499096427305e-16, -6.004675804299541e-17,  3.427073738579465e-18, -1.743299985633104e-19,  8.000799988681228e-21,
 -3.341243758585415e-22,  4.923776851469441e-11, -2.066325975622118e-11,  4.630757102587248e-12, -7.049679790187366e-13,  8.119314765065692e-14, -7.519975751625896e-15,
  5.825306568534920e-16, -3.878930344905652e-17,  2.265409656417444e-18, -1.178505602559612e-19,  5.528031316373612e-21, -2.358014345866857e-22,  2.749521601677351e-11,
 -1.175818460850832e-11,  2.690770469841021e-12, -4.183425915845268e-13,  4.919140190627865e-14, -4.649472023095667e-15,  3.673777157591988e-16, -2.493996860261640e-17,
  1.484238069492745e-18, -7.864068659078297e-20,  3.755218860500225e-21, -1.629802414652471e-22,  1.540546875978927e-11, -6.683448494059830e-12,  1.554195828552680e-12,
 -2.455752842183221e-13,  2.934074470738723e-14, -2.816910680649921e-15,  2.260011264863825e-16, -1.557245923442171e-17,  9.402923770333818e-19, -5.052904384642956e-20,
  2.446261572371801e-21, -1.075977195492409e-22,  8.119299664693878e-12, -3.557610430841554e-12,  8.365657909888038e-13, -1.336780828818011e-13,  1.614975121389278e-14,
 -1.567438137593689e-15,  1.270987692134673e-16, -8.848868694580059e-18,  5.397329881865463e-19, -2.929067576503089e-20,  1.431700504031517e-21, -6.356129333054536e-23,
  3.138270135689198e-12, -1.382691428175350e-12,  3.271595612420160e-13, -5.260652207588029e-14,  6.394870143378684e-15, -6.244386444324138e-16,  5.093470707292841e-17,
 -3.566731102781132e-18,  2.187803337624602e-19, -1.193829979595731e-20,  5.866608891076636e-22, -2.618076394011122e-23,  6.932040485270241e-02, -2.002889922336464e-04,
  6.032131432248880e-07, -1.878296390185736e-09,  5.991357776545700e-12, -1.941873069671541e-14,  6.352844180830482e-17, -2.088295475978107e-19,  6.874473127453545e-22,
 -2.262088534540147e-24,  7.429575526980054e-27, -2.434436744074184e-29,  6.550585136155657e-02, -2.477148586280931e-04,  1.115492425665210e-06, -5.177059153083342e-09,
  2.364082997194108e-11, -1.053703307926214e-13,  4.591406629995089e-16, -1.962036521753351e-18,  8.245164169482687e-21, -3.414874002528995e-23,  1.396253190018538e-25,
 -5.643475620913663e-28,  5.850265705525608e-02, -3.256970203200206e-04,  2.108166708147786e-06, -1.289712067171411e-08,  7.439885312996348e-11, -4.101535249551196e-13,
  2.181438297005331e-15, -1.126328295786625e-17,  5.670454874122767e-20, -2.792722694956701e-22,  1.348985514007317e-24, -6.403831920731751e-27,  4.939274941528659e-02,
 -4.074169123416881e-04,  3.479224876417966e-06, -2.651079622760784e-08,  1.864520769554045e-10, -1.235911983335152e-12,  7.815916163382243e-15, -4.754133485027628e-17,
  2.797726209439397e-19, -1.599924761528660e-21,  8.921694124165656e-24, -4.864375820516104e-26,  3.943828267248795e-02, -4.665022753037331e-04,  5.022635385677780e-06,
 -4.660703683147628e-08,  3.923236113572615e-10, -3.071426518188296e-12,  2.270097439961647e-14, -1.600147561887522e-16,  1.083555351850836e-18, -7.087427077208457e-21,
  4.496842850669637e-23, -2.776840537348044e-25,  2.979726852153243e-02, -4.860414711215773e-04,  6.445728171128691e-06, -7.179273739707464e-08,  7.133075258754238e-10,
 -6.508962856150948e-12,  5.553164786091875e-14, -4.483198914546669e-16,  3.454506218236174e-18, -2.556929373002918e-20,  1.826984903541082e-22, -1.265081910325063e-24,
  2.131763929461831e-02, -4.626302233888669e-04,  7.447267945865141e-06, -9.839547148953969e-08,  1.141187073920124e-09, -1.201415567298755e-11,  1.171955894980677e-13,
 -1.073963525732627e-15,  9.336464379235742e-18, -7.756334410179132e-20,  6.192286651264350e-22, -4.771701754936152e-24,  1.445352741526761e-02, -4.047506642344313e-04,
  7.818833170825365e-06, -1.213079477217717e-07,  1.627414524308302e-09, -1.960369038803012e-11,  2.169727579154449e-13, -2.240638952706873e-15,  2.182608733345285e-17,
 -2.021802842247729e-19,  1.792134213865479e-21, -1.527516133098404e-23,  9.296509655936789e-03, -3.274344220723664e-04,  7.513773242519611e-06, -1.356820118833261e-07,
  2.089283086401967e-09, -2.859620330491228e-11,  3.567998104578780e-13, -4.127190333306910e-15,  4.479025284145946e-17, -4.601116514163584e-19,  4.504597787211765e-21,
 -4.225418210106528e-23,  5.679271335997794e-03, -2.462407459185494e-04,  6.649226698253873e-06, -1.386513986898215e-07,  2.434035177346577e-09, -3.762514347281539e-11,
  5.262916521045514e-13, -6.783650261910861e-15,  8.161827576639995e-17, -9.254569871291323e-19,  9.962486029506659e-21, -1.024021998156384e-22,  3.299807667822694e-03,
 -1.729589942803207e-04,  5.447255137926029e-06, -1.302326970297957e-07,  2.590725717354269e-09, -4.498585643887416e-11,  7.019755104569942e-13, -1.003649218115809e-14,
  1.333011044111341e-16, -1.661570365063471e-18,  1.959087821514233e-20, -2.198332094645219e-22,  1.826384041207162e-03, -1.139508503501955e-04,  4.151054914018019e-06,
 -1.130442843013492e-07,  2.534284205445913e-09, -4.919246435436407e-11,  8.525519088689034e-13, -1.346558109126773e-14,  1.966691549288996e-16, -2.685079720665025e-18,
  3.455479871468918e-20, -4.218887165611439e-22,  9.646757234914993e-04, -7.069474557695694e-05,  2.955637489415969e-06, -9.112907948321401e-08,  2.290655860384396e-09,
 -4.948223320309142e-11,  9.486155665334307e-13, -1.648988322252781e-14,  2.639198019919961e-16, -3.933657318620530e-18,  5.508076546079360e-20, -7.295115247204620e-22,
  4.872323499521403e-04, -4.145466823074872e-05,  1.974709928638752e-06, -6.854364369548530e-08,  1.922671622879209e-09, -4.602921320382646e-11,  9.724408251252241e-13,
 -1.854020172821521e-14,  3.241259752484140e-16, -5.258041375427381e-18,  7.987800701762725e-20, -1.144466258054182e-21,  2.358551845797207e-04, -2.306018821999238e-05,
  1.243121519092183e-06, -4.831996328663203e-08,  1.505773244288413e-09, -3.979491272524491e-11,  9.232426688458202e-13, -1.924362620324810e-14,  3.663736961508105e-16,
 -6.450456135860684e-18,  1.060295396095768e-19, -1.639195986641391e-21,  1.097023222869582e-04, -1.221363317405954e-05,  7.403993227935899e-07, -3.206619620916348e-08,
  1.105440921915435e-09, -3.213141658680494e-11,  8.158781666817664e-13, -1.853469732667901e-14,  3.831986999940558e-16, -7.302711539027653e-18,  1.295546231580728e-19,
 -2.155925133152589e-21,  4.916769307018117e-05, -6.182209731916467e-06,  4.189470125948585e-07, -2.012051198105171e-08,  7.642320021333785e-10, -2.434454064173959e-11,
  6.743937590276138e-13, -1.664900667257814e-14,  3.727726571179214e-16, -7.669847955789177e-18,  1.464993977763051e-19, -2.618118642714860e-21,  2.130122080330816e-05,
 -3.002233691136464e-06,  2.261679237834283e-07, -1.199042620519989e-08,  4.998390182356171e-10, -1.738995500996071e-11,  5.239412487063689e-13, -1.401647619971804e-14,
  3.389737721106329e-16, -7.511318643546594e-18,  1.541090961824159e-19, -2.951100014122022e-21,  8.951576970617028e-06, -1.404477863066105e-06,  1.169988073305952e-07,
 -6.817330654833011e-09,  3.107317418811934e-10, -1.176785246929809e-11,  3.844524990685509e-13, -1.111414268779815e-14,  2.895707702939677e-16, -6.893830915127446e-18,
  1.515795764089174e-19, -3.103481901333647e-21,  3.662898982121020e-06, -6.356580426504000e-07,  5.826266007510091e-08, -3.715562922528479e-09,  1.844934731563754e-10,
 -7.580836009784987e-12,  2.677535008725244e-13, -8.341772284068625e-15,  2.335516103508108e-16, -5.959439522689895e-18,  1.401101464308299e-19, -3.060497136485670e-21,
  1.465537855836896e-06, -2.796112305459818e-07,  2.806295946442420e-08, -1.950716311163035e-09,  1.051420692859415e-10, -4.672371484976406e-12,  1.778896815217658e-13,
 -5.956395630438500e-15,  1.787524736355391e-16, -4.877015925913569e-18,  1.223262156509017e-19, -2.844572459026154e-21,  5.759607964311917e-07, -1.201210128672679e-07,
  1.313998517393623e-08, -9.916227704549188e-10,  5.781175662047084e-11, -2.769559681993792e-12,  1.133296988649802e-13, -4.067268531222227e-15,  1.304991692066955e-16,
 -3.797910920856953e-18,  1.013957658029616e-19, -2.504634458580220e-21,  2.234352962107679e-07, -5.065955737878212e-08,  6.012774185757419e-09, -4.906919879475749e-10,
  3.083448156950142e-11, -1.587349687165876e-12,  6.960515723025591e-14, -2.670122521053397e-15,  9.135866534543163e-17, -2.829178056536801e-18,  8.021134318196330e-20,
 -2.100009383644680e-21,  8.601463516412930e-08, -2.108932238952969e-08,  2.703919535317965e-09, -2.376928900278629e-10,  1.604247828831817e-11, -8.845969278428149e-13,
  4.144277151769642e-14, -1.694540841191973e-15,  6.166481985640315e-17, -2.026910167929519e-18,  6.088002500960153e-20, -1.685498181271284e-21,  3.304494083678247e-08,
 -8.716372444424921e-09,  1.201957352297462e-09, -1.133726125708011e-10,  8.189342091523124e-12, -4.820998057262907e-13,  2.405731125312592e-14, -1.045481321433323e-15,
  4.035422845741184e-17, -1.404272633171011e-18,  4.457445694222624e-20, -1.301906091681129e-21,  1.274490198417587e-08, -3.598444357260953e-09,  5.313804184485588e-10,
 -5.356987109510632e-11,  4.126514653842361e-12, -2.584826115628872e-13,  1.369572547448355e-14, -6.307158096245613e-16,  2.574976027018098e-17, -9.461007928101397e-19,
  3.165577034532432e-20, -9.730066944080568e-22,  4.965531858382743e-09, -1.493252441204866e-09,  2.351122856193161e-10, -2.523282332693577e-11,  2.065169033047938e-12,
 -1.371736439068875e-13,  7.692382737357250e-15, -3.742445302022714e-16,  1.611357431080524e-17, -6.233675859839668e-19,  2.192686019064257e-20, -7.074366420715386e-22,
  1.966830421594844e-09, -6.268887081657163e-10,  1.047816890005649e-10, -1.192343021337623e-11,  1.032957948107445e-12, -7.249777548746792e-14,  4.288371840961849e-15,
 -2.197073148123035e-16,  9.946070985170805e-18, -4.039436358797749e-19,  1.489525178251463e-20, -5.030702004981941e-22,  7.971432042200468e-10, -2.679792309356871e-10,
  4.734005948313313e-11, -5.688283186714826e-12,  5.196016184605413e-13, -3.839232341022170e-14,  2.387105448516831e-15, -1.283603808596566e-16,  6.090023409394067e-18,
 -2.588628573145986e-19,  9.977127460122466e-21, -3.517335773240020e-22,  3.326732499859572e-10, -1.173877207145977e-10,  2.181893538337184e-11, -2.756688819970095e-12,
  2.644511622427084e-13, -2.049248178788182e-14,  1.334435893278014e-15, -7.504926273758967e-17,  3.719259602689820e-18, -1.649239747796715e-19,  6.623269280199468e-21,
 -2.429950341507996e-22,  1.438125746787620e-10, -5.300917276229030e-11,  1.031954029282667e-11, -1.364989611748426e-12,  1.369477274604401e-13, -1.108550583245377e-14,
  7.531486666494120e-16, -4.413958296338899e-17,  2.276815719965074e-18, -1.049669488973925e-19,  4.377883726930143e-21, -1.666180939478593e-22,  6.473624993006834e-11,
 -2.480673272245174e-11,  5.034462827522493e-12, -6.940543993051580e-13,  7.251381327607455e-14, -6.106310846948891e-15,  4.311202832909628e-16, -2.622880905366094e-17,
  1.403003280316170e-18, -6.700770606030735e-20,  2.892364298348053e-21, -1.138111528156165e-22,  3.046514805512636e-11, -1.207870111194957e-11,  2.543385698878778e-12,
 -3.637657256912887e-13,  3.940192386392728e-14, -3.436898236009598e-15,  2.511178949880546e-16, -1.579600591882496e-17,  8.728126845164365e-19, -4.302240192649060e-20,
  1.914941904583128e-21, -7.762940282791557e-23,  1.501706751294543e-11, -6.131017820532065e-12,  1.332984772743694e-12, -1.968533448678221e-13,  2.200424122754130e-14,
 -1.979286104435747e-15,  1.490162631302203e-16, -9.651033310730172e-18,  5.486278840014481e-19, -2.780024548492773e-20,  1.271107506870798e-21, -5.289103357790572e-23,
  7.739901142731457e-12, -3.238602299058991e-12,  7.234401311441914e-13, -1.097767432610189e-13,  1.260308545771362e-14, -1.163657211775878e-15,  8.987020699274763e-17,
 -5.966710465671275e-18,  3.474825687371976e-19, -1.802675820387936e-20,  8.433183648363804e-22, -3.587896270478186e-23,  4.135645236342042e-12, -1.765196651123004e-12,
  4.030927664144252e-13, -6.253635749312683e-14,  7.337998203565138e-15, -6.921522225090412e-16,  5.458131626159744e-17, -3.698149157467115e-18,  2.196713148398701e-19,
 -1.161774397860397e-20,  5.537800785362001e-22, -2.399323773729525e-23,  2.238312316652680e-12, -9.699716851159372e-13,  2.252787148958513e-13, -3.555097556517270e-14,
  4.242273411948447e-15, -4.067927079091831e-16,  3.259841118273472e-17, -2.243583982399982e-18,  1.353196479857459e-19, -7.263821010385328e-21,  3.512902028843372e-22,
 -1.543544691375797e-23,  1.151180718352572e-12, -5.041252696344267e-13,  1.184690874620022e-13, -1.891851880881306e-14,  2.284115010476566e-15, -2.215506080789336e-16,
  1.795395788202930e-17, -1.249249211390555e-18,  7.615334065293143e-20, -4.130419570779270e-21,  2.017798234091909e-22, -8.953350883778084e-24,  4.388705651088174e-13,
 -1.933135657732116e-13,  4.572702965046556e-14, -7.350671676649789e-15,  8.932926836839239e-16, -8.720229633505186e-17,  7.110987663362899e-18, -4.978132581211033e-19,
  3.052716114512007e-20, -1.665347034977310e-21,  8.181550150496715e-23, -3.650222503114107e-24,  6.852875980596616e-02, -1.955518446532105e-04,  5.812362035446083e-07,
 -1.785460765863002e-09,  5.617768898244058e-12, -1.796180225798164e-14,  5.797734555943406e-17, -1.880788701186129e-19,  6.111131576479623e-22, -1.985251477094461e-24,
  6.437849905923291e-27, -2.083156186807106e-29,  6.453245522106518e-02, -2.390331441200347e-04,  1.055569580721116e-06, -4.815084563403148e-09,  2.163931661828255e-11,
 -9.498148319265201e-14,  4.077200737152506e-16, -1.716829762644763e-18,  7.110633962084255e-21, -2.903005469097566e-23,  1.170219602761923e-25, -4.663815215068147e-28,
  5.723264722999584e-02, -3.094311174290096e-04,  1.960281778703997e-06, -1.176962264299049e-08,  6.669480428339997e-11, -3.613873558289368e-13,  1.890029766472265e-15,
 -9.599710907368397e-18,  4.755777877168870e-20, -2.305498027715007e-22,  1.096438178859125e-24, -5.125674590535355e-27,  4.781680374501618e-02, -3.808067311294784e-04,
  3.178210839324525e-06, -2.371555200978540e-08,  1.635068446177809e-10, -1.063343083314696e-12,  6.601905968016603e-15, -3.944526887078982e-17,  2.281147815763675e-19,
 -1.282431112674434e-21,  7.032473106833002e-24, -3.771705623773223e-26,  3.764923833314495e-02, -4.284561014963536e-04,  4.499078758841986e-06, -4.079314097266552e-08,
  3.359996938010017e-10, -2.576673865736396e-12,  1.866998015437496e-14, -1.290987422295924e-16,  8.580431256190593e-19, -5.511130987051435e-21,  3.434990536279442e-23,
 -2.084423921591989e-25,  2.795103947371182e-02, -4.377371209730136e-04,  5.648620351538082e-06, -6.135289145820971e-08,  5.955001986124877e-10, -5.315149976206981e-12,
  4.439738741245222e-14, -3.511952557794499e-16,  2.653162931551850e-18, -1.926399067708799e-20,  1.350869325964967e-22, -9.183871020215899e-25,  1.957921196345956e-02,
 -4.074819766077259e-04,  6.368615395868239e-06, -8.191556834657488e-08,  9.267592752127217e-10, -9.530971409506102e-12,  9.091941769898634e-14, -8.154751245699224e-16,
  6.943679695256660e-18, -5.653450693796640e-20,  4.425749221135992e-22, -3.345724665142774e-24,  1.295099451935612e-02, -3.476081834437590e-04,  6.507292605778259e-06,
 -9.814296580151007e-08,  1.282713458274073e-09, -1.507653713150386e-11,  1.630102705545287e-13, -1.646040276236696e-15,  1.569084633000655e-17, -1.423323247109478e-19,
  1.236185173058955e-21, -1.032933232447693e-23,  8.097429067790454e-03, -2.733093150026673e-04,  6.068693158054870e-06, -1.064001695311826e-07,  1.594406854187103e-09,
 -2.127192854137775e-11,  2.590427424343056e-13, -2.927488848139322e-15,  3.106632819812097e-17, -3.122863201971867e-19,  2.993681925423460e-21, -2.751218187627489e-23,
  4.791022991720925e-03, -1.990931737254624e-04,  5.196303269001410e-06, -1.051002139643112e-07,  1.793860988584504e-09, -2.700655676435383e-11,  3.684070497906368e-13,
 -4.636045638364167e-15,  5.450675694302792e-17, -6.044178880786657e-19,  6.367417421793479e-21, -6.408900715893405e-23,  2.686141727262990e-03, -1.349903180548163e-04,
  4.106205284287632e-06, -9.515098010976655e-08,  1.838994821158914e-09, -3.107898617949097e-11,  4.726579648643779e-13, -6.593775976574209e-15,  8.553198600542612e-17,
 -1.042110402677959e-18,  1.201883284179882e-20, -1.320064519687015e-22,  1.429289116194735e-03, -8.554734928591309e-05,  3.008627152204954e-06, -7.937125830087496e-08,
  1.727835822670509e-09, -3.262510526639926e-11,  5.508021078202230e-13, -8.484550397720433e-15,  1.209759512696132e-16, -1.613804849768163e-18,  2.030767445684371e-20,
 -2.426058148205354e-22,  7.230508304347714e-04, -5.086867444810767e-05,  2.052949195939801e-06, -6.130010036577206e-08,  1.495707496835177e-09, -3.141879537664926e-11,
  5.865487928116162e-13, -9.940796765699717e-15,  1.552763814753151e-16, -2.260696566995603e-18,  3.094536314290057e-20, -4.009423241433121e-22,  3.484551852946843e-04,
 -2.848664071580443e-05,  1.310054996946064e-06, -4.403496669399001e-08,  1.198812128925653e-09, -2.790317492157980e-11,  5.739516620545743e-13, -1.066688191530991e-14,
  1.819672536952530e-16, -2.883029075569634e-18,  4.280976015272240e-20, -5.999588965248190e-22,  1.603393755512272e-04, -1.507849200375694e-05,  7.850226721638989e-07,
 -2.955271945755914e-08,  8.938412824713120e-10, -2.296659565318703e-11,  5.187551121023574e-13, -1.053967295801737e-14,  1.957963639849675e-16, -3.366689965604648e-18,
  5.409051119722856e-20, -8.179455660187366e-22,  7.062499371036354e-05, -7.571648313763415e-06,  4.435385746879406e-07, -1.861057701030780e-08,  6.228338806527638e-10,
 -1.760362856513032e-11,  4.352391154493819e-13, -9.638892243207088e-15,  1.944678561453633e-16, -3.619776568190384e-18,  6.277324832925639e-20, -1.021880143647063e-21,
  2.986386894951113e-05, -3.620535992321690e-06,  2.372672829607618e-07, -1.104567486236313e-08,  4.074505732666209e-10, -1.262486780872879e-11,  3.406351293030786e-13,
 -8.199958143874992e-15,  1.792052639059403e-16, -3.602172336284853e-18,  6.727177934551243e-20, -1.176322352153336e-21,  1.216166781192855e-05, -1.655051321949650e-06,
  1.206853761634799e-07, -6.206386978445933e-09,  2.514077432721928e-10, -8.512043483574726e-12,  2.498941972777350e-13, -6.521260046371158e-15,  1.539937549234423e-16,
 -3.334862206908660e-18,  6.692034582802357e-20, -1.254296245066639e-21,  4.786810327064197e-06, -7.262881610852651e-07,  5.862880998445309e-08, -3.316694325136907e-09,
  1.470082887899332e-10, -5.421526729336150e-12,  1.726868825907747e-13, -4.872439706224420e-15,  1.240196036866335e-16, -2.886898191826344e-18,  6.211302511310936e-20,
 -1.245304163016230e-21,  1.828181149651132e-06, -3.073163631233934e-07,  2.732964565344573e-08, -1.693875232059899e-09,  8.186420431949974e-11, -3.278292717537201e-12,
  1.129737246607647e-13, -3.437570502522118e-15,  9.408525482756776e-17, -2.348803362589851e-18,  5.406785731919760e-20, -1.157165676635087e-21,  6.804609509058719e-07,
 -1.259788328329735e-07,  1.228475363642065e-08, -8.309189475277678e-10,  4.363707025497938e-11, -1.891686597218450e-12,  7.033269453963977e-14, -2.301968452522973e-15,
  6.758530703733743e-17, -1.805429281615854e-18,  4.436956740220340e-20, -1.011621326515167e-21,  2.480130724328144e-07, -5.028646624951958e-08,  5.352828268524180e-09,
 -3.935931058713406e-10,  2.238481648988521e-11, -1.047270596919183e-12,  4.189198382206376e-14, -1.471014845966143e-15,  4.621708400151892e-17, -1.318087352213584e-18,
  3.450821169776780e-20, -8.364391533994040e-22,  8.898170636799444e-08, -1.965234671716307e-08,  2.273543830739109e-09, -1.810459403928038e-10,  1.111307323219422e-11,
 -5.593946887339053e-13,  2.400649682415145e-14, -9.020280160372889e-16,  3.025313121392865e-17, -9.190033940955330e-19,  2.557471802289793e-20, -6.576349515509833e-22,
  3.160398828470831e-08, -7.563515994120968e-09,  9.468835578599699e-10, -8.135078290025537e-11,  5.371191523326654e-12, -2.899914569378229e-13,  1.331334790298897e-14,
 -5.338506336220077e-16,  1.906513939006112e-17, -6.153967145073852e-19,  1.816257123803165e-20, -4.943873975387482e-22,  1.118014527293867e-08, -2.884588539196312e-09,
  3.891220793103258e-10, -3.593233359837289e-11,  2.543107539441637e-12, -1.468031538258653e-13,  7.188708747568937e-15, -3.067792251400707e-16,  1.163548105221585e-17,
 -3.981009980000988e-19,  1.243135266722786e-20, -3.573880554391855e-22,  3.965015213747738e-09, -1.097389435239873e-09,  1.588328984305716e-10, -1.570409447348123e-11,
  1.187246883236100e-12, -7.303939302182499e-14,  3.803351892865579e-15, -1.722427520704366e-16,  6.919256342201501e-18, -2.502880425407919e-19,  8.248882466296214e-21,
 -2.498714026549820e-22,  1.419444809185946e-09, -4.193374101729878e-10,  6.484243586989385e-11, -6.837778431691041e-12,  5.502133529844267e-13, -3.595303376335678e-14,
  1.984577350163286e-15, -9.509215159904597e-17,  4.034497540228705e-18, -1.538733836408761e-19,  5.338494207292910e-21, -1.699621214276790e-22,  5.166246788897217e-10,
 -1.621112919057855e-10,  2.666496354177699e-11, -2.987108442315708e-12,  2.548851291546026e-13, -1.762884078535924e-14,  1.028130256757895e-15, -5.195970637574508e-17,
  2.321344062372710e-18, -9.308151288258557e-20,  3.390191554048310e-21, -1.131402969583045e-22,  1.925712457752174e-10, -6.386937917986393e-11,  1.112590688413601e-11,
 -1.318624497140976e-12,  1.188562976194611e-13, -8.669567342121188e-15,  5.323695527865513e-16, -2.828406409025510e-17,  1.326391282358111e-18, -5.574793598866523e-20,
  2.125335201108114e-21, -7.414058778644182e-23,  7.405210169465884e-11, -2.583287769953159e-11,  4.744293367125707e-12, -5.923738002665216e-13,  5.617806245900264e-14,
 -4.305122914860478e-15,  2.773417256092275e-16, -1.543629116397609e-17,  7.573188370683469e-19, -3.325616753577856e-20,  1.323003788370545e-21, -4.809748198601077e-23,
  2.958461682242154e-11, -1.080200004533921e-11,  2.081857261702568e-12, -2.726533129209264e-13,  2.709186799692470e-14, -2.172544488560395e-15,  1.462686438562298e-16,
 -8.497320352731781e-18,  4.345969484937881e-19, -1.987162912568848e-20,  8.222038261523401e-22, -3.105178203148689e-23,  1.235812451817005e-11, -4.699574628656876e-12,
  9.460005000593935e-13, -1.293636726230001e-13,  1.340926789358200e-14, -1.120541473801378e-15,  7.852615680391784e-17, -4.743100747529644e-18,  2.519466804929810e-19,
 -1.195186762880340e-20,  5.125265723740522e-22, -2.003985632952373e-23,  5.425677108613110e-12, -2.138399284825006e-12,  4.473927620128857e-13, -6.358025851679530e-14,
  6.843903575025195e-15, -5.933546181223846e-16,  4.309879077312610e-17, -2.695583492341237e-18,  1.481225588187807e-19, -7.262124575028153e-21,  3.215623353104106e-22,
 -1.297031916516460e-23,  2.511431682620417e-12, -1.020806058959291e-12,  2.208690873925712e-13, -3.246063492601861e-14,  3.611341438833004e-15, -3.233503163012507e-16,
  2.423587703427845e-17, -1.562849912074972e-18,  8.847014639584346e-20, -4.464762746766036e-21,  2.033370996336322e-22, -8.428631640085731e-24,  1.224943199575216e-12,
 -5.109534156409455e-13,  1.137453562016081e-13, -1.720079015090981e-14,  1.968115243920878e-15, -1.811221826245205e-16,  1.394361217454278e-17, -9.228858246023377e-19,
  5.358453373322685e-20, -2.771765561991571e-21,  1.293006495725421e-22, -5.486042033851551e-24,  6.249036634234027e-13, -2.661816195345010e-13,  6.064702323119838e-14,
 -9.387580012607463e-15,  1.099088072331578e-15, -1.034460179850806e-16,  8.140271732884244e-18, -5.504121178320354e-19,  3.262956502136530e-20, -1.722341548053545e-21,
  8.194431661194195e-23, -3.543890857692442e-24,  3.261040499205879e-13, -1.411489805742480e-13,  3.273877326520197e-14, -5.159575090062925e-15,  6.148798225878410e-16,
 -5.888528779955895e-17,  4.712879629820359e-18, -3.239687324824869e-19,  1.951672762369096e-20, -1.046431781463162e-21,  5.055049266214813e-23, -2.218743039635973e-24,
  1.634466847325109e-13, -7.153401808276599e-14,  1.679921516810284e-14, -2.680883872942742e-15,  3.234590577745805e-16, -3.135381519834009e-17,  2.539218746059971e-18,
 -1.765704708628736e-19,  1.075706181891478e-20, -5.830974514203221e-22,  2.846907795551853e-23, -1.262516138074385e-24,  6.141221094858198e-14, -2.704375716032061e-14,
  6.395123677776321e-15, -1.027713250988196e-15,  1.248556824577755e-16, -1.218466699608803e-17,  9.933192707723283e-19, -6.951855402778724e-20,  4.261850637052501e-21,
 -2.324322006010702e-22,  1.141587144676840e-23, -5.091869187084309e-25,  6.775571863342772e-02, -1.909861559279608e-04,  5.603383654768876e-07, -1.698376500976648e-09,
  5.272031999725094e-12, -1.663139498361079e-14,  5.297451593729174e-17, -1.696187913543252e-19,  5.440668157285820e-22, -1.745158599152738e-24,  5.588426118350729e-27,
 -1.786007361910447e-29,  6.359285393485889e-02, -2.308139666361464e-04,  9.998049312153598e-07, -4.483536761532651e-09,  1.983377490249068e-11, -8.574827849399638e-14,
  3.626835095434243e-16, -1.505146014201452e-18,  6.145089428016226e-21, -2.473488272153966e-23,  9.831851869627561e-26, -3.864342126881801e-28,  5.602541768363453e-02,
 -2.942961978374120e-04,  1.825218233561947e-06, -1.075795154322949e-08,  5.989974945070956e-11, -3.190875523195175e-13,  1.641353897983209e-15, -8.202616146029233e-18,
  3.999596279356684e-20, -1.908884969041659e-22,  8.939718653173204e-25, -4.116306257971410e-27,  4.634268653591546e-02, -3.564764792056650e-04,  2.908645960825508e-06,
 -2.126132971044946e-08,  1.437390673190199e-10, -9.173668825329143e-13,  5.593062402334133e-15, -3.283307141905637e-17,  1.866348575376767e-19, -1.031701870263511e-21,
  5.564754866878681e-24, -2.936394896550538e-26,  3.600442296088194e-02, -3.943339145306868e-04,  4.040192066337329e-06, -3.580624349347534e-08,  2.886695061082214e-10,
 -2.169043102576679e-12,  1.541158407150892e-14, -1.045675399286918e-16,  6.823135471563884e-19, -4.304369067442670e-21,  2.636065168970682e-23, -1.572268746678148e-25,
  2.628602457058153e-02, -3.953388397152818e-04,  4.966224471702802e-06, -5.262059671338976e-08,  4.991030540572853e-10, -4.358625825891531e-12,  3.565528191828111e-14,
 -2.764214194593675e-16,  2.047913754866227e-18, -1.458969731667578e-20,  1.004298476086794e-22, -6.705001555874429e-25,  1.804529402105024e-02, -3.602266757938982e-04,
  5.468670893674328e-06, -6.850115098164964e-08,  7.562332159599234e-10, -7.599561856162865e-12,  7.091370591203725e-14, -6.226930537225213e-16,  5.194541957356551e-18,
 -4.145952060626300e-20,  3.183280889494468e-22, -2.361317317928828e-24,  1.165768359994578e-02, -2.999334160622526e-04,  5.443415063661541e-06, -7.983393798704161e-08,
  1.016846276007087e-09, -1.166503619584866e-11,  1.232435562349980e-13, -1.217196442931843e-15,  1.135729427101721e-17, -1.009084691675904e-19,  8.589198322828229e-22,
 -7.037321819621115e-24,  7.093776713764087e-03, -2.294635685277229e-04,  4.931937345987737e-06, -8.398135069979832e-08,  1.225038314131472e-09, -1.593581979357494e-11,
  1.894526812608662e-13, -2.092308887959433e-15,  2.171640404775075e-17, -2.136638689110554e-19,  2.006023547941218e-21, -1.806547077109184e-23,  4.070441934963879e-03,
 -1.621177620374652e-04,  4.090930594577642e-06, -8.027991484843187e-08,  1.332572285849427e-09, -1.954387788377267e-11,  2.600666003144425e-13, -3.195850823677170e-15,
  3.672503083903979e-17, -3.983428538364093e-19,  4.107552017924573e-21, -4.049146141573645e-23,  2.205296846242407e-03, -1.062512424326071e-04,  3.122262372761035e-06,
 -7.014097661645878e-08,  1.317360881025705e-09, -2.167302866784051e-11,  3.213117161281957e-13, -4.374509341030938e-15,  5.543070849817156e-17, -6.602613697824019e-19,
  7.449963041977937e-21, -8.010378068242292e-23,  1.129809070736734e-03, -6.486347616773696e-05,  2.202635159306274e-06, -5.630119502006912e-08,  1.190335128214936e-09,
 -2.186776805829139e-11,  3.597053836019171e-13, -5.404849296678896e-15,  7.524611321727787e-17, -9.809231892439190e-19,  1.207165600467549e-20, -1.411304615689494e-22,
  5.482816325255949e-04, -3.702387250808398e-05,  1.442440881422351e-06, -4.171634827009134e-08,  9.881688287999300e-10, -2.018769457310739e-11,  3.670575615896886e-13,
 -6.065948220765821e-15,  9.248438570342982e-17, -1.315439710331483e-18,  1.760455100351056e-20, -2.231585708432503e-22,  2.525328339114406e-04, -1.983181256801555e-05,
  8.804782039277072e-07, -2.866087983481737e-08,  7.573374365449129e-10, -1.713966335400726e-11,  3.432846410566700e-13, -6.219650806591011e-15,  1.035418551401460e-16,
 -1.602336945766499e-18,  2.325803623768207e-20, -3.188508647499469e-22,  1.106419585914563e-04, -1.000468164700977e-05,  5.029857172200222e-07, -1.833835786383972e-08,
  5.383396766402703e-10, -1.344844013873664e-11,  2.957538136575031e-13, -5.857414668926371e-15,  1.061796750119805e-16, -1.783158400396735e-18,  2.800311922738273e-20,
 -4.142141343729318e-22,  4.622864916636246e-05, -4.770715837827001e-06,  2.700004346413213e-07, -1.097476232257986e-08,  3.565376869759453e-10, -9.798399832380576e-12,
  2.358856203016360e-13, -5.092530690717063e-15,  1.002611264671777e-16, -1.822793446886580e-18,  3.089953060762862e-20, -4.920611951715935e-22,  1.847290441068817e-05,
 -2.158412541179772e-06,  1.367526219922892e-07, -6.170031820735401e-09,  2.210090070624114e-10, -6.660294278867615e-12,  1.750131670383792e-13, -4.107804114213769e-15,
  8.762038597943983e-17, -1.720541411600532e-18,  3.141446124076210e-20, -5.374529283860530e-22,  7.082559860533721e-06, -9.301851503799100e-07,  6.563319499613843e-08,
 -3.273250604493668e-09,  1.288179246821649e-10, -4.243709871610135e-12,  1.213789330961466e-13, -3.089453730214643e-15,  7.122729749952010e-17, -1.507295312851367e-18,
  2.958024890138286e-20, -5.426087132420397e-22,  2.614832974863799e-06, -3.834518041707105e-07,  2.998279597921953e-08, -1.646220041256882e-09,  7.093692737358253e-11,
 -2.546942085976255e-12,  7.907861114290443e-14, -2.177299586828378e-15,  5.413168653045395e-17, -1.231847791512592e-18,  2.593058033080941e-20, -5.090081622499851e-22,
  9.333552006752393e-07, -1.518847274178680e-07,  1.309902960758666e-08, -7.887333897188844e-10,  3.708969295207095e-11, -1.447089531508488e-12,  4.864296907423732e-14,
 -1.445233388822930e-15,  3.865925485977262e-17, -9.440328373337142e-19,  2.127250512029636e-20, -4.459882227328839e-22,  3.235539679499107e-07, -5.808842413856085e-08,
  5.500698133874879e-09, -3.618637331614262e-10,  1.850902746953773e-11, -7.824461639979071e-13,  2.839978369855186e-14, -9.083113908552235e-16,  2.608247299269280e-17,
 -6.820034562909121e-19,  1.641798514413770e-20, -3.669287786244930e-22,  1.094712641238156e-07, -2.156359520827068e-08,  2.232320126644400e-09, -1.598499426353167e-10,
  8.864566495018933e-12, -4.048498517389178e-13,  1.582483744954478e-14, -5.434979319412596e-16,  1.671547427669695e-17, -4.670113537220931e-19,  1.198610036353931e-20,
 -2.850044288539573e-22,  3.634827373841595e-08, -7.814157135240942e-09,  8.805918768354706e-10, -6.838647345447041e-11,  4.098402420936202e-12, -2.016257407847918e-13,
  8.464696224033845e-15, -3.114075800232225e-16,  1.023401923702622e-17, -3.048405124512367e-19,  8.324062416784650e-21, -2.101622960678959e-22,  1.191519221115464e-08,
 -2.781292156458256e-09,  3.397624252418945e-10, -2.851186389350429e-11,  1.840569097800386e-12, -9.724978773503724e-14,  4.373057532600690e-15, -1.718916346779116e-16,
  6.021822291986120e-18, -1.908044054323168e-19,  5.531301516426690e-21, -1.479775162552059e-22,  3.881357743104569e-09, -9.788025430960125e-10,  1.290776797838159e-10,
 -1.166170667485258e-11,  8.082229064377537e-13, -4.572488422958374e-14,  2.196118364806829e-15, -9.198797947253870e-17,  3.426731488009359e-18, -1.152258127073176e-19,
  3.538244569654676e-21, -1.000846046624735e-22,  1.265277901434061e-09, -3.430142289447258e-10,  4.862761477396743e-11, -4.712353232770515e-12,  3.494420600631507e-13,
 -2.110178768172760e-14,  1.079338696609688e-15, -4.804447387161652e-17,  1.898177978386379e-18, -6.756775667432545e-20,  2.192541829077194e-21, -6.542583184785438e-23,
  4.158801318105850e-10, -1.206072000241093e-10,  1.830323155754091e-11, -1.895281560183129e-12,  1.498505472046105e-13, -9.627401421703562e-15,  5.228220157556175e-16,
 -2.466006151113451e-17,  1.030479132343043e-18, -3.872899050087152e-20,  1.324720078161914e-21, -4.160036084507354e-23,  1.389204199490658e-10, -4.288615242638098e-11,
  6.937325993425156e-12, -7.645882344802021e-13,  6.422139166284913e-14, -4.374780310195142e-15,  2.514255783057193e-16, -1.252788014212540e-17,  5.520891447442931e-19,
 -2.184690036123869e-20,  7.855875329461679e-22, -2.589511663111664e-23,  4.754888403856142e-11, -1.554884883044209e-11,  2.669230683076282e-12, -3.118523290693758e-13,
  2.772163595298398e-14, -1.995099448733674e-15,  1.209341890409002e-16, -6.345081210189266e-18,  2.939736644239402e-19, -1.221180665593898e-20,  4.603172618770170e-22,
 -1.588288393248951e-23,  1.681511105477422e-11, -5.795795639150698e-12,  1.051117361252137e-12, -1.296307428028443e-13,  1.214690465928890e-14, -9.201067452858586e-16,
  5.861223154750083e-17, -3.226992862878570e-18,  1.566646144108937e-19, -6.810040132839713e-21,  2.682657674287010e-22, -9.660423107383711e-24,  6.194233750547945e-12,
 -2.239177317157700e-12,  4.270226114024566e-13, -5.534620265209581e-14,  5.443949878941231e-15, -4.322920595146984e-16,  2.882902891308896e-17, -1.659452392181147e-18,
  8.412066916280153e-20, -3.813351092796791e-21,  1.564691976887683e-22, -5.861826671021354e-24,  2.395045869754586e-12, -9.034757468601880e-13,  1.803048556964551e-13,
 -2.444688959416542e-14,  2.513064802499321e-15, -2.083149471150522e-16,  1.448471468395421e-17, -8.682980042148648e-19,  4.578577512933325e-20, -2.156622098183566e-21,
  9.184762716063325e-23, -3.567458943461651e-24,  9.783676827147419e-13, -3.831801113681907e-13,  7.962574022683754e-14, -1.123974866888368e-14,  1.201920143322127e-15,
 -1.035391278445007e-16,  7.474083463667953e-18, -4.646565714579766e-19,  2.538450539858790e-20, -1.237538019438274e-21,  5.449839293689670e-23, -2.186612389345346e-24,
  4.241177564760513e-13, -1.715796393332446e-13,  3.693456534199879e-14, -5.400553408889067e-15,  5.978337523269346e-16, -5.326902252691322e-17,  3.973853492553891e-18,
 -2.550846244252920e-19,  1.437602121457570e-20, -7.223948059577303e-22,  3.276306216395208e-23, -1.352621664756119e-24,  1.952565399361748e-13, -8.117640596205828e-14,
  1.800525434982502e-14, -2.712887949339479e-15,  3.093022852258272e-16, -2.836571660727374e-17,  2.176356533288931e-18, -1.435750110251150e-19,  8.309776732364750e-21,
 -4.285161734461352e-22,  1.993025217731512e-23, -8.431699393242871e-25,  9.488170344799806e-14, -4.032805384022551e-14,  9.166384899423186e-15, -1.415465428495995e-15,
  1.653308876347909e-16, -1.552517638038326e-17,  1.218962648945711e-18, -8.224246482497715e-20,  4.865233393419561e-21, -2.562848652388326e-22,  1.216914531835730e-23,
 -5.252751975481099e-25,  4.764872563712997e-14, -2.059796255829681e-14,  4.770870451026019e-15, -7.508179789279188e-16,  8.935242557153088e-17, -8.545396935708769e-18,
  6.830247786018149e-19, -4.689144132065413e-20,  2.821327357126982e-21, -1.510875657194888e-22,  7.290032476507764e-24, -3.196047878220334e-25,  2.324072650261678e-14,
 -1.016513453971588e-14,  2.385520315125771e-15, -3.804196054815118e-16,  4.586684705374385e-17, -4.442942886762742e-18,  3.595738326742433e-19, -2.498738307372650e-20,
  1.521311768764733e-21, -8.241278563839015e-23,  4.021264350899620e-24, -1.782253136961335e-25,  8.599166930753396e-15, -3.785735692437367e-15,  8.949486188578354e-16,
 -1.437754329872240e-16,  1.746165207543164e-17, -1.703557110098894e-18,  1.388353406544948e-19, -9.713647007210783e-21,  5.953228699064639e-22, -3.245829709539900e-23,
  1.593734305781572e-24, -7.106637195755168e-26,  6.700061233863615e-02, -1.865835619222846e-04,  5.404532052522963e-07, -1.616617513514314e-09,  4.951743215137485e-12,
 -1.541508771510182e-14,  4.845978582930340e-17, -1.531722122907542e-19,  4.850824644250768e-22, -1.536566898742249e-24,  4.859494925407666e-27, -1.534138192502285e-29,
  6.268526164653559e-02, -2.230254694984836e-04,  9.478514323669870e-07, -4.179457087847522e-09,  1.820255114793848e-11, -7.752817912745054e-14,  3.231637809092961e-16,
 -1.322023455753153e-18,  5.321510960480487e-21, -2.112199689808336e-23,  8.280194904779781e-26, -3.210112722323155e-28,  5.487664115881300e-02, -2.801950123960661e-04,
  1.701669319009324e-06, -9.848544800798289e-09,  5.389404117709662e-11, -2.823126238526435e-13,  1.428612975915593e-15, -7.026134746367087e-18,  3.372627854745440e-20,
 -1.585030482418612e-22,  7.311210801095615e-25, -3.316431094278353e-27,  4.496175650866063e-02, -3.341901068360800e-04,  2.666726291960861e-06, -1.910129083520661e-08,
  1.266629468390300e-10, -7.935232681296409e-13,  4.752057501908583e-15, -2.741446073790362e-17,  1.532073697143539e-19, -8.329415345601258e-22,  4.419913133511988e-24,
 -2.295132890939343e-26,  3.448911576229676e-02, -3.636557307287467e-04,  3.636860330067870e-06, -3.151543444570939e-08,  2.487624339997621e-10, -1.831968758589686e-12,
  1.276745033395493e-14, -8.502211415728400e-17,  5.447796980857201e-19, -3.376277664041930e-21,  2.032080568865844e-23, -1.191551518169472e-25,  2.478031292400709e-02,
 -3.580054121373761e-04,  4.379958236607606e-06, -4.528833774978518e-08,  4.198971899483083e-10, -3.588830356714826e-12,  2.875919875292990e-14, -2.185707505257744e-16,
  1.588408660571012e-18, -1.110580689863961e-20,  7.506077553481284e-23, -4.922278045067440e-25,  1.668695585120258e-02, -3.195706471272726e-04,  4.714523878433998e-06,
 -5.753048488985680e-08,  6.199405282596427e-10, -6.089370344559578e-12,  5.559748684173091e-14, -4.780806262471022e-16,  3.908187656179442e-18, -3.058492179088203e-20,
  2.303738051599260e-22, -1.677189442901988e-24,  1.053934553818025e-02, -2.599582837961548e-04,  4.575816734802844e-06, -6.528098338776919e-08,  8.105622228162269e-10,
 -9.078234597779299e-12,  9.374799222389955e-14, -9.058170691032090e-16,  8.275007830019423e-18, -7.203061517910426e-20,  6.010119399506960e-22, -4.829429208748596e-24,
  6.248891241604944e-03, -1.937286750283064e-04,  4.031996210409915e-06, -6.670201441705479e-08,  9.474227806049751e-10, -1.202003453923006e-11,  1.395426493011350e-13,
 -1.506399523429495e-15,  1.529576370647411e-17, -1.473299381453267e-19,  1.355003037789239e-21, -1.196011556807752e-23,  3.481799646779480e-03, -1.329089388444518e-04,
  3.243620389613561e-06, -6.177484641526553e-08,  9.974964788304940e-10, -1.425548507263976e-11,  1.850871400422264e-13, -2.221570633625375e-15,  2.495764533954909e-17,
 -2.648478981603773e-19,  2.673674419092636e-21, -2.581849876307072e-23,  1.825382987378291e-03, -8.431200204904881e-05,  2.393984635346821e-06, -5.215019821345101e-08,
  9.520433955306832e-10, -1.525101054404609e-11,  2.204583699637806e-13, -2.929777919763830e-15,  3.627170041840607e-17, -4.224691185451469e-19,  4.664448497620711e-21,
 -4.910649572514052e-23,  9.017352528483991e-04, -4.965150961397004e-05,  1.628250003015977e-06, -4.033256638358057e-08,  8.283298294823159e-10, -1.480835373760640e-11,
  2.373712111822470e-13, -3.479724848320111e-15,  4.730957615091292e-17, -6.027940200065292e-19,  7.255880399160317e-21, -8.302717610289585e-23,  4.204373494455143e-04,
 -2.724578791173549e-05,  1.024791045463300e-06, -2.870928242403244e-08,  6.603101253499199e-10, -1.312138267061697e-11,  2.323928210484063e-13, -3.745379358083877e-15,
  5.574550634504306e-17, -7.747013931670543e-19,  1.013777575747568e-20, -1.257431898090053e-22,  1.853748128201912e-04, -1.398112616699499e-05,  5.992429542805665e-07,
 -1.889128342745899e-08,  4.845564903615510e-10, -1.066372799992449e-11,  2.079861996933328e-13, -3.673994368209998e-15,  5.969314561489020e-17, -9.023703441041125e-19,
  1.280465679441354e-20, -1.717333985499810e-22,  7.745990932165406e-05, -6.732795912245140e-06,  3.268420740436119e-07, -1.154055563142963e-08,  3.288253024189029e-10,
 -7.986880142592561e-12,  1.710208569637052e-13, -3.301854564102560e-15,  5.840822470186842e-17, -9.580647623378552e-19,  1.470724404784165e-20, -2.128066018941272e-22,
  3.075123785016510e-05, -3.053634511173002e-06,  1.669420363472828e-07, -6.572967142633999e-09,  2.072767508890870e-10, -5.538739668491772e-12,  1.298298335257396e-13,
 -2.732370559634252e-15,  5.249505899588449e-17, -9.321734167244501e-19,  1.544668649273428e-20, -2.406282446398886e-22,  1.163154987000114e-05, -1.309252887569357e-06,
  8.017799257523851e-08, -3.505379765065206e-09,  1.219126127848214e-10, -3.572949977701962e-12,  9.143025847732372e-14, -2.092289059086010e-15,  4.355645738028948e-17,
 -8.354873900050794e-19,  1.491361063001090e-20, -2.496283115681372e-22,  4.205282381466695e-06, -5.327484694377307e-07,  3.636210117993935e-08, -1.758227330019929e-09,
  6.721251510023900e-11, -2.154113815909297e-12,  6.001860701992808e-14, -1.489835020842158e-15,  3.353139099741905e-17, -6.933288056450403e-19,  1.330536915113206e-20,
 -2.388456482229771e-22,  1.458507044053223e-06, -2.066047868649096e-07,  1.564197019483846e-08, -8.332899481683768e-10,  3.489952032721729e-11, -1.219661633290613e-12,
  3.690615464622994e-14, -9.914143456754275e-16,  2.407183463161672e-17, -5.354447079946401e-19,  1.102586815605909e-20, -2.118783125394023e-22,  4.872460373145788e-07,
 -7.671010206903647e-08,  6.412915079278576e-09, -3.749970324157890e-10,  1.715230975184940e-11, -6.518255242265588e-13,  2.136689140804770e-14, -6.197300930636956e-16,
  1.619833353428354e-17, -3.868341549046240e-19,  8.531240524436673e-21, -1.751804098064791e-22,  1.575071408679372e-07, -2.740348540886690e-08,  2.518649192775666e-09,
 -1.610791974885715e-10,  8.021455003689182e-12, -3.305615422759546e-13,  1.170926653956094e-14, -3.658488221564459e-16,  1.027210823808548e-17, -2.628430546775596e-19,
  6.196597964704206e-21, -1.357199546572495e-22,  4.952019486774268e-08, -9.469847998539913e-09,  9.528660221432555e-10, -6.641462513167983e-11,  3.589678773846966e-12,
 -1.599738542878798e-13,  6.108117187850211e-15, -2.051112700022699e-16,  6.173135382008348e-18, -1.689076588548741e-19,  4.248602645817509e-21, -9.907428805344389e-23,
  1.522862133568217e-08, -3.184370708645914e-09,  3.493413168124247e-10, -2.644340943508815e-11,  1.546486066250531e-12, -7.432378485671604e-14,  3.051165975966369e-15,
 -1.098600262094412e-16,  3.536411982014149e-18, -1.032563294344092e-19,  2.765687381165763e-21, -6.853760296848069e-23,  4.609583470984813e-09, -1.048674315764252e-09,
  1.249221762464002e-10, -1.023336982402824e-11,  6.455485976882495e-13, -3.336348623755439e-14,  1.468794392678896e-15, -5.656899416498232e-17,  1.943237318138569e-18,
 -6.041735966918873e-20,  1.719710721061178e-21, -4.520087173525172e-23,  1.382868860129121e-09, -3.405902569395425e-10,  4.387789237102512e-11, -3.876131664542829e-12,
  2.629110578177895e-13, -1.456967914239063e-14,  6.860000419088132e-16, -2.819002988285231e-17,  1.030959507001528e-18, -3.405555154063266e-20,  1.027928729787615e-21,
 -2.859772944640801e-23,  4.142696407663996e-10, -1.099222706426415e-10,  1.525267021952150e-11, -1.447790059064936e-12,  1.052432448566923e-13, -6.234833978496984e-15,
  3.130872118786097e-16, -1.369138378676442e-17,  5.317551544079098e-19, -1.861836591690475e-20,  5.945895071286354e-22, -1.747109384469179e-23,  1.249371604003476e-10,
 -3.554106916593033e-11,  5.289846187439129e-12, -5.375262499602108e-13,  4.173411029629675e-14, -2.634766482301290e-15,  1.406911055402350e-16, -6.529049193731531e-18,
  2.685871564338037e-19, -9.942707397325559e-21,  3.351454947110591e-22, -1.037676385645711e-23,  3.826166840096928e-11, -1.161223947293856e-11,  1.846056480597795e-12,
 -2.000464300164632e-13,  1.653036285762794e-14, -1.108437814160379e-15,  6.274240724992086e-17, -3.080761401403055e-18,  1.338560136725852e-19, -5.224850989084307e-21,
  1.854085603377780e-22, -6.033902566343086e-24,  1.200728180974258e-11, -3.868728425028319e-12,  6.540667261680853e-13, -7.528316451639833e-14,  6.596086712420254e-15,
 -4.681285626509821e-16,  2.799578794349160e-17, -1.449856688520783e-18,  6.633338499150081e-20, -2.722207921387323e-21,  1.014118576985680e-22, -3.459580132440108e-24,
  3.897544402093852e-12, -1.326532361023172e-12,  2.374305947529943e-13, -2.890541075155735e-14,  2.674783207798570e-15, -2.001664714503555e-16,  1.260226201352761e-17,
 -6.860196776680741e-19,  3.294213563563927e-20, -1.416867229381348e-21,  5.524492006692483e-23, -1.969794942121769e-24,  1.320859969672781e-12, -4.724841399842113e-13,
  8.911129562776167e-14, -1.142413617207238e-14,  1.111819208349643e-15, -8.738294771184532e-17,  5.769718562394092e-18, -3.289325509327956e-19,  1.651959091010526e-20,
 -7.421458147046446e-22,  3.018719838114809e-23, -1.121414302545394e-24,  4.715397833769322e-13, -1.763678371279094e-13,  3.487923088738078e-14, -4.686873420732030e-15,
  4.775990070718628e-16, -3.925497374619740e-17,  2.707170039914158e-18, -1.609980587151602e-19,  8.424420397368809e-21, -3.938658726849310e-22,  1.665367120576544e-23,
 -6.423536064040939e-25,  1.787352986474626e-13, -6.953693229645972e-14,  1.434660403845512e-14, -2.010754241020184e-15,  2.135297508852099e-16, -1.827068917085314e-17,
  1.310286781801396e-18, -8.094463941821818e-20,  4.395007612643409e-21, -2.129947047872289e-22,  9.325982015819425e-24, -3.721064434029467e-25,  7.236098981542456e-14,
 -2.912836747944581e-14,  6.236303911274637e-15, -9.069570018751638e-16,  9.986993545864200e-17, -8.853165762528674e-18,  6.571613875877694e-19, -4.198049337871390e-20,
  2.354888894161033e-21, -1.177980890319507e-22,  5.319138825021984e-24, -2.186704491668203e-25,  3.136030218806156e-14, -1.299190743391472e-14,  2.870534442775473e-15,
 -4.308419447095929e-16,  4.893572953807940e-17, -4.471334728619876e-18,  3.418380592338048e-19, -2.247309834194167e-20,  1.296322959126613e-21, -6.663089924638797e-23,
  3.089223151226343e-24, -1.302942020107558e-25,  1.448022794623042e-14, -6.140452906720675e-15,  1.392150117175069e-15, -2.144274346600756e-16,  2.498324591214630e-17,
 -2.340306179954289e-18,  1.833147672364624e-19, -1.233968698325187e-20,  7.283538047910312e-22, -3.828436055119235e-23,  1.814038241801191e-24, -7.814314849276857e-26,
  6.983625124217275e-15, -3.014887363143860e-15,  6.972614501313230e-16, -1.095672920496747e-16,  1.302002099505137e-17, -1.243402634216784e-18,  9.924457418145046e-20,
 -6.804114135837259e-21,  4.088424630247486e-22, -2.186614542782288e-23,  1.053731633792011e-24, -4.614110073566232e-26,  3.309786703670423e-15, -1.446687188046827e-15,
  3.392507718168788e-16, -5.405974822684260e-17,  6.513099890054313e-18, -6.304402028806423e-19,  5.098623790331196e-20, -3.540666599342073e-21,  2.154217311002288e-22,
 -1.166219917368446e-23,  5.686832519009033e-25, -2.518877983003338e-26,  1.204906425919687e-15, -5.303025726987164e-16,  1.253232725716020e-16, -2.012686534198233e-17,
  2.443629899277579e-18, -2.383237365734866e-19,  1.941660977706833e-20, -1.358066047339316e-21,  8.320680182399562e-23, -4.535259791122446e-24,  2.226204194119195e-25,
 -9.924043277376325e-27,  6.626280435038606e-02, -1.823362100742560e-04,  5.215191892652709e-07, -1.539794271829409e-09,  4.654733267964054e-12, -1.430181446339410e-14,
  4.438022494423693e-17, -1.384984013029251e-19,  4.331082218016138e-22, -1.355032573880271e-24,  4.232794205516904e-27, -1.320226633916358e-29,  6.180801459050828e-02,
 -2.156384360519495e-04,  8.993955550943280e-07, -3.900211620816565e-09,  1.672664507159357e-11, -7.019788609658660e-14,  2.884212511837545e-16, -1.163288764674346e-18,
  4.617484750221358e-21, -1.807583873464885e-23,  6.989668264048285e-26, -2.673298662192230e-28,  5.378235947333693e-02, -2.670401461506095e-04,  1.588480139856736e-06,
 -9.029612010762198e-09,  4.857532915650478e-11, -2.502698169754553e-13,  1.246171404544646e-15, -6.032820711594325e-18,  2.851322865913267e-20, -1.319788928124336e-22,
  5.997148913859188e-25, -2.680423974141100e-27,  4.366625910141604e-02, -3.137398732913127e-04,  2.449166102306472e-06, -1.719570208753981e-08,  1.118735491350416e-10,
 -6.881576832268087e-13,  4.048813921726983e-15, -2.295935825238352e-17,  1.261747046125042e-19, -6.747939320970491e-22,  3.523428999934891e-24, -1.800820762515739e-26,
  3.309037941667444e-02, -3.360086058656004e-04,  3.281399011403020e-06, -2.781247710236360e-08,  2.150041406527006e-10, -1.552254401017041e-12,  1.061368180367460e-14,
 -6.938672899541416e-17,  4.366839666015843e-19, -2.659329597516075e-21,  1.573343544738618e-23, -9.071647121264347e-26,  2.341508303688245e-02, -3.250305957217231e-04,
  3.874555718030713e-06, -3.910867556621686e-08,  3.545552607912145e-10, -2.966655381288631e-12,  2.329461861041340e-14, -1.735989980744499e-16,  1.237802544757055e-18,
 -8.495555014220023e-21,  5.638926719636742e-23, -3.632941603854817e-25,  1.547995974892490e-02, -2.844561019786520e-04,  4.079876358819417e-06, -4.851754607855153e-08,
  5.104811708880230e-10, -4.902490933952542e-12,  4.380846217586797e-14, -3.689919711038476e-16,  2.956633296547198e-18, -2.269263047474570e-20,  1.677188347733470e-22,
 -1.198651461655231e-24,  9.568058129886989e-03, -2.262778096072873e-04,  3.864640934215645e-06, -5.365037215034319e-08,  6.495877042803447e-10, -7.104954769542867e-12,
  7.173330751917827e-14, -6.782525942704772e-16,  6.067886871354818e-18, -5.175849135638335e-20,  4.234319314038352e-22, -3.337684545733439e-24,  5.533760256915694e-03,
 -1.644338586522588e-04,  3.315143910745913e-06, -5.329789696392865e-08,  7.373621465856959e-10, -9.126402493171417e-12,  1.034876294549913e-13, -1.092285810321975e-15,
  1.085268476428425e-17, -1.023598944230662e-19,  9.223911959445531e-22, -7.981413010527239e-24,  2.997723254601408e-03, -1.096740483692493e-04,  2.589400971210865e-06,
 -4.787405843540139e-08,  7.522007130027900e-10, -1.047771804951357e-11,  1.327660489082880e-13, -1.556872358101320e-15,  1.710249112304022e-17, -1.775991165065945e-19,
  1.755597472871137e-21, -1.661008047865878e-23,  1.522812534531292e-03, -6.742582196771768e-05,  1.850373074263748e-06, -3.909588776459705e-08,  6.939110413346854e-10,
 -1.082611958272054e-11,  1.526220704107276e-13, -1.980257688529483e-15,  2.395816613811807e-17, -2.729132169060442e-19,  2.949004597955585e-21, -3.040384724558198e-23,
  7.264066887012563e-04, -3.835681755262586e-05,  1.214924383795714e-06, -2.916938130129854e-08,  5.820456250118091e-10, -1.012777320459331e-11,  1.582327416039802e-13,
 -2.263457511578976e-15,  3.005768610202061e-17, -3.743830902081073e-19,  4.408543974409384e-21, -4.938176904868025e-23,  3.258984934328275e-04, -2.026403978051574e-05,
  7.359015799468870e-07, -1.997303536987981e-08,  4.461040369557083e-10, -8.624044742680568e-12,  1.488044693582992e-13, -2.339170457007069e-15,  3.399241094991273e-17,
 -4.616229449322211e-19,  5.907535081947863e-21, -7.170586088752325e-23,  1.377691826853242e-04, -9.976770691744581e-06,  4.128184559176118e-07, -1.260480748721838e-08,
  3.138659539085307e-10, -6.717487701769510e-12,  1.276007122928825e-13, -2.197841349387732e-15,  3.485491333248199e-17, -5.147433027993496e-19,  7.141339586933844e-21,
 -9.370838673934445e-23,  5.499303152897485e-05, -4.593398608518571e-06,  2.152961294771242e-07, -7.362245863793031e-09,  2.036138402758192e-10, -4.808820153948697e-12,
  1.002651587690016e-13, -1.887206767089110e-15,  3.257943606804700e-17, -5.219915278385279e-19,  7.833312386216091e-21, -1.108813894125275e-22,  2.077796463272238e-05,
 -1.984656867378149e-06,  1.047941892287052e-07, -3.996395395563984e-09,  1.223275694315872e-10, -3.178284949974534e-12,  7.253980819700094e-14, -1.488264382852542e-15,
  2.790268083000505e-17, -4.839552783106159e-19,  7.839268708706993e-21, -1.194641800486198e-22,  7.451499138795901e-06, -8.076717368511788e-07,  4.779679481443882e-08,
 -2.024629229265150e-09,  6.836105312459009e-11, -1.948284530644804e-12,  4.854884055885196e-14, -1.083142654587678e-15,  2.200579819886541e-17, -4.123241277872684e-19,
  7.195283486845723e-21, -1.178276628896024e-22,  2.544513728110330e-06, -3.107930249617479e-07,  2.051349706846577e-08, -9.614858027405115e-10,  3.569642646524090e-11,
 -1.112845286653987e-12,  3.020113116349703e-14, -7.310499421543266e-16,  1.606094129061044e-17, -3.244586470509262e-19,  6.088329968932581e-21, -1.069454209533625e-22,
  8.303300639891344e-07, -1.135566979713096e-07,  8.321297226671712e-09, -4.299915470825839e-10,  1.749929505373372e-11, -5.951515355853613e-13,  1.754813807583830e-14,
 -4.598507738942623e-16,  1.090258240728946e-17, -2.370155170576681e-19,  4.773787443844303e-21, -8.979359058306588e-23,  2.599895349264092e-07, -3.957648536346043e-08,
  3.205719680535273e-09, -1.819800832499606e-10,  8.093925602190717e-12, -2.995159925312242e-13,  9.572223474153308e-15, -2.709716929950351e-16,  6.919222989925904e-18,
 -1.615665274510784e-19,  3.486723891959150e-21, -7.011091634618691e-23,  7.847406657665671e-08, -1.322243089319582e-08,  1.178925709642593e-09, -7.326871334937516e-11,
  3.550975418301466e-12, -1.426044192179950e-13,  4.928311574184683e-15, -1.503846574224233e-16,  4.127570977082765e-18, -1.033299416096948e-19,  2.385104323574484e-21,
 -5.118364735433897e-23,  2.295204707556829e-08, -4.258123662346742e-09,  4.162124255133032e-10, -2.822357300590518e-11,  1.486155532449425e-12, -6.460205503152037e-14,
  2.408593389550255e-15, -7.905439460071408e-17,  2.327574558335064e-18, -6.235268970654870e-20,  1.536659693468560e-21, -3.513323856311501e-23,  6.542993759903081e-09,
 -1.329793030724095e-09,  1.419308415544624e-10, -1.046602576164930e-11,  5.970133210622056e-13, -2.801716039175981e-14,  1.124235212077660e-15, -3.960238999209300e-17,
  1.248230380448638e-18, -3.571316083174085e-20,  9.379891497857290e-22, -2.280842214905388e-23,  1.829870972687129e-09, -4.054155502855664e-10,  4.706351466188310e-11,
 -3.761300556088817e-12,  2.317399351355613e-13, -1.170944721858377e-14,  5.044533002365064e-16, -1.902832675943718e-17,  6.406884262768256e-19, -1.953852763051500e-20,
  5.458603506893016e-22, -1.409106907036680e-23,  5.056985126507788e-10, -1.215467616349591e-10,  1.528679324874729e-11, -1.319596905560973e-12,  8.754780311864450e-14,
 -4.749810252285687e-15,  2.191323492896188e-16, -8.830221281897317e-18,  3.169006926366365e-19, -1.027930992097180e-20,  3.048612154292241e-22, -8.338601006914374e-24,
  1.392021633067501e-10, -3.612307922470416e-11,  4.902628298053362e-12, -4.555266388602381e-13,  3.244102540170705e-14, -1.884385846313271e-15,  9.285061597427974e-17,
 -3.987018817963812e-18,  1.521526998969883e-19, -5.237724123714647e-21,  1.645508089334898e-22, -4.759118087215420e-24,  3.849943373017927e-11, -1.073476543406817e-11,
  1.565873456212966e-12, -1.560414994726418e-13,  1.188977272412526e-14, -7.371841565250524e-16,  3.868525898069622e-17, -1.765425549584262e-18,  7.146007354343246e-20,
 -2.604375225112691e-21,  8.647290840306279e-23, -2.638633874338387e-24,  1.079903247293432e-11, -3.219705851644796e-12,  5.026877113069013e-13, -5.352454076390524e-14,
  4.348501173085384e-15, -2.868609853985551e-16,  1.598386257925607e-17, -7.730061506280654e-19,  3.309764855087038e-20, -1.273750297652829e-21,  4.458571367394202e-23,
 -1.431930406386727e-24,  3.102863183011191e-12, -9.843497350303077e-13,  1.637875018578448e-13, -1.856082532861754e-14,  1.601943407735179e-15, -1.120508991947242e-16,
  6.607762358996853e-18, -3.376063800864115e-19,  1.524555261464458e-20, -6.178011571197344e-22,  2.273596821475090e-23, -7.665239521807387e-25,  9.227807677824259e-13,
 -3.099289938437484e-13,  5.471326409482194e-14, -6.571502180274112e-15,  6.001815771417658e-16, -4.434904080620597e-17,  2.758215433252386e-18, -1.483830548624851e-19,
  7.044347374647920e-21, -2.996569666980608e-22,  1.155980895645258e-23, -4.079435727397242e-25,  2.870608398580625e-13, -1.015520459622231e-13,  1.893101565590161e-14,
 -2.399300863235620e-15,  2.309176880165982e-16, -1.795421865194935e-17,  1.173185382119743e-18, -6.621284560677733e-20,  3.293088910149742e-21, -1.465552152260416e-22,
  5.907116561940460e-24, -2.175174601500053e-25,  9.437612457510760e-14, -3.498256820887015e-14,  6.852411362985833e-15, -9.121257583696879e-16,  9.209549400945676e-17,
 -7.502327690694475e-18,  5.129418738733401e-19, -3.025151313405044e-20,  1.570214190983132e-21, -7.284061118395932e-23,  3.056685855104273e-24, -1.170421113450197e-25,
  3.310187236872634e-14, -1.278762966694339e-14,  2.618359875284411e-15, -3.642281192641291e-16,  3.839611458425081e-17, -3.262062152080129e-18,  2.323319798930960e-19,
 -1.425712436535261e-20,  7.691268329395828e-22, -3.704176423996582e-23,  1.612087308355354e-24, -6.394718605380806e-26,  1.247991342179385e-14, -4.997143650362343e-15,
  1.063742530215011e-15, -1.538199883430842e-16,  1.684357087394373e-17, -1.485046455492251e-18,  1.096547307666653e-19, -6.969287871900176e-21,  3.890154758929932e-22,
 -1.936681454498854e-23,  8.704629323677168e-25, -3.562509144510047e-26,  5.077228761213453e-15, -2.095515047020555e-15,  4.611025492850812e-16, -6.892447966157133e-17,
  7.797219559859686e-18, -7.096698013464562e-19,  5.404992566033597e-20, -3.540328081054237e-21,  2.034928249320287e-22, -1.042353431271422e-23,  4.816578015683027e-25,
 -2.024943960246128e-26,  2.221898995377964e-15, -9.399080637560644e-16,  2.125183800478902e-16, -3.264489495246168e-17,  3.793420231046859e-18, -3.544310367048416e-19,
  2.769271342046224e-20, -1.859574552398664e-21,  1.095027996683276e-22, -5.742603403985714e-24,  2.714993243531513e-25, -1.167024475853074e-26,  1.026893827998002e-15,
 -4.426862194129230e-16,  1.022189425084949e-16, -1.603706118637097e-17,  1.902723055657631e-18, -1.814312689807692e-19,  1.445977371393285e-20, -9.899173622102124e-22,
  5.939831011657314e-23, -3.172479388033595e-24,  1.526800668803093e-25, -6.677045452719166e-27,  4.721341899616220e-16, -2.062216844183745e-16,  4.832123645204586e-17,
 -7.693889559303731e-18,  9.262306945241641e-19, -8.958637928067115e-20,  7.239785503274367e-21, -5.023896178878459e-22,  3.054472797243599e-23, -1.652442828782386e-24,
  8.052367526660807e-26, -3.564314193226881e-27,  1.689500208930142e-16, -7.433609064127000e-17,  1.756150807979931e-17, -2.819408092836161e-18,  3.421920123686208e-19,
 -3.336233037935507e-20,  2.717187149010851e-21, -1.899882340343968e-22,  1.163662279582008e-23, -6.340671523775469e-25,  3.111470273942867e-26, -1.386627594807499e-27,
  6.554168855197515e-02, -1.782367219669350e-04,  5.034792571255375e-07, -1.467550248937285e-09,  4.379042025130099e-12, -1.328170234126586e-14,  4.068919531329986e-17,
 -1.253878622748835e-19,  3.872397749505724e-22, -1.196781740809725e-24,  3.692999038350113e-27, -1.138202701259158e-29,  6.095956104446637e-02, -2.086260364326044e-04,
  8.541536317051800e-07, -3.643451641764243e-09,  1.538935391953930e-11, -6.365052680519938e-14,  2.578236904424980e-16, -1.025423513077646e-18,  4.014370586025889e-21,
 -1.550159815020783e-23,  5.913679340774050e-26, -2.231671214223659e-28,  5.273894648480529e-02, -2.547528840490912e-04,  1.484627960495586e-06, -8.290880539601212e-09,
  4.385584632726987e-11, -2.222898573437517e-13,  1.089343800880917e-15, -5.192008524502620e-18,  2.416681068987096e-20, -1.101914183363348e-22,  4.933510844583978e-25,
 -2.173047299935866e-27,  4.244922101482829e-02, -2.949425213186085e-04,  2.253119878024529e-06, -1.551076152021994e-08,  9.903230511096315e-11, -5.982657566113766e-13,
  3.459011487468279e-15, -1.928472492479951e-17,  1.042390634743036e-19, -5.485068819517600e-22,  2.818756142401234e-24, -1.418262996833020e-26,  3.179681318941032e-02,
 -3.110362042245321e-04,  2.967308289076048e-06, -2.460756455947970e-08,  1.863567677483803e-10, -1.319345232476712e-12,  8.852918299832835e-15, -5.683054969475423e-17,
  3.513762827905609e-19, -2.103096156449263e-21,  1.223347651825390e-23, -6.937306924209730e-26,  2.217411172915475e-02, -2.958192472279432e-04,  3.437424990780929e-06,
 -3.388165568008521e-08,  3.004411262475969e-10, -2.461705676350417e-12,  1.894533586159678e-14, -1.384768725374026e-16,  9.689854929047791e-19, -6.529918172904465e-21,
  4.257434337853439e-23, -2.695312629320406e-25,  1.440391267657866e-02, -2.540141797733948e-04,  3.543612245806192e-06, -4.108044934791841e-08,  4.221607204263046e-10,
 -3.965088944517369e-12,  3.468711270986757e-14, -2.862524103204903e-16,  2.248742520959474e-18, -1.693095971198341e-20,  1.228131202789210e-22, -8.618051790342993e-25,
  8.720939649744439e-03, -1.977694344747946e-04,  3.278793881032267e-06, -4.430630457977254e-08,  5.232728202806352e-10, -5.590918341130024e-12,  5.520227303357632e-14,
 -5.108913068724584e-16,  4.477091154773432e-18, -3.743121677096222e-20,  3.003074397333952e-22, -2.322560059984294e-24,  4.925282387180004e-03, -1.402834882037793e-04,
  2.740742816068103e-06, -4.283511291133993e-08,  5.773830650992896e-10, -6.973630448476862e-12,  7.725870764854296e-14, -7.974727984503530e-16,  7.755095943008339e-18,
 -7.163879544247834e-20,  6.326462785493155e-22, -5.367628185156187e-24,  2.597088228194825e-03, -9.106706746221470e-05,  2.080731073318158e-06, -3.735593495824169e-08,
  5.712754165990604e-10, -7.758055655801568e-12,  9.596330759434490e-14, -1.099647761966819e-15,  1.181457408259050e-17, -1.200821910978181e-19,  1.162575811188217e-21,
 -1.077890962687945e-23,  1.279990216425874e-03, -5.432594651612854e-05,  1.441289320815984e-06, -2.954387324124359e-08,  5.099386974698163e-10, -7.750248383772741e-12,
  1.065794255000852e-13, -1.350410932952205e-15,  1.596922736764497e-17, -1.779434773402578e-19,  1.882165453100157e-21, -1.900644487297828e-23,  5.904061121781778e-04,
 -2.989338960012938e-05,  9.146977377434890e-07, -2.129050052479601e-08,  4.128454838409829e-10, -6.993354768349426e-12,  1.065156748870164e-13, -1.487063437379676e-15,
  1.929162835663595e-17, -2.349329295092314e-19,  2.706765679779185e-21, -2.968452286497211e-23,  2.552542934471161e-04, -1.522614263163438e-05,  5.339319015746444e-07,
 -1.404141617540584e-08,  3.046065465962185e-10, -5.729647898831242e-12,  9.633056861642231e-14, -1.477235990505611e-15,  2.096237066714112e-17, -2.782199540859092e-19,
  3.482381967957305e-21, -4.137013946106960e-23,  1.036175377538045e-04, -7.203107188510375e-06,  2.877451871857536e-07, -8.510216255201017e-09,  2.057409605664709e-10,
 -4.282844166707351e-12,  7.924114992946005e-14, -1.331018315883608e-15,  2.060547317029775e-17, -2.973191602138475e-19,  4.033321508755472e-21, -5.178647213070475e-23,
  3.957416600297006e-05, -3.175575671035482e-06,  1.437013729407196e-07, -4.759139468798600e-09,  1.277632278281048e-10, -2.934167050002755e-12,  5.957542559399186e-14,
 -1.093274500009888e-15,  1.842014707187958e-17, -2.882988393733691e-19,  4.229607168740971e-21, -5.857342137648809e-23,  1.425361902792365e-05, -1.309137294815257e-06,
  6.675487769523838e-08, -2.465627781843312e-09,  7.325630456246983e-11, -1.850654978009106e-12,  4.112801588621481e-14, -8.226048110571232e-16,  1.505069017054820e-17,
 -2.549818508509851e-19,  4.037601890129373e-21, -6.019326233965842e-23,  4.854497331405702e-06, -5.064813965199371e-07,  2.895803180927521e-08, -1.188308093982985e-09,
  3.895005829431906e-11, -1.079430285470244e-12,  2.619201488464143e-14, -5.696909318589459e-16,  1.129542111650976e-17, -2.067334711821414e-19,  3.526788230231859e-21,
 -5.650153414542426e-23,  1.568246664973543e-06, -1.845933428003505e-07,  1.177884379451279e-08, -5.350540450729699e-10,  1.928957718592532e-11, -5.848899970189486e-13,
  1.545939034549018e-14, -3.648817752443992e-16,  7.824471219010737e-18, -1.544240761054536e-19,  2.833203217819236e-21, -4.869552464396151e-23,  4.822555483108276e-07,
 -6.364123738341086e-08,  4.512203253269577e-09, -2.261022007357688e-10,  8.939414348700867e-12, -2.958180546571224e-13,  8.497752980081331e-15, -2.171994317185211e-16,
  5.027755209468489e-18, -1.068099928628547e-19,  2.103960500857573e-21, -3.873304096646752e-23,  1.417409245395575e-07, -2.084958475019583e-08,  1.635629986933197e-09,
 -9.010760615186118e-11,  3.895953232489372e-12, -1.403523034835663e-13,  4.372199603706229e-15, -1.207742789983820e-16,  3.012268110454150e-18, -6.876262763091380e-20,
  1.451866107530319e-21, -2.858389847413979e-23,  4.000159537059678e-08, -6.523216689390453e-09,  5.639431792552655e-10, -3.404475852823892e-11,  1.605247458499981e-12,
 -6.280269825519735e-14,  2.116943127235473e-15, -6.307189015014178e-17,  1.691825712974153e-18, -4.142703279588287e-20,  9.360440129550485e-22, -1.967724809305037e-23,
  1.089696662825932e-08, -1.959913412014800e-09,  1.859946124231240e-10, -1.226470503138539e-11,  6.289112883389585e-13, -2.665618737845305e-14,  9.701210412003677e-16,
 -3.111227400907171e-17,  8.958647015145408e-19, -2.348989462115121e-20,  5.670407936524862e-22, -1.270779720698934e-23,  2.882458074090537e-09, -5.689774524656311e-10,
  5.904588372315543e-11, -4.239375336123456e-12,  2.357610251347885e-13, -1.079899454754421e-14,  4.233884921792106e-16, -1.458589397999568e-17,  4.499930147867423e-19,
 -1.261177804558521e-20,  3.247081095297708e-22, -7.745189932096771e-24,  7.453477300420678e-10, -1.606962683540148e-10,  1.816731468667900e-11, -1.415686517473666e-12,
  8.514409051310381e-14, -4.204106764030819e-15,  1.771573025377581e-16, -6.542128271885492e-18,  2.158205676966098e-19, -6.453336538111517e-21,  1.768948557443541e-22,
 -4.483324891855159e-24,  1.898246267400218e-10, -4.448993135061917e-11,  5.458775705839464e-12, -4.601750895201836e-13,  2.984519211809457e-14, -1.584409041068110e-15,
  7.158810258584359e-17, -2.827480623778869e-18,  9.953313244468480e-20, -3.169007329309193e-21,  9.231094074503976e-23, -2.481432315875858e-24,  4.801418988357028e-11,
 -1.217582868347378e-11,  1.615170298644389e-12, -1.468070338920538e-13,  1.023669950411713e-14, -5.826902025717054e-16,  2.815788855675464e-17, -1.186672317848937e-18,
  4.447604024930120e-20, -1.504627116132310e-21,  4.648184909455644e-23, -1.322685369004595e-24,  1.217332943431214e-11, -3.324332981197115e-12,  4.749068436487418e-13,
 -4.638003091620880e-14,  3.466080534060787e-15, -2.109315950405363e-16,  1.087225828770457e-17, -4.876638259828435e-19,  1.941336412152758e-20, -6.962400022130926e-22,
  2.276090735853794e-23, -6.841849330129358e-25,  3.124899811028035e-12, -9.145658899679043e-13,  1.401334730295146e-13, -1.465136356689380e-14,  1.169581212769937e-15,
 -7.585977488798178e-17,  4.158553804644604e-18, -1.979794961710388e-19,  8.349338383837013e-21, -3.166529174230755e-22,  1.092829788993466e-23, -3.462155992106034e-25,
  8.210079280564194e-13, -2.562616591458148e-13,  4.193676389239370e-14, -4.675974482852308e-15,  3.973007121604885e-16, -2.737329798054217e-17,  1.590892118776852e-18,
 -8.014849443143310e-20,  3.570576535070604e-21, -1.428087531529468e-22,  5.189434998415660e-24, -1.728308656547810e-25,  2.233105619640101e-13, -7.396408784664711e-14,
  1.287014148436883e-14, -1.524121295898717e-15,  1.373075624036652e-16, -1.001280824630326e-17,  6.148359867733038e-19, -3.267132211946293e-20,  1.532700912070752e-21,
 -6.445389279298421e-23,  2.458944198555396e-24, -8.584931689600118e-26,  6.362741384144152e-14, -2.224771133455751e-14,  4.096902472087899e-15, -5.130301822240653e-16,
  4.880281738823242e-17, -3.751886911878520e-18,  2.424995947989817e-19, -1.354279882797902e-20,  6.667232275575114e-22, -2.938100194597009e-23,  1.173017424560670e-24,
 -4.279849671635489e-26,  1.921542769267868e-14, -7.055146619665081e-15,  1.368101612211113e-15, -1.803055057362575e-16,  1.802975160612303e-17, -1.455045290312734e-18,
  9.858511375363970e-20, -5.763465726621169e-21,  2.966300426488151e-22, -1.364804824795523e-23,  5.682041951852647e-25, -2.159088865578938e-26,  6.218908658987074e-15,
 -2.384519618175117e-15,  4.843484632492449e-16, -6.684267488596614e-17,  6.992084615415408e-18, -5.895925436149035e-19,  4.168819485788229e-20, -2.540288235513008e-21,
  1.361117534525457e-22, -6.512263784171694e-24,  2.816202005763175e-25, -1.110264156345672e-26,  2.176988757192786e-15, -8.668062591721302e-16,  1.833963682093935e-16,
 -2.635953006996635e-17,  2.869402329945268e-18, -2.515382132014309e-19,  1.847035662455667e-20, -1.167608377175381e-21,  6.483532041039097e-23, -3.211527457227817e-24,
  1.436423295859678e-25, -5.851123933941438e-27,  8.289788831587509e-16, -3.407804162371826e-16,  7.465989823971517e-17, -1.111156322213227e-17,  1.251682542950827e-18,
 -1.134526706946802e-19,  8.606201705296775e-21, -5.615289205471647e-22,  3.215459781865248e-23, -1.641065780846432e-24,  7.556427560479361e-26, -3.165992399242517e-27,
  3.429026725924371e-16, -1.446767857534658e-16,  3.261826245002589e-17, -4.996091729877204e-18,  5.789242744542611e-19, -5.394243757053625e-20,  4.203460487663319e-21,
 -2.815351582953202e-22,  1.653698408102599e-23, -8.651383064575009e-25,  4.080596624255171e-26, -1.750037005351418e-27,  1.515205796827210e-16, -6.522025874294589e-17,
  1.503436812832885e-17, -2.354743029434354e-18,  2.789153046199608e-19, -2.655246055486416e-20,  2.112853480544966e-21, -1.444248064921442e-22,  8.653094481746378e-24,
 -4.614979543246498e-25,  2.217918107730878e-26, -9.686331999053793e-28,  6.746637183124793e-17, -2.944639977185001e-17,  6.894031145962866e-18, -1.096770570003561e-18,
  1.319255478229425e-19, -1.274968300202186e-20,  1.029530951627397e-21, -7.138707081862786e-23,  4.336998163707738e-24, -2.344564658258652e-25,  1.141696505432380e-26,
 -5.050141228763178e-28,  2.370744193060156e-17, -1.042776898892019e-17,  2.462640974512615e-18, -3.952232114696853e-19,  4.795132458658882e-20, -4.673427660920919e-21,
  3.804956581038837e-22, -2.659565183043637e-23,  1.628423993675608e-24, -8.870236751859177e-26,  4.351388051113448e-27, -1.938596086541510e-28,  6.483668745376522e-02,
 -1.742781590717433e-04,  4.862804449182814e-07, -1.399558759199305e-09,  4.122896076947943e-12, -1.234593053061644e-14,  3.734553933684559e-17, -1.136579766236845e-19,
  3.466982513596055e-22, -1.058603267374902e-24,  3.227222006267950e-27, -9.830235057218710e-30,  6.013845223916835e-02, -2.019636017654474e-04,  8.118686436211325e-07,
 -3.407079368568176e-09,  1.417596829897695e-11, -5.779328435675664e-14,  2.308295224616349e-16, -9.054545632604693e-19,  3.496628256502636e-21, -1.332128367721087e-23,
  5.014406003222293e-26, -1.867422268488105e-28,  5.174307529556564e-02, -2.432622227316576e-04,  1.389205313980533e-06, -7.623380772589070e-09,  3.966015277386562e-11,
 -1.978062675258161e-13,  9.542240461617513e-16, -4.478511513683594e-18,  2.053324936864580e-20, -9.224357992230776e-23,  4.069958657428079e-25, -1.766986840837783e-27,
  4.130435889504237e-02, -2.776360230043174e-04,  2.076117110733135e-06, -1.401763364398558e-08,  8.785528831330758e-11, -5.213697167340816e-13,  2.962918125541114e-15,
 -1.624441797038260e-17,  8.638048827645849e-20, -4.473081190384508e-22,  2.262806577546258e-24, -1.121044210849369e-26,  3.059834413857212e-02, -2.884301449689931e-04,
  2.689072965801183e-06, -2.182592633883819e-08,  1.619719532971208e-10, -1.124766404250001e-12,  7.408337808030264e-15, -4.670911028281627e-17,  2.837840279202094e-19,
 -1.669739263389605e-21,  9.551416896085940e-24, -5.328112054823546e-26,  2.104336916489629e-02, -2.698680343740112e-04,  3.058139313936082e-06, -2.944502378264529e-08,
  2.554570554621663e-10, -2.050248003146205e-12,  1.546896454112947e-14, -1.109237603730199e-16,  7.619046380052093e-19, -5.042397111772630e-21,  3.230018190770637e-23,
 -2.009806438252625e-25,  1.344158615730945e-02, -2.275280616850140e-04,  3.088696733530598e-06, -3.491764577975836e-08,  3.505743805041669e-10, -3.221178639474160e-12,
  2.759420473058107e-14, -2.231662544194093e-16,  1.719219669935888e-18, -1.270063157113917e-20,  9.043744665646475e-23, -6.232407291685370e-25,  7.979145628378875e-03,
 -1.735315093783102e-04,  2.793882963733067e-06, -3.676109021884959e-08,  4.236229684184454e-10, -4.422701022079126e-12,  4.271591498704667e-14, -3.870525012578249e-16,
  3.323233903738113e-18, -2.723893985660654e-20,  2.143609434362332e-22, -1.626953009126625e-24,  4.404953371650376e-03, -1.202665640275021e-04,  2.277854387407724e-06,
 -3.461913570233938e-08,  4.547792936286496e-10, -5.361549065285508e-12,  5.804836004636341e-14, -5.861169569890124e-16,  5.579893186328699e-18, -5.049525270830967e-20,
  4.371005966998163e-22, -3.637027242098577e-24,  2.263477391345743e-03, -7.606994510446963e-05,  1.682560466700330e-06, -2.934142925947713e-08,  4.368564353746712e-10,
 -5.785391512184879e-12,  6.987520356792625e-14, -7.826259548525092e-16,  8.225685375468801e-18, -8.184692690113059e-20,  7.762292914118963e-22, -7.053957805811667e-24,
  1.083683074414007e-03, -4.408597183114398e-05,  1.131019202741684e-06, -2.249780227686172e-08,  3.777251443991454e-10, -5.593772947682391e-12,  7.505393530336999e-14,
 -9.288530864992940e-16,  1.073839306118639e-17, -1.170708024483761e-19,  1.212353213003940e-21, -1.199329502092251e-23,  4.839952142463258e-04, -2.349525076411779e-05,
  6.946433411787095e-07, -1.567800813151826e-08,  2.954993806468692e-10, -4.873999802709131e-12,  7.238447224493487e-14, -9.864700812852745e-16,  1.250426672957018e-17,
 -1.489095591037458e-19,  1.678914685306321e-21, -1.802951319698936e-23,  2.019319214658955e-04, -1.155378003312659e-05,  3.912670848066278e-07, -9.971649329083242e-09,
  2.101382625850797e-10, -3.846640525986241e-12,  6.302621789226959e-14, -9.430105818179741e-16,  1.306905881381768e-17, -1.695502610467158e-19,  2.075948731162523e-21,
 -2.414055410393852e-23,  7.883345222594510e-05, -5.259570995839300e-06,  2.028501104327129e-07, -5.811732819852344e-09,  1.364300358386602e-10, -2.762647371644474e-12,
  4.979338259375887e-14, -8.157352416124852e-16,  1.232909512135015e-17, -1.738343133989029e-19,  2.306080732589121e-21, -2.897532492749250e-23,  2.885314981066329e-05,
 -2.223654194670025e-06,  9.714626537753767e-08, -3.116030097738010e-09,  8.120586479955423e-11, -1.813626177056906e-12,  3.586220075435685e-14, -6.416942503919013e-16,
  1.055280202366180e-17, -1.613549633139051e-19,  2.314450841302778e-21, -3.135937499198790e-23,  9.922577728264733e-06, -8.760225003574218e-07,  4.313298471303790e-08,
 -1.542951449083348e-09,  4.449721701145236e-11, -1.093037998443825e-12,  2.365324225877221e-14, -4.612225045125159e-16,  8.235544017629994e-18, -1.362874801717361e-19,
  2.109748998680314e-21, -3.077039385578791e-23,  3.214632398829245e-06, -3.227045705339003e-07,  1.782252694033319e-08, -7.084296266393268e-10,  2.254057700989180e-11,
 -6.074055047595998e-13,  1.435131314708158e-14, -3.043127951246346e-16,  5.888324468254244e-18, -1.052700248126087e-19,  1.755622136843110e-21, -2.751639415562594e-23,
  9.840519379370398e-07, -1.115718679811668e-07,  6.880872304122442e-09, -3.028676652334369e-10,  1.060145107665214e-11, -3.126190729122810e-13,  8.046906377016458e-15,
 -1.851807000525908e-16,  3.875716477609920e-18, -7.472408238958140e-20,  1.340372804516911e-21, -2.254049127216137e-23,  2.856215847566292e-07, -3.635172632820220e-08,
  2.492863889743958e-09, -1.211024337074067e-10,  4.650663969750246e-12, -1.497160218612610e-13,  4.189505985896071e-15, -1.044316814449411e-16,  2.359944749675046e-18,
 -4.898743201652470e-20,  9.436415878628728e-22, -1.700089669516491e-23,  7.891980804322757e-08, -1.121130820700172e-08,  8.514592255065861e-10, -4.550697165467460e-11,
  1.912190713714099e-12, -6.704749024706887e-14,  2.035460601833570e-15, -5.485561894914486e-17,  1.336142969363074e-18, -2.981317335533692e-20,  6.157800121869101e-22,
 -1.186821235245243e-23,  2.085440182443559e-08, -3.289306105711698e-09,  2.755923874177101e-10, -1.615452577145329e-11,  7.408034668199659e-13, -2.822684725213505e-14,
  9.277777496380967e-16, -2.698277567721974e-17,  7.071921489772728e-19, -1.693442411465962e-20,  3.744786818862052e-22, -7.710030200820463e-24,  5.297998175699945e-09,
 -9.231614001593441e-10,  8.501025096156956e-11, -5.448644184365836e-12,  2.719735829726947e-13, -1.123586148617804e-14,  3.990280394534700e-16, -1.250034038375086e-17,
  3.519196727723078e-19, -9.029302678511800e-21,  2.134464433535405e-22, -4.687656342387057e-24,  1.301781177716684e-09, -2.493877078872947e-10,  2.514839040998287e-11,
 -1.757130143228906e-12,  9.522291091341095e-14, -4.255419511706290e-15,  1.629498350511061e-16, -5.488108278702587e-18,  1.656720835477479e-19, -4.546942302864995e-21,
  1.147236145019420e-22, -2.683540107998270e-24,  3.114896045678006e-10, -6.530132776822764e-11,  7.184978324676371e-12, -5.456015112285735e-13,  3.201571803349231e-14,
 -1.544048570271324e-15,  6.361463771782788e-17, -2.298899224240073e-18,  7.427696097209507e-20, -2.176876831853854e-21,  5.852685341678603e-23, -1.455856074303681e-24,
  7.314502994519229e-11, -1.670341022028431e-11,  1.998019904852647e-12, -1.643851129969739e-13,  1.041637554334743e-14, -5.408115179474403e-16,  2.391953282805323e-17,
 -9.255673320912075e-19,  3.194525136723373e-20, -9.979297049110643e-22,  2.853994204599193e-23, -7.537011615196446e-25,  1.700332678022223e-11, -4.210187442459263e-12,
  5.454887392525032e-13, -4.847028868529668e-14,  3.307203942730436e-15, -1.843739623670326e-16,  8.733395205635157e-18, -3.610504766447425e-19,  1.328389186799912e-20,
 -4.414443763016364e-22,  1.340430839744495e-23, -3.751360138480315e-25,  3.950904098450501e-12, -1.055840763597343e-12,  1.476133217456122e-13, -1.411875206451072e-14,
  1.034208210769576e-15, -6.173890718216381e-17,  3.123979019192177e-18, -1.376515911194968e-19,  5.386598382066212e-21, -1.900149880002904e-22,  6.113340683824101e-24,
 -1.809512432368531e-25,  9.275014795476856e-13, -2.662561180434605e-13,  4.000884329641080e-14, -4.104693134946917e-15,  3.217546457220139e-16, -2.050679520265807e-17,
  1.105365689634976e-18, -5.177619138351564e-20,  2.149613760699750e-21, -8.030213173211418e-23,  2.731201713590537e-24, -8.531476553021983e-26,  2.225594793832822e-13,
 -6.829778619069904e-14,  1.098477793238420e-14, -1.204319100966941e-15,  1.006735668724361e-16, -6.828215964824890e-18,  3.908887929589626e-19, -1.940779205485670e-20,
  8.525311952548665e-22, -3.363785236302384e-23,  1.206406216346342e-24, -3.967268765029317e-26,  5.527251980866868e-14, -1.804127967257983e-14,  3.092228682558630e-15,
 -3.608255934301600e-16,  3.204566180513884e-17, -2.304857524551575e-18,  1.396601997279757e-19, -7.326698250630545e-21,  3.394848104343263e-22, -1.410641378789514e-23,
  5.319788679606413e-25, -1.836683686332312e-26,  1.439384440797560e-14, -4.971337071885163e-15,  9.037792454581343e-16, -1.117563129071414e-16,  1.050175374816284e-17,
 -7.978701227900070e-19,  5.098418245736189e-20, -2.816083444230947e-21,  1.371698722306704e-22, -5.982898180436428e-24,  2.364992047683043e-25, -8.546403886989200e-27,
  3.982862039886543e-15, -1.447714278682156e-15,  2.777668110297414e-16, -3.622629093551933e-17,  3.585793715942429e-18, -2.865461540219662e-19,  1.923068676870940e-20,
 -1.113966054214090e-21,  5.682539730702577e-23, -2.592183178368316e-24,  1.070262679580675e-25, -4.034337400604959e-27,  1.186020255065601e-15, -4.511628205128019e-16,
  9.086757480385028e-17, -1.243551059358409e-17,  1.290239507647518e-18, -1.079390786604527e-19,  7.573811372998059e-21, -4.581090858059287e-22,  2.437095297839373e-23,
 -1.157983324441345e-24,  4.974230113613233e-26, -1.948411899189308e-27,  3.843259744367752e-16, -1.521136534266940e-16,  3.197654123107998e-17, -4.566606503533863e-18,
  4.940034358009728e-19, -4.304328249242105e-20,  3.142120469575012e-21, -1.975029114854044e-22,  1.090679683950499e-23, -5.373834426437758e-25,  2.391206461854231e-26,
 -9.691995316364499e-28,  1.365655286640513e-16, -5.590199695097268e-17,  1.219066273871943e-17, -1.805968995103781e-18,  2.025206977304383e-19, -1.827618448416626e-20,
  1.380499578168906e-21, -8.970346001991437e-23,  5.116224948777205e-24, -2.601102674398760e-25,  1.193236569296269e-26, -4.981430541266802e-28,  5.324350010927173e-17,
 -2.240200746412090e-17,  5.035231901995072e-18, -7.688836975942747e-19,  8.882821096804544e-20, -8.252656258330538e-21,  6.412710652055358e-22, -4.283280660131951e-23,
  2.509265229858945e-24, -1.309357793931640e-25,  6.160472510984983e-27, -2.635674706229819e-28,  2.243944565935571e-17, -9.643182471895506e-18,  2.218928738568321e-18,
 -3.469126006052268e-19,  4.101868065078232e-20, -3.898219583686243e-21,  3.096735313872648e-22, -2.113347883026967e-23,  1.264201277469609e-24, -6.732102912847381e-26,
  3.230596164802550e-27, -1.408879469920268e-28,  9.658511871097890e-18, -4.212222405940717e-18,  9.852986801042237e-19, -1.566114192186644e-19,  1.882154744444271e-20,
 -1.817410516272990e-21,  1.466322972827175e-22, -1.015911733743374e-23,  6.167105846063799e-25, -3.331344332787591e-26,  1.620997299681862e-27, -7.165050705634958e-29,
  3.329255235167353e-18, -1.463904748857432e-18,  3.455916188136439e-19, -5.544249953697019e-20,  6.724196354446041e-21, -6.551142757362339e-22,  5.331823888549015e-23,
 -3.725497245932989e-24,  2.280298133774505e-25, -1.241689147159139e-26,  6.089224497431017e-28, -2.711947780534049e-29,  6.414725049697420e-02, -1.704539913598106e-04,
  4.698735443615423e-07, -1.335520132181261e-09,  3.884688952332038e-12, -1.148660734893321e-14,  3.431288049434443e-17, -1.031492953837470e-19,  3.108116111364320e-22,
 -9.377597464999771e-25,  2.824602796847759e-27, -8.504907634081059e-30,  5.934333412253888e-02, -1.956284224948876e-04,  7.723073925940431e-07, -3.189218197577201e-09,
  1.307351164004619e-11, -5.254539440964844e-14,  2.069738589856646e-16, -8.008639144440460e-19,  3.051270804482442e-21, -1.147057454941349e-23,  4.261062148781408e-26,
 -1.566244276208556e-28,  5.079168915575058e-02, -2.325040077230639e-04,  1.301405484518600e-06, -7.019264360695658e-09,  3.592325503226005e-11, -1.763383817640487e-13,
  8.375469478903893e-16, -3.871583744923174e-18,  1.748771080399500e-20, -7.741755109643756e-23,  3.366779752249783e-25, -1.440994903618287e-27,  4.022600005895622e-02,
 -2.616768040206659e-04,  1.916007616610743e-06, -1.269165375230977e-08,  7.810370532714995e-11, -4.554197320849680e-13,  2.544471224516213e-15, -1.372134360082370e-17,
  7.179441041942798e-20, -3.659370066709062e-22,  1.822613751759132e-24, -8.892544997754429e-27,  2.948604997540184e-02, -2.679227983521196e-04,  2.441998932187444e-06,
 -1.940510413343587e-08,  1.411537669341722e-10, -9.616874099805190e-13,  6.219081644609104e-15, -3.852040552676407e-17,  2.300207922160398e-19, -1.330737215809706e-21,
  7.487332853384631e-24, -4.109431127422223e-26,  2.001068358035162e-02, -2.467497870574945e-04,  2.728032312546879e-06, -2.566658753752933e-08,  2.179266296514864e-10,
 -1.713667415709788e-12,  1.267882552821107e-14, -8.921419493028053e-17,  6.016506206480391e-19, -3.911298714285333e-21,  2.462108705044072e-23, -1.506024167245927e-25,
  1.257836776469082e-02, -2.044038511076814e-04,  2.701325157631199e-06, -2.978987930373705e-08,  2.922976986025356e-10, -2.628083667383138e-12,  2.205170768312633e-14,
 -1.748189211213840e-16,  1.321004402074376e-18, -9.577375700907535e-21,  6.696093966286113e-23, -4.532741704976737e-25,  7.327082118114546e-03, -1.528361306220543e-04,
  2.390669563659100e-06, -3.063853292725246e-08,  3.446013969811701e-10, -3.516402089322440e-12,  3.323087102700056e-14, -2.948743104001053e-16,  2.481147701587340e-18,
 -1.994203723654282e-20,  1.539715401128297e-22, -1.147061413550701e-24,  3.957866209516154e-03, -1.035894315421403e-04,  1.902775728173269e-06, -2.813005700617924e-08,
  3.602481704783558e-10, -4.146713177486734e-12,  4.388595642358476e-14, -4.335611775224464e-16,  4.041676236306490e-18, -3.583803869973167e-20,  3.041469630046815e-22,
 -2.482439486109092e-24,  1.984045491776448e-03, -6.390726176892614e-05,  1.368859186323559e-06, -2.319322001529240e-08,  3.362865612387976e-10, -4.344127303855505e-12,
  5.124327591877059e-14, -5.611140189751465e-16,  5.770554237973262e-18, -5.622223942395078e-20,  5.224288564792424e-22, -4.654165119415676e-24,  9.238602485268301e-04,
 -3.602287938492169e-05,  8.939097447767293e-07, -1.725952416924572e-08,  2.819412861614365e-10, -4.069326622055879e-12,  5.328445232801276e-14, -6.442412449245705e-16,
  7.282893119322469e-18, -7.769783359011995e-20,  7.879069099187924e-22, -7.637080149155019e-24,  4.000413996247987e-04, -1.861711135982309e-05,  5.319402646885840e-07,
 -1.164410554771070e-08,  2.133685758196457e-10, -3.427536641173252e-12,  4.964345693486313e-14, -6.605521749495768e-16,  8.182697204437848e-18, -9.530737314570012e-20,
  1.051730726058653e-21, -1.106127379325910e-23,  1.612928358725866e-04, -8.850479202658001e-06,  2.894853761880895e-07, -7.150907648412799e-09,  1.464152302860776e-10,
 -2.608719634213865e-12,  4.166250711474804e-14, -6.083064117034681e-16,  8.234863644121271e-18, -1.044438194388644e-19,  1.251104996490336e-21, -1.424308701703573e-23,
  6.064641908545962e-05, -3.882437229190834e-06,  1.445741420793560e-07, -4.012977233045005e-09,  9.148541487095367e-11, -1.802313896515454e-12,  3.164924233264169e-14,
 -5.057581404823076e-16,  7.463867060869934e-18, -1.028455485193412e-19,  1.334364309095942e-21, -1.640880015504206e-23,  2.130395233683630e-05, -1.576446170098069e-06,
  6.648897849988686e-08, -2.065637501883431e-09,  5.226146958483626e-11, -1.135173237084160e-12,  2.186244683623421e-14, -3.814695455822128e-16,  6.123718294941856e-18,
 -9.148144913752694e-20,  1.283051379769662e-21, -1.701050834265287e-23,  7.006475875465888e-06, -5.943978854426790e-07,  2.825698272669200e-08, -9.789461157820134e-10,
  2.740377785037856e-11, -6.545618846796694e-13,  1.379332937103704e-14, -2.622266600336605e-16,  4.569801673020539e-18, -7.387433845781948e-20,  1.118021141804727e-21,
 -1.595327721268683e-23,  2.162709541927543e-06, -2.088125818409388e-07,  1.113791642336236e-08, -4.288056633295224e-10,  1.324337496048329e-11, -3.470009013655519e-13,
  7.983238969059320e-15, -1.650312866617463e-16,  3.116365972236857e-18, -5.442133061623283e-20,  8.872714144592834e-22, -1.360502805221678e-23,  6.283612548732720e-07,
 -6.859377916847870e-08,  4.087588416593895e-09, -1.743096624803451e-10,  5.923426335525874e-12, -1.698581098985128e-13,  4.257625494838914e-15, -9.552534966757879e-17,
  1.951232626376541e-18, -3.674928909174672e-20,  6.444662980731721e-22, -1.060349068871722e-23,  1.724218984160034e-07, -2.115320400181402e-08,  1.402594556928885e-09,
 -6.604249041820853e-11,  2.463005371621712e-12, -7.712462296214059e-14,  2.102079274466791e-15, -5.109594790672252e-17,  1.127113969953077e-18, -2.285897226145572e-20,
  4.305653363055859e-22, -7.590829815157425e-24,  4.485824608598631e-08, -6.150800110800290e-09,  4.520499696110280e-10, -2.343179148972376e-11,  9.566467167003429e-13,
 -3.264048119625618e-14,  9.655081475997317e-16, -2.538200569143073e-17,  6.036761500531331e-19, -1.316418116814317e-20,  2.659475806981196e-22, -5.017236140966359e-24,
  1.111535611292590e-08, -1.694641116334629e-09,  1.375393834807542e-10, -7.825328259180806e-12,  3.488913877301803e-13, -1.294351141599906e-14,  4.147406158870358e-16,
 -1.177163962295600e-17,  3.013892713620722e-19, -7.056352298224647e-21,  1.526863866557800e-22, -3.078312980656227e-24,  2.636975723639694e-09, -4.448450635040905e-10,
  3.972840410301474e-11, -2.473919223472238e-12,  1.201606996857859e-13, -4.836869264412177e-15,  1.675697698844199e-16, -5.126282726555843e-18,  1.410651126171578e-19,
 -3.540735059879167e-21,  8.194572279379738e-23, -1.763214233234560e-24,  6.025683641115528e-10, -1.119514317555190e-10,  1.096346429251435e-11, -7.450789843153120e-13,
  3.932894491863715e-14, -1.714064250446257e-15,  6.408162529629140e-17, -2.109248736926771e-18,  6.228288021936780e-20, -1.673425806306197e-21,  4.136481027149079e-23,
 -9.485989257989412e-25,  1.335444877369800e-10, -2.720193506264314e-11,  2.910993935623864e-12, -2.152879234351097e-13,  1.231934173005254e-14, -5.800467977642507e-16,
  2.335525780088823e-17, -8.256152238434764e-19,  2.611619681856600e-20, -7.499360786082495e-22,  1.976922959610552e-23, -4.824932697927071e-25,  2.893302702643952e-11,
 -6.432445966348603e-12,  7.496053663092756e-13, -6.015387730584025e-14,  3.722019477603417e-15, -1.888955341501371e-16,  8.174379433075434e-18, -3.097510895577538e-19,
  1.047752253096149e-20, -3.210088130495816e-22,  9.010068713277328e-24, -2.336753341383673e-25,  6.183055798829891e-12, -1.493663218107753e-12,  1.888811034105397e-13,
 -1.639670582870706e-14,  1.094094031305702e-15, -5.970538081478447e-17,  2.770724113079151e-18, -1.123105782856014e-19,  4.054526399803915e-21, -1.322965739173496e-22,
  3.946840747491441e-24, -1.085904162327832e-25,  1.316561818818643e-12, -3.440269686213988e-13,  4.703507663382402e-14, -4.402982368731551e-15,  3.159299064757628e-16,
 -1.848995986418243e-17,  9.179478019670088e-19, -3.971354239739007e-20,  1.526904663871790e-21, -5.295383168833544e-23,  1.675924823735075e-24, -4.882598098088633e-26,
  2.824918860094530e-13, -7.947783334886165e-14,  1.170334301434114e-14, -1.177402872771923e-15,  9.056971916275549e-17, -5.668745884534984e-18,  3.002802051887342e-19,
 -1.383134033762558e-20,  5.650305059418678e-22, -2.078083129242964e-23,  6.962188512984887e-25, -2.143381514885488e-26,  6.184417237627766e-14, -1.864433424711055e-14,
  2.945028518241082e-15, -3.172618981271390e-16,  2.607603394930475e-17, -1.740028137562317e-18,  9.805902843356803e-20, -4.795614695055081e-21,  2.076090932910051e-22,
 -8.077050456311354e-24,  2.857684974579897e-25, -9.275001120414061e-27,  1.400174622282235e-14, -4.500620068003564e-15,  7.593075890069497e-16, -8.724672415899285e-17,
  7.633960528408178e-18, -5.412330504417660e-19,  3.234425423277920e-20, -1.674294153430230e-21,  7.658549617518171e-23, -3.142957066561231e-24,  1.171101351665948e-25,
 -3.996636812166860e-27,  3.325703878334590e-15, -1.133837488797609e-15,  2.033671972093999e-16, -2.481694898096322e-17,  2.302367524527269e-18, -1.727713566047108e-19,
  1.090911910077037e-20, -5.956562221335950e-22,  2.869313434362247e-23, -1.238125777447493e-24,  4.843657345877844e-26, -1.732906406316361e-27,  8.410441361700171e-16,
 -3.024752097745475e-16,  5.738850360298752e-17, -7.402589582019832e-18,  7.249349425169785e-19, -5.733431498124144e-20,  3.809552268048208e-21, -2.185540515976971e-22,
  1.104536521253178e-23, -4.993334906502958e-25,  2.043776020899847e-26, -7.639504972120432e-28,  2.297707692568915e-16, -8.667289452238984e-17,  1.730081893291994e-17,
 -2.346800558889253e-18,  2.414022427465292e-19, -2.002745739172707e-20,  1.393983207103031e-21, -8.366147233903979e-23,  4.417294977196114e-24, -2.083640538351414e-25,
  8.887665670396966e-27, -3.457728444139293e-28,  6.870952272153152e-17, -2.702242659106933e-17,  5.641730516518944e-18, -8.002471910076969e-19,  8.599712864052865e-20,
 -7.445084468558199e-21,  5.401159620720411e-22, -3.374631634308322e-23,  1.852785470221207e-24, -9.077590261966925e-26,  4.017370511967618e-27, -1.619790921386292e-28,
  2.271136181868028e-17, -9.254735954251104e-18,  2.008278461149434e-18, -2.960583601471279e-19,  3.304122065917663e-20, -2.967918891111549e-21,  2.231750520216291e-22,
 -1.443857502460482e-23,  8.200343886121814e-25, -4.152090767298575e-26,  1.897231432584248e-27, -7.890269547086182e-29,  8.320963617284007e-18, -3.490646378870522e-18,
  7.820283919176743e-19, -1.190282666439941e-19,  1.370745393689807e-20, -1.269562961145188e-21,  9.835519321509094e-23, -6.550404478813722e-24,  3.826609665926456e-25,
 -1.991319368824150e-26,  9.344354254690320e-28, -3.987669265025897e-29,  3.336161627038161e-18, -1.431219080404059e-18,  3.286992124484425e-19, -5.129127937345528e-20,
  6.053257649779597e-21, -5.742207747633599e-22,  4.553492050420280e-23, -3.102147522053269e-24,  1.852598977558428e-25, -9.849448706390704e-27,  4.719124220141762e-28,
 -2.054910228293970e-29,  1.385421775186075e-18, -6.036955374371737e-19,  1.410803872990624e-19, -2.240328848238135e-20,  2.689922034574917e-21, -2.595031381498358e-22,
  2.091869372450569e-23, -1.448060227005378e-24,  8.783105590432638e-26, -4.740590151311341e-27,  2.304895452650026e-28, -1.018016469802900e-29,  4.679084169998444e-19,
 -2.056737924654579e-19,  4.853584710769542e-20, -7.783466277780087e-21,  9.436322437244141e-22, -9.189970554155025e-23,  7.476709778216563e-24, -5.222275977897983e-25,
  3.195297289858240e-26, -1.739321226811593e-27,  8.526667530267648e-29, -3.796230960497368e-30,  6.347285247777644e-02, -1.667580685096068e-04,  4.542127940562474e-07,
 -1.275159184276717e-09,  3.662963632929098e-12, -1.069666291729349e-14,  3.155901999981057e-17, -9.372237847839158e-20,  2.789989670797645e-22, -8.319133855091518e-25,
  2.475970324611676e-27, -7.371024319985335e-30,  5.857293988734893e-02, -1.895995679850323e-04,  7.352580052731763e-07, -2.988186811024466e-09,  1.207051656344242e-11,
 -4.783644879542759e-14,  1.858568294705756e-16, -7.095143585369986e-19,  2.667419536222758e-21, -9.896291859142915e-24,  3.628522267858823e-26, -1.316609970643379e-28,
  4.988197559838758e-02, -2.224201785279800e-04,  1.220510001100593e-06, -6.471650011929700e-09,  3.258903412373159e-11, -1.574773568609310e-13,  7.365759505938789e-16,
 -3.354089419195912e-18,  1.492855539161374e-20, -6.513711911254792e-23,  2.792540710406243e-25, -1.178485711017569e-27,  3.920901350460167e-02, -2.469373695713572e-04,
  1.770915552111177e-06, -1.151166974136224e-08,  6.957615558470370e-11, -3.987148733379575e-13,  2.190553103009373e-15, -1.162136239870260e-17,  5.984387843380873e-20,
 -3.002916512725299e-22,  1.472854967903019e-24, -7.078251538486170e-27,  2.845200831703942e-02, -2.492812689069837e-04,  2.222079032754968e-06, -1.729275646292609e-08,
  1.233293520903841e-10, -8.245828349155049e-13,  5.236750152981445e-15, -3.187180134649887e-17,  1.870962241340138e-19, -1.064494557760025e-21,  5.892229264220035e-24,
 -3.182483198995688e-26,  1.906546266845562e-02, -2.261007501383600e-04,  2.439874523485054e-06, -2.243822684123176e-08,  1.865045769679476e-10, -1.437299621190984e-12,
  1.043048323784821e-14, -7.203644884221813e-17,  4.770827443483108e-19, -3.047214985972324e-21,  1.885370527837891e-23, -1.133920986786174e-25,  1.180181673325240e-02,
 -1.841474748715426e-04,  2.370261447183212e-06, -2.550643632879436e-08,  2.446553451391637e-10, -2.153106110085186e-12,  1.770022647480936e-14, -1.375830393129761e-16,
  1.019982931764127e-18, -7.259024460083165e-21,  4.984208851984864e-23, -3.314782226242372e-25,  6.751785398602837e-03, -1.350927688222053e-04,  2.053901145026278e-06,
 -2.564685574054067e-08,  2.816236893119647e-10, -2.809590298830375e-12,  2.598595358147012e-14, -2.258676799156193e-16,  1.862920298902748e-18, -1.468567847096627e-20,
  1.112683236643286e-22, -8.138081760712871e-25,  3.571945480527231e-03, -8.962543162745918e-05,  1.597236735482124e-06, -2.297621214968024e-08,  2.869339813432315e-10,
 -3.225625247789541e-12,  3.337853838784055e-14, -3.227204150784574e-16,  2.946494289471377e-18, -2.560590709177730e-20,  2.130970419171207e-22, -1.706429740785194e-24,
  1.748676451623186e-03, -5.398438690976340e-05,  1.120159642058529e-06, -1.844586317823115e-08,  2.605301937117437e-10, -3.283691979956746e-12,  3.783960703235538e-14,
 -4.051763118645041e-16,  4.078063904863067e-18, -3.891306048589706e-20,  3.543496741881542e-22, -3.095286733325504e-24,  7.928602072777550e-04, -2.962913314151152e-05,
  7.113854505710347e-07, -1.333576339130977e-08,  2.120077609497086e-10, -2.983012187330726e-12,  3.812776805827276e-14, -4.504616932096357e-16,  4.980417318637851e-18,
 -5.200575232969751e-20,  5.165160691188289e-22, -4.906328879708115e-24,  3.332746052944124e-04, -1.486728852343845e-05,  4.106259171767254e-07, -8.719673179359254e-09,
  1.553745913853897e-10, -2.431352536401403e-12,  3.435084412072167e-14, -4.463489666167748e-16,  5.404559168471226e-18, -6.157911527729601e-20,  6.652078299281002e-22,
 -6.852885339616173e-24,  1.300306236602768e-04, -6.841653826732767e-06,  2.161699496776036e-07, -5.176627874053090e-09,  1.030005170411348e-10, -1.786590157889879e-12,
  2.781625170462208e-14, -3.963981137921553e-16,  5.242554320051961e-18, -6.501435702111926e-20,  7.620400152835927e-22, -8.494335065613797e-24,  4.715669952999234e-05,
 -2.896076425556439e-06,  1.041330986496722e-07, -2.800679909523173e-09,  6.201409990673817e-11, -1.188762421288524e-12,  2.034122405732969e-14, -3.171168684988611e-16,
  4.570228161773129e-18, -6.155067052099301e-20,  7.811331249778968e-22, -9.402142104428827e-24,  1.592300949057406e-05, -1.131026604397802e-06,  4.605251989366540e-08,
 -1.385842042112067e-09,  3.404252801307562e-11, -7.192269910148818e-13,  1.349258025791990e-14, -2.295994004995557e-16,  3.598200947301077e-18, -5.252288827992360e-20,
  7.203527419901152e-22, -9.345668817348843e-24,  5.015940870836603e-06, -4.087669737942895e-07,  1.876047577845510e-08, -6.294568645557475e-10,  1.710420514039613e-11,
 -3.972854205414621e-13,  8.152842927875622e-15, -1.511232179888692e-16,  2.570496548552610e-18, -4.059494144880153e-20,  6.006686624865598e-22, -8.386025048560450e-24,
  1.477543293249641e-06, -1.371565820807661e-07,  7.064462175896627e-09, -2.634110141761296e-10,  7.896406781339235e-12, -2.011764656763366e-13,  4.506758994267582e-15,
 -9.082723981279435e-17,  1.673849786732643e-18, -2.855308248045706e-20,  4.551026783917158e-22, -6.827194092816550e-24,  4.081147065556026e-07, -4.287492625112362e-08,
  2.468189073646795e-09, -1.019567292377697e-10,  3.363301858000196e-12, -9.378078059350842e-14,  2.288978785511516e-15, -5.006809685558522e-17,  9.980958814144071e-19,
 -1.836250086113780e-20,  3.148173642978257e-22, -5.067663662181276e-24,  1.060424097675127e-07, -1.253411801435185e-08,  8.033384079994667e-10, -3.665502813248253e-11,
  1.327349033655299e-12, -4.042326462439182e-14,  1.073006742224022e-15, -2.543124120136831e-17,  5.475513593610778e-19, -1.084892847320883e-20,  1.998012892085293e-22,
 -3.446705765201360e-24,  2.601798033176902e-08, -3.441409827045967e-09,  2.446655194634450e-10, -1.229622598090628e-11,  4.876524816568451e-13, -1.618768884729252e-14,
  4.664770688170865e-16, -1.196042325903688e-17,  2.777226272260622e-19, -5.918071584303571e-21,  1.169270263827553e-22, -2.158947233391631e-24,  6.054563930847295e-09,
 -8.916898509195866e-10,  7.007334659365414e-11, -3.868303757644704e-12,  1.676318579642263e-13, -6.053518505912511e-15,  1.890491427616720e-16, -5.235541280503341e-18,
  1.309206688027718e-19, -2.996410604311326e-21,  6.343226098948544e-23, -1.252087548739662e-24,  1.343212510250001e-09, -2.192242841827288e-10,  1.897813453097879e-11,
 -1.147673990691035e-12,  5.422177961577935e-14, -2.125965420898224e-15,  7.182802038147503e-17, -2.145220144553979e-18,  5.768662871302517e-20, -1.416150941109039e-21,
  3.208065979956514e-23, -6.761467131482312e-25,  2.857987583835981e-10, -5.145792197009470e-11,  4.891025271777090e-12, -3.231468157869970e-13,  1.660708465883495e-14,
 -7.055902182963879e-16,  2.574537025056865e-17, -8.278961921028108e-19,  2.390546932389871e-20, -6.286032454875447e-22,  1.521852734095679e-23, -3.420628646497258e-25,
  5.872773071390894e-11, -1.161383565748396e-11,  1.208028769591393e-12, -8.696457451786292e-14,  4.850370566866492e-15, -2.228602569818868e-16,  8.765964290058345e-18,
 -3.030088455523246e-19,  9.380550234553753e-21, -2.638326375703041e-22,  6.817054623002969e-24, -1.631928719460682e-25,  1.174814401572426e-11, -2.540749362450209e-12,
  2.882581392836087e-13, -2.254843303313997e-14,  1.361611601221065e-15, -6.751353968273547e-17,  2.857242868574136e-18, -1.059785430130296e-19,  3.511819860252535e-21,
 -1.054837947735954e-22,  2.904647545256895e-24, -7.395411333333722e-26,  2.309009047104862e-12, -5.437457390985497e-13,  6.706076478869958e-14, -5.683710078653161e-15,
  3.706670819965255e-16, -1.978900686722717e-17,  8.992432355281655e-19, -3.572216564672036e-20,  1.264799094246131e-21, -4.050420123815857e-23,  1.186737507166681e-24,
 -3.208652999833084e-26,  4.505617007199173e-13, -1.150244845003142e-13,  1.536728044735966e-14, -1.406955437168947e-15,  9.882870021831242e-17, -5.667197375467598e-18,
  2.758956947580436e-19, -1.171354863631499e-20,  4.422715483104152e-22, -1.507246874671339e-23,  4.690454050497620e-25, -1.344435446690350e-26,  8.832493180816969e-14,
 -2.433425530441611e-14,  3.508820720942958e-15, -3.459107240042634e-16,  2.609481125846650e-17, -1.602970375241134e-18,  8.339664722014218e-20, -3.775417282317408e-21,
  1.516795932036724e-22, -5.489470060207569e-24,  1.810784639158947e-25, -5.491736944683975e-27,  1.762530858832659e-14, -5.215840738987744e-15,  8.085388875141383e-16,
 -8.552743935294690e-17,  6.907103662069481e-18, -4.531766039583651e-19,  2.512653811901425e-20, -1.209719515546848e-21,  5.158553263302392e-23, -1.977909801349623e-24,
  6.900133454929562e-26, -2.209330135158187e-27,  3.632520994059281e-15, -1.148954964236591e-15,  1.906681859561019e-16, -2.155868837340283e-17,  1.857273515267124e-18,
 -1.297205633902391e-19,  7.641146112590057e-21, -3.900829170402109e-22,  1.760558122178144e-23, -7.132207672103844e-25,  2.624542349322447e-26, -8.849483835800294e-28,
  7.853776469484571e-16, -2.641302761079187e-16,  4.670886636961807e-17, -5.621462503416657e-18,  5.145779310466347e-19, -3.811775914874164e-20,  2.376974833896827e-21,
 -1.282337376904473e-22,  6.105760135020375e-24, -2.605288858085493e-25,  1.008229243675848e-26, -3.569615186821100e-28,  1.810709875058069e-16, -6.439336260410220e-17,
  1.207406962417559e-17, -1.539496006000866e-18,  1.490769588950189e-19, -1.166289648075749e-20,  7.668482194707205e-22, -4.355083982019305e-23,  2.179576009736587e-24,
 -9.760725635859961e-26,  3.958791102682540e-27, -1.466804231576165e-28,  4.525244386328568e-17, -1.691833480412346e-17,  3.345226135513981e-18, -4.495462732552240e-19,
  4.582386895184013e-20, -3.768386837011782e-21,  2.600728576737069e-22, -1.548091825574785e-23,  8.109291003498186e-25, -3.795955969012508e-26,  1.607198610829836e-27,
 -6.208258530884769e-29,  1.244790236447546e-17, -4.862587835095786e-18,  1.007857432812399e-18, -1.419334084113597e-19,  1.514602675925605e-20, -1.302364885881595e-21,
  9.386311455740157e-23, -5.827397105513383e-24,  3.179847587947166e-25, -1.548723712772248e-26,  6.814801321095126e-28, -2.732537769390434e-29,  3.814933266854567e-18,
 -1.547080409074295e-18,  3.339613304564409e-19, -4.897635191222434e-20,  5.438210427766431e-21, -4.860804025724856e-22,  3.637692939154977e-23, -2.342593146305773e-24,
  1.324533591195038e-25, -6.677597266445747e-27,  3.038490779100151e-28, -1.258570394662267e-29,  1.309379262633273e-18, -5.475486005491628e-19,  1.222447824945464e-19,
 -1.854183338510167e-20,  2.128075910249719e-21, -1.964508278265531e-22,  1.517085884440578e-23, -1.007252442498718e-24,  5.866579817668782e-26, -3.044068176270073e-27,
  1.424446051032387e-28, -6.062355362264324e-30,  4.980629324857033e-19, -2.132767788193748e-19,  4.888221231519437e-20, -7.612190128058431e-21,  8.965750473352897e-22,
 -8.488496822041313e-23,  6.718550461932090e-24, -4.568751527062387e-25,  2.723612047424074e-26, -1.445534656247899e-27,  6.914392689011287e-29, -3.005979298690560e-30,
  1.991381652364248e-19, -8.669663179462315e-20,  2.024032882515203e-20, -3.210901958878376e-21,  3.851469059886142e-22, -3.712024195239260e-23,  2.989476904459109e-24,
 -2.067525903889441e-25,  1.252931395137733e-26, -6.756742794375194e-28,  3.282408595319812e-29, -1.448584996025746e-30,  6.581766787462386e-20, -2.892050220461252e-20,
  6.822048995290864e-21, -1.093573961165398e-21,  1.325263511278322e-22, -1.290151427305494e-23,  1.049222065315038e-24, -7.325722107763553e-26,  4.480629862057003e-27,
 -2.438081379638536e-28,  1.194790345191750e-29, -5.317564042097703e-31,  6.281299208181831e-02, -1.631845934678108e-04,  4.392555994664899e-07, -1.218222953688833e-09,
  3.456397075971139e-12, -9.969755300954920e-15,  2.905541531622193e-17, -8.525509554727805e-20,  2.507573444106481e-22, -7.390641902384004e-25,  2.173563868009142e-27,
 -6.399318523014553e-30,  5.782608318245305e-02, -1.838577248989380e-04,  7.005277280868613e-07, -2.802476605675744e-09,  1.115683253544797e-11, -4.360495577216783e-14,
  1.671338060731873e-16, -6.295880192710240e-19,  2.335940885000508e-21, -8.554361344082863e-24,  3.096227480367837e-26, -1.109206744816734e-28,  4.901134340516888e-02,
 -2.129581067824546e-04,  1.145877839506892e-06, -5.974492334758435e-09,  2.960892820303315e-11, -1.408746185170153e-13,  6.490117200109969e-16, -2.911836214185140e-18,
  1.277278947807614e-20, -5.493833545798775e-23,  2.322281263962430e-25, -9.664688319299645e-28,  3.824874972919499e-02, -2.333042686098683e-04,  1.639200634036670e-06,
 -1.045949601671068e-08,  6.210231102057026e-11, -3.498395781282461e-13,  1.890417506412814e-15, -9.868537923943756e-18,  5.002286922243644e-20, -2.471618767979614e-22,
  1.194003900115579e-24, -5.653054945885187e-27,  2.748916801655851e-02, -2.323023538300397e-04,  2.025882667655178e-06, -1.544488304671227e-08,  1.080255820895479e-10,
 -7.089670648826409e-13,  4.422706894588919e-15, -2.645498621686868e-17,  1.526998443284150e-19, -8.545888671430307e-22,  4.654561888609497e-24, -2.474449255551057e-26,
  1.819846119975481e-02, -2.076101592053277e-04,  2.187613879559879e-06, -1.967117619776310e-08,  1.601070256472682e-10, -1.209543529546749e-12,  8.611688039108715e-15,
 -5.838867090451770e-17,  3.798358241569144e-19, -2.384125106934959e-21,  1.450165523176623e-23, -8.577277818598024e-26,  1.110130234186481e-02, -1.663462749925189e-04,
  2.086321414536129e-06, -2.191461308604924e-08,  2.055473236634570e-10, -1.771068699379503e-12,  1.426815443859019e-14, -1.087668177457974e-16,  7.912874518968349e-19,
 -5.529120895034068e-21,  3.729121998439309e-23, -2.437086123687758e-25,  6.242430358542969e-03, -1.198200677223405e-04,  1.771424588792812e-06, -2.155856050981553e-08,
  2.311890920903138e-10, -2.255542075441296e-12,  2.042250920677341e-14, -1.739196408863504e-16,  1.406410051550174e-18, -1.087648654289939e-20,  8.088403775523533e-23,
 -5.809035733128599e-25,  3.237357406659581e-03, -7.787698456200079e-05,  1.347071974326029e-06, -1.886073384317165e-08,  2.297520484185657e-10, -2.523116241882636e-12,
  2.553474704511727e-14, -2.416729049571058e-16,  2.161587694459502e-18, -1.841417765102477e-20,  1.503060671100909e-22, -1.181104852818045e-24,  1.549353417423957e-03,
 -4.584233575535675e-05,  9.218028451866806e-07, -1.475703559047750e-08,  2.030899740369208e-10, -2.498137185518658e-12,  2.812910756723823e-14, -2.946024988922917e-16,
  2.902583484231978e-18, -2.713107498692907e-20,  2.421627432715875e-22, -2.074496158048938e-24,  6.847881393477140e-04, -2.452473127642034e-05,  5.698903154647904e-07,
 -1.037518777907851e-08,  1.605627549734021e-10, -2.202888848632794e-12,  2.749076968990257e-14, -3.174433578421861e-16,  3.433335464690255e-18, -3.509683047086674e-20,
  3.414665487716453e-22, -3.179208405411245e-24,  2.797679045950821e-04, -1.196198799945073e-05,  3.194353872374380e-07, -6.581824804672279e-09,  1.140723564430403e-10,
 -1.739241024311413e-12,  2.397450774508691e-14, -3.042743830308336e-16,  3.601885687777414e-18, -4.015362146360243e-20,  4.246872894499627e-22, -4.286197425031688e-24,
  1.057655512556210e-04, -5.335253624837219e-06,  1.628672645540135e-07, -3.781660050629156e-09,  7.313509059829319e-11, -1.235201900659990e-12,  1.875196731072140e-14,
 -2.608627584503011e-16,  3.371115926271973e-18, -4.088364048005805e-20,  4.689665216330827e-22, -5.119148947489511e-24,  3.704730301159577e-05, -2.182224890569114e-06,
  7.577204511556452e-08, -1.974877226253043e-09,  4.247896959304494e-11, -7.924486641499898e-13,  1.321502076588161e-14, -2.010186722866135e-16,  2.829525457277142e-18,
 -3.725120401080359e-20,  4.624786972984797e-22, -5.449364576281177e-24,  1.204218220421656e-05, -8.208561847759316e-07,  3.226734692015677e-08, -9.406158589636320e-10,
  2.243597007337696e-11, -4.611059230599315e-13,  8.426964809644212e-15, -1.398653210914355e-16,  2.140085770196021e-18, -3.052706649644987e-20,  4.094591985636797e-22,
 -5.198868734246268e-24,  3.639052762659953e-06, -2.847860751971327e-07,  1.261766316634449e-08, -4.100112059219014e-10,  1.081528967388858e-11, -2.443005175443772e-13,
  4.882575371092973e-15, -8.825036857355138e-17,  1.465205771515981e-18, -2.260696644565604e-20,  3.270701581278607e-22, -4.467975115918500e-24,  1.024601528041558e-06,
 -9.140828704959058e-08,  4.545720421030883e-09, -1.641467442019237e-10,  4.776168556711240e-12, -1.183169085425924e-13,  2.580961009413396e-15, -5.071183402137733e-17,
  9.120959403201464e-19, -1.519867678737044e-20,  2.368338939084062e-22, -3.475989286612113e-24,  2.694827139889478e-07, -2.723380060390522e-08,  1.514197072063214e-09,
 -6.058275980734796e-11,  1.939832010260198e-12, -5.259268320566668e-14,  1.249929675878164e-15, -2.665403029463093e-17,  5.185459456461804e-19, -9.318807274892078e-21,
  1.561914666972640e-22, -2.459809246623474e-24,  6.641240460773707e-08, -7.559237867837024e-09,  4.681717427246747e-10, -2.069658218319073e-11,  7.276080419976171e-13,
 -2.154834357760504e-14,  5.570068791788586e-16, -1.287122526160755e-17,  2.704727886239149e-19, -5.235181969888542e-21,  9.426427917544129e-23, -1.591052802994567e-24,
  1.539166166516322e-08, -1.962816135179897e-09,  1.349394242358415e-10, -6.573563280644232e-12,  2.531859207591918e-13, -8.175359679870910e-15,  2.294735213881165e-16,
 -5.737686071637737e-18,  1.300574369750796e-19, -2.707909844539276e-21,  5.231848721079050e-23, -9.453586767399244e-25,  3.368978712856232e-09, -4.790023392518175e-10,
  3.643142256922871e-11, -1.950685644961917e-12,  8.213886973703886e-14, -2.886583214874608e-15,  8.784159337292916e-17, -2.373173300632918e-18,  5.795013871450168e-20,
 -1.296331135639738e-21,  2.684388052152888e-23, -5.187002163359920e-25,  6.999619169199493e-10, -1.104501838243471e-10,  9.263674052870538e-12, -5.438124064322699e-13,
  2.498213202374371e-14, -9.538015151475246e-16,  3.141820119425372e-17, -9.158406954879212e-19,  2.406063123098419e-20, -5.775716205247891e-22,  1.280411021280077e-23,
 -2.642887963629349e-25,  1.388610370818755e-10, -2.421165403417668e-11,  2.232300136189819e-12, -1.433139698776560e-13,  7.167753039214560e-15, -2.967724391000094e-16,
  1.056482131821027e-17, -3.318063623451864e-19,  9.366106868695938e-21, -2.409683282565861e-22,  5.712332361442693e-24, -1.258112441045560e-25,  2.648611008168993e-11,
 -5.081270190764831e-12,  5.134036976638730e-13, -3.595619384514084e-14,  1.953712545411934e-15, -8.756093029151073e-17,  3.363166336976304e-18, -1.136330103411437e-19,
  3.441647979918893e-21, -9.477835255539131e-23,  2.399627800733777e-24, -5.632754182168099e-26,  4.896488765884864e-12, -1.029280836370610e-12,  1.136107198047217e-13,
 -8.657574168333095e-15,  5.099404746199472e-16, -2.469087824961542e-17,  1.021449842045024e-18, -3.706934220513605e-20,  1.202882035155987e-21, -3.540840747516295e-23,
  9.562100627049978e-25, -2.389217990146517e-26,  8.855909378024547e-13, -2.031227586765941e-13,  2.441475428974748e-14, -2.018964860656204e-15,  1.286109339930425e-16,
 -6.713703189701173e-18,  2.985851993472665e-19, -1.161864413915777e-20,  4.032817252820190e-22, -1.266987121932676e-23,  3.644216679368487e-25, -9.678985513511156e-27,
  1.583909731997596e-13, -3.947118018361202e-14,  5.149154344310484e-15, -4.607651961047877e-16,  3.166412794303542e-17, -1.778028021577413e-18,  8.483439522411509e-20,
 -3.532764222023394e-21,  1.309274386465533e-22, -4.382630005221015e-24,  1.340438136837997e-25, -3.778477225735871e-27,  2.835999606779564e-14, -7.644801753975289e-15,
  1.078584949545834e-15, -1.041209063050070e-16,  7.697959332900595e-18, -4.638188500164331e-19,  2.368672344462356e-20, -1.053329379905082e-21,  4.159653957066886e-23,
 -1.480675068765475e-24,  4.806692774417587e-26, -1.435436194865615e-27,  5.154438443124259e-15, -1.496060212988999e-15,  2.274192938555341e-16, -2.360474813913577e-17,
  1.871838577537435e-18, -1.206773701902590e-19,  6.579143587563469e-21, -3.116554654822404e-22,  1.308365800840602e-23, -4.941522176247246e-25,  1.698993916541738e-26,
 -5.364113936830109e-28,  9.657442837570469e-16, -3.003455932242648e-16,  4.898967638322328e-17, -5.447026895115231e-18,  4.617234179272259e-19, -3.175013126655761e-20,
  1.842376701629176e-21, -9.270429839951615e-23,  4.126128449572198e-24, -1.649222764815409e-25,  5.990641661114656e-27, -1.994810298330107e-28,  1.897039542221953e-16,
 -6.288915361866356e-17,  1.095736010630930e-17, -1.299727907336857e-18,  1.173165562096547e-19, -8.573502140400459e-21,  5.277051521257009e-22, -2.811312532984109e-23,
  1.322454785794636e-24, -5.577189092283880e-26,  2.134084769573649e-27, -7.473790441367856e-29,  3.977591905915272e-17, -1.397838369494581e-17,  2.588652917962488e-18,
 -3.260647862865209e-19,  3.120357100541718e-20, -2.413484397141987e-21,  1.569518654591886e-22, -8.819451478973666e-24,  4.368846520004174e-25, -1.937228185666629e-26,
  7.782370463125234e-28, -2.857063323659325e-29,  9.067027511545048e-18, -3.357943805005722e-18,  6.573393639108205e-19, -8.746826873464747e-20,  8.830855991146884e-21,
 -7.195125880166309e-22,  4.921391502138337e-23, -2.904252483409367e-24,  1.508673187611288e-25, -7.005392670863096e-27,  2.943057620107861e-28, -1.128333759774634e-29,
  2.286861678980442e-18, -8.869267314621471e-19,  1.824190243045171e-19, -2.549424649745933e-20,  2.700417675484531e-21, -2.305373624989832e-22,  1.650000848830735e-23,
 -1.017529335630084e-24,  5.516468587755176e-26, -2.669973590758883e-27,  1.167766819008302e-28, -4.655141529851710e-30,  6.476255587397258e-19, -2.612856944956394e-19,
  5.608877372569695e-20, -8.180126833883134e-21,  9.034054118625191e-22, -8.032649712379345e-23,  5.981009654663608e-24, -3.832801049218616e-25,  2.156873485249337e-26,
 -1.082413370006175e-27,  4.903525386900054e-29, -2.022432333215975e-30,  2.075524326355226e-19, -8.649999700532415e-20,  1.924041078350111e-20, -2.907587221410785e-21,
  3.325060734673570e-22, -3.058749830711751e-23,  2.354103563632490e-24, -1.557853954777517e-25,  9.044679089031344e-27, -4.678726671565627e-28,  2.182871697260844e-29,
 -9.263561197070142e-31,  7.468607195970745e-20, -3.191865539044500e-20,  7.299737797470370e-21, -1.134282708120559e-21,  1.333131225193491e-22, -1.259553763920250e-23,
  9.949196749925570e-25, -6.752484206744161e-26,  4.017830058596841e-27, -2.128536409323033e-28,  1.016337684787258e-29, -4.410905305227101e-31,  2.868690078301641e-20,
 -1.247722671706249e-20,  2.909863090716551e-21, -4.611254358413534e-22,  5.525395096949669e-23, -5.319900889094369e-24,  4.280117636773026e-25, -2.957272869527086e-26,
  1.790439883201931e-27, -9.646586656405139e-29,  4.682138384784492e-30, -2.064539091781965e-31,  9.266370441487297e-21, -4.070151641544012e-21,  9.597020862639442e-22,
 -1.537744386654575e-22,  1.862748641064379e-23, -1.812640594090520e-24,  1.473536521241986e-25, -1.028418920543500e-26,  6.287652189019485e-28, -3.420039544786019e-29,
  1.675373831426574e-30, -7.453733149469262e-32,  6.216719052017638e-02, -1.597280981456862e-04,  4.249622786540324e-07, -1.164478668684173e-09,  3.263786495042908e-12,
 -9.300188304572903e-15,  2.677672863491205e-17, -7.764031690948666e-20,  2.256504772768002e-22, -6.574983089951102e-25,  1.910802321465162e-27, -5.565291298074821e-30,
  5.710165193687210e-02, -1.783850521855931e-04,  6.679409754257390e-07, -2.630731980822067e-09,  1.032346010477755e-11, -3.979711547546601e-14,  1.505071973099268e-16,
 -5.595354180820016e-19,  2.049149303027638e-21, -7.408167740456229e-24,  2.647312928472175e-26, -9.364911388322825e-29,  4.817740205633179e-02, -2.040700148353191e-04,
  1.076936078982367e-06, -5.522470023714259e-09,  2.694082577095190e-11, -1.262322931693233e-13,  5.729175054694974e-16, -2.533038574610010e-18,  1.095245414420693e-20,
 -4.644653186422747e-23,  1.936119121246786e-25, -7.947363110905913e-28,  3.734098810903290e-02, -2.206763437118867e-04,  1.519425345606240e-06, -9.519459064795233e-09,
  5.553773891709307e-11, -3.076124077091456e-13,  1.635234055327646e-15, -8.401418826055908e-18,  4.192800233879854e-20, -2.040263518941551e-22,  9.709471549342298e-25,
 -4.529599784183969e-27,  2.659123901958396e-02, -2.168083052887271e-04,  1.850464625223419e-06, -1.382438352314475e-08,  9.485042807674643e-11, -6.111860052843965e-13,
  3.745996142378982e-15, -2.202692676436024e-17,  1.250392364348306e-19, -6.884786518710400e-22,  3.690454784847548e-24, -1.931402129198340e-26,  1.740158652144258e-02,
 -1.910116837260427e-04,  1.966166655228989e-06, -1.729229323821855e-08,  1.378573105283076e-10, -1.021183602016497e-12,  7.134826200853392e-15, -4.750221184232008e-17,
  3.035989813679917e-19, -1.873037713950839e-21,  1.120252706102192e-23, -6.517435647290577e-26,  1.046770840112466e-02, -1.506542723165075e-04,  1.841967253653470e-06,
 -1.889160746636996e-08,  1.733176665893874e-10, -1.462491472396550e-12,  1.154919387511816e-14, -8.636223989362747e-17,  6.166912214389384e-19, -4.231730056496857e-21,
  2.804072465671348e-23, -1.801125406551043e-25,  5.789938895331043e-03, -1.066238617518652e-04,  1.533509308994780e-06, -1.819535945961571e-08,  1.906100282477420e-10,
 -1.819093923590211e-12,  1.612814565400412e-14, -1.346017248853428e-16,  1.067417982644161e-18, -8.099925750593715e-21,  5.913449457469562e-23, -4.171173565489940e-25,
  2.946052631919137e-03, -6.794686111835769e-05,  1.141236002700520e-06, -1.555726991503189e-08,  1.849078885702133e-10, -1.984241535245838e-12,  1.964435876434610e-14,
 -1.820428449639373e-16,  1.595442289402591e-18, -1.332593669092588e-20,  1.067080157311878e-22, -8.229897276934672e-25,  1.379684649588032e-03, -3.912458228340055e-05,
  7.626778698213069e-07, -1.187324431958667e-08,  1.592607013606759e-10, -1.912369118775182e-12,  2.104612308599943e-14, -2.156428690434269e-16,  2.080252695121736e-18,
 -1.905149826454520e-20,  1.667089393131103e-22, -1.400820982787097e-24,  5.950764626365615e-04, -2.042307433173398e-05,  4.594565504568243e-07, -8.125610730136914e-09,
  1.224423318749722e-10, -1.638435973440082e-12,  1.996786608777766e-14, -2.254075875821770e-16,  2.385341421575285e-18, -2.387557123298118e-20,  2.275953754895654e-22,
 -2.077352288440793e-24,  2.365712578417714e-04, -9.693858831180370e-06,  2.503504192054188e-07, -5.006361298168082e-09,  8.441336687541525e-11, -1.254291592534408e-12,
  1.687255705922298e-14, -2.092005034779582e-16,  2.421527261686553e-18, -2.641709808456668e-20,  2.736061743339592e-22, -2.705749976694421e-24,  8.676880143680376e-05,
 -4.195672581961137e-06,  1.237659944819160e-07, -2.786958668790441e-09,  5.239755498543333e-11, -8.618552625114124e-13,  1.276027351555878e-14, -1.733147764804757e-16,
  2.188880213183996e-18, -2.596441238317116e-20,  2.915159438442486e-22, -3.116642972959572e-24,  2.939551963485157e-05, -1.660389725955253e-06,  5.567948557270259e-08,
 -1.406517433962889e-09,  2.939374095718749e-11, -5.337210769008437e-13,  8.675494683382169e-15, -1.287820479447440e-16,  1.770739972089324e-18, -2.279156250256127e-20,
  2.768488088951403e-22, -3.193774842688518e-24,  9.211322062872611e-06, -6.023999616959758e-07,  2.286174601055321e-08, -6.456327925005401e-10,  1.495517201206256e-11,
 -2.990275769843066e-13,  5.324465901141951e-15, -8.620452377995185e-17,  1.287976881815589e-18, -1.795564857479513e-20,  2.355601757484374e-22, -2.927366212793998e-24,
  2.674341159480367e-06, -2.009173354373033e-07,  8.593096693302455e-09, -2.704414128912519e-10,  6.925436764605369e-12, -1.521430630427730e-13,  2.961622264585993e-15,
 -5.220091952170429e-17,  8.460412527992719e-19, -1.275433957629816e-20,  1.804366595267325e-22, -2.411982287760698e-24,  7.208465798144748e-07, -6.178260188600546e-08,
  2.966095279203636e-09, -1.037225057860367e-10,  2.929362674840737e-12, -7.056180080749020e-14,  1.498877667853294e-15, -2.871354581574348e-17,  5.040416211951874e-19,
 -8.204987601573049e-21,  1.250013486448081e-22, -1.795010475535819e-24,  1.808218262479618e-07, -1.757104903422231e-08,  9.433763613282798e-10, -3.655396511677055e-11,
  1.136026947127906e-12, -2.994665675971045e-14,  6.929993552265142e-16, -1.440668047724030e-17,  2.735265344186879e-19, -4.801591622535966e-21,  7.867774467065820e-23,
 -1.212245098822833e-24,  4.233475881969510e-08, -4.637968919221151e-09,  2.774971725655713e-10, -1.188318891833652e-11,  4.055313788798053e-13, -1.167803983966242e-14,
  2.939406947317888e-16, -6.621956227706452e-18,  1.358041434783705e-19, -2.567712690694823e-21,  4.520080617975606e-23, -7.464423749009482e-25,  9.282832025835101e-09,
 -1.140688091691474e-09,  7.580493245257956e-11, -3.578600626750633e-12,  1.338343367630728e-13, -4.202995236778406e-15,  1.148963894162509e-16, -2.801219864141273e-18,
  6.197734691956134e-20, -1.260721940059433e-21,  2.381696340667303e-23, -4.211177996242968e-25,  1.914193514242987e-09, -2.625840815816210e-10,  1.932069537492146e-11,
 -1.003081584590832e-12,  4.103062479524928e-14, -1.402910087606867e-15,  4.159198098096950e-17, -1.095984139152225e-18,  2.612986370834988e-20, -5.712171618346089e-22,
  1.156881861936082e-23, -2.188000175502298e-25,  3.730211364304044e-10, -5.686993902785123e-11,  4.618882034190212e-12, -2.631060531906126e-13,  1.174872432162763e-14,
 -4.366548794349992e-16,  1.401954013460503e-17, -3.987766083117424e-19,  1.023304559790302e-20, -2.401477862086220e-22,  5.208913627853654e-24, -1.052754406367518e-25,
  6.909324960464505e-11, -1.165780590839257e-11,  1.042032266336541e-12, -6.497551773337898e-14,  3.161326933518143e-15, -1.275073494762657e-16,  4.427152197739241e-18,
 -1.357571855594413e-19,  3.745149947009977e-21, -9.424921871380614e-23,  2.187161348149273e-24, -4.719068216014002e-26,  1.224785294376642e-11, -2.277712074733270e-12,
  2.234081555838342e-13, -1.521357034678499e-14,  8.049479487610686e-16, -3.517427838031238e-17,  1.318759230906025e-18, -4.353776241026602e-20,  1.289647166619757e-21,
 -3.476308762906377e-23,  8.621616364912295e-25, -1.983868789983873e-26,  2.094587573121735e-12, -4.276109179782705e-13,  4.588851088949144e-14, -3.404587508333701e-15,
  1.954981956516473e-16, -9.239076598184801e-18,  3.734556716259110e-19, -1.325509994814798e-20,  4.210320047330274e-22, -1.214136791949727e-23,  3.214407519219328e-25,
 -7.879357189358861e-27,  3.488518354974715e-13, -7.786679152736017e-14,  9.114881785927611e-15, -7.349525706296179e-16,  4.570362309041386e-17, -2.331551418084590e-18,
  1.014347478176213e-19, -3.864533604127892e-21,  1.314400864479378e-22, -4.049440252936457e-24,  1.142961068853057e-25, -2.980912241111741e-27,  5.720688186241412e-14,
 -1.390382428780341e-14,  1.769734064310588e-15, -1.546725651997775e-16,  1.039231760376905e-17, -5.711046943871885e-19,  2.669126640482167e-20, -1.089653853221960e-21,
  3.961958262456461e-23, -1.302036726672405e-24,  3.912248861525141e-26, -1.084075360624888e-27,  9.354477291804990e-15, -2.465055854093341e-15,  3.400323913931407e-16,
 -3.211988707665162e-17,  2.325798344079378e-18, -1.373658093774424e-19,  6.882048058056247e-21, -3.004574753264933e-22,  1.165688671952311e-23, -4.079164165690084e-25,
  1.302580404322689e-26, -3.828617363393538e-28,  1.547543514127566e-15, -4.401697401014783e-16,  6.556314031099405e-17, -6.672436341249473e-18,  5.192046345529201e-19,
 -3.287054580557248e-20,  1.761042105697042e-21, -8.203202642448418e-23,  3.388570036835939e-24, -1.260026021667812e-25,  4.267554927988696e-27, -1.327962725680798e-28,
  2.632770189833280e-16, -8.044195730821031e-17,  1.288670533177483e-17, -1.407982140147551e-18,  1.173537535933175e-19, -7.939932060484365e-21,  4.536004091366938e-22,
 -2.248390760967861e-23,  9.863477089848255e-25, -3.887822259627727e-26,  1.393322196430180e-27, -4.579727017583378e-29,  4.690199342373062e-17, -1.531521386925559e-17,
  2.627169217437652e-18, -3.069264838718616e-19,  2.730021852078296e-20, -1.967083554651596e-21,  1.194374158197653e-22, -6.279995802127546e-24,  2.917008644277368e-25,
 -1.215271688625190e-26,  4.595733070138807e-28, -1.591301021977157e-29,  8.922224380285764e-18, -3.096438700353877e-18,  5.659748247048118e-19, -7.038163730809640e-20,
  6.652257246285056e-21, -5.084021742074979e-22,  3.268242759301251e-23, -1.816161306931341e-24,  8.900546105902843e-26, -3.905991684697889e-27,  1.553526308528854e-28,
 -5.648574747292227e-30,  1.849717455688098e-18, -6.782003629049342e-19,  1.313629513846681e-19, -1.729839632979902e-20,  1.728877206877868e-21, -1.394933508265348e-22,
  9.451594342351771e-24, -5.527107403246517e-25,  2.846058589148702e-26, -1.310385141730068e-27,  5.460213921177169e-29, -2.076926135812798e-30,  4.263486069292809e-19,
 -1.640925523486670e-19,  3.347468446592803e-20, -4.640620518743073e-21,  4.876955419399281e-22, -4.131933488592034e-23,  2.935638806520211e-24, -1.797554728726767e-25,
  9.678760570339395e-27, -4.653625996018635e-28,  2.022389191602526e-29, -8.012458033547980e-31,  1.111785350718515e-19, -4.460959739826477e-20,  9.519379310026756e-21,
 -1.380172717792234e-21,  1.515520618270043e-22, -1.340049593181517e-23,  9.924284423001173e-25, -6.326778766963736e-26,  3.542497892759300e-27, -1.769175133250109e-28,
  7.977194288617471e-30, -3.275315429359206e-31,  3.315580316060420e-20, -1.376820316236615e-20,  3.050407045887718e-21, -4.591620361088800e-22,  5.230733264640762e-23,
 -4.793867496039334e-24,  3.676194334526010e-25, -2.424276454701076e-26,  1.402754349491505e-27, -7.232662068882536e-29,  3.363783034001427e-30, -1.423167233041426e-31,
  1.125222600859131e-20, -4.798767097252435e-21,  1.094922716236794e-21, -1.697420199683887e-22,  1.990462991230443e-23, -1.876456390787631e-24,  1.479038742863096e-25,
 -1.001738282955324e-26,  5.948539251489856e-28, -3.145256323025691e-29,  1.498981872833181e-30, -6.493784782176239e-32,  4.142188955770959e-21, -1.799798365229173e-21,
  4.192640947593257e-22, -6.636539110025240e-23,  7.943320281896505e-24, -7.639595610116004e-25,  6.139932758348387e-26, -4.237928265304281e-27,  2.563240289039655e-28,
 -1.379696015625184e-29,  6.690315032957836e-31, -2.947346300747142e-32,  1.305813988684288e-21, -5.733391764157073e-22,  1.351279488637936e-22, -2.164203796138980e-23,
  2.620446848042876e-24, -2.548843248756206e-25,  2.071125437871514e-26, -1.444885917477783e-27,  8.830269849184633e-29, -4.801119175426460e-30,  2.351001122670419e-31,
 -1.045559996600415e-32,  6.153499025861107e-02, -1.563834210556688e-04,  4.112958311291249e-07, -1.113711922768986e-09,  3.084037181614614e-12, -8.682839366931422e-15,
  2.470043525616662e-17, -7.078393498447713e-20,  2.032993086798376e-22, -5.857447944476536e-25,  1.682092733058200e-27, -4.848405679589454e-30,  5.639860273413586e-02,
 -1.731650507785519e-04,  6.373375992316529e-07, -2.471733092789822e-09,  9.562407771071689e-12, -3.636577622968855e-14,  1.357195432137957e-16, -4.980331632666424e-19,
  1.800563559368050e-21, -6.427221897837285e-24,  2.267909767412262e-26, -7.923369007676703e-29,  4.737794336481158e-02, -1.957124639962121e-04,  1.013171800445554e-06,
 -5.110890315138030e-09,  2.454813348995229e-11, -1.132952631287045e-13,  5.066580294064625e-16, -2.207884333503691e-18,  9.411749023938466e-21, -3.935826187528340e-23,
  1.618168460795196e-25, -6.552409185778898e-28,  3.648189078784250e-02, -2.089632228206188e-04,  1.410327130648339e-06, -8.678018220344716e-09,  4.975964821507008e-11,
 -2.710445835325139e-13,  1.417725148929654e-15, -7.170119193219823e-18,  3.523665050825533e-20, -1.688978501810046e-22,  7.919440703799163e-25, -3.640988678463054e-27,
  2.575259781577855e-02, -2.026432576552944e-04,  1.693289550362497e-06, -1.239988350119060e-08,  8.347803310708516e-11, -5.282529260077313e-13,  3.181727614784694e-15,
 -1.839532683461181e-17,  1.027184009867960e-19, -5.565466938237865e-22,  2.936565846156964e-24, -1.513226531002991e-26,  1.666773520298899e-02, -1.760763772916185e-04,
  1.771248404746005e-06, -1.524109507146477e-08,  1.190436818565279e-10, -8.648700485321251e-13,  5.931225304016581e-15, -3.878474208979807e-17,  2.435892358695573e-19,
 -1.477424110681073e-21,  8.690407693126312e-24, -4.974063904919327e-26,  9.893190767363629e-03, -1.367803181075415e-04,  1.630987845810507e-06, -1.633824706643122e-08,
  1.466547285020207e-10, -1.212231968340138e-12,  9.385884740679676e-15, -6.886372278548247e-17,  4.827641722884201e-19, -3.253899351196034e-21,  2.118766352583976e-23,
 -1.337863730172337e-25,  5.386666463420041e-03, -9.517995308269735e-05,  1.332327740175044e-06, -1.541683819705577e-08,  1.578124892775407e-10, -1.473638784744263e-12,
  1.279672191276674e-14, -1.046870126613422e-16,  8.143168381557152e-19, -6.064591533434292e-21,  4.347453569266686e-23, -3.012401619420421e-25,  2.691409838817881e-03,
 -5.951628492850903e-05,  9.710688021108027e-07, -1.289224075549043e-08,  1.495528672649507e-10, -1.568589685909421e-12,  1.519528436227940e-14, -1.379066065371725e-16,
  1.184543760307275e-18, -9.702784079955437e-21,  7.623566541602350e-23, -5.771979157433607e-25,  1.234544336324610e-03, -3.355249430908191e-05,  6.343094001610713e-07,
 -9.605533286234166e-09,  1.256116554770853e-10, -1.472786508427765e-12,  1.584549102601276e-14, -1.588730555375217e-16,  1.500921192514589e-18, -1.347072988840237e-20,
  1.155834594987968e-22, -9.528390377138881e-25,  5.201618589491537e-04, -1.710647824072416e-05,  3.727011513248134e-07, -6.404645365511982e-09,  9.399609824098968e-11,
 -1.227054279563375e-12,  1.460743431950114e-14, -1.612364262382421e-16,  1.669810636323917e-18, -1.636845444178991e-20,  1.529073757127002e-22, -1.368450381654435e-24,
  2.014510156244002e-04, -7.910173247761432e-06,  1.976161184387765e-07, -3.836276877917850e-09,  6.294426409995014e-11, -9.116939605170485e-13,  1.197062779179000e-14,
 -1.450284719339067e-16,  1.641822032877497e-18, -1.753084356914529e-20,  1.778345481759892e-22, -1.723492955950235e-24,  7.177307850073517e-05, -3.326276071565165e-06,
  9.483354255038075e-08, -2.071373111648322e-09,  3.786735122263073e-11, -6.067168683479306e-13,  8.762173036661492e-15, -1.162190961788999e-16,  1.434711980574667e-18,
 -1.664847004335215e-20,  1.829863757165055e-22, -1.916364399331622e-24,  2.354824047788977e-05, -1.275214988375944e-06,  4.130437253800349e-08, -1.011419923235060e-09,
  2.053949273776638e-11, -3.630649985459880e-13,  5.753321446618026e-15, -8.335677840556813e-17,  1.119769107038111e-18, -1.409299495218193e-20,  1.675131822490481e-22,
 -1.892235509122553e-24,  7.123637825693819e-06, -4.468417327171726e-07,  1.637292521958509e-08, -4.479952823974546e-10,  1.007873374608789e-11, -1.960857892355496e-13,
  3.402214954121622e-15, -5.373858228970141e-17,  7.841056057973413e-19, -1.068459397030114e-20,  1.371143790837776e-22, -1.667944845982699e-24,  1.989991134192108e-06,
 -1.434784586705328e-07,  5.923500842621542e-09, -1.805622541855222e-10,  4.489149734229174e-12, -9.592351092998087e-14,  1.818841496358017e-15, -3.126539166976267e-17,
  4.947063220037705e-19, -7.287428410910166e-21,  1.008196838984656e-22, -1.318889335664443e-24,  5.142887424148526e-07, -4.233152385217521e-08,  1.961729539750867e-09,
 -6.643180122811785e-11,  1.821110674716540e-12, -4.265577925886280e-14,  8.823809528082577e-16, -1.648128946679675e-17,  2.823848059982453e-19, -4.490772630561108e-21,
  6.689254543371157e-23, -9.398698651608526e-25,  1.232364156339644e-07, -1.150989211979746e-08,  5.966138230502014e-10, -2.238653600336996e-11,  6.752446963743572e-13,
 -1.730658187730384e-14,  3.899582198051002e-16, -7.903227841167052e-18,  1.464382865411731e-19, -2.511061388154939e-21,  4.022519592381555e-23, -6.063664228457501e-25,
  2.745483077906890e-08, -2.893620982128610e-09,  1.672108729248125e-10, -6.935063574959142e-12,  2.297140048972439e-13, -6.431735804472715e-15,  1.576287175557291e-16,
 -3.461852958840535e-18,  6.928529189141039e-20, -1.279629907503804e-21,  2.202188221417482e-23, -3.557980549940564e-25,  5.705036771125819e-09, -6.751513806432673e-10,
  4.335695345685733e-11, -1.983020177297965e-12,  7.199801139023308e-14, -2.198743749998593e-15,  5.853190209324288e-17, -1.391315463654384e-18,  3.004408594915240e-20,
 -5.970299635799058e-22,  1.102744909117177e-23, -1.907810260563499e-25,  1.110086479024057e-09, -1.468318160731145e-10,  1.044752948575479e-11, -5.257704425274420e-13,
  2.088677655871630e-14, -6.946876116368197e-16,  2.006110312514177e-17, -5.155194937839462e-19,  1.199836605736881e-20, -2.562888088258853e-22,  5.075981318530267e-24,
 -9.395331876133773e-26,  2.032133690543079e-10, -2.991372282345301e-11,  2.351545038428053e-12, -1.299301762263106e-13,  5.637822232322800e-15, -2.039194834399539e-16,
  6.379994233710597e-18, -1.770424013430434e-19,  4.436617066378117e-21, -1.017694657167238e-22,  2.159397592147440e-24, -4.272558584029208e-26,  3.519528397327612e-11,
 -5.742346249729786e-12,  4.973370720955927e-13, -3.010615216341270e-14,  1.424397725396317e-15, -5.594656033443088e-17,  1.893995643707499e-18, -5.669047073774969e-20,
  1.528037694212992e-21, -3.760476741108628e-23,  8.540705915920123e-25, -1.804850873848969e-26,  5.805831994898480e-12, -1.045806881203927e-12,  9.951702684631095e-14,
 -6.585974429593441e-15,  3.391624008479169e-16, -1.444424274572915e-17,  5.284150450609464e-19, -1.704002790052990e-20,  4.934895894498500e-22, -1.301662159424117e-23,
  3.161397417213114e-25, -7.129039085116570e-27,  9.195033533921255e-13, -1.821578743345184e-13,  1.899236695380630e-14, -1.371098108163678e-15,  7.671406206364314e-17,
 -3.536909166580376e-18,  1.396288990804745e-19, -4.844953794775862e-21,  1.505847155146325e-22, -4.252525156466600e-24,  1.103363635554503e-25, -2.652494097094812e-27,
  1.411392262726698e-13, -3.063176961296745e-14,  3.489472362752915e-15, -2.741704234631548e-16,  1.663420475547145e-17, -8.288495830120063e-19,  3.525651507406412e-20,
 -1.314538249082699e-21,  4.379189721479445e-23, -1.322472235186861e-24,  3.661493056886873e-26, -9.373595403230085e-28,  2.123095405523903e-14, -5.028154939259706e-15,
  6.239745802057607e-16, -5.322728215088169e-17,  3.494390211877563e-18, -1.878255518029879e-19,  8.593957447214565e-21, -3.437706450828519e-22,  1.225708942021256e-23,
 -3.952869831234524e-25,  1.166323417473442e-26, -3.175668112088523e-28,  3.170683087361502e-15, -8.160574278103303e-16,  1.099702265569113e-16, -1.015746433539312e-17,
  7.198709841225693e-19, -4.165108609430778e-20,  2.045955734439923e-21, -8.764572238052355e-23,  3.338971093261271e-24, -1.148085692283343e-25,  3.604552078481035e-27,
 -1.042303794919036e-28,  4.772203537438036e-16, -1.328998164601424e-16,  1.938105226727244e-17, -1.932564594350861e-18,  1.474603553795468e-19, -9.161695498217431e-21,
  4.820542362908436e-22, -2.206837490297635e-23,  8.964935876948157e-25, -3.280335833819328e-26,  1.093888929741721e-27, -3.353332394479929e-29,  7.364129506913729e-17,
 -2.208689802215341e-17,  3.472383419780288e-18, -3.725325886251069e-19,  3.051005702915006e-20, -2.029730136581346e-21,  1.140916139780360e-22, -5.567727748634218e-24,
  2.406096870924710e-25, -9.347640571573629e-27,  3.303552727047751e-28, -1.071325410370642e-29,  1.187778812699941e-17, -3.817310526334410e-18,  6.442148214583099e-19,
 -7.407462305849544e-20,  6.488383614074351e-21, -4.606567202678712e-22,  2.757531373589538e-23, -1.430192788800765e-24,  6.556098346845153e-26, -2.696863118776784e-27,
  1.007423263598453e-28, -3.447256568314166e-30,  2.045278610541018e-18, -7.004656133923701e-19,  1.262812724588448e-19, -1.549344788509707e-20,  1.445428712988737e-21,
 -1.090879655805452e-22,  6.928275674474676e-24, -3.805384708289102e-25,  1.844068042344121e-26, -8.005369200150330e-28,  3.150816828230197e-29, -1.134129916516071e-30,
  3.845172169862885e-19, -1.394916905000907e-19,  2.671763845000538e-20, -3.479767168855854e-21,  3.440912776014531e-22, -2.747815484544587e-23,  1.843414094497386e-24,
 -1.067711758229184e-25,  5.447365050631300e-27, -2.485819689003117e-28,  1.026935474712505e-29, -3.873945101937125e-31,  8.072392720635829e-20, -3.081684137544117e-20,
  6.232210746476977e-21, -8.565992791616297e-22,  8.927544438570027e-23, -7.503044447794713e-24,  5.289430198686225e-25, -3.214615837375475e-26,  1.718390682419058e-27,
 -8.204624197191150e-29,  3.541620981764849e-30, -1.394055816629785e-31,  1.931347046278979e-20, -7.704099372113164e-21,  1.633630398260221e-21, -2.353723011788913e-22,
  2.568809965816613e-23, -2.257995532053600e-24,  1.662722880488912e-25, -1.054161448369748e-26,  5.871117664108775e-28, -2.917081647194866e-29,  1.308793652376981e-30,
 -5.348056960488524e-32,  5.340396299305234e-21, -2.209076089595956e-21,  4.873675269139946e-22, -7.305332111964245e-23,  8.288116764118526e-24, -7.565757079932347e-25,
  5.779551501232988e-26, -3.797197127942058e-27,  2.189286769857288e-28, -1.124895450951892e-29,  5.214178560880442e-31, -2.198925292415751e-32,  1.703788852255749e-21,
 -7.249845736315839e-22,  1.650076201892162e-22, -2.551720302307842e-23,  2.985001291060180e-24, -2.807408226605495e-25,  2.207776582510842e-26, -1.492004952626778e-27,
  8.840933193189673e-29, -4.664940085018632e-30,  2.218799666187700e-31, -9.593607749394500e-33,  5.995961755122460e-22, -2.602452101661742e-22,  6.055130716184789e-23,
 -9.573106727829838e-24,  1.144454006813917e-24, -1.099422758196264e-25,  8.826127409377424e-27, -6.085366768366569e-28,  3.676742780997555e-29, -1.977024092802268e-30,
  9.577302044902061e-32, -4.215120907928610e-33,  1.841949962416230e-22, -8.084043628815601e-23,  1.904408529815520e-23, -3.048656836394537e-24,  3.689633711591657e-25,
 -3.587170746953637e-26,  2.913536033687528e-27, -2.031687216478604e-28,  1.241111566429921e-29, -6.745235317987452e-31,  3.301637285633859e-32, -1.467749475675773e-33,
  6.091595383270979e-02, -1.531456867127617e-04,  3.982217274760596e-07, -1.065725033676558e-09,  2.916151679007180e-12, -8.113096222702132e-15,  2.280648333785513e-17,
 -6.460316622174100e-20,  1.833739172467115e-22, -5.225393605155769e-25,  1.482670945301147e-27, -4.231428241844173e-30,  5.571595568140213e-02, -1.681824463474754e-04,
  6.085713524525270e-07, -2.324380741181177e-09,  8.866568161591048e-12, -3.326954319775107e-14,  1.225476928626634e-16, -4.439487208605784e-19,  1.584706348221630e-21,
 -5.586078410270577e-24,  1.946585272475504e-26, -6.717561734940991e-29,  4.661092503469217e-02, -1.878459032537818e-04,  9.541250467355250e-07, -4.735607162436079e-09,
  2.239898916215405e-11, -1.018445525816088e-13,  4.488493150395191e-16, -1.928183753824163e-18,  8.104734531898625e-21, -3.342706676933331e-23,  1.355698749056456e-25,
 -5.416189106422402e-28,  3.566796218052478e-02, -1.980840163323154e-04,  1.310794756135141e-06, -7.923448305718078e-09,  4.466338418320405e-11, -2.393063314242538e-13,
  1.231875595444904e-15, -6.134017722153419e-18,  2.968993780117369e-20, -1.402047707372307e-22,  6.478414657791029e-25, -2.935799858986632e-27,  2.496820605668960e-02,
 -1.896702064673940e-04,  1.552169169298220e-06, -1.114477513727122e-08,  7.363671250609772e-11, -4.577185968810885e-13,  2.709818667061905e-15, -1.540747918374524e-17,
  8.464590910666636e-20, -4.513885767082664e-22,  2.344859400830570e-24, -1.189951419567326e-26,  1.599065538578432e-02, -1.626068488596262e-04,  1.599236724562044e-06,
 -1.346739504217793e-08,  1.030861632184488e-10, -7.347183441392878e-13,  4.946839315678347e-15, -3.177784997982671e-17,  1.961653653314475e-19, -1.169920969182703e-21,
  6.769242409473954e-24, -3.812430611281382e-26,  9.370977576136284e-03, -1.244785273213347e-04,  1.448245589235732e-06, -1.417411483849033e-08,  1.245151015544159e-10,
 -1.008465932716521e-12,  7.657471487641374e-15, -5.513680177159128e-17,  3.795595559201261e-19, -2.513373338537595e-21,  1.608530160074171e-23, -9.986527847316843e-26,
  5.026149992832462e-03, -8.522055065619318e-05,  1.161554531536639e-06, -1.311187976355839e-08,  1.311879003172884e-10, -1.198938070415294e-12,  1.019972860652872e-14,
 -8.181076527034161e-17,  6.243421824366696e-19, -4.564392763186497e-21,  3.213488355556430e-23, -2.187754352715858e-25,  2.467956429060605e-03, -5.232814542865448e-05,
  8.297444936517189e-07, -1.073179432353391e-08,  1.215360096106258e-10, -1.246259049760316e-12,  1.181598843214176e-14, -1.050477893801247e-16,  8.845177197527046e-19,
 -7.106748835856786e-21,  5.480017259141522e-23, -4.073809171797823e-25,  1.109798732769807e-03, -2.890702985915869e-05,  5.301927024401883e-07, -7.812150387874979e-09,
  9.962477677638830e-11, -1.140866846245506e-12,  1.200247098925163e-14, -1.177864310347737e-16,  1.089991218667074e-18, -9.588825083980693e-21,  8.069185791216269e-23,
 -6.527320570681060e-25,  4.572461939414677e-04, -1.440847363976921e-05,  3.041169313484489e-07, -5.079421304171678e-09,  7.262415240265178e-11, -9.251182790500522e-13,
  1.076008328034990e-14, -1.161587825130420e-16,  1.177519707199198e-18, -1.130658746454189e-20,  1.035249756909291e-22, -9.086104432686519e-25,  1.727030869286605e-04,
 -6.497555555588395e-06,  1.570687604389076e-07, -2.960710861813649e-09,  4.728278638657368e-11, -6.677291314839926e-13,  8.559480992187012e-15, -1.013508485156449e-16,
  1.122357105986478e-18, -1.173192846421696e-20,  1.165821666056367e-22, -1.107466027382444e-24,  5.984129897740425e-05, -2.657586834605642e-06,  7.324609627476062e-08,
 -1.552164013429619e-09,  2.759698394293877e-11, -4.307935055124878e-13,  6.069878248049917e-15, -7.863517129067107e-17,  9.490350051795678e-19, -1.077503360225712e-20,
  1.159561848759002e-22, -1.189747411138435e-24,  1.903859907871379e-05, -9.882482024825475e-07,  3.092179873795872e-08, -7.341023965179056e-10,  1.448902993692871e-11,
 -2.493703663979316e-13,  3.853071982699577e-15, -5.449560935108225e-17,  7.153277313326285e-19, -8.804409090431417e-21,  1.024200210641550e-22, -1.133011823439543e-24,
  5.567700775563301e-06, -3.348922632447247e-07,  1.184821032115146e-08, -3.141375673431251e-10,  6.864942811962349e-12, -1.299743106407060e-13,  2.197778093706300e-15,
 -3.387171024166899e-17,  4.827164863432554e-19, -6.430133652603233e-21,  8.072735224571846e-23, -9.613728462402362e-25,  1.498679937193653e-06, -1.036681429374782e-07,
  4.131343372672168e-09, -1.219801657218173e-10,  2.944600954641995e-12, -6.120478517001173e-14,  1.130553339917834e-15, -1.895501600927945e-17,  2.928333279572126e-19,
 -4.215497369928261e-21,  5.703788251903902e-23, -7.302598182970933e-25,  3.719238756564519e-07, -2.938914363515878e-08,  1.314560587906937e-09, -4.310860787337951e-11,
  1.147091574644363e-12, -2.612798805357712e-14,  5.263697029419959e-16, -9.586648378869710e-18,  1.603297639076725e-19, -2.491083264502505e-21,  3.628189481286194e-23,
 -4.988172721647575e-25,  8.526965139792786e-08, -7.651209239855252e-09,  3.828389435406521e-10, -1.390985060569652e-11,  4.071973305132525e-13, -1.014714290159583e-14,
  2.226264986489924e-16, -4.398713778723953e-18,  7.954246829103515e-20, -1.332379298369108e-21,  2.086661459001120e-23, -3.077484789990054e-25,  1.810547944160621e-08,
 -1.834922689930729e-09,  1.023832537953032e-10, -4.112109733431580e-12,  1.321927935544671e-13, -3.598462405995567e-15,  8.586623551661782e-17, -1.838349381311549e-18,
  3.590498778373559e-20, -6.477364494032878e-22,  1.089757614187643e-23, -1.722540776277639e-25,  3.571226907206331e-09, -4.068020918297846e-10,  2.523660222724692e-11,
 -1.118043550036375e-12,  3.940238224849354e-14, -1.169999474535045e-15,  3.032704913202281e-17, -7.027771322134071e-19,  1.481034806661703e-20, -2.874900382150434e-22,
  5.191408117278989e-24, -8.787410428376210e-26,  6.567772577685023e-10, -8.371486222002052e-11,  5.757915109181819e-12, -2.807963938132966e-13,  1.083106402533311e-14,
 -3.503511628730158e-16,  9.853343835021271e-18, -2.468919256978265e-19,  5.608815373504430e-21, -1.170494587354348e-22,  2.266797790411451e-24, -4.105737305154807e-26,
  1.131238962035856e-10, -1.606775963543313e-11,  1.221981639290895e-12, -6.546759009664345e-14,  2.759554760512102e-15, -9.711236095756825e-17,  2.960081723388511e-18,
 -8.011851208659713e-20,  1.960311884360078e-21, -4.394467705803808e-23,  9.120021519280205e-25, -1.766272994885526e-26,  1.834744482173899e-11, -2.892626645400584e-12,
  2.426147983319801e-13, -1.425173003227944e-14,  6.554483725258853e-16, -2.506197875994841e-17,  8.270090834819399e-19, -2.415561216720647e-20,  6.359927043089796e-22,
 -1.530243095489342e-23,  3.400663265153354e-25, -7.037072695934393e-27,  2.820427529318519e-12, -4.917157124096299e-13,  4.536721275659289e-14, -2.916313172802037e-15,
  1.461102112504615e-16, -6.062139993187489e-18,  2.163170923753815e-19, -6.811411939247752e-21,  1.928031464578575e-22, -4.974867624062468e-24,  1.182915118478401e-25,
 -2.613479821051152e-27,  4.141683385689273e-13, -7.955328163681813e-14,  8.053302732441721e-15, -5.653819462205431e-16,  3.080738995865737e-17, -1.385054284587285e-18,
  5.337964458808869e-20, -1.810048726433124e-21,  5.502770531588004e-23, -1.521285103527412e-24,  3.867035215251692e-26, -9.114300523884625e-28,  5.864556407008785e-14,
 -1.236507720538286e-14,  1.369802562522547e-15, -1.048080137926129e-16,  6.200366748884213e-18, -3.016084266606599e-19,  1.253774677425869e-20, -4.572792376192644e-22,
  1.491448362481174e-23, -4.413194233759594e-25,  1.198104778827768e-26, -3.009644253867534e-28,  8.097268259034033e-15, -1.866991165824160e-15,  2.257095057783632e-16,
 -1.877933005995460e-17,  1.203879884748467e-18, -6.325516527335104e-20,  2.831958555486971e-21, -1.109432148343464e-22,  3.877136580916245e-24, -1.226460001288723e-25,
  3.552039369024693e-27, -9.499478452619378e-29,  1.104635872609181e-15, -2.774298062066093e-16,  3.649383348023090e-17, -3.293593611156288e-18,  2.283076032780820e-19,
 -1.293266117969441e-20,  6.224967817990510e-22, -2.615196174051084e-23,  9.777887633573101e-25, -3.301927342026747e-26,  1.018792938093650e-27, -2.896950905771779e-29,
  1.512145357135614e-16, -4.119408436426917e-17,  5.876870630863630e-18, -5.737317199423264e-19,  4.289782864542052e-20, -2.613884125738275e-21,  1.349892215112531e-22,
 -6.069944933648880e-24,  2.423644888148981e-25, -8.722147058129625e-27,  2.862326985519550e-28, -8.640009071124926e-30,  2.114652777767328e-17, -6.220364768059311e-18,
  9.589374315076782e-19, -1.009441635081274e-19,  8.117710838908248e-21, -5.306618388818228e-22,  2.933067391960946e-23, -1.408369960858239e-24,  5.992198955162435e-26,
 -2.293278298096038e-27,  7.988213880599578e-29, -2.554648759973307e-30,  3.083316461863242e-18, -9.744795600220763e-19,  1.616647456488742e-19, -1.828220280932378e-20,
  1.575912231778602e-21, -1.101730369684313e-22,  6.497963922613546e-24, -3.322414144282747e-25,  1.502231042818794e-26, -6.098159613122613e-28,  2.249078517945152e-29,
 -7.601880035789959e-31,  4.795197223417813e-19, -1.619429040319596e-19,  2.877512851511329e-20, -3.480771302862236e-21,  3.203180536886307e-22, -2.385814850311510e-23,
  1.496144355914403e-24, -8.117825960374352e-26,  3.887811646037264e-27, -1.668710037664791e-28,  6.496333510185739e-30, -2.313809811071002e-31,  8.151890439224328e-20,
 -2.924087555081697e-20,  5.534729940294720e-21, -7.125271342666813e-22,  6.966856077954669e-23, -5.503445047032236e-24,  3.653632264289083e-25, -2.094962414701201e-26,
  1.058491317094970e-27, -4.785198047077208e-29,  1.959054165876751e-30, -7.326122610793406e-32,  1.553452838854075e-20, -5.879176131251037e-21,  1.178050430651251e-21,
 -1.604540906172065e-22,  1.657570606967160e-23, -1.381254897201745e-24,  9.657665327332901e-26, -5.823001363526314e-27,  3.088995038158601e-28, -1.464027445197636e-29,
  6.274805781655411e-31, -2.453014744904194e-32,  3.397356171001974e-21, -1.346737354918159e-21,  2.836519449792439e-22, -4.059648843081975e-23,  4.401947162440618e-24,
 -3.845093574926830e-25,  2.814286374835607e-26, -1.773831457066537e-27,  9.823635080827514e-29, -4.854363075333983e-30,  2.166554189710082e-31, -8.808327403853426e-33,
  8.677557550401303e-22, -3.574662537466972e-22,  7.850911981045644e-23, -1.171534675258578e-23,  1.323339746336876e-24, -1.202892800034715e-25,  9.151427631710206e-27,
 -5.988786040016585e-28,  3.439683545038839e-29, -1.760862391691136e-30,  8.133016298948078e-32, -3.418105411616920e-33,  2.593686231099889e-22, -1.100986671243757e-22,
  2.499212145741531e-23, -3.854614240197390e-24,  4.497458406836727e-25, -4.219255002572646e-26,  3.309996787328363e-27, -2.231617201325409e-28,  1.319345644127471e-29,
 -6.946253557610973e-31,  3.296845728980436e-32, -1.422563301986450e-33,  8.702449730930893e-23, -3.772794696554214e-23,  8.766893439586150e-24, -1.384253641057815e-24,
  1.652769836967935e-25, -1.585785034278374e-26,  1.271542160181362e-27, -8.756769670428200e-29,  5.284847074051236e-30, -2.838625982950406e-31,  1.373665509911570e-32,
 -6.039552685186937e-34,  2.600884697326436e-23, -1.140992781791389e-23,  2.686591892679098e-24, -4.298679131727188e-25,  5.199923432351663e-26, -5.053086999541997e-27,
  4.102234918032601e-28, -2.859281723062360e-29,  1.745884351664517e-30, -9.484421172746938e-32,  4.640412613076436e-33, -2.062042175857634e-34,  6.030966274217912e-02,
 -1.500102866430085e-04,  3.857077176719866e-07, -1.020335565865026e-09,  2.759220145167293e-12, -7.586801187714502e-15,  2.107699776091940e-17, -5.902509167358745e-20,
  1.655866406539764e-22, -4.667939714828424e-25,  1.308468463533295e-27, -3.699891528241044e-30,  5.505278972408788e-02, -1.634230836489457e-04,  5.815085225399043e-07,
 -2.187683100941066e-09,  8.229610713824002e-12, -3.047201562333462e-14,  1.107978841104605e-16, -3.963110155401214e-19,  1.396939110441107e-21, -4.863454457551799e-24,
  1.673892510413808e-26, -5.706780025738536e-29,  4.587445591807732e-02, -1.804342705887515e-04,  8.993826933636595e-07, -4.392951007677081e-09,  2.046559570087659e-11,
 -9.169180766323327e-14,  3.983173841033513e-16, -1.687084510380214e-18,  6.993490695377508e-21, -2.845222071559665e-23,  1.138478327727979e-25, -4.488224559902979e-28,
  3.489601333319427e-02, -1.879661889528604e-04,  1.219848167576603e-06, -7.245573328398324e-09,  4.015953143187728e-11, -2.116994792935481e-13,  1.072699649404516e-15,
 -5.259938359973964e-18,  2.507948684209451e-20, -1.167000825324821e-22,  5.314785427291766e-25, -2.374363199077632e-27,  2.423354032190503e-02, -1.777684466149821e-04,
  1.425209956121335e-06, -1.003643046774278e-08,  6.509927331028739e-11, -3.975681745257592e-13,  2.314011068199855e-15, -1.294168383990924e-17,  6.996526467510950e-20,
 -3.672812468963883e-22,  1.878758739412943e-24, -9.390896056188976e-27,  1.536483041964781e-02, -1.504324269028137e-04,  1.447059440130812e-06, -1.192941093134102e-08,
  8.951047295655850e-11, -6.259993501744692e-13,  4.138964397798815e-15, -2.612528639947659e-17,  1.585432809308051e-19, -9.299376521585348e-22,  5.293800799678008e-24,
 -2.934262595070429e-26,  8.895204035042497e-03, -1.135405225154819e-04,  1.289475041538818e-06, -1.233374365849604e-08,  1.060652797316846e-10, -8.419194640106112e-13,
  6.270919291868021e-15, -4.432253110253812e-17,  2.996735473684383e-19, -1.949939625797541e-21,  1.226791846919853e-23, -7.490207317169525e-26,  4.702904237657667e-03,
 -7.652354120566938e-05,  1.016055762972400e-06, -1.119214308582832e-08,  1.094825812372234e-10, -9.795187847803699e-13,  8.165695345779405e-15, -6.423049854897936e-17,
  4.810151491285158e-19, -3.452714334533660e-21,  2.387813224027264e-23, -1.597527671548568e-25,  2.271148435513200e-03, -4.617405676241072e-05,  7.118551981537271e-07,
 -8.972156966146033e-09,  9.922399657537422e-11, -9.949950667221000e-13,  9.235277211027586e-15, -8.044638330476161e-17,  6.641616405231087e-19, -5.235365923164403e-21,
  3.962715433545944e-23, -2.892984188238019e-25,  1.002096064389257e-03, -2.501501124425563e-05,  4.453057010224547e-07, -6.386095725735763e-09,  7.943998634984252e-11,
 -8.887403816866395e-13,  9.145008146078625e-15, -8.785907944199251e-17,  7.965762525083384e-19, -6.870167741098781e-21,  5.671211895566814e-23, -4.502391981792228e-25,
  4.041182764915279e-04, -1.220091685740696e-05,  2.495678197701378e-07, -4.052456419327938e-09,  5.646126634229308e-11, -7.019970716392061e-13,  7.979249993911804e-15,
 -8.426368998024035e-17,  8.362933274306373e-19, -7.867386963948393e-21,  7.061851889777472e-23, -6.079406616593749e-25,  1.490178551483745e-04, -5.371205618046924e-06,
  1.256723607397862e-07, -2.300757921062288e-09,  3.577204406733825e-11, -4.926573144144327e-13,  6.166883888100704e-15, -7.138040181915675e-17,  7.733902824895284e-19,
 -7.915525493958239e-21,  7.706712714284331e-23, -7.177052635729202e-25,  5.027471917293169e-05, -2.139222420436526e-06,  5.700884777322194e-08, -1.172315271291329e-09,
  2.027586354071081e-11, -3.084349148311099e-13,  4.240781008414613e-15, -5.367057941337137e-17,  6.333712230231792e-19, -7.037141726670423e-21,  7.416068168250837e-23,
 -7.455967190466739e-25,  1.552966550583017e-05, -7.725185101078921e-07,  2.335389461470974e-08, -5.376285232312361e-10,  1.031498477666965e-11, -1.728873797594501e-13,
  2.605130751802146e-15, -3.597401947498352e-17,  4.614857176465437e-19, -5.555719809154207e-21,  6.325974270763426e-23, -6.854263652138742e-25,  4.396225946216095e-06,
 -2.534983430979814e-07,  8.660283353521888e-09, -2.225220601546801e-10,  4.724290666506177e-12, -8.705652941350667e-14,  1.434833063678505e-15, -2.157966647938397e-17,
  3.004175742441230e-19, -3.912497295978182e-21,  4.806006567635323e-23, -5.603755430630149e-25,  1.141857497395084e-06, -7.575578999207819e-08,  2.914192547898301e-09,
 -8.334812841976107e-11,  1.953778199442306e-12, -3.950741452223607e-14,  7.109971185993092e-16, -1.162819392336829e-17,  1.754152601332348e-19, -2.467979064242075e-21,
  3.266193867730702e-23, -4.093051216649287e-25,  2.725172503780279e-07, -2.066553248795636e-08,  8.921306067663562e-10, -2.833103983651829e-11,  7.317959544698796e-13,
 -1.621029561641826e-14,  3.180624529011213e-16, -5.648851287658514e-18,  9.222222616161585e-20, -1.400019765778250e-21,  1.993929970890487e-23, -2.682565692925124e-25,
  5.987126305776333e-08, -5.159139108550103e-09,  2.491518439653042e-10, -8.765148102485425e-12,  2.490260075775320e-13, -6.033604669587726e-15,  1.288979440934562e-16,
 -2.482959886638561e-18,  4.382076174404878e-20, -7.170488951809080e-22,  1.097917685433659e-23, -1.584285451363261e-25,  1.213577180463172e-08, -1.182101967675078e-09,
  6.367341516086223e-11, -2.476223770870545e-12,  7.725150469167448e-14, -2.044394819709598e-15,  4.749587985573049e-17, -9.912556181703003e-19,  1.889300252914309e-20,
 -3.329204436552704e-22,  5.475577441240488e-24, -8.467522065898495e-26,  2.275906056560038e-09, -2.494090739524477e-10,  1.494240744651474e-11, -6.410955683321159e-13,
  2.192785393922083e-14, -6.330269031284948e-16,  1.597556121308385e-17, -3.608835522279461e-19,  7.421675616226501e-21, -1.407198946470205e-22,  2.484154481874062e-24,
 -4.113846896311815e-26,  3.962534571733967e-10, -4.864311839594106e-11,  3.232887901242992e-12, -1.527366670573614e-13,  5.719213168921045e-15, -1.798907046398190e-16,
  4.926521806465623e-18, -1.203486100570603e-19,  2.668347814471560e-21, -5.439828005717321e-23,  1.030002003609168e-24, -1.825412774652553e-26,  6.432160399926515e-11,
 -8.809611917256952e-12,  6.478836216164286e-13, -3.364446057543097e-14,  1.377258220749666e-15, -4.714496388529350e-17,  1.399720260900107e-18, -3.694545083274276e-20,
  8.824622349078934e-22, -1.932961298358325e-23,  3.923029046427515e-25, -7.435791659021907e-27,  9.784721704301033e-12, -1.489590901738655e-12,  1.209281588576400e-13,
 -6.890342572842417e-15,  3.079305079264620e-16, -1.145856924179920e-17,  3.684640379492302e-19, -1.049955169536665e-20,  2.699692800024044e-22, -6.349330743797702e-24,
  1.380366618925032e-25, -2.796524205266302e-27,  1.403727102687524e-12, -2.366783625556901e-13,  2.115970926140144e-14, -1.320554231020066e-15,  6.433924333487376e-17,
 -2.599652456797596e-18,  9.045154962349635e-20, -2.780205958862115e-21,  7.689466681773472e-23, -1.940400699657601e-24,  4.515872123815171e-26, -9.772659993841490e-28,
  1.913737711565037e-13, -3.561161256994738e-14,  3.497874720346169e-15, -2.386739456926934e-16,  1.265926366271159e-17, -5.547395223199822e-19,  2.086306377225428e-20,
 -6.910808155872687e-22,  2.054312392653085e-23, -5.557946464057218e-25,  1.383695197202852e-26, -3.196421132133465e-28,  2.502468179755162e-14, -5.121404934845312e-15,
  5.513272296653964e-16, -4.105326992209375e-17,  2.366831777753233e-18, -1.123371693948651e-19,  4.561493281129281e-21, -1.626696733629183e-22,  5.192311314011834e-24,
 -1.504834082253510e-25,  4.004422933449163e-27, -9.866865819375322e-29,  3.173818760771493e-15, -7.117982685522443e-16,  8.376788383952604e-17, -6.793165017496529e-18,
  4.249824984638027e-19, -2.181552167618105e-20,  9.551665257327407e-22, -3.662826807810639e-23,  1.254054168534413e-24, -3.889414655214007e-26,  1.105208881175176e-27,
 -2.902004641243156e-29,  3.956528532741397e-16, -9.687510266405221e-17,  1.242904617930946e-17, -1.095243603283100e-18,  7.420807862640226e-20, -4.112875548496584e-21,
  1.938756451872275e-22, -7.983395052079569e-24,  2.927958638925869e-25, -9.705935222873512e-27,  2.941686681944706e-28, -8.221893623899095e-30,  4.925332296469716e-17,
 -1.311324182778465e-17,  1.828596337027601e-18, -1.746449555652490e-19,  1.278681458239953e-20, -7.636240288604335e-22,  3.868287222180057e-23, -1.707515550672807e-24,
  6.697594589068853e-26, -2.369359635605934e-27,  7.648085134994205e-29, -2.272132568482034e-30,  6.237442574035405e-18, -1.797850242827820e-18,  2.715486018550721e-19,
 -2.802581269751395e-20,  2.211427043437946e-21, -1.419561224817205e-22,  7.710322061929475e-24, -3.640644220102469e-25,  1.524179189438799e-26, -5.743202621093231e-28,
  1.970776857282713e-29, -6.212220329215347e-31,  8.209993645272463e-19, -2.549513617524239e-19,  4.154494079825922e-20, -4.617186796743196e-21,  3.913897659752794e-22,
 -2.692559787373913e-23,  1.563696781960160e-24, -7.877203036320701e-26,  3.511079888957270e-27, -1.405777870648666e-28,  5.116244234834665e-30, -1.707293878569928e-31,
  1.150761840924179e-19, -3.829316917403188e-20,  6.701180424496012e-21, -7.986348003711175e-22,  7.244669221364448e-23, -5.321966321353379e-24,  3.293327775415297e-25,
 -1.764188055643774e-26,  8.345654038653967e-28, -3.539820390251806e-29,  1.362380427185215e-30, -4.799224724951907e-32,  1.764023405605018e-20, -6.252279859474878e-21,
  1.168710666421240e-21, -1.486225291539737e-22,  1.436038582550810e-23, -1.121490057441319e-24,  7.363778497490664e-26, -4.177767468059522e-27,  2.089375753910759e-28,
 -9.353005654456706e-30,  3.792909592153724e-31, -1.405491605437010e-32,  3.040974059841028e-21, -1.140298421280735e-21,  2.262618951948644e-22, -3.052186994658531e-23,
  3.123717638008977e-24, -2.579604862868458e-25,  1.788018913759879e-26, -1.069066537853493e-27,  5.625549259648027e-29, -2.645531888787460e-30,  1.125383354916536e-31,
 -4.367757788428677e-33,  6.055909811530040e-22, -2.384592335747472e-22,  4.986480256245980e-23, -7.086143704644140e-24,  7.630726597411176e-25, -6.621050735748710e-26,
  4.814915594748557e-27, -3.016010426270028e-28,  1.660310344348664e-29, -8.157151811522802e-31,  3.620377126641994e-32, -1.464017157927481e-33,  1.423231456030952e-22,
 -5.836927873494120e-23,  1.275769265874022e-23, -1.894635097406719e-24,  2.130168244347732e-25, -1.927550503151685e-26,  1.460059387526521e-27, -9.514572168424417e-29,
  5.442544019619760e-30, -2.775260883230979e-31,  1.276981156270629e-32, -5.347292228338129e-34,  3.971010282363965e-23, -1.681283331236189e-23,  3.805622087378784e-24,
 -5.852904492370123e-25,  6.810115866323227e-26, -6.371708246811987e-27,  4.985609743220911e-28, -3.352886386435685e-29,  1.977439367273580e-30, -1.038667494443165e-31,
  4.918587840004070e-33, -2.117703445712221e-34,  1.266645377786696e-23, -5.484529343140085e-24,  1.272698125481301e-24, -2.006772136520076e-25,  2.392816267770213e-26,
 -2.292828410391056e-27,  1.836137113580254e-28, -1.262939036639595e-29,  7.612928711906924e-31, -4.084366549024074e-32,  1.974288101548048e-33, -8.670894201314816e-35,
  3.676501405708163e-24, -1.612119408108240e-24,  3.793952962617910e-25, -6.067346662302499e-26,  7.335620314661269e-27, -7.124870165646189e-28,  5.781302965018622e-29,
 -4.027653453934089e-30,  2.458133717488667e-31, -1.334752115306363e-32,  6.527560509662078e-34, -2.899356207155672e-35,  5.971571641814501e-02, -1.469728618570348e-04,
  3.737236562461415e-07, -9.773749986691417e-10,  2.612411761850408e-12, -7.100202084976424e-15,  1.949602193563313e-17, -5.398540108506325e-20,  1.496862034065815e-22,
 -4.175713141313639e-25,  1.156000707316050e-27, -3.241656674907328e-30,  5.440823836220169e-02, -1.588738312005107e-04,  5.560267143425875e-07, -2.060744055607749e-09,
  7.645888496095637e-12, -2.794113285062802e-14,  1.003015770247496e-16, -3.542858426328501e-19,  1.233325556328275e-21, -4.241510691849765e-24,  1.442007161942664e-26,
 -4.857719129955043e-29,  4.516678277373368e-02, -1.734446401231146e-04,  8.485731015433423e-07, -4.079668377715854e-09,  1.872365620171552e-11, -8.267467831956602e-14,
  3.540641677226261e-16, -1.478839583063865e-18,  6.046637554776133e-21, -2.426980435143516e-23,  9.582605409226358e-26, -3.728355786649429e-28,  3.416313049265782e-02,
 -1.785445806769059e-04,  1.136621279080737e-06, -6.635542433187602e-09,  3.617151295259827e-11, -1.876350796935185e-13,  9.360535154827167e-16, -4.520706879037961e-18,
  2.123705232151912e-20, -9.739108981102186e-23,  4.372341760962492e-25, -1.925965856869838e-27,  2.354453135139252e-02, -1.668313939191640e-04,  1.310769374120335e-06,
 -9.055554336963977e-09,  5.767517823018749e-11, -3.461390382713507e-13,  1.981099542907316e-15, -1.090061632043706e-17,  5.800188897882532e-20, -2.997843609830457e-22,
  1.510301776966815e-24, -7.436991370778117e-27,  1.478538018808054e-02, -1.394051339057621e-04,  1.312103182194725e-06, -1.059224483131198e-08,  7.792742197639575e-11,
 -5.348985408096693e-13,  3.473728323259721e-15, -2.154907459805789e-17,  1.285852395939521e-19, -7.419114673031608e-22,  4.156007392021203e-24, -2.267538422469646e-26,
  8.460775287447939e-03, -1.037891207315169e-04,  1.151122098273462e-06, -1.076363227185900e-08,  9.063672447152425e-11, -7.052877816024564e-13,  5.154228754499627e-15,
 -3.576752330105704e-17,  2.375682637812349e-19, -1.519298664759685e-21,  9.398387275911981e-24, -5.644088939566856e-26,  4.412256524111869e-03, -6.890396131031060e-05,
  8.916467847231864e-07, -9.587078315036992e-09,  9.171482244445976e-11, -8.034927786911107e-13,  6.565288807181038e-15, -5.065535748456812e-17,  3.723406290618910e-19,
 -2.624653953092872e-21,  1.783373333405991e-23, -1.172729245199291e-25,  2.097196209872182e-03, -4.088432756988572e-05,  6.130951380803266e-07, -7.532454199568167e-09,
  8.136982015965032e-11, -7.981405878351352e-13,  7.254034019045923e-15, -6.192613093684253e-17,  5.013972172158772e-19, -3.878400990271227e-21,  2.882161533222212e-23,
 -2.066746998732020e-25,  9.087043840439187e-04, -2.173876791531287e-05,  3.757486841347181e-07, -5.246116691231519e-09,  6.367468699611412e-11, -6.961142017185415e-13,
  7.007549277260810e-15, -6.592405427903596e-17,  5.857197004763260e-19, -4.953535106583474e-21,  4.011916686071854e-23, -3.126524692790566e-25,  3.590200623630561e-04,
 -1.038453795103014e-05,  2.059269427482242e-07, -3.251741701664834e-09,  4.415982000961122e-11, -5.360270655501498e-13,  5.955551275226270e-15, -6.153709290316014e-17,
  5.980630106337288e-19, -5.513314762941310e-21,  4.852403608360257e-23, -4.098146016647548e-25,  1.293817439553108e-04, -4.467232890116823e-06,  1.011965344202175e-07,
 -1.799821172113800e-09,  2.725046777128475e-11, -3.660828027839541e-13,  4.475781643313651e-15, -5.065303158932041e-17,  5.370649131825176e-19, -5.383093857401710e-21,
  5.136008352266929e-23, -4.689812267286429e-25,  4.254808527527686e-05, -1.734343008733505e-06,  4.470059038528256e-08, -8.921936106442742e-10,  1.501414065391860e-11,
 -2.226143132229749e-13,  2.987408025118770e-15, -3.694214049327575e-17,  4.263637117807789e-19, -4.636555668297170e-21,  4.785718930322864e-23, -4.715368856579961e-25,
  1.277603436420294e-05, -6.089301506660955e-07,  1.778862095244601e-08, -3.971683135132358e-10,  7.408778693568953e-12, -1.209514823497214e-13,  1.777703742393659e-15,
 -2.397169069306537e-17,  3.005835229859477e-19, -3.539992346284568e-21,  3.945997776039473e-23, -4.188281806113992e-25,  3.505539254296344e-06, -1.937332440966383e-07,
  6.391636287166352e-09, -1.591788716886660e-10,  3.283683988639919e-12, -5.890297799019007e-14,  9.464048072711925e-16, -1.389230286030925e-17,  1.889477997396083e-19,
 -2.406191174760925e-21,  2.892318248763335e-23, -3.302310079074222e-25,  8.798050072262271e-07, -5.596606645175099e-08,  2.078228943010881e-09, -5.758198119170469e-11,
  1.310856492132735e-12, -2.579013693408470e-14,  4.522493043522390e-16, -7.215798355016328e-18,  1.063034782508428e-19, -1.461889950177027e-21,  1.892545480999314e-23,
 -2.321591053547379e-25,  2.022276709008730e-07, -1.471151860935425e-08,  6.129215453340190e-10, -1.884952245684450e-11,  4.726576094102643e-13, -1.018292451425800e-14,
  1.946099882714441e-16, -3.370699048728354e-18,  5.372277708979778e-20, -7.969212384249649e-22,  1.109935378959416e-23, -1.461362459209797e-25,  4.263976465893259e-08,
 -3.527102200768391e-09,  1.643805139376931e-10, -5.599090963010098e-12,  1.543858136782933e-13, -3.637000915549971e-15,  7.565957651884806e-17, -1.420954137878866e-18,
  2.447628939361103e-20, -3.912667152053463e-22,  5.857451629576789e-24, -8.270066202169702e-26,  8.263968344611401e-09, -7.733083829165181e-10,  4.020308856486742e-11,
 -1.513704188091037e-12,  4.582550471788415e-14, -1.178964323669541e-15,  2.666682116959055e-17, -5.425286752392967e-19,  1.009081954762741e-20, -1.736851904022268e-22,
  2.792617572149863e-24, -4.224990937127907e-26,  1.475928532562197e-09, -1.555201666041497e-10,  8.995674162749094e-12, -3.737087136747704e-13,  1.240404074832623e-14,
 -3.481073850557533e-16,  8.552766326508714e-18, -1.883287478186185e-19,  3.779356743506191e-21, -6.999207502429442e-23,  1.207857096249187e-24, -1.956871695943709e-26,
  2.436812743755669e-10, -2.879250147396254e-11,  1.848416027391147e-12, -8.458037346603391e-14,  3.073923678990935e-15, -9.400241318323505e-17,  2.506493097803824e-18,
 -5.968924640128211e-20,  1.291490161761541e-21, -2.571807085967163e-23,  4.760618831411118e-25, -8.254584650176336e-27,  3.733976004543476e-11, -4.928203426388782e-12,
  3.503247610541327e-13, -1.762788376675540e-14,  7.006111981921781e-16, -2.332306856365710e-17,  6.743497104408624e-19, -1.735486169606484e-20,  4.046051388784426e-22,
 -8.658474914325080e-24,  1.718261436520068e-25, -3.186999056241549e-27,  5.336227207368806e-12, -7.838736637208589e-13,  6.156304959887667e-14, -3.401114062864058e-15,
  1.476481635030094e-16, -5.345402413958678e-18,  1.674568784920820e-19, -4.654200437719061e-21,  1.168435326294745e-22, -2.685568406298398e-24,  5.710622636646828e-26,
 -1.132464037396293e-27,  7.155297309513625e-13, -1.165858082778402e-13,  1.009406121260868e-14, -6.113059199442238e-16,  2.895165059067017e-17, -1.138805544791172e-18,
  3.862288823871174e-20, -1.158486259367935e-21,  3.129912915042643e-23, -7.722225820136804e-25,  1.758588059641090e-26, -3.726823700425809e-28,  9.069199543621009e-14,
 -1.633605311656396e-14,  1.555864878602203e-15, -1.031252875628827e-16,  5.321684255923243e-18, -2.272012709819433e-19,  8.335063485209272e-21, -2.696113155331709e-22,
  7.833848033462660e-24, -2.073495883211633e-25,  5.054247067616566e-27, -1.144018018405700e-28,  1.096470071622135e-14, -2.176183415350696e-15,  2.274900651606641e-16,
 -1.647525946680204e-17,  9.251422463982296e-19, -4.282301176453954e-20,  1.697730398383078e-21, -5.917258560092923e-23,  1.847687299375904e-24, -5.242948725292536e-26,
  1.367039028457065e-27, -3.302862127867431e-29,  1.278525207381227e-15, -2.786487376399795e-16,  3.189729554389154e-17, -2.519508479068809e-18,  1.537244496923718e-19,
 -7.705034274139044e-21,  3.297497065112221e-22, -1.237183235808726e-23,  4.147868976538483e-25, -1.260755632746730e-26,  3.513567438203962e-28, -9.054473705496738e-30,
  1.457190428248228e-16, -3.475110849459823e-17,  4.345078418834147e-18, -3.735716047882813e-19,  2.472370891243318e-20, -1.339882577841675e-21,  6.181921020301741e-23,
 -2.493740361973609e-24,  8.966948386487654e-26, -2.916474668309563e-27,  8.678786976677846e-29, -2.383223048703225e-30,  1.649672429342074e-17, -4.288374083132851e-18,
  5.840216536980043e-19, -5.452654192806837e-20,  3.906484569496351e-21, -2.284985636665733e-22,  1.134701021158807e-23, -4.914010106912658e-25,  1.892440805388190e-26,
 -6.577583057845426e-28,  2.087367148265050e-29, -6.100426735481791e-31,  1.890828611207653e-18, -5.335350335401249e-19,  7.888701961169844e-20, -7.976164171489280e-21,
  6.170966565702790e-22, -3.887186989549530e-23,  2.073430549218064e-24, -9.621512990365503e-26,  3.961324807968825e-27, -1.468822854826889e-28,  4.962693367117145e-30,
 -1.541129193515475e-31,  2.243918320695005e-19, -6.840581934013658e-20,  1.093978455923374e-20, -1.193921167412331e-21,  9.945337773932894e-23, -6.728071006013259e-24,
  3.844877008414147e-25, -1.907126604941435e-26,  8.374944530323937e-28, -3.305461162559744e-29,  1.186496809069480e-30, -3.907019702285081e-32,  2.829048159597772e-20,
 -9.268268737972562e-21,  1.596100413571908e-21, -1.872719645400305e-22,  1.673413552610668e-23, -1.211624289917600e-24,  7.394098221520874e-26, -3.908239129421095e-27,
  1.825162977384354e-28, -7.645999525799380e-30,  2.907758655165375e-31, -1.012585105082382e-32,  3.899719081144662e-21, -1.364753192609356e-21,  2.517535708191721e-22,
 -3.160323085919495e-23,  3.015643745490094e-24, -2.326893736816334e-25,  1.510240453351250e-26, -8.473120423301905e-28,  4.192276349968413e-29, -1.857334526532521e-30,
  7.457263549775375e-32, -2.736943746622513e-33,  6.060677790291795e-22, -2.250361853250412e-22,  4.419031240337333e-23, -5.900468709092516e-24,  5.979233519774327e-25,
 -4.890771268801729e-26,  3.358913608611921e-27, -1.990589644530727e-28,  1.038565574632171e-29, -4.844056666864242e-31,  2.044338088297116e-32, -7.874023946493327e-34,
  1.094735686598134e-22, -4.279914500014692e-23,  8.881457036368575e-24, -1.252598646632563e-24,  1.338982399824998e-25, -1.153589013948744e-26,  8.331786286170457e-28,
 -5.184601346090848e-29,  2.836018232182449e-30, -1.384826516447270e-31,  6.110028088803937e-33, -2.456774207392436e-34,  2.357592038294431e-23, -9.622959593692501e-24,
  2.092434051381996e-24, -3.091575216113797e-25,  3.458614020910941e-26, -3.114570007099077e-27,  2.348223690566031e-28, -1.523373821788675e-29,  8.676350210622192e-31,
 -4.405791187960782e-32,  2.019081830939524e-33, -8.422066470564550e-35,  6.116976993303268e-24, -2.582669206427594e-24,  5.828112422612471e-25, -8.936223048041201e-26,
  1.036691052598754e-26, -9.671691513289791e-28,  7.546713815116364e-29, -5.061657081976360e-30,  2.977499009512022e-31, -1.560050068004553e-32,  7.369762740981575e-34,
 -3.165687858434878e-35,  1.849197268543192e-24, -7.996352518915438e-25,  1.852847702030422e-25, -2.917251547918103e-26,  3.473440561328695e-27, -3.323640125288982e-28,
  2.658017779793033e-29, -1.825845602584175e-30,  1.099209742625940e-31, -5.890042245041550e-33,  2.843716392793477e-34, -1.247497413881862e-35,  5.202884872693395e-25,
 -2.280322181628516e-25,  5.363577532280950e-26, -8.572800134669159e-27,  1.035916828197791e-27, -1.005619538668239e-28,  8.155607611825888e-30, -5.678869112250960e-31,
  3.464174535679961e-32, -1.880115915998256e-33,  9.190302176610704e-35, -4.080194938118471e-36,  5.913373125785922e-02, -1.440292866606521e-04,  3.622413426278619e-07,
 -9.366875243783668e-10,  2.474967066058995e-12, -6.649908965773549e-15,  1.804929227480499e-17, -4.942731101752275e-20,  1.354526875618552e-22, -3.740633807470241e-25,
  1.022272601815122e-27, -2.846560347941957e-30,  5.378148572935844e-02, -1.545224951559605e-04,  5.320137644706990e-07, -1.942752922004486e-09,  7.110357161120000e-12,
 -2.564861255055117e-14,  9.091191834662218e-17, -3.171552597758503e-19,  1.090518638517367e-21, -3.705262977521811e-24,  1.244433846864184e-26, -4.143070304582919e-29,
  4.448627835596835e-02, -1.668469092926241e-04,  8.013614447427957e-07, -3.792869822613022e-09,  1.715189369496552e-11, -7.465294538751060e-14,  3.152392990308026e-16,
 -1.298617729135506e-18,  5.238142743887647e-21, -2.074560391264455e-23,  8.083801885016457e-26, -3.104539236613645e-28,  3.346664733276640e-02, -1.697605553128017e-04,
  1.060347235508438e-06, -6.085640920780085e-09,  3.263359479659319e-11, -1.666150825670985e-13,  8.184839805722351e-16, -3.894001992027618e-18,  1.802638462309222e-20,
 -8.148506470304277e-23,  3.606812474552053e-25, -1.566747370089116e-27,  2.289751133770983e-02, -1.567647277336727e-04,  1.207419180852123e-06, -8.185650501834423e-09,
  5.120418184886231e-11, -3.020550919729347e-13,  1.700324262756595e-15, -9.206183107785076e-18,  4.822259920741163e-20, -2.454400006499234e-22,  1.218029244528606e-24,
 -5.909643309470341e-27,  1.424797718082777e-02, -1.293963245432705e-04,  1.192138375655437e-06, -9.426657191597622e-09,  6.801657495955130e-11, -4.583281642451190e-13,
  2.924163122568714e-15, -1.783145755407080e-17,  1.046430200140982e-19, -5.940293248434230e-22,  3.275076482514618e-24, -1.759230932493891e-26,  8.063252166163931e-03,
 -9.507317510604307e-05,  1.030215023544257e-06, -9.419895285329569e-09,  7.769109728952737e-11, -5.927931917290578e-13,  4.251436704547010e-15, -2.897249156710763e-17,
  1.890818531391037e-19, -1.188697815910788e-21,  7.231423081027078e-24, -4.272287816765539e-26,  4.150212085024821e-03, -6.220718834737538e-05,  7.849026327615317e-07,
 -8.240097951605348e-09,  7.711235480365010e-11, -6.616822866741849e-13,  5.300468848113730e-15, -4.012407529753358e-17,  2.895401027374443e-19, -2.004735273463505e-21,
  1.338570206082745e-23, -8.653349813672087e-26,  1.942925675817518e-03, -3.632014619316374e-05,  5.300195229183770e-07, -6.349338806021076e-09,  6.701637836922570e-11,
 -6.431593742244390e-13,  5.725227379358928e-15, -4.790951991343811e-17,  3.805069003242822e-19, -2.888807552987840e-21,  2.108084241527240e-23, -1.485091966125065e-25,
  8.273857136886678e-04, -1.896827422226837e-05,  3.184765908229966e-07, -4.330153626264479e-09,  5.129498402512127e-11, -5.481198713977983e-13,  5.399331203619158e-15,
 -4.974958202109980e-17,  4.332435860356401e-19, -3.593603707012965e-21,  2.856132089504072e-23, -2.185297449499531e-25,  3.205455526365349e-04, -8.881961603635301e-06,
  1.708152515202137e-07, -2.623732022446078e-09,  3.473948934898620e-11, -4.117785282329662e-13,  4.473086364565462e-15, -4.523277908568478e-17,  4.305708059704768e-19,
 -3.890358288966912e-21,  3.357925742471138e-23, -2.782705629320594e-25,  1.130049460926822e-04, -3.737160690544401e-06,  8.199077809667428e-08, -1.416999956058355e-09,
  2.089744363209692e-11, -2.739072614967470e-13,  3.271577643598407e-15, -3.620824744343041e-17,  3.757649650932647e-19, -3.689158101996398e-21,  3.449874362401168e-23,
 -3.089300451620597e-25,  3.626346516219808e-05, -1.415794437005305e-06,  3.530041969493447e-08, -6.840158749074368e-10,  1.120240600807768e-11, -1.619293096224029e-13,
  2.121362268186827e-15, -2.563680345492582e-17,  2.894266599010356e-19, -3.081112501659600e-21,  3.115347447845127e-23, -3.008726489727414e-25,  1.059736716814401e-05,
 -4.838399183459137e-07,  1.366094542131828e-08, -2.958720294109435e-10,  5.367184735383882e-12, -8.536186409546384e-14,  1.223978883517469e-15, -1.612016567238333e-17,
  1.976087589768491e-19, -2.277026124614538e-21,  2.485171088789523e-23, -2.584307583109808e-25,  2.821927112286837e-06, -1.494297021983883e-07,  4.761511273610989e-09,
 -1.149512069030486e-10,  2.304472207341668e-12, -4.024654910307612e-14,  6.304877613883875e-16, -9.034294610315787e-18,  1.200639072680769e-19, -1.495275335374402e-21,
  1.759060541613587e-23, -1.966911054563712e-25,  6.852723010291241e-07, -4.178330156789578e-08,  1.497803890699857e-09, -4.020731999391381e-11,  8.890259455381790e-13,
 -1.702012876209622e-14,  2.908554412671388e-16, -4.527930172831536e-18,  6.515129111099997e-20, -8.758575766859377e-22,  1.109287731625719e-23, -1.332181231867876e-25,
  1.519187696647777e-07, -1.059833597617794e-08,  4.261237590073330e-10, -1.269140297259513e-11,  3.089624827546228e-13, -6.474308517666288e-15,  1.205302820841869e-16,
 -2.036092612260179e-18,  3.168383466328052e-20, -4.592937619801645e-22,  6.256267746274639e-24, -8.061752226182839e-26,  3.078864139079388e-08, -2.443769994583625e-09,
  1.098981630853708e-10, -3.624265254093702e-12,  9.698891956690697e-14, -2.221664199503561e-15,  4.500604903737886e-17, -8.241418811431032e-19,  1.385625401191464e-20,
 -2.163985785017749e-22,  3.167575763725138e-24, -4.376074543352885e-26,  5.714433281138906e-09, -5.134662542098584e-10,  2.575973155734417e-11, -9.389323523412427e-13,
  2.758240312687774e-14, -6.898499594541316e-16,  1.519163349387447e-17, -3.012874068327510e-19,  5.468627231528415e-21, -9.194275699748306e-23,  1.445211926567172e-24,
 -2.139141036113858e-26,  9.735238348023681e-10, -9.858355366635933e-11,  5.503967550969548e-12, -2.213623014339000e-13,  7.129268393520342e-15, -1.944856055962502e-16,
  4.651756819362769e-18, -9.984078912116553e-20,  1.955063400260711e-21, -3.536359686012795e-23,  5.965611785966789e-25, -9.455134691146620e-27,  1.526734976177728e-10,
 -1.735308698197748e-11,  1.075722126608503e-12, -4.766352866113919e-14,  1.680991085437856e-15, -4.997192203913867e-17,  1.297182107993278e-18, -3.011049500512425e-20,
  6.357255752986791e-22, -1.236482221872769e-23,  2.237451184951443e-25, -3.795456675383734e-27,  2.212102887420171e-11, -2.811640366781178e-12,  1.931087859693090e-13,
 -9.412611323428209e-15,  3.631251146791838e-16, -1.175346270697608e-17,  3.308897704735478e-19, -8.301730430056407e-21,  1.888831193446710e-22, -3.948479099310903e-24,
  7.660801458386876e-26, -1.390283132343542e-27,  2.974792855033171e-12, -4.213614110645312e-13,  3.199829324637321e-14, -1.713357138927359e-15,  7.222901414080134e-17,
 -2.543434620779713e-18,  7.760628079543998e-20, -2.103349428223915e-21,  5.154667742171481e-23, -1.157629615561939e-24,  2.407252320683897e-26, -4.672042185493006e-28,
  3.734215721729421e-13, -5.875242260187170e-14,  4.923414761520671e-15, -2.892036636904577e-16,  1.330891829255779e-17, -5.094557413830013e-19,  1.683690238001190e-20,
 -4.926872584373851e-22,  1.299935135134443e-23, -3.135024735928640e-25,  6.984474535331312e-27, -1.449159696602090e-28,  4.406787645017813e-14, -7.677323819726238e-15,
  7.085429123079231e-16, -4.559502453611819e-17,  2.288118269070365e-18, -9.513496218755808e-20,  3.403168164759755e-21, -1.074583296303645e-22,  3.050955737323471e-24,
 -7.897905564623171e-26,  1.884374427235764e-27, -4.178080388864879e-29,  4.932335616749278e-15, -9.485206232449158e-16,  9.621659737911505e-17, -6.773064971317198e-18,
  3.702398021680149e-19, -1.670523562359711e-20,  6.463358303390579e-22, -2.200811099455919e-23,  6.720112747757000e-25, -1.866313603478169e-26,  4.766434954949165e-28,
 -1.128833603537886e-29,  5.293113070404683e-16, -1.120030062178113e-16,  1.246137036533695e-17, -9.580764822238976e-19,  5.697589993500171e-20, -2.786885194797436e-21,
  1.165207261735528e-22, -4.275218122179799e-24,  1.402962978526680e-25, -4.177404891841908e-27,  1.141318577643945e-28, -2.885469261630070e-30,  5.519309405291380e-17,
 -1.280782371124552e-17,  1.559369733542242e-18, -1.307100937163552e-19,  8.444194268472484e-21, -4.472018012623659e-22,  2.018328663329095e-23, -7.971712668902604e-25,
  2.808945039932221e-26, -8.959659708507316e-28,  2.616603112830107e-29, -7.056449216884091e-31,  5.683496864171513e-18, -1.441147349206830e-18,  1.915135842232874e-19,
 -1.746551209422220e-20,  1.223548698094092e-21, -7.005055884706688e-23,  3.408006458332079e-24, -1.447144613415620e-25,  5.468806891945644e-27, -1.866565004648144e-28,
  5.820654089888918e-30, -1.672663392455536e-31,  5.893730175487033e-19, -1.626468466845626e-19,  2.352105929053394e-20, -2.327956525983466e-21,  1.764640300269972e-22,
 -1.090030202650202e-23,  5.706191649833841e-25, -2.600654871685582e-26,  1.052368112052423e-27, -3.837679486531419e-29,  1.276009443021951e-30, -3.901847898177189e-32,
  6.299407858491442e-20, -1.883445980099605e-20,  2.953578475581050e-21, -3.162821000372548e-22,  2.587053245181101e-23, -1.719835277471758e-24,  9.664882158006466e-26,
 -4.717371505561953e-27,  2.039760295595327e-28, -7.931564714268102e-30,  2.806468726861224e-31, -9.114620083797663e-33,  7.130517822574889e-21, -2.297873056417162e-21,
  3.891002566799088e-22, -4.491112884069397e-23,  3.950292419848785e-24, -2.817136558225477e-25,  1.694333008453970e-26, -8.831096754297644e-28,  4.068998120278806e-29,
 -1.682640341275512e-30,  6.319646782751095e-32, -2.174439420206689e-33,  8.815194046771676e-22, -3.043725407238315e-22,  5.536737941451401e-23, -6.856128052684915e-24,
  6.456577163734685e-25, -4.919144518204977e-26,  3.153997635733894e-27, -1.748894377208029e-28,  8.555939059881442e-30, -3.749626321634480e-31,  1.489807643403274e-32,
 -5.413046302686988e-34,  1.230871500567303e-22, -4.522610745173917e-23,  8.783457256281113e-24, -1.160155840180533e-24,  1.163372035246378e-25, -9.420167641938557e-27,
  6.406967066305159e-28, -3.761549004087324e-29,  1.944922801244555e-30, -8.993030032669827e-32,  3.763706412985543e-33, -1.438018770632162e-34,  2.008552167420524e-23,
 -7.792602474136336e-24,  1.603901787050530e-24, -2.243891800178378e-25,  2.379939986953586e-26, -2.034985740948141e-27,  1.459106123155590e-28, -9.016112082620716e-30,
  4.898696759022296e-31, -2.376523755663830e-32,  1.042000741192975e-33, -4.164590777694322e-35,  3.946900863758371e-24, -1.602785712985517e-24,  3.465887304596836e-25,
 -5.092861027674777e-26,  5.667207343514908e-27, -5.077231077512733e-28,  3.808983786165271e-29, -2.459205896095665e-30,  1.394182965936662e-31, -7.048124723719654e-33,
  3.216179013353180e-34, -1.336019448042850e-35,  9.484385732937113e-25, -3.992476531901816e-25,  8.980048815032384e-26, -1.372428704638908e-26,  1.587104993734645e-27,
 -1.476123017383378e-28,  1.148383720807125e-29, -7.680259452490476e-31,  4.505393312445379e-32, -2.354289870853666e-33,  1.109317832104953e-34, -4.753283330859315e-36,
  2.708428371468031e-25, -1.169522353254543e-25,  2.705655630365964e-26, -4.253272866753903e-27,  5.056389344233377e-28, -4.831086726438606e-29,  3.857972164722455e-30,
 -2.646402489457888e-31,  1.591046817194247e-32, -8.514333807020460e-34,  4.105509712905426e-35, -1.798823165059038e-36,  7.371860039983608e-26, -3.229286099131043e-26,
  7.591282583146155e-27, -1.212638347580053e-27,  1.464484307825547e-28, -1.420854960253514e-29,  1.151686201412167e-30, -8.015068941861367e-32,  4.886731642173637e-33,
 -2.650832813885086e-34,  1.295125990801112e-35, -5.747164696549283e-37,  5.856333972169755e-02, -1.411756536870063e-04,  3.512343752091238e-07, -8.981289623714392e-10,
  2.346191095295011e-12, -6.232855897400028e-15,  1.672404081728810e-17, -4.530063227262726e-20,  1.226932100324300e-22, -3.355735398715570e-25,  9.046980703312280e-28,
 -2.506134347134286e-30,  5.317176299967366e-02, -1.503577413936959e-04,  5.093667715393357e-07, -1.832975386211828e-09,  6.618504331205895e-12, -2.356946726545769e-14,
  8.250073537680109e-17, -2.843002781164167e-19,  9.656667290943980e-22, -3.242100079078585e-24,  1.075768011785856e-26, -3.540393255331983e-29,  4.383143068382090e-02,
 -1.606135210328757e-04,  7.574456163148353e-07, -3.529984953401502e-09,  1.573164199519734e-11, -6.750526505711931e-14,  2.811167146748582e-16, -1.142348316360364e-18,
  4.546357840010053e-21, -1.776944609230248e-23,  6.834356482885263e-26, -2.591134603246826e-28,  3.280412036449311e-02, -1.615612583552770e-04,  9.903457623398528e-07,
 -5.589130446070195e-09,  2.948922343113709e-11, -1.482172825015210e-13,  7.171058457532502e-16, -3.361438012664111e-18,  1.533682262099164e-20, -6.834701628502001e-23,
  2.983217554860617e-25, -1.278108119053601e-27,  2.228916809894814e-02, -1.474848031148066e-04,  1.113914569955686e-06, -7.412579791177224e-09,  4.555114593281193e-11,
 -2.641740545717302e-13,  1.462890745987681e-15, -7.795516004565773e-18,  4.020451613842539e-20, -2.015455676610614e-22,  9.854101650116043e-25, -4.711526348297484e-27,
  1.374877490080474e-02, -1.202938692761242e-04,  1.085257487650167e-06, -8.408074582101298e-09,  5.951324397167472e-11, -3.937801218249498e-13,  2.468719356714435e-15,
 -1.480119770496310e-17,  8.544072430322395e-20, -4.772867658484520e-22,  2.590358193026940e-24, -1.370121360892725e-26,  7.698755683257744e-03, -8.726334426149942e-05,
  9.242606149345692e-07, -8.266404770608136e-09,  6.679324140949885e-11, -4.998473802727253e-13,  3.518860077375973e-15, -2.355421474585534e-17,  1.510721474887659e-19,
 -9.338054959812632e-22,  5.587676373255565e-24, -3.248191489565477e-26,  3.913343865790138e-03, -5.630348010073894e-05,  6.930089221182094e-07, -7.105621593264478e-09,
  6.506496102093011e-11, -5.469689138388719e-13,  4.296554845847855e-15, -3.191719406958060e-17,  2.261553237106584e-19, -1.538358453680815e-21,  1.009573242000863e-23,
 -6.417230611689590e-26,  1.805667357513724e-03, -3.236746108367684e-05,  4.598595385360207e-07, -5.372949075773503e-09,  5.542531002008551e-11, -5.205661790428870e-13,
  4.539683948594419e-15, -3.724648115599604e-17,  2.902349462397270e-19, -2.163106092254239e-21,  1.550365053949235e-23, -1.073187106288372e-25,  7.562978043037522e-04,
 -1.661514627514473e-05,  2.710988840059244e-07, -3.590539221332487e-09,  4.152321051110166e-11, -4.337972694425637e-13,  4.182456885382219e-15, -3.775273453862188e-17,
  3.223136805635543e-19, -2.622623331414960e-21,  2.045870567879220e-23, -1.537134722422234e-25,  2.875639066313946e-04, -7.632519624431551e-06,  1.424114661105877e-07,
 -2.128356028381605e-09,  2.748240086824925e-11, -3.181864260731925e-13,  3.380127845477012e-15, -3.345832066498042e-17,  3.120081920375729e-19, -2.763599437433506e-21,
  2.339779780922182e-23, -1.902892818660296e-25,  9.926797243132806e-05, -3.143956598475131e-06,  6.682508731235244e-08, -1.122521622338488e-09,  1.612889095215759e-11,
 -2.063104164410043e-13,  2.407878881706042e-15, -2.606688968279226e-17,  2.648325902517238e-19, -2.547241065831914e-21,  2.335104607752467e-23, -2.050996214857079e-25,
  3.111710738809792e-05, -1.163406086917314e-06,  2.806912322142476e-08, -5.281462782894675e-10,  8.419805747220989e-12, -1.186785061206057e-13,  1.518095460274017e-15,
 -1.793308032313995e-17,  1.980738319062825e-19, -2.064557992261701e-21,  2.045251960173572e-23, -1.936426154012047e-25,  8.859998472769770e-06, -3.874144314900917e-07,
  1.057417169999624e-08, -2.222004185601474e-10,  3.920536663082116e-12, -6.075759014705202e-14,  8.500686534032650e-16, -1.093663782213798e-17,  1.310886369452927e-19,
 -1.478163242863339e-21,  1.579835943385707e-23, -1.609804332567123e-25,  2.292466698644984e-06, -1.162846841122204e-07,  3.579209083594262e-09, -8.377573144545017e-11,
  1.632417616219834e-12, -2.776148702269297e-14,  4.241019244697128e-16, -5.933032055910201e-18,  7.705684927612841e-20, -9.386487585107058e-22,  1.080852055662012e-23,
 -1.183748127335157e-25,  5.393583404550951e-07, -3.151261121720429e-08,  1.090549495026380e-09, -2.836606254220979e-11,  6.092635459549429e-13, -1.135173026528701e-14,
  1.890710068963793e-16, -2.872238854874437e-18,  4.037003542136539e-20, -5.305980382348241e-22,  6.575152683961457e-24, -7.731300631145653e-26,  1.154857045429900e-07,
 -7.723403761678657e-09,  2.996750018747345e-10, -8.644223473470208e-12,  2.043187745100608e-13, -4.164848856364147e-15,  7.553626296277621e-17, -1.244648210450691e-18,
  1.891171332637589e-20, -2.679294168739087e-22,  3.569659425900413e-24, -4.502273760081127e-26,  2.252971621355722e-08, -1.715199661364376e-09,  7.442227075310871e-11,
 -2.376249609350601e-12,  6.171924098330210e-14, -1.374735521940838e-15,  2.712122666429271e-17, -4.842644279545316e-19,  7.947529920371931e-21, -1.212687408898518e-22,
  1.735738054866831e-24, -2.346517720137664e-26,  4.010720629462478e-09, -3.458875295782449e-10,  1.674226365099024e-11, -5.907280787634664e-13,  1.683861396605081e-14,
 -4.094095756990627e-16,  8.777944361438715e-18, -1.697083536425353e-19,  3.006107387823597e-21, -4.936934739431839e-23,  7.586604838256920e-25, -1.098649012310749e-26,
  6.528219046069717e-10, -6.349850126809590e-11,  3.420997447555264e-12, -1.331827033614519e-13,  4.161624084761878e-15, -1.103502600334895e-16,  2.569345364127432e-18,
 -5.375051800056635e-20,  1.027018135341658e-21, -1.814391500094615e-23,  2.991954456256258e-25, -4.639031622747501e-27,  9.740792113786345e-11, -1.064416914245507e-11,
  6.369386981294994e-13, -2.732166695331114e-14,  9.349221788186978e-16, -2.701467555220530e-17,  6.826229125211815e-19, -1.544366849040802e-20,  3.181476022825641e-22,
 -6.043523956118291e-24,  1.068983509774906e-25, -1.773926264620654e-27,  1.336784168990259e-11, -1.635215090485144e-12,  1.084681977313893e-13, -5.119923455349982e-15,
  1.916820139104013e-16, -6.031316677653441e-18,  1.653026499159787e-19, -4.042543987868325e-21,  8.975108384471334e-23, -1.832539754556138e-24,  3.475742855708991e-26,
 -6.171182803476193e-28,  1.694465072523058e-12, -2.312657825973043e-13,  1.697353721367510e-14, -8.805493385654801e-16,  3.603666830749305e-17, -1.233957008585767e-18,
  3.666348235701091e-20, -9.688003576802379e-22,  2.317256147830182e-23, -5.084014260102555e-25,  1.033698908259017e-26, -1.963166045177304e-28,  1.994516102514156e-13,
 -3.027884891263110e-14,  2.454467834196393e-15, -1.397800763391328e-16,  6.248064607393945e-18, -2.326778758972182e-19,  7.491093152074437e-21, -2.137974971083610e-22,
  5.507519036278356e-24, -1.298031543945575e-25,  2.828495560097300e-27, -5.744554140580919e-29,  2.194899750586833e-14, -3.695322822986852e-15,  3.302661640968440e-16,
 -2.062267947799582e-17,  1.005974005115354e-18, -4.071690120573835e-20,  1.419731443004023e-21, -4.374681235095420e-23,  1.213297435766731e-24, -3.070900394288263e-26,
  7.169750957129551e-28, -1.556801687323639e-29,  2.277472974836357e-15, -4.239927060588855e-16,  4.170520909878469e-17, -2.851869371599690e-18,  1.516770235389106e-19,
 -6.667828162976017e-21,  2.516613463517982e-22, -8.368360943009840e-24,  2.497803085589217e-25, -6.786951850955444e-27,  1.697239103141664e-28, -3.938836696832920e-30,
  2.251962004607459e-16, -4.622152095410766e-17,  4.994402194255084e-18, -3.735064821325506e-19,  2.163677785967161e-20, -1.032239295751435e-21,  4.214260878449946e-23,
 -1.511402080597536e-24,  4.852611895915787e-26, -1.414854181215655e-27,  3.788133305693903e-29, -9.392201617601351e-31,  2.150108186383856e-17, -4.850276924698167e-18,
  5.745457313798165e-19, -4.691904399919655e-20,  2.956780928182150e-21, -1.529299220706627e-22,  6.747886962906923e-24, -2.608140921405114e-25,  9.001315460084105e-27,
 -2.814399651507644e-28,  8.062773340597508e-30, -2.134474770320827e-31,  2.014682449935640e-18, -4.978117840627784e-19,  6.449598321365574e-20, -5.740852189761385e-21,
  3.929766410293354e-22, -2.200708582989943e-23,  1.048272991240798e-24, -4.362061100803551e-26,  1.616702086305714e-27, -5.415800231161791e-29,  1.658723430635178e-30,
 -4.684704799149049e-32,  1.889817221422104e-19, -5.095513867835251e-20,  7.200780284497521e-21, -6.970638108647095e-22,  5.173078709152278e-23, -3.131319932496749e-24,
  1.607697791303816e-25, -7.192095478441512e-27,  2.858742842592639e-28, -1.024726294989416e-29,  3.351208333934731e-31, -1.008542523115702e-32,  1.817605746037429e-20,
 -5.324769427189490e-21,  8.180667964561475e-22, -8.588479074534324e-23,  6.892884521328718e-24, -4.499679052004825e-25,  2.484942532813529e-26, -1.192751601410973e-27,
  5.075092521054912e-29, -1.943142270585415e-30,  6.773852748856057e-32, -2.168638512676232e-33,  1.844059039979326e-21, -5.840265535355114e-22,  9.715598345107908e-23,
 -1.102284156991006e-23,  9.536458658750957e-25, -6.693800348691450e-26,  3.965040351835157e-27, -2.036616849153865e-28,  9.252825753206012e-30, -3.774869413573624e-31,
  1.399409900112001e-32, -4.755055501244765e-34,  2.039353050214637e-22, -6.941693880388210e-23,  1.244222910148707e-23, -1.518686784469988e-24,  1.410460143027675e-25,
 -1.060351895584113e-26,  6.711981147658419e-28, -3.676196053911171e-29,  1.777272363408090e-30, -7.700515630430249e-32,  3.026154816116725e-33, -1.087963636544606e-34,
  2.549706841232533e-23, -9.264308246530431e-24,  1.778251507293466e-24, -2.321940993355993e-25,  2.302645233911824e-26, -1.844673218725836e-27,  1.241775066020372e-28,
 -7.218680574641109e-30,  3.697068000229958e-31, -1.693871112256069e-32,  7.026785865414541e-34, -2.662073457262726e-35,  3.743451703433616e-24, -1.440492112700309e-24,
  2.939091136898139e-25, -4.076646712581491e-26,  4.287937436072177e-27, -3.637087062384830e-28,  2.587728292828061e-29, -1.587145864287264e-30,  8.561803658443064e-32,
 -4.125058321909554e-33,  1.796676282157829e-34, -7.135097393974125e-36,  6.682469801847822e-25, -2.698798477799524e-25,  5.801399664019414e-26, -8.474847303923768e-27,
  9.376991619167791e-28, -8.354681563682057e-29,  6.234574514847966e-30, -4.004719359458211e-31,  2.259219923823262e-32, -1.136717785246949e-33,  5.163391290336076e-35,
 -2.135503221611095e-36,  1.480871985766945e-25, -6.213734658720813e-26,  1.392708852549627e-26, -2.121059263188848e-27,  2.444496859521062e-28, -2.266077710933001e-29,
  1.757345759041871e-30, -1.171691232216254e-31,  6.853066624144739e-33, -3.570863948904592e-34,  1.677933853248948e-35, -7.170733849625386e-37,  3.980675550712768e-26,
 -1.716265896202820e-26,  3.963829625549200e-27, -6.220613656347282e-28,  7.383026022244356e-29, -7.042769713067948e-30,  5.615450690099771e-31, -3.846187691441400e-32,
  2.309023340430872e-33, -1.233922552369874e-34,  5.941779194118795e-36, -2.599987387867775e-37,  1.045834967281426e-26, -4.578855435891847e-27,  1.075725336041633e-27,
 -1.717319791062233e-28,  2.072725820730298e-29, -2.009784948588065e-30,  1.628106426303222e-31, -1.132428863640344e-32,  6.900545673827057e-34, -3.741232365455140e-35,
  1.826912437743691e-36, -8.102875432546275e-38,  5.800418948777437e-02, -1.384082600459132e-04,  3.406780178038186e-07, -8.615657770617115e-10,  2.225447251724145e-12,
 -5.846267189635633e-15,  1.550882211978509e-17, -4.156096591396910e-20,  1.112381901711496e-22, -3.015016001630116e-25,  8.010304131442085e-28, -2.213390245428835e-30,
  5.257834509145096e-02, -1.463690249465720e-04,  4.879912287083564e-07, -1.730745495784879e-09,  6.166287968670046e-12, -2.168158760866839e-14,  7.495597496010014e-17,
 -2.551862954873633e-19,  8.563355587153938e-22, -2.841387366083609e-24,  9.315023328961811e-27, -3.031211867330923e-29,  4.320083335929960e-02, -1.547192166526961e-04,
  7.165526394486983e-07, -3.288723534468528e-09,  1.444649638062985e-11, -6.112642606618182e-14,  2.510751982690162e-16, -1.006593961199752e-18,  3.953237479623404e-21,
 -1.525066546824722e-23,  5.790377305680675e-26, -2.167568342952917e-28,  3.217330712365385e-02, -1.538989688190664e-04,  9.260122829872339e-07, -5.140113561815406e-09,
  2.668963670096100e-11, -1.320829212230830e-13,  6.295023880666345e-16, -2.907830137265564e-18,  1.307823183003552e-20, -5.746677573316773e-23,  2.473831099379236e-25,
 -1.045501523157670e-27,  2.171650514095433e-02, -1.389172899825111e-04,  1.029168150182855e-06, -6.724193376483790e-09,  4.060180224190933e-11, -2.315450324525149e-13,
  1.261589133381593e-15, -6.617841940907417e-18,  3.361111654783464e-20, -1.659813472335567e-22,  7.996631062286743e-25, -3.768445152315920e-27,  1.328434661930399e-02,
 -1.119997876609723e-04,  9.898240250183438e-07, -7.515783833504798e-09,  5.219809692163603e-11, -3.392102956716874e-13,  2.090116215942687e-15, -1.232313607685817e-17,
  6.998681044823947e-20, -3.847921868831633e-22,  2.056126301490347e-24, -1.071075771055338e-26,  7.363886912440508e-03, -8.024861004027124e-05,  8.311602833848367e-07,
 -7.273314686523393e-09,  5.759009608941413e-11, -4.227922640045277e-13,  2.922260717736776e-15, -1.921728853964853e-17,  1.211561765900989e-19, -7.364616610783590e-22,
  4.335374418780948e-24, -2.480200718927316e-26,  3.698701993801354e-03, -5.108357733418389e-05,  6.136440522322802e-07, -6.146784303579003e-09,  5.508838667816117e-11,
 -4.538065133684612e-13,  3.496390653489070e-15, -2.549358429210253e-17,  1.774107520908080e-19, -1.185816793735590e-21,  7.650242137363786e-24, -4.782221748421810e-26,
  1.683167208158971e-03, -2.893216513389934e-05,  4.003796560035885e-07, -4.563851542417958e-09,  4.602416902176334e-11, -4.231469847688874e-13,  3.615903671309488e-15,
 -2.909388537114578e-17,  2.224742950530636e-19, -1.628042545564204e-21,  1.146280271191005e-23, -7.798071221607187e-26,  6.939170385061006e-04, -1.460803241343918e-05,
  2.317290681807388e-07, -2.990460994364576e-09,  3.377110433014059e-11, -3.450196398788899e-13,  3.256637027712330e-15, -2.880372854173388e-17,  2.411330399895975e-19,
 -1.925124535303195e-21,  1.474270577923042e-23, -1.087905202665102e-25,  2.591606063677277e-04, -6.588370281637300e-06,  1.193129549701345e-07, -1.735439098114320e-09,
  2.185948254655217e-11, -2.472629857063601e-13,  2.569316745701811e-15, -2.490045731884004e-17,  2.275246970813026e-19, -1.975996870545069e-21,  1.641289690920246e-23,
 -1.310222160531646e-25,  8.768184011294457e-05, -2.659144237429463e-06,  5.477656855749331e-08, -8.945611126541438e-10,  1.252606562138602e-11, -1.564008614250865e-13,
  1.784055070052252e-15, -1.889547493306972e-17,  1.879747489712323e-19, -1.771608082051384e-21,  1.592363919458844e-23, -1.372072600210791e-25,  2.687546049505497e-05,
 -9.620822635137153e-07,  2.246731658608170e-08, -4.105970150430078e-10,  6.373335793205022e-12, -8.761691228704221e-14,  1.094568917458925e-15, -1.264129697019518e-17,
  1.366290554560065e-19, -1.394606693520659e-21,  1.353837007208618e-23, -1.256808461390662e-25,  7.464032470541140e-06, -3.125059261008689e-07,  8.247363630411349e-09,
 -1.681807349917760e-10,  2.886853017792613e-12, -4.360176548125334e-14,  5.953660559619429e-16, -7.483890809855057e-18,  8.772608350091460e-20, -9.681744219059722e-22,
  1.013475199003834e-23, -1.012075230704957e-25,  1.878803773094693e-06, -9.126709479368202e-08,  2.713938143070009e-09, -6.159770050839808e-11,  1.166833868293511e-12,
 -1.932637622861828e-14,  2.879591895914061e-16, -3.933660724391640e-18,  4.993618601588927e-20, -5.950519951978669e-22,  6.707846360695597e-24, -7.196541474098517e-26,
  4.288139391651030e-07, -2.399984521604857e-08,  8.018836888240283e-10, -2.021250089602005e-11,  4.217773980705961e-13, -7.649107514362980e-15,  1.241891745373715e-16,
 -1.841248166620499e-18,  2.528272293723867e-20, -3.249238803055613e-22,  3.940070926591656e-24, -4.536579268201577e-26,  8.880078050506326e-08, -5.691096592893253e-09,
  2.130995424944332e-10, -5.953723514848396e-12,  1.366465425669643e-13, -2.709810887762715e-15,  4.788461532405713e-17, -7.697041357180505e-19,  1.142083406409030e-20,
 -1.581495941622969e-22,  2.061095843873179e-24, -2.544686544082562e-26,  1.670028798322234e-08, -1.218974624488643e-09,  5.102810120360569e-11, -1.577473844626790e-12,
  3.976831518693001e-14, -8.614011492657768e-16,  1.655098825825199e-17, -2.881847582119697e-19,  4.616979564027339e-21, -6.883567614826281e-23,  9.634767169690250e-25,
 -1.274649842271332e-26,  2.855881731231655e-09, -2.362794950373306e-10,  1.103291561542131e-11, -3.768085527743856e-13,  1.042213339684863e-14, -2.463449196887781e-16,
  5.142507192126928e-18, -9.692444697337608e-20,  1.675536194216259e-21, -2.688041105712634e-23,  4.038473035949727e-25, -5.721983309009107e-27,  4.448435116224266e-10,
 -4.153958827732472e-11,  2.159089974547619e-12, -8.135421489406071e-14,  2.466259123340226e-15, -6.356232718414103e-17,  1.440649746962534e-18, -2.937527785753126e-20,
  5.476672828481647e-22, -9.449853258428768e-24,  1.523256723134229e-25, -2.310487538448326e-27,  6.325717522623681e-11, -6.641733866771064e-12,  3.835279549057343e-13,
 -1.592375840444701e-14,  5.286208149921591e-16, -1.484529191292048e-17,  3.651253901755977e-19, -8.050749951729588e-21,  1.618142934610304e-22, -3.001928761846424e-24,
  5.190107027728393e-26, -8.425115206049288e-28,  8.236433939927716e-12, -9.690252870329821e-13,  6.205552846610502e-14, -2.835809341737683e-15,  1.030095469475067e-16,
 -3.150342669154193e-18,  8.404569239375299e-20, -2.003215408381265e-21,  4.339363726819122e-23, -8.653137753851916e-25,  1.604269376284242e-26, -2.786449054315177e-28,
  9.857639566450408e-13, -1.295472227493817e-13,  9.184926992006767e-15, -4.614936055682651e-16,  1.832999588134793e-17, -6.101863112815804e-19,  1.765083029165833e-20,
 -4.546454679856216e-22,  1.061185231097211e-23, -2.274159508728847e-25,  4.520439686618579e-27, -8.399654568157938e-29,  1.089865400478736e-13, -1.595210295932089e-14,
  1.250190458689173e-15, -6.899667185272021e-17,  2.994572026278540e-18, -1.084567852070439e-19,  3.400657714382449e-21, -9.463712292323814e-23,  2.379684216790328e-24,
 -5.479821749587694e-26,  1.167689101794636e-27, -2.320936852934911e-29,  1.120230333899352e-14, -1.821106146936700e-15,  1.575183016311261e-16, -9.539379928735000e-18,
  4.521196901006899e-19, -1.780743970447662e-20,  6.050229032422458e-22, -1.818691159441026e-23,  4.925816207947536e-25, -1.218653730891815e-26,  2.783488226057455e-28,
 -5.917400482480299e-30,  1.079196780330501e-15, -1.943259624301895e-16,  1.852196822526767e-17, -1.229630177744863e-18,  6.359660162314104e-20, -2.722666859686801e-21,
  1.002010270035989e-22, -3.252585054195215e-24,  9.486697436980619e-26, -2.521122604217509e-27,  6.171389214360532e-29, -1.403021502528618e-30,  9.844974883567893e-17,
 -1.958181434813323e-17,  2.053337839821806e-18, -1.492679495482658e-19,  8.417992277392551e-21, -3.914939017506990e-22,  1.559951007130364e-23, -5.466086264079449e-25,
  1.716309725526453e-26, -4.898172563388675e-28,  1.284683983958866e-29, -3.122582282219511e-31,  8.615184519217403e-18, -1.887373328805673e-18,  2.173393550890195e-19,
 -1.727862559264312e-20,  1.061485252007715e-21, -5.358633929689695e-23,  2.310336331110019e-24, -8.734079768631880e-26,  2.950966539602799e-27, -9.040159211015746e-29,
  2.539437853267405e-30, -6.596619302491367e-32,  7.349688352368824e-19, -1.767877934973482e-19,  2.231069430549086e-20, -1.936760872597262e-21,  1.294508643628297e-22,
 -7.086292629676419e-24,  3.302837400823317e-25, -1.346048187774365e-26,  4.890139161809769e-28, -1.606990291234292e-29,  4.831650357063045e-31, -1.340519243604776e-32,
  6.236242824286628e-20, -1.641193519503304e-20,  2.264308607187468e-21, -2.142119779596918e-22,  1.555194580657760e-23, -9.218331025958588e-25,  4.638865972876885e-26,
 -2.035673971995830e-27,  7.943433724856752e-29, -2.797252816021798e-30,  8.992991139434018e-32, -2.662283136436639e-33,  5.393538462727833e-21, -1.546632521265975e-21,
  2.325783575564097e-22, -2.391835934721184e-23,  1.882044521496377e-24, -1.205568572801514e-25,  6.538134399411247e-27, -3.084158963120820e-28,  1.290564765226722e-29,
 -4.862604555882910e-31,  1.669127747581775e-32, -5.264833589065894e-34,  4.897158350536601e-22, -1.522798223432545e-22,  2.486529715055680e-23, -2.770693244776122e-24,
  2.355933579783242e-25, -1.626444003494268e-26,  9.481996362901887e-28, -4.796511843318701e-29,  2.147413054068300e-30, -8.637994058150467e-32,  3.159042157045621e-33,
 -1.059476478837779e-34,  4.832943154288368e-23, -1.620356780197745e-23,  2.859352283439606e-24, -3.437506489620846e-25,  3.146197636169407e-26, -2.332255157049374e-27,
  1.456535616607671e-28, -7.874901688541104e-30,  3.760067850193565e-31, -1.609768586845569e-32,  6.253623809981809e-34, -2.223541622986113e-35,  5.392248520013485e-24,
 -1.936063714706659e-24,  3.670184059240982e-25, -4.734260731682772e-26,  4.639986181828909e-27, -3.675291065705596e-28,  2.447311027576654e-29, -1.407868181749276e-30,
  7.138300506141649e-32, -3.239047378137278e-33,  1.331223139867309e-34, -4.998376863626421e-36,  7.093609132009983e-25, -2.705781014797653e-25,  5.469470280640613e-26,
 -7.517173647532636e-27,  7.836937864830574e-28, -6.590804552575125e-29,  4.650834405004362e-30, -2.830044199624530e-31,  1.515084925492853e-32, -7.246399706884107e-34,
  3.134019077267382e-35, -1.236207665280935e-36,  1.145065760605178e-25, -4.597256977031519e-26,  9.819689942374877e-27, -1.425500945899390e-27,  1.567654248043907e-28,
 -1.388545408870313e-29,  1.030325660399575e-30, -6.582177576301859e-32,  3.693813575420395e-33, -1.849156015343589e-34,  8.358764089372065e-36, -3.440934762597938e-37,
  2.329580366989882e-26, -9.741064563759094e-27,  2.175053308514085e-27, -3.300128953403526e-28,  3.789483365023978e-29, -3.500500514606272e-30,  2.705401239385833e-31,
 -1.797879269923218e-32,  1.048232012475445e-33, -5.445292512112804e-35,  2.551211522400099e-36, -1.087197493171885e-37,  5.872323531856097e-27, -2.527691564330644e-27,
  5.827286879483626e-28, -9.128481852000936e-29,  1.081513431358781e-29, -1.029902708845216e-30,  8.198167932092858e-32, -5.606172283260007e-33,  3.360406650112144e-34,
 -1.793089549338248e-35,  8.621906809884150e-37, -3.767504607819295e-38,  1.485712593880258e-27, -6.500977246801456e-28,  1.526311729528421e-28, -2.435067869291249e-29,
  2.937134689497223e-30, -2.846162424336484e-31,  2.304239381515043e-32, -1.601759269163603e-33,  9.754792243096251e-35, -5.285720277370273e-36,  2.579696318049194e-37,
 -1.143558284232688e-38,  5.745594265989550e-02, -1.357235944960000e-04,  3.305490773242240e-07, -8.268741888304123e-10,  2.112151802020278e-12, -5.487627518701151e-15,
  1.439336106503021e-17, -3.816901064279664e-20,  1.009381070472209e-22, -2.713314878144881e-25,  7.093008025623155e-28, -1.962665642723681e-30,  5.200054763985650e-02,
 -1.425465260032005e-04,  4.678002466637581e-07, -1.635458574561655e-09,  5.750082499248677e-12, -1.996538230352614e-14,  6.817951741223434e-17, -2.293508134657148e-19,
  7.604431192471490e-22, -2.494140552504494e-24,  8.078688454846221e-27, -2.600287957366571e-29,  4.259317681951131e-02, -1.491408156513572e-04,  6.784355122097680e-07,
 -3.067041750426645e-09,  1.328201473391816e-11, -5.542503373792007e-14,  2.245821633547943e-16, -8.884457274764598e-19,  3.443704897550024e-21, -1.311446800162777e-23,
  4.916106740233393e-26, -1.817287770482736e-28,  3.157214678695549e-02, -1.467305319919122e-04,  8.668085360163929e-07, -4.733418626434846e-09,  2.419270042678433e-11,
 -1.179064494064795e-13,  5.536442941926006e-16, -2.520604220764632e-18,  1.117699279205697e-20, -4.843325760524314e-23,  2.056609370885471e-25, -8.575141538885717e-28,
  2.117680677289901e-02, -1.309960039373200e-04,  9.522279448817614e-07, -6.110027517429203e-09,  3.625927919334950e-11, -2.033742586035545e-13,  1.090491253003521e-15,
 -5.632028257063190e-18,  2.817372046526466e-20, -1.370790762810825e-22,  6.508701988576108e-25, -3.023625527553107e-27,  1.285163283939775e-02, -1.044282536591576e-04,
  9.044302762407655e-07, -6.732275340239186e-09,  4.588882562087838e-11, -2.929472621271266e-13,  1.774448049652932e-15, -1.029020284586226e-17,  5.750778412612049e-20,
 -3.112500962157737e-22,  1.637763427006598e-24, -8.403588116383169e-27,  7.055659562334373e-03, -7.393340113618686e-05,  7.491419755383384e-07, -6.415884652397876e-09,
  4.979417297552916e-11, -3.587002668319914e-13,  2.434695681808460e-15, -1.573304685986998e-17,  9.751883137513045e-20, -5.830508251019963e-22,  3.377244042619950e-24,
 -1.901723833054473e-26,  3.503739114103625e-03, -4.645514784594655e-05,  5.448857457484683e-07, -5.333651507949660e-09,  4.679672615985171e-11, -3.778548957673974e-13,
  2.856031053993842e-15, -2.044429345070101e-17,  1.397575574014980e-19, -9.180856130022425e-22,  5.823687553809542e-24, -3.580751830473168e-26,  1.573514631676086e-03,
 -2.593628805404275e-05,  3.497670308856262e-07, -3.890716381496196e-09,  3.836700007660321e-11, -3.453875249746842e-13,  2.892726473522618e-15, -2.283026798468757e-17,
  1.713529695312182e-19, -1.231459300267960e-21,  8.519129401367779e-24, -5.696713924609131e-26,  6.389776087599103e-04, -1.288905439536763e-05,  1.988708921448159e-07,
 -2.501339119036746e-09,  2.759122622048546e-11, -2.757266554552417e-13,  2.548501723472444e-15, -2.209127461435259e-17,  1.813826463955297e-19, -1.421110311429611e-21,
  1.068571516464739e-23, -7.745963257063150e-26,  2.345921637285649e-04, -5.711577131392644e-06,  1.004332415107567e-07, -1.422122115964700e-09,  1.747837331437023e-11,
 -1.932046718879330e-13,  1.964182923136352e-15, -1.864161079897667e-17,  1.669369138016324e-19, -1.421814028966044e-21,  1.158833891283221e-23, -9.081928361345662e-26,
  7.785821620416115e-05, -2.260686993227767e-06,  4.514818515046211e-08, -7.170101625245516e-10,  9.786644585147409e-12, -1.193075139372039e-13,  1.330419004848239e-15,
 -1.378871038106139e-17,  1.343417083023723e-19, -1.240881697988276e-21,  1.093758697616727e-23, -9.247133424371287e-26,  2.335768590329792e-05, -8.004433080656460e-07,
  1.809848028415051e-08, -3.213270464849034e-10,  4.857392886943307e-12, -6.514358823292729e-14,  7.949616691689060e-16, -8.977882209452553e-18,  9.497005988920394e-20,
 -9.494722358301370e-22,  9.033714185881831e-24, -8.224107303470644e-26,  6.334211970447336e-06, -2.538760309516270e-07,  6.479888581107932e-09, -1.282569379728271e-10,
  2.142244392796362e-12, -3.153995950379185e-14,  4.203897559716222e-16, -5.164038969596401e-18,  5.920897037311713e-20, -6.396654007016090e-22,  6.559214986671433e-24,
 -6.420315840862275e-26,  1.552889174259806e-06, -7.222201051760363e-08,  2.075147698947797e-09, -4.567951628902683e-11,  8.413504991585483e-13, -1.357458141699521e-14,
  1.973038509841178e-16, -2.632288864121342e-18,  3.266669793048951e-20, -3.808540549374285e-22,  4.203536846471393e-24, -4.418382070899597e-26,  3.442564076247285e-07,
 -1.845090760369458e-08,  5.952562554323032e-10, -1.454198939368441e-11,  2.948549876946801e-13, -5.205614600374462e-15,  8.239855640352119e-17, -1.192459628440594e-18,
  1.599883048154406e-20, -2.010734794774127e-22,  2.386240825062855e-24, -2.690720925559704e-26,  6.904101564115533e-08, -4.238657935932642e-09,  1.531683483605427e-10,
 -4.145153814334230e-12,  9.238996206459341e-14, -1.782644688631249e-15,  3.069542657617228e-17, -4.813805637667736e-19,  6.975914908009819e-21, -9.442764727056748e-23,
  1.203920822078737e-24, -1.455149788834244e-26,  1.253465724313832e-08, -8.768331827563360e-10,  3.541072762876467e-11, -1.059892566467341e-12,  2.593637962471975e-14,
 -5.463611940970739e-16,  1.022496685863456e-17, -1.736276087891230e-19,  2.715680176760957e-21, -3.956468430741131e-23,  5.415777323991083e-25, -7.012161485957563e-27,
  2.062211154053978e-09, -1.636032123302138e-10,  7.368590343465175e-12, -2.435879392041734e-13,  6.537500058963324e-15, -1.502264017277791e-16,  3.053451461797987e-18,
 -5.610695510737656e-20,  9.466216294108916e-22, -1.483568752541575e-23,  2.179212245671201e-25, -3.021100138065648e-27,  3.078811813287444e-10, -2.758671437807073e-11,
  1.383048078948048e-12, -5.043310631623906e-14,  1.483184929883297e-15, -3.715321069335572e-17,  8.197108614863562e-19, -1.629100180502114e-20,  2.963631533939887e-22,
 -4.994489638468650e-24,  7.869855989606225e-26, -1.167773798785676e-27,  4.179320063237759e-11, -4.213879075444521e-12,  2.347482428014775e-13, -9.432215890586110e-15,
  3.037331372304339e-16, -8.289357946766553e-18,  1.984355037854609e-19, -4.263998072419892e-21,  8.361459139839473e-23, -1.514857754106047e-24,  2.559933243556396e-26,
 -4.064895192258539e-28,  5.171735896790208e-12, -5.848421707371921e-13,  3.614447898728123e-14, -1.598692854410667e-15,  5.633356445696147e-17, -1.674300651566836e-18,
  4.347388866120893e-20, -1.009793839022881e-21,  2.134049040072087e-23, -4.155747184432729e-25,  7.530571578802848e-27, -1.279446006785756e-28,  5.854414400336900e-13,
 -7.403067351658611e-14,  5.068163990551758e-15, -2.465505689364198e-16,  9.501573616356448e-18, -3.074304051585459e-19,  8.656414688714692e-21, -2.173109665934932e-22,
  4.948958905441614e-24, -1.035811431529367e-25,  2.012596047249260e-27, -3.658485427482839e-29,  6.090149825590189e-14, -8.587856454964321e-15,  6.503579585233982e-16,
 -3.476881140056046e-17,  1.464725672049145e-18, -5.157811147031235e-20,  1.574626225619258e-21, -4.271869000396890e-23,  1.048308063064313e-24, -2.358136231491156e-26,
  4.912924096074809e-28, -9.555091691755887e-30,  5.856651451766809e-15, -9.185603810129927e-16,  7.684602649946717e-17, -4.511325567225719e-18,  2.076575763164548e-19,
 -7.956053034200309e-21,  2.633087400058478e-22, -7.719164737109932e-24,  2.041120196646689e-25, -4.934721335718912e-27,  1.102393906731312e-28, -2.293981391640026e-30,
  5.246652939903827e-16, -9.129568228787029e-17,  8.426173258536403e-18, -5.427697638958470e-19,  2.728525013618428e-20, -1.137083858821567e-21,  4.078888966077907e-23,
 -1.292025900608449e-24,  3.681099881923714e-26, -9.564874646331100e-28,  2.291167267767759e-29, -5.101154317947043e-31,  4.421912305302763e-17, -8.515122342143788e-18,
  8.658316136618303e-19, -6.114296276112091e-20,  3.354943606903904e-21, -1.520214432128036e-22,  5.909213106269151e-24, -2.022141054588380e-25,  6.206919907363899e-27,
 -1.733201591940658e-28,  4.451443673170180e-30, -1.060332414020835e-31,  3.550583926038655e-18, -7.546504003289711e-19,  8.440853886632667e-20, -6.528102354958099e-21,
  3.907000101390213e-22, -1.923946224957469e-23,  8.100704032585362e-25, -2.993800728477955e-26,  9.897726280266816e-28, -2.969504804309931e-29,  8.175664361956755e-31,
 -2.083086271200267e-32,  2.759821862191418e-19, -6.455643643158487e-20,  7.928791414306622e-21, -6.707260958977110e-22,  4.374225540033046e-23, -2.339094079563590e-24,
  1.066122218894386e-25, -4.252935411599624e-27,  1.513696363768565e-28, -4.877191729693150e-30,  1.438843523477674e-31, -3.919769694158769e-33,  2.118673073826013e-20,
 -5.436420844234609e-21,  7.315935029083723e-22, -6.758162924826662e-23,  4.796232850939272e-24, -2.781943304760648e-25,  1.371205466122322e-26, -5.898944244447221e-28,
  2.258395962002123e-29, -7.808595331216353e-31,  2.466577689050069e-32, -7.179317895980773e-34,  1.646929773429589e-21, -4.617954314985553e-22,  6.790731946649244e-23,
 -6.834992239305340e-24,  5.268698610894353e-25, -3.309206054991640e-26,  1.761206395434599e-27, -8.159387946034395e-29,  3.355679534669827e-30, -1.243491159915278e-31,
  4.200584185963767e-33, -1.304717471207721e-34,  1.336487705947128e-22, -4.076359566534676e-23,  6.527341294871334e-24, -7.137217247331776e-25,  5.959870641722960e-26,
 -4.043688564827183e-27,  2.318557646853395e-28, -1.154299532925889e-29,  5.089320175548915e-31, -2.017282705859542e-32,  7.273796428045211e-34, -2.406501228658596e-35,
  1.174327076715043e-23, -3.874534493835527e-24,  6.725480128645818e-25, -7.957019288283187e-26,  7.171496175313015e-27, -5.238262644282765e-28,  3.225379609387986e-29,
 -1.720287501902416e-30,  8.107393598835950e-32, -3.427666306465903e-33,  1.315598433903301e-34, -4.623787825818459e-36,  1.165413525587963e-24, -4.131580588083559e-25,
  7.729252505648972e-26, -9.842153460121869e-27,  9.526705228082703e-28, -7.456178005540751e-29,  4.908159208288992e-30, -2.792507482529217e-31,  1.400935492504160e-32,
 -6.292303917374335e-34,  2.560830652245607e-35, -9.524991544850107e-37,  1.367975698203165e-25, -5.169142118288736e-26,  1.034538540337911e-26, -1.408029167399729e-27,
  1.454116942126243e-28, -1.211826252444154e-29,  8.476852100881343e-31, -5.115013512074579e-32,  2.716327217781983e-33, -1.289121605433732e-34,  5.533857784114034e-36,
 -2.167212477139241e-37,  1.987365442485298e-26, -7.928409450543795e-27,  1.681975384817194e-27, -2.425294052634469e-28,  2.649789901084584e-29, -2.332312825607689e-30,
  1.720162879634368e-31, -1.092530451303550e-32,  6.096839333123407e-34, -3.035721548063069e-35,  1.365141257789451e-36, -5.591764334082437e-38,  3.694227478738580e-27,
 -1.538959286009482e-27,  3.422318740937469e-28, -5.171625365325737e-29,  5.915216038880186e-30, -5.443434274506726e-31,  4.191662920998504e-32, -2.775785328018126e-33,
  1.612911519033103e-34, -8.351356505602730e-36,  3.900475578716877e-37, -1.657175842483979e-38,  8.697519385002478e-28, -3.737150229395889e-28,  8.598744423767860e-29,
 -1.344381122090214e-29,  1.589759416038728e-30, -1.511112303487323e-31,  1.200729326228231e-32, -8.196891197282112e-34,  4.905180859214438e-35, -2.613188875693537e-36,
  1.254590500699471e-37, -5.474032253814657e-39,  2.113621356310287e-28, -9.242842457038850e-29,  2.168568728725174e-29, -3.457340294970771e-30,  4.167355812150313e-31,
 -4.035604797884206e-32,  3.265096415945978e-33, -2.268258404382733e-34,  1.380535316929959e-35, -7.476099601430127e-37,  3.646597932625243e-38, -1.615598630756698e-39,
  5.691827502493086e-02, -1.331183255542109e-04,  3.208257916173547e-07, -7.939393683743009e-10,  2.005768939716731e-12, -5.154655482428130e-15,  1.336841867408662e-17,
 -3.508996730577156e-20,  9.166065751602369e-23, -2.446212671564871e-25,  6.277621694527546e-28, -1.749533575358961e-30,  5.143772421367433e-02, -1.388810917994366e-04,
  4.487138566778500e-07, -1.546564944640934e-09,  5.366631636756111e-12, -1.840346678609905e-14,  6.208530688768769e-17, -2.063930612102745e-19,  6.762052480624266e-22,
 -2.192756636005873e-24,  7.017097762690970e-27, -2.235037729297479e-29,  4.200724042149670e-02, -1.438570192341837e-04,  6.428704301490276e-07, -2.863112904367215e-09,
  1.222546133642478e-11, -5.032155019291730e-14,  2.011801051954064e-16, -7.854366782215745e-19,  3.005135096081706e-21, -1.129900555229012e-23,  4.182340044909655e-26,
 -1.526940141059378e-28,  3.099874291522760e-02, -1.400168620269131e-04,  8.122544682175555e-07, -4.364501788462838e-09,  2.196193157888360e-11, -1.054270494519194e-13,
  4.878234542818020e-16, -2.189321237409789e-18,  9.572812000558363e-21, -4.091426768928386e-23,  1.713973688436476e-25, -7.051626680833258e-28,  2.066760756949950e-02,
 -1.236618993243388e-04,  8.822587424874808e-07, -5.561048771839341e-09,  3.244124627697066e-11, -1.789973402406946e-13,  9.447087885730555e-16, -4.804651065951110e-18,
  2.367712833099373e-20, -1.135213895891716e-22,  5.313086076988447e-25, -2.433465003456321e-27,  1.244789610885930e-02, -9.750390962331743e-05,  8.278621905498064e-07,
 -6.042706161785614e-09,  4.043344209129119e-11, -2.536199876041012e-13,  1.510487493834887e-15, -8.617279400174852e-18,  4.739800966749543e-20, -2.525756820081544e-22,
  1.308956492756524e-24, -6.616868793677260e-27,  6.771443049397833e-03, -6.823520909648564e-05,  6.767047477936977e-07, -5.673538758273132e-09,  4.317055545187194e-11,
 -3.052197475320600e-13,  2.034880155067369e-15, -1.292376173392303e-17,  7.877165651696610e-20, -4.633195806166860e-22,  2.641149466183211e-24, -1.464119268230831e-26,
  3.326248579202646e-03, -4.233989951663568e-05,  4.851365822757722e-07, -4.641822321733119e-09,  3.988119585336507e-11, -3.157030746572157e-13,  2.341537080490950e-15,
 -1.645881988799741e-17,  1.105457427416202e-19, -7.138421351780837e-22,  4.453005765193741e-24, -2.693561221759264e-26,  1.475084127887854e-03, -2.331497188663725e-05,
  3.065453612994283e-07, -3.328540967999133e-09,  3.210476148784272e-11, -2.830521751088474e-13,  2.324022400641309e-15, -1.799513318891621e-17,  1.325946380505984e-19,
 -9.360102125881877e-22,  6.363353213247420e-24, -4.183358019913927e-26,  5.904232921335585e-04, -1.141104523421567e-05,  1.713318182148117e-07, -2.100871604730178e-09,
  2.264142982796293e-11, -2.213738821643094e-13,  2.004066082429942e-15, -1.702932962683486e-17,  1.371601279454266e-19, -1.054809692280002e-21,  7.789111277551289e-24,
 -5.547469766296138e-26,  2.132510502371532e-04, -4.971896812856142e-06,  8.492602155938997e-08, -1.170986779548273e-09,  1.404633467921799e-11, -1.517684991748378e-13,
  1.509905949340488e-15, -1.403640406269450e-17,  1.232140901944817e-19, -1.029359572125618e-21,  8.233884258269892e-24, -6.336292880434156e-26,  6.948687884437219e-05,
 -1.931426726573207e-06,  3.741011908141655e-08, -5.779012142625699e-10,  7.690867884520871e-12, -9.156312864977273e-14,  9.983634022509691e-16, -1.012744971010241e-17,
  9.665375879998312e-20, -8.751275968670211e-22,  7.565836879693342e-24, -6.277228587907549e-26,  2.042281018591697e-05, -6.698506370689160e-07,  1.466900909791153e-08,
 -2.530747767744632e-10,  3.726599409866424e-12, -4.876691939118064e-14,  5.814480324529963e-16, -6.422509023475315e-18,  6.650609305886873e-20, -6.513619659152769e-22,
  6.075062865562113e-24, -5.424557933763017e-26,  5.413402158794188e-06, -2.076551733711590e-07,  5.127294525043799e-09, -9.852479846747990e-11,  1.601649086796594e-12,
 -2.299121823420636e-14,  2.991917659126528e-16, -3.592216805229005e-18,  4.029348064763507e-20, -4.262009936486787e-22,  4.281769854348323e-24, -4.108656037051081e-26,
  1.294029690847362e-06, -5.760367648972238e-08,  1.599573651472200e-09, -3.415564288857671e-11,  6.118024203743303e-13, -9.617211460007085e-15,  1.363843140706211e-16,
 -1.777332430227377e-18,  2.156574335709563e-20, -2.460362738024412e-22,  2.659181012903233e-24, -2.738831521607245e-26,  2.789752937083634e-07, -1.431393936029365e-08,
  4.459421199801603e-10, -1.056015122205757e-11,  2.080866804538186e-13, -3.576946926287701e-15,  5.520799165123157e-17, -7.799854349050244e-19,  1.022648563455386e-20,
 -1.257075385022331e-22,  1.460207942593132e-24, -1.612698106677768e-26,  5.425425298796292e-08, -3.189619069932259e-09,  1.112375401056056e-10, -2.916276846340176e-12,
  6.313035380217882e-14, -1.185310746292586e-15,  1.989058864576772e-17, -3.043709324406349e-19,  4.308303349513139e-21, -5.701403562557400e-23,  7.112081876718186e-25,
 -8.416380875207779e-27,  9.522308886271530e-09, -6.381188959247923e-10,  2.486037601223763e-11, -7.204866873532252e-13,  1.711502610550254e-14, -3.506612665392255e-16,
  6.392535501008285e-18, -1.058716873618717e-19,  1.616783503999230e-21, -2.301931711021450e-23,  3.081821159423464e-25, -3.905481308800069e-27,  1.509422040145939e-09,
 -1.147734079422754e-10,  4.985559536236298e-12, -1.595207933024915e-13,  4.154346101808588e-15, -9.281173485646755e-17,  1.836891040382298e-18, -3.290792053609391e-20,
  5.419060178793775e-22, -8.297143814583797e-24,  1.191665705090796e-25, -1.616509878292192e-27,  2.163331593448778e-10, -1.858991930127900e-11,  8.987962998480340e-13,
 -3.171550086654154e-14,  9.048085391752403e-16, -2.202894753969144e-17,  4.731144023040818e-19, -9.164791826019503e-21,  1.626852520381819e-22, -2.677823855892102e-24,
  4.124711827875952e-26, -5.987626870621210e-28,  2.807872532956034e-11, -2.717124249131008e-12,  1.459881478925245e-13, -5.675758944114845e-15,  1.772717050003233e-16,
 -4.701363302518331e-18,  1.095336050910548e-19, -2.293682927895308e-21,  4.388046302123736e-23, -7.763496318829946e-25,  1.282289506263341e-26, -1.991678995981656e-28,
  3.307866828173852e-12, -3.593201389197923e-13,  2.142350861477385e-14, -9.169374818506118e-16,  3.133799854356016e-17, -9.050398151808986e-19,  2.286941329616646e-20,
 -5.176225074922561e-22,  1.067147913159706e-23, -2.029252747487203e-25,  3.593865634034665e-27, -5.972401254245166e-29,  3.547852926168022e-13, -4.313841948736440e-14,
  2.850404856092988e-15, -1.342123627705947e-16,  5.017306409389030e-18, -1.577567422313061e-19,  4.323099722185791e-21, -1.057574556012303e-22,  2.349630419501141e-24,
 -4.802313276060489e-26,  9.119956594131196e-28, -1.621637806550167e-29,  3.478709788216445e-14, -4.722322149749887e-15,  3.453890158604351e-16, -1.787972845681342e-17,
  7.308852490760852e-19, -2.501662756469887e-20,  7.434377199999909e-22, -1.965782025179674e-23,  4.706909280340314e-25, -1.034119667848573e-26,  2.106099931417152e-28,
 -4.007397596433366e-30,  3.135303960098969e-15, -4.740327780887670e-16,  3.833359202657502e-17, -2.180464012293916e-18,  9.743830476803398e-20, -3.630206771190656e-21,
  1.169937630606806e-22, -3.343985570423679e-24,  8.630378075414461e-26, -2.038502534968715e-27,  4.452990683622782e-29, -9.068221606897886e-31,  2.616206109491083e-16,
 -4.395304781095130e-17,  3.925515261461276e-18, -2.452087875847600e-19,  1.197545797363346e-20, -4.855971456022771e-22,  1.697191745611352e-23, -5.244217497503377e-25,
  1.459034639238759e-26, -3.705589788742242e-28,  8.683560512745733e-30, -1.892866297177231e-31,  2.040182088812202e-17, -3.799938163484512e-18,  3.743892789244716e-19,
 -2.566630913816918e-20,  1.369474839113051e-21, -6.043069753914511e-23,  2.290454270294527e-24, -7.651304274745824e-26,  2.294953357668827e-27, -6.267865615551178e-29,
  1.575824651644188e-30, -3.677277897333543e-32,  1.505042563049335e-18, -3.100331613649243e-19,  3.365474161375112e-20, -2.530244932157704e-21,  1.474318950128983e-22,
 -7.077785485551626e-24,  2.908731927782360e-25, -1.050379963176403e-26,  3.396429098788716e-28, -9.975107776502059e-30,  2.690627327928364e-31, -6.721493768504237e-33,
  1.066844285329122e-19, -2.424246885260262e-20,  2.895084470973865e-21, -2.384681792182633e-22,  1.516362282083756e-23, -7.915857148116048e-25,  3.526029274610239e-26,
 -1.376040498045540e-27,  4.795573373502062e-29, -1.514234944679521e-30,  4.381189831886099e-32, -1.171417006552732e-33,  7.412884965794765e-21, -1.852596256344572e-21,
  2.429453711494464e-22, -2.189524403242525e-23,  1.517805057604956e-24, -8.608640649508113e-26,  4.153319543761865e-27, -1.750541871167226e-28,  6.571579240961800e-30,
 -2.229724746518869e-31,  6.916617902907123e-33, -1.978345839194182e-34,  5.177749830238826e-22, -1.418111246945372e-22,  2.037239672145329e-23, -2.005117694270471e-24,
  1.512930793761228e-25, -9.310437939756154e-27,  4.859309845174131e-28, -2.209521715887777e-29,  8.925427390352102e-31, -3.250921530456635e-32,  1.080126479569781e-33,
 -3.301864305708221e-35,  3.751150363734482e-23, -1.121065952448980e-23,  1.758697991668349e-24, -1.885371045163317e-25,  1.544828753904593e-26, -1.029323050952080e-27,
  5.800394627770842e-29, -2.840122894590004e-30,  1.232394092683748e-31, -4.810614803425892e-33,  1.709204296633849e-34, -5.575282967131631e-36,  2.928361720305597e-24,
 -9.498841783950898e-25,  1.620413207930819e-25, -1.885098788835032e-26,  1.671720765572104e-27, -1.202272815549965e-28,  7.293537584881080e-30, -3.834992652736990e-31,
  1.782787467820841e-32, -7.438840710623836e-34,  2.819278788254964e-35, -9.788964706887627e-37,  2.576678840708143e-25, -9.011972538371514e-26,  1.662414907504704e-26,
 -2.088067616200069e-27,  1.994658359821562e-28, -1.541493325083594e-29,  1.002458495803253e-30, -5.637380498755767e-32,  2.796650145147104e-33, -1.242674425132701e-34,
  5.005371124040268e-36, -1.843345433010458e-37,  2.687419855880335e-26, -1.005303698385909e-26,  1.990703582623658e-27, -2.681300922312179e-28,  2.741333352034331e-29,
 -2.262552442917818e-30,  1.568031214822824e-31, -9.377541674979134e-33,  4.937413812176715e-34, -2.323978393643308e-35,  9.897489347939589e-37, -3.846766300770445e-38,
  3.496577811764263e-27, -1.385413906771892e-27,  2.917620901540222e-28, -4.176738924816881e-29,  4.531553116083675e-30, -3.961835015952387e-31,  2.903123294887208e-32,
 -1.832421619346931e-33,  1.016478009376705e-34, -5.032193173506947e-36,  2.250459006661832e-37, -9.169328959100569e-39,  5.908928756460886e-28, -2.451640901390963e-28,
  5.428031634981925e-29, -8.166961426508222e-30,  9.301865843186766e-31, -8.525153696703319e-32,  6.538992674550600e-33, -4.313900769277488e-34,  2.497566410674008e-35,
 -1.288681883877792e-36,  5.998543778260891e-38, -2.540357919385833e-39,  1.293727041885293e-28, -5.548275742929438e-29,  1.273910981057415e-29, -1.987546480299974e-30,
  2.345524684071308e-31, -2.225087925429861e-32,  1.764683474269103e-33, -1.202462192234205e-34,  7.183008853628093e-36, -3.820136348483393e-37,  1.831020604921726e-38,
 -7.976439319292647e-40,  3.011470441387533e-29, -1.316056423483366e-29,  3.085507191250192e-30, -4.915618350402993e-31,  5.920854405524545e-32, -5.729641222350523e-33,
  4.632524517084485e-34, -3.216068089317486e-35,  1.956136754138574e-36, -1.058652846997903e-37,  5.160606625515609e-39, -2.285013741384239e-40,  5.639087535601392e-02,
 -1.305892904652561e-04,  3.114877265120285e-07, -7.626547059940204e-10,  1.905806345547904e-12, -4.845280185807869e-15,  1.242567337020121e-17, -3.229302902294771e-20,
  8.328823392438942e-23, -2.209953461927018e-25,  5.548355520534423e-28, -1.570783193439948e-30,  5.088926375380453e-02, -1.353641837964136e-04,  4.306583846747468e-07,
 -1.463564355684635e-09,  5.013007009530530e-12, -1.698039338082595e-14,  5.659774928975765e-17, -1.859652151140141e-19,  6.020900271105065e-22, -1.930791726030680e-24,
  6.103714280399812e-27, -1.925063538052427e-29,  4.144188527069704e-02, -1.388482347076213e-04,  6.096543371761234e-07, -2.675301918715784e-09,  1.126558679348639e-11,
 -4.574663244714512e-14,  1.804752565798090e-16, -6.954703963834320e-19,  2.626932765542696e-21, -9.753016182660465e-24,  3.565165104968023e-26, -1.285726487468878e-28,
  3.045134806366425e-02, -1.337225049389102e-04,  7.619212154146391e-07, -4.029363325874592e-09,  1.996567612729654e-11, -9.442159832126810e-14,  4.305987450968715e-16,
 -1.905293043451119e-18,  8.216179090626538e-21, -3.464061215534181e-23,  1.431864965297765e-25, -5.813546071477290e-28,  2.018666558091548e-02, -1.168621999998789e-04,
  8.185262477000951e-07, -5.069440752485273e-09,  2.907755960459326e-11, -1.578567101274509e-13,  8.201996085463043e-16, -4.108470123821581e-18,  1.994843867032291e-20,
 -9.426460769968600e-23,  4.349441651883863e-25, -1.964357346488525e-27,  1.207068205357164e-02, -9.116043719909374e-05,  7.590701011988672e-07, -5.434459667783303e-09,
  3.570486674125808e-11, -2.201003564297186e-13,  1.289139916864949e-15, -7.236464521715119e-18,  3.918156814159879e-20, -2.056061169319436e-22,  1.049625944539910e-24,
 -5.228108097141948e-27,  6.508914286859339e-03, -6.308260586864184e-05,  6.125734820648269e-07, -5.029109647025383e-09,  3.752662988905521e-11, -2.604548823372530e-13,
  1.705935429288436e-15, -1.065074734912684e-17,  6.384815889240288e-20, -3.695130866278959e-22,  2.073356824373553e-24, -1.131692352596166e-26,  3.164313093740264e-03,
 -3.867122742549385e-05,  4.330644243856377e-07, -4.051332104441965e-09,  3.409374406995150e-11, -2.646591860054782e-13,  1.926583599215199e-15, -1.330034281117879e-17,
  8.778716706786805e-20, -5.573452244731232e-22,  3.419710640251961e-24, -2.035331159193328e-26,  1.386487781805448e-03, -2.101405783459160e-05,  2.695074808605983e-07,
 -2.857285676768568e-09,  2.696302232577713e-11, -2.328720043006931e-13,  1.874825824521254e-15, -1.424550834977977e-17,  1.030684606289636e-19, -7.148077169578372e-22,
  4.776438723864573e-24, -3.087657175341913e-26,  5.473690251693618e-04, -1.013539433659678e-05,  1.481568722081242e-07, -1.771568871727081e-09,  1.865872734602920e-11,
 -1.785352297709177e-13,  1.583386528857541e-15, -1.319211352558117e-17,  1.042527781777268e-19, -7.871027622388764e-22,  5.709039191184850e-24, -3.995597620528110e-26,
  1.946383893257351e-04, -4.345093931281067e-06,  7.212849223475209e-08, -9.686854951599397e-10,  1.134367274591134e-11, -1.198335420413144e-13,  1.166939112811524e-15,
 -1.062797826713343e-17,  9.146986196392686e-20, -7.496941949743779e-22,  5.886544272641123e-24, -4.448775182893289e-26,  6.231859325170698e-05, -1.657924288323846e-06,
  3.115716417666426e-08, -4.682860415448317e-10,  6.077933403985972e-12, -7.068287846499370e-14,  7.537466014557912e-16, -7.485200633109770e-18,  6.999052814714622e-20,
 -6.213074844164407e-22,  5.269439960455475e-24, -4.291164695326932e-26,  1.796021724037399e-05, -5.637020051183309e-07,  1.195997796873793e-08, -2.005507626385165e-10,
  2.877398975893930e-12, -3.674974248552209e-14,  4.281964853855737e-16, -4.626901455241355e-18,  4.691088898729696e-20, -4.501723255759933e-22,  4.116485399783011e-24,
 -3.605811298262051e-26,  4.657902249806207e-06, -1.709629305780015e-07,  4.084757333219377e-09, -7.621860912032068e-11,  1.206180480161341e-12, -1.688497682388532e-14,
  2.145712310532999e-16, -2.518502048803453e-18,  2.764185238480839e-20, -2.863094681294236e-22,  2.818548435977776e-24, -2.651805498326490e-26,  1.086829353137840e-06,
 -4.629368924080158e-08,  1.242624627315543e-09, -2.574332811605148e-11,  4.485302242473321e-13, -6.870694503317713e-15,  9.508266314388117e-17, -1.210563585353540e-18,
  1.436414246130551e-20, -1.603853258259388e-22,  1.697741264587618e-24, -1.713643319174982e-26,  2.281253230191061e-07, -1.120169365709175e-08,  3.370502434223033e-10,
 -7.737894639262129e-12,  1.482033854830212e-13, -2.480861657278695e-15,  3.734252114103686e-17, -5.151288411237389e-19,  6.601088380080283e-21, -7.937437371486213e-23,
  9.025811287409484e-25, -9.764823617638385e-27,  4.307600299703432e-08, -2.424175067046804e-09,  8.159715271752303e-11, -2.072543401263061e-12,  4.358069373090242e-14,
 -7.963432024767895e-16,  1.302507534649982e-17, -1.945060298448649e-19,  2.689560273992896e-21, -3.480059559769742e-23,  4.247837133762142e-25, -4.922241037059765e-27,
  7.318774366573622e-09, -4.696474177008048e-10,  1.765062333873174e-11, -4.953279555281626e-13,  1.142314240503044e-14, -2.276553097549412e-16,  4.043061503149155e-18,
 -6.531466358129775e-20,  9.739524900407979e-22, -1.355286672369232e-23,  1.774792747574505e-25, -2.201549053759359e-27,  1.119400918812728e-09, -8.154288282702713e-11,
  3.415852280890398e-12, -1.057870934580180e-13,  2.673395602503756e-15, -5.807013037386193e-17,  1.119170960713454e-18, -1.954940824983302e-20,  3.142316040203425e-22,
 -4.700631262750546e-24,  6.601508921796262e-26, -8.762968818829270e-28,  1.542517131476752e-10, -1.270565462364667e-11,  5.923160405946158e-13, -2.022395813520837e-14,
  5.596912636875779e-16, -1.324415109891261e-17,  2.768936037903166e-19, -5.228173482810817e-21,  9.056020940933706e-23, -1.455966008765637e-24,  2.192358843300488e-26,
 -3.113537004401984e-28,  1.917438115015993e-11, -1.779753560864940e-12,  9.220344565126479e-14, -3.468078207306741e-15,  1.050525269651793e-16, -2.707230680189240e-18,
  6.138475659613317e-20, -1.252639925505825e-21,  2.337926827138982e-23, -4.039327441459464e-25,  6.520878328023301e-27, -9.907139190598512e-29,  2.154112521687165e-12,
 -2.246249627591624e-13,  1.291601690402198e-14, -5.348253103579312e-16,  1.772591936754639e-17, -4.973792215713970e-19,  1.223008875216564e-20, -2.697183386968535e-22,
  5.424188982631407e-24, -1.007138004343664e-25,  1.743167705789873e-27, -2.833335253799451e-29,  2.192891590549578e-13, -2.562027355979922e-14,  1.633236117625782e-15,
 -7.441140510869944e-17,  2.697805311438935e-18, -8.241706491374400e-20,  2.197738632309678e-21, -5.238509687877572e-23,  1.135278187047550e-24, -2.265640653904272e-26,
  4.204906378326134e-28, -7.312945695066224e-30,  2.030263383210122e-14, -2.651181540103710e-15,  1.871803613413491e-16, -9.379198863574479e-18,  3.719174882446531e-19,
 -1.237053315102483e-20,  3.577784916616758e-22, -9.218742684663807e-24,  2.153403525321294e-25, -4.620028989877276e-27,  9.196516688512226e-29, -1.711716930056058e-30,
  1.718016270324406e-15, -2.501877715185851e-16,  1.954520068116907e-17, -1.076705949980098e-18,  4.669285087507234e-20, -1.691072325853872e-21,  5.305569479323602e-23,
 -1.478145098116595e-24,  3.722591898923874e-26, -8.588493760605819e-28,  1.834138559219248e-29, -3.654535235744211e-31,  1.337611584318608e-16, -2.167736006294485e-17,
  1.872190318788151e-18, -1.133460946799859e-19,  5.375329482785422e-21, -2.119980823183849e-22,  7.216617076217863e-24, -2.174498792862728e-25,  5.905933532076695e-27,
 -1.465698956035745e-28,  3.359151068175962e-30, -7.167187910430323e-32,  9.667093313394750e-18, -1.739850706793489e-18,  1.659722258726447e-19, -1.103895285129540e-20,
  5.724426048331849e-22, -2.458708654432615e-23,  9.082756188855779e-25, -2.960644412075574e-26,  8.674276554318460e-28, -2.316310845752871e-29,  5.698684259306832e-31,
 -1.302358148155077e-32,  6.561078091275400e-19, -1.308589854032324e-19,  1.377454872767587e-20, -1.006001521790777e-21,  5.703286763151062e-23, -2.667717621486389e-24,
  1.069537120406107e-25, -3.771995747760134e-27,  1.192379702145655e-28, -3.426660892732635e-30,  9.051669245812528e-32, -2.216163021148832e-33,  4.245863872740663e-20,
 -9.362537189822026e-21,  1.086182825813103e-21, -8.704809064028587e-23,  5.393117399834879e-24, -2.746642942529324e-25,  1.194977190063274e-26, -4.559603979681317e-28,
  1.555139797260701e-29, -4.809834518821527e-31,  1.364209935014884e-32, -3.578324137784433e-34,  2.671881024463731e-21, -6.496444958044713e-22,  8.293902872550980e-23,
 -7.286367516732615e-24,  4.929859437352766e-25, -2.732206699911707e-26,  1.289415916968735e-27, -5.321162259517065e-29,  1.957591368478000e-30, -6.514375850568673e-32,
  1.983392092008004e-33, -5.572116191500342e-35,  1.676840776051932e-22, -4.480990070126486e-23,  6.282619838203056e-24, -6.041220613288600e-25,  4.458200030901706e-26,
 -2.686020845626419e-27,  1.373796268339829e-28, -6.126773805353394e-30,  2.429385552004980e-31, -8.692198676759918e-33,  2.838913973328907e-34, -8.536492801764961e-36,
  1.083574900351260e-23, -3.169680824560950e-24,  4.866776451616082e-25, -5.110503432134267e-26,  4.105400984294198e-27, -2.684201108256270e-28,  1.485476037033091e-29,
 -7.148618328533407e-31,  3.050846067246522e-32, -1.172045625258169e-33,  4.100902543499073e-35, -1.318120145479244e-36,  7.500970021911560e-25, -2.389684690700050e-25,
  4.002521107812526e-26, -4.574437739376838e-27,  3.988204965007792e-28, -2.821895256590685e-29,  1.685388433937947e-30, -8.730367553104391e-32,  4.000722768249448e-33,
 -1.646505068995712e-34,  6.158109704118408e-36, -2.111184372431368e-37,  5.833914229236222e-26, -2.011205061811887e-26,  3.655096727506970e-27, -4.524831136337929e-28,
  4.262500862596487e-29, -3.250298574535219e-30,  2.086767321919679e-31, -1.159150560380819e-32,  5.682924034897768e-34, -2.496699574013428e-35,  9.947472811875914e-37,
 -3.625277639650185e-38,  5.383791107607823e-27, -1.992306162250055e-27,  3.900598435964785e-28, -5.195692499891141e-29,  5.255373139626093e-30, -4.293057868089715e-31,
  2.945978485586414e-32, -1.745196331248633e-33,  9.105434268645081e-35, -4.248503709496507e-36,  1.794239440300431e-37, -6.917531532188463e-39,  6.241878466893899e-28,
 -2.454986136528415e-28,  5.129525152201929e-29, -7.286534374179767e-30,  7.846501773150175e-31, -6.810719122685818e-32,  4.956242884838884e-33, -3.107582015630257e-34,
  1.712852722912233e-35, -8.427788765004301e-37,  3.746846415380260e-38, -1.518013855967655e-39,  9.539107040446743e-29, -3.940557114848053e-29,  8.683300260778974e-30,
 -1.300373707926579e-30,  1.474360850338134e-31, -1.345341173342530e-32,  1.027565750317081e-33, -6.751624131824710e-35,  3.893703471758119e-36, -2.001542614389762e-37,
  9.283267611468011e-39, -3.917865480754809e-40,  1.933275048400085e-29, -8.273937159210096e-30,  1.895429674060621e-30, -2.950570975438014e-31,  3.474358141637491e-32,
 -3.288961004903912e-33,  2.603081802627694e-34, -1.770248031015963e-35,  1.055460917737704e-36, -5.602965171095211e-38,  2.680801177247244e-39, -1.165849709043992e-40,
  4.297647955048975e-30, -1.876833306592087e-30,  4.396851634425195e-31, -6.999321242473651e-32,  8.424233993239982e-33, -8.146099483595328e-34,  6.581500676878745e-35,
 -4.565897758649284e-36,  2.775253269147995e-37, -1.500955950632858e-38,  7.311969033954852e-40, -3.235566755666978e-41,  };
  int offset = -39;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 39;
    if (std::isnan(t)) {
      fill_n(rr+offset, 39, 0.5);
      fill_n(ww+offset, 39, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 39; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=39; ++j) {
        const int boxof = it*468+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
