/*************************************************************************
 * var.c Operations with dyn. vars in script language [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/


#include "avinfo.h"

var_t 		FAKE_VAR	=	{ t_UNKNOWN, "", 0 };
var_item_t	*Var_root	=	NULL;

int SetVar( char* var_name, const var_t value ){

	var_item_t *current = Var_root;
	var_item_t *prev=NULL;
	while( current ){
		if( !STRCMP( current->name, var_name ) ){
			FREE(current->content.string);
			current->content.type = value.type;
			current->content.number = value.number;
			if(value.type==t_STRING)
				current->content.string = value.string;
			else
				current->content.string = dup("");
			return 0; /*ok*/
		}
		prev=current;
		current = current->Next;
	}
	/*not found - create new*/
	current = (var_item_t*)malloc( sizeof( var_item_t ) );
	if( current == NULL ) return -1; /*no memory.*/
	current->Next           =  NULL;
	current->content.type	=  value.type;
	current->content.number =  value.number;
	if(value.type==t_STRING)
		current->content.string = dup(value.string);
	else
		current->content.string = dup("");
	current->name			=  dup( var_name );
	if(prev) prev->Next =  current;
		else Var_root=current;
	return 0; /*ok*/

}


#define FreeVar(a) {free(a.string);}

var_t GetROVar(const char* var_name);

var_t GetVar( char* var_name ){

	var_item_t *current	=	Var_root;
	var_t ret_val={0,NULL,0};

	while( current ){
		if( !STRCMP( current->name, var_name ) ) {
			ret_val.type=current->content.type;
			ret_val.number=current->content.number;
			ret_val.string=dup(current->content.string);
		}
		current = current->Next;
	}
	if(!ret_val.string) ret_val.string=dup("");
	return ret_val;
}

var_t GetROVar(const char* var_name){
	var_item_t *current	=	Var_root;

	while( current ){
		if( !STRCMP( current->name, var_name ) ) {
			return current->content;
		}
		current = current->Next;
	}
	return FAKE_VAR;/*not found.*/

}

int DelVar(const char* name){
	var_item_t *current = Var_root;
	var_item_t *prev=NULL;
	while(current){
		if(!STRCMP(current->name,name)){
			FREE(current->content.string);
			FREE(current->name);
			if(prev) prev->Next=current->Next;
				else Var_root=current->Next;
			FREE(current);
			current=prev->Next;
		}
		else {
			prev=current;
			current=current->Next;
		}
	}
	return 0;
}

int SetNumericVar( char* var_name, int value ){

	var_t var;

	var.type	=	t_NUMBER;
	var.number	=	value;

	return SetVar( var_name, var );

}

int SetStringVar( char* var_name, char* value ){

	var_t var;

	var.type	=	t_STRING;
	var.string	=	value;
	var.number	=	strlen(value); /*easy way to check: #if stringvar { foobar }*/
	return SetVar( var_name, var );

}



int SetIdxVar( char* name,  int class_number, var_t value ){

	char* temp	=	malloc( strlen( name ) + 10 );
	int q;
	sprintf( temp, name, class_number );
	q=SetVar( temp, value );
	FREE(temp);
	return q;
}

int SetIdxNumericVar( char* name, int class_number, int value ){

	var_t var;

	var.type	=	t_NUMBER;
	var.number	=	value;

	return SetIdxVar( name, class_number, var );

}

int SetIdxStringVar( char* name,  int class_number,  char* value ){

	var_t var;

	var.type	=	t_STRING;
	var.string	=	value;
	var.number 	= 	strlen(value);
	return SetIdxVar( name, class_number, var );

}


int GetNumericVar( char* var_name ){

	var_t var	=	GetROVar(var_name);
	return var.number;

}

int GetIdxNumericVar( char* name, int class_number ){

	char* temp	=	malloc( strlen( name ) + 10 );
	int q;
	sprintf( temp, name, class_number );
	q=GetNumericVar( temp );
	FREE(temp);
	return q;

}

char* GetStringVar( char* var_name ){

	var_t var	=	GetROVar( var_name );
	return ( dup(var.string) );

}

 char* GetROStringVar( char* var_name ){
	var_t var	=	GetROVar( var_name );
	return ( var.string );
}

int IncStreamCounter( int T ){

	char str_num[]	=	"stream.?";

	str_num[7]		=	T;
	IncNumVar( str_num );
	return 0;

}

void PrintVarList(){
	var_item_t* current=Var_root;
	int c=0;
	while(current){
		printf("#%d, \"%s\", %d,%d, ~%p~\n",c++,current->name,current->content.type,current->content.number,current->content.string);
		current=current->Next;
	}
}

/*var_item_t* MakeSnap(){
	var_item_t* current=Var_root;
	if(!current) return NULL;
	while(current->Next) current=current->Next;
	return current;
}*/

const char *vids_names[VIDEO_INFO_SIZE]={
	"v!.l",
	"v!.x",
	"v!.y",
	"v!.bits",
	"v!.cc",
	"v!.fpsH",
	"v!.fpsL",
	"v!.bps",
	"v!.bspadd",
	"v!.aspectX",
	"v!.aspectY"
};
const char *auds_names[AUDIO_INFO_SIZE]={
	"a!.l",
	"a!.bits",
	"a!.cc",
	"a!.bps",
	"a!.bspadd",
	"a!.ch",
	"a!.freq"
};

void AddAudioVideo(unsigned int video[MAX_STREAMS][VIDEO_INFO_SIZE], unsigned int audio[MAX_STREAMS][AUDIO_INFO_SIZE]){
	unsigned int c;
	unsigned int c2;
	unsigned int a_c=0;
	unsigned int v_c=0;
	char buffer[16];
	for(c=0;c<MAX_STREAMS;c++){
		if(video) if(video[c][V_exist]){
			v_c++;
			for(c2=0;c2<VIDEO_INFO_SIZE-1;c2++){
				if(video[c][c2]){
					strcpy(buffer,vids_names[c2]);
					buffer[1]=v_c+'0';
					if(video[c][c2])SetNumericVar(buffer,video[c][c2]);
				}
			}
		}
		if(audio) if(audio[c][A_exist]){
			a_c++;
			for(c2=0;c2<AUDIO_INFO_SIZE-1;c2++){
				if(audio[c][c2]){
					strcpy(buffer,auds_names[c2]);
					buffer[1]=a_c+'0';
					if(audio[c][c2])SetNumericVar(buffer,audio[c][c2]);
				}
			}
		}
	}
	SetNumericVar("stream.v",v_c);
	SetNumericVar("stream.a",a_c);
}
