/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:47:06 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.plot.CSCSAlgorithm;
import uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageAlgorithm;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.plot.CumulativeGCSkewAlgorithm;
import uk.ac.sanger.artemis.plot.GCDeviationAlgorithm;
import uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm;
import uk.ac.sanger.artemis.plot.ICDIAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.plot.NcAlgorithm;
import uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm;
import uk.ac.sanger.artemis.plot.ScaledChiAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class BaseAlgorithm_ESTest extends BaseAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertNotNull(gCSDWindowAlgorithm0);
      
      int int0 = gCSDWindowAlgorithm0.getValueCount();
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      Bases bases0 = codon12CorrelationAlgorithm0.getBases();
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertNull(bases0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("]Nx\"");
      assertEquals(4, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(4, genbankStreamSequence0.getOtherCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(4, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(4, genbankStreamSequence0.getOtherCount());
      assertEquals("nnnn", bases0.toString());
      assertEquals(0, bases0.getCCount());
      assertEquals(4, bases0.getLength());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(4, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(4, genbankStreamSequence0.getOtherCount());
      assertEquals("nnnn", bases0.toString());
      assertEquals(0, bases0.getCCount());
      assertEquals(4, bases0.getLength());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getGCount());
      assertEquals(4, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      assertEquals(4, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(4, genbankStreamSequence0.getOtherCount());
      assertEquals("nnnn", bases0.toString());
      assertEquals(0, bases0.getCCount());
      assertEquals(4, bases0.getLength());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getGCount());
      assertEquals(4, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertNull(ncAlgorithm0.getAverage());
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals(3, ncAlgorithm0.getValueCount());
      assertFalse(ncAlgorithm0.isUserMaxMin());
      assertEquals("Nc", ncAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, ncAlgorithm0.getUserMax(), 0.01F);
      assertFalse(ncAlgorithm0.isRevCompDisplay());
      assertEquals("Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, ncAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(ncAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Bases bases1 = ncAlgorithm0.getBases();
      assertEquals(4, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(4, genbankStreamSequence0.getOtherCount());
      assertEquals("nnnn", bases0.toString());
      assertEquals(0, bases0.getCCount());
      assertEquals(4, bases0.getLength());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getGCount());
      assertEquals(4, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertNull(ncAlgorithm0.getAverage());
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals(3, ncAlgorithm0.getValueCount());
      assertFalse(ncAlgorithm0.isUserMaxMin());
      assertEquals("Nc", ncAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, ncAlgorithm0.getUserMax(), 0.01F);
      assertFalse(ncAlgorithm0.isRevCompDisplay());
      assertEquals("Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, ncAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getTCount());
      assertEquals("nnnn", bases1.toString());
      assertEquals(4, bases1.getLength());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertNotNull(bases1);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      assertEquals(1.4E-45F, cSCSAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmName());
      assertTrue(cSCSAlgorithm0.scalingFlag());
      assertEquals(3, cSCSAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cSCSAlgorithm0.getUserMax(), 0.01F);
      assertNull(cSCSAlgorithm0.getAverage());
      assertFalse(cSCSAlgorithm0.isRevCompDisplay());
      assertFalse(cSCSAlgorithm0.isUserMaxMin());
      assertEquals("Corrected Scaled Chi Square", cSCSAlgorithm0.getAlgorithmShortName());
      assertNotNull(cSCSAlgorithm0);
      
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        cSCSAlgorithm0.getValues(1, (-1664), floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      assertEquals(1, gCSDWindowAlgorithm0.getValueCount());
      assertFalse(gCSDWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertNotNull(gCSDWindowAlgorithm0);
      
      float[] floatArray0 = new float[6];
      // Undeclared exception!
      try { 
        gCSDWindowAlgorithm0.getValues(1, (-255), floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -256
         //
         verifyException("uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCDeviationAlgorithm gCDeviationAlgorithm0 = new GCDeviationAlgorithm(strand0);
      assertEquals(3.4028235E38F, gCDeviationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("gc_deviation", gCDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("GC Deviation (G-C)/(G+C)", gCDeviationAlgorithm0.getAlgorithmName());
      assertTrue(gCDeviationAlgorithm0.scalingFlag());
      assertFalse(gCDeviationAlgorithm0.isUserMaxMin());
      assertEquals(1, gCDeviationAlgorithm0.getValueCount());
      assertNotNull(gCDeviationAlgorithm0);
      
      LineAttributes[] lineAttributesArray0 = new LineAttributes[9];
      // Undeclared exception!
      try { 
        gCDeviationAlgorithm0.drawLegend((Graphics) null, 2, 1, lineAttributesArray0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(positionalAsymmetryAlgorithm0);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[3];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.drawLegend(graphics0, Integer.MAX_VALUE, 5, lineAttributesArray0, (-2275));
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // codegen.java.awt.Graphics$MockitoMock$1219758061 cannot be cast to java.awt.Graphics2D
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      assertFalse(scaledChiAlgorithm0.isUserMaxMin());
      assertFalse(scaledChiAlgorithm0.isRevCompDisplay());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertEquals("Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, scaledChiAlgorithm0.getUserMax(), 0.01F);
      assertNull(scaledChiAlgorithm0.getAverage());
      assertEquals(3, scaledChiAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, scaledChiAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(scaledChiAlgorithm0);
      
      // Undeclared exception!
      try { 
        scaledChiAlgorithm0.getStrand();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      boolean boolean0 = cumulativeGCSkewAlgorithm0.isRevCompDisplay();
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Component and container locations must contain an equal number of symbols.");
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(74, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(60, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(74, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(60, emblStreamSequence0.getOtherCount());
      assertEquals("nnmnnnnntnandncnntannnrnnncatnnnsnmustncnntannnannnnuannnumbnrnnnnsymbnnsn", bases0.toString());
      assertEquals(0, bases0.getGCount());
      assertEquals(6, bases0.getACount());
      assertEquals(5, bases0.getTCount());
      assertEquals(74, bases0.getLength());
      assertEquals(8.108108F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getCCount());
      assertEquals(4.054054F, bases0.getAverageGCPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(74, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(60, emblStreamSequence0.getOtherCount());
      assertEquals("nnmnnnnntnandncnntannnrnnncatnnnsnmustncnntannnannnnuannnumbnrnnnnsymbnnsn", bases0.toString());
      assertEquals(0, bases0.getGCount());
      assertEquals(6, bases0.getACount());
      assertEquals(5, bases0.getTCount());
      assertEquals(74, bases0.getLength());
      assertEquals(8.108108F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getCCount());
      assertEquals(4.054054F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(74, strand0.getSequenceLength());
      assertEquals(6, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(5, strand0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(74, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(60, emblStreamSequence0.getOtherCount());
      assertEquals("nnmnnnnntnandncnntannnrnnncatnnnsnmustncnntannnannnnuannnumbnrnnnnsymbnnsn", bases0.toString());
      assertEquals(0, bases0.getGCount());
      assertEquals(6, bases0.getACount());
      assertEquals(5, bases0.getTCount());
      assertEquals(74, bases0.getLength());
      assertEquals(8.108108F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getCCount());
      assertEquals(4.054054F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(74, strand0.getSequenceLength());
      assertEquals(6, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(5, strand0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertFalse(iCDIAlgorithm0.isRevCompDisplay());
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertNull(iCDIAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, iCDIAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertEquals(3, iCDIAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, iCDIAlgorithm0.getUserMin(), 0.01F);
      assertFalse(iCDIAlgorithm0.isUserMaxMin());
      assertEquals("ICDI", iCDIAlgorithm0.getAlgorithmShortName());
      assertNotNull(iCDIAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Bases bases1 = iCDIAlgorithm0.getBases();
      assertEquals(5, emblStreamSequence0.getTCount());
      assertEquals(74, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, emblStreamSequence0.getCCount());
      assertEquals(6, emblStreamSequence0.getACount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(60, emblStreamSequence0.getOtherCount());
      assertEquals("nnmnnnnntnandncnntannnrnnncatnnnsnmustncnntannnannnnuannnumbnrnnnnsymbnnsn", bases0.toString());
      assertEquals(0, bases0.getGCount());
      assertEquals(6, bases0.getACount());
      assertEquals(5, bases0.getTCount());
      assertEquals(74, bases0.getLength());
      assertEquals(8.108108F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getCCount());
      assertEquals(4.054054F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(74, strand0.getSequenceLength());
      assertEquals(6, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(5, strand0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertFalse(iCDIAlgorithm0.isRevCompDisplay());
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertNull(iCDIAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, iCDIAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertEquals(3, iCDIAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, iCDIAlgorithm0.getUserMin(), 0.01F);
      assertFalse(iCDIAlgorithm0.isUserMaxMin());
      assertEquals("ICDI", iCDIAlgorithm0.getAlgorithmShortName());
      assertEquals(0, bases1.getGCount());
      assertEquals(6, bases1.getACount());
      assertEquals("nnmnnnnntnandncnntannnrnnncatnnnsnmustncnntannnannnnuannnumbnrnnnnsymbnnsn", bases1.toString());
      assertEquals(5, bases1.getTCount());
      assertEquals(8.108108F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(4.054054F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(74, bases1.getLength());
      assertEquals(3, bases1.getCCount());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Strand) null).when(bases0).getForwardStrand();
      doReturn((String) null).when(bases0).toString();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      CodonUsageWeight codonUsageWeight0 = mock(CodonUsageWeight.class, new ViolatedAssumptionAnswer());
      doReturn("").when(codonUsageWeight0).getName();
      CodonUsageAlgorithm codonUsageAlgorithm0 = new CodonUsageAlgorithm(strand0, codonUsageWeight0);
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from ", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertNotNull(codonUsageAlgorithm0);
      
      Strand strand1 = codonUsageAlgorithm0.getStrand();
      assertNull(codonUsageAlgorithm0.getAverage());
      assertEquals("codon_usage", codonUsageAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, codonUsageAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Codon Usage Scores from ", codonUsageAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, codonUsageAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codonUsageAlgorithm0.scalingFlag());
      assertFalse(codonUsageAlgorithm0.isRevCompDisplay());
      assertEquals(3, codonUsageAlgorithm0.getValueCount());
      assertFalse(codonUsageAlgorithm0.isUserMaxMin());
      assertNull(strand1);
  }
}
