!{\src2tex{textfont=tt}}
!!****f* ABINIT/prep_coh
!! NAME
!! prep_coh
!!
!! FUNCTION
!! Calculate the Fourier transform of $\u_{b_1 ks}^*(r) u_{b_2ks}$
!! Symmetries are used to obtain $\u_{b_1 ks}^*(r)$ and $u_{b_2 ks}(r)$
!! starting from the corresponding wavefunctions in the IBZ
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (FB,MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! maxbnd,minbnd=max and min band idex for which the Fourier transform of 
!!  $\u_{b_1}ks^*(r) u_{b_2}ks$ is required
!! nb=total number of bands (to dimension wfr)
!! ngfft1,ngfft2,ngfft3=FFT grid
!! nr=number of points in the FFT grid
!! ns=number of independent spin polarizations (equal to nsppol)
!! tim_fourdp=timing code for fourdp
!! mpi_enreg=informations about MPI parallelization
!! ktabr_k(nr)=index of R**-1 r in the FFT array for this particular
!!  kpoint kBZ, where kBZ=(IR) kIBZ 
!! wfr_k(nr,nb,ns)=input wavefunction in real space
!!  
!! OUTPUT
!! wfg2(nr,minbnd:maxbnd,minbnd:maxbnd)= contains the Fourier Transform
!!  of $\u_{b_1 ks}^*(r) u_{b_2ks}$ 
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      fourdp
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prep_coh(nb,nr,ns,wfr_k,ktabr_k,minbnd,maxbnd,ngfft1,ngfft2,ngfft3,tim_fourdp,wfg2,mpi_enreg)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_12ffts
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: maxbnd,minbnd,nb,ngfft1,ngfft2,ngfft3,nr,ns,tim_fourdp
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: ktabr_k(nr)
 complex,intent(in) :: wfr_k(nr,nb,ns)
 complex,intent(out) :: wfg2(nr,minbnd:maxbnd,minbnd:maxbnd,ns)

!Local variables-------------------------------
!scalars
 integer :: is,jb,kb
!arrays
 integer :: ngfft(18)
 real(dp) :: wfg2_tmp(2,nr),wfr2_tmp(2,nr)

! *************************************************************************

!DEBUG
!write(6,*)' prep_coh : enter '
!ENDDEBUG

 do is=1,ns
  do jb=minbnd,maxbnd
   do kb=minbnd,maxbnd

!MG071009 FIXME I think there is a BUG in prep_coh because we are not taking into
!account the time reversal symmetry, should pass ktabi to this subroutine  

    wfr2_tmp(1,:)=real(wfr_k(ktabr_k(:),jb,is))*real(wfr_k(ktabr_k(:),kb,is))&
&               +aimag(wfr_k(ktabr_k(:),jb,is))*aimag(wfr_k(ktabr_k(:),kb,is))
    wfr2_tmp(2,:)=real(wfr_k(ktabr_k(:),jb,is))*aimag(wfr_k(ktabr_k(:),kb,is))&
&                -real(wfr_k(ktabr_k(:),kb,is))*aimag(wfr_k(ktabr_k(:),jb,is))

    ngfft(1)=ngfft1
    ngfft(2)=ngfft2
    ngfft(3)=ngfft3
    ngfft(4)=2*(ngfft(1)/2)+1
    ngfft(5)=2*(ngfft(2)/2)+1
    ngfft(6)=ngfft(3)
    ngfft(7)=200
    ngfft(8)=256
    ngfft(9)=0
    ngfft(10)=1
    ngfft(11)=0
    ngfft(12)=ngfft2
    ngfft(13)=ngfft3
    ngfft(14)=0
    call fourdp(2,wfg2_tmp,wfr2_tmp,-1,mpi_enreg,nr,ngfft,tim_fourdp)
    wfg2(:,jb,kb,is)=wfg2_tmp(1,:)+(0.,1.)*wfg2_tmp(2,:)
 
   end do
  end do
 end do

end subroutine prep_coh
!!***
