// $Id: biasgdgt.h 1386 2006-06-28 17:49:55Z alex $
//------------------------------------------------
//  CBiasGainGadget.h
//------------------------------------------------
/* @@tag:xara-cn@@ DO NOT MODIFY THIS LINE
================================XARAHEADERSTART===========================
 
               Xara LX, a vector drawing and manipulation program.
                    Copyright (C) 1993-2006 Xara Group Ltd.
       Copyright on certain contributions may be held in joint with their
              respective authors. See AUTHORS file for details.

LICENSE TO USE AND MODIFY SOFTWARE
----------------------------------

This file is part of Xara LX.

Xara LX is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License version 2 as published
by the Free Software Foundation.

Xara LX and its component source files are distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with Xara LX (see the file GPL in the root directory of the
distribution); if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


ADDITIONAL RIGHTS
-----------------

Conditional upon your continuing compliance with the GNU General Public
License described above, Xara Group Ltd grants to you certain additional
rights. 

The additional rights are to use, modify, and distribute the software
together with the wxWidgets library, the wxXtra library, and the "CDraw"
library and any other such library that any version of Xara LX relased
by Xara Group Ltd requires in order to compile and execute, including
the static linking of that library to XaraLX. In the case of the
"CDraw" library, you may satisfy obligation under the GNU General Public
License to provide source code by providing a binary copy of the library
concerned and a copy of the license accompanying it.

Nothing in this section restricts any of the rights you have under
the GNU General Public License.


SCOPE OF LICENSE
----------------

This license applies to this program (XaraLX) and its constituent source
files only, and does not necessarily apply to other Xara products which may
in part share the same code base, and are subject to their own licensing
terms.

This license does not apply to files in the wxXtra directory, which
are built into a separate library, and are subject to the wxWindows
license contained within that directory in the file "WXXTRA-LICENSE".

This license does not apply to the binary libraries (if any) within
the "libs" directory, which are subject to a separate license contained
within that directory in the file "LIBS-LICENSE".


ARRANGEMENTS FOR CONTRIBUTION OF MODIFICATIONS
----------------------------------------------

Subject to the terms of the GNU Public License (see above), you are
free to do whatever you like with your modifications. However, you may
(at your option) wish contribute them to Xara's source tree. You can
find details of how to do this at:
  http://www.xaraxtreme.org/developers/

Prior to contributing your modifications, you will need to complete our
contributor agreement. This can be found at:
  http://www.xaraxtreme.org/developers/contribute/

Please note that Xara will not accept modifications which modify any of
the text between the start and end of this header (marked
XARAHEADERSTART and XARAHEADEREND).


MARKS
-----

Xara, Xara LX, Xara X, Xara X/Xtreme, Xara Xtreme, the Xtreme and Xara
designs are registered or unregistered trademarks, design-marks, and/or
service marks of Xara Group Ltd. All rights in these marks are reserved.


      Xara Group Ltd, Gaddesden Place, Hemel Hempstead, HP2 6EX, UK.
                        http://www.xara.com/

=================================XARAHEADEREND============================
 */




#ifndef  Include_CBiasGainGadget
#define  Include_CBiasGainGadget

//#include doccolor.h

class  CBiasGainDlg;
class  InformationBarOp;
class  CProfileBiasGain;
class  DocColour;
class  FillEffectAttribute;











//-------------------------------------------------------------------------------------------------
//
//	class CBiasGainGadget
//
//	Author:     Harrison Ainsworth
//	Date:		06/99
//	Purpose:	represent and contain a gadget specifically for selecting bias/gain choices. 
//				intended to enable easier addition of such a gadget to various toolbars.
//				it handles messages generated by user interaction with the windows gadget, and then
//				sends out commit or slider-set messages (containing the chosen values) to its owning 
//				infobar.
//	Implemen-	depends on a InformationBarOp and valid gadgetID, bubbleID and statusID.
//	tation:		
//	Invariants:	pOwningBar_m is valid, 
//				GadgetID_m is valid
//				BubbleID_m is valid
//				StatusID_m is valid
//				pDialog_m is valid
//
//-------------------------------------------------------------------------------------------------

class CBiasGainGadget
{

public: //-----------------------------------------------------------------------------------------


	CBiasGainGadget ();
	virtual ~CBiasGainGadget ();


	virtual void		Init ( DialogOp* pOwningDialog,
							   CGadgetID GadgetID, UINT32 BubbleID, UINT32 StatusID );
	
	virtual	void		Enable ( BOOL );
	virtual	void		GetPresetBiasGainValue ( WORD Index,  CProfileBiasGain& Value )			const;
	virtual INT32		FindPresetBiasGain (CProfileBiasGain const& Value)						const;

	// handle messages
	virtual	void		Message ( DialogMsg* );
	virtual	void		Message ( DialogMsg*,  CProfileBiasGain const& );
	virtual	void		CloseDialog ();
	

	// interface for use by CBiasGainDlg ----------------------
	virtual	void		DialogHasOpened ();
	virtual	void		DialogHasClosed ();

	virtual	CGadgetID	GetGadgetID ()															const;
	virtual	void		GetDialogTitle ( String_256& DlgTitle )									const;

	// DMc
	//void SetDialogBiasGain(CProfileBiasGain const& );

	// CGS
	// this allows the gadget to know abouts its linked dialog
	void SetCBaisGainDlg (CBiasGainDlg* pMyDlg) { pDialog_m = pMyDlg; }
	// this allows us to route message from the profile gadget (located on the dialog)
	// through the gadget that is located on the infobar
	void SetInfobarGadgetID (CGadgetID gadg) { InfobarGadgetID_m = gadg; }
	// this allows us to reinit the linked dialog when the selection changes
	void ReInitialiseDialog (CProfileBiasGain* ReInitOn, BOOL bMany);
	// allows us to query whether the gadgets linked dialog is open (i.e.  exists)
	BOOL IsDialogOpen () { if (pDialog_m != NULL) { return (TRUE); } else { return (FALSE); } }
	// allows us to change the mode of the linked dialog from its (default) object profile
	// rendering to its fill profile rendering
	void ToggleFillProfile () { useFillProfile = TRUE; }
	// our 'linked' dialog needs access to this information when it is created
	BOOL GetUseFillProfile () { return (useFillProfile); }
	// allows us to change the mode of the linked dialog from its (default) object profile
	// rendering to its transparent fill profile rendering
	void ToggleTranspFillProfile () { useTranspFillProfile = TRUE; }
	// our 'linked' dialog needs access to this information when it is created
	BOOL GetUseTranspFillProfile () { return (useTranspFillProfile); }
	// we need direct access the dialogs 'edited' biasgain within elans feathering bar ....
	CProfileBiasGain GetCurrentDialogProfile ();

	void SetStartColour(DocColour* NewCol);
	void SetEndColour(DocColour* NewCol);
	void SetEndColour2(DocColour* NewCol);
	void SetEndColour3(DocColour* NewCol);
	void SetStartTransp(UINT32* NewTransp);
	void SetEndTransp(UINT32* NewTransp);
	void SetEndTransp2(UINT32* NewTransp);
	void SetEndTransp3(UINT32* NewTransp);
	void SetFillEffect(FillEffectAttribute* NewFillEffect);

	DocColour* GetStartColour() { return (StartColour); }
	DocColour* GetEndColour() { return (EndColour); }
	DocColour* GetEndColour2() { return (EndColour2); }
	DocColour* GetEndColour3() { return (EndColour3); }
	UINT32* GetStartTransp() { return (StartTransp); }
	UINT32* GetEndTransp() { return (EndTransp); }
	UINT32* GetEndTransp2() { return (EndTransp2); }
	UINT32* GetEndTransp3() { return (EndTransp3); }
	FillEffectAttribute* GetFillEffect () { return (FillEffect); }

	// a necessary 'hack' for OpChangeFeatherProfile - to allow us to toggle the state of the
	// linked control button
//	InformationBarOp* GetOwningBar () { return (pOwningBar_m); }


protected: //--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--//--


private: /////////////////////////////////////////////////////////////


	// members ------------------------------------------------
	DialogOp*			pOwningDialog_m;	// owner of me (when located on a dialog)
	CGadgetID			GadgetID_m;
	CGadgetID			InfobarGadgetID_m;	// owner of dialog
	UINT32				BubbleID_m;
	UINT32				StatusID_m;

	CBiasGainDlg*		pDialog_m;			// my linked dialog

	BOOL				useFillProfile;		// are we rendering objects or fills within
											// our linked dialog?
	BOOL				useTranspFillProfile;	// do we want to render transparency
												// fill profiles?

	DocColour* StartColour;
	DocColour* EndColour;
	DocColour* EndColour2;
	DocColour* EndColour3;
	FillEffectAttribute* FillEffect;
	UINT32* StartTransp;
	UINT32* EndTransp;
	UINT32* EndTransp2;
	UINT32* EndTransp3;


	enum { eNumberOfPresets = 5 };
	static const INT32			kNumberOfPresets_s;
	static const double			kBiasPresets_s[ eNumberOfPresets ];
	static const double			kGainPresets_s[ eNumberOfPresets ];




private:
	// Copying is disallowed.
	CBiasGainGadget ( const CBiasGainGadget& );
	CBiasGainGadget&	operator= ( const CBiasGainGadget& );

};


 





#endif//Include_CBiasGainGadget
