#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tonight We Riot
###

script_version=20240528.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='tonight-we-riot'
GAME_NAME='Tonight We Riot'

ARCHIVE_BASE_ITCH_0_NAME='TonightWeRiot_Linux.zip'
ARCHIVE_BASE_ITCH_0_MD5='293a595ea44b5e80a0ca0eeb7b5a925a'
ARCHIVE_BASE_ITCH_0_SIZE='690000'
ARCHIVE_BASE_ITCH_0_VERSION='1.0-itch.2020.06.08'
ARCHIVE_BASE_ITCH_0_URL='https://meansinteractive.itch.io/tonight-we-riot'

ARCHIVE_BASE_GOG_2_NAME='tonight_we_riot_linuxrelease_c_38381.sh'
ARCHIVE_BASE_GOG_2_MD5='7afc74aefbccaa58627d934e63c16247'
ARCHIVE_BASE_GOG_2_SIZE='690000'
ARCHIVE_BASE_GOG_2_VERSION='1.0.c-gog38381'
ARCHIVE_BASE_GOG_2_URL='https://www.gog.com/game/tonight_we_riot'

ARCHIVE_BASE_GOG_1_NAME='tonight_we_riot_linuxrelease_b_38278.sh'
ARCHIVE_BASE_GOG_1_MD5='7ca6aedccb70bcd027b9e79d5cfb8585'
ARCHIVE_BASE_GOG_1_SIZE='690000'
ARCHIVE_BASE_GOG_1_VERSION='1.0.b-gog38278'

ARCHIVE_BASE_GOG_0_NAME='tonight_we_riot_linuxrelease_a_38076.sh'
ARCHIVE_BASE_GOG_0_MD5='38b03db54a7d80895d2abe0d9f153ae7'
ARCHIVE_BASE_GOG_0_SIZE='690000'
ARCHIVE_BASE_GOG_0_VERSION='1.0.a-gog38076'

UNITY3D_NAME='TonightWeRiot_Linux'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_ITCH='TonightWeRiot_Linux'
CONTENT_PATH_DEFAULT_GOG='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
