#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Rayman 1
###

script_version=20230924.2

GAME_ID='rayman-1'
GAME_NAME='Rayman'

PLAYIT_COMPATIBILITY_LEVEL='2.26'

ARCHIVE_BASE_1_NAME='setup_rayman_forever_1.21_(28045).exe'
ARCHIVE_BASE_1_MD5='304cca5f14923730c76bb61f669be575'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='290000'
ARCHIVE_BASE_1_VERSION='1.21-gog28045'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/rayman_forever'

ARCHIVE_BASE_0_NAME='setup_rayman_forever_2.0.0.15.exe'
ARCHIVE_BASE_0_MD5='96e71ea03261646f7f5ce4cb27d6a222'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='290000'
ARCHIVE_BASE_0_VERSION='1.21-gog2.0.0.15'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_MAIN_FILES='
GAME.GOG
GAME.INS
MUSIC
RAYFAN
RAYKIT
RAYMAN'
CONTENT_DOC_DATA_FILES='
MANUAL.PDF'

GAME_IMAGE='GAME.INS'

USER_PERSISTENT_FILES='
RAYMAN/VIGNET.DAT
*.CFG
*.SAV'

APP_MAIN_EXE='RAYMAN/RAYMAN.EXE'
APP_MAIN_OPTIONS='save=C:\RAYMAN'
APP_MAIN_ICON='GOGGAME-1207658919.ICO'
APP_MAIN_ICON_0='GFW_HIGH.ICO'
## Run the game binary from its parent directory
APP_MAIN_PRERUN='# Run the game binary from its parent directory
APP_EXE_DIRECTORY=$(dirname "$APP_EXE")
APP_EXE=$(basename "$APP_EXE")
'
APP_MAIN_DOSBOX_PRERUN='
cd $APP_EXE_DIRECTORY'

APP_FAN_ID="${GAME_ID}-rayfan"
APP_FAN_NAME="$GAME_NAME - Rayman by his Fans"
APP_FAN_EXE='RAYFAN/RAYFAN.EXE'
APP_FAN_OPTIONS='ver=usa'
APP_FAN_ICON='RAYFAN/RAYFAN.ICO'
## Run the game binary from its parent directory
APP_FAN_PRERUN="$APP_MAIN_PRERUN"
APP_FAN_DOSBOX_PRERUN="$APP_MAIN_DOSBOX_PRERUN"

APP_KIT_ID="${GAME_ID}-raykit"
APP_KIT_NAME="$GAME_NAME - Rayman Designer"
APP_KIT_EXE='RAYKIT/RAYKIT.EXE'
APP_KIT_OPTIONS='ver=usa'
APP_KIT_ICON='RAYKIT/RAYKIT.ICO'
## Run the game binary from its parent directory
APP_KIT_PRERUN="$APP_MAIN_PRERUN"
APP_KIT_DOSBOX_PRERUN="$APP_MAIN_DOSBOX_PRERUN"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert all game files to uppercase
	toupper .

	# Force the name of the disk image table of contents
	if [ -e 'GAME.INST' ]; then
		mv 'GAME.INST' "$GAME_IMAGE"
	fi
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
