/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALASSETREGISTEREDPROFILEACCESS_H_
#define OPENDRIM_PHYSICALASSETREGISTEREDPROFILEACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_PhysicalAssetRegisteredProfile.h"

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PhysicalAssetRegisteredProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PhysicalAssetRegisteredProfile& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetRegisteredProfile& newInstance, const OpenDRIM_PhysicalAssetRegisteredProfile& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetRegisteredProfile& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PhysicalAssetRegisteredProfile& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_PhysicalAssetRegisteredProfile_populate(OpenDRIM_PhysicalAssetRegisteredProfile& instance, string& errorMessage);

#endif /*OPENDRIM_PHYSICALASSETREGISTEREDPROFILEACCESS_H_*/
