/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.Value;

public class InstructionOffsetValue
extends Category1Value {
    private static final int[] EMPTY_OFFSETS = new int[0];
    public static final InstructionOffsetValue EMPTY_VALUE = new InstructionOffsetValue(EMPTY_OFFSETS);
    public static final int INSTRUCTION_OFFSET_MASK = 0x1FFFFFF;
    public static final int METHOD_PARAMETER = 0x1000000;
    public static final int METHOD_RETURN_VALUE = 0x2000000;
    public static final int FIELD_VALUE = 0x4000000;
    public static final int NEW_INSTANCE = 0x8000000;
    public static final int CAST = 0x10000000;
    public static final int EXCEPTION_HANDLER = 0x20000000;
    private int[] values;

    public InstructionOffsetValue(int n) {
        this.values = new int[]{n};
    }

    public InstructionOffsetValue(int[] nArray) {
        this.values = nArray;
    }

    public int instructionOffsetCount() {
        return this.values.length;
    }

    public int instructionOffset(int n) {
        return this.values[n] & 0x1FFFFFF;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != n) continue;
            return true;
        }
        return false;
    }

    public int minimumValue() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            int n2 = this.values[i] & 0x1FFFFFF;
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    public int maximumValue() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.values.length; ++i) {
            int n2 = this.values[i] & 0x1FFFFFF;
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public boolean isMethodParameter(int n) {
        return (this.values[n] & 0x1000000) != 0;
    }

    public int methodParameter(int n) {
        return this.values[n] & 0xFEFFFFFF;
    }

    public boolean isMethodReturnValue(int n) {
        return (this.values[n] & 0x2000000) != 0;
    }

    public boolean isFieldValue(int n) {
        return (this.values[n] & 0x4000000) != 0;
    }

    public boolean isNewinstance(int n) {
        return (this.values[n] & 0x8000000) != 0;
    }

    public boolean isCast(int n) {
        return (this.values[n] & 0x10000000) != 0;
    }

    public boolean isExceptionHandler(int n) {
        return (this.values[n] & 0x20000000) != 0;
    }

    public InstructionOffsetValue add(int n) {
        if (this.contains(n)) {
            return this;
        }
        int[] nArray = new int[this.values.length + 1];
        System.arraycopy(this.values, 0, nArray, 0, this.values.length);
        nArray[this.values.length] = n;
        return new InstructionOffsetValue(nArray);
    }

    public InstructionOffsetValue remove(int n) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != n) continue;
            int[] nArray = new int[this.values.length - 1];
            System.arraycopy(this.values, 0, nArray, 0, i);
            System.arraycopy(this.values, i + 1, nArray, i, this.values.length - i - 1);
            return new InstructionOffsetValue(nArray);
        }
        return this;
    }

    public final InstructionOffsetValue generalize(InstructionOffsetValue instructionOffsetValue) {
        int n;
        int[] nArray = this.values;
        if (nArray.length == 0) {
            return instructionOffsetValue;
        }
        int[] nArray2 = instructionOffsetValue.values;
        if (nArray2.length == 0) {
            return this;
        }
        int n2 = nArray.length;
        for (n = 0; n < nArray2.length; ++n) {
            if (this.contains(nArray2[n])) continue;
            ++n2;
        }
        if (n2 == nArray2.length) {
            return instructionOffsetValue;
        }
        if (n2 == this.values.length && nArray2.length == 1 && nArray[nArray.length - 1] == nArray2[0]) {
            return this;
        }
        n = 0;
        int[] nArray3 = new int[n2];
        if (n2 == nArray.length + nArray2.length) {
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            n = nArray.length;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (instructionOffsetValue.contains(nArray[i])) continue;
                nArray3[n++] = nArray[i];
            }
        }
        System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        return new InstructionOffsetValue(nArray3);
    }

    @Override
    public final InstructionOffsetValue instructionOffsetValue() {
        return this;
    }

    @Override
    public boolean isSpecific() {
        return true;
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public final Value generalize(Value value) {
        return this.generalize(value.instructionOffsetValue());
    }

    @Override
    public final int computationalType() {
        return 6;
    }

    @Override
    public final String internalType() {
        return String.valueOf('I');
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InstructionOffsetValue instructionOffsetValue = (InstructionOffsetValue)object;
        if (this.values == instructionOffsetValue.values) {
            return true;
        }
        if (this.values == null || instructionOffsetValue.values == null || this.values.length != instructionOffsetValue.values.length) {
            return false;
        }
        for (int i = 0; i < instructionOffsetValue.values.length; ++i) {
            if (this.contains(instructionOffsetValue.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                n ^= this.values[i];
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.values[i] < 0) {
                    stringBuffer.append(this.values[i]);
                    continue;
                }
                if (this.isMethodParameter(i)) {
                    stringBuffer.append('P');
                }
                if (this.isMethodReturnValue(i)) {
                    stringBuffer.append('M');
                }
                if (this.isFieldValue(i)) {
                    stringBuffer.append('F');
                }
                if (this.isNewinstance(i)) {
                    stringBuffer.append('N');
                }
                if (this.isCast(i)) {
                    stringBuffer.append('C');
                }
                if (this.isExceptionHandler(i)) {
                    stringBuffer.append('E');
                }
                stringBuffer.append(this.values[i] & 0xFFFF);
            }
        }
        return stringBuffer.append(':').toString();
    }
}

