static char rcsid[] = "$Id: maxent_hr.c 53340 2011-11-29 23:07:16Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "maxent_hr.h"
#include <stdio.h>
#include <stdlib.h>


#define DONOR_MODEL_LEFT_MARGIN 3 /* Amount in exon.  Does not include GT */
#define DONOR_MODEL_RIGHT_MARGIN 6 /* Amount in intron */

#define ACCEPTOR_MODEL_LEFT_MARGIN 20 /* Amount in intron.  Includes AG */
#define ACCEPTOR_MODEL_RIGHT_MARGIN 3 /* Amount in exon */


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif


static const double donor_score_plus[16384] =
{1.4359596e-01, 2.3564868e-01, 6.8940261e-02, 2.2479970e-02, 1.9498629e-02, 1.8962596e-02, 6.5353213e-03, 7.5289169e-03,
 1.1135722e-02, 2.4760753e-02, 2.9084585e-03, 3.7937509e-03, 5.6493183e-03, 7.9177177e-03, 1.6257963e-03, 1.5311906e-03,
 9.8735899e-03, 8.4693175e-03, 5.0999206e-03, 1.7705289e-03, 1.2692612e-03, 6.4520168e-04, 4.5768996e-04, 5.6137599e-04,
 6.2392970e-04, 7.2515702e-04, 1.7532268e-04, 2.4347855e-04, 6.6456434e-04, 4.8684610e-04, 2.0576188e-04, 2.0632171e-04,
 2.1087740e+01, 2.4539969e+01, 1.0030623e+01, 4.1281920e+00, 5.8836603e+00, 4.0575415e+00, 1.9537889e+00, 2.8408767e+00,
 1.4437911e+00, 2.2765200e+00, 3.7360800e-01, 6.1507966e-01, 1.7600543e+00, 1.7492488e+00, 5.0183775e-01, 5.9653454e-01,
 3.6979292e-02, 3.8207439e-02, 2.3393828e-02, 4.7897940e-03, 5.7636204e-03, 3.5290353e-03, 2.5454824e-03, 1.8413168e-03,
 3.2955781e-03, 4.6136440e-03, 1.1341963e-03, 9.2893897e-04, 2.8874086e-03, 2.5478814e-03, 1.0949403e-03, 6.4751006e-04,
 3.5721985e-05, 7.7495025e-05, 8.2318329e-06, 2.8820692e-06, 1.7554256e-06, 2.2567918e-06, 2.8240680e-07, 3.4932199e-07,
 5.7080184e-07, 1.6778250e-06, 7.1558320e-08, 1.0021932e-07, 3.2192890e-07, 5.9645772e-07, 4.4469303e-08, 4.4968529e-08,
 1.4415964e-05, 1.6346791e-05, 3.5740621e-06, 1.3322540e-06, 6.7066301e-07, 4.5067595e-07, 1.1607927e-07, 1.5287013e-07,
 1.8770602e-07, 2.8839648e-07, 2.5316887e-08, 3.7750145e-08, 2.2226779e-07, 2.1525180e-07, 3.3031956e-08, 3.5563115e-08,
 2.2433987e-01, 3.4511687e-01, 5.1219395e-02, 2.2633486e-02, 2.2652120e-02, 2.0650942e-02, 3.6105124e-03, 5.6367515e-03,
 3.1648616e-03, 6.5968608e-03, 3.9309397e-04, 6.9485933e-04, 4.2891672e-03, 5.6352633e-03, 5.8700325e-04, 7.4920109e-04,
 1.8941707e-05, 2.5871648e-05, 5.7516424e-06, 1.2644240e-06, 1.0684161e-06, 8.6480197e-07, 2.2648802e-07, 1.7590933e-07,
 3.4782917e-07, 6.4371548e-07, 5.7458272e-08, 5.0528533e-08, 3.3879694e-07, 3.9520825e-07, 6.1666843e-08, 3.9155530e-08,
 5.6562877e-03, 1.1748170e-02, 1.8921004e-03, 7.1453483e-04, 8.6492848e-04, 1.0646087e-03, 2.0198765e-04, 2.6949259e-04,
 2.7506891e-04, 7.7411102e-04, 5.0057339e-05, 7.5618976e-05, 1.7299917e-04, 3.0687719e-04, 3.4689343e-05, 3.7836947e-05,
 4.2400088e-04, 4.6031624e-04, 1.5259380e-04, 6.1352616e-05, 6.1380347e-05, 3.9490266e-05, 1.5421678e-05, 2.1906396e-05,
 1.6802012e-05, 2.4715747e-05, 3.2896181e-06, 5.2908428e-06, 2.2186448e-05, 2.0571168e-05, 4.7862745e-06, 5.5582032e-06,
 1.4436482e+00, 2.1262859e+00, 4.7845481e-01, 2.2804988e-01, 4.5359235e-01, 3.9591080e-01, 1.0494882e-01, 1.7672950e-01,
 6.1982568e-02, 1.2369525e-01, 1.1175399e-02, 2.1307630e-02, 9.3673388e-02, 1.1783056e-01, 1.8609531e-02, 2.5619146e-02,
 2.0549372e-03, 2.6872257e-03, 9.0578034e-04, 2.1478072e-04, 3.6067988e-04, 2.7951102e-04, 1.1098867e-04, 9.2980924e-05,
 1.1484331e-04, 2.0348581e-04, 2.7538727e-05, 2.6121587e-05, 1.2474039e-04, 1.3931398e-04, 3.2958794e-05, 2.2572736e-05,
 3.4545523e-04, 4.3599647e-04, 5.9907352e-05, 1.6560058e-05, 1.1890284e-05, 8.8931334e-06, 1.4395029e-06, 1.4058443e-06,
 3.4033934e-06, 5.8200459e-06, 3.2108072e-07, 3.5504167e-07, 4.8355096e-06, 5.2121281e-06, 5.0265497e-07, 4.0132116e-07,
 1.6422907e-06, 1.0834082e-06, 3.0640519e-07, 9.0176755e-08, 5.3513661e-08, 2.0920773e-08, 6.9701575e-09, 7.2474307e-09,
 1.3184245e-08, 1.1784740e-08, 1.3381803e-09, 1.5754210e-09, 3.9328642e-08, 2.2158103e-08, 4.3983961e-09, 3.7388123e-09,
 4.1231543e-01, 3.6901359e-01, 7.0841049e-02, 2.4715872e-02, 2.9159890e-02, 1.5465709e-02, 3.4976248e-03, 4.3112876e-03,
 3.5863131e-03, 4.3489457e-03, 3.3521029e-04, 4.6783388e-04, 1.2243977e-02, 9.3587228e-03, 1.2610062e-03, 1.2707156e-03,
 2.8364127e-06, 2.2538645e-06, 6.4814142e-07, 1.1249795e-07, 1.1205850e-07, 5.2768425e-08, 1.7876284e-08, 1.0962128e-08,
 3.2113440e-08, 3.4575450e-08, 3.9920944e-09, 2.7717805e-09, 7.8798158e-08, 5.3475609e-08, 1.0793336e-08, 5.4109151e-09,
 1.7593148e-02, 2.9861062e-02, 5.4693186e-03, 1.1659468e-03, 2.0532791e-03, 2.0652881e-03, 4.4562503e-04, 3.3562780e-04,
 6.6161631e-04, 1.5215658e-03, 1.1189474e-04, 9.5419749e-05, 3.7862902e-04, 5.4885417e-04, 7.0557486e-05, 4.3443935e-05,
 1.7171478e-03, 1.5234210e-03, 5.7432131e-04, 1.3035190e-04, 1.8972558e-04, 9.9749216e-05, 4.4300164e-05, 3.5523078e-05,
 5.2620509e-05, 6.3254314e-05, 9.5744973e-06, 8.6928380e-06, 6.3224673e-05, 4.7904929e-05, 1.2675738e-05, 8.3095248e-06,
 7.1960528e+00, 8.6611838e+00, 2.2164145e+00, 5.9635631e-01, 1.7256565e+00, 1.2308600e+00, 3.7105904e-01, 3.5272873e-01,
 2.3892156e-01, 3.8963804e-01, 4.0033711e-02, 4.3088757e-02, 3.2855423e-01, 3.3773146e-01, 6.0660109e-02, 4.7140959e-02,
 3.6557774e-03, 3.9066831e-03, 1.4975499e-03, 2.0045638e-04, 4.8973253e-04, 3.1014051e-04, 1.4005301e-04, 6.6232915e-05,
 1.5799362e-04, 2.2876557e-04, 3.5209100e-05, 1.8852827e-05, 1.5615152e-04, 1.4251348e-04, 3.8343097e-05, 1.4824024e-05,
 9.0944783e-07, 2.0405861e-06, 1.3570550e-07, 3.1061934e-08, 3.8412001e-08, 5.1075811e-08, 4.0014614e-09, 3.2358806e-09,
 7.0471643e-09, 2.1424689e-08, 5.7206821e-10, 5.2379587e-10, 4.4835188e-09, 8.5916718e-09, 4.0103122e-10, 2.6512429e-10,
 5.2097553e-07, 6.1100539e-07, 8.3636230e-08, 2.0381797e-08, 2.0831489e-08, 1.4478365e-08, 2.3346926e-09, 2.0101126e-09,
 3.2895645e-09, 5.2274399e-09, 2.8729589e-10, 2.8006613e-10, 4.3940695e-09, 4.4012526e-09, 4.2284726e-10, 2.9762673e-10,
 1.5907862e-02, 2.5311036e-02, 2.3517885e-03, 6.7942023e-04, 1.3805637e-03, 1.3017454e-03, 1.4248706e-04, 1.4543134e-04,
 1.0882945e-04, 2.3462155e-04, 8.7527984e-06, 1.0115106e-05, 1.6637770e-04, 2.2608669e-04, 1.4744201e-05, 1.2302741e-05,
 3.8911792e-07, 5.4969931e-07, 7.6509053e-08, 1.0996050e-08, 1.8864485e-08, 1.5792843e-08, 2.5894564e-09, 1.3148479e-09,
 3.4650915e-09, 6.6325678e-09, 3.7064665e-10, 2.1309199e-10, 3.8073112e-09, 4.5935016e-09, 4.4873446e-10, 1.8627472e-10,
 4.1614899e-04, 8.9397726e-04, 9.0140499e-05, 2.2254735e-05, 5.4693985e-05, 6.9628749e-05, 8.2707149e-06, 7.2142020e-06,
 9.8139807e-06, 2.8565771e-05, 1.1564592e-06, 1.1421316e-06, 6.9627089e-06, 1.2774307e-05, 9.0404254e-07, 6.4466160e-07,
 4.4280762e-05, 4.9721441e-05, 1.0319156e-05, 2.7124593e-06, 5.5096023e-06, 3.6662316e-06, 8.9635752e-07, 8.3242174e-07,
 8.5093500e-07, 1.2946357e-06, 1.0787954e-07, 1.1343358e-07, 1.2675154e-06, 1.2155226e-06, 1.7706044e-07, 1.3442537e-07,
 2.9582933e-01, 4.5065099e-01, 6.3486296e-02, 1.9782958e-02, 7.9889232e-02, 7.2120469e-02, 1.1969018e-02, 1.3176899e-02,
 6.1593681e-03, 1.2713302e-02, 7.1909854e-04, 8.9636237e-04, 1.0500580e-02, 1.3661355e-02, 1.3508001e-03, 1.2157461e-03,
 1.2199313e-04, 1.6499845e-04, 3.4819202e-05, 5.3977679e-06, 1.8403539e-05, 1.4750854e-05, 3.6670488e-06, 2.0084217e-06,
 3.3061997e-06, 6.0589394e-06, 5.1336490e-07, 3.1835005e-07, 4.0509897e-06, 4.6793680e-06, 6.9308065e-07, 3.1032705e-07,
 4.7112950e-05, 6.1499353e-05, 5.2903902e-06, 9.5607534e-07, 1.3937445e-06, 1.0781638e-06, 1.0926032e-07, 6.9760562e-08,
 2.2508542e-07, 3.9810765e-07, 1.3750173e-08, 9.9402256e-09, 3.6075109e-07, 4.0217897e-07, 2.4282547e-08, 1.2674750e-08,
 3.1792892e-07, 2.1692567e-07, 3.8409142e-08, 7.3902010e-09, 8.9040390e-09, 3.6003034e-09, 7.5097190e-10, 5.1049108e-10,
 1.2377179e-09, 1.1442620e-09, 8.1346677e-11, 6.2610180e-11, 4.1649121e-09, 2.4269914e-09, 3.0161289e-10, 1.6761462e-10,
 1.5661778e-01, 1.4497490e-01, 1.7424299e-02, 3.9743772e-03, 9.5200636e-03, 5.2223083e-03, 7.3941080e-04, 5.9585783e-04,
 6.6061175e-04, 8.2855428e-04, 3.9982883e-05, 3.6481400e-05, 2.5441951e-03, 2.0113319e-03, 1.6966964e-04, 1.1177858e-04,
 3.1213173e-07, 2.5652818e-07, 4.6184562e-08, 5.2407641e-09, 1.0598775e-08, 5.1620701e-09, 1.0948301e-09, 4.3892188e-10,
 1.7137287e-09, 1.9083669e-09, 1.3794776e-10, 6.2617495e-11, 4.7435256e-09, 3.3295069e-09, 4.2072637e-10, 1.3789165e-10,
 7.7444391e-03, 1.3954631e-02, 2.2666404e-03, 5.9399712e-04, 5.4828678e-04, 5.8547342e-04, 1.1202954e-04, 1.0372345e-04,
 1.9287374e-04, 4.7089502e-04, 3.0709974e-05, 3.2193203e-05, 9.3827599e-05, 1.4439112e-04, 1.6461249e-05, 1.2459629e-05,
 3.6183363e-04, 3.4079072e-04, 1.1393551e-04, 3.1789057e-05, 2.4251610e-05, 1.3536007e-05, 5.3311752e-06, 5.2551410e-06,
 7.3430460e-06, 9.3708340e-06, 1.2578827e-06, 1.4039194e-06, 7.4999428e-06, 6.0327926e-06, 1.4156233e-06, 1.1407926e-06,
 5.1058555e+00, 6.5240641e+00, 1.4805676e+00, 4.8971024e-01, 7.4274926e-01, 5.6242296e-01, 1.5036048e-01, 1.7570636e-01,
 1.1226637e-01, 1.9436695e-01, 1.7710196e-02, 2.3432443e-02, 1.3123564e-01, 1.4321311e-01, 2.2811329e-02, 2.1792249e-02,
 1.2953374e-03, 1.4695288e-03, 4.9955988e-04, 8.2201963e-05, 1.0526291e-04, 7.0768784e-05, 2.8340806e-05, 1.6475919e-05,
 3.7073419e-05, 5.6987664e-05, 7.7782364e-06, 5.1198714e-06, 3.1147248e-05, 3.0178402e-05, 7.2005182e-06, 3.4221489e-06,
 1.0796194e-06, 2.5716653e-06, 1.5166784e-07, 4.2675664e-08, 2.7661328e-08, 3.9047029e-08, 2.7128619e-09, 2.6968550e-09,
 5.5402242e-09, 1.7881086e-08, 4.2341267e-10, 4.7657809e-10, 2.9962775e-09, 6.0954719e-09, 2.5231569e-10, 2.0505562e-10,
 2.9604970e-07, 3.6860321e-07, 4.4745062e-08, 1.3404449e-08, 7.1809393e-09, 5.2984269e-09, 7.5769299e-10, 8.0193708e-10,
 1.2379583e-09, 2.0884464e-09, 1.0178879e-10, 1.2197958e-10, 1.4056739e-09, 1.4947221e-09, 1.2735158e-10, 1.1019163e-10,
 3.0439121e-02, 5.1415905e-02, 4.2366449e-03, 1.5045904e-03, 1.6024712e-03, 1.6040833e-03, 1.5570849e-04, 1.9536710e-04,
 1.3790718e-04, 3.1562795e-04, 1.0442172e-05, 1.4834412e-05, 1.7921982e-04, 2.5854309e-04, 1.4952547e-05, 1.5337406e-05,
 3.7181801e-07, 5.5762384e-07, 6.8828034e-08, 1.2160327e-08, 1.0934724e-08, 9.7182870e-09, 1.4131057e-09, 8.8205851e-10,
 2.1927257e-09, 4.4557184e-09, 2.2081715e-10, 1.5606151e-10, 2.0480381e-09, 2.6231927e-09, 2.2725432e-10, 1.1596653e-10,
 1.0555532e-04, 2.4072691e-04, 2.1525565e-05, 6.5330050e-06, 8.4155866e-06, 1.1373660e-05, 1.1980941e-06, 1.2846720e-06,
 1.6485301e-06, 5.0940634e-06, 1.8288797e-07, 2.2203777e-07, 9.9421403e-07, 1.9364482e-06, 1.2153290e-07, 1.0653509e-07,
 5.3765217e-06, 6.4090924e-06, 1.1795964e-06, 3.8116122e-07, 4.0580730e-07, 2.8667268e-07, 6.2156113e-08, 7.0958136e-08,
 6.8423072e-08, 1.1051487e-07, 8.1667342e-09, 1.0556186e-08, 8.6638200e-08, 8.8203605e-08, 1.1394126e-08, 1.0634009e-08,
 1.2094849e-01, 1.9559901e-01, 2.4436683e-02, 9.3607319e-03, 1.9813484e-02, 1.8988819e-02, 2.7946954e-03, 3.7822053e-03,
 1.6676908e-03, 3.6543037e-03, 1.8330355e-04, 2.8088083e-04, 2.4168109e-03, 3.3380283e-03, 2.9270068e-04, 3.2384101e-04,
 2.4907121e-05, 3.5763086e-05, 6.6928358e-06, 1.2754438e-06, 2.2793077e-06, 1.9394806e-06, 4.2758381e-07, 2.8788270e-07,
 4.4703057e-07, 8.6970468e-07, 6.5348786e-08, 4.9816390e-08, 4.6560694e-07, 5.7096872e-07, 7.4997253e-08, 4.1279768e-08,
 2.8878073e-05, 4.0018914e-05, 3.0529426e-06, 6.7823334e-07, 5.1823237e-07, 4.2559134e-07, 3.8247828e-08, 3.0019981e-08,
 9.1368270e-08, 1.7155968e-07, 5.2548375e-09, 4.6698554e-09, 1.2448178e-07, 1.4732768e-07, 7.8885179e-09, 5.0617023e-09,
 9.3285188e-08, 6.7570966e-08, 1.0610117e-08, 2.5095624e-09, 1.5848308e-09, 6.8030203e-10, 1.2584120e-10, 1.0515823e-10,
 2.4050493e-10, 2.3604499e-10, 1.4881466e-11, 1.4080130e-11, 6.8795263e-10, 4.2558635e-10, 4.6903554e-11, 3.2042308e-11,
 1.5473788e-01, 1.5206005e-01, 1.6207422e-02, 4.5444768e-03, 5.7056982e-03, 3.3227563e-03, 4.1721334e-04, 4.1330520e-04,
 4.3223710e-04, 5.7552444e-04, 2.4629364e-05, 2.7625259e-05, 1.4150656e-03, 1.1876172e-03, 8.8845005e-05, 7.1952123e-05,
 1.5400070e-07, 1.3436512e-07, 2.1452834e-08, 2.9925272e-09, 3.1721487e-09, 1.6401692e-09, 3.0849482e-10, 1.5203528e-10,
 5.5994649e-10, 6.6196266e-10, 4.2434825e-11, 2.3678794e-11, 1.3175160e-09, 9.8175118e-10, 1.1001646e-10, 4.4325323e-11,
 1.9657292e-02, 3.5895789e-02, 9.0880154e-03, 1.9033018e-03, 1.6959648e-03, 1.8353028e-03, 5.4738645e-04, 4.0501925e-04,
 8.1502384e-04, 2.0165691e-03, 2.0498847e-04, 1.7173214e-04, 2.8266886e-04, 4.4083836e-04, 7.8336259e-05, 4.7385090e-05,
 1.1312461e-03, 1.0797612e-03, 5.6267833e-04, 1.2546304e-04, 9.2398360e-05, 5.2264396e-05, 3.2084790e-05, 2.5275384e-05,
 3.8219797e-05, 4.9428999e-05, 1.0342014e-05, 9.2245282e-06, 2.7830434e-05, 2.2686729e-05, 8.2977868e-06, 5.3439012e-06,
 8.6174043e+00, 1.1158807e+01, 3.9471994e+00, 1.0433665e+00, 1.5276544e+00, 1.1722972e+00, 4.8850588e-01, 4.5620555e-01,
 3.1544339e-01, 5.5345936e-01, 7.8604544e-02, 8.3114890e-02, 2.6288934e-01, 2.9073402e-01, 7.2181337e-02, 5.5107821e-02,
 5.1930607e-03, 5.9704909e-03, 3.1635939e-03, 4.1601824e-04, 5.1426990e-04, 3.5038781e-04, 2.1871592e-04, 1.0161433e-04,
 2.4743827e-04, 3.8545748e-04, 8.2004536e-05, 4.3137284e-05, 1.4820871e-04, 1.4552631e-04, 5.4121548e-05, 2.0556180e-05,
 2.3743530e-06, 5.7316650e-06, 5.2689094e-07, 1.1847992e-07, 7.4134957e-08, 1.0605461e-07, 1.1484986e-08, 9.1242527e-09,
 2.0284566e-08, 6.6347445e-08, 2.4488083e-09, 2.2027354e-09, 7.8211426e-09, 1.6124533e-08, 1.0403634e-09, 6.7569334e-10,
 8.0196277e-07, 1.0119063e-06, 1.9146405e-07, 4.5838248e-08, 2.3705322e-08, 1.7725684e-08, 3.9510355e-09, 3.3419097e-09,
 5.5828886e-09, 9.5448260e-09, 7.2511318e-10, 6.9443275e-10, 4.5194691e-09, 4.8702922e-09, 6.4678488e-10, 4.4724097e-10,
 4.4512403e-02, 7.6197022e-02, 9.7864154e-03, 2.7775169e-03, 2.8557136e-03, 2.8969616e-03, 4.3831774e-04, 4.3950648e-04,
 3.3573748e-04, 7.7871741e-04, 4.0156519e-05, 4.5590327e-05, 3.1106302e-04, 4.5476467e-04, 4.0994949e-05, 3.3605009e-05,
 1.2915526e-06, 1.9629721e-06, 3.7765865e-07, 5.3323225e-08, 4.6287577e-08, 4.1690588e-08, 9.4489579e-09, 4.7135025e-09,
 1.2680296e-08, 2.6112874e-08, 2.0171141e-09, 1.1392810e-09, 8.4437051e-09, 1.0960158e-08, 1.4799935e-09, 6.0355551e-10,
 1.2544477e-04, 2.8992709e-04, 4.0409161e-05, 9.8011099e-06, 1.2187997e-05, 1.6693201e-05, 2.7408893e-06, 2.3487124e-06,
 3.2616201e-06, 1.0213915e-05, 5.7157607e-07, 5.5456522e-07, 1.4023808e-06, 2.7681111e-06, 2.7078987e-07, 1.8970054e-07,
 7.8702521e-06, 9.5076999e-06, 2.7275529e-06, 7.0434541e-07, 7.2390633e-07, 5.1825116e-07, 1.7514559e-07, 1.5979179e-07,
 1.6674534e-07, 2.7293748e-07, 3.1437809e-08, 3.2474897e-08, 1.5052557e-07, 1.5530252e-07, 3.1270478e-08, 2.3323157e-08,
 9.5575636e-02, 1.5664079e-01, 3.0502940e-02, 9.3378386e-03, 1.9080194e-02, 1.8531553e-02, 4.2511758e-03, 4.5978720e-03,
 2.1939473e-03, 4.8719925e-03, 3.8092038e-04, 4.6646848e-04, 2.2667462e-03, 3.1727953e-03, 4.3364735e-04, 3.8342626e-04,
 4.6752306e-05, 6.8030851e-05, 1.9844578e-05, 3.0222503e-06, 5.2138374e-06, 4.4960539e-06, 1.5450001e-06, 8.3130372e-07,
 1.3969483e-06, 2.7542684e-06, 3.2257688e-07, 1.9651920e-07, 1.0373189e-06, 1.2891299e-06, 2.6393130e-07, 1.1609665e-07,
 6.5736582e-05, 9.2320026e-05, 1.0977672e-05, 1.9489816e-06, 1.4376024e-06, 1.1964611e-06, 1.6759984e-07, 1.0512704e-07,
 3.4625663e-07, 6.5888502e-07, 3.1456812e-08, 2.2340659e-08, 3.3632428e-07, 4.0339294e-07, 3.3666703e-08, 1.7263893e-08,
 2.6155698e-07, 1.9200190e-07, 4.6992309e-08, 8.8826305e-09, 5.4151670e-09, 2.3557121e-09, 6.7921045e-10, 4.5358847e-10,
 1.1226432e-09, 1.1166163e-09, 1.0972764e-10, 8.2968634e-11, 2.2894216e-09, 1.4353124e-09, 2.4656177e-10, 1.3461109e-10,
 2.3421246e-01, 2.3324901e-01, 3.8750737e-02, 8.6833406e-03, 1.0524398e-02, 6.2112450e-03, 1.2156241e-03, 9.6238551e-04,
 1.0891791e-03, 1.4697112e-03, 9.8035289e-05, 8.7876573e-05, 2.5421618e-03, 2.1621946e-03, 2.5212316e-04, 1.6317745e-04,
 5.5369213e-07, 4.8957978e-07, 1.2183811e-07, 1.3582315e-08, 1.3898716e-08, 7.2828469e-09, 2.1351158e-09, 8.4092022e-10,
 3.3516308e-09, 4.0154528e-09, 4.0122186e-10, 1.7891992e-10, 5.6223158e-09, 4.2457290e-09, 7.4159988e-10, 2.3878154e-10,
 2.3168664e-01, 3.1699076e-01, 1.3247671e-01, 2.9065038e-02, 2.4482924e-02, 1.9850891e-02, 9.7731348e-03, 7.5754429e-03,
 1.6183249e-02, 3.0000902e-02, 5.0340551e-03, 4.4180706e-03, 6.5713687e-03, 7.6786172e-03, 2.2523396e-03, 1.4272685e-03,
 1.0288603e+00, 7.3578826e-01, 6.3292560e-01, 1.4784302e-01, 1.0292782e-01, 4.3621485e-02, 4.4203947e-02, 3.6479770e-02,
 5.8560630e-02, 5.6744654e-02, 1.9598176e-02, 1.8312486e-02, 4.9925195e-02, 3.0492827e-02, 1.8410071e-02, 1.2420644e-02,
 3.0794886e+01, 2.9877612e+01, 1.7445536e+01, 4.8308651e+00, 6.6864684e+00, 3.8444576e+00, 2.6444442e+00, 2.5871293e+00,
 1.8990732e+00, 2.4965022e+00, 5.8527659e-01, 6.4831366e-01, 1.8530019e+00, 1.5354111e+00, 6.2924687e-01, 5.0327119e-01,
 5.7878533e-01, 4.9857458e-01, 4.3608204e-01, 6.0074793e-02, 7.0202824e-02, 3.5837551e-02, 3.6926428e-02, 1.7972329e-02,
 4.6459987e-02, 5.4226880e-02, 1.9043358e-02, 1.0494245e-02, 3.2581299e-02, 2.3969704e-02, 1.4714939e-02, 5.8549533e-03,
 4.0575472e-05, 7.3387955e-05, 1.1136078e-05, 2.6233058e-06, 1.5517097e-06, 1.6631950e-06, 2.9731113e-07, 2.4744048e-07,
 5.8398556e-07, 1.4311538e-06, 8.7193526e-08, 8.2164521e-08, 2.6362658e-07, 4.0722261e-07, 4.3370778e-08, 2.9508997e-08,
 1.0575338e-03, 9.9978431e-04, 3.1226306e-04, 7.8316627e-05, 3.8287357e-05, 2.1450559e-05, 7.8924833e-06, 6.9934280e-06,
 1.2402730e-05, 1.5887384e-05, 1.9923122e-06, 1.9988224e-06, 1.1755157e-05, 9.4912170e-06, 2.0806260e-06, 1.5071900e-06,
 2.3063453e-01, 2.9580613e-01, 6.2713360e-02, 1.8646008e-02, 1.8122876e-02, 1.3774668e-02, 3.4402893e-03, 3.6137972e-03,
 2.9306302e-03, 5.0929224e-03, 4.3352163e-04, 5.1560827e-04, 3.1790132e-03, 3.4822227e-03, 5.1816412e-04, 4.4497315e-04,
 2.0871196e-04, 2.3767055e-04, 7.5479304e-05, 1.1164456e-05, 9.1615529e-06, 6.1825642e-06, 2.3130319e-06, 1.2087439e-06,
 3.4520958e-06, 5.3264024e-06, 6.7916796e-07, 4.0185576e-07, 2.6913421e-06, 2.6174513e-06, 5.8343028e-07, 2.4925229e-07,
 1.0055850e-02, 1.7413288e-02, 4.0062601e-03, 1.0179521e-03, 1.1966518e-03, 1.2280079e-03, 3.3282829e-04, 2.9877984e-04,
 4.4047108e-04, 1.0334804e-03, 9.5466651e-05, 9.7033829e-05, 2.2173421e-04, 3.2792631e-04, 5.2953256e-05, 3.8861653e-05,
 4.8682938e-02, 4.4064563e-02, 2.0866751e-02, 5.6449437e-03, 5.4845368e-03, 2.9418727e-03, 1.6411562e-03, 1.5685479e-03,
 1.7376407e-03, 2.1310592e-03, 4.0518341e-04, 4.3847037e-04, 1.8365350e-03, 1.4196898e-03, 4.7186369e-04, 3.6869066e-04,
 2.3229428e+00, 2.8524765e+00, 9.1690869e-01, 2.9405147e-01, 5.6799383e-01, 4.1333108e-01, 1.5651752e-01, 1.7733863e-01,
 8.9832895e-02, 1.4946586e-01, 1.9290200e-02, 2.4746716e-02, 1.0866627e-01, 1.1396195e-01, 2.5711172e-02, 2.3815501e-02,
 3.5439395e-02, 3.8638032e-02, 1.8604524e-02, 2.9682442e-03, 4.8407214e-03, 3.1275928e-03, 1.7740851e-03, 9.9999596e-04,
 1.7839465e-03, 2.6353211e-03, 5.0948091e-04, 3.2515630e-04, 1.5509440e-03, 1.4441309e-03, 4.8805416e-04, 2.2490011e-04,
 3.3147557e-05, 3.4879172e-05, 6.8461726e-06, 1.2733220e-06, 8.8787664e-07, 5.5365383e-07, 1.2802091e-07, 8.4122867e-08,
 2.9414450e-07, 4.1937059e-07, 3.3049939e-08, 2.4589205e-08, 3.3450558e-07, 3.0060717e-07, 4.1413222e-08, 2.2246929e-08,
 1.0177306e-05, 5.5975506e-06, 2.2614474e-06, 4.4781006e-07, 2.5807607e-07, 8.4117034e-08, 4.0034414e-08, 2.8008095e-08,
 7.3591275e-08, 5.4842152e-08, 8.8959798e-09, 7.0466789e-09, 1.7570856e-07, 8.2535280e-08, 2.3403789e-08, 1.3385478e-08,
 3.5807933e-02, 2.6718699e-02, 7.3272775e-03, 1.7200546e-03, 1.9707714e-03, 8.7145139e-04, 2.8153426e-04, 2.3349313e-04,
 2.8053483e-04, 2.8362578e-04, 3.1229411e-05, 2.9325584e-05, 7.6660824e-04, 4.8852970e-04, 9.4032093e-05, 6.3755300e-05,
 2.6401574e-06, 1.7490851e-06, 7.1851827e-07, 8.3911439e-08, 8.1171853e-08, 3.1868229e-08, 1.5422173e-08, 6.3631458e-09,
 2.6923760e-08, 2.4167946e-08, 3.9861855e-09, 1.8621912e-09, 5.2878301e-08, 2.9918534e-08, 8.6263080e-09, 2.9097041e-09,
 4.0230456e-02, 5.6929807e-02, 1.4895406e-02, 2.1365183e-03, 3.6539251e-03, 3.0641886e-03, 9.4447211e-04, 4.7861497e-04,
 1.3627189e-03, 2.6128464e-03, 2.7448433e-04, 1.5749075e-04, 6.2420433e-04, 7.5438479e-04, 1.3853626e-04, 5.7392917e-05,
 2.5359567e-01, 1.8757599e-01, 1.0101754e-01, 1.5426520e-02, 2.1805219e-02, 9.5579938e-03, 6.0638381e-03, 3.2716106e-03,
 6.9996722e-03, 7.0151362e-03, 1.5168638e-03, 9.2661856e-04, 6.7316563e-03, 4.2524453e-03, 1.6073720e-03, 7.0897034e-04,
 1.4893460e+01, 1.4945191e+01, 5.4633637e+00, 9.8906188e-01, 2.7794330e+00, 1.6528503e+00, 7.1179129e-01, 4.5525948e-01,
 4.4539504e-01, 6.0558389e-01, 8.8883981e-02, 6.4368035e-02, 4.9024095e-01, 4.2014307e-01, 1.0779871e-01, 5.6366047e-02,
 8.1094511e-02, 7.2250849e-02, 3.9564064e-02, 3.5632656e-03, 8.4541709e-03, 4.4636852e-03, 2.8794694e-03, 9.1622556e-04,
 3.1567467e-03, 3.8107833e-03, 8.3784330e-04, 3.0185151e-04, 2.4972349e-03, 1.9001688e-03, 7.3031102e-04, 1.8997472e-04,
 1.4640585e-06, 2.7387902e-06, 2.6018732e-07, 4.0070580e-08, 4.8122475e-08, 5.3348166e-08, 5.9704571e-09, 3.2485529e-09,
 1.0218421e-08, 2.5900422e-08, 9.8792706e-10, 6.0862242e-10, 5.2035646e-09, 8.3134766e-09, 5.5432934e-10, 2.4657437e-10,
 5.4165252e-05, 5.2962861e-05, 1.0356327e-05, 1.6980958e-06, 1.6854822e-06, 9.7666638e-07, 2.2497861e-07, 1.3032886e-07,
 3.0805633e-07, 4.0813523e-07, 3.2042706e-08, 2.1016920e-08, 3.2936044e-07, 2.7504510e-07, 3.7748171e-08, 1.7876931e-08,
 2.3178333e-02, 3.0747078e-02, 4.0810948e-03, 7.9327836e-04, 1.5654077e-03, 1.2306096e-03, 1.9242169e-04, 1.3214349e-04,
 1.4282545e-04, 2.5671447e-04, 1.3680877e-05, 1.0637659e-05, 1.7477000e-04, 1.9800220e-04, 1.8445945e-05, 1.0355965e-05,
 6.0766208e-06, 7.1569721e-06, 1.4229886e-06, 1.3760498e-07, 2.2925897e-07, 1.6001645e-07, 3.7479842e-08, 1.2804815e-08,
 4.8739853e-08, 7.7781130e-08, 6.2092271e-09, 2.4018916e-09, 4.2864787e-08, 4.3117076e-08, 6.0169921e-09, 1.6805539e-09,
 1.0485490e-03, 1.8779750e-03, 2.7050030e-04, 4.4934405e-05, 1.0724578e-04, 1.1382885e-04, 1.9314854e-05, 1.1335620e-05,
 2.2272755e-05, 5.4050261e-05, 3.1258404e-06, 2.0771189e-06, 1.2647937e-05, 1.9346482e-05, 1.9558615e-06, 9.3840365e-07,
 7.2057306e-03, 6.7457377e-03, 1.9999297e-03, 3.5370609e-04, 6.9772378e-04, 3.8708492e-04, 1.3519241e-04, 8.4474036e-05,
 1.2472335e-04, 1.5820574e-04, 1.8832085e-05, 1.3323234e-05, 1.4870210e-04, 1.1889132e-04, 2.4739641e-05, 1.2637520e-05,
 6.7463898e-01, 8.5682821e-01, 1.7243192e-01, 3.6152461e-02, 1.4178117e-01, 1.0671170e-01, 2.5298634e-02, 1.8739585e-02,
 1.2651878e-02, 2.1772093e-02, 1.7591984e-03, 1.4754294e-03, 1.7264117e-02, 1.8726142e-02, 2.6450270e-03, 1.6017356e-03,
 2.9817823e-03, 3.3623550e-03, 1.0136009e-03, 1.0572339e-04, 3.5005960e-04, 2.3392735e-04, 8.3074040e-05, 3.0613447e-05,
 7.2787705e-05, 1.1121126e-04, 1.3460561e-05, 5.6163003e-06, 7.1384307e-05, 6.8746715e-05, 1.4545653e-05, 4.3820549e-06,
 6.4069749e-06, 6.9727887e-06, 8.5685646e-07, 1.0418887e-07, 1.4750147e-07, 9.5130779e-08, 1.3771563e-08, 5.9161562e-09,
 2.7570760e-08, 4.0656019e-08, 2.0059366e-09, 9.7569518e-10, 3.5368909e-08, 3.2874303e-08, 2.8354100e-09, 9.9579469e-10,
 2.7923211e-06, 1.5884349e-06, 4.0177036e-07, 5.2012559e-08, 6.0858716e-08, 2.0516253e-08, 6.1131830e-09, 2.7960221e-09,
 9.7914224e-09, 7.5469697e-09, 7.6642866e-10, 3.9690405e-10, 2.6371966e-08, 1.2812329e-08, 2.2745437e-09, 8.5048196e-10,
 1.9277183e-02, 1.4877100e-02, 2.5542628e-03, 3.9200181e-04, 9.1189062e-04, 4.1705049e-04, 8.4352257e-05, 4.5736429e-05,
 7.3238168e-05, 7.6583517e-05, 5.2792635e-06, 3.2410010e-06, 2.2576391e-04, 1.4880274e-04, 1.7931473e-05, 7.9483864e-06,
 4.1176641e-07, 2.8214416e-07, 7.2563433e-08, 5.5401823e-09, 1.0881007e-08, 4.4183531e-09, 1.3386524e-09, 3.6109128e-10,
 2.0363083e-09, 1.8905438e-09, 1.9521984e-10, 5.9623001e-11, 4.5114440e-09, 2.6400808e-09, 4.7656467e-10, 1.0509170e-10,
 8.2847698e-03, 1.2446060e-02, 2.8878934e-03, 5.0920345e-04, 4.5645571e-04, 4.0636968e-04, 1.1107889e-04, 6.9196511e-05,
 1.8584546e-04, 3.7829119e-04, 3.5242462e-05, 2.4857641e-05, 7.2363997e-05, 9.2844330e-05, 1.5120373e-05, 7.7003993e-06,
 2.4998954e-02, 1.9630171e-02, 9.3751931e-03, 1.7599787e-03, 1.3039298e-03, 6.0677484e-04, 3.4138511e-04, 2.2641991e-04,
 4.5695991e-04, 4.8618677e-04, 9.3228813e-05, 7.0010052e-05, 3.7357044e-04, 2.5052783e-04, 8.3978879e-05, 4.5534222e-05,
 4.9436641e+00, 5.2664965e+00, 1.7073274e+00, 3.7995845e-01, 5.5965830e-01, 3.5331907e-01, 1.3493439e-01, 1.0609257e-01,
 9.7908138e-02, 1.4132358e-01, 1.8395019e-02, 1.6375815e-02, 9.1607951e-02, 8.3346564e-02, 1.8964464e-02, 1.2189915e-02,
 1.3442301e-02, 1.2714287e-02, 6.1742783e-03, 6.8358014e-04, 8.5009332e-04, 4.7649259e-04, 2.7259081e-04, 1.0662454e-04,
 3.4653104e-04, 4.4410257e-04, 8.6590134e-05, 3.8349077e-05, 2.3302995e-04, 1.8823984e-04, 6.4159892e-05, 2.0516704e-05,
 8.1307479e-07, 1.6147204e-06, 1.3603825e-07, 2.5754716e-08, 1.6211875e-08, 1.9079699e-08, 1.8936333e-09, 1.2665853e-09,
 3.7581638e-09, 1.0112664e-08, 3.4207372e-10, 2.5905920e-10, 1.6268334e-09, 2.7592535e-09, 1.6315979e-10, 8.9217344e-11,
 1.4399492e-05, 1.4947377e-05, 2.5920029e-06, 5.2245367e-07, 2.7180916e-07, 1.6720640e-07, 3.4157359e-08, 2.4324266e-08,
 5.4234674e-08, 7.6281214e-08, 5.3110312e-09, 4.2822784e-09, 4.9291067e-08, 4.3698600e-08, 5.3185825e-09, 3.0963414e-09,
 2.0748271e-02, 2.9219338e-02, 3.4393755e-03, 8.2183490e-04, 8.5004242e-04, 7.0941463e-04, 9.8371678e-05, 8.3045866e-05,
 8.4669199e-05, 1.6156111e-04, 7.6354904e-06, 7.2983578e-06, 8.8071793e-05, 1.0592706e-04, 8.7513295e-06, 6.0397577e-06,
 2.7163814e-06, 3.3964448e-06, 5.9887101e-07, 7.1190465e-08, 6.2168209e-08, 4.6065234e-08, 9.5684779e-09, 4.0185965e-09,
 1.4428884e-08, 2.4444973e-08, 1.7305699e-09, 8.2292673e-10, 1.0786966e-08, 1.1518999e-08, 1.4255465e-09, 4.8945278e-10,
 1.2442257e-04, 2.3657400e-04, 3.0219098e-05, 6.1709025e-06, 7.7197661e-06, 8.6984685e-06, 1.3089364e-06, 9.4434019e-07,
 1.7502682e-06, 4.5091576e-06, 2.3126008e-07, 1.8890831e-07, 8.4489009e-07, 1.3719857e-06, 1.2300479e-07, 7.2548716e-08,
 4.0930132e-04, 4.0678185e-04, 1.0695059e-04, 2.3252369e-05, 2.4041539e-05, 1.4159625e-05, 4.3856520e-06, 3.3686907e-06,
 4.6917309e-06, 6.3179264e-06, 6.6694007e-07, 5.8003507e-07, 4.7550258e-06, 4.0360136e-06, 7.4478690e-07, 4.6768845e-07,
 1.2903566e-01, 1.7397978e-01, 3.1049823e-02, 8.0026804e-03, 1.6450174e-02, 1.3144099e-02, 2.7634520e-03, 2.5163505e-03,
 1.6025571e-03, 2.9276928e-03, 2.0978601e-04, 2.1628989e-04, 1.8588876e-03, 2.1405419e-03, 2.6812790e-04, 1.9959926e-04,
 2.8480214e-04, 3.4093987e-04, 9.1145899e-05, 1.1686851e-05, 2.0282561e-05, 1.4388931e-05, 4.5315742e-06, 2.0528260e-06,
 4.6041080e-06, 7.4679776e-06, 8.0159244e-07, 4.1114675e-07, 3.8383115e-06, 3.9242464e-06, 7.3633251e-07, 2.7269337e-07,
 1.8372153e-06, 2.1226585e-06, 2.3132269e-07, 3.4577019e-08, 2.5657640e-08, 1.7567426e-08, 2.2553130e-09, 1.1910200e-09,
 5.2357131e-09, 8.1963178e-09, 3.5863081e-10, 2.1443737e-10, 5.7095112e-09, 5.6337882e-09, 4.3091964e-10, 1.8603995e-10,
 3.8328953e-07, 2.3147170e-07, 5.1920976e-08, 8.2628315e-09, 5.0675466e-09, 1.8135927e-09, 4.7923157e-10, 2.6944787e-10,
 8.9007623e-10, 7.2831807e-10, 6.5592874e-11, 4.1756720e-11, 2.0378604e-09, 1.0510583e-09, 1.6547384e-10, 7.6059999e-11,
 8.9100128e-03, 7.2999531e-03, 1.1114850e-03, 2.0969210e-04, 2.5567660e-04, 1.2413773e-04, 2.2266305e-05, 1.4841224e-05,
 2.2417774e-05, 2.4886114e-05, 1.5213577e-06, 1.1481361e-06, 5.8743469e-05, 4.1103874e-05, 4.3926263e-06, 2.3935550e-06,
 9.5041773e-08, 6.9135581e-08, 1.5768282e-08, 1.4799500e-09, 1.5235123e-09, 6.5675665e-10, 1.7646080e-10, 5.8513152e-11,
 3.1126287e-10, 3.0678720e-10, 2.8093836e-11, 1.0547682e-11, 5.8620482e-10, 3.6418159e-10, 5.8298707e-11, 1.5803810e-11,
 2.3872539e-02, 3.6344718e-02, 1.3144728e-02, 1.8522477e-03, 1.6028464e-03, 1.4461253e-03, 6.1613655e-04, 3.0673777e-04,
 8.9152510e-04, 1.8390749e-03, 2.6705482e-04, 1.5053287e-04, 2.4748788e-04, 3.2179426e-04, 8.1685806e-05, 3.3245612e-05,
 8.8726756e-02, 7.0607092e-02, 5.2561226e-02, 7.8855076e-03, 5.6397784e-03, 2.6596645e-03, 2.3324098e-03, 1.2362658e-03,
 2.7000660e-03, 2.9113263e-03, 8.7015961e-04, 5.2221171e-04, 1.5736874e-03, 1.0695309e-03, 5.5881582e-04, 2.4214395e-04,
 9.4719859e+00, 1.0225994e+01, 5.1672723e+00, 9.1900507e-01, 1.3067436e+00, 8.3603790e-01, 4.9767137e-01, 3.1271021e-01,
 3.1230195e-01, 4.5683768e-01, 9.2684837e-02, 6.5939953e-02, 2.0832380e-01, 1.9208121e-01, 6.8123759e-02, 3.4994155e-02,
 6.1178425e-02, 5.8641902e-02, 4.4387787e-02, 3.9273864e-03, 4.7148341e-03, 2.6782275e-03, 2.3881615e-03, 7.4652867e-04,
 2.6256107e-03, 3.4100692e-03, 1.0363566e-03, 3.6680303e-04, 1.2587799e-03, 1.0304835e-03, 5.4746246e-04, 1.3990564e-04,
 2.0299678e-06, 4.0855237e-06, 5.3650345e-07, 8.1171816e-08, 4.9325046e-08, 5.8829730e-08, 9.1008657e-09, 4.8647253e-09,
 1.5620621e-08, 4.2597069e-08, 2.2459242e-09, 1.3592879e-09, 4.8207591e-09, 8.2862027e-09, 7.6372695e-10, 3.3374234e-10,
 4.4281332e-05, 4.6583283e-05, 1.2591039e-05, 2.0282019e-06, 1.0186218e-06, 6.3502866e-07, 2.0220214e-07, 1.1507427e-07,
 2.7766059e-07, 3.9577318e-07, 4.2950578e-08, 2.7675916e-08, 1.7991005e-07, 1.6163901e-07, 3.0664489e-08, 1.4266778e-08,
 3.4444108e-02, 4.9158090e-02, 9.0191413e-03, 1.7222939e-03, 1.7196849e-03, 1.4544545e-03, 3.1436281e-04, 2.1208803e-04,
 2.3400354e-04, 4.5250691e-04, 3.3333926e-05, 2.5463123e-05, 1.7353362e-04, 2.1151690e-04, 2.7237884e-05, 1.5022970e-05,
 1.0711642e-05, 1.3573179e-05, 3.7303663e-06, 3.5438645e-07, 2.9875079e-07, 2.2433945e-07, 7.2633395e-08, 2.4378391e-08,
 9.4724524e-08, 1.6263370e-07, 1.7946149e-08, 6.8199344e-09, 5.0486865e-08, 5.4636813e-08, 1.0539334e-08, 2.8918745e-09,
 1.6786341e-04, 3.2345606e-04, 6.4400750e-05, 1.0509816e-05, 1.2692179e-05, 1.4493267e-05, 3.3994064e-06, 1.9599739e-06,
 3.9311996e-06, 1.0263777e-05, 8.2049108e-07, 5.3562574e-07, 1.3529156e-06, 2.2264422e-06, 3.1113223e-07, 1.4665258e-07,
 6.8016574e-04, 6.8505367e-04, 2.8074187e-04, 4.8778477e-05, 4.8686543e-05, 2.9059613e-05, 1.4029216e-05, 8.6118692e-06,
 1.2979809e-05, 1.7713365e-05, 2.9145703e-06, 2.0257186e-06, 9.3785909e-06, 8.0673188e-06, 2.3204365e-06, 1.1644780e-06,
 1.1575527e-01, 1.5816904e-01, 4.3999006e-02, 9.0626706e-03, 1.7983603e-02, 1.4562253e-02, 4.7721143e-03, 3.4726981e-03,
 2.3933611e-03, 4.4311035e-03, 4.9490755e-04, 4.0777516e-04, 1.9792368e-03, 2.3097227e-03, 4.5096123e-04, 2.6828296e-04,
 6.0688527e-04, 7.3626251e-04, 3.0679871e-04, 3.1437687e-05, 5.2669775e-05, 3.7866808e-05, 1.8588338e-05, 6.7294665e-06,
 1.6333260e-05, 2.6848601e-05, 4.4919330e-06, 1.8412549e-06, 9.7077203e-06, 1.0058304e-05, 2.9417346e-06, 8.7064510e-07,
 4.7476990e-06, 5.5589777e-06, 9.4426532e-07, 1.1279781e-07, 8.0800692e-08, 5.6065815e-08, 1.1219102e-08, 4.7348604e-09,
 2.2524890e-08, 3.5735285e-08, 2.4371771e-09, 1.1646007e-09, 1.7511996e-08, 1.7511722e-08, 2.0877852e-09, 7.2033202e-10,
 1.2200145e-06, 7.4666760e-07, 2.6105577e-07, 3.3201414e-08, 1.9656714e-08, 7.1292629e-09, 2.9363729e-09, 1.3194032e-09,
 4.7166004e-09, 3.9112384e-09, 5.4904896e-10, 2.7933010e-10, 7.6988451e-09, 4.0241070e-09, 9.8749152e-10, 3.6274161e-10,
 1.5310017e-02, 1.2711853e-02, 3.0168502e-03, 4.5485132e-04, 5.3538209e-04, 2.6343166e-04, 7.3650138e-05, 3.9231232e-05,
 6.4128877e-05, 7.2145579e-05, 6.8745630e-06, 4.1461434e-06, 1.1980377e-04, 8.4954267e-05, 1.4151019e-05, 6.1623136e-06,
 3.8792215e-07, 2.8597167e-07, 1.0166397e-07, 7.6254677e-09, 7.5779448e-09, 3.3105553e-09, 1.3864555e-09, 3.6740776e-10,
 2.1150503e-09, 2.1126250e-09, 3.0154863e-10, 9.0477385e-11, 2.8398324e-09, 1.7879399e-09, 4.4612340e-10, 9.6648459e-11,
 7.6489932e+00, 1.2383959e+01, 5.4498946e+00, 2.2806771e+00, 3.9520081e+00, 3.7917898e+00, 1.9657754e+00, 2.9063807e+00,
 3.3741813e+00, 7.4019572e+00, 1.3078742e+00, 2.1894002e+00, 1.6935503e+00, 2.3417191e+00, 7.2330481e-01, 8.7425420e-01,
 1.3092332e+01, 1.1079567e+01, 1.0035947e+01, 4.4714773e+00, 6.4038999e+00, 3.2116013e+00, 3.4270321e+00, 5.3945316e+00,
 4.7061487e+00, 5.3962804e+00, 1.9625504e+00, 3.4978158e+00, 4.9592857e+00, 3.5843172e+00, 2.2787674e+00, 2.9324692e+00,
 9.6319545e+01, 1.1058372e+02, 6.7993187e+01, 3.5912903e+01, 1.0225481e+02, 6.9571535e+01, 5.0392641e+01, 9.4036158e+01,
 3.7512581e+01, 5.8354794e+01, 1.4405942e+01, 3.0437582e+01, 4.5242902e+01, 4.4361767e+01, 1.9144367e+01, 2.9205627e+01,
 2.9831609e+00, 3.0408755e+00, 2.8007379e+00, 7.3593810e-01, 1.7691522e+00, 1.0687063e+00, 1.1595596e+00, 1.0764768e+00,
 1.5122996e+00, 2.0887332e+00, 7.7240930e-01, 8.1189489e-01, 1.3108903e+00, 1.1412219e+00, 7.3773754e-01, 5.5990075e-01,
 1.3171435e-02, 2.8190582e-02, 4.5045073e-03, 2.0239904e-03, 2.4628132e-03, 3.1237309e-03, 5.8800049e-04, 9.3343011e-04,
 1.1972131e-03, 3.4718835e-03, 2.2274043e-04, 4.0035343e-04, 6.6803295e-04, 1.2210973e-03, 1.3694660e-04, 1.7772681e-04,
 1.3231866e-01, 1.4802760e-01, 4.8684717e-02, 2.3290076e-02, 2.3422521e-02, 1.5528391e-02, 6.0164100e-03, 1.0168528e-02,
 9.8003971e-03, 1.4855534e-02, 1.9616843e-03, 3.7539686e-03, 1.1481385e-02, 1.0969763e-02, 2.5322426e-03, 3.4988380e-03,
 7.0929416e+00, 1.0765114e+01, 2.4032969e+00, 1.3629438e+00, 2.7250896e+00, 2.4510046e+00, 6.4460522e-01, 1.2915380e+00,
 5.6919746e-01, 1.1705178e+00, 1.0491984e-01, 2.3801894e-01, 7.6319133e-01, 9.8925268e-01, 1.5500790e-01, 2.5390128e-01,
 1.0577259e-02, 1.4253138e-02, 4.7664913e-03, 1.3447852e-03, 2.2701062e-03, 1.8128208e-03, 7.1417431e-04, 7.1187056e-04,
 1.1048620e-03, 2.0172909e-03, 2.7086165e-04, 3.0569270e-04, 1.0647154e-03, 1.2253292e-03, 2.8760668e-04, 2.3436536e-04,
 1.1898916e+00, 2.4382540e+00, 5.9070842e-01, 2.8628989e-01, 6.9232139e-01, 8.4071837e-01, 2.3994168e-01, 4.1084801e-01,
 3.2915885e-01, 9.1390277e-01, 8.8896566e-02, 1.7234592e-01, 2.0481452e-01, 3.5843749e-01, 6.0948880e-02, 8.5317633e-02,
 2.2203560e+00, 2.3781800e+00, 1.1858942e+00, 6.1192139e-01, 1.2230302e+00, 7.7630180e-01, 4.5602890e-01, 8.3135211e-01,
 5.0050142e-01, 7.2635759e-01, 1.4542612e-01, 3.0017553e-01, 6.5385903e-01, 5.9811882e-01, 2.0933741e-01, 3.1198724e-01,
 2.6041123e+01, 3.7840132e+01, 1.2808327e+01, 7.8349129e+00, 3.1132643e+01, 2.6808972e+01, 1.0690077e+01, 2.3102855e+01,
 6.3599835e+00, 1.2521954e+01, 1.7017775e+00, 4.1641657e+00, 9.5094425e+00, 1.1801297e+01, 2.8036728e+00, 4.9534705e+00,
 6.5468251e-01, 8.4463496e-01, 4.2826081e-01, 1.3032687e-01, 4.3722607e-01, 3.3428400e-01, 1.9967126e-01, 2.1467628e-01,
 2.0812570e-01, 3.6382035e-01, 7.4065706e-02, 9.0162558e-02, 2.2365547e-01, 2.4643342e-01, 8.7699426e-02, 7.7083798e-02,
 4.3092813e-02, 5.3657301e-02, 1.1090380e-02, 3.9344251e-03, 5.6436126e-03, 4.1643997e-03, 1.0139830e-03, 1.2708913e-03,
 2.4149793e-03, 4.0743674e-03, 3.3811810e-04, 4.7982940e-04, 3.3946537e-03, 3.6099503e-03, 5.2369263e-04, 5.3660143e-04,
 5.0996805e-03, 3.3190784e-03, 1.4120235e-03, 5.3332739e-04, 6.3227999e-04, 2.4386822e-04, 1.2221946e-04, 1.6309296e-04,
 2.3288210e-04, 2.0536845e-04, 3.5079141e-05, 5.3001017e-05, 6.8729337e-04, 3.8203083e-04, 1.1407242e-04, 1.2444373e-04,
 4.4102669e+00, 3.8941294e+00, 1.1245362e+00, 5.0352099e-01, 1.1867879e+00, 6.2099733e-01, 2.1125832e-01, 3.3419564e-01,
 2.1820859e-01, 2.6105990e-01, 3.0268727e-02, 5.4215262e-02, 7.3705171e-01, 5.5580827e-01, 1.1265382e-01, 1.4569030e-01,
 5.3584437e-04, 4.2007763e-04, 1.8171556e-04, 4.0478098e-05, 8.0550049e-05, 3.7422078e-05, 1.9070023e-05, 1.5007978e-05,
 3.4509942e-05, 3.6657100e-05, 6.3666558e-06, 5.6731260e-06, 8.3777128e-05, 5.6091598e-05, 1.7030146e-05, 1.0956878e-05,
 1.5940351e+00, 2.6692671e+00, 7.3542871e-01, 2.0120531e-01, 7.0787071e-01, 7.0245627e-01, 2.2799680e-01, 2.2037903e-01,
 3.4099539e-01, 7.7368775e-01, 8.5586464e-02, 9.3667148e-02, 1.9306723e-01, 2.7611123e-01, 5.3393777e-02, 4.2191985e-02,
 3.8729483e+00, 3.3898989e+00, 1.9223927e+00, 5.5996104e-01, 1.6282161e+00, 8.4455493e-01, 5.6421470e-01, 5.8063462e-01,
 6.7511444e-01, 8.0065432e-01, 1.8230192e-01, 2.1241743e-01, 8.0252945e-01, 5.9991165e-01, 2.3878154e-01, 2.0088930e-01,
 5.5907610e+01, 6.6387528e+01, 2.5555280e+01, 8.8244716e+00, 5.1013235e+01, 3.5897955e+01, 1.6278884e+01, 1.9859839e+01,
 1.0558935e+01, 1.6988638e+01, 2.6256912e+00, 3.6268954e+00, 1.4365604e+01, 1.4568709e+01, 3.9361633e+00, 3.9257406e+00,
 5.0163763e-01, 5.2887267e-01, 3.0496135e-01, 5.2388567e-02, 2.5569426e-01, 1.5975460e-01, 1.0851949e-01, 6.5863135e-02,
 1.2332122e-01, 1.7616595e-01, 4.0785561e-02, 2.8027303e-02, 1.2058599e-01, 1.0857738e-01, 4.3943136e-02, 2.1803348e-02,
 5.7038454e-04, 1.2626345e-03, 1.2631085e-04, 3.7104346e-05, 9.1666083e-05, 1.2025123e-04, 1.4171422e-05, 1.4707560e-05,
 2.5141575e-05, 7.5409360e-05, 3.0288588e-06, 3.5591528e-06, 1.5825201e-05, 2.9918558e-05, 2.1006874e-06, 1.7823228e-06,
 8.1336800e-03, 9.4112565e-03, 1.9378383e-03, 6.0606407e-04, 1.2374912e-03, 8.4854251e-04, 2.0582800e-04, 2.2743029e-04,
 2.9214358e-04, 4.5801513e-04, 3.7865225e-05, 4.7372348e-05, 3.8607971e-04, 3.8152141e-04, 5.5137466e-05, 4.9806785e-05,
 8.5550758e-01, 1.3429356e+00, 1.8769982e-01, 6.9591660e-02, 2.8250138e-01, 2.6279858e-01, 4.3270573e-02, 5.6679874e-02,
 3.3292542e-02, 7.0811052e-02, 3.9737494e-03, 5.8935540e-03, 5.0355592e-02, 6.7508810e-02, 6.6225755e-03, 7.0918703e-03,
 3.6959621e-04, 5.1511459e-04, 1.0784806e-04, 1.9892496e-05, 6.8177800e-05, 5.6310681e-05, 1.3888647e-05, 9.0506485e-06,
 1.8721860e-05, 3.5354813e-05, 2.9719899e-06, 2.1928447e-06, 2.0351895e-05, 2.4224964e-05, 3.5598279e-06, 1.8964727e-06,
 1.4890762e-01, 3.1559305e-01, 4.7867576e-02, 1.5166916e-02, 7.4466320e-02, 9.3527980e-02, 1.6711535e-02, 1.8707468e-02,
 1.9975689e-02, 5.7363422e-02, 3.4933328e-03, 4.4277083e-03, 1.4021257e-02, 2.5379243e-02, 2.7017847e-03, 2.4725596e-03,
 3.9442405e-01, 4.3694270e-01, 1.3640977e-01, 4.6016944e-02, 1.8673268e-01, 1.2258931e-01, 4.5085250e-02, 5.3734088e-02,
 4.3115425e-02, 6.4716746e-02, 8.1120092e-03, 1.0946731e-02, 6.3539196e-02, 6.0115179e-02, 1.3172345e-02, 1.2834417e-02,
 9.0767844e+00, 1.3641554e+01, 2.8908365e+00, 1.1560811e+00, 9.3267596e+00, 8.3068019e+00, 2.0737408e+00, 2.9299621e+00,
 1.0750164e+00, 2.1891227e+00, 1.8626044e-01, 2.9796729e-01, 1.8131931e+00, 2.3273271e+00, 3.4615857e-01, 3.9983476e-01,
 6.6108932e-02, 8.8213977e-02, 2.8002478e-02, 5.5711535e-03, 3.7947019e-02, 3.0007248e-02, 1.1221377e-02, 7.8874668e-03,
 1.0191585e-02, 1.8426460e-02, 2.3485073e-03, 1.8690629e-03, 1.2354518e-02, 1.4079414e-02, 3.1369072e-03, 1.8025646e-03,
 9.9964520e-03, 1.2873860e-02, 1.6658891e-03, 3.8637031e-04, 1.1252283e-03, 8.5876564e-04, 1.3090997e-04, 1.0726881e-04,
 2.7166956e-04, 4.7405282e-04, 2.4629461e-05, 2.2850527e-05, 4.3077793e-04, 4.7380287e-04, 4.3032153e-05, 2.8826474e-05,
 1.6792497e-03, 1.1303914e-03, 3.0107394e-04, 7.4344353e-05, 1.7894687e-04, 7.1385300e-05, 2.2398247e-05, 1.9540322e-05,
 3.7187338e-05, 3.3918095e-05, 3.6271587e-06, 3.5828171e-06, 1.2380306e-04, 7.1174841e-05, 1.3305422e-05, 9.4895120e-06,
 2.8495009e+00, 2.6022742e+00, 4.7047459e-01, 1.3772193e-01, 6.5905156e-01, 3.5667683e-01, 7.5965892e-02, 7.8564926e-02,
 6.8369484e-02, 8.4599835e-02, 6.1410588e-03, 7.1910724e-03, 2.6050662e-01, 2.0318162e-01, 2.5782526e-02, 2.1798822e-02,
 1.0029966e-04, 8.1325978e-05, 2.2024785e-05, 3.2074706e-06, 1.2958933e-05, 6.2268707e-06, 1.9866135e-06, 1.0221320e-06,
 3.1325040e-06, 3.4414729e-06, 3.7421189e-07, 2.1799759e-07, 8.5783377e-06, 5.9403807e-06, 1.1291582e-06, 4.7494806e-07,
 7.8640944e-01, 1.3980079e+00, 3.4158173e-01, 1.1488131e-01, 2.1184500e-01, 2.2317746e-01, 6.4238615e-02, 7.6329733e-02,
 1.1140882e-01, 2.6835108e-01, 2.6325664e-02, 3.5417454e-02, 5.3620357e-02, 8.1408943e-02, 1.3960950e-02, 1.3561580e-02,
 9.1463408e-01, 8.4988265e-01, 4.2741602e-01, 1.5304617e-01, 2.3325499e-01, 1.2844399e-01, 7.6096810e-02, 9.6267795e-02,
 1.0558515e-01, 1.3293442e-01, 2.6842325e-02, 3.8448118e-02, 1.0669319e-01, 8.4670064e-02, 2.9886808e-02, 3.0909487e-02,
 4.4457961e+01, 5.6044366e+01, 1.9132096e+01, 8.1213195e+00, 2.4607926e+01, 1.8383520e+01, 7.3929900e+00, 1.1087327e+01,
 5.5605641e+00, 9.4978223e+00, 1.3018040e+00, 2.2105126e+00, 6.4309176e+00, 6.9236782e+00, 1.6589188e+00, 2.0339002e+00,
 1.9920391e-01, 2.2295917e-01, 1.1401330e-01, 2.4077046e-02, 6.1594520e-02, 4.0854599e-02, 2.4611140e-02, 1.8362108e-02,
 3.2431394e-02, 4.9183147e-02, 1.0098042e-02, 8.5303783e-03, 2.6957196e-02, 2.5768206e-02, 9.2485150e-03, 5.6410541e-03,
 7.5886612e-04, 1.7833710e-03, 1.5821254e-04, 5.7132227e-05, 7.3980855e-05, 1.0303079e-04, 1.0767807e-05, 1.3737576e-05,
 2.2151839e-05, 7.0535740e-05, 2.5124615e-06, 3.6293015e-06, 1.1852684e-05, 2.3788923e-05, 1.4812629e-06, 1.5449442e-06,
 5.1801107e-03, 6.3630608e-03, 1.1619101e-03, 4.4671413e-04, 4.7808751e-04, 3.4802112e-04, 7.4863952e-05, 1.0168870e-04,
 1.2321635e-04, 2.0507762e-04, 1.5035420e-05, 2.3123623e-05, 1.3842007e-04, 1.4521378e-04, 1.8611097e-05, 2.0666634e-05,
 1.8346326e+00, 3.0573628e+00, 3.7895874e-01, 1.7271947e-01, 3.6750135e-01, 3.6293450e-01, 5.2994904e-02, 8.5334794e-02,
 4.7281573e-02, 1.0676107e-01, 5.3131100e-03, 9.6868266e-03, 6.0791538e-02, 8.6521142e-02, 7.5270611e-03, 9.9086767e-03,
 3.9580490e-04, 5.8563193e-04, 1.0873491e-04, 2.4654838e-05, 4.4290460e-05, 3.8835128e-05, 8.4943470e-06, 6.8046577e-06,
 1.3277704e-05, 2.6618846e-05, 1.9843785e-06, 1.7998691e-06, 1.2269559e-05, 1.5504365e-05, 2.0204877e-06, 1.3232143e-06,
 4.2330443e-02, 9.5242334e-02, 1.2810926e-02, 4.9899023e-03, 1.2841306e-02, 1.7122117e-02, 2.7131191e-03, 3.7335613e-03,
 3.7606052e-03, 1.1464574e-02, 6.1915449e-04, 9.6470398e-04, 2.2438456e-03, 4.3117320e-03, 4.0706148e-04, 4.5794376e-04,
 5.3672756e-02, 6.3122167e-02, 1.7475885e-02, 7.2471565e-03, 1.5414318e-02, 1.0742944e-02, 3.5038177e-03, 5.1334912e-03,
 3.8854689e-03, 6.1914729e-03, 6.8824389e-04, 1.1417058e-03, 4.8674616e-03, 4.8889075e-03, 9.5000743e-04, 1.1378797e-03,
 4.1590653e+00, 6.6358186e+00, 1.2470691e+00, 6.1307183e-01, 2.5924353e+00, 2.4511941e+00, 5.4266854e-01, 9.4253715e-01,
 3.2621119e-01, 7.0521339e-01, 5.3211726e-02, 1.0464333e-01, 4.6771149e-01, 6.3732124e-01, 8.4064454e-02, 1.1936406e-01,
 1.5127001e-02, 2.1428744e-02, 6.0324293e-03, 1.4753560e-03, 5.2672454e-03, 4.4217960e-03, 1.4664096e-03, 1.2670767e-03,
 1.5443804e-03, 2.9642944e-03, 3.3504851e-04, 3.2778991e-04, 1.5914339e-03, 1.9253705e-03, 3.8042376e-04, 2.6872794e-04,
 6.8671740e-03, 9.3887490e-03, 1.0774113e-03, 3.0718178e-04, 4.6890639e-04, 3.7991562e-04, 5.1359604e-05, 5.1734277e-05,
 1.2359282e-04, 2.2895272e-04, 1.0548972e-05, 1.2031165e-05, 1.6659266e-04, 1.9452123e-04, 1.5667468e-05, 1.2901883e-05,
 5.5220759e-04, 3.9462312e-04, 9.3210161e-05, 2.8293978e-05, 3.5696401e-05, 1.5117360e-05, 4.2064676e-06, 4.5111894e-06,
 8.0984560e-06, 7.8416132e-06, 7.4366392e-07, 9.0300675e-07, 2.2918622e-05, 1.3987833e-05, 2.3189362e-06, 2.0331069e-06,
 3.1552142e+00, 3.0590055e+00, 4.9045505e-01, 1.7649089e-01, 4.4268302e-01, 2.5434035e-01, 4.8039146e-02, 6.1074707e-02,
 5.0135166e-02, 6.5859185e-02, 4.2396179e-03, 6.1028567e-03, 1.6238613e-01, 1.3445642e-01, 1.5130695e-02, 1.5726161e-02,
 5.5461099e-05, 4.7740281e-05, 1.1465790e-05, 2.0526303e-06, 4.3468179e-06, 2.2173741e-06, 6.2736290e-07, 3.9679720e-07,
 1.1470983e-06, 1.3378888e-06, 1.2901184e-07, 9.2388922e-08, 2.6703139e-06, 1.9630911e-06, 3.3091542e-07, 1.7110571e-07,
 9.3038786e-01, 1.6761637e+00, 6.3835538e-01, 1.7157515e-01, 3.0542794e-01, 3.2608630e-01, 1.4629834e-01, 1.3892300e-01,
 2.1943131e-01, 5.3564140e-01, 8.1905107e-02, 8.8061520e-02, 7.5293675e-02, 1.1584906e-01, 3.0966807e-02, 2.4039685e-02,
 1.3328376e+00, 1.2551069e+00, 9.8386058e-01, 2.8154145e-01, 4.1422496e-01, 2.3115889e-01, 2.1346390e-01, 2.1581218e-01,
 2.5615141e-01, 3.2683060e-01, 1.0286474e-01, 1.1774941e-01, 1.8453560e-01, 1.4841063e-01, 8.1653689e-02, 6.7487787e-02,
 3.4973513e+01, 4.4680001e+01, 2.3774144e+01, 8.0650286e+00, 2.3590641e+01, 1.7860140e+01, 1.1195345e+01, 1.3417803e+01,
 7.2823606e+00, 1.2605762e+01, 2.6930953e+00, 3.6545672e+00, 6.0044894e+00, 6.5513599e+00, 2.4467009e+00, 2.3973017e+00,
 3.7223715e-01, 4.2222023e-01, 3.3653490e-01, 5.6795645e-02, 1.4026178e-01, 9.4282234e-02, 8.8528249e-02, 5.2784884e-02,
 1.0089076e-01, 1.5505786e-01, 4.9622150e-02, 3.3499931e-02, 5.9787491e-02, 5.7917664e-02, 3.2401133e-02, 1.5793755e-02,
 7.7789563e-04, 1.8526331e-03, 2.5618265e-04, 7.3931105e-05, 9.2416809e-05, 1.3043383e-04, 2.1247668e-05, 2.1663654e-05,
 3.7803323e-05, 1.2198908e-04, 6.7728635e-06, 7.8186664e-06, 1.4420710e-05, 2.9331636e-05, 2.8467840e-06, 2.3728609e-06,
 6.5404842e-03, 8.1419575e-03, 2.3173738e-03, 7.1201682e-04, 7.3562013e-04, 5.4267946e-04, 1.8195831e-04, 1.9751905e-04,
 2.5900201e-04, 4.3686255e-04, 4.9923255e-05, 6.1359328e-05, 2.0743583e-04, 2.2053831e-04, 4.4056422e-05, 3.9097046e-05,
 1.2504883e+00, 2.1118792e+00, 4.0801414e-01, 1.4861463e-01, 3.0525641e-01, 3.0551019e-01, 6.9533230e-02, 8.9479145e-02,
 5.3652049e-02, 1.2277190e-01, 9.5234863e-03, 1.3876039e-02, 4.9179848e-02, 7.0934636e-02, 9.6188335e-03, 1.0119269e-02,
 6.4083185e-04, 9.6090280e-04, 2.7808962e-04, 5.0391238e-05, 8.7387350e-05, 7.7652330e-05, 2.6474100e-05, 1.6948619e-05,
 3.5789028e-05, 7.2712235e-05, 8.4489714e-06, 6.1243192e-06, 2.3577922e-05, 3.0194092e-05, 6.1331767e-06, 3.2099351e-06,
 2.3448075e-02, 5.3465766e-02, 1.1209532e-02, 3.4892826e-03, 8.6683937e-03, 1.1713282e-02, 2.8930163e-03, 3.1815784e-03,
 3.4679731e-03, 1.0714389e-02, 9.0192347e-04, 1.1230570e-03, 1.4752328e-03, 2.8728365e-03, 4.2274688e-04, 3.8007523e-04,
 3.6620373e-02, 4.3645783e-02, 1.8834787e-02, 6.2420358e-03, 1.2816477e-02, 9.0523058e-03, 4.6019139e-03, 5.3882427e-03,
 4.4134286e-03, 7.1271940e-03, 1.2348884e-03, 1.6371056e-03, 3.9417132e-03, 4.0122307e-03, 1.2152405e-03, 1.1632374e-03,
 1.5318778e+00, 2.4769336e+00, 7.2555719e-01, 2.8505555e-01, 1.1636215e+00, 1.1149950e+00, 3.8476110e-01, 5.3406210e-01,
 2.0002819e-01, 4.3823226e-01, 5.1540958e-02, 8.1001606e-02, 2.0446556e-01, 2.8235275e-01, 5.8050640e-02, 6.5872714e-02,
 1.3234689e-02, 1.8999806e-02, 8.3369216e-03, 1.6294744e-03, 5.6159091e-03, 4.7777855e-03, 2.4696996e-03, 1.7054094e-03,
 2.2494638e-03, 4.3756010e-03, 7.7087728e-04, 6.0271235e-04, 1.6525826e-03, 2.0261903e-03, 6.2401466e-04, 3.5227115e-04,
 7.2861585e-03, 1.0095317e-02, 1.8057380e-03, 4.1143916e-04, 6.0629252e-04, 4.9782256e-04, 1.0489873e-04, 8.4443043e-05,
 2.1831210e-04, 4.0984695e-04, 2.9433874e-05, 2.6827605e-05, 2.0979256e-04, 2.4825206e-04, 3.1166321e-05, 2.0510531e-05,
 7.2166844e-04, 5.2264832e-04, 1.9242050e-04, 4.6678726e-05, 5.6850610e-05, 2.4399353e-05, 1.0582314e-05, 9.0696700e-06,
 1.7619810e-05, 1.7290047e-05, 2.5558098e-06, 2.4801607e-06, 3.5549814e-05, 2.1988261e-05, 5.6818601e-06, 3.9810611e-06,
 2.2259927e+00, 2.1870889e+00, 5.4657124e-01, 1.5718353e-01, 3.8059491e-01, 2.2160357e-01, 6.5240639e-02, 6.6285939e-02,
 5.8884531e-02, 7.8391111e-02, 7.8657103e-03, 9.0486049e-03, 1.3597452e-01, 1.1409900e-01, 2.0013357e-02, 1.6623438e-02,
 9.2942824e-05, 8.1078183e-05, 3.0351749e-05, 4.3423805e-06, 8.8771602e-06, 4.5891631e-06, 2.0238293e-06, 1.0229651e-06,
 3.2003090e-06, 3.7827087e-06, 5.6855631e-07, 3.2538732e-07, 5.3113307e-06, 3.9570604e-06, 1.0397065e-06, 4.2963055e-07,
 1.1989258e-01, 1.7675054e-01, 8.3617007e-02, 3.0673746e-02, 1.2357113e-02, 1.0795844e-02, 6.0166033e-03, 7.7976997e-03,
 1.6767110e-02, 3.3492646e-02, 6.3617155e-03, 9.3353321e-03, 5.2023107e-03, 6.5500722e-03, 2.1748930e-03, 2.3043620e-03,
 2.7146694e-01, 2.0918761e-01, 2.0369344e-01, 7.9554764e-02, 2.6488413e-02, 1.2096125e-02, 1.3875476e-02, 1.9146088e-02,
 3.0936232e-02, 3.2300514e-02, 1.2628191e-02, 1.9729385e-02, 2.0152529e-02, 1.3262644e-02, 9.0641850e-03, 1.0224888e-02,
 2.2803677e+01, 2.3839366e+01, 1.5757024e+01, 7.2955118e+00, 4.8293129e+00, 2.9918954e+00, 2.3296286e+00, 3.8107557e+00,
 2.8155869e+00, 3.9882449e+00, 1.0584055e+00, 1.9602752e+00, 2.0991863e+00, 1.8742287e+00, 8.6948069e-01, 1.1627383e+00,
 2.2718914e-02, 2.1087381e-02, 2.0878617e-02, 4.8091349e-03, 2.6877381e-03, 1.4784048e-03, 1.7243810e-03, 1.4032705e-03,
 3.6513228e-03, 4.5920697e-03, 1.8254847e-03, 1.6820039e-03, 1.9565340e-03, 1.5509730e-03, 1.0778071e-03, 7.1704586e-04,
 4.5191403e-05, 8.8072369e-05, 1.5128226e-05, 5.9586197e-06, 1.6856411e-06, 1.9467956e-06, 3.9393940e-07, 5.4818858e-07,
 1.3022530e-06, 3.4387634e-06, 2.3716010e-07, 3.7366504e-07, 4.4919027e-07, 7.4764566e-07, 9.0136789e-08, 1.0254165e-07,
 6.0055922e-04, 6.1177333e-04, 2.1629457e-04, 9.0702722e-05, 2.1206998e-05, 1.2802210e-05, 5.3321360e-06, 7.8998464e-06,
 1.4101979e-05, 1.9464245e-05, 2.7630173e-06, 4.6349132e-06, 1.0212660e-05, 8.8849536e-06, 2.2047952e-06, 2.6704429e-06,
 3.6757946e-01, 5.0799180e-01, 1.2191317e-01, 6.0606258e-02, 2.8171915e-02, 2.3072414e-02, 6.5230063e-03, 1.1456650e-02,
 9.3516702e-03, 1.7511272e-02, 1.6873391e-03, 3.3554643e-03, 7.7511871e-03, 9.1486123e-03, 1.5410159e-03, 2.2126590e-03,
 1.7632661e-05, 2.1635595e-05, 7.7778969e-06, 1.9235923e-06, 7.5492207e-07, 5.4893912e-07, 2.3247611e-07, 2.0312905e-07,
 5.8392157e-07, 9.7079645e-07, 1.4012401e-07, 1.3862660e-07, 3.4784732e-07, 3.6451966e-07, 9.1975547e-08, 6.5699722e-08,
 3.4821433e-03, 6.4972746e-03, 1.6921186e-03, 7.1888549e-04, 4.0416430e-04, 4.4690364e-04, 1.3711162e-04, 2.0580041e-04,
 3.0538404e-04, 7.7206469e-04, 8.0731703e-05, 1.3720077e-04, 1.1746530e-04, 1.8718702e-04, 3.4216301e-05, 4.1985825e-05,
 8.5955544e-03, 8.3831880e-03, 4.4938186e-03, 2.0326452e-03, 9.4449408e-04, 5.4589096e-04, 3.4472522e-04, 5.5088609e-04,
 6.1426818e-04, 8.1173881e-04, 1.7470835e-04, 3.1611343e-04, 4.9607277e-04, 4.1320176e-04, 1.5546275e-04, 2.0310130e-04,
 1.1510678e+00, 1.5230252e+00, 5.5418164e-01, 2.9716009e-01, 2.7451645e-01, 2.1525118e-01, 9.2268096e-02, 1.7479650e-01,
 8.9124920e-02, 1.5978213e-01, 2.3343392e-02, 5.0070940e-02, 8.2377057e-02, 9.3088085e-02, 2.3773719e-02, 3.6819328e-02,
 9.3087693e-04, 1.0935632e-03, 5.9605790e-04, 1.5900487e-04, 1.2401625e-04, 8.6337873e-05, 5.5437890e-05, 5.2248238e-05,
 9.3818633e-05, 1.4933566e-04, 3.2681275e-05, 3.4874201e-05, 6.2323432e-05, 6.2529434e-05, 2.3921421e-05, 1.8431024e-05,
 1.4434781e-04, 1.6366181e-04, 3.6363875e-05, 1.1308410e-05, 3.7711491e-06, 2.5338566e-06, 6.6323199e-07, 7.2868485e-07,
 2.5646041e-06, 3.9398573e-06, 3.5147460e-07, 4.3722875e-07, 2.2284919e-06, 2.1578921e-06, 3.3651953e-07, 3.0226113e-07,
 2.2597518e-05, 1.3392101e-05, 6.1246042e-06, 2.0278056e-06, 5.5890513e-07, 1.9628946e-07, 1.0575172e-07, 1.2370256e-07,
 3.2715638e-07, 2.6270361e-07, 4.8237684e-08, 6.3887830e-08, 5.9685640e-07, 3.0209204e-07, 9.6967627e-08, 9.2729000e-08,
 2.2313761e-01, 1.7940368e-01, 5.5692882e-02, 2.1859502e-02, 1.1978210e-02, 5.7071823e-03, 2.0871363e-03, 2.8942384e-03,
 3.5001067e-03, 3.8129661e-03, 4.7524981e-04, 7.4618391e-04, 7.3082917e-03, 5.0182929e-03, 1.0934079e-03, 1.2395480e-03,
 8.7210137e-07, 6.2254513e-07, 2.8949331e-07, 5.6527911e-08, 2.6152006e-08, 1.1063184e-08, 6.0605033e-09, 4.1809602e-09,
 1.7806302e-08, 1.7222688e-08, 3.2155817e-09, 2.5116961e-09, 2.6721677e-08, 1.6291050e-08, 5.3171005e-09, 2.9987474e-09,
 2.2056827e-02, 3.3631820e-02, 9.9610270e-03, 2.3889076e-03, 1.9539363e-03, 1.7655851e-03, 6.1603209e-04, 5.2196504e-04,
 1.4958758e-03, 3.0904781e-03, 3.6751103e-04, 3.5257278e-04, 5.2355681e-04, 6.8179290e-04, 1.4173082e-04, 9.8174803e-05,
 7.0892324e-02, 5.6501137e-02, 3.4444332e-02, 8.7948807e-03, 5.9453904e-03, 2.8080802e-03, 2.0166525e-03, 1.8192236e-03,
 3.9177452e-03, 4.2307481e-03, 1.0355441e-03, 1.0577038e-03, 2.8789118e-03, 1.9596011e-03, 8.3846790e-04, 6.1835682e-04,
 1.1684721e+01, 1.2634184e+01, 5.2281311e+00, 1.5825270e+00, 2.1268720e+00, 1.3628288e+00, 6.6435709e-01, 7.1047516e-01,
 6.9963127e-01, 1.0249930e+00, 1.7029859e-01, 2.0620492e-01, 5.8841196e-01, 5.4336523e-01, 1.5781533e-01, 1.3797297e-01,
 3.3725463e-03, 3.2376664e-03, 2.0069242e-03, 3.0221724e-04, 3.4292561e-04, 1.9509456e-04, 1.4246393e-04, 7.5794210e-05,
 2.6284966e-04, 3.4190430e-04, 8.5093096e-05, 5.1258491e-05, 1.5888202e-04, 1.3026581e-04, 5.6674425e-05, 2.4649941e-05,
 1.7276167e-06, 3.4823327e-06, 3.7448848e-07, 9.6431551e-08, 5.5385900e-08, 6.6159659e-08, 8.3815111e-09, 7.6251061e-09,
 2.4142019e-08, 6.5935518e-08, 2.8469413e-09, 2.9325292e-09, 9.3937460e-09, 1.6171237e-08, 1.2205890e-09, 9.0780071e-10,
 3.2589589e-05, 3.4336210e-05, 7.6002432e-06, 2.0836513e-06, 9.8911017e-07, 6.1757436e-07, 1.6103691e-07, 1.5597883e-07,
 3.7109899e-07, 5.2976841e-07, 4.7081710e-08, 5.1633677e-08, 3.0316477e-07, 2.7279336e-07, 4.2380568e-08, 3.3558674e-08,
 3.9138645e-02, 5.5943556e-02, 8.4055076e-03, 2.7318308e-03, 2.5781819e-03, 2.1838807e-03, 3.8654817e-04, 4.4385019e-04,
 4.8287022e-04, 9.3518557e-04, 5.6415995e-05, 7.3345850e-05, 4.5148115e-04, 5.5114446e-04, 5.8121556e-05, 5.4559140e-05,
 5.4391313e-07, 6.9027038e-07, 1.5535760e-07, 2.5119217e-08, 2.0015016e-08, 1.5052788e-08, 3.9910868e-09, 2.2798576e-09,
 8.7347953e-09, 1.5019840e-08, 1.3572800e-09, 8.7786235e-10, 5.8697154e-09, 6.3619198e-09, 1.0049846e-09, 4.6932484e-10,
 3.8469208e-04, 7.4239765e-04, 1.2104755e-04, 3.3620785e-05, 3.8376633e-05, 4.3889603e-05, 8.4302763e-06, 8.2724998e-06,
 1.6360611e-05, 4.2780500e-05, 2.8006318e-06, 3.1116551e-06, 7.0989303e-06, 1.1700325e-05, 1.3389833e-06, 1.0741569e-06,
 1.3479429e-03, 1.3597090e-03, 4.5632265e-04, 1.3494010e-04, 1.2730331e-04, 7.6100041e-05, 3.0086518e-05, 3.1432845e-05,
 4.6713508e-05, 6.3846891e-05, 8.6031364e-06, 1.0176753e-05, 4.2555905e-05, 3.6661940e-05, 8.6357431e-06, 7.3758008e-06,
 3.5418523e-01, 4.8470274e-01, 1.1041811e-01, 3.8708074e-02, 7.2600620e-02, 5.8878447e-02, 1.5800908e-02, 1.9569794e-02,
 1.3298879e-02, 2.4659435e-02, 2.2554793e-03, 3.1628854e-03, 1.3866040e-02, 1.6206121e-02, 2.5912060e-03, 2.6236377e-03,
 8.2981004e-05, 1.0082519e-04, 3.4405946e-05, 6.0003779e-06, 9.5018341e-06, 6.8417778e-06, 2.7503900e-06, 1.6946580e-06,
 4.0556646e-06, 6.6769068e-06, 9.1480934e-07, 6.3820323e-07, 3.0391672e-06, 3.1537449e-06, 7.5535104e-07, 3.8048227e-07,
 2.9560265e-05, 3.4664462e-05, 4.8219979e-06, 9.8035030e-07, 6.6376474e-07, 4.6127652e-07, 7.5590055e-08, 5.4295255e-08,
 2.5468609e-07, 4.0467288e-07, 2.2601505e-08, 1.8381254e-08, 2.4964676e-07, 2.5002495e-07, 2.4410913e-08, 1.4334376e-08,
 6.5688608e-06, 4.0263974e-06, 1.1528331e-06, 2.4953838e-07, 1.3963999e-07, 5.0723323e-08, 1.7108736e-08, 1.3083746e-08,
 4.6118091e-08, 3.8301951e-08, 4.4031251e-09, 3.8125539e-09, 9.4910924e-08, 4.9684857e-08, 9.9846205e-09, 6.2422835e-09,
 1.2727228e-01, 1.0583544e-01, 2.0569293e-02, 5.2781644e-03, 5.8721232e-03, 2.8937687e-03, 6.6254119e-04, 6.0064707e-04,
 9.6811893e-04, 1.0908102e-03, 8.5119309e-05, 8.7372561e-05, 2.2803080e-03, 1.6194683e-03, 2.2091169e-04, 1.6372796e-04,
 1.4410687e-07, 1.0639654e-07, 3.0975270e-08, 3.9542355e-09, 3.7141991e-09, 1.6250972e-09, 5.5734964e-10, 2.5137259e-10,
 1.4268502e-09, 1.4273955e-09, 1.6684859e-10, 8.5202762e-11, 2.4154511e-09, 1.5230799e-09, 3.1122060e-10, 1.1475087e-10,
 3.8490650e-03, 6.2305918e-03, 1.6365131e-03, 4.8247059e-04, 2.0684059e-04, 1.9841804e-04, 6.1394871e-05, 6.3947897e-05,
 1.7287326e-04, 3.7916204e-04, 3.9985785e-05, 4.7156379e-05, 5.1433525e-05, 7.1105286e-05, 1.3108407e-05, 1.1161992e-05,
 5.9219683e-03, 5.0106134e-03, 2.7088689e-03, 8.5026836e-04, 3.0127323e-04, 1.5106244e-04, 9.6208737e-05, 1.0669044e-04,
 2.1673201e-04, 2.4846817e-04, 5.3933510e-05, 6.7718968e-05, 1.3538343e-04, 9.7829932e-05, 3.7121613e-05, 3.3653912e-05,
 3.2866880e+00, 3.7727163e+00, 1.3844900e+00, 5.1516975e-01, 3.6290664e-01, 2.4686613e-01, 1.0672304e-01, 1.4030126e-01,
 1.3032549e-01, 2.0269721e-01, 2.9865823e-02, 4.4454767e-02, 9.3173378e-02, 9.1341671e-02, 2.3526786e-02, 2.5285032e-02,
 4.7372558e-04, 4.8280063e-04, 2.6540130e-04, 4.9130062e-05, 2.9220137e-05, 1.7647959e-05, 1.1428532e-05, 7.4744213e-06,
 2.4450991e-05, 3.3764499e-05, 7.4522312e-06, 5.5184101e-06, 1.2563597e-05, 1.0935442e-05, 4.2191941e-06, 2.2558698e-06,
 8.1302875e-07, 1.7397846e-06, 1.6592057e-07, 5.2521463e-08, 1.5811434e-08, 2.0050813e-08, 2.2526689e-09, 2.5192827e-09,
 7.5240590e-09, 2.1815483e-08, 8.3533422e-10, 1.0577432e-09, 2.4886714e-09, 4.5481907e-09, 3.0443961e-10, 2.7834187e-10,
 7.3416176e-06, 8.2116864e-06, 1.6119205e-06, 5.4324699e-07, 1.3516724e-07, 8.9594802e-08, 2.0718349e-08, 2.4668999e-08,
 5.5363403e-08, 8.3904666e-08, 6.6128455e-09, 8.9150852e-09, 3.8446970e-08, 3.6726867e-08, 5.0600341e-09, 4.9254669e-09,
 2.9688768e-02, 4.5050879e-02, 6.0027940e-03, 2.3982769e-03, 1.1863512e-03, 1.0668309e-03, 1.6745827e-04, 2.3637161e-04,
 2.4256981e-04, 4.9873617e-04, 2.6681602e-05, 4.2642361e-05, 1.9279524e-04, 2.4985551e-04, 2.3366682e-05, 2.6963945e-05,
 2.0603680e-07, 2.7758830e-07, 5.5405247e-08, 1.1012361e-08, 4.5992253e-09, 3.6720819e-09, 8.6342155e-10, 6.0631087e-10,
 2.1912306e-09, 4.0000690e-09, 3.2055903e-10, 2.5487121e-10, 1.2517063e-09, 1.4402586e-09, 2.0176612e-10, 1.1582928e-10,
 3.8682121e-05, 7.9250263e-05, 1.1459252e-05, 3.9125890e-06, 2.3408716e-06, 2.8420987e-06, 4.8412285e-07, 5.8399149e-07,
 1.0894738e-06, 3.0243362e-06, 1.7558063e-07, 2.3981042e-07, 4.0184676e-07, 7.0312479e-07, 7.1358535e-08, 7.0371125e-08,
 6.4881877e-05, 6.9480731e-05, 2.0678885e-05, 7.5171320e-06, 3.7171048e-06, 2.3589411e-06, 8.2706649e-07, 1.0622055e-06,
 1.4890677e-06, 2.1606206e-06, 2.5818556e-07, 3.7543984e-07, 1.1531399e-06, 1.0546412e-06, 2.2030543e-07, 2.3130806e-07,
 5.7405766e-02, 8.3400248e-02, 1.6848794e-02, 7.2608238e-03, 7.1380327e-03, 6.1455620e-03, 1.4625940e-03, 2.2268142e-03,
 1.4274482e-03, 2.8099280e-03, 2.2792245e-04, 3.9290519e-04, 1.2651670e-03, 1.5697895e-03, 2.2258744e-04, 2.7705019e-04,
 6.7163398e-06, 8.6634301e-06, 2.6217463e-06, 5.6207173e-07, 4.6652477e-07, 3.5661793e-07, 1.2713488e-07, 9.6296086e-08,
 2.1738819e-07, 3.7994119e-07, 4.6164465e-08, 3.9590606e-08, 1.3847737e-07, 1.5255184e-07, 3.2402319e-08, 2.0064011e-08,
 7.1829363e-06, 8.9422090e-06, 1.1031223e-06, 2.7569825e-07, 9.7841065e-08, 7.2183031e-08, 1.0489984e-08, 9.2624978e-09,
 4.0984414e-08, 6.9132868e-08, 3.4241613e-09, 3.4233245e-09, 3.4149935e-08, 3.6308993e-08, 3.1437720e-09, 2.2693520e-09,
 7.6407904e-07, 4.9720091e-07, 1.2624606e-07, 3.3592703e-08, 9.8530680e-09, 3.7995851e-09, 1.1365350e-09, 1.0684472e-09,
 3.5525456e-09, 3.1322479e-09, 3.1932489e-10, 3.3989386e-10, 6.2149063e-09, 3.4538983e-09, 6.1553584e-10, 4.7306533e-10,
 4.9848855e-02, 4.4006765e-02, 7.5847965e-03, 2.3925634e-03, 1.3951795e-03, 7.2990372e-04, 1.4820098e-04, 1.6516322e-04,
 2.5111367e-04, 3.0037059e-04, 2.0786089e-05, 2.6228635e-05, 5.0278854e-04, 3.7908021e-04, 4.5857838e-05, 4.1780508e-05,
 2.8186107e-08, 2.2092485e-08, 5.7038585e-09, 8.9510084e-10, 4.4068578e-10, 2.0469626e-10, 6.2257917e-11, 3.4517622e-11,
 1.8481991e-10, 1.9628243e-10, 2.0346805e-11, 1.2772705e-11, 2.6596158e-10, 1.7803688e-10, 3.2262044e-11, 1.4622980e-11,
 1.4753136e-02, 2.4201932e-02, 9.9083453e-03, 2.3344760e-03, 9.6614006e-04, 9.3924065e-04, 4.5299025e-04, 3.7706842e-04,
 1.1031144e-03, 2.4519365e-03, 4.0304269e-04, 3.7985939e-04, 2.3398545e-04, 3.2782047e-04, 9.4198743e-05, 6.4102347e-05,
 2.7958235e-02, 2.3973208e-02, 2.0201530e-02, 5.0674508e-03, 1.7333237e-03, 8.8077937e-04, 8.7435156e-04, 7.7487953e-04,
 1.7034555e-03, 1.9791098e-03, 6.6960542e-04, 6.7190446e-04, 7.5861729e-04, 5.5554669e-04, 3.2857651e-04, 2.3805775e-04,
 8.3764838e+00, 9.7442609e+00, 5.5737281e+00, 1.6574607e+00, 1.1271283e+00, 7.7701904e-01, 5.2358771e-01, 5.5008493e-01,
 5.5296343e-01, 8.7157832e-01, 2.0016774e-01, 2.3810851e-01, 2.8184394e-01, 2.8001239e-01, 1.1241700e-01, 9.6553952e-02,
 2.8678905e-03, 2.9620680e-03, 2.5379989e-03, 3.7546787e-04, 2.1557244e-04, 1.3194624e-04, 1.3318462e-04, 6.9611051e-05,
 2.4643126e-04, 3.4486670e-04, 1.1864199e-04, 7.0210640e-05, 9.0274120e-05, 7.9630059e-05, 4.7888523e-05, 2.0462243e-05,
 2.7000750e-06, 5.8554079e-06, 8.7040792e-07, 2.2018953e-07, 6.3990634e-08, 8.2237290e-08, 1.4401088e-08, 1.2870989e-08,
 4.1599306e-08, 1.2223348e-07, 7.2953579e-09, 7.3825055e-09, 9.8095959e-09, 1.8168281e-08, 1.8955599e-09, 1.3850061e-09,
 3.0031479e-05, 3.4041497e-05, 1.0415523e-05, 2.8052516e-06, 6.7380008e-07, 4.5262051e-07, 1.6314267e-07, 1.5523915e-07,
 3.7702600e-07, 5.7906342e-07, 7.1136031e-08, 7.6641467e-08, 1.8666390e-07, 1.8070654e-07, 3.8806486e-08, 3.0188081e-08,
 6.5559607e-02, 1.0081823e-01, 2.0938738e-02, 6.6854914e-03, 3.1925138e-03, 2.9094219e-03, 7.1183382e-04, 8.0297971e-04,
 8.9175347e-04, 1.8581061e-03, 1.5494322e-04, 1.9789689e-04, 5.0530545e-04, 6.6364864e-04, 9.6740291e-05, 8.9213560e-05,
 1.0807402e-06, 1.4756031e-06, 4.5907147e-07, 7.2920047e-08, 2.9399282e-08, 2.3787885e-08, 8.7182133e-09, 4.8925696e-09,
 1.9134995e-08, 3.5399693e-08, 4.4218197e-09, 2.8096419e-09, 7.7927827e-09, 9.0870355e-09, 1.9842256e-09, 9.1032842e-10,
 6.9418975e-05, 1.4413190e-04, 3.2484555e-05, 8.8638426e-06, 5.1194201e-06, 6.2990314e-06, 1.6724435e-06, 1.6122768e-06,
 3.2549805e-06, 9.1570009e-06, 8.2863024e-07, 9.0445991e-07, 8.5593703e-07, 1.5177671e-06, 2.4009332e-07, 1.8921930e-07,
 1.4341880e-04, 1.5564629e-04, 7.2204206e-05, 2.0976090e-05, 1.0012968e-05, 6.4397102e-06, 3.5192563e-06, 3.6120688e-06,
 5.4797497e-06, 8.0577992e-06, 1.5008281e-06, 1.7441202e-06, 3.0253688e-06, 2.8040930e-06, 9.1300596e-07, 7.6608407e-07,
 6.8501116e-02, 1.0085585e-01, 3.1758742e-02, 1.0937493e-02, 1.0379968e-02, 9.0567113e-03, 3.3596484e-03, 4.0878117e-03,
 2.8357386e-03, 5.6570823e-03, 7.1522995e-04, 9.8533406e-04, 1.7918586e-03, 2.2531416e-03, 4.9797639e-04, 4.9534039e-04,
 1.9037387e-05, 2.4886057e-05, 1.1738641e-05, 2.0112031e-06, 1.6114789e-06, 1.2483730e-06, 6.9369279e-07, 4.1990238e-07,
 1.0258278e-06, 1.8169631e-06, 3.4411116e-07, 2.3584150e-07, 4.6587234e-07, 5.2011240e-07, 1.7219352e-07, 8.5211017e-08,
 2.4690868e-05, 3.1150896e-05, 5.9897766e-06, 1.1963502e-06, 4.0985560e-07, 3.0643350e-07, 6.9412397e-08, 4.8980972e-08,
 2.3454002e-07, 4.0093527e-07, 3.0953155e-08, 2.4730668e-08, 1.3932782e-07, 1.5012512e-07, 2.0260560e-08, 1.1687980e-08,
 3.2350970e-06, 2.1334007e-06, 8.4434382e-07, 1.7954923e-07, 5.0838865e-08, 1.9867905e-08, 9.2631696e-09, 6.9593251e-09,
 2.5041048e-08, 2.2374873e-08, 3.5554783e-09, 3.0244468e-09, 3.1231815e-08, 1.7589916e-08, 4.8861680e-09, 3.0010515e-09,
 1.1393670e-01, 1.0193415e-01, 2.7384513e-02, 6.9033811e-03, 3.8861004e-03, 2.0603502e-03, 6.5205994e-04, 5.8074682e-04,
 9.5552615e-04, 1.1583010e-03, 1.2493897e-04, 1.2599055e-04, 1.3639781e-03, 1.0421848e-03, 1.9651164e-04, 1.4308215e-04,
 1.5302982e-07, 1.2155621e-07, 4.8917268e-08, 6.1348347e-09, 2.9157157e-09, 1.3725160e-09, 6.5067420e-10, 2.8830151e-10,
 1.6705271e-09, 1.7979501e-09, 2.9050495e-10, 1.4573955e-10, 1.7138524e-09, 1.1626694e-09, 3.2839708e-10, 1.1895429e-10,
 2.0415665e-01, 2.3141891e-01, 1.0725635e-01, 3.4207173e-02, 2.0734570e-02, 1.3928413e-02, 7.6047762e-03, 8.5688677e-03,
 1.7969231e-02, 2.7598648e-02, 5.1357358e-03, 6.5520956e-03, 8.7792112e-03, 8.4990870e-03, 2.7647389e-03, 2.5467661e-03,
 8.4462647e-03, 5.0043883e-03, 4.7739938e-03, 1.6210373e-03, 8.1210162e-04, 2.8514625e-04, 3.2044936e-04, 3.8442645e-04,
 6.0578075e-04, 4.8632245e-04, 1.8627145e-04, 2.5301171e-04, 6.2139141e-04, 3.1443642e-04, 2.1053367e-04, 2.0647765e-04,
 1.7884734e+01, 1.4376040e+01, 9.3091292e+00, 3.7472490e+00, 3.7322419e+00, 1.7778604e+00, 1.3562137e+00, 1.9287441e+00,
 1.3897828e+00, 1.5136541e+00, 3.9353835e-01, 6.3368568e-01, 1.6316115e+00, 1.1200955e+00, 5.0907611e-01, 5.9187044e-01,
 5.9112922e-02, 4.2187577e-02, 4.0921704e-02, 8.1948476e-03, 6.8910997e-03, 2.9144850e-03, 3.3303653e-03, 2.3562535e-03,
 5.9792301e-03, 5.7818967e-03, 2.2518025e-03, 1.8038515e-03, 5.0451058e-03, 3.0750626e-03, 2.0935385e-03, 1.2109011e-03,
 7.9119473e-05, 1.1855893e-04, 1.9951374e-05, 6.8320696e-06, 2.9080345e-06, 2.5823889e-06, 5.1194226e-07, 6.1936032e-07,
 1.4349051e-06, 2.9133791e-06, 1.9684586e-07, 2.6964312e-07, 7.7937412e-07, 9.9742067e-07, 1.1780799e-07, 1.1651847e-07,
 1.9211431e-05, 1.5047404e-05, 5.2120302e-06, 1.9002176e-06, 6.6848260e-07, 3.1028645e-07, 1.2661033e-07, 1.6308281e-07,
 2.8391224e-07, 3.0130667e-07, 4.1902989e-08, 6.1111758e-08, 3.2376576e-07, 2.1657789e-07, 5.2652311e-08, 5.5443984e-08,
 2.9640476e-01, 3.1496161e-01, 7.4052845e-02, 3.2005946e-02, 2.2385005e-02, 1.4096162e-02, 3.9043232e-03, 5.9618013e-03,
 4.7459535e-03, 6.8331143e-03, 6.4505049e-04, 1.1152335e-03, 6.1942708e-03, 5.6213965e-03, 9.2765425e-04, 1.1580186e-03,
 4.7170369e-05, 4.4502758e-05, 1.5673668e-05, 3.3701016e-06, 1.9900324e-06, 1.1126251e-06, 4.6162950e-07, 3.5067842e-07,
 9.8311857e-07, 1.2567429e-06, 1.7771377e-07, 1.5285407e-07, 9.2220593e-07, 7.4306550e-07, 1.8368289e-07, 1.1407270e-07,
 1.9339633e-02, 2.7745968e-02, 7.0792869e-03, 2.6148121e-03, 2.2119063e-03, 1.8805690e-03, 5.6524877e-04, 7.3762162e-04,
 1.0674514e-03, 2.0750227e-03, 2.1257060e-04, 3.1407799e-04, 6.4654595e-04, 7.9219574e-04, 1.4186652e-04, 1.5134619e-04,
 8.7227207e-04, 6.5411543e-04, 3.4351907e-04, 1.3508859e-04, 9.4446183e-05, 4.1971807e-05, 2.5966604e-05, 3.6076618e-05,
 3.9231652e-05, 3.9862249e-05, 8.4052171e-06, 1.3222094e-05, 4.9889785e-05, 3.1951801e-05, 1.1777409e-05, 1.3376978e-05,
 2.9444851e+00, 2.9955909e+00, 1.0678682e+00, 4.9782631e-01, 6.9196369e-01, 4.1718389e-01, 1.7519575e-01, 2.8855381e-01,
 1.4348529e-01, 1.9778963e-01, 2.8309333e-02, 5.2792614e-02, 2.0883468e-01, 1.8145010e-01, 4.5399426e-02, 6.1129539e-02,
 7.8998288e-03, 7.1356959e-03, 3.8104022e-03, 8.8372037e-04, 1.0370764e-03, 5.5513739e-04, 3.4921746e-04, 2.8614279e-04,
 5.0108874e-04, 6.1327585e-04, 1.3148664e-04, 1.2198569e-04, 5.2416127e-04, 4.0435678e-04, 1.5155048e-04, 1.0151767e-04,
 4.3969437e-04, 3.8331421e-04, 8.3438742e-05, 2.2559064e-05, 1.1319336e-05, 5.8478487e-06, 1.4995807e-06, 1.4324057e-06,
 4.9165578e-06, 5.8074874e-06, 5.0756499e-07, 5.4894449e-07, 6.7272808e-06, 5.0087023e-06, 7.6523695e-07, 5.9757131e-07,
 1.2577022e-06, 5.7310275e-07, 2.5677460e-07, 7.3913260e-08, 3.0652212e-08, 8.2772828e-09, 4.3688619e-09, 4.4430512e-09,
 1.1459680e-08, 7.0753887e-09, 1.2728021e-09, 1.4655962e-09, 3.2921136e-08, 1.2811830e-08, 4.0289211e-09, 3.3496504e-09,
 3.1305428e-01, 1.9352874e-01, 5.8857755e-02, 2.0084743e-02, 1.6559440e-02, 6.0665574e-03, 2.1735100e-03, 2.6203965e-03,
 3.0904982e-03, 2.5886711e-03, 3.1610123e-04, 4.3149123e-04, 1.0161338e-02, 5.3648534e-03, 1.1451811e-03, 1.1286967e-03,
 4.0591122e-06, 2.2279314e-06, 1.0149855e-06, 1.7230824e-07, 1.1994327e-07, 3.9013773e-08, 2.0938076e-08, 1.2558164e-08,
 5.2160074e-08, 3.8791088e-08, 7.0954639e-09, 4.8184817e-09, 1.2325818e-07, 5.7778765e-08, 1.8474979e-08, 9.0588045e-09,
 4.8968427e-02, 5.7410361e-02, 1.6658436e-02, 3.4733727e-03, 4.2745455e-03, 2.9698548e-03, 1.0151732e-03, 7.4782524e-04,
 2.0901078e-03, 3.3202125e-03, 3.8681253e-04, 3.2262724e-04, 1.1519266e-03, 1.1534015e-03, 2.3489968e-04, 1.4146207e-04,
 2.8757336e-03, 1.7622743e-03, 1.0525056e-03, 2.3364615e-04, 2.3764935e-04, 8.6304330e-05, 6.0721756e-05, 4.7623499e-05,
 1.0001978e-04, 8.3048850e-05, 1.9914775e-05, 1.7684497e-05, 1.1573530e-04, 6.0572042e-05, 2.5391067e-05, 1.6280044e-05,
 1.1948074e+01, 9.9332997e+00, 4.0270123e+00, 1.0597646e+00, 2.1430267e+00, 1.0558310e+00, 5.0424876e-01, 4.6882863e-01,
 4.5024488e-01, 5.0718615e-01, 8.2555842e-02, 8.6907542e-02, 5.9627809e-01, 4.2337595e-01, 1.2046852e-01, 9.1567307e-02,
 1.1440755e-02, 8.4449233e-03, 5.1284328e-03, 6.7142102e-04, 1.1463133e-03, 5.0143598e-04, 3.5872805e-04, 1.6592748e-04,
 5.6118263e-04, 5.6126520e-04, 1.3685101e-04, 7.1670680e-05, 5.3414538e-04, 3.3673006e-04, 1.4352545e-04, 5.4272460e-05,
 3.9434554e-06, 6.1117647e-06, 6.4390958e-07, 1.4415430e-07, 1.2457627e-07, 1.1441852e-07, 1.4200889e-08, 1.1232100e-08,
 3.4681921e-08, 7.2830920e-08, 3.0808115e-09, 2.7589959e-09, 2.1249866e-08, 2.8127268e-08, 2.0799064e-09, 1.3448905e-09,
 1.3592034e-06, 1.1010961e-06, 2.3877593e-07, 5.6912789e-08, 4.0649689e-08, 1.9515013e-08, 4.9853443e-09, 4.1981453e-09,
 9.7408209e-09, 1.0692001e-08, 9.3092584e-10, 8.8760105e-10, 1.2530619e-08, 8.6695039e-09, 1.3195251e-09, 9.0840111e-10,
 4.1147324e-02, 4.5222327e-02, 6.6566670e-03, 1.8809127e-03, 2.6708894e-03, 1.7395556e-03, 3.0164996e-04, 3.0113260e-04,
 3.1949670e-04, 4.7577369e-04, 2.8118710e-05, 3.1782685e-05, 4.7039583e-04, 4.4152577e-04, 4.5616093e-05, 3.7228063e-05,
 1.8970663e-06, 1.8511394e-06, 4.0817138e-07, 5.7377045e-08, 6.8788500e-08, 3.9778052e-08, 1.0332560e-08, 5.1315236e-09,
 1.9173699e-08, 2.5350439e-08, 2.2442943e-09, 1.2619979e-09, 2.0288876e-08, 1.6908150e-08, 2.6167216e-09, 1.0624133e-09,
 2.7855863e-03, 4.1333967e-03, 6.6026225e-04, 1.5943752e-04, 2.7382761e-04, 2.4079020e-04, 4.5311569e-05, 3.8656809e-05,
 7.4559525e-05, 1.4990513e-04, 9.6142867e-06, 9.2869709e-06, 5.0942990e-05, 6.4558940e-05, 7.2380849e-06, 5.0482190e-06,
 1.7834119e-04, 1.3832248e-04, 4.5478797e-05, 1.1692295e-05, 1.6596876e-05, 7.6284911e-06, 2.9547167e-06, 2.6837963e-06,
 3.8897591e-06, 4.0877735e-06, 5.3962745e-07, 5.5496852e-07, 5.5799187e-06, 3.6961584e-06, 8.5295180e-07, 6.3336793e-07,
 1.1812462e+00, 1.2429468e+00, 2.7740060e-01, 8.4545515e-02, 2.3859241e-01, 1.4877845e-01, 3.9116136e-02, 4.2119379e-02,
 2.7914201e-02, 3.9797882e-02, 3.5662030e-03, 4.3478296e-03, 4.5830081e-02, 4.1185471e-02, 6.4514442e-03, 5.6791148e-03,
 9.1813371e-04, 8.5775524e-04, 2.8675945e-04, 4.3479515e-05, 1.0359561e-04, 5.7354794e-05, 2.2588380e-05, 1.2100268e-05,
 2.8241605e-05, 3.5749481e-05, 4.7986043e-06, 2.9104847e-06, 3.3324964e-05, 2.6589401e-05, 6.2390876e-06, 2.7323011e-06,
 1.1739528e-04, 1.0585066e-04, 1.4425343e-05, 2.5497792e-06, 2.5975448e-06, 1.3879610e-06, 2.2282855e-07, 1.3915214e-07,
 6.3657196e-07, 7.7770215e-07, 4.2553660e-08, 3.0088216e-08, 9.8255348e-07, 7.5662484e-07, 7.2372097e-08, 3.6947753e-08,
 4.7666016e-07, 2.2464789e-07, 6.3014709e-08, 1.1858643e-08, 9.9847068e-09, 2.7886887e-09, 9.2151080e-10, 6.1268406e-10,
 2.1061534e-09, 1.3449519e-09, 1.5147362e-10, 1.1402858e-10, 6.8253155e-09, 2.7472474e-09, 5.4087314e-10, 2.9398751e-10,
 2.3279961e-01, 1.4884933e-01, 2.8341652e-02, 6.3228147e-03, 1.0584020e-02, 4.0103848e-03, 8.9955017e-04, 7.0901220e-04,
 1.1144936e-03, 9.6552822e-04, 7.3813203e-05, 6.5872310e-05, 4.1336165e-03, 2.2572315e-03, 3.0165636e-04, 1.9437414e-04,
 8.7448146e-07, 4.9643291e-07, 1.4159181e-07, 1.5714751e-08, 2.2209449e-08, 7.4716908e-09, 2.5104842e-09, 9.8439506e-10,
 5.4493470e-09, 4.1915726e-09, 4.8000495e-10, 2.1310728e-10, 1.4526206e-08, 7.0427692e-09, 1.4098704e-09, 4.5194860e-10,
 2.1649340e-02, 2.6945466e-02, 6.9337154e-03, 1.7772116e-03, 1.1463889e-03, 8.4555953e-04, 2.5632174e-04, 2.3211394e-04,
 6.1195211e-04, 1.0320038e-03, 1.0662336e-04, 1.0932235e-04, 2.8669736e-04, 3.0475168e-04, 5.5040756e-05, 4.0747234e-05,
 6.0860001e-04, 3.9593484e-04, 2.0970598e-04, 5.7226984e-05, 3.0509371e-05, 1.1762408e-05, 7.3391231e-06, 7.0758264e-06,
 1.4018104e-05, 1.2356739e-05, 2.6277363e-06, 2.8685034e-06, 1.3788575e-05, 7.6611259e-06, 2.8479853e-06, 2.2447511e-06,
 8.5144066e+00, 7.5147902e+00, 2.7017353e+00, 8.7402759e-01, 9.2639763e-01, 4.8454173e-01, 2.0521908e-01, 2.3455419e-01,
 2.1248357e-01, 2.5410369e-01, 3.6679842e-02, 4.7467168e-02, 2.3920798e-01, 1.8030992e-01, 4.5499169e-02, 4.2513455e-02,
 4.0713638e-03, 3.1904197e-03, 1.7181981e-03, 2.7652818e-04, 2.4745829e-04, 1.1491612e-04, 7.2906666e-05, 4.1454938e-05,
 1.3225425e-04, 1.4042371e-04, 3.0363818e-05, 1.9548168e-05, 1.0700768e-04, 7.1615046e-05, 2.7069959e-05, 1.2583287e-05,
 4.7016642e-06, 7.7358531e-06, 7.2277482e-07, 1.9891229e-07, 9.0099746e-08, 8.7851948e-08, 9.6695660e-09, 9.4017437e-09,
 2.7384073e-08, 6.1048850e-08, 2.2901456e-09, 2.5211877e-09, 1.4262690e-08, 2.0041929e-08, 1.3142925e-09, 1.0446991e-09,
 7.7573698e-07, 6.6714695e-07, 1.2829893e-07, 3.7592265e-08, 1.4073443e-08, 7.1726344e-09, 1.6249543e-09, 1.6821290e-09,
 3.6816737e-09, 4.2901795e-09, 3.3125909e-10, 3.8826367e-10, 4.0259865e-09, 2.9570670e-09, 3.9913592e-10, 3.3778199e-10,
 7.9075940e-02, 9.2261908e-02, 1.2043777e-02, 4.1834122e-03, 3.1136666e-03, 2.1528879e-03, 3.3107215e-04, 4.0628726e-04,
 4.0662035e-04, 6.4282114e-04, 3.3691579e-05, 4.6813635e-05, 5.0890455e-04, 5.0710270e-04, 4.6461609e-05, 4.6612519e-05,
 1.8205987e-06, 1.8859815e-06, 3.6878846e-07, 6.3727780e-08, 4.0046150e-08, 2.4584158e-08, 5.6631242e-09, 3.4574076e-09,
 1.2185897e-08, 1.7104248e-08, 1.3428717e-09, 9.2825951e-10, 1.0961243e-08, 9.6976094e-09, 1.3309523e-09, 6.6428509e-10,
 7.0962725e-04, 1.1178603e-03, 1.5835549e-04, 4.7007085e-05, 4.2315966e-05, 3.9503229e-05, 6.5923354e-06, 6.9137265e-06,
 1.2578731e-05, 2.6848310e-05, 1.5270507e-06, 1.8132893e-06, 7.3058092e-06, 9.8289513e-06, 9.7726162e-07, 8.3787907e-07,
 2.1748039e-05, 1.7907210e-05, 5.2213235e-06, 1.6501648e-06, 1.2277446e-06, 5.9908307e-07, 2.0577880e-07, 2.2976849e-07,
 3.1413117e-07, 3.5046285e-07, 4.1028476e-08, 5.1869923e-08, 3.8305961e-07, 2.6937406e-07, 5.5127275e-08, 5.0321562e-08,
 4.8504490e-01, 5.4182697e-01, 1.0723880e-01, 4.0178271e-02, 5.9430811e-02, 3.9342478e-02, 9.1730518e-03, 1.2142163e-02,
 7.5907880e-03, 1.1489164e-02, 9.1299926e-04, 1.3683378e-03, 1.0594058e-02, 1.0107007e-02, 1.4040153e-03, 1.5193284e-03,
 1.8826787e-04, 1.8672414e-04, 5.5359382e-05, 1.0318444e-05, 1.2886205e-05, 7.5739157e-06, 2.6452826e-06, 1.7419583e-06,
 3.8351272e-06, 5.1537914e-06, 6.1349144e-07, 4.5741975e-07, 3.8468964e-06, 3.2584874e-06, 6.7805467e-07, 3.6502971e-07,
 7.2270432e-05, 6.9178386e-05, 8.3606381e-06, 1.8166520e-06, 9.7003316e-07, 5.5025934e-07, 7.8342473e-08, 6.0141241e-08,
 2.5952404e-07, 3.3659704e-07, 1.6333155e-08, 1.4196648e-08, 3.4051514e-07, 2.7837335e-07, 2.3613190e-08, 1.4819294e-08,
 1.4046667e-07, 7.0280359e-08, 1.7482749e-08, 4.0444463e-09, 1.7848978e-09, 5.2923039e-10, 1.5508926e-10, 1.2675754e-10,
 4.1103135e-10, 2.7864963e-10, 2.7830761e-11, 2.5754759e-11, 1.1322901e-09, 4.8383764e-10, 8.4476022e-11, 5.6444714e-11,
 2.3100440e-01, 1.5680200e-01, 2.6476839e-02, 7.2611860e-03, 6.3709178e-03, 2.5627387e-03, 5.0977648e-04, 4.9392856e-04,
 7.3237824e-04, 6.7358075e-04, 4.5666220e-05, 5.0097959e-05, 2.3090770e-03, 1.3386008e-03, 1.5864402e-04, 1.2566249e-04,
 4.3332856e-07, 2.6115226e-07, 6.6055360e-08, 9.0122519e-09, 6.6760254e-09, 2.3843262e-09, 7.1046165e-10, 3.4245913e-10,
 1.7882622e-09, 1.4602620e-09, 1.4829813e-10, 8.0936482e-11, 4.0521853e-09, 2.0856782e-09, 3.7027064e-10, 1.4591005e-10,
 4.8412421e-02, 6.1064593e-02, 2.4492365e-02, 5.0169652e-03, 3.1240604e-03, 2.3351948e-03, 1.1033805e-03, 7.9850641e-04,
 2.2782077e-03, 3.8935772e-03, 6.2701927e-04, 5.1377690e-04, 7.6093843e-04, 8.1971620e-04, 2.3076118e-04, 1.3652542e-04,
 1.6763275e-03, 1.1052033e-03, 9.1241060e-04, 1.9898370e-04, 1.0240837e-04, 4.0011957e-05, 3.8913396e-05, 2.9982583e-05,
 6.4280608e-05, 5.7423007e-05, 1.9033785e-05, 1.6604881e-05, 4.5077505e-05, 2.5381916e-05, 1.4707227e-05, 9.2639980e-06,
 1.2660210e+01, 1.1323868e+01, 6.3457374e+00, 1.6405945e+00, 1.6786461e+00, 8.8978341e-01, 5.8739773e-01, 5.3653068e-01,
 5.2598776e-01, 6.3745935e-01, 1.4342680e-01, 1.4833144e-01, 4.2215858e-01, 3.2248631e-01, 1.2683993e-01, 9.4714421e-02,
 1.4380001e-02, 1.1419793e-02, 9.5861619e-03, 1.2329569e-03, 1.0651140e-03, 5.0126420e-04, 4.9569449e-04, 2.2524771e-04,
 7.7766460e-04, 8.3678607e-04, 2.8202781e-04, 1.4510373e-04, 4.4858760e-04, 3.0424840e-04, 1.7925554e-04, 6.6591143e-05,
 9.1097150e-06, 1.5189829e-05, 2.2121209e-06, 4.8652428e-07, 2.1274147e-07, 2.1021872e-07, 3.6065180e-08, 2.8023774e-08,
 8.8331390e-08, 1.9956582e-07, 1.1668981e-08, 1.0266251e-08, 3.2799568e-08, 4.6708707e-08, 4.7743190e-09, 3.0328273e-09,
 1.8513221e-06, 1.6135444e-06, 4.8366385e-07, 1.1325470e-07, 4.0930160e-08, 2.1140410e-08, 7.4651231e-09, 6.1757878e-09,
 1.4627728e-08, 1.7274231e-08, 2.0789892e-09, 1.9473695e-09, 1.1403910e-08, 8.4885606e-09, 1.7858902e-09, 1.2078357e-09,
 1.0187597e-01, 1.2045959e-01, 2.4509976e-02, 6.8037411e-03, 4.8884906e-03, 3.4254343e-03, 8.2106571e-04, 8.0524057e-04,
 8.7212842e-04, 1.3972457e-03, 1.1414717e-04, 1.2675158e-04, 7.7817533e-04, 7.8582950e-04, 1.1222452e-04, 8.9977351e-05,
 5.5715250e-06, 5.8490974e-06, 1.7827480e-06, 2.4619466e-07, 1.4934683e-07, 9.2914207e-08, 3.3361357e-08, 1.6277040e-08,
 6.2084208e-08, 8.8311832e-08, 1.0807142e-08, 5.9701165e-09, 3.9813773e-08, 3.5696829e-08, 7.6363978e-09, 3.0459144e-09,
 7.4298728e-04, 1.1861240e-03, 2.6190095e-04, 6.2130400e-05, 5.3992152e-05, 5.1079969e-05, 1.3286735e-05, 1.1135977e-05,
 2.1925612e-05, 4.7426758e-05, 4.2045643e-06, 3.9899874e-06, 9.0788952e-06, 1.2378362e-05, 1.9183501e-06, 1.3144245e-06,
 2.8046952e-05, 2.3403743e-05, 1.0636507e-05, 2.6864759e-06, 1.9295191e-06, 9.5415672e-07, 5.1085135e-07, 4.5584937e-07,
 6.7443603e-07, 7.6254069e-07, 1.3914496e-07, 1.4058374e-07, 5.8633495e-07, 4.1785602e-07, 1.3329028e-07, 9.7235096e-08,
 3.3768132e-01, 3.8227644e-01, 1.1793154e-01, 3.5310697e-02, 5.0421101e-02, 3.3826247e-02, 1.2293262e-02, 1.3004280e-02,
 8.7978389e-03, 1.3494888e-02, 1.6715233e-03, 2.0020376e-03, 8.7538919e-03, 8.4635590e-03, 1.8325814e-03, 1.5848207e-03,
 3.1133928e-04, 3.1293182e-04, 1.4461113e-04, 2.1540792e-05, 2.5969174e-05, 1.5468388e-05, 8.4208850e-06, 4.4316006e-06,
 1.0558479e-05, 1.4379369e-05, 2.6679813e-06, 1.5897399e-06, 7.5506031e-06, 6.4815485e-06, 2.1022707e-06, 9.0445978e-07,
 1.4493663e-04, 1.4059809e-04, 2.6485591e-05, 4.5991654e-06, 2.3707146e-06, 1.3628617e-06, 3.0244242e-07, 1.8554746e-07,
 8.6648062e-07, 1.1388932e-06, 8.6139836e-08, 5.9835205e-08, 8.1052707e-07, 6.7150668e-07, 8.8784731e-08, 4.4529536e-08,
 3.4698103e-07, 1.7593717e-07, 6.8217321e-08, 1.2611916e-08, 5.3730500e-09, 1.6145212e-09, 7.3746576e-10, 4.8169375e-10,
 1.6903278e-09, 1.1613036e-09, 1.8078966e-10, 1.3370364e-10, 3.3197356e-09, 1.4375963e-09, 3.9122971e-10, 2.0890968e-10,
 3.0804352e-01, 2.1190185e-01, 5.5771255e-02, 1.2223318e-02, 1.0353064e-02, 4.2204890e-03, 1.3085775e-03, 1.0132601e-03,
 1.6258898e-03, 1.5154330e-03, 1.6014126e-04, 1.4039940e-04, 3.6546316e-03, 2.1470783e-03, 3.9662646e-04, 2.5107342e-04,
 1.3725922e-06, 8.3831962e-07, 3.3051020e-07, 3.6036888e-08, 2.5770183e-08, 9.3273156e-09, 4.3320425e-09, 1.6687766e-09,
 9.4301630e-09, 7.8038726e-09, 1.2353109e-09, 5.3879303e-10, 1.5234458e-08, 7.9465103e-09, 2.1989206e-09, 6.9248831e-10,
 4.8389961e-01, 4.5731321e-01, 3.0277662e-01, 6.4971856e-02, 3.8246099e-02, 2.1419865e-02, 1.6706528e-02, 1.2665783e-02,
 3.8362747e-02, 4.9123734e-02, 1.3058425e-02, 1.1209262e-02, 1.5001974e-02, 1.2108446e-02, 5.6267155e-03, 3.4873739e-03,
 1.2929427e+00, 6.3868760e-01, 8.7037031e-01, 1.9884925e-01, 9.6744313e-02, 2.8320797e-02, 4.5465491e-02, 3.6698185e-02,
 8.3525390e-02, 5.5904983e-02, 3.0588421e-02, 2.7955038e-02, 6.8577376e-02, 2.8931545e-02, 2.7672294e-02, 1.8260201e-02,
 3.8367558e+01, 2.5712497e+01, 2.3784745e+01, 6.4418481e+00, 6.2309169e+00, 2.4745889e+00, 2.6966114e+00, 2.5803164e+00,
 2.6854506e+00, 2.4384842e+00, 9.0566018e-01, 9.8120712e-01, 2.5234792e+00, 1.4443126e+00, 9.3772064e-01, 7.3354374e-01,
 1.3591717e+00, 8.0872265e-01, 1.1206073e+00, 1.5099041e-01, 1.2330502e-01, 4.3478801e-02, 7.0972823e-02, 3.3785541e-02,
 1.2383001e-01, 9.9832973e-02, 5.5541670e-02, 2.9936287e-02, 8.3630288e-02, 4.2498181e-02, 4.1331586e-02, 1.6084906e-02,
 1.3202135e-04, 1.6493712e-04, 3.9649844e-05, 9.1354463e-06, 3.7762526e-06, 2.7958002e-06, 7.9175354e-07, 6.4449734e-07,
 2.1566151e-06, 3.6506462e-06, 3.5235764e-07, 3.2475459e-07, 9.3757979e-07, 1.0003772e-06, 1.6878929e-07, 1.1232430e-07,
 2.0703491e-03, 1.3519740e-03, 6.6895720e-04, 1.6409815e-04, 5.6062728e-05, 2.1695529e-05, 1.2646228e-05, 1.0959963e-05,
 2.7558563e-05, 2.4383962e-05, 4.8442345e-06, 4.7535021e-06, 2.5154507e-05, 1.4028851e-05, 4.8720314e-06, 3.4518822e-06,
 4.4764762e-01, 3.9658093e-01, 1.3319891e-01, 3.8734504e-02, 2.6309263e-02, 1.3812596e-02, 5.4651859e-03, 5.6149443e-03,
 6.4559917e-03, 7.7496385e-03, 1.0450601e-03, 1.2156878e-03, 6.7443876e-03, 5.1029283e-03, 1.2029463e-03, 1.0103789e-03,
 7.6353765e-04, 6.0058065e-04, 3.0216183e-04, 4.3714043e-05, 2.5068128e-05, 1.1685141e-05, 6.9256875e-06, 3.5398681e-06,
 1.4333624e-05, 1.5276353e-05, 3.0858779e-06, 1.7858438e-06, 1.0761937e-05, 7.2295756e-06, 2.5529297e-06, 1.0667452e-06,
 5.0509006e-02, 6.0414821e-02, 2.2020017e-02, 5.4723961e-03, 4.4955970e-03, 3.1866421e-03, 1.3682589e-03, 1.2013539e-03,
 2.5110613e-03, 4.0696306e-03, 5.9555233e-04, 5.9205638e-04, 1.2173657e-03, 1.2435904e-03, 3.1813343e-04, 2.2835452e-04,
 1.4712796e-01, 9.1985757e-02, 6.9008370e-02, 1.8259052e-02, 1.2397321e-02, 4.5932967e-03, 4.0594432e-03, 3.7947740e-03,
 5.9603037e-03, 5.0491311e-03, 1.5208575e-03, 1.6097135e-03, 6.0667478e-03, 3.2393871e-03, 1.7056975e-03, 1.3035240e-03,
 6.9601679e+00, 5.9035875e+00, 3.0063235e+00, 9.4298487e-01, 1.2728995e+00, 6.3982541e-01, 3.8383289e-01, 4.2535737e-01,
 3.0549677e-01, 3.5109589e-01, 7.1785441e-02, 9.0071765e-02, 3.5588875e-01, 2.5780539e-01, 9.2144575e-02, 8.3479397e-02,
 2.0014212e-01, 1.5072326e-01, 1.1497394e-01, 1.7941224e-02, 2.0447112e-02, 9.1252497e-03, 8.2002072e-03, 4.5208530e-03,
 1.1434679e-02, 1.1667787e-02, 3.5735403e-03, 2.2306678e-03, 9.5738551e-03, 6.1575774e-03, 3.2967589e-03, 1.4858692e-03,
 6.1978902e-05, 4.5047548e-05, 1.4007756e-05, 2.5481831e-06, 1.2416934e-06, 5.3482629e-07, 1.9591651e-07, 1.2591456e-07,
 6.2422715e-07, 6.1474207e-07, 7.6750491e-08, 5.5850426e-08, 6.8365008e-07, 4.2436814e-07, 9.2618553e-08, 4.8663182e-08,
 1.1449680e-05, 4.3498190e-06, 2.7840416e-06, 5.3920583e-07, 2.1715904e-07, 4.8890797e-08, 3.6863142e-08, 2.5224007e-08,
 9.3967328e-08, 4.8370174e-08, 1.2430052e-08, 9.6302009e-09, 2.1606875e-07, 7.0105360e-08, 3.1492970e-08, 1.7617041e-08,
 3.9939511e-02, 2.0585027e-02, 8.9432314e-03, 2.0533631e-03, 1.6441029e-03, 5.0216769e-04, 2.5701171e-04, 2.0848120e-04,
 3.5514014e-04, 2.4801142e-04, 4.3261890e-05, 3.9733800e-05, 9.3462010e-04, 4.1140092e-04, 1.2544874e-04, 8.3191310e-05,
 5.5504002e-06, 2.5399100e-06, 1.6529548e-06, 1.8880607e-07, 1.2763493e-07, 3.4612642e-08, 2.6536167e-08, 1.0708689e-08,
 6.4242148e-08, 3.9832448e-08, 1.0408078e-08, 4.7556396e-09, 1.2150954e-07, 4.7488220e-08, 2.1691341e-08, 7.1561910e-09,
 1.6449797e-01, 1.6078955e-01, 6.6647896e-02, 9.3500180e-03, 1.1174673e-02, 6.4729653e-03, 3.1607680e-03, 1.5666123e-03,
 6.3241434e-03, 8.3757145e-03, 1.3939314e-03, 7.8225903e-04, 2.7897839e-03, 2.3288921e-03, 6.7754136e-04, 2.7453788e-04,
 6.2390131e-01, 3.1876002e-01, 2.7195639e-01, 4.0620197e-02, 4.0124002e-02, 1.2148516e-02, 1.2210118e-02, 6.4432566e-03,
 1.9545270e-02, 1.3530459e-02, 4.6348841e-03, 2.7692670e-03, 1.8102320e-02, 7.8988514e-03, 4.7299582e-03, 2.0405182e-03,
 3.6327235e+01, 2.5179736e+01, 1.4582276e+01, 2.5820252e+00, 5.0706349e+00, 2.0828233e+00, 1.4209781e+00, 8.8892559e-01,
 1.2330251e+00, 1.1580134e+00, 2.6926422e-01, 1.9072039e-01, 1.3070272e+00, 7.7372193e-01, 3.1449735e-01, 1.6083950e-01,
 3.7282009e-01, 2.2943704e-01, 1.9903859e-01, 1.7532993e-02, 2.9070226e-02, 1.0601900e-02, 1.0834736e-02, 3.3719419e-03,
 1.6471665e-02, 1.3734876e-02, 4.7839773e-03, 1.6857429e-03, 1.2548891e-02, 6.5955516e-03, 4.0158974e-03, 1.0217439e-03,
 9.3258946e-06, 1.2050448e-05, 1.8136211e-06, 2.7318561e-07, 2.2927115e-07, 1.7556319e-07, 3.1127017e-08, 1.6565003e-08,
 7.3876362e-08, 1.2934253e-07, 7.8158300e-09, 4.7094458e-09, 3.6230239e-08, 3.9982100e-08, 4.2234425e-09, 1.8374622e-09,
 2.0759700e-04, 1.4021180e-04, 4.3434486e-05, 6.9656686e-06, 4.8316346e-06, 1.9338772e-06, 7.0573184e-07, 3.9986249e-07,
 1.3400487e-06, 1.2263292e-06, 1.5252742e-07, 9.7849688e-08, 1.3797815e-06, 7.9589413e-07, 1.7304663e-07, 8.0155211e-08,
 8.8073506e-02, 8.0701132e-02, 1.6969476e-02, 3.2261815e-03, 4.4489747e-03, 2.4158256e-03, 5.9843244e-04, 4.0195611e-04,
 6.1596856e-04, 7.6474382e-04, 6.4564702e-05, 4.9101997e-05, 7.2588590e-04, 5.6804677e-04, 8.3836077e-05, 4.6035390e-05,
 4.3520760e-05, 3.5405949e-05, 1.1152299e-05, 1.0547963e-06, 1.2280899e-06, 5.9208106e-07, 2.1970000e-07, 7.3413737e-08,
 3.9619450e-07, 4.3672805e-07, 5.5231895e-08, 2.0896697e-08, 3.3556231e-07, 2.3314953e-07, 5.1544289e-08, 1.4080739e-08,
 1.0310738e-02, 1.2755675e-02, 2.9106994e-03, 4.7291188e-04, 7.8877077e-04, 5.7827647e-04, 1.5544992e-04, 8.9231055e-05,
 2.4857926e-04, 4.1667881e-04, 3.8175621e-05, 2.4811465e-05, 1.3594364e-04, 1.4363289e-04, 2.3004135e-05, 1.0795164e-05,
 4.2633148e-02, 2.7568411e-02, 1.2948300e-02, 2.2398169e-03, 3.0876117e-03, 1.1832000e-03, 6.5466609e-04, 4.0009439e-04,
 8.3754324e-04, 7.3382831e-04, 1.3838411e-04, 9.5756696e-05, 9.6166758e-04, 5.3109312e-04, 1.7507728e-04, 8.7472193e-05,
 3.9573412e+00, 3.4716715e+00, 1.1068229e+00, 2.2697091e-01, 6.2204310e-01, 3.2338993e-01, 1.2145830e-01, 8.7995807e-02,
 8.4231983e-02, 1.0012325e-01, 1.2816380e-02, 1.0513338e-02, 1.1069166e-01, 8.2933813e-02, 1.8557914e-02, 1.0991617e-02,
 3.2966997e-02, 2.5677909e-02, 1.2263063e-02, 1.2510500e-03, 2.8947784e-03, 1.3361852e-03, 7.5173825e-04, 2.7094756e-04,
 9.1337985e-04, 9.6395046e-04, 1.8483528e-04, 7.5429912e-05, 8.6266962e-04, 5.7386050e-04, 1.9235511e-04, 5.6678682e-05,
 2.3452892e-05, 1.7630417e-05, 3.4322575e-06, 4.0819225e-07, 4.0383990e-07, 1.7990636e-07, 4.1259558e-08, 1.7336144e-08,
 1.1454651e-07, 1.1667315e-07, 9.1196646e-09, 4.3385772e-09, 1.4151523e-07, 9.0855408e-08, 1.2414407e-08, 4.2643373e-09,
 6.1500294e-06, 2.4165397e-06, 9.6831850e-07, 1.2260839e-07, 1.0025457e-07, 2.3344909e-08, 1.1019887e-08, 4.9297170e-09,
 2.4476385e-08, 1.3031273e-08, 2.0965341e-09, 1.0619090e-09, 6.3488106e-08, 2.1305448e-08, 5.9920151e-09, 2.1913690e-09,
 4.2093798e-02, 2.2439102e-02, 6.1033537e-03, 9.1614183e-04, 1.4893159e-03, 4.7048459e-04, 1.5075414e-04, 7.9947783e-05,
 1.8151054e-04, 1.3110289e-04, 1.4317464e-05, 8.5969372e-06, 5.3884927e-04, 2.4532198e-04, 4.6833555e-05, 2.0304475e-05,
 1.6947147e-06, 8.0210169e-07, 3.2680745e-07, 2.4404497e-08, 3.3495335e-08, 9.3948178e-09, 4.5093267e-09, 1.1896865e-09,
 9.5121596e-09, 6.1000707e-09, 9.9790257e-10, 2.9809146e-10, 2.0295479e-08, 8.2037787e-09, 2.3460344e-09, 5.0600277e-10,
 3.4022669e-02, 3.5304689e-02, 1.2977690e-02, 2.2380989e-03, 1.4020257e-03, 8.6216625e-04, 3.7335065e-04, 2.2747926e-04,
 8.6622275e-04, 1.2179143e-03, 1.7975145e-04, 1.2400455e-04, 3.2482431e-04, 2.8786855e-04, 7.4270615e-05, 3.6994694e-05,
 6.1770096e-02, 3.3503728e-02, 2.5349239e-02, 4.6544006e-03, 2.4097945e-03, 7.7457943e-04, 6.9039688e-04, 4.4785808e-04,
 1.2815161e-03, 9.4180694e-04, 2.8610446e-04, 2.1013898e-04, 1.0089437e-03, 4.6737274e-04, 2.4819500e-04, 1.3162312e-04,
 1.2110663e+01, 8.9115556e+00, 4.5768215e+00, 9.9621970e-01, 1.0254422e+00, 4.4716528e-01, 2.7054504e-01, 2.0805278e-01,
 2.7222459e-01, 2.7141641e-01, 5.5967698e-02, 4.8731735e-02, 2.4529599e-01, 1.5415494e-01, 5.5568178e-02, 3.4934759e-02,
 6.2067441e-02, 4.0550364e-02, 3.1196426e-02, 3.3781555e-03, 2.9357986e-03, 1.1366545e-03, 1.0301472e-03, 3.9410960e-04,
 1.8160258e-03, 1.6075923e-03, 4.9656598e-04, 2.1509735e-04, 1.1760886e-03, 6.5622476e-04, 3.5434030e-04, 1.1082449e-04,
 5.2016888e-06, 7.1354949e-06, 9.5236574e-07, 1.7634814e-07, 7.7574127e-08, 6.3062015e-08, 9.9153512e-09, 6.4866173e-09,
 2.7288499e-08, 5.0720358e-08, 2.7180189e-09, 2.0132756e-09, 1.1376155e-08, 1.3327743e-08, 1.2485156e-09, 6.6773148e-10,
 5.5428071e-05, 3.9742948e-05, 1.0918085e-05, 2.1524381e-06, 7.8255736e-07, 3.3252004e-07, 1.0761309e-07, 7.4953509e-08,
 2.3694606e-07, 2.3019866e-07, 2.5391017e-08, 2.0023849e-08, 2.0739065e-07, 1.2699923e-07, 2.4487555e-08, 1.3943443e-08,
 7.9182099e-02, 7.7024423e-02, 1.4363270e-02, 3.3568330e-03, 2.4263602e-03, 1.3987106e-03, 3.0726547e-04, 2.5370725e-04,
 3.6674197e-04, 4.8337562e-04, 3.6191009e-05, 3.3834544e-05, 3.6738414e-04, 3.0521313e-04, 3.9947169e-05, 2.6965175e-05,
 1.9539226e-05, 1.6875389e-05, 4.7138763e-06, 5.4807295e-07, 3.3446787e-07, 1.7118751e-07, 5.6332284e-08, 2.3139862e-08,
 1.1779839e-07, 1.3785063e-07, 1.5460512e-08, 7.1906412e-09, 8.4811427e-08, 6.2557929e-08, 1.2264925e-08, 4.1187506e-09,
 1.2288034e-03, 1.6138494e-03, 3.2658273e-04, 6.5227714e-05, 5.7023895e-05, 4.4382165e-05, 1.0580345e-05, 7.4658906e-06,
 1.9619044e-05, 3.4912505e-05, 2.8366279e-06, 2.2663367e-06, 9.1205685e-06, 1.0230192e-05, 1.4530219e-06, 8.3820727e-07,
 2.4321759e-03, 1.6696527e-03, 6.9544605e-04, 1.4788326e-04, 1.0685219e-04, 4.3469595e-05, 2.1329664e-05, 1.6024431e-05,
 3.1642786e-05, 2.9432605e-05, 4.9221735e-06, 4.1869331e-06, 3.0884662e-05, 1.8107367e-05, 5.2935941e-06, 3.2512232e-06,
 7.6019365e-01, 7.0798837e-01, 2.0017141e-01, 5.0460321e-02, 7.2486044e-02, 4.0006218e-02, 1.3324907e-02, 1.1867388e-02,
 1.0715633e-02, 1.3522049e-02, 1.5350034e-03, 1.5478928e-03, 1.1970319e-02, 9.5211432e-03, 1.8893969e-03, 1.3756623e-03,
 3.1624872e-03, 2.6150265e-03, 1.1075203e-03, 1.3889394e-04, 1.6845269e-04, 8.2546068e-05, 4.1184421e-05, 1.8247673e-05,
 5.8025779e-05, 6.5011625e-05, 1.1054965e-05, 5.5459065e-06, 4.6586953e-05, 3.2899774e-05, 9.7797205e-06, 3.5424080e-06,
 6.7543812e-06, 5.3903678e-06, 9.3061937e-07, 1.3605458e-07, 7.0552398e-08, 3.3366902e-08, 6.7862569e-09, 3.5052117e-09,
 2.1846958e-08, 2.3623642e-08, 1.6375375e-09, 9.5766981e-10, 2.2943659e-08, 1.5637849e-08, 1.8949100e-09, 8.0014782e-10,
 8.4785410e-07, 3.5367504e-07, 1.2567971e-07, 1.9562449e-08, 8.3841940e-09, 2.0726021e-09, 8.6763616e-10, 4.7713181e-10,
 2.2346589e-09, 1.2630413e-09, 1.8020593e-10, 1.1220449e-10, 4.9272740e-09, 1.7553820e-09, 4.3781455e-10, 1.9682881e-10,
 1.9540478e-02, 1.1058330e-02, 2.6674044e-03, 4.9219704e-04, 4.1938919e-04, 1.4065096e-04, 3.9967133e-05, 2.6055295e-05,
 5.5800609e-05, 4.2787439e-05, 4.1438726e-06, 3.0587217e-06, 1.4081682e-04, 6.8059743e-05, 1.1522524e-05, 6.1409900e-06,
 3.9286425e-07, 1.9739770e-07, 7.1324875e-08, 6.5474924e-09, 4.7102433e-09, 1.4025374e-09, 5.9699979e-10, 1.9362027e-10,
 1.4603098e-09, 9.9418574e-10, 1.4423057e-10, 5.2963243e-11, 2.6485944e-09, 1.1365719e-09, 2.8823950e-10, 7.6423728e-11,
 8.6370348e-02, 9.0828103e-02, 5.2041078e-02, 7.1724136e-03, 4.3373811e-03, 2.7030526e-03, 1.8244892e-03, 8.8838895e-04,
 3.6609136e-03, 5.2163678e-03, 1.2000105e-03, 6.6158778e-04, 9.7871995e-04, 8.7901359e-04, 3.5349198e-04, 1.4071455e-04,
 1.9314757e-01, 1.0616849e-01, 1.2520701e-01, 1.8372335e-02, 9.1826131e-03, 2.9911890e-03, 4.1556371e-03, 2.1543514e-03,
 6.6711224e-03, 4.9685333e-03, 2.3526214e-03, 1.3809291e-03, 3.7444792e-03, 1.7578399e-03, 1.4550243e-03, 6.1666152e-04,
 2.0442712e+01, 1.5244584e+01, 1.2203577e+01, 2.1228309e+00, 2.1093924e+00, 9.3219263e-01, 8.7909966e-01, 5.4026786e-01,
 7.6500066e-01, 7.7296863e-01, 2.4844167e-01, 1.7287653e-01, 4.9144475e-01, 3.1299207e-01, 1.7585826e-01, 8.8355069e-02,
 2.4886664e-01, 1.6477420e-01, 1.9758800e-01, 1.7099067e-02, 1.4345127e-02, 5.6285706e-03, 7.9511551e-03, 2.4310002e-03,
 1.2122407e-02, 1.0875123e-02, 5.2359612e-03, 1.8125571e-03, 5.5970171e-03, 3.1649051e-03, 2.6637269e-03, 6.6579737e-04,
 1.1441472e-05, 1.5905711e-05, 3.3089755e-06, 4.8966371e-07, 2.0793588e-07, 1.7130577e-07, 4.1982988e-08, 2.1949294e-08,
 9.9926519e-08, 1.8822396e-07, 1.5721943e-08, 9.3066603e-09, 2.9699313e-08, 3.5261372e-08, 5.1486998e-09, 2.2006071e-09,
 1.5016957e-04, 1.0911987e-04, 4.6725193e-05, 7.3616051e-06, 2.5837084e-06, 1.1125935e-06, 5.6123534e-07, 3.1239857e-07,
 1.0687231e-06, 1.0522289e-06, 1.8090410e-07, 1.1401265e-07, 6.6689104e-07, 4.1386455e-07, 1.2438375e-07, 5.6601176e-08,
 1.1580804e-01, 1.1416466e-01, 3.3183146e-02, 6.1977091e-03, 4.3245641e-03, 2.5264229e-03, 8.6507360e-04, 5.7083351e-04,
 8.9296810e-04, 1.1927562e-03, 1.3919655e-04, 1.0399811e-04, 6.3774280e-04, 5.3693261e-04, 1.0953781e-04, 5.9090554e-05,
 6.7881472e-05, 5.9414091e-05, 2.5868730e-05, 2.4036565e-06, 1.4160338e-06, 7.3448514e-07, 3.7672929e-07, 1.2367151e-07,
 6.8131379e-07, 8.0799396e-07, 1.4124876e-07, 5.2500700e-08, 3.4971304e-07, 2.6141553e-07, 7.9886787e-08, 2.1439412e-08,
 1.4605545e-03, 1.9439711e-03, 6.1317053e-04, 9.7871708e-05, 8.2597607e-05, 6.5149415e-05, 2.4208231e-05, 1.3651537e-05,
 3.8821902e-05, 7.0011835e-05, 8.8665353e-06, 5.6612607e-06, 1.2866803e-05, 1.4625951e-05, 3.2379749e-06, 1.4927597e-06,
 3.5607783e-03, 2.4772365e-03, 1.6082960e-03, 2.7331197e-04, 1.9063766e-04, 7.8596357e-05, 6.0112093e-05, 3.6090877e-05,
 7.7123815e-05, 7.2699936e-05, 1.8950612e-05, 1.2882476e-05, 5.3666852e-05, 3.1886755e-05, 1.4530039e-05, 7.1318154e-06,
 6.0080516e-01, 5.6705762e-01, 2.4989884e-01, 5.0344187e-02, 6.9813475e-02, 3.9048434e-02, 2.0272241e-02, 1.4428778e-02,
 1.4099088e-02, 1.8030483e-02, 3.1903282e-03, 2.5710092e-03, 1.1228683e-02, 9.0511527e-03, 2.7996179e-03, 1.6290124e-03,
 5.9370516e-03, 4.9751880e-03, 3.2843242e-03, 3.2916609e-04, 3.8538547e-04, 1.9138378e-04, 1.4883420e-04, 5.2700480e-05,
 1.8135379e-04, 2.0591515e-04, 5.4577775e-05, 2.1881043e-05, 1.0380532e-04, 7.4291634e-05, 3.4421870e-05, 9.9642346e-06,
 1.5377548e-05, 1.2436882e-05, 3.3467733e-06, 3.9102502e-07, 1.9574409e-07, 9.3817608e-08, 2.9741296e-08, 1.2276680e-08,
 8.2804998e-08, 9.0741072e-08, 9.8041394e-09, 4.5821686e-09, 6.1998015e-08, 4.2823658e-08, 8.0882850e-09, 2.7294496e-09,
 2.3775928e-06, 1.0051075e-06, 5.5671677e-07, 6.9251499e-08, 2.8651869e-08, 7.1779325e-09, 4.6836239e-09, 2.0583525e-09,
 1.0432572e-08, 5.9757068e-09, 1.3289292e-09, 6.6127218e-10, 1.6399726e-08, 5.9209731e-09, 2.3018280e-09, 8.2700523e-10,
 2.9580874e-02, 1.6965117e-02, 6.3784807e-03, 9.4059910e-04, 7.7369211e-04, 2.6295738e-04, 1.1646801e-04, 6.0678803e-05,
 1.4063018e-04, 1.0928169e-04, 1.6496751e-05, 9.7312657e-06, 2.5301360e-04, 1.2392850e-04, 3.2703153e-05, 1.3928926e-05,
 1.4127032e-06, 7.1935307e-07, 4.0513711e-07, 2.9721662e-08, 2.0640828e-08, 6.2285874e-09, 4.1324756e-09, 1.0710860e-09,
 8.7421280e-09, 6.0315851e-09, 1.3638986e-09, 4.0025479e-10, 1.1304134e-08, 4.9159806e-09, 1.9432470e-09, 4.1175581e-10,
 1.0067296e+01, 1.1258506e+01, 7.8491995e+00, 3.2127186e+00, 3.8904161e+00, 2.5783104e+00, 2.1175839e+00, 3.0621814e+00,
 5.0404230e+00, 7.6376130e+00, 2.1379284e+00, 3.5004498e+00, 2.4363798e+00, 2.3269899e+00, 1.1386676e+00, 1.3461232e+00,
 1.0367984e+01, 6.0605571e+00, 8.6968881e+00, 3.7899055e+00, 3.7930732e+00, 1.3139566e+00, 2.2212286e+00, 3.4197999e+00,
 4.2299242e+00, 3.3502262e+00, 1.9302629e+00, 3.3648386e+00, 4.2927404e+00, 2.1430613e+00, 2.1584599e+00, 2.7167455e+00,
 7.5623049e+01, 5.9971320e+01, 5.8416260e+01, 3.0177995e+01, 6.0047269e+01, 2.8219790e+01, 3.2382087e+01, 5.9102306e+01,
 3.3427714e+01, 3.5918570e+01, 1.4047531e+01, 2.9029524e+01, 3.8826538e+01, 2.6296606e+01, 1.7978261e+01, 2.6825310e+01,
 4.4145628e+00, 3.1082963e+00, 4.5353645e+00, 1.1656081e+00, 1.9581490e+00, 8.1705600e-01, 1.4044368e+00, 1.2752209e+00,
 2.5400303e+00, 2.4232400e+00, 1.4196360e+00, 1.4594885e+00, 2.1203912e+00, 1.2750648e+00, 1.3058095e+00, 9.6930591e-01,
 2.7006505e-02, 3.9925637e-02, 1.0106735e-02, 4.4416428e-03, 3.7769073e-03, 3.3089571e-03, 9.8675847e-04, 1.5320983e-03,
 2.7860972e-03, 5.5808806e-03, 5.6722109e-04, 9.9716879e-04, 1.4971702e-03, 1.8903240e-03, 3.3585597e-04, 4.2631083e-04,
 1.6323934e-01, 1.2614180e-01, 6.5724140e-02, 3.0752076e-02, 2.1612591e-02, 9.8971963e-03, 6.0748986e-03, 1.0042263e-02,
 1.3722625e-02, 1.4367936e-02, 3.0057367e-03, 5.6257993e-03, 1.5482333e-02, 1.0217668e-02, 3.7365932e-03, 5.0497042e-03,
 8.6754641e+00, 9.0948948e+00, 3.2166395e+00, 1.7842032e+00, 2.4929676e+00, 1.5487908e+00, 6.4529475e-01, 1.2645703e+00,
 7.9016709e-01, 1.1223981e+00, 1.5938316e-01, 3.5364515e-01, 1.0203237e+00, 9.1353353e-01, 2.2677068e-01, 3.6330359e-01,
 2.4384309e-02, 2.2696596e-02, 1.2024440e-02, 3.3181082e-03, 3.9142907e-03, 2.1591094e-03, 1.3475337e-03, 1.3137368e-03,
 2.8909148e-03, 3.6459334e-03, 7.7553888e-04, 8.5607663e-04, 2.6829294e-03, 2.1327556e-03, 7.9305480e-04, 6.3207636e-04,
 3.7662726e+00, 5.3308438e+00, 2.0460023e+00, 9.6986274e-01, 1.6390101e+00, 1.3747930e+00, 6.2159581e-01, 1.0410107e+00,
 1.1824965e+00, 2.2678110e+00, 3.4946820e-01, 6.6266684e-01, 7.0860305e-01, 8.5658170e-01, 2.3074740e-01, 3.1592322e-01,
 4.2285860e+00, 3.1284575e+00, 2.4714237e+00, 1.2472923e+00, 1.7421255e+00, 7.6380997e-01, 7.1082609e-01, 1.2674399e+00,
 1.0818521e+00, 1.0844904e+00, 3.4398034e-01, 6.9444528e-01, 1.3611160e+00, 8.6002572e-01, 4.7685498e-01, 6.9510092e-01,
 4.9169426e+01, 4.9351565e+01, 2.6464059e+01, 1.5833245e+01, 4.3966405e+01, 2.6151573e+01, 1.6520164e+01, 3.4919711e+01,
 1.3629546e+01, 1.8535747e+01, 3.9907699e+00, 9.5510992e+00, 1.9625861e+01, 1.6823481e+01, 6.3318342e+00, 1.0941667e+01,
 2.3299003e+00, 2.0762917e+00, 1.6677985e+00, 4.9641025e-01, 1.1638102e+00, 6.1461682e-01, 5.8159469e-01, 6.1159017e-01,
 8.4066382e-01, 1.0150709e+00, 3.2737249e-01, 3.8978305e-01, 8.7001083e-01, 6.6215103e-01, 3.7331055e-01, 3.2092826e-01,
 5.0775156e-02, 4.3670490e-02, 1.4299514e-02, 4.9616698e-03, 4.9736262e-03, 2.5350187e-03, 9.7785675e-04, 1.1987391e-03,
 3.2296069e-03, 3.7636516e-03, 4.9480428e-04, 6.8678898e-04, 4.3719995e-03, 3.2114301e-03, 7.3805669e-04, 7.3966814e-04,
 3.6154149e-03, 1.6253439e-03, 1.0954329e-03, 4.0467750e-04, 3.3526942e-04, 8.9320752e-05, 7.0917520e-05, 9.2559268e-05,
 1.8738756e-04, 1.1414353e-04, 3.0887468e-05, 4.5644563e-05, 5.3259297e-04, 2.0448645e-04, 9.6730283e-05, 1.0321110e-04,
 3.0998631e+00, 1.8906053e+00, 8.6492746e-01, 3.7878723e-01, 6.2390753e-01, 2.2550160e-01, 1.2153168e-01, 1.8803907e-01,
 1.7407618e-01, 1.4385351e-01, 2.6423491e-02, 4.6290220e-02, 5.6625752e-01, 2.9495361e-01, 9.4708819e-02, 1.1979722e-01,
 7.0988430e-04, 3.8440683e-04, 2.6343262e-04, 5.7394332e-05, 7.9814956e-05, 2.5612920e-05, 2.0677505e-05, 1.5916244e-05,
 5.1889913e-05, 3.8072327e-05, 1.0475593e-05, 9.1298066e-06, 1.2131447e-04, 5.6104507e-05, 2.6985714e-05, 1.6981423e-05,
 4.1073125e+00, 4.7507757e+00, 2.0736192e+00, 5.5488046e-01, 1.3642167e+00, 9.3510724e-01, 4.8082453e-01, 4.5456916e-01,
 9.9723699e-01, 1.5628890e+00, 2.7389454e-01, 2.9318187e-01, 5.4375943e-01, 5.3714928e-01, 1.6455739e-01, 1.2718276e-01,
 6.0044073e+00, 3.6301772e+00, 3.2613619e+00, 9.2915089e-01, 1.8880345e+00, 6.7645454e-01, 7.1593037e-01, 7.2061114e-01,
 1.1879423e+00, 9.7314049e-01, 3.5102498e-01, 4.0004483e-01, 1.3599646e+00, 7.0220881e-01, 4.4278797e-01, 3.6435413e-01,
 8.5933372e+01, 7.0483941e+01, 4.2983350e+01, 1.4517097e+01, 5.8646675e+01, 2.8506439e+01, 2.0479235e+01, 2.4436346e+01,
 1.8420481e+01, 2.0471621e+01, 5.0124846e+00, 6.7719860e+00, 2.4135327e+01, 1.6906857e+01, 7.2365378e+00, 7.0591286e+00,
 1.4532908e+00, 1.0583425e+00, 9.6679772e-01, 1.6244222e-01, 5.5405503e-01, 2.3910991e-01, 2.5731675e-01, 1.5274762e-01,
 4.0549931e-01, 4.0011679e-01, 1.4675297e-01, 9.8635656e-02, 3.8185406e-01, 2.3749401e-01, 1.5227199e-01, 7.3896506e-02,
 2.2895700e-03, 3.5008752e-03, 5.5482436e-04, 1.5940839e-04, 2.7521015e-04, 2.4937806e-04, 4.6558375e-05, 4.7260306e-05,
 1.1454306e-04, 2.3730888e-04, 1.5100236e-05, 1.7354931e-05, 6.9434266e-05, 9.0672963e-05, 1.0085897e-05, 8.3697185e-06,
 1.9644542e-02, 1.5700558e-02, 5.1215415e-03, 1.5666550e-03, 2.2354572e-03, 1.0587919e-03, 4.0687149e-04, 4.3971659e-04,
 8.0083115e-04, 8.6723542e-04, 1.1358305e-04, 1.3898559e-04, 1.0192248e-03, 6.9570421e-04, 1.5928263e-04, 1.4072833e-04,
 2.0485250e+00, 2.2211875e+00, 4.9182389e-01, 1.7835070e-01, 5.0595000e-01, 3.2510432e-01, 8.4802369e-02, 1.0864655e-01,
 9.0480370e-02, 1.3292935e-01, 1.1817791e-02, 1.7142916e-02, 1.3179635e-01, 1.2204748e-01, 1.8967550e-02, 1.9866292e-02,
 1.6680764e-03, 1.6058515e-03, 5.3263441e-04, 9.6089947e-05, 2.3014482e-04, 1.3129907e-04, 5.1303449e-05, 3.2699269e-05,
 9.5901963e-05, 1.2509496e-04, 1.6659210e-05, 1.2022274e-05, 1.0039954e-04, 8.2547231e-05, 1.9216943e-05, 1.0013219e-05,
 9.2272478e-01, 1.3508134e+00, 3.2458271e-01, 1.0058948e-01, 3.4513167e-01, 2.9941876e-01, 8.4755884e-02, 9.2798309e-02,
 1.4049051e-01, 2.7867177e-01, 2.6885227e-02, 3.3329152e-02, 9.4968687e-02, 1.1873670e-01, 2.0025014e-02, 1.7924237e-02,
 1.4705758e+00, 1.1252809e+00, 5.5654217e-01, 1.8362932e-01, 5.2073145e-01, 2.3613408e-01, 1.3758027e-01, 1.6037748e-01,
 1.8245116e-01, 1.8916606e-01, 3.7563913e-02, 4.9579054e-02, 2.5894277e-01, 1.6922286e-01, 5.8742678e-02, 5.5980709e-02,
 3.3552007e+01, 3.4830774e+01, 1.1693339e+01, 4.5737784e+00, 2.5786173e+01, 1.5863632e+01, 6.2739204e+00, 8.6699823e+00,
 4.5101567e+00, 6.3439396e+00, 8.5511661e-01, 1.3379662e+00, 7.3260325e+00, 6.4952366e+00, 1.5304824e+00, 1.7290420e+00,
 4.6059361e-01, 4.2452945e-01, 2.1349256e-01, 4.1543472e-02, 1.9774479e-01, 1.0801053e-01, 6.3988514e-02, 4.3991119e-02,
 8.0591517e-02, 1.0064729e-01, 2.0322075e-02, 1.5818731e-02, 9.4085331e-02, 7.4061638e-02, 2.6141255e-02, 1.4692203e-02,
 2.3059155e-02, 2.0512520e-02, 4.2050607e-03, 9.5389751e-04, 1.9413680e-03, 1.0234218e-03, 2.4715446e-04, 1.9808012e-04,
 7.1126011e-04, 8.5728828e-04, 7.0561987e-05, 6.4030004e-05, 1.0861486e-03, 8.2517560e-04, 1.1872916e-04, 7.7790653e-05,
 2.3306733e-03, 1.0836963e-03, 4.5726478e-04, 1.1043687e-04, 1.8576320e-04, 5.1186714e-05, 2.5443572e-05, 2.1710384e-05,
 5.8580223e-05, 3.6906266e-05, 6.2524622e-06, 6.0406106e-06, 1.8781730e-04, 7.4583624e-05, 2.2088258e-05, 1.5408077e-05,
 3.9210053e+00, 2.4734013e+00, 7.0842403e-01, 2.0282989e-01, 6.7829345e-01, 2.5356300e-01, 8.5555004e-02, 8.6542085e-02,
 1.0677776e-01, 9.1264286e-02, 1.0495195e-02, 1.2020222e-02, 3.9181919e-01, 2.1108826e-01, 4.2434687e-02, 3.5091356e-02,
 2.6013535e-04, 1.4569408e-04, 6.2508653e-05, 8.9035351e-06, 2.5138456e-05, 8.3435765e-06, 4.2170750e-06, 2.1221534e-06,
 9.2210765e-06, 6.9975631e-06, 1.2054133e-06, 6.8681812e-07, 2.4318763e-05, 1.1632287e-05, 3.5028496e-06, 1.4410687e-06,
 2.0351230e+00, 2.4989888e+00, 9.6730881e-01, 3.1819361e-01, 4.1004343e-01, 2.9838335e-01, 1.3606181e-01, 1.5812680e-01,
 3.2722876e-01, 5.4443778e-01, 8.4613498e-02, 1.1133954e-01, 1.5167359e-01, 1.5906155e-01, 4.3213931e-02, 4.1057339e-02,
 1.4241570e+00, 9.1407573e-01, 7.2826575e-01, 2.5505469e-01, 2.7165076e-01, 1.0332525e-01, 9.6978346e-02, 1.1999448e-01,
 1.8659636e-01, 1.6227456e-01, 5.1909739e-02, 7.2723622e-02, 1.8158733e-01, 9.9538558e-02, 5.5661771e-02, 5.6304207e-02,
 6.8631388e+01, 5.9761002e+01, 3.2319465e+01, 1.3418374e+01, 2.8413038e+01, 1.4661686e+01, 9.3409550e+00, 1.3701550e+01,
 9.7427577e+00, 1.1494766e+01, 2.4959575e+00, 4.1453022e+00, 1.0851366e+01, 8.0697664e+00, 3.0631284e+00, 3.6731732e+00,
 5.7961822e-01, 4.4810786e-01, 3.6301833e-01, 7.4980406e-02, 1.3404666e-01, 6.1414053e-02, 5.8610360e-02, 4.2769756e-02,
 1.0710256e-01, 1.1219234e-01, 3.6492185e-02, 3.0151067e-02, 8.5734872e-02, 5.6608192e-02, 3.2187196e-02, 1.9201852e-02,
 3.0593807e-03, 4.9661822e-03, 6.9797177e-04, 2.4651858e-04, 2.2307827e-04, 2.1459396e-04, 3.5529888e-05, 4.4335171e-05,
 1.0136034e-04, 2.2293602e-04, 1.2580167e-05, 1.7773848e-05, 5.2230402e-05, 7.2409252e-05, 7.1427806e-06, 7.2865119e-06,
 1.2565387e-02, 1.0661438e-02, 3.0841679e-03, 1.1597559e-03, 8.6738843e-04, 4.3613882e-04, 1.4863049e-04, 1.9746006e-04,
 3.3923057e-04, 3.8999399e-04, 4.5297142e-05, 6.8136985e-05, 3.6700701e-04, 2.6594739e-04, 5.3997746e-05, 5.8646866e-05,
 4.4121327e+00, 5.0787763e+00, 9.9728680e-01, 4.4457094e-01, 6.6104029e-01, 4.5093097e-01, 1.0431139e-01, 1.6428413e-01,
 1.2905693e-01, 2.0128672e-01, 1.5869632e-02, 2.8299006e-02, 1.5980143e-01, 1.5709884e-01, 2.1651697e-02, 2.7877474e-02,
 1.7941220e-03, 1.8336146e-03, 5.3934718e-04, 1.1961156e-04, 1.5015873e-04, 9.0944770e-05, 3.1513663e-05, 2.4691452e-05,
 6.8309878e-05, 9.4593781e-05, 1.1171558e-05, 9.9106433e-06, 6.0790812e-05, 5.3061023e-05, 1.0954533e-05, 7.0167974e-06,
 2.6344527e-01, 4.0943061e-01, 8.7246215e-02, 3.3237619e-02, 5.9774549e-02, 5.5052544e-02, 1.3819885e-02, 1.8600754e-02,
 2.6563503e-02, 5.5936846e-02, 4.7858067e-03, 7.2932564e-03, 1.5264013e-02, 2.0260035e-02, 3.0301521e-03, 3.3341727e-03,
 2.0098331e-01, 1.6326786e-01, 7.1610016e-02, 2.9045168e-02, 4.3171767e-02, 2.0783160e-02, 1.0738551e-02, 1.5388230e-02,
 1.6513507e-02, 1.8176187e-02, 3.2008605e-03, 5.1933830e-03, 1.9922640e-02, 1.3821935e-02, 4.2550060e-03, 4.9847189e-03,
 1.5440613e+01, 1.7016723e+01, 5.0662627e+00, 2.4360158e+00, 7.1985707e+00, 4.7014161e+00, 1.6489268e+00, 2.8011523e+00,
 1.3745405e+00, 2.0525407e+00, 2.4535478e-01, 4.7192209e-01, 1.8979521e+00, 1.7863982e+00, 3.7329121e-01, 5.1841898e-01,
 1.0585042e-01, 1.0357359e-01, 4.6191356e-02, 1.1049353e-02, 2.7567230e-02, 1.5985313e-02, 8.3983371e-03, 7.0976151e-03,
 1.2265476e-02, 1.6261622e-02, 2.9118303e-03, 2.7862852e-03, 1.2172140e-02, 1.0171972e-02, 3.1840103e-03, 2.1998407e-03,
 1.5909548e-02, 1.5024507e-02, 2.7314281e-03, 7.6168481e-04, 8.1252280e-04, 4.5472526e-04, 9.7386667e-05, 9.5946239e-05,
 3.2498473e-04, 4.1584186e-04, 3.0353497e-05, 3.3859264e-05, 4.2186552e-04, 3.4024971e-04, 4.3415562e-05, 3.4968044e-05,
 7.6975156e-04, 3.7996495e-04, 1.4218052e-04, 4.2212632e-05, 3.7217079e-05, 1.0886959e-05, 4.7991463e-06, 5.0339504e-06,
 1.2812686e-05, 8.5695136e-06, 1.2874885e-06, 1.5290761e-06, 3.4920068e-05, 1.4721411e-05, 3.8663761e-06, 3.3154838e-06,
 4.3605364e+00, 2.9201412e+00, 7.4171800e-01, 2.6105589e-01, 4.5758674e-01, 1.8159692e-01, 5.4338072e-02, 6.7568145e-02,
 7.8639952e-02, 7.1355935e-02, 7.2770588e-03, 1.0245523e-02, 2.4530045e-01, 1.4029547e-01, 2.5011319e-02, 2.5425638e-02,
 1.4446766e-04, 8.5897383e-05, 3.2682446e-05, 5.7225952e-06, 8.4688243e-06, 2.9840325e-06, 1.3375159e-06, 8.2740901e-07,
 3.3913510e-06, 2.7321515e-06, 4.1737877e-07, 2.9234262e-07, 7.6029607e-06, 3.8607670e-06, 1.0310177e-06, 5.2141690e-07,
 2.1212143e+00, 2.6396701e+00, 1.5926178e+00, 4.1867332e-01, 5.2083353e-01, 3.8409199e-01, 2.7299705e-01, 2.5355042e-01,
 5.6781795e-01, 9.5740832e-01, 2.3192625e-01, 2.4389160e-01, 1.8763645e-01, 1.9941778e-01, 8.4446899e-02, 6.4119157e-02,
 1.8283803e+00, 1.1892752e+00, 1.4768998e+00, 4.1336285e-01, 4.2500577e-01, 1.6382561e-01, 2.3966878e-01, 2.3699258e-01,
 3.9881876e-01, 3.5149115e-01, 1.7525638e-01, 1.9621744e-01, 2.7669896e-01, 1.5371104e-01, 1.3397743e-01, 1.0830602e-01,
 4.7565386e+01, 4.1973722e+01, 3.5382219e+01, 1.1739719e+01, 2.3997232e+01, 1.2549284e+01, 1.2461984e+01, 1.4608405e+01,
 1.1241228e+01, 1.3440742e+01, 4.5490590e+00, 6.0377857e+00, 8.9261872e+00, 6.7271977e+00, 3.9801502e+00, 3.8142820e+00,
 9.5420719e-01, 7.4760929e-01, 9.4402112e-01, 1.5582529e-01, 2.6892544e-01, 1.2486341e-01, 1.8573886e-01, 1.0831836e-01,
 2.9353783e-01, 3.1161563e-01, 1.5798540e-01, 1.0431741e-01, 1.6752185e-01, 1.1209467e-01, 9.9345902e-02, 4.7363854e-02,
 2.7629194e-03, 4.5451600e-03, 9.9569299e-04, 2.8104401e-04, 2.4550907e-04, 2.3934217e-04, 6.1766997e-05, 6.1595398e-05,
 1.5239354e-04, 3.3968038e-04, 2.9877037e-05, 3.3734146e-05, 5.5984996e-05, 7.8656417e-05, 1.2093957e-05, 9.8595653e-06,
 1.3977370e-02, 1.2018683e-02, 5.4192599e-03, 1.6285678e-03, 1.1758135e-03, 5.9915768e-04, 3.1826244e-04, 3.3790446e-04,
 6.2821506e-04, 7.3191864e-04, 1.3250639e-04, 1.5928908e-04, 4.8454871e-04, 3.5583644e-04, 1.1261379e-04, 9.7745729e-05,
 2.6494619e+00, 3.0907219e+00, 9.4597972e-01, 3.3700792e-01, 4.8374038e-01, 3.3441515e-01, 1.2057821e-01, 1.5176429e-01,
 1.2901920e-01, 2.0392928e-01, 2.5060639e-02, 3.5713625e-02, 1.1389468e-01, 1.1347161e-01, 2.4376268e-02, 2.5082212e-02,
 2.5591377e-03, 2.6505822e-03, 1.2152416e-03, 2.1537953e-04, 2.6101626e-04, 1.6020877e-04, 8.6530389e-05, 5.4181764e-05,
 1.6221426e-04, 2.2764569e-04, 4.1905556e-05, 2.9709613e-05, 1.0291842e-04, 9.1037934e-05, 2.9295549e-05, 1.4996296e-05,
 1.2856512e-01, 2.0249050e-01, 6.7256144e-02, 2.0476339e-02, 3.5548746e-02, 3.3180027e-02, 1.2982707e-02, 1.3964592e-02,
 2.1581497e-02, 4.6055984e-02, 6.1419219e-03, 7.4801071e-03, 8.8412772e-03, 1.1892631e-02, 2.7724474e-03, 2.4379460e-03,
 1.2081127e-01, 9.9457970e-02, 6.7994493e-02, 2.2039980e-02, 3.1624423e-02, 1.5428585e-02, 1.2425705e-02, 1.4229878e-02,
 1.6525343e-02, 1.8433409e-02, 5.0597690e-03, 6.5607157e-03, 1.4213721e-02, 9.9935866e-03, 4.7952756e-03, 4.4894315e-03,
 5.0103896e+00, 5.5959566e+00, 2.5968539e+00, 9.9787680e-01, 2.8466124e+00, 1.8840939e+00, 1.0299979e+00, 1.3983266e+00,
 7.4255436e-01, 1.1237098e+00, 2.0937168e-01, 3.2183313e-01, 7.3098032e-01, 6.9725250e-01, 2.2710202e-01, 2.5205256e-01,
 8.1589075e-02, 8.0905908e-02, 5.6240967e-02, 1.0751426e-02, 2.5894528e-02, 1.5216946e-02, 1.2461224e-02, 8.4162176e-03,
 1.5739379e-02, 2.1147486e-02, 5.9023100e-03, 4.5135524e-03, 1.1135762e-02, 9.4308251e-03, 4.6012948e-03, 2.5405858e-03,
 1.4871578e-02, 1.4232819e-02, 4.0331240e-03, 8.9880226e-04, 9.2557157e-04, 5.2494658e-04, 1.7523734e-04, 1.3797231e-04,
 5.0573832e-04, 6.5581692e-04, 7.4614669e-05, 6.6516618e-05, 4.6804405e-04, 3.8256222e-04, 7.6087016e-05, 4.8974913e-05,
 8.8626636e-04, 4.4335241e-04, 2.5858696e-04, 6.1354450e-05, 5.2219364e-05, 1.5480577e-05, 1.0636669e-05, 8.9163693e-06,
 2.4559406e-05, 1.6646598e-05, 3.8982856e-06, 3.6999561e-06, 4.7720251e-05, 2.0387716e-05, 8.3461137e-06, 5.7195811e-06,
 2.7102742e+00, 1.8393676e+00, 7.2822384e-01, 2.0483153e-01, 3.4659482e-01, 1.3939544e-01, 6.5013806e-02, 6.4607135e-02,
 8.1373024e-02, 7.4827085e-02, 1.1894490e-02, 1.3383241e-02, 1.8096112e-01, 1.0488711e-01, 2.9145822e-02, 2.3678203e-02,
 2.1329303e-04, 1.2852195e-04, 7.6220717e-05, 1.0665685e-05, 1.5237177e-05, 5.4409699e-06, 3.8013044e-06, 1.8792796e-06,
 8.3357063e-06, 6.8055932e-06, 1.6205129e-06, 9.0709246e-07, 1.3323004e-05, 6.8562133e-06, 2.8538952e-06, 1.1534380e-06,
 9.8322607e-02, 1.0012311e-01, 7.5038520e-02, 2.6923292e-02, 7.5796254e-03, 4.5740385e-03, 4.0384111e-03, 5.1191408e-03,
 1.5606630e-02, 2.1533426e-02, 6.4796824e-03, 9.2999559e-03, 4.6633238e-03, 4.0556296e-03, 2.1333686e-03, 2.2108044e-03,
 1.3395126e-01, 7.1298179e-02, 1.0998543e-01, 4.2014200e-02, 9.7758557e-03, 3.0835985e-03, 5.6037076e-03, 7.5627372e-03,
 1.7325551e-02, 1.2495154e-02, 7.7390766e-03, 1.1825878e-02, 1.0869196e-02, 4.9409495e-03, 5.3496478e-03, 5.9023700e-03,
 1.1155706e+01, 8.0556311e+00, 8.4351927e+00, 3.8198665e+00, 1.7670428e+00, 7.5617248e-01, 9.3277562e-01, 1.4923579e+00,
 1.5633314e+00, 1.5295953e+00, 6.4307666e-01, 1.1649286e+00, 1.1224879e+00, 6.9225440e-01, 5.0876707e-01, 6.6544567e-01,
 2.0948406e-02, 1.3430706e-02, 2.1066558e-02, 4.7460292e-03, 1.8536169e-03, 7.0426978e-04, 1.3013519e-03, 1.0357965e-03,
 3.8212331e-03, 3.3195130e-03, 2.0905484e-03, 1.8839973e-03, 1.9719190e-03, 1.0797382e-03, 1.1886975e-03, 7.7347964e-04,
 5.7735533e-05, 7.7721264e-05, 2.1149690e-05, 8.1476661e-06, 1.6107278e-06, 1.2849606e-06, 4.1192186e-07, 5.6064394e-07,
 1.8883063e-06, 3.4442311e-06, 3.7631139e-07, 5.7990910e-07, 6.2727226e-07, 7.2116443e-07, 1.3773886e-07, 1.5325905e-07,
 4.6164871e-04, 3.2483225e-04, 1.8194088e-04, 7.4623628e-05, 1.2192834e-05, 5.0842068e-06, 3.3547113e-06, 4.8612096e-06,
 1.2303416e-05, 1.1729948e-05, 2.6378977e-06, 4.3280018e-06, 8.5809053e-06, 5.1565841e-06, 2.0271743e-06, 2.4014729e-06,
 2.8013657e-01, 2.6741627e-01, 1.0167116e-01, 4.9435213e-02, 1.6058484e-02, 9.0843517e-03, 4.0687844e-03, 6.9894974e-03,
 8.0890529e-03, 1.0462580e-02, 1.5971269e-03, 3.1064282e-03, 6.4569148e-03, 5.2641082e-03, 1.4047289e-03, 1.9727480e-03,
 2.5328406e-05, 2.1467002e-05, 1.2225895e-05, 2.9573506e-06, 8.1107571e-07, 4.0737660e-07, 2.7331686e-07, 2.3357778e-07,
 9.5199405e-07, 1.0932530e-06, 2.4998899e-07, 2.4189473e-07, 5.4615614e-07, 3.9533188e-07, 1.5802618e-07, 1.1040577e-07,
 6.8675693e-03, 8.8511681e-03, 3.6518726e-03, 1.5174573e-03, 5.9618934e-04, 4.5535769e-04, 2.2132417e-04, 3.2491689e-04,
 6.8358538e-04, 1.1937496e-03, 1.9775123e-04, 3.2870261e-04, 2.5322375e-04, 2.7872970e-04, 8.0715406e-05, 9.6871881e-05,
 1.0199972e-02, 6.8714272e-03, 5.8353806e-03, 2.5815865e-03, 8.3828927e-04, 3.3466726e-04, 3.3480822e-04, 5.2330710e-04,
 8.2731921e-04, 7.5516915e-04, 2.5748797e-04, 4.5567814e-04, 6.4344105e-04, 3.7020158e-04, 2.2065732e-04, 2.8195286e-04,
 1.3542188e+00, 1.2376775e+00, 7.1345844e-01, 3.7417824e-01, 2.4156039e-01, 1.3083252e-01, 8.8845881e-02, 1.6462289e-01,
 1.1900817e-01, 1.4737324e-01, 3.4109101e-02, 7.1558888e-02, 1.0593330e-01, 8.2686161e-02, 3.3454282e-02, 5.0675979e-02,
 2.0641983e-03, 1.6750032e-03, 1.4463591e-03, 3.7737191e-04, 2.0568721e-04, 9.8910550e-05, 1.0061524e-04, 9.2747109e-05,
 2.3612284e-04, 2.5961219e-04, 9.0006995e-05, 9.3940628e-05, 1.5105982e-04, 1.0468742e-04, 6.3447238e-05, 4.7813114e-05,
 1.0597643e-04, 8.2996359e-05, 2.9214437e-05, 8.8858813e-06, 2.0708183e-06, 9.6108778e-07, 3.9853125e-07, 4.2826073e-07,
 2.1370224e-06, 2.2676816e-06, 3.2048761e-07, 3.8993981e-07, 1.7883324e-06, 1.1961332e-06, 2.9551262e-07, 2.5960884e-07,
 9.9822404e-06, 4.0862857e-06, 2.9605595e-06, 9.5872423e-07, 1.8466089e-07, 4.4796756e-08, 3.8234285e-08, 4.3743705e-08,
 1.6402593e-07, 9.0977907e-08, 2.6465016e-08, 3.4282736e-08, 2.8818776e-07, 1.0075289e-07, 5.1234294e-08, 4.7920495e-08,
 9.7724338e-02, 5.4271780e-02, 2.6690582e-02, 1.0246379e-02, 3.9236602e-03, 1.2913199e-03, 7.4813294e-04, 1.0146915e-03,
 1.7398073e-03, 1.3091684e-03, 2.5850585e-04, 3.9697748e-04, 3.4985184e-03, 1.6593462e-03, 5.7276841e-04, 6.3508483e-04,
 7.1989296e-07, 3.5496445e-07, 2.6149797e-07, 4.9941803e-08, 1.6146404e-08, 4.7180620e-09, 4.0945686e-09, 2.7627835e-09,
 1.6682651e-08, 1.1145630e-08, 3.2966968e-09, 2.5185949e-09, 2.4110337e-08, 1.0153162e-08, 5.2498016e-09, 2.8958731e-09,
 3.5412391e-02, 3.7297112e-02, 1.7500274e-02, 4.1049846e-03, 2.3463457e-03, 1.4644787e-03, 8.0949382e-04, 6.7084675e-04,
 2.7258222e-03, 3.8899168e-03, 7.3282584e-04, 6.8762420e-04, 9.1878580e-04, 8.2644833e-04, 2.7217193e-04, 1.8439564e-04,
 6.8482521e-02, 3.7700792e-02, 3.6410534e-02, 9.0930754e-03, 4.2956670e-03, 1.4014330e-03, 1.5944465e-03, 1.4068132e-03,
 4.2954307e-03, 3.2040579e-03, 1.2424177e-03, 1.2411795e-03, 3.0398155e-03, 1.4292213e-03, 9.6879963e-04, 6.9880861e-04,
 1.1190815e+01, 8.3580169e+00, 5.4792172e+00, 1.6221627e+00, 1.5235412e+00, 6.7432148e-01, 5.2076636e-01, 5.4470580e-01,
 7.6050578e-01, 7.6960376e-01, 2.0256897e-01, 2.3990115e-01, 6.1597513e-01, 3.9290359e-01, 1.8078367e-01, 1.5458803e-01,
 6.0879715e-03, 4.0370066e-03, 3.9643683e-03, 5.8389389e-04, 4.6300330e-04, 1.8194583e-04, 2.1048333e-04, 1.0952672e-04,
 5.3853232e-04, 4.8386231e-04, 1.9077752e-04, 1.1240100e-04, 3.1349291e-04, 1.7753999e-04, 1.2236821e-04, 5.2055796e-05,
 4.3210171e-06, 6.0161899e-06, 1.0249570e-06, 2.5814150e-07, 1.0361135e-07, 8.5489778e-08, 1.7157691e-08, 1.5267013e-08,
 6.8533363e-08, 1.2928872e-07, 8.8437292e-09, 8.9098647e-09, 2.5681227e-08, 3.0537464e-08, 3.6515292e-09, 2.6562413e-09,
 4.9043998e-05, 3.5692108e-05, 1.2515928e-05, 3.3560797e-06, 1.1133231e-06, 4.8015191e-07, 1.9834922e-07, 1.8790677e-07,
 6.3385009e-07, 6.2502256e-07, 8.7998943e-08, 9.4390879e-08, 4.9868253e-07, 3.0995012e-07, 7.6285275e-08, 5.9081321e-08,
 5.8394969e-02, 5.7654394e-02, 1.3723417e-02, 4.3623839e-03, 2.8770848e-03, 1.6833752e-03, 4.7203182e-04, 5.3012195e-04,
 8.1769258e-04, 1.0938805e-03, 1.0454192e-04, 1.3293375e-04, 7.3628786e-04, 6.2084925e-04, 1.0372269e-04, 9.5230441e-05,
 1.5295731e-06, 1.3408277e-06, 4.7808154e-07, 7.5604426e-08, 4.2098513e-08, 2.1869566e-08, 9.1860780e-09, 5.1323757e-09,
 2.7879412e-08, 3.3113793e-08, 4.7405517e-09, 2.9988677e-09, 1.8042478e-08, 1.3507662e-08, 3.3803943e-09, 1.5440204e-09,
 1.4853223e-03, 1.9799628e-03, 5.1143700e-04, 1.3893632e-04, 1.1082665e-04, 8.7549086e-05, 2.6640830e-05, 2.5569023e-05,
 7.1696342e-05, 1.2949594e-04, 1.3430188e-05, 1.4594495e-05, 2.9959812e-05, 3.4108034e-05, 6.1837170e-06, 4.8519219e-06,
 3.1314666e-03, 2.1818997e-03, 1.1600501e-03, 3.3551915e-04, 2.2120010e-04, 9.1336296e-05, 5.7206619e-05, 5.8456104e-05,
 1.2317106e-04, 1.1628358e-04, 2.4822833e-05, 2.8719393e-05, 1.0806236e-04, 6.4304728e-05, 2.3996210e-05, 2.0045816e-05,
 8.1577301e-01, 7.7112919e-01, 2.7829655e-01, 9.5420258e-02, 1.2506862e-01, 7.0061202e-02, 2.9786466e-02, 3.6082361e-02,
 3.4765136e-02, 4.4527129e-02, 6.4520248e-03, 8.8493705e-03, 3.4908389e-02, 2.8181807e-02, 7.1385107e-03, 7.0693755e-03,
 3.6023732e-04, 3.0233743e-04, 1.6344518e-04, 2.7879750e-05, 3.0852268e-05, 1.5344805e-05, 9.7724218e-06, 5.8892785e-06,
 1.9983061e-05, 2.2724164e-05, 4.9324074e-06, 3.3655747e-06, 1.4421253e-05, 1.0336830e-05, 3.9221633e-06, 1.9323364e-06,
 4.2487204e-05, 3.4414946e-05, 7.5841240e-06, 1.5081043e-06, 7.1356511e-07, 3.4252592e-07, 8.8922704e-08, 6.2471448e-08,
 4.1547502e-07, 4.5599120e-07, 4.0346489e-08, 3.2093348e-08, 3.9220597e-07, 2.7132160e-07, 4.1966291e-08, 2.4102782e-08,
 5.6807848e-06, 2.4051827e-06, 1.0909710e-06, 2.3097030e-07, 9.0322898e-08, 2.2662527e-08, 1.2109732e-08, 9.0577493e-09,
 4.5266778e-08, 2.5968201e-08, 4.7293121e-09, 4.0052004e-09, 8.9716610e-08, 3.2440959e-08, 1.0328011e-08, 6.3153896e-09,
 1.0912260e-01, 6.2679410e-02, 1.9298735e-02, 4.8435553e-03, 3.7657010e-03, 1.2818203e-03, 4.6493477e-04, 4.1225896e-04,
 9.4210569e-04, 7.3321730e-04, 9.0641603e-05, 9.1001001e-05, 2.1370414e-03, 1.0483464e-03, 2.2655133e-04, 1.6422607e-04,
 2.3288262e-07, 1.1876613e-07, 5.4776728e-08, 6.8393510e-09, 4.4893891e-09, 1.3567935e-09, 7.3718805e-10, 3.2519217e-10,
 2.6171017e-09, 1.8084193e-09, 3.3488318e-10, 1.6726142e-10, 4.2666674e-09, 1.8583436e-09, 6.0157168e-10, 2.1694360e-10,
 6.2065414e-03, 6.9396321e-03, 2.8876359e-03, 8.3265535e-04, 2.4945940e-04, 1.6529419e-04, 8.1026022e-05, 8.2544901e-05,
 3.1638211e-04, 4.7931598e-04, 8.0078995e-05, 9.2368699e-05, 9.0652347e-05, 8.6565986e-05, 2.5281981e-05, 2.1055936e-05,
 5.7455165e-03, 3.3578895e-03, 2.8759362e-03, 8.8291542e-04, 2.1862165e-04, 7.5718453e-05, 7.6396874e-05, 8.2862519e-05,
 2.3865797e-04, 1.8898892e-04, 6.4989016e-05, 7.9811110e-05, 1.4357099e-04, 7.1661434e-05, 4.3078095e-05, 3.8197673e-05,
 3.1614324e+00, 2.5066421e+00, 1.4572829e+00, 5.3036638e-01, 2.6108977e-01, 1.2267875e-01, 8.4019828e-02, 1.0803308e-01,
 1.4228028e-01, 1.5285372e-01, 3.5679463e-02, 5.1943791e-02, 9.7961560e-02, 6.6335410e-02, 2.7067921e-02, 2.8452972e-02,
 8.5886254e-04, 6.0461270e-04, 5.2653629e-04, 9.5333211e-05, 3.9623107e-05, 1.6530022e-05, 1.6958410e-05, 1.0847860e-05,
 5.0313316e-05, 4.7990964e-05, 1.6780365e-05, 1.2153487e-05, 2.4897120e-05, 1.4968706e-05, 9.1494107e-06, 4.7846445e-06,
 2.0423329e-06, 3.0187631e-06, 4.5608884e-07, 1.4120746e-07, 2.9707178e-08, 2.6021661e-08, 4.6314425e-09, 5.0660261e-09,
 2.1451752e-08, 4.2962359e-08, 2.6061494e-09, 3.2276828e-09, 6.8332395e-09, 8.6260234e-09, 9.1472169e-10, 8.1797050e-10,
 1.1096374e-05, 8.5730283e-06, 2.6660085e-06, 8.7879344e-07, 1.5280234e-07, 6.9960720e-08, 2.5629645e-08, 2.9847667e-08,
 9.4973421e-08, 9.9420954e-08, 1.2413552e-08, 1.6368339e-08, 6.3516964e-08, 4.1910627e-08, 9.1476482e-09, 8.7091394e-09,
 4.4488121e-02, 4.6630274e-02, 9.8431456e-03, 3.8463736e-03, 1.3296420e-03, 8.2590440e-04, 2.0537924e-04, 2.8354167e-04,
 4.1255183e-04, 5.8590252e-04, 4.9657199e-05, 7.7621680e-05, 3.1578137e-04, 2.8267776e-04, 4.1880876e-05, 4.7268711e-05,
 5.8192601e-07, 5.4154802e-07, 1.7123899e-07, 3.3289232e-08, 9.7157699e-09, 5.3581836e-09, 1.9959250e-09, 1.3708448e-09,
 7.0242655e-09, 8.8571319e-09, 1.1244740e-09, 8.7444840e-10, 3.8642388e-09, 3.0712452e-09, 6.8161327e-10, 3.8271887e-10,
 1.5000311e-04, 2.1227717e-04, 4.8626696e-05, 1.6238821e-05, 6.7894888e-06, 5.6939204e-06, 1.5365392e-06, 1.8128676e-06,
 4.7950866e-06, 9.1943852e-06, 8.4563862e-07, 1.1296603e-06, 1.7032901e-06, 2.0586057e-06, 3.3098073e-07, 3.1924416e-07,
 1.5138466e-04, 1.1197876e-04, 5.2797585e-05, 1.8772012e-05, 6.4868366e-06, 2.8435301e-06, 1.5794177e-06, 1.9839763e-06,
 3.9433278e-06, 3.9522036e-06, 7.4818450e-07, 1.0641153e-06, 2.9408894e-06, 1.8578645e-06, 6.1482339e-07, 6.3137526e-07,
 1.3279345e-01, 1.3326040e-01, 4.2649926e-02, 1.7976583e-02, 1.2350071e-02, 7.3445445e-03, 2.7691271e-03, 4.1235826e-03,
 3.7477552e-03, 5.0958721e-03, 6.5482724e-04, 1.1040759e-03, 3.1989497e-03, 2.7416586e-03, 6.1586909e-04, 7.4975245e-04,
 2.9283629e-05, 2.6091245e-05, 1.2508675e-05, 2.6229148e-06, 1.5213764e-06, 8.0329996e-07, 4.5368565e-07, 3.3610159e-07,
 1.0757670e-06, 1.2987068e-06, 2.4998757e-07, 2.0968853e-07, 6.5994759e-07, 5.0218158e-07, 1.6898005e-07, 1.0234081e-07,
 1.0368935e-05, 8.9164027e-06, 1.7425469e-06, 4.2595770e-07, 1.0563864e-07, 5.3833115e-08, 1.2393820e-08, 1.0703602e-08,
 6.7149183e-08, 7.8238255e-08, 6.1390997e-09, 6.0030238e-09, 5.3884052e-08, 3.9572855e-08, 5.4281268e-09, 3.8324134e-09,
 6.6364962e-07, 2.9829445e-07, 1.1999046e-07, 3.1228107e-08, 6.4009089e-09, 1.7049789e-09, 8.0794407e-10, 7.4288777e-10,
 3.5021131e-09, 2.1328449e-09, 3.4447033e-10, 3.5861953e-10, 5.9002924e-09, 2.2649639e-09, 6.3947090e-10, 4.8068472e-10,
 4.2925810e-02, 2.6175523e-02, 7.1471959e-03, 2.2050931e-03, 8.9859275e-04, 3.2472146e-04, 1.0445093e-04, 1.1385355e-04,
 2.4542760e-04, 2.0277914e-04, 2.2230769e-05, 2.7436529e-05, 4.7324599e-04, 2.4645943e-04, 4.7232794e-05, 4.2089658e-05,
 4.5747732e-08, 2.4768052e-08, 1.0130519e-08, 1.5549156e-09, 5.3497438e-10, 1.7164318e-10, 8.2704150e-11, 4.4848215e-11,
 3.4046550e-10, 2.4975751e-10, 4.1015607e-11, 2.5182995e-11, 4.7183671e-10, 2.1817020e-10, 6.2631577e-11, 2.7765715e-11,
 2.0958348e-02, 2.3748465e-02, 1.5402900e-02, 3.5494616e-03, 1.0265557e-03, 6.8933764e-04, 5.2669588e-04, 4.2880788e-04,
 1.7786207e-03, 2.7307668e-03, 7.1111945e-04, 6.5551975e-04, 3.6332898e-04, 3.5160893e-04, 1.6006070e-04, 1.0653327e-04,
 2.3897430e-02, 1.4154030e-02, 1.8895315e-02, 4.6358660e-03, 1.1081289e-03, 3.8894727e-04, 6.1168178e-04, 5.3020681e-04,
 1.6525781e-03, 1.3262146e-03, 7.1085098e-04, 6.9765216e-04, 7.0876548e-04, 3.5851967e-04, 3.3592687e-04, 2.3804666e-04,
 7.0984871e+00, 5.7038166e+00, 5.1686622e+00, 1.5033063e+00, 7.1440902e-01, 3.4018717e-01, 3.6315453e-01, 3.7316720e-01,
 5.3185137e-01, 5.7904580e-01, 2.1067672e-01, 2.4511455e-01, 2.6106638e-01, 1.7915642e-01, 1.1394696e-01, 9.5722170e-02,
 4.5807639e-03, 3.2680079e-03, 4.4360372e-03, 6.4187178e-04, 2.5753600e-04, 1.0888156e-04, 1.7411141e-04, 8.9006778e-05,
 4.4674632e-04, 4.3184621e-04, 2.3535970e-04, 1.3622867e-04, 1.5760744e-04, 9.6029207e-05, 9.1489971e-05, 3.8235520e-05,
 5.9755123e-06, 8.9509487e-06, 2.1079031e-06, 5.2154992e-07, 1.0592177e-07, 9.4026527e-08, 2.6085106e-08, 2.2802418e-08,
 1.0449011e-07, 2.1207623e-07, 2.0052304e-08, 1.9846907e-08, 2.3729503e-08, 3.0357362e-08, 5.0176869e-09, 3.5858283e-09,
 3.9989353e-05, 3.1310420e-05, 1.5176699e-05, 3.9979724e-06, 6.7107123e-07, 3.1137547e-07, 1.7780069e-07, 1.6547742e-07,
 5.6980861e-07, 6.0450005e-07, 1.1764558e-07, 1.2397135e-07, 2.7168547e-07, 1.8167388e-07, 6.1807180e-08, 4.7026376e-08,
 8.6549950e-02, 9.1935263e-02, 3.0248884e-02, 9.4463455e-03, 3.1523369e-03, 1.9843541e-03, 7.6914319e-04, 8.4860325e-04,
 1.3361805e-03, 1.9231070e-03, 2.5405129e-04, 3.1736522e-04, 7.2915966e-04, 6.6148447e-04, 1.5275822e-04, 1.3778429e-04,
 2.6891990e-06, 2.5362011e-06, 1.2500011e-06, 1.9419982e-07, 5.4715195e-08, 3.0580160e-08, 1.7755275e-08, 9.7456003e-09,
 5.4040581e-08, 6.9056356e-08, 1.3665359e-08, 8.4926419e-09, 2.1194967e-08, 1.7071622e-08, 5.9055378e-09, 2.6499537e-09,
 2.3716277e-04, 3.4012709e-04, 1.2144335e-04, 3.2410868e-05, 1.3081538e-05, 1.1117944e-05, 4.6764670e-06, 4.4093799e-06,
 1.2621376e-05, 2.4525865e-05, 3.5159890e-06, 3.7535984e-06, 3.1963080e-06, 3.9149350e-06, 9.8110434e-07, 7.5626217e-07,
 2.9481053e-04, 2.2099798e-04, 1.6241559e-04, 4.6148925e-05, 1.5394628e-05, 6.8388912e-06, 5.9208760e-06, 5.9437767e-06,
 1.2784619e-05, 1.2985418e-05, 3.8316540e-06, 4.3551522e-06, 6.7975654e-06, 4.3519137e-06, 2.2447997e-06, 1.8422643e-06,
 1.3960380e-01, 1.4197543e-01, 7.0825795e-02, 2.3857093e-02, 1.5822137e-02, 9.5356961e-03, 5.6039122e-03, 6.6689964e-03,
 6.5592730e-03, 9.0384612e-03, 1.8103543e-03, 2.4393435e-03, 3.9915491e-03, 3.4668824e-03, 1.2138784e-03, 1.1809777e-03,
 7.3127067e-05, 6.6029747e-05, 4.9342047e-05, 8.2685040e-06, 4.6298304e-06, 2.4774082e-06, 2.1809016e-06, 1.2911858e-06,
 4.4723435e-06, 5.4716650e-06, 1.6416781e-06, 1.1004774e-06, 1.9560325e-06, 1.5084091e-06, 7.9114224e-07, 3.8291722e-07,
 3.1401258e-05, 2.7364918e-05, 8.3358484e-06, 1.6284288e-06, 3.8986220e-07, 2.0133949e-07, 7.2251332e-08, 4.9866379e-08,
 3.3854574e-07, 3.9974892e-07, 4.8891567e-08, 3.8206425e-08, 1.9368081e-07, 1.4415024e-07, 3.0819734e-08, 1.7389550e-08,
 2.4755202e-06, 1.1276237e-06, 7.0701230e-07, 1.4704928e-07, 2.9096747e-08, 7.8544057e-09, 5.8014575e-09, 4.2630046e-09,
 2.1748110e-08, 1.3422769e-08, 3.3790583e-09, 2.8113518e-09, 2.6122488e-08, 1.0162343e-08, 4.4721303e-09, 2.6865253e-09,
 8.6438153e-02, 5.3416320e-02, 2.2733979e-02, 5.6053623e-03, 2.2050844e-03, 8.0754154e-04, 4.0488089e-04, 3.5269436e-04,
 8.2276219e-04, 6.8891493e-04, 1.1772208e-04, 1.1610999e-04, 1.1310649e-03, 5.9694949e-04, 1.7831874e-04, 1.2698892e-04,
 2.1882103e-07, 1.2006126e-07, 7.6542704e-08, 9.3889273e-09, 3.1183705e-09, 1.0139414e-09, 7.6150812e-10, 3.3001190e-10,
 2.7111679e-09, 2.0155496e-09, 5.1592296e-10, 2.5315151e-10, 2.6787038e-09, 1.2552210e-09, 5.6166709e-10, 1.9899018e-10,
 1.9297912e-01, 4.0969920e-01, 1.1206895e-01, 3.5268488e-02, 2.2500601e-02, 2.8308708e-02, 9.1222275e-03, 1.0142514e-02,
 1.5050860e-02, 4.3295109e-02, 4.7549896e-03, 5.9859729e-03, 7.1318724e-03, 1.2931231e-02, 2.4826634e-03, 2.2566289e-03,
 1.2943162e-02, 1.4363018e-02, 8.0867261e-03, 2.7095140e-03, 1.4286915e-03, 9.3953942e-04, 6.2316446e-04, 7.3767383e-04,
 8.2257573e-04, 1.2368136e-03, 2.7959020e-04, 3.7473476e-04, 8.1835605e-04, 7.7558447e-04, 3.0648830e-04, 2.9660138e-04,
 3.3983089e+01, 5.1160990e+01, 1.9552601e+01, 7.7663241e+00, 8.1414617e+00, 7.2635619e+00, 3.2702130e+00, 4.5891274e+00,
 2.3399788e+00, 4.7732146e+00, 7.3243212e-01, 1.1637556e+00, 2.6643938e+00, 3.4257529e+00, 9.1892377e-01, 1.0542191e+00,
 9.4670506e-02, 1.2654244e-01, 7.2443806e-02, 1.4315156e-02, 1.2669903e-02, 1.0036124e-02, 6.7684924e-03, 4.7253011e-03,
 8.4852065e-03, 1.5367623e-02, 3.5323424e-03, 2.7921632e-03, 6.9439090e-03, 7.9269669e-03, 3.1851505e-03, 1.8178806e-03,
 3.3416838e-05, 9.3785476e-05, 9.3147232e-06, 3.1474378e-06, 1.4100476e-06, 2.3451755e-06, 2.7439146e-07, 3.2756744e-07,
 5.3701944e-07, 2.0421290e-06, 8.1434487e-08, 1.1007250e-07, 2.8289765e-07, 6.7808031e-07, 4.7268679e-08, 4.6131877e-08,
 1.3154388e-05, 1.9297087e-05, 3.9448726e-06, 1.4191790e-06, 5.2547661e-07, 4.5682028e-07, 1.1001394e-07, 1.3982811e-07,
 1.7225818e-07, 3.4239208e-07, 2.8103212e-08, 4.0443007e-08, 1.9052109e-07, 2.3869623e-07, 3.4248762e-08, 3.5586856e-08,
 2.5165217e-01, 5.0083257e-01, 6.9498030e-02, 2.9639369e-02, 2.1818513e-02, 2.5732867e-02, 4.2065768e-03, 6.3382309e-03,
 3.5704550e-03, 9.6280526e-03, 5.3642528e-04, 9.1514303e-04, 4.5196714e-03, 7.6821070e-03, 7.4820073e-04, 9.2162704e-04,
 3.3754890e-05, 5.9644978e-05, 1.2398049e-05, 2.6304715e-06, 1.6348582e-06, 1.7119389e-06, 4.1920720e-07, 3.1423307e-07,
 6.2338775e-07, 1.4925137e-06, 1.2456287e-07, 1.0571875e-07, 5.6714849e-07, 8.5588503e-07, 1.2486849e-07, 7.6519765e-08,
 1.0995094e-02, 2.9544026e-02, 4.4489266e-03, 1.6214893e-03, 1.4436762e-03, 2.2988553e-03, 4.0781021e-04, 5.2512113e-04,
 5.3775417e-04, 1.9578414e-03, 1.1837331e-04, 1.7258218e-04, 3.1590141e-04, 7.2494291e-04, 7.6620891e-05, 8.0657808e-05,
 8.0395447e-04, 1.1291538e-03, 3.4998188e-04, 1.3580663e-04, 9.9934646e-05, 8.3178116e-05, 3.0371222e-05, 4.1637118e-05,
 3.2040621e-05, 6.0974111e-05, 7.5880220e-06, 1.1778433e-05, 3.9517774e-05, 4.7401890e-05, 1.0312065e-05, 1.1557451e-05,
 3.3650635e+00, 6.4118852e+00, 1.3490150e+00, 6.2056131e-01, 9.0786175e-01, 1.0251406e+00, 2.5408281e-01, 4.1293917e-01,
 1.4530363e-01, 3.7513849e-01, 3.1689379e-02, 5.8312948e-02, 2.0511066e-01, 3.3378132e-01, 4.9289099e-02, 6.5487635e-02,
 7.6094600e-03, 1.2873360e-02, 4.0571620e-03, 9.2848309e-04, 1.1468314e-03, 1.1497632e-03, 4.2687399e-04, 3.4513932e-04,
 4.2769669e-04, 9.8038419e-04, 1.2405590e-04, 1.1356722e-04, 4.3391276e-04, 6.2693389e-04, 1.3867880e-04, 9.1664727e-05,
 4.6359794e-04, 7.5694618e-04, 9.7246444e-05, 2.5943863e-05, 1.3701373e-05, 1.3257412e-05, 2.0064488e-06, 1.8911765e-06,
 4.5934253e-06, 1.0162097e-05, 5.2418256e-07, 5.5940574e-07, 6.0958156e-06, 8.5003476e-06, 7.6648428e-07, 5.9061540e-07,
 2.1497963e-06, 1.8347272e-06, 4.8516215e-07, 1.3780495e-07, 6.0149760e-08, 3.0421385e-08, 9.4766640e-09, 9.5099082e-09,
 1.7357086e-08, 2.0071230e-08, 2.1309851e-09, 2.4212612e-09, 4.8361061e-08, 3.5249372e-08, 6.5422175e-09, 5.3671468e-09,
 6.6350449e-01, 7.6822557e-01, 1.3789330e-01, 4.6431552e-02, 4.0292318e-02, 2.7646383e-02, 5.8459270e-03, 6.9545096e-03,
 5.8041332e-03, 9.1055240e-03, 6.5622121e-04, 8.8390141e-04, 1.8508720e-02, 1.8302179e-02, 2.3057647e-03, 2.2424660e-03,
 7.2511566e-06, 7.4541403e-06, 2.0042473e-06, 3.3574175e-07, 2.4598272e-07, 1.4985320e-07, 4.7465771e-08, 2.8091672e-08,
 8.2565649e-08, 1.1500387e-07, 1.2415298e-08, 8.3194469e-09, 1.8923151e-07, 1.6613659e-07, 3.1352848e-08, 1.5169509e-08,
 3.4133324e-02, 7.4950075e-02, 1.2835477e-02, 2.6408066e-03, 3.4206201e-03, 4.4511228e-03, 8.9798720e-04, 6.5273638e-04,
 1.2909690e-03, 3.8408956e-03, 2.6409675e-04, 2.1735573e-04, 6.9006277e-04, 1.2940875e-03, 1.5554692e-04, 9.2432937e-05,
 3.2496755e-03, 3.7297873e-03, 1.3147123e-03, 2.8798677e-04, 3.0830484e-04, 2.0969870e-04, 8.7076961e-05, 6.7388816e-05,
 1.0015254e-04, 1.5575039e-04, 2.2042790e-05, 1.9314870e-05, 1.1239797e-04, 1.1017534e-04, 2.7257677e-05, 1.7245317e-05,
 1.6741476e+01, 2.6068064e+01, 6.2372634e+00, 1.6196760e+00, 3.4472740e+00, 3.1809868e+00, 8.9661973e-01, 8.2259344e-01,
 5.5902266e-01, 1.1794170e+00, 1.1330358e-01, 1.1769583e-01, 7.1803593e-01, 9.5486658e-01, 1.6035625e-01, 1.2027090e-01,
 1.3511468e-02, 1.8679404e-02, 6.6949584e-03, 8.6489971e-04, 1.5541884e-03, 1.2733134e-03, 5.3762682e-04, 2.4538138e-04,
 5.8726886e-04, 1.1000699e-03, 1.5830553e-04, 8.1808254e-05, 5.4213653e-04, 6.4010415e-04, 1.6102507e-04, 6.0083045e-05,
 1.2282146e-06, 3.5651981e-06, 2.2168572e-07, 4.8972014e-08, 4.4543609e-08, 7.6624139e-08, 5.6128143e-09, 4.3806025e-09,
 9.5716240e-09, 3.7645894e-08, 9.3985868e-10, 8.3053162e-10, 5.6879433e-09, 1.4100869e-08, 6.1540075e-10, 3.9265284e-10,
 6.8629564e-07, 1.0412881e-06, 1.3326990e-07, 3.1344334e-08, 2.3563310e-08, 2.1186885e-08, 3.1943986e-09, 2.6543564e-09,
 4.3581977e-09, 8.9596199e-09, 4.6040663e-10, 4.3316375e-10, 5.4375121e-09, 7.0459842e-09, 6.3293725e-10, 4.2996034e-10,
 2.5761588e-02, 5.3027731e-02, 4.6068384e-03, 1.2844656e-03, 1.9197268e-03, 2.3417537e-03, 2.3966347e-04, 2.3608269e-04,
 1.7724837e-04, 4.9435136e-04, 1.7243536e-05, 1.9232202e-05, 2.5310199e-04, 4.4494661e-04, 2.7130996e-05, 2.1848705e-05,
 1.0010726e-06, 1.8295384e-06, 2.3808994e-07, 3.3025094e-08, 4.1672673e-08, 4.5133472e-08, 6.9192455e-09, 3.3908189e-09,
 8.9654815e-09, 2.2201012e-08, 1.1600126e-09, 6.4364939e-10, 9.2011583e-09, 1.4361505e-08, 1.3117687e-09, 5.2553413e-10,
 1.1678384e-03, 3.2455814e-03, 3.0598343e-04, 7.2908727e-05, 1.3179413e-04, 2.1705847e-04, 2.4106995e-05, 2.0293989e-05,
 2.7698372e-05, 1.0430061e-04, 3.9480532e-06, 3.7631202e-06, 1.8354893e-05, 4.3565572e-05, 2.8827483e-06, 1.9839414e-06,
 1.2121233e-04, 1.7607884e-04, 3.4167988e-05, 8.6679818e-06, 1.2950121e-05, 1.1148220e-05, 2.5484644e-06, 2.2841263e-06,
 2.3426236e-06, 4.6109050e-06, 3.5924366e-07, 3.6456171e-07, 3.2593003e-06, 4.0435823e-06, 5.5072721e-07, 4.0352982e-07,
 9.9549716e-01, 1.9618746e+00, 2.5841766e-01, 7.7716483e-02, 2.3083890e-01, 2.6959474e-01, 4.1833411e-02, 4.4448480e-02,
 2.0845373e-02, 5.5662662e-02, 2.9437830e-03, 3.5414404e-03, 3.3193384e-02, 5.5868156e-02, 5.1650376e-03, 4.4864681e-03,
 6.5216519e-04, 1.1411282e-03, 2.2515669e-04, 3.3686770e-05, 8.4478400e-05, 8.7597806e-05, 2.0361255e-05, 1.0762720e-05,
 1.7775671e-05, 4.2143023e-05, 3.3386197e-06, 1.9981355e-06, 2.0343368e-05, 3.0400528e-05, 4.2100718e-06, 1.8193006e-06,
 9.1276039e-05, 1.5414137e-04, 1.2397891e-05, 2.1623790e-06, 2.3185795e-06, 2.3203600e-06, 2.1985922e-07, 1.3547889e-07,
 4.3856988e-07, 1.0035153e-06, 3.2407326e-08, 2.2610526e-08, 6.5654422e-07, 9.4690798e-07, 5.3455726e-08, 2.6928907e-08,
 6.0081949e-07, 5.3034310e-07, 8.7799534e-08, 1.6303966e-08, 1.4448500e-08, 7.5580014e-09, 1.4740198e-09, 9.6704597e-10,
 2.3523948e-09, 2.8134943e-09, 1.8701326e-10, 1.3891738e-10, 7.3936576e-09, 5.5738296e-09, 6.4766013e-10, 3.4736706e-10,
 3.6384965e-01, 4.3571831e-01, 4.8964361e-02, 1.0778869e-02, 1.8990772e-02, 1.3477144e-02, 1.7841558e-03, 1.3876148e-03,
 1.5434835e-03, 2.5044297e-03, 1.1299883e-04, 9.9506225e-05, 5.5522829e-03, 5.6785390e-03, 4.4788732e-04, 2.8477527e-04,
 1.1519744e-06, 1.2248183e-06, 2.0617940e-07, 2.2579916e-08, 3.3587850e-08, 2.1163253e-08, 4.1967881e-09, 1.6238158e-09,
 6.3609368e-09, 9.1637524e-09, 6.1935199e-10, 2.7133014e-10, 1.6445445e-08, 1.4933315e-08, 1.7643625e-09, 5.5809135e-10,
 6.6714840e-03, 1.5551873e-02, 2.3618860e-03, 5.9736510e-04, 4.0556662e-04, 5.6026519e-04, 1.0023759e-04, 8.9568354e-05,
 1.6710138e-04, 5.2779251e-04, 3.2183287e-05, 3.2560763e-05, 7.5928154e-05, 1.5116274e-04, 1.6113083e-05, 1.1770650e-05,
 3.0404557e-04, 3.7046713e-04, 1.1580643e-04, 3.1183904e-05, 1.7498160e-05, 1.2634982e-05, 4.6528442e-06, 4.4264861e-06,
 6.2055535e-06, 1.0245063e-05, 1.2858447e-06, 1.3850636e-06, 5.9200804e-06, 6.1605555e-06, 1.3516401e-06, 1.0512336e-06,
 5.2743088e+00, 8.7186177e+00, 1.8499891e+00, 5.9055344e-01, 6.5881137e-01, 6.4537796e-01, 1.6132309e-01, 1.8194057e-01,
 1.1663296e-01, 2.6123185e-01, 2.2255574e-02, 2.8419224e-02, 1.2734686e-01, 1.7978426e-01, 2.6775102e-02, 2.4686628e-02,
 2.1257055e-03, 3.1198268e-03, 9.9163463e-04, 1.5748000e-04, 1.4832616e-04, 1.2900780e-04, 4.8305678e-05, 2.7102856e-05,
 6.1186797e-05, 1.2167682e-04, 1.5528158e-05, 9.8645489e-06, 4.8015304e-05, 6.0185012e-05, 1.3426647e-05, 6.1586001e-06,
 6.4738766e-07, 1.9949886e-06, 1.1000975e-07, 2.9874271e-08, 1.4242589e-08, 2.6009746e-08, 1.6896146e-09, 1.6210505e-09,
 3.3411496e-09, 1.3950662e-08, 3.0887030e-10, 3.3552566e-10, 1.6877802e-09, 4.4419441e-09, 1.7191814e-10, 1.3484306e-10,
 1.7316330e-07, 2.7892179e-07, 3.1657748e-08, 9.1529938e-09, 3.6065713e-09, 3.4426441e-09, 4.6031013e-10, 4.7019342e-10,
 7.2823536e-10, 1.5893571e-09, 7.2428548e-11, 8.3767618e-11, 7.7235217e-10, 1.0624869e-09, 8.4640686e-11, 7.0681025e-11,
 2.1887224e-02, 4.7828639e-02, 3.6848865e-03, 1.2629897e-03, 9.8939740e-04, 1.2812666e-03, 1.1628844e-04, 1.4081695e-04,
 9.9728714e-05, 2.9528447e-04, 9.1341415e-06, 1.2523522e-05, 1.2105536e-04, 2.2592436e-04, 1.2216794e-05, 1.2094088e-05,
 4.2472969e-07, 8.2405339e-07, 9.5102284e-08, 1.6216236e-08, 1.0725359e-08, 1.2331777e-08, 1.6765721e-09, 1.0100068e-09,
 2.5190727e-09, 6.6222644e-09, 3.0685484e-10, 2.0930302e-10, 2.1976559e-09, 3.6415307e-09, 2.9496988e-10, 1.4527045e-10,
 1.3152603e-04, 3.8805079e-04, 3.2443679e-05, 9.5031564e-06, 9.0040617e-06, 1.5742947e-05, 1.5505602e-06, 1.6046086e-06,
 2.0658713e-06, 8.2585324e-06, 2.7722683e-07, 3.2483016e-07, 1.1637272e-06, 2.9323079e-06, 1.7207154e-07, 1.4557513e-07,
 6.5347711e-06, 1.0077616e-05, 1.7342284e-06, 5.4083026e-07, 4.2351702e-07, 3.8705210e-07, 7.8465506e-08, 8.6452231e-08,
 8.3638522e-08, 1.7476583e-07, 1.2075250e-08, 1.5063779e-08, 9.8918662e-08, 1.3028284e-07, 1.5735976e-08, 1.4173877e-08,
 1.8071611e-01, 3.7808984e-01, 4.4165409e-02, 1.6327864e-02, 2.5420215e-02, 3.1517250e-02, 4.3370719e-03, 5.6648237e-03,
 2.5060318e-03, 7.1040772e-03, 3.3318530e-04, 4.9273815e-04, 3.3921785e-03, 6.0611971e-03, 4.9693941e-04, 5.3062899e-04,
 5.9121217e-05, 1.0982129e-04, 1.9216472e-05, 3.5343067e-06, 4.6456316e-06, 5.1139832e-06, 1.0541608e-06, 6.8498399e-07,
 1.0671655e-06, 2.6859517e-06, 1.8870164e-07, 1.3883202e-07, 1.0381952e-06, 1.6470386e-06, 2.0227792e-07, 1.0745329e-07,
 2.4841766e-05, 4.4536031e-05, 3.1767009e-06, 6.8110847e-07, 3.8279012e-07, 4.0668766e-07, 3.4173272e-08, 2.5886270e-08,
 7.9046760e-08, 1.9201545e-07, 5.4991029e-09, 4.7164482e-09, 1.0059110e-07, 1.5401756e-07, 7.7106862e-09, 4.7750018e-09,
 7.8275120e-08, 7.3350631e-08, 1.0769007e-08, 2.4582862e-09, 1.1418693e-09, 6.3411391e-10, 1.0967301e-10, 8.8450382e-11,
 2.0295992e-10, 2.5769929e-10, 1.5190625e-11, 1.3871264e-11, 5.4226265e-10, 4.3398120e-10, 4.4719877e-11, 2.9484784e-11,
 1.5961552e-01, 2.0292055e-01, 2.0222575e-02, 5.4724987e-03, 5.0537013e-03, 3.8074223e-03, 4.4699483e-04, 4.2736076e-04,
 4.4841028e-04, 7.7241211e-04, 3.0906528e-05, 3.3456683e-05, 1.3711812e-03, 1.4887676e-03, 1.0413472e-04, 8.1392694e-05,
 2.5236234e-07, 2.8485285e-07, 4.2523649e-08, 5.7248413e-09, 4.4635221e-09, 2.9856896e-09, 5.2506811e-10, 2.4974187e-10,
 9.2283334e-10, 1.4113741e-09, 8.4594669e-11, 4.5557437e-11, 2.0281391e-09, 1.9551281e-09, 2.0485335e-10, 7.9655699e-11,
 3.0548362e-02, 7.2167215e-02, 1.7083511e-02, 3.4529889e-03, 2.2630951e-03, 3.1682964e-03, 8.8353578e-04, 6.3093537e-04,
 1.2738236e-03, 4.0774070e-03, 3.8753606e-04, 3.1333832e-04, 4.1265008e-04, 8.3255946e-04, 1.3832812e-04, 8.0754901e-05,
 1.7148211e-03, 2.1174895e-03, 1.0317288e-03, 2.2202426e-04, 1.2026739e-04, 8.8007876e-05, 5.0515718e-05, 3.8406464e-05,
 5.8267273e-05, 9.7487776e-05, 1.9071513e-05, 1.6417366e-05, 3.9629742e-05, 4.1793168e-05, 1.4292470e-05, 8.8834716e-06,
 1.6058510e+01, 2.6901622e+01, 8.8973657e+00, 2.2698058e+00, 2.4444204e+00, 2.4267258e+00, 9.4550625e-01, 8.5218592e-01,
 5.9118699e-01, 1.3419038e+00, 1.7819475e-01, 1.8184663e-01, 4.6019461e-01, 6.5841002e-01, 1.5284006e-01, 1.1261725e-01,
 1.5373597e-02, 2.2866207e-02, 1.1328607e-02, 1.4377635e-03, 1.3072697e-03, 1.1522725e-03, 6.7250931e-04, 3.0154496e-04,
 7.3670513e-04, 1.4846888e-03, 2.9533065e-04, 1.4993495e-04, 4.1215966e-04, 5.2355910e-04, 1.8205639e-04, 6.6735567e-05,
 2.5684501e-06, 8.0211866e-06, 6.8943022e-07, 1.4962138e-07, 6.8860601e-08, 1.2744109e-07, 1.2903930e-08, 9.8939167e-09,
 2.2068170e-08, 9.3380584e-08, 3.2225459e-09, 2.7976017e-09, 7.9475951e-09, 2.1197510e-08, 1.2787759e-09, 8.0156402e-10,
 8.4620885e-07, 1.3813238e-06, 2.4437352e-07, 5.6464344e-08, 2.1477856e-08, 2.0776879e-08, 4.3301201e-09, 3.5347841e-09,
 5.9245693e-09, 1.3103821e-08, 9.3078102e-10, 8.6030236e-10, 4.4797163e-09, 6.2452503e-09, 7.7547271e-10, 5.1752023e-10,
 5.7739289e-02, 1.2786758e-01, 1.5355282e-02, 4.2060103e-03, 3.1807306e-03, 4.1743326e-03, 5.9053438e-04, 5.7147979e-04,
 4.3799074e-04, 1.3142465e-03, 6.3367256e-05, 6.9432188e-05, 3.7903424e-04, 7.1688412e-04, 6.0423261e-05, 4.7803248e-05,
 2.6614954e-06, 5.2331140e-06, 9.4136253e-07, 1.2827832e-07, 8.1903091e-08, 9.5434576e-08, 2.0223827e-08, 9.7364939e-09,
 2.6279550e-08, 7.0012395e-08, 5.0566485e-09, 2.7564003e-09, 1.6345061e-08, 2.7447464e-08, 3.4654284e-09, 1.3639357e-09,
 2.8197870e-04, 8.4311037e-04, 1.0987204e-04, 2.5719469e-05, 2.3524369e-05, 4.1682843e-05, 6.3991307e-06, 5.2922277e-06,
 7.3734657e-06, 2.9871883e-05, 1.5629896e-06, 1.4635723e-06, 2.9612106e-06, 7.5616910e-06, 6.9163914e-07, 4.6762198e-07,
 1.7256371e-05, 2.6969225e-05, 7.2339913e-06, 1.8028923e-06, 1.3629036e-06, 1.2622787e-06, 3.9886486e-07, 3.5120480e-07,
 3.6769635e-07, 7.7862990e-07, 8.3855510e-08, 8.3600064e-08, 3.1003530e-07, 4.1381991e-07, 7.7907410e-08, 5.6080418e-08,
 2.5761758e-01, 5.4621695e-01, 9.9452006e-02, 2.9383090e-02, 4.4160431e-02, 5.5487327e-02, 1.1901538e-02, 1.2423104e-02,
 5.9474274e-03, 1.7086052e-02, 1.2490531e-03, 1.4762099e-03, 5.7394585e-03, 1.0393028e-02, 1.3281538e-03, 1.1333734e-03,
 2.0019558e-04, 3.7686821e-04, 1.0278681e-04, 1.5107935e-05, 1.9170387e-05, 2.1386378e-05, 6.8714099e-06, 3.5682603e-06,
 6.0159845e-06, 1.5344913e-05, 1.6803641e-06, 9.8799434e-07, 4.1725687e-06, 6.7084165e-06, 1.2841798e-06, 5.4517296e-07,
 1.0201245e-04, 1.8534206e-04, 2.0606296e-05, 3.5308316e-06, 1.9156095e-06, 2.0625222e-06, 2.7013783e-07, 1.6353299e-07,
 5.4040420e-07, 1.3303395e-06, 5.9385325e-08, 4.0704238e-08, 4.9027976e-07, 7.6075730e-07, 5.9364933e-08, 2.9379721e-08,
 3.9592189e-07, 3.7599402e-07, 8.6042654e-08, 1.5696680e-08, 7.0384523e-09, 3.9611350e-09, 1.0678579e-09, 6.8825647e-10,
 1.7090696e-09, 2.1991455e-09, 2.0205870e-10, 1.4745342e-10, 3.2554327e-09, 2.6403502e-09, 4.2408448e-10, 2.2345343e-10,
 4.3583337e-01, 5.6151650e-01, 8.7223634e-02, 1.8863419e-02, 1.6816271e-02, 1.2839352e-02, 2.3495010e-03, 1.7951670e-03,
 2.0383762e-03, 3.5583551e-03, 2.2192781e-04, 1.9199131e-04, 4.4437901e-03, 4.8896425e-03, 5.3309749e-04, 3.3299181e-04,
 1.6368241e-06, 1.8723620e-06, 4.3567303e-07, 4.6873861e-08, 3.5280143e-08, 2.3916027e-08, 6.5557314e-09, 2.4919199e-09,
 9.9647100e-09, 1.5444537e-08, 1.4429023e-09, 6.2099842e-10, 1.5613095e-08, 1.5253091e-08, 2.4910758e-09, 7.7410054e-10,
 4.6634523e-01, 8.2544001e-01, 3.2254489e-01, 6.8296852e-02, 4.2314761e-02, 4.4385471e-02, 2.0431788e-02, 1.5284806e-02,
 3.2760240e-02, 7.8568389e-02, 1.2326599e-02, 1.0440882e-02, 1.2425166e-02, 1.8782857e-02, 5.1513862e-03, 3.1504689e-03,
 2.0200432e+00, 1.8689132e+00, 1.5031441e+00, 3.3886598e-01, 1.7352367e-01, 9.5138977e-02, 9.0142759e-02, 7.1796175e-02,
 1.1563374e-01, 1.4495592e-01, 4.6809961e-02, 4.2213300e-02, 9.2079635e-02, 7.2756781e-02, 4.1071731e-02, 2.6743054e-02,
 7.4327616e+01, 9.3293089e+01, 5.0933032e+01, 1.3611917e+01, 1.3857669e+01, 1.0307672e+01, 6.6293601e+00, 6.2594211e+00,
 4.6098602e+00, 7.8398947e+00, 1.7185061e+00, 1.8371901e+00, 4.2013324e+00, 4.5036808e+00, 1.7257421e+00, 1.3320974e+00,
 2.2192815e+00, 2.4731872e+00, 2.0225845e+00, 2.6891195e-01, 2.3113798e-01, 1.5264656e-01, 1.4706112e-01, 6.9078720e-02,
 1.7916313e-01, 2.7053047e-01, 8.8829407e-02, 4.7243676e-02, 1.1735534e-01, 1.1169380e-01, 6.4111614e-02, 2.4619578e-02,
 5.6850193e-05, 1.3302258e-04, 1.8873145e-05, 4.2908203e-06, 1.8668133e-06, 2.5886033e-06, 4.3265869e-07, 3.4752354e-07,
 8.2289656e-07, 2.6089246e-06, 1.4861794e-07, 1.3516075e-07, 3.4697419e-07, 6.9338142e-07, 6.9047700e-08, 4.5340432e-08,
 1.4453065e-03, 1.7676818e-03, 5.1621435e-04, 1.2495194e-04, 4.4930681e-05, 3.2565542e-05, 1.1203283e-05, 9.5807804e-06,
 1.7047385e-05, 2.8250411e-05, 3.3123912e-06, 3.2072880e-06, 1.5091549e-05, 1.5763745e-05, 3.2310476e-06, 2.2588983e-06,
 3.8748698e-01, 6.4294249e-01, 1.2744910e-01, 3.6571417e-02, 2.6144595e-02, 2.5707987e-02, 6.0033474e-03, 6.0861364e-03,
 4.9518668e-03, 1.1132848e-02, 8.8605796e-04, 1.0170693e-03, 5.0172387e-03, 7.1098642e-03, 9.8919947e-04, 8.1984105e-04,
 5.5706214e-04, 8.2066124e-04, 2.4368455e-04, 3.4786990e-05, 2.0996520e-05, 1.8330688e-05, 6.4121510e-06, 3.2339679e-06,
 9.2664571e-06, 1.8496817e-05, 2.2052200e-06, 1.2592860e-06, 6.7478451e-06, 8.4899833e-06, 1.7694121e-06, 7.2955561e-07,
 2.9276890e-02, 6.5587196e-02, 1.4108774e-02, 3.4598444e-03, 2.9915487e-03, 3.9715627e-03, 1.0064503e-03, 8.7197231e-04,
 1.2897282e-03, 3.9148527e-03, 3.3812412e-04, 3.3168591e-04, 6.0642744e-04, 1.1602574e-03, 1.7517912e-04, 1.2407671e-04,
 1.3825483e-01, 1.6189189e-01, 7.1680675e-02, 1.8714851e-02, 1.3374128e-02, 9.2807127e-03, 4.8408233e-03, 4.4652560e-03,
 4.9629305e-03, 7.8741896e-03, 1.3998250e-03, 1.4619799e-03, 4.8993942e-03, 4.8996910e-03, 1.5226626e-03, 1.1482289e-03,
 8.1097834e+00, 1.2883233e+01, 3.8720457e+00, 1.1984428e+00, 1.7026919e+00, 1.6029610e+00, 5.6754404e-01, 6.2061027e-01,
 3.1541404e-01, 6.7892149e-01, 8.1926809e-02, 1.0143455e-01, 3.5637347e-01, 4.8350691e-01, 1.0199435e-01, 9.1178652e-02,
 1.9655336e-01, 2.7723074e-01, 1.2481205e-01, 1.9218385e-02, 2.3052925e-02, 1.9268961e-02, 1.0219608e-02, 5.5595246e-03,
 9.9506368e-03, 1.9016670e-02, 3.4374822e-03, 2.1173086e-03, 8.0803484e-03, 9.7335784e-03, 3.0757113e-03, 1.3678753e-03,
 6.6625487e-05, 9.0695720e-05, 1.6644852e-05, 2.9877881e-06, 1.5323678e-06, 1.2361777e-06, 2.6726079e-07, 1.6949142e-07,
 5.9459869e-07, 1.0967142e-06, 8.0812351e-08, 5.8027072e-08, 6.3158488e-07, 7.3427667e-07, 9.4582547e-08, 4.9036698e-08,
 1.9953486e-05, 1.4197631e-05, 5.3631038e-06, 1.0249502e-06, 4.3446570e-07, 1.8319941e-07, 8.1523912e-08, 5.5044602e-08,
 1.4510655e-07, 1.3989658e-07, 2.1217696e-08, 1.6220643e-08, 3.2360742e-07, 1.9665155e-07, 5.2138141e-08, 2.8779454e-08,
 8.6304336e-02, 8.3310628e-02, 2.1361881e-02, 4.8396996e-03, 4.0786013e-03, 2.3331916e-03, 7.0477454e-04, 5.6412050e-04,
 6.8000873e-04, 8.8941743e-04, 9.1566211e-05, 8.2984615e-05, 1.7356669e-03, 1.4309209e-03, 2.5752100e-04, 1.6851252e-04,
 1.0108954e-05, 8.6640238e-06, 3.3278055e-06, 3.7507736e-07, 2.6687251e-07, 1.3554651e-07, 6.1332091e-08, 2.4422678e-08,
 1.0367807e-07, 1.2039912e-07, 1.8567466e-08, 8.3714084e-09, 1.9019265e-07, 1.3921583e-07, 3.7530560e-08, 1.2217668e-08,
 1.1690377e-01, 2.1401549e-01, 5.2356393e-02, 7.2477509e-03, 9.1170681e-03, 9.8910646e-03, 2.8505480e-03, 1.3941360e-03,
 3.9824871e-03, 9.8785732e-03, 9.7030740e-04, 5.3731184e-04, 1.7038835e-03, 2.6640246e-03, 4.5742569e-04, 1.8289197e-04,
 7.1880770e-01, 6.8782820e-01, 3.4634691e-01, 5.1046024e-02, 5.3070547e-02, 3.0094838e-02, 1.7851888e-02, 9.2956021e-03,
 1.9953698e-02, 2.5871028e-02, 5.2304123e-03, 3.0836827e-03, 1.7923898e-02, 1.4648103e-02, 5.1769129e-03, 2.2037466e-03,
 5.1895990e+01, 6.7370839e+01, 2.3027246e+01, 4.0233207e+00, 8.3160315e+00, 6.3977267e+00, 2.5760634e+00, 1.5901650e+00,
 1.5608386e+00, 2.7454850e+00, 3.7677316e-01, 2.6333363e-01, 1.6046763e+00, 1.7791278e+00, 4.2681043e-01, 2.1538648e-01,
 4.4890334e-01, 5.1741200e-01, 2.6491463e-01, 2.3026738e-02, 4.0184112e-02, 2.7447908e-02, 1.6555399e-02, 5.0840397e-03,
 1.7574217e-02, 2.7446209e-02, 5.6421265e-03, 1.9617904e-03, 1.2985549e-02, 1.2782784e-02, 4.5935968e-03, 1.1532412e-03,
 2.9613766e-06, 7.1668108e-06, 6.3659739e-07, 9.4620206e-08, 8.3580528e-08, 1.1986946e-07, 1.2543197e-08, 6.5867347e-09,
 2.0787079e-08, 6.8162995e-08, 2.4309631e-09, 1.4453758e-09, 9.8872598e-09, 2.0435701e-08, 1.2740500e-09, 5.4694791e-10,
 1.0686933e-04, 1.3518732e-04, 2.4716200e-05, 3.9112682e-06, 2.8554760e-06, 2.1405864e-06, 4.6104092e-07, 2.5776149e-07,
 6.1127640e-07, 1.0477157e-06, 7.6909490e-08, 4.8685458e-08, 6.1044102e-07, 6.5948970e-07, 8.4627579e-08, 3.8680157e-08,
 5.6218839e-02, 9.6479626e-02, 1.1973472e-02, 2.2461994e-03, 3.2602359e-03, 3.3156910e-03, 4.8475177e-04, 3.2128493e-04,
 3.4840144e-04, 8.1013394e-04, 4.0367523e-05, 3.0293084e-05, 3.9820466e-04, 5.8363539e-04, 5.0837486e-05, 2.7545638e-05,
 2.3414514e-05, 3.5676672e-05, 6.6323622e-06, 6.1898518e-07, 7.5852759e-07, 6.8492297e-07, 1.4999840e-07, 4.9458549e-08,
 1.8887824e-07, 3.8994575e-07, 2.9105761e-08, 1.0866112e-08, 1.5515413e-07, 2.0190361e-07, 2.6344258e-08, 7.1013071e-09,
 4.4071886e-03, 1.0211617e-02, 1.3752589e-03, 2.2048292e-04, 3.8705714e-04, 5.3147063e-04, 8.4319890e-05, 4.7759899e-05,
 9.4150273e-05, 2.9558158e-04, 1.5982994e-05, 1.0250189e-05, 4.9938114e-05, 9.8820404e-05, 9.3410222e-06, 4.3253918e-06,
 2.9542564e-02, 3.5779293e-02, 9.9181056e-03, 1.6929182e-03, 2.4562678e-03, 1.7629115e-03, 5.7568944e-04, 3.4716697e-04,
 5.1427184e-04, 8.4391605e-04, 9.3926250e-05, 6.4132445e-05, 5.7269991e-04, 5.9236899e-04, 1.1525164e-04, 5.6819177e-05,
 3.4002341e+00, 5.5867999e+00, 1.0512326e+00, 2.1271514e-01, 6.1358975e-01, 5.9745273e-01, 1.3243418e-01, 9.4676576e-02,
 6.4130858e-02, 1.4277240e-01, 1.0786260e-02, 8.7307960e-03, 8.1737559e-02, 1.1469846e-01, 1.5147853e-02, 8.8530124e-03,
 2.3874638e-02, 3.4828633e-02, 9.8168365e-03, 9.8822267e-04, 2.4067168e-03, 2.0806355e-03, 6.9086300e-04, 2.4570732e-04,
 5.8612953e-04, 1.1585544e-03, 1.3111197e-04, 5.2796970e-05, 5.3691235e-04, 6.6893602e-04, 1.3233592e-04, 3.8477026e-05,
 1.8591238e-05, 2.6175430e-05, 3.0075090e-06, 3.5293889e-07, 3.6751390e-07, 3.0664105e-07, 4.1505361e-08, 1.7208369e-08,
 8.0459740e-08, 1.5349244e-07, 7.0809430e-09, 3.3240461e-09, 9.6408796e-08, 1.1592672e-07, 9.3487742e-09, 3.1687486e-09,
 7.9034725e-06, 5.8163980e-06, 1.3755434e-06, 1.7186363e-07, 1.4790996e-07, 6.4506677e-08, 1.7971557e-08, 7.9330154e-09,
 2.7872299e-08, 2.7792777e-08, 2.6390208e-09, 1.3189730e-09, 7.0118819e-08, 4.4070953e-08, 7.3152711e-09, 2.6398572e-09,
 6.7075427e-02, 6.6968471e-02, 1.0750513e-02, 1.5923231e-03, 2.7244857e-03, 1.6119910e-03, 3.0484728e-04, 1.5952439e-04,
 2.5629021e-04, 3.4670645e-04, 2.2346613e-05, 1.3240266e-05, 7.3792800e-04, 6.2921987e-04, 7.0895589e-05, 3.0329241e-05,
 2.2761143e-06, 2.0176532e-06, 4.8518221e-07, 3.5751161e-08, 5.1645698e-08, 2.7130492e-08, 7.6855848e-09, 2.0008077e-09,
 1.1320394e-08, 1.3596798e-08, 1.3127609e-09, 3.8694999e-10, 2.3426008e-08, 1.7735035e-08, 2.9932881e-09, 6.3705174e-10,
 1.0689360e-02, 2.0774717e-02, 4.5070883e-03, 7.6698277e-04, 5.0569839e-04, 5.8243352e-04, 1.4885659e-04, 8.9495364e-05,
 2.4115580e-04, 6.3504456e-04, 5.5316641e-05, 3.7655524e-05, 8.7706820e-05, 1.4557896e-04, 2.2167512e-05, 1.0895500e-05,
 3.1462296e-02, 3.1961330e-02, 1.4272246e-02, 2.5858232e-03, 1.4091092e-03, 8.4830104e-04, 4.4625038e-04, 2.8564583e-04,
 5.7839062e-04, 7.9611932e-04, 1.4273708e-04, 1.0344908e-04, 4.4165250e-04, 3.8317411e-04, 1.2009418e-04, 6.2844744e-05,
 7.6486454e+00, 1.0541190e+01, 3.1951848e+00, 6.8626964e-01, 7.4349935e-01, 6.0723501e-01, 2.1683233e-01, 1.6453779e-01,
 1.5234534e-01, 2.8448343e-01, 3.4622166e-02, 2.9746542e-02, 1.3314001e-01, 1.5670944e-01, 3.3339533e-02, 2.0682301e-02,
 3.3039440e-02, 4.0428086e-02, 1.8356463e-02, 1.9614237e-03, 1.7941044e-03, 1.3009755e-03, 6.9588241e-04, 2.6270075e-04,
 8.5659516e-04, 1.4201985e-03, 2.5890813e-04, 1.1066535e-04, 5.3803484e-04, 5.6226670e-04, 1.7918685e-04, 5.5300500e-05,
 7.3023563e-07, 1.8761271e-06, 1.4778739e-07, 2.7003028e-08, 1.2502236e-08, 1.9035240e-08, 1.7664215e-09, 1.1402812e-09,
 3.3945561e-09, 1.1816939e-08, 3.7374143e-10, 2.7316767e-10, 1.3725098e-09, 3.0115913e-09, 1.6650577e-10, 8.7870811e-11,
 1.2614703e-05, 1.6940527e-05, 2.7466863e-06, 5.3431923e-07, 2.0446359e-07, 1.6271854e-07, 3.1079938e-08, 2.1360669e-08,
 4.7783911e-08, 8.6946984e-08, 5.6601418e-09, 4.4045596e-09, 4.0563746e-08, 4.6523156e-08, 5.2943105e-09, 2.9746896e-09,
 2.2344930e-02, 4.0709872e-02, 4.4804392e-03, 1.0332483e-03, 7.8606723e-04, 8.4869476e-04, 1.1003560e-04, 8.9652038e-05,
 9.1705926e-05, 2.2638150e-04, 1.0003514e-05, 9.2282642e-06, 8.9099165e-05, 1.3863598e-04, 1.0709142e-05, 7.1331199e-06,
 4.6474126e-06, 7.5175657e-06, 1.2393602e-06, 1.4218884e-07, 9.1329450e-08, 8.7548308e-08, 1.7003144e-08, 6.8919154e-09,
 2.4827231e-08, 5.4414800e-08, 3.6018714e-09, 1.6530256e-09, 1.7336433e-08, 2.3950094e-08, 2.7713124e-09, 9.1831979e-10,
 2.3220394e-04, 5.7117554e-04, 6.8217503e-05, 1.3444426e-05, 1.2370766e-05, 1.8032986e-05, 2.5371992e-06, 1.7666234e-06,
 3.2851091e-06, 1.0948953e-05, 5.2503658e-07, 4.1392282e-07, 1.4811891e-06, 3.1116582e-06, 2.6084100e-07, 1.4847833e-07,
 7.4509398e-04, 9.5799061e-04, 2.3550209e-04, 4.9414905e-05, 3.7579568e-05, 2.8633443e-05, 8.2921602e-06, 6.1471518e-06,
 8.5896479e-06, 1.4964044e-05, 1.4769748e-06, 1.2397091e-06, 8.1313043e-06, 8.9287803e-06, 1.5405768e-06, 9.3365656e-07,
 2.8876509e-01, 5.0369312e-01, 8.4050017e-02, 2.0907088e-02, 3.1610219e-02, 3.2675326e-02, 6.4232188e-03, 5.6448353e-03,
 3.6068089e-03, 8.5244662e-03, 5.7112361e-04, 5.6828879e-04, 3.9077601e-03, 5.8214427e-03, 6.8180557e-04, 4.8984276e-04,
 1.0125151e-03, 1.5680797e-03, 3.9195815e-04, 4.8504149e-05, 6.1916032e-05, 5.6825213e-05, 1.6732979e-05, 7.3156930e-06,
 1.6461845e-05, 3.4543643e-05, 3.4668116e-06, 1.7161416e-06, 1.2818535e-05, 1.6954557e-05, 2.9745134e-06, 1.0631528e-06,
 2.3670791e-06, 3.5380587e-06, 3.6050777e-07, 5.2007167e-08, 2.8385180e-08, 2.5142877e-08, 3.0180426e-09, 1.5382151e-09,
 6.7842732e-09, 1.3739737e-08, 5.6210667e-10, 3.2437760e-10, 6.9102126e-09, 8.8211438e-09, 6.3085955e-10, 2.6285838e-10,
 4.8170049e-07, 3.7633984e-07, 7.8928997e-08, 1.2122779e-08, 5.4685203e-09, 2.5318859e-09, 6.2554908e-10, 3.3944535e-10,
 1.1249991e-09, 1.1909076e-09, 1.0028253e-10, 6.1613272e-11, 2.4058260e-09, 1.6052717e-09, 2.3629958e-10, 1.0482602e-10,
 1.3765619e-02, 1.4590476e-02, 2.0771350e-03, 3.7820086e-04, 3.3918003e-04, 2.1304694e-04, 3.5729863e-05, 2.2984342e-05,
 3.4832502e-05, 5.0024327e-05, 2.8593481e-06, 2.0826122e-06, 8.5254382e-05, 7.7174151e-05, 7.7112528e-06, 4.0553027e-06,
 2.3326807e-07, 2.1952020e-07, 4.6813271e-08, 4.2404370e-09, 3.2107678e-09, 1.7906022e-09, 4.4983656e-10, 1.4395913e-10,
 7.6832074e-10, 9.7968112e-10, 8.3882272e-11, 3.0394517e-11, 1.3515429e-09, 1.0862520e-09, 1.6258603e-10, 4.2536846e-11,
 5.5565012e-02, 1.0944006e-01, 3.7008217e-02, 5.0329764e-03, 3.2034402e-03, 3.7390649e-03, 1.4895170e-03, 7.1567403e-04,
 2.0869459e-03, 5.5694109e-03, 7.5617434e-04, 4.1136932e-04, 5.4112363e-04, 9.1023395e-04, 2.1603931e-04, 8.4859446e-05,
 2.0144423e-01, 2.0738656e-01, 1.4434754e-01, 2.0900325e-02, 1.0994725e-02, 6.7078194e-03, 5.5001049e-03, 2.8135676e-03,
 6.1652304e-03, 8.5999908e-03, 2.4033541e-03, 1.3920167e-03, 3.3562833e-03, 2.9509763e-03, 1.4416251e-03, 6.0288802e-04,
 2.6436794e+01, 3.6923689e+01, 1.7445060e+01, 2.9943908e+00, 3.1316975e+00, 2.5920742e+00, 1.4426995e+00, 8.7489248e-01,
 8.7663099e-01, 1.6589613e+00, 3.1469846e-01, 2.1607966e-01, 5.4619288e-01, 6.5151470e-01, 2.1604765e-01, 1.0710906e-01,
 2.7126205e-01, 3.3638067e-01, 2.3806635e-01, 2.0329080e-02, 1.7950619e-02, 1.3191448e-02, 1.0998164e-02, 3.3180493e-03,
 1.1708358e-02, 1.9672559e-02, 5.5900882e-03, 1.9095086e-03, 5.2430056e-03, 5.5526936e-03, 2.7582179e-03, 6.8028179e-04,
 3.2889248e-06, 8.5633648e-06, 1.0514312e-06, 1.5352986e-07, 6.8620485e-08, 1.0588044e-07, 1.5314855e-08, 7.9007386e-09,
 2.5452902e-08, 8.9794766e-08, 4.4266808e-09, 2.5856740e-09, 7.3370205e-09, 1.6315177e-08, 1.4060026e-09, 5.9297826e-10,
 6.9981399e-05, 9.5240959e-05, 2.4069502e-05, 3.7419341e-06, 1.3822819e-06, 1.1148313e-06, 3.3190457e-07, 1.8229949e-07,
 4.4131710e-07, 8.1379520e-07, 8.2575075e-08, 5.1352482e-08, 2.6708964e-07, 3.1044143e-07, 5.5065670e-08, 2.4725809e-08,
 6.6918157e-02, 1.2355381e-01, 2.1195220e-02, 3.9062440e-03, 2.8687977e-03, 3.1389408e-03, 6.3434577e-04, 4.1303836e-04,
 4.5722089e-04, 1.1438296e-03, 7.8783252e-05, 5.8081591e-05, 3.1670316e-04, 4.9939708e-04, 6.0129257e-05, 3.2007184e-05,
 3.3060448e-05, 5.4195891e-05, 1.3926685e-05, 1.2768876e-06, 7.9174183e-07, 7.6915206e-07, 2.3283839e-07, 7.5422771e-08,
 2.9402842e-07, 6.5308516e-07, 6.7381719e-08, 2.4713279e-08, 1.4637629e-07, 2.0493196e-07, 3.6961453e-08, 9.7880137e-09,
 5.6514310e-04, 1.4088008e-03, 2.6226296e-04, 4.1306699e-05, 3.6691081e-05, 5.4202968e-05, 1.1886971e-05, 6.6145063e-06,
 1.3310735e-05, 4.4958976e-05, 3.3604293e-06, 2.1171977e-06, 4.2787072e-06, 9.1093078e-06, 1.1902299e-06, 5.4144534e-07,
 2.2336463e-03, 2.9104242e-03, 1.1151944e-03, 1.8700409e-04, 1.3728733e-04, 1.0600927e-04, 4.7851857e-05, 2.8349284e-05,
 4.2868933e-05, 7.5684618e-05, 1.1643751e-05, 7.8104584e-06, 2.8931917e-05, 3.2195898e-05, 8.6587021e-06, 4.1936661e-06,
 4.6731254e-01, 8.2607670e-01, 2.1485892e-01, 4.2711612e-02, 6.2339819e-02, 6.5305461e-02, 2.0009832e-02, 1.4053323e-02,
 9.7173940e-03, 2.3274781e-02, 2.4305769e-03, 1.9327930e-03, 7.5059246e-03, 1.1331789e-02, 2.0686617e-03, 1.1877439e-03,
 3.8922161e-03, 6.1087878e-03, 2.3800581e-03, 2.3537705e-04, 2.9005058e-04, 2.6977593e-04, 1.2382160e-04, 4.3262935e-05,
 1.0535075e-04, 2.2403658e-04, 3.5046296e-05, 1.3864425e-05, 5.8485377e-05, 7.8394728e-05, 2.1437660e-05, 6.1234214e-06,
 1.1034885e-05, 1.6715203e-05, 2.6547422e-06, 3.0606097e-07, 1.6125826e-07, 1.4475609e-07, 2.7083719e-08, 1.1031558e-08,
 5.2652879e-08, 1.0806593e-07, 6.8911281e-09, 3.1780396e-09, 3.8234907e-08, 4.9463542e-08, 5.5138354e-09, 1.8360306e-09,
 2.7659670e-06, 2.1899862e-06, 7.1591085e-07, 8.7874242e-08, 3.8266153e-08, 1.7954803e-08, 6.9144734e-09, 2.9985041e-09,
 1.0754387e-08, 1.1537274e-08, 1.5142983e-09, 7.4352826e-10, 1.6396358e-08, 1.1087237e-08, 2.5438935e-09, 9.0186613e-10,
 4.2670240e-02, 4.5834278e-02, 1.0170601e-02, 1.4799308e-03, 1.2812530e-03, 8.1558890e-04, 2.1320058e-04, 1.0960398e-04,
 1.7975359e-04, 2.6161688e-04, 2.3308418e-05, 1.3567233e-05, 3.1366019e-04, 2.8774397e-04, 4.4814690e-05, 1.8834576e-05,
 1.7175806e-06, 1.6380516e-06, 5.4448169e-07, 3.9415071e-08, 2.8810165e-08, 1.6282747e-08, 6.3759389e-09, 1.6306690e-09,
 9.4182030e-09, 1.2170312e-08, 1.6242333e-09, 4.7033840e-10, 1.1811500e-08, 9.6204908e-09, 2.2444553e-09, 4.6927815e-10,
 6.1408952e+00, 1.2862312e+01, 5.2924832e+00, 2.1375415e+00, 2.7243791e+00, 3.3816293e+00, 1.6391823e+00, 2.3389732e+00,
 2.7243989e+00, 7.7318059e+00, 1.2773566e+00, 2.0637192e+00, 1.2772189e+00, 2.2847262e+00, 6.5983052e-01, 7.6971171e-01,
 1.0252782e+01, 1.1224824e+01, 9.5066411e+00, 4.0878876e+00, 4.3061732e+00, 2.7938349e+00, 2.7874621e+00, 4.2347103e+00,
 3.7065103e+00, 5.4982713e+00, 1.8696670e+00, 3.2160274e+00, 3.6482431e+00, 3.4111698e+00, 2.0277225e+00, 2.5183789e+00,
 9.2727039e+01, 1.3772578e+02, 7.9177418e+01, 4.0361351e+01, 8.4527496e+01, 7.4400866e+01, 5.0387742e+01, 9.0746952e+01,
 3.6319829e+01, 7.3092905e+01, 1.6871454e+01, 3.4403300e+01, 4.0914995e+01, 5.1900643e+01, 2.0941934e+01, 3.0833405e+01,
 4.5623877e+00, 6.0165320e+00, 5.1812184e+00, 1.3139533e+00, 2.3232853e+00, 1.8156327e+00, 1.8419352e+00, 1.6503098e+00,
 2.3260977e+00, 4.1562846e+00, 1.4370817e+00, 1.4578502e+00, 1.8833096e+00, 2.1210819e+00, 1.2820379e+00, 9.3905178e-01,
 7.3607592e-03, 2.0380998e-02, 3.0449503e-03, 1.3204460e-03, 1.1817968e-03, 1.9391750e-03, 3.4129720e-04, 5.2289681e-04,
 6.7287598e-04, 2.5244168e-03, 1.5142821e-04, 2.6268216e-04, 3.5069265e-04, 8.2929907e-04, 8.6960895e-05, 1.0891932e-04,
 7.2128632e-02, 1.0439058e-01, 3.2101333e-02, 1.4821097e-02, 1.0963320e-02, 9.4030113e-03, 3.4063513e-03, 5.5563533e-03,
 5.3728546e-03, 1.0536138e-02, 1.3008706e-03, 2.4025631e-03, 5.8792288e-03, 7.2670070e-03, 1.5684666e-03, 2.0915738e-03,
 4.7531348e+00, 9.3326431e+00, 1.9480720e+00, 1.0662395e+00, 1.5680375e+00, 1.8245341e+00, 4.4865585e-01, 8.6757272e-01,
 3.8361114e-01, 1.0205603e+00, 8.5532240e-02, 1.8726777e-01, 4.8042633e-01, 8.0562452e-01, 1.1802965e-01, 1.8658695e-01,
 1.1260300e-02, 1.9629974e-02, 6.1378986e-03, 1.6712945e-03, 2.0751288e-03, 2.1438097e-03, 7.8967246e-04, 7.5966679e-04,
 1.1829318e-03, 2.7941674e-03, 3.5078677e-04, 3.8208509e-04, 1.0647568e-03, 1.5852642e-03, 3.4790402e-04, 2.7361092e-04,
 1.3817655e+00, 3.6630101e+00, 8.2974384e-01, 3.8811093e-01, 6.9032999e-01, 1.0845053e+00, 2.8939995e-01, 4.7824832e-01,
 3.8442118e-01, 1.3808099e+00, 1.2558293e-01, 2.3497731e-01, 2.2342263e-01, 5.0583902e-01, 8.0422193e-02, 1.0864971e-01,
 2.5150520e+00, 3.4849876e+00, 1.6248527e+00, 8.0917603e-01, 1.1895520e+00, 9.7680749e-01, 5.3651590e-01, 9.4396174e-01,
 5.7017003e-01, 1.0704868e+00, 2.0039424e-01, 3.9920626e-01, 6.9574143e-01, 8.2334876e-01, 2.6943538e-01, 3.8754659e-01,
 3.6261952e+01, 6.8167332e+01, 2.1573860e+01, 1.2736472e+01, 3.7224543e+01, 4.1469212e+01, 1.5461020e+01, 3.2247964e+01,
 8.9068140e+00, 2.2686649e+01, 2.8827876e+00, 6.8079643e+00, 1.2439028e+01, 1.9970677e+01, 4.4361105e+00, 7.5642146e+00,
 1.4482564e+00, 2.4172192e+00, 1.1459538e+00, 3.3656735e-01, 8.3050620e-01, 8.2145648e-01, 4.5877133e-01, 4.7604090e-01,
 4.6303681e-01, 1.0471498e+00, 1.9931988e-01, 2.3417409e-01, 4.6476602e-01, 6.6250069e-01, 2.2044252e-01, 1.8699966e-01,
 3.4547310e-02, 5.5650661e-02, 1.0754728e-02, 3.6822530e-03, 3.8849762e-03, 3.7086482e-03, 8.4431747e-04, 1.0213224e-03,
 1.9471404e-03, 4.2498772e-03, 3.2975876e-04, 4.5164161e-04, 2.5564923e-03, 3.5170802e-03, 4.7705580e-04, 4.7176302e-04,
 3.9879502e-03, 3.3578125e-03, 1.3356494e-03, 4.8688183e-04, 4.2455901e-04, 2.1184397e-04, 9.9268839e-05, 1.2784595e-04,
 1.8315451e-04, 2.0895232e-04, 3.3371363e-05, 4.8661819e-05, 5.0488052e-04, 3.6305871e-04, 1.0136099e-04, 1.0671919e-04,
 4.2397357e+00, 4.8430211e+00, 1.3076487e+00, 5.6508592e-01, 9.7964555e-01, 6.6315908e-01, 2.1093735e-01, 3.2204740e-01,
 2.1096977e-01, 3.2652831e-01, 3.5398643e-02, 6.1191808e-02, 6.6559745e-01, 6.4933771e-01, 1.2305616e-01, 1.5359155e-01,
 8.1834419e-04, 8.2996325e-04, 3.3568584e-04, 7.2167266e-05, 1.0562947e-04, 6.3486173e-05, 3.0249224e-05, 2.2975470e-05,
 5.3004918e-05, 7.2838697e-05, 1.1828429e-05, 1.0172266e-05, 1.2018837e-04, 1.0410388e-04, 2.9552846e-05, 1.8350453e-05,
 1.8475330e+00, 4.0023807e+00, 1.0310478e+00, 2.7224293e-01, 7.0448271e-01, 9.0441481e-01, 2.7446626e-01, 2.5604117e-01,
 3.9748232e-01, 1.1667205e+00, 1.2067517e-01, 1.2746160e-01, 2.1020477e-01, 3.8891104e-01, 7.0318315e-02, 5.3627450e-02,
 4.3785809e+00, 4.9580449e+00, 2.6289209e+00, 7.3904788e-01, 1.5806135e+00, 1.0606539e+00, 6.6252452e-01, 6.5802086e-01,
 7.6761531e-01, 1.1777238e+00, 2.5072717e-01, 2.8195494e-01, 8.5229965e-01, 8.2423452e-01, 3.0674387e-01, 2.4906428e-01,
 7.7701565e+01, 1.1936513e+02, 4.2961887e+01, 1.4317613e+01, 6.0878462e+01, 5.5422038e+01, 2.3498994e+01, 2.7668112e+01,
 1.4758886e+01, 3.0720207e+01, 4.4393671e+00, 5.9182262e+00, 1.8755239e+01, 2.4606607e+01, 6.2160643e+00, 5.9833350e+00,
 1.1075732e+00, 1.5106553e+00, 8.1446214e-01, 1.3503363e-01, 4.8475842e-01, 3.9182265e-01, 2.4886041e-01, 1.4577049e-01,
 2.7383880e-01, 5.0607049e-01, 1.0954868e-01, 7.2654320e-02, 2.5010299e-01, 2.9133556e-01, 1.1024445e-01, 5.2792018e-02,
 4.6017607e-04, 1.3178490e-03, 1.2326515e-04, 3.4946500e-05, 6.3501915e-05, 1.0777045e-04, 1.1875045e-05, 1.1894374e-05,
 2.0399672e-05, 7.9156745e-05, 2.9727161e-06, 3.3713211e-06, 1.1993476e-05, 2.9333798e-05, 1.9257548e-06, 1.5769025e-06,
 6.4008896e-03, 9.5814857e-03, 1.8446528e-03, 5.5679434e-04, 8.3621374e-04, 7.4178983e-04, 1.6823774e-04, 1.7941000e-04,
 2.3121941e-04, 4.6896432e-04, 3.6250352e-05, 4.3769948e-05, 2.8541055e-04, 3.6487491e-04, 4.9304152e-05, 4.2983761e-05,
 8.2764563e-01, 1.6807678e+00, 2.1964842e-01, 7.8596053e-02, 2.3467292e-01, 2.8242134e-01, 4.3478924e-02, 5.4966021e-02,
 3.2392316e-02, 8.9130868e-02, 4.6767002e-03, 6.6941496e-03, 4.5762318e-02, 7.9369325e-02, 7.2799935e-03, 7.5239199e-03,
 5.6803003e-04, 1.0241882e-03, 2.0049328e-04, 3.5690782e-05, 8.9972304e-05, 9.6136571e-05, 2.2170185e-05, 1.3943403e-05,
 2.8937936e-05, 7.0696703e-05, 5.5566088e-06, 3.9568502e-06, 2.9382472e-05, 4.5245824e-05, 6.2166471e-06, 3.1963414e-06,
 2.4963803e-01, 6.8446782e-01, 9.7068639e-02, 2.9683415e-02, 1.0719526e-01, 1.7417634e-01, 2.9098859e-02, 3.1437903e-02,
 3.3679858e-02, 1.2512249e-01, 7.1244638e-03, 8.7150620e-03, 2.2081077e-02, 5.1706378e-02, 5.1466895e-03, 4.5457266e-03,
 6.4499216e-01, 9.2437400e-01, 2.6982378e-01, 8.7848041e-02, 2.6220042e-01, 2.2268842e-01, 7.6575722e-02, 8.8081750e-02,
 7.0908530e-02, 1.3769384e-01, 1.6137569e-02, 2.1017128e-02, 9.7605089e-02, 1.1946674e-01, 2.4475845e-02, 2.3016006e-02,
 1.8246950e+01, 3.5477601e+01, 7.0295201e+00, 2.7131249e+00, 1.6099448e+01, 1.8550098e+01, 4.3299062e+00, 5.9042587e+00,
 2.1734423e+00, 5.7257851e+00, 4.5550937e-01, 7.0327427e-01, 3.4240672e+00, 5.6857487e+00, 7.9070946e-01, 8.8145794e-01,
 2.1112598e-01, 3.6446090e-01, 1.0817376e-01, 2.0770633e-02, 1.0405940e-01, 1.0645397e-01, 3.7221488e-02, 2.5250176e-02,
 3.2733920e-02, 7.6565022e-02, 9.1241432e-03, 7.0081473e-03, 3.7063564e-02, 5.4643433e-02, 1.1383262e-02, 6.3129950e-03,
 1.1569699e-02, 1.9275996e-02, 2.3322007e-03, 5.2203927e-04, 1.1182490e-03, 1.1040909e-03, 1.5736733e-04, 1.2444999e-04,
 3.1622174e-04, 7.1385433e-04, 3.4677642e-05, 3.1050599e-05, 4.6834853e-04, 6.6641632e-04, 5.6591680e-05, 3.6587289e-05,
 1.8957834e-03, 1.6509514e-03, 4.1114059e-04, 9.7981576e-05, 1.7346806e-04, 8.9523338e-05, 2.6263533e-05, 2.2113118e-05,
 4.2222415e-05, 4.9820914e-05, 4.9814804e-06, 4.7489320e-06, 1.3129391e-04, 9.7649833e-05, 1.7068109e-05, 1.1748439e-05,
 3.9546617e+00, 4.6722452e+00, 7.8980633e-01, 2.2313460e-01, 7.8538343e-01, 5.4988225e-01, 1.0950275e-01, 1.0929852e-01,
 9.5428374e-02, 1.5276254e-01, 1.0368177e-02, 1.1717422e-02, 3.3962453e-01, 3.4268638e-01, 4.0658315e-02, 3.3176944e-02,
 2.2113804e-04, 2.3196653e-04, 5.8738061e-05, 8.2556183e-06, 2.4533251e-05, 1.5250645e-05, 4.5492827e-06, 2.2590002e-06,
 6.9459270e-06, 9.8722257e-06, 1.0036910e-06, 5.6430455e-07, 1.7766705e-05, 1.5916594e-05, 2.8287989e-06, 1.1483462e-06,
 4.0470686e-01, 9.3075113e-01, 2.1263275e-01, 6.9018292e-02, 9.3612122e-02, 1.2758402e-01, 3.4336312e-02, 3.9375922e-02,
 5.7661536e-02, 1.7968099e-01, 1.6481230e-02, 2.1399666e-02, 2.5921552e-02, 5.0913832e-02, 8.1637619e-03, 7.6535856e-03,
 4.5913068e-01, 5.5192513e-01, 2.5952773e-01, 8.9688078e-02, 1.0054075e-01, 7.1623742e-02, 3.9675400e-02, 4.8441249e-02,
 5.3304861e-02, 8.6822701e-02, 1.6391844e-02, 2.2660122e-02, 5.0311323e-02, 5.1652437e-02, 1.7047171e-02, 1.7015466e-02,
 2.7435065e+01, 4.4742512e+01, 1.4281130e+01, 5.8506758e+00, 1.3039277e+01, 1.2601986e+01, 4.7385140e+00, 6.8584876e+00,
 3.4510405e+00, 7.6258369e+00, 9.7728319e-01, 1.6015751e+00, 3.7279414e+00, 5.1923627e+00, 1.1632287e+00, 1.3764140e+00,
 1.9528894e-01, 2.8277259e-01, 1.3520076e-01, 2.7555360e-02, 5.1849405e-02, 4.4491281e-02, 2.5059788e-02, 1.8044609e-02,
 3.1975707e-02, 6.2733990e-02, 1.2043020e-02, 9.8185163e-03, 2.4825289e-02, 3.0699797e-02, 1.0302324e-02, 6.0646088e-03,
 2.7184313e-04, 8.2646989e-04, 6.8554839e-05, 2.3892279e-05, 2.2755938e-05, 4.0999121e-05, 4.0063269e-06, 4.9329722e-06,
 7.9806453e-06, 3.2875277e-05, 1.0948920e-06, 1.5264205e-06, 3.9885009e-06, 1.0356190e-05, 6.0293315e-07, 6.0691656e-07,
 1.8100465e-03, 2.8763985e-03, 4.9109670e-04, 1.8222304e-04, 1.4344322e-04, 1.3508606e-04, 2.7169991e-05, 3.5617916e-05,
 4.3300583e-05, 9.3234355e-05, 6.3912352e-06, 9.4864669e-06, 4.5434895e-05, 6.1663805e-05, 7.3893512e-06, 7.9192340e-06,
 7.8807398e-01, 1.6990142e+00, 1.9690369e-01, 8.6612852e-02, 1.3554983e-01, 1.7318099e-01, 2.3643830e-02, 3.6744255e-02,
 2.0426067e-02, 5.9667489e-02, 2.7764205e-03, 4.8853689e-03, 2.4530172e-02, 4.5166061e-02, 3.6738970e-03, 4.6676264e-03,
 2.7009865e-04, 5.1700893e-04, 8.9754078e-05, 1.9641142e-05, 2.5952158e-05, 2.9438804e-05, 6.0205657e-06, 4.6547103e-06,
 9.1125282e-06, 2.3633998e-05, 1.6473440e-06, 1.4420497e-06, 7.8652057e-06, 1.2857807e-05, 1.5666831e-06, 9.9022529e-07,
 3.1509679e-02, 9.1717710e-02, 1.1534946e-02, 4.3361721e-03, 8.2077190e-03, 1.4158028e-02, 2.0976162e-03, 2.7858614e-03,
 2.8152935e-03, 1.1103397e-02, 5.6067192e-04, 8.4310765e-04, 1.5690031e-03, 3.9004499e-03, 3.4429827e-04, 3.7382308e-04,
 3.8971096e-02, 5.9292873e-02, 1.5348696e-02, 6.1429844e-03, 9.6102539e-03, 8.6649493e-03, 2.6423847e-03, 3.7363416e-03,
 2.8373093e-03, 5.8491073e-03, 6.0792422e-04, 9.7328631e-04, 3.3199453e-03, 4.3139219e-03, 7.8378896e-04, 9.0604040e-04,
 3.7123737e+00, 7.6627085e+00, 1.3464495e+00, 6.3883727e-01, 1.9869449e+00, 2.4304544e+00, 5.0310224e-01, 8.4333343e-01,
 2.9283933e-01, 8.1899881e-01, 5.7780545e-02, 1.0966430e-01, 3.9216944e-01, 6.9133074e-01, 8.5261240e-02, 1.1684016e-01,
 2.1450216e-02, 3.9310449e-02, 1.0347016e-02, 2.4423001e-03, 6.4133528e-03, 6.9651807e-03, 2.1597340e-03, 1.8010553e-03,
 2.2024613e-03, 5.4689939e-03, 5.7797009e-04, 5.4572351e-04, 2.1198610e-03, 3.3179146e-03, 6.1295750e-04, 4.1788317e-04,
 3.5290008e-03, 6.2418502e-03, 6.6972850e-04, 1.8428583e-04, 2.0691018e-04, 2.1687763e-04, 2.7413275e-05, 2.6649999e-05,
 6.3876576e-05, 1.5308276e-04, 6.5948135e-06, 7.2590356e-06, 8.0420945e-05, 1.2148211e-04, 9.1486228e-06, 7.2709215e-06,
 2.7680451e-04, 2.5590897e-04, 5.6516839e-05, 1.6557239e-05, 1.5364462e-05, 8.4178443e-06, 2.1900505e-06, 2.2667684e-06,
 4.0827008e-06, 5.1142634e-06, 4.5348848e-07, 5.3144678e-07, 1.0791929e-05, 8.5210493e-06, 1.3208187e-06, 1.1176198e-06,
 1.9443162e+00, 2.4386551e+00, 3.6557900e-01, 1.2696489e-01, 2.3423566e-01, 1.7410350e-01, 3.0746757e-02, 3.7726337e-02,
 3.1071001e-02, 5.2803358e-02, 3.1782135e-03, 4.4153898e-03, 9.3999786e-02, 1.0069122e-01, 1.0594499e-02, 1.0627310e-02,
 5.4293778e-05, 6.0461461e-05, 1.3577172e-05, 2.3458226e-06, 3.6538856e-06, 2.4113196e-06, 6.3789021e-07, 3.8938129e-07,
 1.1293716e-06, 1.7040735e-06, 1.5364192e-07, 1.0618891e-07, 2.4556339e-06, 2.3354663e-06, 3.6809685e-07, 1.8369138e-07,
 8.6374928e-01, 2.0131323e+00, 7.1685272e-01, 1.8595217e-01, 2.4347515e-01, 3.3628711e-01, 1.4106814e-01, 1.2928346e-01,
 2.0487889e-01, 6.4700038e-01, 9.2502442e-02, 9.5985962e-02, 6.5663169e-02, 1.3070375e-01, 3.2666579e-02, 2.4474577e-02,
 1.2069754e+00, 1.4703934e+00, 1.0777013e+00, 2.9763674e-01, 3.2209159e-01, 2.3253363e-01, 2.0077569e-01, 1.9590348e-01,
 2.3328799e-01, 3.8507975e-01, 1.1331985e-01, 1.2519229e-01, 1.5697884e-01, 1.6332690e-01, 8.4019558e-02, 6.7020704e-02,
 3.8933860e+01, 6.4347764e+01, 3.2013772e+01, 1.0481350e+01, 2.2550174e+01, 2.2086516e+01, 1.2944685e+01, 1.4973204e+01,
 8.1533323e+00, 1.8258464e+01, 3.6471904e+00, 4.7766357e+00, 6.2791940e+00, 8.8632215e+00, 3.0949434e+00, 2.9266691e+00,
 6.5831141e-01, 9.6601277e-01, 7.1992241e-01, 1.1725996e-01, 2.1299677e-01, 1.8522329e-01, 1.6261450e-01, 9.3576387e-02,
 1.7944767e-01, 3.5678968e-01, 1.0675931e-01, 6.9558990e-02, 9.9325687e-02, 1.2447856e-01, 6.5111137e-02, 3.0630916e-02,
 5.0269752e-04, 1.5488404e-03, 2.0025299e-04, 5.5774486e-05, 5.1281218e-05, 9.3633136e-05, 1.4261415e-05, 1.4033370e-05,
 2.4569144e-05, 1.0256827e-04, 5.3244662e-06, 5.9322012e-06, 8.7541025e-06, 2.3035270e-05, 2.0903710e-06, 1.6815915e-06,
 4.1228025e-03, 6.6396224e-03, 1.7669432e-03, 5.2395758e-04, 3.9816061e-04, 3.7999716e-04, 1.1912973e-04, 1.2480630e-04,
 1.6419523e-04, 3.5828962e-04, 3.8282837e-05, 4.5410994e-05, 1.2283048e-04, 1.6894232e-04, 3.1555522e-05, 2.7026476e-05,
 9.6901313e-01, 2.1171469e+00, 3.8244479e-01, 1.3444187e-01, 2.0311255e-01, 2.6298415e-01, 5.5963920e-02, 6.9505120e-02,
 4.1812953e-02, 1.2378145e-01, 8.9776792e-03, 1.2624472e-02, 3.5799485e-02, 6.6800527e-02, 8.4694560e-03, 8.5992741e-03,
 7.8889211e-04, 1.5303278e-03, 4.1409673e-04, 7.2418804e-05, 9.2372752e-05, 1.0618961e-04, 3.3850118e-05, 2.0914747e-05,
 4.4309571e-05, 1.1646288e-04, 1.2653060e-05, 8.8517402e-06, 2.7265821e-05, 4.5171751e-05, 8.5791089e-06, 4.3334348e-06,
 3.1486916e-02, 9.2881886e-02, 1.8207667e-02, 5.4699359e-03, 9.9950194e-03, 1.7472524e-02, 4.0349666e-03, 4.2826302e-03,
 4.6835321e-03, 1.8719631e-02, 1.4733683e-03, 1.7706086e-03, 1.8609025e-03, 4.6881963e-03, 6.4504050e-04, 5.5970027e-04,
 4.7967105e-02, 7.3959652e-02, 2.9841808e-02, 9.5448638e-03, 1.4414883e-02, 1.3171452e-02, 6.2607262e-03, 7.0747709e-03,
 5.8139489e-03, 1.2146346e-02, 1.9677350e-03, 2.5176475e-03, 4.8500370e-03, 6.3867233e-03, 1.8086986e-03, 1.6709044e-03,
 2.4666745e+00, 5.1598156e+00, 1.4131982e+00, 5.3584635e-01, 1.6088715e+00, 1.9944115e+00, 6.4349390e-01, 8.6203448e-01,
 3.2393174e-01, 9.1811872e-01, 1.0096211e-01, 1.5313661e-01, 3.0927694e-01, 5.5252417e-01, 1.0621312e-01, 1.1632038e-01,
 3.3855132e-02, 6.2877064e-02, 2.5796485e-02, 4.8661059e-03, 1.2335383e-02, 1.3576629e-02, 6.5617713e-03, 4.3730536e-03,
 5.7871518e-03, 1.4563157e-02, 2.3989144e-03, 1.8101687e-03, 3.9711278e-03, 6.2988761e-03, 1.8138000e-03, 9.8821319e-04,
 6.7546689e-03, 1.2107585e-02, 2.0249023e-03, 4.4528110e-04, 4.8262481e-04, 5.1266547e-04, 1.0100466e-04, 7.8471978e-05,
 2.0354377e-04, 4.9434963e-04, 3.3194901e-05, 2.9200142e-05, 1.8269861e-04, 2.7968542e-04, 3.2830274e-05, 2.0851883e-05,
 6.5259004e-04, 6.1142662e-04, 2.1047375e-04, 4.9277099e-05, 4.4142808e-05, 2.4509542e-05, 9.9391545e-06, 8.2212818e-06,
 1.6024284e-05, 2.0342558e-05, 2.8115760e-06, 2.6331790e-06, 3.0198130e-05, 2.4163805e-05, 5.8381687e-06, 3.9478843e-06,
 2.4745348e+00, 3.1453474e+00, 7.3495491e-01, 2.0398589e-01, 3.6329121e-01, 2.7365343e-01, 7.5327558e-02, 7.3864582e-02,
 6.5833331e-02, 1.1338186e-01, 1.0637181e-02, 1.1809983e-02, 1.4199307e-01, 1.5414288e-01, 2.5279795e-02, 2.0265323e-02,
 1.6413802e-04, 1.8523772e-04, 6.4836718e-05, 8.9524983e-06, 1.3461376e-05, 9.0028653e-06, 3.7122151e-06, 1.8109197e-06,
 5.6840763e-06, 8.6916623e-06, 1.2214773e-06, 6.7467082e-07, 8.8112262e-06, 8.4925469e-06, 2.0863512e-06, 8.3205317e-07,
 1.4184147e-01, 2.7052273e-01, 1.1966008e-01, 4.2364383e-02, 1.2553073e-02, 1.4188020e-02, 7.3931264e-03, 9.2474610e-03,
 1.9950047e-02, 5.1554564e-02, 9.1559551e-03, 1.2966972e-02, 5.7815845e-03, 9.4173547e-03, 2.9236978e-03, 2.9896786e-03,
 3.1327476e-01, 3.1230334e-01, 2.8433429e-01, 1.0717601e-01, 2.6247388e-02, 1.5506307e-02, 1.6631136e-02, 2.2147939e-02,
 3.5904639e-02, 4.8498110e-02, 1.7728331e-02, 2.6731288e-02, 2.1846282e-02, 1.8599883e-02, 1.1885588e-02, 1.2939861e-02,
 3.2350456e+01, 4.3752438e+01, 2.7039182e+01, 1.2082431e+01, 5.8827817e+00, 4.7149393e+00, 3.4326391e+00, 5.4191571e+00,
 4.0171606e+00, 7.3614658e+00, 1.8266116e+00, 3.2650538e+00, 2.7974760e+00, 3.2312444e+00, 1.4015835e+00, 1.8089241e+00,
 5.1201946e-02, 6.1482810e-02, 5.6917308e-02, 1.2652866e-02, 5.2012509e-03, 3.7012325e-03, 4.0364344e-03, 3.1701898e-03,
 8.2760641e-03, 1.3465242e-02, 5.0049040e-03, 4.4506510e-03, 4.1421528e-03, 4.2479058e-03, 2.7600920e-03, 1.7721824e-03,
 3.7215870e-05, 9.3830567e-05, 1.5069692e-05, 5.7285046e-06, 1.1919537e-06, 1.7809306e-06, 3.3695180e-07, 4.5253036e-07,
 1.0785557e-06, 3.6845258e-06, 2.3759246e-07, 3.6128732e-07, 3.4749023e-07, 7.4823880e-07, 8.4344774e-08, 9.2605256e-08,
 4.8242050e-04, 6.3575869e-04, 2.1016451e-04, 8.5057621e-05, 1.4627528e-05, 1.1423759e-05, 4.4487379e-06, 6.3611210e-06,
 1.1392644e-05, 2.0342961e-05, 2.7000514e-06, 4.3712853e-06, 7.7063437e-06, 8.6735453e-06, 2.0124338e-06, 2.3524260e-06,
 3.6298466e-01, 6.4897193e-01, 1.4562357e-01, 6.9867906e-02, 2.3887765e-02, 2.5309540e-02, 6.6903807e-03, 1.1340698e-02,
 9.2875468e-03, 2.2498910e-02, 2.0270194e-03, 3.8903394e-03, 7.1902661e-03, 1.0979027e-02, 1.7291308e-03, 2.3961520e-03,
 2.7661658e-05, 4.3909791e-05, 1.4759320e-05, 3.5228683e-06, 1.0169147e-06, 9.5661847e-07, 3.7879530e-07, 3.1943131e-07,
 9.2127596e-07, 1.9815069e-06, 2.6741853e-07, 2.5533189e-07, 5.1261209e-07, 6.9494953e-07, 1.6395188e-07, 1.1302823e-07,
 5.9587750e-03, 1.4383806e-02, 3.5025537e-03, 1.4361275e-03, 5.9386834e-04, 8.4952901e-04, 2.4369705e-04, 3.5302180e-04,
 5.2557081e-04, 1.7189812e-03, 1.6806338e-04, 2.7565435e-04, 1.8882504e-04, 3.8927616e-04, 6.6531440e-05, 7.8790868e-05,
 1.4347673e-02, 1.8102931e-02, 9.0733345e-03, 3.9608853e-03, 1.3537207e-03, 1.0122028e-03, 5.9764944e-04, 9.2175340e-04,
 1.0311942e-03, 1.7629135e-03, 3.5476420e-04, 6.1951011e-04, 7.7784434e-04, 8.3818842e-04, 2.9486117e-04, 3.7177770e-04,
 2.3619790e+00, 4.0430986e+00, 1.3755330e+00, 7.1185015e-01, 4.8368784e-01, 4.9065334e-01, 1.9664922e-01, 3.5954456e-01,
 1.8392843e-01, 4.2658922e-01, 5.8271663e-02, 1.2063087e-01, 1.5878928e-01, 2.3213503e-01, 5.5431338e-02, 8.2854027e-02,
 3.0345243e-03, 4.6118406e-03, 2.3503391e-03, 6.0510655e-04, 3.4713554e-04, 3.1264651e-04, 1.8770272e-04, 1.7073205e-04,
 3.0758283e-04, 6.3338637e-04, 1.2960320e-04, 1.3347508e-04, 1.9084870e-04, 2.4771632e-04, 8.8607148e-05, 6.5888638e-05,
 1.7053085e-04, 2.5013370e-04, 5.1964484e-05, 1.5596145e-05, 3.8255008e-06, 3.3252844e-06, 8.1381178e-07, 8.6293390e-07,
 3.0471076e-06, 6.0559206e-06, 5.0513229e-07, 6.0645591e-07, 2.4731099e-06, 3.0980924e-06, 4.5173779e-07, 3.9159556e-07,
 2.6040587e-05, 1.9965071e-05, 8.5371303e-06, 2.7279696e-06, 5.5303183e-07, 2.5127035e-07, 1.2657363e-07, 1.4289393e-07,
 3.7915794e-07, 3.9387913e-07, 6.7623109e-08, 8.6438247e-08, 6.4609983e-07, 4.2305906e-07, 1.2696979e-07, 1.1718402e-07,
 3.1610405e-01, 3.2879167e-01, 9.5433468e-02, 3.6151018e-02, 1.4570387e-02, 8.9811734e-03, 3.0709572e-03, 4.1099510e-03,
 4.9866997e-03, 7.0279200e-03, 8.1902583e-04, 1.2410831e-03, 9.7255200e-03, 8.6394294e-03, 1.7600421e-03, 1.9256769e-03,
 1.9626712e-06, 1.8125227e-06, 7.8806673e-07, 1.4851375e-07, 5.0536774e-08, 2.7657627e-08, 1.4166256e-08, 9.4319534e-09,
 4.0302245e-08, 5.0429901e-08, 8.8035645e-09, 6.6365986e-09, 5.6491618e-08, 4.4555528e-08, 1.3596871e-08, 7.4008799e-09,
 3.7672180e-02, 7.4312206e-02, 2.0579063e-02, 4.7632138e-03, 2.8655624e-03, 3.3498114e-03, 1.0928153e-03, 8.9364316e-04,
 2.5694959e-03, 6.8676847e-03, 7.6360097e-04, 7.0700814e-04, 8.4000376e-04, 1.4151487e-03, 2.7505887e-04, 1.8388253e-04,
 1.1810661e-01, 1.2177675e-01, 6.9412338e-02, 1.7105198e-02, 8.5050599e-03, 5.1968326e-03, 3.4895699e-03, 3.0381289e-03,
 6.5642623e-03, 9.1706228e-03, 2.0987577e-03, 2.0688871e-03, 4.5055010e-03, 3.9674807e-03, 1.5872482e-03, 1.1297354e-03,
 2.3930992e+01, 3.3475072e+01, 1.2951873e+01, 3.7836952e+00, 3.7402928e+00, 3.1005433e+00, 1.4132193e+00, 1.4585994e+00,
 1.4410736e+00, 2.7313031e+00, 4.2429883e-01, 4.9583700e-01, 1.1320444e+00, 1.3524017e+00, 3.6726096e-01, 3.0988394e-01,
 1.0972957e-02, 1.3627929e-02, 7.8984239e-03, 1.1479103e-03, 9.5804855e-04, 7.0512310e-04, 4.8143369e-04, 2.4719898e-04,
 8.6009762e-04, 1.4473610e-03, 3.3680492e-04, 1.9580743e-04, 4.8560165e-04, 5.1507186e-04, 2.0952523e-04, 8.7951656e-05,
 2.0539344e-06, 5.3560112e-06, 5.3854439e-07, 1.3383863e-07, 5.6540603e-08, 8.7374872e-08, 1.0349694e-08, 9.0871962e-09,
 2.8866070e-08, 1.0199186e-07, 4.1175258e-09, 4.0933571e-09, 1.0491021e-08, 2.3364379e-08, 1.6488922e-09, 1.1835663e-09,
 3.7793360e-05, 5.1513502e-05, 1.0661241e-05, 2.8208796e-06, 9.8492513e-07, 7.9557312e-07, 1.9396694e-07, 1.8132073e-07,
 4.3281359e-07, 7.9933629e-07, 6.6421250e-08, 7.0301933e-08, 3.3025920e-07, 3.8445210e-07, 5.5845337e-08, 4.2678019e-08,
 5.5796819e-02, 1.0317776e-01, 1.4494775e-02, 4.5465356e-03, 3.1560158e-03, 3.4584927e-03, 5.7236528e-04, 6.3428620e-04,
 6.9232314e-04, 1.7346355e-03, 9.7841841e-05, 1.2276566e-04, 6.0462099e-04, 9.5486297e-04, 9.4150867e-05, 8.5297057e-05,
 1.2318461e-06, 2.0224535e-06, 4.2560186e-07, 6.6413505e-08, 3.8922914e-08, 3.7870261e-08, 9.3882356e-09, 5.1758286e-09,
 1.9895490e-08, 4.4258767e-08, 3.7395133e-09, 2.3342713e-09, 1.2487744e-08, 1.7510045e-08, 2.5862481e-09, 1.1656375e-09,
 9.5036442e-04, 2.3727163e-03, 3.6172358e-04, 9.6963456e-05, 8.1407811e-05, 1.2044611e-04, 2.1631401e-05, 2.0486075e-05,
 4.0649124e-05, 1.3750859e-04, 8.4168856e-06, 9.0254008e-06, 1.6474398e-05, 3.5127472e-05, 3.7586841e-06, 2.9100981e-06,
 3.2482236e-03, 4.2388914e-03, 1.3301182e-03, 3.7961075e-04, 2.6341230e-04, 2.0371059e-04, 7.5302979e-05, 7.5928235e-05,
 1.1321179e-04, 2.0018015e-04, 2.5220260e-05, 2.8792619e-05, 9.6332758e-05, 1.0736478e-04, 2.3645997e-05, 1.9491555e-05,
 1.0492333e+00, 1.8575868e+00, 3.9566319e-01, 1.3386478e-01, 1.8467315e-01, 1.9375459e-01, 4.8617144e-02, 5.8112924e-02,
 3.9621545e-02, 9.5045494e-02, 8.1282870e-03, 1.1000770e-02, 3.8586379e-02, 5.8343493e-02, 8.7222243e-03, 8.5233116e-03,
 3.9052052e-04, 6.1385572e-04, 1.9585847e-04, 3.2966035e-05, 3.8396739e-05, 3.5767457e-05, 1.3443892e-05, 7.9945175e-06,
 1.9195600e-05, 4.0883409e-05, 5.2373816e-06, 3.5263206e-06, 1.3435671e-05, 1.8036967e-05, 4.0392194e-06, 1.9636410e-06,
 5.0415944e-05, 7.6484929e-05, 9.9478723e-06, 1.9519275e-06, 9.7206577e-07, 8.7392598e-07, 1.3390288e-07, 9.2825304e-08,
 4.3685679e-07, 8.9798747e-07, 4.6893798e-08, 3.6807153e-08, 3.9996771e-07, 5.1822065e-07, 4.7307169e-08, 2.6810255e-08,
 1.0928151e-05, 8.6657375e-06, 2.3198860e-06, 4.8463755e-07, 1.9947500e-07, 9.3738621e-08, 2.9562448e-08, 2.1818956e-08,
 7.7161878e-08, 8.2905715e-08, 8.9112047e-09, 7.4468123e-09, 1.4832442e-07, 1.0045066e-07, 1.8874341e-08, 1.1388408e-08,
 2.6029012e-01, 2.8001882e-01, 5.0884671e-02, 1.2601723e-02, 1.0311957e-02, 6.5741810e-03, 1.4073514e-03, 1.2313700e-03,
 1.9912578e-03, 2.9025517e-03, 2.1177300e-04, 2.0979581e-04, 4.3808376e-03, 4.0250237e-03, 5.1336481e-04, 3.6720574e-04,
 4.6820067e-07, 4.4720524e-07, 1.2173243e-07, 1.4997990e-08, 1.0361786e-08, 5.8651736e-09, 1.8807927e-09, 8.1867314e-10,
 4.6623037e-09, 6.0339044e-09, 6.5945981e-10, 3.2501125e-10, 7.3720024e-09, 6.0136997e-09, 1.1489449e-09, 4.0885212e-10,
 2.9189752e-03, 6.1127507e-03, 1.5012002e-03, 4.2713886e-04, 1.3468930e-04, 1.6715158e-04, 4.8358515e-05, 4.8612336e-05,
 1.3184929e-04, 3.7411641e-04, 3.6889222e-05, 4.1986859e-05, 3.6640483e-05, 6.5531323e-05, 1.1295583e-05, 9.2828159e-06,
 4.3806495e-03, 4.7950774e-03, 2.4238418e-03, 7.3426308e-04, 1.9136177e-04, 1.2413184e-04, 7.3918465e-05, 7.9112141e-05,
 1.6123909e-04, 2.3913894e-04, 4.8534399e-05, 5.8813983e-05, 9.4075817e-05, 8.7945965e-05, 3.1202043e-05, 2.7300518e-05,
 2.9888112e+00, 4.4383956e+00, 1.5229072e+00, 5.4690657e-01, 2.8337167e-01, 2.4937650e-01, 1.0080074e-01, 1.2789291e-01,
 1.1919110e-01, 2.3982498e-01, 3.3039438e-02, 4.7463082e-02, 7.9592379e-02, 1.0094400e-01, 2.4310045e-02, 2.5215418e-02,
 6.8436861e-04, 9.0232529e-04, 4.6377790e-04, 8.2857830e-05, 3.6246606e-05, 2.8321191e-05, 1.7148230e-05, 1.0823946e-05,
 3.5525020e-05, 6.3464374e-05, 1.3096884e-05, 9.3599821e-06, 1.7049699e-05, 1.9198678e-05, 6.9258997e-06, 3.5738814e-06,
 4.2918318e-07, 1.1881313e-06, 1.0594507e-07, 3.2366562e-08, 7.1668735e-09, 1.1757710e-08, 1.2350936e-09, 1.3330878e-09,
 3.9945109e-09, 1.4983333e-08, 5.3643305e-10, 6.5556322e-10, 1.2340819e-09, 2.9177459e-09, 1.8260875e-10, 1.6113059e-10,
 3.7802967e-06, 5.4701412e-06, 1.0039723e-06, 3.2655368e-07, 5.9762306e-08, 5.1247296e-08, 1.1080390e-08, 1.2732999e-08,
 2.8670271e-08, 5.6211759e-08, 4.1422947e-09, 5.3896084e-09, 1.8596706e-08, 2.2982109e-08, 2.9605398e-09, 2.7812779e-09,
 1.8792888e-02, 3.6892394e-02, 4.5961964e-03, 1.7722448e-03, 6.4481711e-04, 7.5015486e-04, 1.1009655e-04, 1.4998285e-04,
 1.5442331e-04, 4.1075134e-04, 2.0546209e-05, 3.1691312e-05, 1.1464029e-04, 1.9220384e-04, 1.6806673e-05, 1.8717486e-05,
 2.0719027e-07, 3.6112534e-07, 6.7393734e-08, 1.2927905e-08, 3.9712880e-09, 4.1019560e-09, 9.0180667e-10, 6.1117447e-10,
 2.2160891e-09, 5.2335798e-09, 3.9214901e-10, 3.0091469e-10, 1.1824062e-09, 1.7600986e-09, 2.3054526e-10, 1.2773377e-10,
 4.2431172e-05, 1.1246242e-04, 1.5204591e-05, 5.0102805e-06, 2.2048254e-06, 3.4631226e-06, 5.5156404e-07, 6.4213494e-07,
 1.2018932e-06, 4.3162974e-06, 2.3429859e-07, 3.0884493e-07, 4.1407111e-07, 9.3730027e-07, 8.8941378e-08, 8.4650954e-08,
 6.9421755e-05, 9.6176426e-05, 2.6763501e-05, 9.3896014e-06, 3.4150647e-06, 2.8037752e-06, 9.1913267e-07, 1.1392665e-06,
 1.6023642e-06, 3.0078585e-06, 3.3606422e-07, 4.7163930e-07, 1.1590277e-06, 1.3713503e-06, 2.6784320e-07, 2.7140970e-07,
 7.5508281e-02, 1.4191834e-01, 2.6807210e-02, 1.1149312e-02, 8.0619446e-03, 8.9795570e-03, 1.9981523e-03, 2.9360825e-03,
 1.8883134e-03, 4.8088490e-03, 3.6470767e-04, 6.0677080e-04, 1.5632445e-03, 2.5092981e-03, 3.3267721e-04, 3.9963204e-04,
 1.4034449e-05, 2.3419865e-05, 6.6266950e-06, 1.3711260e-06, 8.3706522e-07, 8.2778909e-07, 2.7592629e-07, 2.0170479e-07,
 4.5684967e-07, 1.0329649e-06, 1.1735157e-07, 9.7129786e-08, 2.7181988e-07, 3.8739311e-07, 7.6934728e-08, 4.5977268e-08,
 5.4394991e-06, 8.7606003e-06, 1.0104726e-06, 2.4373280e-07, 6.3620944e-08, 6.0722007e-08, 8.2508262e-09, 7.0312105e-09,
 3.1214068e-08, 6.8115907e-08, 3.1544935e-09, 3.0437059e-09, 2.4293306e-08, 3.3415115e-08, 2.7051512e-09, 1.8846108e-09,
 5.6440717e-07, 4.7513638e-07, 1.1280170e-07, 2.8968254e-08, 6.2495334e-09, 3.1177735e-09, 8.7197242e-10, 7.9113799e-10,
 2.6391787e-09, 3.0103513e-09, 2.8694957e-10, 2.9477818e-10, 4.3124938e-09, 3.1005287e-09, 5.1664400e-10, 3.8321121e-10,
 4.5266480e-02, 5.1697908e-02, 8.3312330e-03, 2.5363440e-03, 1.0878611e-03, 7.3627672e-04, 1.3977779e-04, 1.5034188e-04,
 2.2933296e-04, 3.5488350e-04, 2.2962161e-05, 2.7963725e-05, 4.2889055e-04, 4.1833525e-04, 4.7317155e-05, 4.1606201e-05,
 4.0661175e-08, 4.1230787e-08, 9.9530760e-09, 1.5074403e-09, 5.4587831e-10, 3.2802631e-10, 9.3283577e-11, 4.9914980e-11,
 2.6814413e-10, 3.6841139e-10, 3.5707509e-11, 2.1633431e-11, 3.6041554e-10, 3.1212376e-10, 5.2883526e-11, 2.3133623e-11,
 2.0183261e-02, 4.2834035e-02, 1.6396532e-02, 3.7283759e-03, 1.1349300e-03, 1.4273749e-03, 6.4366783e-04, 5.1709738e-04,
 1.5177578e-03, 4.3643855e-03, 6.7077480e-04, 6.1013756e-04, 3.0070147e-04, 5.4502298e-04, 1.4643189e-04, 9.6170930e-05,
 3.7309035e-02, 4.1386883e-02, 3.2608626e-02, 7.8943608e-03, 1.9861223e-03, 1.3056472e-03, 1.2118708e-03, 1.0365344e-03,
 2.2861775e-03, 3.4362213e-03, 1.0870306e-03, 1.0527121e-03, 9.5096986e-04, 9.0094191e-04, 4.9822394e-04, 3.4837712e-04,
 1.3741478e+01, 2.0680100e+01, 1.1060153e+01, 3.1742259e+00, 1.5876943e+00, 1.4159813e+00, 8.9212706e-01, 9.0457895e-01,
 9.1231057e-01, 1.8603081e+00, 3.9947010e-01, 4.5861100e-01, 4.3433010e-01, 5.5823961e-01, 2.0954976e-01, 1.7370181e-01,
 7.4740787e-03, 9.9867044e-03, 8.0007413e-03, 1.1423275e-03, 4.8240327e-04, 3.8198450e-04, 3.6050795e-04, 1.8185207e-04,
 6.4590043e-04, 1.1693732e-03, 3.7614222e-04, 2.1483048e-04, 2.2100288e-04, 2.5219945e-04, 1.4181100e-04, 5.8480474e-05,
 2.5712517e-06, 7.2136968e-06, 1.0026178e-06, 2.4478698e-07, 5.2324742e-08, 8.6994445e-08, 1.4243926e-08, 1.2286434e-08,
 3.9840933e-08, 1.5144873e-07, 8.4514966e-09, 8.2541108e-09, 8.7752530e-09, 2.1025891e-08, 2.0511132e-09, 1.4463818e-09,
 2.7896043e-05, 4.0907853e-05, 1.1702831e-05, 3.0420110e-06, 5.3742662e-07, 4.6704022e-07, 1.5739811e-07, 1.4454806e-07,
 3.5221850e-07, 6.9984038e-07, 8.0384826e-08, 8.3584811e-08, 1.6287937e-07, 2.0399126e-07, 4.0959405e-08, 3.0751369e-08,
 7.4863396e-02, 1.4893762e-01, 2.8921938e-02, 8.9122959e-03, 3.1303138e-03, 3.6905736e-03, 8.4426294e-04, 9.1914255e-04,
 1.0241237e-03, 2.7606440e-03, 2.1524063e-04, 2.6532000e-04, 5.4203449e-04, 9.2096491e-04, 1.2552319e-04, 1.1171892e-04,
 1.9605502e-06, 3.4630460e-06, 1.0073505e-06, 1.5442817e-07, 4.5794705e-08, 4.7936525e-08, 1.6426678e-08, 8.8969026e-09,
 3.4910790e-08, 8.3553142e-08, 9.7583386e-09, 5.9841930e-09, 1.3279718e-08, 2.0033217e-08, 4.0900725e-09, 1.8109962e-09,
 1.3736766e-04, 3.6897642e-04, 7.7754779e-05, 2.0476310e-05, 8.6985972e-06, 1.3846319e-05, 3.4373501e-06, 3.1980928e-06,
 6.4778302e-06, 2.3575801e-05, 1.9947365e-06, 2.1013273e-06, 1.5910658e-06, 3.6499216e-06, 5.3984598e-07, 4.1061503e-07,
 2.7682799e-04, 3.8866434e-04, 1.6858153e-04, 4.7266276e-05, 1.6595430e-05, 1.3807796e-05, 7.0553852e-06, 6.9888364e-06,
 1.0637495e-05, 2.0236116e-05, 3.5241398e-06, 3.9525539e-06, 5.4855697e-06, 6.5776072e-06, 2.0024478e-06, 1.6215975e-06,
 1.6254322e-01, 3.0960229e-01, 9.1154539e-02, 3.0297856e-02, 2.1148957e-02, 2.3872383e-02, 8.2800060e-03, 9.7231517e-03,
 6.7672453e-03, 1.7465071e-02, 2.0645966e-03, 2.7450637e-03, 3.9940584e-03, 6.4972781e-03, 1.3426515e-03, 1.2889548e-03,
 7.1763161e-05, 1.2136198e-04, 5.3524923e-05, 8.8506159e-06, 5.2160434e-06, 5.2274887e-06, 2.7159848e-06, 1.5866739e-06,
 3.8890511e-06, 8.9114286e-06, 1.5780174e-06, 1.0437883e-06, 1.6496852e-06, 2.3826673e-06, 7.3755572e-07, 3.5225154e-07,
 3.3730680e-05, 5.5054351e-05, 9.8979043e-06, 1.9079637e-06, 4.8077454e-07, 4.6502799e-07, 9.8489889e-08, 6.7075113e-08,
 3.2224081e-07, 7.1263916e-07, 5.1441342e-08, 3.9666371e-08, 1.7879941e-07, 2.4923793e-07, 3.1450231e-08, 1.7510201e-08,
 4.3109552e-06, 3.6778205e-06, 1.3609725e-06, 2.7931402e-07, 5.8170667e-08, 2.9409817e-08, 1.2820697e-08, 9.2960432e-09,
 3.3559334e-08, 3.8792997e-08, 5.7637191e-09, 4.7318386e-09, 3.9095153e-08, 2.8485358e-08, 7.3984082e-09, 4.3855324e-09,
 1.8664530e-01, 2.1602542e-01, 5.4262806e-02, 1.3201955e-02, 5.4662466e-03, 3.7492841e-03, 1.1094472e-03, 9.5364183e-04,
 1.5742386e-03, 2.4687754e-03, 2.4898303e-04, 2.4231981e-04, 2.0989419e-03, 2.0747694e-03, 3.6578444e-04, 2.5704050e-04,
 3.9824720e-07, 4.0924751e-07, 1.5398667e-07, 1.8638143e-08, 6.5154421e-09, 3.9677874e-09, 1.7587587e-09, 7.5208804e-10,
 4.3722512e-09, 6.0878141e-09, 9.1970576e-10, 4.4529935e-10, 4.1897666e-09, 3.6770933e-09, 9.7108961e-10, 3.3948422e-10,
 1.0617628e+00, 1.3772622e+00, 7.6336450e-01, 1.7685118e-01, 2.3779771e-01, 1.8279659e-01, 1.1935592e-01, 9.7692892e-02,
 1.4462554e-01, 2.5418919e-01, 5.6566986e-02, 5.2423085e-02, 8.9864635e-02, 9.9554190e-02, 3.8728655e-02, 2.5914886e-02,
 8.6115568e-02, 5.8387747e-02, 6.6610651e-02, 1.6429981e-02, 1.8258950e-02, 7.3364701e-03, 9.8598421e-03, 8.5922316e-03,
 9.5583683e-03, 8.7810561e-03, 4.0221619e-03, 3.9685878e-03, 1.2469565e-02, 7.2205972e-03, 5.7816633e-03, 4.1189512e-03,
 3.0001875e+01, 2.7596817e+01, 2.1370745e+01, 6.2489246e+00, 1.3806528e+01, 7.5260351e+00, 6.8657479e+00, 7.0927763e+00,
 3.6079807e+00, 4.4967400e+00, 1.3981356e+00, 1.6353779e+00, 5.3870622e+00, 4.2319864e+00, 2.3001858e+00, 1.9426251e+00,
 3.2742902e-01, 2.6740738e-01, 3.1019416e-01, 4.5123491e-02, 8.4172873e-02, 4.0737985e-02, 5.5669915e-02, 2.8610967e-02,
 5.1254475e-02, 5.6716709e-02, 2.6415680e-02, 1.5371435e-02, 5.5001501e-02, 3.8362966e-02, 3.1234195e-02, 1.3123213e-02,
 7.1843384e-04, 1.2319462e-03, 2.4792545e-04, 6.1671247e-05, 5.8230646e-05, 5.9173579e-05, 1.4028724e-05, 1.2328850e-05,
 2.0164058e-05, 4.6849617e-05, 3.7855263e-06, 3.7667884e-06, 1.3928964e-05, 2.0398835e-05, 2.8813278e-06, 2.0701172e-06,
 3.4199228e-04, 3.0652925e-04, 1.2697214e-04, 3.3626901e-05, 2.6241906e-05, 1.3938698e-05, 6.8017297e-06, 6.3641543e-06,
 7.8215378e-06, 9.4988434e-06, 1.5797846e-06, 1.6736303e-06, 1.1343755e-05, 8.6834833e-06, 2.5245750e-06, 1.9311113e-06,
 8.6814193e-01, 1.0556432e+00, 2.9681943e-01, 9.3188659e-02, 1.4458107e-01, 1.0418591e-01, 3.4510000e-02, 3.8278824e-02,
 2.1511975e-02, 3.5442931e-02, 4.0012491e-03, 5.0251589e-03, 3.5707977e-02, 3.7082849e-02, 7.3182302e-03, 6.6361673e-03,
 4.5618793e-04, 4.9251055e-04, 2.0743886e-04, 3.2399983e-05, 4.2440789e-05, 2.7153536e-05, 1.3472924e-05, 7.4346291e-06,
 1.4714041e-05, 2.1524186e-05, 3.6399212e-06, 2.2742071e-06, 1.7553823e-05, 1.6185465e-05, 4.7847336e-06, 2.1585039e-06,
 1.0753419e-01, 1.7654362e-01, 5.3868234e-02, 1.4453256e-02, 2.7121488e-02, 2.6387014e-02, 9.4848766e-03, 8.9909904e-03,
 9.1853992e-03, 2.0432735e-02, 2.5032138e-03, 2.6866696e-03, 7.0756605e-03, 9.9209679e-03, 2.1246755e-03, 1.6465165e-03,
 9.5083075e-03, 8.1594260e-03, 5.1244477e-03, 1.4638509e-03, 2.2703061e-03, 1.1545472e-03, 8.5420090e-04, 8.6209054e-04,
 6.6181883e-04, 7.6951747e-04, 1.9404249e-04, 2.2173284e-04, 1.0703655e-03, 7.8445853e-04, 3.4579224e-04, 2.8530271e-04,
 5.2809207e+00, 6.1480369e+00, 2.6209742e+00, 8.8757494e-01, 2.7367321e+00, 1.8881247e+00, 9.4823862e-01, 1.1344956e+00,
 3.9825315e-01, 6.2821638e-01, 1.0752915e-01, 1.4566393e-01, 7.3717780e-01, 7.3296095e-01, 2.1931331e-01, 2.1451003e-01,
 4.6782916e-02, 4.8357011e-02, 3.0880569e-02, 5.2024887e-03, 1.3543440e-02, 8.2960698e-03, 6.2410690e-03, 3.7147356e-03,
 4.5923570e-03, 6.4317749e-03, 1.6491015e-03, 1.1113648e-03, 6.1094710e-03, 5.3933371e-03, 2.4173595e-03, 1.1762715e-03,
 1.0162662e-02, 1.0138309e-02, 2.6391818e-03, 5.1832798e-04, 5.7693408e-04, 3.4107945e-04, 1.0459722e-04, 7.2576891e-05,
 1.7586081e-04, 2.3771139e-04, 2.4845334e-05, 1.9519270e-05, 3.0603112e-04, 2.6073851e-04, 4.7639465e-05, 2.7023567e-05,
 5.6988511e-05, 2.9716387e-05, 1.5922334e-05, 3.3293459e-06, 3.0628106e-06, 9.4645513e-07, 5.9740893e-07, 4.4133325e-07,
 8.0358817e-07, 5.6776044e-07, 1.2214249e-07, 1.0216503e-07, 2.9359862e-06, 1.3075073e-06, 4.9171427e-07, 2.9696525e-07,
 2.3338790e+00, 1.6510415e+00, 6.0049211e-01, 1.4885101e-01, 2.7224058e-01, 1.1413100e-01, 4.8900569e-02, 4.2825390e-02,
 3.5656477e-02, 3.4177529e-02, 4.9909261e-03, 4.9489037e-03, 1.4910038e-01, 9.0082375e-02, 2.2995733e-02, 1.6463886e-02,
 9.9921444e-05, 6.2760102e-05, 3.4192634e-05, 4.2165830e-06, 6.5110675e-06, 2.4235296e-06, 1.5554576e-06, 6.7768708e-07,
 1.9870897e-06, 1.6910845e-06, 3.6991763e-07, 1.8248057e-07, 5.9719055e-06, 3.2034598e-06, 1.2249719e-06, 4.3630986e-07,
 1.8816052e-01, 2.5243922e-01, 8.7597483e-02, 1.3267555e-02, 3.6220221e-02, 2.8797207e-02, 1.1771892e-02, 6.2992417e-03,
 1.2428892e-02, 2.2593510e-02, 3.1478168e-03, 1.9071820e-03, 8.7117725e-03, 9.9819704e-03, 2.4311356e-03, 1.0635278e-03,
 2.1662774e-02, 1.5191237e-02, 1.0850127e-02, 1.7496486e-03, 3.9477604e-03, 1.6405928e-03, 1.3803955e-03, 7.8643420e-04,
 1.1660118e-03, 1.1079101e-03, 3.1771460e-04, 2.0494468e-04, 1.7159345e-03, 1.0276869e-03, 5.1518207e-04, 2.3994810e-04,
 1.4808539e+01, 1.4088412e+01, 6.8303417e+00, 1.3057223e+00, 5.8572082e+00, 3.3022625e+00, 1.8860485e+00, 1.2738086e+00,
 8.6360414e-01, 1.1132354e+00, 2.1669981e-01, 1.6571063e-01, 1.4545635e+00, 1.1818541e+00, 4.0216321e-01, 2.2205023e-01,
 4.6820714e-02, 3.9548798e-02, 2.8721915e-02, 2.7315257e-03, 1.0345120e-02, 5.1784737e-03, 4.4303959e-03, 1.4885987e-03,
 3.5541779e-03, 4.0677767e-03, 1.1861182e-03, 4.5123568e-04, 4.3024148e-03, 3.1037644e-03, 1.5820741e-03, 4.3456980e-04,
 2.6456281e-05, 4.6921582e-05, 5.9118302e-06, 9.6140519e-07, 1.8430459e-06, 1.9370961e-06, 2.8751565e-07, 1.6519188e-07,
 3.6008636e-07, 8.6531354e-07, 4.3773735e-08, 2.8476165e-08, 2.8059348e-07, 4.2501379e-07, 3.7584618e-08, 1.7653682e-08,
 1.7876794e-05, 1.6572355e-05, 4.2977429e-06, 7.4411812e-07, 1.1789925e-06, 6.4770403e-07, 1.9787637e-07, 1.2104263e-07,
 1.9826786e-07, 2.4904023e-07, 2.5930838e-08, 1.7959797e-08, 3.2437467e-07, 2.5681662e-07, 4.6745211e-08, 2.3376479e-08,
 8.9042142e-02, 1.1198526e-01, 1.9713143e-02, 4.0462211e-03, 1.2745554e-02, 9.4993784e-03, 1.9699315e-03, 1.4285243e-03,
 1.0699704e-03, 1.8233085e-03, 1.2886821e-04, 1.0580909e-04, 2.0034879e-03, 2.1519565e-03, 2.6588056e-04, 1.5762341e-04,
 1.3555190e-05, 1.5136184e-05, 3.9912675e-06, 4.0755700e-07, 1.0838962e-06, 7.1724822e-07, 2.2280495e-07, 8.0379486e-08,
 2.1202172e-07, 3.2078501e-07, 3.3962473e-08, 1.3872680e-08, 2.8533199e-07, 2.7210878e-07, 5.0361076e-08, 1.4852966e-08,
 1.1443617e-02, 1.9431578e-02, 3.7120013e-03, 6.5112485e-04, 2.4806917e-03, 2.4962514e-03, 5.6175846e-04, 3.4813567e-04,
 4.7402527e-04, 1.0906082e-03, 8.3648844e-05, 5.8694752e-05, 4.1190835e-04, 5.9734674e-04, 8.0091227e-05, 4.0577140e-05,
 1.4363209e-03, 1.2748136e-03, 5.0124940e-04, 9.3611025e-05, 2.9476433e-04, 1.5503909e-04, 7.1814014e-05, 4.7383285e-05,
 4.8481265e-05, 5.8303145e-05, 9.2042886e-06, 6.8761673e-06, 8.8449857e-05, 6.7046128e-05, 1.8502860e-05, 9.9805012e-06,
 1.5652694e+00, 1.8847552e+00, 5.0303843e-01, 1.1136953e-01, 6.9719528e-01, 4.9749802e-01, 1.5642214e-01, 1.2235064e-01,
 5.7243414e-02, 9.3393025e-02, 1.0008093e-02, 8.8633835e-03, 1.1952774e-01, 1.2291814e-01, 2.3026092e-02, 1.4724002e-02,
 4.0172017e-03, 4.2947213e-03, 1.7170408e-03, 1.8911653e-04, 9.9955783e-04, 6.3327233e-04, 2.9826125e-04, 1.1606160e-04,
 1.9123122e-04, 2.7700843e-04, 4.4466125e-05, 1.9591234e-05, 2.8698361e-04, 2.6202924e-04, 7.3528094e-05, 2.3390680e-05,
 2.0047297e-03, 2.0684865e-03, 3.3711372e-04, 4.3284728e-05, 9.7817590e-05, 5.9811557e-05, 1.1483376e-05, 5.2091977e-06,
 1.6823019e-05, 2.3519283e-05, 1.5389998e-06, 7.9046084e-07, 3.3024079e-05, 2.9101081e-05, 3.3288233e-06, 1.2344956e-06,
 1.5957581e-05, 8.6062632e-06, 2.8869891e-06, 3.9465732e-07, 7.3712684e-07, 2.3559222e-07, 9.3100590e-08, 4.4964583e-08,
 1.0911893e-07, 7.9738917e-08, 1.0739690e-08, 5.8728710e-09, 4.4972842e-07, 2.0714739e-07, 4.8771707e-08, 1.9256778e-08,
 1.2822998e+00, 9.3822694e-01, 2.1363727e-01, 3.4621408e-02, 1.2856019e-01, 5.5743740e-02, 1.4952921e-02, 8.5612386e-03,
 9.5002748e-03, 9.4184077e-03, 8.6106830e-04, 5.5819833e-04, 4.4813278e-02, 2.8003131e-02, 4.4754211e-03, 2.0947964e-03,
 1.5904745e-05, 1.0332142e-05, 3.5241911e-06, 2.8412589e-07, 8.9076432e-07, 3.4292393e-07, 1.3779309e-07, 3.9248373e-08,
 1.5338125e-07, 1.3500782e-07, 1.8489214e-08, 5.9628409e-09, 5.1999319e-07, 2.8849824e-07, 6.9066885e-08, 1.6082797e-08,
 7.5684837e-02, 1.0779635e-01, 3.3172271e-02, 6.1763276e-03, 8.8378131e-03, 7.4595222e-03, 2.7042268e-03, 1.7788570e-03,
 3.3108008e-03, 6.3892636e-03, 7.8942889e-04, 5.8796500e-04, 1.9726827e-03, 2.3995721e-03, 5.1827824e-04, 2.7871385e-04,
 4.1710842e-03, 3.1052375e-03, 1.9668578e-03, 3.8989269e-04, 4.6110425e-04, 2.0343056e-04, 1.5179416e-04, 1.0630901e-04,
 1.4868179e-04, 1.4997764e-04, 3.8141296e-05, 3.0244813e-05, 1.8599699e-04, 1.1825881e-04, 5.2573782e-05, 3.0101078e-05,
 9.6010886e+00, 9.6969865e+00, 4.1692099e+00, 9.7975674e-01, 2.3036274e+00, 1.3787952e+00, 6.9835734e-01, 5.7980891e-01,
 3.7080266e-01, 5.0743726e-01, 8.7597168e-02, 8.2345119e-02, 5.3089817e-01, 4.5794068e-01, 1.3819235e-01, 9.3797060e-02,
 1.5159156e-02, 1.3593683e-02, 8.7549445e-03, 1.0235325e-03, 2.0318231e-03, 1.0797397e-03, 8.1921182e-04, 3.3836642e-04,
 7.6207253e-04, 9.2593620e-04, 2.3943534e-04, 1.1197469e-04, 7.8418667e-04, 6.0056910e-04, 2.7147965e-04, 9.1669747e-05,
 2.8698248e-05, 5.4033867e-05, 6.0374245e-06, 1.2069586e-06, 1.2127635e-06, 1.3531875e-06, 1.7811663e-07, 1.2580211e-07,
 2.5867435e-07, 6.5991338e-07, 2.9604897e-08, 2.3674851e-08, 1.7134622e-07, 2.7552862e-07, 2.1607790e-08, 1.2476461e-08,
 9.2826293e-06, 9.1354973e-06, 2.1009949e-06, 4.4718006e-07, 3.7136909e-07, 2.1658998e-07, 5.8680210e-08, 4.4125760e-08,
 6.8179475e-08, 9.0915454e-08, 8.3950086e-09, 7.1476297e-09, 9.4819698e-08, 7.9696859e-08, 1.2864467e-08, 7.9084245e-09,
 1.5568622e-01, 2.0786535e-01, 3.2449911e-02, 8.1877259e-03, 1.3518441e-02, 1.0696202e-02, 1.9670796e-03, 1.7535363e-03,
 1.2389287e-03, 2.2413077e-03, 1.4048296e-04, 1.4179366e-04, 1.9720208e-03, 2.2486667e-03, 2.4638502e-04, 1.7955797e-04,
 1.1835563e-05, 1.4030286e-05, 3.2809317e-06, 4.1184210e-07, 5.7409580e-07, 4.0330453e-07, 1.1110273e-07, 4.9272096e-08,
 1.2259813e-07, 1.9691741e-07, 1.8488671e-08, 9.2837383e-09, 1.4025041e-07, 1.4199171e-07, 2.3305141e-08, 8.4494011e-09,
 2.6523365e-03, 4.7812344e-03, 8.0998458e-04, 1.7465816e-04, 3.4878001e-04, 3.7259243e-04, 7.4358684e-05, 5.6648254e-05,
 7.2759023e-05, 1.7771378e-04, 1.2087846e-05, 1.0426631e-05, 5.3744771e-05, 8.2742587e-05, 9.8383832e-06, 6.1274010e-06,
 1.5935713e-04, 1.5015281e-04, 5.2357268e-05, 1.2020049e-05, 1.9838476e-05, 1.1077495e-05, 4.5503621e-06, 3.6907777e-06,
 3.5621665e-06, 4.5477754e-06, 6.3669784e-07, 5.8471735e-07, 5.5244303e-06, 4.4456063e-06, 1.0880085e-06, 7.2144322e-07,
 5.8476630e-01, 7.4750683e-01, 1.7692845e-01, 4.8152505e-02, 1.5800146e-01, 1.1969194e-01, 3.3374001e-02, 3.2090199e-02,
 1.4162462e-02, 2.4529830e-02, 2.3311361e-03, 2.5378886e-03, 2.5138086e-02, 2.7443941e-02, 4.5591786e-03, 3.5838409e-03,
 7.4945523e-04, 8.5059702e-04, 3.0158230e-04, 4.0832950e-05, 1.1312104e-04, 7.6083875e-05, 3.1778647e-05, 1.5201390e-05,
 2.3626588e-05, 3.6333050e-05, 5.1721921e-06, 2.8013224e-06, 3.0140430e-05, 2.9215215e-05, 7.2702419e-06, 2.8431149e-06,
 1.1228397e-03, 1.2299325e-03, 1.7776293e-04, 2.8057929e-05, 3.3234729e-05, 2.1573822e-05, 3.6732291e-06, 2.0483550e-06,
 6.2400206e-06, 9.2613131e-06, 5.3743198e-07, 3.3932921e-07, 1.0412685e-05, 9.7411004e-06, 9.8815707e-07, 4.5048556e-07,
 4.2784195e-06, 2.4496152e-06, 7.2872679e-07, 1.2246051e-07, 1.1988699e-07, 4.0677818e-08, 1.4255597e-08, 8.4636855e-09,
 1.9374759e-08, 1.5030509e-08, 1.7952772e-09, 1.2068297e-09, 6.7879252e-08, 3.3191966e-08, 6.9303921e-09, 3.3637961e-09,
 1.1576549e+00, 8.9921654e-01, 1.8158074e-01, 3.6173738e-02, 7.0405974e-02, 3.2409028e-02, 7.7096096e-03, 5.4262381e-03,
 5.6799677e-03, 5.9779723e-03, 4.8467485e-04, 3.8624011e-04, 2.2775440e-02, 1.5108921e-02, 2.1413962e-03, 1.2321431e-03,
 7.1704315e-06, 4.9451097e-06, 1.4958266e-06, 1.4824788e-07, 2.4360983e-07, 9.9562657e-08, 3.5478270e-08, 1.2422610e-08,
 4.5794217e-08, 4.2792155e-08, 5.1970893e-09, 2.0603965e-09, 1.3197349e-07, 7.7731788e-08, 1.6502948e-08, 4.7239961e-09,
 1.7296027e-01, 2.4965073e-01, 1.1974718e-01, 1.7817949e-02, 2.4612602e-02, 2.1053059e-02, 1.1896208e-02, 6.2537968e-03,
 1.2596046e-02, 2.4634505e-02, 4.7442427e-03, 2.8238565e-03, 5.3506715e-03, 6.5959342e-03, 2.2205806e-03, 9.5433174e-04,
 1.1740892e-02, 8.8580633e-03, 8.7453642e-03, 1.3854377e-03, 1.5817095e-03, 7.0718835e-04, 8.2249855e-04, 4.6034913e-04,
 6.9674502e-04, 7.1225257e-04, 2.8233469e-04, 1.7891910e-04, 6.2140072e-04, 4.0039652e-04, 2.7745180e-04, 1.2695138e-04,
 1.4589219e+01, 1.4932763e+01, 1.0007329e+01, 1.8794029e+00, 4.2657893e+00, 2.5874888e+00, 2.0427601e+00, 1.3553820e+00,
 9.3803396e-01, 1.3009168e+00, 3.5004051e-01, 2.6296812e-01, 9.5749496e-01, 8.3700116e-01, 3.9369674e-01, 2.1355208e-01,
 5.4716632e-02, 4.9724775e-02, 4.9917209e-02, 4.6637537e-03, 8.9372823e-03, 4.8131556e-03, 5.6920472e-03, 1.8788688e-03,
 4.5793556e-03, 5.6387225e-03, 2.2727356e-03, 8.4941063e-04, 3.3595209e-03, 2.6074265e-03, 1.8371628e-03, 4.9576228e-04,
 5.6824293e-05, 1.0842668e-04, 1.8883520e-05, 3.0168988e-06, 2.9263752e-06, 3.3090502e-06, 6.7890826e-07, 3.8320525e-07,
 8.5269892e-07, 2.2045538e-06, 1.5415527e-07, 9.8518889e-08, 4.0268623e-07, 6.5622113e-07, 8.0214893e-08, 3.7014617e-08,
 2.2639369e-05, 2.2579645e-05, 8.0941430e-06, 1.3767825e-06, 1.1037592e-06, 6.5237637e-07, 2.7549447e-07, 1.6555810e-07,
 2.7682827e-07, 3.7409885e-07, 5.3843200e-08, 3.6636071e-08, 2.7447665e-07, 2.3379733e-07, 5.8823562e-08, 2.8899236e-08,
 2.0497588e-01, 2.7734898e-01, 6.7486831e-02, 1.3608360e-02, 2.1689759e-02, 1.7391996e-02, 4.9854303e-03, 3.5516694e-03,
 2.7155828e-03, 4.9786246e-03, 4.8639908e-04, 3.9234045e-04, 3.0816124e-03, 3.5610902e-03, 6.0818156e-04, 3.5421001e-04,
 3.7014694e-05, 4.4467549e-05, 1.6208213e-05, 1.6259452e-06, 2.1879888e-06, 1.5577044e-06, 6.6886419e-07, 2.3705636e-07,
 6.3831189e-07, 1.0390224e-06, 1.5205740e-07, 6.1018514e-08, 5.2059858e-07, 5.3413791e-07, 1.3664798e-07, 3.9592644e-08,
 2.8379522e-03, 5.1845139e-03, 1.3690078e-03, 2.3591467e-04, 4.5478206e-04, 4.9235373e-04, 1.5315669e-04, 9.3245512e-05,
 1.2960663e-04, 3.2081362e-04, 3.4012726e-05, 2.3446284e-05, 6.8253714e-05, 1.0649042e-04, 1.9736325e-05, 9.8232674e-06,
 2.1002092e-04, 2.0054698e-04, 1.0899857e-04, 1.9998015e-05, 3.1862125e-05, 1.8030156e-05, 1.1544232e-05, 7.4829670e-06,
 7.8157247e-06, 1.0112197e-05, 2.2066883e-06, 1.6195359e-06, 8.6415608e-06, 7.0473691e-06, 2.6883752e-06, 1.4246114e-06,
 4.1603815e-01, 5.3896106e-01, 1.9883867e-01, 4.3247324e-02, 1.3698939e-01, 1.0516775e-01, 4.5707429e-02, 3.5122714e-02,
 1.6774646e-02, 2.9444261e-02, 4.3614893e-03, 3.7946921e-03, 2.1227384e-02, 2.3485631e-02, 6.0814014e-03, 3.8203444e-03,
 1.2665701e-03, 1.4567958e-03, 8.0508492e-04, 8.7113154e-05, 2.3297094e-04, 1.5879718e-04, 1.0338237e-04, 3.9521324e-05,
 6.6473394e-05, 1.0359542e-04, 2.2986565e-05, 9.9494650e-06, 6.0456935e-05, 5.9387796e-05, 2.3035534e-05, 7.1991407e-06,
 2.3012313e-03, 2.5545583e-03, 5.7548870e-04, 7.2591889e-05, 8.3006154e-05, 5.4605550e-05, 1.4491678e-05, 6.4582216e-06,
 2.1290830e-05, 3.2023647e-05, 2.8965619e-06, 1.4615628e-06, 2.5329064e-05, 2.4013528e-05, 3.7969509e-06, 1.3833336e-06,
 1.0800424e-05, 6.2668185e-06, 2.9058613e-06, 3.9025028e-07, 3.6881187e-07, 1.2681832e-07, 6.9274103e-08, 3.2868672e-08,
 8.1425027e-08, 6.4015716e-08, 1.1918055e-08, 6.4026123e-09, 2.0337995e-07, 1.0078494e-07, 3.2800579e-08, 1.2723030e-08,
 1.5775973e+00, 1.2418612e+00, 3.9087667e-01, 6.2230079e-02, 1.1692353e-01, 5.4544356e-02, 2.0224484e-02, 1.1375779e-02,
 1.2886257e-02, 1.3744421e-02, 1.7369370e-03, 1.1061855e-03, 3.6838100e-02, 2.4765977e-02, 5.4711698e-03, 2.5158303e-03,
 2.3211053e-05, 1.6222473e-05, 7.6486228e-06, 6.0579757e-07, 9.6099147e-07, 3.9802739e-07, 2.2107513e-07, 6.1862470e-08,
 2.4678794e-07, 2.3370563e-07, 4.4241124e-08, 1.4016964e-08, 5.0704863e-07, 3.0265882e-07, 1.0015611e-07, 2.2911967e-08,
 1.2792657e+00, 1.3834814e+00, 1.0954008e+00, 1.7074899e-01, 2.2296747e-01, 1.4289766e-01, 1.3328635e-01, 7.3402956e-02,
 1.5695201e-01, 2.2998644e-01, 7.3112721e-02, 4.5589115e-02, 7.8059091e-02, 7.2097040e-02, 4.0065913e-02, 1.8038510e-02,
 6.7009734e+00, 3.7879217e+00, 6.1731629e+00, 1.0244943e+00, 1.1056879e+00, 3.7039644e-01, 7.1110609e-01, 4.1694548e-01,
 6.6992863e-01, 5.1311514e-01, 3.3574699e-01, 2.2289348e-01, 6.9953424e-01, 3.3771755e-01, 3.8629419e-01, 1.8516568e-01,
 3.2716865e+01, 2.5090290e+01, 2.7755622e+01, 5.4606607e+00, 1.1716778e+01, 5.3249236e+00, 6.9393608e+00, 4.8234355e+00,
 3.5438561e+00, 3.6824182e+00, 1.6355699e+00, 1.2872019e+00, 4.2352272e+00, 2.7739093e+00, 2.1537509e+00, 1.2238553e+00,
 3.8269341e+00, 2.6057357e+00, 4.3179261e+00, 4.2262296e-01, 7.6560784e-01, 3.0892778e-01, 6.0306275e-01, 2.0853705e-01,
 5.3957783e-01, 4.9780163e-01, 3.3120120e-01, 1.2967409e-01, 4.6345731e-01, 2.6950725e-01, 3.1345349e-01, 8.8611824e-02,
 6.0938191e-04, 8.7119953e-04, 2.5045627e-04, 4.1918145e-05, 3.8437475e-05, 3.2565228e-05, 1.1028824e-05, 6.5214233e-06,
 1.5405271e-05, 2.9841490e-05, 3.4444942e-06, 2.3061047e-06, 8.5177104e-06, 1.0399979e-05, 2.0984788e-06, 1.0144142e-06,
 1.8734488e-02, 1.3999760e-02, 8.2840280e-03, 1.4761447e-03, 1.1187197e-03, 4.9541736e-04, 3.4534493e-04, 2.1741182e-04,
 3.8592795e-04, 3.9075807e-04, 9.2836733e-05, 6.6174458e-05, 4.4800564e-04, 2.8591953e-04, 1.1874713e-04, 6.1115402e-05,
 6.6647442e-01, 6.7566759e-01, 2.7138934e-01, 5.7328729e-02, 8.6378243e-02, 5.1894980e-02, 2.4555334e-02, 1.8326029e-02,
 1.4875155e-02, 2.0433098e-02, 3.2952225e-03, 2.7845031e-03, 1.9763284e-02, 1.7111583e-02, 4.8240062e-03, 2.9432550e-03,
 3.7535897e-03, 3.3786381e-03, 2.0328301e-03, 2.1363107e-04, 2.7176082e-04, 1.4496164e-04, 1.0274797e-04, 3.8148661e-05,
 1.0904949e-04, 1.3299688e-04, 3.2128584e-05, 1.3506358e-05, 1.0413009e-04, 8.0048387e-05, 3.3804140e-05, 1.0260619e-05,
 1.4276073e-01, 1.9540582e-01, 8.5173150e-02, 1.5376038e-02, 2.8020509e-02, 2.2728767e-02, 1.1670841e-02, 7.4436647e-03,
 1.0983704e-02, 2.0370435e-02, 3.5649740e-03, 2.5744328e-03, 6.7722101e-03, 7.9166364e-03, 2.4219420e-03, 1.2628336e-03,
 8.1524541e-01, 5.8326739e-01, 5.2328676e-01, 1.0057702e-01, 1.5148501e-01, 6.4227373e-02, 6.7881783e-02, 4.6095108e-02,
 5.1110829e-02, 4.9546749e-02, 1.7847531e-02, 1.3722087e-02, 6.6163507e-02, 4.0427713e-02, 2.5457118e-02, 1.4132158e-02,
 6.3454392e+00, 6.1590228e+00, 3.7507891e+00, 8.5462127e-01, 2.5590856e+00, 1.4719945e+00, 1.0560342e+00, 8.5010346e-01,
 4.3102252e-01, 5.6685641e-01, 1.3860371e-01, 1.2633078e-01, 6.3859536e-01, 5.2936786e-01, 2.2626963e-01, 1.4890786e-01,
 6.0248970e-01, 5.1921257e-01, 4.7364790e-01, 5.3689605e-02, 1.3573497e-01, 6.9319997e-02, 7.4495438e-02, 2.9833721e-02,
 5.3270477e-02, 6.2202094e-02, 2.2782752e-02, 1.0330568e-02, 5.6724072e-02, 4.1748843e-02, 2.6730853e-02, 8.7516128e-03,
 7.2818583e-04, 6.0565232e-04, 2.2522248e-04, 2.9761583e-05, 3.2170779e-05, 1.5856736e-05, 6.9464531e-06, 3.2430238e-06,
 1.1349914e-05, 1.2790766e-05, 1.9097476e-06, 1.0094933e-06, 1.5808899e-05, 1.1229603e-05, 2.9309660e-06, 1.1186529e-06,
 2.6372109e-04, 1.1465075e-04, 8.7755042e-05, 1.2346192e-05, 1.1030065e-05, 2.8417196e-06, 2.5623431e-06, 1.2736244e-06,
 3.3494981e-06, 1.9730335e-06, 6.0634621e-07, 3.4124411e-07, 9.7951849e-06, 3.6368554e-06, 1.9537959e-06, 7.9392748e-07,
 1.5135717e-01, 8.9270044e-02, 4.6380981e-02, 7.7355822e-03, 1.3739725e-02, 4.8023300e-03, 2.9393201e-03, 1.7319804e-03,
 2.0828201e-03, 1.6644756e-03, 3.4721800e-04, 2.3165349e-04, 6.9711551e-03, 3.5114711e-03, 1.2805042e-03, 6.1684316e-04,
 6.9453443e-05, 3.6369873e-05, 2.8305809e-05, 2.3486183e-06, 3.5219865e-06, 1.0929669e-06, 1.0020777e-06, 2.9375251e-07,
 1.2440594e-06, 8.8269819e-07, 2.7582675e-07, 9.1549681e-08, 2.9926044e-06, 1.3383781e-06, 7.3108904e-07, 1.7520557e-07,
 3.2130290e-01, 3.5939006e-01, 1.7814991e-01, 1.8154884e-02, 4.8132415e-02, 3.1905102e-02, 1.8631192e-02, 6.7079740e-03,
 1.9116458e-02, 2.8972216e-02, 5.7662301e-03, 2.3506238e-03, 1.0724918e-02, 1.0245351e-02, 3.5645478e-03, 1.0491866e-03,
 2.3890377e+00, 1.3967703e+00, 1.4251202e+00, 1.5462380e-01, 3.3881302e-01, 1.1739058e-01, 1.4109793e-01, 5.4086436e-02,
 1.1582446e-01, 9.1754044e-02, 3.7587421e-02, 1.6313642e-02, 1.3643029e-01, 6.8123083e-02, 4.8784166e-02, 1.5287771e-02,
 2.2886975e+01, 1.8153531e+01, 1.2572636e+01, 1.6171244e+00, 7.0447766e+00, 3.3113961e+00, 2.7017014e+00, 1.2277147e+00,
 1.2022073e+00, 1.2920381e+00, 3.5927843e-01, 1.8485520e-01, 1.6207278e+00, 1.0979041e+00, 5.3368814e-01, 1.9826456e-01,
 7.7557640e-01, 5.4618878e-01, 5.6664020e-01, 3.6258379e-02, 1.3335903e-01, 5.5655988e-02, 6.8020124e-02, 1.5377333e-02,
 5.3029092e-02, 5.0600559e-02, 2.1077100e-02, 5.3950458e-03, 5.1380693e-02, 3.0902937e-02, 2.2502065e-02, 4.1587578e-03,
 3.1804201e-05, 4.7027417e-05, 8.4641871e-06, 9.2614403e-07, 1.7242177e-06, 1.5108801e-06, 3.2035010e-07, 1.2384004e-07,
 3.8989792e-07, 7.8116096e-07, 5.6450216e-08, 2.4708256e-08, 2.4318373e-07, 3.0710211e-07, 3.8794910e-08, 1.2260518e-08,
 1.3879309e-03, 1.0727179e-03, 3.9739867e-04, 4.6295270e-05, 7.1234402e-05, 3.2627099e-05, 1.4239024e-05, 5.8604816e-06,
 1.3864971e-05, 1.4519762e-05, 2.1596893e-06, 1.0064328e-06, 1.8156260e-05, 1.1984656e-05, 3.1161945e-06, 1.0485163e-06,
 9.6881564e-02, 1.0158494e-01, 2.5545194e-02, 3.5278616e-03, 1.0792064e-02, 6.7060109e-03, 1.9865736e-03, 9.6928169e-04,
 1.0485897e-03, 1.4897631e-03, 1.5041377e-04, 8.3094683e-05, 1.5715696e-03, 1.4073545e-03, 2.4839385e-04, 9.9079576e-05,
 1.5807438e-04, 1.4716180e-04, 5.5433753e-05, 3.8085582e-06, 9.8365787e-06, 5.4268644e-06, 2.4081801e-06, 5.8454515e-07,
 2.2270242e-06, 2.8091933e-06, 4.2486549e-07, 1.1676727e-07, 2.3988749e-06, 1.9073162e-06, 5.0426623e-07, 1.0006603e-07,
 2.1531691e-02, 3.0482163e-02, 8.3182315e-03, 9.8173817e-04, 3.6323521e-03, 3.0473815e-03, 9.7965410e-04, 4.0848904e-04,
 8.0334964e-04, 1.5409742e-03, 1.6883839e-04, 7.9711189e-05, 5.5874900e-04, 6.7556297e-04, 1.2939246e-04, 4.4107677e-05,
 1.7453763e-01, 1.2915383e-01, 7.2543651e-02, 9.1155100e-03, 2.7874878e-02, 1.2223690e-02, 8.0882634e-03, 3.5907043e-03,
 5.3064036e-03, 5.3203683e-03, 1.1998426e-03, 6.0309990e-04, 7.7488265e-03, 4.8970630e-03, 1.9305710e-03, 7.0066108e-04,
 2.6655944e+00, 2.6759818e+00, 1.0202668e+00, 1.5198047e-01, 9.2397349e-01, 5.4969260e-01, 2.4689452e-01, 1.2993561e-01,
 8.7804904e-02, 1.1943482e-01, 1.8283218e-02, 1.0894564e-02, 1.4674891e-01, 1.2581880e-01, 3.3669299e-02, 1.4485999e-02,
 7.3322798e-02, 6.5354196e-02, 3.7325329e-02, 2.7660586e-03, 1.4197878e-02, 7.4994482e-03, 5.0456865e-03, 1.3210547e-03,
 3.1438539e-03, 3.7968192e-03, 8.7064456e-04, 2.5809641e-04, 3.7763612e-03, 2.8746806e-03, 1.1523320e-03, 2.4664705e-04,
 2.0358389e-04, 1.7513109e-04, 4.0772907e-05, 3.5224000e-06, 7.7304520e-06, 3.9409076e-06, 1.0808495e-06, 3.2989472e-07,
 1.5387931e-06, 1.7935905e-06, 1.6765728e-07, 5.7939220e-08, 2.4177955e-06, 1.7763192e-06, 2.9026007e-07, 7.2426074e-08,
 1.0465913e-04, 4.7059551e-05, 2.2550860e-05, 2.0741830e-06, 3.7622935e-06, 1.0025239e-06, 5.6594070e-07, 1.8390679e-07,
 6.4461230e-07, 3.9272846e-07, 7.5561118e-08, 2.7801344e-08, 2.1264822e-06, 8.1660895e-07, 2.7465483e-07, 7.2964472e-08,
 1.1786013e-01, 7.1896630e-02, 2.3386353e-02, 2.5499916e-03, 9.1956862e-03, 3.3242758e-03, 1.2738316e-03, 4.9071706e-04,
 7.8650642e-04, 6.5007995e-04, 8.4900731e-05, 3.7031493e-05, 2.9695145e-03, 1.5470655e-03, 3.5319984e-04, 1.1123392e-04,
 1.5668036e-05, 8.4859708e-06, 4.1348050e-06, 2.2429267e-07, 6.8289051e-07, 2.1918412e-07, 1.2581236e-07, 2.4111620e-08,
 1.3609701e-07, 9.9875364e-08, 1.9539021e-08, 4.2398069e-09, 3.6930648e-07, 1.7082656e-07, 5.8420690e-08, 9.1530814e-09,
 6.0460855e-02, 7.1794704e-02, 3.1560815e-02, 3.9537766e-03, 5.4942783e-03, 3.8663398e-03, 2.0022418e-03, 8.8618353e-04,
 2.3822474e-03, 3.8329048e-03, 6.7651088e-04, 3.3901739e-04, 1.1361190e-03, 1.1521884e-03, 3.5549806e-04, 1.2862984e-04,
 2.1519744e-01, 1.3356909e-01, 1.2085609e-01, 1.6119429e-02, 1.8513471e-02, 6.8096938e-03, 7.2585748e-03, 3.4203857e-03,
 6.9093049e-03, 5.8106704e-03, 2.1109601e-03, 1.1262737e-03, 6.9182368e-03, 3.6672924e-03, 2.3289841e-03, 8.9719679e-04,
 6.9418589e+00, 5.8454173e+00, 3.5901862e+00, 5.6766221e-01, 1.2961887e+00, 6.4681302e-01, 4.6799510e-01, 2.6143112e-01,
 2.4148316e-01, 2.7551762e-01, 6.7942537e-02, 4.2973258e-02, 2.7673738e-01, 1.9901638e-01, 8.5792318e-02, 3.9179775e-02,
 1.1747369e-01, 8.7826578e-02, 8.0802880e-02, 6.3559954e-03, 1.2253269e-02, 5.4288544e-03, 5.8839653e-03, 1.6351960e-03,
 5.3192514e-03, 5.3883831e-03, 1.9904450e-03, 6.2631186e-04, 4.3811336e-03, 2.7973895e-03, 1.8063919e-03, 4.1040188e-04,
 1.6139496e-05, 2.5335169e-05, 4.0438416e-06, 5.4393054e-07, 5.3077570e-07, 4.9376028e-07, 9.2842609e-08, 4.4120401e-08,
 1.3103181e-07, 2.7869765e-07, 1.7860534e-08, 9.6100873e-09, 6.9472116e-08, 9.3137752e-08, 1.0434070e-08, 4.0536290e-09,
 3.3715408e-04, 2.7663856e-04, 9.0884558e-05, 1.3015362e-05, 1.0496959e-05, 5.1041002e-06, 1.9754103e-06, 9.9946217e-07,
 2.2304854e-06, 2.4797442e-06, 3.2709581e-07, 1.8738053e-07, 2.4828881e-06, 1.7398953e-06, 4.0119765e-07, 1.6594534e-07,
 7.9245518e-02, 8.8212450e-02, 1.9671880e-02, 3.3396758e-03, 5.3549039e-03, 3.5324665e-03, 9.2801475e-04, 5.5661675e-04,
 5.6801467e-04, 8.5671765e-04, 7.6708700e-05, 5.2093838e-05, 7.2366472e-04, 6.8797720e-04, 1.0768324e-04, 5.2801592e-05,
 6.4568958e-05, 6.3815241e-05, 2.1317673e-05, 1.8004549e-06, 2.4373606e-06, 1.4275507e-06, 5.6178210e-07, 1.6763049e-07,
 6.0243094e-07, 8.0673498e-07, 1.0820252e-07, 3.6556357e-08, 5.5162044e-07, 4.6561019e-07, 1.0916815e-07, 2.6630457e-08,
 2.3346554e-03, 3.5087882e-03, 8.4913913e-04, 1.2319681e-04, 2.3891647e-04, 2.1279021e-04, 6.0664402e-05, 3.1095505e-05,
 5.7685861e-05, 1.1746997e-04, 1.1414036e-05, 6.6243477e-06, 3.4106071e-05, 4.3777155e-05, 7.4357868e-06, 3.1159331e-06,
 9.0591660e-03, 7.1166128e-03, 3.5448824e-03, 5.4756950e-04, 8.7765837e-04, 4.0858443e-04, 2.3975688e-04, 1.3084332e-04,
 1.8239776e-04, 1.9414560e-04, 3.8828156e-05, 2.3992069e-05, 2.2641519e-04, 1.5190501e-04, 5.3107823e-05, 2.3693905e-05,
 4.6587169e-01, 4.9650340e-01, 1.6787630e-01, 3.0741090e-02, 9.7959253e-02, 6.1868912e-02, 2.4643386e-02, 1.5943119e-02,
 1.0162759e-02, 1.4675414e-02, 1.9922701e-03, 1.4593567e-03, 1.4438349e-02, 1.3141803e-02, 3.1187457e-03, 1.6494925e-03,
 6.3994118e-03, 6.0553803e-03, 3.0669582e-03, 2.7939690e-04, 7.5168882e-04, 4.2151274e-04, 2.5150002e-04, 8.0945881e-05,
 1.8171208e-04, 2.3297430e-04, 4.7376766e-05, 1.7264842e-05, 1.8554323e-04, 1.4994354e-04, 5.3303075e-05, 1.4025121e-05,
 5.3343837e-05, 4.8715952e-05, 1.0058095e-05, 1.0681661e-06, 1.2287372e-06, 6.6499360e-07, 1.6174208e-07, 6.0686032e-08,
 2.6701839e-07, 3.3040842e-07, 2.7389663e-08, 1.1635711e-08, 3.5664062e-07, 2.7816281e-07, 4.0308974e-08, 1.2364181e-08,
 1.3127219e-05, 6.2662878e-06, 2.6629432e-06, 3.0109371e-07, 2.8626081e-07, 8.0978659e-08, 4.0539925e-08, 1.6194435e-08,
 5.3544444e-08, 3.4631786e-08, 5.9090431e-09, 2.6726410e-09, 1.5015080e-07, 6.1213431e-08, 1.8258134e-08, 5.9626164e-09,
 4.9777803e-02, 3.2236212e-02, 9.2989598e-03, 1.2464267e-03, 2.3559526e-03, 9.0416172e-04, 3.0725381e-04, 1.4550316e-04,
 2.1998406e-04, 1.9302892e-04, 2.2356483e-05, 1.1987240e-05, 7.0603259e-04, 3.9049398e-04, 7.9061063e-05, 3.0608029e-05,
 3.3045494e-06, 1.9000541e-06, 8.2102381e-07, 5.4748419e-08, 8.7369903e-08, 2.9770564e-08, 1.5154357e-08, 3.5702325e-09,
 1.9009306e-08, 1.4809589e-08, 2.5693511e-09, 6.8536672e-10, 4.3848505e-08, 2.1532272e-08, 6.5303692e-09, 1.2577498e-09,
 1.5685419e-01, 1.8875805e-01, 1.2933695e-01, 1.2948618e-02, 1.7370316e-02, 1.2387632e-02, 9.9992252e-03, 3.5367977e-03,
 1.0288981e-02, 1.6776638e-02, 4.6154380e-03, 1.8484059e-03, 3.4983161e-03, 3.5954243e-03, 1.7291203e-03, 4.9999637e-04,
 6.8765980e-01, 4.3254759e-01, 6.1003942e-01, 6.5024343e-02, 7.2094023e-02, 2.6873914e-02, 4.4649407e-02, 1.6814211e-02,
 3.6756556e-02, 3.1326950e-02, 1.7739143e-02, 7.5636956e-03, 2.6238877e-02, 1.4095715e-02, 1.3953045e-02, 4.2956362e-03,
 1.1974895e+01, 1.0218864e+01, 9.7828521e+00, 1.2361630e+00, 2.7248292e+00, 1.3779757e+00, 1.5540503e+00, 6.9377426e-01,
 6.9350012e-01, 8.0186399e-01, 3.0821524e-01, 1.5579300e-01, 5.6660079e-01, 4.1294286e-01, 2.7746640e-01, 1.0126544e-01,
 4.8135918e-01, 3.6470836e-01, 5.2300753e-01, 3.2877722e-02, 6.1186517e-02, 2.7472835e-02, 4.6411580e-02, 1.0307733e-02,
 3.6286302e-02, 3.7251350e-02, 2.1448406e-02, 5.3935248e-03, 2.1307301e-02, 1.3787531e-02, 1.3877350e-02, 2.5196549e-03,
 3.6278791e-05, 5.7713595e-05, 1.4358518e-05, 1.5434617e-06, 1.4539489e-06, 1.3707103e-06, 4.0173339e-07, 1.5256933e-07,
 4.9034648e-07, 1.0569425e-06, 1.0557810e-07, 4.5398710e-08, 1.8534742e-07, 2.5182198e-07, 4.3972678e-08, 1.3652419e-08,
 9.3348148e-04, 7.7621451e-04, 3.9748458e-04, 4.5490786e-05, 3.5417357e-05, 1.7452736e-05, 1.0528406e-05, 4.2570506e-06,
 1.0281126e-05, 1.1583497e-05, 2.3815990e-06, 1.0903238e-06, 8.1592117e-06, 5.7943620e-06, 2.0825813e-06, 6.8840778e-07,
 1.1844361e-01, 1.3361599e-01, 4.6444625e-02, 6.3013158e-03, 9.7535757e-03, 6.5205136e-03, 2.6700520e-03, 1.2798476e-03,
 1.4133844e-03, 2.1603801e-03, 3.0150744e-04, 1.6363527e-04, 1.2837723e-03, 1.2368474e-03, 3.0175269e-04, 1.1824622e-04,
 2.2924146e-04, 2.2960719e-04, 1.1955342e-04, 8.0694053e-06, 1.0545438e-05, 6.2593285e-06, 3.8394168e-06, 9.1556142e-07,
 3.5607423e-06, 4.8323201e-06, 1.0102366e-06, 2.7276323e-07, 2.3244667e-06, 1.9883689e-06, 7.2666036e-07, 1.4166133e-07,
 2.8358514e-03, 4.3192610e-03, 1.6292659e-03, 1.8890780e-04, 3.5365677e-04, 3.1921181e-04, 1.4184777e-04, 5.8106295e-05,
 1.1665245e-04, 2.4073693e-04, 3.6459960e-05, 1.6910536e-05, 4.9170623e-05, 6.3960684e-05, 1.6933777e-05, 5.6709017e-06,
 1.3553881e-02, 1.0790466e-02, 8.3777939e-03, 1.0341996e-03, 1.6002070e-03, 7.5495997e-04, 6.9051675e-04, 3.0115618e-04,
 4.5431668e-04, 4.9007021e-04, 1.5277013e-04, 7.5439108e-05, 4.0206324e-04, 2.7337112e-04, 1.4897040e-04, 5.3114751e-05,
 3.7627141e-01, 4.0639531e-01, 2.1417901e-01, 3.1343247e-02, 9.6417457e-02, 6.1712649e-02, 3.8314512e-02, 1.9809482e-02,
 1.3665008e-02, 1.9997725e-02, 4.2315488e-03, 2.4771360e-03, 1.3840950e-02, 1.2767178e-02, 4.7225982e-03, 1.9961290e-03,
 1.2277436e-02, 1.1773359e-02, 9.2945412e-03, 6.7667296e-04, 1.7574414e-03, 9.9872236e-04, 9.2882356e-04, 2.3890590e-04,
 5.8038349e-04, 7.5410304e-04, 2.3902830e-04, 6.9611880e-05, 4.2249911e-04, 3.4601925e-04, 1.9172803e-04, 4.0315962e-05,
 1.2411132e-04, 1.1486555e-04, 3.6965400e-05, 3.1372952e-06, 3.4838655e-06, 1.9107817e-06, 7.2439901e-07, 2.1721050e-07,
 1.0342659e-06, 1.2969805e-06, 1.6758297e-07, 5.6894911e-08, 9.8485307e-07, 7.7845113e-07, 1.7583075e-07, 4.3101811e-08,
 3.7619625e-05, 1.8198837e-05, 1.2054695e-05, 1.0892646e-06, 9.9972139e-07, 2.8660192e-07, 2.2364164e-07, 7.1395792e-08,
 2.5545822e-07, 1.6744488e-07, 4.4532335e-08, 1.6096661e-08, 5.1072015e-07, 2.1100542e-07, 9.8098928e-08, 2.5602462e-08,
 7.7008212e-02, 5.0540217e-02, 2.2724177e-02, 2.4342080e-03, 4.4416373e-03, 1.7274843e-03, 9.1501122e-04, 3.4628895e-04,
 5.6657339e-04, 5.0382408e-04, 9.0953906e-05, 3.8973903e-05, 1.2964014e-03, 7.2664218e-04, 2.2931374e-04, 7.0947972e-05,
 1.2143559e-05, 7.0760552e-06, 4.7658697e-06, 2.5397753e-07, 3.9126507e-07, 1.3511001e-07, 1.0720112e-07, 2.0183443e-08,
 1.1629568e-07, 9.1818875e-08, 2.4829818e-08, 5.2931012e-09, 1.9125028e-07, 9.5176282e-08, 4.4992235e-08, 6.9251827e-09,
 5.3603145e+01, 6.8598140e+01, 5.7193660e+01, 1.7005023e+01, 4.5679610e+01, 3.4643010e+01, 3.4026089e+01, 3.5742443e+01,
 4.1533249e+01, 7.2017974e+01, 2.4108343e+01, 2.8673458e+01, 2.5532425e+01, 2.7905854e+01, 1.6330100e+01, 1.4023580e+01,
 1.0822427e+02, 7.2393137e+01, 1.2423377e+02, 3.9326566e+01, 8.7311341e+01, 3.4611020e+01, 6.9970954e+01, 7.8254084e+01,
 6.8330523e+01, 6.1931317e+01, 4.2672059e+01, 5.4034762e+01, 8.8193099e+01, 5.0383549e+01, 6.0686092e+01, 5.5485052e+01,
 1.2987744e+02, 1.1786290e+02, 1.3729614e+02, 5.1522498e+01, 2.2741624e+02, 1.2230277e+02, 1.6783331e+02, 2.2251521e+02,
 8.8845948e+01, 1.0924558e+02, 5.1094719e+01, 7.6700467e+01, 1.3124345e+02, 1.0171913e+02, 8.3165222e+01, 9.0140684e+01,
 2.5034352e+01, 2.0170898e+01, 3.5197017e+01, 6.5709531e+00, 2.4487426e+01, 1.1692378e+01, 2.4035034e+01, 1.5852941e+01,
 2.2291478e+01, 2.4336084e+01, 1.7049910e+01, 1.2732915e+01, 2.3666499e+01, 1.6285615e+01, 1.9945409e+01, 1.0754886e+01,
 2.5106464e-01, 4.2473989e-01, 1.2857989e-01, 4.1047607e-02, 7.7428748e-02, 7.7626682e-02, 2.7683557e-02, 3.1223355e-02,
 4.0083436e-02, 9.1880948e-02, 1.1167764e-02, 1.4261470e-02, 2.7394159e-02, 3.9580103e-02, 8.4097823e-03, 7.7542561e-03,
 2.9750543e+00, 2.6307728e+00, 1.6392304e+00, 5.5714962e-01, 8.6861182e-01, 4.5518210e-01, 3.3412026e-01, 4.0121551e-01,
 3.8704281e-01, 4.6373522e-01, 1.1601596e-01, 1.5773679e-01, 5.5536155e-01, 4.1941660e-01, 1.8342577e-01, 1.8006632e-01,
 2.6014280e+01, 3.1208355e+01, 1.3199778e+01, 5.3185172e+00, 1.6484824e+01, 1.1719646e+01, 5.8394389e+00, 8.3126206e+00,
 3.6668199e+00, 5.9603473e+00, 1.0121806e+00, 1.6314185e+00, 6.0218028e+00, 6.1697430e+00, 1.8315584e+00, 2.1315001e+00,
 2.4143414e-01, 2.5715981e-01, 1.6292890e-01, 3.2659234e-02, 8.5465381e-02, 5.3946808e-02, 4.0264446e-02, 2.8514946e-02,
 4.4297070e-02, 6.3929654e-02, 1.6262541e-02, 1.3040056e-02, 5.2283793e-02, 4.7561219e-02, 2.1149787e-02, 1.2244868e-02,
 2.1439941e+01, 3.4726567e+01, 1.5939069e+01, 5.4884437e+00, 2.0575120e+01, 1.9749299e+01, 1.0678587e+01, 1.2991014e+01,
 1.0417490e+01, 2.2862533e+01, 4.2132392e+00, 5.8034442e+00, 7.9393396e+00, 1.0982575e+01, 3.5380430e+00, 3.5187624e+00,
 4.7191117e+01, 3.9952996e+01, 3.7744795e+01, 1.3837591e+01, 4.2873926e+01, 2.1510634e+01, 2.3939884e+01, 3.1007593e+01,
 1.8684623e+01, 2.1433650e+01, 8.1300846e+00, 1.1922890e+01, 2.9897121e+01, 2.1617223e+01, 1.4333949e+01, 1.5177824e+01,
 9.0283603e+01, 1.0369762e+02, 6.6499051e+01, 2.8900865e+01, 1.7802605e+02, 1.2117543e+02, 9.1542361e+01, 1.4055958e+02,
 3.8729945e+01, 6.0273942e+01, 1.5519116e+01, 2.6980241e+01, 7.0927112e+01, 6.9574990e+01, 3.1315380e+01, 3.9309171e+01,
 1.4126038e+01, 1.4405401e+01, 1.3837949e+01, 2.9919273e+00, 1.5560163e+01, 9.4035146e+00, 1.0641363e+01, 8.1286681e+00,
 7.8878163e+00, 1.0898956e+01, 4.2036047e+00, 3.6356705e+00, 1.0381913e+01, 9.0419853e+00, 6.0963212e+00, 3.8070404e+00,
 1.2014940e+00, 1.1825305e+00, 4.6305934e-01, 1.1671460e-01, 2.5953280e-01, 1.5137501e-01, 6.9829562e-02, 6.2182863e-02,
 1.1826915e-01, 1.5771937e-01, 2.4797056e-02, 2.5001849e-02, 2.0361982e-01, 1.7115605e-01, 4.7040774e-02, 3.4245493e-02,
 1.6771863e-01, 8.6282517e-02, 6.9543078e-02, 1.8662054e-02, 3.4297777e-02, 1.0456313e-02, 9.9282036e-03, 9.4128036e-03,
 1.3452896e-02, 9.3773486e-03, 3.0346047e-03, 3.2575491e-03, 4.8628202e-02, 2.1365402e-02, 1.2086491e-02, 9.3679864e-03,
 2.3660012e+01, 1.6513048e+01, 9.0343507e+00, 2.8740538e+00, 1.0501258e+01, 4.3433486e+00, 2.7993388e+00, 3.1462714e+00,
 2.0561891e+00, 1.9444555e+00, 4.2712884e-01, 5.4355069e-01, 8.5065935e+00, 5.0704837e+00, 1.9470504e+00, 1.7890213e+00,
 1.7890774e-02, 1.1086299e-02, 9.0856505e-03, 1.4379293e-03, 4.4358251e-03, 1.6289326e-03, 1.5726547e-03, 8.7934209e-04,
 2.0238386e-03, 1.6992465e-03, 5.5913490e-04, 3.5398234e-04, 6.0176027e-03, 3.1846557e-03, 1.8318500e-03, 8.3735957e-04,
 1.6157861e+01, 2.1386739e+01, 1.1163492e+01, 2.1699641e+00, 1.1834727e+01, 9.2830400e+00, 5.7082963e+00, 3.9201422e+00,
 6.0712188e+00, 1.0888291e+01, 2.2819493e+00, 1.7743600e+00, 4.2101951e+00, 4.7593162e+00, 1.7436440e+00, 9.7892811e-01,
 4.6307291e+01, 3.2037658e+01, 3.4420970e+01, 7.1234839e+00, 3.2109815e+01, 1.3164993e+01, 1.6662633e+01, 1.2183050e+01,
 1.4178356e+01, 1.3291087e+01, 5.7334203e+00, 4.7464222e+00, 2.0643154e+01, 1.2197456e+01, 9.1979152e+00, 5.4979327e+00,
 1.0904103e+02, 1.0234632e+02, 7.4640287e+01, 1.8311965e+01, 1.6410441e+02, 9.1279604e+01, 7.8421591e+01, 6.7973572e+01,
 3.6172664e+01, 4.6002957e+01, 1.3470311e+01, 1.3219732e+01, 6.0276885e+01, 4.8318620e+01, 2.4732814e+01, 1.7525716e+01,
 6.0890509e+00, 5.0743139e+00, 5.5434217e+00, 6.7658625e-01, 5.1191618e+00, 2.5281203e+00, 3.2535620e+00, 1.4029665e+00,
 2.6292914e+00, 2.9688573e+00, 1.3022092e+00, 6.3578413e-01, 3.1489382e+00, 2.2411616e+00, 1.7184293e+00, 6.0578363e-01,
 1.5726060e-02, 2.7516702e-02, 5.2151427e-03, 1.0884387e-03, 4.1684923e-03, 4.3224176e-03, 9.6506717e-04, 7.1160359e-04,
 1.2175475e-03, 2.8865914e-03, 2.1965743e-04, 1.8338638e-04, 9.3866166e-04, 1.4027071e-03, 1.8659275e-04, 1.1247943e-04,
 2.6452127e-01, 2.4192889e-01, 9.4376625e-02, 2.0971001e-02, 6.6379510e-02, 3.5977601e-02, 1.6533689e-02, 1.2979783e-02,
 1.6688266e-02, 2.0680515e-02, 3.2391340e-03, 2.8791679e-03, 2.7012098e-02, 2.1099239e-02, 5.7769902e-03, 3.7076334e-03,
 4.5384649e+00, 5.6312769e+00, 1.4911538e+00, 3.9279817e-01, 2.4718617e+00, 1.8175788e+00, 5.6698225e-01, 5.2766643e-01,
 3.1022261e-01, 5.2154802e-01, 5.5449867e-02, 5.8429325e-02, 5.7469909e-01, 6.0900384e-01, 1.1318619e-01, 8.6115393e-02,
 1.2202618e-02, 1.3442995e-02, 5.3322565e-03, 6.9878223e-04, 3.7126753e-03, 2.4238245e-03, 1.1326012e-03, 5.2438538e-04,
 1.0857145e-03, 1.6206226e-03, 2.5809998e-04, 1.3530133e-04, 1.4455664e-03, 1.3600755e-03, 3.7864807e-04, 1.4332003e-04,
 3.8809050e+00, 6.5014478e+00, 1.8682327e+00, 4.2057186e-01, 3.2010622e+00, 3.1779148e+00, 1.0757814e+00, 8.5561087e-01,
 9.1444795e-01, 2.0756731e+00, 2.3948076e-01, 2.1565688e-01, 7.8615903e-01, 1.1247831e+00, 2.2685464e-01, 1.4750190e-01,
 1.2125531e+01, 1.0617655e+01, 6.2799533e+00, 1.5051594e+00, 9.4683904e+00, 4.9133201e+00, 3.4234477e+00, 2.8988970e+00,
 2.3281524e+00, 2.7622451e+00, 6.5596513e-01, 6.2891278e-01, 4.2022964e+00, 3.1426505e+00, 1.3046132e+00, 9.0312636e-01,
 4.5517779e+01, 5.4072886e+01, 2.1709316e+01, 6.1682896e+00, 7.7143294e+01, 5.4308500e+01, 2.5685934e+01, 2.5784375e+01,
 9.4690282e+00, 1.5241474e+01, 2.4568818e+00, 2.7924548e+00, 1.9561450e+01, 1.9846364e+01, 5.5924923e+00, 4.5894897e+00,
 2.0632381e+00, 2.1761726e+00, 1.3087583e+00, 1.8499572e-01, 1.9533737e+00, 1.2209576e+00, 8.6502243e-01, 4.3198887e-01,
 5.5869197e-01, 7.9843487e-01, 1.9279523e-01, 1.0901389e-01, 8.2951263e-01, 7.4722015e-01, 3.1540775e-01, 1.2877012e-01,
 4.0314598e-01, 4.1038547e-01, 1.0060885e-01, 1.6578585e-02, 7.4847168e-02, 4.5151907e-02, 1.3040102e-02, 7.5916419e-03,
 1.9244147e-02, 2.6543091e-02, 2.6126797e-03, 1.7221901e-03, 3.7374682e-02, 3.2492914e-02, 5.5910157e-03, 2.6609878e-03,
 7.9882826e-02, 4.2504359e-02, 2.1447897e-02, 3.7628171e-03, 1.4040422e-02, 4.4272302e-03, 2.6317451e-03, 1.6312294e-03,
 3.1072369e-03, 2.2401518e-03, 4.5385735e-04, 3.1851597e-04, 1.2670015e-02, 5.7575630e-03, 2.0391436e-03, 1.0332766e-03,
 2.2111508e+01, 1.5961343e+01, 5.4671271e+00, 1.1370512e+00, 8.4350412e+00, 3.6083566e+00, 1.4559957e+00, 1.0698524e+00,
 9.3186513e-01, 9.1143826e-01, 1.2534522e-01, 1.0428265e-01, 4.3488651e+00, 2.6810716e+00, 6.4454962e-01, 3.8718422e-01,
 4.8438375e-03, 3.1044589e-03, 1.5928510e-03, 1.6480850e-04, 1.0322322e-03, 3.9205319e-04, 2.3697089e-04, 8.6624877e-05,
 2.6571918e-04, 2.3075030e-04, 4.7535983e-05, 1.9674799e-05, 8.9125203e-04, 4.8784152e-04, 1.7568144e-04, 5.2501434e-05,
 7.2839766e+00, 1.0235197e+01, 4.7379234e+00, 1.1321302e+00, 3.2363570e+00, 2.6949773e+00, 1.4696294e+00, 1.2406781e+00,
 1.8125118e+00, 3.4508923e+00, 6.4137790e-01, 6.1306392e-01, 1.0684574e+00, 1.2822313e+00, 4.1659700e-01, 2.8751802e-01,
 9.9928360e+00, 7.3395114e+00, 6.9930368e+00, 1.7790619e+00, 4.2033026e+00, 1.8295330e+00, 2.0535233e+00, 1.8457290e+00,
 2.0262159e+00, 2.0164474e+00, 7.7139385e-01, 7.8502812e-01, 2.5077597e+00, 1.5730612e+00, 1.0519675e+00, 7.7297981e-01,
 7.9232364e+01, 7.8949931e+01, 5.1060985e+01, 1.5399504e+01, 7.2334638e+01, 4.2713651e+01, 3.2543545e+01, 3.4675709e+01,
 1.7406571e+01, 2.3500938e+01, 6.1025807e+00, 7.3623164e+00, 2.4656634e+01, 2.0982843e+01, 9.5248814e+00, 8.2969366e+00,
 2.2094849e+00, 1.9547250e+00, 1.8937486e+00, 2.8413440e-01, 1.1268180e+00, 5.9077133e-01, 6.7424413e-01, 3.5740566e-01,
 6.3183012e-01, 7.5738687e-01, 2.9460859e-01, 1.7681961e-01, 6.4324411e-01, 4.8601734e-01, 3.3048118e-01, 1.4321498e-01,
 1.9118372e-02, 3.5513561e-02, 5.9689830e-03, 1.5314191e-03, 3.0741385e-03, 3.3840592e-03, 6.7004664e-04, 6.0735367e-04,
 9.8025042e-04, 2.4671937e-03, 1.6649465e-04, 1.7087452e-04, 6.4240711e-04, 1.0191430e-03, 1.2022623e-04, 8.9090960e-05,
 1.5393817e-01, 1.4946530e-01, 5.1707485e-02, 1.4124206e-02, 2.3433273e-02, 1.3483358e-02, 5.4950549e-03, 5.3030494e-03,
 6.4315706e-03, 8.4612324e-03, 1.1752703e-03, 1.2841977e-03, 8.8494056e-03, 7.3382045e-03, 1.7818069e-03, 1.4057625e-03,
 8.8934013e+00, 1.1714746e+01, 2.7509618e+00, 8.9081512e-01, 2.9383011e+00, 2.2936770e+00, 6.3451939e-01, 7.2592309e-01,
 4.0258035e-01, 7.1852194e-01, 6.7745857e-02, 8.7754439e-02, 6.3397159e-01, 7.1320779e-01, 1.1755084e-01, 1.0994341e-01,
 1.1940990e-02, 1.3965316e-02, 4.9124956e-03, 7.9138692e-04, 2.2038799e-03, 1.5274578e-03, 6.3296744e-04, 3.6025582e-04,
 7.0359649e-04, 1.1149533e-03, 1.5747030e-04, 1.0147730e-04, 7.9633548e-04, 7.9540372e-04, 1.9637989e-04, 9.1374324e-05,
 1.0080975e+00, 1.7928608e+00, 4.5688175e-01, 1.2643555e-01, 5.0440266e-01, 5.3160888e-01, 1.5959179e-01, 1.5603386e-01,
 1.5730727e-01, 3.7906668e-01, 3.8785005e-02, 4.2935083e-02, 1.1496099e-01, 1.7461271e-01, 3.1231375e-02, 2.4962998e-02,
 1.5077360e+00, 1.4015863e+00, 7.3516379e-01, 2.1660390e-01, 7.1419054e-01, 3.9344118e-01, 2.4311111e-01, 2.5306367e-01,
 1.9171499e-01, 2.4147577e-01, 5.0854403e-02, 5.9936882e-02, 2.9415850e-01, 2.3353807e-01, 8.5976497e-02, 7.3164819e-02,
 1.9058065e+01, 2.4034994e+01, 8.5575019e+00, 2.9889695e+00, 1.9593366e+01, 1.4643528e+01, 6.1419933e+00, 7.5792619e+00,
 2.6255687e+00, 4.4865402e+00, 6.4136498e-01, 8.9611390e-01, 4.6107225e+00, 4.9661041e+00, 1.2410132e+00, 1.2519630e+00,
 4.3139582e-01, 4.8304383e-01, 2.5762562e-01, 4.4765905e-02, 2.4775664e-01, 1.6440204e-01, 1.0329289e-01, 6.3412034e-02,
 7.7360530e-02, 1.1736884e-01, 2.5133095e-02, 1.7469785e-02, 9.7638204e-02, 9.3371009e-02, 3.4952005e-02, 1.7541676e-02,
 2.5306291e-01, 2.7347957e-01, 5.9457329e-02, 1.2044061e-02, 2.8500664e-02, 1.8252508e-02, 4.6748087e-03, 3.3456027e-03,
 7.9999092e-03, 1.1713974e-02, 1.0225285e-03, 8.2856505e-04, 1.3207299e-02, 1.2189669e-02, 1.8600745e-03, 1.0882743e-03,
 2.4003476e-02, 1.3558794e-02, 6.0674830e-03, 1.3085586e-03, 2.5592612e-03, 8.5670813e-04, 4.5162848e-04, 3.4411886e-04,
 6.1832269e-04, 4.7324417e-04, 8.5028309e-05, 7.3355322e-05, 2.1432264e-03, 1.0339430e-03, 3.2474465e-04, 2.0228657e-04,
 2.2372388e+01, 1.7144722e+01, 5.2078265e+00, 1.3314755e+00, 5.1771981e+00, 2.3511684e+00, 8.4133796e-01, 7.5995946e-01,
 6.2440635e-01, 6.4834817e-01, 7.9072452e-02, 8.0869590e-02, 2.4770809e+00, 1.6212112e+00, 3.4563985e-01, 2.5523545e-01,
 2.4474423e-03, 1.6652355e-03, 7.5770694e-04, 9.6374424e-05, 3.1638339e-04, 1.2756990e-04, 6.8380860e-05, 3.0728243e-05,
 8.8913135e-05, 8.1969469e-05, 1.4975060e-05, 7.6192563e-06, 2.5350936e-04, 1.4731219e-04, 4.7045949e-05, 1.7283169e-05,
 7.7586767e+00, 1.1048593e+01, 7.9718629e+00, 1.5223181e+00, 4.2009820e+00, 3.5452045e+00, 3.0133883e+00, 2.0330278e+00,
 3.2141325e+00, 6.2016300e+00, 1.7965929e+00, 1.3723932e+00, 1.3507966e+00, 1.6428225e+00, 8.3195807e-01, 4.5886769e-01,
 1.3110603e+01, 9.7587102e+00, 1.4492809e+01, 2.9465563e+00, 6.7204731e+00, 2.9644281e+00, 5.1863458e+00, 3.7253488e+00,
 4.4257123e+00, 4.4635070e+00, 2.6615000e+00, 2.1645743e+00, 3.9051097e+00, 2.4824742e+00, 2.5876303e+00, 1.5195163e+00,
 5.6117203e+01, 5.6667848e+01, 5.7126176e+01, 1.3768606e+01, 6.2433122e+01, 3.7361711e+01, 4.4369664e+01, 3.7781915e+01,
 2.0524410e+01, 2.8082391e+01, 1.1366410e+01, 1.0958761e+01, 2.0727201e+01, 1.7875694e+01, 1.2647923e+01, 8.8046930e+00,
 3.7172105e+00, 3.3327515e+00, 5.0327007e+00, 6.0344762e-01, 2.3102285e+00, 1.2274731e+00, 2.1835893e+00, 9.2502250e-01,
 1.7696608e+00, 2.1498047e+00, 1.3034301e+00, 6.2518677e-01, 1.2844441e+00, 9.8351925e-01, 1.0424103e+00, 3.6100889e-01,
 1.7644574e-02, 3.3215883e-02, 8.7018845e-03, 1.7842034e-03, 3.4574753e-03, 3.8571374e-03, 1.1904008e-03, 8.6231713e-04,
 1.5061243e-03, 3.8416602e-03, 4.0408875e-04, 3.3142942e-04, 7.0369439e-04, 1.1313590e-03, 2.0802980e-04, 1.2319618e-04,
 1.7499322e-01, 1.7218955e-01, 9.2849852e-02, 2.0268844e-02, 3.2462596e-02, 1.8929531e-02, 1.2024717e-02, 9.2739672e-03,
 1.2171825e-02, 1.6227969e-02, 3.5134133e-03, 3.0680357e-03, 1.1939962e-02, 1.0033902e-02, 3.7975351e-03, 2.3943636e-03,
 5.4576097e+00, 7.2854882e+00, 2.6666851e+00, 6.9009961e-01, 2.1973853e+00, 1.7383354e+00, 7.4956161e-01, 6.8531517e-01,
 4.1129248e-01, 7.4392623e-01, 1.0932855e-01, 1.1317676e-01, 4.6176149e-01, 5.2644807e-01, 1.3524660e-01, 1.0108970e-01,
 1.7406345e-02, 2.0630473e-02, 1.1311540e-02, 1.4562816e-03, 3.9149853e-03, 2.7498119e-03, 1.7761360e-03, 8.0787274e-04,
 1.7074753e-03, 2.7420724e-03, 6.0364576e-04, 3.1087763e-04, 1.3777698e-03, 1.3946321e-03, 5.3669805e-04, 1.9956966e-04,
 5.0276028e-01, 9.0614150e-01, 3.5992706e-01, 7.9600691e-02, 3.0655653e-01, 3.2742906e-01, 1.5321335e-01, 1.1971311e-01,
 1.3060827e-01, 3.1895485e-01, 5.0867259e-02, 4.5001181e-02, 6.8049052e-02, 1.0474637e-01, 2.9202187e-02, 1.8653408e-02,
 9.2618580e-01, 8.7253783e-01, 7.1336134e-01, 1.6796891e-01, 5.3464059e-01, 2.9848289e-01, 2.8747858e-01, 2.3914850e-01,
 1.9606159e-01, 2.5026589e-01, 8.2151935e-02, 7.7378522e-02, 2.1447065e-01, 1.7255814e-01, 9.9019032e-02, 6.7340839e-02,
 6.3199142e+00, 8.0773324e+00, 4.4826192e+00, 1.2512488e+00, 7.9180230e+00, 5.9971508e+00, 3.9207563e+00, 3.8665553e+00,
 1.4495043e+00, 2.5101482e+00, 5.5931165e-01, 6.2452390e-01, 1.8147416e+00, 1.9808567e+00, 7.7156889e-01, 6.2205259e-01,
 3.3981360e-01, 3.8560531e-01, 3.2055803e-01, 4.4514543e-02, 2.3782940e-01, 1.5993326e-01, 1.5662574e-01, 7.6842503e-02,
 1.0144897e-01, 1.5598144e-01, 5.2062751e-02, 2.8920515e-02, 9.1284769e-02, 8.8467127e-02, 5.1618247e-02, 2.0703280e-02,
 2.4174254e-01, 2.6475300e-01, 8.9718659e-02, 1.4524035e-02, 3.3178346e-02, 2.1533465e-02, 8.5963940e-03, 4.9165899e-03,
 1.2722521e-02, 1.8879228e-02, 2.5687190e-03, 1.6634303e-03, 1.4974488e-02, 1.4006239e-02, 3.3313558e-03, 1.5576363e-03,
 2.8243176e-02, 1.6167842e-02, 1.1277180e-02, 1.9436678e-03, 3.6696891e-03, 1.2449126e-03, 1.0229358e-03, 6.2289200e-04,
 1.2112069e-03, 9.3946320e-04, 2.6309901e-04, 1.8139451e-04, 2.9930977e-03, 1.4633258e-03, 7.1638635e-04, 3.5662301e-04,
 1.4210571e+01, 1.1036224e+01, 5.2252599e+00, 1.0676327e+00, 4.0074573e+00, 1.8443755e+00, 1.0287203e+00, 7.4259890e-01,
 6.6028287e-01, 6.9480380e-01, 1.3208094e-01, 1.0795373e-01, 1.8674660e+00, 1.2386356e+00, 4.1161268e-01, 2.4290868e-01,
 3.6926977e-03, 2.5462348e-03, 1.8058646e-03, 1.8356203e-04, 5.8172810e-04, 2.3770929e-04, 1.9860658e-04, 7.1323742e-05,
 2.2333717e-04, 2.0865980e-04, 5.9417729e-05, 2.4160011e-05, 4.5398214e-04, 2.6734676e-04, 1.3308205e-04, 3.9071299e-05,
 7.8902998e-01, 9.1945113e-01, 8.2408003e-01, 2.1478074e-01, 1.3413329e-01, 9.2628099e-02, 9.7801241e-02, 9.0056159e-02,
 1.9382097e-01, 3.0602628e-01, 1.1012610e-01, 1.1481525e-01, 7.3655495e-02, 7.3303005e-02, 4.6112692e-02, 3.4712580e-02,
 2.1073659e+00, 1.2835881e+00, 2.3679548e+00, 6.5707680e-01, 3.3915389e-01, 1.2242041e-01, 2.6604948e-01, 2.6082442e-01,
 4.2182431e-01, 3.4812906e-01, 2.5785696e-01, 2.8622331e-01, 3.3655811e-01, 1.7507623e-01, 2.2669018e-01, 1.8168373e-01,
 2.8876139e+01, 2.3861386e+01, 2.9880098e+01, 9.8291784e+00, 1.0086437e+01, 4.9393025e+00, 7.2863988e+00, 8.4681971e+00,
 6.2624561e+00, 7.0117178e+00, 3.5253440e+00, 4.6389516e+00, 5.7186448e+00, 4.0358130e+00, 3.5471178e+00, 3.3701644e+00,
 1.7904493e-01, 1.3136026e-01, 2.4640527e-01, 4.0324477e-02, 3.4936539e-02, 1.5189835e-02, 3.3566015e-02, 1.9407138e-02,
 5.0543610e-02, 5.0244815e-02, 3.7841454e-02, 2.4772508e-02, 3.3171859e-02, 2.0785155e-02, 2.7365096e-02, 1.2934703e-02,
 8.0895250e-04, 1.2461594e-03, 4.0553541e-04, 1.1348542e-04, 4.9768049e-05, 4.5433116e-05, 1.7417603e-05, 1.7220376e-05,
 4.0945283e-05, 8.5462835e-05, 1.1166665e-05, 1.2500236e-05, 1.7298369e-05, 2.2758173e-05, 5.1981715e-06, 4.2014806e-06,
 1.2680739e-02, 1.0210476e-02, 6.8392425e-03, 2.0376812e-03, 7.3856100e-04, 3.5241857e-04, 2.7808775e-04, 2.9272029e-04,
 5.2301007e-04, 5.7060340e-04, 1.5345715e-04, 1.8289376e-04, 4.6391170e-04, 3.1902014e-04, 1.4998166e-04, 1.2906448e-04,
 1.2660521e+00, 1.3830054e+00, 6.2881740e-01, 2.2209824e-01, 1.6004246e-01, 1.0360446e-01, 5.5493248e-02, 6.9247412e-02,
 5.6575819e-02, 8.3738656e-02, 1.5286837e-02, 2.1598406e-02, 5.7434947e-02, 5.3583364e-02, 1.7099708e-02, 1.7444144e-02,
 3.7797111e-04, 3.6658635e-04, 2.4967581e-04, 4.3871334e-05, 2.6690765e-05, 1.5340864e-05, 1.2308668e-05, 7.6411368e-06,
 2.1985507e-05, 2.8891966e-05, 7.9007482e-06, 5.5533617e-06, 1.6041207e-05, 1.3287283e-05, 6.3517644e-06, 3.2235846e-06,
 5.8922035e-02, 8.6901868e-02, 4.2878086e-02, 1.2942492e-02, 1.1279952e-02, 9.8589325e-03, 5.7305627e-03, 6.1111472e-03,
 9.0765131e-03, 1.8138150e-02, 3.5932722e-03, 4.3386667e-03, 4.2761064e-03, 5.3861857e-03, 1.8652864e-03, 1.6261802e-03,
 1.7156410e-01, 1.3225999e-01, 1.3432026e-01, 4.3165954e-02, 3.1093550e-02, 1.4205074e-02, 1.6994860e-02, 1.9295684e-02,
 2.1535364e-02, 2.2494543e-02, 9.1723589e-03, 1.1791364e-02, 2.1301276e-02, 1.4024561e-02, 9.9967859e-03, 9.2789853e-03,
 3.7477056e+00, 3.9195674e+00, 2.7020293e+00, 1.0293950e+00, 1.4741815e+00, 9.1368200e-01, 7.4200627e-01, 9.9871726e-01,
 5.0968843e-01, 7.2227198e-01, 1.9991398e-01, 3.0466229e-01, 5.7700376e-01, 5.1538629e-01, 2.4936909e-01, 2.7439435e-01,
 1.8862409e-02, 1.7515210e-02, 1.8087001e-02, 3.4280117e-03, 4.1447805e-03, 2.2808195e-03, 2.7746182e-03, 1.8578978e-03,
 3.3391443e-03, 4.2012288e-03, 1.7418803e-03, 1.3206192e-03, 2.7168386e-03, 2.1545852e-03, 1.5616109e-03, 8.5484834e-04,
 3.7795657e-03, 3.3872397e-03, 1.4258552e-03, 3.1503618e-04, 1.6286342e-04, 8.6496540e-05, 4.2893250e-05, 3.3482432e-05,
 1.1794880e-04, 1.4322555e-04, 2.4206981e-05, 2.1394835e-05, 1.2553086e-04, 9.6080638e-05, 2.8387244e-05, 1.8115443e-05,
 6.9793337e-04, 3.2694031e-04, 2.8327281e-04, 6.6635671e-05, 2.8471442e-05, 7.9037906e-06, 8.0673804e-06, 6.7046694e-06,
 1.7748023e-05, 1.1264901e-05, 3.9188139e-06, 3.6875681e-06, 3.9658005e-05, 1.5865976e-05, 9.6485313e-06, 6.5554667e-06,
 1.1241847e+00, 7.1443544e-01, 4.2018269e-01, 1.1717430e-01, 9.9534829e-02, 3.7486217e-02, 2.5972122e-02, 2.5588494e-02,
 3.0973295e-02, 2.6670769e-02, 6.2979847e-03, 7.0255322e-03, 7.9211547e-02, 4.2992762e-02, 1.7747132e-02, 1.4294303e-02,
 2.7344632e-05, 1.5429178e-05, 1.3593065e-05, 1.8857990e-06, 1.3524731e-06, 4.5224136e-07, 4.6935969e-07, 2.3005233e-07,
 9.8066463e-07, 7.4974618e-07, 2.6520373e-07, 1.4717737e-07, 1.8025055e-06, 8.6861786e-07, 5.3710766e-07, 2.1521868e-07,
 2.0996346e-01, 2.5305675e-01, 1.4199679e-01, 2.4195099e-02, 3.0678168e-02, 2.1911619e-02, 1.4484249e-02, 8.7194221e-03,
 2.5011390e-02, 4.0844608e-02, 9.2020814e-03, 6.2721779e-03, 1.0721915e-02, 1.1036412e-02, 4.3465686e-03, 2.1391237e-03,
 7.9601592e-01, 5.0147153e-01, 5.7918035e-01, 1.0507019e-01, 1.1010854e-01, 4.1107093e-02, 5.5930063e-02, 3.5847091e-02,
 7.7268047e-02, 6.5954972e-02, 3.0584811e-02, 2.2194987e-02, 6.9543808e-02, 3.7416623e-02, 3.0331224e-02, 1.5892646e-02,
 2.1401897e+01, 1.8291440e+01, 1.4340162e+01, 3.0839848e+00, 6.4253042e+00, 3.2543190e+00, 3.0055744e+00, 2.2836433e+00,
 2.2508396e+00, 2.6065312e+00, 8.2046495e-01, 7.0583226e-01, 2.3185857e+00, 1.6923890e+00, 9.3124577e-01, 5.7844616e-01,
 3.8444330e-02, 2.9172473e-02, 3.4259343e-02, 3.6653955e-03, 6.4475187e-03, 2.8993768e-03, 4.0111709e-03, 1.5161981e-03,
 5.2628767e-03, 5.4111144e-03, 2.5514287e-03, 1.0919648e-03, 3.8963392e-03, 2.5251038e-03, 2.0813386e-03, 6.4316929e-04,
 4.4731586e-05, 7.1269527e-05, 1.4520413e-05, 2.6565203e-06, 2.3652900e-06, 2.2332910e-06, 5.3602012e-07, 3.4646406e-07,
 1.0979484e-06, 2.3702516e-06, 1.9389214e-07, 1.4189850e-07, 5.2325516e-07, 7.1200746e-07, 1.0181635e-07, 5.3801258e-08,
 9.9533034e-04, 8.2891030e-04, 3.4760763e-04, 6.7708078e-05, 4.9825451e-05, 2.4590244e-05, 1.2148023e-05, 8.3598719e-06,
 1.9907618e-05, 2.2463763e-05, 3.7822939e-06, 2.9470658e-06, 1.9919332e-05, 1.4167610e-05, 4.1700032e-06, 2.3460012e-06,
 1.9498714e-01, 2.2030122e-01, 6.2710113e-02, 1.4480416e-02, 2.1185155e-02, 1.4184496e-02, 4.7565878e-03, 3.8804483e-03,
 4.2254382e-03, 6.4685337e-03, 7.3929408e-04, 6.8287950e-04, 4.8389075e-03, 4.6691721e-03, 9.3286431e-04, 6.2216070e-04,
 1.6864357e-05, 1.6917126e-05, 7.2135079e-06, 8.2865505e-07, 1.0235636e-06, 6.0847440e-07, 3.0564928e-07, 1.2404907e-07,
 4.7570145e-07, 6.4656751e-07, 1.1069419e-07, 5.0866921e-08, 3.9153011e-07, 3.3543089e-07, 1.0038785e-07, 3.3308023e-08,
 9.4155119e-03, 1.4362636e-02, 4.4367025e-03, 8.7551978e-04, 1.5492311e-03, 1.4004823e-03, 5.0964122e-04, 3.5531458e-04,
 7.0335003e-04, 1.4537334e-03, 1.8030242e-04, 1.4232812e-04, 3.7379318e-04, 4.8697116e-04, 1.0558135e-04, 6.0177409e-05,
 3.8915633e-02, 3.1028790e-02, 1.9728673e-02, 4.1449632e-03, 6.0619200e-03, 2.8643251e-03, 2.1454392e-03, 1.5925083e-03,
 2.3688427e-03, 2.5591753e-03, 6.5331710e-04, 5.4907272e-04, 2.6431383e-03, 1.7998751e-03, 8.0321782e-04, 4.8741237e-04,
 1.6679938e+00, 1.8042891e+00, 7.7871371e-01, 1.9395140e-01, 5.6392613e-01, 3.6149755e-01, 1.8379674e-01, 1.6173194e-01,
 1.1000703e-01, 1.6123343e-01, 2.7939432e-02, 2.7836581e-02, 1.4048312e-01, 1.2978289e-01, 3.9313990e-02, 2.8281513e-02,
 2.4321100e-03, 2.3358246e-03, 1.5101203e-03, 1.8711564e-04, 4.5933566e-04, 2.6143171e-04, 1.9910876e-04, 8.7162975e-05,
 2.0878908e-04, 2.7169897e-04, 7.0526095e-05, 3.4956819e-05, 1.9163143e-04, 1.5718283e-04, 7.1323791e-05, 2.5525458e-05,
 1.1195405e-03, 1.0377259e-03, 2.7348413e-04, 3.9503902e-05, 4.1463298e-05, 2.2776002e-05, 7.0711158e-06, 3.6085996e-06,
 1.6942514e-05, 2.1278622e-05, 2.2515622e-06, 1.3009933e-06, 2.0340665e-05, 1.6102348e-05, 2.9784933e-06, 1.2426387e-06,
 2.9345598e-04, 1.4217933e-04, 7.7124532e-05, 1.1860901e-05, 1.0289183e-05, 2.9542389e-06, 1.8878302e-06, 1.0257240e-06,
 3.6188080e-06, 2.3756474e-06, 5.1740299e-07, 3.1830044e-07, 9.1217163e-06, 3.7744317e-06, 1.4370297e-06, 6.3830931e-07,
 9.2746637e-01, 6.0962460e-01, 2.2446955e-01, 4.0923677e-02, 7.0579408e-02, 2.7492438e-02, 1.1925299e-02, 7.6812048e-03,
 1.2391805e-02, 1.1036255e-02, 1.6315767e-03, 1.1898932e-03, 3.5749158e-02, 2.0068340e-02, 5.1863809e-03, 2.7310030e-03,
 6.5356645e-06, 3.8141623e-06, 2.1037474e-06, 1.9080714e-07, 2.7783590e-07, 9.6087982e-08, 6.2434473e-08, 2.0006369e-08,
 1.1366449e-07, 8.9878782e-08, 1.9904093e-08, 7.2214880e-09, 2.3567369e-07, 1.1746323e-07, 4.5473078e-08, 1.1912307e-08,
 3.3480365e-02, 4.2838153e-02, 2.1317093e-02, 4.4651164e-03, 2.9674876e-03, 2.2500949e-03, 1.3190422e-03, 9.7612785e-04,
 2.6412170e-03, 4.5789680e-03, 9.1486176e-04, 7.6655570e-04, 9.6247357e-04, 1.0517466e-03, 3.6733804e-04, 2.2223448e-04,
 6.0760671e-02, 4.0636283e-02, 4.1621506e-02, 9.2819580e-03, 5.0984156e-03, 2.0206815e-03, 2.4381629e-03, 1.9210001e-03,
 3.9058974e-03, 3.5394473e-03, 1.4555593e-03, 1.2984789e-03, 2.9883375e-03, 1.7068784e-03, 1.2270563e-03, 7.9036283e-04,
 5.5008074e+00, 4.9910155e+00, 3.4700152e+00, 9.1737175e-01, 1.0018001e+00, 5.3865976e-01, 4.4118223e-01, 4.1207397e-01,
 3.8312333e-01, 4.7100325e-01, 1.3147929e-01, 1.3904482e-01, 3.3548061e-01, 2.5996284e-01, 1.2685623e-01, 9.6864935e-02,
 4.9344091e-03, 3.9750519e-03, 4.1398527e-03, 5.4448122e-04, 5.0200599e-04, 2.3965567e-04, 2.9402927e-04, 1.3662538e-04,
 4.4734864e-04, 4.8828865e-04, 2.0417829e-04, 1.0742143e-04, 2.8153353e-04, 1.9369528e-04, 1.4158558e-04, 5.3784564e-05,
 1.9235638e-05, 3.2535927e-05, 5.8786080e-06, 1.3221016e-06, 6.1700721e-07, 6.1846860e-07, 1.3164060e-07, 1.0459794e-07,
 3.1267589e-07, 7.1659512e-07, 5.1984749e-08, 4.6768096e-08, 1.2667071e-07, 1.8298436e-07, 2.3205099e-08, 1.5073499e-08,
 2.0488701e-04, 1.8114294e-04, 6.7365828e-05, 1.6130464e-05, 6.2217362e-06, 3.2597928e-06, 1.4281353e-06, 1.2081460e-06,
 2.7138551e-06, 3.2509965e-06, 4.8542893e-07, 4.6496066e-07, 2.3082999e-06, 1.7429334e-06, 4.5494291e-07, 3.1463337e-07,
 1.3515308e-01, 1.6210777e-01, 4.0922384e-02, 1.1616104e-02, 8.9076978e-03, 6.3316151e-03, 1.8829222e-03, 1.8883156e-03,
 1.9395996e-03, 3.1521942e-03, 3.1949259e-04, 3.6278025e-04, 1.8881562e-03, 1.9341811e-03, 3.4269864e-04, 2.8096493e-04,
 5.8373939e-06, 6.2164466e-06, 2.3507083e-06, 3.3195720e-07, 2.1492018e-07, 1.3563498e-07, 6.0421159e-08, 3.0145000e-08,
 1.0904447e-07, 1.5734386e-07, 2.3888951e-08, 1.3494720e-08, 7.6292957e-08, 6.9388784e-08, 1.8416350e-08, 7.5115143e-09,
 8.6511702e-04, 1.4009809e-03, 3.8379083e-04, 9.3101432e-05, 8.6349683e-05, 8.2868367e-05, 2.6743130e-05, 2.2920113e-05,
 4.2797943e-05, 9.3908042e-05, 1.0328952e-05, 1.0023082e-05, 1.9334505e-05, 2.6740623e-05, 5.1415248e-06, 3.6024179e-06,
 1.7116297e-03, 1.4488305e-03, 8.1693378e-04, 2.1099181e-04, 1.6173699e-04, 8.1131302e-05, 5.3891280e-05, 4.9174542e-05,
 6.8998931e-05, 7.9135783e-05, 1.7915672e-05, 1.8509519e-05, 6.5444955e-05, 4.7311343e-05, 1.8723738e-05, 1.3967278e-05,
 2.4703209e-01, 2.8368222e-01, 1.0857756e-01, 3.3243819e-02, 5.0663458e-02, 3.4478203e-02, 1.5545815e-02, 1.6816183e-02,
 1.0789456e-02, 1.6788079e-02, 2.5798825e-03, 3.1597619e-03, 1.1712606e-02, 1.1487182e-02, 3.0858846e-03, 2.7289228e-03,
 1.7987510e-04, 1.8339805e-04, 1.0514838e-04, 1.6016112e-05, 2.0607781e-05, 1.2451639e-05, 8.4099733e-06, 4.5257682e-06,
 1.0226233e-05, 1.4127411e-05, 3.2520774e-06, 1.9815226e-06, 7.9785628e-06, 6.9475270e-06, 2.7957329e-06, 1.2299599e-06,
 2.4858072e-04, 2.4461149e-04, 5.7169261e-05, 1.0151416e-05, 5.5847639e-06, 3.2567586e-06, 8.9666869e-07, 5.6252132e-07,
 2.4912973e-06, 3.3216821e-06, 3.1169839e-07, 2.2140212e-07, 2.5425117e-06, 2.1367519e-06, 3.5050766e-07, 1.7976377e-07,
 3.1190701e-05, 1.6042991e-05, 7.7175236e-06, 1.4590121e-06, 6.6340181e-07, 2.0221249e-07, 1.1459387e-07, 7.6539479e-08,
 2.5472286e-07, 1.7752152e-07, 3.4287392e-08, 2.5929771e-08, 5.4579464e-07, 2.3975676e-07, 8.0950855e-08, 4.4202096e-08,
 3.3193547e-01, 2.3162463e-01, 7.5633812e-02, 1.6950762e-02, 1.5323115e-02, 6.3364941e-03, 2.4374807e-03, 1.9300007e-03,
 2.9370409e-03, 2.7769243e-03, 3.6407113e-04, 3.2639449e-04, 7.2026363e-03, 4.2924388e-03, 9.8376929e-04, 6.3680602e-04,
 1.1680829e-06, 7.2368609e-07, 3.5398189e-07, 3.9467353e-08, 3.0122159e-08, 1.1059453e-08, 6.3727270e-09, 2.5102970e-09,
 1.3453309e-08, 1.1293494e-08, 2.2179404e-09, 9.8921412e-10, 2.3711856e-08, 1.2546522e-08, 4.3073691e-09, 1.3871059e-09,
 1.1553751e-01, 1.4981505e-01, 1.1620193e-01, 1.9451596e-02, 1.2479502e-02, 9.5896024e-03, 8.7623268e-03, 5.1820845e-03,
 1.5174015e-02, 2.6659740e-02, 8.3024206e-03, 5.5594279e-03, 3.9421685e-03, 4.3656504e-03, 2.3766482e-03, 1.1490726e-03,
 2.5826759e-01, 1.7504632e-01, 2.7945890e-01, 4.9805461e-02, 2.6409382e-02, 1.0607485e-02, 1.9949779e-02, 1.2561457e-02,
 2.7639626e-02, 2.5382718e-02, 1.6270236e-02, 1.1599421e-02, 1.5076152e-02, 8.7268031e-03, 9.7786277e-03, 5.0335844e-03,
 1.2622157e+01, 1.1606135e+01, 1.2577405e+01, 2.6573102e+00, 2.8013261e+00, 1.5264707e+00, 1.9487359e+00, 1.4546119e+00,
 1.4635567e+00, 1.8234183e+00, 7.9337903e-01, 6.7052542e-01, 9.1366748e-01, 7.1750289e-01, 5.4573896e-01, 3.3302502e-01,
 2.6895205e-02, 2.1957051e-02, 3.5643238e-02, 3.7463834e-03, 3.3344457e-03, 1.6132216e-03, 3.0850217e-03, 1.1456077e-03,
 4.0592836e-03, 4.4902602e-03, 2.9266151e-03, 1.2305064e-03, 1.8213069e-03, 1.2698830e-03, 1.4468543e-03, 4.3923851e-04,
 5.7514924e-05, 9.8589032e-05, 2.7765215e-05, 4.9903191e-06, 2.2482220e-06, 2.2838022e-06, 7.5769061e-07, 4.8112952e-07,
 1.5564391e-06, 3.6149560e-06, 4.0875797e-07, 2.9388481e-07, 4.4953495e-07, 6.5810173e-07, 1.3008388e-07, 6.7529138e-08,
 7.5457595e-04, 6.7608539e-04, 3.9190521e-04, 7.4993775e-05, 2.7923877e-05, 1.4826738e-05, 1.0124785e-05, 6.8449911e-06,
 1.6639453e-05, 2.0200429e-05, 4.7014390e-06, 3.5988066e-06, 1.0090073e-05, 7.7210157e-06, 3.1413167e-06, 1.7361871e-06,
 2.6870420e-01, 3.2662058e-01, 1.2851736e-01, 2.9154020e-02, 2.1581865e-02, 1.5546386e-02, 7.2062336e-03, 5.7754794e-03,
 6.4198378e-03, 1.0573445e-02, 1.6704189e-03, 1.5158115e-03, 4.4555333e-03, 4.6254130e-03, 1.2773984e-03, 8.3695766e-04,
 2.7567637e-05, 2.9751875e-05, 1.7536061e-05, 1.9790295e-06, 1.2368958e-06, 7.9107797e-07, 5.4928498e-07, 2.1900844e-07,
 8.5733004e-07, 1.2536774e-06, 2.9668402e-07, 1.3393616e-07, 4.2764037e-07, 3.9416227e-07, 1.6306112e-07, 5.3150987e-08,
 1.3978062e-03, 2.2940108e-03, 9.7953294e-04, 1.8989696e-04, 1.7002301e-04, 1.6535890e-04, 8.3178658e-05, 5.6970957e-05,
 1.1512201e-04, 2.5599411e-04, 4.3887847e-05, 3.4035062e-05, 3.7078155e-05, 5.1969473e-05, 1.5575058e-05, 8.7210575e-06,
 3.4064060e-03, 2.9221029e-03, 2.5681832e-03, 5.3008061e-04, 3.9225751e-04, 1.9940753e-04, 2.0645861e-04, 1.5055376e-04,
 2.2860851e-04, 2.6571426e-04, 9.3763957e-05, 7.7416769e-05, 1.5458813e-04, 1.1325488e-04, 6.9862703e-05, 4.1648715e-05,
 2.6539901e-01, 3.0886554e-01, 1.8426320e-01, 4.5086529e-02, 6.6330907e-02, 4.5746432e-02, 3.2150475e-02, 2.7793192e-02,
 1.9297869e-02, 3.0430027e-02, 7.2889041e-03, 7.1343447e-03, 1.4935264e-02, 1.4844466e-02, 6.2157237e-03, 4.3927886e-03,
 4.5903886e-04, 4.7431269e-04, 4.2387079e-04, 5.1597114e-05, 6.4089231e-05, 3.9243868e-05, 4.1314375e-05, 1.7767889e-05,
 4.3446805e-05, 6.0826991e-05, 2.1825083e-05, 1.0627495e-05, 2.4166677e-05, 2.1326210e-05, 1.3376434e-05, 4.7029747e-06,
 7.6931710e-04, 7.6719629e-04, 2.7948181e-04, 3.9660160e-05, 2.1062907e-05, 1.2447737e-05, 5.3419304e-06, 2.6781942e-06,
 1.2835936e-05, 1.7344088e-05, 2.5368161e-06, 1.4400367e-06, 9.3393056e-06, 7.9542157e-06, 2.0337703e-06, 8.3357268e-07,
 1.1889898e-04, 6.1976912e-05, 4.6471176e-05, 7.0210439e-06, 3.0818025e-06, 9.5198007e-07, 8.4089638e-07, 4.4885199e-07,
 1.6165331e-06, 1.1417193e-06, 3.4371913e-07, 2.0773291e-07, 2.4694237e-06, 1.0993321e-06, 5.7854937e-07, 2.5246381e-07,
 6.8307155e-01, 4.8304620e-01, 2.4585613e-01, 4.4034340e-02, 3.8426831e-02, 1.6103799e-02, 9.6556503e-03, 6.1099107e-03,
 1.0062048e-02, 9.6412149e-03, 1.9702218e-03, 1.4115905e-03, 1.7592094e-02, 1.0624820e-02, 3.7955242e-03, 1.9634630e-03,
 5.7097719e-06, 3.5849803e-06, 2.7332454e-06, 2.4354125e-07, 1.7943461e-07, 6.6764453e-08, 5.9965054e-08, 1.8877096e-08,
 1.0948072e-07, 9.3138346e-08, 2.8510917e-08, 1.0162224e-08, 1.3757004e-07, 7.3768899e-08, 3.9475094e-08, 1.0159160e-08,
};

static const double donor_discore_plus[16] =
{1.8655693e-04, 1.7520129e-04, 5.4180998e-02, 1.4924554e-04, 2.5120773e-04, 2.3591682e-04, 7.2957278e-02, 2.0096618e-04,
 2.7053140e-04, 2.5406427e-04, 7.8569376e-02, 2.1642512e-04, 5.4233196e-02, 5.0932045e-02, 1.5750735e+01, 4.3386557e-02,
};

static const double acc_score1_plus[16384] =
{1.9411410e-01, 1.6740850e-01, 1.4822380e-01, 3.2313220e-01, 2.3005190e-01, 1.4372890e-01, 9.8138810e-02, 2.9011860e-01,
 7.1175750e-02, 1.1152220e-01, 5.1925640e-02, 2.8207510e-01, 2.3221500e-01, 1.9695200e-01, 1.5409910e-01, 4.4538570e-01,
 2.3864070e-01, 2.3578740e-01, 2.4317960e-01, 3.2639790e-01, 3.0268710e-01, 2.1665450e-01, 1.7231800e-01, 3.1363400e-01,
 8.2246470e-02, 1.4763940e-01, 8.0073510e-02, 2.6781170e-01, 2.1745160e-01, 2.1129460e-01, 1.9257240e-01, 3.4267950e-01,
 7.1432080e-02, 7.3437110e-02, 7.6663740e-02, 8.5535110e-02, 1.4968980e-01, 1.1148400e-01, 8.9751800e-02, 1.3579060e-01,
 4.9382540e-02, 9.2236910e-02, 5.0635970e-02, 1.4077770e-01, 2.0045790e-01, 2.0267270e-01, 1.8696870e-01, 2.7656490e-01,
 2.5457880e-01, 2.8488180e-01, 2.0514150e-01, 4.7184510e-01, 2.4065760e-01, 1.9509220e-01, 1.0833910e-01, 3.3791170e-01,
 8.2190560e-02, 1.6709880e-01, 6.3276470e-02, 3.6266750e-01, 2.3733780e-01, 2.6119150e-01, 1.6620610e-01, 5.0683530e-01,
 1.4565640e-01, 1.6916110e-01, 1.5422930e-01, 3.2037560e-01, 2.3369940e-01, 1.9661950e-01, 1.3824490e-01, 3.8941600e-01,
 7.3056740e-02, 1.5414890e-01, 7.3907170e-02, 3.8256000e-01, 1.8687240e-01, 2.1343520e-01, 1.7196160e-01, 4.7358480e-01,
 1.7113170e-01, 2.2769680e-01, 2.4181840e-01, 3.0927140e-01, 2.9385890e-01, 2.8324560e-01, 2.3198080e-01, 4.0232270e-01,
 8.0678660e-02, 1.9502680e-01, 1.0891980e-01, 3.4711820e-01, 1.6723640e-01, 2.1883010e-01, 2.0537080e-01, 3.4822730e-01,
 4.5259550e-02, 6.2658950e-02, 6.7357100e-02, 7.1609050e-02, 1.2840100e-01, 1.2877730e-01, 1.0675690e-01, 1.5390490e-01,
 4.2800220e-02, 1.0765340e-01, 6.0856670e-02, 1.6121780e-01, 1.3621430e-01, 1.8545780e-01, 1.7617510e-01, 2.4831500e-01,
 2.0617940e-01, 3.1069780e-01, 2.3038430e-01, 5.0492750e-01, 2.6386500e-01, 2.8805320e-01, 1.6471900e-01, 4.8954430e-01,
 9.1054330e-02, 2.4928870e-01, 9.7206950e-02, 5.3087690e-01, 2.0614480e-01, 3.0550270e-01, 2.0018380e-01, 5.8167280e-01,
 5.0828260e-02, 5.0982350e-02, 3.9597260e-02, 7.8857090e-02, 6.9706810e-02, 5.0650950e-02, 3.0338150e-02, 8.1928890e-02,
 2.3718670e-02, 4.3222900e-02, 1.7653840e-02, 8.7606270e-02, 4.0615230e-02, 4.0063900e-02, 2.7497780e-02, 7.2601740e-02,
 1.2487200e-01, 1.4349440e-01, 1.2982150e-01, 1.5917690e-01, 1.8328020e-01, 1.5257500e-01, 1.0645130e-01, 1.7699330e-01,
 5.4770620e-02, 1.1434750e-01, 5.4402420e-02, 1.6621570e-01, 7.6003460e-02, 8.5892100e-02, 6.8669490e-02, 1.1162750e-01,
 3.2529650e-02, 3.8895190e-02, 3.5618460e-02, 3.6303020e-02, 7.8882310e-02, 6.8327250e-02, 4.8253570e-02, 6.6691320e-02,
 2.8620000e-02, 6.2172030e-02, 2.9940170e-02, 7.6040030e-02, 6.0976110e-02, 7.1701110e-02, 5.8023550e-02, 7.8405350e-02,
 1.7922830e-01, 2.3326160e-01, 1.4734550e-01, 3.0959660e-01, 1.9605830e-01, 1.8485010e-01, 9.0047070e-02, 2.5656710e-01,
 7.3640440e-02, 1.7412530e-01, 5.7840980e-02, 3.0284140e-01, 1.1160960e-01, 1.4285250e-01, 7.9740840e-02, 2.2213340e-01,
 1.8132720e-01, 1.9111010e-01, 1.8202120e-01, 2.9225800e-01, 3.9816720e-01, 3.0400720e-01, 2.2329470e-01, 4.8617790e-01,
 1.0618420e-01, 2.0332440e-01, 1.0183750e-01, 4.0744840e-01, 3.3941290e-01, 3.5180230e-01, 2.9609830e-01, 6.3031020e-01,
 2.3000750e-01, 2.7772700e-01, 3.0812190e-01, 3.0459640e-01, 5.4053630e-01, 4.7282320e-01, 4.0453820e-01, 5.4229310e-01,
 1.2660080e-01, 2.7772920e-01, 1.6203390e-01, 3.9914320e-01, 3.2793820e-01, 3.8941960e-01, 3.8178720e-01, 5.0037720e-01,
 7.6355880e-02, 9.5932310e-02, 1.0773010e-01, 8.8526570e-02, 2.9646610e-01, 2.6983320e-01, 2.3368130e-01, 2.6039500e-01,
 8.4303260e-02, 1.9243130e-01, 1.1363920e-01, 2.3269390e-01, 3.3527750e-01, 4.1426340e-01, 4.1110040e-01, 4.4787640e-01,
 2.8268440e-01, 3.8658450e-01, 2.9945470e-01, 5.0729350e-01, 4.9512270e-01, 4.9051610e-01, 2.9301930e-01, 6.7312640e-01,
 1.4575500e-01, 3.6213870e-01, 1.4751690e-01, 6.2271620e-01, 4.1236190e-01, 5.5458850e-01, 3.7962660e-01, 8.5262600e-01,
 1.9662760e-01, 2.2409380e-01, 1.3608990e-01, 2.7304100e-01, 3.1194720e-01, 2.5755160e-01, 1.2061930e-01, 3.2816390e-01,
 9.9120480e-02, 2.0523800e-01, 6.5544130e-02, 3.2768470e-01, 3.6475330e-01, 4.0882200e-01, 2.1939640e-01, 5.8358660e-01,
 2.6277690e-01, 3.4310570e-01, 2.4271150e-01, 2.9981270e-01, 4.4617390e-01, 4.2202950e-01, 2.3022980e-01, 3.8565000e-01,
 1.2450980e-01, 2.9536120e-01, 1.0987420e-01, 3.3820170e-01, 3.7130140e-01, 4.7677900e-01, 2.9804280e-01, 4.8810370e-01,
 6.6959440e-02, 9.0970160e-02, 6.5137210e-02, 6.6884110e-02, 1.8783590e-01, 1.8486880e-01, 1.0208220e-01, 1.4213990e-01,
 6.3640820e-02, 1.5708400e-01, 5.9148270e-02, 1.5134090e-01, 2.9138230e-01, 3.8931400e-01, 2.4633680e-01, 3.3534900e-01,
 2.5767160e-01, 3.8104280e-01, 1.8819950e-01, 3.9838580e-01, 3.2607060e-01, 3.4931460e-01, 1.3305090e-01, 3.8192260e-01,
 1.1436940e-01, 3.0727430e-01, 7.9808820e-02, 4.2097540e-01, 3.7250540e-01, 5.4173840e-01, 2.3644680e-01, 6.6357900e-01,
 2.0736560e-01, 3.1825300e-01, 1.9901900e-01, 3.8047540e-01, 4.4538180e-01, 4.9518340e-01, 2.3880550e-01, 6.1908270e-01,
 1.4299180e-01, 3.9870900e-01, 1.3111670e-01, 6.2461220e-01, 4.1254730e-01, 6.2267190e-01, 3.4409660e-01, 8.7214020e-01,
 2.6484540e-01, 4.6567590e-01, 3.3921260e-01, 3.9926550e-01, 6.0879160e-01, 7.7545720e-01, 4.3561450e-01, 6.9528740e-01,
 1.7165820e-01, 5.4835890e-01, 2.1005500e-01, 6.1608880e-01, 4.0134170e-01, 6.9399330e-01, 4.4672750e-01, 6.9711790e-01,
 5.9627740e-02, 1.0909030e-01, 8.0434440e-02, 7.8698420e-02, 2.2645100e-01, 3.0013030e-01, 1.7065620e-01, 2.2642190e-01,
 7.7522520e-02, 2.5767640e-01, 9.9910370e-02, 2.4358750e-01, 2.7828000e-01, 5.0069060e-01, 3.2623050e-01, 4.2317730e-01,
 2.9329800e-01, 5.8407270e-01, 2.9705540e-01, 5.9917400e-01, 5.0247380e-01, 7.2488490e-01, 2.8431240e-01, 7.7764900e-01,
 1.7807720e-01, 6.4428060e-01, 1.7231600e-01, 8.6608690e-01, 4.5473410e-01, 8.9056380e-01, 4.0025310e-01, 1.0703460e+00,
 6.7111820e-02, 8.8956640e-02, 4.7389200e-02, 8.6854940e-02, 1.2320740e-01, 1.1830790e-01, 4.8603910e-02, 1.2079770e-01,
 4.3055420e-02, 1.0368510e-01, 2.9046730e-02, 1.3265780e-01, 8.3158000e-02, 1.0840100e-01, 5.1030910e-02, 1.2400020e-01,
 1.7923120e-01, 2.7217520e-01, 1.6889460e-01, 1.9058500e-01, 3.5215340e-01, 3.8740450e-01, 1.8539080e-01, 2.8368300e-01,
 1.0807870e-01, 2.9818380e-01, 9.7304140e-02, 2.7360540e-01, 1.6916230e-01, 2.5263190e-01, 1.3853340e-01, 2.0725320e-01,
 3.9746980e-02, 6.2803730e-02, 3.9447590e-02, 3.7002200e-02, 1.2902450e-01, 1.4769000e-01, 7.1538940e-02, 9.0995890e-02,
 4.8077080e-02, 1.3801570e-01, 4.5587250e-02, 1.0655430e-01, 1.1553300e-01, 1.7952990e-01, 9.9648550e-02, 1.2392300e-01,
 2.3645970e-01, 4.0668540e-01, 1.7620090e-01, 3.4072710e-01, 3.4626090e-01, 4.3142230e-01, 1.4414790e-01, 3.7798910e-01,
 1.3357050e-01, 4.1736980e-01, 9.5093430e-02, 4.5821530e-01, 2.2833560e-01, 3.8621100e-01, 1.4786770e-01, 3.7909300e-01,
 1.8597750e-01, 2.5902750e-01, 1.6921540e-01, 2.5004830e-01, 5.4667680e-01, 5.5158680e-01, 2.7788440e-01, 5.5682720e-01,
 1.4972730e-01, 3.7887460e-01, 1.3015760e-01, 4.7926300e-01, 5.3981780e-01, 7.3940490e-01, 4.2685010e-01, 8.3624450e-01,
 2.5644510e-01, 4.0919970e-01, 3.1138350e-01, 2.8329390e-01, 8.0676120e-01, 9.3257490e-01, 5.4726820e-01, 6.7517170e-01,
 1.9405850e-01, 5.6257770e-01, 2.2512450e-01, 5.1036980e-01, 5.6697750e-01, 8.8972620e-01, 5.9829550e-01, 7.2165790e-01,
 7.2472110e-02, 1.2032560e-01, 9.2680030e-02, 7.0090980e-02, 3.7667890e-01, 4.5306060e-01, 2.6911670e-01, 2.7598710e-01,
 1.1000610e-01, 3.3182790e-01, 1.3440670e-01, 2.5328950e-01, 4.9346250e-01, 8.0573300e-01, 5.4842630e-01, 5.4988020e-01,
 2.8970510e-01, 5.2355640e-01, 2.7816720e-01, 4.3368410e-01, 6.7925810e-01, 8.8928310e-01, 3.6436680e-01, 7.7033310e-01,
 2.0536260e-01, 6.7427610e-01, 1.8839100e-01, 7.3189400e-01, 6.5532110e-01, 1.1646920e+00, 5.4683060e-01, 1.1303010e+00,
 5.2415190e-02, 5.0902570e-02, 3.5985060e-02, 6.5451810e-02, 6.4794730e-02, 4.5584800e-02, 2.4851850e-02, 6.1295770e-02,
 2.4063660e-02, 4.2457380e-02, 1.5783950e-02, 7.1537800e-02, 7.9495460e-02, 7.5923210e-02, 4.7430330e-02, 1.1437460e-01,
 7.0264900e-02, 7.8176540e-02, 6.4376180e-02, 7.2091220e-02, 9.2961130e-02, 7.4926810e-02, 4.7581950e-02, 7.2255640e-02,
 3.0320790e-02, 6.1289710e-02, 2.6540940e-02, 7.4061740e-02, 8.1172390e-02, 8.8816980e-02, 6.4631450e-02, 9.5956620e-02,
 2.0121290e-02, 2.3293780e-02, 1.9415860e-02, 1.8073740e-02, 4.3981340e-02, 3.6885070e-02, 2.3709560e-02, 2.9928650e-02,
 1.7416680e-02, 3.6631830e-02, 1.6056660e-02, 3.7244910e-02, 7.1587550e-02, 8.1502620e-02, 6.0032610e-02, 7.4088780e-02,
 6.4820850e-02, 8.1680650e-02, 4.6962390e-02, 9.0122480e-02, 6.3915440e-02, 5.8345600e-02, 2.5869940e-02, 6.7321010e-02,
 2.6202570e-02, 5.9987030e-02, 1.8137120e-02, 8.6730480e-02, 7.6614550e-02, 9.4943540e-02, 4.8238690e-02, 1.2273050e-01,
 1.2182940e-01, 1.5932550e-01, 1.1598280e-01, 2.0101260e-01, 2.0388910e-01, 1.9316340e-01, 1.0844000e-01, 2.5485390e-01,
 7.6508980e-02, 1.8178350e-01, 6.9589350e-02, 3.0053340e-01, 1.9816170e-01, 2.5486050e-01, 1.6394950e-01, 3.7671540e-01,
 1.5607980e-01, 2.3384880e-01, 1.9829410e-01, 2.1159100e-01, 2.7955600e-01, 3.0342770e-01, 1.9842030e-01, 2.8710830e-01,
 9.2130720e-02, 2.5078520e-01, 1.1182950e-01, 2.9734750e-01, 1.9337440e-01, 2.8492930e-01, 2.1350640e-01, 3.0204530e-01,
 3.9490730e-02, 6.1564460e-02, 5.2841170e-02, 4.6869890e-02, 1.1686030e-01, 1.3197750e-01, 8.7357150e-02, 1.0507330e-01,
 4.6758480e-02, 1.3243550e-01, 5.9775970e-02, 1.3212000e-01, 1.5068130e-01, 2.3101700e-01, 1.7522070e-01, 2.0605390e-01,
 1.6261490e-01, 2.7594030e-01, 1.6336990e-01, 2.9873440e-01, 2.1707530e-01, 2.6684760e-01, 1.2183620e-01, 3.0210770e-01,
 8.9917660e-02, 2.7721010e-01, 8.6306970e-02, 3.9325970e-01, 2.0612900e-01, 3.4398840e-01, 1.7996980e-01, 4.3630150e-01,
 3.6190330e-02, 4.0876070e-02, 2.5348750e-02, 4.2118140e-02, 5.1769760e-02, 4.2359480e-02, 2.0257890e-02, 4.5643530e-02,
 2.1144970e-02, 4.3390300e-02, 1.4150120e-02, 5.8585900e-02, 3.6663000e-02, 4.0724370e-02, 2.2317260e-02, 4.9161750e-02,
 9.6949580e-02, 1.2545210e-01, 9.0621590e-02, 9.2704770e-02, 1.4842600e-01, 1.3913610e-01, 7.7508590e-02, 1.0752080e-01,
 5.3242450e-02, 1.2516970e-01, 4.7548060e-02, 1.2120590e-01, 7.4811120e-02, 9.5202420e-02, 6.0771600e-02, 8.2422350e-02,
 2.4161780e-02, 3.2531750e-02, 2.3786410e-02, 2.0227090e-02, 6.1114300e-02, 5.9610000e-02, 3.3612190e-02, 3.8759100e-02,
 2.6616350e-02, 6.5108250e-02, 2.5034410e-02, 5.3047200e-02, 5.7419720e-02, 7.6030750e-02, 4.9125820e-02, 5.5384500e-02,
 1.2033340e-01, 1.7635380e-01, 8.8944830e-02, 1.5592540e-01, 1.3730250e-01, 1.4577230e-01, 5.6697900e-02, 1.3478310e-01,
 6.1904960e-02, 1.6482880e-01, 4.3716850e-02, 1.9097010e-01, 9.5002080e-02, 1.3692460e-01, 6.1026210e-02, 1.4183600e-01,
 1.3779990e-01, 1.6354280e-01, 1.2436890e-01, 1.6660700e-01, 3.1562030e-01, 2.7135970e-01, 1.5914090e-01, 2.8909180e-01,
 1.0103580e-01, 2.1785460e-01, 8.7121840e-02, 2.9082320e-01, 3.2701370e-01, 3.8167900e-01, 2.5649430e-01, 4.5554690e-01,
 1.9059930e-01, 2.5915490e-01, 2.2956520e-01, 1.8934130e-01, 4.6721620e-01, 4.6020760e-01, 3.1438130e-01, 3.5161570e-01,
 1.3135460e-01, 3.2448330e-01, 1.5115380e-01, 3.1065530e-01, 3.4452690e-01, 4.6069240e-01, 3.6062570e-01, 3.9433910e-01,
 6.0532760e-02, 8.5639660e-02, 7.6787280e-02, 5.2645690e-02, 2.4515270e-01, 2.5125750e-01, 1.7373590e-01, 1.6152340e-01,
 8.3680030e-02, 2.1508760e-01, 1.0141670e-01, 1.7326210e-01, 3.3698000e-01, 4.6885480e-01, 3.7149400e-01, 3.3767520e-01,
 2.0257230e-01, 3.1194970e-01, 1.9293600e-01, 2.7269580e-01, 3.7008760e-01, 4.1286400e-01, 1.9692100e-01, 3.7742400e-01,
 1.3077690e-01, 3.6588490e-01, 1.1900170e-01, 4.1912040e-01, 3.7463510e-01, 5.6736520e-01, 3.1009210e-01, 5.8107150e-01,
 3.0422310e-01, 3.1161460e-01, 2.5353190e-01, 4.1961290e-01, 5.0370720e-01, 3.7376760e-01, 2.3451620e-01, 5.2633380e-01,
 1.4171750e-01, 2.6372920e-01, 1.1283740e-01, 4.6536060e-01, 5.1546500e-01, 5.1924770e-01, 3.7332630e-01, 8.1917850e-01,
 3.9270640e-01, 4.6083890e-01, 4.3674730e-01, 4.4504520e-01, 6.9588020e-01, 5.9158000e-01, 4.3236530e-01, 5.9744380e-01,
 1.7194800e-01, 3.6659560e-01, 1.8270410e-01, 4.6391950e-01, 5.0682710e-01, 5.8491220e-01, 4.8985880e-01, 6.6178760e-01,
 1.0737330e-01, 1.3110630e-01, 1.2576870e-01, 1.0653220e-01, 3.1434930e-01, 2.7805960e-01, 2.0570410e-01, 2.3627800e-01,
 9.4304560e-02, 2.0920360e-01, 1.0553540e-01, 2.2275460e-01, 4.2677590e-01, 5.1248030e-01, 4.3443530e-01, 4.8787330e-01,
 3.7458120e-01, 4.9784430e-01, 3.2942530e-01, 5.7525000e-01, 4.9469850e-01, 4.7630600e-01, 2.4305560e-01, 5.7554280e-01,
 1.5363920e-01, 3.7098700e-01, 1.2909280e-01, 5.6172290e-01, 4.9461170e-01, 6.4648990e-01, 3.7802820e-01, 8.7518070e-01,
 2.9266810e-01, 4.0369340e-01, 3.3821460e-01, 5.3338230e-01, 6.5602540e-01, 6.5553320e-01, 4.2353730e-01, 9.0575390e-01,
 1.8649300e-01, 4.6735590e-01, 2.0590570e-01, 8.0916130e-01, 5.3182020e-01, 7.2142430e-01, 5.3410990e-01, 1.1167370e+00,
 3.6104760e-01, 5.7055320e-01, 5.5680500e-01, 5.4063870e-01, 8.6614410e-01, 9.9156150e-01, 7.4624750e-01, 9.8256030e-01,
 2.1624650e-01, 6.2085450e-01, 3.1862270e-01, 7.7090560e-01, 4.9973370e-01, 7.7664050e-01, 6.6977060e-01, 8.6219190e-01,
 8.7221560e-02, 1.4341740e-01, 1.4166960e-01, 1.1434440e-01, 3.4570000e-01, 4.1178940e-01, 3.1369400e-01, 3.4333390e-01,
 1.0478910e-01, 3.1304230e-01, 1.6261390e-01, 3.2705170e-01, 3.7180050e-01, 6.0122590e-01, 5.2482140e-01, 5.6159550e-01,
 3.8893740e-01, 6.9610990e-01, 4.7431520e-01, 7.8921780e-01, 6.9539810e-01, 9.0163240e-01, 4.7377810e-01, 1.0689980e+00,
 2.1821840e-01, 7.0957550e-01, 2.5425400e-01, 1.0541880e+00, 5.5078290e-01, 9.6945660e-01, 5.8373630e-01, 1.2877170e+00,
 1.2807010e-01, 1.5256940e-01, 1.0888980e-01, 1.6463280e-01, 2.4537750e-01, 2.1176410e-01, 1.1655430e-01, 2.3896270e-01,
 7.5925740e-02, 1.6433040e-01, 6.1676190e-02, 2.3236320e-01, 1.4494560e-01, 1.6981440e-01, 1.0710100e-01, 2.1468250e-01,
 3.3036620e-01, 4.5089030e-01, 3.7484940e-01, 3.4893460e-01, 6.7742820e-01, 6.6978650e-01, 4.2941640e-01, 5.4204830e-01,
 1.8409190e-01, 4.5647710e-01, 1.9956520e-01, 4.6290560e-01, 2.8479850e-01, 3.8226340e-01, 2.8083280e-01, 3.4658420e-01,
 7.8612140e-02, 1.1163780e-01, 9.3943120e-02, 7.2691950e-02, 2.6632200e-01, 2.7398480e-01, 1.7780190e-01, 1.8656490e-01,
 8.7869080e-02, 2.2670800e-01, 1.0032300e-01, 1.9343820e-01, 2.0871020e-01, 2.9148420e-01, 2.1675440e-01, 2.2236320e-01,
 4.2397240e-01, 6.5535920e-01, 3.8040620e-01, 6.0682080e-01, 6.4793790e-01, 7.2555940e-01, 3.2478610e-01, 7.0255870e-01,
 2.2131140e-01, 6.2151910e-01, 1.8971540e-01, 7.5411220e-01, 3.7394390e-01, 5.6845740e-01, 2.9158500e-01, 6.1666880e-01,
 3.2577410e-01, 4.0779540e-01, 3.5690700e-01, 4.3506420e-01, 9.9939270e-01, 9.0627460e-01, 6.1168630e-01, 1.0111120e+00,
 2.4236490e-01, 5.5119410e-01, 2.5368640e-01, 7.7057680e-01, 8.6368540e-01, 1.0632390e+00, 8.2232390e-01, 1.3289690e+00,
 4.3389410e-01, 6.2225010e-01, 6.3437190e-01, 4.7610190e-01, 1.4245700e+00, 1.4800040e+00, 1.1635850e+00, 1.1842040e+00,
 3.0341320e-01, 7.9054180e-01, 4.2382220e-01, 7.9261120e-01, 8.7620850e-01, 1.2357720e+00, 1.1133110e+00, 1.1077620e+00,
 1.3157210e-01, 1.9633210e-01, 2.0259940e-01, 1.2639450e-01, 7.1369650e-01, 7.7150550e-01, 6.1396270e-01, 5.1940310e-01,
 1.8455340e-01, 5.0033250e-01, 2.7150970e-01, 4.2208120e-01, 8.1827520e-01, 1.2008170e+00, 1.0950210e+00, 9.0570470e-01,
 4.7680850e-01, 7.7444710e-01, 5.5125550e-01, 7.0898120e-01, 1.1667350e+00, 1.3728330e+00, 7.5359020e-01, 1.3142840e+00,
 3.1233590e-01, 9.2167680e-01, 3.4500060e-01, 1.1056610e+00, 9.8513200e-01, 1.5735910e+00, 9.8981080e-01, 1.6877490e+00,
 1.8419540e-01, 1.5885440e-01, 1.4065000e-01, 3.0662120e-01, 2.7922730e-01, 1.7445210e-01, 1.1911670e-01, 3.5213360e-01,
 8.0047510e-02, 1.2542300e-01, 5.8397960e-02, 3.1723460e-01, 2.8038230e-01, 2.3780490e-01, 1.8606310e-01, 5.3777000e-01,
 2.5717860e-01, 2.5410360e-01, 2.6207010e-01, 3.5175290e-01, 4.1724810e-01, 2.9865390e-01, 2.3753690e-01, 4.3233810e-01,
 1.0505130e-01, 1.8857600e-01, 1.0227580e-01, 3.4206900e-01, 2.9818880e-01, 2.8974580e-01, 2.6407230e-01, 4.6991240e-01,
 8.3199750e-02, 8.5535090e-02, 8.9293280e-02, 9.9626100e-02, 2.2301350e-01, 1.6609300e-01, 1.3371560e-01, 2.0230600e-01,
 6.8170430e-02, 1.2732900e-01, 6.9900740e-02, 1.9433750e-01, 2.9709160e-01, 3.0037410e-01, 2.7709960e-01, 4.0988700e-01,
 3.1571420e-01, 3.5329420e-01, 2.5440490e-01, 5.8515560e-01, 3.8175230e-01, 3.0947240e-01, 1.7185690e-01, 5.3602530e-01,
 1.2080580e-01, 2.4560610e-01, 9.3005370e-02, 5.3305790e-01, 3.7452190e-01, 4.1216340e-01, 2.6227530e-01, 7.9979230e-01,
 1.3407440e-01, 1.5571010e-01, 1.4196560e-01, 2.9490060e-01, 2.7515910e-01, 2.3150090e-01, 1.6277030e-01, 4.5850080e-01,
 7.9702210e-02, 1.6817070e-01, 8.0629990e-02, 4.1735880e-01, 2.1887690e-01, 2.4998880e-01, 2.0141230e-01, 5.5469260e-01,
 1.7890190e-01, 2.3803540e-01, 2.5279820e-01, 3.2331380e-01, 3.9294660e-01, 3.7875460e-01, 3.1020350e-01, 5.3798390e-01,
 9.9962520e-02, 2.4164220e-01, 1.3495380e-01, 4.3008660e-01, 2.2246100e-01, 2.9109180e-01, 2.7318800e-01, 4.6321840e-01,
 5.1136770e-02, 7.0795580e-02, 7.6103810e-02, 8.0907900e-02, 1.8556740e-01, 1.8611110e-01, 1.5428680e-01, 2.2242600e-01,
 5.7314290e-02, 1.4416000e-01, 8.1493890e-02, 2.1588870e-01, 1.9583220e-01, 2.6662850e-01, 2.5328300e-01, 3.5699680e-01,
 2.4803410e-01, 3.7377000e-01, 2.7715270e-01, 6.0742860e-01, 4.0603000e-01, 4.4325020e-01, 2.5346610e-01, 7.5330060e-01,
 1.2982570e-01, 3.5543700e-01, 1.3859810e-01, 7.5692680e-01, 3.1555630e-01, 4.6764860e-01, 3.0643150e-01, 8.9039640e-01,
 7.2420050e-02, 7.2639600e-02, 5.6418130e-02, 1.1235550e-01, 1.2703950e-01, 9.2310550e-02, 5.5290800e-02, 1.4931410e-01,
 4.0053250e-02, 7.2989670e-02, 2.9811690e-02, 1.4793900e-01, 7.3634430e-02, 7.2634880e-02, 4.9852810e-02, 1.3162520e-01,
 2.0206310e-01, 2.3219730e-01, 2.1007220e-01, 2.5757400e-01, 3.7935650e-01, 3.1580240e-01, 2.2033490e-01, 3.6634390e-01,
 1.0504210e-01, 2.1930210e-01, 1.0433600e-01, 3.1877770e-01, 1.5649260e-01, 1.7685350e-01, 1.4139180e-01, 2.2984310e-01,
 5.6890520e-02, 6.8023090e-02, 6.2292480e-02, 6.3489690e-02, 1.7646160e-01, 1.5284970e-01, 1.0794440e-01, 1.4919000e-01,
 5.9323110e-02, 1.2886930e-01, 6.2059550e-02, 1.5761470e-01, 1.3569340e-01, 1.5956030e-01, 1.2912290e-01, 1.7447960e-01,
 3.3374150e-01, 4.3435700e-01, 2.7437250e-01, 5.7650060e-01, 4.6698070e-01, 4.4028440e-01, 2.1447830e-01, 6.1110350e-01,
 1.6252260e-01, 3.8429030e-01, 1.2765360e-01, 6.6836360e-01, 2.6445010e-01, 3.3847770e-01, 1.8893950e-01, 5.2632730e-01,
 1.6226150e-01, 1.7101570e-01, 1.6288250e-01, 2.6152840e-01, 4.5575140e-01, 3.4797370e-01, 2.5558830e-01, 5.5649050e-01,
 1.1261760e-01, 2.1564320e-01, 1.0800750e-01, 4.3213460e-01, 3.8647300e-01, 4.0058020e-01, 3.3715290e-01, 7.1770380e-01,
 2.3375600e-01, 2.8225320e-01, 3.1314350e-01, 3.0956060e-01, 7.0267710e-01, 6.1465260e-01, 5.2588460e-01, 7.0496090e-01,
 1.5249340e-01, 3.3453090e-01, 1.9517350e-01, 4.8077680e-01, 4.2408340e-01, 5.0359000e-01, 4.9371990e-01, 6.4707830e-01,
 8.3869060e-02, 1.0537180e-01, 1.1833040e-01, 9.7237310e-02, 4.1652830e-01, 3.7910960e-01, 3.2831690e-01, 3.6584910e-01,
 1.0974820e-01, 2.5051230e-01, 1.4793850e-01, 3.0292710e-01, 4.6859980e-01, 5.7899420e-01, 5.7457350e-01, 6.2597350e-01,
 3.3060120e-01, 4.5211290e-01, 3.5021410e-01, 5.9328280e-01, 7.4067120e-01, 7.3378000e-01, 4.3833770e-01, 1.0069530e+00,
 2.0203180e-01, 5.0196260e-01, 2.0447400e-01, 8.6315050e-01, 6.1364820e-01, 8.2529980e-01, 5.6493380e-01, 1.2688180e+00,
 1.6379730e-01, 1.8667750e-01, 1.1336740e-01, 2.2745220e-01, 3.3239420e-01, 2.7443310e-01, 1.2852540e-01, 3.4967380e-01,
 9.7863210e-02, 2.0263470e-01, 6.4712750e-02, 3.2352820e-01, 3.8663390e-01, 4.3334610e-01, 2.3255740e-01, 6.1859430e-01,
 2.4860950e-01, 3.2460750e-01, 2.2962590e-01, 2.8364850e-01, 5.3993920e-01, 5.1072070e-01, 2.7861350e-01, 4.6669600e-01,
 1.3961370e-01, 3.3119050e-01, 1.2320270e-01, 3.7922790e-01, 4.4698770e-01, 5.7396590e-01, 3.5879600e-01, 5.8759910e-01,
 6.8466930e-02, 9.3018210e-02, 6.6603670e-02, 6.8389900e-02, 2.4567320e-01, 2.4179240e-01, 1.3351470e-01, 1.8590680e-01,
 7.7125620e-02, 1.9036840e-01, 7.1681150e-02, 1.8340840e-01, 3.7911470e-01, 5.0653270e-01, 3.2050640e-01, 4.3631930e-01,
 2.8052960e-01, 4.1484510e-01, 2.0489460e-01, 4.3372660e-01, 4.5408170e-01, 4.8645090e-01, 1.8528490e-01, 5.3186040e-01,
 1.4757610e-01, 3.9649010e-01, 1.0298100e-01, 5.4320380e-01, 5.1603990e-01, 7.5048190e-01, 3.2755480e-01, 9.1927030e-01,
 1.6756880e-01, 2.5717510e-01, 1.6082400e-01, 3.0745600e-01, 4.6036150e-01, 5.1183820e-01, 2.4683740e-01, 6.3990460e-01,
 1.3694980e-01, 3.8186190e-01, 1.2557650e-01, 5.9821980e-01, 4.2419800e-01, 6.4025680e-01, 3.5381420e-01, 8.9677020e-01,
 2.4306210e-01, 4.2737450e-01, 3.1131270e-01, 3.6642630e-01, 7.1466680e-01, 9.1031720e-01, 5.1137240e-01, 8.1620520e-01,
 1.8671680e-01, 5.9646320e-01, 2.2848190e-01, 6.7013460e-01, 4.6868120e-01, 8.1043570e-01, 5.2168210e-01, 8.1408460e-01,
 5.9144130e-02, 1.0820550e-01, 7.9782080e-02, 7.8060130e-02, 2.8730800e-01, 3.8078790e-01, 2.1651870e-01, 2.8727100e-01,
 9.1134970e-02, 3.0292260e-01, 1.1745400e-01, 2.8635990e-01, 3.5122360e-01, 6.3193310e-01, 4.1174300e-01, 5.3410180e-01,
 3.0975300e-01, 6.1684120e-01, 3.1372120e-01, 6.3278970e-01, 6.7878150e-01, 9.7923200e-01, 3.8407180e-01, 1.0505100e+00,
 2.2289920e-01, 8.0644620e-01, 2.1568790e-01, 1.0840810e+00, 6.1108610e-01, 1.1967680e+00, 5.3787280e-01, 1.4383640e+00,
 8.3944620e-02, 1.1126850e-01, 5.9275240e-02, 1.0863970e-01, 1.9712450e-01, 1.8928570e-01, 7.7763390e-02, 1.9326920e-01,
 6.3828640e-02, 1.5371070e-01, 4.3061090e-02, 1.9666200e-01, 1.3235380e-01, 1.7253030e-01, 8.1220490e-02, 1.9735790e-01,
 2.5461030e-01, 3.8664370e-01, 2.3992650e-01, 2.7073910e-01, 6.3988850e-01, 7.0394220e-01, 3.3686860e-01, 5.1547270e-01,
 1.8196860e-01, 5.0204230e-01, 1.6382780e-01, 4.6066030e-01, 3.0577660e-01, 4.5665570e-01, 2.5041210e-01, 3.7462950e-01,
 6.1024600e-02, 9.6424220e-02, 6.0564930e-02, 5.6810450e-02, 2.5338620e-01, 2.9004270e-01, 1.4049260e-01, 1.7870330e-01,
 8.7484820e-02, 2.5114410e-01, 8.2954120e-02, 1.9389450e-01, 2.2570700e-01, 3.5073250e-01, 1.9467500e-01, 2.4209790e-01,
 3.8654590e-01, 6.6481750e-01, 2.8803940e-01, 5.5699410e-01, 7.2403150e-01, 9.0210410e-01, 3.0141330e-01, 7.9037520e-01,
 2.5879060e-01, 8.0864670e-01, 1.8424190e-01, 8.8778410e-01, 4.7495880e-01, 8.0335410e-01, 3.0757830e-01, 7.8854800e-01,
 1.4610100e-01, 2.0348790e-01, 1.3293300e-01, 1.9643400e-01, 5.4933020e-01, 5.5426410e-01, 2.7923320e-01, 5.5952990e-01,
 1.3940800e-01, 3.5276230e-01, 1.2118700e-01, 4.4623190e-01, 5.3960800e-01, 7.3911750e-01, 4.2668420e-01, 8.3591950e-01,
 2.2879980e-01, 3.6508710e-01, 2.7781560e-01, 2.5275420e-01, 9.2069600e-01, 1.0642780e+00, 6.2455620e-01, 7.7052280e-01,
 2.0520490e-01, 5.9489130e-01, 2.3805530e-01, 5.3968450e-01, 6.4367310e-01, 1.0100810e+00, 6.7922760e-01, 8.1927740e-01,
 6.9882830e-02, 1.1602660e-01, 8.9368760e-02, 6.7586770e-02, 4.6460180e-01, 5.5881240e-01, 3.3193290e-01, 3.4040700e-01,
 1.2572160e-01, 3.7923320e-01, 1.5360820e-01, 2.8947470e-01, 6.0546940e-01, 9.8861950e-01, 6.7290890e-01, 6.7469280e-01,
 2.9743970e-01, 5.3753440e-01, 2.8559380e-01, 4.4526270e-01, 8.9204690e-01, 1.1678660e+00, 4.7851070e-01, 1.0116530e+00,
 2.4989530e-01, 8.2049210e-01, 2.2924340e-01, 8.9060440e-01, 8.5612140e-01, 1.5215720e+00, 7.1438780e-01, 1.4766430e+00,
 6.6584050e-02, 6.4662530e-02, 4.5712530e-02, 8.3144720e-02, 1.0528410e-01, 7.4070130e-02, 4.0381450e-02, 9.9598690e-02,
 3.6230020e-02, 6.3923430e-02, 2.3764170e-02, 1.0770660e-01, 1.2849720e-01, 1.2272300e-01, 7.6666850e-02, 1.8487620e-01,
 1.0137240e-01, 1.1278670e-01, 9.2876670e-02, 1.0400730e-01, 1.7155090e-01, 1.3827030e-01, 8.7807940e-02, 1.3334090e-01,
 5.1846080e-02, 1.0480040e-01, 4.5382840e-02, 1.2663950e-01, 1.4901440e-01, 1.6304820e-01, 1.1864890e-01, 1.7615490e-01,
 3.1374410e-02, 3.6321180e-02, 3.0274460e-02, 2.8181740e-02, 8.7719950e-02, 7.3566580e-02, 4.7288260e-02, 5.9692130e-02,
 3.2186890e-02, 6.7697470e-02, 2.9673510e-02, 6.8830470e-02, 1.4203510e-01, 1.6170740e-01, 1.1910920e-01, 1.4699780e-01,
 1.0761620e-01, 1.3560700e-01, 7.7967430e-02, 1.4962230e-01, 1.3573100e-01, 1.2390280e-01, 5.4937450e-02, 1.4296300e-01,
 5.1558560e-02, 1.1803590e-01, 3.5688250e-02, 1.7065880e-01, 1.6185000e-01, 2.0057040e-01, 1.0190530e-01, 2.5927090e-01,
 1.5012730e-01, 1.9633270e-01, 1.4292260e-01, 2.4770260e-01, 3.2137440e-01, 3.0446840e-01, 1.7092550e-01, 4.0170640e-01,
 1.1174130e-01, 2.6549460e-01, 1.0163520e-01, 4.3892870e-01, 3.1071730e-01, 3.9962090e-01, 2.5707250e-01, 5.9068930e-01,
 2.1843510e-01, 3.2727350e-01, 2.7751440e-01, 2.9612350e-01, 5.0044300e-01, 5.4317650e-01, 3.5519910e-01, 5.1396260e-01,
 1.5281780e-01, 4.1597920e-01, 1.8549240e-01, 4.9321230e-01, 3.4436030e-01, 5.0740090e-01, 3.8021130e-01, 5.3788100e-01,
 5.9732310e-02, 9.3120260e-02, 7.9925720e-02, 7.0893770e-02, 2.2609520e-01, 2.5534300e-01, 1.6901400e-01, 2.0329020e-01,
 8.3824000e-02, 2.3741730e-01, 1.0716050e-01, 2.3685180e-01, 2.9000920e-01, 4.4462760e-01, 3.3723910e-01, 3.9658230e-01,
 2.6188920e-01, 4.4439840e-01, 2.6310520e-01, 4.8110790e-01, 4.4717540e-01, 5.4970630e-01, 2.5098270e-01, 6.2234210e-01,
 1.7163120e-01, 5.2912740e-01, 1.6473920e-01, 7.5063810e-01, 4.2241060e-01, 7.0491950e-01, 3.6880390e-01, 8.9409250e-01,
 6.9029900e-02, 7.7967550e-02, 4.8350530e-02, 8.0336690e-02, 1.2630800e-01, 1.0334880e-01, 4.9425270e-02, 1.1136120e-01,
 4.7801950e-02, 9.8091480e-02, 3.1988850e-02, 1.3244380e-01, 8.8983850e-02, 9.8841080e-02, 5.4165650e-02, 1.1931920e-01,
 2.1001920e-01, 2.7176350e-01, 1.9631110e-01, 2.0082380e-01, 4.1127590e-01, 3.8553450e-01, 2.1476970e-01, 2.9793110e-01,
 1.3669890e-01, 3.2137070e-01, 1.2207870e-01, 3.1119360e-01, 2.0621380e-01, 2.6242160e-01, 1.6751450e-01, 2.2719380e-01,
 5.6569270e-02, 7.6165630e-02, 5.5690410e-02, 4.7357090e-02, 1.8302250e-01, 1.7851750e-01, 1.0066040e-01, 1.1607410e-01,
 7.3857400e-02, 1.8066810e-01, 6.9467690e-02, 1.4720000e-01, 1.7106100e-01, 2.2650580e-01, 1.4635240e-01, 1.6499780e-01,
 2.9997220e-01, 4.3962220e-01, 2.2172540e-01, 3.8869740e-01, 4.3780760e-01, 4.6481460e-01, 1.8078890e-01, 4.2977420e-01,
 1.8290020e-01, 4.8699180e-01, 1.2916280e-01, 5.6422730e-01, 3.0134660e-01, 4.3432480e-01, 1.9357510e-01, 4.4990370e-01,
 1.6507920e-01, 1.9591830e-01, 1.4898940e-01, 1.9958920e-01, 4.8363590e-01, 4.1581390e-01, 2.4385720e-01, 4.4298550e-01,
 1.4345400e-01, 3.0931730e-01, 1.2369850e-01, 4.1292060e-01, 4.9848020e-01, 5.8180870e-01, 3.9098460e-01, 6.9440860e-01,
 2.5931840e-01, 3.5259120e-01, 3.1233310e-01, 2.5760680e-01, 8.1309250e-01, 8.0089560e-01, 5.4711520e-01, 6.1191400e-01,
 2.1181230e-01, 5.2323680e-01, 2.4373890e-01, 5.0093870e-01, 5.9644940e-01, 7.9755650e-01, 6.2431980e-01, 6.8268490e-01,
 8.9010430e-02, 1.2592890e-01, 1.1291190e-01, 7.7412880e-02, 4.6110230e-01, 4.7258460e-01, 3.2677600e-01, 3.0380570e-01,
 1.4583650e-01, 3.7485180e-01, 1.7674780e-01, 3.0195890e-01, 6.3051150e-01, 8.7725770e-01, 6.9508940e-01, 6.3181220e-01,
 3.1715650e-01, 4.8840280e-01, 3.0206960e-01, 4.2694520e-01, 7.4115370e-01, 8.2681950e-01, 3.9436270e-01, 7.5584580e-01,
 2.4267130e-01, 6.7894090e-01, 2.2082120e-01, 7.7772550e-01, 7.4634640e-01, 1.1303030e+00, 6.1776410e-01, 1.1576080e+00,
 2.5546960e-01, 2.6167660e-01, 2.1290200e-01, 3.5236760e-01, 5.4104750e-01, 4.0147540e-01, 2.5190110e-01, 5.6535140e-01,
 1.4104720e-01, 2.6248180e-01, 1.1230370e-01, 4.6315960e-01, 5.5078840e-01, 5.5483030e-01, 3.9890930e-01, 8.7531450e-01,
 3.7452730e-01, 4.3950590e-01, 4.1652950e-01, 4.2444330e-01, 8.4890710e-01, 7.2167080e-01, 5.2744420e-01, 7.2882410e-01,
 1.9435980e-01, 4.1437800e-01, 2.0651790e-01, 5.2438720e-01, 6.1505480e-01, 7.0981420e-01, 5.9446310e-01, 8.0310560e-01,
 1.1067520e-01, 1.3513810e-01, 1.2963630e-01, 1.0980820e-01, 4.1445420e-01, 3.6660800e-01, 2.7121080e-01, 3.1152110e-01,
 1.1520750e-01, 2.5557430e-01, 1.2892760e-01, 2.7212880e-01, 5.5974770e-01, 6.7215520e-01, 5.6979360e-01, 6.3988140e-01,
 4.1109580e-01, 5.4637490e-01, 3.6153810e-01, 6.3132610e-01, 6.9446090e-01, 6.6864150e-01, 3.4120310e-01, 8.0795070e-01,
 1.9984490e-01, 4.8255820e-01, 1.6791640e-01, 7.3065630e-01, 6.9071680e-01, 9.0281210e-01, 5.2790990e-01, 1.2221750e+00,
 2.3840580e-01, 3.2884640e-01, 2.7550770e-01, 4.3449030e-01, 6.8355300e-01, 6.8304010e-01, 4.4130940e-01, 9.4376040e-01,
 1.8005190e-01, 4.5121450e-01, 1.9879420e-01, 7.8121470e-01, 5.5124500e-01, 7.4777440e-01, 5.5361830e-01, 1.1575250e+00,
 3.3402140e-01, 5.2784450e-01, 5.1512530e-01, 5.0016920e-01, 1.0249670e+00, 1.1733820e+00, 8.8308560e-01, 1.1627310e+00,
 2.3711160e-01, 6.8075930e-01, 3.4936590e-01, 8.4528850e-01, 5.8828370e-01, 9.1425690e-01, 7.8845030e-01, 1.0149680e+00,
 8.7211170e-02, 1.4340030e-01, 1.4165270e-01, 1.1433080e-01, 4.4213780e-01, 5.2666390e-01, 4.0120330e-01, 4.3911170e-01,
 1.2418190e-01, 3.7097550e-01, 1.9270810e-01, 3.8757750e-01, 4.7303860e-01, 7.6493470e-01, 6.6772590e-01, 7.1451320e-01,
 4.1406740e-01, 7.4108710e-01, 5.0496170e-01, 8.4021080e-01, 9.4696730e-01, 1.2278100e+00, 6.4517340e-01, 1.4557220e+00,
 2.7534470e-01, 8.9533160e-01, 3.2081380e-01, 1.3301580e+00, 7.4612280e-01, 1.3132830e+00, 7.9076330e-01, 1.7444160e+00,
 1.6148290e-01, 1.9237390e-01, 1.3729860e-01, 2.0758470e-01, 3.9575260e-01, 3.4153980e-01, 1.8798250e-01, 3.8540650e-01,
 1.1346500e-01, 2.4557860e-01, 9.2170140e-02, 3.4724820e-01, 2.3255320e-01, 2.7245310e-01, 1.7183460e-01, 3.4444020e-01,
 4.7308900e-01, 6.4568120e-01, 5.3678960e-01, 4.9967920e-01, 1.2408540e+00, 1.2268560e+00, 7.8656740e-01, 9.9287680e-01,
 3.1244660e-01, 7.7474740e-01, 3.3870850e-01, 7.8565810e-01, 5.1894750e-01, 6.9654390e-01, 5.1172130e-01, 6.3153070e-01,
 1.2166770e-01, 1.7278140e-01, 1.4539540e-01, 1.1250500e-01, 5.2723320e-01, 5.4240320e-01, 3.5199160e-01, 3.6933960e-01,
 1.6118170e-01, 4.1585920e-01, 1.8402640e-01, 3.5483120e-01, 4.1102460e-01, 5.7403600e-01, 4.2686640e-01, 4.3791230e-01,
 6.9866100e-01, 1.0799610e+00, 6.2686850e-01, 9.9997550e-01, 1.3657540e+00, 1.5293680e+00, 6.8459920e-01, 1.4808860e+00,
 4.3224150e-01, 1.2138840e+00, 3.7053170e-01, 1.4728510e+00, 7.8410410e-01, 1.1919700e+00, 6.1141000e-01, 1.2930620e+00,
 2.5798490e-01, 3.2293870e-01, 2.8263940e-01, 3.4453320e-01, 1.0123340e+00, 9.1801040e-01, 6.1960730e-01, 1.0242050e+00,
 2.2747900e-01, 5.1734010e-01, 2.3810520e-01, 7.2324840e-01, 8.7030550e-01, 1.0713890e+00, 8.2862690e-01, 1.3391560e+00,
 3.9023820e-01, 5.5964310e-01, 5.7054520e-01, 4.2819940e-01, 1.6388530e+00, 1.7026250e+00, 1.3386110e+00, 1.3623310e+00,
 3.2342570e-01, 8.4268420e-01, 4.5177660e-01, 8.4489000e-01, 1.0027480e+00, 1.4142400e+00, 1.2740930e+00, 1.2677420e+00,
 1.2789340e-01, 1.9084290e-01, 1.9693490e-01, 1.2286070e-01, 8.8737710e-01, 9.5925420e-01, 7.6337280e-01, 6.4580160e-01,
 2.1261820e-01, 5.7641740e-01, 3.1279790e-01, 4.8626660e-01, 1.0120980e+00, 1.4852510e+00, 1.3543960e+00, 1.1202360e+00,
 4.9348250e-01, 8.0152950e-01, 5.7053280e-01, 7.3377420e-01, 1.5445790e+00, 1.8174210e+00, 9.9763810e-01, 1.7399110e+00,
 3.8312760e-01, 1.1305770e+00, 4.2319580e-01, 1.3562620e+00, 1.2973600e+00, 2.0723260e+00, 1.3035220e+00, 2.2226650e+00,
 3.9156090e-02, 3.3769120e-02, 2.9899240e-02, 6.5181230e-02, 5.4683270e-02, 3.4164320e-02, 2.3327570e-02, 6.8961090e-02,
 1.5816050e-02, 2.4781500e-02, 1.1538460e-02, 6.2680250e-02, 4.7375060e-02, 4.0180930e-02, 3.1438330e-02, 9.0864820e-02,
 5.2200370e-02, 5.1576230e-02, 5.3193210e-02, 7.1396410e-02, 7.8020590e-02, 5.5844840e-02, 4.4416670e-02, 8.0842260e-02,
 1.9818460e-02, 3.5575830e-02, 1.9294860e-02, 6.4533050e-02, 4.8107070e-02, 4.6744930e-02, 4.2603010e-02, 7.5811370e-02,
 1.8480820e-02, 1.8999560e-02, 1.9834350e-02, 2.2129540e-02, 4.5635900e-02, 3.3988090e-02, 2.7362600e-02, 4.1398450e-02,
 1.4074240e-02, 2.6287930e-02, 1.4431480e-02, 4.0122270e-02, 5.2452760e-02, 5.3032290e-02, 4.8923090e-02, 7.2367260e-02,
 5.7209520e-02, 6.4019280e-02, 4.6099870e-02, 1.0603410e-01, 6.3728270e-02, 5.1662140e-02, 2.8689140e-02, 8.9482020e-02,
 2.0346600e-02, 4.1365970e-02, 1.5664340e-02, 8.9779770e-02, 5.3942400e-02, 5.9363900e-02, 3.7775520e-02, 1.1519410e-01,
 3.9260360e-02, 4.5595850e-02, 4.1571100e-02, 8.6354330e-02, 7.4228150e-02, 6.2450730e-02, 4.3909650e-02, 1.2368720e-01,
 2.1692450e-02, 4.5770820e-02, 2.1944970e-02, 1.1359200e-01, 5.0943310e-02, 5.8184570e-02, 4.6878450e-02, 1.2910400e-01,
 5.0019780e-02, 6.6553100e-02, 7.0680690e-02, 9.0396390e-02, 1.0121310e-01, 9.7557560e-02, 7.9900540e-02, 1.3857100e-01,
 2.5977290e-02, 6.2795610e-02, 3.5070490e-02, 1.1176670e-01, 4.9437830e-02, 6.4689770e-02, 6.0710970e-02, 1.0294170e-01,
 1.5646620e-02, 2.1661740e-02, 2.3285930e-02, 2.4755870e-02, 5.2307640e-02, 5.2460910e-02, 4.3490300e-02, 6.2697340e-02,
 1.6299720e-02, 4.0997930e-02, 2.3176190e-02, 6.1396990e-02, 4.7626650e-02, 6.4844420e-02, 6.1598760e-02, 8.6822110e-02,
 6.1911850e-02, 9.3296800e-02, 6.9180150e-02, 1.5162040e-01, 9.3367710e-02, 1.0192660e-01, 5.8285230e-02, 1.7322350e-01,
 3.0119850e-02, 8.2462180e-02, 3.2155080e-02, 1.7560870e-01, 6.2606300e-02, 9.2781350e-02, 6.0795940e-02, 1.7665440e-01,
 1.8783180e-02, 1.8840120e-02, 1.4632850e-02, 2.9141010e-02, 3.0354660e-02, 2.2056560e-02, 1.3211110e-02, 3.5676910e-02,
 9.6555680e-03, 1.7595490e-02, 7.1866530e-03, 3.5663400e-02, 1.5179940e-02, 1.4973880e-02, 1.0277290e-02, 2.7134890e-02,
 5.0039800e-02, 5.7502360e-02, 5.2023210e-02, 6.3786760e-02, 8.6547060e-02, 7.2047720e-02, 5.0267590e-02, 8.3578330e-02,
 2.4178090e-02, 5.0477870e-02, 2.4015550e-02, 7.3374700e-02, 3.0803580e-02, 3.4811360e-02, 2.7831180e-02, 4.5241690e-02,
 1.5418030e-02, 1.8435090e-02, 1.6882030e-02, 1.7206490e-02, 4.4057050e-02, 3.8161870e-02, 2.6950400e-02, 3.7248180e-02,
 1.4943170e-02, 3.2461470e-02, 1.5632460e-02, 3.9702280e-02, 2.9229840e-02, 3.4371030e-02, 2.7814480e-02, 3.7584810e-02,
 7.3786060e-02, 9.6030880e-02, 6.0660310e-02, 1.2745700e-01, 9.5112860e-02, 8.9675470e-02, 4.3684120e-02, 1.2446720e-01,
 3.3397020e-02, 7.8968400e-02, 2.6231740e-02, 1.3734300e-01, 4.6471490e-02, 5.9480260e-02, 3.3202110e-02, 9.2490840e-02,
 3.3636300e-02, 3.5451020e-02, 3.3765020e-02, 5.4214010e-02, 8.7035600e-02, 6.6453110e-02, 4.8810120e-02, 1.0627390e-01,
 2.1698450e-02, 4.1548780e-02, 2.0810210e-02, 8.3260970e-02, 6.3678180e-02, 6.6002580e-02, 5.5551820e-02, 1.1825420e-01,
 4.6267260e-02, 5.5866300e-02, 6.1980400e-02, 6.1271240e-02, 1.2812770e-01, 1.1207710e-01, 9.5890960e-02, 1.2854410e-01,
 2.8053820e-02, 6.1542770e-02, 3.5905540e-02, 8.8447230e-02, 6.6717690e-02, 7.9225830e-02, 7.7673050e-02, 1.0179970e-01,
 1.8166580e-02, 2.2824200e-02, 2.5631140e-02, 2.1062230e-02, 8.3117430e-02, 7.5650610e-02, 6.5515030e-02, 7.3004510e-02,
 2.2095240e-02, 5.0434790e-02, 2.9783960e-02, 6.0987300e-02, 8.0677470e-02, 9.9683770e-02, 9.8922660e-02, 1.0777200e-01,
 5.8418560e-02, 7.9890190e-02, 6.1884250e-02, 1.0483550e-01, 1.2057250e-01, 1.1945070e-01, 7.1356180e-02, 1.6392000e-01,
 3.3181500e-02, 8.2441840e-02, 3.3582600e-02, 1.4176300e-01, 8.6187580e-02, 1.1591430e-01, 7.9345590e-02, 1.7820700e-01,
 1.1624010e-01, 1.3247730e-01, 8.0452130e-02, 1.6141330e-01, 2.1730960e-01, 1.7941640e-01, 8.4026160e-02, 2.2860660e-01,
 6.4550350e-02, 1.3365740e-01, 4.2684390e-02, 2.1339850e-01, 2.1808610e-01, 2.4443480e-01, 1.3117720e-01, 3.4892650e-01,
 1.6845560e-01, 2.1995110e-01, 1.5559250e-01, 1.9219770e-01, 3.3704570e-01, 3.1880660e-01, 1.7391860e-01, 2.9132510e-01,
 8.7927670e-02, 2.0858130e-01, 7.7592140e-02, 2.3883490e-01, 2.4073650e-01, 3.0912390e-01, 1.9323870e-01, 3.1646630e-01,
 5.0770210e-02, 6.8975690e-02, 4.9388550e-02, 5.0713090e-02, 1.6782710e-01, 1.6517600e-01, 9.1208120e-02, 1.2699880e-01,
 5.3156520e-02, 1.3120570e-01, 4.9404090e-02, 1.2640870e-01, 2.2344850e-01, 2.9854810e-01, 1.8890510e-01, 2.5716470e-01,
 1.6970000e-01, 2.5095110e-01, 1.2394640e-01, 2.6237300e-01, 2.5305410e-01, 2.7109310e-01, 1.0325700e-01, 2.9639920e-01,
 8.2975350e-02, 2.2292840e-01, 5.7901530e-02, 3.0541880e-01, 2.4812200e-01, 3.6084620e-01, 1.5749470e-01, 4.4200300e-01,
 1.6380630e-01, 2.5140070e-01, 1.5721300e-01, 3.0055260e-01, 4.1458410e-01, 4.6094210e-01, 2.2229240e-01, 5.7627390e-01,
 1.2443110e-01, 3.4695540e-01, 1.1409740e-01, 5.4353570e-01, 3.2959820e-01, 4.9747400e-01, 2.7491060e-01, 6.9678270e-01,
 2.2686790e-01, 3.9890030e-01, 2.9057120e-01, 3.4201280e-01, 6.1451940e-01, 7.8275300e-01, 4.3971300e-01, 7.0182900e-01,
 1.6198280e-01, 5.1745090e-01, 1.9821540e-01, 5.8136330e-01, 3.4770590e-01, 6.0124720e-01, 3.8702630e-01, 6.0395430e-01,
 6.0412640e-02, 1.1052630e-01, 8.1493230e-02, 7.9734360e-02, 2.7035860e-01, 3.5832380e-01, 2.0374550e-01, 2.7032370e-01,
 8.6522900e-02, 2.8759260e-01, 1.1151000e-01, 2.7186800e-01, 2.8515350e-01, 5.1305760e-01, 3.3428840e-01, 4.3362970e-01,
 2.5811120e-01, 5.1400180e-01, 2.6141780e-01, 5.2729140e-01, 5.2107170e-01, 7.5171480e-01, 2.9483560e-01, 8.0643190e-01,
 1.7263530e-01, 6.2459210e-01, 1.6705020e-01, 8.3962030e-01, 4.0473660e-01, 7.9264730e-01, 3.5624570e-01, 9.5266230e-01,
 7.2682870e-02, 9.6341070e-02, 5.1323050e-02, 9.4064900e-02, 1.5723750e-01, 1.5098480e-01, 6.2028410e-02, 1.5416220e-01,
 5.1367050e-02, 1.2370090e-01, 3.4654050e-02, 1.5826670e-01, 9.1086560e-02, 1.1873630e-01, 5.5896360e-02, 1.3582270e-01,
 2.1049100e-01, 3.1964530e-01, 1.9835160e-01, 2.2382500e-01, 4.8734670e-01, 5.3613080e-01, 2.5656310e-01, 3.9259010e-01,
 1.3982460e-01, 3.8576920e-01, 1.2588520e-01, 3.5397130e-01, 2.0092800e-01, 3.0007170e-01, 1.6454760e-01, 2.4617170e-01,
 5.5210650e-02, 8.7237680e-02, 5.4794770e-02, 5.1398000e-02, 2.1119180e-01, 2.4174430e-01, 1.1709750e-01, 1.4894530e-01,
 7.3566560e-02, 2.1118870e-01, 6.9756670e-02, 1.6304710e-01, 1.6230870e-01, 2.5221600e-01, 1.3999320e-01, 1.7409560e-01,
 2.8529490e-01, 4.9067670e-01, 2.1259100e-01, 4.1109630e-01, 4.9229640e-01, 6.1337480e-01, 2.0494230e-01, 5.3740610e-01,
 1.7752980e-01, 5.5473000e-01, 1.2638950e-01, 6.0901810e-01, 2.7862990e-01, 4.7127980e-01, 1.8043780e-01, 4.6259390e-01,
 1.0110550e-01, 1.4081870e-01, 9.1992890e-02, 1.3593720e-01, 3.5021220e-01, 3.5335770e-01, 1.7801840e-01, 3.5671480e-01,
 8.9668350e-02, 2.2689950e-01, 7.7948460e-02, 2.8701990e-01, 2.9681010e-01, 4.0654990e-01, 2.3469670e-01, 4.5979560e-01,
 1.5118040e-01, 2.4123280e-01, 1.8356780e-01, 1.6700840e-01, 5.6044420e-01, 6.4784500e-01, 3.8017850e-01, 4.6903110e-01,
 1.2602520e-01, 3.6534850e-01, 1.4620000e-01, 3.3144360e-01, 3.3805240e-01, 5.3048690e-01, 3.5672540e-01, 4.3027850e-01,
 5.0532510e-02, 8.3899250e-02, 6.4622850e-02, 4.8872220e-02, 3.0949780e-01, 3.7225680e-01, 2.2111940e-01, 2.2676450e-01,
 8.4496790e-02, 2.5488040e-01, 1.0323920e-01, 1.9455430e-01, 3.4799370e-01, 5.6820920e-01, 3.8675450e-01, 3.8777980e-01,
 1.7545850e-01, 3.1708940e-01, 1.6847060e-01, 2.6265860e-01, 4.8477400e-01, 6.3466500e-01, 2.6004190e-01, 5.4977260e-01,
 1.3701350e-01, 4.4986240e-01, 1.2569040e-01, 4.8830380e-01, 4.0141130e-01, 7.1342220e-01, 3.3495640e-01, 6.9235620e-01,
 3.7786320e-02, 3.6695860e-02, 2.5941770e-02, 4.7184470e-02, 5.5043180e-02, 3.8724320e-02, 2.1111670e-02, 5.2070810e-02,
 1.9110100e-02, 3.3717420e-02, 1.2534780e-02, 5.6811560e-02, 5.7961150e-02, 5.5356570e-02, 3.4582060e-02, 8.3391950e-02,
 5.4929110e-02, 6.1113980e-02, 5.0325650e-02, 5.6356830e-02, 8.5635120e-02, 6.9022030e-02, 4.3832150e-02, 6.6561370e-02,
 2.6111300e-02, 5.2780740e-02, 2.2856210e-02, 6.3779600e-02, 6.4178520e-02, 7.0222680e-02, 5.1100510e-02, 7.5867590e-02,
 1.8604530e-02, 2.1537890e-02, 1.7952280e-02, 1.6711330e-02, 4.7920110e-02, 4.0188330e-02, 2.5832880e-02, 3.2608920e-02,
 1.7739940e-02, 3.7311730e-02, 1.6354680e-02, 3.7936190e-02, 6.6944940e-02, 7.6216990e-02, 5.6139360e-02, 6.9283960e-02,
 5.2059020e-02, 6.5599490e-02, 3.7716510e-02, 7.2379310e-02, 6.0488590e-02, 5.5217370e-02, 2.4482910e-02, 6.3711560e-02,
 2.3181890e-02, 5.3071620e-02, 1.6046240e-02, 7.6732040e-02, 6.2231420e-02, 7.7119450e-02, 3.9182670e-02, 9.9689830e-02,
 1.1735780e-01, 1.5347760e-01, 1.1172580e-01, 1.9363470e-01, 2.3144090e-01, 2.1926580e-01, 1.2309360e-01, 2.8929270e-01,
 8.1188770e-02, 1.9290260e-01, 7.3845890e-02, 3.1891600e-01, 1.9306200e-01, 2.4830160e-01, 1.5973020e-01, 3.6702060e-01,
 1.6303960e-01, 2.4427650e-01, 2.0713640e-01, 2.2102620e-01, 3.4411350e-01, 3.7349780e-01, 2.4424120e-01, 3.5340980e-01,
 1.0601680e-01, 2.8858400e-01, 1.2868470e-01, 3.4216420e-01, 2.0429730e-01, 3.0102380e-01, 2.2556650e-01, 3.1910660e-01,
 4.8791100e-02, 7.6063350e-02, 6.5285670e-02, 5.7908110e-02, 1.7013700e-01, 1.9214610e-01, 1.2718330e-01, 1.5297620e-01,
 6.3639900e-02, 1.8024920e-01, 8.1357160e-02, 1.7981990e-01, 1.8828770e-01, 2.8867320e-01, 2.1895150e-01, 2.5747990e-01,
 1.7451140e-01, 2.9612760e-01, 1.7532170e-01, 3.2058920e-01, 2.7451150e-01, 3.3745300e-01, 1.5407300e-01, 3.8204260e-01,
 1.0629980e-01, 3.2771510e-01, 1.0203130e-01, 4.6490770e-01, 2.2372780e-01, 3.7335730e-01, 1.9533530e-01, 4.7355190e-01,
 4.7796000e-02, 5.3984380e-02, 3.3477690e-02, 5.5624770e-02, 8.0567800e-02, 6.5922850e-02, 3.1526780e-02, 7.1033720e-02,
 3.0763080e-02, 6.3127030e-02, 2.0586510e-02, 8.5234580e-02, 4.8971590e-02, 5.4396450e-02, 2.9809660e-02, 6.5666450e-02,
 1.3884540e-01, 1.7966510e-01, 1.2978290e-01, 1.3276630e-01, 2.5048520e-01, 2.3480750e-01, 1.3080430e-01, 1.8145320e-01,
 8.3997720e-02, 1.9747340e-01, 7.5013980e-02, 1.9121990e-01, 1.0836000e-01, 1.3789580e-01, 8.8024510e-02, 1.1938450e-01,
 4.0927350e-02, 5.5105130e-02, 4.0291500e-02, 3.4262420e-02, 1.2198710e-01, 1.1898440e-01, 6.7091530e-02, 7.7365010e-02,
 4.9665740e-02, 1.2149110e-01, 4.6713860e-02, 9.8985310e-02, 9.8370050e-02, 1.3025400e-01, 8.4161130e-02, 9.4883350e-02,
 1.7704720e-01, 2.5947030e-01, 1.3086500e-01, 2.2941390e-01, 2.3804970e-01, 2.5273420e-01, 9.8300610e-02, 2.3368170e-01,
 1.0033490e-01, 2.6715270e-01, 7.0855800e-02, 3.0952240e-01, 1.4136870e-01, 2.0375180e-01, 9.0810580e-02, 2.1106030e-01,
 9.1354320e-02, 1.0842060e-01, 8.2450260e-02, 1.1045200e-01, 2.4656500e-01, 2.1198830e-01, 1.2432220e-01, 2.2584080e-01,
 7.3786870e-02, 1.5910020e-01, 6.3625470e-02, 2.1238950e-01, 2.1926200e-01, 2.5591500e-01, 1.7197890e-01, 3.0544330e-01,
 1.3702140e-01, 1.8630580e-01, 1.6503390e-01, 1.3611700e-01, 3.9579580e-01, 3.8985860e-01, 2.6632380e-01, 2.9786650e-01,
 1.0402460e-01, 2.5697040e-01, 1.1970430e-01, 2.4601940e-01, 2.5049980e-01, 3.3496170e-01, 2.6220490e-01, 2.8671740e-01,
 5.1470260e-02, 7.2818340e-02, 6.5291280e-02, 4.4763980e-02, 2.4563430e-01, 2.5175100e-01, 1.7407720e-01, 1.6184070e-01,
 7.8381110e-02, 2.0146740e-01, 9.4994660e-02, 1.6229050e-01, 2.8979260e-01, 4.0320080e-01, 3.1947350e-01, 2.9039040e-01,
 1.4961120e-01, 2.3039270e-01, 1.4249430e-01, 2.0140150e-01, 3.2208840e-01, 3.5931680e-01, 1.7138100e-01, 3.2847320e-01,
 1.0639930e-01, 2.9768180e-01, 9.6819120e-02, 3.4099390e-01, 2.7984000e-01, 4.2380300e-01, 2.3162850e-01, 4.3404120e-01,
 2.1137340e-01, 2.1650900e-01, 1.7615330e-01, 2.9154590e-01, 4.1240380e-01, 3.0601740e-01, 1.9200710e-01, 4.3092900e-01,
 1.0846890e-01, 2.0185530e-01, 8.6364430e-02, 3.5618160e-01, 3.6222180e-01, 3.6487990e-01, 2.6233960e-01, 5.7564390e-01,
 2.9587810e-01, 3.4721140e-01, 3.2906000e-01, 3.3531190e-01, 6.1782530e-01, 5.2522420e-01, 3.8386810e-01, 5.3043020e-01,
 1.4271370e-01, 3.0426770e-01, 1.5164110e-01, 3.8504470e-01, 3.8620850e-01, 4.4571040e-01, 3.7327850e-01, 5.0429040e-01,
 9.5684140e-02, 1.1683350e-01, 1.1207700e-01, 9.4934580e-02, 3.3009770e-01, 2.9199000e-01, 2.1600960e-01, 2.4811520e-01,
 9.2576370e-02, 2.0536990e-01, 1.0360140e-01, 2.1867240e-01, 3.8464570e-01, 4.6188950e-01, 3.9154900e-01, 4.3971170e-01,
 2.8993990e-01, 3.8535020e-01, 2.5498750e-01, 4.4526500e-01, 4.5122060e-01, 4.3444460e-01, 2.2169400e-01, 5.2495970e-01,
 1.3100500e-01, 3.1633290e-01, 1.1007480e-01, 4.7896950e-01, 3.8720740e-01, 5.0610540e-01, 2.9593980e-01, 6.8513630e-01,
 2.7171650e-01, 3.7479360e-01, 3.1400230e-01, 4.9519830e-01, 7.1770750e-01, 7.1716910e-01, 4.6336000e-01, 9.9091660e-01,
 1.9073340e-01, 4.7798240e-01, 2.1058750e-01, 8.2755970e-01, 4.9937010e-01, 6.7740510e-01, 5.0152010e-01, 1.0485970e+00,
 3.6348930e-01, 5.7441180e-01, 5.6057060e-01, 5.4429500e-01, 1.0275520e+00, 1.1763410e+00, 8.8531220e-01, 1.1656620e+00,
 2.3982810e-01, 6.8855840e-01, 3.5336840e-01, 8.5497250e-01, 5.0884210e-01, 7.9079590e-01, 6.8197820e-01, 8.7790670e-01,
 1.0386040e-01, 1.7077650e-01, 1.6869520e-01, 1.3615730e-01, 4.8507820e-01, 5.7781350e-01, 4.4016820e-01, 4.8175820e-01,
 1.3745670e-01, 4.1063210e-01, 2.1330820e-01, 4.2900880e-01, 4.4776820e-01, 7.2407080e-01, 6.3205500e-01, 6.7634290e-01,
 4.0227590e-01, 7.1998290e-01, 4.9058180e-01, 8.1628390e-01, 8.4754770e-01, 1.0989050e+00, 5.7743840e-01, 1.3028900e+00,
 2.4863340e-01, 8.0847510e-01, 2.8969160e-01, 1.2011190e+00, 5.7615860e-01, 1.0141210e+00, 6.1063010e-01, 1.3470440e+00,
 1.6301490e-01, 1.9419900e-01, 1.3860110e-01, 2.0955410e-01, 3.6804490e-01, 3.1762770e-01, 1.7482130e-01, 3.5842320e-01,
 1.0646150e-01, 2.3042060e-01, 8.6481040e-02, 3.2581470e-01, 1.8659580e-01, 2.1861070e-01, 1.3787650e-01, 2.7637160e-01,
 4.5599700e-01, 6.2235370e-01, 5.1739620e-01, 4.8162650e-01, 1.1018340e+00, 1.0894040e+00, 6.9844360e-01, 8.8163890e-01,
 2.7991410e-01, 6.9407930e-01, 3.0344150e-01, 7.0385390e-01, 3.9757710e-01, 5.3363750e-01, 3.9204100e-01, 4.8382960e-01,
 1.2833790e-01, 1.8225380e-01, 1.5336640e-01, 1.1867290e-01, 5.1234040e-01, 5.2708190e-01, 3.4204880e-01, 3.5890680e-01,
 1.5802470e-01, 4.0771410e-01, 1.8042200e-01, 3.4788140e-01, 3.4460860e-01, 4.8127970e-01, 3.5789060e-01, 3.6715170e-01,
 6.0120300e-01, 9.2931500e-01, 5.3942510e-01, 8.6048640e-01, 1.0826880e+00, 1.2123910e+00, 5.4270940e-01, 1.1739580e+00,
 3.4570920e-01, 9.7087150e-01, 2.9635340e-01, 1.1779940e+00, 5.3629920e-01, 8.1526470e-01, 4.1818260e-01, 8.8440810e-01,
 2.0815050e-01, 2.6055730e-01, 2.2804260e-01, 2.7798050e-01, 7.5246010e-01, 6.8234980e-01, 4.6054920e-01, 7.6128380e-01,
 1.7059030e-01, 3.8796200e-01, 1.7855910e-01, 5.4237610e-01, 5.5812790e-01, 6.8708310e-01, 5.3139940e-01, 8.5880220e-01,
 3.0062930e-01, 4.3113440e-01, 4.3953310e-01, 3.2987360e-01, 1.1631020e+00, 1.2083620e+00, 9.5001860e-01, 9.6685290e-01,
 2.3158260e-01, 6.0338740e-01, 3.2348570e-01, 6.0496680e-01, 6.1400560e-01, 8.6597100e-01, 7.8015590e-01, 7.7626720e-01,
 1.0782270e-01, 1.6089330e-01, 1.6602930e-01, 1.0357980e-01, 6.8920190e-01, 7.4502690e-01, 5.9289110e-01, 5.0157670e-01,
 1.6660660e-01, 4.5167800e-01, 2.4510690e-01, 3.8103620e-01, 6.7820840e-01, 9.9526910e-01, 9.0758300e-01, 7.5067230e-01,
 3.3939760e-01, 5.5126010e-01, 3.9238980e-01, 5.0466080e-01, 9.7864080e-01, 1.1515130e+00, 6.3210080e-01, 1.1024030e+00,
 2.4491220e-01, 7.2271520e-01, 2.7052560e-01, 8.6698290e-01, 7.0921260e-01, 1.1328540e+00, 7.1258090e-01, 1.2150380e+00,
 2.6337520e-01, 2.2714090e-01, 2.0111090e-01, 4.3842780e-01, 3.4302430e-01, 2.1431040e-01, 1.4633220e-01, 4.3258810e-01,
 1.0537560e-01, 1.6510850e-01, 7.6875840e-02, 4.1761180e-01, 3.0606260e-01, 2.5958550e-01, 2.0310470e-01, 5.8702450e-01,
 4.0578450e-01, 4.0093270e-01, 4.1350250e-01, 5.5500680e-01, 5.6562170e-01, 4.0485530e-01, 3.2200510e-01, 5.8607770e-01,
 1.5260130e-01, 2.7393230e-01, 1.4856960e-01, 4.9690170e-01, 3.5918290e-01, 3.4901280e-01, 3.1808790e-01, 5.6603220e-01,
 1.3062880e-01, 1.3429540e-01, 1.4019600e-01, 1.5641920e-01, 3.0082860e-01, 2.2404710e-01, 1.8037230e-01, 2.7289560e-01,
 9.8539210e-02, 1.8405200e-01, 1.0104030e-01, 2.8091160e-01, 3.5609910e-01, 3.6003350e-01, 3.3213640e-01, 4.9129770e-01,
 4.1265450e-01, 4.6177350e-01, 3.3252010e-01, 7.6482810e-01, 4.2869180e-01, 3.4752460e-01, 1.9298820e-01, 6.0193400e-01,
 1.4537050e-01, 2.9554790e-01, 1.1191720e-01, 6.4145040e-01, 3.7370890e-01, 4.1126860e-01, 2.6170590e-01, 7.9805600e-01,
 2.4631460e-01, 2.8606270e-01, 2.6081190e-01, 5.4177630e-01, 4.3430960e-01, 3.6539980e-01, 2.5691580e-01, 7.2369510e-01,
 1.3480660e-01, 2.8444020e-01, 1.3637580e-01, 7.0591150e-01, 3.0697850e-01, 3.5061360e-01, 2.8248420e-01, 7.7796580e-01,
 3.6268030e-01, 4.8255910e-01, 5.1248720e-01, 6.5544060e-01, 6.8440590e-01, 6.5968730e-01, 5.4028990e-01, 9.3702120e-01,
 1.8657030e-01, 4.5100150e-01, 2.5187810e-01, 8.0271470e-01, 3.4429170e-01, 4.5050830e-01, 4.2279940e-01, 7.1689990e-01,
 1.0315700e-01, 1.4281420e-01, 1.5352240e-01, 1.6321350e-01, 3.2161630e-01, 3.2255870e-01, 2.6740240e-01, 3.8549790e-01,
 1.0644480e-01, 2.6773570e-01, 1.5135150e-01, 4.0095120e-01, 3.0158730e-01, 4.1061570e-01, 3.9006320e-01, 5.4978550e-01,
 4.1653580e-01, 6.2769020e-01, 4.6543610e-01, 1.0200850e+00, 5.8582810e-01, 6.3953010e-01, 3.6570600e-01, 1.0868770e+00,
 2.0072330e-01, 5.4954070e-01, 2.1428640e-01, 1.1702830e+00, 4.0455870e-01, 5.9954840e-01, 3.9286030e-01, 1.1415320e+00,
 1.1091670e-01, 1.1125290e-01, 8.6408560e-02, 1.7208080e-01, 1.6716610e-01, 1.2146760e-01, 7.2754870e-02, 1.9647620e-01,
 5.6477060e-02, 1.0291900e-01, 4.2035960e-02, 2.0860130e-01, 8.6095950e-02, 8.4927240e-02, 5.8289640e-02, 1.5390080e-01,
 3.4149920e-01, 3.9242790e-01, 3.5503510e-01, 4.3531610e-01, 5.5083480e-01, 4.5855280e-01, 3.1993160e-01, 5.3194010e-01,
 1.6344160e-01, 3.4122570e-01, 1.6234280e-01, 4.9600600e-01, 2.0191110e-01, 2.2818130e-01, 1.8242770e-01, 2.9655000e-01,
 9.5675080e-02, 1.1439720e-01, 1.0475980e-01, 1.0677320e-01, 2.5496480e-01, 2.2084850e-01, 1.5596610e-01, 2.1556090e-01,
 9.1849990e-02, 1.9952830e-01, 9.6086820e-02, 2.4403480e-01, 1.7421330e-01, 2.0485540e-01, 1.6577760e-01, 2.2400990e-01,
 4.6724520e-01, 6.0810900e-01, 3.8412730e-01, 8.0711300e-01, 5.6170030e-01, 5.2958910e-01, 2.5798180e-01, 7.3505610e-01,
 2.0948100e-01, 4.9532510e-01, 1.6453720e-01, 8.6147690e-01, 2.8264550e-01, 3.6176650e-01, 2.0193950e-01, 5.6254100e-01,
 3.1778000e-01, 3.3492470e-01, 3.1899620e-01, 5.1218870e-01, 7.6684970e-01, 5.8550240e-01, 4.3005420e-01, 9.3635390e-01,
 2.0305500e-01, 3.8881520e-01, 1.9474280e-01, 7.7915950e-01, 5.7782190e-01, 5.9891380e-01, 5.0408260e-01, 1.0730500e+00,
 5.0517120e-01, 6.0997870e-01, 6.7673580e-01, 6.6899280e-01, 1.3046760e+00, 1.1412390e+00, 9.7642160e-01, 1.3089160e+00,
 3.0340530e-01, 6.6559230e-01, 3.8832270e-01, 9.5656710e-01, 6.9966590e-01, 8.3083840e-01, 8.1455450e-01, 1.0675700e+00,
 1.8035730e-01, 2.2659810e-01, 2.5446520e-01, 2.0910520e-01, 7.6956900e-01, 7.0043510e-01, 6.0659160e-01, 6.7593530e-01,
 2.1728300e-01, 4.9597210e-01, 2.9289330e-01, 5.9974460e-01, 7.6930360e-01, 9.5053900e-01, 9.4328150e-01, 1.0276650e+00,
 5.9185050e-01, 8.0938390e-01, 6.2696210e-01, 1.0621100e+00, 1.1392110e+00, 1.1286120e+00, 6.7419820e-01, 1.5487740e+00,
 3.3298420e-01, 8.2732320e-01, 3.3700930e-01, 1.4226250e+00, 8.3866940e-01, 1.1279320e+00, 7.7209170e-01, 1.7340870e+00,
 2.5091820e-01, 2.8596800e-01, 1.7366550e-01, 3.4842990e-01, 4.3747160e-01, 3.6118780e-01, 1.6915520e-01, 4.6021380e-01,
 1.3801970e-01, 2.8578230e-01, 9.1266520e-02, 4.5628250e-01, 4.5215670e-01, 5.0678520e-01, 2.7196890e-01, 7.2342740e-01,
 4.2025000e-01, 5.4871710e-01, 3.8816010e-01, 4.7948010e-01, 7.8416240e-01, 7.4172790e-01, 4.0463490e-01, 6.7779010e-01,
 2.1727730e-01, 5.1542340e-01, 1.9173730e-01, 5.9018280e-01, 5.7683200e-01, 7.4069570e-01, 4.6302170e-01, 7.5828910e-01,
 1.1516670e-01, 1.5646390e-01, 1.1203260e-01, 1.1503720e-01, 3.5503820e-01, 3.4942990e-01, 1.9295080e-01, 2.6866590e-01,
 1.1943760e-01, 2.9480670e-01, 1.1100630e-01, 2.8402830e-01, 4.8683360e-01, 6.5045520e-01, 4.1157280e-01, 5.6029200e-01,
 3.9282630e-01, 5.8090870e-01, 2.8691450e-01, 6.0734840e-01, 5.4629470e-01, 5.8523740e-01, 2.2291180e-01, 6.3986840e-01,
 1.9025420e-01, 5.1115250e-01, 1.3276240e-01, 7.0029490e-01, 5.5165660e-01, 8.0227970e-01, 3.5016250e-01, 9.8271780e-01,
 3.2981240e-01, 5.0617750e-01, 3.1653730e-01, 6.0514140e-01, 7.7847380e-01, 8.6552110e-01, 4.1740340e-01, 1.0820820e+00,
 2.4815990e-01, 6.9195280e-01, 2.2755080e-01, 1.0840040e+00, 6.3739140e-01, 9.6203690e-01, 5.3163420e-01, 1.3474690e+00,
 5.2790500e-01, 9.2821180e-01, 6.7613810e-01, 7.9583890e-01, 1.3335620e+00, 1.6986440e+00, 9.5421650e-01, 1.5230320e+00,
 3.7335160e-01, 1.1926650e+00, 4.5686370e-01, 1.3399750e+00, 7.7710500e-01, 1.3437570e+00, 8.6498410e-01, 1.3498070e+00,
 1.2782220e-01, 2.3385360e-01, 1.7242490e-01, 1.6870350e-01, 5.3347440e-01, 7.0704820e-01, 4.0203270e-01, 5.3340560e-01,
 1.8133270e-01, 6.0272990e-01, 2.3370000e-01, 5.6977460e-01, 5.7948500e-01, 1.0426280e+00, 6.7933610e-01, 8.8121630e-01,
 5.5729600e-01, 1.1097970e+00, 5.6443540e-01, 1.1384910e+00, 1.0492320e+00, 1.5136560e+00, 5.9368200e-01, 1.6238340e+00,
 3.6921150e-01, 1.3358020e+00, 3.5726670e-01, 1.7956780e+00, 8.3933730e-01, 1.6437810e+00, 7.3877740e-01, 1.9756180e+00,
 1.3774010e-01, 1.8257440e-01, 9.7261470e-02, 1.7826080e-01, 2.7789410e-01, 2.6684350e-01, 1.0962610e-01, 2.7245900e-01,
 9.6422720e-02, 2.3220300e-01, 6.5050220e-02, 2.9708740e-01, 1.6579350e-01, 2.1612090e-01, 1.0174120e-01, 2.4722120e-01,
 4.6100770e-01, 7.0007260e-01, 4.3442050e-01, 4.9021120e-01, 9.9542280e-01, 1.0950660e+00, 5.2403930e-01, 8.0187920e-01,
 3.0333660e-01, 8.3689060e-01, 2.7309640e-01, 7.6790800e-01, 4.2266870e-01, 6.3122580e-01, 3.4613940e-01, 5.1784260e-01,
 1.0994950e-01, 1.7372990e-01, 1.0912130e-01, 1.0235680e-01, 3.9223150e-01, 4.4897430e-01, 2.1747670e-01, 2.7662550e-01,
 1.4511670e-01, 4.1658880e-01, 1.3760130e-01, 3.2162520e-01, 3.1045390e-01, 4.8242310e-01, 2.6777020e-01, 3.3299910e-01,
 5.7978250e-01, 9.9716370e-01, 4.3203210e-01, 8.3543870e-01, 9.3302350e-01, 1.1624970e+00, 3.8841640e-01, 1.0185170e+00,
 3.5736230e-01, 1.1166550e+00, 2.5441840e-01, 1.2259360e+00, 5.4385570e-01, 9.1988760e-01, 3.5219510e-01, 9.0293370e-01,
 3.0654470e-01, 4.2695220e-01, 2.7891590e-01, 4.1215180e-01, 9.9025070e-01, 9.9914470e-01, 5.0336000e-01, 1.0086370e+00,
 2.6929270e-01, 6.8142640e-01, 2.3409540e-01, 8.6198040e-01, 8.6433600e-01, 1.1839070e+00, 6.8345640e-01, 1.3389630e+00,
 5.2973750e-01, 8.4528200e-01, 6.4322350e-01, 5.8519910e-01, 1.8314390e+00, 2.1170510e+00, 1.2423610e+00, 1.5327160e+00,
 4.3741040e-01, 1.2680580e+00, 5.0743360e-01, 1.1503800e+00, 1.1377170e+00, 1.7853560e+00, 1.2005610e+00, 1.4481040e+00,
 1.6100220e-01, 2.6731240e-01, 2.0589560e-01, 1.5571240e-01, 9.1963070e-01, 1.1061110e+00, 6.5702640e-01, 6.7380010e-01,
 2.6666600e-01, 8.0438500e-01, 3.2581570e-01, 6.1400000e-01, 1.0649210e+00, 1.7388190e+00, 1.1835360e+00, 1.1866730e+00,
 5.7047410e-01, 1.0309640e+00, 5.4775430e-01, 8.5399110e-01, 1.4699270e+00, 1.9244250e+00, 7.8849660e-01, 1.6670150e+00,
 4.4125670e-01, 1.4487980e+00, 4.0479040e-01, 1.5726000e+00, 1.2535340e+00, 2.2278870e+00, 1.0460070e+00, 2.1621020e+00,
 8.1306400e-02, 7.8960020e-02, 5.5819990e-02, 1.0152880e-01, 1.1045580e-01, 7.7708550e-02, 4.2365040e-02, 1.0449110e-01,
 4.0730470e-02, 7.1863920e-02, 2.6716120e-02, 1.2108580e-01, 1.1978760e-01, 1.1440480e-01, 7.1470340e-02, 1.7234520e-01,
 1.3659630e-01, 1.5197670e-01, 1.2514850e-01, 1.4014670e-01, 1.9860180e-01, 1.6007340e-01, 1.0165390e-01, 1.5436670e-01,
 6.4317820e-02, 1.3001050e-01, 5.6299830e-02, 1.5710310e-01, 1.5328900e-01, 1.6772540e-01, 1.2205250e-01, 1.8120810e-01,
 4.2067920e-02, 4.8700710e-02, 4.0593070e-02, 3.7787080e-02, 1.0105200e-01, 8.4747540e-02, 5.4475340e-02, 6.8764390e-02,
 3.9732940e-02, 8.3568780e-02, 3.6630310e-02, 8.4967410e-02, 1.4539010e-01, 1.6552700e-01, 1.2192270e-01, 1.5047000e-01,
 1.2012370e-01, 1.5136770e-01, 8.7029050e-02, 1.6701180e-01, 1.3016710e-01, 1.1882380e-01, 5.2685450e-02, 1.3710270e-01,
 5.2984410e-02, 1.2130020e-01, 3.6675210e-02, 1.7537830e-01, 1.3792010e-01, 1.7091560e-01, 8.6838390e-02, 2.2093710e-01,
 2.3553890e-01, 3.0803180e-01, 2.2423530e-01, 3.8862750e-01, 4.3319710e-01, 4.1040850e-01, 2.3039920e-01, 5.4148060e-01,
 1.6140350e-01, 3.8349080e-01, 1.4680580e-01, 6.3400580e-01, 3.7216210e-01, 4.7864660e-01, 3.0790900e-01, 7.0749900e-01,
 3.7817260e-01, 5.6660260e-01, 4.8045550e-01, 5.1267310e-01, 7.4437780e-01, 8.0794130e-01, 5.2833660e-01, 7.6448730e-01,
 2.4357790e-01, 6.6303350e-01, 2.9565830e-01, 7.8613630e-01, 4.5513940e-01, 6.7062950e-01, 5.0252350e-01, 7.1091480e-01,
 1.0290420e-01, 1.6042350e-01, 1.3769260e-01, 1.2213270e-01, 3.3464650e-01, 3.7793670e-01, 2.5015990e-01, 3.0089260e-01,
 1.3295010e-01, 3.7655850e-01, 1.6996320e-01, 3.7566160e-01, 3.8141650e-01, 5.8476860e-01, 4.4353260e-01, 5.2158000e-01,
 3.7559260e-01, 6.3734130e-01, 3.7733660e-01, 6.8998880e-01, 5.5099610e-01, 6.7733170e-01, 3.0925340e-01, 7.6683140e-01,
 2.2661680e-01, 6.9864410e-01, 2.1751680e-01, 9.9112030e-01, 4.6248540e-01, 7.7179640e-01, 4.0379300e-01, 9.7891660e-01,
 9.0288820e-02, 1.0197900e-01, 6.3240890e-02, 1.0507770e-01, 1.4193800e-01, 1.1613770e-01, 5.5541410e-02, 1.2514160e-01,
 5.7562360e-02, 1.1812020e-01, 3.8520470e-02, 1.5948680e-01, 8.8852890e-02, 9.8695620e-02, 5.4085940e-02, 1.1914360e-01,
 3.0312410e-01, 3.9224060e-01, 2.8333890e-01, 2.8985220e-01, 5.0999480e-01, 4.7807460e-01, 2.6632110e-01, 3.6944370e-01,
 1.8164470e-01, 4.2703530e-01, 1.6221740e-01, 4.1351210e-01, 2.2721800e-01, 2.8915090e-01, 1.8457690e-01, 2.5033500e-01,
 8.1245280e-02, 1.0938970e-01, 7.9983050e-02, 6.8014670e-02, 2.2583600e-01, 2.2027720e-01, 1.2420730e-01, 1.4322670e-01,
 9.7658000e-02, 2.3888850e-01, 9.1853700e-02, 1.9463530e-01, 1.8755660e-01, 2.4834790e-01, 1.6046530e-01, 1.8090870e-01,
 3.5865280e-01, 5.2562110e-01, 2.6509930e-01, 4.6473440e-01, 4.4972560e-01, 4.7746780e-01, 1.8571040e-01, 4.4147350e-01,
 2.0132770e-01, 5.3605720e-01, 1.4217620e-01, 6.2107430e-01, 2.7505730e-01, 3.9643460e-01, 1.7668780e-01, 4.1065440e-01,
 2.7609730e-01, 3.2767610e-01, 2.4918680e-01, 3.3381560e-01, 6.9495940e-01, 5.9750270e-01, 3.5041000e-01, 6.3654680e-01,
 2.2089130e-01, 4.7628860e-01, 1.9047170e-01, 6.3581750e-01, 6.3647500e-01, 7.4287140e-01, 4.9922130e-01, 8.8664250e-01,
 4.7859450e-01, 6.5073750e-01, 5.7643780e-01, 4.7543570e-01, 1.2892750e+00, 1.2699350e+00, 8.6752960e-01, 9.7027730e-01,
 3.5989990e-01, 8.8905550e-01, 4.1414790e-01, 8.5116780e-01, 8.4037220e-01, 1.1237240e+00, 8.7964050e-01, 9.6187440e-01,
 1.6346750e-01, 2.3126820e-01, 2.0736250e-01, 1.4216860e-01, 7.2754350e-01, 7.4566070e-01, 5.1559880e-01, 4.7935550e-01,
 2.4657720e-01, 6.3379160e-01, 2.9884140e-01, 5.1054580e-01, 8.8398990e-01, 1.2299330e+00, 9.7452950e-01, 8.8581360e-01,
 4.8488620e-01, 7.4669700e-01, 4.6182050e-01, 6.5273710e-01, 9.7352170e-01, 1.0860460e+00, 5.1800410e-01, 9.9282010e-01,
 3.4157090e-01, 9.5564040e-01, 3.1081590e-01, 1.0946840e+00, 8.7110480e-01, 1.3192430e+00, 7.2102880e-01, 1.3511130e+00,
 3.3532210e-01, 3.4346920e-01, 2.7944910e-01, 4.6250760e-01, 6.1013990e-01, 4.5274420e-01, 2.8406910e-01, 6.3754740e-01,
 1.7044480e-01, 3.1718920e-01, 1.3571040e-01, 5.5969290e-01, 5.5191390e-01, 5.5596410e-01, 3.9972450e-01, 8.7710320e-01,
 5.4246420e-01, 6.3657890e-01, 6.0330000e-01, 6.1476230e-01, 1.0563770e+00, 8.9804440e-01, 6.5634950e-01, 9.0694580e-01,
 2.5917330e-01, 5.5256130e-01, 2.7538580e-01, 6.9925540e-01, 6.8008780e-01, 7.8486670e-01, 6.5731890e-01, 8.8802230e-01,
 1.5951220e-01, 1.9476970e-01, 1.8684020e-01, 1.5826260e-01, 5.1320560e-01, 4.5395920e-01, 3.3583190e-01, 3.8574680e-01,
 1.5286940e-01, 3.3912290e-01, 1.7107480e-01, 3.6108920e-01, 6.1588520e-01, 7.3956610e-01, 6.2693860e-01, 7.0405560e-01,
 4.9324480e-01, 6.5555650e-01, 4.3378390e-01, 7.5748350e-01, 7.1587690e-01, 6.8926120e-01, 3.5172520e-01, 8.3286650e-01,
 2.2075410e-01, 5.3304690e-01, 1.8548500e-01, 8.0710270e-01, 6.3267850e-01, 8.2695230e-01, 4.8355170e-01, 1.1194800e+00,
 4.0205750e-01, 5.5458020e-01, 4.6462770e-01, 7.3274250e-01, 9.9040920e-01, 9.8966610e-01, 6.3941920e-01, 1.3674270e+00,
 2.7955380e-01, 7.0056850e-01, 3.0865360e-01, 1.2129360e+00, 7.0970810e-01, 9.6273260e-01, 7.1276360e-01, 1.4902720e+00,
 6.2159890e-01, 9.8229510e-01, 9.5862540e-01, 9.3079270e-01, 1.6387670e+00, 1.8760600e+00, 1.4119200e+00, 1.8590290e+00,
 4.0624230e-01, 1.1663420e+00, 5.9856700e-01, 1.4482290e+00, 8.3576960e-01, 1.2988770e+00, 1.1201440e+00, 1.4419560e+00,
 1.6149700e-01, 2.6554760e-01, 2.6231140e-01, 2.1171680e-01, 7.0343020e-01, 8.3790910e-01, 6.3830450e-01, 6.9861580e-01,
 2.1171260e-01, 6.3246090e-01, 3.2854010e-01, 6.6076500e-01, 6.6873270e-01, 1.0813850e+00, 9.4396120e-01, 1.0101040e+00,
 6.3832070e-01, 1.1424500e+00, 7.7844210e-01, 1.2952580e+00, 1.2542210e+00, 1.6261850e+00, 8.5450670e-01, 1.9280470e+00,
 3.9078770e-01, 1.2707150e+00, 4.5532050e-01, 1.8878500e+00, 8.7809580e-01, 1.5455740e+00, 9.3063230e-01, 2.0529660e+00,
 2.2703430e-01, 2.7046510e-01, 1.9303270e-01, 2.9185040e-01, 4.7803520e-01, 4.1255090e-01, 2.2706670e-01, 4.6553800e-01,
 1.4686660e-01, 3.1787170e-01, 1.1930300e-01, 4.4947060e-01, 2.4960370e-01, 2.9242910e-01, 1.8443330e-01, 3.6969410e-01,
 7.3396020e-01, 1.0017230e+00, 8.3278670e-01, 7.7521280e-01, 1.6539460e+00, 1.6352890e+00, 1.0484240e+00, 1.3234150e+00,
 4.4627410e-01, 1.1065880e+00, 4.8378450e-01, 1.1221720e+00, 6.1463430e-01, 8.2497700e-01, 6.0607570e-01, 7.4797630e-01,
 1.8782840e-01, 2.6673670e-01, 2.2445880e-01, 1.7368320e-01, 6.9929400e-01, 7.1941460e-01, 4.6686280e-01, 4.8987230e-01,
 2.2908560e-01, 5.9105580e-01, 2.6155450e-01, 5.0431740e-01, 4.8441480e-01, 6.7653260e-01, 5.0308520e-01, 5.1610340e-01,
 8.9790010e-01, 1.3879370e+00, 8.0563440e-01, 1.2851410e+00, 1.5080130e+00, 1.6886690e+00, 7.5590820e-01, 1.6351370e+00,
 5.1142770e-01, 1.4362670e+00, 4.3841280e-01, 1.7426750e+00, 7.6930570e-01, 1.1694740e+00, 5.9987080e-01, 1.2686580e+00,
 4.6380170e-01, 5.8057470e-01, 5.0812530e-01, 6.1939700e-01, 1.5636270e+00, 1.4179360e+00, 9.5703040e-01, 1.5819630e+00,
 3.7650920e-01, 8.5626950e-01, 3.9409700e-01, 1.1970760e+00, 1.1944650e+00, 1.4704460e+00, 1.1372630e+00, 1.8379470e+00,
 7.7416320e-01, 1.1102320e+00, 1.1318600e+00, 8.4947140e-01, 2.7932760e+00, 2.9019700e+00, 2.2815400e+00, 2.3219690e+00,
 5.9070890e-01, 1.5390890e+00, 8.2513060e-01, 1.5431180e+00, 1.5186530e+00, 2.1418520e+00, 1.9296010e+00, 1.9199830e+00,
 2.5246850e-01, 3.7673400e-01, 3.8876000e-01, 2.4253350e-01, 1.5050060e+00, 1.6269110e+00, 1.2946930e+00, 1.0952900e+00,
 3.8641650e-01, 1.0475920e+00, 5.6848490e-01, 8.8375030e-01, 1.5252640e+00, 2.2383210e+00, 2.0411180e+00, 1.6882320e+00,
 8.1097280e-01, 1.3172070e+00, 9.3759490e-01, 1.2058600e+00, 2.1807990e+00, 2.5660270e+00, 1.4085710e+00, 2.4565910e+00,
 5.7966130e-01, 1.7105320e+00, 6.4028340e-01, 2.0519860e+00, 1.6276420e+00, 2.5998980e+00, 1.6353720e+00, 2.7885100e+00,
 2.5436920e-01, 2.1937390e-01, 1.9423410e-01, 4.2343610e-01, 3.0146260e-01, 1.8834400e-01, 1.2860220e-01, 3.8017460e-01,
 9.3269490e-02, 1.4614000e-01, 6.8043940e-02, 3.6963430e-01, 3.0429710e-01, 2.5808810e-01, 2.0193310e-01, 5.8363840e-01,
 4.3551950e-01, 4.3031220e-01, 4.4380300e-01, 5.9567650e-01, 5.5240420e-01, 3.9539460e-01, 3.1448050e-01, 5.7238220e-01,
 1.5009990e-01, 2.6944200e-01, 1.4613420e-01, 4.8875650e-01, 3.9684940e-01, 3.8561280e-01, 3.5144480e-01, 6.2539030e-01,
 1.3513270e-01, 1.3892570e-01, 1.4502980e-01, 1.6181230e-01, 2.8317800e-01, 2.1090150e-01, 1.6978930e-01, 2.5688390e-01,
 9.3420140e-02, 1.7449050e-01, 9.5791340e-02, 2.6631830e-01, 3.7921920e-01, 3.8340910e-01, 3.5370070e-01, 5.2319560e-01,
 4.2087830e-01, 4.7097620e-01, 3.3914690e-01, 7.8007050e-01, 3.9786340e-01, 3.2253310e-01, 1.7910980e-01, 5.5864720e-01,
 1.3588020e-01, 2.7625350e-01, 1.0461080e-01, 5.9957420e-01, 3.9237490e-01, 4.3181070e-01, 2.7477770e-01, 8.3791740e-01,
 2.3255100e-01, 2.7007800e-01, 2.4623820e-01, 5.1150280e-01, 3.7311800e-01, 3.1391720e-01, 2.2071790e-01, 6.2173080e-01,
 1.1664040e-01, 2.4610980e-01, 1.1799810e-01, 6.1078460e-01, 2.9835540e-01, 3.4076470e-01, 2.7454900e-01, 7.5611240e-01,
 3.8051730e-01, 5.0629190e-01, 5.3769180e-01, 6.8767580e-01, 6.5340570e-01, 6.2980670e-01, 5.1581750e-01, 8.9457880e-01,
 1.7939190e-01, 4.3364890e-01, 2.4218700e-01, 7.7182970e-01, 3.7185600e-01, 4.8657640e-01, 4.5664920e-01, 7.7429560e-01,
 1.0431780e-01, 1.4442130e-01, 1.5525000e-01, 1.6505020e-01, 2.9594880e-01, 2.9681600e-01, 2.4606160e-01, 3.5473220e-01,
 9.8649330e-02, 2.4812810e-01, 1.4026720e-01, 3.7158760e-01, 3.1395740e-01, 4.2745780e-01, 4.0606230e-01, 5.7233590e-01,
 4.1529870e-01, 6.2582600e-01, 4.6405380e-01, 1.0170550e+00, 5.3149260e-01, 5.8021380e-01, 3.3178670e-01, 9.8606920e-01,
 1.8340700e-01, 5.0213210e-01, 1.9580000e-01, 1.0693240e+00, 4.1522900e-01, 6.1536150e-01, 4.0322200e-01, 1.1716400e+00,
 8.1012350e-02, 8.1257940e-02, 6.3111870e-02, 1.2568590e-01, 1.1110180e-01, 8.0729750e-02, 4.8354300e-02, 1.3058190e-01,
 3.7803870e-02, 6.8890580e-02, 2.8137470e-02, 1.3963080e-01, 6.4734360e-02, 6.3855630e-02, 4.3827180e-02, 1.1571590e-01,
 2.7718290e-01, 3.1851990e-01, 2.8816950e-01, 3.5333080e-01, 4.0683370e-01, 3.3867630e-01, 2.3629390e-01, 3.9287850e-01,
 1.2157640e-01, 2.5382140e-01, 1.2075910e-01, 3.6895510e-01, 1.6870770e-01, 1.9065780e-01, 1.5242820e-01, 2.4778360e-01,
 7.4848820e-02, 8.9495540e-02, 8.1955980e-02, 8.3531110e-02, 1.8150360e-01, 1.5721700e-01, 1.1102860e-01, 1.5345280e-01,
 6.5852930e-02, 1.4305420e-01, 6.8890570e-02, 1.7496360e-01, 1.4030240e-01, 1.6498000e-01, 1.3350880e-01, 1.8040610e-01,
 3.6039550e-01, 4.6904660e-01, 2.9628500e-01, 6.2254230e-01, 3.9423750e-01, 3.7169980e-01, 1.8106830e-01, 5.1590980e-01,
 1.4807750e-01, 3.5013430e-01, 1.1630770e-01, 6.0895890e-01, 2.2442670e-01, 2.8725050e-01, 1.6034430e-01, 4.4666980e-01,
 1.9765440e-01, 2.0831810e-01, 1.9841080e-01, 3.1857370e-01, 4.3401910e-01, 3.3138080e-01, 2.4340070e-01, 5.2995460e-01,
 1.1574530e-01, 2.2163220e-01, 1.1100720e-01, 4.4413610e-01, 3.6997450e-01, 3.8347940e-01, 3.2275980e-01, 6.8706500e-01,
 3.4917320e-01, 4.2161590e-01, 4.6775830e-01, 4.6240630e-01, 8.2058530e-01, 7.1779050e-01, 6.1412730e-01, 8.2325240e-01,
 1.9219200e-01, 4.2161930e-01, 2.4598290e-01, 6.0593720e-01, 4.9784130e-01, 5.9117590e-01, 5.7958920e-01, 7.5962010e-01,
 1.2015600e-01, 1.5096210e-01, 1.6952750e-01, 1.3930820e-01, 4.6652840e-01, 4.2461790e-01, 3.6772810e-01, 4.0976570e-01,
 1.3266220e-01, 3.0281600e-01, 1.7882610e-01, 3.6617440e-01, 5.2760310e-01, 6.5189780e-01, 6.4692040e-01, 7.0479240e-01,
 3.8875150e-01, 5.3163640e-01, 4.1181430e-01, 6.9763700e-01, 6.8089960e-01, 6.7456450e-01, 4.0296420e-01, 9.2569270e-01,
 2.0044430e-01, 4.9801820e-01, 2.0286720e-01, 8.5636790e-01, 5.6708580e-01, 7.6267770e-01, 5.2206780e-01, 1.1725430e+00,
 3.7097390e-01, 4.2279380e-01, 2.5675850e-01, 5.1514170e-01, 5.8854530e-01, 4.8591810e-01, 2.2757020e-01, 6.1914110e-01,
 1.8700890e-01, 3.8721880e-01, 1.2366100e-01, 6.1823690e-01, 6.8817370e-01, 7.7131730e-01, 4.1393140e-01, 1.1010430e+00,
 6.9046460e-01, 9.0153420e-01, 6.3774140e-01, 7.8777870e-01, 1.1723530e+00, 1.1089120e+00, 6.0494480e-01, 1.0133220e+00,
 3.2715830e-01, 7.7608210e-01, 2.8870220e-01, 8.8864870e-01, 9.7562040e-01, 1.2527700e+00, 7.8312830e-01, 1.2825270e+00,
 1.8237700e-01, 2.4777490e-01, 1.7741380e-01, 1.8217190e-01, 5.1160760e-01, 5.0352600e-01, 2.7804070e-01, 3.8714570e-01,
 1.7333810e-01, 4.2784870e-01, 1.6110180e-01, 4.1220630e-01, 7.9363630e-01, 1.0603720e+00, 6.7094610e-01, 9.1338810e-01,
 6.1332700e-01, 9.0698340e-01, 4.4796490e-01, 9.4826440e-01, 7.7613500e-01, 8.3146190e-01, 3.1669650e-01, 9.0907760e-01,
 2.7222980e-01, 7.3139480e-01, 1.8996630e-01, 1.0020340e+00, 8.8666220e-01, 1.2894820e+00, 5.6280630e-01, 1.5794950e+00,
 4.7666860e-01, 7.3156400e-01, 4.5748240e-01, 8.7459380e-01, 1.0237930e+00, 1.1382720e+00, 5.4893920e-01, 1.4230770e+00,
 3.2869340e-01, 9.1650700e-01, 3.0139620e-01, 1.4357880e+00, 9.4831710e-01, 1.4313280e+00, 7.9097040e-01, 2.0047770e+00,
 8.4786700e-01, 1.4907990e+00, 1.0859440e+00, 1.2781950e+00, 1.9489650e+00, 2.4825220e+00, 1.3945610e+00, 2.2258690e+00,
 5.4954070e-01, 1.7554970e+00, 6.7246300e-01, 1.9723250e+00, 1.2848410e+00, 2.2217260e+00, 1.4301380e+00, 2.2317290e+00,
 1.9787350e-01, 3.6201400e-01, 2.6692020e-01, 2.6115920e-01, 7.5147350e-01, 9.9597660e-01, 5.6631940e-01, 7.5137660e-01,
 2.5725700e-01, 8.5509410e-01, 3.3155070e-01, 8.0834040e-01, 9.2346700e-01, 1.6615320e+00, 1.0825900e+00, 1.4043060e+00,
 8.5058100e-01, 1.6938440e+00, 8.6147760e-01, 1.7376390e+00, 1.4572030e+00, 2.1022080e+00, 8.2452230e-01, 2.2552270e+00,
 5.1643400e-01, 1.8684510e+00, 4.9972620e-01, 2.5117020e+00, 1.3187550e+00, 2.5826860e+00, 1.1607570e+00, 3.1040640e+00,
 1.5400550e-01, 2.0413410e-01, 1.0874680e-01, 1.9931120e-01, 2.8273130e-01, 2.7148830e-01, 1.1153430e-01, 2.7720160e-01,
 9.8801840e-02, 2.3793230e-01, 6.6655260e-02, 3.0441770e-01, 1.9082760e-01, 2.4875420e-01, 1.1710370e-01, 2.8455060e-01,
 5.7280450e-01, 8.6984390e-01, 5.3976980e-01, 6.0909000e-01, 1.1254460e+00, 1.2381050e+00, 5.9248970e-01, 9.0662140e-01,
 3.4540840e-01, 9.5296460e-01, 3.1097400e-01, 8.7441440e-01, 5.4062510e-01, 8.0738530e-01, 4.4273840e-01, 6.6235970e-01,
 1.3167430e-01, 2.0805690e-01, 1.3068240e-01, 1.2258130e-01, 4.2743380e-01, 4.8926920e-01, 2.3699500e-01, 3.0145230e-01,
 1.5927030e-01, 4.5721990e-01, 1.5102200e-01, 3.5299420e-01, 3.8273890e-01, 5.9474880e-01, 3.3011690e-01, 4.1053350e-01,
 6.8457520e-01, 1.1773960e+00, 5.1011960e-01, 9.8644000e-01, 1.0024610e+00, 1.2490120e+00, 4.1732310e-01, 1.0943170e+00,
 3.8670040e-01, 1.2083290e+00, 2.7530530e-01, 1.3265800e+00, 6.6105500e-01, 1.1181210e+00, 4.2809220e-01, 1.0975130e+00,
 2.9187390e-01, 4.0651880e-01, 2.6556730e-01, 3.9242680e-01, 8.5795660e-01, 8.6566240e-01, 4.3611280e-01, 8.7388660e-01,
 2.3498260e-01, 5.9460730e-01, 2.0426980e-01, 7.5215720e-01, 8.4719200e-01, 1.1604250e+00, 6.6990020e-01, 1.3124050e+00,
 5.6051150e-01, 8.9438690e-01, 6.8059020e-01, 6.1919500e-01, 1.7633360e+00, 2.0383270e+00, 1.1961630e+00, 1.4757220e+00,
 4.2415320e-01, 1.2296250e+00, 4.9205420e-01, 1.1155140e+00, 1.2392420e+00, 1.9446730e+00, 1.3076930e+00, 1.5773260e+00,
 1.6419700e-01, 2.7261660e-01, 2.0998120e-01, 1.5880210e-01, 8.5342520e-01, 1.0264800e+00, 6.0972610e-01, 6.2529220e-01,
 2.4923600e-01, 7.5180820e-01, 3.0451950e-01, 5.7386720e-01, 1.1180170e+00, 1.8255150e+00, 1.2425460e+00, 1.2458400e+00,
 5.7361110e-01, 1.0366330e+00, 5.5076640e-01, 8.5868720e-01, 1.3449190e+00, 1.7607650e+00, 7.2144000e-01, 1.5252470e+00,
 4.0661450e-01, 1.3350550e+00, 3.7301100e-01, 1.4491380e+00, 1.2975250e+00, 2.3060710e+00, 1.0827150e+00, 2.2379770e+00,
 1.1719380e-01, 1.1381170e-01, 8.0458070e-02, 1.4634200e-01, 1.4487290e-01, 1.0192190e-01, 5.5565620e-02, 1.3704960e-01,
 5.3803320e-02, 9.4929370e-02, 3.5290930e-02, 1.5994950e-01, 1.7774190e-01, 1.6975470e-01, 1.0604830e-01, 2.5572720e-01,
 2.1879700e-01, 2.4343290e-01, 2.0046020e-01, 2.2448390e-01, 2.8947050e-01, 2.3331360e-01, 1.4816480e-01, 2.2499590e-01,
 9.4415530e-02, 1.9084930e-01, 8.2645500e-02, 2.3061990e-01, 2.5276170e-01, 2.7656610e-01, 2.0125500e-01, 2.9879810e-01,
 6.4947530e-02, 7.5187730e-02, 6.2670550e-02, 5.8338460e-02, 1.4196310e-01, 1.1905770e-01, 7.6529760e-02, 9.6603760e-02,
 5.6217590e-02, 1.1824030e-01, 5.1827720e-02, 1.2021920e-01, 2.3107050e-01, 2.6307430e-01, 1.9377340e-01, 2.3914390e-01,
 1.8284740e-01, 2.3040580e-01, 1.3247210e-01, 2.5421860e-01, 1.8029350e-01, 1.6458200e-01, 7.2974230e-02, 1.8989990e-01,
 7.3912530e-02, 1.6921210e-01, 5.1161410e-02, 2.4465040e-01, 2.1611520e-01, 2.6781790e-01, 1.3607230e-01, 3.4619960e-01,
 3.3187970e-01, 4.3402390e-01, 3.1595270e-01, 5.4758510e-01, 5.5542110e-01, 5.2620290e-01, 2.9540500e-01, 6.9425610e-01,
 2.0842070e-01, 4.9520250e-01, 1.8957070e-01, 8.1869320e-01, 5.3981900e-01, 6.9427400e-01, 4.4662020e-01, 1.0262230e+00,
 5.9214840e-01, 8.8719500e-01, 7.5230460e-01, 8.0275140e-01, 1.0606030e+00, 1.1511690e+00, 7.5278330e-01, 1.0892550e+00,
 3.4953310e-01, 9.5144980e-01, 4.2426820e-01, 1.1281020e+00, 7.3363960e-01, 1.0809880e+00, 8.1001810e-01, 1.1459240e+00,
 1.5530420e-01, 2.4211290e-01, 2.0780710e-01, 1.8432400e-01, 4.5957350e-01, 5.1902430e-01, 3.4354720e-01, 4.1321890e-01,
 1.8388590e-01, 5.2082550e-01, 2.3507940e-01, 5.1958490e-01, 5.9258030e-01, 9.0851440e-01, 6.8908580e-01, 8.1034260e-01,
 5.5887590e-01, 9.4835380e-01, 5.6147090e-01, 1.0266920e+00, 7.4604610e-01, 9.1710380e-01, 4.1872760e-01, 1.0382860e+00,
 3.0902970e-01, 9.5271770e-01, 2.9662040e-01, 1.3515580e+00, 7.0842560e-01, 1.1822220e+00, 6.1852170e-01, 1.4994840e+00,
 9.8418860e-02, 1.1116160e-01, 6.8935400e-02, 1.1453940e-01, 1.4078680e-01, 1.1519570e-01, 5.5090920e-02, 1.2412660e-01,
 5.7503310e-02, 1.1799900e-01, 3.8480950e-02, 1.5932320e-01, 9.9704280e-02, 1.1074910e-01, 6.0691330e-02, 1.3369440e-01,
 3.6718690e-01, 4.7513750e-01, 3.4322030e-01, 3.5111020e-01, 5.6214880e-01, 5.2696440e-01, 2.9355610e-01, 4.0722440e-01,
 2.0165050e-01, 4.7406780e-01, 1.8008360e-01, 4.5905520e-01, 2.8333970e-01, 3.6056970e-01, 2.3016640e-01, 3.1216650e-01,
 9.4858080e-02, 1.2771820e-01, 9.3384370e-02, 7.9410660e-02, 2.3993200e-01, 2.3402620e-01, 1.3195990e-01, 1.5216650e-01,
 1.0449460e-01, 2.5561210e-01, 9.8283980e-02, 2.0826090e-01, 2.2542730e-01, 2.9849330e-01, 1.9286570e-01, 2.1743710e-01,
 4.1285620e-01, 6.0505860e-01, 3.0516400e-01, 5.3497010e-01, 4.7107610e-01, 5.0013530e-01, 1.9452690e-01, 4.6243220e-01,
 2.1239190e-01, 5.6551690e-01, 1.4998970e-01, 6.5520630e-01, 3.2594600e-01, 4.6977940e-01, 2.0937700e-01, 4.8663010e-01,
 2.5629020e-01, 3.0416880e-01, 2.3131030e-01, 3.0986790e-01, 5.8701360e-01, 5.0469450e-01, 2.9598190e-01, 5.3767400e-01,
 1.8791370e-01, 4.0518180e-01, 1.6203550e-01, 5.4089420e-01, 6.0820380e-01, 7.0987440e-01, 4.7704680e-01, 8.4725930e-01,
 4.9369660e-01, 6.7127150e-01, 5.9462730e-01, 4.9043800e-01, 1.2101990e+00, 1.1920450e+00, 8.1432060e-01, 9.1076650e-01,
 3.4023890e-01, 8.4048730e-01, 3.9152340e-01, 8.0466930e-01, 8.9240490e-01, 1.1933000e+00, 9.3410450e-01, 1.0214300e+00,
 1.6252990e-01, 2.2994170e-01, 2.0617310e-01, 1.4135320e-01, 6.5823280e-01, 6.7462410e-01, 4.6647940e-01, 4.3368880e-01,
 2.2468010e-01, 5.7750810e-01, 2.7230300e-01, 4.6520710e-01, 9.0478830e-01, 1.2588710e+00, 9.9745800e-01, 9.0665490e-01,
 4.7532430e-01, 7.3197220e-01, 4.5271350e-01, 6.3986530e-01, 8.6838970e-01, 9.6876190e-01, 4.6206400e-01, 8.8560390e-01,
 3.0686050e-01, 8.5852820e-01, 2.7923080e-01, 9.8344230e-01, 8.7905990e-01, 1.3312900e+00, 7.2761350e-01, 1.3634510e+00,
 4.4042620e-01, 4.5112700e-01, 3.6704020e-01, 6.0747700e-01, 7.2922100e-01, 5.4110640e-01, 3.3951100e-01, 7.6197770e-01,
 2.0516560e-01, 3.8180290e-01, 1.6335560e-01, 6.7370640e-01, 7.4624290e-01, 7.5171920e-01, 5.4046750e-01, 1.1859310e+00,
 7.9177990e-01, 9.2914960e-01, 8.8057580e-01, 8.9730620e-01, 1.4030430e+00, 1.1927520e+00, 8.7174080e-01, 1.2045740e+00,
 3.4668380e-01, 7.3913490e-01, 3.6837050e-01, 9.3536070e-01, 1.0218720e+00, 1.1793080e+00, 9.8765990e-01, 1.3343050e+00,
 2.2440720e-01, 2.7400870e-01, 2.6285310e-01, 2.2264930e-01, 6.5698130e-01, 5.8113680e-01, 4.2991590e-01, 4.9381460e-01,
 1.9709390e-01, 4.3722980e-01, 2.2056600e-01, 4.6555090e-01, 8.9194990e-01, 1.0710700e+00, 9.0795790e-01, 1.0196420e+00,
 6.8415380e-01, 9.0928780e-01, 6.0167880e-01, 1.0506650e+00, 9.0354200e-01, 8.6994910e-01, 4.4392890e-01, 1.0512000e+00,
 2.8061430e-01, 6.7758920e-01, 2.3578150e-01, 1.0259590e+00, 9.0338360e-01, 1.1807820e+00, 6.9044970e-01, 1.5984740e+00,
 5.1622310e-01, 7.1205520e-01, 5.9656030e-01, 9.4080720e-01, 1.1571310e+00, 1.1562630e+00, 7.4705690e-01, 1.5976150e+00,
 3.2894590e-01, 8.2434640e-01, 3.6318710e-01, 1.4272400e+00, 9.3805190e-01, 1.2724850e+00, 9.4209050e-01, 1.9697570e+00,
 8.8691490e-01, 1.4015660e+00, 1.3677940e+00, 1.3280810e+00, 2.1276860e+00, 2.4357750e+00, 1.8331600e+00, 2.4136630e+00,
 5.3121050e-01, 1.5251320e+00, 7.8269810e-01, 1.8937330e+00, 1.2275980e+00, 1.9078210e+00, 1.6452940e+00, 2.1179780e+00,
 2.2209840e-01, 3.6519390e-01, 3.6074320e-01, 2.9116320e-01, 8.8028010e-01, 1.0485680e+00, 7.9878110e-01, 8.7425530e-01,
 2.6683180e-01, 7.9712170e-01, 4.1407530e-01, 8.3279480e-01, 9.4674160e-01, 1.5309440e+00, 1.3363900e+00, 1.4300300e+00,
 8.6550280e-01, 1.5490540e+00, 1.0554940e+00, 1.7562470e+00, 1.5474700e+00, 2.0064040e+00, 1.0542990e+00, 2.3788430e+00,
 4.8560170e-01, 1.5790190e+00, 5.6579170e-01, 2.3458850e+00, 1.2256580e+00, 2.1573330e+00, 1.2989890e+00, 2.8655580e+00,
 2.2551060e-01, 2.6865000e-01, 1.9173730e-01, 2.8989180e-01, 4.3207010e-01, 3.7288240e-01, 2.0523330e-01, 4.2077450e-01,
 1.3369290e-01, 2.8935920e-01, 1.0860180e-01, 4.0915390e-01, 2.5522570e-01, 2.9901570e-01, 1.8858740e-01, 3.7802110e-01,
 8.1015950e-01, 1.1057220e+00, 9.1924600e-01, 8.5569480e-01, 1.6612620e+00, 1.6425220e+00, 1.0530610e+00, 1.3292690e+00,
 4.5144990e-01, 1.1194220e+00, 4.8939530e-01, 1.1351870e+00, 6.9841360e-01, 9.3742750e-01, 6.8868840e-01, 8.4993110e-01,
 1.9983360e-01, 2.8378550e-01, 2.3880530e-01, 1.8478440e-01, 6.7699580e-01, 6.9647480e-01, 4.5197600e-01, 4.7425180e-01,
 2.2336500e-01, 5.7629610e-01, 2.5502300e-01, 4.9172370e-01, 5.3054550e-01, 7.4095860e-01, 5.5099390e-01, 5.6525180e-01,
 9.4185450e-01, 1.4558800e+00, 8.4507210e-01, 1.3480520e+00, 1.4393940e+00, 1.6118300e+00, 7.2151210e-01, 1.5607340e+00,
 4.9164310e-01, 1.3807040e+00, 4.2145270e-01, 1.6752600e+00, 8.3071610e-01, 1.2628280e+00, 6.4775600e-01, 1.3699290e+00,
 3.9231370e-01, 4.9108790e-01, 4.2980550e-01, 5.2392630e-01, 1.2035190e+00, 1.0913820e+00, 7.3662360e-01, 1.2176320e+00,
 2.9186810e-01, 6.6377580e-01, 3.0550200e-01, 9.2796760e-01, 1.0400940e+00, 1.2804070e+00, 9.9028400e-01, 1.6004120e+00,
 7.2770620e-01, 1.0436080e+00, 1.0639380e+00, 7.9849520e-01, 2.3892200e+00, 2.4821910e+00, 1.9515090e+00, 1.9860890e+00,
 5.0887010e-01, 1.3258590e+00, 7.1081420e-01, 1.3293290e+00, 1.4695350e+00, 2.0725780e+00, 1.8671920e+00, 1.8578850e+00,
 2.2873900e-01, 3.4132480e-01, 3.5222040e-01, 2.1973780e-01, 1.2407660e+00, 1.3412680e+00, 1.0673780e+00, 9.0298580e-01,
 3.2084730e-01, 8.6983140e-01, 4.7202150e-01, 7.3379110e-01, 1.4225770e+00, 2.0876280e+00, 1.9037020e+00, 1.5745740e+00,
 7.2441540e-01, 1.1766180e+00, 8.3752270e-01, 1.0771560e+00, 1.7726210e+00, 2.0857460e+00, 1.1449300e+00, 1.9967930e+00,
 4.7453200e-01, 1.4003040e+00, 5.2415950e-01, 1.6798310e+00, 1.4967110e+00, 2.3907580e+00, 1.5038200e+00, 2.5641980e+00,
 4.3158990e-01, 3.7221320e-01, 3.2955820e-01, 7.1844670e-01, 6.5425980e-01, 4.0876010e-01, 2.7910350e-01, 8.2508730e-01,
 1.8756000e-01, 2.9387980e-01, 1.3683280e-01, 7.4331500e-01, 6.5696620e-01, 5.5720270e-01, 4.3596610e-01, 1.2600540e+00,
 8.3923350e-01, 8.2919900e-01, 8.5519550e-01, 1.1478510e+00, 1.3615770e+00, 9.7457670e-01, 7.7513780e-01, 1.4108190e+00,
 3.4280680e-01, 6.1536720e-01, 3.3374980e-01, 1.1162500e+00, 9.7305930e-01, 9.4550750e-01, 8.6172910e-01, 1.5334330e+00,
 2.8143230e-01, 2.8933190e-01, 3.0204430e-01, 3.3699620e-01, 7.5436770e-01, 5.6182790e-01, 4.5230770e-01, 6.8432210e-01,
 2.3059400e-01, 4.3070440e-01, 2.3644690e-01, 6.5736790e-01, 1.0049450e+00, 1.0160480e+00, 9.3732000e-01, 1.3864880e+00,
 9.3328290e-01, 1.0443730e+00, 7.5204640e-01, 1.7297790e+00, 1.1284980e+00, 9.1483150e-01, 5.0802640e-01, 1.5845450e+00,
 3.5711400e-01, 7.2603640e-01, 2.7493320e-01, 1.5757730e+00, 1.1071240e+00, 1.2183960e+00, 7.7531210e-01, 2.3642660e+00,
 3.8275350e-01, 4.4451890e-01, 4.0528120e-01, 8.4187770e-01, 7.8552010e-01, 6.6088540e-01, 4.6467430e-01, 1.3089210e+00,
 2.2753270e-01, 4.8009120e-01, 2.3018130e-01, 1.1914700e+00, 6.2484640e-01, 7.1366430e-01, 5.7498880e-01, 1.5835280e+00,
 7.1128530e-01, 9.4639050e-01, 1.0050850e+00, 1.2854440e+00, 1.5622930e+00, 1.5058680e+00, 1.2333190e+00, 2.1389380e+00,
 3.9743500e-01, 9.6073050e-01, 5.3655480e-01, 1.7099550e+00, 8.8446910e-01, 1.1573350e+00, 1.0861520e+00, 1.8416820e+00,
 2.1074930e-01, 2.9176900e-01, 3.1364570e-01, 3.3344470e-01, 7.6477660e-01, 7.6701750e-01, 6.3586040e-01, 9.1668170e-01,
 2.3620870e-01, 5.9412490e-01, 3.3585980e-01, 8.8973960e-01, 8.0708070e-01, 1.0988530e+00, 1.0438520e+00, 1.4712860e+00,
 8.9332940e-01, 1.3461850e+00, 9.9820410e-01, 2.1877390e+00, 1.4623740e+00, 1.5964270e+00, 9.1289360e-01, 2.7131170e+00,
 4.6758530e-01, 1.2801560e+00, 4.9918050e-01, 2.7261770e+00, 1.1365200e+00, 1.6843010e+00, 1.1036560e+00, 3.2068860e+00,
 2.0639050e-01, 2.0701620e-01, 1.6078650e-01, 3.2020280e-01, 3.6205100e-01, 2.6307660e-01, 1.5757370e-01, 4.2553140e-01,
 1.1414810e-01, 2.0801380e-01, 8.4960570e-02, 4.2161250e-01, 2.0985130e-01, 2.0700270e-01, 1.4207590e-01, 3.7511970e-01,
 8.0199810e-01, 9.2160200e-01, 8.3378660e-01, 1.0223230e+00, 1.5056840e+00, 1.2534350e+00, 8.7451960e-01, 1.4540360e+00,
 4.1691730e-01, 8.7042030e-01, 4.1411450e-01, 1.2652440e+00, 6.2112660e-01, 7.0193990e-01, 5.6119080e-01, 9.1225820e-01,
 2.3406160e-01, 2.7986380e-01, 2.5628660e-01, 2.6121230e-01, 7.2600650e-01, 6.2886120e-01, 4.4410980e-01, 6.1380470e-01,
 2.4406990e-01, 5.3020000e-01, 2.5532830e-01, 6.4846560e-01, 5.5827600e-01, 6.5647030e-01, 5.3124330e-01, 7.1785200e-01,
 1.1999630e+00, 1.5617250e+00, 9.8650250e-01, 2.0728000e+00, 1.6790230e+00, 1.5830360e+00, 7.7115370e-01, 2.1972140e+00,
 5.8434790e-01, 1.3817110e+00, 4.5897680e-01, 2.4030920e+00, 9.5082660e-01, 1.2169920e+00, 6.7932950e-01, 1.8924020e+00,
 3.1625970e-01, 3.3332230e-01, 3.1746990e-01, 5.0973820e-01, 8.8829310e-01, 6.7822650e-01, 4.9816040e-01, 1.0846410e+00,
 2.1950000e-01, 4.2030460e-01, 2.1051460e-01, 8.4226210e-01, 7.5326450e-01, 7.8076040e-01, 6.5713580e-01, 1.3988580e+00,
 6.3452190e-01, 7.6616570e-01, 8.5001620e-01, 8.4029060e-01, 1.9073900e+00, 1.6684510e+00, 1.4274940e+00, 1.9135900e+00,
 4.1393770e-01, 9.0807150e-01, 5.2979090e-01, 1.3050500e+00, 1.1511580e+00, 1.3669760e+00, 1.3401840e+00, 1.7564690e+00,
 2.3598780e-01, 2.9649130e-01, 3.3295400e-01, 2.7360290e-01, 1.1720130e+00, 1.0667250e+00, 9.2380670e-01, 1.0294130e+00,
 3.0880570e-01, 7.0488270e-01, 4.1626420e-01, 8.5236570e-01, 1.3185300e+00, 1.6291540e+00, 1.6167150e+00, 1.7613420e+00,
 8.1294180e-01, 1.1117370e+00, 8.6116970e-01, 1.4588710e+00, 1.8212960e+00, 1.8043510e+00, 1.0778640e+00, 2.4760780e+00,
 4.9679230e-01, 1.2343160e+00, 5.0279750e-01, 2.1224700e+00, 1.5089490e+00, 2.0293960e+00, 1.3891610e+00, 3.1200000e+00,
 5.5257390e-01, 6.2976080e-01, 3.8244750e-01, 7.6731500e-01, 1.1213390e+00, 9.2580640e-01, 4.3358340e-01, 1.1796330e+00,
 3.3014380e-01, 6.8359260e-01, 2.1830990e-01, 1.0914300e+00, 1.3043180e+00, 1.4619030e+00, 7.8453770e-01, 2.0868420e+00,
 1.1680380e+00, 1.5250980e+00, 1.0788470e+00, 1.3326610e+00, 2.5367870e+00, 2.3995100e+00, 1.3090050e+00, 2.1926700e+00,
 6.5594470e-01, 1.5560270e+00, 5.7884110e-01, 1.7817200e+00, 2.1000750e+00, 2.6966540e+00, 1.6857250e+00, 2.7607070e+00,
 3.3344480e-01, 4.5301350e-01, 3.2437050e-01, 3.3306970e-01, 1.1964670e+00, 1.1775680e+00, 6.5023800e-01, 9.0539570e-01,
 3.7561400e-01, 9.2712430e-01, 3.4909860e-01, 8.9322810e-01, 1.8463490e+00, 2.4668950e+00, 1.5609170e+00, 2.1249450e+00,
 1.1939580e+00, 1.7656170e+00, 8.7204930e-01, 1.8459780e+00, 1.9326110e+00, 2.0703770e+00, 7.8858840e-01, 2.2636440e+00,
 6.2809670e-01, 1.6874960e+00, 4.3829590e-01, 2.3119220e+00, 2.1963100e+00, 3.1941160e+00, 1.3941020e+00, 3.9124940e+00,
 6.8874400e-01, 1.0570450e+00, 6.6102160e-01, 1.2637110e+00, 1.8921850e+00, 2.1037650e+00, 1.0145550e+00, 2.6301460e+00,
 5.6289340e-01, 1.5695350e+00, 5.1614650e-01, 2.4588130e+00, 1.7435460e+00, 2.6315940e+00, 1.4542530e+00, 3.6859190e+00,
 1.3913530e+00, 2.4464070e+00, 1.7820380e+00, 2.0975230e+00, 4.0909460e+00, 5.2109020e+00, 2.9272340e+00, 4.6721790e+00,
 1.0688170e+00, 3.4143160e+00, 1.3078920e+00, 3.8360320e+00, 2.6828580e+00, 4.6391530e+00, 2.9862490e+00, 4.6600400e+00,
 3.5094240e-01, 6.4205680e-01, 4.7340140e-01, 4.6318390e-01, 1.7047940e+00, 2.2594740e+00, 1.2847530e+00, 1.7045740e+00,
 5.4076580e-01, 1.7974460e+00, 6.9693440e-01, 1.6991680e+00, 2.0840490e+00, 3.7496890e+00, 2.4431520e+00, 3.1691900e+00,
 1.6062270e+00, 3.1986360e+00, 1.6268040e+00, 3.2813370e+00, 3.5198280e+00, 5.0778170e+00, 1.9916080e+00, 5.4474300e+00,
 1.1558460e+00, 4.1818340e+00, 1.1184520e+00, 5.6215140e+00, 3.1687930e+00, 6.2058510e+00, 2.7891440e+00, 7.4586520e+00,
 3.4444110e-01, 4.5655630e-01, 2.4321780e-01, 4.4576960e-01, 8.0884020e-01, 7.7667610e-01, 3.1907830e-01, 7.9302090e-01,
 2.6190130e-01, 6.3070470e-01, 1.7668800e-01, 8.0694250e-01, 5.4307330e-01, 7.0792540e-01, 3.3326340e-01, 8.0979780e-01,
 1.4549680e+00, 2.2094720e+00, 1.3710580e+00, 1.5471360e+00, 3.6566370e+00, 4.0226710e+00, 1.9250330e+00, 2.9456640e+00,
 1.0398580e+00, 2.8689160e+00, 9.3619230e-01, 2.6324390e+00, 1.7473580e+00, 2.6095550e+00, 1.4309770e+00, 2.1408170e+00,
 3.6148180e-01, 5.7117310e-01, 3.5875900e-01, 3.3651920e-01, 1.5009440e+00, 1.7180810e+00, 8.3221370e-01, 1.0585570e+00,
 5.1822010e-01, 1.4876630e+00, 4.9138230e-01, 1.1485420e+00, 1.3369850e+00, 2.0775790e+00, 1.1531660e+00, 1.4340770e+00,
 2.0010130e+00, 3.4415280e+00, 1.4910790e+00, 2.8833640e+00, 3.7480580e+00, 4.6698770e+00, 1.5603110e+00, 4.0914960e+00,
 1.3396680e+00, 4.1860810e+00, 9.5375570e-01, 4.5957480e+00, 2.4586960e+00, 4.1586830e+00, 1.5922250e+00, 4.0820370e+00,
 4.0998950e-01, 5.7102900e-01, 3.7303720e-01, 5.5123420e-01, 1.5415340e+00, 1.5553790e+00, 7.8358570e-01, 1.5701560e+00,
 3.9120760e-01, 9.8992360e-01, 3.4007570e-01, 1.2522180e+00, 1.5142510e+00, 2.0741160e+00, 1.1973640e+00, 2.3457620e+00,
 8.9419150e-01, 1.4268270e+00, 1.0857550e+00, 9.8781010e-01, 3.5982490e+00, 4.1593930e+00, 2.4408800e+00, 3.0113450e+00,
 8.0197840e-01, 2.3249450e+00, 9.3036380e-01, 2.1091870e+00, 2.5155930e+00, 3.9475800e+00, 2.6545470e+00, 3.2018870e+00,
 2.8310630e-01, 4.7004210e-01, 3.6204690e-01, 2.7380460e-01, 1.8821750e+00, 2.2638360e+00, 1.3447120e+00, 1.3790420e+00,
 5.0931810e-01, 1.5363330e+00, 6.2229080e-01, 1.1727080e+00, 2.4528510e+00, 4.0050530e+00, 2.7260600e+00, 2.7332860e+00,
 1.0530410e+00, 1.9030600e+00, 1.0111020e+00, 1.5763860e+00, 3.1581590e+00, 4.1346540e+00, 1.6940960e+00, 3.5816050e+00,
 8.8471690e-01, 2.9048300e+00, 8.1160210e-01, 3.1530520e+00, 3.0309700e+00, 5.3868980e+00, 2.5291830e+00, 5.2278330e+00,
 2.6619660e-01, 2.5851450e-01, 1.8275420e-01, 3.3240450e-01, 4.2091560e-01, 2.9612520e-01, 1.6144110e-01, 3.9818590e-01,
 1.4484410e-01, 2.5555970e-01, 9.5006830e-02, 4.3060070e-01, 5.1371940e-01, 4.9063460e-01, 3.0650660e-01, 7.3911690e-01,
 5.6442680e-01, 6.2797970e-01, 5.1712360e-01, 5.7909730e-01, 9.5517000e-01, 7.6986840e-01, 4.8890170e-01, 7.4242230e-01,
 2.8867130e-01, 5.8351310e-01, 2.5268490e-01, 7.0511020e-01, 8.2969010e-01, 9.0782810e-01, 6.6061960e-01, 9.8080470e-01,
 1.8107870e-01, 2.0962920e-01, 1.7473030e-01, 1.6265210e-01, 5.0627930e-01, 4.2459250e-01, 2.7292610e-01, 3.4451550e-01,
 1.8576800e-01, 3.9071870e-01, 1.7126190e-01, 3.9725790e-01, 8.1976160e-01, 9.3330070e-01, 6.8744390e-01, 8.4840360e-01,
 5.4279610e-01, 6.8397660e-01, 3.9325320e-01, 7.5466670e-01, 6.8460160e-01, 6.2494280e-01, 2.7709420e-01, 7.2107890e-01,
 2.6005180e-01, 5.9535130e-01, 1.8000490e-01, 8.6077110e-01, 8.1634120e-01, 1.0116400e+00, 5.1399160e-01, 1.3077140e+00,
 7.3126160e-01, 9.5632570e-01, 6.9616820e-01, 1.2065460e+00, 1.5653970e+00, 1.4830490e+00, 8.3256870e-01, 1.9566900e+00,
 5.4428560e-01, 1.2932090e+00, 4.9505930e-01, 2.1379980e+00, 1.5134870e+00, 1.9465320e+00, 1.2521860e+00, 2.8772150e+00,
 1.4818050e+00, 2.2201360e+00, 1.8825840e+00, 2.0088230e+00, 3.3948720e+00, 3.6847640e+00, 2.4095760e+00, 3.4865850e+00,
 1.0366750e+00, 2.8218910e+00, 1.2583310e+00, 3.3458210e+00, 2.3360480e+00, 3.4420720e+00, 2.5792520e+00, 3.6488410e+00,
 4.2003170e-01, 6.5481250e-01, 5.6202980e-01, 4.9851800e-01, 1.5898790e+00, 1.7955470e+00, 1.1884900e+00, 1.4295170e+00,
 5.8944210e-01, 1.6694950e+00, 7.5354190e-01, 1.6655180e+00, 2.0393160e+00, 3.1265770e+00, 2.3714320e+00, 2.7887270e+00,
 1.6093760e+00, 2.7309420e+00, 1.6168490e+00, 2.9565310e+00, 2.7480070e+00, 3.3780860e+00, 1.5423530e+00, 3.8244520e+00,
 1.0547180e+00, 3.2516230e+00, 1.0123650e+00, 4.6128640e+00, 2.5958210e+00, 4.3319110e+00, 2.2663940e+00, 5.4944280e+00,
 3.3566640e-01, 3.7912680e-01, 2.3511040e-01, 3.9064710e-01, 6.1418840e-01, 5.0254630e-01, 2.4033650e-01, 5.4150770e-01,
 2.3244290e-01, 4.7698190e-01, 1.5554970e-01, 6.4402450e-01, 4.3269490e-01, 4.8062700e-01, 2.6338720e-01, 5.8020460e-01,
 1.4222800e+00, 1.8404220e+00, 1.3294470e+00, 1.3600080e+00, 2.7852190e+00, 2.6108950e+00, 1.4544510e+00, 2.0176320e+00,
 9.2574470e-01, 2.1763680e+00, 8.2673430e-01, 2.1074480e+00, 1.3965090e+00, 1.7771570e+00, 1.1344320e+00, 1.5385890e+00,
 3.9710990e-01, 5.3467420e-01, 3.9094040e-01, 3.3244150e-01, 1.2847970e+00, 1.2531730e+00, 7.0662440e-01, 8.1482720e-01,
 5.1847070e-01, 1.2682700e+00, 4.8765540e-01, 1.0333280e+00, 1.2008290e+00, 1.5900450e+00, 1.0273770e+00, 1.1582660e+00,
 1.8402570e+00, 2.6969760e+00, 1.3602320e+00, 2.3845650e+00, 2.6858440e+00, 2.8515250e+00, 1.1090960e+00, 2.6365610e+00,
 1.1220480e+00, 2.9875770e+00, 7.9238260e-01, 3.4613980e+00, 1.8486880e+00, 2.6644770e+00, 1.1875370e+00, 2.7600500e+00,
 5.4898500e-01, 6.5154300e-01, 4.9547700e-01, 6.6375080e-01, 1.6083730e+00, 1.3828250e+00, 8.1096800e-01, 1.4731860e+00,
 4.7706840e-01, 1.0286610e+00, 4.1137000e-01, 1.3732030e+00, 1.6577380e+00, 1.9348550e+00, 1.3002530e+00, 2.3093150e+00,
 1.2010390e+00, 1.6330330e+00, 1.4465770e+00, 1.1931110e+00, 3.7658550e+00, 3.7093650e+00, 2.5339750e+00, 2.8340920e+00,
 9.8101300e-01, 2.4233820e+00, 1.1288820e+00, 2.3201080e+00, 2.7624680e+00, 3.6938990e+00, 2.8915500e+00, 3.1618690e+00,
 4.2733510e-01, 6.0457890e-01, 5.4208500e-01, 3.7165580e-01, 2.2137310e+00, 2.2688570e+00, 1.5688370e+00, 1.4585580e+00,
 7.0015430e-01, 1.7996470e+00, 8.4855810e-01, 1.4496910e+00, 3.0270570e+00, 4.2116750e+00, 3.3370930e+00, 3.0333020e+00,
 1.3306640e+00, 2.0491470e+00, 1.2673650e+00, 1.7912940e+00, 3.1095900e+00, 3.4690100e+00, 1.6545910e+00, 3.1712320e+00,
 1.0181540e+00, 2.8485700e+00, 9.2647920e-01, 3.2630310e+00, 3.1313770e+00, 4.7423070e+00, 2.5918960e+00, 4.8568710e+00,
 6.6131000e-01, 6.7737750e-01, 5.5111930e-01, 9.1214060e-01, 1.4005590e+00, 1.0392610e+00, 6.5207250e-01, 1.4634720e+00,
 3.6511560e-01, 6.7946190e-01, 2.9071000e-01, 1.1989370e+00, 1.4257740e+00, 1.4362370e+00, 1.0326190e+00, 2.2658440e+00,
 1.3502210e+00, 1.5844770e+00, 1.5016450e+00, 1.5301750e+00, 3.0604230e+00, 2.6017200e+00, 1.9015070e+00, 2.6275080e+00,
 7.0069310e-01, 1.4938880e+00, 7.4452460e-01, 1.8904860e+00, 2.2173540e+00, 2.5589750e+00, 2.1431190e+00, 2.8953030e+00,
 4.1359530e-01, 5.0501360e-01, 4.8445330e-01, 4.1035530e-01, 1.5488240e+00, 1.3700210e+00, 1.0135200e+00, 1.1641600e+00,
 4.3053250e-01, 9.5508600e-01, 4.8180500e-01, 1.0169510e+00, 2.0917880e+00, 2.5118570e+00, 2.1293300e+00, 2.3912490e+00,
 1.3425660e+00, 1.7843640e+00, 1.1807190e+00, 2.0617990e+00, 2.2679860e+00, 2.1836650e+00, 1.1143090e+00, 2.6386240e+00,
 6.5265810e-01, 1.5759500e+00, 5.4838520e-01, 2.3861940e+00, 2.2557590e+00, 2.9484240e+00, 1.7240600e+00, 3.9914070e+00,
 7.5190620e-01, 1.0371460e+00, 8.6892160e-01, 1.3703350e+00, 2.1558520e+00, 2.1542350e+00, 1.3918420e+00, 2.9765190e+00,
 5.6786440e-01, 1.4230820e+00, 6.2697550e-01, 2.4638670e+00, 1.7385670e+00, 2.3584000e+00, 1.7460520e+00, 3.6507110e+00,
 1.4671570e+00, 2.3185060e+00, 2.2626390e+00, 2.1969460e+00, 4.5020720e+00, 5.1539710e+00, 3.8788690e+00, 5.1071840e+00,
 1.0414900e+00, 2.9901700e+00, 1.5345560e+00, 3.7128490e+00, 2.5839800e+00, 4.0157860e+00, 3.4631930e+00, 4.4581490e+00,
 3.9708050e-01, 6.5291490e-01, 6.4495780e-01, 5.2055850e-01, 2.0130940e+00, 2.3979490e+00, 1.8267160e+00, 1.9993160e+00,
 5.6541140e-01, 1.6890850e+00, 8.7741750e-01, 1.7646760e+00, 2.1537880e+00, 3.4828180e+00, 3.0402170e+00, 3.2532440e+00,
 1.6475730e+00, 2.9487840e+00, 2.0092410e+00, 3.3431970e+00, 3.7679800e+00, 4.8854510e+00, 2.5671430e+00, 5.7923150e+00,
 1.0955960e+00, 3.5625220e+00, 1.2765170e+00, 5.2926960e+00, 2.9688210e+00, 5.2255480e+00, 3.1464450e+00, 6.9410280e+00,
 5.0842950e-01, 6.0569010e-01, 4.3228510e-01, 6.5358130e-01, 1.2460290e+00, 1.0753400e+00, 5.9186360e-01, 1.2134540e+00,
 3.5724490e-01, 7.7320530e-01, 2.9019810e-01, 1.0933120e+00, 7.3219470e-01, 8.5781980e-01, 5.4102200e-01, 1.0844710e+00,
 2.0744480e+00, 2.8312480e+00, 2.3537690e+00, 2.1910430e+00, 5.4410210e+00, 5.3796430e+00, 3.4490200e+00, 4.3536660e+00,
 1.3700470e+00, 3.3971900e+00, 1.4852030e+00, 3.4450330e+00, 2.2755330e+00, 3.0542760e+00, 2.2438470e+00, 2.7691990e+00,
 5.5301780e-01, 7.8534540e-01, 6.6086760e-01, 5.1137060e-01, 2.3964400e+00, 2.4653920e+00, 1.5999120e+00, 1.6787640e+00,
 7.3262120e-01, 1.8902100e+00, 8.3645740e-01, 1.6128190e+00, 1.8682350e+00, 2.6091730e+00, 1.9402410e+00, 1.9904480e+00,
 2.7752210e+00, 4.2898220e+00, 2.4900470e+00, 3.9721020e+00, 5.4250460e+00, 6.0749540e+00, 2.7193650e+00, 5.8823740e+00,
 1.7169490e+00, 4.8217900e+00, 1.4718260e+00, 5.8504570e+00, 3.1146180e+00, 4.7347410e+00, 2.4286420e+00, 5.1362990e+00,
 5.5551530e-01, 6.9537930e-01, 6.0860350e-01, 7.4187840e-01, 2.1798450e+00, 1.9767390e+00, 1.3341920e+00, 2.2054070e+00,
 4.8982740e-01, 1.1139810e+00, 5.1270850e-01, 1.5573610e+00, 1.8740170e+00, 2.3070070e+00, 1.7842710e+00, 2.8835860e+00,
 1.1702730e+00, 1.6782950e+00, 1.7109890e+00, 1.2841130e+00, 4.9147020e+00, 5.1059470e+00, 4.0143160e+00, 4.0854490e+00,
 9.6991070e-01, 2.5270980e+00, 1.3548180e+00, 2.5337130e+00, 3.0071090e+00, 4.2411170e+00, 3.8208350e+00, 3.8017900e+00,
 3.9756630e-01, 5.9324920e-01, 6.1218670e-01, 3.8192150e-01, 2.7584780e+00, 2.9819130e+00, 2.3730010e+00, 2.0075220e+00,
 6.6093950e-01, 1.7918360e+00, 9.7235540e-01, 1.5115960e+00, 3.1461810e+00, 4.6170120e+00, 4.2102400e+00, 3.4823380e+00,
 1.3406030e+00, 2.1774490e+00, 1.5499200e+00, 1.9933840e+00, 4.1960290e+00, 4.9372390e+00, 2.7102010e+00, 4.7266740e+00,
 1.0408110e+00, 3.0713460e+00, 1.1496610e+00, 3.6844450e+00, 3.5244310e+00, 5.6297170e+00, 3.5411700e+00, 6.0381300e+00,
 7.4209560e-02, 6.4000050e-02, 5.6665760e-02, 1.2353300e-01, 1.0363710e-01, 6.4749040e-02, 4.4210970e-02, 1.3069670e-01,
 2.9974960e-02, 4.6966490e-02, 2.1867970e-02, 1.1879310e-01, 8.9786370e-02, 7.6151870e-02, 5.9582690e-02, 1.7220920e-01,
 1.3778110e-01, 1.3613370e-01, 1.4040170e-01, 1.8844840e-01, 2.0593270e-01, 1.4740060e-01, 1.1723630e-01, 2.1338040e-01,
 5.2310160e-02, 9.3901180e-02, 5.0928120e-02, 1.7033280e-01, 1.2697700e-01, 1.2338170e-01, 1.1244920e-01, 2.0010150e-01,
 5.0563980e-02, 5.1983270e-02, 5.4267280e-02, 6.0546970e-02, 1.2486100e-01, 9.2992270e-02, 7.4864780e-02, 1.1326720e-01,
 3.8507480e-02, 7.1924440e-02, 3.9484880e-02, 1.0977560e-01, 1.4351210e-01, 1.4509770e-01, 1.3385480e-01, 1.9799870e-01,
 1.3679040e-01, 1.5307280e-01, 1.1022680e-01, 2.5353210e-01, 1.5237700e-01, 1.2352640e-01, 6.8596970e-02, 2.1395530e-01,
 4.8649590e-02, 9.8907820e-02, 3.7454110e-02, 2.1466730e-01, 1.2897860e-01, 1.4194160e-01, 9.0322880e-02, 2.7543400e-01,
 9.0655860e-02, 1.0528510e-01, 9.5991580e-02, 1.9940020e-01, 1.7139980e-01, 1.4420460e-01, 1.0139150e-01, 2.8560540e-01,
 5.0089910e-02, 1.0568910e-01, 5.0672990e-02, 2.6229470e-01, 1.1763290e-01, 1.3435360e-01, 1.0824670e-01, 2.9811320e-01,
 1.6085660e-01, 2.1402540e-01, 2.2729920e-01, 2.9070210e-01, 3.2548700e-01, 3.1373140e-01, 2.5694890e-01, 4.4562480e-01,
 8.3539310e-02, 2.0194190e-01, 1.1278180e-01, 3.5942610e-01, 1.5898510e-01, 2.0803320e-01, 1.9523800e-01, 3.3104610e-01,
 5.2158090e-02, 7.2209530e-02, 7.7623780e-02, 8.2523810e-02, 1.7436780e-01, 1.7487870e-01, 1.4497510e-01, 2.0900190e-01,
 5.4335180e-02, 1.3666680e-01, 7.7257960e-02, 2.0466720e-01, 1.5876370e-01, 2.1615920e-01, 2.0533980e-01, 2.8942190e-01,
 1.8036080e-01, 2.7179100e-01, 2.0153470e-01, 4.4169850e-01, 2.7199760e-01, 2.9693120e-01, 1.6979580e-01, 5.0463250e-01,
 8.7744760e-02, 2.4022780e-01, 9.3673750e-02, 5.1158100e-01, 1.8238390e-01, 2.7028940e-01, 1.7710990e-01, 5.1462730e-01,
 4.3298020e-02, 4.3429280e-02, 3.3730900e-02, 6.7174360e-02, 6.9972010e-02, 5.0843660e-02, 3.0453580e-02, 8.2240590e-02,
 2.2257520e-02, 4.0560230e-02, 1.6566310e-02, 8.2209450e-02, 3.4992010e-02, 3.4517020e-02, 2.3690680e-02, 6.2549970e-02,
 1.6064600e-01, 1.8460360e-01, 1.6701350e-01, 2.0477880e-01, 2.7784770e-01, 2.3129950e-01, 1.6137730e-01, 2.6831700e-01,
 7.7620500e-02, 1.6205240e-01, 7.7098690e-02, 2.3555960e-01, 9.8890740e-02, 1.1175720e-01, 8.9348250e-02, 1.4524240e-01,
 5.1308280e-02, 6.1348490e-02, 5.6180180e-02, 5.7259920e-02, 1.4661350e-01, 1.2699550e-01, 8.9685810e-02, 1.2395490e-01,
 4.9728030e-02, 1.0802560e-01, 5.2021870e-02, 1.3212160e-01, 9.7271340e-02, 1.1438030e-01, 9.2561300e-02, 1.2507510e-01,
 2.1458540e-01, 2.7927800e-01, 1.7641290e-01, 3.7067180e-01, 2.7660820e-01, 2.6079510e-01, 1.2704260e-01, 3.6197690e-01,
 9.7125560e-02, 2.2965670e-01, 7.6287410e-02, 3.9942240e-01, 1.3514890e-01, 1.7298110e-01, 9.6558720e-02, 2.6898280e-01,
 5.3027920e-02, 5.5888860e-02, 5.3230860e-02, 8.5468880e-02, 1.3721240e-01, 1.0476390e-01, 7.6949590e-02, 1.6754180e-01,
 3.4207800e-02, 6.5502030e-02, 3.2807490e-02, 1.3126170e-01, 1.0038920e-01, 1.0405370e-01, 8.7577940e-02, 1.8642890e-01,
 1.0158410e-01, 1.2265970e-01, 1.3608380e-01, 1.3452670e-01, 2.8131630e-01, 2.4607580e-01, 2.1053760e-01, 2.8223060e-01,
 6.1594780e-02, 1.3512290e-01, 7.8833980e-02, 1.9419420e-01, 1.4648490e-01, 1.7394770e-01, 1.7053850e-01, 2.2351080e-01,
 4.1345590e-02, 5.1945940e-02, 5.8334280e-02, 4.7935840e-02, 1.8916820e-01, 1.7217430e-01, 1.4910660e-01, 1.6615200e-01,
 5.0286890e-02, 1.1478530e-01, 6.7785760e-02, 1.3880190e-01, 1.8361500e-01, 2.2687180e-01, 2.2513950e-01, 2.4528000e-01,
 1.1619140e-01, 1.5889740e-01, 1.2308450e-01, 2.0851220e-01, 2.3981230e-01, 2.3758110e-01, 1.4192370e-01, 3.2602820e-01,
 6.5996260e-02, 1.6397250e-01, 6.6794020e-02, 2.8195910e-01, 1.7142250e-01, 2.3054740e-01, 1.5781420e-01, 3.5444430e-01,
 3.1718150e-01, 3.6148740e-01, 2.1952770e-01, 4.4044450e-01, 5.9296740e-01, 4.8956900e-01, 2.2928010e-01, 6.2379300e-01,
 1.7613690e-01, 3.6470750e-01, 1.1647180e-01, 5.8229520e-01, 5.9508610e-01, 6.6698310e-01, 3.5793990e-01, 9.5210720e-01,
 6.4016610e-01, 8.3585980e-01, 5.9128360e-01, 7.3039120e-01, 1.2808430e+00, 1.2115310e+00, 6.6092680e-01, 1.1070960e+00,
 3.3414340e-01, 7.9265220e-01, 2.9486620e-01, 9.0762210e-01, 9.1484880e-01, 1.1747350e+00, 7.3434710e-01, 1.2026380e+00,
 1.9999550e-01, 2.7171110e-01, 1.9455290e-01, 1.9977050e-01, 6.6110950e-01, 6.5066640e-01, 3.5928980e-01, 5.0027750e-01,
 2.0939580e-01, 5.1684950e-01, 1.9461410e-01, 4.9795310e-01, 8.8021520e-01, 1.1760500e+00, 7.4414060e-01, 1.0130310e+00,
 5.8419860e-01, 8.6390850e-01, 4.2668990e-01, 9.0322890e-01, 8.7114810e-01, 9.3324800e-01, 3.5546590e-01, 1.0203650e+00,
 2.8564570e-01, 7.6743920e-01, 1.9932810e-01, 1.0514160e+00, 8.5416900e-01, 1.2422260e+00, 5.4218130e-01, 1.5216120e+00,
 5.4458220e-01, 8.3579400e-01, 5.2266240e-01, 9.9920200e-01, 1.3783060e+00, 1.5324250e+00, 7.3902220e-01, 1.9158510e+00,
 4.1367720e-01, 1.1534700e+00, 3.7932230e-01, 1.8070110e+00, 1.0957660e+00, 1.6538770e+00, 9.1395400e-01, 2.3164890e+00,
 1.0504160e+00, 1.8469390e+00, 1.3453670e+00, 1.5835460e+00, 2.8452730e+00, 3.6242070e+00, 2.0359050e+00, 3.2495230e+00,
 7.4999290e-01, 2.3958380e+00, 9.1775280e-01, 2.6917570e+00, 1.6099050e+00, 2.7838210e+00, 1.7919620e+00, 2.7963550e+00,
 2.8994800e-01, 5.3046640e-01, 3.9112350e-01, 3.8268180e-01, 1.2975750e+00, 1.7197610e+00, 9.7786810e-01, 1.2974080e+00,
 4.1526320e-01, 1.3802890e+00, 5.3518770e-01, 1.3048200e+00, 1.3685830e+00, 2.4623990e+00, 1.6044040e+00, 2.0811880e+00,
 1.0825960e+00, 2.1558780e+00, 1.0964650e+00, 2.2116190e+00, 2.1855320e+00, 3.1529180e+00, 1.2366290e+00, 3.3824180e+00,
 7.2408460e-01, 2.6197270e+00, 7.0065880e-01, 3.5216200e+00, 1.6975870e+00, 3.3246010e+00, 1.4942020e+00, 3.9957530e+00,
 2.4122500e-01, 3.1974350e-01, 1.7033450e-01, 3.1218920e-01, 5.2185080e-01, 5.0109900e-01, 2.0586420e-01, 5.1164440e-01,
 1.7048050e-01, 4.1054730e-01, 1.1501230e-01, 5.2526660e-01, 3.0230450e-01, 3.9407030e-01, 1.8551280e-01, 4.5077800e-01,
 9.7292470e-01, 1.4774540e+00, 9.1681430e-01, 1.0345570e+00, 2.2525980e+00, 2.4780860e+00, 1.1858780e+00, 1.8146180e+00,
 6.4629290e-01, 1.7830900e+00, 5.8186270e-01, 1.6361150e+00, 9.2872300e-01, 1.3869820e+00, 7.6056650e-01, 1.1378470e+00,
 2.6452860e-01, 4.1797840e-01, 2.6253600e-01, 2.4626120e-01, 1.0118750e+00, 1.1582600e+00, 5.6104440e-01, 7.1363570e-01,
 3.5247650e-01, 1.0118600e+00, 3.3422240e-01, 7.8120130e-01, 7.7766310e-01, 1.2084330e+00, 6.7074370e-01, 8.3413720e-01,
 1.1945690e+00, 2.0545300e+00, 8.9014750e-01, 1.7213160e+00, 2.0613120e+00, 2.5682830e+00, 8.5812130e-01, 2.2501920e+00,
 7.4334140e-01, 2.3227300e+00, 5.2921020e-01, 2.5500410e+00, 1.1666610e+00, 1.9733120e+00, 7.5551730e-01, 1.9369430e+00,
 2.2948940e-01, 3.1963030e-01, 2.0880550e-01, 3.0855030e-01, 7.9491190e-01, 8.0205150e-01, 4.0406620e-01, 8.0967140e-01,
 2.0352930e-01, 5.1501670e-01, 1.7692750e-01, 6.5147790e-01, 6.7369980e-01, 9.2278710e-01, 5.3271470e-01, 1.0436440e+00,
 4.7790170e-01, 7.6256960e-01, 5.8028290e-01, 5.2793630e-01, 1.7716400e+00, 2.0479260e+00, 1.2017960e+00, 1.4826710e+00,
 3.9838280e-01, 1.1549160e+00, 4.6215820e-01, 1.0477380e+00, 1.0686300e+00, 1.6769410e+00, 1.1276570e+00, 1.3601690e+00,
 1.6558390e-01, 2.7491930e-01, 2.1175480e-01, 1.6014350e-01, 1.0141560e+00, 1.2198030e+00, 7.2455960e-01, 7.4305730e-01,
 2.7687740e-01, 8.3518700e-01, 3.3829200e-01, 6.3751160e-01, 1.1402990e+00, 1.8618960e+00, 1.2673090e+00, 1.2706690e+00,
 5.0244530e-01, 9.0802150e-01, 4.8243480e-01, 7.5215300e-01, 1.3882060e+00, 1.8174360e+00, 7.4465960e-01, 1.5743370e+00,
 3.9235370e-01, 1.2882320e+00, 3.5992880e-01, 1.3983140e+00, 1.1494870e+00, 2.0429660e+00, 9.5918570e-01, 1.9826410e+00,
 1.2218980e-01, 1.1866360e-01, 8.3888040e-02, 1.5258070e-01, 1.7799340e-01, 1.2522300e-01, 6.8268920e-02, 1.6838160e-01,
 6.1796410e-02, 1.0903220e-01, 4.0533800e-02, 1.8371180e-01, 1.8742930e-01, 1.7900680e-01, 1.1182820e-01, 2.6966500e-01,
 2.4737650e-01, 2.7523050e-01, 2.2664450e-01, 2.5380630e-01, 3.8566290e-01, 3.1084480e-01, 1.9740070e-01, 2.9976310e-01,
 1.1759380e-01, 2.3770120e-01, 1.0293430e-01, 2.8723520e-01, 2.8903180e-01, 3.1625200e-01, 2.3013420e-01, 3.4167420e-01,
 8.6851780e-02, 1.0054560e-01, 8.3806870e-02, 7.8013720e-02, 2.2370610e-01, 1.8761170e-01, 1.2059600e-01, 1.5222870e-01,
 8.2815580e-02, 1.7418280e-01, 7.6348740e-02, 1.7709800e-01, 3.1251990e-01, 3.5580480e-01, 2.6207610e-01, 3.2343920e-01,
 2.1238470e-01, 2.6762560e-01, 1.5387170e-01, 2.9528520e-01, 2.4677470e-01, 2.2526980e-01, 9.9882680e-02, 2.5992340e-01,
 9.4574950e-02, 2.1651580e-01, 6.5463700e-02, 3.1304300e-01, 2.5388490e-01, 3.1462350e-01, 1.5985320e-01, 4.0670360e-01,
 4.6237410e-01, 6.0468130e-01, 4.4018470e-01, 7.6289450e-01, 9.1184610e-01, 8.6387800e-01, 4.8497240e-01, 1.1397740e+00,
 3.1987280e-01, 7.6001020e-01, 2.9094290e-01, 1.2564860e+00, 7.6063830e-01, 9.7827490e-01, 6.2931550e-01, 1.4460120e+00,
 8.9460250e-01, 1.3403510e+00, 1.1365620e+00, 1.2127760e+00, 1.8881590e+00, 2.0493920e+00, 1.3401580e+00, 1.9391680e+00,
 5.8171680e-01, 1.5834670e+00, 7.0609600e-01, 1.8774630e+00, 1.1209840e+00, 1.6517250e+00, 1.2376890e+00, 1.7509460e+00,
 2.7751190e-01, 4.3262980e-01, 3.7132890e-01, 3.2936720e-01, 9.6769780e-01, 1.0928800e+00, 7.2338770e-01, 8.7009150e-01,
 3.6196820e-01, 1.0252140e+00, 4.6273970e-01, 1.0227720e+00, 1.0709340e+00, 1.6419030e+00, 1.2453430e+00, 1.4644830e+00,
 8.6742530e-01, 1.4719300e+00, 8.7145290e-01, 1.5935180e+00, 1.3644850e+00, 1.6773420e+00, 7.6583400e-01, 1.8989780e+00,
 5.2837300e-01, 1.6289380e+00, 5.0715590e-01, 2.3108670e+00, 1.1120600e+00, 1.8558070e+00, 9.7093200e-01, 2.3538340e+00,
 1.8798810e-01, 2.1232790e-01, 1.3167230e-01, 2.1877970e-01, 3.1688400e-01, 2.5928340e-01, 1.2399910e-01, 2.7938520e-01,
 1.2099530e-01, 2.4828710e-01, 8.0969520e-02, 3.3523910e-01, 1.9261190e-01, 2.1394860e-01, 1.1724540e-01, 2.5827500e-01,
 7.6054680e-01, 9.8414270e-01, 7.1090520e-01, 7.2724730e-01, 1.3720700e+00, 1.2861940e+00, 7.1650000e-01, 9.9393710e-01,
 4.6011010e-01, 1.0816900e+00, 4.1090040e-01, 1.0474360e+00, 5.9355830e-01, 7.5534470e-01, 4.8216750e-01, 6.5394650e-01,
 2.3238710e-01, 3.1288910e-01, 2.2877670e-01, 1.9454340e-01, 6.9264730e-01, 6.7559810e-01, 3.8094830e-01, 4.3928150e-01,
 2.8200400e-01, 6.8983100e-01, 2.6524310e-01, 5.6204240e-01, 5.5854900e-01, 7.3958730e-01, 4.7787020e-01, 5.3875140e-01,
 8.7852620e-01, 1.2875180e+00, 6.4936540e-01, 1.1383750e+00, 1.1812270e+00, 1.2540930e+00, 4.8777750e-01, 1.1595520e+00,
 4.9787190e-01, 1.3256390e+00, 3.5159370e-01, 1.5358810e+00, 7.0148560e-01, 1.0110370e+00, 4.5061130e-01, 1.0473020e+00,
 2.4573410e-01, 2.9164060e-01, 2.2178300e-01, 2.9710500e-01, 6.6323550e-01, 5.7022760e-01, 3.3441430e-01, 6.0748940e-01,
 1.9847940e-01, 4.2796370e-01, 1.7114620e-01, 5.7130670e-01, 5.8979300e-01, 6.8838590e-01, 4.6260620e-01, 8.2161220e-01,
 5.1331050e-01, 6.9794020e-01, 6.1825100e-01, 5.0992250e-01, 1.4827330e+00, 1.4604910e+00, 9.9770420e-01, 1.1158690e+00,
 3.8969760e-01, 9.6266430e-01, 4.4843700e-01, 9.2163970e-01, 9.3842400e-01, 1.2548360e+00, 9.8227400e-01, 1.0741030e+00,
 1.9987210e-01, 2.8277210e-01, 2.5354260e-01, 1.7382990e-01, 9.5386030e-01, 9.7761320e-01, 6.7598600e-01, 6.2846840e-01,
 3.0437380e-01, 7.8234930e-01, 3.6888840e-01, 6.3021530e-01, 1.1253380e+00, 1.5657310e+00, 1.2405970e+00, 1.1276600e+00,
 5.0772340e-01, 7.8186490e-01, 4.8357140e-01, 6.8347980e-01, 1.0930450e+00, 1.2193840e+00, 5.8160170e-01, 1.1147130e+00,
 3.6107860e-01, 1.0102190e+00, 3.2856720e-01, 1.1572030e+00, 9.4967020e-01, 1.4382260e+00, 7.8605890e-01, 1.4729700e+00,
 4.4257240e-01, 4.5332530e-01, 3.6882880e-01, 6.1043720e-01, 8.6348880e-01, 6.4073760e-01, 4.0202340e-01, 9.0227670e-01,
 2.2711170e-01, 4.2264340e-01, 1.8082940e-01, 7.4577110e-01, 7.5841790e-01, 7.6398350e-01, 5.4928530e-01, 1.2052800e+00,
 8.6278450e-01, 1.0124730e+00, 9.5954340e-01, 9.7777410e-01, 1.8015870e+00, 1.5315610e+00, 1.1193650e+00, 1.5467420e+00,
 4.1615500e-01, 8.8724860e-01, 4.4218740e-01, 1.1227960e+00, 1.1261890e+00, 1.2996970e+00, 1.0884850e+00, 1.4705180e+00,
 2.8922350e-01, 3.5315150e-01, 3.3877390e-01, 2.8695780e-01, 9.9778310e-01, 8.8259500e-01, 6.5293000e-01, 7.4997530e-01,
 2.7982970e-01, 6.2076940e-01, 3.1315480e-01, 6.6097900e-01, 1.1626650e+00, 1.3961490e+00, 1.1835310e+00, 1.3291120e+00,
 7.6589420e-01, 1.0179260e+00, 6.7356540e-01, 1.1761950e+00, 1.1919270e+00, 1.1476120e+00, 5.8561850e-01, 1.3867140e+00,
 3.4605770e-01, 8.3561310e-01, 2.9076930e-01, 1.2652280e+00, 1.0228320e+00, 1.3369090e+00, 7.8174340e-01, 1.8098300e+00,
 6.9315600e-01, 9.5610850e-01, 8.0102840e-01, 1.2632640e+00, 1.8308910e+00, 1.8295180e+00, 1.1820440e+00, 2.5278550e+00,
 4.8656600e-01, 1.2193460e+00, 5.3721440e-01, 2.1111270e+00, 1.2739070e+00, 1.7280790e+00, 1.2793910e+00, 2.6749980e+00,
 1.2914040e+00, 2.0407690e+00, 1.9915940e+00, 1.9337700e+00, 3.6506840e+00, 4.1793020e+00, 3.1453360e+00, 4.1413630e+00,
 8.5206080e-01, 2.4463090e+00, 1.2554470e+00, 3.0375450e+00, 1.8078130e+00, 2.8095380e+00, 2.4229310e+00, 3.1190250e+00,
 3.8249390e-01, 6.2893040e-01, 6.2126560e-01, 5.0143610e-01, 1.7864310e+00, 2.1279540e+00, 1.6210380e+00, 1.7742050e+00,
 5.0622130e-01, 1.5122640e+00, 7.8556510e-01, 1.5799410e+00, 1.6490270e+00, 2.6665860e+00, 2.3277130e+00, 2.4908150e+00,
 1.2946900e+00, 2.3172030e+00, 1.5788950e+00, 2.6271390e+00, 2.7277590e+00, 3.5367310e+00, 1.8584350e+00, 4.1932380e+00,
 8.0020510e-01, 2.6020070e+00, 9.3234720e-01, 3.8656980e+00, 1.8543160e+00, 3.2638620e+00, 1.9652600e+00, 4.3353450e+00,
 4.1514490e-01, 4.9456060e-01, 3.5297120e-01, 5.3366490e-01, 9.3728840e-01, 8.0889260e-01, 4.4521200e-01, 9.1278500e-01,
 2.7112210e-01, 5.8680480e-01, 2.2023860e-01, 8.2974210e-01, 4.7519770e-01, 5.5672900e-01, 3.5112580e-01, 7.0382700e-01,
 1.6172980e+00, 2.2073200e+00, 1.8350640e+00, 1.7081980e+00, 3.9079040e+00, 3.8638210e+00, 2.4771900e+00, 3.1269340e+00,
 9.9277930e-01, 2.4617110e+00, 1.0762250e+00, 2.4963790e+00, 1.4100980e+00, 1.8926670e+00, 1.3904630e+00, 1.7160120e+00,
 4.7183140e-01, 6.7005200e-01, 5.6384820e-01, 4.3629830e-01, 1.8836080e+00, 1.9378050e+00, 1.2575350e+00, 1.3195130e+00,
 5.8097450e-01, 1.4989520e+00, 6.6331750e-01, 1.2789780e+00, 1.2669460e+00, 1.7694140e+00, 1.3157770e+00, 1.3498250e+00,
 1.9316140e+00, 2.9858100e+00, 1.7331270e+00, 2.7646700e+00, 3.4785840e+00, 3.8953110e+00, 1.7436790e+00, 3.7718270e+00,
 1.1107340e+00, 3.1193280e+00, 9.5215830e-01, 3.7847960e+00, 1.7230840e+00, 2.6193760e+00, 1.3435850e+00, 2.8415280e+00,
 3.6253290e-01, 4.5380910e-01, 3.9717870e-01, 4.8415470e-01, 1.3105490e+00, 1.1884390e+00, 8.0213220e-01, 1.3259170e+00,
 2.9711480e-01, 6.7570810e-01, 3.1099380e-01, 9.4464900e-01, 9.7208370e-01, 1.1966830e+00, 9.2553100e-01, 1.4957640e+00,
 7.2921700e-01, 1.0457750e+00, 1.0661470e+00, 8.0015300e-01, 2.8212600e+00, 2.9310440e+00, 2.3043980e+00, 2.3452320e+00,
 5.6173480e-01, 1.4635970e+00, 7.8465820e-01, 1.4674290e+00, 1.4893530e+00, 2.1005290e+00, 1.8923730e+00, 1.8829410e+00,
 2.7110640e-01, 4.0454550e-01, 4.1745930e-01, 2.6043800e-01, 1.7329100e+00, 1.8732740e+00, 1.4907480e+00, 1.2611500e+00,
 4.1891100e-01, 1.1356860e+00, 6.1628990e-01, 9.5806660e-01, 1.7052680e+00, 2.5024760e+00, 2.2820010e+00, 1.8874690e+00,
 7.4577100e-01, 1.2113040e+00, 8.6221270e-01, 1.1089100e+00, 2.1504040e+00, 2.5302630e+00, 1.3889390e+00, 2.4223510e+00,
 5.3815460e-01, 1.5880490e+00, 5.9443590e-01, 1.9050540e+00, 1.5583790e+00, 2.4892620e+00, 1.5657800e+00, 2.6698480e+00,
 5.4002750e-01, 4.6573230e-01, 4.1236020e-01, 8.9895760e-01, 7.0334110e-01, 4.3942450e-01, 3.0004120e-01, 8.8698370e-01,
 2.1606330e-01, 3.3854050e-01, 1.5762710e-01, 8.5627600e-01, 6.2755440e-01, 5.3225720e-01, 4.1644830e-01, 1.2036420e+00,
 1.1587560e+00, 1.1449010e+00, 1.1807950e+00, 1.5848740e+00, 1.6151860e+00, 1.1561030e+00, 9.1951610e-01, 1.6736000e+00,
 4.3576750e-01, 7.8223970e-01, 4.2425450e-01, 1.4189500e+00, 1.0256810e+00, 9.9663920e-01, 9.0833010e-01, 1.6163590e+00,
 3.8666910e-01, 3.9752250e-01, 4.1498860e-01, 4.6301020e-01, 8.9047090e-01, 6.6319290e-01, 5.3391310e-01, 8.0778770e-01,
 2.9168210e-01, 5.4480500e-01, 2.9908560e-01, 8.3151530e-01, 1.0540750e+00, 1.0657210e+00, 9.8314390e-01, 1.4542710e+00,
 1.0674670e+00, 1.1945290e+00, 8.6017290e-01, 1.9784800e+00, 1.1089530e+00, 8.9898690e-01, 4.9922750e-01, 1.5571010e+00,
 3.7604890e-01, 7.6453220e-01, 2.8951070e-01, 1.6593230e+00, 9.6672130e-01, 1.0638820e+00, 6.7698870e-01, 2.0644350e+00,
 6.1533600e-01, 7.1463340e-01, 6.5155270e-01, 1.3534500e+00, 1.0849800e+00, 9.1283100e-01, 6.4181950e-01, 1.8079140e+00,
 3.3676980e-01, 7.1058030e-01, 3.4069000e-01, 1.7634870e+00, 7.6688470e-01, 8.7589250e-01, 7.0569360e-01, 1.9434910e+00,
 1.2618320e+00, 1.6789130e+00, 1.7830380e+00, 2.2803990e+00, 2.3811750e+00, 2.2951740e+00, 1.8797690e+00, 3.2600710e+00,
 6.4911260e-01, 1.5691180e+00, 8.7633080e-01, 2.7927930e+00, 1.1978550e+00, 1.5674020e+00, 1.4709980e+00, 2.4942280e+00,
 3.7203190e-01, 5.1505430e-01, 5.5367300e-01, 5.8862380e-01, 1.1598980e+00, 1.1632960e+00, 9.6437710e-01, 1.3902840e+00,
 3.8388940e-01, 9.6557940e-01, 5.4584360e-01, 1.4460160e+00, 1.0876640e+00, 1.4808710e+00, 1.4067490e+00, 1.9827820e+00,
 1.3128080e+00, 1.9783090e+00, 1.4669290e+00, 3.2150300e+00, 1.8463710e+00, 2.0156260e+00, 1.1526060e+00, 3.4255420e+00,
 6.3262560e-01, 1.7320030e+00, 6.7537260e-01, 3.6884160e+00, 1.2750590e+00, 1.8896140e+00, 1.2381890e+00, 3.5977990e+00,
 2.7661540e-01, 2.7745400e-01, 2.1549450e-01, 4.2915280e-01, 4.1689590e-01, 3.0292840e-01, 1.8144360e-01, 4.8999260e-01,
 1.4084830e-01, 2.5667010e-01, 1.0483360e-01, 5.2023130e-01, 2.1471490e-01, 2.1180030e-01, 1.4536870e-01, 3.8381360e-01,
 1.1861090e+00, 1.3629970e+00, 1.2331230e+00, 1.5119580e+00, 1.9131820e+00, 1.5926650e+00, 1.1112000e+00, 1.8475570e+00,
 5.6767210e-01, 1.1851590e+00, 5.6385590e-01, 1.7227490e+00, 7.0128610e-01, 7.9252880e-01, 6.3361530e-01, 1.0299900e+00,
 3.4445930e-01, 4.1186450e-01, 3.7716690e-01, 3.8441580e-01, 9.1795050e-01, 7.9512160e-01, 5.6152500e-01, 7.7608440e-01,
 3.3068780e-01, 7.1836240e-01, 3.4594160e-01, 8.7859930e-01, 6.2722060e-01, 7.3754150e-01, 5.9684950e-01, 8.0650350e-01,
 1.4701140e+00, 1.9133200e+00, 1.2085970e+00, 2.5394560e+00, 1.7673030e+00, 1.6662700e+00, 8.1169960e-01, 2.3127400e+00,
 6.5909950e-01, 1.5584630e+00, 5.1769060e-01, 2.7105030e+00, 8.8930010e-01, 1.1382420e+00, 6.3537110e-01, 1.7699480e+00,
 5.4200540e-01, 5.7124730e-01, 5.4407960e-01, 8.7358860e-01, 1.3079380e+00, 9.9863240e-01, 7.3350010e-01, 1.5970440e+00,
 3.4633030e-01, 6.6316280e-01, 3.3215310e-01, 1.3289340e+00, 9.8553260e-01, 1.0215070e+00, 8.5976280e-01, 1.8301940e+00,
 1.1999720e+00, 1.4489290e+00, 1.6075020e+00, 1.5891100e+00, 3.0990970e+00, 2.7108720e+00, 2.3193690e+00, 3.1091690e+00,
 7.2070180e-01, 1.5810320e+00, 9.2241250e-01, 2.2722070e+00, 1.6619700e+00, 1.9735540e+00, 1.9348730e+00, 2.5358800e+00,
 4.4408920e-01, 5.5794670e-01, 6.2656330e-01, 5.1487460e-01, 1.8948900e+00, 1.7246630e+00, 1.4935950e+00, 1.6643380e+00,
 5.3501050e-01, 1.2212200e+00, 7.2118380e-01, 1.4767360e+00, 1.8942370e+00, 2.3404880e+00, 2.3226180e+00, 2.5303940e+00,
 1.2735490e+00, 1.7416400e+00, 1.3491030e+00, 2.2854570e+00, 2.4513650e+00, 2.4285570e+00, 1.4507460e+00, 3.3326650e+00,
 7.1651850e-01, 1.7802420e+00, 7.2517970e-01, 3.0612170e+00, 1.8046560e+00, 2.4270950e+00, 1.6613940e+00, 3.7314240e+00,
 7.4073770e-01, 8.4420850e-01, 5.1267940e-01, 1.0286030e+00, 1.2914640e+00, 1.0662650e+00, 4.9936460e-01, 1.3586010e+00,
 4.0744910e-01, 8.4366050e-01, 2.6942870e-01, 1.3469960e+00, 1.3348160e+00, 1.4960850e+00, 8.0288170e-01, 2.1356360e+00,
 1.7278080e+00, 2.2559860e+00, 1.5958750e+00, 1.9713260e+00, 3.2239910e+00, 3.0495270e+00, 1.6636080e+00, 2.7866540e+00,
 8.9330990e-01, 2.1191020e+00, 7.8830510e-01, 2.4264670e+00, 2.3715770e+00, 3.0452830e+00, 1.9036590e+00, 3.1176160e+00,
 4.9081630e-01, 6.6681610e-01, 4.7745920e-01, 4.9026410e-01, 1.5130980e+00, 1.4891960e+00, 8.2231530e-01, 1.1449970e+00,
 5.0901780e-01, 1.2564040e+00, 4.7308510e-01, 1.2104690e+00, 2.0747820e+00, 2.7721020e+00, 1.7540360e+00, 2.3878460e+00,
 1.4630520e+00, 2.1635500e+00, 1.0685910e+00, 2.2620230e+00, 2.0346330e+00, 2.1796720e+00, 8.3021790e-01, 2.3831410e+00,
 7.0858730e-01, 1.9037490e+00, 4.9446350e-01, 2.6081950e+00, 2.0546030e+00, 2.9880300e+00, 1.3041530e+00, 3.6600580e+00,
 1.1862610e+00, 1.8206070e+00, 1.1385130e+00, 2.1765580e+00, 2.7999950e+00, 3.1130850e+00, 1.5013060e+00, 3.8920060e+00,
 8.9257550e-01, 2.4887990e+00, 8.1844930e-01, 3.8989190e+00, 2.2925540e+00, 3.4602310e+00, 1.9121690e+00, 4.8465430e+00,
 2.6443850e+00, 4.6496040e+00, 3.3869140e+00, 3.9865200e+00, 6.6800860e+00, 8.5088570e+00, 4.7798660e+00, 7.6291790e+00,
 1.8701950e+00, 5.9743020e+00, 2.2885240e+00, 6.7122110e+00, 3.8926790e+00, 6.7311550e+00, 4.3328830e+00, 6.7614610e+00,
 6.6371130e-01, 1.2142740e+00, 8.9530890e-01, 8.7598540e-01, 2.7700420e+00, 3.6713170e+00, 2.0875370e+00, 2.7696850e+00,
 9.4156200e-01, 3.1296490e+00, 1.2134770e+00, 2.9585300e+00, 3.0089500e+00, 5.4138030e+00, 3.5274230e+00, 4.5756770e+00,
 2.5288670e+00, 5.0359780e+00, 2.5612640e+00, 5.1661840e+00, 4.7611470e+00, 6.8685840e+00, 2.6939780e+00, 7.3685460e+00,
 1.6753880e+00, 6.0615280e+00, 1.6211850e+00, 8.1483290e+00, 3.8086990e+00, 7.4590600e+00, 3.3523840e+00, 8.9648520e+00,
 4.9457380e-01, 6.5555710e-01, 3.4923000e-01, 6.4006880e-01, 9.9781510e-01, 9.5813630e-01, 3.9362670e-01, 9.7829980e-01,
 3.4621840e-01, 8.3375510e-01, 2.3357130e-01, 1.0667310e+00, 5.9530330e-01, 7.7601020e-01, 3.6531510e-01, 8.8768020e-01,
 2.3053370e+00, 3.5008160e+00, 2.1723840e+00, 2.4513730e+00, 4.9777580e+00, 5.4760390e+00, 2.6205360e+00, 4.0099150e+00,
 1.5168790e+00, 4.1849950e+00, 1.3656590e+00, 3.8400370e+00, 2.1136170e+00, 3.1565370e+00, 1.7309210e+00, 2.5895480e+00,
 5.6993270e-01, 9.0054370e-01, 5.6563960e-01, 5.3057510e-01, 2.0331650e+00, 2.3272970e+00, 1.1273090e+00, 1.4339120e+00,
 7.5222470e-01, 2.1594240e+00, 7.1326820e-01, 1.6671720e+00, 1.6092640e+00, 2.5006810e+00, 1.3880100e+00, 1.7261300e+00,
 2.6264110e+00, 4.5171440e+00, 1.9571020e+00, 3.7845320e+00, 4.2265900e+00, 5.2661030e+00, 1.7595240e+00, 4.6138770e+00,
 1.6188490e+00, 5.0584400e+00, 1.1525140e+00, 5.5534790e+00, 2.4636620e+00, 4.1670840e+00, 1.5954420e+00, 4.0902830e+00,
 7.5276950e-01, 1.0484490e+00, 6.8492250e-01, 1.0121050e+00, 2.4317190e+00, 2.4535600e+00, 1.2360810e+00, 2.4768700e+00,
 6.6129120e-01, 1.6733510e+00, 5.7485870e-01, 2.1167300e+00, 2.1225150e+00, 2.9072740e+00, 1.6783360e+00, 3.2880380e+00,
 1.8116920e+00, 2.8908480e+00, 2.1998120e+00, 2.0013700e+00, 6.2634880e+00, 7.2402740e+00, 4.2488510e+00, 5.2418610e+00,
 1.4959350e+00, 4.3367330e+00, 1.7354130e+00, 3.9342790e+00, 3.8909710e+00, 6.1058840e+00, 4.1058960e+00, 4.9524890e+00,
 5.7076800e-01, 9.4764760e-01, 7.2991940e-01, 5.5201500e-01, 3.2601770e+00, 3.9212660e+00, 2.3292200e+00, 2.3886840e+00,
 9.4535620e-01, 2.8516200e+00, 1.1550470e+00, 2.1766870e+00, 3.7752440e+00, 6.1642750e+00, 4.1957460e+00, 4.2068690e+00,
 1.7673840e+00, 3.1940250e+00, 1.6969960e+00, 2.6457470e+00, 4.5539770e+00, 5.9620560e+00, 2.4428390e+00, 5.1645750e+00,
 1.3670560e+00, 4.4885150e+00, 1.2540800e+00, 4.8720660e+00, 3.8835700e+00, 6.9022100e+00, 3.2406320e+00, 6.6984010e+00,
 2.8444980e-01, 2.7624100e-01, 1.9528580e-01, 3.5519770e-01, 3.8642870e-01, 2.7186280e-01, 1.4821380e-01, 3.6556130e-01,
 1.4249520e-01, 2.5141540e-01, 9.3466140e-02, 4.2361780e-01, 4.1907620e-01, 4.0024430e-01, 2.5003840e-01, 6.0294830e-01,
 6.6554200e-01, 7.4048020e-01, 6.0976460e-01, 6.8284080e-01, 9.6765300e-01, 7.7992980e-01, 4.9529110e-01, 7.5212500e-01,
 3.1337750e-01, 6.3345350e-01, 2.7431120e-01, 7.6545750e-01, 7.4687420e-01, 8.1721280e-01, 5.9467960e-01, 8.8290530e-01,
 2.1246700e-01, 2.4596640e-01, 2.0501820e-01, 1.9084630e-01, 5.1037030e-01, 4.2802350e-01, 2.7513150e-01, 3.4729940e-01,
 2.0067400e-01, 4.2207000e-01, 1.8500400e-01, 4.2913390e-01, 7.3430310e-01, 8.3600600e-01, 6.1577930e-01, 7.5995920e-01,
 5.3019610e-01, 6.6809920e-01, 3.8412450e-01, 7.3714850e-01, 5.7452480e-01, 5.2445850e-01, 2.3254040e-01, 6.0513690e-01,
 2.3385990e-01, 5.3538880e-01, 1.6187520e-01, 7.7407610e-01, 6.0874470e-01, 7.5437860e-01, 3.8328290e-01, 9.7516090e-01,
 1.0039790e+00, 1.3129780e+00, 9.5579750e-01, 1.6565150e+00, 1.8464920e+00, 1.7493560e+00, 9.8207110e-01, 2.3080480e+00,
 6.8797840e-01, 1.6346200e+00, 6.2575620e-01, 2.7024350e+00, 1.5863320e+00, 2.0402190e+00, 1.3124550e+00, 3.0156980e+00,
 2.2449540e+00, 3.3635350e+00, 2.8521380e+00, 3.0433920e+00, 4.4188660e+00, 4.7961990e+00, 3.1363760e+00, 4.5382420e+00,
 1.4459570e+00, 3.9359800e+00, 1.7551230e+00, 4.6667580e+00, 2.7018540e+00, 3.9810720e+00, 2.9831410e+00, 4.2202190e+00,
 6.3322000e-01, 9.8716450e-01, 8.4728970e-01, 7.5154230e-01, 2.0592440e+00, 2.3256290e+00, 1.5393560e+00, 1.8515390e+00,
 8.1810680e-01, 2.3171490e+00, 1.0458670e+00, 2.3116290e+00, 2.3470420e+00, 3.5983670e+00, 2.7292730e+00, 3.2095370e+00,
 2.0197880e+00, 3.4273680e+00, 2.0291660e+00, 3.7104850e+00, 2.9630380e+00, 3.6424210e+00, 1.6630420e+00, 4.1237150e+00,
 1.2186550e+00, 3.7570310e+00, 1.1697190e+00, 5.3298510e+00, 2.4870630e+00, 4.1504150e+00, 2.1714380e+00, 5.2642240e+00,
 3.8419640e-01, 4.3394020e-01, 2.6910220e-01, 4.4712600e-01, 6.0397390e-01, 4.9418840e-01, 2.3633950e-01, 5.3250190e-01,
 2.4493900e-01, 5.0262440e-01, 1.6391210e-01, 6.7864710e-01, 3.7808630e-01, 4.1996900e-01, 2.3014610e-01, 5.0697930e-01,
 1.7963680e+00, 2.3244880e+00, 1.6791170e+00, 1.7177160e+00, 3.0223210e+00, 2.8331560e+00, 1.5782670e+00, 2.1893900e+00,
 1.0764590e+00, 2.5306880e+00, 9.6132940e-01, 2.4505470e+00, 1.3465350e+00, 1.7135600e+00, 1.0938360e+00, 1.4835300e+00,
 4.9908780e-01, 6.7197860e-01, 4.9133400e-01, 4.1781250e-01, 1.3873050e+00, 1.3531570e+00, 7.6300260e-01, 8.7983830e-01,
 5.9991080e-01, 1.4674870e+00, 5.6425510e-01, 1.1956400e+00, 1.1521560e+00, 1.5255950e+00, 9.8573430e-01, 1.1113180e+00,
 1.9253970e+00, 2.8217520e+00, 1.4231630e+00, 2.4948880e+00, 2.4143140e+00, 2.5632450e+00, 9.9697050e-01, 2.3700130e+00,
 1.0808110e+00, 2.8777780e+00, 7.6326100e-01, 3.3341850e+00, 1.4766220e+00, 2.1282250e+00, 9.4853330e-01, 2.2045640e+00,
 8.0348710e-01, 9.5358960e-01, 7.2517340e-01, 9.7145670e-01, 2.0224430e+00, 1.7388280e+00, 1.0197490e+00, 1.8524530e+00,
 6.4282880e-01, 1.3860760e+00, 5.5430310e-01, 1.8503300e+00, 1.8522440e+00, 2.1618740e+00, 1.4528140e+00, 2.5802710e+00,
 1.9397240e+00, 2.6374130e+00, 2.3362790e+00, 1.9269220e+00, 5.2253780e+00, 5.1469940e+00, 3.5160620e+00, 3.9324950e+00,
 1.4586600e+00, 3.6033060e+00, 1.6785250e+00, 3.4497490e+00, 3.4059950e+00, 4.5544060e+00, 3.5651470e+00, 3.8984380e+00,
 6.8676440e-01, 9.7161060e-01, 8.7117750e-01, 5.9728300e-01, 3.0565770e+00, 3.1326910e+00, 2.1661490e+00, 2.0138820e+00,
 1.0359270e+00, 2.6627030e+00, 1.2555010e+00, 2.1449200e+00, 3.7138440e+00, 5.1672300e+00, 4.0942210e+00, 3.7215050e+00,
 1.7802600e+00, 2.7414980e+00, 1.6955740e+00, 2.3965250e+00, 3.5742850e+00, 3.9874170e+00, 1.9018520e+00, 3.6451390e+00,
 1.2540780e+00, 3.5086340e+00, 1.1411610e+00, 4.0191330e+00, 3.1982610e+00, 4.8436000e+00, 2.6472580e+00, 4.9606110e+00,
 7.5958550e-01, 7.7804080e-01, 6.3301970e-01, 1.0476910e+00, 1.3821140e+00, 1.0255750e+00, 6.4348520e-01, 1.4441990e+00,
 3.8609860e-01, 7.1851020e-01, 3.0741690e-01, 1.2678400e+00, 1.2502180e+00, 1.2593930e+00, 9.0547250e-01, 1.9868510e+00,
 1.7113590e+00, 2.0082710e+00, 1.9032830e+00, 1.9394440e+00, 3.3326430e+00, 2.8331390e+00, 2.0706430e+00, 2.8612210e+00,
 8.1763650e-01, 1.7432130e+00, 8.6878340e-01, 2.2060020e+00, 2.1455320e+00, 2.4760870e+00, 2.0737010e+00, 2.8015210e+00,
 5.2163650e-01, 6.3693560e-01, 6.1100450e-01, 5.1755020e-01, 1.6782840e+00, 1.4845360e+00, 1.0982370e+00, 1.2614680e+00,
 4.9991330e-01, 1.1089990e+00, 5.5944840e-01, 1.1808330e+00, 2.0140670e+00, 2.4185280e+00, 2.0502130e+00, 2.3024010e+00,
 1.4096260e+00, 1.8734900e+00, 1.2396950e+00, 2.1647840e+00, 2.0458780e+00, 1.9698140e+00, 1.0051820e+00, 2.3802180e+00,
 6.3088480e-01, 1.5233750e+00, 5.3009050e-01, 2.3065890e+00, 1.8081080e+00, 2.3633160e+00, 1.3819240e+00, 3.1993210e+00,
 1.1096440e+00, 1.5305940e+00, 1.2823330e+00, 2.0223060e+00, 2.7334440e+00, 2.7313930e+00, 1.7647420e+00, 3.7739820e+00,
 7.7154440e-01, 1.9335090e+00, 8.5185730e-01, 3.3476000e+00, 1.9587330e+00, 2.6570590e+00, 1.9671660e+00, 4.1130230e+00,
 2.3892480e+00, 3.7756610e+00, 3.6846810e+00, 3.5777010e+00, 6.2989510e+00, 7.2110380e+00, 5.4270140e+00, 7.1455770e+00,
 1.5614790e+00, 4.4830840e+00, 2.3007200e+00, 5.5665770e+00, 3.2124590e+00, 4.9925110e+00, 4.3055150e+00, 5.5424650e+00,
 6.4345680e-01, 1.0580290e+00, 1.0451350e+00, 8.4354920e-01, 2.8026970e+00, 3.3385050e+00, 2.5432140e+00, 2.7835140e+00,
 8.4353230e-01, 2.5199320e+00, 1.3090120e+00, 2.6327050e+00, 2.6644500e+00, 4.3085920e+00, 3.7610510e+00, 4.0245870e+00,
 2.2226000e+00, 3.9779510e+00, 2.7104950e+00, 4.5100200e+00, 4.3671320e+00, 5.6622930e+00, 2.9753480e+00, 6.7133590e+00,
 1.3607020e+00, 4.4245630e+00, 1.5854020e+00, 6.5733950e+00, 3.0574840e+00, 5.3816090e+00, 3.2404130e+00, 7.1483220e+00,
 6.2552460e-01, 7.4518520e-01, 5.3184360e-01, 8.0410600e-01, 1.3170820e+00, 1.1366600e+00, 6.2561400e-01, 1.2826500e+00,
 4.0464670e-01, 8.7579970e-01, 3.2870360e-01, 1.2383810e+00, 6.8770780e-01, 8.0570020e-01, 5.0815040e-01, 1.0185810e+00,
 2.8163130e+00, 3.8437600e+00, 3.1955250e+00, 2.9746050e+00, 6.3464350e+00, 6.2748440e+00, 4.0229550e+00, 5.0781390e+00,
 1.7124190e+00, 4.2461420e+00, 1.8563520e+00, 4.3059400e+00, 2.3584420e+00, 3.1655580e+00, 2.3256020e+00, 2.8700950e+00,
 7.4709130e-01, 1.0609510e+00, 8.9278940e-01, 6.9082870e-01, 2.7814570e+00, 2.8614870e+00, 1.8569570e+00, 1.9484770e+00,
 9.1119290e-01, 2.3509370e+00, 1.0403380e+00, 2.0059330e+00, 1.9267700e+00, 2.6909230e+00, 2.0010320e+00, 2.0528120e+00,
 3.1211010e+00, 4.8244690e+00, 2.8003850e+00, 4.4671510e+00, 5.2418520e+00, 5.8698140e+00, 2.6275370e+00, 5.6837370e+00,
 1.7777230e+00, 4.9924620e+00, 1.5239230e+00, 6.0575390e+00, 2.6741060e+00, 4.0650900e+00, 2.0851510e+00, 4.4098540e+00,
 8.7394220e-01, 1.0939780e+00, 9.5746130e-01, 1.1671310e+00, 2.9463450e+00, 2.6718200e+00, 1.8033340e+00, 2.9808950e+00,
 7.0945700e-01, 1.6134700e+00, 7.4259760e-01, 2.2556530e+00, 2.2507330e+00, 2.7707630e+00, 2.1429460e+00, 3.4632460e+00,
 2.0316010e+00, 2.9135310e+00, 2.9702890e+00, 2.2292290e+00, 7.3302660e+00, 7.6155070e+00, 5.9873420e+00, 6.0934370e+00,
 1.5501700e+00, 4.0389610e+00, 2.1653520e+00, 4.0495340e+00, 3.9853300e+00, 5.6207640e+00, 5.0637630e+00, 5.0385230e+00,
 6.8677920e-01, 1.0248130e+00, 1.0575270e+00, 6.5975350e-01, 4.0940030e+00, 4.4256160e+00, 3.5218970e+00, 2.9794710e+00,
 1.0511520e+00, 2.8497200e+00, 1.5464250e+00, 2.4040280e+00, 4.1491100e+00, 6.0888080e+00, 5.5523660e+00, 4.5924260e+00,
 1.9278950e+00, 3.1313470e+00, 2.2289090e+00, 2.8666470e+00, 5.1843330e+00, 6.1001220e+00, 3.3485430e+00, 5.8399620e+00,
 1.3780070e+00, 4.0663830e+00, 1.5221220e+00, 4.8781110e+00, 3.8693320e+00, 6.1806410e+00, 3.8877090e+00, 6.6290220e+00,
 5.9224480e-02, 5.1076570e-02, 4.5223290e-02, 9.8588110e-02, 7.0189170e-02, 4.3851900e-02, 2.9942290e-02, 8.8515590e-02,
 2.1715820e-02, 3.4025600e-02, 1.5842590e-02, 8.6061520e-02, 7.0849140e-02, 6.0090350e-02, 4.7015850e-02, 1.3588780e-01,
 7.6985130e-02, 7.6064640e-02, 7.8449370e-02, 1.0529550e-01, 9.7646380e-02, 6.9892400e-02, 5.5589510e-02, 1.0117780e-01,
 2.6532580e-02, 4.7628240e-02, 2.5831590e-02, 8.6395620e-02, 7.0149550e-02, 6.8163300e-02, 6.2123560e-02, 1.1054790e-01,
 2.1985950e-02, 2.2603070e-02, 2.3596190e-02, 2.6326690e-02, 4.6072760e-02, 3.4313450e-02, 2.7624540e-02, 4.1794750e-02,
 1.5199360e-02, 2.8389430e-02, 1.5585150e-02, 4.3329710e-02, 6.1698570e-02, 6.2380250e-02, 5.7546730e-02, 8.5123380e-02,
 6.7651360e-02, 7.5704030e-02, 5.4513980e-02, 1.2538740e-01, 6.3951980e-02, 5.1843500e-02, 2.8789850e-02, 8.9796140e-02,
 2.1841190e-02, 4.4404580e-02, 1.6814990e-02, 9.6374690e-02, 6.3069770e-02, 6.9408630e-02, 4.4167360e-02, 1.3468560e-01,
 4.1391000e-02, 4.8070310e-02, 4.3827140e-02, 9.1040730e-02, 6.6410070e-02, 5.5873100e-02, 3.9284870e-02, 1.1065990e-01,
 2.0760440e-02, 4.3804280e-02, 2.1002100e-02, 1.0871160e-01, 5.3103300e-02, 6.0651600e-02, 4.8866100e-02, 1.3457800e-01,
 5.1419120e-02, 6.8414970e-02, 7.2658030e-02, 9.2925300e-02, 8.8294390e-02, 8.5105470e-02, 6.9702160e-02, 1.2088400e-01,
 2.4241130e-02, 5.8598770e-02, 3.2726600e-02, 1.0429700e-01, 5.0248720e-02, 6.5750830e-02, 6.1706780e-02, 1.0463020e-01,
 1.2974600e-02, 1.7962510e-02, 1.9309330e-02, 2.0528240e-02, 3.6808860e-02, 3.6916720e-02, 3.0604100e-02, 4.4120090e-02,
 1.2269590e-02, 3.0861130e-02, 1.7445850e-02, 4.6216490e-02, 3.9048690e-02, 5.3165390e-02, 5.0504300e-02, 7.1184710e-02,
 5.1030710e-02, 7.6899690e-02, 5.7021590e-02, 1.2497280e-01, 6.5308280e-02, 7.1295000e-02, 4.0769000e-02, 1.2116530e-01,
 2.2536530e-02, 6.1700540e-02, 2.4059340e-02, 1.3139540e-01, 5.1022140e-02, 7.5613850e-02, 4.9546760e-02, 1.4396770e-01,
 1.5369410e-02, 1.5416000e-02, 1.1973390e-02, 2.3844750e-02, 2.1077890e-02, 1.5315800e-02, 9.1736280e-03, 2.4773600e-02,
 7.1720320e-03, 1.3069710e-02, 5.3381540e-03, 2.6490320e-02, 1.2281200e-02, 1.2114490e-02, 8.3147560e-03, 2.1953260e-02,
 3.9924080e-02, 4.5878060e-02, 4.1506540e-02, 5.0892050e-02, 5.8598350e-02, 4.8781290e-02, 3.4034630e-02, 5.6588310e-02,
 1.7511270e-02, 3.6559200e-02, 1.7393550e-02, 5.3142500e-02, 2.4299840e-02, 2.7461430e-02, 2.1955020e-02, 3.5689540e-02,
 9.9229090e-03, 1.1864660e-02, 1.0865120e-02, 1.1073940e-02, 2.4062410e-02, 2.0842680e-02, 1.4719360e-02, 2.0343650e-02,
 8.7302990e-03, 1.8965080e-02, 9.1330080e-03, 2.3195400e-02, 1.8600270e-02, 2.1871850e-02, 1.7699620e-02, 2.3916920e-02,
 4.7202900e-02, 6.1433500e-02, 3.8806010e-02, 8.1537650e-02, 5.1635370e-02, 4.8683490e-02, 2.3715470e-02, 6.7571430e-02,
 1.9394490e-02, 4.5858940e-02, 1.5233430e-02, 7.9758560e-02, 2.9394340e-02, 3.7622710e-02, 2.1001140e-02, 5.8502700e-02,
 5.1343240e-02, 5.4113280e-02, 5.1539730e-02, 8.2753560e-02, 1.1274200e-01, 8.6080370e-02, 6.3226420e-02, 1.3766240e-01,
 3.0066310e-02, 5.7571790e-02, 2.8835530e-02, 1.1537000e-01, 9.6105570e-02, 9.9613650e-02, 8.3840950e-02, 1.7847390e-01,
 6.8862090e-02, 8.3148850e-02, 9.2248800e-02, 9.1193320e-02, 1.6183150e-01, 1.4155880e-01, 1.2111490e-01, 1.6235750e-01,
 3.7903090e-02, 8.3149520e-02, 4.8511440e-02, 1.1949970e-01, 9.8181610e-02, 1.1658860e-01, 1.1430350e-01, 1.4980820e-01,
 2.1810730e-02, 2.7402660e-02, 3.0772660e-02, 2.5287240e-02, 8.4684300e-02, 7.7076710e-02, 6.6750070e-02, 7.4380730e-02,
 2.4080870e-02, 5.4967200e-02, 3.2460550e-02, 6.6468030e-02, 9.5770600e-02, 1.1833260e-01, 1.1742910e-01, 1.2793400e-01,
 6.9715960e-02, 9.5339930e-02, 7.3851870e-02, 1.2510930e-01, 1.2210770e-01, 1.2097170e-01, 7.2264770e-02, 1.6600720e-01,
 3.5946260e-02, 8.9311080e-02, 3.6380780e-02, 1.5357500e-01, 1.0169720e-01, 1.3677330e-01, 9.3623960e-02, 2.1027560e-01,
 8.5338320e-02, 9.7258900e-02, 5.9064370e-02, 1.1850250e-01, 1.3538820e-01, 1.1177990e-01, 5.2349940e-02, 1.4242640e-01,
 4.3019260e-02, 8.9075280e-02, 2.8446800e-02, 1.4221840e-01, 1.5830650e-01, 1.7743280e-01, 9.5220200e-02, 2.5328230e-01,
 1.2058820e-01, 1.5745100e-01, 1.1138020e-01, 1.3758390e-01, 2.0474890e-01, 1.9366910e-01, 1.0565230e-01, 1.7697460e-01,
 5.7137480e-02, 1.3554110e-01, 5.0421210e-02, 1.5520060e-01, 1.7039000e-01, 2.1879360e-01, 1.3677170e-01, 2.2399050e-01,
 2.9316960e-02, 3.9829610e-02, 2.8519130e-02, 2.9283980e-02, 8.2240500e-02, 8.0941400e-02, 4.4694820e-02, 6.2233360e-02,
 2.7863960e-02, 6.8776330e-02, 2.5896980e-02, 6.6261830e-02, 1.2757640e-01, 1.7045400e-01, 1.0785400e-01, 1.4682640e-01,
 9.7403860e-02, 1.4404010e-01, 7.1142330e-02, 1.5059600e-01, 1.2325980e-01, 1.3204640e-01, 5.0295290e-02, 1.4437270e-01,
 4.3233430e-02, 1.1615450e-01, 3.0168980e-02, 1.5913530e-01, 1.4081280e-01, 2.0478550e-01, 8.9380550e-02, 2.5084320e-01,
 8.3823980e-02, 1.2864830e-01, 8.0450010e-02, 1.5380060e-01, 1.8003790e-01, 2.0016940e-01, 9.6533030e-02, 2.5025350e-01,
 5.7801980e-02, 1.6117120e-01, 5.3001670e-02, 2.5248870e-01, 1.6676520e-01, 2.5170440e-01, 1.3909510e-01, 3.5254770e-01,
 1.1319880e-01, 1.9903670e-01, 1.4498450e-01, 1.7065200e-01, 2.6020650e-01, 3.3144180e-01, 1.8618810e-01, 2.9717610e-01,
 7.3369250e-02, 2.3437670e-01, 8.9780630e-02, 2.6332540e-01, 1.7153930e-01, 2.9662300e-01, 1.9093790e-01, 2.9795850e-01,
 2.4315740e-02, 4.4486180e-02, 3.2800550e-02, 3.2092620e-02, 9.2345010e-02, 1.2239080e-01, 6.9592310e-02, 9.2333120e-02,
 3.1613100e-02, 1.0507850e-01, 4.0742690e-02, 9.9333130e-02, 1.1348050e-01, 2.0417780e-01, 1.3303430e-01, 1.7256850e-01,
 1.0326440e-01, 2.0564040e-01, 1.0458730e-01, 2.1095730e-01, 1.7691110e-01, 2.5521760e-01, 1.0010080e-01, 2.7379490e-01,
 6.2697450e-02, 2.2683850e-01, 6.0669050e-02, 3.0493210e-01, 1.6010290e-01, 3.1354990e-01, 1.4092120e-01, 3.7684760e-01,
 2.8867300e-02, 3.8263580e-02, 2.0383870e-02, 3.7359560e-02, 5.2996100e-02, 5.0888680e-02, 2.0906360e-02, 5.1959600e-02,
 1.8519750e-02, 4.4598830e-02, 1.2494090e-02, 5.7061080e-02, 3.5769370e-02, 4.6627310e-02, 2.1950300e-02, 5.3337110e-02,
 8.1515260e-02, 1.2378670e-01, 7.6814130e-02, 8.6679010e-02, 1.6016110e-01, 1.7619350e-01, 8.4316650e-02, 1.2902040e-01,
 4.9154740e-02, 1.3561550e-01, 4.4254410e-02, 1.2443710e-01, 7.6935840e-02, 1.1489820e-01, 6.3005680e-02, 9.4259780e-02,
 1.7247220e-02, 2.7252120e-02, 1.7117300e-02, 1.6056180e-02, 5.5986960e-02, 6.4086420e-02, 3.1042540e-02, 3.9485410e-02,
 2.0861850e-02, 5.9888460e-02, 1.9781450e-02, 4.6236580e-02, 5.0132650e-02, 7.7902550e-02, 4.3240010e-02, 5.3773300e-02,
 8.8587920e-02, 1.5236170e-01, 6.6012380e-02, 1.2765090e-01, 1.2972410e-01, 1.6162930e-01, 5.4003980e-02, 1.4161090e-01,
 5.0041230e-02, 1.5636460e-01, 3.5626070e-02, 1.7166700e-01, 8.5544270e-02, 1.4469120e-01, 5.5397560e-02, 1.4202450e-01,
 7.4909350e-02, 1.0433290e-01, 6.8157780e-02, 1.0071620e-01, 2.2019430e-01, 2.2217200e-01, 1.1192820e-01, 2.2428280e-01,
 6.0308240e-02, 1.5260580e-01, 5.2425790e-02, 1.9304090e-01, 2.1743160e-01, 2.9782270e-01, 1.7192970e-01, 3.3682850e-01,
 1.0921640e-01, 1.7427250e-01, 1.3261390e-01, 1.2065100e-01, 3.4358840e-01, 3.9717070e-01, 2.3307390e-01, 2.8754630e-01,
 8.2646810e-02, 2.3959400e-01, 9.5877400e-02, 2.1735940e-01, 2.4146780e-01, 3.7892210e-01, 2.5480580e-01, 3.0734410e-01,
 2.9447880e-02, 4.8892390e-02, 3.7659040e-02, 2.8480340e-02, 1.5305740e-01, 1.8409390e-01, 1.0935120e-01, 1.1214290e-01,
 4.4699190e-02, 1.3483290e-01, 5.4613990e-02, 1.0292010e-01, 2.0051060e-01, 3.2739670e-01, 2.2284420e-01, 2.2343500e-01,
 1.0163460e-01, 1.8367460e-01, 9.7586910e-02, 1.5214550e-01, 2.3829800e-01, 3.1197920e-01, 1.2782750e-01, 2.7024910e-01,
 7.2045520e-02, 2.3655020e-01, 6.6091540e-02, 2.5676380e-01, 2.2990040e-01, 4.0859860e-01, 1.9183970e-01, 3.9653350e-01,
 2.4460650e-02, 2.3754750e-02, 1.6793180e-02, 3.0544460e-02, 3.0237820e-02, 2.1273100e-02, 1.1597640e-02, 2.8604960e-02,
 1.1229810e-02, 1.9813630e-02, 7.3659110e-03, 3.3384610e-02, 3.7098220e-02, 3.5431160e-02, 2.2134360e-02, 5.3375290e-02,
 3.4671070e-02, 3.8574930e-02, 3.1765370e-02, 3.5572240e-02, 4.5870150e-02, 3.6971410e-02, 2.3478540e-02, 3.5653360e-02,
 1.4961300e-02, 3.0242410e-02, 1.3096190e-02, 3.6544560e-02, 4.0053190e-02, 4.3825290e-02, 3.1891330e-02, 4.7348220e-02,
 9.4727070e-03, 1.0966260e-02, 9.1406060e-03, 8.5087620e-03, 2.0705550e-02, 1.7364770e-02, 1.1161990e-02, 1.4089820e-02,
 8.1994300e-03, 1.7245550e-02, 7.5591600e-03, 1.7534180e-02, 3.3702020e-02, 3.8369830e-02, 2.8262170e-02, 3.4879550e-02,
 2.6347270e-02, 3.3200150e-02, 1.9088470e-02, 3.6631440e-02, 2.5979250e-02, 2.3715320e-02, 1.0515170e-02, 2.7363490e-02,
 1.0650370e-02, 2.4382500e-02, 7.3720660e-03, 3.5252720e-02, 3.1140970e-02, 3.8591020e-02, 1.9607240e-02, 4.9885370e-02,
 5.2953550e-02, 6.9251320e-02, 5.0412290e-02, 8.7370750e-02, 8.8621020e-02, 8.3959070e-02, 4.7133780e-02, 1.1077300e-01,
 3.3254870e-02, 7.9012760e-02, 3.0247230e-02, 1.3062780e-01, 8.6131600e-02, 1.1077590e-01, 7.1261140e-02, 1.6374050e-01,
 7.1731090e-02, 1.0747220e-01, 9.1131930e-02, 9.7242900e-02, 1.2847820e-01, 1.3944920e-01, 9.1189920e-02, 1.3194910e-01,
 4.2341400e-02, 1.1525580e-01, 5.1394580e-02, 1.3665490e-01, 8.8870910e-02, 1.3094770e-01, 9.8123180e-02, 1.3881390e-01,
 1.7315920e-02, 2.6994820e-02, 2.3169830e-02, 2.0551540e-02, 5.1240980e-02, 5.7869560e-02, 3.8304410e-02, 4.6072590e-02,
 2.0502690e-02, 5.8070380e-02, 2.6210600e-02, 5.7932060e-02, 6.6070810e-02, 1.0129650e-01, 7.6830870e-02, 9.0350620e-02,
 6.1562050e-02, 1.0446430e-01, 6.1847900e-02, 1.1309360e-01, 8.2179480e-02, 1.0102210e-01, 4.6124250e-02, 1.1437070e-01,
 3.4040660e-02, 1.0494500e-01, 3.2673730e-02, 1.4887860e-01, 7.8035450e-02, 1.3022570e-01, 6.8132240e-02, 1.6517320e-01,
 1.6738290e-02, 1.8905480e-02, 1.1723980e-02, 1.9479940e-02, 2.3943890e-02, 1.9591560e-02, 9.3694210e-03, 2.1110460e-02,
 9.7797000e-03, 2.0068330e-02, 6.5445300e-03, 2.7096400e-02, 1.6956900e-02, 1.8835310e-02, 1.0321890e-02, 2.2737660e-02,
 4.7411360e-02, 6.1349990e-02, 4.4316770e-02, 4.5335520e-02, 7.2584930e-02, 6.8041900e-02, 3.7904110e-02, 5.2581020e-02,
 2.6037210e-02, 6.1211870e-02, 2.3252480e-02, 5.9273430e-02, 3.6584960e-02, 4.6556940e-02, 2.9719200e-02, 4.0307090e-02,
 1.1273400e-02, 1.5178660e-02, 1.1098260e-02, 9.4375560e-03, 2.8514710e-02, 2.7812830e-02, 1.5682770e-02, 1.8084220e-02,
 1.2418660e-02, 3.0378210e-02, 1.1680550e-02, 2.4750760e-02, 2.6790890e-02, 3.5474420e-02, 2.2921120e-02, 2.5841300e-02,
 4.8474670e-02, 7.1041710e-02, 3.5830200e-02, 6.2812420e-02, 5.5310430e-02, 5.8722360e-02, 2.2839970e-02, 5.4295530e-02,
 2.4937560e-02, 6.6399010e-02, 1.7610730e-02, 7.6929700e-02, 3.8270290e-02, 5.5158190e-02, 2.4583570e-02, 5.7136680e-02,
 5.9680930e-02, 7.0830150e-02, 5.3863990e-02, 7.2157270e-02, 1.3669470e-01, 1.1752550e-01, 6.8923720e-02, 1.2520520e-01,
 4.3758440e-02, 9.4352510e-02, 3.7732340e-02, 1.2595510e-01, 1.4162910e-01, 1.6530460e-01, 1.1108730e-01, 1.9729670e-01,
 8.7282280e-02, 1.1867640e-01, 1.0512620e-01, 8.6706190e-02, 2.1395510e-01, 2.1074560e-01, 1.4396650e-01, 1.6101750e-01,
 6.0151990e-02, 1.4859260e-01, 6.9218740e-02, 1.4226020e-01, 1.5777130e-01, 2.1096760e-01, 1.6514350e-01, 1.8058210e-01,
 2.6447510e-02, 3.7417030e-02, 3.3549310e-02, 2.3001550e-02, 1.0711030e-01, 1.0977750e-01, 7.5907380e-02, 7.0571570e-02,
 3.6560840e-02, 9.3974420e-02, 4.4310230e-02, 7.5700350e-02, 1.4723070e-01, 2.0484850e-01, 1.6231030e-01, 1.4753450e-01,
 7.6414680e-02, 1.1767420e-01, 7.2779700e-02, 1.0286680e-01, 1.3960520e-01, 1.5574130e-01, 7.4282920e-02, 1.4237260e-01,
 4.9331890e-02, 1.3801980e-01, 4.4890060e-02, 1.5810140e-01, 1.4132050e-01, 2.1402260e-01, 1.1697350e-01, 2.1919290e-01,
 8.4922740e-02, 8.6986060e-02, 7.0772500e-02, 1.1713340e-01, 1.4060800e-01, 1.0433580e-01, 6.5464320e-02, 1.4692410e-01,
 3.9559920e-02, 7.3619030e-02, 3.1498140e-02, 1.2990370e-01, 1.4389020e-01, 1.4494610e-01, 1.0421270e-01, 2.2867070e-01,
 1.1590920e-01, 1.3601880e-01, 1.2890810e-01, 1.3135720e-01, 2.0539240e-01, 1.7460770e-01, 1.2761470e-01, 1.7633840e-01,
 5.0751270e-02, 1.0820240e-01, 5.3925990e-02, 1.3692810e-01, 1.4959240e-01, 1.7263960e-01, 1.4458420e-01, 1.9532980e-01,
 3.0236790e-02, 3.6920130e-02, 3.5417020e-02, 2.9999920e-02, 8.8522150e-02, 7.8302800e-02, 5.7927190e-02, 6.6536940e-02,
 2.6556580e-02, 5.8912670e-02, 2.9719230e-02, 6.2728670e-02, 1.2018200e-01, 1.4431670e-01, 1.2233890e-01, 1.3738730e-01,
 9.1072640e-02, 1.2104190e-01, 8.0093800e-02, 1.3986160e-01, 1.2027700e-01, 1.1580520e-01, 5.9094580e-02, 1.3993280e-01,
 3.7354590e-02, 9.0198780e-02, 3.1386580e-02, 1.3657280e-01, 1.2025590e-01, 1.5718230e-01, 9.1910730e-02, 2.1278440e-01,
 7.6092050e-02, 1.0495800e-01, 8.7933880e-02, 1.3867640e-01, 1.7056290e-01, 1.7043490e-01, 1.1011730e-01, 2.3549090e-01,
 4.8487120e-02, 1.2150990e-01, 5.3534320e-02, 2.1037730e-01, 1.3827020e-01, 1.8756620e-01, 1.3886550e-01, 2.9034520e-01,
 9.9253600e-02, 1.5684760e-01, 1.5306820e-01, 1.4862400e-01, 2.3810690e-01, 2.7258470e-01, 2.0514680e-01, 2.7011020e-01,
 5.9447140e-02, 1.7067570e-01, 8.7590830e-02, 2.1192540e-01, 1.3737900e-01, 2.1350200e-01, 1.8412300e-01, 2.3702040e-01,
 2.2876800e-02, 3.7616070e-02, 3.7157640e-02, 2.9990680e-02, 9.0671500e-02, 1.0800570e-01, 8.2276850e-02, 9.0050920e-02,
 2.7484480e-02, 8.2105940e-02, 4.2651000e-02, 8.5780370e-02, 9.7517240e-02, 1.5769180e-01, 1.3765220e-01, 1.4729740e-01,
 8.8075200e-02, 1.5763470e-01, 1.0740910e-01, 1.7871900e-01, 1.5747350e-01, 2.0417540e-01, 1.0728750e-01, 2.4207560e-01,
 4.9415750e-02, 1.6068400e-01, 5.7576030e-02, 2.3872170e-01, 1.2472530e-01, 2.1953430e-01, 1.3218760e-01, 2.9160460e-01,
 3.5431310e-02, 4.2209180e-02, 3.0124970e-02, 4.5546610e-02, 6.7885080e-02, 5.8585750e-02, 3.2245410e-02, 6.6110370e-02,
 2.1005290e-02, 4.5462930e-02, 1.7063070e-02, 6.4284590e-02, 4.0100020e-02, 4.6980120e-02, 2.9630090e-02, 5.9393120e-02,
 9.6639160e-02, 1.3189500e-01, 1.0965150e-01, 1.0207080e-01, 1.9816220e-01, 1.9592680e-01, 1.2561340e-01, 1.5856070e-01,
 5.3850810e-02, 1.3352930e-01, 5.8377090e-02, 1.3540980e-01, 8.3309650e-02, 1.1182020e-01, 8.2149590e-02, 1.0138330e-01,
 2.1940010e-02, 3.1157200e-02, 2.6218760e-02, 2.0287730e-02, 7.4328290e-02, 7.6466930e-02, 4.9623070e-02, 5.2068760e-02,
 2.4523550e-02, 6.3272340e-02, 2.7999330e-02, 5.3987020e-02, 5.8249310e-02, 8.1350860e-02, 6.0494380e-02, 6.2059770e-02,
 1.0216150e-01, 1.5791710e-01, 9.1663670e-02, 1.4622110e-01, 1.5612880e-01, 1.7483270e-01, 7.8261310e-02, 1.6929040e-01,
 5.3327770e-02, 1.4976290e-01, 4.5714330e-02, 1.8171290e-01, 9.0106500e-02, 1.3697700e-01, 7.0261090e-02, 1.4859410e-01,
 8.4396490e-02, 1.0564530e-01, 9.2461910e-02, 1.1270970e-01, 2.5890710e-01, 2.3478350e-01, 1.5846620e-01, 2.6194320e-01,
 6.2788140e-02, 1.4279480e-01, 6.5721130e-02, 1.9962910e-01, 2.2375020e-01, 2.7544760e-01, 2.1303490e-01, 3.4428880e-01,
 1.1885280e-01, 1.7044760e-01, 1.7376800e-01, 1.3041450e-01, 3.9022000e-01, 4.0540460e-01, 3.1873070e-01, 3.2437860e-01,
 8.3111350e-02, 2.1654620e-01, 1.1609390e-01, 2.1711310e-01, 2.4001220e-01, 3.3850440e-01, 3.0495960e-01, 3.0343960e-01,
 3.4385800e-02, 5.1310570e-02, 5.2948480e-02, 3.3032680e-02, 1.8652150e-01, 2.0162970e-01, 1.6045650e-01, 1.3574380e-01,
 4.8232240e-02, 1.3075980e-01, 7.0957900e-02, 1.1030910e-01, 2.1385270e-01, 3.1382840e-01, 2.8617920e-01, 2.3670210e-01,
 1.0758750e-01, 1.7474700e-01, 1.2438580e-01, 1.5997520e-01, 2.6326320e-01, 3.0976740e-01, 1.7004080e-01, 2.9655640e-01,
 7.0475770e-02, 2.0796800e-01, 7.7846260e-02, 2.4948240e-01, 2.2228610e-01, 3.5506660e-01, 2.2334190e-01, 3.8082530e-01,
 3.6475680e-01, 3.1457480e-01, 2.7852510e-01, 6.0719290e-01, 5.5294550e-01, 3.4546230e-01, 2.3588340e-01, 6.9731980e-01,
 1.5851570e-01, 2.4837150e-01, 1.1564380e-01, 6.2821030e-01, 5.5523280e-01, 4.7091810e-01, 3.6845530e-01, 1.0649300e+00,
 5.3848970e-01, 5.3205110e-01, 5.4873170e-01, 7.3651260e-01, 8.7364870e-01, 6.2533200e-01, 4.9736310e-01, 9.0524470e-01,
 2.1996010e-01, 3.9484710e-01, 2.1414880e-01, 7.1623600e-01, 6.2435830e-01, 6.0667990e-01, 5.5292390e-01, 9.8391900e-01,
 1.6620880e-01, 1.7087420e-01, 1.7838190e-01, 1.9902390e-01, 4.4551600e-01, 3.3180540e-01, 2.6712480e-01, 4.0414830e-01,
 1.3618460e-01, 2.5436630e-01, 1.3964130e-01, 3.8822960e-01, 5.9350240e-01, 6.0005980e-01, 5.5356430e-01, 8.1883480e-01,
 5.4453870e-01, 6.0935610e-01, 4.3879340e-01, 1.0092670e+00, 6.5844010e-01, 5.3377290e-01, 2.9641600e-01, 9.2452770e-01,
 2.0836380e-01, 4.2361740e-01, 1.6041410e-01, 9.1940960e-01, 6.4596930e-01, 7.1089270e-01, 4.5236820e-01, 1.3794690e+00,
 2.4728760e-01, 2.8719260e-01, 2.6184220e-01, 5.4391640e-01, 5.0750510e-01, 4.2698170e-01, 3.0021460e-01, 8.4566160e-01,
 1.4700320e-01, 3.1017510e-01, 1.4871440e-01, 7.6977910e-01, 4.0369780e-01, 4.6108090e-01, 3.7148600e-01, 1.0230780e+00,
 3.4889080e-01, 4.6421160e-01, 4.9300180e-01, 6.3051990e-01, 7.6631630e-01, 7.3863930e-01, 6.0495240e-01, 1.0491650e+00,
 1.9494480e-01, 4.7124550e-01, 2.6318410e-01, 8.3874590e-01, 4.3383870e-01, 5.6768120e-01, 5.3276550e-01, 9.0335880e-01,
 9.5147500e-02, 1.3172560e-01, 1.4160240e-01, 1.5054110e-01, 3.4527550e-01, 3.4628720e-01, 2.8707340e-01, 4.1385650e-01,
 1.0664170e-01, 2.6823100e-01, 1.5163140e-01, 4.0169280e-01, 3.6437460e-01, 4.9610170e-01, 4.7127030e-01, 6.6424520e-01,
 3.9845390e-01, 6.0044200e-01, 4.4523140e-01, 9.7580240e-01, 6.5226610e-01, 7.1205840e-01, 4.0718020e-01, 1.2101380e+00,
 2.0855820e-01, 5.7099110e-01, 2.2265070e-01, 1.2159630e+00, 5.0692480e-01, 7.5125300e-01, 4.9226630e-01, 1.4303750e+00,
 1.4213170e-01, 1.4256260e-01, 1.1072630e-01, 2.2050910e-01, 2.4932800e-01, 1.8116890e-01, 1.0851380e-01, 2.9304410e-01,
 7.8608590e-02, 1.4324970e-01, 5.8508480e-02, 2.9034540e-01, 1.4451510e-01, 1.4255340e-01, 9.7841210e-02, 2.5832790e-01,
 4.1931190e-01, 4.8184500e-01, 4.3593210e-01, 5.3450550e-01, 7.8722300e-01, 6.5533850e-01, 4.5722870e-01, 7.6021970e-01,
 2.1797860e-01, 4.5508540e-01, 2.1651320e-01, 6.6151270e-01, 3.2474620e-01, 3.6699810e-01, 2.9340970e-01, 4.7695970e-01,
 1.1263660e-01, 1.3467780e-01, 1.2333190e-01, 1.2570220e-01, 3.4937350e-01, 3.0262460e-01, 2.1371740e-01, 2.9537900e-01,
 1.1745290e-01, 2.5514620e-01, 1.2287070e-01, 3.1205880e-01, 2.6865720e-01, 3.1591090e-01, 2.5564830e-01, 3.4544940e-01,
 5.7049600e-01, 7.4248760e-01, 4.6901090e-01, 9.8546700e-01, 7.9825430e-01, 7.5261980e-01, 3.6662800e-01, 1.0446170e+00,
 2.7781530e-01, 6.5690380e-01, 2.1821040e-01, 1.1424970e+00, 4.5204960e-01, 5.7859190e-01, 3.2297220e-01, 8.9970100e-01,
 2.9820570e-01, 3.1429440e-01, 2.9934690e-01, 4.8063940e-01, 8.3758430e-01, 6.3950940e-01, 4.6972260e-01, 1.0227240e+00,
 2.0696970e-01, 3.9631120e-01, 1.9849730e-01, 7.9418100e-01, 7.1026380e-01, 7.3619020e-01, 6.1962280e-01, 1.3190030e+00,
 4.5423570e-01, 5.4847570e-01, 6.0850180e-01, 6.0153950e-01, 1.3654450e+00, 1.1943960e+00, 1.0219010e+00, 1.3698830e+00,
 2.9632590e-01, 6.5006200e-01, 3.7926190e-01, 9.3424750e-01, 8.2408070e-01, 9.7857820e-01, 9.5939870e-01, 1.2574050e+00,
 1.5549260e-01, 1.9535850e-01, 2.1938380e-01, 1.8027730e-01, 7.7224050e-01, 7.0286650e-01, 6.0869730e-01, 6.7828170e-01,
 2.0347250e-01, 4.6444800e-01, 2.7427700e-01, 5.6162470e-01, 8.6878070e-01, 1.0734510e+00, 1.0652550e+00, 1.1605500e+00,
 5.2919410e-01, 7.2369830e-01, 5.6058860e-01, 9.4966920e-01, 1.1855940e+00, 1.1745630e+00, 7.0164820e-01, 1.6118320e+00,
 3.2339280e-01, 8.0349270e-01, 3.2730200e-01, 1.3816470e+00, 9.8226810e-01, 1.3210590e+00, 9.0429090e-01, 2.0310010e+00,
 4.6140950e-01, 5.2586200e-01, 3.1935080e-01, 6.4072230e-01, 9.3633920e-01, 7.7306550e-01, 3.6205020e-01, 9.8501510e-01,
 2.7567620e-01, 5.7081260e-01, 1.8229290e-01, 9.1136430e-01, 1.0891300e+00, 1.2207160e+00, 6.5510360e-01, 1.7425520e+00,
 7.4048370e-01, 9.6684370e-01, 6.8394110e-01, 8.4484750e-01, 1.6082100e+00, 1.5211820e+00, 8.2985060e-01, 1.3900550e+00,
 4.1583960e-01, 9.8645130e-01, 3.6695940e-01, 1.1295310e+00, 1.3313540e+00, 1.7095580e+00, 1.0686740e+00, 1.7501650e+00,
 1.9456660e-01, 2.6433540e-01, 1.8927160e-01, 1.9434770e-01, 6.9814420e-01, 6.8711600e-01, 3.7941680e-01, 5.2830250e-01,
 2.1917250e-01, 5.4098120e-01, 2.0370060e-01, 5.2120260e-01, 1.0773530e+00, 1.4394440e+00, 9.1080240e-01, 1.2399150e+00,
 6.8828550e-01, 1.0178310e+00, 5.0271350e-01, 1.0641580e+00, 1.1140990e+00, 1.1935180e+00, 4.5460050e-01, 1.3049310e+00,
 3.6208120e-01, 9.7279710e-01, 2.5266610e-01, 1.3327620e+00, 1.2661150e+00, 1.8413240e+00, 8.0366280e-01, 2.2554500e+00,
 4.3964790e-01, 6.7474670e-01, 4.2195180e-01, 8.0666800e-01, 1.2078440e+00, 1.3429020e+00, 6.4762370e-01, 1.6789090e+00,
 3.5931330e-01, 1.0018860e+00, 3.2947320e-01, 1.5695410e+00, 1.1129620e+00, 1.6798320e+00, 9.2829740e-01, 2.3528430e+00,
 6.7429060e-01, 1.1856010e+00, 8.6362790e-01, 1.0165210e+00, 1.9825920e+00, 2.5253560e+00, 1.4186230e+00, 2.2642750e+00,
 5.1798010e-01, 1.6546780e+00, 6.3384290e-01, 1.8590530e+00, 1.3001910e+00, 2.2482690e+00, 1.4472240e+00, 2.2583920e+00,
 1.5654210e-01, 2.8639710e-01, 2.1116640e-01, 2.0660870e-01, 7.6044380e-01, 1.0078660e+00, 5.7307950e-01, 7.6034580e-01,
 2.4121510e-01, 8.0177250e-01, 3.1087600e-01, 7.5793430e-01, 9.2961500e-01, 1.6725940e+00, 1.0897970e+00, 1.4136550e+00,
 7.0784390e-01, 1.4095980e+00, 7.1691190e-01, 1.4460430e+00, 1.5511430e+00, 2.2377290e+00, 8.7767620e-01, 2.4006130e+00,
 5.0936660e-01, 1.8428810e+00, 4.9288750e-01, 2.4773290e+00, 1.3964470e+00, 2.7348390e+00, 1.2291400e+00, 3.2869330e+00,
 2.3435830e-01, 3.1064170e-01, 1.6548580e-01, 3.0330240e-01, 5.5033630e-01, 5.2845180e-01, 2.1710140e-01, 5.3957280e-01,
 1.7819810e-01, 4.2913260e-01, 1.2021880e-01, 5.4904510e-01, 3.6950800e-01, 4.8167370e-01, 2.2675300e-01, 5.5098790e-01,
 7.5159090e-01, 1.1413440e+00, 7.0824520e-01, 7.9920190e-01, 1.8889030e+00, 2.0779850e+00, 9.9441120e-01, 1.5216370e+00,
 5.3715780e-01, 1.4819920e+00, 4.8360750e-01, 1.3598350e+00, 9.0262990e-01, 1.3480140e+00, 7.3919790e-01, 1.1058780e+00,
 1.7187000e-01, 2.7156970e-01, 1.7057540e-01, 1.6000120e-01, 7.1363810e-01, 8.1687780e-01, 3.9568390e-01, 5.0330090e-01,
 2.4639270e-01, 7.0732340e-01, 2.3363240e-01, 5.4608540e-01, 6.3568230e-01, 9.8780470e-01, 5.4828360e-01, 6.8184570e-01,
 9.3993680e-01, 1.6165910e+00, 7.0040550e-01, 1.3544040e+00, 1.7605770e+00, 2.1935840e+00, 7.3292580e-01, 1.9219010e+00,
 6.2928310e-01, 1.9663300e+00, 4.4800820e-01, 2.1587630e+00, 1.1549240e+00, 1.9534600e+00, 7.4791670e-01, 1.9174570e+00,
 3.8195220e-01, 5.3197890e-01, 3.4752690e-01, 5.1353780e-01, 1.4361150e+00, 1.4490140e+00, 7.2999980e-01, 1.4627800e+00,
 3.6445470e-01, 9.2222720e-01, 3.1681950e-01, 1.1665850e+00, 1.4106980e+00, 1.9322760e+00, 1.1154810e+00, 2.1853460e+00,
 6.3245450e-01, 1.0091840e+00, 7.6794560e-01, 6.9867020e-01, 2.5450130e+00, 2.9419060e+00, 1.7264150e+00, 2.1299000e+00,
 5.6723290e-01, 1.6444150e+00, 6.5803890e-01, 1.4918110e+00, 1.7792590e+00, 2.7920920e+00, 1.8775400e+00, 2.2646690e+00,
 1.8430360e-01, 3.0599980e-01, 2.3569430e-01, 1.7824820e-01, 1.2253050e+00, 1.4737690e+00, 8.7541430e-01, 8.9776330e-01,
 3.3156860e-01, 1.0001600e+00, 4.0511440e-01, 7.6343850e-01, 1.5968190e+00, 2.6073090e+00, 1.7746780e+00, 1.7793830e+00,
 6.7727450e-01, 1.2239740e+00, 6.5030130e-01, 1.0138700e+00, 2.0312040e+00, 2.6592480e+00, 1.0895760e+00, 2.3035480e+00,
 5.6901530e-01, 1.8682730e+00, 5.2199070e-01, 2.0279200e+00, 1.9494010e+00, 3.4646420e+00, 1.6266720e+00, 3.3623370e+00,
 2.0167930e-01, 1.9585910e-01, 1.3846060e-01, 2.5184060e-01, 3.1889950e-01, 2.2435420e-01, 1.2231310e-01, 3.0167870e-01,
 1.0973870e-01, 1.9362040e-01, 7.1980300e-02, 3.2623720e-01, 3.8921070e-01, 3.7172090e-01, 2.3221950e-01, 5.5997930e-01,
 3.2466010e-01, 3.6121590e-01, 2.9745110e-01, 3.3309860e-01, 5.4941680e-01, 4.4283080e-01, 2.8121780e-01, 4.2704370e-01,
 1.6604470e-01, 3.3563860e-01, 1.4534520e-01, 4.0558160e-01, 4.7724040e-01, 5.2218560e-01, 3.7999050e-01, 5.6416200e-01,
 9.5868120e-02, 1.1098350e-01, 9.2507100e-02, 8.6112560e-02, 2.6803840e-01, 2.2479110e-01, 1.4449470e-01, 1.8239620e-01,
 9.8350750e-02, 2.0685740e-01, 9.0670820e-02, 2.1031940e-01, 4.3400470e-01, 4.9411550e-01, 3.6395200e-01, 4.4916860e-01,
 2.8390880e-01, 3.5775310e-01, 2.0569060e-01, 3.9472750e-01, 3.5808000e-01, 3.2687550e-01, 1.4493380e-01, 3.7715940e-01,
 1.3601970e-01, 3.1139770e-01, 9.4151320e-02, 4.5022520e-01, 4.2698620e-01, 5.2913690e-01, 2.6884260e-01, 6.8399820e-01,
 4.2352850e-01, 5.5387990e-01, 4.0320320e-01, 6.9880110e-01, 9.0663900e-01, 8.5894480e-01, 4.8220300e-01, 1.1332660e+00,
 3.1523660e-01, 7.4899460e-01, 2.8672600e-01, 1.2382750e+00, 8.7657380e-01, 1.1273820e+00, 7.2523500e-01, 1.6664110e+00,
 6.5157350e-01, 9.7622950e-01, 8.2780210e-01, 8.8331150e-01, 1.4927790e+00, 1.6202500e+00, 1.0595290e+00, 1.5331070e+00,
 4.5584280e-01, 1.2408310e+00, 5.5330830e-01, 1.4712110e+00, 1.0271980e+00, 1.5135340e+00, 1.1341380e+00, 1.6044540e+00,
 1.6999650e-01, 2.6501770e-01, 2.2746640e-01, 2.0176170e-01, 6.4346060e-01, 7.2669910e-01, 4.8100910e-01, 5.7855830e-01,
 2.3856080e-01, 6.7568290e-01, 3.0497570e-01, 6.7407350e-01, 8.2535820e-01, 1.2653980e+00, 9.5977310e-01, 1.1286620e+00,
 6.4350310e-01, 1.0919570e+00, 6.4649110e-01, 1.1821580e+00, 1.0987810e+00, 1.3507150e+00, 6.1670430e-01, 1.5291930e+00,
 4.2172500e-01, 1.3001500e+00, 4.0479040e-01, 1.8444370e+00, 1.0379300e+00, 1.7320990e+00, 9.0620960e-01, 2.1969270e+00,
 2.0722210e-01, 2.3405210e-01, 1.4514430e-01, 2.4116410e-01, 3.7916630e-01, 3.1024460e-01, 1.4837060e-01, 3.3429720e-01,
 1.4349750e-01, 2.9446250e-01, 9.6027890e-02, 3.9758540e-01, 2.6712220e-01, 2.9671280e-01, 1.6260080e-01, 3.5818650e-01,
 6.6661610e-01, 8.6259690e-01, 6.2310540e-01, 6.3742920e-01, 1.3054190e+00, 1.2237140e+00, 6.8169460e-01, 9.4565450e-01,
 4.3389220e-01, 1.0200530e+00, 3.8748650e-01, 9.8775080e-01, 6.5453740e-01, 8.3294490e-01, 5.3170290e-01, 7.2112950e-01,
 1.7131160e-01, 2.3065630e-01, 1.6865020e-01, 1.4341390e-01, 5.5425650e-01, 5.4061380e-01, 3.0483500e-01, 3.5151320e-01,
 2.2366620e-01, 5.4712660e-01, 2.1037260e-01, 4.4577350e-01, 5.1803300e-01, 6.8593920e-01, 4.4320650e-01, 4.9967150e-01,
 7.8431380e-01, 1.1494460e+00, 5.7972800e-01, 1.0162970e+00, 1.1447010e+00, 1.2153140e+00, 4.7269470e-01, 1.1236970e+00,
 4.7821470e-01, 1.2732990e+00, 3.3771190e-01, 1.4752410e+00, 7.8790730e-01, 1.1355950e+00, 5.0612570e-01, 1.1763280e+00,
 4.6404430e-01, 5.5073420e-01, 4.1881510e-01, 5.6105310e-01, 1.3595200e+00, 1.1688690e+00, 6.8549240e-01, 1.2452500e+00,
 4.0325480e-01, 8.6950320e-01, 3.4772150e-01, 1.1607360e+00, 1.4012480e+00, 1.6354880e+00, 1.0990730e+00, 1.9520100e+00,
 7.7075850e-01, 1.0479880e+00, 9.2833140e-01, 7.6567130e-01, 2.4167120e+00, 2.3804600e+00, 1.6261620e+00, 1.8187600e+00,
 6.2955860e-01, 1.5551890e+00, 7.2445240e-01, 1.4889140e+00, 1.7727950e+00, 2.3705350e+00, 1.8556330e+00, 2.0291090e+00,
 2.5241520e-01, 3.5710830e-01, 3.2019480e-01, 2.1952690e-01, 1.3075910e+00, 1.3401520e+00, 9.2666930e-01, 8.6153030e-01,
 4.1356210e-01, 1.0630020e+00, 5.0122020e-01, 8.5629320e-01, 1.7880000e+00, 2.4877220e+00, 1.9711300e+00, 1.7916890e+00,
 7.7651650e-01, 1.1957910e+00, 7.3957820e-01, 1.0453200e+00, 1.8146190e+00, 2.0243600e+00, 9.6554590e-01, 1.8505900e+00,
 5.9414920e-01, 1.6622990e+00, 5.4065210e-01, 1.9041600e+00, 1.8273320e+00, 2.7674000e+00, 1.5125150e+00, 2.8342540e+00,
 4.6286180e-01, 4.7410770e-01, 3.8573750e-01, 6.3842230e-01, 9.8027410e-01, 7.2739620e-01, 4.5639640e-01, 1.0243080e+00,
 2.5555050e-01, 4.7556660e-01, 2.0347270e-01, 8.3915620e-01, 9.9792270e-01, 1.0052460e+00, 7.2274690e-01, 1.5859020e+00,
 7.1748630e-01, 8.4196650e-01, 7.9795040e-01, 8.1311100e-01, 1.6262610e+00, 1.3825130e+00, 1.0104310e+00, 1.3962170e+00,
 3.7233730e-01, 7.9382860e-01, 3.9562870e-01, 1.0045750e+00, 1.1782670e+00, 1.3597990e+00, 1.1388200e+00, 1.5385190e+00,
 2.0228790e-01, 2.4700030e-01, 2.3694430e-01, 2.0070320e-01, 7.5752380e-01, 6.7007220e-01, 4.9570900e-01, 5.6938650e-01,
 2.1057180e-01, 4.6712900e-01, 2.3564900e-01, 4.9738670e-01, 1.0230860e+00, 1.2285400e+00, 1.0414470e+00, 1.1695510e+00,
 6.4873200e-01, 8.6220980e-01, 5.7052710e-01, 9.9626760e-01, 1.0958980e+00, 1.0551530e+00, 5.3843730e-01, 1.2749910e+00,
 3.1536630e-01, 7.6150360e-01, 2.6498130e-01, 1.1530160e+00, 1.0899890e+00, 1.4246870e+00, 8.3307100e-01, 1.9286600e+00,
 4.0231010e-01, 5.5492870e-01, 4.6491960e-01, 7.3320290e-01, 1.1534970e+00, 1.1526310e+00, 7.4471020e-01, 1.5925970e+00,
 3.0383790e-01, 7.6142500e-01, 3.3546550e-01, 1.3183010e+00, 9.3022670e-01, 1.2618700e+00, 9.3423160e-01, 1.9533260e+00,
 5.9598640e-01, 9.4182030e-01, 9.1912590e-01, 8.9244010e-01, 1.8288250e+00, 2.0936390e+00, 1.5756690e+00, 2.0746330e+00,
 4.2307260e-01, 1.2146630e+00, 6.2336530e-01, 1.5082280e+00, 1.0496610e+00, 1.6312870e+00, 1.4068130e+00, 1.8109830e+00,
 1.4846490e-01, 2.4411920e-01, 2.4114410e-01, 1.9463230e-01, 7.5267830e-01, 8.9657220e-01, 6.8299300e-01, 7.4752680e-01,
 2.1140240e-01, 6.3153430e-01, 3.2805880e-01, 6.5979690e-01, 8.0528260e-01, 1.3021950e+00, 1.1367110e+00, 1.2163600e+00,
 6.0859070e-01, 1.0892400e+00, 7.4218590e-01, 1.2349300e+00, 1.3918400e+00, 1.8046180e+00, 9.4826720e-01, 2.1396010e+00,
 4.0469790e-01, 1.3159460e+00, 4.7152780e-01, 1.9550490e+00, 1.0966410e+00, 1.9302450e+00, 1.1622530e+00, 2.5639200e+00,
 2.8996550e-01, 3.4543480e-01, 2.4653910e-01, 3.7274790e-01, 7.1063000e-01, 6.1328340e-01, 3.3754930e-01, 6.9205210e-01,
 2.0374250e-01, 4.4097140e-01, 1.6550460e-01, 6.2353360e-01, 4.1758230e-01, 4.8922840e-01, 3.0855350e-01, 6.1849140e-01,
 8.9821580e-01, 1.2259030e+00, 1.0191590e+00, 9.4870030e-01, 2.3559080e+00, 2.3293330e+00, 1.4933920e+00, 1.8850950e+00,
 5.9321700e-01, 1.4709500e+00, 6.4307830e-01, 1.4916650e+00, 9.8528360e-01, 1.3224710e+00, 9.7156380e-01, 1.1990360e+00,
 2.2039550e-01, 3.1298560e-01, 2.6337710e-01, 2.0379780e-01, 9.5505900e-01, 9.8253870e-01, 6.3761670e-01, 6.6904180e-01,
 2.9197330e-01, 7.5331000e-01, 3.3335540e-01, 6.4276050e-01, 7.4455230e-01, 1.0398400e+00, 7.7324900e-01, 7.9325810e-01,
 1.0926890e+00, 1.6890330e+00, 9.8040700e-01, 1.5639370e+00, 2.1360050e+00, 2.3918940e+00, 1.0706960e+00, 2.3160690e+00,
 6.7601510e-01, 1.8984850e+00, 5.7950250e-01, 2.3035020e+00, 1.2263200e+00, 1.8642110e+00, 9.5623020e-01, 2.0223170e+00,
 4.3379280e-01, 5.4301040e-01, 4.7524860e-01, 5.7932080e-01, 1.7022060e+00, 1.5436030e+00, 1.0418490e+00, 1.7221670e+00,
 3.8249820e-01, 8.6988980e-01, 4.0036570e-01, 1.2161180e+00, 1.4633890e+00, 1.8015040e+00, 1.3933080e+00, 2.2517450e+00,
 6.9380250e-01, 9.9498650e-01, 1.0143690e+00, 7.6129350e-01, 2.9137080e+00, 3.0270890e+00, 2.3799090e+00, 2.4220810e+00,
 5.7501690e-01, 1.4982040e+00, 8.0321130e-01, 1.5021260e+00, 1.7827810e+00, 2.5143690e+00, 2.2652030e+00, 2.2539120e+00,
 2.1694220e-01, 3.2372160e-01, 3.3405530e-01, 2.0840520e-01, 1.5052340e+00, 1.6271570e+00, 1.2948880e+00, 1.0954560e+00,
 3.6065850e-01, 9.7776120e-01, 5.3059050e-01, 8.2484080e-01, 1.7167940e+00, 2.5193900e+00, 2.2974240e+00, 1.9002260e+00,
 7.2271970e-01, 1.1738640e+00, 8.3556230e-01, 1.0746340e+00, 2.2620810e+00, 2.6616680e+00, 1.4610710e+00, 2.5481520e+00,
 5.6110180e-01, 1.6557640e+00, 6.1978290e-01, 1.9862860e+00, 1.9000230e+00, 3.0349830e+00, 1.9090470e+00, 3.2551590e+00,
 4.6060800e-02, 3.9723910e-02, 3.5171620e-02, 7.6675180e-02, 6.4326020e-02, 4.0188800e-02, 2.7441110e-02, 8.1121570e-02,
 1.8605030e-02, 2.9151420e-02, 1.3573130e-02, 7.3733180e-02, 5.5729100e-02, 4.7266370e-02, 3.6982120e-02, 1.0688780e-01,
 6.4926770e-02, 6.4150460e-02, 6.6161670e-02, 8.8802790e-02, 9.7041940e-02, 6.9459760e-02, 5.5245410e-02, 1.0055150e-01,
 2.4650190e-02, 4.4249180e-02, 2.3998930e-02, 8.0266150e-02, 5.9835520e-02, 5.8141300e-02, 5.2989590e-02, 9.4294100e-02,
 2.1931130e-02, 2.2546720e-02, 2.3537360e-02, 2.6261050e-02, 5.4155980e-02, 4.0333560e-02, 3.2471120e-02, 4.9127410e-02,
 1.6701860e-02, 3.1195800e-02, 1.7125790e-02, 4.7612980e-02, 6.2245530e-02, 6.2933260e-02, 5.8056890e-02, 8.5878010e-02,
 5.8615260e-02, 6.5592340e-02, 4.7232620e-02, 1.0863960e-01, 6.5294180e-02, 5.2931570e-02, 2.9394080e-02, 9.1680740e-02,
 2.0846550e-02, 4.2382400e-02, 1.6049240e-02, 9.1985810e-02, 5.5267850e-02, 6.0822570e-02, 3.8703720e-02, 1.1802460e-01,
 4.3014860e-02, 4.9956210e-02, 4.5546580e-02, 9.4612460e-02, 8.1326650e-02, 6.8422940e-02, 4.8108770e-02, 1.3551550e-01,
 2.3766920e-02, 5.0147920e-02, 2.4043580e-02, 1.2445490e-01, 5.5815060e-02, 6.3748810e-02, 5.1361470e-02, 1.4145030e-01,
 5.7946070e-02, 7.7099310e-02, 8.1880970e-02, 1.0472090e-01, 1.1725160e-01, 1.1301680e-01, 9.2561830e-02, 1.6052940e-01,
 3.0093730e-02, 7.2746400e-02, 4.0627860e-02, 1.2947760e-01, 5.7271900e-02, 7.4940710e-02, 7.0331420e-02, 1.1925420e-01,
 1.7293880e-02, 2.3942260e-02, 2.5737450e-02, 2.7362140e-02, 5.7814520e-02, 5.7983930e-02, 4.8068900e-02, 6.9298040e-02,
 1.8015730e-02, 4.5314140e-02, 2.5616160e-02, 6.7860790e-02, 5.2640730e-02, 7.1671160e-02, 6.8083810e-02, 9.5962640e-02,
 5.9081040e-02, 8.9030970e-02, 6.6017010e-02, 1.4468780e-01, 8.9098640e-02, 9.7266180e-02, 5.5620240e-02, 1.6530320e-01,
 2.8742680e-02, 7.8691750e-02, 3.0684840e-02, 1.6757930e-01, 5.9743730e-02, 8.8539090e-02, 5.8016150e-02, 1.6857720e-01,
 2.1898230e-02, 2.1964620e-02, 1.7059600e-02, 3.3973830e-02, 3.5388760e-02, 2.5714480e-02, 1.5402080e-02, 4.1593660e-02,
 1.1256870e-02, 2.0513580e-02, 8.3785060e-03, 4.1577910e-02, 1.7697420e-02, 1.7457180e-02, 1.1981700e-02, 3.1635010e-02,
 6.1684130e-02, 7.0883240e-02, 6.4129090e-02, 7.8630030e-02, 1.0668670e-01, 8.8813330e-02, 6.1964930e-02, 1.0302710e-01,
 2.9804360e-02, 6.2224150e-02, 2.9604000e-02, 9.0449100e-02, 3.7971610e-02, 4.2912010e-02, 3.4307530e-02, 5.5769490e-02,
 1.8133280e-02, 2.1681680e-02, 1.9855100e-02, 2.0236700e-02, 5.1815890e-02, 4.4882520e-02, 3.1696610e-02, 4.3807920e-02,
 1.7574790e-02, 3.8178220e-02, 1.8385480e-02, 4.6694200e-02, 3.4377470e-02, 4.0424070e-02, 3.2712860e-02, 4.4203830e-02,
 7.4924590e-02, 9.7512650e-02, 6.1596310e-02, 1.2942370e-01, 9.6580460e-02, 9.1059170e-02, 4.4358180e-02, 1.2638780e-01,
 3.3912350e-02, 8.0186900e-02, 2.6636500e-02, 1.3946230e-01, 4.7188550e-02, 6.0398050e-02, 3.3714430e-02, 9.3917990e-02,
 3.6721160e-02, 3.8702320e-02, 3.6861690e-02, 5.9186100e-02, 9.5017830e-02, 7.2547680e-02, 5.3286600e-02, 1.1602050e-01,
 2.3688460e-02, 4.5359320e-02, 2.2718760e-02, 9.0897030e-02, 6.9518250e-02, 7.2055830e-02, 6.0646600e-02, 1.2909960e-01,
 5.3407220e-02, 6.4487580e-02, 7.1545210e-02, 7.0726610e-02, 1.4790030e-01, 1.2937280e-01, 1.1068880e-01, 1.4838100e-01,
 3.2383080e-02, 7.1040050e-02, 4.1446480e-02, 1.0209640e-01, 7.7013550e-02, 9.1451950e-02, 8.9659550e-02, 1.1750940e-01,
 2.0007320e-02, 2.5136880e-02, 2.8228230e-02, 2.3196380e-02, 9.1539370e-02, 8.3315960e-02, 7.2153390e-02, 8.0401750e-02,
 2.4334060e-02, 5.5545140e-02, 3.2801840e-02, 6.7166880e-02, 8.8852180e-02, 1.0978430e-01, 1.0894610e-01, 1.1869210e-01,
 5.5548090e-02, 7.5964680e-02, 5.8843490e-02, 9.9684250e-02, 1.1464800e-01, 1.1358130e-01, 6.7850000e-02, 1.5586560e-01,
 3.1551090e-02, 7.8390960e-02, 3.1932480e-02, 1.3479730e-01, 8.1952650e-02, 1.1021870e-01, 7.5446850e-02, 1.6945060e-01,
 1.9451070e-01, 2.2168120e-01, 1.3462480e-01, 2.7010150e-01, 3.6363570e-01, 3.0022690e-01, 1.4060540e-01, 3.8253940e-01,
 1.0801550e-01, 2.2365590e-01, 7.1426040e-02, 3.5709100e-01, 3.6493500e-01, 4.0902560e-01, 2.1950570e-01, 5.8387720e-01,
 2.9805120e-01, 3.8916310e-01, 2.7529230e-01, 3.4005850e-01, 5.9634040e-01, 5.6406980e-01, 3.0771700e-01, 5.1544630e-01,
 1.5557190e-01, 3.6904630e-01, 1.3728500e-01, 4.2257450e-01, 4.2593910e-01, 5.4693790e-01, 3.4190030e-01, 5.5992910e-01,
 8.5704580e-02, 1.1643700e-01, 8.3372220e-02, 8.5608170e-02, 2.8330690e-01, 2.7883170e-01, 1.5396730e-01, 2.1438510e-01,
 8.9732890e-02, 2.2148680e-01, 8.3398450e-02, 2.1338910e-01, 3.7720080e-01, 5.0397550e-01, 3.1888840e-01, 4.3411660e-01,
 2.4733150e-01, 3.6575200e-01, 1.8064730e-01, 3.8239910e-01, 3.6881710e-01, 3.9510820e-01, 1.5049320e-01, 4.3199100e-01,
 1.2093350e-01, 3.2490990e-01, 8.4389350e-02, 4.4513680e-01, 3.6162860e-01, 5.2592010e-01, 2.2954270e-01, 6.4420310e-01,
 2.5529960e-01, 3.9181940e-01, 2.4502360e-01, 4.6842490e-01, 6.4614830e-01, 7.1839920e-01, 3.4645290e-01, 8.9814910e-01,
 1.9393150e-01, 5.4074580e-01, 1.7782590e-01, 8.4712510e-01, 5.1369390e-01, 7.7533590e-01, 4.2846070e-01, 1.0859680e+00,
 3.7386130e-01, 6.5735780e-01, 4.7883970e-01, 5.6361150e-01, 1.0126820e+00, 1.2899180e+00, 7.2461410e-01, 1.1565620e+00,
 2.6693550e-01, 8.5272040e-01, 3.2664420e-01, 9.5804320e-01, 5.7299330e-01, 9.9081040e-01, 6.3779030e-01, 9.9527140e-01,
 9.4984980e-02, 1.7377710e-01, 1.2812940e-01, 1.2536390e-01, 4.2507660e-01, 5.6338170e-01, 3.2034290e-01, 4.2502190e-01,
 1.3603740e-01, 4.5217330e-01, 1.7532380e-01, 4.2744990e-01, 4.4833830e-01, 8.0666500e-01, 5.2559150e-01, 6.8178300e-01,
 3.5037770e-01, 6.9774100e-01, 3.5486630e-01, 7.1578120e-01, 7.0733820e-01, 1.0204290e+00, 4.0022990e-01, 1.0947060e+00,
 2.3434700e-01, 8.4786380e-01, 2.2676530e-01, 1.1397580e+00, 5.4941700e-01, 1.0759930e+00, 4.8359210e-01, 1.2932090e+00,
 1.2053890e-01, 1.5977420e-01, 8.5115310e-02, 1.5599940e-01, 2.6076620e-01, 2.5039670e-01, 1.0286930e-01, 2.5566610e-01,
 8.5188270e-02, 2.0514840e-01, 5.7471060e-02, 2.6247310e-01, 1.5106000e-01, 1.9691490e-01, 9.2699790e-02, 2.2525150e-01,
 3.6910220e-01, 5.6050770e-01, 3.4781540e-01, 3.9248380e-01, 8.5457700e-01, 9.4012130e-01, 4.4989110e-01, 6.8841860e-01,
 2.4518670e-01, 6.7645790e-01, 2.2074350e-01, 6.2069930e-01, 3.5233330e-01, 5.2618480e-01, 2.8853910e-01, 4.3166950e-01,
 9.2368870e-02, 1.4595090e-01, 9.1673100e-02, 8.5990210e-02, 3.5332950e-01, 4.0444450e-01, 1.9590710e-01, 2.4918940e-01,
 1.2307880e-01, 3.5332430e-01, 1.1670480e-01, 2.7278220e-01, 2.7154670e-01, 4.2196410e-01, 2.3421230e-01, 2.9126650e-01,
 4.1209690e-01, 7.0876260e-01, 3.0707910e-01, 5.9381190e-01, 7.1110220e-01, 8.8599490e-01, 2.9603090e-01, 7.7626120e-01,
 2.5643460e-01, 8.0128500e-01, 1.8256460e-01, 8.7970190e-01, 4.0246960e-01, 6.8074450e-01, 2.6063500e-01, 6.6819810e-01,
 1.5701400e-01, 2.1868740e-01, 1.4286230e-01, 2.1110660e-01, 5.4386960e-01, 5.4875440e-01, 2.7645750e-01, 5.5396790e-01,
 1.3925240e-01, 3.5236850e-01, 1.2105170e-01, 4.4573370e-01, 4.6093770e-01, 6.3136040e-01, 3.6447720e-01, 7.1404940e-01,
 2.4824290e-01, 3.9611180e-01, 3.0142410e-01, 2.7423300e-01, 9.2026690e-01, 1.0637820e+00, 6.2426510e-01, 7.7016380e-01,
 2.0693730e-01, 5.9991370e-01, 2.4006510e-01, 5.4424090e-01, 5.5509270e-01, 8.7107610e-01, 5.8575430e-01, 7.0653070e-01,
 7.9166580e-02, 1.3144050e-01, 1.0124120e-01, 7.6565500e-02, 4.8487370e-01, 5.8319480e-01, 3.4641600e-01, 3.5525990e-01,
 1.3237660e-01, 3.9930760e-01, 1.6173930e-01, 3.0479790e-01, 5.4518310e-01, 8.9018310e-01, 6.0590770e-01, 6.0751400e-01,
 2.3732740e-01, 4.2889920e-01, 2.2787560e-01, 3.5527550e-01, 6.5571170e-01, 8.5845620e-01, 3.5173610e-01, 7.4362960e-01,
 1.8532620e-01, 6.0848980e-01, 1.7001050e-01, 6.6048610e-01, 5.4295410e-01, 9.6498430e-01, 4.5306640e-01, 9.3649010e-01,
 6.7988180e-02, 6.6026130e-02, 4.6676510e-02, 8.4898080e-02, 9.9038080e-02, 6.9675900e-02, 3.7985810e-02, 9.3689960e-02,
 3.4384410e-02, 6.0667080e-02, 2.2553590e-02, 1.0221990e-01, 1.0428830e-01, 9.9601970e-02, 6.2222800e-02, 1.5004550e-01,
 1.0450070e-01, 1.1626720e-01, 9.5742790e-02, 1.0721690e-01, 1.6291780e-01, 1.3131200e-01, 8.3389140e-02, 1.2663070e-01,
 4.9675830e-02, 1.0041350e-01, 4.3483140e-02, 1.2133850e-01, 1.2209740e-01, 1.3359620e-01, 9.7216950e-02, 1.4433550e-01,
 3.3769540e-02, 3.9093940e-02, 3.2585620e-02, 3.0333140e-02, 8.6980960e-02, 7.2946820e-02, 4.6889880e-02, 5.9189250e-02,
 3.2200190e-02, 6.7725430e-02, 2.9685770e-02, 6.8858900e-02, 1.2151340e-01, 1.3834330e-01, 1.0189990e-01, 1.2575900e-01,
 8.1583980e-02, 1.0280380e-01, 5.9107190e-02, 1.1342880e-01, 9.4794310e-02, 8.6533560e-02, 3.8368240e-02, 9.9845180e-02,
 3.6329360e-02, 8.3170870e-02, 2.5146770e-02, 1.2025010e-01, 9.7525590e-02, 1.2085730e-01, 6.1404880e-02, 1.5622830e-01,
 1.9667210e-01, 2.5720290e-01, 1.8723380e-01, 3.2449940e-01, 3.8785630e-01, 3.6745290e-01, 2.0628440e-01, 4.8480630e-01,
 1.3605880e-01, 3.2327250e-01, 1.2375340e-01, 5.3445000e-01, 3.2353970e-01, 4.1611200e-01, 2.6768110e-01, 6.1506520e-01,
 2.8889630e-01, 4.3284310e-01, 3.6703300e-01, 3.9164480e-01, 6.0974810e-01, 6.6181530e-01, 4.3278050e-01, 6.2622050e-01,
 1.8785530e-01, 5.1135320e-01, 2.2802140e-01, 6.0629400e-01, 3.6200230e-01, 5.3339580e-01, 3.9969000e-01, 5.6543740e-01,
 8.2485750e-02, 1.2859200e-01, 1.1037130e-01, 9.7898880e-02, 2.8763200e-01, 3.2484030e-01, 2.1501490e-01, 2.5862010e-01,
 1.0758900e-01, 3.0472760e-01, 1.3754160e-01, 3.0400170e-01, 3.1831730e-01, 4.8802810e-01, 3.7015730e-01, 4.3529300e-01,
 2.5472100e-01, 4.3223480e-01, 2.5590370e-01, 4.6793950e-01, 4.0068340e-01, 4.9255440e-01, 2.2488850e-01, 5.5763840e-01,
 1.5515770e-01, 4.7834060e-01, 1.4892720e-01, 6.7859030e-01, 3.2655840e-01, 5.4496110e-01, 2.8511590e-01, 6.9120750e-01,
 8.5231080e-02, 9.6266370e-02, 5.9698300e-02, 9.9191540e-02, 1.4367060e-01, 1.1755540e-01, 5.6219380e-02, 1.2666920e-01,
 5.4857520e-02, 1.1256980e-01, 3.6710400e-02, 1.5199250e-01, 8.7327430e-02, 9.7001170e-02, 5.3157370e-02, 1.1709810e-01,
 2.6179180e-01, 3.3875690e-01, 2.4470440e-01, 2.5032960e-01, 4.7228760e-01, 4.4272740e-01, 2.4663020e-01, 3.4212830e-01,
 1.5837690e-01, 3.7233430e-01, 1.4143820e-01, 3.6054330e-01, 2.0431180e-01, 2.6000120e-01, 1.6596940e-01, 2.2509830e-01,
 7.3625390e-02, 9.9130230e-02, 7.2481550e-02, 6.1635670e-02, 2.1944610e-01, 2.1404450e-01, 1.2069290e-01, 1.3917420e-01,
 8.9345140e-02, 2.1855380e-01, 8.4034910e-02, 1.7806760e-01, 1.7696070e-01, 2.3431770e-01, 1.5139990e-01, 1.7068840e-01,
 2.7498290e-01, 4.0299930e-01, 2.0325450e-01, 3.5631680e-01, 3.6972960e-01, 3.9253700e-01, 1.5267670e-01, 3.6294530e-01,
 1.5583630e-01, 4.1493130e-01, 1.1005050e-01, 4.8073820e-01, 2.1956830e-01, 3.1645940e-01, 1.4104350e-01, 3.2781060e-01,
 1.5254700e-01, 1.8104490e-01, 1.3767870e-01, 1.8443710e-01, 4.1172400e-01, 3.5398650e-01, 2.0759800e-01, 3.7711790e-01,
 1.2321220e-01, 2.6567180e-01, 1.0624430e-01, 3.5465630e-01, 3.6613230e-01, 4.2733690e-01, 2.8717710e-01, 5.1004120e-01,
 2.4192520e-01, 3.2894190e-01, 2.9138400e-01, 2.4032840e-01, 6.9881770e-01, 6.8833500e-01, 4.7022170e-01, 5.2591350e-01,
 1.8366590e-01, 4.5370730e-01, 2.1135000e-01, 4.3437230e-01, 4.4228280e-01, 5.9140890e-01, 4.6294950e-01, 5.0622870e-01,
 8.6703900e-02, 1.2266570e-01, 1.0998600e-01, 7.5406880e-02, 4.1378170e-01, 4.2408560e-01, 2.9324070e-01, 2.7262770e-01,
 1.3203640e-01, 3.3938070e-01, 1.6002270e-01, 2.7338550e-01, 4.8816830e-01, 6.7920950e-01, 5.3816720e-01, 4.8917540e-01,
 2.1759500e-01, 3.3508380e-01, 2.0724420e-01, 2.9291890e-01, 4.6844640e-01, 5.2259150e-01, 2.4925700e-01, 4.7773250e-01,
 1.5474750e-01, 4.3294940e-01, 1.4081400e-01, 4.9594270e-01, 4.0700010e-01, 6.1638050e-01, 3.3688120e-01, 6.3127090e-01,
 2.2749410e-01, 2.3302140e-01, 1.8958790e-01, 3.1378110e-01, 4.4385640e-01, 3.2935630e-01, 2.0665080e-01, 4.6379450e-01,
 1.1674150e-01, 2.1725010e-01, 9.2951150e-02, 3.8334630e-01, 3.8984720e-01, 3.9270800e-01, 2.8234740e-01, 6.1954630e-01,
 3.3670580e-01, 3.9512250e-01, 3.7446650e-01, 3.8158110e-01, 7.0307800e-01, 5.9769900e-01, 4.3683750e-01, 6.0362340e-01,
 1.6240650e-01, 3.4625300e-01, 1.7256580e-01, 4.3817640e-01, 4.3950080e-01, 5.0721320e-01, 4.2478660e-01, 5.7387660e-01,
 1.0388850e-01, 1.2685130e-01, 1.2168690e-01, 1.0307470e-01, 3.5840160e-01, 3.1702630e-01, 2.3453110e-01, 2.6938960e-01,
 1.0051420e-01, 2.2297910e-01, 1.1248460e-01, 2.3742230e-01, 4.1762680e-01, 5.0149380e-01, 4.2512200e-01, 4.7741440e-01,
 2.7179280e-01, 3.6123140e-01, 2.3902800e-01, 4.1739630e-01, 4.2297900e-01, 4.0725300e-01, 2.0781840e-01, 4.9210290e-01,
 1.2280550e-01, 2.9653390e-01, 1.0318530e-01, 4.4899110e-01, 3.6297240e-01, 4.7442870e-01, 2.7741720e-01, 6.4225410e-01,
 2.7237530e-01, 3.7570240e-01, 3.1476370e-01, 4.9639910e-01, 7.1944790e-01, 7.1890810e-01, 4.6448360e-01, 9.9331940e-01,
 1.9119590e-01, 4.7914150e-01, 2.1109820e-01, 8.2956640e-01, 5.0058110e-01, 6.7904780e-01, 5.0273620e-01, 1.0511390e+00,
 3.8526670e-01, 6.0882600e-01, 5.9415550e-01, 5.7690480e-01, 1.0891140e+00, 1.2468180e+00, 9.3835310e-01, 1.2355000e+00,
 2.5419670e-01, 7.2981130e-01, 3.7453940e-01, 9.0619570e-01, 5.3932780e-01, 8.3817410e-01, 7.2283690e-01, 9.3050390e-01,
 1.0502900e-01, 1.7269810e-01, 1.7059340e-01, 1.3768940e-01, 4.9053640e-01, 5.8431510e-01, 4.4512100e-01, 4.8717900e-01,
 1.3900340e-01, 4.1525260e-01, 2.1570840e-01, 4.3383610e-01, 4.5280650e-01, 7.3221810e-01, 6.3916690e-01, 6.8395320e-01,
 3.5122540e-01, 6.2861420e-01, 4.2832490e-01, 7.1269410e-01, 7.3999050e-01, 9.5944960e-01, 5.0415910e-01, 1.1375480e+00,
 2.1708080e-01, 7.0587630e-01, 2.5292850e-01, 1.0486920e+00, 5.0304170e-01, 8.8542520e-01, 5.3313870e-01, 1.1760990e+00,
 1.7388210e-01, 2.0714510e-01, 1.4784080e-01, 2.2352380e-01, 3.9258020e-01, 3.3880200e-01, 1.8647560e-01, 3.8231700e-01,
 1.1355860e-01, 2.4578130e-01, 9.2246190e-02, 3.4753480e-01, 1.9903500e-01, 2.3318410e-01, 1.4706790e-01, 2.9479560e-01,
 5.1428930e-01, 7.0191220e-01, 5.8353750e-01, 5.4319520e-01, 1.2426860e+00, 1.2286680e+00, 7.8772900e-01, 9.9434300e-01,
 3.1569690e-01, 7.8280680e-01, 3.4223190e-01, 7.9383100e-01, 4.4840130e-01, 6.0185500e-01, 4.4215750e-01, 5.4567980e-01,
 1.3809880e-01, 1.9611540e-01, 1.6503090e-01, 1.2769880e-01, 5.5130730e-01, 5.6717000e-01, 3.6806390e-01, 3.8620400e-01,
 1.7004360e-01, 4.3872350e-01, 1.9414430e-01, 3.7434010e-01, 3.7081840e-01, 5.1788420e-01, 3.8511060e-01, 3.9507600e-01,
 5.5854580e-01, 8.6337720e-01, 5.0115120e-01, 7.9943230e-01, 1.0058680e+00, 1.1263690e+00, 5.0420250e-01, 1.0906620e+00,
 3.2118010e-01, 9.0198520e-01, 2.7532620e-01, 1.0944120e+00, 4.9824710e-01, 7.5741920e-01, 3.8851130e-01, 8.2165660e-01,
 2.0790900e-01, 2.6025500e-01, 2.2777800e-01, 2.7765790e-01, 7.5158700e-01, 6.8155810e-01, 4.6001480e-01, 7.6040050e-01,
 1.7039240e-01, 3.8751190e-01, 1.7835190e-01, 5.4174680e-01, 5.5748030e-01, 6.8628590e-01, 5.3078280e-01, 8.5780580e-01,
 3.1750100e-01, 4.5533020e-01, 4.6420030e-01, 3.4838660e-01, 1.2283770e+00, 1.2761760e+00, 1.0033350e+00, 1.0211140e+00,
 2.4457930e-01, 6.3725020e-01, 3.4164010e-01, 6.3891830e-01, 6.4846440e-01, 9.1457040e-01, 8.2393920e-01, 8.1983230e-01,
 1.0864600e-01, 1.6212180e-01, 1.6729700e-01, 1.0437060e-01, 6.9446420e-01, 7.5071540e-01, 5.9741800e-01, 5.0540650e-01,
 1.6787870e-01, 4.5512670e-01, 2.4697840e-01, 3.8394560e-01, 6.8338680e-01, 1.0028680e+00, 9.1451270e-01, 7.5640400e-01,
 2.9526690e-01, 4.7958160e-01, 3.4136870e-01, 4.3904140e-01, 8.5139140e-01, 1.0017860e+00, 5.4991080e-01, 9.5906130e-01,
 2.1306710e-01, 6.2874290e-01, 2.3535000e-01, 7.5425200e-01, 6.1699600e-01, 9.8555260e-01, 6.1992640e-01, 1.0570510e+00,
 4.9291810e-01, 4.2510410e-01, 3.7638790e-01, 8.2053690e-01, 6.4198500e-01, 4.0109130e-01, 2.7386710e-01, 8.0960760e-01,
 1.9721500e-01, 3.0900780e-01, 1.4387650e-01, 7.8157870e-01, 5.7280960e-01, 4.8582570e-01, 3.8011940e-01, 1.0986420e+00,
 8.0299610e-01, 7.9339490e-01, 8.1826900e-01, 1.0982880e+00, 1.1192940e+00, 8.0115730e-01, 6.3720730e-01, 1.1597730e+00,
 3.0197870e-01, 5.4207740e-01, 2.9400040e-01, 9.8330550e-01, 7.1077750e-01, 6.9065210e-01, 6.2945560e-01, 1.1201060e+00,
 2.4663030e-01, 2.5355300e-01, 2.6469340e-01, 2.9532320e-01, 5.6797170e-01, 4.2300630e-01, 3.4054740e-01, 5.1523360e-01,
 1.8604440e-01, 3.4749460e-01, 1.9076660e-01, 5.3036790e-01, 6.7232380e-01, 6.7975210e-01, 6.2708160e-01, 9.2758190e-01,
 6.7266160e-01, 7.5272980e-01, 5.4203580e-01, 1.2467340e+00, 6.9880390e-01, 5.6649440e-01, 3.1458700e-01, 9.8120330e-01,
 2.3696630e-01, 4.8176810e-01, 1.8243450e-01, 1.0456180e+00, 6.0917700e-01, 6.7040260e-01, 4.2660280e-01, 1.3008990e+00,
 4.2936060e-01, 4.9864700e-01, 4.5463140e-01, 9.4439140e-01, 7.5706200e-01, 6.3694260e-01, 4.4784000e-01, 1.2615010e+00,
 2.3498660e-01, 4.9581890e-01, 2.3772200e-01, 1.2305020e+00, 5.3510620e-01, 6.1116820e-01, 4.9240910e-01, 1.3561020e+00,
 6.6845780e-01, 8.8940690e-01, 9.4456750e-01, 1.2080460e+00, 1.2614320e+00, 1.2158730e+00, 9.9581080e-01, 1.7270280e+00,
 3.4386860e-01, 8.3124300e-01, 4.6423780e-01, 1.4794870e+00, 6.3456560e-01, 8.3033390e-01, 7.7926360e-01, 1.3213220e+00,
 1.8140040e-01, 2.5113720e-01, 2.6996740e-01, 2.8700920e-01, 5.6555860e-01, 5.6721580e-01, 4.7022410e-01, 6.7789380e-01,
 1.8718200e-01, 4.7081030e-01, 2.6614980e-01, 7.0506820e-01, 5.3033780e-01, 7.2206310e-01, 6.8592170e-01, 9.6679170e-01,
 6.3240380e-01, 9.5298810e-01, 7.0664650e-01, 1.5487390e+00, 8.8943110e-01, 9.7096400e-01, 5.5523160e-01, 1.6501460e+00,
 3.0474740e-01, 8.3433790e-01, 3.2533940e-01, 1.7767780e+00, 6.1421960e-01, 9.1026190e-01, 5.9645850e-01, 1.7331260e+00,
 2.0573330e-01, 2.0635700e-01, 1.6027450e-01, 3.1918330e-01, 3.1006720e-01, 2.2530370e-01, 1.3494900e-01, 3.6443300e-01,
 1.0475620e-01, 1.9089890e-01, 7.7970200e-02, 3.8692310e-01, 1.5969470e-01, 1.5752690e-01, 1.0811830e-01, 2.8546220e-01,
 6.6975420e-01, 7.6963620e-01, 6.9630100e-01, 8.5374940e-01, 1.0803070e+00, 8.9932160e-01, 6.2745530e-01, 1.0432500e+00,
 3.2054440e-01, 6.6921760e-01, 3.1838960e-01, 9.7277550e-01, 3.9599160e-01, 4.4751310e-01, 3.5778030e-01, 5.8159890e-01,
 1.7902520e-01, 2.1405760e-01, 1.9602430e-01, 1.9979170e-01, 4.7708480e-01, 4.1324710e-01, 2.9184040e-01, 4.0335290e-01,
 1.7186780e-01, 3.7335320e-01, 1.7979560e-01, 4.5663280e-01, 3.2598420e-01, 3.8332110e-01, 3.1019950e-01, 4.1916260e-01,
 7.5485350e-01, 9.8242460e-01, 6.2057320e-01, 1.3039240e+00, 9.0744950e-01, 8.5557260e-01, 4.1678000e-01, 1.1875130e+00,
 3.3842510e-01, 8.0021760e-01, 2.6581640e-01, 1.3917510e+00, 4.5662520e-01, 5.8444840e-01, 3.2624130e-01, 9.0880770e-01,
 5.5195360e-01, 5.8173230e-01, 5.5406590e-01, 8.8962290e-01, 1.3319450e+00, 1.0169620e+00, 7.4696310e-01, 1.6263570e+00,
 3.5268710e-01, 6.7533490e-01, 3.3824970e-01, 1.3533260e+00, 1.0036220e+00, 1.0402560e+00, 8.7554330e-01, 1.8637860e+00,
 9.2775340e-01, 1.1202340e+00, 1.2428340e+00, 1.2286140e+00, 2.3960540e+00, 2.0959000e+00, 1.7932110e+00, 2.4038420e+00,
 5.5720770e-01, 1.2223690e+00, 7.1315950e-01, 1.7567480e+00, 1.2849450e+00, 1.5258450e+00, 1.4959400e+00, 1.9606050e+00,
 3.1602200e-01, 3.9704500e-01, 4.4587380e-01, 3.6639410e-01, 1.3484390e+00, 1.2273020e+00, 1.0628700e+00, 1.1843740e+00,
 3.8072320e-01, 8.6904210e-01, 5.1320750e-01, 1.0508720e+00, 1.3479730e+00, 1.6655340e+00, 1.6528170e+00, 1.8006740e+00,
 8.9536080e-01, 1.2244490e+00, 9.4847820e-01, 1.6067760e+00, 1.7234170e+00, 1.7073820e+00, 1.0199380e+00, 2.3430090e+00,
 5.0374380e-01, 1.2515880e+00, 5.0983300e-01, 2.1521700e+00, 1.2687520e+00, 1.7063540e+00, 1.1680330e+00, 2.6233540e+00,
 6.6801680e-01, 7.6132950e-01, 4.6234780e-01, 9.2762130e-01, 1.1646760e+00, 9.6158640e-01, 4.5034020e-01, 1.2252220e+00,
 3.6744840e-01, 7.6083530e-01, 2.4297790e-01, 1.2147560e+00, 1.2037720e+00, 1.3492090e+00, 7.2405990e-01, 1.9259730e+00,
 1.1829900e+00, 1.5446200e+00, 1.0926580e+00, 1.3497200e+00, 2.2073910e+00, 2.0879390e+00, 1.1390340e+00, 1.9079560e+00,
 6.1162830e-01, 1.4509000e+00, 5.3973400e-01, 1.6613450e+00, 1.6237630e+00, 2.0850340e+00, 1.3033910e+00, 2.1345590e+00,
 3.0930710e-01, 4.2022030e-01, 3.0088970e-01, 3.0895920e-01, 9.5353790e-01, 9.3847550e-01, 5.1821430e-01, 7.2156500e-01,
 3.2077760e-01, 7.9177200e-01, 2.9813320e-01, 7.6282440e-01, 1.3075050e+00, 1.7469490e+00, 1.1053750e+00, 1.5047950e+00,
 9.1089010e-01, 1.3470170e+00, 6.6530060e-01, 1.4083260e+00, 1.2667540e+00, 1.3570550e+00, 5.1689030e-01, 1.4837340e+00,
 4.4116360e-01, 1.1852660e+00, 3.0785100e-01, 1.6238520e+00, 1.2791880e+00, 1.8603350e+00, 8.1196060e-01, 2.2787370e+00,
 8.1781350e-01, 1.2551340e+00, 7.8489600e-01, 1.5005280e+00, 1.9303290e+00, 2.1461740e+00, 1.0350070e+00, 2.6831660e+00,
 6.1534530e-01, 1.7157880e+00, 5.6424240e-01, 2.6879310e+00, 1.5804960e+00, 2.3854980e+00, 1.3182570e+00, 3.3412270e+00,
 1.3840800e+00, 2.4336180e+00, 1.7727220e+00, 2.0865580e+00, 3.4963790e+00, 4.4535630e+00, 2.5017980e+00, 3.9931370e+00,
 9.7886610e-01, 3.1269690e+00, 1.1978210e+00, 3.5131930e+00, 2.0374410e+00, 3.5231080e+00, 2.2678450e+00, 3.5389710e+00,
 3.1974310e-01, 5.8497710e-01, 4.3131540e-01, 4.2200630e-01, 1.3344690e+00, 1.7686580e+00, 1.0056720e+00, 1.3342970e+00,
 4.5359780e-01, 1.5077090e+00, 5.8459300e-01, 1.4252730e+00, 1.4495630e+00, 2.6081010e+00, 1.6993370e+00, 2.2043340e+00,
 1.2036030e+00, 2.3968510e+00, 1.2190220e+00, 2.4588220e+00, 2.2660470e+00, 3.2690720e+00, 1.2821870e+00, 3.5070270e+00,
 7.9739330e-01, 2.8849570e+00, 7.7159580e-01, 3.8781610e+00, 1.8127330e+00, 3.5501070e+00, 1.5955520e+00, 4.2667820e+00,
 3.6343220e-01, 4.8172900e-01, 2.5662790e-01, 4.7034760e-01, 7.3323350e-01, 7.0407600e-01, 2.8925230e-01, 7.1889290e-01,
 2.5441480e-01, 6.1267580e-01, 1.7163730e-01, 7.8387580e-01, 4.3745220e-01, 5.7024260e-01, 2.6844780e-01, 6.5230210e-01,
 1.2861430e+00, 1.9530980e+00, 1.2119680e+00, 1.3676160e+00, 2.7770810e+00, 3.0550710e+00, 1.4619910e+00, 2.2371230e+00,
 8.4626370e-01, 2.3348000e+00, 7.6189810e-01, 2.1423490e+00, 1.1791830e+00, 1.7610260e+00, 9.6567730e-01, 1.4447040e+00,
 2.9266030e-01, 4.6242900e-01, 2.9045590e-01, 2.7245020e-01, 1.0440300e+00, 1.1950670e+00, 5.7887310e-01, 7.3631340e-01,
 3.8626730e-01, 1.1088640e+00, 3.6626310e-01, 8.5609240e-01, 8.2635690e-01, 1.2840990e+00, 7.1274270e-01, 8.8636720e-01,
 1.3324110e+00, 2.2916040e+00, 9.9286240e-01, 1.9199400e+00, 2.1442020e+00, 2.6715600e+00, 8.9262830e-01, 2.3406770e+00,
 8.2126220e-01, 2.5662100e+00, 5.8468460e-01, 2.8173500e+00, 1.2498470e+00, 2.1140140e+00, 8.0938740e-01, 2.0750520e+00,
 7.5739960e-01, 1.0548980e+00, 6.8913520e-01, 1.0183300e+00, 2.4466760e+00, 2.4686510e+00, 1.2436840e+00, 2.4921040e+00,
 6.6535860e-01, 1.6836440e+00, 5.7839450e-01, 2.1297500e+00, 2.1355700e+00, 2.9251560e+00, 1.6886590e+00, 3.3082620e+00,
 1.3839170e+00, 2.2082630e+00, 1.6803940e+00, 1.5288080e+00, 4.7845570e+00, 5.5307050e+00, 3.2456150e+00, 4.0041570e+00,
 1.1427160e+00, 3.3127470e+00, 1.3256490e+00, 3.0053190e+00, 2.9722370e+00, 4.6641670e+00, 3.1364150e+00, 3.7831110e+00,
 4.0130150e-01, 6.6628180e-01, 5.1319920e-01, 3.8811640e-01, 2.2921990e+00, 2.7570040e+00, 1.6376520e+00, 1.6794610e+00,
 6.6467070e-01, 2.0049470e+00, 8.1210240e-01, 1.5304080e+00, 2.6543380e+00, 4.3340420e+00, 2.9499880e+00, 2.9578080e+00,
 1.2276580e+00, 2.2186290e+00, 1.1787650e+00, 1.8377850e+00, 3.1632770e+00, 4.1413550e+00, 1.6968410e+00, 3.5874100e+00,
 9.4958250e-01, 3.1178060e+00, 8.7110710e-01, 3.3842270e+00, 2.6975990e+00, 4.7944030e+00, 2.2510030e+00, 4.6528340e+00,
 2.3275080e-01, 2.2603400e-01, 1.5979250e-01, 2.9064020e-01, 3.1619500e-01, 2.2245150e-01, 1.2127580e-01, 2.9912030e-01,
 1.1659660e-01, 2.0572040e-01, 7.6478600e-02, 3.4662490e-01, 3.4290870e-01, 3.2749960e-01, 2.0459380e-01, 4.9336200e-01,
 4.1345050e-01, 4.6000390e-01, 3.7880030e-01, 4.2419690e-01, 6.0112910e-01, 4.8451090e-01, 3.0768660e-01, 4.6723790e-01,
 1.9467750e-01, 3.9351640e-01, 1.7040860e-01, 4.7552040e-01, 4.6397610e-01, 5.0767210e-01, 3.6942910e-01, 5.4848180e-01,
 1.2148570e-01, 1.4064020e-01, 1.1722650e-01, 1.0912330e-01, 2.9182270e-01, 2.4473790e-01, 1.5731640e-01, 1.9858100e-01,
 1.1474260e-01, 2.4133380e-01, 1.0578270e-01, 2.4537290e-01, 4.1986440e-01, 4.7801670e-01, 3.5209410e-01, 4.3453420e-01,
 2.9950590e-01, 3.7740690e-01, 2.1699060e-01, 4.1641260e-01, 3.2454710e-01, 2.9626480e-01, 1.3136130e-01, 3.4183970e-01,
 1.3210670e-01, 3.0243930e-01, 9.1442730e-02, 4.3727290e-01, 3.4387780e-01, 4.2614590e-01, 2.1651520e-01, 5.5086500e-01,
 6.2800210e-01, 8.2128550e-01, 5.9786410e-01, 1.0361730e+00, 1.1550050e+00, 1.0942460e+00, 6.1429860e-01, 1.4437150e+00,
 4.3033970e-01, 1.0224770e+00, 3.9141890e-01, 1.6904090e+00, 9.9227200e-01, 1.2761840e+00, 8.2095800e-01, 1.8863590e+00,
 1.0661210e+00, 1.5973320e+00, 1.3544710e+00, 1.4452970e+00, 2.0985050e+00, 2.2776990e+00, 1.4894540e+00, 2.1551960e+00,
 6.8668010e-01, 1.8691840e+00, 8.3350190e-01, 2.2162280e+00, 1.2831010e+00, 1.8905980e+00, 1.4166840e+00, 2.0041680e+00,
 2.7678290e-01, 4.3149340e-01, 3.7035360e-01, 3.2850210e-01, 9.0010350e-01, 1.0165420e+00, 6.7285860e-01, 8.0931500e-01,
 3.5759770e-01, 1.0128350e+00, 4.5715230e-01, 1.0104220e+00, 1.0259010e+00, 1.5728600e+00, 1.1929760e+00, 1.4029010e+00,
 8.7221930e-01, 1.4800650e+00, 8.7626920e-01, 1.6023250e+00, 1.2795500e+00, 1.5729320e+00, 7.1816320e-01, 1.7807730e+00,
 5.2626030e-01, 1.6224250e+00, 5.0512810e-01, 2.3016270e+00, 1.0740060e+00, 1.7923030e+00, 9.3770750e-01, 2.2732870e+00,
 2.5615810e-01, 2.8932420e-01, 1.7942050e-01, 2.9811570e-01, 4.0269200e-01, 3.2949400e-01, 1.5757640e-01, 3.5503900e-01,
 1.6331000e-01, 3.3511850e-01, 1.0928630e-01, 4.5247950e-01, 2.5208430e-01, 2.8000910e-01, 1.5344710e-01, 3.3802210e-01,
 9.0931130e-01, 1.1766430e+00, 8.4995970e-01, 8.6949840e-01, 1.5298820e+00, 1.4341280e+00, 7.9890980e-01, 1.1082570e+00,
 5.4489760e-01, 1.2810200e+00, 4.8661960e-01, 1.2404530e+00, 6.8160840e-01, 8.6739470e-01, 5.5369360e-01, 7.5095480e-01,
 2.3253050e-01, 3.1308220e-01, 2.2891790e-01, 1.9466340e-01, 6.4636080e-01, 6.3045090e-01, 3.5549130e-01, 4.0992640e-01,
 2.7950500e-01, 6.8371820e-01, 2.6289270e-01, 5.5706200e-01, 5.3680210e-01, 7.1079170e-01, 4.5926450e-01, 5.1777530e-01,
 8.8625470e-01, 1.2988440e+00, 6.5507790e-01, 1.1483890e+00, 1.1113020e+00, 1.1798540e+00, 4.5890260e-01, 1.0909100e+00,
 4.9749400e-01, 1.3246330e+00, 3.5132680e-01, 1.5347160e+00, 6.7968470e-01, 9.7961590e-01, 4.3660710e-01, 1.0147540e+00,
 7.3350760e-01, 8.7053700e-01, 6.6201460e-01, 8.8684790e-01, 1.8462980e+00, 1.5873850e+00, 9.3093410e-01, 1.6911140e+00,
 5.8684180e-01, 1.2653560e+00, 5.0602620e-01, 1.6891760e+00, 1.6909230e+00, 1.9735860e+00, 1.3262810e+00, 2.3555430e+00,
 1.3443990e+00, 1.8279580e+00, 1.6192460e+00, 1.3355260e+00, 3.6216450e+00, 3.5673180e+00, 2.4369390e+00, 2.7255640e+00,
 1.0109790e+00, 2.4974070e+00, 1.1633650e+00, 2.3909780e+00, 2.3606530e+00, 3.1566030e+00, 2.4709600e+00, 2.7019590e+00,
 4.3810840e-01, 6.1982060e-01, 5.5575120e-01, 3.8102540e-01, 1.9498850e+00, 1.9984410e+00, 1.3818530e+00, 1.2847180e+00,
 6.6085020e-01, 1.6986210e+00, 8.0092320e-01, 1.3683110e+00, 2.3691760e+00, 3.2963370e+00, 2.6118310e+00, 2.3740640e+00,
 1.1219990e+00, 1.7278140e+00, 1.0686260e+00, 1.5103960e+00, 2.2526730e+00, 2.5130470e+00, 1.1986320e+00, 2.2973290e+00,
 7.9037550e-01, 2.2112970e+00, 7.1921030e-01, 2.5330360e+00, 2.0156860e+00, 3.0526520e+00, 1.6684190e+00, 3.1263970e+00,
 5.7418220e-01, 5.8813280e-01, 4.7850920e-01, 7.9196580e-01, 1.0447610e+00, 7.7524780e-01, 4.8642030e-01, 1.0916920e+00,
 2.9185780e-01, 5.4313280e-01, 2.3238110e-01, 9.5837920e-01, 9.4505910e-01, 9.5199430e-01, 6.8446040e-01, 1.5018910e+00,
 9.8214730e-01, 1.1525450e+00, 1.0922920e+00, 1.1130450e+00, 1.9126010e+00, 1.6259360e+00, 1.1883400e+00, 1.6420520e+00,
 4.6924090e-01, 1.0004280e+00, 4.9859400e-01, 1.2660220e+00, 1.2313190e+00, 1.4210240e+00, 1.1900950e+00, 1.6077900e+00,
 2.7554280e-01, 3.3644700e-01, 3.2274950e-01, 2.7338430e-01, 8.8651610e-01, 7.8417320e-01, 5.8011900e-01, 6.6634250e-01,
 2.6406800e-01, 5.8580400e-01, 2.9551610e-01, 6.2374870e-01, 1.0638860e+00, 1.2775330e+00, 1.0829790e+00, 1.2161920e+00,
 7.3563130e-01, 9.7770500e-01, 6.4695070e-01, 1.1297200e+00, 1.0676680e+00, 1.0279730e+00, 5.2456720e-01, 1.2421470e+00,
 3.2923530e-01, 7.9499260e-01, 2.7663450e-01, 1.2037230e+00, 9.4358450e-01, 1.2333270e+00, 7.2117490e-01, 1.6696070e+00,
 6.4122110e-01, 8.8447180e-01, 7.4101110e-01, 1.1686140e+00, 1.5795530e+00, 1.5783680e+00, 1.0197770e+00, 2.1808400e+00,
 4.4584610e-01, 1.1173010e+00, 4.9225590e-01, 1.9344500e+00, 1.1318770e+00, 1.5354130e+00, 1.1367500e+00, 2.3767590e+00,
 1.0482090e+00, 1.6564550e+00, 1.6165400e+00, 1.5696060e+00, 2.7634700e+00, 3.1636200e+00, 2.3809350e+00, 3.1349010e+00,
 6.8505060e-01, 1.9668140e+00, 1.0093700e+00, 2.4421640e+00, 1.4093670e+00, 2.1903100e+00, 1.8889120e+00, 2.4315850e+00,
 2.5983140e-01, 4.2723770e-01, 4.2203100e-01, 3.4062970e-01, 1.1317440e+00, 1.3481060e+00, 1.0269640e+00, 1.1239980e+00,
 3.4062290e-01, 1.0175620e+00, 5.2858590e-01, 1.0631000e+00, 1.0759190e+00, 1.7398330e+00, 1.5187330e+00, 1.6251500e+00,
 8.8668360e-01, 1.5869630e+00, 1.0813250e+00, 1.7992270e+00, 1.7422230e+00, 2.2589140e+00, 1.1869850e+00, 2.6782260e+00,
 5.4283840e-01, 1.7651340e+00, 6.3248020e-01, 2.6223890e+00, 1.2197520e+00, 2.1469380e+00, 1.2927300e+00, 2.8517500e+00,
 3.8528920e-01, 4.5899350e-01, 3.2758670e-01, 4.9528560e-01, 8.1125090e-01, 7.0012050e-01, 3.8534420e-01, 7.9004250e-01,
 2.4924030e-01, 5.3944500e-01, 2.0246350e-01, 7.6277530e-01, 4.2359060e-01, 4.9626750e-01, 3.1299300e-01, 6.2739040e-01,
 1.3170000e+00, 1.7974680e+00, 1.4943320e+00, 1.3910230e+00, 2.9678000e+00, 2.9343220e+00, 1.8812650e+00, 2.3747040e+00,
 8.0078330e-01, 1.9856350e+00, 8.6809100e-01, 2.0135980e+00, 1.1028850e+00, 1.4803180e+00, 1.0875270e+00, 1.3421500e+00,
 3.2156150e-01, 4.5665240e-01, 3.8427260e-01, 2.9734510e-01, 1.1971890e+00, 1.2316350e+00, 7.9926750e-01, 8.3865970e-01,
 3.9219380e-01, 1.0118860e+00, 4.4778040e-01, 8.6338960e-01, 8.2931640e-01, 1.1582210e+00, 8.6128020e-01, 8.8356730e-01,
 1.3271910e+00, 2.0515170e+00, 1.1908130e+00, 1.8995740e+00, 2.2290020e+00, 2.4960310e+00, 1.1173120e+00, 2.4169050e+00,
 7.5594410e-01, 2.1229530e+00, 6.4802030e-01, 2.5758580e+00, 1.1371150e+00, 1.7286050e+00, 8.8667230e-01, 1.8752100e+00,
 7.3704820e-01, 9.2261750e-01, 8.0748480e-01, 9.8431170e-01, 2.4848300e+00, 2.2533070e+00, 1.5208600e+00, 2.5139690e+00,
 5.9832790e-01, 1.3607360e+00, 6.2627730e-01, 1.9023280e+00, 1.8981780e+00, 2.3367520e+00, 1.8072750e+00, 2.9207640e+00,
 1.3008110e+00, 1.8655000e+00, 1.9018410e+00, 1.4273490e+00, 4.6934840e+00, 4.8761210e+00, 3.8336260e+00, 3.9015570e+00,
 9.9255600e-01, 2.5861000e+00, 1.3864500e+00, 2.5928700e+00, 2.5517610e+00, 3.5989100e+00, 3.2422690e+00, 3.2261080e+00,
 4.0474210e-01, 6.0395700e-01, 6.2323630e-01, 3.8881490e-01, 2.4127340e+00, 2.6081640e+00, 2.0755720e+00, 1.7559020e+00,
 6.1947930e-01, 1.6794360e+00, 9.1136030e-01, 1.4167750e+00, 2.4452100e+00, 3.5883400e+00, 3.2721960e+00, 2.7064710e+00,
 1.1224840e+00, 1.8231720e+00, 1.2977440e+00, 1.6690550e+00, 3.0184870e+00, 3.5516890e+00, 1.9496310e+00, 3.4002160e+00,
 8.0232070e-01, 2.3675810e+00, 8.8622890e-01, 2.8401950e+00, 2.2528510e+00, 3.5985700e+00, 2.2635510e+00, 3.8596320e+00,
 4.7961100e-01, 4.1362770e-01, 3.6622670e-01, 7.9838520e-01, 5.6840520e-01, 3.5512100e-01, 2.4247840e-01, 7.1681600e-01,
 1.7585880e-01, 2.7554570e-01, 1.2829630e-01, 6.9694240e-01, 5.7374970e-01, 4.8662310e-01, 3.8074320e-01, 1.1004450e+00,
 6.2505600e-01, 6.1758240e-01, 6.3694450e-01, 8.5491260e-01, 7.9280840e-01, 5.6746890e-01, 4.5134120e-01, 8.2148080e-01,
 2.1542280e-01, 3.8670220e-01, 2.0973130e-01, 7.0146150e-01, 5.6955680e-01, 5.5343000e-01, 5.0439230e-01, 8.9755790e-01,
 2.0024170e-01, 2.0586240e-01, 2.1490740e-01, 2.3977600e-01, 4.1961760e-01, 3.1251710e-01, 2.5159650e-01, 3.8065470e-01,
 1.3843140e-01, 2.5856280e-01, 1.4194510e-01, 3.9463470e-01, 5.6193300e-01, 5.6814160e-01, 5.2411930e-01, 7.7527960e-01,
 6.2393570e-01, 6.9820390e-01, 5.0277210e-01, 1.1564240e+00, 5.8981690e-01, 4.7814270e-01, 2.6552330e-01, 8.2817270e-01,
 2.0143710e-01, 4.0953500e-01, 1.5508150e-01, 8.8884540e-01, 5.8168050e-01, 6.4014260e-01, 4.0734720e-01, 1.2421800e+00,
 3.7230210e-01, 4.3238090e-01, 3.9421460e-01, 8.1888950e-01, 5.9734260e-01, 5.0256510e-01, 3.5335800e-01, 9.9535890e-01,
 1.8673520e-01, 3.9400900e-01, 1.8890890e-01, 9.7783460e-01, 4.7765150e-01, 5.4554660e-01, 4.3953880e-01, 1.2104970e+00,
 4.6370140e-01, 6.1697120e-01, 6.5523550e-01, 8.3800720e-01, 7.9624540e-01, 7.6748740e-01, 6.2857920e-01, 1.0901410e+00,
 2.1860830e-01, 5.2844800e-01, 2.9513090e-01, 9.4055770e-01, 4.5314670e-01, 5.9294590e-01, 5.5647630e-01, 9.4356280e-01,
 1.3125180e-01, 1.8170970e-01, 1.9533430e-01, 2.0766480e-01, 3.7236040e-01, 3.7345150e-01, 3.0959270e-01, 4.4632120e-01,
 1.2411980e-01, 3.1219280e-01, 1.7648310e-01, 4.6752850e-01, 3.9501860e-01, 5.3782400e-01, 5.1090430e-01, 7.2010840e-01,
 5.2275300e-01, 7.8775200e-01, 5.8412300e-01, 1.2802080e+00, 6.6901090e-01, 7.3033810e-01, 4.1763320e-01, 1.2412050e+00,
 2.3086170e-01, 6.3205360e-01, 2.4646120e-01, 1.3460000e+00, 5.2266520e-01, 7.7458000e-01, 5.0755150e-01, 1.4747900e+00,
 1.2673120e-01, 1.2711540e-01, 9.8728710e-02, 1.9661610e-01, 1.7380150e-01, 1.2628910e-01, 7.5642790e-02, 2.0427510e-01,
 5.9138280e-02, 1.0776860e-01, 4.4016700e-02, 2.1843060e-01, 1.0126680e-01, 9.9892200e-02, 6.8560810e-02, 1.8101950e-01,
 3.3005440e-01, 3.7927630e-01, 3.4313670e-01, 4.2072720e-01, 4.8443550e-01, 4.0327740e-01, 2.8136600e-01, 4.6781850e-01,
 1.4476660e-01, 3.0223680e-01, 1.4379340e-01, 4.3933180e-01, 2.0088800e-01, 2.2702500e-01, 1.8150320e-01, 2.9504730e-01,
 9.2021010e-02, 1.1002810e-01, 1.0075870e-01, 1.0269520e-01, 2.2314500e-01, 1.9328650e-01, 1.3650140e-01, 1.8865870e-01,
 8.0961230e-02, 1.7587440e-01, 8.4695790e-02, 2.1510470e-01, 1.7249130e-01, 2.0283060e-01, 1.6413900e-01, 2.2179580e-01,
 4.4327220e-01, 5.7690870e-01, 3.6441880e-01, 7.6570230e-01, 4.8489650e-01, 4.5717600e-01, 2.2270680e-01, 6.3454860e-01,
 1.8212950e-01, 4.3065130e-01, 1.4305380e-01, 7.4899530e-01, 2.7603590e-01, 3.5330670e-01, 1.9721710e-01, 5.4938610e-01,
 3.8212960e-01, 4.0274600e-01, 3.8359190e-01, 6.1590540e-01, 8.3909870e-01, 6.4066570e-01, 4.7057190e-01, 1.0245730e+00,
 2.2377290e-01, 4.2848640e-01, 2.1461260e-01, 8.5865800e-01, 7.1527970e-01, 7.4138910e-01, 6.2399850e-01, 1.3283180e+00,
 5.1384450e-01, 6.2045150e-01, 6.8835470e-01, 6.8047880e-01, 1.2075760e+00, 1.0563030e+00, 9.0375200e-01, 1.2115010e+00,
 2.8283040e-01, 6.2045640e-01, 3.6198930e-01, 8.9169930e-01, 7.3262500e-01, 8.6997650e-01, 8.5292550e-01, 1.1178600e+00,
 1.8256570e-01, 2.2937270e-01, 2.5758100e-01, 2.1166560e-01, 7.0884590e-01, 6.4516690e-01, 5.5872820e-01, 6.2260040e-01,
 2.0156780e-01, 4.6010030e-01, 2.7170950e-01, 5.5636740e-01, 8.0164320e-01, 9.9049720e-01, 9.8293460e-01, 1.0708660e+00,
 5.9092850e-01, 8.0812310e-01, 6.2598540e-01, 1.0604550e+00, 1.0350130e+00, 1.0253830e+00, 6.1253270e-01, 1.4071150e+00,
 3.0468870e-01, 7.5702110e-01, 3.0837180e-01, 1.3017370e+00, 8.6200850e-01, 1.1593210e+00, 7.9357810e-01, 1.7823440e+00,
 7.7299750e-01, 8.8097460e-01, 5.3500710e-01, 1.0734000e+00, 1.2263510e+00, 1.0125060e+00, 4.7418760e-01, 1.2901030e+00,
 3.8967000e-01, 8.0684710e-01, 2.5767210e-01, 1.2882190e+00, 1.4339460e+00, 1.6071920e+00, 8.6250790e-01, 2.2942400e+00,
 1.0951230e+00, 1.4298930e+00, 1.0115000e+00, 1.2494700e+00, 1.8594300e+00, 1.7588080e+00, 9.5948280e-01, 1.6071970e+00,
 5.1889480e-01, 1.2309180e+00, 4.5790090e-01, 1.4094560e+00, 1.5473990e+00, 1.9869770e+00, 1.2420940e+00, 2.0341730e+00,
 2.9865830e-01, 4.0575290e-01, 2.9053060e-01, 2.9832230e-01, 8.3780180e-01, 8.2456760e-01, 4.5531580e-01, 6.3398480e-01,
 2.8385620e-01, 7.0063940e-01, 2.6381820e-01, 6.7502360e-01, 1.2996480e+00, 1.7364520e+00, 1.0987330e+00, 1.4957520e+00,
 1.0048140e+00, 1.4859110e+00, 7.3390090e-01, 1.5535410e+00, 1.2715420e+00, 1.3621840e+00, 5.1884380e-01, 1.4893420e+00,
 4.4599400e-01, 1.1982440e+00, 3.1122170e-01, 1.6416320e+00, 1.4526190e+00, 2.1125580e+00, 9.2204550e-01, 2.5876860e+00,
 8.4334240e-01, 1.2943140e+00, 8.0939730e-01, 1.5473690e+00, 1.8113390e+00, 2.0138790e+00, 9.7120660e-01, 2.5177690e+00,
 5.8153840e-01, 1.6215230e+00, 5.3324310e-01, 2.5402570e+00, 1.6778030e+00, 2.5323660e+00, 1.3994190e+00, 3.5469370e+00,
 1.1418310e+00, 2.0076740e+00, 1.4624510e+00, 1.7213580e+00, 2.6246900e+00, 3.3432370e+00, 1.8780700e+00, 2.9976010e+00,
 7.4007190e-01, 2.3641460e+00, 9.0561270e-01, 2.6561510e+00, 1.7303090e+00, 2.9920210e+00, 1.9259810e+00, 3.0054930e+00,
 2.7513430e-01, 5.0336430e-01, 3.7114060e-01, 3.6313020e-01, 1.0448900e+00, 1.3848610e+00, 7.8744180e-01, 1.0447560e+00,
 3.5770440e-01, 1.1889700e+00, 4.6100640e-01, 1.1239610e+00, 1.2840400e+00, 2.3102860e+00, 1.5052930e+00, 1.9526250e+00,
 1.1832100e+00, 2.3562400e+00, 1.1983680e+00, 2.4171610e+00, 2.0270580e+00, 2.9242990e+00, 1.1469610e+00, 3.1371570e+00,
 7.1839110e-01, 2.5991280e+00, 6.9514950e-01, 3.4939300e+00, 1.8344680e+00, 3.5926730e+00, 1.6146830e+00, 4.3179410e+00,
 2.6624330e-01, 3.5290530e-01, 1.8800060e-01, 3.4456750e-01, 4.8878340e-01, 4.6934660e-01, 1.9281950e-01, 4.7922380e-01,
 1.7080780e-01, 4.1133530e-01, 1.1523300e-01, 5.2627470e-01, 3.2990110e-01, 4.3004400e-01, 2.0244780e-01, 4.9192850e-01,
 7.5376440e-01, 1.1446440e+00, 7.1029340e-01, 8.0151320e-01, 1.4809960e+00, 1.6292450e+00, 7.7966860e-01, 1.1930410e+00,
 4.5452950e-01, 1.2540240e+00, 4.0921660e-01, 1.1506590e+00, 7.1141900e-01, 1.0624540e+00, 5.8260800e-01, 8.7161180e-01,
 1.7890110e-01, 2.8267950e-01, 1.7755360e-01, 1.6654680e-01, 5.8073900e-01, 6.6475260e-01, 3.2199670e-01, 4.0957240e-01,
 2.1639490e-01, 6.2120830e-01, 2.0518810e-01, 4.7960060e-01, 5.2001370e-01, 8.0806390e-01, 4.4851800e-01, 5.5777720e-01,
 9.3051280e-01, 1.6003820e+00, 6.9338310e-01, 1.3408240e+00, 1.3626010e+00, 1.6977270e+00, 5.6724880e-01, 1.4874570e+00,
 5.2562480e-01, 1.6424280e+00, 3.7421030e-01, 1.8031620e+00, 8.9854290e-01, 1.5198120e+00, 5.8188680e-01, 1.4918010e+00,
 6.2360480e-01, 8.6855010e-01, 5.6739940e-01, 8.3844170e-01, 1.8330720e+00, 1.8495360e+00, 9.3177940e-01, 1.8671080e+00,
 5.0205360e-01, 1.2704120e+00, 4.3643390e-01, 1.6070260e+00, 1.8100730e+00, 2.4793120e+00, 1.4312790e+00, 2.8040270e+00,
 9.1156050e-01, 1.4545420e+00, 1.1068450e+00, 1.0069980e+00, 2.8677160e+00, 3.3149340e+00, 1.9453210e+00, 2.3999680e+00,
 6.8980090e-01, 1.9997410e+00, 8.0022820e-01, 1.8141620e+00, 2.0153800e+00, 3.1626240e+00, 2.1267030e+00, 2.5652070e+00,
 2.7570780e-01, 4.5775830e-01, 3.5258530e-01, 2.6664920e-01, 1.4330100e+00, 1.7235920e+00, 1.0238080e+00, 1.0499460e+00,
 4.1849920e-01, 1.2623820e+00, 5.1132720e-01, 9.6359670e-01, 1.8772940e+00, 3.0652740e+00, 2.0863940e+00, 2.0919250e+00,
 9.6358600e-01, 1.7413970e+00, 9.2521010e-01, 1.4424740e+00, 2.2592760e+00, 2.9578380e+00, 1.2119180e+00, 2.5622000e+00,
 6.8305520e-01, 2.2427050e+00, 6.2660610e-01, 2.4343480e+00, 2.1796590e+00, 3.8738750e+00, 1.8188100e+00, 3.7594870e+00,
 1.8037080e-01, 1.7516560e-01, 1.2383150e-01, 2.2523230e-01, 2.2297120e-01, 1.5686610e-01, 8.5520030e-02, 2.1093060e-01,
 8.2807700e-02, 1.4610400e-01, 5.4315620e-02, 2.4617540e-01, 2.7355920e-01, 2.6126640e-01, 1.6321690e-01, 3.9358500e-01,
 2.5632420e-01, 2.8518560e-01, 2.3484230e-01, 2.6298660e-01, 3.3911940e-01, 2.7333070e-01, 1.7357750e-01, 2.6358640e-01,
 1.1060930e-01, 2.2358300e-01, 9.6820540e-02, 2.7017500e-01, 2.9611440e-01, 3.2400160e-01, 2.3577360e-01, 3.5004680e-01,
 7.8558630e-02, 9.0944880e-02, 7.5804460e-02, 7.0564490e-02, 1.7171440e-01, 1.4400870e-01, 9.2568150e-02, 1.1684910e-01,
 6.7999150e-02, 1.4302000e-01, 6.2689290e-02, 1.4541360e-01, 2.7949610e-01, 3.1820700e-01, 2.3438260e-01, 2.8926150e-01,
 2.2126320e-01, 2.7881340e-01, 1.6030410e-01, 3.0762930e-01, 2.1817260e-01, 1.9916020e-01, 8.8305920e-02, 2.2979740e-01,
 8.9441350e-02, 2.0476320e-01, 6.1910290e-02, 2.9605080e-01, 2.6152050e-01, 3.2408570e-01, 1.6466070e-01, 4.1893520e-01,
 4.3370560e-01, 5.6718930e-01, 4.1289190e-01, 7.1559280e-01, 7.2583290e-01, 6.8765010e-01, 3.8603990e-01, 9.0726470e-01,
 2.7236740e-01, 6.4713840e-01, 2.4773390e-01, 1.0698810e+00, 7.0544390e-01, 9.0728810e-01, 5.8365030e-01, 1.3410840e+00,
 5.8902210e-01, 8.8251090e-01, 7.4833270e-01, 7.9851310e-01, 1.0550030e+00, 1.1450910e+00, 7.4880880e-01, 1.0835040e+00,
 3.4768770e-01, 9.4642640e-01, 4.2202820e-01, 1.1221460e+00, 7.2976620e-01, 1.0752810e+00, 8.0574150e-01, 1.1398740e+00,
 1.5950230e-01, 2.4865770e-01, 2.1342450e-01, 1.8930660e-01, 4.7199670e-01, 5.3305450e-01, 3.5283390e-01, 4.2438900e-01,
 1.8885660e-01, 5.3490440e-01, 2.4143400e-01, 5.3363030e-01, 6.0859890e-01, 9.3307320e-01, 7.0771310e-01, 8.3224770e-01,
 5.7423330e-01, 9.7441370e-01, 5.7689960e-01, 1.0549050e+00, 7.6654670e-01, 9.4230490e-01, 4.3023390e-01, 1.0668170e+00,
 3.1752150e-01, 9.7889740e-01, 3.0477130e-01, 1.3886970e+00, 7.2789250e-01, 1.2147080e+00, 6.3551810e-01, 1.5406890e+00,
 1.2567470e-01, 1.4194640e-01, 8.8026160e-02, 1.4625960e-01, 1.7977590e-01, 1.4709770e-01, 7.0347630e-02, 1.5850190e-01,
 7.3428100e-02, 1.5067730e-01, 4.9137750e-02, 2.0344560e-01, 1.2731610e-01, 1.4141960e-01, 7.7498990e-02, 1.7071930e-01,
 3.5689740e-01, 4.6182290e-01, 3.3360230e-01, 3.4127110e-01, 5.4639590e-01, 5.1219740e-01, 2.8532990e-01, 3.9581290e-01,
 1.9599970e-01, 4.6078320e-01, 1.7503710e-01, 4.4619120e-01, 2.7539980e-01, 3.5046560e-01, 2.2371650e-01, 3.0341870e-01,
 9.5194830e-02, 1.2817160e-01, 9.3715890e-02, 7.9692570e-02, 2.4078380e-01, 2.3485700e-01, 1.3242840e-01, 1.5270670e-01,
 1.0486560e-01, 2.5651950e-01, 9.8632900e-02, 2.0900030e-01, 2.2622750e-01, 2.9955300e-01, 1.9355040e-01, 2.1820900e-01,
 4.1450230e-01, 6.0747100e-01, 3.0638070e-01, 5.3710300e-01, 4.7295430e-01, 5.0212930e-01, 1.9530240e-01, 4.6427590e-01,
 2.1323870e-01, 5.6777170e-01, 1.5058770e-01, 6.5781860e-01, 3.2724560e-01, 4.7165250e-01, 2.1021180e-01, 4.8857030e-01,
 4.0445780e-01, 4.8001620e-01, 3.6503640e-01, 4.8901010e-01, 9.2638030e-01, 7.9647060e-01, 4.6709620e-01, 8.4851630e-01,
 2.9655110e-01, 6.3942720e-01, 2.5571220e-01, 8.5359810e-01, 9.5982120e-01, 1.1202700e+00, 7.5283900e-01, 1.3370800e+00,
 5.9304540e-01, 8.0635460e-01, 7.1428690e-01, 5.8913120e-01, 1.4537320e+00, 1.4319250e+00, 9.7819010e-01, 1.0940440e+00,
 4.0870680e-01, 1.0096220e+00, 4.7031140e-01, 9.6659670e-01, 1.0719880e+00, 1.4334340e+00, 1.1220790e+00, 1.2269770e+00,
 2.0157840e-01, 2.8518620e-01, 2.5570710e-01, 1.7531390e-01, 8.1637610e-01, 8.3670550e-01, 5.7855310e-01, 5.3788450e-01,
 2.7866050e-01, 7.1625700e-01, 3.3772500e-01, 5.7697520e-01, 1.1221680e+00, 1.5613200e+00, 1.2371020e+00, 1.1244830e+00,
 5.8977970e-01, 9.0822700e-01, 5.6172440e-01, 7.9394120e-01, 1.0774930e+00, 1.2020340e+00, 5.7332650e-01, 1.0988520e+00,
 3.8075080e-01, 1.0652570e+00, 3.4646800e-01, 1.2202500e+00, 1.0907330e+00, 1.6518580e+00, 9.0281870e-01, 1.6917630e+00,
 9.3049080e-01, 9.5309840e-01, 7.7544790e-01, 1.2834200e+00, 1.5406290e+00, 1.1431980e+00, 7.1728670e-01, 1.6098340e+00,
 4.3345450e-01, 8.0663710e-01, 3.4512230e-01, 1.4233430e+00, 1.5765910e+00, 1.5881610e+00, 1.1418490e+00, 2.5055240e+00,
 1.2732980e+00, 1.4942090e+00, 1.4160950e+00, 1.4430000e+00, 2.2562990e+00, 1.9181190e+00, 1.4018870e+00, 1.9371320e+00,
 5.5751830e-01, 1.1886370e+00, 5.9239370e-01, 1.5041970e+00, 1.6433190e+00, 1.8965000e+00, 1.5883020e+00, 2.1457580e+00,
 3.7260210e-01, 4.5495960e-01, 4.3643710e-01, 3.6968330e-01, 1.0908410e+00, 9.6491030e-01, 7.1382550e-01, 8.1992180e-01,
 3.2725160e-01, 7.2596940e-01, 3.6622430e-01, 7.7299320e-01, 1.4809790e+00, 1.7783870e+00, 1.5075590e+00, 1.6929970e+00,
 1.1364530e+00, 1.5104240e+00, 9.9945290e-01, 1.7452670e+00, 1.5008800e+00, 1.4450790e+00, 7.3741340e-01, 1.7461560e+00,
 4.6613040e-01, 1.1255480e+00, 3.9165840e-01, 1.7042270e+00, 1.5006170e+00, 1.9614040e+00, 1.1469110e+00, 2.6552360e+00,
 9.2603850e-01, 1.2773360e+00, 1.0701530e+00, 1.6876880e+00, 2.0757460e+00, 2.0741890e+00, 1.3401250e+00, 2.8659190e+00,
 5.9008710e-01, 1.4787720e+00, 6.5151140e-01, 2.5602870e+00, 1.6827460e+00, 2.2826770e+00, 1.6899900e+00, 3.5334940e+00,
 1.2110450e+00, 1.9137800e+00, 1.8676650e+00, 1.8134390e+00, 2.9052660e+00, 3.3259480e+00, 2.5031030e+00, 3.2957560e+00,
 7.2534550e-01, 2.0825030e+00, 1.0687410e+00, 2.5858120e+00, 1.6762330e+00, 2.6050480e+00, 2.2465800e+00, 2.8920100e+00,
 3.1311700e-01, 5.1485470e-01, 5.0858020e-01, 4.1048540e-01, 1.2410290e+00, 1.4782840e+00, 1.1261310e+00, 1.2325360e+00,
 3.7618270e-01, 1.1237920e+00, 5.8376840e-01, 1.1740840e+00, 1.3347280e+00, 2.1583430e+00, 1.8840580e+00, 2.0160740e+00,
 1.2207280e+00, 2.1848260e+00, 1.4886960e+00, 2.4770570e+00, 2.1825920e+00, 2.8298840e+00, 1.4870100e+00, 3.3551820e+00,
 6.8490520e-01, 2.2270890e+00, 7.9800720e-01, 3.3086970e+00, 1.7287000e+00, 3.0427580e+00, 1.8321280e+00, 4.0416560e+00,
 3.9528810e-01, 4.7090530e-01, 3.3608820e-01, 5.0813910e-01, 7.5735750e-01, 6.5360980e-01, 3.5974480e-01, 7.3755800e-01,
 2.3434470e-01, 5.0720550e-01, 1.9036350e-01, 7.1718870e-01, 4.4737450e-01, 5.2413200e-01, 3.3056700e-01, 6.6261720e-01,
 1.0809460e+00, 1.4752960e+00, 1.2264930e+00, 1.1417010e+00, 2.2165200e+00, 2.1915160e+00, 1.4050340e+00, 1.7735620e+00,
 6.0234180e-01, 1.4935760e+00, 6.5297000e-01, 1.5146100e+00, 9.3185020e-01, 1.2507520e+00, 9.1887440e-01, 1.1340110e+00,
 2.7528650e-01, 3.9093680e-01, 3.2897300e-01, 2.5455500e-01, 9.3261480e-01, 9.5944870e-01, 6.2263250e-01, 6.5331910e-01,
 3.0770280e-01, 7.9389320e-01, 3.5131420e-01, 6.7738800e-01, 7.3086800e-01, 1.0207290e+00, 7.5903730e-01, 7.7867870e-01,
 1.2980430e+00, 2.0064620e+00, 1.1646600e+00, 1.8578560e+00, 1.9837410e+00, 2.2213890e+00, 9.9437230e-01, 2.1509690e+00,
 6.7757180e-01, 1.9028570e+00, 5.8083700e-01, 2.3088070e+00, 1.1448750e+00, 1.7404020e+00, 8.9272320e-01, 1.8880070e+00,
 8.4986880e-01, 1.0638430e+00, 9.3108730e-01, 1.1349810e+00, 2.6071830e+00, 2.3642590e+00, 1.5957470e+00, 2.6377560e+00,
 6.3227370e-01, 1.4379370e+00, 6.6180880e-01, 2.0102550e+00, 2.2531540e+00, 2.7737440e+00, 2.1452520e+00, 3.4669720e+00,
 1.1999450e+00, 1.7208480e+00, 1.7543710e+00, 1.3166720e+00, 3.9396830e+00, 4.0929870e+00, 3.2179230e+00, 3.2749440e+00,
 8.3909670e-01, 2.1862630e+00, 1.1720910e+00, 2.1919860e+00, 2.4231760e+00, 3.4175590e+00, 3.0788890e+00, 3.0635420e+00,
 3.8942900e-01, 5.8110670e-01, 5.9965660e-01, 3.7410440e-01, 2.1124090e+00, 2.2835130e+00, 1.8172160e+00, 1.5373370e+00,
 5.4624380e-01, 1.4808910e+00, 8.0361830e-01, 1.2492820e+00, 2.4219430e+00, 3.5541950e+00, 3.2410600e+00, 2.6807180e+00,
 1.2338570e+00, 2.0040680e+00, 1.4265060e+00, 1.8346600e+00, 3.0192080e+00, 3.5525370e+00, 1.9500960e+00, 3.4010270e+00,
 8.0824430e-01, 2.3850610e+00, 8.9277200e-01, 2.8611640e+00, 2.5492660e+00, 4.0720460e+00, 2.5613740e+00, 4.3674570e+00,
 6.7722950e-01, 5.8405850e-01, 5.1712650e-01, 1.1273510e+00, 1.0266320e+00, 6.4140620e-01, 4.3795530e-01, 1.2946860e+00,
 2.9430990e-01, 4.6114160e-01, 2.1471120e-01, 1.1663730e+00, 1.0308790e+00, 8.7433490e-01, 6.8409650e-01, 1.9772140e+00,
 1.0023840e+00, 9.9039870e-01, 1.0214490e+00, 1.3709980e+00, 1.6262730e+00, 1.1640380e+00, 9.2582780e-01, 1.6850880e+00,
 4.0944980e-01, 7.3499710e-01, 3.9863210e-01, 1.3332540e+00, 1.1622260e+00, 1.1293180e+00, 1.0292530e+00, 1.8315380e+00,
 3.4706290e-01, 3.5680460e-01, 3.7248170e-01, 4.1558440e-01, 9.3028780e-01, 6.9284720e-01, 5.5778670e-01, 8.4390740e-01,
 2.8436900e-01, 5.3114550e-01, 2.9158680e-01, 8.1066740e-01, 1.2393000e+00, 1.2529930e+00, 1.1559050e+00, 1.7098200e+00,
 1.1514270e+00, 1.2884840e+00, 9.2782890e-01, 2.1340950e+00, 1.3922720e+00, 1.1286630e+00, 6.2677190e-01, 1.9549140e+00,
 4.4058550e-01, 8.9573930e-01, 3.3919580e-01, 1.9440920e+00, 1.3659020e+00, 1.5031830e+00, 9.5653280e-01, 2.9168870e+00,
 5.0996040e-01, 5.9225330e-01, 5.3997510e-01, 1.1216730e+00, 1.0465850e+00, 8.8052850e-01, 6.1910740e-01, 1.7439370e+00,
 3.0315240e-01, 6.3964800e-01, 3.0668130e-01, 1.5874510e+00, 8.3251210e-01, 9.5084840e-01, 7.6608450e-01, 2.1098090e+00,
 7.2135300e-01, 9.5978580e-01, 1.0193110e+00, 1.3036380e+00, 1.5844060e+00, 1.5271820e+00, 1.2507760e+00, 2.1692130e+00,
 4.0306030e-01, 9.7432880e-01, 5.4414920e-01, 1.7341580e+00, 8.9698800e-01, 1.1737160e+00, 1.1015250e+00, 1.8677490e+00,
 2.2067500e-01, 3.0551040e-01, 3.2841750e-01, 3.4914900e-01, 8.0079520e-01, 8.0314170e-01, 6.6580750e-01, 9.5985460e-01,
 2.4733340e-01, 6.2210640e-01, 3.5167770e-01, 9.3164360e-01, 8.4509170e-01, 1.1506050e+00, 1.0930140e+00, 1.5405800e+00,
 9.3580970e-01, 1.4101990e+00, 1.0456720e+00, 2.2917720e+00, 1.5319140e+00, 1.6723420e+00, 9.5630430e-01, 2.8421330e+00,
 4.8982030e-01, 1.3410310e+00, 5.2291790e-01, 2.8558150e+00, 1.1905650e+00, 1.7643950e+00, 1.1561380e+00, 3.3593830e+00,
 2.6869650e-01, 2.6951110e-01, 2.0932540e-01, 4.1686700e-01, 4.7134850e-01, 3.4249530e-01, 2.0514270e-01, 5.5399260e-01,
 1.4860760e-01, 2.7080990e-01, 1.1060880e-01, 5.4889070e-01, 2.7320220e-01, 2.6949360e-01, 1.8496640e-01, 4.8836250e-01,
 7.9475340e-01, 9.1327690e-01, 8.2625480e-01, 1.0130890e+00, 1.4920830e+00, 1.2421120e+00, 8.6661990e-01, 1.4409020e+00,
 4.1315120e-01, 8.6255750e-01, 4.1037370e-01, 1.2538150e+00, 6.1551580e-01, 6.9559910e-01, 5.5612140e-01, 9.0401760e-01,
 2.3948170e-01, 2.8634440e-01, 2.6222130e-01, 2.6726100e-01, 7.4281820e-01, 6.4342340e-01, 4.5439380e-01, 6.2801820e-01,
 2.4972170e-01, 5.4247750e-01, 2.6124080e-01, 6.6348170e-01, 5.7120360e-01, 6.7167180e-01, 5.4354500e-01, 7.3447490e-01,
 1.2282840e+00, 1.5985840e+00, 1.0097860e+00, 2.1217220e+00, 1.7186510e+00, 1.6203990e+00, 7.8935430e-01, 2.2490720e+00,
 5.9813960e-01, 1.4143210e+00, 4.6980950e-01, 2.4598090e+00, 9.7326790e-01, 1.2457150e+00, 6.9536290e-01, 1.9370670e+00,
 5.0884780e-01, 5.3630090e-01, 5.1079510e-01, 8.2014620e-01, 1.4292240e+00, 1.0912360e+00, 8.0151810e-01, 1.7451400e+00,
 3.5316580e-01, 6.7625150e-01, 3.3870880e-01, 1.3551630e+00, 1.2119690e+00, 1.2562090e+00, 1.0573030e+00, 2.2507000e+00,
 7.7710090e-01, 9.3832550e-01, 1.0410170e+00, 1.0291060e+00, 2.3359870e+00, 2.0433570e+00, 1.7482560e+00, 2.3435790e+00,
 5.0695070e-01, 1.1121180e+00, 6.4883660e-01, 1.5982990e+00, 1.4098270e+00, 1.6741400e+00, 1.6413270e+00, 2.1511530e+00,
 2.9840310e-01, 3.7490890e-01, 4.2101540e-01, 3.4596690e-01, 1.4819930e+00, 1.3488580e+00, 1.1681400e+00, 1.3016780e+00,
 3.9048030e-01, 8.9131370e-01, 5.2635990e-01, 1.0778040e+00, 1.6672610e+00, 2.0600410e+00, 2.0443120e+00, 2.2271910e+00,
 1.0284000e+00, 1.4063870e+00, 1.0894100e+00, 1.8455240e+00, 2.3040040e+00, 2.2825680e+00, 1.3635360e+00, 3.1323270e+00,
 6.2845990e-01, 1.5614540e+00, 6.3605680e-01, 2.6850000e+00, 1.9088740e+00, 2.5672580e+00, 1.7573380e+00, 3.9469110e+00,
 9.5821970e-01, 1.0920700e+00, 6.6320310e-01, 1.3306030e+00, 1.9445170e+00, 1.6054430e+00, 7.5187790e-01, 2.0456040e+00,
 5.7250310e-01, 1.1854200e+00, 3.7857180e-01, 1.8926510e+00, 2.2618210e+00, 2.5350890e+00, 1.3604690e+00, 3.6187970e+00,
 1.5417650e+00, 2.0130710e+00, 1.4240380e+00, 1.7590620e+00, 3.3484620e+00, 3.1672620e+00, 1.7278370e+00, 2.8942400e+00,
 8.6582200e-01, 2.0538960e+00, 7.6404830e-01, 2.3518020e+00, 2.7720190e+00, 3.5594810e+00, 2.2250930e+00, 3.6440270e+00,
 4.5443140e-01, 6.1738410e-01, 4.4206450e-01, 4.5392020e-01, 1.6305920e+00, 1.6048340e+00, 8.8616920e-01, 1.2339080e+00,
 5.1190120e-01, 1.2635210e+00, 4.7576500e-01, 1.2173250e+00, 2.5162750e+00, 3.3619790e+00, 2.1272780e+00, 2.8959560e+00,
 1.6278800e+00, 2.4072980e+00, 1.1889800e+00, 2.5168650e+00, 2.6349830e+00, 2.8228180e+00, 1.0751860e+00, 3.0863240e+00,
 8.5636700e-01, 2.3007860e+00, 5.9758650e-01, 3.1521480e+00, 2.9945190e+00, 4.3549590e+00, 1.9007620e+00, 5.3344180e+00,
 1.0141100e+00, 1.5563990e+00, 9.7329170e-01, 1.8606940e+00, 2.7860640e+00, 3.0975950e+00, 1.4938360e+00, 3.8726410e+00,
 8.2880730e-01, 2.3109920e+00, 7.5997690e-01, 3.6203690e+00, 2.5672060e+00, 3.8747730e+00, 2.1412500e+00, 5.4271670e+00,
 1.5593780e+00, 2.7418450e+00, 1.9972440e+00, 2.3508280e+00, 4.5849840e+00, 5.8401900e+00, 3.2807380e+00, 5.2364090e+00,
 1.1978920e+00, 3.8266420e+00, 1.4658380e+00, 4.2992850e+00, 3.0068500e+00, 5.1993940e+00, 3.3468800e+00, 5.2228040e+00,
 4.0609980e-01, 7.4296860e-01, 5.4780570e-01, 5.3598240e-01, 1.9727360e+00, 2.6145950e+00, 1.4866770e+00, 1.9724810e+00,
 6.2575780e-01, 2.0799500e+00, 8.0647140e-01, 1.9662260e+00, 2.4115980e+00, 4.3390270e+00, 2.8271410e+00, 3.6672900e+00,
 1.8594870e+00, 3.7029750e+00, 1.8833080e+00, 3.7987170e+00, 4.0748110e+00, 5.8784540e+00, 2.3056310e+00, 6.3063450e+00,
 1.3380920e+00, 4.8411980e+00, 1.2948020e+00, 6.5078770e+00, 3.6684270e+00, 7.1843490e+00, 3.2289180e+00, 8.6346840e+00,
 4.9556140e-01, 6.5686610e-01, 3.4992730e-01, 6.4134690e-01, 1.1637110e+00, 1.1174360e+00, 4.5907090e-01, 1.1409510e+00,
 3.7680810e-01, 9.0742050e-01, 2.5420820e-01, 1.1609810e+00, 7.8134160e-01, 1.0185210e+00, 4.7947970e-01, 1.1650890e+00,
 1.5933920e+00, 2.4196780e+00, 1.5014990e+00, 1.6943290e+00, 4.0045250e+00, 4.4053840e+00, 2.1081780e+00, 3.2259110e+00,
 1.1387890e+00, 3.1418610e+00, 1.0252610e+00, 2.8828860e+00, 1.9135990e+00, 2.8578250e+00, 1.5671190e+00, 2.3444920e+00,
 4.0873200e-01, 6.4583250e-01, 4.0565320e-01, 3.8050640e-01, 1.6971360e+00, 1.9426550e+00, 9.4099440e-01, 1.1969230e+00,
 5.8595790e-01, 1.6821190e+00, 5.5561210e-01, 1.2986710e+00, 1.5117460e+00, 2.3491440e+00, 1.3038990e+00, 1.6215290e+00,
 2.2635550e+00, 3.8930720e+00, 1.6867160e+00, 3.2616740e+00, 4.2398200e+00, 5.2825870e+00, 1.7650310e+00, 4.6283200e+00,
 1.5154390e+00, 4.7353150e+00, 1.0788930e+00, 5.1987320e+00, 2.7812880e+00, 4.7043220e+00, 1.8011320e+00, 4.6176190e+00,
 7.2899920e-01, 1.0153420e+00, 6.6329450e-01, 9.8014530e-01, 2.7409890e+00, 2.7656070e+00, 1.3932880e+00, 2.7918820e+00,
 6.9560310e-01, 1.7601750e+00, 6.0468600e-01, 2.2265600e+00, 2.6924780e+00, 3.6879690e+00, 2.1290230e+00, 4.1709810e+00,
 1.2102400e+00, 1.9311340e+00, 1.4695100e+00, 1.3369480e+00, 4.8700360e+00, 5.6295140e+00, 3.3036000e+00, 4.0756930e+00,
 1.0854340e+00, 3.1466870e+00, 1.2591970e+00, 2.8546700e+00, 3.4047190e+00, 5.3428370e+00, 3.5927850e+00, 4.3335810e+00,
 3.9561560e-01, 6.5684160e-01, 5.0592790e-01, 3.8261730e-01, 2.6301700e+00, 3.1635080e+00, 1.8791140e+00, 1.9270870e+00,
 7.1172620e-01, 2.1468870e+00, 8.6959540e-01, 1.6387530e+00, 3.4276390e+00, 5.5967010e+00, 3.8094230e+00, 3.8195220e+00,
 1.4721700e+00, 2.6605130e+00, 1.4135390e+00, 2.2038170e+00, 4.4151640e+00, 5.7803230e+00, 2.3683770e+00, 5.0071510e+00,
 1.2368510e+00, 4.0610060e+00, 1.1346350e+00, 4.4080250e+00, 4.2373520e+00, 7.5309830e+00, 3.5358450e+00, 7.3086070e+00,
 3.4096050e-01, 3.3112090e-01, 2.3408260e-01, 4.2576360e-01, 5.3913390e-01, 3.7929490e-01, 2.0678340e-01, 5.1002030e-01,
 1.8552500e-01, 3.2733610e-01, 1.2169040e-01, 5.5153910e-01, 6.5800260e-01, 6.2843420e-01, 3.9259200e-01, 9.4670520e-01,
 5.5029540e-01, 6.1225720e-01, 5.0417660e-01, 5.6459870e-01, 9.3125570e-01, 7.5059350e-01, 4.7666120e-01, 7.2383450e-01,
 2.8144390e-01, 5.6890390e-01, 2.4635860e-01, 6.8745660e-01, 8.0891740e-01, 8.8509910e-01, 6.4407990e-01, 9.5624860e-01,
 1.8227980e-01, 2.1101970e-01, 1.7588930e-01, 1.6373100e-01, 5.0963750e-01, 4.2740890e-01, 2.7473650e-01, 3.4680080e-01,
 1.8700020e-01, 3.9331040e-01, 1.7239790e-01, 3.9989290e-01, 8.2519920e-01, 9.3949150e-01, 6.9200380e-01, 8.5403120e-01,
 5.4663450e-01, 6.8881320e-01, 3.9603400e-01, 7.6000330e-01, 6.8944280e-01, 6.2936200e-01, 2.7905370e-01, 7.2617790e-01,
 2.6189070e-01, 5.9956130e-01, 1.8127780e-01, 8.6685800e-01, 8.2211390e-01, 1.0187940e+00, 5.1762620e-01, 1.3169620e+00,
 7.9529290e-01, 1.0400640e+00, 7.5712660e-01, 1.3121940e+00, 1.7024680e+00, 1.6129090e+00, 9.0547070e-01, 2.1280230e+00,
 5.9194470e-01, 1.4064460e+00, 5.3840800e-01, 2.3252060e+00, 1.6460120e+00, 2.1169750e+00, 1.3618310e+00, 3.1291520e+00,
 1.2266820e+00, 1.8378950e+00, 1.5584580e+00, 1.6629630e+00, 2.8103750e+00, 3.0503570e+00, 1.9947180e+00, 2.8862980e+00,
 8.5819060e-01, 2.3360450e+00, 1.0416840e+00, 2.7697690e+00, 1.9338500e+00, 2.8494490e+00, 2.1351810e+00, 3.0206180e+00,
 3.5900950e-01, 5.5968140e-01, 4.8037810e-01, 4.2609340e-01, 1.3589010e+00, 1.5346900e+00, 1.0158260e+00, 1.2218370e+00,
 5.0380800e-01, 1.4269510e+00, 6.4406740e-01, 1.4235520e+00, 1.7430450e+00, 2.6723490e+00, 2.0269110e+00, 2.3835810e+00,
 1.3761650e+00, 2.3352080e+00, 1.3825550e+00, 2.5281070e+00, 2.3498000e+00, 2.8885750e+00, 1.3188540e+00, 3.2702590e+00,
 9.0188090e-01, 2.7804380e+00, 8.6566530e-01, 3.9444240e+00, 2.2196670e+00, 3.7041830e+00, 1.9379760e+00, 4.6982420e+00,
 3.5671170e-01, 4.0289690e-01, 2.4985110e-01, 4.1513940e-01, 6.5269620e-01, 5.3405440e-01, 2.5540490e-01, 5.7545860e-01,
 2.4701640e-01, 5.0688720e-01, 1.6530220e-01, 6.8440280e-01, 4.5982360e-01, 5.1076080e-01, 2.7990070e-01, 6.1658160e-01,
 1.1504860e+00, 1.4887210e+00, 1.0753930e+00, 1.1001130e+00, 2.2529700e+00, 2.1119590e+00, 1.1765090e+00, 1.6320670e+00,
 7.4883710e-01, 1.7604690e+00, 6.6874730e-01, 1.7047190e+00, 1.1296400e+00, 1.4375460e+00, 9.1764460e-01, 1.2445680e+00,
 3.3165750e-01, 4.4654810e-01, 3.2650480e-01, 2.7764780e-01, 1.0730350e+00, 1.0466220e+00, 5.9015710e-01, 6.8052570e-01,
 4.3301530e-01, 1.0592310e+00, 4.0727900e-01, 8.6301250e-01, 1.0029060e+00, 1.3279710e+00, 8.5804280e-01, 9.6735840e-01,
 1.5376110e+00, 2.2534350e+00, 1.1365300e+00, 1.9924030e+00, 2.2441340e+00, 2.3825680e+00, 9.2669610e-01, 2.2029560e+00,
 9.3751790e-01, 2.4962450e+00, 6.6206860e-01, 2.8921420e+00, 1.5446560e+00, 2.2262820e+00, 9.9223620e-01, 2.3061370e+00,
 7.2101060e-01, 8.5570540e-01, 6.5073570e-01, 8.7173840e-01, 2.1123590e+00, 1.8161360e+00, 1.0650860e+00, 1.9348120e+00,
 6.2655880e-01, 1.3509940e+00, 5.4027360e-01, 1.8034980e+00, 2.1771940e+00, 2.5411450e+00, 1.7076900e+00, 3.0329440e+00,
 1.2006730e+00, 1.6325360e+00, 1.4461370e+00, 1.1927480e+00, 3.7647090e+00, 3.7082360e+00, 2.5332040e+00, 2.8332300e+00,
 9.8071440e-01, 2.4226450e+00, 1.1285380e+00, 2.3194020e+00, 2.7616270e+00, 3.6927750e+00, 2.8906700e+00, 3.1609070e+00,
 4.4108190e-01, 6.2402750e-01, 5.5952320e-01, 3.8361150e-01, 2.2849440e+00, 2.3418440e+00, 1.6193050e+00, 1.5054780e+00,
 7.2267750e-01, 1.8575390e+00, 8.7585520e-01, 1.4963260e+00, 3.1244340e+00, 4.3471600e+00, 3.4444440e+00, 3.1308800e+00,
 1.3740680e+00, 2.1159860e+00, 1.3087050e+00, 1.8497230e+00, 3.2110200e+00, 3.5821640e+00, 1.7085610e+00, 3.2746730e+00,
 1.0513640e+00, 2.9414850e+00, 9.5669940e-01, 3.3694660e+00, 3.2335170e+00, 4.8969930e+00, 2.6764390e+00, 5.0152930e+00,
 1.1627440e+00, 1.1909940e+00, 9.6900170e-01, 1.6037650e+00, 2.4625220e+00, 1.8272740e+00, 1.1465020e+00, 2.5731390e+00,
 6.4196200e-01, 1.1946590e+00, 5.1113880e-01, 2.1080230e+00, 2.5068570e+00, 2.5252530e+00, 1.8155950e+00, 3.9839040e+00,
 1.8070510e+00, 2.1205650e+00, 2.0097070e+00, 2.0478900e+00, 4.0958790e+00, 3.4819790e+00, 2.5448570e+00, 3.5164920e+00,
 9.3776370e-01, 1.9993260e+00, 9.9642510e-01, 2.5301080e+00, 2.9675680e+00, 3.4247720e+00, 2.8682160e+00, 3.8748920e+00,
 5.7151030e-01, 6.9783320e-01, 6.6942280e-01, 5.6703330e-01, 2.1401810e+00, 1.8931100e+00, 1.4004930e+00, 1.6086490e+00,
 5.9491440e-01, 1.3197480e+00, 6.6576330e-01, 1.4052330e+00, 2.8904550e+00, 3.4709110e+00, 2.9423310e+00, 3.3042540e+00,
 1.8559800e+00, 2.4667260e+00, 1.6322410e+00, 2.8502570e+00, 3.1352920e+00, 3.0187250e+00, 1.5404340e+00, 3.6476660e+00,
 9.0224250e-01, 2.1786120e+00, 7.5809430e-01, 3.2987040e+00, 3.1183880e+00, 4.0759380e+00, 2.3833620e+00, 5.5177690e+00,
 1.1225230e+00, 1.5483580e+00, 1.2972160e+00, 2.0457780e+00, 3.2184790e+00, 3.2160640e+00, 2.0778860e+00, 4.4436540e+00,
 8.4776650e-01, 2.1245230e+00, 9.3601350e-01, 3.6783140e+00, 2.5955130e+00, 3.5208620e+00, 2.6066870e+00, 5.4501570e+00,
 1.6672280e+00, 2.6346720e+00, 2.5711860e+00, 2.4965340e+00, 5.1160020e+00, 5.8567970e+00, 4.4078160e+00, 5.8036300e+00,
 1.1835140e+00, 3.3979280e+00, 1.7438180e+00, 4.2191560e+00, 2.9363480e+00, 4.5634040e+00, 3.9354550e+00, 5.0660890e+00,
 4.6588610e-01, 7.6605110e-01, 7.5671530e-01, 6.1076020e-01, 2.3619200e+00, 2.8134630e+00, 2.1432470e+00, 2.3457550e+00,
 6.6338510e-01, 1.9817680e+00, 1.0294550e+00, 2.0704570e+00, 2.5269940e+00, 4.0863160e+00, 3.5670220e+00, 3.8169620e+00,
 1.9339040e+00, 3.4612510e+00, 2.3584260e+00, 3.9242090e+00, 4.4228160e+00, 5.7344910e+00, 3.0132860e+00, 6.7989590e+00,
 1.2859990e+00, 4.1816510e+00, 1.4983630e+00, 6.2125110e+00, 3.4847710e+00, 6.1336940e+00, 3.6932640e+00, 8.1473070e+00,
 7.4168150e-01, 8.8356240e-01, 6.3060430e-01, 9.5342450e-01, 1.8176690e+00, 1.5686730e+00, 8.6339260e-01, 1.7701500e+00,
 5.2113800e-01, 1.1279280e+00, 4.2333210e-01, 1.5948910e+00, 1.0681030e+00, 1.2513610e+00, 7.8922640e-01, 1.5819940e+00,
 2.3034350e+00, 3.1437740e+00, 2.6135890e+00, 2.4329010e+00, 6.0416250e+00, 5.9734730e+00, 3.8297380e+00, 4.8342430e+00,
 1.5212790e+00, 3.7721870e+00, 1.6491460e+00, 3.8253110e+00, 2.5267170e+00, 3.3914200e+00, 2.4915330e+00, 3.0748760e+00,
 6.3400900e-01, 9.0036180e-01, 7.5765370e-01, 5.8626250e-01, 2.7474060e+00, 2.8264570e+00, 1.8342240e+00, 1.9246240e+00,
 8.3991590e-01, 2.1670380e+00, 9.5895920e-01, 1.8490210e+00, 2.1418440e+00, 2.9912950e+00, 2.2243960e+00, 2.2819560e+00,
 3.1830460e+00, 4.9202220e+00, 2.8559650e+00, 4.5558120e+00, 6.2222690e+00, 6.9676830e+00, 3.1189820e+00, 6.7468020e+00,
 1.9692590e+00, 5.5303630e+00, 1.6881140e+00, 6.7101950e+00, 3.5723180e+00, 5.4305220e+00, 2.7855370e+00, 5.8910900e+00,
 1.0015080e+00, 1.2536610e+00, 1.0972180e+00, 1.3374920e+00, 3.9299240e+00, 3.5637540e+00, 2.4053410e+00, 3.9760080e+00,
 8.8308300e-01, 2.0083360e+00, 9.2433410e-01, 2.8076800e+00, 3.3785620e+00, 4.1591770e+00, 3.2167640e+00, 5.1986590e+00,
 1.6059500e+00, 2.3031030e+00, 2.3479690e+00, 1.7621720e+00, 6.7443840e+00, 7.0068280e+00, 5.5087950e+00, 5.6064110e+00,
 1.3309960e+00, 3.4679050e+00, 1.8592000e+00, 3.4769830e+00, 4.1266190e+00, 5.8200320e+00, 5.2432840e+00, 5.2171490e+00,
 5.6329720e-01, 8.4055330e-01, 8.6738510e-01, 5.4113070e-01, 3.9083870e+00, 4.2249640e+00, 3.3622190e+00, 2.8443850e+00,
 9.3646110e-01, 2.5387880e+00, 1.3776950e+00, 2.1417250e+00, 4.4577090e+00, 6.5416760e+00, 5.9653350e+00, 4.9339970e+00,
 1.9002790e+00, 3.0864920e+00, 2.1969810e+00, 2.8255830e+00, 5.9477900e+00, 6.9984400e+00, 3.8416580e+00, 6.6999680e+00,
 1.4753300e+00, 4.3535730e+00, 1.6296220e+00, 5.2226300e+00, 4.9958130e+00, 7.9800140e+00, 5.0195400e+00, 8.5589320e+00,
 1.4261610e-01, 1.2299540e-01, 1.0890040e-01, 2.3740610e-01, 1.9916990e-01, 1.2443480e-01, 8.4964730e-02, 2.5117320e-01,
 5.7605940e-02, 9.0260290e-02, 4.2025910e-02, 2.2829690e-01, 1.7255160e-01, 1.4634880e-01, 1.1450610e-01, 3.3095200e-01,
 2.0155100e-01, 1.9914110e-01, 2.0538450e-01, 2.7566890e-01, 3.0124550e-01, 2.1562270e-01, 1.7149730e-01, 3.1214030e-01,
 7.6521130e-02, 1.3736190e-01, 7.4499440e-02, 2.4916880e-01, 1.8574630e-01, 1.8048700e-01, 1.6449460e-01, 2.9271550e-01,
 7.6369430e-02, 7.8513050e-02, 8.1962700e-02, 9.1447250e-02, 1.8858400e-01, 1.4045110e-01, 1.1307220e-01, 1.7107340e-01,
 5.8159860e-02, 1.0863120e-01, 5.9636080e-02, 1.6579980e-01, 2.1675380e-01, 2.1914860e-01, 2.0216790e-01, 2.9904770e-01,
 2.0669170e-01, 2.3129460e-01, 1.6655370e-01, 3.8308950e-01, 2.3024320e-01, 1.8664960e-01, 1.0365070e-01, 3.2328860e-01,
 7.3510000e-02, 1.4945070e-01, 5.6593530e-02, 3.2436440e-01, 1.9488790e-01, 2.1447520e-01, 1.3647880e-01, 4.1618350e-01,
 1.4793030e-01, 1.7180200e-01, 1.5663700e-01, 3.2537710e-01, 2.7968650e-01, 2.3531000e-01, 1.6544850e-01, 4.6604490e-01,
 8.1735660e-02, 1.7246130e-01, 8.2687110e-02, 4.2800690e-01, 1.9195080e-01, 2.1923540e-01, 1.7663470e-01, 4.8645480e-01,
 1.9979600e-01, 2.6583570e-01, 2.8232270e-01, 3.6107390e-01, 4.0427940e-01, 3.8967810e-01, 3.1914990e-01, 5.5349960e-01,
 1.0376210e-01, 2.5082700e-01, 1.4008350e-01, 4.4643430e-01, 1.9747150e-01, 2.5839290e-01, 2.4250030e-01, 4.1118420e-01,
 6.6888670e-02, 9.2603080e-02, 9.9546430e-02, 1.0583030e-01, 2.2361310e-01, 2.2426830e-01, 1.8591930e-01, 2.6802860e-01,
 6.9680630e-02, 1.7526450e-01, 9.9077300e-02, 2.6246970e-01, 2.0360200e-01, 2.7720730e-01, 2.6333220e-01, 3.7116100e-01,
 2.3139930e-01, 3.4870250e-01, 2.5856510e-01, 5.6669050e-01, 3.4896760e-01, 3.8095690e-01, 2.1784460e-01, 6.4743360e-01,
 1.1257480e-01, 3.0820750e-01, 1.2018160e-01, 6.5634830e-01, 2.3399490e-01, 3.4677600e-01, 2.2722860e-01, 6.6025670e-01,
 6.9037410e-02, 6.9246700e-02, 5.3782920e-02, 1.0710750e-01, 1.1156830e-01, 8.1068710e-02, 4.8557330e-02, 1.3113020e-01,
 3.5488960e-02, 6.4672090e-02, 2.6414480e-02, 1.3108050e-01, 5.5793730e-02, 5.5036360e-02, 3.7774090e-02, 9.9734070e-02,
 1.9497240e-01, 2.2404910e-01, 2.0270050e-01, 2.4853530e-01, 3.3721740e-01, 2.8072290e-01, 1.9585990e-01, 3.2565010e-01,
 9.4206210e-02, 1.9667930e-01, 9.3572900e-02, 2.8589330e-01, 1.2002140e-01, 1.3563710e-01, 1.0843990e-01, 1.7627730e-01,
 6.4294450e-02, 7.6875840e-02, 7.0399430e-02, 7.1752460e-02, 1.8372150e-01, 1.5913810e-01, 1.1238540e-01, 1.5532800e-01,
 6.2314240e-02, 1.3536700e-01, 6.5188650e-02, 1.6556170e-01, 1.2189080e-01, 1.4333000e-01, 1.1598860e-01, 1.5673170e-01,
 2.6901420e-01, 3.5011590e-01, 2.2115950e-01, 4.6469150e-01, 3.4676890e-01, 3.2694490e-01, 1.5926650e-01, 4.5379110e-01,
 1.2176110e-01, 2.8790830e-01, 9.5637440e-02, 5.0073450e-01, 1.6942890e-01, 2.1685710e-01, 1.2105050e-01, 3.3720930e-01,
 1.0449430e-01, 1.1013200e-01, 1.0489420e-01, 1.6842100e-01, 2.7038430e-01, 2.0644290e-01, 1.5163330e-01, 3.3015000e-01,
 6.7408290e-02, 1.2907520e-01, 6.4648900e-02, 2.5865810e-01, 1.9782230e-01, 2.0504330e-01, 1.7257700e-01, 3.6736800e-01,
 1.5237040e-01, 1.8398260e-01, 2.0411790e-01, 2.0178250e-01, 4.2195850e-01, 3.6909970e-01, 3.1579440e-01, 4.2333000e-01,
 9.2388670e-02, 2.0267670e-01, 1.1824650e-01, 2.9128020e-01, 2.1971910e-01, 2.6091170e-01, 2.5579800e-01, 3.3525350e-01,
 6.4030510e-02, 8.0446910e-02, 9.0340320e-02, 7.4236610e-02, 2.9295840e-01, 2.6664050e-01, 2.3091630e-01, 2.5731400e-01,
 7.7877600e-02, 1.7776410e-01, 1.0497750e-01, 2.1495780e-01, 2.8435840e-01, 3.5134860e-01, 3.4866600e-01, 3.7985680e-01,
 1.8002010e-01, 2.4618610e-01, 1.9069980e-01, 3.2305630e-01, 3.7155080e-01, 3.6809390e-01, 2.1988800e-01, 5.0512860e-01,
 1.0225070e-01, 2.5404910e-01, 1.0348670e-01, 4.3685050e-01, 2.6559190e-01, 3.5719640e-01, 2.4450790e-01, 5.4915480e-01,
 6.7363810e-01, 7.6773600e-01, 4.6623850e-01, 9.3542720e-01, 1.2593590e+00, 1.0397590e+00, 4.8695080e-01, 1.3248270e+00,
 3.7408410e-01, 7.7457500e-01, 2.4736580e-01, 1.2366930e+00, 1.2638590e+00, 1.4165550e+00, 7.6020170e-01, 2.0221090e+00,
 1.0348990e+00, 1.3512600e+00, 9.5587540e-01, 1.1807580e+00, 2.0706250e+00, 1.9585750e+00, 1.0684610e+00, 1.7897430e+00,
 5.4017970e-01, 1.2814100e+00, 4.7668390e-01, 1.4672720e+00, 1.4789540e+00, 1.8990890e+00, 1.1871530e+00, 1.9441970e+00,
 3.3381720e-01, 4.5351930e-01, 3.2473270e-01, 3.3344160e-01, 1.1034730e+00, 1.0860420e+00, 5.9969880e-01, 8.3502470e-01,
 3.4950730e-01, 8.6268540e-01, 3.2483480e-01, 8.3114510e-01, 1.4691880e+00, 1.9629720e+00, 1.2420620e+00, 1.6908730e+00,
 9.7552390e-01, 1.4425970e+00, 7.1250810e-01, 1.5082570e+00, 1.4546860e+00, 1.5583840e+00, 5.9357470e-01, 1.7038570e+00,
 4.7698550e-01, 1.2815080e+00, 3.3284810e-01, 1.7557060e+00, 1.4263340e+00, 2.0743320e+00, 9.0536140e-01, 2.5408630e+00,
 9.8205280e-01, 1.5071990e+00, 9.4252460e-01, 1.8018750e+00, 2.4855180e+00, 2.7634440e+00, 1.3326890e+00, 3.4548820e+00,
 7.4599010e-01, 2.0800700e+00, 6.8403740e-01, 3.2586090e+00, 1.9760100e+00, 2.9824600e+00, 1.6481460e+00, 4.1773570e+00,
 1.4418480e+00, 2.5351910e+00, 1.8467110e+00, 2.1736460e+00, 3.9055480e+00, 4.9747490e+00, 2.7945750e+00, 4.4604400e+00,
 1.0294740e+00, 3.2886340e+00, 1.2597480e+00, 3.6948260e+00, 2.2098280e+00, 3.8211970e+00, 2.4597270e+00, 3.8384020e+00,
 4.1092370e-01, 7.5179410e-01, 5.5431280e-01, 5.4234910e-01, 1.8389650e+00, 2.4373000e+00, 1.3858660e+00, 1.8387280e+00,
 5.8852440e-01, 1.9561910e+00, 7.5848530e-01, 1.8492330e+00, 1.9396000e+00, 3.4897920e+00, 2.2738130e+00, 2.9495280e+00,
 1.5349580e+00, 3.0567110e+00, 1.5546220e+00, 3.1357420e+00, 3.0987550e+00, 4.4703630e+00, 1.7533540e+00, 4.7957600e+00,
 1.0266430e+00, 3.7143790e+00, 9.9342860e-01, 4.9931270e+00, 2.4069230e+00, 4.7137840e+00, 2.1185530e+00, 5.6653750e+00,
 4.2505860e-01, 5.6341480e-01, 3.0014370e-01, 5.5010350e-01, 9.1954480e-01, 8.8297850e-01, 3.6275000e-01, 9.0156030e-01,
 3.0040100e-01, 7.2341880e-01, 2.0266130e-01, 9.2556370e-01, 5.3268580e-01, 6.9438480e-01, 3.2688900e-01, 7.9430870e-01,
 1.3049460e+00, 1.9816520e+00, 1.2296870e+00, 1.3876100e+00, 3.0213220e+00, 3.3237600e+00, 1.5905720e+00, 2.4338750e+00,
 8.6684730e-01, 2.3915890e+00, 7.8042970e-01, 2.1944570e+00, 1.2456600e+00, 1.8603050e+00, 1.0201180e+00, 1.5261500e+00,
 3.6632690e-01, 5.7882860e-01, 3.6356750e-01, 3.4102960e-01, 1.4012740e+00, 1.6039920e+00, 7.7695060e-01, 9.8826340e-01,
 4.8811980e-01, 1.4012530e+00, 4.6284080e-01, 1.0818300e+00, 1.0769300e+00, 1.6734730e+00, 9.2886540e-01, 1.1551370e+00,
 1.6549940e+00, 2.8464110e+00, 1.2332390e+00, 2.3847660e+00, 2.8558070e+00, 3.5581820e+00, 1.1888690e+00, 3.1174880e+00,
 1.0298490e+00, 3.2179840e+00, 7.3318470e-01, 3.5329090e+00, 1.6163300e+00, 2.7338900e+00, 1.0467180e+00, 2.6835030e+00,
 4.9975920e-01, 6.9605930e-01, 4.5471600e-01, 6.7193030e-01, 1.7310810e+00, 1.7466280e+00, 8.7993540e-01, 1.7632220e+00,
 4.4322590e-01, 1.1215520e+00, 3.8529510e-01, 1.4187240e+00, 1.4671170e+00, 2.0095550e+00, 1.1600930e+00, 2.2727450e+00,
 7.9217950e-01, 1.2640510e+00, 9.6188850e-01, 8.7511770e-01, 2.9367060e+00, 3.3946830e+00, 1.9921210e+00, 2.4577050e+00,
 6.6036720e-01, 1.9144120e+00, 7.6608270e-01, 1.7367520e+00, 1.7713820e+00, 2.7797310e+00, 1.8692270e+00, 2.2546430e+00,
 2.8339090e-01, 4.7051470e-01, 3.6241090e-01, 2.7407990e-01, 1.7356920e+00, 2.0876500e+00, 1.2400580e+00, 1.2717160e+00,
 4.7386580e-01, 1.4293930e+00, 5.7897470e-01, 1.0910780e+00, 1.9515800e+00, 3.1865700e+00, 2.1689550e+00, 2.1747050e+00,
 8.6029170e-01, 1.5547230e+00, 8.2602950e-01, 1.2878440e+00, 2.3768990e+00, 3.1118310e+00, 1.2750130e+00, 2.6955940e+00,
 6.7179180e-01, 2.2057240e+00, 6.1627360e-01, 2.3942060e+00, 1.9681630e+00, 3.4979860e+00, 1.6423270e+00, 3.3946970e+00,
 1.9168170e-01, 1.8615010e-01, 1.3159690e-01, 2.3935650e-01, 2.7922190e-01, 1.9644000e-01, 1.0709490e-01, 2.6414380e-01,
 9.6941320e-02, 1.7104110e-01, 6.3586210e-02, 2.8819260e-01, 2.9402420e-01, 2.8081170e-01, 1.7542720e-01, 4.2302900e-01,
 2.9538660e-01, 3.2864640e-01, 2.7063100e-01, 3.0306430e-01, 4.6051110e-01, 3.7117260e-01, 2.3571160e-01, 3.5794020e-01,
 1.4041600e-01, 2.8383350e-01, 1.2291150e-01, 3.4298100e-01, 3.4512620e-01, 3.7762920e-01, 2.7479800e-01, 4.0798530e-01,
 1.0707650e-01, 1.2395910e-01, 1.0332250e-01, 9.6180330e-02, 2.7579920e-01, 2.3129980e-01, 1.4867840e-01, 1.8767730e-01,
 1.0210040e-01, 2.1474380e-01, 9.4127630e-02, 2.1833780e-01, 3.8529460e-01, 4.3865900e-01, 3.2310420e-01, 3.9875660e-01,
 2.6195550e-01, 3.3008970e-01, 1.8978550e-01, 3.6420510e-01, 3.0437220e-01, 2.7784800e-01, 1.2319540e-01, 3.2058980e-01,
 1.1664880e-01, 2.6705080e-01, 8.0743000e-02, 3.8610750e-01, 3.1314190e-01, 3.8805690e-01, 1.9716310e-01, 5.0162870e-01,
 6.1587390e-01, 8.0542450e-01, 5.8631800e-01, 1.0161620e+00, 1.2145620e+00, 1.1506700e+00, 6.4597450e-01, 1.5181590e+00,
 4.2606480e-01, 1.0123200e+00, 3.8753070e-01, 1.6736170e+00, 1.0131560e+00, 1.3030440e+00, 8.3823680e-01, 1.9260620e+00,
 9.0701630e-01, 1.3589500e+00, 1.1523340e+00, 1.2296050e+00, 1.9143600e+00, 2.0778300e+00, 1.3587540e+00, 1.9660770e+00,
 5.8978890e-01, 1.6054400e+00, 7.1589400e-01, 1.9035160e+00, 1.1365390e+00, 1.6746450e+00, 1.2548640e+00, 1.7752420e+00,
 2.9050220e-01, 4.5288130e-01, 3.8871090e-01, 3.4478490e-01, 1.0129960e+00, 1.1440380e+00, 7.5724960e-01, 9.1082070e-01,
 3.7891200e-01, 1.0732040e+00, 4.8440060e-01, 1.0706480e+00, 1.1210650e+00, 1.7187610e+00, 1.3036380e+00, 1.5330360e+00,
 9.0842500e-01, 1.5415020e+00, 9.1264300e-01, 1.6688370e+00, 1.4289780e+00, 1.7566230e+00, 8.0203190e-01, 1.9887350e+00,
 5.5334700e-01, 1.7059320e+00, 5.3112710e-01, 2.4200920e+00, 1.1646220e+00, 1.9435240e+00, 1.0168240e+00, 2.4650900e+00,
 2.4467170e-01, 2.7635060e-01, 1.7137510e-01, 2.8474790e-01, 4.1243330e-01, 3.3746460e-01, 1.6138820e-01, 3.6362760e-01,
 1.5747880e-01, 3.2315260e-01, 1.0538410e-01, 4.3632300e-01, 2.5068970e-01, 2.7846000e-01, 1.5259820e-01, 3.3615210e-01,
 7.5347020e-01, 9.7498560e-01, 7.0429050e-01, 7.2048050e-01, 1.3593040e+00, 1.2742260e+00, 7.0983330e-01, 9.8468890e-01,
 4.5582900e-01, 1.0716260e+00, 4.0707710e-01, 1.0376900e+00, 5.8803540e-01, 7.4831650e-01, 4.7768110e-01, 6.4786170e-01,
 2.3770320e-01, 3.2004680e-01, 2.3401020e-01, 1.9899380e-01, 7.0849240e-01, 6.9105320e-01, 3.8966300e-01, 4.4933060e-01,
 2.8845510e-01, 7.0561170e-01, 2.7131080e-01, 5.7489980e-01, 5.7132640e-01, 7.5650620e-01, 4.8880200e-01, 5.5107590e-01,
 8.9901480e-01, 1.3175450e+00, 6.6450960e-01, 1.1649240e+00, 1.2087750e+00, 1.2833400e+00, 4.9915330e-01, 1.1865950e+00,
 5.0948300e-01, 1.3565550e+00, 3.5979330e-01, 1.5717000e+00, 7.1784530e-01, 1.0346160e+00, 4.6112020e-01, 1.0717270e+00,
 3.9526700e-01, 4.6910830e-01, 3.5674140e-01, 4.7789790e-01, 1.0668240e+00, 9.1721970e-01, 5.3791050e-01, 9.7715590e-01,
 3.1925710e-01, 6.8838620e-01, 2.7529130e-01, 9.1895550e-01, 9.4869110e-01, 1.1072790e+00, 7.4410910e-01, 1.3215760e+00,
 6.2848070e-01, 8.5453540e-01, 7.5696650e-01, 6.2433260e-01, 1.8154100e+00, 1.7881780e+00, 1.2215570e+00, 1.3662340e+00,
 4.7713310e-01, 1.1786550e+00, 5.4905170e-01, 1.1284260e+00, 1.1489760e+00, 1.5363810e+00, 1.2026650e+00, 1.3150970e+00,
 2.5266610e-01, 3.5746320e-01, 3.2051310e-01, 2.1974510e-01, 1.2058120e+00, 1.2358390e+00, 8.5454010e-01, 7.9447140e-01,
 3.8477070e-01, 9.8899810e-01, 4.6632620e-01, 7.9667970e-01, 1.4225840e+00, 1.9793020e+00, 1.5682870e+00, 1.4255190e+00,
 6.4211230e-01, 9.8881620e-01, 6.1156750e-01, 8.6438950e-01, 1.3823630e+00, 1.5421420e+00, 7.3554540e-01, 1.4097650e+00,
 4.5665230e-01, 1.2776130e+00, 4.1553540e-01, 1.4635030e+00, 1.2010380e+00, 1.8189090e+00, 9.9412020e-01, 1.8628500e+00,
 9.5303150e-01, 9.7618680e-01, 7.9423270e-01, 1.3145100e+00, 1.8594290e+00, 1.3797590e+00, 8.6571370e-01, 1.9429550e+00,
 4.8906030e-01, 9.1011670e-01, 3.8939640e-01, 1.6059370e+00, 1.6331710e+00, 1.6451550e+00, 1.1828260e+00, 2.5954390e+00,
 1.4142040e+00, 1.6595610e+00, 1.5728030e+00, 1.6026850e+00, 2.9530090e+00, 2.5104050e+00, 1.8347680e+00, 2.5352880e+00,
 6.8212620e-01, 1.4543030e+00, 7.2479640e-01, 1.8403920e+00, 1.8459550e+00, 2.1303550e+00, 1.7841530e+00, 2.4103490e+00,
 4.8947000e-01, 5.9765920e-01, 5.7332710e-01, 4.8563570e-01, 1.6886070e+00, 1.4936680e+00, 1.1049920e+00, 1.2692280e+00,
 4.7357230e-01, 1.0505650e+00, 5.2997050e-01, 1.1186140e+00, 1.9676460e+00, 2.3627850e+00, 2.0029600e+00, 2.2493350e+00,
 1.2967320e+00, 1.7234470e+00, 1.1404110e+00, 1.9914120e+00, 2.0180470e+00, 1.9430180e+00, 9.9150840e-01, 2.3478390e+00,
 5.8590900e-01, 1.4147730e+00, 4.9230030e-01, 2.1421520e+00, 1.7317530e+00, 2.2635150e+00, 1.3235670e+00, 3.0642160e+00,
 1.2673790e+00, 1.7481660e+00, 1.4646150e+00, 2.3097760e+00, 3.3476360e+00, 3.3451240e+00, 2.1612710e+00, 4.6219770e+00,
 8.8964630e-01, 2.2294750e+00, 9.8225280e-01, 3.8600240e+00, 2.3292350e+00, 3.1596510e+00, 2.3392630e+00, 4.8910160e+00,
 1.7973160e+00, 2.8402470e+00, 2.7718080e+00, 2.6913310e+00, 5.0808520e+00, 5.8165580e+00, 4.3775310e+00, 5.7637560e+00,
 1.1858590e+00, 3.4046590e+00, 1.7472720e+00, 4.2275130e+00, 2.5160300e+00, 3.9101850e+00, 3.3721220e+00, 4.3409140e+00,
 5.4962920e-01, 9.0374900e-01, 8.9273500e-01, 7.2054450e-01, 2.5670340e+00, 3.0577890e+00, 2.3293700e+00, 2.5494640e+00,
 7.2742070e-01, 2.1730650e+00, 1.1288270e+00, 2.2703150e+00, 2.3695890e+00, 3.8317820e+00, 3.3448350e+00, 3.5792060e+00,
 1.8612300e+00, 3.3311820e+00, 2.2697990e+00, 3.7767420e+00, 3.9213920e+00, 5.0843600e+00, 2.6716630e+00, 6.0281470e+00,
 1.1503650e+00, 3.7406130e+00, 1.3403310e+00, 5.5572790e+00, 2.6657420e+00, 4.6920870e+00, 2.8252330e+00, 6.2324380e+00,
 7.4170380e-01, 8.8358890e-01, 6.3062330e-01, 9.5345310e-01, 1.6745730e+00, 1.4451790e+00, 7.9542200e-01, 1.6307940e+00,
 4.8439050e-01, 1.0483940e+00, 3.9348130e-01, 1.4824290e+00, 8.4899490e-01, 9.9465990e-01, 6.2732620e-01, 1.2574670e+00,
 2.1994160e+00, 3.0018060e+00, 2.4955630e+00, 2.3230350e+00, 5.3144870e+00, 5.2545370e+00, 3.3688110e+00, 4.2524190e+00,
 1.3501130e+00, 3.3477610e+00, 1.4635930e+00, 3.3949070e+00, 1.9176380e+00, 2.5739000e+00, 1.8909360e+00, 2.3336610e+00,
 6.6250200e-01, 9.4082500e-01, 7.9170350e-01, 6.1260980e-01, 2.6447880e+00, 2.7208860e+00, 1.7657140e+00, 1.8527380e+00,
 8.1575070e-01, 2.1046900e+00, 9.3136900e-01, 1.7958230e+00, 1.7789280e+00, 2.4844480e+00, 1.8474920e+00, 1.8952990e+00,
 2.7133750e+00, 4.1942230e+00, 2.4345560e+00, 3.8835840e+00, 4.8864320e+00, 5.4718160e+00, 2.4493790e+00, 5.2983560e+00,
 1.5602690e+00, 4.3817780e+00, 1.3375150e+00, 5.3165740e+00, 2.4204480e+00, 3.6794870e+00, 1.8873590e+00, 3.9915480e+00,
 8.0047890e-01, 1.0020180e+00, 8.7697730e-01, 1.0690220e+00, 2.8937150e+00, 2.6240940e+00, 1.7711220e+00, 2.9276490e+00,
 6.5603470e-01, 1.4919750e+00, 6.8667980e-01, 2.0858010e+00, 2.1463780e+00, 2.6422970e+00, 2.0435880e+00, 3.3026730e+00,
 1.2255920e+00, 1.7576290e+00, 1.7918680e+00, 1.3448140e+00, 4.7416810e+00, 4.9261930e+00, 3.8729920e+00, 3.9416220e+00,
 9.4410530e-01, 2.4598620e+00, 1.3187720e+00, 2.4663010e+00, 2.5031500e+00, 3.5303510e+00, 3.1805040e+00, 3.1646510e+00,
 4.7044820e-01, 7.0200380e-01, 7.2441290e-01, 4.5193540e-01, 3.0071010e+00, 3.2506740e+00, 2.5868810e+00, 2.1884620e+00,
 7.2693200e-01, 1.9707450e+00, 1.0694420e+00, 1.6625230e+00, 2.9591340e+00, 4.3425220e+00, 3.9599330e+00, 3.2753060e+00,
 1.2946920e+00, 2.1028800e+00, 1.4968410e+00, 1.9251180e+00, 3.7331990e+00, 4.3926520e+00, 2.4112610e+00, 4.2053120e+00,
 9.3426100e-01, 2.7569250e+00, 1.0319680e+00, 3.3072600e+00, 2.7054170e+00, 4.3214720e+00, 2.7182660e+00, 4.6349780e+00,
 7.4115140e-01, 6.3918620e-01, 5.6593670e-01, 1.2337590e+00, 9.6528830e-01, 6.0308060e-01, 4.1178640e-01, 1.2173250e+00,
 2.9653240e-01, 4.6462400e-01, 2.1633260e-01, 1.1751810e+00, 8.6127610e-01, 7.3048720e-01, 5.7154720e-01, 1.6519180e+00,
 1.2105140e+00, 1.1960400e+00, 1.2335380e+00, 1.6556650e+00, 1.6873310e+00, 1.2077420e+00, 9.6058780e-01, 1.7483540e+00,
 4.5523180e-01, 8.1717980e-01, 4.4320460e-01, 1.4823300e+00, 1.0714950e+00, 1.0411560e+00, 9.4890220e-01, 1.6885560e+00,
 4.1706150e-01, 4.2876810e-01, 4.4760700e-01, 4.9940310e-01, 9.6046250e-01, 7.1532030e-01, 5.7587900e-01, 8.7128030e-01,
 3.1460840e-01, 5.8762700e-01, 3.2259390e-01, 8.9687290e-01, 1.1369260e+00, 1.1494870e+00, 1.0604200e+00, 1.5685770e+00,
 1.1518720e+00, 1.2889810e+00, 9.2818700e-01, 2.1349190e+00, 1.1966380e+00, 9.7007000e-01, 5.3870160e-01, 1.6802210e+00,
 4.0578310e-01, 8.2498390e-01, 3.1240240e-01, 1.7905260e+00, 1.0431600e+00, 1.1480030e+00, 7.3051840e-01, 2.2276700e+00,
 7.1706090e-01, 8.3277370e-01, 7.5926480e-01, 1.5771970e+00, 1.2643440e+00, 1.0637370e+00, 7.4792260e-01, 2.1067910e+00,
 3.9244320e-01, 8.2805060e-01, 3.9701150e-01, 2.0550200e+00, 8.9366310e-01, 1.0206920e+00, 8.2235610e-01, 2.2647810e+00,
 1.1192630e+00, 1.4892190e+00, 1.5815790e+00, 2.0227460e+00, 2.1121350e+00, 2.0358510e+00, 1.6673810e+00, 2.8917280e+00,
 5.7577190e-01, 1.3918290e+00, 7.7731750e-01, 2.4772460e+00, 1.0625140e+00, 1.3903070e+00, 1.3047950e+00, 2.2124150e+00,
 3.4071680e-01, 4.7170060e-01, 5.0706850e-01, 5.3907750e-01, 1.0622650e+00, 1.0653780e+00, 8.8320240e-01, 1.2732600e+00,
 3.5157620e-01, 8.8430340e-01, 4.9989820e-01, 1.3243000e+00, 9.9611150e-01, 1.3562210e+00, 1.2883380e+00, 1.8158850e+00,
 1.2028280e+00, 1.8125780e+00, 1.3440370e+00, 2.9456930e+00, 1.6916930e+00, 1.8467680e+00, 1.0560470e+00, 3.1385690e+00,
 5.7962770e-01, 1.5869060e+00, 6.1879360e-01, 3.3794210e+00, 1.1682420e+00, 1.7313130e+00, 1.1344600e+00, 3.2963950e+00,
 3.1497440e-01, 3.1592930e-01, 2.4537770e-01, 4.8866450e-01, 4.7470790e-01, 3.4493630e-01, 2.0660480e-01, 5.5794110e-01,
 1.6038010e-01, 2.9226320e-01, 1.1937110e-01, 5.9237310e-01, 2.4449000e-01, 2.4117120e-01, 1.6552730e-01, 4.3703800e-01,
 1.0280410e+00, 1.1813550e+00, 1.0687890e+00, 1.3104640e+00, 1.6582190e+00, 1.3804160e+00, 9.6311380e-01, 1.6013390e+00,
 4.9202040e-01, 1.0272170e+00, 4.8871270e-01, 1.4931640e+00, 6.0782810e-01, 6.8691120e-01, 5.4917560e-01, 8.9272650e-01,
 3.0825230e-01, 3.6857240e-01, 3.3752200e-01, 3.4400890e-01, 8.2146250e-01, 7.1154440e-01, 5.0250170e-01, 6.9450830e-01,
 2.9592840e-01, 6.4285360e-01, 3.0957890e-01, 7.8624760e-01, 5.6129190e-01, 6.6001670e-01, 5.3411320e-01, 7.2172990e-01,
 1.3161600e+00, 1.7129520e+00, 1.0820290e+00, 2.2735170e+00, 1.5822260e+00, 1.4917730e+00, 7.2669610e-01, 2.0705430e+00,
 5.9007680e-01, 1.3952570e+00, 4.6347660e-01, 2.4266510e+00, 7.9617000e-01, 1.0190420e+00, 5.6883320e-01, 1.5845940e+00,
 7.6273580e-01, 8.0388650e-01, 7.6565480e-01, 1.2293560e+00, 1.8405930e+00, 1.4053230e+00, 1.0322160e+00, 2.2474370e+00,
 4.8737260e-01, 9.3323440e-01, 4.6742180e-01, 1.8701390e+00, 1.3868890e+00, 1.4375130e+00, 1.2098990e+00, 2.5755360e+00,
 1.2853700e+00, 1.5520450e+00, 1.7219040e+00, 1.7022020e+00, 3.3196510e+00, 2.9037970e+00, 2.4844320e+00, 3.3304400e+00,
 7.7199210e-01, 1.6935500e+00, 9.8805800e-01, 2.4339140e+00, 1.7802480e+00, 2.1140060e+00, 2.0725730e+00, 2.7163510e+00,
 4.9114580e-01, 6.1706780e-01, 6.9295510e-01, 5.6943170e-01, 2.0956770e+00, 1.9074120e+00, 1.6518590e+00, 1.8406950e+00,
 5.9170120e-01, 1.3506220e+00, 7.9760180e-01, 1.6332140e+00, 2.0949540e+00, 2.5884910e+00, 2.5687270e+00, 2.7985190e+00,
 1.4091100e+00, 1.9270260e+00, 1.4927060e+00, 2.5287290e+00, 2.7122970e+00, 2.6870610e+00, 1.6051680e+00, 3.6874060e+00,
 7.9278720e-01, 1.9697370e+00, 8.0237040e-01, 3.3870640e+00, 1.9967500e+00, 2.6854440e+00, 1.8382390e+00, 4.1286090e+00,
 1.1234810e+00, 1.2804150e+00, 7.7758350e-01, 1.5600870e+00, 1.9587700e+00, 1.6172100e+00, 7.5738890e-01, 2.0605970e+00,
 6.1798020e-01, 1.2795840e+00, 4.0864390e-01, 2.0429950e+00, 2.0245220e+00, 2.2691200e+00, 1.2177350e+00, 3.2391310e+00,
 1.9947270e+00, 2.6044990e+00, 1.8424110e+00, 2.2758640e+00, 3.7220450e+00, 3.5206290e+00, 1.9206090e+00, 3.2171470e+00,
 1.0313120e+00, 2.4464690e+00, 9.1008550e-01, 2.8013170e+00, 2.7379470e+00, 3.5157300e+00, 2.1977440e+00, 3.5992370e+00,
 5.8504560e-01, 7.9483480e-01, 5.6912420e-01, 5.8438740e-01, 1.8035900e+00, 1.7751000e+00, 9.8018750e-01, 1.3648200e+00,
 6.0674160e-01, 1.4976140e+00, 5.6391040e-01, 1.4428600e+00, 2.4731090e+00, 3.3043040e+00, 2.0907850e+00, 2.8462760e+00,
 1.7446950e+00, 2.5800420e+00, 1.2742990e+00, 2.6974720e+00, 2.4263080e+00, 2.5992680e+00, 9.9003820e-01, 2.8419050e+00,
 8.4499320e-01, 2.2702280e+00, 5.8964970e-01, 3.1102830e+00, 2.4501220e+00, 3.5632370e+00, 1.5552080e+00, 4.3646330e+00,
 1.5276860e+00, 2.3446070e+00, 1.4661960e+00, 2.8030060e+00, 3.6058790e+00, 4.0090810e+00, 1.9334060e+00, 5.0121890e+00,
 1.1494730e+00, 3.2051150e+00, 1.0540120e+00, 5.0210910e+00, 2.9523880e+00, 4.4561410e+00, 2.4625220e+00, 6.2414560e+00,
 2.5921800e+00, 4.5578120e+00, 3.3200510e+00, 3.9078200e+00, 6.5482100e+00, 8.3408770e+00, 4.6855040e+00, 7.4785660e+00,
 1.8332740e+00, 5.8563590e+00, 2.2433440e+00, 6.5797010e+00, 3.8158310e+00, 6.5982700e+00, 4.2473440e+00, 6.6279790e+00,
 6.7174230e-01, 1.2289670e+00, 9.0614220e-01, 8.8658490e-01, 2.8035600e+00, 3.7157400e+00, 2.1127970e+00, 2.8031990e+00,
 9.5295490e-01, 3.1675180e+00, 1.2281600e+00, 2.9943280e+00, 3.0453590e+00, 5.4793100e+00, 3.5701050e+00, 4.6310430e+00,
 2.5605810e+00, 5.0991330e+00, 2.5933840e+00, 5.2309720e+00, 4.8208560e+00, 6.9547210e+00, 2.7277620e+00, 7.4609530e+00,
 1.6963980e+00, 6.1375440e+00, 1.6415160e+00, 8.2505150e+00, 3.8564630e+00, 7.5526030e+00, 3.3944250e+00, 9.0772780e+00,
 6.2235780e-01, 8.2493460e-01, 4.3946120e-01, 8.0544450e-01, 1.2556220e+00, 1.2056920e+00, 4.9532880e-01, 1.2310650e+00,
 4.3567140e-01, 1.0491740e+00, 2.9391960e-01, 1.3423450e+00, 7.4911290e-01, 9.7650930e-01, 4.5970220e-01, 1.1170320e+00,
 2.2081580e+00, 3.3532420e+00, 2.0808090e+00, 2.3480380e+00, 4.7679250e+00, 5.2452010e+00, 2.5100690e+00, 3.8408810e+00,
 1.4529370e+00, 4.0085800e+00, 1.3080910e+00, 3.6781640e+00, 2.0245200e+00, 3.0234760e+00, 1.6579560e+00, 2.4803880e+00,
 5.6364040e-01, 8.9060140e-01, 5.5939480e-01, 5.2471740e-01, 2.0107190e+00, 2.3016030e+00, 1.1148630e+00, 1.4180810e+00,
 7.4391990e-01, 2.1355830e+00, 7.0539350e-01, 1.6487660e+00, 1.5914980e+00, 2.4730730e+00, 1.3726860e+00, 1.7070720e+00,
 2.5985450e+00, 4.4692190e+00, 1.9363380e+00, 3.7443790e+00, 4.1817470e+00, 5.2102310e+00, 1.7408560e+00, 4.5649250e+00,
 1.6016730e+00, 5.0047720e+00, 1.1402860e+00, 5.4945590e+00, 2.4375240e+00, 4.1228730e+00, 1.5785140e+00, 4.0468860e+00,
 1.1706920e+00, 1.6305270e+00, 1.0651780e+00, 1.5740050e+00, 3.7817610e+00, 3.8157270e+00, 1.9223280e+00, 3.8519780e+00,
 1.0284270e+00, 2.6023630e+00, 8.9400890e-01, 3.2918970e+00, 3.3008930e+00, 4.5213340e+00, 2.6101160e+00, 5.1134920e+00,
 2.1446270e+00, 3.4221000e+00, 2.6040720e+00, 2.3691620e+00, 7.4145300e+00, 8.5708200e+00, 5.0296630e+00, 6.2051590e+00,
 1.7708430e+00, 5.1336950e+00, 2.0543300e+00, 4.6572810e+00, 4.6060150e+00, 7.2279630e+00, 4.8604370e+00, 5.8626090e+00,
 6.9760560e-01, 1.1582360e+00, 8.9212400e-01, 6.7468520e-01, 3.9846620e+00, 4.7926600e+00, 2.8468260e+00, 2.9195040e+00,
 1.1554360e+00, 3.4853150e+00, 1.4117250e+00, 2.6603970e+00, 4.6141890e+00, 7.5341170e+00, 5.1281350e+00, 5.1417300e+00,
 2.1610770e+00, 3.9055090e+00, 2.0750100e+00, 3.2351000e+00, 5.5683970e+00, 7.2901320e+00, 2.9869930e+00, 6.3150090e+00,
 1.6715740e+00, 5.4883540e+00, 1.5334320e+00, 5.9573410e+00, 4.7486530e+00, 8.4397100e+00, 3.9624990e+00, 8.1905020e+00,
 3.1866450e-01, 3.0946830e-01, 2.1877550e-01, 3.9792220e-01, 4.3290980e-01, 3.0456350e-01, 1.6604150e-01, 4.0953240e-01,
 1.5963510e-01, 2.8165660e-01, 1.0470860e-01, 4.7457220e-01, 4.6948420e-01, 4.4838720e-01, 2.8011400e-01, 6.7547320e-01,
 5.6753180e-01, 6.3143430e-01, 5.1996840e-01, 5.8228310e-01, 8.2515290e-01, 6.6507440e-01, 4.2235270e-01, 6.4136420e-01,
 2.6722830e-01, 5.4016880e-01, 2.3391510e-01, 6.5273340e-01, 6.3688680e-01, 6.9686700e-01, 5.0710490e-01, 7.5288540e-01,
 1.8706350e-01, 2.1655760e-01, 1.8050530e-01, 1.6802790e-01, 4.4934830e-01, 3.7684720e-01, 2.4223560e-01, 3.0577480e-01,
 1.7668060e-01, 3.7160560e-01, 1.6288410e-01, 3.7782490e-01, 6.4650670e-01, 7.3604960e-01, 5.4215410e-01, 6.6909530e-01,
 4.6700680e-01, 5.8847460e-01, 3.3834420e-01, 6.4929440e-01, 5.0605250e-01, 4.6195310e-01, 2.0482600e-01, 5.3301610e-01,
 2.0598830e-01, 4.7158070e-01, 1.4258280e-01, 6.8182100e-01, 5.3619390e-01, 6.6447110e-01, 3.3760290e-01, 8.5894040e-01,
 9.5500410e-01, 1.2489300e+00, 9.0917330e-01, 1.5757100e+00, 1.7564190e+00, 1.6640220e+00, 9.3416520e-01, 2.1954600e+00,
 6.5441840e-01, 1.5548820e+00, 5.9523150e-01, 2.5706080e+00, 1.5089500e+00, 1.9406960e+00, 1.2484330e+00, 2.8685900e+00,
 1.6254550e+00, 2.4353610e+00, 2.0650850e+00, 2.2035620e+00, 3.1994720e+00, 3.4726790e+00, 2.2708870e+00, 3.2859060e+00,
 1.0469420e+00, 2.8498390e+00, 1.2707930e+00, 3.3789570e+00, 1.9562720e+00, 2.8824880e+00, 2.1599380e+00, 3.0556410e+00,
 4.7337470e-01, 7.3797200e-01, 6.3340610e-01, 5.6182850e-01, 1.5394240e+00, 1.7385650e+00, 1.1507730e+00, 1.3841500e+00,
 6.1159000e-01, 1.7322250e+00, 7.8185570e-01, 1.7280990e+00, 1.7545720e+00, 2.6900220e+00, 2.0403160e+00, 2.3993450e+00,
 1.5105850e+00, 2.5633040e+00, 1.5175990e+00, 2.7750460e+00, 2.2160350e+00, 2.7241400e+00, 1.2437770e+00, 3.0840970e+00,
 9.1142330e-01, 2.8098560e+00, 8.7482450e-01, 3.9861580e+00, 1.8600570e+00, 3.1040650e+00, 1.6240030e+00, 3.9370760e+00,
 3.5709940e-01, 4.0333490e-01, 2.5012270e-01, 4.1559070e-01, 5.6137620e-01, 4.5933390e-01, 2.1967070e-01, 4.9494510e-01,
 2.2766370e-01, 4.6717480e-01, 1.5235150e-01, 6.3078280e-01, 3.5142020e-01, 3.9034900e-01, 2.1391420e-01, 4.7122260e-01,
 1.2709190e+00, 1.6445610e+00, 1.1879650e+00, 1.2152730e+00, 2.1382730e+00, 2.0044400e+00, 1.1166140e+00, 1.5489790e+00,
 7.6158790e-01, 1.7904460e+00, 6.8013440e-01, 1.7337470e+00, 9.5266480e-01, 1.2123330e+00, 7.7388190e-01, 1.0495880e+00,
 3.6457130e-01, 4.9086370e-01, 3.5890730e-01, 3.0520170e-01, 1.0133920e+00, 9.8844800e-01, 5.5735440e-01, 6.4270010e-01,
 4.3822000e-01, 1.0719630e+00, 4.1217440e-01, 8.7338560e-01, 8.4162130e-01, 1.1144100e+00, 7.2005450e-01, 8.1179020e-01,
 1.4070670e+00, 2.0621180e+00, 1.0400380e+00, 1.8232470e+00, 1.7643640e+00, 1.8732020e+00, 7.2857930e-01, 1.7319900e+00,
 7.8984920e-01, 2.1030600e+00, 5.5778600e-01, 2.4366000e+00, 1.0791050e+00, 1.5552930e+00, 6.9318170e-01, 1.6110800e+00,
 9.2296770e-01, 1.0953910e+00, 8.3300860e-01, 1.1159150e+00, 2.3231850e+00, 1.9973960e+00, 1.1713880e+00, 2.1279170e+00,
 7.3841910e-01, 1.5921890e+00, 6.3672930e-01, 2.1254790e+00, 2.1276770e+00, 2.4833510e+00, 1.6688510e+00, 2.9639640e+00,
 1.6960330e+00, 2.3060690e+00, 2.0427680e+00, 1.6848390e+00, 4.5689040e+00, 4.5003670e+00, 3.0743320e+00, 3.4384480e+00,
 1.2754060e+00, 3.1506160e+00, 1.4676480e+00, 3.0163500e+00, 2.9780930e+00, 3.9822270e+00, 3.1172510e+00, 3.4086700e+00,
 6.1999040e-01, 8.7714110e-01, 7.8647300e-01, 5.3920930e-01, 2.7593860e+00, 2.8281000e+00, 1.9555340e+00, 1.8180730e+00,
 9.3520430e-01, 2.4038090e+00, 1.1334290e+00, 1.9363700e+00, 3.3527470e+00, 4.6648210e+00, 3.6961410e+00, 3.3596640e+00,
 1.6078650e+00, 2.4760200e+00, 1.5313800e+00, 2.1644530e+00, 3.2281630e+00, 3.6012880e+00, 1.7176830e+00, 3.2921560e+00,
 1.1326370e+00, 3.1688690e+00, 1.0306550e+00, 3.6299330e+00, 2.8885520e+00, 4.3745610e+00, 2.3909060e+00, 4.4802410e+00,
 1.1681050e+00, 1.1964860e+00, 9.7347000e-01, 1.6111600e+00, 2.1254420e+00, 1.5771490e+00, 9.8956410e-01, 2.2209170e+00,
 5.9375000e-01, 1.1049390e+00, 4.7275170e-01, 1.9497090e+00, 1.9226100e+00, 1.9367190e+00, 1.3924530e+00, 3.0554180e+00,
 2.0032410e+00, 2.3507920e+00, 2.2278980e+00, 2.2702270e+00, 3.9010440e+00, 3.3163460e+00, 2.4238030e+00, 3.3492180e+00,
 9.5708900e-01, 2.0405280e+00, 1.0169590e+00, 2.5822480e+00, 2.5114650e+00, 2.8983980e+00, 2.4273820e+00, 3.2793360e+00,
 6.3043890e-01, 7.6978690e-01, 7.3844710e-01, 6.2550020e-01, 2.0283390e+00, 1.7941790e+00, 1.3273060e+00, 1.5245840e+00,
 6.0418460e-01, 1.3403130e+00, 6.7613750e-01, 1.4271300e+00, 2.4341580e+00, 2.9229820e+00, 2.4778450e+00, 2.7826330e+00,
 1.7043850e+00, 2.2652470e+00, 1.4989210e+00, 2.6174510e+00, 2.4736810e+00, 2.3817120e+00, 1.2153710e+00, 2.8779330e+00,
 7.6280590e-01, 1.8419200e+00, 6.4093510e-01, 2.7889080e+00, 2.1861930e+00, 2.8574970e+00, 1.6708910e+00, 3.8683140e+00,
 1.4489110e+00, 1.9985640e+00, 1.6743980e+00, 2.6406140e+00, 3.5691780e+00, 3.5665000e+00, 2.3043010e+00, 4.9278540e+00,
 1.0074400e+00, 2.5246680e+00, 1.1123080e+00, 4.3711080e+00, 2.5576040e+00, 3.4694390e+00, 2.5686150e+00, 5.3705550e+00,
 2.3746850e+00, 3.7526470e+00, 3.6622220e+00, 3.5558930e+00, 6.2605560e+00, 7.1670840e+00, 5.3939350e+00, 7.1020220e+00,
 1.5519610e+00, 4.4557580e+00, 2.2866960e+00, 5.5326470e+00, 3.1928780e+00, 4.9620790e+00, 4.2792710e+00, 5.5086810e+00,
 6.6030880e-01, 1.0857380e+00, 1.0725060e+00, 8.6564150e-01, 2.8760980e+00, 3.4259390e+00, 2.6098200e+00, 2.8564140e+00,
 8.6562410e-01, 2.5859280e+00, 1.3432940e+00, 2.7016540e+00, 2.7342310e+00, 4.4214330e+00, 3.8595520e+00, 4.1299890e+00,
 2.2818020e+00, 4.0839100e+00, 2.7826930e+00, 4.6301510e+00, 4.4834570e+00, 5.8131170e+00, 3.0546010e+00, 6.8921790e+00,
 1.3969470e+00, 4.5424180e+00, 1.6276320e+00, 6.7484880e+00, 3.1389250e+00, 5.5249560e+00, 3.3267270e+00, 7.3387280e+00,
 7.9810050e-01, 9.5077420e-01, 6.7857380e-01, 1.0259510e+00, 1.6804520e+00, 1.4502520e+00, 7.9821450e-01, 1.6365200e+00,
 5.1628460e-01, 1.1174240e+00, 4.1938960e-01, 1.5800380e+00, 8.7743940e-01, 1.0279850e+00, 6.4834400e-01, 1.2995970e+00,
 2.7351480e+00, 3.7329840e+00, 3.1034310e+00, 2.8888780e+00, 6.1635320e+00, 6.0940050e+00, 3.9070140e+00, 4.9317880e+00,
 1.6630680e+00, 4.1237690e+00, 1.8028530e+00, 4.1818430e+00, 2.2904730e+00, 3.0743270e+00, 2.2585780e+00, 2.7873800e+00,
 7.4912870e-01, 1.0638440e+00, 8.9522420e-01, 6.9271270e-01, 2.7890420e+00, 2.8692910e+00, 1.8620210e+00, 1.9537910e+00,
 9.1367780e-01, 2.3573480e+00, 1.0431760e+00, 2.0114030e+00, 1.9320240e+00, 2.6982610e+00, 2.0064890e+00, 2.0584100e+00,
 3.1309750e+00, 4.8397320e+00, 2.8092440e+00, 4.4812840e+00, 5.2584360e+00, 5.8883840e+00, 2.6358500e+00, 5.7017190e+00,
 1.7833470e+00, 5.0082570e+00, 1.5287440e+00, 6.0767040e+00, 2.6825670e+00, 4.0779510e+00, 2.0917480e+00, 4.4238060e+00,
 1.3780580e+00, 1.7250170e+00, 1.5097540e+00, 1.8403670e+00, 4.6458850e+00, 4.2130060e+00, 2.8435510e+00, 4.7003650e+00,
 1.1186930e+00, 2.5441680e+00, 1.1709500e+00, 3.5567810e+00, 3.5490230e+00, 4.3690220e+00, 3.3790610e+00, 5.4609500e+00,
 2.4384280e+00, 3.4969650e+00, 3.5650880e+00, 2.6756310e+00, 8.7981480e+00, 9.1405090e+00, 7.1863040e+00, 7.3136450e+00,
 1.8605910e+00, 4.8477620e+00, 2.5989630e+00, 4.8604510e+00, 4.7833910e+00, 6.7463190e+00, 6.0777790e+00, 6.0474850e+00,
 8.5108250e-01, 1.2699870e+00, 1.3105270e+00, 8.1759120e-01, 5.0734420e+00, 5.4843880e+00, 4.3644660e+00, 3.6922720e+00,
 1.3026270e+00, 3.5314800e+00, 1.9163880e+00, 2.9791610e+00, 5.1417320e+00, 7.5454790e+00, 6.8807000e+00, 5.6911060e+00,
 2.3901600e+00, 3.8821720e+00, 2.7633500e+00, 3.5540030e+00, 6.4274160e+00, 7.5627900e+00, 4.1514470e+00, 7.2402500e+00,
 1.7084220e+00, 5.0414080e+00, 1.8870910e+00, 6.0477690e+00, 4.7971090e+00, 7.6626160e+00, 4.8198920e+00, 8.2185080e+00,
};

static const double acc_score2_plus[16384] =
{2.8738600e-02, 6.0585370e-02, 1.5395830e-02, 8.0934450e-02, 4.7557240e-02, 1.3116140e-01, 3.6121330e-02, 1.7000970e-01,
 8.7537590e-04, 2.7975750e-02, 7.7298380e-03, 5.1774310e-02, 4.8473980e-02, 1.2567770e-01, 5.0497150e-02, 1.3480300e-01,
 2.6315700e-02, 6.7482410e-02, 1.2458800e-02, 8.1931230e-02, 6.0412420e-02, 2.0266980e-01, 4.0550550e-02, 2.3875370e-01,
 1.0937750e-03, 4.2519540e-02, 8.5354660e-03, 7.1517840e-02, 9.2644570e-02, 2.9217490e-01, 8.5290700e-02, 2.8482460e-01,
 3.8250590e-04, 1.1289900e-03, 3.1937570e-04, 1.4783270e-03, 2.3864210e-02, 9.2148110e-02, 2.8250110e-02, 1.1707620e-01,
 3.2153820e-04, 1.4386980e-02, 4.4252160e-03, 2.6098580e-02, 3.0925800e-02, 1.1225880e-01, 5.0211730e-02, 1.1802560e-01,
 5.1204170e-02, 1.3609430e-01, 3.0336100e-02, 1.7796750e-01, 9.5689720e-02, 3.3272650e-01, 8.0376520e-02, 4.2217260e-01,
 2.3030810e-03, 9.2795920e-02, 2.2490640e-02, 1.6811120e-01, 1.2144440e-01, 3.9697170e-01, 1.3991120e-01, 4.1680790e-01,
 3.5290640e-02, 6.1108940e-02, 1.5907110e-02, 7.8450890e-02, 6.7036150e-02, 1.5185940e-01, 4.2840080e-02, 1.8916330e-01,
 1.5272200e-03, 4.0089630e-02, 1.1346750e-02, 7.1300410e-02, 6.1546070e-02, 1.3106690e-01, 5.3945180e-02, 1.3510200e-01,
 5.4146370e-02, 1.1404810e-01, 2.1568730e-02, 1.3306820e-01, 1.4268530e-01, 3.9317430e-01, 8.0583060e-02, 4.4511630e-01,
 3.1973900e-03, 1.0209380e-01, 2.0993700e-02, 1.6502610e-01, 1.9709340e-01, 5.1054970e-01, 1.5266800e-01, 4.7829970e-01,
 7.0180690e-04, 1.7014250e-03, 4.9303240e-04, 2.1410190e-03, 5.0260290e-02, 1.5940710e-01, 5.0060170e-02, 1.9463340e-01,
 8.3815680e-04, 3.0803890e-02, 9.7055760e-03, 5.3700720e-02, 5.8667570e-02, 1.7492050e-01, 8.0145030e-02, 1.7673560e-01,
 1.2384350e-01, 2.7036530e-01, 6.1733610e-02, 3.3976540e-01, 2.6566330e-01, 7.5874670e-01, 1.8775420e-01, 9.2518160e-01,
 7.9138930e-03, 2.6191060e-01, 6.5024480e-02, 4.5598240e-01, 3.0369880e-01, 8.1539530e-01, 2.9438270e-01, 8.2275800e-01,
 3.0201210e-04, 6.0790750e-04, 1.2337410e-04, 7.2128620e-04, 4.1496080e-04, 1.0927170e-03, 2.4033460e-04, 1.2579970e-03,
 1.4076200e-05, 4.2952020e-04, 9.4781470e-05, 7.0602590e-04, 5.0344510e-04, 1.2462710e-03, 3.9991950e-04, 1.1872950e-03,
 1.6347270e-02, 4.0025040e-02, 5.9015820e-03, 4.3161360e-02, 3.1159320e-02, 9.9807220e-02, 1.5948530e-02, 1.0443050e-01,
 1.0396570e-03, 3.8588850e-02, 6.1865950e-03, 5.7649050e-02, 5.6876770e-02, 1.7126510e-01, 3.9928110e-02, 1.4828860e-01,
 1.6780720e-04, 4.7290490e-04, 1.0684070e-04, 5.4999470e-04, 8.6926290e-03, 3.2048050e-02, 7.8466910e-03, 3.6164990e-02,
 2.1584260e-04, 9.2211560e-03, 2.2651730e-03, 1.4857200e-02, 1.3408440e-02, 4.6471710e-02, 1.6600640e-02, 4.3395940e-02,
 2.9089510e-02, 7.3821370e-02, 1.3141740e-02, 8.5740760e-02, 4.5136510e-02, 1.4985150e-01, 2.8910400e-02, 1.6887610e-01,
 2.0020380e-03, 7.7019920e-02, 1.4908260e-02, 1.2392960e-01, 6.8185710e-02, 2.1280720e-01, 5.9900520e-02, 1.9845740e-01,
 9.1341650e-02, 1.4612570e-01, 4.4706410e-02, 2.0980090e-01, 1.6893040e-01, 3.5355160e-01, 1.1722440e-01, 4.9253330e-01,
 3.7834440e-03, 9.1755070e-02, 3.0522940e-02, 1.8250620e-01, 1.7146970e-01, 3.3735920e-01, 1.6319580e-01, 3.8890990e-01,
 8.0867590e-02, 1.5736410e-01, 3.4978320e-02, 2.0534290e-01, 2.0747870e-01, 5.2819230e-01, 1.2723520e-01, 6.6875660e-01,
 4.5706390e-03, 1.3483210e-01, 3.2586630e-02, 2.4374410e-01, 3.1685100e-01, 7.5828690e-01, 2.6650180e-01, 7.9448050e-01,
 2.1404280e-03, 4.7941130e-03, 1.6327800e-03, 6.7468900e-03, 1.4924410e-01, 4.3731290e-01, 1.6141120e-01, 5.9715850e-01,
 2.4467210e-03, 8.3076300e-02, 3.0764480e-02, 1.6197180e-01, 1.9260120e-01, 5.3053490e-01, 2.8569760e-01, 5.9949420e-01,
 1.7146060e-01, 3.4582360e-01, 9.2807270e-02, 4.8603830e-01, 3.5810640e-01, 9.4490840e-01, 2.7481420e-01, 1.2885690e+00,
 1.0487150e-02, 3.2065120e-01, 9.3564990e-02, 6.2433200e-01, 4.5259740e-01, 1.1226640e+00, 4.7637660e-01, 1.2668970e+00,
 3.4282690e-02, 9.0159110e-02, 2.9088850e-02, 1.1470200e-01, 4.6567120e-02, 1.6021440e-01, 5.6019660e-02, 1.9777200e-01,
 1.1329450e-03, 4.5167750e-02, 1.5845230e-02, 7.9607990e-02, 7.1728410e-02, 2.3199210e-01, 1.1834870e-01, 2.3697920e-01,
 4.7792880e-02, 1.5288730e-01, 3.5837540e-02, 1.7677710e-01, 9.0059160e-02, 3.7689750e-01, 9.5744180e-02, 4.2284370e-01,
 2.1551670e-03, 1.0451390e-01, 2.6637540e-02, 1.6741550e-01, 2.0870910e-01, 8.2110140e-01, 3.0432460e-01, 7.6230200e-01,
 6.2517430e-04, 2.3018960e-03, 8.2675870e-04, 2.8705280e-03, 3.2015730e-02, 1.5421810e-01, 6.0027540e-02, 1.8660070e-01,
 5.7016480e-04, 3.1825120e-02, 1.2428430e-02, 5.4981030e-02, 6.2698500e-02, 2.8391550e-01, 1.6123350e-01, 2.8427630e-01,
 6.4976500e-02, 2.1543860e-01, 6.0971190e-02, 2.6829960e-01, 9.9671210e-02, 4.3233890e-01, 1.3260120e-01, 5.2242350e-01,
 3.1707720e-03, 1.5937390e-01, 4.9042370e-02, 2.7496700e-01, 1.9116210e-01, 7.7950030e-01, 3.4881140e-01, 7.7945020e-01,
 5.9091910e-02, 1.2764560e-01, 4.2186520e-02, 1.5606110e-01, 9.2136360e-02, 2.6037310e-01, 9.3258030e-02, 3.0887800e-01,
 2.7744380e-03, 9.0852710e-02, 3.2648170e-02, 1.5388400e-01, 1.2783270e-01, 3.3959960e-01, 1.7746320e-01, 3.3337390e-01,
 1.3803100e-01, 3.6268370e-01, 8.7085510e-02, 4.0300460e-01, 2.9856580e-01, 1.0263100e+00, 2.6706600e-01, 1.1065280e+00,
 8.8431660e-03, 3.5224430e-01, 9.1963410e-02, 5.4224170e-01, 6.2323630e-01, 2.0139620e+00, 7.6461440e-01, 1.7968380e+00,
 1.6100520e-03, 4.8693120e-03, 1.7914790e-03, 5.8354050e-03, 9.4645660e-02, 3.7446890e-01, 1.4930760e-01, 4.3543280e-01,
 2.0861830e-03, 9.5645630e-02, 3.8261520e-02, 1.5879450e-01, 1.6695280e-01, 6.2096720e-01, 3.6123180e-01, 5.9751350e-01,
 2.2058870e-01, 6.0074990e-01, 1.7415890e-01, 7.1898120e-01, 3.8841440e-01, 1.3838630e+00, 4.3477770e-01, 1.6070110e+00,
 1.5293440e-02, 6.3139420e-01, 1.9902420e-01, 1.0468670e+00, 6.7100620e-01, 2.2474200e+00, 1.0301720e+00, 2.1596520e+00,
 4.3030070e-04, 1.0804830e-03, 2.7841060e-04, 1.2209100e-03, 4.8529760e-04, 1.5941940e-03, 4.4517570e-04, 1.7478700e-03,
 2.1758950e-05, 8.2826380e-04, 2.3205440e-04, 1.2965860e-03, 8.8976040e-04, 2.7476800e-03, 1.1194570e-03, 2.4929160e-03,
 3.5459430e-02, 1.0830560e-01, 2.0275380e-02, 1.1122690e-01, 5.5478930e-02, 2.2168410e-01, 4.4975370e-02, 2.2089990e-01,
 2.4467050e-03, 1.1328850e-01, 2.3059880e-02, 1.6118020e-01, 1.5303640e-01, 5.7485880e-01, 1.7015810e-01, 4.7401920e-01,
 3.2757600e-04, 1.1516160e-03, 3.3033300e-04, 1.2755230e-03, 1.3928550e-02, 6.4060310e-02, 1.9913850e-02, 6.8844840e-02,
 4.5713390e-04, 2.4362630e-02, 7.5983870e-03, 3.7382760e-02, 3.2467800e-02, 1.4037700e-01, 6.3666840e-02, 1.2483950e-01,
 4.4088540e-02, 1.3957380e-01, 3.1546870e-02, 1.5438490e-01, 5.6152720e-02, 2.3256070e-01, 5.6965360e-02, 2.4959700e-01,
 3.2920500e-03, 1.5799010e-01, 3.8827120e-02, 2.4210150e-01, 1.2819050e-01, 4.9909300e-01, 1.7836400e-01, 4.4325950e-01,
 1.5626160e-01, 3.1184780e-01, 1.2113430e-01, 4.2640190e-01, 2.3721640e-01, 6.1933020e-01, 2.6071680e-01, 8.2167630e-01,
 7.0222380e-03, 2.1244710e-01, 8.9728130e-02, 4.0243360e-01, 3.6386830e-01, 8.9306240e-01, 5.4850390e-01, 9.8046920e-01,
 2.1061870e-01, 5.1128210e-01, 1.4428970e-01, 6.3537530e-01, 4.4355700e-01, 1.4086410e+00, 4.3082130e-01, 1.6985260e+00,
 1.2915290e-02, 4.7528360e-01, 1.4584130e-01, 8.1825640e-01, 1.0236480e+00, 3.0560590e+00, 1.3636710e+00, 3.0493490e+00,
 5.0169260e-03, 1.4017740e-02, 6.0614800e-03, 1.8787500e-02, 2.8713610e-01, 1.0495800e+00, 4.9185630e-01, 1.3649240e+00,
 6.2219480e-03, 2.6354310e-01, 1.2390980e-01, 4.8933870e-01, 5.5997580e-01, 1.9242290e+00, 1.3156210e+00, 2.0707310e+00,
 3.1202500e-01, 7.8507700e-01, 2.6749830e-01, 1.0508090e+00, 5.3492220e-01, 1.7607630e+00, 6.5017720e-01, 2.2867270e+00,
 2.0705580e-02, 7.8976030e-01, 2.9258850e-01, 1.4644470e+00, 1.0216690e+00, 3.1614080e+00, 1.7031880e+00, 3.3975650e+00,
 4.0721040e-04, 7.2784110e-04, 3.4173450e-04, 1.1750990e-03, 4.7914780e-04, 1.1204040e-03, 5.7009720e-04, 1.7551500e-03,
 1.2883920e-05, 3.4910080e-04, 1.7821990e-04, 7.8082840e-04, 5.7618560e-04, 1.2665650e-03, 9.4027080e-04, 1.6418780e-03,
 5.7477010e-04, 1.2496410e-03, 4.2627270e-04, 1.8336490e-03, 9.3822050e-04, 2.6685990e-03, 9.8652420e-04, 3.7994120e-03,
 2.4814610e-05, 8.1786860e-04, 3.0334650e-04, 1.6625760e-03, 1.6974600e-03, 4.5387680e-03, 2.4480120e-03, 5.3474250e-03,
 8.3033110e-06, 2.0778730e-05, 1.0860440e-05, 3.2883000e-05, 3.6834920e-04, 1.2059090e-03, 6.8306990e-04, 1.8516930e-03,
 7.2501340e-06, 2.7504180e-04, 1.5630760e-04, 6.0300100e-04, 5.6316350e-04, 1.7332030e-03, 1.4323570e-03, 2.2023050e-03,
 8.2601810e-04, 1.8614010e-03, 7.6661320e-04, 2.9417970e-03, 1.0976130e-03, 3.2358370e-03, 1.4442600e-03, 4.9620540e-03,
 3.8591680e-05, 1.3183450e-03, 5.9036220e-04, 2.8864810e-03, 1.6434720e-03, 4.5546990e-03, 2.9659890e-03, 5.7797400e-03,
 2.6513370e-02, 3.8924730e-02, 1.8720990e-02, 6.0393600e-02, 3.5810790e-02, 6.8779990e-02, 3.5849860e-02, 1.0354510e-01,
 1.1918110e-03, 2.6524860e-02, 1.3871060e-02, 5.7014500e-02, 3.8788780e-02, 7.0034850e-02, 5.3258720e-02, 8.7247930e-02,
 6.2704760e-02, 1.1197850e-01, 3.9128040e-02, 1.5790400e-01, 1.1749240e-01, 2.7449310e-01, 1.0394580e-01, 3.7557090e-01,
 3.8461570e-03, 1.0412290e-01, 3.9559670e-02, 2.0340970e-01, 1.9147130e-01, 4.2051860e-01, 2.3233350e-01, 4.7612330e-01,
 8.0776090e-04, 1.6603270e-03, 8.8894110e-04, 2.5250700e-03, 4.1132940e-02, 1.1060830e-01, 6.4178470e-02, 1.6321860e-01,
 1.0020530e-03, 3.1223860e-02, 1.8176870e-02, 6.5785980e-02, 5.6645290e-02, 1.4319300e-01, 1.2122010e-01, 1.7485470e-01,
 1.0592770e-01, 1.9606620e-01, 8.2716140e-02, 2.9778520e-01, 1.6157250e-01, 3.9124440e-01, 1.7887830e-01, 5.7656790e-01,
 7.0311560e-03, 1.9729000e-01, 9.0499410e-02, 4.1511880e-01, 2.1791130e-01, 4.9604430e-01, 3.3088820e-01, 6.0491800e-01,
 1.7710170e-04, 3.0223970e-04, 1.1333260e-04, 4.3340480e-04, 1.7302340e-04, 3.8629670e-04, 1.5698080e-04, 5.3748370e-04,
 8.5740120e-06, 2.2181850e-04, 9.0438720e-05, 4.4066340e-04, 2.4765720e-04, 5.1978890e-04, 3.0817950e-04, 5.9847360e-04,
 1.4776430e-02, 3.0674080e-02, 8.3565110e-03, 3.9976710e-02, 2.0026810e-02, 5.4387770e-02, 1.6057460e-02, 6.8776300e-02,
 9.7614600e-04, 3.0718640e-02, 9.0993110e-03, 5.5463120e-02, 4.3128030e-02, 1.1010550e-01, 4.7428110e-02, 1.1521800e-01,
 1.5075400e-04, 3.6020330e-04, 1.5035820e-04, 5.0629600e-04, 5.5527610e-03, 1.7357010e-02, 7.8519340e-03, 2.3671940e-02,
 2.0141680e-04, 7.2955740e-03, 3.3112510e-03, 1.4206370e-02, 1.0105010e-02, 2.9693600e-02, 1.9598180e-02, 3.3511620e-02,
 1.9420740e-02, 4.1785630e-02, 1.3744050e-02, 5.8654910e-02, 2.1426780e-02, 6.0312240e-02, 2.1498850e-02, 8.2145690e-02,
 1.3883590e-03, 4.5284360e-02, 1.6195300e-02, 8.8062790e-02, 3.8187660e-02, 1.0104890e-01, 5.2552410e-02, 1.1388980e-01,
 6.4570580e-02, 8.7580610e-02, 4.9507150e-02, 1.5197110e-01, 8.4912780e-02, 1.5067240e-01, 9.2302990e-02, 2.5368140e-01,
 2.7781350e-03, 5.7123090e-02, 3.5109510e-02, 1.3731930e-01, 1.0168430e-01, 1.6961890e-01, 1.5160290e-01, 2.3632130e-01,
 8.8118310e-02, 1.4538280e-01, 5.9706670e-02, 2.2927620e-01, 1.6075510e-01, 3.4697550e-01, 1.5442970e-01, 5.3094180e-01,
 5.1733140e-03, 1.2939000e-01, 5.7778160e-02, 2.8269210e-01, 2.8963240e-01, 5.8768040e-01, 3.8161410e-01, 7.4415430e-01,
 2.3180680e-03, 4.4019950e-03, 2.7700370e-03, 7.4871580e-03, 1.1492710e-01, 2.8551770e-01, 1.9471130e-01, 4.7119700e-01,
 2.7523920e-03, 7.9235290e-02, 5.4213550e-02, 1.8670370e-01, 1.7497860e-01, 4.0865380e-01, 4.0659770e-01, 5.5808290e-01,
 1.3799420e-01, 2.3597550e-01, 1.1700680e-01, 4.0082510e-01, 2.0493130e-01, 4.5846000e-01, 2.4635860e-01, 7.5559920e-01,
 8.7670700e-03, 2.2727170e-01, 1.2253010e-01, 5.3481090e-01, 3.0556890e-01, 6.4263200e-01, 5.0382510e-01, 8.7644770e-01,
 5.6136290e-02, 1.0494730e-01, 4.5867750e-02, 1.5793740e-01, 7.8338750e-02, 1.9159830e-01, 9.0750670e-02, 2.7977390e-01,
 2.0861600e-03, 5.9123520e-02, 2.8096320e-02, 1.2326520e-01, 8.5201920e-02, 1.9589550e-01, 1.3537350e-01, 2.3670830e-01,
 7.4403690e-02, 1.6919810e-01, 5.3725650e-02, 2.3142070e-01, 1.4404150e-01, 4.2852480e-01, 1.4746340e-01, 5.6870190e-01,
 3.7729610e-03, 1.3006740e-01, 4.4906340e-02, 2.4645750e-01, 2.3570130e-01, 6.5918980e-01, 3.3095570e-01, 7.2392380e-01,
 8.8342850e-04, 2.3123260e-03, 1.1250230e-03, 3.4109640e-03, 4.6479580e-02, 1.5915750e-01, 8.3919220e-02, 2.2780180e-01,
 9.0602610e-04, 3.5950370e-02, 1.9018170e-02, 7.3468020e-02, 6.4271260e-02, 2.0689110e-01, 1.5915750e-01, 2.4504480e-01,
 9.7248080e-02, 2.2921410e-01, 8.7874230e-02, 3.3766790e-01, 1.5325790e-01, 4.7257470e-01, 1.9634180e-01, 6.7549320e-01,
 5.3365390e-03, 1.9067990e-01, 7.9483750e-02, 3.8915300e-01, 2.0754670e-01, 6.0162150e-01, 3.6468420e-01, 7.1161910e-01,
 8.4513230e-02, 1.2977630e-01, 5.8100860e-02, 1.8768800e-01, 1.3538050e-01, 2.7196580e-01, 1.3195430e-01, 3.8164290e-01,
 4.4621250e-03, 1.0387180e-01, 5.0563580e-02, 2.0811600e-01, 1.3262580e-01, 2.5046450e-01, 1.7729910e-01, 2.9084580e-01,
 1.8768770e-01, 3.5057430e-01, 1.1402950e-01, 4.6080190e-01, 4.1708790e-01, 1.0191990e+00, 3.5926780e-01, 1.2998560e+00,
 1.3521880e-02, 3.8288310e-01, 1.3541180e-01, 6.9721580e-01, 6.1475380e-01, 1.4121890e+00, 7.2627850e-01, 1.4903990e+00,
 1.9871840e-03, 4.2722710e-03, 2.1292270e-03, 6.0563960e-03, 1.2001270e-01, 3.3754790e-01, 1.8231430e-01, 4.6429380e-01,
 2.8954800e-03, 9.4368330e-02, 5.1137870e-02, 1.8533130e-01, 1.4947930e-01, 3.9522940e-01, 3.1144810e-01, 4.4986310e-01,
 2.8836060e-01, 5.5826360e-01, 2.1923530e-01, 7.9034240e-01, 5.2164650e-01, 1.3211950e+00, 5.6229000e-01, 1.8148680e+00,
 2.2481630e-02, 6.5980590e-01, 2.8173490e-01, 1.2940740e+00, 6.3630960e-01, 1.5150230e+00, 9.4072730e-01, 1.7221490e+00,
 8.2635380e-04, 1.4750430e-03, 5.1486330e-04, 1.9716170e-03, 9.5748190e-04, 2.2359220e-03, 8.4579670e-04, 2.8998570e-03,
 4.6989620e-05, 1.2715270e-03, 4.8257640e-04, 2.3545640e-03, 1.2395280e-03, 2.7210870e-03, 1.5017690e-03, 2.9203580e-03,
 6.4742310e-02, 1.4057250e-01, 3.5648200e-02, 1.7077000e-01, 1.0406700e-01, 2.9560540e-01, 8.1240350e-02, 3.4843800e-01,
 5.0235200e-03, 1.6535040e-01, 4.5592740e-02, 2.7828090e-01, 2.0269380e-01, 5.4125260e-01, 2.1702540e-01, 5.2794280e-01,
 5.4288460e-04, 1.3567390e-03, 5.2718070e-04, 1.7775780e-03, 2.3715370e-02, 7.7536450e-02, 3.2650620e-02, 9.8569010e-02,
 8.5193980e-04, 3.2276210e-02, 1.3636380e-02, 5.8584400e-02, 3.9033520e-02, 1.1997030e-01, 7.3707270e-02, 1.2620650e-01,
 7.7388360e-02, 1.7415940e-01, 5.3323460e-02, 2.2787670e-01, 1.0126260e-01, 2.9813140e-01, 9.8923910e-02, 3.7849720e-01,
 6.4981000e-03, 2.2168820e-01, 7.3801850e-02, 4.0184870e-01, 1.6322820e-01, 4.5176620e-01, 2.1870490e-01, 4.7461610e-01,
 1.6305250e-01, 2.3131860e-01, 1.2171790e-01, 3.7414440e-01, 2.5430100e-01, 4.7197470e-01, 2.6914390e-01, 7.4071180e-01,
 8.2398740e-03, 1.7721030e-01, 1.0138780e-01, 3.9708580e-01, 2.7542830e-01, 4.8055070e-01, 3.9981240e-01, 6.2408460e-01,
 2.0894610e-01, 3.6057120e-01, 1.3784300e-01, 5.3004520e-01, 4.5208000e-01, 1.0206090e+00, 4.2283920e-01, 1.4557380e+00,
 1.4408260e-02, 3.7692360e-01, 1.5667520e-01, 7.6761240e-01, 7.3667770e-01, 1.5634410e+00, 9.4503660e-01, 1.8453510e+00,
 4.5176670e-03, 8.9732020e-03, 5.2561450e-03, 1.4226260e-02, 2.6563950e-01, 6.9026100e-01, 4.3818280e-01, 1.0618390e+00,
 6.3004690e-03, 1.8971040e-01, 1.2082700e-01, 4.1667860e-01, 3.6579280e-01, 8.9354350e-01, 8.2757790e-01, 1.1374560e+00,
 2.9759130e-01, 5.3227510e-01, 2.4567680e-01, 8.4275210e-01, 5.2414320e-01, 1.2264590e+00, 6.1348400e-01, 1.8841640e+00,
 2.2206920e-02, 6.0212860e-01, 3.0218320e-01, 1.3207470e+00, 7.0685560e-01, 1.5548690e+00, 1.1347370e+00, 1.9766650e+00,
 3.4680140e-02, 7.3111040e-02, 1.8578830e-02, 9.7667180e-02, 7.8073250e-02, 2.1532370e-01, 5.9299280e-02, 2.7909970e-01,
 1.4676170e-03, 4.6902910e-02, 1.2959510e-02, 8.6802530e-02, 6.5504700e-02, 1.6983290e-01, 6.8238700e-02, 1.8216430e-01,
 2.7083260e-02, 6.9450680e-02, 1.2822180e-02, 8.4320930e-02, 8.4582900e-02, 2.8375630e-01, 5.6774480e-02, 3.3427690e-01,
 1.5639280e-03, 6.0796330e-02, 1.2204390e-02, 1.0225940e-01, 1.0677130e-01, 3.3672660e-01, 9.8296090e-02, 3.2825550e-01,
 4.4703530e-04, 1.3194530e-03, 3.7325490e-04, 1.7277230e-03, 3.7942080e-02, 1.4650770e-01, 4.4915300e-02, 1.8614130e-01,
 5.2208250e-04, 2.3360180e-02, 7.1852350e-03, 4.2376340e-02, 4.0473730e-02, 1.4691720e-01, 6.5713950e-02, 1.5446450e-01,
 6.2221820e-02, 1.6537790e-01, 3.6863550e-02, 2.1626100e-01, 1.5818780e-01, 5.5004110e-01, 1.3287310e-01, 6.9790750e-01,
 3.8882070e-03, 1.5666400e-01, 3.7970120e-02, 2.8381590e-01, 1.6525840e-01, 5.4018880e-01, 1.9038760e-01, 5.6718140e-01,
 4.0326110e-02, 6.9828320e-02, 1.8176830e-02, 8.9644720e-02, 1.0420930e-01, 2.3606900e-01, 6.6595910e-02, 2.9405870e-01,
 2.4245510e-03, 6.3644620e-02, 1.8013630e-02, 1.1319360e-01, 7.8754570e-02, 1.6771360e-01, 6.9028460e-02, 1.7287700e-01,
 5.2767550e-02, 1.1114390e-01, 2.1019490e-02, 1.2967970e-01, 1.8916780e-01, 5.2125850e-01, 1.0683460e-01, 5.9012150e-01,
 4.3290830e-03, 1.3822920e-01, 2.8424270e-02, 2.2343590e-01, 2.1508900e-01, 5.5716560e-01, 1.6660730e-01, 5.2197090e-01,
 7.7666360e-04, 1.8829040e-03, 5.4562060e-04, 2.3693860e-03, 7.5667740e-02, 2.3999010e-01, 7.5366450e-02, 2.9302390e-01,
 1.2886750e-03, 4.7361310e-02, 1.4922430e-02, 8.2565440e-02, 7.2704630e-02, 2.1677270e-01, 9.9320880e-02, 2.1902210e-01,
 1.4250240e-01, 3.1110000e-01, 7.1034720e-02, 3.9095630e-01, 4.1586380e-01, 1.1877260e+00, 2.9390640e-01, 1.4482600e+00,
 1.2651500e-02, 4.1870190e-01, 1.0395100e-01, 7.2895370e-01, 3.9132780e-01, 1.0506690e+00, 3.7932360e-01, 1.0601560e+00,
 4.0003230e-04, 8.0520830e-04, 1.6341610e-04, 9.5538490e-04, 7.4773580e-04, 1.9690130e-03, 4.3306940e-04, 2.2668400e-03,
 2.5903530e-05, 7.9041870e-04, 1.7442030e-04, 1.2992540e-03, 7.4674360e-04, 1.8485530e-03, 5.9318750e-04, 1.7610750e-03,
 1.8466590e-02, 4.5214030e-02, 6.6666840e-03, 4.8756960e-02, 4.7885050e-02, 1.5338180e-01, 2.4509400e-02, 1.6048680e-01,
 1.6316780e-03, 6.0562830e-02, 9.7094800e-03, 9.0476630e-02, 7.1949040e-02, 2.1665010e-01, 5.0509020e-02, 1.8758490e-01,
 2.1526320e-04, 6.0664280e-04, 1.3705530e-04, 7.0553370e-04, 1.5169830e-02, 5.5928260e-02, 1.3693550e-02, 6.3112880e-02,
 3.8467970e-04, 1.6434160e-02, 4.0370430e-03, 2.6478840e-02, 1.9261320e-02, 6.6756950e-02, 2.3846940e-02, 6.2338580e-02,
 3.8799780e-02, 9.8463440e-02, 1.7528550e-02, 1.1436160e-01, 8.1901400e-02, 2.7190950e-01, 5.2458680e-02, 3.0643020e-01,
 3.7099500e-03, 1.4272460e-01, 2.7626300e-02, 2.2965230e-01, 1.0184390e-01, 3.1785420e-01, 8.9468900e-02, 2.9642090e-01,
 8.5939760e-02, 1.3748390e-01, 4.2062500e-02, 1.9739340e-01, 2.1622380e-01, 4.5253120e-01, 1.5004230e-01, 6.3042190e-01,
 4.9455590e-03, 1.1993840e-01, 3.9898310e-02, 2.3856450e-01, 1.8065970e-01, 3.5544010e-01, 1.7194240e-01, 4.0975370e-01,
 6.4888910e-02, 1.2627040e-01, 2.8066930e-02, 1.6476910e-01, 2.2648530e-01, 5.7657860e-01, 1.3889090e-01, 7.3001960e-01,
 5.0953700e-03, 1.5031140e-01, 3.6327730e-02, 2.7172700e-01, 2.8470800e-01, 6.8136250e-01, 2.3946650e-01, 7.1388440e-01,
 1.9503580e-03, 4.3683960e-03, 1.4877890e-03, 6.1477670e-03, 1.8500410e-01, 5.4209630e-01, 2.0008650e-01, 7.4024210e-01,
 3.0974260e-03, 1.0517040e-01, 3.8946300e-02, 2.0504820e-01, 1.9652660e-01, 5.4134770e-01, 2.9152040e-01, 6.1171250e-01,
 1.6244700e-01, 3.2764390e-01, 8.7928450e-02, 4.6048750e-01, 4.6156180e-01, 1.2178890e+00, 3.5420700e-01, 1.6608310e+00,
 1.3804090e-02, 4.2206870e-01, 1.2315830e-01, 8.2179940e-01, 4.8018450e-01, 1.1910930e+00, 5.0541300e-01, 1.3441180e+00,
 5.8641470e-02, 1.5421960e-01, 4.9757260e-02, 1.9620090e-01, 1.0836270e-01, 3.7282220e-01, 1.3035890e-01, 4.6021960e-01,
 2.6924120e-03, 1.0733990e-01, 3.7655740e-02, 1.8918620e-01, 1.3739460e-01, 4.4437720e-01, 2.2669500e-01, 4.5392990e-01,
 6.9721040e-02, 2.2303450e-01, 5.2280400e-02, 2.5788530e-01, 1.7873060e-01, 7.4798760e-01, 1.9001310e-01, 8.3917200e-01,
 4.3680190e-03, 2.1182520e-01, 5.3988050e-02, 3.3931190e-01, 3.4095000e-01, 1.3413620e+00, 4.9714870e-01, 1.2453070e+00,
 1.0356660e-03, 3.8133280e-03, 1.3696110e-03, 4.7553250e-03, 7.2152650e-02, 3.4755560e-01, 1.3528180e-01, 4.2053510e-01,
 1.3122650e-03, 7.3247250e-02, 2.8604700e-02, 1.2654180e-01, 1.1631190e-01, 5.2669130e-01, 2.9910420e-01, 5.2736070e-01,
 1.1192020e-01, 3.7108690e-01, 1.0502110e-01, 4.6213850e-01, 2.3355670e-01, 1.0130870e+00, 3.1072060e-01, 1.2241800e+00,
 7.5878700e-03, 3.8139250e-01, 1.1736170e-01, 6.5801450e-01, 3.6872490e-01, 1.5035470e+00, 6.7280840e-01, 1.5034510e+00,
 9.5712710e-02, 2.0675090e-01, 6.8330610e-02, 2.5277620e-01, 2.0302200e-01, 5.7373080e-01, 2.0549360e-01, 6.8061100e-01,
 6.2433750e-03, 2.0444770e-01, 7.3468860e-02, 3.4628840e-01, 2.3186340e-01, 6.1596690e-01, 3.2188340e-01, 6.0467480e-01,
 1.9067290e-01, 5.0100290e-01, 1.2029790e-01, 5.5670140e-01, 5.6107730e-01, 1.9286850e+00, 5.0188160e-01, 2.0794350e+00,
 1.6971600e-02, 6.7601940e-01, 1.7649410e-01, 1.0406580e+00, 9.6408130e-01, 3.1153880e+00, 1.1827780e+00, 2.7795200e+00,
 2.5256310e-03, 7.6383170e-03, 2.8102290e-03, 9.1537920e-03, 2.0197670e-01, 7.9912780e-01, 3.1862690e-01, 9.2922660e-01,
 4.5465840e-03, 2.0844810e-01, 8.3386380e-02, 3.4607340e-01, 2.9327310e-01, 1.0908060e+00, 6.3454830e-01, 1.0496060e+00,
 3.5978830e-01, 9.7984510e-01, 2.8405960e-01, 1.1726850e+00, 8.6184560e-01, 3.0706270e+00, 9.6472020e-01, 3.5657670e+00,
 3.4655470e-02, 1.4307610e+00, 4.5099570e-01, 2.3722360e+00, 1.2255720e+00, 4.1048430e+00, 1.8815770e+00, 3.9445380e+00,
 8.0789980e-04, 2.0286320e-03, 5.2272260e-04, 2.2922870e-03, 1.2395500e-03, 4.0719000e-03, 1.1370700e-03, 4.4644190e-03,
 5.6757890e-05, 2.1605130e-03, 6.0531040e-04, 3.3821250e-03, 1.8707130e-03, 5.7769710e-03, 2.3536480e-03, 5.2413320e-03,
 5.6779030e-02, 1.7342320e-01, 3.2465730e-02, 1.7810090e-01, 1.2085220e-01, 4.8290440e-01, 9.7971860e-02, 4.8119620e-01,
 5.4430290e-03, 2.5202570e-01, 5.1299840e-02, 3.5856740e-01, 2.7440980e-01, 1.0307800e+00, 3.0511070e-01, 8.4996440e-01,
 5.9564290e-04, 2.0940240e-03, 6.0065600e-04, 2.3193280e-03, 3.4454850e-02, 1.5846500e-01, 4.9260600e-02, 1.7030040e-01,
 1.1548360e-03, 6.1546150e-02, 1.9195450e-02, 9.4438300e-02, 6.6111260e-02, 2.8583700e-01, 1.2963910e-01, 2.5419940e-01,
 8.3355330e-02, 2.6388310e-01, 5.9643610e-02, 2.9188550e-01, 1.4442720e-01, 5.9815600e-01, 1.4651730e-01, 6.4197390e-01,
 8.6472280e-03, 4.1499250e-01, 1.0198720e-01, 6.3592810e-01, 2.7140150e-01, 1.0566660e+00, 3.7762730e-01, 9.3845690e-01,
 2.0839740e-01, 4.1589400e-01, 1.6155010e-01, 5.6866840e-01, 4.3038300e-01, 1.1236540e+00, 4.7301990e-01, 1.4907720e+00,
 1.3011230e-02, 3.9363500e-01, 1.6625370e-01, 7.4565340e-01, 5.4341650e-01, 1.3337380e+00, 8.1915930e-01, 1.4642750e+00,
 2.3955630e-01, 5.8152900e-01, 1.6411410e-01, 7.2267170e-01, 6.8632610e-01, 2.1796240e+00, 6.6662000e-01, 2.6281690e+00,
 2.0408810e-02, 7.5104570e-01, 2.3045920e-01, 1.2930130e+00, 1.3037970e+00, 3.8924320e+00, 1.7368770e+00, 3.8838860e+00,
 6.4798690e-03, 1.8105330e-02, 7.8290160e-03, 2.4265960e-02, 5.0452970e-01, 1.8442270e+00, 8.6424560e-01, 2.3983210e+00,
 1.1164970e-02, 4.7291490e-01, 2.2234980e-01, 8.7809380e-01, 8.0992800e-01, 2.7831330e+00, 1.9028650e+00, 2.9950270e+00,
 4.1903620e-01, 1.0543250e+00, 3.5923880e-01, 1.4111920e+00, 9.7728940e-01, 3.2168690e+00, 1.1878570e+00, 4.1777930e+00,
 3.8632460e-02, 1.4735340e+00, 5.4591150e-01, 2.7323650e+00, 1.5364600e+00, 4.7543520e+00, 2.5613770e+00, 5.1095020e+00,
 9.5947170e-04, 1.7149440e-03, 8.0519690e-04, 2.7687750e-03, 1.5358650e-03, 3.5913540e-03, 1.8273960e-03, 5.6259770e-03,
 4.2175890e-05, 1.1427910e-03, 5.8340800e-04, 2.5560640e-03, 1.5202820e-03, 3.3418680e-03, 2.4809320e-03, 4.3321430e-03,
 1.1549900e-03, 2.5111300e-03, 8.5658710e-04, 3.6846840e-03, 2.5648340e-03, 7.2952090e-03, 2.6968830e-03, 1.0386540e-02,
 6.9277820e-05, 2.2833390e-03, 8.4688760e-04, 4.6416060e-03, 3.8197260e-03, 1.0213410e-02, 5.5086620e-03, 1.2033090e-02,
 1.8947550e-05, 4.7415540e-05, 2.4782730e-05, 7.5036600e-05, 1.1434890e-03, 3.7435770e-03, 2.1204950e-03, 5.7483240e-03,
 2.2985320e-05, 8.7197350e-04, 4.9554690e-04, 1.9117120e-03, 1.4390800e-03, 4.4289400e-03, 3.6601720e-03, 5.6276610e-03,
 1.9598600e-03, 4.4164700e-03, 1.8189120e-03, 6.9798830e-03, 3.5428670e-03, 1.0444620e-02, 4.6617720e-03, 1.6016490e-02,
 1.2721310e-04, 4.3457740e-03, 1.9460630e-03, 9.5149600e-03, 4.3666280e-03, 1.2101630e-02, 7.8804960e-03, 1.5356500e-02,
 5.9154770e-02, 8.6846150e-02, 4.1768970e-02, 1.3474600e-01, 1.0869490e-01, 2.0876490e-01, 1.0881350e-01, 3.1428570e-01,
 3.6943250e-03, 8.2220650e-02, 4.2996910e-02, 1.7673110e-01, 9.6912460e-02, 1.7497970e-01, 1.3306510e-01, 2.1798600e-01,
 1.1931530e-01, 2.1307400e-01, 7.4453250e-02, 3.0046150e-01, 3.0414160e-01, 7.1055450e-01, 2.6907470e-01, 9.7220510e-01,
 1.0167760e-02, 2.7526100e-01, 1.0458060e-01, 5.3773720e-01, 4.0798850e-01, 8.9604430e-01, 4.9505800e-01, 1.0145270e+00,
 1.7454050e-03, 3.5876250e-03, 1.9208190e-03, 5.4561570e-03, 1.2091320e-01, 3.2514090e-01, 1.8865710e-01, 4.7979250e-01,
 3.0082020e-03, 9.3735210e-02, 5.4567650e-02, 1.9749200e-01, 1.3706480e-01, 3.4648450e-01, 2.9331650e-01, 4.2309650e-01,
 2.3798880e-01, 4.4050400e-01, 1.8583920e-01, 6.6903710e-01, 4.9383850e-01, 1.1958190e+00, 5.4673290e-01, 1.7622520e+00,
 2.1947070e-02, 6.1582170e-01, 2.8248510e-01, 1.2957530e+00, 5.4824600e-01, 1.2480040e+00, 8.3248600e-01, 1.5219210e+00,
 4.5802740e-04, 7.8166420e-04, 2.9310530e-04, 1.1208890e-03, 6.0875720e-04, 1.3591270e-03, 5.5231360e-04, 1.8910560e-03,
 3.0807450e-05, 7.9702040e-04, 3.2495710e-04, 1.5833560e-03, 7.1724640e-04, 1.5053740e-03, 8.9252660e-04, 1.7332550e-03,
 3.2591840e-02, 6.7656740e-02, 1.8431660e-02, 8.8175220e-02, 6.0092700e-02, 1.6319660e-01, 4.8182220e-02, 2.0637100e-01,
 2.9912800e-03, 9.4133510e-02, 2.7883730e-02, 1.6996000e-01, 1.0652410e-01, 2.7195510e-01, 1.1714500e-01, 2.8458260e-01,
 3.7759500e-04, 9.0220430e-04, 3.7660360e-04, 1.2681240e-03, 1.8920680e-02, 5.9142900e-02, 2.6754960e-02, 8.0660610e-02,
 7.0089960e-04, 2.5387480e-02, 1.1522650e-02, 4.9436000e-02, 2.8342800e-02, 8.3285380e-02, 5.4969480e-02, 9.3994260e-02,
 5.0577420e-02, 1.0882230e-01, 3.5793610e-02, 1.5275490e-01, 7.5913360e-02, 2.1368140e-01, 7.6168710e-02, 2.9103560e-01,
 5.0233760e-03, 1.6384830e-01, 5.8597990e-02, 3.1862970e-01, 1.1136860e-01, 2.9469400e-01, 1.5326120e-01, 3.3214240e-01,
 1.1862000e-01, 1.6089080e-01, 9.0947600e-02, 2.7917990e-01, 2.1221040e-01, 3.7655410e-01, 2.3067980e-01, 6.3398990e-01,
 7.0905420e-03, 1.4579340e-01, 8.9608850e-02, 3.5047540e-01, 2.0918260e-01, 3.4893640e-01, 3.1187430e-01, 4.8615510e-01,
 1.3805760e-01, 2.2777550e-01, 9.3544210e-02, 3.5921390e-01, 3.4263300e-01, 7.3954270e-01, 3.2915110e-01, 1.1316480e+00,
 1.1260710e-02, 2.8164200e-01, 1.2576520e-01, 6.1533340e-01, 5.0814750e-01, 1.0310600e+00, 6.6952550e-01, 1.3055870e+00,
 4.1241840e-03, 7.8317950e-03, 4.9283020e-03, 1.3320750e-02, 2.7816640e-01, 6.9105910e-01, 4.7127390e-01, 1.1404720e+00,
 6.8033830e-03, 1.9585440e-01, 1.3400540e-01, 4.6149570e-01, 3.4861450e-01, 8.1417170e-01, 8.1007520e-01, 1.1118830e+00,
 2.5527390e-01, 4.3652820e-01, 2.1644950e-01, 7.4148150e-01, 5.1573210e-01, 1.1537650e+00, 6.1998850e-01, 1.9015480e+00,
 2.2532160e-02, 5.8410870e-01, 3.1491330e-01, 1.3745120e+00, 6.3299940e-01, 1.3312400e+00, 1.0436960e+00, 1.8156000e+00,
 1.4049530e-01, 2.6265720e-01, 1.1479570e-01, 3.9527820e-01, 2.6672580e-01, 6.5234910e-01, 3.0898560e-01, 9.5256700e-01,
 7.2538470e-03, 2.0558010e-01, 9.7694540e-02, 4.2860910e-01, 2.3878990e-01, 5.4902350e-01, 3.7940270e-01, 6.6340710e-01,
 1.5881190e-01, 3.6114720e-01, 1.1467540e-01, 4.9395910e-01, 4.1826040e-01, 1.2443290e+00, 4.2819670e-01, 1.6513680e+00,
 1.1188550e-02, 3.8570920e-01, 1.3316780e-01, 7.3085890e-01, 5.6337740e-01, 1.5756070e+00, 7.9105590e-01, 1.7303350e+00,
 2.1413020e-03, 5.6047410e-03, 2.7268910e-03, 8.2676790e-03, 1.5326360e-01, 5.2481230e-01, 2.7671860e-01, 7.5116280e-01,
 3.0510550e-03, 1.2106330e-01, 6.4043930e-02, 2.4740450e-01, 1.7445040e-01, 5.6156090e-01, 4.3199860e-01, 6.6512090e-01,
 2.4508750e-01, 5.7767210e-01, 2.2146330e-01, 8.5100080e-01, 5.2545250e-01, 1.6202460e+00, 6.7316790e-01, 2.3159630e+00,
 1.8685410e-02, 6.6764860e-01, 2.7830520e-01, 1.3625840e+00, 5.8573960e-01, 1.6979000e+00, 1.0292140e+00, 2.0083360e+00,
 2.0028770e-01, 3.0755660e-01, 1.3769310e-01, 4.4480130e-01, 4.3647180e-01, 8.7682780e-01, 4.2542550e-01, 1.2304310e+00,
 1.4691770e-02, 3.4200310e-01, 1.6648310e-01, 6.8523230e-01, 3.5197060e-01, 6.6469810e-01, 4.7052730e-01, 7.7186450e-01,
 3.7934660e-01, 7.0856620e-01, 2.3047170e-01, 9.3135360e-01, 1.1468280e+00, 2.8023980e+00, 9.8784560e-01, 3.5740940e+00,
 3.7969960e-02, 1.0751510e+00, 3.8024160e-01, 1.9578090e+00, 1.3913940e+00, 3.1962570e+00, 1.6438120e+00, 3.3732740e+00,
 4.5609580e-03, 9.8056600e-03, 4.8869740e-03, 1.3900560e-02, 3.7472770e-01, 1.0539590e+00, 5.6925800e-01, 1.4497110e+00,
 9.2329700e-03, 3.0091730e-01, 1.6306600e-01, 5.9097570e-01, 3.8419160e-01, 1.0158180e+00, 8.0048350e-01, 1.1562380e+00,
 6.8815730e-01, 1.3322660e+00, 5.2319350e-01, 1.8861100e+00, 1.6935520e+00, 4.2893270e+00, 1.8255030e+00, 5.8920600e+00,
 7.4538800e-02, 2.1876140e+00, 9.3410390e-01, 4.2905570e+00, 1.7004700e+00, 4.0487370e+00, 2.5139930e+00, 4.6022610e+00,
 2.2700710e-03, 4.0520820e-03, 1.4143780e-03, 5.4162180e-03, 3.5782820e-03, 8.3560400e-03, 3.1608940e-03, 1.0837280e-02,
 1.7934050e-04, 4.8529070e-03, 1.8418000e-03, 8.9864220e-03, 3.8131040e-03, 8.3707540e-03, 4.6198210e-03, 8.9837620e-03,
 1.5168140e-01, 3.2934010e-01, 8.3518330e-02, 4.0008820e-01, 3.3168630e-01, 9.4216520e-01, 2.5893240e-01, 1.1105550e+00,
 1.6351410e-02, 5.3821070e-01, 1.4840300e-01, 9.0579600e-01, 5.3178170e-01, 1.4200150e+00, 5.6938160e-01, 1.3850950e+00,
 1.4443400e-03, 3.6095920e-03, 1.4025600e-03, 4.7292330e-03, 8.5834580e-02, 2.8063270e-01, 1.1817450e-01, 3.5675730e-01,
 3.1490080e-03, 1.1930190e-01, 5.0403870e-02, 2.1654430e-01, 1.1629160e-01, 3.5742450e-01, 2.1959420e-01, 3.7600400e-01,
 2.1407760e-01, 4.8177310e-01, 1.4750750e-01, 6.3037010e-01, 3.8107920e-01, 1.1219510e+00, 3.7227800e-01, 1.4243900e+00,
 2.4973810e-02, 8.5200310e-01, 2.8363890e-01, 1.5444050e+00, 5.0563780e-01, 1.3994520e+00, 6.7748990e-01, 1.4702350e+00,
 3.1816720e-01, 4.5137620e-01, 2.3751030e-01, 7.3007460e-01, 6.7506640e-01, 1.2529020e+00, 7.1446840e-01, 1.9662910e+00,
 2.2338370e-02, 4.8041850e-01, 2.7486320e-01, 1.0765030e+00, 6.0184580e-01, 1.0500640e+00, 8.7364080e-01, 1.3637040e+00,
 3.4772270e-01, 6.0005330e-01, 2.2939480e-01, 8.8208740e-01, 1.0234920e+00, 2.3106200e+00, 9.5729200e-01, 3.2957350e+00,
 3.3312950e-02, 8.7147490e-01, 3.6224450e-01, 1.7747760e+00, 1.3728560e+00, 2.9135930e+00, 1.7611490e+00, 3.4389540e+00,
 8.5375000e-03, 1.6957580e-02, 9.9330780e-03, 2.6884820e-02, 6.8293540e-01, 1.7745990e+00, 1.1265290e+00, 2.7298920e+00,
 1.6542160e-02, 4.9809300e-01, 3.1723680e-01, 1.0940080e+00, 7.7410570e-01, 1.8909530e+00, 1.7513540e+00, 2.4071310e+00,
 5.8475040e-01, 1.0458910e+00, 4.8274120e-01, 1.6559610e+00, 1.4011050e+00, 3.2784890e+00, 1.6399250e+00, 5.0366220e+00,
 6.0623550e-02, 1.6437750e+00, 8.2494190e-01, 3.6055610e+00, 1.5553550e+00, 3.4213120e+00, 2.4968590e+00, 4.3494270e+00,
 2.5233020e-04, 5.3195070e-04, 1.3517830e-04, 7.1061930e-04, 4.4060760e-04, 1.2151820e-03, 3.3465640e-04, 1.5751040e-03,
 9.7234830e-06, 3.1074850e-04, 8.5861340e-05, 5.7509770e-04, 4.2016170e-04, 1.0893460e-03, 4.3769810e-04, 1.1684420e-03,
 2.3160760e-04, 5.9392050e-04, 1.0965130e-04, 7.2108630e-04, 5.6104250e-04, 1.8821690e-03, 3.7658780e-04, 2.2172750e-03,
 1.2178380e-05, 4.7342370e-04, 9.5036120e-05, 7.9629840e-04, 8.0493710e-04, 2.5385450e-03, 7.4104340e-04, 2.4746820e-03,
 4.5711400e-06, 1.3492010e-05, 3.8167020e-06, 1.7666760e-05, 3.0092980e-04, 1.1619960e-03, 3.5623640e-04, 1.4763420e-03,
 4.8611910e-06, 2.1751030e-04, 6.6902840e-05, 3.9457260e-04, 3.6484760e-04, 1.3243750e-03, 5.9237380e-04, 1.3924090e-03,
 4.7116770e-04, 1.2523050e-03, 2.7914500e-04, 1.6376120e-03, 9.2911010e-04, 3.2306450e-03, 7.8042480e-04, 4.0991330e-03,
 2.6810380e-05, 1.0802460e-03, 2.6181560e-04, 1.9569980e-03, 1.1031940e-03, 3.6060680e-03, 1.2709450e-03, 3.7862590e-03,
 3.3284700e-04, 5.7635480e-04, 1.5002940e-04, 7.3991700e-04, 6.6715370e-04, 1.5113270e-03, 4.2635090e-04, 1.8825810e-03,
 1.8222610e-05, 4.7834450e-04, 1.3538810e-04, 8.5074770e-04, 5.7304620e-04, 1.2203440e-03, 5.0227550e-04, 1.2579140e-03,
 5.1190410e-04, 1.0782200e-03, 2.0391250e-04, 1.2580380e-03, 1.4234100e-03, 3.9222580e-03, 8.0388660e-04, 4.4404250e-03,
 3.8241820e-05, 1.2210750e-03, 2.5109140e-04, 1.9737650e-03, 1.8394820e-03, 4.7649850e-03, 1.4248570e-03, 4.4639940e-03,
 9.0091860e-06, 2.1841420e-05, 6.3291210e-06, 2.7484540e-05, 6.8080810e-04, 2.1592710e-03, 6.7809730e-04, 2.6364340e-03,
 1.3611840e-05, 5.0026160e-04, 1.5762060e-04, 8.7211100e-04, 7.4348170e-04, 2.2167300e-03, 1.0156610e-03, 2.2397330e-03,
 1.2241220e-03, 2.6724070e-03, 6.1020160e-04, 3.3583880e-03, 2.7708630e-03, 7.9137110e-03, 1.9582720e-03, 9.6496240e-03,
 9.8961330e-05, 3.2751290e-03, 8.1311550e-04, 5.7019510e-03, 2.9634590e-03, 7.9565370e-03, 2.8725530e-03, 8.0283810e-03,
 3.3868210e-06, 6.8171900e-06, 1.3835410e-06, 8.0886410e-06, 4.9102850e-06, 1.2930260e-05, 2.8439110e-06, 1.4886040e-05,
 1.9969950e-07, 6.0936180e-06, 1.3446680e-06, 1.0016410e-05, 5.5734520e-06, 1.3797000e-05, 4.4273590e-06, 1.3144090e-05,
 1.8375840e-04, 4.4991850e-04, 6.6339240e-05, 4.8517370e-04, 3.6959140e-04, 1.1838480e-03, 1.8917100e-04, 1.2386860e-03,
 1.4784820e-05, 5.4876660e-04, 8.7978680e-05, 8.1981880e-04, 6.3116250e-04, 1.9005320e-03, 4.4308300e-04, 1.6455620e-03,
 2.5613060e-06, 7.2181280e-06, 1.6307500e-06, 8.3947790e-06, 1.4000180e-04, 5.1615970e-04, 1.2637730e-04, 5.8246630e-04,
 4.1678460e-06, 1.7805730e-04, 4.3739690e-05, 2.8688730e-04, 2.0203800e-04, 7.0023470e-04, 2.5013800e-04, 6.5388900e-04,
 3.4187780e-04, 8.6759410e-04, 1.5444980e-04, 1.0076780e-03, 5.5975010e-04, 1.8583490e-03, 3.5852570e-04, 2.0942790e-03,
 2.9766680e-05, 1.1451470e-03, 2.2165890e-04, 1.8426090e-03, 7.9110120e-04, 2.4690230e-03, 6.9497510e-04, 2.3025340e-03,
 7.7483440e-04, 1.2395570e-03, 3.7923630e-04, 1.7797030e-03, 1.5120960e-03, 3.1646420e-03, 1.0492760e-03, 4.4086670e-03,
 4.0602330e-05, 9.8467690e-04, 3.2755940e-04, 1.9585800e-03, 1.4359250e-03, 2.8251190e-03, 1.3666370e-03, 3.2568160e-03,
 6.8762030e-04, 1.3380730e-03, 2.9742200e-04, 1.7460390e-03, 1.8615700e-03, 4.7391230e-03, 1.1415980e-03, 6.0003150e-03,
 4.9167120e-05, 1.4504110e-03, 3.5053980e-04, 2.6219950e-03, 2.6597050e-03, 6.3651990e-03, 2.2370640e-03, 6.6690140e-03,
 2.4712880e-05, 5.5351720e-05, 1.8851700e-05, 7.7898040e-05, 1.8182420e-03, 5.3277870e-03, 1.9664740e-03, 7.2751880e-03,
 3.5738050e-05, 1.2134550e-03, 4.4936170e-04, 2.3658430e-03, 2.1952600e-03, 6.0470140e-03, 3.2563690e-03, 6.8330090e-03,
 1.5243010e-03, 3.0744060e-03, 8.2506580e-04, 4.3209280e-03, 3.3593120e-03, 8.8639640e-03, 2.5779680e-03, 1.2087760e-02,
 1.1794720e-04, 3.6063100e-03, 1.0523100e-03, 7.0217570e-03, 3.9721240e-03, 9.8528180e-03, 4.1808170e-03, 1.1118650e-02,
 2.3429920e-02, 6.1617700e-02, 1.9880270e-02, 7.8391120e-02, 3.3582040e-02, 1.1553910e-01, 4.0398760e-02, 1.4262390e-01,
 9.7955370e-04, 3.9052420e-02, 1.3699920e-02, 6.8829750e-02, 4.8393970e-02, 1.5652120e-01, 7.9847890e-02, 1.5988590e-01,
 3.2741100e-02, 1.0473730e-01, 2.4550950e-02, 1.2110330e-01, 6.5101300e-02, 2.7244890e-01, 6.9210850e-02, 3.0566220e-01,
 1.8678190e-03, 9.0579070e-02, 2.3085960e-02, 1.4509400e-01, 1.4114830e-01, 5.5530430e-01, 2.0581230e-01, 5.1553880e-01,
 5.8154040e-04, 2.1412360e-03, 7.6905520e-04, 2.6701800e-03, 3.1424900e-02, 1.5137210e-01, 5.8919770e-02, 1.8315710e-01,
 6.7096950e-04, 3.7451780e-02, 1.4625770e-02, 6.4701640e-02, 5.7575810e-02, 2.6071860e-01, 1.4806020e-01, 2.6105000e-01,
 4.6539190e-02, 1.5430710e-01, 4.3670400e-02, 1.9216860e-01, 7.5329300e-02, 3.2675220e-01, 1.0021710e-01, 3.9483620e-01,
 2.8731020e-03, 1.4441200e-01, 4.4438310e-02, 2.4915330e-01, 1.3516630e-01, 5.5116660e-01, 2.4663650e-01, 5.5113130e-01,
 4.3381590e-02, 9.3709420e-02, 3.0970710e-02, 1.1457030e-01, 7.1374030e-02, 2.0169970e-01, 7.2242930e-02, 2.3927430e-01,
 2.5767730e-03, 8.4379880e-02, 3.0322150e-02, 1.4292050e-01, 9.2645360e-02, 2.4612100e-01, 1.2861450e-01, 2.4160910e-01,
 1.0157540e-01, 2.6689450e-01, 6.4085160e-02, 2.9656620e-01, 2.3183730e-01, 7.9693300e-01, 2.0737760e-01, 8.5922290e-01,
 8.2327140e-03, 3.2792860e-01, 8.5615090e-02, 5.0481030e-01, 4.5276050e-01, 1.4630760e+00, 5.5546700e-01, 1.3053430e+00,
 1.6087930e-03, 4.8655040e-03, 1.7900780e-03, 5.8308410e-03, 9.9791300e-02, 3.9482780e-01, 1.5742510e-01, 4.5910620e-01,
 2.6371580e-03, 1.2090630e-01, 4.8366670e-02, 2.0073320e-01, 1.6468650e-01, 6.1253810e-01, 3.5632840e-01, 5.8940280e-01,
 1.6971780e-01, 4.6220820e-01, 1.3399540e-01, 5.5317370e-01, 3.1533410e-01, 1.1234890e+00, 3.5297420e-01, 1.3046520e+00,
 1.4885820e-02, 6.1456550e-01, 1.9371950e-01, 1.0189640e+00, 5.0965310e-01, 1.7069950e+00, 7.8245210e-01, 1.6403330e+00,
 3.7560580e-04, 9.4314390e-04, 2.4302220e-04, 1.0657220e-03, 4.4699240e-04, 1.4683620e-03, 4.1003730e-04, 1.6099080e-03,
 2.4028230e-05, 9.1464490e-04, 2.5625580e-04, 1.4318090e-03, 7.6672120e-04, 2.3677210e-03, 9.6465470e-04, 2.1481870e-03,
 3.1026020e-02, 9.4764410e-02, 1.7740400e-02, 9.7320500e-02, 5.1221720e-02, 2.0467300e-01, 4.1524160e-02, 2.0394910e-01,
 2.7083180e-03, 1.2540180e-01, 2.5525550e-02, 1.7841430e-01, 1.3218840e-01, 4.9654630e-01, 1.4697760e-01, 4.0944400e-01,
 3.8918410e-04, 1.3682040e-03, 3.9245960e-04, 1.5154140e-03, 1.7461470e-02, 8.0308920e-02, 2.4964920e-02, 8.6307030e-02,
 6.8708440e-04, 3.6617680e-02, 1.1420580e-02, 5.6187290e-02, 3.8080270e-02, 1.6464290e-01, 7.4672470e-02, 1.4641960e-01,
 4.0332260e-02, 1.2768230e-01, 2.8859120e-02, 1.4123150e-01, 5.4203750e-02, 2.2448890e-01, 5.4988180e-02, 2.4093380e-01,
 3.8099290e-03, 1.8284380e-01, 4.4935090e-02, 2.8018700e-01, 1.1576760e-01, 4.5072590e-01, 1.6107870e-01, 4.0030320e-01,
 1.0317740e-01, 2.0590880e-01, 7.9983340e-02, 2.8154730e-01, 1.6527560e-01, 4.3150550e-01, 1.8164900e-01, 5.7248590e-01,
 5.8658570e-03, 1.7746260e-01, 7.4952230e-02, 3.3616320e-01, 2.3718140e-01, 5.8212770e-01, 3.5753310e-01, 6.3910240e-01,
 1.3940020e-01, 3.3839750e-01, 9.5499640e-02, 4.2052980e-01, 3.0977590e-01, 9.8378150e-01, 3.0088140e-01, 1.1862340e+00,
 1.0814200e-02, 3.9796330e-01, 1.2211550e-01, 6.8514040e-01, 6.6883860e-01, 1.9967900e+00, 8.9100530e-01, 1.9924060e+00,
 4.5087160e-03, 1.2597750e-02, 5.4474570e-03, 1.6884340e-02, 2.7229190e-01, 9.9531900e-01, 4.6642860e-01, 1.2943610e+00,
 7.0740020e-03, 2.9963360e-01, 1.4087840e-01, 5.5635040e-01, 4.9680810e-01, 1.7071680e+00, 1.1672130e+00, 1.8371430e+00,
 2.1591770e-01, 5.4326430e-01, 1.8510580e-01, 7.2714780e-01, 3.9059010e-01, 1.2856760e+00, 4.7474710e-01, 1.6697250e+00,
 1.8126330e-02, 6.9138160e-01, 2.5614140e-01, 1.2820240e+00, 6.9793260e-01, 2.1596510e+00, 1.1634980e+00, 2.3209770e+00,
 2.5128400e-04, 4.4914080e-04, 2.1087970e-04, 7.2513740e-04, 3.1199460e-04, 7.2954500e-04, 3.7121580e-04, 1.1428570e-03,
 1.0058140e-05, 2.7253380e-04, 1.3913160e-04, 6.0957220e-04, 3.5100430e-04, 7.7157370e-04, 5.7280000e-04, 1.0002090e-03,
 3.5552830e-04, 7.7297480e-04, 2.6367420e-04, 1.1342180e-03, 6.1237390e-04, 1.7417870e-03, 6.4390160e-04, 2.4798660e-03,
 1.9418300e-05, 6.4001070e-04, 2.3737920e-04, 1.3010240e-03, 1.0365350e-03, 2.7715470e-03, 1.4948510e-03, 3.2653440e-03,
 6.9739690e-06, 1.7452100e-05, 9.1217050e-06, 2.7618500e-05, 3.2645260e-04, 1.0687470e-03, 6.0537660e-04, 1.6410790e-03,
 7.7036830e-06, 2.9224770e-04, 1.6608580e-04, 6.4072310e-04, 4.6694680e-04, 1.4370850e-03, 1.1876380e-03, 1.8260410e-03,
 5.3419770e-04, 1.2037940e-03, 4.9577970e-04, 1.9025020e-03, 7.4901960e-04, 2.2081610e-03, 9.8557440e-04, 3.3861460e-03,
 3.1574010e-05, 1.0786110e-03, 4.8300840e-04, 2.3615920e-03, 1.0492500e-03, 2.9078790e-03, 1.8935910e-03, 3.6899880e-03,
 1.7574870e-02, 2.5801980e-02, 1.2409560e-02, 4.0033010e-02, 2.5048000e-02, 4.8108430e-02, 2.5075330e-02, 7.2424990e-02,
 9.9944380e-04, 2.2243560e-02, 1.1632170e-02, 4.7811940e-02, 2.5382690e-02, 4.5829570e-02, 3.4851570e-02, 5.7093500e-02,
 4.1664110e-02, 7.4404010e-02, 2.5998580e-02, 1.0491920e-01, 8.2376460e-02, 1.9245300e-01, 7.2878610e-02, 2.6332080e-01,
 3.2330490e-03, 8.7524870e-02, 3.3253540e-02, 1.7098460e-01, 1.2559420e-01, 2.7583600e-01, 1.5239740e-01, 3.1230950e-01,
 7.2877430e-04, 1.4979730e-03, 8.0201630e-04, 2.2781570e-03, 3.9159010e-02, 1.0530030e-01, 6.1098610e-02, 1.5538590e-01,
 1.1437330e-03, 3.5638590e-02, 2.0746890e-02, 7.5087420e-02, 5.0451980e-02, 1.2753700e-01, 1.0796650e-01, 1.5573700e-01,
 7.3587390e-02, 1.3620620e-01, 5.7462460e-02, 2.0686980e-01, 1.1843860e-01, 2.8679650e-01, 1.3112440e-01, 4.2264540e-01,
 6.1793720e-03, 1.7338950e-01, 7.9535930e-02, 3.6482950e-01, 1.4944380e-01, 3.4018770e-01, 2.2692350e-01, 4.1485340e-01,
 1.3958310e-04, 2.3821090e-04, 8.9323360e-05, 3.4158900e-04, 1.4389540e-04, 3.2126460e-04, 1.3055350e-04, 4.4699960e-04,
 8.5490510e-06, 2.2117280e-04, 9.0175430e-05, 4.3938060e-04, 1.9269270e-04, 4.0442820e-04, 2.3978290e-04, 4.6564970e-04,
 1.1673840e-02, 2.4233490e-02, 6.6019060e-03, 3.1582860e-02, 1.6695060e-02, 4.5339570e-02, 1.3386070e-02, 5.7334350e-02,
 9.7562470e-04, 3.0702230e-02, 9.0944520e-03, 5.5433510e-02, 3.3636290e-02, 8.5873190e-02, 3.6990000e-02, 8.9860490e-02,
 1.6171930e-04, 3.8640310e-04, 1.6129470e-04, 5.4312210e-04, 6.2854110e-03, 1.9647160e-02, 8.8879460e-03, 2.6795300e-02,
 2.7334580e-04, 9.9009330e-03, 4.4937490e-03, 1.9279680e-02, 1.0701240e-02, 3.1445620e-02, 2.0754530e-02, 3.5488910e-02,
 1.6041410e-02, 3.4514670e-02, 1.1352500e-02, 4.8448590e-02, 1.8675200e-02, 5.2567090e-02, 1.8738020e-02, 7.1596740e-02,
 1.4507820e-03, 4.7320420e-02, 1.6923470e-02, 9.2022250e-02, 3.1138960e-02, 8.2397230e-02, 4.2852240e-02, 9.2867910e-02,
 3.8496120e-02, 5.2214400e-02, 2.9515500e-02, 9.0603130e-02, 5.3417930e-02, 9.4786760e-02, 5.8067050e-02, 1.5958890e-01,
 2.0953630e-03, 4.3084160e-02, 2.6480770e-02, 1.0357080e-01, 5.9846700e-02, 9.9829940e-02, 8.9226540e-02, 1.3908790e-01,
 5.2660220e-02, 8.6881910e-02, 3.5681190e-02, 1.3701730e-01, 1.0137080e-01, 2.1879980e-01, 9.7382090e-02, 3.3480750e-01,
 3.9111900e-03, 9.7822940e-02, 4.3682130e-02, 2.1372420e-01, 1.7087080e-01, 3.4670640e-01, 2.2513610e-01, 4.3901940e-01,
 1.8810110e-03, 3.5720260e-03, 2.2477640e-03, 6.0755020e-03, 9.8405470e-02, 2.4447240e-01, 1.6672010e-01, 4.0345890e-01,
 2.8255250e-03, 8.1340600e-02, 5.5654030e-02, 1.9166460e-01, 1.4016970e-01, 3.2735940e-01, 3.2571240e-01, 4.4706230e-01,
 8.6220360e-02, 1.4744010e-01, 7.3107150e-02, 2.5044000e-01, 1.3511040e-01, 3.0226090e-01, 1.6242330e-01, 4.9816370e-01,
 6.9299000e-03, 1.7964610e-01, 9.6853470e-02, 4.2273940e-01, 1.8847870e-01, 3.9638330e-01, 3.1076560e-01, 5.4060380e-01,
 3.7581700e-02, 7.0259340e-02, 3.0707190e-02, 1.0573470e-01, 5.5340240e-02, 1.3534930e-01, 6.4108300e-02, 1.9763850e-01,
 1.7668670e-03, 5.0074490e-02, 2.3796100e-02, 1.0439910e-01, 5.6310090e-02, 1.2946760e-01, 8.9468590e-02, 1.5644090e-01,
 4.9929970e-02, 1.1354350e-01, 3.6053590e-02, 1.5529920e-01, 1.0199670e-01, 3.0344120e-01, 1.0441980e-01, 4.0270150e-01,
 3.2031170e-03, 1.1042280e-01, 3.8123970e-02, 2.0923410e-01, 1.5614680e-01, 4.3669830e-01, 2.1925060e-01, 4.7958310e-01,
 8.0498340e-04, 2.1070000e-03, 1.0251250e-03, 3.1080830e-03, 4.4689900e-02, 1.5302920e-01, 8.0687950e-02, 2.1903040e-01,
 1.0444310e-03, 4.1442170e-02, 2.1923400e-02, 8.4691040e-02, 5.7814460e-02, 1.8610650e-01, 1.4316830e-01, 2.2042720e-01,
 6.8230770e-02, 1.6082020e-01, 6.1653930e-02, 2.3691310e-01, 1.1346290e-01, 3.4986570e-01, 1.4535960e-01, 5.0009430e-01,
 4.7367730e-03, 1.6924970e-01, 7.0550690e-02, 3.4541670e-01, 1.4375380e-01, 4.1670320e-01, 2.5259250e-01, 4.9289120e-01,
 6.0776950e-02, 9.3327510e-02, 4.1782720e-02, 1.3497410e-01, 1.0273110e-01, 2.0637650e-01, 1.0013120e-01, 2.8960300e-01,
 4.0595660e-03, 9.4500780e-02, 4.6001880e-02, 1.8934040e-01, 9.4155670e-02, 1.7781340e-01, 1.2587080e-01, 2.0648150e-01,
 1.3529580e-01, 2.5271350e-01, 8.2198810e-02, 3.3217170e-01, 3.1725440e-01, 7.7524530e-01, 2.7327400e-01, 9.8872450e-01,
 1.2331300e-02, 3.4917100e-01, 1.2348900e-01, 6.3582740e-01, 4.3747560e-01, 1.0049520e+00, 5.1683950e-01, 1.0606090e+00,
 1.9450690e-03, 4.1817280e-03, 2.0841020e-03, 5.9280420e-03, 1.2395270e-01, 3.4862950e-01, 1.8829960e-01, 4.7953640e-01,
 3.5854290e-03, 1.1685490e-01, 6.3323260e-02, 2.2949290e-01, 1.4443830e-01, 3.8190060e-01, 3.0094480e-01, 4.3469190e-01,
 2.1732850e-01, 4.2074600e-01, 1.6523090e-01, 5.9565670e-01, 4.1484780e-01, 1.0507020e+00, 4.4717020e-01, 1.4433030e+00,
 2.1435430e-02, 6.2910130e-01, 2.6862410e-01, 1.2338530e+00, 4.7342740e-01, 1.1272080e+00, 6.9992040e-01, 1.2813150e+00,
 7.0658270e-04, 1.2612510e-03, 4.4023940e-04, 1.6858530e-03, 8.6389170e-04, 2.0173690e-03, 7.6312320e-04, 2.6164070e-03,
 5.0830290e-05, 1.3754550e-03, 5.2201940e-04, 2.5470130e-03, 1.0463030e-03, 2.2969080e-03, 1.2676640e-03, 2.4651150e-03,
 5.5490590e-02, 1.2048460e-01, 3.0554050e-02, 1.4636680e-01, 9.4118680e-02, 2.6734700e-01, 7.3474170e-02, 3.1512910e-01,
 5.4470700e-03, 1.7929170e-01, 4.9436810e-02, 3.0174360e-01, 1.7150470e-01, 4.5796820e-01, 1.8363100e-01, 4.4670640e-01,
 6.3181120e-04, 1.5789780e-03, 6.1353500e-04, 2.0687520e-03, 2.9123360e-02, 9.5217640e-02, 4.0096170e-02, 1.2104640e-01,
 1.2543320e-03, 4.7521050e-02, 2.0077170e-02, 8.6255230e-02, 4.4845790e-02, 1.3783440e-01, 8.4682620e-02, 1.4499930e-01,
 6.9348840e-02, 1.5606680e-01, 4.7783930e-02, 2.0420360e-01, 9.5751230e-02, 2.8190510e-01, 9.3539830e-02, 3.5789690e-01,
 7.3667100e-03, 2.5132160e-01, 8.3667050e-02, 4.5556440e-01, 1.4439860e-01, 3.9965160e-01, 1.9347560e-01, 4.1986550e-01,
 1.0546210e-01, 1.4961660e-01, 7.8726960e-02, 2.4199610e-01, 1.7355970e-01, 3.2212130e-01, 1.8368990e-01, 5.0553360e-01,
 6.7423810e-03, 1.4500450e-01, 8.2961870e-02, 3.2492050e-01, 1.7586600e-01, 3.0684030e-01, 2.5528750e-01, 3.9848930e-01,
 1.3546830e-01, 2.3377300e-01, 8.9369250e-02, 3.4364980e-01, 3.0927890e-01, 6.9822320e-01, 2.8927450e-01, 9.9590540e-01,
 1.1817850e-02, 3.0915780e-01, 1.2850710e-01, 6.2960610e-01, 4.7150350e-01, 1.0006660e+00, 6.0486170e-01, 1.1810990e+00,
 3.9770960e-03, 7.8994960e-03, 4.6272100e-03, 1.2523980e-02, 2.4676090e-01, 6.4120510e-01, 4.0704170e-01, 9.8637510e-01,
 7.0169500e-03, 2.1128400e-01, 1.3456740e-01, 4.6406280e-01, 3.1790050e-01, 7.7655430e-01, 7.1922540e-01, 9.8853180e-01,
 2.0172320e-01, 3.6080440e-01, 1.6653280e-01, 5.7126220e-01, 3.7490160e-01, 8.7724420e-01, 4.3880400e-01, 1.3476780e+00,
 1.9043540e-02, 5.1635520e-01, 2.5913710e-01, 1.1326070e+00, 4.7301020e-01, 1.0404800e+00, 7.5933770e-01, 1.3227360e+00,
 8.6087500e-02, 1.8148560e-01, 4.6118770e-02, 2.4244200e-01, 1.2679180e-01, 3.4968780e-01, 9.6302640e-02, 4.5326090e-01,
 2.9599560e-03, 9.4595910e-02, 2.6137320e-02, 1.7506730e-01, 1.3282940e-01, 3.4438460e-01, 1.3837340e-01, 3.6939000e-01,
 6.8795140e-02, 1.7641410e-01, 3.2570080e-02, 2.1418660e-01, 1.4056230e-01, 4.7155440e-01, 9.4349460e-02, 5.5551100e-01,
 3.2276530e-03, 1.2547220e-01, 2.5187560e-02, 2.1104410e-01, 2.2155110e-01, 6.9870970e-01, 2.0396500e-01, 6.8113210e-01,
 1.2587890e-03, 3.7153970e-03, 1.0510340e-03, 4.8650290e-03, 6.9897530e-02, 2.6989900e-01, 8.2743710e-02, 3.4291270e-01,
 1.1944380e-03, 5.3444220e-02, 1.6438620e-02, 9.6950020e-02, 9.3099420e-02, 3.3794530e-01, 1.5115810e-01, 3.5530590e-01,
 1.2045460e-01, 3.2015340e-01, 7.1363770e-02, 4.1865750e-01, 2.0034720e-01, 6.9663500e-01, 1.6828570e-01, 8.8391000e-01,
 6.1156600e-03, 2.4641270e-01, 5.9722210e-02, 4.4640670e-01, 2.6134050e-01, 8.5425740e-01, 3.0107990e-01, 8.9694370e-01,
 9.6582560e-02, 1.6724150e-01, 4.3534190e-02, 2.1470250e-01, 1.6328570e-01, 3.6989700e-01, 1.0434930e-01, 4.6076120e-01,
 4.7179900e-03, 1.2384750e-01, 3.5053140e-02, 2.2026590e-01, 1.5408160e-01, 3.2812800e-01, 1.3505260e-01, 3.3822990e-01,
 1.2932330e-01, 2.7239270e-01, 5.1514800e-02, 3.1782040e-01, 3.0330980e-01, 8.3578100e-01, 1.7129750e-01, 9.4619540e-01,
 8.6202350e-03, 2.7524710e-01, 5.6599480e-02, 4.4491400e-01, 4.3061650e-01, 1.1154670e+00, 3.3355430e-01, 1.0450060e+00,
 2.1100720e-03, 5.1155520e-03, 1.4823650e-03, 6.4372470e-03, 1.3449450e-01, 4.2656690e-01, 1.3395900e-01, 5.2083100e-01,
 2.8445990e-03, 1.0454450e-01, 3.2939500e-02, 1.8225350e-01, 1.6135740e-01, 4.8109570e-01, 2.2042830e-01, 4.8608800e-01,
 2.6616800e-01, 5.8107710e-01, 1.3267970e-01, 7.3023380e-01, 5.0817620e-01, 1.4513740e+00, 3.5914710e-01, 1.7697410e+00,
 1.9199460e-02, 6.3540680e-01, 1.5775230e-01, 1.1062340e+00, 5.9708620e-01, 1.6031060e+00, 5.7877020e-01, 1.6175810e+00,
 1.0697360e-03, 2.1532270e-03, 4.3699500e-04, 2.5548180e-03, 1.3081550e-03, 3.4447660e-03, 7.5764980e-04, 3.9658100e-03,
 5.6279960e-05, 1.7173230e-03, 3.7895860e-04, 2.8228580e-03, 1.6312320e-03, 4.0380910e-03, 1.2957940e-03, 3.8469980e-03,
 5.0531910e-02, 1.2372350e-01, 1.8242690e-02, 1.3341840e-01, 8.5725190e-02, 2.7458850e-01, 4.3877430e-02, 2.8730800e-01,
 3.6276620e-03, 1.3464760e-01, 2.1586800e-02, 2.0115400e-01, 1.6082980e-01, 4.8428440e-01, 1.1290430e-01, 4.1931420e-01,
 6.5298530e-04, 1.8402060e-03, 4.1574720e-04, 2.1401850e-03, 3.0105360e-02, 1.1099270e-01, 2.7175600e-02, 1.2525090e-01,
 9.4808220e-04, 4.0503650e-02, 9.9497020e-03, 6.5259810e-02, 4.7728970e-02, 1.6542170e-01, 5.9091990e-02, 1.5447310e-01,
 8.0915590e-02, 2.0534210e-01, 3.6555170e-02, 2.3849710e-01, 1.1174390e-01, 3.7098540e-01, 7.1573100e-02, 4.1808440e-01,
 6.2861420e-03, 2.4183270e-01, 4.6810040e-02, 3.8912320e-01, 1.7350040e-01, 5.4149370e-01, 1.5241850e-01, 5.0498010e-01,
 2.5662050e-01, 4.1053400e-01, 1.2560080e-01, 5.8942680e-01, 4.2240600e-01, 8.8404670e-01, 2.9311670e-01, 1.2315670e+00,
 1.1998470e-02, 2.9098360e-01, 9.6797670e-02, 5.7878360e-01, 4.4067770e-01, 8.6701420e-01, 4.1941380e-01, 9.9949970e-01,
 1.9827370e-01, 3.8583040e-01, 8.5760960e-02, 5.0346630e-01, 4.5275590e-01, 1.1526110e+00, 2.7765020e-01, 1.4593470e+00,
 1.2649800e-02, 3.7316410e-01, 9.0187480e-02, 6.7459140e-01, 7.1065190e-01, 1.7007300e+00, 5.9772570e-01, 1.7819070e+00,
 6.6063780e-03, 1.4796920e-02, 5.0395350e-03, 2.0824110e-02, 4.0997750e-01, 1.2013100e+00, 4.4340080e-01, 1.6404100e+00,
 8.5243900e-03, 2.8943840e-01, 1.0718360e-01, 5.6431080e-01, 5.4379210e-01, 1.4979180e+00, 8.0664150e-01, 1.6926180e+00,
 3.7829470e-01, 7.6299310e-01, 2.0476140e-01, 1.0723500e+00, 7.0319850e-01, 1.8554770e+00, 5.3964120e-01, 2.5303080e+00,
 2.6117980e-02, 7.9857350e-01, 2.3302120e-01, 1.5548830e+00, 9.1345930e-01, 2.2658270e+00, 9.6145190e-01, 2.5569270e+00,
 9.1515940e-02, 2.4067520e-01, 7.7651220e-02, 3.0619120e-01, 1.1063720e-01, 3.8064760e-01, 1.3309510e-01, 4.6987950e-01,
 3.4138670e-03, 1.3610260e-01, 4.7745930e-02, 2.3988030e-01, 1.7515570e-01, 5.6650810e-01, 2.8899900e-01, 5.7868630e-01,
 1.1134050e-01, 3.5617330e-01, 8.3488810e-02, 4.1182810e-01, 1.8673160e-01, 7.8147170e-01, 1.9851910e-01, 8.7673800e-01,
 5.6674420e-03, 2.7484020e-01, 7.0048730e-02, 4.4025240e-01, 4.4477730e-01, 1.7498390e+00, 6.4854220e-01, 1.6245320e+00,
 1.8334260e-03, 6.7506880e-03, 2.4246050e-03, 8.4182920e-03, 8.3565220e-02, 4.0252930e-01, 1.5667970e-01, 4.8705220e-01,
 1.8874640e-03, 1.0535340e-01, 4.1142860e-02, 1.8200830e-01, 1.6820180e-01, 7.6166230e-01, 4.3254250e-01, 7.6263040e-01,
 1.3621400e-01, 4.5163640e-01, 1.2781740e-01, 5.6245180e-01, 1.8596660e-01, 8.0665820e-01, 2.4740750e-01, 9.7473820e-01,
 7.5031970e-03, 3.7713650e-01, 1.1605210e-01, 6.5067170e-01, 3.6658800e-01, 1.4948330e+00, 6.6890930e-01, 1.4947370e+00,
 1.4411680e-01, 3.1130950e-01, 1.0288690e-01, 3.8061080e-01, 1.9999420e-01, 5.6517450e-01, 2.0242900e-01, 6.7046080e-01,
 7.6379640e-03, 2.5011540e-01, 8.9879670e-02, 4.2363920e-01, 2.8519360e-01, 7.5764340e-01, 3.9591870e-01, 7.4375400e-01,
 2.9378630e-01, 7.7193860e-01, 1.8535340e-01, 8.5775790e-01, 5.6558080e-01, 1.9441650e+00, 5.0591000e-01, 2.0961250e+00,
 2.1246070e-02, 8.4628150e-01, 2.2094590e-01, 1.3027580e+00, 1.2134410e+00, 3.9211830e+00, 1.4887040e+00, 3.4984430e+00,
 4.3138670e-03, 1.3046520e-02, 4.7999700e-03, 1.5635000e-02, 2.2569790e-01, 8.9298180e-01, 3.5604820e-01, 1.0383600e+00,
 6.3095050e-03, 2.8927310e-01, 1.1571920e-01, 4.8026220e-01, 4.0919630e-01, 1.5219720e+00, 8.8536850e-01, 1.4644880e+00,
 4.2248700e-01, 1.1505980e+00, 3.3356140e-01, 1.3770430e+00, 6.6210250e-01, 2.3589730e+00, 7.4113470e-01, 2.7393580e+00,
 3.3063690e-02, 1.3650440e+00, 4.3028080e-01, 2.2632760e+00, 1.1756220e+00, 3.9375440e+00, 1.8048900e+00, 3.7837720e+00,
 1.3582250e-03, 3.4104940e-03, 8.7879060e-04, 3.8537460e-03, 1.3633510e-03, 4.4785840e-03, 1.2506360e-03, 4.9103050e-03,
 7.7527110e-05, 2.9511030e-03, 8.2680960e-04, 4.6197340e-03, 2.5691170e-03, 7.9337190e-03, 3.2323490e-03, 7.1981080e-03,
 9.7678630e-02, 2.9834500e-01, 5.5851750e-02, 3.0639220e-01, 1.3601780e-01, 5.4350340e-01, 1.1026620e-01, 5.4158090e-01,
 7.6079130e-03, 3.5226520e-01, 7.1703590e-02, 5.0118220e-01, 3.8563260e-01, 1.4485720e+00, 4.2877710e-01, 1.1944690e+00,
 1.1359310e-03, 3.9934450e-03, 1.1454920e-03, 4.4231140e-03, 4.2987870e-02, 1.9771010e-01, 6.1460380e-02, 2.1247670e-01,
 1.7893670e-03, 9.5363060e-02, 2.9742500e-02, 1.4632800e-01, 1.0299210e-01, 4.4529410e-01, 2.0195960e-01, 3.9600720e-01,
 1.0928710e-01, 3.4597690e-01, 7.8198680e-02, 3.8269080e-01, 1.2388360e-01, 5.1307330e-01, 1.2567640e-01, 5.5065850e-01,
 9.2114000e-03, 4.4206790e-01, 1.0864120e-01, 6.7741800e-01, 2.9067670e-01, 1.1317120e+00, 4.0444680e-01, 1.0051070e+00,
 3.9122090e-01, 7.8075070e-01, 3.0327530e-01, 1.0675520e+00, 5.2858430e-01, 1.3800410e+00, 5.8094990e-01, 1.8309240e+00,
 1.9845470e-02, 6.0039440e-01, 2.5357960e-01, 1.1373130e+00, 8.3334550e-01, 2.0453270e+00, 1.2562050e+00, 2.2455090e+00,
 4.6018760e-01, 1.1171170e+00, 3.1526310e-01, 1.3882520e+00, 8.6255590e-01, 2.7392920e+00, 8.3778980e-01, 3.3030110e+00,
 3.1853570e-02, 1.1722140e+00, 3.5969520e-01, 2.0181040e+00, 2.0459730e+00, 6.1081660e+00, 2.7255790e+00, 6.0947540e+00,
 1.3799010e-02, 3.8555660e-02, 1.6672040e-02, 5.1674850e-02, 7.0290710e-01, 2.5693630e+00, 1.2040610e+00, 3.3413240e+00,
 1.9317570e-02, 8.1823470e-01, 3.8470840e-01, 1.5192730e+00, 1.4089340e+00, 4.8414800e+00, 3.3101840e+00, 5.2100860e+00,
 6.1348320e-01, 1.5435670e+00, 5.2593780e-01, 2.0660320e+00, 9.3606030e-01, 3.0811580e+00, 1.1377450e+00, 4.0015430e+00,
 4.5953310e-02, 1.7527690e+00, 6.4936160e-01, 3.2501480e+00, 1.8375320e+00, 5.6859760e+00, 3.0632830e+00, 6.1107180e+00,
 1.9727050e-03, 3.5259800e-03, 1.6555110e-03, 5.6926910e-03, 2.0659150e-03, 4.8307830e-03, 2.4580570e-03, 7.5675860e-03,
 7.0454290e-05, 1.9090180e-03, 9.7457560e-04, 4.2698720e-03, 2.5533870e-03, 5.6128280e-03, 4.1668440e-03, 7.2760420e-03,
 2.4299960e-03, 5.2831960e-03, 1.8021830e-03, 7.7522490e-03, 3.5303370e-03, 1.0041410e-02, 3.7120950e-03, 1.4296430e-02,
 1.1842270e-04, 3.9031120e-03, 1.4476600e-03, 7.9343060e-03, 6.5648090e-03, 1.7553370e-02, 9.4675180e-03, 2.0680800e-02,
 4.4191110e-05, 1.1058660e-04, 5.7800410e-05, 1.7500680e-04, 1.7447900e-03, 5.7121310e-03, 3.2355540e-03, 8.7710700e-03,
 4.3555770e-05, 1.6523360e-03, 9.3903090e-04, 3.6225770e-03, 2.7417590e-03, 8.4380910e-03, 6.9734210e-03, 1.0721910e-02,
 3.1425070e-03, 7.0815210e-03, 2.9165070e-03, 1.1191790e-02, 3.7165130e-03, 1.0956540e-02, 4.8902590e-03, 1.6801500e-02,
 1.6572820e-04, 5.6615030e-03, 2.5352530e-03, 1.2395710e-02, 5.7195260e-03, 1.5851030e-02, 1.0322080e-02, 2.0114360e-02,
 1.1734720e-01, 1.7227950e-01, 8.2858450e-02, 2.6729990e-01, 1.4106580e-01, 2.7093800e-01, 1.4121970e-01, 4.0788440e-01,
 5.9543080e-03, 1.3251870e-01, 6.9300040e-02, 2.8484540e-01, 1.5704540e-01, 2.8355230e-01, 2.1563030e-01, 3.5324350e-01,
 2.4220140e-01, 4.3252470e-01, 1.5113470e-01, 6.0991510e-01, 4.0391120e-01, 9.4364230e-01, 3.5734100e-01, 1.2911240e+00,
 1.6769470e-02, 4.5398180e-01, 1.7248240e-01, 8.8687790e-01, 6.7653610e-01, 1.4858420e+00, 8.2091670e-01, 1.6823130e+00,
 3.9276350e-03, 8.0731300e-03, 4.3223640e-03, 1.2277830e-02, 1.7800740e-01, 4.7866980e-01, 2.7773950e-01, 7.0634670e-01,
 5.4999050e-03, 1.7137640e-01, 9.9766210e-02, 3.6107520e-01, 2.5195520e-01, 6.3691480e-01, 5.3918030e-01, 7.7774440e-01,
 3.6818060e-01, 6.8148180e-01, 2.8750250e-01, 1.0350340e+00, 4.9982590e-01, 1.2103180e+00, 5.5336170e-01, 1.7836180e+00,
 2.7586350e-02, 7.7405640e-01, 3.5506940e-01, 1.6286950e+00, 6.9285500e-01, 1.5771870e+00, 1.0520680e+00, 1.9233530e+00,
 1.0144800e-03, 1.7313000e-03, 6.4919600e-04, 2.4826450e-03, 8.8211620e-04, 1.9694360e-03, 8.0032690e-04, 2.7402240e-03,
 5.5439730e-05, 1.4342830e-03, 5.8477850e-04, 2.8493380e-03, 1.2977260e-03, 2.7236990e-03, 1.6148640e-03, 3.1360070e-03,
 7.3868380e-02, 1.5334190e-01, 4.1774780e-02, 1.9984640e-01, 8.9104760e-02, 2.4198610e-01, 7.1444030e-02, 3.0600450e-01,
 5.5083310e-03, 1.7334340e-01, 5.1346850e-02, 3.1297500e-01, 1.9722410e-01, 5.0351150e-01, 2.1688830e-01, 5.2689080e-01,
 9.4870310e-04, 2.2667780e-03, 9.4621220e-04, 3.1861480e-03, 3.1100710e-02, 9.7215670e-02, 4.3978250e-02, 1.3258520e-01,
 1.4307810e-03, 5.1824710e-02, 2.3521750e-02, 1.0091610e-01, 5.8171390e-02, 1.7093670e-01, 1.1282060e-01, 1.9291590e-01,
 8.7363540e-02, 1.8797130e-01, 6.1827140e-02, 2.6385710e-01, 8.5786950e-02, 2.4147370e-01, 8.6075510e-02, 3.2888890e-01,
 7.0498920e-03, 2.2994750e-01, 8.2237430e-02, 4.4717040e-01, 1.5714430e-01, 4.1582190e-01, 2.1625610e-01, 4.6866270e-01,
 2.9337680e-01, 3.9792310e-01, 2.2493600e-01, 6.9048150e-01, 3.4337130e-01, 6.0929090e-01, 3.7325600e-01, 1.0258400e+00,
 1.4248220e-02, 2.9296710e-01, 1.8006610e-01, 7.0426910e-01, 4.2262580e-01, 7.0497970e-01, 6.3010060e-01, 9.8221190e-01,
 3.4940210e-01, 5.7646410e-01, 2.3674580e-01, 9.0911410e-01, 5.6731460e-01, 1.2244980e+00, 5.4499200e-01, 1.8737260e+00,
 2.3154970e-02, 5.7912990e-01, 2.5860630e-01, 1.2652870e+00, 1.0505520e+00, 2.1316290e+00, 1.3841880e+00, 2.6991900e+00,
 1.1570650e-02, 2.1972580e-02, 1.3826650e-02, 3.7372190e-02, 5.1056830e-01, 1.2684240e+00, 8.6501300e-01, 2.0933120e+00,
 1.5508080e-02, 4.4644320e-01, 3.0546080e-01, 1.0519630e+00, 7.9896480e-01, 1.8659420e+00, 1.8565540e+00, 2.5482470e+00,
 4.9237460e-01, 8.4197950e-01, 4.1748960e-01, 1.4301760e+00, 6.5079290e-01, 1.4559150e+00, 7.8235220e-01, 2.3995290e+00,
 3.5310610e-02, 9.1536870e-01, 4.9350710e-01, 2.1540260e+00, 9.9736700e-01, 2.0975300e+00, 1.6444690e+00, 2.8606970e+00,
 1.5261110e-01, 2.8530780e-01, 1.2469520e-01, 4.2936550e-01, 1.8954780e-01, 4.6358980e-01, 2.1957960e-01, 6.7693870e-01,
 6.4018560e-03, 1.8143400e-01, 8.6219960e-02, 3.7826750e-01, 2.1188630e-01, 4.8716690e-01, 3.3665670e-01, 5.8866330e-01,
 1.7652450e-01, 4.0142660e-01, 1.2746540e-01, 5.4905120e-01, 3.0415710e-01, 9.0487050e-01, 3.1138280e-01, 1.2008680e+00,
 1.0104360e-02, 3.4833330e-01, 1.2026360e-01, 6.6003750e-01, 5.1154490e-01, 1.4306460e+00, 7.1827630e-01, 1.5711390e+00,
 2.6384820e-03, 6.9060830e-03, 3.3600360e-03, 1.0187320e-02, 1.2355060e-01, 4.2306760e-01, 2.2307150e-01, 6.0553580e-01,
 3.0544960e-03, 1.2119990e-01, 6.4116160e-02, 2.4768350e-01, 1.7559440e-01, 5.6524360e-01, 4.3483160e-01, 6.6948270e-01,
 2.0761890e-01, 4.8935850e-01, 1.8760630e-01, 7.2090110e-01, 2.9121160e-01, 8.9795830e-01, 3.7307710e-01, 1.2835320e+00,
 1.2860610e-02, 4.5952260e-01, 1.9154920e-01, 9.3782610e-01, 4.0533380e-01, 1.1749530e+00, 7.1221970e-01, 1.3897750e+00,
 2.0990930e-01, 3.2233130e-01, 1.4430770e-01, 4.6616900e-01, 2.9926990e-01, 6.0120310e-01, 2.9169600e-01, 8.4365350e-01,
 1.2510220e-02, 2.9121960e-01, 1.4176230e-01, 5.8348330e-01, 3.0133270e-01, 5.6906830e-01, 4.0283270e-01, 6.6081670e-01,
 4.0682830e-01, 7.5989810e-01, 2.4716810e-01, 9.9882520e-01, 8.0464200e-01, 1.9662300e+00, 6.9309610e-01, 2.5076700e+00,
 3.3084780e-02, 9.3682290e-01, 3.3132010e-01, 1.7059200e+00, 1.2189550e+00, 2.8001360e+00, 1.4400900e+00, 2.9552140e+00,
 5.4223240e-03, 1.1657520e-02, 5.8099090e-03, 1.6525770e-02, 2.9145710e-01, 8.1975240e-01, 4.4275960e-01, 1.1275610e+00,
 8.9183390e-03, 2.9066300e-01, 1.5750930e-01, 5.7083710e-01, 3.7311240e-01, 9.8652430e-01, 7.7739950e-01, 1.1228950e+00,
 5.6245330e-01, 1.0889050e+00, 4.2762300e-01, 1.5415790e+00, 9.0557990e-01, 2.2935990e+00, 9.7613720e-01, 3.1506160e+00,
 4.9498770e-02, 1.4527230e+00, 6.2030780e-01, 2.8492180e+00, 1.1353510e+00, 2.7032170e+00, 1.6785160e+00, 3.0727880e+00,
 2.6563550e-03, 4.7415990e-03, 1.6550530e-03, 6.3378610e-03, 2.7393690e-03, 6.3970040e-03, 2.4198360e-03, 8.2965310e-03,
 1.7050540e-04, 4.6138320e-03, 1.7510650e-03, 8.5437130e-03, 3.6449170e-03, 8.0015420e-03, 4.4160530e-03, 8.5875110e-03,
 1.8162540e-01, 3.9435620e-01, 1.0000600e-01, 4.7907090e-01, 2.5983710e-01, 7.3807520e-01, 2.0284300e-01, 8.6998900e-01,
 1.5907890e-02, 5.2361210e-01, 1.4437770e-01, 8.8122680e-01, 5.2016370e-01, 1.3889910e+00, 5.5694210e-01, 1.3548350e+00,
 1.9172030e-03, 4.7913370e-03, 1.8617440e-03, 6.2775360e-03, 7.4540160e-02, 2.4370600e-01, 1.0262470e-01, 3.0981380e-01,
 3.3961390e-03, 1.2866460e-01, 5.4359520e-02, 2.3353850e-01, 1.2609830e-01, 3.8756570e-01, 2.3811240e-01, 4.0771200e-01,
 1.9536160e-01, 4.3965350e-01, 1.3461140e-01, 5.7525920e-01, 2.2751640e-01, 6.6984020e-01, 2.2226180e-01, 8.5040590e-01,
 1.8516810e-02, 6.3171670e-01, 2.1030370e-01, 1.1450970e+00, 3.7693810e-01, 1.0432500e+00, 5.0504880e-01, 1.0960170e+00,
 4.1573590e-01, 5.8979470e-01, 3.1034490e-01, 9.5395840e-01, 5.7708290e-01, 1.0710480e+00, 6.1076580e-01, 1.6808900e+00,
 2.3715200e-02, 5.1002940e-01, 2.9180460e-01, 1.1428540e+00, 6.4240660e-01, 1.1208320e+00, 9.3251890e-01, 1.4556090e+00,
 4.6493560e-01, 8.0232360e-01, 3.0672090e-01, 1.1794280e+00, 8.9531040e-01, 2.0212390e+00, 8.3740120e-01, 2.8829790e+00,
 3.6189790e-02, 9.4673370e-01, 3.9352720e-01, 1.9280420e+00, 1.4995020e+00, 3.1823740e+00, 1.9236150e+00, 3.7562000e+00,
 1.2654500e-02, 2.5134960e-02, 1.4723060e-02, 3.9849350e-02, 6.6225200e-01, 1.7208530e+00, 1.0924110e+00, 2.6472140e+00,
 1.9921390e-02, 5.9984340e-01, 3.8204180e-01, 1.3174920e+00, 9.3729640e-01, 2.2895890e+00, 2.1205610e+00, 2.9145830e+00,
 5.9587350e-01, 1.0657860e+00, 4.9192390e-01, 1.6874600e+00, 9.3407900e-01, 2.1856810e+00, 1.0932940e+00, 3.3577820e+00,
 5.0192430e-02, 1.3609400e+00, 6.8299920e-01, 2.9851740e+00, 1.2947190e+00, 2.8479920e+00, 2.0784520e+00, 3.6205800e+00,
 5.1427760e-02, 1.0841760e-01, 2.7550870e-02, 1.4483230e-01, 8.5103750e-02, 2.3471350e-01, 6.4639170e-02, 3.0423270e-01,
 1.5664860e-03, 5.0062650e-02, 1.3832560e-02, 9.2650200e-02, 8.6744250e-02, 2.2490030e-01, 9.0364730e-02, 2.4123010e-01,
 6.6875320e-02, 1.7149100e-01, 3.1661170e-02, 2.0820940e-01, 1.5352430e-01, 5.1503890e-01, 1.0304990e-01, 6.0673760e-01,
 2.7795780e-03, 1.0805370e-01, 2.1690930e-02, 1.8174620e-01, 2.3543490e-01, 7.4249530e-01, 2.1674670e-01, 7.2381620e-01,
 6.9655970e-04, 2.0559400e-03, 5.8159680e-04, 2.6920970e-03, 4.3457750e-02, 1.6780570e-01, 5.1444670e-02, 2.1320080e-01,
 5.8553490e-04, 2.6199320e-02, 8.0585090e-03, 4.7526640e-02, 5.6317200e-02, 2.0442810e-01, 9.1437730e-02, 2.1492970e-01,
 1.2493810e-01, 3.3206990e-01, 7.4020020e-02, 4.3424040e-01, 2.3348270e-01, 8.1185180e-01, 1.9611850e-01, 1.0301000e+00,
 5.6195120e-03, 2.2642190e-01, 5.4877100e-02, 4.1019090e-01, 2.9632410e-01, 9.6861010e-01, 3.4138310e-01, 1.0170100e+00,
 8.6948840e-02, 1.5055980e-01, 3.9191830e-02, 1.9328680e-01, 1.6516320e-01, 3.7415020e-01, 1.0554910e-01, 4.6605920e-01,
 3.7627560e-03, 9.8772560e-02, 2.7956060e-02, 1.7566950e-01, 1.5163680e-01, 3.2292170e-01, 1.3290980e-01, 3.3286330e-01,
 1.8944910e-01, 3.9903520e-01, 7.5465370e-02, 4.6558350e-01, 4.9923180e-01, 1.3756510e+00, 2.8194670e-01, 1.5573870e+00,
 1.1187130e-02, 3.5720910e-01, 7.3453430e-02, 5.7739850e-01, 6.8959680e-01, 1.7863280e+00, 5.3415960e-01, 1.6734910e+00,
 1.7595840e-03, 4.2658480e-03, 1.2361410e-03, 5.3680060e-03, 1.2601360e-01, 3.9966860e-01, 1.2551190e-01, 4.8798870e-01,
 2.1014440e-03, 7.7232140e-02, 2.4334020e-02, 1.3463950e-01, 1.4709250e-01, 4.3856420e-01, 2.0094120e-01, 4.4311510e-01,
 4.1603980e-01, 9.0826520e-01, 2.0738790e-01, 1.1414080e+00, 8.9246940e-01, 2.5489340e+00, 6.3074140e-01, 3.1080550e+00,
 2.6585930e-02, 8.7986240e-01, 2.1844320e-01, 1.5318270e+00, 1.0202460e+00, 2.7392390e+00, 9.8894910e-01, 2.7639730e+00,
 1.4750890e-03, 2.9691460e-03, 6.0258480e-04, 3.5229110e-03, 2.0267540e-03, 5.3370530e-03, 1.1738440e-03, 6.1443170e-03,
 6.8751060e-05, 2.0978650e-03, 4.6293220e-04, 3.4483760e-03, 2.4589300e-03, 6.0870470e-03, 1.9532890e-03, 5.7989910e-03,
 1.1338560e-01, 2.7761610e-01, 4.0933720e-02, 2.9936980e-01, 2.1612290e-01, 6.9226890e-01, 1.1062000e-01, 7.2433620e-01,
 7.2111260e-03, 2.6765460e-01, 4.2910600e-02, 3.9985730e-01, 3.9450070e-01, 1.1879050e+00, 2.7694380e-01, 1.0285390e+00,
 8.3405140e-04, 2.3504770e-03, 5.3102960e-04, 2.7336360e-03, 4.3204930e-02, 1.5928830e-01, 3.9000370e-02, 1.7975070e-01,
 1.0728010e-03, 4.5831870e-02, 1.1258580e-02, 7.3844670e-02, 6.6643890e-02, 2.3097810e-01, 8.2510060e-02, 2.1569060e-01,
 1.9372590e-01, 4.9162450e-01, 8.7519400e-02, 5.7100340e-01, 3.0059340e-01, 9.9795840e-01, 1.9253310e-01, 1.1246560e+00,
 1.3332870e-02, 5.1292570e-01, 9.9283820e-02, 8.2532800e-01, 4.5409290e-01, 1.4172220e+00, 3.9891650e-01, 1.3216570e+00,
 2.0245000e-01, 3.2387360e-01, 9.9087470e-02, 4.6500360e-01, 3.7441790e-01, 7.8361320e-01, 2.5981670e-01, 1.0916530e+00,
 8.3856400e-03, 2.0336630e-01, 6.7651170e-02, 4.0450760e-01, 3.8004620e-01, 7.4772430e-01, 3.6170790e-01, 8.6198150e-01,
 2.5453190e-01, 4.9530590e-01, 1.1009480e-01, 6.4631990e-01, 6.5304240e-01, 1.6624930e+00, 4.0047480e-01, 2.1049210e+00,
 1.4386150e-02, 4.2438590e-01, 1.0256690e-01, 7.6718800e-01, 9.9729320e-01, 2.3867190e+00, 8.3881830e-01, 2.5006390e+00,
 4.8276710e-03, 1.0812980e-02, 3.6826860e-03, 1.5217410e-02, 3.3661570e-01, 9.8634620e-01, 3.6405820e-01, 1.3468730e+00,
 5.5185060e-03, 1.8737610e-01, 6.9388370e-02, 3.6532260e-01, 4.3440620e-01, 1.1966060e+00, 6.4438240e-01, 1.3521410e+00,
 5.1816800e-01, 1.0451070e+00, 2.8047120e-01, 1.4688480e+00, 1.0822270e+00, 2.8555910e+00, 8.3051130e-01, 3.8941610e+00,
 3.1693030e-02, 9.6903440e-01, 2.8276110e-01, 1.8867830e+00, 1.3677870e+00, 3.3927820e+00, 1.4396490e+00, 3.8286660e+00,
 5.6280340e-02, 1.4801010e-01, 4.7753840e-02, 1.8830110e-01, 7.6447140e-02, 2.6301660e-01, 9.1964940e-02, 3.2467330e-01,
 1.8599040e-03, 7.4149840e-02, 2.6012390e-02, 1.3068880e-01, 1.1775330e-01, 3.8085090e-01, 1.9428760e-01, 3.8903800e-01,
 1.1142020e-01, 3.5642810e-01, 8.3548540e-02, 4.1212270e-01, 2.0995610e-01, 8.7866630e-01, 2.2320970e-01, 9.8578130e-01,
 5.0243710e-03, 2.4365470e-01, 6.2100470e-02, 3.9029800e-01, 4.8656630e-01, 1.9142450e+00, 7.0947600e-01, 1.7771650e+00,
 1.0444100e-03, 3.8455260e-03, 1.3811750e-03, 4.7954760e-03, 5.3485180e-02, 2.5763530e-01, 1.0028140e-01, 3.1173340e-01,
 9.5251190e-04, 5.3166740e-02, 2.0762810e-02, 9.1850790e-02, 1.0474350e-01, 4.7430650e-01, 2.6935520e-01, 4.7490930e-01,
 1.4544390e-01, 4.8223950e-01, 1.3647840e-01, 6.0056390e-01, 2.2310480e-01, 9.6775070e-01, 2.9681560e-01, 1.1693970e+00,
 7.0974800e-03, 3.5674380e-01, 1.0977680e-01, 6.1548820e-01, 4.2789870e-01, 1.7448400e+00, 7.8078220e-01, 1.7447280e+00,
 1.3356180e-01, 2.8850940e-01, 9.5351560e-02, 3.5273510e-01, 2.0825010e-01, 5.8850520e-01, 2.1078530e-01, 6.9813770e-01,
 6.2708900e-03, 2.0534870e-01, 7.3792630e-02, 3.4781450e-01, 2.8893230e-01, 7.6757570e-01, 4.0110900e-01, 7.5350430e-01,
 4.4304690e-01, 1.1641290e+00, 2.7952380e-01, 1.2935490e+00, 9.5832530e-01, 3.2942110e+00, 8.5721850e-01, 3.5516940e+00,
 2.8384470e-02, 1.1306210e+00, 2.9518070e-01, 1.7404670e+00, 2.0004410e+00, 6.4643400e+00, 2.4542310e+00, 5.7674240e+00,
 3.7032420e-03, 1.1199790e-02, 4.1205380e-03, 1.3421880e-02, 2.1769220e-01, 8.6130710e-01, 3.4341890e-01, 1.0015290e+00,
 4.7983800e-03, 2.1999220e-01, 8.8004430e-02, 3.6523940e-01, 3.8400410e-01, 1.4282720e+00, 8.3086070e-01, 1.3743270e+00,
 6.7982140e-01, 1.8514210e+00, 5.3673170e-01, 2.2157920e+00, 1.1970350e+00, 4.2648570e+00, 1.3399200e+00, 4.9525670e+00,
 4.7132090e-02, 1.9458620e+00, 6.1336260e-01, 3.2262860e+00, 2.0679400e+00, 6.9262100e+00, 3.1748340e+00, 6.6557230e+00,
 1.9280390e-03, 4.8412950e-03, 1.2474680e-03, 5.4705040e-03, 2.1744630e-03, 7.1430710e-03, 1.9946890e-03, 7.8316410e-03,
 9.7494850e-05, 3.7111830e-03, 1.0397610e-03, 5.8095850e-03, 3.9867300e-03, 1.2311470e-02, 5.0159270e-03, 1.1169950e-02,
 2.2562870e-01, 6.8914960e-01, 1.2901240e-01, 7.0773800e-01, 3.5301300e-01, 1.4105780e+00, 2.8617870e-01, 1.4055890e+00,
 1.5568410e-02, 7.2085580e-01, 1.4673020e-01, 1.0255910e+00, 9.7377220e-01, 3.6578320e+00, 1.0827180e+00, 3.0161890e+00,
 1.4936330e-03, 5.2509720e-03, 1.5062040e-03, 5.8159420e-03, 6.3509390e-02, 2.9209290e-01, 9.0800300e-02, 3.1390870e-01,
 2.0843730e-03, 1.1108520e-01, 3.4646020e-02, 1.7045250e-01, 1.4804190e-01, 6.4007040e-01, 2.9029880e-01, 5.6922480e-01,
 2.6935620e-01, 8.5271750e-01, 1.9273360e-01, 9.4320490e-01, 3.4306150e-01, 1.4208150e+00, 3.4802620e-01, 1.5248970e+00,
 2.0112570e-02, 9.6523030e-01, 2.3721180e-01, 1.4791040e+00, 7.8317190e-01, 3.0491770e+00, 1.0897030e+00, 2.7080660e+00,
 3.1772480e-01, 6.3407610e-01, 2.4630090e-01, 8.6699740e-01, 4.8232900e-01, 1.2592760e+00, 5.3011210e-01, 1.6707040e+00,
 1.4278230e-02, 4.3196600e-01, 1.8244300e-01, 8.1826300e-01, 7.3984870e-01, 1.8158520e+00, 1.1152660e+00, 1.9935750e+00,
 6.0815520e-01, 1.4763120e+00, 4.1663220e-01, 1.8346270e+00, 1.2807580e+00, 4.0674100e+00, 1.2439840e+00, 4.9044430e+00,
 3.7292510e-02, 1.3723670e+00, 4.2111250e-01, 2.3626910e+00, 2.9557540e+00, 8.8242790e+00, 3.9375600e+00, 8.8049040e+00,
 1.0380650e-02, 2.9004470e-02, 1.2541960e-02, 3.8873700e-02, 5.9412080e-01, 2.1717120e+00, 1.0177130e+00, 2.8241990e+00,
 1.2873990e-02, 5.4530380e-01, 2.5638490e-01, 1.0125030e+00, 1.1586600e+00, 3.9814730e+00, 2.7221860e+00, 4.2846020e+00,
 8.6505860e-01, 2.1765490e+00, 7.4161270e-01, 2.9132650e+00, 1.4830190e+00, 4.8815410e+00, 1.8025520e+00, 6.3397260e+00,
 5.7404180e-02, 2.1895330e+00, 8.1117280e-01, 4.0600360e+00, 2.8324780e+00, 8.7646920e+00, 4.7219220e+00, 9.4194140e+00,
 7.3608390e-04, 1.3156640e-03, 6.1772800e-04, 2.1241390e-03, 8.6611970e-04, 2.0252700e-03, 1.0305220e-03, 3.1726540e-03,
 2.3289310e-05, 6.3104350e-04, 3.2215490e-04, 1.4114450e-03, 1.0415280e-03, 2.2894740e-03, 1.6996570e-03, 2.9679000e-03,
 1.4754400e-03, 3.2078390e-03, 1.0942460e-03, 4.7069940e-03, 2.4084200e-03, 6.8503160e-03, 2.5324160e-03, 9.7531230e-03,
 6.3699310e-05, 2.0994760e-03, 7.7869300e-04, 4.2678470e-03, 4.3573940e-03, 1.1651050e-02, 6.2840670e-03, 1.3726880e-02,
 1.5273830e-05, 3.8222190e-05, 1.9977630e-05, 6.0487830e-05, 6.7757330e-04, 2.2182540e-03, 1.2564980e-03, 3.4061650e-03,
 1.3336520e-05, 5.0593570e-04, 2.8752580e-04, 1.1092120e-03, 1.0359320e-03, 3.1882040e-03, 2.6348010e-03, 4.0511110e-03,
 2.0358950e-03, 4.5878130e-03, 1.8894790e-03, 7.2506770e-03, 2.7052970e-03, 7.9754000e-03, 3.5596810e-03, 1.2230030e-02,
 9.5117300e-05, 3.2493370e-03, 1.4550720e-03, 7.1143390e-03, 4.0506810e-03, 1.1226010e-02, 7.3103030e-03, 1.4245380e-02,
 6.5985050e-02, 9.6873810e-02, 4.6591810e-02, 1.5030440e-01, 8.9124000e-02, 1.7117600e-01, 8.9221230e-02, 2.5769740e-01,
 2.9661160e-03, 6.6013670e-02, 3.4521550e-02, 1.4189470e-01, 9.6535440e-02, 1.7429900e-01, 1.3254750e-01, 2.1713800e-01,
 2.2161550e-01, 3.9576220e-01, 1.3828900e-01, 5.5807530e-01, 4.1524980e-01, 9.7013230e-01, 3.6737230e-01, 1.3273680e+00,
 1.3593350e-02, 3.6799830e-01, 1.3981450e-01, 7.1890460e-01, 6.7671110e-01, 1.4862260e+00, 8.2112900e-01, 1.6827480e+00,
 2.0457460e-03, 4.2049660e-03, 2.2513440e-03, 6.3950270e-03, 1.0417380e-01, 2.8012810e-01, 1.6253930e-01, 4.1336970e-01,
 2.5378130e-03, 7.9077960e-02, 4.6034980e-02, 1.6661040e-01, 1.4346060e-01, 3.6265260e-01, 3.0700360e-01, 4.4283940e-01,
 3.5945750e-01, 6.6533580e-01, 2.8069090e-01, 1.0105110e+00, 5.4828400e-01, 1.3276580e+00, 6.0701000e-01, 1.9565390e+00,
 2.3859690e-02, 6.6948870e-01, 3.0710290e-01, 1.4086740e+00, 7.3946550e-01, 1.6832890e+00, 1.1228440e+00, 2.0527430e+00,
 8.7376190e-04, 1.4911520e-03, 5.5914600e-04, 2.1382780e-03, 8.5364110e-04, 1.9058620e-03, 7.7449200e-04, 2.6517690e-03,
 4.2301370e-05, 1.0943800e-03, 4.4619510e-04, 2.1740890e-03, 1.2218600e-03, 2.5644690e-03, 1.5204570e-03, 2.9526730e-03,
 1.0352820e-01, 2.1491210e-01, 5.8548290e-02, 2.8008920e-01, 1.4031400e-01, 3.8105750e-01, 1.1250350e-01, 4.8186790e-01,
 6.8391800e-03, 2.1522420e-01, 6.3752580e-02, 3.8859180e-01, 3.0216820e-01, 7.7143310e-01, 3.3229590e-01, 8.0725260e-01,
 7.5688080e-04, 1.8084490e-03, 7.5489360e-04, 2.5419270e-03, 2.7878380e-02, 8.7143210e-02, 3.9421690e-02, 1.1884810e-01,
 1.0112400e-03, 3.6628410e-02, 1.6624580e-02, 7.1325000e-02, 5.0733570e-02, 1.4908070e-01, 9.8395290e-02, 1.6824960e-01,
 1.3064520e-01, 2.8109610e-01, 9.2457560e-02, 3.9457730e-01, 1.4414000e-01, 4.0572640e-01, 1.4462490e-01, 5.5260220e-01,
 9.3396300e-03, 3.0463230e-01, 1.0894740e-01, 5.9240710e-01, 2.5689220e-01, 6.7976610e-01, 3.5352520e-01, 7.6614770e-01,
 1.4456390e-01, 1.9608000e-01, 1.1083920e-01, 3.4024070e-01, 1.9010710e-01, 3.3733310e-01, 2.0665270e-01, 5.6795500e-01,
 6.2198320e-03, 1.2789010e-01, 7.8604980e-02, 3.0743750e-01, 2.2765600e-01, 3.7975160e-01, 3.3941650e-01, 5.2908840e-01,
 2.8016270e-01, 4.6222890e-01, 1.8983100e-01, 7.2895920e-01, 5.1110360e-01, 1.1031710e+00, 4.9099280e-01, 1.6880730e+00,
 1.6448000e-02, 4.1138150e-01, 1.8369950e-01, 8.9878910e-01, 9.2085510e-01, 1.8684670e+00, 1.2133010e+00, 2.3659590e+00,
 5.2812860e-03, 1.0029120e-02, 6.3110130e-03, 1.7058090e-02, 2.6183990e-01, 6.5049880e-01, 4.4361350e-01, 1.0735350e+00,
 6.2708130e-03, 1.8052280e-01, 1.2351550e-01, 4.2536970e-01, 3.9865620e-01, 9.3104150e-01, 9.2635710e-01, 1.2714880e+00,
 4.2125370e-01, 7.2036000e-01, 3.5718540e-01, 1.2235950e+00, 6.2559170e-01, 1.3995360e+00, 7.5205660e-01, 2.3066100e+00,
 2.6763150e-02, 6.9379010e-01, 3.7404630e-01, 1.6326120e+00, 9.3280720e-01, 1.9617560e+00, 1.5380220e+00, 2.6755230e+00,
 1.1046270e-01, 2.0651110e-01, 9.0256680e-02, 3.1078270e-01, 1.5415180e-01, 3.7701930e-01, 1.7857550e-01, 5.5052750e-01,
 4.1050600e-03, 1.1634080e-01, 5.5286790e-02, 2.4255630e-01, 1.6765680e-01, 3.8547500e-01, 2.6638250e-01, 4.6578490e-01,
 2.0791470e-01, 4.7280970e-01, 1.5013170e-01, 6.4668540e-01, 4.0251160e-01, 1.1974760e+00, 4.1207380e-01, 1.5891890e+00,
 1.0543220e-02, 3.6346220e-01, 1.2548690e-01, 6.8870430e-01, 6.5864720e-01, 1.8420490e+00, 9.2482730e-01, 2.0229430e+00,
 1.7690150e-03, 4.6303000e-03, 2.2527930e-03, 6.8302600e-03, 9.3072690e-02, 3.1870380e-01, 1.6804340e-01, 4.5616010e-01,
 1.8142650e-03, 7.1988560e-02, 3.8082790e-02, 1.4711550e-01, 1.2869950e-01, 4.1428750e-01, 3.1870390e-01, 4.9068820e-01,
 2.6092180e-01, 6.1499360e-01, 2.3577130e-01, 9.0598110e-01, 4.1119910e-01, 1.2679430e+00, 5.2679560e-01, 1.8123840e+00,
 1.4318220e-02, 5.1160440e-01, 2.1325920e-01, 1.0441180e+00, 5.5685890e-01, 1.6141830e+00, 9.7846720e-01, 1.9093120e+00,
 2.2896490e-01, 3.5159260e-01, 1.5740800e-01, 5.0848790e-01, 3.6677550e-01, 7.3681500e-01, 3.5749310e-01, 1.0339540e+00,
 1.2088880e-02, 2.8141140e-01, 1.3698780e-01, 5.6383180e-01, 3.5931250e-01, 6.7856340e-01, 4.8034230e-01, 7.8796510e-01,
 7.2210270e-01, 1.3487860e+00, 4.3871270e-01, 1.7728720e+00, 1.6046880e+00, 3.9212280e+00, 1.3822330e+00, 5.0010160e+00,
 5.2023550e-02, 1.4730900e+00, 5.2097810e-01, 2.6824420e+00, 2.3651810e+00, 5.4332010e+00, 2.7942560e+00, 5.7341050e+00,
 5.4786100e-03, 1.1778530e-02, 5.8702190e-03, 1.6697310e-02, 3.3087170e-01, 9.3061000e-01, 5.0263540e-01, 1.2800450e+00,
 7.9827560e-03, 2.6017090e-01, 1.4098570e-01, 5.1095310e-01, 4.1211030e-01, 1.0896360e+00, 8.5865370e-01, 1.2402600e+00,
 1.0652160e+00, 2.0622480e+00, 8.0986410e-01, 2.9195560e+00, 1.9269830e+00, 4.8805480e+00, 2.0771220e+00, 6.7041940e+00,
 8.3048040e-02, 2.4373490e+00, 1.0407400e+00, 4.7803610e+00, 2.3505530e+00, 5.5965540e+00, 3.4750840e+00, 6.3616890e+00,
 4.4381280e-03, 7.9220680e-03, 2.7651950e-03, 1.0589040e-02, 5.1423830e-03, 1.2008550e-02, 4.5425510e-03, 1.5574370e-02,
 2.5236890e-04, 6.8290380e-03, 2.5917910e-03, 1.2645740e-02, 6.6571800e-03, 1.4614240e-02, 8.0656040e-03, 1.5684470e-02,
 4.9378840e-01, 1.0721440e+00, 2.7188810e-01, 1.3024590e+00, 7.9371700e-01, 2.2545770e+00, 6.1961870e-01, 2.6575310e+00,
 3.8314290e-02, 1.2611250e+00, 3.4773500e-01, 2.1224430e+00, 1.5459420e+00, 4.1281240e+00, 1.6552490e+00, 4.0266100e+00,
 2.9670820e-03, 7.4151210e-03, 2.8812540e-03, 9.7151780e-03, 1.2961400e-01, 4.2376780e-01, 1.7844870e-01, 5.3871920e-01,
 4.6561930e-03, 1.7640250e-01, 7.4528280e-02, 3.2018730e-01, 2.1333380e-01, 6.5568570e-01, 4.0283980e-01, 6.8976930e-01,
 5.6671790e-01, 1.2753760e+00, 3.9048970e-01, 1.6687500e+00, 7.4154990e-01, 2.1832270e+00, 7.2442350e-01, 2.7717500e+00,
 4.7585830e-02, 1.6234310e+00, 5.4045370e-01, 2.9427530e+00, 1.1953260e+00, 3.3083010e+00, 1.6015840e+00, 3.4756320e+00,
 3.9738930e-01, 5.6376670e-01, 2.9664920e-01, 9.1185970e-01, 6.1977900e-01, 1.1502900e+00, 6.5595400e-01, 1.8052530e+00,
 2.0082110e-02, 4.3189450e-01, 2.4710100e-01, 9.6777220e-01, 6.7127020e-01, 1.1711920e+00, 9.7441750e-01, 1.5210110e+00,
 7.2317270e-01, 1.2479540e+00, 4.7708140e-01, 1.8345120e+00, 1.5646710e+00, 3.5323760e+00, 1.4634670e+00, 5.0383780e+00,
 4.9867690e-02, 1.3045510e+00, 5.4226040e-01, 2.6567440e+00, 2.5496770e+00, 5.4111450e+00, 3.2708170e+00, 6.3868500e+00,
 1.1204470e-02, 2.2254840e-02, 1.3036000e-02, 3.5283170e-02, 6.5882440e-01, 1.7119470e+00, 1.0867570e+00, 2.6335130e+00,
 1.5626070e-02, 4.7050920e-01, 2.9966850e-01, 1.0334230e+00, 9.0721890e-01, 2.2161170e+00, 2.0525130e+00, 2.8210550e+00,
 9.8893220e-01, 1.7688150e+00, 8.1641380e-01, 2.8005670e+00, 1.7417910e+00, 4.0756730e+00, 2.0386820e+00, 6.2613070e+00,
 7.3796290e-02, 2.0009460e+00, 1.0041920e+00, 4.3890040e+00, 2.3489670e+00, 5.1670190e+00, 3.7708680e+00, 6.5686990e+00,
 8.7950910e-02, 1.8541400e-01, 4.7117040e-02, 2.4768980e-01, 1.9799850e-01, 5.4607380e-01, 1.5038650e-01, 7.0781370e-01,
 3.7219640e-03, 1.1894860e-01, 3.2866090e-02, 2.2013640e-01, 1.6612390e-01, 4.3070660e-01, 1.7305750e-01, 4.6197970e-01,
 9.7539230e-02, 2.5012370e-01, 4.6178560e-02, 3.0367830e-01, 3.0462180e-01, 1.0219360e+00, 2.0447090e-01, 1.2038840e+00,
 5.6324220e-03, 2.1895550e-01, 4.3953600e-02, 3.6828290e-01, 3.8453240e-01, 1.2127070e+00, 3.5400930e-01, 1.1821990e+00,
 1.1536910e-03, 3.4051920e-03, 9.6328160e-04, 4.4588400e-03, 9.7919420e-02, 3.7810140e-01, 1.1591560e-01, 4.8038620e-01,
 1.3473700e-03, 6.0287040e-02, 1.8543370e-02, 1.0936320e-01, 1.0445300e-01, 3.7915810e-01, 1.6959200e-01, 3.9863580e-01,
 2.1515910e-01, 5.7186610e-01, 1.2747180e-01, 7.4781660e-01, 5.4700340e-01, 1.9020070e+00, 4.5946660e-01, 2.4133200e+00,
 1.3445170e-02, 5.4173400e-01, 1.3129820e-01, 9.8141730e-01, 5.7145300e-01, 1.8679380e+00, 6.5834800e-01, 1.9612770e+00,
 1.4080500e-01, 2.4381670e-01, 6.3467280e-02, 3.1300880e-01, 3.6386320e-01, 8.2427240e-01, 2.3253020e-01, 1.0267530e+00,
 8.4657070e-03, 2.2222530e-01, 6.2897460e-02, 3.9523330e-01, 2.7498410e-01, 5.8559880e-01, 2.4102380e-01, 6.0362740e-01,
 2.6164810e-01, 5.5110750e-01, 1.0422520e-01, 6.4301720e-01, 9.3798910e-01, 2.5846620e+00, 5.2973960e-01, 2.9261200e+00,
 2.1465780e-02, 6.8540990e-01, 1.4094190e-01, 1.1079080e+00, 1.0665200e+00, 2.7627080e+00, 8.2612310e-01, 2.5881950e+00,
 2.7596430e-03, 6.6903400e-03, 1.9387010e-03, 8.4189100e-03, 2.6886280e-01, 8.5273350e-01, 2.6779230e-01, 1.0411730e+00,
 4.5789240e-03, 1.6828430e-01, 5.3022410e-02, 2.9337170e-01, 2.5833430e-01, 7.7023750e-01, 3.5290720e-01, 7.7823010e-01,
 6.7843990e-01, 1.4811160e+00, 3.3818930e-01, 1.8613040e+00, 1.9798870e+00, 5.6546460e+00, 1.3992600e+00, 6.8950220e+00,
 6.0232550e-02, 1.9933980e+00, 4.9490060e-01, 3.4704770e+00, 1.8630730e+00, 5.0021310e+00, 1.8059220e+00, 5.0472980e+00,
 2.7689590e-03, 5.5735220e-03, 1.1311400e-03, 6.6130200e-03, 5.1757070e-03, 1.3629190e-02, 2.9976370e-03, 1.5690700e-02,
 1.7930010e-04, 5.4711510e-03, 1.2073090e-03, 8.9932300e-03, 5.1688390e-03, 1.2795390e-02, 4.1059480e-03, 1.2189880e-02,
 1.8152100e-01, 4.4444040e-01, 6.5531520e-02, 4.7926630e-01, 4.7069570e-01, 1.5076970e+00, 2.4092010e-01, 1.5775370e+00,
 1.6038910e-02, 5.9531460e-01, 9.5441300e-02, 8.8935830e-01, 7.0723760e-01, 2.1296060e+00, 4.9648860e-01, 1.8439040e+00,
 1.5162800e-03, 4.2730960e-03, 9.6539590e-04, 4.9696680e-03, 1.0685390e-01, 3.9394990e-01, 9.6455250e-02, 4.4455720e-01,
 2.7096230e-03, 1.1575960e-01, 2.8436290e-02, 1.8651280e-01, 1.3567370e-01, 4.7022550e-01, 1.6797410e-01, 4.3910320e-01,
 3.6619140e-01, 9.2929570e-01, 1.6543400e-01, 1.0793420e+00, 7.7298350e-01, 2.5662750e+00, 4.9510380e-01, 2.8920810e+00,
 3.5014420e-02, 1.3470310e+00, 2.6073640e-01, 2.1674540e+00, 9.6120000e-01, 2.9999000e+00, 8.4440540e-01, 2.7976140e+00,
 2.6994210e-01, 4.3184550e-01, 1.3212090e-01, 6.2002490e-01, 6.7917210e-01, 1.4214280e+00, 4.7129220e-01, 1.9801940e+00,
 1.5534300e-02, 3.7673380e-01, 1.2532300e-01, 7.4934580e-01, 5.6746340e-01, 1.1164590e+00, 5.4008160e-01, 1.2870620e+00,
 2.8944480e-01, 5.6324460e-01, 1.2519590e-01, 7.3497240e-01, 1.0102650e+00, 2.5718980e+00, 6.1953970e-01, 3.2563400e+00,
 2.2728510e-02, 6.7048220e-01, 1.6204420e-01, 1.2120710e+00, 1.2699740e+00, 3.0393000e+00, 1.0681690e+00, 3.1843680e+00,
 6.2341740e-03, 1.3963250e-02, 4.7556070e-03, 1.9650880e-02, 5.9135190e-01, 1.7327710e+00, 6.3956180e-01, 2.3661290e+00,
 9.9006920e-03, 3.3616950e-01, 1.2448890e-01, 6.5542140e-01, 6.2818260e-01, 1.7303780e+00, 9.3182320e-01, 1.9552940e+00,
 6.9573770e-01, 1.4032530e+00, 3.7658520e-01, 1.9722040e+00, 1.9768050e+00, 5.2160460e+00, 1.5170190e+00, 7.1131050e+00,
 5.9120970e-02, 1.8076610e+00, 5.2746970e-01, 3.5196520e+00, 2.0565630e+00, 5.1012850e+00, 2.1646130e+00, 5.7566670e+00,
 1.3643140e-01, 3.5879700e-01, 1.1576190e-01, 4.5646790e-01, 2.5210940e-01, 8.6738340e-01, 3.0328450e-01, 1.0707160e+00,
 6.2639870e-03, 2.4972990e-01, 8.7607350e-02, 4.4014800e-01, 3.1965320e-01, 1.0338580e+00, 5.2741360e-01, 1.0560830e+00,
 2.3035200e-01, 7.3688570e-01, 1.7272970e-01, 8.5202970e-01, 5.9050990e-01, 2.4712840e+00, 6.2778600e-01, 2.7725490e+00,
 1.4431540e-02, 6.9985130e-01, 1.7837170e-01, 1.1210560e+00, 1.1264680e+00, 4.4317400e+00, 1.6425350e+00, 4.1143820e+00,
 2.4519810e-03, 9.0282110e-03, 3.2426100e-03, 1.1258430e-02, 1.7082440e-01, 8.2285210e-01, 3.2028520e-01, 9.9563400e-01,
 3.1068420e-03, 1.7341590e-01, 6.7722810e-02, 2.9959300e-01, 2.7537320e-01, 1.2469630e+00, 7.0814140e-01, 1.2485480e+00,
 3.5503830e-01, 1.1771790e+00, 3.3315280e-01, 1.4660160e+00, 7.4089900e-01, 3.2137610e+00, 9.8568190e-01, 3.8833990e+00,
 2.4070580e-02, 1.2098700e+00, 3.7230010e-01, 2.0873830e+00, 1.1696860e+00, 4.7696200e+00, 2.1343130e+00, 4.7693130e+00,
 3.0658520e-01, 6.6226070e-01, 2.1887540e-01, 8.0968820e-01, 6.5031630e-01, 1.8377640e+00, 6.5823330e-01, 2.1801210e+00,
 1.9998670e-02, 6.5488320e-01, 2.3533410e-01, 1.1092250e+00, 7.4270080e-01, 1.9730540e+00, 1.0310510e+00, 1.9368830e+00,
 8.6734030e-01, 2.2789810e+00, 5.4721580e-01, 2.5323440e+00, 2.5522500e+00, 8.7732740e+00, 2.2829780e+00, 9.4590110e+00,
 7.7201080e-02, 3.0751030e+00, 8.0284310e-01, 4.7337850e+00, 4.3854500e+00, 1.4171400e+01, 5.3802670e+00, 1.2643590e+01,
 8.2326500e-03, 2.4898170e-02, 9.1603370e-03, 2.9838080e-02, 6.5837140e-01, 2.6048700e+00, 1.0386090e+00, 3.0289450e+00,
 1.4820230e-02, 6.7946610e-01, 2.7180970e-01, 1.1280750e+00, 9.5596520e-01, 3.5556350e+00, 2.0684000e+00, 3.4213400e+00,
 1.5713980e+00, 4.2795340e+00, 1.2406480e+00, 5.1217730e+00, 3.7641630e+00, 1.3411150e+01, 4.2134750e+00, 1.5573710e+01,
 1.5135990e-01, 6.2489370e+00, 1.9697510e+00, 1.0360890e+01, 5.3527620e+00, 1.7928150e+01, 8.2179020e+00, 1.7228010e+01,
 5.1301350e-03, 1.2881740e-02, 3.3192700e-03, 1.4555940e-02, 7.8710980e-03, 2.5856420e-02, 7.2203550e-03, 2.8348900e-02,
 3.6041060e-04, 1.3719180e-02, 3.8437000e-03, 2.1476370e-02, 1.1878960e-02, 3.6683560e-02, 1.4945580e-02, 3.3282270e-02,
 5.1200960e-01, 1.5638580e+00, 2.9276240e-01, 1.6060400e+00, 1.0897950e+00, 4.3546300e+00, 8.8346940e-01, 4.3392270e+00,
 4.9082970e-02, 2.2726630e+00, 4.6260060e-01, 3.2334110e+00, 2.4745130e+00, 9.2951440e+00, 2.7513610e+00, 7.6646240e+00,
 3.8489780e-03, 1.3531350e-02, 3.8813720e-03, 1.4987240e-02, 2.2264340e-01, 1.0239830e+00, 3.1831650e-01, 1.1004620e+00,
 7.4624190e-03, 3.9770430e-01, 1.2403880e-01, 6.1024980e-01, 4.2720360e-01, 1.8470470e+00, 8.3771310e-01, 1.6426080e+00,
 7.2170890e-01, 2.2847590e+00, 5.1640760e-01, 2.5272090e+00, 1.2504820e+00, 5.1789670e+00, 1.2685790e+00, 5.5583520e+00,
 7.4869620e-02, 3.5930970e+00, 8.8302770e-01, 5.5060060e+00, 2.3498540e+00, 9.1488490e+00, 3.2695810e+00, 8.1253680e+00,
 6.0050770e-01, 1.1984200e+00, 4.6551480e-01, 1.6386470e+00, 1.2401700e+00, 3.2378660e+00, 1.3630310e+00, 4.2957340e+00,
 3.7492520e-02, 1.1342790e+00, 4.7906850e-01, 2.1486380e+00, 1.5658820e+00, 3.8432320e+00, 2.3604490e+00, 4.2193810e+00,
 9.8028580e-01, 2.3796680e+00, 6.7156960e-01, 2.9572370e+00, 2.8085080e+00, 8.9192150e+00, 2.7278680e+00, 1.0754700e+01,
 8.3514660e-02, 3.0733460e+00, 9.4305970e-01, 5.2911250e+00, 5.3352540e+00, 1.5928180e+01, 7.1074540e+00, 1.5893210e+01,
 1.9001180e-02, 5.3091000e-02, 2.2957340e-02, 7.1156060e-02, 1.4794530e+00, 5.4079010e+00, 2.5342620e+00, 7.0326950e+00,
 3.2739500e-02, 1.3867470e+00, 6.5200540e-01, 2.5748700e+00, 2.3749850e+00, 8.1610940e+00, 5.5798480e+00, 8.7824380e+00,
 1.6463990e+00, 4.1424570e+00, 1.4114540e+00, 5.5445920e+00, 3.8397840e+00, 1.2639130e+01, 4.6671090e+00, 1.6414610e+01,
 1.5178750e-01, 5.7895380e+00, 2.1448940e+00, 1.0735500e+01, 6.0367730e+00, 1.8679920e+01, 1.0063690e+01, 2.0075310e+01,
 2.4579220e-03, 4.3932490e-03, 2.0627090e-03, 7.0928970e-03, 3.9344960e-03, 9.2001330e-03, 4.6813220e-03, 1.4412320e-02,
 1.0804390e-04, 2.9275410e-03, 1.4945430e-03, 6.5479840e-03, 3.8945760e-03, 8.5610140e-03, 6.3555160e-03, 1.1097850e-02,
 4.2017760e-03, 9.1353260e-03, 3.1162070e-03, 1.3404640e-02, 9.3306970e-03, 2.6539490e-02, 9.8110830e-03, 3.7785540e-02,
 2.5202810e-04, 8.3066360e-03, 3.0809210e-03, 1.6885860e-02, 1.3895910e-02, 3.7155690e-02, 2.0040150e-02, 4.3775600e-02,
 4.9394340e-05, 1.2360750e-04, 6.4606050e-05, 1.9561280e-04, 2.9809590e-03, 9.7591260e-03, 5.5279160e-03, 1.4985300e-02,
 5.9920400e-05, 2.2731460e-03, 1.2918410e-03, 4.9836400e-03, 3.7515350e-03, 1.1545800e-02, 9.5416970e-03, 1.4670740e-02,
 6.8457080e-03, 1.5426540e-02, 6.3533830e-03, 2.4380440e-02, 1.2375090e-02, 3.6482600e-02, 1.6283380e-02, 5.5944930e-02,
 4.4435010e-04, 1.5179610e-02, 6.7975150e-03, 3.3235360e-02, 1.5252450e-02, 4.2270480e-02, 2.7526240e-02, 5.3639620e-02,
 2.0864020e-01, 3.0630830e-01, 1.4732010e-01, 4.7525210e-01, 3.8336940e-01, 7.3631830e-01, 3.8378770e-01, 1.1084930e+00,
 1.3029970e-02, 2.8999410e-01, 1.5165110e-01, 6.2333460e-01, 3.4181240e-01, 6.1715740e-01, 4.6932370e-01, 7.6884160e-01,
 5.9761740e-01, 1.0672290e+00, 3.7291580e-01, 1.5049290e+00, 1.5233610e+00, 3.5589710e+00, 1.3477210e+00, 4.8695070e+00,
 5.0927520e-02, 1.3787060e+00, 5.2381540e-01, 2.6933770e+00, 2.0435020e+00, 4.4880380e+00, 2.4796090e+00, 5.0814860e+00,
 6.2645900e-03, 1.2876670e-02, 6.8941820e-03, 1.9583180e-02, 4.3398020e-01, 1.1669920e+00, 6.7712610e-01, 1.7220660e+00,
 1.0797010e-02, 3.3643350e-01, 1.9585370e-01, 7.0883630e-01, 4.9195140e-01, 1.2435990e+00, 1.0527690e+00, 1.5185730e+00,
 1.1445170e+00, 2.1184370e+00, 8.9372300e-01, 3.2174800e+00, 2.3749290e+00, 5.7508390e+00, 2.6293040e+00, 8.4748800e+00,
 1.0554610e-01, 2.9615610e+00, 1.3585050e+00, 6.2314320e+00, 2.6365810e+00, 6.0018040e+00, 4.0035250e+00, 7.3191020e+00,
 3.2025020e-03, 5.4653520e-03, 2.0493760e-03, 7.8371910e-03, 4.2563960e-03, 9.5029420e-03, 3.8617460e-03, 1.3222160e-02,
 2.1540390e-04, 5.5727210e-03, 2.2720820e-03, 1.1070740e-02, 5.0149460e-03, 1.0525490e-02, 6.2404950e-03, 1.2118820e-02,
 3.2361280e-01, 6.7178120e-01, 1.8301270e-01, 8.7551450e-01, 5.9667590e-01, 1.6204210e+00, 4.7841360e-01, 2.0491110e+00,
 2.9701190e-02, 9.3467580e-01, 2.7686470e-01, 1.6875760e+00, 1.0577050e+00, 2.7003120e+00, 1.1631630e+00, 2.8256940e+00,
 2.6866570e-03, 6.4193490e-03, 2.6796030e-03, 9.0229350e-03, 1.3462410e-01, 4.2081260e-01, 1.9036640e-01, 5.7391500e-01,
 4.9870290e-03, 1.8063650e-01, 8.1985740e-02, 3.5174620e-01, 2.0166420e-01, 5.9259070e-01, 3.9111790e-01, 6.6878640e-01,
 4.8218310e-01, 1.0374640e+00, 3.4124070e-01, 1.4562990e+00, 7.2372490e-01, 2.0371460e+00, 7.2615930e-01, 2.7746070e+00,
 4.7890680e-02, 1.5620580e+00, 5.5864770e-01, 3.0376760e+00, 1.0617400e+00, 2.8094840e+00, 1.4611250e+00, 3.1665010e+00,
 3.7636640e-01, 5.1048640e-01, 2.8856530e-01, 8.8580280e-01, 6.7331700e-01, 1.1947590e+00, 7.3191790e-01, 2.0115700e+00,
 2.2497400e-02, 4.6258400e-01, 2.8431760e-01, 1.1120140e+00, 6.6371020e-01, 1.1071310e+00, 9.8953780e-01, 1.5425090e+00,
 6.2205950e-01, 1.0263100e+00, 4.2149130e-01, 1.6185450e+00, 1.5438350e+00, 3.3322300e+00, 1.4830880e+00, 5.0989770e+00,
 5.0738470e-02, 1.2690220e+00, 5.6667260e-01, 2.7725680e+00, 2.2896100e+00, 4.6457470e+00, 3.0167470e+00, 5.8827090e+00,
 1.3316160e-02, 2.5287290e-02, 1.5912500e-02, 4.3010040e-02, 8.9814330e-01, 2.2312910e+00, 1.5216490e+00, 3.6823560e+00,
 2.1966760e-02, 6.3237440e-01, 4.3267670e-01, 1.4900770e+00, 1.1256060e+00, 2.6287970e+00, 2.6155700e+00, 3.5900470e+00,
 1.1043750e+00, 1.8885240e+00, 9.3641150e-01, 3.2078240e+00, 2.2311790e+00, 4.9914600e+00, 2.6822170e+00, 8.2265470e+00,
 9.7479440e-02, 2.5269920e+00, 1.3623890e+00, 5.9464640e+00, 2.7385050e+00, 5.7592600e+00, 4.5152750e+00, 7.8547140e+00,
 3.9179700e-01, 7.3246830e-01, 3.2012890e-01, 1.1023060e+00, 7.4381420e-01, 1.8191960e+00, 8.6166350e-01, 2.6564090e+00,
 2.0228690e-02, 5.7329810e-01, 2.7243930e-01, 1.1952560e+00, 6.6590980e-01, 1.5310540e+00, 1.0580340e+00, 1.8500330e+00,
 6.2892880e-01, 1.4302190e+00, 4.5413880e-01, 1.9561820e+00, 1.6563990e+00, 4.9278040e+00, 1.6957490e+00, 6.5397650e+00,
 4.4309020e-02, 1.5274900e+00, 5.2737250e-01, 2.8943550e+00, 2.2310930e+00, 6.2397340e+00, 3.1327480e+00, 6.8524910e+00,
 6.0766680e-03, 1.5905350e-02, 7.7384730e-03, 2.3462330e-02, 4.3493730e-01, 1.4893320e+00, 7.8528250e-01, 2.1316780e+00,
 8.6583990e-03, 3.4355820e-01, 1.8174630e-01, 7.0209390e-01, 4.9506190e-01, 1.5936190e+00, 1.2259420e+00, 1.8875050e+00,
 9.3191870e-01, 2.1965360e+00, 8.4209000e-01, 3.2358380e+00, 1.9979760e+00, 6.1608100e+00, 2.5596480e+00, 8.8061970e+00,
 7.1049250e-02, 2.5386610e+00, 1.0582250e+00, 5.1810790e+00, 2.2272110e+00, 6.4560810e+00, 3.9134750e+00, 7.6364800e+00,
 7.6899940e-01, 1.1808560e+00, 5.2866900e-01, 1.7078030e+00, 1.6758220e+00, 3.3665570e+00, 1.6334100e+00, 4.7242070e+00,
 5.6408680e-02, 1.3131120e+00, 6.3920760e-01, 2.6309310e+00, 1.3513820e+00, 2.5520910e+00, 1.8065770e+00, 2.9635530e+00,
 2.0683630e+00, 3.8634120e+00, 1.2566320e+00, 5.0781460e+00, 6.2530060e+00, 1.5279900e+01, 5.3861650e+00, 1.9487520e+01,
 2.0702880e-01, 5.8621900e+00, 2.0732430e+00, 1.0674830e+01, 7.5864880e+00, 1.7427390e+01, 8.9627790e+00, 1.8392560e+01,
 1.7820340e-02, 3.8312170e-02, 1.9094130e-02, 5.4311550e-02, 1.4641170e+00, 4.1179750e+00, 2.2241760e+00, 5.6642350e+00,
 3.6074580e-02, 1.1757290e+00, 6.3712320e-01, 2.3090290e+00, 1.5010930e+00, 3.9689520e+00, 3.1276080e+00, 4.5175920e+00,
 3.6026060e+00, 6.9746140e+00, 2.7389960e+00, 9.8740690e+00, 8.8659980e+00, 2.2455270e+01, 9.5567820e+00, 3.0845820e+01,
 3.9022180e-01, 1.1452490e+01, 4.8901740e+00, 2.2461710e+01, 8.9022140e+00, 2.1195740e+01, 1.3161130e+01, 2.4093520e+01,
 1.7278300e-02, 3.0841790e-02, 1.0765320e-02, 4.1224700e-02, 2.7235530e-02, 6.3600700e-02, 2.4058650e-02, 8.2486300e-02,
 1.3650220e-03, 3.6937150e-02, 1.4018570e-02, 6.8398750e-02, 2.9022840e-02, 6.3712690e-02, 3.5163050e-02, 6.8378500e-02,
 1.6395050e+00, 3.5597930e+00, 9.0273860e-01, 4.3245000e+00, 3.5851540e+00, 1.0183740e+01, 2.7987670e+00, 1.2003850e+01,
 1.7674020e-01, 5.8174490e+00, 1.6040690e+00, 9.7906290e+00, 5.7479590e+00, 1.5348750e+01, 6.1543710e+00, 1.4971310e+01,
 1.1187140e-02, 2.7958100e-02, 1.0863530e-02, 3.6630280e-02, 6.6483190e-01, 2.1736410e+00, 9.1532080e-01, 2.7632640e+00,
 2.4390640e-02, 9.2405310e-01, 3.9040330e-01, 1.6772440e+00, 9.0073670e-01, 2.7684320e+00, 1.7008670e+00, 2.9123400e+00,
 2.2217240e+00, 4.9999000e+00, 1.5308500e+00, 6.5420580e+00, 3.9548860e+00, 1.1643740e+01, 3.8635470e+00, 1.4782490e+01,
 2.5918130e-01, 8.8421920e+00, 2.9436390e+00, 1.6028020e+01, 5.2475710e+00, 1.4523690e+01, 7.0310730e+00, 1.5258280e+01,
 1.0989340e+00, 1.5590320e+00, 8.2034920e-01, 2.5216430e+00, 2.3316470e+00, 4.3274640e+00, 2.4677400e+00, 6.7914740e+00,
 7.7155650e-02, 1.6593430e+00, 9.4936440e-01, 3.7181890e+00, 2.0787470e+00, 3.6268710e+00, 3.0175140e+00, 4.7101680e+00,
 1.7055650e+00, 2.9432350e+00, 1.1251720e+00, 4.3266010e+00, 5.0201840e+00, 1.1333490e+01, 4.6954760e+00, 1.6165440e+01,
 1.6339860e-01, 4.2745470e+00, 1.7767940e+00, 8.7052000e+00, 6.7337980e+00, 1.4291050e+01, 8.6383580e+00, 1.6867920e+01,
 3.0007870e-02, 5.9603050e-02, 3.4913090e-02, 9.4495610e-02, 2.4004030e+00, 6.2374160e+00, 3.9595580e+00, 9.5951090e+00,
 5.8142900e-02, 1.7507130e+00, 1.1150340e+00, 3.8452540e+00, 2.7208510e+00, 6.6463830e+00, 6.1557150e+00, 8.4606590e+00,
 2.7538750e+00, 4.9256110e+00, 2.2734640e+00, 7.7987270e+00, 6.5984860e+00, 1.5440010e+01, 7.7232050e+00, 2.3719910e+01,
 2.8550590e-01, 7.7413370e+00, 3.8850540e+00, 1.6980350e+01, 7.3249260e+00, 1.6112630e+01, 1.1758930e+01, 2.0483570e+01,
 7.6529200e-04, 1.6133530e-03, 4.0998200e-04, 2.1552370e-03, 1.3363180e-03, 3.6855260e-03, 1.0149790e-03, 4.7771310e-03,
 2.9490340e-05, 9.4246890e-04, 2.6040880e-04, 1.7442130e-03, 1.2743080e-03, 3.3038770e-03, 1.3274940e-03, 3.5437680e-03,
 9.9753840e-04, 2.5580270e-03, 4.7227040e-04, 3.1057330e-03, 2.4164210e-03, 8.1065390e-03, 1.6219710e-03, 9.5498460e-03,
 5.2452510e-05, 2.0390450e-03, 4.0932240e-04, 3.4296730e-03, 3.4668800e-03, 1.0933560e-02, 3.1916880e-03, 1.0658500e-02,
 1.4108170e-05, 4.1641160e-05, 1.1779710e-05, 5.4525930e-05, 9.2877670e-04, 3.5863340e-03, 1.0994730e-03, 4.5565170e-03,
 1.5003370e-05, 6.7131440e-04, 2.0648610e-04, 1.2177920e-03, 1.1260500e-03, 4.0874940e-03, 1.8282770e-03, 4.2974720e-03,
 1.9484570e-03, 5.1787580e-03, 1.1543710e-03, 6.7721470e-03, 3.8422230e-03, 1.3359940e-02, 3.2273530e-03, 1.6951470e-02,
 1.1087110e-04, 4.4672280e-03, 1.0827070e-03, 8.0929300e-03, 4.5621260e-03, 1.4912460e-02, 5.2558420e-03, 1.5657620e-02,
 1.3898720e-03, 2.4066900e-03, 6.2647920e-04, 3.0896780e-03, 2.7858400e-03, 6.3108630e-03, 1.7803170e-03, 7.8611100e-03,
 7.6092310e-05, 1.9974280e-03, 5.6534130e-04, 3.5524750e-03, 2.3928740e-03, 5.0958010e-03, 2.0973560e-03, 5.2526840e-03,
 3.0355530e-03, 6.3937620e-03, 1.2091860e-03, 7.4600680e-03, 8.4407150e-03, 2.3258690e-02, 4.7669870e-03, 2.6331380e-02,
 2.2677110e-04, 7.2408800e-03, 1.4889530e-03, 1.1704280e-02, 1.0907990e-02, 2.8256000e-02, 8.4492960e-03, 2.6471140e-02,
 3.8282830e-05, 9.2810960e-05, 2.6894400e-05, 1.1679030e-04, 2.8929650e-03, 9.1754140e-03, 2.8814460e-03, 1.1203030e-02,
 5.7840940e-05, 2.1257670e-03, 6.6977870e-04, 3.7058700e-03, 3.1592840e-03, 9.4195740e-03, 4.3158580e-03, 9.5173200e-03,
 6.9696740e-03, 1.5215640e-02, 3.4742500e-03, 1.9121350e-02, 1.5776210e-02, 4.5057580e-02, 1.1149640e-02, 5.4941190e-02,
 5.6344720e-04, 1.8647300e-02, 4.6295620e-03, 3.2464680e-02, 1.6872780e-02, 4.5301420e-02, 1.6355200e-02, 4.5710470e-02,
 2.8035750e-05, 5.6431990e-05, 1.1452810e-05, 6.6956920e-05, 4.0646820e-05, 1.0703530e-04, 2.3541600e-05, 1.2322510e-04,
 1.6530920e-06, 5.0442330e-05, 1.1131020e-05, 8.2914820e-05, 4.6136450e-05, 1.1421010e-04, 3.6649210e-05, 1.0880540e-04,
 2.1601610e-03, 5.2889890e-03, 7.7984680e-04, 5.7034290e-03, 4.3447090e-03, 1.3916650e-02, 2.2237880e-03, 1.4561290e-02,
 1.7380200e-04, 6.4509910e-03, 1.0342280e-03, 9.6373290e-03, 7.4195920e-03, 2.2341580e-02, 5.2086350e-03, 1.9344300e-02,
 2.1575930e-05, 6.0804070e-05, 1.3737110e-05, 7.0715950e-05, 1.1793470e-03, 4.3480270e-03, 1.0645770e-03, 4.9065810e-03,
 3.5109100e-05, 1.4999190e-03, 3.6845450e-04, 2.4166820e-03, 1.7019280e-03, 5.8986380e-03, 2.1071130e-03, 5.5082310e-03,
 3.8587640e-03, 9.7925080e-03, 1.7432710e-03, 1.1373630e-02, 6.3178820e-03, 2.0975130e-02, 4.0466680e-03, 2.3638060e-02,
 3.3597560e-04, 1.2925240e-02, 2.5018570e-03, 2.0797480e-02, 8.9291350e-03, 2.7867780e-02, 7.8441630e-03, 2.5988630e-02,
 2.9106080e-03, 4.6563060e-03, 1.4245730e-03, 6.6853220e-03, 5.6800790e-03, 1.1887740e-02, 3.9415290e-03, 1.6560830e-02,
 1.5251970e-04, 3.6988660e-03, 1.2304530e-03, 7.3572630e-03, 5.3939460e-03, 1.0612350e-02, 5.1336730e-03, 1.2233990e-02,
 3.6681110e-03, 7.1379530e-03, 1.5865980e-03, 9.3142450e-03, 9.9305480e-03, 2.5280850e-02, 6.0898570e-03, 3.2008680e-02,
 2.6228200e-04, 7.7372160e-03, 1.8699550e-03, 1.3987030e-02, 1.4188200e-02, 3.3955150e-02, 1.1933620e-02, 3.5575860e-02,
 9.4468380e-05, 2.1158950e-04, 7.2063190e-05, 2.9777590e-04, 6.9504810e-03, 2.0366200e-02, 7.5171180e-03, 2.7810400e-02,
 1.3661360e-04, 4.6385980e-03, 1.7177470e-03, 9.0437590e-03, 8.3916810e-03, 2.3115540e-02, 1.2447920e-02, 2.6120110e-02,
 7.8073410e-03, 1.5746840e-02, 4.2259160e-03, 2.2131420e-02, 1.7206110e-02, 4.5400460e-02, 1.3204130e-02, 6.1912470e-02,
 6.0411550e-04, 1.8471210e-02, 5.3898400e-03, 3.5964840e-02, 2.0344880e-02, 5.0465290e-02, 2.1413790e-02, 5.6948760e-02,
 6.5189640e-02, 1.7144040e-01, 5.5313370e-02, 2.1810950e-01, 9.3436120e-02, 3.2146730e-01, 1.1240250e-01, 3.9682600e-01,
 2.7254360e-03, 1.0865650e-01, 3.8117620e-02, 1.9150670e-01, 1.3464770e-01, 4.3549280e-01, 2.2216270e-01, 4.4485460e-01,
 1.2936590e-01, 4.1383580e-01, 9.7005180e-02, 4.7850070e-01, 2.5722690e-01, 1.0764940e+00, 2.7346440e-01, 1.2077260e+00,
 7.3800850e-03, 3.5789410e-01, 9.1216740e-02, 5.7329210e-01, 5.5770210e-01, 2.1941060e+00, 8.1320100e-01, 2.0369860e+00,
 1.6465530e-03, 6.0626220e-03, 2.1774760e-03, 7.5602540e-03, 8.8975380e-02, 4.2858980e-01, 1.6682340e-01, 5.1858480e-01,
 1.8997600e-03, 1.0603970e-01, 4.1410890e-02, 1.8319400e-01, 1.6301820e-01, 7.3818960e-01, 4.1921250e-01, 7.3912790e-01,
 1.7655660e-01, 5.8539800e-01, 1.6567320e-01, 7.2903380e-01, 2.8577820e-01, 1.2396060e+00, 3.8019540e-01, 1.4978970e+00,
 1.0899740e-02, 5.4785860e-01, 1.6858650e-01, 9.4521770e-01, 5.1278290e-01, 2.0909710e+00, 9.3566960e-01, 2.0908370e+00,
 1.6618260e-01, 3.5897420e-01, 1.1864000e-01, 4.3888630e-01, 2.7341370e-01, 7.7265450e-01, 2.7674220e-01, 9.1659220e-01,
 9.8708870e-03, 3.2323540e-01, 1.1615560e-01, 5.4748810e-01, 3.5489810e-01, 9.4282000e-01, 4.9268580e-01, 9.2553590e-01,
 5.5256990e-01, 1.4519060e+00, 3.4862330e-01, 1.6133200e+00, 1.2611950e+00, 4.3353160e+00, 1.1281340e+00, 4.6741730e+00,
 4.4785970e-02, 1.7839320e+00, 4.6574610e-01, 2.7461680e+00, 2.4630170e+00, 7.9591360e+00, 3.0217400e+00, 7.1010670e+00,
 6.2714550e-03, 1.8966890e-02, 6.9781460e-03, 2.2730000e-02, 3.8901010e-01, 1.5391320e+00, 6.1368020e-01, 1.7897050e+00,
 1.0280270e-02, 4.7132150e-01, 1.8854470e-01, 7.8250570e-01, 6.4198700e-01, 2.3878190e+00, 1.3890520e+00, 2.2976320e+00,
 8.8647150e-01, 2.4142100e+00, 6.9988590e-01, 2.8893420e+00, 1.6470560e+00, 5.8682160e+00, 1.8436580e+00, 6.8144690e+00,
 7.7751770e-02, 3.2100050e+00, 1.0118380e+00, 5.3222640e+00, 2.6620250e+00, 8.9159950e+00, 4.0869110e+00, 8.5678010e+00,
 2.8523440e-03, 7.1622200e-03, 1.8455070e-03, 8.0930730e-03, 3.3944530e-03, 1.1150720e-02, 3.1138170e-03, 1.2225610e-02,
 1.8247000e-04, 6.9457990e-03, 1.9460030e-03, 1.0873140e-02, 5.8224690e-03, 1.7980440e-02, 7.3255730e-03, 1.6313300e-02,
 3.3459140e-01, 1.0219600e+00, 1.9131630e-01, 1.0495250e+00, 5.5238610e-01, 2.2072380e+00, 4.4780550e-01, 2.1994310e+00,
 2.9207090e-02, 1.3523600e+00, 2.7527300e-01, 1.9240590e+00, 1.4255480e+00, 5.3548630e+00, 1.5850380e+00, 4.4155320e+00,
 3.0075510e-03, 1.0573250e-02, 3.0328630e-03, 1.1710870e-02, 1.3493940e-01, 6.2061420e-01, 1.9292480e-01, 6.6696660e-01,
 5.3096760e-03, 2.8297540e-01, 8.8256360e-02, 4.3420620e-01, 2.9427810e-01, 1.2723330e+00, 5.7705660e-01, 1.1315060e+00,
 4.1761840e-01, 1.3220810e+00, 2.9882040e-01, 1.4623750e+00, 5.6125010e-01, 2.3244600e+00, 5.6937240e-01, 2.4947380e+00,
 3.9449730e-02, 1.8932470e+00, 4.6527820e-01, 2.9011830e+00, 1.1987100e+00, 4.6670190e+00, 1.6678820e+00, 4.1449200e+00,
 3.5555710e-01, 7.0957720e-01, 2.7562860e-01, 9.7023310e-01, 5.6955200e-01, 1.4870000e+00, 6.2597600e-01, 1.9728290e+00,
 2.0214180e-02, 6.1154930e-01, 2.5829100e-01, 1.1584430e+00, 8.1734490e-01, 2.0060560e+00, 1.2320860e+00, 2.2023940e+00,
 6.8219240e-01, 1.6560390e+00, 4.6735320e-01, 2.0579760e+00, 1.5159720e+00, 4.8144000e+00, 1.4724440e+00, 5.8051550e+00,
 5.2922180e-02, 1.9475400e+00, 5.9760500e-01, 3.3529190e+00, 3.2731420e+00, 9.7718300e+00, 4.3603750e+00, 9.7503740e+00,
 1.5811230e-02, 4.4177990e-02, 1.9103220e-02, 5.9210270e-02, 9.5487720e-01, 3.4903990e+00, 1.6356790e+00, 4.5390840e+00,
 2.4807210e-02, 1.0507590e+00, 4.9403430e-01, 1.9510180e+00, 1.7422140e+00, 5.9867210e+00, 4.0932010e+00, 6.4425200e+00,
 1.0145430e+00, 2.5526610e+00, 8.6976520e-01, 3.4166840e+00, 1.8352840e+00, 6.0410650e+00, 2.2307170e+00, 7.8456150e+00,
 8.5171050e-02, 3.2486270e+00, 1.2035440e+00, 6.0239080e+00, 3.2794090e+00, 1.0147660e+01, 5.4669840e+00, 1.0905680e+01,
 7.6983770e-04, 1.3759950e-03, 6.4605440e-04, 2.2215430e-03, 9.5583180e-04, 2.2350460e-03, 1.1372630e-03, 3.5012760e-03,
 3.0814280e-05, 8.3493910e-04, 4.2624590e-04, 1.8674950e-03, 1.0753430e-03, 2.3638060e-03, 1.7548390e-03, 3.0642580e-03,
 1.5467760e-03, 3.3629360e-03, 1.1471520e-03, 4.9345730e-03, 2.6642190e-03, 7.5778910e-03, 2.8013850e-03, 1.0789010e-02,
 8.4482040e-05, 2.7844570e-03, 1.0327520e-03, 5.6602870e-03, 4.5095900e-03, 1.2058000e-02, 6.5035580e-03, 1.4206340e-02,
 2.1742150e-05, 5.4408940e-05, 2.8437970e-05, 8.6103870e-05, 1.0177540e-03, 3.3319440e-03, 1.8873310e-03, 5.1162540e-03,
 2.4017120e-05, 9.1111590e-04, 5.1779180e-04, 1.9975280e-03, 1.4557610e-03, 4.4802780e-03, 3.7025980e-03, 5.6928930e-03,
 2.2314840e-03, 5.0285650e-03, 2.0710020e-03, 7.9472520e-03, 3.1288520e-03, 9.2240700e-03, 4.1170030e-03, 1.4144820e-02,
 1.3189290e-04, 4.5056440e-03, 2.0176530e-03, 9.8649890e-03, 4.3829910e-03, 1.2146980e-02, 7.9100270e-03, 1.5414050e-02,
 7.4130840e-02, 1.0883280e-01, 5.2343530e-02, 1.6885930e-01, 1.0565250e-01, 2.0292140e-01, 1.0576770e-01, 3.0548870e-01,
 4.2156550e-03, 9.3823340e-02, 4.9064490e-02, 2.0167080e-01, 1.0706420e-01, 1.9330920e-01, 1.4700400e-01, 2.4082050e-01,
 2.4956730e-01, 4.4567870e-01, 1.5573100e-01, 6.2846390e-01, 4.9343350e-01, 1.1527900e+00, 4.3654160e-01, 1.5772870e+00,
 1.9365900e-02, 5.2427240e-01, 1.9918810e-01, 1.0241940e+00, 7.5230680e-01, 1.6522530e+00, 9.1285770e-01, 1.8707280e+00,
 3.1281530e-03, 6.4298180e-03, 3.4425330e-03, 9.7786420e-03, 1.6808410e-01, 4.5198560e-01, 2.6225640e-01, 6.6697030e-01,
 4.9092990e-03, 1.5297320e-01, 8.9052850e-02, 3.2230130e-01, 2.1655740e-01, 5.4743320e-01, 4.6342960e-01, 6.6847730e-01,
 4.2322120e-01, 7.8335900e-01, 3.3048240e-01, 1.1897650e+00, 6.8117260e-01, 1.6494450e+00, 7.5413220e-01, 2.4307500e+00,
 3.5539260e-02, 9.9721040e-01, 4.5743290e-01, 2.0982350e+00, 8.5949240e-01, 1.9565130e+00, 1.3050990e+00, 2.3859360e+00,
 1.1671570e-03, 1.9918560e-03, 7.4689820e-04, 2.8562770e-03, 1.2032150e-03, 2.6863290e-03, 1.0916530e-03, 3.7376920e-03,
 7.1484890e-05, 1.8493880e-03, 7.5402300e-04, 3.6739830e-03, 1.6112450e-03, 3.3817210e-03, 2.0050000e-03, 3.8936390e-03,
 1.3862100e-01, 2.8776050e-01, 7.8394310e-02, 3.7503050e-01, 1.9824540e-01, 5.3838450e-01, 1.5895280e-01, 6.8081650e-01,
 1.1585050e-02, 3.6457350e-01, 1.0799200e-01, 6.5824500e-01, 3.9941410e-01, 1.0197010e+00, 4.3923760e-01, 1.0670480e+00,
 1.3760890e-03, 3.2879500e-03, 1.3724760e-03, 4.6214900e-03, 5.3483300e-02, 1.6718000e-01, 7.5628570e-02, 2.2800430e-01,
 2.3259320e-03, 8.4248200e-02, 3.8237840e-02, 1.6405310e-01, 9.1058110e-02, 2.6757440e-01, 1.7660280e-01, 3.0197930e-01,
 1.8289260e-01, 3.9351160e-01, 1.2943300e-01, 5.5237610e-01, 2.1292130e-01, 5.9933230e-01, 2.1363750e-01, 8.1629480e-01,
 1.6540780e-02, 5.3951350e-01, 1.9294930e-01, 1.0491720e+00, 3.5502410e-01, 9.3943420e-01, 4.8857060e-01, 1.0588130e+00,
 1.4607240e-01, 1.9812600e-01, 1.1199570e-01, 3.4379100e-01, 2.0269280e-01, 3.5966560e-01, 2.2033380e-01, 6.0555540e-01,
 7.9507950e-03, 1.6348160e-01, 1.0048050e-01, 3.9299650e-01, 2.2708660e-01, 3.7880180e-01, 3.3856760e-01, 5.2776510e-01,
 2.8376100e-01, 4.6816560e-01, 1.9226910e-01, 7.3832180e-01, 5.4623940e-01, 1.1790090e+00, 5.2474610e-01, 1.8041190e+00,
 2.1075560e-02, 5.2712160e-01, 2.3538240e-01, 1.1516590e+00, 9.2074200e-01, 1.8682370e+00, 1.2131520e+00, 2.3656680e+00,
 7.2632470e-03, 1.3792850e-02, 8.6794090e-03, 2.3459650e-02, 3.7997820e-01, 9.4399410e-01, 6.4376520e-01, 1.5578970e+00,
 1.0910350e-02, 3.1408480e-01, 2.1489980e-01, 7.4008440e-01, 5.4124480e-01, 1.2640500e+00, 1.2576900e+00, 1.7262650e+00,
 4.4608590e-01, 7.6282410e-01, 3.7824100e-01, 1.2957240e+00, 6.9903280e-01, 1.5638340e+00, 8.4034390e-01, 2.5773940e+00,
 3.5853840e-02, 9.2945110e-01, 5.0109940e-01, 2.1871640e+00, 9.7514880e-01, 2.0508040e+00, 1.6078350e+00, 2.7969700e+00,
 1.2533550e-01, 2.3431600e-01, 1.0240900e-01, 3.5262690e-01, 1.8456060e-01, 4.5139200e-01, 2.1380220e-01, 6.5912740e-01,
 5.8925290e-03, 1.6699920e-01, 7.9360360e-02, 3.4817280e-01, 1.8779500e-01, 4.3177660e-01, 2.9837910e-01, 5.2173290e-01,
 2.3647110e-01, 5.3774840e-01, 1.7075180e-01, 7.3550540e-01, 4.8306200e-01, 1.4371140e+00, 4.9453780e-01, 1.9072170e+00,
 1.5170140e-02, 5.2296860e-01, 1.8055720e-01, 9.9094430e-01, 7.3951980e-01, 2.0682270e+00, 1.0383830e+00, 2.2713320e+00,
 2.7319510e-03, 7.1507340e-03, 3.4790670e-03, 1.0548210e-02, 1.5166850e-01, 5.1935030e-01, 2.7383860e-01, 7.4334500e-01,
 3.5445890e-03, 1.4064640e-01, 7.4403590e-02, 2.8742430e-01, 1.9621060e-01, 6.3160780e-01, 4.8588440e-01, 7.4808550e-01,
 3.1026700e-01, 7.3130030e-01, 2.8036000e-01, 1.0773190e+00, 5.1595180e-01, 1.5909500e+00, 6.6099640e-01, 2.2740880e+00,
 2.1539610e-02, 7.6963200e-01, 3.2081640e-01, 1.5707190e+00, 6.5369410e-01, 1.8948820e+00, 1.1486180e+00, 2.2413330e+00,
 2.7906730e-01, 4.2852860e-01, 1.9185220e-01, 6.1975600e-01, 4.7170690e-01, 9.4761150e-01, 4.5976880e-01, 1.3297600e+00,
 1.8640160e-02, 4.3391590e-01, 2.1122520e-01, 8.6938740e-01, 4.3233130e-01, 8.1645970e-01, 5.7795650e-01, 9.4809390e-01,
 8.8221260e-01, 1.6478490e+00, 5.3598740e-01, 2.1659660e+00, 2.0686960e+00, 5.0550820e+00, 1.7819170e+00, 6.4470990e+00,
 8.0407760e-02, 2.2768120e+00, 8.0522530e-01, 4.1459900e+00, 2.8526130e+00, 6.5529120e+00, 3.3701150e+00, 6.9158280e+00,
 9.0885230e-03, 1.9539530e-02, 9.7381680e-03, 2.7699350e-02, 5.7918100e-01, 1.6290050e+00, 8.7984810e-01, 2.2406800e+00,
 1.6753270e-02, 5.4601590e-01, 2.9588410e-01, 1.0723280e+00, 6.7490190e-01, 1.7844680e+00, 1.4061940e+00, 2.0311400e+00,
 1.3606430e+00, 2.6341930e+00, 1.0344720e+00, 3.7292680e+00, 2.5972650e+00, 6.5781990e+00, 2.7996290e+00, 9.0361820e+00,
 1.3420220e-01, 3.9386570e+00, 1.6817930e+00, 7.7248670e+00, 2.9640190e+00, 7.0571870e+00, 4.3820390e+00, 8.0220120e+00,
 6.4316560e-03, 1.1480520e-02, 4.0072710e-03, 1.5345440e-02, 7.8635580e-03, 1.8363060e-02, 6.9463150e-03, 2.3815790e-02,
 4.6268180e-04, 1.2520050e-02, 4.7516720e-03, 2.3184140e-02, 9.5239570e-03, 2.0907560e-02, 1.1538890e-02, 2.2438670e-02,
 7.1729540e-01, 1.5574360e+00, 3.9495480e-01, 1.8920010e+00, 1.2166190e+00, 3.4558430e+00, 9.4975880e-01, 4.0734940e+00,
 7.0411180e-02, 2.3176010e+00, 6.3904160e-01, 3.9004690e+00, 2.2169430e+00, 5.9198950e+00, 2.3736930e+00, 5.7743200e+00,
 5.8524180e-03, 1.4625950e-02, 5.6831270e-03, 1.9162690e-02, 2.6976740e-01, 8.8199360e-01, 3.7140770e-01, 1.1212430e+00,
 1.1618780e-02, 4.4018380e-01, 1.8597330e-01, 7.9897550e-01, 4.1540300e-01, 1.2767490e+00, 7.8440850e-01, 1.3431170e+00,
 8.6070910e-01, 1.9369910e+00, 5.9306060e-01, 2.5344320e+00, 1.1883970e+00, 3.4988090e+00, 1.1609510e+00, 4.4419660e+00,
 9.1430440e-02, 3.1192280e+00, 1.0384170e+00, 5.6541460e+00, 1.7921740e+00, 4.9601950e+00, 2.4012840e+00, 5.2110770e+00,
 4.3562340e-01, 6.1800850e-01, 3.2519080e-01, 9.9959260e-01, 7.1690830e-01, 1.3305590e+00, 7.5875250e-01, 2.0881650e+00,
 2.7850180e-02, 5.9895800e-01, 3.4268360e-01, 1.3421210e+00, 7.2643470e-01, 1.2674390e+00, 1.0544940e+00, 1.6460060e+00,
 7.9464150e-01, 1.3712860e+00, 5.2422980e-01, 2.0158110e+00, 1.8141950e+00, 4.0956980e+00, 1.6968510e+00, 5.8418680e+00,
 6.9322160e-02, 1.8134840e+00, 7.5380800e-01, 3.6931970e+00, 2.7657860e+00, 5.8697900e+00, 3.5480500e+00, 6.9281950e+00,
 1.6717410e-02, 3.3204910e-02, 1.9450110e-02, 5.2643590e-02, 1.0372400e+00, 2.6952550e+00, 1.7109680e+00, 4.1461500e+00,
 2.9495200e-02, 8.8811590e-01, 5.6564330e-01, 1.9506520e+00, 1.3362700e+00, 3.2641850e+00, 3.0232070e+00, 4.1552160e+00,
 1.1361300e+00, 2.0320950e+00, 9.3793330e-01, 3.2174190e+00, 2.1114920e+00, 4.9407470e+00, 2.4713980e+00, 7.5902890e+00,
 1.0725560e-01, 2.9081760e+00, 1.4594920e+00, 6.3789800e+00, 2.6640520e+00, 5.8601110e+00, 4.2766840e+00, 7.4498100e+00,
 1.8876430e-01, 3.9794410e-01, 1.0112480e-01, 5.3160340e-01, 2.7801670e-01, 7.6676160e-01, 2.1116310e-01, 9.9386650e-01,
 6.4903040e-03, 2.0742070e-01, 5.7311380e-02, 3.8387050e-01, 2.9125550e-01, 7.5513330e-01, 3.0341180e-01, 8.0996260e-01,
 2.1421820e-01, 5.4932840e-01, 1.0141860e-01, 6.6694640e-01, 4.3769100e-01, 1.4683530e+00, 2.9379080e-01, 1.7297820e+00,
 1.0050450e-02, 3.9070240e-01, 7.8430460e-02, 6.5716120e-01, 6.8987840e-01, 2.1756820e+00, 6.3511780e-01, 2.1209480e+00,
 2.8088020e-03, 8.2903570e-03, 2.3452270e-03, 1.0855590e-02, 1.5596600e-01, 6.0223960e-01, 1.8463030e-01, 7.6515870e-01,
 2.6652110e-03, 1.1925280e-01, 3.6680350e-02, 2.1632960e-01, 2.0773750e-01, 7.5407480e-01, 3.3728680e-01, 7.9281230e-01,
 3.6013110e-01, 9.5718390e-01, 2.1336100e-01, 1.2516880e+00, 5.9899130e-01, 2.0827760e+00, 5.0313480e-01, 2.6426840e+00,
 1.8284390e-02, 7.3671630e-01, 1.7855550e-01, 1.3346520e+00, 7.8134710e-01, 2.5540300e+00, 9.0015860e-01, 2.6816520e+00,
 2.9157540e-01, 5.0488920e-01, 1.3142640e-01, 6.4817040e-01, 4.9294710e-01, 1.1166910e+00, 3.1502250e-01, 1.3910030e+00,
 1.4243250e-02, 3.7388620e-01, 1.0582280e-01, 6.6496600e-01, 4.6516050e-01, 9.9059330e-01, 4.0771360e-01, 1.0210900e+00,
 5.5443130e-01, 1.1677950e+00, 2.2085280e-01, 1.3625510e+00, 1.3003420e+00, 3.5831370e+00, 7.3438210e-01, 4.0565030e+00,
 3.6956430e-02, 1.1800320e+00, 2.4265170e-01, 1.9074230e+00, 1.8461270e+00, 4.7821990e+00, 1.4300050e+00, 4.4801200e+00,
 6.4824260e-03, 1.5715670e-02, 4.5540250e-03, 1.9776090e-02, 4.1318530e-01, 1.3104710e+00, 4.1154010e-01, 1.6000630e+00,
 8.7389910e-03, 3.2117490e-01, 1.0119460e-01, 5.5990730e-01, 4.9571180e-01, 1.4779910e+00, 6.7718560e-01, 1.4933280e+00,
 1.0956340e+00, 2.3919010e+00, 5.4615250e-01, 3.0058790e+00, 2.0918180e+00, 5.9743270e+00, 1.4783660e+00, 7.2848260e+00,
 7.9031190e-02, 2.6155400e+00, 6.4935960e-01, 4.5536170e+00, 2.4578000e+00, 6.5989020e+00, 2.3824060e+00, 6.6584870e+00,
 6.4020400e-03, 1.2886400e-02, 2.6152800e-03, 1.5289800e-02, 7.8289050e-03, 2.0615860e-02, 4.5343010e-03, 2.3734150e-02,
 3.3681820e-04, 1.0277650e-02, 2.2679510e-03, 1.6893930e-02, 9.7624180e-03, 2.4166730e-02, 7.7549300e-03, 2.3023100e-02,
 4.2946360e-01, 1.0515090e+00, 1.5504210e-01, 1.1339040e+00, 7.2856640e-01, 2.3336890e+00, 3.7290810e-01, 2.4417910e+00,
 3.0830990e-02, 1.1443510e+00, 1.8346320e-01, 1.7095800e+00, 1.3668700e+00, 4.1158650e+00, 9.5955780e-01, 3.5636920e+00,
 3.9767960e-03, 1.1207180e-02, 2.5319740e-03, 1.3034110e-02, 1.8334700e-01, 6.7596500e-01, 1.6550420e-01, 7.6280050e-01,
 5.7739890e-03, 2.4667440e-01, 6.0595450e-02, 3.9744380e-01, 2.9067790e-01, 1.0074480e+00, 3.5988070e-01, 9.4076880e-01,
 6.6028500e-01, 1.6756260e+00, 2.9829640e-01, 1.9461770e+00, 9.1184900e-01, 3.0273040e+00, 5.8404860e-01, 3.4116400e+00,
 5.1295990e-02, 1.9733960e+00, 3.8197780e-01, 3.1753110e+00, 1.4157920e+00, 4.4186800e+00, 1.2437610e+00, 4.1207240e+00,
 6.9692820e-01, 1.1149250e+00, 3.4110570e-01, 1.6007610e+00, 1.1471670e+00, 2.4008880e+00, 7.9604430e-01, 3.3446810e+00,
 3.2585360e-02, 7.9025150e-01, 2.6288250e-01, 1.5718570e+00, 1.1967900e+00, 2.3546310e+00, 1.1390410e+00, 2.7144350e+00,
 7.6468190e-01, 1.4880310e+00, 3.3075410e-01, 1.9417170e+00, 1.7461430e+00, 4.4452710e+00, 1.0708130e+00, 5.6282620e+00,
 4.8786450e-02, 1.4391810e+00, 3.4782580e-01, 2.6016950e+00, 2.7407690e+00, 6.5592020e+00, 2.3052470e+00, 6.8722780e+00,
 1.8257790e-02, 4.0893670e-02, 1.3927570e-02, 5.7550810e-02, 1.1330390e+00, 3.3200140e+00, 1.2254100e+00, 4.5335390e+00,
 2.3558530e-02, 7.9990980e-01, 2.9621940e-01, 1.5595640e+00, 1.5028580e+00, 4.1397380e+00, 2.2292840e+00, 4.6778240e+00,
 1.4008270e+00, 2.8253660e+00, 7.5823200e-01, 3.9709150e+00, 2.6039470e+00, 6.8708380e+00, 1.9982930e+00, 9.3697410e+00,
 9.6714960e-02, 2.9571210e+00, 8.6287840e-01, 5.7577360e+00, 3.3825430e+00, 8.3903670e+00, 3.5602600e+00, 9.4683110e+00,
 1.8408840e-01, 4.8412890e-01, 1.5619890e-01, 6.1591730e-01, 2.2255160e-01, 7.6568960e-01, 2.6772680e-01, 9.4518340e-01,
 6.8671450e-03, 2.7377630e-01, 9.6043050e-02, 4.8252980e-01, 3.5233340e-01, 1.1395560e+00, 5.8133430e-01, 1.1640530e+00,
 3.1805460e-01, 1.0174420e+00, 2.3849360e-01, 1.1764250e+00, 5.3341630e-01, 2.2323470e+00, 5.6708840e-01, 2.5044840e+00,
 1.6189580e-02, 7.8510670e-01, 2.0010080e-01, 1.2576220e+00, 1.2705480e+00, 4.9985780e+00, 1.8526220e+00, 4.6406280e+00,
 3.7530230e-03, 1.3818660e-02, 4.9631660e-03, 1.7232240e-02, 1.7105800e-01, 8.2397750e-01, 3.2072330e-01, 9.9699570e-01,
 3.8636390e-03, 2.1565830e-01, 8.4219430e-02, 3.7257090e-01, 3.4430890e-01, 1.5591230e+00, 8.8541440e-01, 1.5611040e+00,
 3.7360160e-01, 1.2387280e+00, 3.5057180e-01, 1.5426680e+00, 5.1006090e-01, 2.2124660e+00, 6.7857810e-01, 2.6734680e+00,
 2.0579430e-02, 1.0343930e+00, 3.1830240e-01, 1.7846330e+00, 1.0054610e+00, 4.0999620e+00, 1.8346540e+00, 4.0996990e+00,
 3.9913190e-01, 8.6217260e-01, 2.8494570e-01, 1.0541030e+00, 5.5388470e-01, 1.5652530e+00, 5.6062770e-01, 1.8568430e+00,
 2.1153370e-02, 6.9269540e-01, 2.4892200e-01, 1.1732700e+00, 7.8984450e-01, 2.0982960e+00, 1.0964980e+00, 2.0598290e+00,
 1.1554530e+00, 3.0360120e+00, 7.2898970e-01, 3.3735370e+00, 2.2244130e+00, 7.6463460e+00, 1.9897290e+00, 8.2439990e+00,
 8.3560180e-02, 3.3284010e+00, 8.6897370e-01, 5.1237090e+00, 4.7724280e+00, 1.5421900e+01, 5.8550300e+00, 1.3759280e+01,
 1.2157850e-02, 3.6769240e-02, 1.3527840e-02, 4.4064410e-02, 6.3608860e-01, 2.5167070e+00, 1.0034570e+00, 2.9264290e+00,
 1.7782200e-02, 8.1526380e-01, 3.2613340e-01, 1.3535320e+00, 1.1532450e+00, 4.2894030e+00, 2.4952500e+00, 4.1273940e+00,
 1.5954110e+00, 4.3449330e+00, 1.2596070e+00, 5.2000430e+00, 2.5002560e+00, 8.9080410e+00, 2.7987010e+00, 1.0344470e+01,
 1.2485630e-01, 5.1547310e+00, 1.6248420e+00, 8.5466660e+00, 4.4394280e+00, 1.4869100e+01, 6.8156940e+00, 1.4288420e+01,
 7.4569840e-03, 1.8724440e-02, 4.8247740e-03, 2.1158000e-02, 7.4851280e-03, 2.4588510e-02, 6.8662950e-03, 2.6958770e-02,
 4.2564270e-04, 1.6202270e-02, 4.5393860e-03, 2.5363460e-02, 1.4105070e-02, 4.3558050e-02, 1.7746380e-02, 3.9519360e-02,
 7.6157030e-01, 2.3261040e+00, 4.3545890e-01, 2.3888460e+00, 1.0604890e+00, 4.2375290e+00, 8.5971180e-01, 4.2225400e+00,
 5.9316560e-02, 2.7465030e+00, 5.5905090e-01, 3.9075630e+00, 3.0066590e+00, 1.1294070e+01, 3.3430430e+00, 9.3129080e+00,
 6.3464640e-03, 2.2311430e-02, 6.3998770e-03, 2.4712000e-02, 2.4017380e-01, 1.1046090e+00, 3.4338000e-01, 1.1871100e+00,
 9.9972200e-03, 5.3279470e-01, 1.6617180e-01, 8.1753660e-01, 5.7541840e-01, 2.4878640e+00, 1.1283510e+00, 2.2124980e+00,
 8.1812160e-01, 2.5899780e+00, 5.8539420e-01, 2.8648180e+00, 9.2739090e-01, 3.8408590e+00, 9.4081190e-01, 4.1222210e+00,
 6.8956410e-02, 3.3093140e+00, 8.1328610e-01, 5.0711410e+00, 2.1760020e+00, 8.4719770e+00, 3.0276830e+00, 7.5242180e+00,
 9.7469470e-01, 1.9451760e+00, 7.5558530e-01, 2.6597170e+00, 1.3169240e+00, 3.4382580e+00, 1.4473890e+00, 4.5615970e+00,
 4.9443340e-02, 1.4958330e+00, 6.3177280e-01, 2.8335210e+00, 2.0762120e+00, 5.0957630e+00, 3.1297320e+00, 5.5945010e+00,
 1.6281720e+00, 3.9524280e+00, 1.1154200e+00, 4.9117210e+00, 3.0517760e+00, 9.6917830e+00, 2.9641520e+00, 1.1686260e+01,
 1.1269990e-01, 4.1473650e+00, 1.2726240e+00, 7.1401740e+00, 7.2387760e+00, 2.1611070e+01, 9.6432650e+00, 2.1563610e+01,
 3.4985060e-02, 9.7751370e-02, 4.2269150e-02, 1.3101280e-01, 1.7821020e+00, 6.5141860e+00, 3.0526920e+00, 8.4713620e+00,
 4.8976450e-02, 2.0744960e+00, 9.7536330e-01, 3.8518600e+00, 3.5721140e+00, 1.2274760e+01, 8.3924140e+00, 1.3209290e+01,
 2.0840430e+00, 5.2435990e+00, 1.7866450e+00, 7.0184470e+00, 3.1798580e+00, 1.0466900e+01, 3.8649940e+00, 1.3593500e+01,
 1.5610640e-01, 5.9542710e+00, 2.2059240e+00, 1.1040960e+01, 6.2422150e+00, 1.9315630e+01, 1.0406170e+01, 2.0758510e+01,
 4.3693650e-03, 7.8097300e-03, 3.6668090e-03, 1.2608800e-02, 4.5758190e-03, 1.0699750e-02, 5.4443770e-03, 1.6761530e-02,
 1.5605000e-04, 4.2283060e-03, 2.1585980e-03, 9.4573850e-03, 5.6555250e-03, 1.2431910e-02, 9.2291890e-03, 1.6115780e-02,
 7.6432960e-03, 1.6617730e-02, 5.6685770e-03, 2.4383880e-02, 1.1104300e-02, 3.1584190e-02, 1.1676000e-02, 4.4967920e-02,
 3.7248600e-04, 1.2276830e-02, 4.5534600e-03, 2.4956520e-02, 2.0648910e-02, 5.5212270e-02, 2.9779080e-02, 6.5049260e-02,
 9.9604590e-05, 2.4925680e-04, 1.3027930e-04, 3.9445680e-04, 3.9326710e-03, 1.2874860e-02, 7.2927800e-03, 1.9769560e-02,
 9.8172560e-05, 3.7242840e-03, 2.1165290e-03, 8.1651110e-03, 6.1797890e-03, 1.9019040e-02, 1.5717750e-02, 2.4166670e-02,
 9.4905190e-03, 2.1386520e-02, 8.8079870e-03, 3.3799720e-02, 1.1224040e-02, 3.3089250e-02, 1.4768810e-02, 5.0741320e-02,
 5.0050690e-04, 1.7098000e-02, 7.6565830e-03, 3.7435630e-02, 1.7273240e-02, 4.7870860e-02, 3.1173180e-02, 6.0746300e-02,
 3.5785020e-01, 5.2536610e-01, 2.5267680e-01, 8.1513080e-01, 4.3018000e-01, 8.2622510e-01, 4.3064930e-01, 1.2438430e+00,
 1.8157660e-02, 4.0411560e-01, 2.1133040e-01, 8.6863590e-01, 4.7890970e-01, 8.6469260e-01, 6.5756440e-01, 1.0772160e+00,
 1.0488760e+00, 1.8730880e+00, 6.5450280e-01, 2.6412940e+00, 1.7491750e+00, 4.0865310e+00, 1.5474980e+00, 5.5913320e+00,
 7.2621730e-02, 1.9660110e+00, 7.4695120e-01, 3.8407070e+00, 2.9298030e+00, 6.4345750e+00, 3.5550560e+00, 7.2854110e+00,
 1.2188430e-02, 2.5052940e-02, 1.3413370e-02, 3.8101180e-02, 5.5240130e-01, 1.4854320e+00, 8.6189480e-01, 2.1919700e+00,
 1.7067580e-02, 5.3182370e-01, 3.0959940e-01, 1.1205070e+00, 7.8187970e-01, 1.9765060e+00, 1.6732110e+00, 2.4135350e+00,
 1.5309000e+00, 2.8336110e+00, 1.1954400e+00, 4.3036850e+00, 2.0782830e+00, 5.0325190e+00, 2.3008850e+00, 7.4163070e+00,
 1.1470440e-01, 3.2185370e+00, 1.4763830e+00, 6.7721380e+00, 2.8809010e+00, 6.5579630e+00, 4.3745130e+00, 7.9973300e+00,
 6.1328430e-03, 1.0466240e-02, 3.9245880e-03, 1.5008350e-02, 5.3326610e-03, 1.1905840e-02, 4.8382200e-03, 1.6565490e-02,
 3.3515010e-04, 8.6706780e-03, 3.5351640e-03, 1.7225120e-02, 7.8451510e-03, 1.6465590e-02, 9.7623430e-03, 1.8958120e-02,
 6.3415530e-01, 1.3164300e+00, 3.5863380e-01, 1.7156680e+00, 7.6495860e-01, 2.0774350e+00, 6.1334240e-01, 2.6270290e+00,
 4.7288670e-02, 1.4881420e+00, 4.4080940e-01, 2.6868700e+00, 1.6931560e+00, 4.3226140e+00, 1.8619720e+00, 4.5233230e+00,
 5.8362880e-03, 1.3944900e-02, 5.8209640e-03, 1.9600730e-02, 1.9132720e-01, 5.9805710e-01, 2.7054800e-01, 8.1564560e-01,
 8.8019640e-03, 3.1881830e-01, 1.4470250e-01, 6.2082190e-01, 3.5786220e-01, 1.0515790e+00, 6.9405620e-01, 1.1867910e+00,
 7.2012160e-01, 1.5494130e+00, 5.0962970e-01, 2.1749260e+00, 7.0712600e-01, 1.9904230e+00, 7.0950460e-01, 2.7109710e+00,
 5.8110960e-02, 1.8954150e+00, 6.7786800e-01, 3.6859430e+00, 1.2953120e+00, 3.4275430e+00, 1.7825590e+00, 3.8631000e+00,
 8.0482030e-01, 1.0916220e+00, 6.1706680e-01, 1.8941970e+00, 9.4197020e-01, 1.6714670e+00, 1.0239530e+00, 2.8141860e+00,
 3.9087120e-02, 8.0369630e-01, 4.9397510e-01, 1.9320210e+00, 1.1593890e+00, 1.9339700e+00, 1.7285540e+00, 2.6945010e+00,
 1.3611860e+00, 2.2457650e+00, 9.2230430e-01, 3.5416890e+00, 2.2101210e+00, 4.7703480e+00, 2.1231570e+00, 7.2995850e+00,
 9.0206160e-02, 2.2561500e+00, 1.0074680e+00, 4.9292520e+00, 4.0926970e+00, 8.3043120e+00, 5.3924600e+00, 1.0515390e+01,
 3.2301230e-02, 6.1339800e-02, 3.8599210e-02, 1.0433020e-01, 1.4253290e+00, 3.5409980e+00, 2.4148150e+00, 5.8437990e+00,
 4.3293150e-02, 1.2463140e+00, 8.5274020e-01, 2.9367160e+00, 2.2304320e+00, 5.2090620e+00, 5.1828540e+00, 7.1138180e+00,
 1.8417310e+00, 3.1494310e+00, 1.5616230e+00, 5.3495850e+00, 2.4342960e+00, 5.4458610e+00, 2.9263940e+00, 8.9754570e+00,
 1.3207960e-01, 3.4239440e+00, 1.8459670e+00, 8.0571510e+00, 3.7306590e+00, 7.8458260e+00, 6.1511480e+00, 1.0700460e+01,
 3.6796440e-01, 6.8791280e-01, 3.0065570e-01, 1.0352540e+00, 4.5702350e-01, 1.1177730e+00, 5.2943390e-01, 1.6321840e+00,
 1.5435680e-02, 4.3746000e-01, 2.0788710e-01, 9.1205010e-01, 5.1088430e-01, 1.1746200e+00, 8.1172130e-01, 1.4193410e+00,
 6.0442660e-01, 1.3745000e+00, 4.3644620e-01, 1.8799720e+00, 1.0414460e+00, 3.0983110e+00, 1.0661870e+00, 4.1118160e+00,
 3.4597720e-02, 1.1927070e+00, 4.1178720e-01, 2.2599940e+00, 1.7515490e+00, 4.8985860e+00, 2.4594050e+00, 5.3796390e+00,
 6.4738410e-03, 1.6944930e-02, 8.2442630e-03, 2.4995840e-02, 3.0314660e-01, 1.0380480e+00, 5.4733340e-01, 1.4857570e+00,
 7.4945820e-03, 2.9737880e-01, 1.5731690e-01, 6.0772210e-01, 4.3084250e-01, 1.3868950e+00, 1.0669130e+00, 1.6426580e+00,
 6.8256500e-01, 1.6088080e+00, 6.1677180e-01, 2.3700240e+00, 9.5738310e-01, 2.9521150e+00, 1.2265230e+00, 4.2197220e+00,
 4.2280360e-02, 1.5107200e+00, 6.2973440e-01, 3.0831840e+00, 1.3325700e+00, 3.8627580e+00, 2.3414830e+00, 4.5690060e+00,
 6.9682500e-01, 1.0700260e+00, 4.7905080e-01, 1.5475170e+00, 9.9347070e-01, 1.9957820e+00, 9.6832780e-01, 2.8006320e+00,
 4.1529510e-02, 9.6674650e-01, 4.7060100e-01, 1.9369590e+00, 1.0003180e+00, 1.8891060e+00, 1.3372630e+00, 2.1936780e+00,
 1.9178830e+00, 3.5823350e+00, 1.1652080e+00, 4.7086930e+00, 3.7932680e+00, 9.2692600e+00, 3.2674150e+00, 1.1821740e+01,
 1.5596930e-01, 4.4163990e+00, 1.5619190e+00, 8.0420980e+00, 5.7464350e+00, 1.3200490e+01, 6.7889160e+00, 1.3931560e+01,
 1.8317470e-02, 3.9380970e-02, 1.9626800e-02, 5.5826690e-02, 9.8458850e-01, 2.7692540e+00, 1.4957130e+00, 3.8090820e+00,
 3.0127570e-02, 9.8190610e-01, 5.3209140e-01, 1.9283790e+00, 1.2604330e+00, 3.3326370e+00, 2.6261800e+00, 3.7933170e+00,
 2.5458680e+00, 4.9287780e+00, 1.9355770e+00, 6.9777470e+00, 4.0989830e+00, 1.0381660e+01, 4.4183510e+00, 1.4260830e+01,
 2.2404940e-01, 6.5755520e+00, 2.8077380e+00, 1.2896600e+01, 5.1390120e+00, 1.2235740e+01, 7.5975720e+00, 1.3908550e+01,
 1.7481060e-02, 3.1203730e-02, 1.0891650e-02, 4.1708480e-02, 1.8027360e-02, 4.2097690e-02, 1.5924570e-02, 5.4598180e-02,
 1.1220690e-03, 3.0362920e-02, 1.1523490e-02, 5.6224850e-02, 2.3986640e-02, 5.2656910e-02, 2.9061360e-02, 5.6513080e-02,
 1.6973720e+00, 3.6854390e+00, 9.3460140e-01, 4.4771360e+00, 2.4282960e+00, 6.8976500e+00, 1.8956600e+00, 8.1304450e+00,
 1.4866650e-01, 4.8933940e+00, 1.3492750e+00, 8.2354670e+00, 4.8611670e+00, 1.2980760e+01, 5.2048780e+00, 1.2661550e+01,
 1.2839200e-02, 3.2086810e-02, 1.2467800e-02, 4.2039650e-02, 4.9918340e-01, 1.6320600e+00, 6.8726090e-01, 2.0747730e+00,
 2.2743400e-02, 8.6164620e-01, 3.6403700e-01, 1.5639700e+00, 8.4446020e-01, 2.5954650e+00, 1.5946000e+00, 2.7303820e+00,
 1.7529860e+00, 3.9450240e+00, 1.2078720e+00, 5.1618170e+00, 2.0415110e+00, 6.0104960e+00, 1.9943620e+00, 7.6307160e+00,
 1.6615180e-01, 5.6684120e+00, 1.8870610e+00, 1.0274990e+01, 3.3822760e+00, 9.3611160e+00, 4.5318170e+00, 9.8345920e+00,
 1.2415210e+00, 1.7613170e+00, 9.2678980e-01, 2.8488270e+00, 1.7233550e+00, 3.1984930e+00, 1.8239430e+00, 5.0196800e+00,
 7.0821230e-02, 1.5231120e+00, 8.7142230e-01, 3.4129290e+00, 1.9184330e+00, 3.3471650e+00, 2.7848020e+00, 4.3469180e+00,
 1.9717340e+00, 3.4025540e+00, 1.3007650e+00, 5.0018060e+00, 3.7968990e+00, 8.5718220e+00, 3.5513140e+00, 1.2226350e+01,
 1.5347640e-01, 4.0149790e+00, 1.6689000e+00, 8.1765860e+00, 6.3592020e+00, 1.3496050e+01, 8.1578130e+00, 1.5929570e+01,
 3.8456490e-02, 7.6384090e-02, 4.4742760e-02, 1.2110050e-01, 2.0125560e+00, 5.2296020e+00, 3.3197900e+00, 8.0447730e+00,
 6.0540270e-02, 1.8228990e+00, 1.1610090e+00, 4.0038030e+00, 2.8484050e+00, 6.9579660e+00, 6.4442960e+00, 8.8572960e+00,
 2.4263200e+00, 4.3397430e+00, 2.0030510e+00, 6.8711210e+00, 3.8034490e+00, 8.8998120e+00, 4.4517520e+00, 1.3672450e+01,
 2.0437710e-01, 5.5415730e+00, 2.7810850e+00, 1.2155240e+01, 5.2719300e+00, 1.1596660e+01, 8.4631900e+00, 1.4742530e+01,
 3.1261380e-04, 6.5903780e-04, 1.6747340e-04, 8.8039180e-04, 5.1731990e-04, 1.4267530e-03, 3.9292200e-04, 1.8493380e-03,
 9.5221970e-06, 3.0431570e-04, 8.4083920e-05, 5.6319260e-04, 5.2729200e-04, 1.3671010e-03, 5.4929980e-04, 1.4663650e-03,
 3.8491170e-04, 9.8704430e-04, 1.8223100e-04, 1.1983830e-03, 8.8363380e-04, 2.9643890e-03, 5.9312040e-04, 3.4921760e-03,
 1.5998310e-05, 6.2192020e-04, 1.2484560e-04, 1.0460690e-03, 1.3550830e-03, 4.2735510e-03, 1.2475210e-03, 4.1660410e-03,
 5.6953520e-06, 1.6810190e-05, 4.7553700e-06, 2.2011670e-05, 3.5532800e-04, 1.3720470e-03, 4.2063230e-04, 1.7432160e-03,
 4.7875690e-06, 2.1421620e-04, 6.5889610e-05, 3.8859690e-04, 4.6047210e-04, 1.6714860e-03, 7.4763170e-04, 1.7573520e-03,
 8.5855210e-04, 2.2819250e-03, 5.0865230e-04, 2.9840230e-03, 1.6044520e-03, 5.5789010e-03, 1.3476910e-03, 7.0786660e-03,
 3.8616280e-05, 1.5559310e-03, 3.7710570e-04, 2.8187580e-03, 2.0362860e-03, 6.6561150e-03, 2.3459240e-03, 6.9887140e-03,
 3.6354020e-04, 6.2950280e-04, 1.6386420e-04, 8.0814780e-04, 6.9056090e-04, 1.5643520e-03, 4.4130950e-04, 1.9486310e-03,
 1.5732390e-05, 4.1297610e-04, 1.1688660e-04, 7.3448840e-04, 6.3400580e-04, 1.3501620e-03, 5.5570670e-04, 1.3917290e-03,
 7.5000780e-04, 1.5797360e-03, 2.9875900e-04, 1.8431930e-03, 1.9764030e-03, 5.4460490e-03, 1.1161950e-03, 6.1655230e-03,
 4.4288610e-05, 1.4141510e-03, 2.9079400e-04, 2.2858570e-03, 2.7300370e-03, 7.0718740e-03, 2.1146780e-03, 6.6251630e-03,
 9.8957900e-06, 2.3990850e-05, 6.9519760e-06, 3.0189320e-05, 7.0869260e-04, 2.2477110e-03, 7.0587070e-04, 2.7444170e-03,
 1.1818390e-05, 4.3434860e-04, 1.3685290e-04, 7.5720420e-04, 8.2723900e-04, 2.4664570e-03, 1.1300810e-03, 2.4920510e-03,
 1.9664590e-03, 4.2930170e-03, 9.8024210e-04, 5.3949920e-03, 4.2183570e-03, 1.2047820e-02, 2.9812700e-03, 1.4690570e-02,
 1.2566140e-04, 4.1587680e-03, 1.0324960e-03, 7.2403540e-03, 4.8223060e-03, 1.2947320e-02, 4.6743790e-03, 1.3064230e-02,
 5.3997880e-06, 1.0869010e-05, 2.2058530e-06, 1.2896150e-05, 7.4192400e-06, 1.9537090e-05, 4.2970330e-06, 2.2492210e-05,
 2.5167370e-07, 7.6795550e-06, 1.6946340e-06, 1.2623300e-05, 9.0012860e-06, 2.2282560e-05, 7.1503120e-06, 2.1228090e-05,
 3.9300770e-04, 9.6224950e-04, 1.4188100e-04, 1.0376500e-03, 7.4910720e-04, 2.3994840e-03, 3.8342170e-04, 2.5106330e-03,
 2.4994600e-05, 9.2772190e-04, 1.4873310e-04, 1.3859520e-03, 1.3673850e-03, 4.1174160e-03, 9.5991930e-04, 3.5650350e-03,
 4.1067950e-06, 1.1573540e-05, 2.6147420e-06, 1.3460180e-05, 2.1273720e-04, 7.8432120e-04, 1.9203430e-04, 8.8507630e-04,
 5.2823790e-06, 2.2567200e-04, 5.5436220e-05, 3.6360460e-04, 3.2814860e-04, 1.1373160e-03, 4.0627220e-04, 1.0620410e-03,
 8.0169190e-04, 2.0344790e-03, 3.6217970e-04, 2.3629710e-03, 1.2439390e-03, 4.1298300e-03, 7.9675580e-04, 4.6541400e-03,
 5.5175140e-05, 2.1226300e-03, 4.1086410e-04, 3.4154370e-03, 1.8791630e-03, 5.8648590e-03, 1.6508280e-03, 5.4693840e-03,
 1.0931240e-03, 1.7487480e-03, 5.3502060e-04, 2.5107770e-03, 2.0216610e-03, 4.2311020e-03, 1.4028740e-03, 5.8943540e-03,
 4.5278070e-05, 1.0980720e-03, 3.6528100e-04, 2.1841290e-03, 2.0520510e-03, 4.0373200e-03, 1.9530340e-03, 4.6542500e-03,
 1.3013040e-03, 2.5322690e-03, 5.6286350e-04, 3.3043340e-03, 3.3387030e-03, 8.4995560e-03, 2.0474420e-03, 1.0761490e-02,
 7.3549730e-05, 2.1696880e-03, 5.2437700e-04, 3.9222770e-03, 5.0986970e-03, 1.2202190e-02, 4.2884890e-03, 1.2784610e-02,
 3.5062360e-05, 7.8532400e-05, 2.6746570e-05, 1.1052090e-04, 2.4447690e-03, 7.1636250e-03, 2.6440780e-03, 9.7820580e-03,
 4.0079750e-05, 1.3608730e-03, 5.0395320e-04, 2.6532610e-03, 3.1550010e-03, 8.6906950e-03, 4.6800140e-03, 9.8203180e-03,
 3.1628870e-03, 6.3793140e-03, 1.7119910e-03, 8.9658170e-03, 6.6058910e-03, 1.7430470e-02, 5.0694240e-03, 2.3769880e-02,
 1.9345360e-04, 5.9149660e-03, 1.7259680e-03, 1.1516880e-02, 8.3489420e-03, 2.0709470e-02, 8.7875900e-03, 2.3370100e-02,
 3.7689360e-04, 9.9118210e-04, 3.1979400e-04, 1.2609990e-03, 5.1194490e-04, 1.7613480e-03, 6.1586330e-04, 2.1742460e-03,
 1.2455250e-05, 4.9656060e-04, 1.7419770e-04, 8.7518630e-04, 7.8856050e-04, 2.5504510e-03, 1.3010900e-03, 2.6052780e-03,
 7.0649740e-04, 2.2600530e-03, 5.2976780e-04, 2.6132040e-03, 1.3312980e-03, 5.5714810e-03, 1.4153370e-03, 6.2506800e-03,
 3.1858720e-05, 1.5449750e-03, 3.9376900e-04, 2.4748160e-03, 3.0852390e-03, 1.2137920e-02, 4.4986730e-03, 1.1268720e-02,
 9.4077310e-06, 3.4639340e-05, 1.2441210e-05, 4.3196200e-05, 4.8177830e-04, 2.3207010e-03, 9.0330480e-04, 2.8080000e-03,
 8.5799390e-06, 4.7890990e-04, 1.8702510e-04, 8.2736410e-04, 9.4349780e-04, 4.2724090e-03, 2.4262700e-03, 4.2778390e-03,
 1.1010800e-03, 3.6507840e-03, 1.0332070e-03, 4.5465560e-03, 1.6890100e-03, 7.3263370e-03, 2.2470370e-03, 8.8528950e-03,
 5.3731330e-05, 2.7007220e-03, 8.3106320e-04, 4.6595410e-03, 3.2393980e-03, 1.3209270e-02, 5.9108960e-03, 1.3208420e-02,
 6.1520840e-04, 1.3289240e-03, 4.3920560e-04, 1.6247580e-03, 9.5923560e-04, 2.7107560e-03, 9.7091330e-04, 3.2157420e-03,
 2.8884790e-05, 9.4587140e-04, 3.3990150e-04, 1.6020930e-03, 1.3308720e-03, 3.5355860e-03, 1.8475770e-03, 3.4707700e-03,
 1.9323000e-03, 5.0772170e-03, 1.2191120e-03, 5.6416710e-03, 4.1796290e-03, 1.4367340e-02, 3.7386630e-03, 1.5490320e-02,
 1.2379570e-04, 4.9310770e-03, 1.2873980e-03, 7.5908550e-03, 8.7246990e-03, 2.8193500e-02, 1.0703850e-02, 2.5153980e-02,
 2.2944260e-05, 6.9390780e-05, 2.5529700e-05, 8.3158210e-05, 1.3487610e-03, 5.3364190e-03, 2.1277280e-03, 6.2051930e-03,
 2.9729420e-05, 1.3630110e-03, 5.4525090e-04, 2.2629220e-03, 2.3791820e-03, 8.8491750e-03, 5.1477820e-03, 8.5149450e-03,
 3.5399430e-03, 9.6406580e-03, 2.7948520e-03, 1.1538000e-02, 6.2331600e-03, 2.2207820e-02, 6.9771840e-03, 2.5788840e-02,
 2.4542460e-04, 1.0132430e-02, 3.1938810e-03, 1.6799810e-02, 1.0768110e-02, 3.6065930e-02, 1.6531890e-02, 3.4657460e-02,
 7.7754530e-06, 1.9524120e-05, 5.0308280e-06, 2.2061610e-05, 8.7692380e-06, 2.8806790e-05, 8.0442420e-06, 3.1583680e-05,
 3.9318020e-07, 1.4966570e-05, 4.1931800e-06, 2.3429070e-05, 1.6077810e-05, 4.9650060e-05, 2.0228380e-05, 4.5046520e-05,
 8.6156680e-04, 2.6315290e-03, 4.9263600e-04, 2.7025090e-03, 1.3479860e-03, 5.3863150e-03, 1.0927780e-03, 5.3672620e-03,
 5.9448220e-05, 2.7525990e-03, 5.6029180e-04, 3.9162370e-03, 3.7183640e-03, 1.3967490e-02, 4.1343740e-03, 1.1517360e-02,
 8.1022510e-06, 2.8484020e-05, 8.1704410e-06, 3.1548720e-05, 3.4450830e-04, 1.5844650e-03, 4.9254840e-04, 1.7028050e-03,
 1.1306730e-05, 6.0258420e-04, 1.8793820e-04, 9.2462370e-04, 8.0305710e-04, 3.4720780e-03, 1.5747330e-03, 3.0877740e-03,
 1.2279990e-03, 3.8875540e-03, 8.7867590e-04, 4.3000880e-03, 1.5640230e-03, 6.4775210e-03, 1.5866580e-03, 6.9520310e-03,
 9.1693580e-05, 4.4005020e-03, 1.0814530e-03, 6.7432610e-03, 3.5704950e-03, 1.3901250e-02, 4.9679770e-03, 1.2346120e-02,
 1.8899670e-03, 3.7717650e-03, 1.4651060e-03, 5.1572840e-03, 2.8691060e-03, 7.4907310e-03, 3.1533410e-03, 9.9380840e-03,
 8.4933200e-05, 2.5695250e-03, 1.0852520e-03, 4.8673900e-03, 4.4009470e-03, 1.0801490e-02, 6.6340940e-03, 1.1858670e-02,
 3.4253290e-03, 8.3150730e-03, 2.3466090e-03, 1.0333220e-02, 7.2136460e-03, 2.2908990e-02, 7.0065240e-03, 2.7623430e-02,
 2.1004360e-04, 7.7296230e-03, 2.3718440e-03, 1.3307450e-02, 1.6647770e-02, 4.9701230e-02, 2.2177630e-02, 4.9592100e-02,
 8.3057640e-05, 2.3207050e-04, 1.0035070e-04, 3.1103620e-04, 4.7536770e-03, 1.7376300e-02, 8.1429190e-03, 2.2596980e-02,
 1.0300740e-04, 4.3630830e-03, 2.0513860e-03, 8.1012390e-03, 9.2706700e-03, 3.1856550e-02, 2.1780740e-02, 3.4281940e-02,
 5.8171480e-03, 1.4636360e-02, 4.9870270e-03, 1.9590450e-02, 9.9726670e-03, 3.2826270e-02, 1.2121390e-02, 4.2631930e-02,
 3.8601850e-04, 1.4723670e-02, 5.4547890e-03, 2.7302000e-02, 1.9047200e-02, 5.8938790e-02, 3.1752900e-02, 6.3341520e-02,
 5.2713400e-06, 9.4219050e-06, 4.4237540e-06, 1.5211660e-05, 6.2025690e-06, 1.4503630e-05, 7.3799090e-06, 2.2720420e-05,
 1.6678240e-07, 4.5191110e-06, 2.3070570e-06, 1.0107820e-05, 7.4587230e-06, 1.6395680e-05, 1.2171810e-05, 2.1254110e-05,
 1.0004600e-05, 2.1751580e-05, 7.4198160e-06, 3.1916990e-05, 1.6330920e-05, 4.6450350e-05, 1.7171700e-05, 6.6133580e-05,
 4.3192970e-07, 1.4236040e-05, 5.2801300e-06, 2.8939240e-05, 2.9546440e-05, 7.9003000e-05, 4.2610750e-05, 9.3078700e-05,
 1.4712730e-07, 3.6818070e-07, 1.9243740e-07, 5.8265760e-07, 6.5268210e-06, 2.1367650e-05, 1.2103400e-05, 3.2810370e-05,
 1.2846600e-07, 4.8734970e-06, 2.7696330e-06, 1.0684640e-05, 9.9787590e-06, 3.0710820e-05, 2.5380090e-05, 3.9022900e-05,
 1.6482020e-05, 3.7141610e-05, 1.5296680e-05, 5.8699390e-05, 2.1901300e-05, 6.4566540e-05, 2.8818150e-05, 9.9010760e-05,
 7.7004220e-07, 2.6305700e-05, 1.1779840e-05, 5.7595640e-05, 3.2793140e-05, 9.0882570e-05, 5.9182100e-05, 1.1532650e-04,
 3.2502540e-04, 4.7717550e-04, 2.2949930e-04, 7.4036080e-04, 4.3900190e-04, 8.4316890e-04, 4.3948090e-04, 1.2693510e-03,
 1.4610320e-05, 3.2516640e-04, 1.7004430e-04, 6.9893660e-04, 4.7550880e-04, 8.5855210e-04, 6.5289480e-04, 1.0695660e-03,
 1.0336100e-03, 1.8458260e-03, 6.4497670e-04, 2.6028510e-03, 1.9367160e-03, 4.5246750e-03, 1.7134160e-03, 6.1908160e-03,
 6.3399090e-05, 1.7163360e-03, 6.5209170e-04, 3.3529550e-03, 3.1561650e-03, 6.9317230e-03, 3.8297270e-03, 7.8482960e-03,
 1.3554240e-05, 2.7860320e-05, 1.4916450e-05, 4.2370720e-05, 6.9021150e-04, 1.8560100e-03, 1.0769160e-03, 2.7388110e-03,
 1.6814470e-05, 5.2393690e-04, 3.0500820e-04, 1.1038900e-03, 9.5050890e-04, 2.4027810e-03, 2.0340750e-03, 2.9340650e-03,
 2.0016160e-03, 3.7048790e-03, 1.5630090e-03, 5.6269670e-03, 3.0530830e-03, 7.3929770e-03, 3.3800960e-03, 1.0894860e-02,
 1.3286110e-04, 3.7280040e-03, 1.7100820e-03, 7.8441080e-03, 4.1176650e-03, 9.3732820e-03, 6.2524820e-03, 1.1430570e-02,
 3.7682060e-06, 6.4307760e-06, 2.4113860e-06, 9.2215870e-06, 3.6814330e-06, 8.2192640e-06, 3.3400930e-06, 1.1436080e-05,
 1.8242990e-07, 4.7196500e-06, 1.9242720e-06, 9.3760290e-06, 5.2694210e-06, 1.1059590e-05, 6.5571590e-06, 1.2733770e-05,
 4.2275120e-04, 8.7758060e-04, 2.3907850e-04, 1.1437270e-03, 5.7296390e-04, 1.5560260e-03, 4.5940140e-04, 1.9676790e-03,
 2.7927380e-05, 8.7885540e-04, 2.6032990e-04, 1.5867910e-03, 1.2338860e-03, 3.1501010e-03, 1.3569110e-03, 3.2963680e-03,
 4.3905690e-06, 1.0490580e-05, 4.3790410e-06, 1.4745390e-05, 1.6171890e-04, 5.0550660e-04, 2.2868020e-04, 6.8942290e-04,
 5.8660750e-06, 2.1247670e-04, 9.6437070e-05, 4.1374720e-04, 2.9429900e-04, 8.6479820e-04, 5.7077850e-04, 9.7599440e-04,
 6.3693690e-04, 1.3704330e-03, 4.5075990e-04, 1.9236900e-03, 7.0272840e-04, 1.9780450e-03, 7.0509220e-04, 2.6941110e-03,
 4.5533660e-05, 1.4851790e-03, 5.3115300e-04, 2.8881730e-03, 1.2524310e-03, 3.3140750e-03, 1.7235480e-03, 3.7352130e-03,
 9.1959130e-04, 1.2472920e-03, 7.0506330e-04, 2.1643180e-03, 1.2092980e-03, 2.1458230e-03, 1.3145470e-03, 3.6128400e-03,
 3.9565210e-05, 8.1352680e-04, 5.0001720e-04, 1.9556520e-03, 1.4481510e-03, 2.4156530e-03, 2.1590750e-03, 3.3656050e-03,
 1.6874460e-03, 2.7840470e-03, 1.1433690e-03, 4.3905890e-03, 3.0784240e-03, 6.6445030e-03, 2.9572950e-03, 1.0167420e-02,
 9.9067800e-05, 2.4777890e-03, 1.1064390e-03, 5.4134900e-03, 5.5463960e-03, 1.1253950e-02, 7.3078260e-03, 1.4250390e-02,
 4.5188330e-05, 8.5812320e-05, 5.3999000e-05, 1.4595440e-04, 2.2403840e-03, 5.5658710e-03, 3.7956950e-03, 9.1854960e-03,
 5.3655030e-05, 1.5446100e-03, 1.0568370e-03, 3.6395960e-03, 3.4110260e-03, 7.9662820e-03, 7.9262000e-03, 1.0879250e-02,
 3.0292840e-03, 5.1801920e-03, 2.5685620e-03, 8.7990100e-03, 4.4987020e-03, 1.0064230e-02, 5.4081250e-03, 1.6587100e-02,
 1.9245690e-04, 4.9891240e-03, 2.6898100e-03, 1.1740300e-02, 6.7079240e-03, 1.4107220e-02, 1.1060090e-02, 1.9240000e-02,
 7.8859740e-04, 1.4742900e-03, 6.4434590e-04, 2.2186890e-03, 1.1004960e-03, 2.6915550e-03, 1.2748570e-03, 3.9302370e-03,
 2.9306180e-05, 8.3056170e-04, 3.9469450e-04, 1.7316190e-03, 1.1969090e-03, 2.7519210e-03, 1.9017150e-03, 3.3252560e-03,
 1.4054310e-03, 3.1960290e-03, 1.0148380e-03, 4.3713690e-03, 2.7208380e-03, 8.0945210e-03, 2.7854760e-03, 1.0742360e-02,
 7.1268470e-05, 2.4568780e-03, 8.4824790e-04, 4.6554020e-03, 4.4522260e-03, 1.2451610e-02, 6.2515110e-03, 1.3674390e-02,
 1.6987250e-05, 4.4463190e-05, 2.1632800e-05, 6.5588650e-05, 8.9374520e-04, 3.0604030e-03, 1.6136640e-03, 4.3803490e-03,
 1.7421770e-05, 6.9128150e-04, 3.6569600e-04, 1.4127000e-03, 1.2358570e-03, 3.9782610e-03, 3.0604040e-03, 4.7119110e-03,
 2.1057720e-03, 4.9633130e-03, 1.9027950e-03, 7.3117310e-03, 3.3185870e-03, 1.0232950e-02, 4.2515100e-03, 1.4626870e-02,
 1.1555540e-04, 4.1289090e-03, 1.7211110e-03, 8.4265690e-03, 4.4941360e-03, 1.3027280e-02, 7.8967310e-03, 1.5409130e-02,
 1.1243120e-03, 1.7264640e-03, 7.7293780e-04, 2.4968840e-03, 1.8010180e-03, 3.6180640e-03, 1.7554380e-03, 5.0771410e-03,
 5.9361350e-05, 1.3818460e-03, 6.7266650e-04, 2.7686460e-03, 1.7643720e-03, 3.3320250e-03, 2.3586780e-03, 3.8692320e-03,
 3.3573870e-03, 6.2711280e-03, 2.0397770e-03, 8.2428950e-03, 7.4609320e-03, 1.8231590e-02, 6.4266380e-03, 2.3252020e-02,
 2.4188140e-04, 6.8490720e-03, 2.4222670e-03, 1.2471900e-02, 1.0996810e-02, 2.5261450e-02, 1.2991780e-02, 2.6660490e-02,
 3.6185950e-05, 7.7796610e-05, 3.8772500e-05, 1.1028490e-04, 2.1853910e-03, 6.1466330e-03, 3.3198820e-03, 8.4546330e-03,
 5.2725710e-05, 1.7184160e-03, 9.3120340e-04, 3.3748200e-03, 2.7219680e-03, 7.1969940e-03, 5.6713650e-03, 8.1918560e-03,
 5.9131200e-03, 1.1447750e-02, 4.4956380e-03, 1.6206750e-02, 1.0696880e-02, 2.7092420e-02, 1.1530310e-02, 3.7215660e-02,
 4.6100810e-04, 1.3529970e-02, 5.7772530e-03, 2.6536270e-02, 1.3048160e-02, 3.1067040e-02, 1.9290540e-02, 3.5314380e-02,
 1.9080400e-05, 3.4058550e-05, 1.1888130e-05, 4.5524390e-05, 2.2108130e-05, 5.1627140e-05, 1.9529340e-05, 6.6957310e-05,
 1.0849840e-06, 2.9359400e-05, 1.1142620e-05, 5.4366570e-05, 2.8620550e-05, 6.2829550e-05, 3.4675640e-05, 6.7430680e-05,
 2.0100790e-03, 4.3644080e-03, 1.1067830e-03, 5.3019600e-03, 3.2310070e-03, 9.1777750e-03, 2.5223000e-03, 1.0818090e-02,
 1.5596710e-04, 5.1336970e-03, 1.4155350e-03, 8.6398920e-03, 6.2931130e-03, 1.6804480e-02, 6.7380700e-03, 1.6391240e-02,
 1.7158090e-05, 4.2880280e-05, 1.6661760e-05, 5.6181080e-05, 7.4953390e-04, 2.4505710e-03, 1.0319360e-03, 3.1153140e-03,
 2.6925900e-05, 1.0201030e-03, 4.3098330e-04, 1.8515840e-03, 1.2336700e-03, 3.7917090e-03, 2.3295480e-03, 3.9888090e-03,
 2.7543290e-03, 6.1985070e-03, 1.8978350e-03, 8.1103600e-03, 3.6040380e-03, 1.0610800e-02, 3.5208010e-03, 1.3471100e-02,
 2.3127390e-04, 7.8901070e-03, 2.6266820e-03, 1.4302200e-02, 5.8094560e-03, 1.6078810e-02, 7.7839270e-03, 1.6892060e-02,
 2.5199800e-03, 3.5750350e-03, 1.8811530e-03, 5.7824110e-03, 3.9302280e-03, 7.2943800e-03, 4.1596260e-03, 1.1447720e-02,
 1.2734750e-04, 2.7387890e-03, 1.5669510e-03, 6.1369710e-03, 4.2567510e-03, 7.4269220e-03, 6.1791110e-03, 9.6452420e-03,
 4.3421780e-03, 7.4931480e-03, 2.8645610e-03, 1.1015040e-02, 9.3948210e-03, 2.1209600e-02, 8.7871590e-03, 3.0252160e-02,
 2.9942280e-04, 7.8329720e-03, 3.2559180e-03, 1.5952000e-02, 1.5309140e-02, 3.2490380e-02, 1.9639110e-02, 3.8348840e-02,
 9.5570490e-05, 1.8982660e-04, 1.1119290e-04, 3.0095410e-04, 5.6195610e-03, 1.4602360e-02, 9.2696850e-03, 2.2463020e-02,
 1.3328540e-04, 4.0132920e-03, 2.5560760e-03, 8.8147670e-03, 7.7382860e-03, 1.8902770e-02, 1.7507270e-02, 2.4062690e-02,
 7.0893880e-03, 1.2680160e-02, 5.8526510e-03, 2.0076510e-02, 1.2486430e-02, 2.9217400e-02, 1.4614760e-02, 4.4885620e-02,
 5.2902580e-04, 1.4344250e-02, 7.1987790e-03, 3.1463590e-02, 1.6839110e-02, 3.7040970e-02, 2.7032340e-02, 4.7089240e-02,
 2.1916880e-02, 4.6204140e-02, 1.1741310e-02, 6.1722930e-02, 4.9340120e-02, 1.3607860e-01, 3.7475490e-02, 1.7638330e-01,
 9.2749290e-04, 2.9641330e-02, 8.1900470e-03, 5.4856780e-02, 4.1397150e-02, 1.0732970e-01, 4.3124960e-02, 1.1512280e-01,
 2.3014540e-02, 5.9017110e-02, 1.0895910e-02, 7.1653410e-02, 7.1876020e-02, 2.4112760e-01, 4.8245250e-02, 2.8405850e-01,
 1.3289790e-03, 5.1662900e-02, 1.0370920e-02, 8.6896970e-02, 9.0731060e-02, 2.8614020e-01, 8.3529080e-02, 2.7894170e-01,
 3.8670490e-04, 1.1413840e-03, 3.2288170e-04, 1.4945560e-03, 3.2821540e-02, 1.2673550e-01, 3.8853680e-02, 1.6102030e-01,
 4.5162400e-04, 2.0207570e-02, 6.2155400e-03, 3.6657370e-02, 3.5011530e-02, 1.2708970e-01, 5.6845410e-02, 1.3361850e-01,
 6.0612110e-02, 1.6109950e-01, 3.5909870e-02, 2.1066620e-01, 1.5409540e-01, 5.3581120e-01, 1.2943560e-01, 6.7985230e-01,
 3.7876170e-03, 1.5261100e-01, 3.6987810e-02, 2.7647350e-01, 1.6098310e-01, 5.2621380e-01, 1.8546210e-01, 5.5250810e-01,
 2.4134300e-02, 4.1790730e-02, 1.0878430e-02, 5.3650410e-02, 6.2366970e-02, 1.4128210e-01, 3.9856200e-02, 1.7598770e-01,
 1.4510410e-03, 3.8089910e-02, 1.0780770e-02, 6.7743870e-02, 4.7132890e-02, 1.0037290e-01, 4.1312020e-02, 1.0346310e-01,
 4.2463790e-02, 8.9441160e-02, 1.6915070e-02, 1.0435750e-01, 1.5222950e-01, 4.1947390e-01, 8.5973300e-02, 4.7489030e-01,
 3.4837560e-03, 1.1123760e-01, 2.2873950e-02, 1.7980620e-01, 1.7308930e-01, 4.4836950e-01, 1.3407440e-01, 4.2004720e-01,
 6.3624030e-04, 1.5424690e-03, 4.4697060e-04, 1.9409940e-03, 6.1986770e-02, 1.9659910e-01, 6.1739950e-02, 2.4004420e-01,
 1.0556780e-03, 3.8798230e-02, 1.2224400e-02, 6.7637340e-02, 5.9559400e-02, 1.7757950e-01, 8.1363340e-02, 1.7942220e-01,
 1.3145870e-01, 2.8699020e-01, 6.5529630e-02, 3.6065770e-01, 3.8363490e-01, 1.0956790e+00, 2.7112910e-01, 1.3360220e+00,
 1.1671030e-02, 3.8625310e-01, 9.5894960e-02, 6.7246090e-01, 3.6100050e-01, 9.6924360e-01, 3.4992660e-01, 9.7799540e-01,
 4.1553040e-04, 8.3640390e-04, 1.6974720e-04, 9.9239860e-04, 7.7670470e-04, 2.0452970e-03, 4.4984750e-04, 2.3546620e-03,
 2.6907090e-05, 8.2104120e-04, 1.8117770e-04, 1.3495900e-03, 7.7567410e-04, 1.9201700e-03, 6.1616890e-04, 1.8293030e-03,
 2.5792770e-02, 6.3151620e-02, 9.3115330e-03, 6.8100120e-02, 6.6882300e-02, 2.1423240e-01, 3.4232920e-02, 2.2415610e-01,
 2.2790080e-03, 8.4589700e-02, 1.3561490e-02, 1.2637110e-01, 1.0049310e-01, 3.0260090e-01, 7.0547270e-02, 2.6200480e-01,
 3.0606770e-04, 8.6254300e-04, 1.9486930e-04, 1.0031490e-03, 2.1568930e-02, 7.9520480e-02, 1.9469910e-02, 8.9735790e-02,
 5.4694920e-04, 2.3366580e-02, 5.7399890e-03, 3.7648420e-02, 2.7386320e-02, 9.4917050e-02, 3.3906290e-02, 8.8634870e-02,
 6.2123480e-02, 1.5765280e-01, 2.8065480e-02, 1.8310780e-01, 1.3113480e-01, 4.3536240e-01, 8.3993160e-02, 4.9063450e-01,
 5.9401110e-03, 2.2852060e-01, 4.4233300e-02, 3.6770320e-01, 1.6306520e-01, 5.0892580e-01, 1.4325130e-01, 4.7460830e-01,
 5.9751680e-02, 9.5589000e-02, 2.9244970e-02, 1.3724250e-01, 1.5033480e-01, 3.1463320e-01, 1.0432050e-01, 4.3831600e-01,
 3.4385190e-03, 8.3390040e-02, 2.7740260e-02, 1.6586770e-01, 1.2560800e-01, 2.4712830e-01, 1.1954710e-01, 2.8489110e-01,
 6.0663860e-02, 1.1804870e-01, 2.6239430e-02, 1.5404060e-01, 2.1173830e-01, 5.3903630e-01, 1.2984740e-01, 6.8248650e-01,
 4.7636000e-03, 1.4052430e-01, 3.3962360e-02, 2.5403430e-01, 2.6617010e-01, 6.3699750e-01, 2.2387430e-01, 6.6740190e-01,
 1.8561380e-03, 4.1573630e-03, 1.4159150e-03, 5.8507740e-03, 1.7606670e-01, 5.1590820e-01, 1.9042060e-01, 7.0448180e-01,
 2.9477920e-03, 1.0008980e-01, 3.7064840e-02, 1.9514250e-01, 1.8703260e-01, 5.1519570e-01, 2.7743730e-01, 5.8216130e-01,
 1.7409510e-01, 3.5113720e-01, 9.4233260e-02, 4.9350630e-01, 4.9465760e-01, 1.3052160e+00, 3.7960490e-01, 1.7799190e+00,
 1.4793890e-02, 4.5233260e-01, 1.3198920e-01, 8.8072560e-01, 5.1461550e-01, 1.2764990e+00, 5.4165310e-01, 1.4404960e+00,
 3.7454510e-02, 9.8500570e-02, 3.1780130e-02, 1.2531410e-01, 6.9211620e-02, 2.3812280e-01, 8.3260700e-02, 2.9394380e-01,
 1.7196530e-03, 6.8558360e-02, 2.4050850e-02, 1.2083390e-01, 8.7754420e-02, 2.8382520e-01, 1.4479090e-01, 2.8992660e-01,
 5.9877910e-02, 1.9154670e-01, 4.4899510e-02, 2.2147730e-01, 1.5349760e-01, 6.4238760e-01, 1.6318720e-01, 7.2069870e-01,
 3.7513470e-03, 1.8192000e-01, 4.6366080e-02, 2.9140820e-01, 2.9281510e-01, 1.1519900e+00, 4.2696180e-01, 1.0694960e+00,
 9.0543800e-04, 3.3338290e-03, 1.1973920e-03, 4.1573760e-03, 6.3079960e-02, 3.0385290e-01, 1.1827110e-01, 3.6765570e-01,
 1.1472570e-03, 6.4036920e-02, 2.5007860e-02, 1.1063010e-01, 1.0168650e-01, 4.6046360e-01, 2.6149390e-01, 4.6104880e-01,
 1.1018600e-01, 3.6533700e-01, 1.0339390e-01, 4.5497770e-01, 2.2993770e-01, 9.9738950e-01, 3.0590600e-01, 1.2052110e+00,
 7.4702970e-03, 3.7548290e-01, 1.1554320e-01, 6.4781860e-01, 3.6301160e-01, 1.4802500e+00, 6.6238340e-01, 1.4801550e+00,
 5.7892080e-02, 1.2505380e-01, 4.1329950e-02, 1.5289240e-01, 1.2279840e-01, 3.4702260e-01, 1.2429330e-01, 4.1166940e-01,
 3.7763220e-03, 1.2366070e-01, 4.4437830e-02, 2.0945350e-01, 1.4024320e-01, 3.7256920e-01, 1.9469200e-01, 3.6573910e-01,
 1.5507510e-01, 4.0746790e-01, 9.7838840e-02, 4.5276770e-01, 4.5632660e-01, 1.5686080e+00, 4.0818250e-01, 1.6912130e+00,
 1.3803080e-02, 5.4980950e-01, 1.4354340e-01, 8.4637180e-01, 7.8409150e-01, 2.5337590e+00, 9.6195890e-01, 2.2605960e+00,
 2.0910260e-03, 6.3239320e-03, 2.3266510e-03, 7.5786270e-03, 1.6722090e-01, 6.6161560e-01, 2.6379830e-01, 7.6932730e-01,
 3.7642180e-03, 1.7257880e-01, 6.9037430e-02, 2.8652190e-01, 2.4280730e-01, 9.0310210e-01, 5.2535660e-01, 8.6899230e-01,
 3.3544040e-01, 9.1353620e-01, 2.6483650e-01, 1.0933260e+00, 8.0352200e-01, 2.8628290e+00, 8.9943490e-01, 3.3244620e+00,
 3.2310230e-02, 1.3339370e+00, 4.2047550e-01, 2.2117000e+00, 1.1426340e+00, 3.8270570e+00, 1.7542450e+00, 3.6776000e+00,
 8.4813810e-04, 2.1296700e-03, 5.4875730e-04, 2.4064570e-03, 1.3012870e-03, 4.2747050e-03, 1.1937030e-03, 4.6867740e-03,
 5.9584770e-05, 2.2681200e-03, 6.3545850e-04, 3.5505750e-03, 1.9638860e-03, 6.0646990e-03, 2.4708740e-03, 5.5023820e-03,
 8.0149450e-02, 2.4480460e-01, 4.5828720e-02, 2.5140780e-01, 1.7059540e-01, 6.8166930e-01, 1.3829740e-01, 6.7925800e-01,
 7.6833970e-03, 3.5576020e-01, 7.2415010e-02, 5.0615480e-01, 3.8735770e-01, 1.4550520e+00, 4.3069510e-01, 1.1998120e+00,
 8.5592360e-04, 3.0090590e-03, 8.6312730e-04, 3.3328140e-03, 4.9510730e-02, 2.2771010e-01, 7.0786210e-02, 2.4471740e-01,
 1.6594690e-03, 8.8440230e-02, 2.7583360e-02, 1.3570540e-01, 9.5000170e-02, 4.1074040e-01, 1.8628800e-01, 3.6527800e-01,
 1.3488420e-01, 4.2701140e-01, 9.6514310e-02, 4.7232440e-01, 2.3370970e-01, 9.6792620e-01, 2.3709190e-01, 1.0388320e+00,
 1.3992800e-02, 6.7153400e-01, 1.6503400e-01, 1.0290480e+00, 4.3917740e-01, 1.7098800e+00, 6.1107030e-01, 1.5185960e+00,
 1.4643660e-01, 2.9224020e-01, 1.1351800e-01, 3.9959170e-01, 3.0242130e-01, 7.8956880e-01, 3.3238140e-01, 1.0475350e+00,
 9.1427250e-03, 2.7659920e-01, 1.1682310e-01, 5.2395540e-01, 3.8184770e-01, 9.3719020e-01, 5.7560640e-01, 1.0289160e+00,
 2.2634370e-01, 5.4945510e-01, 1.5506250e-01, 6.8281310e-01, 6.4847220e-01, 2.0594080e+00, 6.2985290e-01, 2.4832140e+00,
 1.9283170e-02, 7.0962220e-01, 2.1774840e-01, 1.2216980e+00, 1.2318870e+00, 3.6777470e+00, 1.6410800e+00, 3.6696720e+00,
 6.2325160e-03, 1.7414210e-02, 7.5301630e-03, 2.3339670e-02, 4.8527060e-01, 1.7738280e+00, 8.3125520e-01, 2.3067720e+00,
 1.0738780e-02, 4.5486260e-01, 2.1386220e-01, 8.4457480e-01, 7.7901110e-01, 2.6768940e+00, 1.8302280e+00, 2.8806990e+00,
 4.5386600e-01, 1.1419590e+00, 3.8909830e-01, 1.5284880e+00, 1.0585200e+00, 3.4842510e+00, 1.2865910e+00, 4.5250460e+00,
 4.1843540e-02, 1.5960130e+00, 5.9128700e-01, 2.9594760e+00, 1.6641680e+00, 5.1495280e+00, 2.7742750e+00, 5.5341970e+00,
 7.2158860e-04, 1.2897550e-03, 6.0556340e-04, 2.0823090e-03, 1.1550760e-03, 2.7009440e-03, 1.3743270e-03, 4.2311210e-03,
 3.1719160e-05, 8.5945760e-04, 4.3876290e-04, 1.9223350e-03, 1.1433570e-03, 2.5133140e-03, 1.8658310e-03, 3.2580690e-03,
 1.1679900e-03, 2.5393950e-03, 8.6622860e-04, 3.7261580e-03, 2.5937030e-03, 7.3773220e-03, 2.7272390e-03, 1.0503450e-02,
 7.0057600e-05, 2.3090390e-03, 8.5642000e-04, 4.6938510e-03, 3.8627190e-03, 1.0328360e-02, 5.5706670e-03, 1.2168540e-02,
 1.9505200e-05, 4.8811050e-05, 2.5512120e-05, 7.7245030e-05, 1.1771430e-03, 3.8537560e-03, 2.1829050e-03, 5.9175050e-03,
 2.3661810e-05, 8.9763690e-04, 5.1013160e-04, 1.9679770e-03, 1.4814340e-03, 4.5592900e-03, 3.7678960e-03, 5.7932910e-03,
 2.2719630e-03, 5.1197820e-03, 2.1085700e-03, 8.0914130e-03, 4.1070610e-03, 1.2107900e-02, 5.4041490e-03, 1.8567080e-02,
 1.4747150e-04, 5.0378290e-03, 2.2559690e-03, 1.1030200e-02, 5.0620040e-03, 1.4028780e-02, 9.1354470e-03, 1.7801990e-02,
 4.2130590e-02, 6.1852660e-02, 2.9748270e-02, 9.5967380e-02, 7.7413570e-02, 1.4868430e-01, 7.7498030e-02, 2.2383730e-01,
 2.6311340e-03, 5.8558340e-02, 3.0622820e-02, 1.2586960e-01, 6.9021990e-02, 1.2462220e-01, 9.4770270e-02, 1.5525170e-01,
 1.1426350e-01, 2.0405240e-01, 7.1300900e-02, 2.8774000e-01, 2.9126430e-01, 6.8046970e-01, 2.5768210e-01, 9.3104200e-01,
 9.7372620e-03, 2.6360650e-01, 1.0015270e-01, 5.1496950e-01, 3.9071430e-01, 8.5810580e-01, 4.7409720e-01, 9.7157210e-01,
 1.7015470e-03, 3.4974760e-03, 1.8725530e-03, 5.3190570e-03, 1.1787490e-01, 3.1697090e-01, 1.8391660e-01, 4.6773650e-01,
 2.9326130e-03, 9.1379870e-02, 5.3196500e-02, 1.9252950e-01, 1.3362060e-01, 3.3777820e-01, 2.8594620e-01, 4.1246510e-01,
 2.6126610e-01, 4.8358910e-01, 2.0401590e-01, 7.3447460e-01, 5.4214010e-01, 1.3127810e+00, 6.0020810e-01, 1.9346150e+00,
 2.4093680e-02, 6.7605440e-01, 3.1011460e-01, 1.4224890e+00, 6.0186920e-01, 1.3700700e+00, 9.1391020e-01, 1.6707780e+00,
 5.6618560e-04, 9.6624570e-04, 3.6231890e-04, 1.3855740e-03, 7.5250860e-04, 1.6800710e-03, 6.8273640e-04, 2.3376090e-03,
 3.8082290e-05, 9.8522800e-04, 4.0169210e-04, 1.9572480e-03, 8.8661630e-04, 1.8608520e-03, 1.1032870e-03, 2.1425440e-03,
 5.4172610e-02, 1.1245580e-01, 3.0636230e-02, 1.4656070e-01, 9.9883230e-02, 2.7125770e-01, 8.0086190e-02, 3.4302010e-01,
 4.9719640e-03, 1.5646420e-01, 4.6347010e-02, 2.8249940e-01, 1.7705920e-01, 4.5203080e-01, 1.9471290e-01, 4.7301970e-01,
 6.3890080e-04, 1.5265540e-03, 6.3722330e-04, 2.1457000e-03, 3.2014290e-02, 1.0007140e-01, 4.5270110e-02, 1.3647990e-01,
 1.1859410e-03, 4.2956290e-02, 1.9496630e-02, 8.3647040e-02, 4.7956780e-02, 1.4092110e-01, 9.3009840e-02, 1.5904080e-01,
 9.6370190e-02, 2.0735000e-01, 6.8201140e-02, 2.9105920e-01, 1.4464530e-01, 4.0714850e-01, 1.4513180e-01, 5.5453920e-01,
 9.5715380e-03, 3.1219650e-01, 1.1165260e-01, 6.0711690e-01, 2.1220160e-01, 5.6150980e-01, 2.9202380e-01, 6.3286400e-01,
 9.8146210e-02, 1.3312110e-01, 7.5250050e-02, 2.3099350e-01, 1.7558290e-01, 3.1156090e-01, 1.9086450e-01, 5.2456330e-01,
 5.8667150e-03, 1.2062950e-01, 7.4142370e-02, 2.8998340e-01, 1.7307770e-01, 2.8871000e-01, 2.5804480e-01, 4.0224480e-01,
 1.5359580e-01, 2.5341130e-01, 1.0407250e-01, 3.9964300e-01, 3.8119590e-01, 8.2277730e-01, 3.6619670e-01, 1.2590140e+00,
 1.2528090e-02, 3.1334050e-01, 1.3992000e-01, 6.8458850e-01, 5.6533890e-01, 1.1471040e+00, 7.4487980e-01, 1.4525290e+00,
 4.6708240e-03, 8.8698610e-03, 5.5815250e-03, 1.5086350e-02, 3.1503590e-01, 7.8265560e-01, 5.3373900e-01, 1.2916360e+00,
 7.7051380e-03, 2.2181390e-01, 1.5176720e-01, 5.2266470e-01, 3.9482160e-01, 9.2208610e-01, 9.1744670e-01, 1.2592580e+00,
 3.2556730e-01, 5.5673260e-01, 2.7605200e-01, 9.4565920e-01, 6.5774640e-01, 1.4714710e+00, 7.9071140e-01, 2.4251670e+00,
 2.8736710e-02, 7.4495150e-01, 4.0162920e-01, 1.7530040e+00, 8.0730490e-01, 1.6978170e+00, 1.3310930e+00, 2.3155520e+00,
 1.1466440e-01, 2.1436620e-01, 9.3689830e-02, 3.2260410e-01, 2.1768680e-01, 5.3241100e-01, 2.5217690e-01, 7.7743220e-01,
 5.9201860e-03, 1.6778300e-01, 7.9732850e-02, 3.4980690e-01, 1.9488710e-01, 4.4808250e-01, 3.0964730e-01, 5.4143600e-01,
 1.7428250e-01, 3.9632800e-01, 1.2584640e-01, 5.4207770e-01, 4.5900480e-01, 1.3655440e+00, 4.6990910e-01, 1.8122340e+00,
 1.2278470e-02, 4.2328270e-01, 1.4614020e-01, 8.0205490e-01, 6.1825830e-01, 1.7290930e+00, 8.6811590e-01, 1.8988940e+00,
 2.3921300e-03, 6.2612700e-03, 3.0463140e-03, 9.2361400e-03, 1.7121660e-01, 5.8628790e-01, 3.0913290e-01, 8.3915270e-01,
 3.4084500e-03, 1.3524450e-01, 7.1545930e-02, 2.7638510e-01, 1.9488520e-01, 6.2734110e-01, 4.8260220e-01, 7.4303200e-01,
 3.0832370e-01, 7.2672010e-01, 2.7860410e-01, 1.0705720e+00, 6.6102700e-01, 2.0382940e+00, 8.4685520e-01, 2.9135150e+00,
 2.3506530e-02, 8.3991180e-01, 3.5011210e-01, 1.7141510e+00, 7.3686920e-01, 2.1359840e+00, 1.2947670e+00, 2.5265170e+00,
 1.5480030e-01, 2.3770730e-01, 1.0642150e-01, 3.4378220e-01, 3.3734450e-01, 6.7769090e-01, 3.2880690e-01, 9.5098700e-01,
 1.1355120e-02, 2.6433060e-01, 1.2867300e-01, 5.2960880e-01, 2.7203440e-01, 5.1373820e-01, 3.6366560e-01, 5.9656590e-01,
 3.9423680e-01, 7.3637890e-01, 2.3951820e-01, 9.6791120e-01, 1.1918430e+00, 2.9123980e+00, 1.0266210e+00, 3.7143850e+00,
 3.9460360e-02, 1.1173530e+00, 3.9516680e-01, 2.0346570e+00, 1.4460090e+00, 3.3217170e+00, 1.7083350e+00, 3.5056820e+00,
 4.8251790e-03, 1.0373710e-02, 5.1700810e-03, 1.4705830e-02, 3.9643600e-01, 1.1150160e+00, 6.0223570e-01, 1.5336940e+00,
 9.7678440e-03, 3.1834970e-01, 1.7251260e-01, 6.2521140e-01, 4.0644820e-01, 1.0746650e+00, 8.4685630e-01, 1.2232200e+00,
 8.1983010e-01, 1.5871840e+00, 6.2330190e-01, 2.2470010e+00, 2.0175980e+00, 5.1100520e+00, 2.1747970e+00, 7.0194530e+00,
 8.8801140e-02, 2.6061950e+00, 1.1128360e+00, 5.1115170e+00, 2.0258400e+00, 4.8234270e+00, 2.9950240e+00, 5.4828630e+00,
 3.0452040e-03, 5.4356950e-03, 1.8973270e-03, 7.2656250e-03, 4.8001120e-03, 1.1209270e-02, 4.2402040e-03, 1.4537750e-02,
 2.4057760e-04, 6.5099680e-03, 2.4706950e-03, 1.2054900e-02, 5.1151150e-03, 1.1229010e-02, 6.1972930e-03, 1.2051330e-02,
 2.7359790e-01, 5.9405260e-01, 1.5064760e-01, 7.2166570e-01, 5.9828480e-01, 1.6994460e+00, 4.6705370e-01, 2.0031830e+00,
 2.9494130e-02, 9.7080650e-01, 2.6768440e-01, 1.6338450e+00, 9.5921020e-01, 2.5613750e+00, 1.0270320e+00, 2.4983890e+00,
 2.6520780e-03, 6.6278850e-03, 2.5753620e-03, 8.6837530e-03, 1.5760830e-01, 5.1529400e-01, 2.1699040e-01, 6.5507280e-01,
 5.7821650e-03, 2.1906050e-01, 9.2550900e-02, 3.9761580e-01, 2.1353300e-01, 6.5629790e-01, 4.0321590e-01, 6.9041350e-01,
 4.4265660e-01, 9.9618080e-01, 3.0500690e-01, 1.3034400e+00, 7.8797200e-01, 2.3199010e+00, 7.6977350e-01, 2.9452650e+00,
 5.1639320e-02, 1.7617200e+00, 5.8649100e-01, 3.1934250e+00, 1.0455270e+00, 2.8937010e+00, 1.4008720e+00, 3.0400620e+00,
 2.8568040e-01, 4.0528800e-01, 2.1325910e-01, 6.5552960e-01, 6.0613810e-01, 1.1249730e+00, 6.4151700e-01, 1.7655210e+00,
 2.0057490e-02, 4.3136490e-01, 2.4679810e-01, 9.6658550e-01, 5.4039380e-01, 9.4284640e-01, 7.8443690e-01, 1.2244620e+00,
 4.1981860e-01, 7.2446670e-01, 2.7695690e-01, 1.0649770e+00, 1.2357000e+00, 2.7896970e+00, 1.1557740e+00, 3.9790640e+00,
 4.0219970e-02, 1.0521640e+00, 4.3735130e-01, 2.1427530e+00, 1.6575000e+00, 3.5176900e+00, 2.1263000e+00, 4.1519780e+00,
 1.0492900e-02, 2.0841500e-02, 1.2208120e-02, 3.3042440e-02, 8.3935300e-01, 2.1810480e+00, 1.3845460e+00, 3.3551380e+00,
 2.0330930e-02, 6.1217490e-01, 3.8989580e-01, 1.3445770e+00, 9.5140470e-01, 2.3240520e+00, 2.1524800e+00, 2.9584530e+00,
 8.0930900e-01, 1.4475390e+00, 6.6812570e-01, 2.2918910e+00, 1.9391630e+00, 4.5375100e+00, 2.2696960e+00, 6.9708100e+00,
 8.3904490e-02, 2.2750250e+00, 1.1417400e+00, 4.9901850e+00, 2.1526500e+00, 4.7351800e+00, 3.4557140e+00, 6.0197140e+00,
 2.1059400e-04, 4.4396430e-04, 1.1281930e-04, 5.9308070e-04, 3.6772970e-04, 1.0141870e-03, 2.7930310e-04, 1.3145770e-03,
 8.1151880e-06, 2.5934970e-04, 7.1659610e-05, 4.7997470e-04, 3.5066560e-04, 9.0916480e-04, 3.6530150e-04, 9.7517820e-04,
 2.5991600e-04, 6.6651300e-04, 1.2305350e-04, 8.0922170e-04, 6.2961640e-04, 2.1122190e-03, 4.2261660e-04, 2.4882830e-03,
 1.3666890e-05, 5.3128840e-04, 1.0665200e-04, 8.9362660e-04, 9.0332120e-04, 2.8488200e-03, 8.3161810e-04, 2.7771520e-03,
 5.2220520e-06, 1.5413220e-05, 4.3601850e-06, 2.0182440e-05, 3.4378100e-04, 1.3274590e-03, 4.0696310e-04, 1.6865670e-03,
 5.5534050e-06, 2.4848290e-04, 7.6429540e-05, 4.5075820e-04, 4.1680050e-04, 1.5129610e-03, 6.7672550e-04, 1.5906830e-03,
 6.0613730e-04, 1.6110380e-03, 3.5910830e-04, 2.1067180e-03, 1.1952610e-03, 4.1560880e-03, 1.0039830e-03, 5.2733610e-03,
 3.4490420e-05, 1.3896910e-03, 3.3681470e-04, 2.5175950e-03, 1.4192120e-03, 4.6390540e-03, 1.6350180e-03, 4.8708620e-03,
 2.6307020e-04, 4.5553000e-04, 1.1857780e-04, 5.8480370e-04, 5.2729430e-04, 1.1944990e-03, 3.3697230e-04, 1.4879240e-03,
 1.4402490e-05, 3.7806620e-04, 1.0700590e-04, 6.7240030e-04, 4.5291500e-04, 9.6451570e-04, 3.9698040e-04, 9.9420990e-04,
 5.4402550e-04, 1.1458770e-03, 2.1670780e-04, 1.3369780e-03, 1.5127280e-03, 4.1683750e-03, 8.5432960e-04, 4.7190560e-03,
 4.0641450e-05, 1.2976960e-03, 2.6684710e-04, 2.0976170e-03, 1.9549070e-03, 5.0639830e-03, 1.5142650e-03, 4.7441040e-03,
 9.7465880e-06, 2.3629140e-05, 6.8471590e-06, 2.9734150e-05, 7.3653220e-04, 2.3360080e-03, 7.3359950e-04, 2.8522260e-03,
 1.4725970e-05, 5.4120800e-04, 1.7052180e-04, 9.4349320e-04, 8.0433570e-04, 2.3981690e-03, 1.0987930e-03, 2.4230550e-03,
 1.4913200e-03, 3.2557310e-03, 7.4339430e-04, 4.0914450e-03, 3.3756770e-03, 9.6410890e-03, 2.3857170e-03, 1.1755910e-02,
 1.2056230e-04, 3.9900130e-03, 9.9059950e-04, 6.9465530e-03, 3.6103130e-03, 9.6932630e-03, 3.4995640e-03, 9.7807880e-03,
 4.6459960e-06, 9.3517310e-06, 1.8979230e-06, 1.1095890e-05, 6.7358630e-06, 1.7737560e-05, 3.9012390e-06, 2.0420480e-05,
 2.7394510e-07, 8.3591440e-06, 1.8445970e-06, 1.3740380e-05, 7.6455870e-06, 1.8926550e-05, 6.0733920e-06, 1.8030890e-05,
 3.3895130e-04, 8.2989660e-04, 1.2236600e-04, 8.9492640e-04, 6.8172930e-04, 2.1836640e-03, 3.4893510e-04, 2.2848160e-03,
 2.7271320e-05, 1.0122270e-03, 1.6228100e-04, 1.5121960e-03, 1.1642100e-03, 3.5056230e-03, 8.1728820e-04, 3.0353190e-03,
 4.8093670e-06, 1.3553490e-05, 3.0620610e-06, 1.5762890e-05, 2.6288160e-04, 9.6919380e-04, 2.3729880e-04, 1.0936980e-03,
 7.8259690e-06, 3.3433840e-04, 8.2130070e-05, 5.3868880e-04, 3.7936710e-04, 1.3148320e-03, 4.6968450e-04, 1.2278080e-03,
 7.2289660e-04, 1.8345180e-03, 3.2658240e-04, 2.1307240e-03, 1.1835850e-03, 3.9294580e-03, 7.5809850e-04, 4.4283280e-03,
 6.2941310e-05, 2.4214000e-03, 4.6869530e-04, 3.8961770e-03, 1.6727740e-03, 5.2207200e-03, 1.4695170e-03, 4.8686810e-03,
 7.1144890e-04, 1.1381550e-03, 3.4821280e-04, 1.6341140e-03, 1.3883990e-03, 2.9057580e-03, 9.6344010e-04, 4.0480160e-03,
 3.7280850e-05, 9.0412520e-04, 3.0076330e-04, 1.7983580e-03, 1.3184590e-03, 2.5940100e-03, 1.2548390e-03, 2.9903920e-03,
 8.4895970e-04, 1.6520310e-03, 3.6720740e-04, 2.1557200e-03, 2.2983590e-03, 5.8510840e-03, 1.4094570e-03, 7.4081940e-03,
 6.0703410e-05, 1.7907270e-03, 4.3278850e-04, 3.2372050e-03, 3.2837630e-03, 7.8586930e-03, 2.7619570e-03, 8.2337940e-03,
 3.1059760e-05, 6.9567420e-05, 2.3693280e-05, 9.7904190e-05, 2.2852120e-03, 6.6960950e-03, 2.4715140e-03, 9.1436370e-03,
 4.4916470e-05, 1.5251000e-03, 5.6476900e-04, 2.9734500e-03, 2.7590570e-03, 7.6000380e-03, 4.0926850e-03, 8.5878960e-03,
 2.1573690e-03, 4.3512580e-03, 1.1677290e-03, 6.1154810e-03, 4.7544900e-03, 1.2545320e-02, 3.6486410e-03, 1.7108010e-02,
 1.6693270e-04, 5.1040710e-03, 1.4893520e-03, 9.9380100e-03, 5.6218130e-03, 1.3944860e-02, 5.9171800e-03, 1.5736410e-02,
 1.9762820e-02, 5.1973690e-02, 1.6768740e-02, 6.6121830e-02, 2.8325990e-02, 9.7455660e-02, 3.4075800e-02, 1.2030130e-01,
 8.2624020e-04, 3.2940180e-02, 1.1555690e-02, 5.8056950e-02, 4.0819650e-02, 1.3202350e-01, 6.7350600e-02, 1.3486160e-01,
 3.7134260e-02, 1.1879080e-01, 2.7845170e-02, 1.3735280e-01, 7.3836520e-02, 3.0900580e-01, 7.8497480e-02, 3.4667560e-01,
 2.1184410e-03, 1.0273290e-01, 2.6183610e-02, 1.6456250e-01, 1.6008740e-01, 6.2981440e-01, 2.3342790e-01, 5.8471320e-01,
 6.7142550e-04, 2.4721940e-03, 8.8792340e-04, 3.0828930e-03, 3.6282050e-02, 1.7476880e-01, 6.8026630e-02, 2.1146660e-01,
 7.7467710e-04, 4.3240470e-02, 1.6886380e-02, 7.4702170e-02, 6.6474950e-02, 3.0101630e-01, 1.7094500e-01, 3.0139880e-01,
 6.0508390e-02, 2.0062400e-01, 5.6778500e-02, 2.4984990e-01, 9.7940140e-02, 4.2483010e-01, 1.3029820e-01, 5.1335020e-01,
 3.7354920e-03, 1.8775870e-01, 5.7776920e-02, 3.2393920e-01, 1.7573780e-01, 7.1660480e-01, 3.2066690e-01, 7.1655880e-01,
 3.4652440e-02, 7.4853420e-02, 2.4738850e-02, 9.1516710e-02, 5.7012300e-02, 1.6111420e-01, 5.7706370e-02, 1.9112810e-01,
 2.0582800e-03, 6.7401150e-02, 2.4220790e-02, 1.1416240e-01, 7.4003470e-02, 1.9659710e-01, 1.0273500e-01, 1.9299300e-01,
 1.0909890e-01, 2.8666290e-01, 6.8831840e-02, 3.1853230e-01, 2.4900910e-01, 8.5596060e-01, 2.2273770e-01, 9.2286420e-01,
 8.8424980e-03, 3.5221770e-01, 9.1956460e-02, 5.4220070e-01, 4.8629570e-01, 1.5714440e+00, 5.9660950e-01, 1.4020280e+00,
 1.7590100e-03, 5.3198110e-03, 1.9572220e-03, 6.3752840e-03, 1.0910910e-01, 4.3169410e-01, 1.7212430e-01, 5.0197430e-01,
 2.8833980e-03, 1.3219570e-01, 5.2882800e-02, 2.1947630e-01, 1.8006380e-01, 6.6973260e-01, 3.8959980e-01, 6.4443700e-01,
 2.0896540e-01, 5.6909510e-01, 1.6498210e-01, 6.8109660e-01, 3.8825600e-01, 1.3832980e+00, 4.3460040e-01, 1.6063560e+00,
 1.8328210e-02, 7.5668540e-01, 2.3851770e-01, 1.2546020e+00, 6.2751170e-01, 2.1017420e+00, 9.6339620e-01, 2.0196640e+00,
 5.2073900e-04, 1.3075730e-03, 3.3692550e-04, 1.4775140e-03, 6.1970930e-04, 2.0357340e-03, 5.6847480e-04, 2.2319720e-03,
 3.3312690e-05, 1.2680620e-03, 3.5527250e-04, 1.9850570e-03, 1.0629810e-03, 3.2826030e-03, 1.3373950e-03, 2.9782410e-03,
 5.7838570e-02, 1.7665940e-01, 3.3071560e-02, 1.8142440e-01, 9.5487300e-02, 3.8155050e-01, 7.7409140e-02, 3.8020090e-01,
 5.0488340e-03, 2.3377350e-01, 4.7584600e-02, 3.3259920e-01, 2.4642500e-01, 9.2565920e-01, 2.7399490e-01, 7.6328350e-01,
 7.3855510e-04, 2.5964420e-03, 7.4477100e-04, 2.8758020e-03, 3.3136650e-02, 1.5240230e-01, 4.7375950e-02, 1.6378490e-01,
 1.3038810e-03, 6.9489410e-02, 2.1672840e-02, 1.0662670e-01, 7.2264980e-02, 3.1244300e-01, 1.4170600e-01, 2.7786060e-01,
 8.6190450e-02, 2.7285850e-01, 6.1672240e-02, 3.0181330e-01, 1.1583400e-01, 4.7973510e-01, 1.1751030e-01, 5.1487810e-01,
 8.1418580e-03, 3.9073910e-01, 9.6026750e-02, 5.9876250e-01, 2.4739650e-01, 9.6320590e-01, 3.4422680e-01, 8.5545210e-01,
 9.5746030e-02, 1.9107820e-01, 7.4222510e-02, 2.6126880e-01, 1.5337150e-01, 4.0042610e-01, 1.6856570e-01, 5.3125240e-01,
 5.4433670e-03, 1.6468080e-01, 6.9553770e-02, 3.1195090e-01, 2.2009840e-01, 5.4019980e-01, 3.3178160e-01, 5.9307080e-01,
 1.7394140e-01, 4.2224720e-01, 1.1916300e-01, 5.2473070e-01, 3.8653360e-01, 1.2275470e+00, 3.7543520e-01, 1.4801640e+00,
 1.3493790e-02, 4.9657240e-01, 1.5237380e-01, 8.5490760e-01, 8.3456660e-01, 2.4915640e+00, 1.1117830e+00, 2.4860930e+00,
 5.7270230e-03, 1.6001810e-02, 6.9194230e-03, 2.1446690e-02, 3.4586830e-01, 1.2642660e+00, 5.9246290e-01, 1.6441120e+00,
 8.9854780e-03, 3.8059800e-01, 1.7894530e-01, 7.0668270e-01, 6.3105130e-01, 2.1684640e+00, 1.4826080e+00, 2.3335600e+00,
 3.0884680e-01, 7.7708050e-01, 2.6477370e-01, 1.0401060e+00, 5.5869670e-01, 1.8390190e+00, 6.7907420e-01, 2.3883600e+00,
 2.5927750e-02, 9.8894630e-01, 3.6638240e-01, 1.8337960e+00, 9.9831670e-01, 3.0891470e+00, 1.6642580e+00, 3.3199060e+00,
 2.4957500e-04, 4.4608620e-04, 2.0944550e-04, 7.2020570e-04, 3.0987270e-04, 7.2458340e-04, 3.6869120e-04, 1.1350840e-03,
 9.9897350e-06, 2.7068030e-04, 1.3818540e-04, 6.0542650e-04, 3.4861710e-04, 7.6632630e-04, 5.6890440e-04, 9.9340700e-04,
 4.7480360e-04, 1.0322980e-03, 3.5213350e-04, 1.5147330e-03, 8.1781770e-04, 2.3261350e-03, 8.5992250e-04, 3.3118300e-03,
 2.5932890e-05, 8.5472630e-04, 3.1701700e-04, 1.7375010e-03, 1.3842790e-03, 3.7013660e-03, 1.9963540e-03, 4.3608260e-03,
 9.4810460e-06, 2.3725970e-05, 1.2400870e-05, 3.7547090e-05, 4.4380920e-04, 1.4529520e-03, 8.2300380e-04, 2.2310320e-03,
 1.0473080e-05, 3.9730800e-04, 2.2579210e-04, 8.7105700e-04, 6.3480980e-04, 1.9537030e-03, 1.6145830e-03, 2.4824850e-03,
 8.1781880e-04, 1.8429240e-03, 7.5900350e-04, 2.9125960e-03, 1.1466960e-03, 3.3805380e-03, 1.5088440e-03, 5.1839490e-03,
 4.8337570e-05, 1.6512780e-03, 7.3945150e-04, 3.6154290e-03, 1.6063270e-03, 4.4517570e-03, 2.8989530e-03, 5.6491100e-03,
 1.6530230e-02, 2.4268320e-02, 1.1671940e-02, 3.7653470e-02, 2.3559160e-02, 4.5248880e-02, 2.3584860e-02, 6.8120070e-02,
 9.4003720e-04, 2.0921410e-02, 1.0940750e-02, 4.4970010e-02, 2.3873950e-02, 4.3105470e-02, 3.2780000e-02, 5.3699890e-02,
 5.2692920e-02, 9.4099330e-02, 3.2880600e-02, 1.3269210e-01, 1.0418210e-01, 2.4339680e-01, 9.2170150e-02, 3.3302390e-01,
 4.0888620e-03, 1.1069340e-01, 4.2056010e-02, 2.1624550e-01, 1.5883990e-01, 3.4885200e-01, 1.9273820e-01, 3.9498020e-01,
 9.3825230e-04, 1.9285480e-03, 1.0325470e-03, 2.9329880e-03, 5.0414830e-02, 1.3556780e-01, 7.8660720e-02, 2.0004990e-01,
 1.4724860e-03, 4.5882500e-02, 2.6710350e-02, 9.6670460e-02, 6.4953830e-02, 1.6419610e-01, 1.3900020e-01, 2.0050190e-01,
 1.0668630e-01, 1.9747050e-01, 8.3308560e-02, 2.9991800e-01, 1.7171120e-01, 4.1579500e-01, 1.9010290e-01, 6.1274750e-01,
 8.9587990e-03, 2.5137850e-01, 1.1531050e-01, 5.2892660e-01, 2.1666230e-01, 4.9320110e-01, 3.2899160e-01, 6.0145070e-01,
 2.2786570e-04, 3.8887300e-04, 1.4581800e-04, 5.5763500e-04, 2.3490540e-04, 5.2445600e-04, 2.1312510e-04, 7.2971500e-04,
 1.3956100e-05, 3.6105870e-04, 1.4720900e-04, 7.1727710e-04, 3.1456580e-04, 6.6021820e-04, 3.9143910e-04, 7.6016080e-04,
 2.5624970e-02, 5.3194360e-02, 1.4491690e-02, 6.9326790e-02, 3.6646930e-02, 9.9523810e-02, 2.9383440e-02, 1.2585330e-01,
 2.1415710e-03, 6.7393750e-02, 1.9963020e-02, 1.2168080e-01, 7.3834240e-02, 1.8849820e-01, 8.1195880e-02, 1.9725060e-01,
 3.6136660e-04, 8.6342920e-04, 3.6041780e-04, 1.2136220e-03, 1.4044940e-02, 4.3902150e-02, 1.9860380e-02, 5.9874880e-02,
 6.1079920e-04, 2.2123930e-02, 1.0041410e-02, 4.3081020e-02, 2.3912240e-02, 7.0266150e-02, 4.6376610e-02, 7.9301010e-02,
 4.0365220e-02, 8.6849760e-02, 2.8566450e-02, 1.2191190e-01, 4.6992680e-02, 1.3227530e-01, 4.7150750e-02, 1.8015990e-01,
 3.6506250e-03, 1.1907310e-01, 4.2584770e-02, 2.3155690e-01, 7.8355400e-02, 2.0733730e-01, 1.0782970e-01, 2.3368490e-01,
 4.2064070e-02, 5.7053810e-02, 3.2251100e-02, 9.9000540e-02, 5.8368890e-02, 1.0357190e-01, 6.3448910e-02, 1.7438010e-01,
 2.2895680e-03, 4.7077350e-02, 2.8935100e-02, 1.1317010e-01, 6.5393500e-02, 1.0908250e-01, 9.7496370e-02, 1.5197910e-01,
 7.7371410e-02, 1.2765190e-01, 5.2424860e-02, 2.0131370e-01, 1.4893980e-01, 3.2147330e-01, 1.4307940e-01, 4.9191840e-01,
 5.7465450e-03, 1.4372710e-01, 6.4180300e-02, 3.1401590e-01, 2.5105320e-01, 5.0940090e-01, 3.3078290e-01, 6.4503250e-01,
 2.8133620e-03, 5.3425540e-03, 3.3619020e-03, 9.0869140e-03, 1.4718160e-01, 3.6564880e-01, 2.4935750e-01, 6.0343940e-01,
 4.2260380e-03, 1.2165830e-01, 8.3239780e-02, 2.8666590e-01, 2.0964700e-01, 4.8962000e-01, 4.8715660e-01, 6.6865540e-01,
 1.4521880e-01, 2.4832980e-01, 1.2313260e-01, 4.2181000e-01, 2.2756320e-01, 5.0909070e-01, 2.7356560e-01, 8.3904490e-01,
 1.1671860e-02, 3.0257360e-01, 1.6312790e-01, 7.1200970e-01, 3.1745000e-01, 6.6761880e-01, 5.2341480e-01, 9.1052570e-01,
 4.0506270e-02, 7.5726850e-02, 3.3096790e-02, 1.1396290e-01, 5.9646760e-02, 1.4588200e-01, 6.9097140e-02, 2.1301850e-01,
 1.9043630e-03, 5.3971240e-02, 2.5647890e-02, 1.1252340e-01, 6.0692080e-02, 1.3954270e-01, 9.6430940e-02, 1.6861500e-01,
 7.2362020e-02, 1.6455530e-01, 5.2251390e-02, 2.2507040e-01, 1.4782080e-01, 4.3976830e-01, 1.5133250e-01, 5.8362330e-01,
 4.6421820e-03, 1.6003250e-01, 5.5251930e-02, 3.0323680e-01, 2.2629890e-01, 6.3289380e-01, 3.1775340e-01, 6.9504550e-01,
 1.1876070e-03, 3.1084960e-03, 1.5123850e-03, 4.5854120e-03, 6.5931830e-02, 2.2576680e-01, 1.1904040e-01, 3.2313960e-01,
 1.5408690e-03, 6.1140400e-02, 3.2343990e-02, 1.2494620e-01, 8.5294740e-02, 2.7456630e-01, 2.1121880e-01, 3.2520030e-01,
 1.1335610e-01, 2.6718070e-01, 1.0242960e-01, 3.9359870e-01, 1.8850310e-01, 5.8125400e-01, 2.4149510e-01, 8.3083830e-01,
 7.8695000e-03, 2.8118520e-01, 1.1721030e-01, 5.7386250e-01, 2.3882720e-01, 6.9229530e-01, 4.1964780e-01, 8.1887120e-01,
 6.2034750e-02, 9.5258970e-02, 4.2647440e-02, 1.3776750e-01, 1.0485720e-01, 2.1064750e-01, 1.0220350e-01, 2.9559650e-01,
 4.1435800e-03, 9.6456520e-02, 4.6953910e-02, 1.9325880e-01, 9.6104270e-02, 1.8149340e-01, 1.2847570e-01, 2.1075480e-01,
 1.8568810e-01, 3.4683920e-01, 1.1281460e-01, 4.5589240e-01, 4.3541900e-01, 1.0639930e+00, 3.7505770e-01, 1.3569850e+00,
 1.6924220e-02, 4.7922330e-01, 1.6948380e-01, 8.7264770e-01, 6.0041770e-01, 1.3792560e+00, 7.0934160e-01, 1.4556430e+00,
 2.7175100e-03, 5.8424080e-03, 2.9117570e-03, 8.2822320e-03, 1.7317780e-01, 4.8707990e-01, 2.6307860e-01, 6.6997360e-01,
 5.0093030e-03, 1.6326120e-01, 8.8470680e-02, 3.2063100e-01, 2.0179870e-01, 5.3356400e-01, 4.2045840e-01, 6.0732020e-01,
 3.4192560e-01, 6.6196490e-01, 2.5995980e-01, 9.3715400e-01, 6.5268510e-01, 1.6530820e+00, 7.0353840e-01, 2.2707660e+00,
 3.3724630e-02, 9.8977280e-01, 4.2262960e-01, 1.9412360e+00, 7.4484920e-01, 1.7734500e+00, 1.1011930e+00, 2.0159080e+00,
 1.2517530e-03, 2.2343820e-03, 7.7991020e-04, 2.9865880e-03, 1.5304350e-03, 3.5738880e-03, 1.3519180e-03, 4.6351190e-03,
 9.0048860e-05, 2.4366990e-03, 9.2478830e-04, 4.5121840e-03, 1.8535880e-03, 4.0691090e-03, 2.2457420e-03, 4.3670980e-03,
 1.3218390e-01, 2.8700580e-01, 7.2782660e-02, 3.4865980e-01, 2.2419970e-01, 6.3684600e-01, 1.7502250e-01, 7.5066750e-01,
 1.2975440e-02, 4.2708990e-01, 1.1776320e-01, 7.1878220e-01, 4.0854050e-01, 1.0909240e+00, 4.3742650e-01, 1.0640970e+00,
 1.5320850e-03, 3.8288790e-03, 1.4877670e-03, 5.0165380e-03, 7.0621510e-02, 2.3089420e-01, 9.7229600e-02, 2.9352660e-01,
 3.0416410e-03, 1.1523430e-01, 4.8685330e-02, 2.0916120e-01, 1.0874700e-01, 3.3423600e-01, 2.0534770e-01, 3.5161020e-01,
 1.8937110e-01, 4.2617200e-01, 1.3048370e-01, 5.5761940e-01, 2.6146820e-01, 7.6979910e-01, 2.5542950e-01, 9.7731010e-01,
 2.0116300e-02, 6.8628470e-01, 2.2846980e-01, 1.2440110e+00, 3.9430960e-01, 1.0913300e+00, 5.2832440e-01, 1.1465280e+00,
 1.2505480e-01, 1.7741230e-01, 9.3352810e-02, 2.8695390e-01, 2.0580350e-01, 3.8196480e-01, 2.1781580e-01, 5.9945140e-01,
 7.9949760e-03, 1.7194340e-01, 9.8374470e-02, 3.8528400e-01, 2.0853830e-01, 3.6384490e-01, 3.0271460e-01, 4.7252040e-01,
 2.1599570e-01, 3.7273640e-01, 1.4249370e-01, 5.4792810e-01, 4.9312570e-01, 1.1132730e+00, 4.6123010e-01, 1.5879090e+00,
 1.8842820e-02, 4.9293270e-01, 2.0489650e-01, 1.0038670e+00, 7.5178280e-01, 1.5954990e+00, 9.6441400e-01, 1.8831890e+00,
 6.4552030e-03, 1.2821630e-02, 7.5104000e-03, 2.0327610e-02, 4.0051630e-01, 1.0407360e+00, 6.6066730e-01, 1.6009800e+00,
 1.1389170e-02, 3.4293400e-01, 2.1841550e-01, 7.5321780e-01, 5.1598260e-01, 1.2604210e+00, 1.1673710e+00, 1.6044810e+00,
 3.6870460e-01, 6.5946910e-01, 3.0438440e-01, 1.0441390e+00, 6.8523570e-01, 1.6034050e+00, 8.0203490e-01, 2.4632520e+00,
 3.4807300e-02, 9.4378090e-01, 4.7364430e-01, 2.0701500e+00, 8.6455610e-01, 1.9017630e+00, 1.3878980e+00, 2.4176630e+00,
 6.6268450e-02, 1.3970410e-01, 3.5501320e-02, 1.8662710e-01, 9.7601790e-02, 2.6918280e-01, 7.4131860e-02, 3.4891120e-01,
 2.2785150e-03, 7.2818060e-02, 2.0119990e-02, 1.3476330e-01, 1.0224950e-01, 2.6510050e-01, 1.0651710e-01, 2.8434910e-01,
 7.1207870e-02, 1.8260120e-01, 3.3712350e-02, 2.2169840e-01, 1.4549200e-01, 4.8809240e-01, 9.7658420e-02, 5.7499350e-01,
 3.3408510e-03, 1.2987260e-01, 2.6070920e-02, 2.1844570e-01, 2.2932120e-01, 7.2321430e-01, 2.1111830e-01, 7.0502030e-01,
 1.3263550e-03, 3.9148200e-03, 1.1074480e-03, 5.1261590e-03, 7.3649280e-02, 2.8438580e-01, 8.7184980e-02, 3.6131850e-01,
 1.2585490e-03, 5.6312830e-02, 1.7320970e-02, 1.0215380e-01, 9.8096530e-02, 3.5608450e-01, 1.5927150e-01, 3.7437690e-01,
 1.4292520e-01, 3.7987750e-01, 8.4676580e-02, 4.9675740e-01, 2.3772170e-01, 8.2659120e-01, 1.9967910e-01, 1.0488020e+00,
 7.2565260e-03, 2.9238060e-01, 7.0863300e-02, 5.2968320e-01, 3.1009320e-01, 1.0136180e+00, 3.5724590e-01, 1.0642670e+00,
 7.0407000e-02, 1.2191610e-01, 3.1735660e-02, 1.5651440e-01, 1.1903240e-01, 2.6964840e-01, 7.6068790e-02, 3.3588690e-01,
 3.4393320e-03, 9.0282670e-02, 2.5553130e-02, 1.6057000e-01, 1.1232280e-01, 2.3919950e-01, 9.8451010e-02, 2.4656370e-01,
 1.2676440e-01, 2.6700300e-01, 5.0495490e-02, 3.1153190e-01, 2.9730830e-01, 8.1924370e-01, 1.6790810e-01, 9.2747340e-01,
 8.4496690e-03, 2.6980090e-01, 5.5479570e-02, 4.3611060e-01, 4.2209610e-01, 1.0933960e+00, 3.2695440e-01, 1.0243290e+00,
 2.1054950e-03, 5.1044570e-03, 1.4791500e-03, 6.4232850e-03, 1.3420280e-01, 4.2564170e-01, 1.3366840e-01, 5.1970140e-01,
 2.8384290e-03, 1.0431780e-01, 3.2868060e-02, 1.8185820e-01, 1.6100740e-01, 4.8005220e-01, 2.1995020e-01, 4.8503370e-01,
 2.9908300e-01, 6.5293450e-01, 1.4908720e-01, 8.2053630e-01, 5.7101850e-01, 1.6308550e+00, 4.0356000e-01, 1.9885910e+00,
 2.1573710e-02, 7.1398280e-01, 1.7726030e-01, 1.2430330e+00, 6.7092330e-01, 1.8013500e+00, 6.5034230e-01, 1.8176150e+00,
 1.3534840e-03, 2.7243720e-03, 5.5290820e-04, 3.2324850e-03, 1.6551440e-03, 4.3584930e-03, 9.5861690e-04, 5.0177430e-03,
 7.1208260e-05, 2.1728440e-03, 4.7947760e-04, 3.5716230e-03, 2.0639170e-03, 5.1091970e-03, 1.6395050e-03, 4.8674160e-03,
 8.5969770e-02, 2.1049050e-01, 3.1036240e-02, 2.2698430e-01, 1.4584400e-01, 4.6715660e-01, 7.4648540e-02, 4.8879620e-01,
 6.1717300e-03, 2.2907550e-01, 3.6725560e-02, 3.4222270e-01, 2.7361930e-01, 8.2391160e-01, 1.9208370e-01, 7.1337790e-01,
 1.1308890e-03, 3.1870070e-03, 7.2002200e-04, 3.7065320e-03, 5.2138710e-02, 1.9222540e-01, 4.7064740e-02, 2.1691890e-01,
 1.6419600e-03, 7.0147250e-02, 1.7231640e-02, 1.1302180e-01, 8.2660610e-02, 2.8648970e-01, 1.0233990e-01, 2.6752810e-01,
 1.5780750e-01, 4.0047310e-01, 7.1292550e-02, 4.6513440e-01, 2.1793100e-01, 7.2352260e-01, 1.3958710e-01, 8.1537870e-01,
 1.2259690e-02, 4.7163960e-01, 9.1292330e-02, 7.5889620e-01, 3.3837300e-01, 1.0560600e+00, 2.9725760e-01, 9.8484890e-01,
 2.1732820e-01, 3.4767540e-01, 1.0636950e-01, 4.9917710e-01, 3.5772960e-01, 7.4868650e-01, 2.4823630e-01, 1.0429960e+00,
 1.0161330e-02, 2.4642990e-01, 8.1976570e-02, 4.9016360e-01, 3.7320370e-01, 7.3426190e-01, 3.5519550e-01, 8.4646200e-01,
 2.2578420e-01, 4.3936430e-01, 9.7660280e-02, 5.7332220e-01, 5.1557580e-01, 1.3125350e+00, 3.1617420e-01, 1.6618320e+00,
 1.4404960e-02, 4.2494060e-01, 1.0270100e-01, 7.6819080e-01, 8.0925480e-01, 1.9367060e+00, 6.8066010e-01, 2.0291470e+00,
 7.6582260e-03, 1.7152840e-02, 5.8419150e-03, 2.4139670e-02, 4.7525280e-01, 1.3925790e+00, 5.1399780e-01, 1.9015910e+00,
 9.8816180e-03, 3.3552190e-01, 1.2424910e-01, 6.5415870e-01, 6.3037310e-01, 1.7364120e+00, 9.3507260e-01, 1.9621120e+00,
 4.9382590e-01, 9.9601110e-01, 2.6729540e-01, 1.3998450e+00, 9.1795520e-01, 2.4221400e+00, 7.0444760e-01, 3.3030640e+00,
 3.4094400e-02, 1.0424580e+00, 3.0418590e-01, 2.0297440e+00, 1.1924300e+00, 2.9578110e+00, 1.2550790e+00, 3.3378120e+00,
 7.1197500e-02, 1.8724030e-01, 6.0411040e-02, 2.3821040e-01, 8.6073430e-02, 2.9613590e-01, 1.0354520e-01, 3.6555650e-01,
 2.6559180e-03, 1.0588500e-01, 3.7145340e-02, 1.8662190e-01, 1.3626750e-01, 4.4073150e-01, 2.2483520e-01, 4.5020590e-01,
 1.1647290e-01, 3.7259140e-01, 8.7337300e-02, 4.3081170e-01, 1.9533920e-01, 8.1749440e-01, 2.0767000e-01, 9.1715210e-01,
 5.9286890e-03, 2.8750920e-01, 7.3277700e-02, 4.6054620e-01, 4.6527970e-01, 1.8304990e+00, 6.7843740e-01, 1.6994160e+00,
 1.9524110e-03, 7.1887930e-03, 2.5819570e-03, 8.9646200e-03, 8.8988420e-02, 4.2865260e-01, 1.6684790e-01, 5.1866080e-01,
 2.0099560e-03, 1.1219060e-01, 4.3812940e-02, 1.9382020e-01, 1.7911770e-01, 8.1109250e-01, 4.6061360e-01, 8.1212340e-01,
 1.6334600e-01, 5.4159630e-01, 1.5327690e-01, 6.7448470e-01, 2.2300870e-01, 9.6733370e-01, 2.9668770e-01, 1.1688930e+00,
 8.9977340e-03, 4.5225710e-01, 1.3916810e-01, 7.8027680e-01, 4.3960740e-01, 1.7925840e+00, 8.0214700e-01, 1.7924690e+00,
 1.0617760e-01, 2.2935630e-01, 7.5801640e-02, 2.8041390e-01, 1.4734520e-01, 4.1639060e-01, 1.4913890e-01, 4.9396000e-01,
 5.6272470e-03, 1.8427180e-01, 6.6218580e-02, 3.1211490e-01, 2.1011550e-01, 5.5819150e-01, 2.9169190e-01, 5.4795850e-01,
 2.9104050e-01, 7.6472380e-01, 1.8362110e-01, 8.4974120e-01, 5.6029470e-01, 1.9259950e+00, 5.0118160e-01, 2.0765340e+00,
 2.1047500e-02, 8.3837190e-01, 2.1888090e-01, 1.2905820e+00, 1.2021000e+00, 3.8845350e+00, 1.4747900e+00, 3.4657460e+00,
 4.3503590e-03, 1.3156880e-02, 4.8405740e-03, 1.5767260e-02, 2.2760710e-01, 9.0053570e-01, 3.5906000e-01, 1.0471440e+00,
 6.3628780e-03, 2.9172010e-01, 1.1669800e-01, 4.8432480e-01, 4.1265770e-01, 1.5348470e+00, 8.9285800e-01, 1.4768760e+00,
 4.7978930e-01, 1.3066550e+00, 3.7880260e-01, 1.5638130e+00, 7.5190400e-01, 2.6789220e+00, 8.4165540e-01, 3.1108990e+00,
 3.7548140e-02, 1.5501860e+00, 4.8864010e-01, 2.5702450e+00, 1.3350730e+00, 4.4715960e+00, 2.0496890e+00, 4.2969680e+00,
 1.7367990e-03, 4.3610910e-03, 1.1237330e-03, 4.9278900e-03, 1.7433540e-03, 5.7268860e-03, 1.5992220e-03, 6.2789400e-03,
 9.9136010e-05, 3.7736550e-03, 1.0572640e-03, 5.9073790e-03, 3.2851990e-03, 1.0145060e-02, 4.1332920e-03, 9.2044150e-03,
 1.6795040e-01, 5.1297960e-01, 9.6032480e-02, 5.2681620e-01, 2.3387140e-01, 9.3450930e-01, 1.8959370e-01, 9.3120370e-01,
 1.3081180e-02, 6.0569090e-01, 1.2328840e-01, 8.6174150e-01, 6.6306340e-01, 2.4907010e+00, 7.3724680e-01, 2.0537910e+00,
 1.9882450e-03, 6.9898130e-03, 2.0049780e-03, 7.7418710e-03, 7.5242590e-02, 3.4605630e-01, 1.0757540e-01, 3.7190250e-01,
 3.1319680e-03, 1.6691600e-01, 5.2058930e-02, 2.5612100e-01, 1.8026930e-01, 7.7940780e-01, 3.5349420e-01, 6.9313980e-01,
 2.1540980e-01, 6.8193620e-01, 1.5413310e-01, 7.5430090e-01, 2.4418020e-01, 1.0112910e+00, 2.4771390e-01, 1.0853730e+00,
 1.8156090e-02, 8.7133580e-01, 2.1413660e-01, 1.3352220e+00, 5.7293700e-01, 2.2306550e+00, 7.9718290e-01, 1.9811120e+00,
 3.3484840e-01, 6.6824930e-01, 2.5957510e-01, 9.1372380e-01, 4.5241850e-01, 1.1811850e+00, 4.9723850e-01, 1.5670990e+00,
 1.6985860e-02, 5.1388120e-01, 2.1704040e-01, 9.7343310e-01, 7.1326540e-01, 1.7506070e+00, 1.0751940e+00, 1.9219450e+00,
 5.2962010e-01, 1.2856660e+00, 3.6282970e-01, 1.5977100e+00, 9.9269740e-01, 3.1525930e+00, 9.6419460e-01, 3.8013650e+00,
 3.6659600e-02, 1.3490760e+00, 4.1396560e-01, 2.3225930e+00, 2.3546670e+00, 7.0297590e+00, 3.1368110e+00, 7.0143240e+00,
 1.6166420e-02, 4.5170430e-02, 1.9532370e-02, 6.0540390e-02, 8.2350060e-01, 3.0101730e+00, 1.4106340e+00, 3.9145740e+00,
 2.2631770e-02, 9.5861430e-01, 4.5071060e-01, 1.7799260e+00, 1.6506560e+00, 5.6721040e+00, 3.8780930e+00, 6.1039490e+00,
 8.0937080e-01, 2.0364340e+00, 6.9387180e-01, 2.7257240e+00, 1.2349480e+00, 4.0649840e+00, 1.5010310e+00, 5.2792520e+00,
 6.0626380e-02, 2.3124350e+00, 8.5670530e-01, 4.2879320e+00, 2.4242630e+00, 7.5015300e+00, 4.0414010e+00, 8.0618940e+00,
 1.8071260e-03, 3.2300260e-03, 1.5165550e-03, 5.2148750e-03, 1.8925130e-03, 4.4253110e-03, 2.2517400e-03, 6.9324010e-03,
 6.4540700e-05, 1.7487850e-03, 8.9277450e-04, 3.9114800e-03, 2.3390690e-03, 5.1417150e-03, 3.8171000e-03, 6.6653270e-03,
 2.9931970e-03, 6.5076840e-03, 2.2198760e-03, 9.5489920e-03, 4.3485650e-03, 1.2368710e-02, 4.5724490e-03, 1.7609920e-02,
 1.4586960e-04, 4.8077380e-03, 1.7831840e-03, 9.7732450e-03, 8.0863380e-03, 2.1621720e-02, 1.1661810e-02, 2.5474000e-02,
 5.5411650e-05, 1.3866560e-04, 7.2476490e-05, 2.1944270e-04, 2.1878090e-03, 7.1624950e-03, 4.0570920e-03, 1.0998130e-02,
 5.4614990e-05, 2.0718800e-03, 1.1774600e-03, 4.5423840e-03, 3.4379180e-03, 1.0580600e-02, 8.7440390e-03, 1.3444310e-02,
 4.4373260e-03, 9.9993460e-03, 4.1182060e-03, 1.5803180e-02, 5.2478410e-03, 1.5471000e-02, 6.9052100e-03, 2.3724290e-02,
 2.3401380e-04, 7.9942320e-03, 3.5798630e-03, 1.7503160e-02, 8.0761630e-03, 2.2382190e-02, 1.4575130e-02, 2.8402150e-02,
 1.0180040e-01, 1.4945490e-01, 7.1880890e-02, 2.3188650e-01, 1.2237660e-01, 2.3504260e-01, 1.2251010e-01, 3.5384560e-01,
 5.1654470e-03, 1.1496190e-01, 6.0118780e-02, 2.4710750e-01, 1.3623910e-01, 2.4598570e-01, 1.8706240e-01, 3.0644380e-01,
 2.8252500e-01, 5.0453470e-01, 1.7629680e-01, 7.1145850e-01, 4.7115740e-01, 1.1007470e+00, 4.1683390e-01, 1.5060800e+00,
 1.9561370e-02, 5.2956420e-01, 2.0119860e-01, 1.0345320e+00, 7.8917100e-01, 1.7332160e+00, 9.5758920e-01, 1.9623970e+00,
 4.6638840e-03, 9.5864650e-03, 5.1326050e-03, 1.4579360e-02, 2.1137540e-01, 5.6839810e-01, 3.2980270e-01, 8.3875380e-01,
 6.5308800e-03, 2.0350150e-01, 1.1846770e-01, 4.2876000e-01, 2.9918500e-01, 7.5630660e-01, 6.4025150e-01, 9.2353520e-01,
 4.9233000e-01, 9.1127540e-01, 3.8444750e-01, 1.3840440e+00, 6.6836570e-01, 1.6184330e+00, 7.3995360e-01, 2.3850480e+00,
 3.6888380e-02, 1.0350660e+00, 4.7479770e-01, 2.1778870e+00, 9.2648370e-01, 2.1090090e+00, 1.4068220e+00, 2.5719020e+00,
 1.5274950e-03, 2.6068050e-03, 9.7748920e-04, 3.7380990e-03, 1.3281950e-03, 2.9653640e-03, 1.2050460e-03, 4.1259340e-03,
 8.3475150e-05, 2.1595880e-03, 8.8049630e-04, 4.2902260e-03, 1.9539760e-03, 4.1010520e-03, 2.4314870e-03, 4.7218610e-03,
 1.4955410e-01, 3.1045620e-01, 8.4577300e-02, 4.0460930e-01, 1.8040170e-01, 4.8992550e-01, 1.4464570e-01, 6.1953740e-01,
 1.1152180e-02, 3.5095130e-01, 1.0395690e-01, 6.3364970e-01, 3.9930020e-01, 1.0194100e+00, 4.3911250e-01, 1.0667440e+00,
 1.9552680e-03, 4.6718090e-03, 1.9501350e-03, 6.5666210e-03, 6.4098270e-02, 2.0036060e-01, 9.0638760e-02, 2.7325690e-01,
 2.9488270e-03, 1.0681030e-01, 4.8478100e-02, 2.0798720e-01, 1.1989070e-01, 3.5229910e-01, 2.3252210e-01, 3.9759790e-01,
 2.0276130e-01, 4.3626100e-01, 1.4349410e-01, 6.1238380e-01, 1.9910220e-01, 5.6043430e-01, 1.9977190e-01, 7.6331550e-01,
 1.6362040e-02, 5.3368330e-01, 1.9086420e-01, 1.0378340e+00, 3.6471500e-01, 9.6507760e-01, 5.0190690e-01, 1.0877150e+00,
 2.9567200e-01, 4.0103610e-01, 2.2669580e-01, 6.9588320e-01, 3.4605760e-01, 6.1405750e-01, 3.7617600e-01, 1.0338650e+00,
 1.4359680e-02, 2.9525900e-01, 1.8147480e-01, 7.0977870e-01, 4.2593210e-01, 7.1049490e-01, 6.3503000e-01, 9.8989600e-01,
 4.7349280e-01, 7.8119620e-01, 3.2082640e-01, 1.2319870e+00, 7.6879730e-01, 1.6593800e+00, 7.3854680e-01, 2.5391830e+00,
 3.1378490e-02, 7.8480880e-01, 3.5045070e-01, 1.7146560e+00, 1.4236570e+00, 2.8886810e+00, 1.8757840e+00, 3.6578120e+00,
 1.5961810e-02, 3.0311350e-02, 1.9073980e-02, 5.1555240e-02, 7.0433310e-01, 1.7498010e+00, 1.1932930e+00, 2.8877410e+00,
 2.1393520e-02, 6.1587210e-01, 4.2138560e-01, 1.4511920e+00, 1.1021790e+00, 2.5740830e+00, 2.5611320e+00, 3.5153270e+00,
 7.6488960e-01, 1.3079910e+00, 6.4855800e-01, 2.2217370e+00, 1.0109880e+00, 2.2617220e+00, 1.2153610e+00, 3.7275990e+00,
 5.4854000e-02, 1.4219990e+00, 7.6664890e-01, 3.3462170e+00, 1.5493810e+00, 3.2584520e+00, 2.5546340e+00, 4.4440090e+00,
 1.5171270e-01, 2.8362830e-01, 1.2396110e-01, 4.2683790e-01, 1.8843200e-01, 4.6086070e-01, 2.1828700e-01, 6.7295360e-01,
 6.3641690e-03, 1.8036590e-01, 8.5712390e-02, 3.7604060e-01, 2.1063890e-01, 4.8429900e-01, 3.3467480e-01, 5.8519790e-01,
 2.3596320e-01, 5.3659350e-01, 1.7038510e-01, 7.3392580e-01, 4.0657190e-01, 1.2095550e+00, 4.1623060e-01, 1.6052200e+00,
 1.3506670e-02, 4.6562290e-01, 1.6075840e-01, 8.8228310e-01, 6.8379050e-01, 1.9123680e+00, 9.6013180e-01, 2.1001670e+00,
 3.5902930e-03, 9.3973960e-03, 4.5721420e-03, 1.3862310e-02, 1.6812040e-01, 5.7568570e-01, 3.0354270e-01, 8.2397780e-01,
 4.1563800e-03, 1.6492170e-01, 8.7245530e-02, 3.3703330e-01, 2.3893870e-01, 7.6915050e-01, 5.9169360e-01, 9.1099310e-01,
 3.1814230e-01, 7.4986260e-01, 2.8747620e-01, 1.1046640e+00, 4.4623450e-01, 1.3759760e+00, 5.7168020e-01, 1.9668050e+00,
 1.9706800e-02, 7.0414390e-01, 2.9351810e-01, 1.4370660e+00, 6.2110840e-01, 1.8004250e+00, 1.0913610e+00, 2.1296060e+00,
 1.9761410e-01, 3.0345110e-01, 1.3585500e-01, 4.3886360e-01, 2.8174050e-01, 5.6598820e-01, 2.7461010e-01, 7.9423730e-01,
 1.1777440e-02, 2.7416170e-01, 1.3345870e-01, 5.4930630e-01, 2.8368240e-01, 5.3573570e-01, 3.7923720e-01, 6.2211000e-01,
 5.1499240e-01, 9.6193350e-01, 3.1288310e-01, 1.2643850e+00, 1.0185740e+00, 2.4889940e+00, 8.7737070e-01, 3.1743880e+00,
 4.1881090e-02, 1.1858980e+00, 4.1940870e-01, 2.1594750e+00, 1.5430410e+00, 3.5446130e+00, 1.8229690e+00, 3.7409220e+00,
 6.9873340e-03, 1.5022160e-02, 7.4867870e-03, 2.1295500e-02, 3.7557850e-01, 1.0563520e+00, 5.7055050e-01, 1.4530020e+00,
 1.1492380e-02, 3.7455520e-01, 2.0297020e-01, 7.3559410e-01, 4.8080150e-01, 1.2712590e+00, 1.0017750e+00, 1.4469880e+00,
 8.1619030e-01, 1.5801370e+00, 6.2053460e-01, 2.2370250e+00, 1.3141100e+00, 3.3282990e+00, 1.4164970e+00, 4.5719380e+00,
 7.1828920e-02, 2.1080830e+00, 9.0014430e-01, 4.1345720e+00, 1.6475370e+00, 3.9227060e+00, 2.4357370e+00, 4.4590000e+00,
 4.3404200e-03, 7.7476580e-03, 2.7043170e-03, 1.0355910e-02, 4.4760630e-03, 1.0452550e-02, 3.9539540e-03, 1.3556330e-02,
 2.7860170e-04, 7.5388910e-03, 2.8611970e-03, 1.3960220e-02, 5.9557070e-03, 1.3074330e-02, 7.2157240e-03, 1.4031790e-02,
 3.9904850e-01, 8.6643860e-01, 2.1972280e-01, 1.0525650e+00, 5.7088720e-01, 1.6216230e+00, 4.4566570e-01, 1.9114500e+00,
 3.4951170e-02, 1.1504260e+00, 3.1721170e-01, 1.9361400e+00, 1.1428500e+00, 3.0517480e+00, 1.2236560e+00, 2.9767030e+00,
 4.2879880e-03, 1.0716240e-02, 4.1639510e-03, 1.4040250e-02, 1.6671550e-01, 5.4506950e-01, 2.2952890e-01, 6.9292520e-01,
 7.5957560e-03, 2.8776950e-01, 1.2157970e-01, 5.2232900e-01, 2.8202970e-01, 8.6682390e-01, 5.3255880e-01, 9.1188290e-01,
 4.9204370e-01, 1.1073250e+00, 3.3903640e-01, 1.4488650e+00, 5.7302960e-01, 1.6870800e+00, 5.5979530e-01, 2.1418580e+00,
 4.6636990e-02, 1.5910610e+00, 5.2967730e-01, 2.8840760e+00, 9.4936760e-01, 2.6275620e+00, 1.2720310e+00, 2.7604610e+00,
 4.5468590e-01, 6.4505210e-01, 3.3942090e-01, 1.0433340e+00, 6.3114930e-01, 1.1713930e+00, 6.6798790e-01, 1.8383720e+00,
 2.5937060e-02, 5.5781350e-01, 3.1914350e-01, 1.2499270e+00, 7.0259300e-01, 1.2258420e+00, 1.0198860e+00, 1.5919840e+00,
 6.8373880e-01, 1.1799050e+00, 4.5106670e-01, 1.7344780e+00, 1.3166520e+00, 2.9724540e+00, 1.2314900e+00, 4.2397370e+00,
 5.3221060e-02, 1.3922760e+00, 5.7872490e-01, 2.8353970e+00, 2.2051830e+00, 4.6800290e+00, 2.8288870e+00, 5.5239030e+00,
 1.8944300e-02, 3.7628070e-02, 2.2041030e-02, 5.9656130e-02, 9.9141870e-01, 2.5761890e+00, 1.6353840e+00, 3.9629890e+00,
 2.9823140e-02, 8.9799040e-01, 5.7193240e-01, 1.9723400e+00, 1.4031720e+00, 3.4276090e+00, 3.1745670e+00, 4.3632510e+00,
 1.0045390e+00, 1.7967290e+00, 8.2929790e-01, 2.8447640e+00, 1.5746940e+00, 3.6846770e+00, 1.8431030e+00, 5.6606340e+00,
 8.4615680e-02, 2.2943080e+00, 1.1514170e+00, 5.0324820e+00, 2.1826710e+00, 4.8012180e+00, 3.5039080e+00, 6.1036660e+00,
 7.3324430e-02, 1.5457910e-01, 3.9281340e-02, 2.0649830e-01, 1.2133880e-01, 3.3464880e-01, 9.2160940e-02, 4.3376740e-01,
 2.2334580e-03, 7.1378090e-02, 1.9722120e-02, 1.3209840e-01, 1.2367780e-01, 3.2065740e-01, 1.2883980e-01, 3.4393990e-01,
 7.1193800e-02, 1.8256510e-01, 3.3705690e-02, 2.2165460e-01, 1.6343810e-01, 5.4829760e-01, 1.0970440e-01, 6.4591780e-01,
 2.9590700e-03, 1.1503120e-01, 2.3091620e-02, 1.9348250e-01, 2.5063810e-01, 7.9044200e-01, 2.3074320e-01, 7.7055670e-01,
 1.2360260e-03, 3.6482090e-03, 1.0320270e-03, 4.7770520e-03, 7.7114560e-02, 2.9776650e-01, 9.1287140e-02, 3.7831900e-01,
 1.0390150e-03, 4.6489960e-02, 1.4299600e-02, 8.4334700e-02, 9.9933320e-02, 3.6275190e-01, 1.6225370e-01, 3.8138680e-01,
 1.7710120e-01, 4.7071300e-01, 1.0492430e-01, 6.1554100e-01, 3.3096450e-01, 1.1508100e+00, 2.7800030e-01, 1.4601800e+00,
 7.9657260e-03, 3.2095570e-01, 7.7788950e-02, 5.8145050e-01, 4.2004290e-01, 1.3730160e+00, 4.8391460e-01, 1.4416240e+00,
 1.1003070e-01, 1.9052820e-01, 4.9595900e-02, 2.4459770e-01, 2.0900830e-01, 4.7347400e-01, 1.3356870e-01, 5.8978170e-01,
 4.7616360e-03, 1.2499320e-01, 3.5377420e-02, 2.2230360e-01, 1.9189110e-01, 4.0864610e-01, 1.6819270e-01, 4.2122700e-01,
 1.7900610e-01, 3.7703930e-01, 7.1305510e-02, 4.3991920e-01, 4.7171280e-01, 1.2998210e+00, 2.6640500e-01, 1.4715400e+00,
 1.0570470e-02, 3.3751870e-01, 6.9404480e-02, 5.4557080e-01, 6.5158430e-01, 1.6878610e+00, 5.0471530e-01, 1.5812430e+00,
 2.7712670e-03, 6.7185210e-03, 1.9468670e-03, 8.4543720e-03, 1.9846590e-01, 6.2946040e-01, 1.9767560e-01, 7.6856050e-01,
 3.3096810e-03, 1.2163720e-01, 3.8324990e-02, 2.1205130e-01, 2.3166420e-01, 6.9071910e-01, 3.1647350e-01, 6.9788660e-01,
 5.2343250e-01, 1.1427170e+00, 2.6092110e-01, 1.4360410e+00, 1.1228430e+00, 3.2068920e+00, 7.9355530e-01, 3.9103400e+00,
 3.3448580e-02, 1.1069820e+00, 2.7483020e-01, 1.9272390e+00, 1.2836030e+00, 3.4463210e+00, 1.2442270e+00, 3.4774400e+00,
 1.6133470e-03, 3.2474400e-03, 6.5906420e-04, 3.8531080e-03, 2.2167190e-03, 5.8372880e-03, 1.2838670e-03, 6.7202160e-03,
 7.5195010e-05, 2.2944960e-03, 5.0632230e-04, 3.7715880e-03, 2.6894020e-03, 6.6575770e-03, 2.1363690e-03, 6.3425230e-03,
 9.2596120e-02, 2.2671460e-01, 3.3428440e-02, 2.4447970e-01, 1.7649630e-01, 5.6533990e-01, 9.0337580e-02, 5.9152760e-01,
 5.8889510e-03, 2.1857960e-01, 3.5042840e-02, 3.2654260e-01, 3.2216810e-01, 9.7009990e-01, 2.2616560e-01, 8.3995400e-01,
 1.1353260e-03, 3.1995120e-03, 7.2284710e-04, 3.7210750e-03, 5.8811340e-02, 2.1682610e-01, 5.3088010e-02, 2.4467990e-01,
 1.4603170e-03, 6.2387170e-02, 1.5325380e-02, 1.0051870e-01, 9.0716880e-02, 3.1441160e-01, 1.1231420e-01, 2.9360200e-01,
 2.1065560e-01, 5.3458740e-01, 9.5167710e-02, 6.2090330e-01, 3.2686210e-01, 1.0851700e+00, 2.0935850e-01, 1.2229390e+00,
 1.4498030e-02, 5.5775020e-01, 1.0796020e-01, 8.9745320e-01, 4.9377600e-01, 1.5410720e+00, 4.3377770e-01, 1.4371560e+00,
 2.1461190e-01, 3.4332990e-01, 1.0504000e-01, 4.9293810e-01, 3.9691060e-01, 8.3068780e-01, 2.7542490e-01, 1.1572320e+00,
 8.8893960e-03, 2.1558330e-01, 7.1715230e-02, 4.2880790e-01, 4.0287700e-01, 7.9264290e-01, 3.8343710e-01, 9.1376400e-01,
 2.0146680e-01, 3.9204400e-01, 8.7142100e-02, 5.1157440e-01, 5.1689540e-01, 1.3158950e+00, 3.1698340e-01, 1.6660850e+00,
 1.1386910e-02, 3.3590950e-01, 8.1183650e-02, 6.0724380e-01, 7.8937640e-01, 1.8891340e+00, 6.6394050e-01, 1.9793030e+00,
 6.3693020e-03, 1.4265910e-02, 4.8586870e-03, 2.0076820e-02, 4.4410790e-01, 1.3013180e+00, 4.8031380e-01, 1.7769740e+00,
 7.2807430e-03, 2.4721140e-01, 9.1546320e-02, 4.8198190e-01, 5.7312610e-01, 1.5787200e+00, 8.5015450e-01, 1.7839240e+00,
 5.4611270e-01, 1.1014700e+00, 2.9559700e-01, 1.5480630e+00, 1.1405910e+00, 3.0095930e+00, 8.7530070e-01, 4.1041720e+00,
 3.3402240e-02, 1.0212940e+00, 2.9801040e-01, 1.9885370e+00, 1.4415510e+00, 3.5757550e+00, 1.5172890e+00, 4.0351460e+00,
 8.1657760e-02, 2.1474950e-01, 6.9286560e-02, 2.7320810e-01, 1.1091800e-01, 3.8161370e-01, 1.3343290e-01, 4.7107200e-01,
 2.6985550e-03, 1.0758480e-01, 3.7741660e-02, 1.8961780e-01, 1.7084950e-01, 5.5258070e-01, 2.8189410e-01, 5.6445950e-01,
 1.2070630e-01, 3.8613390e-01, 9.0511720e-02, 4.4647020e-01, 2.2745450e-01, 9.5189690e-01, 2.4181260e-01, 1.0679390e+00,
 5.4431170e-03, 2.6396160e-01, 6.7276100e-02, 4.2282650e-01, 5.2711820e-01, 2.0737830e+00, 7.6860580e-01, 1.9252790e+00,
 1.8859490e-03, 6.9440790e-03, 2.4940640e-03, 8.6594560e-03, 9.6581140e-02, 4.6522630e-01, 1.8108370e-01, 5.6291420e-01,
 1.7200030e-03, 9.6006120e-02, 3.7492560e-02, 1.6586000e-01, 1.8914110e-01, 8.5648140e-01, 4.8638960e-01, 8.5757000e-01,
 2.0980310e-01, 6.9563140e-01, 1.9687030e-01, 8.6631450e-01, 3.2182910e-01, 1.3959820e+00, 4.2815710e-01, 1.6868570e+00,
 1.0238130e-02, 5.1460360e-01, 1.5835330e-01, 8.8784290e-01, 6.1724470e-01, 2.5169340e+00, 1.1262800e+00, 2.5167730e+00,
 1.7199740e-01, 3.7153500e-01, 1.2279130e-01, 4.5424330e-01, 2.6817910e-01, 7.5786200e-01, 2.7144390e-01, 8.9904390e-01,
 8.0754920e-03, 2.6444280e-01, 9.5028270e-02, 4.4790660e-01, 3.7207970e-01, 9.8846450e-01, 5.1653800e-01, 9.7034360e-01,
 4.2600510e-01, 1.1193500e+00, 2.6877190e-01, 1.2437930e+00, 9.2146320e-01, 3.1674990e+00, 8.2424550e-01, 3.4150770e+00,
 2.7292660e-02, 1.0871310e+00, 2.8382660e-01, 1.6735200e+00, 1.9234940e+00, 6.2156880e+00, 2.3598290e+00, 5.5455800e+00,
 5.9352650e-03, 1.7950140e-02, 6.6040730e-03, 2.1511530e-02, 3.4890000e-01, 1.3804350e+00, 5.5040470e-01, 1.6051710e+00,
 7.6904650e-03, 3.5258620e-01, 1.4104660e-01, 5.8537700e-01, 6.1545150e-01, 2.2891220e+00, 1.3316380e+00, 2.2026630e+00,
 8.7038280e-01, 2.3703950e+00, 6.8718360e-01, 2.8369030e+00, 1.5325770e+00, 5.4603430e+00, 1.7155140e+00, 6.3408260e+00,
 6.0343730e-02, 2.4913090e+00, 7.8529490e-01, 4.1306490e+00, 2.6476070e+00, 8.8677030e+00, 4.0647760e+00, 8.5213950e+00,
 2.1459270e-03, 5.3884110e-03, 1.3884450e-03, 6.0887280e-03, 2.4202000e-03, 7.9503130e-03, 2.2201100e-03, 8.7166990e-03,
 1.0851280e-04, 4.1305860e-03, 1.1572650e-03, 6.4661290e-03, 4.4372720e-03, 1.3702790e-02, 5.5827800e-03, 1.2432270e-02,
 1.8750760e-01, 5.7271420e-01, 1.0721510e-01, 5.8816210e-01, 2.9336960e-01, 1.1722540e+00, 2.3782740e-01, 1.1681070e+00,
 1.2938050e-02, 5.9906350e-01, 1.2193940e-01, 8.5231240e-01, 8.0924830e-01, 3.0398230e+00, 8.9978680e-01, 2.5065880e+00,
 2.0690040e-03, 7.2737280e-03, 2.0864180e-03, 8.0563340e-03, 8.7974200e-02, 4.0461160e-01, 1.2577800e-01, 4.3483120e-01,
 2.8873060e-03, 1.5387690e-01, 4.7992210e-02, 2.3611350e-01, 2.0507000e-01, 8.8663550e-01, 4.0212640e-01, 7.8849910e-01,
 2.9805870e-01, 9.4358290e-01, 2.1327130e-01, 1.0437130e+00, 3.7961810e-01, 1.5722170e+00, 3.8511180e-01, 1.6873900e+00,
 2.2255770e-02, 1.0680850e+00, 2.6248910e-01, 1.6367170e+00, 8.6662660e-01, 3.3740970e+00, 1.2058220e+00, 2.9966370e+00,
 3.4274950e-01, 6.8401730e-01, 2.6570010e-01, 9.3528410e-01, 5.2031830e-01, 1.3584600e+00, 5.7186490e-01, 1.8022920e+00,
 1.5402810e-02, 4.6598860e-01, 1.9681270e-01, 8.8271120e-01, 7.9812080e-01, 1.9588730e+00, 1.2031070e+00, 2.1505940e+00,
 4.8985260e-01, 1.1891290e+00, 3.3558590e-01, 1.4777430e+00, 1.0316160e+00, 3.2761890e+00, 1.0019950e+00, 3.9503960e+00,
 3.0038110e-02, 1.1054050e+00, 3.3919470e-01, 1.9030840e+00, 2.3807800e+00, 7.1077180e+00, 3.1715980e+00, 7.0921120e+00,
 1.3936970e-02, 3.8941150e-02, 1.6838730e-02, 5.2191500e-02, 7.9766140e-01, 2.9157220e+00, 1.3663720e+00, 3.7917460e+00,
 1.7284510e-02, 7.3212020e-01, 3.4422010e-01, 1.3593780e+00, 1.5556080e+00, 5.3454910e+00, 3.6547830e+00, 5.7524700e+00,
 9.2778400e-01, 2.3343700e+00, 7.9538710e-01, 3.1245060e+00, 1.5905530e+00, 5.2355020e+00, 1.9332550e+00, 6.7994190e+00,
 6.1566560e-02, 2.3482960e+00, 8.6999100e-01, 4.3544290e+00, 3.0378610e+00, 9.4002210e+00, 5.0643090e+00, 1.0102420e+01,
 9.6060320e-04, 1.7169660e-03, 8.0614650e-04, 2.7720400e-03, 1.1303020e-03, 2.6430150e-03, 1.3448510e-03, 4.1403730e-03,
 3.0392980e-05, 8.2352360e-04, 4.2041810e-04, 1.8419620e-03, 1.3592130e-03, 2.9878070e-03, 2.2180840e-03, 3.8731650e-03,
 1.4376840e-03, 3.1257520e-03, 1.0662440e-03, 4.5865440e-03, 2.3467890e-03, 6.6750200e-03, 2.4676130e-03, 9.5035440e-03,
 6.2069270e-05, 2.0457510e-03, 7.5876660e-04, 4.1586340e-03, 4.2458900e-03, 1.1352910e-02, 6.1232610e-03, 1.3375620e-02,
 2.4807490e-05, 6.2079820e-05, 3.2447320e-05, 9.8243280e-05, 1.1005030e-03, 3.6028490e-03, 2.0407820e-03, 5.5322340e-03,
 2.1660950e-05, 8.2173190e-04, 4.6699440e-04, 1.8015630e-03, 1.6825420e-03, 5.1782250e-03, 4.2793970e-03, 6.5797440e-03,
 2.6414830e-03, 5.9524810e-03, 2.4515150e-03, 9.4074280e-03, 3.5100010e-03, 1.0347720e-02, 4.6185260e-03, 1.5867910e-02,
 1.2341040e-04, 4.2158690e-03, 1.8878900e-03, 9.2305360e-03, 5.2555770e-03, 1.4565250e-02, 9.4847900e-03, 1.8482750e-02,
 7.6429560e-02, 1.1220760e-01, 5.3966650e-02, 1.7409550e-01, 1.0323110e-01, 1.9827070e-01, 1.0334370e-01, 2.9848730e-01,
 3.4356100e-03, 7.6462710e-02, 3.9985830e-02, 1.6435460e-01, 1.1181570e-01, 2.0188810e-01, 1.5352790e-01, 2.5150790e-01,
 1.9166430e-01, 3.4227520e-01, 1.1959930e-01, 4.8265170e-01, 3.5912900e-01, 8.3901940e-01, 3.1772210e-01, 1.1479750e+00,
 1.1756220e-02, 3.1826350e-01, 1.2091870e-01, 6.2174500e-01, 5.8525390e-01, 1.2853630e+00, 7.1015380e-01, 1.4553250e+00,
 2.9490740e-03, 6.0617280e-03, 3.2454570e-03, 9.2188410e-03, 1.5017330e-01, 4.0382270e-01, 2.3431070e-01, 5.9589890e-01,
 3.6584210e-03, 1.1399600e-01, 6.6362380e-02, 2.4017960e-01, 2.0680770e-01, 5.2278690e-01, 4.4256530e-01, 6.3838140e-01,
 4.1394150e-01, 7.6618280e-01, 3.2323610e-01, 1.1636780e+00, 6.3138900e-01, 1.5288950e+00, 6.9901630e-01, 2.2530980e+00,
 2.7476180e-02, 7.7096510e-01, 3.5365130e-01, 1.6221910e+00, 8.5154850e-01, 1.9384300e+00, 1.2930370e+00, 2.3638830e+00,
 8.7471850e-04, 1.4927840e-03, 5.5975820e-04, 2.1406190e-03, 8.5457570e-04, 1.9079480e-03, 7.7534000e-04, 2.6546720e-03,
 4.2347690e-05, 1.0955780e-03, 4.4668360e-04, 2.1764700e-03, 1.2231980e-03, 2.5672760e-03, 1.5221220e-03, 2.9559060e-03,
 7.7385410e-02, 1.6064280e-01, 4.3763760e-02, 2.0936150e-01, 1.0488210e-01, 2.8483340e-01, 8.4094300e-02, 3.6018740e-01,
 5.1121600e-03, 1.6087610e-01, 4.7653870e-02, 2.9046510e-01, 2.2586520e-01, 5.7663200e-01, 2.4838510e-01, 6.0340640e-01,
 9.4301990e-04, 2.2531990e-03, 9.4054390e-04, 3.1670610e-03, 3.4734490e-02, 1.0857430e-01, 4.9116630e-02, 1.4807640e-01,
 1.2599340e-03, 4.5636400e-02, 2.0713050e-02, 8.8865900e-02, 6.3210440e-02, 1.8574400e-01, 1.2259360e-01, 2.0962710e-01,
 1.3003020e-01, 2.7977290e-01, 9.2022340e-02, 3.9272000e-01, 1.4346150e-01, 4.0381650e-01, 1.4394410e-01, 5.5000100e-01,
 9.2956670e-03, 3.0319840e-01, 1.0843450e-01, 5.8961850e-01, 2.5568290e-01, 6.7656630e-01, 3.5186110e-01, 7.6254130e-01,
 1.4026900e-01, 1.9025450e-01, 1.0754620e-01, 3.3013220e-01, 1.8445910e-01, 3.2731110e-01, 2.0051310e-01, 5.5108120e-01,
 6.0350430e-03, 1.2409050e-01, 7.6269660e-02, 2.9830360e-01, 2.2089240e-01, 3.6846930e-01, 3.2933250e-01, 5.1336940e-01,
 2.0297250e-01, 3.3487600e-01, 1.3752890e-01, 5.2811700e-01, 3.7028470e-01, 7.9922650e-01, 3.5571490e-01, 1.2229760e+00,
 1.1916260e-02, 2.9803800e-01, 1.3308670e-01, 6.5115550e-01, 6.6714190e-01, 1.3536680e+00, 8.7901350e-01, 1.7140920e+00,
 6.3776330e-03, 1.2111080e-02, 7.6211220e-03, 2.0599200e-02, 3.1619550e-01, 7.8553640e-01, 5.3570360e-01, 1.2963910e+00,
 7.5725760e-03, 2.1799770e-01, 1.4915620e-01, 5.1367260e-01, 4.8141360e-01, 1.1243170e+00, 1.1186600e+00, 1.5354370e+00,
 4.0636950e-01, 6.9490740e-01, 3.4456500e-01, 1.1803610e+00, 6.0348760e-01, 1.3500860e+00, 7.2548400e-01, 2.2251100e+00,
 2.5817520e-02, 6.6927630e-01, 3.6083010e-01, 1.5749270e+00, 8.9984820e-01, 1.8924410e+00, 1.4836790e+00, 2.5809890e+00,
 1.4399640e-01, 2.6920260e-01, 1.1765630e-01, 4.0512840e-01, 2.0094830e-01, 4.9147270e-01, 2.3278640e-01, 7.1765370e-01,
 5.3512510e-03, 1.5165890e-01, 7.2070450e-02, 3.1619020e-01, 2.1855320e-01, 5.0249550e-01, 3.4724940e-01, 6.0718540e-01,
 2.0237010e-01, 4.6020090e-01, 1.4612800e-01, 6.2943970e-01, 3.9177750e-01, 1.1655420e+00, 4.0108470e-01, 1.5468090e+00,
 1.0262050e-02, 3.5376940e-01, 1.2214050e-01, 6.7033810e-01, 6.4108250e-01, 1.7929260e+00, 9.0016420e-01, 1.9689950e+00,
 2.8700240e-03, 7.5121310e-03, 3.6548990e-03, 1.1081310e-02, 1.5099980e-01, 5.1706030e-01, 2.7263120e-01, 7.4006740e-01,
 2.9434370e-03, 1.1679320e-01, 6.1784960e-02, 2.3867800e-01, 2.0880020e-01, 6.7213400e-01, 5.1706050e-01, 7.9608530e-01,
 3.3815970e-01, 7.9704370e-01, 3.0556410e-01, 1.1741690e+00, 5.3292210e-01, 1.6432790e+00, 6.8273740e-01, 2.3488850e+00,
 1.8556690e-02, 6.6304930e-01, 2.7638800e-01, 1.3531980e+00, 7.2170000e-01, 2.0920120e+00, 1.2681130e+00, 2.4745060e+00,
 2.6491340e-01, 4.0679410e-01, 1.8212170e-01, 5.8832270e-01, 4.2436090e-01, 8.5249820e-01, 4.1362110e-01, 1.1962900e+00,
 1.3986880e-02, 3.2559430e-01, 1.5849550e-01, 6.5235580e-01, 4.1572610e-01, 7.8510070e-01, 5.5575810e-01, 9.1167910e-01,
 6.2381980e-01, 1.1652080e+00, 3.7900110e-01, 1.5315720e+00, 1.3862800e+00, 3.3875240e+00, 1.1941020e+00, 4.3203460e+00,
 4.4942810e-02, 1.2725930e+00, 4.5006960e-01, 2.3173440e+00, 2.0432640e+00, 4.6937070e+00, 2.4139400e+00, 4.9536560e+00,
 7.8890280e-03, 1.6960720e-02, 8.4529330e-03, 2.4043610e-02, 4.7644500e-01, 1.3400490e+00, 7.2377930e-01, 1.8432250e+00,
 1.1494920e-02, 3.7463800e-01, 2.0301500e-01, 7.3575660e-01, 5.9342610e-01, 1.5690420e+00, 1.2364350e+00, 1.7859360e+00,
 1.2253160e+00, 2.3722010e+00, 9.3158560e-01, 3.3583620e+00, 2.2166060e+00, 5.6140880e+00, 2.3893110e+00, 7.7118260e+00,
 9.5530060e-02, 2.8036800e+00, 1.1971620e+00, 5.4988430e+00, 2.7038380e+00, 6.4377090e+00, 3.9973850e+00, 7.3178420e+00,
 4.4380710e-03, 7.9219660e-03, 2.7651600e-03, 1.0588900e-02, 5.1423170e-03, 1.2008390e-02, 4.5424930e-03, 1.5574170e-02,
 2.5236560e-04, 6.8289500e-03, 2.5917570e-03, 1.2645580e-02, 6.6570940e-03, 1.4614050e-02, 8.0654990e-03, 1.5684270e-02,
 3.6868930e-01, 8.0052090e-01, 2.0300650e-01, 9.7248700e-01, 5.9263220e-01, 1.6833900e+00, 4.6264100e-01, 1.9842570e+00,
 2.8607540e-02, 9.4162420e-01, 2.5963780e-01, 1.5847310e+00, 1.1542850e+00, 3.0822820e+00, 1.2358990e+00, 3.0064860e+00,
 3.6926830e-03, 9.2284920e-03, 3.5858660e-03, 1.2091030e-02, 1.6131120e-01, 5.2740040e-01, 2.2208840e-01, 6.7046320e-01,
 5.7948670e-03, 2.1954180e-01, 9.2754210e-02, 3.9848920e-01, 2.6550470e-01, 8.1603390e-01, 5.0135440e-01, 8.5845280e-01,
 5.6342610e-01, 1.2679680e+00, 3.8822150e-01, 1.6590570e+00, 7.3724260e-01, 2.1705460e+00, 7.2021570e-01, 2.7556500e+00,
 4.7309430e-02, 1.6140020e+00, 5.3731450e-01, 2.9256600e+00, 1.1883830e+00, 3.2890850e+00, 1.5922810e+00, 3.4554430e+00,
 3.8515630e-01, 5.4641210e-01, 2.8751740e-01, 8.8378960e-01, 6.0070020e-01, 1.1148810e+00, 6.3576160e-01, 1.7496810e+00,
 1.9463920e-02, 4.1859940e-01, 2.3949450e-01, 9.3798100e-01, 6.5060630e-01, 1.1351380e+00, 9.4442160e-01, 1.4741890e+00,
 5.2334500e-01, 9.0311870e-01, 3.4525390e-01, 1.3275980e+00, 1.1323200e+00, 2.5563070e+00, 1.0590810e+00, 3.6461700e+00,
 3.6088210e-02, 9.4407620e-01, 3.9242260e-01, 1.9226300e+00, 1.8451480e+00, 3.9159330e+00, 2.3670220e+00, 4.6220300e+00,
 1.3515440e-02, 2.6845000e-02, 1.5724730e-02, 4.2560490e-02, 7.9471010e-01, 2.0650440e+00, 1.3109050e+00, 3.1766870e+00,
 1.8849020e-02, 5.6755390e-01, 3.6147660e-01, 1.2465710e+00, 1.0943370e+00, 2.6732010e+00, 2.4758530e+00, 3.4029110e+00,
 9.5293450e-01, 1.7044290e+00, 7.8669590e-01, 2.6986250e+00, 1.6783890e+00, 3.9273160e+00, 1.9644730e+00, 6.0333920e+00,
 7.1110070e-02, 1.9281110e+00, 9.6763840e-01, 4.2292420e+00, 2.2634630e+00, 4.9789360e+00, 3.6336060e+00, 6.3295950e+00,
 1.0203450e-01, 2.1510440e-01, 5.4661900e-02, 2.8735250e-01, 2.2970400e-01, 6.3351670e-01, 1.7446800e-01, 8.2115610e-01,
 4.3179630e-03, 1.3799590e-01, 3.8128940e-02, 2.5538690e-01, 1.9272530e-01, 4.9967570e-01, 2.0076920e-01, 5.3595660e-01,
 8.4491160e-02, 2.1666410e-01, 4.0001140e-02, 2.6305450e-01, 2.6387180e-01, 8.8522950e-01, 1.7711830e-01, 1.0428380e+00,
 4.8789590e-03, 1.8966520e-01, 3.8073810e-02, 3.1901680e-01, 3.3309250e-01, 1.0504800e+00, 3.0665260e-01, 1.0240530e+00,
 1.6657680e-03, 4.9166190e-03, 1.3908430e-03, 6.4379380e-03, 1.4138190e-01, 5.4592520e-01, 1.6736590e-01, 6.9361010e-01,
 1.9454130e-03, 8.7046010e-02, 2.6774020e-02, 1.5790500e-01, 1.5081540e-01, 5.4745100e-01, 2.4486690e-01, 5.7557400e-01,
 2.4816590e-01, 6.5959410e-01, 1.4702680e-01, 8.6253660e-01, 6.3091730e-01, 2.1937870e+00, 5.2995170e-01, 2.7835390e+00,
 1.5507750e-02, 6.2483950e-01, 1.5144020e-01, 1.1319730e+00, 6.5911760e-01, 2.1544920e+00, 7.5934290e-01, 2.2621500e+00,
 1.4498530e-01, 2.5105520e-01, 6.5351530e-02, 3.2230150e-01, 3.7466580e-01, 8.4874380e-01, 2.3943370e-01, 1.0572350e+00,
 8.7170410e-03, 2.2882280e-01, 6.4764800e-02, 4.0696720e-01, 2.8314800e-01, 6.0298430e-01, 2.4817950e-01, 6.2154820e-01,
 2.0116330e-01, 4.2370870e-01, 8.0131610e-02, 4.9437180e-01, 7.2115540e-01, 1.9871690e+00, 4.0728040e-01, 2.2496930e+00,
 1.6503560e-02, 5.2696460e-01, 1.0836050e-01, 8.5179420e-01, 8.1997390e-01, 2.1240560e+00, 6.3514930e-01, 1.9898850e+00,
 3.5365270e-03, 8.5737770e-03, 2.4844760e-03, 1.0788970e-02, 3.4455200e-01, 1.0927920e+00, 3.4318010e-01, 1.3342800e+00,
 5.8679640e-03, 2.1565910e-01, 6.7949060e-02, 3.7596060e-01, 3.3105950e-01, 9.8707150e-01, 4.5225620e-01, 9.9731420e-01,
 6.9453300e-01, 1.5162500e+00, 3.4621140e-01, 1.9054560e+00, 2.0268510e+00, 5.7887790e+00, 1.4324510e+00, 7.0585770e+00,
 6.1661310e-02, 2.0406830e+00, 5.0664000e-01, 3.5527990e+00, 1.9072670e+00, 5.1207860e+00, 1.8487600e+00, 5.1670240e+00,
 2.4642330e-03, 4.9601520e-03, 1.0066570e-03, 5.8852530e-03, 4.6061170e-03, 1.2129290e-02, 2.6677450e-03, 1.3963930e-02,
 1.5956800e-04, 4.8690470e-03, 1.0744440e-03, 8.0035190e-03, 4.6000050e-03, 1.1387250e-02, 3.6540860e-03, 1.0848370e-02,
 1.2061950e-01, 2.9532760e-01, 4.3545240e-02, 3.1846920e-01, 3.1277410e-01, 1.0018550e+00, 1.6008970e-01, 1.0482630e+00,
 1.0657750e-02, 3.9558240e-01, 6.3420090e-02, 5.9097250e-01, 4.6995450e-01, 1.4151090e+00, 3.2991320e-01, 1.2252620e+00,
 1.6794340e-03, 4.7328870e-03, 1.0692740e-03, 5.5044110e-03, 1.1835150e-01, 4.3633930e-01, 1.0683390e-01, 4.9239210e-01,
 3.0011820e-03, 1.2821550e-01, 3.1496070e-02, 2.0658180e-01, 1.5027240e-01, 5.2082230e-01, 1.8604830e-01, 4.8635120e-01,
 3.2400300e-01, 8.2223290e-01, 1.4637460e-01, 9.5499270e-01, 6.8392920e-01, 2.2706190e+00, 4.3806360e-01, 2.5588890e+00,
 3.0980460e-02, 1.1918420e+00, 2.3069740e-01, 1.9177440e+00, 8.5046160e-01, 2.6542860e+00, 7.4712270e-01, 2.4753050e+00,
 2.3284250e-01, 3.7249470e-01, 1.1396280e-01, 5.3481170e-01, 5.8583000e-01, 1.2260740e+00, 4.0652010e-01, 1.7080460e+00,
 1.3399340e-02, 3.2495730e-01, 1.0809920e-01, 6.4635930e-01, 4.8947390e-01, 9.6301860e-01, 4.6585540e-01, 1.1101740e+00,
 1.8641580e-01, 3.6275550e-01, 8.0631950e-02, 4.7335610e-01, 6.5065720e-01, 1.6564210e+00, 3.9901210e-01, 2.0972330e+00,
 1.4638210e-02, 4.3182150e-01, 1.0436400e-01, 7.8062980e-01, 8.1792210e-01, 1.9574490e+00, 6.8795020e-01, 2.0508800e+00,
 6.6925060e-03, 1.4989820e-02, 5.1052360e-03, 2.1095600e-02, 6.3482770e-01, 1.8601630e+00, 6.8658190e-01, 2.5400850e+00,
 1.0628590e-02, 3.6088450e-01, 1.3364130e-01, 7.0360750e-01, 6.7436610e-01, 1.8575940e+00, 1.0003300e+00, 2.0990460e+00,
 5.9664080e-01, 1.2033810e+00, 3.2294660e-01, 1.6912940e+00, 1.6952400e+00, 4.4731020e+00, 1.3009430e+00, 6.0999550e+00,
 5.0700120e-02, 1.5501880e+00, 4.5233990e-01, 3.0183330e+00, 1.7636380e+00, 4.3746870e+00, 1.8562980e+00, 4.9367200e+00,
 1.6106850e-01, 4.2358960e-01, 1.3666650e-01, 5.3889810e-01, 2.9763600e-01, 1.0240180e+00, 3.5805240e-01, 1.2640690e+00,
 7.3951540e-03, 2.9482680e-01, 1.0342770e-01, 5.1963110e-01, 3.7737710e-01, 1.2205550e+00, 6.2265530e-01, 1.2467930e+00,
 2.0305500e-01, 6.4956370e-01, 1.5226100e-01, 7.5106300e-01, 5.2053360e-01, 2.1784330e+00, 5.5339250e-01, 2.4439980e+00,
 1.2721380e-02, 6.1691800e-01, 1.5723440e-01, 9.8820920e-01, 9.9298000e-01, 3.9065730e+00, 1.4478920e+00, 3.6268220e+00,
 3.6027290e-03, 1.3265270e-02, 4.7644110e-03, 1.6542160e-02, 2.5099460e-01, 1.2090280e+00, 4.7059950e-01, 1.4628990e+00,
 4.5649260e-03, 2.5480230e-01, 9.9506050e-02, 4.4019610e-01, 4.0460960e-01, 1.8321800e+00, 1.0404820e+00, 1.8345090e+00,
 4.1672280e-01, 1.3817020e+00, 3.9103490e-01, 1.7207230e+00, 8.6962310e-01, 3.7721210e+00, 1.1569350e+00, 4.5581020e+00,
 2.8252620e-02, 1.4200740e+00, 4.3698360e-01, 2.4500460e+00, 1.3729070e+00, 5.5982950e+00, 2.5051300e+00, 5.5979360e+00,
 3.2125260e-01, 6.9394410e-01, 2.2934660e-01, 8.4842470e-01, 6.8142830e-01, 1.9256850e+00, 6.8972400e-01, 2.2844210e+00,
 2.0955430e-02, 6.8621370e-01, 2.4659280e-01, 1.1622910e+00, 7.7823250e-01, 2.0674470e+00, 1.0803780e+00, 2.0295460e+00,
 6.7859440e-01, 1.7830420e+00, 4.2813370e-01, 1.9812690e+00, 1.9968430e+00, 6.8640820e+00, 1.7861690e+00, 7.4005920e+00,
 6.0401000e-02, 2.4059150e+00, 6.2813270e-01, 3.7036440e+00, 3.4311120e+00, 1.1087490e+01, 4.2094430e+00, 9.8921590e+00,
 1.0736270e-02, 3.2469910e-02, 1.1946070e-02, 3.8912080e-02, 8.5858760e-01, 3.3970320e+00, 1.3544590e+00, 3.9500720e+00,
 1.9327190e-02, 8.8609730e-01, 3.5446920e-01, 1.4711320e+00, 1.2466820e+00, 4.6369320e+00, 2.6974170e+00, 4.4617970e+00,
 1.6370320e+00, 4.4582830e+00, 1.2924680e+00, 5.3357010e+00, 3.9213860e+00, 1.3971320e+01, 4.3894650e+00, 1.6224200e+01,
 1.5768190e-01, 6.5099450e+00, 2.0520250e+00, 1.0793640e+01, 5.5763380e+00, 1.8676980e+01, 8.5611500e+00, 1.7947600e+01,
 4.6460480e-03, 1.1666200e-02, 3.0060590e-03, 1.3182420e-02, 7.1283710e-03, 2.3416570e-02, 6.5390330e-03, 2.5673860e-02,
 3.2640170e-04, 1.2424620e-02, 3.4810030e-03, 1.9449830e-02, 1.0758050e-02, 3.3222050e-02, 1.3535300e-02, 3.0141710e-02,
 3.4622480e-01, 1.0574930e+00, 1.9796820e-01, 1.0860160e+00, 7.3692790e-01, 2.9446350e+00, 5.9740880e-01, 2.9342190e+00,
 3.3190280e-02, 1.5367920e+00, 3.1281410e-01, 2.1864570e+00, 1.6732850e+00, 6.2854480e+00, 1.8604910e+00, 5.1828780e+00,
 4.3382890e-03, 1.5251560e-02, 4.3748020e-03, 1.6892530e-02, 2.5094750e-01, 1.1541600e+00, 3.5878330e-01, 1.2403620e+00,
 8.4110980e-03, 4.4826350e-01, 1.3980760e-01, 6.8782930e-01, 4.8151290e-01, 2.0818570e+00, 9.4420950e-01, 1.8514290e+00,
 6.4981930e-01, 2.0571730e+00, 4.6496810e-01, 2.2754740e+00, 1.1259210e+00, 4.6630890e+00, 1.1422160e+00, 5.0046830e+00,
 6.7411840e-02, 3.2351880e+00, 7.9506910e-01, 4.9575520e+00, 2.1157850e+00, 8.2375300e+00, 2.9438970e+00, 7.3159980e+00,
 5.2710840e-01, 1.0519380e+00, 4.0861550e-01, 1.4383570e+00, 1.0885860e+00, 2.8421060e+00, 1.1964290e+00, 3.7706720e+00,
 3.2909860e-02, 9.9563760e-01, 4.2051260e-01, 1.8860130e+00, 1.3744860e+00, 3.3734790e+00, 2.0719340e+00, 3.7036520e+00,
 6.4247960e-01, 1.5596350e+00, 4.4014690e-01, 1.9381740e+00, 1.8406970e+00, 5.8456560e+00, 1.7878460e+00, 7.0486340e+00,
 5.4735530e-02, 2.0142720e+00, 6.1808160e-01, 3.4678050e+00, 3.4967270e+00, 1.0439330e+01, 4.6582270e+00, 1.0416410e+01,
 2.0757740e-02, 5.7998990e-02, 2.5079630e-02, 7.7734080e-02, 1.6162210e+00, 5.9078340e+00, 2.7685420e+00, 7.6828310e+00,
 3.5766100e-02, 1.5149450e+00, 7.1228000e-01, 2.8129030e+00, 2.5945400e+00, 8.9155450e+00, 6.0956770e+00, 9.5943290e+00,
 1.4367870e+00, 3.6150570e+00, 1.2317540e+00, 4.8386770e+00, 3.3509190e+00, 1.1029960e+01, 4.0729120e+00, 1.4324770e+01,
 1.3246250e-01, 5.0524380e+00, 1.8718150e+00, 9.3687010e+00, 5.2681950e+00, 1.6301670e+01, 8.7824190e+00, 1.7519400e+01,
 2.6100000e-03, 4.6650700e-03, 2.1903340e-03, 7.5317520e-03, 4.1779330e-03, 9.7693680e-03, 4.9709670e-03, 1.5304050e-02,
 1.1472880e-04, 3.1086750e-03, 1.5870140e-03, 6.9531250e-03, 4.1355430e-03, 9.0907050e-03, 6.7487470e-03, 1.1784500e-02,
 3.3314290e-03, 7.2430530e-03, 2.4707220e-03, 1.0628030e-02, 7.3979550e-03, 2.1042150e-02, 7.7788350e-03, 2.9958720e-02,
 1.9982350e-04, 6.5860160e-03, 2.4427450e-03, 1.3388150e-02, 1.1017540e-02, 2.9459340e-02, 1.5889070e-02, 3.4708010e-02,
 6.5278130e-05, 1.6335610e-04, 8.5381490e-05, 2.5851620e-04, 3.9395490e-03, 1.2897380e-02, 7.3055340e-03, 1.9804130e-02,
 7.9189070e-05, 3.0041240e-03, 1.7072590e-03, 6.5862350e-03, 4.9579200e-03, 1.5258590e-02, 1.2610030e-02, 1.9388430e-02,
 7.2271390e-03, 1.6286080e-02, 6.7073830e-03, 2.5738870e-02, 1.3064600e-02, 3.8515350e-02, 1.7190660e-02, 5.9062080e-02,
 4.6910850e-04, 1.6025390e-02, 7.1762600e-03, 3.5087170e-02, 1.6102290e-02, 4.4625710e-02, 2.9059960e-02, 5.6628330e-02,
 1.9663890e-01, 2.8868900e-01, 1.3884600e-01, 4.4791490e-01, 3.6131750e-01, 6.9396430e-01, 3.6171170e-01, 1.0447310e+00,
 1.2280460e-02, 2.7331320e-01, 1.4292790e-01, 5.8747950e-01, 3.2215090e-01, 5.8165760e-01, 4.4232760e-01, 7.2461670e-01,
 4.2055220e-01, 7.5102460e-01, 2.6242640e-01, 1.0590410e+00, 1.0720120e+00, 2.5045010e+00, 9.4841110e-01, 3.4267440e+00,
 3.5838450e-02, 9.7021620e-01, 3.6861660e-01, 1.8953700e+00, 1.4380430e+00, 3.1582990e+00, 1.7449370e+00, 3.5759170e+00,
 7.3482220e-03, 1.5104040e-02, 8.0867190e-03, 2.2970630e-02, 5.0904900e-01, 1.3688560e+00, 7.9425360e-01, 2.0199450e+00,
 1.2664640e-02, 3.9462880e-01, 2.2973190e-01, 8.3144890e-01, 5.7704780e-01, 1.4587130e+00, 1.2348740e+00, 1.7812520e+00,
 1.0724310e+00, 1.9850100e+00, 8.3743300e-01, 3.0148310e+00, 2.2253470e+00, 5.3886300e+00, 2.4637010e+00, 7.9411010e+00,
 9.8898430e-02, 2.7750310e+00, 1.2729410e+00, 5.8389530e+00, 2.4705190e+00, 5.6237880e+00, 3.7513680e+00, 6.8581180e+00,
 2.6086770e-03, 4.4519370e-03, 1.6693690e-03, 6.3839770e-03, 3.4671520e-03, 7.7408560e-03, 3.1456800e-03, 1.0770440e-02,
 1.7546260e-04, 4.5393980e-03, 1.8507800e-03, 9.0179410e-03, 4.0850480e-03, 8.5737970e-03, 5.0833490e-03, 9.8716820e-03,
 1.9682570e-01, 4.0858640e-01, 1.1131080e-01, 5.3249980e-01, 3.6290640e-01, 9.8556230e-01, 2.9097770e-01, 1.2462970e+00,
 1.8064670e-02, 5.6848250e-01, 1.6839290e-01, 1.0264070e+00, 6.4331040e-01, 1.6423660e+00, 7.0745170e-01, 1.7186250e+00,
 2.7237130e-03, 6.5078870e-03, 2.7165610e-03, 9.1473830e-03, 1.3648090e-01, 4.2661660e-01, 1.9299210e-01, 5.8183070e-01,
 5.0558120e-03, 1.8312800e-01, 8.3116520e-02, 3.5659760e-01, 2.0444570e-01, 6.0076400e-01, 3.9651240e-01, 6.7801050e-01,
 3.9049770e-01, 8.4019440e-01, 2.7635510e-01, 1.1793890e+00, 5.8611120e-01, 1.6497900e+00, 5.8808270e-01, 2.2470260e+00,
 3.8784440e-02, 1.2650390e+00, 4.5242290e-01, 2.4600730e+00, 8.5985360e-01, 2.2752710e+00, 1.1832980e+00, 2.5644020e+00,
 2.9714480e-01, 4.0303380e-01, 2.2782500e-01, 6.9934980e-01, 5.3159020e-01, 9.4327350e-01, 5.7785610e-01, 1.5881540e+00,
 1.7761910e-02, 3.6521450e-01, 2.2447140e-01, 8.7794600e-01, 5.2400550e-01, 8.7409070e-01, 7.8124950e-01, 1.2178260e+00,
 3.6670300e-01, 6.0500820e-01, 2.4846840e-01, 9.5412960e-01, 9.1008820e-01, 1.9643440e+00, 8.7427820e-01, 3.0058390e+00,
 2.9910240e-02, 7.4808630e-01, 3.3405260e-01, 1.6344240e+00, 1.3497210e+00, 2.7386600e+00, 1.7783670e+00, 3.4678470e+00,
 1.3084420e-02, 2.4847220e-02, 1.5635580e-02, 4.2261540e-02, 8.8251300e-01, 2.1924600e+00, 1.4951680e+00, 3.6182720e+00,
 2.1584470e-02, 6.2136930e-01, 4.2514690e-01, 1.4641450e+00, 1.1060170e+00, 2.5830480e+00, 2.5700520e+00, 3.5275700e+00,
 8.6686150e-01, 1.4823670e+00, 7.3502100e-01, 2.5179300e+00, 1.7513280e+00, 3.9179660e+00, 2.1053630e+00, 6.4572950e+00,
 7.6514900e-02, 1.9835220e+00, 1.0693850e+00, 4.6675810e+00, 2.1495450e+00, 4.5206380e+00, 3.5441920e+00, 6.1654310e+00,
 4.1557810e-01, 7.7692730e-01, 3.3955990e-01, 1.1692140e+00, 7.8896190e-01, 1.9296170e+00, 9.1396430e-01, 2.8176460e+00,
 2.1456520e-02, 6.0809580e-01, 2.8897560e-01, 1.2678050e+00, 7.0632890e-01, 1.6239850e+00, 1.1222540e+00, 1.9623260e+00,
 4.9810190e-01, 1.1327120e+00, 3.5967100e-01, 1.5492660e+00, 1.3118430e+00, 3.9027450e+00, 1.3430070e+00, 5.1793930e+00,
 3.5092060e-02, 1.2097480e+00, 4.1767090e-01, 2.2922850e+00, 1.7669910e+00, 4.9417740e+00, 2.4810880e+00, 5.4270680e+00,
 8.0218620e-03, 2.0996790e-02, 1.0215630e-02, 3.0972830e-02, 5.7416450e-01, 1.9660800e+00, 1.0366580e+00, 2.8140470e+00,
 1.1430030e-02, 4.5353410e-01, 2.3992490e-01, 9.2684030e-01, 6.5353550e-01, 2.1037500e+00, 1.6183770e+00, 2.4917120e+00,
 9.8275490e-01, 2.3163570e+00, 8.8802610e-01, 3.4123530e+00, 2.1069660e+00, 6.4968830e+00, 2.6992770e+00, 9.2865750e+00,
 7.4924990e-02, 2.6771450e+00, 1.1159520e+00, 5.4637070e+00, 2.3487060e+00, 6.8082610e+00, 4.1269550e+00, 8.0530510e+00,
 7.2396350e-01, 1.1117000e+00, 4.9770790e-01, 1.6077870e+00, 1.5776790e+00, 3.1693970e+00, 1.5377510e+00, 4.4475370e+00,
 5.3105140e-02, 1.2362100e+00, 6.0177280e-01, 2.4768530e+00, 1.2722390e+00, 2.4026300e+00, 1.7007760e+00, 2.7899950e+00,
 1.4539270e+00, 2.7157320e+00, 8.8333200e-01, 3.5696120e+00, 4.3954640e+00, 1.0740790e+01, 3.7861300e+00, 1.3698480e+01,
 1.4552800e-01, 4.1207450e+00, 1.4573570e+00, 7.5037240e+00, 5.3328170e+00, 1.2250340e+01, 6.3002610e+00, 1.2928790e+01,
 2.0879720e-02, 4.4889580e-02, 2.2372200e-02, 6.3635730e-02, 1.7154750e+00, 4.8249470e+00, 2.6060210e+00, 6.6366670e+00,
 4.2267840e-02, 1.3775770e+00, 7.4650410e-01, 2.7054420e+00, 1.7588000e+00, 4.6503390e+00, 3.6645540e+00, 5.2931690e+00,
 3.3719650e+00, 6.5280950e+00, 2.5636440e+00, 9.2419250e+00, 8.2983910e+00, 2.1017670e+01, 8.9449520e+00, 2.8871050e+01,
 3.6523960e-01, 1.0719290e+01, 4.5771020e+00, 2.1023700e+01, 8.3322890e+00, 1.9838780e+01, 1.2318550e+01, 2.2551040e+01,
 1.4058890e-02, 2.5095140e-02, 8.7594510e-03, 3.3543440e-02, 2.2160830e-02, 5.1750190e-02, 1.9575880e-02, 6.7116900e-02,
 1.1106820e-03, 3.0054770e-02, 1.1406540e-02, 5.5654240e-02, 2.3615110e-02, 5.1841320e-02, 2.8611230e-02, 5.5637760e-02,
 9.9606560e-01, 2.1627190e+00, 5.4845030e-01, 2.6273090e+00, 2.1781270e+00, 6.1870350e+00, 1.7003640e+00, 7.2928240e+00,
 1.0737690e-01, 3.5343360e+00, 9.7453680e-01, 5.9482050e+00, 3.4921180e+00, 9.3249900e+00, 3.7390300e+00, 9.0956810e+00,
 1.1328890e-02, 2.8312350e-02, 1.1001180e-02, 3.7094410e-02, 6.7325570e-01, 2.2011820e+00, 9.2691850e-01, 2.7982760e+00,
 2.4699690e-02, 9.3576140e-01, 3.9534990e-01, 1.6984960e+00, 9.1214950e-01, 2.8035090e+00, 1.7224180e+00, 2.9492410e+00,
 1.7972800e+00, 4.0447070e+00, 1.2383930e+00, 5.2922470e+00, 3.1993350e+00, 9.4192930e+00, 3.1254450e+00, 1.1958410e+01,
 2.0966670e-01, 7.1529580e+00, 2.3812790e+00, 1.2965990e+01, 4.2450620e+00, 1.1749050e+01, 5.6878400e+00, 1.2343300e+01,
 8.6665900e-01, 1.2295090e+00, 6.4695680e-01, 1.9886580e+00, 1.8388210e+00, 3.4127930e+00, 1.9461480e+00, 5.3560000e+00,
 6.0847710e-02, 1.3086170e+00, 7.4870290e-01, 2.9322980e+00, 1.6393740e+00, 2.8602810e+00, 2.3797200e+00, 3.7146080e+00,
 1.0043150e+00, 1.7331130e+00, 6.6255290e-01, 2.5477020e+00, 2.9561150e+00, 6.6736810e+00, 2.7649120e+00, 9.5189540e+00,
 9.6216620e-02, 2.5170500e+00, 1.0462580e+00, 5.1260230e+00, 3.9651700e+00, 8.4152270e+00, 5.0866630e+00, 9.9326090e+00,
 2.9453020e-02, 5.8500980e-02, 3.4267550e-02, 9.2748370e-02, 2.3560190e+00, 6.1220860e+00, 3.8863460e+00, 9.4176940e+00,
 5.7067830e-02, 1.7183420e+00, 1.0944170e+00, 3.7741550e+00, 2.6705420e+00, 6.5234900e+00, 6.0418950e+00, 8.3042200e+00,
 2.1592180e+00, 3.8620000e+00, 1.7825440e+00, 6.1147110e+00, 5.1736430e+00, 1.2105970e+01, 6.0554970e+00, 1.8597960e+01,
 2.2385530e-01, 6.0697130e+00, 3.0461360e+00, 1.3313700e+01, 5.7432200e+00, 1.2633350e+01, 9.2197660e+00, 1.6060460e+01,
 1.3030500e-03, 2.7470300e-03, 6.9806980e-04, 3.6696870e-03, 2.2753280e-03, 6.2752850e-03, 1.7281880e-03, 8.1339430e-03,
 5.0212730e-05, 1.6047270e-03, 4.4339380e-04, 2.9698440e-03, 2.1697440e-03, 5.6254580e-03, 2.2603030e-03, 6.0339160e-03,
 1.2682030e-03, 3.2521040e-03, 6.0041280e-04, 3.9484200e-03, 3.0720750e-03, 1.0306110e-02, 2.0620650e-03, 1.2141030e-02,
 6.6684590e-05, 2.5923050e-03, 5.2038500e-04, 4.3602550e-03, 4.4075580e-03, 1.3900190e-02, 4.0576980e-03, 1.3550510e-02,
 2.9896670e-05, 8.8241930e-05, 2.4962410e-05, 1.1554610e-04, 1.9681740e-03, 7.5998130e-03, 2.3298970e-03, 9.6557310e-03,
 3.1793690e-05, 1.4225850e-03, 4.3756530e-04, 2.5806270e-03, 2.3862160e-03, 8.6618220e-03, 3.8743080e-03, 9.1067870e-03,
 3.2983790e-03, 8.7666820e-03, 1.9541370e-03, 1.1464000e-02, 6.5041750e-03, 2.2615920e-02, 5.4633140e-03, 2.8695710e-02,
 1.8768430e-04, 7.5621930e-03, 1.8328230e-03, 1.3699840e-02, 7.7228380e-03, 2.5244050e-02, 8.8971720e-03, 2.6505460e-02,
 2.1004290e-03, 3.6370830e-03, 9.4675960e-04, 4.6692420e-03, 4.2100700e-03, 9.5372220e-03, 2.6904850e-03, 1.1880020e-02,
 1.1499370e-04, 3.0185900e-03, 8.5436570e-04, 5.3686380e-03, 3.6162050e-03, 7.7009720e-03, 3.1696070e-03, 7.9380600e-03,
 3.4252800e-03, 7.2146420e-03, 1.3644300e-03, 8.4178490e-03, 9.5243990e-03, 2.6244820e-02, 5.3790090e-03, 2.9712000e-02,
 2.5588570e-04, 8.1705200e-03, 1.6801160e-03, 1.3206960e-02, 1.2308440e-02, 3.1883720e-02, 9.5340810e-03, 2.9869710e-02,
 7.2003770e-05, 1.7456230e-04, 5.0583990e-05, 2.1966360e-04, 5.4411960e-03, 1.7257460e-02, 5.4195310e-03, 2.1071070e-02,
 1.0878940e-04, 3.9982220e-03, 1.2597450e-03, 6.9701390e-03, 5.9421000e-03, 1.7716690e-02, 8.1174280e-03, 1.7900530e-02,
 1.0471800e-02, 2.2861200e-02, 5.2199910e-03, 2.8729450e-02, 2.3703450e-02, 6.7698130e-02, 1.6752110e-02, 8.2548050e-02,
 8.4656820e-04, 2.8017210e-02, 6.9558250e-03, 4.8777540e-02, 2.5351020e-02, 6.8064480e-02, 2.4573360e-02, 6.8679070e-02,
 3.6618850e-05, 7.3708550e-05, 1.4959070e-05, 8.7455680e-05, 5.3090780e-05, 1.3980400e-04, 3.0748820e-05, 1.6095030e-04,
 2.1591830e-06, 6.5885170e-05, 1.4538760e-05, 1.0829910e-04, 6.0261060e-05, 1.4917540e-04, 4.7869310e-05, 1.4211600e-04,
 2.1067050e-03, 5.1581080e-03, 7.6054880e-04, 5.5622920e-03, 4.2371940e-03, 1.3572260e-02, 2.1687580e-03, 1.4200960e-02,
 1.6950110e-04, 6.2913550e-03, 1.0086350e-03, 9.3988440e-03, 7.2359860e-03, 2.1788720e-02, 5.0797420e-03, 1.8865600e-02,
 3.5073590e-05, 9.8842410e-05, 2.2330890e-05, 1.1495500e-04, 1.9171340e-03, 7.0681030e-03, 1.7305650e-03, 7.9760820e-03,
 5.7072960e-05, 2.4382520e-03, 5.9895540e-04, 3.9285310e-03, 2.7666350e-03, 9.5887590e-03, 3.4252990e-03, 8.9541170e-03,
 5.0109070e-03, 1.2716340e-02, 2.2637740e-03, 1.4769550e-02, 8.2042660e-03, 2.7237850e-02, 5.2549160e-03, 3.0695870e-02,
 4.3629070e-04, 1.6784440e-02, 3.2488580e-03, 2.7007150e-02, 1.1595180e-02, 3.6188500e-02, 1.0186260e-02, 3.3748270e-02,
 3.6847050e-03, 5.8946840e-03, 1.8034480e-03, 8.4633310e-03, 7.1907360e-03, 1.5049370e-02, 4.9898070e-03, 2.0965310e-02,
 1.9308330e-04, 4.6826060e-03, 1.5577000e-03, 9.3139800e-03, 6.8285040e-03, 1.3434780e-02, 6.4990100e-03, 1.5487710e-02,
 3.4672620e-03, 6.7471120e-03, 1.4997230e-03, 8.8042400e-03, 9.3867970e-03, 2.3896590e-02, 5.7564050e-03, 3.0256030e-02,
 2.4792070e-04, 7.3135620e-03, 1.7675650e-03, 1.3221170e-02, 1.3411320e-02, 3.2095930e-02, 1.1280190e-02, 3.3627890e-02,
 1.4884130e-04, 3.3337370e-04, 1.1354050e-04, 4.6916620e-04, 1.0950950e-02, 3.2088330e-02, 1.1843730e-02, 4.3817180e-02,
 2.1524400e-04, 7.3084260e-03, 2.7064270e-03, 1.4249060e-02, 1.3221660e-02, 3.6420100e-02, 1.9612540e-02, 4.1154020e-02,
 9.8264760e-03, 1.9819290e-02, 5.3188230e-03, 2.7855050e-02, 2.1655950e-02, 5.7141940e-02, 1.6618980e-02, 7.7924280e-02,
 7.6035190e-04, 2.3248240e-02, 6.7837610e-03, 4.5266070e-02, 2.5606470e-02, 6.3516620e-02, 2.6951820e-02, 7.1676850e-02,
 1.1295420e-01, 2.9705500e-01, 9.5841550e-02, 3.7791860e-01, 1.6189690e-01, 5.5700670e-01, 1.9475990e-01, 6.8758090e-01,
 4.7223670e-03, 1.8826920e-01, 6.6046440e-02, 3.3182390e-01, 2.3330430e-01, 7.5457890e-01, 3.8494160e-01, 7.7080000e-01,
 1.6736660e-01, 5.3539820e-01, 1.2550000e-01, 6.1905820e-01, 3.3278610e-01, 1.3927100e+00, 3.5379340e-01, 1.5624900e+00,
 9.5479520e-03, 4.6302380e-01, 1.1801130e-01, 7.4169410e-01, 7.2152470e-01, 2.8386160e+00, 1.0520750e+00, 2.6353410e+00,
 3.5507300e-03, 1.3073810e-02, 4.6956450e-03, 1.6303400e-02, 1.9187200e-01, 9.2423760e-01, 3.5974830e-01, 1.1183080e+00,
 4.0967600e-03, 2.2867050e-01, 8.9301000e-02, 3.9505090e-01, 3.5154250e-01, 1.5918780e+00, 9.0401590e-01, 1.5939010e+00,
 3.0414680e-01, 1.0084410e+00, 2.8539850e-01, 1.2558770e+00, 4.9229840e-01, 2.1354180e+00, 6.5494710e-01, 2.5803670e+00,
 1.8776540e-02, 9.4377360e-01, 2.9041700e-01, 1.6282880e+00, 8.8335010e-01, 3.6020310e+00, 1.6118400e+00, 3.6018000e+00,
 2.5556900e-01, 5.5205970e-01, 1.8245420e-01, 6.7495500e-01, 4.2047770e-01, 1.1882510e+00, 4.2559660e-01, 1.4096100e+00,
 1.5180250e-02, 4.9709770e-01, 1.7863340e-01, 8.4197160e-01, 5.4579110e-01, 1.4499450e+00, 7.5769210e-01, 1.4233640e+00,
 6.3450530e-01, 1.6671950e+00, 4.0031730e-01, 1.8525440e+00, 1.4482060e+00, 4.9781590e+00, 1.2954150e+00, 5.3672620e+00,
 5.1426850e-02, 2.0484540e+00, 5.3480720e-01, 3.1533710e+00, 2.8282340e+00, 9.1393210e+00, 3.4698060e+00, 8.1540170e+00,
 1.2003540e-02, 3.6302540e-02, 1.3356140e-02, 4.3505120e-02, 7.4456360e-01, 2.9458920e+00, 1.1745810e+00, 3.4254860e+00,
 1.9676390e-02, 9.0210720e-01, 3.6087370e-01, 1.4977120e+00, 1.2287600e+00, 4.5702740e+00, 2.6586400e+00, 4.3976560e+00,
 1.3553870e+00, 3.6912510e+00, 1.0701030e+00, 4.4177120e+00, 2.5182970e+00, 8.9723160e+00, 2.8188940e+00, 1.0419100e+01,
 1.1888000e-01, 4.9079950e+00, 1.5470680e+00, 8.1375720e+00, 4.0701510e+00, 1.3632270e+01, 6.2487570e+00, 1.3099890e+01,
 3.7912650e-03, 9.5198440e-03, 2.4530020e-03, 1.0757110e-02, 4.5118230e-03, 1.4821260e-02, 4.1388080e-03, 1.6249980e-02,
 2.4253460e-04, 9.2321830e-03, 2.5865780e-03, 1.4452300e-02, 7.7390810e-03, 2.3899150e-02, 9.7369690e-03, 2.1683230e-02,
 3.3206420e-01, 1.0142410e+00, 1.8987130e-01, 1.0415980e+00, 5.4821410e-01, 2.1905670e+00, 4.4442330e-01, 2.1828190e+00,
 2.8986490e-02, 1.3421460e+00, 2.7319390e-01, 1.9095270e+00, 1.4147810e+00, 5.3144180e+00, 1.5730670e+00, 4.3821820e+00,
 4.9752320e-03, 1.7490770e-02, 5.0171050e-03, 1.9372670e-02, 2.2322300e-01, 1.0266490e+00, 3.1914520e-01, 1.1033270e+00,
 8.7835140e-03, 4.6811120e-01, 1.4599780e-01, 7.1828420e-01, 4.8680860e-01, 2.1047540e+00, 9.5459410e-01, 1.8717910e+00,
 5.5187090e-01, 1.7470920e+00, 3.9488260e-01, 1.9324870e+00, 7.4167610e-01, 3.0717070e+00, 7.5240950e-01, 3.2967250e+00,
 5.2131700e-02, 2.5018720e+00, 6.1485200e-01, 3.8338310e+00, 1.5840610e+00, 6.1673340e+00, 2.2040580e+00, 5.4773940e+00,
 4.5805540e-01, 9.1413070e-01, 3.5508540e-01, 1.2499270e+00, 7.3373970e-01, 1.9156650e+00, 8.0642940e-01, 2.5415470e+00,
 2.6041430e-02, 7.8784380e-01, 3.3274990e-01, 1.4923940e+00, 1.0529650e+00, 2.5843520e+00, 1.5872650e+00, 2.8372900e+00,
 6.5620690e-01, 1.5929590e+00, 4.4955110e-01, 1.9795850e+00, 1.4582270e+00, 4.6310130e+00, 1.4163570e+00, 5.5840300e+00,
 5.0906310e-02, 1.8733560e+00, 5.7484150e-01, 3.2252020e+00, 3.1484640e+00, 9.3996090e+00, 4.1942830e+00, 9.3789700e+00,
 2.5350850e-02, 7.0832530e-02, 3.0629050e-02, 9.4934450e-02, 1.5309970e+00, 5.5963120e+00, 2.6225560e+00, 7.2777140e+00,
 3.9774510e-02, 1.6847290e+00, 7.9210710e-01, 3.1281530e+00, 2.7933690e+00, 9.5987750e+00, 6.5628100e+00, 1.0329580e+01,
 1.2994350e+00, 3.2694710e+00, 1.1140030e+00, 4.3761180e+00, 2.3506480e+00, 7.7374490e+00, 2.8571220e+00, 1.0048730e+01,
 1.0908780e-01, 4.1608710e+00, 1.5415090e+00, 7.7154740e+00, 4.2002960e+00, 1.2997210e+01, 7.0021620e+00, 1.3968100e+01,
 1.1997720e-03, 2.1444530e-03, 1.0068590e-03, 3.4622170e-03, 1.4896390e-03, 3.4832620e-03, 1.7723950e-03, 5.4566480e-03,
 4.8023270e-05, 1.3012310e-03, 6.6429320e-04, 2.9104430e-03, 1.6758940e-03, 3.6839310e-03, 2.7348720e-03, 4.7755670e-03,
 1.7999160e-03, 3.9133020e-03, 1.3348910e-03, 5.7421490e-03, 3.1002360e-03, 8.8180630e-03, 3.2598500e-03, 1.2554700e-02,
 9.8308080e-05, 3.2401520e-03, 1.2017680e-03, 6.5866300e-03, 5.2476140e-03, 1.4031380e-02, 7.5679090e-03, 1.6531300e-02,
 4.2171630e-05, 1.0553290e-04, 5.5159000e-05, 1.6700920e-04, 1.9740600e-03, 6.4627210e-03, 3.6607150e-03, 9.9236130e-03,
 4.6584210e-05, 1.7672230e-03, 1.0043220e-03, 3.8744560e-03, 2.8236300e-03, 8.6900580e-03, 7.1816520e-03, 1.1042080e-02,
 3.4575550e-03, 7.7914690e-03, 3.2088970e-03, 1.2313800e-02, 4.8479740e-03, 1.4292160e-02, 6.3790570e-03, 2.1916580e-02,
 2.0436040e-04, 6.9812330e-03, 3.1262360e-03, 1.5285230e-02, 6.7911900e-03, 1.8821030e-02, 1.2256130e-02, 2.3883170e-02,
 1.0254100e-01, 1.5054230e-01, 7.2403860e-02, 2.3357360e-01, 1.4614320e-01, 2.8068980e-01, 1.4630260e-01, 4.2256530e-01,
 5.8312790e-03, 1.2978060e-01, 6.7868150e-02, 2.7895990e-01, 1.4809590e-01, 2.6739370e-01, 2.0334230e-01, 3.3311340e-01,
 2.5775770e-01, 4.6030510e-01, 1.6084190e-01, 6.4908910e-01, 5.0962720e-01, 1.1906230e+00, 4.5086820e-01, 1.6290510e+00,
 2.0001460e-02, 5.4147820e-01, 2.0572520e-01, 1.0578070e+00, 7.7699630e-01, 1.7064770e+00, 9.4281630e-01, 1.9321220e+00,
 5.3852370e-03, 1.1069180e-02, 5.9264540e-03, 1.6834310e-02, 2.8936330e-01, 7.7811090e-01, 4.5148470e-01, 1.1482150e+00,
 8.4515500e-03, 2.6334930e-01, 1.5330800e-01, 5.5485430e-01, 3.7281200e-01, 9.4242760e-01, 7.9781220e-01, 1.1508100e+00,
 5.8202530e-01, 1.0772960e+00, 4.5448830e-01, 1.6361970e+00, 9.3676700e-01, 2.2683620e+00, 1.0371030e+00, 3.3428320e+00,
 4.8874550e-02, 1.3713910e+00, 6.2907410e-01, 2.8855490e+00, 1.1819970e+00, 2.6906490e+00, 1.7948070e+00, 3.2812030e+00,
 1.3953640e-03, 2.3813110e-03, 8.9293440e-04, 3.4147460e-03, 1.4384720e-03, 3.2115700e-03, 1.3050970e-03, 4.4684990e-03,
 8.5461870e-05, 2.2109870e-03, 9.0145220e-04, 4.3923340e-03, 1.9262820e-03, 4.0429270e-03, 2.3970250e-03, 4.6549370e-03,
 1.2374060e-01, 2.5687070e-01, 6.9979030e-02, 3.3477270e-01, 1.7696460e-01, 4.8059130e-01, 1.4188990e-01, 6.0773390e-01,
 1.0341450e-02, 3.2543820e-01, 9.6399570e-02, 5.8758530e-01, 3.5653870e-01, 9.1024050e-01, 3.9208740e-01, 9.5250520e-01,
 2.0474950e-03, 4.8921690e-03, 2.0421190e-03, 6.8763550e-03, 7.9578270e-02, 2.4874850e-01, 1.1252840e-01, 3.3924960e-01,
 3.4607740e-03, 1.2535360e-01, 5.6894410e-02, 2.4409600e-01, 1.3548620e-01, 3.9812630e-01, 2.6276880e-01, 4.4931760e-01,
 2.1738520e-01, 4.6772580e-01, 1.5384340e-01, 6.5655130e-01, 2.5307710e-01, 7.1236320e-01, 2.5392840e-01, 9.7024370e-01,
 1.9660290e-02, 6.4126300e-01, 2.2933850e-01, 1.2470400e+00, 4.2197970e-01, 1.1166070e+00, 5.8071240e-01, 1.2585000e+00,
 1.6925940e-01, 2.2957580e-01, 1.2977350e-01, 3.9836310e-01, 2.3486750e-01, 4.1675770e-01, 2.5530870e-01, 7.0167900e-01,
 9.2128750e-03, 1.8943210e-01, 1.1643050e-01, 4.5537930e-01, 2.6313350e-01, 4.3893150e-01, 3.9231050e-01, 6.1154060e-01,
 2.4550630e-01, 4.0505070e-01, 1.6634870e-01, 6.3878620e-01, 4.7259910e-01, 1.0200630e+00, 4.5400340e-01, 1.5609000e+00,
 1.8234290e-02, 4.5605860e-01, 2.0364970e-01, 9.9640000e-01, 7.9661370e-01, 1.6163740e+00, 1.0496030e+00, 2.0467450e+00,
 1.0474510e-02, 1.9891010e-02, 1.2516790e-02, 3.3831740e-02, 5.4797590e-01, 1.3613570e+00, 9.2838960e-01, 2.2466820e+00,
 1.5734080e-02, 4.5294930e-01, 3.0991230e-01, 1.0672940e+00, 7.8054240e-01, 1.8229180e+00, 1.8137460e+00, 2.4894890e+00,
 5.1390020e-01, 8.7878920e-01, 4.3574140e-01, 1.4927010e+00, 8.0530020e-01, 1.8015690e+00, 9.6809350e-01, 2.9692110e+00,
 4.1304360e-02, 1.0707470e+00, 5.7727680e-01, 2.5196590e+00, 1.1233920e+00, 2.3625680e+00, 1.8522600e+00, 3.2221670e+00,
 1.9511610e-01, 3.6477140e-01, 1.5942510e-01, 5.4895180e-01, 2.8731460e-01, 7.0270440e-01, 3.3283650e-01, 1.0260960e+00,
 9.1731930e-03, 2.5997600e-01, 1.2354420e-01, 5.4201790e-01, 2.9234990e-01, 6.7216810e-01, 4.6450170e-01, 8.1220760e-01,
 2.7486670e-01, 6.2506210e-01, 1.9847660e-01, 8.5492860e-01, 5.6149630e-01, 1.6704570e+00, 5.7483540e-01, 2.2168890e+00,
 1.7633300e-02, 6.0788250e-01, 2.0987410e-01, 1.1518430e+00, 8.5959490e-01, 2.4040430e+00, 1.2069840e+00, 2.6401260e+00,
 5.2930980e-03, 1.3854390e-02, 6.7406180e-03, 2.0436930e-02, 2.9385450e-01, 1.0062300e+00, 5.3055650e-01, 1.4402150e+00,
 6.8675660e-03, 2.7249940e-01, 1.4415540e-01, 5.5687850e-01, 3.8015390e-01, 1.2237270e+00, 9.4139070e-01, 1.4494000e+00,
 4.8020870e-01, 1.1318540e+00, 4.3392080e-01, 1.6673960e+00, 7.9855260e-01, 2.4623570e+00, 1.0230420e+00, 3.5196680e+00,
 3.3337440e-02, 1.1911800e+00, 4.9653630e-01, 2.4310450e+00, 1.0117400e+00, 2.9327600e+00, 1.7777480e+00, 3.4689720e+00,
 3.8559100e-01, 5.9210360e-01, 2.6508480e-01, 8.5632500e-01, 6.5176360e-01, 1.3093270e+00, 6.3526870e-01, 1.8373470e+00,
 2.5755360e-02, 5.9954730e-01, 2.9185270e-01, 1.2012440e+00, 5.9735780e-01, 1.1281130e+00, 7.9857010e-01, 1.3099940e+00,
 9.1015720e-01, 1.7000460e+00, 5.5296510e-01, 2.2345740e+00, 2.1342230e+00, 5.2152040e+00, 1.8383600e+00, 6.6513140e+00,
 8.2954720e-02, 2.3489310e+00, 8.3073130e-01, 4.2773160e+00, 2.9429710e+00, 6.7604790e+00, 3.4768650e+00, 7.1348900e+00,
 1.5628930e-02, 3.3600840e-02, 1.6746090e-02, 4.7632750e-02, 9.9597940e-01, 2.8012920e+00, 1.5130170e+00, 3.8531500e+00,
 2.8809490e-02, 9.3894750e-01, 5.0881230e-01, 1.8440120e+00, 1.1605840e+00, 3.0686320e+00, 2.4181390e+00, 3.4928180e+00,
 1.8691230e+00, 3.6186050e+00, 1.4210600e+00, 5.1229150e+00, 3.5678770e+00, 9.0365060e+00, 3.8458640e+00, 1.2413050e+01,
 1.8435430e-01, 5.4105530e+00, 2.3102880e+00, 1.0611690e+01, 4.0716890e+00, 9.6944950e+00, 6.0196300e+00, 1.1019880e+01,
 7.6806880e-03, 1.3710040e-02, 4.7854860e-03, 1.8325540e-02, 9.3906660e-03, 2.1929180e-02, 8.2952950e-03, 2.8440840e-02,
 5.5253490e-04, 1.4951450e-02, 5.6744500e-03, 2.7686510e-02, 1.1373520e-02, 2.4967830e-02, 1.3779750e-02, 2.6796270e-02,
 6.3958840e-01, 1.3887140e+00, 3.5216800e-01, 1.6870340e+00, 1.0848180e+00, 3.0814600e+00, 8.4686830e-01, 3.6321990e+00,
 6.2783300e-02, 2.0665280e+00, 5.6981210e-01, 3.4779180e+00, 1.9767740e+00, 5.2785730e+00, 2.1165430e+00, 5.1487690e+00,
 8.6982280e-03, 2.1737990e-02, 8.4466170e-03, 2.8480790e-02, 4.0094510e-01, 1.3108740e+00, 5.5200930e-01, 1.6664620e+00,
 1.7268550e-02, 6.5422860e-01, 2.7640510e-01, 1.1874870e+00, 6.1739790e-01, 1.8975840e+00, 1.1658370e+00, 1.9962240e+00,
 1.0219020e+00, 2.2997500e+00, 7.0412870e-01, 3.0090790e+00, 1.4109600e+00, 4.1540640e+00, 1.3783730e+00, 5.2738550e+00,
 1.0855350e-01, 3.7033950e+00, 1.2328910e+00, 6.7130510e+00, 2.1278120e+00, 5.8891380e+00, 2.8509950e+00, 6.1870040e+00,
 5.0421410e-01, 7.1531660e-01, 3.7639340e-01, 1.1569830e+00, 8.2978850e-01, 1.5400610e+00, 8.7822130e-01, 2.4169550e+00,
 3.2235310e-02, 6.9326640e-01, 3.9664050e-01, 1.5534440e+00, 8.4081490e-01, 1.4670030e+00, 1.2205290e+00, 1.9051770e+00,
 6.8675250e-01, 1.1851050e+00, 4.5305480e-01, 1.7421230e+00, 1.5678800e+00, 3.5396220e+00, 1.4664690e+00, 5.0487140e+00,
 5.9910250e-02, 1.5672660e+00, 6.5146300e-01, 3.1917700e+00, 2.3902730e+00, 5.0728450e+00, 3.0663290e+00, 5.9875490e+00,
 2.4081910e-02, 4.7832630e-02, 2.8018450e-02, 7.5834600e-02, 1.4941740e+00, 3.8825920e+00, 2.4646990e+00, 5.9726490e+00,
 4.2488680e-02, 1.2793560e+00, 8.1482550e-01, 2.8099700e+00, 1.9249350e+00, 4.7021520e+00, 4.3550170e+00, 5.9857080e+00,
 1.3073970e+00, 2.3384250e+00, 1.0793230e+00, 3.7024320e+00, 2.4297910e+00, 5.6855450e+00, 2.8439520e+00, 8.7344940e+00,
 1.2342390e-01, 3.3465720e+00, 1.6795050e+00, 7.3405850e+00, 3.0656470e+00, 6.7434990e+00, 4.9213760e+00, 8.5728380e+00,
 2.1539990e-01, 4.5409600e-01, 1.1539400e-01, 6.0661530e-01, 3.1724620e-01, 8.7495550e-01, 2.4095920e-01, 1.1341060e+00,
 7.4061180e-03, 2.3668880e-01, 6.5398290e-02, 4.3803650e-01, 3.3235310e-01, 8.6168630e-01, 3.4622470e-01, 9.2425230e-01,
 1.8251860e-01, 4.6803980e-01, 8.6410860e-02, 5.6825300e-01, 3.7292230e-01, 1.2510690e+00, 2.5031620e-01, 1.4738120e+00,
 8.5632050e-03, 3.3288710e-01, 6.6824480e-02, 5.5991580e-01, 5.8779160e-01, 1.8537290e+00, 5.4113430e-01, 1.8070940e+00,
 3.9890070e-03, 1.1773810e-02, 3.3306460e-03, 1.5416900e-02, 2.2149990e-01, 8.5528920e-01, 2.6220850e-01, 1.0866640e+00,
 3.7850820e-03, 1.6936060e-01, 5.2092740e-02, 3.0722720e-01, 2.9502490e-01, 1.0709230e+00, 4.7900830e-01, 1.1259370e+00,
 4.0856570e-01, 1.0859170e+00, 2.4205620e-01, 1.4200290e+00, 6.7955050e-01, 2.3628910e+00, 5.7080220e-01, 2.9981030e+00,
 2.0743490e-02, 8.3579830e-01, 2.0256960e-01, 1.5141510e+00, 8.8643160e-01, 2.8975250e+00, 1.0212220e+00, 3.0423120e+00,
 2.9530820e-01, 5.1135300e-01, 1.3310900e-01, 6.5646850e-01, 4.9925800e-01, 1.1309870e+00, 3.1905550e-01, 1.4088110e+00,
 1.4425600e-02, 3.7867280e-01, 1.0717750e-01, 6.7347910e-01, 4.7111560e-01, 1.0032750e+00, 4.1293330e-01, 1.0341630e+00,
 4.1927380e-01, 8.8311320e-01, 1.6701400e-01, 1.0303930e+00, 9.8334830e-01, 2.7096510e+00, 5.5535670e-01, 3.0676210e+00,
 2.7947310e-02, 8.9236740e-01, 1.8349880e-01, 1.4424370e+00, 1.3960840e+00, 3.6164090e+00, 1.0814030e+00, 3.3879700e+00,
 8.1710970e-03, 1.9809600e-02, 5.7403480e-03, 2.4927760e-02, 5.2082000e-01, 1.6518490e+00, 5.1874630e-01, 2.0168790e+00,
 1.1015500e-02, 4.0484090e-01, 1.2755580e-01, 7.0576310e-01, 6.2484470e-01, 1.8630080e+00, 8.5359240e-01, 1.8823400e+00,
 1.1032290e+00, 2.4084830e+00, 5.4993870e-01, 3.0267170e+00, 2.1063190e+00, 6.0157440e+00, 1.4886140e+00, 7.3353280e+00,
 7.9579080e-02, 2.6336720e+00, 6.5386120e-01, 4.5851850e+00, 2.4748390e+00, 6.6446490e+00, 2.3989210e+00, 6.7046470e+00,
 5.6040570e-03, 1.1280170e-02, 2.2892980e-03, 1.3384000e-02, 6.8530690e-03, 1.8046190e-02, 3.9691220e-03, 2.0775800e-02,
 2.9483540e-04, 8.9965890e-03, 1.9852610e-03, 1.4788190e-02, 8.5455790e-03, 2.1154460e-02, 6.7883150e-03, 2.0153380e-02,
 2.8069560e-01, 6.8726190e-01, 1.0133490e-01, 7.4111500e-01, 4.7618800e-01, 1.5252900e+00, 2.4373120e-01, 1.5959440e+00,
 2.0151010e-02, 7.4794290e-01, 1.1991080e-01, 1.1173740e+00, 8.9338070e-01, 2.6901130e+00, 6.2716310e-01, 2.3292150e+00,
 4.3324700e-03, 1.2209520e-02, 2.7584270e-03, 1.4199840e-02, 1.9974500e-01, 7.3642150e-01, 1.8030650e-01, 8.3102330e-01,
 6.2903990e-03, 2.6873630e-01, 6.6014950e-02, 4.3299010e-01, 3.1667540e-01, 1.0975510e+00, 3.9206750e-01, 1.0249090e+00,
 5.7463380e-01, 1.4582670e+00, 2.5960180e-01, 1.6937220e+00, 7.9356530e-01, 2.6346060e+00, 5.0828670e-01, 2.9690870e+00,
 4.4641950e-02, 1.7174100e+00, 3.3242830e-01, 2.7634140e+00, 1.2321380e+00, 3.8454960e+00, 1.0824220e+00, 3.5861900e+00,
 5.9128740e-01, 9.4592440e-01, 2.8940070e-01, 1.3581170e+00, 9.7327910e-01, 2.0369600e+00, 6.7537940e-01, 2.8376920e+00,
 2.7646050e-02, 6.7046470e-01, 2.2303460e-01, 1.3335940e+00, 1.0153800e+00, 1.9977150e+00, 9.6638460e-01, 2.3029790e+00,
 4.8441390e-01, 9.4264420e-01, 2.0952750e-01, 1.2300470e+00, 1.1061540e+00, 2.8160090e+00, 6.7834310e-01, 3.5654150e+00,
 3.0905450e-02, 9.1169860e-01, 2.2034220e-01, 1.6481330e+00, 1.7362340e+00, 4.1551510e+00, 1.4603380e+00, 4.3534800e+00,
 1.9278670e-02, 4.3180220e-02, 1.4706320e-02, 6.0768730e-02, 1.1963920e+00, 3.5056510e+00, 1.2939280e+00, 4.7870290e+00,
 2.4875790e-02, 8.4463630e-01, 3.1278230e-01, 1.6467660e+00, 1.5868890e+00, 4.3712090e+00, 2.3539340e+00, 4.9393820e+00,
 1.1816000e+00, 2.3832030e+00, 6.3957040e-01, 3.3494760e+00, 2.1964350e+00, 5.7955670e+00, 1.6855650e+00, 7.9033970e+00,
 8.1579290e-02, 2.4943380e+00, 7.2783980e-01, 4.8566630e+00, 2.8531820e+00, 7.0772930e+00, 3.0030870e+00, 7.9865410e+00,
 2.1376750e-01, 5.6218110e-01, 1.8138160e-01, 7.1521660e-01, 2.5843180e-01, 8.8913550e-01, 3.1089020e-01, 1.0975680e+00,
 7.9742790e-03, 3.1791510e-01, 1.1152730e-01, 5.6032420e-01, 4.0913720e-01, 1.3232780e+00, 6.7505820e-01, 1.3517240e+00,
 2.7576690e-01, 8.8216590e-01, 2.0678410e-01, 1.0200110e+00, 4.6249470e-01, 1.9355400e+00, 4.9168980e-01, 2.1714950e+00,
 1.4037060e-02, 6.8072100e-01, 1.7349590e-01, 1.0904120e+00, 1.1016190e+00, 4.3339800e+00, 1.6063020e+00, 4.0236220e+00,
 5.4239360e-03, 1.9970970e-02, 7.1728570e-03, 2.4904350e-02, 2.4721610e-01, 1.1908270e+00, 4.6351510e-01, 1.4408760e+00,
 5.5838000e-03, 3.1167320e-01, 1.2171540e-01, 5.3844630e-01, 4.9760150e-01, 2.2532720e+00, 1.2796170e+00, 2.2561360e+00,
 4.3132000e-01, 1.4301010e+00, 4.0473240e-01, 1.7809970e+00, 5.8886110e-01, 2.5542740e+00, 7.8341290e-01, 3.0864970e+00,
 2.3758790e-02, 1.1941990e+00, 3.6747750e-01, 2.0603450e+00, 1.1607970e+00, 4.7333730e+00, 2.1180930e+00, 4.7330690e+00,
 4.1136830e-01, 8.8860460e-01, 2.9368140e-01, 1.0864190e+00, 5.7086540e-01, 1.6132390e+00, 5.7781510e-01, 1.9137690e+00,
 2.1801880e-02, 7.1393170e-01, 2.5655340e-01, 1.2092400e+00, 8.1405920e-01, 2.1626240e+00, 1.1301140e+00, 2.1229780e+00,
 8.8918440e-01, 2.3363780e+00, 5.6099750e-01, 2.5961220e+00, 1.7118080e+00, 5.8842820e+00, 1.5312060e+00, 6.3442090e+00,
 6.4304140e-02, 2.5613870e+00, 6.6872290e-01, 3.9429750e+00, 3.6726450e+00, 1.1868000e+01, 4.5057670e+00, 1.0588520e+01,
 1.5595140e-02, 4.7164700e-02, 1.7352460e-02, 5.6522380e-02, 8.1592470e-01, 3.2282350e+00, 1.2871560e+00, 3.7537950e+00,
 2.2809610e-02, 1.0457570e+00, 4.1833850e-01, 1.7362050e+00, 1.4792930e+00, 5.5021100e+00, 3.2007120e+00, 5.2942980e+00,
 1.6347930e+00, 4.4521830e+00, 1.2907000e+00, 5.3284010e+00, 2.5619730e+00, 9.1279280e+00, 2.8677840e+00, 1.0599810e+01,
 1.2793830e-01, 5.2819710e+00, 1.6649500e+00, 8.7576330e+00, 4.5490110e+00, 1.5236130e+01, 6.9839330e+00, 1.4641120e+01,
 6.6425820e-03, 1.6679490e-02, 4.2978450e-03, 1.8847270e-02, 6.6676530e-03, 2.1903120e-02, 6.1164050e-03, 2.4014520e-02,
 3.7915680e-04, 1.4432770e-02, 4.0436250e-03, 2.2593440e-02, 1.2564610e-02, 3.8800930e-02, 1.5808240e-02, 3.5203320e-02,
 5.0653440e-01, 1.5471350e+00, 2.8963180e-01, 1.5888660e+00, 7.0535090e-01, 2.8184590e+00, 5.7181020e-01, 2.8084890e+00,
 3.9452540e-02, 1.8267500e+00, 3.7183500e-01, 2.5989920e+00, 1.9997840e+00, 7.5118960e+00, 2.2235190e+00, 6.1941860e+00,
 7.0359660e-03, 2.4735430e-02, 7.0951820e-03, 2.7396800e-02, 2.6626710e-01, 1.2246180e+00, 3.8068600e-01, 1.3160820e+00,
 1.1083350e-02, 5.9067940e-01, 1.8422520e-01, 9.0635660e-01, 6.3793380e-01, 2.7581550e+00, 1.2509390e+00, 2.4528710e+00,
 7.2454820e-01, 2.2937470e+00, 5.1843910e-01, 2.5371520e+00, 8.2131970e-01, 3.4015570e+00, 8.3320570e-01, 3.6507380e+00,
 6.1069450e-02, 2.9308080e+00, 7.2026570e-01, 4.4911250e+00, 1.9271190e+00, 7.5029870e+00, 2.6813890e+00, 6.6636280e+00,
 8.4152850e-01, 1.6794190e+00, 6.5235460e-01, 2.2963370e+00, 1.1370010e+00, 2.9685110e+00, 1.2496410e+00, 3.9383750e+00,
 4.2688220e-02, 1.2914670e+00, 5.4545780e-01, 2.4463960e+00, 1.7925520e+00, 4.3995620e+00, 2.7021370e+00, 4.8301610e+00,
 1.0496050e+00, 2.5479410e+00, 7.1905820e-01, 3.1663510e+00, 1.9673340e+00, 6.2478290e+00, 1.9108470e+00, 7.5335700e+00,
 7.2652230e-02, 2.6736080e+00, 8.2039960e-01, 4.6029290e+00, 4.6664930e+00, 1.3931620e+01, 6.2165520e+00, 1.3901030e+01,
 3.7592480e-02, 1.0503670e-01, 4.5419450e-02, 1.4077720e-01, 1.9149210e+00, 6.9996860e+00, 3.2802080e+00, 9.1027280e+00,
 5.2626640e-02, 2.2291070e+00, 1.0480570e+00, 4.1389370e+00, 3.8383420e+00, 1.3189590e+01, 9.0178970e+00, 1.4193780e+01,
 1.7888850e+00, 4.5009620e+00, 1.5336070e+00, 6.0244430e+00, 2.7295030e+00, 8.9844970e+00, 3.3176050e+00, 1.1668290e+01,
 1.3399750e-01, 5.1109830e+00, 1.8935050e+00, 9.4772620e+00, 5.3581470e+00, 1.6580010e+01, 8.9323740e+00, 1.7818540e+01,
 4.5636210e-03, 8.1569390e-03, 3.8298300e-03, 1.3169370e-02, 4.7792530e-03, 1.1175450e-02, 5.6864260e-03, 1.7506720e-02,
 1.6298770e-04, 4.4162900e-03, 2.2545660e-03, 9.8778470e-03, 5.9069620e-03, 1.2984620e-02, 9.6395050e-03, 1.6832270e-02,
 5.9606980e-03, 1.2959500e-02, 4.4206940e-03, 1.9016000e-02, 8.6597970e-03, 2.4631230e-02, 9.1056420e-03, 3.5068660e-02,
 2.9048680e-04, 9.5742010e-03, 3.5510600e-03, 1.9462580e-02, 1.6103250e-02, 4.3057820e-02, 2.3223500e-02, 5.0729290e-02,
 1.2947580e-04, 3.2400850e-04, 1.6934980e-04, 5.1275360e-04, 5.1120720e-03, 1.6736010e-02, 9.4798710e-03, 2.5698420e-02,
 1.2761430e-04, 4.8411900e-03, 2.7512730e-03, 1.0613810e-02, 8.0330970e-03, 2.4722820e-02, 2.0431470e-02, 3.1414210e-02,
 9.8550040e-03, 2.2207880e-02, 9.1462600e-03, 3.5097810e-02, 1.1655100e-02, 3.4360050e-02, 1.5336010e-02, 5.2690060e-02,
 5.1972900e-04, 1.7754650e-02, 7.9506350e-03, 3.8873350e-02, 1.7936620e-02, 4.9709350e-02, 3.2370390e-02, 6.3079280e-02,
 3.3173520e-01, 4.8702630e-01, 2.3423710e-01, 7.5564470e-01, 3.9878660e-01, 7.6592930e-01, 3.9922170e-01, 1.1530710e+00,
 1.6832560e-02, 3.7462430e-01, 1.9590810e-01, 8.0524510e-01, 4.4396010e-01, 8.0158960e-01, 6.0957710e-01, 9.9860330e-01,
 7.2600490e-01, 1.2965040e+00, 4.5303010e-01, 1.8282360e+00, 1.2107340e+00, 2.8285920e+00, 1.0711390e+00, 3.8701770e+00,
 5.0266900e-02, 1.3608220e+00, 5.1702050e-01, 2.6584390e+00, 2.0279340e+00, 4.4538480e+00, 2.4607190e+00, 5.0427750e+00,
 1.4062300e-02, 2.8904610e-02, 1.5475560e-02, 4.3958910e-02, 6.3732820e-01, 1.7138040e+00, 9.9440370e-01, 2.5289660e+00,
 1.9691570e-02, 6.1358690e-01, 3.5719770e-01, 1.2927750e+00, 9.0208700e-01, 2.2803760e+00, 1.9304530e+00, 2.7845950e+00,
 1.4109540e+00, 2.6115970e+00, 1.1017770e+00, 3.9664910e+00, 1.9154490e+00, 4.6382200e+00, 2.1206110e+00, 6.8352390e+00,
 1.0571730e-01, 2.9663640e+00, 1.3607090e+00, 6.2415400e+00, 2.6551820e+00, 6.0441460e+00, 4.0317700e+00, 7.3707380e+00,
 4.9137340e-03, 8.3857200e-03, 3.1444430e-03, 1.2024930e-02, 4.2726150e-03, 9.5391520e-03, 3.8764600e-03, 1.3272540e-02,
 2.6852770e-04, 6.9470880e-03, 2.8324310e-03, 1.3801040e-02, 6.2856620e-03, 1.3192500e-02, 7.8217470e-03, 1.5189550e-02,
 3.7937660e-01, 7.8754020e-01, 2.1454880e-01, 1.0263800e+00, 4.5762830e-01, 1.2428030e+00, 3.6692550e-01, 1.5715920e+00,
 2.8289940e-02, 8.9026480e-01, 2.6370950e-01, 1.6073910e+00, 1.0129120e+00, 2.5859570e+00, 1.1139050e+00, 2.7060300e+00,
 5.8197530e-03, 1.3905390e-02, 5.8044730e-03, 1.9545200e-02, 1.9078510e-01, 5.9636270e-01, 2.6978150e-01, 8.1333480e-01,
 8.7770270e-03, 3.1791510e-01, 1.4429250e-01, 6.1906310e-01, 3.5684830e-01, 1.0486000e+00, 6.9208990e-01, 1.1834290e+00,
 5.7362910e-01, 1.2342200e+00, 4.0595710e-01, 1.7324860e+00, 5.6327720e-01, 1.5855170e+00, 5.6517190e-01, 2.1594850e+00,
 4.6289600e-02, 1.5098360e+00, 5.3997110e-01, 2.9361210e+00, 1.0318100e+00, 2.7302870e+00, 1.4199380e+00, 3.0772400e+00,
 6.2499290e-01, 8.4771220e-01, 4.7919070e-01, 1.4709620e+00, 7.3149840e-01, 1.2979980e+00, 7.9516290e-01, 2.1853900e+00,
 3.0353570e-02, 6.2412010e-01, 3.8360240e-01, 1.5003340e+00, 9.0033740e-01, 1.5018480e+00, 1.3423300e+00, 2.0924470e+00,
 7.8925790e-01, 1.3021640e+00, 5.3478060e-01, 2.0535810e+00, 1.2814960e+00, 2.7659950e+00, 1.2310720e+00, 4.2325260e+00,
 5.2304330e-02, 1.3081860e+00, 5.8416090e-01, 2.8581330e+00, 2.3730730e+00, 4.8150980e+00, 3.1267160e+00, 6.0971510e+00,
 3.1218600e-02, 5.9283890e-02, 3.7305490e-02, 1.0083340e-01, 1.3775570e+00, 3.4223160e+00, 2.3338790e+00, 5.6479340e+00,
 4.1842110e-02, 1.2045420e+00, 8.2415910e-01, 2.8382870e+00, 2.1556750e+00, 5.0344720e+00, 5.0091410e+00, 6.8753860e+00,
 1.4219290e+00, 2.4315540e+00, 1.2056690e+00, 4.1302080e+00, 1.8794260e+00, 4.2045390e+00, 2.2593560e+00, 6.9296040e+00,
 1.0197360e-01, 2.6434950e+00, 1.4252000e+00, 6.2206160e+00, 2.8802980e+00, 6.0574600e+00, 4.7490640e+00, 8.2614110e+00,
 3.8389820e-01, 7.1770140e-01, 3.1367500e-01, 1.0800830e+00, 4.7681390e-01, 1.1661760e+00, 5.5235990e-01, 1.7028620e+00,
 1.6104080e-02, 4.5640320e-01, 2.1688920e-01, 9.5154450e-01, 5.3300700e-01, 1.2254850e+00, 8.4687110e-01, 1.4808020e+00,
 4.7084630e-01, 1.0707310e+00, 3.3999020e-01, 1.4644920e+00, 8.1128270e-01, 2.4135740e+00, 8.3055580e-01, 3.2030910e+00,
 2.6951510e-02, 9.2911440e-01, 3.2078080e-01, 1.7605270e+00, 1.3644510e+00, 3.8159820e+00, 1.9158690e+00, 4.1907210e+00,
 8.4060230e-03, 2.2002310e-02, 1.0704840e-02, 3.2456100e-02, 3.9362370e-01, 1.3478640e+00, 7.1069040e-01, 1.9291950e+00,
 9.7314130e-03, 3.8613450e-01, 2.0426970e-01, 7.8910270e-01, 5.5943170e-01, 1.8008270e+00, 1.3853440e+00, 2.1329260e+00,
 7.0799480e-01, 1.6687460e+00, 6.3975040e-01, 2.4583220e+00, 9.9305150e-01, 3.0621000e+00, 1.2722190e+00, 4.3769330e+00,
 4.3855570e-02, 1.5670040e+00, 6.5319590e-01, 3.1980520e+00, 1.3822160e+00, 4.0066700e+00, 2.4287180e+00, 4.7392300e+00,
 6.4525770e-01, 9.9084110e-01, 4.4359950e-01, 1.4329960e+00, 9.1995070e-01, 1.8480880e+00, 8.9666840e-01, 2.5933770e+00,
 3.8456190e-02, 8.9520420e-01, 4.3577500e-01, 1.7936180e+00, 9.2629170e-01, 1.7493060e+00, 1.2383010e+00, 2.0313390e+00,
 1.3260400e+00, 2.4768570e+00, 8.0563440e-01, 3.2556300e+00, 2.6226980e+00, 6.4088450e+00, 2.2591190e+00, 8.1736480e+00,
 1.0783850e-01, 3.0535360e+00, 1.0799240e+00, 5.5603750e+00, 3.9731340e+00, 9.1269300e+00, 4.6939140e+00, 9.6324010e+00,
 2.1110240e-02, 4.5385170e-02, 2.2619200e-02, 6.4338290e-02, 1.1347040e+00, 3.1914680e+00, 1.7237560e+00, 4.3898330e+00,
 3.4720970e-02, 1.1316120e+00, 6.1321660e-01, 2.2223880e+00, 1.4526050e+00, 3.8407460e+00, 3.0265790e+00, 4.3716640e+00,
 2.3438030e+00, 4.5375810e+00, 1.7819510e+00, 6.4239240e+00, 3.7736470e+00, 9.5576680e+00, 4.0676670e+00, 1.3128950e+01,
 2.0626660e-01, 6.0536500e+00, 2.5848880e+00, 1.1872990e+01, 4.7311280e+00, 1.1264590e+01, 6.9945530e+00, 1.2804630e+01,
 1.3990610e-02, 2.4973270e-02, 8.7169110e-03, 3.3380540e-02, 1.4427830e-02, 3.3692030e-02, 1.2744900e-02, 4.3696540e-02,
 8.9802540e-04, 2.4300340e-02, 9.2225870e-03, 4.4998410e-02, 1.9197220e-02, 4.2142890e-02, 2.3258670e-02, 4.5229090e-02,
 1.0143110e+00, 2.2023350e+00, 5.5849660e-01, 2.6754350e+00, 1.4510950e+00, 4.1218790e+00, 1.1328040e+00, 4.8585700e+00,
 8.8839710e-02, 2.9241810e+00, 8.0629630e-01, 4.9213280e+00, 2.9049230e+00, 7.7570060e+00, 3.1103170e+00, 7.5662550e+00,
 1.2788660e-02, 3.1960500e-02, 1.2418720e-02, 4.1874160e-02, 4.9721840e-01, 1.6256350e+00, 6.8455550e-01, 2.0666060e+00,
 2.2653870e-02, 8.5825440e-01, 3.6260390e-01, 1.5578130e+00, 8.4113600e-01, 2.5852480e+00, 1.5883230e+00, 2.7196340e+00,
 1.3948350e+00, 3.1390210e+00, 9.6109340e-01, 4.1072120e+00, 1.6244120e+00, 4.7824990e+00, 1.5868960e+00, 6.0716940e+00,
 1.3220560e-01, 4.5103060e+00, 1.5015180e+00, 8.1757180e+00, 2.6912470e+00, 7.4485580e+00, 3.6059270e+00, 7.8252980e+00,
 9.6305160e-01, 1.3662580e+00, 7.1891350e-01, 2.2098430e+00, 1.3368120e+00, 2.4810800e+00, 1.4148380e+00, 3.8937800e+00,
 5.4936230e-02, 1.1814820e+00, 6.7596480e-01, 2.6474190e+00, 1.4881340e+00, 2.5964060e+00, 2.1601780e+00, 3.3719170e+00,
 1.1420070e+00, 1.9707230e+00, 7.5338920e-01, 2.8969930e+00, 2.1991240e+00, 4.9647080e+00, 2.0568830e+00, 7.0813740e+00,
 8.8891890e-02, 2.3254330e+00, 9.6660900e-01, 4.7357920e+00, 3.6831820e+00, 7.8167680e+00, 4.7249180e+00, 9.2262390e+00,
 3.7126430e-02, 7.3742260e-02, 4.3195280e-02, 1.1691210e-01, 1.9429500e+00, 5.0487300e+00, 3.2049720e+00, 7.7665350e+00,
 5.8446410e-02, 1.7598520e+00, 1.1208540e+00, 3.8653270e+00, 2.7498900e+00, 6.7173170e+00, 6.2214130e+00, 8.5509560e+00,
 1.8711950e+00, 3.3468400e+00, 1.5447670e+00, 5.2990580e+00, 2.9332470e+00, 6.8635980e+00, 3.4332230e+00, 1.0544290e+01,
 1.5761710e-01, 4.2737010e+00, 2.1447920e+00, 9.3742090e+00, 4.0657500e+00, 8.9434240e+00, 6.5268720e+00, 1.1369550e+01,
};

static const double acc_score3_plus[16384] =
{3.6349880e-02, 7.5643410e-02, 2.1046080e-02, 1.3103500e-01, 4.1624360e-02, 3.0961730e-01, 3.1165780e-02, 2.6516370e-01,
 5.8457030e-04, 3.4844020e-02, 9.5437430e-03, 6.2671930e-02, 4.8876160e-02, 1.7799350e-01, 3.3064590e-02, 4.1327540e-01,
 1.9208380e-02, 4.1395290e-02, 1.0685730e-02, 7.1498930e-02, 2.7197610e-02, 2.0950790e-01, 1.9566200e-02, 1.7890470e-01,
 3.6669950e-04, 2.2635700e-02, 5.7522490e-03, 4.0594880e-02, 4.6959220e-02, 1.7710060e-01, 3.0523360e-02, 4.1000380e-01,
 4.9297550e-03, 1.0920320e-02, 4.2011320e-03, 1.7201700e-02, 4.9871920e-02, 3.9488960e-01, 5.4961590e-02, 3.0752770e-01,
 4.7210220e-04, 2.9955010e-02, 1.1344640e-02, 4.8993010e-02, 6.2173080e-02, 2.4101910e-01, 6.1907220e-02, 5.0886960e-01,
 2.2709840e-02, 3.2610730e-02, 1.3775050e-02, 9.0023270e-02, 3.9615740e-02, 2.0334040e-01, 3.1074860e-02, 2.7751760e-01,
 3.4837130e-04, 1.4328880e-02, 5.9584790e-03, 4.1070980e-02, 9.0902070e-02, 2.2843310e-01, 6.4424470e-02, 8.4522540e-01,
 8.4524570e-01, 2.2264130e+00, 4.3972750e-01, 2.2962890e+00, 7.3792890e-01, 6.9477910e+00, 4.9645210e-01, 3.5427480e+00,
 1.6566700e-02, 1.2499190e+00, 2.4302470e-01, 1.3385410e+00, 8.2822990e-01, 3.8177940e+00, 5.0344200e-01, 5.2777970e+00,
 4.3988910e-01, 1.1999360e+00, 2.1988180e-01, 1.2339890e+00, 4.7486510e-01, 4.6301460e+00, 3.0695770e-01, 2.3540760e+00,
 1.0234870e-02, 7.9968780e-01, 1.4425870e-01, 8.5389090e-01, 7.8369550e-01, 3.7411160e+00, 4.5771100e-01, 5.1567210e+00,
 1.6416150e-01, 4.6029490e-01, 1.2570280e-01, 4.3169470e-01, 1.2661620e+00, 1.2690050e+01, 1.2537900e+00, 5.8840530e+00,
 1.9160260e-02, 1.5388260e+00, 4.1370300e-01, 1.4985070e+00, 1.5087670e+00, 7.4033100e+00, 1.3498750e+00, 9.3064870e+00,
 3.8704380e-01, 7.0349520e-01, 2.1094620e-01, 1.1562720e+00, 5.1475520e-01, 3.3443460e+00, 3.6280610e-01, 2.7175830e+00,
 7.2361520e-03, 3.7673160e-01, 1.1120730e-01, 6.4292400e-01, 1.1289990e+00, 3.5911500e+00, 7.1895750e-01, 7.9113700e+00,
 3.9546820e-06, 4.2808770e-05, 2.3427230e-05, 1.2212690e-04, 2.4834210e-05, 9.6090630e-04, 1.9024880e-04, 1.3552910e-03,
 2.1965220e-06, 6.8105150e-04, 3.6690920e-04, 2.0173790e-03, 5.7857480e-05, 1.0960230e-03, 4.0046710e-04, 4.1909990e-03,
 2.5244280e-05, 2.8299340e-04, 1.4368710e-04, 8.0498440e-04, 1.9601860e-04, 7.8545290e-03, 1.4428270e-03, 1.1045970e-02,
 1.6644580e-05, 5.3445310e-03, 2.6714150e-03, 1.5785170e-02, 6.7150180e-04, 1.3173440e-02, 4.4658060e-03, 5.0226130e-02,
 4.5544470e-07, 5.2480600e-06, 3.9711640e-06, 1.3614360e-05, 2.5267400e-05, 1.0407190e-03, 2.8490820e-04, 1.3347640e-03,
 1.5063870e-06, 4.9719070e-04, 3.7036720e-04, 1.3392150e-03, 6.2498060e-05, 1.2602840e-03, 6.3671730e-04, 4.3821410e-03,
 7.0096910e-06, 5.2359840e-05, 4.3503000e-05, 2.3804280e-04, 6.7057410e-05, 1.7904230e-03, 5.3818220e-04, 4.0242520e-03,
 3.7137900e-06, 7.9458470e-04, 6.4990750e-04, 3.7508150e-03, 3.0528990e-04, 3.9907150e-03, 2.2137610e-03, 2.4317940e-02,
 4.4153970e-01, 9.7057760e-01, 2.4157360e-01, 8.5694490e-01, 5.3770920e-01, 4.2249100e+00, 3.8044270e-01, 1.8442200e+00,
 9.8549580e-03, 6.2049550e-01, 1.5203660e-01, 5.6883980e-01, 5.8280890e-01, 2.2419480e+00, 3.7256650e-01, 2.6531850e+00,
 4.2544870e-01, 9.6850060e-01, 2.2365170e-01, 8.5261880e-01, 6.4064930e-01, 5.2129380e+00, 4.3551950e-01, 2.2688730e+00,
 1.1272450e-02, 7.3501170e-01, 1.6709250e-01, 6.7185860e-01, 1.0210330e+00, 4.0675360e+00, 6.2713750e-01, 4.7996060e+00,
 6.8158700e-02, 1.5948650e-01, 5.4887550e-02, 1.2804610e-01, 7.3330600e-01, 6.1333430e+00, 7.6365970e-01, 2.4345140e+00,
 9.0590650e-03, 6.0716860e-01, 2.0570730e-01, 5.0615120e-01, 8.4384130e-01, 3.4554310e+00, 7.9398300e-01, 3.7184660e+00,
 3.1002250e-01, 4.7025350e-01, 1.7769850e-01, 6.6165670e-01, 5.7514850e-01, 3.1183750e+00, 4.2631710e-01, 2.1692100e+00,
 6.6004390e-03, 2.8677090e-01, 1.0667860e-01, 4.1895210e-01, 1.2181910e+00, 3.2336500e+00, 8.1583780e-01, 6.0983570e+00,
 4.7549640e-02, 8.0988690e-02, 3.1996910e-02, 1.6518880e-01, 4.6011520e-02, 2.8012590e-01, 4.0039580e-02, 2.8247630e-01,
 7.8978330e-04, 3.8530830e-02, 1.4985890e-02, 8.1600590e-02, 7.9289380e-02, 2.3633660e-01, 6.2340980e-02, 6.4611000e-01,
 1.6945180e-02, 2.9889290e-02, 1.0956010e-02, 6.0786080e-02, 2.0275010e-02, 1.2783210e-01, 1.6952330e-02, 1.2852900e-01,
 3.3411260e-04, 1.6880510e-02, 6.0913390e-03, 3.5645340e-02, 5.1374810e-02, 1.5858370e-01, 3.8810940e-02, 4.3228110e-01,
 4.8296950e-03, 8.7566670e-03, 4.7835820e-03, 1.6241070e-02, 4.1288130e-02, 2.6758010e-01, 5.2883590e-02, 2.4535920e-01,
 4.7770230e-04, 2.4808460e-02, 1.3341500e-02, 4.7775410e-02, 7.5538870e-02, 2.3967820e-01, 8.7418210e-02, 5.9583170e-01,
 1.8142870e-02, 2.1323640e-02, 1.2790210e-02, 6.9309950e-02, 2.6744490e-02, 1.1235680e-01, 2.4381940e-02, 1.8055360e-01,
 2.8744930e-04, 9.6769840e-03, 5.7140850e-03, 3.2659000e-02, 9.0061530e-02, 1.8523950e-01, 7.4183770e-02, 8.0702520e-01,
 5.2947270e-01, 1.1414980e+00, 3.2013760e-01, 1.3862330e+00, 3.9061590e-01, 3.0101700e+00, 3.0542540e-01, 1.8072770e+00,
 1.0718240e-02, 6.6187890e-01, 1.8273870e-01, 8.3458030e-01, 6.4340620e-01, 2.4274810e+00, 4.5454440e-01, 3.9512630e+00,
 1.8582970e-01, 4.1489590e-01, 1.0795770e-01, 5.0238010e-01, 1.6951850e-01, 1.3528520e+00, 1.2735550e-01, 8.0987180e-01,
 4.4656140e-03, 2.8558040e-01, 7.3153220e-02, 3.5904620e-01, 4.1057550e-01, 1.6041900e+00, 2.7869520e-01, 2.6035650e+00,
 7.7016200e-02, 1.7674860e-01, 6.8540630e-02, 1.9518050e-01, 5.0196640e-01, 4.1177300e+00, 5.7770050e-01, 2.2480760e+00,
 9.2840840e-03, 6.1028990e-01, 2.3298010e-01, 6.9975410e-01, 8.7782260e-01, 3.5254890e+00, 9.1278950e-01, 5.2181820e+00,
 1.4807040e-01, 2.2028170e-01, 9.3793430e-02, 4.2630190e-01, 1.6641160e-01, 8.8491830e-01, 1.3631700e-01, 8.4667110e-01,
 2.8591890e-03, 1.2183620e-01, 5.1069400e-02, 2.4481830e-01, 5.3564320e-01, 1.3945190e+00, 3.9644010e-01, 3.6172840e+00,
 3.2914880e-06, 2.9162340e-05, 2.2661780e-05, 9.7958280e-05, 1.7466500e-05, 5.5315320e-04, 1.5551410e-04, 9.1862190e-04,
 1.8881790e-06, 4.7917770e-04, 3.6657150e-04, 1.6712600e-03, 5.9719190e-05, 9.2594010e-04, 4.8041180e-04, 4.1688950e-03,
 1.4169520e-05, 1.3001020e-04, 9.3735120e-05, 4.3544020e-04, 9.2974560e-05, 3.0492700e-03, 7.9537790e-04, 5.0491660e-03,
 9.6492130e-06, 2.5359320e-03, 1.7999190e-03, 8.8189600e-03, 4.6742610e-04, 7.5054050e-03, 3.6129180e-03, 3.3693370e-02,
 2.8390070e-07, 2.6775560e-06, 2.8770080e-06, 8.1785640e-06, 1.3309640e-05, 4.4869150e-04, 1.7442270e-04, 6.7757740e-04,
 9.6982700e-07, 2.6199310e-04, 2.7712950e-04, 8.3091560e-04, 4.8313790e-05, 7.9741080e-04, 5.7206270e-04, 3.2646740e-03,
 3.5630930e-06, 2.1783900e-05, 2.5700410e-05, 1.1660910e-04, 2.8803800e-05, 6.2945940e-04, 2.6867350e-04, 1.6658550e-03,
 1.9497220e-06, 3.4143210e-04, 3.9655120e-04, 1.8977100e-03, 1.9244850e-04, 2.0590260e-03, 1.6219040e-03, 1.4773310e-02,
 2.8951750e-01, 5.2088810e-01, 1.8409710e-01, 5.4151070e-01, 2.9793900e-01, 1.9160480e+00, 2.4499750e-01, 9.8478540e-01,
 6.6740100e-03, 3.4393770e-01, 1.1966660e-01, 3.7125390e-01, 4.7392000e-01, 1.4921530e+00, 3.5210740e-01, 2.0791950e+00,
 1.8813240e-01, 3.5053020e-01, 1.1494270e-01, 3.6334600e-01, 2.3939310e-01, 1.5943470e+00, 1.8914350e-01, 8.1705330e-01,
 5.1482740e-03, 2.7475570e-01, 8.8693740e-02, 2.9571300e-01, 5.5992520e-01, 1.8257050e+00, 3.9971040e-01, 2.5365580e+00,
 3.3471610e-02, 6.4104450e-02, 3.1327200e-02, 6.0599700e-02, 3.0430930e-01, 2.0832260e+00, 3.6831750e-01, 9.7362390e-01,
 4.5947890e-03, 2.5205800e-01, 1.2126190e-01, 2.4740670e-01, 5.1391320e-01, 1.7224250e+00, 5.6199530e-01, 2.1824370e+00,
 1.2414980e-01, 1.5413230e-01, 8.2704490e-02, 2.5534920e-01, 1.9462900e-01, 8.6370370e-01, 1.6766900e-01, 7.0742110e-01,
 2.7299360e-03, 9.7078650e-02, 5.1280170e-02, 1.6699100e-01, 6.0498100e-01, 1.3144030e+00, 4.7089360e-01, 2.9186920e+00,
 2.4382380e-01, 4.5576480e-01, 1.4003930e-01, 7.1671660e-01, 2.0991300e-01, 1.4025350e+00, 1.5591050e-01, 1.0904180e+00,
 3.5616190e-03, 1.9069330e-01, 5.7681300e-02, 3.1136570e-01, 2.9512600e-01, 9.6540830e-01, 1.9805200e-01, 2.0348710e+00,
 1.3762780e-01, 2.6641780e-01, 7.5949610e-02, 4.1773630e-01, 1.4650930e-01, 1.0137510e+00, 1.0455540e-01, 7.8585620e-01,
 2.3865120e-03, 1.3232560e-01, 3.7136130e-02, 2.1543270e-01, 3.0288230e-01, 1.0260530e+00, 1.9529490e-01, 2.1563930e+00,
 2.3858260e-02, 4.7472870e-02, 2.0169050e-02, 6.7884690e-02, 1.8146310e-01, 1.2906380e+00, 1.9837960e-01, 9.1243800e-01,
 2.0753300e-03, 1.1828160e-01, 4.9470640e-02, 1.7561930e-01, 2.7086510e-01, 9.4318900e-01, 2.6754550e-01, 1.8077750e+00,
 1.5119280e-01, 1.9501780e-01, 9.0973740e-02, 4.8871860e-01, 1.9829130e-01, 9.1423130e-01, 1.5429450e-01, 1.1326960e+00,
 2.1066730e-03, 7.7832960e-02, 3.5743390e-02, 2.0252420e-01, 5.4478880e-01, 1.2297310e+00, 3.8301070e-01, 4.1306080e+00,
 2.4804880e+00, 5.8688960e+00, 1.2800990e+00, 5.4950010e+00, 1.6281240e+00, 1.3769440e+01, 1.0865650e+00, 6.3738240e+00,
 4.4159860e-02, 2.9927500e+00, 6.4261050e-01, 2.9094470e+00, 2.1879750e+00, 9.0594230e+00, 1.3193090e+00, 1.1369230e+01,
 1.3789230e+00, 3.3787140e+00, 6.8374110e-01, 3.1542430e+00, 1.1191430e+00, 9.8018190e+00, 7.1762830e-01, 4.5240040e+00,
 2.9141810e-02, 2.0452740e+00, 4.0745720e-01, 1.9825480e+00, 2.2114720e+00, 9.4826950e+00, 1.2812420e+00, 1.1865740e+01,
 3.4758890e-01, 8.7544170e-01, 2.6402500e-01, 7.4534650e-01, 2.0155910e+00, 1.8145680e+01, 1.9799020e+00, 7.6379490e+00,
 3.6849660e-02, 2.6583870e+00, 7.8927150e-01, 2.3500540e+00, 2.8757700e+00, 1.2675190e+01, 2.5522970e+00, 1.4464540e+01,
 1.1273490e+00, 1.8405850e+00, 6.0950260e-01, 2.7462830e+00, 1.1272430e+00, 6.5784670e+00, 7.8812850e-01, 4.8527360e+00,
 1.9144480e-02, 8.9529150e-01, 2.9186000e-01, 1.3870190e+00, 2.9602550e+00, 8.4579600e+00, 1.8700120e+00, 1.6915090e+01,
 2.2240480e-05, 2.1625290e-04, 1.3069510e-04, 5.6005560e-04, 1.0500300e-04, 3.6494630e-03, 7.9795590e-04, 4.6727310e-03,
 1.1220330e-05, 3.1249770e-03, 1.8592360e-03, 8.4031990e-03, 2.9290680e-04, 4.9840920e-03, 2.0111400e-03, 1.7301130e-02,
 1.5164850e-04, 1.5270320e-03, 8.5624620e-04, 3.9432080e-03, 8.8530160e-04, 3.1864760e-02, 6.4641850e-03, 4.0680360e-02,
 9.0820890e-05, 2.6195040e-02, 1.4459720e-02, 7.0234300e-02, 3.6312800e-03, 6.3989460e-02, 2.3956200e-02, 2.2147730e-01,
 1.8480280e-06, 1.9127950e-05, 1.5984400e-05, 4.5046100e-05, 7.7081880e-05, 2.8518160e-03, 8.6218870e-04, 3.3203440e-03,
 5.5519700e-06, 1.6460020e-03, 1.3540940e-03, 4.0248320e-03, 2.2828470e-04, 4.1350000e-03, 2.3070800e-03, 1.3052200e-02,
 3.9126910e-05, 2.6252560e-04, 2.4088040e-04, 1.0834750e-03, 2.8141170e-04, 6.7491280e-03, 2.2404240e-03, 1.3771060e-02,
 1.8829190e-05, 3.6186870e-03, 3.2686730e-03, 1.5506970e-02, 1.5340040e-03, 1.8011970e-02, 1.1034440e-02, 9.9638640e-02,
 1.9297910e+00, 3.8103730e+00, 1.0473590e+00, 3.0540810e+00, 1.7668790e+00, 1.2470200e+01, 1.2400930e+00, 4.9415030e+00,
 3.9123080e-02, 2.2126540e+00, 5.9873160e-01, 1.8414300e+00, 2.2930010e+00, 7.9231920e+00, 1.4540770e+00, 8.5120170e+00,
 1.9862340e+00, 4.0614370e+00, 1.0357650e+00, 3.2458250e+00, 2.2486520e+00, 1.6435430e+01, 1.5164050e+00, 6.4938030e+00,
 4.7801230e-02, 2.7997020e+00, 7.0288380e-01, 2.3231960e+00, 4.2910180e+00, 1.5354960e+01, 2.6145020e+00, 1.6448000e+01,
 2.1493260e-01, 4.5175350e-01, 1.7169610e-01, 3.2925640e-01, 1.7385410e+00, 1.3061520e+01, 1.7959960e+00, 4.7065090e+00,
 2.5947890e-02, 1.5621560e+00, 5.8448580e-01, 1.1821860e+00, 2.3954060e+00, 8.8108370e+00, 2.2358110e+00, 8.6073430e+00,
 1.3448630e+00, 1.8323710e+00, 7.6467030e-01, 2.3404770e+00, 1.8757860e+00, 9.1354150e+00, 1.3792460e+00, 5.7688860e+00,
 2.6007290e-02, 1.0149720e+00, 4.1697040e-01, 1.3460890e+00, 4.7570450e+00, 1.1342570e+01, 3.1603230e+00, 1.9418780e+01,
 2.3216970e-02, 3.9307510e-02, 1.6690350e-02, 7.9260200e-02, 2.1524950e-02, 1.3026320e-01, 2.0010790e-02, 1.2985950e-01,
 4.3708580e-04, 2.1196300e-02, 8.8601370e-03, 4.4378060e-02, 2.6937020e-02, 7.9810200e-02, 2.2625980e-02, 2.1570350e-01,
 1.3466840e-02, 2.3611730e-02, 9.3018870e-03, 4.7472250e-02, 1.5438240e-02, 9.6754120e-02, 1.3790030e-02, 9.6173190e-02,
 3.0096280e-04, 1.5114660e-02, 5.8618130e-03, 3.1552880e-02, 2.8408340e-02, 8.7165960e-02, 2.2927100e-02, 2.3489730e-01,
 2.2117830e-03, 3.9861590e-03, 2.3403210e-03, 7.3089320e-03, 1.8116130e-02, 1.1670430e-01, 2.4789080e-02, 1.0579350e-01,
 2.4795950e-04, 1.2800180e-02, 7.3982210e-03, 2.4369360e-02, 2.4069640e-02, 7.5913750e-02, 2.9757760e-02, 1.8656880e-01,
 1.4170100e-02, 1.6554700e-02, 1.0671950e-02, 5.3195990e-02, 2.0013300e-02, 8.3575010e-02, 1.9491790e-02, 1.3277210e-01,
 2.5446540e-04, 8.5153080e-03, 5.4039770e-03, 2.8411010e-02, 4.8942090e-02, 1.0006210e-01, 4.3067670e-02, 4.3096950e-01,
 3.4463820e-01, 7.3856390e-01, 2.2261580e-01, 8.8669130e-01, 2.4360550e-01, 1.8660410e+00, 2.0348940e-01, 1.1075880e+00,
 7.9075860e-03, 4.8539120e-01, 1.4402910e-01, 6.0506900e-01, 2.9139450e-01, 1.0928100e+00, 2.1992350e-01, 1.7585240e+00,
 1.9687760e-01, 4.3693120e-01, 1.2218960e-01, 5.2303380e-01, 1.7207400e-01, 1.3650280e+00, 1.3810690e-01, 8.0785030e-01,
 5.3624430e-03, 3.4088100e-01, 9.3845680e-02, 4.2369000e-01, 3.0265670e-01, 1.1754550e+00, 2.1947550e-01, 1.8860010e+00,
 4.7018270e-02, 1.0725890e-01, 4.4702510e-02, 1.1709470e-01, 2.9361380e-01, 2.3941570e+00, 3.6099720e-01, 1.2921980e+00,
 6.4242740e-03, 4.1977260e-01, 1.7222770e-01, 4.7582440e-01, 3.7287860e-01, 1.4885830e+00, 4.1421960e-01, 2.1781930e+00,
 1.5416900e-01, 2.2798160e-01, 1.0432790e-01, 4.3617640e-01, 1.6600820e-01, 8.7748970e-01, 1.4527640e-01, 8.2999780e-01,
 3.3742090e-03, 1.4292170e-01, 6.4385670e-02, 2.8391560e-01, 3.8804350e-01, 1.0042050e+00, 3.0681860e-01, 2.5751570e+00,
 1.5240400e-07, 1.3422070e-06, 1.1209790e-06, 4.4571960e-06, 7.7486730e-07, 2.4392700e-05, 7.3703940e-06, 4.0047430e-05,
 9.9094110e-08, 2.4997360e-05, 2.0552410e-05, 8.6191630e-05, 1.9239530e-06, 2.9652160e-05, 1.6534590e-05, 1.3198290e-04,
 1.0678750e-06, 9.7394780e-06, 7.5468720e-06, 3.2248550e-05, 6.7134660e-06, 2.1886260e-04, 6.1355780e-05, 3.5827680e-04,
 8.2424770e-07, 2.1532590e-04, 1.6425480e-04, 7.4028600e-04, 2.4510630e-05, 3.9120880e-04, 2.0239460e-04, 1.7362100e-03,
 1.2329210e-08, 1.1558470e-07, 1.3347790e-07, 3.4902960e-07, 5.5379920e-07, 1.8557820e-05, 7.7533330e-06, 2.7705200e-05,
 4.7737930e-08, 1.2818940e-05, 1.4573080e-05, 4.0192270e-05, 1.4598770e-06, 2.3950800e-05, 1.8466650e-05, 9.6939590e-05,
 2.6390050e-07, 1.6037680e-06, 2.0335380e-06, 8.4871460e-06, 2.0439960e-06, 4.4400810e-05, 2.0368280e-05, 1.1616720e-04,
 1.6367640e-07, 2.8491200e-05, 3.5564110e-05, 1.5655240e-04, 9.9175320e-06, 1.0547360e-04, 8.9292220e-05, 7.4814070e-04,
 1.7528540e-01, 3.1347880e-01, 1.1907410e-01, 3.2217680e-01, 1.7282860e-01, 1.1048100e+00, 1.5182700e-01, 5.6136590e-01,
 4.5799230e-03, 2.3460860e-01, 8.7729060e-02, 2.5035640e-01, 1.9964210e-01, 6.2481790e-01, 1.5846070e-01, 8.6071370e-01,
 1.8539400e-01, 3.4336050e-01, 1.2100760e-01, 3.5185900e-01, 2.2602730e-01, 1.4963220e+00, 1.9078310e-01, 7.5808170e-01,
 5.7503480e-03, 3.0505080e-01, 1.0583390e-01, 3.2457810e-01, 3.8391780e-01, 1.2443190e+00, 2.9278780e-01, 1.7091070e+00,
 1.9006930e-02, 3.6184000e-02, 1.9004500e-02, 3.3816000e-02, 1.6556480e-01, 1.1266320e+00, 2.1407920e-01, 5.2054740e-01,
 2.9573420e-03, 1.6126100e-01, 8.3379560e-02, 1.5648180e-01, 2.0304930e-01, 6.7646410e-01, 2.3721580e-01, 8.4736350e-01,
 1.2023350e-01, 1.4837690e-01, 8.5567330e-02, 2.4301350e-01, 1.8059440e-01, 7.9662620e-01, 1.6620690e-01, 6.4504680e-01,
 2.9966270e-03, 1.0592460e-01, 6.0135210e-02, 1.8013140e-01, 4.0765950e-01, 8.8039410e-01, 3.3898290e-01, 1.9326820e+00,
 3.1088400e-02, 6.4694370e-02, 1.7999760e-02, 1.1206830e-01, 4.4059060e-02, 3.2772750e-01, 3.2988730e-02, 2.8067370e-01,
 5.7325640e-04, 3.4169640e-02, 9.3590310e-03, 6.1458970e-02, 3.8518870e-02, 1.4027510e-01, 2.6057920e-02, 3.2569870e-01,
 1.4718510e-02, 3.1719330e-02, 8.1879910e-03, 5.4786380e-02, 2.5792650e-02, 1.9868530e-01, 1.8555460e-02, 1.6966290e-01,
 3.2218120e-04, 1.9887670e-02, 5.0539110e-03, 3.5666550e-02, 3.3156990e-02, 1.2504730e-01, 2.1551950e-02, 2.8949570e-01,
 4.4807530e-03, 9.9257010e-03, 3.8184940e-03, 1.5634970e-02, 5.6101450e-02, 4.4421550e-01, 6.1826870e-02, 3.4594110e-01,
 4.9201520e-04, 3.1218500e-02, 1.1823150e-02, 5.1059510e-02, 5.2072590e-02, 2.0186370e-01, 5.1849920e-02, 4.2619990e-01,
 1.5325550e-02, 2.2007080e-02, 9.2959810e-03, 6.0751460e-02, 3.3087350e-02, 1.6983130e-01, 2.5953940e-02, 2.3178470e-01,
 2.6956350e-04, 1.1087430e-02, 4.6105650e-03, 3.1779990e-02, 5.6527110e-02, 1.4205030e-01, 4.0062120e-02, 5.2560020e-01,
 7.6998830e-01, 2.0281820e+00, 4.0057590e-01, 2.0918370e+00, 8.3197050e-01, 7.8332160e+00, 5.5971990e-01, 3.9942350e+00,
 1.7304290e-02, 1.3055690e+00, 2.5384480e-01, 1.3981360e+00, 6.9523750e-01, 3.2047540e+00, 4.2260220e-01, 4.4303180e+00,
 3.5902290e-01, 9.7934800e-01, 1.7946020e-01, 1.0071410e+00, 4.7966870e-01, 4.6769830e+00, 3.1006270e-01, 2.3778890e+00,
 9.5780670e-03, 7.4836960e-01, 1.3500120e-01, 7.9909430e-01, 5.8939620e-01, 2.8135920e+00, 3.4423200e-01, 3.8782310e+00,
 1.5892890e-01, 4.4562300e-01, 1.2169600e-01, 4.1793450e-01, 1.5170950e+00, 1.5205020e+01, 1.5022720e+00, 7.0501820e+00,
 2.1269130e-02, 1.7081960e+00, 4.5923710e-01, 1.6634400e+00, 1.3459690e+00, 6.6044790e+00, 1.2042210e+00, 8.3022990e+00,
 2.7820680e-01, 5.0567190e-01, 1.5162800e-01, 8.3112770e-01, 4.5793170e-01, 2.9751660e+00, 3.2275610e-01, 2.4175900e+00,
 5.9639250e-03, 3.1049640e-01, 9.1655310e-02, 5.2988810e-01, 7.4779490e-01, 2.3786050e+00, 4.7620290e-01, 5.2401120e+00,
 2.7709090e-06, 2.9994630e-05, 1.6414650e-05, 8.5570140e-05, 2.1535420e-05, 8.3326670e-04, 1.6497760e-04, 1.1752640e-03,
 1.7646680e-06, 5.4715140e-04, 2.9477200e-04, 1.6207460e-03, 3.7355230e-05, 7.0763840e-04, 2.5855840e-04, 2.7058850e-03,
 1.5847160e-05, 1.7764980e-04, 9.0199940e-05, 5.0533100e-04, 1.5229230e-04, 6.1024020e-03, 1.1209720e-03, 8.5819220e-03,
 1.1980590e-05, 3.8469350e-03, 1.9228560e-03, 1.1362000e-02, 3.8843350e-04, 7.6202450e-03, 2.5832670e-03, 2.9053560e-02,
 3.3913820e-07, 3.9078680e-06, 2.9570520e-06, 1.0137680e-05, 2.3285950e-05, 9.5910600e-04, 2.6256590e-04, 1.2300920e-03,
 1.2861580e-06, 4.2450310e-04, 3.1622080e-04, 1.1434260e-03, 4.2883350e-05, 8.6475040e-04, 4.3688670e-04, 3.0068270e-03,
 3.8753970e-06, 2.8947810e-05, 2.4051190e-05, 1.3160500e-04, 4.5883480e-05, 1.2250820e-03, 3.6824670e-04, 2.7535610e-03,
 2.3542440e-06, 5.0370270e-04, 4.1198900e-04, 2.3777150e-03, 1.5552880e-04, 2.0330550e-03, 1.1277920e-03, 1.2388680e-02,
 3.9288660e-01, 8.6363020e-01, 2.1495470e-01, 7.6251860e-01, 5.9215750e-01, 4.6527230e+00, 4.1896630e-01, 2.0309650e+00,
 1.0054700e-02, 6.3307180e-01, 1.5511810e-01, 5.8036910e-01, 4.7786460e-01, 1.8382490e+00, 3.0547970e-01, 2.1754350e+00,
 3.3917390e-01, 7.7210280e-01, 1.7829840e-01, 6.7972010e-01, 6.3210300e-01, 5.1433970e+00, 4.2970960e-01, 2.2386060e+00,
 1.0304100e-02, 6.7187160e-01, 1.5273870e-01, 6.1414360e-01, 7.5006020e-01, 2.9880490e+00, 4.6070090e-01, 3.5258350e+00,
 6.4453900e-02, 1.5081750e-01, 5.1904110e-02, 1.2108600e-01, 8.5823320e-01, 7.1782300e+00, 8.9375810e-01, 2.8492620e+00,
 9.8226350e-03, 6.5834560e-01, 2.2304590e-01, 5.4881370e-01, 7.3530880e-01, 3.0110030e+00, 6.9186310e-01, 3.2402070e+00,
 2.1766940e-01, 3.3016890e-01, 1.2476360e-01, 4.6455460e-01, 4.9977700e-01, 2.7097210e+00, 3.7044960e-01, 1.8849420e+00,
 5.3136590e-03, 2.3086380e-01, 8.5881210e-02, 3.3727580e-01, 7.8813470e-01, 2.0920790e+00, 5.2782380e-01, 3.9454640e+00,
 4.3774770e-02, 7.4559170e-02, 2.9456740e-02, 1.5207480e-01, 5.2424650e-02, 3.1917000e-01, 4.5620330e-02, 3.2184810e-01,
 8.3368380e-04, 4.0672590e-02, 1.5818880e-02, 8.6136400e-02, 6.7262470e-02, 2.0048820e-01, 5.2884870e-02, 5.4810560e-01,
 1.3976570e-02, 2.4653010e-02, 9.0366350e-03, 5.0137020e-02, 2.0697010e-02, 1.3049280e-01, 1.7305170e-02, 1.3120420e-01,
 3.1598330e-04, 1.5964550e-02, 5.7608150e-03, 3.3711180e-02, 3.9046820e-02, 1.2052970e-01, 2.9497800e-02, 3.2855020e-01,
 4.7252710e-03, 8.5673370e-03, 4.6801550e-03, 1.5889920e-02, 4.9994760e-02, 3.2400600e-01, 6.4035410e-02, 2.9709930e-01,
 5.3589680e-04, 2.7830670e-02, 1.4966780e-02, 5.3595490e-02, 6.8101800e-02, 2.1608100e-01, 7.8811580e-02, 5.3717000e-01,
 1.3179200e-02, 1.5489760e-02, 9.2909660e-03, 5.0347610e-02, 2.4044170e-02, 1.0101240e-01, 2.1920160e-02, 1.6232360e-01,
 2.3942050e-04, 8.0600920e-03, 4.7593400e-03, 2.7202130e-02, 6.0284220e-02, 1.2399320e-01, 4.9656170e-02, 5.4019610e-01,
 5.1918960e-01, 1.1193290e+00, 3.1392010e-01, 1.3593100e+00, 4.7405040e-01, 3.6531350e+00, 3.7066350e-01, 2.1933060e+00,
 1.2050990e-02, 7.4417970e-01, 2.0546110e-01, 9.3835550e-01, 5.8136490e-01, 2.1934080e+00, 4.1071430e-01, 3.5702570e+00,
 1.6325830e-01, 3.6450150e-01, 9.4844890e-02, 4.4135960e-01, 1.8431870e-01, 1.4709670e+00, 1.3847460e-01, 8.8057970e-01,
 4.4984000e-03, 2.8767710e-01, 7.3690310e-02, 3.6168230e-01, 3.3237960e-01, 1.2986650e+00, 2.2561650e-01, 2.1077040e+00,
 8.0259210e-02, 1.8419110e-01, 7.1426750e-02, 2.0339920e-01, 6.4741030e-01, 5.3108360e+00, 7.4508840e-01, 2.8994530e+00,
 1.1093500e-02, 7.2923200e-01, 2.7838660e-01, 8.3613230e-01, 8.4294780e-01, 3.3854260e+00, 8.7652550e-01, 5.0108700e+00,
 1.1456640e-01, 1.7043840e-01, 7.2570720e-02, 3.2984220e-01, 1.5935470e-01, 8.4739210e-01, 1.3053630e-01, 8.1076680e-01,
 2.5365810e-03, 1.0808910e-01, 4.5307130e-02, 2.1719490e-01, 3.8189650e-01, 9.9424770e-01, 2.8264920e-01, 2.5790080e+00,
 2.4824710e-06, 2.1994520e-05, 1.7091730e-05, 7.3881070e-05, 1.6303850e-05, 5.1633280e-04, 1.4516240e-04, 8.5747430e-04,
 1.6328710e-06, 4.1438630e-04, 3.1700600e-04, 1.4452830e-03, 4.1503720e-05, 6.4351110e-04, 3.3387720e-04, 2.8973040e-03,
 9.5746920e-06, 8.7851090e-05, 6.3339130e-05, 2.9423770e-04, 7.7754600e-05, 2.5501040e-03, 6.6517440e-04, 4.2226170e-03,
 7.4761570e-06, 1.9648260e-03, 1.3945670e-03, 6.8328820e-03, 2.9104740e-04, 4.6733140e-03, 2.2496190e-03, 2.0979510e-02,
 2.2755630e-07, 2.1461540e-06, 2.3060220e-06, 6.5554040e-06, 1.3203250e-05, 4.4510500e-04, 1.7302850e-04, 6.7216130e-04,
 8.9131950e-07, 2.4078470e-04, 2.5469590e-04, 7.6365300e-04, 3.5684080e-05, 5.8895970e-04, 4.2251990e-04, 2.4112560e-03,
 2.1204390e-06, 1.2963860e-05, 1.5294620e-05, 6.9395450e-05, 2.1214880e-05, 4.6361620e-04, 1.9788630e-04, 1.2269530e-03,
 1.3304180e-06, 2.3298060e-04, 2.7059180e-04, 1.2949270e-03, 1.0553440e-04, 1.1291230e-03, 8.8941590e-04, 8.1013510e-03,
 2.7730240e-01, 4.9891120e-01, 1.7632990e-01, 5.1866370e-01, 3.5318190e-01, 2.2713150e+00, 2.9042410e-01, 1.1673810e+00,
 7.3296370e-03, 3.7772470e-01, 1.3142210e-01, 4.0772430e-01, 4.1827790e-01, 1.3169620e+00, 3.1076710e-01, 1.8350810e+00,
 1.6144340e-01, 3.0080290e-01, 9.8636520e-02, 3.1180060e-01, 2.5424970e-01, 1.6932910e+00, 2.0088160e-01, 8.6775910e-01,
 5.0656470e-03, 2.7034610e-01, 8.7270260e-02, 2.9096700e-01, 4.4275930e-01, 1.4436710e+00, 3.1606990e-01, 2.0057760e+00,
 3.4071070e-02, 6.5252530e-02, 3.1888260e-02, 6.1685010e-02, 3.8336870e-01, 2.6244460e+00, 4.6400620e-01, 1.2265710e+00,
 5.3627990e-03, 2.9418900e-01, 1.4153060e-01, 2.8876030e-01, 4.8203660e-01, 1.6155870e+00, 5.2713630e-01, 2.0470670e+00,
 9.3827750e-02, 1.1648750e-01, 6.2504960e-02, 1.9298330e-01, 1.8204770e-01, 8.0787170e-01, 1.5683040e-01, 6.6169160e-01,
 2.3656730e-03, 8.4125160e-02, 4.4437700e-02, 1.4470890e-01, 4.2131620e-01, 9.1536630e-01, 3.2793610e-01, 2.0326130e+00,
 1.4764600e-01, 2.7598560e-01, 8.4799950e-02, 4.3400340e-01, 1.5731760e-01, 1.0511180e+00, 1.1684590e-01, 8.1720450e-01,
 2.4729190e-03, 1.3240300e-01, 4.0049540e-02, 2.1618880e-01, 1.6467750e-01, 5.3868860e-01, 1.1051110e-01, 1.1354390e+00,
 7.4667170e-02, 1.4453950e-01, 4.1204910e-02, 2.2663430e-01, 9.8374080e-02, 6.8068640e-01, 7.0204040e-02, 5.2766550e-01,
 1.4845810e-03, 8.2315960e-02, 2.3101320e-02, 1.3401450e-01, 1.5141830e-01, 5.1294890e-01, 9.7632740e-02, 1.0780340e+00,
 1.5353760e-02, 3.0550720e-02, 1.2979600e-02, 4.3686560e-02, 1.4452950e-01, 1.0279520e+00, 1.5800300e-01, 7.2672760e-01,
 1.5313690e-03, 8.7279050e-02, 3.6503990e-02, 1.2958810e-01, 1.6062390e-01, 5.5931420e-01, 1.5865540e-01, 1.0720160e+00,
 7.2240950e-02, 9.3180810e-02, 4.3467860e-02, 2.3351300e-01, 1.1725950e-01, 5.4063050e-01, 9.1242050e-02, 6.6981950e-01,
 1.1541600e-03, 4.2641510e-02, 1.9582350e-02, 1.1095470e-01, 2.3986200e-01, 5.4143140e-01, 1.6863370e-01, 1.8186420e+00,
 1.5998840e+00, 3.7853660e+00, 8.2564780e-01, 3.5442080e+00, 1.2996640e+00, 1.0991570e+01, 8.6736020e-01, 5.0879610e+00,
 3.2658480e-02, 2.2132910e+00, 4.7524330e-01, 2.1516850e+00, 1.3003940e+00, 5.3843470e+00, 7.8411380e-01, 6.7571520e+00,
 7.9683630e-01, 1.9524530e+00, 3.9511250e-01, 1.8227380e+00, 8.0040000e-01, 7.0101630e+00, 5.1324050e-01, 3.2355220e+00,
 1.9309120e-02, 1.3551810e+00, 2.6997770e-01, 1.3136200e+00, 1.1775830e+00, 5.0494260e+00, 6.8224640e-01, 6.3183690e+00,
 2.3825810e-01, 6.0007980e-01, 1.8097840e-01, 5.1090490e-01, 1.7099220e+00, 1.5393850e+01, 1.6796460e+00, 6.4796390e+00,
 2.8962230e-02, 2.0893770e+00, 6.2033310e-01, 1.8470410e+00, 1.8164230e+00, 8.0060300e+00, 1.6121080e+00, 9.1362400e+00,
 5.7374150e-01, 9.3672890e-01, 3.1019410e-01, 1.3976660e+00, 7.1001550e-01, 4.1435730e+00, 4.9641770e-01, 3.0565880e+00,
 1.1171680e-02, 5.2244340e-01, 1.7031360e-01, 8.0938900e-01, 1.3882520e+00, 3.9664750e+00, 8.7696740e-01, 7.9325590e+00,
 1.1033290e-05, 1.0728100e-04, 6.4836600e-05, 2.7783830e-04, 6.4469600e-05, 2.2406920e-03, 4.8992790e-04, 2.8689570e-03,
 6.3823930e-06, 1.7775610e-03, 1.0575780e-03, 4.7799400e-03, 1.3389720e-04, 2.2783910e-03, 9.1935770e-04, 7.9089100e-03,
 6.7402650e-05, 6.7871420e-04, 3.8057250e-04, 1.7526230e-03, 4.8699250e-04, 1.7528370e-02, 3.5558610e-03, 2.2377720e-02,
 4.6285110e-05, 1.3349790e-02, 7.3691170e-03, 3.5793550e-02, 1.4872350e-03, 2.6207670e-02, 9.8115550e-03, 9.0708740e-02,
 9.7431630e-07, 1.0084620e-05, 8.4272880e-06, 2.3749180e-05, 5.0296290e-05, 1.8608230e-03, 5.6258210e-04, 2.1665400e-03,
 3.3562580e-06, 9.9503510e-04, 8.1857210e-04, 2.4330780e-03, 1.1090450e-04, 2.0088520e-03, 1.1208180e-03, 6.3409760e-03,
 1.5315920e-05, 1.0276360e-04, 9.4290760e-05, 4.2411770e-04, 1.3633330e-04, 3.2696970e-03, 1.0854010e-03, 6.6715590e-03,
 8.4511550e-06, 1.6241850e-03, 1.4670870e-03, 6.9600340e-03, 5.5331840e-04, 6.4969580e-03, 3.9801460e-03, 3.5939870e-02,
 1.2157890e+00, 2.4005750e+00, 6.5984740e-01, 1.9241030e+00, 1.3776750e+00, 9.7232950e+00, 9.6692840e-01, 3.8530010e+00,
 2.8261660e-02, 1.5983730e+00, 4.3251060e-01, 1.3302090e+00, 1.3311690e+00, 4.5996960e+00, 8.4414350e-01, 4.9415290e+00,
 1.1211300e+00, 2.2924790e+00, 5.8463750e-01, 1.8321060e+00, 1.5708690e+00, 1.1481510e+01, 1.0593340e+00, 4.5364580e+00,
 3.0937230e-02, 1.8119830e+00, 4.5491040e-01, 1.5035850e+00, 2.2318600e+00, 7.9864760e+00, 1.3598640e+00, 8.5549960e+00,
 1.4390650e-01, 3.0246820e-01, 1.1495790e-01, 2.2045120e-01, 1.4406400e+00, 1.0823410e+01, 1.4882490e+00, 3.9000420e+00,
 1.9920350e-02, 1.1992770e+00, 4.4871320e-01, 9.0757160e-01, 1.4778770e+00, 5.4359620e+00, 1.3794130e+00, 5.3104140e+00,
 6.6854750e-01, 9.1089380e-01, 3.8012690e-01, 1.1634800e+00, 1.1540640e+00, 5.6204990e+00, 8.4857150e-01, 3.5492660e+00,
 1.4824030e-02, 5.7852900e-01, 2.3767110e-01, 7.6726410e-01, 2.1790780e+00, 5.1957360e+00, 1.4476610e+00, 8.8952340e+00,
 3.2215950e-02, 5.4543240e-02, 2.3159590e-02, 1.0998170e-01, 3.6965770e-02, 2.2370690e-01, 3.4365440e-02, 2.2301370e-01,
 6.9542270e-04, 3.3724250e-02, 1.4096870e-02, 7.0607450e-02, 3.4442610e-02, 1.0204810e-01, 2.8930370e-02, 2.7580600e-01,
 1.6742060e-02, 2.9354250e-02, 1.1564160e-02, 5.9017800e-02, 2.3753800e-02, 1.4886920e-01, 2.1217820e-02, 1.4797540e-01,
 4.2901520e-04, 2.1545580e-02, 8.3558740e-03, 4.4977870e-02, 3.2543930e-02, 9.9855300e-02, 2.6264750e-02, 2.6909300e-01,
 3.2616570e-03, 5.8782810e-03, 3.4512080e-03, 1.0778290e-02, 3.3063840e-02, 2.1299770e-01, 4.5242680e-02, 1.9308420e-01,
 4.1926950e-04, 2.1643560e-02, 1.2509500e-02, 4.1205640e-02, 3.2707430e-02, 1.0315670e-01, 4.0436830e-02, 2.5352210e-01,
 1.5514750e-02, 1.8125640e-02, 1.1684660e-02, 5.8243960e-02, 2.7119570e-02, 1.1325060e-01, 2.6412890e-02, 1.7991650e-01,
 3.1946070e-04, 1.0690280e-02, 6.7842560e-03, 3.5667730e-02, 4.9378240e-02, 1.0095380e-01, 4.3451470e-02, 4.3481010e-01,
 5.0937150e-01, 1.0915890e+00, 3.2902370e-01, 1.3105200e+00, 4.4560550e-01, 3.4133800e+00, 3.7222460e-01, 2.0260100e+00,
 1.3400840e-02, 8.2258320e-01, 2.4408330e-01, 1.0253990e+00, 3.9685660e-01, 1.4883230e+00, 2.9951870e-01, 2.3949730e+00,
 2.6070250e-01, 5.7857810e-01, 1.6180170e-01, 6.9259390e-01, 2.8200480e-01, 2.2370870e+00, 2.2633750e-01, 1.3239510e+00,
 8.1419490e-03, 5.1756930e-01, 1.4248860e-01, 6.4330050e-01, 3.6930090e-01, 1.4342870e+00, 2.6780340e-01, 2.3012930e+00,
 7.3853000e-02, 1.6847480e-01, 7.0215580e-02, 1.8392420e-01, 5.7078190e-01, 4.6542140e+00, 7.0177460e-01, 2.5120190e+00,
 1.1570240e-02, 7.5601850e-01, 3.1018550e-01, 8.5696890e-01, 5.3969720e-01, 2.1545450e+00, 5.9953330e-01, 3.1526730e+00,
 1.7979380e-01, 2.6587510e-01, 1.2166850e-01, 5.0867450e-01, 2.3960710e-01, 1.2665200e+00, 2.0968390e-01, 1.1979730e+00,
 4.5119730e-03, 1.9111410e-01, 8.6096150e-02, 3.7965040e-01, 4.1700310e-01, 1.0791480e+00, 3.2971640e-01, 2.7673410e+00,
 1.7325160e-07, 1.5258100e-06, 1.2743200e-06, 5.0669020e-06, 1.0901850e-06, 3.4318860e-05, 1.0369640e-05, 5.6344000e-05,
 1.2916520e-07, 3.2583050e-05, 2.6789240e-05, 1.1234730e-04, 2.0153770e-06, 3.1061190e-05, 1.7320300e-05, 1.3825460e-04,
 1.0876240e-06, 9.9196010e-06, 7.6864450e-06, 3.2844960e-05, 8.4624780e-06, 2.7588130e-04, 7.7340370e-05, 4.5161610e-04,
 9.6257160e-07, 2.5146160e-04, 1.9181980e-04, 8.6451960e-04, 2.3003510e-05, 3.6715400e-04, 1.8994970e-04, 1.6294540e-03,
 1.4895200e-08, 1.3964050e-07, 1.6125770e-07, 4.2167060e-07, 8.2804830e-07, 2.7747910e-05, 1.1592890e-05, 4.1425210e-05,
 6.6128940e-08, 1.7757420e-05, 2.0187350e-05, 5.5676320e-05, 1.6252060e-06, 2.6663200e-05, 2.0557970e-05, 1.0791790e-04,
 2.3671590e-07, 1.4385630e-06, 1.8240620e-06, 7.6128810e-06, 2.2691320e-06, 4.9291320e-05, 2.2611740e-05, 1.2896250e-04,
 1.6834110e-07, 2.9303190e-05, 3.6577680e-05, 1.6101410e-04, 8.1973240e-06, 8.7179080e-05, 7.3804370e-05, 6.1837470e-04,
 2.5305410e-01, 4.5255960e-01, 1.7190350e-01, 4.6511660e-01, 3.0879860e-01, 1.9740000e+00, 2.7127450e-01, 1.0030110e+00,
 7.5812810e-03, 3.8835450e-01, 1.4522050e-01, 4.1442230e-01, 2.6558330e-01, 8.3119340e-01, 2.1079980e-01, 1.1450050e+00,
 2.3979550e-01, 4.4411520e-01, 1.5651570e-01, 4.5510750e-01, 3.6182490e-01, 2.3953140e+00, 3.0540590e-01, 1.2135380e+00,
 8.5281770e-03, 4.5241210e-01, 1.5695920e-01, 4.8137240e-01, 4.5757750e-01, 1.4830580e+00, 3.4896300e-01, 2.0370220e+00,
 2.9161510e-02, 5.5515530e-02, 2.9157770e-02, 5.1882420e-02, 3.1438230e-01, 2.1393020e+00, 4.0650380e-01, 9.8844030e-01,
 5.2025500e-03, 2.8369000e-01, 1.4668120e-01, 2.7528240e-01, 2.8706510e-01, 9.5636530e-01, 3.3536880e-01, 1.1979780e+00,
 1.3696190e-01, 1.6902090e-01, 9.7472500e-02, 2.7682450e-01, 2.5460720e-01, 1.1231060e+00, 2.3432320e-01, 9.0940550e-01,
 3.9140240e-03, 1.3835270e-01, 7.8545220e-02, 2.3527750e-01, 4.2791030e-01, 9.2412850e-01, 3.5582220e-01, 2.0286900e+00,
 2.5194540e-02, 5.2429350e-02, 1.4587290e-02, 9.0821930e-02, 3.5671780e-02, 2.6533980e-01, 2.6708850e-02, 2.2724340e-01,
 4.4646380e-04, 2.6612010e-02, 7.2890050e-03, 4.7865500e-02, 3.2303630e-02, 1.1764090e-01, 2.1853320e-02, 2.7314540e-01,
 1.4026360e-02, 3.0227710e-02, 7.8029450e-03, 5.2210020e-02, 2.4556070e-02, 1.8915970e-01, 1.7665850e-02, 1.6152870e-01,
 2.9506030e-04, 1.8213540e-02, 4.6284770e-03, 3.2664170e-02, 3.2698370e-02, 1.2331770e-01, 2.1253850e-02, 2.8549140e-01,
 3.6022410e-03, 7.9796330e-03, 3.0698260e-03, 1.2569520e-02, 4.5058570e-02, 3.5677710e-01, 4.9657010e-02, 2.7784690e-01,
 3.8012780e-04, 2.4119210e-02, 9.1344930e-03, 3.9448250e-02, 4.3321220e-02, 1.6793830e-01, 4.3135980e-02, 3.5457240e-01,
 2.0172230e-02, 2.8966790e-02, 1.2235820e-02, 7.9964020e-02, 4.3509240e-02, 2.2332500e-01, 3.4128940e-02, 3.0479250e-01,
 3.4097960e-04, 1.4024850e-02, 5.8320520e-03, 4.0199540e-02, 7.6995350e-02, 1.9348610e-01, 5.4568450e-02, 7.1591800e-01,
 5.7326740e-01, 1.5100100e+00, 2.9823450e-01, 1.5574030e+00, 6.1881760e-01, 5.8263270e+00, 4.1631830e-01, 2.9709020e+00,
 1.2381020e-02, 9.3411950e-01, 1.8162300e-01, 1.0003500e+00, 5.3564380e-01, 2.4690940e+00, 3.2559270e-01, 3.4133270e+00,
 3.1431740e-01, 8.5739980e-01, 1.5711390e-01, 8.8173200e-01, 4.1953610e-01, 4.0906630e+00, 2.7119240e-01, 2.0797900e+00,
 8.0584870e-03, 6.2963930e-01, 1.1358300e-01, 6.7231640e-01, 5.3397810e-01, 2.5490440e+00, 3.1186560e-01, 3.5135790e+00,
 1.1737880e-01, 3.2912020e-01, 8.9880040e-02, 3.0867050e-01, 1.1193900e+00, 1.1219040e+01, 1.1084520e+00, 5.2019810e+00,
 1.5096140e-02, 1.2124220e+00, 3.2595160e-01, 1.1806560e+00, 1.0287070e+00, 5.0477190e+00, 9.2037110e-01, 6.3453420e+00,
 3.3641150e-01, 6.1146540e-01, 1.8335070e-01, 1.0050110e+00, 5.5320400e-01, 3.5941470e+00, 3.8990530e-01, 2.9205680e+00,
 6.9305000e-03, 3.6081860e-01, 1.0650990e-01, 6.1576720e-01, 9.3574030e-01, 2.9764270e+00, 5.9588830e-01, 6.5571240e+00,
 5.9304640e-08, 6.4196280e-07, 3.5131610e-07, 1.8314230e-06, 4.6047010e-07, 1.7816890e-05, 3.5275480e-06, 2.5129470e-05,
 3.6296000e-08, 1.1253900e-05, 6.0629210e-06, 3.3335790e-05, 8.2734680e-07, 1.5672840e-05, 5.7265740e-06, 5.9930180e-05,
 3.9883300e-07, 4.4709970e-06, 2.2701040e-06, 1.2717900e-05, 3.8291220e-06, 1.5343420e-04, 2.8184880e-05, 2.1577730e-04,
 2.8976580e-07, 9.3043010e-05, 4.6506710e-05, 2.7480430e-04, 1.0116400e-05, 1.9846240e-04, 6.7278880e-05, 7.5667380e-04,
 7.2004030e-09, 8.2969790e-08, 6.2782560e-08, 2.1523780e-07, 4.9391890e-07, 2.0343620e-05, 5.5692930e-06, 2.6091520e-05,
 2.6242420e-08, 8.6614460e-06, 6.4520820e-06, 2.3330150e-05, 9.4219040e-07, 1.8999440e-05, 9.5988400e-06, 6.6063020e-05,
 1.3471390e-07, 1.0062640e-06, 8.3605120e-07, 4.5747650e-06, 1.5934350e-06, 4.2544470e-05, 1.2788420e-05, 9.5625250e-05,
 7.8646090e-08, 1.6826740e-05, 1.3762940e-05, 7.9430150e-05, 5.5947020e-06, 7.3133320e-05, 4.0569090e-05, 4.4564730e-04,
 2.8759360e-01, 6.3217860e-01, 1.5734720e-01, 5.5816480e-01, 4.3304280e-01, 3.4025210e+00, 3.0638860e-01, 1.4852380e+00,
 7.0731100e-03, 4.4534260e-01, 1.0911990e-01, 4.0826820e-01, 3.6198170e-01, 1.3924700e+00, 2.3140040e-01, 1.6478890e+00,
 2.9194940e-01, 6.6460000e-01, 1.5347320e-01, 5.8508000e-01, 5.4356890e-01, 4.4229990e+00, 3.6952330e-01, 1.9250610e+00,
 8.5236320e-03, 5.5577730e-01, 1.2634660e-01, 5.0802420e-01, 6.6811480e-01, 2.6615990e+00, 4.1036850e-01, 3.1406310e+00,
 4.6803130e-02, 1.0951600e-01, 3.7690110e-02, 8.7926500e-02, 6.2260500e-01, 5.2074450e+00, 6.4837650e-01, 2.0669960e+00,
 6.8546150e-03, 4.5941900e-01, 1.5565010e-01, 3.8298340e-01, 5.5254190e-01, 2.2625940e+00, 5.1989500e-01, 2.4348280e+00,
 2.5878500e-01, 3.9253470e-01, 1.4833030e-01, 5.5230460e-01, 5.9360810e-01, 3.2184600e+00, 4.3999990e-01, 2.2388310e+00,
 6.0710660e-03, 2.6377110e-01, 9.8122670e-02, 3.8535100e-01, 9.6964360e-01, 2.5738890e+00, 6.4938260e-01, 4.8541110e+00,
 6.4784060e-02, 1.1034310e-01, 4.3594220e-02, 2.2506170e-01, 7.7510650e-02, 4.7189780e-01, 6.7450350e-02, 4.7585740e-01,
 1.1857000e-03, 5.7846280e-02, 2.2498290e-02, 1.2250680e-01, 1.0301180e-01, 3.0704560e-01, 8.0992620e-02, 8.3941810e-01,
 2.4323050e-02, 4.2902980e-02, 1.5726210e-02, 8.7252120e-02, 3.5983780e-02, 2.2687440e-01, 3.0086730e-02, 2.2811130e-01,
 5.2845850e-04, 2.6699530e-02, 9.6345350e-03, 5.6379440e-02, 7.0319040e-02, 2.1706070e-01, 5.3122310e-02, 5.9168280e-01,
 6.9372070e-03, 1.2577770e-02, 6.8709730e-03, 2.3328120e-02, 7.3327020e-02, 4.7521780e-01, 9.3920360e-02, 4.3575380e-01,
 7.5608130e-04, 3.9265490e-02, 2.1116200e-02, 7.5616320e-02, 1.0346330e-01, 3.2827990e-01, 1.1973410e-01, 8.1609270e-01,
 3.1678410e-02, 3.7232210e-02, 2.2332380e-02, 1.2101880e-01, 5.7738510e-02, 2.4256630e-01, 5.2638010e-02, 3.8979600e-01,
 5.5305050e-04, 1.8618450e-02, 1.0993860e-02, 6.2835700e-02, 1.4995040e-01, 3.0841960e-01, 1.2351430e-01, 1.3436790e+00,
 7.0588730e-01, 1.5218330e+00, 4.2680410e-01, 1.8481110e+00, 6.4389570e-01, 4.9620000e+00, 5.0346680e-01, 2.9791360e+00,
 1.5745680e-02, 9.7233640e-01, 2.6845310e-01, 1.2260440e+00, 8.1795230e-01, 3.0860190e+00, 5.7785520e-01, 5.0231790e+00,
 2.6101050e-01, 5.8274940e-01, 1.5163400e-01, 7.0562690e-01, 2.9439710e-01, 2.3494540e+00, 2.2117410e-01, 1.4064780e+00,
 6.9114630e-03, 4.4199490e-01, 1.1321980e-01, 5.5569850e-01, 5.4990380e-01, 2.1485700e+00, 3.7327000e-01, 3.4870810e+00,
 1.0824750e-01, 2.4842300e-01, 9.6334970e-02, 2.7432940e-01, 8.7233710e-01, 7.1559540e+00, 1.0039510e+00, 3.9067960e+00,
 1.4378750e-02, 9.4518800e-01, 3.6082850e-01, 1.0837460e+00, 1.1765040e+00, 4.7250470e+00, 1.2233690e+00, 6.9936840e+00,
 2.5298610e-01, 3.7636270e-01, 1.6025100e-01, 7.2835910e-01, 3.5154900e-01, 1.8694130e+00, 2.8797320e-01, 1.7886150e+00,
 5.3829120e-03, 2.2937740e-01, 9.6146880e-02, 4.6091230e-01, 8.7267950e-01, 2.2719760e+00, 6.4588740e-01, 5.8933440e+00,
 9.7025720e-08, 8.5964080e-07, 6.6801890e-07, 2.8875920e-06, 6.3661130e-07, 2.0161090e-05, 5.6681110e-06, 3.3481530e-05,
 6.1331540e-08, 1.5564580e-05, 1.1906920e-05, 5.4285620e-05, 1.6786470e-06, 2.6027260e-05, 1.3503900e-05, 1.1718350e-04,
 4.4004860e-07, 4.0375970e-06, 2.9110380e-06, 1.3523030e-05, 3.5701260e-06, 1.1708880e-04, 3.0541680e-05, 1.9388270e-04,
 3.3020500e-07, 8.6781930e-05, 6.1594880e-05, 3.0179290e-04, 1.3842340e-05, 2.2226480e-04, 1.0699280e-04, 9.9779410e-04,
 8.8227730e-09, 8.3210340e-08, 8.9408710e-08, 2.5416500e-07, 5.1142120e-07, 1.7240920e-05, 6.7021720e-06, 2.6035830e-05,
 3.3210780e-08, 8.9716980e-06, 9.4900310e-06, 2.8453900e-05, 1.4317290e-06, 2.3630440e-05, 1.6952480e-05, 9.6745200e-05,
 1.3460410e-07, 8.2293730e-07, 9.7089250e-07, 4.4051790e-06, 1.3454100e-06, 2.9401720e-05, 1.2549600e-05, 7.7811200e-05,
 8.1161470e-08, 1.4212870e-05, 1.6507320e-05, 7.8996370e-05, 6.9326050e-06, 7.4172650e-05, 5.8426140e-05, 5.3218150e-04,
 3.7068230e-01, 6.6691650e-01, 2.3570790e-01, 6.9332050e-01, 4.7165910e-01, 3.0332430e+00, 3.8784890e-01, 1.5589870e+00,
 9.4158600e-03, 4.8523590e-01, 1.6882860e-01, 5.2377430e-01, 5.7860610e-01, 1.8217610e+00, 4.2988570e-01, 2.5384770e+00,
 2.5377080e-01, 4.7282820e-01, 1.5504550e-01, 4.9011540e-01, 3.9926700e-01, 2.6591000e+00, 3.1545910e-01, 1.3627060e+00,
 7.6521890e-03, 4.0838590e-01, 1.3183080e-01, 4.3953600e-01, 7.2020950e-01, 2.3483320e+00, 5.1413160e-01, 3.2626740e+00,
 4.5180150e-02, 8.6528520e-02, 4.2285620e-02, 8.1797790e-02, 5.0787890e-01, 3.4768120e+00, 6.1470580e-01, 1.6249360e+00,
 6.8341230e-03, 3.7490200e-01, 1.8036060e-01, 3.6798380e-01, 6.6147240e-01, 2.2169820e+00, 7.2336020e-01, 2.8090780e+00,
 2.0370860e-01, 2.5290490e-01, 1.3570400e-01, 4.1898450e-01, 3.9486150e-01, 1.7522740e+00, 3.4016540e-01, 1.4352100e+00,
 4.9358520e-03, 1.7552270e-01, 9.2716940e-02, 3.0192750e-01, 9.4657740e-01, 2.0565670e+00, 7.3677880e-01, 4.5667020e+00,
 1.6017720e-01, 2.9940940e-01, 9.1997200e-02, 4.7083870e-01, 1.7050530e-01, 1.1392320e+00, 1.2664090e-01, 8.8570960e-01,
 2.5782100e-03, 1.3804040e-01, 4.1754750e-02, 2.2539360e-01, 1.8487710e-01, 6.0476490e-01, 1.2406660e-01, 1.2747130e+00,
 9.5253710e-02, 1.8439060e-01, 5.2565540e-02, 2.8911980e-01, 1.2537600e-01, 8.6752280e-01, 8.9473800e-02, 6.7250030e-01,
 1.8200590e-03, 1.0091730e-01, 2.8321640e-02, 1.6429840e-01, 1.9989430e-01, 6.7716750e-01, 1.2888950e-01, 1.4231620e+00,
 1.6523710e-02, 3.2878670e-02, 1.3968640e-02, 4.7015440e-02, 1.5539280e-01, 1.1052160e+00, 1.6987900e-01, 7.8135060e-01,
 1.5838060e-03, 9.0267630e-02, 3.7753950e-02, 1.3402540e-01, 1.7888450e-01, 6.2290000e-01, 1.7669220e-01, 1.1938890e+00,
 1.2728940e-01, 1.6418570e-01, 7.6590900e-02, 4.1145280e-01, 2.0641370e-01, 9.5168020e-01, 1.6061480e-01, 1.1790940e+00,
 1.9543600e-03, 7.2205590e-02, 3.3159130e-02, 1.8788160e-01, 4.3736120e-01, 9.8723860e-01, 3.0748430e-01, 3.3160880e+00,
 1.5945300e+00, 3.7726970e+00, 8.2288470e-01, 3.5323470e+00, 1.2940670e+00, 1.0944240e+01, 8.6362510e-01, 5.0660500e+00,
 3.1280190e-02, 2.1198840e+00, 4.5518660e-01, 2.0608770e+00, 1.3411850e+00, 5.5532470e+00, 8.0871040e-01, 6.9691140e+00,
 9.3387000e-01, 2.2882210e+00, 4.6306090e-01, 2.1361990e+00, 9.3714330e-01, 8.2078050e+00, 6.0092440e-01, 3.7882910e+00,
 2.1747490e-02, 1.5263150e+00, 3.0407080e-01, 1.4795050e+00, 1.4281660e+00, 6.1239150e+00, 8.2742450e-01, 7.6628810e+00,
 2.3556210e-01, 5.9328970e-01, 1.7893060e-01, 5.0512380e-01, 1.6889460e+00, 1.5205010e+01, 1.6590410e+00, 6.4001510e+00,
 2.7518150e-02, 1.9851990e+00, 5.8940280e-01, 1.7549460e+00, 1.8584230e+00, 8.1911500e+00, 1.6493840e+00, 9.3474930e+00,
 9.2873180e-01, 1.5163100e+00, 5.0212010e-01, 2.2624410e+00, 1.1482160e+00, 6.7008610e+00, 8.0279180e-01, 4.9430220e+00,
 1.7378880e-02, 8.1272320e-01, 2.6494320e-01, 1.2591010e+00, 2.3254770e+00, 6.6442900e+00, 1.4690190e+00, 1.3287920e+01,
 3.1611320e-07, 3.0736920e-06, 1.8576230e-06, 7.9603020e-06, 1.8453300e-06, 6.4135900e-05, 1.4023330e-05, 8.2118880e-05,
 1.7573180e-07, 4.8943090e-05, 2.9119180e-05, 1.3161010e-04, 3.9698930e-06, 6.7551560e-05, 2.7257860e-05, 2.3448970e-04,
 2.2708450e-06, 2.2866380e-05, 1.2821770e-05, 5.9047160e-05, 1.6391340e-05, 5.8997530e-04, 1.1968420e-04, 7.5319590e-04,
 1.4985840e-06, 4.3222960e-04, 2.3859170e-04, 1.1588970e-03, 5.1851330e-05, 9.1371070e-04, 3.4207250e-04, 3.1624920e-03,
 2.7691790e-08, 2.8662290e-07, 2.3951840e-07, 6.7499370e-07, 1.4281330e-06, 5.2836960e-05, 1.5974180e-05, 6.1517600e-05,
 9.1671800e-08, 2.7178090e-05, 2.2358230e-05, 6.6456340e-05, 3.2618970e-06, 5.9083860e-05, 3.2965220e-05, 1.8649920e-04,
 7.1270610e-07, 4.7819660e-06, 4.3876950e-06, 1.9735750e-05, 6.3379800e-06, 1.5200450e-04, 5.0459050e-05, 3.1015320e-04,
 3.7793120e-07, 7.2632690e-05, 6.5607350e-05, 3.1124900e-04, 2.6644790e-05, 3.1285790e-04, 1.9166200e-04, 1.7306670e-03,
 1.1913550e+00, 2.3523300e+00, 6.4658630e-01, 1.8854340e+00, 1.3486880e+00, 9.5187090e+00, 9.4658340e-01, 3.7719310e+00,
 2.6613990e-02, 1.5051870e+00, 4.0729500e-01, 1.2526570e+00, 1.3498510e+00, 4.6642500e+00, 8.5599070e-01, 5.0108820e+00,
 1.2918500e+00, 2.6415660e+00, 6.7366320e-01, 2.1110900e+00, 1.8083310e+00, 1.3217110e+01, 1.2194690e+00, 5.2222140e+00,
 3.4258380e-02, 2.0065020e+00, 5.0374570e-01, 1.6649980e+00, 2.6612950e+00, 9.5231620e+00, 1.6215170e+00, 1.0201070e+01,
 1.3988690e-01, 2.9401970e-01, 1.1174690e-01, 2.1429350e-01, 1.3990510e+00, 1.0510960e+01, 1.4452860e+00, 3.7874560e+00,
 1.8609000e-02, 1.1203290e+00, 4.1917460e-01, 8.4782640e-01, 1.4866370e+00, 5.4681810e+00, 1.3875890e+00, 5.3418890e+00,
 1.0640090e+00, 1.4497080e+00, 6.0498060e-01, 1.8517040e+00, 1.8349510e+00, 8.9365400e+00, 1.3492200e+00, 5.6432990e+00,
 2.2672980e-02, 8.8484530e-01, 3.6351190e-01, 1.1735110e+00, 3.5888510e+00, 8.5571620e+00, 2.3842380e+00, 1.4650080e+01,
 3.4880610e-02, 5.9054660e-02, 2.5075180e-02, 1.1907860e-01, 3.9984770e-02, 2.4197700e-01, 3.7172070e-02, 2.4122720e-01,
 7.2358810e-04, 3.5090120e-02, 1.4667810e-02, 7.3467130e-02, 3.8590380e-02, 1.1433730e-01, 3.2414320e-02, 3.0902010e-01,
 2.1315480e-02, 3.7372950e-02, 1.4723140e-02, 7.5139690e-02, 3.0213510e-02, 1.8935330e-01, 2.6987870e-02, 1.8821640e-01,
 5.2491440e-04, 2.6361740e-02, 1.0223690e-02, 5.5031920e-02, 4.2877180e-02, 1.3156100e-01, 3.4604260e-02, 3.5453450e-01,
 3.5032020e-03, 6.3136030e-03, 3.7067910e-03, 1.1576480e-02, 3.5478220e-02, 2.2855110e-01, 4.8546380e-02, 2.0718360e-01,
 4.3276240e-04, 2.2340090e-02, 1.2912080e-02, 4.2531720e-02, 3.6353240e-02, 1.1465530e-01, 4.4944220e-02, 2.8178160e-01,
 2.7282740e-02, 3.1873980e-02, 2.0547500e-02, 1.0242220e-01, 4.7643930e-02, 1.9895980e-01, 4.6402430e-02, 3.1607900e-01,
 5.3987090e-04, 1.8065980e-02, 1.1465020e-02, 6.0276480e-02, 8.9856290e-02, 1.8371120e-01, 7.9071030e-02, 7.9124790e-01,
 5.0665580e-01, 1.0857690e+00, 3.2726940e-01, 1.3035330e+00, 4.4280290e-01, 3.3919120e+00, 3.6988360e-01, 2.0132670e+00,
 1.2809720e-02, 7.8629870e-01, 2.3331670e-01, 9.8016800e-01, 4.0849030e-01, 1.5319520e+00, 3.0829900e-01, 2.4651810e+00,
 3.0492760e-01, 6.7672700e-01, 1.8924940e-01, 8.1008420e-01, 3.2952590e-01, 2.6140620e+00, 2.6447800e-01, 1.5470530e+00,
 9.1518570e-03, 5.8176740e-01, 1.6016250e-01, 7.2309400e-01, 4.4699400e-01, 1.7360300e+00, 3.2414350e-01, 2.7854360e+00,
 7.2871920e-02, 1.6623670e-01, 6.9282810e-02, 1.8148090e-01, 5.6265710e-01, 4.5879630e+00, 6.9178520e-01, 2.4762620e+00,
 1.0971440e-02, 7.1689210e-01, 2.9413240e-01, 8.1261810e-01, 5.5107660e-01, 2.1999740e+00, 6.1217440e-01, 3.2191460e+00,
 2.9045770e-01, 4.2952240e-01, 1.9655600e-01, 8.2176610e-01, 3.8671360e-01, 2.0440990e+00, 3.3841920e-01, 1.9334670e+00,
 7.0049350e-03, 2.9670880e-01, 1.3366610e-01, 5.8941530e-01, 6.9713570e-01, 1.8040940e+00, 5.5121200e-01, 4.6263730e+00,
 4.9539180e-09, 4.3628660e-08, 3.6437620e-08, 1.4488190e-07, 3.1142510e-08, 9.8036110e-07, 2.9622170e-07, 1.6095370e-06,
 3.5493300e-09, 8.9534980e-07, 7.3614150e-07, 3.0871920e-06, 5.9634510e-08, 9.1909320e-07, 5.1250330e-07, 4.0909200e-06,
 3.6569900e-08, 3.3353310e-07, 2.5844630e-07, 1.1043670e-06, 2.8426530e-07, 9.2672020e-06, 2.5979610e-06, 1.5170360e-05,
 3.1103350e-08, 8.1254190e-06, 6.1982270e-06, 2.7935020e-05, 8.0040300e-07, 1.2775060e-05, 6.6092640e-06, 5.6696540e-05,
 4.2250480e-10, 3.9609260e-09, 4.5741000e-09, 1.1960760e-08, 2.3465110e-08, 7.8631600e-07, 3.2851770e-07, 1.1739010e-06,
 1.8026280e-09, 4.8405490e-07, 5.5029300e-07, 1.5176970e-06, 4.7704950e-08, 7.8264960e-07, 6.0344170e-07, 3.1677330e-06,
 1.0993320e-08, 6.6808280e-08, 8.4711260e-08, 3.5354970e-07, 1.0527920e-07, 2.2869340e-06, 1.0491000e-06, 5.9833770e-06,
 7.5131330e-09, 1.3078130e-06, 1.6324770e-06, 7.1861230e-06, 3.9395210e-07, 4.1897060e-06, 3.5469360e-06, 2.9718230e-05,
 2.4747450e-01, 4.4258110e-01, 1.6811320e-01, 4.5486130e-01, 3.0169910e-01, 1.9286170e+00, 2.6503770e-01, 9.7995160e-01,
 7.1250690e-03, 3.6498490e-01, 1.3648170e-01, 3.8948400e-01, 2.6877430e-01, 8.4118020e-01, 2.1333250e-01, 1.1587620e+00,
 2.7576000e-01, 5.1072360e-01, 1.7998990e-01, 5.2336460e-01, 4.1569080e-01, 2.7519120e+00, 3.5087250e-01, 1.3942010e+00,
 9.4248810e-03, 4.9998140e-01, 1.7346290e-01, 5.3198690e-01, 5.4453370e-01, 1.7648930e+00, 4.1527850e-01, 2.4241300e+00,
 2.8290510e-02, 5.3857390e-02, 2.8286890e-02, 5.0332800e-02, 3.0469870e-01, 2.0734070e+00, 3.9398260e-01, 9.5799430e-01,
 4.8503880e-03, 2.6448700e-01, 1.3675230e-01, 2.5664850e-01, 2.8819150e-01, 9.6011770e-01, 3.3668460e-01, 1.2026780e+00,
 2.1754380e-01, 2.6846490e-01, 1.5482080e-01, 4.3969500e-01, 4.0401680e-01, 1.7821720e+00, 3.7182960e-01, 1.4430660e+00,
 5.9744780e-03, 2.1118550e-01, 1.1989360e-01, 3.5913420e-01, 7.0334700e-01, 1.5189700e+00, 5.8485730e-01, 3.3345140e+00,
 7.6382750e-02, 1.5895110e-01, 4.4224560e-02, 2.7534660e-01, 9.7630820e-02, 7.2621390e-01, 7.3099990e-02, 6.2194700e-01,
 2.2057040e-03, 1.3147360e-01, 3.6010500e-02, 2.3647410e-01, 1.1162770e-01, 4.0651710e-01, 7.5515820e-02, 9.4387460e-01,
 3.7259650e-02, 8.0296960e-02, 2.0727760e-02, 1.3869080e-01, 5.8887880e-02, 4.5362370e-01, 4.2364460e-02, 3.8736190e-01,
 1.2772520e-03, 7.8842490e-02, 2.0035680e-02, 1.4139610e-01, 9.9003720e-02, 3.7337970e-01, 6.4352140e-02, 8.6440740e-01,
 9.5292220e-03, 2.1109000e-02, 8.1207950e-03, 3.3250910e-02, 1.0760570e-01, 8.5203010e-01, 1.1858740e-01, 6.6353440e-01,
 1.6386510e-03, 1.0397280e-01, 3.9376870e-02, 1.7005310e-01, 1.3062220e-01, 5.0636770e-01, 1.3006370e-01, 1.0691070e+00,
 4.8389510e-02, 6.9486050e-02, 2.9351510e-02, 1.9181910e-01, 9.4221920e-02, 4.8362400e-01, 7.3908320e-02, 6.6004680e-01,
 1.3329010e-03, 5.4823600e-02, 2.2797680e-02, 1.5714130e-01, 2.1052000e-01, 5.2902800e-01, 1.4920060e-01, 1.9574570e+00,
 1.3935190e+00, 3.6705870e+00, 7.2495900e-01, 3.7857890e+00, 1.3579740e+00, 1.2785670e+01, 9.1359610e-01, 6.5195430e+00,
 4.9043780e-02, 3.7002410e+00, 7.1944630e-01, 3.9625940e+00, 1.4841000e+00, 6.8410820e+00, 9.0211470e-01, 9.4572520e+00,
 6.6946660e-01, 1.8261810e+00, 3.3463780e-01, 1.8780060e+00, 8.0668320e-01, 7.8655190e+00, 5.2144820e-01, 3.9990170e+00,
 2.7969590e-02, 2.1853670e+00, 3.9422660e-01, 2.3334920e+00, 1.2963300e+00, 6.1882710e+00, 7.5711080e-01, 8.5298580e+00,
 2.4896660e-01, 6.9808100e-01, 1.9064020e-01, 6.5470620e-01, 2.1434130e+00, 2.1482270e+01, 2.1224700e+00, 9.9607790e+00,
 5.2178220e-02, 4.1906110e+00, 1.1266180e+00, 4.0808120e+00, 2.4869930e+00, 1.2203320e+01, 2.2250810e+00, 1.5340440e+01,
 6.4704540e-01, 1.1760770e+00, 3.5265200e-01, 1.9330130e+00, 9.6055550e-01, 6.2406950e+00, 6.7701180e-01, 5.0711270e+00,
 2.1722040e-02, 1.1309020e+00, 3.3383050e-01, 1.9299790e+00, 2.0514020e+00, 6.5251530e+00, 1.3063520e+00, 1.4375030e+01,
 2.5640910e-06, 2.7755860e-05, 1.5189480e-05, 7.9183270e-05, 1.7972950e-05, 6.9542450e-04, 1.3768640e-04, 9.8084730e-04,
 2.5572640e-06, 7.9290300e-04, 4.2716800e-04, 2.3487000e-03, 4.0772180e-05, 7.7236740e-04, 2.8220920e-04, 2.9533980e-03,
 1.5109180e-05, 1.6937690e-04, 8.5999430e-05, 4.8179830e-04, 1.3095500e-04, 5.2474100e-03, 9.6391580e-04, 7.3795300e-03,
 1.7888290e-05, 5.7438830e-03, 2.8710280e-03, 1.6964670e-02, 4.3682490e-04, 8.5695820e-03, 2.9050930e-03, 3.2673070e-02,
 2.7164230e-07, 3.1301170e-06, 2.3685340e-06, 8.1200570e-06, 1.6821680e-05, 6.9285460e-04, 1.8967660e-04, 8.8861410e-04,
 1.6133050e-06, 5.3247970e-04, 3.9665460e-04, 1.4342680e-03, 4.0514530e-05, 8.1698270e-04, 4.1275370e-04, 2.8407340e-03,
 4.6085640e-06, 3.4424300e-05, 2.8601320e-05, 1.5650270e-04, 4.9210820e-05, 1.3139220e-03, 3.9495090e-04, 2.9532410e-03,
 4.3843210e-06, 9.3804820e-04, 7.6724930e-04, 4.4280310e-03, 2.1815330e-04, 2.8516750e-03, 1.5819030e-03, 1.7377050e-02,
 6.4315360e-01, 1.4137590e+00, 3.5187990e-01, 1.2482390e+00, 8.7425780e-01, 6.8692530e+00, 6.1855930e-01, 2.9985050e+00,
 2.5776140e-02, 1.6229380e+00, 3.9765950e-01, 1.4878290e+00, 9.2268550e-01, 3.5493850e+00, 5.8983600e-01, 4.2004420e+00,
 5.7206850e-01, 1.3022690e+00, 3.0072750e-01, 1.1464520e+00, 9.6154200e-01, 7.8240290e+00, 6.5366530e-01, 3.4053210e+00,
 2.7216810e-02, 1.7746520e+00, 4.0343730e-01, 1.6221720e+00, 1.4921870e+00, 5.9444920e+00, 9.1652870e-01, 7.0143740e+00,
 9.1328470e-02, 2.1370210e-01, 7.3545940e-02, 1.7157390e-01, 1.0967740e+00, 9.1733760e+00, 1.1421730e+00, 3.6411970e+00,
 2.1796480e-02, 1.4608730e+00, 4.9494020e-01, 1.2178210e+00, 1.2289330e+00, 5.0323350e+00, 1.1563210e+00, 5.4154070e+00,
 4.5791310e-01, 6.9457940e-01, 2.6246640e-01, 9.7728790e-01, 9.4823690e-01, 5.1412080e+00, 7.0286140e-01, 3.5763370e+00,
 1.7505760e-02, 7.6057680e-01, 2.8293410e-01, 1.1111490e+00, 1.9556340e+00, 5.1911710e+00, 1.3097130e+00, 9.7900560e+00,
 8.1232560e-02, 1.3835900e-01, 5.4662670e-02, 2.8220420e-01, 8.7739780e-02, 5.3417450e-01, 7.6351820e-02, 5.3865660e-01,
 2.4227520e-03, 1.1819780e-01, 4.5970950e-02, 2.5031930e-01, 1.4722460e-01, 4.3883010e-01, 1.1575480e-01, 1.1996980e+00,
 2.6722990e-02, 4.7136180e-02, 1.7277910e-02, 9.5861210e-02, 3.5690030e-02, 2.2502240e-01, 2.9841120e-02, 2.2624910e-01,
 9.4612790e-04, 4.7801610e-02, 1.7249230e-02, 1.0093920e-01, 8.8058540e-02, 2.7181890e-01, 6.6523550e-02, 7.4094750e-01,
 7.5900120e-03, 1.3761370e-02, 7.5175440e-03, 2.5523340e-02, 7.2426090e-02, 4.6937900e-01, 9.2766410e-02, 4.3039990e-01,
 1.3480260e-03, 7.0006900e-02, 3.7648320e-02, 1.3481720e-01, 1.2902550e-01, 4.0938670e-01, 1.4931630e-01, 1.0177210e+00,
 3.1429230e-02, 3.6939340e-02, 2.2156720e-02, 1.2006690e-01, 5.1714120e-02, 2.1725710e-01, 4.7145800e-02, 3.4912500e-01,
 8.9414340e-04, 3.0101350e-02, 1.7774300e-02, 1.0158950e-01, 1.6957020e-01, 3.4877380e-01, 1.3967510e-01, 1.5194880e+00,
 7.0968230e-01, 1.5300150e+00, 4.2909860e-01, 1.8580470e+00, 5.8440960e-01, 4.5035870e+00, 4.5695420e-01, 2.7039090e+00,
 2.5796580e-02, 1.5930050e+00, 4.3981400e-01, 2.0086610e+00, 9.3732050e-01, 3.5363780e+00, 6.6218480e-01, 5.7562400e+00,
 2.2992780e-01, 5.1335220e-01, 1.3357650e-01, 6.2159660e-01, 2.3412100e-01, 1.8684170e+00, 1.7588990e-01, 1.1185090e+00,
 9.9214600e-03, 6.3448720e-01, 1.6252790e-01, 7.9770950e-01, 5.5214330e-01, 2.1573200e+00, 3.7479020e-01, 3.5012820e+00,
 9.4960360e-02, 2.1792960e-01, 8.4510050e-02, 2.4065600e-01, 6.9084710e-01, 5.6671560e+00, 7.9507860e-01, 3.0939860e+00,
 2.0555000e-02, 1.3511840e+00, 5.1581900e-01, 1.5492590e+00, 1.1763850e+00, 4.7245680e+00, 1.2232450e+00, 6.9929750e+00,
 2.0124890e-01, 2.9939430e-01, 1.2747870e-01, 5.7940540e-01, 2.5246200e-01, 1.3425040e+00, 2.0680560e-01, 1.2844790e+00,
 6.9779250e-03, 2.9734430e-01, 1.2463620e-01, 5.9748540e-01, 7.9126750e-01, 2.0600240e+00, 5.8563270e-01, 5.3435560e+00,
 1.7350210e-06, 1.5372160e-05, 1.1945560e-05, 5.1636130e-05, 1.0276980e-05, 3.2546550e-04, 9.1501750e-05, 5.4050090e-04,
 1.7872030e-06, 4.5355220e-04, 3.4696800e-04, 1.5818840e-03, 3.4214400e-05, 5.3049090e-04, 2.7523820e-04, 2.3884490e-03,
 6.8948280e-06, 6.3262420e-05, 4.5611120e-05, 2.1188340e-04, 5.0498630e-05, 1.6561950e-03, 4.3200520e-04, 2.7424270e-03,
 8.4309880e-06, 2.2157670e-03, 1.5726770e-03, 7.7055550e-03, 2.4720870e-04, 3.9694010e-03, 1.9107720e-03, 1.7819490e-02,
 1.3766350e-07, 1.2983480e-06, 1.3950620e-06, 3.9657880e-06, 7.2038660e-06, 2.4285510e-04, 9.4406630e-05, 3.6674010e-04,
 8.4443230e-07, 2.2811840e-04, 2.4129780e-04, 7.2348160e-04, 2.5462790e-05, 4.2025900e-04, 3.0149390e-04, 1.7205790e-03,
 1.9045160e-06, 1.1643750e-05, 1.3737170e-05, 6.2328940e-05, 1.7185190e-05, 3.7555380e-04, 1.6029840e-04, 9.9389740e-04,
 1.8713210e-06, 3.2770270e-04, 3.8060530e-04, 1.8214000e-03, 1.1180320e-04, 1.1961940e-03, 9.4224760e-04, 8.5825750e-03,
 3.4285500e-01, 6.1685060e-01, 2.1801310e-01, 6.4127250e-01, 3.9383110e-01, 2.5327310e+00, 3.2385030e-01, 1.3017400e+00,
 1.4191900e-02, 7.3136390e-01, 2.5446410e-01, 7.8945040e-01, 6.0999060e-01, 1.9205760e+00, 4.5320340e-01, 2.6761680e+00,
 2.0566250e-01, 3.8319240e-01, 1.2565290e-01, 3.9720240e-01, 2.9211250e-01, 1.9454560e+00, 2.3079680e-01, 9.9698560e-01,
 1.0105810e-02, 5.3933220e-01, 1.7410150e-01, 5.8047030e-01, 6.6527920e-01, 2.1692250e+00, 4.7491880e-01, 3.0138300e+00,
 3.6462970e-02, 6.9833470e-02, 3.4126920e-02, 6.6015510e-02, 3.7003070e-01, 2.5331380e+00, 4.4786270e-01, 1.1838960e+00,
 8.9879210e-03, 4.9305360e-01, 2.3720180e-01, 4.8395520e-01, 6.0848200e-01, 2.0393800e+00, 6.6541200e-01, 2.5840430e+00,
 1.4908240e-01, 1.8508630e-01, 9.9313780e-02, 3.0663020e-01, 2.6087650e-01, 1.1576900e+00, 2.2473990e-01, 9.4821220e-01,
 5.8864190e-03, 2.0932560e-01, 1.1057270e-01, 3.6007390e-01, 7.8959550e-01, 1.7155020e+00, 6.1459030e-01, 3.8093530e+00,
 3.9122200e-01, 7.3128720e-01, 2.2469690e-01, 1.1499910e+00, 3.7595300e-01, 2.5119310e+00, 2.7923490e-01, 1.9529320e+00,
 1.0261550e-02, 5.4941540e-01, 1.6618830e-01, 8.9709030e-01, 5.1467980e-01, 1.6836070e+00, 3.4538930e-01, 3.5486780e+00,
 2.0384940e-01, 3.9460830e-01, 1.1249380e-01, 6.1873580e-01, 2.4222290e-01, 1.6760290e+00, 1.7286080e-01, 1.2992510e+00,
 6.3472390e-03, 3.5193720e-01, 9.8768370e-02, 5.7297120e-01, 4.8759520e-01, 1.6517910e+00, 3.1439560e-01, 3.4714700e+00,
 3.5214840e-02, 7.0070070e-02, 2.9769560e-02, 1.0019800e-01, 2.9896640e-01, 2.1263690e+00, 3.2683700e-01, 1.5032720e+00,
 5.5003750e-03, 3.1348910e-01, 1.3111510e-01, 4.6545470e-01, 4.3453290e-01, 1.5131020e+00, 4.2920740e-01, 2.9001060e+00,
 2.4599330e-01, 3.1729720e-01, 1.4801580e-01, 7.9515340e-01, 3.6011620e-01, 1.6603330e+00, 2.8021390e-01, 2.0570860e+00,
 6.1547070e-03, 2.2739130e-01, 1.0442540e-01, 5.9168030e-01, 9.6339130e-01, 2.1746260e+00, 6.7730680e-01, 7.3044660e+00,
 3.1226390e+00, 7.3882420e+00, 1.6114920e+00, 6.9175520e+00, 2.2878050e+00, 1.9348530e+01, 1.5268190e+00, 8.9563660e+00,
 9.9822990e-02, 6.7650850e+00, 1.4526160e+00, 6.5767790e+00, 2.9937090e+00, 1.2395600e+01, 1.8051520e+00, 1.5556010e+01,
 1.6024350e+00, 3.9263770e+00, 7.9457010e-01, 3.6655210e+00, 1.4516880e+00, 1.2714350e+01, 9.3086600e-01, 5.8682770e+00,
 6.0810040e-02, 4.2678600e+00, 8.5023850e-01, 4.1369710e+00, 2.7932160e+00, 1.1977190e+01, 1.6182810e+00, 1.4987110e+01,
 4.0252270e-01, 1.0137990e+00, 3.0575220e-01, 8.6314310e-01, 2.6053970e+00, 2.3455500e+01, 2.5592650e+00, 9.8729830e+00,
 7.6626020e-02, 5.5279100e+00, 1.6412290e+00, 4.8867560e+00, 3.6196050e+00, 1.5953700e+01, 3.2124640e+00, 1.8205880e+01,
 1.4390900e+00, 2.3495540e+00, 7.7804570e-01, 3.5057000e+00, 1.6061800e+00, 9.3734890e+00, 1.1229840e+00, 6.9145390e+00,
 4.3882490e-02, 2.0521650e+00, 6.6899410e-01, 3.1792910e+00, 4.1071560e+00, 1.1734850e+01, 2.5945160e+00, 2.3468550e+01,
 1.1010850e-05, 1.0706280e-04, 6.4704730e-05, 2.7727320e-04, 5.8026390e-05, 2.0167530e-03, 4.4096360e-04, 2.5822280e-03,
 9.9747200e-06, 2.7780610e-03, 1.6528350e-03, 7.4703280e-03, 1.5761180e-04, 2.6819170e-03, 1.0821850e-03, 9.3096590e-03,
 6.9306010e-05, 6.9788010e-04, 3.9131930e-04, 1.8021150e-03, 4.5161770e-04, 1.6255130e-02, 3.2975660e-03, 2.0752220e-02,
 7.4530940e-05, 2.1496610e-02, 1.1866180e-02, 5.7636830e-02, 1.8037440e-03, 3.1785100e-02, 1.1899620e-02, 1.1001310e-01,
 8.4163790e-07, 8.7113410e-06, 7.2796940e-06, 2.0515110e-05, 3.9184660e-05, 1.4497240e-03, 4.3829450e-04, 1.6879000e-03,
 4.5402730e-06, 1.3460620e-03, 1.1073470e-03, 3.2914150e-03, 1.1299940e-04, 2.0467960e-03, 1.1419890e-03, 6.4607480e-03,
 1.9642520e-05, 1.3179330e-04, 1.2092700e-04, 5.4392680e-04, 1.5769240e-04, 3.7819550e-03, 1.2554490e-03, 7.7167810e-03,
 1.6973510e-05, 3.2620520e-03, 2.9465330e-03, 1.3978700e-02, 8.3700990e-04, 9.8280070e-03, 6.0208040e-03, 5.4366570e-02,
 2.1463980e+00, 4.2380630e+00, 1.1649190e+00, 3.3968820e+00, 2.1935810e+00, 1.5481760e+01, 1.5395760e+00, 6.1348790e+00,
 7.8135990e-02, 4.4190770e+00, 1.1957770e+00, 3.6776750e+00, 2.7719570e+00, 9.5781700e+00, 1.7578010e+00, 1.0289990e+01,
 2.0393240e+00, 4.1699950e+00, 1.0634490e+00, 3.3325820e+00, 2.5770630e+00, 1.8835790e+01, 1.7378730e+00, 7.4422100e+00,
 8.8127810e-02, 5.1616160e+00, 1.2958580e+00, 4.2831150e+00, 4.7884900e+00, 1.7135110e+01, 2.9176100e+00, 1.8354870e+01,
 2.1990850e-01, 4.6221210e-01, 1.7567110e-01, 3.3687910e-01, 1.9855080e+00, 1.4916960e+01, 2.0511250e+00, 5.3750900e+00,
 4.7671620e-02, 2.8700040e+00, 1.0738210e+00, 2.1719200e+00, 2.6637980e+00, 9.7980440e+00, 2.4863220e+00, 9.5717500e+00,
 1.5167800e+00, 2.0666080e+00, 8.6242020e-01, 2.6396670e+00, 2.3614300e+00, 1.1500590e+01, 1.7363350e+00, 7.2624600e+00,
 5.2669370e-02, 2.0554970e+00, 8.4443880e-01, 2.7260680e+00, 5.8312880e+00, 1.3903970e+01, 3.8739920e+00, 2.3803950e+01,
 5.2300650e-02, 8.8547660e-02, 3.7598200e-02, 1.7854870e-01, 5.4124110e-02, 3.2754450e-01, 5.0316790e-02, 3.2652960e-01,
 1.7680170e-03, 8.5739280e-02, 3.5839360e-02, 1.7950980e-01, 6.5952850e-02, 1.9540800e-01, 5.5397660e-02, 5.2813060e-01,
 2.8004190e-02, 4.9100430e-02, 1.9343210e-02, 9.8718210e-02, 3.5834570e-02, 2.2458150e-01, 3.2008830e-02, 2.2323310e-01,
 1.1237980e-03, 5.6438310e-02, 2.1888080e-02, 1.1781880e-01, 6.4207500e-02, 1.9700930e-01, 5.1819000e-02, 5.3090650e-01,
 4.5833600e-03, 8.2603040e-03, 4.8497220e-03, 1.5145910e-02, 4.1903840e-02, 2.6994510e-01, 5.7338830e-02, 2.4470750e-01,
 9.2265710e-04, 4.7629470e-02, 2.7528780e-02, 9.0678380e-02, 5.4211750e-02, 1.7097960e-01, 6.7023050e-02, 4.2020670e-01,
 3.2368260e-02, 3.7815310e-02, 2.4377570e-02, 1.2151370e-01, 5.1028420e-02, 2.1309330e-01, 4.9698720e-02, 3.3853230e-01,
 1.0437420e-03, 3.4927300e-02, 2.2165530e-02, 1.1653360e-01, 1.2150980e-01, 2.4842690e-01, 1.0692530e-01, 1.0699800e+00,
 6.0911960e-01, 1.3053510e+00, 3.9345500e-01, 1.5671530e+00, 4.8058830e-01, 3.6813520e+00, 4.0144660e-01, 2.1850640e+00,
 2.5095810e-02, 1.5404560e+00, 4.5709600e-01, 1.9202690e+00, 5.5976140e-01, 2.0992610e+00, 4.2246750e-01, 3.3780800e+00,
 3.2121160e-01, 7.1286620e-01, 1.9935590e-01, 8.5334510e-01, 3.1336990e-01, 2.4859000e+00, 2.5151120e-01, 1.4712040e+00,
 1.5709990e-02, 9.9865620e-01, 2.7493340e-01, 1.2412560e+00, 5.3669530e-01, 2.0844110e+00, 3.8919160e-01, 3.3444090e+00,
 7.6444380e-02, 1.7438630e-01, 7.2679320e-02, 1.9037780e-01, 5.3284690e-01, 4.3448880e+00, 6.5513360e-01, 2.3450670e+00,
 1.8755180e-02, 1.2254940e+00, 5.0280580e-01, 1.3891330e+00, 6.5891430e-01, 2.6304770e+00, 7.3196800e-01, 3.8490870e+00,
 2.7630000e-01, 4.0858630e-01, 1.8697530e-01, 7.8171090e-01, 3.3209370e-01, 1.7553870e+00, 2.9062050e-01, 1.6603820e+00,
 1.0858610e-02, 4.5993920e-01, 2.0720080e-01, 9.1367430e-01, 7.5586960e-01, 1.9560890e+00, 5.9765170e-01, 5.0161470e+00,
 1.0593210e-07, 9.3293360e-07, 7.7916400e-07, 3.0980820e-06, 6.0118150e-07, 1.8925100e-05, 5.7183260e-06, 3.1070840e-05,
 1.2367940e-07, 3.1199210e-05, 2.5651460e-05, 1.0757580e-04, 1.4534770e-06, 2.2401130e-05, 1.2491290e-05, 9.9708320e-05,
 6.8518450e-07, 6.2491760e-06, 4.8423270e-06, 2.0691750e-05, 4.8081820e-06, 1.5674930e-04, 4.3942990e-05, 2.5659770e-04,
 9.4964880e-07, 2.4808560e-04, 1.8924450e-04, 8.5291320e-04, 1.7093230e-05, 2.7282120e-04, 1.4114600e-04, 1.2107990e-03,
 7.8832690e-09, 7.3904590e-08, 8.5345440e-08, 2.2316870e-07, 3.9524870e-07, 1.3244790e-05, 5.5335850e-06, 1.9773310e-05,
 5.4809130e-08, 1.4717750e-05, 1.6731720e-05, 4.6145760e-05, 1.0145410e-06, 1.6644610e-05, 1.2833400e-05, 6.7368170e-05,
 1.8600140e-07, 1.1303620e-06, 1.4332710e-06, 5.9818810e-06, 1.6080630e-06, 3.4931240e-05, 1.6024240e-05, 9.1391710e-05,
 2.0714780e-07, 3.6058280e-05, 4.5009710e-05, 1.9813170e-04, 7.5973510e-06, 8.0798330e-05, 6.8402530e-05, 5.7311500e-04,
 2.7371590e-01, 4.8951100e-01, 1.8593940e-01, 5.0309330e-01, 3.0124290e-01, 1.9257000e+00, 2.6463690e-01, 9.7846970e-01,
 1.2841940e-02, 6.5783420e-01, 2.4598910e-01, 7.0199040e-01, 3.3883550e-01, 1.0604500e+00, 2.6894180e-01, 1.4608160e+00,
 2.6724270e-01, 4.9494900e-01, 1.7443060e-01, 5.0719950e-01, 3.6367890e-01, 2.4075880e+00, 3.0697080e-01, 1.2197570e+00,
 1.4884100e-02, 7.8958780e-01, 2.7393850e-01, 8.4013190e-01, 6.0149340e-01, 1.9495050e+00, 4.5871780e-01, 2.6777000e+00,
 2.7302740e-02, 5.1976940e-02, 2.7299240e-02, 4.8575400e-02, 2.6546620e-01, 1.8064380e+00, 3.4325400e-01, 8.3464440e-01,
 7.6280560e-03, 4.1595060e-01, 2.1506610e-01, 4.0362320e-01, 3.1701370e-01, 1.0561400e+00, 3.7035670e-01, 1.3229590e+00,
 1.9038150e-01, 2.3494460e-01, 1.3549000e-01, 3.8479500e-01, 3.1919090e-01, 1.4079940e+00, 2.9376170e-01, 1.1400850e+00,
 8.5202030e-03, 3.0117160e-01, 1.7098030e-01, 5.1216130e-01, 7.0158310e-01, 1.5151610e+00, 5.8339060e-01, 3.3261510e+00,
 4.4079440e-02, 9.1728470e-02, 2.5521390e-02, 1.5889870e-01, 5.0475500e-02, 3.7545530e-01, 3.7792970e-02, 3.2154890e-01,
 7.0887510e-04, 4.2253360e-02, 1.1573150e-02, 7.5998690e-02, 5.9269340e-02, 2.1584260e-01, 4.0095550e-02, 5.0115560e-01,
 2.4062380e-02, 5.1855990e-02, 1.3386040e-02, 8.9566890e-02, 3.4070510e-02, 2.6245110e-01, 2.4510630e-02, 2.2411430e-01,
 4.5936540e-04, 2.8355800e-02, 7.2058580e-03, 5.0853310e-02, 5.8825940e-02, 2.2185440e-01, 3.8236690e-02, 5.1361280e-01,
 5.4774850e-03, 1.2133650e-02, 4.6679070e-03, 1.9112930e-02, 5.5413040e-02, 4.3876460e-01, 6.1068210e-02, 3.4169620e-01,
 5.2455600e-04, 3.3283220e-02, 1.2605110e-02, 5.4436470e-02, 6.9080940e-02, 2.6779790e-01, 6.8785540e-02, 5.6540860e-01,
 2.8286910e-02, 4.0619250e-02, 1.7157920e-02, 1.1213110e-01, 4.9344540e-02, 2.5327660e-01, 3.8706190e-02, 3.4567010e-01,
 4.3392410e-04, 1.7847750e-02, 7.4217570e-03, 5.1157160e-02, 1.1322570e-01, 2.8453150e-01, 8.0245780e-02, 1.0527950e+00,
 1.0587680e+00, 2.7888400e+00, 5.5080970e-01, 2.8763690e+00, 9.2434160e-01, 8.7029140e+00, 6.2186390e-01, 4.4377030e+00,
 2.0751710e-02, 1.5656690e+00, 3.0441660e-01, 1.6766780e+00, 1.0374540e+00, 4.7822300e+00, 6.3061960e-01, 6.6110530e+00,
 5.6921480e-01, 1.5527130e+00, 2.8452620e-01, 1.5967770e+00, 6.1447360e-01, 5.9913900e+00, 3.9720200e-01, 3.0461650e+00,
 1.3243880e-02, 1.0347930e+00, 1.8667020e-01, 1.1049310e+00, 1.0140990e+00, 4.8409890e+00, 5.9227610e-01, 6.6727760e+00,
 1.8841360e-01, 5.2829550e-01, 1.4427320e-01, 4.9547020e-01, 1.4532150e+00, 1.4564790e+01, 1.4390160e+00, 6.7533210e+00,
 2.1990860e-02, 1.7661610e+00, 4.7482050e-01, 1.7198860e+00, 1.7316620e+00, 8.4970220e+00, 1.5492960e+00, 1.0681360e+01,
 4.9798520e-01, 9.0514350e-01, 2.7141140e-01, 1.4877030e+00, 6.6230350e-01, 4.3029620e+00, 4.6680000e-01, 3.4965450e+00,
 9.3103070e-03, 4.8471710e-01, 1.4308350e-01, 8.2721040e-01, 1.4526130e+00, 4.6205090e+00, 9.2503780e-01, 1.0179070e+01,
 4.8147120e-06, 5.2118440e-05, 2.8521980e-05, 1.4868610e-04, 3.0234940e-05, 1.1698760e-03, 2.3162250e-04, 1.6500270e-03,
 2.6742020e-06, 8.2916070e-04, 4.4670150e-04, 2.4561010e-03, 7.0439830e-05, 1.3343760e-03, 4.8755720e-04, 5.1024210e-03,
 3.1749490e-05, 3.5591810e-04, 1.8071390e-04, 1.0124210e-03, 2.4653070e-04, 9.8785640e-03, 1.8146290e-03, 1.3892410e-02,
 2.0933730e-05, 6.7217640e-03, 3.3598130e-03, 1.9852860e-02, 8.4454120e-04, 1.6568110e-02, 5.6166000e-03, 6.3168910e-02,
 5.0806260e-07, 5.8543730e-06, 4.4299560e-06, 1.5187240e-05, 2.8186570e-05, 1.1609540e-03, 3.1782390e-04, 1.4889700e-03,
 1.6804210e-06, 5.5463160e-04, 4.1315600e-04, 1.4939350e-03, 6.9718520e-05, 1.4058860e-03, 7.1027780e-04, 4.8884130e-03,
 8.7658890e-06, 6.5478000e-05, 5.4402180e-05, 2.9768180e-04, 8.3857880e-05, 2.2389930e-03, 6.7301760e-04, 5.0324820e-03,
 4.6442380e-06, 9.9365880e-04, 8.1273430e-04, 4.6905390e-03, 3.8177680e-04, 4.9905430e-03, 2.7683930e-03, 3.0410520e-02,
 5.8034560e-01, 1.2756960e+00, 3.1751650e-01, 1.1263410e+00, 7.0674770e-01, 5.5530860e+00, 5.0004170e-01, 2.4239830e+00,
 1.2953040e-02, 8.1555940e-01, 1.9983210e-01, 7.4766470e-01, 7.6602530e-01, 2.9467450e+00, 4.8968940e-01, 3.4872610e+00,
 5.7766900e-01, 1.3150180e+00, 3.0367160e-01, 1.1576750e+00, 8.6986570e-01, 7.0780630e+00, 5.9134300e-01, 3.0806480e+00,
 1.5305590e-02, 9.9798990e-01, 2.2687620e-01, 9.1224140e-01, 1.3863460e+00, 5.5228500e+00, 8.5151960e-01, 6.5168470e+00,
 8.2084490e-02, 1.9207180e-01, 6.6101850e-02, 1.5420770e-01, 8.8313070e-01, 7.3864720e+00, 9.1968620e-01, 2.9319190e+00,
 1.0909960e-02, 7.3122170e-01, 2.4773620e-01, 6.0956500e-01, 1.0162500e+00, 4.1614240e+00, 9.5620490e-01, 4.4782010e+00,
 4.1855110e-01, 6.3487370e-01, 2.3990490e-01, 8.9328070e-01, 7.7648890e-01, 4.2100140e+00, 5.7555660e-01, 2.9285780e+00,
 8.9110340e-03, 3.8715980e-01, 1.4402320e-01, 5.6561330e-01, 1.6446390e+00, 4.3656430e+00, 1.1014360e+00, 8.2331900e+00,
 5.7744280e-02, 9.8352660e-02, 3.8857040e-02, 2.0060530e-01, 5.5876390e-02, 3.4018480e-01, 4.8624060e-02, 3.4303920e-01,
 9.5911270e-04, 4.6791840e-02, 1.8198860e-02, 9.9095750e-02, 9.6289020e-02, 2.8700720e-01, 7.5706890e-02, 7.8463600e-01,
 2.1258030e-02, 3.7496630e-02, 1.3744500e-02, 7.6257200e-02, 2.5435350e-02, 1.6036760e-01, 2.1266990e-02, 1.6124180e-01,
 4.1915010e-04, 2.1176890e-02, 7.6416910e-03, 4.4717700e-02, 6.4450590e-02, 1.9894590e-01, 4.8689010e-02, 5.4230410e-01,
 5.3740820e-03, 9.7436890e-03, 5.3227710e-03, 1.8071710e-02, 4.5941990e-02, 2.9774090e-01, 5.8844450e-02, 2.7301530e-01,
 5.3154730e-04, 2.7604790e-02, 1.4845310e-02, 5.3160500e-02, 8.4053350e-02, 2.6669390e-01, 9.7271690e-02, 6.6299190e-01,
 2.2631120e-02, 2.6598760e-02, 1.5954300e-02, 8.6456110e-02, 3.3360640e-02, 1.4015200e-01, 3.0413630e-02, 2.2521960e-01,
 3.5855960e-04, 1.2070910e-02, 7.1276570e-03, 4.0738310e-02, 1.1234130e-01, 2.3106470e-01, 9.2535630e-02, 1.0066700e+00,
 6.6418680e-01, 1.4319310e+00, 4.0159050e-01, 1.7389330e+00, 4.9000050e-01, 3.7760500e+00, 3.8313500e-01, 2.2671030e+00,
 1.3445290e-02, 8.3028130e-01, 2.2923300e-01, 1.0469230e+00, 8.0710850e-01, 3.0451070e+00, 5.7019440e-01, 4.9565860e+00,
 2.4081130e-01, 5.3765140e-01, 1.3989930e-01, 6.5101960e-01, 2.1967400e-01, 1.7531220e+00, 1.6503620e-01, 1.0494890e+00,
 5.7868570e-03, 3.7007520e-01, 9.4797110e-02, 4.6527740e-01, 5.3205280e-01, 2.0788230e+00, 3.6115290e-01, 3.3738830e+00,
 8.8522080e-02, 2.0315400e-01, 7.8780300e-02, 2.2433960e-01, 5.7695790e-01, 4.7329000e+00, 6.6400640e-01, 2.5839290e+00,
 1.0671080e-02, 7.0146450e-01, 2.6778630e-01, 8.0429420e-01, 1.0089650e+00, 4.0521820e+00, 1.0491560e+00, 5.9977550e+00,
 1.9078900e-01, 2.8383330e-01, 1.2085300e-01, 5.4929070e-01, 2.1442170e-01, 1.1402190e+00, 1.7564470e-01, 1.0909370e+00,
 3.6840700e-03, 1.5698610e-01, 6.5803010e-02, 3.1544880e-01, 6.9017720e-01, 1.7968400e+00, 5.1081380e-01, 4.6608770e+00,
 4.0130970e-06, 3.5555750e-05, 2.7630040e-05, 1.1943420e-04, 2.1295770e-05, 6.7442380e-04, 1.8960830e-04, 1.1200160e-03,
 2.3021340e-06, 5.8423020e-04, 4.4693690e-04, 2.0376590e-03, 7.2811730e-05, 1.1289390e-03, 5.8573490e-04, 5.0828630e-03,
 1.7846680e-05, 1.6374940e-04, 1.1806050e-04, 5.4844230e-04, 1.1710260e-04, 3.8405930e-03, 1.0017880e-03, 6.3594870e-03,
 1.2153300e-05, 3.1940370e-03, 2.2670200e-03, 1.1107590e-02, 5.8872890e-04, 9.4531490e-03, 4.5505140e-03, 4.2437220e-02,
 3.1715870e-07, 2.9912240e-06, 3.2140410e-06, 9.1366570e-06, 1.4868820e-05, 5.0125430e-04, 1.9485580e-04, 7.5695350e-04,
 1.0834390e-06, 2.9268470e-04, 3.0959440e-04, 9.2825480e-04, 5.3973600e-05, 8.9082500e-04, 6.3907810e-04, 3.6471200e-03,
 4.4622400e-06, 2.7281070e-05, 3.2185910e-05, 1.4603540e-04, 3.6072450e-05, 7.8830360e-04, 3.3647330e-04, 2.0862330e-03,
 2.4417340e-06, 4.2759260e-04, 4.9662090e-04, 2.3765980e-03, 2.4101290e-04, 2.5786210e-03, 2.0311920e-03, 1.8501360e-02,
 3.8108380e-01, 6.8563040e-01, 2.4232190e-01, 7.1277540e-01, 3.9216870e-01, 2.5220400e+00, 3.2248340e-01, 1.2962450e+00,
 8.7848120e-03, 4.5271550e-01, 1.5751370e-01, 4.8867110e-01, 6.2380770e-01, 1.9640800e+00, 4.6346910e-01, 2.7367870e+00,
 2.5581400e-01, 4.7663510e-01, 1.5629380e-01, 4.9406150e-01, 3.2551590e-01, 2.1679210e+00, 2.5718870e-01, 1.1109920e+00,
 7.0003900e-03, 3.7360040e-01, 1.2060170e-01, 4.0209710e-01, 7.6136100e-01, 2.4825110e+00, 5.4350820e-01, 3.4490970e+00,
 4.0368730e-02, 7.7313740e-02, 3.7782450e-02, 7.3086810e-02, 3.6701490e-01, 2.5124930e+00, 4.4421260e-01, 1.1742480e+00,
 5.5415860e-03, 3.0399680e-01, 1.4624900e-01, 2.9838710e-01, 6.1980950e-01, 2.0773450e+00, 6.7779930e-01, 2.6321480e+00,
 1.6785330e-01, 2.0839040e-01, 1.1181830e-01, 3.4523790e-01, 2.6314280e-01, 1.1677470e+00, 2.2669230e-01, 9.5644940e-01,
 3.6909360e-03, 1.3125250e-01, 6.9331950e-02, 2.2577560e-01, 8.1794800e-01, 1.7771020e+00, 6.3665880e-01, 3.9461380e+00,
 2.5464090e-01, 4.7598450e-01, 1.4625210e-01, 7.4851330e-01, 2.1922570e-01, 1.4647570e+00, 1.6282740e-01, 1.1387930e+00,
 3.7196280e-03, 1.9915330e-01, 6.0240300e-02, 3.2517930e-01, 3.0821910e-01, 1.0082380e+00, 2.0683840e-01, 2.1251470e+00,
 1.4848180e-01, 2.8742880e-01, 8.1939360e-02, 4.5068100e-01, 1.5806370e-01, 1.0937010e+00, 1.1280110e-01, 8.4783250e-01,
 2.5747240e-03, 1.4276140e-01, 4.0064860e-02, 2.3242270e-01, 3.2676900e-01, 1.1069720e+00, 2.1069680e-01, 2.3264560e+00,
 2.2830410e-02, 4.5427660e-02, 1.9300130e-02, 6.4960110e-02, 1.7364530e-01, 1.2350350e+00, 1.8983310e-01, 8.7312870e-01,
 1.9859210e-03, 1.1318580e-01, 4.7339370e-02, 1.6805330e-01, 2.5919580e-01, 9.0255490e-01, 2.5601920e-01, 1.7298930e+00,
 1.6218910e-01, 2.0920140e-01, 9.7590250e-02, 5.2426310e-01, 2.1271300e-01, 9.8072320e-01, 1.6551640e-01, 1.2150770e+00,
 2.2598910e-03, 8.3493740e-02, 3.8343010e-02, 2.1725370e-01, 5.8441130e-01, 1.3191690e+00, 4.1086710e-01, 4.4310270e+00,
 2.6759260e+00, 6.3313070e+00, 1.3809580e+00, 5.9279530e+00, 1.7564040e+00, 1.4854330e+01, 1.1721760e+00, 6.8760200e+00,
 4.7639230e-02, 3.2285490e+00, 6.9324190e-01, 3.1386820e+00, 2.3603660e+00, 9.7732170e+00, 1.4232580e+00, 1.2265020e+01,
 1.5367100e+00, 3.7653330e+00, 7.6198010e-01, 3.5151760e+00, 1.2472040e+00, 1.0923420e+01, 7.9974490e-01, 5.0416760e+00,
 3.2476450e-02, 2.2793100e+00, 4.5408170e-01, 2.2094070e+00, 2.4645260e+00, 1.0567780e+01, 1.4278510e+00, 1.3223510e+01,
 3.4357830e-01, 8.6534050e-01, 2.6097860e-01, 7.3674650e-01, 1.9923340e+00, 1.7936300e+01, 1.9570570e+00, 7.5498200e+00,
 3.6424480e-02, 2.6277140e+00, 7.8016460e-01, 2.3229390e+00, 2.8425880e+00, 1.2528940e+01, 2.5228480e+00, 1.4297640e+01,
 1.2492050e+00, 2.0395350e+00, 6.7538420e-01, 3.0431310e+00, 1.2490880e+00, 7.2895390e+00, 8.7331790e-01, 5.3772720e+00,
 2.1213820e-02, 9.9206430e-01, 3.2340740e-01, 1.5369430e+00, 3.2802310e+00, 9.3721880e+00, 2.0721430e+00, 1.8743450e+01,
 2.3319650e-05, 2.2674600e-04, 1.3703670e-04, 5.8723090e-04, 1.1009800e-04, 3.8265440e-03, 8.3667480e-04, 4.8994630e-03,
 1.1764770e-05, 3.2766090e-03, 1.9494510e-03, 8.8109440e-03, 3.0711940e-04, 5.2259330e-03, 2.1087260e-03, 1.8140630e-02,
 1.6425970e-04, 1.6540210e-03, 9.2745190e-04, 4.2711270e-03, 9.5892350e-04, 3.4514640e-02, 7.0017490e-03, 4.4063350e-02,
 9.8373580e-05, 2.8373420e-02, 1.5662200e-02, 7.6075000e-02, 3.9332580e-03, 6.9310850e-02, 2.5948410e-02, 2.3989540e-01,
 1.7754530e-06, 1.8376760e-05, 1.5356670e-05, 4.3277070e-05, 7.4054750e-05, 2.7398210e-03, 8.2832910e-04, 3.1899480e-03,
 5.3339350e-06, 1.5813600e-03, 1.3009160e-03, 3.8667710e-03, 2.1931960e-04, 3.9726110e-03, 2.2164770e-03, 1.2539620e-02,
 4.2139720e-05, 2.8274030e-04, 2.5942850e-04, 1.1669030e-03, 3.0308070e-04, 7.2688180e-03, 2.4129390e-03, 1.4831450e-02,
 2.0279060e-05, 3.8973300e-03, 3.5203640e-03, 1.6701020e-02, 1.6521240e-03, 1.9398910e-02, 1.1884100e-02, 1.0731090e-01,
 2.1844710e+00, 4.3132390e+00, 1.1855820e+00, 3.4571370e+00, 2.0000590e+00, 1.4115930e+01, 1.4037520e+00, 5.5936470e+00,
 4.4286260e-02, 2.5046640e+00, 6.7774780e-01, 2.0844490e+00, 2.5956140e+00, 8.9688370e+00, 1.6459750e+00, 9.6353710e+00,
 2.3226370e+00, 4.7493120e+00, 1.2111890e+00, 3.7955620e+00, 2.6295000e+00, 1.9219060e+01, 1.7732340e+00, 7.5936410e+00,
 5.5897190e-02, 3.2738790e+00, 8.2192930e-01, 2.7166690e+00, 5.0177760e+00, 1.7955580e+01, 3.0573130e+00, 1.9233760e+01,
 2.2292620e-01, 4.6855470e-01, 1.7808170e-01, 3.4150190e-01, 1.8031990e+00, 1.3547290e+01, 1.8627910e+00, 4.8815500e+00,
 2.6912920e-02, 1.6202550e+00, 6.0622350e-01, 1.2261530e+00, 2.4844940e+00, 9.1385220e+00, 2.3189640e+00, 8.9274600e+00,
 1.5636960e+00, 2.1305300e+00, 8.8909570e-01, 2.7213140e+00, 2.1810100e+00, 1.0621910e+01, 1.6036740e+00, 6.7075860e+00,
 3.0239140e-02, 1.1801260e+00, 4.8481890e-01, 1.5651210e+00, 5.5311010e+00, 1.3188210e+01, 3.6745640e+00, 2.2578560e+01,
 2.7582830e-02, 4.6699130e-02, 1.9828910e-02, 9.4164770e-02, 2.5572630e-02, 1.5475860e-01, 2.3773740e-02, 1.5427910e-01,
 5.1927800e-04, 2.5182180e-02, 1.0526250e-02, 5.2723180e-02, 3.2002420e-02, 9.4818190e-02, 2.6880710e-02, 2.5626570e-01,
 1.6527760e-02, 2.8978510e-02, 1.1416140e-02, 5.8262360e-02, 1.8947240e-02, 1.1874560e-01, 1.6924410e-02, 1.1803270e-01,
 3.6936950e-04, 1.8550110e-02, 7.1941610e-03, 3.8724620e-02, 3.4865350e-02, 1.0697820e-01, 2.8138260e-02, 2.8828780e-01,
 2.4076790e-03, 4.3392100e-03, 2.5476020e-03, 7.9562800e-03, 1.9720660e-02, 1.2704070e-01, 2.6984630e-02, 1.1516350e-01,
 2.6992110e-04, 1.3933890e-02, 8.0534770e-03, 2.6527740e-02, 2.6201470e-02, 8.2637380e-02, 3.2393390e-02, 2.0309310e-01,
 1.7291970e-02, 2.0201930e-02, 1.3023130e-02, 6.4915810e-02, 2.4422510e-02, 1.0198780e-01, 2.3786110e-02, 1.6202360e-01,
 3.1052770e-04, 1.0391350e-02, 6.5945480e-03, 3.4670350e-02, 5.9724720e-02, 1.2210720e-01, 5.2556080e-02, 5.2591820e-01,
 4.2294280e-01, 9.0637160e-01, 2.7319590e-01, 1.0881550e+00, 2.9895460e-01, 2.2900210e+00, 2.4972380e-01, 1.3592410e+00,
 9.7042530e-03, 5.9567600e-01, 1.7675360e-01, 7.4254550e-01, 3.5760170e-01, 1.3411060e+00, 2.6989190e-01, 2.1580750e+00,
 2.4959130e-01, 5.5391900e-01, 1.5490570e-01, 6.6307540e-01, 2.1814660e-01, 1.7305130e+00, 1.7508480e-01, 1.0241510e+00,
 6.7982300e-03, 4.3215150e-01, 1.1897270e-01, 5.3713240e-01, 3.8369270e-01, 1.4901820e+00, 2.7823980e-01, 2.3909750e+00,
 5.2869800e-02, 1.2060750e-01, 5.0265840e-02, 1.3166740e-01, 3.3015470e-01, 2.6921150e+00, 4.0592420e-01, 1.4530150e+00,
 7.2237900e-03, 4.7201430e-01, 1.9366190e-01, 5.3504190e-01, 4.1928420e-01, 1.6738400e+00, 4.6577020e-01, 2.4492740e+00,
 1.9433610e-01, 2.8737990e-01, 1.3150940e-01, 5.4981780e-01, 2.0926000e-01, 1.1061110e+00, 1.8312670e-01, 1.0462450e+00,
 4.2533250e-03, 1.8015850e-01, 8.1160690e-02, 3.5788690e-01, 4.8914430e-01, 1.2658400e+00, 3.8675710e-01, 3.2460880e+00,
 1.8178390e-07, 1.6009530e-06, 1.3370780e-06, 5.3164370e-06, 9.2424340e-07, 2.9095030e-05, 8.7912300e-06, 4.7767630e-05,
 1.1819710e-07, 2.9816260e-05, 2.4514430e-05, 1.0280730e-04, 2.2948450e-06, 3.5368390e-05, 1.9722070e-05, 1.5742610e-04,
 1.3158140e-06, 1.2000780e-05, 9.2991010e-06, 3.9736000e-05, 8.2721940e-06, 2.6967800e-04, 7.5601330e-05, 4.4146120e-04,
 1.0156210e-06, 2.6532020e-04, 2.0239140e-04, 9.1216520e-04, 3.0201500e-05, 4.8203940e-04, 2.4938650e-04, 2.1393230e-03,
 1.3474640e-08, 1.2632290e-07, 1.4587840e-07, 3.8145560e-07, 6.0524910e-07, 2.0281900e-05, 8.4736460e-06, 3.0279110e-05,
 5.2172960e-08, 1.4009860e-05, 1.5926970e-05, 4.3926280e-05, 1.5955040e-06, 2.6175920e-05, 2.0182260e-05, 1.0594560e-04,
 3.2332360e-07, 1.9648930e-06, 2.4914350e-06, 1.0398220e-05, 2.5042480e-06, 5.4398660e-05, 2.4954660e-05, 1.4232490e-04,
 2.0053190e-07, 3.4906640e-05, 4.3572180e-05, 1.9180370e-04, 1.2150690e-05, 1.2922340e-04, 1.0939840e-04, 9.1660150e-04,
 2.2571630e-01, 4.0366900e-01, 1.5333260e-01, 4.1486940e-01, 2.2255260e-01, 1.4226710e+00, 1.9550880e-01, 7.2287510e-01,
 5.8976010e-03, 3.0210730e-01, 1.1296940e-01, 3.2238580e-01, 2.5708060e-01, 8.0458260e-01, 2.0405100e-01, 1.1083470e+00,
 2.4661970e-01, 4.5675410e-01, 1.6096990e-01, 4.6805930e-01, 3.0067200e-01, 1.9904770e+00, 2.5378850e-01, 1.0084360e+00,
 7.6493800e-03, 4.0579270e-01, 1.4078520e-01, 4.3176880e-01, 5.1070530e-01, 1.6552510e+00, 3.8947990e-01, 2.2735340e+00,
 2.2426010e-02, 4.2692990e-02, 2.2423140e-02, 3.9899030e-02, 1.9534760e-01, 1.3292970e+00, 2.5258900e-01, 6.1418660e-01,
 3.4893260e-03, 1.9026960e-01, 9.8378370e-02, 1.8463060e-01, 2.3957500e-01, 7.9815050e-01, 2.7988760e-01, 9.9979220e-01,
 1.5903070e-01, 1.9625550e-01, 1.1317840e-01, 3.2142960e-01, 2.3886900e-01, 1.0536830e+00, 2.1983890e-01, 8.5319190e-01,
 3.9635850e-03, 1.4010450e-01, 7.9539770e-02, 2.3825660e-01, 5.3920390e-01, 1.1644820e+00, 4.4836670e-01, 2.5563240e+00,
 4.5756230e-02, 9.5217860e-02, 2.6492230e-02, 1.6494330e-01, 6.4846590e-02, 4.8235270e-01, 4.8553160e-02, 4.1309840e-01,
 8.4372470e-04, 5.0291230e-02, 1.3774720e-02, 9.0455950e-02, 5.6692480e-02, 2.0645830e-01, 3.8352310e-02, 4.7936670e-01,
 2.2378480e-02, 4.8227070e-02, 1.2449280e-02, 8.3298940e-02, 3.9215960e-02, 3.0208740e-01, 2.8212310e-02, 2.5796090e-01,
 4.8985440e-04, 3.0237840e-02, 7.6841250e-03, 5.4228540e-02, 5.0412930e-02, 1.9012580e-01, 3.2768260e-02, 4.4015830e-01,
 6.0426270e-03, 1.3385540e-02, 5.1495210e-03, 2.1084910e-02, 7.5656940e-02, 5.9905740e-01, 8.3378100e-02, 4.6652720e-01,
 6.6351880e-04, 4.2100450e-02, 1.5944400e-02, 6.8857520e-02, 7.0223730e-02, 2.7222810e-01, 6.9923450e-02, 5.7476200e-01,
 2.3168940e-02, 3.3269990e-02, 1.4053530e-02, 9.1843180e-02, 5.0020980e-02, 2.5674860e-01, 3.9236790e-02, 3.5040870e-01,
 4.0752230e-04, 1.6761820e-02, 6.9701860e-03, 4.8044540e-02, 8.5456880e-02, 2.1474960e-01, 6.0565330e-02, 7.9459490e-01,
 1.1706330e+00, 3.0834980e+00, 6.0900610e-01, 3.1802740e+00, 1.2648670e+00, 1.1909050e+01, 8.5095690e-01, 6.0725410e+00,
 2.6308170e-02, 1.9848920e+00, 3.8592700e-01, 2.1256240e+00, 1.0569880e+00, 4.8722730e+00, 6.4249320e-01, 6.7355300e+00,
 5.6386340e-01, 1.5381150e+00, 2.8185120e-01, 1.5817650e+00, 7.5334370e-01, 7.3454360e+00, 4.8696910e-01, 3.7345940e+00,
 1.5042830e-02, 1.1753520e+00, 2.1202620e-01, 1.2550180e+00, 9.2567630e-01, 4.4188870e+00, 5.4063360e-01, 6.0909550e+00,
 2.2139230e-01, 6.2076510e-01, 1.6952590e-01, 5.8219430e-01, 2.1133550e+00, 2.1181020e+01, 2.0927060e+00, 9.8210970e+00,
 2.9628480e-02, 2.3795640e+00, 6.3972980e-01, 2.3172170e+00, 1.8749710e+00, 9.2002200e+00, 1.6775130e+00, 1.1565330e+01,
 4.3445320e-01, 7.8966700e-01, 2.3678520e-01, 1.2979050e+00, 7.1511500e-01, 4.6460770e+00, 5.0402220e-01, 3.7753560e+00,
 9.3133810e-03, 4.8487720e-01, 1.4313070e-01, 8.2748350e-01, 1.1677710e+00, 3.7144760e+00, 7.4364760e-01, 8.1830590e+00,
 4.0944910e-06, 4.4322180e-05, 2.4255450e-05, 1.2644450e-04, 3.1822260e-05, 1.2312940e-03, 2.4378250e-04, 1.7366530e-03,
 2.6075980e-06, 8.0850940e-04, 4.3557580e-04, 2.3949280e-03, 5.5198720e-05, 1.0456560e-03, 3.8206410e-04, 3.9984070e-03,
 2.4190460e-05, 2.7117980e-04, 1.3768890e-04, 7.7138030e-04, 2.3247200e-04, 9.3152260e-03, 1.7111480e-03, 1.3100180e-02,
 1.8288190e-05, 5.8722890e-03, 2.9352100e-03, 1.7343920e-02, 5.9293800e-04, 1.1632190e-02, 3.9433190e-03, 4.4349820e-02,
 4.5917390e-07, 5.2910310e-06, 4.0036800e-06, 1.3725840e-05, 3.1527850e-05, 1.2985750e-03, 3.5549930e-04, 1.6654750e-03,
 1.7413850e-06, 5.7475320e-04, 4.2814500e-04, 1.5481340e-03, 5.8061630e-05, 1.1708230e-03, 5.9151980e-04, 4.0710740e-03,
 5.8820970e-06, 4.3937120e-05, 3.6505010e-05, 1.9975070e-04, 6.9642170e-05, 1.8594360e-03, 5.5892660e-04, 4.1793680e-03,
 3.5732830e-06, 7.6452240e-04, 6.2531890e-04, 3.6089070e-03, 2.3606240e-04, 3.0857810e-03, 1.7117690e-03, 1.8803610e-02,
 6.2676260e-01, 1.3777280e+00, 3.4291210e-01, 1.2164280e+00, 9.4465450e-01, 7.4223770e+00, 6.6836680e-01, 3.2399500e+00,
 1.6040020e-02, 1.0099240e+00, 2.4745620e-01, 9.2584880e-01, 7.6232580e-01, 2.9325140e+00, 4.8732440e-01, 3.4704190e+00,
 5.5895020e-01, 1.2724070e+00, 2.9383140e-01, 1.1201620e+00, 1.0416900e+00, 8.4761920e+00, 7.0815090e-01, 3.6891670e+00,
 1.6980910e-02, 1.1072280e+00, 2.5170960e-01, 1.0120940e+00, 1.2360810e+00, 4.9242320e+00, 7.5922380e-01, 5.8104890e+00,
 9.4212350e-02, 2.2045020e-01, 7.5868300e-02, 1.7699160e-01, 1.2544810e+00, 1.0492430e+01, 1.3064070e+00, 4.1647690e+00,
 1.4357760e-02, 9.6230460e-01, 3.2602650e-01, 8.0220170e-01, 1.0748020e+00, 4.4011870e+00, 1.0112970e+00, 4.7362150e+00,
 3.5667400e-01, 5.4101620e-01, 2.0443820e-01, 7.6122130e-01, 8.1893690e-01, 4.4401610e+00, 6.0702030e-01, 3.0886740e+00,
 8.7069860e-03, 3.7829450e-01, 1.4072530e-01, 5.5266170e-01, 1.2914410e+00, 3.4280910e+00, 8.6489450e-01, 6.4650540e+00,
 6.4521510e-02, 1.0989590e-01, 4.3417540e-02, 2.2414960e-01, 7.7270920e-02, 4.7043830e-01, 6.7241750e-02, 4.7438560e-01,
 1.2288020e-03, 5.9949070e-02, 2.3316130e-02, 1.2696010e-01, 9.9141030e-02, 2.9550810e-01, 7.7949260e-02, 8.0787630e-01,
 2.1281200e-02, 3.7537520e-02, 1.3759490e-02, 7.6340340e-02, 3.1513980e-02, 1.9869280e-01, 2.6349450e-02, 1.9977600e-01,
 4.8112690e-04, 2.4308170e-02, 8.7716140e-03, 5.1329790e-02, 5.9454030e-02, 1.8352260e-01, 4.4914360e-02, 5.0026170e-01,
 6.3816080e-03, 1.1570420e-02, 6.3206780e-03, 2.1459780e-02, 6.7519300e-02, 4.3757910e-01, 8.6481580e-02, 4.0124080e-01,
 7.2374340e-04, 3.7586090e-02, 2.0213050e-02, 7.2382180e-02, 9.1973350e-02, 2.9182330e-01, 1.0643720e-01, 7.2546290e-01,
 1.9953000e-02, 2.3451120e-02, 1.4066300e-02, 7.6225060e-02, 3.6402300e-02, 1.5293030e-01, 3.3186590e-02, 2.4575390e-01,
 3.6247680e-04, 1.2202780e-02, 7.2055250e-03, 4.1183370e-02, 9.1268860e-02, 1.8772270e-01, 7.5178240e-02, 8.1784380e-01,
 7.9048120e-01, 1.7042110e+00, 4.7795250e-01, 2.0695890e+00, 7.2175550e-01, 5.5620040e+00, 5.6434600e-01, 3.3393720e+00,
 1.8347980e-02, 1.1330350e+00, 3.1282050e-01, 1.4286730e+00, 8.8514480e-01, 3.3395270e+00, 6.2532440e-01, 5.4358200e+00,
 2.5677690e-01, 5.7329720e-01, 1.4917440e-01, 6.9418150e-01, 2.8990110e-01, 2.3135730e+00, 2.1779630e-01, 1.3849980e+00,
 7.0751980e-03, 4.5246590e-01, 1.1590200e-01, 5.6886310e-01, 5.2277500e-01, 2.0425730e+00, 3.5485530e-01, 3.3150500e+00,
 1.1196530e-01, 2.5695500e-01, 9.9643570e-02, 2.8375120e-01, 9.0316690e-01, 7.4088580e+00, 1.0394320e+00, 4.0448690e+00,
 1.5475940e-02, 1.0173120e+00, 3.8836210e-01, 1.1664430e+00, 1.1759510e+00, 4.7228230e+00, 1.2227930e+00, 6.9903920e+00,
 1.7916830e-01, 2.6654540e-01, 1.1349200e-01, 5.1583420e-01, 2.4921190e-01, 1.3252210e+00, 2.0414330e-01, 1.2679430e+00,
 3.9669120e-03, 1.6903860e-01, 7.0854990e-02, 3.3966710e-01, 5.9724090e-01, 1.5548860e+00, 4.4202980e-01, 4.0332640e+00,
 3.6735890e-06, 3.2547730e-05, 2.5292540e-05, 1.0933000e-04, 2.4126620e-05, 7.6407510e-04, 2.1481290e-04, 1.2689000e-03,
 2.4163410e-06, 6.1321350e-04, 4.6910910e-04, 2.1387460e-03, 6.1417670e-05, 9.5227500e-04, 4.9407530e-04, 4.2874630e-03,
 1.4636800e-05, 1.3429770e-04, 9.6826300e-05, 4.4980010e-04, 1.1886320e-04, 3.8983350e-03, 1.0168500e-03, 6.4550990e-03,
 1.1428780e-05, 3.0036230e-03, 2.1318700e-03, 1.0445400e-02, 4.4492320e-04, 7.1440790e-03, 3.4389840e-03, 3.2071300e-02,
 3.0854460e-07, 2.9099810e-06, 3.1267460e-06, 8.8885030e-06, 1.7902350e-05, 6.0351990e-04, 2.3461020e-04, 9.1138670e-04,
 1.2085440e-06, 3.2648120e-04, 3.4534330e-04, 1.0354410e-03, 4.8384220e-05, 7.9857320e-04, 5.7289670e-04, 3.2694330e-03,
 3.2230750e-06, 1.9705110e-05, 2.3247880e-05, 1.0548130e-04, 3.2246700e-05, 7.0469830e-04, 3.0078790e-04, 1.8649730e-03,
 2.0222400e-06, 3.5413140e-04, 4.1130050e-04, 1.9682940e-03, 1.6041270e-04, 1.7162720e-03, 1.3519150e-03, 1.2314080e-02,
 4.4301480e-01, 7.9705400e-01, 2.8170230e-01, 8.2861040e-01, 5.6423870e-01, 3.6286240e+00, 4.6397780e-01, 1.8649930e+00,
 1.1709730e-02, 6.0344800e-01, 2.0995820e-01, 6.5137510e-01, 6.6823540e-01, 2.1039620e+00, 4.9647750e-01, 2.9317020e+00,
 2.6644020e-01, 4.9643390e-01, 1.6278610e-01, 5.1458410e-01, 4.1960420e-01, 2.7945450e+00, 3.3152750e-01, 1.4321170e+00,
 8.3601560e-03, 4.4616910e-01, 1.4402760e-01, 4.8020110e-01, 7.3071350e-01, 2.3825810e+00, 5.2163000e-01, 3.3102590e+00,
 4.9873870e-02, 9.5517880e-02, 4.6678630e-02, 9.0295690e-02, 5.6118230e-01, 3.8417140e+00, 6.7922110e-01, 1.7954770e+00,
 7.8501670e-03, 4.3063940e-01, 2.0717510e-01, 4.2269270e-01, 7.0561430e-01, 2.3649270e+00, 7.7163210e-01, 2.9965350e+00,
 1.5396930e-01, 1.9115340e-01, 1.0256930e-01, 3.1668150e-01, 2.9873630e-01, 1.3257000e+00, 2.5735540e-01, 1.0858220e+00,
 3.8820180e-03, 1.3804760e-01, 7.2921310e-02, 2.3746410e-01, 6.9137080e-01, 1.5020960e+00, 5.3813600e-01, 3.3354750e+00,
 1.8715120e-01, 3.4983030e-01, 1.0748960e-01, 5.5012840e-01, 1.9941060e-01, 1.3323620e+00, 1.4810990e-01, 1.0358610e+00,
 3.1345900e-03, 1.6782970e-01, 5.0765470e-02, 2.7403380e-01, 2.0873970e-01, 6.8282390e-01, 1.4008020e-01, 1.4392450e+00,
 9.7772240e-02, 1.8926590e-01, 5.3955390e-02, 2.9676420e-01, 1.2881500e-01, 8.9131860e-01, 9.1928030e-02, 6.9094670e-01,
 1.9439710e-03, 1.0778790e-01, 3.0249810e-02, 1.7548400e-01, 1.9827330e-01, 6.7167630e-01, 1.2784430e-01, 1.4116210e+00,
 1.7832350e-02, 3.5482590e-02, 1.5074930e-02, 5.0738960e-02, 1.6786120e-01, 1.1938960e+00, 1.8350970e-01, 8.4404460e-01,
 1.7785810e-03, 1.0136870e-01, 4.2396900e-02, 1.5050770e-01, 1.8655370e-01, 6.4960530e-01, 1.8426740e-01, 1.2450740e+00,
 9.4057340e-02, 1.2132090e-01, 5.6594930e-02, 3.0403280e-01, 1.5267130e-01, 7.0389810e-01, 1.1879670e-01, 8.7210150e-01,
 1.5027110e-03, 5.5519020e-02, 2.5496120e-02, 1.4446250e-01, 3.1229910e-01, 7.0494080e-01, 2.1956010e-01, 2.3678630e+00,
 2.0948090e+00, 4.9563700e+00, 1.0810620e+00, 4.6406100e+00, 1.7017150e+00, 1.4391820e+01, 1.1356780e+00, 6.6619240e+00,
 4.2761390e-02, 2.8979740e+00, 6.2226000e-01, 2.8173090e+00, 1.7026710e+00, 7.0499970e+00, 1.0266800e+00, 8.8474790e+00,
 1.0778040e+00, 2.6408970e+00, 5.3443100e-01, 2.4654440e+00, 1.0826250e+00, 9.4819770e+00, 6.9421140e-01, 4.3763820e+00,
 2.6117600e-02, 1.8330240e+00, 3.6517310e-01, 1.7768080e+00, 1.5928050e+00, 6.8298770e+00, 9.2280950e-01, 8.5462540e+00,
 2.8584220e-01, 7.1992580e-01, 2.1712280e-01, 6.1294110e-01, 2.0514220e+00, 1.8468260e+01, 2.0150990e+00, 7.7737310e+00,
 3.4746480e-02, 2.5066600e+00, 7.4422400e-01, 2.2159260e+00, 2.1791930e+00, 9.6049680e+00, 1.9340730e+00, 1.0960900e+01,
 7.7163250e-01, 1.2598190e+00, 4.1718410e-01, 1.8797390e+00, 9.5490920e-01, 5.5727450e+00, 6.6763870e-01, 4.1108450e+00,
 1.5024930e-02, 7.0264100e-01, 2.2905700e-01, 1.0885580e+00, 1.8670780e+00, 5.3345640e+00, 1.1794450e+00, 1.0668600e+01,
 1.4041120e-05, 1.3652730e-04, 8.2511960e-05, 3.5358090e-04, 8.2044910e-05, 2.8515360e-03, 6.2348900e-04, 3.6510740e-03,
 8.1223220e-06, 2.2621490e-03, 1.3458880e-03, 6.0830180e-03, 1.7039950e-04, 2.8995110e-03, 1.1699870e-03, 1.0064990e-02,
 8.8611190e-05, 8.9227460e-04, 5.0032130e-04, 2.3040930e-03, 6.4022680e-04, 2.3043750e-02, 4.6747280e-03, 2.9418960e-02,
 6.0848920e-05, 1.7550370e-02, 9.6878420e-03, 4.7056150e-02, 1.9552000e-03, 3.4454020e-02, 1.2898800e-02, 1.1925060e-01,
 1.1361080e-06, 1.1759240e-05, 9.8266910e-06, 2.7692880e-05, 5.8648300e-05, 2.1698250e-03, 6.5600240e-04, 2.5263070e-03,
 3.9135850e-06, 1.1602670e-03, 9.5450100e-04, 2.8371050e-03, 1.2932090e-04, 2.3424340e-03, 1.3069370e-03, 7.3939340e-03,
 2.0020650e-05, 1.3433040e-04, 1.2325490e-04, 5.5439770e-04, 1.7821200e-04, 4.2740780e-03, 1.4188130e-03, 8.7209200e-03,
 1.1047170e-05, 2.1231000e-03, 1.9177450e-03, 9.0980080e-03, 7.2328610e-04, 8.4926850e-03, 5.2027620e-03, 4.6979830e-02,
 1.6703710e+00, 3.2981480e+00, 9.0656380e-01, 2.6435240e+00, 1.8927870e+00, 1.3358830e+01, 1.3284620e+00, 5.2936350e+00,
 3.8828670e-02, 2.1960030e+00, 5.9422590e-01, 1.8275730e+00, 1.8288910e+00, 6.3195170e+00, 1.1597680e+00, 6.7891630e+00,
 1.5912040e+00, 3.2536820e+00, 8.2976750e-01, 2.6002820e+00, 2.2295120e+00, 1.6295540e+01, 1.5034970e+00, 6.4385290e+00,
 4.3908760e-02, 2.5717210e+00, 6.4564770e-01, 2.1340170e+00, 3.1676470e+00, 1.1335090e+01, 1.9300360e+00, 1.2141980e+01,
 1.8115830e-01, 3.8076530e-01, 1.4471590e-01, 2.7751730e-01, 1.8135640e+00, 1.3625160e+01, 1.8734980e+00, 4.9096100e+00,
 2.5076940e-02, 1.5097230e+00, 5.6486750e-01, 1.1425060e+00, 1.8604420e+00, 6.8431190e+00, 1.7364890e+00, 6.6850710e+00,
 9.4346430e-01, 1.2854670e+00, 5.3644070e-01, 1.6419200e+00, 1.6286330e+00, 7.9317330e+00, 1.1975170e+00, 5.0087780e+00,
 2.0919900e-02, 8.1642880e-01, 3.3540500e-01, 1.0827750e+00, 3.0751470e+00, 7.3323000e+00, 2.0429610e+00, 1.2553090e+01,
 4.6453990e-02, 7.8648980e-02, 3.3395130e-02, 1.5858890e-01, 5.3303030e-02, 3.2257550e-01, 4.9553470e-02, 3.2157600e-01,
 1.0027690e-03, 4.8628890e-02, 2.0327070e-02, 1.0181290e-01, 4.9664740e-02, 1.4714890e-01, 4.1716330e-02, 3.9770030e-01,
 2.4938820e-02, 4.3725830e-02, 1.7225870e-02, 8.7912390e-02, 3.5383450e-02, 2.2175420e-01, 3.1605870e-02, 2.2042280e-01,
 6.3905730e-04, 3.2094110e-02, 1.2446840e-02, 6.6998640e-02, 4.8477160e-02, 1.4874360e-01, 3.9123740e-02, 4.0083850e-01,
 4.3093650e-03, 7.7665000e-03, 4.5598040e-03, 1.4240480e-02, 4.3684600e-02, 2.8141670e-01, 5.9775510e-02, 2.5510670e-01,
 5.5394700e-04, 2.8595890e-02, 1.6527790e-02, 5.4441690e-02, 4.3213690e-02, 1.3629260e-01, 5.3425930e-02, 3.3495840e-01,
 2.2979230e-02, 2.6846250e-02, 1.7306390e-02, 8.6266340e-02, 4.0167360e-02, 1.6773790e-01, 3.9120680e-02, 2.6647800e-01,
 4.7315990e-04, 1.5833600e-02, 1.0048300e-02, 5.2828210e-02, 7.3135140e-02, 1.4952480e-01, 6.4356870e-02, 6.4400630e-01,
 7.5870290e-01, 1.6259100e+00, 4.9007690e-01, 1.9520040e+00, 6.6372410e-01, 5.0841890e+00, 5.5442420e-01, 3.0177180e+00,
 1.9960390e-02, 1.2252280e+00, 3.6355920e-01, 1.5273200e+00, 5.9111330e-01, 2.2168390e+00, 4.4612960e-01, 3.5672850e+00,
 4.0114110e-01, 8.9025420e-01, 2.4896310e-01, 1.0656900e+00, 4.3391890e-01, 3.4421900e+00, 3.4826390e-01, 2.0371550e+00,
 1.2527960e-02, 7.9638040e-01, 2.1924620e-01, 9.8984210e-01, 5.6824070e-01, 2.2069270e+00, 4.1206720e-01, 3.5409840e+00,
 1.0079250e-01, 2.2992950e-01, 9.5828210e-02, 2.5101450e-01, 7.7898680e-01, 6.3519380e+00, 9.5776190e-01, 3.4283320e+00,
 1.5790730e-02, 1.0317920e+00, 4.2333230e-01, 1.1695670e+00, 7.3656330e-01, 2.9404620e+00, 8.1822590e-01, 4.3026780e+00,
 2.7507440e-01, 4.0677390e-01, 1.8614590e-01, 7.7824330e-01, 3.6658530e-01, 1.9377040e+00, 3.2080460e-01, 1.8328310e+00,
 6.9030650e-03, 2.9239380e-01, 1.3172230e-01, 5.8084360e-01, 6.3799120e-01, 1.6510360e+00, 5.0444760e-01, 4.2338750e+00,
 2.5081590e-07, 2.2089110e-06, 1.8448300e-06, 7.3353420e-06, 1.5782590e-06, 4.9683340e-05, 1.5012100e-05, 8.1569080e-05,
 1.8699210e-07, 4.7170410e-05, 3.8782710e-05, 1.6264490e-04, 2.9176560e-06, 4.4967220e-05, 2.5074550e-05, 2.0015090e-04,
 1.6265660e-06, 1.4834980e-05, 1.1495250e-05, 4.9120360e-05, 1.2655820e-05, 4.1258650e-04, 1.1566420e-04, 6.7540180e-04,
 1.4395470e-06, 3.7606630e-04, 2.8687070e-04, 1.2929080e-03, 3.4402260e-05, 5.4908680e-04, 2.8407390e-04, 2.4368840e-03,
 1.9758190e-08, 1.8523040e-07, 2.1390510e-07, 5.5933770e-07, 1.0983900e-06, 3.6807040e-05, 1.5377740e-05, 5.4949710e-05,
 8.7718710e-08, 2.3554870e-05, 2.6778110e-05, 7.3853520e-05, 2.1558030e-06, 3.5368200e-05, 2.7269740e-05, 1.4315090e-04,
 3.5200080e-07, 2.1391690e-06, 2.7124130e-06, 1.1320490e-05, 3.3742390e-06, 7.3297080e-05, 3.3624060e-05, 1.9176950e-04,
 2.5032630e-07, 4.3574370e-05, 5.4391660e-05, 2.3943080e-04, 1.2189570e-05, 1.2963680e-04, 1.0974840e-04, 9.1953420e-04,
 3.9550260e-01, 7.0731330e-01, 2.6867100e-01, 7.2693880e-01, 4.8262670e-01, 3.0851990e+00, 4.2397960e-01, 1.5676240e+00,
 1.1848920e-02, 6.0696600e-01, 2.2696760e-01, 6.4770780e-01, 4.1508480e-01, 1.2990870e+00, 3.2946270e-01, 1.7895480e+00,
 3.8716130e-01, 7.1704530e-01, 2.5270210e-01, 7.3479300e-01, 5.8418370e-01, 3.8673500e+00, 4.9309250e-01, 1.9593160e+00,
 1.3769150e-02, 7.3044100e-01, 2.5341820e-01, 7.7719900e-01, 7.3878080e-01, 2.3944680e+00, 5.6341750e-01, 3.2888700e+00,
 4.1760810e-02, 7.9501140e-02, 4.1755450e-02, 7.4298330e-02, 4.5021200e-01, 3.0635920e+00, 5.8213470e-01, 1.4154980e+00,
 7.4503230e-03, 4.0625900e-01, 2.1005510e-01, 3.9421880e-01, 4.1109230e-01, 1.3695650e+00, 4.8026560e-01, 1.7155670e+00,
 2.1987410e-01, 2.7134060e-01, 1.5647920e-01, 4.4440490e-01, 4.0873810e-01, 1.8029980e+00, 3.7617480e-01, 1.4599300e+00,
 6.2834460e-03, 2.2210690e-01, 1.2609390e-01, 3.7770670e-01, 6.8695320e-01, 1.4835660e+00, 5.7122530e-01, 3.2567920e+00,
 3.4485810e-02, 7.1764310e-02, 1.9966810e-02, 1.2431540e-01, 4.8826870e-02, 3.6319210e-01, 3.6558570e-02, 3.1104650e-01,
 6.1111120e-04, 3.6426020e-02, 9.9770530e-03, 6.5517400e-02, 4.4216600e-02, 1.6102460e-01, 2.9912420e-02, 3.7387620e-01,
 1.9833250e-02, 4.2741940e-02, 1.1033350e-02, 7.3824890e-02, 3.4722250e-02, 2.6747160e-01, 2.4979490e-02, 2.2840140e-01,
 4.1721480e-04, 2.5753920e-02, 6.5446600e-03, 4.6187090e-02, 4.6235440e-02, 1.7437100e-01, 3.0052910e-02, 4.0368440e-01,
 4.5178270e-03, 1.0007830e-02, 3.8500880e-03, 1.5764340e-02, 5.6511160e-02, 4.4745960e-01, 6.2278400e-02, 3.4846760e-01,
 4.7674530e-04, 3.0249620e-02, 1.1456220e-02, 4.9474860e-02, 5.4332230e-02, 2.1062340e-01, 5.4099910e-02, 4.4469450e-01,
 2.8361310e-02, 4.0726090e-02, 1.7203050e-02, 1.1242610e-01, 6.1172160e-02, 3.1398560e-01, 4.7983860e-02, 4.2852540e-01,
 4.7940300e-04, 1.9718350e-02, 8.1996200e-03, 5.6518870e-02, 1.0825220e-01, 2.7203340e-01, 7.6720950e-02, 1.0065510e+00,
 8.1054320e-01, 2.1350050e+00, 4.2167410e-01, 2.2020130e+00, 8.7494670e-01, 8.2378490e+00, 5.8863280e-01, 4.2005620e+00,
 1.7505530e-02, 1.3207520e+00, 2.5679690e-01, 1.4143960e+00, 7.5734730e-01, 3.4910550e+00, 4.6035580e-01, 4.8261050e+00,
 4.5909480e-01, 1.2523260e+00, 2.2948190e-01, 1.2878660e+00, 6.1277810e-01, 5.9748580e+00, 3.9610600e-01, 3.0377600e+00,
 1.1770300e-02, 9.1965660e-01, 1.6590030e-01, 9.8199130e-01, 7.7993310e-01, 3.7231550e+00, 4.5551360e-01, 5.1319650e+00,
 1.5206580e-01, 4.2637950e-01, 1.1644080e-01, 3.9988660e-01, 1.4501840e+00, 1.4534410e+01, 1.4360140e+00, 6.7392350e+00,
 1.9557240e-02, 1.5707090e+00, 4.2227460e-01, 1.5295550e+00, 1.3327030e+00, 6.5393860e+00, 1.1923530e+00, 8.2204730e+00,
 4.8857150e-01, 8.8803310e-01, 2.6628080e-01, 1.4595810e+00, 8.0342000e-01, 5.2197910e+00, 5.6626070e-01, 4.2415510e+00,
 1.0065190e-02, 5.2401810e-01, 1.5468470e-01, 8.9428070e-01, 1.3589790e+00, 4.3226740e+00, 8.6541050e-01, 9.5229320e+00,
 8.1498280e-08, 8.8220510e-07, 4.8278950e-07, 2.5167980e-06, 6.3279220e-07, 2.4484530e-05, 4.8476660e-06, 3.4533700e-05,
 4.9879080e-08, 1.5465460e-05, 8.3318540e-06, 4.5811070e-05, 1.1369660e-06, 2.1538100e-05, 7.8696350e-06, 8.2357910e-05,
 5.6619460e-07, 6.3471550e-06, 3.2227050e-06, 1.8054700e-05, 5.4359310e-06, 2.1781950e-04, 4.0012050e-05, 3.0632360e-04,
 4.1135970e-07, 1.3208650e-04, 6.6022250e-05, 3.9012000e-04, 1.4361530e-05, 2.8174290e-04, 9.5511010e-05, 1.0741960e-03,
 9.0664940e-09, 1.0447260e-07, 7.9053590e-08, 2.7101980e-07, 6.2192530e-07, 2.5615980e-05, 7.0126570e-06, 3.2853530e-05,
 3.3043530e-08, 1.0906190e-05, 8.1242340e-06, 2.9376500e-05, 1.1863730e-06, 2.3923420e-05, 1.2086520e-05, 8.3184230e-05,
 1.9015620e-07, 1.4203980e-06, 1.1801330e-06, 6.4575360e-06, 2.2492220e-06, 6.0053900e-05, 1.8051560e-05, 1.3498040e-04,
 1.1101340e-07, 2.3751880e-05, 1.9427160e-05, 1.1212010e-04, 7.8972350e-06, 1.0323180e-04, 5.7265530e-05, 6.2905610e-04,
 4.2667490e-01, 9.3790250e-01, 2.3344080e-01, 8.2809530e-01, 6.4246390e-01, 5.0479930e+00, 4.5455930e-01, 2.2035050e+00,
 1.0493690e-02, 6.6071200e-01, 1.6189070e-01, 6.0570830e-01, 5.3703740e-01, 2.0658740e+00, 3.4330650e-01, 2.4448140e+00,
 4.4744580e-01, 1.0185750e+00, 2.3521530e-01, 8.9670200e-01, 8.3308140e-01, 6.7787510e+00, 5.6633670e-01, 2.9503750e+00,
 1.3063440e-02, 8.5179220e-01, 1.9364060e-01, 7.7860520e-01, 1.0239620e+00, 4.0792050e+00, 6.2893670e-01, 4.8133760e+00,
 6.3623220e-02, 1.4887380e-01, 5.1235170e-02, 1.1952550e-01, 8.4635660e-01, 7.0788940e+00, 8.8138990e-01, 2.8098320e+00,
 9.3180240e-03, 6.2452490e-01, 2.1158750e-01, 5.2061990e-01, 7.5111420e-01, 3.0757240e+00, 7.0673470e-01, 3.3098550e+00,
 3.9436230e-01, 5.9818330e-01, 2.2604040e-01, 8.4165660e-01, 9.0459890e-01, 4.9046090e+00, 6.7051550e-01, 3.4117530e+00,
 9.2516930e-03, 4.0196050e-01, 1.4952910e-01, 5.8723600e-01, 1.4776390e+00, 3.9223480e+00, 9.8959370e-01, 7.3971760e+00,
 8.8803660e-02, 1.5125440e-01, 5.9757390e-02, 3.0850640e-01, 1.0624880e-01, 6.4686060e-01, 9.2458520e-02, 6.5228820e-01,
 1.6253160e-03, 7.9293610e-02, 3.0839850e-02, 1.6792800e-01, 1.4120480e-01, 4.2088710e-01, 1.1102180e-01, 1.1506440e+00,
 3.4442590e-02, 6.0752630e-02, 2.2269060e-02, 1.2355310e-01, 5.0954720e-02, 3.2126490e-01, 4.2604230e-02, 3.2301630e-01,
 7.4832210e-04, 3.7807780e-02, 1.3642950e-02, 7.9835940e-02, 9.9575070e-02, 3.0736810e-01, 7.5223690e-02, 8.3785060e-01,
 8.7130500e-03, 1.5797540e-02, 8.6298600e-03, 2.9299840e-02, 9.2097870e-02, 5.9686790e-01, 1.1796290e-01, 5.4730160e-01,
 9.4962920e-04, 4.9316990e-02, 2.6521700e-02, 9.4973210e-02, 1.2994870e-01, 4.1231570e-01, 1.5038460e-01, 1.0250030e+00,
 4.4603030e-02, 5.2422750e-02, 3.1443880e-02, 1.7039390e-01, 8.1295530e-02, 3.4153210e-01, 7.4114040e-02, 5.4883070e-01,
 7.7869220e-04, 2.6214680e-02, 1.5479300e-02, 8.8472330e-02, 2.1112940e-01, 4.3425310e-01, 1.7390750e-01, 1.8918920e+00,
 9.9950050e-01, 2.1548390e+00, 6.0433280e-01, 2.6168310e+00, 9.1172360e-01, 7.0259390e+00, 7.1288340e-01, 4.2183050e+00,
 2.2295080e-02, 1.3767790e+00, 3.8011590e-01, 1.7360160e+00, 1.1581790e+00, 4.3696450e+00, 8.1821360e-01, 7.1125670e+00,
 3.8178650e-01, 8.5240210e-01, 2.2179880e-01, 1.0321380e+00, 4.3062200e-01, 3.4366050e+00, 3.2351680e-01, 2.0572900e+00,
 1.0109570e-02, 6.4651690e-01, 1.6560940e-01, 8.1283390e-01, 8.0435790e-01, 3.1427660e+00, 5.4599130e-01, 5.1006390e+00,
 1.4043920e-01, 3.2230140e-01, 1.2498400e-01, 3.5591220e-01, 1.1317610e+00, 9.2840630e+00, 1.3025160e+00, 5.0686380e+00,
 1.8654840e-02, 1.2262770e+00, 4.6813530e-01, 1.4060410e+00, 1.5263850e+00, 6.1302290e+00, 1.5871860e+00, 9.0735350e+00,
 3.6794470e-01, 5.4738470e-01, 2.3307020e-01, 1.0593310e+00, 5.1129530e-01, 2.7188880e+00, 4.1883030e-01, 2.6013740e+00,
 7.8289460e-03, 3.3360820e-01, 1.3983670e-01, 6.7035410e-01, 1.2692310e+00, 3.3043780e+00, 9.3938320e-01, 8.5713220e+00,
 1.3352890e-07, 1.1830560e-06, 9.1934220e-07, 3.9739670e-06, 8.7611830e-07, 2.7746130e-05, 7.8005780e-06, 4.6078020e-05,
 8.4405810e-08, 2.1420310e-05, 1.6386570e-05, 7.4709060e-05, 2.3101910e-06, 3.5819290e-05, 1.8584360e-05, 1.6127050e-04,
 6.2561050e-07, 5.7401910e-06, 4.1385790e-06, 1.9225490e-05, 5.0755950e-06, 1.6646340e-04, 4.3420650e-05, 2.7564010e-04,
 4.6944750e-07, 1.2337660e-04, 8.7568520e-05, 4.2905450e-04, 1.9679440e-05, 3.1599050e-04, 1.5211010e-04, 1.4185490e-03,
 1.1125420e-08, 1.0492730e-07, 1.1274340e-07, 3.2049930e-07, 6.4489650e-07, 2.1740610e-05, 8.4513650e-06, 3.2830900e-05,
 4.1878430e-08, 1.1313210e-05, 1.1966820e-05, 3.5880050e-05, 1.8053940e-06, 2.9797720e-05, 2.1376890e-05, 1.2199460e-04,
 1.9027650e-07, 1.1633050e-06, 1.3724540e-06, 6.2271640e-06, 1.9018730e-06, 4.1562290e-05, 1.7740120e-05, 1.0999400e-04,
 1.1472990e-07, 2.0091320e-05, 2.3334760e-05, 1.1166930e-04, 9.7999360e-06, 1.0485050e-04, 8.2591240e-05, 7.5229220e-04,
 5.5074240e-01, 9.9087320e-01, 3.5020370e-01, 1.0301030e+00, 7.0076890e-01, 4.5066500e+00, 5.7624760e-01, 2.3162690e+00,
 1.3989640e-02, 7.2094070e-01, 2.5083760e-01, 7.7819930e-01, 8.5966570e-01, 2.7066870e+00, 6.3870400e-01, 3.7715500e+00,
 3.8949620e-01, 7.2571310e-01, 2.3796920e-01, 7.5224600e-01, 6.1280880e-01, 4.0812780e+00, 4.8417760e-01, 2.0915280e+00,
 1.1744840e-02, 6.2680490e-01, 2.0233850e-01, 6.7461500e-01, 1.1054030e+00, 3.6043010e+00, 7.8910700e-01, 5.0076650e+00,
 6.1505950e-02, 1.1779550e-01, 5.7565480e-02, 1.1135530e-01, 6.9140040e-01, 4.7331550e+00, 8.3682910e-01, 2.2121040e+00,
 9.3036270e-03, 5.1037240e-01, 2.4553370e-01, 5.0095440e-01, 9.0049480e-01, 3.0180860e+00, 9.8474570e-01, 3.8241350e+00,
 3.1088120e-01, 3.8596000e-01, 2.0709880e-01, 6.3941510e-01, 6.0260090e-01, 2.6741580e+00, 5.1912870e-01, 2.1902840e+00,
 7.5326390e-03, 2.6786650e-01, 1.4149600e-01, 4.6077360e-01, 1.4445780e+00, 3.1385410e+00, 1.1244030e+00, 6.9692760e+00,
 1.8882250e-01, 3.5295430e-01, 1.0844950e-01, 5.5504110e-01, 2.0099760e-01, 1.3429660e+00, 1.4928870e-01, 1.0441050e+00,
 3.0392840e-03, 1.6272690e-01, 4.9221960e-02, 2.6570190e-01, 2.1793960e-01, 7.1291810e-01, 1.4625400e-01, 1.5026770e+00,
 1.1599780e-01, 2.2454680e-01, 6.4013140e-02, 3.5208360e-01, 1.5268010e-01, 1.0564500e+00, 1.0895920e-01, 8.1895580e-01,
 2.2164270e-03, 1.2289480e-01, 3.4489460e-02, 2.0007890e-01, 2.4342680e-01, 8.2463950e-01, 1.5695870e-01, 1.7330950e+00,
 1.7847740e-02, 3.5513220e-02, 1.5087940e-02, 5.0782780e-02, 1.6784430e-01, 1.1937760e+00, 1.8349130e-01, 8.4395990e-01,
 1.7107160e-03, 9.7500750e-02, 4.0779160e-02, 1.4476480e-01, 1.9321850e-01, 6.7281280e-01, 1.9085050e-01, 1.2895550e+00,
 1.5412880e-01, 1.9880470e-01, 9.2740320e-02, 4.9820880e-01, 2.4993660e-01, 1.1523450e+00, 1.9448090e-01, 1.4277090e+00,
 2.3664420e-03, 8.7430350e-02, 4.0150820e-02, 2.2749690e-01, 5.2958010e-01, 1.1954010e+00, 3.7231830e-01, 4.0152940e+00,
 1.9416490e+00, 4.5939890e+00, 1.0020210e+00, 4.3013160e+00, 1.5757770e+00, 1.3326730e+01, 1.0516310e+00, 6.1688970e+00,
 3.8089690e-02, 2.5813690e+00, 5.5427780e-01, 2.5095170e+00, 1.6331530e+00, 6.7621530e+00, 9.8476140e-01, 8.4862450e+00,
 1.1747340e+00, 2.8783980e+00, 5.8249350e-01, 2.6871670e+00, 1.1788510e+00, 1.0324760e+01, 7.5591470e-01, 4.7653660e+00,
 2.7356600e-02, 1.9199810e+00, 3.8249660e-01, 1.8610980e+00, 1.7965190e+00, 7.7033940e+00, 1.0408340e+00, 9.6392900e+00,
 2.6282480e-01, 6.6195380e-01, 1.9963900e-01, 5.6358410e-01, 1.8844150e+00, 1.6964750e+01, 1.8510490e+00, 7.1408690e+00,
 3.0702950e-02, 2.2149540e+00, 6.5761700e-01, 1.9580530e+00, 2.0735070e+00, 9.1391480e+00, 1.8402740e+00, 1.0429320e+01,
 1.1616270e+00, 1.8965500e+00, 6.2803510e-01, 2.8297860e+00, 1.4361500e+00, 8.3812140e+00, 1.0041050e+00, 6.1825680e+00,
 2.1736920e-02, 1.0165270e+00, 3.3138210e-01, 1.5748420e+00, 2.9086300e+00, 8.3104570e+00, 1.8374000e+00, 1.6620090e+01,
 3.7412900e-07, 3.6378020e-06, 2.1985500e-06, 9.4212450e-06, 2.1840010e-06, 7.5906670e-05, 1.6597010e-05, 9.7190040e-05,
 2.0798360e-07, 5.7925540e-05, 3.4463380e-05, 1.5576430e-04, 4.6984820e-06, 7.9949200e-05, 3.2260450e-05, 2.7752530e-04,
 2.7763950e-06, 2.7957040e-05, 1.5676230e-05, 7.2192610e-05, 2.0040480e-05, 7.2131930e-04, 1.4632910e-04, 9.2087710e-04,
 1.8322090e-06, 5.2845520e-04, 2.9170850e-04, 1.4168970e-03, 6.3394800e-05, 1.1171270e-03, 4.1822690e-04, 3.8665460e-03,
 3.0029820e-08, 3.1082250e-07, 2.5974100e-07, 7.3198360e-07, 1.5487100e-06, 5.7298000e-05, 1.7322890e-05, 6.6711540e-05,
 9.9411670e-08, 2.9472740e-05, 2.4245940e-05, 7.2067260e-05, 3.5373000e-06, 6.4072320e-05, 3.5748480e-05, 2.0224540e-04,
 8.6641820e-07, 5.8133110e-06, 5.3340070e-06, 2.3992240e-05, 7.7049170e-06, 1.8478790e-04, 6.1341750e-05, 3.7704510e-04,
 4.5944110e-07, 8.8297660e-05, 7.9757150e-05, 3.7837730e-04, 3.2391370e-05, 3.8033320e-04, 2.3299850e-04, 2.1039270e-03,
 1.5222220e+00, 3.0056280e+00, 8.2615860e-01, 2.4090640e+00, 1.7232500e+00, 1.2162280e+01, 1.2094720e+00, 4.8194850e+00,
 3.4005320e-02, 1.9232130e+00, 5.2041050e-01, 1.6005500e+00, 1.7247370e+00, 5.9596230e+00, 1.0937200e+00, 6.4025220e+00,
 1.7051560e+00, 3.4866900e+00, 8.8919030e-01, 2.7864980e+00, 2.3868750e+00, 1.7445710e+01, 1.6096170e+00, 6.8929720e+00,
 4.5218770e-02, 2.6484480e+00, 6.6491060e-01, 2.1976850e+00, 3.5127310e+00, 1.2569940e+01, 2.1402940e+00, 1.3464730e+01,
 1.6377100e-01, 3.4422000e-01, 1.3082630e-01, 2.5088160e-01, 1.6379230e+00, 1.2305580e+01, 1.6920520e+00, 4.4341200e+00,
 2.1786260e-02, 1.3116120e+00, 4.9074370e-01, 9.9258270e-01, 1.7404620e+00, 6.4018080e+00, 1.6245040e+00, 6.2539540e+00,
 1.3964340e+00, 1.9026370e+00, 7.9399310e-01, 2.4302280e+00, 2.4082400e+00, 1.1728560e+01, 1.7707540e+00, 7.4064200e+00,
 2.9756640e-02, 1.1612950e+00, 4.7708300e-01, 1.5401480e+00, 4.7101060e+00, 1.1230650e+01, 3.1291390e+00, 1.9227170e+01,
 4.6775490e-02, 7.9193290e-02, 3.3626250e-02, 1.5968640e-01, 5.3620250e-02, 3.2449530e-01, 4.9848380e-02, 3.2348980e-01,
 9.7034390e-04, 4.7056440e-02, 1.9669780e-02, 9.8520670e-02, 5.1750350e-02, 1.5332820e-01, 4.3468150e-02, 4.1440120e-01,
 2.9528700e-02, 5.1773390e-02, 2.0396220e-02, 1.0409230e-01, 4.1855290e-02, 2.6231430e-01, 3.7386760e-02, 2.6073940e-01,
 7.2717290e-04, 3.6519370e-02, 1.4163050e-02, 7.6236660e-02, 5.9398500e-02, 1.8225380e-01, 4.7937870e-02, 4.9114270e-01,
 4.3044960e-03, 7.7577250e-03, 4.5546520e-03, 1.4224390e-02, 4.3593220e-02, 2.8082810e-01, 5.9650480e-02, 2.5457300e-01,
 5.3174890e-04, 2.7449980e-02, 1.5865480e-02, 5.2260070e-02, 4.4668380e-02, 1.4088060e-01, 5.5224390e-02, 3.4623400e-01,
 3.7580330e-02, 4.3904490e-02, 2.8302940e-02, 1.4108040e-01, 6.5626640e-02, 2.7405510e-01, 6.3916540e-02, 4.3537970e-01,
 7.4363960e-04, 2.4884800e-02, 1.5792370e-02, 8.3027220e-02, 1.2377160e-01, 2.5305110e-01, 1.0891560e-01, 1.0898960e+00,
 7.0183040e-01, 1.5040310e+00, 4.5334060e-01, 1.8056810e+00, 6.1338000e-01, 4.6985490e+00, 5.1237060e-01, 2.7888210e+00,
 1.7744300e-02, 1.0891980e+00, 3.2319530e-01, 1.3577500e+00, 5.6584960e-01, 2.1220930e+00, 4.2706240e-01, 3.4148220e+00,
 4.3634580e-01, 9.6838410e-01, 2.7081250e-01, 1.1592160e+00, 4.7154570e-01, 3.7406760e+00, 3.7846330e-01, 2.2138050e+00,
 1.3096140e-02, 8.3249870e-01, 2.2918960e-01, 1.0347340e+00, 6.3964030e-01, 2.4842280e+00, 4.6384350e-01, 3.9859090e+00,
 9.2491590e-02, 2.1099340e-01, 8.7936170e-02, 2.3034190e-01, 7.1414410e-01, 5.8232040e+00, 8.7803800e-01, 3.1429580e+00,
 1.3925340e-02, 9.0990450e-01, 3.7332310e-01, 1.0314030e+00, 6.9944570e-01, 2.7922840e+00, 7.7699310e-01, 4.0858530e+00,
 4.1327630e-01, 6.1114380e-01, 2.7966870e-01, 1.1692460e+00, 5.5023340e-01, 2.9084350e+00, 4.8151800e-01, 2.7510240e+00,
 9.9669360e-03, 4.2217050e-01, 1.9018610e-01, 8.3864650e-01, 9.9191590e-01, 2.5669450e+00, 7.8428910e-01, 6.5826110e+00,
 6.6697390e-09, 5.8739720e-08, 4.9058020e-08, 1.9506260e-07, 4.1928910e-08, 1.3199150e-06, 3.9881990e-07, 2.1670100e-06,
 4.7786620e-09, 1.2054600e-06, 9.9110860e-07, 4.1564600e-06, 8.0289290e-08, 1.2374270e-06, 6.9001200e-07, 5.5078350e-06,
 5.0862610e-08, 4.6388880e-07, 3.5945560e-07, 1.5359900e-06, 3.9536560e-07, 1.2889130e-05, 3.6133290e-06, 2.1099430e-05,
 4.3259560e-08, 1.1301100e-05, 8.6206980e-06, 3.8852940e-05, 1.1132270e-06, 1.7767970e-05, 9.1923820e-06, 7.8855410e-05,
 5.2121210e-10, 4.8862940e-09, 5.6427200e-09, 1.4755080e-08, 2.8947120e-08, 9.7001830e-07, 4.0526730e-07, 1.4481530e-06,
 2.2237660e-09, 5.9714170e-07, 6.7885460e-07, 1.8722680e-06, 5.8849970e-08, 9.6549540e-07, 7.4442020e-07, 3.9077910e-06,
 1.5202930e-08, 9.2390780e-08, 1.1714920e-07, 4.8893240e-07, 1.4559320e-07, 3.1626550e-06, 1.4508260e-06, 8.2745560e-06,
 1.0390090e-08, 1.8086060e-06, 2.2575910e-06, 9.9378610e-06, 5.4480570e-07, 5.7940450e-06, 4.9051430e-06, 4.1098060e-05,
 3.5970680e-01, 6.4329630e-01, 2.4435440e-01, 6.6114560e-01, 4.3852280e-01, 2.8032650e+00, 3.8523510e-01, 1.4243700e+00,
 1.0356360e-02, 5.3050930e-01, 1.9837750e-01, 5.6611900e-01, 3.9066630e-01, 1.2226640e+00, 3.1008110e-01, 1.6842730e+00,
 4.1406110e-01, 7.6686530e-01, 2.7025970e-01, 7.8584600e-01, 6.2417080e-01, 4.1320690e+00, 5.2684450e-01, 2.0934310e+00,
 1.4151710e-02, 7.5073560e-01, 2.6045920e-01, 7.9879260e-01, 8.1763200e-01, 2.6500340e+00, 6.2355190e-01, 3.6398960e+00,
 3.7677480e-02, 7.1727610e-02, 3.7672650e-02, 6.7033530e-02, 4.0579960e-01, 2.7613760e+00, 5.2470850e-01, 1.2758630e+00,
 6.4597760e-03, 3.5224540e-01, 1.8212750e-01, 3.4180600e-01, 3.8381520e-01, 1.2786910e+00, 4.4839870e-01, 1.6017340e+00,
 3.2479040e-01, 4.0081500e-01, 2.3114560e-01, 6.5645960e-01, 6.0319240e-01, 2.6607620e+00, 5.5513740e-01, 2.1544810e+00,
 8.9198270e-03, 3.1529750e-01, 1.7899980e-01, 5.3618330e-01, 1.0500890e+00, 2.2678050e+00, 8.7318530e-01, 4.9783910e+00,
 9.9866270e-02, 2.0781980e-01, 5.7821200e-02, 3.6000060e-01, 1.2764700e-01, 9.4948500e-01, 9.5574250e-02, 8.1316180e-01,
 2.8838370e-03, 1.7189460e-01, 4.7081770e-02, 3.0917700e-01, 1.4594710e-01, 5.3149890e-01, 9.8732820e-02, 1.2340650e+00,
 5.0324250e-02, 1.0845200e-01, 2.7995670e-02, 1.8732090e-01, 7.9536120e-02, 6.1268070e-01, 5.7218990e-02, 5.2318510e-01,
 1.7251040e-03, 1.0648760e-01, 2.7060920e-02, 1.9097480e-01, 1.3371800e-01, 5.0430030e-01, 8.6916360e-02, 1.1675000e+00,
 1.1415730e-02, 2.5287970e-02, 9.7284790e-03, 3.9833640e-02, 1.2890850e-01, 1.0207080e+00, 1.4206430e-01, 7.9489520e-01,
 1.9630560e-03, 1.2455650e-01, 4.7172360e-02, 2.0371870e-01, 1.5648160e-01, 6.0661400e-01, 1.5581250e-01, 1.2807590e+00,
 6.4985000e-02, 9.3316740e-02, 3.9417800e-02, 2.5760470e-01, 1.2653590e-01, 6.4948590e-01, 9.9255640e-02, 8.8641400e-01,
 1.7900270e-03, 7.3625700e-02, 3.0616290e-02, 2.1103400e-01, 2.8271920e-01, 7.1046150e-01, 2.0036990e-01, 2.6287790e+00,
 1.8820070e+00, 4.9572860e+00, 9.7908850e-01, 5.1128720e+00, 1.8340020e+00, 1.7267600e+01, 1.2338510e+00, 8.8049240e+00,
 6.6235750e-02, 4.9973360e+00, 9.7164340e-01, 5.3516550e+00, 2.0043410e+00, 9.2391770e+00, 1.2183450e+00, 1.2772430e+01,
 9.3401180e-01, 2.5478110e+00, 4.6687260e-01, 2.6201160e+00, 1.1254510e+00, 1.0973640e+01, 7.2750280e-01, 5.5792620e+00,
 3.9022000e-02, 3.0489320e+00, 5.5000840e-01, 3.2555900e+00, 1.8085850e+00, 8.6336170e+00, 1.0562890e+00, 1.1900500e+01,
 3.0808630e-01, 8.6384770e-01, 2.3590980e-01, 8.1017300e-01, 2.6523890e+00, 2.6583460e+01, 2.6264730e+00, 1.2326070e+01,
 6.4568480e-02, 5.1857160e+00, 1.3941450e+00, 5.0498440e+00, 3.0775550e+00, 1.5101130e+01, 2.7534500e+00, 1.8983190e+01,
 8.9759740e-01, 1.6314830e+00, 4.8920770e-01, 2.6815230e+00, 1.3325060e+00, 8.6572470e+00, 9.3916760e-01, 7.0347930e+00,
 3.0133350e-02, 1.5688150e+00, 4.6309790e-01, 2.6773140e+00, 2.8457560e+00, 9.0518540e+00, 1.8122040e+00, 1.9941400e+01,
 3.3657570e-06, 3.6433750e-05, 1.9938490e-05, 1.0394000e-04, 2.3592210e-05, 9.1284970e-04, 1.8073420e-04, 1.2875100e-03,
 3.3567950e-06, 1.0408050e-03, 5.6072260e-04, 3.0830230e-03, 5.3519650e-05, 1.0138490e-03, 3.7044220e-04, 3.8767810e-03,
 2.0488260e-05, 2.2967750e-04, 1.1661650e-04, 6.5332540e-04, 1.7757690e-04, 7.1155620e-03, 1.3070830e-03, 1.0006750e-02,
 2.4256780e-05, 7.7887860e-03, 3.8931550e-03, 2.3004330e-02, 5.9234080e-04, 1.1620470e-02, 3.9393480e-03, 4.4305150e-02,
 3.2671530e-07, 3.7647200e-06, 2.8487330e-06, 9.7663250e-06, 2.0232130e-05, 8.3332470e-04, 2.2813190e-04, 1.0687730e-03,
 1.9403880e-06, 6.4043520e-04, 4.7707280e-04, 1.7250520e-03, 4.8728490e-05, 9.8261870e-04, 4.9643580e-04, 3.4166680e-03,
 6.2137430e-06, 4.6414400e-05, 3.8563250e-05, 2.1101320e-04, 6.6351120e-05, 1.7715650e-03, 5.3251370e-04, 3.9818650e-03,
 5.9113950e-06, 1.2647740e-03, 1.0344850e-03, 5.9703290e-03, 2.9413680e-04, 3.8449230e-03, 2.1328860e-03, 2.3429540e-02,
 9.1142760e-01, 2.0034700e+00, 4.9865700e-01, 1.7689090e+00, 1.2389310e+00, 9.7345750e+00, 8.7657450e-01, 4.2492500e+00,
 3.6527960e-02, 2.2999020e+00, 5.6353240e-01, 2.1084370e+00, 1.3075590e+00, 5.0299140e+00, 8.3587000e-01, 5.9525420e+00,
 8.3747230e-01, 1.9064400e+00, 4.4024610e-01, 1.6783330e+00, 1.4076370e+00, 1.1453890e+01, 9.5692500e-01, 4.9851760e+00,
 3.9843700e-02, 2.5979800e+00, 5.9060680e-01, 2.3747580e+00, 2.1844670e+00, 8.7023620e+00, 1.3417400e+00, 1.0268600e+01,
 1.1858680e-01, 2.7748470e-01, 9.5496850e-02, 2.2278270e-01, 1.4241230e+00, 1.1911310e+01, 1.4830720e+00, 4.7279670e+00,
 2.8301970e-02, 1.8968920e+00, 6.4266260e-01, 1.5812980e+00, 1.5957260e+00, 6.5343120e+00, 1.5014430e+00, 7.0317180e+00,
 6.6654400e-01, 1.0110390e+00, 3.8204940e-01, 1.4225530e+00, 1.3802660e+00, 7.4836080e+00, 1.0230940e+00, 5.2057610e+00,
 2.5481600e-02, 1.1071050e+00, 4.1184250e-01, 1.6174030e+00, 2.8466460e+00, 7.5563330e+00, 1.9064350e+00, 1.4250530e+01,
 1.0636100e-01, 1.8115880e-01, 7.1572000e-02, 3.6950110e-01, 1.1488120e-01, 6.9941580e-01, 9.9970460e-02, 7.0528440e-01,
 3.1722050e-03, 1.5476110e-01, 6.0191580e-02, 3.2775300e-01, 1.9276700e-01, 5.7457760e-01, 1.5156230e-01, 1.5708120e+00,
 3.6145330e-02, 6.3756070e-02, 2.3369980e-02, 1.2966120e-01, 4.8274090e-02, 3.0436370e-01, 4.0362900e-02, 3.0602300e-01,
 1.2797260e-03, 6.4656140e-02, 2.3331190e-02, 1.3652970e-01, 1.1910740e-01, 3.6766040e-01, 8.9979310e-02, 1.0022010e+00,
 9.1057880e-03, 1.6509610e-02, 9.0188490e-03, 3.0620530e-02, 8.6890070e-02, 5.6311720e-01, 1.1129250e-01, 5.1635370e-01,
 1.6172360e-03, 8.3987750e-02, 4.5166950e-02, 1.6174110e-01, 1.5479280e-01, 4.9114400e-01, 1.7913570e-01, 1.2209670e+00,
 4.2269230e-02, 4.9679790e-02, 2.9798610e-02, 1.6147820e-01, 6.9550420e-02, 2.9218950e-01, 6.3406470e-02, 4.6953880e-01,
 1.2025350e-03, 4.0483360e-02, 2.3904700e-02, 1.3662790e-01, 2.2805530e-01, 4.6906650e-01, 1.8784940e-01, 2.0435630e+00,
 9.5984510e-01, 2.0693450e+00, 5.8035580e-01, 2.5130080e+00, 7.9041390e-01, 6.0911000e+00, 6.1803040e-01, 3.6570360e+00,
 3.4889870e-02, 2.1545390e+00, 5.9484830e-01, 2.7167140e+00, 1.2677260e+00, 4.7829510e+00, 8.9560480e-01, 7.7853130e+00,
 3.2125040e-01, 7.1724510e-01, 1.8663030e-01, 8.6848200e-01, 3.2710900e-01, 2.6105130e+00, 2.4574980e-01, 1.5627580e+00,
 1.3862060e-02, 8.8649250e-01, 2.2708060e-01, 1.1145430e+00, 7.7144330e-01, 3.0141630e+00, 5.2364920e-01, 4.8919190e+00,
 1.1767990e-01, 2.7006990e-01, 1.0472940e-01, 2.9823380e-01, 8.5613450e-01, 7.0230410e+00, 9.8530380e-01, 3.8342320e+00,
 2.5472850e-02, 1.6744600e+00, 6.3923030e-01, 1.9199240e+00, 1.4578390e+00, 5.8549370e+00, 1.5159100e+00, 8.6660670e+00,
 2.7958190e-01, 4.1592890e-01, 1.7709780e-01, 8.0492990e-01, 3.5072890e-01, 1.8650520e+00, 2.8730150e-01, 1.7844430e+00,
 9.6939740e-03, 4.1308100e-01, 1.7314890e-01, 8.3004730e-01, 1.0992560e+00, 2.8618560e+00, 8.1358120e-01, 7.4234520e+00,
 2.2807770e-06, 2.0207510e-05, 1.5703070e-05, 6.7878410e-05, 1.3509630e-05, 4.2784160e-04, 1.2028390e-04, 7.1051690e-04,
 2.3493720e-06, 5.9621830e-04, 4.5610770e-04, 2.0794700e-03, 4.4976630e-05, 6.9735820e-04, 3.6181510e-04, 3.1397420e-03,
 9.3630300e-06, 8.5909020e-05, 6.1938920e-05, 2.8773310e-04, 6.8576060e-05, 2.2490770e-03, 5.8665380e-04, 3.7241580e-03,
 1.1449100e-05, 3.0089650e-03, 2.1356620e-03, 1.0463980e-02, 3.3570420e-04, 5.3903620e-03, 2.5947880e-03, 2.4198490e-02,
 1.6581340e-07, 1.5638380e-06, 1.6803290e-06, 4.7767250e-06, 8.6769370e-06, 2.9251500e-04, 1.1371120e-04, 4.4173230e-04,
 1.0171050e-06, 2.7476490e-04, 2.9063920e-04, 8.7142170e-04, 3.0669510e-05, 5.0619500e-04, 3.6314440e-04, 2.0724090e-03,
 2.5715850e-06, 1.5722050e-05, 1.8548710e-05, 8.4160070e-05, 2.3204410e-05, 5.0709400e-04, 2.1644400e-04, 1.3420170e-03,
 2.5267630e-06, 4.4248270e-04, 5.1391480e-04, 2.4593580e-03, 1.5096300e-04, 1.6151690e-03, 1.2722760e-03, 1.1588680e-02,
 4.8657150e-01, 8.7541940e-01, 3.0939890e-01, 9.1007840e-01, 5.5891550e-01, 3.5943900e+00, 4.5960050e-01, 1.8473980e+00,
 2.0140800e-02, 1.0379340e+00, 3.6112930e-01, 1.1203690e+00, 8.6568390e-01, 2.7256350e+00, 6.4317530e-01, 3.7979530e+00,
 3.0151320e-01, 5.6178220e-01, 1.8421450e-01, 5.8232170e-01, 4.2825380e-01, 2.8521510e+00, 3.3836150e-01, 1.4616390e+00,
 1.4815710e-02, 7.9069230e-01, 2.5524290e-01, 8.5100310e-01, 9.7533790e-01, 3.1802090e+00, 6.9625860e-01, 4.4184500e+00,
 4.7414490e-02, 9.0807700e-02, 4.4376810e-02, 8.5843020e-02, 4.8116800e-01, 3.2939560e+00, 5.8237660e-01, 1.5394750e+00,
 1.1687410e-02, 6.4114050e-01, 3.0844450e-01, 6.2930930e-01, 7.9123730e-01, 2.6519000e+00, 8.6526600e-01, 3.3601510e+00,
 2.1732060e-01, 2.6980420e-01, 1.4477180e-01, 4.4698130e-01, 3.8028530e-01, 1.6875890e+00, 3.2760820e-01, 1.3822290e+00,
 8.5807590e-03, 3.0513840e-01, 1.6118430e-01, 5.2488740e-01, 1.1510100e+00, 2.5007250e+00, 8.9590140e-01, 5.5529750e+00,
 4.4052020e-01, 8.2343740e-01, 2.5301120e-01, 1.2949030e+00, 4.2332720e-01, 2.8284620e+00, 3.1442150e-01, 2.1990220e+00,
 1.1554610e-02, 6.1864780e-01, 1.8712980e-01, 1.0101340e+00, 5.7953510e-01, 1.8957600e+00, 3.8891210e-01, 3.9958500e+00,
 2.3711930e-01, 4.5901180e-01, 1.3085370e-01, 7.1971870e-01, 2.8175570e-01, 1.9495710e+00, 2.0107320e-01, 1.5113000e+00,
 7.3831620e-03, 4.0937630e-01, 1.1488820e-01, 6.6648490e-01, 5.6717480e-01, 1.9213780e+00, 3.6570770e-01, 4.0380430e+00,
 3.6332160e-02, 7.2293290e-02, 3.0714110e-02, 1.0337710e-01, 3.0845210e-01, 2.1938350e+00, 3.3720700e-01, 1.5509680e+00,
 5.6748940e-03, 3.2343560e-01, 1.3527520e-01, 4.8022290e-01, 4.4832000e-01, 1.5611110e+00, 4.4282550e-01, 2.9921220e+00,
 2.8451430e-01, 3.6698410e-01, 1.7119420e-01, 9.1966960e-01, 4.1650820e-01, 1.9203310e+00, 3.2409370e-01, 2.3792130e+00,
 7.1184970e-03, 2.6299940e-01, 1.2077780e-01, 6.8433380e-01, 1.1142530e+00, 2.5151590e+00, 7.8336900e-01, 8.4483020e+00,
 3.6320290e+00, 8.5934710e+00, 1.8743710e+00, 8.0459990e+00, 2.6610110e+00, 2.2504810e+01, 1.7758860e+00, 1.0417400e+01,
 1.1610690e-01, 7.8686600e+00, 1.6895780e+00, 7.6496370e+00, 3.4820670e+00, 1.4417680e+01, 2.0996230e+00, 1.8093640e+01,
 1.9254090e+00, 4.7177460e+00, 9.5471710e-01, 4.4043130e+00, 1.7442780e+00, 1.5276950e+01, 1.1184840e+00, 7.0510390e+00,
 7.3066420e-02, 5.1280550e+00, 1.0216060e+00, 4.9707850e+00, 3.3561930e+00, 1.4391210e+01, 1.9444490e+00, 1.8007780e+01,
 4.2898370e-01, 1.0804440e+00, 3.2585170e-01, 9.1988430e-01, 2.7766700e+00, 2.4997420e+01, 2.7275050e+00, 1.0522010e+01,
 8.1663250e-02, 5.8913030e+00, 1.7491200e+00, 5.2080010e+00, 3.8575500e+00, 1.7002460e+01, 3.4236440e+00, 1.9402690e+01,
 1.7193080e+00, 2.8070580e+00, 9.2954620e-01, 4.1883280e+00, 1.9189340e+00, 1.1198690e+01, 1.3416510e+00, 8.2609340e+00,
 5.2427260e-02, 2.4517610e+00, 7.9926020e-01, 3.7983600e+00, 4.9068980e+00, 1.4019860e+01, 3.0997180e+00, 2.8038330e+01,
 1.2447710e-05, 1.2103390e-04, 7.3148320e-05, 3.1345580e-04, 6.5598500e-05, 2.2799280e-03, 4.9850680e-04, 2.9191940e-03,
 1.1276360e-05, 3.1405820e-03, 1.8685200e-03, 8.4451620e-03, 1.7817920e-04, 3.0318920e-03, 1.2234040e-03, 1.0524520e-02,
 8.0938320e-05, 8.1501220e-04, 4.5699830e-04, 2.1045810e-03, 5.2741710e-04, 1.8983380e-02, 3.8510290e-03, 2.4235270e-02,
 8.7040200e-05, 2.5104590e-02, 1.3857790e-02, 6.7310590e-02, 2.1064840e-03, 3.7119910e-02, 1.3896850e-02, 1.2847770e-01,
 8.7179910e-07, 9.0235240e-06, 7.5405720e-06, 2.1250300e-05, 4.0588890e-05, 1.5016770e-03, 4.5400140e-04, 1.7483890e-03,
 4.7029800e-06, 1.3943000e-03, 1.1470300e-03, 3.4093680e-03, 1.1704890e-04, 2.1201460e-03, 1.1829130e-03, 6.6922770e-03,
 2.2808880e-05, 1.5303820e-04, 1.4042030e-04, 6.3160730e-04, 1.8311230e-04, 4.3916030e-03, 1.4578260e-03, 8.9607190e-03,
 1.9709620e-05, 3.7878920e-03, 3.4215110e-03, 1.6232050e-02, 9.7193500e-04, 1.1412270e-02, 6.9913510e-03, 6.3130410e-02,
 2.6196110e+00, 5.1724220e+00, 1.4217460e+00, 4.1457870e+00, 2.6771960e+00, 1.8895000e+01, 1.8790040e+00, 7.4874260e+00,
 9.5362500e-02, 5.3933440e+00, 1.4594080e+00, 4.4884860e+00, 3.3830860e+00, 1.1689850e+01, 2.1453410e+00, 1.2558600e+01,
 2.5711510e+00, 5.2574720e+00, 1.3407820e+00, 4.2016740e+00, 3.2491260e+00, 2.3747910e+01, 2.1910860e+00, 9.3830360e+00,
 1.1111030e-01, 6.5076940e+00, 1.6338000e+00, 5.4000920e+00, 6.0372630e+00, 2.1603710e+01, 3.6784820e+00, 2.3141570e+01,
 2.4591860e-01, 5.1688110e-01, 1.9644890e-01, 3.7672410e-01, 2.2203480e+00, 1.6681290e+01, 2.2937250e+00, 6.0108390e+00,
 5.3310080e-02, 3.2094590e+00, 1.2008290e+00, 2.4288080e+00, 2.9788640e+00, 1.0956930e+01, 2.7803970e+00, 1.0703870e+01,
 1.9014610e+00, 2.5907350e+00, 1.0811450e+00, 3.3091310e+00, 2.9603290e+00, 1.4417330e+01, 2.1766990e+00, 9.1043430e+00,
 6.6027210e-02, 2.5768060e+00, 1.0586030e+00, 3.4174440e+00, 7.3102020e+00, 1.7430250e+01, 4.8565020e+00, 2.9841040e+01,
 6.6993230e-02, 1.1342290e-01, 4.8160490e-02, 2.2870760e-01, 6.9328940e-02, 4.1956000e-01, 6.4452050e-02, 4.1826000e-01,
 2.2646980e-03, 1.0982560e-01, 4.5907540e-02, 2.2993860e-01, 8.4480670e-02, 2.5030310e-01, 7.0960270e-02, 6.7649580e-01,
 3.7056280e-02, 6.4971680e-02, 2.5595710e-02, 1.3062790e-01, 4.7417760e-02, 2.9717530e-01, 4.2355380e-02, 2.9539100e-01,
 1.4870550e-03, 7.4681450e-02, 2.8963190e-02, 1.5590260e-01, 8.4961960e-02, 2.6069070e-01, 6.8568990e-02, 7.0251690e-01,
 5.3793600e-03, 9.6948860e-03, 5.6919810e-03, 1.7776330e-02, 4.9181360e-02, 3.1682690e-01, 6.7296970e-02, 2.8720630e-01,
 1.0828970e-03, 5.5901360e-02, 3.2309750e-02, 1.0642670e-01, 6.3626800e-02, 2.0067400e-01, 7.8663060e-02, 4.9318470e-01,
 4.2587440e-02, 4.9754210e-02, 3.2073950e-02, 1.5987750e-01, 6.7138900e-02, 2.8037030e-01, 6.5389400e-02, 4.4541240e-01,
 1.3732690e-03, 4.5954400e-02, 2.9163540e-02, 1.5332520e-01, 1.5987240e-01, 3.2685920e-01, 1.4068330e-01, 1.4077890e+00,
 8.0595600e-01, 1.7271730e+00, 5.2059950e-01, 2.0735770e+00, 6.3589000e-01, 4.8709770e+00, 5.3117370e-01, 2.8911660e+00,
 3.3205490e-02, 2.0382520e+00, 6.0480610e-01, 2.5408030e+00, 7.4064770e-01, 2.7776350e+00, 5.5898740e-01, 4.4697040e+00,
 4.3905100e-01, 9.7438760e-01, 2.7249140e-01, 1.1664020e+00, 4.2833250e-01, 3.3978750e+00, 3.4378030e-01, 2.0109280e+00,
 2.1473340e-02, 1.3650220e+00, 3.7579510e-01, 1.6966220e+00, 7.3358670e-01, 2.8490960e+00, 5.3197010e-01, 4.5713350e+00,
 9.2678110e-02, 2.1141890e-01, 8.8113500e-02, 2.3080640e-01, 6.4600220e-01, 5.2675680e+00, 7.9425770e-01, 2.8430650e+00,
 2.2738030e-02, 1.4857400e+00, 6.0958160e-01, 1.6841300e+00, 7.9884130e-01, 3.1890850e+00, 8.8740880e-01, 4.6664790e+00,
 3.7551560e-01, 5.5530410e-01, 2.5411560e-01, 1.0624130e+00, 4.5134400e-01, 2.3857230e+00, 3.9497830e-01, 2.2566020e+00,
 1.4757790e-02, 6.2509710e-01, 2.8160370e-01, 1.2417620e+00, 1.0272920e+00, 2.6584940e+00, 8.1226040e-01, 6.8173770e+00,
 1.3623140e-07, 1.1997760e-06, 1.0020250e-06, 3.9842120e-06, 7.7313470e-07, 2.4338160e-05, 7.3539130e-06, 3.9957880e-05,
 1.5905480e-07, 4.0122980e-05, 3.2988430e-05, 1.3834520e-04, 1.8692080e-06, 2.8808420e-05, 1.6064110e-05, 1.2822740e-04,
 9.1027370e-07, 8.3020860e-06, 6.4330740e-06, 2.7489180e-05, 6.3877130e-06, 2.0824290e-04, 5.8378660e-05, 3.4089230e-04,
 1.2616170e-06, 3.2958400e-04, 2.5141310e-04, 1.1331030e-03, 2.2708510e-05, 3.6244540e-04, 1.8751370e-04, 1.6085570e-03,
 9.2892090e-09, 8.7085090e-08, 1.0056640e-07, 2.6296970e-07, 4.6573920e-07, 1.5606930e-05, 6.5204710e-06, 2.3299780e-05,
 6.4584050e-08, 1.7342580e-05, 1.9715740e-05, 5.4375620e-05, 1.1954790e-06, 1.9613090e-05, 1.5122160e-05, 7.9382930e-05,
 2.4569940e-07, 1.4931570e-06, 1.8932860e-06, 7.9017920e-06, 2.1241790e-06, 4.6142580e-05, 2.1167290e-05, 1.2072430e-04,
 2.7363280e-07, 4.7631350e-05, 5.9455790e-05, 2.6172290e-04, 1.0035750e-05, 1.0673090e-04, 9.0356640e-05, 7.5705890e-04,
 3.8002110e-01, 6.7962630e-01, 2.5815420e-01, 6.9848360e-01, 4.1823900e-01, 2.6736000e+00, 3.6741610e-01, 1.3584860e+00,
 1.7829470e-02, 9.1332260e-01, 3.4152590e-01, 9.7462800e-01, 4.7043170e-01, 1.4723050e+00, 3.7339280e-01, 2.0281650e+00,
 3.8329090e-01, 7.0987700e-01, 2.5017580e-01, 7.2744730e-01, 5.2160380e-01, 3.4530660e+00, 4.4027070e-01, 1.7494270e+00,
 2.1347410e-02, 1.1324610e+00, 3.9289430e-01, 1.2049530e+00, 8.6268760e-01, 2.7960640e+00, 6.5791270e-01, 3.8404720e+00,
 3.4732560e-02, 6.6121280e-02, 3.4728100e-02, 6.1794100e-02, 3.3770680e-01, 2.2980190e+00, 4.3666280e-01, 1.0617740e+00,
 9.7038580e-03, 5.2914210e-01, 2.7359140e-01, 5.1346010e-01, 4.0328180e-01, 1.3435440e+00, 4.7114090e-01, 1.6829720e+00,
 2.7150060e-01, 3.3505140e-01, 1.9322050e-01, 5.4875120e-01, 4.5519410e-01, 2.0079220e+00, 4.1892970e-01, 1.6258610e+00,
 1.2150550e-02, 4.2949700e-01, 2.4383280e-01, 7.3038660e-01, 1.0005190e+00, 2.1607510e+00, 8.3196590e-01, 4.7433820e+00,
 1.7385570e-02, 3.6179040e-02, 1.0066000e-02, 6.2671960e-02, 1.9908270e-02, 1.4808500e-01, 1.4906100e-02, 1.2682360e-01,
 2.7959060e-04, 1.6665340e-02, 4.5646200e-03, 2.9974990e-02, 2.3376690e-02, 8.5131430e-02, 1.5814270e-02, 1.9766300e-01,
 1.0894180e-02, 2.3477650e-02, 6.0604940e-03, 4.0551160e-02, 1.5425330e-02, 1.1882400e-01, 1.1097120e-02, 1.0146710e-01,
 2.0797640e-04, 1.2838010e-02, 3.2624320e-03, 2.3023690e-02, 2.6633280e-02, 1.0044400e-01, 1.7311560e-02, 2.3253680e-01,
 2.4254990e-03, 5.3729300e-03, 2.0670080e-03, 8.4634440e-03, 2.4537590e-02, 1.9429050e-01, 2.7041770e-02, 1.5130730e-01,
 2.3228000e-04, 1.4738230e-02, 5.5817010e-03, 2.4105150e-02, 3.0589900e-02, 1.1858430e-01, 3.0459100e-02, 2.5037000e-01,
 1.0148390e-02, 1.4572830e-02, 6.1556870e-03, 4.0228880e-02, 1.7703170e-02, 9.0867150e-02, 1.3886490e-02, 1.2401490e-01,
 1.5567740e-04, 6.4031760e-03, 2.6626780e-03, 1.8353480e-02, 4.0621600e-02, 1.0208040e-01, 2.8789500e-02, 3.7770760e-01,
 4.8522370e-01, 1.2781000e+00, 2.5243100e-01, 1.3182130e+00, 4.2361720e-01, 3.9884650e+00, 2.8499450e-01, 2.0337580e+00,
 9.5103170e-03, 7.1753170e-01, 1.3951130e-01, 7.6840590e-01, 4.7545560e-01, 2.1916520e+00, 2.8900710e-01, 3.0297840e+00,
 2.9944710e-01, 8.1683640e-01, 1.4968080e-01, 8.4001750e-01, 3.2325650e-01, 3.1518940e+00, 2.0895630e-01, 1.6024980e+00,
 6.9672140e-03, 5.4437400e-01, 9.8201690e-02, 5.8127190e-01, 5.3348760e-01, 2.5467020e+00, 3.1157900e-01, 3.5103510e+00,
 9.6943850e-02, 2.7182230e-01, 7.4232450e-02, 2.5493280e-01, 7.4771830e-01, 7.4939760e+00, 7.4041240e-01, 3.4747650e+00,
 1.1314890e-02, 9.0873740e-01, 2.4430790e-01, 8.8492740e-01, 8.9098670e-01, 4.3719470e+00, 7.9715470e-01, 5.4958480e+00,
 2.0759480e-01, 3.7732670e-01, 1.1314310e-01, 6.2017820e-01, 2.7609410e-01, 1.7937740e+00, 1.9459470e-01, 1.4576030e+00,
 3.8811830e-03, 2.0206380e-01, 5.9647130e-02, 3.4483880e-01, 6.0555010e-01, 1.9261490e+00, 3.8562000e-01, 4.2433430e+00,
 8.1236180e-06, 8.7936800e-05, 4.8123690e-05, 2.5087040e-04, 5.1013880e-05, 1.9738720e-03, 3.9080480e-04, 2.7840070e-03,
 4.5120450e-06, 1.3990010e-03, 7.5369660e-04, 4.1440540e-03, 1.1884950e-04, 2.2514250e-03, 8.2263040e-04, 8.6090550e-03,
 6.1492030e-05, 6.8933790e-04, 3.5000450e-04, 1.9608450e-03, 4.7747780e-04, 1.9132690e-02, 3.5145530e-03, 2.6906650e-02,
 4.0544200e-05, 1.3018630e-02, 6.5072460e-03, 3.8450780e-02, 1.6356970e-03, 3.2088920e-02, 1.0878160e-02, 1.2234480e-01,
 9.6241730e-07, 1.1089870e-05, 8.3916170e-06, 2.8769020e-05, 5.3393500e-05, 2.1991820e-03, 6.0205030e-04, 2.8205390e-03,
 3.1832030e-06, 1.0506320e-03, 7.8263690e-04, 2.8299450e-03, 1.3206700e-04, 2.6631550e-03, 1.3454710e-03, 9.2600660e-03,
 1.3453470e-05, 1.0049250e-04, 8.3493860e-05, 4.5686770e-04, 1.2870100e-04, 3.4362990e-03, 1.0329150e-03, 7.7236110e-03,
 7.1277540e-06, 1.5250200e-03, 1.2473460e-03, 7.1988140e-03, 5.8593270e-04, 7.6592460e-03, 4.2487970e-03, 4.6672610e-02,
 2.4214180e-01, 5.3226790e-01, 1.3247970e-01, 4.6995130e-01, 2.9488140e-01, 2.3169540e+00, 2.0863600e-01, 1.0113760e+00,
 5.4044900e-03, 3.4028170e-01, 8.3377370e-02, 3.1195350e-01, 3.1961430e-01, 1.2294920e+00, 2.0431660e-01, 1.4550150e+00,
 2.7667180e-01, 6.2982180e-01, 1.4544210e-01, 5.5446320e-01, 4.1661810e-01, 3.3900050e+00, 2.8322100e-01, 1.4754620e+00,
 7.3305400e-03, 4.7798260e-01, 1.0866130e-01, 4.3691370e-01, 6.6398400e-01, 2.6451430e+00, 4.0783130e-01, 3.1212130e+00,
 3.8451310e-02, 8.9973310e-02, 3.0964470e-02, 7.2236390e-02, 4.1369000e-01, 3.4600870e+00, 4.3081390e-01, 1.3734160e+00,
 5.1106150e-03, 3.4253040e-01, 1.1604850e-01, 2.8554210e-01, 4.7604780e-01, 1.9493600e+00, 4.4792050e-01, 2.0977490e+00,
 1.5885120e-01, 2.4095130e-01, 9.1050250e-02, 3.3902360e-01, 2.9469810e-01, 1.5978120e+00, 2.1843900e-01, 1.1114730e+00,
 3.3819730e-03, 1.4693740e-01, 5.4660620e-02, 2.1466520e-01, 6.2418390e-01, 1.6568770e+00, 4.1802390e-01, 3.1247130e+00,
 2.8228540e-02, 4.8080130e-02, 1.8995430e-02, 9.8066760e-02, 2.7315420e-02, 1.6630080e-01, 2.3770080e-02, 1.6769620e-01,
 4.6886650e-04, 2.2874400e-02, 8.8965920e-03, 4.8443390e-02, 4.7071310e-02, 1.4030470e-01, 3.7009640e-02, 3.8357270e-01,
 1.1929040e-02, 2.1041400e-02, 7.7127890e-03, 4.2792070e-02, 1.4273160e-02, 8.9990980e-02, 1.1934070e-02, 9.0481580e-02,
 2.3520800e-04, 1.1883510e-02, 4.2881690e-03, 2.5093540e-02, 3.6166740e-02, 1.1163940e-01, 2.7322050e-02, 3.0431640e-01,
 2.9495160e-03, 5.3477360e-03, 2.9213550e-03, 9.9184960e-03, 2.5214840e-02, 1.6341240e-01, 3.2296240e-02, 1.4984200e-01,
 2.9173490e-04, 1.5150640e-02, 8.1477140e-03, 2.9176660e-02, 4.6131920e-02, 1.4637250e-01, 5.3386690e-02, 3.6387710e-01,
 1.0063400e-02, 1.1827690e-02, 7.0944090e-03, 3.8444500e-02, 1.4834500e-02, 6.2321490e-02, 1.3524050e-02, 1.0014860e-01,
 1.5944090e-04, 5.3675810e-03, 3.1694600e-03, 1.8115130e-02, 4.9954880e-02, 1.0274770e-01, 4.1147880e-02, 4.4763670e-01,
 3.7727490e-01, 8.1337290e-01, 2.2811360e-01, 9.8775810e-01, 2.7833270e-01, 2.1448920e+00, 2.1763040e-01, 1.2877720e+00,
 7.6372660e-03, 4.7162080e-01, 1.3021020e-01, 5.9467900e-01, 4.5845810e-01, 1.7296980e+00, 3.2388490e-01, 2.8154670e+00,
 1.5701730e-01, 3.5056730e-01, 9.1219150e-02, 4.2448730e-01, 1.4323500e-01, 1.1430960e+00, 1.0760930e-01, 6.8430320e-01,
 3.7732310e-03, 2.4130190e-01, 6.1810990e-02, 3.0337700e-01, 3.4691680e-01, 1.3554640e+00, 2.3548420e-01, 2.1998880e+00,
 5.6452910e-02, 1.2955680e-01, 5.0240320e-02, 1.4306740e-01, 3.6794160e-01, 3.0182980e+00, 4.2345480e-01, 1.6478410e+00,
 6.8052380e-03, 4.4734280e-01, 1.7077450e-01, 5.1292010e-01, 6.4344440e-01, 2.5841850e+00, 6.6907520e-01, 3.8249300e+00,
 9.8578010e-02, 1.4665270e-01, 6.2443060e-02, 2.8381090e-01, 1.1078870e-01, 5.8913520e-01, 9.0753150e-02, 5.6367200e-01,
 1.9035080e-03, 8.1112540e-02, 3.3999500e-02, 1.6298800e-01, 3.5660490e-01, 9.2840230e-01, 2.6393040e-01, 2.4082100e+00,
 8.3923870e-06, 7.4355940e-05, 5.7781310e-05, 2.4976660e-04, 4.4534760e-05, 1.4103880e-03, 3.9651820e-04, 2.3422330e-03,
 4.8143360e-06, 1.2217710e-03, 9.3465650e-04, 4.2612530e-03, 1.5226750e-04, 2.3608920e-03, 1.2249180e-03, 1.0629530e-02,
 4.2841650e-05, 3.9308690e-04, 2.8340890e-04, 1.3165570e-03, 2.8110930e-04, 9.2194940e-03, 2.4048320e-03, 1.5266200e-02,
 2.9174470e-05, 7.6674110e-03, 5.4420690e-03, 2.6664200e-02, 1.4132670e-03, 2.2692650e-02, 1.0923690e-02, 1.0187220e-01,
 7.4464540e-07, 7.0229850e-06, 7.5461290e-06, 2.1451620e-05, 3.4909960e-05, 1.1768770e-03, 4.5749480e-04, 1.7772230e-03,
 2.5437670e-06, 6.8718380e-04, 7.2688530e-04, 2.1794160e-03, 1.2672260e-04, 2.0915350e-03, 1.5004680e-03, 8.5629410e-03,
 8.4882430e-06, 5.1895090e-05, 6.1225260e-05, 2.7779410e-04, 6.8618380e-05, 1.4995410e-03, 6.4005230e-04, 3.9685130e-03,
 4.6447600e-06, 8.1338290e-04, 9.4469120e-04, 4.5208540e-03, 4.5846380e-04, 4.9051510e-03, 3.8638100e-03, 3.5193980e-02,
 1.9707440e-01, 3.5456810e-01, 1.2531480e-01, 3.6860600e-01, 2.0280690e-01, 1.3042520e+00, 1.6676960e-01, 6.7034270e-01,
 4.5429940e-03, 2.3411810e-01, 8.1456940e-02, 2.5271230e-01, 3.2259700e-01, 1.0157080e+00, 2.3967920e-01, 1.4153070e+00,
 1.5185770e-01, 2.8294280e-01, 9.2780000e-02, 2.9328750e-01, 1.9323450e-01, 1.2869330e+00, 1.5267380e-01, 6.5951330e-01,
 4.1556100e-03, 2.2177870e-01, 7.1592270e-02, 2.3869510e-01, 4.5196330e-01, 1.4736820e+00, 3.2264030e-01, 2.0474720e+00,
 2.3438060e-02, 4.4888320e-02, 2.1936470e-02, 4.2434160e-02, 2.1308870e-01, 1.4587520e+00, 2.5790960e-01, 6.8176760e-01,
 3.2174420e-03, 1.7650040e-01, 8.4912080e-02, 1.7324340e-01, 3.5986110e-01, 1.2061060e+00, 3.9353000e-01, 1.5282240e+00,
 7.8958440e-02, 9.8027160e-02, 5.2599510e-02, 1.6240040e-01, 1.2378270e-01, 5.4930990e-01, 1.0663640e-01, 4.4991520e-01,
 1.7362220e-03, 6.1741380e-02, 3.2613850e-02, 1.0620520e-01, 3.8476390e-01, 8.3595150e-01, 2.9948520e-01, 1.8562690e+00,
 1.1752680e-01, 2.1968550e-01, 6.7501070e-02, 3.4546820e-01, 1.0118130e-01, 6.7604290e-01, 7.5151230e-02, 5.2559780e-01,
 1.7167540e-03, 9.1917070e-02, 2.7803260e-02, 1.5008300e-01, 1.4225520e-01, 4.6534140e-01, 9.5464060e-02, 9.8083880e-01,
 7.8665600e-02, 1.5227960e-01, 4.3411430e-02, 2.3877060e-01, 8.3742060e-02, 5.7944210e-01, 5.9761990e-02, 4.4918120e-01,
 1.3640870e-03, 7.5634940e-02, 2.1226340e-02, 1.2313740e-01, 1.7312210e-01, 5.8647320e-01, 1.1162710e-01, 1.2325550e+00,
 1.1830120e-02, 2.3539430e-02, 1.0000830e-02, 3.3660640e-02, 8.9978500e-02, 6.3996320e-01, 9.8366590e-02, 4.5243260e-01,
 1.0290530e-03, 5.8649960e-02, 2.4530030e-02, 8.7080860e-02, 1.3430850e-01, 4.6768050e-01, 1.3266250e-01, 8.9638550e-01,
 6.8090930e-02, 8.7827850e-02, 4.0970770e-02, 2.2009840e-01, 8.9302090e-02, 4.1173150e-01, 6.9487810e-02, 5.1011880e-01,
 9.4875750e-04, 3.5052710e-02, 1.6097330e-02, 9.1208410e-02, 2.4535010e-01, 5.5381930e-01, 1.7249200e-01, 1.8602530e+00,
 1.4350630e+00, 3.3953950e+00, 7.4058900e-01, 3.1790810e+00, 9.4193560e-01, 7.9661780e+00, 6.2862220e-01, 3.6875160e+00,
 2.5548270e-02, 1.7314270e+00, 3.7177630e-01, 1.6832330e+00, 1.2658320e+00, 5.2412440e+00, 7.6327390e-01, 6.5775630e+00,
 9.4600120e-01, 2.3179450e+00, 4.6907620e-01, 2.1639480e+00, 7.6778110e-01, 6.7244760e+00, 4.9232430e-01, 3.1036640e+00,
 1.9992550e-02, 1.4031470e+00, 2.7953340e-01, 1.3601150e+00, 1.5171660e+00, 6.5055430e+00, 8.7898760e-01, 8.1404130e+00,
 2.0686620e-01, 5.2101580e-01, 1.5713350e-01, 4.4359020e-01, 1.1995710e+00, 1.0799330e+01, 1.1783310e+00, 4.5456970e+00,
 2.1930940e-02, 1.5821290e+00, 4.6973200e-01, 1.3986260e+00, 1.7115040e+00, 7.5435890e+00, 1.5189900e+00, 8.6085160e+00,
 6.0938180e-01, 9.9491760e-01, 3.2946310e-01, 1.4844870e+00, 6.0932470e-01, 3.5559520e+00, 4.2601830e-01, 2.6231180e+00,
 1.0348440e-02, 4.8394460e-01, 1.5776320e-01, 7.4974520e-01, 1.6001490e+00, 4.5719010e+00, 1.0108240e+00, 9.1433520e+00,
 4.6042290e-05, 4.4768720e-04, 2.7056520e-04, 1.1594280e-03, 2.1737740e-04, 7.5551250e-03, 1.6519300e-03, 9.6734970e-03,
 2.3228360e-05, 6.4693330e-03, 3.8489940e-03, 1.7396320e-02, 6.0637630e-04, 1.0318080e-02, 4.1634670e-03, 3.5816840e-02,
 3.7227930e-04, 3.7486840e-03, 2.1019830e-03, 9.6801110e-03, 2.1733110e-03, 7.8224220e-02, 1.5868810e-02, 9.9865480e-02,
 2.2295460e-04, 6.4305720e-02, 3.5496910e-02, 1.7241690e-01, 8.9143630e-03, 1.5708660e-01, 5.8809650e-02, 5.4370070e-01,
 3.9356020e-06, 4.0735300e-05, 3.4040740e-05, 9.5931190e-05, 1.6415530e-04, 6.0732920e-03, 1.8361360e-03, 7.0710780e-03,
 1.1823600e-05, 3.5053620e-03, 2.8837080e-03, 8.5713730e-03, 4.8616020e-04, 8.8059870e-03, 4.9132080e-03, 2.7796250e-02,
 7.5680790e-05, 5.0778710e-04, 4.6592030e-04, 2.0956990e-03, 5.4431740e-04, 1.3054430e-02, 4.3335160e-03, 2.6636530e-02,
 3.6420150e-05, 6.9994060e-03, 6.3223940e-03, 2.9994180e-02, 2.9671300e-03, 3.4839460e-02, 2.1343240e-02, 1.9272490e-01,
 1.0665600e+00, 2.1059220e+00, 5.7885590e-01, 1.6879340e+00, 9.7652090e-01, 6.8920460e+00, 6.8537620e-01, 2.7310760e+00,
 2.1622590e-02, 1.2228930e+00, 3.3090770e-01, 1.0177240e+00, 1.2672990e+00, 4.3790000e+00, 8.0364110e-01, 4.7044320e+00,
 1.3017360e+00, 2.6617810e+00, 6.7881860e-01, 2.1272460e+00, 1.4737200e+00, 1.0771440e+01, 9.9382010e-01, 4.2559030e+00,
 3.1327930e-02, 1.8348660e+00, 4.6065540e-01, 1.5225740e+00, 2.8122440e+00, 1.0063320e+01, 1.7134900e+00, 1.0779680e+01,
 1.2219880e-01, 2.5684200e-01, 9.7616920e-02, 1.8719700e-01, 9.8843820e-01, 7.4260550e+00, 1.0211040e+00, 2.6758610e+00,
 1.4752530e-02, 8.8815570e-01, 3.3230630e-01, 6.7212580e-01, 1.3618950e+00, 5.0093540e+00, 1.2711590e+00, 4.8936590e+00,
 6.9446440e-01, 9.4620540e-01, 3.9486290e-01, 1.2085830e+00, 9.6862460e-01, 4.7173750e+00, 7.1221960e-01, 2.9789560e+00,
 1.3429730e-02, 5.2411440e-01, 2.1531650e-01, 6.9509760e-01, 2.4564580e+00, 5.8571140e+00, 1.6319380e+00, 1.0027530e+01,
 1.1848020e-02, 2.0059310e-02, 8.5173780e-03, 4.0447860e-02, 1.0984560e-02, 6.6475570e-02, 1.0211860e-02, 6.6269590e-02,
 2.2305250e-04, 1.0816840e-02, 4.5214830e-03, 2.2646900e-02, 1.3746430e-02, 4.0728540e-02, 1.1546430e-02, 1.1007730e-01,
 8.1493680e-03, 1.4288480e-02, 5.6289750e-03, 2.8727520e-02, 9.3423480e-03, 5.8550110e-02, 8.3449470e-03, 5.8198570e-02,
 1.8212560e-04, 9.1465350e-03, 3.5472370e-03, 1.9094020e-02, 1.7191120e-02, 5.2747900e-02, 1.3874180e-02, 1.4214660e-01,
 1.1611080e-03, 2.0925930e-03, 1.2285860e-03, 3.8369330e-03, 9.5103300e-03, 6.1265660e-02, 1.3013390e-02, 5.5537850e-02,
 1.3017000e-04, 6.7196460e-03, 3.8838060e-03, 1.2793060e-02, 1.2635710e-02, 3.9852050e-02, 1.5621780e-02, 9.7942060e-02,
 6.7563270e-03, 7.8933070e-03, 5.0884050e-03, 2.5363940e-02, 9.5423730e-03, 3.9848700e-02, 9.2937180e-03, 6.3305930e-02,
 1.2132950e-04, 4.0601130e-03, 2.5766250e-03, 1.3546420e-02, 2.3335670e-02, 4.7709780e-02, 2.0534740e-02, 2.0548700e-01,
 2.1109460e-01, 4.5237820e-01, 1.3635450e-01, 5.4310780e-01, 1.4921090e-01, 1.1429700e+00, 1.2463940e-01, 6.7840920e-01,
 4.8434800e-03, 2.9730720e-01, 8.8219320e-02, 3.7061110e-01, 1.7848220e-01, 6.6935790e-01, 1.3470550e-01, 1.0771150e+00,
 1.4299730e-01, 3.1735440e-01, 8.8749430e-02, 3.7989290e-01, 1.2498180e-01, 9.9145520e-01, 1.0031060e-01, 5.8676250e-01,
 3.8948800e-03, 2.4759070e-01, 6.8162530e-02, 3.0773690e-01, 2.1982740e-01, 8.5376320e-01, 1.5941070e-01, 1.3698510e+00,
 2.9625800e-02, 6.7582880e-02, 2.8166660e-02, 7.3780350e-02, 1.8500350e-01, 1.5085370e+00, 2.2746120e-01, 8.1420280e-01,
 4.0478790e-03, 2.6449500e-01, 1.0851920e-01, 2.9981280e-01, 2.3494750e-01, 9.3794300e-01, 2.6099610e-01, 1.3724600e+00,
 8.8228290e-02, 1.3047000e-01, 5.9705080e-02, 2.4961640e-01, 9.5003700e-02, 5.0217250e-01, 8.3139250e-02, 4.7499370e-01,
 1.9310030e-03, 8.1791690e-02, 3.6846830e-02, 1.6248010e-01, 2.2207070e-01, 5.7468930e-01, 1.7558710e-01, 1.4737190e+00,
 3.3403270e-07, 2.9417920e-06, 2.4569150e-06, 9.7690920e-06, 1.6983210e-06, 5.3462880e-05, 1.6154110e-05, 8.7774250e-05,
 2.1719020e-07, 5.4788160e-05, 4.5045900e-05, 1.8891110e-04, 4.2168370e-06, 6.4990330e-05, 3.6239810e-05, 2.8927450e-04,
 2.7754330e-06, 2.5313140e-05, 1.9614500e-05, 8.3814770e-05, 1.7448460e-05, 5.6882910e-04, 1.5946520e-04, 9.3117000e-04,
 2.1422400e-06, 5.5963730e-04, 4.2690220e-04, 1.9240210e-03, 6.3703730e-05, 1.0167610e-03, 5.2602850e-04, 4.5124530e-03,
 2.7798260e-08, 2.6060490e-07, 3.0094810e-07, 7.8694530e-07, 1.2486320e-06, 4.1841680e-05, 1.7481180e-05, 6.2465990e-05,
 1.0763310e-07, 2.8902430e-05, 3.2857440e-05, 9.0620170e-05, 3.2915350e-06, 5.4001070e-05, 4.1636130e-05, 2.1856640e-04,
 5.4041820e-07, 3.2842130e-06, 4.1643010e-06, 1.7380070e-05, 4.1857170e-06, 9.0924450e-05, 4.1710380e-05, 2.3788850e-04,
 3.3517830e-07, 5.8344590e-05, 7.2828570e-05, 3.2058960e-04, 2.0309230e-05, 2.1599000e-04, 1.8285360e-04, 1.5320500e-03,
 1.0256520e-01, 1.8342670e-01, 6.9674150e-02, 1.8851620e-01, 1.0112770e-01, 6.4646030e-01, 8.8838980e-02, 3.2847360e-01,
 2.6798640e-03, 1.3727720e-01, 5.1333150e-02, 1.4649180e-01, 1.1681710e-01, 3.6560140e-01, 9.2720540e-02, 5.0363180e-01,
 1.2863760e-01, 2.3824440e-01, 8.3962400e-02, 2.4414120e-01, 1.5683150e-01, 1.0382390e+00, 1.3237690e-01, 5.2600310e-01,
 3.9899410e-03, 2.1166280e-01, 7.3433980e-02, 2.2521200e-01, 2.6638550e-01, 8.6338410e-01, 2.0315400e-01, 1.1858830e+00,
 1.1440800e-02, 2.1780150e-02, 1.1439330e-02, 2.0354790e-02, 9.9658030e-02, 6.7815080e-01, 1.2886020e-01, 3.1333190e-01,
 1.7801060e-03, 9.7067460e-02, 5.0188470e-02, 9.4190710e-02, 1.2222100e-01, 4.0718250e-01, 1.4278680e-01, 5.1005150e-01,
 6.5732080e-02, 8.1118160e-02, 4.6779950e-02, 1.3285630e-01, 9.8731600e-02, 4.3551830e-01, 9.0865860e-02, 3.5264930e-01,
 1.6382660e-03, 5.7909330e-02, 3.2876130e-02, 9.8478460e-02, 2.2286880e-01, 4.8131450e-01, 1.8532310e-01, 1.0566040e+00,
 2.4586990e-02, 5.1165050e-02, 1.4235530e-02, 8.8631820e-02, 3.4845130e-02, 2.5919090e-01, 2.6089910e-02, 2.2197730e-01,
 4.5337310e-04, 2.7023850e-02, 7.4018080e-03, 4.8606250e-02, 3.0463550e-02, 1.1093980e-01, 2.0608510e-02, 2.5758640e-01,
 1.3803480e-02, 2.9747390e-02, 7.6789550e-03, 5.1380390e-02, 2.4189160e-02, 1.8633340e-01, 1.7401900e-02, 1.5911520e-01,
 3.0215160e-04, 1.8651280e-02, 4.7397160e-03, 3.3449210e-02, 3.1095660e-02, 1.1727330e-01, 2.0212090e-02, 2.7149810e-01,
 3.6454220e-03, 8.0752860e-03, 3.1066250e-03, 1.2720200e-02, 4.5642640e-02, 3.6140190e-01, 5.0300700e-02, 2.8144850e-01,
 4.0029050e-04, 2.5398540e-02, 9.6190040e-03, 4.1540660e-02, 4.2364870e-02, 1.6423090e-01, 4.2183720e-02, 3.4674490e-01,
 1.1324530e-02, 1.6261730e-02, 6.8690940e-03, 4.4891170e-02, 2.4449290e-02, 1.2549370e-01, 1.9178190e-02, 1.7127300e-01,
 1.9918900e-04, 8.1928530e-03, 3.4068920e-03, 2.3483240e-02, 4.1769670e-02, 1.0496540e-01, 2.9603160e-02, 3.8838260e-01,
 7.3091050e-01, 1.9252490e+00, 3.8024620e-01, 1.9856740e+00, 7.8974700e-01, 7.4356720e+00, 5.3131350e-01, 3.7915230e+00,
 1.6426080e-02, 1.2393100e+00, 2.4096190e-01, 1.3271790e+00, 6.5995340e-01, 3.0421090e+00, 4.0115460e-01, 4.2054740e+00,
 4.0412900e-01, 1.1023890e+00, 2.0200690e-01, 1.1336740e+00, 5.3993230e-01, 5.2645800e+00, 3.4901780e-01, 2.6766380e+00,
 1.0781420e-02, 8.4239170e-01, 1.5196220e-01, 8.9948930e-01, 6.6344550e-01, 3.1670800e+00, 3.8747990e-01, 4.3654760e+00,
 1.5519320e-01, 4.3514860e-01, 1.1883550e-01, 4.0811090e-01, 1.4814360e+00, 1.4847630e+01, 1.4669610e+00, 6.8844660e+00,
 2.0769190e-02, 1.6680450e+00, 4.4844260e-01, 1.6243400e+00, 1.3143310e+00, 6.4492390e+00, 1.1759160e+00, 8.1071520e+00,
 2.4674320e-01, 4.4848330e-01, 1.3447980e-01, 7.3713190e-01, 4.0614220e-01, 2.6386910e+00, 2.8625420e-01, 2.1441750e+00,
 5.2894390e-03, 2.7538100e-01, 8.1289610e-02, 4.6996080e-01, 6.6322350e-01, 2.1095980e+00, 4.2234700e-01, 4.6474850e+00,
 9.4119860e-06, 1.0188320e-04, 5.5755880e-05, 2.9065730e-04, 7.3149670e-05, 2.8303680e-03, 5.6038170e-04, 3.9920350e-03,
 5.9940720e-06, 1.8585170e-03, 1.0012560e-03, 5.5052100e-03, 1.2688500e-04, 2.4036450e-03, 8.7824890e-04, 9.1911190e-03,
 6.3830510e-05, 7.1555280e-04, 3.6331480e-04, 2.0354140e-03, 6.1341570e-04, 2.4579760e-02, 4.5151460e-03, 3.4566980e-02,
 4.8256410e-05, 1.5495000e-02, 7.7450370e-03, 4.5764790e-02, 1.5645650e-03, 3.0693450e-02, 1.0405100e-02, 1.1702430e-01,
 1.1850200e-06, 1.3654910e-05, 1.0332560e-05, 3.5423150e-05, 8.1365960e-05, 3.3513160e-03, 9.1746000e-04, 4.2981990e-03,
 4.4941050e-06, 1.4833020e-03, 1.1049410e-03, 3.9953690e-03, 1.4984340e-04, 3.0216180e-03, 1.5265730e-03, 1.0506480e-02,
 1.2299080e-05, 9.1869630e-05, 7.6329580e-05, 4.1766570e-04, 1.4561720e-04, 3.8879580e-03, 1.1686790e-03, 8.7387830e-03,
 7.4715000e-06, 1.5985660e-03, 1.3075010e-03, 7.5459870e-03, 4.9359090e-04, 6.4521650e-03, 3.5791960e-03, 3.9317100e-02,
 3.5627740e-01, 7.8315690e-01, 1.9492520e-01, 6.9146690e-01, 5.3698010e-01, 4.2191810e+00, 3.7992690e-01, 1.8417190e+00,
 9.1177990e-03, 5.7408200e-01, 1.4066420e-01, 5.2629010e-01, 4.3333700e-01, 1.6669600e+00, 2.7701500e-01, 1.9727270e+00,
 3.6472140e-01, 8.3025970e-01, 1.9172830e-01, 7.3091850e-01, 6.7971470e-01, 5.5308120e+00, 4.6207650e-01, 2.4072240e+00,
 1.1080240e-02, 7.2247880e-01, 1.6424340e-01, 6.6040250e-01, 8.0655680e-01, 3.2131170e+00, 4.9540220e-01, 3.7914100e+00,
 6.0125680e-02, 1.4068980e-01, 4.8418630e-02, 1.1295490e-01, 8.0060100e-01, 6.6961970e+00, 8.3374030e-01, 2.6579280e+00,
 9.1630240e-03, 6.1413630e-01, 2.0806790e-01, 5.1195970e-01, 6.8593120e-01, 2.8088080e+00, 6.4540300e-01, 3.0226200e+00,
 1.8442320e-01, 2.7973990e-01, 1.0570760e-01, 3.9360000e-01, 4.2344270e-01, 2.2958470e+00, 3.1386830e-01, 1.5970410e+00,
 4.5020680e-03, 1.9560240e-01, 7.2763980e-02, 2.8576140e-01, 6.6775750e-01, 1.7725420e+00, 4.4720570e-01, 3.3428460e+00,
 4.2972060e-02, 7.3191950e-02, 2.8916580e-02, 1.4928620e-01, 5.1463310e-02, 3.1331730e-01, 4.4783770e-02, 3.1594620e-01,
 8.1839620e-04, 3.9926760e-02, 1.5528810e-02, 8.4556890e-02, 6.6029050e-02, 1.9681180e-01, 5.1915100e-02, 5.3805480e-01,
 1.6269750e-02, 2.8697900e-02, 1.0519300e-02, 5.8363140e-02, 2.4092830e-02, 1.5190310e-01, 2.0144480e-02, 1.5273120e-01,
 3.6782750e-04, 1.8583900e-02, 6.7060080e-03, 3.9242270e-02, 4.5453340e-02, 1.4030530e-01, 3.4337590e-02, 3.8245630e-01,
 4.7717620e-03, 8.6516300e-03, 4.7262030e-03, 1.6046260e-02, 5.0486650e-02, 3.2719390e-01, 6.4665440e-02, 3.0002240e-01,
 5.4116940e-04, 2.8104490e-02, 1.5114040e-02, 5.4122810e-02, 6.8771840e-02, 2.1820700e-01, 7.9586990e-02, 5.4245510e-01,
 1.2087840e-02, 1.4207060e-02, 8.5215870e-03, 4.6178350e-02, 2.2053090e-02, 9.2647630e-02, 2.0104960e-02, 1.4888160e-01,
 2.1959420e-04, 7.3926410e-03, 4.3652220e-03, 2.4949540e-02, 5.5292120e-02, 1.1372540e-01, 4.5544170e-02, 4.9546280e-01,
 6.1173230e-01, 1.3188430e+00, 3.6987470e-01, 1.6016000e+00, 5.5854730e-01, 4.3042870e+00, 4.3673230e-01, 2.5842510e+00,
 1.4199010e-02, 8.7682560e-01, 2.4208340e-01, 1.1056120e+00, 6.8499000e-01, 2.5843710e+00, 4.8392190e-01, 4.2066360e+00,
 2.2810180e-01, 5.0927530e-01, 1.3251570e-01, 6.1666010e-01, 2.5752700e-01, 2.0552090e+00, 1.9347430e-01, 1.2303310e+00,
 6.2850880e-03, 4.0193760e-01, 1.0295890e-01, 5.0533640e-01, 4.6439510e-01, 1.8144730e+00, 3.1522750e-01, 2.9448480e+00,
 9.7279240e-02, 2.2325130e-01, 8.6573740e-02, 2.4653270e-01, 7.8470230e-01, 6.4370680e+00, 9.0309420e-01, 3.5143200e+00,
 1.3446020e-02, 8.8387530e-01, 3.3742220e-01, 1.0134450e+00, 1.0217060e+00, 4.1033500e+00, 1.0624040e+00, 6.0734910e+00,
 1.2612180e-01, 1.8762910e-01, 7.9890330e-02, 3.6311070e-01, 1.7542750e-01, 9.3286160e-01, 1.4370240e-01, 8.9254220e-01,
 2.7924240e-03, 1.1899120e-01, 4.9876890e-02, 2.3910150e-01, 4.2041530e-01, 1.0945290e+00, 3.1115770e-01, 2.8391320e+00,
 1.0466430e-05, 9.2731810e-05, 7.2061030e-05, 3.1149240e-04, 6.8739190e-05, 2.1769280e-03, 6.1202400e-04, 3.6152260e-03,
 6.8844020e-06, 1.7471080e-03, 1.3365400e-03, 6.0935050e-03, 1.7498520e-04, 2.7131280e-03, 1.4076710e-03, 1.2215420e-02,
 4.7869290e-05, 4.3921720e-04, 3.1666810e-04, 1.4710600e-03, 3.8873920e-04, 1.2749410e-02, 3.3255820e-03, 2.1111240e-02,
 3.7377530e-05, 9.8232750e-03, 6.9722290e-03, 3.4161430e-02, 1.4551100e-03, 2.3364530e-02, 1.1247110e-02, 1.0488840e-01,
 9.8694500e-07, 9.3081870e-06, 1.0001560e-05, 2.8431750e-05, 5.7264430e-05, 1.9304860e-03, 7.5045010e-04, 2.9152620e-03,
 3.8657840e-06, 1.0443190e-03, 1.1046530e-03, 3.3120760e-03, 1.5476710e-04, 2.5544050e-03, 1.8325310e-03, 1.0457970e-02,
 8.3529030e-06, 5.1067650e-05, 6.0249060e-05, 2.7336480e-04, 8.3570360e-05, 1.8262920e-03, 7.7952010e-04, 4.8332540e-03,
 5.2408250e-06, 9.1776490e-04, 1.0659240e-03, 5.1010180e-03, 4.1572470e-04, 4.4478800e-03, 3.5036160e-03, 3.1913110e-02,
 3.1212600e-01, 5.6156440e-01, 1.9847330e-01, 5.8379740e-01, 3.9753440e-01, 2.5565470e+00, 3.2689560e-01, 1.3139810e+00,
 8.2500910e-03, 4.2515930e-01, 1.4792610e-01, 4.5892630e-01, 4.7080520e-01, 1.4823460e+00, 3.4979320e-01, 2.0655300e+00,
 2.1548370e-01, 4.0149130e-01, 1.3165340e-01, 4.1617030e-01, 3.3935520e-01, 2.2600900e+00, 2.6812310e-01, 1.1582260e+00,
 6.7612830e-03, 3.6083960e-01, 1.1648240e-01, 3.8836300e-01, 5.9096510e-01, 1.9269140e+00, 4.2186870e-01, 2.6771740e+00,
 3.9450450e-02, 7.5555050e-02, 3.6922990e-02, 7.1424270e-02, 4.4389760e-01, 3.0388120e+00, 5.3726670e-01, 1.4202300e+00,
 6.2095150e-03, 3.4063760e-01, 1.6387640e-01, 3.3435170e-01, 5.5814390e-01, 1.8706680e+00, 6.1036420e-01, 2.3702720e+00,
 9.8674510e-02, 1.2250470e-01, 6.5733710e-02, 2.0295210e-01, 1.9145150e-01, 8.4960300e-01, 1.6493170e-01, 6.9587190e-01,
 2.4878740e-03, 8.8470720e-02, 4.6733170e-02, 1.5218390e-01, 4.4307970e-01, 9.6265030e-01, 3.4487590e-01, 2.1376100e+00,
 1.1768020e-01, 2.1997240e-01, 6.7589200e-02, 3.4591930e-01, 1.2538890e-01, 8.3778610e-01, 9.3131160e-02, 6.5134700e-01,
 1.9710220e-03, 1.0553090e-01, 3.1921200e-02, 1.7231180e-01, 1.3125500e-01, 4.2935790e-01, 8.8082100e-02, 9.0499340e-01,
 7.0571480e-02, 1.3661120e-01, 3.8944710e-02, 2.1420280e-01, 9.2978010e-02, 6.4334900e-01, 6.6353170e-02, 4.9872170e-01,
 1.4031480e-03, 7.7800720e-02, 2.1834150e-02, 1.2666340e-01, 1.4311260e-01, 4.8481240e-01, 9.2277330e-02, 1.0189010e+00,
 1.2588860e-02, 2.5049150e-02, 1.0642240e-02, 3.5819490e-02, 1.1850260e-01, 8.4283820e-01, 1.2954980e-01, 5.9585850e-01,
 1.2556000e-03, 7.1561850e-02, 2.9930360e-02, 1.0625190e-01, 1.3169880e-01, 4.5859290e-01, 1.3008470e-01, 8.7896780e-01,
 5.3797550e-02, 6.9391380e-02, 3.2370350e-02, 1.7389620e-01, 8.7322690e-02, 4.0260540e-01, 6.7947590e-02, 4.9881190e-01,
 8.5949870e-04, 3.1754960e-02, 1.4582900e-02, 8.2627560e-02, 1.7862430e-01, 4.0320180e-01, 1.2558080e-01, 1.3543360e+00,
 1.5305350e+00, 3.6212850e+00, 7.8985930e-01, 3.3905810e+00, 1.2433290e+00, 1.0515130e+01, 8.2976360e-01, 4.8674180e+00,
 3.1242860e-02, 2.1173540e+00, 4.5464340e-01, 2.0584180e+00, 1.2440270e+00, 5.1509570e+00, 7.5012560e-01, 6.4642560e+00,
 9.0394470e-01, 2.2148960e+00, 4.4822240e-01, 2.0677450e+00, 9.0798740e-01, 7.9524480e+00, 5.8222880e-01, 3.6704310e+00,
 2.1904600e-02, 1.5373410e+00, 3.0626740e-01, 1.4901930e+00, 1.3358710e+00, 5.7281550e+00, 7.7395190e-01, 7.1676650e+00,
 2.3447270e-01, 5.9054600e-01, 1.7810310e-01, 5.0278780e-01, 1.6827560e+00, 1.5149280e+01, 1.6529600e+00, 6.3766930e+00,
 2.8502090e-02, 2.0561820e+00, 6.1047760e-01, 1.8176960e+00, 1.7875650e+00, 7.8788340e+00, 1.5864950e+00, 8.9910870e+00,
 5.1282420e-01, 8.3727120e-01, 2.7725910e-01, 1.2492680e+00, 6.3462920e-01, 3.7036260e+00, 4.4371030e-01, 2.7320530e+00,
 9.9855160e-03, 4.6697270e-01, 1.5223050e-01, 7.2345160e-01, 1.2408530e+00, 3.5453320e+00, 7.8385490e-01, 7.0903150e+00,
 3.7769300e-05, 3.6724570e-04, 2.2194940e-04, 9.5109940e-04, 2.2069310e-04, 7.6703640e-03, 1.6771270e-03, 9.8210470e-03,
 2.1848280e-05, 6.0849690e-03, 3.6203130e-03, 1.6362750e-02, 4.5835860e-04, 7.7994140e-03, 3.1471560e-03, 2.7073870e-02,
 2.7360790e-04, 2.7551080e-03, 1.5448600e-03, 7.1144300e-03, 1.9768510e-03, 7.1153010e-02, 1.4434320e-02, 9.0837970e-02,
 1.8788530e-04, 5.4190880e-02, 2.9913490e-02, 1.4529690e-01, 6.0371390e-03, 1.0638490e-01, 3.9828090e-02, 3.6821440e-01,
 3.4310230e-06, 3.5512670e-05, 2.9676410e-05, 8.3631950e-05, 1.7711670e-04, 6.5528280e-03, 1.9811140e-03, 7.6293980e-03,
 1.1818950e-05, 3.5039830e-03, 2.8825740e-03, 8.5680020e-03, 3.9054670e-04, 7.0741060e-03, 3.9469230e-03, 2.2329540e-02,
 4.8986260e-05, 3.2867770e-04, 3.0157840e-04, 1.3564930e-03, 4.3604680e-04, 1.0457760e-02, 3.4715330e-03, 2.1338230e-02,
 2.7030070e-05, 5.1947730e-03, 4.6923130e-03, 2.2260890e-02, 1.7697270e-03, 2.0779790e-02, 1.2730050e-02, 1.1494960e-01,
 1.1111020e+00, 2.1938710e+00, 6.0303050e-01, 1.7584260e+00, 1.2590490e+00, 8.8860600e+00, 8.8367000e-01, 3.5212340e+00,
 2.5828160e-02, 1.4607430e+00, 3.9526880e-01, 1.2156700e+00, 1.2165470e+00, 4.2036340e+00, 7.7145760e-01, 4.5160330e+00,
 1.2149810e+00, 2.4843850e+00, 6.3357830e-01, 1.9854740e+00, 1.7023690e+00, 1.2442640e+01, 1.1480120e+00, 4.9162110e+00,
 3.3527020e-02, 1.9636660e+00, 4.9299150e-01, 1.6294530e+00, 2.4186920e+00, 8.6550350e+00, 1.4737000e+00, 9.2711470e+00,
 1.3529010e-01, 2.8435790e-01, 1.0807480e-01, 2.0725170e-01, 1.3543810e+00, 1.0175360e+01, 1.3991400e+00, 3.6665270e+00,
 1.8727620e-02, 1.1274700e+00, 4.2184650e-01, 8.5323070e-01, 1.3893890e+00, 5.1104840e+00, 1.2968210e+00, 4.9924530e+00,
 5.7085450e-01, 7.7778730e-01, 3.2458000e-01, 9.9346350e-01, 9.8542390e-01, 4.7991910e+00, 7.2457200e-01, 3.0306210e+00,
 1.2657840e-02, 4.9399010e-01, 2.0294090e-01, 6.5514580e-01, 1.8606550e+00, 4.4364970e+00, 1.2361180e+00, 7.5953970e+00,
 2.7185190e-02, 4.6025910e-02, 1.9543050e-02, 9.2807270e-02, 3.1193290e-02, 1.8877340e-01, 2.8999020e-02, 1.8818840e-01,
 5.8682730e-04, 2.8457950e-02, 1.1895540e-02, 5.9581570e-02, 2.9064140e-02, 8.6112520e-02, 2.4412670e-02, 2.3273690e-01,
 1.6752830e-02, 2.9373130e-02, 1.1571600e-02, 5.9055760e-02, 2.3769080e-02, 1.4896490e-01, 2.1231460e-02, 1.4807050e-01,
 4.2929120e-04, 2.1559440e-02, 8.3612490e-03, 4.5006810e-02, 3.2564870e-02, 9.9919540e-02, 2.6281650e-02, 2.6926610e-01,
 2.8313240e-03, 5.1027190e-03, 2.9958660e-03, 9.3562310e-03, 2.8701500e-02, 1.8489540e-01, 3.9273500e-02, 1.6760930e-01,
 3.6395230e-04, 1.8787970e-02, 1.0859030e-02, 3.5769090e-02, 2.8392110e-02, 8.9546490e-02, 3.5101720e-02, 2.2007320e-01,
 1.2232170e-02, 1.4290650e-02, 9.2124400e-03, 4.5920820e-02, 2.1381670e-02, 8.9289300e-02, 2.0824510e-02, 1.4185010e-01,
 2.5186990e-04, 8.4284540e-03, 5.3488570e-03, 2.8121220e-02, 3.8930890e-02, 7.9594220e-02, 3.4258100e-02, 3.4281390e-01,
 5.1590440e-01, 1.1055890e+00, 3.3324350e-01, 1.3273280e+00, 4.5132060e-01, 3.4571580e+00, 3.7699860e-01, 2.0519940e+00,
 1.3572710e-02, 8.3313320e-01, 2.4721380e-01, 1.0385500e+00, 4.0194650e-01, 1.5074110e+00, 3.0336020e-01, 2.4256900e+00,
 3.1311050e-01, 6.9488740e-01, 1.9432800e-01, 8.3182340e-01, 3.3869510e-01, 2.6867990e+00, 2.7183720e-01, 1.5901000e+00,
 9.7786930e-03, 6.2161430e-01, 1.7113250e-01, 7.7262070e-01, 4.4354000e-01, 1.7226160e+00, 3.2163890e-01, 2.7639130e+00,
 7.6947160e-02, 1.7553320e-01, 7.3157340e-02, 1.9162990e-01, 5.9469550e-01, 4.8492070e+00, 7.3117620e-01, 2.6172630e+00,
 1.2054990e-02, 7.8769270e-01, 3.2318110e-01, 8.9287260e-01, 5.6230840e-01, 2.2448130e+00, 6.2465140e-01, 3.2847580e+00,
 1.7014010e-01, 2.5159940e-01, 1.1513570e-01, 4.8136210e-01, 2.2674180e-01, 1.1985160e+00, 1.9842530e-01, 1.1336500e+00,
 4.2697110e-03, 1.8085260e-01, 8.1473370e-02, 3.5926570e-01, 3.9461290e-01, 1.0212050e+00, 3.1201290e-01, 2.6187530e+00,
 6.2790040e-07, 5.5298560e-06, 4.6184040e-06, 1.8363520e-05, 3.9510620e-06, 1.2437880e-04, 3.7581770e-05, 2.0420260e-04,
 4.6812180e-07, 1.1808790e-04, 9.7089850e-05, 4.0717030e-04, 7.3041510e-06, 1.1257230e-04, 6.2772410e-05, 5.0106380e-04,
 4.6742320e-06, 4.2631000e-05, 3.3033670e-05, 1.4115620e-04, 3.6368790e-05, 1.1856420e-03, 3.3238210e-04, 1.9408890e-03,
 4.1367990e-06, 1.0806950e-03, 8.2437480e-04, 3.7154050e-03, 9.8861100e-05, 1.5779000e-03, 8.1633780e-04, 7.0028260e-03,
 5.5532820e-08, 5.2061270e-07, 6.0120660e-07, 1.5720870e-06, 3.0871590e-06, 1.0345070e-04, 4.3221030e-05, 1.5444290e-04,
 2.4654420e-07, 6.6203850e-05, 7.5263190e-05, 2.0757440e-04, 6.0591500e-06, 9.9406690e-05, 7.6644950e-05, 4.0234330e-04,
 8.0156420e-07, 4.8712420e-06, 6.1766140e-06, 2.5778630e-05, 7.6837010e-06, 1.6690960e-04, 7.6567550e-05, 4.3669090e-04,
 5.7003440e-07, 9.9226060e-05, 1.2385880e-04, 5.4522350e-04, 2.7757660e-05, 2.9520460e-04, 2.4991530e-04, 2.0939320e-03,
 2.4484360e-01, 4.3787610e-01, 1.6632600e-01, 4.5002570e-01, 2.9877950e-01, 1.9099530e+00, 2.6247290e-01, 9.7046830e-01,
 7.3353030e-03, 3.7575420e-01, 1.4050870e-01, 4.0097620e-01, 2.5696640e-01, 8.0422500e-01, 2.0396030e-01, 1.1078550e+00,
 2.7512770e-01, 5.0955250e-01, 1.7957720e-01, 5.2216450e-01, 4.1513730e-01, 2.7482480e+00, 3.5040540e-01, 1.3923450e+00,
 9.7847450e-03, 5.1907190e-01, 1.8008610e-01, 5.5229940e-01, 5.2499840e-01, 1.7015760e+00, 4.0038030e-01, 2.3371630e+00,
 2.9025210e-02, 5.5256040e-02, 2.9021480e-02, 5.1639910e-02, 3.1291290e-01, 2.1293030e+00, 4.0460380e-01, 9.8382020e-01,
 5.1782330e-03, 2.8236400e-01, 1.4599560e-01, 2.7399570e-01, 2.8572340e-01, 9.5189510e-01, 3.3380120e-01, 1.1923780e+00,
 1.2381480e-01, 1.5279640e-01, 8.8116030e-02, 2.5025180e-01, 2.3016730e-01, 1.0152990e+00, 2.1183030e-01, 8.2211090e-01,
 3.5383140e-03, 1.2507210e-01, 7.1005590e-02, 2.1269300e-01, 3.8683480e-01, 8.3542060e-01, 3.2166650e-01, 1.8339540e+00,
 1.7535750e-02, 3.6491570e-02, 1.0152960e-02, 6.3213350e-02, 2.4828070e-02, 1.8468030e-01, 1.8589740e-02, 1.5816460e-01,
 3.1074510e-04, 1.8522340e-02, 5.0732510e-03, 3.3315070e-02, 2.2483790e-02, 8.1879730e-02, 1.5210220e-02, 1.9011300e-01,
 1.1576600e-02, 2.4948310e-02, 6.4401280e-03, 4.3091320e-02, 2.0267250e-02, 1.5612220e-01, 1.4580440e-02, 1.3331710e-01,
 2.4352680e-04, 1.5032470e-02, 3.8200940e-03, 2.6959240e-02, 2.6987460e-02, 1.0177970e-01, 1.7541770e-02, 2.3562910e-01,
 2.5791740e-03, 5.7133500e-03, 2.1979700e-03, 8.9996730e-03, 3.2261550e-02, 2.5544940e-01, 3.5554000e-02, 1.9893600e-01,
 2.7216830e-04, 1.7269150e-02, 6.5402200e-03, 2.8244610e-02, 3.1017630e-02, 1.2024240e-01, 3.0885000e-02, 2.5387080e-01,
 1.3118050e-02, 1.8837180e-02, 7.9569860e-03, 5.2000800e-02, 2.8294160e-02, 1.4522880e-01, 2.2194140e-02, 1.9820730e-01,
 2.2173990e-04, 9.1203940e-03, 3.7925980e-03, 2.6141860e-02, 5.0070270e-02, 1.2582450e-01, 3.5486000e-02, 4.6556330e-01,
 4.7890400e-01, 1.2614530e+00, 2.4914330e-01, 1.3010440e+00, 5.1695640e-01, 4.8672780e+00, 3.4778970e-01, 2.4818740e+00,
 1.0343030e-02, 7.8035770e-01, 1.5172670e-01, 8.3568630e-01, 4.4747350e-01, 2.0626660e+00, 2.7199810e-01, 2.8514720e+00,
 3.1137060e-01, 8.4936130e-01, 1.5564090e-01, 8.7346550e-01, 4.1560280e-01, 4.0523120e+00, 2.6864990e-01, 2.0602920e+00,
 7.9829360e-03, 6.2373610e-01, 1.1251810e-01, 6.6601320e-01, 5.2897190e-01, 2.5251450e+00, 3.0894170e-01, 3.4806380e+00,
 1.0087200e-01, 2.8283660e-01, 7.7240370e-02, 2.6526270e-01, 9.6197190e-01, 9.6413230e+00, 9.5257260e-01, 4.4704360e+00,
 1.2973190e-02, 1.0419220e+00, 2.8011360e-01, 1.0146220e+00, 8.8404150e-01, 4.3378670e+00, 7.9094090e-01, 5.4530080e+00,
 2.6257870e-01, 4.7726600e-01, 1.4311040e-01, 7.8443940e-01, 4.3179130e-01, 2.8053330e+00, 3.0433210e-01, 2.2795860e+00,
 5.4094510e-03, 2.8162910e-01, 8.3133990e-02, 4.8062370e-01, 7.3037170e-01, 2.3231850e+00, 4.6510760e-01, 5.1180200e+00,
 1.7727960e-07, 1.9190220e-06, 1.0501910e-06, 5.4746800e-06, 1.3764850e-06, 5.3260120e-05, 1.0544910e-05, 7.5119650e-05,
 1.0849980e-07, 3.3641350e-05, 1.8123920e-05, 9.9650810e-05, 2.4731910e-06, 4.6850870e-05, 1.7118470e-05, 1.7914960e-04,
 1.4137710e-06, 1.5848650e-05, 8.0469970e-06, 4.5082040e-05, 1.3573360e-05, 5.4388870e-04, 9.9908890e-05, 7.6488080e-04,
 1.0271530e-06, 3.2981600e-04, 1.6485560e-04, 9.7411800e-04, 3.5860310e-05, 7.0350360e-04, 2.3848810e-04, 2.6822340e-03,
 2.2142000e-08, 2.5514080e-07, 1.9306300e-07, 6.6187880e-07, 1.5188530e-06, 6.2558780e-05, 1.7126160e-05, 8.0234170e-05,
 8.0698200e-08, 2.6634860e-05, 1.9840830e-05, 7.1742660e-05, 2.8973340e-06, 5.8425260e-05, 2.9517440e-05, 2.0315070e-04,
 3.7625300e-07, 2.8104730e-06, 2.3350720e-06, 1.2777220e-05, 4.4504270e-06, 1.1882580e-04, 3.5717760e-05, 2.6707920e-04,
 2.1965680e-07, 4.6996710e-05, 3.8439590e-05, 2.2184670e-04, 1.5625880e-05, 2.0425970e-04, 1.1330860e-04, 1.2446830e-03,
 2.2951520e-01, 5.0451250e-01, 1.2557150e-01, 4.4544550e-01, 3.4559140e-01, 2.7153950e+00, 2.4451460e-01, 1.1853000e+00,
 5.6447220e-03, 3.5540740e-01, 8.7083520e-02, 3.2582000e-01, 2.8888080e-01, 1.1112660e+00, 1.8467000e-01, 1.3151040e+00,
 2.7628520e-01, 6.2894160e-01, 1.4523880e-01, 5.5368820e-01, 5.1440430e-01, 4.1856870e+00, 3.4969690e-01, 1.8217740e+00,
 8.0663060e-03, 5.2595770e-01, 1.1956760e-01, 4.8076680e-01, 6.3226780e-01, 2.5187940e+00, 3.8835070e-01, 2.9721240e+00,
 3.8423490e-02, 8.9908230e-02, 3.0942070e-02, 7.2184140e-02, 5.1113380e-01, 4.2751040e+00, 5.3229120e-01, 1.6969210e+00,
 5.6273640e-03, 3.7716460e-01, 1.2778250e-01, 3.1441410e-01, 4.5361480e-01, 1.8574990e+00, 4.2681300e-01, 1.9988960e+00,
 1.9296060e-01, 2.9268970e-01, 1.1060110e-01, 4.1182070e-01, 4.4261820e-01, 2.3998140e+00, 3.2808180e-01, 1.6693630e+00,
 4.5268320e-03, 1.9667840e-01, 7.3164240e-02, 2.8733330e-01, 7.2300550e-01, 1.9191960e+00, 4.8420600e-01, 3.6194220e+00,
 5.5968230e-02, 9.5327610e-02, 3.7661910e-02, 1.9443520e-01, 6.6962980e-02, 4.0768180e-01, 5.8271690e-02, 4.1110260e-01,
 1.0243500e-03, 4.9974550e-02, 1.9436720e-02, 1.0583610e-01, 8.8993910e-02, 2.6526270e-01, 6.9971130e-02, 7.2518990e-01,
 2.4917780e-02, 4.3952000e-02, 1.6110740e-02, 8.9385540e-02, 3.6863620e-02, 2.3242180e-01, 3.0822390e-02, 2.3368890e-01,
 5.4137990e-04, 2.7352360e-02, 9.8701110e-03, 5.7757990e-02, 7.2038430e-02, 2.2236810e-01, 5.4421210e-02, 6.0615010e-01,
 6.1652110e-03, 1.1178080e-02, 6.1063470e-03, 2.0732090e-02, 6.5166930e-02, 4.2233390e-01, 8.3468570e-02, 3.8726160e-01,
 6.7194190e-04, 3.4895890e-02, 1.8766320e-02, 6.7201480e-02, 9.1949550e-02, 2.9174780e-01, 1.0640970e-01, 7.2527510e-01,
 2.5570200e-02, 3.0053120e-02, 1.8026270e-02, 9.7684070e-02, 4.6605410e-02, 1.9579480e-01, 4.2488380e-02, 3.1463580e-01,
 4.4641160e-04, 1.5028450e-02, 8.8740320e-03, 5.0719760e-02, 1.2103710e-01, 2.4895030e-01, 9.9698350e-02, 1.0845910e+00,
 7.3195090e-01, 1.5780240e+00, 4.4256300e-01, 1.9163490e+00, 6.6767040e-01, 5.1452130e+00, 5.2205640e-01, 3.0891350e+00,
 1.6327060e-02, 1.0082380e+00, 2.7836520e-01, 1.2713140e+00, 8.4815370e-01, 3.1999640e+00, 5.9919140e-01, 5.2086510e+00,
 3.2093890e-01, 7.1654970e-01, 1.8644940e-01, 8.6764000e-01, 3.6199120e-01, 2.8888930e+00, 2.7195600e-01, 1.7294070e+00,
 8.4983470e-03, 5.4347770e-01, 1.3921520e-01, 6.8328780e-01, 6.7616260e-01, 2.6418850e+00, 4.5897350e-01, 4.2877200e+00,
 1.1546610e-01, 2.6498920e-01, 1.0275910e-01, 2.9262320e-01, 9.3050940e-01, 7.6331530e+00, 1.0709000e+00, 4.1673230e+00,
 1.5337600e-02, 1.0082180e+00, 3.8489060e-01, 1.1560160e+00, 1.2549600e+00, 5.0401400e+00, 1.3049500e+00, 7.4600620e+00,
 2.4509840e-01, 3.6462850e-01, 1.5525470e-01, 7.0565020e-01, 3.4058830e-01, 1.8111280e+00, 2.7899480e-01, 1.7328490e+00,
 5.2150830e-03, 2.2222590e-01, 9.3149200e-02, 4.4654190e-01, 8.4547100e-01, 2.2011400e+00, 6.2574980e-01, 5.7096010e+00,
 3.6000820e-07, 3.1896460e-06, 2.4786450e-06, 1.0714240e-05, 2.3621080e-06, 7.4806510e-05, 2.1031190e-05, 1.2423120e-04,
 2.2756700e-07, 5.7751440e-05, 4.4179930e-05, 2.0142360e-04, 6.2285210e-06, 9.6572610e-05, 5.0105420e-05, 4.3480240e-04,
 1.9361720e-06, 1.7765050e-05, 1.2808290e-05, 5.9500060e-05, 1.5708220e-05, 5.1517960e-04, 1.3438050e-04, 8.5306560e-04,
 1.4528710e-06, 3.8183230e-04, 2.7101170e-04, 1.3278600e-03, 6.0904970e-05, 9.7794390e-04, 4.7075820e-04, 4.3902000e-03,
 3.3676000e-08, 3.1760890e-07, 3.4126770e-07, 9.7013260e-07, 1.9520640e-06, 6.5807550e-05, 2.5581790e-05, 9.9377200e-05,
 1.2676360e-07, 3.4244430e-05, 3.6222880e-05, 1.0860680e-04, 5.4648220e-06, 9.0195950e-05, 6.4706600e-05, 3.6927060e-04,
 4.6663910e-07, 2.8529200e-06, 3.3658440e-06, 1.5271660e-05, 4.6642050e-06, 1.0192850e-04, 4.3506350e-05, 2.6975220e-04,
 2.8136670e-07, 4.9272490e-05, 5.7226780e-05, 2.7386090e-04, 2.4033630e-05, 2.5713820e-04, 2.0254900e-04, 1.8449420e-03,
 3.6718880e-01, 6.6063090e-01, 2.3348640e-01, 6.8678620e-01, 4.6721380e-01, 3.0046560e+00, 3.8419350e-01, 1.5442940e+00,
 9.3271180e-03, 4.8066270e-01, 1.6723740e-01, 5.1883790e-01, 5.7315280e-01, 1.8045910e+00, 4.2583420e-01, 2.5145530e+00,
 2.9808970e-01, 5.5540360e-01, 1.8212290e-01, 5.7570990e-01, 4.6899550e-01, 3.1234890e+00, 3.7055140e-01, 1.6006910e+00,
 8.9885790e-03, 4.7970710e-01, 1.5485400e-01, 5.1629720e-01, 8.4598800e-01, 2.7584480e+00, 6.0392030e-01, 3.8324720e+00,
 4.6038910e-02, 8.8173190e-02, 4.3089360e-02, 8.3352550e-02, 5.1753230e-01, 3.5428970e+00, 6.2638970e-01, 1.6558210e+00,
 6.9640220e-03, 3.8202790e-01, 1.8378870e-01, 3.7497820e-01, 6.7404530e-01, 2.2591210e+00, 7.3710940e-01, 2.8624710e+00,
 1.8853600e-01, 2.3406800e-01, 1.2559650e-01, 3.8777760e-01, 3.6545140e-01, 1.6217610e+00, 3.1482910e-01, 1.3283120e+00,
 4.5682200e-03, 1.6244940e-01, 8.5811190e-02, 2.7943930e-01, 8.7607430e-01, 1.9033890e+00, 6.8190200e-01, 4.2265650e+00,
 1.1235530e-01, 2.1001890e-01, 6.4530860e-02, 3.3026680e-01, 1.1959990e-01, 7.9910700e-01, 8.8831450e-02, 6.2127550e-01,
 1.8084690e-03, 9.6827600e-02, 2.9288610e-02, 1.5810100e-01, 1.2968090e-01, 4.2420860e-01, 8.7025730e-02, 8.9413970e-01,
 7.9230540e-02, 1.5337320e-01, 4.3723190e-02, 2.4048530e-01, 1.0428580e-01, 7.2159180e-01, 7.4422900e-02, 5.5937520e-01,
 1.5138960e-03, 8.3941430e-02, 2.3557490e-02, 1.3666080e-01, 1.6626890e-01, 5.6325730e-01, 1.0720820e-01, 1.1837640e+00,
 1.1923130e-02, 2.3724490e-02, 1.0079450e-02, 3.3925270e-02, 1.1212780e-01, 7.9749820e-01, 1.2258080e-01, 5.6380470e-01,
 1.1428380e-03, 6.5135050e-02, 2.7242390e-02, 9.6709640e-02, 1.2907900e-01, 4.4947040e-01, 1.2749700e-01, 8.6148280e-01,
 8.3422380e-02, 1.0760330e-01, 5.0195800e-02, 2.6965610e-01, 1.3527850e-01, 6.2370790e-01, 1.0526300e-01, 7.7274910e-01,
 1.2808390e-03, 4.7321780e-02, 2.1731680e-02, 1.2313300e-01, 2.8663580e-01, 6.4701200e-01, 2.0151770e-01, 2.1732830e+00,
 1.3424520e+00, 3.1762740e+00, 6.9279540e-01, 2.9739210e+00, 1.0894890e+00, 9.2140720e+00, 7.2709520e-01, 4.2651620e+00,
 2.6335130e-02, 1.7847530e+00, 3.8322650e-01, 1.7350750e+00, 1.1291580e+00, 4.6753380e+00, 6.8086200e-01, 5.8673720e+00,
 9.3233150e-01, 2.2844510e+00, 4.6229800e-01, 2.1326790e+00, 9.3559940e-01, 8.1942820e+00, 5.9993440e-01, 3.7820500e+00,
 2.1711660e-02, 1.5238000e+00, 3.0356980e-01, 1.4770670e+00, 1.4258130e+00, 6.1138260e+00, 8.2606130e-01, 7.6502570e+00,
 2.0401470e-01, 5.1383390e-01, 1.5496750e-01, 4.3747550e-01, 1.4627550e+00, 1.3168690e+01, 1.4368550e+00, 5.5430160e+00,
 2.3832800e-02, 1.7193320e+00, 5.1046750e-01, 1.5199160e+00, 1.6095350e+00, 7.0941560e+00, 1.4284910e+00, 8.0956370e+00,
 7.3055630e-01, 1.1927550e+00, 3.9497630e-01, 1.7796750e+00, 9.0320610e-01, 5.2710120e+00, 6.3148980e-01, 3.8882660e+00,
 1.3670520e-02, 6.3930200e-01, 2.0840880e-01, 9.9043060e-01, 1.8292600e+00, 5.2265120e+00, 1.1555550e+00, 1.0452510e+01,
 9.5233010e-07, 9.2598780e-06, 5.5963200e-06, 2.3981400e-05, 5.5592850e-06, 1.9321730e-04, 4.2247020e-05, 2.4739330e-04,
 5.2941370e-07, 1.4744710e-04, 8.7725130e-05, 3.9649180e-04, 1.1959790e-05, 2.0350740e-04, 8.2117670e-05, 7.0642940e-04,
 8.1124190e-06, 8.1688380e-05, 4.5804780e-05, 2.1094140e-04, 5.8556780e-05, 2.1076410e-03, 4.2756260e-04, 2.6907340e-03,
 5.3535760e-06, 1.5441070e-03, 8.5235040e-04, 4.1400680e-03, 1.8523490e-04, 3.2641600e-03, 1.2220280e-03, 1.1297760e-02,
 8.5819470e-08, 8.8827120e-07, 7.4229010e-07, 2.0918690e-06, 4.4259180e-06, 1.6374670e-04, 4.9505490e-05, 1.9064880e-04,
 2.8409950e-07, 8.4227450e-05, 6.9290250e-05, 2.0595450e-04, 1.0108930e-05, 1.8310640e-04, 1.0216230e-04, 5.7797860e-04,
 2.0061010e-06, 1.3460110e-05, 1.2350330e-05, 5.5551520e-05, 1.7839930e-05, 4.2785700e-04, 1.4203040e-04, 8.7300850e-04,
 1.0637880e-06, 2.0444400e-04, 1.8466930e-04, 8.7609310e-04, 7.4998830e-05, 8.8062170e-04, 5.3948380e-04, 4.8714230e-03,
 9.5818220e-01, 1.8919310e+00, 5.2003600e-01, 1.5164160e+00, 1.0847220e+00, 7.6557010e+00, 7.6131750e-01, 3.0336860e+00,
 2.1405080e-02, 1.2105910e+00, 3.2757900e-01, 1.0074860e+00, 1.0856570e+00, 3.7513600e+00, 6.8845570e-01, 4.0301490e+00,
 1.2320740e+00, 2.5193370e+00, 6.4249180e-01, 2.0134070e+00, 1.7246570e+00, 1.2605540e+01, 1.1630420e+00, 4.9805740e+00,
 3.2673200e-02, 1.9136580e+00, 4.8043670e-01, 1.5879560e+00, 2.5381530e+00, 9.0825110e+00, 1.5464870e+00, 9.7290530e+00,
 1.1573750e-01, 2.4326140e-01, 9.2455360e-02, 1.7729880e-01, 1.1575250e+00, 8.6963910e+00, 1.1957780e+00, 3.1336060e+00,
 1.5396420e-02, 9.2692010e-01, 3.4681010e-01, 7.0146130e-01, 1.2299900e+00, 4.5241780e+00, 1.1480420e+00, 4.4196880e+00,
 7.9955700e-01, 1.0893940e+00, 4.5461710e-01, 1.3914770e+00, 1.3788870e+00, 6.7154270e+00, 1.0138810e+00, 4.2406980e+00,
 1.7037770e-02, 6.6492340e-01, 2.7316360e-01, 8.8184320e-01, 2.6968680e+00, 6.4303410e+00, 1.7916530e+00, 1.1008910e+01,
 2.5903400e-02, 4.3855770e-02, 1.8621590e-02, 8.8431370e-02, 2.9693900e-02, 1.7969940e-01, 2.7605100e-02, 1.7914260e-01,
 5.3735840e-04, 2.6058980e-02, 1.0892760e-02, 5.4558910e-02, 2.8658380e-02, 8.4910320e-02, 2.4071850e-02, 2.2948770e-01,
 1.8770920e-02, 3.2911510e-02, 1.2965550e-02, 6.6169800e-02, 2.6606730e-02, 1.6674900e-01, 2.3766160e-02, 1.6574780e-01,
 4.6225210e-04, 2.3214770e-02, 9.0032240e-03, 4.8462420e-02, 3.7758670e-02, 1.1585580e-01, 3.0473330e-02, 3.1221160e-01,
 2.6762560e-03, 4.8232490e-03, 2.8317860e-03, 8.8438020e-03, 2.7103430e-02, 1.7460060e-01, 3.7086790e-02, 1.5827700e-01,
 3.3060690e-04, 1.7066610e-02, 9.8641250e-03, 3.2491920e-02, 2.7771890e-02, 8.7590380e-02, 3.4334940e-02, 2.1526580e-01,
 1.8930320e-02, 2.2115980e-02, 1.4257030e-02, 7.1066330e-02, 3.3058070e-02, 1.3804960e-01, 3.2196640e-02, 2.1931360e-01,
 3.7459320e-04, 1.2535210e-02, 7.9550810e-03, 4.1823260e-02, 6.2347410e-02, 1.2746930e-01, 5.4863980e-02, 5.4901280e-01,
 4.5160500e-01, 9.6779500e-01, 2.9170990e-01, 1.1618970e+00, 3.9469010e-01, 3.0233630e+00, 3.2969380e-01, 1.7945160e+00,
 1.1417880e-02, 7.0086330e-01, 2.0796560e-01, 8.7366770e-01, 3.6410580e-01, 1.3654980e+00, 2.7480070e-01, 2.1973260e+00,
 3.2230000e-01, 7.1528170e-01, 2.0003140e-01, 8.5623660e-01, 3.4829980e-01, 2.7629910e+00, 2.7954600e-01, 1.6351920e+00,
 9.6732600e-03, 6.1491210e-01, 1.6928730e-01, 7.6429030e-01, 4.7246020e-01, 1.8349360e+00, 3.4261080e-01, 2.9441290e+00,
 6.6818360e-02, 1.5242720e-01, 6.3527400e-02, 1.6640500e-01, 5.1591650e-01, 4.2068360e+00, 6.3431780e-01, 2.2705560e+00,
 1.0060030e-02, 6.5733900e-01, 2.6969840e-01, 7.4511290e-01, 5.0529800e-01, 2.0172190e+00, 5.6132030e-01, 2.9517280e+00,
 2.4189450e-01, 3.5770830e-01, 1.6369280e-01, 6.8437050e-01, 3.2205690e-01, 1.7023350e+00, 2.8183710e-01, 1.6102000e+00,
 5.8337420e-03, 2.4710040e-01, 1.1131780e-01, 4.9086770e-01, 5.8057780e-01, 1.5024580e+00, 4.5905180e-01, 3.8528650e+00,
 1.5800600e-08, 1.3915430e-07, 1.1621830e-07, 4.6210290e-07, 9.9329490e-08, 3.1268760e-06, 9.4480360e-07, 5.1336410e-06,
 1.1320640e-08, 2.8557310e-06, 2.3479340e-06, 9.8466440e-06, 1.9020520e-07, 2.9314610e-06, 1.6346370e-06, 1.3048050e-05,
 1.3831400e-07, 1.2614830e-06, 9.7749100e-07, 4.1769190e-06, 1.0751430e-06, 3.5050250e-05, 9.8259630e-06, 5.7377060e-05,
 1.1763860e-07, 3.0731820e-05, 2.3442830e-05, 1.0565530e-04, 3.0272700e-06, 4.8317590e-05, 2.4997440e-05, 2.1443670e-04,
 1.3862650e-09, 1.2996050e-08, 1.5007910e-08, 3.9243990e-08, 7.6990490e-08, 2.5799520e-06, 1.0778870e-06, 3.8516440e-06,
 5.9145360e-09, 1.5882140e-06, 1.8055450e-06, 4.9796590e-06, 1.5652290e-07, 2.5679220e-06, 1.9799300e-06, 1.0393530e-05,
 3.2760530e-08, 1.9909130e-07, 2.5244290e-07, 1.0535920e-06, 3.1373630e-07, 6.8151520e-06, 3.1263600e-06, 1.7830700e-05,
 2.2389430e-08, 3.8973350e-06, 4.8648450e-06, 2.1414930e-05, 1.1739930e-06, 1.2485490e-05, 1.0570010e-05, 8.8561500e-05,
 2.1072550e-01, 3.7685960e-01, 1.4314910e-01, 3.8731610e-01, 2.5689800e-01, 1.6422250e+00, 2.2568060e-01, 8.3443260e-01,
 6.0670240e-03, 3.1078600e-01, 1.1621470e-01, 3.3164710e-01, 2.2886240e-01, 7.1626830e-01, 1.8165350e-01, 9.8669060e-01,
 2.7844270e-01, 5.1569210e-01, 1.8174090e-01, 5.2845600e-01, 4.1973470e-01, 2.7786830e+00, 3.5428590e-01, 1.4077640e+00,
 9.5165690e-03, 5.0484540e-01, 1.7515040e-01, 5.3716220e-01, 5.4983110e-01, 1.7820620e+00, 4.1931850e-01, 2.4477120e+00,
 2.4780910e-02, 4.7176080e-02, 2.4777740e-02, 4.4088730e-02, 2.6689910e-01, 1.8161890e+00, 3.4510680e-01, 8.3914960e-01,
 4.2486700e-03, 2.3167590e-01, 1.1978740e-01, 2.2480980e-01, 2.5243970e-01, 8.4100960e-01, 2.9491700e-01, 1.0534790e+00,
 1.7307360e-01, 2.1358540e-01, 1.2317230e-01, 3.4981270e-01, 3.2142770e-01, 1.4178610e+00, 2.9582030e-01, 1.1480750e+00,
 4.7531760e-03, 1.6801500e-01, 9.5385010e-02, 2.8572010e-01, 5.5956890e-01, 1.2084630e+00, 4.6530090e-01, 2.6528730e+00,
 7.3810950e-02, 1.5359920e-01, 4.2735520e-02, 2.6607570e-01, 9.4343600e-02, 7.0176230e-01, 7.0638720e-02, 6.0100610e-01,
 2.1314380e-03, 1.2704690e-01, 3.4798040e-02, 2.2851200e-01, 1.0786920e-01, 3.9282970e-01, 7.2973210e-02, 9.1209450e-01,
 4.2695500e-02, 9.2011580e-02, 2.3751760e-02, 1.5892460e-01, 6.7479100e-02, 5.1980340e-01, 4.8545060e-02, 4.4387460e-01,
 1.4635920e-03, 9.0344910e-02, 2.2958710e-02, 1.6202460e-01, 1.1344750e-01, 4.2785250e-01, 7.3740550e-02, 9.9051690e-01,
 9.4726790e-03, 2.0983740e-02, 8.0726080e-03, 3.3053610e-02, 1.0696720e-01, 8.4697440e-01, 1.1788370e-01, 6.5959720e-01,
 1.6289270e-03, 1.0335590e-01, 3.9143220e-02, 1.6904400e-01, 1.2984710e-01, 5.0336310e-01, 1.2929190e-01, 1.0627630e+00,
 4.3689200e-02, 6.2736530e-02, 2.6500450e-02, 1.7318680e-01, 8.5069680e-02, 4.3664720e-01, 6.6729240e-02, 5.9593320e-01,
 1.2034290e-03, 4.9498310e-02, 2.0583230e-02, 1.4187740e-01, 1.9007120e-01, 4.7764090e-01, 1.3470800e-01, 1.7673190e+00,
 1.6162610e+00, 4.2572990e+00, 8.4083760e-01, 4.3909160e+00, 1.5750350e+00, 1.4829360e+01, 1.0596270e+00, 7.5616370e+00,
 5.6883020e-02, 4.2916940e+00, 8.3444380e-01, 4.5959820e+00, 1.7213210e+00, 7.9345720e+00, 1.0463100e+00, 1.0968910e+01,
 9.2075790e-01, 2.5116570e+00, 4.6024760e-01, 2.5829360e+00, 1.1094800e+00, 1.0817920e+01, 7.1717930e-01, 5.5000900e+00,
 3.8468270e-02, 3.0056670e+00, 5.4220370e-01, 3.2093920e+00, 1.7829210e+00, 8.5111030e+00, 1.0413000e+00, 1.1731630e+01,
 2.9705000e-01, 8.3290280e-01, 2.2745900e-01, 7.8115090e-01, 2.5573750e+00, 2.5631180e+01, 2.5323870e+00, 1.1884530e+01,
 6.2255510e-02, 4.9999520e+00, 1.3442040e+00, 4.8689480e+00, 2.9673110e+00, 1.4560180e+01, 2.6548160e+00, 1.8303180e+01,
 7.0118200e-01, 1.2744760e+00, 3.8215750e-01, 2.0947430e+00, 1.0409230e+00, 6.7628380e+00, 7.3365570e-01, 5.4954150e+00,
 2.3539460e-02, 1.2255220e+00, 3.6176120e-01, 2.0914550e+00, 2.2230380e+00, 7.0710960e+00, 1.4156520e+00, 1.5577760e+01,
 1.0641700e-05, 1.1519460e-04, 6.3040620e-05, 3.2863290e-04, 7.4592810e-05, 2.8862080e-03, 5.7143720e-04, 4.0707930e-03,
 1.0613370e-05, 3.2907710e-03, 1.7728680e-03, 9.7477660e-03, 1.6921600e-04, 3.2055420e-03, 1.1712480e-03, 1.2257430e-02,
 7.4359460e-05, 8.3358440e-04, 4.2324420e-04, 2.3711590e-03, 6.4449210e-04, 2.5825010e-02, 4.7438890e-03, 3.6318190e-02,
 8.8036810e-05, 2.8268380e-02, 1.4129700e-02, 8.3491220e-02, 2.1498240e-03, 4.2175000e-02, 1.4297350e-02, 1.6079980e-01,
 1.1597510e-06, 1.3363740e-05, 1.0112230e-05, 3.4667820e-05, 7.1818590e-05, 2.9580780e-03, 8.0980650e-04, 3.7938540e-03,
 6.8878540e-06, 2.2733720e-03, 1.6934790e-03, 6.1234700e-03, 1.7297300e-04, 3.4880310e-03, 1.7622130e-03, 1.2128250e-02,
 1.7870660e-05, 1.3348730e-04, 1.1090750e-04, 6.0687160e-04, 1.9082510e-04, 5.0950030e-03, 1.5315040e-03, 1.1451800e-02,
 1.7001110e-05, 3.6374750e-03, 2.9751670e-03, 1.7170600e-02, 8.4593430e-04, 1.1057960e-02, 6.1341570e-03, 6.7383100e-02,
 7.1261390e-01, 1.5664440e+00, 3.8988270e-01, 1.3830490e+00, 9.6867720e-01, 7.6111290e+00, 6.8536340e-01, 3.3223420e+00,
 2.8559960e-02, 1.7982140e+00, 4.4060660e-01, 1.6485140e+00, 1.0223350e+00, 3.9327170e+00, 6.5353800e-01, 4.6540870e+00,
 7.5163230e-01, 1.7110320e+00, 3.9512140e-01, 1.5063060e+00, 1.2633560e+00, 1.0279880e+01, 8.5884130e-01, 4.4742010e+00,
 3.5759760e-02, 2.3316900e+00, 5.3007030e-01, 2.1313480e+00, 1.9605620e+00, 7.8103800e+00, 1.2042140e+00, 9.2160830e+00,
 1.0409640e-01, 2.4357810e-01, 8.3827810e-02, 1.9556020e-01, 1.2501050e+00, 1.0455830e+01, 1.3018510e+00, 4.1502430e+00,
 2.4843670e-02, 1.6651060e+00, 5.6413380e-01, 1.3880740e+00, 1.4007400e+00, 5.7358660e+00, 1.3179770e+00, 6.1724920e+00,
 4.7404540e-01, 7.1904950e-01, 2.7171310e-01, 1.0117180e+00, 9.8164350e-01, 5.3223340e+00, 7.2762330e-01, 3.7023320e+00,
 1.8122490e-02, 7.8737200e-01, 2.9290190e-01, 1.1502950e+00, 2.0245310e+00, 5.3740560e+00, 1.3558540e+00, 1.0134960e+01,
 9.7434100e-02, 1.6595410e-01, 6.5564950e-02, 3.3848880e-01, 1.0523920e-01, 6.4071370e-01, 9.1579920e-02, 6.4608970e-01,
 2.9059620e-03, 1.4177200e-01, 5.5139690e-02, 3.0024460e-01, 1.7658800e-01, 5.2635320e-01, 1.3884170e-01, 1.4389730e+00,
 3.8008760e-02, 6.7042940e-02, 2.4574790e-02, 1.3634580e-01, 5.0762800e-02, 3.2005480e-01, 4.2443760e-02, 3.2179970e-01,
 1.3457010e-03, 6.7989410e-02, 2.4534000e-02, 1.4356830e-01, 1.2524780e-01, 3.8661470e-01, 9.4618090e-02, 1.0538680e+00,
 9.3651150e-03, 1.6979790e-02, 9.2757000e-03, 3.1492580e-02, 8.9364640e-02, 5.7915440e-01, 1.1446200e-01, 5.3105910e-01,
 1.6632940e-03, 8.6379670e-02, 4.6453280e-02, 1.6634740e-01, 1.5920120e-01, 5.0513150e-01, 1.8423740e-01, 1.2557400e+00,
 3.5221830e-02, 4.1396850e-02, 2.4830390e-02, 1.3455550e-01, 5.7954520e-02, 2.4347380e-01, 5.2834940e-02, 3.9125430e-01,
 1.0020410e-03, 3.3733710e-02, 1.9919150e-02, 1.1384840e-01, 1.9003240e-01, 3.9086070e-01, 1.5652990e-01, 1.7028470e+00,
 1.0216870e+00, 2.2026710e+00, 6.1774770e-01, 2.6749190e+00, 8.4133970e-01, 6.4835450e+00, 6.5784970e-01, 3.8926570e+00,
 3.7137800e-02, 2.2933550e+00, 6.3317400e-01, 2.8917500e+00, 1.3494050e+00, 5.0911130e+00, 9.5330790e-01, 8.2869150e+00,
 3.9252140e-01, 8.7636960e-01, 2.2803520e-01, 1.0611590e+00, 3.9967980e-01, 3.1896690e+00, 3.0027070e-01, 1.9094640e+00,
 1.6937430e-02, 1.0831650e+00, 2.7745960e-01, 1.3618110e+00, 9.4259190e-01, 3.6828710e+00, 6.3982340e-01, 5.9772170e+00,
 1.4063270e-01, 3.2274540e-01, 1.2515620e-01, 3.5640240e-01, 1.0231180e+00, 8.3928420e+00, 1.1774810e+00, 4.5820760e+00,
 3.0441170e-02, 2.0010530e+00, 7.6390820e-01, 2.2943930e+00, 1.7421820e+00, 6.9969060e+00, 1.8115790e+00, 1.0356330e+01,
 2.7069790e-01, 4.0271240e-01, 1.7147040e-01, 7.7935240e-01, 3.3958410e-01, 1.8057880e+00, 2.7817220e-01, 1.7277400e+00,
 9.3859380e-03, 3.9995490e-01, 1.6764690e-01, 8.0367160e-01, 1.0643260e+00, 2.7709170e+00, 7.8772880e-01, 7.1875640e+00,
 8.9379450e-06, 7.9189540e-05, 6.1537460e-05, 2.6600300e-04, 5.2941750e-05, 1.6766330e-03, 4.7137040e-04, 2.7843850e-03,
 9.2067580e-06, 2.3364700e-03, 1.7874030e-03, 8.1490630e-03, 1.7625520e-04, 2.7328190e-03, 1.4178870e-03, 1.2304070e-02,
 4.2118630e-05, 3.8645290e-04, 2.7862590e-04, 1.2943380e-03, 3.0848240e-04, 1.0117240e-02, 2.6390020e-03, 1.6752740e-02,
 5.1502610e-05, 1.3535520e-02, 9.6070550e-03, 4.7071140e-02, 1.5101310e-03, 2.4247990e-02, 1.1672390e-02, 1.0885440e-01,
 7.2952730e-07, 6.8804010e-06, 7.3929240e-06, 2.1016100e-05, 3.8175820e-05, 1.2869750e-03, 5.0029390e-04, 1.9434850e-03,
 4.4749440e-06, 1.2088800e-03, 1.2787220e-03, 3.8339840e-03, 1.3493630e-04, 2.2271000e-03, 1.5977220e-03, 9.1179550e-03,
 9.1667370e-06, 5.6043240e-05, 6.6119210e-05, 2.9999910e-04, 8.2715040e-05, 1.8076000e-03, 7.7154180e-04, 4.7837870e-03,
 9.0069640e-06, 1.5772850e-03, 1.8319140e-03, 8.7666910e-03, 5.3812670e-04, 5.7574720e-03, 4.5351880e-03, 4.1309300e-02,
 4.7152570e-01, 8.4834970e-01, 2.9983170e-01, 8.8193700e-01, 5.4163270e-01, 3.4832440e+00, 4.4538870e-01, 1.7902730e+00,
 1.9518010e-02, 1.0058390e+00, 3.4996250e-01, 1.0857250e+00, 8.3891520e-01, 2.6413530e+00, 6.2328710e-01, 3.6805130e+00,
 3.3540370e-01, 6.2492750e-01, 2.0492050e-01, 6.4777570e-01, 4.7639030e-01, 3.1727370e+00, 3.7639390e-01, 1.6259290e+00,
 1.6481020e-02, 8.7956740e-01, 2.8393270e-01, 9.4665730e-01, 1.0849680e+00, 3.5376700e+00, 7.7451920e-01, 4.9150910e+00,
 5.1586590e-02, 9.8798060e-02, 4.8281620e-02, 9.3396520e-02, 5.2350700e-01, 3.5837980e+00, 6.3362120e-01, 1.6749370e+00,
 1.2715810e-02, 6.9755580e-01, 3.3558520e-01, 6.8468360e-01, 8.6085990e-01, 2.8852460e+00, 9.4140250e-01, 3.6558170e+00,
 1.9156610e-01, 2.3782990e-01, 1.2761500e-01, 3.9400990e-01, 3.3521790e-01, 1.4875940e+00, 2.8878360e-01, 1.2184220e+00,
 7.5638590e-03, 2.6897670e-01, 1.4208240e-01, 4.6268340e-01, 1.0146050e+00, 2.2043660e+00, 7.8972870e-01, 4.8948960e+00,
 3.8099880e-01, 7.1217750e-01, 2.1882520e-01, 1.1199400e+00, 3.6612880e-01, 2.4462910e+00, 2.7193800e-01, 1.9018990e+00,
 9.9933960e-03, 5.3505840e-01, 1.6184550e-01, 8.7364800e-01, 5.0123040e-01, 1.6396120e+00, 3.3636380e-01, 3.4559460e+00,
 2.3541140e-01, 4.5570570e-01, 1.2991120e-01, 7.1453490e-01, 2.7972630e-01, 1.9355290e+00, 1.9962490e-01, 1.5004150e+00,
 7.3299840e-03, 4.0642770e-01, 1.1406070e-01, 6.6168450e-01, 5.6308970e-01, 1.9075390e+00, 3.6307360e-01, 4.0089580e+00,
 3.5278970e-02, 7.0197670e-02, 2.9823780e-02, 1.0038040e-01, 2.9951080e-01, 2.1302410e+00, 3.2743210e-01, 1.5060090e+00,
 5.5103920e-03, 3.1406000e-01, 1.3135390e-01, 4.6630230e-01, 4.3532420e-01, 1.5158580e+00, 4.2998900e-01, 2.9053870e+00,
 2.2383130e-01, 2.8871140e-01, 1.3468080e-01, 7.2351670e-01, 3.2767270e-01, 1.5107510e+00, 2.5496890e-01, 1.8717600e+00,
 5.6002190e-03, 2.0690520e-01, 9.5017510e-02, 5.3837480e-01, 8.7659780e-01, 1.9787100e+00, 6.1628710e-01, 6.6463950e+00,
 3.6500200e+00, 8.6360390e+00, 1.8836560e+00, 8.0858550e+00, 2.6741920e+00, 2.2616290e+01, 1.7846830e+00, 1.0469000e+01,
 1.1668210e-01, 7.9076370e+00, 1.6979470e+00, 7.6875290e+00, 3.4993150e+00, 1.4489090e+01, 2.1100230e+00, 1.8183260e+01,
 2.2211190e+00, 5.4423110e+00, 1.1013450e+00, 5.0807410e+00, 2.0121700e+00, 1.7623240e+01, 1.2902640e+00, 8.1339580e+00,
 8.4288180e-02, 5.9156370e+00, 1.1785070e+00, 5.7342140e+00, 3.8716480e+00, 1.6601460e+01, 2.2430830e+00, 2.0773470e+01,
 4.8400930e-01, 1.2190320e+00, 3.6764860e-01, 1.0378780e+00, 3.1328330e+00, 2.8203830e+01, 3.0773620e+00, 1.1871670e+01,
 9.2138170e-02, 6.6469790e+00, 1.9734790e+00, 5.8760300e+00, 4.3523570e+00, 1.9183360e+01, 3.8627940e+00, 2.1891470e+01,
 1.5716600e+00, 2.5659980e+00, 8.4972020e-01, 3.8286500e+00, 1.7541430e+00, 1.0236990e+01, 1.2264350e+00, 7.5515150e+00,
 4.7925000e-02, 2.2412130e+00, 7.3062270e-01, 3.4721710e+00, 4.4855120e+00, 1.2815880e+01, 2.8335260e+00, 2.5630500e+01,
 4.6054640e-05, 4.4780720e-04, 2.7063780e-04, 1.1597390e-03, 2.4270460e-04, 8.4353900e-03, 1.8444000e-03, 1.0800580e-02,
 4.1720840e-05, 1.1619680e-02, 6.9132440e-03, 3.1245830e-02, 6.5923630e-04, 1.1217540e-02, 4.5264120e-03, 3.8939120e-02,
 3.4374880e-04, 3.4613940e-03, 1.9408930e-03, 8.9382530e-03, 2.2399650e-03, 8.0623310e-02, 1.6355500e-02, 1.0292830e-01,
 3.6966370e-04, 1.0662040e-01, 5.8854680e-02, 2.8587120e-01, 8.9463330e-03, 1.5765000e-01, 5.9020570e-02, 5.4565060e-01,
 3.6213250e-06, 3.7482390e-05, 3.1322420e-05, 8.8270610e-05, 1.6860030e-04, 6.2377430e-03, 1.8858550e-03, 7.2625480e-03,
 1.9535490e-05, 5.7917170e-03, 4.7645930e-03, 1.4162010e-02, 4.8620370e-04, 8.8067740e-03, 4.9136470e-03, 2.7798730e-02,
 7.6762110e-05, 5.1504240e-04, 4.7257740e-04, 2.1256420e-03, 6.1625520e-04, 1.4779720e-02, 4.9062390e-03, 3.0156850e-02,
 6.6331720e-05, 1.2747960e-02, 1.1514920e-02, 5.4628150e-02, 3.2709980e-03, 3.8407420e-02, 2.3529040e-02, 2.1246220e-01,
 2.3967610e+00, 4.7324040e+00, 1.3007980e+00, 3.7931050e+00, 2.4494470e+00, 1.7287600e+01, 1.7191570e+00, 6.8504700e+00,
 8.7250010e-02, 4.9345320e+00, 1.3352560e+00, 4.1066500e+00, 3.0952870e+00, 1.0695400e+01, 1.9628360e+00, 1.1490240e+01,
 2.7003400e+00, 5.5216350e+00, 1.4081510e+00, 4.4127890e+00, 3.4123800e+00, 2.4941130e+01, 2.3011780e+00, 9.8544900e+00,
 1.1669310e-01, 6.8346760e+00, 1.7158910e+00, 5.6714220e+00, 6.3406070e+00, 2.2689190e+01, 3.8633090e+00, 2.4304330e+01,
 2.5260750e-01, 5.3094010e-01, 2.0179220e-01, 3.8697080e-01, 2.2807410e+00, 1.7135020e+01, 2.3561140e+00, 6.1743320e+00,
 5.4760090e-02, 3.2967550e+00, 1.2334910e+00, 2.4948710e+00, 3.0598880e+00, 1.1254950e+01, 2.8560220e+00, 1.0995010e+01,
 1.5824660e+00, 2.1561040e+00, 8.9976820e-01, 2.7539800e+00, 2.4636950e+00, 1.1998630e+01, 1.8115290e+00, 7.5769680e+00,
 5.4950270e-02, 2.1445130e+00, 8.8100810e-01, 2.8441230e+00, 6.0838180e+00, 1.4506100e+01, 4.0417590e+00, 2.4834810e+01,
 5.3924620e-02, 9.1297130e-02, 3.8765650e-02, 1.8409280e-01, 5.5804700e-02, 3.3771500e-01, 5.1879160e-02, 3.3666850e-01,
 1.8229150e-03, 8.8401540e-02, 3.6952200e-02, 1.8508370e-01, 6.8000730e-02, 2.0147560e-01, 5.7117800e-02, 5.4452940e-01,
 3.4238990e-02, 6.0032050e-02, 2.3649740e-02, 1.2069660e-01, 4.3812710e-02, 2.7458180e-01, 3.9135210e-02, 2.7293320e-01,
 1.3739990e-03, 6.9003620e-02, 2.6761190e-02, 1.4404970e-01, 7.8502520e-02, 2.4087110e-01, 6.3355870e-02, 6.4910640e-01,
 4.8613160e-03, 8.7612470e-03, 5.1438310e-03, 1.6064430e-02, 4.4445080e-02, 2.8631580e-01, 6.0816120e-02, 2.5954770e-01,
 9.7861130e-04, 5.0517940e-02, 2.9198250e-02, 9.6177530e-02, 5.7499400e-02, 1.8134860e-01, 7.1087630e-02, 4.4568990e-01,
 3.1181480e-02, 3.6428810e-02, 2.3483760e-02, 1.1705840e-01, 4.9157460e-02, 2.0528030e-01, 4.7876520e-02, 3.2612010e-01,
 1.0054740e-03, 3.3646690e-02, 2.1352830e-02, 1.1226090e-01, 1.1705470e-01, 2.3931830e-01, 1.0300480e-01, 1.0307490e+00,
 7.5379940e-01, 1.6154010e+00, 4.8690950e-01, 1.9393880e+00, 5.9473900e-01, 4.5557570e+00, 4.9679940e-01, 2.7040670e+00,
 3.1056630e-02, 1.9063490e+00, 5.6566670e-01, 2.3763770e+00, 6.9271750e-01, 2.5978830e+00, 5.2281310e-01, 4.1804510e+00,
 4.7137040e-01, 1.0461140e+00, 2.9255000e-01, 1.2522640e+00, 4.5986290e-01, 3.6479990e+00, 3.6908670e-01, 2.1589570e+00,
 2.3054030e-02, 1.4655040e+00, 4.0345810e-01, 1.8215130e+00, 7.8758750e-01, 3.0588240e+00, 5.7112940e-01, 4.9078400e+00,
 9.7316980e-02, 2.2200120e-01, 9.2523900e-02, 2.4235910e-01, 6.7833690e-01, 5.5312280e+00, 8.3401320e-01, 2.9853700e+00,
 2.3876150e-02, 1.5601070e+00, 6.4009340e-01, 1.7684260e+00, 8.3882620e-01, 3.3487100e+00, 9.3182670e-01, 4.9000530e+00,
 3.1947100e-01, 4.7242660e-01, 2.1618960e-01, 9.0385070e-01, 3.8398230e-01, 2.0296610e+00, 3.3602900e-01, 1.9198110e+00,
 1.2555230e-02, 5.3180320e-01, 2.3957520e-01, 1.0564330e+00, 8.7397180e-01, 2.2617220e+00, 6.9103290e-01, 5.7999030e+00,
 4.6909390e-07, 4.1312630e-06, 3.4503320e-06, 1.3719080e-05, 2.6621820e-06, 8.3805050e-05, 2.5322180e-05, 1.3758940e-04,
 5.4768310e-07, 1.3815790e-04, 1.1359110e-04, 4.7637240e-04, 6.4363570e-06, 9.9197800e-05, 5.5314530e-05, 4.4153330e-04,
 3.5979690e-06, 3.2815020e-05, 2.5427520e-05, 1.0865440e-04, 2.5248230e-05, 8.2310560e-04, 2.3074890e-04, 1.3474190e-03,
 4.9866970e-06, 1.3027210e-03, 9.9374120e-04, 4.4787290e-03, 8.9758180e-05, 1.4326100e-03, 7.4117100e-04, 6.3580200e-03,
 3.5911060e-08, 3.3666140e-07, 3.8877850e-07, 1.0166120e-06, 1.8004970e-06, 6.0334670e-05, 2.5207430e-05, 9.0074410e-05,
 2.4967490e-07, 6.7044510e-05, 7.6218880e-05, 2.1021020e-04, 4.6215920e-06, 7.5822060e-05, 5.8460630e-05, 3.0688570e-04,
 7.6956560e-07, 4.6767800e-06, 5.9300420e-06, 2.4749540e-05, 6.6532310e-06, 1.4452510e-04, 6.6298990e-05, 3.7812570e-04,
 8.5705710e-07, 1.4918820e-04, 1.8622400e-04, 8.1975360e-04, 3.1433420e-05, 3.3429650e-04, 2.8300990e-04, 2.3712170e-03,
 3.2358930e-01, 5.7870410e-01, 2.1981920e-01, 5.9476120e-01, 3.5613190e-01, 2.2765800e+00, 3.1285600e-01, 1.1567550e+00,
 1.5181850e-02, 7.7769730e-01, 2.9081050e-01, 8.2989910e-01, 4.0057420e-01, 1.2536730e+00, 3.1794520e-01, 1.7269890e+00,
 3.7464310e-01, 6.9386090e-01, 2.4453140e-01, 7.1103470e-01, 5.0983540e-01, 3.3751580e+00, 4.3033730e-01, 1.7099570e+00,
 2.0865770e-02, 1.1069100e+00, 3.8402990e-01, 1.1777670e+00, 8.4322370e-01, 2.7329790e+00, 6.4306890e-01, 3.7538240e+00,
 3.3203980e-02, 6.3211290e-02, 3.3199720e-02, 5.9074540e-02, 3.2284430e-01, 2.1968840e+00, 4.1744530e-01, 1.0150450e+00,
 9.2767920e-03, 5.0585450e-01, 2.6155070e-01, 4.9086270e-01, 3.8553340e-01, 1.2844150e+00, 4.5040600e-01, 1.6089050e+00,
 2.1028880e-01, 2.5951160e-01, 1.4965750e-01, 4.2503130e-01, 3.5256720e-01, 1.5552210e+00, 3.2447900e-01, 1.2592990e+00,
 9.4111210e-03, 3.3266370e-01, 1.8885900e-01, 5.6571560e-01, 7.7494440e-01, 1.6735940e+00, 6.4439310e-01, 3.6739520e+00,
 4.6962010e-02, 9.7727060e-02, 2.7190360e-02, 1.6928990e-01, 5.3776350e-02, 4.0000820e-01, 4.0264450e-02, 3.4257670e-01,
 7.5523210e-04, 4.5016520e-02, 1.2329980e-02, 8.0968630e-02, 6.3145260e-02, 2.2995760e-01, 4.2717610e-02, 5.3392870e-01,
 2.2668170e-02, 4.8851380e-02, 1.2610440e-02, 8.4377250e-02, 3.2096420e-02, 2.4724430e-01, 2.3090450e-02, 2.1112880e-01,
 4.3274910e-04, 2.6712830e-02, 6.7883390e-03, 4.7906790e-02, 5.5417470e-02, 2.0899980e-01, 3.6021200e-02, 4.8385330e-01,
 6.5309150e-03, 1.4467190e-02, 5.5656400e-03, 2.2788730e-02, 6.6070070e-02, 5.2314780e-01, 7.2812850e-02, 4.0741120e-01,
 6.2543870e-04, 3.9684260e-02, 1.5029330e-02, 6.4905700e-02, 8.2366580e-02, 3.1930090e-01, 8.2014380e-02, 6.7414800e-01,
 3.3732790e-02, 4.8439400e-02, 2.0461220e-02, 1.3371900e-01, 5.8844510e-02, 3.0203820e-01, 4.6158040e-02, 4.1221970e-01,
 5.1746460e-04, 2.1283860e-02, 8.8506180e-03, 6.1006110e-02, 1.3502430e-01, 3.3931050e-01, 9.5694960e-02, 1.2554830e+00,
 8.8672800e-01, 2.3356790e+00, 4.6130810e-01, 2.4089850e+00, 7.7414440e-01, 7.2887690e+00, 5.2081660e-01, 3.7166160e+00,
 1.7379750e-02, 1.3112620e+00, 2.5495170e-01, 1.4042330e+00, 8.6887720e-01, 4.0051610e+00, 5.2814960e-01, 5.5368170e+00,
 4.2153420e-01, 1.1498670e+00, 2.1070700e-01, 1.1825000e+00, 4.5505080e-01, 4.4369470e+00, 2.9414950e-01, 2.2558500e+00,
 9.8078040e-03, 7.6631980e-01, 1.3823930e-01, 8.1826130e-01, 7.5099490e-01, 3.5850130e+00, 4.3861240e-01, 4.9415510e+00,
 1.7659720e-01, 4.9516350e-01, 1.3522510e-01, 4.6439680e-01, 1.3620770e+00, 1.3651360e+01, 1.3487680e+00, 6.3297860e+00,
 2.0611700e-02, 1.6553960e+00, 4.4504210e-01, 1.6120230e+00, 1.6230610e+00, 7.9641310e+00, 1.4521320e+00, 1.0011480e+01,
 4.6683360e-01, 8.4852200e-01, 2.5443320e-01, 1.3946400e+00, 6.2087290e-01, 4.0337890e+00, 4.3759920e-01, 3.2778170e+00,
 8.7278980e-03, 4.5439550e-01, 1.3413280e-01, 7.7546400e-01, 1.3617440e+00, 4.3314720e+00, 8.6717180e-01, 9.5423140e+00,
 2.2436390e-05, 2.4287010e-04, 1.3291140e-04, 6.9287180e-04, 1.4089380e-04, 5.4515800e-03, 1.0793530e-03, 7.6890700e-03,
 1.2461690e-05, 3.8638590e-03, 2.0816130e-03, 1.1445340e-02, 3.2824710e-04, 6.2181460e-03, 2.2719990e-03, 2.3777100e-02,
 1.3082370e-04, 1.4665600e-03, 7.4463130e-04, 4.1716800e-03, 1.0158300e-03, 4.0704610e-02, 7.4771780e-03, 5.7243660e-02,
 8.6257400e-05, 2.7697020e-02, 1.3844110e-02, 8.1803680e-02, 3.4799310e-03, 6.8268890e-02, 2.3143190e-02, 2.6028740e-01,
 2.6496100e-06, 3.0531290e-05, 2.3102780e-05, 7.9203360e-05, 1.4699650e-04, 6.0545190e-03, 1.6574920e-03, 7.7651660e-03,
 8.7636060e-06, 2.8924730e-03, 2.1546610e-03, 7.7910600e-03, 3.6359080e-04, 7.3318730e-03, 3.7041880e-03, 2.5493690e-02,
 4.5723000e-05, 3.4153420e-04, 2.8376260e-04, 1.5527120e-03, 4.3740390e-04, 1.1678620e-02, 3.5104690e-03, 2.6249500e-02,
 2.4224410e-05, 5.1829380e-03, 4.2392340e-03, 2.4465920e-02, 1.9913530e-03, 2.6030750e-02, 1.4439980e-02, 1.5862170e-01,
 5.7646550e-01, 1.2671670e+00, 3.1539370e-01, 1.1188110e+00, 7.0202260e-01, 5.5159600e+00, 4.9669860e-01, 2.4077770e+00,
 1.2866440e-02, 8.1010680e-01, 1.9849600e-01, 7.4266610e-01, 7.6090390e-01, 2.9270440e+00, 4.8641550e-01, 3.4639460e+00,
 5.0737950e-01, 1.1550100e+00, 2.6672150e-01, 1.0168120e+00, 7.6402240e-01, 6.2168200e+00, 5.1938970e-01, 2.7058010e+00,
 1.3443240e-02, 8.7655660e-01, 1.9927040e-01, 8.0124190e-01, 1.2176590e+00, 4.8508420e+00, 7.4790850e-01, 5.7238910e+00,
 9.1249380e-02, 2.1351700e-01, 7.3482250e-02, 1.7142530e-01, 9.8173400e-01, 8.2111860e+00, 1.0223710e+00, 3.2592740e+00,
 1.2128080e-02, 8.1286400e-01, 2.7539640e-01, 6.7762420e-01, 1.1297160e+00, 4.6260550e+00, 1.0629670e+00, 4.9782000e+00,
 4.6536240e-01, 7.0587880e-01, 2.6673620e-01, 9.9318650e-01, 8.6333250e-01, 4.6808680e+00, 6.3992770e-01, 3.2561150e+00,
 9.9076570e-03, 4.3046030e-01, 1.6013100e-01, 6.2887230e-01, 1.8285780e+00, 4.8539030e+00, 1.2246220e+00, 9.1540010e+00,
 6.4310860e-02, 1.0953720e-01, 4.3275800e-02, 2.2341780e-01, 6.2230560e-02, 3.7887010e-01, 5.4153510e-02, 3.8204910e-01,
 1.0681810e-03, 5.2112930e-02, 2.0268400e-02, 1.1036480e-01, 1.0723880e-01, 3.1964520e-01, 8.4316150e-02, 8.7386350e-01,
 2.0934640e-02, 3.6926220e-02, 1.3535420e-02, 7.5097140e-02, 2.5048420e-02, 1.5792800e-01, 2.0943470e-02, 1.5878900e-01,
 4.1277380e-04, 2.0854740e-02, 7.5254420e-03, 4.4037440e-02, 6.3470140e-02, 1.9591950e-01, 4.7948320e-02, 5.3405430e-01,
 6.6982560e-03, 1.2144540e-02, 6.6343030e-03, 2.2524590e-02, 5.7262100e-02, 3.7110430e-01, 7.3343730e-02, 3.4028630e-01,
 6.6252070e-04, 3.4406620e-02, 1.8503200e-02, 6.6259250e-02, 1.0476410e-01, 3.3240730e-01, 1.2123950e-01, 8.2635320e-01,
 2.8212240e-02, 3.3158350e-02, 1.9888830e-02, 1.0777730e-01, 4.1587800e-02, 1.7471530e-01, 3.7914020e-02, 2.8076160e-01,
 4.4698490e-04, 1.5047750e-02, 8.8854270e-03, 5.0784890e-02, 1.4004610e-01, 2.8804820e-01, 1.1535610e-01, 1.2549280e+00,
 5.8149290e-01, 1.2536490e+00, 3.5159080e-01, 1.5224290e+00, 4.2899350e-01, 3.3059170e+00, 3.3543320e-01, 1.9848400e+00,
 1.1771300e-02, 7.2690790e-01, 2.0069260e-01, 9.1657710e-01, 7.0662030e-01, 2.6659790e+00, 4.9920290e-01, 4.3394710e+00,
 1.8642240e-01, 4.1621920e-01, 1.0830210e-01, 5.0398240e-01, 1.7005910e-01, 1.3571670e+00, 1.2776170e-01, 8.1245490e-01,
 4.4798570e-03, 2.8649130e-01, 7.3386540e-02, 3.6019140e-01, 4.1188510e-01, 1.6093070e+00, 2.7958410e-01, 2.6118690e+00,
 8.6733710e-02, 1.9904980e-01, 7.7188740e-02, 2.1980740e-01, 5.6530190e-01, 4.6372840e+00, 6.5059180e-01, 2.5317270e+00,
 1.0455500e-02, 6.8729310e-01, 2.6237630e-01, 7.8804540e-01, 9.8858180e-01, 3.9703170e+00, 1.0279610e+00, 5.8765860e+00,
 1.8696640e-01, 2.7814650e-01, 1.1843170e-01, 5.3828540e-01, 2.1012560e-01, 1.1173740e+00, 1.7212550e-01, 1.0690800e+00,
 3.6102580e-03, 1.5384080e-01, 6.4484620e-02, 3.0912860e-01, 6.7634910e-01, 1.7608400e+00, 5.0057940e-01, 4.5674940e+00,
 1.9549110e-05, 1.7320370e-04, 1.3459500e-04, 5.8180290e-04, 1.0373860e-04, 3.2853390e-03, 9.2364390e-04, 5.4559650e-03,
 1.1214450e-05, 2.8459760e-03, 2.1771760e-03, 9.9261020e-03, 3.5468980e-04, 5.4994300e-03, 2.8533060e-03, 2.4760290e-02,
 7.6872660e-05, 7.0533310e-04, 5.0853310e-04, 2.3623560e-03, 5.0440690e-04, 1.6542940e-02, 4.3150950e-03, 2.7392810e-02,
 5.2349040e-05, 1.3757970e-02, 9.7649450e-03, 4.7844740e-02, 2.5358860e-03, 4.0718430e-02, 1.9600850e-02, 1.8279370e-01,
 1.7290440e-06, 1.6307160e-05, 1.7521890e-05, 4.9810030e-05, 8.1059870e-05, 2.7326720e-03, 1.0622890e-03, 4.1266590e-03,
 5.9065510e-06, 1.5956200e-03, 1.6878060e-03, 5.0605370e-03, 2.9424610e-04, 4.8564820e-03, 3.4840420e-03, 1.9882890e-02,
 2.4330800e-05, 1.4875270e-04, 1.7549680e-04, 7.9627230e-04, 1.9668850e-04, 4.2983020e-03, 1.8346530e-03, 1.1375390e-02,
 1.3313790e-05, 2.3314900e-03, 2.7078740e-03, 1.2958630e-02, 1.3141460e-03, 1.4060180e-02, 1.1075270e-02, 1.0088040e-01,
 3.9570530e-01, 7.1193670e-01, 2.5161930e-01, 7.4012320e-01, 4.0721550e-01, 2.6188060e+00, 3.3485640e-01, 1.3459800e+00,
 9.1218690e-03, 4.7008540e-01, 1.6355720e-01, 5.0742050e-01, 6.4774200e-01, 2.0394380e+00, 4.8125150e-01, 2.8417920e+00,
 2.3487820e-01, 4.3762740e-01, 1.4350280e-01, 4.5362760e-01, 2.9887580e-01, 1.9904990e+00, 2.3614050e-01, 1.0200690e+00,
 6.4274800e-03, 3.4302510e-01, 1.1073170e-01, 3.6918960e-01, 6.9905150e-01, 2.2793430e+00, 4.9902760e-01, 3.1668240e+00,
 4.6911420e-02, 8.9844220e-02, 4.3905970e-02, 8.4932220e-02, 4.2649820e-01, 2.9197000e+00, 5.1620760e-01, 1.3645620e+00,
 6.4397280e-03, 3.5326650e-01, 1.6995200e-01, 3.4674760e-01, 7.2026400e-01, 2.4140270e+00, 7.8765250e-01, 3.0587480e+00,
 1.9509110e-01, 2.4220620e-01, 1.2996330e-01, 4.0126010e-01, 3.0584330e-01, 1.3572390e+00, 2.6347790e-01, 1.1116540e+00,
 4.2898690e-03, 1.5255110e-01, 8.0582540e-02, 2.6241250e-01, 9.5067750e-01, 2.0654750e+00, 7.3997020e-01, 4.5864830e+00,
 2.8297150e-01, 5.2894130e-01, 1.6252370e-01, 8.3179080e-01, 2.4361610e-01, 1.6277220e+00, 1.8094310e-01, 1.2654920e+00,
 4.1334630e-03, 2.2131060e-01, 6.6942470e-02, 3.6135780e-01, 3.4251070e-01, 1.1204120e+00, 2.2985070e-01, 2.3615850e+00,
 1.4589990e-01, 2.8243080e-01, 8.0514540e-02, 4.4284420e-01, 1.5531520e-01, 1.0746830e+00, 1.1083970e-01, 8.3308980e-01,
 2.5299530e-03, 1.4027900e-01, 3.9368190e-02, 2.2838120e-01, 3.2108690e-01, 1.0877230e+00, 2.0703310e-01, 2.2860020e+00,
 2.8392940e-02, 5.6495930e-02, 2.4002530e-02, 8.0787370e-02, 2.1595330e-01, 1.5359460e+00, 2.3608520e-01, 1.0858630e+00,
 2.4697830e-03, 1.4076310e-01, 5.8873410e-02, 2.0899880e-01, 3.2234780e-01, 1.1224590e+00, 3.1839730e-01, 2.1513740e+00,
 2.0174020e-01, 2.6021680e-01, 1.2138840e-01, 6.5210880e-01, 2.6458470e-01, 1.2198800e+00, 2.0587880e-01, 1.5113830e+00,
 2.8109840e-03, 1.0385440e-01, 4.7693250e-02, 2.7023280e-01, 7.2692460e-01, 1.6408590e+00, 5.1106020e-01, 5.5115670e+00,
 2.3375850e+00, 5.5307850e+00, 1.2063510e+00, 5.1784300e+00, 1.5343260e+00, 1.2976170e+01, 1.0239680e+00, 6.0066250e+00,
 4.1615790e-02, 2.8203350e+00, 6.0558930e-01, 2.7418320e+00, 2.0619250e+00, 8.5375040e+00, 1.2433030e+00, 1.0714240e+01,
 1.1870050e+00, 2.9084660e+00, 5.8857820e-01, 2.7152370e+00, 9.6338140e-01, 8.4376060e+00, 6.1774900e-01, 3.8943550e+00,
 2.5085870e-02, 1.7606130e+00, 3.5074750e-01, 1.7066180e+00, 1.9036800e+00, 8.1628970e+00, 1.1029190e+00, 1.0214270e+01,
 3.3589320e-01, 8.4598490e-01, 2.5514110e-01, 7.2026720e-01, 1.9477700e+00, 1.7535110e+01, 1.9132820e+00, 7.3809480e+00,
 3.5609750e-02, 2.5689380e+00, 7.6271410e-01, 2.2709800e+00, 2.7790060e+00, 1.2248690e+01, 2.4664170e+00, 1.3977840e+01,
 1.2214710e+00, 1.9942560e+00, 6.6039000e-01, 2.9755700e+00, 1.2213570e+00, 7.1277030e+00, 8.5392940e-01, 5.2578910e+00,
 2.0742850e-02, 9.7003940e-01, 3.1622740e-01, 1.5028210e+00, 3.2074070e+00, 9.1641150e+00, 2.0261390e+00, 1.8327330e+01,
 1.1334660e-04, 1.1021130e-03, 6.6607560e-04, 2.8542720e-03, 5.3513830e-04, 1.8599160e-02, 4.0667100e-03, 2.3814150e-02,
 5.7183400e-05, 1.5926160e-02, 9.4754270e-03, 4.2826140e-02, 1.4927730e-03, 2.5400970e-02, 1.0249590e-02, 8.8173640e-02,
 7.0596740e-04, 7.1087720e-03, 3.9860710e-03, 1.8356760e-02, 4.1213330e-03, 1.4833960e-01, 3.0092640e-02, 1.8937870e-01,
 4.2279730e-04, 1.2194540e-01, 6.7314150e-02, 3.2696080e-01, 1.6904650e-02, 2.9788930e-01, 1.1152300e-01, 1.0310400e+00,
 9.6577920e-06, 9.9962620e-05, 8.3534470e-05, 2.3541090e-04, 4.0282980e-04, 1.4903590e-02, 4.5057970e-03, 1.7352110e-02,
 2.9014590e-05, 8.6020020e-03, 7.0764920e-03, 2.1033770e-02, 1.1930160e-03, 2.1609500e-02, 1.2056790e-02, 6.8210760e-02,
 2.2926320e-04, 1.5382620e-03, 1.4114330e-03, 6.3485950e-03, 1.6489250e-03, 3.9546350e-02, 1.3127710e-02, 8.0691220e-02,
 1.1032920e-04, 2.1203610e-02, 1.9152710e-02, 9.0862720e-02, 8.9884590e-03, 1.0554070e-01, 6.4656040e-02, 5.8383020e-01,
 2.2632730e+00, 4.4688330e+00, 1.2283500e+00, 3.5818480e+00, 2.0722080e+00, 1.4625140e+01, 1.4543900e+00, 5.7954300e+00,
 4.5883820e-02, 2.5950160e+00, 7.0219660e-01, 2.1596420e+00, 2.6892470e+00, 9.2923750e+00, 1.7053520e+00, 9.9829530e+00,
 2.1278410e+00, 4.3509940e+00, 1.1096090e+00, 3.4772330e+00, 2.4089680e+00, 1.7607180e+01, 1.6245150e+00, 6.9567720e+00,
 5.1209170e-02, 2.9993040e+00, 7.5299520e-01, 2.4888260e+00, 4.5969420e+00, 1.6449670e+01, 2.8009000e+00, 1.7620650e+01,
 2.5848410e-01, 5.4329170e-01, 2.0648670e-01, 3.9597320e-01, 2.0908190e+00, 1.5708150e+01, 2.1599160e+00, 5.6601830e+00,
 3.1205670e-02, 1.8786940e+00, 7.0291930e-01, 1.4217310e+00, 2.8807840e+00, 1.0596160e+01, 2.6888510e+00, 1.0351440e+01,
 1.8134220e+00, 2.4707820e+00, 1.0310870e+00, 3.1559160e+00, 2.5293240e+00, 1.2318260e+01, 1.8597860e+00, 7.7788070e+00,
 3.5068420e-02, 1.3685950e+00, 5.6224590e-01, 1.8150760e+00, 6.4144340e+00, 1.5294410e+01, 4.2614020e+00, 2.6184420e+01,
 3.5175130e-02, 5.9553280e-02, 2.5286900e-02, 1.2008400e-01, 3.2611610e-02, 1.9735670e-01, 3.0317580e-02, 1.9674520e-01,
 6.6221170e-04, 3.2113690e-02, 1.3423650e-02, 6.7235480e-02, 4.0811230e-02, 1.2091730e-01, 3.4279740e-02, 3.2680400e-01,
 1.8637080e-02, 3.2676850e-02, 1.2873110e-02, 6.5698000e-02, 2.1365350e-02, 1.3390040e-01, 1.9084360e-02, 1.3309640e-01,
 4.1650970e-04, 2.0917540e-02, 8.1123040e-03, 4.3666790e-02, 3.9314980e-02, 1.2063110e-01, 3.1729360e-02, 3.2508010e-01,
 3.4361940e-03, 6.1928380e-03, 3.6358880e-03, 1.1355050e-02, 2.8144950e-02, 1.8131010e-01, 3.8511950e-02, 1.6435920e-01,
 3.8522620e-04, 1.9886180e-02, 1.1493770e-02, 3.7859880e-02, 3.7394240e-02, 1.1793850e-01, 4.6231220e-02, 2.8985060e-01,
 2.4682980e-02, 2.8836720e-02, 1.8589540e-02, 9.2662400e-02, 3.4861280e-02, 1.4557980e-01, 3.3952860e-02, 2.3127640e-01,
 4.4325470e-04, 1.4832860e-02, 9.4132180e-03, 4.9489300e-02, 8.5252510e-02, 1.7429880e-01, 7.5019820e-02, 7.5070830e-01,
 4.2399170e-01, 9.0861940e-01, 2.7387340e-01, 1.0908530e+00, 2.9969600e-01, 2.2957000e+00, 2.5034310e-01, 1.3626110e+00,
 9.7283190e-03, 5.9715320e-01, 1.7719200e-01, 7.4438700e-01, 3.5848850e-01, 1.3444320e+00, 2.7056130e-01, 2.1634270e+00,
 2.2124440e-01, 4.9100860e-01, 1.3731250e-01, 5.8776780e-01, 1.9337100e-01, 1.5339730e+00, 1.5519990e-01, 9.0783500e-01,
 6.0261330e-03, 3.8307060e-01, 1.0546060e-01, 4.7612850e-01, 3.4011540e-01, 1.3209370e+00, 2.4663920e-01, 2.1194240e+00,
 5.9315130e-02, 1.3531070e-01, 5.6393730e-02, 1.4771890e-01, 3.7040370e-01, 3.0203090e+00, 4.5541020e-01, 1.6301520e+00,
 8.1044390e-03, 5.2955730e-01, 2.1727110e-01, 6.0026860e-01, 4.7039900e-01, 1.8778980e+00, 5.2255210e-01, 2.7478630e+00,
 2.1806470e-01, 3.2246920e-01, 1.4756680e-01, 6.1695090e-01, 2.3481080e-01, 1.2411680e+00, 2.0548660e-01, 1.1739930e+00,
 4.7726590e-03, 2.0215600e-01, 9.1070470e-02, 4.0158520e-01, 5.4886920e-01, 1.4204000e+00, 4.3398040e-01, 3.6424380e+00,
 1.0139680e-06, 8.9299150e-06, 7.4580530e-06, 2.9654430e-05, 5.1553140e-06, 1.6228850e-04, 4.9036390e-05, 2.6644190e-04,
 6.5928870e-07, 1.6631140e-04, 1.3673840e-04, 5.7344650e-04, 1.2800360e-05, 1.9728050e-04, 1.1000720e-04, 8.7810310e-04,
 6.4897860e-06, 5.9189630e-05, 4.5864530e-05, 1.9598380e-04, 4.0799680e-05, 1.3300910e-03, 3.7287680e-04, 2.1773520e-03,
 5.0091920e-06, 1.3085980e-03, 9.9822400e-04, 4.4989320e-03, 1.4895820e-04, 2.3774890e-03, 1.2300110e-03, 1.0551450e-02,
 8.4113950e-08, 7.8855710e-07, 9.1063020e-07, 2.3811950e-06, 3.7782010e-06, 1.2660760e-04, 5.2895810e-05, 1.8901410e-04,
 3.2568400e-07, 8.7455030e-05, 9.9422380e-05, 2.7420500e-04, 9.9597610e-06, 1.6340030e-04, 1.2598560e-04, 6.6135400e-04,
 2.0186570e-06, 1.2267720e-05, 1.5555160e-05, 6.4920820e-05, 1.5635160e-05, 3.3963560e-04, 1.5580330e-04, 8.8859940e-04,
 1.2520120e-06, 2.1793810e-04, 2.7204100e-04, 1.1975180e-03, 7.5862290e-05, 8.0680040e-04, 6.8302400e-04, 5.7227600e-03,
 2.6837110e-01, 4.7995250e-01, 1.8230860e-01, 4.9326950e-01, 2.6460960e-01, 1.6915210e+00, 2.3245510e-01, 8.5948070e-01,
 7.0121030e-03, 3.5919810e-01, 1.3431780e-01, 3.8330880e-01, 3.0566250e-01, 9.5662890e-01, 2.4261160e-01, 1.3177980e+00,
 2.5927930e-01, 4.8020040e-01, 1.6923290e-01, 4.9208590e-01, 3.1610620e-01, 2.0926530e+00, 2.6681610e-01, 1.0602010e+00,
 8.0420410e-03, 4.2662300e-01, 1.4801200e-01, 4.5393260e-01, 5.3692100e-01, 1.7402190e+00, 4.0947290e-01, 2.3902400e+00,
 2.9840570e-02, 5.6808270e-02, 2.9836740e-02, 5.3090560e-02, 2.5993400e-01, 1.7687930e+00, 3.3610080e-01, 8.1725070e-01,
 4.6429780e-03, 2.5317710e-01, 1.3090450e-01, 2.4567380e-01, 3.1878400e-01, 1.0620370e+00, 3.7242490e-01, 1.3303470e+00,
 2.1164600e-01, 2.6118660e-01, 1.5062340e-01, 4.2777450e-01, 3.1789880e-01, 1.4022940e+00, 2.9257250e-01, 1.1354700e+00,
 5.2749360e-03, 1.8645810e-01, 1.0585550e-01, 3.1708370e-01, 7.1759940e-01, 1.5497500e+00, 5.9670870e-01, 3.4020830e+00,
 3.4370030e-02, 7.1523390e-02, 1.9899780e-02, 1.2389800e-01, 4.8709850e-02, 3.6232170e-01, 3.6470960e-02, 3.1030100e-01,
 6.3376820e-04, 3.7776520e-02, 1.0346950e-02, 6.7946460e-02, 4.2584850e-02, 1.5508220e-01, 2.8808540e-02, 3.6007880e-01,
 1.4863720e-02, 3.2032270e-02, 8.2687720e-03, 5.5326900e-02, 2.6047120e-02, 2.0064550e-01, 1.8738530e-02, 1.7133680e-01,
 3.2535980e-04, 2.0083880e-02, 5.1037720e-03, 3.6018430e-02, 3.3484110e-02, 1.2628100e-01, 2.1764580e-02, 2.9235180e-01,
 5.0796940e-03, 1.1252470e-02, 4.3289110e-03, 1.7724890e-02, 6.3600510e-02, 5.0359360e-01, 7.0091250e-02, 3.9218300e-01,
 5.5778270e-04, 3.5391470e-02, 1.3403550e-02, 5.7884620e-02, 5.9033120e-02, 2.2884670e-01, 5.8780690e-02, 4.8316990e-01,
 1.9480140e-02, 2.7972970e-02, 1.1816020e-02, 7.7220530e-02, 4.2056970e-02, 2.1587080e-01, 3.2989780e-02, 2.9461900e-01,
 3.4263930e-04, 1.4093110e-02, 5.8604390e-03, 4.0395210e-02, 7.1851010e-02, 1.8055860e-01, 5.0922530e-02, 6.6808480e-01,
 6.9124090e-01, 1.8207580e+00, 3.5960860e-01, 1.8779030e+00, 7.4688410e-01, 7.0321060e+00, 5.0247690e-01, 3.5857410e+00,
 1.5534570e-02, 1.1720480e+00, 2.2788390e-01, 1.2551480e+00, 6.2413490e-01, 2.8770010e+00, 3.7938230e-01, 3.9772260e+00,
 2.9440800e-01, 8.0309050e-01, 1.4716200e-01, 8.2588150e-01, 3.9334060e-01, 3.8352460e+00, 2.5425940e-01, 1.9499300e+00,
 7.8542600e-03, 6.1368220e-01, 1.1070450e-01, 6.5527780e-01, 4.8332000e-01, 2.3072180e+00, 2.8227910e-01, 3.1802490e+00,
 1.4630300e-01, 4.1022100e-01, 1.1202800e-01, 3.8473220e-01, 1.3965710e+00, 1.3997080e+01, 1.3829260e+00, 6.4900880e+00,
 1.9579430e-02, 1.5724910e+00, 4.2275350e-01, 1.5312900e+00, 1.2390400e+00, 6.0797930e+00, 1.1085530e+00, 7.6427330e+00,
 2.8714920e-01, 5.2192570e-01, 1.5650180e-01, 8.5784260e-01, 4.7265090e-01, 3.0707960e+00, 3.3313040e-01, 2.4952990e+00,
 6.1556230e-03, 3.2047660e-01, 9.4601370e-02, 5.4692020e-01, 7.7183110e-01, 2.4550600e+00, 4.9150940e-01, 5.4085440e+00,
 1.3452450e-05, 1.4562050e-04, 7.9691300e-05, 4.1543340e-04, 1.0455210e-04, 4.0454160e-03, 8.0094770e-04, 5.7057750e-03,
 8.5672650e-06, 2.6563580e-03, 1.4310850e-03, 7.8685400e-03, 1.8135540e-04, 3.4355050e-03, 1.2552720e-03, 1.3136770e-02,
 7.0276940e-05, 7.8781850e-04, 4.0000700e-04, 2.2409760e-03, 6.7536630e-04, 2.7062140e-02, 4.9711430e-03, 3.8058000e-02,
 5.3129960e-05, 1.7059890e-02, 8.5272310e-03, 5.0386700e-02, 1.7225750e-03, 3.3793270e-02, 1.1455940e-02, 1.2884290e-01,
 1.6883440e-06, 1.9454680e-05, 1.4721200e-05, 5.0468750e-05, 1.1592530e-04, 4.7747520e-03, 1.3071410e-03, 6.1238130e-03,
 6.4029270e-06, 2.1133190e-03, 1.5742530e-03, 5.6923590e-03, 2.1348770e-04, 4.3050180e-03, 2.1749690e-03, 1.4969000e-02,
 2.1631660e-05, 1.6158070e-04, 1.3424880e-04, 7.3459190e-04, 2.5611210e-04, 6.8381550e-03, 2.0554770e-03, 1.5369810e-02,
 1.3140900e-05, 2.8115640e-03, 2.2996370e-03, 1.3271910e-02, 8.6812960e-04, 1.1348090e-02, 6.2951030e-03, 6.9151070e-02,
 4.3894360e-01, 9.6487100e-01, 2.4015320e-01, 8.5190640e-01, 6.6157440e-01, 5.1981490e+00, 4.6808050e-01, 2.2690490e+00,
 1.1233380e-02, 7.0728490e-01, 1.7330220e-01, 6.4840410e-01, 5.3388320e-01, 2.0537410e+00, 3.4129020e-01, 2.4304550e+00,
 3.4613540e-01, 7.8795010e-01, 1.8195800e-01, 6.9367130e-01, 6.4507680e-01, 5.2489640e+00, 4.3852930e-01, 2.2845530e+00,
 1.0515590e-02, 6.8566160e-01, 1.5587360e-01, 6.2674880e-01, 7.6545510e-01, 3.0493780e+00, 4.7015670e-01, 3.5982020e+00,
 7.3840670e-02, 1.7278190e-01, 5.9463180e-02, 1.3872050e-01, 9.8322240e-01, 8.2236350e+00, 1.0239210e+00, 3.2642150e+00,
 1.1253160e-02, 7.5422410e-01, 2.5552930e-01, 6.2874040e-01, 8.4239580e-01, 3.4495120e+00, 7.9262290e-01, 3.7120960e+00,
 2.7959750e-01, 4.2410370e-01, 1.6025950e-01, 5.9672300e-01, 6.4196630e-01, 3.4806520e+00, 4.7584450e-01, 2.4212180e+00,
 6.8254240e-03, 2.9654590e-01, 1.1031490e-01, 4.3323260e-01, 1.0123630e+00, 2.6872870e+00, 6.7799260e-01, 5.0679700e+00,
 5.0663930e-02, 8.6293080e-02, 3.4092560e-02, 1.7600790e-01, 6.0675090e-02, 3.6940010e-01, 5.2799930e-02, 3.7249970e-01,
 9.6488670e-04, 4.7073530e-02, 1.8308420e-02, 9.9692310e-02, 7.7848050e-02, 2.3204050e-01, 6.1207740e-02, 6.3436500e-01,
 1.4776030e-02, 2.6063160e-02, 9.5535290e-03, 5.3004850e-02, 2.1880880e-02, 1.3795690e-01, 1.8295030e-02, 1.3870900e-01,
 3.3405740e-04, 1.6877720e-02, 6.0903330e-03, 3.5639450e-02, 4.1280290e-02, 1.2742390e-01, 3.1185070e-02, 3.4734320e-01,
 5.6079820e-03, 1.0167770e-02, 5.5544390e-03, 1.8858260e-02, 5.9334100e-02, 3.8453250e-01, 7.5997640e-02, 3.5259940e-01,
 6.3600580e-04, 3.3029620e-02, 1.7762680e-02, 6.3607480e-02, 8.0823660e-02, 2.5644630e-01, 9.3534090e-02, 6.3751680e-01,
 1.7537130e-02, 2.0611710e-02, 1.2363180e-02, 6.6995910e-02, 3.1994790e-02, 1.3441390e-01, 2.9168430e-02, 2.1599860e-01,
 3.1858890e-04, 1.0725300e-02, 6.3330970e-03, 3.6196980e-02, 8.0218230e-02, 1.6499370e-01, 6.6075840e-02, 7.1882120e-01,
 4.8793800e-01, 1.0519530e+00, 2.9502430e-01, 1.2774890e+00, 4.4551590e-01, 3.4332420e+00, 3.4835220e-01, 2.0612850e+00,
 1.1325600e-02, 6.9938530e-01, 1.9309380e-01, 8.8187300e-01, 5.4637080e-01, 2.0613800e+00, 3.8599220e-01, 3.3553530e+00,
 1.4015100e-01, 3.1291050e-01, 8.1420680e-02, 3.7889020e-01, 1.5823050e-01, 1.2627680e+00, 1.1887510e-01, 7.5594370e-01,
 3.8617030e-03, 2.4695970e-01, 6.3260290e-02, 3.1049030e-01, 2.8533510e-01, 1.1148540e+00, 1.9368300e-01, 1.8093830e+00,
 7.7346130e-02, 1.7750570e-01, 6.8834250e-02, 1.9601660e-01, 6.2391190e-01, 5.1180740e+00, 7.1804460e-01, 2.7942150e+00,
 1.0690850e-02, 7.0276380e-01, 2.6828230e-01, 8.0578410e-01, 8.1235210e-01, 3.2625480e+00, 8.4471110e-01, 4.8289950e+00,
 1.2379140e-01, 1.8416220e-01, 7.8414190e-02, 3.5640140e-01, 1.7218610e-01, 9.1562490e-01, 1.4104720e-01, 8.7605050e-01,
 2.7408280e-03, 1.1679260e-01, 4.8955300e-02, 2.3468360e-01, 4.1264720e-01, 1.0743050e+00, 3.0540830e-01, 2.7866720e+00,
 1.2617020e-05, 1.1178590e-04, 8.6867780e-05, 3.7549640e-04, 8.2863380e-05, 2.6242320e-03, 7.3777970e-04, 4.3580650e-03,
 8.2989750e-06, 2.1060950e-03, 1.6111650e-03, 7.3455680e-03, 2.1094030e-04, 3.2706090e-03, 1.6969120e-03, 1.4725380e-02,
 4.4450790e-05, 4.0785130e-04, 2.9405380e-04, 1.3660070e-03, 3.6097810e-04, 1.1838930e-02, 3.0880920e-03, 1.9603620e-02,
 3.4708280e-05, 9.1217640e-03, 6.4743200e-03, 3.1721860e-02, 1.3511960e-03, 2.1696000e-02, 1.0443920e-02, 9.7398000e-02,
 1.1859500e-06, 1.1185070e-05, 1.2018250e-05, 3.4164650e-05, 6.8811080e-05, 2.3197440e-03, 9.0176880e-04, 3.5030880e-03,
 4.6452700e-06, 1.2548920e-03, 1.3273930e-03, 3.9799140e-03, 1.8597390e-04, 3.0694680e-03, 2.2020370e-03, 1.2566690e-02,
 1.2390610e-05, 7.5753250e-05, 8.9372870e-05, 4.0550670e-04, 1.2396750e-04, 2.7091040e-03, 1.1563320e-03, 7.1696020e-03,
 7.7741890e-06, 1.3614040e-03, 1.5811810e-03, 7.5668010e-03, 6.1668190e-04, 6.5979420e-03, 5.1972300e-03, 4.7339600e-02,
 3.2433100e-01, 5.8352310e-01, 2.0623420e-01, 6.0662550e-01, 4.1307910e-01, 2.6565150e+00, 3.3967810e-01, 1.3653610e+00,
 8.5726930e-03, 4.4178420e-01, 1.5371040e-01, 4.7687160e-01, 4.8921500e-01, 1.5403100e+00, 3.6347110e-01, 2.1462980e+00,
 1.7247940e-01, 3.2136520e-01, 1.0537920e-01, 3.3311480e-01, 2.7162970e-01, 1.8090420e+00, 2.1461350e-01, 9.2707770e-01,
 5.4119270e-03, 2.8882650e-01, 9.3235910e-02, 3.1085700e-01, 4.7302560e-01, 1.5423580e+00, 3.3767590e-01, 2.1428880e+00,
 4.0862560e-02, 7.8259520e-02, 3.8244640e-02, 7.3980880e-02, 4.5978670e-01, 3.1475850e+00, 5.5649800e-01, 1.4710670e+00,
 6.4317820e-03, 3.5283060e-01, 1.6974230e-01, 3.4631970e-01, 5.7812250e-01, 1.9376270e+00, 6.3221200e-01, 2.4551150e+00,
 1.2617130e-01, 1.5664210e-01, 8.4051180e-02, 2.5950700e-01, 2.4480170e-01, 1.0863550e+00, 2.1089180e-01, 8.8978480e-01,
 3.1811490e-03, 1.1312410e-01, 5.9755920e-02, 1.9459180e-01, 5.6654910e-01, 1.2309040e+00, 4.4097970e-01, 2.7332800e+00,
 1.4663110e-01, 2.7408860e-01, 8.4217060e-02, 4.3102020e-01, 1.5623620e-01, 1.0438930e+00, 1.1604270e-01, 8.1158720e-01,
 2.4559210e-03, 1.3149290e-01, 3.9774250e-02, 2.1470280e-01, 1.6354550e-01, 5.3498580e-01, 1.0975150e-01, 1.1276340e+00,
 6.7735490e-02, 1.3112130e-01, 3.7379680e-02, 2.0559480e-01, 8.9241590e-02, 6.1749540e-01, 6.3686690e-02, 4.7868000e-01,
 1.3467610e-03, 7.4674220e-02, 2.0956730e-02, 1.2157330e-01, 1.3736150e-01, 4.6532970e-01, 8.8569070e-02, 9.7795520e-01,
 1.5635950e-02, 3.1112220e-02, 1.3218160e-02, 4.4489480e-02, 1.4718580e-01, 1.0468440e+00, 1.6090690e-01, 7.4008420e-01,
 1.5595140e-03, 8.8883160e-02, 3.7174900e-02, 1.3196980e-01, 1.6357600e-01, 5.6959390e-01, 1.6157130e-01, 1.0917190e+00,
 8.2486420e-02, 1.0639600e-01, 4.9632630e-02, 2.6663070e-01, 1.3388970e-01, 6.1730460e-01, 1.0418230e-01, 7.6481570e-01,
 1.3178480e-03, 4.8689080e-02, 2.2359590e-02, 1.2669070e-01, 2.7388010e-01, 6.1821910e-01, 1.9254990e-01, 2.0765690e+00,
 1.2901990e+00, 3.0526430e+00, 6.6582960e-01, 2.8581660e+00, 1.0480920e+00, 8.8639660e+00, 6.9946780e-01, 4.1030990e+00,
 2.6336870e-02, 1.7848710e+00, 3.8325190e-01, 1.7351890e+00, 1.0486800e+00, 4.3421150e+00, 6.3233520e-01, 5.4491890e+00,
 5.8697490e-01, 1.4382390e+00, 2.9105240e-01, 1.3426870e+00, 5.8960000e-01, 5.1639070e+00, 3.7806920e-01, 2.3833880e+00,
 1.4223710e-02, 9.9826930e-01, 1.9887420e-01, 9.6765400e-01, 8.6744520e-01, 3.7195670e+00, 5.0256430e-01, 4.6543100e+00,
 1.9702480e-01, 4.9622910e-01, 1.4965800e-01, 4.2248690e-01, 1.4140000e+00, 1.2729760e+01, 1.3889640e+00, 5.3582630e+00,
 2.3949990e-02, 1.7277860e+00, 5.1297740e-01, 1.5273890e+00, 1.5020700e+00, 6.6204950e+00, 1.3331140e+00, 7.5551090e+00,
 5.3196010e-01, 8.6851360e-01, 2.8760490e-01, 1.2958840e+00, 6.5831020e-01, 3.8418260e+00, 4.6026720e-01, 2.8339990e+00,
 1.0358120e-02, 4.8439760e-01, 1.5791090e-01, 7.5044700e-01, 1.2871550e+00, 3.6776250e+00, 8.1310410e-01, 7.3548880e+00,
 4.8117980e-05, 4.6786990e-04, 2.8276290e-04, 1.2116980e-03, 2.8116230e-04, 9.7720200e-03, 2.1366540e-03, 1.2511980e-02,
 2.7834640e-05, 7.7522320e-03, 4.6122670e-03, 2.0846090e-02, 5.8394740e-04, 9.9364290e-03, 4.0094670e-03, 3.4492030e-02,
 2.6851050e-04, 2.7037790e-03, 1.5160780e-03, 6.9818860e-03, 1.9400210e-03, 6.9827400e-02, 1.4165410e-02, 8.9145630e-02,
 1.8438500e-04, 5.3181280e-02, 2.9356190e-02, 1.4259000e-01, 5.9246650e-03, 1.0440290e-01, 3.9086080e-02, 3.6135440e-01,
 4.3571960e-06, 4.5098990e-05, 3.7687290e-05, 1.0620760e-04, 2.2492770e-04, 8.3217040e-03, 2.5158980e-03, 9.6888850e-03,
 1.5009370e-05, 4.4498520e-03, 3.6606990e-03, 1.0880860e-02, 4.9597120e-04, 8.9836970e-03, 5.0123590e-03, 2.8357190e-02,
 7.6796210e-05, 5.1527120e-04, 4.7278730e-04, 2.1265860e-03, 6.8359460e-04, 1.6394720e-02, 5.4423540e-03, 3.3452140e-02,
 4.2375290e-05, 8.1438940e-03, 7.3561820e-03, 3.4898600e-02, 2.7744170e-03, 3.2576670e-02, 1.9957020e-02, 1.8020760e-01,
 1.2201760e+00, 2.4092380e+00, 6.6222860e-01, 1.9310470e+00, 1.3826470e+00, 9.7583830e+00, 9.7041770e-01, 3.8669050e+00,
 2.8363640e-02, 1.6041410e+00, 4.3407140e-01, 1.3350090e+00, 1.3359720e+00, 4.6162940e+00, 8.4718970e-01, 4.9593610e+00,
 1.0277850e+00, 2.1016080e+00, 5.3596100e-01, 1.6795660e+00, 1.4400800e+00, 1.0525560e+01, 9.7113460e-01, 4.1587550e+00,
 2.8361410e-02, 1.6611180e+00, 4.1703490e-01, 1.3783980e+00, 2.0460370e+00, 7.3215280e+00, 1.2466430e+00, 7.8427130e+00,
 1.4809820e-01, 3.1127850e-01, 1.1830630e-01, 2.2687250e-01, 1.4826020e+00, 1.1138670e+01, 1.5315990e+00, 4.0136430e+00,
 2.0500590e-02, 1.2342090e+00, 4.6178330e-01, 9.3400730e-01, 1.5209250e+00, 5.5943000e+00, 1.4195930e+00, 5.4650950e+00,
 7.7142050e-01, 1.0510580e+00, 4.3861900e-01, 1.3425100e+00, 1.3316460e+00, 6.4853560e+00, 9.7914570e-01, 4.0954110e+00,
 1.7105080e-02, 6.6755030e-01, 2.7424280e-01, 8.8532710e-01, 2.5143840e+00, 5.9952310e+00, 1.6704210e+00, 1.0263990e+01,
 4.1767540e-02, 7.0714580e-02, 3.0026100e-02, 1.4258980e-01, 4.7925630e-02, 2.9003290e-01, 4.4554330e-02, 2.8913420e-01,
 9.0160620e-04, 4.3723030e-02, 1.8276400e-02, 9.1541610e-02, 4.4654370e-02, 1.3230400e-01, 3.7507830e-02, 3.5757880e-01,
 1.9827090e-02, 3.4763310e-02, 1.3695070e-02, 6.9892910e-02, 2.8130880e-02, 1.7630110e-01, 2.5127590e-02, 1.7524250e-01,
 5.0806910e-04, 2.5515750e-02, 9.8955970e-03, 5.3265870e-02, 3.8540750e-02, 1.1825550e-01, 3.1104520e-02, 3.1867830e-01,
 4.3362200e-03, 7.8148990e-03, 4.5882190e-03, 1.4329220e-02, 4.3956830e-02, 2.8317040e-01, 6.0148020e-02, 2.5669640e-01,
 5.5739910e-04, 2.8774090e-02, 1.6630790e-02, 5.4780960e-02, 4.3482990e-02, 1.3714190e-01, 5.3758860e-02, 3.3704570e-01,
 2.3126370e-02, 2.7018160e-02, 1.7417200e-02, 8.6818720e-02, 4.0424560e-02, 1.6881190e-01, 3.9371180e-02, 2.6818430e-01,
 4.7618970e-04, 1.5934980e-02, 1.0112640e-02, 5.3166480e-02, 7.3603440e-02, 1.5048230e-01, 6.4768970e-02, 6.4813010e-01,
 5.3624890e-01, 1.1491880e+00, 3.4638480e-01, 1.3796700e+00, 4.6911820e-01, 3.5934890e+00, 3.9186530e-01, 2.1329140e+00,
 1.4107940e-02, 8.6598750e-01, 2.5696260e-01, 1.0795050e+00, 4.1779710e-01, 1.5668550e+00, 3.1532310e-01, 2.5213460e+00,
 2.5070270e-01, 5.5638560e-01, 1.5559540e-01, 6.6602810e-01, 2.7118790e-01, 2.1512790e+00, 2.1765580e-01, 1.2731690e+00,
 7.8296480e-03, 4.9771690e-01, 1.3702310e-01, 6.1862540e-01, 3.5513560e-01, 1.3792720e+00, 2.5753120e-01, 2.2130220e+00,
 7.9726900e-02, 1.8187440e-01, 7.5800170e-02, 1.9855260e-01, 6.1617900e-01, 5.0243870e+00, 7.5759020e-01, 2.7118130e+00,
 1.2490480e-02, 8.1614840e-01, 3.3485610e-01, 9.2512800e-01, 5.8262200e-01, 2.3259070e+00, 6.4721720e-01, 3.4034210e+00,
 2.1762110e-01, 3.2181320e-01, 1.4726660e-01, 6.1569580e-01, 2.9001860e-01, 1.5329860e+00, 2.5379990e-01, 1.4500170e+00,
 5.4612590e-03, 2.3132310e-01, 1.0421010e-01, 4.5952600e-01, 5.0473750e-01, 1.3061930e+00, 3.9908630e-01, 3.3495690e+00,
 9.8637700e-07, 8.6869230e-06, 7.2551110e-06, 2.8847500e-05, 6.2067750e-06, 1.9538830e-04, 5.9037690e-05, 3.2078450e-04,
 7.3537870e-07, 1.8550580e-04, 1.5251970e-04, 6.3962920e-04, 1.1474190e-05, 1.7684130e-04, 9.8610000e-05, 7.8712780e-04,
 5.6562260e-06, 5.1587200e-05, 3.9973600e-05, 1.7081130e-04, 4.4009380e-05, 1.4347290e-03, 4.0221100e-04, 2.3486440e-03,
 5.0058840e-06, 1.3077340e-03, 9.9756490e-04, 4.4959620e-03, 1.1963050e-04, 1.9093960e-03, 9.8783930e-04, 8.4740250e-03,
 8.6959500e-08, 8.1523370e-07, 9.4143650e-07, 2.4617500e-06, 4.8342190e-06, 1.6199470e-04, 6.7680330e-05, 2.4184400e-04,
 3.8606650e-07, 1.0366940e-04, 1.1785550e-04, 3.2504320e-04, 9.4880940e-06, 1.5566210e-04, 1.2001920e-04, 6.3003410e-04,
 1.5494860e-06, 9.4164890e-06, 1.1939880e-05, 4.9832100e-05, 1.4853190e-05, 3.2264920e-04, 1.4801100e-04, 8.4415740e-04,
 1.1019210e-06, 1.9181170e-04, 2.3942870e-04, 1.0539600e-03, 5.3657720e-05, 5.7065340e-04, 4.8310580e-04, 4.0477330e-03,
 3.3154400e-01, 5.9293030e-01, 2.2522300e-01, 6.0938210e-01, 4.0457890e-01, 2.5862770e+00, 3.5541590e-01, 1.3141160e+00,
 9.9327720e-03, 5.0881070e-01, 1.9026360e-01, 5.4296390e-01, 3.4795950e-01, 1.0890050e+00, 2.7618370e-01, 1.5001520e+00,
 2.8697960e-01, 5.3150290e-01, 1.8731300e-01, 5.4465810e-01, 4.3302050e-01, 2.8666360e+00, 3.6550000e-01, 1.4523240e+00,
 1.0206250e-02, 5.4143230e-01, 1.8784380e-01, 5.7609120e-01, 5.4761410e-01, 1.7748760e+00, 4.1762780e-01, 2.4378430e+00,
 3.9178050e-02, 7.4584290e-02, 3.9173030e-02, 6.9703260e-02, 4.2236800e-01, 2.8741200e+00, 5.4613180e-01, 1.3279550e+00,
 6.9895480e-03, 3.8113330e-01, 1.9706400e-01, 3.6983780e-01, 3.8566780e-01, 1.2848630e+00, 4.5056300e-01, 1.6094650e+00,
 2.0631080e-01, 2.5460260e-01, 1.4682650e-01, 4.1699120e-01, 3.8352450e-01, 1.6917780e+00, 3.5296990e-01, 1.3698720e+00,
 5.8958430e-03, 2.0840590e-01, 1.1831560e-01, 3.5440740e-01, 6.4457750e-01, 1.3920500e+00, 5.3598850e-01, 3.0558920e+00,
 3.4051750e-02, 7.0861040e-02, 1.9715490e-02, 1.2275060e-01, 4.8212300e-02, 3.5862080e-01, 3.6098420e-02, 3.0713140e-01,
 6.0341940e-04, 3.5967540e-02, 9.8514750e-03, 6.4692750e-02, 4.3660060e-02, 1.5899790e-01, 2.9535920e-02, 3.6917040e-01,
 1.7316500e-02, 3.7318170e-02, 9.6332690e-03, 6.4456830e-02, 3.0316140e-02, 2.3353060e-01, 2.1809700e-02, 1.9941830e-01,
 3.6427210e-04, 2.2485860e-02, 5.7141710e-03, 4.0326150e-02, 4.0368370e-02, 1.5224410e-01, 2.6239330e-02, 3.5245870e-01,
 4.9924160e-03, 1.1059130e-02, 4.2545320e-03, 1.7420350e-02, 6.2447540e-02, 4.9446440e-01, 6.8820620e-02, 3.8507340e-01,
 5.2682650e-04, 3.3427290e-02, 1.2659670e-02, 5.4672090e-02, 6.0039720e-02, 2.3274890e-01, 5.9782990e-02, 4.9140870e-01,
 3.1345950e-02, 4.5011960e-02, 1.9013440e-02, 1.2425740e-01, 6.7609690e-02, 3.4702830e-01, 5.3033500e-02, 4.7362180e-01,
 5.2985360e-04, 2.1793440e-02, 9.0625180e-03, 6.2466710e-02, 1.1964430e-01, 3.0066110e-01, 8.4794780e-02, 1.1124760e+00,
 6.2914970e-01, 1.6572070e+00, 3.2730650e-01, 1.7092190e+00, 6.7914020e-01, 6.3942790e+00, 4.5690110e-01, 3.2605070e+00,
 1.3587920e-02, 1.0251780e+00, 1.9932770e-01, 1.0978650e+00, 5.8785860e-01, 2.7097830e+00, 3.5733160e-01, 3.7460590e+00,
 3.1509920e-01, 8.5953240e-01, 1.5750460e-01, 8.8392520e-01, 4.2057960e-01, 4.1008380e+00, 2.7186690e-01, 2.0849640e+00,
 8.0785310e-03, 6.3120540e-01, 1.1386550e-01, 6.7398870e-01, 5.3530630e-01, 2.5553840e+00, 3.1264130e-01, 3.5223190e+00,
 1.3209650e-01, 3.7038740e-01, 1.0114980e-01, 3.4737360e-01, 1.2597460e+00, 1.2625750e+01, 1.2474370e+00, 5.8542400e+00,
 1.6988990e-02, 1.3644440e+00, 3.6682160e-01, 1.3286940e+00, 1.1576930e+00, 5.6806350e+00, 1.0357730e+00, 7.1409630e+00,
 4.2448480e-01, 7.7154830e-01, 2.3135230e-01, 1.2681250e+00, 6.9803400e-01, 4.5351020e+00, 4.9198330e-01, 3.6851790e+00,
 8.7449200e-03, 4.5528170e-01, 1.3439440e-01, 7.7697640e-01, 1.1807190e+00, 3.7556620e+00, 7.5189310e-01, 8.2737930e+00,
 3.5198110e-07, 3.8101360e-06, 2.0851090e-06, 1.0869740e-05, 2.7329520e-06, 1.0574570e-04, 2.0936480e-05, 1.4914680e-04,
 2.1542170e-07, 6.6793450e-05, 3.5984260e-05, 1.9785240e-04, 4.9104150e-06, 9.3020400e-05, 3.3987990e-05, 3.5569380e-04,
 2.1622400e-06, 2.4239140e-05, 1.2307180e-05, 6.8949050e-05, 2.0759270e-05, 8.3183040e-04, 1.5280200e-04, 1.1698190e-03,
 1.5709410e-06, 5.0442490e-04, 2.5213220e-04, 1.4898290e-03, 5.4845230e-05, 1.0759470e-03, 3.6474680e-04, 4.1022440e-03,
 4.3822030e-08, 5.0495840e-07, 3.8209790e-07, 1.3099480e-06, 3.0060160e-06, 1.2381230e-04, 3.3895000e-05, 1.5879430e-04,
 1.5971270e-07, 5.2714000e-05, 3.9267700e-05, 1.4198850e-04, 5.7342190e-06, 1.1563150e-04, 5.8419040e-05, 4.0206290e-04,
 9.1925850e-07, 6.8665270e-06, 5.7050310e-06, 3.1217200e-05, 1.0873250e-05, 2.9031420e-04, 8.7265370e-05, 6.5252590e-04,
 5.3666380e-07, 1.1482200e-04, 9.3915320e-05, 5.4201410e-04, 3.8177030e-05, 4.9904580e-04, 2.7683460e-04, 3.0410000e-03,
 3.9280060e-01, 8.6344100e-01, 2.1490760e-01, 7.6235160e-01, 5.9145770e-01, 4.6472250e+00, 4.1847120e-01, 2.0285650e+00,
 9.6605820e-03, 6.0825710e-01, 1.4903790e-01, 5.5762020e-01, 4.9440120e-01, 1.9018620e+00, 3.1605090e-01, 2.2507160e+00,
 3.6423580e-01, 8.2915430e-01, 1.9147300e-01, 7.2994530e-01, 6.7815600e-01, 5.5181290e+00, 4.6101690e-01, 2.4017040e+00,
 1.0634080e-02, 6.9338720e-01, 1.5762990e-01, 6.3381050e-01, 8.3353940e-01, 3.3206090e+00, 5.1197540e-01, 3.9182480e+00,
 6.5550010e-02, 1.5338230e-01, 5.2786790e-02, 1.2314530e-01, 8.7198800e-01, 7.2932750e+00, 9.0808220e-01, 2.8949260e+00,
 9.6002140e-03, 6.4343820e-01, 2.1799540e-01, 5.3638650e-01, 7.7386130e-01, 3.1688710e+00, 7.2813770e-01, 3.4100920e+00,
 4.0637460e-01, 6.1640400e-01, 2.3292560e-01, 8.6729340e-01, 9.3215300e-01, 5.0540030e+00, 6.9093950e-01, 3.5156750e+00,
 9.5334990e-03, 4.1420420e-01, 1.5408370e-01, 6.0512330e-01, 1.5226480e+00, 4.0418230e+00, 1.0197370e+00, 7.6224950e+00,
 9.1663100e-02, 1.5612470e-01, 6.1681550e-02, 3.1844020e-01, 1.0967000e-01, 6.6768920e-01, 9.5435640e-02, 6.7329160e-01,
 1.6776500e-03, 8.1846820e-02, 3.1832870e-02, 1.7333520e-01, 1.4575160e-01, 4.3443940e-01, 1.1459660e-01, 1.1876940e+00,
 3.1435950e-02, 5.5449280e-02, 2.0325100e-02, 1.1276760e-01, 4.6506670e-02, 2.9322030e-01, 3.8885130e-02, 2.9481880e-01,
 6.8299790e-04, 3.4507390e-02, 1.2452000e-02, 7.2866730e-02, 9.0882750e-02, 2.8053670e-01, 6.8657100e-02, 7.6471120e-01,
 1.0065050e-02, 1.8248840e-02, 9.9689540e-03, 3.3846290e-02, 1.0638870e-01, 6.8948370e-01, 1.3626710e-01, 6.3222630e-01,
 1.0969830e-03, 5.6969490e-02, 3.0637070e-02, 1.0971020e-01, 1.5011280e-01, 4.7629470e-01, 1.7371970e-01, 1.1840520e+00,
 5.1532860e-02, 6.0567500e-02, 3.6329210e-02, 1.9686740e-01, 9.3926140e-02, 3.9459480e-01, 8.5628890e-02, 6.3410070e-01,
 8.9967500e-04, 3.0287570e-02, 1.7884270e-02, 1.0221800e-01, 2.4393180e-01, 5.0172160e-01, 2.0092690e-01, 2.1858290e+00,
 8.1100870e-01, 1.7484660e+00, 4.9036410e-01, 2.1233330e+00, 7.3978520e-01, 5.7009450e+00, 5.7844350e-01, 3.4227910e+00,
 1.8090540e-02, 1.1171380e+00, 3.0843140e-01, 1.4086280e+00, 9.3976240e-01, 3.5455910e+00, 6.6390990e-01, 5.7712360e+00,
 2.7392410e-01, 6.1158120e-01, 1.5913610e-01, 7.4053810e-01, 3.0896250e-01, 2.4656940e+00, 2.3211680e-01, 1.4760640e+00,
 7.2534110e-03, 4.6386280e-01, 1.1882140e-01, 5.8319190e-01, 5.7711050e-01, 2.2548710e+00, 3.9173770e-01, 3.6596050e+00,
 1.2753020e-01, 2.9267580e-01, 1.1349560e-01, 3.2319710e-01, 1.0277310e+00, 8.4306810e+00, 1.1827900e+00, 4.6027340e+00,
 1.6940110e-02, 1.1135590e+00, 4.2510470e-01, 1.2767990e+00, 1.3860810e+00, 5.5667440e+00, 1.4412940e+00, 8.2395050e+00,
 3.3418060e-01, 4.9715440e-01, 2.1168270e-01, 9.6212210e-01, 4.6437670e-01, 2.4693910e+00, 3.8039670e-01, 2.3626610e+00,
 7.1105290e-03, 3.0299490e-01, 1.2700470e-01, 6.0883960e-01, 1.1527610e+00, 3.0011540e+00, 8.5318150e-01, 7.7847820e+00,
 6.0285230e-07, 5.3412270e-06, 4.1506180e-06, 1.7941550e-05, 3.9554720e-06, 1.2526740e-04, 3.5217810e-05, 2.0803160e-04,
 3.8107280e-07, 9.6707780e-05, 7.3981570e-05, 3.3729420e-04, 1.0429980e-05, 1.6171580e-04, 8.3904120e-05, 7.2809910e-04,
 2.4975070e-06, 2.2915490e-05, 1.6521670e-05, 7.6750330e-05, 2.0262340e-05, 6.6454060e-04, 1.7334010e-04, 1.1003860e-03,
 1.8740870e-06, 4.9253310e-04, 3.4958340e-04, 1.7128340e-03, 7.8562550e-05, 1.2614690e-03, 6.0724040e-04, 5.6630070e-03,
 5.6212660e-08, 5.3015920e-07, 5.6965100e-07, 1.6193650e-06, 3.2584250e-06, 1.0984730e-04, 4.2701640e-05, 1.6588250e-04,
 2.1159630e-07, 5.7161510e-05, 6.0463960e-05, 1.8128870e-04, 9.1219920e-06, 1.5055690e-04, 1.0800960e-04, 6.1639410e-04,
 9.6156100e-07, 5.8787540e-06, 6.9356900e-06, 3.1468940e-05, 9.6111050e-06, 2.1003480e-04, 8.9649590e-05, 5.5585390e-04,
 5.7978690e-07, 1.0153140e-04, 1.1792210e-04, 5.6432030e-04, 4.9523920e-05, 5.2986140e-04, 4.1737430e-04, 3.8017040e-03,
 5.3001500e-01, 9.5358130e-01, 3.3702360e-01, 9.9133480e-01, 6.7439520e-01, 4.3370410e+00, 5.5456030e-01, 2.2290960e+00,
 1.3463140e-02, 6.9380780e-01, 2.4139720e-01, 7.4891150e-01, 8.2731190e-01, 2.6048200e+00, 6.1466620e-01, 3.6296060e+00,
 3.3144390e-01, 6.1754950e-01, 2.0250120e-01, 6.4012790e-01, 5.2147290e-01, 3.4729860e+00, 4.1201350e-01, 1.7797970e+00,
 9.9943400e-03, 5.3338300e-01, 1.7218110e-01, 5.7406730e-01, 9.4064830e-01, 3.0671000e+00, 6.7149490e-01, 4.2613000e+00,
 6.6242840e-02, 1.2686750e-01, 6.1998890e-02, 1.1993140e-01, 7.4464870e-01, 5.0976790e+00, 9.0127760e-01, 2.3824700e+00,
 1.0020150e-02, 5.4967880e-01, 2.6444350e-01, 5.3953540e-01, 9.6984650e-01, 3.2505250e+00, 1.0605860e+00, 4.1186510e+00,
 3.3488080e-01, 4.1575560e-01, 2.2308650e-01, 6.8877710e-01, 6.4912090e-01, 2.8806000e+00, 5.5920480e-01, 2.3593710e+00,
 8.1141480e-03, 2.8854540e-01, 1.5241930e-01, 4.9634480e-01, 1.5560980e+00, 3.3808320e+00, 1.2112060e+00, 7.5072950e+00,
 1.9447180e-01, 3.6351420e-01, 1.1169420e-01, 5.7164720e-01, 2.0701120e-01, 1.3831460e+00, 1.5375520e-01, 1.0753440e+00,
 3.1302150e-03, 1.6759550e-01, 5.0694610e-02, 2.7365130e-01, 2.2446000e-01, 7.3424760e-01, 1.5062970e-01, 1.5476350e+00,
 1.0563790e-01, 2.0449230e-01, 5.8296060e-02, 3.2063860e-01, 1.3904410e-01, 9.6209720e-01, 9.9227930e-02, 7.4581400e-01,
 2.0184750e-03, 1.1191900e-01, 3.1409170e-02, 1.8220960e-01, 2.2168610e-01, 7.5099000e-01, 1.4294060e-01, 1.5783100e+00,
 2.0571610e-02, 4.0933150e-02, 1.7390620e-02, 5.8533090e-02, 1.9346020e-01, 1.3759670e+00, 2.1149520e-01, 9.7276260e-01,
 1.9718000e-03, 1.1238100e-01, 4.7002760e-02, 1.6685840e-01, 2.2270690e-01, 7.7549550e-01, 2.1997750e-01, 1.4863630e+00,
 1.7768170e-01, 2.2918480e-01, 1.0691230e-01, 5.7434190e-01, 2.8813030e-01, 1.3284390e+00, 2.2420020e-01, 1.6458820e+00,
 2.7280660e-03, 1.0079090e-01, 4.6286410e-02, 2.6226150e-01, 6.1050700e-01, 1.3780740e+00, 4.2921350e-01, 4.6288860e+00,
 1.5719990e+00, 3.7193890e+00, 8.1125740e-01, 3.4824350e+00, 1.2757820e+00, 1.0789600e+01, 8.5142210e-01, 4.9944680e+00,
 3.0838210e-02, 2.0899300e+00, 4.4875490e-01, 2.0317570e+00, 1.3222350e+00, 5.4747800e+00, 7.9728340e-01, 6.8706410e+00,
 8.4098500e-01, 2.0606290e+00, 4.1700370e-01, 1.9237270e+00, 8.4393270e-01, 7.3914360e+00, 5.4115500e-01, 3.4114980e+00,
 1.9584430e-02, 1.3745040e+00, 2.7382710e-01, 1.3323500e+00, 1.2861170e+00, 5.5148150e+00, 7.4512680e-01, 6.9007120e+00,
 2.3813880e-01, 5.9977940e-01, 1.8088780e-01, 5.1064910e-01, 1.7074200e+00, 1.5371320e+01, 1.6771880e+00, 6.4701580e+00,
 2.7819150e-02, 2.0069130e+00, 5.9584990e-01, 1.7741420e+00, 1.8787510e+00, 8.2807470e+00, 1.6674250e+00, 9.4497390e+00,
 1.0527000e+00, 1.7187080e+00, 5.6914350e-01, 2.5644340e+00, 1.3014810e+00, 7.5952970e+00, 9.0994910e-01, 5.6028210e+00,
 1.9698620e-02, 9.2120620e-01, 3.0030800e-01, 1.4271670e+00, 2.6358840e+00, 7.5311750e+00, 1.6651040e+00, 1.5061610e+01,
 1.6853740e-06, 1.6387550e-05, 9.9040130e-06, 4.2440760e-05, 9.8384700e-06, 3.4194380e-04, 7.4766100e-05, 4.3782100e-04,
 9.3692290e-07, 2.6094260e-04, 1.5525040e-04, 7.0168600e-04, 2.1165690e-05, 3.6015460e-04, 1.4532670e-04, 1.2501940e-03,
 1.1059190e-05, 1.1136100e-04, 6.2442990e-05, 2.8756420e-04, 7.9827060e-05, 2.8732240e-03, 5.8287130e-04, 3.6681210e-03,
 7.2982200e-06, 2.1049910e-03, 1.1619600e-03, 5.6439140e-03, 2.5251990e-04, 4.4498400e-03, 1.6659190e-03, 1.5401580e-02,
 1.5139430e-07, 1.5670010e-06, 1.3094760e-06, 3.6902710e-06, 7.8077730e-06, 2.8886600e-04, 8.7332760e-05, 3.3632410e-04,
 5.0118070e-07, 1.4858580e-04, 1.2223510e-04, 3.6332470e-04, 1.7833180e-05, 3.2301850e-04, 1.8022480e-04, 1.0196130e-03,
 4.3687630e-06, 2.9312620e-05, 2.6895800e-05, 1.2097670e-04, 3.8850710e-05, 9.3176090e-04, 3.0930510e-04, 1.9011850e-03,
 2.3166520e-06, 4.4522570e-04, 4.0216160e-04, 1.9079020e-03, 1.6332790e-04, 1.9177640e-03, 1.1748550e-03, 1.0608690e-02,
 1.4616960e+00, 2.8861180e+00, 7.9330890e-01, 2.3132750e+00, 1.6547300e+00, 1.1678680e+01, 1.1613810e+00, 4.6278530e+00,
 3.2653200e-02, 1.8467420e+00, 4.9971790e-01, 1.5369080e+00, 1.6561580e+00, 5.7226570e+00, 1.0502310e+00, 6.1479450e+00,
 1.4478050e+00, 2.9604610e+00, 7.5498920e-01, 2.3659460e+00, 2.0266360e+00, 1.4812710e+01, 1.3666860e+00, 5.8526510e+00,
 3.8394130e-02, 2.2487310e+00, 5.6455900e-01, 1.8660000e+00, 2.9825720e+00, 1.0672820e+01, 1.8172700e+00, 1.1432570e+01,
 1.7599410e-01, 3.6991090e-01, 1.4059060e-01, 2.6960620e-01, 1.7601690e+00, 1.3224010e+01, 1.8183390e+00, 4.7650610e+00,
 2.3412290e-02, 1.4095040e+00, 5.2737040e-01, 1.0666640e+00, 1.8703620e+00, 6.8796080e+00, 1.7457490e+00, 6.7207180e+00,
 1.5009130e+00, 2.0449890e+00, 8.5339830e-01, 2.6120530e+00, 2.5884200e+00, 1.2606070e+01, 1.9032390e+00, 7.9605560e+00,
 3.1982980e-02, 1.2481810e+00, 5.1277750e-01, 1.6553790e+00, 5.0625090e+00, 1.2070910e+01, 3.3632560e+00, 2.0665710e+01,
 5.5284520e-02, 9.3599510e-02, 3.9743270e-02, 1.8873530e-01, 6.3374430e-02, 3.8352490e-01, 5.8916400e-02, 3.8233650e-01,
 1.1468610e-03, 5.5616570e-02, 2.3247950e-02, 1.1644280e-01, 6.1164360e-02, 1.8122050e-01, 5.1375530e-02, 4.8978580e-01,
 3.0860060e-02, 5.4107690e-02, 2.1315820e-02, 1.0878550e-01, 4.3742410e-02, 2.7414120e-01, 3.9072410e-02, 2.7249530e-01,
 7.5995870e-04, 3.8165910e-02, 1.4801620e-02, 7.9673930e-02, 6.2076580e-02, 1.9047100e-01, 5.0099230e-02, 5.1328680e-01,
 5.6936350e-03, 1.0261280e-02, 6.0245200e-03, 1.8814860e-02, 5.7661550e-02, 3.7145640e-01, 7.8900780e-02, 3.3672840e-01,
 7.0335400e-04, 3.6308590e-02, 2.0985560e-02, 6.9125350e-02, 5.9083680e-02, 1.8634530e-01, 7.3046300e-02, 4.5797000e-01,
 4.9716660e-02, 5.8083170e-02, 3.7443200e-02, 1.8664140e-01, 8.6820340e-02, 3.6255950e-01, 8.4557980e-02, 5.7598280e-01,
 9.8379330e-04, 3.2921190e-02, 2.0892410e-02, 1.0984030e-01, 1.6374290e-01, 3.3477240e-01, 1.4408920e-01, 1.4418710e+00,
 6.5207290e-01, 1.3974000e+00, 4.2120030e-01, 1.6776650e+00, 5.6989340e-01, 4.3654370e+00, 4.7604520e-01, 2.5911030e+00,
 1.6486280e-02, 1.0119770e+00, 3.0028180e-01, 1.2614900e+00, 5.2573270e-01, 1.9716440e+00, 3.9678510e-01, 3.1727220e+00,
 3.5847760e-01, 7.9557080e-01, 2.2248450e-01, 9.5234760e-01, 3.8739580e-01, 3.0731320e+00, 3.1092450e-01, 1.8187390e+00,
 1.0759070e-02, 6.8393480e-01, 1.8828950e-01, 8.5008050e-01, 5.2549300e-01, 2.0409040e+00, 3.8106820e-01, 3.2746020e+00,
 9.6171940e-02, 2.1938910e-01, 9.1435250e-02, 2.3950750e-01, 7.4256080e-01, 6.0549160e+00, 9.1297620e-01, 3.2680200e+00,
 1.4479450e-02, 9.4611070e-01, 3.8817810e-01, 1.0724440e+00, 7.2727750e-01, 2.9033920e+00, 8.0791060e-01, 4.2484340e+00,
 4.2979430e-01, 6.3557020e-01, 2.9084660e-01, 1.2159780e+00, 5.7222540e-01, 3.0246810e+00, 5.0076360e-01, 2.8609780e+00,
 1.0365300e-02, 4.3904400e-01, 1.9778760e-01, 8.7216590e-01, 1.0315610e+00, 2.6695420e+00, 8.1563590e-01, 6.8457080e+00,
 3.4479900e-08, 3.0366100e-07, 2.5361040e-07, 1.0083960e-06, 2.1675580e-07, 6.8234370e-06, 2.0617400e-06, 1.1202580e-05,
 2.4703780e-08, 6.2317470e-06, 5.1236370e-06, 2.1487240e-05, 4.1506370e-07, 6.3970040e-06, 3.5670880e-06, 2.8473320e-05,
 2.3250000e-07, 2.1205000e-06, 1.6431210e-06, 7.0212220e-06, 1.8072700e-06, 5.8917980e-05, 1.6517020e-05, 9.6448390e-05,
 1.9774540e-07, 5.1658880e-05, 3.9406400e-05, 1.7760210e-04, 5.0887120e-06, 8.1219810e-05, 4.2019640e-05, 3.6045890e-04,
 3.0154610e-09, 2.8269550e-08, 3.2645830e-08, 8.5365170e-08, 1.6747290e-07, 5.6120200e-06, 2.3446650e-06, 8.3782570e-06,
 1.2865550e-08, 3.4547500e-06, 3.9274980e-06, 1.0831960e-05, 3.4047520e-07, 5.5858520e-06, 4.3068270e-06, 2.2608440e-05,
 8.7971210e-08, 5.3461590e-07, 6.7787980e-07, 2.8291900e-06, 8.4246980e-07, 1.8300590e-05, 8.3951530e-06, 4.7880420e-05,
 6.0121890e-08, 1.0465440e-05, 1.3063470e-05, 5.7505080e-05, 3.1524990e-06, 3.3527030e-05, 2.8383440e-05, 2.3781240e-04,
 3.9637820e-01, 7.0887920e-01, 2.6926580e-01, 7.2854820e-01, 4.8322940e-01, 3.0890530e+00, 4.2450910e-01, 1.5695820e+00,
 1.1412170e-02, 5.8459380e-01, 2.1860180e-01, 6.2383380e-01, 4.3049400e-01, 1.3473130e+00, 3.4169330e-01, 1.8559820e+00,
 4.0345280e-01, 7.4721820e-01, 2.6333560e-01, 7.6571260e-01, 6.0817960e-01, 4.0262050e+00, 5.1334670e-01, 2.0397970e+00,
 1.3789150e-02, 7.3150170e-01, 2.5378620e-01, 7.7832750e-01, 7.9668420e-01, 2.5821400e+00, 6.0757650e-01, 3.5466420e+00,
 4.6464920e-02, 8.8456480e-02, 4.6458960e-02, 8.2667610e-02, 5.0044340e-01, 3.4054060e+00, 6.4708510e-01, 1.5734290e+00,
 7.9663760e-03, 4.3439880e-01, 2.2460470e-01, 4.2152470e-01, 4.7333150e-01, 1.5769170e+00, 5.5297770e-01, 1.9753030e+00,
 4.0060890e-01, 4.9438050e-01, 2.8510380e-01, 8.0970230e-01, 7.4400050e-01, 3.2818860e+00, 6.8472750e-01, 2.6574190e+00,
 1.1002050e-02, 3.8889990e-01, 2.2078520e-01, 6.6134880e-01, 1.2952200e+00, 2.7971970e+00, 1.0770200e+00, 6.1405370e+00,
 8.6067890e-02, 1.7910560e-01, 4.9832120e-02, 3.1025980e-01, 1.1001020e-01, 8.1829600e-01, 8.2368890e-02, 7.0080830e-01,
 2.4853820e-03, 1.4814420e-01, 4.0576550e-02, 2.6645840e-01, 1.2578180e-01, 4.5806250e-01, 8.5091040e-02, 1.0635560e+00,
 3.8350120e-02, 8.2647000e-02, 2.1334400e-02, 1.4274990e-01, 6.0611340e-02, 4.6689980e-01, 4.3604330e-02, 3.9869880e-01,
 1.3146330e-03, 8.1149960e-02, 2.0622060e-02, 1.4553440e-01, 1.0190120e-01, 3.8430730e-01, 6.6235530e-02, 8.8970590e-01,
 1.1010530e-02, 2.4390370e-02, 9.3831660e-03, 3.8419740e-02, 1.2433290e-01, 9.8447750e-01, 1.3702170e-01, 7.6668030e-01,
 1.8933780e-03, 1.2013530e-01, 4.5497980e-02, 1.9648770e-01, 1.5092730e-01, 5.8508220e-01, 1.5028190e-01, 1.2352990e+00,
 6.2689040e-02, 9.0019800e-02, 3.8025140e-02, 2.4850340e-01, 1.2206530e-01, 6.2653920e-01, 9.5748870e-02, 8.5509640e-01,
 1.7267840e-03, 7.1024450e-02, 2.9534600e-02, 2.0357800e-01, 2.7273050e-01, 6.8536040e-01, 1.9329060e-01, 2.5359020e+00,
 1.2750360e+00, 3.3584980e+00, 6.6331990e-01, 3.4639050e+00, 1.2425130e+00, 1.1698580e+01, 8.3591830e-01, 5.9652240e+00,
 4.4873870e-02, 3.3856310e+00, 6.5827600e-01, 3.6256780e+00, 1.3579160e+00, 6.2594240e+00, 8.2541320e-01, 8.6531570e+00,
 5.5952650e-01, 1.5262850e+00, 2.7968340e-01, 1.5695990e+00, 6.7420930e-01, 6.5738400e+00, 4.3581580e-01, 3.3422970e+00,
 2.3376410e-02, 1.8264850e+00, 3.2948650e-01, 1.9502850e+00, 1.0834460e+00, 5.1720300e+00, 6.3277780e-01, 7.1290810e+00,
 2.3359070e-01, 6.5496850e-01, 1.7886660e-01, 6.1427240e-01, 2.0110390e+00, 2.0155550e+01, 1.9913890e+00, 9.3456160e+00,
 4.8955760e-02, 3.9318050e+00, 1.0570390e+00, 3.8287870e+00, 2.3333990e+00, 1.1449660e+01, 2.0876630e+00, 1.4393040e+01,
 6.8067350e-01, 1.2372000e+00, 3.7098000e-01, 2.0334750e+00, 1.0104770e+00, 6.5650350e+00, 7.1219740e-01, 5.3346830e+00,
 2.2850970e-02, 1.1896770e+00, 3.5118030e-01, 2.0302830e+00, 2.1580170e+00, 6.8642770e+00, 1.3742460e+00, 1.5122130e+01,
 1.2687530e-05, 1.3734030e-04, 7.5159930e-05, 3.9181130e-04, 8.8932990e-05, 3.4410700e-03, 6.8129380e-04, 4.8533870e-03,
 1.2653750e-05, 3.9234090e-03, 2.1136950e-03, 1.1621740e-02, 2.0174720e-04, 3.8217960e-03, 1.3964160e-03, 1.4613880e-02,
 6.8291470e-05, 7.6556100e-04, 3.8870600e-04, 2.1776640e-03, 5.9189930e-04, 2.3717590e-02, 4.3567710e-03, 3.3354490e-02,
 8.0852700e-05, 2.5961580e-02, 1.2976660e-02, 7.6678040e-02, 1.9743910e-03, 3.8733370e-02, 1.3130630e-02, 1.4767790e-01,
 1.3783070e-06, 1.5882140e-05, 1.2017890e-05, 4.1200980e-05, 8.5352840e-05, 3.5155290e-03, 9.6241490e-04, 4.5088080e-03,
 8.1858730e-06, 2.7017900e-03, 2.0126160e-03, 7.2774410e-03, 2.0556980e-04, 4.1453520e-03, 2.0943030e-03, 1.4413820e-02,
 2.6218250e-05, 1.9584080e-04, 1.6271370e-04, 8.9034830e-04, 2.7996170e-04, 7.4749370e-03, 2.2468870e-03, 1.6801070e-02,
 2.4942520e-05, 5.3365820e-03, 4.3649020e-03, 2.5191190e-02, 1.2410800e-03, 1.6223260e-02, 8.9994920e-03, 9.8858510e-02,
 7.3235300e-01, 1.6098340e+00, 4.0068230e-01, 1.4213590e+00, 9.9550920e-01, 7.8219540e+00, 7.0434770e-01, 3.4143700e+00,
 2.9351050e-02, 1.8480240e+00, 4.5281120e-01, 1.6941770e+00, 1.0506530e+00, 4.0416510e+00, 6.7164070e-01, 4.7830040e+00,
 5.9502590e-01, 1.3545300e+00, 3.1279580e-01, 1.1924590e+00, 1.0001290e+00, 8.1380120e+00, 6.7989740e-01, 3.5419790e+00,
 2.8309040e-02, 1.8458700e+00, 4.1962750e-01, 1.6872710e+00, 1.5520690e+00, 6.1830480e+00, 9.5330960e-01, 7.2958660e+00,
 1.0663920e-01, 2.4952810e-01, 8.5875540e-02, 2.0033730e-01, 1.2806420e+00, 1.0711240e+01, 1.3336520e+00, 4.2516240e+00,
 2.5450550e-02, 1.7057800e+00, 5.7791430e-01, 1.4219820e+00, 1.4349570e+00, 5.8759800e+00, 1.3501730e+00, 6.3232720e+00,
 5.9949190e-01, 9.0933130e-01, 3.4361650e-01, 1.2794480e+00, 1.2414150e+00, 6.7307810e+00, 9.2017400e-01, 4.6820790e+00,
 2.2918230e-02, 9.9573400e-01, 3.7041240e-01, 1.4546970e+00, 2.5602820e+00, 6.7961910e+00, 1.7146540e+00, 1.2816970e+01,
 9.5822910e-02, 1.6320990e-01, 6.4480750e-02, 3.3289150e-01, 1.0349890e-01, 6.3011870e-01, 9.0065540e-02, 6.3540590e-01,
 2.8579080e-03, 1.3942760e-01, 5.4227890e-02, 2.9527970e-01, 1.7366790e-01, 5.1764930e-01, 1.3654580e-01, 1.4151780e+00,
 2.8794290e-02, 5.0789710e-02, 1.8617120e-02, 1.0329140e-01, 3.8456370e-02, 2.4246390e-01, 3.2154110e-02, 2.4378570e-01,
 1.0194620e-03, 5.1506720e-02, 1.8586220e-02, 1.0876300e-01, 9.4883970e-02, 2.9288760e-01, 7.1679800e-02, 7.9837850e-01,
 9.1809300e-03, 1.6645840e-02, 9.0932730e-03, 3.0873210e-02, 8.7607090e-02, 5.6776400e-01, 1.1221090e-01, 5.2061470e-01,
 1.6305820e-03, 8.4680820e-02, 4.5539670e-02, 1.6307580e-01, 1.5607020e-01, 4.9519690e-01, 1.8061400e-01, 1.2310430e+00,
 4.2625300e-02, 5.0098280e-02, 3.0049630e-02, 1.6283850e-01, 7.0136310e-02, 2.9465090e-01, 6.3940600e-02, 4.7349420e-01,
 1.2126650e-03, 4.0824390e-02, 2.4106070e-02, 1.3777890e-01, 2.2997640e-01, 4.7301790e-01, 1.8943180e-01, 2.0607770e+00,
 6.7977770e-01, 1.4655430e+00, 4.1101730e-01, 1.7797520e+00, 5.5978380e-01, 4.3138150e+00, 4.3769910e-01, 2.5899720e+00,
 2.4709560e-02, 1.5258790e+00, 4.2128110e-01, 1.9240210e+00, 8.9782380e-01, 3.3873630e+00, 6.3428170e-01, 5.5136840e+00,
 2.0117620e-01, 4.4915940e-01, 1.1687330e-01, 5.4386830e-01, 2.0484500e-01, 1.6347780e+00, 1.5389560e-01, 9.7864390e-01,
 8.6808190e-03, 5.5514700e-01, 1.4220440e-01, 6.9795900e-01, 4.8309990e-01, 1.8875550e+00, 3.2792410e-01, 3.0634600e+00,
 9.3271800e-02, 2.1405440e-01, 8.3007310e-02, 2.3637670e-01, 6.7856260e-01, 5.5663840e+00, 7.8094070e-01, 3.0389700e+00,
 2.0189500e-02, 1.3271580e+00, 5.0664680e-01, 1.5217100e+00, 1.1554670e+00, 4.6405570e+00, 1.2014930e+00, 6.8686280e+00,
 2.2163130e-01, 3.2971680e-01, 1.4038970e-01, 6.3808720e-01, 2.7803120e-01, 1.4784720e+00, 2.2775070e-01, 1.4145700e+00,
 7.6846450e-03, 3.2745920e-01, 1.3725930e-01, 6.5799830e-01, 8.7140650e-01, 2.2686610e+00, 6.4494520e-01, 5.8847480e+00,
 8.9875560e-06, 7.9629090e-05, 6.1879030e-05, 2.6747950e-04, 5.3235610e-05, 1.6859390e-03, 4.7398690e-04, 2.7998400e-03,
 9.2578620e-06, 2.3494390e-03, 1.7973240e-03, 8.1942950e-03, 1.7723350e-04, 2.7479880e-03, 1.4257570e-03, 1.2372370e-02,
 3.2624390e-05, 2.9934000e-04, 2.1581900e-04, 1.0025730e-03, 2.3894530e-04, 7.8366490e-03, 2.0441270e-03, 1.2976400e-02,
 3.9893070e-05, 1.0484390e-02, 7.4414660e-03, 3.6460530e-02, 1.1697220e-03, 1.8782090e-02, 9.0412390e-03, 8.4316850e-02,
 7.3124120e-07, 6.8965650e-06, 7.4102930e-06, 2.1065480e-05, 3.8265510e-05, 1.2899980e-03, 5.0146930e-04, 1.9480500e-03,
 4.4854570e-06, 1.2117200e-03, 1.2817260e-03, 3.8429910e-03, 1.3525330e-04, 2.2323320e-03, 1.6014760e-03, 9.1393760e-03,
 1.1342690e-05, 6.9346470e-05, 8.1814210e-05, 3.7121130e-04, 1.0234950e-04, 2.2366780e-03, 9.5468610e-04, 5.9193350e-03,
 1.1144990e-05, 1.9516920e-03, 2.2667630e-03, 1.0847680e-02, 6.6586420e-04, 7.1241490e-03, 5.6117250e-03, 5.1115080e-02,
 4.0870470e-01, 7.3532470e-01, 2.5988530e-01, 7.6443710e-01, 4.6947140e-01, 3.0191740e+00, 3.8604990e-01, 1.5517560e+00,
 1.6917640e-02, 8.7183170e-01, 3.0333720e-01, 9.4107440e-01, 7.2714710e-01, 2.2894470e+00, 5.4024690e-01, 3.1901610e+00,
 2.2394240e-01, 4.1725170e-01, 1.3682140e-01, 4.3250700e-01, 3.1807630e-01, 2.1183740e+00, 2.5131080e-01, 1.0856010e+00,
 1.1004050e-02, 5.8726970e-01, 1.8957620e-01, 6.3206430e-01, 7.2441130e-01, 2.3620320e+00, 5.1713110e-01, 3.2817090e+00,
 4.4571390e-02, 8.5362620e-02, 4.1715860e-02, 8.0695640e-02, 4.5231590e-01, 3.0964420e+00, 5.4745580e-01, 1.4471640e+00,
 1.0986600e-02, 6.0269600e-01, 2.8994930e-01, 5.9157430e-01, 7.4379260e-01, 2.4928850e+00, 8.1338230e-01, 3.1586670e+00,
 2.0432430e-01, 2.5366930e-01, 1.3611410e-01, 4.2025080e-01, 3.5754330e-01, 1.5866670e+00, 3.0801640e-01, 1.2995680e+00,
 8.0676080e-03, 2.8689040e-01, 1.5154500e-01, 4.9349790e-01, 1.0821770e+00, 2.3511750e+00, 8.4232430e-01, 5.2208940e+00,
 3.9599710e-01, 7.4021310e-01, 2.2743950e-01, 1.1640280e+00, 3.8054180e-01, 2.5425910e+00, 2.8264310e-01, 1.9767690e+00,
 1.0386800e-02, 5.5612150e-01, 1.6821670e-01, 9.0804000e-01, 5.2096180e-01, 1.7041570e+00, 3.4960500e-01, 3.5919920e+00,
 1.8847780e-01, 3.6485240e-01, 1.0401110e-01, 5.7207920e-01, 2.2395770e-01, 1.5496460e+00, 1.5982600e-01, 1.2012800e+00,
 5.8686170e-03, 3.2539890e-01, 9.1320610e-02, 5.2976550e-01, 4.5082740e-01, 1.5272360e+00, 2.9068820e-01, 3.2096990e+00,
 3.6551020e-02, 7.2728780e-02, 3.0899130e-02, 1.0399980e-01, 3.1031020e-01, 2.2070510e+00, 3.3923840e-01, 1.5603110e+00,
 5.7090800e-03, 3.2538400e-01, 1.3609010e-01, 4.8311580e-01, 4.5102060e-01, 1.5705150e+00, 4.4549310e-01, 3.0101460e+00,
 2.8627700e-01, 3.6925770e-01, 1.7225480e-01, 9.2536740e-01, 4.1908870e-01, 1.9322280e+00, 3.2610160e-01, 2.3939530e+00,
 7.1626000e-03, 2.6462880e-01, 1.2152600e-01, 6.8857360e-01, 1.1211560e+00, 2.5307420e+00, 7.8822230e-01, 8.5006430e+00,
 2.5665770e+00, 6.0725850e+00, 1.3245260e+00, 5.6857140e+00, 1.8804060e+00, 1.5903050e+01, 1.2549320e+00, 7.3614670e+00,
 8.2047080e-02, 5.5603970e+00, 1.1939420e+00, 5.4056240e+00, 2.4606060e+00, 1.0188270e+01, 1.4837010e+00, 1.2785890e+01,
 1.2030820e+00, 2.9478590e+00, 5.9655000e-01, 2.7520120e+00, 1.0899030e+00, 9.5457260e+00, 6.9887870e-01, 4.4058050e+00,
 4.5655170e-02, 3.2042390e+00, 6.3834500e-01, 3.1059700e+00, 2.0971000e+00, 8.9922730e+00, 1.2149790e+00, 1.1252070e+01,
 3.3925630e-01, 8.5445520e-01, 2.5769570e-01, 7.2747880e-01, 2.1958940e+00, 1.9768890e+01, 2.1570130e+00, 8.3211990e+00,
 6.4582340e-02, 4.6590620e+00, 1.3832690e+00, 4.1186810e+00, 3.0506940e+00, 1.3446180e+01, 2.7075450e+00, 1.5344370e+01,
 1.3599250e+00, 2.2203040e+00, 7.3524510e-01, 3.3128500e+00, 1.5178230e+00, 8.8578500e+00, 1.0612080e+00, 6.5341680e+00,
 4.1468500e-02, 1.9392740e+00, 6.3219250e-01, 3.0043970e+00, 3.8812200e+00, 1.1089310e+01, 2.4517910e+00, 2.2177540e+01,
 4.8942640e-05, 4.7588840e-04, 2.8760900e-04, 1.2324640e-03, 2.5792420e-04, 8.9643590e-03, 1.9600590e-03, 1.1477860e-02,
 4.4337090e-05, 1.2348330e-02, 7.3467620e-03, 3.3205200e-02, 7.0057590e-04, 1.1920980e-02, 4.8102550e-03, 4.1380930e-02,
 2.8139700e-04, 2.8335400e-03, 1.5888390e-03, 7.3169650e-03, 1.8336630e-03, 6.5999240e-02, 1.3388810e-02, 8.4258380e-02,
 3.0261130e-04, 8.7280750e-02, 4.8179170e-02, 2.3401770e-01, 7.3235800e-03, 1.2905420e-01, 4.8314970e-02, 4.4667640e-01,
 3.8361600e-06, 3.9706030e-05, 3.3180620e-05, 9.3507270e-05, 1.7860250e-04, 6.6077970e-03, 1.9977330e-03, 7.6933980e-03,
 2.0694430e-05, 6.1353100e-03, 5.0472530e-03, 1.5002170e-02, 5.1504770e-04, 9.3292360e-03, 5.2051490e-03, 2.9447890e-02,
 1.0038250e-04, 6.7352570e-04, 6.1799390e-04, 2.7797220e-03, 8.0588270e-04, 1.9327570e-02, 6.4159350e-03, 3.9436390e-02,
 8.6742610e-05, 1.6670620e-02, 1.5058170e-02, 7.1437750e-02, 4.2775150e-03, 5.0225750e-02, 3.0769140e-02, 2.7783880e-01,
 2.1955280e+00, 4.3350700e+00, 1.1915830e+00, 3.4746350e+00, 2.2437910e+00, 1.5836130e+01, 1.5748160e+00, 6.2753030e+00,
 7.9924480e-02, 4.5202280e+00, 1.2231480e+00, 3.7618550e+00, 2.8354060e+00, 9.7974090e+00, 1.7980360e+00, 1.0525520e+01,
 1.9054470e+00, 3.8962460e+00, 9.9363680e-01, 3.1138070e+00, 2.4078860e+00, 1.7599270e+01, 1.6237860e+00, 6.9536480e+00,
 8.2342450e-02, 4.8227690e+00, 1.2107880e+00, 4.0019400e+00, 4.4741380e+00, 1.6010230e+01, 2.7260760e+00, 1.7149930e+01,
 2.3066190e-01, 4.8481380e-01, 1.8426120e-01, 3.5335210e-01, 2.0825980e+00, 1.5646390e+01, 2.1514230e+00, 5.6379270e+00,
 5.0002720e-02, 3.0103440e+00, 1.1263300e+00, 2.2781250e+00, 2.7940550e+00, 1.0277160e+01, 2.6079010e+00, 1.0039800e+01,
 1.7837990e+00, 2.4304200e+00, 1.0142430e+00, 3.1043620e+00, 2.7771440e+00, 1.3525190e+01, 2.0420050e+00, 8.5409650e+00,
 6.1941440e-02, 2.4173530e+00, 9.9309630e-01, 3.2059730e+00, 6.8578450e+00, 1.6351670e+01, 4.5559810e+00, 2.7994470e+01,
 6.9109760e-02, 1.1700630e-01, 4.9682040e-02, 2.3593320e-01, 7.1519270e-02, 4.3281530e-01, 6.6488300e-02, 4.3147420e-01,
 2.3362470e-03, 1.1329540e-01, 4.7357910e-02, 2.3720310e-01, 8.7149690e-02, 2.5821100e-01, 7.3202140e-02, 6.9786850e-01,
 3.3801620e-02, 5.9265200e-02, 2.3347630e-02, 1.1915480e-01, 4.3253040e-02, 2.7107430e-01, 3.8635290e-02, 2.6944670e-01,
 1.3564470e-03, 6.8122160e-02, 2.6419340e-02, 1.4220960e-01, 7.7499720e-02, 2.3779420e-01, 6.2546560e-02, 6.4081470e-01,
 6.2104240e-03, 1.1192660e-02, 6.5713430e-03, 2.0522610e-02, 5.6779440e-02, 3.6577390e-01, 7.7693760e-02, 3.3157720e-01,
 1.2501950e-03, 6.4537630e-02, 3.7301320e-02, 1.2286860e-01, 7.3456580e-02, 2.3167630e-01, 9.0815810e-02, 5.6937740e-01,
 4.9175200e-02, 5.7450590e-02, 3.7035410e-02, 1.8460870e-01, 7.7524490e-02, 3.2374020e-01, 7.5504360e-02, 5.1431230e-01,
 1.5856970e-03, 5.3063000e-02, 3.3674790e-02, 1.7704270e-01, 1.8460280e-01, 3.7742040e-01, 1.6244530e-01, 1.6255570e+00,
 6.5357980e-01, 1.4006290e+00, 4.2217360e-01, 1.6815410e+00, 5.1566690e-01, 3.9500570e+00, 4.3074860e-01, 2.3445540e+00,
 2.6927570e-02, 1.6528950e+00, 4.9045990e-01, 2.0604320e+00, 6.0061890e-01, 2.2524880e+00, 4.5330380e-01, 3.6246500e+00,
 3.1482510e-01, 6.9869270e-01, 1.9539220e-01, 8.3637850e-01, 3.0713940e-01, 2.4364740e+00, 2.4651050e-01, 1.4419530e+00,
 1.5397630e-02, 9.7880050e-01, 2.6946700e-01, 1.2165770e+00, 5.2602450e-01, 2.0429680e+00, 3.8145350e-01, 3.2779140e+00,
 8.4109800e-02, 1.9187270e-01, 7.9967200e-02, 2.0946780e-01, 5.8627780e-01, 4.7805690e+00, 7.2082670e-01, 2.5802170e+00,
 2.0635840e-02, 1.3483800e+00, 5.5322440e-01, 1.5284280e+00, 7.2498660e-01, 2.8942460e+00, 8.0536570e-01, 4.2350520e+00,
 3.4085640e-01, 5.0405090e-01, 2.3066140e-01, 9.6435450e-01, 4.0968600e-01, 2.1655270e+00, 3.5852280e-01, 2.0483230e+00,
 1.3395680e-02, 5.6740210e-01, 2.5561240e-01, 1.1271510e+00, 9.3247540e-01, 2.4131210e+00, 7.3729060e-01, 6.1881490e+00,
 6.1469210e-07, 5.4135320e-06, 4.5212530e-06, 1.7977230e-05, 3.4884750e-06, 1.0981660e-04, 3.3181720e-05, 1.8029470e-04,
 7.1767390e-07, 1.8103960e-04, 1.4884770e-04, 6.2422970e-04, 8.4340860e-06, 1.2998700e-04, 7.2483150e-05, 5.7857720e-04,
 3.6317810e-06, 3.3123390e-05, 2.5666470e-05, 1.0967540e-04, 2.5485490e-05, 8.3084060e-04, 2.3291730e-04, 1.3600810e-03,
 5.0335580e-06, 1.3149630e-03, 1.0030800e-03, 4.5208170e-03, 9.0601660e-05, 1.4460730e-03, 7.4813600e-04, 6.4177680e-03,
 4.6907390e-08, 4.3975050e-07, 5.0782640e-07, 1.3279090e-06, 2.3518270e-06, 7.8809740e-05, 3.2926190e-05, 1.1765610e-04,
 3.2612780e-07, 8.7574210e-05, 9.9557870e-05, 2.7457870e-04, 6.0367700e-06, 9.9039530e-05, 7.6361860e-05, 4.0085720e-04,
 1.2409110e-06, 7.5412260e-06, 9.5620890e-06, 3.9908200e-05, 1.0728220e-05, 2.3304430e-04, 1.0690600e-04, 6.0972110e-04,
 1.3819900e-06, 2.4056340e-04, 3.0028300e-04, 1.3218380e-03, 5.0685840e-05, 5.3904720e-04, 4.5634850e-04, 3.8235450e-03,
 3.6550410e-01, 6.5366410e-01, 2.4829250e-01, 6.7180110e-01, 4.0226200e-01, 2.5714670e+00, 3.5338050e-01, 1.3065910e+00,
 1.7148370e-02, 8.7843310e-01, 3.2847940e-01, 9.3739660e-01, 4.5246090e-01, 1.4160620e+00, 3.5912900e-01, 1.9506870e+00,
 3.2597190e-01, 6.0371890e-01, 2.1276340e-01, 6.1866160e-01, 4.4360090e-01, 2.9366790e+00, 3.7443060e-01, 1.4878100e+00,
 1.8155020e-02, 9.6310750e-01, 3.3413920e-01, 1.0247590e+00, 7.3367750e-01, 2.3779280e+00, 5.5952550e-01, 3.2661510e+00,
 3.7385520e-02, 7.1171790e-02, 3.7380720e-02, 6.6514080e-02, 3.6350160e-01, 2.4735480e+00, 4.7001620e-01, 1.1428750e+00,
 1.0445060e-02, 5.6955920e-01, 2.9448900e-01, 5.5267940e-01, 4.3408550e-01, 1.4461670e+00, 5.0712780e-01, 1.8115220e+00,
 2.9228830e-01, 3.6070500e-01, 2.0801460e-01, 5.9076690e-01, 4.9004640e-01, 2.1616600e+00, 4.5100550e-01, 1.7503470e+00,
 1.3080870e-02, 4.6238180e-01, 2.6250210e-01, 7.8630940e-01, 1.0771240e+00, 2.3261910e+00, 8.9566610e-01, 5.1065630e+00,
};

static const double acc_discore_plus[16] =
{3.6677778e-02, 1.3913043e-04, 1.4782609e-04, 1.1111111e-04, 5.9003382e-02, 2.2381853e-04, 2.3780718e-04, 1.7874396e-04,
 1.5795365e+01, 5.9916824e-02, 6.3661626e-02, 4.7850242e-02, 4.0753086e-02, 1.5458937e-04, 1.6425121e-04, 1.2345679e-04,
};

static const double acc_score467_plus[16384] =
{2.1576185e+00, 1.9874195e+00, 2.1497267e+00, 2.1717103e+00, 2.1086518e+00, 1.8971964e+00, 2.1286880e+00, 2.0912386e+00,
 1.3086940e+00, 1.2002561e+00, 1.2983313e+00, 1.3114790e+00, 1.9625977e+00, 1.7875270e+00, 1.9679379e+00, 1.9873573e+00,
 1.5723068e+00, 1.2505688e+00, 1.3822942e+00, 1.5452415e+00, 1.3589596e+00, 1.0557695e+00, 1.2105106e+00, 1.3159433e+00,
 8.3376903e-01, 6.6029337e-01, 7.2987380e-01, 8.1583188e-01, 1.3793613e+00, 1.0848116e+00, 1.2204291e+00, 1.3638111e+00,
 1.0165542e+00, 8.7149010e-01, 9.6168793e-01, 1.0014942e+00, 9.0512928e-01, 7.5793975e-01, 8.6758634e-01, 8.7861851e-01,
 5.6195873e-01, 4.7968595e-01, 5.2935468e-01, 5.5121173e-01, 9.4483095e-01, 8.0092514e-01, 8.9955799e-01, 9.3646086e-01,
 1.4435916e+00, 1.2624148e+00, 1.3553983e+00, 1.4662029e+00, 1.3167378e+00, 1.1247329e+00, 1.2526229e+00, 1.3177118e+00,
 7.9630589e-01, 6.9335960e-01, 7.4446016e-01, 8.0524038e-01, 1.4344308e+00, 1.2403471e+00, 1.3554196e+00, 1.4657043e+00,
 1.0161911e+00, 9.6223059e-01, 1.2073705e+00, 1.2544187e+00, 1.2369140e+00, 1.1440255e+00, 1.4890291e+00, 1.5044505e+00,
 8.2010554e-01, 7.7320456e-01, 9.7022840e-01, 1.0079356e+00, 1.1428037e+00, 1.0699953e+00, 1.3664964e+00, 1.4192410e+00,
 9.7692514e-01, 7.9876759e-01, 1.0241917e+00, 1.1774979e+00, 1.0516333e+00, 8.3987714e-01, 1.1170764e+00, 1.2489205e+00,
 6.8928800e-01, 5.6115222e-01, 7.1954729e-01, 8.2717142e-01, 1.0595987e+00, 8.5665659e-01, 1.1179770e+00, 1.2848651e+00,
 7.4522716e-01, 6.5676388e-01, 8.4071519e-01, 9.0042278e-01, 8.2642313e-01, 7.1140246e-01, 9.4462866e-01, 9.8385670e-01,
 5.4814247e-01, 4.8098866e-01, 6.1573304e-01, 6.5939738e-01, 8.5635106e-01, 7.4624011e-01, 9.7226224e-01, 1.0409432e+00,
 9.9137386e-01, 8.9121783e-01, 1.1099839e+00, 1.2348860e+00, 1.1262278e+00, 9.8892893e-01, 1.2776266e+00, 1.3822514e+00,
 7.2761913e-01, 6.5128537e-01, 8.1118928e-01, 9.0237980e-01, 1.2179018e+00, 1.0825920e+00, 1.3723444e+00, 1.5262257e+00,
 3.9003989e-01, 2.9232852e-01, 3.4754591e-01, 3.8705571e-01, 4.2487256e-01, 3.1103794e-01, 3.8358389e-01, 4.1542716e-01,
 2.7145267e-01, 2.0257094e-01, 2.4084416e-01, 2.6819748e-01, 2.3724839e-01, 1.7582144e-01, 2.1275413e-01, 2.3685649e-01,
 2.3407373e+00, 1.5148524e+00, 1.8403925e+00, 2.2680317e+00, 2.2549732e+00, 1.4254476e+00, 1.7963788e+00, 2.1528278e+00,
 1.4242390e+00, 9.1774323e-01, 1.1150115e+00, 1.3739633e+00, 1.3731909e+00, 8.7872796e-01, 1.0865766e+00, 1.3385806e+00,
 1.7416674e+00, 1.2149109e+00, 1.4735448e+00, 1.6916886e+00, 1.7284812e+00, 1.1777035e+00, 1.4817035e+00, 1.6542147e+00,
 1.1047416e+00, 7.6729198e-01, 9.3067388e-01, 1.0683463e+00, 1.0824963e+00, 7.4664064e-01, 9.2171348e-01, 1.0577892e+00,
 2.4144018e+00, 1.7179655e+00, 2.0273404e+00, 2.4176673e+00, 2.4546179e+00, 1.7060082e+00, 2.0883325e+00, 2.4218222e+00,
 1.5281529e+00, 1.0826612e+00, 1.2776823e+00, 1.5235251e+00, 1.6042876e+00, 1.1287384e+00, 1.3557236e+00, 1.6161678e+00,
 1.4144331e+00, 1.2140974e+00, 1.4164160e+00, 1.4714944e+00, 1.4594273e+00, 1.2236186e+00, 1.4807762e+00, 1.4959949e+00,
 9.5815537e-01, 8.1889449e-01, 9.5539564e-01, 9.9244844e-01, 1.4026977e+00, 1.1905334e+00, 1.4136577e+00, 1.4681070e+00,
 1.0352995e+00, 7.6734841e-01, 9.1480625e-01, 1.0516566e+00, 9.4472403e-01, 6.8394934e-01, 8.4579831e-01, 9.4555017e-01,
 6.1314697e-01, 4.5249306e-01, 5.3946897e-01, 6.2010939e-01, 9.9022008e-01, 7.2571205e-01, 8.8057498e-01, 1.0119450e+00,
 1.0288401e+00, 8.2193233e-01, 9.7825314e-01, 1.0476466e+00, 9.6715907e-01, 7.5470661e-01, 9.3175064e-01, 9.7036795e-01,
 6.3520211e-01, 5.0526673e-01, 6.0138712e-01, 6.4398366e-01, 1.0425492e+00, 8.2355159e-01, 9.9763483e-01, 1.0680239e+00,
 1.0391744e+00, 8.4684211e-01, 9.8064329e-01, 1.0909053e+00, 1.0007218e+00, 7.9656193e-01, 9.5682901e-01, 1.0351024e+00,
 6.4019806e-01, 5.1945644e-01, 6.0155555e-01, 6.6912747e-01, 1.1257681e+00, 9.0712853e-01, 1.0691607e+00, 1.1889526e+00,
 1.4823193e+00, 2.6124234e+00, 1.5803511e+00, 1.4854100e+00, 1.3588902e+00, 2.3392609e+00, 1.4678945e+00, 1.3417159e+00,
 1.3868539e+00, 2.4336238e+00, 1.4722501e+00, 1.3836663e+00, 1.4261513e+00, 2.4852712e+00, 1.5302034e+00, 1.4377642e+00,
 1.1159241e+00, 1.6982116e+00, 1.0497872e+00, 1.0918706e+00, 9.0472434e-01, 1.3448250e+00, 8.6234581e-01, 8.7221661e-01,
 9.1278579e-01, 1.3830781e+00, 8.5501563e-01, 8.8920311e-01, 1.0354819e+00, 1.5581377e+00, 9.8034904e-01, 1.0192864e+00,
 7.8344253e-01, 1.2850676e+00, 7.9307477e-01, 7.6842683e-01, 6.5433409e-01, 1.0483600e+00, 6.7112757e-01, 6.3236328e-01,
 6.6804644e-01, 1.0910536e+00, 6.7336769e-01, 6.5237605e-01, 7.7019027e-01, 1.2491738e+00, 7.8465082e-01, 7.5999527e-01,
 1.1398976e+00, 1.9072618e+00, 1.1452278e+00, 1.1526381e+00, 9.7528928e-01, 1.5939331e+00, 9.9279076e-01, 9.7169860e-01,
 9.6990026e-01, 1.6158181e+00, 9.7026854e-01, 9.7645019e-01, 1.1980320e+00, 1.9820698e+00, 1.2113396e+00, 1.2187440e+00,
 6.7615051e-01, 1.2249937e+00, 8.5963077e-01, 8.3097478e-01, 7.7200432e-01, 1.3661644e+00, 9.9445898e-01, 9.3483662e-01,
 8.4171150e-01, 1.5183604e+00, 1.0655426e+00, 1.0299204e+00, 8.0427920e-01, 1.4408004e+00, 1.0290751e+00, 9.9441726e-01,
 6.7152100e-01, 1.0505231e+00, 7.5332588e-01, 8.0581603e-01, 6.7807075e-01, 1.0361276e+00, 7.7072050e-01, 8.0171992e-01,
 7.3084382e-01, 1.1383908e+00, 8.1636906e-01, 8.7316553e-01, 7.7038367e-01, 1.1916786e+00, 8.6976481e-01, 9.3003732e-01,
 5.5624495e-01, 9.3793723e-01, 6.7147486e-01, 6.6911571e-01, 5.7861837e-01, 9.5299820e-01, 7.0770867e-01, 6.8580256e-01,
 6.3109762e-01, 1.0595577e+00, 7.5857554e-01, 7.5583598e-01, 6.7607767e-01, 1.1272240e+00, 8.2135624e-01, 8.1818039e-01,
 7.5815798e-01, 1.3040467e+00, 9.0832747e-01, 9.4021367e-01, 8.0790610e-01, 1.3573337e+00, 9.8071326e-01, 9.8718615e-01,
 8.5832525e-01, 1.4699622e+00, 1.0239378e+00, 1.0597773e+00, 9.8514871e-01, 1.6754876e+00, 1.1878348e+00, 1.2290960e+00,
 2.4620112e-01, 3.5305226e-01, 2.3474508e-01, 2.4323827e-01, 2.5156600e-01, 3.5236557e-01, 2.4302840e-01, 2.4488681e-01,
 2.6430204e-01, 3.7737268e-01, 2.5092617e-01, 2.5997915e-01, 1.5839864e-01, 2.2459854e-01, 1.5199511e-01, 1.5743849e-01,
 1.5263844e+00, 1.8900291e+00, 1.2841777e+00, 1.4724409e+00, 1.3793197e+00, 1.6682522e+00, 1.1757765e+00, 1.3110229e+00,
 1.4325821e+00, 1.7662208e+00, 1.2001059e+00, 1.3759074e+00, 9.4712984e-01, 1.1596313e+00, 8.0194018e-01, 9.1917961e-01,
 1.2332629e+00, 1.6459695e+00, 1.1164960e+00, 1.1925823e+00, 1.1480674e+00, 1.4966687e+00, 1.0530949e+00, 1.0938852e+00,
 1.2066373e+00, 1.6034797e+00, 1.0877198e+00, 1.1617306e+00, 8.1074465e-01, 1.0699321e+00, 7.3868122e-01, 7.8874047e-01,
 1.7516402e+00, 2.3847157e+00, 1.5738576e+00, 1.7462611e+00, 1.6704432e+00, 2.2213434e+00, 1.5207246e+00, 1.6408440e+00,
 1.7101242e+00, 2.3181440e+00, 1.5299844e+00, 1.6974148e+00, 1.2310761e+00, 1.6572302e+00, 1.1132096e+00, 1.2347141e+00,
 1.0065242e+00, 1.6530355e+00, 1.0785396e+00, 1.0425037e+00, 9.7417409e-01, 1.5627413e+00, 1.0576622e+00, 9.9417223e-01,
 1.0517277e+00, 1.7198174e+00, 1.1221582e+00, 1.0845580e+00, 1.0557797e+00, 1.7145005e+00, 1.1385622e+00, 1.1001304e+00,
 7.6109364e-01, 1.0793233e+00, 7.1962237e-01, 7.6970366e-01, 6.5146265e-01, 9.0239191e-01, 6.2410077e-01, 6.4915196e-01,
 6.9528397e-01, 9.8174014e-01, 6.5458730e-01, 7.0007317e-01, 7.6996522e-01, 1.0796691e+00, 7.3267119e-01, 7.8338198e-01,
 8.2129528e-01, 1.2553773e+00, 8.3561481e-01, 8.3261361e-01, 7.2420459e-01, 1.0812562e+00, 7.4656367e-01, 7.2339815e-01,
 7.8214779e-01, 1.1903767e+00, 7.923815