/*==============================================================================

FICHIER     : [rdtsc.h]

DATE        : 2006/03/0001 21:28:47

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __RDTSC_H__
#define __RDTSC_H__

#define ENABLE_COUNTERS		0

typedef struct {
	char *			name;
	unsigned int 		sLow, sHigh;
	unsigned long long	sumTsc;
} Counter_t;

#define OVERALL_COUNTER		0
#define COPYCELL_COUNTER	1
#define COPYMENU_COUNTER	2
#define UPDATEVOB_COUNTER	3

#define MAX_COUNTER		4

#if ENABLE_COUNTERS
#ifdef __IN_RDTSC__
static Counter_t Counters[MAX_COUNTER+1] = {
	{ "OverAll", 0, 0, 0LL },
	{ "CopyCell", 0, 0, 0LL },
	{ "CopyMenu", 0, 0, 0LL },
	{ "UpdateVob", 0, 0, 0LL },

	{ NULL, 0, 0, 0LL }
};
#endif
#endif
#if ENABLE_COUNTERS
#	define COUNTER_START(x)		CounterStart(x)
#	define COUNTER_STOP(x)		CounterStop(x)
#	define COUNTERS_REPORT()	CountersReport()
#else
#	define COUNTER_START(x)
#	define COUNTER_STOP(x)
#	define COUNTERS_REPORT()
#endif

/*@$#[rdtsc.c] global proto. AutoProtoSigV1.1. date: 106/03/01 21:35:08 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
void CounterStart PROTO((int no));
void CounterStop PROTO((int no));
void CountersReport PROTO((void));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/

#endif	/* __RDTSC_H__ */

