include(../common-project-config.pri)
include($${TOP_SRC_DIR}/common-vars.pri)
include($${TOP_SRC_DIR}/common-installs-config.pri)

TEMPLATE = lib
TARGET = keyring

CONFIG += \
    link_pkgconfig \
    plugin \
    qt

QT += \
    core
QT -= gui

QMAKE_CXXFLAGS += -Wno-missing-field-initializers

DEFINES += QT_NO_KEYWORDS

PKGCONFIG += \
    SignOnExtension \
    libsecret-1

# The following use of pkg-config + sed is a hack to workaround a qmake
# limitation: the CFLAGS variable is not used with the moc compiler, so the
# include rules given out by pkg-config wouldn't be applied when running the
# moc.
INCLUDEPATH += . \
    $$system(pkg-config --cflags SignOnExtension | sed s/-I//g)

HEADERS = \
    debug.h \
    secrets-storage.h \
    keyring-plugin.h

SOURCES = \
    secrets-storage.cpp \
    keyring-plugin.cpp

target.path = $$system(pkg-config --variable=plugindir SignOnExtension)
INSTALLS = target

