/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

/****************************************************************************
*************** This file has been generated. DO NOT MODIFY! ****************
****************************************************************************/

#include "tst_qscriptvalue.h"



void tst_QScriptValueGenerated::equals_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString equals_array[] = {
    "QScriptValue() <=> QScriptValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->newQObject(0)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(true) <=> QScriptValue(true)",
    "QScriptValue(true) <=> QScriptValue(0, true)",
    "QScriptValue(true) <=> QScriptValue(engine, true)",
    "QScriptValue(true) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(true) <=> engine->evaluate(\"true\")",
    "QScriptValue(false) <=> QScriptValue(false)",
    "QScriptValue(false) <=> QScriptValue(0)",
    "QScriptValue(false) <=> QScriptValue(0.0)",
    "QScriptValue(false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(QString())",
    "QScriptValue(false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(false) <=> QScriptValue(0, false)",
    "QScriptValue(false) <=> QScriptValue(0, 0)",
    "QScriptValue(false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(0, QString())",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(false) <=> QScriptValue(engine, false)",
    "QScriptValue(false) <=> QScriptValue(engine, 0)",
    "QScriptValue(false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(false) <=> QScriptValue(engine, QString())",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(false) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(false) <=> engine->evaluate(\"false\")",
    "QScriptValue(false) <=> engine->evaluate(\"0\")",
    "QScriptValue(false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(false) <=> engine->evaluate(\"''\")",
    "QScriptValue(false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(false) <=> engine->newArray()",
    "QScriptValue(false) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0) <=> QScriptValue(false)",
    "QScriptValue(0) <=> QScriptValue(0)",
    "QScriptValue(0) <=> QScriptValue(0.0)",
    "QScriptValue(0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(QString())",
    "QScriptValue(0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0) <=> QScriptValue(0, false)",
    "QScriptValue(0) <=> QScriptValue(0, 0)",
    "QScriptValue(0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(0, QString())",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0) <=> QScriptValue(engine, false)",
    "QScriptValue(0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0) <=> engine->newArray()",
    "QScriptValue(0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0.0) <=> QScriptValue(false)",
    "QScriptValue(0.0) <=> QScriptValue(0)",
    "QScriptValue(0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(QString())",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, false)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0.0) <=> engine->newArray()",
    "QScriptValue(0.0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(123.0) <=> QScriptValue(123.0)",
    "QScriptValue(123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(123.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(123.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString(\"\")) <=> engine->newArray()",
    "QScriptValue(QString(\"\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(QString()) <=> QScriptValue(false)",
    "QScriptValue(QString()) <=> QScriptValue(0)",
    "QScriptValue(QString()) <=> QScriptValue(0.0)",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString())",
    "QScriptValue(QString()) <=> QScriptValue(0, false)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString()) <=> engine->newArray()",
    "QScriptValue(QString()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString(\"0\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"123\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->newQObject(0)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(0, true) <=> QScriptValue(true)",
    "QScriptValue(0, true) <=> QScriptValue(0, true)",
    "QScriptValue(0, true) <=> QScriptValue(engine, true)",
    "QScriptValue(0, true) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, false) <=> QScriptValue(false)",
    "QScriptValue(0, false) <=> QScriptValue(0)",
    "QScriptValue(0, false) <=> QScriptValue(0.0)",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(QString())",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, false)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, QString())",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, false)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, false) <=> engine->newArray()",
    "QScriptValue(0, false) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0) <=> QScriptValue(false)",
    "QScriptValue(0, 0) <=> QScriptValue(0)",
    "QScriptValue(0, 0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(QString())",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, false)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString())",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, false)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, 0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, 0) <=> engine->newArray()",
    "QScriptValue(0, 0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, 0.0) <=> QScriptValue(false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, 0.0) <=> engine->newArray()",
    "QScriptValue(0, 0.0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, 123.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString(\"\")) <=> engine->newArray()",
    "QScriptValue(0, QString(\"\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, QString()) <=> QScriptValue(false)",
    "QScriptValue(0, QString()) <=> QScriptValue(0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString()) <=> engine->newArray()",
    "QScriptValue(0, QString()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->nullValue()",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->newQObject(0)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(engine, true) <=> QScriptValue(true)",
    "QScriptValue(engine, true) <=> QScriptValue(0, true)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, true) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, false) <=> QScriptValue(false)",
    "QScriptValue(engine, false) <=> QScriptValue(0)",
    "QScriptValue(engine, false) <=> QScriptValue(0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(QString())",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, false)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, false) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, false) <=> engine->newArray()",
    "QScriptValue(engine, false) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0) <=> QScriptValue(false)",
    "QScriptValue(engine, 0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, false)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, 0) <=> engine->newArray()",
    "QScriptValue(engine, 0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, 0.0) <=> engine->newArray()",
    "QScriptValue(engine, 0.0) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, 123.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(-qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->newArray()",
    "QScriptValue(engine, QString(\"\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, QString()) <=> QScriptValue(false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString()) <=> engine->newArray()",
    "QScriptValue(engine, QString()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString())",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"{}\") <=> engine->nullValue()",
    "engine->evaluate(\"{}\") <=> engine->undefinedValue()",
    "engine->evaluate(\"{}\") <=> engine->newQObject(0)",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Date.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(true)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(false)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(QString())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"new String('ciao')\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"undefined\") <=> engine->nullValue()",
    "engine->evaluate(\"undefined\") <=> engine->undefinedValue()",
    "engine->evaluate(\"undefined\") <=> engine->newQObject(0)",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"null\") <=> engine->nullValue()",
    "engine->evaluate(\"null\") <=> engine->undefinedValue()",
    "engine->evaluate(\"null\") <=> engine->newQObject(0)",
    "engine->evaluate(\"true\") <=> QScriptValue(true)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"false\") <=> QScriptValue(false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"false\") <=> engine->newArray()",
    "engine->evaluate(\"false\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"122\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"124\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0\") <=> QScriptValue(false)",
    "engine->evaluate(\"0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"0\") <=> engine->newArray()",
    "engine->evaluate(\"0\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"0.0\") <=> engine->newArray()",
    "engine->evaluate(\"0.0\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"123.0\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(-6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"-6.37e-8\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(-qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"''\") <=> QScriptValue(false)",
    "engine->evaluate(\"''\") <=> QScriptValue(0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"''\") <=> engine->newArray()",
    "engine->evaluate(\"''\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"'0'\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'123'\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'12.4'\")",
    "engine->nullValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->nullValue() <=> engine->evaluate(\"{}\")",
    "engine->nullValue() <=> engine->evaluate(\"undefined\")",
    "engine->nullValue() <=> engine->evaluate(\"null\")",
    "engine->nullValue() <=> engine->nullValue()",
    "engine->nullValue() <=> engine->undefinedValue()",
    "engine->nullValue() <=> engine->newQObject(0)",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->undefinedValue() <=> engine->evaluate(\"{}\")",
    "engine->undefinedValue() <=> engine->evaluate(\"undefined\")",
    "engine->undefinedValue() <=> engine->evaluate(\"null\")",
    "engine->undefinedValue() <=> engine->nullValue()",
    "engine->undefinedValue() <=> engine->undefinedValue()",
    "engine->undefinedValue() <=> engine->newQObject(0)",
    "engine->newObject() <=> engine->newObject()",
    "engine->newArray() <=> QScriptValue(false)",
    "engine->newArray() <=> QScriptValue(0)",
    "engine->newArray() <=> QScriptValue(0.0)",
    "engine->newArray() <=> QScriptValue(QString(\"\"))",
    "engine->newArray() <=> QScriptValue(QString())",
    "engine->newArray() <=> QScriptValue(0, false)",
    "engine->newArray() <=> QScriptValue(0, 0)",
    "engine->newArray() <=> QScriptValue(0, 0.0)",
    "engine->newArray() <=> QScriptValue(0, QString(\"\"))",
    "engine->newArray() <=> QScriptValue(0, QString())",
    "engine->newArray() <=> QScriptValue(engine, false)",
    "engine->newArray() <=> QScriptValue(engine, 0)",
    "engine->newArray() <=> QScriptValue(engine, 0.0)",
    "engine->newArray() <=> QScriptValue(engine, QString(\"\"))",
    "engine->newArray() <=> QScriptValue(engine, QString())",
    "engine->newArray() <=> engine->evaluate(\"false\")",
    "engine->newArray() <=> engine->evaluate(\"0\")",
    "engine->newArray() <=> engine->evaluate(\"0.0\")",
    "engine->newArray() <=> engine->evaluate(\"''\")",
    "engine->newArray() <=> engine->newArray()",
    "engine->newArray(10) <=> engine->newArray(10)",
    "engine->newDate(QDateTime()) <=> engine->newDate(QDateTime())",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->newVariant(QVariant()) <=> engine->newVariant(QVariant())",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(123.0)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(QString(\"123\"))",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, 123.0)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, QString(\"123\"))",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, 123.0)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"123.0\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"'123'\")",
    "engine->newVariant(QVariant(123)) <=> engine->newVariant(QVariant(123))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(false)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(QString(\"\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(QString())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(QString(\"0\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, false)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 0.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, QString(\"\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, QString())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, QString(\"0\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, false)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 0.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, QString(\"\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, QString())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, QString(\"0\"))",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"false\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"0\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"0.0\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"''\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"'0'\")",
    "engine->newVariant(QVariant(false)) <=> engine->newVariant(QVariant(false))",
    "engine->newQObject(0) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->newQObject(0) <=> QScriptValue(QScriptValue::NullValue)",
    "engine->newQObject(0) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->newQObject(0) <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->newQObject(0) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->newQObject(0) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->newQObject(0) <=> engine->evaluate(\"{}\")",
    "engine->newQObject(0) <=> engine->evaluate(\"undefined\")",
    "engine->newQObject(0) <=> engine->evaluate(\"null\")",
    "engine->newQObject(0) <=> engine->nullValue()",
    "engine->newQObject(0) <=> engine->undefinedValue()",
    "engine->newQObject(0) <=> engine->newQObject(0)",
    "engine->newQObject(engine) <=> engine->newQObject(engine)"};

void tst_QScriptValueGenerated::equals_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(1307);
        for (unsigned i = 0; i < 1307; ++i)
            equals.insert(equals_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValueGenerated::equals_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.equals(other), expected);
}

DEFINE_TEST_FUNCTION(equals)


void tst_QScriptValueGenerated::strictlyEquals_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString strictlyEquals_array[] = {
    "QScriptValue() <=> QScriptValue()",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(true) <=> QScriptValue(true)",
    "QScriptValue(true) <=> QScriptValue(0, true)",
    "QScriptValue(true) <=> QScriptValue(engine, true)",
    "QScriptValue(true) <=> engine->evaluate(\"true\")",
    "QScriptValue(false) <=> QScriptValue(false)",
    "QScriptValue(false) <=> QScriptValue(0, false)",
    "QScriptValue(false) <=> QScriptValue(engine, false)",
    "QScriptValue(false) <=> engine->evaluate(\"false\")",
    "QScriptValue(int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0) <=> QScriptValue(0)",
    "QScriptValue(0) <=> QScriptValue(0.0)",
    "QScriptValue(0) <=> QScriptValue(0, 0)",
    "QScriptValue(0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0.0) <=> QScriptValue(0)",
    "QScriptValue(0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(123.0) <=> QScriptValue(123.0)",
    "QScriptValue(123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString())",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(0, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(0, true) <=> QScriptValue(true)",
    "QScriptValue(0, true) <=> QScriptValue(0, true)",
    "QScriptValue(0, true) <=> QScriptValue(engine, true)",
    "QScriptValue(0, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, false) <=> QScriptValue(false)",
    "QScriptValue(0, false) <=> QScriptValue(0, false)",
    "QScriptValue(0, false) <=> QScriptValue(engine, false)",
    "QScriptValue(0, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0) <=> QScriptValue(0)",
    "QScriptValue(0, 0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"{}\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->evaluate(\"undefined\")",
    "QScriptValue(engine, QScriptValue::UndefinedValue) <=> engine->undefinedValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->nullValue()",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->newQObject(0)",
    "QScriptValue(engine, true) <=> QScriptValue(true)",
    "QScriptValue(engine, true) <=> QScriptValue(0, true)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, true) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, false) <=> QScriptValue(false)",
    "QScriptValue(engine, false) <=> QScriptValue(0, false)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, false) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, 123.0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x43211234) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(-qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, -qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, -qInf())",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"-Infinity\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"ciao\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"{}\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"{}\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"{}\") <=> engine->undefinedValue()",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Date.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"undefined\") <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"{}\")",
    "engine->evaluate(\"undefined\") <=> engine->evaluate(\"undefined\")",
    "engine->evaluate(\"undefined\") <=> engine->undefinedValue()",
    "engine->evaluate(\"null\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"null\") <=> engine->nullValue()",
    "engine->evaluate(\"null\") <=> engine->newQObject(0)",
    "engine->evaluate(\"true\") <=> QScriptValue(true)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"false\") <=> QScriptValue(false)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"122\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"124\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"123.0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(-6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, -6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"-6.37e-8\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x43211234\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"Infinity\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"Infinity\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(-qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, -qInf())",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"-Infinity\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'ciao'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'12.4'\")",
    "engine->nullValue() <=> QScriptValue(QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->nullValue() <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->nullValue() <=> engine->evaluate(\"null\")",
    "engine->nullValue() <=> engine->nullValue()",
    "engine->nullValue() <=> engine->newQObject(0)",
    "engine->undefinedValue() <=> QScriptValue(QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(0, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> QScriptValue(engine, QScriptValue::UndefinedValue)",
    "engine->undefinedValue() <=> engine->evaluate(\"{}\")",
    "engine->undefinedValue() <=> engine->evaluate(\"undefined\")",
    "engine->undefinedValue() <=> engine->undefinedValue()",
    "engine->newObject() <=> engine->newObject()",
    "engine->newArray() <=> engine->newArray()",
    "engine->newArray(10) <=> engine->newArray(10)",
    "engine->newDate(QDateTime()) <=> engine->newDate(QDateTime())",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->newVariant(QVariant()) <=> engine->newVariant(QVariant())",
    "engine->newVariant(QVariant(123)) <=> engine->newVariant(QVariant(123))",
    "engine->newVariant(QVariant(false)) <=> engine->newVariant(QVariant(false))",
    "engine->newQObject(0) <=> QScriptValue(QScriptValue::NullValue)",
    "engine->newQObject(0) <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->newQObject(0) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->newQObject(0) <=> engine->evaluate(\"null\")",
    "engine->newQObject(0) <=> engine->nullValue()",
    "engine->newQObject(0) <=> engine->newQObject(0)",
    "engine->newQObject(engine) <=> engine->newQObject(engine)"};

void tst_QScriptValueGenerated::strictlyEquals_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(529);
        for (unsigned i = 0; i < 529; ++i)
            equals.insert(strictlyEquals_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValueGenerated::strictlyEquals_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.strictlyEquals(other), expected);
}

DEFINE_TEST_FUNCTION(strictlyEquals)


void tst_QScriptValueGenerated::lessThan_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString lessThan_array[] = {
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(true)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(int(122))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(uint(124))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(123.0)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(6.37e-8)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0x43211234)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0x10000)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0x10001)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(qInf())",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, true)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, int(122))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, qInf())",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, true)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, int(122))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"true\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"122\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"124\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(QScriptValue::NullValue) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(true) <=> QScriptValue(int(122))",
    "QScriptValue(true) <=> QScriptValue(uint(124))",
    "QScriptValue(true) <=> QScriptValue(123.0)",
    "QScriptValue(true) <=> QScriptValue(0x43211234)",
    "QScriptValue(true) <=> QScriptValue(0x10000)",
    "QScriptValue(true) <=> QScriptValue(0x10001)",
    "QScriptValue(true) <=> QScriptValue(qInf())",
    "QScriptValue(true) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(true) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(true) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(true) <=> QScriptValue(0, int(122))",
    "QScriptValue(true) <=> QScriptValue(0, uint(124))",
    "QScriptValue(true) <=> QScriptValue(0, 123.0)",
    "QScriptValue(true) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(true) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(true) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(true) <=> QScriptValue(0, qInf())",
    "QScriptValue(true) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(true) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(true) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(true) <=> QScriptValue(engine, int(122))",
    "QScriptValue(true) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(true) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(true) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(true) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(true) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(true) <=> QScriptValue(engine, qInf())",
    "QScriptValue(true) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(true) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(true) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(true) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(true) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(true) <=> engine->evaluate(\"122\")",
    "QScriptValue(true) <=> engine->evaluate(\"124\")",
    "QScriptValue(true) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(true) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(true) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(true) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(true) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(true) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(true) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(true) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(false) <=> QScriptValue(true)",
    "QScriptValue(false) <=> QScriptValue(int(122))",
    "QScriptValue(false) <=> QScriptValue(uint(124))",
    "QScriptValue(false) <=> QScriptValue(123.0)",
    "QScriptValue(false) <=> QScriptValue(6.37e-8)",
    "QScriptValue(false) <=> QScriptValue(0x43211234)",
    "QScriptValue(false) <=> QScriptValue(0x10000)",
    "QScriptValue(false) <=> QScriptValue(0x10001)",
    "QScriptValue(false) <=> QScriptValue(qInf())",
    "QScriptValue(false) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(false) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(false) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(false) <=> QScriptValue(0, true)",
    "QScriptValue(false) <=> QScriptValue(0, int(122))",
    "QScriptValue(false) <=> QScriptValue(0, uint(124))",
    "QScriptValue(false) <=> QScriptValue(0, 123.0)",
    "QScriptValue(false) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(false) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(false) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(false) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(false) <=> QScriptValue(0, qInf())",
    "QScriptValue(false) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(false) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(false) <=> QScriptValue(engine, true)",
    "QScriptValue(false) <=> QScriptValue(engine, int(122))",
    "QScriptValue(false) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(false) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(false) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(false) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(false) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(false) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(false) <=> QScriptValue(engine, qInf())",
    "QScriptValue(false) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(false) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(false) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(false) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(false) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(false) <=> engine->evaluate(\"true\")",
    "QScriptValue(false) <=> engine->evaluate(\"122\")",
    "QScriptValue(false) <=> engine->evaluate(\"124\")",
    "QScriptValue(false) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(false) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(false) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(false) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(false) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(false) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(false) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(false) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(false) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(int(122)) <=> QScriptValue(uint(124))",
    "QScriptValue(int(122)) <=> QScriptValue(123.0)",
    "QScriptValue(int(122)) <=> QScriptValue(0x43211234)",
    "QScriptValue(int(122)) <=> QScriptValue(0x10000)",
    "QScriptValue(int(122)) <=> QScriptValue(0x10001)",
    "QScriptValue(int(122)) <=> QScriptValue(qInf())",
    "QScriptValue(int(122)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(int(122)) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(int(122)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(int(122)) <=> QScriptValue(0, 123.0)",
    "QScriptValue(int(122)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(int(122)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(int(122)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(int(122)) <=> QScriptValue(0, qInf())",
    "QScriptValue(int(122)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(int(122)) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(int(122)) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(int(122)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(int(122)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(int(122)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(int(122)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(int(122)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(int(122)) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(int(122)) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"124\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(int(122)) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(int(122)) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(uint(124)) <=> QScriptValue(0x43211234)",
    "QScriptValue(uint(124)) <=> QScriptValue(0x10000)",
    "QScriptValue(uint(124)) <=> QScriptValue(0x10001)",
    "QScriptValue(uint(124)) <=> QScriptValue(qInf())",
    "QScriptValue(uint(124)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(uint(124)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(uint(124)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(uint(124)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(uint(124)) <=> QScriptValue(0, qInf())",
    "QScriptValue(uint(124)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(uint(124)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(uint(124)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0) <=> QScriptValue(true)",
    "QScriptValue(0) <=> QScriptValue(int(122))",
    "QScriptValue(0) <=> QScriptValue(uint(124))",
    "QScriptValue(0) <=> QScriptValue(123.0)",
    "QScriptValue(0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0) <=> QScriptValue(0x43211234)",
    "QScriptValue(0) <=> QScriptValue(0x10000)",
    "QScriptValue(0) <=> QScriptValue(0x10001)",
    "QScriptValue(0) <=> QScriptValue(qInf())",
    "QScriptValue(0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0) <=> QScriptValue(0, true)",
    "QScriptValue(0) <=> QScriptValue(0, int(122))",
    "QScriptValue(0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0) <=> QScriptValue(0, qInf())",
    "QScriptValue(0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0) <=> QScriptValue(engine, true)",
    "QScriptValue(0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0) <=> engine->evaluate(\"true\")",
    "QScriptValue(0) <=> engine->evaluate(\"122\")",
    "QScriptValue(0) <=> engine->evaluate(\"124\")",
    "QScriptValue(0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0.0) <=> QScriptValue(true)",
    "QScriptValue(0.0) <=> QScriptValue(int(122))",
    "QScriptValue(0.0) <=> QScriptValue(uint(124))",
    "QScriptValue(0.0) <=> QScriptValue(123.0)",
    "QScriptValue(0.0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(0.0) <=> QScriptValue(0x10000)",
    "QScriptValue(0.0) <=> QScriptValue(0x10001)",
    "QScriptValue(0.0) <=> QScriptValue(qInf())",
    "QScriptValue(0.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0.0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, true)",
    "QScriptValue(0.0) <=> QScriptValue(0, int(122))",
    "QScriptValue(0.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0.0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(0.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0.0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, true)",
    "QScriptValue(0.0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0.0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0.0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"true\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"122\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0.0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(123.0) <=> QScriptValue(uint(124))",
    "QScriptValue(123.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(123.0) <=> QScriptValue(0x10000)",
    "QScriptValue(123.0) <=> QScriptValue(0x10001)",
    "QScriptValue(123.0) <=> QScriptValue(qInf())",
    "QScriptValue(123.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(123.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(123.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(123.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(123.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(123.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(123.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(123.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(123.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(123.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(123.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(123.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(123.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(123.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(false)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QString())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, false)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 0.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QString())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, false)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QString())",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(-6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"[]\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"null\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"false\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"0\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"''\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(-6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(-6.37e-8) <=> engine->nullValue()",
    "QScriptValue(-6.37e-8) <=> engine->newArray()",
    "QScriptValue(-6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(-6.37e-8) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(-6.37e-8) <=> engine->newQObject(0)",
    "QScriptValue(0x43211234) <=> QScriptValue(qInf())",
    "QScriptValue(0x43211234) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0x43211234) <=> QScriptValue(0, qInf())",
    "QScriptValue(0x43211234) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0x43211234) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0x43211234) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0x10000) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x10000) <=> QScriptValue(0x10001)",
    "QScriptValue(0x10000) <=> QScriptValue(qInf())",
    "QScriptValue(0x10000) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x10000) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0x10000) <=> QScriptValue(0, qInf())",
    "QScriptValue(0x10000) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0x10000) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0x10000) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10000) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0x10000) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0x10001) <=> QScriptValue(0x43211234)",
    "QScriptValue(0x10001) <=> QScriptValue(qInf())",
    "QScriptValue(0x10001) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0x10001) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0x10001) <=> QScriptValue(0, qInf())",
    "QScriptValue(0x10001) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0x10001) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0x10001) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0x10001) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0x10001) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0x10001) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(-qInf()) <=> QScriptValue(true)",
    "QScriptValue(-qInf()) <=> QScriptValue(false)",
    "QScriptValue(-qInf()) <=> QScriptValue(int(122))",
    "QScriptValue(-qInf()) <=> QScriptValue(uint(124))",
    "QScriptValue(-qInf()) <=> QScriptValue(0)",
    "QScriptValue(-qInf()) <=> QScriptValue(0.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(123.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(0x43211234)",
    "QScriptValue(-qInf()) <=> QScriptValue(0x10000)",
    "QScriptValue(-qInf()) <=> QScriptValue(0x10001)",
    "QScriptValue(-qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(QString())",
    "QScriptValue(-qInf()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, true)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, false)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, int(122))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 0)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(-qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QString())",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, true)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, false)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 0)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QString())",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(-qInf()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"null\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"true\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"false\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"122\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"124\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"0\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"''\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(-qInf()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(-qInf()) <=> engine->nullValue()",
    "QScriptValue(-qInf()) <=> engine->newArray()",
    "QScriptValue(-qInf()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(-qInf()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(-qInf()) <=> engine->newQObject(0)",
    "QScriptValue(\"NaN\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"NaN\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"True\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"False\")",
    "QScriptValue(\"NaN\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(\"NaN\") <=> engine->newObject()",
    "QScriptValue(\"NaN\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(\"NaN\") <=> engine->newQObject(engine)",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(\"Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(\"Infinity\") <=> engine->newObject()",
    "QScriptValue(\"Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(\"Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(true)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(false)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(int(122))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(uint(124))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(123.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(-6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0x43211234)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0x10000)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0x10001)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, true)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, false)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, int(122))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, uint(124))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 0.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 123.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 0x10000)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, 0x10001)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, true)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, false)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, int(122))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, uint(124))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 0.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 123.0)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(\"-Infinity\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"null\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"true\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"false\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"122\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"124\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"0\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"0.0\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"123.0\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"'0'\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"'123'\")",
    "QScriptValue(\"-Infinity\") <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(\"-Infinity\") <=> engine->nullValue()",
    "QScriptValue(\"-Infinity\") <=> engine->newObject()",
    "QScriptValue(\"-Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(\"-Infinity\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(\"-Infinity\") <=> engine->newVariant(QVariant(123))",
    "QScriptValue(\"-Infinity\") <=> engine->newVariant(QVariant(false))",
    "QScriptValue(\"-Infinity\") <=> engine->newQObject(0)",
    "QScriptValue(\"-Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(\"ciao\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(true)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(int(122))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(uint(124))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(123.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0x10000)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0x10001)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(qInf())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, true)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, true)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(QString(\"\")) <=> engine->newObject()",
    "QScriptValue(QString(\"\")) <=> engine->newArray(10)",
    "QScriptValue(QString(\"\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(QString(\"\")) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(QString(\"\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(QString(\"\")) <=> engine->newQObject(engine)",
    "QScriptValue(QString()) <=> QScriptValue(true)",
    "QScriptValue(QString()) <=> QScriptValue(int(122))",
    "QScriptValue(QString()) <=> QScriptValue(uint(124))",
    "QScriptValue(QString()) <=> QScriptValue(123.0)",
    "QScriptValue(QString()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(QString()) <=> QScriptValue(0x43211234)",
    "QScriptValue(QString()) <=> QScriptValue(0x10000)",
    "QScriptValue(QString()) <=> QScriptValue(0x10001)",
    "QScriptValue(QString()) <=> QScriptValue(qInf())",
    "QScriptValue(QString()) <=> QScriptValue(\"NaN\")",
    "QScriptValue(QString()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString()) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, true)",
    "QScriptValue(QString()) <=> QScriptValue(0, int(122))",
    "QScriptValue(QString()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QString()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QString()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QString()) <=> QScriptValue(0, qInf())",
    "QScriptValue(QString()) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(QString()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString()) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, true)",
    "QScriptValue(QString()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(QString()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QString()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QString()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QString()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QString()) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(QString()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(QString()) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(QString()) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Null\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"True\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"False\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"true\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"122\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"124\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(QString()) <=> engine->newObject()",
    "QScriptValue(QString()) <=> engine->newArray(10)",
    "QScriptValue(QString()) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(QString()) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(QString()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(QString()) <=> engine->newQObject(engine)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(true)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(int(122))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(uint(124))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(123.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0x10000)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0x10001)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(qInf())",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, true)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, true)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"0\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"0\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(QString(\"0\")) <=> engine->newObject()",
    "QScriptValue(QString(\"0\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(QString(\"0\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(QString(\"0\")) <=> engine->newQObject(engine)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(uint(124))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0x10000)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0x10001)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(qInf())",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString(\"123\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QString(\"123\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"123\")) <=> engine->newObject()",
    "QScriptValue(QString(\"123\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(QString(\"123\")) <=> engine->newQObject(engine)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(int(122))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(uint(124))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(123.0)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0x10000)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0x10001)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(qInf())",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(QString(\"12.4\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(QString(\"12.4\")) <=> engine->newObject()",
    "QScriptValue(QString(\"12.4\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(QString(\"12.4\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(QString(\"12.4\")) <=> engine->newQObject(engine)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(true)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(int(122))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(123.0)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(qInf())",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, true)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, true)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QScriptValue::NullValue) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, true) <=> QScriptValue(int(122))",
    "QScriptValue(0, true) <=> QScriptValue(uint(124))",
    "QScriptValue(0, true) <=> QScriptValue(123.0)",
    "QScriptValue(0, true) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, true) <=> QScriptValue(0x10000)",
    "QScriptValue(0, true) <=> QScriptValue(0x10001)",
    "QScriptValue(0, true) <=> QScriptValue(qInf())",
    "QScriptValue(0, true) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, true) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, true) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, true) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, true) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, true) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, true) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, true) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, true) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, true) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, true) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, true) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, true) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, true) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, true) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, true) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, true) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, true) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, true) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, true) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, true) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, true) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, true) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, true) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, true) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, true) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, false) <=> QScriptValue(true)",
    "QScriptValue(0, false) <=> QScriptValue(int(122))",
    "QScriptValue(0, false) <=> QScriptValue(uint(124))",
    "QScriptValue(0, false) <=> QScriptValue(123.0)",
    "QScriptValue(0, false) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, false) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, false) <=> QScriptValue(0x10000)",
    "QScriptValue(0, false) <=> QScriptValue(0x10001)",
    "QScriptValue(0, false) <=> QScriptValue(qInf())",
    "QScriptValue(0, false) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, false) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, true)",
    "QScriptValue(0, false) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, false) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, false) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, false) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, false) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, false) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, false) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, false) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, true)",
    "QScriptValue(0, false) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, false) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, false) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, false) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, false) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, false) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, false) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, false) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, false) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, false) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, int(122)) <=> QScriptValue(uint(124))",
    "QScriptValue(0, int(122)) <=> QScriptValue(123.0)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0x10000)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0x10001)",
    "QScriptValue(0, int(122)) <=> QScriptValue(qInf())",
    "QScriptValue(0, int(122)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, int(122)) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, int(122)) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, int(122)) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0x10000)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0x10001)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(qInf())",
    "QScriptValue(0, uint(124)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, uint(124)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, uint(124)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, uint(124)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 0) <=> QScriptValue(true)",
    "QScriptValue(0, 0) <=> QScriptValue(int(122))",
    "QScriptValue(0, 0) <=> QScriptValue(uint(124))",
    "QScriptValue(0, 0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 0) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0) <=> QScriptValue(qInf())",
    "QScriptValue(0, 0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, 0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, true)",
    "QScriptValue(0, 0) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, 0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, 0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, 0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, true)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, 0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, 0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, 0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, 0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, 0.0) <=> QScriptValue(true)",
    "QScriptValue(0, 0.0) <=> QScriptValue(int(122))",
    "QScriptValue(0, 0.0) <=> QScriptValue(uint(124))",
    "QScriptValue(0, 0.0) <=> QScriptValue(123.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0.0) <=> QScriptValue(qInf())",
    "QScriptValue(0, 0.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, true)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, true)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, 0.0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, 0.0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, 0.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, 123.0) <=> QScriptValue(uint(124))",
    "QScriptValue(0, 123.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 123.0) <=> QScriptValue(qInf())",
    "QScriptValue(0, 123.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 123.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 123.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, 123.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, 6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, 6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, 6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(false)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QString())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, false)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QString())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, false)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, -6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, -6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, -6.37e-8) <=> engine->nullValue()",
    "QScriptValue(0, -6.37e-8) <=> engine->newArray()",
    "QScriptValue(0, -6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, -6.37e-8) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, -6.37e-8) <=> engine->newQObject(0)",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(qInf())",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 0x43211234) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 0x43211234) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0x10001)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(qInf())",
    "QScriptValue(0, 0x10000) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 0x10000) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 0x10000) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, 0x10000) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(qInf())",
    "QScriptValue(0, 0x10001) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, 0x10001) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, 0x10001) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, 0x10001) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(true)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(false)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(int(122))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(uint(124))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(123.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0x10000)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0x10001)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QString())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, true)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, false)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QString())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, true)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, false)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QString())",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, -qInf()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"null\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"false\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"0\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"''\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, -qInf()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, -qInf()) <=> engine->nullValue()",
    "QScriptValue(0, -qInf()) <=> engine->newArray()",
    "QScriptValue(0, -qInf()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, -qInf()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, -qInf()) <=> engine->newQObject(0)",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"NaN\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"True\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"False\")",
    "QScriptValue(0, \"NaN\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, \"NaN\") <=> engine->newObject()",
    "QScriptValue(0, \"NaN\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, \"NaN\") <=> engine->newQObject(engine)",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(0, \"Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, \"Infinity\") <=> engine->newObject()",
    "QScriptValue(0, \"Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, \"Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(true)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(false)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(int(122))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(uint(124))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(123.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(-6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0x43211234)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0x10000)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0x10001)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, true)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, false)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, int(122))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 0.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, true)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, false)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 0.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, \"-Infinity\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"null\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"true\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"false\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"122\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"124\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"0\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"0.0\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->nullValue()",
    "QScriptValue(0, \"-Infinity\") <=> engine->newObject()",
    "QScriptValue(0, \"-Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, \"-Infinity\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(0, \"-Infinity\") <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, \"-Infinity\") <=> engine->newVariant(QVariant(false))",
    "QScriptValue(0, \"-Infinity\") <=> engine->newQObject(0)",
    "QScriptValue(0, \"-Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, \"ciao\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(true)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(int(122))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(qInf())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, true)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, true)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QString(\"\")) <=> engine->newObject()",
    "QScriptValue(0, QString(\"\")) <=> engine->newArray(10)",
    "QScriptValue(0, QString(\"\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, QString(\"\")) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(0, QString(\"\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, QString(\"\")) <=> engine->newQObject(engine)",
    "QScriptValue(0, QString()) <=> QScriptValue(true)",
    "QScriptValue(0, QString()) <=> QScriptValue(int(122))",
    "QScriptValue(0, QString()) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QString()) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, QString()) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QString()) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QString()) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QString()) <=> QScriptValue(qInf())",
    "QScriptValue(0, QString()) <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, QString()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString()) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, true)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QString()) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QString()) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, QString()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, true)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"True\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"False\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QString()) <=> engine->newObject()",
    "QScriptValue(0, QString()) <=> engine->newArray(10)",
    "QScriptValue(0, QString()) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, QString()) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(0, QString()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, QString()) <=> engine->newQObject(engine)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(true)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(int(122))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(qInf())",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, true)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, true)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"0\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QString(\"0\")) <=> engine->newObject()",
    "QScriptValue(0, QString(\"0\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, QString(\"0\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, QString(\"0\")) <=> engine->newQObject(engine)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(qInf())",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString(\"123\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"123\")) <=> engine->newObject()",
    "QScriptValue(0, QString(\"123\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, QString(\"123\")) <=> engine->newQObject(engine)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(int(122))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(uint(124))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(123.0)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0x10000)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0x10001)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(qInf())",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->newObject()",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(0, QString(\"12.3\")) <=> engine->newQObject(engine)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(true)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(int(122))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, true)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, QScriptValue::NullValue) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, true) <=> QScriptValue(int(122))",
    "QScriptValue(engine, true) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, true) <=> QScriptValue(123.0)",
    "QScriptValue(engine, true) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, true) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, true) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, true) <=> QScriptValue(qInf())",
    "QScriptValue(engine, true) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, true) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, true) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, true) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, true) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, true) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, true) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, true) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, true) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, true) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, true) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, true) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, true) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, true) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, true) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, true) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, true) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, true) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, true) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, true) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, true) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, true) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, true) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, false) <=> QScriptValue(true)",
    "QScriptValue(engine, false) <=> QScriptValue(int(122))",
    "QScriptValue(engine, false) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, false) <=> QScriptValue(123.0)",
    "QScriptValue(engine, false) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, false) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, false) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, false) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, false) <=> QScriptValue(qInf())",
    "QScriptValue(engine, false) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, false) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, true)",
    "QScriptValue(engine, false) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, false) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, false) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, false) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, false) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, false) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, false) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, false) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, false) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, false) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, false) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, false) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, false) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(123.0)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(qInf())",
    "QScriptValue(engine, int(122)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, int(122)) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, int(122)) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, int(122)) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(qInf())",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, uint(124)) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, uint(124)) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 0) <=> QScriptValue(true)",
    "QScriptValue(engine, 0) <=> QScriptValue(int(122))",
    "QScriptValue(engine, 0) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, 0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 0) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, true)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, 0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, 0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, 0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(true)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(int(122))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, true)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, 0.0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, 0.0) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, 0.0) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 123.0) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 123.0) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 123.0) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, 123.0) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, 6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, 6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(true)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(false)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(int(122))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(123.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(qInf())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QString())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, true)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, false)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, -6.37e-8) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, -6.37e-8) <=> engine->nullValue()",
    "QScriptValue(engine, -6.37e-8) <=> engine->newArray()",
    "QScriptValue(engine, -6.37e-8) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, -6.37e-8) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, -6.37e-8) <=> engine->newQObject(0)",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 0x43211234) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 0x43211234) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 0x10000) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, 0x10000) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(qInf())",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, 0x10001) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, 0x10001) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(true)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(false)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(int(122))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(123.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QString(\"\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QString())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, true)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, false)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QString(\"\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QString())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, false)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QString(\"\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QString())",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, -qInf()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"[]\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"Array.prototype\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"new Array()\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"''\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, -qInf()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, -qInf()) <=> engine->nullValue()",
    "QScriptValue(engine, -qInf()) <=> engine->newArray()",
    "QScriptValue(engine, -qInf()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, -qInf()) <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, -qInf()) <=> engine->newQObject(0)",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"NaN\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, \"NaN\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, \"NaN\") <=> engine->newObject()",
    "QScriptValue(engine, \"NaN\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, \"NaN\") <=> engine->newQObject(engine)",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, \"Infinity\") <=> engine->newObject()",
    "QScriptValue(engine, \"Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, \"Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(QScriptValue::NullValue)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(true)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(false)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(int(122))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(uint(124))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(123.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(-6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0x10000)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0x10001)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, true)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, false)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 0.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, -6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, true)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, false)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 0.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, -6.37e-8)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, \"-Infinity\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new Boolean(false)\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"null\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"false\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"0\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"0.0\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"-6.37e-8\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->nullValue()",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newObject()",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newVariant(QVariant(false))",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newQObject(0)",
    "QScriptValue(engine, \"-Infinity\") <=> engine->newQObject(engine)",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, \"ciao\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString::fromLatin1(\"ciao\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(true)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(int(122))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, true)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->newObject()",
    "QScriptValue(engine, QString(\"\")) <=> engine->newArray(10)",
    "QScriptValue(engine, QString(\"\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, QString(\"\")) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(engine, QString(\"\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, QString(\"\")) <=> engine->newQObject(engine)",
    "QScriptValue(engine, QString()) <=> QScriptValue(true)",
    "QScriptValue(engine, QString()) <=> QScriptValue(int(122))",
    "QScriptValue(engine, QString()) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QString()) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QString()) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QString()) <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(\"-Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"0\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, true)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, \"-Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"0\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, \"-Infinity\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"0\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString()) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"/foo/\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"'0'\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString()) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, QString()) <=> engine->newObject()",
    "QScriptValue(engine, QString()) <=> engine->newArray(10)",
    "QScriptValue(engine, QString()) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, QString()) <=> engine->newRegExp(\"foo\", \"gim\")",
    "QScriptValue(engine, QString()) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, QString()) <=> engine->newQObject(engine)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(true)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(int(122))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(6.37e-8)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, true)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 6.37e-8)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, true)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 6.37e-8)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"0\")) <=> QScriptValue(engine, QString(\"1.23\"))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new Boolean(true)\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"true\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"6.37e-8\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, QString(\"0\")) <=> engine->newObject()",
    "QScriptValue(engine, QString(\"0\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, QString(\"0\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, QString(\"0\")) <=> engine->newQObject(engine)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString(\"123\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"123\")) <=> engine->newObject()",
    "QScriptValue(engine, QString(\"123\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, QString(\"123\")) <=> engine->newQObject(engine)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(int(122))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(uint(124))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(123.0)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0x43211234)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0x10000)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0x10001)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(qInf())",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(\"NaN\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(\"Infinity\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(\"ciao\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(QString(\"123\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(QString(\"12.4\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, int(122))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, uint(124))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, 123.0)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, 0x43211234)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, 0x10000)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, 0x10001)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, qInf())",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, \"NaN\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, \"Infinity\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, \"ciao\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, QString(\"123\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(0, QString(\"12.3\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, int(122))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, uint(124))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, 123.0)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, 0x43211234)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, 0x10000)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, 0x10001)",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, qInf())",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, \"NaN\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, \"Infinity\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, \"ciao\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> QScriptValue(engine, QString(\"123\"))",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Object.prototype\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Function.prototype\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Error.prototype\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Object\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Array\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Number\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Function\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"(function() { return 1; })\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"new Object()\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"new Error()\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"new Number(123)\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"new String('ciao')\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Undefined\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Null\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"True\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"False\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"122\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"124\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"123.0\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"0x43211234\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"0x10000\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"0x10001\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"Infinity\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"'ciao'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"'123'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->evaluate(\"'12.4'\")",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->newObject()",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->newVariant(QVariant(123))",
    "QScriptValue(engine, QString(\"1.23\")) <=> engine->newQObject(engine)",
    "engine->evaluate(\"[]\") <=> QScriptValue(true)",
    "engine->evaluate(\"[]\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"[]\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"[]\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"[]\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"[]\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"[]\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"[]\") <=> engine->newObject()",
    "engine->evaluate(\"[]\") <=> engine->newArray(10)",
    "engine->evaluate(\"[]\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"[]\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->evaluate(\"[]\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"[]\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"Object.prototype\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"Object.prototype\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(true)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"Array.prototype\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->newObject()",
    "engine->evaluate(\"Array.prototype\") <=> engine->newArray(10)",
    "engine->evaluate(\"Array.prototype\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"Array.prototype\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"Array.prototype\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"Error.prototype\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->newObject()",
    "engine->evaluate(\"Error.prototype\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"Error.prototype\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"/foo/\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"/foo/\") <=> engine->newObject()",
    "engine->evaluate(\"/foo/\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"/foo/\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->evaluate(\"/foo/\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"new Object()\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"new Object()\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(true)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"new Array()\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"new Array()\") <=> engine->newObject()",
    "engine->evaluate(\"new Array()\") <=> engine->newArray(10)",
    "engine->evaluate(\"new Array()\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"new Array()\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->evaluate(\"new Array()\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"new Array()\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"new Error()\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"new Error()\") <=> engine->newObject()",
    "engine->evaluate(\"new Error()\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"new Error()\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(true)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"new Number(123)\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->newObject()",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"Undefined\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"Undefined\") <=> engine->newObject()",
    "engine->evaluate(\"Undefined\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"Null\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"Null\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Null\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"Null\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Null\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"Null\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"Null\") <=> engine->newObject()",
    "engine->evaluate(\"Null\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"True\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"True\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"True\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"True\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"True\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"True\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"True\") <=> engine->newObject()",
    "engine->evaluate(\"True\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"False\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"False\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"False\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"False\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"False\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"False\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"False\") <=> engine->newObject()",
    "engine->evaluate(\"False\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"null\") <=> QScriptValue(true)",
    "engine->evaluate(\"null\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"null\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"null\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"null\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"null\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"null\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"null\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"null\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"null\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"null\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"null\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"null\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"null\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"null\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"null\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"null\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"null\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"null\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"null\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"null\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"true\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"true\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"true\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"true\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"true\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"true\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"true\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"true\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"true\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"true\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"true\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"true\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"true\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"true\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"true\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"true\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"true\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"true\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"true\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"true\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"false\") <=> QScriptValue(true)",
    "engine->evaluate(\"false\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"false\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"false\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"false\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"false\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"false\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"false\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"false\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"false\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"false\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"false\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"false\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"false\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"122\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"122\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"122\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"122\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"122\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"122\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"122\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"122\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"122\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"122\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"122\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"122\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"122\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"122\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"122\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"122\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"122\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"122\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"124\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"124\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"124\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"124\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"124\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"124\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"124\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"124\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"124\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"124\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"124\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"124\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"0\") <=> QScriptValue(true)",
    "engine->evaluate(\"0\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"0\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"0\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"0\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"0\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"0\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"0\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"0\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(true)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"0.0\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"0.0\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"0.0\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"123.0\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"123.0\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"123.0\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"123.0\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(true)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"6.37e-8\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"6.37e-8\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(true)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(false)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QString())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"-6.37e-8\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"-6.37e-8\") <=> engine->nullValue()",
    "engine->evaluate(\"-6.37e-8\") <=> engine->newArray()",
    "engine->evaluate(\"-6.37e-8\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"-6.37e-8\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"-6.37e-8\") <=> engine->newQObject(0)",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"0x43211234\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"0x43211234\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"0x10000\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"0x10000\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"0x10001\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"0x10001\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QScriptValue::NullValue)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(true)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(false)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(-6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QString(\"\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QString())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QScriptValue::NullValue)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, false)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 0.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, -6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QString(\"\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QString())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QScriptValue::NullValue)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, false)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 0.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, -6.37e-8)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QString(\"\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QString())",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"-Infinity\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"[]\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"Array.prototype\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"new Array()\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"new Boolean(false)\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"null\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"false\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"0\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"0.0\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"-6.37e-8\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"''\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"-Infinity\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"-Infinity\") <=> engine->nullValue()",
    "engine->evaluate(\"-Infinity\") <=> engine->newArray()",
    "engine->evaluate(\"-Infinity\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"-Infinity\") <=> engine->newVariant(QVariant(false))",
    "engine->evaluate(\"-Infinity\") <=> engine->newQObject(0)",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"'ciao'\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"''\") <=> QScriptValue(true)",
    "engine->evaluate(\"''\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"''\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"''\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"''\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"''\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"''\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"''\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"''\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"''\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(\"-Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"''\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"0\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"''\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"''\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"''\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(0, \"-Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, \"-Infinity\")",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"''\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"/foo/\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"'0'\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"''\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"''\") <=> engine->newObject()",
    "engine->evaluate(\"''\") <=> engine->newArray(10)",
    "engine->evaluate(\"''\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"''\") <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->evaluate(\"''\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"''\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(true)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(6.37e-8)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"'0'\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, true)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 6.37e-8)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, true)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 6.37e-8)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'0'\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"true\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"6.37e-8\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'0'\") <=> engine->evaluate(\"'12.4'\")",
    "engine->evaluate(\"'0'\") <=> engine->newObject()",
    "engine->evaluate(\"'0'\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"'0'\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"'0'\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"'123'\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'123'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"'123'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"'123'\") <=> engine->newObject()",
    "engine->evaluate(\"'123'\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"'123'\") <=> engine->newQObject(engine)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(int(122))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(uint(124))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(123.0)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0x43211234)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0x10000)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0x10001)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(qInf())",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(\"NaN\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(\"Infinity\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(\"ciao\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(QString(\"123\"))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, int(122))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, uint(124))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, 123.0)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, 0x43211234)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, 0x10000)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, 0x10001)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, qInf())",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, \"NaN\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, \"Infinity\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, \"ciao\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, int(122))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, uint(124))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, 123.0)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, 0x43211234)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, 0x10000)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, 0x10001)",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, qInf())",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, \"NaN\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, \"ciao\")",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->evaluate(\"'12.4'\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"new Object()\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"new Error()\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"new Number(123)\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Undefined\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Null\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"True\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"False\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"122\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"124\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"123.0\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"0x43211234\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"0x10000\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"0x10001\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"Infinity\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'ciao'\")",
    "engine->evaluate(\"'12.4'\") <=> engine->evaluate(\"'123'\")",
    "engine->evaluate(\"'12.4'\") <=> engine->newObject()",
    "engine->evaluate(\"'12.4'\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->evaluate(\"'12.4'\") <=> engine->newVariant(QVariant(123))",
    "engine->evaluate(\"'12.4'\") <=> engine->newQObject(engine)",
    "engine->nullValue() <=> QScriptValue(true)",
    "engine->nullValue() <=> QScriptValue(int(122))",
    "engine->nullValue() <=> QScriptValue(uint(124))",
    "engine->nullValue() <=> QScriptValue(123.0)",
    "engine->nullValue() <=> QScriptValue(6.37e-8)",
    "engine->nullValue() <=> QScriptValue(0x43211234)",
    "engine->nullValue() <=> QScriptValue(0x10000)",
    "engine->nullValue() <=> QScriptValue(0x10001)",
    "engine->nullValue() <=> QScriptValue(qInf())",
    "engine->nullValue() <=> QScriptValue(\"Infinity\")",
    "engine->nullValue() <=> QScriptValue(QString(\"123\"))",
    "engine->nullValue() <=> QScriptValue(QString(\"12.4\"))",
    "engine->nullValue() <=> QScriptValue(0, true)",
    "engine->nullValue() <=> QScriptValue(0, int(122))",
    "engine->nullValue() <=> QScriptValue(0, uint(124))",
    "engine->nullValue() <=> QScriptValue(0, 123.0)",
    "engine->nullValue() <=> QScriptValue(0, 6.37e-8)",
    "engine->nullValue() <=> QScriptValue(0, 0x43211234)",
    "engine->nullValue() <=> QScriptValue(0, 0x10000)",
    "engine->nullValue() <=> QScriptValue(0, 0x10001)",
    "engine->nullValue() <=> QScriptValue(0, qInf())",
    "engine->nullValue() <=> QScriptValue(0, \"Infinity\")",
    "engine->nullValue() <=> QScriptValue(0, QString(\"123\"))",
    "engine->nullValue() <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->nullValue() <=> QScriptValue(engine, true)",
    "engine->nullValue() <=> QScriptValue(engine, int(122))",
    "engine->nullValue() <=> QScriptValue(engine, uint(124))",
    "engine->nullValue() <=> QScriptValue(engine, 123.0)",
    "engine->nullValue() <=> QScriptValue(engine, 6.37e-8)",
    "engine->nullValue() <=> QScriptValue(engine, 0x43211234)",
    "engine->nullValue() <=> QScriptValue(engine, 0x10000)",
    "engine->nullValue() <=> QScriptValue(engine, 0x10001)",
    "engine->nullValue() <=> QScriptValue(engine, qInf())",
    "engine->nullValue() <=> QScriptValue(engine, \"Infinity\")",
    "engine->nullValue() <=> QScriptValue(engine, QString(\"123\"))",
    "engine->nullValue() <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->nullValue() <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->nullValue() <=> engine->evaluate(\"new Number(123)\")",
    "engine->nullValue() <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->nullValue() <=> engine->evaluate(\"true\")",
    "engine->nullValue() <=> engine->evaluate(\"122\")",
    "engine->nullValue() <=> engine->evaluate(\"124\")",
    "engine->nullValue() <=> engine->evaluate(\"123.0\")",
    "engine->nullValue() <=> engine->evaluate(\"6.37e-8\")",
    "engine->nullValue() <=> engine->evaluate(\"0x43211234\")",
    "engine->nullValue() <=> engine->evaluate(\"0x10000\")",
    "engine->nullValue() <=> engine->evaluate(\"0x10001\")",
    "engine->nullValue() <=> engine->evaluate(\"Infinity\")",
    "engine->nullValue() <=> engine->evaluate(\"'123'\")",
    "engine->nullValue() <=> engine->evaluate(\"'12.4'\")",
    "engine->nullValue() <=> engine->newVariant(QVariant(123))",
    "engine->newObject() <=> QScriptValue(\"ciao\")",
    "engine->newObject() <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newObject() <=> QScriptValue(0, \"ciao\")",
    "engine->newObject() <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newObject() <=> QScriptValue(engine, \"ciao\")",
    "engine->newObject() <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newObject() <=> engine->evaluate(\"Function.prototype\")",
    "engine->newObject() <=> engine->evaluate(\"Object\")",
    "engine->newObject() <=> engine->evaluate(\"Array\")",
    "engine->newObject() <=> engine->evaluate(\"Number\")",
    "engine->newObject() <=> engine->evaluate(\"Function\")",
    "engine->newObject() <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newObject() <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newObject() <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newObject() <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newObject() <=> engine->evaluate(\"'ciao'\")",
    "engine->newObject() <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newArray() <=> QScriptValue(true)",
    "engine->newArray() <=> QScriptValue(int(122))",
    "engine->newArray() <=> QScriptValue(uint(124))",
    "engine->newArray() <=> QScriptValue(123.0)",
    "engine->newArray() <=> QScriptValue(6.37e-8)",
    "engine->newArray() <=> QScriptValue(0x43211234)",
    "engine->newArray() <=> QScriptValue(0x10000)",
    "engine->newArray() <=> QScriptValue(0x10001)",
    "engine->newArray() <=> QScriptValue(qInf())",
    "engine->newArray() <=> QScriptValue(\"NaN\")",
    "engine->newArray() <=> QScriptValue(\"Infinity\")",
    "engine->newArray() <=> QScriptValue(\"-Infinity\")",
    "engine->newArray() <=> QScriptValue(\"ciao\")",
    "engine->newArray() <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newArray() <=> QScriptValue(QString(\"0\"))",
    "engine->newArray() <=> QScriptValue(QString(\"123\"))",
    "engine->newArray() <=> QScriptValue(QString(\"12.4\"))",
    "engine->newArray() <=> QScriptValue(0, true)",
    "engine->newArray() <=> QScriptValue(0, int(122))",
    "engine->newArray() <=> QScriptValue(0, uint(124))",
    "engine->newArray() <=> QScriptValue(0, 123.0)",
    "engine->newArray() <=> QScriptValue(0, 6.37e-8)",
    "engine->newArray() <=> QScriptValue(0, 0x43211234)",
    "engine->newArray() <=> QScriptValue(0, 0x10000)",
    "engine->newArray() <=> QScriptValue(0, 0x10001)",
    "engine->newArray() <=> QScriptValue(0, qInf())",
    "engine->newArray() <=> QScriptValue(0, \"NaN\")",
    "engine->newArray() <=> QScriptValue(0, \"Infinity\")",
    "engine->newArray() <=> QScriptValue(0, \"-Infinity\")",
    "engine->newArray() <=> QScriptValue(0, \"ciao\")",
    "engine->newArray() <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newArray() <=> QScriptValue(0, QString(\"0\"))",
    "engine->newArray() <=> QScriptValue(0, QString(\"123\"))",
    "engine->newArray() <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->newArray() <=> QScriptValue(engine, true)",
    "engine->newArray() <=> QScriptValue(engine, int(122))",
    "engine->newArray() <=> QScriptValue(engine, uint(124))",
    "engine->newArray() <=> QScriptValue(engine, 123.0)",
    "engine->newArray() <=> QScriptValue(engine, 6.37e-8)",
    "engine->newArray() <=> QScriptValue(engine, 0x43211234)",
    "engine->newArray() <=> QScriptValue(engine, 0x10000)",
    "engine->newArray() <=> QScriptValue(engine, 0x10001)",
    "engine->newArray() <=> QScriptValue(engine, qInf())",
    "engine->newArray() <=> QScriptValue(engine, \"NaN\")",
    "engine->newArray() <=> QScriptValue(engine, \"Infinity\")",
    "engine->newArray() <=> QScriptValue(engine, \"-Infinity\")",
    "engine->newArray() <=> QScriptValue(engine, \"ciao\")",
    "engine->newArray() <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newArray() <=> QScriptValue(engine, QString(\"0\"))",
    "engine->newArray() <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newArray() <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->newArray() <=> engine->evaluate(\"Object.prototype\")",
    "engine->newArray() <=> engine->evaluate(\"Function.prototype\")",
    "engine->newArray() <=> engine->evaluate(\"Error.prototype\")",
    "engine->newArray() <=> engine->evaluate(\"Object\")",
    "engine->newArray() <=> engine->evaluate(\"Array\")",
    "engine->newArray() <=> engine->evaluate(\"Number\")",
    "engine->newArray() <=> engine->evaluate(\"Function\")",
    "engine->newArray() <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newArray() <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newArray() <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newArray() <=> engine->evaluate(\"/foo/\")",
    "engine->newArray() <=> engine->evaluate(\"new Object()\")",
    "engine->newArray() <=> engine->evaluate(\"new Error()\")",
    "engine->newArray() <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->newArray() <=> engine->evaluate(\"new Number(123)\")",
    "engine->newArray() <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->newArray() <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newArray() <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->newArray() <=> engine->evaluate(\"Undefined\")",
    "engine->newArray() <=> engine->evaluate(\"Null\")",
    "engine->newArray() <=> engine->evaluate(\"True\")",
    "engine->newArray() <=> engine->evaluate(\"False\")",
    "engine->newArray() <=> engine->evaluate(\"true\")",
    "engine->newArray() <=> engine->evaluate(\"122\")",
    "engine->newArray() <=> engine->evaluate(\"124\")",
    "engine->newArray() <=> engine->evaluate(\"123.0\")",
    "engine->newArray() <=> engine->evaluate(\"6.37e-8\")",
    "engine->newArray() <=> engine->evaluate(\"0x43211234\")",
    "engine->newArray() <=> engine->evaluate(\"0x10000\")",
    "engine->newArray() <=> engine->evaluate(\"0x10001\")",
    "engine->newArray() <=> engine->evaluate(\"Infinity\")",
    "engine->newArray() <=> engine->evaluate(\"'ciao'\")",
    "engine->newArray() <=> engine->evaluate(\"'0'\")",
    "engine->newArray() <=> engine->evaluate(\"'123'\")",
    "engine->newArray() <=> engine->evaluate(\"'12.4'\")",
    "engine->newArray() <=> engine->newObject()",
    "engine->newArray() <=> engine->newArray(10)",
    "engine->newArray() <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newArray() <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->newArray() <=> engine->newVariant(QVariant(123))",
    "engine->newArray() <=> engine->newQObject(engine)",
    "engine->newArray(10) <=> QScriptValue(\"NaN\")",
    "engine->newArray(10) <=> QScriptValue(\"Infinity\")",
    "engine->newArray(10) <=> QScriptValue(\"-Infinity\")",
    "engine->newArray(10) <=> QScriptValue(\"ciao\")",
    "engine->newArray(10) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newArray(10) <=> QScriptValue(QString(\"0\"))",
    "engine->newArray(10) <=> QScriptValue(QString(\"123\"))",
    "engine->newArray(10) <=> QScriptValue(QString(\"12.4\"))",
    "engine->newArray(10) <=> QScriptValue(0, \"NaN\")",
    "engine->newArray(10) <=> QScriptValue(0, \"Infinity\")",
    "engine->newArray(10) <=> QScriptValue(0, \"-Infinity\")",
    "engine->newArray(10) <=> QScriptValue(0, \"ciao\")",
    "engine->newArray(10) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newArray(10) <=> QScriptValue(0, QString(\"0\"))",
    "engine->newArray(10) <=> QScriptValue(0, QString(\"123\"))",
    "engine->newArray(10) <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->newArray(10) <=> QScriptValue(engine, \"NaN\")",
    "engine->newArray(10) <=> QScriptValue(engine, \"Infinity\")",
    "engine->newArray(10) <=> QScriptValue(engine, \"-Infinity\")",
    "engine->newArray(10) <=> QScriptValue(engine, \"ciao\")",
    "engine->newArray(10) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newArray(10) <=> QScriptValue(engine, QString(\"0\"))",
    "engine->newArray(10) <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newArray(10) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->newArray(10) <=> engine->evaluate(\"Object.prototype\")",
    "engine->newArray(10) <=> engine->evaluate(\"Function.prototype\")",
    "engine->newArray(10) <=> engine->evaluate(\"Error.prototype\")",
    "engine->newArray(10) <=> engine->evaluate(\"Object\")",
    "engine->newArray(10) <=> engine->evaluate(\"Array\")",
    "engine->newArray(10) <=> engine->evaluate(\"Number\")",
    "engine->newArray(10) <=> engine->evaluate(\"Function\")",
    "engine->newArray(10) <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newArray(10) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newArray(10) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newArray(10) <=> engine->evaluate(\"/foo/\")",
    "engine->newArray(10) <=> engine->evaluate(\"new Object()\")",
    "engine->newArray(10) <=> engine->evaluate(\"new Error()\")",
    "engine->newArray(10) <=> engine->evaluate(\"new RegExp('foo', 'gim')\")",
    "engine->newArray(10) <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newArray(10) <=> engine->evaluate(\"Undefined\")",
    "engine->newArray(10) <=> engine->evaluate(\"Null\")",
    "engine->newArray(10) <=> engine->evaluate(\"True\")",
    "engine->newArray(10) <=> engine->evaluate(\"False\")",
    "engine->newArray(10) <=> engine->evaluate(\"'ciao'\")",
    "engine->newArray(10) <=> engine->evaluate(\"'0'\")",
    "engine->newArray(10) <=> engine->evaluate(\"'123'\")",
    "engine->newArray(10) <=> engine->evaluate(\"'12.4'\")",
    "engine->newArray(10) <=> engine->newObject()",
    "engine->newArray(10) <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newArray(10) <=> engine->newRegExp(\"foo\", \"gim\")",
    "engine->newArray(10) <=> engine->newQObject(engine)",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(\"ciao\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(0, \"ciao\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(engine, \"ciao\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Function.prototype\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Object\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Array\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Number\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Function\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"'ciao'\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(\"NaN\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(\"Infinity\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(\"ciao\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(QString(\"0\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(QString(\"123\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(QString(\"12.4\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, \"NaN\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, \"Infinity\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, \"ciao\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, QString(\"0\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, QString(\"123\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, \"NaN\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, \"Infinity\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, \"ciao\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, QString(\"0\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Object.prototype\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Function.prototype\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Error.prototype\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Object\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Array\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Number\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Function\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"new Object()\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"new Error()\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Undefined\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Null\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"True\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"False\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"'ciao'\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"'0'\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"'123'\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"'12.4'\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->newObject()",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->newQMetaObject(&QObject::staticMetaObject)",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->newQObject(engine)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(uint(124))",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0x43211234)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0x10000)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0x10001)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(qInf())",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(\"Infinity\")",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, uint(124))",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, 0x43211234)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, 0x10000)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, 0x10001)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, qInf())",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(0, \"Infinity\")",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, uint(124))",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, 0x43211234)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, 0x10000)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, 0x10001)",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, qInf())",
    "engine->newVariant(QVariant(123)) <=> QScriptValue(engine, \"Infinity\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"124\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"0x43211234\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"0x10000\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"0x10001\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"Infinity\")",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(true)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(int(122))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(uint(124))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(123.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(6.37e-8)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0x43211234)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0x10000)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0x10001)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(qInf())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(\"Infinity\")",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(QString(\"123\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(QString(\"12.4\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, true)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, int(122))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, uint(124))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 123.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 6.37e-8)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 0x43211234)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 0x10000)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, 0x10001)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, qInf())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, \"Infinity\")",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, QString(\"123\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, true)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, int(122))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, uint(124))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 123.0)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 6.37e-8)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 0x43211234)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 0x10000)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, 0x10001)",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, qInf())",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, \"Infinity\")",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newVariant(QVariant(false)) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"new Number(123)\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"true\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"122\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"124\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"123.0\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"6.37e-8\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"0x43211234\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"0x10000\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"0x10001\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"Infinity\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"'123'\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"'12.4'\")",
    "engine->newVariant(QVariant(false)) <=> engine->newVariant(QVariant(123))",
    "engine->newQObject(0) <=> QScriptValue(true)",
    "engine->newQObject(0) <=> QScriptValue(int(122))",
    "engine->newQObject(0) <=> QScriptValue(uint(124))",
    "engine->newQObject(0) <=> QScriptValue(123.0)",
    "engine->newQObject(0) <=> QScriptValue(6.37e-8)",
    "engine->newQObject(0) <=> QScriptValue(0x43211234)",
    "engine->newQObject(0) <=> QScriptValue(0x10000)",
    "engine->newQObject(0) <=> QScriptValue(0x10001)",
    "engine->newQObject(0) <=> QScriptValue(qInf())",
    "engine->newQObject(0) <=> QScriptValue(\"Infinity\")",
    "engine->newQObject(0) <=> QScriptValue(QString(\"123\"))",
    "engine->newQObject(0) <=> QScriptValue(QString(\"12.4\"))",
    "engine->newQObject(0) <=> QScriptValue(0, true)",
    "engine->newQObject(0) <=> QScriptValue(0, int(122))",
    "engine->newQObject(0) <=> QScriptValue(0, uint(124))",
    "engine->newQObject(0) <=> QScriptValue(0, 123.0)",
    "engine->newQObject(0) <=> QScriptValue(0, 6.37e-8)",
    "engine->newQObject(0) <=> QScriptValue(0, 0x43211234)",
    "engine->newQObject(0) <=> QScriptValue(0, 0x10000)",
    "engine->newQObject(0) <=> QScriptValue(0, 0x10001)",
    "engine->newQObject(0) <=> QScriptValue(0, qInf())",
    "engine->newQObject(0) <=> QScriptValue(0, \"Infinity\")",
    "engine->newQObject(0) <=> QScriptValue(0, QString(\"123\"))",
    "engine->newQObject(0) <=> QScriptValue(0, QString(\"12.3\"))",
    "engine->newQObject(0) <=> QScriptValue(engine, true)",
    "engine->newQObject(0) <=> QScriptValue(engine, int(122))",
    "engine->newQObject(0) <=> QScriptValue(engine, uint(124))",
    "engine->newQObject(0) <=> QScriptValue(engine, 123.0)",
    "engine->newQObject(0) <=> QScriptValue(engine, 6.37e-8)",
    "engine->newQObject(0) <=> QScriptValue(engine, 0x43211234)",
    "engine->newQObject(0) <=> QScriptValue(engine, 0x10000)",
    "engine->newQObject(0) <=> QScriptValue(engine, 0x10001)",
    "engine->newQObject(0) <=> QScriptValue(engine, qInf())",
    "engine->newQObject(0) <=> QScriptValue(engine, \"Infinity\")",
    "engine->newQObject(0) <=> QScriptValue(engine, QString(\"123\"))",
    "engine->newQObject(0) <=> QScriptValue(engine, QString(\"1.23\"))",
    "engine->newQObject(0) <=> engine->evaluate(\"new Boolean(true)\")",
    "engine->newQObject(0) <=> engine->evaluate(\"new Number(123)\")",
    "engine->newQObject(0) <=> engine->evaluate(\"a = new Object(); a.foo = 22; a.foo\")",
    "engine->newQObject(0) <=> engine->evaluate(\"true\")",
    "engine->newQObject(0) <=> engine->evaluate(\"122\")",
    "engine->newQObject(0) <=> engine->evaluate(\"124\")",
    "engine->newQObject(0) <=> engine->evaluate(\"123.0\")",
    "engine->newQObject(0) <=> engine->evaluate(\"6.37e-8\")",
    "engine->newQObject(0) <=> engine->evaluate(\"0x43211234\")",
    "engine->newQObject(0) <=> engine->evaluate(\"0x10000\")",
    "engine->newQObject(0) <=> engine->evaluate(\"0x10001\")",
    "engine->newQObject(0) <=> engine->evaluate(\"Infinity\")",
    "engine->newQObject(0) <=> engine->evaluate(\"'123'\")",
    "engine->newQObject(0) <=> engine->evaluate(\"'12.4'\")",
    "engine->newQObject(0) <=> engine->newVariant(QVariant(123))",
    "engine->newQObject(engine) <=> QScriptValue(\"ciao\")",
    "engine->newQObject(engine) <=> QScriptValue(QString::fromLatin1(\"ciao\"))",
    "engine->newQObject(engine) <=> QScriptValue(0, \"ciao\")",
    "engine->newQObject(engine) <=> QScriptValue(0, QString::fromLatin1(\"ciao\"))",
    "engine->newQObject(engine) <=> QScriptValue(engine, \"ciao\")",
    "engine->newQObject(engine) <=> QScriptValue(engine, QString::fromLatin1(\"ciao\"))",
    "engine->newQObject(engine) <=> engine->evaluate(\"Object.prototype\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Function.prototype\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Object\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Array\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Number\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Function\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"(function() { return 1; })\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"(function() { return 'ciao'; })\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"(function() { throw new Error('foo'); })\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"new Object()\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"new String('ciao')\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Undefined\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Null\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"True\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"False\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"'ciao'\")",
    "engine->newQObject(engine) <=> engine->newObject()",
    "engine->newQObject(engine) <=> engine->newQMetaObject(&QObject::staticMetaObject)"};

void tst_QScriptValueGenerated::lessThan_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(5476);
        for (unsigned i = 0; i < 5476; ++i)
            equals.insert(lessThan_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValueGenerated::lessThan_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.lessThan(other), expected);
}

DEFINE_TEST_FUNCTION(lessThan)


void tst_QScriptValueGenerated::instanceOf_initData()
{
    QTest::addColumn<QScriptValue>("other");
    QTest::addColumn<bool>("expected");
    initScriptValues();
}

static QString instanceOf_array[] = {
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"[]\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"Date.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Error.prototype\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Object\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Array\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Number\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Function\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 1; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { return 'ciao'; })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"(function() { throw new Error('foo'); })\") <=> engine->evaluate(\"Function\")",
    "engine->evaluate(\"/foo/\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Object()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Array()\") <=> engine->evaluate(\"Array\")",
    "engine->evaluate(\"new Error()\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Boolean(true)\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Boolean(false)\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new Number(123)\") <=> engine->evaluate(\"Number\")",
    "engine->evaluate(\"new RegExp('foo', 'gim')\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"new String('ciao')\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Undefined\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"Null\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"True\") <=> engine->evaluate(\"Object\")",
    "engine->evaluate(\"False\") <=> engine->evaluate(\"Object\")",
    "engine->newObject() <=> engine->evaluate(\"Object\")",
    "engine->newArray() <=> engine->evaluate(\"Object\")",
    "engine->newArray() <=> engine->evaluate(\"Array\")",
    "engine->newArray(10) <=> engine->evaluate(\"Object\")",
    "engine->newArray(10) <=> engine->evaluate(\"Array\")",
    "engine->newDate(QDateTime()) <=> engine->evaluate(\"Object\")",
    "engine->newQMetaObject(&QObject::staticMetaObject) <=> engine->evaluate(\"Object\")",
    "engine->newRegExp(\"foo\", \"gim\") <=> engine->evaluate(\"Object\")",
    "engine->newVariant(QVariant()) <=> engine->evaluate(\"Object\")",
    "engine->newVariant(QVariant(123)) <=> engine->evaluate(\"Object\")",
    "engine->newVariant(QVariant(false)) <=> engine->evaluate(\"Object\")",
    "engine->newQObject(engine) <=> engine->evaluate(\"Object\")"};

void tst_QScriptValueGenerated::instanceOf_makeData(const char *expr)
{
    static QSet<QString> equals;
    if (equals.isEmpty()) {
        equals.reserve(47);
        for (unsigned i = 0; i < 47; ++i)
            equals.insert(instanceOf_array[i]);
    }
    QHash<QString, QScriptValue>::const_iterator it;
    for (it = m_values.constBegin(); it != m_values.constEnd(); ++it) {
        QString tag = QString::fromLatin1("%20 <=> %21").arg(expr).arg(it.key());
        newRow(tag.toLatin1()) << it.value() << equals.contains(tag);
    }
}

void tst_QScriptValueGenerated::instanceOf_test(const char *, const QScriptValue& value)
{
    QFETCH(QScriptValue, other);
    QFETCH(bool, expected);
    QCOMPARE(value.instanceOf(other), expected);
}

DEFINE_TEST_FUNCTION(instanceOf)
